<?php

namespace App\Http\Controllers;

use App\Models\Article_deletion_reasons;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class Manage_Reason_For_Deletion_Api extends Controller
{
    /*List all article deletion reasons
     commited date :- 02-01-2023
     Requested type :- POST
    */
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            DB::enableQueryLog();
            $sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'adel_id';
            $sort_order =  (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
            $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
            $result = Article_deletion_reasons::get_paginated_records('*', null, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Delete a article deletion reason from table
     commited date :- 02-01-2023
     Requested type :- POST
    */
    public function remove_delete_reason(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'adel_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $delete_reason_id = $this->decrypt_data($request->adel_id);
            $criteria = 'adel_id="' . $delete_reason_id . '"';
            $result = Article_deletion_reasons::delete_records($criteria, '', $current_user);
            $message = customTrans('reasonfordeletion.delete_reason_removed_success');
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Add / Update a article deletion reason 
     commited date :- 02-01-2023
     Requested type :- POST
    */
    public function save_delete_reason(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $form_data = $request->all();
            if ($form_data['edit_id'] != '') {
                $validator = Validator::make($request->all(), [
                    'reason' => 'required',
                ]);
            } else {
                $validator = Validator::make($request->all(), [
                    'reason' => 'required|unique:rvw_article_delete_reasons,adel_reason',
                ]);
            }
            if ($validator->fails()) {
                return $this->failure('Failed', 200, customTrans('reasonfordeletion.duplicate_err'));
            }
            $reason_array = array(
                'adel_reason' => $form_data['reason'],
            );
            if (isset($form_data['edit_id']) && $form_data['edit_id'] != '') {
                $reason_id = $this->decrypt_data($form_data['edit_id']);
                $condition = 'adel_id=' . $reason_id;
                $result = Article_deletion_reasons::get_single_record('count(adel_id) as count', $condition);
                if ($result->count > 0) {
                    $updatedata = Article_deletion_reasons::update_record($reason_array, $condition, $current_user);
                }
                $message = customTrans('reasonfordeletion.delete_reason_update_success');
                return $this->success($message, 200, $updatedata);
            } else {
                $result = Article_deletion_reasons::insert_record($reason_array, $current_user);
                $message = customTrans('reasonfordeletion.delete_reason_saved_success');
                return $this->success($message, 200, $result);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
}
