<?php

namespace App\Http\Controllers;

use App\Models\Reject_reasons;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class Manage_Reason_For_Rejection_Api extends Controller
{
    /*List all reason for reasons
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            DB::enableQueryLog();
            $sort_field = (isset($form_data['sort_field'])) ? $form_data['sort_field'] : 'rjct_id';
            $sort_order =  (isset($form_data['sort_order'])) ? $form_data['sort_order'] : 'asc';
            $limit = (isset($form_data['per_page'])) ? $form_data['per_page'] : 10;
            $result = Reject_reasons::get_paginated_records('*', NULL, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Delete a reject reason  from table
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function delete_reject_reason(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'rjct_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $reject_reason_id = $this->decrypt_data($request->rjct_id);
            $criteria = 'rjct_id="' . $reject_reason_id . '"';
            $result = Reject_reasons::delete_records($criteria, '', $current_user);
            $message = customTrans('reasonforrejection.reject_reason_removed_success');
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Add / Update a reject reason 
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function save_reject_reason(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $form_data = $request->all();
            $roleName = ($form_data['reject_applicable'] == 'y') ? 'i':'y';
            if ($form_data['edit_id'] != '') {
                $validator = Validator::make($request->all(), [
                    'reject_applicable' => 'required',
                    'reject_reason' => 'required',
                ]);
            } else {
                $validator = Validator::make($request->all(), [
                    'reject_applicable' => 'required',
                    'reject_reason' => 'required|unique:rvw_review_reject_reasons,rjct_reason,'.$roleName.',rjct_reason_reviewers',
                ]);
            }
            // $validator = Validator::make($request->all(), [
            //     'reject_reason' => 'required|unique:rvw_review_reject_reasons,rjct_reason',
            // ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 200, customTrans('reasonforrejection.duplicate_err'));
            }
            $reason_array = [];

            $reason_array['rjct_reason'] = $form_data['reject_reason'];
            $reason_array['rjct_reason_reviewers'] =  (isset($form_data['reject_applicable']) && $form_data['reject_applicable'] == 'y') ? 'y' : ((isset($form_data['reject_applicable']) && $form_data['reject_applicable'] == 'i') ? 'i' : 'n');
            $reason_array['rjct_suggest_flag'] =  (isset($form_data['suggest_flag']) && $form_data['suggest_flag'] == 'y') ? 'y' : 'n';
            $reason_array['rjct_reinvite_flag'] =   (isset($form_data['reinvite_flag']) && $form_data['reinvite_flag'] == 'y') ? 'y' : 'n';
            
            if ($form_data['edit_id'] != '') {

                $reason_id = $this->decrypt_data($form_data['edit_id']);
                $condition= "rjct_reason='".$reason_array['rjct_reason']."' and rjct_reason_reviewers='".$reason_array['rjct_reason_reviewers']."' and rjct_reinvite_flag='".$reason_array['rjct_reinvite_flag']."' and rjct_suggest_flag='".$reason_array['rjct_suggest_flag']."' and rjct_id !=".$reason_id;
			    $existence = Reject_reasons::get_single_record("rjct_id",$condition);
                if(empty($existence))
                {
                    $condition="rjct_id=".$reason_id;
                    $updatedata = Reject_reasons::update_record($reason_array, $condition, $current_user);
                    $message = customTrans('reasonforrejection.reject_reason_update_success');
                    return $this->success($message, 200, $updatedata);
                }
                else{
                    return $this->failure('Failed', 200, customTrans('reasonforrejection.duplicate_err'));
                }
                /*$condition = 'rjct_id=' . $reason_id;
                $result = Reject_reasons::get_single_record('count(rjct_id) as count', $condition);
                if ($result->count > 0) {
                    $updatedata = Reject_reasons::update_record($reason_array, $condition, $current_user);
                }
                $message = customTrans('reasonforrejection.reject_reason_update_success');
                return $this->success($message, 200, $updatedata);*/
            } else {
                $result = Reject_reasons::insert_record($reason_array, $current_user);
                $message = customTrans('reasonforrejection.reject_reason_saved_success');
                return $this->success($message, 200, $result);
                // print_r($reason_array);
            }
        } catch (\Exception $e) {
   
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*Delete a reject reason  from table
     commited date :- 03-01-2023
     Requested type :- POST
    */
    public function change_reject_reason_status(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'rjct_id' => 'required',
                'rjct_status' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $reject_reason_id = $this->decrypt_data($request->rjct_id);
            $criteria = "rjct_id={$reject_reason_id}";
            $update_data = array(
                'rjct_inactive' => $request->rjct_status
            );
            $result = Reject_reasons::update_record($update_data, $criteria);
            $message = 'Success';
            return $this->success($message, 200, $result);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
}
