<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\User;
use App\Models\Country;
use App\Models\Flags;
use App\Models\User_affiliations;
use App\Models\User_global_flags;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use App\Http\Traits\General_ConfigTraits;
use App\Jobs\SendEmailJob;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendEmail;
use App\Models\Email_templates;
use App\Models\Authors;
use App\Models\Article_flow;
use App\Models\Article_status_link_statistics;
use App\Models\Article_types;
use App\Models\Generic_flows;
use App\Models\Journal_permission;
use App\Models\Journals;
use App\Models\User_unregister;
use App\Models\Primary_email;
use App\Models\Roles;
use Jenssegers\Agent\Facades\Agent;
use Illuminate\Support\Facades\Storage;
use Mockery\Undefined;
use \stdClass;
use DateTime;

class Manage_Register_Api extends Controller
{
    use StandaloneDataTrait;
    use GeneralEmailTrait;
    use SendGlobalEmailFunctionTrait;

    public function save_user_registration(Request $request)
    {
        try {
            DB::beginTransaction();
            $form_data = $request->all();
            $form_data['password']=$this->decrypt_data($form_data['password']);
            $generic_data=[];
            $cc_object_array_check = array();
            $cc_data_check = [];
            $formid = isset($form_data['form_id']) && ($form_data['form_id']) !=''?decrypt_link($form_data['form_id']):'';
            $form_data['form_id']=isset($form_data['form_id']) && ($form_data['form_id']) !=''?decrypt_link($form_data['form_id']):'';
            $validation_response=$this->validateInput($form_data);
            if ($validation_response &&($validation_response['status']=='error')) {
                return  $this->warning('Failed', 200, $validation_response);
            }
            $ethnicityarray=[];
            $racearray=[];
            $gender=null;
            $ethnicity_val=null;
            $race_val=null;
            $terms_condition='n';
            $cfty_gender_race_ethnicity=$form_data['cfty_gender_race_ethnicity'];
            $cfty_show_terms_conditions=$form_data['cfty_show_terms_conditions'];
            $cs_tbl = new \App\Models\Client_settings();
            $client_settings= $cs_tbl::get_client_settings_using_client_code('cs_show_reg_feedback_frm', $this->current_client->clnt_client_code);
            $return_array['cs_show_reg_feedback_frm']=$client_settings[0]->cs_show_reg_feedback_frm;

            if(isset($return_array['cs_show_reg_feedback_frm']) && $return_array['cs_show_reg_feedback_frm']=='y')
            {
                foreach ( $form_data as $val=>$values) {

                    if(strpos($val, "form_") !== false && $val !== 'form_id'){
                        $ind_val = explode('_',$val);
                        $generic_data['form_'.$formid]['ctrl_'.$ind_val[2]] = $form_data[$val];
                    }
                }

            }
            $return_array = array();

            if($form_data['confirmpassword'] != $form_data['password'])
            {
                return  $this->warning('Failed', 200,'Passwords must match');
            }
            if($form_data['confirmpassword'] != $form_data['password'])
            {
                return  $this->warning('Failed', 200,'Passwords must match');
            }
            $user_id='';
            $email='';
            $emaildata='';
            if(isset($form_data['username']))
            {
                $criteria =array('usr_username'=>$form_data['username']);
                $check_username = User::get_single_record_with_bind_cond('count(usr_id) as cnt', $criteria);
                if($check_username->cnt > 0)
                {
                    return  $this->warning('Failed', 200,'Username Already Exist');
                }
            }
            if(isset($form_data['email']))
            {
                $user_exist_email= $this->check_email($form_data['email'],$user_id,'',$emaildata);
                if(isset( $user_exist_email)&& ($user_exist_email==true))
                {
                    return  $this->warning('Failed', 200,'Email Already Exist');
                }
            }
            if(isset($form_data['cc_email'])&&isset($form_data['cc_email'][0]))
                {
                foreach ($form_data['cc_email'] as $keys => $mail) {
                    if ($mail != "") {
                        if($mail == $form_data['email'])
                        {
                            return  $this->warning('Failed', 200,'Alternative email should not be the same as primary email');
                        }
                        $cc_data_check['uml_email'] = $mail;
                        if( in_array($cc_data_check['uml_email'],$cc_object_array_check)){
                            return  $this->warning('Failed', 200,'Duplicate alternative mail found');
                        }
                        else
                        {
                            array_push($cc_object_array_check, $cc_data_check['uml_email']);
                        }
                    }
                }
            }

            if($cfty_gender_race_ethnicity=='y') {
                $gender=$form_data['gender'];
                $ethnicity=implode(',',$form_data['ethnicity']);
                $ethnicityarray['opt_val'] = $ethnicity;
                if(in_array('s',$form_data['ethnicity'])){
                    $ethnicity_selfdescribe=$form_data['ethnicity_selfdescribe'];
                    $ethnicityarray['selfdescribe'] = $ethnicity_selfdescribe;
                }
                $race=implode(',',$form_data['race']);
                $racearray['opt_val'] = $race;
                if(in_array('s',$form_data['race'])){
                    $race_selfdescribe=$form_data['race_selfdescribe'];
                    $racearray['selfdescribe'] = $race_selfdescribe;
                }

                $ethnicity_val=json_encode($ethnicityarray);
                $race_val=json_encode($racearray);

            }

            if($cfty_show_terms_conditions=='y') {
                $terms_condition=$form_data['terms'];
            }

            $usr_dnd = (isset($form_data['usr_dnd'])) ? $form_data['usr_dnd'] : 'n';
            $usr_jnl_standalone = null;
            $stdgrp = $this->get_standalone_journal_data();
            if ($stdgrp != null)
                $usr_jnl_standalone = $stdgrp->jnl_id;
            $user_email = $form_data['email'];
            $current_date_time = date('Y-m-d H:i:s');
            $activation_url = md5($user_email . '' . $current_date_time);
            $password = Hash::make($form_data['password']);


            $data = array(
                'usr_username' => $form_data['username'],
                'usr_pwd' => $password,
                'usr_pwd_original' => '',
                'usr_title' => $form_data['title'],
                'usr_first_name' => $form_data['firstname'],
                'usr_middle_name' => $form_data['middlename'],
                'usr_last_name' => $form_data['lastname'],
                'usr_email' => $form_data['email'],
                'usr_phone_no' => $form_data['phonenumber'],
                'usr_website' => $form_data['website'],
                'usr_status' => 'w',
                'usr_jnl_standalone' => $usr_jnl_standalone,
                'usr_dnd' => $usr_dnd,
                'usr_registered' => 'y',
                'usr_url' => $activation_url,
                'usr_posted_date' => date('Y-m-d H:i:s'),
                'usr_proxy_id' =>  0,
                'usr_gender' =>  $gender,
                'usr_ethnicity' =>  $ethnicity_val,
                'usr_race' =>  $race_val,
                'usr_terms_condition' => $terms_condition
            );
            if(isset($form_data['sourcedata']) && !empty($form_data['sourcedata']))
            {
                $data['usr_source']=$form_data['sourcedata'];
            }
            $user_id = User::insert_record($data);
            $User_emails = new \App\Models\User_emails();
            $cc_object_array = array();
            $cc_data = [];
            if(isset($form_data['cc_email'])&&isset($form_data['cc_email'][0]))
            {
                foreach ($form_data['cc_email'] as $keys => $mail) {
                    if ($mail != "") {
                        $cc_data['uml_user_id'] = $user_id;
                        $cc_data['uml_email'] = $mail;
                        $cc_data['uml_status'] = 'w';
                        $cc_data['uml_posted_by'] = $user_id;
                        array_push($cc_object_array, $cc_data['uml_email']);
                        $User_emails::insert_record($cc_data);
                    }
                }
            }
            if ($user_id != NULL) {
                $userdata = array(
                    'user_id' => $user_id,
                    'proxy_user_id' => 0,
                );
                $this->update_password_history($password, $user_id, $userdata);
                $aff_data = $this->add_user_affiliation($form_data, $user_id, TRUE);
                /*Feedback form start */
                //save all generic forms
                 if (isset($form_data )) {
                    //Customisation #1345 : Update user table with DND
                    $clnt_generic_form_identifier = NULL;
                if(!empty($generic_data)) {
                        foreach ($generic_data as $key => $val) {
                            
                            $formid = explode("_", $key);
                            $formid = end($formid);
                            $customformdata = $val;
                            $this->save_generic_forms($user_id , $formid, $customformdata, $clnt_generic_form_identifier);
                            // }
                        }
                    }
                }
                $key = Str::random(10);
                $ecncrypt_user_data=$this->encrypt_data('&userid=' . $user_id . '&datetime=' . date("Y-m-d H:i:s").'&key=' . $key );
                $usr_data = array(
                    'userid' => $user_id,
                    'datetime' => date("Y-m-d H:i:s"),
                    'key' => $key
                );
                $encrypt_deeplink_user_data=$this->encrypt_data(json_encode($usr_data));
                $usr_criteria = "usr_id = {$user_id}";
                $update_arr = array('usr_deeplink_token' => $encrypt_deeplink_user_data); //TASK #2702  old email in not expiring (SA add user) revert
                $current_user['user_id'] =  $current_user['proxy_user_id'] = $user_id;
                User::update_record($update_arr, $usr_criteria, $current_user);
                $reset_link =  URL::to('/') . '/reset-password?' . $ecncrypt_user_data;

                /*Feedback form end */
                $user_data_info = array(
                    'user_password' => $form_data['password'],
                    'activation_url' => URL::to('/') . '/confirmation_register/' . $activation_url, //TASK #2702  old email in not expiring (SA add user) revert
                    'reset_link'=>$reset_link,
                    'user_id' => $user_id
                );
                $this->send_email_confirmation($user_data_info);
                $return_array['user_id'] = $this->encrypt_data($user_id);
            }
            DB::commit();
            return $this->success('success', 201, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function new_confirm_mail_change(Request $request)
    {
        try{
            $return_array = array();
            $post_data=$request->all();
            $return_array['user_active']=false;
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            if($post_data['select']!=NULL)
            {
                $usr_id=isset($_GET['id']) ? $_GET['id'] : '';
                $verify_url=isset($_GET['token']) ? $_GET['token'] : '';
                $user_cnfrm = User::get_single_record_with_bind_cond('*', array(
                    'usr_url' => $verify_url,'usr_id'=>decrypt_link($usr_id)));

                    if ($user_cnfrm != null && $user_cnfrm->usr_status == 'a' ) {
                        $current_user['proxy_user_id'] = NULL;
                        $current_user['user_id'] = $user_cnfrm->usr_id;
                        $user_id=$user_cnfrm->usr_id;
                        $user_email=$user_cnfrm->usr_email;
                          $updatedata['cpe_new_email_verify']='y';
                                  $condition = array(
                                    'cpe_usr_id' => $user_id);

                         Primary_email::update_record($updatedata, $condition);
                         $user_det = Primary_email::get_single_record_with_bind_cond('*', array(
                            'cpe_usr_id' =>$user_id));
                            $old_verification_email_status=$user_det->cpe_old_email_verify;
                            $new_verfication_email_status=$user_det->cpe_new_email_verify;
                            if($old_verification_email_status=='y'&&$new_verfication_email_status=='y')
                            {
                                $email = $user_det->cpe_new_email_id;
                                $old_email = $user_cnfrm->usr_email;
                                // Users::trans_start();
                                /*
                                $login_session = $this->session->userdata('logged_user');
                                if ($login_session != NULL) {
                                    if ($login_session['user_id'] != $user_cnfrm->usr_id)
                                        $this->session->unset_userdata('logged_user');
                                }
                                */
                                Primary_email::update_record(array(
                                    'cpe_verification_uri' => NULL), array(
                                    'cpe_usr_id' => $user_cnfrm->usr_id));
                                User::update_record(array(
                                    'usr_url' => NULL,
                                    'usr_email' => $email), array(
                                    'usr_id' => $user_cnfrm->usr_id));
                                    $data['user_cnfrm'] = $user_cnfrm;
                                    $user_cnfrm->usr_email = $email;
                                    // $login_session = $this->set_login_session_data($user_cnfrm);
                                    // $this->set_user_session_data($login_session, TRUE);
                                    $record = Email_templates::get_single_record_with_bind_cond('*', array(
                                        'etmp_name' => 'primary_email_changed',
                                        'etmp_notification' => 'User'));
                                if ($record != NULL) {
                                    $email_data = new stdClass;
                                    $email_data->user_id = $user_cnfrm->usr_id;
                                    $email_data->user_id = $user_cnfrm->usr_id;
                                    //$email_data->new_primary_email = $email;
                                    $email_data->user_email = $old_email;
                                    $email_data->mail_recipient_ids = $user_cnfrm->usr_id;
                                    $email_data->email_templates_config = $this->email_templates_config();
                                    $email_data->join_config = $this->join_config();
                                    $email_data->join_dependency_config = $this->join_dependency_config();
                                    $email_data->user_role_tags = $this->user_role_tags();
                                    $email_config = 'clients.' . $this->current_client->clnt_client_code;
                                    $email_config_data = Config::get($email_config . '.email');
                                    $email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];
                                    $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                                    if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

                                    if (isset($record->etmp_email_template) && strpos($record->etmp_email_template,"OPENING_PARAGRAPH") > 0)
                                    $record->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$record->etmp_email_template);
                                    /*
                                    $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
                                    $email_data->core_role = $core_role;
                                    $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                                    $email_data->core_role_name = $core_role_name;
                                    */
                                    $data_array = array(
                                        'record' => $record,
                                        'email_data' => $email_data,
                                        'user_data' =>$current_user,
                                        'column_prefix' =>'etmp_',
                                    );
                                    $this->notify_mail($data_array);
                                    $return_array['user_active']=true;
                                    // $return_array['msg'] = customTrans('users.confrm_failed')
                                }
                                if($return_array['user_active']==true)
                                    {
                                        // $flash_message = str_replace('REPLACE', '<span style = "color: #d4cb3e;font-weight:bold;">' . $email . '</span>', lang('email_change_success'));
                                        $return_array['msg'] = "confirm success";
                                        $return_array['msgs'] = "You have successfully verified  " .$email. "  as your primary email.";
                                        if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                                        {
                                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                                            $es_api_data  = Config::get($es_config);
                                            if(isset($es_api_data['primary_email_change']))
                                            {
                                                $apiUrl = $es_api_data['primary_email_change'];
                                                $query_string = 'user_id='.$user_cnfrm->usr_id.'&email='.$email;
                                                $encrypted_string = Rv_encrypt($query_string);
                                                $pass_data = array('encryptedData' => $encrypted_string);
                                                $response = $this->es_curl_request($apiUrl,$pass_data);
                                                $response = json_decode($response);
                                            }
                                        }
                                    }
                                }
                                    else {
                                        // $return_array['msg'] = customTrans('users.primary_email_updated_notification');
                                        $return_array['msg'] = customTrans('users.primary_email_verified_from_updated_notification');
                                        }

                    }
                    else {
                        // $return_array['msg'] = customTrans('users.prime_email_change_failed');
                        $return_array['msg'] = customTrans('users.prime_email_change_verify_failed');
                    }
            }
            return $this->success('success', 201, $return_array);
        }
        catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }
    public function verify_user_confirmation(Request $request)
    {
        try{
            $return_array = array();
            $post_data=$request->all();
            $return_array['user_active']=false;
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            if($post_data['select']!=NULL)
            {
                $usr_id=isset($_GET['id']) ? $_GET['id'] : '';
                $verify_url=isset($_GET['token']) ? $_GET['token'] : '';
                $user_det = Primary_email::get_single_record_with_bind_cond('*', array(
                    'cpe_verification_uri' => $verify_url,'cpe_usr_id'=>decrypt_link($usr_id)));
                    if($user_det!=null)
                    {
                        $user_id=$user_det->cpe_usr_id;
                        $user_email=$user_det->cpe_new_email_id;
                        $verification_uri=$user_det->cpe_verification_uri;
                        $updatedata['cpe_old_email_verify']='y';
                                $condition = array(
                                  'cpe_usr_id' => $user_id);


                       $update_status=Primary_email::update_record($updatedata, $condition);
                       $user_cnfrm = User::get_single_record_with_bind_cond('*', array(
                          'usr_id' =>$user_id));
                       $new_primary_info=Primary_email::get_single_record_with_bind_cond('*', array(
                          'cpe_usr_id' =>$user_id));
                       $old_verification_email_status=$new_primary_info->cpe_old_email_verify;
                       $new_verfication_email_status=$new_primary_info->cpe_new_email_verify;


                       if($old_verification_email_status=='y'&&$new_verfication_email_status=='y')
                       {


                       if ($user_cnfrm != null && $user_cnfrm->usr_status == 'a') {
                        $current_user['proxy_user_id'] = NULL;
                        $current_user['user_id'] = $user_cnfrm->usr_id;
                          $email =$user_email;
                           Primary_email::update_record(array(
                              'cpe_verification_uri' => NULL), array(
                              'cpe_usr_id' => $user_cnfrm->usr_id));
                        //   Users::trans_start();
                        /*
                          $login_session = $this->session->userdata('logged_user');
                          if ($login_session != NULL) {
                              if ($login_session['user_id'] != $user_cnfrm->usr_id)
                                  $this->session->unset_userdata('logged_user');
                          }
                            */
                          User::update_record(array(
                              'usr_url' => NULL,
                              'usr_email' => $email), array(
                              'usr_id' => $user_cnfrm->usr_id));

                          $data['user_cnfrm'] = $user_cnfrm;
                          $user_cnfrm->usr_email = $email;
                          $record = Email_templates::get_single_record_with_bind_cond('*', array(
                              'etmp_name' => 'primary_email_changed',
                              'etmp_notification' => 'User'));
                          if ($record != NULL) {
                              $email_data = new stdClass;
                              $email_data->user_id = $user_cnfrm->usr_id;
                              //$email_data->new_primary_email = $email;
                              $email_data->user_email = $email;
                              $email_data->mail_recipient_ids = $user_cnfrm->usr_id;
                              $email_data->email_templates_config = $this->email_templates_config();
                              $email_data->join_config = $this->join_config();
                              $email_data->join_dependency_config = $this->join_dependency_config();
                              $email_data->user_role_tags = $this->user_role_tags();
                              $email_config = 'clients.' . $this->current_client->clnt_client_code;
                              $email_config_data = Config::get($email_config . '.email');
                              $email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];
                              $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                              if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                                  $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

                              if (isset($record->etmp_email_template) && strpos($record->etmp_email_template,"OPENING_PARAGRAPH") > 0)
                              $record->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$record->etmp_email_template);
                              /*
                              $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
                              $email_data->core_role = $core_role;
                              $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                              $email_data->core_role_name = $core_role_name;
                              */
                            $data_array = array(
                                'record' => $record,
                                'email_data' => $email_data,
                                'user_data' =>$current_user,
                                'column_prefix' =>'etmp_',
                            );
                            $this->notify_mail($data_array);
                            $return_array['user_active']=true;
                          }
                          if($return_array['user_active']==true)
                          {
                              // $flash_message = str_replace('REPLACE', '<span style = "color: #d4cb3e;font-weight:bold;">' . $email . '</span>', lang('email_change_success'));
                              $return_array['msgs'] = "You have successfully verified  " .$email. "  as your primary email.";
                              $return_array['msg'] = "confirm success";
                              if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                              {
                                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                                $es_api_data  = Config::get($es_config);
                                if(isset($es_api_data['primary_email_change']))
                                {
                                    $apiUrl = $es_api_data['primary_email_change'];
                                    $query_string = 'user_id='.$user_id.'&email='.$email;
                                    $encrypted_string = Rv_encrypt($query_string);
                                    $pass_data = array('encryptedData' => $encrypted_string);
                                    $response = $this->es_curl_request($apiUrl,$pass_data);
                                    $response = json_decode($response);
                                }
                              }
                          }
                      }
                       else {
                        $return_array['msg'] = customTrans('users.prime_email_change_failed');
                        }

                       }
                       else {
                        $return_array['msg'] = customTrans('users.primary_email_updated_notification');
                    }
                    }
                    else
                    {
                        // $return_array['msg'] = customTrans('users.prime_email_change_failed');
                        $return_array['msg'] = customTrans('users.prime_email_change_verify_failed');
                    }
            }
            return $this->success('success', 201, $return_array);
        }
        catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function revert_primary_mail_change(Request $request)
    {
        try{
            $return_array = array();
            $post_data=$request->all();
            $return_array['user_active']=false;
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            if($post_data['select']!=NULL)
            {
                $usr_id=isset($_GET['id']) ? $_GET['id'] : '';
                $verify_url=isset($_GET['token']) ? $_GET['token'] : '';
                $user_det = Primary_email::get_single_record_with_bind_cond('*', array(
                    'cpe_verification_uri' => $verify_url,'cpe_usr_id'=>decrypt_link($usr_id)));

                $user_id=$user_det->cpe_usr_id;
                $old_email_id_status=$user_det->cpe_old_email_verify;
                $updated_email_id_status=$user_det->cpe_new_email_verify;
                if($old_email_id_status!='y'&&!empty($user_det))
                {
                Primary_email::delete_records(array('cpe_usr_id' => $user_id));
                 User::update_record(array(
                        'usr_url' => NULL),array('usr_id' =>$user_id));
                $return_array['msg'] = customTrans('users.revert_email');
               }
                else {
                    $return_array['msg'] = customTrans('users.revert_email_error');
                  }

            }
            return $this->success('success', 201, $return_array);
        }
    catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }

    }
    public function checkuserStatus(Request $request)
    {
        try {
                $post_data = $request->all();
                $awaiting_flag=false;
                if(isset($post_data['segment']) && $post_data['segment']=='awaiting-confirm-mail')
                {
                    $awaiting_flag=true;
                }
                $user_url=$post_data['user_url'];
                if($request->segment(2) !='confirmation_register' ||  $awaiting_flag==true){
                    parse_str(decrypt_link($post_data['user_url']), $data); //TASK #2702 old email in not expiring (SA add user) revert
                if(isset($data['name'])&& ($data['name']=='coauthor_account_creation')){
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_id='{$data['userid']}' AND usr_status='w'");
                }
                elseif(isset($data['name'])&& $data['name']=='add_user_confirmation'){
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_id='{$data['userid']}' AND usr_status in('w','a','n')");
                    if(isset($user_cnfrm->usr_deeplink_token) && isset($data['key']) && $user_cnfrm->usr_deeplink_token !=$data['key']){
                        return response()->json(['responsecode' => 422,'message'=>'Unauthorized User','success'=>false]);
                    }
                }
                elseif($awaiting_flag==true)
                {

                    if(isset($data['userid']) && $data['userid'] !='' && isset($data['usr_url']) && $data['usr_url'] !='') //TASK #2702 old email in not expiring (SA add user) revert
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_id='{$data['userid']}' AND usr_url='{$data['usr_url']}' ");
                    elseif(isset($data['key']) &&$data['key'] !='')
                    {
                    $criteria=array('usr_deeplink_token'=>"{$data['key']}");
                    $user_cnfrm = User::get_single_record_with_bind_cond('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', $criteria);
                    }

                }
                else{
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_url='{$user_url}'"); //TASK #2702 old email in not expiring (SA add user) revert
                }
                }
                else{
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_url='{$user_url}'");
                }

                if ($user_cnfrm != NULL) {
                    $return_array['user_status']=$user_cnfrm->usr_status;
                    $return_array['user_active']=false;
                }
                else
                {
                    $return_array['user_active']=true;
                    $return_array['msg'] = customTrans('users.confrm_failed');
                }
                return $this->success('success', 201, $return_array);
            } catch (\Exception $e) {
                return  $this->failure('Failed', 500, $e);
            }
    }
    public function user_confirmation(Request $request)
    {
        try {
            $post_data = $request->all();
            $awaiting_flag=false;
            if(isset($post_data['segment']) && $post_data['segment']=='awaiting-confirm-mail')
            {
                $awaiting_flag=true;
            }
            $user_url = $post_data['user_url'];
            if($request->segment(2) !='confirmation_register'){
                parse_str(decrypt_link($post_data['user_url']), $data);
            if(isset($data['name'])&& ($data['name']=='coauthor_account_creation')){
                $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_id='{$data['userid']}' AND usr_status='w'");
            }
            elseif(isset($data['name'])&& $data['name']=='add_user_confirmation'){
                $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_id='{$data['userid']}' AND usr_status in('w','a','n')");
                if(isset($user_cnfrm->usr_deeplink_token) && isset($data['key']) && $user_cnfrm->usr_deeplink_token !=$data['key']){
                    return response()->json(['responsecode' => 422,'message'=>'Unauthorized User','success'=>false]);
                }
            }
            elseif($awaiting_flag==true)
                {
                    if(isset($data['userid']) && $data['userid'] !='' && isset($data['usr_url']) && $data['usr_url'] !='') //TASK #2702 old email in not expiring (SA add user) revert
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_registered,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_id='{$data['userid']}' AND usr_url='{$data['usr_url']}' "); //TASK #2702 old email in not expiring (SA add user) revert & TASK #4265
                    else
                    $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_registered,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_deeplink_token='{$data['key']}'"); //TASK #2702 old email in not expiring (SA add user) revert & TASK #4265
            }
            else{
                $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_registered,usr_last_name,usr_status,usr_deeplink_token,usr_url', "usr_url='{$user_url}'"); //TASK #2702 old email in not expiring (SA add user) revert & TASK #4265
            }
            }
            else{
                $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,usr_deeplink_token,usr_registered,usr_url', "usr_url='{$user_url}'"); //TASK #2702 old email in not expiring (SA add user) revert & TASK #4265
            }
            $return_array['user_data'] = '';
            $return_array['user_active'] = TRUE;
            $return_array['user_data'] = $user_cnfrm;
            if ($user_cnfrm != NULL) {

                $current_date_time = date('Y-m-d H:i:s');
                //#415 BUG Empty "Account created date" in user info
                User::update_record(array('usr_reg_date' => $current_date_time), "usr_id={$user_cnfrm->usr_id}");

                // $this->check_standalone_url($user_cnfrm->usr_id);
                $current_user = array(
                    'user_id' => $user_cnfrm->usr_id,
                    'proxy_user_id' => $user_cnfrm->usr_id
                );
                DB::beginTransaction();
                if(isset($data['name'])&&($data['name']=='add_user_confirmation' ||$data['name']=='coauthor_account_creation'))
                    $send_mail = $this->create_user_email($user_cnfrm, $current_user);
                $this->confirm_registered_user($user_cnfrm, $current_user, 'url');
                DB::commit();
                if($awaiting_flag==true && $user_cnfrm->usr_registered=='n') //TASK #4265 Password automatically changing in db after confirming resend mail
                {
                    $send_mail = $this->create_user_email($user_cnfrm, $current_user);
                }
                $return_array['user_active'] = FALSE;
            } else {
                // $this->session->set_flashdata('msg_error', lang('confrm_failed'));
                $return_array['msg'] = customTrans('users.confrm_failed');
            }
            return $this->success('success', 201, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function accept_usr_agreement_form(Request $request)
    {
        try {
            $post_data = $request->all();
            $user_url = $post_data['user_url'];
            parse_str(decrypt_link($post_data['user_url']), $data);

            if(isset($data))
            {
                $user_details = array(
                    'usr_terms_condition' => 'y'
                );
                $usr_result = User::update_record($user_details, "usr_id={$data['userid']}");
                if (isset( $usr_result) && $usr_result ==true)
			    {
                $site_url= $this->confirm_mail_terms($data);
                }
            }
            return $this->success('success', 201, 'success');

        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function confirm_mail_terms($data)
    {
            $site_url=URL::to('/');
            $current_date_time = date('Y-m-d H:i:s');
            // $criteria="usrs_id={$data['userid']} AND usr_deeplink_token={$data['key']}";
            $criteria="usr_id={$data['userid']}";

            $user_record = User::get_single_record('*', $criteria);

            // $this->check_standalone_url($this->session->userdata('userId'));
            if ($user_record != NULL && ($user_record->usr_status == 'w' || $user_record->usr_status == 'a')) {
				//#370 BUG Empty "Account created date" in user info
			User::update_record(array('usr_reg_date'=>$current_date_time), $criteria);
            $current_user = array(
                'user_id' => $user_record->usr_id,
                'proxy_user_id' => $user_record->usr_id);
                $send_mail = $this->create_user_email($user_record, $current_user);


                //#660 if jnl code is found in the url, redirect to that journal
                // if(isset($_GET['jnl_code']) && $_GET['jnl_code'] != '') {
                //     $site_url  =   base_url() . '/journal/' . $_GET['jnl_code'];
                // }
                return $site_url;

            } else {

                return $site_url;
            }

    }
    public function user_cc_confirmation(Request $request)
    {

        try {
            $post_data = $request->all();
            $user_url = $post_data['user_url'];
            $User_emails = new \App\Models\User_emails();
            $useremail_cnfrm = $User_emails::get_single_record('*', "uml_url='{$user_url}'");
            $return_array['user_data'] = array();
            $return_array['user_cc_email'] = NULL;
            $return_array['msg'] = '';
            $return_array['cc_confirmation'] = FALSE;
            if ($useremail_cnfrm != NULL) {
                $user_data = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status', "usr_id={$useremail_cnfrm->uml_user_id}");
                if ($user_data->usr_status == 'a') {
                    $data = array(
                        'uml_status' => 'c',
                        'uml_url' => ''
                    );
                    $condition = "uml_user_id={$useremail_cnfrm->uml_user_id} AND uml_email='{$useremail_cnfrm->uml_email}'";

                    $User_emails::update_record($data, $condition);
                    $return_array['user_data'] = $user_data;
                    $return_array['user_cc_email'] = $useremail_cnfrm->uml_email;
                    $return_array['cc_confirmation'] = TRUE;
                } else {
                    $return_array['msg'] = customTrans('users.confrm_cc_inactive_user');
                }
            } else {
                $return_array['msg'] = customTrans('users.confrm_cc_failed');
            }
            return $this->success('success', 201, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function pre_login(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'user_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $user_id = $this->decrypt_data($post_data['user_id']);

            $valid_user = $this->validate_exist_user($user_id);

            if ($valid_user == true) {
                $user_data = User::get_single_record('count(usr_id) as cnt', "usr_id={$user_id} AND usr_status='a'");
                if ($user_data->cnt > 0) {
                    $return_array['user_status'] = 'active';
                } else {
                    $return_array['user_status'] = 'inactive';
                }
                $return_array['found'] = true;
            } else {
                $return_array['found'] = false;
            }
            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function user_registration_login(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'user_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $user_id = $this->decrypt_data($post_data['user_id']);

            $valid_user = $this->validate_exist_user($user_id);
            if ($valid_user == true) {
                $return_array['found'] = true;
                $current_user = User::get_single_record('*', "usr_id={$user_id} AND usr_status='w'");

                if (!empty($current_user)) {

                    $loggeddata = $this->set_user_loggin($user_id);
                    $logindata = $this->user_login_check($current_user);
                    $token = $loggeddata['token'];
                    $return_array['client_functionality'] = $loggeddata['client_functionality'];
                    $return_array['module_status'] = $loggeddata['module_status'];
                    $return_array['profiledetails'] = $loggeddata['profile_data'];
                    $return_array['login_data'] = $logindata;
                    // $return_array['login_data']=$logindata;
                } else {
                    $return_array['login_error'] = customTrans('user.login-failed');
                }
            } else {
                $return_array['found'] = false;
            }
            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) { {

                return  $this->failure('Failed', 500, $e);
            }
        }
    }
    public function reset_password_email(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'email'      => 'required|email',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $return_array = array();
            $jrnl_grp = $this->get_standalone_journal_data();
            $jnl_id = (isset($jrnl_grp)) ? $jrnl_grp->jnl_id : '';
            $user_record_collection = User::get_user_by_email_journal("usr_email='{$post_data['email']}'", $jnl_id);

            $user_record = array();
            $return_array['lpsuccessmsg'] = customTrans('users.forgot_pwd_success_msg');
            if (count($user_record_collection) > 0) {
                $user_record = $user_record_collection[0];
                if (count($user_record_collection) > 0 && $user_record->usr_status == 'a') {

                    $this->send_forget_password_change($user_record);
                    //Todo - Write code to send email here
                    //  $reset_link = base_url() . 'reset-password?' . $this->encrypt_data('&userid=' . $user_record->usr_id . '&datetime=' . date("Y-m-d H:i:s"));
                    // $set_link = base_url() . 'set-password?' . $this->encrypt_data('&userid=' . $user_record->usr_id . '&datetime=' . date("Y-m-d H:i:s"));
                    $return_array['lpsuccessmsg'] = customTrans('users.forgot_pwd_success_msg');
                } elseif (count($user_record_collection) > 0 && $user_record->usr_status == 'n')
                    $return_array['lpsuccessmsg'] = customTrans('users.inactive_user_msg');
                elseif (count($user_record_collection) > 0 && $user_record->usr_status == 's')
                    $return_array['lpsuccessmsg'] = customTrans('users.suspended_user_msg');
                elseif (count($user_record_collection) > 0 && $user_record->usr_status == 'w')
                    $return_array['lpsuccessmsg'] = customTrans('users.awitng_forgot_user_msg');
                else
                    $return_array['lpsuccessmsg'] = customTrans('users.forgot_pwd_fail_msg');
            }


            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) { {

                return  $this->failure('Failed', 500, $e);
            }
        }
    }
    public function reauthorise_account(Request $request)
    {
        try{
        $return_array = array();
        $cc_object_array_check = array();
        $cc_data_check = [];
        $user_data = $request->all();
        $validator = Validator::make($request->all(), [
            'primary_emailid'      => 'required|regex:/(.+)@(.+)\.(.+)/i',
            'user_id'      => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $reauthorise_account = FALSE;
        if (isset($this->current_client->functionality->cfty_reauthorise_user_account) && $this->current_client->functionality->cfty_reauthorise_user_account == 'y') {
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
            $review_flow_login  = Config::get($review_config);
            $reauthorise_interval =$review_flow_login['reauthorise_interval'];
            $criteria2 = "usr_id={$user_data['user_id']}";
            $last_reauthorised_dates = User::get_single_record('usr_reauthorised_date,usr_roles',$criteria2);
            if (empty($last_reauthorised_dates->usr_reauthorised_date)) {
                $criteria3 = "usr_id={$user_data['user_id']}";
                $registration_date = User::get_single_record('usr_reg_date', $criteria3);
                if (empty($registration_date->usr_reg_date)) {
                    $users = DB::select('SELECT usr_posted_date from tbk_users where usr_id=' . $user_data['user_id'] . ' ORDER BY tbk_id ASC LIMIT 1' );
                    $last_reauthorised_date = $users[0]->usr_posted_date;
                } else {
                    $last_reauthorised_date = $registration_date->usr_reg_date;
                }


            }else {
                $last_reauthorised_date = $last_reauthorised_dates->usr_reauthorised_date;
            }
            $date_diff = time() - strtotime($last_reauthorised_date);
                        $days = round($date_diff / (60 * 60 * 24));
                        if ($days >  $reauthorise_interval) {
                            $user_admin_roles = $this->UserConfigdata('managing_roles');
                            $admin_user_found_re = array();
                            if ($last_reauthorised_dates->usr_roles !== NULL) {
                                $admin_user_found_re = array_intersect(array_keys($user_admin_roles['managing_roles']), json_decode($last_reauthorised_dates->usr_roles));
                            }
                            if (!empty($admin_user_found_re)) {
                                $reauthorise_account = TRUE;
                            }else {
                                $UserToJournal = new \App\Models\User_to_journals();
                                $journal_where_authorize = 'usrj_usr_id =' . $user_data['user_id'] . ' AND usrj_role_id IN(SELECT role_id from rvw_roles WHERE role_reauthorize_accont_enable = \'y\')';
                                $authorize_required = $UserToJournal->get_single_record('count(usrj_id) as cnt', $journal_where_authorize);
                                if ($authorize_required->cnt > 0) {
                                    $reauthorise_account = TRUE;
                                }
                            }

                        }
        }
        if((isset($reauthorise_account) && $reauthorise_account == TRUE))
        {
        if(isset($user_data['primary_emailid']))
        {
            $emaildata='';
            $user_exist_email= $this->check_email($user_data['primary_emailid'],$user_data['user_id'],'',$emaildata);
            if(isset( $user_exist_email)&& ($user_exist_email==true))
            {
                $return_array['msg'] = "Primary Email Already Exist";
                return  $this->success('failure', 201,$return_array);
            }
        }
        if (isset($user_data['ccemailcount'])) {
            $ccemailcounts=$user_data['ccemailcount'];
            if($ccemailcounts>0)
            {
                for($j=0;$j<$ccemailcounts;$j++)
                {
                    if(!empty($user_data['flow_option_'.$j.'_alemail']))
                    {
                    $email_array = array('input'=>$user_data['flow_option_'.$j.'_alemail'],'type'=>'email', 'enc_data'=>FALSE );
                    $email_check= $this->Rv_validator($email_array);
                    if($email_check==false)
                    {
                        $return_array['msg'] = "Invalid alternative emails";
                        return $this->success('failure', 201, $return_array);
                    }
                    if($user_data['flow_option_'.$j.'_alemail'] == $user_data['primary_emailid'])
                        {
                            return  $this->success('failure', 201,'Alternative email should not be the same as primary email');
                        }
                        $cc_data_check['ccuml_email'] = $user_data['flow_option_'.$j.'_alemail'];
                        if( in_array($cc_data_check['ccuml_email'],$cc_object_array_check)){
                            return  $this->success('failure', 201,'Duplicate alternative mail found');
                        }
                        else
                        {
                            array_push($cc_object_array_check, $cc_data_check['ccuml_email']);
                        }
                    }
                }
            }
        }

        $current_user['proxy_user_id'] = NULL;
        $current_user['user_id'] = $user_data['user_id'];
        $current_date_time = date('Y-m-d H:i:s');
        $criteria = "usr_id={$user_data['user_id']}";
        $usr_url_record = User::get_single_record('usr_url, usr_email',$criteria);

            $new_alter_email_found = array();
            $old_alter_email_found = array();
            $new_alter_emails = array();
            $User_emails = new \App\Models\User_emails();
            $criteria1 = "uml_user_id={$user_data['user_id']}";
        $cc_mail_data = $User_emails::get_all_records('uml_email',$criteria1);

            if (isset($user_data['ccemailcount'])) {
        $ccemailcount=$user_data['ccemailcount'];
        if($ccemailcount>0)
        {
            for($i=0;$i<$ccemailcount;$i++)
            {
                array_push($new_alter_emails,  $user_data['flow_option_'.$i.'_alemail']);
                    }
                }
                $cc_mail_data_array = array();
                foreach ($cc_mail_data as $key => $mail) {
                    $cc_mail_data_array[] = $mail->uml_email;
                    if (!in_array($mail->uml_email, $new_alter_emails)) {
                        $criteria3 = "uml_email = '{$mail->uml_email}' AND uml_user_id = {$user_data['user_id']}";
                        $User_emails::delete_records($criteria3, '',  $current_user);
                        array_push($old_alter_email_found, $mail->uml_email);
                    }


                }
                $activation_links = array();
                foreach (array_unique($new_alter_emails) as $key => $mail) {
                    if (!in_array($mail, $cc_mail_data_array) && $mail != '') {
                        $activation_url = md5($mail . '' . $current_date_time);
                        $cc_data['uml_url'] = $activation_links[] = $activation_url;
                        $cc_data['uml_user_id'] = $user_data['user_id'];
                        $cc_data['uml_email'] = $mail;
                        $cc_data['uml_posted_by'] = $user_data['user_id'];
                        $User_emails::insert_record($cc_data);
                        array_push($new_alter_email_found, $mail);

                    }

                }
            }
            /*  if (!empty($old_alter_email_found)) {
            foreach ($old_alter_email_found as $ind_mails) {
                $condition = "uml_email = '{$ind_mails}' AND uml_user_id = {$user_data['user_id']}";
                $get_email_id = $User_emails::get_single_record('uml_id', $condition);

                $remove_email_link = URL::to('/')  . "/confirm_alernative_email?" . $this->encrypt_data("&user_id=" . $user_data['user_id'] . "&uml_id=" . $get_email_id->uml_id);
                $custom_data = array(
                    'confirmation_link' => $remove_email_link,
                    'user_email' =>  $ind_mails

                );
                $email_data = array(
                    'type' => 'global',
                    'action' => 'send',
                    'email_with_login' => FALSE,
                    'user_id' => $user_data['user_id'],
                    'empt_name' => 'confirm_mail_for_ccmail',
                    'custom_data' => $custom_data
                );
                $this->master_email_details($email_data);
            }
        }*/
            if (!empty($new_alter_email_found)) {
            $i=0;
                foreach ($new_alter_email_found as $ind_mails) {
                    $activation_links[$i];
                $remove_email_links = URL::to('/')  . "/cc_mail_confirm?". $this->encrypt_data("&token=" . $activation_links[$i]);
                    $custom_data = array(
                        'confirmation_link' => $remove_email_links,
                        'user_email' =>  $ind_mails

                    );
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => FALSE,
                        'user_id' => $user_data['user_id'],
                        'empt_name' => 'confirm_mail_for_ccmail',
                        'custom_data' => $custom_data
                    );
                    $this->master_email_details($email_data);
                $i=$i+1;
                }
            }

         $activation_url = md5(Str::random(20). '' . $current_date_time);
            $user_encrypted_id = $user_data['user_id'];
            $primary_email_link = URL::to('/')  . "/confirm-reauthorization?" . $this->encrypt_data("&token=" . $activation_url . "&id=" . $user_encrypted_id . "&reauthorization=true");
            $custom_data_pr = array(
                'confirmation_link' => $primary_email_link,
                'user_email' =>  $user_data['primary_emailid']
            );
            $email_data = array(
                'type' => 'global',
                'action' => 'send',
                'email_with_login' => FALSE,
                'user_id' => $user_data['user_id'],
                'empt_name' => 'reauthorize_account',
                'custom_data' => $custom_data_pr
            );
            $this->master_email_details($email_data);
            $data['usr_url'] = $activation_url;
            $data['usr_email'] = $user_data['primary_emailid'];
            $condition = "usr_id = {$user_data['user_id']}";
            User::update_record($data, $condition, $current_user);
            $return_array['msg'] = "Your listed email address has received a verification email. To finish the reauthorization procedure for your account, kindly click the confirmation link in it.";
            $return_array['status'] = 'success';
            return $this->success('success', 201, $return_array);
        }else{
            return  $this->success('failure', 201,'Failed');
        }

        }catch (\Exception $e) {


            return  $this->failure('Failed', 500, $e);
        }
    }
    public function delete_alternative_mail(Request $request)
    {
        try
        {
            $return_array = array();
            $user_data = $request->all();
            $return_array['status'] = 'failed';
            $current_user['proxy_user_id'] = NULL;
            $current_user['user_id'] = $user_data['userid'];
            $uml_id =$user_data['umlid'];
            $User_emails = new \App\Models\User_emails();
            $condition = "uml_id = '{$uml_id}' ";
            $delete_email = $User_emails::delete_records($condition,'',  $current_user);
            if($delete_email)
			{
                $return_array['status'] = 'success';
            }
            return $this->success('success', 201, $return_array);
        }catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function confirm_alernative_email(Request $request)
    {
        try
        {
            $return_array = array();
            $post_data=$request->all();
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            if($post_data['select']!=NULL)
            {
                $User_emails = new \App\Models\User_emails();
                $user_id=isset($_GET['user_id']) ? $_GET['user_id'] : '';
                $uml_id=isset($_GET['uml_id']) ? $_GET['uml_id'] : '';
                $delete_email = FALSE;
                $condition = "uml_id = '{$uml_id}' AND uml_user_id={$user_id}";
                $email_check = $User_emails::get_single_record('count(uml_id) as cnt',$condition);
                if($email_check->cnt > 0)
			    {
                    $delete_email = TRUE;
                }
                $return_array['uml_id'] = $uml_id;
                $return_array['user_id'] = $user_id;
                $return_array['delete_email'] = $delete_email;
                return $this->success('success', 201, $return_array);
            }

        }catch (\Exception $e) {


            return  $this->failure('Failed', 500, $e);
        }

    }
    public function ccmail_confirmation(Request $request)
    {
        try
        {
            $return_array = array();
            $post_data=$request->all();
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            if($post_data['select']!=NULL)
            {
            $verify_url=isset($_GET['token']) ? $_GET['token'] : '';
                $User_emails = new \App\Models\User_emails();
                $condition = "uml_url = '{$verify_url}' ";
                $user_cnfrm = $User_emails::get_single_record('*', $condition);
                if ($user_cnfrm != NULL) {
                    $condition1 = "usr_id = {$user_cnfrm->uml_user_id} ";
                $user_data=User::get_single_record('*',  $condition1);
                    if ($user_data->usr_status == 'a') {

                        $data = array(
                            'uml_status' => 'c',
                        'uml_url' => '');
                        $condition3 = "uml_user_id={$user_cnfrm->uml_user_id} AND uml_email='{$user_cnfrm->uml_email}'";

                        $User_emails::update_record($data, $condition3);

                $return_array['user_cnfrm_email']= $user_cnfrm->uml_email; //RVW1093
                $return_array['user_cnfrm']=$user_data;
                        $return_array['status'] = 'success';
                        return $this->success('success', 201, $return_array);


                }else{
                        $return_array['status'] = 'failed';
                        return $this->success('success', 201, $return_array);
                    }


            }else{
                    $return_array['status'] = 'failed';
                    return $this->success('success', 201, $return_array);
                }
        }else{
                $return_array['status'] = 'failed';
                return $this->success('success', 201, $return_array);
            }

        }catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }

    }
    public function reauthorise_confirm(Request $request)
    {
        try
        {
            $return_array = array();
            $post_data=$request->all();
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            if($post_data['select']!=NULL)
            {
                $usr_id=isset($_GET['id']) ? $_GET['id'] : '';
                $verify_url=isset($_GET['token']) ? $_GET['token'] : '';
                $reauthorization=isset($_GET['reauthorization']) ? $_GET['reauthorization'] : '';
                $condition = "usr_id = {$usr_id} AND usr_url='{$verify_url}'";
                $user_cnfrm = User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status',$condition);
                if ($user_cnfrm != null && $user_cnfrm->usr_status == 'a' ) {

                    $user_id=$user_cnfrm->usr_id;
                    $user_email=$user_cnfrm->usr_email;

                    $old_email = $user_cnfrm->usr_email;
                    $current_user['proxy_user_id'] = NULL;
                    $current_user['user_id'] = $user_id;
                    $usr_data = array(
                        'usr_url' => NULL,
                        'usr_email' => $user_email,
                        'usr_reauthorised_date' => date('Y-m-d H:i:s'));
                    $condition1 = "usr_id = {$user_cnfrm->usr_id}";
                        User::update_record($usr_data, $condition1,$current_user );
                    $custom_data_confirm = array(
                        'user_email' =>  $old_email
                    );
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => FALSE,
                        'user_id' => $user_cnfrm->usr_id,
                        'empt_name' => 'reauthorize_account_confirmation',
                        'custom_data' => $custom_data_confirm
                    );

                    $this->master_email_details($email_data);
                    $return_array['user_data'] = $user_cnfrm;
                    $return_array['status'] = 'success';
                    return $this->success('success', 201, $return_array);
                }
                else{
                    $return_array['status'] = 'failed';
                    return $this->success('success', 201, $return_array);
                }

            }else{
                $return_array['status'] = 'failed';
                return $this->success('success', 201, $return_array);
            }
        }
        catch (\Exception $e) {


            return  $this->failure('Failed', 500, $e);
        }

    }
    public function change_force_password(Request $request)
    {
        try{
            $return_array = array();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'current_password'      => 'required',
                'newpassword'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!.@#\$%\^&\*])(?=.{8,})/',
                'confirmpassword'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!.@#\$%\^&\*])(?=.{8,})/',
                'user_id'      => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            if($post_data['confirmpassword'] != $post_data['newpassword'])
            {
                return  $this->failure('Failed', 200,'Passwords must match');
            }
            $check_pass=$this->check_recent_passwords($post_data['user_id'],$post_data['confirmpassword']);
            if($check_pass==true && !empty($check_pass))
                {
                    $return_array['msg'] = customTrans('users.resetpasswordvalid');
                    return $this->success('failure', 201, $return_array);
                }
            $change_password = FALSE;
            if (isset($this->current_client->functionality->cfty_force_change_password) && $this->current_client->functionality->cfty_force_change_password == 'y') {
                $review_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                $review_flow_login  = Config::get($review_config);
                $change_password_interval =$review_flow_login['change_password_interval'];
                $criteria = "pash_usr_id={$post_data['user_id']}";
                $User_password_history=new \App\Models\User_password_history();
                $last_password_change_date  =  $User_password_history::get_single_record('pash_posted_date', $criteria, NULL, NULL, 'pash_id DESC');
                if (!empty($last_password_change_date)) {
                    $last_password_change_date = $last_password_change_date->pash_posted_date;
                }else {
                  $users = DB::select('SELECT usr_posted_date from tbk_users where usr_id=' . $post_data['user_id'] . ' ORDER BY tbk_id ASC LIMIT 1' );
                  $last_password_change_date = $users[0]->usr_posted_date;
                }
                $date_diff = time() - strtotime($last_password_change_date);
                $days = round($date_diff / (60 * 60 * 24));
                if ($days > $change_password_interval) {
                    $change_password = TRUE;
                }
            }
            if((isset($change_password) && $change_password == TRUE))
            {
            $user_id = $post_data['user_id'];
            $username = $post_data['username'];
            $current_password = $post_data['current_password'];
            $confirmpassword = $post_data['confirmpassword'];
            $Authzorize = new \App\Models\Authorize();
            $user = $Authzorize::where('usr_id', $user_id)->get()->first();
            if ($post_data && \Hash::check($current_password, $user->usr_pwd) ) {
                if($post_data['current_password'] == $post_data['newpassword'])
                {
                    $return_array['msg'] = "Your current password and new password are the same. Please use a different password.";
                    return $this->success('failure', 201, $return_array);
                }
                $verify_userid = $this->validate_exist_user($user_id);
                if ($verify_userid == true) {
                    $userdata = array(
                        'user_id' => $user_id,
                        'proxy_user_id' => 0,
                    );
                    $password = Hash::make($post_data['confirmpassword']);
                    $edit_user = 'usr_id=' . $user_id;
                    $data['usr_pwd'] = $password;
                    $data['usr_f_status'] = 'n';
                    User::update_record($data, $edit_user, $userdata);
                    $this->update_password_history($password, $user_id, $userdata);
                    $user_data = array("password" => $post_data['confirmpassword'], "user_id" => $user_id);
                    $this->send_change_password_success($user_data);
                    $return_array['msg'] = "Password changed successfully";
                    $return_array['status'] = 'success';
                    return $this->success('success', 201, $return_array);


                }

            }else{

                $return_array['msg'] = "Your current password is incorrect.";
                return $this->success('failure', 201, $return_array);
            }
        }else{
            $return_array['msg'] = "Password Already Changed.";
            return $this->success('failure', 201, $return_array);
        }
            // $jrnl_grp = $this->get_standalone_journal_data();
            // $jnl_id = (isset($jrnl_grp)) ? $jrnl_grp->jnl_id : '';
            // $where = "usr_username='{$username}' AND usr_pwd='{$current_password}'";
            // $user_dets = User::get_user_by_email_journal($where, $jnl_id);



        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function forget_user_password(Request $request)
    {
        try {

            $post_data = $request->all();

            $return_array = array();
            $return_array['user_id'] = '';
            $return_array['msg'] = '';
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            $return_array['verifi'] = FALSE;
            if ($post_data['select'] != NULL) {

                $user_id = isset($_GET['userid']) ? $_GET['userid'] : '';
                $date = isset($_GET['datetime']) ? $_GET['datetime'] : '';
                $valid_key = isset($_GET['key']) ? $_GET['key'] : '';
                if ($user_id != NULL && $date != NULL) {

                    $verifydate = $this->verifyDate($date);
                    $verify_userid = $this->validate_exist_user($user_id);
                    if ($verifydate == TRUE && $verify_userid == TRUE) {
                        $today = date("Y-m-d H:i:s");
                        $hoursDiff = round((strtotime($today) - strtotime($date)) / 3600, 1);
                        $check_user = User::get_single_record('usr_deeplink_token', "usr_id={$user_id}");
                        $key = isset(json_decode(decrypt_link($check_user->usr_deeplink_token))->key) ? json_decode(decrypt_link($check_user->usr_deeplink_token))->key:'' ;
                    //    print_r($key);
                        if ($hoursDiff >= 24 || $key == '' ||$valid_key != $key) {
                            $return_array['msg'] = "The link expired !!";
                        } else {
                            // print_r(json_decode(decrypt_link($check_user->usr_deeplink_token))->key);
                            $return_array['user_id'] = $this->encrypt_data($_GET['userid']);
                            $return_array['verifi'] = TRUE;
                            $return_array['valid'] = $this->encrypt_data($key);
                        }
                    }
                }
            }
            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) { {

                return  $this->failure('Failed', 500, $e);
            }
        }
    }
    public function save_password(Request $request)
    {
        try {
            $post_data = $request->all();
            $return_array = array();
            $validator = Validator::make($request->all(), [
                'newpassword'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/',
                'confirmpassword'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/',
                'user_id'      => 'required',
                'token'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            if ($post_data['newpassword'] != $post_data['confirmpassword']) {
                $msg = 'Password mismatch';
                return $this->success('failed', 201, $msg);

            }
            $user_id = $this->decrypt_data($post_data['user_id']);
            $key = $this->decrypt_data($post_data['token']);
            $verify_userid = $this->validate_exist_user($user_id);
            $check_user = User::get_single_record('usr_deeplink_token', "usr_id={$user_id}");
            // print_r(isset($check_user->usr_deeplink_token) && $check_user->usr_deeplink_token != '' ? json_decode(decrypt_link($check_user->usr_deeplink_token))->userid : "false");
            // exit;
            if (isset($check_user->usr_deeplink_token) && $check_user->usr_deeplink_token != '' && (json_decode(decrypt_link($check_user->usr_deeplink_token))->userid == $user_id) && (json_decode(decrypt_link($check_user->usr_deeplink_token))->key == $key)) {
                if ($verify_userid == true) {
                    $userdata = array(
                        'user_id' => $user_id,
                        'proxy_user_id' => 0,
                    );
                    $password = Hash::make($post_data['confirmpassword']);
                    $check_pass=$this->check_recent_passwords($user_id,$post_data['confirmpassword']);
                    if($check_pass==true && !empty($check_pass))
                    {
                        $msg= customTrans('users.resetpasswordvalid');
                        // $msg="You must enter a new password or one that is older than the last 10 passwords you used.";
                        return $this->success('warning', 201, $msg);
                    }
                    $edit_user = 'usr_id=' . $user_id;
                    $data['usr_pwd'] = $password;
                    $data['usr_deeplink_token'] = '';
                    $data['usr_f_status'] = 'n';
                    User::update_record($data, $edit_user, $userdata);
                    $this->update_password_history($password, $user_id, $userdata);
                    $user_data = array("password" => $post_data['confirmpassword'], "user_id" => $user_id);
                    $this->send_change_password_success($user_data);
                    return $this->success('success', 201, $return_array);
                }
            } else {
                $msg = 'The password reset link has expired';
                return $this->success('failed', 201, $msg);
            }
        } catch (\Exception $e) { {

                return  $this->failure('Failed', 500, $e);
            }
        }
    }
    public function change_password(Request $request)
    {
        try {
            $post_data = $request->all();
            $return_array = array();
            $validator = Validator::make($request->all(), [
                'newpassword'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/',
                'confirmpassword'      => 'required|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/',
                'current_pass'      => 'required',
                'user_id'      => 'required',
                // 'token'      => 'required',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
            }
            if ($post_data['newpassword'] != $post_data['confirmpassword']) {
                $msg = 'Password mismatch';
                return $this->success('failed', 201, $msg);

            }
            $user_id = $this->decrypt_data($post_data['user_id']);
            $key = $this->decrypt_data($post_data['token']);
            $verify_userid = $this->validate_exist_user($user_id);
            $check_user = User::get_single_record('usr_deeplink_token,usr_pwd', "usr_id={$user_id}");
            if(Hash::check($post_data['current_pass'], $check_user->usr_pwd))
            {
                if ($verify_userid == true) {
                    $userdata = array(
                        'user_id' => $user_id,
                        'proxy_user_id' => 0,
                    );
                    $password = Hash::make($post_data['confirmpassword']);
                    //  print_r($check_user );exit;
                    $check_pass=$this->check_recent_passwords($user_id,$post_data['confirmpassword']);
                    if($check_pass==true && !empty($check_pass))
                    {
                        $msg= customTrans('users.resetpasswordvalid');
                        // $msg="You must enter a new password or one that is older than the last 10 passwords you used.";
                        return $this->success('warning', 201, $msg);
                    }
                    $edit_user = 'usr_id=' . $user_id;
                    $data['usr_pwd'] = $password;
                    $data['usr_deeplink_token'] = '';
                    $data['usr_f_status'] = 'n';
                    User::update_record($data, $edit_user, $userdata);
                    $this->update_password_history($password, $user_id, $userdata);
                    $user_data = array("password" => $post_data['confirmpassword'], "user_id" => $user_id);
                    $this->send_change_password_success($user_data);
                    return $this->success('success', 201, $return_array);
                }
            }
            else{
                $return_array['msg']='Unauthorized access';
                return  $this->warning('Warnings',200,$return_array,'warning');
            }
        } catch (\Exception $e) { {

                return  $this->failure('Failed', 500, $e);
            }
        }
    }




    public function send_confirmation_email(Request $request)
    {
        try {
            $agent = new Agent();
            $post_data = $request->all();
            exit;
            //$footer_part = lang('email_footer_html');



            $email = 'vimalr.rvt@gmail.com';
            $file_path = Config::get('general_config.file_retrieval')['file_path'];

            //$fullpath = public_path() . $file_path . '/pcori/DFRR/670/day_and_night_night_1_year.jpg';
            //$fullpath=Storage::disk('s3')->url('uploads/pcori/DFRR/670/day_and_night_night_1_year.jpg');
            $general_config= Config::get('general_config');
            $s3_bucket_access_time = $general_config['s3_bucket_access_time'];
            $fullpath=Storage::disk('s3')->temporaryUrl('uploads/pcori/DFRR/670/day_and_night_night_1_year.jpg', now()->addHours($s3_bucket_access_time));



            /*$array=array($fullpath);
       $mailData = [
    'title' => 'Demo Email',
    'form_email'=>'noreply@reviewdemo.rivervalleytechnologies.com',
    'from_name'=>'rsgp',
    'url' => 'https://www.positronx.io',
    'subject'=>'Confirmation Email',
    'ccuser'=>'sajitha.rvtproduction@gmail.com',
    'bccuser'=>'shyno.1099.rvt@gmail.com',
    'replay_to'=>'lincy.rvt@gmail.com',
    'content'=>'hai',
    'header_content'=>'lal',
    'footer_content'=>'footer',
     'attachments'=>$array

];

                           Mail::to($email)
                           ->send(new SendEmail($mailData));
*/
$return_array=array();
return $this->success('success',201,$return_array);
            $user_email = 'vimal@rivervalleytechnologies.com';
            $User_emails = new \App\Models\User_emails();
            $Email_templates = new \App\Models\Email_templates();
            //confirm altenate emails


            $user_cnfrm = $User_emails::get_all_records('*', "uml_user_id=61470 AND uml_status!='c'");

            if (!empty($user_cnfrm)) {
                foreach ($user_cnfrm as $key => $mail) {
                    $user_email = $mail->uml_email;
                    $current_date_time = date('Y-m-d H:i:s');
                    $activation_url = md5($user_email . '' . $current_date_time);
                    /*$custom_data=array(
    'password'=>'12345678',
    'confirmation_link'=>URL::to('/') . '/confirmation/' . $activation_url);
$email_data=array(
    'type'=>'global',
    'action'=>'send',
    'email_with_login'=>FALSE,
    'user_id'=>610,
    'empt_name'=>'register_user',
    'custom_data'=>$custom_data
);*/
                    $custom_data = array(
                        'cc_email' => $user_email,
                        'cc_confirmation_link' => URL::to('/') . '/confirmation/cc-mail/' . $activation_url,
                        'confirm_cc_email' => TRUE
                    );
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => FALSE,
                        'user_id' => 61470,
                        'empt_name' => 'confirm_mail_for_ccmail',
                        'custom_data' => $custom_data
                    );

                    $this->master_email_details($email_data);
                }
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }


    public function unregister_user_account(Request $request)
    {
        try {
            $crnt_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'unreg_reason' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $form_data = $request->all();
            $unregister_reason = "";
            if (isset($form_data['unreg_reason'])) {
                $unregister_reason = $form_data['unreg_reason'];
            } elseif (isset($form_data['unreg_comment'])) {
                $unregister_reason = $form_data['unreg_comment'];
            }
            $msg = "Your unregister request has been sent successfully.";
            $current_user_id = $this->get_current_user_details()['user_id'];
            // $user_condition = "usr_id={$current_user_id}";
            // $current_user = User::get_single_record('*', $user_condition);
            $user_condition = ['usr_id'=>$current_user_id];
            $current_user = User::get_single_record_with_bind_cond('*',$user_condition);
            // $criteria = "uur_usr_id={$current_user_id}";
            // $status_count = User_unregister::get_single_record('count(uur_id) as un_count', $criteria);
            $criteria = ['uur_usr_id'=>$current_user_id];
            $status_count = User_unregister::get_single_record_with_bind_cond('count(uur_id) as un_count',$criteria);

            $user_email = $current_user->usr_email;
            $data['usr_username'] = $current_user->usr_username;
            $data['usr_status'] = $current_user->usr_status;
            $data['usr_registered'] = $current_user->usr_registered;
            $data['user_id'] = $current_user->usr_id;
            $data['proxy_user_id'] = '0';

            $user_email_criteria = "etmp_name = 'unregister_notification' AND etmp_notification = 'User'";
            $email_template_record = Email_templates::get_single_record('*', $user_email_criteria);
            // print_r($user_record);
            /* Email for user */
            if ($status_count->un_count == 0) {
                if ($email_template_record != NULL) {
                    $custom_data = array(
                        'current_user_unregister_account' => $unregister_reason
                    );
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => TRUE,
                        'user_id' => $current_user->usr_id,
                        'empt_name' => 'unregister_notification',
                        'custom_data' => $custom_data
                    );
                    $this->master_email_details($email_data);
                }
            }
            /* End of email for user */

            /* Email for super admin */
            $super_admin_email_criteria = "etmp_name = 'unregister_notification_super' AND etmp_notification = 'Super Admin'";
            $super_admin_email_record = Email_templates::get_single_record('*', $super_admin_email_criteria);
            $sa_user_criteria = 'usr_roles LIKE "%super_admin%"';
            $super_user_data = User::get_all_records('usr_email,usr_id', $sa_user_criteria);
            // get_single_record("usr_email,usr_id", 'usr_roles LIKE "%super_admin%"');
            if (count($super_user_data) > 0 && $status_count->un_count == 0){
                foreach ($super_user_data as $superuser) {
                    $custom_data = array(
                        'current_user_unregister_account' => $unregister_reason
                    );
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => TRUE,
                        'user_id' => $superuser->usr_id,
                        'empt_name' => 'unregister_notification_super',
                        'custom_data'=>$custom_data
                    );
                    $this->master_email_details($email_data);
                }
            }
            /* End of email for super admin */

            /*send feedback email */
            // if ($this->input->get()) {
            //     parse_str(decrypt_link($_SERVER["QUERY_STRING"]), $_GET);
            //     $pass_data = $_GET;
            //     $send_feedback = $this->user_feedback($pass_data);
            //     $unregister_reason = $pass_data['comments'];
            // $jnl_id     =   $post_data['jnl_id'];
            //     if(((isset($this->current_client->functionality->cfty_enable_journal_reply_to)) && ($this->current_client->functionality->cfty_enable_journal_reply_to == 'y'))
            //     && ($jnl_id != '')) {
            //         $jrnl_grp   =   Journal_settings::get_single_record('jset_reply_to_email',"jset_jnl_id={$jnl_id}");
            //         if(isset($jrnl_grp->jset_reply_to_email) && ($jrnl_grp->jset_reply_to_email != '')) {
            //             $email_jnl_to = $jrnl_grp->jset_reply_to_email;
            //         }
            //     }
            //     if($email_jnl_to == '')
            //         $email_jnl_to     =   Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['email_from_address'];

            //     DB::beginTransaction();
            //     $mail_status =  $this->user_feedback_notification($post_data, $email_jnl_to);
            //     DB::commit();
            // }
            /*end of feedback email */
            $reason_array = [];
            $reason_array['uur_usr_id'] = $current_user->usr_id;
            $reason_array['uur_reason'] =  $form_data['unreg_reason'];
            $return_arr = array();

            if ($status_count->un_count == 0) {
                $user_unreg = User_unregister::insert_record($reason_array, $crnt_user);
                if ($user_unreg != '') {
                    $return_arr['flag'] = 1;
                    $return_arr['msg'] = "Unregister request sent";
                    $return_arr['status'] = "success";
                }
            } else {
                $user_dlt_criteria = "uur_usr_id={$current_user_id}";
                $user_dlt = User_unregister::delete_records($user_dlt_criteria, '', $crnt_user);
                if ($user_dlt) {
                    $return_arr['flag'] = 0;
                    $return_arr['msg'] = "Deleted unregister request";
                    $return_arr['status'] = "success";
                }
            }
            $update_criteria = "usr_id={$current_user_id}";
            $update_array = array('usr_status' => 'n');
            User::update_record($update_array, $update_criteria, $crnt_user);
            // $msg = "Your unregister request has been sent successfully.";
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_unregistered_users_list(Request $request)
    {
        try {
            $form_data = $request->all();
            $date_format = $this->current_client->settings->cs_date_format;
            $date_format = date_format_map($date_format);
            $condition = "uur_request_status ='n' ";

            $condition .= (isset($form_data['reg_name'])) ? 'AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $form_data['reg_name'] . '%"))' : '';
            $condition .= (isset($form_data['reg_email'])) ? " AND usr_email LIKE '%" . $form_data['reg_email'] . "%'" : '';

            $unregister_table = (new \App\Models\User_unregister())->getTable();
            $user_table = (new \App\Models\User())->getTable();
            $limit = 10;
            $select = 'CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as usr_fullname,usr_id,DATE_FORMAT(uur_posted_date,"' . $date_format . ' ") AS uur_posted_date,uur_reason,uur_id,usr_email';
            $sort_field = $form_data['sort_field'] ? $form_data['sort_field'] : 'uur_id';
            $sort_order = $form_data['sort_order'] ? $form_data['sort_order'] : 'asc';
            $tables = array(
                'main_table' => $unregister_table,
                'join_table' => $user_table,
                'column_prefix1' => $unregister_table . '.uur_usr_id',
                'column_prefix2' => $user_table . '.usr_id',
            );

            $unregistered_users_list = User_unregister::get_results_join_pagination($tables, $select, $condition, null, $sort_field, $sort_order, $limit);
            // exit;
            foreach ($unregistered_users_list as $unregistered_user) {
                if ($unregistered_user->usr_id) {
                    $displayArray = array(
                        'user_id' => $unregistered_user->usr_id,
                        'jnl_code' => NULL,
                        'flag'     => TRUE,
                        'article_id' =>  NULL,
                        'availability' => TRUE,
                        'save_coauthor' => FALSE,
                        'remove_user' => FALSE,
                        'source' => FALSE,
                        'salutation' => TRUE,
                        'flag_only' => FALSE,
                        'inactive_user' => FALSE,
                        'fullname_only' => FALSE,
                        'journal_id' => NULL,
                    );
                    $unregistered_user->usr_fullname = $this->get_user_display_name($displayArray);
                }
            }
            // print_r($unregistered_users_list);
            return $this->success('success', 200, $unregistered_users_list);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function approve_unregister_user_request(Request $request)
    {
        try {
            $return_arr = [];
            $form_data  = $request->all();
            $crnt_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'request_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $unreg_id = $this->decrypt_data($form_data['request_id']);
            $criteria = "uur_id={$unreg_id}";
            $userdetails = User_unregister::get_single_record('uur_usr_id', $criteria);
            $user_condition = "usr_id={$userdetails->uur_usr_id}";
            $user_data = User::get_single_record('*', $user_condition);
            $user_email = $user_data->usr_email;
            $data['usr_username'] = $user_data->usr_username;
            $data['usr_status'] = $user_data->usr_status;
            $data['usr_registered'] = $user_data->usr_registered;
            $data['user_id'] = $user_data->usr_id;
            $link = "";
            if (!empty($user_data->usr_jnl_standalone)) {
                $jnl_criteria = "jnl_id ={$user_data->usr_jnl_standalone}";
                $jrnl_grp_name = Journals::get_single_record('jnl_standalone_group', $jnl_criteria);
                $link = $this->build_url_standalone($jrnl_grp_name->jnl_standalone_group);
            }
            $user_email_criteria = "etmp_name = 'unregister_confirmation' AND etmp_notification = 'User'";
            $email_template_record = Email_templates::get_single_record('*', $user_email_criteria);
            $custom_data = array(
                'link' => $link
            );
            if ($email_template_record != NULL) {
                $email_data = array(
                    'type' => 'global',
                    'action' => 'send',
                    'email_with_login' => TRUE,
                    'user_id' => $user_data->usr_id,
                    'empt_name' => 'unregister_confirmation',
                    'custom_data' => $custom_data
                );
                $this->master_email_details($email_data);
            }
            $unreg_data = array("uur_request_status" => 'y');
            $unreg_criteria = "uur_usr_id = {$userdetails->uur_usr_id}";
            $update_result = User_unregister::update_record($unreg_data, $unreg_criteria, $crnt_user);

            $anonymise_data = $this->anonymize_users($userdetails->uur_usr_id, "u");
            if ($anonymise_data['status'] == "success") {
                $return_arr['status'] = 'success';
                return $this->success('success', 200, $return_arr);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function check_accept_reject_url(Request $request){
        try{
          $post_data = $request->all();

          $return_array = array();
          $return_array['user_id'] = '';
          $return_array['msg'] = '';
          parse_str($this->decrypt_data($post_data['select']), $_GET);
          $return_array['verifi'] = FALSE;
          $redirect_link='';
          $redirect_msg='';
          $query_string='';
          $set_user_role='';
          if ($post_data['select'] != NULL) {

              $user_id = isset($_GET['userid']) ? $_GET['userid'] : '';
              $key = isset($_GET['key']) ? $_GET['key'] : '';
              $flw_id = isset($_GET['status_id']) ? $_GET['status_id'] : '';
              $btn=isset($_GET['btn']) ? $_GET['btn'] : '';
              $article_id=isset($_GET['article_id']) ? $_GET['article_id'] : '';
              $bulksubmission = isset($_GET['bulksubmission']) ? $_GET['bulksubmission'] : FALSE;
              if ($user_id != NULL) {

                 // $verifydate = $this->verifyDate($date);
                  $verify_userid = $this->validate_exist_user($user_id);
                  if ( $verify_userid == TRUE) {
                      $return_array['verifi'] = TRUE;
                      $Authzorize = new \App\Models\Authorize();

                      $user = $Authzorize::where('usr_id', $user_id)->get()->first();
                      $loggeddata = $this->set_user_loggin($user->usr_id);

                      if (!empty($loggeddata)) {


                          $user_role_manage_tab = '';
                          if (isset($_GET['user_role'])) {
                              $user_role_manage_tab = $_GET['user_role'];
                          }
                          $user_arr = array(
                              'user_id' => $user_id,
                              'proxy_user_id'=>$user_id
                          );
                          $without_login_token_flag=FALSE;
                          $bulk_invitation_link=FALSE;
                          //#581 hide terms & conditions popup for reviewers on decline invitation
                          //if hide, don't show the t&c popup else show
                          $show_tc_popup = 'show';
                          if (isset($_GET['show_user_terms_condition_modal']) && $_GET['show_user_terms_condition_modal'] == 'hide') {
                              $show_tc_popup = 'hide';
                          }
                       $User = new \App\Models\User();
                       $Article_flow = new \App\Models\Article_flow();
                       $Journals = new \App\Models\Journals();
                       $Articles = new \App\Models\Articles();
                       $Article_types = new \App\Models\Article_types();
                       $article_type_table=(new \App\Models\Article_types())->getTable();
                       $article_table=(new \App\Models\Articles())->getTable();
                       $journal_table=(new \App\Models\Journals())->getTable();
                          $sql = "SELECT jnl_journal_name,jnl_journal_code FROM {$journal_table} INNER JOIN $article_type_table ON jnl_id = artp_jnl_id INNER JOIN {$article_table} ON artp_id=art_artp_id WHERE art_id = " . $article_id;
                          $jnl_name = $Journals::get_records_by_raw_query($sql);
                            if (empty($jnl_name) && count($jnl_name) == 0) {
                                $return_array['redirect_msg'] = 'The link that you have followed has expired.';
                                return $this->success('success', 200, $return_array);
                            }
                          $journal_code=$jnl_name[0]->jnl_journal_code;

                          if(!empty($flw_id))
                          {
                              $flw_user_id = Article_flow::get_single_record("aflw_usr_id, aflw_status,aflw_deeplink_token,aflw_operation,aflw_posted_by,aflw_remarks,aflw_decline_clk_count,aflw_accept_clk_count,aflw_jwf_id","aflw_id={$flw_id}");
                            }
                            if(!empty($flw_user_id->aflw_jwf_id)){
                                $flw_user_role_data = Generic_flows::get_single_record("jwf_role_id,jwf_id","jwf_id={$flw_user_id->aflw_jwf_id}");
                                $set_user_role = $flw_user_role_data->jwf_role_id;
                            }
                          if (isset($flw_user_id) && $flw_user_id != NULL) {

                          $accept_link_click_count = $flw_user_id->aflw_accept_clk_count +1;
                          $link_click_count = $flw_user_id->aflw_decline_clk_count +1;
                          $urlsetting= 'general_config.url_settings';
                          $click_count= Config::get($urlsetting);

                          $clk_cnt = $click_count['url_click_count'];

                          if($btn == 'reject' && $link_click_count <= $clk_cnt && $flw_user_id->aflw_status == 'i' && $flw_user_id->aflw_deeplink_token != '')
                          {
                          $update_array = array(
                              'aflw_decline_clk_count' => $link_click_count);
                              $Article_flow::update_record($update_array,"aflw_id={$flw_id}", $user_arr);
                          }

                              if(isset($this->current_client->functionality->cfty_enable_google_mfa) && $this->current_client->functionality->cfty_enable_google_mfa == 'y')
                              {
                                 $skip_2fa=TRUE;
                              }

                              $user_data = $User::get_single_record('*',"usr_id={$user_id}");
                              $link_expire='The link that you have followed has expired. Please login to your account and visit the
                              %user_role% dashboard in "%JOURNAL_NAME%" in order to complete this action.';
                                  $link_expired_error_msg =    str_replace('%JOURNAL_NAME%', $jnl_name[0]->jnl_journal_name, $link_expire);
                                  if(isset($bulksubmission) && $bulksubmission == TRUE){
                                      $link_expired_error_msg =    str_replace('%user_role%', 'Author', $link_expired_error_msg);
                                  }else{
                                      $link_expired_error_msg =    str_replace('%user_role%', 'Reviewer', $link_expired_error_msg);
                                  }
                                  $reject_response_recorded='Your reject response already recorded.Kindly login to your journal "%JOURNAL_NAME%" and pick your task.';
                                  $reject_error_msg =    str_replace('%JOURNAL_NAME%', $jnl_name[0]->jnl_journal_name, $reject_response_recorded);
                                  $accept_response_recorded='Your accept response already recorded.Kindly login to your journal "%JOURNAL_NAME%" and pick your task.';
                                  $accept_error_msg =    str_replace('%JOURNAL_NAME%', $jnl_name[0]->jnl_journal_name,$accept_response_recorded);

                                if($flw_user_id->aflw_status == 'd')
                                {
                                    $error_msg = $reject_error_msg;
                                }
                                elseif($flw_user_id->aflw_status == 'g' || $flw_user_id->aflw_status == 'i'|| $flw_user_id->aflw_status == 'u')
                                {
                                    $error_msg = $link_expired_error_msg;
                                }
                                else
                                {
                                    $error_msg = $accept_error_msg;
                                }
                              if($flw_user_id->aflw_status == 'd' && $flw_user_id->aflw_operation == 'u' && $flw_user_id->aflw_posted_by != $flw_user_id->aflw_usr_id && ( $flw_user_id->aflw_remarks == '' || $flw_user_id->aflw_remarks == 'timeout'))
                              {
                                  $error_msg = $link_expired_error_msg;
                              }
                              if ($user_data != NULL && $user_data->usr_status != 'n')
                              {

                                  //Task#447-Import Lepra ReViewers
                                  if($user_data->usr_operation == 'b' && empty($user_data->usr_pwd))
                                  {
                                      $this->generate_email_and_send_to_reviewer($user_data);
                                  }
                                  if($btn == 'accept' && $flw_user_id->aflw_deeplink_token != '' && $accept_link_click_count <= $clk_cnt && (( $user_data->usr_status == 'a' && $flw_user_id->aflw_deeplink_token == $key) || ( $user_data->usr_status == 'w' && $user_data->usr_deeplink_token == $key)) && $flw_user_id->aflw_status == 'i')
                                  {

                                              $qry_string = '&accept_link=true&user_role=reviewer&' . $btn . '&article_id=' . $article_id . '&status_id=' . $flw_id;
                                              if($bulksubmission == true)
                                              {
                                              $qry_string = '&accept_link=true&user_role=author&' . $btn . '&article_id=' . $article_id . '&status_id=' . $flw_id.'&bulksubmission=true';
                                              }

                                              if ($flw_user_id->aflw_status == 'i')
                                              {
                                                  $without_login_token_flag=TRUE;
                                              }
                                              if ($user_data->usr_status == 'w') {
                                                  $login_session['active_status'] = 'a';

                                                  if (!empty($user_data->usr_pwd) && !empty($user_data->usr_url)) {
                                                      $this->confirm_registered_user($user_data,$user_arr,'url');
                                                  } else if ((!empty($user_data->usr_deeplink_token)) || empty($user_data->usr_pwd)) {
                                                      $this->create_user_email($user_data, $user_arr);
                                                  } else {
                                                      $User::update_record(array(
                                                          'usr_status' => 'a',
                                                              ), "usr_id={$user_id}", $user_arr);
                                                  }
                                                 $without_login_token_flag=TRUE;
                                              } else {
                                                  // in any way there is non empty usr_deeplink_token
                                                  if($flw_user_id->aflw_accept_clk_count +1 == $clk_cnt)
                                                  {
                                                  if (!empty($user_data->usr_deeplink_token)) {
                                                      //Task #5284 Reviewer invite auto-accepted - ICE
                                                      $this->Email_deeplink_click_tracker($user_data->usr_deeplink_token,'url',$user_arr);

                                                      $update_array = array(
                                                          'usr_deeplink_token' => '');
                                                      $User::update_record($update_array,"usr_id={$user_id}", $user_arr);
                                                      $user_data->usr_deeplink_token = '';
                                                      }
                                                  }
                                              }
                                              $update_array = array(
                                                  'aflw_accept_clk_count' => $accept_link_click_count);
                                                  $Article_flow::update_record($update_array,"aflw_id={$flw_id}" );
                                              if ($flw_user_id->aflw_status == 'i') {
                                                  if($flw_user_id->aflw_accept_clk_count +1 == $clk_cnt)
                                                  {
                                                      //Task #5284 Reviewer invite auto-accepted - ICE
                                                      $this->Email_deeplink_click_tracker($flw_user_id->aflw_deeplink_token,'ra',$user_arr);

                                                 $Article_flow::update_record(array(
                                                      'aflw_deeplink_token' => ''),"aflw_id={$flw_id}",NULL,NULL,'e');
                                                  }
                                              }

                                          $query_string=($flw_user_id->aflw_status == 'i') ?encrypt_link($qry_string) : NULL;
                                          $redirect_link='view-article-accept' ;

                                  }
                                  elseif (( $user_data->usr_status == 'a' && $flw_user_id->aflw_deeplink_token == $key) || ( $user_data->usr_status == 'w' && $user_data->usr_deeplink_token == $key) && $flw_user_id->aflw_status == 'i')
                                  { //if reviewer_on_fly click on accept with out clicking confirm-and-accept-review-invitation


                                          $qry_string = '&' . $btn . '&article_id=' . $article_id . '&status_id=' . $flw_id;
                                          $view_article_link = ($flw_user_id->aflw_status == 'i') ? encrypt_link($qry_string) : NULL;
                                          if($bulksubmission == true && $btn == 'accept')
                                          {
                                              $article_details = $Articles::get_article_data($article_id);

                                          }

                                          if ($flw_user_id->aflw_status == 'i')
                                          {
                                              $without_login_token_flag=TRUE;
                                          }

                                          if ($user_data->usr_status == 'w') {
                                              $login_session['active_status'] = 'a';

                                              if (!empty($user_data->usr_pwd) && !empty($user_data->usr_url)) {
                                                  $this->confirm_registered_user($user_data,$user_arr,'url');
                                              } else if ((!empty($user_data->usr_deeplink_token)) || empty($user_data->usr_pwd)) {
                                                  $this->create_user_email($user_data, $user_arr);
                                              } else {
                                                  $User::update_record(array(
                                                      'usr_status' => 'a',
                                                          ), "usr_id={$user_id}", $user_arr);
                                              }

                                          }
                                          else {
                                              // in any way there is non empty usr_deeplink_token
                                              if($flw_user_id->aflw_decline_clk_count +1 == $clk_cnt || $btn == 'accept')
                                              {
                                              if (!empty($user_data->usr_deeplink_token)) {
                                                  //Task #5284 Reviewer invite auto-accepted - ICE
                                                  $this->Email_deeplink_click_tracker($user_data->usr_deeplink_token,'url',$user_arr);

                                                  $update_array = array(
                                                      'usr_deeplink_token' => '');
                                                  $User::update_record($update_array,"usr_id={$user_id}");
                                                  $user_data->usr_deeplink_token = '';
                                                  }
                                              }
                                          }
                                          if($btn == 'reject' && $link_click_count <= $clk_cnt && $flw_user_id->aflw_status == 'i' && $flw_user_id->aflw_deeplink_token != '')
                                          {
                                          $update_array = array(
                                              'aflw_decline_clk_count' => $link_click_count);
                                              $Article_flow::update_record($update_array, "aflw_id={$flw_id}");
                                          }
                                        if ($flw_user_id->aflw_status == 'i')
                                        {
                                              if($flw_user_id->aflw_decline_clk_count +1 == $clk_cnt)
                                              {
                                                  //Task #5284 Reviewer invite auto-accepted - ICE
                                                //   $this->Email_deeplink_click_tracker($flw_user_id->aflw_deeplink_token,'ra',$user_arr);

                                              $Article_flow::update_record(array(
                                                  'aflw_deeplink_token' => ''), "aflw_id={$flw_id}",NULL,NULL,'e');
                                              }
                                            //   if ($btn == 'accept') {
                                            //     if ($user_role_manage_tab != '') {
                                            //         $query_string= encrypt_link('&status_id=' . $flw_id . '&user_role=reviewer' . '&link_click_count=' .$link_click_count.'&bulksubmission='.$bulksubmission);
                                            //     } else {
                                            //         $query_string= encrypt_link('&status_id=' . $flw_id . '&link_click_count=' .$link_click_count.'&bulksubmission='.$bulksubmission);
                                            //     }
                                            //    // $redirect_link='view-article-accept' ;
                                            //   }
                                              if ($btn == 'reject') {
                                                  //Task #5284 Reviewer invite auto-accepted - ICE
                                                  $this->Email_deeplink_click_tracker($flw_user_id->aflw_deeplink_token,'rr',$user_arr);

                                                  //#581 hide terms & conditions popup for reviewers on decline invitation
                                                  //if hide, don't show the t&c popup else show
                                                  $query_string= encrypt_link("&article_id={$article_id}&status_id={$flw_id}&show_user_terms_condition_modal={$show_tc_popup}&bulksubmission={$bulksubmission}");

                                                  $redirect_link='view-article-decline' ;
                                              }
                                              $redirect_msg=$error_msg;
                                        }
                                        else
                                        {
                                            $redirect_msg=$error_msg;
                                        }

                                      }
                                      elseif($flw_user_id->aflw_status == 'd')
                                      {
                                      $redirect_msg=$reject_error_msg;
                                      }
                                      elseif($flw_user_id->aflw_status == 'i' || $flw_user_id->aflw_status == 'g'|| $flw_user_id->aflw_status == 'u')
                                      {
                                      $redirect_msg=$link_expired_error_msg;
                                      }
                                      else
                                      {
                                      $redirect_msg=$accept_error_msg;
                                      }
                              }
                          }

                          $this->set_login_tracker('in', $user->usr_id, $request->ip());
                          if($without_login_token_flag==TRUE)
                            $return_array['token'] = $loggeddata['token'];
                          $return_array['bulksubmission'] = $bulksubmission ;
                          $return_array['client_functionality'] = $loggeddata['client_functionality'];
                          $return_array['module_status'] = $loggeddata['module_status'];
                          $return_array['profiledetails'] = $loggeddata['profile_data'];
                          $return_array['article_id']=encrypt_link($article_id);
                          $return_array['flow_id']=encrypt_link($flw_id);
                          $return_array['query_string']=$query_string;
                          $return_array['redirect_msg']=$redirect_msg;
                          $return_array['redirect_link']=$redirect_link;
                          $return_array['jnlcode']=$journal_code;
                          $return_array['roleData']=$set_user_role;


                      }

                  }
              }
          }
          return $this->success('success', 200, $return_array);
        }
        catch (\Exception $e) {
          return  $this->failure('Failed', 500, $e);
      }

  }
    // public function user_feedback($post_data)
    // {
    //     $email_jnl_to = "";
    //     $jnl_code = "";
    //     $feedback = false;
    //     $msg = "";
    //     if ($post_data['subject'] == 'dereg') {
    //         $post_data['subject'] = 'Unregister my account';
    //     }
    //     $this->load->model(array('user/User_feedback'));
    //     $this->load->library('email');
    //     $load = array('email' => $this->email, 'User_feedback' => $this->User_feedback);
    //     $this->load->library('Sendemail', array('client' => $this->current_client));
    //     if (isset($this->jnl_data)) {
    //         $jnl_code = $this->jnl_data->jnl_journal_code;
    //     }
    //     $url = base_url() . 'journal/' . $jnl_code;
    //     if ((isset($this->current_client->functionality->cfty_enable_journal_reply_to)) && ($this->current_client->functionality->cfty_enable_journal_reply_to == 'y') && (strpos($post_data['hid_current_url'], $url) !== false)) {
    //         if (isset($this->jnl_data->jset_reply_to_email) && ($this->jnl_data->jset_reply_to_email != '')) {
    //             $email_jnl_to = $this->jnl_data->jset_reply_to_email;
    //         } else {
    //             $email_jnl_to = "";
    //         }
    //     }

    //     if (!empty($post_data)) {
    //         $feedback = $this->sendemail->user_feedback_notification($load, $post_data, $email_jnl_to);
    //     }
    // }
    public function generate_email_and_send_to_reviewer($user_record)
    {
        $User = new \App\Models\User();
        $current_date_time = date('Y-m-d H:i:s');
        if ($user_record != NULL && ($user_record->usr_status == 'a'))
        {
            $user_id = $user_record->usr_id;
            $user_email = $user_record->usr_email;
            $User::update_record(array('usr_reg_date'=>$current_date_time),$user_id);
            $current_user = array(
                'user_id' => $user_record->usr_id,
            'proxy_user_id' => $user_record->usr_id);
            $send_mail = $this->create_user_email($user_record, $current_user);
        }
    }
    public function reject_unregister_user_request(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'request_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            };
            $return_arr = [];
            $form_data = $request->all();
            $unreg_id = decrypt_link($form_data['request_id']);
            $criteria = "uur_id={$unreg_id}";
            $userdetails = User_unregister::get_single_record('uur_usr_id', $criteria);
            $user_condition = "usr_id={$userdetails->uur_usr_id}";
            $recipient = User::get_single_record('*', $user_condition);        // 	if (!empty($recipient)) {
            $user_email_criteria = "etmp_name = 'unregister_diapproval' AND etmp_notification = 'User'";
            $email_template_record = Email_templates::get_single_record('*', $user_email_criteria);
            $current_user = $this->get_current_user_details();
            if ($email_template_record != NULL) {
                preg_match_all('/##([^##]*)##/', $email_template_record->etmp_email_template, $matches);
                $keys = $matches[1];

                if ($email_template_record->etmp_notification == 'User') {
                    $email_data = new stdClass;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $email_data->join_config = $this->join_config();
                    $email_data->join_dependency_config = $this->join_dependency_config();
                    $email_data->user_role_tags = $this->user_role_tags();
                    $subject = $email_template_record->etmp_subject;
                    $content = $email_template_record->etmp_email_template;
                    $user_titles = $this->UserConfigdata('titles')['titles'];
                    $email_data->user_id = $recipient->usr_id; //
                    $email_data->resend_usr_confirmation = TRUE;

                    if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
                    $content = $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);
                    $subject = $this->generate_email_data_from_keys($email_data, $subject, $current_user, $user_titles, TRUE);

                    $reply_to = '';
                    if (isset($this->current_client->email_settings['reply_to_email']) && $this->current_client->email_settings['reply_to_email'] != '') {
                        $reply_to = $this->current_client->email_settings['reply_to_email'];
                    }
                    $cc_bcc_roles = array();
                    $remove_roles = array("sudo" => "Super User", "admin" => "Admin", "report_operator" => "Report Operator");
                    $display_role = array_diff_key($this->UserConfigdata('managing_roles')['managing_roles'], $remove_roles); //
                    $usr_roles = array_values($display_role);
                    if (!empty($usr_roles)) {
                        foreach ($usr_roles as $us) {
                            $cc_bcc_roles[$us] = $us;
                        }
                    }
                    $cc_bcc_roles['Custom'] = 'Specific email ID';

                    $return_arr = array(
                        'status' => 'success',
                        'cc_bcc_roles' => $cc_bcc_roles,
                        'to_cc' => json_decode($email_template_record->etmp_cc),
                        'to_bcc' => json_decode($email_template_record->etmp_bcc),
                        'cust_cc' => $email_template_record->etmp_cust_cc,
                        'cust_bcc' => $email_template_record->etmp_cust_bcc,
                        'reply_to' => $reply_to,
                        'subject' => $subject,
                        'content' => $content,
                        'user' => $userdetails->uur_usr_id,
                    );
                } else {
                    $return_arr = array(
                        'status' => 'warning',
                        'msg' => 'Not defined email template properly'
                    );
                    if (!in_array('CONFIRMATION_URL', $keys))
                        $return_arr['msg'] = '##CONFIRMATION_URL## tag missing in Confirmation Mail';
                }
            } else {
                $return_arr = array(
                    'status' => 'template_err',
                    'msg' => 'No email template defined'
                );
            }
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function delete_unregister_request(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'hdn_usr_id'      => 'required',
                'email_subject'      => 'required',
                'email_content'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $form_data = $request->all();
            $jnl_id = '';
            $recipient_id = decrypt_link($form_data['hdn_usr_id']);
            $user_criteria = "usr_id = {$recipient_id}";
            $user_select = "usr_id, usr_email, usr_deeplink_token, usr_pwd, usr_url, usr_status, usr_first_name, usr_last_name,usr_jnl_standalone";
            $recipient_detail = User::get_single_record($user_select, $user_criteria);
            if (!empty($recipient_detail)) {

                $user_data['user_id'] = $recipient_id;
                $user_data['proxy_user_id'] = NULL;

                $subject = $request['email_subject'];
                $body = $request['email_content'];
                $email_template = array(
                    'etmp_name' => 'unregister_diapproval',
                    'etmp_cust_to' => '',
                    'etmp_bcc' => '',
                    'etmp_cc' => '',
                    'etmp_cust_cc' => '',
                    'etmp_cust_bcc' => '',
                    'etmp_subject' => $subject,
                    'etmp_email_template' => $body,
                    'etmp_notification' => 'User'
                );

                $email_data = new stdClass;
                $email_data->subject = $subject;
                $email_data->body = $body;
                $reply_to=$this->get_reply_to_email($jnl_id);
                $email_data->reply_to = $reply_to;
                $email_data->user_email = $recipient_detail->usr_email;
                $email_data->mail_recipient_ids = $recipient_detail->usr_id;
                $email_data->user_id = $recipient_detail->usr_id;

                $email_data->email_templates_config = $this->email_templates_config();
                $email_data->join_config = $this->join_config();
                $email_data->join_dependency_config = $this->join_dependency_config();
                $email_data->user_role_tags = $this->user_role_tags();


                $current_user = $this->get_current_user_details();
				$request_id = decrypt_link($request['hdn_usr_id']);
                $update_array = array(
                    'usr_status' => 'a'
                );
                $usr_criteria = "usr_id = {$request_id}";
                $usr_unreg_criteria = "uur_usr_id = {$request_id}";
				$usr_update = User::update_record($update_array,$usr_criteria,$current_user);
				$res = User_unregister::delete_records($usr_unreg_criteria, '', $current_user);
				$return_arr = array();
                $this->send_email_notification((object)$email_template, $email_data, $user_data, 'etmp_');
                $return_arr['status'] = 'success';
            } else {
                $return_arr['msg'] = 'Recipient not exists';
                $return_arr['status'] = 'Failed';
            }
            // print_r($return_arr);die;
            // $return_arr['email'] = $return_arr;
            return $this->success('success', 200, $return_arr);
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function check_author_invitation(Request $request)
    {
        try {
            $post_data = $request->all();
            $return_array = array();
            $return_array['user_id'] = '';
            $return_array['msg'] = '';
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            $return_array['verifi'] = FALSE;
            $redirect_link='preview-article';
            $redirect_msg='';
            $query_string='';
            $without_login_token_flag=FALSE;
            if ($post_data['select'] != NULL) {
                $user_id = isset($_GET['userid']) ? $_GET['userid'] : '';
                $ukey = isset($_GET['ukey']) ? $_GET['ukey'] : '';
                $akey = isset($_GET['akey']) ? $_GET['akey'] : '';
                $articletype_id = isset($_GET['articletype_id']) ? $_GET['articletype_id'] : '';
                $article_id = isset($_GET['article_id']) ? $_GET['article_id'] : '';
                $article_id = decrypt_link($article_id);
                if ($user_id != NULL) {
                    $verify_userid = $this->validate_exist_user($user_id);
                    if ( $verify_userid == TRUE) {
                        $return_array['verifi'] = TRUE;
                        $Authzorize = new \App\Models\Authorize();
                        $user = $Authzorize::where('usr_id', $user_id)->get()->first();
                        $current_user = array(
                            'user_id' => $user->usr_id,
                            'proxy_user_id' => $user->usr_id
                        );
                        $loggeddata = $this->set_user_loggin($user->usr_id);
                        if (!empty($loggeddata) && $user != NULL && $user->usr_status != 'n') {
                            if($user->usr_operation == 'b' && empty($user->usr_pwd)){
                                $this->generate_email_and_send_to_reviewer($user);
                            }
                            $get_co_author_detail = Authors::get_single_record('auth_deeplink_token,auth_deeplink_token_attempts', 'auth_usr_id=' . $user_id . ' AND auth_art_id=' . ($article_id));
                            if (!empty($get_co_author_detail) && $get_co_author_detail->auth_deeplink_token == $akey && $get_co_author_detail->auth_deeplink_token_attempts >= 1) {
                                $number_of_attempts = $get_co_author_detail->auth_deeplink_token_attempts - 1;
                                    if (!empty($user->usr_pwd) && !empty($user->usr_url)) {
                                        $this->confirm_registered_user($user, $current_user,'url');
                                    } else if ((!empty($user->usr_deeplink_token)) && empty($user->usr_pwd)) {
                                        $this->create_user_email($user, $current_user);
                                    } 
                                    else {
                                            User::update_record(array(
                                                'usr_status' => 'a'), ('usr_id=' . $user_id));
                                    }
                                if($number_of_attempts >= 1)
                                {
                                    User::update_record(array('usr_deeplink_token_attempts' => $number_of_attempts), ('usr_id=' . $user_id));
                                    Authors::update_record(array('auth_deeplink_token_attempts' => $number_of_attempts), ('auth_usr_id=' . $user_id));
                                }        
                                if($number_of_attempts == 0)
                                {
                                    Authors::update_record(array('auth_deeplink_token' => '', 'auth_deeplink_token_attempts' => NULL), 'auth_usr_id =' . $user_id . ' AND auth_art_id=' . ($article_id));
                                    User::update_record(array('usr_deeplink_token' => '', 'usr_deeplink_token_attempts' => NULL), 'usr_id =' . $user_id );
                                }
                               
                               

                                $art_flow_detail = Article_flow::get_single_record('aflw_id', 'aflw_art_id=' . $article_id);
                                $arti_type_details = Article_types::get_single_record('artp_jnl_id,artp_abbr_article_type', 'artp_id=' . $articletype_id);
                                $status_id = $art_flow_detail->aflw_id;
                                $arti_type_code = $arti_type_details->artp_abbr_article_type;
                                $journal_table=(new \App\Models\Journals())->getTable();
                                $article_table=(new \App\Models\Articles())->getTable();
                                $article_type_table=(new \App\Models\Article_types())->getTable();
                                $sql = "SELECT jnl_journal_name,jnl_journal_code FROM {$journal_table} INNER JOIN $article_type_table ON jnl_id = artp_jnl_id INNER JOIN {$article_table} ON artp_id=art_artp_id WHERE art_id = " . $article_id;
                                $jnl_details = Journals::get_records_by_raw_query($sql);

                                // print_r(($jnl_details));die;
                                $this->set_login_tracker('in', $user->usr_id, $request->ip());
                                $return_array['token'] = $loggeddata['token'];
                                $return_array['client_functionality'] = $loggeddata['client_functionality'];
                                $return_array['module_status'] = $loggeddata['module_status'];
                                $return_array['profiledetails'] = $loggeddata['profile_data'];
                                $return_array['arti_type_code'] = $arti_type_code;
                                $return_array['articletype_id']=encrypt_link($articletype_id);
                                $return_array['article_id']=encrypt_link($article_id);
                                $return_array['flw_id']=encrypt_link($status_id);
                                $return_array['query_string']=$query_string;
                                $return_array['redirect_msg']=$redirect_msg;
                                $return_array['redirect_link']=$redirect_link;
                                $return_array['jnlcode']=$jnl_details[0]->jnl_journal_code;
                            } 
                            else {
                                $return_array['redirect_msg']=customTrans('users.author_seek_confirm');
                            }
                        }
                    }
                }
                return $this->success('success', 200, $return_array);
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_registration_generic_form(Request $request)
    {
        try{
            /*  Stand-alone not checked*/
            $Generic_forms=new \App\Models\Generic_forms();
            $reg_form_id =NULL;
            $criteria = 'gncf_form_type = "feedback_form"';
            $reg_generic_form = $Generic_forms::get_single_record('*',  $criteria);
            return $this->success('success', 200, $reg_generic_form);

        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function check_recent_passwords($userid,$password)
    {
        try{
            $return_arr = array('status'=>'success');
            $User_password_history=new \App\Models\User_password_history();
            $where_condi = 'pash_usr_id ='.$userid;
            $urlsetting= 'general_config';
            $click_count= Config::get($urlsetting);
            $password_cnt=$click_count['password_count'];
            $sql_raw_query  = 'SELECT  pash_pwd from rvw_password_history where pash_usr_id=' . $userid . ' ORDER BY pash_id DESC LIMIT '.$password_cnt;
            $check_recent_psw=  $User_password_history::get_records_by_raw_query($sql_raw_query);
            // $check_recent_psw = $User_password_history::get_all_records('pash_pwd',$where_condi,'pash_id',$password_cnt,'','','DESC');
            $recent_ten_psw = FALSE;
            if(!empty($check_recent_psw))
            {
            foreach($check_recent_psw as $single_psw)
            {
                if(Hash::check($password, $single_psw->pash_pwd))
                {
                        $recent_ten_psw = TRUE;
                        break;
                    }
                }
            }
            if($recent_ten_psw == TRUE)
            {
                $return_arr['status'] = 'failed';
            }
            return $recent_ten_psw;
            // echo json_encode($return_arr);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function client_terms_data(Request $request)
    {
        try{
            $return_array['client_name']=$this->current_client->clnt_client_name;
            $return_array['terms_data']=$this->current_client->clnt_review_terms;
            $cs_tbl = new \App\Models\Client_settings();
            $client_settings= $cs_tbl::get_client_settings_using_client_code('cs_show_reg_feedback_frm', $this->current_client->clnt_client_code);
            $return_array['cs_show_reg_feedback_frm']=$client_settings[0]->cs_show_reg_feedback_frm;
            return $this->success('Success', 200, $return_array);

        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function view_article_status(Request $request)
    {
        try {
            $post_data = $request->all();
            $return_array = array();
            $return_array['user_id'] = '';
            $return_array['msg'] = '';
            parse_str($this->decrypt_data($post_data['select']), $_GET);
            $return_array['verifi'] = FALSE;
            $redirect_link = '';
            $redirect_msg = '';
            $query_string = '';

            if ($post_data['select'] != NULL) {
                $user_id = isset($_GET['usr_id']) ? $_GET['usr_id'] : '';
                $key = isset($_GET['key']) ? $_GET['key'] : '';
                $flw_id = isset($_GET['status_id']) ? $_GET['status_id'] : '';
                $article_id = isset($_GET['article_id']) ? $_GET['article_id'] : '';
                $journal_code = isset($_GET['jnl_code']) ? $_GET['jnl_code'] : '';
                $article_type_table = (new \App\Models\Article_types())->getTable();
                $article_table = (new \App\Models\Articles())->getTable();
                $journal_table = (new \App\Models\Journals())->getTable();
                if(!empty($article_id)) {
                $sql = "SELECT jnl_journal_name,jnl_journal_code FROM {$journal_table} INNER JOIN $article_type_table ON jnl_id = artp_jnl_id INNER JOIN {$article_table} ON artp_id=art_artp_id WHERE art_id = " . $article_id;
                $jnl_name = Journals::get_records_by_raw_query($sql);
                if ($user_id != NULL) {
                    $verify_userid = $this->validate_exist_user($user_id);
                    if ($verify_userid == TRUE) {
                        $return_array['verifi'] = TRUE;
                        $Authzorize = new \App\Models\Authorize();
                        $user = $Authzorize::where('usr_id', $user_id)->get()->first();
                        $loggeddata = $this->set_user_loggin($user->usr_id);
                        if (!empty($loggeddata)) {
                            $user_arr = array(
                                'user_id' => $user_id,
                                'proxy_user_id' => $user_id
                            );
                            $without_login_token_flag = FALSE;

                            if (isset($this->current_client->functionality->cfty_enable_google_mfa) && $this->current_client->functionality->cfty_enable_google_mfa == 'y') {
                                $skip_2fa = TRUE;
                                $return_array['skip_2fa'] = TRUE;
                            }
                            $check_article_status_condition = "aslnks_deeplink_token = '{$key}' AND aslnks_usr_id = {$user_id} AND aslnks_flw_id = {$flw_id}";
                            $get_result = Article_status_link_statistics::get_single_record('COUNT(aslnks_id) as cnt', $check_article_status_condition);

                            $roles_ids = array_column(json_decode(json_encode(Roles::get_all_records('role_id', 'role_assigned_role != "system"')), True), 'role_id');
                            $has_any_role = $this->check_journal_permission_with_role_ids($roles_ids, $journal_code, NULL, $user_id);

                            if ($has_any_role == TRUE) {
                                $check_flow_condition = "aflw_id = {$flw_id} AND aflw_art_id = {$article_id}";
                                $check_flow = Article_flow::get_single_record('COUNT(aflw_id) as cnt,aflw_status', $check_flow_condition);
                            }
                            if ($has_any_role == TRUE && !empty($check_flow) && $check_flow->cnt > 0) {

                                if (!empty($get_result) && $get_result->cnt < 10) {
                                    $go_to = '';
                                    $redirect_link = '/journal/' . $journal_code;

                                    // check article author or not
                                    $author_article_condition = "auth_art_id ={$article_id} AND auth_usr_id = {$user_id}";
                                    $is_article_authors = Authors::get_single_record('COUNT(auth_usr_id) as cnt', $author_article_condition);
                                    $query_string = encrypt_link('&article_id=' . $article_id . '&status_id=' . $flw_id);
                                    $mng_production = $this->is_article_in_production_management($article_id, $flw_id);

                                    if ($mng_production['status'] == TRUE) {
                                        $go_to = '/view-article-production?' . $query_string;
                                        if (!empty($is_article_authors) && $is_article_authors->cnt > 0)
                                            $go_to = '/author-article-production?' . $query_string;
                                    } else {
                                        $go_to = '/view-article?' . $query_string;
                                        if (!empty($is_article_authors) && $is_article_authors->cnt > 0)
                                            $go_to = '/author-article?' . $query_string;
                                    }
                                    $this->set_login_tracker('in', $user->usr_id, $request->ip());
                                    /*
                                    $agent = new Agent();
                                    if ($agent->isBrowser()) {
                                        $browser = $agent->browser();
                                        $agent =    $agent->browser() . ' ' . $agent->version($browser);
                                    } elseif ($agent->isRobot()) {
                                        $agent = $agent->robot();
                                    } elseif ($agent->isMobile()) {
                                        $agent = $agent->mobile();
                                    } else {
                                        $agent = '--';
                                    }
                                    */
                                    $browser = Agent::browser();
                                    $b_version = Agent::version($browser);
                                    $agentName = $browser . ' ' . $b_version;
                                    $platform = Agent::platform();
                                    $p_version = Agent::version($platform);
                                    if ($p_version !== FALSE) {
                                        $platform = $platform . ' ' . $p_version;
                                    }
                                    $ip = $request->ip();
                                    $user_data = $user_arr;

                                    $insert_data = array(
                                        'aslnks_ip' => $ip,
                                        'aslnks_browser' => $agentName,
                                        'aslnks_os' =>  $platform,
                                        'aslnks_art_id' => $article_id,
                                        'aslnks_flw_id' => $flw_id,
                                        'aslnks_deeplink_token' => $key,
                                        'aslnks_usr_id' => $user_id
                                    );
                                    Article_status_link_statistics::insert_record($insert_data, $user_data);
                                    $return_array['token'] = $loggeddata['token'];
                                    $return_array['client_functionality'] = $loggeddata['client_functionality'];
                                    $return_array['module_status'] = $loggeddata['module_status'];
                                    $return_array['profiledetails'] = $loggeddata['profile_data'];
                                    $return_array['article_id'] = encrypt_link($article_id);
                                    $return_array['flow_id'] = encrypt_link($flw_id);
                                    $return_array['query_string'] = $go_to;
                                    $return_array['redirect_msg'] = $redirect_msg;
                                    $return_array['redirect_link'] = $redirect_link;
                                    $return_array['jnlcode'] = $journal_code;

                                    return $this->success('success', 200, $return_array);
                                    // return $return_array;
                                } else {
                                    $redirect_msg = 'Link has expired';
                                    $return_array['redirect_msg'] = $redirect_msg;
                                    return $this->success('success', 200, $return_array);
                                }
                            } else {
                                    $redirect_msg = 'Link has expired';
                                    $return_array['redirect_msg'] = $redirect_msg;
                                return $this->success('success', 200, $return_array);
                                // return $return_array;
                            }
                        }
                    }
                }
                }
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function test_mail_reply(Request $request)
    {
        try{
            $hostname = '{mail.your-server.de:993/imap/ssl}INBOX';
            $username = 'noreply-reporting@rivervalleytechnologies.in';
            $password = 'b63JddJAwZwzDuz5';
            //print_r($hostname. '     '.$username.'       '.$password.'        ');
            $afterdetails = array();
            $mailbox = imap_open($hostname, $username, $password);
        if (!$mailbox) {
            return "Failed to connect to mailbox: " . imap_last_error();
        }
        // Fetch email headers
        // $emails = imap_search($mailbox, 'UNSEEN'); // Fetch only unread emails
        // $emails = imap_search($mailbox, 'SEEN'); // Fetch only read emails
        $searchToAddress = 'test123123@rivervalleytechnologies.in';
        $searchCriteria = "TO \"$searchToAddress\"";
        $emails = imap_search($mailbox, $searchCriteria); // Search for emails where the specified email address is in the "To" field
            //print_r($emails);
        if ($emails) {
            foreach ($emails as $email_number) {
                $mail_data = [];
                $email = imap_fetch_overview($mailbox, $email_number, 0);

            //print_r($email);
            
                $mail_data['content'] = imap_fetchbody($mailbox, $email_number, "1");
                $mail_data['subject'] = $email[0]->subject;
                $mail_data['from'] = $email[0]->from;
                $header_info = imap_headerinfo($mailbox, $email_number);
                $mail_data['to'] = $header_info->toaddress;
                $mail_date = $email[0]->date;  
                $mail_data['date'] =$mail_date->format('Y-m-d H:i:s'); 
                // Get email attachments
                $attachments = $this->getAttachments($mailbox, $email_number);
                $mail_data['attachments'] = $attachments; 
                $ccBccInfo = $this->getCCandBCC($mailbox, $email_number);
    		    $mail_data['cc'] = $ccBccInfo['cc'];
    		    $mail_data['bcc'] = $ccBccInfo['bcc'];
                array_push($afterdetails,$mail_data);
                if($attachments){
                   // print_r($attachments);
                    $this->saveAttachments($attachments);
                }
            }
          }
          // Close the mailbox
          imap_close($mailbox);
          //print_r($afterdetails);
          //return $this->success('success', 200, $afterdetails);
          return $this->success('success', 200, []);
        } catch (\Exception $e) {
           // print_r($e);
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function getAttachments($inbox, $email_number) {
        $attachments = [];
        $structure = imap_fetchstructure($inbox, $email_number);
        if (isset($structure->parts) && count($structure->parts) > 0) {
            foreach ($structure->parts as $part_number => $part) {
               // print_r($part);
                if (isset($part->disposition, $part->dparameters[0]->value)) {
                    $attachment = [
                        'filename' => $part->dparameters[0]->value,
                        'content' => decrypt_link(imap_fetchbody($inbox, $email_number, $part_number + 1)),
                    ];
                    $attachments[] = $attachment;
                //print_r($attachments);
            }
            }
        }
        return $attachments;
    }
    public function saveAttachments($attachments) 
   {
    foreach ($attachments as $attachment) {
        $filename = $attachment['filename'];
        $content = $attachment['content'];
        $fullpath = "uploads" . DIRECTORY_SEPARATOR . 'email_attachments/934';
        // Define the local path where you want to save the attachments
        $localPath = storage_path("app/public/{$filename}");
        file_put_contents($localPath, $content);
        // Store the file in the "public" disk
        Storage::disk('public')->putFileAs($fullpath, $localPath, $filename);
        // Save the attachment content to the local file
        file_put_contents($localPath, $content);
        // You can also perform any additional processing here if needed
        unlink($localPath);
    	}
   }
   public function getCCandBCC($inbox, $email_number) 
   {
    $headers = imap_fetchheader($inbox, $email_number);

    preg_match('/^Cc:(.*?)(?=\r?\n\S|\Z)/ms', $headers, $matchesCc);
    preg_match('/^Bcc:(.*?)(?=\r?\n\S|\Z)/ms', $headers, $matchesBcc);

    $cc = isset($matchesCc[1]) ? $matchesCc[1] : null;
    $bcc = isset($matchesBcc[1]) ? $matchesBcc[1] : null;

    return ['cc' => $cc, 'bcc' => $bcc];
   }
}
