<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Reports_email;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use App\Models\Reports_model;
use App\Models\Reports_folder_model;
use Config;
use DB;
use App\Http\Controllers\Report_generation_Api;
use App\Jobs\ReportGenerationJob;
use App\Models\Report_email_sent_log;
use DateTime;
use \Mpdf\Mpdf as PDF;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response as FacadesResponse;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
ini_set('max_execution_time', 300);
ini_set('memory_limit', '512M');
class Manage_Reports_Api extends Controller
{
    public function getReportConfig(Request $request)
    {
        try {
            $post_data   = $request->all();
            // $validationArr = array(
            //     'report_id'  => 'required',
            // );
            // $validator = Validator::make($post_data, $validationArr);
            // if ($validator->fails()) 
            // {
            //     return  $this->failure('Failed', 422, $validator->errors());
            // }
            // $input_arr = array(
            //     'input' => $post_data['report_id'],
            //     'type'  => 'number',
            //     'rv_enc_data' => true
            // );
            // $report_id_validate = $this->Rv_validator($input_arr);     
            // if($report_id_validate == false)
            // {
            //     $arraymsg['mesage'] = customTrans('validation.notvalid');
            //     return $this->warning("Failed", 200, $arraymsg);
            // }
            $report_types = $this->Utility('report_type');
            $report_format = $this->Utility('report_format');
            $report_period = $this->Utility('report_period');
            $rtn_array = array(
                'report_type' => $report_types['report_type'],
                'report_format' => $report_format['report_format'],
                'report_period' => $report_period['report_period']
            );
            $rtn_array['report_basic_data'] = array();
            if (isset($post_data['report_id']) && !empty($post_data['report_id'])) {
                $report_id = Rv_decrypt($post_data['report_id']);
                $rtn_array['report_basic_data'] = Reports_model::get_single_record("*", 'rep_id =' . $report_id);
                if (!empty($rtn_array['report_basic_data'])) {
                    /* email settings */
                    $criteria = 'rmil_rep_id =' . $rtn_array['report_basic_data']->rep_id;
                    $rtn_array['report_basic_data']->rep_type_str = $report_types['report_type'][$rtn_array['report_basic_data']->rep_type];
                    $rtn_array['report_basic_data']->email_settings = Reports_email::get_all_records('*', $criteria);
                    if (!empty($rtn_array['report_basic_data']->email_settings)) {
                        foreach ($rtn_array['report_basic_data']->email_settings as $email) {
                            $email->report_period_str = $report_period['report_period'][$email->rmil_report_period];
                            $email->report_cc_arr = array();
                            if ($email->rmil_send_cc != '') {
                                $email->report_cc_arr = explode(',', $email->rmil_send_cc);
                            }
                        }
                    }
                    /* array of parents folders if any */
                    $enc_folder_ids    =    null;
                    if($rtn_array['report_basic_data']->rep_rfld_id != null){
                        $arr = [];
                        $this->find_parent_folders($arr, $rtn_array['report_basic_data']->rep_rfld_id);
                        $enc_folder_ids=    $this->encrypt_folder_ids($arr);
                        array_push($enc_folder_ids,"home");
                    }
                    $rtn_array['report_basic_data']->parent_folder_ids = $enc_folder_ids;
                }
                $current_page = 1;
                $generated_on = '';
                $xml = (new Report_generation_Api())->report_xml($report_id, 'read');
                $data_Element = $xml->getElementsByTagName('generated_report');
                if($data_Element->item(0)->nodeValue != ''){
                    $generated_report = json_decode($data_Element->item(0)->nodeValue);
                    $current_page = $generated_report->current_page;
                    $generated_on = $data_Element->item(0)->getAttribute("generated-date");
                }
                $timezone = config('app.timezone');
                $rtn_array["xml_data"] = array(
                    'generated_date' => $generated_on,
                    "current_page"   => $current_page,
                    "time_zone"      => $timezone
                );
            }
            $is_super_admin = false;
            $permitted_roles = array('sudo', 'super_admin');
            $current_user = $this->get_current_user_details();
            if (isset($current_user['roles']) && !empty(array_intersect($permitted_roles, $current_user['roles']))) {
                $is_super_admin = true;
            }
            $rtn_array['is_super_admin'] = $is_super_admin;
            //get folder only structure
            $rtn_array["reports_folder_data"] = null;
            $reports_folder_structure = $this->get_report_folders();
            if (count($reports_folder_structure) > 0) {
                $rtn_array["reports_folder_data"] = json_decode(json_encode($reports_folder_structure));
            }
            return $this->success('success', 200, $rtn_array);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function reportList(Request $request)
    {
        try {
            $report_table = (new \App\Models\Reports_model())->getTable();
            $tbk_report_table = Reports_model::$tbk_table;
            $report_folder_table = (new \App\Models\Reports_folder_model())->getTable();
            $tbk_report_folder_table = Reports_folder_model::$tbk_table;
            $data   = $request->all();
            $sort_field = (isset($data['sort_field'])) ? $data['sort_field'] : 'title';
            $sort_order =  (isset($data['sort_order'])) ? $data['sort_order'] : 'asc';
            $limit  = $data['per_page'] ? $data['per_page'] : 10000;
            
            /* created by list - starts */
            $return_array['created_by'] = Reports_model::get_posted_by();
            /* created by list - ends */

            /* report+folder list - starts */
            $date_format = $this->get_platform_date_format();
            $date_format = date_format_map($date_format);
            $report_criteria = 'rep_parent Is NULL AND rep_title != ""';
            $folder_criteria = 'rfld_parent_id Is NULL';
            $common_having_criteria = '';
            $is_filtered = false;
            if (isset($data['filterVal']) && !empty($data['filterVal'])) {
                if (isset($data['filterVal']['report_title']) && !empty($data['filterVal']['report_title'])) {
                    $is_filtered = true;
                    $report_criteria .= ' AND LOWER(rep_title) LIKE LOWER("%' . $data['filterVal']['report_title'] . '%")';
                    $folder_criteria = ' LOWER(rfld_title) LIKE LOWER("%' . $data['filterVal']['report_title'] . '%")';
                }
                if (isset($data['filterVal']['report_type']) && !empty($data['filterVal']['report_type'])) {
                    $is_filtered = true;
                    $report_criteria .= ' AND LOWER(rep_type) LIKE LOWER("%' . $data['filterVal']['report_type'] . '%")';
                    $folder_criteria = ' rfld_id IS NULL ';
                }
                if (isset($data['filterVal']['created_by']) && !empty($data['filterVal']['created_by'])) {
                    $is_filtered = true;
                    $common_having_criteria = ' posted_by_id=' . Rv_decrypt($data['filterVal']['created_by']);
                }
                if (isset($data['filterVal']['select_create_date_type']) && !empty($data['filterVal']['select_create_date_type'])) {
                    $is_filtered = true;
                    if ($data['filterVal']['select_create_date_type'] == 'd' && $data['filterVal']['created_on'] != '') {
                        if($common_having_criteria != ''){
                            $common_having_criteria .= " AND ";
                        }
                        $common_having_criteria .= " DATE(posted_date) ='" . $data['filterVal']['created_on'] . "'";
                    }
                    if ($data['filterVal']['select_create_date_type'] == 'dr' && $data['filterVal']['created_date_start'] != '' && $data['filterVal']['created_date_end'] != '') {
                        if($common_having_criteria != ''){
                            $common_having_criteria .= " AND ";
                        }
                        $common_having_criteria .= " posted_date BETWEEN '" . $data['filterVal']['created_date_start'] . " 00:00:00'" . " AND '" . $data['filterVal']['created_date_end'] . " 23:59:59'";
                    }
                }
            }
            $folder_id = null;
            if(isset($data['folder_id']) && !empty($data['folder_id'])){
                $folder_id = Rv_decrypt($data['folder_id']);
                $report_criteria .= ' AND rep_rfld_id = ' . $folder_id;
                $folder_criteria = ' rfld_parent_id = ' . $folder_id;
            }else{
                if ($is_filtered == false) 
                $report_criteria .= " AND rep_rfld_id IS NULL";
            }
            $folder_columns = "'folder' AS type, 
            rfld_id AS id, 
            rfld_title AS title, 
            '' AS report_type, 
            '' AS is_locked, 
            (
            SELECT 
                MIN(rfld_posted_date) 
            FROM 
                $tbk_report_folder_table rf 
            WHERE 
                rf.`rfld_id` = id
            ) AS posted_date, 
            (
            SELECT 
                usr_id 
            FROM 
                $tbk_report_folder_table rf2 
                LEFT JOIN `rvw_users` ON rf2.`rfld_posted_by` = `usr_id` 
            WHERE 
                rf2.`rfld_id` = id 
            ORDER BY 
                tbk_id ASC 
            LIMIT 
                1
            ) AS posted_by_id, 
            rfld_posted_date AS updated_date, 
            usr_id AS updated_by_id, 
            (
            SELECT 
                COUNT(*) 
            FROM 
                $report_folder_table rf3 
            WHERE 
                rf3.`rfld_parent_id` = id
            ) AS child_cnt, 
            '' AS folder_id";
            $report_columns = "'file' AS type, 
            rep_id AS id, 
            rep_title AS title, 
            CONCAT(
                UPPER(
                LEFT(rep_type, 1)
                ), 
                LOWER(
                SUBSTRING(rep_type, 2)
                )
            ) AS report_type, 
            rep_locked AS is_locked, 
            (
                SELECT 
                MIN(rep_posted_date) 
                FROM 
                $tbk_report_table r 
                WHERE 
                r.`rep_id` = id
            ) AS posted_date, 
            (
            SELECT 
                usr_id 
            FROM 
                $tbk_report_table r2 
                LEFT JOIN `rvw_users` ON r2.`rep_posted_by` = `usr_id` 
            WHERE 
                r2.`rep_id` = id 
            ORDER BY 
                tbk_id ASC 
            LIMIT 
                1
            ) AS posted_by_id,  
            (
                SELECT 
                MAX(rep_posted_date) 
                FROM 
                $report_table r3 
                WHERE 
                r3.`rep_parent` = id 
                OR r3.`rep_id` = id
            ) AS updated_date, 
            (
                SELECT 
                usr_id  
                FROM 
                $tbk_report_table r4 
                LEFT JOIN `rvw_users` ON r4.`rep_posted_by` = `usr_id` 
                WHERE 
                r4.`rep_parent` = id OR r4.`rep_id` = id
                ORDER BY 
                tbk_id DESC
                LIMIT 1
            ) as updated_by_id, 
            0 AS child_cnt, 
            rep_rfld_id AS folder_id";
            // DB::enableQueryLog();
            $report_list  = Reports_model::get_report_list($report_columns, $folder_columns, $report_criteria, $folder_criteria, $common_having_criteria, $sort_field, $sort_order, $limit);
            // $query = DB::getQueryLog();$query = end($query);dd($query);
            if (!empty($report_list)) {
                $report_period = $this->Utility('report_period');
                foreach ($report_list as $report) {
                    $displayArray = array(
                        'user_id'       => $report->posted_by_id
                    );
                    $report->posted_by = $this->get_user_display_name( $displayArray );
                    $displayArray = array(
                        'user_id'       => $report->updated_by_id
                    );
                    $report->updated_by = $this->get_user_display_name( $displayArray );
                    if($report->updated_date == ''){
                        $report->updated_date = $report->posted_date;
                    }
                    $report->posted_date = date($this->current_client->settings->cs_date_format, strtotime(trim($report->posted_date)));
                    $report->updated_date = date($this->current_client->settings->cs_date_format, strtotime(trim($report->updated_date)));
                    $report->email_settings = [];
                    if($report->type == 'file'){
                        $criteria = 'rmil_rep_id =' . $report->id;
                        $report->email_settings = Reports_email::get_all_records('*', $criteria);
                        if (!empty($report->email_settings)) {
                            foreach ($report->email_settings as $email) {
                                $email->report_period_str = $report_period['report_period'][$email->rmil_report_period];
                                $email->report_cc_arr = array();
                                if ($email->rmil_send_cc != '') {
                                    $email->report_cc_arr = explode(',', $email->rmil_send_cc);
                                }
                            }
                        }
                    }
                    $enc_folder_ids    =    null;
                    if($report->type == 'folder'){
                        //parent folder ids of current folder in array format
                        $arr = [];
                        $this->find_parent_folders($arr, $report->id);
                        $enc_folder_ids=    $this->encrypt_folder_ids($arr);
                        array_push($enc_folder_ids,"home");
                    }else if($report->type == 'file' && $report->folder_id != ''){
                        //parent folder ids of report in array format
                        $arr = [];
                        $this->find_parent_folders($arr, $report->folder_id);
                        $enc_folder_ids=    $this->encrypt_folder_ids($arr);
                        array_push($enc_folder_ids,"home");
                    }
                    $report->parent_folder_ids = $enc_folder_ids;
                    // print_r($report);die;
                }
            }
            $return_array['report_list'] = $report_list;
            /* report+folder list - ends */

            /* folder data - starts */
            $return_array["reports_folder_data"] = null;
            $initial_fixed_sort_order = $data['initial_fixed_sort'];
            $reports_folder_structure = $this->get_report_folders('', true, $initial_fixed_sort_order);
            if (count($reports_folder_structure) > 0) {
                $return_array["reports_folder_data"] = json_decode(json_encode($reports_folder_structure));
            }
            $array_date = platform_date_format();
            $return_array['date_format'] = $array_date[$this->current_client->settings->cs_date_format];
            /* folder data - ends */

            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) {
            // dd($e);
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function createSummaryReport(Request $request)
    {
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'report_title'  => 'required',
                // 'report_type'   => 'required',
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $input_arr = array(
                'input' => $post_data['report_title'],
                'type'  => 'string'
            );
            $report_title_validate = $this->Rv_validator($input_arr);
            $input_arr['input'] = $post_data['report_type'];
            $report_type_validate = $this->Rv_validator($input_arr);
            $report_id = '';
            if (isset($post_data['report_id']) && !empty($post_data['report_id'])) {
                $report_id = Rv_decrypt($post_data['report_id']);
                $input_arr = array(
                    'input' => $post_data['report_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_id_validate = $this->Rv_validator($input_arr);
                if ($report_id_validate == false) {
                    $arraymsg['mesage'] = customTrans('validation.notvalid');
                    return $this->warning("Failed", 200, $arraymsg);
                }
            }
            // && $report_type_validate == false
            if (!preg_match('/^[A-Za-z0-9\(\)\&\-\_ ]+$/', $post_data['report_title'])) {
                $report_title_validate = false;
            }
            if ($report_title_validate == false) {
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            DB::beginTransaction();
            /* Report Folder Add/edit - starts */
            $report_folder_id = null;
            if (isset($post_data['addToAFolder']) && !empty($post_data['addToAFolder']) && $post_data['addToAFolder'] == 'y') {
                if (isset($post_data['addtoNewFolder']) && $post_data['addtoNewFolder'] == false) {
                    $report_folder_id = null;
                    if (isset($post_data['parent_folder_id']) && !empty($post_data['parent_folder_id'] && $post_data['parent_folder_id'] != 'home')) {
                        $report_folder_id = Rv_decrypt($post_data['parent_folder_id']);
                    }
                } else {
                    if (!preg_match('/^[A-Za-z0-9\(\)\&\-\_ ]+$/', $post_data['folder_title'])) {
                        $arraymsg['mesage'] = customTrans('validation.notvalid');
                        return $this->warning("Failed", 200, $arraymsg);
                    }
                    $parent_folder_id = null;
                    if (isset($post_data['parent_folder_id']) && !empty($post_data['parent_folder_id'] && $post_data['parent_folder_id'] != 'home')) {
                        $parent_folder_id = Rv_decrypt($post_data['parent_folder_id']);
                    }else if($post_data['parent_folder_id'] == 'home'){
                        $parent_folder_id = $post_data['parent_folder_id'];
                    }
                    $add_folder_status = $this->create_folder( $post_data['folder_title'], $parent_folder_id);
                    if ($add_folder_status['status'] == 'error') {
                        return $this->success($rtn_arr['status'], 200, $add_folder_status);
                    } else {
                        $report_folder_id = $add_folder_status['folder_id'];
                    }
                }
            }
            // print_r($report_folder_id);
            // echo'end';die;
            /* Report Folder Add/edit - ends */


            //Report Add/Edit - starts
            $insert_data = array(
                'rep_title' => $post_data['report_title'],
                'rep_type'  => $post_data['report_type'] ?? 'article',
                'rep_rfld_id' => $report_folder_id
            );

            $select = '*';
            $criteria = 'rep_title = "' . $post_data['report_title'] . '"' ;//. '" AND rep_type = "' . $post_data['report_type'] . '"'
            if ($report_id != '') {
                $criteria .= ' AND rep_id !=' . $report_id;
            }
            $duplicate_report_search = Reports_model::get_all_records($select, $criteria);
            if (count($duplicate_report_search) != 0) {
                DB::rollback();
                $rtn_arr = array(
                    'msg' => customTrans('reports.duplicate_report_title'),
                    'alert_type' => 'alert_box',
                    'status' => 'error',
                );
            } elseif ($report_id != '') {
                $result = Reports_model::update_record($insert_data, 'rep_id =' . $report_id, $current_user);
                if ($result) {
                    $rtn_arr = array(
                        'status' => 'success',
                        'msg' => customTrans('reports.reported_updated_success'),
                        'alert_type' => 'toaster'
                    );
                }
            } else {
                $ins_id = Reports_model::insert_record($insert_data, $current_user);
                if ($ins_id) {
                    $report_id = $ins_id;
                    $rtn_arr = array(
                        'msg' => customTrans('reports.reported_added_success'),
                        'status' => 'success',
                        'urlRedirect' => true,
                        'report_id' => Rv_encrypt($report_id)
                    );
                }
            }
            if ($rtn_arr['status'] == 'success') {
                DB::commit();
            }

            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // dd($e);
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function manageReports(Request $request)
    {
        try {
            $report_table = (new \App\Models\Reports_model())->getTable();
            $report_folder_table = (new \App\Models\Reports_folder_model())->getTable();
            $post_data   = $request->all();
            $validationArr = array(
                'action'   => 'required',
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $report_id_validate = true;
            $report_id = null;
            if (isset($post_data['report_id']) && !empty($post_data['report_id'])) {
                $report_id = Rv_decrypt($post_data['report_id']);
                $input_arr = array(
                    'input' => $post_data['report_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_id_validate = $this->Rv_validator($input_arr);
            }
            $report_mail_id_validate = true;
            $report_email_id = NULL;
            if (isset($post_data['report_email_id']) && !empty($post_data['report_email_id'])) {
                $report_email_id = Rv_decrypt($post_data['report_email_id']);
                $input_arr = array(
                    'input' => $post_data['report_email_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_mail_id_validate = $this->Rv_validator($input_arr);
            }
            $input_arr = array(
                'input' => $post_data['action'],
                'type' => 'string'
            );
            $report_type_validate = $this->Rv_validator($input_arr);
            if ($report_id_validate == false || $report_mail_id_validate == false || $report_type_validate == false) {
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            if ($post_data['action']  == 'delete') {
                $report_meta_data = Reports_model::get_single_record("rep_locked", 'rep_id =' . $report_id);
                $res = null;
                if (isset($report_meta_data->rep_locked) && $report_meta_data->rep_locked == 'y') {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.cannot_perform_delete'),
                        'status' => 'warning',
                        'url' => ''
                    );
                } else {
                    Reports_email::delete_records(array(
                        'rmil_rep_id' => $report_id
                    ));
                    Reports_model::delete_records(array(
                        'rep_parent' => $report_id
                    ));
                    Report_email_sent_log::delete_records(array(
                        'resl_rep_id' => $report_id
                    ));
                    $res = Reports_model::delete_records(array(
                        'rep_id' => $report_id
                    ));
                    $this->delete_report_cache($report_id);
                }
                if ($res) {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.report_deleted'),
                        'status' => 'success',
                    );
                }
            } elseif ($post_data['action']  == 'lock' || $post_data['action'] == 'unlock') {
                $lock_type = 'n';
                $lock_msg = customTrans('reports.report_unlocked');
                if ($post_data['action']  == 'lock') {
                    $lock_type = 'y';
                    $lock_msg = customTrans('reports.report_locked');
                }
                $update_data = array(
                    'rep_locked' => $lock_type
                );
                $rep_condition = "rep_id=" . $report_id;
                Reports_model::update_record($update_data, $rep_condition);
                $rtn_arr = array(
                    'msg' => $lock_msg,
                    'status' => 'success',
                );
            } elseif ($post_data['action'] == 'delete_email') {
                $res = Reports_email::delete_records(array(
                    'rmil_id' => $report_email_id
                ));
                if ($res) {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.report_email_deleted'),
                        'status' => 'success',
                    );
                }
            } elseif ($post_data['action'] == 'copy_report') {
                $current_report_parent = Reports_model::get_single_record('*', 'rep_id =' . $report_id);
                unset($current_report_parent->rep_id);
                unset($current_report_parent->rep_posted_by);
                unset($current_report_parent->rep_posted_date);
                unset($current_report_parent->rep_locked);
                $current_report_parent->rep_locked = 'n';

                $existing_report_title_count = Reports_model::get_single_record('COUNT(rep_id) as cnt', "rep_title LIKE '%$current_report_parent->rep_title%'");
                $new_rep_title = $current_report_parent->rep_title . ' ' . '(copy)';

                if ($existing_report_title_count->cnt >= 0) {
                    $title_not_present = false;
                    $current_count_title = $existing_report_title_count->cnt;
                    while($title_not_present == false)
                    {
                        $new_report_title = $current_report_parent->rep_title . ' ' . "(copy $current_count_title)";
                        $check_name_exist = Reports_model::get_single_record('COUNT(rep_id) as cnt', "rep_title ='$new_report_title'");
                        if($check_name_exist->cnt == 0)
                        {
                            $title_not_present = true;
                        }
                        else
                        {
                            $current_count_title++;
                        }
                    }
                    $current_report_parent->rep_title = $new_report_title;
                } else {
                    $current_report_parent->rep_title = $new_rep_title;
                }
                $new_report_id = Reports_model::insert_record((array) $current_report_parent, $current_user);
                $current_report_children = Reports_model::get_all_records('*', 'rep_parent =' . $report_id);

                if (count($current_report_children)) {
                    foreach ($current_report_children as $key => $report_child) {
                        unset($report_child->rep_id);
                        unset($report_child->rep_posted_by);
                        unset($report_child->rep_posted_date);
                        //make new report id as the parent
                        $report_child->rep_parent = $new_report_id;
                        //get the new id of each individual columns              
                        Reports_model::insert_record((array) $report_child, $current_user);
                    }
                }
                if ($new_report_id) {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.reported_copied_success'),
                        'status' => 'success',
                        'urlRedirect' => true,
                        'report_id' => Rv_encrypt($new_report_id)
                    );
                }
            }elseif ($post_data['action'] == 'delete_folder') {
                $folder_id      =       $report_id;
                $rcriteria	=	'`rfld_parent_id` = ' . $folder_id;
                $fcriteria	=	'`rep_rfld_id` = ' . $folder_id;
                /*
                *  check any child folders or reports under a selected folder
                *  param $folder_id - folder id
                */
                $sql		=	"SELECT	`rfld_id` as id FROM $report_folder_table WHERE $rcriteria
                                    UNION
                                SELECT `rep_id` as id FROM $report_table  WHERE  $fcriteria ";
                $res		=	Reports_folder_model::get_records_by_raw_query($sql);

                if (empty($res)) {
                    Reports_folder_model::delete_records(array('rfld_id' => $folder_id));
                    $rtn_arr = array(
                        'msg' => customTrans('reports.folder_deleted'),
                        'status' => 'success',
                    );
                } else {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.cannot_perform_delete_folder'),
                        'status' => 'warning',
                        'url' => ''
                    );
                }
            }
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // dd($e);
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function saveEmailSettings(Request $request)
    {
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'sendTo'  => 'required',
                'format'   => ['required', 'regex:/^[pc]+$/i'],
                'period'   => ['required', 'regex:/^[dwm]+$/i'],
                'startFrom'   => 'required',
                'report_id'   => 'required',
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $input_arr = array(
                'input' => $post_data['report_id'],
                'type'  => 'number',
                'rv_enc_data' => true
            );
            $report_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['sendTo'],
                'type' => 'string'
            );
            $send_to_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['format'],
                'type' => 'alphabet'
            );
            $format_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['period'],
                'type' => 'alphabet'
            );
            $period_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['startFrom'],
                'type' => 'date'
            );
            $start_from_validate = $this->Rv_validator($input_arr);
            $report_email_id = '';
            if (isset($post_data['report_email_id']) && !empty($post_data['report_email_id'])) {
                $report_email_id = Rv_decrypt($post_data['report_email_id']);
                $input_arr = array(
                    'input' => $post_data['report_email_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_email_id_validate = $this->Rv_validator($input_arr);
                if ($report_email_id_validate == false) {
                    $arraymsg['mesage'] = customTrans('validation.notvalid');
                    return $this->warning("Failed", 200, $arraymsg);
                }
            }
            $report_format = $this->Utility('report_format');
            $report_period = $this->Utility('report_period');
            if ($report_id_validate == false || $send_to_validate == false || $format_validate == false || $period_validate == false || $start_from_validate == false || !isset($report_format['report_format'][$post_data['format']]) || !isset($report_period['report_period'][$post_data['period']]) ) {
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            $email_validation_err = false;
            if (!$this->checkemail(trim($post_data['sendTo']))) {
                $rtn_arr = array(
                    'msg' => customTrans('reports.sendTo_invalid'),
                    'alert_type' => 'alert_box',
                    'status' => 'error',
                    'url' => ''
                );
                $email_validation_err = true;
            }
            $cc_arr = null;
            if (isset($post_data['cc']) && !empty($post_data['cc'])) {
                $cc_arr = implode(',', array_column($post_data['cc'], 'value'));
                foreach ($post_data['cc'] as $cc) {
                    if (!$this->checkemail(trim($cc['value']))) {
                        $rtn_arr = array(
                            'msg' => customTrans('reports.cc_invalid'),
                            'alert_type' => 'alert_box',
                            'status' => 'error',
                            'url' => ''
                        );
                        $email_validation_err = true;
                        continue;
                    }
                }
            }
            if ($email_validation_err != true) {
                $rmil_rep_id = Rv_decrypt($post_data['report_id']);
                $db_date = convert_dmy_to_ymd($post_data['startFrom'], $this->current_client->settings->cs_date_format) . ' ' . date('H:i:s');
                $data_list = array(
                    'rmil_rep_id' => $rmil_rep_id,
                    'rmil_send_to' => $post_data['sendTo'],
                    'rmil_send_cc' => $cc_arr,
                    'rmil_report_format' => $post_data['format'],
                    'rmil_report_period' => $post_data['period'],
                    'rmil_report_start' => $db_date,
                    'rmil_report_last_sent' => $db_date,
                    'rmil_covering_letter' => $post_data['emailContent']
                );
                $select = '*';
                $criteria = 'rmil_rep_id =' . $rmil_rep_id . ' AND rmil_send_to = "' . $post_data['sendTo'] . '" AND rmil_report_format = "' . $post_data['format'] . '" AND rmil_report_period = "' . $post_data['period'] . '"';
                if ($report_email_id != '') {
                    $criteria .= ' AND rmil_id !=' . $report_email_id;
                }
                $duplicate_email_search = Reports_email::get_all_records($select, $criteria);
                if (count($duplicate_email_search) != 0) {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.duplicate_send_to'),
                        'alert_type' => 'alert_box',
                        'status' => 'warning',
                        'url' => ''
                    );
                } elseif ($report_email_id != '') {
                    //update
                    $result = Reports_email::update_record($data_list, 'rmil_id =' . $report_email_id, $current_user);
                    if ($result) {
                        $rtn_arr = array(
                            'status' => 'success',
                            'msg' => customTrans('reports.email_updated'),
                            'alert_type' => 'toaster'
                        );
                    }
                } else {
                    //insert
                    $result = Reports_email::insert_record($data_list, $current_user);
                    if ($result) {
                        $rtn_arr = array(
                            'status' => 'success',
                            'msg' => customTrans('reports.email_added'),
                            'alert_type' => 'toaster'
                        );
                    }
                }
            }

            return $this->success($rtn_arr['status'], 200, $rtn_arr);

            // print_r($e);die;
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
	 *  fetch all the child folders and reports of a selected folder
	 *  param $folder_id - folder id
	 */
    public function get_report_folders($parent_id = '', $include_report = false, $initial_fixed_sort_order = array())
    {
        $report_table = (new \App\Models\Reports_model())->getTable();
        $tbk_report_table = Reports_model::$tbk_table;
        $report_folder_table = (new \App\Models\Reports_folder_model())->getTable();
        $tbk_report_folder_table = Reports_folder_model::$tbk_table;
        $res = [];
        $result_arr[] = ["key" => "home", "title" => customTrans('reports.home'), "children" => []];
        $date_format = $this->get_platform_date_format();
        $date_format = date_format_map($date_format);
        $union_query = '';
        $sort_query = " ORDER BY type DESC, id ASC";
        $child_cnt_query = "(select count(*) from $report_folder_table where `rfld_parent_id` = r.`rfld_id`) as child_cnt,";
        if ($include_report == true) {
            $union_query  .= " UNION
                SELECT
                    'file' AS type,
                    `rep_id` AS id,
                    CONCAT(`rep_id`, '_file') AS modified_id,
                    `rep_title` AS title,
                    CONCAT(`rep_rfld_id`, '_folder') AS folder_id,
                    '0' AS child_cnt,
                    (select MIN(rep_posted_date) from $tbk_report_table r where r.`rep_id` = id ) AS posted_date
                FROM
                    $report_table rep WHERE rep_parent Is NULL AND rep_title != '' ";
            $child_cnt_query = "(
                (
                    CASE 
                        WHEN(
                            SELECT 
                                COUNT(*)
                            FROM
                                $report_folder_table
                            WHERE
                                `rfld_parent_id` = r.`rfld_id`
                        ) > 0 
                    THEN 
                        TRUE
                    END
                ) OR (
                    CASE 
                        WHEN(
                            SELECT
                                COUNT(*)
                            FROM
                                $report_table
                            WHERE
                                `rep_rfld_id` = r.`rfld_id`
                        ) > 0 
                    THEN 
                        TRUE
                    END 
                )
            ) AS child_cnt,";
            $sort_query .= ', ' . $initial_fixed_sort_order['initial_sort_column'] . ' ' . $initial_fixed_sort_order['sort_asc'];
        }
        $query  =   "SELECT
                        'folder' AS type,
                        r.`rfld_id` as id,
                        CONCAT(r.`rfld_id`, '_folder') AS modified_id,
                        r.`rfld_title` as title,
                        CONCAT(r.`rfld_parent_id`, '_folder') AS folder_id,
                        " . $child_cnt_query . "
                        (select MIN(rfld_posted_date) from $tbk_report_folder_table rf where rf.`rfld_id` = id ) as posted_date
                    FROM
                        $report_folder_table r" . $union_query . $sort_query . ';';
        // print_r($query);die;

        $report_list   =   Reports_folder_model::get_records_by_raw_query($query);
        if (count($report_list) > 0) {
            /* foreach ($report_list as $key => $each_row) {
                $this->find_child_folders($res, $each_row);
            } */
           $res = $this->buildFolderTree($report_list);
           $result_arr[0]['children'] = $res;
        }
        return $result_arr;
    }
    public function buildFolderTree($items, $parentId = null) {
        $branch = [];
        $report_prefix = $this->Utility('report_prefix');
        foreach ($items as $item) {
            $row_prefix = ($report_prefix['report_prefix'][$item->type]);
            $enc_id = $row_prefix . Rv_encrypt($item->id);
            // $enc_parent_id = $row_prefix . Rv_encrypt($item->folder_id);
            if ($item->folder_id == $parentId) {
                $children = $this->buildFolderTree($items, $item->modified_id);
                if ($children && $item->type == 'folder') {// && $item->type='folder'
                    $item->children = $children;
                } else {
                    $item->children = [];
                }
                $branch[] = [
                    'key' => $enc_id,
                    'title' => $item->title,
                    'type' => $item->type,
                    'isLeaf' => ($item->type == 'folder') ? empty($children) : true,
                    'children' =>  ($item->type == 'folder') ? $children : []
                ];
            }
        }
        return $branch;
    }
    public function find_child_folders(&$arr, $row)
    { 
        $report_prefix = $this->Utility('report_prefix');
        $row_prefix = ($report_prefix['report_prefix'][$row->type]);
        $enc_id = $row_prefix . Rv_encrypt($row->id);
        $enc_parent_id = Rv_encrypt($row->folder_id);

        if ($row->folder_id == null) {
            if ($row->child_cnt == 0) {
                return $arr[] = ["key" => $enc_id, "title" => $row->title, "type" => $row->type, "isLeaf" => true, "children" => []];
            } else {
                return $arr[] = ["key" => $enc_id, "title" => $row->title, "type" => $row->type, "children" => []];
            }
        }
        foreach ($arr as &$e) {
            $e_prefix = ($report_prefix['report_prefix'][$e['type']]);
            $search_id = str_replace($e_prefix, '', $e['key']);
            if ($search_id == $enc_parent_id) {
                if ($row->child_cnt == 0) {
                    $e["children"][] = (["key" => $enc_id, "title" => $row->title, "type" => $row->type, "isLeaf" => true, "children" => []]);
                } else {
                    $e["children"][] = (["key" => $enc_id, "title" => $row->title, "type" => $row->type, "children" => []]);
                }
                break;
            }
            $this->find_child_folders($e["children"], $row);
        }
    }
    public function customFolderActions(Request $request)
    {
        try {
            $post_data   = $request->all();
            $current_user = $this->get_current_user_details();
            $validationArr = array(
                'action'  => 'required',
            );
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $selected_folder_id = 'home';
            if (isset($post_data['selected_folder_id']) && $post_data['selected_folder_id'] != 'home') {
                $report_prefix = $this->Utility('report_prefix');
                $selected_folder_id = str_replace(($report_prefix['report_prefix']), '', $post_data['selected_folder_id']);
                $input_arr = array(
                    'input' => $selected_folder_id,
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $folder_id_validate = $this->Rv_validator($input_arr);
            } elseif (isset($post_data['parent_folder_id']) && $post_data['parent_folder_id'] != 'home') {
                $input_arr = array(
                    'input' => $post_data['parent_folder_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $folder_id_validate = $this->Rv_validator($input_arr);
            } else {
                $folder_id_validate = true;
            }
            if ($folder_id_validate == false) {
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            if ($post_data['action']  == 'fetch_parents') {
                $colmn = array();
                $parent_folder_data = array();
                if (isset($selected_folder_id) && $selected_folder_id != 'home') {
                    $arr = [];
                    $folder_id = Rv_decrypt($selected_folder_id);
                    $folder_ids    =    $this->find_parent_folders($arr, $folder_id);
                    $parent_folder_data = Reports_folder_model::get_all_records_with_bind_cond("rfld_id, rfld_title", null, 'rfld_id IN ( ' . implode(',', $folder_ids) . ')');
                    /* encrypt all the parent folder ids */
                    if(count($parent_folder_data) > 0) {
                        /* foreach($parent_folder_data as $data){
                            $arr           =    [];
                            $this->find_parent_folders($arr, $data->rfld_id);
                            $enc_folder_ids=    $this->encrypt_folder_ids($arr);
                            array_push($enc_folder_ids,"home");
                            $data->parent_ids = $enc_folder_ids;
                        } */
                        $collection = collect($parent_folder_data);
                        for ($i=0; $i < count($folder_ids); $i++) { 
                            $arr           =    [];
                            $colmn[$i]      = $collection->firstWhere('rfld_id', $folder_ids[$i]);
                            $this->find_parent_folders($arr, $colmn[$i]->rfld_id);
                            $enc_folder_ids=    $this->encrypt_folder_ids($arr);
                            array_push($enc_folder_ids,"home");
                            $colmn[$i]->parent_ids = $enc_folder_ids;
                        }
                    }
                }

                $rtn_arr = array(
                    'selected_folder_id' => $selected_folder_id,
                    'parent_folder_data' => $colmn,
                    'status' => 'success',
                );
            }else if ($post_data['action']  == 'create') {
                $parent_folder_id = null;
                $input_arr = array(
                    'input' => $post_data['folder_title'],
                    'type'  => 'string'
                );
                $folder_title_validate = $this->Rv_validator($input_arr);
                if (!preg_match('/^[A-Za-z0-9\(\)\&\-\_ ]+$/', $post_data['folder_title'])) {
                    $folder_title_validate = false;
                }
                if ($folder_title_validate == false) {
                    $arraymsg['mesage'] = customTrans('validation.notvalid');
                    return $this->warning("Failed", 200, $arraymsg);
                }
                if (isset($post_data['parent_folder_id']) && $post_data['parent_folder_id'] != 'home') {
                    $parent_folder_id = Rv_decrypt($post_data['parent_folder_id']);
                }else if($post_data['parent_folder_id'] == 'home'){
                    $parent_folder_id = $post_data['parent_folder_id'];
                }
                $rtn_arr = $this->create_folder($post_data['folder_title'], $parent_folder_id);
            }else if($post_data['action']  == 'edit'){
                if (isset($post_data['folder_id']) && !empty($post_data['folder_id'])) {
                    $folder_id = Rv_decrypt($post_data['folder_id']);
                }
                $parent_folder_id = null;
                if (isset($post_data['parent_folder_id']) && $post_data['parent_folder_id'] != 'home') {
                    $parent_folder_id = Rv_decrypt($post_data['parent_folder_id']);
                }
                $rtn_arr = $this->create_folder($post_data['folder_title'], $parent_folder_id, $folder_id, $post_data['action']);
            }else if($post_data['action']  == 'move'){
                $report_id = Rv_decrypt($post_data['report_id']);
                $parent_folder_id = null;
                if (isset($post_data['parent_folder_id']) && $post_data['parent_folder_id'] != 'home') {
                    $parent_folder_id = Rv_decrypt($post_data['parent_folder_id']);
                }
                $update_data = array(
                    'rep_rfld_id' => $parent_folder_id
                );
                if(isset($post_data['addtoNewFolder']) && $post_data['addtoNewFolder'] == true){
                    if (!preg_match('/^[A-Za-z0-9\(\)\&\-\_ ]+$/', $post_data['folder_title'])) {
                        $arraymsg['mesage'] = customTrans('validation.notvalid');
                        return $this->warning("Failed", 200, $arraymsg);
                    }
                    $rtn_arr = $this->create_folder($post_data['folder_title'], $parent_folder_id, null);
                    $update_data['rep_rfld_id'] = $parent_folder_id = $rtn_arr['folder_id'];
                }
                //checking if the move to folder is same folder
                $same_folder = Reports_model::get_single_record("rep_rfld_id", 'rep_id =' . $report_id);
                if($same_folder->rep_rfld_id == $parent_folder_id){
                    $rtn_arr = array(
                        'msg' => customTrans('reports.report_moving_to_same_folder'),
                        'alert_type' => 'alert_box',
                        'status' => 'error',
                    );
                }else{
                    $result = Reports_model::update_record($update_data, 'rep_id =' . $report_id, $current_user);
                    if ($result) {
                        $rtn_arr = array(
                            'msg' => customTrans('reports.report_moved_success'),
                            'status' => 'success',
                        );
                    }else{
                        $rtn_arr = array(
                            'msg' => customTrans('reports.report_moved_failed'),
                            'alert_type' => 'alert_box',
                            'status' => 'error',
                        );
                    }
                }
            }
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function encrypt_folder_ids($arr){
        $report_prefix = $this->Utility('report_prefix');
        $prefix = ($report_prefix['report_prefix']['folder']);
        $enc_set = array_map(function($item) use($prefix) {
                return $prefix.Rv_encrypt($item);
            return null;
        }, $arr);
        return $enc_set;
    }
    public function find_parent_folders(&$arr, $id)
    {
        $columns        =    '`rfld_id` as id,IF(`rfld_parent_id` IS NULL, "#", `rfld_parent_id`) as parent';
        $fetch_parent    =    Reports_folder_model::get_single_record($columns, 'rfld_id =' . $id);
        if (!empty($fetch_parent)) {
            if (!in_array($fetch_parent->id, $arr)) {
                $arr[]    = $fetch_parent->id;
            }
            if ($fetch_parent->parent != '#') {
                $this->find_parent_folders($arr, $fetch_parent->parent);
            }
            $rev    =    array_reverse($arr);
            return $rev;
        }
    }
    public function create_folder($folder_title, $parent_folder_id = null, $folder_id = null, $mode = null)
    {
        $current_user = $this->get_current_user_details();
        $select = '*';
        $criteria = 'rfld_title = "' . $folder_title . '"';
        if ($folder_id != null) {
            $criteria .= ' AND rfld_id !=' . $folder_id;
        } 
        $duplicate_folder_search = Reports_folder_model::get_all_records($select, $criteria);
        if (count($duplicate_folder_search) != 0) {
            $rtn_arr = array(
                'msg' => customTrans('reports.duplicate_folder_title'),
                'alert_type' => 'alert_box',
                'status' => 'error',
            );
        } else if($parent_folder_id != null && $mode == null) {
            if($parent_folder_id == 'home'){
                $parent_folder_id = null;
            }
            $data            =    array(
                'rfld_parent_id'  => $parent_folder_id,
                'rfld_title'        => $folder_title
            );
            $res = Reports_folder_model::insert_record($data, $current_user);
            if ($res) {
                $rtn_arr = array(
                    'msg' => customTrans('reports.folder_added'),
                    'folder_id' => $res,
                    'status' => 'success',
                );
            }
        } else if($folder_id != null) {
            $update_data            =    array(
                'rfld_title'        => $folder_title
            );
            if($mode == 'edit' && $parent_folder_id != $folder_id){
                $update_data['rfld_parent_id'] = $parent_folder_id;
            }
            $result = Reports_folder_model::update_record($update_data, 'rfld_id =' . $folder_id, $current_user);
            if ($result) {
                $rtn_arr = array(
                    'msg' => customTrans('reports.reported_updated_success'),
                    'folder_id' => $folder_id,
                    'status' => 'success',
                );
            }
        }else{
            $res = Reports_folder_model::insert_record(array(
                'rfld_parent_id'  => $parent_folder_id,
                'rfld_title'        => $folder_title
            ), $current_user);
            if ($res) {
                $rtn_arr = array(
                    'msg' => customTrans('reports.folder_added'),
                    'folder_id' => $res,
                    'status' => 'success',
                );
            }
        }
        return $rtn_arr;
    }
    public function manageDownload(Request $request){
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'report_id'   => 'required',
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $report_id_validate = true;
            $report_id = null;
            if (isset($post_data['report_id']) && !empty($post_data['report_id'])) {
                $report_id = Rv_decrypt($post_data['report_id']);
                $input_arr = array(
                    'input' => $post_data['report_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_id_validate = $this->Rv_validator($input_arr);
            }
            if ($report_id_validate == false){
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            // initiating download
           $rtn_arr = $this->process_download($report_id, $post_data['download_mode']);

            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function resetReport(Request $request){
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'report_id'   => 'required',
                'reset_mode'   => 'required'
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $report_id_validate = true;
            $report_id = null;
            if (isset($post_data['report_id']) && !empty($post_data['report_id'])) {
                $report_id = Rv_decrypt($post_data['report_id']);
                $input_arr = array(
                    'input' => $post_data['report_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_id_validate = $this->Rv_validator($input_arr);
            }
            if ($report_id_validate == false){
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            if($post_data['reset_mode'] == 'all'){
                $res = Reports_model::delete_records(array(
                    'rep_parent' => $report_id
                ));
                Reports_model::where('rep_id', $report_id)->update(['rep_filter' => null]);
                if ($res) {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.report_reset'),
                        'status' => 'success',
                    );
                }
                $this->delete_report_cache($report_id);
            }
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function delete_report_cache($report_id){
        if($report_id){
            $report_cache_path = storage_path('/app/public/uploads/' . config('report_generation')['report_cache_path'] . '/' . $report_id);
            File::deleteDirectory($report_cache_path);
        }
    }
    public function process_download($report_id, $download_mode, $cron_path = null)
    {
        try {
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            if (!empty($report_id) && !empty($download_mode)) {
                $report_basic_data = Reports_model::find($report_id);
                $sorted_columns = $filters = [];
                if (!empty($report_basic_data)) {
                    $global_filter = json_decode($report_basic_data->rep_filter, true);
                    // $report_type = $report_basic_data->rep_type;
                    $report_config = config('report_generation');
                    $delimeters = $report_config['delimeters'];
                    $fn_column_values = [];
                    $report_child_columns = Reports_model::get_all_records("rep_id, rep_col_value, rep_fields, rep_field_function, rep_values_seperator, rep_title, rep_show_total_type, rep_column_order, rep_filter", 'rep_parent =' . $report_id, 'rep_field_order');
                    if (count($report_child_columns) > 0) {
                        foreach ($report_child_columns as $child) {
                            $fn_column_values[$child->rep_title] = $child->rep_col_value ?? null;
                            $fields = json_decode($child->rep_fields, true)[0];
                            $keys[$child->rep_title] = $fields;
                            if (in_array($child->rep_column_order, array('a', 'd'))) {
                                $sorted_columns = array(
                                    'name' => $child->rep_title,
                                    'order' => ($child->rep_column_order == 'a') ? 'asc' : 'desc'
                                );
                            }
                            if ($child->rep_filter) {
                                $filters[$child->rep_title] = json_decode($child->rep_filter, true);
                            }
                            if ($child->rep_field_function == 'group_concat') {
                                $filters[$child->rep_title]['view'] = array(
                                    'mode'      => $child->rep_field_function,
                                    'separator' => ($child->rep_values_seperator) ? $delimeters[$child->rep_values_seperator]['value'] : ''
                                );
                            } elseif ($child->rep_field_function == 'count') {
                                $filters[$child->rep_title]['view'] = array(
                                    'mode'      => $child->rep_field_function
                                );
                            }
                        }
                        $req = array(
                            'report_id' => $report_id,
                            // 'type'      => $report_type,
                            'keys'      => $keys,
                            'fn_column_values' => $fn_column_values,
                            'filters'   => $filters,
                            'sort_by'   => $sorted_columns,
                            'limit'     => 20,
                            'global_filter' => $global_filter,
                            'report_child_rows' => $report_child_columns,
                            'force_reload' => false, //($cron_path == null)?false:true
                            'download' => true
                        );
                        $generated_report_data = (new Report_generation_Api())->buildQuery($req, true);
                        if(in_array('generic_form_elements',array_values($req['keys']))){
                            $keyOrder = $req['keys'];
                            $collection = $generated_report_data['generated_report'];
                            $generated_report_data['generated_report'] = $collection->map(function ($item) use ($keyOrder) {
                                $itemArray = (array) $item;
                                $sortedItem = [];
                                foreach ($keyOrder as $key => $label) {
                                    $sortedItem[$key] = $itemArray[$key] ?? null;
                                }
                                return (object) $sortedItem;
                            });
                        }
                    }
                }

                if (isset($generated_report_data) && !empty($generated_report_data)) {
                    //setting up common path for generating report
                    $report_cache_full_path = storage_path('/app/public/uploads/' . config('report_generation')['report_cache_path'] . '/' . $report_id . '/');
                    if ($cron_path != null) {
                        $report_cache_full_path = $cron_path;
                    }
                    $report_format = $this->Utility('report_format');
                    $extension = $report_format['report_format'][$download_mode]['extension'];
                    $file_name = str_replace(" ", "_", $report_basic_data->rep_title) . $extension;
                    $full_path  = $report_cache_full_path . $file_name;
                    //Before download remove the previous temporary file
                    if (File::exists($full_path)) {
                        unlink($full_path);
                    }
                    // generating total count of columns records if any
                    $template_data['templated_report_data'] = $this->convert_to_template_data($generated_report_data['generated_report'], $download_mode);
                    if (isset($generated_report_data['generated_total_count']) && $generated_report_data['generated_total_count'] != null) {
                        $template_data['templated_total_count'] = json_decode($generated_report_data['generated_total_count']);
                    }
                    $template_data['templated_footer_content'] = $this->get_footer_content(true, $report_id);

                    $cacheKey = "report_template_data" . md5(json_encode([$req['report_id']]));
                    
                    Cache::put($cacheKey, $template_data, now()->addHours(1));
                    //setting up job for file generation
                    $generate_data = array(
                        'report_id'     => $req['report_id'],
                        'download_mode' => $download_mode,
                        // 'full_path'     => $full_path,
                        'file_path'     => $report_cache_full_path,
                        'file_name'     => $file_name
                        // 'is_s3_enabled' => $this->current_client->functionality->cfty_enable_upload_s3_bucket
                    );
                    $rtn_arr = array(
                        'status'    => 'success',
                        'msg'       => customTrans('reports.download_inprogress'),
                        'file_name' => Rv_encrypt($file_name),
                        'file_path' => Rv_encrypt($full_path)
                    );
                    /* for pdf download testing */
                    // $generated_file_details = (new Report_generation_Api())->generateReportPdf($generate_data['report_id'], $generate_data['file_path'], $generate_data['file_name'], $generate_data['template_data']['templated_report_data']);
                    // print_r($generated_file_details);die;
                    if ($cron_path == null) {
                        ReportGenerationJob::dispatch($generate_data); //->delay(now()->addSeconds(10))
                    } else {
                        $generate_data['is_s3_enabled'] = $this->current_client->functionality->cfty_enable_upload_s3_bucket;
                        $rtn_arr['report_generation_job_data'] = $generate_data;
                    }
                    /* if ($this->current_client->functionality->cfty_enable_upload_s3_bucket == 'y') {
                        $this->update_s3_files(config('report_generation')['report_cron_send_path'] . '/' . date('d_m_Y') . '/');
                    } */
                } else {
                    $rtn_arr = array(
                        'status' => 'warning',
                        'msg'    => customTrans('reports.no_records'),
                    );
                }
                return $rtn_arr;
            }
        } catch (\Exception $e) {
            // dd($e);
            // print_r($e);die;
            throw  $e;
        }
    }
    public function initiateDownload($download_data){
        try {
            $post_data = json_decode($download_data);
            $decrypted_path = Rv_decrypt($post_data->download_path);
            if(File::exists($decrypted_path)){
                return FacadesResponse::download($decrypted_path);
            }else{
                return false;
            }
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_footer_content($return_array = false, $report_id){
        $url = URL::to('/') . '/';
        $formatted_url = preg_replace("(^https?://)", "", $url);
        $date = Cache::store('report_redis')->get("reportDateFor_" . $report_id);
        $date_format = $this->get_platform_date_format() . ' H:i:s A';
        $formated_date = Carbon::parse($date)->format($date_format);
        $current_user = $this->get_current_user_details();
        $generated_by = '';
        $generated_from = 'Auto generated';
        if(!empty($current_user)){
            $user_data = User::get_single_record('CONCAT_WS(" ",usr_first_name,usr_middle_name,usr_last_name) as full_name',"usr_id={$current_user['user_id']}");
            $generated_by = ', by: '. $user_data->full_name;
            $generated_from = 'Generated';
        }
        if($return_array == true){
            $rtn_data = array('
                <hr>
                <div class="footer">
                    ' . $generated_from . ' from: <a target="_blank" href="'.$url.'">' . $formatted_url . '</a>, on: ' . $formated_date . $generated_by .
                '</div>
            ');
        }else{
           $rtn_data = '
                <hr>
                <div class="footer">
                    ' . $generated_from . ' from: <a target="_blank" href="'.$url.'">' . $formatted_url . '</a>, on: ' . $formated_date . $generated_by .
                '</div>
            '; 
        }
        return $rtn_data;
    }
    public function get_template_structure($tableData = array(), $report_id)
    {
        //sample table structure
        /* $tableData = [
            ['Header 1', 'Header 2', 'Header 3', 'Header 4', 'Header 5'],
            ['Row 1, Col 1', 'Row 1, Col 2', 'Row 1, Col 3', 'Row 1, Col 4', 'Row 1, Col 5'],
            ['Row 2, Col 1', 'Row 2, Col 2', 'Row 2, Col 3', 'Row 2, Col 4', 'Row 2, Col 5'],
            ['Row 3, Col 1', 'Row 3, Col 2', 'Row 3, Col 3', 'Row 3, Col 4', 'Row 3, Col 5'],
            ['Row 4, Col 1', 'Row 4, Col 2', 'Row 4, Col 3', 'Row 4, Col 4', 'Row 4, Col 5']
        ]; */
        // common for pdf and html modes
        if(isset($tableData['templated_report_data']) && !empty($tableData['templated_report_data'])){
            // print_r($tableData['templated_report_data']);die;
            $html = '
                <style>
                    table {
                        width: 100%;
                        border-collapse: collapse;
                        margin-bottom: 10px;
                    }
                    th, td {
                        border: 1px solid #000;
                        padding: 8px;
                        text-align: left;
                    }
                    thead {
                        background-color: #007bff;
                        color: white;
                        font-weight: bold;
                    }
                    tbody tr:nth-child(even) {
                        background-color: #f2f2f2;
                    }
                    .footer{
                        text-align: right;
                        font-size:14px
                    }
                </style>
                <table>
                    <thead>
                        <tr>';
                        // Add headers
                        foreach ($tableData['templated_report_data'][0] as $header) {
                            $html .= "<th>{$header}</th>";
                        }
                        $html .= '
                        </tr>
                    </thead>
                    <tbody>';
                        // Add data rows (skipping the header row)
                        for ($i = 1; $i < count($tableData['templated_report_data']); $i++) {
                            $html .= '<tr>';
                            foreach ($tableData['templated_report_data'][$i] as $cell) {
                                if (Str::contains($cell, ["\r\n", "\n", "\r"])) {
                                    $cell = Str::replace(["\r\n", "\n", "\r"], "<br>", $cell);
                                }
                                $html .= "<td>{$cell}</td>";
                            }
                            $html .= '</tr>';
                        }
                    $html .= '
                    </tbody>
                </table>';
                if(isset($tableData['templated_total_count']) && !empty($tableData['templated_total_count'])){
                    $html .= '
                        <table>
                            <tbody>';
                                    foreach ($tableData['templated_total_count'] as $key => $value) {
                                        $html .= '<tr><td> ' .$key . '</td>';
                                        $html .= '<td> ' .$value . '</td></tr>';
                                    }
                    $html .= '
                            </tbody>
                        </table>';
                }
                $html .= $this->get_footer_content(false, $report_id); 
        }
        return $html;
    }
    public function convert_to_template_data($report_data = null, $download_mode = null) {
        $rtn_data = array();
        if($report_data != null){
            //removing custom columns
            $report_data = $report_data->map(function($obj) { $obj; unset($obj->custom_art_id, $obj->custom_artp_id, $obj->custom_usr_id); return (array)$obj;})->all();
            // preparing header data
            $rtn_data[] = array_keys((array)$report_data[0]);
            // preparing column data
            foreach($report_data as $each_data){
                $each_data = (array) $each_data;
                if($download_mode != 'c'){
                    $rtn_data[] = (array_values($each_data));
                }else{
                    $each_data_arr = array_values($each_data);
                    $rtn_data[] = array_map(function($item) {
                        return strip_tags($item);
                    }, $each_data_arr);
                }
            }
        }
        return $rtn_data;
    }
    public function reportEmailHistory(Request $request){
        try{
            $post_data   = $request->all();
            $validationArr = array(
                'report_id'   => 'required',
                'per_page'    => 'required',
                'page'        => 'required'
            );
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $report_id = null;
            $report_id_validate = true;
            $per_page = $post_data['per_page'];
            $report_period = $this->Utility('report_period');
            if (isset($post_data['report_id']) && !empty($post_data['report_id'])) {
                $report_id = Rv_decrypt($post_data['report_id']);
                $input_arr = array(
                    'input' => $post_data['report_id'],
                    'type'  => 'number',
                    'rv_enc_data' => true
                );
                $report_id_validate = $this->Rv_validator($input_arr);
                if ($report_id_validate == false){
                    $arraymsg['mesage'] = customTrans('validation.notvalid');
                    return $this->warning("Failed", 200, $arraymsg);
                }
                $report_email_send_log_table = (new \App\Models\Report_email_sent_log())->getTable();
                $email_send_log_table = (new \App\Models\Email_send_log())->getTable();

                $log_tables = array(
                    'main_table' => $report_email_send_log_table,
                    'join_table' => array(
                        $email_send_log_table => array($report_email_send_log_table . '.resl_esl_id', $email_send_log_table . '.esl_id')
                    )
                );
                $rep_criteria = "resl_rep_id={$report_id}";
                $select_fields = 'esl_subject, esl_content, esl_to, esl_cc, esl_attachments, resl_rmil_report_period, resl_posted_date';
                $report_email_send_log = Report_email_sent_log::get_results_using_joins($log_tables, $select_fields, $rep_criteria, 'all', 'resl_posted_date DESC', $per_page, paginate:TRUE);
                if(count($report_email_send_log) > 0){
                    foreach($report_email_send_log as $send_log){
                        $dt = new DateTime($send_log->resl_posted_date);
                        $date = $dt->format('d-m-Y');
                        $time = $dt->format('h:i:s A');
                        $send_log->report_period_str = $report_period['report_period'][$send_log->resl_rmil_report_period];
                        $send_log->resl_posted_date = date($this->current_client->settings->cs_date_format, strtotime(trim($date))) . ' ' . $time;
                        $attch_obj = json_decode($send_log->esl_attachments);
                        $send_log->report_cron_send_path = Rv_encrypt(storage_path('/app/public/uploads/' . config('report_generation')['report_cron_send_path'] . '/' . $attch_obj->modified));
                        $temp_arr = explode('/', $attch_obj->modified);
                        $send_log->file_name = $temp_arr[1];
                    }
                }
                $rtn_arr = array(
                    'status' => 'success',
                    'data' => $report_email_send_log,
                    'msg' => ''
                );
            }
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }        

    }
}
