<?php

/*
* Task #925 Manage Research Integrity Api
*/

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Research_integrity_reports;

use App\Models\Journals;
use App\Models\Api_credentials;
use App\Http\Traits\ResearchIntegrityTrait;

use Config;
use DB;

class Manage_Research_Integrity_Api extends Controller
{
    use ResearchIntegrityTrait;

    // Common variables
    protected $apiLogin;
    protected $submitManuscript;
    protected $rvriWebhook;
    protected $rvriAccptdfiles;

    public function __construct()
    {
        parent::__construct(); // Ensure the parent constructor is called

        $this->apiLogin             =   "/rvri-api/login";
        $this->submitManuscript     =   "/rvri-api/submission";
        $this->rvriWebhook          =   "/api/rvri-webhook";
        $this->rvriAccptdfiles      =   '".docx",".pdf"';
    }

    /*
    * Authentication - validates the domain against an API call
    */
    // public function login_research_integrity() {
    //     try {
    //         if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
    //         {
    //             $this->loginresearchintegrity();
    //         }
    //     } catch (\Exception $e) {
    //         return  $this->failure('Failed', 500, $e);
    //     }
    // }

    /*
    * genrate the research integrity report
    */
    public function generate_research_integrity(Request $request)
    {
        try {
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $this->current_user = $this->get_current_user_details();
                $validator = Validator::make($request->all(), [
                    'art_id'       => 'required',
                    'jnl_id'    => 'required',
                ]);
                if ($validator->fails()) {
                    return response()->json($validator->errors(), 422);
                }
                $post_data  =   $request->all();
                $art_id     =   decrypt_link($post_data['art_id']);
                $aflw_id    =   decrypt_link($post_data['art_flow_id']);
                $atmnt_id   =   decrypt_link($post_data['atmnt_id']);
                if($art_id != '') {
                    return $this->generateresearchintegrity($art_id, $aflw_id, $atmnt_id);
                } else {
                    return response()->json([
                        'message' => 'Article not found',
                        'status' => 'error',
                    ]);
                }
            } else {
                return response()->json([
                    'message' => 'You have no permission',
                    'status' => 'error',
                ]);
            }

        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * genrate the research integrity report
    * No past reports can view so 
    */
    public function fetch_research_integrity(Request $request)
    {
        try {
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $this->current_user = $this->get_current_user_details();
                $validator = Validator::make($request->all(), [
                    'art_id'       => 'required',
                    'jnl_id'       => 'required',
                    'art_flow_id'  => 'required',
                ]);
                if ($validator->fails()) {
                    return response()->json($validator->errors(), 422);
                }
                $post_data  =   $request->all();
                $art_id     =   decrypt_link($post_data['art_id']);
                $jnl_id     =   decrypt_link($post_data['jnl_id']);
                $aflw_id    =   decrypt_link($post_data['art_flow_id']);

                $return_array= $this->get_article_rvri_details($art_id, $jnl_id, $aflw_id);
                if(!empty($return_array)) {
                return response()->json([
                    'result' => $return_array,
                    'status' => 'success',
                ]);
            } else {
                return response()->json([
                    'result' => array(),
                    'status' => 'error',
                ]);
            }
            } else {
                return response()->json([
                    'result' => array(),
                    'status' => 'error',
                ]);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * fetch the rvri settings
    */
    public function get_rvriconfig_setting(Request $request)
	{
		try
		{
			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_code'      => 'required',
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}

			$this->currentuser = $this->get_current_user_details();
			$jnl_code = $post_data['jnl_code'];
			$criteria = "jnl_journal_code='{$jnl_code}'";
			$platform_data = Journals::get_single_record('*', $criteria);
			$returndata['jnl_id']=$platform_data->jnl_id;
			$edit_record = isset($post_data['edit_record']) ? $this->decrypt_data($post_data['edit_record']) : '';
            $rvri_api_config = NULL;
			if ($edit_record != '') {
				if ($this->current_client->modules->mdl_research_integrity == 'y') {
					$rvri_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'research_integrity', 'acrd_artp_id' => $edit_record, 'acrd_jnl_id' =>$platform_data->jnl_id);
				    $rvri_api_config = Api_credentials::get_single_record_with_bind_cond('*', $rvri_api_condition);
					if ($rvri_api_config == NULL) {
					    $rvri_api_condition['acrd_artp_id'] = NULL;
						$rvri_api_config = Api_credentials::get_single_record_with_bind_cond('*', $rvri_api_condition);
						if ($rvri_api_config == NULL) {
						   $rvri_api_condition['acrd_jnl_id'] = NULL;
						   $rvri_api_config = Api_credentials::get_single_record_with_bind_cond('*', $rvri_api_condition);
					   }
					}
			   }

			}else{
				if ($this->current_client->modules->mdl_research_integrity == 'y') {
					$rvri_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'research_integrity', 'acrd_artp_id' => NULL, 'acrd_jnl_id' =>$platform_data->jnl_id);
					$rvri_api_config = Api_credentials::get_single_record_with_bind_cond('*', $rvri_api_condition);
					if ($rvri_api_config == NULL) {
						$rvri_api_condition['acrd_jnl_id'] = NULL;
						$rvri_api_config = Api_credentials::get_single_record_with_bind_cond('*', $rvri_api_condition);
					}
				}
			}
			$returndata['form_data']['rvri_api_config'] = $rvri_api_config;
			return $this->success('success',200,$returndata);
		}
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
	}

    /*
    * fetch the rvri report history
    */
    public function fetch_research_integrity_history(Request $request) {
        try {
            $ret_arry   =   array();
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $this->current_user = $this->get_current_user_details();
                $validator = Validator::make($request->all(), [
                    'art_id'       => 'required',
                    'jnl_code'     => 'required',
                ]);
                if ($validator->fails()) {
                    return response()->json($validator->errors(), 422);
                }
                $post_data  =   $request->all();
                $art_id     =   decrypt_link($post_data['art_id']);
                $jnl_code   =   $post_data['jnl_code'];
                if($art_id != '') {
                    $platform_data = Journals::get_single_record('*', "jnl_journal_code='{$jnl_code}'");
                    $jnl_id =   $platform_data->jnl_id;

                    $result     =   Research_integrity_reports::get_latest_research_integrity_report($art_id);
                    if($result) {
                        $prevres     =   Research_integrity_reports::get_research_integrity_report_history($art_id, $result->rri_id);
                        if(!empty($prevres)) {
                            $date_format = $this->get_platform_date_format($jnl_id);
                            foreach($prevres as $key) {
                                $subArray   =   array();
                                $subArray['rri_report']         =   $key->rri_report;
                                $subArray['rri_posted_date']    =   'as on '.date($date_format. ' h:i:s A', strtotime($key->rri_posted_date));
                                $ret_arry[] = $subArray;
                            }
                        }
                    }
                }
                return $this->success('success',200,$ret_arry);
            }
        }
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
}
