<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\JournalUserfunctionTrait;
use App\Http\Traits\RolesConfigTrait;
use Illuminate\Support\Str;
use Config;
use DB;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Blind_user_articles;
use App\Models\Authors;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Http\Traits\ArticlelistTrait;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\ReviewerListTrait;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\WorkflowAssignmentTypeTrait;
use DateTime;

class Manage_Reviewer_Pre_Review_Api extends Controller
{
    use StagemovementTrait;
    use RolesConfigTrait;
    use JournalUserfunctionTrait;
    use ReviewerListTrait;
    use GeneralEmailTrait;
    use SendGlobalEmailFunctionTrait;
    use WorkflowTrait;
    use WorkflowAssignmentTypeTrait;
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    public function allocate_pre_review_stage_users_method(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'journal_id' => 'required',
                'journal_code' => 'required',
                'hdn_current_status_id' => 'required',
                'hdn_short_rvws_ids' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => Rv_decrypt($post_data['article_id']),
                'type' => 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            
            $input_arr = array(
                'input' => decrypt_link($post_data['journal_id']),
                'type' => 'number'
            );
            $journal_id_validate = $this->Rv_validator($input_arr);

            $input_arr = array(
                'input' => $post_data['journal_code'],
                'type' => 'string'
            );
            $journal_code_validate = $this->Rv_validator($input_arr);

            if ($art_id_validate == FALSE || $journal_code_validate == FALSE || $journal_id_validate == FALSE) {
                $arraymsg['mesage'] = trans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            $return_data=array();
            $current_user = $this->get_current_user_details();
            $user_ids = array();
            $decrypted_hdns = Rv_decrypt($post_data['hdn_short_rvws_ids']);
            $post_data['hdn_short_rvws_ids'] = json_decode($decrypted_hdns);
            if ($post_data['hdn_short_rvws_ids'] != '')
                $user_ids = $post_data['hdn_short_rvws_ids'];
            if(is_array($user_ids))
            {
                foreach ($user_ids as $alt_rwrs) 
                {
                    $input_arr = array(
                        'input' => $alt_rwrs,
                        'type' => 'string'
                    );
                    $hidden_id_validate = $this->Rv_validator($input_arr);
                    if($hidden_id_validate == FALSE)
                    {
                        $arraymsg['mesage'] = trans('validation.notvalid');
                        return $this->warning("Failed", 200, $arraymsg);
                    }
                }
            }
            else
            {
                $arraymsg['mesage'] = trans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            //Task #5083 Modify alternative reviewer selection	
            $alternate_reviewers = array();
            if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')) {
                if (isset($post_data['hdn_alt_rvws_ids']) && $post_data['hdn_alt_rvws_ids'] != '') {
                    $alt_user_ids =  $post_data['hdn_alt_rvws_ids'];
                    if (count($alt_user_ids) > 0) {
                        $alt_user_ids = array_unique($alt_user_ids);
                        foreach ($alt_user_ids as $alt_rwrs) {
                            $alternate_reviewers[] = $alt_rwrs;
                        }
                    }
                }
            }
            $jnl_code = $post_data['journal_code'];
            $current_stage_id = Rv_decrypt($post_data['stage_status_id']);
            if (isset($post_data['journal_id']))
                $journal_id = decrypt_link($post_data['journal_id']);
            $article_id = Rv_decrypt($post_data['article_id']);
            $unavailable_confirm = (isset($post_data['unavilable_status_confirm']) ? $post_data['unavilable_status_confirm'] : '');
            $unavilable_status = (isset($post_data['unavilable_status']) ? $post_data['unavilable_status'] : '');
            $msg = '';
            $already_added = array();
            $added = array();
            $total_assignments = 0;
            if (count($user_ids) > 0) {

                $Article_flow = new \App\Models\Article_flow;
                $Articles = new \App\Models\Articles;
                $Article_reviewers = new \App\Models\Article_reviewers;
                $Roles = new \App\Models\Roles;
                $Article_versions_reviewers = new \App\Models\Article_versions_reviewers;
                $User_to_journals = new \App\Models\User_to_journals;
                $Article_types = new \App\Models\Article_types;
                $User_articles = new \App\Models\User_articles;
                $Article_flow_alternativereviewer_priorityorder = new \App\Models\Article_flow_alternativereviewer_priorityorder;
                $generic_flow = new \App\Models\Generic_flows;
                $today = date('Y-m-d H:i:s', time());
                /*
                Get Article Details
                */
                $get_article_rec = $Articles::get_single_record('*', "art_id={$article_id}");

                /*
                Check User Have Permission to ShortList
                */
                $all_user_roles = $this->validate_user_journal($jnl_code, $current_user['user_id'], $get_article_rec->art_artp_id);
                $all_roles = $Roles::get_all_records('role_id,role_name,role_assigned_role');
                $array_data['user_roles'] = $all_user_roles;
                $array_data['article_id'] = $article_id;
                $array_data['all_roles'] = $all_roles;
                $array_data['jnl_id'] = $journal_id;
                $article_cur_stage = $Article_flow::get_aticle_statuses($article_id, $current_user, $current_stage_id, TRUE);
                $article_cur_stage = $article_cur_stage[0];
                /* start --- check if max number of reviewers has been alllocated */
                $condition['aflw_status'] = $article_cur_stage->aflw_status; //$current_stage_id
                $pool_id = Rv_decrypt($post_data['assigntype_pool_id']);
                $destination_review_stage =  Rv_decrypt($post_data['destination_review_stage']);
                $pool_min_max_count = $this->get_min_max_count_pre_review_stage($pool_id, $article_cur_stage->aflw_id, $article_cur_stage->jwf_id,$destination_review_stage);
                $where = "aflw_art_id={$article_id} AND aflw_jwf_id = {$destination_review_stage} AND aflw_assignment_type_id ={$pool_id} AND (aflw_source_assignment_id != 0 OR aflw_source_assignment_id != NULL)";
                $allocated_usrs = $Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt', $where);
                //$allocated_usrs = $this->Article_flow->get_stage_allocated_users($current_stage_id);
                $where_cond = "aflw_art_id={$article_id} AND aflw_jwf_id = {$destination_review_stage} AND aflw_assignment_type_id ={$pool_id} AND aflw_status='d'";
                $declined_users = $Article_flow::get_single_record('count(aflw_id) as count', $where_cond);

                //			$availble = $this->User_to_journals->find_filtered_users($journal_id, $current_stage_id, FALSE, $condition);
                $return_data['allocate_complete'] = FALSE;
                if ((($allocated_usrs->cnt + count($user_ids)) - $declined_users->count) >= $pool_min_max_count->min_user)
                    $return_data['allocate_complete'] = TRUE;

                if ($unavailable_confirm == 'y' && $unavilable_status == 0) {
                    $return_data['status'] = 'unavailable';
                    $return_data['msg'] = 'unavailable_user';
                    $return_data['valid_status'] = false;
                    return $this->success('success', 200, $return_data);
                }
                $m = $allocated_usrs->cnt;
                /* end --- check if max number of reviewers has been alllocated */
                $parent_status_record = $Article_flow::get_single_record('*', "aflw_id={$current_stage_id}");
                $Roles_table = (new \App\Models\Roles())->getTable();
                $Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                $criteria = 'jwf_id=:jwf_id';
                $binding_arr = array(
                    'jwf_id' => $destination_review_stage
                );
                $select = 'jwf_role_id,jwf_tat_complete,role_assigned_role,jwf_stage_type';
                $tables = array(
                    'main_table' => $Generic_flow_table,
                    'join_table' => array(
                        $Roles_table => array($Generic_flow_table . '.jwf_role_id', $Roles_table . '.role_id', 'join')
                    )

                );
                $destination_stage_details = $generic_flow::get_results_using_joins($tables, $select, $criteria, 'all',  NULL,  NULL, '',  NULL, NULL,  FALSE, NULL, FALSE, $binding_arr);
                $destination_stage_details = $destination_stage_details[0];
                $req_role_id = $destination_stage_details->jwf_role_id;
                //Article_flow::trans_start();
                $inserted_ids = array();
                $in = 0;
                $role_name_multi = '';
                $change_assignment = FALSE;

                //Task #5083 Modify alternative reviewer selection
                $order = 1;
                if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y') {
                    $article_flow_table = (new \App\Models\Article_flow)->getTable();;
                    $Article_flow_alternativereviewer_priorityorder_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
                    $tables = array(
                        'main_table' => $Article_flow_alternativereviewer_priorityorder_table,
                        'join_table' => array(
                            $article_flow_table => array($Article_flow_alternativereviewer_priorityorder_table . '.afap_aflw_id', $article_flow_table . '.aflw_id', 'join')
                        )
                    );
                    $sel_max_order = 'max(afap_number) as max_cnt_val';
                    $criteria = "aflw_art_id={$article_id} AND aflw_jwf_id = {$destination_review_stage} AND aflw_assignment_type_id ={$pool_id} AND (aflw_source_assignment_id != 0 OR aflw_source_assignment_id != NULL AND afap_art_id={$article_id})";
                    $max_order = $Article_flow_alternativereviewer_priorityorder::get_results_using_joins($tables, $sel_max_order, $criteria, 'single');
                    // $max_order = $Article_flow_alternativereviewer_priorityorder::get_single_record($sel_max_order, "afap_parent_flow_id={$current_stage_id} AND afap_art_id={$article_id}");
                    if ($max_order->max_cnt_val != NULL) {
                        $order = $max_order->max_cnt_val + 1;
                    }
                }

                foreach ($user_ids as $user_id) {
                    if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' && $article_cur_stage->jwf_stage_type == "review") {
                        $return_data = $this->get_current_user_only_reviewer_conditon($get_article_rec->art_artp_id, $article_id, $user_id, $jnl_code, $journal_id);
                        if (isset($return_data['msg']) && $return_data['msg'] != '')
                            return $this->success('warning', 200, $return_data);
                    }


                    $condition = "aflw_usr_id={$user_id} AND aflw_art_id={$article_id} AND aflw_jwf_id = {$destination_review_stage} AND aflw_assignment_type_id ={$pool_id}";
                    $get_record = $Article_flow::get_single_record('*', $condition);
                    if ($get_record != '') {
                        $already_added[] = $user_id;
                        $return_data['id_arr_duplication'][] = encrypt_link($user_id);
                    } else {

                        $data['aflw_usr_id'] = $user_id;
                        $data['aflw_art_id'] = $article_id;
                        $data['aflw_parent_flow_id'] = $current_stage_id;
                        $data['aflw_status'] = 'u';
                        $data['aflw_assigned_date'] = $today;
                        $data['aflw_source_assignment_id'] = $article_cur_stage->jwf_id;
                        $data['aflw_assignment_type_id'] = $pool_id;
                        $data['aflw_reviewer_added_by_stage_status'] = 'p';
                        $data['aflw_jwf_id'] = $destination_review_stage;
                        $data['aflw_level'] = $parent_status_record->aflw_level;

                        $inserted_id = $Article_flow::insert_record($data, $current_user);

                        $article_reviewer_data['sorw_aflw_id'] = $inserted_id;
                        $article_reviewer_data['sorw_suggested_reviewer_id'] = $user_id;
                        $article_reviewer_data['sorw_suggested_user_id'] = $current_user['user_id'];
                        $article_reviewer_data['sorw_suggested_on'] = $today;
                        $article_reviewer_data['sorw_art_id'] = $article_id;
                        $article_reviewer_data['sorw_user_added_by_status'] = 'p';
                        if (isset($post_data['usr_source']))
                            $article_reviewer_data['sorw_usr_source'] = $post_data['usr_source'];

                        $art_rev_id = $Article_reviewers::insert_record($article_reviewer_data, $current_user);

                        //Task #5083 Modify alternative reviewer selection
                        if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y' && in_array($user_id, $alternate_reviewers) == TRUE) {
                            $alter_arr = array(
                                'afap_usr_id' => $user_id,
                                'afap_art_id' => $article_id,
                                'afap_aflw_id' => $inserted_id,
                                'afap_parent_flow_id' => $current_stage_id,
                                'afap_sorw_id' => $art_rev_id,
                                'afap_number' => $order
                            );
                            $Article_flow_alternativereviewer_priorityorder::insert_record($alter_arr, $current_user);
                            if ($inserted_id)
                                $inserted_ids[$in]['afap_number'] = $order;
                            $order++;
                        }

                        if ($inserted_id) {
                            $inserted_ids[$in]['user'] = $user_id;
                            $inserted_ids[$in]['flow'] = $inserted_id;
                            $inserted_ids[$in]['review'] = $art_rev_id;
                            $in++;
                            /* start  --- add the user with reviewer role to journal users if not added */
                            $user_role_details = "usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$req_role_id} AND usrj_artp_id IS NULL";
                            $jnl_spec_rev_record = $User_to_journals::get_single_record('*', $user_role_details);
                            $user_role_details_insert = array(
                                'usrj_jnl_id' => $journal_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $req_role_id,
                                'usrj_artp_id' => NULL,
                            );
                            if ($jnl_spec_rev_record == NULL) {

                                $user_role_id = $User_to_journals::insert_record($user_role_details_insert, $current_user);
                            }
                            $user_role_details_art_type = "usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$req_role_id} AND usrj_artp_id ={$get_article_rec->art_artp_id}";
                            //register user as article type reviewer

                            $art_type_spec_rev_record = $User_to_journals::get_single_record('*', $user_role_details_art_type);

                            if ($art_type_spec_rev_record == NULL) {
                                $user_role_details_insert['usrj_artp_id'] = $get_article_rec->art_artp_id;
                                $user_role_id = $User_to_journals::insert_record($user_role_details_insert, $current_user);
                            }
                            /* end  --- add the user with reviewer role to journal users if not added */
                            $added[] = $user_id;
                            $total_assignments++;
                            $return_data['id_arr_alloacted'][] = encrypt_link($user_id);
                            if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                                $del_criteria = "usra_art_id={$article_id} AND usra_usr_id={$user_id}";
                                $User_articles::delete_records($del_criteria, '', $current_user);
                            }
                        } else {
                            $return_data['msg'] = 'Sorry ! some error occured';
                            return $this->success('warning', 200, $return_data);
                        }
                        //Enhancement#2068 Self and Assignmet type processing on production and ReView
                        //only below code work when assign reviewers
                        
                       /* if ($destination_stage_details->jwf_stage_type == 'review' && $destination_stage_details->role_assigned_role == 'reviewer') {
                            $revier_exist = $Article_versions_reviewers::get_single_record('count(artvr_id) as count', "artvr_article_id={$article_id} AND artvr_user_id={$user_id}");
                            if ($revier_exist->count > 0) {
                                $criteria_revwr = "artvr_article_id={$article_id} AND artvr_user_id={$user_id}";
                                $Article_versions_reviewers::delete_records($criteria_revwr, '', $current_user);
                            }

                            $reviwers_details = array(
                                'artvr_user_id' => $user_id,
                                //'artvr_prev_art_id' => $user_id,
                                'artvr_article_id' => $article_id,
                                'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
                            );
                            $Article_versions_reviewers::insert_record($reviwers_details, $current_user);
                        }*/
                    }
                }

                if ($change_assignment == TRUE) {
                    //echo $role_names.'<br/>';
                    $role_display_arr = explode(',', $role_name_multi);
                    $role_name_multiple = str_replace(',' . end($role_display_arr), ' and ' . end($role_display_arr), $role_name_multi);
                    $msgdata = 'You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.';
                    $msg .= str_replace('##roles##', $role_name_multiple, $msgdata);
                    return $this->success('warning', 200, $return_data);
                }
                
                if (!empty($added)) {

                    if ($destination_stage_details->jwf_stage_type == 'review') {
                        //Task #140: JPR-136 BUG: Overdue Reviewer Selection
                        $today = date('Y-m-d H:i:s', time());
                        $invite_due_date = new DateTime($today);

                        $invite_due_date = $invite_due_date->modify('+' . $destination_stage_details->jwf_tat_complete . ' days');
                        $invite_due_date = $invite_due_date->format('Y-m-d H:i:s');

                        $Article_flow::update_record(array(
                            'aflw_invite_due_date' => $invite_due_date
                        ), "aflw_id={$current_stage_id}",NULL,NULL,'e');
                    }
                    $return_data['assignment_completed'] = FALSE;
                    if (!empty($already_added)) {
                        $return_data['msg'] = 'User assignment failed. The user has already been assigned to this stage.';
                        return $this->success('warning', 200, $return_data);
                    }
                }
                return $this->success('success', 200, $return_data);
            } else {
                //lang('stage_user_alocation_failed');
                $return_data['msg'] = 'User allocation failed. You have not selected any users.';
                return $this->success('success', 200, $return_data);
            }

            return $this->success('success', 200, $return_data);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function save_min_max_count_for_pre_review_stage(Request $request)
    {
        try {
            $Workflow_Assignment_User_Parent_Flow_based = new \App\Models\Workflow_Assignment_User_Parent_Flow_based;
            $post_data = $request->all();
            $result=array();
            $validator = Validator::make($request->all(), [
                'assignment_type_id' => 'required',
                'source_jwf_id' => 'required',
                'flow_master_id' => 'required',
                'source_article_flow_id' => 'required',
                'destination_jwf_id' => 'required',
                'min_user_count' => 'required',
                'max_user_count' => 'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $current_user = $this->get_current_user_details();
            $data = array(
                'waup_wa_id' => decrypt_link($post_data['assignment_type_id']),
                'waup_souce_jwf_id' => decrypt_link($post_data['source_jwf_id']),
                'waup_destination_jwf_id' => decrypt_link($post_data['destination_jwf_id']),
                'waup_flow_master_id' => decrypt_link($post_data['flow_master_id']),
                'waup_source_aflw_id' => decrypt_link($post_data['source_article_flow_id']),
                'waup_minimum_user' => $post_data['min_user_count'],
                'waup_maximum_user' => $post_data['max_user_count']
            );
            $pool_id = decrypt_link($post_data['assignment_type_id']);
            $source_jwf_id = decrypt_link($post_data['source_jwf_id']);
            $source_aflw_id = decrypt_link($post_data['source_article_flow_id']);
            $destination_jwf_id = decrypt_link($post_data['destination_jwf_id']);
            $update_criteria = array(
                'waup_wa_id' => $pool_id,
                'waup_souce_jwf_id' => $source_jwf_id,
                'waup_source_aflw_id' => $source_aflw_id,
                'waup_destination_jwf_id' => $destination_jwf_id
            );
            $waup_id = $Workflow_Assignment_User_Parent_Flow_based::get_single_record_with_bind_cond('waup_id',$update_criteria);
            if (isset($waup_id->waup_id) && !empty($waup_id->waup_id)) {
                $id = $waup_id->waup_id;
                $condition = array(
                    "waup_id" => $id
                );
                $Workflow_Assignment_User_Parent_Flow_based::update_record($data, $condition, $current_user);
            } else {
                $Workflow_Assignment_User_Parent_Flow_based::insert_record($data, $current_user);
            }
            $result['status'] = 'success';
            $result['message'] = 'Number of reviewers successfully changed.';
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_reviewer_assignment_to_pre_review_stage(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'status_id' => 'required',
                'jnl_id' => 'required',
                'curent_article' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_table = (new \App\Models\Articles())->getTable();
            $article_type_table = (new \App\Models\Article_types())->getTable();
            $article_flow_table = (new \App\Models\Article_flow())->getTable();
            $article_reviwers_table = (new \App\Models\Article_reviewers())->getTable();
            $reject_reason_table = (new \App\Models\Reject_reasons())->getTable();
            $article_flow_alternativereviewer_priorityorder_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
            $usertable = (new \App\Models\User())->getTable();
            $generic_flow = new \App\Models\Generic_flows;


            $is_previous = FALSE;
            $excluded_deleted_status_arr = array(
                'w',
                'h'
            );
            parse_str(decrypt_link($post_data['select']), $_GET);
            $article_id = decrypt_link($post_data['article_id']);

            $jnl_code = $post_data['jnl_code'];
            $jnl_id = decrypt_link($post_data['jnl_id']);
            $flow_id = decrypt_link($post_data['status_id']);
            $curent_article_id = decrypt_link($post_data['curent_article']);
            $destination_id = decrypt_link($post_data['destination_review_stage']);
            $input_arr = array(
                'input' => $article_id,
                'type' => 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $flow_id,
                'type' => 'number'
            );
            $flow_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $curent_article_id,
                'type' => 'number'
            );
            $curent_article_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $jnl_id,
                'type' => 'number'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            if ($art_id_validate == FALSE || $flow_id_validate == FALSE || $curent_article_id_validate == FALSE || $jnl_id_validate == FALSE) {
                $arraymsg['mesage'] = trans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }

            $date_format = $this->get_platform_date_format($jnl_id);
            $date_format = $this->date_format_map($date_format);

            if ($article_id != $curent_article_id) {
                $is_previous = TRUE;
            }
            $pool_id = decrypt_link($post_data['assignment_pool_id']);
            $destination_review_stage =  decrypt_link($post_data['destination_review_stage']);

            $current_stage_status = Article_flow::get_single_record_with_bind_cond('aflw_status,aflw_jwf_id',array('aflw_id'=>$flow_id));
            $Roles_table = (new \App\Models\Roles())->getTable();
            $Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $criteria = 'jwf_id=:jwf_id';
            $binding_arr = array(
                'jwf_id' => $destination_review_stage
            );
            $select = 'jwf_id,jwf_role_id,jwf_tat_complete,role_name,role_assigned_role,role_name,jwf_stage_type,jwf_assignment,jwf_fwm_id';
            $tables = array(
                'main_table' => $Generic_flow_table,
                'join_table' => array(
                    $Roles_table => array($Generic_flow_table . '.jwf_role_id', $Roles_table . '.role_id', 'join')
                )

            );
            $destination_stage_details = $generic_flow::get_results_using_joins($tables, $select, $criteria, 'all',  NULL,  NULL, '',  NULL, NULL,  FALSE, NULL, FALSE, $binding_arr);
            $article_flow_details = $destination_stage_details[0];
            $join_flow_reviwewer = " FROM " . $article_flow_table . " as af INNER JOIN " . $article_reviwers_table . " ON sorw_aflw_id=aflw_id";
            $reject_reson_join = '';
            $alternative_reviwer_join = '';
            $assg_criteria = " WHERE aflw_art_id={$article_id} AND aflw_jwf_id = {$destination_review_stage} AND (aflw_source_assignment_id != 0 OR aflw_source_assignment_id != NULL)";
            $show_invited = ($article_flow_details->jwf_assignment == 'invitation') ? TRUE : FALSE;
            $order_by = '';
            $select = 'SELECT sorw_id,aflw_id,aflw_usr_id,aflw_status,sorw_invited_by,sorw_suggested_user_id,aflw_due_date,DATE_FORMAT(sorw_suggested_on, "' . $date_format . '") as suggested_date,DATE_FORMAT(sorw_invited_on, "' . $date_format . '") as invited_date,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as due_date,aflw_posted_by,aflw_remarks,aflw_returned_date,aflw_usr_review_reopen,sorw_author_suggested';
            $workflow_assignment_type_selection = $this->workflow_assignment_type_seletion_status($article_flow_details->jwf_stage_type);
            if (isset($pool_id) && !empty($pool_id)) {
                $assg_criteria .= ' AND aflw_assignment_type_id=' . $pool_id;
            }
            if ($article_flow_details->jwf_stage_type == 'review') {
                $select .= ',IF(((select max(b.aflw_id) from ' . $article_flow_table . ' as b  where b.aflw_usr_id = af.aflw_usr_id and b.aflw_assignment_type_id = af.aflw_assignment_type_id AND b.aflw_jwf_id = af.aflw_jwf_id AND b.aflw_art_id = af.aflw_art_id ) = af.aflw_id) && rjct_reinvite_flag ="y"  && (select count(aflw_id) from ' . $article_flow_table . ' as c  where c.aflw_usr_id = af.aflw_usr_id and c.aflw_assignment_type_id = af.aflw_assignment_type_id and c.aflw_jwf_id = af.aflw_jwf_id and c.aflw_art_id = af.aflw_art_id and c.aflw_status != "i" and c.aflw_status !="a" and c.aflw_status !="c")>0,1,0) as reinvte_condition,IF( ( ( SELECT MAX(d.aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_assignment_type_id = af.aflw_assignment_type_id AND d.aflw_jwf_id = af.aflw_jwf_id AND d.aflw_art_id = af.aflw_art_id ) = af.aflw_id and af.aflw_status = "g" ) > 0, 1, 0 ) AS reinvte_unassigned_condition,(select count(aflw_id) from ' . $article_flow_table . ' as d  where d.aflw_usr_id = af.aflw_usr_id and d.aflw_assignment_type_id = af.aflw_assignment_type_id AND d.aflw_jwf_id = af.aflw_jwf_id AND d.aflw_art_id = af.aflw_art_id) as reviewer_invite_count,IF( ( ( SELECT MAX(e.aflw_id) FROM rvw_article_flow AS e WHERE e.aflw_usr_id = af.aflw_usr_id AND e.aflw_assignment_type_id = af.aflw_assignment_type_id AND e.aflw_jwf_id = af.aflw_jwf_id AND e.aflw_art_id = af.aflw_art_id) = af.aflw_id ) &&( SELECT COUNT(aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_assignment_type_id = af.aflw_assignment_type_id AND d.aflw_jwf_id = af.aflw_jwf_id AND d.aflw_art_id = af.aflw_art_id AND d.aflw_status = "d") <= 1, 1, 0 ) AS reviewer_invite_condition,sorw_usr_source';
                $reject_reson_join = " LEFT JOIN " . $reject_reason_table . " ON sorw_rjct_id=rjct_id";


                if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')) {
                    $select .= ',afap_id,afap_number';
                    $order_by = ' ORDER BY afap_number ASC';
                    $alternative_reviwer_join = " LEFT JOIN " . $article_flow_alternativereviewer_priorityorder_table . " ON afap_aflw_id = aflw_id";
                }
                /* to recognise if added through reviewer on fly or not */
                $select .= ',(CASE WHEN sorw_usr_source=\'p\' THEN \'n\' WHEN `sorw_posted_by`=`sorw_suggested_user_id` and EXISTS(SELECT `usr_id` FROM ' . $usertable . ' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\' and `usr_status`=\'w\')   then \'y\' else \'n\' end ) as added_through_fly,(SELECT DATE_FORMAT(usr_posted_date, "' . $date_format . '") as user_posted FROM '.$usertable.' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
                and `usr_status`=\'w\') as user_posted_date';
                /* to recognise if added through reviewer on fly or not */
            }
            $assigned_users_sql = $select . $join_flow_reviwewer . $reject_reson_join . $alternative_reviwer_join . $assg_criteria . $order_by;

            //$assigned_users = $this->Article_flow->get_results_using_joins($assg_tables, 'all', $select, $assg_criteria,$order_by);
            $assigned_users = Article_flow::get_records_by_raw_query($assigned_users_sql);
            $conflict_interest = array();
            if ($article_flow_details->jwf_stage_type == 'review' && $this->current_client->modules->mdl_review_for_doc == 'n') {
                $conflict_interest = $this->get_article_conflict_array($article_id);
            }
            /* #625 Queue system for shortlisted reviewers auto invitation client functionality */
            $enable_reviewer_queue = FALSE;

            if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')) {
                $enable_reviewer_queue = TRUE;
            }
            $article_table = (new \App\Models\Articles())->getTable();
            $article_type_table = (new \App\Models\Article_types())->getTable();
            $Article = new \App\Models\Articles;
            $art_tables = array(
                'main_table' => $article_table,
                'join_table' => array(
                    $article_type_table => array($article_table . '.art_artp_id', $article_type_table . '.artp_id')

                )
            );

            $art_criteria = "art_id={$article_id}";
            $selectfields = 'art_id,artp_id,artp_fwm_id,art_status,art_stub,art_artp_id,art_article_upload_path,art_submitted_by,art_delete_status';

            $article_data = $Article::get_results_using_joins($art_tables, $selectfields, $art_criteria, 'single');

            //($art_tables, 'single', 'art_id,artp_id,artp_fwm_id,atotp_review_method,atotp_rate_reviewer,art_status,art_stub,atotp_rescind_review,art_artp_id,atotp_primary_class,atotp_secondary_class,atotp_classification_hierarchy', $art_criteria);
            $pool_min_max_count = $this->get_min_max_count_pre_review_stage($pool_id, $flow_id, $current_stage_status->aflw_jwf_id,$destination_review_stage);
            $read_only = FALSE;

            $role_id = $article_flow_details->jwf_role_id;
            $data['article_id'] = $article_id;
            $data['action_stage_id'] = $flow_id;
            $data['jwf_id'] = $article_flow_details->jwf_id;
            $data['article_type'] = $article_data->artp_id;
            $data['role'] = $role_id;
            $data['role_id'] = $role_id;
            $data['stage_role_name'] = $article_flow_details->role_name;
            $data['read_only'] = $read_only;
            $data['min_review_cnt'] = $pool_min_max_count->min_user;
            $data['max_review_cnt'] = $pool_min_max_count->max_user;
            $article_flow_details->aflw_stage_min_users = $pool_min_max_count->min_user;
            $article_flow_details->aflw_stage_max_users = $pool_min_max_count->max_user;
            $data['show_invited'] = $show_invited;
            $data['show_other_details'] = TRUE;
            $data['parent_flow_id'] = $flow_id;
            $data['type'] = 'stage';
            $data['invitation_status'] = invitation_status();
            //$data['titles'] = $this->user->titles;

            $data['next_stage_id'] = '';
            $data['enable_reviewer_queue'] = $enable_reviewer_queue;
            $data['jwf_assignment'] = $article_flow_details->jwf_assignment;
            $data['has_invite_permission'] = TRUE;
            $data['has_assign_permission'] = TRUE;
          /*  */
            if ($article_flow_details->jwf_stage_type == 'review') {
                $active_pool_id = '';
                $active_destination_id = '';
                if (isset($_GET['pool_id']) && $_GET['pool_id'] != '')
                $active_pool_id = decrypt_link($_GET['pool_id']);
                if (isset($_GET['destination_id']) && $_GET['destination_id'] != '')
                {
                $active_destination_id = decrypt_link($_GET['destination_id']);
                }
                $array_data['active_destination_id'] = $active_destination_id;
                $array_data['active_pool_id']=$active_pool_id;
                $array_data['workflow_stage_id']=$current_stage_status->aflw_jwf_id;
                $array_data['flow_master_id'] = $article_flow_details->jwf_fwm_id;
                $array_data['post_assign_pool_id']=$pool_id;
                $array_data['post_assign_destination_id'] = $destination_id;
                $array_data['flow_status']=$current_stage_status->aflw_status;
                $array_data['article_id']=$article_id;
                $data_action_stage=$this->get_show_stage_readonly_or_action($array_data);

                $current_status_id = decrypt_link($post_data['current_status_id']);
              //  $current_stage_active = ($current_status_id == $flow_id) ? TRUE : FALSE;
                $data['current_stage_active'] =$data_action_stage['current_stage_active'];

                $enable_button_active =$data_action_stage['enable_button_active'];;
                $enable_edit_reviewer_count = TRUE;
                /*  if(isset($article_data->jp_edit_reviewer_count)&&count(array_intersect($user_roles['role_id'],json_decode($article_data->jp_edit_reviewer_count)))>0)
             {
             $enable_edit_reviewer_count = TRUE;	
             } */
                //$stage_completed = ($child_stage_count->completed_child_stages == $article_flow_details->aflw_stage_min_users || $article_flow_details->aflw_satus == 'c') ? TRUE : FALSE;

                $excluded_deleted_status_arr = array(
                    'w',
                    'h'
                );

                if (isset($article_data->art_delete_status) && in_array($article_data->art_delete_status, $excluded_deleted_status_arr)) {
                    $enable_button_active = FALSE;
                }

                //  $flow_id = ($article_flow_details->aflw_parent_flow_id == NULL) ? $article_flow_details->aflw_id : $article_flow_details->aflw_parent_flow_id;

                $data['enable_button_active'] = $enable_button_active;
                $data['readonly_button'] = 'Edit reviewer list';

                $data['article_flow_details'] = $article_flow_details;
                //  $data['show_next_stage_button'] = $show_next_stage_button;
                $data['show_multiple_checkbox'] = TRUE;

                $data['read_only'] = FALSE;
                if (in_array($article_data->art_delete_status, $excluded_deleted_status_arr)) {
                    $data['current_stage_active'] = FALSE;
                    $data['read_only'] = TRUE;
                    $data['enable_button_active'] = FALSE;
                }
                if ((isset($article_data->art_status)) && ($article_data->art_status == 'c')) {
                    $data['current_stage_active'] = FALSE;
                }
                //#3323 Setting re-open review button on the reviewer list
                $data['article_data_set'] = $article_data;
                $data['is_previous'] = $is_previous;
                $data['is_previous'] = $is_previous;
                $data['assignment_only'] = FALSE;
                $data['reopen'] = FALSE;
                //$data['cfty_enable_review_resubmit']=$this->current_client->functionality->cfty_enable_review_resubmit;
                $arr_set = array('a', 'r', 'c');
                if (isset($this->current_client->functionality->cfty_enable_review_resubmit) && $this->current_client->functionality->cfty_enable_review_resubmit == 'y' && (isset($article_data->art_status) && !in_array($article_data->art_status, $arr_set)) && (isset($is_previous) && $is_previous == FALSE) && $article_data->art_delete_status == 'n') {
                    $data['reopen'] = TRUE;
                }
                $notinviteduser = array();
                if (!empty($assigned_users)) {

                    foreach ($assigned_users as $assg) {
                        $due_date = $assg->aflw_due_date;
                        $assg_date_format = $this->get_platform_date_format($jnl_id);
                        $assg->assg_date_format = $assg_date_format;
                        $date_diff = time() - strtotime($due_date);
                        $days = round($date_diff / (60 * 60 * 24));
                        $assg->due_date_danger = FALSE;
                        if ($days > 0) {
                            $assg->due_date_danger = TRUE;
                            $assg->due_date = $assg->due_date;
                        }
                        $alt_txt = NULL;
                        if (isset($assg->afap_number)) {
                            $alt_txt = $assg->afap_number;
                        }
                        $array_data['user_id'] = $assg->aflw_usr_id;
                        $array_data['journal_id'] = $jnl_id;
                        $array_data['flag'] = TRUE;
                        $array_data['article_id'] = $article_id;
                        if ($alt_txt != NULL)
                            $array_data['alternate_no'] = $alt_txt;
                        $array_data['availability'] = TRUE;

                        $array_data['jnl_code'] = $jnl_code;
                        if (isset($assg->aflw_usr_id) && ($assg->aflw_usr_id != NULL))
                            $array_data['conflict_interest'] = $this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                        $assg->short_listed_user = $this->get_user_display_name($array_data);

                        $assg->suggested_user = '';
                        $array_data['conflict_interest'] = '';
                        if ($assg->sorw_suggested_user_id != NULL) {
                            $array_data['user_id'] = $assg->sorw_suggested_user_id;
                            $array_data['journal_id'] = $jnl_id;
                            $array_data['flag'] = TRUE;
                            $array_data['article_id'] = $article_id;
                            $array_data['availability'] = TRUE;
                            $array_data['alternate_no'] = '';
                            $array_data['jnl_code'] = $jnl_code;
                            $assg->suggested_user = $this->get_user_display_name($array_data);
                        }
                        $assg->invited_user = '';
                        if ($assg->sorw_invited_by != NULL) {
                            $array_data['user_id'] = $assg->sorw_invited_by;
                            $array_data['journal_id'] = $jnl_id;
                            $array_data['flag'] = TRUE;
                            $array_data['article_id'] = $article_id;
                            $array_data['availability'] = TRUE;
                            $array_data['alternate_no'] = '';
                            $array_data['jnl_code'] = $jnl_code;
                            $assg->invited_user = $this->get_user_display_name($array_data);

                            if ($assg->sorw_invited_by == 0) {

                                $assg->invited_user = 'system';
                            }
                        }
                        $assg->invited_user_id = $assg->sorw_invited_by;
                        $show_conflict_interest_message = array();
                        if (!empty($conflict_interest)) {
                            $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                        }
                        $assg->conflict_message = $show_conflict_interest_message;
                        $assg->unregistered_user = $this->check_usr_account($assg->aflw_usr_id);
                        if ($assg->aflw_status == 'u' && $assg->unregistered_user == false) {
                            array_push($notinviteduser, $assg->aflw_usr_id);
                        }
                        $assg->invitationstatus = $this->check_invitation_status($data, $assg);
                    }
                }
                $data['not_invited_users'] = $notinviteduser;
                $data['assigned_users'] = $assigned_users;
                $data['shortlistinfo'] = $this->get_short_list_details($flow_id,$pool_id,$article_id,$destination_review_stage);
                $data['enable_reviewer_count'] = $enable_edit_reviewer_count;
            }



            return $this->success('success', 200, $data);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_pre_review_stage_permission(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'aflw_id' => 'required',
                'jnl_id' => 'required',

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $post_data = $request->all();

            parse_str(decrypt_link($post_data['select']), $_GET);
            $this->current_user = $this->get_current_user_details();
            $article_id = decrypt_link($post_data['article_id']);
            $jnl_code = $post_data['jnl_code'];
            $jnl_id = decrypt_link($post_data['jnl_id']);
            $flow_id = decrypt_link($post_data['aflw_id']);
            $pool_id = $post_data['pool_id'];
            $destination_id = decrypt_link($post_data['destination_id']);
            $input_arr = array(
                'input' => $article_id,
                'type' => 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $flow_id,
                'type' => 'number'
            );
            $flow_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $jnl_id,
                'type' => 'number'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            if ($art_id_validate == FALSE || $flow_id_validate == FALSE || $jnl_id_validate == FALSE) {
                $arraymsg['mesage'] = trans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }


            $flow_privilages = $this->get_article_flow_privilages($article_id, $flow_id, $jnl_code, $jnl_id);
            $article_flow_details = $flow_privilages['article_flow_details'];
            $active_pool_id = '';
            $active_destination_id = '';
            if (isset($_GET['pool_id']) && $_GET['pool_id'] != '')
            {
            $active_pool_id = decrypt_link($_GET['pool_id']);
            }
            if (isset($_GET['destination_id']) && $_GET['destination_id'] != '')
            {
            $active_destination_id = decrypt_link($_GET['destination_id']);
            }
            $array_data['active_pool_id']=$active_pool_id;
            $array_data['active_destination_id'] = $active_destination_id;
            $array_data['workflow_stage_id']=$article_flow_details->jwf_id;
            $array_data['flow_master_id'] = $article_flow_details->jwf_fwm_id;
            $array_data['post_assign_pool_id']=$pool_id;
            $array_data['post_assign_destination_id'] = $destination_id;
            $array_data['flow_status']=$article_flow_details->aflw_status;
            $array_data['article_id']=$article_id;
            $data=$this->get_show_stage_readonly_or_action($array_data);
            // $data['show_invited'] = $show_invited;
            return  $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    

    public function get_show_stage_readonly_or_action($array_data)
    {
        try {
        $active_pool_id = isset($array_data['active_pool_id']) ? $array_data['active_pool_id'] : '';
        $active_destination_id = isset($array_data['active_destination_id']) ? $array_data['active_destination_id'] : '';
        $workflow_stage_id = isset($array_data['workflow_stage_id']) ? $array_data['workflow_stage_id'] : '';
        $flow_master_id = isset($array_data['flow_master_id']) ? $array_data['flow_master_id'] : '';
        $post_assign_pool_id = isset($array_data['post_assign_pool_id']) ? $array_data['post_assign_pool_id'] : '';
        $flow_status = isset($array_data['flow_status']) ? $array_data['flow_status'] : '';
        $post_assign_destination_id = isset($array_data['post_assign_destination_id']) ? $array_data['post_assign_destination_id'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        if ($active_pool_id == '' && $active_destination_id == '')
         {
            $workflow_id = $workflow_stage_id;
            $flow_master_id = $flow_master_id;
            /* Task #1986 Reviewer Pool Still Visible After Completion or Skipping of Parallel Reviewer Stage */
            $get_selected_workflow_assignment_for_source_stage = $this->get_selected_workflow_assignment_type_for_source_or_destination_stage_view_article($workflow_id, TRUE, $flow_master_id,$article_id);
            if ((!empty($get_selected_workflow_assignment_for_source_stage)) && isset($get_selected_workflow_assignment_for_source_stage[0]['pool_id'])) {
                $active_pool_id = $get_selected_workflow_assignment_for_source_stage[0]['pool_id'];
                $active_destination_id = $get_selected_workflow_assignment_for_source_stage[0]['pool_workflow_assignment_desination_id'];
            }
        }
        $current_stage_active = ( ($post_assign_pool_id == $active_pool_id) && ($post_assign_destination_id == $active_destination_id ) ) ? TRUE : FALSE;
        $enable_button_active = FALSE;
        if($current_stage_active == TRUE){
            $enable_button_active = TRUE;
        }
        if ($flow_status == 'c') {
            $enable_button_active = FALSE;
        }
  /*TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review*/
  $data['enable_author_suggested_reviewers']=$this->get_author_suggested_reviewstage_flag($article_id);
  /* End*/ 

        $data['current_stage_active'] = $current_stage_active;
        $data['has_assign_permission'] = true;
        $data['has_invite_permission'] = true;
        $data['enable_button_active'] = $enable_button_active;
        return $data;
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
}
