<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\SearchArticleTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\SubmissionTrait;
use App\Http\Traits\ArticlelistTrait;
use  App\Http\Traits\UserDataTrait;
use Config;
use DB;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Authors;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use Response;
use Illuminate\Support\Facades\Storage;
use App\Consts;

class Manage_Search_Article_Api extends Controller
{
    use SearchArticleTrait;
    use RolesConfigTrait;
	use SubmissionTrait;
	use ArticlelistTrait;
	use UserDataTrait;
/*
     Dashboard Api 
*/
    public function index(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
				'jnl_id' => 'required',
				'jnl_code' => 'required',
				'role_id' => 'required',
				'core_role' => 'required',
			]);

            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            else
            {
				$post_data=$request->all();	
				$current_user = $this->get_current_user_details();
				
				$input_arr = array(
					'input' => $post_data['jnl_id'],
					'type'=> 'number'
				);
				$jnl_id_validate = $this->Rv_validator($input_arr);
				
				$input_arr['input']= $post_data['role_id'];
				$role_id_validate = $this->Rv_validator($input_arr);

				$input_arr = array(
					'input' => $post_data['jnl_code'],
				);
				
				$jnl_code_validate = $this->Rv_validator($input_arr);

				$input_arr['input']= $post_data['core_role'];
				$core_role_validate = $this->Rv_validator($input_arr);

				$search_items = array('article_id','article_title','user_email','user_name');

				if(isset($post_data['search_by']) && isset($post_data['search_value']) && $jnl_id_validate == TRUE && $role_id_validate == TRUE && $jnl_code_validate == TRUE && $core_role_validate == TRUE && in_array($post_data['search_by'],$search_items))
				{
					$retun_array=array();
					$search_by_arr = array('article_id','article_title');
					//$core_role_exclude = array('reviewer');
					
					if(in_array($post_data['search_by'],$search_by_arr) && isset($post_data['jnl_id']) && isset($post_data['core_role']) && isset($post_data['role_id']) /*&& !in_array($post_data['core_role'],$core_role_exclude)*/)
					{
						$post_data['post_from'] = 'normal_search';	
						
						//currently author and reviewer current core role search avoid from this
						$search_data=$this->get_search_article_details($post_data);
						$search_data['type'] = 'article';
					}
					else
					{ 
						$search_data=$this->global_format_search_article($post_data);
					}
					
					return $this->success('success',200,$search_data);
				}
				else
				{
					return $this->warning('Warning',200,customTrans('auth.invalid_data'),'warning');					
				}
			}
        }
        catch(\exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
        
    }
	public function global_format_search_article($post = null, $all_art_ids = null, $jnl_data = null, $current_user = null, $current_client = null, $limit = null, $start = null,$order_by = null,$advanced= FALSE, $next_data = NULL) 
	{
		$jnl_code = $post['jnl_code'];
		$jnl_id=  $post['jnl_id'];		
		$core_role = $post['core_role'];
		$rol_id=$post['role_id'];
		$limit=10;
		$post_data = $post;
	
		$this->current_user = $this->get_current_user_details();
         $User=new \App\Models\User();
		 $Journals=new \App\Models\Journals();
		 $Journal_settings=new \App\Models\Journal_settings();
		 $User_to_journals=new \App\Models\User_to_journals();
		 $Roles=new \App\Models\Roles();
		 $Article_flow=new \App\Models\Article_flow();
		 $Article_notes=new \App\Models\Article_notes();
		 $Keywords=new \App\Models\Keywords();
		 $Article_keywords=new \App\Models\Article_keywords();
		 $Generic_flows=new \App\Models\Generic_flows();
		 $Generic_forms=new \App\Models\Generic_forms();
		 $Article_generic_form_data=new \App\Models\Article_generic_form_data();
		 $Review_rating=new \App\Models\Review_rating();
		 $Articles=new \App\Models\Articles();
		 $Article_types=new \App\Models\Article_types();
		 $Assign_permission=new \App\Models\Assign_permission();
		 $User_articles=new \App\Models\User_articles();
		 $Payment_order=new \App\Models\Payment_order();
		 $Custom_email_template_tags=new \App\Models\Custom_email_template_tags();
		 $Stage_email_templates=new \App\Models\Stage_email_templates();
		 $Article_type_advance_options=new \App\Models\Article_type_advance_options();
		 $Article_flag=new \App\Models\Article_flag();
		 $Flag=new \App\Models\Flags();
		 $Article_reviewers=new \App\Models\Article_reviewers();
		 $Article_versions_reviewers=new \App\Models\Article_versions_reviewers();
		 $Authors = new \App\Models\Authors;
		 $user_journal_table=(new \App\Models\User_to_journals())->getTable();
		 $user_article_table=(new \App\Models\User_articles())->getTable();
		 $article_version_table=(new \App\Models\Article_versions_reviewers())->getTable();

		
		$privileged_user = $this->has_journal_privilege($jnl_code,$this->current_user['user_id']);
		$user_roles = $this->validate_user_journal($jnl_code, $this->current_user['user_id']);

	
		//$jnl_data = $Journal_settings::get_single_record('*',"jset_jnl_id={$jnl_id}");
       $date_format=$this->get_platform_date_format($jnl_id);
	   $date_format= $this->date_format_map($date_format);
	
		$generic_tab_result = array();
		$criteria = array();
		$search_for = '';
		$search_text = '';
        
		$select_data=$this->select_sql($date_format);
		if (!empty($post_data['search_value']) || $all_art_ids != null)
		 {
			$post_value = $post_data['search_value'];
			//RVW694 avoid sql injection  
			//$post_data['search_value'] = $this->db->escape_str($post_data['search_value']);

			if ($all_art_ids != null) {
				$criteria['art_id'] = $all_art_ids;
				$search_for = 'article';
				$search_text = 'Article ID';
			} elseif ($post_data['search_by'] == 'article_id') {
				$criteria['art_code'] = trim($post_data['search_value']);
				$search_for = 'article';
				$search_text = 'Article ID';
			} elseif ($post_data['search_by'] == 'article_title') {
				$criteria['art_title'] = trim($post_data['search_value']);
				$search_for = 'article';
				$search_text = 'Article Title';
			} elseif ($post_data['search_by'] == 'user_email') {
				$criteria['usr_email'] = trim($post_data['search_value']);
				$search_for = 'user';
				$search_text = 'Email Address';
			} elseif ($post_data['search_by'] == 'user_name') {
				$criteria["CONCAT(usr_first_name,' ',usr_last_name)"] = trim($post_data['search_value']);
				$search_for = 'user';
				$search_text = 'Name';
			} elseif ($post_data['search_by'] == 'adv_article_search') {//to do
				$search_text = 'Adv. Article search';
			} elseif ($post_data['search_by'] == 'adv_user_search') {// to do
				$search_text = 'Adv. User search';
			} else {
				$criteria['art_code'] = trim($post_data['search_value']);
				$search_for = 'article';
				$search_text = 'Article ID';
			} 
		
			
			if ($search_for == 'article') {

				$article_table=(new \App\Models\Articles())->getTable();
				$user_article_table=(new \App\Models\User_articles())->getTable();
				$article_flow_table=(new \App\Models\Article_flow())->getTable();
				$generic_flow_table=(new \App\Models\Generic_flows())->getTable();
				$roles_table=(new \App\Models\Roles())->getTable();
			    $userjournal_table=(new \App\Models\User_to_journals())->getTable();
				$condition = array();
				$privilege_usr_as_reviewer = '';
				$sort_field ='art_id';
				$sort_order ='asc';
				$i = 0;
              
                /* Search criteria Condition */
				$wherecond='';
				foreach ($criteria as $key => $val) {
					if ($i == 0)
						$wherecond .= '' . $key . " LIKE '%$val%'";
					else
						$wherecond .= ' AND ' . $key . " LIKE '%$val%'";

					$i++;
				}
				
				/* Roles in System Config and DB */   
				$privileged_core_roles = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
				$all_roles = $Roles::get_all_records('role_id,role_assigned_role,role_name');
				$permitted_roles = $associate_roles = $editor_roles = $user_all_roles = $user_permitd = $production_roles = $privileged_user_roles = array();
				if (!empty($all_roles)) {
					foreach ($all_roles as $al)
					{
						if ($al->role_assigned_role == 'staff' || $al->role_assigned_role == 'journal_admin'  /*|| $al->role_assigned_role == 'author' */ )
							{ //Task #424 Production Management
								$permitted_roles[] = $al->role_id;
                                $user_permitd[] = $al->role_id;
							}
							//Task #424 Production Management
							$search_criteria_production_roles=array('copy_editor','type_setter','proof_reader','staff','editor_in_chief','production_manager','author','tsp');
							
							if (($this->current_client->modules->mdl_production == 'y') && (in_array($al->role_assigned_role,$search_criteria_production_roles))) {
									$production_roles[] = $al->role_id;
							}
							if ($al->role_assigned_role == 'associate_editor') {
									$associate_roles[] = $al->role_id;
							}
							if ($al->role_assigned_role == 'editor_in_chief') {
									$editor_roles[] = $al->role_id;
							}

						if(in_array($al->role_assigned_role, $privileged_core_roles))
						{
							$privileged_user_roles[] = $al->role_id;
						}

					}
				}

				$user_associate_editr_roles = array_merge($associate_roles, $editor_roles);
           		/* Condition for Previleged user As Reviewer */
			
					$allocate_condition = ' (SELECT count(usa.usra_usr_id) FROM '.$user_article_table.' usa WHERE usa.usra_art_id = art_id AND usa.usra_role_id IN ('. implode(',', $privileged_user_roles) .') AND usa.usra_usr_id = '.$this->current_user['user_id'].') ';
					$having_role_in_article_type = ' (SELECT COUNT(usj.usrj_id) FROM '.$user_journal_table.' usj WHERE  usj.usrj_jnl_id = ' . $jnl_id. ' AND usj.usrj_artp_id IS NOT NULL AND usj.usrj_artp_id = art_artp_id AND usj.usrj_role_id IN ('.implode(',', $privileged_user_roles).') AND usj.usrj_usr_id = ' .$this->current_user['user_id'] . ' AND usj.usrj_role_retired = \'n\' ) ';

					$non_reviewer_condition = ' (SELECT COUNT(arvr.artvr_id) FROM '.$article_version_table.' arvr WHERE FIND_IN_SET(art_id,CONCAT_WS(",",artvr_previous_art_ids,artvr_article_id)) > 0 AND arvr.artvr_user_id = '.$this->current_user['user_id'].') ';

					$privilege_usr_as_reviewer = ' AND CASE  ';
					$privilege_usr_as_reviewer .= ' WHEN '.$allocate_condition.' > 0 THEN TRUE ';
					if(count($privileged_user_roles) > 0)
					{
						$privilege_usr_as_reviewer .= ' WHEN ('.$having_role_in_article_type.' > 0  AND '.$non_reviewer_condition.' = 0) THEN TRUE ';
					}
					else
					{
						$privilege_usr_as_reviewer .= ' ELSE FALSE ';
					}

					$privilege_usr_as_reviewer .= ' END ';

					if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
					{
						$privilege_usr_as_reviewer = ' AND CASE WHEN ('.$having_role_in_article_type.' > 0  AND '.$non_reviewer_condition.' = 0) THEN TRUE END ';
					}

				
								
				/** *  #2030 - JPR-226 Editors able to see their papers ** */
				
				if ($this->current_client->functionality->cfty_manage_search_results_for_editors == 'y') {
					                               
                                     
					if (((!empty($associate_roles) || !empty($editor_roles) || !empty($production_roles) ) ) && !empty($permitted_roles)) {
						$subcondition = '';
						$or = '';			
						//1981 Limit search results for purticular roles
						if (!empty($production_roles) && $this->current_client->modules->mdl_production == 'y' && array_intersect(array('production_manager','tsp'), $user_roles['assigned_roles']))
						{
							$having_role_in_article_type = ' (SELECT COUNT(usj.usrj_id) FROM '.$user_journal_table.' usj WHERE  usj.usrj_jnl_id = ' . $jnl_id. ' AND usj.usrj_artp_id IS NOT NULL AND usj.usrj_artp_id = art_artp_id AND usj.usrj_role_id IN ('.implode(',', $production_roles).') AND usj.usrj_usr_id = ' . $this->current_user['user_id'] . ' AND usj.usrj_role_retired = \'n\' ) ';
							
							$subcondition = ' ( IF(('.$having_role_in_article_type.' > 0 AND FIND_IN_SET(jwf_role_id,\''. implode(',', $production_roles).'\') > 0),TRUE,FALSE) AND jwf_stage_type  IN (\'qulity_check\',\'editorial_amendment\',\'pro_revision\',\'aop_publish\',\'editorial_process\',\'preprocessing\',\'graphic_processing\',\'copy_editing\',\'type_setting\',\'proof_reading\',\'postprocessing\',\'publish\') ';
							if ($privilege_usr_as_reviewer != '')
								$subcondition.= $privilege_usr_as_reviewer;
							$subcondition.= ') ';
							$or = ' OR ';
						}
						
						if (!empty($associate_roles)) {
							$subcondition .=  $or . '(IF (( SELECT count(usrj_id) FROM ' . $user_journal_table . ' usj  WHERE usj.usrj_artp_id = art_artp_id AND usj.usrj_role_id IN (' . join(',', $permitted_roles) . ')  AND usj.usrj_usr_id = ' . $this->current_user['user_id'] . '  AND usj.usrj_role_retired = "n") > 0,TRUE,IF( ( SELECT count(usa.usra_usr_id) FROM ' . $user_article_table . ' usa WHERE usa.usra_art_id = art_id AND usa.usra_role_id IN( ' . join(',', $associate_roles) . ') and  usra_usr_id =' . $this->current_user['user_id'] . ') > 0,aflw_usr_id = ' . $this->current_user['user_id'] . ' OR (jwf_assignment !="self_service" AND aflw_parent_flow_id IS NULL AND (FIND_array_intersect("' . join(',', $associate_roles) . '",REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) OR FIND_array_intersect("' . join(',', $associate_roles) . '",REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")))),FALSE))';
						
							if ($privilege_usr_as_reviewer != '')
								$subcondition.= $privilege_usr_as_reviewer;
							$subcondition.= ')';
							$or = ' OR ';
						}

						if (!empty($editor_roles)) {
							$subcondition .=  $or . '(IF (( SELECT count(usrj_id) FROM ' . $user_journal_table . ' usj  WHERE usj.usrj_artp_id =art_artp_id AND usj.usrj_role_id IN (' . join(',', $permitted_roles) . ')  AND usj.usrj_usr_id = ' . $this->current_user['user_id'] . '  AND usj.usrj_role_retired = "n") > 0,TRUE,IF( ( SELECT count(usa.usra_usr_id) FROM ' . $user_article_table . ' usa WHERE usa.usra_art_id = art_id AND usa.usra_role_id IN( ' . join(',', $editor_roles) . ') and  usra_usr_id =' . $this->current_user['user_id'] . ') > 0,aflw_usr_id = ' . $this->current_user['user_id'] . ' OR (jwf_assignment !="self_service" AND aflw_parent_flow_id IS NULL AND (FIND_array_intersect("' . join(',', $editor_roles) . '",REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) OR FIND_array_intersect("' . join(',', $editor_roles) . '",REPLACE(REPLACE(REPLACE(rvw_journal_workflows.jwf_who_can_invite,\'"\',""),"]",""),"[","")))),FALSE))';
					
							if ($privilege_usr_as_reviewer != '')
								$subcondition.= $privilege_usr_as_reviewer;
							$subcondition.= ')';
						}
						if ($subcondition != '') {
							$subcondition .= ' OR aflw_usr_id = ' . $this->current_user['user_id'];
							$condition[] = '(' . $subcondition . ')';
						}
					}
				}
                /* Condition Previleged User as Reviwer */
				$jnl_privilage = $this->has_journal_privilege($jnl_code, $this->current_user['user_id']);
				if ($jnl_privilage == TRUE) {

					$condition[] = $this->reviewer_privilaged_listing();

				}
				
				//Task #424 Production Management
				$pri_core_roles = '\'staff\' , \'journal_admin\',\'editor_in_chief\',\'associate_editor\'';
				if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
				{
					
					$pri_core_roles .= ',\'production_manager\',\'tsp\'';
				}
		
				
				
				//Added to resolve the bug in searching articles(showing incorrect label for submitted author even if article is not submitted and viewarticle link redirect to dashboard(article stub))
				if($this->current_client->modules->mdl_review_for_doc == 'n')
				{
					$condition[] = '(CASE WHEN `art_status` = "n" AND `art_stub` = "y" AND `art_submitted_by` != ' . $this->current_user['user_id'] . ' THEN FALSE ELSE TRUE END)';
				}
				if($this->current_client->modules->mdl_review_for_doc == 'n' || ($this->current_client->modules->mdl_review_for_doc == 'y' && !in_array($core_role,array('author','reviewer','staff','journal_admin'))))
				{
					$condition[] = 'IF(FIND_IN_SET(' . $this->current_user['user_id'] . ',' . $select_data['authors'] . ') > 0,role_assigned_role = "author",IF((SELECT 
						COUNT("inn_aflw.aflw_id")
					FROM
						'.$article_flow_table. ' AS inn_aflw,
						'.$generic_flow_table.' AS inn_gflw,
						'.$roles_table.' AS inn_rl
					WHERE
						inn_aflw.aflw_jwf_id = inn_gflw.jwf_id
						AND inn_gflw.jwf_role_id = inn_rl.role_id
						AND inn_rl.role_assigned_role IN ('.$pri_core_roles.')
						AND inn_aflw.aflw_usr_id = ' . $this->current_user['user_id'] . '
						AND inn_aflw.aflw_art_id = art_id) > 0,
					TRUE,
					IF((SELECT 
							COUNT("tb_art.art_id")
						FROM
							'.$article_table.' AS tb_art,
							'.$userjournal_table.' AS tb_uj,
							'.$roles_table.'  AS tb_rl
						WHERE
						tb_art.art_artp_id=tb_uj.usrj_artp_id 
						AND tb_uj.usrj_role_id = tb_rl.role_id
						AND tb_uj.usrj_usr_id = ' . $this->current_user['user_id'] . '	
							AND tb_rl.role_assigned_role IN ('.$pri_core_roles.')	 AND  tb_uj.usrj_role_retired = \'n\') > 0,TRUE,
					aflw_usr_id=' . $this->current_user['user_id'] . ')))';
				}

				/* Feature #2063 - JPR-214 Retiring an AE/Editor -- View article section */
				$retire_condition = '';
				if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
					$retire_condition = ' AND tb_uj.usrj_role_retired = "n"';
				}

				$normal_contition = 'IF((SELECT 
                        COUNT("usrj_id")
                    FROM
						
					'.$userjournal_table.' AS tb_uj,
					'.$roles_table.' AS tb_rl
                    WHERE
					tb_uj.usrj_artp_id=art_artp_id 
					
                    AND tb_uj.usrj_role_id = tb_rl.role_id
					AND tb_uj.usrj_jnl_id = ' . $jnl_id . ' 
					AND tb_uj.usrj_usr_id = ' . $this->current_user['user_id'] . '	
						 AND tb_rl.role_assigned_role IN (\'' . implode('\',\'', $privileged_core_roles) . '\')	' . $retire_condition . '
							
                        
						) > 0,
                TRUE,
                aflw_usr_id=' . $this->current_user['user_id'] . ')';
				if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
					$normal_contition = 'IF((select COUNT(usra_id) FROM ' . $user_article_table . ' as tb_asmt WHERE  tb_asmt.usra_art_id = art_id AND  usra_usr_id =' . $this->current_user['user_id'] . ') > 0, TRUE,' . $normal_contition . ')';
				}

				if($this->current_client->modules->mdl_review_for_doc == 'n' || ($this->current_client->modules->mdl_review_for_doc == 'y' && !in_array($core_role,array('author','reviewer','staff','journal_admin'))))
				{
		
					$condition[] = 'IF(FIND_IN_SET(' . $this->current_user['user_id'] . ',' .$select_data['authors'] . ') > 0,role_assigned_role = "author",IF((SELECT 
						COUNT("aflw_id")
					FROM
						'.$article_flow_table.' AS inn_aflw,
						'.$generic_flow_table.' AS inn_gflw,
						'.$roles_table.' AS inn_rl
					WHERE
						inn_aflw.aflw_jwf_id = inn_gflw.jwf_id
						AND inn_gflw.jwf_role_id = inn_rl.role_id
						AND inn_rl.role_assigned_role IN (\'' . implode('\',\'', $privileged_core_roles) . '\')
						AND inn_aflw.aflw_usr_id = ' . $this->current_user['user_id'] . '
						AND inn_aflw.aflw_art_id = art_id) > 0,
					TRUE,
					' . $normal_contition . '))';
				}

				$select_more = '';
				$select_more .= $select_data['authors'] . 'as authors';
				$select_more .= ' ,IF(aflw_status IN("w","p"),(SELECT COUNT(aflw_id) FROM '.$article_flow_table.' WHERE aflw_id = aflw_parent_flow_id AND aflw_status IN("u","i","a","c")),NULL) as shot_listed,IF(aflw_status IN("w","p"),(SELECT COUNT(aflw_id) FROM '.$article_flow_table.' WHERE aflw_id = aflw_parent_flow_id AND aflw_status IN("i","a","c")),NULL) as invited_list';
				if($this->current_client->modules->mdl_review_for_doc == 'y')
				{
					$select_more .=','. $select_data['co_author_id'] . 'as co_author_id';
				}
				//	$select_more .= $select_data['pending_article_status'];

				$where = "";


				if ($all_art_ids == null && count($criteria) > 0) {
					$i = 0;
					foreach ($criteria as $key => $val) {
						if ($i == 0)
							$where .= ' WHERE ' . $key . " LIKE '%$val%'";
						else
							$where .= ' AND ' . $key . " LIKE '%$val%'";

						$i++;
					}
				}
				if ($all_art_ids != null) {
					$subquery = $all_art_ids;
				} else
					$subquery = "SELECT DISTINCT art_id FROM  $article_table $where ";

				$condition[] = 'art_id IN(' . $subquery . ') ';
				$condition[] = ' aflw_status != "h"';
				$review_for_document = FALSE;
				if($this->current_client->modules->mdl_review_for_doc == 'y')
				{
					$review_for_document = TRUE;
				}
				
             $order_by = str_replace('art_title', 'trim(strip_tags(art_title))', $order_by); 
		
	
             if ($limit != null) {
					$where_condition="jnl_id={$jnl_id} AND aflw_skip_review='n' ";
			
					$blinded_articles = $this->get_blinded_articles($this->current_user['user_id']);
					if(!empty($blinded_articles))
					{
						$where_condition .= ' AND art_id NOT IN ('.$blinded_articles.') ';
					}

					
					$parameter_head_array['select']= 'artp_jpm_id,artp_palette_color_code,artp_special_issue,artp_article_type,artp_abbr_article_type,art_id,art_code,art_status,art_delete_status,art_title,art_artp_id,art_submitted_by,DATE_FORMAT(art_submission_date, "' .  $date_format .' %H:%i") as art_submission_date_format,art_stub,aflw_id,aflw_due_date as due_date,DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days,aflw_art_id as reviewed_article,art_publication_issue,iss_soft_end_date,iss_hard_end_date,atotp_review_method,atotp_custom_blind_params,'.$select_data['authors'] . 'as authors';

					$parameter_head_array['condition']=$where_condition;
					$parameter_head_array['order_by']=$order_by;
					$parameter_head_array['advanced_serach ']=TRUE;
					$parameter_head_array['auth_usr_id']=$this->current_user['user_id'];
					$parameter_head_array['review_for_document']=$review_for_document;
					$parameter_head_array['additional_criteria']=$condition;
					$parameter_head_array['completed_tasks']=TRUE;
					$parameter_head_array['export']=TRUE;
					$parameter_head_array['urlsegment']='search-articles';
					$parameter_head_array['issue']=TRUE;
					$parameter_head_array['group_by']='art_id';
					$parameter_head_array['limit']=10;
					
				//	$parameter_head_array['user_id']=$this->current_user['user_id'];
					
					$article_list['head'] = $Article_flow::get_articles_and_status($parameter_head_array);
				
				
					$art_id_arr = array();
					if(!empty($article_list['head']))
					{
					foreach($article_list['head'] as $item)
					{
						$art_id_arr[] = $item->art_id;
					}
					}
				
			
					
										
				//	$generic_tab_result_data = implode(',', array_column($article_list['head'], 'art_id'));
                    if(!empty($art_id_arr))
				     $condition[] = 'art_id IN('. implode(',',$art_id_arr ).')';
										
				}

				//get blinded articles
				/*$blinded_articles = $this->get_blinded_articles($this->current_user['user_id']);
				
				if(!empty($blinded_articles))
				{
					$condition[] = 'art_id NOT IN(' . $blinded_articles . ') ';
				}*/
				$generic_tab_result_data=array();
				if(!empty($art_id_arr))
				{
					$select_shortlist_permission = $select_invite_permission = '';
						
					$jwf_parent_user_roles_new = 'REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")';
					$jwf_who_can_invite_new = 'REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")';
					$user_retire_flag = 'FALSE';
					$art_user_allocation_cnd = ' IF(GROUP_CONCAT(IF(usra_role_id = '.$rol_id.',usra_usr_id,NULL)) IS NOT NULL,FIND_array_intersect('.$this->current_user['user_id'].',GROUP_CONCAT(IF(usra_role_id = '.$rol_id.',usra_usr_id,NULL)) IS NOT NULL) = 1, '.$user_retire_flag.' AND FIND_array_intersect('.$rol_id.',user_artp_roles) = 1) ';
							
							$select_shortlist_permission = ',IF(aflw_status IN (\'w\',\'p\') AND FIND_array_intersect('.$rol_id.','.$jwf_parent_user_roles_new.') = 1 ,TRUE,FALSE) AS shortlist_permission';

							$select_invite_permission = ',IF(aflw_status = \'w\' AND FIND_array_intersect('.$rol_id.','.$jwf_who_can_invite_new.') = 1 ,TRUE,FALSE) AS invite_permission';


					$selectquery='aflw_invite_due_date,art_publication_issue,' .$select_data['formatted_select']  . ',atotp_review_method, atotp_custom_blind_params,jp_extend_task,jnl_id,artp_soft_enddate,artp_hard_enddate,art_transfer_article,art_new_submission,art_submitted_by as orginal_submitted_id,DATE_FORMAT(art_update_last_date, "' . $date_format . '") as art_update_last_date_format,art_prev_article_id,art_stub,DATE_FORMAT(art_prduction_submission_accepted_date, "' . $date_format . '") as art_prduction_submission_accepted_date_format,art_publication_issue,aflw_operation,artp_jpm_id,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as per_shotlist_roles,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as per_invite_roles'.$select_shortlist_permission.$select_invite_permission ;
					
					if($select_more!='')
					$selectquery.=',' . $select_more;
					$parameter_array['select']=$selectquery;
					//$parameter_array['condition']="jnl_id={$jnl_id} AND aflw_skip_review='n'";
					$parameter_array['date_format']=$date_format;
					$parameter_array['order_by']=$order_by;
					$parameter_array['advanced_serach ']=TRUE;
					$parameter_array['auth_usr_id']=$this->current_user['user_id'];
					$parameter_array['review_for_document']=$review_for_document;
					$parameter_array['additional_criteria']=$condition;
					$parameter_array['completed_tasks']=TRUE;
					$parameter_array['export']=FALSE;
					$parameter_array['urlsegment']='search-articles';
					$parameter_array['issue']=TRUE;
					DB::enableQueryLog();

					//$query = DB::getQueryLog();


						$generic_tab_result_data = $Article_flow::get_articles_and_status($parameter_array);	
						//$query = end($query);
					
					
				}
		
 

				if(isset($this->current_client->functionality->cfty_next_task_button) && $this->current_client->functionality->cfty_next_task_button == 'y' ){
					$strt_cnt = $start;
					$art_cnt_array = array(); 
					$st_art_old='';
					$client_code = $this->current_client->clnt_client_code;
					$this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
			       
				
					if(!empty($generic_tab_result_data_art_ids))
					{
						foreach( $generic_tab_result_data as $artss)
						{
							if(empty($st_art_old))
							{
								$st_art_old = $artss->art_id;
							}
						    $core_stage = isset($artss->jwf_stage_type) ? $artss->jwf_stage_type : '';
						    $artss->view_article = 'view-article';
						//    if(!empty($core_stage) && isset($this->review_flow[$core_stage]['stage_for']) && $this->review_flow[$core_stage]['stage_for'] == 'manageproduction')
				        //      {
					    //   $artss->view_article = 'view-article-production';
				        //      }
							
							$art_cnt_array[$artss->art_id] = array ($strt_cnt,$artss->art_id,$artss->aflw_id, $artss->view_article);
							
							if($st_art_old != $artss->art_id)
							{
								$strt_cnt++;
							}
							$st_art_old = $artss->art_id;
							
						}
					}
					//die;
					//$this->write_advanced_list($post_data,$art_cnt_array);
				}	
								
		
	
					$arraydata['author_listing']=FALSE;
					$arraydata['action_button']='';
					$arraydata['my_list']=TRUE;
					$arraydata['disable_duedate']=FALSE;
					$arraydata['disable_duedate_head']=TRUE;
					$arraydata['jnldata']=$post; 
					$arraydata['article_tasks']=$generic_tab_result_data;
					
				//	$generic_tab_result_article = $this->format_article_stages_for_display($arraydata);
				DB::enableQueryLog();
				$generic_tab_result_article['head']=$article_list['head'];
				$generic_tab_result_article['format_head_stage']=$this->format_article_data($article_list['head'],$post);
    
				$stages=array();
				if(!empty($generic_tab_result_data))
				{
					$arraydata['author_listing']=FALSE;
					$arraydata['action_button']='';
					$arraydata['my_list']=TRUE;
					$arraydata['disable_duedate']=FALSE;
					$arraydata['disable_duedate_head']=TRUE;
					$arraydata['jnldata']=$post; 
					$arraydata['article_tasks']=$generic_tab_result_data;
				$stages = $this->format_article_stage_data($arraydata);
				}

				$generic_tab_result_article['stages']=$stages;
				$generic_tab_result_article['type']='article';
				return $generic_tab_result_article;

		} 
		else {
			
				//DB::enableQueryLog();
				$generic_user_data= $User_to_journals::search_user_in_journal($jnl_id, $criteria, $this->current_user['user_id']);
				//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
				//echo '<pre>';print_r($generic_user_data);exit;
				$generic_tab_result['userlist'] =$this->formate_user_list($generic_user_data,$jnl_id);
			
				$generic_tab_result['type']='user';
	          return   $generic_tab_result;

			}
			
		}
		/* Customisation 2537
		 * flag icons are showing incorrect in the search article list
		 */
		/*if (!empty($generic_tab_result)) {
			$user_roles = $this->validate_user_journal($jnl_code, $this->current_user['user_id']);
			$current_userroles	=	$user_roles['role_id'];
			
         $logged_user_role = $core_role;                          
			foreach($generic_tab_result as $key => $val) {
				$val->newflags	=	"";
				if(isset($val->artp_jnl_id) && isset($val->art_id)){
                                        //#604 Replace fetch_role_flags_of_user() with get_article_flags() for fetching article flags.
                  $newflags        =      $this->get_article_flags($val->art_id,$current_userroles);
					$val->newflags	=	$newflags;
					$corresponding_author = $Authors::get_single_record('auth_usr_id',"auth_art_id={$val->art_id} AND auth_corr_author='y'");
					if(!empty($corresponding_author))
					{
					$val->corresponding_author = $corresponding_author->auth_usr_id;
					$val->corresponding_author_fullname = $this->get_user_display_name($corresponding_author->auth_usr_id,$jnl_id, TRUE, $val->art_id);
					}
					$reviewer_privilage = $this->reviewer_privilage_check($val->art_id);
					if ($val->atotp_review_method == 'd' && $reviewer_privilage == FALSE)
					{
							$val->art_submitted_by = '';
							$val->corresponding_author = '';
							$val->corresponding_author_fullname = ''; 
					}
                                        $val->due_date_class = '';
                                        if(isset($val->rvd_remaining_days))
                                            $val->due_date_class = $this->get_due_date_class($val->rvd_remaining_days);
				
				}
			}
		}
	*/
        

	}
    public function format_article_data($article_data,$jnl_data)
	{
		$article_base_array=array();
		$jnl_id =$jnl_data['jnl_id'];
		$this->journal_code=$jnl_data['jnl_code'];
	    $core_role=$jnl_data['core_role'];
	    $role_id=$jnl_data['role_id'];
		$this->current_user = $this->get_current_user_details();
		$is_reviewer=TRUE;
		$edit_article=FALSE;
		$can_delete = 'n';
		$Article_type_advance_options=new \App\Models\Article_type_advance_options();
		$Authors=new \App\Models\Authors();

		foreach ($article_data as $article)
		{ 
	         
			$show_author = $this->show_author_name($article);
			$submitted='';
			if($show_author == true)
            {
				$submitted=$this->get_article_submitted_user($article,$jnl_id);

                $article->corresp_suptag = false;
                $article->corresp_author_name_tag = false;
				$corresponding_author = $Authors::get_single_record('auth_usr_id',"auth_art_id={$article->art_id} AND auth_corr_author='y'");
		
                if(!empty($article->authors))
                {
                    $author_list = explode(',',$article->authors);
                    
                
                    
                    if(in_array($article->art_submitted_by,$author_list)&&(!empty($corresponding_author))&&($corresponding_author->auth_usr_id==$article->art_submitted_by))
                    {
                        $article->corresp_suptag = true;//here check submitting author
                    }
                    else
                    {
						if(!empty($corresponding_author))
						{
							$article->corresp_author_name_tag = true;//here corresp. author 
							$array_data['user_id'] = $corresponding_author->auth_usr_id;
							$array_data['journal_id'] = $jnl_id;
							$array_data['flag'] = TRUE;
							$array_data['article_id'] = $article->art_id;
							$array_data['jnl_code'] = $this->journal_code;
							$article->corresp_user_full_name = $this->get_user_display_name($array_data);
						
						}
                    }
                }
            }
			if($this->current_client->modules->mdl_review_for_doc == 'y')
			{
				$article->art_submitted_by = $article->co_author_id;
			}
			
			
			$article->user_full_name = $submitted;

  
			$is_special=$this->check_special_issue_in_article($article);

			$is_invited = FALSE;
			if (isset($article->art_stub) && $article->art_stub != 'n')
			{
			$is_invited = TRUE;
			}
            $article_code = $this->get_article_display_code($article->art_id, $jnl_id, $is_special,$is_invited,role_id:$role_id);  
            $article->art_code=$article_code;
			if (isset($article->art_abstract))
			{
				$art_abstract = $article->art_abstract;
				if (strlen($art_abstract) > 100)
				{
					$article->art_abstract = mb_substr(strip_tags($art_abstract), 0, 100, "utf-8") . '...';
				}

			}
			$client_code = $this->current_client->clnt_client_code;
			$this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
			$skip_review_author=FALSE;
			if($this->current_client->modules->mdl_review_for_doc == 'y')
			{
				$array_skip_review_author_roles=array('author','reviewer','staff','journal_admin');
				if (in_array($core_role, $array_skip_review_author_roles))
               {
				$skip_review_author = TRUE;
                }
			}
			if (isset($article->authors) && in_array($this->current_user['user_id'], explode(',', $article->authors)) == TRUE && $skip_review_author == FALSE)
			{
	
				
				$article->isauthor = TRUE;
				$article->can_delete = 'n';
			}
			else
			{
				/* start -- Here splits the task with w status into two separate status row */
				$this_user = $this->validate_user_journal($this->journal_code, $this->current_user['user_id'], $article->art_artp_id);
             
				/*				 * * Feature #1402 - Delete article from the sytem ** */
				$can_delete = 'n';
				if ($this->current_client->functionality->cfty_enable_article_delete == 'y')
				{
				
					if (isset($this_user['role_id']))
					{
						$jset_delet_permission =$Journal_settings::get_single_record('jset_manage_article',"jset_jnl_id={ $jnl_id}");
						$delete_permission_roles = ($jset_delet_permission->jset_manage_article != NULL) ? json_decode($jset_delet_permission->jset_manage_article) : array();
						$permitted_role = array_intersect($delete_permission_roles, $this_user['role_id']);
						if (count($permitted_role) > 0)
						{

							$can_delete = 'y';
						}
					}
				}
				
				if($is_reviewer == TRUE )
				{
					$can_delete = 'n';
				}
			}
			$article->can_delete = $can_delete;
			   $privleged_reviewer = $this->is_reviewer_privileged_user($article->art_id,NULL,FALSE,$article->art_artp_id);
				if($privleged_reviewer == TRUE)
				$is_reviewer = FALSE;
				$article->user_reviewer=$is_reviewer;
				
				$edit_article_status_array= $this->check_article_editable_action($article,$is_reviewer,$this->journal_code);
				$article->edit_article=$edit_article_status_array['edit_article_status'];
				$article->flags =$this->get_article_flag($jnl_id,$role_id,$article->art_id);
				$article->articleFlags = $this->get_article_flags_formatted($article->art_id,$this->journal_code);
			$article_base_array[$article->art_id]=$article;
		}
		return $article_base_array;
	}
    public function format_article_stage_data($array_data)
	{
		// var_dump($array_data['article_tasks']);
		$article_tasks = isset($array_data['article_tasks']) ? $array_data['article_tasks'] : array();
		$author_listing = isset($array_data['author_listing']) ? $array_data['author_listing'] : FALSE;
		$action_button = isset($array_data['action_button']) ? $array_data['action_button'] : '';
		$my_list = isset($array_data['my_list']) ? $array_data['my_list'] : '';
		$disable_duedate = isset($array_data['disable_duedate']) ? $array_data['disable_duedate'] : FALSE;
		$disable_duedate_head = isset($array_data['disable_duedate_head']) ? $array_data['disable_duedate_head'] : FALSE;
		$jnl_data = isset($array_data['jnldata']) ? $array_data['jnldata'] : array();
		
		$Article_flag=new \App\Models\Article_flag();
		$Authors=new \App\Models\Authors();
		$Flag=new \App\Models\Flags();
		$Article_flow=new \App\Models\Article_flow();
		$Journals=new \App\Models\Journals();
		$Journal_settings=new \App\Models\Journal_settings();
		$Article_type_advance_options=new \App\Models\Article_type_advance_options();
		$article_flow_table=(new \App\Models\Article_flow())->getTable();
		$generic_flow_table=(new \App\Models\Generic_flows())->getTable();
		$User_articles=new \App\Models\User_articles();
		$ret_array = array();
		$return = array();
		$status_row = array();
		$duplicates_array = array();
		$art_allocation = array();
		$is_art_reviewer_arr = array();
		$user_disply_name = array();
		$parent_id = NULL;
		$return_html = '';
		$counter = 0;
		$allocation_user = array();
		$jnl_details = $Journal_settings::get_single_record('*',"jset_jnl_id={$jnl_data['jnl_id']}");

		$this->journal_code=$jnl_data['jnl_code'];
		$core_role=$jnl_data['core_role'];
		$role_id=$jnl_data['role_id'];
	
		$art_stages = array();
		$user_role_arr = $this->set_all_roles_key_value();
		foreach ($article_tasks as $article)
		{
			if(($article->jwf_assignment == "invitation" &&  $article->aflw_status == 'w')||  ($article->jwf_assignment == "manual" &&  ($article->aflw_status == 'p' || ($article->aflw_status == 'c' && $article->aflw_usr_id==''))))
			{
				if($article->aflw_skip_review =='y' )
				{
					continue;
				}
				elseif($article->aflw_stage_min_users<=($article->child_invitation_count+$article->child_confirmed_count))
				{
					continue;
				}
			}
			//check article having allocated users 
			if(!isset($art_allocation[$article->art_id]))
			{
				$allocated_user = $this->get_allocated_users_list(array($article->art_id));
				if(isset($allocated_user[$article->art_id]))
					$art_allocation[$article->art_id] = $allocated_user[$article->art_id];
				else
					$art_allocation[$article->art_id] = array();
			}
		
			//Task #140: JPR-136 BUG: Overdue Reviewer Selection
			$review_select_row_copy = FALSE;
			$review_invite_row_copy = FALSE;
			$edit_flag = FALSE;
//			$privileged_user = FALSE;
            $article->art_submitted_by_id = $article->art_submitted_by;
			$privileged_user = $this->has_journal_privilege($article->jnl_journal_code, $this->current_user['user_id'], $article->artp_id);
			
			$special_issue = FALSE;
			$is_invited_art = FALSE;
			$permission_roles = array();
			$is_reviewer = TRUE;
			
			//$user_reviewer = FALSE;  //checking user has reviewer role regardless of client functionality and assiging this value when client functionaly is enabled
			
			//in this array store current user is reviewer or not in the article
			if(isset($is_art_reviewer_arr[$article->art_id]))
			{
				$is_reviewer = $is_art_reviewer_arr[$article->art_id];
			}
			else
			{
				//if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') 
				//{
					$privleged_reviewer = $this->is_reviewer_privileged_user($article->art_id,NULL,FALSE,$article->artp_id);
					if($privleged_reviewer == TRUE)
						$is_reviewer = FALSE;
			/*	}
				else
				{
					$condition =' aflw_art_id='.$article->art_id.' and aflw_usr_id='.$this->current_user['user_id'].' and aflw_status IN (\'u\',\'i\',\'a\') and jwf_stage_type=\'review\'';
			
					$sql_str = ' SELECT COUNT(DISTINCT aflw_id) AS cnt FROM '.$article_flow_table.','.$generic_flow_table.' WHERE '.$condition;
					$reviewer_record = $Article_flow::get_records_by_raw_query($sql_str,TRUE);
					if($reviewer_record->cnt == 0)
						$is_reviewer = FALSE;
				}*/
				
				$is_art_reviewer_arr[$article->art_id] = $is_reviewer;
			}
			
		
			if (isset($article->artp_special_issue) && $article->artp_special_issue == 'y')
				$special_issue = TRUE;
			if (isset($article->art_publication_issue) && !empty($article->art_publication_issue))
			{
				$special_issue = TRUE;
			}	
			if (isset($article->art_stub) && $article->art_stub != 'n')
				$is_invited_art = TRUE;
			if (isset($article->artp_jnl_id))
				$jnl_id = $article->artp_jnl_id;
			else
				$jnl_id =$jnl_data['jnl_id'];
			
				
			$date_format = $jnl_details->jset_date_format;
			$dateformat = $date_format." H:i";
			$article->dateformat=$dateformat;

			$convert_date='';
			$date_sub=date_create($article->art_submission_date);
			if($date_sub!='')
			$convert_date=date_format($date_sub,$dateformat);
			$article->convert_date =$convert_date;
			//artp_soft_enddate,is_author
			//$article->due_date_show=FALSE;
			$is_author = FALSE;	
			$chk_author=$Authors::get_single_record('auth_art_id',"auth_art_id={$article->art_id} AND auth_usr_id={$this->current_user['user_id']}");
			if(!empty($chk_author))
			{
				$is_author= TRUE;
			}
			$article->is_author=$is_author;
			$hold_status = $hold_baldge_reason ='';
			$article->user_reviewer=$is_reviewer;
			$article->hold_status=$hold_status;
			$article->hold_baldge_reason = $hold_baldge_reason;
			$due_date_array=$this->format_due_date($article,$jnl_id);
			$article->due_date=$due_date_array['due_date'];
			$article->expired=$due_date_array['expired_status'];
			
			$due_date_change = FALSE;
			$client_code = $this->current_client->clnt_client_code;
			$this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
	
			$core_stage = isset($article->jwf_stage_type) ? $article->jwf_stage_type : '';
			$skip_review_author = FALSE;
			if($this->current_client->modules->mdl_review_for_doc == 'y')
			{
				$array_skip_review_author_roles=array('author','reviewer','staff','journal_admin');
				if (in_array($core_role, $array_skip_review_author_roles))
               {
				$skip_review_author = TRUE;
                }
			}
			$article->authorurl=FALSE;
			if($article->art_status=='n')
			{
			$article->authorurl=TRUE;		
			$article->status_link= $this->author_status_link($article,$is_reviewer,$this->journal_code);
			}
			else
			{
            $article->status_link= $this->set_article_url($article,$skip_review_author,$core_role);
			}


			$shorlist_permission = FALSE;
			$my_task=FALSE;
			if($my_task == FALSE)
			{
				$shorlist_permission = TRUE;
				$invite_permission = TRUE;
			}	
			else //if(isset($art_list->$temp_art_id))
			{
				//$shorlist_permission = $art_list->$temp_art_id->shortlist_permission;
				//$invite_permission = $art_list->$temp_art_id->invite_permission;
				if(isset($article->shortlist_permission))
					$shorlist_permission = $art_stage->shortlist_permission;
				if(isset($article->invite_permission))
					$invite_permission = $article->invite_permission;
			}
			$assigned_details=$this->get_assiged_user_details($article,$user_role_arr,$shorlist_permission,$invite_permission,$allocation_user,$jnl_data);
			$article->assigned_role = implode(',',  $assigned_details['assigned_role']);
			$article->assigned_text = $assigned_details['assigned_text'];
			$mng_flow_status_w=$assigned_details['manage_flow_status'];
			$article->art_current_status=$this->formated_article_status($article,$jnl_data['jnl_code']);
			$article->current_user_id = $this->current_user['user_id'];
			$article->formated_stagename=$article->formated_stagename.' '.$mng_flow_status_w;
			$edit_article_editable_array= $this->check_article_editable_action($article,$is_reviewer,$this->journal_code);

			if ($edit_article_editable_array['due_date_extend_status']==TRUE)
			{
						$due_date_change  = TRUE;
			}
			/*if (isset($article->aflw_usr_id) && $article->aflw_usr_id != NULL)
			{
				if(isset($user_disply_name[$article->aflw_usr_id]))
				{
					$article->assigned_user = $user_disply_name[$article->aflw_usr_id];
				}
				else
				{
					$array_data['user_id']=$article->aflw_usr_id;
					$array_data['journal_id']=$article->artp_jnl_id;
					$array_data['flag']=TRUE;
					$array_data['article_id']=$article->art_id;
					$article->assigned_user = $this->get_user_display_name($array_data);
				
			    }
				if (isset($article->jwf_role_id))
				{
					$article->user_role =  ' (' .$user_role_arr[$article->jwf_role_id]. ')';
				}
		    }
			else
			{
			if(isset($user_role_arr[$article->jwf_role_id]))
			$assigned_roles[] = $user_role_arr[$article->jwf_role_id];
			$assigned_rolelist = implode(', ', $assigned_roles);
			}
			$article->assigned_text = $assigned_text;
			$article->assigned_role = $assigned_rolelist;
			*/
			$article->due_date_show = TRUE;
			if($is_author == TRUE || $is_reviewer == TRUE )
			{
				if($role_id != $article->jwf_role_id)
					$article->due_date_show = FALSE;
			}
			$flow_status_arr = array('u','i','a','w','p');
			if(!in_array($article->aflw_status,$flow_status_arr) )
			{
				$article->due_date_show = FALSE;
			}


			$article->edit_due_date = FALSE;
			if ($due_date_change == TRUE && $article->rvd_aflw_due_date!=NULL &&$article->aflw_returned_date==NULL ) 
			{
				$article->edit_due_date = TRUE;
				//$article->due_date_show=TRUE;
			}
			
		
	               $default_art_pri = array();
                 $article->privileged_user_arttype = FALSE;
                       
		         if (isset($article->is_author) && $article->is_author ==FALSE) 
                {
                            
				if (isset($default_art_pri[$article->art_artp_id])) {
					$article->privileged_user_arttype = $default_art_pri[$article->art_artp_id];
				} else {
					$article->privileged_user_arttype = $this->has_journal_privilege($this->journal_code, $this->current_user['user_id'], $article->art_artp_id);
					$default_art_pri[$article->art_artp_id] = $article->privileged_user_arttype;
				 }
			   }
			  

			
			if (isset($article->jwf_status_name) && isset($article->jwf_status_name_formatted)&&(!isset($article->privileged_user_arttype) || $article->privileged_user_arttype == FALSE || (isset($article->is_author) && $article->is_author == TRUE)) || $core_role == 'reviewer' || ( $is_reviewer == TRUE && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' ))
			 {
         //Customization #2472 --Need to implement "temporary status name" in every article listing section for non-privileged user
              //  $article->jwf_stage_name_formatted = $this->has_temporary_status_name($article->jwf_status_name, $article->jwf_status_name_formatted, $article->aflw_status, $article->jwf_temporary_status_name, $article->jwf_temporary_status_name_formatted);
			}
		
			$article->change_due_date = '';

			/*if ($disable_duedate == FALSE)
			{
				if (isset($this->jnl_data))
				{
					$article->jset_date_format = $this->jnl_data->js_date_format;
				}

				if (isset($article->jp_extend_task) && $article->jp_extend_task != '')
				{
				

					$role_extending_task = json_decode($article->jp_extend_task);
					$user_role_in_artp = $User_articles::get_single_record('GROUP_CONCAT(DISTINCT usrj_role_id) as role_ids',"usrj_artp_id={$article->artp_id} AND usrj_usr_id={$this->current_user['user_id']}");

					if (!empty($user_role_in_artp->role_ids))
					{
						$user_roles_in_artp = explode(',', $user_role_in_artp->role_ids);
						$usr_extend_roles_in_artp = array_intersect($user_roles_in_artp, $role_extending_task);
						if (!empty($usr_extend_roles_in_artp))
						{
						
							$article->change_due_date = TRUE;
							$get_assigned_role_usrs = $User_articles::get_single_record('GROUP_CONCAT(DISTINCT usra_usr_id) as usr_ids', 'usra_art_id = ' . $article->art_id . ' AND usra_role_id IN( ' . implode(',', $role_extending_task) . ')');
							$alloc_usr_ids = (!empty($get_assigned_role_usrs->usr_ids)) ? explode(',', $get_assigned_role_usrs->usr_ids) : array();
							$usr_extend_alloc_roles = array_intersect($user_roles_in_artp, $alloc_usr_ids);
							if (!empty($alloc_usr_ids) && !in_array($user_id, $alloc_usr_ids))
							{
								if (count($usr_extend_roles_in_artp) == count($usr_extend_alloc_roles))
									$article->change_due_date = FALSE;
							}
							
							if ( $is_reviewer == TRUE)
							{
								$article->change_due_date = FALSE;
							}
						}
					}
				}

			}
			*/
	
			//Task #666 - Transfer without author confirmation
			$article->transfer_completed_without_au_confirmation_role = '';
			if($article->jwf_stage_type == 'transit' && $article->aflw_status == 'c')
			{
			
				$transfer_complte_details = $Article_transfer_suggestion::get_transfer_details($article->art_id, $article->aflw_id);
				if($transfer_complte_details->ats_without_au_confirmation_usr_role > 0)
				{
					$transfer_completed_usr_role =$Roles::get_single_record('role_name',"role_id={$transfer_complte_details->ats_without_au_confirmation_usr_role}");
					$article->transfer_completed_without_au_confirmation_role = $transfer_completed_usr_role->role_name;
				}
			}
			

				$article->non_privileged = !$privileged_user;
				$art_stages[$article->art_id][] = $article;
		
		}

        return $art_stages;
	}
public function formate_user_list($userdata,$jnl_id)
{
    
     if(!empty($userdata))
	 {
        foreach($userdata as $user)
		{
			        $displayarray=array();
                    $displayarray['user_id']=$user->usr_id;
                    $displayarray['salutation']=TRUE;
					$displayarray['journal_id']=$jnl_id;
			
			$user->fullname=$this->get_user_display_name($displayarray);
		}
	 }
	 return $userdata;
}
	

	//advance search function
	public function advanceSearch(Request $request)
	{
		$result = array();
		try
        {
			$validator = Validator::make($request->all(), [
				'jnl_id' => 'required',
				'jnl_code' => 'required',
				'role_id' => 'required',
				'core_role' => 'required',
			]);
	
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
				$post_data = $request->all();
				$jnl_id = $post_data['jnl_id'];
				$core_role = $post_data['core_role'];
				$roleid = $post_data['role_id'];
				if($this->hasAdvanceSearch($jnl_id,$core_role) == TRUE)
				{
					if(isset($post_data['search_arr']['search_type']) && $post_data['search_arr']['search_type'] == 'user')
					{
						$export_users = FALSE;
						if(isset($post_data['search_arr']['export']) && $post_data['search_arr']['export'] == TRUE)
						{
							$export_users = TRUE;
						}
						$condition_arr = $this->manage_search_filters($post_data['search_arr']);
						$User=new \App\Models\User();
						if(isset($post_data['search_arr']['sort']) && count($post_data['search_arr']['sort']) > 0)
						{
							$sort_data = $post_data['search_arr']['sort'];
							if (isset($this->current_client->functionality->cfty_show_minimised_sort)&&($this->current_client->functionality->cfty_show_minimised_sort == 'y'))
							{
								$order_by_condition =  $sort_data['sort_type'] . " " . $sort_data['order'];
							}
							else
							{
								if (is_array($sort_data['sort_type']) || is_object($sort_data['sort_type']))
								{
									$sort_type = implode(' '.$sort_data['order'].',', $sort_data['sort_type']);
									$sort_type .= ' '.$sort_data['order'];
									$order_by_condition =  $sort_type;
								}
							} 
						}
						else
						{
							$order_by_condition = '  usr_id asc';
						}
						$ordering_column = 'usr_id';
						$select = "
                        usr_id, 
                        usr_first_name AS user_name, 
                        usr_email, 
                        keyword_table.user_keywords AS user_keywords,
                        classification_table.user_classification_id AS user_classification_id,
						CONCAT(
						GROUP_CONCAT(
							DISTINCT
							CONCAT(
								'<div style=\"min-width: 350px;\">',
								article_role_concat.article_type_concat,
								' – ',
								article_role_concat.role_name_concat,
								'<hr/>',
								'</div>'
							) SEPARATOR '\n'
						)
						) AS usr_articletype_rolelist
						";
						$array_data['select'] = $select;
						$array_data['exclude_users'] = array();
						$array_data['search_filters'] = $condition_arr;
						$array_data['order_by_condition'] = $order_by_condition;
						$array_data['ordering_column'] = $ordering_column;
						$array_data['advance_search'] = TRUE;
						$array_data['export_flag'] = $export_users;
						$array_data['five_star'] = $this->current_client->functionality->cfty_fivestar_review_rating == 'y' ? TRUE : FALSE;
						$result_data = array();
						$array_data['jnl_id'] = $jnl_id;
						//DB::enableQueryLog();
						$result_data['head'] = $User::get_user_data_global($array_data);  
						//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
						//echo '<pre>';print_r($result_data['head']);exit;
						if(count($result_data['head']) > 0)
						{
							$array_data['advance_cnt'] = FALSE;
							$result_data['head'] = $User::get_user_data_global($array_data); 
							foreach($result_data['head'] as $value)
							{
								$disp_arr = array();
								$disp_arr['user_id'] = $value->usr_id;
								$disp_arr['journal_id'] = $jnl_id;
								$disp_arr['flag'] = TRUE;
								$disp_arr['salutation'] = (isset($this->current_client->functionality->cfty_avoid_salutation) && $this->current_client->functionality->cfty_avoid_salutation == 'y') ? FALSE : TRUE;
								$value->display_name = $this->get_user_display_name($disp_arr);
							}
						}
						if($export_users == TRUE)
						{
							$link_to_download = $this->create_csv_file_creation($post_data['jnl_code'],$result_data['head'],$post_data,'user');
							$result_data = [];
							$result_data['download_link'] = $link_to_download;
						}
						return  $this->success('Success',200,$result_data);
					}
					else
					{
						$result = $this->get_search_article_details($post_data);
					}
				}
				else
				{
					return $this->warning('Failed',422,'Unauthorised request',403);
				}
				
				return  $this->success('Success',200,$result);
			}
		}
		catch (\Exception $e)
		{
   
			return  $this->failure('Failed',500,$e);
		}
	}

	//make sure jnl_id, core_role,role_id exist in post data
	public function get_search_article_details($post_data)
	{
		$return = array();
		$submission_inprogrs_permited_role = FALSE;
		if(isset($this->current_client->functionality->cfty_submission_inprogress_view_article) &&  $this->current_client->functionality->cfty_submission_inprogress_view_article == 'y')   
		{
			$role_perm_stat = $this->check_view_article_on_submission($post_data);
			if($role_perm_stat == TRUE)
			{
				$submission_inprogrs_permited_role = TRUE;
			}
		}
      
		if(isset($post_data['jnl_id']) && isset($post_data['core_role']) && isset($post_data['role_id']))
		{
			$jnl_id = $post_data['jnl_id'];
			$core_role = $post_data['core_role'];
			$roleid = $post_data['role_id'];
			$this->current_user = $this->get_current_user_details();

			$user_retire_status = $this->get_user_role_retire($post_data['role_id'],$this->current_user['user_id'],$post_data['jnl_id']);
						
			$user_retire_flag = ' TRUE ';
			if($user_retire_status == TRUE)
				$user_retire_flag = ' FALSE ';

			//for build condition array
			$condition_arr = array();
			if(isset($post_data['post_from']) && $post_data['post_from'] == 'normal_search')
			{
				$condition_arr = $this->arrange_normal_search_filter($post_data); 
			}
			else
			{
				//from advanced search section
				$condition_arr = $this->manage_search_filters($post_data['search_arr']);
			}
						
			$tile_condition = array(); //conditional array manipulation
						
			$select = 'art_id';
			$group_by = 'art_id';
			if(isset($post_data['search_arr']['sort']) && count($post_data['search_arr']['sort']) > 0)
			{
				$sort_data = $post_data['search_arr']['sort'];
				if($sort_data['sort_type'] == 'art_title')
				{
					$sort_data['sort_type'] = ' strip_tags(art_title) ';
				}
				if (isset($this->current_client->functionality->cfty_show_minimised_sort)&&($this->current_client->functionality->cfty_show_minimised_sort == 'y'))
				{
					$order_by = $sort_data['sort_type'] . " " . $sort_data['order'];
				}
				else
				{
					if (is_array($sort_data['sort_type']) || is_object($sort_data['sort_type']))
					{
						$sort_type = implode(' '.$sort_data['order'].',', $sort_data['sort_type']);
						$sort_type .= ' '.$sort_data['order'];
						$order_by =  $sort_type;
					}
				} 
			}
			else
			{
				$order_by = 'art_id';
			}
			$cfty_allow_privileged_users_as_only_reviewer = FALSE;
			if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
			{
				$cfty_allow_privileged_users_as_only_reviewer = TRUE;
			}

			$date_format = $this->get_platform_date_format($jnl_id);
			$date_format = $this->date_format_map($date_format);

			$jwf_parent_user_roles_new = 'REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")';
			$jwf_who_can_invite_new = 'REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","")';

			$art_user_allocation_cnd = ' IF(allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$this->current_user['user_id'].',allocate_curr_role_users) = 1, '.$user_retire_flag.' AND FIND_array_intersect('.$roleid.',user_artp_roles) = 1) ';

			$select_shortlist_permission = ',IF(jwf_assignment != \'self_service\'  AND FIND_array_intersect('.$roleid.','.$jwf_parent_user_roles_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS shortlist_permission';

			$select_invite_permission = ',IF(jwf_assignment = \'invitation\' AND FIND_array_intersect('.$roleid.','.$jwf_who_can_invite_new.') = 1 AND '.$art_user_allocation_cnd.' ,TRUE,FALSE) AS invite_permission';

			$select = 'artp_palette_color_code,artp_fwm_id,DATE_FORMAT(art_epub_date,"' . $date_format . '") AS rv_art_epub_date,IF(art_epub_date IS NOT NULL and art_epub_date< now(),1,0) as art_epub_date_flag,artp_jpm_id,artp_special_issue,artp_article_type,artp_abbr_article_type,art_id,art_code,art_status,art_delete_status,art_title,art_artp_id,art_submitted_by,art_prev_article_id,DATE_FORMAT(art_submission_date, "' . $date_format .' %H:%i") as art_submission_date_format,art_stub,aflw_id,aflw_due_date as due_date,DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days,aflw_art_id as reviewed_article,art_publication_issue,iss_soft_end_date,auth_corr_author_list,atotp_review_method,atotp_custom_blind_params,iss_hard_end_date,art_stage_submission_method,art_es_document_type,art_es_document_status'.$select_shortlist_permission.$select_invite_permission;

			$blinded_articles = $this->get_blinded_articles($this->current_user['user_id']);
			if(!empty($blinded_articles))
			{
				$tile_condition[] = ' art_id NOT IN ('.$blinded_articles.') ';
			}

			//**********CONDITION START******** */
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$review_flow  = Config::get($workflow_config);
			$preventConfig = in_array(true,array_column($review_flow, 'prevent_edit'),true);
			$prevent_edit_cond = 'false';
			if($preventConfig){
				$prevent_edit_cond = '(cusr_action_type=\'prevent_edit_request_access\' AND IF(JSON_SEARCH(jp_prevent_edit,\'all\','.$roleid.') IS NOT NULL,IF(user_allocation_table.allocate_curr_role_users IS NOT NULL,FIND_array_intersect('.$this->current_user['user_id'].', allocate_curr_role_users),TRUE),FALSE))'; 
				$select .= ',IF('.$prevent_edit_cond.',cusr_id,"") AS cusr_id,IF('.$prevent_edit_cond.',cusr_action_type,"") AS cusr_action_type';
			}
			$art_status = '';
			if($submission_inprogrs_permited_role != TRUE)
			{
				$art_status = ' (art_status NOT IN (\'n\') OR '.$prevent_edit_cond.')';
			}
			if($post_data['core_role'] == 'journal_admin'  || $post_data['core_role'] == 'staff')
			{
				if($submission_inprogrs_permited_role == TRUE)   
			    {
					$art_status = ' (IF(art_status=\'n\',jwf_stage_type IN("resubmission","author_submission"),TRUE) AND IF(jwf_stage_type = "author_submission",a1.aflw_status NOT IN (\'i\',\'u\'),TRUE)  OR '.$prevent_edit_cond.')'; 
			    }
				else
				{
					$art_status = ' (IF(art_status=\'n\',jwf_stage_type = \'resubmission\',TRUE) OR '.$prevent_edit_cond.')'; 
				}

			}
			elseif($post_data['core_role'] == 'author' || $post_data['core_role'] == 'reviewer')
			{
				$array_data['non_author_flag'] = FALSE;
				$non_prvlg_srch_cnd = '';
				if($post_data['core_role'] == 'author')
				{
					$non_prvlg_srch_cnd = 'FIND_array_intersect('.$this->current_user['user_id'].', author_art_table.author_list) = 1';
					$art_status = ' IF(art_status = \'n\',art_submitted_by = '.$this->current_user['user_id'].' AND aflw_status IN (\'i\',\'a\'),TRUE) ';
					$tile_condition[] = ' (aflw_usr_id = '.$this->current_user['user_id'].' OR '.$non_prvlg_srch_cnd.') AND jwf_role_id = '.$roleid;
				}
				if($post_data['core_role'] == 'reviewer')
				{
					$non_prvlg_srch_cnd = 'FIND_array_intersect('.$this->current_user['user_id'].', author_art_table.author_list) = 0';
					$tile_condition[] = ' (aflw_usr_id = '.$this->current_user['user_id'].' AND '.$non_prvlg_srch_cnd.') AND jwf_role_id = '.$roleid;
				}
				

			}
			
			$article_flow_table = (new \App\Models\Article_flow())->getTable();
			$search_privilege_limited_roles = array('editor_in_chief','associate_editor','copy_editor','type_setter','proof_reader');
			$for_retire_role= '(CASE  WHEN allocate_curr_role_users IS NOT NULL  AND FIND_array_intersect(' . $this->current_user['user_id'] . ', allocate_curr_role_users) = 1 THEN TRUE
                    WHEN aflw_status IN (\'a\', \'c\')  AND aflw_usr_id = ' . $this->current_user['user_id'] . ' THEN TRUE ELSE FALSE END)';
			if ($this->current_client->functionality->cfty_manage_search_results_for_editors == 'y')
			{
				if(in_array($post_data['core_role'],$search_privilege_limited_roles))
				{
					
					$shotlist_cnd = ' (FIND_array_intersect('.$post_data['role_id'].','.$jwf_parent_user_roles_new.') = 1 AND  a1.aflw_stage_min_users > (SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'u\',\'i\',\'a\',\'c\') )) ';

                    $most_shortlist_cond = '( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'u\') ) > 0 ';

                    $invite_cnd = ' ( '.$most_shortlist_cond.' AND FIND_array_intersect('.$post_data['role_id'].','.$jwf_who_can_invite_new.') = 1 AND a1.aflw_stage_min_users > ( SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'i\',\'a\',\'c\') )) ';

					$assignment_cnd = ' IF(a1.aflw_status = \'w\', '.$art_user_allocation_cnd.' AND ('.$shotlist_cnd.' OR '.$invite_cnd.' ) AND aflw_more_review_skip_status =\'n\' AND  aflw_skip_review =\'n\',FALSE) ';

                    $assignment_p_cnd = ' IF(a1.aflw_status = \'p\', FIND_array_intersect('.$post_data['role_id'].','.$jwf_parent_user_roles_new.') = 1 AND '.$art_user_allocation_cnd.'  AND aflw_skip_review =\'n\' AND a1.aflw_stage_min_users > (select count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb where inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'a\',\'c\')),FALSE) ';

                	$already_started = ' ( aflw_status IN (\'a\',\'c\') AND aflw_usr_id = '.$this->current_user['user_id'].' ) ';
                    $for_checkout = ' ( aflw_status = \'u\' AND '.$art_user_allocation_cnd.' )';
                    $assign_checkout_cnd = ' ( jwf_role_id= '.$post_data['role_id'].'  AND ( '.$already_started.' OR '.$for_checkout.')) ';
					$transfer_cnd='(CASE WHEN art_status=\'t\' and jwf_stage_type=\'transit\' AND  `aflw_art_id` = `art_id` THEN TRUE ELSE FALSE end)';

                    //$tile_condition[] = ' aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\')  AND jwf_stage_type NOT IN (\'author_submission\',\'transit\',\'authors_declaration\',\'revision\',\'decision_resubmit\',\'resubmission\',\'copyright\',\'payment\')  AND FIND_array_intersect('.$post_data['role_id'].',user_artp_roles) = 1 AND  ('.$assignment_cnd.' OR '.$assignment_p_cnd.' OR '.$assign_checkout_cnd.') ';
					$tile_condition[] = ' (aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\')  AND jwf_stage_type NOT IN (\'author_submission\',\'authors_declaration\',\'revision\',\'decision_resubmit\',\'resubmission\',\'copyright\',\'payment\')  AND FIND_array_intersect('.$post_data['role_id'].',user_artp_roles) = 1 AND  ('.$assignment_cnd.' OR '.$assignment_p_cnd.' OR '.$assign_checkout_cnd.' OR '.$transfer_cnd.') OR ('.$prevent_edit_cond.')) ';

                                    //\'staff_check\',\'pre_assessment\',\'post_assessment\',\'accept\',\'reject\',\'decision_revision\',\'license_check\',\'production\',\'review\'
                                    
				}
				elseif($user_retire_status == true)
				{
					$tile_condition[] = '((aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\',\'i\') OR '.$prevent_edit_cond.') AND '.$for_retire_role.')';
				}
			}
			elseif($user_retire_status == true)
				{
					$tile_condition[] = '((aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\',\'i\') OR '.$prevent_edit_cond.') AND '.$for_retire_role.')';
				}else{
				//$tile_condition[] = '(aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\',\'i\') OR ('.$prevent_edit_cond.'))';
				if((isset($post_data['post_from']) && $post_data['post_from'] == 'normal_search') || (isset($post_data['search_arr']['search_type']) && $post_data['search_arr']['search_type']=="article") )
				{
					$tile_condition[] = '(aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\',\'i\',\'d\') OR ('.$prevent_edit_cond.'))';
				}
				else{
					$tile_condition[] = '(aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\',\'i\') OR ('.$prevent_edit_cond.'))';
				}
			}
            if($art_status!='')
			{
			$tile_condition[] = $art_status;
			}
			$tile_condition[] = ' aflw_status NOT IN (\'h\') ';
		
			//for avoid w/p stages if min. users assigned
		
			$child_count = 'a1.aflw_stage_min_users > (SELECT count(inn_tb.aflw_id) as cnt from '.$article_flow_table.' as inn_tb WHERE inn_tb.aflw_parent_flow_id = a1.aflw_id and inn_tb.aflw_status IN (\'i\',\'a\',\'c\',\'h\') ) AND aflw_skip_review = \'n\' ';

			$tile_condition[] = ' IF(jwf_assignment != \'self_service\' AND aflw_parent_flow_id IS NULL,'.$child_count.',TRUE) '; 
			$tile_condition[] = ' IF(jwf_assignment = \'invitation\',a1.aflw_status != \'u\',TRUE) ';

			if(isset($this->current_client->modules->mdl_production) &&  $this->current_client->modules->mdl_production == 'y')
			{
				$role_arr = array();
				$stage_type = array();

				$where_cnd = array(
					'role_id' => $roleid
				);
				$role_areas = Roles::get_single_record_with_bind_cond('role_used_in',$where_cnd);	
				
				if(isset($role_areas->role_used_in) && $role_areas->role_used_in != '')
				{
					$role_arr = explode(',',$role_areas->role_used_in);
				}

				$stage_keys = $this->get_production_stages_keys(NULL,FALSE,TRUE);
				
				if(in_array('r',$role_arr) && !in_array('p',$role_arr))
				{
					$stage_type = $stage_keys['review'];
				}
				elseif(in_array('p',$role_arr) && !in_array('r',$role_arr))
				{
					$stage_type = $stage_keys['production'];
				}

				if(!empty($stage_type))
				{
					if(count($stage_type) > 1)
					{
						$tile_condition[] = ' jwf_stage_type IN (\''. implode('\',\'', $stage_type).'\')';
					}
					else
					{
						$tile_condition[] = ' jwf_stage_type = \''.$stage_type[0].'\'';
					}
				}
			}
			//**********CONDITION STOP******** */
			$tile_condition_str = '';
			if(count($tile_condition) > 0)
				$array_data['extra_condition'] = implode(' AND ',$tile_condition); 
			
			//for fetching header data 
			$array_data['user_id']=$this->current_user['user_id'];
			$array_data['jnl_id']=$post_data['jnl_id'];
			$array_data['select']=$select;
			$array_data['return_count']=FALSE;
			//$array_data['condition']=$tile_condition_str;

			$array_data['cfty_manage_privilaged_user_as_reviewer']=FALSE;
			$array_data['limit']=NULL;
			$array_data['start']=NULL;
			$array_data['group_by']=$group_by; 
			$array_data['order_by']=$order_by;
			//$array_data['assignment']= TRUE;
			$array_data['role_id']=$roleid;
			$array_data['art_flow_alias']=TRUE;
			$array_data['cfty_allow_privileged_users_as_only_reviewer'] = $cfty_allow_privileged_users_as_only_reviewer;
			$array_data['clnt_client_code']=$this->current_client->clnt_client_code;
			$array_data['core_role'] = $post_data['core_role'];			
			$array_data['issue_tb_connect'] = TRUE;
			$array_data['transfer_tb_connect'] =TRUE;
			$array_data['condition'] = count($condition_arr) == 0 ? NULL : $condition_arr;
			$export_article = FALSE;
			if(isset($post_data['search_arr']['export']) && $post_data['search_arr']['export'] == TRUE)
			{
				$export_article = TRUE;
				$array_data['pagination'] = FALSE;
			}
			$array_data['export_flag'] = $export_article;

			$array_data['preventEditAuthor'] = $preventConfig;
			//DB::enableQueryLog();
			$result['head'] = Articles::advanced_search_results($array_data);
			//$query = DB::getQueryLog();$query = end($query);print_r($query);exit;
			//dd($article_stages);

			if(count($result['head']) > 0)
			{
				$article_flow_table = (new \App\Models\Article_flow())->getTable();

				$array_data['group_by'] = array('art_id','aflw_id');
				$array_data['order_by'] = 'art_id,aflw_level,aflw_id'; /* Prev code $array_data['order_by'] = 'art_id,aflw_id' Task #92 taskbot  Change the status of editor decision when article moved to revision stage */
				$art_id_arr = array();
				foreach($result['head'] as $item)
				{
					$art_id_arr[] = $item->art_id;
				}
			
				//$array_data['condition']= $array_data['condition']. ' AND  art_id IN ('.implode(',',$art_id_arr).')';
				$array_data['extra_condition'] = (isset($array_data['extra_condition']) && $array_data['extra_condition'] != '')?$array_data['extra_condition'].' AND ':' ';
				
				$array_data['extra_condition'] .= ' art_id IN ('.implode(',',$art_id_arr).')';
				//dd($array_data['extra_condition']);
				// if(!empty(trim($array_data['condition'])))
				// 	$array_data['condition'] .= ' AND ';
							
				// $array_data['condition']= $array_data['condition']. '  art_id IN ('.implode(',',$art_id_arr).')';	
							
				$result['format_head_stage']=$this->format_head_article($result['head'],$post_data['jnl_id'],$post_data['jnl_code'],$roleid,"search");

				$select = 'artp_fwm_id,art_code,aflw_parent_flow_id,art_title,art_artp_id,artp_jpm_id,artp_article_type,art_status,art_delete_status,art_submitted_by,aflw_id,aflw_parent_flow_id,aflw_art_id as art_id,aflw_jwf_id,aflw_remarks,aflw_stage_min_users,aflw_stage_max_users,aflw_status,aflw_due_date,aflw_invite_due_date,aflw_posted_by,aflw_operation,aflw_usr_id,jwf_stage_name,ROW_NUMBER() OVER (ORDER BY aflw_id) AS rn,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as per_shotlist_roles,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","") as jwf_parent_user_roles_new,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as per_invite_roles,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),"]",""),"[","") as jwf_who_can_invite_new,jwf_role_id,jwf_stage_type,art_publication_issue,iss_soft_end_date,jwf_status_name,jwf_temporary_status_name,art_prev_article_id,iss_hard_end_date,ats_author_action'.$select_shortlist_permission.$select_invite_permission;

				$select .= ' ,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE a1.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN(\'u\',\'i\',\'a\',\'c\')),NULL) as shot_listed,IF(a1.aflw_status IN(\'w\',\'p\'),(SELECT COUNT(base_tbtwo.aflw_id) FROM '.$article_flow_table.' base_tbtwo WHERE a1.aflw_id = base_tbtwo.aflw_parent_flow_id AND base_tbtwo.aflw_status IN(\'i\',\'a\',\'c\')),NULL) as invited_list';
				if($preventConfig)
					$select .= ',IF('.$prevent_edit_cond.',cusr_id,"") AS cusr_id,IF('.$prevent_edit_cond.',cusr_action_type,"") AS cusr_action_type';

				$select .= ',DATEDIFF(a1.aflw_due_date ,NOW()) AS rvd_remaining_days';
				$select .= ',DATEDIFF(a1.aflw_invite_due_date ,NOW()) AS rvd_remaining_days_invite_due';

				$select .= ',DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i") AS due_date';
				//$select .= ',DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';
				// if(isset($post_data['post_from']) && $post_data['post_from'] == 'normal_search')
					$select .= ',IF(a1.aflw_status NOT IN(\'d\',\'g\'),DATE_FORMAT(a1.aflw_due_date,"' . $date_format . ' %H:%i"),NULL) AS rvd_aflw_due_date';
				$select .= ',DATE_FORMAT(a1.aflw_invite_due_date,"' . $date_format . ' %H:%i") AS invite_due_date';
				$select .= ',DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") AS aflw_assigned_date';
				$select .= ',DATE_FORMAT(aflw_accepted_date,"' . $date_format . ' %H:%i") AS aflw_accepted_date';
				$select .= ',DATE_FORMAT(aflw_returned_date,"' . $date_format . ' %H:%i") AS aflw_returned_date';
				// if($author_requests['status'] == TRUE && $author_requests['art_perm'] != "")
				// {
				// 	$array_data['preventEditAuthor'] = TRUE;
				// 	$array_data['preventEditAuthorList'] = $author_requests['art_perm'];
				// 	// $tile_condition[] = ' art_id IN ('.$author_requests['art_perm'].') ';
				// 	$select .= ',cusr_id,cusr_status,cusr_action_type,cusr_aflw_id';
				// }
				$array_data['select']=$select;
				$array_data['pagination'] = FALSE;

				//DB::enableQueryLog();
				$article_stages = Articles::advanced_search_results($array_data);
				
		//$query = DB::getQueryLog();
				//dd($query);
				//print_r($query);exit;
				//dd($article_stages);

				$type = 'todo_all_task';
				$my_task = TRUE;
				// TASK #5132Assigned user name or user role is missing for the articles inside stage over view "Review - Awaiting shortlist/invite articles"
				if($post_data['core_role'] == 'journal_admin' || $post_data['core_role'] == 'staff')
				{
					$my_task = FALSE;
				}
				$art_stages = $this->arrange_article_stages($article_stages,$post_data['jnl_code'],$post_data['jnl_id'],$core_role,$type,$my_task,$roleid,'',$date_format);
				if($export_article == TRUE)
				{
					$result = [];
					$result['download_link'] = $this->create_csv_file_creation($post_data['jnl_code'],$art_stages,$post_data,'article');
				}
				else
				{
					$result['stages'] = $art_stages['art_stages'];
					$result['global_es_data'] = $art_stages['es_data_global_arr'];
				}
				//dd($result);

			}
		}
		return $result;			
	}

	public function arrange_normal_search_filter($post_data)
	{
		$filter_arr = array();
		if(isset($post_data['search_by']))
		{
			//article title filter
			if($post_data['search_by'] == 'article_id')
			{
				$filter_arr['article_id_filter'] = array(
					'LIKE' => $post_data['search_value']
				);
			}
			//article title filter
			if($post_data['search_by'] == 'article_title')
			{
				// detect non-ASCII characters in a string?
				// This will return false if input contains at least one non-ASCII character
				// if(!mb_detect_encoding($post_data['search_value'], 'ASCII', true)) {
				// 	$post_data['search_value']	=	htmlentities($post_data['search_value'], ENT_QUOTES, "UTF-8");
				// }
				$filter_arr['article_title_filter'] = array(
					'LIKE' => $post_data['search_value']
				);
			}
		}
		return $filter_arr;
	}

	public function manage_search_filters($search_details = array())
	{
		$return_arr = array();
		//echo '<pre>';print_r($search_details);die;
		//JOURNAL FILTER SECTION -- START
		if (isset($search_details['journal_stype']) && isset($search_details['journal']) && count($search_details['journal_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['journal_stype'], $search_details['journal'], 'array', TRUE);
			if (count($temp_filter) > 0)
				$return_arr['journal_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//JOURNAL FILTER SECTION -- STOP
		//ROLE FILTER SECTION -- START
		if (isset($search_details['userroles_stype']) && isset($search_details['userroles']) && count($search_details['userroles_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['userroles_stype'], $search_details['userroles'], 'array');
			if (count($temp_filter) > 0)
				$return_arr['role_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//ROLE FILTER SECTION -- STOP

		/* Feature #2063 - JPR-214 Retiring an AE/Editor -- View article section */
		//RETIRE ROLE FILTER SECTION -- START
		if (isset($search_details['retiredroles_stype']) && isset($search_details['retiredroles']) && count($search_details['retiredroles_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['retiredroles_stype'], $search_details['retiredroles'], 'array');
			if (count($temp_filter) > 0)
				$return_arr['retired_role_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//RETIRE ROLE FILTER SECTION -- STOP
		//ARTICLE TITLE FILTER SECTION -- START
		if (isset($search_details['articletitle_stype']) && isset($search_details['articletitle']) && count($search_details['articletitle_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['articletitle_stype'], $search_details['articletitle'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['articletitle_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//ARTICLE TITLE FILTER SECTION -- STOP
		//ARTICLE ORCID FILTER SECTION -- START
		if (isset($search_details['article_orcid_stype']) && isset($search_details['article_orcid']) && count($search_details['article_orcid']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_orcid_stype'], $search_details['article_orcid'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_orcid_filter'] = $temp_filter;
		}
		//ARTICLE ORCID FILTER SECTION -- STOP
		//REVIEW RATING FILTER SECTION -- START
		if (isset($search_details['reviewer_rating_stype']) && isset($search_details['reviewer_rating']) && count($search_details['reviewer_rating_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['reviewer_rating_stype'], $search_details['reviewer_rating'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['review_rating_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//REVIEW RATING FILTER SECTION -- STOP
		//COMPLETED REVIEW COUNT FILTER SECTION -- START
		if (isset($search_details['completed_review_count_stype']) && isset($search_details['completed_review_count']) && count($search_details['completed_review_count_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['completed_review_count_stype'], $search_details['completed_review_count'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['completed_review_count_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//COMPLETED REVIEW COUNT FILTER SECTION -- STOP
		//AUTODECLINED UNASSIGNED FILTER SECTION -- START
		if (isset($search_details['autodeclined_unassigned_review_count_stype']) && isset($search_details['autodeclined_unassigned_review_count']) && count($search_details['autodeclined_unassigned_review_count_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['autodeclined_unassigned_review_count_stype'], $search_details['autodeclined_unassigned_review_count'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['autodeclined_unassigned_review_count_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}

		//REVIEW IN HAND FILTER SECTION -- START
		if (isset($search_details['present_review_count_stype']) && isset($search_details['present_review_count']) && count($search_details['present_review_count_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['present_review_count_stype'], $search_details['present_review_count'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['present_review_count_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//REVIEW IN HAND FILTER SECTION -- STOP
		//INSTITUTION FILTER SECTION -- START
		if (isset($search_details['institution_stype']) && isset($search_details['institution']) && count($search_details['institution_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['institution_stype'], $search_details['institution'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['institution_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//INSTITUTION  FILTER SECTION -- STOP
		//COUNTRY FILTER SECTION -- START
		if (isset($search_details['country_stype']) && isset($search_details['country']) && count($search_details['country_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['country_stype'], $search_details['country'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['country_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//COUNTRY FILTER SECTION -- STOP
		//POSTCODE FILTER SECTION -- START
		if (isset($search_details['post_code_stype']) && isset($search_details['post_code']) && count($search_details['post_code_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['post_code_stype'], $search_details['post_code'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['post_code_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//POSTCODE FILTER SECTION -- STOP
		//USERNAME FILTER SECTION -- START
		if (isset($search_details['user_name_stype']) && isset($search_details['user_name']) && count($search_details['user_name_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_name_stype'], $search_details['user_name'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['username_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//USERNAME FILTER SECTION -- STOP
		//USERNAME FILTER SECTION -- START
		if (isset($search_details['user_email_stype']) && isset($search_details['user_email']) && count($search_details['user_email_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_email_stype'], $search_details['user_email'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_email_filter'] = $temp_filter;
			//echo '<pre>';print_r($return_arr);die;
		}
		//USERNAME FILTER SECTION -- STOP
		//REVIEW DATE FILTER SECTION -- START
		if (isset($search_details['review_date_range_type'][0]) && count($search_details['review_date_range_type'][0]) > 0)
		{
			$return_arr['review_date_filter'] = $search_details['review_date_range_type'][0];
			if ($search_details['review_date_range_type'][0] == 'custom_year')
			{
				$return_arr['jnl_date'] = $this->jnl_data->jset_date_format;
				if (isset($search_details['review_start_date'][0]))
				{
					$return_arr['review_date_start'] = $search_details['review_start_date'][0];
				}
				if (isset($search_details['review_end_date'][0]))
				{
					$return_arr['review_date_end'] = $search_details['review_end_date'][0];
				}
			}
			//echo '<pre>';print_r($return_arr);die;
		}
		//REVIEW DATE FILTER SECTION -- STOP
		//KEYWORDS FILTER SECTION -- START
		if (isset($search_details['keyword_stype']) && count($search_details['keyword_stype']) > 0)
		{
			$temp_arr = array();
			$main_arr = array();
			$keyword_type = '';
			foreach ($search_details['keyword_stype'] as $key => $keyword)
			{
				if ($keyword_type != '' && $keyword_type != $keyword && count($temp_arr) > 0)
				{
					$main_arr[$keyword_type] = $temp_arr;
					$temp_arr = array();
				}

				if ($search_details['keyword_operator'][$key] == 'LIKE')
				{
					$like_text = trim($search_details['keyword_name'][$key]);
					if ($like_text != '')
						$temp_arr[$search_details['keyword_operator'][$key]] = $like_text;
				}
				else
				{
					if (isset($search_details['keyword'][$key]) && count($search_details['keyword'][$key]) > 0)
						$temp_arr[$search_details['keyword_operator'][$key]] = implode(',', $search_details['keyword'][$key]);
				}

				$keyword_type = $keyword;
			}

			if (!isset($main_arr[$keyword_type]) && count($temp_arr) > 0)
				$main_arr[$keyword_type] = $temp_arr;

			$return_arr['keyword_filter'] = $main_arr;
			//echo '<pre>';print_r($return_arr);die;
		}
		//KEYWORDS FILTER SECTION -- STOP

		//USER CLASSFICATION FILTER SECTION - START
		if (isset($search_details['user_classifications_stype']) && isset($search_details['user_classifications']) && count($search_details['user_classifications_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_classifications_stype'], $search_details['user_classifications'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_classification_filter'] = $temp_filter;
		}
		//USER CLASSFICATION FILTER SECTION - STOP

		if(isset($search_details['article_title_left']) && isset($search_details['article_title_right']) && count($search_details['article_title_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_title_left'], $search_details['article_title_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_title_filter'] = $temp_filter;
		}
		if(isset($search_details['article_id_left']) && isset($search_details['article_id_right']) && count($search_details['article_id_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_id_left'], $search_details['article_id_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_id_filter'] = $temp_filter;
		}
		if(isset($search_details['art_submission_status_left']) && isset($search_details['art_submission_status_right']) && count($search_details['art_submission_status_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['art_submission_status_left'], $search_details['art_submission_status_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['art_submission_status_filter'] = $temp_filter;
		}
		if(isset($search_details['article_type_left']) && isset($search_details['article_type_right']) && count($search_details['article_type_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_type_left'], $search_details['article_type_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_type_filter'] = $temp_filter;
		}
		if(isset($search_details['submitted_by_left']) && isset($search_details['submitted_by_right']) && count($search_details['submitted_by_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['submitted_by_left'], $search_details['submitted_by_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['submitted_by_filter'] = $temp_filter;
		}
		if(isset($search_details['corresponding_author_left']) && isset($search_details['corresponding_author_right']) && count($search_details['corresponding_author_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['corresponding_author_left'], $search_details['corresponding_author_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['corres_author_filter'] = $temp_filter;
		}
		if(isset($search_details['all_authors_left']) && isset($search_details['all_authors_right']) && count($search_details['all_authors_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['all_authors_left'], $search_details['all_authors_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['all_author_filter'] = $temp_filter;
		}
		if(isset($search_details['article_keyword_left']) && isset($search_details['article_keyword_right']) && count($search_details['article_keyword_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_keyword_left'], $search_details['article_keyword_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_keyword_filter'] = $temp_filter;
		}
		//ARTICLE CLASSFICATION FILTER SECTION - START
		if(isset($search_details['article_classification_left']) && isset($search_details['article_classification_right']) && count($search_details['article_classification_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_classification_left'], $search_details['article_classification_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_classification_filter'] = $temp_filter;
		}
		//ARTICLE CLASSFICATION FILTER SECTION - STOP

		if(isset($search_details['article_flag_left']) && isset($search_details['article_flag_right']) && count($search_details['article_flag_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['article_flag_left'], $search_details['article_flag_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_flag_filter'] = $temp_filter;
		}
		if(isset($search_details['is_transferred_left']))
		{
			$return_arr['transfer_filter'] = $search_details['is_transferred_left'][0];
		}
		if(isset($search_details['is_resubmitted_left']))
		{
			$return_arr['resubmit_filter'] = $search_details['is_resubmitted_left'][0];
		}
		if(isset($search_details['is_revised_left']))
		{
			$return_arr['revised_filter'] = $search_details['is_revised_left'][0];
		}
		if(isset($search_details['is_special_issue_left']))
		{
			$return_arr['special_issue_filter'] = $search_details['is_special_issue_left'][0];
		}
		if(isset($search_details['copyright_is_open_access_left']))
		{
			$return_arr['copyright_is_open_access'] = $search_details['copyright_is_open_access_left'][0];
		}
		if(isset($search_details['copyright_is_left']) && isset($search_details['copyright_is_right']) && count($search_details['copyright_is_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['copyright_is_left'], $search_details['copyright_is_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['copyright_filter'] = $temp_filter;
		}
		if(isset($search_details['payment_is_left']) && isset($search_details['payment_is_right']) && count($search_details['payment_is_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['payment_is_left'], $search_details['payment_is_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['payment_filter'] = $temp_filter;
		}
		if(isset($search_details['published_article_type_difference_left']))
		{
			$return_arr['published_article_type_difference_filter'] = $search_details['published_article_type_difference_left'][0];
		}
		if(isset($search_details['published_article_type_left']) && isset($search_details['published_article_type_right']) && count($search_details['published_article_type_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['published_article_type_left'], $search_details['published_article_type_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['published_article_type_filter'] = $temp_filter;
		}
		if(isset($search_details['original_article_id_left']) && isset($search_details['original_article_id_right']) && count($search_details['original_article_id_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['original_article_id_left'], $search_details['original_article_id_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['orginal_id_filter'] = $temp_filter;
		}
		if(isset($search_details['submission_date_left']))
		{
			$extra_field = array();
			if(isset($search_details['submission_date_right']))
			{
				if(count($search_details['submission_date_left']) !== count($search_details['submission_date_right']))
				{
					if(in_array('>=NO_APOSTROPHE',$search_details['submission_date_left']))
					{
						array_push($extra_field,'>=NO_APOSTROPHE');
					}
					if(in_array('NO_APOSTROPHE>=',$search_details['submission_date_left']))
					{
						array_push($extra_field,'NO_APOSTROPHE>=');
					}
					$search_details['submission_date_left'] = array_diff($search_details['submission_date_left'], ['>=NO_APOSTROPHE', 'NO_APOSTROPHE>=']);
					$tempor_arr = array();
					foreach($search_details['submission_date_left'] as $values)
					{
						array_push($tempor_arr,$values);
					}
					$search_details['submission_date_left'] = $tempor_arr;
				}
				$temp_filter = $this->arrange_post_data($search_details['submission_date_left'], $search_details['submission_date_right'], 'string');
				if(count($temp_filter) > 0)
				{
					$return_arr['submission_filter'] = $temp_filter;
				}
				if(count($extra_field))
				{
					foreach($extra_field as $value)
					{
						$return_arr['submission_filter'][$value] = TRUE;
					}
				}
			}
			else
			{
				$return_arr['submission_filter'] = array();
				foreach($search_details['submission_date_left'] as $value)
				{
					$return_arr['submission_filter'][$value] = TRUE;
				}
			}
		}

		if(isset($search_details['original_submission_date_left']))
		{
			$extra_field = array();
			if(isset($search_details['original_submission_date_right']))
			{
				if(count($search_details['original_submission_date_left']) !== count($search_details['original_submission_date_right']))
				{
					if(in_array('>=NO_APOSTROPHE',$search_details['original_submission_date_left']))
					{
						array_push($extra_field,'>=NO_APOSTROPHE');
					}
					if(in_array('NO_APOSTROPHE>=',$search_details['original_submission_date_left']))
					{
						array_push($extra_field,'NO_APOSTROPHE>=');
					}
					$search_details['original_submission_date_left'] = array_diff($search_details['original_submission_date_left'], ['>=NO_APOSTROPHE', 'NO_APOSTROPHE>=']);
					$tempor_arr = array();
					foreach($search_details['original_submission_date_left'] as $values)
					{
						array_push($tempor_arr,$values);
					}
					$search_details['original_submission_date_left'] = $tempor_arr;
				}
				$temp_filter = $this->arrange_post_data($search_details['original_submission_date_left'], $search_details['original_submission_date_right'], 'string');
				if(count($temp_filter) > 0)
				{
					$return_arr['org_sub_date_filter'] = $temp_filter;
				}
				if(count($extra_field))
				{
					foreach($extra_field as $value)
					{
						$return_arr['org_sub_date_filter'][$value] = TRUE;
					}
				}
			}
			else
			{
				$return_arr['org_sub_date_filter'] = array();
				foreach($search_details['original_submission_date_left'] as $value)
				{
					$return_arr['org_sub_date_filter'][$value] = TRUE;
				}
			}
		}
		if(isset($search_details['art_decision_left']) && isset($search_details['art_decision_right']) && count($search_details['art_decision_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['art_decision_left'], $search_details['art_decision_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['article_decision_filter'] = $temp_filter;
		}

		if(isset($search_details['decision_date_left']))
		{
			$extra_field = array();
			if(isset($search_details['decision_date_right']))
			{
				if(count($search_details['decision_date_left']) !== count($search_details['decision_date_right']))
				{
					if(in_array('>=NO_APOSTROPHE',$search_details['decision_date_left']))
					{
						array_push($extra_field,'>=NO_APOSTROPHE');
					}
					if(in_array('NO_APOSTROPHE>=',$search_details['decision_date_left']))
					{
						array_push($extra_field,'NO_APOSTROPHE>=');
					}
					$search_details['decision_date_left'] = array_diff($search_details['decision_date_left'], ['>=NO_APOSTROPHE', 'NO_APOSTROPHE>=']);
					$tempor_arr = array();
					foreach($search_details['decision_date_left'] as $values)
					{
						array_push($tempor_arr,$values);
					}
					$search_details['decision_date_left'] = $tempor_arr;
				}
				$temp_filter = $this->arrange_post_data($search_details['decision_date_left'], $search_details['decision_date_right'], 'string');
				if(count($temp_filter) > 0)
				{
					$return_arr['decision_date_filter'] = $temp_filter;
				}
				if(count($extra_field))
				{
					foreach($extra_field as $value)
					{
						$return_arr['decision_date_filter'][$value] = TRUE;
					}
				}
			}
			else
			{
				$return_arr['decision_date_filter'] = array();
				foreach($search_details['decision_date_left'] as $value)
				{
					$return_arr['decision_date_filter'][$value] = TRUE;
				}
			}
		}

		if(isset($search_details['art_status_left']) && isset($search_details['art_status_right']) && count($search_details['art_status_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['art_status_left'], $search_details['art_status_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['art_status_filter'] = $temp_filter;
		}
		if (isset($search_details['usr_firstname_stype']) && isset($search_details['user_fname']) && count($search_details['usr_firstname_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['usr_firstname_stype'], $search_details['user_fname'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_fname_filter'] = $temp_filter;
		}
		if (isset($search_details['usr_lastname_stype']) && isset($search_details['user_lname']) && count($search_details['usr_lastname_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['usr_lastname_stype'], $search_details['user_lname'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_lname_filter'] = $temp_filter;
		}
		if (isset($search_details['usr_title_stype']) && isset($search_details['user_title']) && count($search_details['usr_title_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['usr_title_stype'], $search_details['user_title'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_title_filter'] = $temp_filter;
		}
		if (isset($search_details['usr_status_stype']) && isset($search_details['user_status']) && count($search_details['usr_status_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['usr_status_stype'], $search_details['user_status'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_status_filter'] = $temp_filter;
		}
		if (isset($search_details['user_kwd_stype']) && isset($search_details['user_keywords']) && count($search_details['user_kwd_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_kwd_stype'], $search_details['user_keywords'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_keyword_filter'] = $temp_filter;
		}
		if (isset($search_details['user_role_stype']) && isset($search_details['user_role']) && count($search_details['user_role_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_role_stype'], $search_details['user_role'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_role_filter'] = $temp_filter;
		}
		if (isset($search_details['user_artp_stype']) && isset($search_details['user_article_type']) && count($search_details['user_artp_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_artp_stype'], $search_details['user_article_type'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_artp_filter'] = $temp_filter;
		}
		if (isset($search_details['usr_flags_stype']) && isset($search_details['user_flags']) && count($search_details['usr_flags_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['usr_flags_stype'], $search_details['user_flags'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_flag_filter'] = $temp_filter;
		}
		if (isset($search_details['usr_global_flags_stype']) && isset($search_details['user_global_flags']) && count($search_details['usr_global_flags_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['usr_global_flags_stype'], $search_details['user_global_flags'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['user_global_flag_filter'] = $temp_filter;
		}

		if(isset($search_details['by_assignment_left']) && isset($search_details['by_assignment_right']) && count($search_details['by_assignment_right']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['by_assignment_left'], $search_details['by_assignment_right'], 'string');
			if (count($temp_filter) > 0)
				$return_arr['by_assignment_filter'] = $temp_filter;
		}
		return $return_arr;
	}

	//data arrange function
	public function arrange_post_data($filter_data, $data_arr, $content_type = 'array', $data_encp = FALSE)
	{
		$review_filter = array();
		if (isset($filter_data) && count($filter_data) > 0)
		{
			$filter = array();
			if ($content_type == 'array')
				$data = array();
			else
				$data = '';
			foreach ($filter_data as $jk => $jv)
			{
				$review_data = (isset($data_arr[$jk])) ? $data_arr[$jk] : $data;
				if ($content_type == 'array')
				{
					if (count($review_data) > 0)
					{
						if ($data_encp == TRUE)
						{
							array_walk($review_data, function(&$value, $key)
							{
								$value = decrypt_link($value);
							});
						}
						$review_filter[$jv] = implode(',', $review_data);
					}
				}
				else
				{
					if ($review_data != '')
						$review_filter[$jv] = trim($review_data);
				}
			}
			//$return_arr[$return_key] = $review_filter;
			//echo '<pre>';print_r($review_filter);die;
		}

		return $review_filter;
	}
	
	 /*
    master function to load dashboard config
    commited date :-  25-04-2022
    Request type :- POST
    */
    public function isadvsrch_link(Request $request)
    {
		$result = false;
        try
        {
            $validator = Validator::make($request->all(), [
                'core_role' => 'required',
				'jnl_id' => 'required',
            ]);

            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            else
            {
                $post_data = $request->all();
				
				$jnl_id = $post_data['jnl_id'];
				$core_role = $post_data['core_role'];
				
				$result = $this->hasAdvanceSearch($jnl_id,$core_role);
                
				return $this->success('success',200,$result);
            }
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
        
	}
	
	public function ajax_populate_select(Request $request)
	{
		$post_data = $request->all();
		$type = $post_data['query_type'];
		$search_string = $post_data['query'];
		$journal_id = NULL;
		if (isset($post_data["jnl_id"])) {
			$journal_id = $post_data["jnl_id"];
		}
		$result_set = array();
		$results = array();
		if ($type == 'art_decision_name') {

			$sql = 'SELECT 
						tb4.jwf_stage_name as name
						FROM
						rvw_article_flow AS tb1
							JOIN
						(SELECT 
							MAX(aflw_id) AS aflw_id
						FROM
							rvw_article_flow AS rvw_article_flow_for_all_stages
						LEFT JOIN rvw_journal_workflows AS rvw_journal_workflows_for_all_stages ON rvw_journal_workflows_for_all_stages.jwf_id = rvw_article_flow_for_all_stages.aflw_jwf_id
						WHERE 
							rvw_journal_workflows_for_all_stages.jwf_stage_type IN (\'accept\' , \'reject\', \'decision_revision\', \'resubmission\')
								AND aflw_returned_date IS NOT NULL
						GROUP BY aflw_art_id) AS tb2 ON tb1.aflw_id = tb2.aflw_id
							LEFT JOIN
						rvw_articles AS tb3 ON tb1.aflw_art_id = tb3.art_id
							LEFT JOIN
						rvw_journal_workflows tb4 ON tb1.aflw_jwf_id = tb4.jwf_id 
						where tb4.jwf_stage_name  LIKE "%' . $search_string . '%"
						GROUP BY tb4.jwf_stage_name';
			$result_set = DB::select($sql);
		}
		else if($type == 'users')
		{
			$user_table=(new \App\Models\User())->getTable();
			$sql = 'SELECT DISTINCT `usr_id` as `id`, `usr_email` as `useremail`, CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ", `usr_middle_name`, " ")), usr_last_name) as name FROM '.$user_table.' WHERE CONCAT(usr_first_name, IF(usr_middle_name IS NULL or `usr_middle_name` = "", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) LIKE "%'.$search_string.'%" ORDER BY `usr_first_name` LIMIT 25';
			$result_set = DB::select($sql);
		}
		if(!empty($result_set))
		{
			foreach ($result_set as $key) {
				if (!isset($key->id))
					$key->id = $key->name;
	
				$id = $key->id;
				if($type == 'assignusers') 
					$id = encrypt_link($key->id);
				
				$results[] = array(
					'label' => $key->name,
					'value' => $id);
			}
		}
		return $this->success('success',200,$results);
	}

	public function init_adv_search_data(Request $request)
	{
		$jnl_id = $request['jnl_id'];
		$flag_table=(new \App\Models\Flags())->getTable();
		$flag_sql = 'SELECT DISTINCT `flag_name`,`flag_id` FROM '.$flag_table.' LEFT JOIN `rvw_article_flag` ON `aflg_flag_id` = `flag_id` WHERE `flag_type` = "a"';
		$result_set = DB::select($flag_sql);
		$results = array();
		if(!empty($result_set))
		{
			foreach ($result_set as $key) 
			{
				$results['article_flag'][] = array(
					'label' => $key->flag_name,
					'value' => $key->flag_id
				);
			}
		}
		$copyright =  new \App\Models\Copyright_master();
		$cpy_data = $copyright::select('crtm_id','crtm_license_name')->get();
		if(!empty($cpy_data))
		{
			foreach($cpy_data as $key) 
			{
				$results['copyright_is'][] = array(
					'label' => $key->crtm_license_name,
					'value' => $key->crtm_id
				);
			}	
		}
		$country = new \App\Models\Country();
		$country_list = $country::get_all_records('cnt_country as label,cnt_id as value');
		$results['usr_country'] = $country_list;
		$article_type_table = (new \App\Models\Article_types())->getTable();
		$type_sql = 'select artp_id,artp_article_type from '.$article_type_table.' where artp_jnl_id = '.$jnl_id.' AND artp_status=\'y\' GROUP BY artp_article_type ORDER by artp_article_type';
		$type_set = DB::select($type_sql);
		$results['article_type'] = [];
		$results['published_article_type'] = [];
		$results['usr_article_type'] = [];
		if(!empty($type_set))
		{
			foreach($type_set as $key) 
			{
				$results['article_type'][] = array(
					'label' => $key->artp_article_type,
					'value' => $key->artp_id
				);
				$results['published_article_type'][] = array(
					'label' => $key->artp_article_type,
					'value' => $key->artp_id
				);
				$results['usr_article_type'][] = array(
					'label' => $key->artp_article_type,
					'value' => $key->artp_id
				);
			}	
		}
		$salutation = $this->UserConfigdata('titles');
		foreach($salutation['titles'] as $key => $value)
		{
			$results['usr_title'][] = array(
				'label' => $value,
				'value' => $key
			);
		}
		$roles = new \App\Models\Roles();
		$roles_data = $roles::get_all_records('role_id,role_name');
		foreach($roles_data as $key) 
		{
			$results['usr_role'][] = $results['by_assignment'][] = array(
					'label' => $key->role_name,
					'value' => $key->role_id
			);
		}	

		/* $articleTypes=new \App\Models\Article_types();
		 $artps = $articleTypes::get_all_records('artp_id,artp_article_type');
		 foreach($artps as $key) 
		 {
		 	$results['usr_article_type'][] = array(
		 			'label' => $key->artp_article_type,
		 			'value' => $key->artp_id
		 	);
		 }*/	
		$flags = new \App\Models\Flags();
		$usr_flags = $flags::get_all_records("Distinct flag_name","`flag_type` = 'u'");
		if(!empty($usr_flags)&&count($usr_flags)>0)
		{
			foreach($usr_flags as $key) 
			{
				$results['usr_flags'][] = array(
					'label' => $key->flag_name,
					'value' => $key->flag_name
				);
			}	
			$results['usr_global_flags'] = $results['usr_flags'];
		}
		//get Classification data
		$jnl_classification = $this->search_classificationdata(NULL, NULL, $jnl_id); 
		$results['classfication_data'] = $jnl_classification;
		return $this->success('success',200,$results);
	}

	public function create_csv_file_creation($jnl_cole,$csv_details,$post_data,$type)
	{
		$cur_date = date("h:i:sa");
		$string_date = strtotime($cur_date);
		$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		// $file_name = 'advanced_search_'.$string_date.'_'.$jnl_cole. '.csv';
		$Journals=new \App\Models\Journals();
		$journalData = $Journals::get_single_record('jnl_journal_name', "jnl_id='{$post_data['jnl_id']}'");
		$journal_name = $journalData->jnl_journal_name;
		if ($type == 'user') {

			$file_name = $journal_name . ' user search.csv';
		} else {
			$file_name = $journal_name . ' article search.csv';
		}
		$csv_file=$file_storage_path .'uploads/advanced_search_export/'.$file_name;
		if (!file_exists($file_storage_path .'uploads/advanced_search_export/'.$file_name))
		{
			$path = 'public/uploads/advanced_search_export';
			if (!Storage::exists($path)) 
			{
                $create_dir = Storage::makeDirectory($path);
            }
	 	}
		$file = fopen(storage_path().$csv_file,'w');
		header("Content-type: application/octet-stream");
		header("Content-Disposition: attachment; filename=\"$csv_file\"");
		header("Pragma: no-cache");
		header("Expires: 0");
		if($type == 'article')
		{
			$headers = array('Article Code','Article Title','Article type','Flow Status','Assigned To','Assigned Date','Accepted Date','Completed Date','Due Date','Last Export Date');
			fputcsv($file, $headers);
			$row_space['space']= '';
			if(!empty($csv_details))
			{
				foreach($csv_details['art_stages'] as $out_key => $out_value)
				{
					foreach($out_value as $key => $value)
					{
						$csv_content['art_code'] = $value->art_code;
						$csv_content['art_title'] = $this->unicode_correction_export(strip_tags($value->art_title));
						$csv_content['art_type'] = $value->artp_article_type;
						$csv_content['flow_status'] = $value->formated_stagename.' : '.$value->art_current_status;
						$csv_content['assigned_to'] = (isset($value->assigned_user) && isset($value->assigned_user['fullname'])) ? $value->assigned_user['fullname']: '';
						$csv_content['assigned_date'] = $value->aflw_assigned_date;
						$csv_content['accepted_date'] = $value->aflw_accepted_date;
						$csv_content['completed_date'] = $value->aflw_returned_date;
						$csv_content['due_date'] = !in_array($value->aflw_status, array('c','d')) ? $value->aflw_due_date : '' ;
						$csv_content['last_export'] = $value->export == TRUE ? $value->export_date :'';
						fputcsv($file, $csv_content);
					}
					fputcsv($file,$row_space);
				}
			}
		}
		else
		{
			$headers = array('User name','User email','User keywords','Article Type - Roles');
			fputcsv($file, $headers);
			foreach($csv_details as $value)
			{	
				$csv_content['user_name'] = $value->display_name['fullname'];
				$csv_content['usr_email'] = $value->usr_email;
				$csv_content['user_keywords'] = $this->unicode_correction_export(strip_tags($value->user_keywords));
				$csv_content['usr_articletype_rolelist'] = $this->unicode_correction_export(strip_tags($value->usr_articletype_rolelist));
				fputcsv($file, $csv_content);
			}
		}
		fclose($file);
		return $file_name;
	}

	public function download_export_file($file_data)
	{
		try
		{
			$post_data = json_decode($file_data);
			// $file_name = 'advanced_search_'.$post_data->file_path.'_'.$post_data->jnl_code. '.csv';
			$file_name = $post_data->file_path;
			// $filepath=$this->upload_folder_path("uploads/advanced_search_export/".$file_name);
			//commited for muneer chettan	
			$filepath = storage_path().'/app/public/uploads/advanced_search_export/'.$file_name;
			if(file_exists($filepath))
			{
				return Response::download($filepath);
			}
			else
			{
				$this->warning('Failed',500,'file not exist');
			}
			
		}
		catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}

}