<?php

namespace App\Http\Controllers;

use App\Models\Article_flow_alternativereviewer_priorityorder;
use App\Models\Article_reviewers;
use App\Models\Article_versions_reviewers;
use App\Models\Generic_flows;
use App\Models\User_articles;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\JournalUserfunctionTrait;
use App\Http\Traits\RolesConfigTrait;
use Illuminate\Support\Str;
use Config;
use DB;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Blind_user_articles;
use App\Models\Authors;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\ReviewerListTrait;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\GeneralEmailTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\WorkflowAssignmentTypeTrait;

use App\Models\Article_classification;
use App\Models\Article_publons;
use App\Models\Reviewed_privilaged_users;
use App\Models\User;
use App\Http\Traits\ReviewerConnectTrait;

use App\Http\Controllers\NotificationController;
use Exception;
use DateTime;
use \stdClass;

class Manage_Search_Reviewer_Api extends Controller
{
    use StagemovementTrait;
    use RolesConfigTrait;
    use JournalUserfunctionTrait;
    use ReviewerListTrait;
    use GeneralEmailTrait;
    use SendGlobalEmailFunctionTrait;
    use WorkflowTrait;
    use WorkflowAssignmentTypeTrait;
    use ReviewerConnectTrait;
    public $current_user;
public function index(Request $request)
{
    try
    {
        $User=new \App\Models\User();
        $Reviewed_privilaged_users = new \App\Models\Reviewed_privilaged_users;
        $Blind_user_articles=new \App\Models\Blind_user_articles;
        $this->current_user = $this->get_current_user_details();
        $post_data=$request->all();
        $filter_data = $this->manage_search_filters($post_data['search_data']);
        $validator = Validator::make($request->all(), [
			'jwf_id' => 'required',
		    'article_id'=>'required',
			'jnl_id'=>'required'
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
        $jwf_id=$post_data['jwf_id'];
        $article_id=$post_data['article_id'];
        $parent_flow_id=$post_data['parent_flow_id'];
        $jnl_id=$post_data['jnl_id'];
        $search_filters=array();
        $array_data['search_filters']=$search_filters;

    $array_data['jnl_id']=$jnl_id;
    $array_data['filter_arr']=$search_filters;
    $document_module = false;
    if (isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y')
    {
        $document_module = true;
    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    $master_record =Article_flow::get_single_record('aflw_id,aflw_stage_max_users,aflw_jwf_id',"aflw_id= ?",binding_arr:[$parent_flow_id]);
    $active_parent_stage = isset($post_data['active_parent_stage']) ? $post_data['active_parent_stage']: '';
    $destination_stage_id = isset($post_data['destination_stage_id']) ? decrypt_link($post_data['destination_stage_id']) : '';
    $pool_id = isset($post_data['pool_id']) ? decrypt_link($post_data['pool_id']) : '';
    if(!empty($destination_stage_id) && $active_parent_stage == 'prereview')
    {
        $article_flow_users =Article_flow::get_all_records('aflw_usr_id',"aflw_art_id= ? AND aflw_jwf_id= ? AND aflw_assignment_type_id IS NOT null ",binding_arr:[$article_id,$destination_stage_id]);
        $declined_users = Article_flow::get_single_record('count(aflw_id) as count',"aflw_art_id= ? AND aflw_jwf_id= ? AND aflw_assignment_type_id = ? AND aflw_status='d'",binding_arr:[$article_id,$destination_stage_id,$pool_id]);
        $allocated_usrs =Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt',"aflw_art_id= ? AND aflw_jwf_id= ?  AND aflw_assignment_type_id = ?",binding_arr:[$article_id,$destination_stage_id,$pool_id]);
        $decline_count=$declined_users->count;
        $allocated_user_count=$allocated_usrs->cnt;
    }
    else
    {
        $declined_users = Article_flow::get_single_record('count(aflw_id) as count',"aflw_parent_flow_id= ? AND aflw_status='d'",binding_arr:[$parent_flow_id]);
        $allocated_usrs =Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt',"aflw_parent_flow_id= ? ",binding_arr:[$parent_flow_id]);
        $decline_count=$declined_users->count;
        $allocated_user_count=$allocated_usrs->cnt;
        $article_flow_users =Article_flow::get_all_records('aflw_usr_id',"aflw_art_id= ? AND aflw_jwf_id= ?",binding_arr:[$article_id,$jwf_id]);
    }
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */


    $exclude_users = array();
     if ($this->current_client->functionality->cfty_self_assignment == 'n')
	{
	$exclude_users[] = $this->current_user['user_id'];
	}
    if (!empty($article_flow_users))
	{
        
	$aflw_usrs = $this->get_column_array($article_flow_users, 'aflw_usr_id');
	$exclude_users = array_merge($exclude_users, $aflw_usrs);
    }
    $article_authors =Authors::get_all_records('auth_usr_id',"auth_art_id= ?",binding_arr:[$article_id]);
    $auth_usrs = $this->get_column_array($article_authors, 'auth_usr_id');
    if($document_module !== true)
    {
    $exclude_users = array_merge($exclude_users, $auth_usrs);
    }
    else
    {
     $user_author=implode(',',$auth_usrs);
    }


    			/* Exclude reviewed privilaged user if they perform any task after the review stage. */
			
                $article_details =Articles::get_single_record('art_pre_all_ids,art_artp_id',"art_id=?",binding_arr:[$article_id]);
				$art_ids = array();
				$art_ids = ($article_details->art_pre_all_ids != null) ? $article_details->art_pre_all_ids : '';
				$art_ids = ($art_ids != '') ? $art_ids . ',' . $article_id : $article_id;

				$reviewd_privilaged = array();
				if ($art_ids != null)
				{
					$reviewd_privilaged = $Reviewed_privilaged_users::get_all_records('rvp_usr_id', 'rvp_art_id in(' . $art_ids . ')');
				}

				$exclude_privilaged = array();
				if (!empty($reviewd_privilaged))
				{
					foreach ($reviewd_privilaged as $rev)
					{
						$exclude_privilaged[] = $rev->rvp_usr_id;
					}
				}
				$exclude_users = array_merge($exclude_users, $exclude_privilaged);
		

			$exclude_users = (!empty($exclude_users)) ? array_unique(array_filter($exclude_users)) : array();
            $where_cnd = '"sudo" IN(REPLACE(REPLACE(REPLACE(usr_roles,\'"\',""),"]",""),"[",""))';
			$sudo_users =$User::get_single_record('group_concat(usr_id) as sudo_users', $where_cnd);
			if ($sudo_users->sudo_users != '')
			{
				$sudo_user_arr = explode(',', $sudo_users->sudo_users);
				$exclude_users = array_merge($exclude_users, $sudo_user_arr);
			}

			$exclude_users = (!empty($exclude_users)) ? array_unique($exclude_users) : array();


            $blinded_usr_records = $Blind_user_articles::get_single_record('bau_usr_ids','bau_art_id = ?',binding_arr:[$article_id]);
			if(isset($blinded_usr_records->bau_usr_ids)){
				$blinded_usr_ids = json_decode($blinded_usr_records->bau_usr_ids);
				$exclude_users = array_merge($exclude_users, $blinded_usr_ids);
            }
            $orderby = '';
            if(isset($post_data['search_data']['sort_field']))
            {
                $colmncnt = $post_data['search_data']['sort_field'] == 'user_fullname' ? 'name':$post_data['search_data']['sort_field'];
                $columnorder = $post_data['search_data']['sort_value'];
                $orderby = array($colmncnt,$columnorder);

            }
            else
            {
                $orderby=array('last_invitation_date','asc');
            }
            // TASK #8785 When the client functionality reviewer_search_option_surname is enabled, a TypeError occurs while searching for reviewers using surnames
            $default_sort_conf = 'clients.' . $this->current_client->clnt_client_code . '.reviewer_search_default_filters';
            $default_sort_config = Config::get($default_sort_conf);
            $filter_optn = '';
			if ($this->current_client->functionality->cfty_reviewer_search_option_surname == "y")
			{
				$filter_optn = $default_sort_config['reviewer_filters'];
			}
            $order_by_condition = '';
            $ordering_column = '';
            if(isset($filter_data['keyword_filter']['has_profile_keywords']['OR']))
            {
                	// TASK #6273 remove desc
                $order_by_condition .="keyword_table.keyword_order DESC,";
            }
            if (!empty($orderby) && isset($orderby[1]))
            {
                if ($filter_optn == "user_surname" && $orderby[0] == "name")
                {
                    $order_by_condition .= '  TRIM(usr_last_name)  ' . $orderby[1];
                }
                elseif ($orderby[0] == "name")
                {
                    $order_by_condition .= '  TRIM(usr_first_name) ' . $orderby[1];
                }
                elseif ($orderby[0] == "last_invitation_date")
                {

                    $ordering_column = $orderby[0];
                     // TASK #6273
                    $order_by_condition .= '  DATE(' . $orderby[0] . ') ' . $orderby[1]. ' , usr_id asc' ;
                }
                elseif($orderby[0] == "rating")
                {
                    $ordering_column = $orderby[0];
                    // TASK #6273
                    $order_by_condition .= '  '.$orderby[0].' '.$orderby[1]. ' , usr_id asc' ;
                }
                else
                {
                    $ordering_column = $orderby[0];
                    $order_by_condition .= ' ' . $orderby[0] . ' ' . $orderby[1];
                }
            }
            else
            {
                $order_by_condition .= '  usr_id asc';
            }
            if($document_module === true &&(!empty($auth_usrs)))
			{
				$order_by_condition='FIELD(usr_id,'.$user_author.') DESC ,'.$order_by_condition;
			}
			else
			{
				$order_by_condition=' '.$order_by_condition;
            }
            $array_data['five_star'] = $this->current_client->functionality->cfty_fivestar_review_rating == 'y' ? true : false;
            $select = 'usr_id,usr_first_name,usr_middle_name,usr_last_name';
            /*Task #1893 ReView: Reviewer filtering and sorting (basecamp issue)*/
            if($ordering_column == 'rating' && $array_data['five_star'] === true)
            {
                $select .= ',IF(review_rating_table1.five_star IS NULL,review_rating_table.rating,review_rating_table1.five_star) AS rating';
            }
            elseif($ordering_column == 'rating' || isset($filter_data['review_rating_filter']))
            {
                $select .= ',review_rating_table.rating AS rating';
            }
            $return_array=array();
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            $Generic_flows=new \App\Models\Generic_flows;
            $master_jwf_id = $master_record->aflw_jwf_id;
            $master_flow_details = $Generic_flows::get_single_record('jwf_fwm_id,jwf_stage_type',"jwf_id={$master_jwf_id}");

            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            $array_data['select']=$select;
            $array_data['exclude_users']=$exclude_users;
            $array_data['search_filters'] = $filter_data;
            $array_data['order_by_condition'] = $order_by_condition;
            $array_data['ordering_column'] = $ordering_column;
            $array_data['page_limit'] = isset($post_data['per_page']) ? $post_data['per_page'] : 10;
            $return_array=array();
            $result_data=$User::get_user_data_global($array_data);
            if($master_flow_details->jwf_stage_type == 'review')
            {
            $return_array['maximum_reviewer']=$master_record->aflw_stage_max_users;
            }
            else
            {
            $workflow_id = $master_record->aflw_jwf_id;
            $pool_min_max_count = $this->get_min_max_count_pre_review_stage($pool_id, $master_record->aflw_id, $workflow_id,$destination_stage_id);
            $return_array['maximum_reviewer']= $pool_min_max_count->max_user;
            }
            $return_array['no_allocate_user']=$allocated_user_count-$decline_count;
            $return_array['data_result']=$this->format_reviewer_search($result_data,$filter_data,$post_data,$document_module);
         return  $this->success('Success', 200, $return_array);

    }
	catch(\Exception $e)
	{
		return  $this->failure('Failed',500,$e);
	}

}

public function batch_paper_assignment_reviewer_list(Request $request)
{
try
{
$post_data=$request->all();
$order_by_condition='';
$ordering_column = '';
$User=new \App\Models\User();
$this->current_user = $this->get_current_user_details();
$filter_data = $this->manage_search_filters($post_data['search_data']);
$exclude_users = array();
if ($this->current_client->functionality->cfty_self_assignment == 'n')
{
$exclude_users[] = $this->current_user['user_id'];
}
$exclude_users = (!empty($exclude_users)) ? array_unique(array_filter($exclude_users)) : array();
$where_cnd = '"sudo" IN(REPLACE(REPLACE(REPLACE(usr_roles,\'"\',""),"]",""),"[",""))';
$sudo_users =$User::get_single_record('group_concat(usr_id) as sudo_users', $where_cnd);
if ($sudo_users->sudo_users != '')
{
    $sudo_user_arr = explode(',', $sudo_users->sudo_users);
    $exclude_users = array_merge($exclude_users, $sudo_user_arr);
}
if ($this->current_client->functionality->cfty_self_assignment == 'n')
{
$exclude_users[] = $this->current_user['user_id'];
}
$exclude_users = (!empty($exclude_users)) ? array_unique($exclude_users) : array();
if(isset($post_data['search_data']['sort_field']))
{
    $colmncnt = $post_data['search_data']['sort_field'] == 'user_fullname' ? 'name':$post_data['search_data']['sort_field'];
    $columnorder = $post_data['search_data']['sort_value'];
    $orderby = array($colmncnt,$columnorder);

}
else
{
    $orderby=array('usr_id','asc');
}
if(isset($filter_data['keyword_filter']['has_profile_keywords']['OR']))
{
    $order_by_condition .="keyword_table.keyword_order DESC,";
}
// reviewer_search_default_filters && Sonarq bug fix
$clientCode = $this->current_client->clnt_client_code;
$default_sort_conf = 'clients.' . $clientCode . '.reviewer_search_default_filters';
$default_sort_config = Config::get($default_sort_conf);
$filter_optn = '';
if ($this->current_client->functionality->cfty_reviewer_search_option_surname == "y") {
    $filter_optn = $default_sort_config['reviewer_filters']; //last_name sort
}
if (!empty($orderby) && isset($orderby[1]))
{
    if ($filter_optn == "user_surname" && $orderby[0] == "name")
    {
        $order_by_condition .= '  TRIM(usr_last_name)  ' . $orderby[1];
    }
    elseif ($orderby[0] == "name")
    {
        $order_by_condition .= '  TRIM(usr_first_name) ' . $orderby[1];
    }
    elseif ($orderby[0] == "last_invitation_date")
    {

        $ordering_column = $orderby[0];
        $order_by_condition .= '  DATE(' . $orderby[0] . ') ' . $orderby[1];
    }
    elseif($orderby[0] == "rating")
    {
        $ordering_column = $orderby[0];
        $order_by_condition .= '  '.$orderby[0].' '.$orderby[1];
    }
    else
    {
        $ordering_column = $orderby[0];
        $order_by_condition .= ' ' . $orderby[0] . ' ' . $orderby[1];
    }
}
else
{
    $order_by_condition .= '  usr_id asc';
}

$array_data['search_filters'] = $filter_data;
$array_data['order_by_condition'] = $order_by_condition;
$array_data['ordering_column'] = $ordering_column;
$array_data['exclude_users']=$exclude_users;
$array_data['page_limit'] = isset($post_data['per_page']) ? $post_data['per_page'] : 10;
$array_data['five_star'] = $this->current_client->functionality->cfty_fivestar_review_rating == 'y' ? true : false;
$array_data['user_status'] = isset($post_data['include_awaiting']) && $post_data['include_awaiting'] ? ['a', 'w'] : ['a'];
$return_array=array();
DB::enableQueryLog();
$result_data=$User::get_user_data_global($array_data);
$post_data['jnl_id']=Rv_decrypt($post_data['jnl_id']);
$return_array['data_result']=$this->format_reviewer_search($result_data,$filter_data,$post_data,false);
return  $this->success('Success', 200, $return_array);

}
catch(\Exception $e)
{
    return  $this->failure('Failed',500,$e);
}
}

public function invite_stage_assigned_users(Request $request)
{
    try
    {
    $post_data = $request->all();

    $validator = Validator::make($request->all(), [
        'article_id'=>'required',
        'jnl_id'=>'required'
    ]);
    if($validator->fails())
    {
        return  $this->failure('Failed',422,$validator->errors());
    }
    $this->current_user=$this->get_current_user_details();
    $user_data = $this->get_current_user_details();
    $Article_flow=new \App\Models\Article_flow;
    $Articles=new \App\Models\Articles;
    $Article_reviewers=new \App\Models\Article_reviewers;
    $Roles=new \App\Models\Roles;
    $User=new \App\Models\User;
    $Stage_email_templates=new \App\Models\Stage_email_templates;
    $User_to_journals=new \App\Models\User_to_journals;
    $Article_notification_emails=new \App\Models\Article_notification_emails;
    $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder;

        $document_module = false;
        if (isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y')
        {
            $document_module = true;
        }
    $exclude_template_id = '';// used to keep the template id to keep in our database and the all other template ids are removed from the article notification table
    $current_stage_id = $this->decrypt_data($post_data['current_status_id']);
    $user_ids = explode(',', $post_data['user_ids']);
	$jnl_id=$this->decrypt_data($post_data['jnl_id']);
    $jnl_code=$post_data['jnl_code'];
    $core_role=$post_data['core_role'];
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    $articleid = $this->decrypt_data($post_data['article_id']);
    $pool_id = $this->decrypt_data($post_data['pool_id']);
    $destination_stage_id = isset($post_data['destination_stage_id']) ? $this->decrypt_data($post_data['destination_stage_id']) : '';   /* TASK #3044, Ability for AEs to shortlist reviewers during Pre-Review -> invitation mail api issue fix */
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
    $input_arr = array(
        'input' =>$current_stage_id,
        'type'=> 'number'
    );

     $flow_id_validate = $this->Rv_validator($input_arr);

    $input_arr = array(
        'input' =>$jnl_id,
        'type'=> 'number'
    );

    $jnl_id_validate = $this->Rv_validator($input_arr);

    $re_invite_users = $re_reviewer_ids = array();
    $status = null;
    $invitation_send = false;
    $current_aflw_id = '';
    $rv_cnt = 0;
    /* 1 loop through $user_ids */

    $post_stage_cust_cc=isset($post_data['postdata']['stage_cust_cc'])?$post_data['postdata']['stage_cust_cc']:'';
    $post_stage_cust_bcc=isset($post_data['postdata']['stage_cust_bcc'])?$post_data['postdata']['stage_cust_bcc']:'';

    $artp_code = (new Articles())->with('article_types')->findOrFail($articleid)?->article_types?->artp_abbr_article_type;

    //get current stage details
    /*
    $articleflowtable = (new \App\Models\Article_flow())->getTable();
    $genericflowtable = (new \App\Models\Generic_flows())->getTable();
    $articlestable = (new \App\Models\Articles())->getTable();
    $roles_table = (new \App\Models\Roles())->getTable();
    $tables = array(
        'main_table' => $articleflowtable,
        'join_table' => array(
            $articlestable => array('aflw_art_id','art_id'),
            $genericflowtable => array('aflw_jwf_id','jwf_id'),
            $roles_table => array('jwf_role_id','role_id')
    ));
    $select = 'jwf_stage_type,role_assigned_role,art_pre_all_ids';
    $curStagecnd = ' aflw_id = '.$current_stage_id;
    $curStageDetails = Article_flow::get_results_using_joins($tables, $select, $curStagecnd,'single');
    */
    foreach ($user_ids as $user_id)
    {
        //#122  The article is not listed for the privileged user after it is rescinded
        $addreviewVersion = false;

        $article_reviewer_data = array();
        $user_id = $this->decrypt_data($user_id);
        $input_arr = array(
            'input' =>$user_id,
            'type'=> 'number'
        );
        $user_id_validate = $this->Rv_validator($input_arr);

        if($flow_id_validate === false || $jnl_id_validate === false || $user_id_validate === false)
        {

         $arraymsg['mesage'] = customTrans('validation.notvalid');


        }
        $each_user_detail =  $User::get_single_record('usr_deeplink_token',"usr_id={$user_id} AND usr_status='w'");
     
            if (!empty($each_user_detail->usr_deeplink_token))
            {
                 $aflw_deeplink_token = $each_user_detail->usr_deeplink_token;
            }
            else
            {
                $aflw_deeplink_token = Str::random(20);
            }
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
        $active_parent_stage = isset($post_data['active_parent_stage']) ? $post_data['active_parent_stage']: '';
        if($active_parent_stage != 'prereview')
        {
            $current_flow = $Article_flow::get_single_record('aflw_parent_flow_id',"aflw_id={$current_stage_id}");
            $current_stage_id = ($current_flow->aflw_parent_flow_id != null) ? $current_flow->aflw_parent_flow_id : $current_stage_id;
        }
        $decline_where = "aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND  aflw_status IN('g','d')";
        $condition="aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id}";
        if($active_parent_stage == 'prereview' && !empty($pool_id) && !empty($destination_stage_id))
        {
            $decline_where = "aflw_usr_id={$user_id} AND aflw_art_id={$articleid} AND aflw_assignment_type_id = {$pool_id} AND aflw_jwf_id = {$destination_stage_id} AND aflw_status IN('g','d')";
            $condition="aflw_usr_id={$user_id} AND aflw_art_id={$articleid} AND aflw_assignment_type_id = {$pool_id} AND aflw_jwf_id = {$destination_stage_id}";
        }
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */

        $current_aflw_id_rec = $Article_flow::get_single_record('max(aflw_id) as aflw_id', $condition
        );

        $current_aflw_id = $current_aflw_id_rec->aflw_id;


        $data['aflw_status'] = 'i';


        /* 1.1 get users who previously declined invititation
         *     in the current flow */
         /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
        $decline_data = $Article_flow::get_single_record('*',$decline_where);
        $today = date('Y-m-d H:i:s', time());
        $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
        $article_details = $Articles::get_article_details($select,"aflw_id={$current_aflw_id}");

        $article_details = $article_details[0];
        $article_id = $article_details->art_id;


        //unlist the alternate reviewers, if the reviewer is invited manually.

        if(isset($current_stage_id))
        {
            $alt_rver = $Article_flow_alternativereviewer_priorityorder::get_all_records('afap_id,afap_aflw_id,afap_usr_id,afap_number',"afap_art_id={$article_id} AND afap_parent_flow_id={$current_stage_id}",'afap_number',null,null,null,null,'asc');
            if(isset($alt_rver) && !empty($alt_rver))
            {
                $alt_revr_detected = false;
                foreach($alt_rver as $each_rver)
                {
                    if($each_rver->afap_usr_id == $user_id)
                    {

                        $alt_criteria="afap_parent_flow_id={$current_stage_id} AND afap_aflw_id={$current_aflw_id} AND afap_usr_id={$user_id} AND afap_art_id={$article_id}";
                        $Article_flow_alternativereviewer_priorityorder::delete_records($alt_criteria, '', $this->current_user);
                        $alt_revr_detected = true;
                    }
                    if($alt_revr_detected === true && $each_rver->afap_usr_id != $user_id)
                    {
                        $del_criteria="afap_parent_flow_id={$current_stage_id} AND afap_aflw_id={$each_rver->afap_aflw_id} AND afap_usr_id={$each_rver->afap_usr_id} AND afap_art_id={$article_id}";
                        $alt_data = array(
                            'afap_number' => $each_rver->afap_number-1
                        );
                        $Article_flow_alternativereviewer_priorityorder::update_record($alt_data, $del_criteria);
                    }
                }
            }
        }
 
        $data['aflw_due_date'] = $this->get_due_date_for_article($article_id, $article_details->jwf_tat_accept);

        /* start --- Add code block for sending invitation email to inviting reviewers */

        $template = null;
        if (isset($post_data['invite_tmpl_name']) && $post_data['invite_tmpl_name'] != null)
        {
            $invite_tmpl_id = $this->decrypt_data($post_data['invite_tmpl_name']);
            $exclude_template_id = $invite_tmpl_id;


            $template = $Stage_email_templates::get_single_record('*, stage_etmp_content AS stage_etmp_email_template',"stage_etmp_id={$invite_tmpl_id} AND stage_etmp_action='assigned'");
        }

        if ($template != null)
        {

            /* 1.1.1 if $decline_data found */
            if (!empty($decline_data))
            {

                $invite_user_data = $Article_flow::get_single_record('*',"aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_status='u'");

                // Check uninvite user  record already exist
                if (!empty($invite_user_data))
                {
                    $invite_condition ="aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_status='u'";



                    $flow = $Article_flow::get_single_record('aflw_deeplink_token', $invite_condition);

                    $aflw_deeplink_token = ($flow->aflw_deeplink_token != '' ) ? $flow->aflw_deeplink_token : $aflw_deeplink_token;
                    $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                    $data['aflw_assigned_date'] = $today;
                    /* 1.1.2 else ,update status row in article flow table  */
                    $status = $Article_flow::update_record($data, $invite_condition, $user_data);
                    if($status)
                    {
                        $addreviewVersion = true;
                    }
                    /* if the suggested user is not have reviewer role in journal or article type then add role-- start */
                    $is_sugst_usr = $Article_reviewers::get_single_record('sorw_id',"sorw_suggested_reviewer_id={$user_id} AND sorw_action='s' AND sorw_aflw_id={$current_aflw_id}");

                    if ($is_sugst_usr !== null)
                    {
                        $revw_role_id = $article_details->jwf_role_id;
                        $user_role_details ="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND  usrj_artp_id IS null";


                        $jnl_reviewr_record = $User_to_journals::get_single_record('usrj_id', $user_role_details);

                        if ($jnl_reviewr_record == null)
                        {
                            $user_role_details_insert = array(
								'usrj_jnl_id' => $jnl_id,
								'usrj_usr_id' => $user_id,
								'usrj_role_id' => $revw_role_id,
								'usrj_artp_id' => null,
							);
                            $user_role_details_insert['usrj_invite'] = 'n';
                            $User_to_journals::insert_record($user_role_details_insert, $user_data);
                        }
                        //user as article type reviewer
                        $user_role_details.= " AND usrj_artp_id={$article_details->art_artp_id}";
                        $art_reviewr_record = $User_to_journals::get_single_record('usrj_id', $user_role_details);

                        if ($art_reviewr_record == null)
                        {
                            $user_role_details_insert['usrj_artp_id'] =$article_details->art_artp_id;
                            $user_role_details_insert['usrj_invite'] = 'n';
                            $User_to_journals::insert_record($user_role_details_insert, $user_data);
                        }
                    }
                    /* add reviewer role end */
                }
                else
                {
                    $revw_role_id = $article_details->jwf_role_id;

                    $user_role_details ="usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$revw_role_id} AND  usrj_artp_id IS NULL";



                    $user_role_details_insert = array(
                        'usrj_jnl_id' => $jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $revw_role_id,
                        'usrj_artp_id' => null,
                    );
                    $jnl_reviewr_record = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details_insert);

                    if ($jnl_reviewr_record == null&&(empty($jnl_reviewr_record)))
                    {

                        $user_role_details_insert['usrj_invite'] = 'n';
                        $User_to_journals::insert_record($user_role_details_insert, $user_data);


                    }

                    //user as article type reviewer

                    $user_role_details_insert['usrj_artp_id']=$article_details->art_artp_id;

                    $art_reviewr_record = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details_insert);

                    if ($art_reviewr_record == null&&(empty($art_reviewr_record)))
                    {


                        $user_role_details_insert['usrj_invite'] = 'n';

                        $User_to_journals::insert_record($user_role_details_insert, $user_data);
                    }
                    /* 1.1.1.1 use $decline_data array for new invite */
                    $new_invite = array(
                        'aflw_parent_flow_id' => $decline_data->aflw_parent_flow_id,
                        'aflw_art_id' => $decline_data->aflw_art_id,
                        'aflw_jwf_id' => $decline_data->aflw_jwf_id,
                        'aflw_usr_id' => $decline_data->aflw_usr_id,
                        'aflw_assigned_date' => $today,
                        'aflw_due_date' => $data['aflw_due_date'],
                        'aflw_status' => 'i',
                        'aflw_deeplink_token' => $aflw_deeplink_token,
                        'aflw_level' => $decline_data->aflw_level
                    );
                     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                    if($decline_data->aflw_assignment_type_id != 0 && $decline_data->aflw_assignment_type_id != null && $active_parent_stage == 'prereview')
                    {
                        $new_invite['aflw_assignment_type_id']   = $decline_data->aflw_assignment_type_id;
                        $new_invite['aflw_source_assignment_id'] = $decline_data->aflw_source_assignment_id;
                        $new_invite['aflw_parent_flow_id'] = $current_stage_id;
                    }
                     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */

                    /* 1.1.1.2 insert new status row and get newly inserted id */
                    $status = $Article_flow::insert_record($new_invite, $user_data);
                    $article_details->aflw_id = $status;
                    $re_invite_users[$rv_cnt] = $decline_data->aflw_usr_id;
                    $addreviewVersion = true;

                    $previous_suggested_user_id = $Article_reviewers::get_single_record('sorw_suggested_user_id',"sorw_aflw_id={$decline_data->aflw_id}");
                    $article_reviewer_data ['sorw_aflw_id'] = $status;
                    $article_reviewer_data ['sorw_suggested_reviewer_id'] = $user_id;
                    $article_reviewer_data ['sorw_suggested_user_id'] = $previous_suggested_user_id->sorw_suggested_user_id;
                    $article_reviewer_data['sorw_suggested_on'] = $today;
                    $article_reviewer_data['sorw_art_id'] = $decline_data->aflw_art_id;
                    $article_reviewer_data ['sorw_invited_by'] = $this->current_user['user_id'];
                    $article_reviewer_data['sorw_invited_on'] = $today;
                    /* 1.1.1.2 insert article reviewers in Article_reviewers table */
                    $re_reviewer_ids[$rv_cnt]['review'] = $Article_reviewers::insert_record($article_reviewer_data, $this->current_user);
                    $re_reviewer_ids[$rv_cnt]['flow'] = $status;
                    $rv_cnt++;
                }
            }
            else
            {

                $flow = $Article_flow::get_single_record('aflw_deeplink_token', $condition);

                $aflw_deeplink_token = ($flow->aflw_deeplink_token != '' ) ? $flow->aflw_deeplink_token : $aflw_deeplink_token;
                $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                $data['aflw_assigned_date'] = $today;
                /* 1.1.2 else ,update status row in article flow table  */
                $status = $Article_flow::update_record($data, $condition, $user_data);
                if($status)
                {
                    $addreviewVersion = true;
                }
                /* if the suggested user is not have reviewer role in journal or article type then add role-- start */
                $is_sugst_usr = $Article_reviewers::get_single_record('sorw_id',"sorw_suggested_reviewer_id={$user_id} AND sorw_action='s' AND sorw_aflw_id={$current_aflw_id}");
                if ($is_sugst_usr !== null)
                {
                    $revw_role_id = $article_details->jwf_role_id;
          

                    $user_role_details_insert = array(
                        'usrj_jnl_id' => $jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $revw_role_id,
                        'usrj_artp_id' => null,
                    );
                    $jnl_reviewr_record = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details_insert);
                    if ($jnl_reviewr_record == null)
                    {

                        $user_role_details_insert['usrj_invite'] = 'n';
                        $User_to_journals::insert_record($user_role_details_insert, $user_data);
                    }
       
                   $user_role_details_insert['usrj_artp_id'] = $article_details->art_artp_id;
                    $art_reviewr_record = $User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details_insert);
                    if ($art_reviewr_record == null)
                    {
            
                        $user_role_details_insert['usrj_invite'] = 'n';
                        $User_to_journals::insert_record($user_role_details_insert, $user_data);
                    }
                }
                /* add reviewer role end */
            }

            /* 1.2 if no declined users found,update corresponding row in Article_reviewers table */
            if (empty($decline_data))
            {
                $article_reviewer_data ['sorw_invited_by'] = $this->current_user['user_id'];
                $article_reviewer_data ['sorw_invited_on'] = $today;
                $article_reviewer_condition ="sorw_art_id={$article_id} AND sorw_suggested_reviewer_id={$user_id}";
                $Article_reviewers::update_record($article_reviewer_data, $article_reviewer_condition, $this->current_user);
            }

            $reviewer_role = $Roles::get_single_record('role_id',"role_assigned_role='reviewer'");
            $role_id = $reviewer_role->role_id;
            if ($document_module === true)
            {
                $user_role_in_journal = $User_to_journals::get_single_record('count(usrj_id) as count',"usrj_jnl_id={$jnl_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$role_id} AND usrj_artp_id IS null");
                if ($user_role_in_journal != null && $user_role_in_journal->count == 0)
                {
                    $journal_user_data ['usrj_usr_id'] = $user_id;
                    $journal_user_data ['usrj_role_id'] = $role_id;
                    $journal_user_data['usrj_artp_id'] = null;
                    $journal_user_data['usrj_invite'] = 'n';
                    $journal_user_data['usrj_cpy_class_art_type'] = 'n';
                    $journal_user_data['usrj_jnl_id'] = $jnl_id;
                    $User_to_journals::insert_record($journal_user_data, $user_data);
                }
                if (isset($article_details->art_artp_id))
                {
                    $user_role_cnt_in_artp = $User_to_journals::get_single_record('count(usrj_id) as cnt',"usrj_jnl_id={$jnl_id} AND usrj_artp_id={$article_details->art_artp_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$role_id}");
                    if ($user_role_cnt_in_artp != null && $user_role_cnt_in_artp->cnt == 0)
                    {
                        $atp_user_data['usrj_jnl_id']=$jnl_id;
                        $atp_user_data['usrj_artp_id']=$article_details->art_artp_id;
                        $atp_user_data['usrj_usr_id']=$user_id;
                        $atp_user_data['usrj_role_id']=$role_id;
                        $atp_user_data['usrj_invite'] = 'n';
                        $atp_user_data['usrj_cpy_class_art_type'] = 'n';
                        $User_to_journals::insert_record($atp_user_data, $user_data);
                    }
                }
            }

            $res = $User::get_single_record('usr_email, usr_status, usr_deeplink_token',"usr_id={$user_id}");
            if ($res)
            {
                
                if ($res->usr_status == 'w')
                {
                    if (!empty($res->usr_deeplink_token))
                        $aflw_deeplink_token = $res->usr_deeplink_token;
                    else
                    {
                        $User::update_record(array(
                            'usr_deeplink_token' => $aflw_deeplink_token),"usr_id={$user_id}");
                    }
                }
            }

            $attachments = $files_attached = array();
            if (isset($invite_tmpl_id) && $invite_tmpl_id != null) {

                $article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',
                "ane_stage_etmp_id={$invite_tmpl_id} and ane_art_id={$article_id} and ane_aflw_id={$current_stage_id} ");
                if(!empty($article_notification)) {
                    $template->stage_etmp_subject = $article_notification->ane_subject;
                    $template->stage_etmp_content = $article_notification->ane_content;
                    $template->stage_etmp_cc = $article_notification->ane_cc;
                    $template->stage_etmp_bcc = $article_notification->ane_bcc;
                    $template->stage_etmp_cust_cc = $article_notification->ane_cust_cc;
                    $template->stage_etmp_cust_cc = $article_notification->ane_cust_cc;
                    $email_attachments	=	$this->get_invite_email_attachments($article_id,$article_notification->ane_id,false);
                    if(!empty($email_attachments)) {
                        $attachments = $email_attachments['attachments'];
                        $files_attached = $email_attachments['files_attached'];
                    }
                }
			}
            $optccvalue = array();
            if (isset($post_data['postdata']['stage_cust_cc'])&&!empty($post_data['postdata']['stage_cust_cc']) && (in_array('Custom_cc',$post_data['postdata']['stage_template_to_cc'])||in_array('Custom',$post_data['postdata']['stage_template_to_cc']))) {
                $custm_cc = $post_stage_cust_cc;
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($optccvalue, $cust_value);


                }
                $post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);

            }
            else{
                $post_data['postdata']['stage_cust_cc']='';
            }
            $optbccvalue = array();
            if (isset($post_data['postdata']['stage_cust_bcc'])&&!empty($post_data['postdata']['stage_cust_bcc']) && (in_array('Custom_bcc',$post_data['postdata']['stage_template_to_bcc'])||in_array('Custom',$post_data['postdata']['stage_template_to_bcc']))) {
                $custm_bcc = $post_stage_cust_bcc;
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                    array_push($optbccvalue, $cust_bcc_value);

                }
                $post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
            }
            else{
                $post_data['postdata']['stage_cust_bcc']='';
            }
            $custom_data=array(
                'link'=> URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&user_role_id=' . $role_id . '&article_flow_id=' . $article_details->aflw_id),
                'accept_link'=>URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id),
                'reject_link'=>URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code  . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide'),
                );
                if(isset($attachments)){
                    $post_data['postdata']['attachments'] = $attachments;
                    $post_data['postdata']['files_attached'] = $files_attached;
                }
                $replace_button = array('<button contenteditable="false">', '</button>');
            $replaceval = str_replace($replace_button, '##',  $post_data['postdata']['stage_template_content']);
            $post_data['postdata']['stage_template_content'] = $replaceval;
            $email_data=array(
                'type'=>'custom',
                'action'=>'send',
                'email_with_login'=>true,
                'article_id'=>$article_id,
                'user_id'=> $user_id,
                'aflw_id'=>$article_details->aflw_id,//TASK #9401
                'post_data'=>$post_data,
                'aflw_deeplink_token'=>$aflw_deeplink_token,
                'role_id'=>$role_id,
                'template'=> $template,
                'decline_data'=>$decline_data ,
                'custom_data'=>$custom_data,
                'jnl_user_role'=>array(
                    'core_role'=>$core_role,
                    // 'role_name'=>$jnl_array['role_name'],
                    'jnl_id'=> $jnl_id,
                    'jnl_journal_code'=> $jnl_code
                ),
            );
            if($current_aflw_id != ''){
                $art_details["art_id"]=$article_id;
                $art_details["art_user_id"]=$user_id;
                $art_details["art_flow_id"]=$current_aflw_id;
                $art_details["notify_get_type"]='n';
                $data_removed = $this->auto_delete_notification_templates_and_corresponding_attachments($art_details,'notification',$exclude_template_id);
                $return_data['flag'] = $data_removed;
            }
            $this->master_email_details($email_data);

            $invitation_send = true;
        }

        //Here add into reviewer version
        if($addreviewVersion == true)
        {
            $this->mngReviewerversion($articleid,$current_stage_id,$user_id);
        }

       /* if($addreviewVersion == true && isset($curStageDetails->jwf_stage_type) && $curStageDetails->jwf_stage_type == 'review' && $curStageDetails->role_assigned_role == 'reviewer')
        {
            $revier_exist = Article_versions_reviewers::get_single_record('count(artvr_id) as count', "artvr_article_id={$articleid} AND artvr_user_id={$user_id}");
            if ($revier_exist->count == 0) 
            {
                
                $criteria_revwr = "artvr_article_id={$articleid} AND artvr_user_id={$user_id}";
                Article_versions_reviewers::delete_records($criteria_revwr, '', $this->current_user);
                 
                $reviwers_details = array(
                    'artvr_user_id' => $user_id,
                    'artvr_article_id' => $articleid,
                    'artvr_previous_art_ids' => $curStageDetails->art_pre_all_ids
                );
                Article_versions_reviewers::insert_record($reviwers_details, $this->current_user);
            }
        }*/

    }

    /* TASK #3044, Ability for AEs to shortlist reviewers during Pre-Review -> invitation mail api issue fix  Start*/
    $invited_user_cond = "aflw_parent_flow_id={$current_stage_id} AND aflw_status='u'";
    if(!empty($destination_stage_id)){
        $invited_user_cond .= " AND aflw_jwf_id = {$destination_stage_id}";
    }
    $invited_usrs = $Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt',$invited_user_cond );
    /* TASK #3044, Ability for AEs to shortlist reviewers during Pre-Review -> invitation mail api issue fix  End*/
    $return_data['invite_complete'] = false;
    if ($invited_usrs->cnt == 0)
    {
        $return_data['invite_complete'] = true;
    }
    if ($invitation_send === true)
    {
        $return_data['alloc_users_cnt'] = 0;
        $return_data['stage_alloc_usr'] = '';

     }

    else
    {
        $return_data['status'] = 'tmpl_err';
        $return_data['msg'] ='You have not defined any email templates';
    }

    /**
     * Task #7473 Live push notification Save in Mongo db and list data
     */
    $user_id_list=array_map('decrypt_link', $user_ids);
    $broadcast_data=array('user_id_array'=>$user_id_list,'noti_posted_by'=>$this->current_user['user_id'],'article_id'=>$article_id,'noti_type'=>'reviewer_invitation','','noti_flow_id'=>$current_aflw_id,'noti_role_id'=>$role_id,'jnl_code'=>$jnl_code,'jnl_journal_code'=>$jnl_code,'art_type_code'=>$artp_code,'art_type_id'=>$article_details->art_artp_id);
    (new NotificationController)->save_notification_data($broadcast_data);
 /**,
  * Task End  #7473 Live push notification
  */

    return  $this->success('Success', 201, $return_data);
}
catch(\Exception $e)
{
    return  $this->failure('Failed',500,$e);
}

}

public function send_uninvitation(Request $request)
{
    try
    {
		$post_data = $request->all();

	    $validator = Validator::make($request->all(), [
            'current_status_id'=>'required',
            'user_ids'=>'required'
        ]);
        if($validator->fails())
        {
            return  $this->failure('Failed',422,$validator->errors());
        }
        $this->current_user=$this->get_current_user_details();
		$current_stage_id = $this->decrypt_data($post_data['current_status_id']);
		$user_ids = explode(',', $post_data['user_ids']);

        $optccvalue = array();
        if (isset($post_data['postdata']['stage_cust_cc'])&&!empty($post_data['postdata']['stage_cust_cc']) && (in_array('Custom_cc',$post_data['postdata']['stage_template_to_cc'])||in_array('Custom',$post_data['postdata']['stage_template_to_cc']))) {
                        $custm_cc = $post_data['postdata']['stage_cust_cc'];
            for ($i = 0; $i < count($custm_cc); $i++) {
                $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                $cust_value = str_replace('\\', '"', $cust_value);
                $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                array_push($optccvalue, $cust_value);


            }
            $post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);

        }
        else{
            $post_data['postdata']['stage_cust_cc']='';
        }
        $optbccvalue = array();
            if (isset($post_data['postdata']['stage_cust_bcc'])&&!empty($post_data['postdata']['stage_cust_bcc']) && (in_array('Custom_bcc',$post_data['postdata']['stage_template_to_bcc'])||in_array('Custom',$post_data['postdata']['stage_template_to_bcc']))) {
            $custm_bcc = $post_data['postdata']['stage_cust_bcc'];
            for ($i = 0; $i < count($custm_bcc); $i++) {
                $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                array_push($optbccvalue, $cust_bcc_value);

            }
            $post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
        }
        else{
            $post_data['postdata']['stage_cust_bcc']='';
        }
        $replace_button = array('<button contenteditable="false">', '</button>');
        $post_data['postdata']['stage_template_content'] = str_replace($replace_button, '##', $post_data['postdata']['stage_template_content']);
		$return_data=array();
        $Article_flow=new \App\Models\Article_flow;
        $Articles=new \App\Models\Articles;
        $Article_reviewers=new \App\Models\Article_reviewers;
        $Stage_email_templates=new \App\Models\Stage_email_templates;
		foreach ($user_ids as $user_id)
		{
			$user_id=decrypt_link($user_id);
			$template = null;
			if (isset($post_data['invite_tmpl_name']) && $post_data['invite_tmpl_name'] != null)
			{
				$invite_tmpl_id = $this->decrypt_data($post_data['invite_tmpl_name']);

				$tmpl_condition ="stage_etmp_id={$invite_tmpl_id} AND stage_etmp_action='uninvite_user'";
				$template = $Stage_email_templates::get_single_record('*, stage_etmp_content AS stage_etmp_email_template', $tmpl_condition);
			}
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            $active_parent_stage = isset($post_data['active_parent_stage']) ? $post_data['active_parent_stage']: '';
            $destination_stage_id = isset($post_data['destination_stage_id']) ? decrypt_link($post_data['destination_stage_id']) : '';
            $pool_id = isset($post_data['pool_id']) ? decrypt_link($post_data['pool_id']) : '';
            if($active_parent_stage == 'prereview')
            {
                $where = "aflw_usr_id={$user_id} AND aflw_assignment_type_id ={$pool_id} AND aflw_jwf_id = {$destination_stage_id} AND aflw_status='i'";
            }
            else
            {
                $where = "aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_status='i'";
            }
			$invite_user_data = $Article_flow::get_single_record('*',$where);
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */


			if (!empty($invite_user_data))
			{
				$up_flw_id = $invite_user_data->aflw_id;
				$update_result = $Article_flow::update_record(array(
					'aflw_status' => 'u',
					'aflw_deeplink_token' => null,
                    'aflw_accept_clk_count' => 0,
                    'aflw_decline_clk_count' => 0,
					'aflw_due_date' => null),"aflw_id={$up_flw_id}", $this->current_user);

				$Article_reviewers::update_record(array(
					'sorw_invited_by' => null,
					'sorw_invited_on' => null),"sorw_aflw_id={$up_flw_id}", $this->current_user);
                $Article_user_alternativereviewer_priorityorder=new \App\Models\Article_user_alternativereviewer_priorityorder;
                $condition ="auap_parent_flow_id={$current_stage_id}
                AND auap_usr_id={$user_id}";
                $Article_user_alternativereviewer_priorityorder::delete_records($condition);

				$select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                 $article_details = $Articles::get_article_details($select,"aflw_id={$up_flw_id}");

                $article_details = $article_details[0];
                $article_id = $article_details->art_id;
                if (!empty($update_result))
                {
                    //#122  The article is not listed for the privileged user after it is rescinded
                    //Here remove that user from reviewer version table
                    $this->mngReviewerversion($article_id,$current_stage_id,$user_id,false);

                    $return_data['status'] = 'success';
                }
                $email_data=array(
                    'type'=>'custom',
                    'action'=>'send',
                    'email_with_login'=>true,
                    'article_id'=>$article_id,
                    'user_id'=> $user_id,
                    'aflw_id'=>$up_flw_id,
                    'post_data'=>$post_data,
                    'template'=> $template
                );
              $this->master_email_details($email_data);

			}
		}
          /**
     * Task #7473 Live push notification Save in Mongo db and list data
     */
    $user_id_list=array_map('decrypt_link', $user_ids);
    $art_jnl_code = (new Articles())->with('journals')->find($article_id)->journals->jnl_journal_code;
    $artp_code = (new Articles())->with('article_types')->findOrFail($article_id)?->article_types?->artp_abbr_article_type;

    $broadcast_data=array('user_id_array'=>$user_id_list,'noti_posted_by'=>$this->current_user['user_id'],'article_id'=>$article_id,'noti_type'=>'reviewer_uninvitation','','jnl_code'=>$art_jnl_code,'jnl_journal_code'=>$art_jnl_code,'art_type_code'=>$artp_code,'art_type_id'=>$article_details->art_artp_id);
    (new NotificationController)->save_notification_data($broadcast_data);
 /**
  * Task End  #7473 Live push notification
  */
        return  $this->success('Success', 201, $return_data);
    }
    catch(\Exception $e)
{

    return  $this->failure('Failed',500,$e);
}

	}

    public function delete_stage_assigned_users(Request $request)
	{
        try
        {
		$post_data = $request->all();
		$return_data['status'] = 'failed';
	    $validator = Validator::make($request->all(), [
            'article_id'=>'required',
            'jnl_id'=>'required',
            'current_status_id'=>'required',
            'aflwid'=>'required'
        ]);
        if($validator->fails())
        {
            return  $this->failure('Failed',422,$validator->errors());
        }

        $this->current_user=$this->get_current_user_details();


		$user_deleted = false;
        $Article_flow=new \App\Models\Article_flow;
        $Articles=new \App\Models\Articles;
        $Article_reviewers=new \App\Models\Article_reviewers;
        $User=new \App\Models\User;
        $Article_versions_reviewers=new \App\Models\Article_versions_reviewers;
        $User_to_journals=new \App\Models\User_to_journals;
        $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder;
        $Article_remove_reviewer_suggest=new \App\Models\Article_remove_reviewer_suggest;


		$current_stage_id = decrypt_link($post_data['current_status_id']);
		$user_id = decrypt_link($post_data['user_ids']);
		$article_id = decrypt_link($post_data['article_id']);
		$aflwid = decrypt_link($post_data['aflwid']);
        DB::beginTransaction();
		$condition ="aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_id={$aflwid}";

		$status = $Article_flow::delete_records($condition, '', $this->current_user);

		$Article_reviewers::delete_records("sorw_suggested_reviewer_id={$user_id} AND sorw_aflw_id={$aflwid} AND sorw_art_id={$article_id}", '', $this->current_user);

		if(isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')
		{

			//checking element in article alternative reviewers
			$alt_criteria ="afap_aflw_id={$aflwid} AND afap_usr_id={$user_id} AND afap_art_id={$article_id}";
			$select_user_from_alt = $Article_flow_alternativereviewer_priorityorder::get_single_record('afap_id',$alt_criteria);
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($post_data['pool_id']) && isset($post_data['pool_workflow_assignment_desination_id']))
            {
                $pool_id =  decrypt_link($post_data['pool_id']);
                $destination_id =  decrypt_link($post_data['pool_workflow_assignment_desination_id']);
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */

			if(!empty($select_user_from_alt->afap_id))
			{
					$Article_flow_alternativereviewer_priorityorder::delete_records($alt_criteria, '', $this->current_user);
                    if(isset($pool_id))
                    {
                        $select = "afap_id";
                        $condition = "afap_art_id={$article_id} AND aflw_assignment_type_id={$pool_id} AND aflw_jwf_id={$destination_id}";
                        $article_flow_alternativereviewer_priorityorder_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
                        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                        $tables = array(
                            'main_table' => $Article_flow_table,
                            'join_table' => array($article_flow_alternativereviewer_priorityorder_table => array($Article_flow_table . '.aflw_id', $article_flow_alternativereviewer_priorityorder_table . '.afap_aflw_id') )
                        );
                        $get_all_alt_user = Article_flow::get_results_using_joins($tables, $select, $condition);
                    }
                    else
                    {
                        $get_all_alt_user = $Article_flow_alternativereviewer_priorityorder::get_all_records('afap_id',
                    "afap_parent_flow_id={$current_stage_id} AND afap_art_id={$article_id}",'afap_number');
                    }

					$i = 1;
					if(!empty($get_all_alt_user))
					{
						foreach($get_all_alt_user as $single_alt_user)
						{
							$update_alt_condition ="afap_id={$single_alt_user->afap_id}";


							$update_alt_data = array('afap_number' => $i);
							$Article_flow_alternativereviewer_priorityorder::update_record($update_alt_data,$update_alt_condition,$this->current_user);
							$i++;
						}
					}

			}
		}
        $article_version_table=(new \App\Models\Article_versions_reviewers())->getTable();
        $article_flow_table=(new \App\Models\Article_flow())->getTable();
        $generic_flowtable=(new \App\Models\Generic_flows())->getTable();
		//Task #524  Listing issue  -- related to privileged user as reviewer functionality
		$where_cnd = ' artvr_user_id = '.$user_id;
		$where_cnd .= ' AND CASE WHEN artvr_previous_art_ids IS NOT NULL THEN FIND_IN_SET('.$article_id.',CONCAT_WS(\',\',artvr_article_id,artvr_previous_art_ids)) > 0 ELSE artvr_article_id = '.$article_id.' END';

		$select = 'IF(artvr_previous_art_ids IS NOT NULL,artvr_previous_art_ids,artvr_article_id) as article_dis';

		$str_sql = 'SELECT '.$select.' FROM '. $article_version_table.'  WHERE '.$where_cnd;

		$result =  $Article_versions_reviewers::get_records_by_raw_query($str_sql);

		if(!empty($result[0]))
		{
			$str_sql = 'SELECT count(aflw_id) as cnt FROM '.$article_flow_table.','.$generic_flowtable.'  WHERE  aflw_jwf_id = jwf_id AND jwf_assignment = "invitation" AND  aflw_usr_id ='.$user_id.' AND aflw_parent_flow_id IS NOT NULL AND aflw_art_id IN ('.$result[0]->article_dis.')';
			$pre_reivew_count = $Article_flow::get_records_by_raw_query($str_sql,true);
			if($pre_reivew_count->cnt == 0)
			{
				$del_sql = 'DELETE FROM '.$article_version_table.' WHERE '.$where_cnd;
				$Article_versions_reviewers::get_records_by_raw_query($del_sql);
			}
		}

		/* delete user account if user account is in awaiting list */
		$user_details = $User::get_all_records('*',"usr_id={$user_id}");
        $user_role=array();
		$user_status = $user_details[0]->usr_status;
        $user_role = json_decode($user_details[0]->usr_roles);
        $author_criteria = array("auth_usr_id"=>$user_id);
        $co_authors = Authors::get_single_record_with_bind_cond('count(auth_id) as cnt',$author_criteria);
        $check_role_exist_condtn = array(
        'usrj_usr_id' => $user_id
        );
        $jrnl_role = $User_to_journals::get_single_record_with_bind_cond('count(usrj_id) as cnt', $check_role_exist_condtn);
        if ((!empty($jrnl_role) && $jrnl_role->cnt <= 2) && $user_status == 'w' && $co_authors->cnt == 0 && (empty($user_role) || (!empty($user_role) && !array_intersect($user_role, ['sudo', 'super_admin', 'report_operator'])))) 
        {
            $check_other_task = $Article_flow::get_single_record('count(aflw_id) as cnt', "aflw_usr_id={$user_id}"); // Bug #1715
            if (empty($check_other_task) || $check_other_task->cnt == 0) {
                /* insert deleted user detaila  */
                $user_title = $user_details[0]->usr_title;
                if ($user_details[0]->usr_title == null) {
                    $user_title = '';
                }
				$user_details = array(
					'arw_usr_id' => $user_id,
					'arw_title' => $user_title,
					'arw_first_name' => $user_details[0]->usr_first_name,
					'arw_last_name' => $user_details[0]->usr_last_name,
					'arw_email' => $user_details[0]->usr_email);

				$Article_remove_reviewer_suggest::insert_record($user_details, $this->current_user);
				$User_to_journals::delete_records("usrj_usr_id={$user_id}", '', $this->current_user);
				$User::delete_records("usr_id={$user_id}", '', $this->current_user);
				$user_deleted = true;
                $email_data=array(
                    'type'=>'global',
                    'action'=>'send',
                    'email_with_login'=>true,
                    'user_id'=>$user_id,
                    'empt_name'=>'remove_awaiting_activation_account',
                    // 'custom_data'=>$custom_data
                );

                $this->master_email_details($email_data);
			}
		}
		//
		/* end --- Add code block for sending notification email to invited users */
		if ($status)
		{
			$return_data['msg'] ='deletion success';
			$return_data['status'] = 'success';
			$return_data['user_deleted'] = $user_deleted;

		}
		else
		{
			$return_data['msg'] = 'Sorry ! some error occured';
		}
        DB::commit();
		return  $this->success('Success', 201, $return_data);

    }
    catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
	}
    public function allocate_stage_users_method(Request $request)
    {
        try
        {
        $post_data=$request->all();

		$validator = Validator::make($request->all(), [
            'article_id' => 'required',
            'journal_id'=>'required',
            'journal_code'=>'required',
			'hdn_current_status_id'=>'required',
			'hdn_short_rvws_ids'=>'required'
        ]);
        if($validator->fails())
        {
            return  $this->failure('Failed',422,$validator->errors());
        }

		$current_user = $this->get_current_user_details();

		$user_ids = array();
		if ($post_data['hdn_short_rvws_ids'] != '')
        {
        $user_ids =$post_data['hdn_short_rvws_ids'];
        }
		//Task #5083 Modify alternative reviewer selection
		$alternate_reviewers = array();
		if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))
		{
			if (isset($post_data['hdn_alt_rvws_ids']) && $post_data['hdn_alt_rvws_ids'] != '')
			{
				$alt_user_ids =  $post_data['hdn_alt_rvws_ids'];
				if(count($alt_user_ids) > 0)
				{
					$alt_user_ids = array_unique($alt_user_ids);
					foreach($alt_user_ids as $alt_rwrs)
					{
						$alternate_reviewers[] = $alt_rwrs;
					}
				}
			}
		}

		$jnl_code=$post_data['journal_code'];
		$current_stage_id = decrypt_link($post_data['stage_status_id']);
		if(isset($post_data['journal_id']))
        {
			$journal_id = decrypt_link($post_data['journal_id']);
        }
		$article_id = decrypt_link($post_data['article_id']);
		$unavailable_confirm = (isset($post_data['unavilable_status_confirm']) ? $post_data['unavilable_status_confirm'] :'');
		$unavilable_status = (isset($post_data['unavilable_status']) ? $post_data['unavilable_status'] :'');
        $skipcondition = (isset($post_data['skipcondition']) ? $post_data['skipcondition'] :false);

		$already_added = array();
		$added = array();
		$total_assignments = 0;
		if (count($user_ids) > 0)
		{

            $Article_flow=new \App\Models\Article_flow;
            $Articles=new \App\Models\Articles;
            $Article_reviewers=new \App\Models\Article_reviewers;
            $Roles=new \App\Models\Roles;
            $Article_versions_reviewers=new \App\Models\Article_versions_reviewers;
            $User_to_journals=new \App\Models\User_to_journals;
            $User_articles=new \App\Models\User_articles;
            $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder;
            $today = date('Y-m-d H:i:s', time());
            /*
			Get Article Details
			*/
			$get_article_rec = $Articles::get_single_record('*',"art_id={$article_id}");
       
		/*
		Check User Have Permission to ShortList
		*/
        $all_user_roles = $this->validate_user_journal($jnl_code, $current_user['user_id'],$get_article_rec->art_artp_id);
        $all_roles = $Roles::get_all_records('role_name,role_assigned_role,role_id');
        $array_data['user_roles']=$all_user_roles;
        $array_data['article_id']=$article_id;
        $array_data['all_roles']=$all_roles;
        $array_data['jnl_id']=$journal_id;
        $user_roles_list = $this->get_article_user_roles($array_data);
        $user_article_type_roles=isset($user_roles_list['role_id']) ? $user_roles_list['role_id'] : array();
        $article_cur_stage = $Article_flow::get_aticle_statuses($article_id, $current_user, $current_stage_id, true);
        $article_cur_stage = $article_cur_stage[0];
        $assigning_roles = json_decode($article_cur_stage->jwf_parent_user_roles);
		$inviting_roles = json_decode($article_cur_stage->jwf_who_can_invite);

                        //Bug #2484 :- Table alignment issue when a user is shortlisted from reviewer list to the shortlist user list
			if ($inviting_roles == null && $article_cur_stage->jwf_assignment == 'invitation')
			{
				$inviting_roles = $assigning_roles;
			}

			if (count(array_intersect($assigning_roles, $user_article_type_roles)) > 0
				|| count(array_intersect($inviting_roles, $user_article_type_roles)) > 0)
			{
				if (count(array_intersect($inviting_roles, $user_article_type_roles)) > 0)
				{
					$invite_permission = true;
				}
			}
			else
			{
				$return_data['msg'] = 'You do not have permission to access that page';
                $return_data['valid_status']=false;
                return $this->success('warning',200,$return_data);
			}


			/* start --- check if max number of reviewers has been alllocated */
			$condition['aflw_status'] = $article_cur_stage->aflw_status; //$current_stage_id

			$allocated_usrs = $Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt',"aflw_parent_flow_id={$current_stage_id}");

			$declined_users = $Article_flow::get_single_record('count(aflw_id) as count',"aflw_parent_flow_id={$current_stage_id} AND aflw_status='d'");

			$return_data['allocate_complete'] = false;
			if ((($allocated_usrs->cnt + count($user_ids)) - $declined_users->count ) >= $article_cur_stage->aflw_stage_min_users)
            {
				$return_data['allocate_complete'] = true;
            }

			if ( $article_cur_stage->jwf_stage_type == "review" && $unavailable_confirm == 'y' && $unavilable_status == 0)
			{
					$return_data['status'] = 'unavailable';
					$return_data['msg'] = 'unavailable_user';
                    $return_data['valid_status']=false;
                    return $this->success('success',200,$return_data);
			}
           
			$parent_status_record = $Article_flow::get_single_record('*',"aflw_id={$current_stage_id}");

			/* end --- check if max number of reviewers has been alllocated */

			if ($article_cur_stage->aflw_status == 'w')
			{
				$req_role_id = $article_cur_stage->jwf_role_id;
			}
			$inserted_ids = array();
			$in = 0;
			$role_name_multi='';
			$change_assignment = false;

			//Task #5083 Modify alternative reviewer selection
			$order = 1;
			if(isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')
			{
				$sel_max_order = 'max(afap_number) as max_cnt_val';
				$max_order = $Article_flow_alternativereviewer_priorityorder::get_single_record($sel_max_order,"afap_parent_flow_id={$current_stage_id} AND afap_art_id={$article_id}");
				if($max_order->max_cnt_val != null)
				{
					$order = $max_order->max_cnt_val + 1;
				}
			}

			foreach ($user_ids as $user_id)
			{
				//if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y'&& $article_cur_stage->jwf_stage_type == "review")
                if($article_cur_stage->jwf_stage_type == "review" &&  $skipcondition == false)
				{
					$return_data=$this->get_current_user_only_reviewer_conditon($get_article_rec->art_artp_id,$article_id,$user_id,$jnl_code,$journal_id,$user_ids);
                    if(isset($return_data['msg'])&&$return_data['msg']!='')
                    {
                    return $this->success('warning',200,$return_data);
                    }

				}


                $condition="aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id}";
				$get_record = $Article_flow::get_single_record('*', $condition);

				if ($get_record != '' && $skipcondition==false)
				{
					$already_added[] = $user_id;
					$return_data['id_arr_duplication'][] = encrypt_link($user_id);
				}
				else
				{
                    if($skipcondition==true && $get_record != '')
                    {
                        continue;
                    }
					$data['aflw_usr_id'] = $user_id;
					$data['aflw_art_id'] = $article_id;
					$data['aflw_parent_flow_id'] = $current_stage_id;
					$data['aflw_status'] = 'u';

					$data['aflw_assigned_date'] = $today;
					$data['aflw_jwf_id'] = $parent_status_record->aflw_jwf_id;
					$data['aflw_level'] = $parent_status_record->aflw_level;


					$inserted_id = $Article_flow::insert_record($data, $current_user);

					$article_reviewer_data ['sorw_aflw_id'] = $inserted_id;
					$article_reviewer_data ['sorw_suggested_reviewer_id'] = $user_id;
					$article_reviewer_data ['sorw_suggested_user_id'] = $current_user['user_id'];
					$article_reviewer_data['sorw_suggested_on'] = $today;
					$article_reviewer_data['sorw_art_id'] = $article_id;
					if(isset($post_data['usr_source']))
                    {
					$article_reviewer_data['sorw_usr_source']=$post_data['usr_source'];
                    }
					$art_rev_id = $Article_reviewers::insert_record($article_reviewer_data, $current_user);

					//Task #5083 Modify alternative reviewer selection
					if(isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y' && in_array($user_id,$alternate_reviewers) === true)
					{
						$alter_arr = array(
							'afap_usr_id' => $user_id,
							'afap_art_id' => $article_id,
							'afap_aflw_id'=> $inserted_id,
							'afap_parent_flow_id' => $current_stage_id,
							'afap_sorw_id' => $art_rev_id,
							'afap_number' => $order
						);
						$Article_flow_alternativereviewer_priorityorder::insert_record($alter_arr, $current_user);
						if ($inserted_id)
                        {
							$inserted_ids[$in]['afap_number'] = $order;
                        }
						$order++;
					}

					if ($inserted_id)
					{
						$inserted_ids[$in]['user'] = $user_id;
						$inserted_ids[$in]['flow'] = $inserted_id;
						$inserted_ids[$in]['review'] = $art_rev_id;
						$in++;
						/* start  --- add the user with reviewer role to journal users if not added */
						if ($article_cur_stage->aflw_status == 'w')
						{
                            $user_role_details="usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$req_role_id} AND usrj_artp_id IS null";
							$jnl_spec_rev_record = $User_to_journals::get_single_record('*', $user_role_details);
							$user_role_details_insert = array(
								'usrj_jnl_id' => $journal_id,
								'usrj_usr_id' => $user_id,
								'usrj_role_id' => $req_role_id,
								'usrj_artp_id' => null,
							);
							if ($jnl_spec_rev_record == null)
							{

								$User_to_journals::insert_record($user_role_details_insert, $current_user);
							}
                            $user_role_details_art_type="usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$req_role_id} AND usrj_artp_id ={$get_article_rec->art_artp_id}";
							//register user as article type reviewer

							$art_type_spec_rev_record = $User_to_journals::get_single_record('*', $user_role_details_art_type);

							if ($art_type_spec_rev_record == null)
							{
                                $user_role_details_insert['usrj_artp_id']=$get_article_rec->art_artp_id;
								$User_to_journals::insert_record($user_role_details_insert, $current_user);
							}
						}
						/* end  --- add the user with reviewer role to journal users if not added */
						$added[] = $user_id;
						$total_assignments++;
						$return_data['id_arr_alloacted'][] = encrypt_link($user_id);
						if ($article_cur_stage->jwf_stage_type == "review" && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
						{
                        $del_criteria ="usra_art_id={$article_id} AND usra_usr_id={$user_id}";
							$User_articles::delete_records($del_criteria, '',$current_user);
						}
					}
					else
					{
						$return_data['msg'] = 'Sorry ! some error occured';
						return $this->success('warning',200,$return_data);
					}

					//Enhancement#2068 Self and Assignmet type processing on production and ReView
					//only below code work when assign reviewers
					/*if($article_cur_stage->jwf_stage_type == 'review' && $article_cur_stage->role_assigned_role == 'reviewer')
					{
						$revier_exist = $Article_versions_reviewers::get_single_record('count(artvr_id) as count',"artvr_article_id={$article_id} AND artvr_user_id={$user_id}");
						if($revier_exist->count > 0)
						{
							$criteria_revwr ="artvr_article_id={$article_id} AND artvr_user_id={$user_id}";
							$Article_versions_reviewers::delete_records($criteria_revwr,'',$current_user);
						}

						$reviwers_details = array(
							'artvr_user_id' => $user_id,
							//'artvr_prev_art_id' => $user_id,
							'artvr_article_id' => $article_id,
							'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
						);
						$Article_versions_reviewers::insert_record($reviwers_details, $current_user);
					}*/
				}
			}

			if ($change_assignment === true)
			{
				$role_display_arr = explode(',',$role_name_multi);
				$role_name_multiple = str_replace(','.end($role_display_arr),' and '.end($role_display_arr),$role_name_multi);
                $msgdata = 'You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.';
				$msg.= str_replace('##roles##', $role_name_multiple, $msgdata);
                return $this->success('warning',200,$return_data);
			}

			if (!empty($added))
			{


					if($article_cur_stage->jwf_stage_type == 'review')
					{
						//Task #140: JPR-136 BUG: Overdue Reviewer Selection
						$today = date('Y-m-d H:i:s', time());
						$invite_due_date = new DateTime($today);

                        $invite_due_date = $this->get_due_date_for_article($article_id, $article_cur_stage->jwf_tat_complete);

						$Article_flow::update_record(array(
							'aflw_invite_due_date' => $invite_due_date
						),"aflw_id={$current_stage_id}");
					}



				$return_data['assignment_completed'] = false;

			 if (!empty($already_added))
			 {
                $return_data['msg'] = 'User assignment failed. The user has already been assigned to this stage.';
				return $this->success('warning',200,$return_data);
			 }
			}
            return $this->success('success',200,$return_data);

		}
		else
		{
			$return_data['msg'] = 'User allocation failed. You have not selected any users.';
			return $this->success('success',200,$return_data);
		}
        return $this->success('success',200,$return_data);
	}



        catch(\Exception $e)
        {

            return  $this->failure('Failed',500,$e);
        }
    }

	public function get_reviewer_assignment_to_stage(Request $request)
   {
     try
     {
         $post_data=$request->all();

         $validator = Validator::make($request->all(), [
			'article_id' => 'required',
		    'status_id'=>'required',
			'jnl_id'=>'required',
            'curent_article'=>'required'
		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
         $Article_flow=new \App\Models\Article_flow;
         $article_flow_table=(new \App\Models\Article_flow())->getTable();
         $genneric_flows_table=(new \App\Models\Generic_flows())->getTable();
         $article_reviwers_table=(new \App\Models\Article_reviewers())->getTable();
         $reject_reason_table=(new \App\Models\Reject_reasons())->getTable();
         $article_flow_alternativereviewer_priorityorder_table=(new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
         $usertable= (new \App\Models\User())->getTable();


		$is_previous = false;
		$excluded_deleted_status_arr = array(
			'w',
			'h'
		);

			$article_id = decrypt_link($post_data['article_id']);

            $jnl_code=$post_data['jnl_code'];
            $jnl_id=decrypt_link($post_data['jnl_id']);
			$flow_id = decrypt_link($post_data['status_id']);
			$curent_article_id = decrypt_link($post_data['curent_article']);

            $input_arr = array(
                'input' =>$article_id,
                'type'=> 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$flow_id,
                'type'=> 'number'
            );
            $flow_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$curent_article_id,
                'type'=> 'number'
            );
            $curent_article_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$jnl_id,
                'type'=> 'number'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            if($art_id_validate === false || $flow_id_validate === false || $curent_article_id_validate === false || $jnl_id_validate === false)
	        {
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",200,$arraymsg);
            }
			$flow_privilages = $this->get_article_flow_privilages($article_id, $flow_id,$jnl_code,$jnl_id);

            $date_format=$this->get_platform_date_format($jnl_id);
            $date_format=$this->date_format_map($date_format);

		if ($article_id != $curent_article_id)
		{
			$is_previous = true;
		}
		$article_data = $flow_privilages['article_data'];
		$article_flow_details = $flow_privilages['article_flow_details'];
		$user_roles = $flow_privilages['user_roles'];
		$all_roles = $flow_privilages['all_roles'];
		$all_roles = $this->rebuild_array_by_field($all_roles, 'role_id');
 $user_array_invite_shortlist=$this->get_who_can_shortlist_invite_users($flow_privilages,$article_id,$jnl_id,$jnl_code);

        $join_flow_reviwewer=" FROM ".$article_flow_table." as af INNER JOIN ".$article_reviwers_table." ON sorw_aflw_id=aflw_id";
         $reject_reson_join='';
         $alternative_reviwer_join='';
        //  TASK #7690 Batch review bugs
        $workflow_join='';
		$assg_criteria =" WHERE aflw_parent_flow_id={$flow_id}";
		$show_invited = ($article_flow_details->jwf_assignment == 'invitation' ) ? true : false;
		$order_by = '';
		$select = 'SELECT sorw_id,aflw_id,aflw_usr_id,aflw_status,sorw_invited_by,sorw_suggested_user_id,aflw_due_date,DATE_FORMAT(sorw_suggested_on, "' . $date_format . '") as suggested_date,DATE_FORMAT(sorw_invited_on, "' . $date_format . '") as invited_date,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as due_date,aflw_posted_by,aflw_remarks,aflw_returned_date,aflw_usr_review_reopen,sorw_author_suggested';
		if ($article_flow_details->jwf_stage_type == 'review')
		{
			$select .= ',IF(((select max(b.aflw_id) from ' . $article_flow_table . ' as b  where b.aflw_usr_id = af.aflw_usr_id and b.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id) && rjct_reinvite_flag ="y"  && (select count(aflw_id) from ' . $article_flow_table . ' as c  where c.aflw_usr_id = af.aflw_usr_id and c.aflw_parent_flow_id = af.aflw_parent_flow_id and c.aflw_status != "i" and c.aflw_status !="a" and c.aflw_status !="c")>0,1,0) as reinvte_condition,IF( ( ( SELECT MAX(d.aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id and af.aflw_status = "g" ) > 0, 1, 0 ) AS reinvte_unassigned_condition,(select count(aflw_id) from ' . $article_flow_table . ' as d  where d.aflw_usr_id = af.aflw_usr_id and d.aflw_parent_flow_id = af.aflw_parent_flow_id) as reviewer_invite_count,IF( ( ( SELECT MAX(e.aflw_id) FROM rvw_article_flow AS e WHERE e.aflw_usr_id = af.aflw_usr_id AND e.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id ) &&( SELECT COUNT(aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_parent_flow_id = af.aflw_parent_flow_id AND d.aflw_status = "d") <= 1, 1, 0 ) AS reviewer_invite_condition,sorw_usr_source';
            $reject_reson_join=" LEFT JOIN ".$reject_reason_table." ON sorw_rjct_id=rjct_id";


			if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))
			{
				$select .= ',afap_id,afap_number';
				$order_by = ' ORDER BY afap_number ASC';
                $alternative_reviwer_join=" LEFT JOIN ".$article_flow_alternativereviewer_priorityorder_table." ON afap_aflw_id = aflw_id";
			}
            // TASK #7690 Batch review bugs

            if($this->current_client->modules->mdl_conference=='y')
            {
                $select .= ',jwf_stage_name';
                $workflow_join=" LEFT JOIN ". $genneric_flows_table. " ON aflw_jwf_id  = jwf_id";
            }

			/* to recognise if added through reviewer on fly or not */
			$select .= ',(CASE WHEN sorw_usr_source=\'p\' THEN \'n\' WHEN `sorw_posted_by`=`sorw_suggested_user_id` and EXISTS(
SELECT `usr_id` FROM '.$usertable.' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
and `usr_status`=\'w\')   then \'y\' else \'n\' end ) as added_through_fly,(SELECT DATE_FORMAT(usr_posted_date, "' . $date_format . '") as user_posted FROM '.$usertable.' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
and `usr_status`=\'w\') as user_posted_date';
			/* to recognise if added through reviewer on fly or not */
		}
        $assigned_users_sql=$select.$join_flow_reviwewer.$reject_reson_join.$alternative_reviwer_join.$workflow_join.$assg_criteria.$order_by;

        $assigned_users=Article_flow::get_records_by_raw_query($assigned_users_sql);

		$conflict_interest = array();
		if ($article_flow_details->jwf_stage_type == 'review' && $this->current_client->modules->mdl_review_for_doc == 'n')
		{
			$conflict_interest = $this->get_article_conflict_array($article_id);
		}

		/* #625 Queue system for shortlisted reviewers auto invitation client functionality */
		$enable_reviewer_queue=false;

		if(isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority)&&($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y'))		  {
			$enable_reviewer_queue=true;
		}
		//($art_tables, 'single', 'art_id,artp_id,artp_fwm_id,atotp_review_method,atotp_rate_reviewer,art_status,art_stub,atotp_rescind_review,art_artp_id,atotp_primary_class,atotp_secondary_class,atotp_classification_hierarchy', $art_criteria);
        $read_only=false;
		$role_id = $article_flow_details->jwf_role_id;
		$data['article_id'] = $article_id;
		$data['action_stage_id'] = $article_flow_details->aflw_id;
		$data['jwf_id'] = $article_flow_details->jwf_id;
		$data['article_type'] = $article_data->artp_id;
		$data['role'] = $role_id;
		$data['role_id'] = $role_id;
		$data['stage_role_name'] = $all_roles[$role_id]->role_name;
		$data['read_only'] = $read_only;
		$data['min_review_cnt'] = $article_flow_details->aflw_stage_min_users;
		$data['max_review_cnt'] = $article_flow_details->aflw_stage_max_users;
		$data['show_invited'] = $show_invited;
		$data['show_other_details'] = true;
		$data['parent_flow_id'] = $flow_id;
		$data['type'] = 'stage';
		$data['invitation_status'] = invitation_status();

		$data['next_stage_id'] = '';
		$data['enable_reviewer_queue']=$enable_reviewer_queue;
		$data['jwf_assignment']= $article_flow_details->jwf_assignment;

		$assigning_roles = ($article_flow_details->jwf_parent_user_roles != '') ? json_decode($article_flow_details->jwf_parent_user_roles) : array();
		$inviting_roles = ($article_flow_details->jwf_who_can_invite != '') ? json_decode($article_flow_details->jwf_who_can_invite) : array();
		$has_assign_permission = $has_invite_permission = false;
		if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $assigning_roles)) > 0 &&(isset($user_array_invite_shortlist['assigned_user_ids']))&&(in_array($this->current_user['user_id'],$user_array_invite_shortlist['assigned_user_ids'])))
		{
			$has_assign_permission = true;
		}

		if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $inviting_roles)) > 0 &&(isset($user_array_invite_shortlist['who_can_invite_user_ids']))&&(in_array($this->current_user['user_id'],$user_array_invite_shortlist['who_can_invite_user_ids'])))
		{
			$has_invite_permission = true;
		}
		$data['has_invite_permission'] = $has_invite_permission;
		$data['has_assign_permission'] = $has_assign_permission;

		if ($article_flow_details->jwf_stage_type == 'review')
		{
			$current_status_id=decrypt_link($post_data['current_status_id']);
			$current_stage_active = ($current_status_id == $article_flow_details->aflw_id) ? true : false;
			$data['current_stage_active'] = $current_stage_active;



			$show_next_stage_button = false;
			$child_stage_count = $Article_flow::get_single_record('SUM(CASE WHEN aflw_status ="c" THEN 1 ELSE 0 END) AS completed_child_stages',"aflw_parent_flow_id={$article_flow_details->aflw_id}");
		if ($is_previous === false && in_array($article_flow_details->aflw_status, array(
					'w',
					'p')) && $article_data->art_status == "y")
			{
                $next_stage = array(
                'proceed_type' => 'manual',
                'stages' => null
            );
				if (isset($next_stage['stages'][0]))
				{

					if (isset($next_stage['stages'])&&$next_stage['stages'][0]['stage_type'] == "post_assessment")
					{
						$next_stage['stages'][0]['confirm_msg'] = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					$data['move_next_stage'] = $next_stage['stages'][0];
					$data['next_stage_id'] = $next_stage['stages'][0]['stage_id'];
				}

				if ($child_stage_count->completed_child_stages >= $article_flow_details->aflw_stage_min_users)
				{
			       if(isset($article_data->jp_edit_reviewer_count)&&count(array_intersect($user_roles['role_id'],json_decode($article_data->jp_edit_reviewer_count)))>0)
			        {
			        $show_next_stage_button = true;
			        }

					if ($next_stage['stages'] != null && (!isset($flow_details->aflw_reopened_flow_id) || (isset($flow_details->aflw_reopened_flow_id) && $flow_details->aflw_reopened_flow_id == null))
					)
					{

						foreach ($next_stage['stages'] as $stg)
						{
							$next_stages = $Article_flow::get_single_record('count(aflw_id) as count',"aflw_art_id={$article_id} AND aflw_jwf_id={$stg['stage_id']}");
							if ($next_stages->count > 0)
							{
								$show_next_stage_button = false;
								break;
							}
						}
					}
				}
			}
			$enable_button_active = false;
			if ($has_invite_permission == true || $has_assign_permission == true)
			{
				$enable_button_active = true;
			}
            $enable_edit_reviewer_count=false;
            if(isset($article_data->jp_edit_reviewer_count)&&count(array_intersect($user_roles['role_id'],json_decode($article_data->jp_edit_reviewer_count)))>0)
            {
            $enable_edit_reviewer_count = true;
            }
		if($this->current_client->modules->mdl_review_for_doc == 'n')
		{
			if ($article_flow_details->aflw_status == 'c')
			{
				if ($article_data->atotp_review_open_decision == "y")
				{

					$return_date = $article_flow_details->aflw_returned_date;
					$added_date = date('Y-m-d h:i:s', strtotime($return_date . ' +' . $article_data->atotp_review_open_count . ' days'));
					$current_date = date('Y-m-d h:i:s');

					$date1 = new DateTime($current_date);
					$date2 = new DateTime($added_date);

					if ($date1 > $date2)
                    {
						$enable_button_active = false;
                    }
				}
				else
				{
					$enable_button_active = false;
				}
			}
			if ($article_data->art_status != "y" || $is_previous == true)
			{
				$enable_button_active = false;
			}
			if (($article_flow_details->jwf_fwm_id != $article_data->artp_fwm_id) || ($article_data->art_status == 't'))
			{
				$enable_button_active = false;
				$data['current_stage_active'] = false;
			}
		}
		elseif($article_flow_details->aflw_status == 'c')
		{
			$enable_button_active = false;
		}

		if($article_flow_details->aflw_more_review_skip_status == 'y' || $article_flow_details->aflw_skip_review == 'y' )
		{
			$enable_button_active = false;
		}

        $excluded_deleted_status_arr = array(
			'w',
			'h'
		);

        if (isset($article_data->art_delete_status) && in_array($article_data->art_delete_status, $excluded_deleted_status_arr))
        {
            $enable_button_active = false;
        }

			$flow_id = ($article_flow_details->aflw_parent_flow_id == null) ? $article_flow_details->aflw_id : $article_flow_details->aflw_parent_flow_id;

			$data['enable_button_active'] = $enable_button_active;
			$data['readonly_button'] = 'Edit reviewer list';

			$data['article_flow_details'] = $article_flow_details;
			$data['show_next_stage_button'] = $show_next_stage_button;
			$data['show_multiple_checkbox'] = true;

			$data['read_only'] = false;
			if (in_array($article_data->art_delete_status, $excluded_deleted_status_arr))
			{
				$data['current_stage_active'] = false;
				$data['read_only'] = true;
				$data['enable_button_active'] = false;
			}
			if ((isset($article_data->art_status)) && ($article_data->art_status == 'c'))
			{
				$data['current_stage_active'] = false;
			}
			$skip_content = '';
			if ($article_flow_details->aflw_more_review_skip_status == 'y')
			{
				$sql1 = 'select aflw_posted_date from tbk_article_flow where aflw_usr_id is null and  aflw_art_id=' . $article_id . ' and aflw_reopened_min_user_count!=\'0\' and aflw_reopened_min_user_count=aflw_stage_min_users';
				$res1 = $Article_flow::get_records_by_raw_query($sql1);
				$sql2 = 'select aflw_posted_date from tbk_article_flow where aflw_more_review_skip_status =\'y\' and aflw_art_id=' . $article_id . ' and aflw_parent_flow_id is null and aflw_reopened_flow_id=0';
				$res2 = $Article_flow::get_records_by_raw_query($sql2);
				$i = 0;


				if (!empty($res1) && !empty($res2))
				{
					foreach ($res1 as $res)
					{
						if (isset($res2[$i]))
						{
							if ($i > 0)
                            {
								$skip_content .= '<hr class="seperator"/>';
                            }
							$skip_content .= 'Received for more review on ' . date_format(date_create($res->aflw_posted_date), $date_format) . ' and skipped on ' . date_format(date_create($res2[$i]->aflw_posted_date),$date_format);
							$i++;
						}
					}
				}
			}
			$data['skip_content'] = $skip_content;
			//#3323 Setting re-open review button on the reviewer list
			$data['article_data_set'] = $article_data;
			$data['is_previous'] = $is_previous;
			$data['assignment_only'] = false;
			$data['reopen']=false;
			$arr_set = array('a','r','c');
			if(isset($this->current_client->functionality->cfty_enable_review_resubmit) && $this->current_client->functionality->cfty_enable_review_resubmit == 'y' && (isset($article_data->art_status) && !in_array($article_data->art_status, $arr_set)) && (isset($is_previous) && $is_previous == false) && $article_data->art_delete_status == 'n')
			{
				$data['reopen']=true;
			}
			$notinviteduser=array();
            if (!empty($assigned_users))
            {

                foreach ($assigned_users as $assg)
                {



                    $due_date = $assg->aflw_due_date;
                    $date_diff=time() - strtotime($due_date);
                    $days = round($date_diff / (60 * 60 * 24));
                    $assg->due_date_danger=false;
                    if($days>0)
                    {
                        $assg->due_date_danger=true;
                    }
                    $alt_txt = null;
                    if(isset($assg->afap_number))
                    {
                        $alt_txt = $assg->afap_number;
                    }
                    $array_data['user_id'] = $assg->aflw_usr_id;
                    $array_data['journal_id'] =$jnl_id;
                    $array_data['flag']=true;
                    $array_data['article_id']= $article_id;
                    if($alt_txt!=null)
                    {
                    $array_data['alternate_no']= $alt_txt;
                    }
                    $array_data['availability']= true;

                    $array_data['jnl_code'] = $jnl_code;
                    if(isset($assg->aflw_usr_id)&&($assg->aflw_usr_id!=null))
                    $array_data['conflict_interest']=$this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                    $assg->short_listed_user = $this->get_user_display_name($array_data);

                    $assg->suggested_user = '';
                    $array_data['conflict_interest']='';
                    if ($assg->sorw_suggested_user_id != null)
                    {
                        $array_data['user_id'] = $assg->sorw_suggested_user_id;
                        $array_data['journal_id'] =$jnl_id;
                        $array_data['flag']=true;
                        $array_data['article_id']= $article_id;
                        $array_data['availability']= true;
                        $array_data['alternate_no']= '';
                        $array_data['jnl_code'] = $jnl_code;
                        $assg->suggested_user = $this->get_user_display_name($array_data);
                    }
                    $assg->invited_user = '';
                    if ($assg->sorw_invited_by != null)
                    {
                        $array_data['user_id'] = $assg->sorw_invited_by;
                        $array_data['journal_id'] =$jnl_id;
                        $array_data['flag']=true;
                        $array_data['article_id']= $article_id;
                        $array_data['availability']= true;
                        $array_data['alternate_no']= '';
                        $array_data['jnl_code'] = $jnl_code;
                        $assg->invited_user = $this->get_user_display_name($array_data);

                        if($assg->sorw_invited_by == 0)
                        {

                            $assg->invited_user='system';
                        }
                    }
                    $assg->invited_user_id=$assg->sorw_invited_by;
                    $show_conflict_interest_message = array();
                    if (!empty($conflict_interest))
                    {
                        $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                    }
                    $assg->conflict_message = $show_conflict_interest_message;
                    $assg->unregistered_user = $this->check_usr_account($assg->aflw_usr_id);
                       if($assg->aflw_status =='u'&&$assg->unregistered_user === false)
                       {
                        array_push($notinviteduser,$assg->aflw_usr_id);

                       }
                    $assg->invitationstatus=$this->check_invitation_status($data,$assg);
                }
            }
            $data['not_invited_users']=$notinviteduser;
            $data['assigned_users'] = $assigned_users;
            $data['shortlistinfo']=$this->get_short_list_details($flow_id);
            $data['enable_reviewer_count']=$enable_edit_reviewer_count;
		}



    return $this->success('success',200,$data);


     }
     catch(\Exception $e)
     {

         return  $this->failure('Failed',500,$e);
     }

   }


   public function invitation_history(Request $request)
   {
       try
       {
       $post_data = $request->all();
       $validator = Validator::make($request->all(), [
        'art_id' => 'required',
        'art_reviwer_id'=>'required',
        'usr_id'=>'required',
        'parent_flow'=>'required',
        'jnl_id'=>'required'
    ]);
    if($validator->fails())
    {
        return  $this->failure('Failed',422,$validator->errors());
    }

       $Article_flow=new \App\Models\Article_flow;
       $art_review_user = decrypt_link($post_data['art_reviwer_id']);
       $art_id = decrypt_link($post_data['art_id']);
       $user = decrypt_link($post_data['usr_id']);
       $parent_flow = decrypt_link($post_data['parent_flow']);
       $resend_invitation = $post_data['resend_invitation'];
       $jnl_id=decrypt_link($post_data['jnl_id']);
       $aflwid = decrypt_link($post_data['aflw_id']);
       $pool_details = Article_flow::get_single_record_with_bind_cond('aflw_parent_flow_id,aflw_assignment_type_id,aflw_jwf_id',array('aflw_id'=>$aflwid));
       $sql1 = 'SELECT tbk_id FROM tbk_article_flow WHERE aflw_reviewer_added_by_stage_status = "r" AND aflw_id = '.$aflwid.' ORDER BY tbk_id ASC LIMIT 1';
	   $res1 = $Article_flow::get_records_by_raw_query($sql1);
       $sql2 = 'SELECT aflw_parent_flow_id FROM tbk_article_flow WHERE aflw_reviewer_added_by_stage_status = "p" AND aflw_id = '.$aflwid.' ORDER BY tbk_id ASC LIMIT 1';
	   $res2 = $Article_flow::get_records_by_raw_query($sql2);
       $removed_tbk_id = '';
       $parent_flow_id = '';
       if(!empty($res1) && count($res1)>0)
       {
           $removed_tbk_id = $res1[0]->tbk_id;
       }
       if(!empty($res2) && count($res2)>0)
       {
           $parent_flow_id = $res2[0]->aflw_parent_flow_id;
       }
       $pool_array = array();
       if($pool_details->aflw_assignment_type_id != null && $pool_details->aflw_assignment_type_id != 0)
       {
           $pool_id = $pool_details->aflw_assignment_type_id;
           $destination_id = $pool_details->aflw_jwf_id;
           $pool_array = array(
               'pool_id' => $pool_id,
               'destination_id' => $destination_id,
               'art_id' => $art_id,
               'parent_flow_id'=> $parent_flow_id,
               'removed_tbk_id'=> $removed_tbk_id
           );
       }
       $input_arr = array(
        'input' =>$art_id,
        'type'=> 'number'
    );
    $art_id_validate = $this->Rv_validator($input_arr);
    $input_arr = array(
        'input' =>$parent_flow,
        'type'=> 'number'
    );
    $flow_id_validate = $this->Rv_validator($input_arr);
    $input_arr = array(
        'input' =>$user,
        'type'=> 'number'
    );
    $user_validate = $this->Rv_validator($input_arr);
    $input_arr = array(
        'input' =>$jnl_id,
        'type'=> 'number'
    );
    $jnl_id_validate = $this->Rv_validator($input_arr);
    if($art_id_validate === false || $flow_id_validate === false || $user_validate === false || $jnl_id_validate === false)
    {
     $arraymsg['mesage'] = customTrans('validation.notvalid');
    return $this->warning("Failed",200,$arraymsg);
    }

       if ($art_review_user != '' && $art_id != '' && $user != '' && $parent_flow != '')
       {
        $date_format=$this->get_platform_date_format($jnl_id);
        $date_format=$this->date_format_map($date_format);

           $Article_flow=new \App\Models\Article_flow;
           $Article_reviewer_suggest=new \App\Models\Article_reviewer_suggest;
           $Article_reviewers=new \App\Models\Article_reviewers;
           

           $invitation_history_data = $Article_reviewers::get_reviewer_data($art_id, $parent_flow,$date_format, true, $user, true,$pool_array);

           $all_invitation_data = $Article_reviewers::get_all_invitation_data($art_id, $parent_flow, $user, $date_format,$pool_array);

           $reviewer_suggestion_data = $Article_reviewer_suggest::get_suggested_data($user, $parent_flow, $date_format,$pool_array);
           $reviewer_email_change_arr=$this->get_user_profile_modification_history($user,$date_format);
           $list_array=$this->format_invitation_history($reviewer_suggestion_data,$invitation_history_data,$resend_invitation,$art_review_user,$reviewer_email_change_arr,$all_invitation_data,$this->current_client->functionality->cfty_enable_review_resubmit);
           return $this->success('success',200,$list_array);

       }
    }
       catch(\Exception $e)
     {
         return  $this->failure('Failed',500,$e);
     }
   }


public function add_reviewer_and_invite(Request $request)
{
try
{
    $reviewer=$request->all();

    $validator = Validator::make($request->all(), [
        'article_id'=>'required',
        'jnl_id'=>'required',
        'jnl_code'=>'required'
    ]);
    if($validator->fails())
    {
        return  $this->failure('Failed',422,$validator->errors());
    }
    $this->current_user=$this->get_current_user_details();
    DB::beginTransaction();
    $user_data = $this->get_current_user_details();
    $article_id = $reviewer['article_id'] ? decrypt_link($reviewer['article_id']) : null;
    $journal_id = decrypt_link($reviewer['jnl_id']);
    $journal_flow_id = decrypt_link($reviewer['current_status_id']);
    $max_limit_reached = $reviewer['max_limit_reached'];
    $unavilable_user_status = $reviewer['unavilable_user_status'];
    $unavilable_user_confirm = $reviewer['unavilable_user_confirm'];
    $jnl_standalone=$reviewer['jnl_standalone'];
    $jnl_code=$reviewer['jnl_code'];
        $user_id='';
    if(isset($reviewer['user_id'])&&$reviewer['user_id']!='')
    {
        $user_id= decrypt_link($reviewer['user_id']);
    }
$User_to_journals=new \App\Models\User_to_journals;
$Users=new \App\Models\User;
$Article_reviewers=new \App\Models\Article_reviewers;
$Generic_flows=new \App\Models\Generic_flows;
$Articles=new \App\Models\Articles;
$Article_flow=new \App\Models\Article_flow;
$Article_versions_reviewers=new \App\Models\Article_versions_reviewers;
$User_articles=new \App\Models\User_articles;
$result = array();
$article_type_id='';
    if($article_id){
        $article_data = $Articles::get_single_record('art_artp_id',"art_id={$article_id}");
        $article_type_id = $article_data->art_artp_id;
    }

    $update_reviwer_id=isset($reviewer['reviewerid']) ? $reviewer['reviewerid'] : null;


    $post_email = trim($reviewer['email']);

    $jnl_id = ($jnl_standalone == 'y') ? $journal_id : null;
    $email_condition = ' (usr_username = \'' . $post_email . '\' OR usr_email = \'' . $post_email . '\') ';
    if ($jnl_standalone == 'y')
    {
        $email_condition .= '  AND usr_jnl_standalone = ' . $journal_id;
    }
    else
    {
        $email_condition .= ' AND usr_jnl_standalone IS null';
    }

    //1.2EXIST EMAIL CHECK -- START
    $exist_awaiting_reviewer = array();
    $exist_email_data = $Users::get_single_record('usr_id,usr_roles,usr_jnl_standalone,usr_status,usr_pwd,usr_url,usr_deeplink_token', $email_condition);

    $email_exist = false;
    $user_ids =  array();

    if (!empty($exist_email_data))
    {
        /*          $user_id = $exist_email_data[0]->usr_id;
          foreach ($exist_email_data as $exist_email)
          { */
        $user_id = $exist_email_data->usr_id;
        $usr_role = json_decode($exist_email_data->usr_roles);
        if (is_array($usr_role) && (in_array('super_admin', $usr_role) || in_array('sudo', $usr_role)))
        {
            $email_exist = true;
        }
        elseif ($exist_email_data->usr_status == 'w')
        {
            $exist_awaiting_reviewer = $exist_email_data;
        }
        else
        {
            $email_exist = true;
        }
        //}
    }
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
     if(isset($reviewer['pool_id']) && isset($reviewer['pool_workflow_assignment_desination_id']) && isset($reviewer['pool_workflow_assignment_source_id']))
     {
         $pool_id =  decrypt_link($reviewer['pool_id']);
         $source_id =  decrypt_link($reviewer['pool_workflow_assignment_source_id']);
         $destination_id =  decrypt_link($reviewer['pool_workflow_assignment_desination_id']);
     }
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
     if ($update_reviwer_id == null && $journal_flow_id)
    {

    /* 1.3 check if  maximum  number of reviewers are allocated
     *   Overriding for edit fly user */

            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($pool_id) && isset($source_id) && isset($destination_id))
            {
                $child_count = $Article_flow::get_single_record('count(DISTINCT aflw_usr_id) as cnt',"aflw_art_id={$article_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id IS NOT null");
                $master_record = $this->get_min_max_count_pre_review_stage($pool_id, $journal_flow_id, $source_id,$destination_id);
                $aflw_stage_max_users = $master_record->max_user;
            }
            else
            {
                $child_count = $Article_flow::get_single_record('count(DISTINCT aflw_usr_id) as cnt',"aflw_parent_flow_id={$journal_flow_id}");

                $master_record = $Article_flow::get_single_record('aflw_stage_max_users',"aflw_id={$journal_flow_id}");
                $aflw_stage_max_users=$master_record->aflw_stage_max_users;
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            /* 1.1 if yes,return with an error message */
            //if (!$availble && $max_limit_reached == 0 && $excess_reviewer!=1)
            if (empty($master_record))
            {
                $result['msg'] = 'Invalid stage data';
                return $this->success('warning',200,$result);
            }

            if ($unavilable_user_status == 0 && $unavilable_user_confirm == "y")
            {
                $result['status'] = 'unavilable';
                $result['msg'] = '';
                return $this->success('warning',200,$result);
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review */
            if ($child_count->cnt >= $aflw_stage_max_users && $max_limit_reached == 0)
            {
                $result['status'] = 'excess';
                $result['msg'] = 'The number of reviewers invited exceeds the maximum number of reviewers required. Do you wish to continue?';
                return $this->success('warning',200,$result);
            }

        }
    if ($user_id != '' && ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') && $article_type_id)
    {
        $user_ids = $user_id;
        $return_data=$this->get_current_user_only_reviewer_conditon($article_type_id,$article_id,$user_id,$jnl_code,$journal_id, $user_ids);
        if(isset($return_data['msg'])&&$return_data['msg']!='')
        return $this->success('warning',200,$return_data);
    }

    /* 2  add new user record to database
     * 2.1 generate access token for invititation link  */
    $user_deeplink_token = Str::random(20);

    $registered_user = false; //user by sign up -- usr_url

    if (!empty($exist_awaiting_reviewer) && $exist_awaiting_reviewer->usr_status == 'w')
    {
        $user_id = $exist_awaiting_reviewer->usr_id;
        if (!empty($exist_awaiting_reviewer->usr_pwd) && !empty($exist_awaiting_reviewer->usr_url))
        {
            $user_deeplink_token = $exist_awaiting_reviewer->usr_url;
            $registered_user = true;
        }
        else
        {
            if (!empty($exist_awaiting_reviewer->usr_deeplink_token))
            {
                $user_deeplink_token = $exist_awaiting_reviewer->usr_deeplink_token;
            }
            else
            {
                $Users::update_record(array(
                    'usr_deeplink_token' => $user_deeplink_token),"usr_id={$user_id}");
            }
        }
    }
    else
    {
        /* 2.2 generate temporary password */
        if ($email_exist !== true &&isset($reviewer['first_name']))
        {
            $user_details = array(
                'usr_username' => $reviewer['email'],
                'usr_title' => $reviewer['user_title'],
                'usr_first_name' => $reviewer['first_name'],
                'usr_last_name' => $reviewer['last_name'],
                'usr_email' => $reviewer['email'],
                //'usr_pwd' => md5($password),
                'usr_deeplink_token' => $user_deeplink_token,
                'usr_status' => 'w',
                'usr_registered' => 'n',
                'usr_jnl_standalone' => $jnl_id
            );

            if (isset($update_reviwer_id)&&$update_reviwer_id != null)
            {
                $user_id = decrypt_link($update_reviwer_id);


                    $reviwer_data = $Users::get_single_record('usr_email', "usr_id={$user_id}");
                    if(strtolower($post_email)==strtolower($reviwer_data->usr_email))
                    {
                        $Users::update_record(
                            $user_details,"usr_id={$user_id}", $this->current_user);

                            $newusername=$reviewer['first_name'].$user_id;
                            $data_username_new = array('usr_username' =>$newusername);
                            $user_condition = "usr_id = {$user_id}";
                            $Users::update_record($data_username_new, $user_condition, $this->current_user);
                    }

            }
            else
            {
                $user_id = $Users::insert_record($user_details, $user_data);
                if($user_id)
                    {
                        $newusername=$reviewer['first_name'].$user_id;
                        $data_username_new = array('usr_username' =>$newusername);
                        $user_condition = "usr_id = {$user_id}";
                        $Users::update_record($data_username_new, $user_condition, $this->current_user);
                        if($this->current_client->modules->mdl_conference == 'y'){
                            $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $user_deeplink_token . "&userid=" . $user_id."&name=add_user_confirmation");
                            $user_data_for_mail=array("user_id"=>$user_id,'activation_link'=>$link);
                            $this->send_email_confirmation_user($user_data_for_mail);
                            $result['message'] = 'User has been added';
                            $result['data'] = ['user_id' => $user_id];
                        }
                    }
            }
        }
    }
    /* 3  if $user_id is returned,add roles for new user    */
    if ($user_id != '' && (!isset($reviewer['batch_view']) || (isset($reviewer['batch_view']) && $reviewer['batch_view'] != true)))
    {
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
        if(isset($pool_id) && isset($source_id) && isset($destination_id))
        {
            $reviewer_role = $Generic_flows::get_single_record('jwf_role_id as role_id',"jwf_id={$destination_id}");
        }
        else
        {
            $aflw_jwf_id = $Article_flow::get_single_record('aflw_jwf_id',"aflw_id={$journal_flow_id}")->aflw_jwf_id;
            $reviewer_role = $Generic_flows::get_single_record('jwf_role_id as role_id',"jwf_id={$aflw_jwf_id}");
        }
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
        /* 3.1  format data to be inserted */
        $role_in_jnl = $role_in_artp = false;
        if (!empty($exist_awaiting_reviewer) || $email_exist === true)
        {
            $check_role_exist ="usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$reviewer_role->role_id} AND usrj_artp_id IS null";

            $get_jnl_role = $User_to_journals::get_single_record('usrj_id', $check_role_exist);

            if (!empty($get_jnl_role))
            {
                $role_in_jnl = true;
                $user_role_id = $get_jnl_role->usrj_id;
            }

            $check_role_exist_arttype= "usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$reviewer_role->role_id} AND  usrj_artp_id={$article_type_id}";

            $get_artp_role = $User_to_journals::get_single_record('usrj_id', $check_role_exist_arttype);
            if (!empty($get_artp_role))
            {
                $role_in_artp = true;
                $user_role_id = $get_jnl_role->usrj_id;
            }
        }
        $user_role_details = array(
            'usrj_jnl_id' => $journal_id,
            'usrj_usr_id' => $user_id,
            'usrj_role_id' => $reviewer_role->role_id,
            'usrj_artp_id' => null,
            'usrj_invite' => 'y' // Changed Y to y. Y not used anywhere
        );
        /* 3.2  insert the record into database */
        if (isset($update_reviwer_id)&&$update_reviwer_id != null)
        {
            $user_role_id = true;
            $user_id = decrypt_link($update_reviwer_id);
            $reviwer_data = $Users::get_single_record('usr_email', "usr_id={$user_id}");
            $user_details = array(
                //'usr_username' => $reviewer['email'],
                'usr_title' => $reviewer['user_title'],
                'usr_first_name' => $reviewer['first_name'],
                'usr_last_name' => $reviewer['last_name'],
                'usr_email' => $reviewer['email'],
                'usr_deeplink_token' => $user_deeplink_token,
                'usr_jnl_standalone' => $jnl_id
            );
            if(strtolower($post_email)==strtolower($reviwer_data->usr_email))
            {
                $Users::update_record(
                $user_details,"usr_id={$user_id}", $this->current_user);

            }
            else
            {

                if(isset($reviewer['email']))
                {
                    $email_condition = ' usr_email = \'' . $reviewer['email'].'\' ';
                    if ($jnl_standalone == 'y')
                    {
                        $email_condition .= '  AND usr_jnl_standalone = ' . $journal_id;
                    }
                    else
                    {
                        $email_condition .= ' AND usr_jnl_standalone IS null';
                    }
                    $rvr_data = $Users::get_single_record('usr_id', $email_condition);
                    if(isset($rvr_data) && count((array)$rvr_data) > 0)
                    {
                        $result['status'] = 'warning';
                        $result['msg'] = 'Email already exists';
                    }
                    else
                    {
                        $Users::update_record(
                        $user_details,"usr_id={$user_id}", $this->current_user);
                    }
			    }
            }

        }
        else
        {

            if ($role_in_jnl === false)
            {
                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
            }
            /* 3.3 register user as article type reviewer  */
            $user_role_details['usrj_artp_id'] = $article_type_id;
            if ($role_in_artp === false)
            {
                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
            }
        }
        if ($user_role_id != '')
        {


            /* 4.1 get article details for email content */
            $select = 'art_id, art_artp_id,art_title, aflw_id, aflw_level, artp_article_type, jnl_journal_name, jwf_id, jwf_assignment, jwf_stage_type, jwf_stage_name, jwf_status_name, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,aflw_status';
            $article_details = $Articles::get_article_details($select,"aflw_id={$journal_flow_id}",null,true);

            $article_details = $article_details[0];

            $data['aflw_usr_id'] = $user_id;
            $data['aflw_art_id'] = $article_id;
            $data['aflw_parent_flow_id'] = $journal_flow_id;
            /* 4.2 get article flow and permissions */
            $article_flow_status = 'u';

            /* 5 insert data into article flow and get the new id */
            $data['aflw_status'] = $article_flow_status;
            $data['aflw_assigned_date'] = date('Y-m-d H:i:s');
            $data['aflw_jwf_id'] = $article_details->jwf_id;
            $data['aflw_level'] = $article_details->aflw_level;
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($pool_id) && isset($source_id) && isset($destination_id))
            {
                $data['aflw_assignment_type_id'] =  $pool_id;
                $data['aflw_source_assignment_id'] =  $source_id;
                $data['aflw_jwf_id'] =  $destination_id;
                $data['aflw_reviewer_added_by_stage_status'] = 'p';
            }
            $art_flw_exist = false;
            if (!empty($exist_awaiting_reviewer) || $email_exist === true )
            {

                if(isset($pool_id) && isset($source_id) && isset($destination_id))
                {
                    $check_flw_exist_cond = "aflw_usr_id={$user_id} AND aflw_art_id={$article_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id IS NOT null";
                }
                else
                {
                    $check_flw_exist_cond="aflw_level={$article_details->aflw_level} AND aflw_usr_id={$user_id} AND aflw_art_id={$article_id} AND aflw_parent_flow_id={$journal_flow_id} AND aflw_jwf_id={$article_details->jwf_id}";
                }
                $get_flow_detail = $Article_flow::get_single_record('aflw_id', $check_flw_exist_cond);
                if (!empty($get_flow_detail))
                {
                    $art_flw_exist = true;
                }
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            /* 6  insert data into article Article_reviewers  */
            if ($art_flw_exist === false )
            {
                if ($update_reviwer_id === null)
                {
                    $article_flow_id = $Article_flow::insert_record($data, $user_data);
                    if ($article_flow_id > 0)
                    {
                        $article_reviewer_data ['sorw_aflw_id'] = $article_flow_id;
                        $article_reviewer_data ['sorw_suggested_reviewer_id'] = $user_id;
                        $article_reviewer_data ['sorw_suggested_user_id'] = $user_data['user_id'];
                        if ($article_flow_status == 'i')
                        {
                            $article_reviewer_data ['sorw_invited_by'] = $user_data['user_id'];
                            $article_reviewer_data['sorw_invited_on'] = date('Y-m-d H:i:s');
                        }
                        $article_reviewer_data['sorw_suggested_on'] = date('Y-m-d H:i:s');
                        $article_reviewer_data['sorw_art_id'] = $article_id;
                        if (isset($post_array['new_reviewer']['usr_source']))
                        {
                            $article_reviewer_data['sorw_usr_source'] = $post_array['new_reviewer']['usr_source'];
                        }


                        $Article_reviewers::insert_record($article_reviewer_data, $user_data);
                    }
                }
                $result=array();
                if ($this->current_client->functionality->cfty_disable_reviewer_on_fly_email == 'n' && $email_exist === false)
                {
  /* 8 if templates found, send mail */
                    $etmp_name='reviewer_on_fly';
                    if (!empty($exist_awaiting_reviewer))
                    {
                        $etmp_name='reviewer_on_fly_awaiting_confirm';
                    }
                    if ($registered_user === false)
                    {
                        $confirmation_url =URL::to('/') . '/' ."awaiting-confirm-mail/" . encrypt_link("&key=" . $user_deeplink_token . "&userid=" . $user_id);
                    }
                    else
                    {
                        $confirmation_url =URL::to('/') . '/' .'confirmation/' . $user_deeplink_token;
                    }

                    $custom_data=array(
                        'confirmation_link'=>$confirmation_url,
                        'esl_etmp_action'=>'add_potential_reviewer',
                        'add_potential_reviewer'=>true,
                        'article_id'=> $article_id,
                        'artp_id'=>$article_type_id,
                        'jnl_id'=>$journal_id,
                        'jnl_code'=>$jnl_code,
                        'aflw_id'=>$journal_flow_id,
                    );
                    $email_data=array(
                        'type'=>'global',
                        'action'=>'send',
                        'email_with_login'=>true,
                        'user_id'=>$user_id,
                        'empt_name'=> $etmp_name,
                        'custom_data'=>$custom_data
                    );

                    $this->master_email_details($email_data);

                }

                /* 9 set response */




                                    $revier_exist = $Article_versions_reviewers::get_single_record('count(artvr_id) as count',"artvr_article_id={$article_id} AND artvr_user_id={$user_id}");
                                     if($revier_exist->count > 0)
                                    {
                                        $criteria_revwr="artvr_article_id={$article_id} AND artvr_user_id={$user_id}";

                                        $Article_versions_reviewers::delete_records($criteria_revwr,'',$user_data);
                                    }

                                    $get_article_rec = $Articles::get_single_record('art_pre_all_ids',"art_id={$article_id}");

                                    $reviwers_details = array(
                                                            'artvr_user_id' => $user_id,
                                                            //'artvr_prev_art_id' => $user_id,
                                                            'artvr_article_id' => $article_id,
                                                            'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
                                                    );
                                    $Article_versions_reviewers::insert_record($reviwers_details,$user_data);

                if ( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' )
                {
                        $del_criteria = "usra_art_id={$article_id} AND usra_usr_id={$user_id}";
                        $User_articles::delete_records($del_criteria,'',$user_data);
                }
            }
            elseif($update_reviwer_id!=null)
            {
                $result['msg'] = 'Update Success';
                if(isset($rvr_data) && count((array)$rvr_data) > 0)
                {
                    $result['msg'] = 'Email already exists';
                }
            }
            else
            {
                $result['status'] = 'warning';
                $result['msg'] = 'Reviewer already exists';
            }
        }
    }

    DB::commit();

    return $this->success('success',200, $result);
}
    catch(\Exception $e)
	{

		return  $this->failure('Failed',500,$e);
	}
}



// get user details when add new reviewer email search
public function get_reviewer_by_email_search(Request $request){
	try{

		$validator = Validator::make($request->all(), [
			'new_reviewer_email' => 'required',
			'jnl_id' => 'required',
			'jnl_standalone' => 'required'
		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
		else
		{
			$Users=new \App\Models\User();
            $Authors=new \App\Models\Authors();
			$this->current_user = $this->get_current_user_details();
			$reviewer = $request->all();

			$post_email = trim($reviewer['new_reviewer_email']);
			$jnl_id = ($reviewer['jnl_standalone'] == 'y') ? $reviewer['jnl_id']: null;
            $article_id=decrypt_link($reviewer['article_id']);
			$jnl_condition = ($reviewer['jnl_standalone'] == 'y') ? ' AND usr_jnl_standalone = '.$reviewer['jnl_id'] : ' AND usr_jnl_standalone IS null';
            $result['userdata']=false;
			//EXIST EMAIL CHECK -- START
            $email_condition = ' (usr_username = \''.$post_email.'\' OR usr_email = \''.$post_email.'\') '.$jnl_condition;

			$exist_email_data = $Users::get_all_records('usr_id,usr_roles,usr_jnl_standalone,usr_status,usr_pwd,usr_url,usr_deeplink_token',$email_condition);
			$email_exist = false;
			$self_assignment = true;
			if($this->current_client->functionality->cfty_self_assignment == 'n')
			{
			   $self_assignment = false;
			}
			$document_module = false;
			if (isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y')
			{
			$document_module = true;
			}
            $userstatus=user_status();
			if(count($exist_email_data) > 0)
			{
                $result['email_found'] ='y';
                $result['active']=false;
                $criteria = "usr_id={$exist_email_data[0]->usr_id}";
				$user_details = $Users::get_single_record('usr_id, usr_title, usr_first_name, usr_middle_name, usr_last_name, usr_email, usr_status',$criteria);

				foreach ($exist_email_data as $exist_email)
				{
				$email_exist = true;

                $array_data['user_id'] =$user_details->usr_id;
                $array_data['journal_id'] =$jnl_id;
                $array_data['article_id'] =$article_id;

				$user_details->user_full_name = $this->get_user_display_name($array_data);
                $user_details->usr_status_text=$userstatus[$user_details->usr_status];
				$tat_dates = array();
				$tat_dates = $this->get_tat_dates(decrypt_link($reviewer['stage_id']));
				$user_unavail = 'n';
				$user_unavail_msg = '';
				$unavailable_reason = '';
				$date_bwn = '';
				$users_unavailability = $this->get_users_unavailability($exist_email_data[0]->usr_id, $tat_dates);
				if ($users_unavailability != null)
				{

					$user_unavail = 'y';
					if ( $users_unavailability[0]->unavail_start_date != $users_unavailability[0]->unavail_end_date )
					{

						$date_bwn = ' between '.date('d-m-Y', strtotime($users_unavailability[0]->unavail_start_date)) .' and '.date('d-m-Y',strtotime($users_unavailability[0]->unavail_end_date));

					}else
					{
						$date_bwn = ' on '.date('d-m-Y', strtotime($users_unavailability[0]->unavail_start_date));

					}

					$unavailable_reason = $users_unavailability[0]->unavail_reason;
					$user_unavail_msg = ' The user unavailable '.$date_bwn .' <br><b>Reason:</b> '.$unavailable_reason;
				}
				$user_details->user_unavailable =  $user_unavail;
				if ($email_exist === true)
				{
					$article_id = decrypt_link($reviewer['article_id']);
					$author_count = '';
					$self_assign = '';
					if($document_module=== false)
					{
					$author_data =$Authors::get_all_records('auth_usr_id',"auth_art_id={$article_id}");
					if(!empty($author_data))
					{
						foreach($author_data as $author)
						{
							if($author->auth_usr_id == $exist_email_data[0]->usr_id)
							{
								$author_count = 'y';
							}
						}
					}
					}
					if( $self_assignment === false && $this->current_user['user_id'] == $exist_email_data[0]->usr_id )
					{
                        $self_assign = 'y';
					}

					if($author_count == 'y')
					{
						$result['status']='a';
						$result['msg']='Author and reviewer for an article cannot be same';
					}
					elseif( $self_assign == 'y' )
					{
						$result['status']='s';
						$result['msg']='Self assignment not possible';
					}
					elseif( $user_unavail == 'y' )
					{
						$result['status']='y';
                        $result['active']=true;
                        $result['user_unavail']='y';
                        $result['userdata']=true;
                        $result['user_details']=$user_details;
						$result['msg']=$user_unavail_msg;
					}
					else
					{
                        $result['active']=true;
						$result['status']='y';
                        $result['userdata']=true;
						$result['msg']='email_exist';
                        $result['user_details']=$user_details;
					}

				}


				}


			}
            else
            {
			$result['msg'] ='reviewer_email_not_exist';
			$result['email_found'] ='n';
            }
			return  $this->success('success',200,$result);

		}
	}
		catch(\Exception $e)
		{

			return  $this->failure('Failed',500,$e);
		}
}

public function get_reviewer_data(Request $request)
{
    try
    {
        $Users=new \App\Models\User();
        $validator = Validator::make($request->all(), [
			'user_id' => 'required'
		]);

		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
        $post_data=$request->all();
        $user_id=decrypt_link($post_data['user_id']);
        $reviewer = $Users::get_single_record('usr_id,usr_username,usr_email,usr_title,usr_first_name,usr_last_name',"usr_id={$user_id}");
        $return_arr['userdata'] = $reviewer;
        return  $this->success('success',200,$return_arr);

    }
    catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
}

public function get_review_stage_permission(Request $request)
{
    try
    {

        $validator = Validator::make($request->all(), [
			'article_id' => 'required',
		    'aflw_id'=>'required',
			'jnl_id'=>'required',

		]);
		if($validator->fails())
		{
			return  $this->failure('Failed',422,$validator->errors());
		}
        $post_data=$request->all();
         $this->current_user=$this->get_current_user_details();
			$article_id = decrypt_link($post_data['article_id']);
            $jnl_code=$post_data['jnl_code'];
            $jnl_id=decrypt_link($post_data['jnl_id']);
			$flow_id = decrypt_link($post_data['aflw_id']);

            $input_arr = array(
                'input' =>$article_id,
                'type'=> 'number'
            );
            $art_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$flow_id,
                'type'=> 'number'
            );
            $flow_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' =>$jnl_id,
                'type'=> 'number'
            );
            $jnl_id_validate = $this->Rv_validator($input_arr);
            if($art_id_validate === false || $flow_id_validate === false || $jnl_id_validate === false)
	        {
             $arraymsg['mesage'] = customTrans('validation.notvalid');
            return $this->warning("Failed",200,$arraymsg);
            }
			$flow_privilages = $this->get_article_flow_privilages($article_id, $flow_id,$jnl_code,$jnl_id);

         $user_array_invite_shortlist=$this->get_who_can_shortlist_invite_users($flow_privilages,$article_id,$jnl_id,$jnl_code);
            $date_format=$this->get_platform_date_format($jnl_id);
            $date_format=$this->date_format_map($date_format);
            $article_data = $flow_privilages['article_data'];
            $article_flow_details = $flow_privilages['article_flow_details'];
            $user_roles = $flow_privilages['user_roles'];
            $all_roles = $flow_privilages['all_roles'];
            $all_roles = $this->rebuild_array_by_field($all_roles, 'role_id');
            $is_previous=false;
            $show_invited = ($article_flow_details->jwf_assignment == 'invitation' ) ? true : false;
            $assigning_roles = ($article_flow_details->jwf_parent_user_roles != '') ? json_decode($article_flow_details->jwf_parent_user_roles) : array();
            $inviting_roles = ($article_flow_details->jwf_who_can_invite != '') ? json_decode($article_flow_details->jwf_who_can_invite) : array();
            $has_assign_permission = $has_invite_permission = false;

            if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $assigning_roles)) > 0 &&(isset($user_array_invite_shortlist['assigned_user_ids']))&&(in_array($this->current_user['user_id'],$user_array_invite_shortlist['assigned_user_ids'])))
            {
                $has_assign_permission = true;
            }

            if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $inviting_roles)) > 0&&(isset($user_array_invite_shortlist['who_can_invite_user_ids']))&&in_array($this->current_user['user_id'],$user_array_invite_shortlist['who_can_invite_user_ids']))
            {
                $has_invite_permission = true;
            }
            $current_status_id=decrypt_link($post_data['current_status_id']);

			$current_stage_active = ($current_status_id == $article_flow_details->aflw_id) ? true : false;

            if($this->current_client->modules->mdl_review_for_doc == 'n')
            {
                if ($article_flow_details->aflw_status == 'c')
                {
                    if ($article_data->atotp_review_open_decision == "y")
                    {

                        $return_date = $article_flow_details->aflw_returned_date;
                        $added_date = date('Y-m-d h:i:s', strtotime($return_date . ' +' . $article_data->atotp_review_open_count . ' days'));
                        $current_date = date('Y-m-d h:i:s');

                        $date1 = new DateTime($current_date);
                        $date2 = new DateTime($added_date);

                        if ($date1 > $date2)
                        {
                            $enable_button_active = false;
                        }
                    }
                    else
                    {
                        $enable_button_active = false;
                    }
                }
                if ($article_data->art_status != "y" || $is_previous === true)
                {
                    $enable_button_active = false;
                }
                if (($article_flow_details->jwf_fwm_id != $article_data->artp_fwm_id) || ($article_data->art_status == 't'))
                {
                    $enable_button_active = false;
                    $current_stage_active = false;
                }
            }
            elseif($article_flow_details->aflw_status == 'c')
            {
                $enable_button_active = false;
            }

            if($article_flow_details->aflw_more_review_skip_status == 'y' || $article_flow_details->aflw_skip_review == 'y' )
            {
                $enable_button_active = false;
            }
            $enable_button_active = false;
			if ($has_invite_permission === true || $has_assign_permission === true)
			{
				$enable_button_active = true;
			}


            $enable_author_suggested_reviewers=false;
            if(isset($this->current_client->functionality->cfty_shortlist_author_suggested_reviewers)&&($this->current_client->functionality->cfty_shortlist_author_suggested_reviewers == 'y'))		  {
                $Article_reviewers = new \App\Models\Article_reviewers();
                $reviewer_data =$Article_reviewers::get_single_record('count(sorw_id) as cnt', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='s'");
                if($reviewer_data->cnt >0)
                {
                    $enable_author_suggested_reviewers=true;
                }
            }
             $data['enable_author_suggested_reviewers']=$enable_author_suggested_reviewers;

                $flow_id = ($article_flow_details->aflw_parent_flow_id == null) ? $article_flow_details->aflw_id : $article_flow_details->aflw_parent_flow_id;

                $data['current_stage_active'] = $current_stage_active;
                $data['has_assign_permission'] = $has_assign_permission;
                $data['has_invite_permission'] = $has_invite_permission;
                $data['enable_button_active'] = $enable_button_active;
                $data['show_invited'] = $show_invited;
                return  $this->success('success',200,$data);
    }
    catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
}

public function send_mail_to_unassigned_rvr(Request $request)
{
    try{
       $post_data=$request->all();
       $emaildata=$post_data['postdata'];
       $Stage_email_templates=new \App\Models\Stage_email_templates;
       $Users=new \App\Models\User();
       $Article_flow=new \App\Models\Article_flow();
       $Unassign_reviewer=new \App\Models\Unassign_reviewer();
       $Articles=new \App\Models\Articles;

       $this->current_user=$this->get_current_user_details();
       $validator = Validator::make($request->all(), [
        'article_id' => 'required',
        'jnl_id'=>'required',
         'jnl_code'=>'required'
    ]);
    if($validator->fails())
    {
        return  $this->failure('Failed',422,$validator->errors());
    }
    $return_data=array();
    if(isset($emaildata['unassign_reason'])&&$emaildata['unassign_reason']=='')
    {
       return $this->success('warning',200,$return_data);
    }

       $reviewer_id = decrypt_link($post_data['user_ids']);
       $aflw_id=decrypt_link($post_data['rvr_flow_id']);
       $article_id=decrypt_link($post_data['article_id']);
       $jnl_id=decrypt_link($post_data['jnl_id']);
       $jnl_code=$post_data['jnl_code'];
       $input_arr = array(
        'input' =>$article_id,
        'type'=> 'number'
    );
    $art_id_validate = $this->Rv_validator($input_arr);
    $input_arr = array(
        'input' =>$aflw_id,
        'type'=> 'number'
    );
    $flow_id_validate = $this->Rv_validator($input_arr);
    $input_arr = array(
        'input' =>$reviewer_id,
        'type'=> 'number'
    );
    $reviewer_id_validate = $this->Rv_validator($input_arr);

    if($art_id_validate === false || $flow_id_validate === false || $reviewer_id_validate === false )
    {
     $arraymsg['mesage'] = customTrans('validation.notvalid');
    return $this->warning("Failed",200,$arraymsg);
    }

       $post_data['esl_aflw_id'] = decrypt_link($post_data['rvr_flow_id']);

       $article_details = $Articles::get_single_record('*', "art_id={$article_id}");

       $template_id=decrypt_link($post_data['invite_tmpl_name']);
       $condition="stage_etmp_action='unassign_user' AND stage_etmp_id={$template_id}";

       $email_template = $Stage_email_templates::get_single_record('*', $condition);

       if (!empty($email_template))
       {
           $usr_details = $Users::get_single_record("usr_email,usr_id,concat(`usr_title`,' ',  `usr_first_name` ,' ', `usr_last_name` ) as rv_name","usr_id={$reviewer_id}");

           $return_data['msg'] = "Successfully unassigned {$usr_details->rv_name}";



           $insert_data = array(
               'unsn_aflw_id' => $aflw_id,
               'unsn_rvr_id' => $reviewer_id,
               'unsn_reason' =>$emaildata['unassign_reason'],
           );

        

        $Article_flow::update_record(array(
               'aflw_status' => 'g'),"aflw_id={$aflw_id}", $this->current_user);
           $Article_flow::get_single_record('aflw_parent_flow_id,aflw_jwf_id',"aflw_id={$aflw_id}");
           $Unassign_reviewer::insert_record($insert_data, $this->current_user);



           $post_data['art_id'] =  decrypt_link($post_data['article_id']);
           $post_data['unassign_email_reply_to'] =$post_data['postdata']['stage_template_to_mail'];

           if (isset($emaildata['stage_template_to_mail'])) {
            $post_data['unassign_email_reply_to'] = $emaildata['stage_template_to_mail'];
        }
        if (isset($emaildata['stage_template_to_cc'])) {
            $post_data['unassign_tmpl_to_cc'] = $emaildata['stage_template_to_cc'];
        }
        if (isset($emaildata['stage_template_to_bcc'])) {
            $post_data['unassign_tmpl_to_bcc'] = $emaildata['stage_template_to_bcc'];
        }
        // TASK #8733 Reinstate the Reply-to Address Feature for Email Communication
				$optccvalue = array();
				if (isset($emaildata['stage_cust_cc'])&&!empty($emaildata['stage_cust_cc']) && (in_array('Custom_cc',$post_data['postdata']['stage_template_to_cc'])||in_array('Custom',$post_data['postdata']['stage_template_to_cc']))) {
					$custm_cc = $emaildata['stage_cust_cc'];
					for ($i = 0; $i < count($custm_cc); $i++) {
						$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
						$cust_value = str_replace('\\', '"', $cust_value);
						$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

						array_push($optccvalue, $cust_value);


					}
					$post_data['unassign_tmpl_to_cust_cc'] = implode(',', $optccvalue);

				}
				else{
					$post_data['unassign_tmpl_to_cust_cc']='';
				}
				$optbccvalue = array();
				if (isset($emaildata['stage_cust_bcc'])&&!empty($emaildata['stage_cust_bcc']) && (in_array('Custom_bcc',$emaildata['stage_template_to_bcc'])||in_array('Custom',$emaildata['stage_template_to_bcc']))) {
					$custm_bcc = $emaildata['stage_cust_bcc'];
					for ($i = 0; $i < count($custm_bcc); $i++) {
						$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
						$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
						$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

						array_push($optbccvalue, $cust_bcc_value);

					}
					$post_data['unassign_tmpl_to_cust_bcc'] = implode(',', $optbccvalue);
				}
				else{
					$post_data['unassign_tmpl_to_cust_bcc']='';
				}
          $this->send_unassign_email($email_template, $post_data, $article_details, $usr_details,$jnl_id,$jnl_code);
       }
       else
       {
           $return_data['status'] = 'failed';
           $return_data['msg'] ='Email template not found';
       }


       return  $this->success('success',200,$return_data);


    }
    catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
}

public function change_assign_user_count(Request $request)
{
    try
    {
      $post_data=$request->all();
      $result=array();
    $current_user = $this->get_current_user_details();

        $updation_array = array();
        $Articles=new \App\Models\Articles;
        $Article_flow=new \App\Models\Article_flow();
        $Generic_flows=new \App\Models\Generic_flows();
        $Article_custom_reason = new \App\Models\Article_custom_reasons();
        $Article_parallel_flow_movement=new \App\Models\Article_parallel_flow_movement();
        $Email_templates=new \App\Models\Email_templates;
        $aflw_id = decrypt_link($post_data['stage_flow_id']);
        $article_id = decrypt_link($post_data['article_id']);
        $jwf_fwm_id = decrypt_link($post_data['flow_master_id']);
        $jwf_id = decrypt_link($post_data['jwf_id']);
        $jnl_code = $post_data['jnl_code'];
        $jnl_id = $post_data['jnl_id'];
        $core_role = isset($post_data['core_role'])?$post_data['core_role']:'';
        $role_name = isset($post_data['role_name'])?$post_data['role_name']:'';
        $more_rw_reason = isset($post_data['more_rw_reason'])?$post_data['more_rw_reason']:'';
        if (isset($post_data['poststagereviewer'])&&$post_data['poststagereviewer']=== true)
        {

            $hdn_current_status_id = decrypt_link($post_data['current_flow_id']);
            $min_users_count = $post_data['min_rev_count'];
            $max_users_count = $post_data['max_rev_count'];

            if ($min_users_count > $max_users_count)
            {
                $return_data['msg']='Please enter the minimum number of users - ensure this is less than the maximum number';
                return $this->success('warning',200,$return_data);
            }

            if ($min_users_count <= 0 || $max_users_count <= 0)
            {
                $return_data['msg']='Minimum or maximum reviewers cannot be less than 1';
                return $this->success('warning',200,$return_data);
            }

            $aflw_id = decrypt_link($post_data['stage_flow_id']);
            $current_stage_cnt_info = $Article_flow::get_single_record('count(*)as review_submit_cnt','aflw_parent_flow_id='.$aflw_id.' and aflw_status=\'c\'');
            if (!empty($min_users_count) && !empty($max_users_count) && ($min_users_count <= $current_stage_cnt_info->review_submit_cnt))
            {
               
                    $return_data['msg'] = 'Please enter a minimum reviewers value greater than '. $current_stage_cnt_info->review_submit_cnt;
                    return $this->success('warning',200,$return_data);
            }
            $where = 'aflw_id = ' . $aflw_id;
            $updation_array['aflw_returned_date'] = null;
            // $updation_array['aflw_due_date'] = date('Y-m-d H:i:s');
            if(isset($post_data['resume_current_stage']) && $post_data['resume_current_stage'] == 'y' )
            {
                $updation_array['aflw_reopened_flow_id'] = $hdn_current_status_id;
            }
            else
            {
            $updation_array['aflw_reopened_flow_id'] = 0;
            }
            $updation_array['aflw_reopened_min_user_count'] = $min_users_count;
            $updation_array['aflw_more_review_skip_status'] = 'n';
            $updation_array['aflw_skip_review'] = 'n';
           // $condition = 'aflw_id ='.$hdn_current_status_id.' and aflw_art_id='.$article_id.' and aflw_parent_flow_id is NULL';
            $condition = 'aflw_id ='.$hdn_current_status_id.' and aflw_art_id='.$article_id;
            $review_stage_details = $Article_flow::get_single_record('aflw_stage_min_users,aflw_stage_max_users,aflw_jwf_id',"aflw_id={$aflw_id}");

            $review_stage_details->art_id = $article_id;
            $article_types =  Articles::get_single_record('art_artp_id', 'art_id=:article_id',null,'',null,array('article_id'=>$article_id));
            $review_stage_details->artp_id = $article_types->art_artp_id;
            $article_types_data =  Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',null,'',null,array('artp_id'=>$review_stage_details->artp_id));
            $review_stage_details->artp_fwm_id = $article_types_data->artp_fwm_id;
            $article_privilages = $this->article_privilages($review_stage_details, $aflw_id, $jnl_code);
            $isauthor = $article_privilages['author'];
            $isreviewer=$article_privilages['reviewer'];
            $user_allocated=$article_privilages['user_allocated'];
            if($isauthor=== true || ($isreviewer=== true && $user_allocated == false))
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }

            $aflw_resume_source_of = $aflw_id;
            $current_min_max_count = array(
                $review_stage_details->aflw_stage_min_users,
                $review_stage_details->aflw_stage_max_users,
                $current_stage_cnt_info->review_submit_cnt);
            $change_status_arr = array(
                'aflw_resume_source_of' => $aflw_resume_source_of,
                'aflw_reopened_stage_min_max_count' => json_encode($current_min_max_count),
                'aflw_status' => 'h'
            );
            $Article_flow::update_record($change_status_arr, $condition, $current_user);

            $this->active_parallel_flow($article_id,$review_stage_details->aflw_jwf_id);
            /* Redirection link */


            $stage_roles = $Generic_flows::get_single_record('jwf_parent_user_roles,jwf_who_can_invite,jwf_tat_complete',"jwf_id={$review_stage_details->aflw_jwf_id}");
            $updation_array['aflw_due_date'] = $this->get_due_date_for_article($article_id, $stage_roles->jwf_tat_complete);
            $article_details = $Articles::get_single_record('art_artp_id',"art_id={$article_id}");
            $invite_roles = json_decode($stage_roles->jwf_who_can_invite, true);
            $assign_roles = json_decode($stage_roles->jwf_parent_user_roles, true);
            $user_roles = $this->validate_user_journal($jnl_code, $current_user['user_id'], $article_details->art_artp_id);
            $result1 = array_intersect($user_roles['role_id'], $invite_roles);
            $result2 = array_intersect($user_roles['role_id'], $assign_roles);

            if (!empty($result1) || !empty($result2))
            {
                $redirect='viewarticle';
            }
            else
            {
                $redirect='dashboard';
            }
            $result['redirect'] = $redirect;
            $jnl_data=array(
                'jnl_code'=>$jnl_code,
                'jnl_id'=>$jnl_id,
                'core_role'=>$core_role,
                'core_role_name'=>$role_name,
            );

            $record = $Email_templates::get_single_record('*',  "etmp_name='reopen_review' and etmp_notification='Users'");
            if ($record != null)
            {
                $this->send_review_reopen_mail($article_id, $jwf_id, $hdn_current_status_id, $record,$jnl_data);
            }
            $review_record = $Email_templates::get_single_record('*', "etmp_name='article_more_reviewers_mail' and etmp_notification='User'");

            if($post_data['stage_etmp_subject']){
                $review_record->etmp_subject =$post_data['stage_etmp_subject'];
            }
            if($post_data['stage_etmp_content']){
                $review_record->etmp_email_template =$post_data['stage_etmp_content'];
            }
            
            if ($review_record != null)
            {
               $this->send_review_reopen_mail($article_id, $jwf_id, $hdn_current_status_id, $review_record,$jnl_data,$post_data);
            }
            
        }
        else
        {
            $flow_details = $Article_flow::get_single_record('aflw_reopened_min_user_count,aflw_reopened_flow_id,aflw_jwf_id',"aflw_id={$aflw_id}");

            $min_users_count =$post_data['min_user_count'];
            $max_users_count =$post_data['max_user_count'];
            if ($min_users_count > $max_users_count)
            {
                $return_data['msg']='Please enter the minimum number of users - ensure this is less than the maximum number';
                return $this->success('warning',200,$return_data);

            }

            if ($min_users_count <= 0 || $max_users_count <= 0)
            {
                $return_data['msg']='Minimum or maximum reviewers cannot be less than 1';
                return $this->success('warning',200,$return_data);

            }
            if (!empty($flow_details))
            {
                if (isset($flow_details->aflw_reopened_flow_id) && ($flow_details->aflw_reopened_flow_id != null || $flow_details->aflw_reopened_flow_id == 0) && $flow_details->aflw_reopened_min_user_count > 0 && ($min_users_count < $flow_details->aflw_reopened_min_user_count))
                {

                        $return_data['msg']='You cannot reduce the minimum number of reviewers to less than the minimum set for this article';
                        return $this->success('warning',200,$return_data);

                }
            }


            $where = 'aflw_id = ' . $aflw_id;
        }
        $updation_array['aflw_stage_min_users'] = $min_users_count;
        $updation_array['aflw_stage_max_users'] = $max_users_count;

        $Article_flow::update_record($updation_array, $where, $current_user);

        if($more_rw_reason != '')
        {
            $custom_reason_arr = array(
                'cusr_art_id' =>$article_id,
                'cusr_aflw_id' => $aflw_id,
                'cusr_action_type' =>'more_review',
                'cusr_reason' => $more_rw_reason
            );
               $Article_custom_reason::insert_record($custom_reason_arr,$current_user);
        }
        $result['status'] = 'success';
        $result['message'] = 'Number of reviewers successfully changed.';
        $parallel_stage_completed=false;
           $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        /* get completed child stage count */
        if (isset($post_data['poststagereviewer'])&&$post_data['poststagereviewer']=== false)
        {
            $current_stage=$Article_flow::get_single_record("aflw_level","aflw_parent_flow_id={$aflw_id}");
            $completed_child = $Article_flow::get_single_record('count(aflw_id) as count',"aflw_parent_flow_id={$aflw_id} AND aflw_status='c'");
            //1.minimum or maximise


            if ($completed_child->count >= $min_users_count)
            {
                $next_stage = $this->get_next_stages($jwf_id, $jwf_fwm_id, $article_id,false,$review_flow);
                $status='c';
                $this->update_parallel_flow($article_id,$jwf_id,$next_stage,$status);
                if(count($next_stage['stages'])==0)
                {
                    $where_condition='apfm_travel_path_ids='.$jwf_id.' and aflw_art_id='. $article_id;
                    $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
                    $get_path_jwf =$Article_parallel_flow_movement::get_path_having_workflow($select,$where_condition,'');
                    if(!empty($get_path_jwf))
                    {
                        $end_stgdate = $get_path_jwf[0]->apfm_end_stg_jwf_id;
                        if(!empty($end_stgdate))
                        {
                            $stg_record=$Generic_flows::get_single_record('jwf_stage_name',"jwf_id={$end_stgdate}");
                            $result['stage_name'] =$stg_record->jwf_stage_name;
                        }
                    }
                }


                $next_stage_present = false;
                if(count($next_stage['stages'])>0)
                {
                    foreach ($next_stage['stages'] as $stg)
                    {
                        $next_stage_count = $Article_flow::get_single_record('count(aflw_id) as count,group_concat(aflw_id) as aflw_ids',"aflw_jwf_id={$stg['stage_id']} AND aflw_art_id={$article_id} AND aflw_level={$current_stage->aflw_level}");
                        //if ($next_stage_count->count > 0 && $next_stage_move ==  true)
                        if ($next_stage_count->count > 0)
                        {
                            $next_stage_present = true;
                            break;
                        }

                        $where_condition ="aflw_art_id={$article_id} AND apfm_status='a' AND apfm_end_stg_jwf_id={$stg['stage_id']}";
                        $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
                        $get_path_having_jwf =$Article_parallel_flow_movement::get_path_having_workflow($select,$where_condition,'');

                        if(count($get_path_having_jwf)==0)
                        {
                            $parallel_stage_completed=true;
                        }

                    }
                }
                if($next_stage_present === true)
                {
                    $parallel_stage_completed=true;
                }

                if($next_stage_present === false ||  $parallel_stage_completed === true)
                {
                    if(count($next_stage['stages'])>0)
                    {
                        foreach ($next_stage['stages'] as $stg)
                        {
                            $flow_records = $Article_flow::get_single_record('group_concat(aflw_id) as aflw_ids',"aflw_jwf_id={$stg['stage_id']} AND aflw_art_id={$article_id} and aflw_status='h'");
                            if(isset($flow_records->aflw_ids))
                            {
                                $where="aflw_id IN (".$flow_records->aflw_ids.")";
                                Article_flow::update_record(array('aflw_status'=>'a'), $where, $current_user);
                            }
                        }
                    }
                }
                $result['parallel_stage_completed'] = $parallel_stage_completed;
                $result['next_stage'] = $next_stage;
                $result['move_stage'] = $next_stage_present ? false : true;
                $result['message'] .= ' Stage eligible to move next stage.';
            }
            else
            {

                $current_stage = $Article_flow::get_single_record('aflw_level',"aflw_id={$aflw_id}");
                $status='a';

                $next_stage = $this->get_next_stages($jwf_id, $jwf_fwm_id, $article_id,false,$review_flow);

                $next_stage_present = false;
                if(isset($next_stage['stages']))
                {
                    foreach ($next_stage['stages'] as $stg)
                    {
                        $next_stage_count = $Article_flow::get_single_record('count(aflw_id) as count',"aflw_jwf_id={$stg['stage_id']} AND aflw_art_id={$article_id} AND aflw_level>={$current_stage->aflw_level}");
                        //if ($next_stage_count->count > 0 && $next_stage_move ==  true)
                        if ($next_stage_count->count > 0)
                        {
                            $next_stage_present = true;
                            $status='c';
                            break;
                        }

                    }
                }
                if($next_stage_present === false)
                {
                    $this->active_parallel_flow($article_id,$jwf_id);
                }
            }

        }

        return $this->success('success',200,$result);

}
catch(\Exception $e)
{

    return  $this->failure('Failed',500,$e);
}
}
public function send_reviewer_resubmit(Request $request)
{
    try
    {
    $post_data = $request->all();
    $return_data['status'] = 'failed';
    // validate post data
    $current_stage_id = decrypt_link($post_data['current_status_id']);
    $jnl_code=$post_data['jnl_code'];
    $jnl_id=decrypt_link($post_data['jnl_id']);
    $user_id = decrypt_link($post_data['user_ids']);
    $email_post_data=$post_data['postdata'];
    $article_id = decrypt_link($post_data['article_id']);
    $reviewer_flow_id=decrypt_link($post_data['rvr_flow_id']);
    $Article_reviewers=new \App\Models\Article_reviewers;
    $Article_flow=new \App\Models\Article_flow;
    $Article_generic_form_data_temp=new \App\Models\Article_generic_form_data_temp;
    $Article_generic_form_data=new \App\Models\Article_generic_form_data;
    $Email_templates=new \App\Models\Email_templates;
    $article_flow_table=(new \App\Models\Article_flow())->getTable();
    $jnl_flow_table=(new \App\Models\Generic_flows())->getTable();
        $review_method='';
        $c_params=null;
        $current_user = $this->get_current_user_details();;
        $formatted_journalcode = '_'.decrypt_link($jnl_code);
        //check this form is added as populate data in any another form, then gdata and temp data check that form exist. Yes, get the content and remove current data & update
        $sql="select jwf_forms,jwf_fwm_id,aflw_art_id from {$jnl_flow_table} left join {$article_flow_table} on jwf_id=aflw_jwf_id where aflw_id=".$current_stage_id;
        $forms=$Article_flow::get_records_by_raw_query($sql);

        if(!empty($forms))
        {
            foreach($forms as $form)
            {
                $art_id=$form->aflw_art_id;
                $form_ids=implode(',',json_decode($form->jwf_forms,true));
                $sql='select emt_gucf_id,emt_source_elementid from rvw_generic_forms left join rvw_generic_form_elements on gncf_id=emt_gucf_id where emt_populate_data=1 and emt_source_formid IN("'.$form_ids.'")';
                $form_element=$Article_flow::get_records_by_raw_query($sql);
                if(!empty($form_element))
                {
                    foreach($form_element as $form_ele)
                    {
                        $frm_id =$form_ele->emt_gucf_id;
                        $source_elemnt=$form_ele->emt_source_elementid;
                        $where='gdata_art_id='.$art_id.' and gdata_atf_id='.$frm_id;
                        $main_record = $Article_generic_form_data::get_generic_form_stage_elements($formatted_journalcode, '*', $where);
                        if(empty($main_record))
                        {
                            //editor data
                            $where='gdata_art_id='.$art_id.' and gdata_atf_id='.$frm_id;
                            $temp_records = $Article_generic_form_data_temp::get_all_records('gdata_data,gdata_display_data,gdata_atfemt_id', $where);

                            if(!empty($temp_records))
                            {
                                foreach($temp_records as $temp)
                                {
                                    $gdata_display_data=$temp->gdata_display_data;
                                    $where='gdata_art_id='.$art_id.' and gdata_atf_id IN ('.$form_ids.') and gdata_atfemt_id='.$source_elemnt.' and gdata_posted_by='.$user_id;
                                    $current_records = $Article_generic_form_data::get_generic_form_stage_elements($formatted_journalcode, 'gdata_display_data', $where);
                                    if(!empty($current_records))
                                    {
                                    foreach($current_records as $current_record)
                                        {
                                            $review_data=strip_tags($current_record->gdata_display_data);
                                            if (!empty($review_data) && !empty($gdata_display_data) && strpos($gdata_display_data, $review_data) !== false)
                                            {
                                                $sql='select atotp_review_method, atotp_custom_blind_params from rvw_article_type_advance_options left join rvw_articles on atotp_artp_id=art_artp_id where art_id='.$art_id;
                                                $method_review=$Article_flow::get_records_by_raw_query($sql);
                                                if(!empty($method_review))
                                                {
                                                    $review_method=$method_review[0]?->atotp_review_method;
                                                    $c_params = $method_review[0]?->atotp_custom_blind_params;
                                                    if($review_method == 'o' || ($review_method == 'c' && $c_params == null))
                                                    {
                                                        $displayarray=array();
                                                        $displayarray['user_id']=$user_id;
                                                        $displayarray['salutation']=true;
                                                        $displayarray['fullname_only']=true;
                                                        $displayarray['journal_id']=$jnl_id;
                                                        $displayarray['article_id']=$art_id;
                                                        $user_full_name = $this->get_user_display_name( $displayarray);
                                                        $gdata_display_data =str_replace($user_full_name,"",$gdata_display_data);
                                                        $gdata_display_data =str_replace($review_data,"",$gdata_display_data);
                                                    }
                                                    else
                                                    {
                                                        $str_start=strpos($gdata_display_data, $review_data)-4;
                                                        $str_end=strpos($gdata_display_data, $review_data)-2;
                                                        $remaing=substr($gdata_display_data, $str_start,$str_end);
                                                        $remaing=preg_replace('/[^0-9]/', '', $remaing);
                                                        $gdata_display_data =str_replace("Reviewer #".$remaing,"",$gdata_display_data);
                                                        $gdata_display_data =str_replace($review_data,"",$gdata_display_data);
                                                    }
                                                    $update=array('gdata_data'=>$gdata_display_data,
                                                                        'gdata_display_data'=>$gdata_display_data);
                                                        $Article_generic_form_data_temp::update_record($update, "gdata_art_id={$art_id} AND gdata_atf_id={$frm_id}",$current_user);
                                                }
                                            }
                                        }
                                    }
                                    //ord_tempdata
                                    if($review_method==='o'  || ($review_method == 'c' && $c_params == null))
                                    {
                                    $up ="gdata_art_id=".$art_id." and gdata_atf_id=".$frm_id.' and gdata_display_data like "%Reviewer%"';
                                    $record=$Article_generic_form_data_temp::get_single_record('gdata_display_data',$up);
                                    if(!empty($record))
                                    {
                                        $gdata_display_data=$record->gdata_display_data;
                                        $data=explode('#',$gdata_display_data);
                                        $gdata_display_data_up='';
                                        if(count($data)>2)
                                        {
                                            for($i=1; $i<count($data); $i++)
                                            {
                                                $num =preg_replace('/[^0-9]/', "", $data[$i]);
                                                $gdata_display_data_up.=str_replace($num,$i,$data[$i]);
                                            }
                                        }
                                        else{
                                            for($i=1; $i<count($data); $i++)
                                            {
                                            $num =preg_replace('/[^0-9]/',"", $data[$i]);
                                            $gdata_display_data_up.=str_replace($num,"",$data[$i]);
                                            }
                                        }
                                        $update=array('gdata_data'=>$gdata_display_data_up,
                                                    'gdata_display_data'=>$gdata_display_data_up);

                                        $Article_generic_form_data_temp::update_record($update,"gdata_art_id={$art_id} AND gdata_atf_id={$frm_id}",$current_user);
                                    }
                                    }

                                }
                            }
                        }
                        else{
                            foreach($main_record as $record)
                            {
                                $gdata_display_data=$record->gdata_display_data;
                                $where='gdata_art_id='.$art_id.' and gdata_atf_id IN ('.$form_ids.') and gdata_atfemt_id='.$source_elemnt.' and gdata_posted_by='.$user_id;
                                $current_records = $Article_generic_form_data::get_generic_form_stage_elements($formatted_journalcode, 'gdata_display_data', $where);
                                if(!empty($current_records))
                                {
                                    foreach($current_records as $current_record)
                                    {
                                        $review_data=strip_tags($current_record->gdata_display_data);

                                        if (strpos($gdata_display_data, $review_data) !== false)
                                        {
                                            $sql='select atotp_review_method, atotp_custom_blind_params from rvw_article_type_advance_options left join rvw_articles on atotp_artp_id=art_artp_id where art_id='.$art_id;
                                            $review_method=$Article_flow::get_records_by_raw_query($sql);
                                            if(!empty($review_method))
                                            {
                                                if($review_method[0]->atotp_review_method=='o' || ($review_method[0]->atotp_review_method=='c' && $review_method[0]->atotp_custom_blind_params == null))
                                                {
                                                    $displayarray=array();
                                                    $displayarray['user_id']=$user_id;
                                                    $displayarray['salutation']=true;
                                                    $displayarray['fullname_only']=true;
                                                    $displayarray['journal_id']=$jnl_id;
                                                    $displayarray['article_id']=$art_id;
                                                    $user_full_name = $this->get_user_display_name($displayarray);
                                                    $gdata_display_data =str_replace($user_full_name,"",$gdata_display_data);
                                                    $gdata_display_data =str_replace($review_data,"",$gdata_display_data);
                                                }
                                                else
                                                {
                                                    $str_start=strpos($gdata_display_data, $review_data)-4;
                                                    $str_end=strpos($gdata_display_data, $review_data)-2;
                                                    $remaing=substr($gdata_display_data, $str_start,$str_end);
                                                    $remaing=preg_replace('/[^0-9]/', '', $remaing);
                                                    $gdata_display_data =str_replace("Reviewer #".$remaing,"",$gdata_display_data);
                                                    $gdata_display_data =str_replace($review_data,"",$gdata_display_data);
                                                }
                                                $update=array('gdata_data'=>$gdata_display_data,
                                                                    'gdata_display_data'=>$gdata_display_data);
                                                    $Article_generic_form_data::update_record($update,"gdata_art_id={$art_id} AND gdata_atf_id={$frm_id}");
                                            }
                                        }
                                    }
                                }
                                //ord_tempdata
                                $up ="gdata_art_id=".$art_id." and gdata_atf_id=".$frm_id.' and gdata_display_data like "%Reviewer%"';
                                $record=$Article_generic_form_data::get_single_record('gdata_display_data',$up);
                                if(!empty($record))
                                {
                                    $gdata_display_data=$record->gdata_display_data;
                                    $data=explode('#',$gdata_display_data);
                                    $gdata_display_data_up='';
                                    if(count($data)>2)
                                    {
                                        for($i=1; $i<count($data); $i++)
                                        {
                                            $num =preg_replace('/[^0-9]/', "", $data[$i]);
                                            $gdata_display_data_up.=str_replace($num,$i,$data[$i]);
                                        }
                                    }
                                    else{
                                        for($i=1; $i<count($data); $i++)
                                        {
                                        $num =preg_replace('/[^0-9]/',"", $data[$i]);
                                        $gdata_display_data_up.=str_replace($num,"",$data[$i]);
                                        }
                                    }
                                    $update=array('gdata_data'=>$gdata_display_data_up,
                                                                    'gdata_display_data'=>$gdata_display_data_up);

                                    $Article_generic_form_data::update_record($update,"gdata_art_id={$art_id} AND gdata_atf_id={$frm_id}", $current_user, $formatted_journal_code);
                                }
                            }
                        }
                    }

                }
            }
        }

        $template =$Email_templates::get_single_record('*',"etmp_name='reopen_review' AND etmp_notification='User'");
        $invite_user_data = $Article_flow::get_single_record('*',"aflw_usr_id={$user_id} AND aflw_parent_flow_id={$current_stage_id} AND aflw_id={$reviewer_flow_id}");

        if (!empty($invite_user_data))
        {

            $select = 'jwf_tat_complete,jwf_role_id,aflw_usr_id,aflw_status,jwf_stage_type,aflw_stage_min_users';
            $article_flow_details = $Article_flow::get_stage_details("aflw_id={$current_stage_id}", $select);


            $today = date('Y-m-d H:i:s', time());
            $due_date = new DateTime($today);
            $date_format_org=$this->get_platform_date_format($jnl_id);
            $date_format_org=$this->date_format_map($date_format_org);
            $due_date = $this->get_due_date_for_article($article_id, $article_flow_details->jwf_tat_complete, );


             $up_flw_id = $invite_user_data->aflw_id;
            $update_result = $Article_flow::update_record(array(
                'aflw_status' => 'a',
                'aflw_usr_review_reopen' => 'y',
                'aflw_remarks' => $email_post_data['reopen_reason'],
                'aflw_due_date' => $due_date),"aflw_id={$up_flw_id}", $current_user);

            $Article_reviewers::update_record(array(
                'sorw_invited_by' => $current_user['user_id'],
                'sorw_invited_on' => $today),"sorw_aflw_id={$up_flw_id}", $current_user);

            if (!empty($update_result))
            {

                $return_data['status'] = 'success';

            }

            if (!empty($update_result) && $template != null)
            {
                // TASK #8948 The reopen mail is not being sent to the CC and BCC specific email addresses configured by the super admin.
                $post_stage_cust_cc=isset($post_data['postdata']['stage_cust_cc'])?$post_data['postdata']['stage_cust_cc']:'';
                $post_stage_cust_bcc=isset($post_data['postdata']['stage_cust_bcc'])?$post_data['postdata']['stage_cust_bcc']:'';
                $optccvalue = array();
                if (isset($post_data['postdata']['stage_cust_cc'])&&!empty($post_data['postdata']['stage_cust_cc']) && (in_array('Custom_cc',$post_data['postdata']['stage_template_to_cc'])||in_array('Custom',$post_data['postdata']['stage_template_to_cc']))) {
                    $custm_cc = $post_stage_cust_cc;
                    for ($i = 0; $i < count($custm_cc); $i++) {
                        $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                        $cust_value = str_replace('\\', '"', $cust_value);
                        $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
    
                        array_push($optccvalue, $cust_value);
    
    
                    }
                    $post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);
    
                }
                else{
                    $post_data['postdata']['stage_cust_cc']='';
                }
                $optbccvalue = array();
                if (isset($post_data['postdata']['stage_cust_bcc'])&&!empty($post_data['postdata']['stage_cust_bcc']) && (in_array('Custom_bcc',$post_data['postdata']['stage_template_to_bcc'])||in_array('Custom',$post_data['postdata']['stage_template_to_bcc']))) {
                    $custm_bcc = $post_stage_cust_bcc;
                    for ($i = 0; $i < count($custm_bcc); $i++) {
                        $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                        $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                        $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);
    
                        array_push($optbccvalue, $cust_bcc_value);
    
                    }
                    $post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
                }
                else{
                    $post_data['postdata']['stage_cust_bcc']='';
                }
                
                    if(isset($attachments)){
                        $post_data['postdata']['attachments'] = $attachments;
                        $post_data['postdata']['files_attached'] = $files_attached;
                    }
                $email_data=array(
                    'type'=>'custom',
                    'action'=>'send',
                    'email_temp'=>'global',
                    'email_with_login'=>true,
                    'article_id'=>$art_id,
                    'user_id'=> $user_id,
                    'aflw_id'=>$reviewer_flow_id,
                    'post_data'=>$post_data,
                    'template'=> 'reopen_review',
                    'jnl_user_role'=>array(
                        // 'core_role'=>$core_role,
                        // 'role_name'=>$jnl_array['role_name'],
                        'jnl_id'=> $jnl_id,
                        'jnl_journal_code'=> $jnl_code
                    ),
                );

                $this->master_email_details($email_data);

            }
        }
    return  $this->success('Success', 200, $return_data);
}
catch(\Exception $e)
{
    return  $this->failure('Failed',500,$e);
}
}

public function get_shortlisted_user(Request $request)
{

  try{
      $post_data=$request->all();

      $art_id = decrypt_link($post_data['art_id']);
      $parent_flow = decrypt_link($post_data['parent_flow']);
      $user_id = decrypt_link($post_data['userid']);
      $type = $post_data['type'];
      $jnl_code=$post_data['jnl_code'];
      $jnl_id=decrypt_link($post_data['jnl_id']);
      /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
      if(isset($post_data['aflw_id']))
      {
      $flow_id = decrypt_link($post_data['aflw_id']);
      }
      /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
      $invited_user = '';
      $Article_alternativereviewer_priority_settings=new \App\Models\Article_alternativereviewer_priority_settings;
      $Article_flow=new \App\Models\Article_flow;
      $article_flow_table=(new \App\Models\Article_flow())->getTable();
      $article_reviewers_table=(new \App\Models\Article_reviewers())->getTable();
      $article_flow_alternativereviewer_priorityorder_order_table=(new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
      $article_user_alternativereviewer_priorityorder_order_table=(new \App\Models\Article_user_alternativereviewer_priorityorder())->getTable();
      $article_autoinvitation_emails=(new \App\Models\Article_autoinvitation_emails())->getTable();
      $sql_joined_assigned=" FROM {$article_flow_table} as af
      JOIN {$article_reviewers_table} ON sorw_aflw_id=af.aflw_id";

      $priority_setting_condition =" aaps_art_id={$art_id} AND aaps_parent_flow_id={$parent_flow}";
      /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
      if(isset($post_data['pool_id']) && isset($post_data['pool_workflow_assignment_desination_id']) && isset($post_data['pool_workflow_assignment_source_id']))
      {
          $pool_id =  Rv_decrypt($post_data['pool_id']);
          $destination_id =  Rv_decrypt($post_data['pool_workflow_assignment_desination_id']);
      }

      if ($type == "user")
      {

          $select = 'sorw_id,aflw_id,aflw_usr_id,aflw_art_id,aflw_status,sorw_suggested_user_id';
          $assg_criteria = " WHERE aflw_parent_flow_id={$parent_flow} AND aflw_status='u'";
          $assg_criteria_priorty =" WHERE aflw_parent_flow_id={$parent_flow} AND aflw_status='u'
          AND auap_usr_id={$user_id} AND auap_art_id={$art_id}";
          if(isset($pool_id))
          {
              $assg_criteria = " WHERE aflw_art_id={$art_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id={$pool_id} AND aflw_status='u'";
              $assg_criteria_priorty =" WHERE aflw_art_id={$art_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id={$pool_id} AND aflw_status='u' AND auap_usr_id={$user_id} AND auap_art_id={$art_id}";
              $priority_setting_condition =" aaps_art_id={$art_id} AND aaps_aflw_id={$flow_id}";
          }
          $build_assign_sql=" SELECT {$select} {$sql_joined_assigned} {$assg_criteria}";
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */

          $assigned_users=$Article_flow::get_records_by_raw_query($build_assign_sql);
          if (!empty($assigned_users))
          {

              foreach ($assigned_users as $assg)
              {
                $array_data['user_id']=$assg->aflw_usr_id;
                $array_data['journal_id']=$jnl_id;
                $array_data['flag']=true;
                $array_data['article_id']=$art_id;
                $array_data['jnl_code']=$jnl_code;
                $assg->short_listed_user = $this->get_user_display_name($array_data);

              }
          }




		/* Task #3044 , Ability for AEs to shortlist reviewers during Pre-Review bug fix
         $assg_criteria_priorty =" WHERE aflw_parent_flow_id={$parent_flow} AND aflw_status='u'
         AND auap_usr_id={$user_id} AND auap_art_id={$art_id}"; // commented due to code over riding   */
     $priority_sql="SELECT
     sorw_id,
     aflw_id,
     aflw_usr_id,
     aflw_art_id,
     aflw_status,
     sorw_suggested_user_id,
     auap_id,
     auap_number,
     aae_id
   FROM
     {$article_flow_table} AS af
   JOIN
   {$article_reviewers_table}
   ON
     sorw_aflw_id = af.aflw_id
   JOIN
     {$article_user_alternativereviewer_priorityorder_order_table}
   ON
   auap_aflw_id = af.aflw_id
   LEFT JOIN
     {$article_autoinvitation_emails}
   ON
     aae_auap_id = auap_id {$assg_criteria_priorty}";
          $priority_users=$Article_flow::get_records_by_raw_query($priority_sql);
          $priorityuser_array = array();
          foreach ($priority_users as $priority_user)
          {
              array_push($priorityuser_array, $priority_user->aflw_usr_id);
              $array_data['user_id']=$priority_user->aflw_usr_id;
              $array_data['journal_id']=$jnl_id;
              $array_data['flag']=true;
              $array_data['article_id']=$art_id;
              $array_data['jnl_code']=$jnl_code;
              $priority_user->short_listed_user = $this->get_user_display_name($array_data);

          }

          $array_data['user_id']=$user_id;
          $array_data['journal_id']=$jnl_id;
          $array_data['flag']=true;
          $array_data['article_id']=$art_id;
          $array_data['jnl_code']=$jnl_code;
          $array_data['fullname_only']=true;
          $invited_user = $this->get_user_display_name($array_data);
          $priority_setting_condition .=" AND aaps_usr_id={$user_id} AND aaps_priority_type='u'";
      }

      else
      {
        $select = 'sorw_id,aflw_id,aflw_usr_id,aflw_art_id,aflw_status,sorw_suggested_user_id';
        $assg_criteria = " WHERE aflw_parent_flow_id={$parent_flow} AND aflw_status='u'";
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
        $assg_flow_criteria_priorty =" WHERE aflw_parent_flow_id={$parent_flow} AND aflw_status='u' AND afap_art_id={$art_id}";
        if(isset($pool_id))
        {
            $assg_criteria = " WHERE aflw_art_id={$art_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id={$pool_id} AND aflw_status='u'";
            $assg_flow_criteria_priorty =" WHERE aflw_art_id={$art_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id={$pool_id} AND aflw_status='u'";
            $priority_setting_condition =" aaps_art_id={$art_id} AND aaps_pool_id={$pool_id} AND aaps_destination_id={$destination_id}";
        }
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
        $build_assign_sql=" SELECT {$select} {$sql_joined_assigned} {$assg_criteria}";

        $assigned_users=$Article_flow::get_records_by_raw_query($build_assign_sql);

          if (!empty($assigned_users))
          {

              foreach ($assigned_users as $assg)
              {
                $array_data['user_id']=$assg->aflw_usr_id;
                $array_data['journal_id']=$jnl_id;
                $array_data['flag']=true;
                $array_data['article_id']=$art_id;
                $array_data['jnl_code']=$jnl_code;
                $assg->short_listed_user = $this->get_user_display_name($array_data);
              }
          }


		/* Task #3044 , Ability for AEs to shortlist reviewers during Pre-Review bug fix
         $assg_flow_criteria_priorty =" WHERE aflw_parent_flow_id={$parent_flow} AND aflw_status='u'
         AND afap_art_id={$art_id}"; // commented due to code over riding  */
$priority_sql="SELECT
sorw_id,
aflw_id,
aflw_usr_id,
aflw_art_id,
aflw_status,
sorw_suggested_user_id,
afap_id,
afap_number,
aae_id
FROM
{$article_flow_table} AS af
JOIN
{$article_reviewers_table}
ON
sorw_aflw_id = af.aflw_id
JOIN
{$article_flow_alternativereviewer_priorityorder_order_table}
ON
afap_aflw_id = af.aflw_id
LEFT JOIN
{$article_autoinvitation_emails}
ON
aae_afap_id = afap_id {$assg_flow_criteria_priorty} ORDER BY afap_number ASC";


                $priority_users = $Article_flow::get_records_by_raw_query($priority_sql);
          $priorityuser_array = array();

          foreach ($priority_users as $priority_user)
          {
              array_push($priorityuser_array, $priority_user->aflw_usr_id);
              $array_data['user_id']=$priority_user->aflw_usr_id;
              $array_data['journal_id']=$jnl_id;
              $array_data['flag']=true;
              $array_data['article_id']=$art_id;
              $array_data['jnl_code']=$jnl_code;
              $priority_user->short_listed_user = $this->get_user_display_name($array_data);
          }
          $priority_setting_condition .=" AND aaps_priority_type='p'";

      }

      $priority_settings = $Article_alternativereviewer_priority_settings::get_single_record('aaps_multiple_invitation_status	as multiple_invitation ', $priority_setting_condition);

      $status = 'n';
      if (isset($priority_settings->multiple_invitation))
      {
          $status = $priority_settings->multiple_invitation;
      }
      $return_arr['status'] = 'success';
      $return_arr['shortlistuser']=$assigned_users;
      $return_arr['priorityuser']=$priority_users;
      $return_arr['priority_userslist']=$priorityuser_array;
      $return_arr['parent_flow_id']=$parent_flow;
      $return_arr['article_id']=$art_id;
      $return_arr['type']=$type;
      $return_arr['multiple_invitation_status']=$status;

      $return_arr['invite_user_name'] = $invited_user;
      return  $this->success('Success', 200, $return_arr);


  }
    catch(\Exception $e)
{

    return  $this->failure('Failed',500,$e);
}
}
public function change_priority(Request $request)
{
    try
    {
    $current_user=$this->get_current_user_details();
    $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder;
    $Article_autoinvitation_emails=new \App\Models\Article_autoinvitation_emails;
    $post_data = $request->all();
    $data_removed = '';
    $priority_id = decrypt_link($post_data['priority_id']);
    $ordering_lst = $post_data['ordering_lst'];
    $art_id = decrypt_link($post_data['art_id']);
    $user_id = decrypt_link($post_data['user_id']);
    $type = $post_data['type'];
    $flow_id = isset($post_data['flow_id']) ? decrypt_link($post_data['flow_id']) : '';
    if (($key = array_search($user_id, $ordering_lst)) !== false)
    {
        unset($ordering_lst[$key]);
    }
    if ($priority_id != null && $art_id != null)
    {
        if ($type == "all")
        {
            $column_prefix = 'afap_';
            $Article_flow_alternativereviewer_priorityorder::delete_records("{$column_prefix}id={$priority_id}",'',$current_user);
            $Article_autoinvitation_emails::delete_records("aae_afap_id={$priority_id}",'',$current_user);
            if($flow_id != ''){
                $art_details["art_id"]=$art_id;
                $art_details["art_user_id"]=$user_id;
                $art_details["art_flow_id"]=$flow_id;
                $art_details["notify_get_type"]='a';
                $data_removed = $this->auto_delete_notification_templates_and_corresponding_attachments($art_details,'notification');
            }
        }

        $i = 1;
        if (!empty($ordering_lst))
        {
            foreach ($ordering_lst as $rev_order)
            {
                $userdata=explode("##",$rev_order['id']);
                $reviwer_id=$userdata[0];
                $afap_id = $userdata[3];
                $order = $i;
                $rev_order = $data = array(
                    $column_prefix . 'number' => $i
                );
                $update_condition ="afap_id={$afap_id} AND afap_usr_id={$reviwer_id} AND afap_number!={$order} AND afap_art_id={$art_id}";

                $Article_flow_alternativereviewer_priorityorder::update_record($data, $update_condition,$current_user);
                $i++;

            }
        }
        $return_arr['priority_id'] = encrypt_link($priority_id);
        $return_arr['user_id'] = encrypt_link($user_id);
        $return_arr['status'] = 'success';
        $return_arr['flag'] = $data_removed;
        return  $this->success('Success', 200, $return_arr);
    }
    else
    {
        $return_arr['failed'] = 'fail';
    }

}
catch(\Exception $e)
{

    return  $this->failure('Failed',500,$e);
}
}
public function update_reviewer_priority(Request $request)
{

try
{
        $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder;
        $current_user=$this->get_current_user_details();
    $post_data = $request->all();

    $user_id = decrypt_link($post_data['user_id']);
    $art_id = decrypt_link($post_data['art_id']);
    $flow_id = decrypt_link($post_data['flow_id']);
    $art_reviewer_id = decrypt_link($post_data['art_reve_id']);
    $ordering_lst = $post_data['ordering_lst'];
    $parent_flow_id = decrypt_link($post_data['parent_flow_id']);
    //alternate reviewer darg bug fix priya george
    $priority_id = isset($post_data['priority_id']) ? decrypt_link($post_data['priority_id']) : '';
    $type = $post_data['type'];

    $new_prioity = false;
    $changed_priority_id = $priority_id;
    if ($type == "all")
    {
        $column_prefix = 'afap_';
        if ($priority_id == '')
        {
            $data_reviewer = array(
                $column_prefix . "usr_id" => $user_id,
                $column_prefix . "art_id" => $art_id,
                $column_prefix . "aflw_id" => $flow_id,
                $column_prefix . "sorw_id" => $art_reviewer_id,
                $column_prefix . "parent_flow_id" => $parent_flow_id);

            $pri_id = $Article_flow_alternativereviewer_priorityorder::insert_record($data_reviewer, $current_user);
            $new_prioity = true;
            $changed_priority_id = $pri_id;
        }
    }

    $i = 1;
    if (!empty($ordering_lst))
    {
        foreach ($ordering_lst as $rev_order)
        {
            $userdata=explode("##",$rev_order['id']);
            $reviwer_id=$userdata[0];
            $aflw_id = $userdata[2];
            $order = $i;
            $rev_order = $data = array(
                'afap_number' => $i
            );
            $update_condition ="afap_usr_id={$reviwer_id} AND afap_number!={$order} AND afap_art_id={$art_id}
            AND afap_aflw_id={$aflw_id}";


            $Article_flow_alternativereviewer_priorityorder::update_record($data, $update_condition,$current_user);
            $i++;
        }
    }
    $return_arr=array();
    $return_arr['new_priority'] = $new_prioity;
    $return_arr['user_id'] = encrypt_link($user_id);
    $return_arr['changed_priority_id'] = encrypt_link($changed_priority_id);

    return  $this->success('Success', 200, $return_arr);
}
catch(\Exception $e)
{
    return  $this->failure('Failed',500,$e);
}
}
	/* #625 Queue system for shortlisted reviewers priority setting updation   */
	public function update_priority_settings(Request $request)
	{
        try
        {
        $Article_user_alternativereviewer_priorityorder=new \App\Models\Article_user_alternativereviewer_priorityorder;
        $Article_alternativereviewer_priority_settings=new \App\Models\Article_alternativereviewer_priority_settings;
        $current_user=$this->get_current_user_details();
		$post_data = $request->all();
		$return_arr = array(
			'status' => 'failed',
			'msg' => 'failed',
		);
		$user_id = decrypt_link($post_data['invite_usr_id']);
		$article_id = decrypt_link($post_data['article_id']);
		$parent_flowid = decrypt_link($post_data['parent_flow_id']);
		$multiple_invitation_status = $post_data['multiple_invited_status'];
		$type=$post_data['type'];
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
        if(isset($post_data['pool_id']) && isset($post_data['pool_workflow_assignment_desination_id']) && isset($post_data['pool_workflow_assignment_source_id']))
        {
            $pool_id =  Rv_decrypt($post_data['pool_id']);
            $destination_id =  Rv_decrypt($post_data['pool_workflow_assignment_desination_id']);
        }
        if(isset($post_data['aflw_id']))
        {
            $aflw_id = decrypt_link($post_data['aflw_id']);
        }
        if($type=='user')
        {
                $priority_type='u';
                $condotion="aaps_usr_id={$user_id} AND aaps_art_id={$article_id} AND aaps_parent_flow_id={$parent_flowid} AND aaps_priority_type='{$priority_type}'";
                if(isset($aflw_id))
                {
                    $condotion="aaps_usr_id={$user_id} AND aaps_art_id={$article_id} AND aaps_aflw_id={$aflw_id} AND aaps_priority_type='{$priority_type}'";
        }
        }
        else
        {
            $priority_type='p';
            $condotion="aaps_art_id={$article_id} AND aaps_parent_flow_id={$parent_flowid} AND aaps_priority_type='{$priority_type}'";
            if(isset($pool_id))
            {
                $condotion="aaps_art_id={$article_id} AND aaps_pool_id={$pool_id} AND aaps_destination_id='{$destination_id}'";
        }
        }
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
		$column_prefix = 'aaps_';
		$check_priority_user_exist = $Article_alternativereviewer_priority_settings::get_single_record('count(aaps_id) as count,aaps_id',$condotion);
		if ($check_priority_user_exist->count > 0)
		{
            if(isset($check_priority_user_exist->aaps_id)&&($check_priority_user_exist->aaps_id!=''))
            {
			$data = array('aaps_multiple_invitation_status' => $multiple_invitation_status,
					      'aaps_priority_type' => $priority_type);
			$update_condition ="aaps_id={$check_priority_user_exist->aaps_id}";
			$auto_invied_id = $Article_alternativereviewer_priority_settings::update_record($data, $update_condition,$current_user);
			if ($auto_invied_id === true)
            {
				$return_arr['status'] = 'success';
            }
            }
		}
		else
		{
			$data = array(
				$column_prefix . 'usr_id' => $user_id,
				$column_prefix . 'art_id' => $article_id,
				$column_prefix . 'parent_flow_id' => $parent_flowid,
				$column_prefix . 'multiple_invitation_status' => $multiple_invitation_status,
				$column_prefix . 'priority_type' => $priority_type);
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($aflw_id))
            {
                $data[$column_prefix . 'aflw_id'] = $aflw_id;
            }
            if(isset($pool_id))
            {
                $data[$column_prefix . 'pool_id'] = $pool_id;
                $data[$column_prefix . 'destination_id'] = $destination_id;
            }
			$auto_invied_id = $Article_alternativereviewer_priority_settings::insert_record($data,$current_user);
			if ($auto_invied_id === true)
            {
				$return_arr['status'] = 'success';
            }
		}
        $return_arr['multiple_invitation_status'] = true;
		if ($multiple_invitation_status == 'n' && $type=='user')
		{
			$condition = 'auap_usr_id='.$user_id.' AND auap_art_id='.$article_id.' AND auap_parent_flow_id='.$parent_flowid;
            if(isset($aflw_id))
            {
                $condition = 'auap_usr_id='.$user_id.' AND auap_art_id='.$article_id.' AND auap_current_aflw_id='.$aflw_id;
            }
			$priority_id = $Article_user_alternativereviewer_priorityorder::get_single_record('auap_id', $condition);
			$conditionnew = 'auap_usr_id='.$user_id.' AND auap_art_id='.$article_id.' AND auap_parent_flow_id='.$parent_flowid.' AND auap_id!='.$priority_id->auap_id;
            if(isset($aflw_id))
            {
                $conditionnew = 'auap_usr_id='.$user_id.' AND auap_art_id='.$article_id.' AND auap_current_aflw_id='.$aflw_id.' AND auap_id!='.$priority_id->auap_id;
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
			$remove_reviwer_priority = $Article_user_alternativereviewer_priorityorder::delete_records($conditionnew);
            if($remove_reviwer_priority)
            {
                $return_arr['multiple_invitation_status'] = false;
            }
		}
        return  $this->success('Success', 200, $return_arr);
    }
    catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
	}
  	/* #625 Queue system for shortlisted reviewers auto invitation email save  */
	public function save_autoinvited_email(Request $request)
    {
          try
          {
            $Article_autoinvitation_emails=new \App\Models\Article_autoinvitation_emails;
            $Stage_email_templates=new \App\Models\Stage_email_templates;
            $current_user=$this->get_current_user_details();
              $post_data=$request->all();
              $email_data=$post_data['postdata'];

              $user_id = isset($post_data['user_ids']) ? decrypt_link($post_data['user_ids']) : '';
              $article_id = isset($post_data['article_id']) ? decrypt_link($post_data['article_id']) : '';
              $aflow_id = isset($post_data['aflwid']) ? decrypt_link($post_data['aflwid']) : '';
              $template_id = isset($post_data['invite_tmpl_name']) ? decrypt_link($post_data['invite_tmpl_name']) : '';
              $priority_type = isset($post_data['priority_type']) ? $post_data['priority_type'] : '';
              $priority_id = isset($post_data['priority_id']) ? decrypt_link($post_data['priority_id']) : '';
              $column_prefix = 'aae_';
              // Task #31, api error in saveautoinvitedemail -> Column 'aae_reply_to' cannot be null fix start
              $jnl_id = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
              $default_mail_id = $this->get_reply_to_email($jnl_id);
              // Task #31, api error in saveautoinvitedemail -> Column 'aae_reply_to' cannot be null fix end 
              $bcc_id = (isset($post_data['invite_tmpl_to_bcc']) && $post_data['invite_tmpl_to_bcc'] != "") ? json_encode($post_data['invite_tmpl_to_bcc']) : '';
              $stage_email = $Stage_email_templates::get_single_record('stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_to',"stage_etmp_id={$template_id}");
                //    TASK #9026 CC and BCC mail is not set for user-based alternative reviewer
                $optccvalue = array();
                $email_data['stage_template_to_cc'] = $email_data['stage_template_to_cc'] ? (is_array($email_data['stage_template_to_cc']) ? $email_data['stage_template_to_cc'] : explode(',', $email_data['stage_template_to_cc'])) : ""; // Task #31, api error in saveautoinvitedemail -> in_array(): Argument #2 ($haystack) must be of type array, string given fix
                if (isset($email_data['stage_cust_cc'])&&!empty($email_data['stage_cust_cc']) && (in_array('Custom_cc',$email_data['stage_template_to_cc'])||in_array('Custom',$email_data['stage_template_to_cc']))) {
                    $custm_cc = $email_data['stage_cust_cc'];
                    for ($i = 0; $i < count($custm_cc); $i++) {
                        $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                        $cust_value = str_replace('\\', '"', $cust_value);
                        $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                        array_push($optccvalue, $cust_value);


                    }
                    $email_data['stage_cust_cc'] = implode(',', $optccvalue);

                }
                else{
                    $email_data['stage_cust_cc']='';
                }
                $optbccvalue = array();
                $email_data['stage_template_to_bcc'] = $email_data['stage_template_to_bcc'] ? (is_array($email_data['stage_template_to_bcc']) ? $email_data['stage_template_to_bcc'] : explode(',', $email_data['stage_template_to_bcc'])) : ""; // Task #31, api error in saveautoinvitedemail -> in_array(): Argument #2 ($haystack) must be of type array, string given fix
                if (isset($email_data['stage_cust_bcc'])&&!empty($email_data['stage_cust_bcc']) && (in_array('Custom_bcc',$email_data['stage_template_to_bcc'])||in_array('Custom',$email_data['stage_template_to_bcc']))) {
                    $custm_bcc = $email_data['stage_cust_bcc'];
                    for ($i = 0; $i < count($custm_bcc); $i++) {
                        $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                        $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                        $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                        array_push($optbccvalue, $cust_bcc_value);

                    }
                    $email_data['stage_cust_bcc'] = implode(',', $optbccvalue);
                }
                else{
                    $email_data['stage_cust_bcc']='';
                }
              /*Task #9296 Alternative Reviewer email cc,bcc field invalid character save*/  
                if (isset($email_data['stage_template_to_cc'])&&(is_array($email_data['stage_template_to_cc'])) && count($email_data['stage_template_to_cc'])) {
                    $email_data['stage_template_to_cc'] = json_encode($email_data['stage_template_to_cc']);
                }
                if (isset($email_data['stage_template_to_bcc']) &&(is_array($email_data['stage_template_to_bcc'])) && count($email_data['stage_template_to_bcc'])) {
                    $email_data['stage_template_to_bcc'] = json_encode($email_data['stage_template_to_bcc']);
                }
                
    
        //    TASK #9026 end

              $update_condition ="aae_usr_id={$user_id} AND aae_art_id={$article_id}";
      $template_name= isset($stage_email->stage_etmp_name) ? $stage_email->stage_etmp_name : '';
      $template_action=isset($stage_email->stage_etmp_action) ? $stage_email->stage_etmp_action : '';
      $stage_to=isset($stage_email->stage_etmp_to) ? $stage_email->stage_etmp_to : '';
      $replace_button = array('<button contenteditable="false">', '</button>');
      $email_data['stage_template_content'] = str_replace($replace_button, '##', $email_data['stage_template_content']);

              $data = array(
                  $column_prefix . 'usr_id' => $user_id,
                  $column_prefix . 'stage_etmp_id' => $template_id,
                  $column_prefix . 'art_id' => $article_id,
                  $column_prefix . 'aflw_id' => $aflow_id,
                  $column_prefix . 'template_name' =>$template_name,
                  $column_prefix . 'action' =>$template_action,
                  $column_prefix . 'to' => $stage_to,
                  $column_prefix . 'bcc' => isset($email_data['stage_template_to_bcc']) && $email_data['stage_template_to_bcc'] !=null ?  $email_data['stage_template_to_bcc'] : "",  //    TASK #9026
                  $column_prefix . 'cc' =>  isset($email_data['stage_template_to_cc']) && $email_data['stage_template_to_cc'] !=null ?  $email_data['stage_template_to_cc'] : "",    //    TASK #9026
                  $column_prefix . 'subject' => $email_data['stage_template_sub'],
                  $column_prefix . 'content' => $email_data['stage_template_content'],
                  $column_prefix . 'cust_to' => '',
                  $column_prefix . 'cust_cc' => $email_data['stage_cust_cc'],    //    TASK #9026,
                  $column_prefix . 'cust_bcc' =>  $email_data['stage_cust_bcc'],  //    TASK #9026
                  $column_prefix . 'reply_to' => (isset($email_data['stage_template_to_mail']) && !empty($email_data['stage_template_to_mail'])) ? $email_data['stage_template_to_mail'] : $default_mail_id, // Task #31, api error in saveautoinvitedemail -> Column 'aae_reply_to' cannot be null fix
              );
              if ($priority_type == 'user')
              {
                $update_condition.=" AND aae_auap_id={$priority_id}";
                  $data[$column_prefix . 'auap_id'] = $priority_id;
                  $return_arr['type'] = 'user';
              }
              else
              {
                $update_condition.=" AND aae_afap_id={$priority_id}";
                  $data[$column_prefix . 'afap_id'] = $priority_id;
                  $return_arr['type'] = 'all';
              }
              $check_invitation_email_exist = $Article_autoinvitation_emails::get_single_record('count(aae_id) as count', $update_condition);

              if ($check_invitation_email_exist->count > 0)
              {


                  $auto_invied_id = $Article_autoinvitation_emails::update_record($data, $update_condition,$current_user);
                  if ($auto_invied_id === true)
                  {
                      $return_arr['status'] = 'success';
                  }
              }
              else
              {
                  $auto_invied_id = $Article_autoinvitation_emails::insert_record($data,$current_user);
                  if ($auto_invied_id === true)
                  {
                      $return_arr['status'] = 'success';
                  }
              }

              $return_arr['email_id'] = encrypt_link($auto_invied_id);

              return  $this->success('Success', 200, $return_arr);
          }
          catch(\Exception $e)
          {

              return  $this->failure('Failed',500,$e);
          }
    }

    	/* #625 Queue system for shortlisted reviewers auto invitation user based  update priorites */

	public function save_alternate_reviwer_priority(Request $request)
	{
        try
        {
        $Article_user_alternativereviewer_priorityorder=new \App\Models\Article_user_alternativereviewer_priorityorder;
        $Article_autoinvitation_emails=new \App\Models\Article_autoinvitation_emails;
		$post_data = $request->all();
        $this->current_user=$this->get_current_user_details();
		$user_id = decrypt_link($post_data['user_id']);
		$art_id = decrypt_link($post_data['art_id']);
		$flow_id = decrypt_link($post_data['flow_id']);
		$art_reviewer_id = decrypt_link($post_data['art_reve_id']);
		$ordering_lst =$post_data['ordering_lst'];
		$parent_flow_id = decrypt_link($post_data['parent_flow_id']);
		$priority_id = isset($post_data['priority_id']) ? decrypt_link($post_data['priority_id']) : '';
		$invited_user_id = decrypt_link($post_data['invited_user_id']);
		/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
        if(isset($post_data['aflw_id']))
        {
            $aflw_id = decrypt_link($post_data['aflw_id']);
        }
		$column_prefix = 'auap_';
		$pri_id = '';
		$check_user_exist = $Article_user_alternativereviewer_priorityorder::get_single_record('count(auap_id) as count',"auap_alternate_usr_id={$user_id} AND auap_art_id={$art_id} AND auap_aflw_id={$flow_id} AND auap_usr_id={$invited_user_id}");
		if ($check_user_exist->count == 0)
		{
			$data_reviewer = array(
				$column_prefix . "usr_id" => $invited_user_id,
				$column_prefix . "alternate_usr_id" => $user_id,
				$column_prefix . "art_id" => $art_id,
				$column_prefix . "aflw_id" => $flow_id,
				$column_prefix . "sorw_id" => $art_reviewer_id,
				$column_prefix . "parent_flow_id" => $parent_flow_id);
                if(isset($aflw_id))
                {
                    $data_reviewer[$column_prefix . "current_aflw_id"] = $aflw_id;
                }
			$pri_id = $Article_user_alternativereviewer_priorityorder::insert_record($data_reviewer, $this->current_user);
		}
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
		if (isset($priority_id) && $priority_id != null)
		{
			 $Article_user_alternativereviewer_priorityorder::delete_records("auap_id={$priority_id}",'',$this->current_user);
			 $Article_autoinvitation_emails::delete_records("aae_auap_id={$priority_id}",'',$this->current_user);
		}

		$i = 1;
		if (!empty($ordering_lst))
		{
			foreach ($ordering_lst as $rev_order)
			{
				$reviwer_id = decrypt_link($rev_order);
				$order = $i;
				$rev_order = $data = array(
					$column_prefix . 'number' => $i
				);
				$update_condition ="auap_alternate_usr_id={$reviwer_id} AND auap_number!={$order} AND auap_art_id={$art_id} AND auap_usr_id={$invited_user_id}";


				$Article_user_alternativereviewer_priorityorder::update_record($data, $update_condition);
				$i++;
			}
		}
		$return_arr['status'] = 'success';

		$return_arr['priorityid'] = encrypt_link($pri_id);
        return  $this->success('Success', 200, $return_arr);
    }
    catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
	}
    /* #625 Queue system for shortlisted reviewers auto invitation user based  remove priorites */
	public function remove_alternate_autoinvited_priority(Request $request)
	{
        try
        {
            $Article_user_alternativereviewer_priorityorder=new \App\Models\Article_user_alternativereviewer_priorityorder;
            $post_data = $request->all();
            $priority_id = decrypt_link($post_data['priority_id']);
            $column_prefix = 'auap_';
            $condition ="{$column_prefix}id = {$priority_id}";
            $Article_user_alternativereviewer_priorityorder::delete_records($condition);

            $return_arr['status'] = 'success';
            return  $this->success('Success', 200, $return_arr);
        }
        catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
    }

    public function get_init_filter_data(Request $request)
    {
    try{
    $journal=new \App\Models\Journals();
    $roles = new \App\Models\Roles();
    $country = new \App\Models\Country();
    $validator = Validator::make($request->all(), [
        'article_id' => 'required',
    ]);
    if($validator->fails())
    {
        return  $this->failure('Failed',422,$validator->errors());
    }
    // TASK #7033 SQL injection getinitfilterdata
    if(isset($request->article_id)){
    $artidarray = array('input'=>$request->article_id,'type'=>'number', 'enc_data'=>true );
    $artidvalidation= $this->Rv_validator($artidarray);
    if($artidvalidation != true){
        return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
    }
    }
    // end TASK #7033 SQL injection getinitfilterdata
    $article_id = decrypt_link($request->article_id);
    $return_arr = array();
    $jnl_details = $journal::get_all_records('jnl_id,jnl_journal_name');
    $roles_data = $roles::select('role_id','role_name')->where('role_assigned_role', '!=', 'system')->get();
    $country_list = $country::get_all_records('cnt_id,cnt_country');
    $article_key_tbl = (new \App\Models\Article_keywords())->getTable();
    $Keyword_tbl = (new \App\Models\Keywords())->getTable();
    $default_filter = 'clients.' . $this->current_client->clnt_client_code . '.reviewer_search_default_filters.default_filters';
    $default_filters_keyword = Config::get($default_filter);

    $art_keywords = DB::table($article_key_tbl)
            ->join($Keyword_tbl, $article_key_tbl.'.ak_keyword_id', '=', $Keyword_tbl.'.kwd_id')
            ->select('kwd_id','kwd_name')
            ->where('ak_art_id',$article_id)
            ->get();
    $flags = new \App\Models\Flags();
    $usr_flags = $flags::get_all_records("Distinct flag_name","`flag_type` = 'u'");
    $return_arr['usr_flags']=array();
    $return_arr['usr_global_flags']=array();
    if(!empty($usr_flags)&&count($usr_flags)>0)
    {
        foreach($usr_flags as $key)
        {
            $return_arr['usr_flags'][] = array(
                'label' => $key->flag_name,
                'value' => $key->flag_name
            );
        }
    $return_arr['usr_global_flags'] = $return_arr['usr_flags'];
    }
    //get Classification data
    $art_classification = array();
    if(isset($request->jnl_id)){
        $jnlidarray = array('input'=>$request->jnl_id,'type'=>'number', 'enc_data'=>true );
        $jnlidvalidation= $this->Rv_validator($jnlidarray);
        if($jnlidvalidation !== true){
            return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
        }
    }
    $jnl_id = decrypt_link($request->journal_id);
    $jnl_classification = $this->search_classificationdata(null, null, $jnl_id);
    $condition ="arcls_art_id ={$article_id}";
    $checkBoxData = Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition);
    if(!empty($checkBoxData->checkData)){
        $art_classification = json_decode(json_encode(explode(',', $checkBoxData->checkData)));
    }
    $return_arr['classfication_data'] = array(
        'jnl_classification' => $jnl_classification,
        'art_classification' => $art_classification
    );
    $return_arr['journals'] = $jnl_details;
    $return_arr['roles'] = $roles_data;
    $return_arr['countries'] = $country_list;
    $return_arr['art_keywords'] = $art_keywords;
    $return_arr['default_filter'] = $default_filters_keyword;

    if($request->journal_id)
    {
        $journal_id = decrypt_link($request->journal_id);
        $date_format = $this->get_platform_date_format($journal_id);
        $array_date = platform_date_format();
        $return_arr['jnl_frmt'] =  $array_date[$date_format];
        $return_arr['org_frmt'] = $date_format;
    }
    if(isset($request->role_id))
    {
        $roleidarray = array('input'=>$request->role_id,'type'=>'number', 'enc_data'=>false );
        $roleidvalidation= $this->Rv_validator($roleidarray);
        if($roleidvalidation != true){
            return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
        }
        $criteria = 'role_id = '.$request->role_id;
        $current_role = $roles::get_all_records('role_name',$criteria);
        $return_arr['current_role'] = $current_role;
    }
    return  $this->success('Success', 200, $return_arr);

}
catch(\Exception $e)
    {

        return  $this->failure('Failed',500,$e);
    }
}

public function getkeywords(Request $request)
    {
        try {
            $data = array();
            $form_data = $request->all();
            $criteria = 'kwd_user_keyword IN (\'n\',\'y\') ';
            $request->cur_sel = $request->cur_sel ?? [];
            $jnlid = isset($form_data['jnlid']) ? $this->decrypt_data($form_data['jnlid']) : '';
            if (!empty($jnlid) && isset($form_data['page']) && $form_data['page'] === 'jnl_stngs') {
                $criteria = "kwd_user_keyword = 'n' "; 
                $criteria .= " AND kwd_id NOT IN (SELECT kwdrl_kwd_id FROM rvw_keyword_relationship WHERE kwdrl_jnl_id = '$jnlid')";
            }
            if(count($request->cur_sel) > 0)
            {
                $current_selected = $request->cur_sel;
                $exclude_ids = '';
                foreach($current_selected as $single_row)
                {
                    $exclude_ids .= ','.$single_row['value'];
                }
                $exclude_ids = ltrim($exclude_ids,',');
                $criteria .= ' AND kwd_id NOT IN('.$exclude_ids.')';
            }
            $keywordid = isset($form_data['keywordid']) ? $form_data['keywordid'] : '';
            if (!empty($keywordid)) {
                $key_name = htmlspecialchars($keywordid, ENT_QUOTES);
                $criteria .= ' AND LOWER(kwd_name) LIKE LOWER("%' . trim($key_name) . '%")';
            }
            if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y') {
                $criteria .= ' AND kwdrl_inactive =\'n\'';
            }
            $kwd_tbl = new \App\Models\Keywords();
            $records =  $kwd_tbl::get_jnl_keywords('kwd_id,REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name', false, $criteria, 25,'kwd_id');
            $data['records'] = $records;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    private function manage_search_filters($search_details = array())
	{
        try{
		$return_arr = array();
		//JOURNAL FILTER SECTION -- START
		if (isset($search_details['journal_stype']) && isset($search_details['journal']) && count($search_details['journal_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['journal_stype'], $search_details['journal'], 'array', true);
			if (count($temp_filter) > 0)
            {
				$return_arr['journal_filter'] = $temp_filter;
            }
		}
		//JOURNAL FILTER SECTION -- STOP
		//ROLE FILTER SECTION -- START
		if (isset($search_details['userroles_stype']) && isset($search_details['userroles']) && count($search_details['userroles_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['userroles_stype'], $search_details['userroles'], 'array');
			if (count($temp_filter) > 0)
            {
				$return_arr['role_filter'] = $temp_filter;
            }
		}
		//ROLE FILTER SECTION -- STOP

		/* Feature #2063 - JPR-214 Retiring an AE/Editor -- View article section */
		//RETIRE ROLE FILTER SECTION -- START
		if (isset($search_details['retiredroles_stype']) && isset($search_details['retiredroles']) && count($search_details['retiredroles_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['retiredroles_stype'], $search_details['retiredroles'], 'array');
			if (count($temp_filter) > 0)
            {
				$return_arr['retired_role_filter'] = $temp_filter;
            }
        
		}
		//RETIRE ROLE FILTER SECTION -- STOP
		//ARTICLE TITLE FILTER SECTION -- START
		if (isset($search_details['articletitle_stype']) && isset($search_details['articletitle']) && count($search_details['articletitle_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['articletitle_stype'], $search_details['articletitle'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['articletitle_filter'] = $temp_filter;
            }
		}
		//ARTICLE TITLE FILTER SECTION -- STOP
		//REVIEW RATING FILTER SECTION -- START
		if (isset($search_details['reviewer_rating_stype']) && isset($search_details['reviewer_rating']) && count($search_details['reviewer_rating_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['reviewer_rating_stype'], $search_details['reviewer_rating'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['review_rating_filter'] = $temp_filter;
            }
		}
		//REVIEW RATING FILTER SECTION -- STOP
		//COMPLETED REVIEW COUNT FILTER SECTION -- START
		if (isset($search_details['completed_review_count_stype']) && isset($search_details['completed_review_count']) && count($search_details['completed_review_count_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['completed_review_count_stype'], $search_details['completed_review_count'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['completed_review_count_filter'] = $temp_filter;
            }
		}
		//COMPLETED REVIEW COUNT FILTER SECTION -- STOP
		//AUTODECLINED UNASSIGNED FILTER SECTION -- START
		if (isset($search_details['autodeclined_unassigned_review_count_stype']) && isset($search_details['autodeclined_unassigned_review_count']) && count($search_details['autodeclined_unassigned_review_count_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['autodeclined_unassigned_review_count_stype'], $search_details['autodeclined_unassigned_review_count'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['autodeclined_unassigned_review_count_filter'] = $temp_filter;
            }
		}

		//REVIEW IN HAND FILTER SECTION -- START
		if (isset($search_details['present_review_count_stype']) && isset($search_details['present_review_count']) && count($search_details['present_review_count_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['present_review_count_stype'], $search_details['present_review_count'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['present_review_count_filter'] = $temp_filter;
			}
		}
		//REVIEW IN HAND FILTER SECTION -- STOP
		//INSTITUTION FILTER SECTION -- START
		if (isset($search_details['institution_stype']) && isset($search_details['institution']) && count($search_details['institution_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['institution_stype'], $search_details['institution'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['institution_filter'] = $temp_filter;
			}
		}
		//INSTITUTION  FILTER SECTION -- STOP
		//COUNTRY FILTER SECTION -- START
		if (isset($search_details['country_stype']) && isset($search_details['country']) && count($search_details['country_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['country_stype'], $search_details['country'], 'array');
			if (count($temp_filter) > 0)
            {
				$return_arr['country_filter'] = $temp_filter;
			}
		}
		//COUNTRY FILTER SECTION -- STOP
		//POSTCODE FILTER SECTION -- START
		if (isset($search_details['post_code_stype']) && isset($search_details['post_code']) && count($search_details['post_code_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['post_code_stype'], $search_details['post_code'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['post_code_filter'] = $temp_filter;
			}
		}
		//POSTCODE FILTER SECTION -- STOP
		//USERNAME FILTER SECTION -- START
		if (isset($search_details['user_name_stype']) && isset($search_details['user_name']) && count($search_details['user_name_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_name_stype'], $search_details['user_name'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['username_filter'] = $temp_filter;
			}
		}
		//USERNAME FILTER SECTION -- STOP
		//USERNAME FILTER SECTION -- START
		if (isset($search_details['user_email_stype']) && isset($search_details['user_email']) && count($search_details['user_email_stype']) > 0)
		{
			$temp_filter = $this->arrange_post_data($search_details['user_email_stype'], $search_details['user_email'], 'string');
			if (count($temp_filter) > 0)
            {
				$return_arr['user_email_filter'] = $temp_filter;
			}
		}
		//USERNAME FILTER SECTION -- STOP
        //REVIEW DATE FILTER SECTION -- START
		if (isset($search_details['review_date_range_type'][0]) && count($search_details['review_date_range_type']) > 0)
		{
			$return_arr['review_date_filter'] = $search_details['review_date_range_type'][0];
			if ($search_details['review_date_range_type'][0] == 'custom_date')
			{
				$return_arr['jnl_date'] = $search_details['server_date_formt'];
				if (isset($search_details['review_start_date'][0]))
				{
					$return_arr['review_date_start'] = $search_details['review_start_date'][0];
				}
				if (isset($search_details['review_end_date'][0]))
				{
					$return_arr['review_date_end'] = $search_details['review_end_date'][0];
                }

			}
		}
		//REVIEW DATE FILTER SECTION -- STOP
		//KEYWORDS FILTER SECTION -- START
		if (isset($search_details['keyword_stype']) && count($search_details['keyword_stype']) > 0)
		{
			$temp_arr = array();
			$main_arr = array();
			$keyword_type = '';
			foreach ($search_details['keyword_stype'] as $key => $keyword)
			{
				if ($keyword_type != '' && $keyword_type != $keyword && count($temp_arr) > 0)
				{
					$main_arr[$keyword_type] = $temp_arr;
					$temp_arr = array();
				}

				if ($search_details['keyword_operator'][$key] == 'LIKE')
				{
					$like_text = trim($search_details['keyword'][$key]);
					if ($like_text != '')
						$temp_arr[$search_details['keyword_operator'][$key]] = $like_text;
				}
				else
				{
					if (isset($search_details['keyword'][$key]) && count($search_details['keyword'][$key]) > 0)
						$temp_arr[$search_details['keyword_operator'][$key]] = implode(',', $search_details['keyword'][$key]);
				}

				$keyword_type = $keyword;
			}

			if (!isset($main_arr[$keyword_type]) && count($temp_arr) > 0)
            {
				$main_arr[$keyword_type] = $temp_arr;
            }

			$return_arr['keyword_filter'] = $main_arr;

		}
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
		//KEYWORDS FILTER SECTION -- STOP
        //CLASSIFICATION FILTER SECTION -- START
        if(isset($search_details['classification_stype']) && count($search_details['classification_stype']) > 0){
            $temp_arr = array();
            $main_arr = array();
            $class_type = '';
            foreach ($search_details['classification_stype'] as $key => $classification){
                if ($class_type != '' && $class_type != $classification && count($temp_arr) > 0)
				{
					$main_arr[$class_type] = $temp_arr;
					$temp_arr = array();
				}
                if ($search_details['classification_operator'][$key] == 'LIKE')
				{
					$like_text = trim($search_details['classification'][$key]);
					if ($like_text != '')
                    {
						$temp_arr[$search_details['classification_operator'][$key]] = $like_text;
                    }
				}
                else
				{
                    if (isset($search_details['classification'][$key]) && count($search_details['classification'][$key]) > 0){
                        $temp_arr[$search_details['classification_operator'][$key]] = implode(',', $search_details['classification'][$key]);
                    }
				}
                $class_type = $classification;
            }
            if (!isset($main_arr[$class_type]) && count($temp_arr) > 0)
            {
				$main_arr[$class_type] = $temp_arr;
            }

			$return_arr['classification_filter'] = $main_arr;
        }
        //CLASSIFICATION FILTER SECTION -- STOP
        if (isset($search_details['flag_stype']) && count($search_details['flag_stype']) > 0)
        {
            $temp_arr = array();
            $main_arr = array();
            $flag_type = '';
            foreach ($search_details['flag_stype'] as $key => $flag)
            {
                if ($flag_type != '' && $flag_type != $flag && count($temp_arr) > 0)
                {
                    $main_arr[$flag_type] = $temp_arr;
                    $temp_arr = array();
                }
                if (isset($search_details['flag'][$key]) && count($search_details['flag'][$key]) > 0)
                {
                    $temp_arr[$search_details['flag_operator'][$key]] = implode(',', $search_details['flag'][$key]);
                }

                        $flag_type = $flag;
            }

            if (!isset($main_arr[$flag_type]) && count($temp_arr) > 0)
            {
                $main_arr[$flag_type] = $temp_arr;
            }
            if(isset($main_arr['user_flag']))
            {
            $return_arr['user_flag_filter'] = $main_arr['user_flag'];
            }
            if(isset($main_arr['global_flag']))
            {
            $return_arr['user_global_flag_filter'] = $main_arr['global_flag'];
            }

        }
        //echo '<pre>';print_r($return_arr);exit;
        //echo '<pre>';print_r($search_details);exit;
        //BOOLEAN SEARCH
        if (isset($search_details['boolean_search']))
        {
            $bsearch_filter_val_arr = $this->manipulate_Bserach_string($search_details['boolean_search']);
            $bsearch_tables = array();

            $jnl_flag = false;
            if(in_array('journal',array_keys($bsearch_filter_val_arr)))
            {
                $jnl_flag = true;
            }

            $boolSearch_condition = '';
            $operator_flag = true;
            foreach($bsearch_filter_val_arr as $key=>$val)
            {
                if(str_contains($key,'operand') == true)
                {
                    if($operator_flag == true)
                    {
                        $boolSearch_condition .= ' '.$val.' ';
                    }
                    $operator_flag = true;
                }
                elseif($key == 'name')
                {
                    $boolSearch_condition .= ' concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) LIKE \'%'.$val.'%\' ';
                }
                elseif($key == 'email')
                {
                    $boolSearch_condition .= '  usr_email LIKE "%'.$val.'%" ';
                }
                elseif($key == 'keyword')
                {
                    $bsearch_tables[] = 'bs_keywords';
                    $boolSearch_condition .= '  keyword_table.user_keywords LIKE "%'.$val.'%" ';
                }
                elseif($key == 'journal')
                {
                    $bsearch_tables[] = 'bs_journals';
                    $boolSearch_condition .= '  user_journal_table.jnl_journal_name_list LIKE "%'.$val.'%" ';
                }
                elseif($key == 'country')
                {
                    $bsearch_tables[] = 'bs_country';
                    $boolSearch_condition .= '  user_institution_table.country_GP LIKE "%'.$val.'%" ';
                }
                elseif($key == 'institution')
                {
                    $return_arr['institution_filter']['from'] = $val;
                    $operator_flag = false;
                }
                elseif($key == 'post code')
                {
                    $return_arr['post_code_filter']['from'] = $val;
                    $operator_flag = false;
                }
                elseif($val == 'review')
                {
                    if(isset($bsearch_filter_val_arr['status']))
                    {
                        $bf_status = $bsearch_filter_val_arr['status'];
                        $bf_count = 0;
                        if(isset($bsearch_filter_val_arr['count']))
                            $bf_count = $bsearch_filter_val_arr['count'];

                        unset($bsearch_filter_val_arr['status']);
                        unset($bsearch_filter_val_arr['count']);
                        $operator_flag = false;
                        if($bf_status == 'complete')
                        {
                            $return_arr['completed_review_count_filter']['has_at_least'] = $bf_count;
                            break;
                        }
                        elseif($bf_status == 'inprogress')
                        {
                            $return_arr['present_review_count_filter']['has_at_least'] = $bf_count;
                            break;
                        }
                        elseif($bf_status == 'period')
                        {
                            //in progress
                        }
                        elseif($bf_status == 'unassigned')
                        {
                            $bsearch_tables[] = 'bs_reviewunassigned';
                            $return_arr['autodeclined_unassigned_review_count_filter']['has_at_least'] = $bf_count;
                            break;
                        }
                        elseif($bf_status == 'autodeclined' || $bf_status == 'declined')
                        {
                            $bsearch_tables[] = 'bs_reviewdeclined';
                            $return_arr['autodeclined_unassigned_review_count_filter']['has_at_least'] = $bf_count;
                            break;
                        }

                    }
                    elseif(isset($bsearch_filter_val_arr['period']))
                    {
                        $bs_period = $bsearch_filter_val_arr['period'];
                        if($bs_period == 'current year')
                        {
                            $return_arr['review_date_filter'] = 'current_year';
                            break;
                        }
                        elseif($bs_period == 'last year')
                        {
                            $return_arr['review_date_filter'] = 'last_year';
                            break;
                        }
                    }
                }
                elseif($val == 'rating' )
                {
                    if(isset($bsearch_filter_val_arr['count']))
                    {
                        $operator_flag = false;
                        $return_arr['review_rating_filter']['avg_rating_above'] = $bsearch_filter_val_arr['count'];
                        unset($bsearch_filter_val_arr['count']);
                    }
                }
                elseif($key == 'role' )
                {
                    $operator_flag = false;
                    if(isset($bsearch_filter_val_arr['status']) && $bsearch_filter_val_arr['status'] == 'retired')
                    {
                        $bsearch_tables[] = 'bs_retiredroles';
                        unset($bsearch_filter_val_arr['status']);

                        $jnl_role_ret_str = 'user_journal_table_retired.role_name';
                        $role_str = 'jnl_retired_role_table.role_name';
                    }
                    else
                    {
                        $bsearch_tables[] = 'bs_roles';
                        $jnl_role_ret_str = 'user_journal_table_role.role_name';
                        $role_str = 'jnl_role_table.role_name';
                    }

                    if($jnl_flag == true)
                    {
                        $boolSearch_condition .= '  '.$jnl_role_ret_str.' LIKE "%'.$val.'%" ';
                    }
                    else
                    {
                        $boolSearch_condition .= '  '.$role_str.' LIKE "%'.$val.'%" ';
                    }
                }
                elseif($key == 'title')
                {
                    $return_arr['articletitle_filter']['has_reviewed_articles'] = $val;
                }
                elseif($key == 'single_search')
                {
                    $boolSearch_condition = '(concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) LIKE \'%'.$val.'%\') OR ( usr_email LIKE "%'.$val.'%") ';
                }
            }

            $return_arr['booleanseach_condition'] = $boolSearch_condition;
            $return_arr['booleanseach_tables'] = $bsearch_tables;
        }
		return $return_arr;
    }

    private function arrange_post_data($filter_data, $data_arr, $content_type = 'array', $data_encp = false)
	{
		$review_filter = array();
		if (isset($filter_data) && count($filter_data) > 0)
		{
			if ($content_type == 'array')
            {
				$data = array();
            }
			else
            {
				$data = '';
            }
			foreach ($filter_data as $jk => $jv)
			{
				$review_data = (isset($data_arr[$jk])) ? $data_arr[$jk] : $data;
				if ($content_type == 'array')
				{
					if (count($review_data) > 0)
					{
						if ($data_encp === true)
						{
							array_walk($review_data, function(&$value, $key)
							{
								$value = $value;
							});
						}
						$review_filter[$jv] = implode(',', $review_data);
					}
				}
				else
				{
					if ($review_data != '')
                    {
						$review_filter[$jv] = trim($review_data);
                    }
				}
			}
		}

		return $review_filter;
	}

    public function get_author_suggested_reviewers(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id'=>'required',
                'jnl_id'=>'required'
            ]);
            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $article_id = isset($post_data['art_id']) ? Rv_decrypt($post_data['art_id']):'';
            $art_flow_id = isset($post_data['art_flow_id']) ? Rv_decrypt($post_data['art_flow_id']):'';
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($post_data['pool_id']) && isset($post_data['pool_workflow_assignment_desination_id']) && isset($post_data['pool_workflow_assignment_source_id']))
            {
                $source_id =  Rv_decrypt($post_data['pool_workflow_assignment_source_id']);
                $destination_id =  Rv_decrypt($post_data['pool_workflow_assignment_desination_id']);
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            if($article_id!='')
            {
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();
                // For getting suggest reviewers
                $reviewer_data =$Article_reviewers::get_all_records('sorw_id,sorw_email,sorw_name,sorw_last_name,sorw_university,sorw_shortlisted_reviewer,(select cnt_country from ' . $Country_table . ' where sorw_cnt_id = cnt_id) as country_name', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='s'");
                foreach($reviewer_data as $data)
                {
                    $data->enable_checkbox = true;
                    $data->enable_info =false;
                    $shortlistedids = json_decode($data->sorw_shortlisted_reviewer);
                    if(!empty($shortlistedids))
                    {
                        $shortlists = implode(',',$shortlistedids);
                        $Article_flow = new \App\Models\Article_flow();
                        $article_flow_table = (new \App\Models\Article_flow)->getTable();
                        $user_table = (new \App\Models\User())->getTable();
                        $quer = 'select aflw_id,usr_first_name,usr_last_name FROM ' . $article_flow_table . ' JOIN ' . $user_table  . ' ON aflw_usr_id = usr_id WHERE aflw_parent_flow_id in ('.$art_flow_id.') and aflw_id IN ('.$shortlists.')';
                        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                        if(isset($destination_id) && isset($source_id))
                        {
                            $quer = 'select aflw_id,usr_first_name,usr_last_name FROM ' . $article_flow_table . ' JOIN ' . $user_table  . ' ON aflw_usr_id = usr_id WHERE aflw_art_id in ('.$article_id.') AND aflw_jwf_id in ('.$destination_id.') AND aflw_assignment_type_id IS NOT NULL  and aflw_id IN ('.$shortlists.')';
                        }
                        $aflw_record = $Article_flow::get_records_by_raw_query($quer);
                        if(isset($aflw_record[0]) && isset($aflw_record[0]->aflw_id))
                        {
                            $data->enable_checkbox = false;
                            if($aflw_record[0]->usr_first_name!=$data->sorw_name || $aflw_record[0]->usr_last_name!=$data->sorw_last_name )
                            {
                                $data->enable_info =true;
                                $data->suggestedname=$aflw_record[0]->usr_first_name.' '.$aflw_record[0]->usr_last_name;
                            }
                        }
                    }
                }
                $return_array['suggest_review_details'] = $reviewer_data;
                return  $this->success('Success', 200, $return_array);
            }

        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function check_user_exists(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'usr_ids' => 'required'
            ]);
            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $Article_reviewers = new \App\Models\Article_reviewers();
            $suggestids = isset($post_data['usr_ids']) ? $post_data['usr_ids']:'';
            $aflw_id = isset($post_data['aflw_id']) ? Rv_decrypt($post_data['aflw_id']):'';
            $art_id = isset($post_data['art_id']) ? Rv_decrypt($post_data['art_id']):'';
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($post_data['pool_workflow_assignment_desination_id']) && isset($post_data['pool_workflow_assignment_source_id']))
            {
                $source_id =  Rv_decrypt($post_data['pool_workflow_assignment_source_id']);
                $destination_id =  Rv_decrypt($post_data['pool_workflow_assignment_desination_id']);
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            $i=0;
            $userwithdifference = false; $return_array =array();
            $usernotshortlist = false; $useralreadyshortlist = false;
            foreach($suggestids as $suggestid)
            {
                $sorw_id =$this->decrypt_data($suggestid);
                $article_data = $Article_reviewers::get_single_record('sorw_email,sorw_name,sorw_last_name,sorw_university,sorw_shortlisted_reviewer', "sorw_id={$sorw_id}");
                if(!empty($article_data))
                {
                    $user_email =$article_data->sorw_email;
                    $User = new \App\Models\User();
                    $User_affiliations=new \App\Models\User_affiliations();

                    $records = $User::get_single_record('usr_first_name,usr_middle_name,usr_last_name,usr_id,usr_status', "usr_email='".$user_email."'");
                    if(!empty($records))
                    {
                        $Article_flow = new \App\Models\Article_flow();
                        $articleflowdata = $Article_flow::get_single_record('aflw_id',"aflw_parent_flow_id={$aflw_id} and aflw_usr_id={$records->usr_id}");
                        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                        if(isset($destination_id) && isset($source_id))
                        {
                            $articleflowdata = $Article_flow::get_single_record('aflw_id',"aflw_art_id = {$art_id} AND aflw_jwf_id={$destination_id} AND aflw_assignment_type_id IS NOT null and aflw_usr_id={$records->usr_id}");
                        }
                        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                        if(isset($articleflowdata->aflw_id) && $articleflowdata->aflw_id!='' && !empty($records))
                        {
                            if($records->usr_first_name!=$article_data->sorw_name || $records->usr_last_name!=$article_data->sorw_last_name )
                            {
                                $user_status =': User already shortlisted in the system with a difference in';
                                $userwithdifference = true;
                            }
                            else
                            {
                                $user_status =': User already shortlisted in the system';
                                $userwithdifference = false;
                            }
                            $return_array['name'][$i]=$records->usr_first_name.' '.$records->usr_last_name;
                            $return_array['user_status'][$i]=$user_status;
                            $return_array['active'][$i]='';
                            $return_array['inactive'][$i]="";
                            $return_array['institution'][$i]='';
                            $useralreadyshortlist = true;
                            $return_array['username'][$i]=$article_data->sorw_name.' '.$article_data->sorw_last_name;
                        }
                        else{
                            if($records->usr_first_name!=$article_data->sorw_name || $records->usr_last_name!=$article_data->sorw_last_name )
                            {
                                $user_status =': User already exist in the system with a difference in';
                            }
                            else
                            {
                                $user_status =': User already exist in the system with same';
                            }
                        if($records->usr_status =='n')
                        {
                            $return_array['user_status'][$i]=$user_status;
                            $return_array['active'][$i]='';
                            $return_array['name'][$i]=$records->usr_first_name.' '.$records->usr_last_name;
                            $return_array['inactive'][$i]=" and is an inactive user, so can't be shortlisted as a reviewer.";
                            $return_array['institution'][$i]='';
                            $usernotshortlist = true;
                            $return_array['username'][$i]=$article_data->sorw_name.' '.$article_data->sorw_last_name;

                        }
                        elseif($records->usr_status =='s'){
                            $return_array['user_status'][$i]=$user_status;
                            $return_array['active'][$i]='';
                            $return_array['name'][$i]=$records->usr_first_name.' '.$records->usr_last_name;
                            $return_array['inactive'][$i]=" and is a suspended user, so can't be shortlisted as a reviewer.";
                            $return_array['institution'][$i]='';
                            $return_array['username'][$i]=$article_data->sorw_name.' '.$article_data->sorw_last_name;
                            $usernotshortlist = true;
                        }
                        else{
                            $records_affliation = $User_affiliations::get_single_record('usaff_company', "usaff_user_id=".$records->usr_id.' and usaff_prime_affiliation = \'y\'');
                            if($records->usr_first_name!=$article_data->sorw_name || $records->usr_last_name!=$article_data->sorw_last_name)
                            {
                                $return_array['user_status'][$i]=$user_status;
                                $return_array['active'][$i]=' and this account will be used for shortlisting.';
                                $return_array['name'][$i]=$records->usr_first_name.' '.$records->usr_last_name;
                                $userwithdifference = true;
                                $return_array['institution'][$i]='';
                                $return_array['inactive'][$i]='';
                                $return_array['username'][$i]=$article_data->sorw_name.' '.$article_data->sorw_last_name;
                            }
                            if(!empty($records_affliation))
                            {
                                if($records_affliation->usaff_company!=$article_data->sorw_university)
                                {
                                    $user_status=": A user already exists in the system with a difference in ";
                                    $return_array['user_status'][$i]=$user_status;
                                    $return_array['active'][$i]=' and this account will be used for shortlisting.';
                                    if(!isset($return_array['name'][$i]))
                                    {
                                        $return_array['name'][$i]='';
                                    }
                                    $return_array['username'][$i]=$article_data->sorw_name.' '.$article_data->sorw_last_name;
                                    $return_array['institution'][$i]=$records_affliation->usaff_company;
                                    $userwithdifference = true;
                                    $return_array['inactive'][$i]='';
                                }
                            }
                        }
                    }
                    }


                }
                if(isset($return_array['name'][$i]))
                {
                    $i++;
                }
            }
            $return_array['useralreadyshortlist'] = $useralreadyshortlist;
            $return_array['usernotshortlist'] = $usernotshortlist;
            $return_array['userwithdifference'] = $userwithdifference;
            return  $this->success('Success', 200, $return_array);
         } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function shortlist_suggest_reviewer(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'usr_ids' => 'required',
                'aflw_id' => 'required'

            ]);
            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $Users=new \App\Models\User;
            $suggestids = isset($post_data['usr_ids']) ? $post_data['usr_ids']:'';
            $aflw_id = isset($post_data['aflw_id']) ? Rv_decrypt($post_data['aflw_id']):'';
            $art_id= isset($post_data['art_id']) ? Rv_decrypt($post_data['art_id']):'';
            $journal_id=isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']):'';
            $user_data = $this->get_current_user_details();
            $User = new \App\Models\User();
            $Articles = new \App\Models\Articles();
            $Article_flow = new \App\Models\Article_flow();
            $User_articles=new \App\Models\User_articles();
            $Article_reviewers = new \App\Models\Article_reviewers();
            $Journals = new \App\Models\Journals();
            $Generic_flows = new \App\Models\Generic_flows();
            $User_to_journals = new \App\Models\User_to_journals();
            $Journals = new \App\Models\Journals();
            $jnldata = $Journals::get_single_record('jnl_standalone',"jnl_id={$journal_id}");
            $jnl_id = ($jnldata->jnl_standalone == 'y') ? $journal_id : null;
            $return_array =array();
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($post_data['pool_id']) && isset($post_data['pool_workflow_assignment_desination_id']) && isset($post_data['pool_workflow_assignment_source_id']))
            {
                $pool_id =  Rv_decrypt($post_data['pool_id']);
                $source_id =  Rv_decrypt($post_data['pool_workflow_assignment_source_id']);
                $destination_id =  Rv_decrypt($post_data['pool_workflow_assignment_desination_id']);
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            if(!empty($suggestids))
            {
                foreach($suggestids as $suggestid)
                {
                    $sorw_id =$this->decrypt_data($suggestid);
                    $article_data = $Article_reviewers::get_single_record('sorw_email,sorw_name,sorw_last_name,sorw_university,sorw_shortlisted_reviewer', "sorw_id={$sorw_id}");
                    if(!empty($article_data))
                    {
                        $user_email =$article_data->sorw_email;
                        $records = $User::get_single_record('usr_first_name,usr_middle_name,usr_last_name,usr_id,usr_status', "usr_email='".$user_email."'");
                        $articletypedata=$Articles::get_single_record('art_artp_id', "art_id='".$art_id."'");
                        $article_type_id=$articletypedata->art_artp_id;
                        if(empty($records))
                        {
                            $user_deeplink_token = Str::random(20);
                            $user_details = array(
                                'usr_username' => $article_data->sorw_email,
                                //'usr_title' => $reviewer['user_title'],
                                'usr_first_name' => $article_data->sorw_name,
                                'usr_last_name' => $article_data->sorw_last_name,
                                'usr_email' => $article_data->sorw_email,
                                //'usr_pwd' => md5($password),
                                'usr_deeplink_token' => $user_deeplink_token,
                                'usr_status' => 'w',
                                'usr_registered' => 'n',
                                'usr_jnl_standalone' => $jnl_id
                            );
                            $user_id = $Users::insert_record($user_details, $user_data);
                            if($user_id)
                            {
                                $newusername=$article_data->sorw_name.$user_id;
                                $data_username_new = array('usr_username' =>$newusername);
                                $user_condition = "usr_id = {$user_id}";
                                $Users::update_record($data_username_new, $user_condition, $user_data);
                            }
                        }
                        else{
                            $user_id =$records->usr_id;
                        }
                        if ($user_id != '')
                        {

                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                            if(isset($pool_id) && isset($source_id) && isset($destination_id))
                            {
                                $articleflowdata = $Article_flow::get_single_record('aflw_id',"aflw_jwf_id={$destination_id} AND aflw_assignment_type_id IS NOT NULL AND aflw_usr_id={$user_id} AND aflw_art_id = {$art_id}");
                            }
                            else
                            {
                                $articleflowdata = $Article_flow::get_single_record('aflw_id',"aflw_parent_flow_id={$aflw_id} and aflw_usr_id={$user_id}");
                            }
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                            if(isset($articleflowdata->aflw_id) && $articleflowdata->aflw_id!='' && !empty($records))
                            {
                                $return_array['dataexist']=$records->usr_first_name.' '.$records->usr_last_name." already shortlisted";
                                return  $this->warning('Warnings',200,$return_array,'warning');
                            }
                            elseif(isset($records->usr_status) && $records->usr_status =='n')
                            {
                                $return_array['dataexist']=$records->usr_first_name.' '.$records->usr_last_name." is an inactive user so can't shortlist as reviewer";
                                return  $this->warning('Warnings',200,$return_array,'warning');
                            }
                            elseif(isset($records->usr_status) && $records->usr_status =='s')
                            {
                                $return_array['dataexist']=$records->usr_first_name.' '.$records->usr_last_name." is a suspended user so can't shortlist as reviewer";
                                return  $this->warning('Warnings',200,$return_array,'warning');
                            }
                            $return_array['status']="success";
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                            if(isset($pool_id) && isset($source_id) && isset($destination_id))
                            {
                                $reviewer_role = $Generic_flows::get_single_record('jwf_role_id as role_id',"jwf_id={$destination_id}");
                            }
                            else
                            {
                                $aflw_jwf_id = $Article_flow::get_single_record('aflw_jwf_id',"aflw_id={$aflw_id}")->aflw_jwf_id;
                                $reviewer_role = $Generic_flows::get_single_record('jwf_role_id as role_id',"jwf_id={$aflw_jwf_id}");
                            }
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                            /* 3.1  format data to be inserted */
                            $role_in_jnl = $role_in_artp = false;

                            $check_role_exist ="usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$reviewer_role->role_id} AND usrj_artp_id IS null";

                            $get_jnl_role = $User_to_journals::get_single_record('usrj_id', $check_role_exist);

                            if (!empty($get_jnl_role))
                            {
                                $role_in_jnl = true;
                                $user_role_id = $get_jnl_role->usrj_id;
                            }

                            $check_role_exist_arttype= "usrj_jnl_id={$journal_id} AND usrj_usr_id={$user_id} AND usrj_role_id={$reviewer_role->role_id} AND  usrj_artp_id={$article_type_id}";

                            $get_artp_role = $User_to_journals::get_single_record('usrj_id', $check_role_exist_arttype);
                            if (!empty($get_artp_role))
                            {
                                $role_in_artp = true;
                                $user_role_id = $get_jnl_role->usrj_id;
                            }

                            $user_role_details = array(
                                'usrj_jnl_id' => $journal_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $reviewer_role->role_id,
                                'usrj_artp_id' => null,
                                'usrj_invite' => 'y' // Changed Y to y. Y not used anywhere
                            );


                            if ($role_in_jnl === false)
                            {
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                            }
                            /* 3.3 register user as article type reviewer  */
                            $user_role_details['usrj_artp_id'] = $article_type_id;
                            if ($role_in_artp === false)
                            {
                                $user_role_id = $User_to_journals::insert_record($user_role_details, $user_data);
                            }

                            if ($user_role_id != '')
                            {
                                /* 4.1 get article details for email content */
                                $select = 'art_id, art_artp_id,art_title, aflw_id, aflw_level, artp_article_type, jnl_journal_name, jwf_id, jwf_assignment, jwf_stage_type, jwf_stage_name, jwf_status_name, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,aflw_status';
                                $article_details = $Articles::get_article_details($select,"aflw_id={$aflw_id}",null,true);

                                $article_details = $article_details[0];
                                $article_id =$article_details->art_id;
                                $data['aflw_usr_id'] = $user_id;
                                $data['aflw_art_id'] = $article_id;
                                $data['aflw_parent_flow_id'] = $aflw_id;
                                /* 4.2 get article flow and permissions */
                                $article_flow_status = 'u';

                                /* 5 insert data into article flow and get the new id */
                                $data['aflw_status'] = $article_flow_status;
                                $data['aflw_assigned_date'] = date('Y-m-d H:i:s');
                                $data['aflw_jwf_id'] = $article_details->jwf_id;
                                $data['aflw_level'] = $article_details->aflw_level;
                                /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                                if(isset($pool_id) && isset($source_id) && isset($destination_id))
                                {
                                    $data['aflw_assignment_type_id'] =  $pool_id;
                                    $data['aflw_source_assignment_id'] =  $source_id;
                                    $data['aflw_jwf_id'] =  $destination_id;
                                    $data['aflw_reviewer_added_by_stage_status'] = 'p';
                                }
                                /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                                $data['aflw_author_suggested']='y';

                                $article_flow_id = $Article_flow::insert_record($data, $user_data);
                                if ($article_flow_id > 0)
                                {
                                    $article_reviewer_data ['sorw_aflw_id'] = $article_flow_id;
                                    $article_reviewer_data ['sorw_suggested_reviewer_id'] = $user_id;
                                    $article_reviewer_data ['sorw_suggested_user_id'] = $user_data['user_id'];
                                    if ($article_flow_status == 'i')
                                    {
                                        $article_reviewer_data ['sorw_invited_by'] = $user_data['user_id'];
                                        $article_reviewer_data['sorw_invited_on'] = date('Y-m-d H:i:s');
                                    }
                                    $article_reviewer_data['sorw_suggested_on'] = date('Y-m-d H:i:s');
                                    $article_reviewer_data['sorw_art_id'] = $article_id;
                                    $article_reviewer_data['sorw_usr_source'] = "s";
                                    $article_reviewer_data['sorw_author_suggested'] = "y";

                                    $Article_reviewers::insert_record($article_reviewer_data, $user_data);

                                    /*new modification*/
                                    $update_flows =array();
                                    if($article_data->sorw_shortlisted_reviewer!='')
                                    {
                                        $update_flows =json_decode($article_data->sorw_shortlisted_reviewer,true);
                                        array_push($update_flows,$article_flow_id);
                                    }
                                    else{
                                       array_push($update_flows,$article_flow_id);
                                    }
                                    $update_reviewers=array('sorw_shortlisted_reviewer'=>json_encode($update_flows));
                                    $Article_reviewers::update_record($update_reviewers,"sorw_id=".$sorw_id);
                                }
                                    //}
                                    /* 9 set response */


                                    $Article_versions_reviewers=new \App\Models\Article_versions_reviewers;

                                    $revier_exist = $Article_versions_reviewers::get_single_record('count(artvr_id) as count',"artvr_article_id={$article_id} AND artvr_user_id={$user_id}");
                                    if($revier_exist->count > 0)
                                    {
                                        $criteria_revwr="artvr_article_id={$article_id} AND artvr_user_id={$user_id}";

                                        $Article_versions_reviewers::delete_records($criteria_revwr,'',$user_data);
                                    }

                                    $get_article_rec = $Articles::get_single_record('art_pre_all_ids',"art_id={$article_id}");

                                    $reviwers_details = array(
                                                            'artvr_user_id' => $user_id,
                                                            //'artvr_prev_art_id' => $user_id,
                                                            'artvr_article_id' => $article_id,
                                                            'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
                                                    );
                                    $Article_versions_reviewers::insert_record($reviwers_details,$user_data);

                                    if ( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' )
                                    {
                                        $del_criteria = "usra_art_id={$article_id} AND usra_usr_id={$user_id}";
                                        $User_articles::delete_records($del_criteria,'',$user_data);
                                    }
                                }
                            }
                    }
                }
            }

           return  $this->success('Success', 200, $return_array);


        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }

    /**
     * Boolean seach string manipulation
     * 1.filter data like key => value pair
     * 2.single search => value (only for user name / email)
     */
    public function manipulate_Bserach_string($searchSting)
    {
        $return_arr = array();
        if($searchSting!= '')
        {
            $filters_arr = array('name','email','journal','keyword','role','title','retired','institution','post code','country','status','task','count','period');
            $filters_operand = array('and','or');

            $seach_arr = str_split($searchSting);
            $var_filter = $sub_var = '';
            $ans_flag = $operand_flag = false;
            $i = 1;
            foreach($seach_arr as $key=>$val)
            {
                if($val != ':')
                {
                    $sub_var .= $val;
                }

                if(in_array(trim($sub_var),$filters_arr))
                {
                    $var_filter =  $sub_var;
                    $sub_var = '';
                }
                elseif(trim($val) == '"')
                {
                    if($ans_flag=== false)
                    {
                        $ans_flag= true;
                    }
                    else
                    {
                        $ans_flag= false;
                    }

                }
                if($ans_flag == false && $sub_var!= '' && $var_filter != '' && $operand_flag == false)
                {
                    $return_arr[trim($var_filter)] = str_replace('"','',trim($sub_var));
                    $sub_var = $var_filter = '';
                    $operand_flag = true;
                }
                if($operand_flag == true && $sub_var!= '' && in_array(strtolower(trim($sub_var)),$filters_operand))
                {
                    $return_arr['operand'.$i] = trim($sub_var);
                    $i++;
                    $operand_flag = false;
                    $sub_var = '';
                }
            }

            if(count($return_arr) == 0 && $sub_var != '')
            {
                $return_arr['single_search'] = trim($sub_var);
            }
        }
        return $return_arr;
    }


    public function review_connect_add(Request $request)
    {
        try {
            $post_arr = $request->all();
            if (!isset($post_arr['new_reviewer']['hdn_usr_info'])) {
                $result_arr['status'] = 'error';
                $result_arr['msg'] = 'Please select a user.';
                echo json_encode($result_arr);
                return;
            }
            $max_limit_ignore = $post_arr['new_reviewer']['max_limit_reached'];
            $shortlisted_reviewers_exceeded = $post_arr['new_reviewer']['shortlisted_reviewers_exceeded'];
            if ($shortlisted_reviewers_exceeded == 1 && $max_limit_ignore == 0) {
                $result['status'] = 'excess';
                $result['msg'] = 'The number of reviewers invited exceeds the maximum number of reviewers required. Do you wish to continue?';
                echo json_encode($result);
                return;
            }
            $selected_usr_array = $post_arr['new_reviewer']['hdn_usr_info'];
            $data['client_functionality'] = $this->current_client->functionality;
            $data['order'] = null;
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.review_connect';

            $result_arr = array();
            foreach ($selected_usr_array as $key => $details_encrypted) {
                $post = $post_arr;
                unset($post['hdn_usr_info']);
                $details = json_decode(($details_encrypted));
                $post['new_reviewer']['email_search'] = $details->contact->emails[0]->email ?? null;
                $post['new_reviewer']['title'] = '';
                $post['new_reviewer']['fname'] = $details->firstName ?? null;
                $post['new_reviewer']['lname'] = $details->lastName ?? null;
                $post['new_reviewer']['email'] = $details->contact->emails[0]->email ?? null;
                $post['new_reviewer']['recentOrganizations'] = $details->recentOrganizations ?? null;
                $post['new_reviewer']['alt_emails'] = $details->contact->emails ?? null;
                $post['new_reviewer']['usr_source'] = 'p';
                $post['new_reviewer']["usr_r_id"] = $details->researcherId ?? null;
                if (isset($details->orcid) && $details->orcid != '') {
                    $post['new_reviewer']['usr_orcid'] = $details->orcid ?? null;
                }
                $jnl_id = decrypt_link($post_arr['new_reviewer']['jnl_id']);
                $jnl_data = Journals::get_single_record_with_bind_cond('jnl_id,jnl_standalone', array('jnl_id' => $jnl_id));

                $jnl_condition = ($jnl_data->jnl_standalone == 'y') ? ' AND usr_jnl_standalone = ' . $jnl_data->jnl_id : ' AND usr_jnl_standalone IS null';
                if (isset($details->contact->emails) && count($details->contact->emails) > 0) {
                    $existing_usr_ids = $this->get_user_emails($details, $jnl_condition);
                }

                if (isset($existing_usr_ids[0]->usr_id)) {
                    $post_data = $post_arr['new_reviewer'];
                    unset($post_data['hdn_usr_info']);
                    $post_data["journal_id"] = $post_arr['new_reviewer']['jnl_id'];
                    $post_data["max_limit_reached_confirm"] = $post_arr['new_reviewer']['max_limit_reached'];
                    $post_data["hdn_short_rvws_ids"] = encrypt_link($existing_usr_ids[0]->usr_id);
                    $post_data["hdn_forms_validated"] = true;
                    $post_data["search_from"] = 'advance_search';
                    $post_data["usr_source"] = 'p';
                    $result = $this->allocate_publons_stage_users_method($post_data);
                    $result['msg'] = ' <b>##USER##</b> allocated to the stage';
                } else {
                    $result = $this->add_reviewer_from_publons_and_invite($post);
                    $result['msg'] = 'ReView account created for <b>##USER##</b> and allocated to the stage';
                }
                $result['name'] = $details->publishingName ?? null;
                $result_arr[] = $result;
            }
            $response_msg = '';
            $ret_html = '';
            $full_html = '';
            foreach ($result_arr as $key => $value) {
                if (isset($value['stage_alloc_usr'])) {
                    $ret_html .= $value['stage_alloc_usr'];
                }
                if (isset($value['reviewer_data'])) {
                    $ret_html .= $value['reviewer_data'];
                }
                if (isset($value['status']) && $value['status'] == 'success') {
                    $msg = str_replace('##USER##', $value['name'], $value['msg']);
                    $response_msg .= $msg . '</br>';
                } else {
                    $response_msg .= '<span  style="color: red;">Error shortlisting ' . $value['name'] . '</span></br>';
                }
            }
            $result = array( 'status' => 'success', 'reviewer_data' => $ret_html );
            if ($full_html != false) {
                $result['stage_alloc_usr'] = $full_html;
            }
            $result['response_msg'] = $response_msg;
            return $this->success('success', 200, $result);
        } catch (Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }
    public function allocate_publons_stage_users_method($post_data)
    {
        try {
            $current_client = $this->current_client;
            $current_user = $this->get_current_user_details();

            $user_ids = array();
            if ($post_data['hdn_short_rvws_ids'] != '') {
                $user_ids = explode(',', $post_data['hdn_short_rvws_ids']);
            }
            $alternate_reviewers = array();
            if (isset($current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')) {
                if (isset($post_data['hdn_alt_rvws_ids']) && $post_data['hdn_alt_rvws_ids'] != '') {
                    $alt_user_ids = explode(',', $post_data['hdn_alt_rvws_ids']);
                    if (count($alt_user_ids) > 0) {
                        $alt_user_ids = array_unique($alt_user_ids);
                        foreach ($alt_user_ids as $alt_rwrs) {
                            $alternate_reviewers[] = decrypt_link($alt_rwrs);
                        }
                    }
                }
            }
            $current_stage_id = decrypt_link($post_data['stage_status_id']);
            $journal_id = decrypt_link($post_data['journal_id']);
            $article_id = decrypt_link($post_data['article_id']);
            $search_from = (isset($post_data['search_from']) ? $post_data['search_from'] : '');
            $max_limit_reached_confirm = (isset($post_data['max_limit_reached_confirm']) ? $post_data['max_limit_reached_confirm'] : '');
            $unavailable_confirm = (isset($post_data['unavilable_status_confirm']) ? $post_data['unavilable_status_confirm'] : '');
            $unavilable_status = (isset($post_data['unavilable_status']) ? $post_data['unavilable_status'] : '');

            $select_journal_data = "jnl_id,jnl_standalone,jnl_journal_code,jset_date_format";
            $journal_table = (new Journals())->getTable();
            $journal_settings_table = (new Journal_settings())->getTable();
            $join_tables = [
                "main_table" => $journal_table,
                "join_table" => [$journal_settings_table => [$journal_settings_table . '.jset_jnl_id', $journal_table . '.jnl_id', "left"]]
            ];
            $join_cnd = "jnl_id = $journal_id ";
            $jnl_data = Journals::get_results_using_joins($join_tables, $select_journal_data, $join_cnd, 'single');
            $jnlcode = (isset($jnl_data) && $jnl_data->jnl_journal_code) ? $jnl_data->jnl_journal_code :"";
            $return_data = array(
                'status' => 'failed',
                'msg' => ''
            );
            $msg = '';
            $already_added = array();
            $added = array();
            $total_assignments = 0;
            if (count($user_ids) > 0) {
                $today = date('Y-m-d H:i:s', time());

                $get_article_rec = $this->Articles->get_single_record(
                    '*',
                    array(
                        'art_id' => $article_id
                    )
                );

                if (empty($get_article_rec)) {
                    $return_data['msg'] = 'You do not have permission to access that page';
                    echo json_encode($return_data);
                    return;
                }
                $all_user_roles = $this->validate_user_journal($this->journal_code, $current_user['user_id'], $get_article_rec->art_artp_id);
                $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
                $user_roles_list = $this->get_article_user_roles($all_user_roles, $article_id, $all_roles);
                $user_article_type_roles = isset($user_roles_list['role_id']) ? $user_roles_list['role_id'] : array();
                $article_cur_stage = Article_flow::get_aticle_statuses($article_id, $current_user, $current_stage_id, true);
                $article_cur_stage = $article_cur_stage[0];
                $assigning_roles = json_decode($article_cur_stage->jwf_parent_user_roles);
                $inviting_roles = json_decode($article_cur_stage->jwf_who_can_invite);
                if ($inviting_roles == null && $article_cur_stage->jwf_assignment == 'invitation') {
                    $inviting_roles = $assigning_roles;
                }
                $invite_permission = false;
                if (
                    count(array_intersect($assigning_roles, $user_article_type_roles)) > 0
                    || count(array_intersect($inviting_roles, $user_article_type_roles)) > 0
                ) {
                    if (count(array_intersect($inviting_roles, $user_article_type_roles)) > 0) {
                        $invite_permission = true;
                    }
                } else {
                    $return_data['msg'] = 'You do not have permission to access that page';
                    echo json_encode($return_data);
                    return;
                }
                $condition['aflw_status'] = $article_cur_stage->aflw_status; //$current_stage_id
                $allocated_usrs = Article_flow::get_single_record_with_bind_cond('count( DISTINCT aflw_usr_id) as cnt', array('aflw_parent_flow_id' => $current_stage_id));
                $declined_users = Article_flow::get_single_record_with_bind_cond('count(*) as count', array('aflw_parent_flow_id' => $current_stage_id, 'aflw_status' => 'd'));
                $return_data['allocate_complete'] = false;
                if ((($allocated_usrs->cnt + count($user_ids)) - $declined_users->count) >= $article_cur_stage->aflw_stage_min_users)
                {
                    $return_data['allocate_complete'] = true;
                }

                if ($article_cur_stage->jwf_stage_type == "review") {
                    if ($unavailable_confirm == 'y' && $unavilable_status == 0) {
                        $return_data['status'] = 'unavailable';
                        $return_data['msg'] = 'unavailable_user';
                        echo json_encode($return_data);
                        return;
                    }
                }
                if ($max_limit_reached_confirm == 0 && (($allocated_usrs->cnt + count($user_ids)) - $declined_users->count) > $article_cur_stage->aflw_stage_max_users) {
                    if ($article_cur_stage->jwf_stage_type == 'review') {
                        $return_data['status'] = 'excess';
                        $return_data['msg'] = 'The number of reviewers invited exceeds the maximum number of reviewers required. Do you wish to continue?';
                        $return_data['post_data'] = $post_data;
                    } else {
                        $return_data['status'] = 'failed';
                        $return_data['msg'] = 'Maximum number of users for the stage exceeded';
                    }
                    echo json_encode($return_data);
                    return;
                }
                $parent_status_record = Article_flow::get_single_record_with_bind_cond('*', array('aflw_id' => $current_stage_id));
                if ($article_cur_stage->aflw_status == 'w' || (isset($search_from) && $search_from == 'advance_search')) {
                    $req_role_id = $article_cur_stage->jwf_role_id;
                }
                DB::beginTransaction();
                $inserted_ids = array();
                $in = 0;
                $role_name_multi = '';
                $change_assignment = false;
                $order = 1;
                if (isset($current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y') {
                    $sel_max_order = 'max(afap_number) as max_cnt_val';
                    $max_order = Article_flow_alternativereviewer_priorityorder::get_single_record_with_bind_cond($sel_max_order, array('afap_parent_flow_id' => $current_stage_id, 'afap_art_id' => $article_id));
                    if ($max_order->max_cnt_val != null) {
                        $order = $max_order->max_cnt_val + 1;
                    }
                }

                foreach ($user_ids as $user_id) {
                    $user_id = decrypt_link($user_id);
                    if ($current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y' && $article_cur_stage->jwf_stage_type == "review") {
                        $user_assigned_cnt = array();
                        $role_names = '';
                        $change_assignment = false;
                        $change_role_alert = false;
                        $users_list_arttp = array();
                        $article_assigned_users = $this->get_allocated_users_list(array($article_id));
                        $condi = array(
                            'usra_art_id' => $article_id,
                            'usra_usr_id' => $user_id
                        );
                        $user_roles_data = User_articles::get_allocate_user_with_role('usra_art_id,usra_usr_id as usr_id,usra_role_id as role_id,role_name,role_assigned_role', $condi, 'role_name');
                        $user_roles = $this->validate_user_journal($jnlcode, $user_id, $get_article_rec->art_artp_id);
                        $only_one_roles = '';
                        foreach ($user_roles['role_id'] as $role_cnt) {
                            $usrs_list_artp = User_to_journals::get_usrs_count($get_article_rec->art_artp_id, $role_cnt);
                            if (count($usrs_list_artp) == 1) {
                                $only_one_roles .= $usrs_list_artp[0]->role_name . '/';
                            }
                        }
                        if ($only_one_roles != '') {
                            $only_one_roles = trim($only_one_roles, '/');
                            $array_data['user_id'] = $user_id;
                            $array_data['journal_id'] = $journal_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = $article_id;
                            $sele_usr_name = $this->get_user_display_name($array_data);
                            $msg_warnings = str_replace('##user full name##', $sele_usr_name, "Sorry! you cannot assign <span id='usr_info_warning'>##user full name## </span>  as a reviewer because the user only ##user role## for this article.");
                            $return_data['msg'] = str_replace('##user role##', $only_one_roles, $msg_warnings);
                            return ($return_data);
                        }
                        $select = 'aflw_usr_id  as usr_id,jwf_stage_name,jwf_role_id as role_id,role_name';
                        $where = array(
                            'aflw_art_id' => $article_id,
                            'jwf_stage_type =' => 'post_assessment'
                        );
                        $stage_assignment_revwr = Article_flow::get_article_flow_details($select, $where);
                        if (!empty($stage_assignment_revwr)) {
                            foreach ($stage_assignment_revwr as $stages) {
                                if ($user_id == $stages->usr_id) {
                                    $array_data['user_id'] = $user_id;
                                    $array_data['journal_id'] = $journal_id;
                                    $array_data['flag'] = true;
                                    $array_data['article_id'] = $article_id;
                                    $selected_user_name = $this->get_user_display_name($array_data);
                                    $return_data['msg'] = str_replace('##user full name##', $selected_user_name, "Sorry! you cannot assign <span id='usr_info_warning'>##user full name## </span> as a reviewer because the user already participated in a post review stage.");
                                    $return_data['status'] = 'warning_restrict';
                                    return ($return_data);
                                }
                            }
                        }
                        if (!empty($user_roles_data)) {
                            foreach ($user_roles_data as $details) {
                                if (array_key_exists($details->role_id, $article_assigned_users[$article_id]) && in_array($details->role_assigned_role, privileged_user_roles())) {
                                    $where = array(
                                        'usra_art_id' => $article_id,
                                        'usra_role_id' => $details->role_id
                                    );
                                    $user_assigned_cnt = User_articles::get_assigned_users('count(*) as cnt', $where);
                                    if (!empty($user_assigned_cnt) && $user_assigned_cnt[0]->cnt == 1) {
                                        $role_names = Roles::get_role_name($details->role_id) . '/';
                                        if ($current_user['user_id'] == $user_id) {
                                            $change_role_alert = true;
                                        }
                                        $change_assignment = true;
                                        if (count($user_ids) == 1 && $current_user['user_id'] == $user_id)
                                        {
                                            $change_assignment = false;
                                        }
                                    }
                                    $role_names = trim($role_names, '/');
                                    $change_msg = str_replace('##roles##', $role_names, "You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.");
                                    $return_data['change_assignment'] = $change_assignment;
                                    $return_data['change_msg'] = $change_msg;
                                    $condtn = ' AND usrj_role_retired = "n" AND usrj_role_id =' . $details->role_id;
                                    $users_list_arttp = User_to_journals::get_user_role_classification($get_article_rec->art_artp_id, 'a', array(), null, null, $condtn, false);
                                    if (!empty($users_list_arttp) && count($users_list_arttp) == 1 && in_array($users_list_arttp[0]->role_assigned_role, array('editor_in_chief', 'associate_editor'))) {
                                        $array_data['user_id'] = $users_list_arttp[0]->user_id;
                                        $array_data['journal_id'] = $journal_id;
                                        $array_data['flag'] = true;
                                        $array_data['article_id'] = $article_id;
                                        $selected_usr_name = $this->get_user_display_name($array_data);
                                        $msg_warning = str_replace('##user full name##', $selected_usr_name, "Sorry! you cannot assign <span id='usr_info_warning'>##user full name## </span>  as a reviewer because the user only ##user role## for this article.");
                                        $return_data['msg'] = str_replace('##user role##', $users_list_arttp[0]->role_names, $msg_warning);

                                        if ($users_list_arttp[0]->user_id == $current_user['user_id']) {
                                            $return_data['msg'] = str_replace('##user role##', $users_list_arttp[0]->role_names, "As you are the only ##user role## for this article, you are not allowed to assign yourself as a reviewer.");
                                        }
                                        echo json_encode($return_data);
                                        return;
                                    }
                                }
                            }
                        }
                        if ($change_role_alert === true) {
                            $role_array = explode('/', $role_names);
                            if (count($role_array) > 1)
                            {
                                $role_names = rtrim(str_replace('/', ', ', $role_names), ', ');
                            }
                            else
                            {
                                $role_names = str_replace('/', ' ', $role_names);
                            }
                            $return_data['msg'] = str_replace('##user role##', $role_names, "As you are the only ##user role## for this article, you are not allowed to assign yourself as a reviewer.");
                            echo json_encode($return_data);
                            return;
                        }
                        if ($change_assignment === true) {
                            $role_names = trim($role_names, '/');
                            $role_name_multi .= !empty($role_name_multi) ? ',' . $role_names : $role_names;
                        }
                    }
                    $condition = array(
                        'aflw_usr_id' => $user_id,
                        'aflw_parent_flow_id' => $current_stage_id
                    );
                    $get_record = Article_flow::get_single_record_with_bind_cond('*', $condition);
                    if ($get_record != '') {
                        $already_added[] = $user_id;
                        $return_data['id_arr_duplication'][] = encrypt_link($user_id);
                    } else {
                        $data['aflw_usr_id'] = $user_id;
                        $data['aflw_art_id'] = $article_id;
                        $data['aflw_parent_flow_id'] = $current_stage_id;
                        $data['aflw_status'] = 'u';

                        if ($article_cur_stage->aflw_status == 'p') {
                            $due_date = new DateTime($today);
                            $due_date = $due_date->modify('+' . $article_cur_stage->jwf_tat_complete . ' days');
                            $due_date = $due_date->format('Y-m-d H:i:s');
                            $data['aflw_due_date'] = $due_date;
                            $data['aflw_status'] = 'a';
                            $data['aflw_accepted_date'] = $today;
                        }
                        $data['aflw_assigned_date'] = $today;
                        $data['aflw_jwf_id'] = $parent_status_record->aflw_jwf_id;
                        $data['aflw_level'] = $parent_status_record->aflw_level;

                        $inserted_id = Article_flow::insert_record($data, $current_user);

                        $article_reviewer_data['sorw_aflw_id'] = $inserted_id;
                        $article_reviewer_data['sorw_suggested_reviewer_id'] = $user_id;
                        $article_reviewer_data['sorw_suggested_user_id'] = $current_user['user_id'];
                        $article_reviewer_data['sorw_suggested_on'] = $today;
                        $article_reviewer_data['sorw_art_id'] = $article_id;
                        if (isset($post_data['usr_source']))
                        {
                            $article_reviewer_data['sorw_usr_source'] = $post_data['usr_source'];
                        }
                        $art_rev_id = Article_reviewers::insert_record($article_reviewer_data, $current_user);
                        if (isset($current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y' && in_array($user_id, $alternate_reviewers) === true) {
                            $alter_arr = array(
                                'afap_usr_id' => $user_id,
                                'afap_art_id' => $article_id,
                                'afap_aflw_id' => $inserted_id,
                                'afap_parent_flow_id' => $current_stage_id,
                                'afap_sorw_id' => $art_rev_id,
                                'afap_number' => $order
                            );
                            Article_flow_alternativereviewer_priorityorder::insert_record($alter_arr, $current_user);
                            if ($inserted_id)
                                $inserted_ids[$in]['afap_number'] = $order;
                            $order++;
                        }
                        if ($inserted_id) {
                            $inserted_ids[$in]['user'] = $user_id;
                            $inserted_ids[$in]['flow'] = $inserted_id;
                            $inserted_ids[$in]['review'] = $art_rev_id;
                            $in++;
                            if ($article_cur_stage->aflw_status == 'w' || (isset($search_from) && $search_from == 'advance_search')) {
                                $user_role_details = array(
                                    'usrj_jnl_id' => $journal_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $req_role_id,
                                    'usrj_artp_id' => null,
                                );
                                $jnl_spec_rev_record = User_to_journals::get_single_record('*', $user_role_details);

                                if ($jnl_spec_rev_record == null) {
                                    User_to_journals::insert_record($user_role_details, $current_user);
                                }
                                $user_role_details['usrj_artp_id'] = $get_article_rec->art_artp_id;
                                $art_type_spec_rev_record = User_to_journals::get_single_record('*', $user_role_details);
                                if ($art_type_spec_rev_record == null) {
                                    User_to_journals::insert_record($user_role_details, $current_user);
                                }
                            }
                            $added[] = $user_id;
                            $total_assignments++;
                            $return_data['id_arr_alloacted'][] = encrypt_link($user_id);
                            if ($current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && $article_cur_stage->jwf_stage_type == "review" && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                                $del_criteria = array(
                                    'usra_art_id' => $article_id,
                                    'usra_usr_id' => $user_id
                                );
                                $this->User_articles->delete_records($del_criteria, '');
                            }
                        } else {
                            $return_data['msg'] = 'Sorry! An error occurred.';
                        }
                        if ($article_cur_stage->jwf_stage_type == 'review' && $article_cur_stage->role_assigned_role == 'reviewer') {
                            $revier_exist = Article_versions_reviewers::get_single_record(
                                'count(artvr_id) as count',
                                array(
                                    'artvr_article_id' => $article_id,
                                    'artvr_user_id' => $user_id
                                )
                            );
                            if ($revier_exist->count > 0) {
                                $criteria_revwr = array('artvr_article_id' => $article_id, 'artvr_user_id' => $user_id);
                                Article_versions_reviewers::delete_records($criteria_revwr);
                            }

                            $reviwers_details = array(
                                'artvr_user_id' => $user_id,
                                'artvr_article_id' => $article_id,
                                'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
                            );
                            Article_versions_reviewers::insert_record($reviwers_details, $current_user);
                        }
                    }
                }

                if ($change_assignment === true) {
                    $role_display_arr = explode(',', $role_name_multi);
                    $role_name_multiple = str_replace(',' . end($role_display_arr), ' and ' . end($role_display_arr), $role_name_multi);
                    $msg .= str_replace('##roles##', $role_name_multiple, "You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.");
                    $return_data['msg'] = $msg;
                    $return_data['status'] = 'warning';
                    return ($return_data);
                }

                if (!empty($added)) {
                    if (DB::commit() === true) {
                        $show_multiple_checkbox = false;
                        if ($invite_permission === true && $article_cur_stage->jwf_stage_type == 'review') {
                            $show_multiple_checkbox = true;
                        }

                        $conflict_interest = array();
                        if ($article_cur_stage->jwf_stage_type == 'review') {
                            $today = date('Y-m-d H:i:s', time());
                            $invite_due_date = new DateTime($today);

                            $invite_due_date = $invite_due_date->modify('+' . $article_cur_stage->jwf_tat_complete . ' days');
                            $invite_due_date = $invite_due_date->format('Y-m-d H:i:s');

                            Article_flow::update_record(array('aflw_invite_due_date' => $invite_due_date), array('aflw_id' => $current_stage_id));
                            if ($current_client->modules->mdl_review_for_doc == 'n')
                            {
                                $conflict_interest = $this->get_article_conflict_array($article_id);
                            }
                        }

                        if ($article_cur_stage->aflw_status == 'p') {
                            if (isset($inserted_id) && !empty($inserted_id))
                                $article_assignment_stage = Article_flow::get_aticle_statuses($article_id, $current_user, $inserted_id, true);
                            if (!empty($article_assignment_stage) && $article_assignment_stage[0]->aflw_parent_flow_id == $article_cur_stage->aflw_id) {
                                $article_cur_stage_assignment = $article_assignment_stage[0];
                            } else {
                                $article_cur_stage_assignment = $article_cur_stage;
                            }
                            $this->get_stage_assignment_emaildetails($added, $load_models, $article_cur_stage_assignment);
                        }
                        $enable_reviewer_queue = false;
                        if (isset($current_client->functionality->cfty_enable_userbased_alternativereviewer_priority) && ($current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y')) {
                            $enable_reviewer_queue = true;
                        }
                        $stage_alloc_usr = '';
                        if (!empty($inserted_ids)) {
                            $array_data['user_id'] = $current_user['user_id'];
                            $array_data['journal_id'] = $jnl_data->jnl_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = null;
                            $suggested_user = $this->get_user_display_name($array_data);
                            foreach ($inserted_ids as $ins) {
                                $assgn_data = new stdClass();
                                $assgn_data->aflw_id = $ins['flow'];
                                $assgn_data->parent_flow_id = $current_stage_id;
                                $assgn_data->aflw_usr_id = $ins['user'];
                                
                                $array_data['user_id'] = $ins['user'];
                                $array_data['journal_id'] = $jnl_data->jnl_id;
                                $array_data['flag'] = true;
                                $array_data['article_id'] = $article_id;
                                $array_data['availability'] = true;
                                $array_data['source'] = isset($post_data['usr_source']) ? $post_data['usr_source'] : null;
                                $array_data['salutation'] = true;

                                $assgn_data->short_listed_user = $this->get_user_display_name($array_data);
                                $assgn_data->suggested_user = $suggested_user;
                                $assgn_data->show_invited = ($article_cur_stage->jwf_assignment == 'invitation') ? true : false;
                                $assgn_data->invited_date = null;
                                $assgn_data->suggested_date = date($jnl_data->jset_date_format);
                                $assgn_data->due_date = null;
                                $assgn_data->aflw_status = $data['aflw_status'];
                                $assgn_data->aflw_returned_date = null;
                                $assgn_data->sorw_id = $ins['review'];
                                $assgn_data->article_id = $article_id;
                                $assgn_data->has_invite_permission = $invite_permission;
                                $assgn_data->has_assign_permission = true;
                                $assgn_data->show_multiple_checkbox = $show_multiple_checkbox;
                                $assgn_data->enable_button_active = true;
                                $show_conflict_interest_message = array();
                                if (!empty($conflict_interest)) {
                                    $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $ins['user']);
                                }
                                $assgn_data->conflict_message = $show_conflict_interest_message;
                                $assgn_data->enable_reviewer_queue = $enable_reviewer_queue;

                            }
                        }

                        $return_data['stage_alloc_usr'] = $stage_alloc_usr;
                    }

                    $return_data['status'] = 'success';
                    $return_data['msg'] = 'User shortlisted to the stage';
                    $return_data['assignment_completed'] = false;
                    if ($article_cur_stage->aflw_status == "p" && ($allocated_usrs->cnt + $total_assignments) >= $article_cur_stage->aflw_stage_min_users && $article_cur_stage->jwf_stage_type !== 'review') {
                        $production_stages = $this->get_production_stages_keys(null, false);
                        if (in_array($article_cur_stage->jwf_stage_type, $production_stages)) {
                            $jnl_roles = $current_user['jnl_user_role'][$jnl_data->jnl_journal_code]['role_id'];
                            $return_data['assignment_completed'] = true;
                            $sql = 'SELECT aflw.aflw_id FROM rvw_article_flow aflw left join rvw_journal_workflows on aflw.`aflw_jwf_id`=jwf_id WHERE aflw.aflw_art_id = ' . $article_id . ' AND aflw.aflw_parent_flow_id IS null && aflw.aflw_usr_id IS null && FIND_array_intersect(' . $jnl_roles . ',REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),"]",""),"[","")) = 1 AND aflw.aflw_status = \'p\' and aflw.aflw_id not in (select af.`aflw_parent_flow_id` from rvw_article_flow af where af.`aflw_art_id`=' . $article_id . ' and aflw_parent_flow_id is not null)';
                        }
                        $current_role = Roles::get_single_record("role_name", array("role_id" => $post_data['assign_role_id']));
                        $return_data['assignment_success_msg'] = str_replace('%ROLE_NAME%', $current_role->role_name, '%ROLE_NAME% selection completed');
                    }
                    $short_list_detail = $this->get_short_list_details($current_stage_id);
                    if (!empty($short_list_detail)) {
                        $return_data['short_list_html'] = $short_list_detail['short_list'];
                        $return_data['list_status'] = $short_list_detail['status'];
                    }
                } else if (!empty($already_added)) {
                    $return_data['msg'] = 'User assignment failed. The user has already been assigned to this stage.';
                }
                if (isset($post_data['usr_source']) && $post_data['usr_source'] == 'p') {
                    return $return_data;
                }
                return $return_data;
            } else {
                $return_data['msg'] = 'User allocation failed. You have not selected any users.';
                return $return_data;
            }
        } catch (Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function review_connect(Request $request)
    {
        try {
            $return = array('status' => 'error');
            $post = $request->all();
        $jnl_id = Rv_decrypt($post['jnl_id']);

            $post_data = array(
                'article_id'=> $post['article_id'],
                'hdn_curnt_status_id'=> $post['hdn_curnt_status_id'],
                'hdn_current_stage_id'=> $post['hdn_current_stage_id'],
                'user'=> $post['user'],
                'aflow_id'=> $post['aflow_id'],
                'jnl_id'=> $jnl_id,
            );
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.review_connect';
            $review_connect_config  = Config::get($review_config);
            $exclude_reviewers = $this->reviewer_search($request,$post_data);
            $return['order'] = null;
            $journal_table = (new \App\Models\Journals())->getTable();
            $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
            $select_jnl = "jnl_journal_code,jnl_journal_name,jnl_standalone,jset_reviewer_connect_search_years,jset_date_format,jset_reviewer_connect_limit";
            $select_jnl_condition = "jnl_id = ?";
            $binding_arr = [$jnl_id];
            $tables = array(
                'main_table' => $journal_settings_table,
                'join_table' => array(
                    $journal_table => array($journal_settings_table . '.jset_jnl_id', $journal_table . '.jnl_id', "left")
                    )
                );
                $get_jnl_data =Journal_settings::get_results_using_joins($tables,$select_jnl,$select_jnl_condition,binding_arr: $binding_arr);
                $recommendedReviewers = $this->recommendedReviewers($post, $get_jnl_data[0], $exclude_reviewers,$review_connect_config['review_connect']);

            $article_id = decrypt_link($post['art']);
            $aflow_id = decrypt_link($post['aflow_id']);
            $recommendedReviewers = $this->remove_already_invited_users($recommendedReviewers, $article_id, $aflow_id);
            $data['search_details'] = $recommendedReviewers;

            $data['jset_reviewer_connect_limit'] = $get_jnl_data[0]->jset_reviewer_connect_limit;
            $data['jset_reviewer_connect_search_years'] = $get_jnl_data[0]->jset_reviewer_connect_search_years;
            $return['excess_usr_msg'] = 'The number of reviewers invited exceeds the maximum number of reviewers required. Do you wish to continue?';

            return  $this->success('Success', 200, $recommendedReviewers);
        } catch (Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function reviewer_search(Request $request, $array_value)
    {
        try {

            /* If the ajax function doesn't do session_write_close(),
            *  then your outer page will appear to hang, and opening other pages in new tabs will also stall.
            done to make full use of inline loader */

            $current_user = $this->get_current_user_details();
            $post_array = $request->all();
            $current_client = $this->current_client;
            if ($array_value == null) {
                $search_details = $post_data = $post_array["search"];
            } else {
                $search_details = $post_data = $array_value;
            }
            $order = array_key_exists("order", $post_array) ? $post_array["order"] : '';
            $jnl_id = $post_data['jnl_id'];
            $select_journal_data = "jnl_id,jnl_standalone,jnl_journal_code,jset_date_format,jset_reply_to_email";
            $journal_table = (new Journals())->getTable();
            $journal_settings_table = (new Journal_settings())->getTable();
            $join_tables = [
                "main_table" => $journal_table,
                "join_table" => [$journal_settings_table => [$journal_settings_table . '.jset_jnl_id', $journal_table . '.jnl_id', "left"]]
            ];
            $join_cnd = "jnl_id = $jnl_id ";
            $jnl_data = Journals::get_results_using_joins($join_tables, $select_journal_data, $join_cnd, 'single');

            $jnl_id = ($jnl_data->jnl_standalone == 'y') ? $jnl_data->jnl_id : null;

            $orderby = array();

            $ordeing_arrays = array('name', 'current_assignmets', 'date_count', 'past_oneyr_assignments', 'last_invitation_date', 'rating');

            // reviewer_search_default_filters
            $default_sort_conf = 'clients.' . $current_client->clnt_client_code . '.reviewer_search_default_filters';
            $default_sort_config = Config::get($default_sort_conf);
            $default_sort_value = $default_sort_config['default_sort_column'];

            $filter_optn = '';
            if ($current_client->functionality->cfty_reviewer_search_option_surname == "y") {
                $filter_optn = $default_sort_config['reviewer_filters']; //last_name sort
            }

            $ord_cnt = null;

            if (!empty($order)) {
                $order_array = explode(",", $order);
                $ord_cnt = $order_array[0];
                if ($current_client->functionality->cfty_show_reviewer_keyword_accordion == "y" && $ord_cnt != 0) {
                    $ord_cnt--;
                }
            } elseif (!empty($default_sort_value)) {
                $ord_cnt = 3;
                $order_array = array('3', 'desc');
            }
            $orderby = array();
            if ($ord_cnt != null) {
                $orderby = array(
                    $ordeing_arrays[$ord_cnt],
                    $order_array[1]
                );
            }
            if (!isset($order)) {
                if (isset($search_details['sort_column']) && isset($search_details['sort_oder'])) {
                    if ($search_details['sort_column'] != null && $search_details['sort_oder'] != null) {
                        $colmncnt = $search_details['sort_column'];
                        $columnorder = $search_details['sort_oder'];
                        $orderby = array($ordeing_arrays[$colmncnt], $columnorder);
                    }
                } else {
                    $orderby = array('last_invitation_date', 'asc');
                }
            }
            $return_arr = array();
            if (!empty($search_details)) {
                //INTRV0486 :temporary fix

                $filter_optn = '';
                if ($current_client->functionality->cfty_reviewer_search_option_surname == "y") {
                    // TASK #8785 When the client functionality reviewer_search_option_surname is enabled, a TypeError occurs while searching for reviewers using surnames
                    $filter_optn =  $default_sort_config['reviewer_filters']; // need to change
                }
                $document_module = false;
                if (isset($current_client->modules->mdl_review_for_doc) && $current_client->modules->mdl_review_for_doc == 'y') {
                    $document_module = true;
                }
                $date_format = $this->get_platform_date_format($jnl_id);
                $date_format = $this->date_format_map($date_format);
                $exclude_users = array();

                if ($current_client->functionality->cfty_self_assignment == 'n') {
                    $exclude_users[] = $current_user['user_id'];
                }

                $article_id = decrypt_link($search_details['article_id']);
                $jwf_id = decrypt_link($search_details['hdn_current_stage_id']);

                //   need to check the output for real time scenario
                DB::enableQueryLog();
                $article_flow_users = Article_flow::get_all_records('aflw_usr_id', "aflw_art_id ={$article_id} AND aflw_jwf_id ={$jwf_id}");

                if (!empty($article_flow_users)) {
                    $aflw_usrs = $this->get_column_array($article_flow_users, 'aflw_usr_id');
                    $exclude_users = array_merge($exclude_users, $aflw_usrs);
                }

                $article_authors = Authors::get_all_records('auth_usr_id', "auth_art_id = {$article_id}");
                $auth_usrs = $this->get_column_array($article_authors, 'auth_usr_id');

                $user_author = '';
                if ($document_module != true) {
                    $exclude_users = array_merge($exclude_users, $auth_usrs);
                } else {
                    $user_author = implode(',', $auth_usrs);
                }
                /* Exclude reviewed privilaged user if they perform any task after the review stage. */
                
                if ($current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') {
                    $article_details = Articles::get_single_record('art_pre_all_ids,art_artp_id', "art_id = {$article_id}");
                    $art_ids = array();
                    $art_ids = (isset($article_details->art_pre_all_ids) && $article_details->art_pre_all_ids != null) ? $article_details->art_pre_all_ids : '';
                    $art_ids = ($art_ids != '') ? $art_ids . ',' . decrypt_link($search_details['article_id']) : decrypt_link($search_details['article_id']);

                    $reviewd_privilaged = array();
                    if ($art_ids != null) {
                        $reviewd_privilaged = Reviewed_privilaged_users::get_all_records('rvp_usr_id', "rvp_art_id in({$art_ids})");
                    }
                    $exclude_privilaged = array();
                    if (!empty($reviewd_privilaged)) {
                        foreach ($reviewd_privilaged as $rev) {
                            $exclude_privilaged[] = $rev->rvp_usr_id;
                        }
                    }
                    $exclude_users = array_merge($exclude_users, $exclude_privilaged);
                }
                $exclude_users = (!empty($exclude_users)) ? array_unique(array_filter($exclude_users)) : array();

                //******NEW SECTION USING GLOBAL REVIEWER SEARCH**********START*******//
                //set sudo users in exclude user list  ==> for avoid load from main sql
                $where_cnd = '"sudo" IN(REPLACE(REPLACE(REPLACE(usr_roles,\'"\',""),"]",""),"[",""))';
                $sudo_users = User::get_single_record('group_concat(usr_id) as sudo_users', $where_cnd);
                if ($sudo_users->sudo_users != '') {
                    $sudo_user_arr = explode(',', $sudo_users->sudo_users);
                    $exclude_users = array_merge($exclude_users, $sudo_user_arr);
                }

                $exclude_users = (!empty($exclude_users)) ? array_unique($exclude_users) : array();
                if ($array_value != null) {
                    return $exclude_users;
                }

                // create new scenarios to check the balance code for conformation
                $filter_arr = $this->manage_search_filters($search_details);
                $this->save_reviewer_filter($search_details);
                $standalone_jnl = '';
                if (isset($current_user['usr_jnl_standalone']) && $current_user['usr_jnl_standalone'] != '')
                {
                    $standalone_jnl = $current_user['usr_jnl_standalone'];
                }

                $select = 'usr_id,usr_first_name,usr_middle_name,usr_last_name';
                $blinded_usr_records = Blind_user_articles::get_single_record('bau_usr_ids', 'bau_art_id = ' . decrypt_link($search_details['article_id']));
                if (isset($blinded_usr_records->bau_usr_ids)) {
                    $blinded_usr_ids = json_decode($blinded_usr_records->bau_usr_ids);
                    $exclude_users = array_merge($exclude_users, $blinded_usr_ids);
                }
                // need to create an array to pass data
                $result_count_arr = User::get_user_data_global(true, $exclude_users, $select, $standalone_jnl, $filter_arr);
                $total_result = $result_count_arr->cnt;

                $return_arr['status'] = 'success';
                

                if ($total_result > 0) {
                    $order_by_condition = '';
                    $ordering_column = '';
                    if (isset($filter_arr['keyword_filter']['has_profile_keywords']['OR']))
                    {
                        $order_by_condition .= "keyword_table.keyword_order DESC,";
                    }
                    if (!empty($orderby) && isset($orderby[1])) {
                        if ($filter_optn == "user_surname" && $orderby[0] == "name") {
                            $order_by_condition .= '  TRIM(usr_last_name)  ' . $orderby[1];
                        } elseif ($orderby[0] == "name") {
                            $order_by_condition .= '  TRIM(usr_first_name) ' . $orderby[1];
                        } elseif ($orderby[0] == "last_invitation_date") {

                            $ordering_column = $orderby[0];
                            $order_by_condition .= '  DATE(' . $orderby[0] . ') ' . $orderby[1];
                        } elseif ($orderby[0] == "rating") {
                            $ordering_column = $orderby[0];
                            $order_by_condition .= '  ' . $orderby[0] . ' ' . $orderby[1];
                        } else {
                            $ordering_column = $orderby[0];
                            $order_by_condition .= ' ' . $orderby[0] . ' ' . $orderby[1];
                        }
                    } else {
                        $order_by_condition .= '  usr_id asc';
                    }

                    $order_by = ' ORDER BY ';
                    if ($document_module === true && (!empty($auth_usrs))) {
                        $order_by_condition = $order_by . 'FIELD(usr_id,' . $user_author . ') DESC ,' . $order_by_condition;
                    } else {
                        $order_by_condition = $order_by . ' ' . $order_by_condition;
                    }

                    $date_format = $jnl_data->jset_date_format;
                    $return_arr['result'] = 'true';
                    $segment = 4;
                    $url = 'journal/' . $jnl_data->jnl_journal_code . '/search-reviewers';
                    $url = '';
                    $search_limit = (isset($search_details['limit'])) ? $search_details['limit'] : 10;
                    $pagination = $this->init_pagination($url, $total_result, $search_limit, $segment);
                    // need to create an array to pass data
                    $result_arr = User::get_user_data_global(false, $exclude_users, $select, $standalone_jnl, $filter_arr, $pagination->start, $pagination->limit, $order_by_condition, $date_format, $ordering_column, $jnl_data->jnl_id);
                    $links = str_replace('data-ci-pagination', 'class="user_search_page" data-ci-pagination', $pagination->create_links());


                    $tat_dates = array();
                    if (isset($post_data['hdn_current_stage_id']) && $post_data['hdn_current_stage_id'] != '') {
                        $hdn_current_stage_id = decrypt_link($post_data['hdn_current_stage_id']);

                        $tat_dates = $this->get_tat_dates($hdn_current_stage_id);
                    }

                    if (isset($search_details['article_id']) && $document_module != true) {
                        $conflict_interest = $this->get_article_conflict_array(decrypt_link($search_details['article_id']));
                    }

                    foreach ($result_arr as $usr) {
                        //MANAGE DEFAULT COLUMN VALUE BASED ON ORDERDING DATA
                        //FETCH USRE CURRENT ASSIGNMENT
                        if (isset($usr->current_assignmets)) {
                            $current_assign_global = User::user_current_assignmets($usr->usr_id, $filter_arr)->current_assignmets;
                            $usr->current_assignmets = $usr->current_assignmets . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">' . $current_assign_global . '</abbr>)';
                        } else {

                            $current_assgn_global = User::user_current_assignmets($usr->usr_id, $filter_arr)->current_assignmets;
                            $current_assign_jnl = User::user_current_assignmets($usr->usr_id, $filter_arr, $jnl_data->jnl_id)->current_assignmets;
                            if (empty($current_assgn_global)) {
                                $current_assgn_global = 0;
                            }
                            if (empty($current_assign_jnl)) {
                                $current_assign_jnl = 0;
                            }
                            $usr->current_assignmets = $current_assign_jnl . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">' . $current_assgn_global . '</abbr>)';
                        }
                        //FETCH USER date_count
                        if (isset($usr->date_count)) {
                            $temp_date_count_global = User::user_date_count($usr->usr_id, $filter_arr);
                            if (isset($temp_date_count_global->date_count)) {

                                $usr->date_count = $usr->date_count . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">' . $temp_date_count_global->date_count . '</abbr>)';

                            } else {
                                $usr->date_count = $usr->date_count . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">0</abbr>)';
                            }
                        } else {
                            $temp_date_count_global = User::user_date_count($usr->usr_id, $filter_arr);
                            $temp_date_count_jnl = User::user_date_count($usr->usr_id, $filter_arr, $jnl_data->jnl_id);
                            if (count($temp_date_count_global) > 0) {
                                $total_global = 0;
                                $total_jnl = 0;
                                if (isset($temp_date_count_global->date_count)) {
                                    $total_global = $temp_date_count_global->date_count;
                                }
                                if (isset($temp_date_count_jnl->date_count)) {
                                    $total_jnl = $temp_date_count_jnl->date_count;
                                }
                                $usr->date_count = $total_jnl . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">' . $total_global . '</abbr>)';
                            } else {
                                $usr->date_count = '0(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">0</abbr>)';
                            }
                        }

                        //FETCH USER PAST ONE YEAR ASSIGNMENT
                        if (isset($usr->past_oneyr_assignments)) {
                            $total_sys = User::user_past_oneyr_assignments($usr->usr_id, $filter_arr)->past_oneyr_assignments;
                            if ($total_sys > 0) {
                                $usr->past_oneyr_assignments = $usr->past_oneyr_assignments . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">' . $total_sys . '</abbr>)';
                            } else {
                                $usr->past_oneyr_assignments = $usr->past_oneyr_assignments . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">0</abbr>)';
                            }
                        } else {
                            $total_global = User::user_past_oneyr_assignments($usr->usr_id, $filter_arr)->past_oneyr_assignments;
                            $total_jnl = User::user_past_oneyr_assignments($usr->usr_id, $filter_arr, $jnl_data->jnl_id)->past_oneyr_assignments;
                            if (empty($total_global)) {
                                $total_global = 0;
                            }
                            if (empty($total_jnl)) {
                                $total_jnl = 0;
                            }
                            $usr->past_oneyr_assignments = $total_jnl . '(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">' . $total_global . '</abbr>)';
                        }

                        if ($ordering_column != 'last_invitation_date') {
                            $usr->last_invitation_date = User::user_last_invitation_date($usr->usr_id, $filter_arr, $date_format)->last_invitation_date;
                        }

                        //REVIEW RATING FETCH
                        if (!isset($filter_arr['review_rating_filter']['avg_rating_above']) && !isset($usr->rating) && $ordering_column != 'rating') {
                            $usr->rating = User::user_review_rating($usr->usr_id, $filter_arr)->rating;
                        }
                        if (!isset($filter_arr['review_rating_filter']['avg_rating_above'])) {
                            $usr->rating = User::user_review_rating($usr->usr_id, $filter_arr)->rating;
                        }
                        $usr->searched_profile_kwd = array();
                        $srch_profile_kwd = array();
                        $srch_profile_kwd_id_array = array();
                        $srch_profile_kwd_like_array = array();
                        if (isset($filter_arr['keyword_filter']['has_profile_keywords'])) {

                            $searched_profile_kwd = $filter_arr['keyword_filter']['has_profile_keywords'];
                            if (isset($searched_profile_kwd)) {
                                if (isset($searched_profile_kwd['AND'])) {
                                    $srch_profile_kwd_and = explode(",", $searched_profile_kwd['AND']);
                                    $srch_profile_kwd_id_array = array_merge($srch_profile_kwd_id_array, $srch_profile_kwd_and);
                                    $srch_profile_kwd = array_merge($srch_profile_kwd, $srch_profile_kwd_and);
                                }
                                if (isset($searched_profile_kwd['OR'])) {
                                    $srch_profile_kwd_or = explode(",", $searched_profile_kwd['OR']);
                                    $srch_profile_kwd_id_array = array_merge($srch_profile_kwd_id_array, $srch_profile_kwd_or);
                                    $srch_profile_kwd = array_merge($srch_profile_kwd, $srch_profile_kwd_or);
                                }
                                if (isset($searched_profile_kwd['LIKE'])) {
                                    $srch_profile_kwd_like = explode(",", $searched_profile_kwd['LIKE']);
                                    $srch_profile_kwd_like_array = array_merge($srch_profile_kwd_like_array, $srch_profile_kwd_like);
                                    $srch_profile_kwd = array_merge($srch_profile_kwd, $srch_profile_kwd_like);
                                }
                            }
                            $usr->searched_profile_kwd = $srch_profile_kwd;
                            $usr->search_match_keyword = $srch_profile_kwd_like_array;
                        }

                        //removed an unnecessary !isset condition from here, as detected by SonarQube.
                            $order_kwd = '';
                            $order_kwd_title = '';
                            if (!empty($srch_profile_kwd_id_array)) {
                                $order_kwd = implode(",", $srch_profile_kwd_id_array);
                            }
                            if (!empty($srch_profile_kwd_like_array)) {
                                $order_kwd_title = implode(",", $srch_profile_kwd_like_array);
                            }

                            $temp_data = User::get_profile_keywords_assignment($usr->usr_id, $order_kwd, $order_kwd_title);
                            if ($temp_data != '') {
                                $usr->user_keywords = $temp_data;
                            } else {
                                $usr->user_keywords = '';
                            }
                        $usr->reviwed_keyword = '';
                        $usr->author_keyword = '';
                        if ($current_client->functionality->cfty_show_reviewer_keyword_accordion == 'y') {
                            if (isset($filter_arr['keyword_filter']['has_keywords_in_reviewed_articles'])) {
                                $reviwed = User::getreviwed_article_keyword($usr->usr_id, $filter_arr);
                                if (isset($reviwed->artcount) && $reviwed->artcount > 0)
                                {
                                    $usr->reviwed_keyword = $reviwed->artcount;
                                }
                            }
                            if (isset($filter_arr['keyword_filter']['has_keywords_in_submitted_articles'])) {
                                $authored = User::get_article_submitted_keywords($usr->usr_id, $filter_arr);
                                if (isset($authored->artcount) && $authored->artcount > 0)
                                {
                                    $usr->author_keyword = $authored->artcount;
                                }
                            }
                        }
                        $show_conflict_interest_message = array();
                        if (isset($conflict_interest) && $document_module != true) {
                            $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $usr->usr_id);
                        }
                        $usr->conflict_message = $show_conflict_interest_message;

                        $availability = true;
                        $date_bwn = '';
                        $unavailable_reason = '';
                        if ($current_client->modules->mdl_review_for_doc == 'n') {
                            $users_unavailability = $this->get_users_unavailability($usr->usr_id, $tat_dates);
                            if ($users_unavailability != null) {
                                $availability = false;
                                if ($users_unavailability[0]->unavail_start_date != $users_unavailability[0]->unavail_end_date) {
                                    $date_bwn = ' between ' . date('d-m-Y', strtotime($users_unavailability[0]->unavail_start_date)) . ' and ' . date('d-m-Y', strtotime($users_unavailability[0]->unavail_end_date));
                                } else {
                                    $date_bwn = ' on ' . date('d-m-Y', strtotime($users_unavailability[0]->unavail_start_date));
                                }
                                $unavailable_reason = $users_unavailability[0]->unavail_reason;
                            }
                        }

                        $array_data['user_id'] = $usr->usr_id;
                        $array_data['journal_id'] = $jnl_data->jnl_id;
                        $array_data['flag'] = true;
                        $array_data['article_id'] = null;
                        $array_data['availability'] = true;

                        $usr->user_fullname = $this->get_user_display_name($array_data);
                        $usr->user_availability = $availability;
                        $usr->date_between = $date_bwn;
                        $usr->unavailable_reason = $unavailable_reason;
                        $return_arr['user'] = $usr;
                    }
                    $return_arr['order'] = $order;
                    $return_arr['links'] = $links;
                } else {
                    $return_arr['result'] = 'false';
                    $return_arr['order'] = '';
                }
                $return_arr['total_reviewer_count'] = isset($total_result) ? $total_result : '0';
            }
            return $return_arr;
        } catch (Exception $e) {
            return $e;
        }
    }
    public function add_reviewer_from_publons_and_invite($post_array = null)
    {
        try {
            $result = array(
                'status' => 'failed'
            );
            $post = $post_array;
            $current_client = $this->current_client;
            $reviewer = $post['new_reviewer'];
            $update_arr = null;
            $article_id = decrypt_link($reviewer['article_id']);
            $journal_id = decrypt_link($reviewer['jnl_id']);
            $journal_flow_id = decrypt_link($reviewer['current_status_id']);
            $max_limit_reached = $reviewer['max_limit_reached'];
            $unavilable_user_status = $reviewer['unavilable_user_status'];
            $unavilable_user_confirm = $reviewer['unavilable_user_confirm'];
            $user_data = $this->get_current_user_details();
            $article_data = Articles::get_single_record_with_bind_cond('art_artp_id', array("art_id" => $article_id));
            $article_type_id = $article_data->art_artp_id;

            /* 1.1 server side validation for email or username already exist */

            
            $post_email = trim($reviewer['email']);
            $select_journal_data = "jnl_id,jnl_standalone,jnl_journal_code,jset_date_format,jset_reply_to_email";
            $journal_table = (new Journals())->getTable();
            $journal_settings_table = (new Journal_settings())->getTable();
            $join_tables = [
                "main_table" => $journal_table,
                "join_table" => [$journal_settings_table => [$journal_settings_table . '.jset_jnl_id', $journal_table . '.jnl_id', "left"]]
            ];
            $join_cnd = "jnl_id = $journal_id ";
            $jnl_data = Journals::get_results_using_joins($join_tables, $select_journal_data, $join_cnd, 'single');

            $jnl_id = ($jnl_data->jnl_standalone == 'y') ? $jnl_data->jnl_id : null;
            $journal_code = $jnl_data->jnl_journal_code;

            $email_condition = ' (usr_username = \'' . $post_email . '\' OR usr_email = \'' . $post_email . '\') ';
            if ($jnl_data->jnl_standalone == 'y') {
                $email_condition .= '  AND usr_jnl_standalone = ' . $jnl_data->jnl_id;
            } else {
                $email_condition .= ' AND usr_jnl_standalone IS null';
            }
            //1.2EXIST EMAIL CHECK -- START
            $exist_awaiting_reviewer = array();
            $exist_email_data = User::get_single_record('usr_id,usr_roles,usr_jnl_standalone,usr_status,usr_pwd,usr_url,usr_deeplink_token', $email_condition);
            $email_exist = false;
            $user_id = '';
            if (isset($exist_email_data) && !empty($exist_email_data) > 0) {
                $user_id = $exist_email_data->usr_id;
                $usr_role = json_decode($exist_email_data->usr_roles);
                if (is_array($usr_role) && (in_array('super_admin', $usr_role) || in_array('sudo', $usr_role))) {
                    $email_exist = true;
                } elseif ($exist_email_data->usr_status == 'w') {
                    $exist_awaiting_reviewer = $exist_email_data;
                } else {
                    $email_exist = true;
                }
            }

            //EXIST EMAIL CHECK -- STOP
            /* 1.3 check if  maximum  number of reviewers are allocated
             *   Overriding for edit fly user */
            if ($update_arr == null) {

                $child_count = Article_flow::get_single_record_with_bind_cond("count(DISTINCT aflw_usr_id) as cnt", array('aflw_parent_flow_id' => $journal_flow_id));
                $master_record = Article_flow::get_single_record_with_bind_cond("aflw_stage_max_users", array('aflw_id' => $journal_flow_id));

                /* 1.1 if yes,return with an error message */
                if (empty($master_record)) {
                    $result['msg'] = 'Invalid stage data';
                    echo json_encode($result);
                    return;
                }
                if ($unavilable_user_status == 0 && $unavilable_user_confirm == "y") {
                    $result['status'] = 'unavilable';
                    $result['msg'] = '';
                    return ($result);
                }
                if ($child_count->cnt >= $master_record->aflw_stage_max_users && $max_limit_reached == 0) {
                    $result['status'] = 'excess';
                    $result['msg'] = 'The number of reviewers invited exceeds the maximum number of reviewers required. Do you wish to continue?';
                    return ($result);
                }
            }

            /* 2  add new user record to database
             * 2.1 generate access token for invititation link  */

            DB::beginTransaction();
            $user_deeplink_token = Str::random(20);
            $registered_user = false; //user by sign up -- usr_url
            if (!empty($exist_awaiting_reviewer) && $exist_awaiting_reviewer->usr_status == 'w') {
                $user_id = $exist_awaiting_reviewer->usr_id;
                if (!empty($exist_awaiting_reviewer->usr_pwd) && !empty($exist_awaiting_reviewer->usr_url)) {
                    $user_deeplink_token = $exist_awaiting_reviewer->usr_url;
                    $registered_user = true;
                } else {
                    if (!empty($exist_awaiting_reviewer->usr_deeplink_token)) {
                        $user_deeplink_token = $exist_awaiting_reviewer->usr_deeplink_token;
                    } else {
                        User::update_record(array('usr_deeplink_token' => $user_deeplink_token), array('usr_id' => $user_id));
                    }
                }
            } else {
                if ($email_exist !== true) {
                    $uml_id = $reviewer['email'];
                    $encoded_uml_id = $this->xorEncode($uml_id);
                    $usr_mail = env("APP_ENV") === 'production' ? $reviewer['email'] : "testpub_{$encoded_uml_id}_@reviewdemo.rivervalleytechnologies.com";
                    $user_details = array(
                        'usr_username' => $usr_mail,
                        'usr_title' => $reviewer['title'],
                        'usr_first_name' => $reviewer['fname'] ?? ' ',
                        'usr_last_name' => $reviewer['lname'] ?? ' ',
                        'usr_email' => $usr_mail,
                        'usr_deeplink_token' => $user_deeplink_token,
                        'usr_status' => 'w',
                        'usr_registered' => 'n',
                        'usr_jnl_standalone' => $jnl_id
                    );
                    /* 2.3 insert record into database and get the the new user id */
                    $user_id = User::insert_record($user_details, $user_data);
                }
            }
            /* 3  if $user_id is returned,add roles for new user    */
            if ($user_id != '') {
                $aflw_jwf_id = Article_flow::get_single_record_with_bind_cond('aflw_jwf_id', array('aflw_id' => $journal_flow_id))->aflw_jwf_id;
                $reviewer_role = Generic_flows::get_single_record_with_bind_cond('jwf_role_id as role_id', array('jwf_id' => $aflw_jwf_id));
                /* 3.1  format data to be inserted */
                $role_in_jnl = $role_in_artp = false;

                if (!empty($exist_awaiting_reviewer) || $email_exist == true) {

                    $check_role_exist['usrj_jnl_id'] = $journal_id;
                    $check_role_exist['usrj_usr_id'] = $user_id;
                    $check_role_exist['usrj_role_id'] = $reviewer_role->role_id;
                    $check_role_exist['usrj_artp_id'] = null;
                    $get_jnl_role = User_to_journals::get_single_record_with_bind_cond('usrj_id', $check_role_exist);
                    if (!empty($get_jnl_role)) {
                        $role_in_jnl = true;
                        $user_role_id = $get_jnl_role->usrj_id;
                    }
                    $check_role_exist['usrj_artp_id'] = $article_type_id;
                    $get_artp_role = User_to_journals::get_single_record_with_bind_cond('usrj_id', $check_role_exist);
                    if (!empty($get_artp_role)) {
                        $role_in_artp = true;
                        $user_role_id = $get_jnl_role->usrj_id;
                    }
                }
                $user_role_details = array(
                    'usrj_jnl_id' => $journal_id,
                    'usrj_usr_id' => $user_id,
                    'usrj_role_id' => $reviewer_role->role_id,
                    'usrj_artp_id' => null,
                    'usrj_invite' => 'y'
                );
                /* 3.2  insert the record into database */
                if ($role_in_jnl === false) {
                    $user_role_id = User_to_journals::insert_record($user_role_details, $user_data);
                }
                /* 3.3 register user as article type reviewer  */
                $user_role_details['usrj_artp_id'] = $article_type_id;
                if ($role_in_artp === false) {
                    $user_role_id = User_to_journals::insert_record($user_role_details, $user_data);
                }
                if ($user_role_id != '') {
                    /* 4 generate email  */
                    /* 4.1 get article details for email content */

                    $select = 'art_id, art_artp_id,art_title, aflw_id, aflw_level, artp_article_type, jnl_journal_name, jwf_id, jwf_assignment, jwf_stage_type, jwf_stage_name, jwf_status_name, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,aflw_status';
                    $article_details = Articles::get_article_details($select, "aflw_id={$journal_flow_id}", null, true);
                    $article_details = $article_details[0];

                    $data['aflw_usr_id'] = $user_id;
                    $data['aflw_art_id'] = $article_id;
                    $data['aflw_parent_flow_id'] = $journal_flow_id;

                    /* 4.2 get article flow and permissions */
                    $who_can_invite = array();
                    $article_flow_status = 'u';
                    $invite = false;
                    $article_stage = Article_flow::get_aticle_statuses($article_id, $user_data, $journal_flow_id, true);

                    /* 5 get roles and invite permissions */
                    //commented for-Customisation #1394 : JPR-156 - Avoid automatic sending invitation
                    $who_can_invite = json_decode($article_stage[0]->jwf_who_can_invite);
                    $all_user_roles = $this->validate_user_journal($journal_code, $user_data['user_id'], $article_type_id);
                    $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');

                    $role_data['user_roles'] = $all_user_roles;
                    $role_data['article_id'] = $article_id;
                    $role_data['all_roles'] = $all_roles;
                    $role_data['jnl_id'] = $journal_id;
                    $user_roles = $this->get_article_user_roles($role_data);

                    if (count($user_roles) > 0 && count($who_can_invite) > 0) {
                        /* 5.1 if any of the users roles has permission to invite reviewer, use the revier on fly template  */
                        if (count(array_intersect($user_roles['role_id'], $who_can_invite)) > 0) {
                            $invite = true;
                        }
                    }

                    $has_assign_permission = false;
                    $assigning_roles = ($article_stage[0]->jwf_parent_user_roles != '') ? json_decode($article_stage[0]->jwf_parent_user_roles) : array();
                    if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $assigning_roles)) > 0) {
                        $has_assign_permission = true;
                    }

                    /* 5.2 insert data into article flow and get the new id */
                    $data['aflw_status'] = $article_flow_status;
                    $data['aflw_assigned_date'] = date('Y-m-d H:i:s');
                    $data['aflw_jwf_id'] = $article_details->jwf_id;
                    $data['aflw_level'] = $article_details->aflw_level;

                    $art_flw_exist = false;
                    if (!empty($exist_awaiting_reviewer) || $email_exist === true) {
                        $check_flw_exist_cond = array(
                            'aflw_level' => $article_details->aflw_level,
                            'aflw_usr_id' => $user_id,
                            'aflw_art_id' => $article_id,
                            'aflw_parent_flow_id' => $journal_flow_id,
                            'aflw_jwf_id' => $article_details->jwf_id
                        );

                        $get_flow_detail = Article_flow::get_single_record_with_bind_cond('aflw_id', $check_flw_exist_cond);
                        if (!empty($get_flow_detail)) {
                            $art_flw_exist = true;
                        }
                    }
                    /* 6  insert data into article Article_reviewers  */
                    if ($art_flw_exist === false) {
                        if ($update_arr == null) {
                            $article_flow_id = Article_flow::insert_record($data, $user_data);
                            if ($article_flow_id > 0) {
                                $article_reviewer_data['sorw_aflw_id'] = $article_flow_id;
                                $article_reviewer_data['sorw_suggested_reviewer_id'] = $user_id;
                                $article_reviewer_data['sorw_suggested_user_id'] = $user_data['user_id'];
                                if ($article_flow_status == 'i') {
                                    $article_reviewer_data['sorw_invited_by'] = $user_data['user_id'];
                                    $article_reviewer_data['sorw_invited_on'] = date('Y-m-d H:i:s');
                                }
                                $article_reviewer_data['sorw_suggested_on'] = date('Y-m-d H:i:s');
                                $article_reviewer_data['sorw_art_id'] = $article_id;
                                if (isset($post_array['new_reviewer']['usr_source'])) {
                                    $article_reviewer_data['sorw_usr_source'] = $post_array['new_reviewer']['usr_source'];
                                }
                                Article_reviewers::insert_record($article_reviewer_data, $user_data);
                            }
                        }

                        /* 7  generate content for email invitation  */
                        //commented for-Customisation #1394 : JPR-156 - Avoid automatic sending invitation
                        $new_aloc_usr = new stdClass();
                        $newly_aloc_usrs = Article_reviewers::get_reviewer_data($article_id, $article_details->aflw_id, $jnl_data->jset_date_format, true, $user_id, true);


                        foreach ($newly_aloc_usrs as $new_aloc_usr) {
                            $array_data['journal_id'] = $journal_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = $article_id;
                            $array_data['availability'] = true;
                            $array_data['user_id'] = $new_aloc_usr->reviewer_id;
                            $new_aloc_usr->rvwr_user_full_name = $new_aloc_usr->reviewer_id ? $this->get_user_display_name($array_data) : '';
                            $array_data['user_id'] = $new_aloc_usr->suggested_user_id;
                            $new_aloc_usr->sugg_user_full_name = $new_aloc_usr->suggested_user_id ? $this->get_user_display_name($array_data) : '';
                            $array_data['user_id'] = $new_aloc_usr->invited_user_id;
                            $new_aloc_usr->invite_user_full_name = $new_aloc_usr->invited_user_id ? $this->get_user_display_name($array_data) : '';
                            $new_aloc_usr->usr_id = $new_aloc_usr->reviewer_id;
                        }
                        $result = array();
                        //Feature #1702 : No email for BMJ to send out while add reviewer
                        if ($current_client->functionality->cfty_disable_reviewer_on_fly_email == 'n' && $email_exist == false) {
                            $etmp_name = 'reviewer_on_fly';
                            if (!empty($exist_awaiting_reviewer)) {
                                $etmp_name = 'reviewer_on_fly_awaiting_confirm';
                            }
                            if ($registered_user === false) {
                                $confirmation_url = URL::to('/') . '/' ."awaiting-confirm-mail/" . encrypt_link("&key=" . $user_deeplink_token . "&userid=" . $user_id);
                            } else {
                                $confirmation_url = URL::to('/') . '/' .'confirmation/' . $user_deeplink_token;
                            }
                            $custom_data = array(
                                'confirmation_link' => $confirmation_url,
                                'esl_etmp_action' => 'add_potential_reviewer',
                                'add_potential_reviewer' => true
                            );
                            $email_data = array(
                                'type' => 'global',
                                'action' => 'send',
                                'email_with_login' => true,
                                'user_id' => $user_id,
                                'empt_name' => $etmp_name,
                                'custom_data' => $custom_data
                            );
                            $this->master_email_details($email_data);
                        }
                        /* 9 set response */
                        $result['status'] = 'success';
                        $reviewer_exist = Article_versions_reviewers::get_single_record('count(artvr_id) as count', "artvr_article_id={$article_id} AND artvr_user_id={$user_id}");
                        if ($reviewer_exist->count > 0) {
                            $criteria_revwr = "artvr_article_id={$article_id} AND artvr_user_id={$user_id}";
                            Article_versions_reviewers::delete_records($criteria_revwr, '', $user_data);
                        }

                        $get_article_rec = Articles::get_single_record('art_pre_all_ids', "art_id={$article_id}");

                        $reviwers_details = array(
                            'artvr_user_id' => $user_id,
                            //'artvr_prev_art_id' => $user_id,
                            'artvr_article_id' => $article_id,
                            'artvr_previous_art_ids' => $get_article_rec->art_pre_all_ids
                        );
                        Article_versions_reviewers::insert_record($reviwers_details, $user_data);

                        if ($current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                            $del_criteria = "usra_art_id={$article_id} AND usra_usr_id={$user_id}";
                            User_articles::delete_records($del_criteria, '', $user_data);
                        }
                    } else {
                        $result['status'] = 'failed';
                        $result['msg'] = 'Reviewer already exists';
                    }
                }
            }
            DB::commit();
            return $result;
        } catch (Exception $e) {
            return $e;
        }
    }

    public function review_publons_integrate(Request $request)
    {
        try {
            $postdata = $request->all();
            $article_flow_id = $postdata['artf_id'];
            $aflw_id = decrypt_link($article_flow_id);
            $article_id = decrypt_link($postdata['article_id']);
            $artp_id = decrypt_link($postdata['article_type_id']);

            $user_id = $this->current_user['user_id']; //and pub_status='y'
            $criteria = "pub_usr_id={$user_id} and pub_art_id = {$article_id} and pub_response_status='n'";
            $publons_records = Article_publons::get_single_record('*', $criteria);
            $result = array();
            if (!empty($publons_records)) {
                if ($publons_records->pub_status == "n") {
                    $pub_arr = array("pub_status" => 'y');
                    $publon_id = $publons_records->pub_id;
                    Article_publons::update_record($pub_arr, array('pub_id' => $publon_id), $this->current_user);
                    $publons_records->pub_status = 'y';
                }
                $param_data = array(
                    'article_id' => $article_id,
                    'current_user' => $this->current_user,
                    'publon_key' => $this->jnl_data->jset_publons_key,
                    'publons_records' => $publons_records,
                    'current_client' => $this->current_client,
                    'config' => $this->config,
                    'article_type_id' => $artp_id,
                    'jnl_id' => $this->jnl_data->jnl_id,
                    'jnl_code' => $this->jnl_data->jnl_journal_code,
                    'reply_to_email' => $this->jnl_data->jset_reply_to_email,
                    'art_flow_id' => $aflw_id
                );
                $result = $this->publon_resend($param_data);
            }
            return $result;
        } catch (Exception $e) {
            return $e;
        }
    }
    // TASK #4072 starts
    public function permitted_shortlist(Request $request){
        try{
            $post_data = $request->all();
            $userToJournalsTable = (new \App\Models\User_to_journals())->getTable();
            $rolesTable = (new \App\Models\Roles())->getTable();
            $usersTable = (new \App\Models\User())->getTable();
            $userIds = "";
            $message = "";
            $status = true;
            $tempArr = [];
            // $art_id = Rv_decrypt($post_data['article_id']);
            if($post_data['hdn_short_rvws_ids']!=""){
                $userDet = "";
                $userIds = json_decode(Rv_decrypt($post_data['hdn_short_rvws_ids']));
                $jnlId = Rv_decrypt($post_data['journal_id']);
                $tables = array(
                    'main_table' => $userToJournalsTable,
                    'join_table' => array( $rolesTable => array('role_id', 'usrj_role_id'),
                                            $usersTable => array('usr_id','usrj_usr_id'))
                );
                $select = 'DISTINCT usr_id,CONCAT("<li>",usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name,"</li>") as name';
                $condition = 'role_assigned_role="journal_admin" AND usrj_jnl_id=? AND usrj_artp_id IS NULL';
                $binding_arr = [$jnlId];
                $where_in = 'usr_id IN ('.implode(',',$userIds).')';
                $users = User_to_journals::get_results_using_joins($tables,$select,$condition,'all',binding_arr:$binding_arr,where_in:$where_in);
                $tempArr = $userIds;
                if(count($users) > 0){
                    $status = false;
                    $tempArr = array_values(array_diff($tempArr,$users->pluck('usr_id')->toArray()));
                    $userDet = '<ul style="margin-left: 25%;text-align:left">'.implode(' ',$users->pluck('name')->toArray()).'</ul>';
                    $message = str_replace('##userDet##',$userDet,customTrans('users.user_ja_exist'));
                }
            }
            $return_data = [
                'status' => $status,
                'content' => [
                    'resArr' => $tempArr,
                    'warn_message' => $message
                ],
            ];
            return  $this->success('Success', 201, $return_data);
        }catch(Exception $e){
            return  $this->failure('Failed',500,$e);
        }
    } // TASK #4072 ends
}
