<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Config;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Http\Traits\GeneralEmailTrait;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use \stdClass;
use App\Models\Article_flow;
use WorkflowDataTrait;
use App\Models\Generic_flows;
use App\Models\Journals;
use DateTime;
use Tymon\JWTAuth\Facades\JWTAuth;

class Manage_Services_Api extends Controller
{
    use GeneralEmailTrait;
    public function index()
    {
        try
        {
            $return_arr = array();
            $journal_tbl = new \App\Models\Journals();
            $get_all_journals = $journal_tbl::get_all_records('jnl_id,jnl_journal_name');
            $return_arr['journals'] = $get_all_journals;
            $return_arr['subscription_types']= Config::get('review_apis.subscription_type');
            $return_arr['api_names'] = Config::get('review_apis.api_names');
            return $this->success('success', 200, $return_arr);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }

    public function save_api_client(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'client_name'   => 'required',
                'client_email' => 'required',
                'site_url' => 'required',
                'subscription'   => 'required',
                'api_name' => 'required',
                'expiry' => 'required',
            ]);
            $return_array = array();
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } 
            else 
            {
              $post_data = $request->all();
              $data = array();
              $check_data = array(
                'acl_name' => $post_data['client_name'],
                'acl_email' => $post_data['client_email'],
                'acl_api_name' => $post_data['api_name'],
                'acl_subr_type' => $post_data['subscription'],
                'acl_url' => $post_data['site_url']
              );
              $data = $check_data;
              $data['acl_expiration_period'] = $post_data['expiry'];
                //for sandbox subscription expiration period is in months
                //for production subscription expiration period is in years
                if($post_data['subscription'] == 's')
                {
                    $exp_period = '+'.$post_data['expiry'].' month';
                }
                else
                {
                    $exp_period = '+'.$post_data['expiry'].' year';
                }
                if(!empty($post_data['journals']))
                {
                    $data['acl_journal'] = implode(',',$post_data['journals']);
                }
                else 
                {
                    $data['acl_journal'] = NULL;
                }
                $api_client = new \App\Models\API_client();
                $current_user = $this->get_current_user_details();
                if(isset($post_data['account_id']) && $post_data['account_id'] !== '')
                {
                    $check_client = $api_client::where($check_data)->first();
                    $client_already_present = FALSE;
                    if(!empty($check_client) && $check_client->acl_id !== $post_data['account_id'])
                    {
                        $client_already_present = TRUE;
                    }
                    if($client_already_present == FALSE)
                    {
                        $condition_var = array('acl_id' => $post_data['account_id']);
                        $old_api_data = $api_client::where($condition_var)->first();
                        $data['acl_created_date']  = $old_api_data->acl_created_date;
                        $data['acl_expiry_date']   = date('Y-m-d H:i:s', strtotime($exp_period, strtotime($data['acl_created_date'])));
                        $data['acl_posted_by'] = $current_user['user_id'];
                        $data['acl_proxy_id'] = $current_user['proxy_user_id'];
                        $data['acl_operation'] = 'u';
                        $condition = 'acl_id ='.$post_data['account_id'];
                        $update_records =  $api_client::update_record($data,$condition,$current_user);
                        if($update_records)
                        {
                            $return_array['status'] = 'update';
                            return $this->success('Success', 200, $return_array);
                        }
                    }
                    else
                    {
                        $return_array['status'] = 'duplicate';
                        return $this->success('Success', 200, $return_array);
                    }
                }
                else
                {
                    $check_client = $api_client::where($check_data)->first();
                    if($check_client == NULL)
                    {
                        $api_record  = $api_client::count();
                        $api_record_cnt = $api_record+1;
                        $new_record_cnt = sprintf('%08d', $api_record_cnt);
                        //string
                        $str= 'rvhistory';
                        //current year
                        $ye = date('Y');
                        //current month
                        $mn = date('m');
                        //concatinating string,year,month
                        $api_key    = $str.$ye.$mn.$new_record_cnt;
                        $en_api_key = Hash::make($api_key);//encrypting
                        //end   ---- encryption for api key
                        
                        //start ---- Finding expiration date
                        $exp_date   = date('Y-m-d H:i:s', strtotime($exp_period));
                        //end   ---- Finding expiration date 
                        
                        $data['acl_expiry_date'] = $exp_date;
                        $data['acl_created_date'] = date('Y-m-d H:i:s');
                        $data['acl_api_key'] = $en_api_key;
                        $email_template = new \App\Models\Email_templates();
                        $api_template = $email_template::get_single_record('*',"etmp_name='api_client_invitation'");
                        $api_client_email= $post_data['client_email'];
                        $insert_client = $api_client::insert_record($data, $current_user);
                        $data['user_id']         = $insert_client;
                        $data['proxy_user_id']   = '0';
                        if(!empty($api_template))
                        {
                            $replace_api = $data['acl_api_key'];
                            $current_jnl_date_format = $this->get_platform_date_format();
                            $email_data = new stdClass;
                            $email_data->api_client_id = $insert_client;    
                            $email_data->user_email = $api_client_email;
                            $email_data->mail_recipient_ids = $insert_client;
                            $email_data->email_templates_config = $this->email_templates_config();
                            $email_data->join_config = $this->join_config();
                            $email_data->join_dependency_config = $this->join_dependency_config();
                            $email_data->user_role_tags = $this->user_role_tags();
                            
                            $reply_to=$this->get_reply_to_email();

                                if (isset($reply_to) && $reply_to != '')
                                        $email_data->reply_to = $reply_to;
                                
                            $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                            if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                            $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
    
                            if (isset($api_template->etmp_email_template) && strpos($api_template->etmp_email_template,"OPENING_PARAGRAPH") > 0)
                            $api_template->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$api_template->etmp_email_template);
                            $core_role=(isset($post_data['core_role']))?$post_data['core_role']:'';
                            $email_data->core_role = $core_role;                          
                            $data_response = array(
                                'record' => $api_template,
                                'email_data' => $email_data,
                                'user_data' =>$data,
                                'column_prefix' =>'etmp_',
                            );
                            $this->notify_mail($data_response);
                        }
                        if($insert_client == TRUE) 
                        {
                            //$this->send_email_notification($api_template[0], $template_obj);
                            $return_array['status'] = 'success';
                            return $this->success('Success', 200, $return_array);
                        }
                    }
                    else
                    {
                        $return_array['status'] = 'duplicate';
                        return $this->success('Success', 200, $return_array);
                    }
                }   
            }
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_all_api_records()
    {
        try
        {
            $return_arr = array('status' => 'success');
            $api_client = new \App\Models\API_client();
            $all_records = $api_client::get_all_records('acl_id,acl_name,acl_email,acl_subr_type,acl_expiration_period,acl_expiry_date,acl_created_date,acl_api_name','acl_status != "d"');
            $current_jnl_date_format = $this->get_platform_date_format();
            $apis = Config::get('review_apis.api_names');
            foreach($all_records as $single_records)
            {
                if($single_records->acl_subr_type == 'p')
                {
                    if($single_records->acl_expiration_period > 1)
                    {
                        $single_records->acl_expiration_period = $single_records->acl_expiration_period.' Years';
                    }
                    else
                    {
                        $single_records->acl_expiration_period = $single_records->acl_expiration_period.' Year';
                    }
                    $single_records->acl_subr_type = 'Production';
                }
                else
                {
                    if($single_records->acl_expiration_period > 1)
                    {
                        $single_records->acl_expiration_period = $single_records->acl_expiration_period.' Months';
                    }
                    else
                    {
                        $single_records->acl_expiration_period = $single_records->acl_expiration_period.' Month';
                    }
                    $single_records->acl_subr_type = 'SanDBox';
                }
                $single_records->acl_id = $this->encrypt_data($single_records->acl_id);
                $single_records->acl_expiry_date = date($current_jnl_date_format, strtotime($single_records->acl_expiry_date));
                $single_records->acl_created_date = date($current_jnl_date_format, strtotime($single_records->acl_created_date));
                $single_records->acl_api_name = $apis[$single_records->acl_api_name]['title'];
            }
            $return_arr['records'] = $all_records;
            return $this->success('Success', 200, $return_arr);
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_api_data(Request $request)
    {
        try
        {
            $return_arr = array('status' => 'success');
            $validator = Validator::make($request->all(), [
                'token_faked'   => 'required',
            ]);
            $return_array = array();
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } 
            else 
            {
                $post_data = $request->all();
                $tokened = $this->decrypt_data($post_data['token_faked']);
                $api_client = new \App\Models\API_client();
                $ret_data = $api_client::select('acl_id','acl_name','acl_url','acl_email','acl_subr_type','acl_expiration_period','acl_expiry_date','acl_created_date','acl_api_name','acl_journal') ->where('acl_id',$tokened)->take(1)->get();
                $apis = Config::get('review_apis.api_names');
                $return_arr['records'] = $ret_data;
                return $this->success('Success', 200, $return_arr);
            }
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function delete_api_data(Request $request)
    {
        try
        {
            $return_arr = array('status' => 'success');
            $validator = Validator::make($request->all(), [
                'token_faked'   => 'required',
            ]);
            $return_array = array();
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } 
            else 
            {
                $post_data = $request->all();
                $tokened = $this->decrypt_data($post_data['token_faked']);
                $condition = 'acl_id ='.$tokened;
                $data = array('acl_status' => 'd');
                $api_client = new \App\Models\API_client();
                $current_user = $this->get_current_user_details();
                $update_records = $api_client::update_record($data,$condition,$current_user);
                if($update_records)
                {
                    $return_array['status'] = 'delete';
                    return $this->success('Success', 200, $return_array);
                }

            }
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function check_client_credentials(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $api_key = isset($post_data['api_key']) ? $post_data['api_key'] : '';
            $response_data = NULL;
            //api configuration
            $expires_in  = Config::get('review_apis.expire_time');
            $ms_conv_val =  Config::get('review_apis.ms_conv_val');         
            //manage request api log entry
            $this->log_this_api_entry($request,"Request::\r\n api_key = " . $api_key); //TASK #4666 Api_log_task
            if (!empty($api_key))
            {
                $check_api_client = $this->authenticate_api_key($api_key,$post_data);
                if ($check_api_client->status != FALSE)
                {
                    DB::beginTransaction();
                    $api_client_id = $check_api_client->acl_id;
                    /*
                    * access-token is a time-based authentication key,which is used to authenticate every api call
                    * access-token can be used only once,after its been called that token gets deleted.
                    */
                    $api_client_tbl = new \App\Models\Api_client_tokens();

                    $unique_token = FALSE;
                    while($unique_token == FALSE)
                    {
                        $api_access_token = Str::random(16);
                        $check_access_token = $api_client_tbl::get_single_record('act_acl_id', 'act_access_token ="'.$api_access_token.'"');
                        if($check_access_token == NULL)
                        {
                            $unique_token = TRUE;
                        }
                    }
                    $data = array(
                        'act_acl_id'        => $api_client_id,
                        'act_access_token'  => $api_access_token,
                        'act_status'        => 'a'
                    );
                    /*
                    * check the access token for the client api is already been inserted or not
                    * if inserted update the access token and return the response
                    * if not inserted create a new access token for the client api and return the response
                    */
                    $check_api_client_token = $api_client_tbl::get_single_record('act_acl_id', 'act_acl_id ='.$api_client_id);
                    if ($check_api_client_token != NULL)
                    {
                        $api_client_token_id = $api_client_tbl->update_record($data,'act_acl_id ='.$api_client_id);
                    }
                    else
                    {
                        $data['act_created_date'] = date('Y-m-d H:i:s');
                        $api_client_token_id = $api_client_tbl->insert_record($data);
                    }
                    //convert expires_in to milliseconds for standardization purpose only
                    $data = array(
                        'access_token'  => $api_access_token,
                        'expires_in'    => $expires_in * $ms_conv_val
                    );
                    $response_data = [
                        'status' => 200,
                        'status_message' => TRUE,
                        'data' => $data
                    ];
                    DB::commit();

                }
                else
                {
                    $response_data = [
                        'status' => 401,
                        'status_message' => FALSE,
                        'message' => $check_api_client->message
                    ];
                    if($check_api_client->message == 'Site url required')
                        $response_data['status'] = 400;
                }
            }
            else
            {
                $response_data = [
                    'status' => 400,
                    'status_message' => FALSE,
                    'message' => 'api key required'
                ];
            }
            $response_obj = (object) $response_data;
            $response_jsn = json_encode($response_obj);
            $this->log_this_api_entry($request,"Response::\r\n" . $response_jsn); //TASK #4666 Api_log_task
            return response()->json($response_obj, $response_obj->status);
        }
        catch(\Exception $e)
        {
            DB::rollBack();
            return  $this->failure('Failed', 500, $e);
        }
    }
    /*TASK #4666 Api_log_task */
    public function log_this_api_entry(Request $request,$post_data)
    {
        /*
         * location of review api log file root->logs->review_api_log->client_code->monthDate folder->date wise log file
         * example:-base_URL/logs/review_api_log/iet/Mar2019/29032019.log
         */
        $client_code = $this->current_client->clnt_client_code;
        $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
        $file_name = date("dmY", time()) . ".log";
		// $csv_file=$file_storage_path .'uploads/logs/review_api_log/'.$file_name;
		if (!file_exists($file_storage_path .'/logs/review_api_log/'.$client_code.'/'.$file_name))
		{
            $path = 'public/uploads/logs/review_api_log/'.$client_code;
            if (!Storage::exists($path)) 
			{
                $create_dir = Storage::makeDirectory($path);
            }
         }
        $handle = fopen(storage_path().'/app/public/uploads/logs/review_api_log/'.$client_code.'/'.$file_name,'a+');
        if ($handle) {
                $log_data = [
                    'Date and Time' => date("d-m-Y h:i:s a", time()),
                    'Endpoint' => $request->path(),
                    'Source IP' => $request->ip(),
                    'Request_details'=>$request->all(),
                    'Source OS' => $request->header('User-Agent'),
                    'Source Web Browser' => $request->header('User-Agent'), 
                ];
            if ($request->has('access_token')) {
                $log_data['Access_token'] = $request->access_token;
            }
            if(isset($post_data)&&!empty($post_data)){
                fwrite($handle, $post_data . "\r\n\r\n".json_encode($log_data, JSON_PRETTY_PRINT) . "\r\n" );
                fclose($handle);
            }
        }
}
/*End TASK #4666 Api_log_task */
    public function authenticate_api_key($api_key = NULL,$post_data = NULL)
    {
        $check_api_client = new \stdClass();
        if($api_key != NULL)
        {
            $api_client = new \App\Models\API_client();
            $check_api_client = $api_client->get_single_record_with_bind_cond('acl_id,acl_expiry_date,acl_url,acl_status', array('acl_api_key' => $api_key));
            if($check_api_client == NULL)
            {
                $check_api_client          = new \stdClass();
                $check_api_client->status  = FALSE;
                $check_api_client->message = 'wrong api key';
                return $check_api_client;
            }
            elseif($check_api_client != NULL && $check_api_client->acl_status == 'd')
            {
                //check the api client is active or not
                $check_api_client->status = FALSE;
                $check_api_client->message = 'unauthorized api client';
                return $check_api_client;
            }
            else
            {
                $auth_url = $this->authenticate_this_url($check_api_client,$post_data);
                if($auth_url == FALSE)
                {
                    //checks whether the api call is from an authorised url[server]
                    $check_api_client->status   = FALSE;
                    $check_api_client->message  = 'Wrong site url';
                    if(!isset($post_data['site_url']))
                        $check_api_client->message = 'Site url required';
                    return $check_api_client;
                }
                else
                {
                    //api_key for an api client is valid upto the date of expiration
                    $expiration_date = strtotime($check_api_client->acl_expiry_date);
                    $current_date    = strtotime(date('Y-m-d'));
                    if ($expiration_date > $current_date)
                    {
                        $check_api_client->status  = TRUE;
                        $check_api_client->message = 'success';
                        return $check_api_client;
                    }
                    else
                    {
                        $check_api_client->status  = FALSE;
                        $check_api_client->message = 'api expired';
                        return $check_api_client;
                    }
                }
            }
        }
        else
        {
            $check_api_client->status = FALSE;
            $check_api_client->message = 'api key required';
            return $check_api_client;
        }
    }

    public function authenticate_this_url($api_client_details = NULL,$post_data = NULL)
    {
        //checks whether the api call is from an authorised url[server]
        if($api_client_details != NULL && $post_data !== NULL && isset($post_data['site_url']))
        {
            $post_url       = $post_data['site_url'];
            $api_client_url = $api_client_details->acl_url;
            if($api_client_url == $post_url)
            {
                return TRUE;
            }
            else
            {
                return FALSE;
            }
        }
        return FALSE;
    }

    public function get_review_response(Request $request)
    {
        try
        { 
            $post_data = $request->all();
            $access_token = $request->access_token ? $request->access_token : '';
            $return_only_page_extent = $request->return_only_page_extent ? $request->return_only_page_extent : '';
            $api_type = $request->api_type ? $request->api_type : '';
            $response_data = NULL;
            //api configarations
            $expires_in  = Config::get('review_apis.expire_time');
            $config_api_types =  Config::get('review_apis.api_names');
            $config_subs_types = Config::get('review_apis.subscription_type');
            if(!empty($access_token))
            {
                //checking the access token
                $check_access_token = $this->authenticate_access_token($access_token, $expires_in,$post_data);
                if ($check_access_token->status != FALSE)
                {
                    $api_client_details = array(
                        'sub_type' => $check_access_token->acl_subr_type,
                        'api_name' => $check_access_token->acl_api_name,
                        'journals' => $check_access_token->acl_journal,
                        'api_client_id' => $check_access_token->act_acl_id,
                        'token_id' => $check_access_token->act_id,
                    );
                    /*
                    * generic functions and parameters..
                    * which is configured in the review_apis configuraton file
                    * api_types is determined on the basis of api-client's api name
                    */
                    $client_api_type = $api_client_details['api_name'];
                    $client_subs_types = $config_subs_types[$api_client_details['sub_type']]['value'];
                    $parameters = $config_api_types[$client_api_type]['parameters'];
                    $call_to_function = $config_api_types[$client_api_type]['call_to_function'];
                    $redirect_function = $config_api_types[$client_api_type][$client_subs_types];
                    $data_to_display   = $config_api_types[$client_api_type]['data_to_display'];
                    $response_data = $this->$call_to_function($parameters, $api_client_details, $redirect_function,$data_to_display,$return_only_page_extent,$api_type,$request);
                }
                else
                {
                    $response_data = [
                        'status' => 401,
                        'status_message' => FALSE,
                        'message' => $check_access_token->message
                    ];

                    if($response_data['message'] == 'Site url required')
                        $response_data['status'] = 400;
                }
            }
            else
            {
                $response_data = [
                    'status' => 400,
                    'status_message' => FALSE,
                    'message' => 'access token needed'
                ];
            }
            $response_obj = (object) $response_data;
            $response_jsn = json_encode($response_obj);
            $this->log_this_api_entry($request,"Response::\r\n" . $response_jsn); /*Api_log_task */
            return response()->json($response_obj, $response_obj->status);
        }
        catch(\Exception $e)
        {
            $response_jsn  = (object) [
                'status' => 500,
                'status_message' => FALSE,
                'message' => 'Something went wrong'
            ];
            return response()->json($response_jsn, $response_jsn->status);
        }
    }

    public function authenticate_access_token($access_token,$expires_in = NULL,$post_data = NULL)
    {
        if($access_token != NULL)
        {
            /*
             * authenticate the access token by-
             * checks whether the access token is present in the DB under a authenticated user.
             * checks whether the access token is previously deleted.(access token is deleted after a suuccessful api call)
             * checks whether the access token exceeds its expiration period.
             * checks whether the access token is being called form authenticated server.
             */
            $api_client_tbl = new \App\Models\Api_client_tokens();
            $api_client = new \App\Models\API_client();

            $tables = array(
                'main_table' => $api_client_tbl->getTable(),
                'join_table' => array(
                    $api_client->getTable() => array($api_client_tbl->getTable(). '.act_acl_id', $api_client->getTable() . '.acl_id')
            ));
            
            $select = 'act_id,act_acl_id,act_posted_date,acl_url,acl_subr_type,acl_api_name,acl_journal,act_status';
            $criteria =  array('act_access_token' => $access_token, 'acl_status' => 'a');
            $access_token_detail = $api_client_tbl::get_results_using_joins($tables,$select,$criteria,'single');
            if(empty($access_token_detail))
            {
                //token was not found on the db
                $access_token_detail = new \stdClass();
                $access_token_detail->status    = FALSE;
                $access_token_detail->message   = 'Invalid token';
                return $access_token_detail;
            }
            else if($access_token_detail != NULL && $access_token_detail->act_status == 'd')
            {
                //token has been used once
                $access_token_detail->status    = FALSE;
                $access_token_detail->message   = 'expired token';
                return $access_token_detail;
            }
            else
            {
                //checks whether the api call is from an authorised url[server]
                $auth_post_url    = $this->authenticate_this_url($access_token_detail,$post_data);
                if($auth_post_url == FALSE)
                {
                    $access_token_detail->status  = FALSE;
                    $access_token_detail->message = 'unauthorised server';
                    if(!isset($post_data['site_url']))
                        $access_token_detail->message = 'Site url required';
                    return $access_token_detail;
                }
                else
                {
                    //token expired.
                    $created_time         = strtotime($access_token_detail->act_posted_date);
                    $check_expire_time    = $this->check_access_token_expire_time($created_time, $expires_in);
                    if($check_expire_time == FALSE)
                    {
                        $access_token_detail->status  = FALSE;
                        $access_token_detail->message = 'expired token';
                        return $access_token_detail;
                    }
                    else
                    {
                        //success
                        $access_token_detail->status  = TRUE;
                        $access_token_detail->message = 'success';
                        return $access_token_detail;
                    }
                }
            }
        }
        return FALSE;
    }

    public function check_access_token_expire_time($created_time, $expires_in)
    {
        /*
         * $created time is the time of access token creation
         * $expires_in is the expiration period, which is configured in review_api confi file.
         */
        if(!empty($created_time) && !empty($expires_in))
        {
            if (time() - $created_time < $expires_in * 60)
            {
                return TRUE;
            }
            return FALSE;
        }
        return FALSE;
    }

    public function get_reports_for_pcori($parameters, $api_client_details, $redirect_function,$data_to_display,$return_only_page_extent,$api_type)
    {
        try
        {
            if($api_type !== '')
            {
                $Users = new \App\Models\User();
                $article_tbl = (new \App\Models\Articles())->getTable();
                $Article_types = (new \App\Models\Article_types())->getTable();
                $Journals = (new \App\Models\Journals());
                $article_flow_tbl = (new \App\Models\Article_flow())->getTable();
                $users_tbl = (new \App\Models\User())->getTable();
                $workflow_tbl = (new \App\Models\Generic_flows())->getTable();
                $roles_tbl = (new \App\Models\Roles())->getTable();
                $art_flags_tbl = (new \App\Models\Article_flag())->getTable();
                $flag_tbl = (new \App\Models\Flags())->getTable();
                $author_tbl = (new \App\Models\Authors())->getTable();
                $aff_tbl = (new \App\Models\Authors_affiliation())->getTable();
                $country_tbl = (new \App\Models\Country())->getTable();
                $user_affiliaion_tbl = (new \App\Models\User_affiliations())->getTable();
                $client_settings = new \App\Models\Client_settings();
                $client_date_format = $client_settings->where('cs_id',1)->get();
                //$date_format = static::date_format_map('m-d-Y');
                $date_format = static::date_format_map($client_date_format[0]->cs_date_format);
                if($api_type == 'pcori_report')
                {
                    try
                    {
                        $result = $Users::get_records_by_raw_query('SELECT 
                        art1.art_code AS article_id,
                        (
                        SELECT
                            gdata_display_data
                        FROM
                            rvw_article_gnf_form_data_pcori
                        WHERE
                            gdata_unique_identifier = \'PCORI_PROJECT_ID\' AND gdata_art_id = art1.art_id
                        GROUP BY
                            gdata_art_id
                    ) AS pcori_award_number,
                    art_type.artp_article_type AS article_type,
                    strip_tags(art1.art_title) AS article_title,
                    (
                        SELECT
                            GROUP_CONCAT(flag_name)
                        FROM
                            '.$art_flags_tbl.'
                        INNER JOIN '.$flag_tbl.' ON aflg_flag_id = flag_id
                        WHERE
                            aflg_art_id = art1.art_id
                    ) AS article_flags,
                    CASE WHEN artflw.aflw_status = \'a\' THEN \'In progress\' WHEN artflw.aflw_status = \'d\' AND artflw.aflw_remarks != \'timeout\' THEN \'Declined\' WHEN artflw.aflw_status = \'d\' AND artflw.aflw_remarks = \'timeout\' THEN \'Auto declined\' WHEN artflw.aflw_status = \'i\' THEN \'Invited\' WHEN artflw.aflw_status = \'c\' THEN \'Completed\' WHEN artflw.aflw_status = \'g\' THEN \'Unassigned\' WHEN (artflw.aflw_parent_flow_id IS NULL AND artflw.aflw_status = \'u\' AND jwf_stage_type != \'review\') THEN 
                    \'Ready\' WHEN(
                        artflw.aflw_status = \'w\' AND(
                        SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                    ) < artflw.aflw_stage_min_users
                    ) THEN \'Shortlisting in progress\' WHEN(
                        artflw.aflw_status = \'w\' AND(
                            (
                            SELECT
                                COUNT(inner_flow.aflw_id) AS flw_cnt
                            FROM
                                '.$article_flow_tbl.' AS inner_flow
                            WHERE
                                inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                        ) >= artflw.aflw_stage_min_users
                        ) AND(
                        SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'i\', \'c\')
                    ) < artflw.aflw_stage_min_users
                    ) THEN \'Invitation in progress\' WHEN(
                        artflw.aflw_status = \'w\' AND(
                        SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'i\', \'c\')
                    ) >= artflw.aflw_stage_min_users
                    ) THEN \'Invitation completed\'
                    WHEN(
                        artflw.aflw_status = \'p\'
                    ) THEN (
                        IF((SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'u\', \'a\', \'c\')
                    ) < artflw.aflw_stage_min_users,\'Awaiting assignment\',\'Assignment completed\'))
                    WHEN (artflw.aflw_status = \'u\'AND jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL) 
                    THEN(
                        IF((SELECT count(aflwtbk.tbk_id)
                        FROM tbk_article_flow AS aflwtbk WHERE artflw.aflw_id = aflwtbk.aflw_id AND aflwtbk.aflw_status = \'i\') > 0,\'Un-invited\',\'Shortlisted\'))
                    ELSE artflw.aflw_status
                    END AS current_status,
                    DATE_FORMAT(
                        IF(
                            art1.art_pre_all_ids IS NOT NULL,
                            (
                            SELECT
                                art2.art_submission_date
                            FROM
                                '.$article_tbl.' AS art2
                            WHERE
                                art2.art_id = CAST(
                                    TRIM(
                                        SUBSTRING_INDEX(art1.art_pre_all_ids, \',\', 1)
                                    ) AS SIGNED
                                )
                        ),
                        art1.art_submission_date
                        ),
                        "' . $date_format . '"
                    ) AS original_submission_date,
                    DATE_FORMAT(art_submission_date,"' . $date_format . '") AS submission_date,
                    CASE WHEN usr1.usr_title = \'pr\' THEN \'Professor\' WHEN usr1.usr_title = \'dr\' THEN \'Dr\' WHEN usr1.usr_title = \'mr\' THEN \'Mr\' WHEN usr1.usr_title = \'mrs\' THEN \'Mrs\' WHEN usr1.usr_title = \'mis\' THEN \'Miss\' WHEN usr1.usr_title = \'mx\' THEN \'Mx\' WHEN usr1.usr_title = \'ind\' THEN \'Ind\' WHEN usr1.usr_title = \'misc\' THEN \'Misc\' WHEN usr1.usr_title = \'msr\' THEN \'Msr\' WHEN usr1.usr_title = \'prn\' THEN \'Prn\' WHEN usr1.usr_title = \'rev\' THEN \'Rev\' ELSE \'\'
                    END AS user_title,
                    usr1.usr_first_name AS user_first_name,
                    usr1.usr_last_name AS user_last_name,
 (SELECT
 GROUP_CONCAT(flag_name)
FROM
 rvw_user_global_flags
INNER JOIN rvw_flags ON ugf_flag_id = flag_id
WHERE
 ugf_user_id = usr1.usr_id) as user_global_flags,
   (SELECT
        GROUP_CONCAT(flag_name)
    FROM
        rvw_user_flags
    INNER JOIN rvw_flags ON uf_flag_id = flag_id
    INNER JOIN rvw_article_types ON artp_id = art1.art_artp_id
    INNER JOIN rvw_journals as inner_jnl ON artp_jnl_id = jnl_id
    WHERE
        uf_usr_id = usr1.usr_id AND uf_jnl_id = inner_jnl.jnl_id) as user_journal_flags,
                    CONCAT(\'RV_USER_\', usr1.usr_id) AS user_id_number,
                    CASE WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_1.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_1
                        WHERE
                            user_aff_1.usaff_user_id = usr1.usr_id AND user_aff_1.usaff_prime_affiliation = \'y\'
                    ) > 0
                    ) THEN(
                        SELECT
                            user_country_1.cnt_country
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_2
                        INNER JOIN '.$country_tbl.' AS user_country_1
                        ON
                            cnt_id = user_aff_2.usaff_cnt_id
                        WHERE
                            user_aff_2.usaff_user_id = usr1.usr_id AND user_aff_2.usaff_prime_affiliation = \'y\' LIMIT 1
                    ) WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_2.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_2
                        WHERE
                            user_aff_2.usaff_user_id = usr1.usr_id AND user_aff_2.usaff_prime_affiliation = \'y\'
                    ) = 0
                    ) THEN(
                        IF(
                            (
                            SELECT
                                COUNT(auth_aff_2.auaff_id)
                            FROM
                                '.$aff_tbl.' AS auth_aff_2
                            INNER JOIN '.$author_tbl.' AS auth_table
                            ON
                                auth_table.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_2.auaff_prime_affiliation = \'y\'
                        ) > 0,
                        (
                        SELECT
                            country_tbl.cnt_country
                        FROM
                            '.$aff_tbl.' AS aff_table_1
                        INNER JOIN '.$author_tbl.' AS auth_table_1
                        ON
                            auth_table_1.auth_id = aff_table_1.auaff_auth_id
                        INNER JOIN '.$country_tbl.' AS country_tbl
                        ON
                            cnt_id = aff_table_1.auaff_cnt_id
                        WHERE
                            aff_table_1.auaff_prime_affiliation = \'y\' AND auth_table_1.auth_usr_id = usr1.usr_id
                        ORDER BY
                            aff_table_1.auaff_id
                        DESC
                    LIMIT 1
                    ),
                    NULL
                        )
                    ) ELSE NULL
                    END AS user_country, CASE WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_5.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_5
                        WHERE
                            user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                    ) > 0
                    ) THEN(
                        SELECT
                            user_aff_6.usaff_address_line2
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_6
                        WHERE
                            user_aff_6.usaff_user_id = usr1.usr_id AND user_aff_6.usaff_prime_affiliation = \'y\' LIMIT 1
                    )
                    WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_5.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_5
                        WHERE
                            user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                    ) = 0
                    ) 
                    THEN(
                    IF(
                        (
                            SELECT
                                COUNT(auth_aff_7.auaff_id)
                            FROM
                                '.$aff_tbl.' AS auth_aff_7
                            INNER JOIN '.$author_tbl.' AS auth_table_7
                            ON
                                auth_table_7.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_7.auaff_prime_affiliation = \'y\'
                        ) > 0,(SELECT
                                auth_aff_8.auaff_address_line2
                            FROM
                                '.$aff_tbl.' AS auth_aff_8
                            INNER JOIN '.$author_tbl.' AS auth_table_8
                            ON
                                auth_table_8.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_8.auaff_prime_affiliation = \'y\' ORDER by auth_table_8.auth_id DESC LIMIT 1), NULL   
                    )
                        )
                    ELSE NULL
                    END AS user_state_or_region,
                    CASE WHEN(
                        artflw.aflw_status = \'w\' AND(
                        SELECT
                            COUNT(inner_flow_1.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow_1
                        WHERE
                            inner_flow_1.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_1.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                    ) < artflw.aflw_stage_min_users
                    ) THEN(
                        SELECT
                            GROUP_CONCAT(inner_roles.role_name)
                        FROM
                            '.$roles_tbl.' AS inner_roles
                        WHERE
                            FIND_IN_SET(
                                inner_roles.role_id,
                            REPLACE
                                (
                                REPLACE
                                    (
                                    REPLACE
                                        (
                                            (
                                            SELECT
                                                inner_jnl_flow.jwf_parent_user_roles
                                            FROM
                                                '.$workflow_tbl.' AS inner_jnl_flow
                                            WHERE
                                                inner_jnl_flow.jwf_id = artflw.aflw_jwf_id
                                        ),
                                        \'"\',
                                        ""
                                        ),
                                        "]",
                                        ""
                                ),
                                "[",
                                ""
                            )
                            )
                    ) WHEN(
                        (
                            artflw.aflw_status = \'w\' AND(
                                (
                                SELECT
                                    COUNT(inner_flow_2.aflw_id) AS flw_cnt
                                FROM
                                    '.$article_flow_tbl.' AS inner_flow_2
                                WHERE
                                    inner_flow_2.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_2.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                            ) >= artflw.aflw_stage_min_users
                            ) AND(
                            SELECT
                                COUNT(inner_flow_3.aflw_id) AS flw_cnt
                            FROM
                                '.$article_flow_tbl.' AS inner_flow_3
                            WHERE
                                inner_flow_3.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_3.aflw_status IN(\'i\', \'c\')
                        ) < artflw.aflw_stage_min_users
                        ) OR(
                            artflw.aflw_status = \'w\' AND(
                            SELECT
                                COUNT(inner_flow_4.aflw_id) AS flw_cnt
                            FROM
                                '.$article_flow_tbl.' AS inner_flow_4
                            WHERE
                                inner_flow_4.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_4.aflw_status IN(\'i\', \'c\')
                        ) >= artflw.aflw_stage_min_users
                        )
                    ) THEN(
                        SELECT
                            GROUP_CONCAT(inner_roles.role_name)
                        FROM
                            '.$roles_tbl.' AS inner_roles
                        WHERE
                            FIND_IN_SET(
                                inner_roles.role_id,
                            REPLACE
                                (
                                REPLACE
                                    (
                                    REPLACE
                                        (
                                            (
                                            SELECT
                                                inner_jnl_flow_1.jwf_who_can_invite
                                            FROM
                                                '.$workflow_tbl.' AS inner_jnl_flow_1
                                            WHERE
                                                inner_jnl_flow_1.jwf_id = artflw.aflw_jwf_id
                                        ),
                                        \'"\',
                                        ""
                                        ),
                                        "]",
                                        ""
                                ),
                                "[",
                                ""
                            )
                            )
                    )
                    WHEN
                        artflw.aflw_status = \'p\' 
                     THEN(
                        SELECT
                            GROUP_CONCAT(inner_roles.role_name)
                        FROM
                            '.$roles_tbl.' AS inner_roles
                        WHERE
                            FIND_IN_SET(
                                inner_roles.role_id,
                            REPLACE
                                (
                                REPLACE
                                    (
                                    REPLACE
                                        (
                                            (
                                            SELECT
                                                inner_jnl_flow.jwf_parent_user_roles
                                            FROM
                                                '.$workflow_tbl.' AS inner_jnl_flow
                                            WHERE
                                                inner_jnl_flow.jwf_id = artflw.aflw_jwf_id
                                        ),
                                        \'"\',
                                        ""
                                        ),
                                        "]",
                                        ""
                                ),
                                "[",
                                ""
                            )
                            )
                    )
                    ELSE role_name
                    END AS role_name,
                    jwf_stage_name,
                    IF(
                        jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL,
                        (
                        SELECT
                            DATE_FORMAT(
                                aflwtbk.aflw_posted_date,
                                "' . $date_format . '"
                            )
                        FROM
                            tbk_article_flow AS aflwtbk
                        WHERE
                            artflw.aflw_id = aflwtbk.aflw_id AND aflwtbk.aflw_status = \'i\'
                        ORDER BY
                            tbk_id 
                        LIMIT 1
                    ),
                    NULL
                    ) AS invited_date,
                    DATE_FORMAT(
                        artflw.aflw_accepted_date,
                        "' . $date_format . '"
                    ) AS task_accepted_date,
                    DATE_FORMAT(
                        IF(
                            jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL AND artflw.aflw_status = \'d\',
                            artflw.aflw_returned_date,
                            \'NA\'
                        ),
                        "' . $date_format . '"
                    ) AS task_rejected_date,
                    DATE_FORMAT(
                        artflw.aflw_returned_date,
                        "' . $date_format . '"
                    ) AS task_completed_date,
                    CASE WHEN(artflw.aflw_status = \'g\' AND jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL) THEN (
                        SELECT
                                DATE_FORMAT(
                                        aflwtbk1.aflw_posted_date,
                                        "' . $date_format . '"
                                        )
                                FROM
                                    tbk_article_flow AS aflwtbk1
                                WHERE
                                    artflw.aflw_id = aflwtbk1.aflw_id AND aflwtbk1.aflw_status = \'g\'
                                ORDER BY
                                    tbk_id DESC
                                LIMIT 1 
                        ) WHEN (artflw.aflw_status = \'u\' AND jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL AND (SELECT count(aflwtbk.tbk_id)
                        FROM
                            tbk_article_flow AS aflwtbk
                        WHERE
                            artflw.aflw_id = aflwtbk.aflw_id AND aflwtbk.aflw_status = \'i\') > 0) 
                            THEN (
                                SELECT
                                                DATE_FORMAT(
                                                        aflwtbk1.aflw_posted_date,
                                                        "' . $date_format . '"
                                                        )
                                                FROM
                                                    tbk_article_flow AS aflwtbk1
                                                WHERE
                                                    artflw.aflw_id = aflwtbk1.aflw_id AND aflwtbk1.aflw_status = \'u\'
                                                ORDER BY
                                                    tbk_id DESC
                                                LIMIT 1 ) ELSE NULL END AS uninvited_unassigned_date,
                    (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori WHERE gdata_art_id = art1.art_id AND gdata_unique_identifier = \'PCORI_PI_LAST_NAME\' GROUP BY
                    gdata_art_id) as pi_last_name,
                    CONCAT_WS(
                        " ",
                        usr2.usr_first_name,
                        usr2.usr_middle_name,
                        usr2.usr_last_name
                    ) AS submitting_author,
                    (
                        SELECT
                            GROUP_CONCAT(
                                CONCAT_WS(
                                    " ",
                                    inner_user.usr_first_name,
                                    inner_user.usr_middle_name,
                                    inner_user.usr_last_name
                                )
                            )
                        FROM
                            '.$author_tbl.' AS inner_author
                        INNER JOIN '.$users_tbl.' AS inner_user
                        ON
                            inner_author.auth_usr_id = inner_user.usr_id
                        WHERE
                            inner_author.auth_corr_author = \'y\' AND inner_author.auth_art_id = art1.art_id
                    ) AS corresponding_author,
                    (
                        SELECT
                            GROUP_CONCAT(
                                CONCAT_WS(
                                    " ",
                                    inner_user.usr_first_name,
                                    inner_user.usr_middle_name,
                                    inner_user.usr_last_name
                                )
                            )
                        FROM
                            `'.$author_tbl.'` AS inner_author
                        INNER JOIN '.$users_tbl.' AS inner_user
                        ON
                            inner_author.auth_usr_id = inner_user.usr_id
                        WHERE
                            inner_author.auth_corr_author != \'y\' AND inner_author.auth_art_id = art1.art_id
                    ) AS co_authors,
                    DATE_FORMAT(
                        IF(
                            art1.art_pre_all_ids IS NOT NULL,
                            (
                            SELECT
                                art3.art_decision_date
                            FROM
                                '.$article_tbl.' AS art3
                            WHERE
                                art3.art_id = CAST(
                                    TRIM(
                                        SUBSTRING_INDEX(art1.art_pre_all_ids, \',\', 1)
                                    ) AS SIGNED
                                )
                        ),
                        art1.art_decision_date
                        ),
                        "' . $date_format . '"
                    ) AS date_of_first_decision,
                    DATE_FORMAT(
                        art1.art_final_decision_date,
                        "' . $date_format . '"
                    ) AS date_of_final_decision,
                    (
                        CASE WHEN art1.art_status = \'a\' THEN \'Accepted\' WHEN art1.art_status = \'r\' THEN \'Rejected\' WHEN art1.art_status = \'y\' THEN \'Peer review in progress\' WHEN art1.art_status = \'c\' THEN \'Revised\' ELSE \'Not submitted\'
                    END
                    ) AS decision
                    FROM
                        '.$article_tbl.' AS art1
                    INNER JOIN `'.$Article_types.'` AS art_type
                    ON
                        art1.art_artp_id = art_type.artp_id
                    INNER JOIN '.$article_flow_tbl.' AS artflw
                    ON
                        art1.art_id = artflw.aflw_art_id
                    LEFT JOIN '.$users_tbl.' AS `usr1`
                    ON
                        artflw.aflw_usr_id = usr1.usr_id
                    INNER JOIN '.$workflow_tbl.' ON artflw.aflw_jwf_id = jwf_id
                    INNER JOIN `'.$roles_tbl.'` ON jwf_role_id = role_id
                    INNER JOIN '.$users_tbl.' AS `usr2`
                    ON
                        art1.art_submitted_by = usr2.usr_id
                    INNER JOIN `'.$author_tbl.'` ON art1.art_id = auth_art_id
                    INNER JOIN '.$users_tbl.' AS `usr3`
                    ON
                        auth_usr_id = usr3.usr_id
                    WHERE
                        art1.art_status != \'n\' AND art1.art_delete_status = \'n\'
                    GROUP BY
                        artflw.aflw_id
                    ORDER BY
                        art_id,
                        artflw.aflw_id'); 
                        $response_data = [
                            'status' => 200,
                            'status_message' => TRUE,
                            'data' => $result,
                            'message' => 'success' 
                        ];
                        return $response_data;
                    }
                    catch (\Exception $e) {
                        $response_data = [
                            'status' => 500,
                            'status_message' => FALSE,
                            'message' => ''
                        ];
                        return $response_data;
                    }

                }
                else if($api_type == 'reviewer_coi')
                {
                    $result = $Users::get_records_by_raw_query('SELECT art1.art_code as article_id,CASE WHEN usr1.usr_title = \'pr\' THEN \'Professor\' WHEN usr1.usr_title = \'dr\' THEN \'Dr\' WHEN usr1.usr_title = \'mr\' THEN \'Mr\' WHEN usr1.usr_title = \'mrs\' THEN \'Mrs\' WHEN usr1.usr_title = \'mis\' THEN \'Miss\' WHEN usr1.usr_title = \'mx\' THEN \'Mx\' WHEN usr1.usr_title = \'ind\' THEN \'Ind\' WHEN usr1.usr_title = \'misc\' THEN \'Misc\' WHEN usr1.usr_title = \'msr\' THEN \'Msr\' WHEN usr1.usr_title = \'prn\' THEN \'Prn\' WHEN usr1.usr_title = \'rev\' THEN \'Rev\' ELSE \'\' END AS user_title,usr1.usr_first_name as user_first_name, usr1.usr_last_name as user_last_name,usr1.usr_email as user_email, CONCAT(\'RV_USER_\',usr1.usr_id) AS person_id,role_name as role, jwf_stage_name as task, DATE_FORMAT(artflw.aflw_accepted_date,"' . $date_format . '") as task_accepted_date,DATE_FORMAT(artflw.aflw_returned_date,"' . $date_format . '") as task_completed_date,DATE_FORMAT(aflw_returned_date,"' . $date_format . '") as disclosure_date, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COI_EMPLOYER\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as reviewer_employer,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'EMPLOYER_RELATIONSHIP\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'EMPLOYER_APPLIES_TO\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'EMPLOYED_STOCK_COMPENSATION\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as finance_buisiness_compensation, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_1, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_1, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_1, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_2, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_2, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_2, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_3, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_3, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_3, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_4, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_4, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_4, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_5, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_5, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_5,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PER_ASS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_associations,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_1,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_1_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_1,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_1_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_1,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_2,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_2_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_2,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_2_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_2,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_3,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_3_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_3,
                    (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_3_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_3,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_4,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_4_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_4,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_4_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_4,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_5,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_5_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_5,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_5_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_5 FROM '.$article_tbl.' AS art1 INNER JOIN `'.$article_flow_tbl.'` AS artflw ON art1.art_id = artflw.aflw_art_id INNER JOIN `'.$users_tbl.'` AS `usr1` ON artflw.aflw_usr_id = usr1.usr_id INNER JOIN `'.$workflow_tbl.'` ON artflw.aflw_jwf_id = jwf_id INNER JOIN `'.$roles_tbl.'` ON jwf_role_id = role_id INNER JOIN rvw_article_gnf_form_data_pcori ON gdata_art_id = art1.art_id WHERE art1.art_status != \'n\' AND jwf_stage_type = \'review\' AND artflw.aflw_status = \'c\' AND gdata_unique_identifier IN(\'COI_EMPLOYER\',\'EMPLOYER_RELATIONSHIP\',\'EMPLOYER_APPLIES_TO\',\'EMPLOYED_STOCK_COMPENSATION\',\'COMPANY_ORGANIZATION_NAME_1\',\'NATURE_OF_RELATIONSHIP_1\',\'APPLIES_TO_1\',\'COMPANY_ORGANIZATION_NAME_2\',\'NATURE_OF_RELATIONSHIP_2\',\'APPLIES_TO_2\',\'COMPANY_ORGANIZATION_NAME_3\',\'NATURE_OF_RELATIONSHIP_3\',\'APPLIES_TO_3\',\'COMPANY_ORGANIZATION_NAME_4\',\'NATURE_OF_RELATIONSHIP_4\',\'APPLIES_TO_4\',\'COMPANY_ORGANIZATION_NAME_5\',\'NATURE_OF_RELATIONSHIP_5\',\'APPLIES_TO_5\',\'PER_ASS\',\'PERSONAL_ASSOCIATION_COMPANY_1\',\'RELATIONSHIP_1_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_1_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_2\',\'RELATIONSHIP_2_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_2_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_3\',\'RELATIONSHIP_3_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_3_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_4\',\'RELATIONSHIP_4_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_4_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_5\',\'RELATIONSHIP_5_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_5_PERSONAL_ASSOCIATIONS\') GROUP BY artflw.aflw_id ORDER BY art_id,artflw.aflw_id');
                    $response_data = [
                        'status' => 200,
                        'status_message' => TRUE,
                        'data' => $result,
                        'message' => 'success' 
                    ];
                    return $response_data;
                }
                else
                {
                    $response_data = [
                        'status' => 404,
                        'status_message' => FALSE,
                        'message' => 'invalid api type'
                    ];
                    return $response_data;
                }
        }
        else
        {
            $response_data = [
                'status' => 400,
                'status_message' => FALSE,
                'message' => 'API type needed'
            ];
            return $response_data;
        }
    }
    catch (\Exception $e) {
        $response_data = [
            'status' => 500,
            'status_message' => FALSE,
            'message' => ''
        ];
        return $response_data;
    }
}
    public function get_reports_for_ice($parameters, $api_client_details, $redirect_function,$data_to_display,$return_only_page_extent,$api_type,$request)
    {
        try
        {
            $config_data =  Config::get('review_apis.api_names');
            $api_name = $api_client_details['api_name'];
            $restricted_mode = $config_data[$api_name]['enable_restricted_mode'];
            if($api_type !== '')
            {
                $Users = new \App\Models\User();
                $article_tbl = (new \App\Models\Articles())->getTable();
                $Article_types = (new \App\Models\Article_types())->getTable();
                $Article_type_tbl = new \App\Models\Article_types();
                $Journals = (new \App\Models\Journals());
                $journal_tbl = (new \App\Models\Journals())->getTable();
                $article_flow_tbl = (new \App\Models\Article_flow())->getTable();
                $users_tbl = (new \App\Models\User())->getTable();
                $workflow_tbl = (new \App\Models\Generic_flows())->getTable();
                $workflow_model = new \App\Models\Generic_flows();
                $roles_tbl = (new \App\Models\Roles())->getTable();
                $art_flags_tbl = (new \App\Models\Article_flag())->getTable();
                $flag_tbl = (new \App\Models\Flags())->getTable();
                $author_tbl = (new \App\Models\Authors())->getTable();
                $aff_tbl = (new \App\Models\Authors_affiliation())->getTable();
                $country_tbl = (new \App\Models\Country())->getTable();
                $user_affiliaion_tbl = (new \App\Models\User_affiliations())->getTable();
                $client_settings = new \App\Models\Client_settings();
                $client_date_format = $client_settings->where('cs_id',1)->get();
                //$date_format = static::date_format_map('m-d-Y');
                $date_format = static::date_format_map($client_date_format[0]->cs_date_format);
                if($restricted_mode == TRUE)
                {
                    $date_format = '%Y-%m-%dT%H:%i:%sZ';
                }
                $journal_condition = 'jnl_journal_status = \'y\'';
                $artp_condition = '';
                $journal_join = '';
                $journal_where_condition = '';
                $date_condition = '';
                if($api_type == 'report')
                {
                    if($restricted_mode == TRUE && !isset($request->jnl_code))
                    {
                        $response_data = [
                            'status' => 400,
                            'status_message' => FALSE,
                            'message' => 'Journal code required'
                        ];
                        return $response_data;
                    }
                    if(!isset($request->last_updated_date))
                    {
                        $response_data = [
                            'status' => 400,
                            'status_message' => FALSE,
                            'message' => 'Last updated date required'
                        ];
                        return $response_data;
                    }
                    if(isset($request->last_updated_date))
                    {
                        $check_format = $this->isMonthYearFormat($request->last_updated_date);
                        if($check_format == FALSE || $check_format == 'days_over')
                        {
                            $response_data = [
                                'status' => 400,
                                'status_message' => FALSE,
                                'message' => 'Incorrect last updated date format'
                            ];
                            if($check_format == 'days_over')
                            {
                                $response_data['message'] = 'Maximum 3 months range is allowed';
                            }
                            return $response_data;
                        }
                        else
                        {
                            if($check_format['type'] == 'day')
                            {
                                $date_condition = 'AND DATE(artflw.aflw_posted_date) ="'.$check_format['day'].'" ';
                            }
                            else if($check_format['type'] == 'month')
                            {
                                $date_condition = 'AND MONTH(artflw.aflw_posted_date) = "'.$check_format['month'].'" AND YEAR(artflw.aflw_posted_date) = "'.$check_format['year'].'" ';
                            }
                            else
                            {
                                $date_condition = 'AND artflw.aflw_posted_date >= "'.$check_format['range_from'].'" AND artflw.aflw_posted_date <= "'.$check_format['range_to'].'" ';
                            }
                        }
                    }
                    // if($restricted_mode == TRUE)
                    // {
                    //     $date_filter_flag = FALSE;
                    //     if(isset($request->date_filter_type))
                    //     {
                    //         $date_filter_flag = TRUE;
                    //     }
                    //     if($date_filter_flag == TRUE && !in_array($request->date_filter_type,['day','range']))
                    //     {
                    //         $response_data = [
                    //             'status' => 400,
                    //             'status_message' => FALSE,
                    //             'message' => 'Invalid Date filter type'
                    //         ];
                    //         return $response_data;
                    //     }

                    //     if($date_filter_flag == TRUE && $request->date_filter_type == 'day' && !isset($request->last_updated_date))
                    //     {
                    //         $response_data = [
                    //             'status' => 400,
                    //             'status_message' => FALSE,
                    //             'message' => 'Last update date required'
                    //         ];
                    //         return $response_data;
                    //     }

                    //     if($date_filter_flag == TRUE && $request->date_filter_type == 'range' && !isset($request->last_updated_date_from))
                    //     {
                    //         $response_data = [
                    //             'status' => 400,
                    //             'status_message' => FALSE,
                    //             'message' => 'Last update date from required'
                    //         ];
                    //         return $response_data;
                    //     }

                    //     if($date_filter_flag == TRUE && $request->date_filter_type == 'range' && !isset($request->last_updated_date_to))
                    //     {
                    //         $response_data = [
                    //             'status' => 400,
                    //             'status_message' => FALSE,
                    //             'message' => 'Last update date to required'
                    //         ];
                    //         return $response_data;
                    //     }

                    //     if($date_filter_flag == TRUE)
                    //     {
                    //         if($request->date_filter_type == 'day')
                    //         {
                    //             $filter_date = $request->last_updated_date;
                    //             if($this->is_date_format($filter_date))
                    //             {
                    //                 $date_condition = 
                    //             }
                    //             else
                    //             {
                    //                 $response_data = [
                    //                     'status' => 400,
                    //                     'status_message' => FALSE,
                    //                     'message' => 'Provided wrong date format'
                    //                 ];
                    //                 return $response_data;
                    //             }
                    //         }
                    //     }

                        
                        
                    // }


                    /*if($restricted_mode == TRUE && !isset($request->article_type_code))
                    {
                        $response_data = [
                            'status' => 400,
                            'status_message' => FALSE,
                            'message' => 'Article type required'
                        ];
                        return $response_data;
                    }

                    if($restricted_mode == TRUE && !isset($request->decision))
                    {
                        $response_data = [
                            'status' => 400,
                            'status_message' => FALSE,
                            'message' => 'Decision type required'
                        ];
                        return $response_data;
                    }*/

                    if($restricted_mode == TRUE)
                    {
                        $journal_condition = $journal_condition.' AND jnl_journal_code = "'.$request->jnl_code.'"';
                    }
                }
                $all_active_journals = $Journals::get_all_records('jnl_journal_code,jnl_id',$journal_condition);
                if(count($all_active_journals) == 0)
                {
                    $response_data = [
                        'status' => 400,
                        'status_message' => FALSE,
                        'message' => 'Invalid journal code'
                    ];
                    return $response_data;
                }
                $artp_condition = '';
                $art_status_condition = '';

                if(isset($request->decision))
                {
                    $art_status_condition = ' AND art1.art_status="'.$request->decision.'"';
                }
                if($restricted_mode == TRUE && isset($request->article_type_code))
                {
                    $article_type_id = $Article_type_tbl::get_single_record_with_bind_cond('artp_id,artp_article_type',array('artp_jnl_id' => $all_active_journals[0]->jnl_id,'artp_abbr_article_type' => $request->article_type_code));
                    if($article_type_id == null)
                    {
                        $response_data = [
                            'status' => 400,
                            'status_message' => FALSE,
                            'message' => 'Article type not belonging to this journal code'
                        ];
                        return $response_data;
                    }
                    $artp_condition = ' AND art1.art_artp_id = "'.$article_type_id->artp_id.'"';
                }
                if($artp_condition == '')
                {
                    $journal_join = ' INNER JOIN rvw_article_types as art_types ON art_types.artp_id = art1.art_artp_id INNER JOIN rvw_journals as jrns ON jrns.jnl_id = art_types.artp_jnl_id';
                    $journal_where_condition = ' AND jrns.jnl_journal_code ="'.$request->jnl_code.'"';
                }
                if($api_type == 'pcori_report' || $api_type == 'report')
                {
                    try
                    {
                        $return_arr = '';
                        $pcori_award_query = '';
                        $pi_name = '';
                        $limit_query = ' LIMIT 200';
                        foreach($all_active_journals as $single_journals)
                        {
                        $journal_abbr = 'rvw_article_gnf_form_data_'.$single_journals->jnl_journal_code;
                        $additional_user_query = '';
                        if($restricted_mode == FALSE)
                        {
                            $pcori_award_query = '(
                                SELECT
                                    gdata_display_data
                                FROM
                                    '.$journal_abbr.'
                                WHERE
                                    gdata_unique_identifier = \'PCORI_PROJECT_ID\' AND gdata_art_id = art1.art_id
                                GROUP BY
                                    gdata_art_id
                                ) AS pcori_award_number,';
                            $pi_name = '(SELECT gdata_display_data FROM '.$journal_abbr.' WHERE gdata_art_id = art1.art_id AND gdata_unique_identifier = \'PCORI_PI_LAST_NAME\' GROUP BY
                            gdata_art_id) as pi_last_name,';
                            $limit_query = '';
                        }
                        else
                        {
                            $additional_user_query = ' usr1.usr_email as email,IF(usr1.usr_orcid_id = null,null,CONCAT("https://orcid.org/",usr1.usr_orcid_id)) as orcid,';
                        }

                        $result = $Users::get_records_by_raw_query('SELECT 
                        art1.art_id AS art_id,art1.art_code AS article_id,'.$pcori_award_query.'
                    strip_tags(art1.art_title) AS article_title,art_types.artp_article_type as article_type,
                    (
                        SELECT
                            GROUP_CONCAT(flag_name)
                        FROM
                            '.$art_flags_tbl.'
                        INNER JOIN '.$flag_tbl.' ON aflg_flag_id = flag_id
                        WHERE
                            aflg_art_id = art1.art_id
                    ) AS article_flags,
                    CASE WHEN artflw.aflw_status = \'a\' THEN \'In progress\' WHEN artflw.aflw_status = \'d\' AND artflw.aflw_remarks != \'timeout\' THEN \'Declined\' WHEN artflw.aflw_status = \'d\' AND artflw.aflw_remarks = \'timeout\' THEN \'Auto declined\' WHEN artflw.aflw_status = \'i\' THEN \'Invited\'  WHEN (artflw.aflw_status = \'c\' AND artflw.aflw_parent_flow_id IS NULL AND jwf_stage_type =\'review\') THEN \'Reviewer shortlist/invite completed\' WHEN artflw.aflw_status = \'c\' THEN \'Completed\' WHEN artflw.aflw_status = \'g\' THEN \'Unassigned\' WHEN (artflw.aflw_parent_flow_id IS NULL AND artflw.aflw_status = \'u\' AND jwf_stage_type != \'review\') THEN 
                    \'Ready\' WHEN(
                        artflw.aflw_status = \'w\' AND(
                        SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                    ) < artflw.aflw_stage_min_users
                    ) THEN \'Shortlisting in progress\' WHEN(
                        artflw.aflw_status = \'w\' AND(
                            (
                            SELECT
                                COUNT(inner_flow.aflw_id) AS flw_cnt
                            FROM
                                '.$article_flow_tbl.' AS inner_flow
                            WHERE
                                inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                        ) >= artflw.aflw_stage_min_users
                        ) AND(
                        SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'i\', \'c\')
                    ) < artflw.aflw_stage_min_users
                    ) THEN \'Invitation in progress\' WHEN(
                        artflw.aflw_status = \'w\' AND(
                        SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'i\', \'c\')
                    ) >= artflw.aflw_stage_min_users
                    ) THEN \'Invitation completed\'
                    WHEN(
                        artflw.aflw_status = \'p\'
                    ) THEN (
                        IF((SELECT
                            COUNT(inner_flow.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow
                        WHERE
                            inner_flow.aflw_parent_flow_id = artflw.aflw_id AND inner_flow.aflw_status IN(\'u\', \'a\', \'c\')
                    ) < artflw.aflw_stage_min_users,\'Awaiting assignment\',\'Assignment completed\'))
                    WHEN (artflw.aflw_status = \'u\'AND jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL) 
                    THEN(
                        IF((SELECT count(aflwtbk.tbk_id)
                        FROM tbk_article_flow AS aflwtbk WHERE artflw.aflw_id = aflwtbk.aflw_id AND aflwtbk.aflw_status = \'i\') > 0,\'Un-invited\',\'Shortlisted\'))
                    ELSE artflw.aflw_status
                    END AS current_status,
                    DATE_FORMAT(
                        IF(
                            art1.art_pre_all_ids IS NOT NULL,
                            (
                            SELECT
                                art2.art_submission_date
                            FROM
                                '.$article_tbl.' AS art2
                            WHERE
                                art2.art_id = CAST(
                                    TRIM(
                                        SUBSTRING_INDEX(art1.art_pre_all_ids, \',\', 1)
                                    ) AS SIGNED
                                )
                        ),
                        art1.art_submission_date
                        ),
                        "' . $date_format . '"
                    ) AS original_submission_date,
                    DATE_FORMAT(art_submission_date,"' . $date_format . '") AS submission_date,
                    CASE WHEN usr1.usr_title = \'pr\' THEN \'Professor\' WHEN usr1.usr_title = \'dr\' THEN \'Dr\' WHEN usr1.usr_title = \'mr\' THEN \'Mr\' WHEN usr1.usr_title = \'mrs\' THEN \'Mrs\' WHEN usr1.usr_title = \'mis\' THEN \'Miss\' WHEN usr1.usr_title = \'mx\' THEN \'Mx\' WHEN usr1.usr_title = \'ind\' THEN \'Ind\' WHEN usr1.usr_title = \'misc\' THEN \'Misc\' WHEN usr1.usr_title = \'msr\' THEN \'Msr\' WHEN usr1.usr_title = \'prn\' THEN \'Prn\' WHEN usr1.usr_title = \'rev\' THEN \'Rev\' ELSE \'\'
                    END AS user_title,
                    usr1.usr_first_name AS user_first_name,
                    usr1.usr_last_name AS user_last_name,
                    '.$additional_user_query.'
                    CONCAT(\'RV_USER_\', usr1.usr_id) AS user_id_number,

                    CASE WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_5.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_5
                        WHERE
                            user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                    ) > 0
                    ) THEN(
                        SELECT
                            user_aff_6.usaff_company
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_6
                        WHERE
                            user_aff_6.usaff_user_id = usr1.usr_id AND user_aff_6.usaff_prime_affiliation = \'y\' LIMIT 1
                    )
                    WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_5.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_5
                        WHERE
                            user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                    ) = 0
                    ) 
                    THEN(
                    IF(
                        (
                            SELECT
                                COUNT(auth_aff_7.auaff_id)
                            FROM
                                '.$aff_tbl.' AS auth_aff_7
                            INNER JOIN '.$author_tbl.' AS auth_table_7
                            ON
                                auth_table_7.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_7.auaff_prime_affiliation = \'y\'
                        ) > 0,(SELECT
                                auth_aff_8.auaff_company
                            FROM
                                '.$aff_tbl.' AS auth_aff_8
                            INNER JOIN '.$author_tbl.' AS auth_table_8
                            ON
                                auth_table_8.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_8.auaff_prime_affiliation = \'y\' ORDER by auth_table_8.auth_id DESC LIMIT 1), NULL   
                    )
                        )
                    ELSE NULL
                    END AS affiliation,
                    CASE WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_1.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_1
                        WHERE
                            user_aff_1.usaff_user_id = usr1.usr_id AND user_aff_1.usaff_prime_affiliation = \'y\'
                    ) > 0
                    ) THEN(
                        SELECT
                            user_country_1.cnt_country
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_2
                        INNER JOIN '.$country_tbl.' AS user_country_1
                        ON
                            cnt_id = user_aff_2.usaff_cnt_id
                        WHERE
                            user_aff_2.usaff_user_id = usr1.usr_id AND user_aff_2.usaff_prime_affiliation = \'y\' LIMIT 1
                    ) WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_2.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_2
                        WHERE
                            user_aff_2.usaff_user_id = usr1.usr_id AND user_aff_2.usaff_prime_affiliation = \'y\'
                    ) = 0
                    ) THEN(
                        IF(
                            (
                            SELECT
                                COUNT(auth_aff_2.auaff_id)
                            FROM
                                '.$aff_tbl.' AS auth_aff_2
                            INNER JOIN '.$author_tbl.' AS auth_table
                            ON
                                auth_table.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_2.auaff_prime_affiliation = \'y\'
                        ) > 0,
                        (
                        SELECT
                            country_tbl.cnt_country
                        FROM
                            '.$aff_tbl.' AS aff_table_1
                        INNER JOIN '.$author_tbl.' AS auth_table_1
                        ON
                            auth_table_1.auth_id = aff_table_1.auaff_auth_id
                        INNER JOIN '.$country_tbl.' AS country_tbl
                        ON
                            cnt_id = aff_table_1.auaff_cnt_id
                        WHERE
                            aff_table_1.auaff_prime_affiliation = \'y\' AND auth_table_1.auth_usr_id = usr1.usr_id
                        ORDER BY
                            aff_table_1.auaff_id
                        DESC
                    LIMIT 1
                    ),
                    NULL
                        )
                    ) ELSE NULL
                    END AS country, CASE WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_5.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_5
                        WHERE
                            user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                    ) > 0
                    ) THEN(
                        SELECT
                            user_aff_6.usaff_address_line2
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_6
                        WHERE
                            user_aff_6.usaff_user_id = usr1.usr_id AND user_aff_6.usaff_prime_affiliation = \'y\' LIMIT 1
                    )
                    WHEN(
                        usr1.usr_id IS NOT NULL AND(
                        SELECT
                            COUNT(user_aff_5.usaff_id)
                        FROM
                            '.$user_affiliaion_tbl.' AS user_aff_5
                        WHERE
                            user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                    ) = 0
                    ) 
                    THEN(
                    IF(
                        (
                            SELECT
                                COUNT(auth_aff_7.auaff_id)
                            FROM
                                '.$aff_tbl.' AS auth_aff_7
                            INNER JOIN '.$author_tbl.' AS auth_table_7
                            ON
                                auth_table_7.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_7.auaff_prime_affiliation = \'y\'
                        ) > 0,(SELECT
                                auth_aff_8.auaff_address_line2
                            FROM
                                '.$aff_tbl.' AS auth_aff_8
                            INNER JOIN '.$author_tbl.' AS auth_table_8
                            ON
                                auth_table_8.auth_usr_id = usr1.usr_id
                            WHERE
                                auth_aff_8.auaff_prime_affiliation = \'y\' ORDER by auth_table_8.auth_id DESC LIMIT 1), NULL   
                    )
                        )
                    ELSE NULL
                    END AS user_state_or_region,
                    CASE WHEN(
                        artflw.aflw_status = \'w\' AND(
                        SELECT
                            COUNT(inner_flow_1.aflw_id) AS flw_cnt
                        FROM
                            '.$article_flow_tbl.' AS inner_flow_1
                        WHERE
                            inner_flow_1.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_1.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                    ) < artflw.aflw_stage_min_users
                    ) THEN(
                        SELECT
                            GROUP_CONCAT(inner_roles.role_name)
                        FROM
                            '.$roles_tbl.' AS inner_roles
                        WHERE
                            FIND_IN_SET(
                                inner_roles.role_id,
                            REPLACE
                                (
                                REPLACE
                                    (
                                    REPLACE
                                        (
                                            (
                                            SELECT
                                                inner_jnl_flow.jwf_parent_user_roles
                                            FROM
                                                '.$workflow_tbl.' AS inner_jnl_flow
                                            WHERE
                                                inner_jnl_flow.jwf_id = artflw.aflw_jwf_id
                                        ),
                                        \'"\',
                                        ""
                                        ),
                                        "]",
                                        ""
                                ),
                                "[",
                                ""
                            )
                            )
                    ) WHEN(
                        (
                            artflw.aflw_status = \'w\' AND(
                                (
                                SELECT
                                    COUNT(inner_flow_2.aflw_id) AS flw_cnt
                                FROM
                                    '.$article_flow_tbl.' AS inner_flow_2
                                WHERE
                                    inner_flow_2.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_2.aflw_status IN(\'u\', \'a\', \'i\', \'c\')
                            ) >= artflw.aflw_stage_min_users
                            ) AND(
                            SELECT
                                COUNT(inner_flow_3.aflw_id) AS flw_cnt
                            FROM
                                '.$article_flow_tbl.' AS inner_flow_3
                            WHERE
                                inner_flow_3.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_3.aflw_status IN(\'i\', \'c\')
                        ) < artflw.aflw_stage_min_users
                        ) OR(
                            artflw.aflw_status = \'w\' AND(
                            SELECT
                                COUNT(inner_flow_4.aflw_id) AS flw_cnt
                            FROM
                                '.$article_flow_tbl.' AS inner_flow_4
                            WHERE
                                inner_flow_4.aflw_parent_flow_id = artflw.aflw_id AND inner_flow_4.aflw_status IN(\'i\', \'c\')
                        ) >= artflw.aflw_stage_min_users
                        )
                    ) THEN(
                        SELECT
                            GROUP_CONCAT(inner_roles.role_name)
                        FROM
                            '.$roles_tbl.' AS inner_roles
                        WHERE
                            FIND_IN_SET(
                                inner_roles.role_id,
                            REPLACE
                                (
                                REPLACE
                                    (
                                    REPLACE
                                        (
                                            (
                                            SELECT
                                                inner_jnl_flow_1.jwf_who_can_invite
                                            FROM
                                                '.$workflow_tbl.' AS inner_jnl_flow_1
                                            WHERE
                                                inner_jnl_flow_1.jwf_id = artflw.aflw_jwf_id
                                        ),
                                        \'"\',
                                        ""
                                        ),
                                        "]",
                                        ""
                                ),
                                "[",
                                ""
                            )
                            )
                    )
                    WHEN
                        artflw.aflw_status = \'p\' 
                     THEN(
                        SELECT
                            GROUP_CONCAT(inner_roles.role_name)
                        FROM
                            '.$roles_tbl.' AS inner_roles
                        WHERE
                            FIND_IN_SET(
                                inner_roles.role_id,
                            REPLACE
                                (
                                REPLACE
                                    (
                                    REPLACE
                                        (
                                            (
                                            SELECT
                                                inner_jnl_flow.jwf_parent_user_roles
                                            FROM
                                                '.$workflow_tbl.' AS inner_jnl_flow
                                            WHERE
                                                inner_jnl_flow.jwf_id = artflw.aflw_jwf_id
                                        ),
                                        \'"\',
                                        ""
                                        ),
                                        "]",
                                        ""
                                ),
                                "[",
                                ""
                            )
                            )
                    )
                    ELSE role_name
                    END AS role_name,
                    jwf_stage_name,
                    IF(
                        jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL,
                        (
                        SELECT
                            DATE_FORMAT(
                                aflwtbk.aflw_posted_date,
                                "' . $date_format . '"
                            )
                        FROM
                            tbk_article_flow AS aflwtbk
                        WHERE
                            artflw.aflw_id = aflwtbk.aflw_id AND aflwtbk.aflw_status = \'i\'
                        ORDER BY
                            tbk_id 
                        LIMIT 1
                    ),
                    NULL
                    ) AS invited_date,
                    DATE_FORMAT(
                        artflw.aflw_accepted_date,
                        "' . $date_format . '"
                    ) AS task_accepted_date,
                    DATE_FORMAT(
                        IF(
                            jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL AND artflw.aflw_status = \'d\',
                            artflw.aflw_returned_date,
                            \'NA\'
                        ),
                        "' . $date_format . '"
                    ) AS task_rejected_date,
                    DATE_FORMAT(
                        artflw.aflw_returned_date,
                        "' . $date_format . '"
                    ) AS task_completed_date,
                    CASE WHEN(artflw.aflw_status = \'g\' AND jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL) THEN (
                        SELECT
                                DATE_FORMAT(
                                        aflwtbk1.aflw_posted_date,
                                        "' . $date_format . '"
                                        )
                                FROM
                                    tbk_article_flow AS aflwtbk1
                                WHERE
                                    artflw.aflw_id = aflwtbk1.aflw_id AND aflwtbk1.aflw_status = \'g\'
                                ORDER BY
                                    tbk_id DESC
                                LIMIT 1 
                        ) WHEN (artflw.aflw_status = \'u\' AND jwf_stage_type = \'review\' AND artflw.aflw_parent_flow_id IS NOT NULL AND (SELECT count(aflwtbk.tbk_id)
                        FROM
                            tbk_article_flow AS aflwtbk
                        WHERE
                            artflw.aflw_id = aflwtbk.aflw_id AND aflwtbk.aflw_status = \'i\') > 0) 
                            THEN (
                                SELECT
                                                DATE_FORMAT(
                                                        aflwtbk1.aflw_posted_date,
                                                        "' . $date_format . '"
                                                        )
                                                FROM
                                                    tbk_article_flow AS aflwtbk1
                                                WHERE
                                                    artflw.aflw_id = aflwtbk1.aflw_id AND aflwtbk1.aflw_status = \'u\'
                                                ORDER BY
                                                    tbk_id DESC
                                                LIMIT 1 ) ELSE NULL END AS uninvited_unassigned_date,
                    '.$pi_name.'
                    CONCAT_WS(
                        " ",
                        usr2.usr_first_name,
                        usr2.usr_middle_name,
                        usr2.usr_last_name
                    ) AS submitting_author,
                    DATE_FORMAT(
                        IF(
                            art1.art_pre_all_ids IS NOT NULL,
                            (
                            SELECT
                                art3.art_decision_date
                            FROM
                                '.$article_tbl.' AS art3
                            WHERE
                                art3.art_id = CAST(
                                    TRIM(
                                        SUBSTRING_INDEX(art1.art_pre_all_ids, \',\', 1)
                                    ) AS SIGNED
                                )
                        ),
                        art1.art_decision_date
                        ),
                        "' . $date_format . '"
                    ) AS date_of_first_decision,
                    DATE_FORMAT(
                        art1.art_final_decision_date,
                        "' . $date_format . '"
                    ) AS date_of_final_decision,
                    DATE_FORMAT( artflw.aflw_posted_date,"' . $date_format . '") AS last_updated_date,
                    jwf_parent_stages,
                    artflw.aflw_id as aflw_id,
                    artflw.aflw_jwf_id as aflw_jwf_id,
                    art1.art_status as art_status,
                    (
                        CASE WHEN art1.art_status = \'a\' THEN \'Accepted\' WHEN art1.art_status = \'r\' THEN \'Rejected\' WHEN art1.art_status = \'y\' THEN \'Peer review in progress\' WHEN art1.art_status = \'c\' THEN \'Revised\' WHEN (art1.art_status = \'t\') THEN \'Under transfer process\' ELSE \'Not submitted\'
                    END
                    ) AS decision
                    FROM
                        '.$article_tbl.' AS art1
                    INNER JOIN '.$article_flow_tbl.' AS artflw
                    ON
                        art1.art_id = artflw.aflw_art_id
                    LEFT JOIN '.$users_tbl.' AS `usr1`
                    ON
                        artflw.aflw_usr_id = usr1.usr_id
                    '.$journal_join.'
                    INNER JOIN '.$workflow_tbl.' ON artflw.aflw_jwf_id = jwf_id
                    INNER JOIN `'.$roles_tbl.'` ON jwf_role_id = role_id
                    INNER JOIN '.$users_tbl.' AS `usr2`
                    ON
                        art1.art_submitted_by = usr2.usr_id
                    INNER JOIN `'.$author_tbl.'` ON art1.art_id = auth_art_id
                    WHERE art1.art_delete_status = \'n\' '.$date_condition.' '.$art_status_condition.' '.$artp_condition.' '.$journal_where_condition.'
                    GROUP BY
                        artflw.aflw_id
                    ORDER BY
                        art_id,
                        artflw.aflw_id '); 
                        if($restricted_mode == TRUE)
                        {
                            $loop_article_code = '';
                            $co_authors_list = [];
                            $submitting_author = [];
                            $corresponding_author = [];
                            $parent_stages_list = '';
                            $row_count = 0;
                            $transfer_stage = [];
                            $extracted_array = [];
                            foreach($result as $single_row)
                            {
                                $parent_stages_list = '';
                                //$single_row->country = $single_row->user_country;
                                $single_row->co_authors = [];
                                $single_row->parent_node = NULL;
                                $transfered_article = FALSE;

                                if($loop_article_code !== $single_row->article_id)
                                {
                                    $submitting_author = [];
                                    $corresponding_author = [];
                                    $transfer_stage = [];
                                    if($single_row->jwf_stage_name == 'Transit')
                                    {
                                        $trans_data = array_slice((array)$single_row,0);
                                        $transfer_stage = $this->transfered_article_check((object)$trans_data);
                                        if(count($transfer_stage))
                                        {
                                           foreach($transfer_stage as $single_transfer)
                                            {
                                               array_splice($result, $row_count, 0, (object)[$single_transfer]);
                                            }
                                            $transfer_stage = [];                        
                                         }
                                    }
                                    /*if($single_row->art_status == 'c' || $single_row->art_status == 'y')
                                    {
                                        $trans_data = array_slice((array)$single_row,0);
                                        $transfer_stage = $this->transfered_article_check((object)$trans_data);
                                        if(count($transfer_stage))
                                        {
                                            $next_stage = $result[$row_count+1];
                                            if($next_stage->jwf_stage_name == 'Transit')
                                            {
                                                foreach($transfer_stage as $single_transfer)
                                                {
                                                   array_splice($result, $row_count+1, 0, (object)[$single_transfer]);
                                                }
                                                $transfer_stage = [];
                                            }
                                         }
                                    }*/
                                    $get_co_author_records = $Users::get_records_by_raw_query('SELECT
                                    usr_first_name AS first_name,
                                    usr_last_name AS last_name,
                                    usr_email AS email,
                                    art_submitted_by AS submitted_by,
                                    auth_corr_author,
                                    auth_usr_id,
                                    CASE WHEN(
                                    usr1.usr_id IS NOT NULL AND(
                                    SELECT
                                        COUNT(user_aff_1.usaff_id)
                                    FROM
                                        rvw_user_affiliation AS user_aff_1
                                    WHERE
                                        user_aff_1.usaff_user_id = usr1.usr_id AND user_aff_1.usaff_prime_affiliation =\'y\'
                                                    ) > 0
                                                    ) THEN(
                                                        SELECT
                                                            user_country_1.cnt_country
                                                        FROM
                                                            rvw_user_affiliation AS user_aff_2
                                                        INNER JOIN rvw_country AS user_country_1
                                                        ON
                                                            cnt_id = user_aff_2.usaff_cnt_id
                                                        WHERE
                                                            user_aff_2.usaff_user_id = usr1.usr_id AND user_aff_2.usaff_prime_affiliation = \'y\' LIMIT 1
                                                    ) WHEN(
                                                        usr1.usr_id IS NOT NULL AND(
                                                        SELECT
                                                            COUNT(user_aff_2.usaff_id)
                                                        FROM
                                                            rvw_user_affiliation AS user_aff_2
                                                        WHERE
                                                            user_aff_2.usaff_user_id = usr1.usr_id AND user_aff_2.usaff_prime_affiliation = \'y\'
                                                    ) = 0
                                                    ) THEN(
                                                        IF(
                                                            (
                                                            SELECT
                                                                COUNT(auth_aff_2.auaff_id)
                                                            FROM
                                                               rvw_author_affiliation AS auth_aff_2
                                                            INNER JOIN rvw_article_authors  AS auth_table
                                                            ON
                                                                auth_table.auth_usr_id = usr1.usr_id
                                                            WHERE
                                                                auth_aff_2.auaff_prime_affiliation = \'y\'
                                                        ) > 0,
                                                        (
                                                        SELECT
                                                            country_tbl.cnt_country
                                                        FROM
                                                            rvw_author_affiliation AS aff_table_1
                                                        INNER JOIN rvw_article_authors AS auth_table_1
                                                        ON
                                                            auth_table_1.auth_id = aff_table_1.auaff_auth_id
                                                        INNER JOIN rvw_country AS country_tbl
                                                        ON
                                                            cnt_id = aff_table_1.auaff_cnt_id
                                                        WHERE
                                                            aff_table_1.auaff_prime_affiliation =\'y\' AND auth_table_1.auth_usr_id = usr1.usr_id
                                                        ORDER BY
                                                            aff_table_1.auaff_id
                                                        DESC
                                                    LIMIT 1
                                                    ),
                                                    NULL
                                                        )
                                                    ) ELSE NULL
                                                    END AS country,IF(usr_orcid_id = null,null,CONCAT("https://orcid.org/",usr_orcid_id)) as orcid, CASE WHEN(
                                    usr1.usr_id IS NOT NULL AND(
                                    SELECT
                                        COUNT(user_aff_5.usaff_id)
                                    FROM
                                        rvw_user_affiliation AS user_aff_5
                                    WHERE
                                        user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                                ) > 0
                                ) THEN(
                                    SELECT
                                        user_aff_6.usaff_company
                                    FROM
                                        rvw_user_affiliation AS user_aff_6
                                    WHERE
                                        user_aff_6.usaff_user_id = usr1.usr_id AND user_aff_6.usaff_prime_affiliation = \'y\'
                                    LIMIT 1
                                ) WHEN(
                                    usr1.usr_id IS NOT NULL AND(
                                    SELECT
                                        COUNT(user_aff_5.usaff_id)
                                    FROM
                                        rvw_user_affiliation AS user_aff_5
                                    WHERE
                                        user_aff_5.usaff_user_id = usr1.usr_id AND user_aff_5.usaff_prime_affiliation = \'y\'
                                ) = 0
                                ) THEN(
                                    IF(
                                        (
                                        SELECT
                                            COUNT(auth_aff_7.auaff_id)
                                        FROM
                                            rvw_author_affiliation AS auth_aff_7
                                        INNER JOIN rvw_article_authors AS auth_table_7
                                        ON
                                            auth_table_7.auth_usr_id = usr1.usr_id
                                        WHERE
                                            auth_aff_7.auaff_prime_affiliation = \'y\'
                                    ) > 0,
                                    (
                                    SELECT
                                        auth_aff_8.auaff_company
                                    FROM
                                        rvw_author_affiliation AS auth_aff_8
                                    INNER JOIN rvw_article_authors AS auth_table_8
                                    ON
                                        auth_table_8.auth_usr_id = usr1.usr_id
                                    WHERE
                                        auth_aff_8.auaff_prime_affiliation = \'y\'
                                    ORDER BY
                                        auth_table_8.auth_id
                                    DESC
                                LIMIT 1
                                ),
                                NULL
                                    )
                                ) ELSE NULL
                                END AS affiliation,
                                "CoAuthor" as role_name
                                from rvw_users as usr1 INNER JOIN rvw_article_authors ON auth_usr_id = usr1.usr_id INNER JOIN rvw_articles ON art_id = auth_art_id WHERE art_code ="'.$single_row->article_id.'"');
                                 if(!empty($get_co_author_records))
                                    {
                                        $co_author_arr = [];
                                        foreach($get_co_author_records as $single_authors)
                                        {
                                            $skip_co_author = FALSE;
                                            if($single_authors->submitted_by == $single_authors->auth_usr_id)
                                            {
                                                $insert_row = array_slice((array)$single_authors,0);
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'auth_usr_id');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'submitted_by');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'auth_corr_author');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'role_name');
                                                $submitting_author = $insert_row;
                                                $skip_co_author = TRUE;
                                            }
                                            if($single_authors->auth_corr_author == 'y')
                                            {
                                                $insert_row = array_slice((array)$single_authors,0);
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'auth_usr_id');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'submitted_by');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'auth_corr_author');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'role_name');
                                                $corresponding_author = $insert_row;
                                                $skip_co_author = TRUE;
                                            }
                                            if($skip_co_author == FALSE)
                                            {
                                                $insert_row = array_slice((array)$single_authors,0);
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'auth_usr_id');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'submitted_by');
                                                $insert_row =$this->removeKeyFromObject((object)$insert_row, 'auth_corr_author');
                                                array_push($co_author_arr,$insert_row);
                                            }
                                        }
                                        $single_row->submitting_author = $submitting_author;
                                        $single_row->corresponding_author = $corresponding_author; 
                                        $single_row->co_authors = $co_author_arr;
                                        $co_authors_list =  $co_author_arr;                           //$single_row->article_id);

                                    }
                                    $loop_article_code = $single_row->article_id;
                                }
                                else
                                {
                                    $single_row->submitting_author = $submitting_author;
                                    $single_row->corresponding_author = $corresponding_author; 
                                    $single_row->co_authors = $co_authors_list;
                                    if($single_row->jwf_stage_name == 'Transit')
                                    {
                                        $trans_data = array_slice((array)$single_row,0);
                                        $transfer_stage = $this->transfered_article_check((object)$trans_data);
                                        if(count($transfer_stage))
                                        {
                                           foreach($transfer_stage as $single_transfer)
                                            {
                                               array_splice($result, $row_count, 0, (object)[$single_transfer]);
                                            }
                                            $transfer_stage = [];                        
                                         }
                                    }
                                   /* if(count($transfer_stage))
                                    {
                                        $next_stage = $result[$row_count+1];
                                        if(isset($next_stage->jwf_stage_name) && $next_stage->jwf_stage_name == 'Transit')
                                        {
                                            foreach($transfer_stage as $single_transfer)
                                            {
                                               array_splice($result, $row_count+1, 0, (object)[$single_transfer]);
                                            }
                                            $transfer_stage = [];
                                        }
                                     }*/

                                }
                                if($single_row->jwf_parent_stages !== '[]')
                                {
                                    $get_parent_stages = $this->get_parent_stages_for_report($single_row->art_id,$single_row);
                                    $parent_stages_list = $get_parent_stages;
                                }
                                $single_row->parent_node  = $parent_stages_list;
                                $row_count++;
                                
                            }
                            foreach($result as $single_row)
                            {
                                $rewrite_array = [];
                                $rewrite_array['article_id'] = $single_row->article_id;
                                $rewrite_array['article_type'] = $single_row->article_type;
                                $rewrite_array['article_title'] = $single_row->article_title;
                                $rewrite_array['article_flags'] = $single_row->article_flags;
                                $rewrite_array['current_status'] = $single_row->current_status;
                                $rewrite_array['original_submission_date'] = $single_row->original_submission_date;
                                $rewrite_array['submission_date'] = $single_row->submission_date;
                                $rewrite_array['user_title'] = $single_row->user_title;
                                $rewrite_array['user_first_name'] = $single_row->user_first_name;

                                $rewrite_array['user_last_name'] = $single_row->user_last_name;
                                $rewrite_array['user_id_number'] = $single_row->user_id_number;
                                $rewrite_array['email'] = $single_row->email;
                                $rewrite_array['country'] = $single_row->country;
                                $rewrite_array['orcid'] = $single_row->orcid;
                                $rewrite_array['affiliation'] = $single_row->affiliation;
                                $rewrite_array['user_state_or_region'] = $single_row->user_state_or_region;
                                $rewrite_array['role_name'] = $single_row->role_name;
                                $rewrite_array['jwf_stage_name'] = $single_row->jwf_stage_name;
                                $rewrite_array['invited_date'] = $single_row->invited_date;
                                $rewrite_array['task_accepted_date'] = $single_row->task_accepted_date;
                                $rewrite_array['task_rejected_date'] = $single_row->task_rejected_date;
                                $rewrite_array['task_completed_date'] = $single_row->task_completed_date;
                                $rewrite_array['uninvited_unassigned_date'] = $single_row->uninvited_unassigned_date;
                                $rewrite_array['submitting_author'] = $single_row->submitting_author;
                                $rewrite_array['corresponding_author'] = isset($single_row->corresponding_author)?$single_row->corresponding_author:'';

                                $rewrite_array['co_authors'] = $single_row->co_authors;
                                $rewrite_array['date_of_first_decision'] = $single_row->date_of_first_decision;
                                $rewrite_array['date_of_final_decision'] = $single_row->date_of_final_decision;
                                $rewrite_array['last_updated_date'] = $single_row->last_updated_date;
                                $rewrite_array['parent_node'] = $single_row->parent_node;
                                $rewrite_array['decision'] = $single_row->decision;


                                /* //$single_row->article_type = $article_type_id->artp_article_type;
                                 $single_row =$this->removeKeyFromObject($single_row, 'jwf_parent_stages');
                                 $single_row =$this->removeKeyFromObject($single_row, 'aflw_id');
                                 $single_row =$this->removeKeyFromObject($single_row, 'aflw_jwf_id');
                                 $single_row =$this->removeKeyFromObject($single_row, 'art_status');
                                 $single_row =$this->removeKeyFromObject($single_row, 'art_id');*/
                                array_push($extracted_array,$rewrite_array);
                            }
                        }
                        if($return_arr == '')
                        {
                            $return_arr = json_encode($extracted_array);
                        }
                        else
                        {
                            $arr_1 = json_decode($return_arr);
                            $arr_2 = $extracted_array;
                            $return_arr = array_merge($arr_1,$arr_2);
                            $return_arr = json_encode($return_arr);
                        }
                    }
                        $response_data = [
                            'status' => 200,
                            'status_message' => TRUE,
                            'data' => json_decode($return_arr),
                            'message' => 'success' 
                        ];
                        if(!isset($request->last_updated_date))
                        {
                            $jsonData = json_encode($return_arr, JSON_PRETTY_PRINT);
                            $cur_date = date('d_m_Y_H_i_s');
                            $fileName = $request->jnl_code.'_'.$cur_date.'_data.json';
                            $filePath = 'public/uploads/data_api/' . $fileName;
                            Storage::put($filePath, $jsonData);
                        }
                        return $response_data;
                    }
                    catch (\Exception $e) {
                        $response_data = [
                            'status' => 500,
                            'status_message' => FALSE,
                            'message' => ''
                        ];
                        return $response_data;
                    }

                }
                else if($api_type == 'reviewer_coi')
                {
                    $return_arr = '';
                    foreach($all_active_journals as $single_journals)
                    {
                        $journal_abbr = 'rvw_article_gnf_form_data_'.$single_journals->jnl_journal_code;
                    $result = $Users::get_records_by_raw_query('SELECT art1.art_code as article_id,CASE WHEN usr1.usr_title = \'pr\' THEN \'Professor\' WHEN usr1.usr_title = \'dr\' THEN \'Dr\' WHEN usr1.usr_title = \'mr\' THEN \'Mr\' WHEN usr1.usr_title = \'mrs\' THEN \'Mrs\' WHEN usr1.usr_title = \'mis\' THEN \'Miss\' WHEN usr1.usr_title = \'mx\' THEN \'Mx\' WHEN usr1.usr_title = \'ind\' THEN \'Ind\' WHEN usr1.usr_title = \'misc\' THEN \'Misc\' WHEN usr1.usr_title = \'msr\' THEN \'Msr\' WHEN usr1.usr_title = \'prn\' THEN \'Prn\' WHEN usr1.usr_title = \'rev\' THEN \'Rev\' ELSE \'\' END AS user_title,usr1.usr_first_name as user_first_name, usr1.usr_last_name as user_last_name,usr1.usr_email as user_email, CONCAT(\'RV_USER_\',usr1.usr_id) AS person_id,role_name as role, jwf_stage_name as task, DATE_FORMAT(artflw.aflw_accepted_date,"' . $date_format . '") as task_accepted_date,DATE_FORMAT(artflw.aflw_returned_date,"' . $date_format . '") as task_completed_date,DATE_FORMAT(aflw_returned_date,"' . $date_format . '") as disclosure_date, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COI_EMPLOYER\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as reviewer_employer,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'EMPLOYER_RELATIONSHIP\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'EMPLOYER_APPLIES_TO\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'EMPLOYED_STOCK_COMPENSATION\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as finance_buisiness_compensation, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_1, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_1, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_1, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_2, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_2, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_2, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_3, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_3, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_3, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_4, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_4, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_4, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'COMPANY_ORGANIZATION_NAME_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as name_of_company_5, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'NATURE_OF_RELATIONSHIP_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as nature_of_relationship_company_5, (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_company_5,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PER_ASS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_associations,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_1\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_1,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_1_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_1,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_1_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_1,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_2\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_2,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_2_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_2,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_2_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_2,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_3\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_3,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_3_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_3,
                    (SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_3_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_3,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_4\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_4,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_4_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_4,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_4_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_4,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'PERSONAL_ASSOCIATION_COMPANY_5\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_company_5,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'RELATIONSHIP_5_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as personal_association_relationship_5,(SELECT gdata_display_data FROM rvw_article_gnf_form_data_pcori as inner_gdata WHERE gdata_unique_identifier = \'APPLIES_TO_5_PERSONAL_ASSOCIATIONS\' AND inner_gdata.gdata_art_id = art1.art_id AND inner_gdata.gdata_artflw_id = artflw.aflw_id GROUP BY inner_gdata.gdata_artflw_id) as applies_to_personal_association_5 FROM '.$article_tbl.' AS art1 INNER JOIN `'.$article_flow_tbl.'` AS artflw ON art1.art_id = artflw.aflw_art_id INNER JOIN `'.$users_tbl.'` AS `usr1` ON artflw.aflw_usr_id = usr1.usr_id INNER JOIN `'.$workflow_tbl.'` ON artflw.aflw_jwf_id = jwf_id INNER JOIN `'.$roles_tbl.'` ON jwf_role_id = role_id INNER JOIN rvw_article_gnf_form_data_pcori ON gdata_art_id = art1.art_id INNER JOIN `'.$Article_types.'` AS art_type
                    ON
                        art1.art_artp_id = art_type.artp_id
                    INNER JOIN `'.$journal_tbl.'` AS jnl_tbl
                    ON
                    art_type.artp_jnl_id = jnl_tbl.jnl_id WHERE art1.art_status != \'n\' AND jwf_stage_type = \'review\' AND artflw.aflw_status = \'c\' AND gdata_unique_identifier IN(\'COI_EMPLOYER\',\'EMPLOYER_RELATIONSHIP\',\'EMPLOYER_APPLIES_TO\',\'EMPLOYED_STOCK_COMPENSATION\',\'COMPANY_ORGANIZATION_NAME_1\',\'NATURE_OF_RELATIONSHIP_1\',\'APPLIES_TO_1\',\'COMPANY_ORGANIZATION_NAME_2\',\'NATURE_OF_RELATIONSHIP_2\',\'APPLIES_TO_2\',\'COMPANY_ORGANIZATION_NAME_3\',\'NATURE_OF_RELATIONSHIP_3\',\'APPLIES_TO_3\',\'COMPANY_ORGANIZATION_NAME_4\',\'NATURE_OF_RELATIONSHIP_4\',\'APPLIES_TO_4\',\'COMPANY_ORGANIZATION_NAME_5\',\'NATURE_OF_RELATIONSHIP_5\',\'APPLIES_TO_5\',\'PER_ASS\',\'PERSONAL_ASSOCIATION_COMPANY_1\',\'RELATIONSHIP_1_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_1_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_2\',\'RELATIONSHIP_2_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_2_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_3\',\'RELATIONSHIP_3_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_3_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_4\',\'RELATIONSHIP_4_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_4_PERSONAL_ASSOCIATIONS\',\'PERSONAL_ASSOCIATION_COMPANY_5\',\'RELATIONSHIP_5_PERSONAL_ASSOCIATIONS\',\'APPLIES_TO_5_PERSONAL_ASSOCIATIONS\') AND jnl_tbl.jnl_id = '.$single_journals->jnl_id.' GROUP BY artflw.aflw_id ORDER BY art_id,artflw.aflw_id');
                    if($return_arr == '')
                    {
                        $return_arr = json_encode($result);
                    }
                    else
                    {
                        $arr_1 = json_decode($return_arr);
                        $arr_2 = $result;
                        $return_arr = array_merge($arr_1,$arr_2);
                        $return_arr = json_encode($return_arr);
                    }
                    }
                    $response_data = [
                        'status' => 200,
                        'status_message' => TRUE,
                        'data' => json_decode($return_arr),
                        'message' => 'success' 
                    ];
                    return $response_data;
                }
                else
                {
                    $response_data = [
                        'status' => 404,
                        'status_message' => FALSE,
                        'message' => 'invalid api type'
                    ];
                    return $response_data;
                }
        }
        else
        {
            $response_data = [
                'status' => 400,
                'status_message' => FALSE,
                'message' => 'API type needed'
            ];
            return $response_data;
        }
    }
    catch (\Exception $e) {
        $response_data = [
            'status' => 500,
            'status_message' => FALSE,
            'message' => ''
        ];
        return $response_data;
    }
}

    public function manage_review_history_response($parameters, $api_client_details, $redirect_function = NULL, $data_to_display = NULL, $return_only_page_extent = FALSE, $api_type=NULL, $request = array())
    {
        //Function for Review history response
        $return_data =  NULL;
        $result      =  array();

        //checking parameters and log request entry
        $check_params = $this->check_parameters($request, $parameters);
        if ($check_params != FALSE)
        {
            $journal_code   =   '';
            $article_code   =   '';
            $article_doi    =   '';

            if(isset($_GET['journal_code']) && $_GET['journal_code'] != '')
                $journal_code = $_GET['journal_code'];
                
            if(isset($_GET['article_code']) && $_GET['article_code'] != '')
                $article_code = $_GET['article_code'];  
                
            if(isset($_GET['article_doi']) && $_GET['article_doi'] != '')
                $article_doi = $_GET['article_doi'];  

            if( $journal_code == ''  && $article_code == '' && $article_doi == ""){
                $return_data = [
                    'status' => 404,
                    'status_message' => FALSE,
                    'message' => customTrans('Please provide :Article code/doi or :Journal code to proceed.')
                ];
                return $return_data;
            }

            $Articles       = (new \App\Models\Articles());
            $Article_types  = (new \App\Models\Article_types());
            $Journals       = (new \App\Models\Journals());

            $articles_table     =   $Articles->getTable();
            $article_type_table =   $Article_types->getTable();
            $journals_table     =   $Journals->getTable();

            if(!empty($journal_code))
            {              
                $criteria   = "art_delete_status = 'n' AND jnl_journal_code='{$journal_code}'";
                $select     = 'art_id, art_doi';
                $tables = array(
                    'main_table' => $articles_table,
                    'join_table' => array(
                        $article_type_table => array($article_type_table . '.artp_id', $articles_table . '.art_artp_id', "left"),
                        $journals_table => array($journals_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "left")
                    )
                );
                $article_codes = $Articles::get_results_using_joins($tables, $select, $criteria, 'all');
                if(count($article_codes) > 0)
                {
                    $rrr    =   array();
                    foreach($article_codes as $each_art_id)
                    {
                        $rrr[]  =   $each_art_id->art_id;
                    }
                    foreach($rrr as $each_art_id)
                    {
                        $result[] = $this->get_article_page_extend_details($each_art_id, TRUE);
                    }
                }
                $return_data = [
                    'status' => 200,
                    'status_message' => TRUE,
                    'message' => 'success',
                    'data' => $result
                ];
                return $return_data;
            }
            $condi = "art_code = '$article_code'";
            if(!empty($article_doi))
            {
                $condi = "art_doi = '$article_doi'";//"art_delete_status = 'n' and "
            }
            $check_article_doi = $Articles::get_single_record('art_id, art_doi, art_status', $condi, NULL, '', 'art_id DESC');
            if (!empty($check_article_doi))
            {
                if ($check_article_doi->art_status == 'n')
                {
                    $return_data = [
                        'status' => 404,
                        'status_message' => FALSE,
                        'message' => customTrans(':Article not yet submitted!')
                    ];
                }
                $article_doi = $check_article_doi->art_doi;
                /*
                * retrieving the relevent details for the response.
                * checks whether the api client is sandbox or production.
                * Redirects to the corredponding function.
                * function should be defined in the review_api config file.
                */
                $result = $this->$redirect_function($article_doi, $api_client_details, $return_only_page_extent);
                if ($result != FALSE)
                {
                    if(!empty($data_to_display) && !is_array($result))
                        $result->data_to_display = $data_to_display;
                    /* /*
                        * access_token can be used only once, after a success response, the current access token is deleted.
                        * if there is a need for another api call, new access token has to be generated
                        */
                    $token_id = $api_client_details['token_id'];
                    //end access_token deletion
                    $return_data = [
                        'status' => 200,
                        'status_message' => TRUE,
                        'message' => 'Success',
                        'data' => $result
                    ];
                }
                elseif(isset($result['status']) && $result['status'] == 'failed')
                {
                    $return_data = [
                        'status' => 404,
                        'status_message' => FALSE,
                        'message' => 'Invalid api type'
                    ];
                }
                else
                {
                    $return_data = [
                        'status' => 401,
                        'status_message' => FALSE,
                        'message' => customTrans('Unauthorized :article doi request')
                    ];
                }
            }
        }
        else
        {
            $return_data = [
                'status' => 404,
                'status_message' => FALSE,
                'message' => 'Parameter missing'
            ];
        }
        return $return_data;
    }

    public function get_ice_review_history($article_doi, $api_client_details, $return_only_page_extent = FALSE)
    {
        //retriving user titles from libraries/user
        $author_titles  = $this->UserConfigdata('titles')['titles'];
        //retriving stage status from assistant_helper
        $status_options  = invitation_status();

        $Articles       = (new \App\Models\Articles());
        $Article_types  = (new \App\Models\Article_types());
        $Journals       = (new \App\Models\Journals());

        $articles_table     =   $Articles->getTable();
        $article_type_table =   $Article_types->getTable();
        $journals_table     =   $Journals->getTable();

        //initializing
        $curnt_version_details  = '';

        $select     =   "art_id,art_status,jnl_id,jnl_journal_code as journal_code, jnl_journal_name as journal_name, art_doi as article_doi, artp_article_type as submitted_article_type, art_published_article_type as published_article_type_id, art_pre_all_ids as all_prev_ids,art_transfer_article";
        $criteria   =   'art_doi = "'.$article_doi.'"';
        $tables = array(
            'main_table' => $articles_table,
            'join_table' => array(
                $article_type_table => array($article_type_table . '.artp_id', $articles_table . '.art_artp_id', "left"),
                $journals_table => array($journals_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "left")
            )
        );
        // DB::enableQueryLog();    
        $fetch_journal_details = $Articles::get_results_using_joins($tables, $select, $criteria, '', 'art_id DESC');
        // $query = DB::getQueryLog();
        // dd(end($query));

        /*
         * checking whether the api_client have the permission to view the article review history under the specified journal
         * if $api_client_details['journals'] is null, then the api_client has permission to view all the journal,
         * otherwise, specify the journal in the api_client UI.
         */
        if(!empty($fetch_journal_details)) {
            $journal_details            =   $fetch_journal_details[0];
            $journal_id                 =   $journal_details->jnl_id;
            $authorized_client_jnl_id   =   array_filter(explode(',',$api_client_details['journals']));
            if(!empty($authorized_client_jnl_id) && !in_array($journal_id , $authorized_client_jnl_id) )
            {
                return FALSE;
            }
            $curnt_version_id     = $journal_details->art_id;
            //removing non-essential data from the response
            unset($journal_details->published_article_type_id);
            unset($journal_details->art_transfer_article);
            unset($journal_details->all_prev_ids);
            unset($journal_details->art_status);
            unset($journal_details->art_id);
            unset($journal_details->jnl_id);
            /*
            * get current version and the previous version,if any
            * resubmitted articles
            */
            if($return_only_page_extent == TRUE)
            {
                unset($journal_details->journal_name);
                unset($journal_details->article_doi);
                unset($journal_details->submitted_article_type);
                
            }
            $curnt_version_details          = $this->get_article_version($curnt_version_id,NULL,$status_options,$author_titles,TRUE, $return_only_page_extent);
            $journal_details->current_version   = $curnt_version_details;
            return $journal_details;
        }
        else {
            return FALSE;
        }           
    }

    public function get_article_version($version_id,$approved_stages = NULL,$status_options,$author_titles,$for_ice = FALSE, $return_only_page_extent = FALSE)
    {
        //initializing
        $a = 0;
        $b = 0;
        $journal_id     = '';
        $journal_code   = '';
        $fwm_id         = '';
        $art_upld_path  = '';
        $return_data     = array();
        $article_details = array();
        $author_details  = array();
        $article_stages  = array();
        $jnl_flw_arr     = array();
        $stg_usr_det     = new \stdClass();
        $child_stage_details    = array();

        //fetching article details--starts
        $article_details = $this->get_article_details($version_id,$for_ice);
        if($article_details != NULL)
        {
            //variable assignment
            $journal_id     = $article_details->journal_id;
            $journal_code   = $article_details->journal_code;
            $fwm_id         = $article_details->artp_fwm_id;
            $art_upld_path  = $article_details->art_article_upload_path;
            $art_code       = $article_details->code;

            //removing unnecessary fields from the response
            unset($article_details->artp_id);
            unset($article_details->journal_id);
            unset($article_details->artp_fwm_id);
            unset($article_details->journal_code);
            unset($article_details->art_article_upload_path);
        }
        //fetching article details--ends
        
		if($return_only_page_extent == TRUE)
		{
			unset($article_details->art_status);
			unset($article_details->art_decision_date);
			unset($article_details->abstract);
			unset($article_details->revised_count);
			unset($article_details->original_submission_date);
			unset($article_details->editorial_status);
			unset($article_details->editorial_status_date);
			unset($article_details->publication_charges_status);
			unset($article_details->publication_date);
			$return_data   =   array(
				'article_details'   =>  $article_details,
			);
			 return $return_data;
		}

        //fetching authors details--starts
        $author_details = $this->get_author_details($version_id,$author_titles,$for_ice);
		if(empty($author_details))
		{
			$author_details = $this->get_author_details($version_id,$author_titles,$for_ice,'n');
		}
        //fetching authors details--ends

        //fetching article_stages - starts
        $article_flow = array();
        $Article_flow   =   (new \App\Models\Article_flow()); 
        $Generic_flows  =   (new \App\Models\Generic_flows());
        $Roles          =   (new \App\Models\Roles());
        $Users          =   (new \App\Models\User());
        $Payment_order  =   (new \App\Models\Payment_order()); 

        $artflow_tbl    =   $Article_flow->getTable();
        $workflow_tbl   =   $Generic_flows->getTable();
        $roles_tbl      =   $Roles->getTable();
        $users_tbl      =   $Users->getTable();
        $payment_tbl    =   $Payment_order->getTable();

        $select     =   'aflw_id,aflw_parent_flow_id,aflw_jwf_id,aflw_usr_id,aflw_accepted_date as started_date, aflw_returned_date as completed_date, aflw_status,aflw_level,aflw_posted_by, jwf_stage_name as stage_name,jwf_stage_type as stage_type, usr_title as user_title, usr_first_name as user_first_name, usr_middle_name as user_middle_name, usr_last_name as user_last_name, role_name';
        $criteria   =   'aflw_art_id = '.$version_id;
        $criteria  .=   ' AND aflw_status != \'p\'';
        if(empty($approved_stages))
        {
            $criteria  .= ' AND aflw_usr_id IS NOT NULL';
        }

        $join_tables = array(
            'main_table' => $artflow_tbl,
            'join_table' => array(
                $workflow_tbl => array($artflow_tbl . '.aflw_jwf_id', $workflow_tbl . '.jwf_id', "LEFT"),
                $users_tbl => array($users_tbl . '.usr_id', $artflow_tbl . '.aflw_usr_id', "LEFT"),
                $roles_tbl => array($roles_tbl . '.role_id', $workflow_tbl . '.jwf_role_id')
            )
        );
        $article_flow = $Article_flow::get_results_using_joins($join_tables, $select, $criteria, 'all', $orderby='aflw_id,aflw_level', NULL, '', NULL, $distinct = TRUE);
        
        /* /*
         * structure for article stage flow -starts
         * When the loop starts $jnl_flw_arr is empty ,so it enters in the if statement
         * when the parent_flow_id is not empty
         *
         */
        if(!empty($article_flow))
        {
            foreach($article_flow as $art_flw)
            {
                if($art_flw->stage_type == 'review' && $art_flw->aflw_usr_id == NULL)
                {
                    continue;
                }
                $article_flw_id       = $art_flw->aflw_id;
                $aflw_parent_flow_id  = $art_flw->aflw_parent_flow_id;
                $journal_work_flow_id = $art_flw->aflw_jwf_id;
                $stage_name           = $art_flw->stage_name;
                $stage_type           = $art_flw->stage_type;
                $stage_status         = $art_flw->aflw_status;
                $started_date         = $art_flw->started_date;
                $completed_date       = $art_flw->completed_date;
                $user_id              = $art_flw->aflw_usr_id;
                $posted_by            = $art_flw->aflw_posted_by;
                $stage_user_name      = array(
                    'title'       =>  (!empty($art_flw->user_title)) ? $author_titles[$art_flw->user_title] : '',
                    'first_name'  =>  $art_flw->user_first_name,
                    'middle_name' =>  $art_flw->user_middle_name,
                    'last_name'   =>  $art_flw->user_last_name,
                );
                $artflw_stage_status           = $this->get_stage_status($status_options, $stage_type, $stage_status, $user_id, $posted_by);
                
                if(!in_array($journal_work_flow_id, $jnl_flw_arr) || empty($aflw_parent_flow_id))
                {
                    (!empty($jnl_flw_arr)) ? $a++ : $a = 0;
                    $b  =   0;
                    $article_stages[$a] = new \stdClass();
                    $jnl_flw_arr[]      = $journal_work_flow_id;
                    $article_stages[$a]->stage_name   = $stage_name;
                    $article_stages[$a]->stage_type   = $stage_type;
					if($art_flw->stage_type == 'review')
						$article_stages[$a]->stage_status = '';
					else
						$article_stages[$a]->stage_status = $artflw_stage_status;
                }
                else
                {
                    $b++;
                    $jnl_flw_arr[] = $journal_work_flow_id;
                }
                $article_stages[$a]->stage_details[$b] = new \stdClass();
                $article_stages[$a]->stage_details[$b]->started_date   = $started_date;
                $article_stages[$a]->stage_details[$b]->completed_date = $completed_date;
                $article_stages[$a]->stage_details[$b]->stage_user_name= $stage_user_name;
                
				if($for_ice == FALSE)
					$article_stages[$a]->stage_details[$b]->forms = $this->get_form_details($journal_code, $version_id, $article_flw_id, $art_upld_path);
				else
				{
					$article_stages[$a]->stage_details[$b]->article_code    = $art_code;
					$article_stages[$a]->stage_details[$b]->stage_name      = $stage_name;
					$article_stages[$a]->stage_details[$b]->stage_type      = $stage_type;
					$article_stages[$a]->stage_details[$b]->stage_status    = $artflw_stage_status;
					$article_stages[$a]->stage_details[$b]->stage_user_role = $art_flw->role_name;
					if($stage_type == 'review')
					{
                        $reviewer_rating = $Users::user_review_rating($user_id, NULL)->rating;
						$article_stages[$a]->stage_details[$b]->reviewer_rating = (!empty($reviewer_rating))?$reviewer_rating:'';
					}
					else
						$article_stages[$a]->stage_details[$b]->reviewer_rating = '';
				}
                //structure for article stage flow -ends
                /*
                 * only for gigadb response
                 * retriving details of the child stages
                 */
                if(!empty($approved_stages) && $stage_status != 'c' && $stage_status != 'p')
                {
                    $symbls = array('(','\'',')');
                    $aprd_stg = str_replace($symbls,'',$approved_stages);
                    $aprd_stg = explode(',',$aprd_stg);
                    if(in_array($stage_type,$aprd_stg))
                    {
                        $next_stages    =   new \stdClass();
                        $next_stages    =   $this->get_next_stages($journal_work_flow_id, $fwm_id, $version_id);
                        $nxt_stgs       =   $next_stages['stages'];
                        if($nxt_stgs != NULL)
                        {
                            foreach($nxt_stgs as $each_nxt_stg)
                            {
                                $child_stage_details[] = array(
                                    'stage_name'     => $each_nxt_stg['stage_name'],
                                    'stage_type'     => $each_nxt_stg['stage_type']
                                );
                            }
                        }
                    }
                }
            }
        }
        //fetching article_stages - ends
        $return_data   =   array(
            'article_details'   =>  $article_details,
            'author_details'    =>  $author_details,
            'article_stages'    =>  $article_stages
        );
        if(!empty($child_stage_details))
        {
             $return_data['possible_child_stages']      =  $child_stage_details;
        }
        return $return_data;
    }

    public function get_form_details($journal_code, $version_id, $article_flow_id, $art_upld_path)
    {
        //initializing
        $h = 0;
        $i = 0;
        $j = 0;
        $form_details  = array();
        $file_details  = array();
        $form_output   = array();
        $all_forms     = array();
        $prev_form_id  = array();
        $prev_group_id = array();
        $form          = array();

        $Gen_frm_data   =   (new \App\Models\Article_generic_form_data()); 
        $gen_frm_dt_tbl =   $Gen_frm_data->getTable().'_'.$journal_code;
        $Gen_frm_elmts  =   (new \App\Models\Generic_form_elements());
        $gen_frm_el_tbl =   $Gen_frm_elmts->getTable();

        /*
         * form structure starts
         * retriving article flow data of each stage
         */
        $fields = 'gdata_atf_id, gdata_gform_title AS f_title, gdata_gfg_id, gdata_group_name AS g_title, gdata_unique_identifier AS unique_id,  emt_element_type AS type, gdata_label AS e_title, gdata_data';
        $join_tables = array(
            'main_table' => $gen_frm_dt_tbl,
            'join_table' => array(
                $gen_frm_el_tbl => array($gen_frm_el_tbl . '.emt_id', $gen_frm_dt_tbl . '.gdata_atfemt_id'),
            )
        );
        $criteria = 'gdata_art_id = '.$version_id.' and gdata_artflw_id = '.$article_flow_id.'';
        // DB::enableQueryLog();    
        $form_details = $Gen_frm_data::get_results_using_joins($join_tables, $fields, $criteria, 'all', 'gdata_atf_id,gdata_data_order', '');
        // $query = DB::getQueryLog();
        // dd(end($query));

        //form structure starts
        if(isset($form_details) && !empty($form_details))
        {
            foreach ($form_details as $frm_det)
            {
                /*
                 * initally $prev_form_id array doesnot have any form_id so enters the if statement at the first time
                 * first array of every form data goes throught the if statment and all the remaining elements of the same form goes through the else statement
                 * When all the elements of the first form data iterates,then current form is put into the $all_forms array, so that next form can be created
                 */
                if (!in_array($frm_det->gdata_atf_id, $prev_form_id))
                {
                    //initializing form
                    $h += !empty($prev_form_id) ? 1 : 0 ;
                    $i = 0;
                    $form[$h] = new \stdClass();
                    $prev_form_id[]  = $frm_det->gdata_atf_id;
                    $form[$h]->title = $frm_det->f_title;
                    $form[$h]->groups[$i]        = new \stdClass();
                    $form[$h]->groups[$i]->title = $frm_det->g_title;
                    //like the form group also checked
                    if (!in_array($frm_det->gdata_gfg_id, $prev_group_id))
                    {
                        $j = 0;
                    }
                }
                else
                {
                    if (!in_array($frm_det->gdata_gfg_id, $prev_group_id))
                    {
                        $i++;
                        $j = 0;
                    }
                    else
                    {
                        $j++;
                    }
                }
                if(isset($form[$h]->groups[$i])){
                $form[$h]->groups[$i]->elements[$j] = new \stdClass();
                $prev_group_id[] = $frm_det->gdata_gfg_id;
                $form[$h]->groups[$i]->title = $frm_det->g_title;
                $form[$h]->groups[$i]->elements[$j] = $this->get_group_elements($frm_det, $art_upld_path, $version_id);
                }
            }
        }
        return $form;
    }

    public function get_group_elements($frm_det,$art_upld_path, $version_id)
    {
        //geting the elements of the corresponding group
        $frm_det->title = $frm_det->e_title;
        $gdata          = $frm_det->gdata_data;

        $Generic_form_files =   new \App\Models\Generic_form_files;
        if(is_array(json_decode($gdata)))
        {
            $elemt_value = array();
            $file_ids = ($gdata != "") ? join(",", array_filter(json_decode($gdata))) : '';
            $file_details = $Generic_form_files::get_all_records('agf_name', 'agf_id in (' . $file_ids . ')');
            foreach($file_details as $value)
            {
                $arr = array('article_id' => $version_id, 'file_name' => $value->agf_name);
                $json = json_encode($arr);
                $elemt_value[]  =  url('/') .'/api/download-documents?payload='.Rv_encrypt($json);
            }
            $frm_det->value = $elemt_value;
        }
        else
        {
            $frm_det->value     = $gdata;
        }
        unset($frm_det->gdata_atf_id);
        unset($frm_det->f_title);
        unset($frm_det->gdata_gfg_id);
        unset($frm_det->g_title);
        unset($frm_det->e_title);
        unset($frm_det->gdata_data);
        return $frm_det;
    }

    public function get_stage_status($status_options, $stage_type, $stage_status, $user_id, $posted_by)
    {
        /*
         * conditions for the article flow status
         *  -stage type is 'review' and status is not 'c'/submitted then
         *      -check weather article flow user id and article flow posted by are not same
         *          -then status 'g' becomes 'Auto unassigned' and status 'd' becomes 'Auto Decline'
         *          -else status 'g' becomes 'Assigned' and status 'd' becomes 'Decline'
         *      -else follow the same as in func. invitation_status().
         *  -else other stages 'a' is 'active' and 'h' is 'Review Reopened'
        */
        $art_flw_stage_status = NULL;
        if($status_options != NULL && $stage_type != NULL && $stage_status != NULL)
        {
            if($stage_type == 'review' && $stage_status != 'c')
            {
                if($user_id != $posted_by)
                {
                    if($stage_status == 'g')
                    {
                       $art_flw_stage_status = 'Auto Unssigned';
                    }
                    else if($stage_status == 'd')
                    {
                       $art_flw_stage_status = 'Auto Decline';
                    }
                    else
                    {
                        $art_flw_stage_status = $status_options[$stage_status];
                    }
                }
                else
                {
                    $art_flw_stage_status = $status_options[$stage_status];
                }
            }
            else
            {
                if($stage_status == 'a')
                {
                    $art_flw_stage_status = 'active';
                }
                elseif($stage_status == 'h')
                {
                    $art_flw_stage_status = 'Review Reopened';
                }
                elseif($stage_status == 'c')
                {
                    $art_flw_stage_status = 'completed';
                }
               else
                {
                    $art_flw_stage_status = $status_options[$stage_status];
                }
            }
        }
        return $art_flw_stage_status;
    }

    public function get_author_details($version_id,$author_titles,$for_ice=FALSE,$aff = 'y')
    {
        $Authors        =   (new \App\Models\Authors());
        $Authors_affi   =   (new \App\Models\Authors_affiliation());
        $Country        =   (new \App\Models\Country());
        $Users          =   (new \App\Models\User());

        $author_tbl     =   $Authors->getTable();
        $aff_tbl        =   $Authors_affi->getTable();
        $country_tbl    =   $Country->getTable();
        $users_tbl      =   $Users->getTable();

        $author_details = '';
        if($version_id != NULL)
        {
            $select     =   'usr_title as title, usr_first_name as first_name, usr_last_name as last_name, usr_email as email, (SELECT CASE WHEN auth_corr_author = \'y\' THEN \'true\' WHEN auth_corr_author = \'n\' THEN \'false\' END) as corresponding_author, CONCAT_WS((SELECT CASE WHEN auaff_address_line2 != \'\' THEN \', \' WHEN auaff_address_line2  = \'\' THEN \'\' END), auaff_address_line1, auaff_address_line2) as address, cnt_country as country';
            $criteria   =   'auaff_prime_affiliation = "'.$aff.'" and auth_art_id = '.$version_id.'';
            if($for_ice == TRUE)
                $criteria   .=   ' and auth_corr_author = "y"';

            $join_tables = array(
                'main_table' => $author_tbl,
                'join_table' => array(
                    $aff_tbl => array($aff_tbl . '.auaff_auth_id', $author_tbl . '.auth_id', "LEFT"),
                    $country_tbl => array($country_tbl . '.cnt_id', $aff_tbl . '.auaff_cnt_id', "LEFT"),
                    $users_tbl => array($users_tbl . '.usr_id', $author_tbl . '.auth_usr_id', "LEFT")
                )
            );  
            $author_details = $Authors::get_results_using_joins($join_tables, $select, $criteria, 'all');
            foreach ($author_details as $auth_det)
            {
                //formatting author title
				if(!empty($auth_det->title))
					$auth_det->title = $author_titles[$auth_det->title];
            }
            return $author_details;
        }
        return NULL;
    }

    public function get_article_page_extend_details($art_id, $for_ice)
    {
        //fetching article details--starts
        $article_details = $this->get_article_details($art_id, $for_ice);
        if($article_details != NULL)
        {
            //removing unnecessary fields from the response
            unset($article_details->artp_id);
            unset($article_details->journal_id);
            unset($article_details->artp_fwm_id);
            unset($article_details->journal_code);
            unset($article_details->art_article_upload_path);
			unset($article_details->art_status);
			unset($article_details->art_decision_date);
			unset($article_details->abstract);
			unset($article_details->revised_count);
			unset($article_details->original_submission_date);
			unset($article_details->editorial_status);
			unset($article_details->editorial_status_date);
			unset($article_details->publication_charges_status);
			unset($article_details->publication_date);
        }
        //fetching article details--ends
        
		return $article_details;
		
    }

    public function get_article_details($art_id, $for_ice=FALSE)
    {
        $article_details = '';
        
        if($art_id != NULL)
        {
            $Articles       =   (new \App\Models\Articles());
            $Users          =   (new \App\Models\User());
            $Article_types  =   (new \App\Models\Article_types());
            $Journals       =   (new \App\Models\Journals());
            $Payment_order  =   (new \App\Models\Payment_order()); 
            $Article_flow   =   (new \App\Models\Article_flow()); 
            $Generic_flows  =   (new \App\Models\Generic_flows()); 
            $Gen_frm_data   =   (new \App\Models\Article_generic_form_data()); 
            $Issue_mngt     =   (new \App\Models\Issue_management()); 

            $articles_table     =   $Articles->getTable();
            $users_table        =   $Users->getTable();
            $article_type_table =   $Article_types->getTable();
            $journals_table     =   $Journals->getTable();
            $aflw_table         =   $Article_flow->getTable();
            $gen_flw_table      =   $Generic_flows->getTable();

            $select     =   'artp_fwm_id,jnl_id as journal_id, jnl_journal_code as journal_code, art_code as code, art_title as title, art_status, art_decision_date, art_abstract as abstract, art_submission_date as submitted_date, art_article_upload_path';
            if($for_ice == TRUE)
            {
                $select .= ', art_version_no as revised_count';
            }
            $criteria = 'art_id = '.$art_id;

            $tables = array(
                'main_table' => $articles_table,
                'join_table' => array(
                    $users_table => array($users_table . '.usr_id', $articles_table . '.art_submitted_by', "left"),
                    $article_type_table => array($article_type_table . '.artp_id', $articles_table . '.art_artp_id', "left"),
                    $journals_table => array($journals_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "left")
                )
            );

            $article_details = $Articles::get_results_using_joins($tables, $select, $criteria, 'single');
            if(!empty($article_details))
            {
                $art_upld_path  = $article_details->art_article_upload_path;
                //striping html tags  --start
                $art_title  = str_replace(array('<p>', '</p>'), "", $article_details->title);
                $article_details->title = html_entity_decode($art_title);
                //striping html tags  --end

                //adding article attachments and pdf to the current article
                if($for_ice == FALSE)
                {
                    $attchmt_and_pdf = $this->get_attachments_and_pdf($art_id, $art_upld_path);
                    if (!empty($attchmt_and_pdf)) 
                    {
                        $article_details = (object) array_merge((array) $article_details, (array) $attchmt_and_pdf);
                    }
                }
                else
			    {
                    //getting original submittion date of current article
                    $article_details->original_submission_date = $article_details->submitted_date;
                    unset($article_details->submitted_date);

                    //getting decision status and date
                    $article_details->editorial_status = ($article_details->art_status == 'a')?  'Accepted' : 'Rejected';
                    $article_details->editorial_status_date = $article_details->art_decision_date;
				
                    //getting publication payment status
                    $payment_stat = array('cc' => 'Checkout complete', 'fn' => 'Finished', 'cl' => 'Cancelled');
                    $publication_charges_status = 'NIL';
                    $payment_data = $Payment_order::get_single_record('pmt_transaction_status', 'pmt_ord_art_id = '.$art_id.'');
                    
                    if(isset($payment_data->pmt_transaction_status))
				        $publication_charges_status=$payment_stat[strtolower($payment_data->pmt_transaction_status)];
                    
                    $article_details->publication_charges_status = $publication_charges_status;
                    //publish date
                    $sel = 'aflw_returned_date';
                    $cri = 'art_id = '.$art_id.' AND jwf_stage_type ="publish"';
                    $jn_tables = array(
                        'main_table' => $articles_table,
                        'join_table' => array(
                            $aflw_table => array($aflw_table . '.aflw_art_id', $articles_table . '.art_id', "left"),
                            $gen_flw_table => array($gen_flw_table . '.jwf_id', $aflw_table . '.aflw_jwf_id', "left"),
                    ));
                    
                    $publish_status = $Articles::get_results_using_joins($jn_tables, $sel, $cri, 'single');
                    $article_details->publication_date = 'NIL';
                    if(!empty($publish_status) > 0){
                        $article_details->publication_date = $publish_status->aflw_returned_date;
                    }
                    
                    //target_no_of_pages
                    $pages = 'NIL';                
                    $generic_form = $Gen_frm_data::get_single_record('gdata_data', 'gdata_unique_identifier = "DOCUMENT_PAGE_COUNT" and gdata_art_id = '.$art_id.' and gdata_data != ""',NULL,'_'.$article_details->journal_code, 'gdata_id DESC');
                    if(!empty($generic_form))
                        $pages = $generic_form->gdata_data;
                    else
                    {
                        $auth_pages = $this->get_attach_to_author_files($art_id,TRUE);
                        if(!empty($auth_pages))
                            $pages = ($auth_pages != 0)?$auth_pages:'NIL';
                    }
                    $issue_art_page_cnt =   $Issue_mngt::get_single_record('ism_art_page_cnt', 'ism_art_id = '.$art_id.'');
                    if(!empty($issue_art_page_cnt->ism_art_page_cnt))
                        $pages = $issue_art_page_cnt->ism_art_page_cnt;
                    $article_details->target_number_of_pages = $pages;
                }
                return $article_details;
            }
        }
        return NULL;
    }

    public function get_attach_to_author_files($art_id, $return_count=FALSE)
	{
        $Articles       =   (new \App\Models\Articles()); 
        $Article_flow   =   (new \App\Models\Article_flow()); 
        $Generic_flows  =   (new \App\Models\Generic_flows()); 
        $Afd            =   (new \App\Models\Attachment_file_description());
        $Prod_att_fls   =   (new \App\Models\Production_attachment_files());
        $Art_adv_type_opt = (new \App\Models\Article_type_advance_options());

        $articles_table     =   $Articles->getTable();
        $afd_table          =   $Afd->getTable();
        $prod_att_table     =   $Prod_att_fls->getTable();
           
        $select_cur = 'paf_id,paf_aflw_id,paf_file_name,art_article_upload_path';
		$tables = array(
            'main_table' => $prod_att_table,
            'join_table' => array(
                $articles_table => array($articles_table . '.art_id', $prod_att_table . '.paf_art_id', "left"),
                $afd_table => array($afd_table . '.afdec_id', $prod_att_table . '.paf_description_id', "left"),
        ));
        $author_desigated_files = $Article_flow::get_results_using_joins($tables, $select_cur, 'paf_art_id = '.$art_id.' and afdec_attach_to_author = "y"', 'single', 'paf_id DESC');
        
		if($return_count == FALSE)
			return $author_desigated_files;
		else
		{
			$pdf_pages = 0;
			if(!empty($author_desigated_files))
			{
				if(file_exists('uploads/'.$author_desigated_files->art_article_upload_path.'/production/'.$author_desigated_files->paf_aflw_id.'/'.$author_desigated_files->paf_file_name))
				{
					$pdf_dir    =   'var/www/html/uploads/'.$author_desigated_files->art_article_upload_path.'/production/'.$author_desigated_files->paf_aflw_id;
                    $pdfname    =   $author_desigated_files->paf_file_name;
					$pdf_pages  =   $this->count_pages($pdf_dir, $pdfname);
				}
			}
			return $pdf_pages;
		}
	}

    public function get_attachments_and_pdf($article_id,$upload_path)
    {
        $Articles           = (new \App\Models\Articles());
        $Afd                = (new \App\Models\Attachment_file_description());
        $Article_pdf        = (new \App\Models\Article_pdf());
        $Attachment_files   = (new \App\Models\Attachment_files());

        $articles_table     =   $Articles->getTable();
        $afd_table          =   $Afd->getTable();
        $art_pdf_table      =   $Article_pdf->getTable();
        $att_files_table    =   $Attachment_files->getTable();

        $attachmnts_details = array();
        $select     =   'pdf_art_attachement_order as attachment_ids, pdf_name';        
        $criteria = 'art_id = '.$article_id.' and pdf_show_status ="y"';
        
        $tables = array(
            'main_table' => $articles_table,
            'join_table' => array(
                $art_pdf_table => array($art_pdf_table . '.pdf_art_id', $articles_table . '.art_id', "left"),
            )
        );
        $attachmnts_details = $Articles::get_results_using_joins($tables, $select, $criteria, 'single', 'pdf_posted_date DESC');
        if(!empty($attachmnts_details))
        {
            $i  = 0;
            $att_file_name           = array();
            $pdf_arr = array('article_id' => $article_id, 'file_name' => $attachmnts_details->pdf_name);
            $pdf_json = json_encode($pdf_arr);
            $attachmnts_details->pdf = url('/') . '/api/download-documents?payload='.Rv_encrypt($pdf_json);
            $attmnts_ids     = $attachmnts_details->attachment_ids;
            $generated_order = join(",", array_filter(json_decode($attmnts_ids)));
            $condi           = 'atmnt_id IN ('.$generated_order.')';
            $join_att_tables = array(
                'main_table' => $att_files_table,
                'join_table' => array(
                    $afd_table => array($att_files_table.'.atmnt_label', $afd_table.'.afdec_id', 'left')
            ));
            $attachments = $Attachment_files::get_results_using_joins($join_att_tables, 'atmnt_file_name as file_name, afdec_description as file_description, atmnt_file_uploaded_date as file_uploaded_date', $condi, 'all', 'atmnt_order');
            foreach($attachments as $att)
            {
                $att_arr = array('article_id' => $article_id, 'file_name' => $att->file_name);
                $att_json = json_encode($att_arr);
                $att_file_name[$i]['file_name']         = $att->file_name;
                $att_file_name[$i]['file_path']         = url('/').'/api/download-documents?payload='.Rv_encrypt($att_json);
                $att_file_name[$i]['file_despription']  = $att->file_description;
                $att_file_name[$i]['file_uploaded_date']= $att->file_uploaded_date;
                $i++;
            }
            $attachmnts_details->attachments = $att_file_name;
            unset($attachmnts_details->pdf_name);
            unset($attachmnts_details->attachment_ids);
            return $attachmnts_details;
        }
        return FALSE;
    }

    public function check_parameters($request, $parameters)
    {
        $get_params  = $_GET;
        $request_str = '';
        foreach($parameters as $params)
        {
            if(!array_key_exists($params,$get_params) || empty($get_params[$params]))
            {
                return FALSE;
            }
            $request_str .= "\r\n ".$params." = ".$get_params[$params]." ";
        }
        //Manage request log entry
        $this->log_this_api_entry($request,"Request::".$request_str);/*TASK #4666 Api_log_task */
        return TRUE;
    }

public function send_es_data(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_flow_id' => 'required',
                'article_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id =Rv_decrypt($post_data['article_id']);
            $core_role =isset($post_data['core_role']) ?  $post_data['core_role'] : ''; 
            $input_arr = array(
                'input' => $article_id,
                'type'=> 'number'
            );
            $article_id_validate = $this->Rv_validator($input_arr);

            $article_flow_id =Rv_decrypt($post_data['art_flow_id']);
            $input_arr = array(
                'input' =>$article_flow_id,
                'type'=> 'number'
            );
            $article_flow_validate = $this->Rv_validator($input_arr);
        
            if($article_id_validate != TRUE || $article_flow_validate != TRUE){
                return $this->warning('Failed',422,trans('viewarticle.invalid_data'));	
            }
            $article_model = (new \App\Models\Articles());
            $article_data = $article_model::get_single_record_with_bind_cond('art_id,art_artp_id,art_title,art_abstract,art_es_document_status,art_es_document_type,art_prev_article_id,art_submitted_by,art_code,art_submission_date,art_version_no,art_pre_all_ids',array('art_id' => $article_id));
            $attchment_table = (new \App\Models\Attachment_files())->getTable();
            $description_tbl = (new \App\Models\Attachment_file_description())->getTable();
            $article_tbl = (new \App\Models\Articles())->getTable();
            $article_type_tbl = (new \App\Models\Article_types())->getTable();
            $jnl_table = (new \App\Models\Journals())->getTable();
            $attch_tbl = new \App\Models\Attachment_files();
            $generic_flw_tbl = (new \App\Models\Generic_flows())->getTable();
            $article_flow_tbl_name = (new \App\Models\Article_flow())->getTable();
            $article_flow_tbl = new \App\Models\Article_flow();
            $Attachment_file_description_tbl = (new \App\Models\Attachment_file_description());
            $role_tbl = (new \App\Models\Roles());
            $role_tbl_name = (new \App\Models\Roles())->getTable();
            $art_adv_type_opt = (new \App\Models\Article_type_advance_options())->getTable();
            $roles ='';
            if(!empty($core_role))
            {
            $roles = $role_tbl::get_single_record_with_bind_cond('role_id',array('role_assigned_role' => $core_role));  
            }
            $auth_data_arr = array();
            $Authors_tbl_name = (new \App\Models\Authors())->getTable();
            $User_tbl_name = (new \App\Models\User())->getTable();
            $join_tbls_author = array(
                'main_table' => $article_tbl,
                'join_table' => array(
                    $Authors_tbl_name => array(
                        $Authors_tbl_name.'.auth_art_id', $article_tbl.'.art_id'),
                        $User_tbl_name => array(
                            $User_tbl_name.'.usr_id', $Authors_tbl_name.'.auth_usr_id')
                )
            );
            $select = 'usr_id,usr_first_name,usr_last_name,CONCAT( IF( usr_title IS NULL OR usr_title = "", " ", CONCAT( UPPER(SUBSTR(usr_title, 1, 1)), LOWER(SUBSTR(usr_title, 2)) ) )," ", usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user_name,usr_email,auth_corr_author,auth_id';
            $wherecondition = 'art_id=' .$article_id;
            $articles_authors = $article_model::get_results_using_joins($join_tbls_author, $select, $wherecondition); 
            if(!empty($articles_authors))
            {
                $authors_key = array(); 
                foreach($articles_authors as $authors_list)
                {
                    $affiliation_table = new \App\Models\Authors_affiliation();
                    $all_affiliations = $affiliation_table::user_affiliation($authors_list->auth_id);
                    $aff_arr = [];
                    $affl_config = 'clients.' . $this->current_client->clnt_client_code;
                    $affl_config_data = Config::get($affl_config . '.aff_config')['user_affiliation_type'];
                    if(!empty($all_affiliations))
                    {
                        foreach($all_affiliations as $single_aff)
                        {
                                $inner_array = [];
                                $inner_array['department'] = $single_aff->auaff_department;
                                $inner_array['institution'] = $single_aff->auaff_company;
                                $inner_array['institution_type'] = $affl_config_data[$single_aff->auaff_type] ? $affl_config_data[$single_aff->auaff_type] : '';
                                $inner_array['state'] = $single_aff->auaff_state;
                                $inner_array['address_line_1'] = $single_aff->auaff_address_line1;
                                $inner_array['address_line_2'] = $single_aff->auaff_address_line2;
                                $inner_array['postal_code'] = $single_aff->auaff_postal_code;
                                $inner_array['phone'] = $single_aff->auaff_phone;
                                $inner_array['country'] = $single_aff->cnt_country;
                                $inner_array['primary_affiliation'] = $single_aff->auaff_prime_affiliation;
                                array_push($aff_arr,$inner_array);
                        }
                    }
                    if($authors_list->auth_corr_author=='y')
                    {
                        $auth_data_arr['user_global_id'] = Rv_encrypt($authors_list->usr_id);
                        $auth_data_arr['user_name'] = $authors_list->user_name; 
                        $auth_data_arr['usr_email'] = $authors_list->usr_email; 
                        $auth_data_arr['user_first_name'] = $authors_list->usr_first_name; 
                        $auth_data_arr['user_last_name'] = $authors_list->usr_last_name; 
                        $auth_data_arr['corresponding_author'] = 'y';   
                        $auth_data_arr['affiliations'] = $aff_arr;
                     }
                     else
                    {
                        $auth_co_author['user_global_id'] = Rv_encrypt($authors_list->usr_id);
                        $auth_co_author['user_name'] = $authors_list->user_name; 
                        $auth_co_author['usr_email'] = $authors_list->usr_email; 
                        $auth_co_author['user_first_name'] = $authors_list->usr_first_name; 
                        $auth_co_author['user_last_name'] = $authors_list->usr_last_name; 
                        $auth_co_author['corresponding_author'] = 'n'; 
                        $auth_co_author['affiliations'] = $aff_arr;
                        array_push($authors_key, $auth_co_author);
                    }
                   
                }
                $auth_data_arr['list_co_authors']= $authors_key; 

            }
           

            $join_tbls = array(
                'main_table' => $article_flow_tbl_name,
                'join_table' => array(
                    $generic_flw_tbl => array(
                        $generic_flw_tbl.'.jwf_id', $article_flow_tbl_name.'.aflw_jwf_id'
                    )
                )
            );
            $work_criteria = 'aflw_id ='.$article_flow_id;
            $get_all_workflow_details = $attch_tbl::get_results_using_joins($join_tbls, 'jwf_stage_name,jwf_stage_type,jwf_status_name,jwf_temporary_status_name,jwf_fwm_id,jwf_enable_ithenticate',$work_criteria, 'all');

            $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id'),
                                $article_tbl => array($attchment_table.'.atmnt_art_id',$article_tbl.'.art_id'),
                                $article_type_tbl => array($article_tbl.'.art_artp_id',$article_type_tbl.'.artp_id'),
                                $jnl_table => array($article_type_tbl.'.artp_jnl_id',$jnl_table.'.jnl_id'),
                                $art_adv_type_opt => array($art_adv_type_opt.'.atotp_artp_id',$article_type_tbl.'.artp_id')
                            )
                        );
            $select_fields = 'atmnt_id,atmnt_orginal_upload_path,atmnt_file_name,atmnt_send_to_es,afdec_main_document,jnl_journal_code,artp_abbr_article_type,art_es_document_status,art_es_document_type,afdec_id,atmnt_orginal_upload_path,afdec_description,atmnt_posted_by,atotp_review_method,atotp_custom_blind_params,artp_fwm_id';
            $criteria = 'atmnt_art_id=' . $article_id;
            $get_all_attach_details = $attch_tbl::get_results_using_joins($tables, $select_fields, $criteria, 'all');

            $user_data_tables = array(
                'main_table' => $article_flow_tbl_name,
                'join_table' => array(
                    $User_tbl_name => array($User_tbl_name . '.usr_id', $article_flow_tbl_name . '.aflw_usr_id'),
                    $generic_flw_tbl => array($generic_flw_tbl.'.jwf_id',$article_flow_tbl_name.'.aflw_jwf_id'),
                    $role_tbl_name => array($role_tbl_name.'.role_id',$generic_flw_tbl.'.jwf_role_id')
                )
            );
            $select_fields_user = 'usr_id as user_id,usr_first_name,usr_middle_name,usr_last_name,usr_email,role_name,role_assigned_role as core_role,jwf_role_id as role_id';
            $criteria_user = 'aflw_art_id=' . $article_id;
            $get_all_user_details = $article_flow_tbl::get_results_using_joins($user_data_tables, $select_fields_user, $criteria_user, 'all');
            $return_arr = array();
            $return_arr['document_created_at_rv_rite'] = $article_data->art_es_document_type == 'n' ? 'y' : 'n';
            $return_arr['previous_article_id'] = $article_data->art_prev_article_id;
            $return_arr['main_document'] = '';
            $return_arr['document_id'] = '';
            $return_arr['file_uploaded_by'] = '';
            $return_arr['current_stage_name'] = $get_all_workflow_details[0]->jwf_stage_name;
            $return_arr['current_stage_name_non_privillaged'] = $get_all_workflow_details[0]->jwf_temporary_status_name;
            $return_arr['current_stage_type'] = $get_all_workflow_details[0]->jwf_stage_type;
            $return_arr['art_submitted_by'] = Rv_encrypt($article_data->art_submitted_by);
            $return_arr['article_id'] = Rv_encrypt($article_data->art_id);
            $return_arr['article_code'] = Rv_encrypt($article_data->art_code);
            $return_arr['art_title'] = $article_data->art_title;
            $return_arr['art_version'] = 'R'.$article_data->art_version_no;
            $return_arr['art_abstract'] = $article_data->art_abstract;
            $return_arr['art_submission_date'] = $article_data->art_submission_date;
            $return_arr['art_authors'] = $auth_data_arr;
            $return_arr['art_authors']['hash_value'] = $this->hash_author_data($auth_data_arr);
            $return_arr['all_user_details'] = $get_all_user_details;
            $article_keywords_table = new \App\Models\Article_keywords();
            $article_type_table = new \App\Models\Article_types();
            $art_jnl = $article_type_table::get_single_record_with_bind_cond('artp_jnl_id,artp_fwm_id',array('artp_id' => $article_data->art_artp_id));
            $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $article_keywords = $article_keywords_table::get_article_keywords($article_id, FALSE, FALSE, $hierachy, $art_jnl->artp_jnl_id);
            $return_arr['art_keywords'] = [];
            $return_arr['art_classification'] = [];
            $return_arr['art_blind_method'] = isset($get_all_attach_details[0]) ? $get_all_attach_details[0]->atotp_review_method : '';
            if($this->current_client->functionality->cfty_enable_custom_blinding == 'y' && $return_arr['art_blind_method'] == 'c')
            {
                if($get_all_attach_details[0]->atotp_custom_blind_params !== null)
                {
                    $custom_blind_roles = json_decode($get_all_attach_details[0]->atotp_custom_blind_params);
                    $blind_array = array();
                    foreach($custom_blind_roles as $key => $single_roles)
                    {
                        $sub_arr = array();
                        $sub_arr['role_id'] = $key;
                        $sub_arr['blind_role_id'] = implode(',',$single_roles);
                        array_push($blind_array,$sub_arr);
                    }
                    $return_arr['art_custom_blind_roles'] = $blind_array;
                }
            }
            if(!empty($article_keywords))
            {
                $art_kwd_arr = array();
                foreach($article_keywords as $single_art_keyword)
                {
                    array_push($art_kwd_arr,$single_art_keyword->kwd_name);
                }
                $return_arr['art_keywords'] = $art_kwd_arr;
            }
            $condition ="arcls_art_id =:art_id";
            $Article_classification = new \App\Models\Article_classification();
            $classification_tbl =  new \App\Models\Classifications();

            $cls_table = (new \App\Models\Classifications())->getTable();
            $checkBoxData = $Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,NULL,'',NULL,array('art_id'=>$article_id));
            if(!empty($checkBoxData->checkData)){
                $class_id = explode(',', $checkBoxData->checkData);
                $art_class_arr = array();
                $term_table = (new \App\Models\Terms())->getTable();

                foreach($class_id as $single_class_id)
                {
                    $criteria = 'cls_id =' . $single_class_id;
                    $join_tbls =  array(
                        'main_table' => $cls_table,
                        'join_table' => array(
                            $term_table => array($term_table . '.term_id', $cls_table . '.cls_term_id')
                        )
                    );
                    $cls_dtls = $classification_tbl::get_results_using_joins($join_tbls,'term_name', $criteria, 'all');
                    array_push($art_class_arr,$cls_dtls[0]->term_name);
                }
                $return_arr['art_classification'] = $art_class_arr;
            }
            $client_code = $this->current_client->clnt_client_code;
            if(!empty($get_all_attach_details) && count($get_all_attach_details) > 0)
            {
                $other_docs = array();
                foreach($get_all_attach_details as $single_attac)
                {
                    $attach_arr = [];
                    $doc_data = $this->get_file_name_and_path($single_attac);
                    if($single_attac->afdec_main_document == 'y')
                    {
                        $return_arr['document_id'] = Rv_encrypt($single_attac->atmnt_id);
                        $return_arr['main_document'] = $doc_data['file_name'];
                        $return_arr['file_ftp_location'] = $single_attac->jnl_journal_code.'/'.$single_attac->artp_abbr_article_type.'/'.$article_id.'/'.$single_attac->atmnt_file_name;
                        $return_arr['file_uploaded_by'] = $single_attac->atmnt_posted_by;
                    }
                    else
                    {
                        if(!empty($roles))
                        {
                           if(($core_role=='author' || $core_role=='journal_admin') && $single_attac->afdec_description=='Supplementary Zip')
                           {
                                $attach_arr['file_name'] = $doc_data['file_name'];
                                $attach_arr['path'] = $doc_data['file_path'];
                                $attach_arr['sup_id'] = $single_attac->atmnt_id;
                                $attach_arr['file_description'] = $single_attac->afdec_description;
                                $attach_arr['file_posted_by'] = $single_attac->atmnt_posted_by;
                                array_push($other_docs,$attach_arr); 
                           }else
                           {
                            $afdec_id=$single_attac->afdec_id;
                            $role_id=$roles->role_id;
                            $filediscription_valid = $Attachment_file_description_tbl::get_single_record('afdec_id', 'afdec_id=' . $afdec_id . ' AND FIND_IN_SET(' . $role_id . ',afdec_viewable_roles)', '', '', 'afdec_id DESC');  
                            if(!empty($filediscription_valid))
                            {
                                $attach_arr['file_name'] = $doc_data['file_name'];
                                $attach_arr['path'] = $doc_data['file_path'];
                                $attach_arr['sup_id'] = $single_attac->atmnt_id;
                                $attach_arr['file_description'] = $single_attac->afdec_description;
                                $attach_arr['file_posted_by'] = $single_attac->atmnt_posted_by;
                                array_push($other_docs,$attach_arr); 
                            }
                        }
                        }else{
                               // array_push($other_docs,$single_attac->atmnt_file_name);
                                $attach_arr['file_name'] = $doc_data['file_name'];
                                $attach_arr['path'] = $doc_data['file_path'];
                                $attach_arr['sup_id'] = $single_attac->atmnt_id;
                                $attach_arr['file_description'] = $single_attac->afdec_description;
                                $attach_arr['file_posted_by'] = $single_attac->atmnt_posted_by;
                                array_push($other_docs,$attach_arr); 
                        }
                       
                    }
                }
                if(count($other_docs) > 0)
                {
                    $return_arr['other_documents'] = (object)$other_docs;
                }
            }
            $all_article_versions = $article_id;
            if($article_data->art_pre_all_ids !== NULL)
            {
                $all_article_versions = $article_data->art_pre_all_ids.','.$all_article_versions;
            }
            $return_arr['review_stage_details'] = $this->get_masked_reviewer_dtls($all_article_versions); 
            if(isset($post_data['user_site_token']))
            {
                $jwt_token = Rv_decrypt($post_data['user_site_token']);
                JWTAuth::setToken($jwt_token);
                $jnl_code_data = Journals::get_single_record_with_bind_cond('jnl_journal_code',array('jnl_id' => $art_jnl->artp_jnl_id));
                $article_details = (object) [
                'artp_id' =>$article_data->art_artp_id,
                'art_id' =>$article_data->art_id,
                'artp_fwm_id'=>$art_jnl->artp_fwm_id,
                'jnl_journal_code'=>$jnl_code_data->jnl_journal_code,
                'art_artp_id'=>$article_data->art_artp_id,
                ];
                $art_previlege = $this->article_privilages($article_details,NULL,$jnl_code_data->jnl_journal_code); 
                $return_arr['article_previllages'] = $art_previlege;
            }
            if($core_role == 'author')
            {
                $author_comment_subquery = DB::table($article_flow_tbl_name)
                        ->join($generic_flw_tbl, 'aflw_jwf_id', '=', 'jwf_id')
                        ->join($role_tbl_name, 'jwf_role_id', '=', 'role_id')
                        ->where('role_assigned_role', 'author')
                        ->where('aflw_art_id', $article_data->art_id)
                        ->orderByDesc('aflw_id')
                        ->limit(1)
                        ->select('aflw_id');
                $author_viewable_comment = DB::table($article_flow_tbl_name)
                    ->where('aflw_art_id', $article_data->art_id)
                    ->where('aflw_id', '<=', $author_comment_subquery)
                    ->select(DB::raw('GROUP_CONCAT(aflw_id) as flow_ids'))
                    ->first();
                $return_arr['comment_view_flows'] = $author_viewable_comment->flow_ids;
            }
            $return_arr['ithenticate_enabled'] = false;
            if($this->current_client->modules->mdl_ithenticate == 'y' && isset($post_data['active_stage']) && $post_data['active_stage'] == true)
            {
                $atyp_advanced_tbl = (new \App\Models\Article_type_advance_options());
                $get_ithenticate_settings = $atyp_advanced_tbl::get_single_record_with_bind_cond('atotp_plagiarism_checking,atotp_ithsubmission_type,atotp_ithauto_submissions',array('atotp_artp_id' => $article_data->art_artp_id));
                if($get_ithenticate_settings->atotp_plagiarism_checking == 'y' && $get_ithenticate_settings->atotp_ithsubmission_type == 'auto' && in_array($get_all_workflow_details[0]->jwf_stage_type, json_decode($get_ithenticate_settings->atotp_ithauto_submissions)))
                { 
                    $return_arr['ithenticate_enabled'] = true;
                }
                if($get_ithenticate_settings->atotp_plagiarism_checking == 'y' && $get_ithenticate_settings->atotp_ithsubmission_type == 'manual' && $get_all_workflow_details[0]->jwf_enable_ithenticate == 'y')
                {
                    $return_arr['ithenticate_enabled'] = true;
                }
            }
            
            return response()->json($return_arr);
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function change_article_doc_status(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = $post_data['article_id'];

            $input_arr = array(
                'input' => $article_id,
                'type'=> 'number'
            );
            $article_id_validate = $this->Rv_validator($input_arr);
            /*if($article_id_validate != TRUE)
            {
                return $this->warning('Failed',422,trans('viewarticle.invalid_data'));	
            }*/
            $return_arr = array();
            $return_arr['status'] = 'failed';
            $return_arr['status_code'] = 401;
            $article_model = (new \App\Models\Articles());
            $article_data = $article_model::get_single_record_with_bind_cond('art_id,art_es_document_status,art_es_document_type,art_prev_article_id',array('art_id' => $article_id));
            if(!empty($article_data) && $article_data->art_es_document_type !== 'u')
            {
                $return_arr['status'] = 'success';
                $return_arr['status_code'] = 200;
                $return_arr['message'] = 'Data successfully recorded';
                $update_arr = array('art_es_document_status' => 'y','art_es_document_type' => 'n');
                $update_condition = array('art_id' => $article_id);
                $update_record = $article_model::update_record($update_arr,$update_condition);
            }
            else
            {
                $return_arr['message'] = 'Article not found';
            }
            $this->log_incoming_request($request,$return_arr);
            return response()->json($return_arr);
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_admin_data(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'pseudo' => 'required',
                'identity' => 'required'
            ]);

            if($validator->fails()) 
            {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $user_id = Rv_decrypt($post_data['user_id']);
            $sudo_user = $post_data['pseudo'];
            $Users = new \App\Models\User();
            $Roles = new \App\Models\Roles();
            $get_user_data = $Users::get_single_record_with_bind_cond('CONCAT(usr_first_name,usr_middle_name,usr_last_name) as user_name,usr_first_name as user_first_name,usr_middle_name as user_middle_name,usr_last_name as user_last_name,usr_email as user_email,usr_id as user_id,usr_roles',array('usr_id' => $user_id));
            $return_arr = array();
            $return_arr['status'] = 'failed';
            $return_arr['status_code'] = 401;
            
            if(!empty($get_user_data))
            {
                $sudo_user = FALSE;
                $return_arr = array();
                $return_arr["sudo"] = FALSE;
                $return_arr["user_role"] = Rv_decrypt($post_data['identity']);
                if($get_user_data->usr_roles !== NULL)
                {
                    $roles = json_decode($get_user_data->usr_roles);
                    if(in_array('sudo',$roles))
                    {
                        $sudo_user = TRUE;
                        $return_arr["sudo"] = TRUE;
                    }
                }
                
                $return_arr['user_name'] =  $get_user_data->user_name;
                $return_arr['user_first_name'] =  $get_user_data->user_first_name;
                $return_arr['user_middle_name'] =  $get_user_data->user_middle_name;
                $return_arr['user_last_name'] = $get_user_data->user_last_name;
                $return_arr["user_email"] = $get_user_data->user_email;
                $return_arr["user_id"] = Rv_encrypt($get_user_data->user_id);
                if($sudo_user == TRUE)
                {
                    $role_list = $Roles::get_all_records_with_bind_cond('role_id,role_name,role_assigned_role',array(),'role_assigned_role != "system"');
                    $return_arr['all_roles'] = $role_list;
                }
            }
            return response()->json($return_arr);

        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function create_new_es_doc(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($post_data, [
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = $post_data['art_id'];
            //$article_id = $this->decrypt_data($art_id);
            $return_arr = array('status' => 'failed'); 
            //$current_user = $this->get_current_user_details();
            $update_arr = array('art_es_document_type' => 'n');
            $articles_table = new \App\Models\Articles();
            $update_record = $articles_table::update_record($update_arr,array('art_id' => $article_id));
            if($update_record)
            {
                $return_arr['status'] = 'success';
                $return_arr['status_code'] = 200;
            }
            else
            {
                $return_arr['status'] = 'failed';
                $return_arr['status_code'] = 400;
            }
            return response()->json($return_arr);
        }
        catch(\Exeception $e)
        {
            $return_arr = array();
            $return_arr['status'] = 'error';
            $return_arr['status_code'] = 500;
            return response()->json($return_arr);
        }
    }

    public function send_workflow_details(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
            ]);
            if($validator->fails()) 
            {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $return_arr = array('status' => 'failed');
            $jnl_id = $post_data['jnl_id'];
            $Article_type = new \App\Models\Article_types();
            $Article_type_tbl = (new \App\Models\Article_types())->getTable();
            $workflow_tbl = (new \App\Models\Generic_flows())->getTable();
            $roles_tbl = (new \App\Models\Roles())->getTable();
            $journals = new \App\Models\Journals();
            $journal_tbl = (new \App\Models\Journals())->getTable();
            $tables = array(
                'main_table' => $journal_tbl,
                'join_table' => array($workflow_tbl => array($workflow_tbl. '.jwf_fwm_id',$journal_tbl . '.jnl_fwm_id'),
                                        $roles_tbl => array($roles_tbl.'.role_id',$workflow_tbl.'.jwf_role_id')
            ));
            $select = 'jnl_id as journal_id,jnl_journal_name as journal_name,jwf_stage_name as stage_name,jwf_stage_type as stage_type,role_name as stage_role_name,role_assigned_role as stage_core_role';
            $criteria = array('jnl_id' => $jnl_id);
            $return_data = $journals::get_results_using_joins($tables,$select,$criteria,'all');
            if(!empty($return_data))
            {
                $return_arr['status'] = 'success';
                $return_arr['data'] = $return_data;
            }
            $this->log_incoming_request($request,$return_arr);
            return response()->json($return_arr);

        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_review_history($article_doi, $api_client_details, $approved_stages = NULL){
        $author_titles = $this->UserConfigdata('titles')['titles'];
        $status_options  = invitation_status();
        //initializing
        $version_details        = array();
        $article_type_name      = '';
        $prev_version_ids       = NULL;
        $pre_version_details    = array();
        $curnt_version_details  = '';  
        $Articles       = (new \App\Models\Articles());
        $Article_types  = (new \App\Models\Article_types());
        $Journals       = (new \App\Models\Journals());
        $articles_table     =   $Articles->getTable();
        $article_type_table =   $Article_types->getTable();
        $journals_table     =   $Journals->getTable();  
        $select     =   "art_id,art_status,jnl_id,jnl_journal_code as journal_code, jnl_journal_name as journal_name, art_doi as article_doi, artp_article_type as submitted_article_type, art_published_article_type as published_article_type_id, art_pre_all_ids as all_prev_ids,art_transfer_article";
        $criteria   =   'art_doi = "'.$article_doi.'"';
        $tables = array(
            'main_table' => $articles_table,
            'join_table' => array(
                $article_type_table => array($article_type_table . '.artp_id', $articles_table . '.art_artp_id', "left"),
                $journals_table => array($journals_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "left")
            )
        );
        // DB::enableQueryLog();    
        $journal_details = $Articles::get_results_using_joins($tables, $select, $criteria, 'single', 'art_id DESC');
        /*
         * checking whether the api_client have the permission to view the article review history under the specified journal
         * if $api_client_details['journals'] is null, then the api_client has permission to view all the journal,
         * otherwise, specify the journal in the api_client UI.
         */
        $authorized_client_jnl_id   = array_filter(explode(',',$api_client_details['journals']));
        $journal_id                 = $journal_details->jnl_id;
        if(!empty($authorized_client_jnl_id) && !in_array($journal_id , $authorized_client_jnl_id) )
        {
            return FALSE;
        }
        if($journal_details->art_status != 'a')
        {
            $return_status = array(
                'msg' => 'Decision pending..',
                'status' => 'failed'
            );
            return $return_status;
        }
        /*
         * Retriving published article type
         * have to show only to the review history api call
         * dont want in gigadb api call
         * $approved_stages isset only in a gigadb api call
         */
        if($approved_stages == NULL)
        {
            $article_type_name = $Article_types::get_single_record('artp_article_type as published_article_type','artp_id ='.$journal_details->published_article_type_id );
            if(!empty($article_type_name))
            {
                $journal_details->published_article_type = $article_type_name->published_article_type;
            }
            else
            {
                $journal_details->published_article_type = "";
            }
        }
        
         //checking for resubmissions
         if(!empty($journal_details->art_transfer_article) && $journal_details->art_transfer_article == 'n')
         {
             $prev_version_ids = array_filter( explode(',',$journal_details->all_prev_ids) );
         }
         $curnt_version_id     = $journal_details->art_id;
         //removing non-essential data from the response
         unset($journal_details->published_article_type_id);
         unset($journal_details->art_transfer_article);
         unset($journal_details->all_prev_ids);
         unset($journal_details->art_status);
         unset($journal_details->art_id);
         unset($journal_details->jnl_id);
         /*
         * get current version and the previous version,if any
         * resubmitted articles
         */

        if($prev_version_ids != NULL)
        {
            foreach ($prev_version_ids as $prev_version_id)
            {
                $pre_version_details[]  = $this->get_article_version($prev_version_id,$approved_stages,$status_options,$author_titles);
            }
        }   
        $curnt_version_details          = $this->get_article_version($curnt_version_id,$approved_stages,$status_options,$author_titles);
        $journal_details->previous_versions = $pre_version_details;
        $journal_details->current_version   = $curnt_version_details;
        return $journal_details;
    }
    
    public function get_masked_reviewer_dtls($article_ids)
    {
        $article_ids = explode(',',$article_ids);
        $versions_arr = array();
        $article_flow_tbl_name = (new \App\Models\Article_flow())->getTable();
        $article_tbl = (new \App\Models\Articles())->getTable();
        $generic_flw_tbl = (new \App\Models\Generic_flows())->getTable();
        $User_tbl_name = (new \App\Models\User())->getTable();
        $article_flow_tbl = new \App\Models\Article_flow();
        $roles_tbl_name = (new \App\Models\Roles())->getTable();

        foreach($article_ids as $single_key => $single_value)
        {
            $review_stages_condition =  array('aflw_status' => 'c','jwf_stage_type' => 'review','aflw_art_id' => $single_value);
            $tables = array(
                'main_table' => $article_flow_tbl_name,
                'join_table' => array($article_tbl => array($article_tbl. '.art_id',$article_flow_tbl_name . '.aflw_art_id'),
                                        $generic_flw_tbl => array($generic_flw_tbl.'.jwf_id',$article_flow_tbl_name.'.aflw_jwf_id'),
                                        $User_tbl_name => array($User_tbl_name.'.usr_id',$article_flow_tbl_name.'.aflw_usr_id'),
                                        $roles_tbl_name => array($roles_tbl_name.'.role_id',$generic_flw_tbl.'.jwf_role_id'))
            );
            $select = 'jwf_stage_name,aflw_id,aflw_returned_date,jwf_id,aflw_parent_flow_id,CONCAT(usr_first_name,\' \',usr_last_name) as user_name,usr_email,usr_id,role_name';
            $review_stages = $article_flow_tbl::get_results_using_joins($tables,$select,$review_stages_condition,'all','jwf_id ASC,aflw_returned_date ASC',NULL,'',NULL,NULL,FALSE);
            $parent_flow_ids = array();
            $passed_journal_workflows = array();
            $i = 0;
            if(count($review_stages) > 0)
            {
                foreach($review_stages as $single_stages)
                {
                    if(array_key_exists($single_stages->jwf_id, $passed_journal_workflows) && !in_array($single_stages->aflw_parent_flow_id,$parent_flow_ids)) 
                    {
                        $new_key_val = $passed_journal_workflows[$single_stages->jwf_id] + 1;
                        $passed_journal_workflows[$single_stages->jwf_id] = $new_key_val;
                    }
                    if(!array_key_exists($single_stages->jwf_id, $passed_journal_workflows))
                    {
                        $passed_journal_workflows[$single_stages->jwf_id] = 0;
                    }
                    if($passed_journal_workflows[$single_stages->jwf_id] > 0)
                    {
                        $single_stages->jwf_stage_name = $single_stages->jwf_stage_name.' #'.$passed_journal_workflows[$single_stages->jwf_id];
                    }
                    if(!in_array($single_stages->aflw_parent_flow_id,$parent_flow_ids))
                    {
                        array_push($parent_flow_ids,$single_stages->aflw_parent_flow_id);
                        $i = 1;
                    }
                    $single_stages->masked_name = $single_stages->role_name.' #'.$i;
                    $i++;
                }
            }
            $versions_arr['R'.$single_key] = $review_stages;
        }
        return $versions_arr;
    }

    public function get_parent_stages_for_report($art_id,$current_stage,$tbk_tbl = FALSE)
    {
        $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement;
        $all_possible_aflw_id   =   Article_flow::get_single_record("GROUP_CONCAT(aflw_id) as flows", "aflw_art_id =".$art_id);
        $parallel_flow_condi    =   " apfm_end_stg_jwf_id = ".$current_stage->aflw_jwf_id." AND apfm_aflw_id IN(".$all_possible_aflw_id->flows.")";
         $parallel_flows         =   $Article_parallel_flow_movement::get_all_records("apfm_id,apfm_travel_path_ids", $parallel_flow_condi);
        $parallel_workflow_set  = FALSE;
        $para_mov_arr           = array();
        if(!$parallel_flows->isEmpty()) {
            $parallel_workflow_set = TRUE;
            foreach($parallel_flows as $single_paralel_flow)
            {
                $flow_arr = explode(',',$single_paralel_flow->apfm_travel_path_ids);
                array_push($para_mov_arr, end($flow_arr));
            }
        }
        $select     = 'aflw_id, aflw_status, jwf_stage_type, jwf_parent_stages, jwf_assignment,aflw_jwf_id,aflw_usr_id,jwf_role_id,jwf_id,jwf_fwm_id,aflw_level';
        $where      = 'aflw_id ='.$current_stage->aflw_id;
        $crnt_stage = Article_flow::get_generic_flow($select, $where,NULL,NULL,FALSE,FALSE ,array(),$tbk_tbl);
        $crnt_stage = $crnt_stage[0];
        $enabled_parent_stages  =   $this->get_enabled_parent($crnt_stage->aflw_jwf_id, $crnt_stage->jwf_parent_stages);
        $parent_stage_ids       =  array();
        foreach ($enabled_parent_stages as $parent)
        {
            if ($parent->jwf_disable_status == 'n')
                $parent_stage_ids[] = $parent->jwf_id;
        } 

        if($parallel_workflow_set == TRUE)
        {
            $parent_stage_ids = $para_mov_arr;
        }
        $article_flow_table = (new \App\Models\Article_flow())->getTable();

        $select =   'aflw_id, aflw_level, aflw_status, jwf_stage_type,jwf_stage_name, jwf_child_stages, jwf_assignment,jwf_role_id, aflw_skip_review, jwf_flow_proceed_type, jwf_id, jwf_fwm_id';
        $where  =  "aflw_art_id ={$art_id} AND aflw_id < {$current_stage->aflw_id} AND aflw_parent_flow_id IS NULL AND aflw_level = ".$crnt_stage->aflw_level - 1;
        $where_in =   NULL;
        if(!empty($parent_stage_ids))
        {
            $stgFlg =   0;
            // check the parent stg exists in the article flow table
            foreach ($parent_stage_ids as $par_stg)
            {
                $this_stg_exits     =   Article_flow::get_single_record('count(`aflw_id`) as cnt', "aflw_art_id ={$art_id} AND aflw_jwf_id = {$par_stg}");
                if($this_stg_exits->cnt != 0) {
                    $stgFlg++;
                }
            }
            if($stgFlg == 0) 
            {
                $prev_stg_lvl   =   $crnt_stage->aflw_level - 1;
                $prev_stg_flw     =   Article_flow::get_single_record('aflw_jwf_id', "aflw_art_id ={$art_id} AND aflw_level = {$prev_stg_lvl}");
                if(isset($prev_stg_flw)) 
                {
                    unset($parent_stage_ids);
                    $parent_stage_ids[]   =  $prev_stg_flw->aflw_jwf_id;
                } 
            }
            $where_in['aflw_jwf_id']   =   $parent_stage_ids;
        }

        $parent_stages  =   Generic_flows::get_artcle_flow($select, $where, $where_in, 'aflw_level DESC, aflw_id ASC');
        $revised_parent_name = '';
        if($parent_stages->isEmpty())
        {
            $current_stage_type = Generic_flows::get_single_record_with_bind_cond('jwf_stage_type',array('jwf_id' => $current_stage->aflw_jwf_id));
            if($current_stage_type->jwf_stage_type == 'resubmission')
            {
                $Articles       = (new \App\Models\Articles());
                $art_previous_id = $Articles::get_single_record_with_bind_cond('art_prev_article_id',array('art_id' => $current_stage->art_id));
                if(!empty($art_previous_id))
                {
                    $new_revision_parent = Generic_flows::get_records_by_raw_query('SELECT jwf_stage_name from rvw_journal_workflows INNER JOIN rvw_article_flow ON aflw_jwf_id = jwf_id where aflw_art_id ='.$art_previous_id->art_prev_article_id.' ORDER BY aflw_id DESC LIMIT 1');
                    if(!empty($new_revision_parent))
                    {
                        $revised_parent_name = $new_revision_parent[0]->jwf_stage_name;
                    }
                }
            }
        }
        if($parent_stages->isNotEmpty())
        {
            $select     =   'aflw_id, aflw_level, aflw_status, jwf_stage_type, jwf_child_stages, jwf_assignment,jwf_role_id, aflw_skip_review, jwf_flow_proceed_type, jwf_id, jwf_fwm_id'; 
            $where      =   "aflw_art_id = {$art_id}";
            $where_in   =   array();
            
            $parent_stage_ids = array();
            foreach ($enabled_parent_stages as $parent)
            {
                if ($parent->jwf_disable_status == 'n')
                {
                    $parent_stage_ids[] = $parent->jwf_id;
                }
            } 
            $where_in['aflw_jwf_id']= $parent_stage_ids;
            $parent_stages_advanced = Generic_flows::get_artcle_flow($select, $where, $where_in, 'aflw_level DESC, aflw_id DESC');	
            $advanced_flow = FALSE;
            if(!$parent_stages_advanced->isEmpty()) {
                $all_possi_aflw_id  = Article_flow::get_single_record("GROUP_CONCAT(aflw_id) as flows", "aflw_art_id = ".$art_id);
                $paral_flow_condi   = "apfm_end_stg_jwf_id = ".$crnt_stage->aflw_jwf_id." AND apfm_aflw_id IN(".$all_possi_aflw_id->flows.")";
                $parallel_flows = $Article_parallel_flow_movement::get_all_records("apfm_id", $paral_flow_condi);
                if(!$parallel_flows->isEmpty()) {
                    foreach($parallel_flows as $single_parallel_flows)
                    {
                        $advanced_flow = TRUE;
                    }
                }
            }
            $temp_arr = [];
            $all_stages = [];
            $stages_names = '';
            foreach ($parent_stages as $stg)
            {
                // only considering parent stages with same level
                if($stg->aflw_level != $parent_stages[0]->aflw_level && $advanced_flow == FALSE)
                {
                    break;
                }

                $temp_arr['stage_name'] = $stg->jwf_stage_name;
                $temp_arr['stage_type'] = $stg->jwf_stage_type;
                array_push($all_stages,$temp_arr);
                if($stages_names !== '')
                {
                    $stages_names = $stages_names.','.$stg->jwf_stage_name;
                }
                else
                {
                    $stages_names = $stg->jwf_stage_name;  
                }
            }
            $parent_stages = $stages_names;
        }
        else if($revised_parent_name !== '')
        {
            $parent_stages = $revised_parent_name;
        }
        return $parent_stages;
}

public function transfered_article_check($article_data)
{
    $transfer_stage = Article_flow::get_records_by_raw_query('SELECT aflw_id from rvw_article_flow INNER JOIN rvw_journal_workflows ON aflw_jwf_id = jwf_id WHERE jwf_stage_type = \'transit\' AND aflw_art_id ='.$article_data->art_id);
    $return_arr = [];
    $return_arr['status'] = FALSE;
    $deleted_stages = [];
    if(count($transfer_stage) > 0)
    {
        $get_deleted_status = Article_flow::get_records_by_raw_query('SELECT aflw_id FROM tbk_article_flow WHERE aflw_operation =\'d\' AND aflw_art_id ='.$article_data->art_id);
        if(!empty($get_deleted_status))
        {
            foreach($get_deleted_status as $single_row)
            {
                $new_arr = [];
                $check_active_status = Article_flow::get_records_by_raw_query('SELECT * FROM tbk_article_flow WHERE aflw_id='.$single_row->aflw_id.' ORDER BY tbk_id desc LIMIT 1');
                if($check_active_status[0]->aflw_status == 'u')
                {
                    $new_arr = $article_data;
                    $new_arr->user_title = '';
                    $new_arr->user_first_name = '';
                    $new_arr->user_last_name = '';
                    $new_arr->email = '';
                    $new_arr->orcid = '';
                    $new_arr->user_id_number = '';
                    $new_arr->affiliation = '';
                    //$new_arr->user_country = '';
                    $new_arr->user_state_or_region = '';
                    $new_arr->invited_date = NULL;
                    $new_arr->task_accepted_date = $check_active_status[0]->aflw_assigned_date;
                    $new_arr->task_rejected_date = NULL;
                    $new_arr->task_completed_date = NULL;
                    $new_arr->uninvited_unassigned_date = NULL;
                    $new_arr->date_of_first_decision = NULL;
                    $new_arr->date_of_final_decision = NULL;
                    $new_arr->uninvited_unassigned_date = $check_active_status[0]->aflw_posted_date;
                    $new_arr->country = NULL;
                    $new_arr->aflw_id = $check_active_status[0]->aflw_id;
                    $new_arr->current_status = 'closed';
                    $new_arr->parent_node = $this->get_parent_stages_for_report($new_arr->art_id,$new_arr,TRUE);
                    $stage_dtls = Article_flow::get_records_by_raw_query('SELECT jwf_stage_name,role_name from tbk_article_flow INNER JOIN rvw_journal_workflows ON aflw_jwf_id = jwf_id INNER JOIN rvw_roles ON jwf_role_id = role_id WHERE aflw_id = '.$check_active_status[0]->aflw_id.' LIMIT 1');
                    if(count($stage_dtls) > 0)
                    {
                        $new_arr->role_name = $stage_dtls[0]->role_name;
                        $new_arr->jwf_stage_name = $stage_dtls[0]->jwf_stage_name;
                    }
                    array_push($deleted_stages,$new_arr);
                }
            }
        }
    }
    return $deleted_stages;
}

public function removeKeyFromObject($object, $key) {
    $array = (array)$object;  // Convert object to array
    unset($array[$key]);      // Remove the specified key
    return (object)$array;    // Convert array back to object
}

public function is_date_format($value, $format = 'Y-m-d') {
    $d = DateTime::createFromFormat($format, $value);
    return $d && $d->format($format) === $value;
}

public function isMonthYearFormat($input) {
    $return_arr = [];
    $monthly_date = DateTime::createFromFormat('F Y', $input);
    $daily_date = DateTime::createFromFormat('d-m-Y', $input);
    
    if($monthly_date && strtolower($monthly_date->format('F Y')) === strtolower($input)) {
        $return_arr['type'] = 'month';
        $month =  $monthly_date->format('m');
        $return_arr['month'] = $month;
        $return_arr['year'] = $monthly_date->format('Y');
        return $return_arr;
    }
    else if($daily_date && $daily_date->format('d-m-Y') === $input)
    {
        $return_arr['type'] = 'day';
        $return_arr['day'] = $daily_date->format('Y-m-d');
        return $return_arr;
    }
    else 
    {
        try
        {
            $parts = explode(':', $input);
            if (count($parts) !== 2) {
                return FALSE;
            }
            $date1 = DateTime::createFromFormat('d-m-Y', trim($parts[0]));
            $date2 = DateTime::createFromFormat('d-m-Y', trim($parts[1]));    
            $interval = $date1->diff($date2);
            $daysDifference = $interval->days;
            if($daysDifference > 90)
            {
                return 'days_over';
            }
            // Check if both dates are valid and match the input format
            if ($date1 && $date2 && $date1->format('d-m-Y') === trim($parts[0]) && $date2->format('d-m-Y') === trim($parts[1]) && $daysDifference <= 90) 
            {
                $return_arr['type'] = 'range';
                $return_arr['range_from'] = $date1->format('Y-m-d');
                $return_arr['range_to'] = $date2->format('Y-m-d');
                return $return_arr;
            } 
            else 
            {
                return FALSE;
            }
        }
        catch(\Exception $e)
        {
            return FALSE;
        }
    }
}


    /*
    * Fetch the chronological order of workflow
    */
    public function get_chrono_order_of_workflow()
    {
        $response_data = [
            'status' => 401,
            'status_message' => FALSE,
            'data' => response()->json(array()),
            'message' => 'success' 
        ];

        if(isset($_GET['jnl_code'])) {            
            $Journals   =   (new \App\Models\Journals());
            $jnl_code   =   $_GET['jnl_code'];
            $sql        =   "SELECT 
                                `at`.`artp_id`, `at`.`artp_article_type`
                            FROM 
                                `rvw_article_types` `at` 
                            INNER JOIN 
                                `rvw_journals` `j` ON (`j`.jnl_id = `at`.`artp_jnl_id`)
                            WHERE 
                                `j`.`jnl_journal_code` = '".$jnl_code."' and `artp_status` = 'y'";
            $types      =   $Journals::get_records_by_raw_query($sql);

            if(count($types) > 0) {
                foreach($types as $key) {
                    $artp_id    =   $key->artp_id;
                    $order_by   =   "";
                    // $order_by   =   "ORDER BY FIELD(`jw`.`jwf_stage_type`, 'author_submission', 'transit', 'authors_declaration', 'staff_check', 'pre_assessment', 'revision', 'review', 'post_assessment', 'accept', 'reject', 'decision_revision', 'decision_resubmit', 'resubmission', 'copyright', 'license_check', 'payment', 'production', 'qulity_check', 'editorial_amendment', 'pro_revision', 'editorial_process', 'preprocessing', 'aop_publish', 'graphic_processing', 'copy_editing', 'type_setting', 'proof_reading', 'postprocessing', 'publish')";
                    $sql        =   "SELECT
                                        `jw`.`jwf_id` AS id, `jw`.`jwf_stage_type`, `jw`.`jwf_stage_name` AS name,
                                        REPLACE(REPLACE(REPLACE(`jw`.`jwf_child_stages`, ']', ''), '[', ''), '\"', '') AS children
                                    FROM
                                        `rvw_journal_workflows` `jw`
                                    LEFT JOIN `rvw_article_types` `at` ON
                                        (`jw`.jwf_fwm_id = `at`.`artp_fwm_id`)
                                    WHERE
                                        `artp_id` = $artp_id $order_by";
                    $set        =   $Journals::get_records_by_raw_query($sql);
                    $dataSets = json_decode(json_encode($set), true);
                                        
                    // Convert the array to a collection
                    $collection = collect($dataSets);
                    
                    // Create a mapping of id to children for quick lookup
                    $idToChildren = $collection->mapWithKeys(function ($item) {
                        return [$item['id'] => explode(',', $item['children'])];
                    })->toArray();

                    // Flatten all children ids to identify root nodes
                    $allChildren = array_merge(...array_values($idToChildren));
                    
                    // Initialize the sorted array
                    $sorted = [];        
                    // Sort recursively starting from the root nodes (nodes without parents)
                    foreach ($dataSets as $item) {
                        if (!in_array($item['id'], $allChildren)) {
                            $sorted[] = $item;
                            $this->sortRecursively($collection, $idToChildren, $item['id'], $sorted);
                        }
                    }
                    $results[]    =   array('id' => $artp_id, 'article_type' => $key->artp_article_type, 'workflow'  => $sorted);
                }
            }
        }

        // Return the results to a view or as JSON
        $response_data = [
            'status' => 200,
            'status_message' => TRUE,
            'data' => response()->json($results),
            'message' => 'success' 
        ];
        return $response_data;

    }

    // Define a function to sort recursively
    private function sortRecursively($collection, $idToChildren, $parentId, &$sorted) {
        if (!isset($idToChildren[$parentId])) {
            return;
        }
    
        foreach ($idToChildren[$parentId] as $childId) {
            $child = $collection->firstWhere('id', $childId);
            if (isset($child)) {
                if (!in_array($child, $sorted)) {
                    $sorted[] = $child;
                    $this->sortRecursively($collection, $idToChildren, $childId, $sorted);
                }
            }
        }
    }

    public function send_mail_for_rvrite_comments(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'email_ids'   => 'required',
                'user_ids' => 'required',
                'art_id' => 'required',
                'email_content'   => 'required',
                'sender_user_id' => 'required',
                'sender_user_proxy_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } 
            else 
            {
                $return_arr = array('status' => 'failed','code' => 400);
                $post_data = $request->all();
                $email_template_tbl = new \App\Models\Email_templates();
                $tmpl_condition =array('etmp_name'=>'comment_on_rvrite_mail');
                $email_template = $email_template_tbl::get_all_records_with_bind_cond('etmp_subject,etmp_email_template,etmp_id,etmp_cc,etmp_bcc,etmp_cust_cc,etmp_cust_bcc,etmp_templete_name,etmp_name,etmp_cust_to,etmp_content_type,etmp_name,etmp_notification',$tmpl_condition);
                if(!empty($email_template))
                {
                    $send_mail_to = $post_data['email_ids'];
                    $send_mail_to_usr_ids = $post_data['user_ids'];
                    $user_data = array(
                        'user_id' => $post_data['sender_user_id'],
                        'proxy_user_id' => $post_data['sender_user_proxy_id']
                    );
                    $Articles       = (new \App\Models\Articles());
                    $articles_table = $Articles->getTable();
                    $article_type_table  = (new \App\Models\Article_types())->getTable();
                    $journals_table       = (new \App\Models\Journals())->getTable();
                    $criteria   = "art_id='{$post_data['art_id']}'";
                    $select     = 'artp_id,jnl_id,jnl_journal_code';
                    $tables = array(
                        'main_table' => $articles_table,
                        'join_table' => array(
                            $article_type_table => array($article_type_table . '.artp_id', $articles_table . '.art_artp_id'),
                            $journals_table => array($journals_table . '.jnl_id', $article_type_table . '.artp_jnl_id')
                        )
                    );
                    $article_codes = $Articles::get_results_using_joins($tables, $select, $criteria, 'all');
                    if(!empty($article_codes))
                    {
                        $article_data = $article_codes[0];
                        if ($send_mail_to != '')
                        {
                                $custom_data = array(
                                    'user_email'=>$send_mail_to,
                                    'etmp_notification' => $email_template[0]->etmp_notification,
                                    'mail_recipient_ids'=> $send_mail_to_usr_ids,
                                    'article_id'=> $post_data['art_id'],
                                    'artp_id'=> $article_data->artp_id,
                                    'jnl_id'=>$article_data->jnl_id,
                                    'jnl_code'=>$article_data->jnl_journal_code,
                                    'user_data'=>$user_data,
                                    'esl_etmp_action'=>'rv_rite_comment_mail',
                                    'editor_passed_comments'=>$post_data['email_content']
                                );
                                $email_data = array(
                                    'type' => 'global',
                                    'action' => 'send',
                                    'user_id'=> $user_data['user_id'],
                                    'email_with_login' => true,
                                    'empt_name' => 'comment_on_rvrite_mail',
                                    'custom_data' => $custom_data
                                );
                                $send_email = $this->master_email_details($email_data);   
                                $return_arr = array('status' => 'success','code' => 200);
                        }
                        
                    }
                }
                return response()->json($return_arr);
            }
        }
        catch(\Exception $e)
        {
            return  $this->failure('Failed', 500, $e);
        }
    }

     public function deep_sort_data($data)
    {
        if (is_array($data)) {
            foreach ($data as &$value) {
                $value = $this->deep_sort_data($value);
            }

            if (array_is_list($data)) {
                sort($data);
            } else {
                ksort($data);
            }
        }
        return $data;
    }

    public function hash_author_data($data)
    {
        $sorted = $this->deep_sort_data($data);
        $json = json_encode($sorted, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRESERVE_ZERO_FRACTION);
        $hashed_string = hash('sha256', $json);
        return $hashed_string;
    }

}
