<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Config;
// use JWTAuth;
// use JWTAuthException;
use DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Generic_flows;
use App\Models\Journals;
use App\Models\Articles;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Models\User;
use App\Models\Flags;
use App\Http\Traits\SearchArticleTrait;
use App\Http\Traits\JatsArtcileXmlTrait;
use App\Models\Article_type_advance_options;
use App\Models\Roles;
use App\Models\Email_templates;
use App\Models\Article_flow;
use App\Models\Authors;
use App\Models\Unassign_reviewer;
use App\Models\Stage_email_templates;
use App\Models\User_to_journals;
use App\Models\Article_legacydata;
use App\Models\Article_reviewer_legacydata;
use App\Models\Article_classification;
use App\Models\Classifications;
use App\Models\Terms;
use App\Models\Sheet_view_optional_selected_colums;
use App\Http\Traits\UtilityTrait;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\File;
use Response;
// use Illuminate\Support\Facades\Response;

class Manage_Sheet_View_Api extends Controller
{
    use SearchArticleTrait;
    use JatsArtcileXmlTrait;
    //function to get all the articles in a journal.
    public function manage_sheet_view(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'journalCode'       => 'required',
                'activeCoreRoleId'  => 'required',
                'activeCoreRole'    => 'required',
                'per_page'          => 'required',
                'sort_field'        => 'required',
                'sort_order'        => 'required',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } else {
                //check user has permission to manage articles
                $payloadData      = $request->all();
                $activeCoreRoleId = Rv_decrypt($payloadData['activeCoreRoleId']);
                $activeCoreRole   = Rv_decrypt($payloadData['activeCoreRole']);
                $journalCode      = strtolower(Rv_decrypt($payloadData['journalCode']));
                $currentUser      = $this->get_current_user_details();
                $current_client   = $this->current_client;
                $downloadStatus   = isset($payloadData['downloadStatus']) ? $payloadData['downloadStatus'] : 'n';

                $breaker = '';
                // Setting permissions
                $result = $this->getPermittedArticleStatus($current_client);
                $articleStatus = $result['articleStatus'];
                $permissions = $result['permissions'];

                $validatorStatus  = TRUE;
                $input_arr = array(
                    'input' => $payloadData['activeCoreRole'],
                    'type'  => 'string'
                );
                if($validatorStatus == TRUE) {
                    $validatorStatus = $this->Rv_validator($input_arr);
                }
                if($validatorStatus == TRUE) {
                    $input_arr['input'] = $payloadData['journalCode'];
                    $validatorStatus = $this->Rv_validator($input_arr);
                }
                if($validatorStatus == TRUE) {
                    $input_arr['input'] = $payloadData['activeCoreRoleId'];
                    // $input_arr['type'] = 'number';
                    $validatorStatus = $this->Rv_validator($input_arr);
                }

                $jnlCodeValid = $this->validatecode(array('jnl_code'=>$journalCode),FALSE);
                $roleValid = $this->validatecode(array('role_assigned_role'=>$activeCoreRole),FALSE);

                if($jnlCodeValid['jnl_code'] != TRUE || $roleValid['role_assigned_role'] != TRUE  || $validatorStatus == FALSE ){
                    $response = array(
                        'msg'            => customTrans('viewarticle.invalid_data'),
                        'status'         => 'warning',
                    );
                    return  $this->warning('Warnings',200,$response,'warning');
                }
    			$Journals         = new \App\Models\Journals;
                $journalData      = $Journals::get_journal_data($journalCode);

                $showPrductionContent = FALSE;
                $isProductionUser = FALSE;
                if (isset($current_client->modules->mdl_production) && $current_client->modules->mdl_production == 'y') {
                    $showPrductionContent = TRUE;
                    $productionUserRoles = overview_productionroles();
                    if (in_array($activeCoreRole, $productionUserRoles)) {
                        $isProductionUser = TRUE;
                    }
                }
                $jset_date_format =  $this->get_platform_date_format($journalData->jnl_id);
                if (isset($jset_date_format) && !empty($jset_date_format)) {
                    $dateFormat = $jset_date_format;
                } else {
                    $dateFormat = $current_client->settings->cs_date_format;
                }
                $dateFormat = date_format_map($dateFormat);
                $articleDetails = $this->getSheetViewData($payloadData, $currentUser, $current_client, $journalData, $downloadStatus, $isProductionUser ,$showPrductionContent, $dateFormat);
                if(isset($articleDetails['status']) && $articleDetails['status'] == 'failed') {
                    $response = array(
                        'msg'            => customTrans('viewarticle.invalid_data'),
                        'status'         => 'warning',
                        'data'           => array(),
                        'last_page'      => 0,
                        'total_records'  => 0,
                        'per_page'       => 0,
                        'currentPage'    => 0,
                        'to'             => 0,
                        'from'           => 0,
                    );
                    // return $this->success('error', 200, $response);
                    return  $this->warning('Warnings',200,$response,'warning');
                }

                $articleLists = $articleDetails['article_result'];
                $data = array();
                if (count($articleLists) > 0) {
                    $i=0;
                    foreach ($articleLists as $article) {
                        $select = "jp_blind_articles";
                        $condition = "artp_id={$article->art_artp_id}";
                        $articleTypeAdvance = $this->get_article_type_permission($select, $condition);
                        $allowBlindRoles = json_decode($articleTypeAdvance->jp_blind_articles);
                        $articleBlindPermission = FALSE;
                        if (!empty($allowBlindRoles) && in_array($activeCoreRoleId, $allowBlindRoles)) {
                            $articleBlindPermission = TRUE;
                        }
                        $articleKeywords = '';
                        // $escape_hash    = "#*#";
                        if ($article->prev_art_codes != ''){
                            $condition = 'art_id IN (' . $article->prev_art_codes . ')';
                            $previous_articles = Articles::get_single_record('GROUP_CONCAT(art_code) as prev_codes', $condition);
                            $previous_art_codes = explode(',', $previous_articles->prev_codes);
                        }
                        else
                            $previous_art_codes = '';

                        if ($article->keywords != '') {
                            // $articleKeywords = implode($escape_hash, explode(',  ', $article->keywords));
                            // $articleKeywords = $this->unicode_correction_export($articleKeywords);
                            $articleKeywords = explode(',  ', $article->keywords);
                        } else
                            $articleKeywords = '';

                        //getting submitted user names
                        $displayArray = array(
                            'user_id' => $article->art_submitted_by,
                            'jnl_code' => $journalData->jnl_journal_code,
                            'flag'     => TRUE,
                            'article_id' => $article->art_id,
                            'availability' => TRUE,
                            'save_coauthor' => FALSE,
                            'remove_user' => FALSE,
                            'source' => FALSE,
                            'salutation' => TRUE,
                            'flag_only' => FALSE,
                            'inactive_user' => FALSE,
                            'fullname_only' => FALSE,
                            'journal_id' => $journalData->jnl_id,
                        );
                        $title_html          = $this->get_user_display_name($displayArray);

                        // $blinded_usr_details = $this->get_blinded_users($article->art_id,TRUE,$articleBlindPermission,TRUE);
                        // $blinded_usr_details = '<div class="input-group" data-art_id="'.encrypt_link($row->art_id).'" id="select_userList_'.encrypt_link($row->art_id).'">'.$blinded_usr_details.'</div>';

                        if ($current_client->modules->mdl_review_for_doc == 'y') {
                            $act_submission_date = $article->last_updated_date;
                        } else {
                            $act_submission_date = $article->submitted_date;
                        }
                        if ($downloadStatus == 'y'){
                            $article_status = ($article->art_delete_status == 'h') ? "On Hold" : (($article->art_delete_status == 'w') ? "Withdrawn" : (isset($articleStatus[$article->original_status]) ? $articleStatus[$article->original_status] : ''));
                        }
                        else{
                            $article_status = ($article->art_delete_status == 'h') ? "<span class='text-red'><b>On Hold</b></span>" : (($article->art_delete_status == 'w') ? "<span class='text-red'><b>Withdrawn</b></span>" : (isset($articleStatus[$article->original_status]) ? $articleStatus[$article->original_status] : ''));
                        }
                        $article_status = $article_status == '' ? $articleStatus['y'] : $article_status;

                        $delete_permission = FALSE;
                        $withdraw_permission = FALSE;
                        $hold_permission = FALSE;
                        $release_permission = FALSE;

                        if ($permissions['deletePermission'] === TRUE && $article->art_delete_status != 'w') {
                            $delete_permission = TRUE;
                        }
                        if ($permissions['withdrawPermission'] === TRUE && $article->art_delete_status != 'w' && $article->art_delete_status != 'h' && (!in_array($article->original_status, array('r', 'c')) || ($article->original_status == 'c' && $article->jwf_stage_type == 'resubmission'))) {
                            $withdraw_permission = TRUE;
                        }
                        if ($permissions['holdPermission'] === TRUE && $article->art_delete_status != 'w' && $article->art_delete_status != 'h' && !in_array($article->original_status, array('r', 'c'))) {
                            $hold_permission = TRUE;
                        }
                        if ($permissions['holdPermission'] === TRUE && $article->art_delete_status == 'h' && $article->original_status != 'q') {
                            $release_permission = TRUE;
                        }
		                $blinded_usr_details = $this->get_blinded_users($journalData->jnl_journal_code, $article->art_id,TRUE);

                        // if (isset($current_client->modules->mdl_production) && $current_client->modules->mdl_production == 'y') {
                            //shows when the production module is on
                            $pages = $this->issue_management_page_count($article->art_id,$journalCode);
                            if ($pages == 0 && isset($article->ism_art_page_cnt) && !empty($article->ism_art_page_cnt))
                            $pages = $article->ism_art_page_cnt;
                            $issue_volume      =   (!empty($article->iss_title))?$article->iss_title . $breaker . '(' . $article->vol_title . ')':'NIL';
						    $current_stage_details = $this->get_current_stage_details_for_sheet_view($article->art_id,$journalData,$downloadStatus);
                            $user_roles = $this->validate_user_journal($journalData->jnl_journal_code, $currentUser['user_id']);
                            $current_userroles = $user_roles['role_id'];
                            $art_flags = $this->get_article_flags($article->art_id,$current_userroles,$journalData->jnl_journal_code,FALSE,TRUE);
                            // print_r($current_stage_details);die;
                            $data[$i] = array(
                                'jnl_id'            => encrypt_link($journalData->jnl_id),
                                'jnl_code'          => $journalData->jnl_journal_code,
                                'art_code'          => $article->art_code,
                                "art_title"         => trim(strip_tags($article->art_title)),
                                "artp_id"           => encrypt_link($article->art_artp_id),
                                "artp_article_type" => $article->artp_article_type,
                                "kwd_name"          => $articleKeywords,
                                "art_submitted_by"  => $title_html,
                                "art_submission_date" => $act_submission_date,
                                "articleBlindPermission" => $articleBlindPermission,
                                "art_blinded_for"   => $blinded_usr_details,
                                "prev_art_codes"    => $previous_art_codes,
                                "original_status"   => $article_status,
                                "delete_permission" => $delete_permission,
                                "withdraw_permission" => $withdraw_permission,
                                "hold_permission"   => $hold_permission,
                                "release_permission"=> $release_permission,
                                "art_id"            => $article->art_id,
                                "aflw_id"           =>$this->encrypt_data($article->aflw_id), //TASK #3755 Modification in adhoc email to load the 'View Article' link with its content
                                "encrypt_art_id"    => $this->encrypt_data($article->art_id),
                                "page_extent"       => $pages,
                                "page_count"        => $article->ism_art_page_cnt,
						        "iss_title"         => $issue_volume,
                                "current_stage"     => $current_stage_details['crnt_stg'],
                                "start_date"        => $current_stage_details['crnt_stg_dts'],
                                "due_date"          => $current_stage_details['crnt_stg_due_dts'],
                                "task_assigned_to"  => ($current_stage_details['crnt_stg_assign_to']),
                                "flags"             => $art_flags,
                                "classification"    => $article->classification,
                                "art_delete_status" => $article->art_delete_status,
                            );
                            if($isProductionUser == TRUE) {
                                $target_online_pub_date = 'NIL';
                                if (!empty($article->art_epub_date))
                                {
                                    $articleTypesTable  = (new \App\Models\Article_types())->getTable();
                                    $articlesTable      = (new \App\Models\Articles())->getTable();
                                    $today = date('Y-m-d');
                                    $top_date = $article->art_epub_date;
                                    $epub_date = $article->epub_date;

                                    if ($today > $top_date)
                                    {
                                        $target_online_pub_date = '<span class="exp_cls">'.(!empty($epub_date)?$epub_date:'').'</span>';
                                    }
                                    else
                                    {
                                        $target_online_pub_date = '<span>'.(!empty($epub_date)?$epub_date:'').'</span>';
                                    }
                                    if ($downloadStatus == 'y'){
                                        $target_online_pub_date = (!empty($epub_date)?$epub_date:'');
                                    }
                                    $original_submitdate='';
                                    if(!empty($article->art_pre_all_ids))//prev_art_codes
                                    {
                                        $sql ='SELECT DATE_FORMAT(art_submission_date, "' . $dateFormat . '") as original_submitdate  FROM '.$articlesTable . ' LEFT JOIN ' . $articleTypesTable . ' artp ON art_artp_id = artp_id WHERE artp_jnl_id = '.$journalData->jnl_id.' and art_id IN ('.$article->art_pre_all_ids.') LIMIT 1';
                                        $details= Articles::get_records_by_raw_query($sql);
                                        if(!empty($details))
                                            $original_submitdate=$details[0]->original_submitdate;
                                    }
                                }
                                $data[$i]['original_submission_date'] = (!empty($original_submitdate)?$original_submitdate:$act_submission_date);
                                $data[$i]['art_decision_date'] = $article->decision_date;
                                $data[$i]['art_epub_date'] = $target_online_pub_date;
                            }
                        // } else {
                        //     $redirect_base_url = URL::to('/');
                        //     $temp_arr = explode('##', $article->aflow_sgtype_column);
						//     $aflw_id = $temp_arr[0];
                        //     // $aflw_id =  ( $article->aflw_parent_flow_id != NULL) ? $article->aflw_parent_flow_id : $article->aflw_id ;
                        //     $article_code_link =  $redirect_base_url.'/'. $current_client->platform_type.'/'. $journalData->jnl_journal_code . '/view-article/' . $this->encrypt_data($article->art_id) .'/'. $this->encrypt_data($aflw_id);

                        //     $data[$i] = array(
                        //         'jnl_id'            => encrypt_link($journalData->jnl_id),
                        //         'jnl_code'          => $journalData->jnl_journal_code,
                        //         'art_code'          => $article->art_code,
                        //         'art_link'          => $article_code_link,
                        //         "art_title"         => trim(strip_tags($article->art_title)),
                        //         "artp_id"           => encrypt_link($article->art_artp_id),
                        //         "artp_article_type" => $article->artp_article_type,
                        //         "kwd_name"          => $articleKeywords,
                        //         "art_submitted_by"  => $title_html,
                        //         "art_submission_date" => $act_submission_date,
                        //         "articleBlindPermission" => $articleBlindPermission,
                        //         "art_blinded_for"   => $blinded_usr_details,
                        //         "prev_art_codes"    => $previous_art_codes,
                        //         "original_status"   => $article_status,
                        //         "delete_permission" => $delete_permission,
                        //         "withdraw_permission" => $withdraw_permission,
                        //         "hold_permission"   => $hold_permission,
                        //         "release_permission" => $release_permission,
                        //         "art_id"            => $article->art_id,
                        //         "encrypt_art_id"    => $this->encrypt_data($article->art_id)
                        //     );
                        // }
                        $i++;
                    }
                };
                // $sheet_view_config = 'clients.' . $this->current_client->clnt_client_code . '.sheet_view_colums';
                // $sheet_view_colums = Config::get($sheet_view_config);
                // if($isProductionUser == FALSE) {
                //     if(($key = array_search('original_submission_date', $sheet_view_colums)) !== false) {
                //         unset($sheet_view_colums[$key]);
                //     }
                //     if(($key = array_search('art_decision_date', $sheet_view_colums)) !== false) {
                //         unset($sheet_view_colums[$key]);
                //     }
                //     if(($key = array_search('art_epub_date', $sheet_view_colums)) !== false) {
                //         unset($sheet_view_colums[$key]);
                //     }
                //     $sheet_view_colums = array_values($sheet_view_colums);
                // }
                $currentPage = $articleLists->currentPage();
                $perPage     = $articleLists->perPage();
                $lastPage    = $articleLists->lastPage();
                $total       = $articleLists->total();
                $to          = $currentPage * $perPage;
                $from        = (($currentPage - 1) * $perPage) + 1;
                if($lastPage == $currentPage){
                    $to = $total;
                }
                //Task #7443 Starts
                $journal_setting = Journal_settings::get_single_record_with_bind_cond('jset_jats_export',['jset_jnl_id' => $journalData->jnl_id]);
                $jats_func = isset($current_client->functionality->cfty_meca_export)?$current_client->functionality->cfty_meca_export:'n';
                $jats_export = $this->jatsExportFunc($jats_func,$journal_setting,$activeCoreRoleId);
                //Task #7443 Ends
                // print_r($payloadData['page']);die;
                $response = array(
                    'data'           => $data,
                    'last_page'      => $articleLists->lastPage(),
                    'total_records'  => $articleLists->total(),
                    'per_page'       => $articleLists->perPage(),
                    'currentPage'    => $articleLists->currentPage(),
                    'to'             => $to,
                    'from'           => $from,
                    'jats_export'    => $jats_export
                 );
                if($downloadStatus == 'y'){
                    if(count($data) > 0){
                        $titles = array("Sl.no","Current version","Article Title","Article Type","Keywords","Submitted By","Submission Date","Blinded For","Previous version","Status","Page extent","Issue(Volume)","Current stage(s)","Start date of current stage(s)","Due date of current stage(s)","Task assigned to","Flags");
                        if($isProductionUser == TRUE) {
                            $titles = array("Sl.no","Current version","Article Title","Article Type","Keywords","Submitted By","Submission Date","Blinded For","Previous version","Status","Page extent","Issue(Volume)","Current stage(s)","Start date of current stage(s)","Due date of current stage(s)","Task assigned to","Flags","Original submission date","Decision date","Target online publication date");
                        }
                        $rtn_arr = $this->download_sheet_view_as_csv($titles,$data,$isProductionUser);
                        $response = array(
                            'status'            => TRUE,
                            'downloadPath'      => Rv_encrypt($rtn_arr['fullPath']),
                            'fileName'          => Rv_encrypt($rtn_arr['fileName'])
                        );
                    } else {
                        $response = array(
                            'status'            => FALSE
                        );
                    }
                }
                return $this->success('success', 200, $response);
            }
        } catch (\Exception $e) {
            // $this->customErrorAction('manage_proposal',$e);
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function getSheetViewColumnDetails(Request $request)
    {
        try{
            $activeCoreRole  = isset($request->activeCoreRole) ? Rv_decrypt($request->activeCoreRole) : NULL;
            /*Conflict Resolve commit */
            $sheet_view_config = 'clients.' . $this->current_client->clnt_client_code . '.sheet_view_config';
            $sheet_view_colums = array();
            $config_data = Config::get($sheet_view_config);
            if(isset($config_data['sheet_view_colums']))
            {
                $sheet_view_colums = $config_data['sheet_view_colums'];
            }

            $productionUserRoles = overview_productionroles();
            $isProductionUser = FALSE;
            if ($activeCoreRole && in_array($activeCoreRole, $productionUserRoles)) {
                        $isProductionUser = TRUE;
            }
            if($isProductionUser == FALSE && is_array($sheet_view_colums) && count($sheet_view_colums) > 0) {
                if(($key = array_search('original_submission_date', $sheet_view_colums)) !== false) {
                    unset($sheet_view_colums[$key]);
                }
                if(($key = array_search('art_decision_date', $sheet_view_colums)) !== false) {
                    unset($sheet_view_colums[$key]);
                }
                if(($key = array_search('art_epub_date', $sheet_view_colums)) !== false) {
                    unset($sheet_view_colums[$key]);
                }
                $sheet_view_colums = array_values($sheet_view_colums);
            }
            if(isset($this->current_client->functionality->cfty_manage_issues) && ($this->current_client->functionality->cfty_manage_issues == 'n'))
            {
                if(($key = array_search('iss_title', $sheet_view_colums)) !== false) {
                    unset($sheet_view_colums[$key]);
                }
                if(($key = array_search('page_extent', $sheet_view_colums)) !== false) {
                    unset($sheet_view_colums[$key]);
                }
                if(($key = array_search('page_count', $sheet_view_colums)) !== false) {
                    unset($sheet_view_colums[$key]);
                }
                $sheet_view_colums = array_values($sheet_view_colums);
            }
            $response = array(
                'sheet_view_colums' => $sheet_view_colums
            );
            return $this->success('success', 200, $response);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_all_assigned_to_prdn_users($journalData, $current_client, $postDataSearch = '')
    {
        $articlesTable      = (new \App\Models\Articles())->getTable();
        $articleFlowTable   = (new \App\Models\Article_flow())->getTable();
        $genericFlowsTable  = (new \App\Models\Generic_flows())->getTable();
        $userTable          = (new \App\Models\User())->getTable();
        $articleTypesTable  = (new \App\Models\Article_types())->getTable();
        $tables = array(
            'main_table' => $articleTypesTable,
            'join_table' => array(
                $articlesTable      => array($articlesTable . '.art_artp_id', $articleTypesTable . '.artp_id', "left"),
                $articleFlowTable   => array($articleFlowTable . '.aflw_art_id', $articlesTable . '.art_id', "left"),
                $genericFlowsTable  => array($genericFlowsTable . '.jwf_id', $articleFlowTable . '.aflw_jwf_id', "left"),
                $userTable          => array($userTable . '.usr_id', $articleFlowTable . '.aflw_usr_id', "left")
            )
        );
        $selectFields     = 'usr_id,usr_email,art_id,art_code,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as full_name';
        $produtionStages       = $this->get_all_stages_keys($current_client);
        // print_r($produtionStages);die;
        $searchCriteria   = '`aflw_status` IN (\'a\') AND `artp_jnl_id` = ' . $journalData->jnl_id . ' AND jwf_stage_type IN (\'' . implode('\',\'', $produtionStages) . '\') AND `art_status` != \'n\' AND `art_delete_status` = \'n\' AND LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $postDataSearch . '%") GROUP BY usr_id';
        $assigned_to_users = User::get_results_using_joins($tables, $selectFields, $searchCriteria, 'all', 'usr_first_name');
        return $assigned_to_users;
    }
    public function get_all_stages_keys($current_client, $workflow = NULL)
    {
        if (empty($workflow)) {
            $clientCode = $current_client->clnt_client_code;
            $workflow_config = 'clients.' . $clientCode . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
        }
        $prdn_stages = array();
        foreach ($review_flow as $k => $v) {
            $prdn_stages[] = $k;
        }
        return $prdn_stages;
    }
    public function get_all_jnl_authors($journalData, $postDataSearch = '')
    {
        $userTable          = (new \App\Models\User())->getTable();
        $userJournalTable   = (new \App\Models\User_to_journals())->getTable();
        $rolesTable         = (new \App\Models\Roles())->getTable();
        $articleTable       = (new \App\Models\Articles())->getTable();

        $tables = array(
            'main_table' => $userTable,
            'join_table' => array(
                $userJournalTable   => array($userTable . '.usr_id', $userJournalTable . '.usrj_usr_id', "left"),
                $rolesTable         => array($rolesTable . '.role_id', $userJournalTable . '.usrj_role_id', "left"),
                $articleTable       => array($articleTable . '.art_submitted_by', $userTable . '.usr_id', "left")
            )
        );
        $selectFields   = 'DISTINCT(usr_id),usr_email,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as full_name';
        $searchCriteria =  '`art_status` != \'n\' AND `usrj_jnl_id` = ' . $journalData->jnl_id . ' AND `role_assigned_role` = \'author\' AND LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $postDataSearch . '%")';
        $prdn_users     = User::get_results_using_joins($tables, $selectFields, $searchCriteria,'all', 'usr_first_name');
        return $prdn_users;
    }
    public function get_all_stages(Request $request)
    {
        try{
            $payloadData      = $request->all();
            $articleTypeId    = $payloadData['articleTypeId']?Rv_decrypt($payloadData['articleTypeId']):NULL;
            $activeCoreRoleId = Rv_decrypt($payloadData['activeCoreRoleId']);
            $activeCoreRole   = Rv_decrypt($payloadData['activeCoreRole']);
            $journalCode      = Rv_decrypt($payloadData['journalCode']);
            $currentUser      = $this->get_current_user_details();
            $current_client   = $this->current_client;
            $Journals          = new \App\Models\Journals;
            $journalData       = $Journals::get_journal_data($journalCode);
            $productionUserRoles = overview_productionroles();
            $productionUsers= array();
            $journalAuthors = array();
            $allStages      = array();
            $flags          = array();
            $wrkFlwStages   = array();
            if (in_array($activeCoreRoleId, $productionUserRoles)) {
                $allStages = $this->get_production_stages_keys();
            } else {
                $allStages = $this->get_all_stages_keys($current_client);
            }
            $current_client = $this->current_client;
            $hide_submission_inprogress_articles = (isset($current_client->functionality->cfty_hide_submission_inprogress_sheetview) && $current_client->functionality->cfty_hide_submission_inprogress_sheetview == 'y') ? TRUE : FALSE;
            if($hide_submission_inprogress_articles == TRUE)
            {
                $key = array_search('author_submission', $allStages);
                array_splice($allStages, $key, 1);
            }
            $wrkFlwStages = $this->get_production_wrk_flw_stages_keys($allStages, $journalData->jnl_id, $articleTypeId);
            $response = array(
                'allStages' => $wrkFlwStages
            );
            return $this->success('success', 200, $response);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_production_wrk_flw_stages_keys($prdn_stages, $jnl_id, $artp_id=NULL)
    {
        $articleTypesTable  = (new \App\Models\Article_types())->getTable();

        $select = 'DISTINCT(jwf_stage_name),jwf_stage_type';
        $criteria = '`jwf_stage_type` IN ( \'' . implode('\',\'', $prdn_stages) . '\' )  AND  `jwf_fwm_id` IN (select artp_fwm_id FROM ' . $articleTypesTable . ' WHERE artp_jnl_id = ' . $jnl_id . ')';
        if($artp_id != NULL)
        {
            $criteria = '`jwf_stage_type` IN ( \'' . implode('\',\'', $prdn_stages) . '\' )  AND  `jwf_fwm_id` IN (select artp_fwm_id FROM ' . $articleTypesTable . ' WHERE artp_jnl_id = ' . $jnl_id . ' AND artp_id='.$artp_id.')';  
        }
        $wrk_flw_stages = Generic_flows::get_all_records($select, $criteria);
        return ($wrk_flw_stages);
    }
    public function get_all_prdn_stage_article_flags($prdn_stages, $journalData)
    {
        $flagTable      = (new \App\Models\Flags())->getTable();
        $ArticleFlag    = (new \App\Models\Article_flag())->getTable();
        $articleFlowTable   = (new \App\Models\Article_flow())->getTable();
        $genericFlowsTable  = (new \App\Models\Generic_flows())->getTable();

        $tables = array(
            'main_table' => $flagTable,
            'join_table' => array(
                $ArticleFlag        => array($ArticleFlag . '.aflg_flag_id', $flagTable . '.flag_id', "left"),
                $articleFlowTable   => array($articleFlowTable . '.aflw_art_id', $ArticleFlag . '.aflg_art_id', "left"),
                $genericFlowsTable  => array($genericFlowsTable . '.jwf_id', $articleFlowTable . '.aflw_jwf_id', "left"),
            )
        );
        $selectFields = 'flag_id,flag_name,aflg_art_id';
        $searchCriteria = 'aflg_jnl_id = ' . $journalData->jnl_id . ' AND jwf_stage_type IN ' . '(\'' . implode('\',\'', $prdn_stages) . '\')';
        $prdnFlags = Flags::get_results_using_joins($tables, $selectFields, $searchCriteria, 'all', 'flag_id ASC', null, '', null, null, null, 'flag_id');
        return $prdnFlags;
    }

    public function get_basic_details(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id'   => 'required',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } else {
                $result = array();
                $payloadData = $request->all();
                $current_client = $this->current_client;
                $current_user = $this->get_current_user_details();
                $jnl_id            = decrypt_link($payloadData['jnl_id']);
                $journalCode       = $payloadData['journalCode'];
                $activeCoreRoleId  = $payloadData['activeCoreRoleId'];
                $art_type_code     = $payloadData['activeCoreRoleId'];
                $Journals          = new \App\Models\Journals;
                $journalData       = $Journals::get_journal_data($journalCode);
                $all_article_types   = Article_types::get_all_valid_articletype('artp_fwm_id,artp_id,artp_article_type', "artp_jnl_id={$jnl_id}");
                $result['all_article_types'] = $all_article_types;
                $jnl_date_format = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
                $array_date=platform_date_format();
                $result['dateFormat'] = $array_date[$jnl_date_format];
                $result['deleteReason'] =  UtilityTrait::Utility('reason_to_delete_article')['reason_to_delete_article'];
                $articlePermission = $this->getPermittedArticleStatus($current_client);
                $result['articleStatus'] = $articlePermission['articleStatus'];
                $result['modules'] = $current_client->modules;
                $productionUsers= array();
                $journalAuthors = array();
                $allStages      = array();
                $flags          = array();
                $wrkFlwStages   = array();
                // if (isset($current_client->modules->mdl_production) && $current_client->modules->mdl_production == 'y') {
                    $productionUsers = $this->get_all_assigned_to_prdn_users($journalData, $current_client);
                    $journalAuthors  = $this->get_all_jnl_authors($journalData);
                    $productionUserRoles = overview_productionroles();
                    if (in_array($activeCoreRoleId, $productionUserRoles)) {
                        $allStages = $this->get_production_stages_keys();
                    } else {
                        $allStages = $this->get_all_stages_keys($current_client);
                    }
                    $current_client = $this->current_client;
                    $hide_submission_inprogress_articles = (isset($current_client->functionality->cfty_hide_submission_inprogress_sheetview) && $current_client->functionality->cfty_hide_submission_inprogress_sheetview == 'y') ? TRUE : FALSE;
                    if($hide_submission_inprogress_articles == TRUE)
                    {
                        $key = array_search('author_submission', $allStages);
                        array_splice($allStages, $key, 1);
                    }
                    $wrkFlwStages = $this->get_production_wrk_flw_stages_keys($allStages, $journalData->jnl_id);
                    $flags = $this->get_all_prdn_stage_article_flags($allStages, $journalData);
                // }
                 //$article_type_details = $this->article_type_settings_data($art_type_code, $jnl_id);
                 //get all clasificaciones
                 $term_table = (new \App\Models\Terms())->getTable();
                 $classification_table = (new \App\Models\Classifications())->getTable();
                 //$cls_criteria = "cls_artp_id='{$artp_id}'";
                 $cls_criteria = '';
                 $select = '*';
                 $tables = array(
                     'main_table' => $term_table,
                     'join_table' => array(
                         $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
                     )
                 );
                 $classification_details = Classifications::get_results_using_joins($tables, $select);
                 $res = [];
                 if (count($classification_details) > 0) {
                     foreach ($classification_details as $e) {
                         $this->convertToArr($res, $e);
                     }
                 }
                $classification_treedata=json_decode(json_encode($res));
                $condition = "sosc_user_id=".$current_user['user_id']." AND sosc_jnl_id=".decrypt_link($payloadData['jnl_id']);
                $saved_optional_colums = array();
                $sosc_data = Sheet_view_optional_selected_colums::get_single_record('sosc_id,sosc_colums', $condition);
                if(!empty($sosc_data) && $sosc_data->sosc_colums)
                {
                    $saved_optional_colums = json_decode($sosc_data->sosc_colums);
                }
                $sheet_view_config = 'clients.' . $this->current_client->clnt_client_code . '.sheet_view_config';
                $default_issue_selection = array();
                $config_data = Config::get($sheet_view_config);
                if(isset($config_data['issue_selection']))
                {
                    $default_issue_selection = $config_data['issue_selection'];
                }

                $result['classification_treedata'] = $classification_treedata;
                $result['productionUsers']  = $productionUsers;
                $result['journalAuthors']   = $journalAuthors;
                $result['allStages']   = $wrkFlwStages;
                $result['allFlags']   = $flags;
                $result['default_issue_selection']  = $default_issue_selection;
                $result['saved_optional_colums']  = $saved_optional_colums;
                // $result['article_type_details'] = $this->article_type_settings_data($art_type_code, $jnl_id);
                return $this->success('success', 200, $result);
            }
        } catch (\Exception $e) {

            // $this->customErrorAction('manage_proposal',$e);
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function convertToArr(&$arr, $data)
    {
        if ($data->cls_primary_id == 0)
            return $arr[] =  ["key" => (string)$data->cls_id, "title" => $data->term_name, "children" => []];
        foreach ($arr as &$e) {
            if ($e["key"] == $data->cls_primary_id) {
                $e["children"][] = (["key" => (string)$data->cls_id, "title" => $data->term_name, "children" => []]);
                break;
            }
            $this->convertToArr($e["children"], $data);
        }
    }
    public function getSheetViewData($payloadData, $currentUser, $current_client, $journalData, $downloadStatus, $isProductionUser ,$showPrductionContent ,$dateFormat)
    {
        //setting up relevant Models.
        $articleTransferSuggestionTable = (new \App\Models\Article_transfer_suggestion())->getTable();
        $articleKeywordsTable           = (new \App\Models\Article_keywords())->getTable();
        $KeywordsTable                  = (new \App\Models\Keywords())->getTable();
        $articlesTable                  = (new \App\Models\Articles())->getTable();
        $articleFlowTable               = (new \App\Models\Article_flow())->getTable();
        $issueManagementTable           = (new \App\Models\Issue_management())->getTable();
        $IssuesTable                    = (new \App\Models\Issues())->getTable();
        $genericFlowsTable              = (new \App\Models\Generic_flows())->getTable();
        $volumesTable                   = (new \App\Models\Volumes())->getTable();
        $ArticleFlagTable               = (new \App\Models\Article_flag())->getTable();
        $UserTable                      = (new \App\Models\User())->getTable();
        $ArticleClassificationTable     = (new \App\Models\Article_classification())->getTable();
        $ClassificationTable            = (new \App\Models\Classifications())->getTable();
        $UserTable                      = (new \App\Models\User())->getTable();
        $articlesPerPage                = ($downloadStatus == 'n') ? ($payloadData["per_page"]) : (10000);


        $additionalConditions = array();
        $additionalConditionsArr = array();
        $additionalJoins = array();
        $additionalJoinsArr = array();
        $additinalSelect = array();
        $statusConditions = '';
        $groupBy = '';
        $FilterValidate = TRUE;
        $paramsdet = isset($payloadData['paramsdet']) ? $payloadData['paramsdet'] : NULL;
        $sheet_view_config = 'clients.' . $this->current_client->clnt_client_code . '.sheet_view_config';
        $sheet_view_colums = array();
        $config_data = Config::get($sheet_view_config);
        if($config_data)
        {
            $sheet_view_colums = $config_data['sheet_view_colums'];
        }
        $columns_data = $sheet_view_colums;
 
        if(isset($articlesPerPage) && !empty($articlesPerPage)){
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$articlesPerPage,
                    'type'=> 'number'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
        }
        if(isset($downloadStatus)){
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$downloadStatus,
                    'type'=> 'bflag'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
        }
        // Search with article ID
        if (
            isset($paramsdet['article_id']) && $paramsdet['article_id'] != ''
        ) {
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$paramsdet['article_id'],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            $paramsdet['article_id'] = trim($paramsdet['article_id']);
            // $additionalConditions[] = "AND `art`.`art_code` LIKE '%{$paramsdet['article_id']}%'";
            $additionalConditionsArr[] = array(
                'field_name' => 'art.art_code',
                'condition'  => 'LIKE',
                'searchTerm' => $paramsdet['article_id'],
            );
        }

        // Search with article title
        if (
            isset($paramsdet['article_title']) && $paramsdet['article_title'] != ''
        ) {
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$paramsdet['article_title'],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            $paramsdet['article_title'] = trim($paramsdet['article_title']);
            // $additionalConditions[] = "AND `art`.`art_title` LIKE '%{$paramsdet['article_title']}%'";
            $additionalConditionsArr[] = array(
                'field_name' => 'art.art_title',
                'condition'  => 'LIKE',
                'searchTerm' => $paramsdet['article_title'],
            );
        }

        // Search with article type
        if (isset($paramsdet['article_type']) && $paramsdet['article_type'] != ''){
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$paramsdet['article_type'],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            // $additionalConditions[] = "AND `art`.`art_artp_id` = " . decrypt_link($paramsdet['article_type']);
            $additionalConditionsArr[] = array(
                'field_name' => 'art.art_artp_id',
                'condition'  => '=',
                'searchTerm' =>  decrypt_link($paramsdet['article_type']),
            );
        }
        if(isset($paramsdet['article_status']) && !empty($paramsdet['article_status'])){
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' => $paramsdet['article_status'],
                    'type'=> 'alphabet'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            if (!in_array($paramsdet['article_status'], array('', 'w', 'h'))) {
                if ( $paramsdet['article_status'] == 'y' ) {
                    //Start - TASK #5202 search functionality issue fix.
                    $stage = '';
                    if (isset($paramsdet['all_stages']) && $paramsdet['all_stages'] != '') {
                        $all_stages = trim($paramsdet['all_stages']);
                        if (strpos($all_stages, ',') !== FALSE) {
                            $all_stages = explode(',', $all_stages);
                            $stage = $all_stages[0];
                        }
                    }
                    if($stage != 'author_submission')
                    {
                            $statusConditions = " AND (`art`.`art_status` = 'y' OR `art`.`art_status` IS NULL OR (CASE WHEN art.art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a' END)) AND `art`.`art_delete_status` NOT IN ('w','h')";
                    }
                    //End - TASK #5202 search functionality issue fix.
                } elseif (($paramsdet['article_status'] == 't')) {
                    $additionalConditions[] = "AND ((`art`.`art_transfer_article` = 'y' ) OR ( `art`.`art_transfer_article` = 'n' AND `art`.`art_status` IN ('t') )) "; // AND ats_author_action = 1
                    // $additionalJoins[] = "LEFT JOIN " . $articleTransferSuggestionTable . " ON `ats_art_id` = `art_id`";
                        $additionalJoinsArr[] = array($articleTransferSuggestionTable, 'ats_art_id' , 'art_id');

                } else {
                    if ($paramsdet['article_status'] == 'c' || $paramsdet['article_status'] == 'a') {
                        $statusConditions = " AND `art`.`art_status` = '{$paramsdet['article_status']}' AND `art`.`art_status` !='w' AND `art`.`art_delete_status` !='w' AND `art`.`art_delete_status` !='h'";
                    } 
                    else {
                        $statusConditions = " AND `art`.`art_status` = '{$paramsdet['article_status']}' AND `art`.`art_status` !='w' AND `art`.`art_delete_status` !='w'";
                    }
                }
            } 
            elseif (($paramsdet['article_status'] == 'w' || $paramsdet['article_status'] == 'h'))
                $additionalConditions[] = "AND `art`.`art_delete_status` = '" . $paramsdet['article_status'] . "'";
            else {
                //echo 'else condition';exit;
                $statusConditions      =   "AND (`art`.`art_status` IN('a','r','t','y') OR(
                    CASE WHEN art.art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art.art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a'
                END)) ";
                if ($current_client->modules->mdl_review_for_doc == 'y') {
                    $statusConditions = "AND `art`.`art_status` IN('a','q','y')";
                }
            }
            // echo "<pre>";
            // echo $statusConditions;exit;
        } else {
            $current_client = $this->current_client;
            $hide_submission_inprogress_articles = (isset($current_client->functionality->cfty_hide_submission_inprogress_sheetview) && $current_client->functionality->cfty_hide_submission_inprogress_sheetview == 'y') ? TRUE : FALSE;
            if($hide_submission_inprogress_articles == TRUE)
            {
                $statusConditions      =   "AND (`art`.`art_status` IN('a','r','t','y') OR(
                    CASE WHEN art.art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art.art_status = 'n' THEN (jwf_stage_type = 'resubmission') AND aflw_status = 'a'
                END)) ";
            }
            else
            {
                $statusConditions      =   "AND (`art`.`art_status` IN('a','r','t','y') OR(
                    CASE WHEN art.art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art.art_status = 'n' THEN (jwf_stage_type = 'resubmission' OR jwf_stage_type = 'author_submission') AND aflw_status = 'a'
                END)) ";
            }
            //above status condition commented for reference.
            // $statusConditions      =   "AND (`art`.`art_status` IN('a','r','t','y') OR(
            //     -- CASE WHEN art.art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art.art_status = 'n' THEN (jwf_stage_type = 'resubmission' OR (jwf_stage_type = 'author_submission' AND art_stage_submission_method = 'b')) AND aflw_status = 'a'
            //     CASE WHEN art.art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art.art_status = 'n' THEN (jwf_stage_type = 'resubmission' OR jwf_stage_type = 'author_submission') AND aflw_status = 'a'
            // END)) ";
            if ($current_client->modules->mdl_review_for_doc == 'y') {
                $statusConditions = "AND `art`.`art_status` IN('a','q','y')";
            }
        }
        if (isset($paramsdet['date_selection']) && $paramsdet['date_selection'] != '') {
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$paramsdet['date_selection'],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            if ($paramsdet['date_selection'] == 'sd') {
                if ($paramsdet['submission_date'] != '') {
                    if($FilterValidate == TRUE){
                        $input_arr = array(
                            'input' =>$paramsdet['submission_date'],
                            'type'=> 'string'
                        );
                        $FilterValidate = $this->Rv_validator($input_arr);
                    }
                    $submissionDate = convert_dmy_to_ymd($paramsdet['submission_date'], $journalData->jset_date_format);
                    if ($current_client->modules->mdl_review_for_doc == 'y') {
                        // $additionalConditions[] = "AND `art`.`art_update_last_date` LIKE  '%{$submissionDate}%'";
                        $additionalConditionsArr[] = array(
                            'field_name' => 'art.art_update_last_date',
                            'condition'  => 'LIKE',
                            'searchTerm' =>  $submissionDate,
                        );
                    } else {
                        // $additionalConditions[] = "AND `art`.`art_submission_date` LIKE  '%{$submissionDate}%'";
                        $additionalConditionsArr[] = array(
                            'field_name' => 'art.art_submission_date',
                            'condition'  => 'LIKE',
                            'searchTerm' =>  $submissionDate,
                        );
                    }
                }
            } else {
                if($FilterValidate == TRUE){
                    $input_arr = array(
                        'input' =>$paramsdet['submission_startdate'],
                        'type'=> 'string'
                    );
                    $FilterValidate = $this->Rv_validator($input_arr);
                }
                if($FilterValidate == TRUE){
                    $input_arr = array(
                        'input' =>$paramsdet['submission_enddate'],
                        'type'=> 'string'
                    );
                    $FilterValidate = $this->Rv_validator($input_arr);
                }

                if ($paramsdet['submission_startdate'] != '' && $paramsdet['submission_enddate'] != '') {
                    $submissionStartDate = convert_dmy_to_ymd($paramsdet['subduerangestartdate'], $journalData->jset_date_format);
                    $submissionEndDate   = convert_dmy_to_ymd($paramsdet['subduerangeenddate'], $journalData->jset_date_format);
                    if ($current_client->modules->mdl_review_for_doc == 'y') {
                        // $additionalConditions[] = "AND `art`.`art_update_last_date` BETWEEN '{$submissionStartDate}' AND '{$submissionEndDate}'";
                        $additionalConditionsArr[] = array(
                            'field_name' => 'art.art_update_last_date',
                            'condition'  => 'BETWEEN',
                            'submissionStartDate' =>  $submissionStartDate,
                            'submissionEndDate' =>  $submissionEndDate,
                        );
                    } else {
                        // $additionalConditions[] = "AND `art`.`art_submission_date` BETWEEN '{$submissionStartDate}' AND '{$submissionEndDate}'";
                        $additionalConditionsArr[] = array(
                            'field_name' => 'art.art_submission_date',
                            'condition'  => 'BETWEEN',
                            'submissionStartDate' =>  $submissionStartDate,
                            'submissionEndDate' =>  $submissionEndDate,
                        );
                    }
                }
            }
        }
        // Search with keywords
        $keywordSearchMode = $keywordIds = '';
        if (isset($paramsdet['keywords']) && count($paramsdet['keywords']) > 0){
            if($FilterValidate == TRUE && $paramsdet['keywardOption'] != ''){
                $input_arr = array(
                    'input' =>$paramsdet['keywardOption'],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            $keywordSearchMode = $paramsdet['keywardOption'];
            if ($keywordSearchMode != 'contains'){
                if(!is_array($paramsdet['keywords'])){
                    $FilterValidate = FALSE;
                } else {
                    // print_r($paramsdet['keywords']);die;
                    $keywordIds = trim(implode(',',array_column($paramsdet['keywords'],'id')));
                    if ($keywordSearchMode == 'all') {
                        if (!in_array($keywordIds, array('', null))) {
                            $additionalConditions[] = "AND `ak_keyword_id` IN ({$keywordIds})";
                            $additionalConditions[] = "AND FIND_array_in_all (
                                                    '{$keywordIds}',
                                                    (SELECT GROUP_CONCAT(`ak_keyword_id`)
                                                    FROM " . $articleKeywordsTable . "
                                                    WHERE `ak_art_id` = `art`.`art_id`)
                                                ) = 1";
                            $groupBy = "GROUP BY art_id";
                            $additionalJoinsArr[] = array($articleKeywordsTable, 'ak_art_id' , 'art_id');
                        }
                    }
                    if ($keywordSearchMode == 'any' || $keywordSearchMode == '') {
                        if (!in_array($keywordIds, array('', null))) {
                            $additionalConditions[] = "AND `ak_keyword_id` IN ({$keywordIds})";
                            $groupBy = "GROUP BY art_id";
                            $additionalJoinsArr[] = array($articleKeywordsTable, 'ak_art_id' , 'art_id');
                        }
                    }
                }
            }
            if ($keywordSearchMode == 'contains') {
                if (isset($paramsdet['keywordText']) && $paramsdet['keywordText'] != '') {
                    if($FilterValidate == TRUE){
                        $input_arr = array(
                            'input' =>$paramsdet['keywordText'],
                            'type'=> 'string'
                        );
                        $FilterValidate = $this->Rv_validator($input_arr);
                    }
                    // $additionalConditions[] = "AND `kwd_name` LIKE '%{$paramsdet['keywordText']}%'";
                    $additionalConditionsArr[] = array(
                        'field_name' => 'kwd_name',
                        'condition'  => 'LIKE',
                        'searchTerm' =>  $paramsdet['keywordText'],
                    );
                    $additionalJoinsArr[] = array($articleKeywordsTable, 'ak_art_id', 'art_id');
                    $additionalJoinsArr[] = array($KeywordsTable, 'ak_keyword_id', 'kwd_id');
                }
            }
        }

        $additionalJoinsArr[] = array($articleFlowTable, 'art_id', 'aflw_art_id');
        $additionalJoinsArr[] = array($genericFlowsTable, 'jwf_id', 'aflw_jwf_id');
        $groupBy = "GROUP BY art_id";

        // if ($showPrductionContent == TRUE) {
            $additinalSelect[] = " ,iss_title,ism_art_page_cnt,vol_title";
            $additionalJoinsArr[] = array($issueManagementTable, 'ism_art_id', 'art_id');
            $additionalJoinsArr[] = array($IssuesTable, 'ism_iss_id', 'iss_id');
            $additionalJoinsArr[] = array($volumesTable, 'vol_id', 'iss_vol_id');

            if (isset($paramsdet['all_flags']) && $paramsdet['all_flags'] != '') {
                if($FilterValidate == TRUE){
                    $input_arr = array(
                        'input' =>$paramsdet['all_flags'],
                        'type'=> 'number'
                    );
                    $FilterValidate = $this->Rv_validator($input_arr);
                }
                $paramsdet['all_flags'] = trim($paramsdet['all_flags']);
                // $additionalConditions[] = "AND `aflg_flag_id` = " . $paramsdet['all_flags'];
                $additionalConditionsArr[] = array(
                    'field_name' => 'aflg_flag_id',
                    'condition'  => '=',
                    'searchTerm' =>  $paramsdet['all_flags'],
                );
                $additionalJoinsArr[] = array($ArticleFlagTable, 'aflg_art_id' , 'art_id');
                // $additionalJoins[] = "JOIN " . $ArticleFlagTable . " ON `aflg_art_id` = `art_id`";
            }
            if (isset($paramsdet['author_selection']) && $paramsdet['author_selection'] != '') {
                if(!is_array($paramsdet['author_selection'])){
                    $FilterValidate = FALSE;
                }
                if (!empty($paramsdet['author_selection']) && is_array($paramsdet['author_selection'])){
                    if(count($paramsdet['author_selection'])>0){
                        foreach($paramsdet['author_selection'] as $row){
                            if($FilterValidate == TRUE){
                                $input_arr = array(
                                    'input' =>$row,
                                    'type'=> 'number'
                                );
                                $FilterValidate = $this->Rv_validator($input_arr);
                            }
                        }
                    }
                    // $paramsdet['author_selection'] = implode(',', $paramsdet['author_selection']);
                    $paramsdet['author_selection'] = array_values(array_filter($paramsdet['author_selection']));
                    $additionalConditionsArr[] = array(
                        'field_name' => 'art_submitted_by',
                        'condition'  => 'IN',
                        'searchTerm' =>  $paramsdet['author_selection'],
                    );
                }
            }
            if (isset($paramsdet['assigned_to']) && $paramsdet['assigned_to'] != '') {
                if(!is_array($paramsdet['assigned_to'])){
                    $FilterValidate = FALSE;
                }
                if (!empty($paramsdet['assigned_to']) && is_array($paramsdet['assigned_to'])) {
                    if(count($paramsdet['assigned_to'])>0){
                        foreach($paramsdet['assigned_to'] as $row){
                            if($FilterValidate == TRUE){
                                $input_arr = array(
                                    'input' =>$row,
                                    'type'=> 'number'
                                );
                                $FilterValidate = $this->Rv_validator($input_arr);
                            }
                        }
                    }
                    $paramsdet['assigned_to'] = array_values(array_filter($paramsdet['assigned_to']));
                    // $paramsdet['assigned_to'] = implode(',', $paramsdet['assigned_to']);
                    $additionalConditions[] = " AND `aflw_status` in ('a','u')";
                    $additionalConditionsArr[] = array(
                        'field_name' => 'aflw_usr_id',
                        'condition'  => 'IN',
                        'searchTerm' =>  $paramsdet['assigned_to'],
                    );
                }
            }
            //for production user roles shuch as JP,TSP
            if ($isProductionUser == TRUE) {
                $only_prdn_stages = $this->get_production_stages_keys();
                $additionalConditions[] = 'AND `jwf_stage_type` IN ( \'' . implode('\',\'', $only_prdn_stages) . '\' )';
            }
            if (isset($paramsdet['all_stages']) && $paramsdet['all_stages'] != '') {
                if($FilterValidate == TRUE){
                    $input_arr = array(
                        'input' =>$paramsdet['all_stages'],
                        'type'=> 'string'
                    );
                    $FilterValidate = $this->Rv_validator($input_arr);
                }
                $paramsdet['all_stages'] = trim($paramsdet['all_stages']);
                if (strpos($paramsdet['all_stages'], ',') !== FALSE) {
                    $paramsdet['all_stages'] = explode(',', $paramsdet['all_stages']);
                    $prdn_stages = array();
                    $prdn_stages[] = $paramsdet['all_stages'][0];
                    if (isset($paramsdet['all_stages'][0]) && ($paramsdet['all_stages'][0] == 'publish' || $paramsdet['all_stages'][0] == 'reject')) {
                        //only for publish stage complt status is also included
                        // $additionalConditions[] = "AND `jwf_stage_name` LIKE '%{$paramsdet['all_stages'][1]}%' AND aflw_status IN ('a','u','w','p','c')";
                        $additionalConditions[] = " AND aflw_status IN ('a','u','w','p','c')";
                        $additionalConditionsArr[] = array(
                            'field_name' => 'jwf_stage_name',
                            'condition'  => 'LIKE',
                            'searchTerm' =>  $paramsdet['all_stages'][1],
                        );
                    } else
                        // $additionalConditions[] = "AND `jwf_stage_name` LIKE '%{$paramsdet['all_stages'][1]}%' AND aflw_status IN ('a','u','w','p')";
                        $additionalConditions[] = " AND aflw_status IN ('a','u','w','p')";
                    $additionalConditionsArr[] = array(
                        'field_name' => 'jwf_stage_name',
                        'condition'  => 'LIKE',
                        'searchTerm' =>  $paramsdet['all_stages'][1],
                    );
                }
            }
            if (isset($this->current_client->functionality->cfty_manage_issues) && ($this->current_client->functionality->cfty_manage_issues == 'y') && in_array('iss_title', $columns_data)) {

                if (isset($paramsdet['issue_selection']) && $paramsdet['issue_selection'] != '') {
                    if(!is_array($paramsdet['issue_selection'])){
                        $FilterValidate = FALSE;
                    }
                    else{
                        if(count($paramsdet['issue_selection'])>0){
                            foreach($paramsdet['issue_selection'] as $row){
                                if($FilterValidate == TRUE){
                                    $input_arr = array(
                                        'input' =>$row,
                                        'type'=> 'string'
                                    );
                                    $FilterValidate = $this->Rv_validator($input_arr);
                                }
                            }
                        }
                        $issue_art_query = 'SELECT
                                            GROUP_CONCAT(`ism_art_id`) as ids
                                            FROM
                                            rvw_articles AS `art`
                                            left JOIN
                                            rvw_article_types `artp`
                                            ON
                                            `artp`.`artp_id` = `art`.`art_artp_id`
                                            LEFT JOIN
                                            rvw_issue_management
                                            ON
                                            `ism_art_id` = `art_id`
                                            WHERE
                                            `artp`.`artp_jnl_id` = ' . $journalData->jnl_id . ' AND ism_art_id IS NOT null';

                        if (count($paramsdet['issue_selection']) == 1) {
                            if (in_array('issue_in_progress', $paramsdet['issue_selection'])) {
                                $additionalConditions[] = " AND ism_art_id IS NOT NULL AND iss_status != 'c' ";
                            }
                            if (in_array('issue_closed', $paramsdet['issue_selection'])) {
                                $additionalConditions[] = " AND ism_art_id IS NOT NULL AND iss_status = 'c' ";
                            }
                            if (in_array('not_an_issue', $paramsdet['issue_selection'])) {
                                // $issue_art_ids = Articles::get_records_by_raw_query($issue_art_query);
                                // if (!empty($issue_art_ids[0]->ids))
                                //     $additionalConditions[] = " AND art_id NOT IN (" . $issue_art_ids[0]->ids . ") ";
                                $additionalConditions[] = " AND ism_art_id IS NULL";
                            }
                            if (in_array('special_issue', $paramsdet['issue_selection'])) {
                                $additionalConditions[] = " AND art_publication_issue IS NOT NULL AND art_publication_issue!=0 ";
                            }
                        } elseif (count($paramsdet['issue_selection']) == 2) {
                            $issue_condi = '';
                            if (in_array('issue_in_progress', $paramsdet['issue_selection']) && in_array('issue_closed', $paramsdet['issue_selection'])) {
                                $additionalConditions[] = " AND ism_art_id IS NOT NULL ";
                            }
                            if (in_array('issue_in_progress', $paramsdet['issue_selection']) && in_array('not_an_issue', $paramsdet['issue_selection'])) {
                                $issue_art_ids = Articles::get_records_by_raw_query($issue_art_query);
                                // if (!empty($issue_art_ids[0]->ids)) {
                                //     $issue_condi = " OR (art_id NOT IN ( " . $issue_art_ids[0]->ids . ")) ";
                                // }
                                // $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status != 'c' ) " . $issue_condi . ") ";
                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status != 'c' ) OR ism_art_id IS NULL)";
                            }
                            if (in_array('issue_closed', $paramsdet['issue_selection']) && in_array('not_an_issue', $paramsdet['issue_selection'])) {
                                $issue_art_ids = Articles::get_records_by_raw_query($issue_art_query);
                                // if (!empty($issue_art_ids[0]->ids)) {
                                //     $issue_condi = " OR (art_id NOT IN ( " . $issue_art_ids[0]->ids . ")) ";
                                // }
                                // $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status = 'c' ) " . $issue_condi . ") ";
                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status = 'c' ) OR ism_art_id IS NULL) ";
                            }


                            if (in_array('issue_in_progress', $paramsdet['issue_selection']) && in_array('special_issue', $paramsdet['issue_selection'])) {
                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status != 'c') OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0 ))";
                            }
                            if (in_array('special_issue', $paramsdet['issue_selection']) && in_array('not_an_issue', $paramsdet['issue_selection'])) {
                                // $issue_art_ids = Articles::get_records_by_raw_query($issue_art_query);
                                // $additionalConditions[] = " AND ((art_id NOT IN (" . $issue_art_ids[0]->ids . ")) OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0 ))";
                                $additionalConditions[] = " AND (ism_art_id IS NULL OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0 ))";
                            }
                            if (in_array('issue_closed', $paramsdet['issue_selection']) && in_array('special_issue', $paramsdet['issue_selection'])) {

                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status = 'c')  OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0))";
                            }
                        } elseif (count($paramsdet['issue_selection']) == 3) {
                            if (in_array('issue_in_progress', $paramsdet['issue_selection']) && in_array('issue_closed', $paramsdet['issue_selection']) && in_array('special_issue', $paramsdet['issue_selection'])) {
                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL) OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0)) ";
                            }
                            if (in_array('issue_in_progress', $paramsdet['issue_selection']) && in_array('not_an_issue', $paramsdet['issue_selection']) && in_array('special_issue', $paramsdet['issue_selection'])) {
                                // $issue_art_ids = Articles::get_records_by_raw_query($issue_art_query);
                                // $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status != 'c' ) OR (art_id NOT IN ( " . $issue_art_ids[0]->ids . ")) OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0)) ";
                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status != 'c' ) OR (ism_art_id IS NULL) OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0)) ";
                            }
                            if (in_array('issue_closed', $paramsdet['issue_selection']) && in_array('not_an_issue', $paramsdet['issue_selection']) && in_array('special_issue', $paramsdet['issue_selection'])) {
                                // $issue_art_ids = Articles::get_records_by_raw_query($issue_art_query);
                                // $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status = 'c' ) OR (art_id NOT IN ( " . $issue_art_ids[0]->ids . ")) OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0)) ";
                                $additionalConditions[] = " AND ((ism_art_id IS NOT NULL AND iss_status = 'c' ) OR (ism_art_id IS NULL) OR (art_publication_issue IS NOT NULL AND art_publication_issue!=0)) ";
                            }
                            if (in_array('issue_in_progress', $paramsdet['issue_selection']) && in_array('issue_closed', $paramsdet['issue_selection']) && in_array('not_an_issue', $paramsdet['issue_selection'])) {
                                //$additionalConditions[] = " AND ism_art_id IS NOT NULL ";
                                $additionalConditions[] = " AND (ism_art_id IS NOT NULL OR ism_art_id IS NULL)";
                            }
                        }
                    }
                }
            }

            if (isset($paramsdet['classifications']) && count($paramsdet['classifications']) > 0) {
                $classification_articles = array();
                $criteria = 'rvw_classifications.cls_id IN ('.join(",",$paramsdet['classifications']).')';
                $select_fields = "$ArticleClassificationTable.arcls_art_id";
                $tables = array(
                    'main_table' =>  $ClassificationTable,
                    'join_table' => array(
                        $ArticleClassificationTable => array($ArticleClassificationTable . '.arcls_cls_id', $ClassificationTable . '.cls_id')
                    )
                );
                $result_obj = Classifications::get_results_using_joins($tables, $select_fields, $criteria, 'all');
                foreach($result_obj as $data)
                {
                    $classification_articles[] = $data->arcls_art_id;
                }
                if(count($classification_articles) > 0)
                {
                    $additionalConditions[] = " AND art_id IN ( ".join(",",$classification_articles)." ) ";
                }
                else
                {
                    $additionalConditions[] = " AND art_id ='' ";
                }
            }
        // }

        $orderbyField = '';
        if (isset($payloadData["sort_field"]) && !empty($payloadData["sort_field"])) {
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$payloadData["sort_field"],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            $allowedSortFields = array(
                'art_code',
                'art_title',
                'artp_article_type',
                'art_submitted_by',
                'art_submission_date',
                'original_status',
                'iss_title',
                'start_date',
                'due_date',
                'art_decision_date',
                'art_epub_date'

            );
            if(!in_array($payloadData["sort_field"], $allowedSortFields)){
                $payloadData["sort_field"] = $allowedSortFields[0];
            }
            if ($payloadData["sort_field"] != 'start_date' && $payloadData["sort_field"] != 'due_date') {
                $orderbyField = $payloadData["sort_field"] . ' ';
            } else {
                if ($payloadData["sort_field"] == 'start_date') {
                    $sortColName  = 'aflw_assigned_date';
                } else {
                    $sortColName  = 'aflw_due_date';
                }
            }
            if($payloadData["sort_field"] == 'art_submitted_by') {
                $orderbyField = 'usr_first_name ';
                $additionalJoinsArr[] = array($UserTable, 'art_submitted_by', 'usr_id');
            }
        }
        if (isset($sortColName) && !empty($sortColName)) {
            $orderbyField = ' (SELECT DATE(' . $sortColName . ')
                FROM ' . $articleFlowTable . '
                JOIN `rvw_journal_workflows` ON `jwf_id` = `aflw_jwf_id`
                WHERE `aflw_art_id` = art_id AND ' . $sortColName . ' IS NOT NULL AND(
                    (
                    aflw_status IN(\'a\', \'u\', \'p\', \'w\')
                    ) OR(
                    `aflw_status` IN(\'c\') AND (jwf_stage_type = \'publish\' || jwf_stage_type = \'reject\' || jwf_stage_type = \'transit\' )
                    )
                ) ORDER BY `aflw_id` DESC LIMIT 0,1) ';
        }
        // Setting orderby
        $orderbyMode = '';
        if (isset($payloadData["sort_order"]) && !empty($payloadData["sort_order"])){
            if($FilterValidate == TRUE){
                $input_arr = array(
                    'input' =>$payloadData["sort_order"],
                    'type'=> 'string'
                );
                $FilterValidate = $this->Rv_validator($input_arr);
            }
            $allowedSortOrder = array(
                'asc',
                'desc'
            );
            if(!in_array($payloadData["sort_order"], $allowedSortOrder)){
                $orderbyMode = $allowedSortOrder[0];
            }else{
                $orderbyMode = $payloadData["sort_order"];
            }
        }

        if($FilterValidate == FALSE){
            $arraymsg['message'] = customTrans('viewarticle.invalid_data');
            $arraymsg['status'] = 'failed';
            return $arraymsg;
        }
        //Blinding article
        $current_user = $this->get_current_user_details();
        $blinded_articles = $this->get_blinded_articles($current_user['user_id']);
        if(!empty($blinded_articles))
        {
            $additionalConditions[] = " AND art_id NOT IN ( ".$blinded_articles." ) ";
        }


        $additionalConditions = implode(' ', $additionalConditions);
        $additionalJoins = implode(' ', $additionalJoins);
        $additinalSelect = implode(' ', $additinalSelect);

        $find_flowid_sql = ' ,(SELECT concat(aflw_id,\'##\',jwf_stage_type) FROM ' . $articleFlowTable . ' JOIN ' . $genericFlowsTable . ' ON jwf_id = aflw_jwf_id WHERE `art`.`art_id` = `aflw_art_id` ORDER BY FIELD(aflw_status, "c", "p", "w", "u", "a") DESC,aflw_id DESC LIMIT 0,1) AS aflow_sgtype_column';

        /* (SELECT GROUP_CONCAT(`art2`.`art_code`)
        FROM " . $articlesTable . " AS `art2`
        WHERE FIND_IN_SET (`art2`.`art_id`,`art`.`art_pre_all_ids`) ) */
        /*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
        $select = "
            art_id,
            aflw_id,
            art_code,
            art_title,
            art_artp_id,
            art_epub_date,
            jwf_stage_type,
            art_submitted_by,
            art_delete_status,
            art_status as original_status,
            DATE_FORMAT(art_decision_date, '" . $dateFormat . "') as decision_date,
            DATE_FORMAT(art_epub_date, '" . $dateFormat . "') as epub_date,
            `art`.`art_pre_all_ids` AS `prev_art_codes`,
            (
                SELECT GROUP_CONCAT(REPLACE(REPLACE(kwd_name,'&AMP;','&'),'&amp;','&') SEPARATOR ',  ')
                FROM " . $KeywordsTable . "
                WHERE `kwd_id` IN (
                    SELECT `ak_keyword_id`
                    FROM " . $articleKeywordsTable . "
                    WHERE `ak_art_id` = `art`.`art_id`
                )
            ) AS `keywords`,
            DATE_FORMAT(art_submission_date, ' " . $dateFormat . "') as submitted_date,
            DATE_FORMAT(art_update_last_date, ' " . $dateFormat . "') as last_updated_date,
            artp_article_type, tb1.author_list as author_list {$additinalSelect}{$find_flowid_sql}";
            /* END TASK #3755 Modification in adhoc email to load the 'View Article' link with its content */
        $criteria = "artp.artp_jnl_id = {$journalData->jnl_id} AND art_submitted_by IS NOT NULL
        AND art_delete_status != 'y' and FIND_array_intersect('" . $currentUser['user_id'] . "',author_list )=0 {$statusConditions}{$additionalConditions}";
        DB::enableQueryLog();
        $articleDetails = Articles::sheet_view_paginated_records($select, $criteria, $additionalJoinsArr, NULL, 'art_id', $orderbyField, $orderbyMode, $articlesPerPage, $additionalConditionsArr);
        $queries = DB::getQueryLog();
	    // $query = end($queries);
        // print_r($query);exit;
        foreach($articleDetails['article_result'] as $key => $data)
        {
            $article_classification = array();
            $condition ="arcls_art_id =:art_id";
            $checkBoxData = Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,NULL,'',NULL,array('art_id'=>$data->art_id));
            if(!empty($checkBoxData->checkData)){
                $article_classification = json_decode(json_encode(explode(',', $checkBoxData->checkData)));
            }
            $data->classification = $article_classification;
        }
        return $articleDetails;
    }
    public function modifyArticleStatus(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'mode'   => 'required',
                'selectedArticle' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } else {
                $payloadData = $request->all();
                $current_user = $this->get_current_user_details();
                $art_id = decrypt_link($payloadData['selectedArticle']['encrypt_art_id']);
                $artp_id = decrypt_link($payloadData['selectedArticle']['artp_id']);
                $jnl_id = decrypt_link($payloadData['selectedArticle']['jnl_id']);
                $jnl_code = $payloadData['selectedArticle']['jnl_code'];
                if(isset($payloadData['clickbtn']) && $payloadData['clickbtn'] == 'todolist'){
                    $jnl_code = $payloadData['selectedArticle']['jnl_journal_code'];
                }
                $condition = 'art_id =' . $art_id;
                $mode = $payloadData['mode'];
                $art_details = array(
                    'art_id' => $art_id,
                    'artp_id' => $artp_id,
                    'jnl_id' => $jnl_id,
                    'jnl_code' => $jnl_code,
                    'core_role' => $payloadData['core_role'],
                    'role_name' => $payloadData['role_name'],
                );
                if($mode == 'delete' || $mode == 'withdraw' || $mode == 'hold'){
                    $actionReason = $payloadData['reason'];
                    $delete_reasons =  UtilityTrait::Utility('reason_to_delete_article')['reason_to_delete_article'];
                    $reason = $actionReason['actionReason'];
                    if ($reason == 'c'){
                        $reason = $actionReason['otherReason'];
                    } else {
                        $reason = (isset($delete_reasons[$reason])) ? $delete_reasons[$reason] : $reason;
                    }
                    $delete_status = $mode == 'delete' ? 'y' : ($mode == 'withdraw' ? 'w' : ($mode == 'hold' ? 'h' : ''));

                    $update_array = array(
                        'art_delete_status' => $delete_status,
                        'art_delete_reason' => $reason,
                        'art_deleted_by' => $current_user['user_id'],
                        'art_deleted_date' => date('Y-m-d H:i:s')
                    );
                    DB::beginTransaction();
                    if($mode=="hold"){
                        Articles::update_record($update_array, $condition, $current_user);
                    } else {
                        $this->update_article_data($art_id, $update_array, $current_user);
                    }
                    if ($mode == 'delete'){
                        $this->update_last_invitaion_date($art_id, $current_user);
                    }
                    DB::commit();
                    if ($mode == 'delete'){
                        $this->send_email_article_delete_status($art_details, 'delete_article');
                        $undo_class = 'undo';
                    }
                    if ($mode == 'withdraw')
                    {
                        DB::beginTransaction();
                        $this->manange_article_auto_decline_invitation($art_id);
                        DB::commit();
                        $etmp_name = 'withdraw_article_author';
                        $this->send_email_article_delete_status($art_details, $etmp_name,$reason);
                        $undo_class = 'undo_withdraw';
                    }
                    elseif($mode == 'hold')
                    {
                        $undo_class = 'undo_hold';
                    }
                    $rtn_arr = array(
                        'msg' => ($mode == 'hold' ? customTrans('sheetView.article_hold_success') : ($mode == 'withdraw' ? customTrans('sheetView.article_withdraw_success') : customTrans('sheetView.article_delete_success'))),
                        'undoChange' => $undo_class
                    );
                    $es_article = false;
                    $esarray['article_id']=$art_id;
                    $checkdata=$this->check_espermission_access($esarray);
                    if($checkdata==true)
                    {                 
                        $es_article = true;
                        $aflw_ids = Article_flow::get_single_record_with_bind_cond('GROUP_CONCAT(aflw_id) as aflw_id_list ', array('aflw_art_id' => $art_id));
                        $rtn_arr['redirect_flows'] = $aflw_ids->aflw_id_list;
                        $rtn_arr['redirect_msg'] = 'Proposal status has been changed.';
                    }
                    $rtn_arr['es_article'] = $es_article;
                    return $this->success('success', 200, $rtn_arr);

                    // print_r($art_details);die;
                }
                elseif($mode == 'undo' || $mode == 'undo_withdraw' || $mode == 'undo_hold')
		        {
        			$condition = ' art_id =' . $art_id;
                    $my_tak = FALSE;
                    $userRoles = $this->validate_user_journal($jnl_code, $current_user['user_id']);
                    if (!in_array('journal_admin', $userRoles['assigned_roles']))
                    {
                        $my_tak = TRUE;
                    }
                    $update_array = array(
                        'art_delete_status' => 'n',
                        'art_delete_reason' => NULL,
                        'art_deleted_by' => NULL,
                        'art_deleted_date' => NULL
                    );
                    $data = '';
                    $msg = '';
                    if ($mode == 'undo')
                    {
                        $date_format=$this->get_platform_date_format($jnl_id);
	                    $date_format= $this->date_format_map($date_format);
                        $select_data=$this->select_sql($date_format);

                        // print_r($select_data);die;
                        // // Articles::trans_start();
                        $this->update_article_data($art_id, $update_array, $current_user);
                        $this->update_last_invitaion_date($art_id, $current_user, 'undo');


                        $this->send_email_article_delete_status($art_details, 'undo_delete_article');
                        $msg = customTrans('sheetView.article_recovered');
                    }
                    if ($mode == 'undo_withdraw')
                    {
                        $this->update_article_data($art_id,$update_array, $current_user);
                        $this->send_email_article_delete_status($art_details, 'undo_withdraw_article_author');
                        $msg = customTrans('sheetView.article_recovered');
                    }
                    elseif($mode == 'undo_hold')
                    {
                        Articles::update_record($update_array, $condition, $current_user);
                        //$this->update_article_data($art_id,$update_array);
                        $msg = customTrans('sheetView.article_released');
                    }
                    $rtn_arr = array(
                        'msg' => $msg
                    );
                    return $this->success('success', 200, $rtn_arr);
                }
            }

        } catch (\Exception $e) {
            // $this->customErrorAction('manage_proposal',$e);
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function update_article_data($article_id, $update_array, $current_user)
	{
		$condition = 'art_id=' . $article_id;
		Articles::update_record($update_array, $condition, $current_user);
		$article_detail = Articles::get_single_record('art_pre_all_ids', $condition);
		if (isset($article_detail->art_pre_all_ids) && $article_detail->art_pre_all_ids != NULL)
		{
			$previous_ids = explode(',', $article_detail->art_pre_all_ids);
			if (!empty($previous_ids))
			{
				foreach ($previous_ids as $pre)
				{
					$pre_condition = 'art_id =' . $pre;
					Articles::update_record($update_array, $pre_condition, $current_user);
				}
			}
		}
		$resubmitted_articles = Articles::get_all_records('art_id', 'SUBSTRING_INDEX(art_pre_all_ids, ",", 1) =' . $article_id);
		if (!empty($resubmitted_articles))
		{
			foreach ($resubmitted_articles as $re)
			{
				$resub_condition = 'art_id=' . $re->art_id;
				Articles::update_record($update_array, $resub_condition, $current_user);
			}
		}
	}
    public function update_last_invitaion_date($article_id, $current_user ,$type = 'delete')
	{
		$article_flow = Article_flow::get_all_records('aflw_usr_id', 'aflw_art_id =' . $article_id . ' AND aflw_usr_id IS NOT NULL');
		$user_ids = array();
		if (!empty($article_flow)){
			foreach ($article_flow as $af){
				$user_ids[] = $af->aflw_usr_id;
			}
		}
		if ($type == 'undo'){
            $article_id = NULL;
		}
		$user_latest_invitation_data = User::get_user_last_invite_list($article_id, $user_ids);
		foreach ($user_latest_invitation_data as $user_list)
		{
            if ($user_list->last_invitation_date != '')
			{
				User::update_record(array(
					'usr_last_review_invite' => $user_list->last_invitation_date), 'usr_id =' . $user_list->usr_id, $current_user);
			}
		}
	}
    public function send_email_article_delete_status($article_details, $etmp_name, $reason=""){
        $send_to_privileged_users = FALSE;
        $current_user = $this->get_current_user_details();
        if ($etmp_name == 'withdraw_article_author' || $etmp_name == 'undo_withdraw_article_author'){
            $record = Email_templates::get_single_record('*', "etmp_name ='" . $etmp_name . "' AND etmp_notification =" . "'Author'");
            $send_to_privileged_users = TRUE;
        } elseif($etmp_name == 'author_withdrawal') {
			$record = Email_templates::get_single_record('*', "etmp_name ='" . $etmp_name . "'");
		}
        else {
            $record = Email_templates::get_single_record("*", "etmp_name = '" . $etmp_name . "' AND etmp_notification =" . "'Journal Admin'");
        }

        if ($record != NULL)
		{
			$cfty_retire_role = FALSE;
			if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
			{
				$cfty_retire_role = TRUE;
			}
                        // print_r($article_details);die;
            $send_mail_to_detail = $this->send_email_to($record->etmp_notification, $article_details['jnl_code'], $article_details['artp_id'], $article_details['art_id'], $cfty_retire_role);
            if(isset($send_mail_to_detail)){
                $send_mail_to_ids = $send_mail_to_detail['email_ids'];
                $send_mail_to_ids = explode(',', $send_mail_to_ids);
                $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                $send_mail_to_usr_ids = explode(',', $send_mail_to_usr_ids);
                for ($i=0; $i < count($send_mail_to_ids); $i++) {
                    $custom_data = array(
                        'user_email' => $send_mail_to_ids[$i],
                        'article_id' => $article_details['art_id'],
                        'withdraw_reason'   => $reason,
                        'jnl_id'=> $article_details['jnl_id'],
                        'jnl_code'=> $article_details['jnl_code'],
                        'artp_id'=> $article_details['artp_id'],

                    );
                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => TRUE,
                        'user_id' => $send_mail_to_usr_ids[$i],//$current_user['user_id']
                        'empt_name' => $etmp_name,
                        'jnl_user_role'=>array(
                          'core_role'=>$article_details['core_role'],
                          'role_name'=>$article_details['role_name'],
                          'jnl_journal_code'=> $article_details['jnl_code']
                      ),
                        'custom_data' => $custom_data
                    );
                    $this->master_email_details($email_data);
                }
            }

            if ($send_to_privileged_users === TRUE) {
                if ($etmp_name == 'withdraw_article_author'){
                    $record = Email_templates::get_single_record("*", "etmp_name = 'withdraw_article_privileged'");
                }
                if ($etmp_name == 'undo_withdraw_article_author'){
                    $record = Email_templates::get_single_record("*", "etmp_name = 'undo_withdraw_article_privileged'");
                }
                if ($record != NULL ){
                    $send_mail_to_detail = $this->get_sendto_roles_in_article($article_details['art_id'],$record->etmp_notification,$article_details['artp_id']);
                    if(isset($send_mail_to_detail))
                    {
                        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
                        $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
                        $send_mail_to_ids = $send_mail_to_detail['email_ids'];
                        $send_mail_to_ids = explode(',', $send_mail_to_ids);
                        $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                        $send_mail_to_usr_ids = explode(',', $send_mail_to_usr_ids);

                        for ($i=0; $i < count($send_mail_to_ids); $i++) {
                            $custom_data = array(
                                'user_email' => $send_mail_to_ids[$i],
                                'article_id' => $article_details['art_id'],
                                'etmp_notification' => $record->etmp_notification,
                                'withdraw_reason'   => $reason,
                                'jnl_id'=> $article_details['jnl_id'],
                                'jnl_code'=> $article_details['jnl_code'],
                                'artp_id'=> $article_details['artp_id']
                            );
                            if(isset($article_details['artp_id']) && !empty($article_details['artp_id'])) {
                                $custom_data['artp_id'] = $article_details['artp_id'];
                            } //TASK #5630 Implement an option within the sheet view to recover a withdrawn article. withdraw bugfix
                            $email_data = array(
                                'type'      => 'global',
                                'action'    => 'send',
                                'email_with_login' => TRUE,
                                'user_id'   => $send_mail_to_usr_ids[$i],
                                'empt_name' => $record->etmp_name,
                                'jnl_user_role'     =>array(
                                'core_role'         =>$article_details['core_role'],
                                'role_name'         =>$article_details['role_name'],
                                'jnl_journal_code'  => $article_details['jnl_code']
                            ),
                                'custom_data' => $custom_data
                            );
                            $this->master_email_details($email_data);
                        }
                    }
                }
            }
        }
    }
    public function get_sendto_roles_in_article($article_id,$to_role_name,$artp_id)
	{
        $authorsTable       = (new \App\Models\Authors())->getTable();
        $usersFlag          = (new \App\Models\User())->getTable();
        $articleFlowFlag    = (new \App\Models\Article_flow())->getTable();
        $GenericFlowsFlag    = (new \App\Models\Generic_flows())->getTable();

        if($to_role_name == 'article_authors')
		{
			$tables = array(
				'main_table' => $authorsTable,
				'join_table' => array(
					$usersFlag => array($usersFlag.'.usr_id', $authorsTable . '.auth_usr_id', "left")
				));
			$select_fields ='GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS auth_email, GROUP_CONCAT(`auth_usr_id` SEPARATOR ", ") AS usr_ids';
			$criteria = 'auth_art_id =' . $article_id;
			$corresp_author = Authors::get_results_using_joins($tables,$select_fields,$criteria,'single');

			if(!empty($corresp_author))
			{
				$user_email = $corresp_author->auth_email;
				$user_ids = $corresp_author->usr_ids;
				return array('email_ids'=>$user_email,'usr_ids'=>$user_ids);
			}
		}

		$role = Roles::get_single_record("role_id,role_assigned_role","role_name='" . $to_role_name . "'");
		if(isset($role->role_id))
		{
            $role_id = $role->role_id;
			$user_article_ids = array();
			if($role->role_assigned_role == 'journal_admin')
			{
                $user_journals = User_to_journals::get_all_records('usrj_usr_id','usrj_artp_id =' . $artp_id . ' AND usrj_role_id=' . $role_id);
				if(!empty($user_journals))
				{
					$user_article_ids = array_filter(array_column(json_decode(json_encode($user_journals), TRUE), 'usrj_usr_id'));
				}
			}

			$select = 'aflw_usr_id';
			$art_flw_tables = array(
				'main_table' => $articleFlowFlag,
				'join_table' => array(
					$GenericFlowsFlag => array($GenericFlowsFlag.'.jwf_id', $articleFlowFlag . '.aflw_jwf_id', "left")
			));
			$art_flw_criteria = 'aflw_art_id=' . $article_id . ' AND jwf_role_id =' . $role_id;
			$artcle_flow = Article_flow::get_results_using_joins($art_flw_tables, $select,$art_flw_criteria, 'all');
			$artcle_flow_usr_ids = array();
			if(!empty($artcle_flow))
			{

				$artcle_flow_usr_ids = array_filter(array_column(json_decode(json_encode($artcle_flow), TRUE), 'aflw_usr_id'));
			}
			$user_ids = array_filter(array_unique(array_merge($artcle_flow_usr_ids,$user_article_ids)));


			if(!empty($user_ids))
			{
				$select = 'GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids';
				$users = User::get_single_record($select, 'usr_id IN ('.join(",",$user_ids).')');
				return array('email_ids'=>$users->usr_email,'usr_ids'=>$users->usr_ids);
			}
		}
	}
    public function manange_article_auto_decline_invitation($article_id)
    {

        $current_user = $this->get_current_user_details();
        $client = $this->current_client;
        $current_stage = FALSE;
        //Decline all active invitation and review on withdrawn
        $article_flow_child_data['aflw_status'] = 'd';
        $article_flow_child_data['aflw_remarks'] = 'onwithdrawn';
        $article_flow_child_data['aflw_returned_date'] = date('Y-m-d H:i:s');

        $article_flow_child_condition = 'aflw_art_id =' . $article_id . ' AND aflw_parent_flow_id IS NOT NULL AND aflw_status = "i"';

        $decline_flow_records = Article_flow::get_all_records('aflw_id,aflw_usr_id', $article_flow_child_condition);

        Article_flow::update_record($article_flow_child_data, $article_flow_child_condition, $current_user);

        $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept, artp_id,jnl_journal_code,jnl_id,art_article_upload_path';
        $article_details = Articles::get_article_details($select, 'art_id =' . $article_id . " AND art_delete_status ='w'", null);

        $article_details = $article_details[0];
        if (sizeof($decline_flow_records) > 0) {
            foreach ($decline_flow_records as $invited) {
                //Email_templates
                $email_template = Email_templates::get_single_record('*', "etmp_name ='auto_decline_invitation' AND etmp_notification ='User'");
                $this->send_unassign_email_workflow($email_template, $article_details, $invited->aflw_usr_id, $client, $current_user, $current_stage,'etmp_');
            }
        }

        // Unassign all accepted reviews on decision

        $unassign_flow_child_condition = 'aflw_art_id =' . $article_id . ' AND aflw_parent_flow_id IS NOT NULL' . " AND aflw_status = 'a'";
        $unassign_flow_records = Article_flow::get_all_records('aflw_parent_flow_id,aflw_id,aflw_usr_id,aflw_jwf_id', $unassign_flow_child_condition);

        Article_flow::update_record(array('aflw_status' => 'g'), $unassign_flow_child_condition, $current_user);

        $eselect = 'stage_etmp_id, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content AS stage_etmp_email_template, stage_etmp_journal_id,stage_etmp_action,setr_id';
        if (!empty($unassign_flow_records)) {
            foreach ($unassign_flow_records as $unas) {
                $insert_data = array(
                    'unsn_reason' => 'Auto unassign',
                    'unsn_rvr_id' => $unas->aflw_usr_id,
                    'unsn_aflw_id' => $unas->aflw_id
                );

                $article_details->aflw_id = $unas->aflw_parent_flow_id;

                Unassign_reviewer::insert_record($insert_data, $current_user);

                if (isset($stage_email_ids['unassign']) && !empty($stage_email_ids['unassign'])) {
                    $condition = 'setr_jwf_id = ' . $unas->aflw_jwf_id . ' AND setr_id in (' . join(",", $stage_email_ids['unassign']) . ' ) AND stage_etmp_action = "unassign_user"';
                    $email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger($eselect, $condition);
                    if (!empty($email_templates)) {
                        foreach ($email_templates as $email_template) {
                            $this->send_unassign_email_workflow($email_template, $article_details, $unas->aflw_usr_id, $client, $current_user, $current_stage, 'stage_etmp_');
                        }
                    }
                }
            }
        }
    }
    public function get_current_stage_details_for_sheet_view($art_id,$journalData,$download_status='n'){
        $clientCode = $this->current_client->clnt_client_code;
        $workflow_config = 'clients.' . $clientCode . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $jset_date_format =  $this->get_platform_date_format($journalData->jnl_id);
        if (isset($jset_date_format) && !empty($jset_date_format)) {
            $date_format_org = $jset_date_format;
        } else {
            $date_format_org = $this->current_client->settings->cs_date_format;
        }
        $dateFormat = date_format_map($date_format_org);

        $articleFlowTable   = (new \App\Models\Article_flow())->getTable();
        $articlesTable      = (new \App\Models\Articles())->getTable();
        $genericFlowsTable  = (new \App\Models\Generic_flows())->getTable();
        $UserTable          = (new \App\Models\User())->getTable();
        $rolesTable         = (new \App\Models\Roles())->getTable();

        $rtn_arr = array(
            'crnt_stg' => '',
            'crnt_stg_dts' => '',
            'crnt_stg_due_dts' => '',
            'crnt_stg_assign_to' => '',
            'crnt_status_link' => ''
        );
        $escape_hash = '</br>';
        $main_array = array();
        $stage_arr = array();
        $start_date_arr = array();
        $due_date_arr = array();
        $stage_assign_to_arr = array();
        $stage_assign_to_roles_arr = array();
        $assign_roles = array();
        $full_name_only = FALSE;
        $due_date_expired_cls = '';
        $expired_remaining = '';
        $status_link = '';
        $select_fields = 'art_delete_status,art_delete_reason,aflw_id,aflw_parent_flow_id,aflw_art_id,aflw_status,aflw_jwf_id,aflw_stage_max_users,aflw_accepted_date,'
                    . 'jwf_stage_name,jwf_stage_type,jwf_tat_complete,'
                    . 'DATE_FORMAT(aflw_assigned_date, \' ' . $dateFormat . '\') as started_date,'
                    . 'DATE_FORMAT(aflw_due_date, \' ' . $dateFormat . '\') as due_date,'
                    . 'aflw_usr_id,role_name,role_assigned_role,'
                    . 'DATEDIFF(`aflw_due_date`, NOW()) AS rvd_remaining_days,aflw_returned_date';
        $search_criteria = 'aflw_art_id = ' . $art_id . ' AND ((aflw_status IN (\'a\',\'u\',\'p\',\'w\')  AND (jwf_stage_type != \'review\' OR ( jwf_stage_type = \'review\' AND aflw_status IN (\'a\',\'w\') ) ) ) OR ( aflw_status IN (\'c\') AND (jwf_stage_type IN (\'publish\') || (art_status = \'r\' AND jwf_stage_type = \'reject\') || (art_status = \'c\' AND jwf_stage_type = \'transit\' ))))';

        $tables = array(
            'main_table' => $articleFlowTable,
            'join_table' => array(
                $articlesTable => array($articlesTable.'.art_id', $articleFlowTable . '.aflw_art_id', "left"),
                $genericFlowsTable => array($genericFlowsTable.'.jwf_id', $articleFlowTable . '.aflw_jwf_id', "left"),
                $UserTable => array($UserTable.'.usr_id', $articleFlowTable . '.aflw_usr_id', "left"),
                $rolesTable => array($rolesTable.'.role_id', $genericFlowsTable . '.jwf_role_id', "left"),
            ));
        $crnt_stg_dets = Article_flow::get_results_using_joins($tables,$select_fields,$search_criteria,'all','aflw_id DESC');
        // print_r( $crnt_stg_dets);die;
        if(!empty($crnt_stg_dets))
        {
            $i=0;
            foreach($crnt_stg_dets as $each_stag)
            {
                if($each_stag->aflw_status == 'p')
                {
                    $mini_assign_user = Article_flow::get_single_record('count(aflw_id) as cnt','aflw_art_id =' . $each_stag->aflw_art_id . ' AND aflw_jwf_id =' . $each_stag->aflw_jwf_id . ' AND aflw_status != \'p\'');
                    if($mini_assign_user->cnt > 0)
                    {
                        continue;
                    }
                }

                if($each_stag->rvd_remaining_days < 0 && $each_stag->aflw_returned_date == NULL)
                {
                    $due_date_expired_cls = 'exp_cls';
                    $expired_remaining = ' (' .abs($each_stag->rvd_remaining_days) . " days overdue" . ')';
                }
                if(empty($each_stag->due_date))
                {
                    // $due_date = new \DateTime($each_stag->aflw_accepted_date);
                    // $due_date = $due_date->modify('+' . $each_stag->jwf_tat_complete . ' days');
                    // $due_date = $this->get_due_date_for_article($each_stag->aflw_art_id, $each_stag->jwf_tat_complete, $date_format_org);
                    $each_stag->due_date = $this->get_due_date_for_article($each_stag->aflw_art_id, $each_stag->jwf_tat_complete, $date_format_org);
                }

                //#2582 Switch the link from article ID to current stages
                $popovr_type = 'view_article';
                $popovr_content = '';
                $delete_stats = array('h','w');
                if(in_array($each_stag->art_delete_status,$delete_stats))
                {
                    $popovr_type = ($each_stag->art_delete_status == 'w')?'withdrawn_article':'holded_article';
                    $popovr_content = $each_stag->art_delete_reason;
                }

                $redirect_base_url = URL::to('/');
                $aflw_id =  ( $each_stag->aflw_parent_flow_id != NULL) ? $each_stag->aflw_parent_flow_id : $each_stag->aflw_id ;
                $status_link =  $redirect_base_url.'/'. $this->current_client->platform_type.'/'. $journalData->jnl_journal_code . '/view-article/' . $this->encrypt_data($art_id) .'/'. $this->encrypt_data($aflw_id);
                $start_date_arr[] = !empty($each_stag->started_date)? $each_stag->started_date:'NIL';
                if($download_status == 'y'){
                    $escape_hash = " \n";
                    $stage_arr['jwf_stage_name'][] = $each_stag->jwf_stage_name;
                    $due_date_arr[] = !empty($each_stag->due_date)?$each_stag->due_date . $expired_remaining :'NIL';
                }else{
                    $stage_arr['jwf_stage_name'][] = $each_stag->jwf_stage_name . '#*#' .$status_link;
                    $due_date_arr[] = !empty($each_stag->due_date)? '<span title="'.$expired_remaining.'" class="'.$due_date_expired_cls.'">'.$each_stag->due_date . '</span>' :'NIL';
                }
                $stage_arr['popovr_type'] = $popovr_type;
                $stage_arr['popovr_content'] = $popovr_content;
                if(!empty($each_stag->aflw_usr_id))
                {
                    $displayArray = array(
                        'user_id' => $each_stag->aflw_usr_id,
                        'jnl_code' => $journalData->jnl_journal_code,
                        'flag'     => TRUE,
                        'article_id' => $art_id,
                        'availability' => TRUE,
                        'save_coauthor' => FALSE,
                        'remove_user' => FALSE,
                        'source' => FALSE,
                        'salutation' => TRUE,
                        'flag_only' => FALSE,
                        'inactive_user' => FALSE,
                        'fullname_only' => FALSE,
                        'journal_id' => $journalData->jnl_id,
                    );
                    $title_html          = $this->get_user_display_name($displayArray);
                    $title_html['role_name'] = $each_stag->role_name;
                    $title_html['art_id'] = $art_id;
                    $title_html['id'] = $i;
                    $stage_assign_to_arr[] = $title_html;
                }
                else{
                    $assign_roles['role_name'] = $each_stag->role_name;
                    if($each_stag->aflw_status == 'p'){
                        $assign_roles['role_name'] = 'Not yet assigned';
                    }
                    $assign_roles['id'] = $i;
                    $stage_assign_to_roles_arr[] = $assign_roles;
                }
                $i++;
                $main_array = array_merge($stage_assign_to_arr, $stage_assign_to_roles_arr);
            }
            // print_r($main_array);die;
            $rtn_arr = array(
                'crnt_stg' => $stage_arr,
                'crnt_stg_dts' => implode($escape_hash,$start_date_arr),
                'crnt_stg_due_dts' => implode($escape_hash,$due_date_arr),
                'crnt_stg_assign_to' => $main_array,
                // 'crnt_status_link' => $status_link
            );
            return($rtn_arr);
        }
    }
    public function download_sheet_view_as_csv($titles, $csvData, $isProductionUser = FALSE)
    {
        try {
            $rtn_arr = array();
            $file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
            $timestamp = strtotime(date('d-m-Y H:i:s'));
            $upload_path = 'uploads/sheetView_downloads/sheetView_' . $timestamp . '.csv';
            $csv_file           = $file_storage_path . $upload_path;
            $path = storage_path() . '/app/public/uploads/sheetView_downloads/';
            File::deleteDirectory($path);
            if (!file_exists($path)) {
                File::makeDirectory($path, 0777, TRUE, TRUE);
            }
            $file = fopen(storage_path() . $csv_file, 'w');
            // $headers = array("Peter ","Griffin ","Oslo ","Norway ");
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=$csv_file");
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header("Content-Transfer-Encoding: binary");
            header("Pragma: no-cache");
            header("Expires: 0");
            fputcsv($file, $titles);
            if (count($csvData) > 0) {
                $i = 1;
                // print_r($csvData);die;
                foreach ($csvData as $row) {
                    $assigned_to = array();
                    $csv_content['sl_no']               = $i++;
                    $csv_content['art_code']            = $row['art_code'];
                    $csv_content['art_title']           = $row['art_title'];
                    $csv_content['artp_article_type']   = $row['artp_article_type'];
                    if (!empty($row['kwd_name']) && count($row['kwd_name']) > 0) {
                        $csv_content['kwd_name']        = implode(" \n", $row['kwd_name']);
                    } else {
                        $csv_content['kwd_name']        = '';
                    }
                    $csv_content['art_submitted_by']    = $row['art_submitted_by']['fullname'];
                    $csv_content['art_submission_date'] = $row['art_submission_date'];
                    $csv_content['art_blinded_for']     = implode(" \n", array_column($row['art_blinded_for'], 'fullname'));
                    $csv_content['prev_art_codes']      = (!empty($row['prev_art_codes'])) ? (implode(" \n", $row['prev_art_codes'])) : null;
                    $csv_content['original_status']     = $row['original_status'];
                    $csv_content['page_extent']         = $row['page_extent'];
                    $csv_content['iss_title']           = $row['iss_title'];
                    if(isset($row['current_stage']['jwf_stage_name']) && !empty($row['current_stage']['jwf_stage_name'])){
                        $csv_content['jwf_stage_name']  = implode(" \n", $row['current_stage']['jwf_stage_name']);
                    } else {
                        $csv_content['jwf_stage_name']  = '';
                    }
                    $csv_content['start_date']          = $row['start_date'];
                    $csv_content['due_date']            = $row['due_date'];

                    if (count($row['task_assigned_to'])) {
                        foreach ($row['task_assigned_to'] as $assignee) {
                            if (isset($assignee['fullname']) && !empty($assignee['fullname'])) {
                                $assigned_to[] = $assignee['fullname'] . '(' . $assignee['role_name'] . ')';
                            } else {
                                $assigned_to[] = $assignee['role_name'];
                            }
                        }
                    }
                    $csv_content['task_assigned_to']    = implode(" \n", $assigned_to);
                    $csv_content['flags']               = implode(" \n", array_column($row['flags'], 'flag_name'));
                    if($isProductionUser == TRUE) {
                        $csv_content['original_submission_date'] = $row['original_submission_date'];
                        $csv_content['art_decision_date']        = $row['art_decision_date'];
                        $csv_content['art_epub_date']            = $row['art_epub_date'];
                    }
                    // print_r( array_column($row['flags'],'flag_name') );die;
                    fputcsv($file, $csv_content);
                }
            }
            fclose($file);
            $fullPath = storage_path('app/public/' . $upload_path);
            $rtn_arr['fullPath'] = $fullPath;
            $rtn_arr['fileName'] = 'sheetView_' . $timestamp . '.csv';
            // return Response::download($myFile);
            return $rtn_arr;
            // print_r($myFile);die;
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function download_sheet_view($file_data)
    {
        try {
            $post_data = json_decode($file_data);
            // print_r(decrypt_link($post_data->downloadPath));die;
            return Response::download(Rv_decrypt($post_data->downloadPath));
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function getBasicLegacydetails(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id'   => 'required',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            } else {
                $result = array();
                $payloadData = $request->all();
                $current_client = $this->current_client;
                $jnl_id            = decrypt_link($payloadData['jnl_id']);
                $journalCode       = $payloadData['journalCode'];
                $activeCoreRoleId  = $payloadData['activeCoreRoleId'];
                $Journals          = new \App\Models\Journals;
                $journalCode       = $payloadData['journalCode'];
                $journalData       = $Journals::get_journal_data($journalCode);
                $legacy_article_types =Article_legacydata::get_all_records("arld_article_type",array(),NULL,NULL,'',NULL,'arld_article_type');
		        $result['legacyArticleTypes']=$legacy_article_types;
                $jnl_date_format = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
                $array_date=platform_date_format();
                $result['dateFormat'] = $array_date[$jnl_date_format];
                $result['modules'] = $current_client->modules;
                return $this->success('success', 200, $result);
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function getLegacySheetView(Request $request)
    {
        try {
            $currentUser      = $this->get_current_user_details();
            $currentClient   = $this->current_client;
            $payloadData = $request->all();
            $journalCode      = $payloadData['journalCode'];
            $journalData      = Journals::get_journal_data($journalCode);
            $legacyArticlesDetails   = $this->getLegacyArticleData($payloadData, $currentUser, $currentClient, $journalData);

            $legacyArticles   = $legacyArticlesDetails['legacy_article_result'];
            // print_r($legacyArticles);die;
            $data = array();
            if(count($legacyArticles) > 0){
                foreach($legacyArticles as $article){

                    $displayArray = array(
                        'user_id' => $article->arld_submitted_by,
                        'jnl_code' => $journalData->jnl_journal_code,
                        'flag'     => TRUE,
                        'article_id' => $article->arld_id,
                        'availability' => TRUE,
                        'save_coauthor' => FALSE,
                        'remove_user' => FALSE,
                        'source' => FALSE,
                        'salutation' => TRUE,
                        'flag_only' => FALSE,
                        'inactive_user' => FALSE,
                        'fullname_only' => FALSE,
                        'journal_id' => $journalData->jnl_id,
                    );
                    $title_html          = $this->get_user_display_name($displayArray);

                    $data[] = array(
                        'arld_id'               => $article->arld_id,
                        'arld_article_code'     => $article->arld_article_code,
                        'arld_article_title'    => $article->arld_article_title,
                        'arld_article_type'     => $article->arld_article_type,
                        'arld_submission_date'       => $article->submitted_date,
                        'arld_decision_date'   => $article->decision_date,
                        'arld_most_recent_decision_date'   => $article->most_recent_decision_date,
                        'author_name'           => $title_html,
                    );
                }
            }
            $currentPage = $legacyArticles->currentPage();
            $perPage     = $legacyArticles->perPage();
            $lastPage    = $legacyArticles->lastPage();
            $total       = $legacyArticles->total();
            $to          = $currentPage * $perPage;
            $from        = (($currentPage - 1) * $perPage) + 1;
            if($lastPage == $currentPage){
                $to = $total;
            }
            $response = array(
                'data'           => $data,
                'last_page'      => $legacyArticles->lastPage(),
                'total_records'  => $legacyArticles->total(),
                'per_page'       => $legacyArticles->perPage(),
                'currentPage'    => $legacyArticles->currentPage(),
                'to'             => $to,
                'from'           => $from,
            );
            return $this->success('success', 200, $response);

        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function getLegacyArticleData($payloadData, $currentUser, $currentClient, $journalData)
    {
        $articlesPerPage = $payloadData["per_page"];
        $additional_conditions = array();
        $paramsdet = $payloadData['paramsdet'];
        if (isset($paramsdet['article_id']) && $paramsdet['article_id'] != '') {
            $paramsdet['article_id'] = trim($paramsdet['article_id']);
            $additional_conditions[] = " AND `arld_article_code` LIKE '%{$paramsdet['article_id']}%'";
        }
        if (isset($paramsdet['article_title']) && $paramsdet['article_title'] != '') {
            $paramsdet['article_title'] = trim($paramsdet['article_title']);
            $additional_conditions[] = " AND `arld_article_title` LIKE '%{$paramsdet['article_title']}%'";
        }
        if (isset($paramsdet['article_type']) && $paramsdet['article_type'] != '') {
            $additional_conditions[] = " AND `arld_article_type` LIKE '{$paramsdet['article_type']}'";
        }
        if (isset($paramsdet['date_selection']) && $paramsdet['date_selection'] != '') {
            if ($paramsdet['date_selection'] == 'sd') {
                if ($paramsdet['submission_date'] != '') {
                    $submissionDate = convert_dmy_to_ymd($paramsdet['submission_date'], $journalData->jset_date_format);

                    $additional_conditions[] = " AND `arld_submission_date` LIKE  '%{$submissionDate}%'";
                }
            } else {
                if ($paramsdet['submission_startdate'] != '' && $paramsdet['submission_enddate'] != '') {
                    $submissionStartDate = convert_dmy_to_ymd($paramsdet['subduerangestartdate'], $journalData->jset_date_format);
                    $submissionEndDate   = convert_dmy_to_ymd($paramsdet['subduerangeenddate'], $journalData->jset_date_format);
                    $additional_conditions[] = " AND `arld_submission_date` BETWEEN '{$submissionStartDate}' AND '{$submissionEndDate}'";
                }
            }
        }
        $additional_conditions = implode(' ', $additional_conditions);
        $orderbyField = '';
        if (isset($payloadData["sort_field"]) && !empty($payloadData["sort_field"])) {
            $orderbyField = $payloadData["sort_field"] . ' ';
            if($payloadData["sort_field"] == 'author_name') {
                $orderbyField = 'usr_first_name ';
                // $additionalJoinsArr[] = array($UserTable, 'art_submitted_by', 'usr_id');
            }
        }
        $orderbyMode = '';
        if (isset($payloadData["sort_order"]) && !empty($payloadData["sort_order"]))
        $orderbyMode = $payloadData["sort_order"];
        $jset_date_format =  $this->get_platform_date_format($journalData->jnl_id);
        if (isset($jset_date_format) && !empty($jset_date_format)) {
            $dateFormat = $jset_date_format;
        } else {
            $dateFormat = $currentClient->settings->cs_date_format;
        }
        $dateFormat = date_format_map($dateFormat);

        $select = "
                   `arld_id`,
                    `arld_article_title`,
                    `arld_article_code`,
                    `arld_article_abstract`,
                    `arld_article_type`,
                    DATE_FORMAT(NULLIF(arld_submission_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as submitted_date,
					DATE_FORMAT(NULLIF(arld_decision_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as decision_date,
                    DATE_FORMAT(NULLIF(arld_most_recent_decision_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as most_recent_decision_date,
                    `arld_submitted_by`";
        $criteria = "`arld_jnl_id` = {$journalData->jnl_id}
            AND FIND_array_intersect('" . $currentUser['user_id'] . "',arld_submitted_by )=0{$additional_conditions}";
        $legacyArticleDetails = Article_legacydata::legacy_sheet_view_paginated_records($select, $criteria, 'arld_id', $orderbyField, $orderbyMode, $articlesPerPage);

        return ($legacyArticleDetails);
    }
    public function fetchLegacyDetails (Request $request){
        try{
            $response           = array(
                'status'    => FALSE
            );
            $currentClient      = $this->current_client;
            $payloadData        = $request->all();
            $arld_id            = decrypt_link($payloadData['arld_id']);
            $journalCode        = $payloadData['journalCode'];
            $journalData        = Journals::get_journal_data($journalCode);
            $jset_date_format   =  $this->get_platform_date_format($journalData->jnl_id);
            if (isset($jset_date_format) && !empty($jset_date_format)) {
                $dateFormat = $jset_date_format;
            } else {
                $dateFormat = $currentClient->settings->cs_date_format;
            }
            $dateFormat = date_format_map($dateFormat);
            $records = Article_legacydata::get_details('arld_id =' . $arld_id,$dateFormat);
            if(!empty($records)){

                $submitted_by_arr = array(
                    'user_id' => $records->arld_submitted_by,
                    'jnl_code' => $journalData->jnl_journal_code,
                    'flag'     => TRUE,
                    'article_id' => $arld_id,
                    'availability' => TRUE,
                    'save_coauthor' => FALSE,
                    'remove_user' => FALSE,
                    'source' => FALSE,
                    'salutation' => TRUE,
                    'flag_only' => FALSE,
                    'inactive_user' => FALSE,
                    'fullname_only' => FALSE,
                    'journal_id' => $journalData->jnl_id,
                );
                $records->submitted_by_link          = $this->get_user_display_name($submitted_by_arr);
                $reviewers = Article_reviewer_legacydata::get_reviewer_details('arev_arld_id =' . $arld_id,$dateFormat);
                if(!empty($reviewers))
				{
                    $i=1;
					foreach($reviewers as $r)
					{
                        $reviewer_arr = array(
                            'user_id' => $r->arev_user_id,
                            'jnl_code' => $journalData->jnl_journal_code,
                            'flag'     => TRUE,
                            'article_id' => $arld_id,
                            'availability' => TRUE,
                            'save_coauthor' => FALSE,
                            'remove_user' => FALSE,
                            'source' => FALSE,
                            'salutation' => TRUE,
                            'flag_only' => FALSE,
                            'inactive_user' => FALSE,
                            'fullname_only' => FALSE,
                            'journal_id' => $journalData->jnl_id,
                        );
                        $r->reviewer_link   = $this->get_user_display_name($reviewer_arr);
                        $r->sl_no           = $i++;
                    }
				}
                $records->reviewers= $reviewers;
                $response = array(
                    'status'    => TRUE,
                    'data'      => $records
                );
            }
            return $this->success('success', 200, $response);
        } catch (\Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function saveOptionalColums(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'optional_colums_selected' => 'present|array',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            else
            {
                $current_user = $this->get_current_user_details();
                $condition = "sosc_user_id=".$current_user['user_id']." AND sosc_jnl_id=".decrypt_link($post_data['jnl_id']);
                $saved_data = Sheet_view_optional_selected_colums::get_single_record('sosc_id', $condition);
                if(empty($saved_data))
                {
                    $insert_data = array(
                        'sosc_user_id' => $current_user['user_id'],
                        'sosc_jnl_id'  => decrypt_link($post_data['jnl_id']),
                        'sosc_colums' => json_encode($post_data['optional_colums_selected'])
                    );
                    Sheet_view_optional_selected_colums::insert_record($insert_data, $current_user);
                }
                else
                {
                    $condition = "sosc_id=".$saved_data->sosc_id;
                    $update_data = array(
                        'sosc_colums' => json_encode($post_data['optional_colums_selected'])
                    );
                    Sheet_view_optional_selected_colums::update_record($update_data, $condition, $current_user);
                }

                return $this->success('success', 200);
            }
        }
        catch(\Exception $e)
        {

            return  $this->failure('Failed',500,$e);
        }
    }
    /* TASK #5630 Implement an option within the sheet view to recover a withdrawn article. */
    public function recover_withdrawn_article(Request $request){
        try{
                $validator = Validator::make($request->all(), [
                    'mode'   => 'required',
                    'art_id' => 'required',
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }
                    $payloadData = $request->all();
                    $current_user = $this->get_current_user_details();
                    $artidarray = array('input'=>$payloadData['art_id'],'type'=>'number', 'enc_data'=>TRUE );
                    $artparray = array('input'=>$payloadData['artp_id'],'type'=>'number', 'enc_data'=>TRUE );
                    $jnlidarray = array('input'=>$payloadData['jnl_id'],'type'=>'number', 'enc_data'=>TRUE );
                    $jnlcodearray = array('input'=>$payloadData['jnl_code'],'type'=>'string', 'enc_data'=>TRUE );
                    $artidvalidation = $this->Rv_validator($artidarray);
                    $artpvalidation = $this->Rv_validator($artparray);
                    $jnlidvalidation = $this->Rv_validator($jnlidarray);
                    $jnlcodevalidation = $this->Rv_validator($jnlcodearray);
                    //removed the exit() after return (detected by Sonarqube)
                    if($artidvalidation != TRUE || $artpvalidation != TRUE || $jnlidvalidation != TRUE || $jnlcodevalidation != TRUE ){
                        return $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
                    }
                    $art_id = isset($payloadData['art_id']) ? $this->decrypt_data($payloadData['art_id']) : '';
                    $artp_id = isset($payloadData['artp_id']) ? $this->decrypt_data($payloadData['artp_id']) : '';
                    $jnl_id = isset($payloadData['jnl_id']) ? $this->decrypt_data($payloadData['jnl_id']) : '';
                    $jnl_code = isset($payloadData['jnl_code']) ? $this->decrypt_data($payloadData['jnl_code']) : '';
                    $mode = $payloadData['mode'];
                    $art_details = array(
                        'art_id' => $art_id,
                        'artp_id' => $artp_id,
                        'jnl_id' => $jnl_id,
                        'jnl_code' => $jnl_code,
                        'core_role' => $payloadData['core_role'],
                        'role_name' => $payloadData['role_name'],
                    );
                    $update_array = array(
                        'art_delete_status' => 'n',
                        'art_delete_reason' => NULL,
                        'art_deleted_by' => NULL,
                        'art_deleted_date' => NULL
                    );
                    $msg = '';
                    if (isset($mode) &&  $mode == 'recover_article') {
                            $this->update_article_data($art_id,$update_array, $current_user);
                            if(isset($art_details) && !empty($art_details)){
                                $this->send_email_article_delete_status($art_details, 'undo_withdraw_article_author');
                            }
                            $msg = customTrans('sheetView.article_recovered');
                    } 
                    else {
                        return $this->failure('Failed',422,customTrans('viewarticle.invalid_data'));
                    }
                    $rtn_arr = array(
                        'msg' => $msg
                    );
                    return $this->success('success', 200, $rtn_arr);

        } 
        catch(\Exception $e){
            return  $this->failure('Failed', 500, $e->getMessage());
        }
    }
    /* end Implement an option within the sheet view to recover a withdrawn article. */
}
