<?php

namespace App\Http\Controllers;

use App\Models\Article_types;
use App\Models\Email_templates;
use App\Models\Generic_flows;
use App\Models\Journals;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use  App\Http\Traits\UtilityTrait;
use App\Models\Stage_email_templates;
use App\Models\Stage_email_tmpl_reference;
use Illuminate\Support\Facades\DB;

class Manage_Staged_Emails_Api extends Controller
{
    use UtilityTrait;
    public function index(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $form_data = $request->all();
            $artp_data = Article_types::get_all_records('artp_id,artp_article_type,artp_abbr_article_type,artp_fwm_id', "artp_jnl_id = {$this->decrypt_data($form_data['jnl_id'])} AND artp_status='y'");
            $data['all_article_types'] = array();
            $article_type_array = [];
            $initial = [];
            if($this->current_client->modules->mdl_conference == 'y')
                $initial['label'] = 'Event';
            else
                $initial['label'] = 'Article type';
            $initial['value'] = '';
            array_push($article_type_array, $initial);
            foreach ($artp_data as $artp) {
                $data = [];
                $proper_flow = $this->validate_journal($artp->artp_fwm_id, $artp->artp_id, 'a');
                if ($proper_flow['status'] == TRUE) {
                    $data['label'] =  $artp->artp_article_type;
                    $data['value'] =  $this->encrypt_data($artp->artp_id);
                    array_push($article_type_array, $data);
                }
            }

            // $this->_render_page('templates/rv_journal_fullscreen', $this->data);
            return $this->success('success', 200, $article_type_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_stage_types(Request $request)
    {
        try {
            $article_stage_array = [];

            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $form_data = $request->all();
            
            $result = Generic_flows::get_article_type_stages('jwf_stage_name,jwf_id,jwf_stage_type', array('artp_id' => $this->decrypt_data($form_data['art_id'])));
            $initial = [];
            $initial['label'] = 'Select stage type';
            $initial['value'] = '';
            array_push($article_stage_array, $initial);
            foreach ($result as $art_stage) {
                $data = [];
                // $proper_flow = $this->validate_journal($artp->artp_fwm_id, $artp->artp_id, 'a');
                // if ($proper_flow['status'] == TRUE)
                $data['label'] =  $art_stage->jwf_stage_name;
                $data['value'] =  $this->encrypt_data($art_stage->jwf_id);
                $data['core'] =  $art_stage->jwf_stage_type;
                if(isset($form_data['type'])&&$form_data['type']=='decision')
                {

                    if(!in_array($art_stage->jwf_stage_type,config('general_config.avoid_decision_stages')))
                    {
                     
                        array_push($article_stage_array, $data);
                    }
                }
                else
                {
                array_push($article_stage_array, $data);
                }
            }
            // print_r($article_stage_array);exit;
            return $this->success('success', 200, $article_stage_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function email_template_keyword_search(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'keyword' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $enable_journal_data = FALSE;
            if (isset($this->current_client->functionality->cfty_allow_journal_wise_data_to_sa) && $this->current_client->functionality->cfty_allow_journal_wise_data_to_sa == 'y') {
                $enable_journal_data = TRUE;
            }
            $form_data = $request->all();
            if(isset($form_data['event_type'])){
                $pattern = "/^[a-zA-Z0-9_]+$/";
                if(preg_match($pattern, $form_data['event_type']) != TRUE)
                {
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            }
            if(isset($form_data['jnl_code'])){
                $jnlcodevalid = $this->validatecode(array('jnl_code'=>$form_data['jnl_code']),false);
                if($jnlcodevalid['jnl_code'] != TRUE ){
                    $res['msg']=customTrans('viewarticle.invalid_data');
                    return  $this->warning('Warnings',200,$res,'warning');
                }
            }
            $event_bind_arr = array();
            $stage_bind_arr = array();
            $type_search_arr = array();
            $em_type_search_arr = array();

            $keywordarray = array('input' => trim($form_data['keyword']),'required'=>TRUE, 'enc_data' => TRUE);
            $typearray = array('input' => trim($form_data['type']),'required'=>FALSE, 'enc_data' => TRUE);
            // $eventtypedarray = array('input' => trim($form_data['event_type']),'required'=>FALSE, 'enc_data' => TRUE);
            $eventtypedarray = array('input' => trim($form_data['event_type']),'required'=>FALSE, 'enc_data' => FALSE);
            $searchcasesarray = array('input' => trim($form_data['search_cases']),'required'=>FALSE, 'enc_data' => TRUE);
            $conditionarray = array('input' => trim($form_data['condition']),'required'=>FALSE, 'enc_data' => TRUE);
            $jnlcodearray = array('input' => trim($form_data['jnl_code']),'required'=>FALSE);
            $sortarray = array('input' => trim($form_data['sort']),'required'=>FALSE, 'enc_data' => TRUE);

            $keywordarrayvalidation = $this->Rv_validator($keywordarray);
            $typearrayvalidation = $this->Rv_validator($typearray);
            $eventtypedarrayvalidation = $this->Rv_validator($eventtypedarray);
            $searchcasesarrayvalidation = $this->Rv_validator($searchcasesarray);
            $conditionarrayvalidation = $this->Rv_validator($conditionarray);
            $jnlcodearrayvalidation = $this->Rv_validator($jnlcodearray);
            $sortarrayvalidation = $this->Rv_validator($sortarray);

            if ($keywordarrayvalidation != TRUE || $typearrayvalidation != TRUE || $eventtypedarrayvalidation != TRUE || $searchcasesarrayvalidation != TRUE || $conditionarrayvalidation != TRUE || $jnlcodearrayvalidation != TRUE || $sortarrayvalidation != TRUE) {
                return $this->warning('Failed', 422, customTrans('viewarticle.invalid_data'));
            }
            $keyword = isset($form_data['keyword']) ? decrypt_link($form_data['keyword']) : '';
            $type = isset($form_data['type']) ? decrypt_link($form_data['type']) : '';
            $condition = isset($form_data['condition']) ? decrypt_link($form_data['condition']) : '';
            // $event_type = isset($form_data['event_type']) ? decrypt_link($form_data['event_type']) : '';
            $event_type = isset($form_data['event_type']) ? $form_data['event_type'] : '';
            $jnl_code = isset($form_data['jnl_code']) ? decrypt_link($form_data['jnl_code']) : '';
            $search_case = isset($form_data['search_cases']) ? decrypt_link($form_data['search_cases']) : '';
            $sort = (decrypt_link($form_data['sort']) == 'false') ? 'desc' : 'asc';
            $page = $form_data['page'];
            $limit =  $form_data['per_page'] ?? 10;
            $jnl_search = '';
            $type_search = '';
            $em_type_search = '';
            $addslash = FALSE;
            $search_operator = ' LIKE ';
            $event_search_criteria = '';
            $stage_search_criteria = '';
            $conditionArray = array();
            if (!$sort)
                $order = 'asc';
            else
            $order = $sort;
            if ($event_type) {
                if ($type_search) {
                    $type_search = ' AND setmp.stage_etmp_name = :event_type';
                    $em_type_search = ' etmp.etmp_name = :event_type';
                } else {
                    $type_search = ' AND setmp.stage_etmp_name = :event_type';
                    $em_type_search = ' etmp.etmp_name = :event_type';
                }
            }
            if (!empty($jnl_code) && $jnl_code != '') {
                $fetch_jnl  = Journals::get_single_record('jnl_id', "jnl_journal_code = '{$jnl_code}'");
                // $jnl_search = ($enable_journal_data ? 'stage_etmp_journal_id = ? ' : 'OR stage_etmp_journal_id = ? ');
                $jnl_search = ($enable_journal_data ? 'stage_etmp_journal_id = ? ' : ' stage_etmp_journal_id = ? ');
                $stage_bind_arr[]= $fetch_jnl->jnl_id;
            }
            $keyword_regexp = $keyword;
            $flg_regexp_adv = 0;
            if (preg_match('/^[^a-zA-Z0-9]+$/', $keyword)) {
                if (strpos($keyword, '%') !== false) {
                    $search_operator = ' REGEXP BINARY ';
                } elseif (strpos($keyword, '__') !== false) {
                    $keyword = str_replace(array('_'), array('\_'), $keyword);
                    $search_operator = ' REGEXP BINARY ';
                }
            }
            if (in_array($keyword, array('"'))) {
                $addslash = TRUE;
            } else
                $keyword = htmlspecialchars($keyword);
            $keyword_normal =  $keyword;
            if ($search_case == '') {
                $keyword_normal = preg_replace('/\\\\{1}/', '\\\\\\\\\\\\\\\\', $keyword);
            }
            if ($em_type_search != ''){
                $event_search_criteria  =   '(etmp.etmp_subject ' . $search_operator . ' :keyword_normal1 OR strip_tags(etmp.etmp_email_template) ' . $search_operator . ' :keyword_normal2 ) AND ' . $em_type_search;
                $event_bind_arr['keyword_normal1']= "%".$keyword_normal."%";
                $event_bind_arr['keyword_normal2']= "%".$keyword_normal."%";
                $event_bind_arr['event_type'] = $event_type;
            }
            else{
                $event_search_criteria  =   '(etmp.etmp_subject ' . $search_operator . ' :keyword_normal3 OR strip_tags(etmp.etmp_email_template) ' . $search_operator . ' :keyword_normal4)  ';
                $event_bind_arr['keyword_normal3']= "%".$keyword_normal."%";
                $event_bind_arr['keyword_normal4']= "%".$keyword_normal."%";
            }
            $event_columns = 'etmp.etmp_id as id,etmp.etmp_subject as subject,etmp.etmp_email_template as content, "Event Type" as email_type, NULL as jnl_id, NULL as stage_type,etmp.etmp_name as NAME';
            if(!empty($jnl_search)){
                // $stage_search_criteria = '(' . ($enable_journal_data ? '' : 'setmp.stage_etmp_journal_id IS NULL') . ' :jnl_search ) AND (setmp.stage_etmp_subject ' . $search_operator . ' :keyword_normal5 OR strip_tags(setmp.stage_etmp_content) ' . $search_operator . ' :keyword_normal6)';
                $stage_search_criteria = '( :jnl_search ) AND (setmp.stage_etmp_subject ' . $search_operator . ' :keyword_normal5 OR strip_tags(setmp.stage_etmp_content) ' . $search_operator . ' :keyword_normal6)';
                $stage_bind_arr['jnl_search']= $jnl_search;
                $stage_bind_arr['keyword_normal5']= "%".$keyword_normal."%";
                $stage_bind_arr['keyword_normal6']= "%".$keyword_normal."%";
            }else{
                // $stage_search_criteria = ($enable_journal_data ? '' : '(setmp.stage_etmp_journal_id IS NULL ) AND') . ' (setmp.stage_etmp_subject ' . $search_operator . ' :keyword_normal7 OR strip_tags(setmp.stage_etmp_content) ' . $search_operator . ' :keyword_normal8)';
                $stage_search_criteria =' (setmp.stage_etmp_subject ' . $search_operator . ' :keyword_normal7 OR strip_tags(setmp.stage_etmp_content) ' . $search_operator . ' :keyword_normal8)';
                $stage_bind_arr['keyword_normal7']= "%".$keyword_normal."%";
                $stage_bind_arr['keyword_normal8']= "%".$keyword_normal."%";
            }
            $stage_columns = 'setmp.stage_etmp_id as id,setmp.stage_etmp_subject as subject,setmp.stage_etmp_content as content, "Stage Type" as email_type, setmp.stage_etmp_journal_id as jnl_id, setmp.stage_etmp_stage_type as stage_type,setmp.stage_etmp_name as NAME';

            if ($search_case == 'regular_expression' || ($search_case == '' && in_array($keyword, array('%', '=')))) {
                $event_bind_arr = array();
                $stage_bind_arr = array();
                if (strpos($keyword, ':') == false) {
                    $keyword = preg_replace('/([^A-Za-z0-9\s])/', '$1', $keyword);
                    $keyword_reg = preg_quote($keyword);
                    if (in_array($keyword, array('\l', '\L', '\U', '\u', '\n', '\N'))) {
                        $keyword = $keyword_reg;
                    }
                    if ($search_case == 'regular_expression' && $keyword == '\d') {
                        $keyword_reg = '[0-9]';
                    }
                    $event_search_criteria = '(etmp.etmp_subject REGEXP :keyword_reg1 OR strip_tags(etmp.etmp_email_template) REGEXP :keyword_reg2 ) ';
                    $event_bind_arr['keyword_reg1']= $keyword_reg;
                    $event_bind_arr['keyword_reg2']= $keyword_reg;
                    if(!empty($jnl_search)){
                        // $stage_search_criteria = '(' . ($enable_journal_data ? '' : 'setmp.stage_etmp_journal_id IS NULL') . ' :jnl_search ) AND (setmp.stage_etmp_subject REGEXP :keyword_reg3 OR strip_tags(setmp.stage_etmp_content) REGEXP :keyword_reg4 )';
                        $stage_search_criteria = '( :jnl_search ) AND (setmp.stage_etmp_subject REGEXP :keyword_reg3 OR strip_tags(setmp.stage_etmp_content) REGEXP :keyword_reg4 )';
                        $stage_bind_arr['jnl_search']= $jnl_search;
                        $stage_bind_arr['keyword_reg3']= $keyword_reg;
                        $stage_bind_arr['keyword_reg4']= $keyword_reg;
                    }else{
                        // $stage_search_criteria = ($enable_journal_data ? '' : '(setmp.stage_etmp_journal_id IS NULL ) AND') . ' (setmp.stage_etmp_subject REGEXP :keyword_reg5 OR strip_tags(setmp.stage_etmp_content) REGEXP :keyword_reg6 )';
                        $stage_search_criteria = ' (setmp.stage_etmp_subject REGEXP :keyword_reg5 OR strip_tags(setmp.stage_etmp_content) REGEXP :keyword_reg6 )';
                        $stage_bind_arr['keyword_reg5']= $keyword_reg;
                        $stage_bind_arr['keyword_reg6']= $keyword_reg;
                    }
                } else {
                    $flg_regexp_adv = 1;
                    $keyword_altr = $keyword_regexp;
                    if (substr($keyword, -1) == '.') {
                        $keyword_altr = '\\\b' . str_replace('.', '[.]', $keyword);
                    }
                    $event_search_criteria = '(etmp.etmp_subject  REGEXP  :keyword_altr1 OR strip_tags(etmp.etmp_email_template)  REGEXP :keyword_altr2" )  ';
                    $event_bind_arr['keyword_altr1']= $keyword_altr;
                    $event_bind_arr['keyword_altr2']= $keyword_altr;
                    if(!empty($jnl_search)){
                        // $stage_search_criteria = '(' . ($enable_journal_data ? '' : 'setmp.stage_etmp_journal_id IS NULL') . ' :jnl_search ) AND (setmp.stage_etmp_subject  REGEXP :keyword_altr3  OR strip_tags(setmp.stage_etmp_content)  REGEXP :keyword_altr4 )';
                        $stage_search_criteria = '( :jnl_search ) AND (setmp.stage_etmp_subject  REGEXP :keyword_altr3  OR strip_tags(setmp.stage_etmp_content)  REGEXP :keyword_altr4 )';
                        $stage_bind_arr['jnl_search']= $jnl_search;
                        $stage_bind_arr['keyword_altr3']= $keyword_altr;
                        $stage_bind_arr['keyword_altr4']= $keyword_altr;
                    }else{
                        // $stage_search_criteria = ($enable_journal_data ? '' : '(setmp.stage_etmp_journal_id IS NULL ) AND') . ' (setmp.stage_etmp_subject  REGEXP :keyword_altr5  OR strip_tags(setmp.stage_etmp_content)  REGEXP :keyword_altr6 )';
                        $stage_search_criteria =  ' (setmp.stage_etmp_subject  REGEXP :keyword_altr5  OR strip_tags(setmp.stage_etmp_content)  REGEXP :keyword_altr6 )';
                        $stage_bind_arr['keyword_altr5']= $keyword_altr;
                        $stage_bind_arr['keyword_altr6']= $keyword_altr;
                    }
                }
            } else if ($search_case == 'match_case') {
                $event_bind_arr = array();
                $stage_bind_arr = array();
                $event_search_criteria = '(etmp.etmp_subject  LIKE binary :keyword1  OR strip_tags(etmp.etmp_email_template)  LIKE binary :keyword2 )  ';
                $event_bind_arr['keyword1']= "%".$keyword."%";
                $event_bind_arr['keyword2']= "%".$keyword."%";
                if(!empty($jnl_search)){
                    // $stage_search_criteria = '(' . ($enable_journal_data ? '' : 'setmp.stage_etmp_journal_id IS NULL') . ' :jnl_search ) AND (setmp.stage_etmp_subject  LIKE binary :keyword3  OR strip_tags(setmp.stage_etmp_content)  LIKE binary :keyword4)';
                    $stage_search_criteria = '( :jnl_search ) AND (setmp.stage_etmp_subject  LIKE binary :keyword3  OR strip_tags(setmp.stage_etmp_content)  LIKE binary :keyword4)';
                    $stage_bind_arr['jnl_search']= $jnl_search;
                    $stage_bind_arr['keyword3']= "%".$keyword."%";
                    $stage_bind_arr['keyword4']= "%".$keyword."%";
                }else{
                    // $stage_search_criteria = ($enable_journal_data ? '' : '(setmp.stage_etmp_journal_id IS NULL ) AND') . ' (setmp.stage_etmp_subject  LIKE binary  :keyword5  OR strip_tags(setmp.stage_etmp_content)  LIKE binary  :keyword6 )';
                    $stage_search_criteria = ' (setmp.stage_etmp_subject  LIKE binary  :keyword5  OR strip_tags(setmp.stage_etmp_content)  LIKE binary  :keyword6 )';
                    $stage_bind_arr['keyword5']= "%".$keyword."%";
                    $stage_bind_arr['keyword6']= "%".$keyword."%";
                }

            } else if ($search_case == 'match_entire_word') {
                $event_bind_arr = array();
                $stage_bind_arr = array();
                $keyword_altr = '\\\b' . $keyword . '\\\b';
                if (substr($keyword, -1) == '.') {
                    $keyword_altr = '\\\b' . str_replace('.', '[.]', $keyword);
                }
                // $event_search_criteria = '(etmp.etmp_subject REGEXP :keyword_altr7 OR strip_tags(etmp.etmp_email_template) REGEXP :keyword_altr8 )  ';
                // $event_bind_arr['keyword_altr7']= "'".$keyword_altr."'";
                // $event_bind_arr['keyword_altr8']= "'".$keyword_altr."'";
                // if(!empty($jnl_search)){
                    // $stage_search_criteria = '('.( $enable_journal_data ?'setmp.stage_etmp_journal_id IS NULL':'').'setmp.stage_etmp_journal_id IS NULL :jnl_search ) AND (setmp.stage_etmp_subject REGEXP :keyword_altr9 OR strip_tags(setmp.stage_etmp_content) REGEXP :keyword_altr10) ';
                    // $stage_bind_arr['jnl_search']= $jnl_search;
                    // $stage_bind_arr['keyword_altr9']= "'".$keyword_altr."'";
                    // $stage_bind_arr['keyword_altr10']= "'".$keyword_altr."'";
                // }else{
                    // $stage_search_criteria = ($enable_journal_data?'':'(setmp.stage_etmp_journal_id IS NULL ) AND').' (setmp.stage_etmp_subject REGEXP :keyword_altr11 OR strip_tags(setmp.stage_etmp_content) REGEXP :keyword_altr12) ';
                    // $stage_bind_arr['keyword_altr11']= "'".$keyword_altr."'";
                    // $stage_bind_arr['keyword_altr12']= "'".$keyword_altr."'";
                // }
                $event_search_criteria = '(etmp.etmp_subject REGEXP "' . $keyword_altr . '" OR strip_tags(etmp.etmp_email_template) REGEXP "' . $keyword_altr . '" )  ';
                // $stage_search_criteria = '(' . ($enable_journal_data ? '' : 'setmp.stage_etmp_journal_id IS NULL') . ' ' . $jnl_search . ') AND (setmp.stage_etmp_subject REGEXP "' . $keyword_altr . '" OR strip_tags(setmp.stage_etmp_content) REGEXP "' . $keyword_altr . '") ';
                $stage_search_criteria = (!empty($jnl_search) ? '(' . $jnl_search . ') AND' : '') . ' (setmp.stage_etmp_subject REGEXP "' . $keyword_altr . '" OR strip_tags(setmp.stage_etmp_content) REGEXP "' . $keyword_altr . '") ';
            }
            $select = NULL;
            $sort_field = 'NAME';
            $sort_order = $order;
            DB::enableQueryLog();
            if ($condition == 'both') {
                $select_first = $event_columns;
                $select_first_condition = $event_search_criteria;
                $select_second = $stage_columns;
                $select_second_condition = $stage_search_criteria;
                $where_condition = ($type_search) ? ' setmp.stage_etmp_name = :event_type3' : NULL;
                if ($type != '') {
                    if ($type == 'Event Type') {
                        $selectData = $event_columns;
                        if($em_type_search){
                            $selectDataCondition = $select_first_condition . ' AND etmp.etmp_name = :event_type2';
                            $event_bind_arr['event_type2'] = $event_type;
                        }
                        else{
                            $selectDataCondition = $select_first_condition;
                        }
                        $search_records = Stage_email_templates::geteventsearchemailpaginated($selectData, $selectDataCondition, $event_bind_arr, $sort_field, $sort_order, $limit);
                    } else {
                        $selectData = $stage_columns;
                        $selectDataCondition = $stage_search_criteria;
                        $search_records = Stage_email_templates::getstagesearchemailpaginated($selectData, $selectDataCondition, $stage_bind_arr, $sort_field, $sort_order, $limit);
                    }
                } else{
                    if($type_search){
                        $stage_bind_arr['event_type3'] = $event_type;
                    }
                    $search_records = Stage_email_templates::alljournalsearchemailpaginated($select_first, $select_first_condition, $event_bind_arr, $select_second, $select_second_condition, $stage_bind_arr, $where_condition, $sort_field, $sort_order, $limit);
                }
            } else {
                if($type_search){
                    $stage_bind_arr['event_type'] = $event_type;
                }
                $select = 'setmp.stage_etmp_id as id,setmp.stage_etmp_subject as subject,setmp.stage_etmp_content as content, "Stage Type" as email_type, setmp.stage_etmp_journal_id as jnl_id, setmp.stage_etmp_stage_type as stage_type,setmp.stage_etmp_name as NAME';
                $condition =  $stage_search_criteria . '' . $type_search;
                $search_records =   Stage_email_templates::stage_email_paginated_records($select, $condition, $stage_bind_arr, NULL, $sort_field, $sort_order, $limit);
            }
            if ($addslash == TRUE) {
                $keyword = stripslashes($keyword);
            }
            if ($flg_regexp_adv > 0) {
                $keyword = trim($keyword_regexp);
            }
            $email_temp_types = $this->Utility('email_template_type');
            $count = 0;
            if (!empty($search_records)) {
                foreach ($search_records as $emil_tmpl_data) {
                    $emil_tmpl_data->NAME  = (($emil_tmpl_data->jnl_id == NULL) && ($condition != 'both')) ? $emil_tmpl_data->NAME . ' (Master)' : $emil_tmpl_data->NAME;
                    $subject = $this->high_light_matched_text($emil_tmpl_data->subject, $keyword, $search_case, $count, $this->encrypt_data($emil_tmpl_data->id), 'tmpl_subject', $emil_tmpl_data->email_type);
                    $emil_tmpl_data->subject = $subject['data'];
                    preg_match_all('/##([^##]*)##/', $emil_tmpl_data->subject, $matches);
                    $keys = $matches[1];
                    for ($i = 0; $i < count($keys); $i++) {
                        $element = $keys[$i];
                        if(!empty($element))
                        {
                        $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$emil_tmpl_data->subject);
                            $emil_tmpl_data->subject = $tmpl_data;
                        }
                    }
                    $count = $subject['count'];
                    $content = $this->high_light_matched_text($emil_tmpl_data->content, $keyword, $search_case, $count, $this->encrypt_data($emil_tmpl_data->id), 'tmpl_content', $emil_tmpl_data->email_type);
                    $count = $content['count'];
                    $emil_tmpl_data->content = $this->trim_content_tmpl($content['data']);
                    preg_match_all('/##([^##]*)##/', $emil_tmpl_data->content, $matches);
                    $keys = $matches[1];
                    for ($i = 0; $i < count($keys); $i++) {
                        $element = $keys[$i];
                        if(!empty($element))
                        {
                        $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$emil_tmpl_data->content);
                            $emil_tmpl_data->content = $tmpl_data;
                        }
                    }
                    $emil_tmpl_data->disp_email_type = $email_temp_types['email_template_type'][$emil_tmpl_data->email_type];
                    $assoc_flag = false;
                    $edit_flag = false;
                    $dele_flag = false;
                    if ($emil_tmpl_data->email_type == 'Event Type') {
                        $edit_flag  = true;
                        $dele_flag  = true;
                    } else {
                        $assoc_flag = true;
                        $edit_flag  = true;
                        if ($condition == "both") {
                            $dele_flag  = true;
                        } else {
                            if ($emil_tmpl_data->jnl_id != NULL) {
                                $edit_flag  =   true;
                                $dele_flag  =   true;
                            } else {
                                $edit_flag  =   $dele_flag  =   false;
                            }
                        }
                    }
                    $emil_tmpl_data->edit_status = $edit_flag;
                    $emil_tmpl_data->delete_status = $dele_flag;
                    $emil_tmpl_data->associate_status = $assoc_flag;
                    $emil_tmpl_data->associate_status = $assoc_flag;

                    if ($emil_tmpl_data->email_type == 'Event Type')
                        $emil_tmpl_data->NAME = $this->get_stage_name($emil_tmpl_data->NAME);
                }
            }
            // $query = DB::getQueryLog();
            // $query = end($query);
            // print_r($query);
            // exit;
            $result = [];
            $result['records'] = $search_records;
            $result['keywordCount'] = $count;
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            // print_r($e);
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_stage_name($name)
    {
        $template_name = '';
        $email_hooks = $this->Utility('email_hooks');
        foreach ($email_hooks['email_hooks'] as $eh => $value) {
            if ($eh == $name) {
                $template_name = $value["name"];
                break;
            }
        }
        return $template_name;
    }
    public function high_light_matched_text($text, $string, $search_case, $count, $id, $column, $email_type)
    {
        $text = strip_tags($text);
        $counter = $count;
        $temp_id = $id;
        $email_type = $email_type;
        $count = 0; // Initialize the counter
        $col_name = $column;
        if (strpos($string, "'") > 0) {
            $string = '/' . $string . '/i';
        } else if ($search_case != '' && $search_case == 'match_case') {
            $string = '/' . preg_quote($string, '/') . '/';
        } else if ($search_case != '' && $search_case == 'regular_expression') {
            $string = '/' . $string . '/';
        } else if ($search_case != '' && $search_case == 'match_entire_word') {
            if (substr($string, -1) == '.') {
                $string = '/' . preg_quote($string, '/') . '/i';
            } else {
                $string = '/\b' . preg_quote($string, '/') . '\b/i';
            }
        } else {
            $string = '/' . preg_quote($string, '/') . '/i';
        }

        // Transform the content
        $text = preg_replace_callback(
            $string,
            function ($matches) use (&$counter, $temp_id, &$count, $col_name, $email_type) {
                $counter++;
                $count++;
                return '<b class="search_mark highlighted" id="matched_' . $counter . '" data-tempid="' . $temp_id . '" data-matchcount="' . $count . '" data-columntype="' . $col_name . '" data-emailtype="' . $email_type . '">' . substr($matches[0], 0, strlen($matches[0])) . '</b>';
            },
            $text
        );
        $result_data['data'] = $text;
        $result_data['count'] = $counter;

        return $result_data;
        // return $text;
    }

    public function trim_content_tmpl($text)
    {
        //$arr = preg_split('/\s+(?=[^>]*(<|$))/', $text);// /\s+(?![^<>]+>)/m

        $dom = new \DOMDocument();
        @$dom->loadHTML('<div>' . $text . '</div>', LIBXML_HTML_NOIMPLIED);

        $nodeList = $dom->documentElement->childNodes;

        $arr = [];

        foreach ($nodeList as $childNode) {
            if (
                $childNode->nodeType == XML_TEXT_NODE &&
                preg_match_all('~[^\s"]+|"[^"]*"?~', $childNode->nodeValue, $m)
            )
                $arr = array_merge($arr, $m[0]);
            else
                $arr[] = $dom->saveHTML($childNode);
        }
        $str = '';
        $vl = '...';
        $count = 1;
        if (!empty($arr)) {
            foreach ($arr as $k => $val) {
                $left_txt = '';
                $right_txt = '';
                if (preg_match("/<[^<]+>/", $val, $m)) {
                    if ($k > 5) {
                        for ($i = 5; $i > 0; $i--) {
                            $left_txt .= ' ' . strip_tags($arr[$k - $i]);
                        }
                        $x = 1;
                        do {
                            $indx = $k + $x;
                            if (count($arr) > $indx) {
                                $right_txt .= ' ' . strip_tags($arr[$k + $x]);
                            }
                            $x++;
                        } while ($x <= 5);
                    }
                    if ($k <= 5) {
                        for ($i = $k; $i >= 0; $i--) {
                            if ($i != 0)
                                $left_txt .= ' ' . strip_tags($arr[$k - $i]);
                        }
                        $x = 1;
                        do {
                            $indx = $k + $x;
                            if (count($arr) > $indx) {
                                $right_txt .= ' ' . strip_tags($arr[$k + $x]);
                            }
                            $x++;
                        } while ($x <= 5);
                    }
                    $str .= '...' . $left_txt . ' ' . $arr[$k] . ' ' . $right_txt . '.........';
                    $count++;
                }
            }
        } else {
            $str = $text;
        }
        if ($count == 1) {
            $str = $text;
        }
        $str = str_replace('Â', '', $str);
        return $str;
    }
    public function get_associate_email(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'tmp_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $form_data = $request->all();
            $page = $form_data['pageno'];
            $id = decrypt_link($form_data['tmp_id']);
            //echo $id; die;
            $total_records = 0;
            $temp_reff_table = (new \App\Models\Stage_email_tmpl_reference())->getTable();
            $gen_flw_table = (new \App\Models\Generic_flows())->getTable();
            $art_type_table = (new \App\Models\Article_types())->getTable();
            $jnl_table = (new \App\Models\Journals())->getTable();

            $type_search = 'WHERE setr_stage_etmp_id = ' . $id;
            $stage_columns = 'jnl_journal_name,artp_article_type,jwf_stage_name';


            // $cntsql =   'SELECT COUNT(setr_id) cnt FROM ' . $temp_reff_table . ' LEFT JOIN  ' . $gen_flw_table . ' on setr_jwf_id=jwf_id LEFT JOIN ' . $art_type_table . ' on jwf_fwm_id=artp_fwm_id LEFT JOIN ' . $jnl_table . ' on (jwf_fwm_id=jnl_fwm_id or artp_jnl_id =jnl_id) ' . $type_search;

            $sql    =   'SELECT ' . $stage_columns . ' FROM ' . $temp_reff_table . ' LEFT JOIN  ' . $gen_flw_table . ' on setr_jwf_id=jwf_id LEFT JOIN ' . $art_type_table . ' on jwf_fwm_id=artp_fwm_id LEFT JOIN ' . $jnl_table . ' on (jwf_fwm_id=jnl_fwm_id or artp_jnl_id =jnl_id)  ' . $type_search;

            // $tot_search_records     =   Stage_email_tmpl_reference::get_records_by_raw_query($cntsql);
            // if (isset($tot_search_records[0]->cnt)) {
            //     $total_records          =   $tot_search_records[0]->cnt;
            // }
            if ($page > 0)
                $offset                 =   ($page - 1) * 25;
            else
                $offset                 =   0;

            $page_sql               =   $sql . "  LIMIT " . $offset . ", " . 25;
            $search_records         =   Stage_email_tmpl_reference::get_records_by_raw_query($page_sql);
            $data['search_records'] =   $search_records;
            // print_r($data);
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function email_template_keyword_replace(Request $request)
    {
        try {
            // $email_temp_types = $this->Utility('email_template_type');
            DB::enableQueryLog();

            $current_user = $this->get_current_user_details();
            $form_data = $request->all();
            $email_temp_id = $this->decrypt_data($form_data['email_temp_id']);
            $find_keyword  = $form_data['txt_find_keyword'];
            $replace_keyword = $form_data['txt_replace_keyword'];
            $match_id = $form_data['matched_id'];
            $matched_content = $form_data['matched_content'];
            $search_cases = $form_data['search_cases'];
            $email_type_find = $form_data['email_type_find'];
            $email_type = $form_data['email_type'];
            $data = [];
            $condition = '';
            if ($email_type == 'Event Type') {
                $condition = "etmp_id = {$email_temp_id}";
                $email_template_details = Email_templates::get_single_record('etmp_subject,etmp_email_template', $condition);
                if ($matched_content == 'tmpl_subject') {
                    $replaced_content = $this->find_replace_matched_content($email_template_details->etmp_subject, $find_keyword, $replace_keyword, $match_id, $search_cases);
                    $data['etmp_subject'] = $replaced_content;
                } else if ($matched_content == 'tmpl_content') {
                    $replaced_content = $this->find_replace_matched_content($email_template_details->etmp_email_template, $find_keyword, $replace_keyword, $match_id, $search_cases);
                    $data['etmp_email_template'] = $replaced_content;
                }
                Email_templates::update_record($data, $condition, $current_user);
                $result = Email_templates::get_single_record('etmp_subject,etmp_email_template', $condition);
            } else {
                $condition = "stage_etmp_id = {$email_temp_id}";
                $email_template_stage_details = Stage_email_templates::get_single_record('stage_etmp_subject,stage_etmp_content', $condition);
                if ($matched_content == 'tmpl_subject') {
                    $replaced_content = $this->find_replace_matched_content($email_template_stage_details->stage_etmp_subject, $find_keyword, $replace_keyword, $match_id, $search_cases);
                    $data['stage_etmp_subject'] = $replaced_content;
                } else if ($matched_content == 'tmpl_content') {
                    $replaced_content = $this->find_replace_matched_content($email_template_stage_details->stage_etmp_content, $find_keyword, $replace_keyword, $match_id, $search_cases);
                    $data['stage_etmp_content'] = $replaced_content;
                }
                Stage_email_templates::update_record($data, $condition, $current_user);
                $result = Stage_email_templates::get_single_record('stage_etmp_subject,stage_etmp_content', $condition);
            }
            // $query = DB::getQueryLog();
            // $query = end($query);
            // print_r($query);

            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            // exit;
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function delete_stage_email_template(Request $request)
    {
        try {
            $form_data = $request->all();
            $current_user = $this->get_current_user_details();
            $email_tmpl_id = $this->decrypt_data($form_data['tmpl_id']);
            if (!empty($email_tmpl_id)) {
                $where_condition = "setr_stage_etmp_id = {$email_tmpl_id}";
                $is_used_tmpl = Stage_email_tmpl_reference::get_single_record('COUNT(setr_id) as cnt', $where_condition);
                if ($is_used_tmpl->cnt > 0) {
                    $result = [];
                    $message = 'Email template cannot be deleted as it is currently in use.';
                    return $this->warning($message, 200, $result);
                } else {
                    $result = Stage_email_templates::delete_records($where_condition, '', $current_user);
                    $message = 'Email template deleted';
                    return $this->success($message, 200, $result);
                }
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function delete_email_template(Request $request)
    {
        try {
            $form_data = $request->all();
            $current_user = $this->get_current_user_details();
            $email_id = $this->decrypt_data($form_data['tmpl_id']);
            if (isset($email_id) && $email_id != "") {
                $where_condition = "etmp_id = {$email_id}";
                $deletedata = Email_templates::delete_records($where_condition, '', $current_user);
                if ($deletedata > 0) {
                    $message = 'Email template deleted';
                    return $this->success($message, 200, $deletedata);
                } else {
                    $result = [];
                    $message = 'Email template could not be deleted';
                    return $this->warning($message, 200, $result);
                }
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function find_replace_matched_content($text, $find_keyword, $replace_keyword, $occurence_cnt, $search_case)
    {
        $counter = 0;
        if (strpos($find_keyword, "'") > 0) {
            $string = '/' . $find_keyword . '/i';
        } else if ($search_case != '' && $search_case == 'match_case') {
            $string = '/' . preg_quote($find_keyword) . '/';
        } else if ($search_case != '' && $search_case == 'regular_expression') {
            $string = '/' . $find_keyword . '/i';
        } else if ($search_case != '' && $search_case == 'match_entire_word') {
            $string = '/\b' . preg_quote($find_keyword) . '\b/i';
        } else {
            $string = '/' . preg_quote($find_keyword) . '/i';
        }
        $text = preg_replace_callback(
            $string,
            function ($matches) use (&$counter, $occurence_cnt, $replace_keyword) {
                $counter++;
                if ($counter == $occurence_cnt) {
                    return $replace_keyword;
                } else {
                    return $matches[0];
                }
            },
            $text
        );
        return $text;
    }
}
