<?php

namespace App\Http\Controllers;

use App\Models\Article_types;
use App\Models\Dashboard_settings;
use App\Models\Dashboard_tile;
use App\Models\Generic_flows;
use App\Models\Journals;
use App\Models\Roles;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class Manage_User_Journal_Tile_Api extends Controller
{
    public function index(Request $request)
    {
        try {
            $form_data = $request->all();
            $sort_field = $form_data['sort_field'] ?? 'jnl_journal_name,role_name';
            $sort_order = $form_data['sort_order'] ?? 'asc';
            $limit = '20';
            $select = 'jnl_journal_name,role_name,ds_id';
            $criteria = 'ds_operation = i" ';
            $dashboard_settings_records = Dashboard_settings::get_setting_details($select, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $dashboard_settings_records);
        } catch (\Exception $e) {
            // do something else  
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_dashboard_setting_details(Request $request)
    {
        try {
            $criteria = 'jnl_journal_status="y"';
            $return_arr['journal_name'] = Journals::get_all_records('jnl_journal_name,jnl_id', $criteria);
            $return_arr['role_name'] = Roles::get_all_records('role_id,role_name,role_assigned_role');
            $return_arr['dashboard_settings'] = Dashboard_settings::get_all_records('*');
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function save_generic_data(Request $request)
    {
        try {
            $form_data = $request->all();

            $this->current_user = $this->get_current_user_details();
            $edited_id = $this->decrypt_data($form_data['edited_id']);
            $journals = $form_data['ds_jnl_name'];
            $visible_role = $form_data['ds_role_name'];
            $features = $form_data['ds_features'];
            $modename = $form_data['mode'];

            $data_arr = array(
                "ds_jnl_id" => $journals,
                "ds_role_id" => $visible_role,
                "ds_features" => json_encode($features)
            );

            $condition = 'ds_jnl_id=' . $journals . ' and ds_role_id=' . $visible_role;
            if (!empty($edited_id) && $modename != "copy") {
                $condition .= ' and ds_id!=' . $edited_id;
            }
            $record = Dashboard_settings::get_single_record('ds_id', $condition);
            if (!empty($record)) {
                $msg = 'Already exists, please use a different role name';
                return $this->warning($msg, 200, '', 'warning');
            } else {
                if ($edited_id == "") {

                    $return_arr = Dashboard_settings::insert_record($data_arr, $this->current_user);
                    $msg = 'Dashboard settings added successfully';
                } else {

                    if ($modename == "copy") {
                        $id = Dashboard_settings::insert_record($data_arr, $this->current_user);

                        $msg = 'Dashboard settings copied successfully';
                        if (isset($form_data['copy_tile']) && $form_data['copy_tile'] == 'y') {
                            $criteria = "dt_settings_id = {$edited_id}";
                            $return_arr = Dashboard_tile::get_all_records('*', $criteria);

                            if (!empty($return_arr)) {
                                $inst_data = array();
                                foreach ($return_arr as $red) {
                                    $inst_data['dt_settings_id'] = $id;
                                    $inst_data['dt_title'] = $red->dt_title;
                                    $inst_data['dt_color_option'] = $red->dt_color_option;
                                    $inst_data['dt_color'] = $red->dt_color;
                                    $inst_data['dt_icon'] = $red->dt_icon;
                                    $inst_data['dt_layout'] = $red->dt_layout;
                                    $inst_data['dt_revised_type'] = $red->dt_revised_type;
                                    $inst_data['dt_no_result'] = $red->dt_no_result;
                                    $inst_data['dt_data'] = $red->dt_data;

                                    $ins_id = Dashboard_tile::insert_record($inst_data, $this->current_user);
                                }
                            }

                            if (!empty($ins_id)) {
                                $msg = 'Dashboard settings and tile are copied successfully';
                            }
                        }
                    } else {
                        $criteria = "ds_id = {$edited_id}";
                        $return_arr = Dashboard_settings::update_record($data_arr, $criteria, $this->current_user);
                        $msg = 'Dashboard settings updated successfully';
                    }
                }
            }
            return $this->success($msg, 201);
        } catch (\Exception $e) {
     
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_dashboard_setting_by_id(Request $request)
    {
        try {
            $form_data = $request->all();
            $id = $this->decrypt_data($form_data['id']);
            if (isset($id) && $id != "") {
                $crietria = 'ds_id=' . $id;
                $data = Dashboard_settings::get_single_record('ds_id,ds_role_id,ds_jnl_id,ds_features', $crietria);
            }
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function delete_dashboard_setting(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $id = $this->decrypt_data($form_data['ds_id']);
            if (isset($id) && $id != "") {
                $criteria = 'dt_settings_id=' . $id;
                $tile_data = Dashboard_tile::get_all_records('dt_id', $criteria);
                if (count($tile_data) > 0) {
                    return $this->success('Cannot delete dashboard setting as it is used in tile', 200, 'Already exists');
                } else {
                    $crietria = 'ds_id=' . $id;
                    $deletedata = Dashboard_settings::delete_records($crietria, '', $this->current_user);
                    return $this->success('Dashboard settings deleted successfully', 201);
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    //get dashboard tile pagination details
    public function get_generic_tile(Request $request)
    {
        try {

            $form_data = $request->all();
            $sort_field = $form_data['sort_field'] ?? 'dt_id';
            $sort_order = $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            $settings_id = $this->decrypt_data($form_data['settings_id']);
            $criteria = "dt_settings_id = {$settings_id}";
            $select = "dt_id,dt_title,dt_color,dt_icon,dt_layout";
            $tilelist = Dashboard_tile::get_paginated_records($select, $criteria, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $tilelist);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    //  delete tile record based on condition
    public function delete_dashboard_tile(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $id = $this->decrypt_data($form_data['dt_id']);
            if (isset($id) && $id != "") {
                $crietria = 'dt_id=' . $id;
                $deletedata = Dashboard_tile::delete_records($crietria, '', $this->current_user);
            }
            return $this->success('Dashboard tile deleted successfully', 201);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    // get record based on conditon
    public function get_dashboard_tile_by_id(Request $request)
    {
        try {
            $form_data = $request->all();
            $id = $this->decrypt_data($form_data['id']);
            if (isset($id) && $id != "") {
                $crietria = 'dt_id=' . $id;
                $data = Dashboard_tile::get_single_record('*', $crietria);
            }
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function save_generic_tile_data(Request $request)
    {
        try {
            $form_data = $request->all();
            $dt_data = [];
            $optvalue = array();
            $this->current_user = $this->get_current_user_details();
            $edited_id = $this->decrypt_data($form_data['edited_id']);
            $setting_id = $this->decrypt_data($form_data['setting_id']);

            $modename = $form_data['mode'];
            $condition = 'dt_title = "' . $form_data['dt_title'] . '"';
            // $color_option = $form_data['dt_color_option'];
            $color = $form_data['choose_color'] ? $form_data['choose_color'] : '#0073b7';
            if ($color == "#0073b7") {
                $color_option = 'd';
            } else {
                $color_option = 'c';
            }
            if (isset($form_data['autodata'][0]['dt_article_type'])) {

                $temp_arr = array();

                for ($i = 0; $i < count($form_data['autodata']); $i++) {
                    $j = 0;
                    $dt_article_type = $form_data['autodata'][$i]['dt_article_type'];
                    $dt_stage_name = $form_data['autodata'][$i]['dt_stage_name'];
                    $dt_status = $form_data['autodata'][$i]['dt_status'];
                    $dt_statictile_criteria = isset($form_data['autodata'][$i]['dt_statictile_criteria']) ? $form_data['autodata'][$i]['dt_statictile_criteria'] : '';
                    $dt_date = $form_data['autodata'][$i]['dt_date'];
                    if ((!empty($dt_article_type)) && (!empty($dt_stage_name))) {
                        $temp_arr['dt_article_type'] = $dt_article_type;
                        $temp_arr['dt_stage_name'] = $dt_stage_name;
                        $temp_arr['dt_status'] = $dt_status;
                        $temp_arr['dt_statictile_criteria'] = $dt_statictile_criteria;
                        $temp_arr['dt_date'] = $dt_date;
                    }
                    array_push($optvalue, $temp_arr);
                    $temp_arr = array();
                }
            }
            if ($form_data) {
                $dt_data['dt_article_type'] = $form_data['dt_article_type'];
                $dt_data['dt_stage_type'] = $form_data['dt_stage_type'];
                $dt_data['dt_stage_name'] = $form_data['dt_stage_name'];
                $dt_data['dt_tile_type'] = $form_data['dt_tile_type'];
                $dt_data['autodata'] = $form_data['autodata'];
            }
            $data_arr = array(
                'dt_settings_id' => $setting_id,
                'dt_title' => $form_data['dt_title'],
                'dt_art_type' => 'null',
                // 'dt_all_article_type' => $form_data['dt_all_article_type'],
                'dt_data' => json_encode($dt_data),
                'dt_color_option' => $color_option,
                'dt_color' => $color,
                'dt_icon' => $form_data['choose_icon'],
                'dt_layout' => $form_data['dt_layout'],
                'dt_revised_type' => $form_data['dt_revised_type'],
            );
            if ($edited_id == '') {
                $return_arr = Dashboard_tile::insert_record($data_arr, $this->current_user);
                $msg = 'Dashboard tile added successfully';
            } else {
                if (!empty($modename) && $modename != "") {
                    $id = Dashboard_tile::insert_record($data_arr, $this->current_user);
                    $msg = 'Dashboard settings copied successfully';
                } else {
                    $criteria = "dt_id = {$edited_id}";
                    $return_arr = Dashboard_tile::update_record($data_arr, $criteria, $this->current_user);
                    $msg = 'Dashboard tile updated successfully';
                }
            }
            return $this->success($msg, 201);
        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }
    /*public function get_article_type_details(Request $request)
    {
        try {
            $return_arr=[];
            $stage_id=[]; 
            $form_data = $request->all();
            $id = $this->decrypt_data($form_data['settingid']);
            if($id){
            $jnl_id =   Dashboard_settings::get_single_record('ds_jnl_id',"ds_id={$id}");
            $crietria = "artp_jnl_id = '{$jnl_id->ds_jnl_id}'";
            $return_arr['article_type'] = Article_types::get_all_records('artp_id,artp_article_type', $crietria);}
            if (!empty($form_data['art_id'])) {
               
                $art_id =  implode(',',$form_data['art_id']);
                // print_r($art_id);exit;
                $return_arr['stage_name'] = $this->getarticlestagedata('jwf_stage_type,jwf_id', $art_id, 'jwf_stage_name');
            }
            if (!empty($form_data['jwf_id'])) {
                $stage_id = implode($form_data['jwf_id']);
                $condition = 'jwf_id=' . $stage_id;
                $stage_data = Generic_flows::get_single_record('jwf_stage_type,jwf_assignment', $condition);
                $enable_criteria = false;
                if (!empty($stage_data)) {
                    $stage_type = $stage_data->jwf_stage_type;
                    if ($stage_data->jwf_assignment != 'self_service') {
                        $enable_criteria = true;
                    }
                }

                $result = array();
                $i = 0;

                $ivitation_stage = array(
                    "pre_assessment",
                    "post_assessment",
                    "review");
                if ($stage_type != 'author_submission') {
                    $result[$i]['name'] = 'u';
                    $result[$i]['text'] = 'ready';
                    $i++;
                }
                if (in_array($stage_type, $ivitation_stage)) {
                    if ($stage_data->jwf_assignment == "manual") {
                        $result[$i]['name'] = 'p';
                    } else if ($stage_data->jwf_assignment == "invitation") {
                        $result[$i]['name'] = 'w';
                    } else {
                        $result[$i]['name'] = 'a';
                    }
                } else {
                    $result[$i]['name'] = 'a';
                }
                $result[$i]['text'] = 'in progress';
                $i++;

                if (in_array($stage_type, $ivitation_stage)) {
                    $result[$i]['name'] = 'i';
                    $result[$i]['text'] = 'invitation';
                    $i++;
                }

                $result[$i]['name'] = 'c';
                $result[$i]['text'] = 'completed';
                $i++;
                $return_arr['stage_data'] = $result;
            }
            return $this->success('success', 200, $return_arr);
               } catch (\Exception $e) {
                   print_r($e);
            return $this->failure('Failed', 500, $e);
        }
    }*/
    public function get_article_type_data(Request $request)
    {
        try {
            $return_arr = [];
            $stage_id = [];
            $stage_type = [];
            $tile_type = [];
            $tile_status = [];
            $tle_id = [];
            $form_data = $request->all();
            $id = $this->decrypt_data($form_data['settingid']);
            $validator = Validator::make($form_data, [
                // 'settingid'     => 'required',
            ]);
            if ($validator->fails())
                return response()->json($validator->errors(), 422);
            else {
                if ($id) {
                    $article_type_table = (new \App\Models\Article_types())->getTable();
                    $dashboard_setting_tabel = (new \App\Models\Dashboard_settings())->getTable();
                    $tables = array(
                        'main_table' => $article_type_table,
                        'join_table' => array(
                            $dashboard_setting_tabel => array('ds_jnl_id', 'artp_jnl_id'),
                        )
                    );
                    $return_arr['article_data'] =  Dashboard_settings::get_results_using_joins($tables, 'artp_id,ds_jnl_id,artp_article_type', "ds_id={$id}");
                }
                if (!empty($form_data['art_type_id'])) {
                    $art_id =  implode(',', $form_data['art_type_id']);
                    if (!empty($form_data['jwf_stage_type'])) {
                        // print_r($form_data['jwf_stage_type']);exit;
                        $stage_type = $form_data['jwf_stage_type'];
                        $return_arr['stage_data'] = $this->getarticlestagedata('jwf_stage_name,jwf_stage_type,jwf_id', $art_id, $stage_type);
                    }
                    $return_arr['stage_data'] = $this->getarticlestagedata('jwf_stage_name,jwf_stage_type,jwf_id', $art_id);
                }

                $return_arr['type_tile'] = array(
                    "self",
                    "assignment",
                    "invitation"
                );

                if (!empty($form_data['tile_type'])) {
                    if ($form_data['tile_type'] == 'self') {
                        $return_arr['tile_status'] =
                            array(
                                "u" => "Ready",
                                "a" => "in progress",
                                "c" => "complete",
                            );
                    } elseif ($form_data['tile_type'] == 'assignment') {
                        $return_arr['tile_status'] =
                            array(
                                "p" => "shortlist",
                                "a" => "in progress",
                                "c" => "complete"
                            );
                    } elseif ($form_data['tile_type'] == 'invitation') {
                        $return_arr['tile_status'] =
                            array(
                                "u" => "Ready",
                                "i" => "invite",
                                "a" => "inprogress",
                                "g" => "unassignment",
                                "c" => "complete"
                            );
                    }
                }
                return $this->success('success', 200, $return_arr);
            }
        } catch (\Exception $e) {
    
            return $this->failure('Failed', 500, $e);
        }
    }
    //get dashboard tile  details
    public function get_tile_details(Request $request)
    {
        try {

            $form_data = $request->all();
            $settings_id = $this->decrypt_data($form_data['settingid']);
            $criteria = "dt_settings_id = {$settings_id}";
            $select = "dt_id,dt_title,dt_color,dt_icon,dt_layout";
            $tilelist = Dashboard_tile::get_all_records('*', $criteria);
            return $this->success('success', 200, $tilelist);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function getarticlestagedata($select = '*', $art_type = array(), $stage_type = array(), $group_by = array())
    {
        try {
            $article_type_table = (new \App\Models\Article_types())->getTable();
            $table_name = (new \App\Models\Generic_flows())->getTable();
            if ($art_type != NULL) {
                $criteria = "artp_id IN({$art_type})";
                if (!empty($stage_type)) {
                    $criteria = " artp_id IN({$art_type}) AND jwf_stage_type IN (\"" . implode("\",\"", $stage_type) . "\")";
                } else
                    $criteria = "artp_id IN({$art_type})";
            } else {
                $criteria = "jwf_id({$art_type})";
            }

            $tables = array(
                'main_table' => $article_type_table,
                'join_table' => array(
                    $table_name => array($table_name . '.jwf_fwm_id', $article_type_table . '.artp_fwm_id', "join"),
                )
            );
            $stage_data =  Generic_flows::get_results_using_joins($tables, 'DISTINCT jwf_stage_name,jwf_stage_type,jwf_id', $criteria);
            /* print_r($stage_data);exit;  
               $query = DB::getQueryLog();
               $query =end($query); 
               print_r($query);exit;
            */
            return $stage_data;
        } catch (\Exception $e) {
           
            return $this->failure('Failed', 500, $e);
        }
    }
}
