<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Roles;
use  App\Http\Traits\RolesConfigTrait;
use Illuminate\Support\Facades\Validator;
use App\Models\Email_templates;
use App\Models\Stage_email_templates;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Generic_flows;
use App\Models\User_to_journals;
use App\Models\Article_notification_emails;
use App\Models\Article_autoinvitation_emails;
use App\Models\Adhoc_notification_emails;
use Illuminate\Support\Facades\DB;

class Manage_user_roles_Api extends Controller
{
    use RolesConfigTrait;
	use General_ConfigTraits;
    public function index(Request $request)
    {   
		try {
			$form_data= $request->all();	
			$this->current_user = $this->get_current_user_details();
			$return_array=[];
			/* start --- Checking roles table author and journal admin roles are present 
		 	* if not present then insert */
			 $criteria = array('role_assigned_role'=>'author');
			 $author = Roles::get_all_records_with_bind_cond('*',$criteria); 
			 if (empty($author))
				{
			 		$data=['role_name' => 'Author',
					 'role_used_in' => 'r,p,',
					 'role_assigned_role' => 'author'];
					Roles::insert_record($data,$this->current_user);
				}
			$criteria = array('role_assigned_role' =>'journal_admin');
			$journal_admin =Roles::get_all_records_with_bind_cond('*',$criteria);
			if (empty($journal_admin))
			{
				$data=['role_name' => 'Journal Admin',
						'role_assigned_role' => 'journal_admin'];
			Roles::insert_record($data,$this->current_user);
			}
			$criteria = array('role_assigned_role'=>'system');
			$system = Roles::get_all_records_with_bind_cond('*',$criteria);
			if (empty($system))
			{
				$data=['role_name' => 'System',
						'role_assigned_role' => 'system'];
			Roles::insert_record($data,$this->current_user);
			}
			/* end --- Checking roles table author and journal admin roles are present 
		 	* if not present then insert */


			//Feature #1536 : Add Adhoc user role : sudo user can have permission to choose which roles with core roles author, reviewer to make as adhoc role (available in sign up)

			$return_array['choose_adhoc_role'] = FALSE;
			$manage_roles=$this->convert_string_array( $this->current_user['roles']);
			if(in_array('sudo',$manage_roles) && $this->current_client->functionality->cfty_adhoc_user_role == 'y')
			$return_array['choose_adhoc_role'] = TRUE;

			//Getting all roles from user library file
			$return_array['all_roles'] = $this->RolesConfigdata('roles');
			$return_array['production_flag'] = FALSE;
			if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
			{
				$return_array['production_flag'] = TRUE;
			}
			if(in_array('sudo',$manage_roles) && isset($this->current_client->functionality->cfty_enable_google_mfa) == 'y')
			$return_array['google_mfa_flag'] = TRUE;
			$search_parameters=$form_data['paramsdet']??array();
			$sort_field = $form_data['sort_field'] ?? 'role_id';
			$sort_order =  $form_data['sort_order'] ?? 'asc';
			$limit = $form_data['per_page'] ?? 5;
            $select = '*';
            $return_array['rolelist']=Roles::get_paginated_records($select,$criteria =NULL, $sort_field, $sort_order, $limit);
            return $this->success('success',200,$return_array);
		} catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function getroleusedin(Request $request)
    {
        try
        {  
            $select=$request->select;
            $role_used=$this->RolesConfigdata($select); 
			return $this->success('success',200,$role_used);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public  function getcoreuserrole(Request $request)
    {
        try
        {
        $select=$request->select;
        $configvalues=$this->RolesConfigdata($select);
        $corerolevalues=$this->RolesConfigdata('coreroles');
        $coreuserrole = array_diff($configvalues['roles'],$corerolevalues['coreroles']);
        return response()->json([
            'success'=>true,
            'result'=>$configvalues,
            'corerole'=>$coreuserrole
        ]);
        }
        catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
        }
     
    }
    public function save_user_role(Request $request)
    { 
		try {
        $role_used_in=array();
        $user_role=$request->all();
        if(isset($user_role['roleusedreview']) && ($user_role['roleusedreview']=='r') && ($user_role['roleusedreview']) !=null)
        array_push($role_used_in,'r');
        if(isset($user_role['roleusedproduction']) && ($user_role['roleusedproduction']=='p') && ($user_role['roleusedproduction']) !=null)
        array_push($role_used_in,'p');
		if(($user_role['roleusedproduction']=='') && ($user_role['roleusedreview']==''))
		array_push($role_used_in,'r');
		$this->current_user = $this->get_current_user_details();
            $validator = Validator::make($user_role, [
            'name'     => 'required',
            'assigned_role'  => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message'=>$validator->errors(),
                    'responsecode'=>422
                ]
            );
            }
			$input_arr = array(
				'input' => $user_role['name'],
				'type'=> 'string'
			);
			$input_arrs = array(
				'input' => $user_role['assigned_role'],
				'type'=> 'string'
			);
			$art_id_validate = $this->Rv_validator($input_arr);
			$art_id_validates = $this->Rv_validator($input_arrs);

			
			if($art_id_validate == FALSE || $art_id_validates==FALSE)
			{
			 $arraymsg['mesage'] = customTrans('validation.notvalid');
			return $this->warning("Failed",201,$arraymsg); 
			}
            $exclude_role_names = array(	//unable to use these as role name since it uses in email tmpls
                'article_authors',
                'User',
                'Users',
                'Custom',
                'submit_author',
                'Authors'
            );
            if (isset($user_role['name']) && isset($user_role['assigned_role']) &&
			$user_role['name'] != '' && $user_role['assigned_role'] != '')
            {          
            if(in_array($user_role['name'], $exclude_role_names))
			{
				return  $this->warning('Warnings',200,customTrans('Unable to use this user role. Try another one'),'warning');
			}
			if(isset($user_role['hdn_id']) && $user_role['hdn_id'] !='')
			{
				$role_id=$this->decrypt_data($user_role['hdn_id']);
				$input_arr = array(
					'input' => $role_id,
					'type'=> 'number'
				);
				$art_id_validate = $this->Rv_validator($input_arr);
				
				if($art_id_validate == FALSE)
				{
				 $arraymsg['mesage'] = customTrans('validation.notvalid');
				return $this->warning("Failed",201,$arraymsg); 
				}
				$criteria = 'role_name=? and role_id =?';
				$bindarray  = array($user_role['name'],$user_role['hdn_id']);
			}
            else{
		
				$criteria = 'role_name=?';
				$bindarray  = array($user_role['name']);
			}
            //Checking user role name already added
			$check_user_role= Roles::get_single_record_with_bind_cond('*',array(),$criteria,$bindarray);
            if ($check_user_role == NULL /* || $check_assign_role == NULL */)
			{  
                $oa_discount_enabled = isset($user_role['oa_discount']) ? $user_role['oa_discount'] : 'n';
				$mfa_enabled = isset($user_role['mfaenabled']) ? $user_role['mfaenabled'] : 'n';
				$reauthorenabled = isset($user_role['reauthorenabled']) ? $user_role['reauthorenabled'] : 'n';
				$data = array(
					'role_name' => $user_role['name'],
					'role_assigned_role' => $user_role['assigned_role'],
					'role_oa_discount_enabled' => $oa_discount_enabled,
					'role_mfa_enabled' =>$mfa_enabled,
					'role_reauthorize_accont_enable' =>$reauthorenabled
				); 
                if(isset($role_used_in)&&!empty($role_used_in))
				{
					$data['role_used_in'] = implode(',',$role_used_in);
				}
                if ($user_role['hdn_id'] == '')
				{
					$role_id = Roles::insert_record($data,$this->current_user);
					$result['userrolestatus'] = 'insert';
					$data['role_adhoc_role_status'] = 'n'; // initially set as n
					$status = 'insertion success';
					$msg = "role add success";
				}
                //check data
                else
				{
					// DB::beginTransaction();
					if ($role_id != '') {
					$criteria =array('role_id'=>$role_id);
					$old_role_data = Roles::get_single_record_with_bind_cond('role_name, role_adhoc_role_status, role_adhoc_role_label',$criteria);
			        $data['role_adhoc_role_status'] = $old_role_data->role_adhoc_role_status;
					$data['role_adhoc_role_label'] = $old_role_data->role_adhoc_role_label;
					//if change core role update role_adhoc_role_status	
					if(!in_array($user_role['assigned_role'], array('author', 'reviewer')) && $old_role_data->role_adhoc_role_status == 'y')
					{
						$data['role_adhoc_role_status'] = 'n';
						$data['role_adhoc_role_label'] = NULL;
					}
					
					$old_role_name = $old_role_data->role_name;
					$condition = 'stage_etmp_to = ? OR stage_etmp_cc LIKE ? OR stage_etmp_bcc LIKE ?';
					$bindarray = array(
						$old_role_name,
						"%".$old_role_name."%",
						"%".$old_role_name."%",
					);
					$stage_tmpls =Stage_email_templates::get_all_records_with_bind_cond('stage_etmp_id,stage_etmp_to,stage_etmp_cc,stage_etmp_bcc',array(), $condition,$bindarray);
						if(!empty($stage_tmpls)){
							foreach($stage_tmpls as $tmpls)
							{
								
								$up_data = array();
								$cc = json_decode($tmpls->stage_etmp_cc);
								$bcc = json_decode($tmpls->stage_etmp_bcc);
								if($tmpls->stage_etmp_to == $old_role_name)
									$up_data['stage_etmp_to'] = $user_role['name'];
								if(!empty($cc) && is_array($cc) && in_array($old_role_name, $cc))
								{
									$key = array_search($old_role_name, $cc);
									$cc[$key] = $user_role['name'];
									$up_data['stage_etmp_cc'] = json_encode($cc);
								}
								if(!empty($bcc) && is_array($bcc) && in_array($old_role_name, $bcc))
								{
									$key = array_search($old_role_name, $bcc);
									$bcc[$key] = $user_role['name'];
									$up_data['stage_etmp_bcc'] = json_encode($bcc);
								}						
								if(!empty($up_data))
								{
									$con_update="stage_etmp_id=".$tmpls->stage_etmp_id;
									$updatestageemailtem=Stage_email_templates::update_record($up_data,$con_update,$this->current_user);
								}
							}}
								
									//update role name in rvw_article_notification_emails
									$art_condition = 'ane_to = ? OR ane_cc LIKE ? OR ane_bcc LIKE ?';
									$binding_array=array(
										$old_role_name,
										"%".$old_role_name."%",
										"%".$old_role_name."%",
									);
									$decision_ltr_tmpls = Article_notification_emails::get_all_records_with_bind_cond('ane_id,ane_to,ane_cc,ane_bcc',array(), $art_condition,$binding_array);
									if (!empty($decision_ltr_tmpls))
									{
									foreach($decision_ltr_tmpls as $tmpls)
									{
									$dec_up_data = array();
									$cc = json_decode($tmpls->ane_cc);
									$bcc = json_decode($tmpls->ane_bcc);
									if($tmpls->ane_to == $old_role_name)
									$dec_up_data['ane_to'] = $user_role['name'];
									if(!empty($cc) && is_array($cc) && in_array($old_role_name, $cc))
									{
									$key = array_search($old_role_name, $cc);
									$cc[$key] = $user_role['name'];
									$dec_up_data['ane_cc'] = json_encode($cc);
									}
									if(!empty($bcc) && is_array($bcc) && in_array($old_role_name, $bcc))
									{
									$key = array_search($old_role_name, $bcc);
									$bcc[$key] = $user_role['name'];
									$dec_up_data['ane_bcc'] = json_encode($bcc);
									}
									$art_criteria="ane_id=".$tmpls->ane_id;
									
									if(!empty($dec_up_data)){
									Article_notification_emails::update_record($dec_up_data,$art_criteria,$this->current_user);
									}
							}
							}
                                 //update role name in rvw_email_tmpls
									$gl_condition = 'etmp_notification = ? OR etmp_cc LIKE ? OR etmp_bcc LIKE ?';
									$binding_array=array(
										$old_role_name,
										"%".$old_role_name."%",
										"%".$old_role_name."%",
									);
									
									$global_tmpls = Email_templates::get_all_records_with_bind_cond('etmp_id,etmp_notification,etmp_cc,etmp_bcc',array(), $gl_condition,$binding_array);
									if(!empty($global_tmpls)){
									foreach($global_tmpls as $gl_tmpls)
									{
									$gl_up_data = array();
									$cc = json_decode($gl_tmpls->etmp_cc);
									$bcc = json_decode($gl_tmpls->etmp_bcc);
									if($gl_tmpls->etmp_notification == $old_role_name)
									$gl_up_data['etmp_notification'] = $user_role['name'];
									if(!empty($cc) && is_array($cc) && in_array($old_role_name, $cc))
									{
									$key = array_search($old_role_name, $cc);
									$cc[$key] = $user_role['name'];
									$gl_up_data['etmp_cc'] = json_encode($cc);
									}
									if(!empty($bcc) && is_array($bcc) && in_array($old_role_name, $bcc))
									{
									$key = array_search($old_role_name, $bcc);
									$bcc[$key] = $user_role['name'];
									$gl_up_data['etmp_bcc'] = json_encode($bcc);
									}
									$glb_criteria="etmp_id=".$gl_tmpls->etmp_id;
									
									if(!empty($gl_up_data)){
										Email_templates::update_record($gl_up_data,$glb_criteria,$this->current_user);
									}
							}
							}
							     //update role name in rvw_article_autoinvitation_emails
								 $auto_condition = 'aae_to = ? OR aae_cc LIKE ? OR aae_bcc LIKE ?';
								 $binding_array=array(
									 $old_role_name,
									 "%".$old_role_name."%",
									 "%".$old_role_name."%",
								 );
								 
								 $autoinvt_tmpls = Article_autoinvitation_emails::get_all_records_with_bind_cond('aae_id,aae_to,aae_cc,aae_bcc',array(), $auto_condition,$binding_array);
								 if(!empty($autoinvt_tmpls)){
								 foreach($autoinvt_tmpls as $auto_tmpls)
								 {
								 $auto_up_data = array();
								 $cc = json_decode($auto_tmpls->aae_cc);
								 $bcc = json_decode($auto_tmpls->aae_bcc);
								 if($auto_tmpls->aae_to == $old_role_name)
								 $auto_up_data['aae_to'] = $user_role['name'];
								 if(!empty($cc) && is_array($cc) && in_array($old_role_name, $cc))
								 {
								 $key = array_search($old_role_name, $cc);
								 $cc[$key] = $user_role['name'];
								 $auto_up_data['aae_cc'] = json_encode($cc);
								 }
								 if(!empty($bcc) && is_array($bcc) && in_array($old_role_name, $bcc))
								 {
								 $key = array_search($old_role_name, $bcc);
								 $bcc[$key] = $user_role['name'];
								 $auto_up_data['aae_bcc'] = json_encode($bcc);
								 }
								 $auto_criteria="aae_id=".$auto_tmpls->aae_id;
								 
								 if(!empty($auto_up_data)){
									Article_autoinvitation_emails::update_record($auto_up_data,$auto_criteria,$this->current_user);
								 }
						 }
						 }
						   //update role name in  rvw_adhoc_notification_emails
						   $adhoc_condition = 'ade_to = ? OR ade_cc LIKE ? OR ade_bcc LIKE ?';
						   $binding_array=array(
							   $old_role_name,
							   "%".$old_role_name."%",
							   "%".$old_role_name."%",
						   );
						   
						   $adhoc_tmpls = Adhoc_notification_emails::get_all_records_with_bind_cond('ade_id,ade_to,ade_cc,ade_bcc',array(), $adhoc_condition,$binding_array);
						   
						   if(!empty($adhoc_tmpls)){
						   foreach($adhoc_tmpls as $adhoc_tmpls)
						   {
						   $adhoc_up_data = array();
						   $cc = json_decode($adhoc_tmpls->ade_cc);
						   $bcc = json_decode($adhoc_tmpls->ade_bcc);
						   if($adhoc_tmpls->ade_to == $old_role_name)
						   $adhoc_up_data['ade_to'] = $user_role['name'];
						   if(!empty($cc) && is_array($cc) && in_array($old_role_name, $cc))
						   {
						   $key = array_search($old_role_name, $cc);
						   $cc[$key] = $user_role['name'];
						   $adhoc_up_data['ade_cc'] = json_encode($cc);
						   }
						   if(!empty($bcc) && is_array($bcc) && in_array($old_role_name, $bcc))
						   {
						   $key = array_search($old_role_name, $bcc);
						   $bcc[$key] = $user_role['name'];
						   $adhoc_up_data['ade_bcc'] = json_encode($bcc);
						   }
						   $adhoc_criteria="ade_id=".$adhoc_tmpls->ade_id;
						   if(!empty($adhoc_up_data)){
							Adhoc_notification_emails::update_record($adhoc_up_data,$adhoc_criteria,$this->current_user);
						   }
				   }
				   }
				   $result['status'] = Roles::update_record($data, $criteria,$this->current_user);
				   $result['userrolestatus'] = 'update';
						if ($result) {
						return $this->success(customTrans('roles.role_updated_success'),201,$result);
                    }
               	 }
					DB::commit();
					$status = 'success';
					$msg = "role_updated_success";
					$role_id = $user_role['hdn_id'];
				}
            }
			else
				{
				//Error message for duplicate user role 
				if ($check_user_role != NULL)
				{
				return response()->json(
                    [
                        'success' => false,
                        'message' => customTrans('roles.duplicate_user_role'),
                        'responsecode' => 422
                    ]
                );
				}
				}
			return $this->success(customTrans('roles.role_save_successfully'),201,$result);
            }
        }
        catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
        }
    }
    public function delete_user(Request $request)
    {
		try {
        $this->current_user = $this->get_current_user_details();
        $param_data=$request->all();
        $user_role['r_id']=$this->decrypt_data($param_data['role_id']);
        if (isset($user_role['r_id']) && $user_role['r_id'] != '')
		{
        $criteria = 'role_id="' .$user_role['r_id']. '"';
        //Checking role is reffered in user to journal table if yes error message
        	$user_config=$this->General_config_data('user_module');
			$user_module=$user_config['user_module'];
			$user_config['delete_role_conditional']=$user_module['delete_role_conditional'];
			if (isset($user_config['delete_role_conditional']) && $user_config['delete_role_conditional'] == TRUE)
			{
				$return_data = $this->check_delete_role($user_role['r_id']);
				if ($return_data['can_delete_role'] == FALSE)
				{
				return  $this->warning('Warnings',200,customTrans('roles.role_ref_user_journal'),'warning');
				}
			}
            if($user_role['r_id'] != NULL)
		    {
			$select = 'count(distinct usrj_jnl_id) as result';
			$condition_role=array('usrj_role_id'=>$user_role['r_id']);
		    }
		    $result = User_to_journals::get_single_record_with_bind_cond($select,$condition_role);
			//TASK #8773 Please add a warning message to delete a role if the role already used in a email template
			$condition = array('role_id'=>$user_role['r_id']);
            $role_name = Roles::get_single_record_with_bind_cond('role_name', $condition);
			// $role_exist=Roles::isRoleInUse($role_name->role_name);
			if (isset($role_name)) {
				$templatesInUse = Roles::isRoleInUse($role_name->role_name);
				if ($templatesInUse) {
				return response()->json([
				'status' => 'warning',
				'message' => customTrans('roles.role_exist_email_tmpl'),
				'role_name' => $role_name->role_name,
				'templates' => $templatesInUse,
				]);
				}
			}
		
            //TASK #8773
			if($result->result > 0)
			{
				return  $this->warning('Warnings',200,customTrans('roles.user_exist in_role'),'warning');
			}
			else
			{
				Roles::delete_records($criteria, '', $this->current_user);
				$ext_roles =Roles::get_all_records();
			     echo json_encode(array(
				'status' => 'success',
				'msg' => customTrans('roles.delete_role_success'),
				'result' => count($ext_roles)
			   ));
			}
		}
    }
	catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
        }
}
/*update adhoc roles client functionality */
	public function update_adhoc_role(Request $request)
	{
		try{
			$param_data=$request->all();
			$row=array();
			$return_data = array();
			$role_id = $param_data['hdn_adhoc_role_id'];
			$withdraw_adhoc =$param_data['withdraw_adhoc'];
			$this->current_user = $this->get_current_user_details();
			$roles=$this->convert_string_array( $this->current_user['roles']);
			if (!empty($role_id))
			{
				if ((in_array('sudo',$roles)) && $this->current_client->functionality->cfty_adhoc_user_role == 'y')
				{
					if ($withdraw_adhoc == true)
					{	//remove adhoc role
						$data =[
							'role_id' =>$role_id,
							'status' =>$param_data['status'],
							'label' =>NULL
						];
					}
					else
					{	//add role as adhoc or edit label
						$data = array(
							'role_id' => $role_id,
							'status' => 'y',
							'label' =>$param_data['label']);
					}					
					// $criteria = 'role_id="' . $data['role_id'] . '"';
					$criteria =array('role_id'=>$data['role_id']);
					$past_status['role_adhoc_role_status'] =Roles::get_single_record_with_bind_cond('role_adhoc_role_status', $criteria);
						$criteria = 'role_id="' . $data['role_id'] . '"';
						$adhocdetails=array(
						'role_adhoc_role_status' => $data['status'],
						'role_adhoc_role_label' => $data['label']);
						$result = Roles::update_record($adhocdetails,$criteria,$this->current_user);
						$return_data['status'] = 'success';
						$row['role_adhoc_role_status'] = $data['status'];
						$row['role_adhoc_role_label'] = $data['label'];
						$row['all_roles']= $this->RolesConfigdata('roles');
						$row['choose_adhoc_role'] = TRUE;
						$return_data['roleid'] = $data['role_id'];
						if ($withdraw_adhoc == true)
							$return_data['msg'] = customTrans('roles.up_adhoc_role_status_success');
						else
							$return_data['msg'] = ($past_status == 'n') ? customTrans('roles.up_adhoc_role_status_success') : customTrans('roles.up_adhoc_role_label_success');
						return $this->success($return_data['msg'],201,$row);
					}
		}
	} catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}
			// redirect(site_url());
	}
    public function get_user_role_by_id(Request $request)
    {
	try{
      $get_data = $request->all();
      $role_id=$this->decrypt_data($get_data['role_id']);
      if ($role_id != "")
		{
            // $this->data['all_roles'] = $this->getcoreuserrole();
            // $criteria = 'role_id="' . $role_id . '"';
			$criteria =array('role_id'=>$role_id);
			$role_details = Roles::get_single_record_with_bind_cond('*', $criteria);
			return $this->success('Success',200,$role_details);
		}		
		else
		{
			$msg=customTrans('roles.invalid_data');
			return $this->success('Success',204,$msg);
		}   
   /* $criteria = array('role_id' => $role_id);
	  $old_role_data = Roles::get_single_record('role_name, role_adhoc_role_status, role_adhoc_role_label',$criteria);
      $data['role_adhoc_role_status'] = $old_role_data->role_adhoc_role_status;
	  $data['role_adhoc_role_label'] = $old_role_data->role_adhoc_role_label;
      print_r($data);exit;
      print_r($old_role_data);exit;*/
		} catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
    }
	public function check_delete_role($role_id)
	{
	try{
		$return_data['can_delete_role'] = TRUE;
		$criteria=array('jwf_role_id'=>$role_id);
		$user_journal = Generic_flows::get_single_record_with_bind_cond('*',$criteria);
		if ($user_journal != NULL)
		{
			$return_data['can_delete_role'] = FALSE;
			$return_data['msg'] = 'role_ref_user_journal';
		}
		return $return_data;
		} catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
		}
	}
	public function check_user_role(Request $request)
	{
		try {
			$condition = array();
			//$journal_name
			$roles_data = $request->all();
			
			if (!empty($roles_data) && isset($roles_data['platform_name'])) {
				$platform_name=trim($roles_data['platform_name']);
					// $condition="role_name='{$platform_name}'" ;
					$condition=array('role_name'=>$platform_name);

				}
			$roles =Roles::get_single_record_with_bind_cond('count(*) cnt', $condition);
			if ($roles->cnt > 0) {
				$return_array['found'] = true;
				return response()->json([
					'success' => true,
					'result' => $return_array
				]);
			} else {
				$return_array['found'] = false;
				return response()->json([
					'success' => true,
					'result' => $return_array
				]);
			}
		} catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
 }
 public function get_adhoc_label_by_id(Request $request)
    {
	try{
      $get_data = $request->all();
	  $role_id=$get_data['role_id'];
      if ($role_id != "")
		{
			$criteria =array('role_id'=>$role_id);
			$return_array = Roles::get_single_record_with_bind_cond('role_adhoc_role_label', $criteria);
			return $this->success('success',200,$return_array);
		}		
		else
		{
		return  $this->warning('Failed',500,'failed'); 
		}   
    }
	catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}
}
}
