<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Country;
use App\Models\Flags;
use App\Models\User_global_flags;
use App\Http\Traits\ModalDataTrait;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\SendGlobalEmailFunctionTrait;
use App\Models\Article_flow;
use App\Models\Article_legacydata;
use App\Models\Article_reviewer_legacydata;
use App\Models\Article_reviewers;
use App\Models\Articles;
use App\Models\Journals;
use App\Models\Keywords;
use App\Models\Login_tracking;
use App\Models\Merged_users;
use App\Models\Review_rating;
use App\Models\Roles;
use App\Models\User_affiliations;
use App\Models\Keyword_relationship;  /* TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
use Illuminate\Support\Facades\URL;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Models\User_emails;
use App\Models\User_to_journals;
use App\Models\Userkeywords;
use App\Models\User_note;
use App\Models\User_unregister;
use App\Models\Users_unavailability;
use App\Models\User_flags;
use App\Models\User_attachment_files;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\UserDataTrait;
use App\Models\Authors;
use App\Models\Client_settings;
use Config;
use \stdClass;
use Illuminate\Support\Facades\Lang;
use App\Http\Traits\GeneralEmailTrait;
use App\Models\User_feedback;
use DOMDocument;
use DOMXPath;
use Response;
use App\Models\User_classification;
use App\Models\Classifications;
use App\Models\Email_templates;
use App\Models\Event_invited_users;// task #3703 show notify button bug fix
use App\Models\Email_send_log;
use App\Models\Unsuscribe_email;

class Manage_Users_Api extends Controller
{
    use ModalDataTrait;
    use StandaloneDataTrait;
    use SendGlobalEmailFunctionTrait;
    use UtilityTrait;
    use UserDataTrait;
    use GeneralEmailTrait;
    /*
    get pagination
    commited date :-  08-02-2022
    Request type :- POST
    */
    public function index(Request $request)
    {
        try {
                $form_data= $request->all();
            $this->current_user = $this->get_current_user_details();
            $user_id= $this->current_user['user_id'];
                $search_parameters=$form_data['paramsdet']??array();
                $user_name ='';
                $status ='';
                $admin_role='';
                $user_email='';
                $usr_jnl_standalone='';
                if(!empty($search_parameters))
                {
                if(isset($search_parameters['user_name']))
                $user_name = $search_parameters['user_name']??'';
                if(isset($search_parameters['user_status']))
                    $status = $search_parameters['user_status'];
                if(isset($search_parameters['user_adminroles']))
                    $admin_role = $search_parameters['user_adminroles'];
                if(isset( $search_parameters['user_email']))
                $user_email =$search_parameters['user_email'];
                if(isset( $search_parameters['standalone_journal']))
                $usr_jnl_standalone =$search_parameters['standalone_journal']??'';
            }
            $sort_field = $form_data['sort_field'] ?? 'usr_id';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            $criteria = '((`usr_roles` NOT LIKE "%super_admin%" && `usr_roles` NOT LIKE "%sudo%") OR `usr_roles` IS NULL  ) AND usr_status !="u"';
            $criteria .='AND usr_id !="'.$user_id.'"';
                if ($user_name != NULL)
                {
                $criteria =  $criteria . ' AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $user_name . '%"))';
            }
                if ($status != NULL)
                {
                    $criteria .= ' AND  usr_status ="'.$status.'"';
            }
                if(isset($admin_role) && $admin_role != ''){
                $criteria .= ' AND JSON_SEARCH(usr_roles,"one","'.$admin_role.'")'; 
            }
                if(isset($user_email) && $user_email != ''){
                    $criteria .= ' AND usr_email  LIKE "%'.$user_email.'%"';
            }
            if(isset($usr_jnl_standalone) && $usr_jnl_standalone != ''){
                if($this->decrypt_data($usr_jnl_standalone)=='all'){
                    $criteria .= ' AND usr_jnl_standalone IS NULL ';
                }else{
                    $criteria .= ' AND usr_jnl_standalone  LIKE "%'.$this->decrypt_data($usr_jnl_standalone).'%"';
                }
            }
                $criteria .= 'AND usr_id NOT IN (
                    SELECT uur_usr_id
                    FROM rvw_user_unregister_request
                )';
                $userslist=User::get_paginated_records('usr_id,usr_first_name,usr_email,usr_roles,usr_username,usr_status,usr_terms_condition,usr_jnl_standalone,usr_orcid_id,usr_mfa_token,usr_source', $criteria, $sort_field, $sort_order, $limit);
                if(!empty($userslist))
                {
                foreach ($userslist as $user) 
                {
                    if ($user->usr_id) 
                    {
                        $displayArray = array(
                            'user_id' => $user->usr_id,
                            'jnl_code' => NULL,
                            'flag'     => TRUE,
                            'article_id' =>  NULL,
                            'availability' => TRUE,
                            'save_coauthor' => FALSE,
                            'remove_user' => FALSE,
                            'source' => FALSE,
                            'salutation' => TRUE,
                            'flag_only' => FALSE,
                            'inactive_user' => FALSE,
                            'fullname_only' => FALSE,
                            'journal_id' => NULL,
                        );
                        $user->usr_first_name = $this->get_user_display_name($displayArray);
                    }
                    if (isset($this->current_client->modules->mdl_orcid) && $this->current_client->modules->mdl_orcid == 'n') {
                        $user->usr_orcid_id = NULL;
                    }
                }
            }
            $un_register_criteria ="uur_request_status ='n' " ;
            $un_registered=User_unregister::get_all_records('*',$un_register_criteria);
            $return_array['userlist']=$userslist;
            $return_array['cforc'] = (isset($this->current_client->modules->mdl_orcid) && $this->current_client->modules->mdl_orcid == 'y') ? 'TRUE' : 'FALSE';
            if (isset($this->current_client->modules->mdl_orcid) && $this->current_client->modules->mdl_orcid == 'y') {
                $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
                $client_params = Config::get($review_config);
                $return_array['link_url']['link'] = encrypt_link($client_params['orcid']['link_url']);
                $return_array['link_url']['view'] = encrypt_link($client_params['orcid']['view_url']);
            }
            $return_array['urreglist']= (count($un_registered)>0) ? count($un_registered):0;
            
            return $this->success('success',200,$return_array);
        } catch (\Exception $e) {
            
                return  $this->failure('Failed',500,$e);
        }
    }
    /*
    get country list
    commited date :-  08-02-2022
    Request type :- GET
    */
    public function country(Request $request)
    {
        try {
            $criteria = ' cnt_id !=0';
            $country_list = Country::get_all_records('*');
            return $this->success('success',200, $country_list);
            
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    /*
    get flag list
    commited date :-  08-02-2022
    Request type :- GET
    */
    public function flags(Request $request)
    {
        try {
            /**
            * TASK #8446, flags changes
            * changed due to display only active flags for user's flag list where flag status is 'y'
            * $criteria = ' flag_type="u"';
            */
            $criteria = ' flag_type="u" AND flag_status = "y"';
            $flag_list = Flags::get_all_records('*', $criteria);
            return $this->success('success',200, $flag_list);
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    /*
    Save User Information  Function for Super Admin Area 
    Commited date :- 08-02-2022
    Request type :- POST
    */
    public function save_user(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'username'      => 'required',
                'firstname'      => 'required',
                'lastname'    => 'required',
                'email'=>'required|email'
            ]);
            if(isset($form_data['standalone_journal']) && $form_data['standalone_journal'] == ""){
                unset($form_data['standalone_journal']);
            }
            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
            }
            
            $edited_id=$this->decrypt_data($form_data['edited_id'])??'';
            
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $userdata = array(
                'user_id' => $tokeninfo['user_id'],
                'proxy_user_id' => $this->current_user['proxy_user_id']
            );
            $snd_jnl = FALSE;
            $user_data['usr_jnl_standalone'] = NULL;
			if ($this->current_client->modules->mdl_standalone_journals == 'y' && isset($form_data['standalone_journal']) && $form_data['standalone_journal'] != '')
			{
                if(isset($form_data['standalone_journal']) && !empty($form_data['standalone_journal']))
                {
                    $user_data['usr_jnl_standalone'] = $this->decrypt_data($form_data['standalone_journal']);
                    $snd_jnl = TRUE;
                }
            }
            $data = array(
                'usr_username' => $form_data['username'],
                'usr_jnl_standalone' =>(isset($form_data['standalone_journal']) && !empty($form_data['standalone_journal']))?$this->decrypt_data($form_data['standalone_journal']):null,
                // 'usr_jnl_standalone' =>NULL,
                'usr_pwd_original' => '',
                'usr_title' => $form_data['title'],
                'usr_first_name' => $form_data['firstname'],
                'usr_middle_name' => $form_data['middlename'],
                'usr_last_name' => $form_data['lastname'],
                'usr_email' => $form_data['email'],
                'usr_website' => $form_data['website'],
                'usr_phone_no' => $form_data['phonenumber'],
                'usr_f_status' => $form_data['first_login'],
                'usr_posted_by' => $this->current_user['user_id'],
                'usr_posted_date' => date('Y-m-d H:i:s'),
                'usr_proxy_id' =>  $this->current_user['proxy_user_id'],
            );
            $email_criteria='usr_email= "'.$form_data['email'].'"';
            $criteria ='usr_username="'.$form_data['username'].'"';

            if($edited_id!='')
            {
                $email_criteria.=' AND usr_id !='.$edited_id;
                $criteria.=' AND usr_id!='.$edited_id;
                $data['usr_operation']='u';
            } 
            $jnl_id = '';
            $jrnl_grp = $this->get_standalone_journal_data();
             if (isset($form_data['standalone_journal']) && $form_data['standalone_journal'] != '')
			{
                $jnl_id =$this->decrypt_data($form_data['standalone_journal']);
            }
            $get_email_record = User::get_user_by_email_journal($email_criteria, $jnl_id);
            $check_username = User::get_single_record('count(usr_id) as cnt', $criteria);
            if(count($get_email_record)>0)
            {
                $msg_arr[]=customTrans('users.generic-email-exist');
                return  $this->warning('Warning', 200, $msg_arr);
            }
            elseif($check_username->cnt>0)
            {
                $msg_arr[]=customTrans('users.generic-username-exist');
                return  $this->warning('Warning', 200, $msg_arr);
            }
            if(isset($form_data['adminroleslist']))
            {
                $json_admin_roles=json_encode($form_data['adminroleslist']);
            }
            $data['usr_roles'] = isset($json_admin_roles) ? ($json_admin_roles) : NULL;
            $data['usr_status'] = isset($form_data['user_status']) ? $form_data['user_status'] : 'w';
            /* Update */
            if($edited_id!='')
            {
                $post_data =array();
                $this->current_user = $this->get_current_user_details();
                if(in_array('sudo', $this->current_user['roles']) && isset($form_data['generate_password']) && $form_data['generate_password'] !='')
                {
                    $post_data['generate_password']=$form_data['generate_password'];
                    $post_data['user_id']=$edited_id;
                    $generatepwdreslt=$this->update_sudo_password($post_data);
                    if(isset($generatepwdreslt['status']) && $generatepwdreslt['status'] == 'warning')
                    {
                        $msg =$generatepwdreslt['msg'];
                        return $this->warning('Warning',200,$msg);	 
                    }
                }
                
                $input_arr = array(
                    'input' => $edited_id,
                    'type'=> 'number'
                );
                $edited_id_validate = $this->Rv_validator($input_arr);
                if($edited_id_validate != TRUE ){
                    return $this->warning('Failed',422,'Edit User Invalid');	
                }
                $ccmailflag='edit';  
                $new_alter_email_found=$this->save_cc_email_confirmation($ccmailflag,$edited_id,$form_data['cc_email']);
                if (isset($form_data['user_status']))
				{
                    $user_data['user_status'] = $form_data['user_status'];
					if($form_data['user_status'] == 'a')
					{	//Bug #1709
                        $get_user_data = User::get_single_record('*', "usr_id={$edited_id}");
						if(!empty($get_user_data->usr_pwd) && !empty($get_user_data->usr_url))
						{
                            $current_date_time = date('Y-m-d H:i:s');
                            $condition = array(
                                'usr_id' => $get_user_data->usr_id);
                            $updt_data = array(
                                            'usr_reg_date'=>$current_date_time,
                                'usr_status' => 'a',
                                'usr_activation' => 'y',
                                'usr_url' => '',
                                'usr_deeplink_token' => '');
                            User::update_record($updt_data, $condition);
						}
                    }
                }
                $edit_array='usr_id='.$edited_id;
                User::update_record($data,$edit_array,$this->current_user);
                if(isset($new_alter_email_found[0])&&!empty($new_alter_email_found[0]) && $new_alter_email_found[0] !=''){
                $ccuser_data=array("usr_id"=>$edited_id,'activation_link'=>'');
                }
                $user_id=$edited_id;
            }
           else 
           {
                $data['usr_status'] = isset($form_data['user_status']) ? $form_data['user_status'] : 'w';
                $data['usr_pwd']=Hash::make('123456');
                $data['usr_operation']='i';
                $key = Str::random(20);
                $data['usr_deeplink_token'] = $key;
                $user_id = User::insert_record($data, $userdata);
                if($user_id)
                {  
                $ccmailflag='add';
                 if(isset($form_data['cc_email'])&&isset($form_data['cc_email'][0]))
                  {
                    $this->save_cc_email_confirmation($ccmailflag,$user_id,$form_data['cc_email']);
                  }
                    $this->add_user_affiliation($form_data, $user_id,TRUE); 
                    //CCEMAIL START
                    if($snd_jnl == TRUE)
                        {
                        $stndalon_jnl = $this->get_standalone_journal_data();   
                        $Journals=new \App\Models\Journals();
                        $jrnl_grp = $Journals::get_single_record('*',"jnl_id={$data['usr_jnl_standalone']}");
                        $link = $this->build_url_standalone($jrnl_grp->jnl_standalone_group)."confirmation/" . encrypt_link("&key=" . $key . "&userid=" . $user_id."&name=add_user_confirmation");
                        }
                    else
                    {
                        $stndalon_jnl = $this->get_standalone_journal_data();
                        if($stndalon_jnl == NULL)
                        {
                        if($this->current_client->functionality->cfty_show_terms_conditions=='y')
                            {
                                    //TASK #2702 old email in not expiring (SA add user) revert
                                    $link =URL::to('/') . "/confirmation/" . encrypt_link("&key=" . $key . "&userid=" . $user_id."&name=add_user_confirmation");
                            }
                            else 
                            {
                                $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $key . "&userid=" . $user_id."&name=add_user_confirmation");
                                //end TASK #2702 old email in not expiring (SA add user) revert
                            }
                        }
                        else
                        {
                            if($this->current_client->functionality->cfty_show_terms_conditions=='y')
                            {
                                $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $key . "&userid=" . $user_id."&name=add_user_confirmation");
                            }
                            else
                            {
                                $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $key . "&userid=" . $user_id."&name=add_user_confirmation");
                            }
                        }
                    }
                    //SEND EMAIL
                            $user_data=array("user_id"=>$user_id,'activation_link'=>$link);
                            $ccuser_data=array("usr_id"=>$user_id,'activation_link'=>$link);
                            $this->send_email_confirmation_user($user_data,$ccuser_data);         
                    }
            }
            
            $this->save_user_flag($form_data['userflaglist'],$user_id,$this->current_user);
            return $this->success(customTrans('users.save-successfully'),201,array());
            //  DB::commit();
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    /*
    Save User Flag  for Super Admin Area 
    Commited date :- 20-02-2022
    Request type :- POST 
    */
    public function save_user_flag($user_flag,$user_id,$current_user)
    {
        $where_condition='ugf_user_id ='.$user_id;
       $groupby='ugf_user_id';
       $select="GROUP_CONCAT(ugf_flag_id) as flag_id_list";
       $user_global_flags = User_global_flags::get_single_record($select,$where_condition,$groupby);
      if(!empty($user_global_flags))
      {
       $user_flaglist=$user_global_flags->flag_id_list;
       if($user_flaglist!=NULL)
       $existing_user_flag_array=explode(',',$user_flaglist);
        }
        /*
        $user_global_flag_arr=array();
		if (count($user_global_flags) > 0)
		{
			foreach ($user_global_flags as $user_global_flag)
			{
				$user_global_flag_arr [] = $user_global_flag->ugf_flag_id;
			}
        }*/
        if(!empty($user_flag))
        {
            $flag_data = array();
            if(is_array($user_flag))
                $user_flags_ids=$user_flag;
            else
                $user_flags_ids = explode(",",$user_flag);

            if(count($user_flags_ids) > 0)
            {
                $commaSepflags      =   implode(",", $user_flags_ids);
                $whereCondition='uf_usr_id='.$user_id.' AND uf_flag_id IN ('.$commaSepflags.')';
                $jnl_user_flags = User_flags::get_all_records('uf_id',$whereCondition);
                if(count($jnl_user_flags) > 0) {
                    User_flags::delete_records($whereCondition,'', $current_user);
                }
                $User_global_flags = (new User_global_flags())->getTable();
                $Flags    = (new Flags())->getTable();
                $tables = array(
                    'main_table' => $Flags,
                    'join_table' => array(
                        $User_global_flags => array($Flags . '.flag_id', $User_global_flags . '.ugf_flag_id')
                    )
                );
                $flag_condition = 'ugf_user_id ="' . $user_id . '" AND flag_type = "s" ';
                $result_flags = '';
                $used_flags = Flags::get_results_using_joins($tables, 'GROUP_CONCAT(flag_id) as flag_id', $flag_condition,'single');
                if(!empty($used_flags))
                {
                    
                    $result_flags=$used_flags->flag_id;
                      if($result_flags!=NULL){
                         $exclude_user_flags_ids=explode(',',$result_flags); 

                         $user_flags_ids = array_diff($user_flags_ids, $exclude_user_flags_ids);
                         } 
                }
                if(!empty($user_flags_ids)){
                    foreach ($user_flags_ids as $flag_id)
					{ 
                    $flag_data[] = array(
                        'ugf_flag_id' => $flag_id,
                        'ugf_user_id' => $user_id,
                            'ugf_posted_by' =>$current_user['user_id'] ,
                            'ugf_proxy_id'=>$current_user['proxy_user_id'],
                        'ugf_posted_date' => date('Y-m-d H:i:s')
                    );
                }

                }
					
            }

            if (count($flag_data) > 0)
            {
                $this->delete_flags($user_id,$current_user);
                $result = User_global_flags::insert_batch($flag_data);
            }
        }
        else
				{
                    $this->delete_flags($user_id,$current_user);
				}
    }

    public function delete_flags($user_id,$current_user){
        $User_global_flags = (new User_global_flags())->getTable();
        $Flags    = (new Flags())->getTable();

    
        $tables = array(
            'main_table' => $Flags,
            'join_table' => array(
                $User_global_flags => array($Flags . '.flag_id', $User_global_flags . '.ugf_flag_id')
            )
        );
        $flag_condition = 'ugf_user_id ="' . $user_id . '" AND flag_type != "s"';
        $result_flags = '';
        $used_flags = Flags::get_results_using_joins($tables, 'GROUP_CONCAT(flag_id) as flag_id', $flag_condition,'single');
        if(!empty($used_flags))
        {
            $result_flags=$used_flags->flag_id;
              if($result_flags!=NULL){
            User_global_flags::delete_records("ugf_user_id={$user_id} AND ugf_flag_id  IN ({$result_flags})",'',$current_user);
              }
        }
        return $result_flags;
    }


    /* Get Current User Details
     Commited date :- 10-02-2022
     Request type :- GET 

    */
    public function getuserdetails(Request $request)
    {
        try
        {
            $get_data = $request->all();
        $return_array=array();
            $validator = Validator::make($request->all(), [
                'user_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
            }
        $user_id=$this->decrypt_data($get_data['user_id']);
            $select = 'uml_email,uml_cc_email,uml_status';
            $criteria = 'uml_user_id=' . $user_id;
            $return_array['useremail'] = User_emails::get_all_records($select, $criteria);
        if(is_numeric($user_id)!=true)
        {
            $return_array['found']=false;
            return $this->success("Success",200,$return_array);
            }

        $criteria='usr_id ='.$user_id;
        $selct_field = '*';
        if($get_data['limted_data'] == true)
        {
            $selct_field = 'usr_id,usr_first_name,usr_last_name,usr_middle_name,usr_status,usr_proxy_id,usr_email';
        }
        $userdet = User::get_single_record($selct_field,$criteria);
        if(!empty($userdet))
        {
            if($get_data['limted_data'] == false)
            {
        $user_global_flag_arr=array();
        $where_condition='ugf_user_id ='.$user_id;
        $user_global_flags = User_global_flags::get_all_records('ugf_flag_id',$where_condition);
        if (count($user_global_flags) > 0)
        {
            foreach ($user_global_flags as $user_global_flag)
            {
                $user_global_flag_arr [] = strval($user_global_flag->ugf_flag_id);
                    }
                }
                $User_global_flags_table = (new User_global_flags())->getTable();
                $Flags    = (new Flags())->getTable();
                $tables = array(
                    'main_table' => $Flags,
                    'join_table' => array(
                        $User_global_flags_table => array($Flags . '.flag_id', $User_global_flags_table . '.ugf_flag_id')
                    )
                );
                $flag_condition = 'ugf_user_id ="' . $user_id . '" AND flag_type = "s" ';
                $result_flags = '';
                $used_flags = Flags::get_results_using_joins($tables, 'GROUP_CONCAT(flag_id) as flag_id', $flag_condition,'single');
                $result_flags=$used_flags->flag_id;
                $exclude_user_flags_ids=explode(',',$result_flags); 
                $user_flags_ids = array_diff($user_global_flag_arr, $exclude_user_flags_ids);
        $return_array['user_details']=$userdet;
        $return_array['user_flags']=$user_flags_ids;
        $return_array['found']=true;
        $return_array['msg']="User Found";
            }
            else
            {
                $return_array = array();
                $return_array['user_details']=$userdet;
            }
           }
       else
       {
        $return_array['found']=false;
        $return_array['msg']="User Not Found";
            }

           return $this->success("Success",200,$return_array);

        }
        catch (\Exception $e){
            return  $this->failure('Failed',500,$e);
           
        }
    
    }
    /* Get  User profile Details
     Commited date :- 10-02-2022
     Request type :- GET 

    */
    public function profile(Request $request)
    {
        try{
            $current_user=$this->get_current_user_details();

            if(isset($current_user['proxy_user_id'])&&$current_user['proxy_user_id']==0)
            {
                $proxi_id=$current_user['user_id'];
            }
            else
            {
                $proxi_id=$current_user['proxy_user_id']; 
            }
            $user = JWTAuth::parseToken()->authenticate();
            $user_id=$user->usr_id;
            $userdata=$this->set_profile_data($user_id,$proxi_id);
            $displayArray = array(
                'user_id' => $user->usr_id,
                'jnl_code' =>NULL,
                'flag'     => TRUE,
                'availability' => TRUE,
                'save_coauthor' => FALSE,
                'remove_user' => FALSE,
                'source' => FALSE,
                'salutation' => TRUE,
                'flag_only' => FALSE,
                'inactive_user' => FALSE,
                'fullname_only' => FALSE,
                
                // 'journal_id' => $form_data['platform_id'],
                'journal_id' => NULL,
            );
            $userdata->userfullname = $this->get_user_display_name($displayArray ); 
            // $exists = Storage::disk('public')->exists(explode('/storage/', $userdata->usr_image, 2)[1]);

            // $userdata->usr_image = ($exists == '1') ? $userdata->usr_image : '';


            if(!empty($userdata))
            {
                if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                {
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    $userdata->live_link = Rv_encrypt($es_api_data['ums_url']);
                }
            return $this->success("Success",200,$userdata);
            }
          
        }catch (\Exception $e){
           return  $this->failure('Failed',500,$e);
        }
        
    }
    /*
Username Available Check
Commited Date:14-05-2022
Requested type:POST
    */
    public function check_availble_username(Request $request)
    {
        try {
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'username'=>'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed',422,$validator->errors());
        }
        $username='';
        $user_id='';
        $input_arr = array(
            'input' =>  $post_data['username']
        );
        if(isset($post_data['username']))
        {
            $edited_id_validate = $this->Rv_validator($input_arr);
            if($edited_id_validate != TRUE ){
                return $this->warning('Failed',200,'Invalid UserName');	
            }
            $username=$post_data['username'];
            }
        if(isset($post_data['user_id']))
        {
            $user_id=$post_data['user_id'];
            }
       $user_exist= $this->check_username($username,$user_id);
      
       $msg='';
       if($user_exist==true)
       $msg=customTrans('users.user-already-exist');
       $return_array['found']=$user_exist;
       $return_array['msg']=$msg;
       return  $this->success('success',200,$return_array);
    }
    catch (\Exception $e) {
          return  $this->failure('Failed',500,$e);
        }
    }
    /*
Email Available Check
Commited Date:14-05-2022
Requested type:POST
    */
    public function check_availble_email(Request $request)
    {
        try {
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'email'=>'required|email'
        ]);
        if ($validator->fails()) {
            return  $this->warning('Failed',200,$validator->errors());
        }
        
        $email='';
        $user_id='';
        $emaildata='';
        $input_arr = array(
            'input' =>  $post_data['email']
        );
        $stand_alone = isset($post_data['standalone_journal'])?$this->decrypt_data($post_data['standalone_journal']):'';
        if(isset($post_data['email']))
        {
            $edited_id_validate = $this->Rv_validator($input_arr);
            if($edited_id_validate != true ){
                return $this->warning('Failed',200,'Invalid UserName');	
            }
            $email=$post_data['email'];
            }
        if(isset($post_data['user_id']))
        {
            $user_id=Rv_decrypt($post_data['user_id']);
            }
       $user_exist= $this->check_email($email,$user_id,$stand_alone,$emaildata);

       $return_array['found']=$user_exist;
          return  $this->success(customTrans('users.generic-email-exist'),200,$return_array);
    }
    catch (\Exception $e) {

          return  $this->failure('Failed',500,$e);
        }
    }



 

    /* Delete user 
     Commited date :- 10-02-2022
     Request type :- POST 

    */

    public function delete_user(Request $request)
    {
        try{
            $param_data=$request->all();
            $user_id=$this->decrypt_data($param_data['user_id']);
            $user_config=$this->General_config_data('user_module');
            $current_user = $this->get_current_user_details();
            $user_module=$user_config['user_module'];
            if (isset($user_module['delete_user_conditional']) && $user_module['delete_user_conditional'] == TRUE)
            {
                $return_data = $this->check_delete_user($user_id);
                $return_data['epa_user'] = FALSE;
                        if($this->current_client->functionality->cfty_jnl_EPA == 'y')
                        {
                            $sql = 'SELECT jnl_journal_name FROM rvw_journals INNER JOIN rvw_journal_settings ON jnl_id = jset_jnl_id WHERE jset_editorial_production_assistant = ' . $user_id;
                            $jnl_names = Journals::get_records_by_raw_query($sql);
                            if(!empty($jnl_names))
                            {
                                $return_data['epa_user'] = TRUE;
                                $return_data['user_as_epa_jrnls'] = ' and ';
                                if($return_data['can_delete_user'] == TRUE)
                                {
                                    $return_data['msg'] = '';
                                    $return_data['user_as_epa_jrnls'] = 'Can\'t delete user, since ';
                                }
                                $return_data['msg'] .=  $return_data['user_as_epa_jrnls'] . 'user is EPA in journals (' . implode(", ", array_column(json_decode(json_encode($jnl_names), TRUE), 'jnl_journal_name')) . ') ';
                            }
                        }
                    }
                    if ($return_data['can_delete_user'] == FALSE || $return_data['epa_user'] == TRUE)
                        {
                            return $this->warning('Failed', 200,$return_data['msg']);
                        }
                    // User::trans_start();
                    $condition = 'usr_id='.$user_id;
                    $res = User::delete_records($condition, '', $current_user);
                    $ext_users = User::get_all_records('count(usr_id) as usercount');
                    // if (User::trans_complete() === TRUE) 
                    if(isset($ext_users))
                    {
                        $return_array=array(
                            'result' => $ext_users[0]->usercount,
                            'msg' => customTrans('users.user_del_success'));

                        return $this->success('success', 200, $return_array);
                    }
                    else
                    {
                        return $this->warning('failed', 422);	
                    }
        }
        catch (\Exception $e) {
            return  $this->failure();
          }
    }
    /*
    Get User Information
    Commited Date:13-12-2022
    Requested type:POST
    */
    public function get_user_info(Request $request)
    {
        try {
            $uri_segment = '';
            $article_id = '';
			$show_date = FALSE; 
            $journal_id = '';
            $current_user = $this->get_current_user_details();
            $enable_proxy = TRUE;
            $key_array = [];
            $user_array = [];
            $journal_overview_array = [];
            $journal_roles_array = [];
            $affiliation_array = [];
            $dates_unavailability_array = [];
            $usr_leg = isset($request->usr_leg) ? TRUE : '';
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $form_data = $request->all();
            $user_id = Rv_decrypt($form_data['user_id']);
            if (isset($form_data['jnl_id']))
            {
                $journal_id = Rv_decrypt($form_data['jnl_id']);
                $input_arr = array(
                    'input' =>$journal_id,
                    'type'=> 'number'
                );
                $jnl_id_validate = $this->Rv_validator($input_arr);
               
                if($jnl_id_validate == FALSE)
                {
                  $arraymsg['mesage'] = customTrans('validation.notvalid');
                 return $this->warning("Failed",200,$arraymsg); 
                 }
         

            }
            // $input_arr = array(
            //     'input' =>$user_id,
            //     'type'=> 'number'
            // );
            $input_arr = array('input'=>trim(Rv_decrypt($form_data['user_id'])),'type'=>'number','required'=>TRUE, 'enc_data'=>FALSE );

            $user_id_validate = $this->Rv_validator($input_arr);
            if($user_id_validate == FALSE)
            {
                  $arraymsg['mesage'] = customTrans('validation.notvalid');
                 return $this->warning("Failed",200,$arraymsg); 
                 }

            // user affiliation
            //$user_affiliation_criteria = 'usaff_user_id = "' . $user_id . '"';
            $affl_config = 'clients.' . $this->current_client->clnt_client_code;
            $affl_config_data = Config::get($affl_config . '.aff_config')['user_affiliation_type'];
            $user_affiliation_criteria=array("usaff_user_id"=>$user_id);
            $user_affiliations = User_affiliations::get_all_records_with_bind_cond('usaff_type,usaff_company,usaff_address_line1,usaff_address_line2,usaff_cnt_id,usaff_postal_code,usaff_state,usaff_email', $user_affiliation_criteria);
            foreach ($user_affiliations as $affiliation) {
               // $country_criteria = 'cnt_id = "' . $affiliation->usaff_cnt_id . '"';
                $country_criteria=array("cnt_id"=>$affiliation->usaff_cnt_id);
                $country_name = Country::get_all_records_with_bind_cond('cnt_country', $country_criteria);
                $aff_array['county'] = isset( $country_name[0]->cnt_country) ? $country_name[0]->cnt_country: '';
                $aff_array['usaff_type'] = isset($affl_config_data[$affiliation->usaff_type]) ? $affl_config_data[$affiliation->usaff_type]: ' ';                
                $aff_array['usaff_company'] = $affiliation->usaff_company;
                $aff_array['usaff_address_line1'] = $affiliation->usaff_address_line1;
                $aff_array['usaff_address_line2'] = $affiliation->usaff_address_line2;
                $aff_array['usaff_postal_code'] = $affiliation->usaff_postal_code;
                $aff_array['usaff_state'] = $affiliation->usaff_state;
                $aff_array['usaff_email'] = $affiliation->usaff_email;
                array_push($affiliation_array, $aff_array);
            }
            $return_array['affiliation'] = $affiliation_array;


            //user classiffication
            $User_classification = (new User_classification())->getTable();
            $Classifications    = (new Classifications())->getTable();
            $journal_table = (new Journals())->getTable();
            $journal_settings_table = (new Journal_settings())->getTable();
            $cls_tbls = [
                "main_table" => $User_classification,
                "join_table" => [
                    $Classifications => ["usrcls_cls_id", "cls_id"],
                    $journal_table => [$Classifications . '.cls_jnl_id', $journal_table . '.jnl_id', "left"],
                    $journal_settings_table => [$journal_settings_table . '.jset_jnl_id', $journal_table . '.jnl_id', "left"]
                ]
            ];
            $cls_slct = "GROUP_CONCAT(usrcls_cls_id) as classification";
            $cls_cnd  = "usrcls_usr_id = $user_id  AND jset_classification='y'";
            if (isset($journal_id) && !empty($journal_id)) {
                $cls_cnd    .=  "AND cls_jnl_id = $journal_id";
            }
            $user_classification_details    =   User_classification::get_results_using_joins($cls_tbls,$cls_slct,$cls_cnd,'single');
            $return_array['user_classification']    =   [];
            if (isset($user_classification_details->classification)) {
                $return_array['user_classification'] =  json_decode(json_encode(explode(',', $user_classification_details->classification)));
            }

            // dates unavailability            
            if (isset($form_data['jnl_id'])) {
                $date_format =  $this->get_platform_date_format($journal_id);
            } else {
                $date_format = $this->current_client->settings->cs_date_format;
            }
            $date_format = date_format_map($date_format);
           // $user_dates_unavail_criteria = 'unavail_user_id = "' . $user_id . '"';
            $user_dates_unavail_criteria=array("unavail_user_id"=>$user_id);
            $dates_array = Users_unavailability::get_all_records_with_bind_cond('*,DATE_FORMAT(unavail_start_date,"' . $date_format . ' ") AS startdate,DATE_FORMAT(unavail_end_date,"' . $date_format . ' ") AS enddate', $user_dates_unavail_criteria);
            foreach (json_decode($dates_array) as $unavailable_info) {
                // reason exist or not and value not equal to empty or ''
                if (isset($unavailable_info->unavail_reason) && $unavailable_info->unavail_reason != '')
                     $unavail_date = $unavailable_info->startdate . ' - ' . $unavailable_info->enddate . '(' . $unavailable_info->unavail_reason . ')';
                else
                    $unavail_date = $unavailable_info->startdate . ' - ' . $unavailable_info->enddate;

                if (!in_array($unavail_date, $dates_unavailability_array, true)) {
                    array_push($dates_unavailability_array, $unavail_date);
                }
            }
            $return_array['dates_unavailable'] = $dates_unavailability_array;


            // overview
            $sql_jnl_part = '';
            $jnl_condition = '';
            if (isset($form_data['jnl_id'])) {
                $jnl_condition = ' AND artp_jnl_id =' . $journal_id;
            }
            $overview_criteria=array("art_submitted_by"=>$user_id);
            if (isset($form_data['jnl_id'])) {
                $articles_status = Articles::get_all_records_with_bind_cond('sum(if((`art_status`= "n"),1,0)) as live_submission , sum(if(`art_status`= "a",1,0)) as art_accepted , sum(if(`art_status`= "r",1,0)) as art_rejected', $overview_criteria);
                $journal_overview_array['live_submission'] =  $articles_status[0]->live_submission;
                $journal_overview_array['art_accepted'] =  $articles_status[0]->art_accepted;
                $journal_overview_array['art_rejected'] =  $articles_status[0]->art_rejected;
            } else {
                $article_table = (new \App\Models\Articles())->getTable();
                $article_type_table = (new \App\Models\Article_types())->getTable();
                $journal_table = (new \App\Models\Journals())->getTable();
                $tables = array(
                    'main_table' => $article_table,
                    'join_table' => array(
                        $article_type_table => array($article_type_table . '.artp_id', $article_table . '.art_artp_id', "join"),
                        $journal_table => array($journal_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "join")
                    )
                );
                $select_fields = 'sum(if((`art_status`= "n"),1,0)) as live_submission , sum(if(`art_status`= "a",1,0)) as art_accepted , sum(if(`art_status`= "r",1,0)) as art_rejected';
                $criteria_overview       =   "art_submitted_by = ?";
                $binding_arr = array($user_id);
                $articles_status =  Articles::get_results_using_joins($tables, $select_fields, $criteria_overview , 'all', NULL, NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
                $journal_overview_array['live_submission'] =  $articles_status[0]->live_submission;
                $journal_overview_array['art_accepted'] =  $articles_status[0]->art_accepted;
                $journal_overview_array['art_rejected'] =  $articles_status[0]->art_rejected;
            }
            // Submitted articles
            $article_submitted = 'SELECT IF(art_pre_all_ids IS NOT NULL,SUBSTRING_INDEX(art_pre_all_ids, \',\', 1),art_id) as base_art_id FROM rvw_articles, rvw_article_types WHERE art_submitted_by =' . $user_id . '  AND art_artp_id = artp_id AND art_status NOT IN (\'b\', \'n\') AND art_delete_status IN (\'n\',\'h\') ' . $jnl_condition . ' GROUP BY base_art_id,art_artp_id';
            $submit_articles = Articles::get_records_by_raw_query($article_submitted);
            $journal_overview_array['art_submited'] = count($submit_articles);

            //Co-authored articles
            $co_authors_query = "SELECT IF(art_pre_all_ids IS NOT NULL,SUBSTRING_INDEX(art_pre_all_ids, ',', 1),art_id) as base_art_id FROM rvw_article_authors,rvw_articles, rvw_article_types  WHERE auth_usr_id != art_submitted_by AND auth_art_id = art_id AND auth_usr_id = " . $user_id . " AND art_artp_id = artp_id AND art_status NOT IN ('b', 'n') AND art_delete_status IN ('n','h')   " . $jnl_condition . "   GROUP BY base_art_id,art_artp_id";
            $reviewed_co_author = Articles::get_records_by_raw_query($co_authors_query);
            $journal_overview_array['co_author_submit'] = count($reviewed_co_author);


            //Completed reviews
            $condition_review = 'jwf_stage_type =\'review\'  AND art_delete_status = \'n\' and aflw_usr_id=' . $user_id . $sql_jnl_part;
            $completed_review_condition = $condition_review . ' and aflw_status=\'c\' and art_status not in (\'n\',\'t\')';
            $reviewed_art = Article_flow::get_stage_details($completed_review_condition, 'count(DISTINCT `aflw_returned_date`) as reviewed_art_count', NULL, NULL, NULL, NULL, TRUE);
            $journal_overview_array['reviewed_art'] = $reviewed_art->reviewed_art_count;

            //Reviewer unassigned from articles
            $reviewer_unassigned_condition = $condition_review . ' and aflw_status=\'g\' and art_status not in (\'n\',\'t\')';
            $review_unassign = Article_flow::get_stage_details($reviewer_unassigned_condition, 'count(DISTINCT(`aflw_art_id`)) as review_unassign_count', NULL, NULL, NULL, NULL, TRUE);
            $journal_overview_array['review_unassign'] = $review_unassign->review_unassign_count;

            //Inprogress reviews
            $inprogress_reviews_condition = $condition_review . ' and aflw_status=\'a\' and art_status =\'y\'';
            $review_inprogress = Article_flow::get_stage_details($inprogress_reviews_condition, 'count(DISTINCT(`aflw_art_id`)) as review_in_progress', NULL, NULL, NULL, NULL, TRUE);
            $journal_overview_array['review_inprogress'] = $review_inprogress->review_in_progress;

            //Reviews in one year
            $sql_condition = 'jwf_stage_type = \'review\' and aflw_status = \'c\' and art_delete_status = \'n\' and aflw_usr_id =' . $user_id . ' and aflw_returned_date IS NOT NULL  and  aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) ';
            if (isset($form_data['jnl_id']))
                $sql_condition .= ' and jnl_id=' . $journal_id;
            $review_in_year = Article_flow::get_stage_details($sql_condition, 'count(`aflw_returned_date`) as review_in_one_year', NULL, NULL, NULL, NULL, TRUE);
            $journal_overview_array['review_in_year'] = $review_in_year->review_in_one_year;

            //Reviewer rating
            $rating_criteria = 'rvr_reviewer_id =' . $user_id;
            $review_rating = Review_rating::get_single_record('ROUND(AVG(rvr_rating), 2) as reviewer_rating', $rating_criteria);
            $journal_overview_array['review_rating'] = $review_rating->reviewer_rating;

            //Reviews in one month
            $sql_condition = str_replace('12 MONTH', '1 MONTH', $sql_condition);
            $review_in_one_month = Article_flow::get_stage_details($sql_condition, 'count(DISTINCT(`aflw_returned_date`)) as review_in_one_month', NULL, NULL, NULL, NULL, TRUE);
            $journal_overview_array['review_in_one_month'] = $review_in_one_month->review_in_one_month;
            // $journal_overview_array['review_rating'] = $review_rating->reviewer_rating;

            //Legacy article

            $legacy_auth_cnt = 0;

            if ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y') {
                $legacy_condition = "arld_submitted_by =" . $user_id . " AND arld_art_previous_id =  NULL";
                if (isset($form_data['jnl_id']))
                    $legacy_condition .= ' AND arld_jnl_id = ' . $journal_id;
                $legacy_auth_cnt = Article_legacydata::get_single_record('count(arld_id) legacy_count', $legacy_condition, NULL . '');
                $all_legacy_submission = $legacy_auth_cnt;
                $journal_overview_array['legacy_art'] = $all_legacy_submission->legacy_count;
            }else{
            $journal_overview_array['legacy_art'] = $legacy_auth_cnt;
            }

            //Open invitation

            $article_table = (new \App\Models\Articles())->getTable();
            $article_table = (new \App\Models\Articles())->getTable();
            $article_type_table = (new \App\Models\Article_types())->getTable();
            $journal_table = (new \App\Models\Journals())->getTable();
            $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $tables = array(
                'main_table' => $article_table,
                'join_table' => array(
                    $article_type_table => array($article_type_table . '.artp_id', $article_table . '.art_artp_id', "join"),
                    $journal_table => array($journal_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "join")
                )
            );
            $where_condition = 'jwf_stage_type =\'review\' and aflw_usr_id=' . $user_id . ' and aflw_status=\'i\' and art_status != \'c\' and art_delete_status = \'n\'';
            if (isset($form_data['jnl_id']))
                $where_condition .= ' and jnl_id=' . $journal_id;
            $open_invitation = Article_flow::check_usr_status('count(*) as count', $where_condition);
            $journal_overview_array['open_invitation'] = $open_invitation->count;

            //Last invitation date
            // $sql_query = 'SELECT DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") as aflw_assigned_date FROM `rvw_article_flow`,rvw_articles,rvw_article_types WHERE aflw_parent_flow_id IS NOT NULL and aflw_art_id = art_id AND artp_id = art_artp_id AND  aflw_usr_id=' . $user_id;
            $sql_query = 'SELECT DATE_FORMAT(aflw_posted_date,"' . $date_format . ' %H:%i") as invited_date,aflw_status FROM `tbk_article_flow`,rvw_articles,rvw_article_types WHERE aflw_parent_flow_id IS NOT NULL  and aflw_art_id = art_id AND artp_id = art_artp_id AND  aflw_usr_id=' . $user_id;
            if (isset($form_data['jnl_id']))
                $sql_query .= ' and artp_jnl_id=' . $journal_id;

            $sql_query .= ' ORDER BY tbk_id DESC LIMIT 1';
            $journal_overview_array['last_invitation'] = '';
            $last_invite = Article_flow::get_records_by_raw_query($sql_query);

            if (count($last_invite) > 0)
            {
                if($last_invite[0]->aflw_status == 'i')
                $journal_overview_array['last_invitation'] = $last_invite[0]->invited_date;
            }

            $link_art_submited  =   '';
            if(count($journal_overview_array) > 0) {
                if(($journal_overview_array["live_submission"] == NULL || $journal_overview_array["live_submission"] == 0) && 
                    ($journal_overview_array["art_accepted"] == NULL || $journal_overview_array["art_accepted"] == 0) && 
                    ($journal_overview_array["art_rejected"] == NULL || $journal_overview_array["art_rejected"] == 0)&& 
                    $journal_overview_array["art_submited"] == 0 && 
                    $journal_overview_array["co_author_submit"] == 0 && 
                    $journal_overview_array["reviewed_art"] == 0 && 
                    $journal_overview_array["review_unassign"] == 0 && 
                    $journal_overview_array["review_inprogress"] == 0 && 
                    $journal_overview_array["review_in_year"] == 0 && 
                    $journal_overview_array["review_rating"] == NULL && 
                    $journal_overview_array["review_in_one_month"] == 0 && 
                    $journal_overview_array["legacy_art"] == 0 && 
                    $journal_overview_array["open_invitation"] == 0 && 
                    $journal_overview_array["last_invitation"] == "") {
                        $journal_overview_array['tab_show_flg'] = false; 
                    } else {
                        $journal_overview_array['tab_show_flg'] = true; 
                        if($journal_overview_array["art_submited"] > 0 && $journal_id) {
                            $get_jnl_code_sql = 'SELECT `jnl_journal_code`, `jw`.`jwf_stage_name` 
                                            FROM `rvw_journals` `j` 
                                            LEFT JOIN `rvw_journal_workflows` `jw` ON (`jw`.`jwf_fwm_id` = `j`.`jnl_fwm_id`) 
                                            WHERE `jw`.`jwf_stage_type` = \'author_submission\' and `j`.`jnl_id` = '. $journal_id;
                            $get_jnl_code = Journals::get_records_by_raw_query($get_jnl_code_sql);
                            if(!empty($get_jnl_code)){
                                $lblARt     =   'articles';
                                if($this->current_client->modules->mdl_conference == 'y') {
                                    $lblARt     =   'abstracts';
                                }
                                // $link_art_submited = $this->current_client->platform_type . '/' . $get_jnl_code[0]->jnl_journal_code . '/view-more/' . encrypt_link('overview') .'/'. encrypt_link("Author submitted articles") .'/'. encrypt_link('author_submission') .'/'. encrypt_link($user_id);
                                $link_art_submited = $this->current_client->platform_type . '/' . $get_jnl_code[0]->jnl_journal_code . '/view-more/' . encrypt_link('overview') .'/'. encrypt_link("Author submitted ".$lblARt."") .'/'. encrypt_link('author_submitted_articles') .'/'. encrypt_link($user_id);

                            }
                        }
                    }
            }
            $journal_overview_array['link_art_submited'] =   $link_art_submited;
            $journal_overview_array['fivestar_review_rating'] =   $this->current_client->functionality->cfty_fivestar_review_rating;
            $return_array['journal_overview'] = $journal_overview_array;

            //User basic details
            $titles = $this->UserConfigdata('titles')['titles'];
            $criteria = 'usr_id=' . $user_id;
            $get_users = User::get_single_record(' * ,DATE_FORMAT(usr_reg_date,"' . $date_format . ' ") AS acc_reg_date', $criteria);
            if ($get_users != NULL) {

                $user_name =  (isset($titles[$get_users->usr_title])) ? $titles[$get_users->usr_title] . ' ' : '';

                if ($this->current_client->functionality->cfty_avoid_salutation == 'y') {
                    $user_name = '';
                }

                $user_name .= $get_users->usr_first_name;
                if (!empty($get_users->usr_middle_name))
                    $user_name .= ' ' . $get_users->usr_middle_name;
                $user_name .= ' ' . $get_users->usr_last_name;
            }
            if(empty($get_users)){
                return  $this->warning('Failed', 200, 'no_data_found');
            }
            $file_path = Config::get('general_config.file_retrieval');
            $current_user_condition = "usr_id = {$current_user['user_id']}";
            $current_user_data = User::get_single_record('*',$current_user_condition );
            
            if (isset($current_user_data) && !empty($current_user_data))
			{
                $user_role = json_decode($current_user_data->usr_roles); 
				if (!empty($user_role) && (in_array('super_admin',$user_role) ||  in_array('sudo',$user_role)))
				{
                        $show_date = TRUE; 
                    }
                    else
				{ 	
                    if (!empty($journal_id))
					{
                        $journal_condition = "jnl_id = {$journal_id}";
                        $jnl_data = Journals::get_single_record('jnl_journal_code',$journal_condition );            
                       if(!empty($jnl_data)){
                        $usr_roles = $this->validate_user_journal($jnl_data->jnl_journal_code, $current_user['user_id']);
                           
                        if (in_array('staff',$usr_roles['assigned_roles']) || in_array('journal_admin',$usr_roles['assigned_roles']) )
                        {
                            $show_date = TRUE;
                        }
                        }
					}
				}
			}
			$return_array['show_date'] = $show_date;

            $get_users->usr_image=$this->get_profile_image($get_users,$user_id);
            $user_array['full_name'] = $user_name;
            $user_array['email'] = $get_users->usr_email;
            $orcid_status = $this->current_client->modules->mdl_orcid;
            $client_url = [];
            $client_url['orcid_status'] = $orcid_status;
            if($orcid_status == 'y'){
                $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
                $client_params  = Config::get($review_config);
                if ($client_params) {
                    $client_url['view_url'] = encrypt_link($client_params['orcid']['view_url']);
                    $client_url['link_url'] = encrypt_link($client_params['orcid']['link_url']);
                    $client_url['usr_id'] = ($get_users->usr_orcid_id != '') ? encrypt_link($get_users->usr_orcid_id) : NULL;
                }
            }
            $user_array['orcid'] = $get_users->usr_orcid_id;
            $user_array['orcid_details'] = $client_url;
            /** select account created date after user confirm user account registration */
            $sql_query = '';
            if(!empty($get_users) && $get_users->usr_registered ==='y'){
                $sql_query = 'SELECT DATE_FORMAT(usr_reg_date,"'.$date_format.'") AS acc_reg_date from tbk_users where usr_id=' . $user_id . ' AND usr_reg_date IS NOT NULL ORDER BY tbk_id ASC LIMIT 1';
            }else{
                $sql_query = 'SELECT DATE_FORMAT(usr_posted_date,"'.$date_format.'") AS acc_reg_date from tbk_users where usr_id=' . $user_id . ' AND usr_posted_date IS NOT NULL ORDER BY tbk_id ASC LIMIT 1';
            }
            $usersregdate = User::get_records_by_raw_query($sql_query);
            $get_register_date = null;
            if(!empty($usersregdate)){
                $get_register_date = $usersregdate[0]->acc_reg_date;
            }
            $user_array['account_created'] = $get_register_date;
            $user_array['usr_id'] = $this->encrypt_data($get_users->usr_id);
            $user_array['user_status'] = $get_users->usr_status;
            $user_array['user_img'] = $get_users->usr_image;
            $user_array['user_status'] = $get_users->usr_status;

            $usr_terms_condition = 'y';
            if (isset($this->current_client->functionality->cfty_show_terms_conditions) && $this->current_client->functionality->cfty_show_terms_conditions == 'y') {
                $usr_terms_condition = (isset($get_users->usr_terms_condition)) ? $get_users->usr_terms_condition : '';
            }
            $user_array['user_terms_condition'] = $usr_terms_condition;

            // enable proxy
            if (isset($form_data['jnl_id'])) {
                $enble_prxy_cond = '`usrj_usr_id` = ' . $user_id . ' AND `usrj_artp_id` Is NULL AND `usrj_jnl_id` =' . $journal_id;
                $user_jnl_roles = User_to_journals::get_single_record('count(usrj_id) as roles', $enble_prxy_cond);
                if ($user_jnl_roles->roles == 0)
                    $enable_proxy = FALSE;
            }
             /* Start -> TASK #8105 Retire roles able to proxy as a another user */
             if (isset($journal_id) && !empty($journal_id) && $enable_proxy) {
                 $enable_proxy = $this->check_user_proxy_access($current_user['user_id'],$journal_id,null);
                } 
             /* End -> TASK #8105 Retire roles able to proxy as a another user */
            $user_array['enable_proxy'] = $enable_proxy;

            $return_array['user_details'] = $user_array;

            //Last login date
            $login_criteria = 'ltk_posted_by = "' . $user_id . '" AND ltk_user_type ="normal" ORDER BY `ltk_id` DESC LIMIT 1';
            $last_login_date = Login_tracking::get_all_records('DATE_FORMAT(ltk_posted_date,"' . $date_format .  " %h:%i %p" . ' ") AS lastlogin', $login_criteria);
            $return_array['last_login'] = (count($last_login_date) > 0) ?  $last_login_date[0]->lastlogin : '';
            // if ($usr_leg == TRUE)
            // $user_id = $user_info['basic_data']->usr_id;
            // Merged user details
            $merged_data = '';
            $merge_user_criteria  = 'musr_master_usr_id = "' . $user_id . '"';
            $merged_array = Merged_users::get_all_records('CONCAT(musr_first_name, IF(musr_middle_name IS NULL or musr_middle_name ="", " ", CONCAT(" ",musr_middle_name," ")), musr_last_name , CONCAT(" (", musr_email, ")")) as merged_acc, DATE_FORMAT(musr_posted_date,"' . $date_format . ' %H:%i") as merge_date, musr_posted_by as merge_by', $merge_user_criteria);
            $merge_user_array = [];
            if (count($merged_array) > 0) {
                foreach (json_decode($merged_array) as $merged_user) {
                    $merge_data['merged_user'] = $merged_user->merged_acc;
                    $merge_data['merged_date'] = $merged_user->merge_date;
                    $mergebyusercriteria = 'usr_id=' . $merged_user->merge_by;
                    // $merged_data = 'This account was merged with "' . $merged_user_name . '" ["' . $mail_id . '"] on "' . $date . '" by "' . $user_merged . '"';
                    $merge_by_user = User::get_single_record('CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as name', $mergebyusercriteria);
                    if(!empty($merge_by_user)){
                    $merge_data['merged_by_user'] = $merge_by_user->name;
                    array_push($merge_user_array, $merge_data);
                }
            }
            }
            $return_array['merged_data'] = $merge_user_array;

            // Roles in journal
            // $user_info['user_jnl_roles'] = $this->User_to_journals->get_journal_user(array(
            // 'usrj_usr_id' => $user_id,
            // 'usrj_artp_id' => NULL
            // ));
            $user_journal_criteria = 'usrj_usr_id=' . $user_id;
            $user_journals = User_to_journals::get_all_records('*', $user_journal_criteria);
            if($user_journals && count($user_journals) > 0){
                foreach (json_decode($user_journals) as $journal_info) {
                    $journal_criteria = 'jnl_id =' . $journal_info->usrj_jnl_id;
                    $userrole_criteria = 'role_id =' . $journal_info->usrj_role_id;
                    $journaldata = Journals::get_single_record('jnl_journal_name', $journal_criteria, NULL, '');
                    $userroledata = Roles::get_single_record('role_name', $userrole_criteria, NULL, '');
                    if(!empty($journaldata) && !empty($userroledata)){
                    $journal_roles['journal_name'] = $journaldata->jnl_journal_name;
                    $journal_roles['role'] = $userroledata->role_name;
                    $journal_roles['role_retire'] = $journal_info->usrj_role_retired;
                    $role_exists = false;
                    foreach ($journal_roles_array as $element) {
                        if ($element["journal_name"] === $journal_roles["journal_name"] && $element["role"] === $journal_roles["role"]) {
                            $role_exists = true;
                        }
                    }
                    if (!$role_exists ) {
                        array_push($journal_roles_array, $journal_roles);
                    }
                    }
                }
            }

            $return_array['journal_roles'] = $journal_roles_array;
            $return_array['retire_role_status'] = $this->current_client->functionality->cfty_retire_role;

            // // proxy login button permmission 
            $journal_table = (new \App\Models\Journals())->getTable();
            $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
            if ((isset($form_data['jnl_id']) && $form_data['platform'] == 'journal') || (isset($form_data['jnl_id']) && $form_data['platform'] == 'conference')) {
                if ($form_data['art_id'] != '' && ($user_id != $current_user['user_id'])) {
                    $return_array['show_adhoc_template'] = TRUE;
                }
                $tables = array(
                    'main_table' => $journal_table,
                    'join_table' => array(
                        $journal_settings_table => array($journal_table . '.jnl_id', $journal_settings_table . '.jset_jnl_id')
                    )
                );
                $proxy_roles_condition = 'jnl_id ="' . $journal_id . '"';
                $allowed_jnl_proxy_roles = Journals::get_results_using_joins($tables, 'jnl_id,jnl_journal_name,jnl_fwm_id,jset_login_user_type,jset_proxy_login,jset_date_format', $proxy_roles_condition);
                if (count($allowed_jnl_proxy_roles) > 0 && $allowed_jnl_proxy_roles[0]->jset_proxy_login != NULL) {
                    $user_journal_roles = User_to_journals::get_user_jnl_roles($current_user['user_id'], $journal_id);

                    if ($user_journal_roles[0]->role_ids != NULL) {
                        $user_jnl_roles_arr = explode(';', $user_journal_roles[0]->role_ids);
                        if (array_intersect($user_jnl_roles_arr, json_decode($allowed_jnl_proxy_roles[0]->jset_proxy_login))) {
                            $return_array['proxy_permission'] = TRUE;
                        }
                    }
                }
            }


            // key words 
            $user_keywords_criteria = 'ukwd_usr_id =' . $user_id;
            $key_words = Userkeywords::get_all_records('ukwd_kwd_id', $user_keywords_criteria);
            // $inactive_keywords = []; /* TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
            foreach (json_decode($key_words) as $keyword_info) {
                /* TASK #9433 inactive keyword is displaying in journal user info keyword section.
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y') {
                    if(isset($journal_id)){
                        $get_inactive_keywords = Keyword_relationship::get_all_records_with_bind_cond('kwdrl_kwd_id', ['kwdrl_jnl_id'=>$journal_id,
                        'kwdrl_kwd_id' => $keyword_info->ukwd_kwd_id,
                        'kwdrl_inactive' => 'y'
                        ]);
                    }
                    if ($get_inactive_keywords->isNotEmpty()) {
                        // Add inactive keyword ID to the array
                        $inactive_keywords[] = $get_inactive_keywords->first()->kwdrl_kwd_id ?? null;
                    }
                }
                if (in_array($keyword_info->ukwd_kwd_id, $inactive_keywords, true)) {
                    continue;
                }
                end TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
                // $criteria = 'kwd_id =' . $keyword_info->ukwd_kwd_id. ' AND kwd_user_keyword = \'n\''; /*TASK #9419 Add new feature to add custom keyword in user profile section*/
                $criteria = 'kwd_id =' . $keyword_info->ukwd_kwd_id;/*TASK #9419 Add new feature to add custom keyword in user profile section*/
                $keyworddata = Keywords::get_single_record('kwd_name', $criteria, NULL, '');
                if (isset($keyworddata->kwd_name))
                    if (!in_array($keyworddata->kwd_name, $key_array, true)) {
                        array_push($key_array, $keyworddata->kwd_name);
                    }
            }
            $return_array['key_words'] = $key_array;

            // author history button 
            $show_author_history = FALSE;

            if ($return_array['journal_overview']['art_submited'] > 0 || $return_array['journal_overview']['co_author_submit'] > 0 ||  $return_array['journal_overview']['legacy_art'] > 0)
                $show_author_history = TRUE;
            elseif ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y') {
                $where_cnd = 'FIND_IN_SET(' . $user_id . ',arld_author_id) != 0';
                $res_co_author = Article_legacydata::get_single_record('count(arld_id) cnt', $where_cnd);
                if ($res_co_author->cnt > 0)
                    $show_author_history = TRUE;
            }
            $return_array['show_author_history'] = $show_author_history;

            // reviewer history button 
            $show_reviewer_details_button = FALSE;
            $live_sql = 'SELECT count(sorw_suggested_reviewer_id) as cnt FROM rvw_article_reviewers rev ' . 'JOIN rvw_article_flow afl ON afl.aflw_id = rev.sorw_aflw_id ' . 'JOIN rvw_journal_workflows jfl ON jfl.jwf_id = afl.aflw_jwf_id ' . 'WHERE sorw_suggested_reviewer_id=' . $user_id . '  AND jfl.jwf_stage_type = \'review\'';
            $live_review = Article_reviewers::get_records_by_raw_query($live_sql);
            if (isset($live_review[0]->cnt) && $live_review[0]->cnt > 0) {
                $show_reviewer_details_button = TRUE;
            } elseif ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y') {
                $leg_review_condition = 'arev_user_id =' . $user_id;
                $legacy_review = Article_reviewer_legacydata::get_single_record('count(arev_user_id) as cnt', $leg_review_condition);
                if ($legacy_review->cnt > 0) {
                    $show_reviewer_details_button = TRUE;
                }
            }
            $return_array['show_reviewer_history'] = $show_reviewer_details_button;

            //fetch the client's proceeding config array
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('user-info');
            $return_array['proceeding_arr'] = $proceedingArr;

            // DB::enableQueryLog();
            // $query = DB::getQueryLog();
            // $query = end($query);
            // print_r($query);
            // exit;
            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) {
            
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function user_terms_condition(Request $request)
    {
            try
            {
            $User=new \App\Models\User();
            $form_data= $request->all();
            $current_user = $this->get_current_user_details();
            $user_id = $form_data['user_id'];
			if (isset($user_id) && $user_id != '')
			{
                $data = array(
                    'usr_terms_condition' => 'y',
                );
                $condition ='usr_id='.decrypt_link($user_id);
				$return_array['msg']= 'Terms & Conditions agreed';
					$result = $User::update_record($data,$condition,$current_user);
                if ($result > 0)
                    return $this->success('success', 200, $return_array);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_user_reviewer_history(Request $request)
    {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $useridarray = array('input'=>trim(Rv_decrypt($form_data['user_id'])),'type'=>'number','required'=>TRUE, 'enc_data'=>FALSE );
            $useridvalidation= $this->Rv_validator($useridarray);
            if($form_data['jnl_id'] != ''){
                $jnlidarray = array( 'input'=>trim(Rv_decrypt($form_data['jnl_id'])),'type' => 'number','required' => FALSE, 'enc_data'=>FALSE );
                $jnlidvalidation= $this->Rv_validator($jnlidarray);
            }
            $reviewstatusarray = array('input'=>trim($form_data['review_status']),'required'=>FALSE, 'enc_data'=>FALSE );
            $reviewstatusarrayvalidation= $this->Rv_validator($reviewstatusarray);
            $startdatearray = array('input'=>trim($form_data['start_date']),'required'=>FALSE, 'enc_data'=>FALSE );
            $startdatearrayvalidation= $this->Rv_validator($startdatearray);
            $enddatearray = array('input'=>trim($form_data['end_date']),'required'=>FALSE, 'enc_data'=>FALSE );
            $enddatearrayvalidation= $this->Rv_validator($enddatearray);
            
            if($useridvalidation != TRUE || ($form_data['jnl_id'] != '' && $jnlidvalidation != TRUE) || $reviewstatusarrayvalidation != TRUE || $startdatearrayvalidation != TRUE || $enddatearrayvalidation != TRUE ){
                return $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'');
            }
            $user_id = Rv_decrypt($form_data['user_id']);
            $page = (isset($form_data['page'])) ? $form_data['page'] : 0;
            $load = (isset($form_data['load'])) ? $form_data['load'] : '';
            $jnl_id = (isset($form_data['jnl_id'])) ? Rv_decrypt($form_data['jnl_id']) : '';
            $status = (isset($form_data['review_status'])) ? $form_data['review_status'] : NULL;
            // $uri_segment = (isset($form_data['platform'])) ? $form_data['platform'] : '';
            $content = '';
            $user_name = '';
            $r_start_date = isset($form_data['start_date']) ? date("Y-m-d H:i:s", strtotime($form_data['start_date'])) : '';
            $r_end_date = isset($form_data['end_date']) ? date("Y-m-d  H:i:s", strtotime('+1 day', strtotime($form_data['end_date']))) : '';
            $limit = 10;
            $start = ($page - 1) * $limit;
            $legacy_enabled = ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y') ? TRUE : FALSE;
            $legacy_status  = array(
                'ac' => 'Completed',
                'dc' => 'Declined',
                'dn' => 'Declined - No time',
                'do' => 'Declined - Out of field',
                'ra' => 'Reassigned',
                'nr' => 'No response',
                'ad' => 'Auto Declined',
                'ag' => 'Agreed',
                'ua' => 'Unavailable',
                'cm' => 'Changes to manuscript format required'
            );
            $flow_status = array(
                'd' => 'Declined',
                'a' => 'Assigned',
                'i' => 'Invited',
                'g' => 'Unassigned',
                'c' => 'Completed',
                'u' => 'Shortlisted'
            );
            $reviews = array();
            $original_status = NULL;
            $original_status = $status != NULL ? review_status($status, $legacy_enabled) : NULL;
            $date_format =  $this->get_platform_date_format($jnl_id);
            // $jnl_date_format = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
            $array_date=platform_date_format();
            $jnl_date_format = $array_date[$date_format];
            $reviews = Article_reviewers::get_reviewers($user_id, $legacy_enabled, $r_start_date, $r_end_date, $original_status, $start, $limit);

            if (!empty($reviews) && count($reviews) > 0)
                foreach ($reviews as $key => $reviewData) {
                    if($this->is_custom_blinded('reviewer', $reviewData->article_id, blinded_user:$user_id)){
                        unset($reviews[$key]);
                        continue;
                    } 
                    $reviewData->start_date = ($reviewData->start_date != '') ? date($date_format, strtotime($reviewData->start_date)) : NULL;
                    if ($reviewData->status == 'c' || $reviewData->status == 'ac') {
                        $flow_id = $reviewData->flow_id;
                        $data_review = $reviewData->id;
                        $data_from = $reviewData->data_from;
                        $user_id = $form_data['user_id'];
                        $reviews[$key]->review_details = $this->user_reviewed_details($flow_id, $data_review, $data_from, $user_id);
                    }
                }
            $data['date_format'] = $jnl_date_format;
            $data['original_status'] = array_keys(review_status());
            $data['reviews'] = $reviews;
            $data['legacy_status'] = $legacy_status;
            $data['flow_status'] = $flow_status;
            $data['user_id'] = $user_id;
            $data['jnl_code'] = $jnl_id;

            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function user_reviewed_details($flow_id, $data_review, $data_from, $user_id)
    {
        if ($data_from == "new") {
            $select = 'jnl_journal_code,aflw_art_id,jwf_forms';
            $criteria = 'aflw_id = ' . $flow_id;
            $article = Articles::get_article_data_by_condition($select, $criteria);
            $article = $article[0];
            $content = '';
            $formatted_journal_code = '_' . $article->jnl_journal_code;
            $condition = 'gdata_artflw_id =' . $flow_id;
            $form_select = 'gdata_art_id,gdata_atfemt_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gncf_reviewer_view,gdata_gfg_id,gncf_form_type,aflw_usr_id,aflw_orcid_putcode';
            $main_table = 'rvw_article_gnf_form_data' . $formatted_journal_code;
            $article_flow_table = (new \App\Models\Article_flow())->getTable();
            $generic_form_table = (new \App\Models\Generic_forms())->getTable();
            $details_tables = array(
                'main_table' => $main_table,
                'join_table' => array(
                    $generic_form_table => array($generic_form_table . '.gncf_id', $main_table . '.gdata_atf_id'),
                    $article_flow_table => array($article_flow_table . '.aflw_id', $main_table . '.gdata_artflw_id')
                )
            );
            $formdata = Article_flow::get_results_using_joins($details_tables, $form_select, $condition, 'all', 'gdata_data_order asc');
            $forms =  array();
            foreach ($formdata as $key => $form) {
                if(isset($form->gdata_element_type) && !empty($form->gdata_element_type) && $form->gdata_element_type == 'file'){
                    $attach_id_array = "'".implode("','",json_decode($form->gdata_data))."'";
                    $Generic_form_files = new \App\Models\Generic_form_files;
                    $select_attachment_name = "GROUP_CONCAT(agf_name) AS attach_name";
                    $attach_condition = "agf_id IN ($attach_id_array)";
                    $get_attachments_name = $Generic_form_files::get_single_record($select_attachment_name,$attach_condition);
                    $form->gdata_display_data = $get_attachments_name->attach_name;
                }
                $forms[$form->gdata_atf_id][] = $form;
            }
            $rvwData =  array();
            foreach ($forms as $rvwhstry) {
                array_push($rvwData, $rvwhstry);
            }
            $content = $rvwData;
        } else if ($data_from == "legacy") {
            $legacy_criteria = 'arev_id =' . $data_review;
            $content  = Article_reviewer_legacydata::get_single_record('arev_reveiewer_recommentation,arev_comments_author,arev_comment_editor', $legacy_criteria);
        }
        return $content;
    }
    public function get_journal_users(Request $request)
    {
        try {
            $form_data= $request->all();
            $this->current_user = $this->get_current_user_details();
            $search_parameters=$form_data['paramsdet']??array();
            $user_name ='';
            $status ='';
            $admin_role='';
            $user_email='';
            $validsortorder=array('ASC','asc','desc','DESC');
            $validsortfield=array('userfullname','usr_id','usrj_usr_id','usr_username','rolename','usr_roles','usr_email','usr_status');
            if(!empty($search_parameters))
            {
                if(isset($search_parameters['user_roles']))
                {
                    $rolearray = array('input'=>$search_parameters['user_roles'],'type'=>'number', 'enc_data'=>TRUE );
                    $platformarray = array('input'=>$form_data['platform_id'],'type'=>'number', 'enc_data'=>FALSE );
                    $rolevalidation= $this->Rv_validator($rolearray);
                    $platformvalidation= $this->Rv_validator($platformarray);
                    if($rolevalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    } if($platformvalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    }
                }
                if(isset($search_parameters['user_name']))
                {
                    $usernamearray = array('input'=>$search_parameters['user_name'],'type'=>'string', 'enc_data'=>FALSE ); 
                    $usernamevalidation= $this->Rv_validator($usernamearray); 
                    if($usernamevalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    } 
                } 
                if(isset($search_parameters['user_status']))
                {
                    $userstatusarray = array('input'=>$search_parameters['user_status'],'type'=>'string', 'enc_data'=>FALSE ); 
                    $userstatusvalidation= $this->Rv_validator($userstatusarray); 
                    if($userstatusvalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    }   
                } 
                if(isset( $search_parameters['user_email']))
                {
                    $useremailarray = array('input'=>$search_parameters['user_email'],'type'=>'string', 'enc_data'=>FALSE );  
                    $useremailvalidation= $this->Rv_validator($useremailarray);   
                    if($useremailvalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    } 
                } 
                if(isset( $form_data['per_page']))
                {
                    $perpagearray = array('input'=>$form_data['per_page'],'type'=>'number', 'enc_data'=>FALSE );
                    $perpagevalidation= $this->Rv_validator($perpagearray);
                    if($perpagevalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    }
                } 
                if(isset( $form_data['sort_order']) && $form_data['sort_order']!='')
                {
                    if (!in_array($form_data['sort_order'], $validsortorder)){
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);  
                    }
                }
                if(isset( $form_data['sort_field']) && $form_data['sort_field']!='')
                {
                    if (!in_array($form_data['sort_field'], $validsortfield)){
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);  
                    }

                }
            if(isset($search_parameters['user_name']))
            $user_name = $search_parameters['user_name']??'';
            if(isset($search_parameters['user_status']))
                    $status = $search_parameters['user_status'];
            if(isset($search_parameters['user_roles']))
                    $user_role = $search_parameters['user_roles'];
            if(isset( $search_parameters['user_email']))
            $user_email =$search_parameters['user_email'];
                // if(isset($search_parameters['author_filter']))
                // {
                // 	$authr_filter = $search_parameters['author_filter'];
                // }

            }
            if(isset( $form_data['sort_order']) && $form_data['sort_order']!='')
                {
                    if (!in_array($form_data['sort_order'], $validsortorder)){
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);  
                    }
                }
                if(isset( $form_data['sort_field']) && $form_data['sort_field']!='')
                {
                    if (!in_array($form_data['sort_field'], $validsortfield)){
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);  
                    }

                }
                if(isset( $form_data['per_page']))
                {
                    $perpagearray = array('input'=>$form_data['per_page'],'type'=>'number', 'enc_data'=>FALSE );
                    $perpagevalidation= $this->Rv_validator($perpagearray);
                    if($perpagevalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    }
                }
                if(isset($form_data['platform_id']))
                {
                $platformarray = array('input'=>$form_data['platform_id'],'type'=>'number', 'enc_data'=>FALSE );
                $platformvalidation= $this->Rv_validator($platformarray); 
                if($platformvalidation==false)
                    {
                        $arraymsg['chatmesage'] = customTrans('users.invalid_data');
                        return $this->warning("Failed",201,$arraymsg);     
                    } 
                }
            $authr_filter = $search_parameters['author_filter'] ?? '';
            $sort_field = $form_data['sort_field'] ?? 'usr_id';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            $bind_arr = array();
            $criteria ="usrj_jnl_id= ? AND usrj_usr_id!= ? ";
            //$bind_arr[]=  $form_data['platform_id']; 
            $bind_arr[]=isset($form_data['platform_id']) ? $form_data['platform_id'] : '';
            $bind_arr[]=  $this->current_user['user_id']; 

            if ($user_name != NULL)
            {
                $criteria =  $criteria . ' AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER(?))';
                $bind_arr[]=  "%".$user_name."%"; 
            }
            if ($status != NULL)
            {
               $criteria .= ' AND  usr_status = ? ';
               $bind_arr[]=  $status; 
            }
           /* if(isset($user_role) && $user_role != ''){
                $criteria .= ' AND FIND_IN_SET(\'' . $user_role . '\' , (REPLACE(REPLACE(REPLACE(role_name,\'"\',""),"[",""),"]",""))) ';
            }*/
           if(isset($user_email) && $user_email != ''){
               $criteria .= ' AND usr_email  LIKE ? ';
               $bind_arr[]=  "%".$user_email."%"; 
            }
            $criteria .= 'AND usr_id NOT IN (
                SELECT uur_usr_id
                FROM rvw_user_unregister_request
            )';
            // task #3703 show notify button bug fix
            $select ='CONCAT(
                usr_first_name,
               " ",
                usr_last_name
                ) AS userfullname,usr_email AS user_email,usr_id,usrj_usr_id,usrj_role_retired,usrj_jnl_id,usr_username, GROUP_CONCAT(DISTINCT role_name) as rolename,GROUP_CONCAT(DISTINCT usr_roles SEPARATOR ",") usr_roles,usr_email,usr_terms_condition,usr_status,GROUP_CONCAT(DISTINCT usrj_role_id SEPARATOR ",") usrj_role_id,GROUP_CONCAT(DISTINCT role_name,"\t",usrj_role_retired) role_names, GROUP_CONCAT(DISTINCT role_assigned_role SEPARATOR ",") role_assigned_role, GROUP_CONCAT(DISTINCT usrj_role_id SEPARATOR ",") role_ids, GROUP_CONCAT(DISTINCT CONCAT(role_name,",",usrj_role_retired) SEPARATOR "," ) role_retire_status';
            $search_array=array();
            $search_flag=FALSE;
            if(isset($search_parameters['user_roles']) && (isset($user_role) && $user_role != ''))
            {
            $search_flag=TRUE;
            $search_array=array('usrj_role_id'=>decrypt_link($search_parameters['user_roles']),'usrj_jnl_id'=>$form_data['platform_id']);
            }

           $userslist=User_to_journals::get_journal_users($select, $criteria, $sort_field, $sort_order, $limit,$authr_filter,$search_flag,$search_array,$bind_arr,TRUE);
            foreach ($userslist as $user_list) {
                if($user_list->usr_id)
                {
                    $usr_admin_roles = '';
                    $displayArray = array(
                        'user_id' => $user_list->usr_id,
                        'jnl_code' =>$form_data['jnl_code'],
                        'flag'     => TRUE,
                        'availability' => TRUE,
                        'save_coauthor' => FALSE,
                        'remove_user' => FALSE,
                        'source' => FALSE,  
                        'salutation' => TRUE,
                        'flag_only' => FALSE,
                        'inactive_user' => FALSE,
                        'fullname_only' => FALSE,
                        'journal_id' => $form_data['platform_id'],
                    );
                    $user_list->userfullname = $this->get_user_display_name($displayArray ); 
                // $selectedroles_condition ="jnl_id={$form_data['platform_id']} AND usr_id=$user_list->usr_id ";
                $user_list->all_usr_roles =$user_list->usrj_role_id;
                // task #3703 show notify button bug fix
                $user_list->evu_id = null;
				$event_already_exists    =   Event_invited_users::get_single_record_with_bind_cond('evu_id', array('evu_jnl_id' =>$user_list->usrj_jnl_id, 'evu_user_id'=>$user_list->usr_id, 'evu_submit_status' => 'i'));
				if (isset($event_already_exists) && !empty($event_already_exists))
				{
					$user_list->evu_id = $event_already_exists->evu_id;
				}
                // $user_list->all_usr_roles = User_to_journals::get_all_roles($selectedroles_condition, TRUE);
                }
            }
            $data=[];
          $return_array['userlist']=$userslist;

          //fetch the client's proceeding config array
		   $proceedingArr  =   $this->fetch_client_proceeding_config_array('user-with-roles');
		   $return_array['proceeding_arr'] = $proceedingArr;
           
          return $this->success('success',200,$return_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed',500,$e);
        }
        
    }

    public function get_jrnl_user_info(Request $request)
    {
        try {
          $form_data= $request->all();
            $this->current_user = $this->get_current_user_details();
          $user_id=$this->decrypt_data($form_data['user_id']);
            $contact_condition = 'usr_id =' . $user_id;
          $return_array['contact_details'] = User::get_single_record('*',$contact_condition);
            $ccemail_condition = 'uml_user_id =' . $user_id;
          $return_array['cc_email_data'] =User_emails::get_all_records('uml_email,uml_cc_email,uml_status', $ccemail_condition);
          $selectedroles_condition ="jnl_id={$form_data['jnl_id']} AND usr_id=$user_id ";
          $return_array['selected_roles'] = User_to_journals::get_all_roles($selectedroles_condition );
        //   $inactiveflag= false; /* TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
          $jnl_code="";
          if(isset($form_data['jnl_code']))
          {
            $jnl_code =$form_data['jnl_code'];
            }
          $core_role ='';
          if(isset($form_data['core_role']))
          {
            $core_role =$form_data['core_role'];
            }
            /**
             * TASK #8446 article flags changes
             * changed due to choose only active flags for users flag list where flag status is 'y'
             * $flag_condition = 'flag_type = "u"';
             */
            $flag_condition = 'flag_type = "u" AND flag_status = "y"';

            $flags = Flags::get_all_records("flag_id,flag_name", $flag_condition);
            $this->user_flag = new \App\Models\User_flags;
            $return_array['flags'] = $flags;
            $return_array['usr_flag_data'] = $this->user_flag::get_user_flags($form_data['jnl_id'],$user_id);
            $this->user_global_flag = new \App\Models\User_global_flags;
            $return_array['user_global_flags']  = $this->user_global_flag::get_user_global_flags("ugf_user_id={$user_id}");
            $this->General_settings = new \App\Models\General_Settings();
            $return_array['allowed_file_types']= $this->General_settings->get_single_record('gnl_file_types');
            $sql ="SELECT usatmnt_id, usatmnt_user_id, usatmnt_file_name,usatmnt_description,usatmnt_document_size,usatmnt_posted_by FROM rvw_user_attachment_files JOIN rvw_users ON usr_id = usatmnt_posted_by WHERE  usatmnt_user_id='" .$user_id."'";
            $return_array['user_attachments'] = User_attachment_files::get_records_by_raw_query($sql);
            $jnl_sett_details = 'jset_jnl_id =' .$form_data['jnl_id'];
            $return_array['jnl_sett_details'] = Journal_settings::get_single_record('jset_add_user_note,jset_add_user_attachemnts,jset_user_flags,jset_change_user_status,jset_date_format,jset_edit_user_details',$jnl_sett_details);
            $return_array['user_roles'] = $this->validate_user_journal($jnl_code, $this->current_user['user_id']);
            $return_array['privileged_user'] = $this->has_journal_privilege($jnl_code,$this->current_user['user_id']);
            if (isset( $this->current_client->functionality->cfty_manage_user_keywords ) &&  $this->current_client->functionality->cfty_manage_user_keywords == 'y' && ($core_role == "journal_admin" || $core_role == "staff" ) )
			{
                /* TASK #9433 inactive keyword is displaying in journal user info keyword section.
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
                {
                $inactiveflag=true;
                }
                end TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
                
                // if ($this->current_client->functionality->cfty_keyword_hierarchy == 'j')
                //     $keyword_jounal_id = $form_data['jnl_id'];
                // else
                //     $keyword_jounal_id = NULL;
                $user_keywords = Userkeywords::get_user_keywords($user_id, TRUE, $this->current_client->functionality->cfty_keyword_hierarchy, $form_data['jnl_id'], []); /* TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
                $return_array['keywords'] = $user_keywords;
                $return_array[''] = TRUE;
            }
            //setting global note----Start
            $return_array['enable_global_note'] = FALSE;
            $defult_usr_roles   = $this->get_default_user_roles_to_global_notes();
             if (isset($this->current_client->functionality->cfty_enable_global_user_notes) && $this->current_client->functionality->cfty_enable_global_user_notes == 'y' && isset($defult_usr_roles) && in_array($core_role,$defult_usr_roles)) 
             {
                $return_array['enable_global_note'] = TRUE;
                $return_array['all_user_roles'] = Roles::get_all_records();
            }
            //setting global note-----End
            return $this->success('success',200,$return_array);
        } catch (\Exception $e) {
                return  $this->failure('Failed',500,$e);
        }

            
    }
    public function save_jrnl_user_details(Request $request)
    {
        try {
        $form_data = $request->all();
        $check_journal_user_status = '';     // TASK #7987, Retire and inactive issue fix
        $validator = Validator::make($request->all(), [
            'user_first_det'      => 'required',
            'user_last_det'      => 'required',
            'user_email'=>'required'
        ]);
        $result =FALSE;
        $this->current_user = $this->get_current_user_details();
        if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());
        }

            if($form_data !=FALSE)
            {

            $user_id=$this->decrypt_data($form_data['user_id']);
            $input_arr = array(
                'input' =>  $user_id,
                'type'=> 'number'
            );
            $edited_id_validate = $this->Rv_validator($input_arr);
            if($edited_id_validate != TRUE ){
                return $this->warning('Failed',422,'Edit User Invalid');	
            }
            $condition = 'usr_id =' . $user_id;
            $get_user_data = User::get_single_record('*',$condition);	
            $usr_roles = isset($form_data['admin_role']) ? $form_data['admin_role'] : NULL;
            $array=array();
            $array['email']=$form_data['user_email'];
            $array['emaidata']=$get_user_data->usr_email;
            $arr =(object) $array;
            // TASK #7987, Retire and inactive issue changes applied as per the discussion start
            $jnl_id = $form_data['hdn_jnl_id'];
            $updated_user_roles_in_journal = implode(',', $form_data['journal_user_role']);
            $check_journal_user_status = $this->check_roles_of_user_in_journal_change_details($user_id,$jnl_id,$updated_user_roles_in_journal);
            // TASK #7987, Retire and inactive issue changes applied as per the discussion end            
            if(isset($form_data['user_email']))
            {
                $user_exist_email= $this->check_email($form_data['user_email'],$user_id,'',$arr);
                if(isset( $user_exist_email)&& ($user_exist_email==true))
                {
                    return  $this->warning('Failed', 200,'Email Already Exist');
                }
            }
            if(!empty($get_user_data))
			{
                $data = array(
                    'usr_title' => $form_data['titles'],
                    'usr_first_name' => $form_data['user_first_det'],
                    'usr_middle_name' => $form_data['user_middle_det'],
                    'usr_last_name' => $form_data['user_last_det'],
                    'usr_email' => $form_data['user_email'],
                    'usr_website' => $form_data['user_website_det'],
                    'usr_phone_no' => $form_data['user_phone_det'],
                    // 'usr_roles' => $usr_roles
                );
            $record = User::update_record($data,$condition,$this->current_user);
            if($record > 0)
                    $result = TRUE;
            }
           if ($result == TRUE)
			{
                $form_value['journal_user_name']= $user_id;
                if(is_array(($form_data['journal_user_role'])))
                {
                    $new_roles= $form_data['journal_user_role']; 
                }
                else
                {
                    $new_roles = explode(",", $form_data['journal_user_role']);
                }
                $form_value['journal_user_role'] = (isset($new_roles)?$new_roles:'');
                $form_value['hdn_jnl_id'] =$form_data['hdn_jnl_id'];
                $form_value['hdn_user'] = $user_id;
                DB::beginTransaction();
                $user_journal = $this->manage_users_journal($form_value);
                DB::commit();
                if (isset($user_journal))
                {
                    $return_array['removal_failed_roles'] = $user_journal['removal_failed_roles'];
                    $return_array['user_update'] = $user_id;
                    if(count($user_journal['removal_failed_roles']) > 0)
                    {
                        return $this->warning('warning', 200, $user_journal);
                        exit;
                    }
                }
               
            }
            $cc_mail_data = User_emails::get_all_records('uml_email,uml_id', "uml_user_id={$user_id}");
            $cc_mail_data_array = array();
            if (isset($form_data['autodata'])&&isset($form_data['autodata'][0])&&$form_data['autodata'][0]['uml_email'])
			{   
                $ccmailflag= 'savejrnluserdetails';

                for ($i = 0; $i < count($form_data['autodata']); $i++) {
                    if(empty($form_data['autodata'][$i]['uml_email']))
                    {
                        return $this->warning('Please fill all the alternative fields', 200, '', 'warning');
                    }
                    $input_alt_emails[] = $form_data['autodata'][$i]['uml_email'];
                    $valid_email = array();
                    if (!preg_match(
                        "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$^", "{$form_data['autodata'][$i]['uml_email']}")) {
                        $valid_email[] = "Invalid";
                    } else {
                        $valid_email[] = "Valid";
                    }
                }
              $new_alter_email_found=$this->save_cc_email_confirmation($ccmailflag,$user_id, $input_alt_emails);
                $cc_mail_data = User_emails::get_all_records('uml_email', "uml_user_id={$user_id}");
                $cc_mail_data_array = array();
                foreach ($cc_mail_data as $key => $mail) {
                    $cc_mail_data_array[] = $mail->uml_email;
                    if (!in_array($mail->uml_email, $input_alt_emails) && $mail != '') {
                        $condition ="uml_email='{$mail->uml_email}' AND uml_user_id=$user_id ";
                        User_emails::delete_records($condition, '', $this->current_user);
                    }
                }


                $check_email_validation = 'FALSE';
                if (in_array("Invalid", $valid_email)) {$check_email_validation = true;} else { $check_email_validation = false;}
                $activation_links = array();
                if ($check_email_validation == false) {
                    for ($i = 0; $i < count($form_data['autodata']); $i++) {
                        $mail = $form_data['autodata'][$i]['uml_email'];
                        if (!in_array($mail, $cc_mail_data_array) && $mail != '') {

                            $cc_data['uml_user_id'] = $user_id;
                            $cc_data['uml_email'] = $form_data['autodata'][$i]['uml_email'];
                            $cc_data['uml_posted_by'] = $this->current_user['user_id'];
                            User_emails::insert_record($cc_data, $this->current_user);
                        }
                    }

                } else {

                    return $this->warning('Invalid email address', 200, '', 'warning');
                    exit;
                }

				if(isset($new_alter_email_found)&&!empty($new_alter_email_found)){
                    $ccuser_data=array("usr_id"=>$user_id,'activation_link'=>'');
                    $ccmailuser_data = (object) $ccuser_data;
                    $this->send_cc_email_confirmation($new_alter_email_found,$ccmailuser_data,$mail_flag='savejrnluserdetails');
                }

              
            }
            else{
                //TASK #2203 Alternative email remove issue in manage user
                  $input_alt_emails[] =array();
                  if(isset($cc_mail_data) && $cc_mail_data->isNotEmpty())
                  {
                  
                    for ($i = 0; $i < count($form_data['autodata']); $i++) {
                        $input_alt_emails[] = $form_data['autodata'][$i]['uml_email'];
                    }
                    foreach ($cc_mail_data as $key => $mail) {
                       
                        $cc_mail_data_array[] = $mail->uml_email;
                        if (!in_array($mail->uml_email, $input_alt_emails) && $mail != '') {
                            User_emails::delete_records("uml_email='{$mail->uml_email}' AND uml_user_id={$user_id} AND uml_id={$mail->uml_id}", '', $this->current_user);
                        }
                        
                    }
                    
                  }
                 //TASK #2203
            }
            $return_array['info_msg'] =(($check_journal_user_status!='') ? $check_journal_user_status :'');    // TASK #7987, Retire and inactive issue fix
            $return_array['msg'] = customTrans('manageusers.user-details-updated');
            return $this->success('success', 200, $return_array);
    }
    else{
            return $this->warning('warning', 200, "error", 'warning');
        }

        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function get_global_note_count($note_id,$user_id, $posted_user_id,$is_global)
    {
        try {
            //limit for the global notes
            $con="usnote_id!='{$note_id}'";
            if($note_id==NUll)
            {
            $con="usnote_id IS NOT NULL";
            }
            $global_note_limit = 3;
            $data ="{$con} and usnote_user_id={$user_id} and usnote_posted_by ={$posted_user_id} and usnote_global ='y'";
            $global_note_cnt = User_note::get_single_record('count(usnote_id) as cnt',$data);

            if($is_global == 'y' )
            {
                if($global_note_cnt->cnt >= $global_note_limit)
                {
                    return FALSE;
                }
            }
            return TRUE;
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function save_jrnl_user_note(Request $request)
    {
        try {
        $form_data = $request->all();

        $this->current_user = $this->get_current_user_details();
        $user_data = $this->current_user;
        $hdn_user_id=$this->decrypt_data($form_data['hdn_user_id']);

		if ($form_data)
		{

                        $is_global = (isset($form_data['note_global'])) ? trim($form_data['note_global']) : 'n' ;
                        $permitted_roles = (isset($form_data['note_to']) && $is_global == 'y' ) ? json_encode(array_values($form_data['note_to'])) : NULL ;
                        $global_note_cnt = $this->get_global_note_count($form_data['hdn_note_id'], $hdn_user_id,$user_data['user_id'],$is_global);
                        if($global_note_cnt == TRUE)
                        {

                $data = array(
                    'usnote_user_id' =>  $hdn_user_id,
                    'usnote_title' => $form_data['note_title'],
                    'usnote_content' => trim($form_data['note_content']),
                    'usnote_global' => $is_global,
                    'usnote_to' => $permitted_roles,

                );
                            if (isset($form_data['hdn_note_id']) && $form_data['hdn_note_id'] != '')
                            {

                                    $note_id =$form_data['hdn_note_id'];
                                    $condition="usnote_id='{$note_id}'";
                                    $update_record =User_note::update_record($data,$condition, $user_data);
                    if ($update_record > 0)
                        $status = customTrans('manageusers.user-note-updated');
                            }
                            else
                            {
                    $note_id = User_note::insert_record($data, $user_data);
                    if ($note_id > 0)
                        $status = customTrans('manageusers.user-note-saved');
                }

                            if ($status != '')
                            {

                    $response = array(

                        'msg'      => $status,
                    );

                    return $this->success('success', 200, $response);
                    


                            }
                            else
                            {
                    return $this->warning('warning', 200, "error", 'warning');
                }
                        }
                        else
                        {

                $response = array(

                    'msg'      => customTrans('manageusers.max-no-globalnotes'),
                );
                return $this->warning($response, 200, "error", 'warning');
                // echo json_encode(array(
                //     'status' => 'error',
                //     'msg'    => lang('limit_global_user_note')));
            }
        }
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function get_jrnl_user_note(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $user_data = $this->current_user;
        $hdn_user_id=$this->decrypt_data($form_data['hdn_user_id']);
        $condition ="usnote_user_id={$hdn_user_id} and usnote_posted_by ={$user_data['user_id']}";
        $jset_date_format = "%d-%m-%y";
        $criteria = ['jset_jnl_id' => $form_data['jnl_id']];
        $jset = Journal_settings::get_single_record_with_bind_cond('jset_date_format', $criteria);
        if(isset($jset->jset_date_format)){
            $jset_date_format = '%' . $jset->jset_date_format;
            $jset_date_format = str_replace('-', '-%', $jset_date_format);
        }
        $select = '*,DATE_FORMAT(usnote_posted_date, "' . $jset_date_format . ' %h:%i:%s %p") as usnote_posted_date';
        $user_note_values = User_note::get_all_records($select,$condition);

            $displayArray = array(
                'user_id' => $user_data['user_id'],
                'jnl_code' => $form_data['jnl_code'],
                'journal_id' => $form_data['jnl_id'],
            );
            $posted_by = $this->get_user_display_name($displayArray);

            $posted_date =  $this->get_platform_date_format($form_data['jnl_id']);

                                     $return_array= array(

                                       'data'=>$user_note_values,'userfullname'=>$posted_by,'posteddate'=>$posted_date

            );
                                    return $this->success('success', 200,$return_array);
                    
                                 

                          
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }

    public function delete_jnl_user_note(Request $request)
    {
        try {
            $form_data = $request->all();
            $note_id = $form_data['note_id'];
            $this->current_user = $this->get_current_user_details();
		if ($note_id)
		{

			$result = User_note::delete_records("usnote_id={$note_id}",'',$this->current_user);
			if ($result > 0)
			{
                $return_array['msg']=customTrans('manageusers.note-removed');
                return $this->success('success', 200,$return_array);
                }
            }
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }
    public function get_jnl_user_note_by_id(Request $request)
    {
        try {
            $form_data = $request->all();
            $note_id = $form_data['hdn_note_id'];
            $this->current_user = $this->get_current_user_details();
            $user_data = $this->current_user;
		if ($note_id)
		{
            $condition = 'usnote_posted_by ='.$user_data['user_id'].' AND usnote_id ='.$note_id .'';
            $return_array['usernote']= User_note::get_single_record('*',$condition);
                return $this->success('success', 200,$return_array);
			
            }
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }
    public function update_user_status(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $user_data = $this->current_user;
            $check_journal_user_status = '';    // TASK #7987, Retire and inactive issue fix
		if ($form_data!= FALSE)
		{
                $result = FALSE;
                $user_id = $this->decrypt_data($form_data['user_id']);
            $condition = 'usr_id ='.$user_id.'';
			$get_user_data = User::get_single_record('*',$condition);
            // TASK #7987, Retire and inactive issue changes applied as per the discussion start
            if(isset($form_data['jnl_id']) && $form_data['jnl_id'] != '' && ($get_user_data->usr_status == 'a' && $form_data['user_status'] != 'a')){
                $jnl_id = Rv_decrypt($form_data['jnl_id']);
                $check_journal_user_status = $this->check_roles_of_user_in_journal_change_details($user_id,$jnl_id);
            }
            // TASK #7987, Retire and inactive issue changes applied as per the discussion end
			if(!empty($get_user_data))
			{
				if($form_data['user_status'] == 'a')
				{
					if(!empty($get_user_data->usr_pwd) && !empty($get_user_data->usr_url))
					{
						$this->confirm_registered_user($get_user_data, $user_data,'url');
                            $result = TRUE;
					}
					else if((!empty ($get_user_data->usr_deeplink_token)) || empty($get_user_data->usr_pwd))
					{

                            $result = $this->create_user_email($get_user_data, $this->current_user);
                            $result = TRUE;
					}
					else
					{
                        $where_cnd = 'usr_id = '.$user_id.'';
                            $record = User::update_record(array(
							'usr_status' => 'a'),$where_cnd,$this->current_user);

						if($record > 0)
                                $result = TRUE;
                        }
				}
				else
				{
                    $where_cnd = 'usr_id = '.$user_id.'';
                        $record = User::update_record(array(
						'usr_status' => $form_data['user_status']), $where_cnd, $this->current_user);
					if($record > 0)
                            $result = TRUE;
                    }
                }
			if ($result == TRUE)
			{

                    $return_array['msg'] =customTrans('manageusers.user-status-updated');
                    $return_array['info_msg'] = ($check_journal_user_status != '') ? $check_journal_user_status : '';    // TASK #7987, Retire and inactive issue fix
                    return $this->success('success', 200,$return_array);
                }
		}
		else
		{
                return $this->warning('warning', 200, "error", 'warning');
            }
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }

    public function get_usr_keywords(Request $request)
    {
        try {
            $form_data = $request->all();
            $user_id = $this->decrypt_data($form_data['user_id']);
            $jnl_id = $form_data['jnl_id'];
            $select = 'kwd_id,kwd_name';
            $group_by = 'kwd_id';


            $hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;
		if ($hierarchy == "c")
		{ 
                // $jnl_id = NULL;
                $return_array['jnl_keywords'] = Userkeywords::get_user_keywords($user_id, TRUE, $hierarchy ,$jnl_id);
		}
		else
		{
                $select = 'DISTINCT(kwd_id),REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name,kwdrl_id,kwdrl_inactive';
                $group_by = 'kwd_id';
               $where = "kwdrl_jnl_id = " . $jnl_id; /* Provide a search feature for keyword in the user profile section*/
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $where .= " AND kwdrl_inactive ='n' ";

                $return_array['jnl_keywords'] = Keywords::get_keywords($where, $select, NULL, NULL, $group_by, $hierarchy);
                $enable_browse = FALSE;
            if(count($return_array['jnl_keywords'])>0)
            {
                    $enable_browse = TRUE;
               
                }
            $return_array['enable_browse']=$enable_browse;
                //$return_array['jnl_keywords'] = Userkeywords::get_user_keywords($user_id, TRUE, $hierarchy ,$jnl_id);
            }
        return $this->success('success', 200,$return_array);	
	
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }



    public function save_user_keywords(Request $request)
    {
        try {
            $form_data = $request->all();
            $jnl_id = NULL;
            $this->current_user = $this->get_current_user_details();
            $user_id = $this->decrypt_data($form_data['user_id']);
            $keywords_cnt_check =  TRUE;
            $condition = array();
            $Keywords = new \App\Models\Keywords;
            if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
                $condition = array('kwdrl_inactive' => 'n');
            $frm_keywords = isset($form_data['keywords']) && !empty($form_data['keywords']) ? $form_data['keywords'] : array();
            
            if (count($frm_keywords) > 0  || empty($frm_keywords))
            {
                    if ( $this->current_client->settings->cs_min_keyword > count($frm_keywords) ){
        
                        $return_arr['msg'] = customTrans('manageusers.min-keywords');
                            $keywords_cnt_check = FALSE;
                        return $this->warning('error', 200,$return_arr);
                    } elseif ( $this->current_client->settings->cs_max_keyword < count($frm_keywords)) {
                        $return_arr['msg'] =customTrans('manageusers.max-keywords');
                            $keywords_cnt_check = FALSE;
                        return $this->warning('error', 200,$return_arr);	
        
                        }  
                
            }
		else
		{
			$return_arr['msg'] =customTrans('manageusers.select-keywords');
                $keywords_cnt_check = FALSE;
            }
		if ($user_id  != '' && $keywords_cnt_check == TRUE)
		{

                $from_form = $frm_keywords;
            if( $this->current_client->functionality->cfty_keyword_hierarchy == "j")
				$jnl_id  =$form_data['jnl_id'];

                $user_keywords = Userkeywords::get_user_keywords($user_id, TRUE, $this->current_client->functionality->cfty_keyword_hierarchy, $jnl_id);
                $from_db = array();

			if (!empty($user_keywords))
			{
				foreach ($user_keywords as $uk)
				{
                        $from_db[] = $uk->ukwd_kwd_id;
                      
                    }
                }
                $to_insert = $to_delete = $data_list = array();
                $to_insert = $from_form;
			if (!empty($from_db))
			{
                    $to_insert = array_diff($from_form, $from_db);
                    $to_delete = array_diff($from_db, $from_form);
                }

			if (!empty($to_insert))
			{
				foreach ($to_insert as $in)
				{
                        $data_list[] = array(
                            'ukwd_kwd_id' => $in,
                            'ukwd_usr_id' => $user_id,
                            'ukwd_posted_date' => date('Y-m-d H:i:s'),
                            'ukwd_posted_by' => $this->current_user['user_id']
                        );
                    }
                    $result = Userkeywords::insert_batch($data_list);
                }

			$user = User::get_single_record('usr_orcid_token,usr_orcid_id',$this->current_user['user_id']);
                $token = $user->usr_orcid_token;
                $orcid = $user->usr_orcid_id;

                $insert_keywords = '';
                $del_keywords = '';

			if(!empty($to_insert))
			{
                    $to_insert_string = "'" . implode("','", $to_insert) . "'";

                    $sql = "SELECT kwd_name FROM rvw_keywords WHERE kwd_id IN({$to_insert_string}) ORDER BY kwd_id";

                    $insert_keyword_array = Keywords::get_records_by_raw_query($sql);
				foreach( $insert_keyword_array as $keywd_names)
				{

					$insert_keywords .= $keywd_names->kwd_name.', ';
					
                    }
                }
			if(!empty($to_delete))
			{
                    $to_delete_string = "'" . implode("','", $to_delete) . "'";
                    $sql = "SELECT kwd_name FROM rvw_keywords WHERE kwd_id IN({$to_delete_string}) ORDER BY kwd_id";
                    $delete_keyword_array = Keywords::get_records_by_raw_query($sql);

				foreach ( $delete_keyword_array as $kwd_name)
				{
					$del_keywords .=  $kwd_name->kwd_name. ', ';
                    }
                }

			if (!empty($to_delete))
			{
				foreach ($to_delete as $del)
				{
					if ($this->current_client->modules->mdl_orcid == 'y' && isset($keyword_put_code[$del]) && $keyword_put_code[$del] != NULL && $this->current_client->functionality->cfty_profile_update_to_orcid == 'y')
					{
                            $end_point = 'keywords/' . trim($keyword_put_code[$del]);
                            $this->orcid_lib->delete_from_orcid($end_point, $token, $orcid);
                        }
                    $where = 'ukwd_usr_id=' .$user_id . ' and ukwd_kwd_id=' . $del;
                        Userkeywords::delete_records($where, '', $this->current_user);
					
                    }
                }

                $return_arr['msg'] = customTrans('manageusers.keyword-update');
            return $this->success('success', 200,$return_arr);	
            }
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }
    public function save_jnl_user_flag(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $user_id = $this->decrypt_data($form_data['user_id']);

            $check_jnl_flg = User_flags::check_flag_exists($form_data['jnl_id'], $form_data['flag_id'], $user_id);

            $check_global_flg = User_flags::check_glb_flag_exists($form_data['flag_id'], $user_id);
		if (count($check_jnl_flg) > 0)
		{
            $return_arr['msg']=customTrans('manageusers.flag-exist');
            return $this->warning('warning', 200,$return_arr,'warning');

		}
        else if (count($check_global_flg) > 0)
		{
            $return_arr['msg']=customTrans('manageusers.global-flag-exist');
            return $this->warning('warning', 200,$return_arr,'warning');

		}
		else
		{

                $data = array(
                    'uf_usr_id' => $user_id,
                    'uf_jnl_id' => $form_data['jnl_id'],
				'uf_flag_id' => $form_data['flag_id']);
			$insert_id = User_flags::insert_record($data,$this->current_user);

			if ($insert_id > 0)
			{

                    $return_arr['msg'] = customTrans('manageusers.user-flag-updated');
            return $this->success('success', 200,$return_arr);	
			}
			else
			{
				return $this->warning('warning', 200,customTrans('manageusers.user-flag-notupdated'), 'warning');
                }
            }
        } catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }

    public function delete_jnl_user_flag(Request $request)
    {
        try{
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
         $flag_id =$form_data['flag_id'];
            $user_id = $this->decrypt_data($form_data['user_id']);
         $return_arr =array();
         if (isset($flag_id) && $flag_id != '')
         {
                //$where = 'uf_id=' .$flag_id;
                $where = 'uf_usr_id=' .$user_id . ' and uf_flag_id=' . $flag_id;
           
                $result = User_flags::delete_records($where, '', $this->current_user);
             if ($result > 0)
             {
                    $return_arr['msg'] = customTrans('manageusers.flag-removed');
                
                }
            }
         return $this->success('success', 200,$return_arr);	
        }catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
                 
        }
    }
    public function upload_user_attachments(Request $request)
    {
        try{
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
		if ($form_data)
		{
			$data['usatmnt_user_id'] =$this->decrypt_data($form_data['hdn_user_id']);
                $data['usatmnt_file_name'] = $form_data['filename'];
			$data['usatmnt_document_size'] =$this->file_size_convert_to_kb($form_data['filesize'])/ 1000;
			$id = User_attachment_files::insert_record($data,$this->current_user);
            $return_arr['msg'] =customTrans('manageusers.attachment-added');
            
		}
      	
        else
			{
                $return_arr['msg'] = customTrans('manageusers.attachment-notadded');
                return $this->warning('warning', 200, $return_arr, 'warning');
            }
            return $this->success('success', 200,$return_arr);
    }catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }

    public function save_user_uploads(Request $request)
    {
        try{
            $form_data = $request->all();
            $file_id = $form_data['file_id'];
            $file_caption = $form_data['file_cpt'];

		if ($file_caption != '' && $file_id != '')
		{


                $this->current_user = $this->get_current_user_details();

                $where = 'usatmnt_id=' . $file_id;
                $result = User_attachment_files::update_record(array(
                'usatmnt_description' => $form_data['file_cpt']), $where, $this->current_user);
                if ($result)
				$return_arr['msg']=customTrans('manageusers.des-updated');
            }
        return $this->success('success', 200,$return_arr);

    }catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }
    public function get_user_filesby_id(Request $request)
    {
    try{
            $form_data = $request->all();
            $file_id = $form_data['hdn_file_id'];
            $this->current_user = $this->get_current_user_details();
            // $user_data =$this->decrypt_data($form_data['user_id']);
            $user_data = $this->current_user;
		if ($file_id )
		{
                //$condition = 'usatmnt_posted_by ='.$user_data.' AND usatmnt_id  ='.$file_id .'';
           $condition = 'usatmnt_posted_by ='.$user_data['user_id'].' AND usatmnt_id ='.$file_id .'';
            $return_array['userattachment']= User_attachment_files::get_single_record('*',$condition);

                return $this->success('success', 200,$return_array);
			
            }
    }catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }
    public function delete_user_attachments(Request $request)
    {
    try{
            $form_data = $request->all();
            $attach_id = $form_data['attach_id'];
            $this->current_user = $this->get_current_user_details();
       if (isset($attach_id) && $attach_id != '')
       {
        $where = 'usatmnt_id ='.$attach_id.'';
                $result = User_attachment_files::delete_records($where, '', $this->current_user);
           if ($result > 0)
           {
            $return_array['msg']=customTrans('manageusers.attachment-removed');
            return $this->success('success', 200,$return_array);
                }
            }
    }catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }


    public function get_user_unavailable_dates(Request $request)
    {
    try{
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'current_user'      => 'required',
                'jnl_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $user_id = $this->decrypt_data($form_data['current_user']);
             $format = platform_date_format();
            // $date_format =$this->current_client->settings->cs_date_format;
            // var_dump($date_format);exit;
            // $date_format= date_format_map($date_format);
            $date_formats = $this->get_platform_date_format($form_data['jnl_id']);
            $date_format= date_format_map($date_formats);
            $criteria = 'unavail_user_id = "' . $user_id . '"';
            $result = Users_unavailability::get_all_records('*,DATE_FORMAT(unavail_start_date,"' . $date_format . ' ") AS startdate,DATE_FORMAT(unavail_end_date,"' . $date_format . ' ") AS enddate', $criteria, NULL, NULL, '', NULL, NULL, 'ASC');
            if (isset($format[$this->current_client->settings->cs_date_format]))
                $return_array['cs_format'] = $format[$this->current_client->settings->cs_date_format];
            $return_array['user_unavailability'] = $result;
            $return_array['jset_dateformat'] = $date_formats;
            return $this->success('success', 200, $return_array);

    }catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
             
        }
    }
    public function get_datesunavailable_byid(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $user_data = $this->current_user;
            $validator = Validator::make($request->all(), [
                'dates_unavail_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
           $condition = 'unavail_id ='.$form_data['dates_unavail_id'].'';
            $result = Users_unavailability::get_single_record('*', $condition);
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function alternate_as_cc_mail(Request $request) { //use confirmed alternate email as cc_mail
        try{
        $form_data = $request->all();
        $user_id = Rv_decrypt($form_data['user_id']);
        $this->current_user = $this->get_current_user_details();
        $status = $form_data ['status'];
        $cc_email =$form_data ['cc_email'];
        if (!empty($user_id) && !empty($cc_email)) {
            $up_cond = array(
                'uml_user_id' => $user_id,
                'uml_email' => $cc_email
            );
            User_emails::update_record(array(
                'uml_cc_email' => $status), $up_cond, $this->current_user);
            $return_array['msg'] = 'success';  
        }
        return $this->success('success', 200, $return_array);
         } catch (\Exception $e) {
                    return  $this->failure('Failed', 500, $e);
                }
    }
   //TASK #8727 Cannot retire roles should also be added on the popup message
    public function get_user_jnl_roles(Request $request)
    {
    try {
        $form_data = $request->all();
        $validator = Validator::make($form_data, [
            'jnl_id'  => 'required',
            'user_id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $protectedRoles = ['author', 'reviewer', 'journal_admin'];
        $criteria = "role_assigned_role IN ('" . implode("','", $protectedRoles) . "')";
        $non_privilage_roleids = (new Roles())->get_all_records('group_concat(role_id) as roleids', $criteria);

        $user_id = $this->decrypt_data($form_data['user_id']);
        $journal_id = $this->decrypt_data(($form_data['jnl_id']));
        $type = 'j';
        $initialCondition = "usrj_usr_id={$user_id} AND usrj_role_retired='n'";
        $initialCondition .= ($type === 'a') ? " AND usrj_artp_id={$journal_id}" : " AND usrj_jnl_id={$journal_id}";
        $allRolesList= (new User_to_journals())->get_all_roles($initialCondition, true, $type);
        $allRoles = $allRolesList->toArray();
        $allAssignedRoles = array_column($allRoles, 'role_assigned_role');
        $roleFullNames = array_column($allRoles, 'role_name');
        $assignedProtectedRoles = array_intersect($allAssignedRoles, $protectedRoles);
        $countProtectedRoles = count($assignedProtectedRoles);
        
        $onlyProtectedRolesAssigned = (count($allAssignedRoles) === $countProtectedRoles);
        if ($onlyProtectedRolesAssigned) {  
            $roleNamesFormatted = implode(",", $roleFullNames);
            
            $return_array['messageDisplay'] =customTrans('roles.cannot_retire_role');
            $return_array['roleNamesFormatted'] =$roleNamesFormatted;
        }
        $condition = $initialCondition;
        if ($non_privilage_roleids && isset($non_privilage_roleids[0]->roleids)) {
            $condition .= " AND usrj_role_id NOT IN (" . $non_privilage_roleids[0]->roleids . ")";
        }

        $filteredRolesCollection = (new User_to_journals())->get_all_roles($condition, TRUE, $type);
        $roles = $filteredRolesCollection->toArray();
        $return_array['roles'] = $roles;
        return $this->success('success', 200, $return_array);

    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e->getMessage());
    }
} 
//TASK #8727 Cannot retire roles should also be added on the popup message
    public function get_user_retire_jnl_roles(Request $request)
    {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id'      => 'required',
                'user_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
    $user_id = $this->decrypt_data($form_data ['user_id']);
            $journal_id = $form_data['jnl_id'];
            $type = 'j';
            $condition = "usrj_usr_id={$user_id} AND usrj_role_retired='y'";

            if ($type === 'a') {
                $condition .= " AND usrj_artp_id={$journal_id}";
            } else {
                $condition .= " AND usrj_jnl_id={$journal_id}";
            }

            $return_array['roles'] = User_to_journals::get_all_roles($condition, TRUE, $type);

            return $this->success('success', 200, $return_array);
    }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function save_user_retire_roles(Request $request)
    {
        try {
            $form_data = $request->all();
            $jnl_code = $form_data['jnl_code'];
            $jnl_id = $form_data['jnl_id'];
            $core_role ='';
            $retired_roles = '';
            $rest_roles_array = array();
            $validator = Validator::make($request->all(), [
                'jnl_code'      => 'required',
                'jnl_id'      => 'required',
                'user_id'      => 'required',
                'status'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            if(isset($form_data['core_role']))
            {
            $core_role = $form_data['core_role'];
            }
        $user_id = $this->decrypt_data($form_data ['user_id']);
            $this->current_user = $this->get_current_user_details();
            $status = $form_data['status'];
        $criteria ="usrj_usr_id='{$user_id}' AND usrj_jnl_id='{$jnl_id}'"; 
            // $data ="usrj_role_retired='{$status}'";
            $data = array(
                'usrj_role_retired' => $status
            );
            $restrict_role_ids = array();
            $rest_roles = '';
        if($status == 'y')
        {
            $get_user_details = User::get_single_record_with_bind_cond('usr_status AS user_current_status',array('usr_id'=>$user_id));
            foreach($form_data['retire_roles'] as $role_id)
            {
                    /*
                    TASK #7987 , Users should be restricted from retiring a role if all other accounts with the same role are in inactive or suspended status
                    Here add a condition to check the users status = 'a'
                    old code -> $cond ="usrj_role_id={$role_id} AND usrj_jnl_id={$jnl_id}  AND usrj_usr_id <>{$user_id} AND usrj_role_retired='n'";
                    also check the case of active user actions only not bother about inactive or suspended users 
                    */
                    $cond ="usrj_role_id={$role_id} AND usrj_jnl_id={$jnl_id}  AND usrj_usr_id <>{$user_id} AND usrj_role_retired='n' AND usr_status='a'";
                    $res = User_to_journals::get_users_based_role($cond);
                if($res < 1 && (isset($get_user_details->user_current_status) && !empty($get_user_details->user_current_status) && $get_user_details->user_current_status =='a')){

                   $pos = array_search($role_id,$form_data['retire_roles']);
                        $restrict_role_ids[] = $role_id;
                   $rest_roles.= Roles::get_role_name($role_id)->role_name.',';
                        unset($form_data['retire_roles'][$pos]);
                    }
                
            }
            $rest_roles = rtrim($rest_roles,", ");
                // TASK #7987 added warning msg to display start
                $rest_roles_array = explode(',', $rest_roles);
                $retired_roles = implode(', ', array_slice($rest_roles_array, 0, -1)) . (count($rest_roles_array) > 1 ? ' and ' : (count($rest_roles_array) == 1 ? '' : ',')) . end($rest_roles_array);
                // TASK #7987 added warning msg to display end
            }

        if(!empty($form_data['retire_roles']))
        {
           $result = User_to_journals::update_retire_user_roles($form_data['retire_roles'], $criteria,$data);
                // $result= User_to_journals::get_records_by_raw_query($retire_role_sql);
            if(!empty($result))
            {

                    $role_value = array();
                    $role_names='';
                $retired_roles_id=$form_data['retire_roles'];
                foreach($retired_roles_id as $role){

                    $role_value[]= Roles::get_role_name($role)->role_name;
                        //$role_names.= Roles::get_role_name($role)->role_name.',';

                    }
                  if(count($role_value)>2)
                  {
                    $role_names=implode(',',$role_value);
                    
                    }
                  else if(count($role_value)== 2)
                  {
                    $role_names=implode(' and ',$role_value);
                  }
                  else
                  {
                    $role_names=implode('',$role_value);
                  }
                if($status == 'y')
                {
                        $email_tmplte_name = 'retire_user_roles';
                        $user_roles = 'RETIRED_ROLES';
        
                }
                else
                {
                        $email_tmplte_name = 'rejoin_user_roles';
                        $user_roles = 'REJOIN_ROLES';
                    }
                  $custom_data=array( 
                        'user_roles'=>$user_roles,
                        'role_names'=>$role_names,
                    );
                        $email_data=array(
                        'type'=>'global',
                        'action'=>'send',
                        'email_with_login'=>FALSE,
                        'user_id'=>$user_id,
                        'empt_name'=>    $email_tmplte_name,
                    'custom_data'=>$custom_data,
                    'jnl_user_role'=>array(
                    'core_role'=>$core_role,
                            // 'role_name'=>$jnl_array['role_name'],
                        'jnl_id'=>$jnl_id,
                        'jnl_journal_code'=> $jnl_code
                    ),);

                    $this->master_email_details($email_data);
                $return_array['restricted_roles']=$rest_roles;
                $return_array['msg']=($rest_roles != '') ? customTrans('manageusers.role-active-user-status-warning-head') . "{$retired_roles}" . customTrans('manageusers.role-active-user-status-journal-warning-tail'):"status updated"; // TASK #7987 added warning msg to display
                $return_array['status']="success";
                $return_array['retirestatus']=$status;
                $return_array['role_names']=$role_names;

                    return $this->success('success', 200, $return_array);
              
            }
            else
            {
                $return_array['retirestatus']=$status;
                $return_array['restricted_roles']=$rest_roles;
                $return_array['role_names']=$role_names;
                $return_array['msg'] = ($rest_roles != '') ? customTrans('manageusers.role-active-user-status-warning-head') . "{$retired_roles}" . customTrans('manageusers.role-active-user-status-journal-warning-tail') : "status updated";  // TASK #7987 added warning msg to display
                $return_array['status']="failed";
                    return $this->success('success', 200, $return_array);
                }
        }
        else
        {
            $return_array['retirestatus']=$status;
            $return_array['restricted_roles']=$rest_roles;
            $return_array['msg']= ($rest_roles != '') ? customTrans('manageusers.role-active-user-status-warning-head') . "{$retired_roles}" . customTrans('manageusers.role-active-user-status-journal-warning-tail') : ""; // TASK #7987 added warning msg to display
            $return_array['status']="Warning";
                return  $this->warning('Warning', 200, $return_array);
            }
        
      
    }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    //Get the default roles(Journal admin & staff) if the usnote_global = 'y' and usnote_to = 'NULL' --- an expection case.
    public function get_default_user_roles_to_global_notes()
    {
         $role_ids='';
         $roles=array();
        $all_user_roles = Roles::get_all_records();
         foreach($all_user_roles as $each_roles)
         {
             if (($each_roles->role_assigned_role == 'journal_admin') || ($each_roles->role_assigned_role == 'staff'))
             {
                //$role_ids.= $each_roles->role_id.',';
                 $roles[]=$each_roles->role_assigned_role;
            }
        }
        //$role_ids = substr($role_ids, 0, -1);
        //$default_roles = json_encode(array_values(explode(',',$role_ids)));
        return $roles;
    }
    public function get_usr_confirmation_email_tmpl(Request $request)
    {
        try{
            $Email_templates = new \App\Models\Email_templates();
            $User=new \App\Models\User();
            $user_id=decrypt_link($request->user_id);
            $criteria="usr_id=$user_id";
            $recipient = $User::get_single_record('*',$criteria);
            $current_user = $this->get_current_user_details();
            $email_template = $Email_templates::get_single_record('*',"etmp_name='confirm_mail'");
            $email_hooks = $this->Utility('email_hooks');
            foreach ($email_hooks as $eh => $value) {
                if ($eh == 'email_hooks') {
                    $email_template->template_name = $value["confirm_mail"];
                    break;
                }
            }
            if ($email_template != NULL)
			{
                $email_data = new stdClass;
                preg_match_all('/##([^##]*)##/', $email_template->etmp_email_template, $matches);
                $keys = $matches[1];
                if(in_array('CONFIRMATION_URL', $keys) &&  $email_template->etmp_notification == 'User')
					{
                        $email_data->email_templates_config = $this->email_templates_config();
                        $email_data->join_config = $this->join_config();
                        $email_data->join_dependency_config = $this->join_dependency_config();
                        $email_data->user_role_tags = $this->user_role_tags();
                        $subject = $email_template->etmp_subject;
						$content =$email_template->etmp_email_template;
                        $user_titles = $this->UserConfigdata('titles')['titles'];
                        $email_data->user_id = $recipient->usr_id;
                        $email_data->resend_usr_confirmation = TRUE;
                        if($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email=$this->current_client->functionality->cfty_unique_hide_control_label_email;
                        $content = $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);
                        $confirmation_url=preg_match_all('/##([^##]*)##/', $content, $matches);
                        if($confirmation_url){
                           
                            for ($i = 0; $i < count($matches[1]); $i++) {
                                $element = $matches[1][$i];
                                if (!empty($element)) {
                                    $content = str_ireplace('<p>##' . $element . '##</p>', '<button contenteditable="false">' . $element . '</button>', $content);
                                }
                            }
                            $body = $content;
                        }
                        $subject = $this->generate_email_data_from_keys($email_data, $subject, $current_user, $user_titles, TRUE);
                        $reply_to= '';
                        $reply_to=Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['reply_to_email'];
                        /*
						if (isset($this->current_client->email_settings['reply_to_email']) && $this->current_client->email_settings['reply_to_email'] != '')
						{
							$reply_to = $this->current_client->email_settings['reply_to_email'];
						}
                        */
                        $cc_bcc_roles = array();
						$remove_roles=array("sudo"=>"Super User");
                        $display_role = array_diff_key($this->UserConfigdata("managing_roles")['managing_roles'], $remove_roles);
                        $usr_roles = array_values($display_role);
                        if (!empty($usr_roles)) {
							foreach ($usr_roles as $us) {
								$cc_bcc_roles[$us] = $us;
							}
						}
						$cc_bcc_roles['Custom'] = 'Specific email ID';
                        $return_arr = array(
                            'status' => 'success',
                            'cc_bcc_roles' => $cc_bcc_roles,
                            'to_cc' => json_decode($email_template->etmp_cc),
                            'to_bcc' => json_decode($email_template->etmp_bcc),
                            'cust_cc' => $email_template->etmp_cust_cc,
                            'cust_bcc' => $email_template->etmp_cust_bcc,
                            'reply_to' => $reply_to,
                            'subject' => $subject,
                            'content' => $body);
                           
                    }
                    else
					{
						$return_arr = array(
							'status' => 'warning',
							'msg' => 'Not defined email template properly'
						);
						if(!in_array('CONFIRMATION_URL', $keys))
							$return_arr['msg'] = '##CONFIRMATION_URL## tag missing in Confirmation Mail';
					}
            }
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function resend_confirmation_email(Request $request)
	{
        try{
            $form_data = $request->post();
            $current_user = $this->get_current_user_details();
            if(!empty($form_data))
            {
            $recipient_id = $form_data['user_ids'];
            $User=new \App\Models\User();
            $criteria='usr_id='.decrypt_link($recipient_id);
          
            $recipient_detail = $User::get_single_record('usr_id, usr_email, usr_deeplink_token, usr_pwd, usr_url, usr_status, usr_first_name, usr_last_name,usr_jnl_standalone', $criteria);
            if(!empty($recipient_detail))
			{
                if($recipient_detail->usr_status == 'w') {
                    $subject=$form_data['stage_template_sub'];
                    $body =  $form_data['stage_template_content'];
                    $registered_user = FALSE;
					if(!empty($recipient_detail->usr_pwd) && !empty($recipient_detail->usr_url)) {
                        //TASK #2702 old email in not expiring (SA add user) revert
						$user_deeplink_token = $recipient_detail->usr_url;
                        // end TASK #2702 old email in not expiring (SA add user) revert
						$registered_user = TRUE;
					}
                    else
					{    //TASK #2702 old email in not expiring (SA add user) revert
						if(empty($recipient_detail->usr_deeplink_token))
						{
							$usr_deeplink_token = random_string('alnum', 16);
                            // end TASK #2702 old email in not expiring (SA add user) revert
						}
						else
							$usr_deeplink_token = $recipient_detail->usr_deeplink_token;
					}
                    $body = preg_replace('/<p><button contenteditable="false">([^<]+)<\/button><\/p>/i', '<p>##$1##</p>', $body);
                    preg_match_all('/##([^##]*)##/', $body, $matches);
					$keys = $matches[1];
                    
                    if (in_array('CONFIRMATION_URL', $keys))
					{
                        $link = '';
                        // $standalone = $this->input->post('hdn_standalone_usr');
                        if ($this->current_client->modules->mdl_standalone_journals == 'y')
						{
							if ($recipient_detail->usr_jnl_standalone == NULL)
							{
								$link = URL::to('/') . '/';
							}
							else
							{
							
								$jrnl_grp = Journals::get_single_record('jnl_standalone_group',"jnl_id={$recipient_detail->usr_jnl_standalone}");
								
								$link = $this->build_url_standalone($jrnl_grp->jnl_standalone_group);
							}
						}
                        else
						{
                            
                            $link =URL::to('/') . '/';
							// $link = base_url();
						}
                        if($registered_user == FALSE)
						{
                            $link .= "awaiting-confirm-mail/" .encrypt_link("&key=" . $usr_deeplink_token . "&userid=" . $recipient_detail->usr_id);
                            /*
							if($this->current_client->functionality->cfty_show_terms_conditions=='y')
								{
									$link .= "terms-condition?" . encrypt_link("&key=" . $usr_deeplink_token . "&userid=" . $recipient_detail->usr_id);
								}else{
							$link .= "awaiting-confirm-mail/" .encrypt_link("&key=" . $usr_deeplink_token . "&userid=" . $recipient_detail->usr_id);
								}
                                */
						}
						else{
                           
                            $link .= "awaiting-confirm-mail/" .encrypt_link("&key=" . $user_deeplink_token . "&userid=" . $recipient_detail->usr_id."&usr_url=" . $user_deeplink_token);
						}
                        if (in_array('CONFIRMATION_URL', $keys))
						{
							if(!empty($link))
                            //TASK #3020 Change link to Button in mail(confirmation button)
                            $body = str_ireplace("##CONFIRMATION_URL##", '<a style="box-sizing: border-box;position: relative; -webkit-text-size-adjust: none; border-radius: 4px; color: #fff; display: inline-block; overflow: hidden; text-decoration: none; background-color: #007bff; border-bottom: 8px solid #007bff; border-left: 18px solid #007bff; border-right: 18px solid #007bff; border-top: 8px solid #007bff;" id="confirmation_url_tag" href="' . $link . '">Click here to confirm</a>', $body);
							else
								$body = str_ireplace("##CONFIRMATION_URL##", '', $body);
						}
                        $email_template = array(
							'etmp_name' => 'confirm_mail',
							'etmp_cust_to' => '',
							'etmp_bcc' => '',
							'etmp_cc' => '',
							'etmp_cust_cc' => '',
							'etmp_cust_bcc' => '',
							'etmp_subject' => $subject,
							'etmp_email_template' => $body,
							'etmp_notification' => 'User'
						);
                        $etmp_cust_cc_array=[];
                        $cc = isset( $form_data['stage_template_to_cc'])?$form_data['stage_template_to_cc']:null;
                        if(!empty($cc))
						{
                        $email_template['etmp_cc'] =json_encode($cc);
                        if(in_array('Custom', $cc)||in_array('Custom_cc', $cc))
                                {  
                                    $email_cust_cc =$form_data['stage_cust_cc'];
                                    foreach ($email_cust_cc as $key => $emailcustcc) 
                                    {
                                        array_push($etmp_cust_cc_array,$emailcustcc['value']);           
                                    }
                                    $commaSeparatedString = implode(',', $etmp_cust_cc_array);   
                                    $email_template['etmp_cust_cc'] = trim($commaSeparatedString);
                                }
                                else{
                                    $email_template['etmp_cust_cc']='';
                                }
                        }
                        $etmp_cust_bcc_array=[];
						$bcc =isset($form_data['stage_template_to_bcc'])?$form_data['stage_template_to_bcc']:null;
                       
                        if(!empty($bcc))
                        {
                                $email_template['etmp_bcc'] =json_encode($bcc);
                                if(in_array('Custom', $bcc)||in_array('Custom_cc', $bcc))
                                {  
                                    $email_cust_bcc =$form_data['stage_cust_bcc'];
                                    foreach ($email_cust_bcc as $key => $emailcustbcc) 
                                    {
                                        array_push($etmp_cust_bcc_array,$emailcustbcc['value']);
                                                 
                                    }
                                    $commaSeparatedString = implode(',', $etmp_cust_bcc_array); 
                                    $email_template['etmp_cust_bcc'] = trim($commaSeparatedString);
                                }
                                
                                else{
                                    $email_template['etmp_cust_cc']='';
                                }
						}

                        $email_data = new stdClass;
						$email_data->subject = $subject;
						$email_data->body = $body;
						$email_data->reply_to = trim($form_data['stage_template_to_mail']);
                        $email_data->user_email = $recipient_detail->usr_email;
						$email_data->mail_recipient_ids = $recipient_detail->usr_id;
						$email_data->CONFIRMATION_URL = $link;
						$email_data->user_id = $recipient_detail->usr_id;
                        $email_data->email_templates_config = $this->email_templates_config();
                        $email_data->join_config = $this->join_config();
                        $email_data->join_dependency_config = $this->join_dependency_config();
                        $email_data->user_role_tags = $this->user_role_tags();
                        $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                        // Email_templates::trans_start();
						if(empty($recipient_detail->usr_deeplink_token) && $registered_user == FALSE) 
						{
							User::update_record(array('usr_deeplink_token' => $usr_deeplink_token), array('usr_id' => $recipient_detail->usr_id), $current_user);
						}
                    
                        if(!empty($current_user['jnl_user_role']))
						{
						$core_role=(isset($form_data['core_role']))?$form_data['core_role']:'';
						$email_data->core_role = $core_role;
						$core_role_name=(isset($form_data['role_name']))?$form_data['role_name']:'';
						$email_data->core_role_name = $core_role_name;
						}
                        $this->send_email_notification((object)$email_template, $email_data,$current_user,'etmp_');
                        // Email_templates::trans_complete();

						$return_arr['status'] = 'success';
						// $return_arr['msg'] = lang('email_send_success');
                    }
                    else
                    {
                        $return_arr['status'] = 'warning';
						// $return_arr['msg'] = lang('confirm_tag_missing');
                    }
                    
                }
                else
                {
					$return_arr['msg'] = $recipient_detail->usr_first_name. ' '. $recipient_detail->usr_last_name. ' is not an awaiting user';
                }
            }
            else
            {
				$return_arr['msg'] = 'Recipient not exists';
            }
           
        } 
        return $this->success('success', 200, $return_arr);
        }
        catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
       
	}

    public function get_user_author_history(Request $request)
    {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $useridarray = array('input'=>trim(Rv_decrypt($form_data['user_id'])),'type'=>'number','required'=>TRUE, 'enc_data'=>FALSE );
            $useridvalidation= $this->Rv_validator($useridarray);
            if($form_data['jnl_id'] != ''){
                $jnlidarray = array( 'input' => trim(Rv_decrypt($form_data['jnl_id'])), 'type' => 'number', 'required' => FALSE, 'enc_data'=>FALSE );
                $jnlidvalidation= $this->Rv_validator($jnlidarray);
            }
            $authortypearray = array('input'=>trim($form_data['authoring_type']),'required'=>FALSE, 'enc_data'=>FALSE );
            $authortypevalidation= $this->Rv_validator($authortypearray);
            
            if($useridvalidation != TRUE || ($form_data['jnl_id'] != '' && $jnlidvalidation != TRUE) || $authortypevalidation != TRUE){
                    return $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
            }
            
            if(isset($form_data['jnl_id'])){
                $jnlidvalid = $this->validatecode(array('jnl_id'=>Rv_decrypt($form_data['jnl_id'])),false);
                if($jnlidvalid['jnl_id'] != TRUE ){
                    return $this->warning("Warning",200,customTrans('viewarticle.invalid_data'),'Warning'); 
                }
            }

            $user_id = (isset($form_data['user_id'])) ? Rv_decrypt($form_data['user_id']) : '';
            $page = (isset($form_data['page'])) ? $form_data['page'] : '';
            if ($page == '') $page = 0;
            $prev_lv_art_ids = (isset($form_data['prev_art_ids'])) ? $form_data['prev_art_ids'] : '';
            $prev_lg_art_ids = (isset($form_data['prev_legc_art_ids'])) ? $form_data['prev_legc_art_ids'] : '';
            $search = (isset($form_data['search'])) ? $form_data['search'] : '';
            $authoring_type = (isset($form_data['authoring_type'])) ? $form_data['authoring_type'] : '';
            $journal = (isset($form_data['jnl_id'])) ? Rv_decrypt($form_data['jnl_id']) : '';
            $current_user = $this->get_current_user_details();
            
            if((isset($form_data['authoring_type']) && ($form_data['authoring_type'] != 'Submitted' && $form_data['authoring_type'] != 'Co-authored')) ){
                return $this->warning("Warning",200,customTrans('viewarticle.invalid_data'),'Warning'); 
            }
            $limit = 10;
            $start = ($page - 1) * $limit;
            if (isset($journal) && $journal != ''){
                $format = $this->get_platform_date_format($journal);
            }
            else{
                $format = $this->current_client->settings->cs_date_format;
            }
            $date_format = date_format_map($format);

            //exclude blinded articles
            $blinded_articles = $this->get_blinded_articles($current_user['user_id']);
            if(gettype($blinded_articles) == 'string'){
                $blinded_articles = explode(',',$blinded_articles);
            }
            $author_id = '';
            $legacy_status  = false;
            if ((isset($this->current_client->functionality->cfty_enable_s1data)) && $this->current_client->functionality->cfty_enable_s1data == 'y') {
                $legacy_status = true;
                $role_arr = Roles::get_single_record('role_id', "role_assigned_role = 'author'");
                if (isset($role_arr->role_id) > 0){
                    $author_id = $role_arr->role_id;
                }
            }
            $author_history = Authors::get_author_history_details($user_id, $blinded_articles, $authoring_type, $date_format, $legacy_status, $journal, $start, $limit);
           
            if (count($author_history) > 0) {
                foreach ($author_history as $key => $auth_hist) {
                   /* if($this->is_custom_blinded('author', $auth_hist->artcle_id)){
                        unset($author_history[$key]);
                        continue;
                    } */
                    $decison = ($auth_hist->tbl == 'live') ? 'Peer review in progress' : '--';
                    $final_status = '';
                    if ($auth_hist->gp_status != '') {
                        $gp_arr = explode(',', $auth_hist->gp_status);
                        $final_status = end($gp_arr);
                        if ($final_status == 'a') {
                            $decison = 'Accepted';
                        } elseif ($final_status == 'r') {
                            $decison = 'Rejected';
                        } elseif ($final_status == 'c') {
                            $decison = 'Article Transfered';
                        } elseif ($final_status == 'y' && $auth_hist->tbl == 'live') {
                            $cur_stage_sql = ' SELECT jwf_stage_type FROM rvw_article_flow,rvw_journal_workflows WHERE aflw_jwf_id = jwf_id AND aflw_art_id = ' . $auth_hist->artcle_id . ' ORDER BY aflw_id DESC LIMIT 0,1';
                            $cur_status = Authors::get_records_by_raw_query($cur_stage_sql);
                            if (isset($cur_status) && count($cur_status) > 0) {
                                if ($cur_status[0]->jwf_stage_type == 'resubmission' ||  $cur_status[0]->jwf_stage_type == 'author_submission')
                                    $decison = 'set_revison';
                            }
                        }
                    }
                    $auth_hist->date = '';
                    if ($auth_hist->status != 'n' && $auth_hist->status != 'y')
                        $auth_hist->date = $auth_hist->decision_date;
                        
                        if ($auth_hist->tbl == 'legacy') {
                            if ($author_id != '')
                            $auth_hist->status_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' . $auth_hist->jnl_journal_code . '/legacy-article-view/' . encrypt_link('article_id=' . $auth_hist->artcle_id . '&role_id=' . $author_id);
                            else
                            $auth_hist->status_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' . $auth_hist->jnl_journal_code . '/legacy-article-view/' . encrypt_link( $auth_hist->artcle_id);
                        } else {
                            //$auth_hist->status_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' .  $auth_hist->jnl_journal_code . '/view-article/' . encrypt_link($auth_hist->artcle_id) . '/' .encrypt_link($auth_hist->flow_id);
                            $auth_hist->status_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' .  $auth_hist->jnl_journal_code . '/author-article/' . encrypt_link($auth_hist->artcle_id) . '/' .encrypt_link($auth_hist->flow_id);

                        }

                    $auth_hist->decison = $decison;

                }
            }

            $criteria = "role_assigned_role = 'author'";
            $role_data = Roles::get_single_record('role_id', $criteria);
            if (isset($role_data))
                $role_id = $role_data->role_id;
            $user_journal_criteria = "usrj_role_id ={$role_id} and usrj_artp_id IS NULL and usrj_usr_id={$user_id}";
            $user_journals = User_to_journals::get_all_records('*', $user_journal_criteria);
            
            $journals = [];
            if (!empty($user_journals) && count($user_journals) > 0) {
                foreach ($user_journals as $jnl) {
                    $jnl_arry = [];
                  //  $journal_criteria = 'jnl_id =' . $jnl->usrj_jnl_id;
                  $journal_criteria =array("jnl_id"=>$jnl->usrj_jnl_id);
                    $journaldata = Journals::get_single_record_with_bind_cond('jnl_id,jnl_journal_name', $journal_criteria, NULL, '');
          if(!empty($journaldata))
          {
            $jnl_arry['value'] = $journaldata->jnl_id;
            $jnl_arry['label'] = $journaldata->jnl_journal_name;
            if (!in_array($jnl_arry, $journals, true)) {
                array_push($journals, $jnl_arry);
            }
                }
            }
            }
            $data['data'] = $author_history;
            $data['journals'] = $journals;
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    public function upload_users(Request $request)
    {
        try{
        $form_data = $request->all();
        $config['upload_path']="./assets/images";
        $config['allowed_types']='csv';
       // $file =  $form_data->file_upload;
        $filename=$file->getClientOriginalName();
       
        
        $this->load->library('upload',$config);
        $selected_user_role = $this->input->post('selected_user_role');
        // if($this->upload->do_upload("file") && !empty($selected_user_role))
        if($this->upload->do_upload("file"))
        {
            $data = array('upload_data' => $this->upload->data());
            $this->read_upload_users($data['upload_data']['file_name'],$selected_user_role);
        }
        else
        {
            $return_data['status'] = 'error';
            $return_data['stat'] = 'failed';
            $return_data['msg'] = 'error occured';
            echo json_encode($return_data);            
        }
    } catch (\Exception $e) {

        return  $this->failure('Failed', 500, $e);
    }
    }
    public function get_usr_reset_password_email(Request $request)
    {
        try{
            $user_id=decrypt_link($request->user_id);
            // $condition='usr_id='.decrypt_link($request->user_id);
            $condition='usr_id=?';
            $recipient = User::get_single_record('usr_id,usr_email', $condition,binding_arr:[$user_id]);  // #6252
            $primary_email=$recipient->usr_email;
            // $criteria ="uml_user_id='{$user_id}' AND uml_status='c' AND uml_cc_email='y'"; 
            $criteria ="uml_user_id=? AND uml_status='c' AND uml_cc_email='y'"; 
            $cc_mail_data = User_emails::get_all_records('uml_email,uml_cc_email,uml_status',$criteria,binding_arr:[$user_id]); // #6252
            if(!empty($recipient)) {
                $cc_emails=array();
                $cc_email_id=array();
                $cc_bcc_emails=array();
                foreach($cc_mail_data as $cc_email)
                {
                array_push($cc_emails,$cc_email->uml_email);
                }
                if (!empty($cc_emails)) 
                {
                    foreach ($cc_emails as $cemail)
                    {
                    $cc_bcc_emails[$cemail] = $cemail;
                    }
                }
                $cc_bcc_emails['Custom'] = 'Specific email ID';
                $cc = [];
                $bcc = [];
                $cust_cc = [];
                $cust_bcc = [];
                $email_template_data = Email_templates::get_single_record_with_bind_cond('etmp_cc,etmp_bcc,etmp_cust_cc,etmp_cust_bcc',['etmp_name' => 'forgot_password']);
                // $cc_bcc_emails['etmp_bcc'] = "";
                if($email_template_data){
                    $cc = ($email_template_data->etmp_cc!="")?json_decode($email_template_data->etmp_cc):[];
                    $cust_cc = ($email_template_data->etmp_cust_cc!="")?explode(",",$email_template_data->etmp_cust_cc):[];
                    $bcc = ($email_template_data->etmp_bcc!="")?json_decode($email_template_data->etmp_bcc):[];
                    $cust_bcc = ($email_template_data->etmp_cust_bcc!="")?explode(",",$email_template_data->etmp_cust_bcc):[];
                }
                $return_arr = array('status' => 'success',
                                'cc' => $cc,
                                'bcc' => $bcc,
                                'cust_cc' => $cust_cc,
                                'cust_bcc' => $cust_bcc,
                                'cc_bcc_emails' => $cc_bcc_emails,
                                'primary_email'=>$primary_email);
                                return $this->success('success', 200, $return_arr);									

    }
      
 else
 {// $return_arr['model_info'] = $this->load->view('user/user_password_reset_confirmation',$return_arr, TRUE);
$return_arr['msg'] = 'Recipient not exists';
 $return_arr['status']='warning';

 }

        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
	}
    public function reset_password_email(Request $request)
    {
        try{
            $Email_templates = new \App\Models\Email_templates();
            $recipient_id=decrypt_link($request->hdn_usr_id);
            $request_data=$request->all();
            $condition = "usr_id={$recipient_id}";
            $user_record = User::get_single_record('usr_email,usr_jnl_standalone', $condition);
            if( !empty($user_record->usr_jnl_standalone) )
                {
                $criteria =array('jnl_id'=> $user_record->usr_jnl_standalone);
                $jrnl_grp_name = Journals::get_single_record_with_bind_cond('jnl_standalone_group', $criteria);
                $link = trim($this->build_url_standalone($jrnl_grp_name->jnl_standalone_group),'\/');
                 }
                 else
                 {
                 $link = URL::to('/');
                 }
                 $key = Str::random(10);
                 $usr_data = array( 'userid' => $recipient_id, 'datetime' => date("Y-m-d H:i:s"), 'key' => $key );
                 $encrypt_deeplink_user_data=$this->encrypt_data(json_encode($usr_data));
                 $update_arr = array('usr_deeplink_token' => $encrypt_deeplink_user_data);
                 $current_user = $this->get_current_user_details();
                 User::update_record($update_arr, $condition, $current_user);
    
                 $reset_link = $link . '/reset-password?' . encrypt_link('&userid=' . $recipient_id . '&datetime=' . date("Y-m-d H:i:s").'&key=' . $key);
                 $set_link = $link . '/set-password?' . encrypt_link('&userid=' . $recipient_id . '&datetime=' . date("Y-m-d H:i:s").'&key=' . $key);
                 $criteria ="etmp_name='forgot_password' AND etmp_notification='User'"; 
                 $record =  $Email_templates::get_single_record('*', $criteria);
                 if ($record!= NULL)
                 {
                         $subject=$record->etmp_subject;
                         $body=$record->etmp_email_template;
                         //TASK #3020 Change link to Button in mail
                            if($record != NULL)
                            {
                                $email_data = new stdClass;
                                $email_data->subject = $subject;
                                $email_data->body = $body;
                                $email_data->RESET_PASSWORD_LINK = $reset_link;
                                $email_data->SET_PASSWORD_LINK = $set_link;
                                $email_data->user_email = $user_record->usr_email;
                                $email_data->mail_recipient_ids = $recipient_id;
                                $email_data->user_id =$recipient_id;
                                $user_data['proxy_user_id'] = NULL;
                                $user_data['user_id'] = $recipient_id;
                                $email_template = array(
                                    'etmp_name' => 'confirm_mail',
                                    'etmp_cust_to' => '',
                                    'etmp_bcc' => '',
                                    'etmp_cc' => '',
                                    'etmp_cust_cc' => '',
                                    'etmp_cust_bcc' => '',
                                    'etmp_subject' => $subject,
                                    'etmp_email_template' => $body,
                                    'etmp_notification' => 'User'
                                );
                                $cc = $request_data['email_cc'] ?? "";
                                $etmp_cust_cc_array=[];
                                if(!empty($cc))
						        { 
	                            if(in_array('Custom', $cc)||in_array('Custom', $cc))
                                {  
                                    $email_cust_cc =$request_data['email_cust_cc'];
                                    foreach ($email_cust_cc as $key => $emailcustcc) 
                                    {
                                        array_push($etmp_cust_cc_array,$emailcustcc['value']);
                                                 
                                    }
                                    $commaSeparatedString = implode(',', $etmp_cust_cc_array);   
                                    $email_template['etmp_cust_cc'] = trim($commaSeparatedString);
                                }
                                
                                else{
                                    $email_template['etmp_cust_cc']='';
                                }
                                $etmp_email_cc = array_diff($request_data['email_cc'], array('Custom'));
                                 //$email_template['etmp_email_cc']=json_encode($etmp_email_cc);
                                 $email_template['etmp_cc']=json_encode($cc);
						        }

                                $bcc = $request_data['email_bcc'] ?? "";
                                $etmp_cust_bcc_array=[];
                                if(!empty($bcc))
						        { 
	                            if(in_array('Custom', $bcc)||in_array('Custom_bcc', $bcc))
                                {  
                                    $email_cust_bcc =$request_data['email_cust_bcc'];
                                    foreach ($email_cust_bcc as $key => $emailcustbcc) 
                                    {
                                        array_push($etmp_cust_bcc_array,$emailcustbcc['value']);
                                                 
                                    }
                                    $commaSeparatedString = implode(',', $etmp_cust_bcc_array); 
                                    $email_template['etmp_cust_bcc'] = trim($commaSeparatedString);
                                }
                                
                                else{
                                    $email_template['etmp_cust_bcc']='';
                                }
                                $etmp_email_bcc = array_diff($request_data['email_bcc'], array('Custom'));
                                //$email_template['etmp_email_bcc']=json_encode($etmp_email_bcc);
                                $email_template['etmp_bcc']=json_encode($bcc);
						        }
                                $email_data->email_templates_config = $this->email_templates_config();
                                $email_data->join_config = $this->join_config();
                                $email_data->join_dependency_config = $this->join_dependency_config();
                                $email_data->user_role_tags = $this->user_role_tags();
                                /*
                                if (isset($this->current_client->email_settings['reply_to_email'])) {
                                    $email_data->reply_to = $this->current_client->email_settings['reply_to_email'];
                                }
                                
                                if(!empty($this->current_user['jnl_user_role']))
                                {  
                                $core_role=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['core_role']:'';
                                $email_data->core_role = $core_role;
                                $core_role_name=(isset($this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]))?$this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_name']:'';
                                $email_data->core_role_name = $core_role_name;
                                }*/
                                $email_data->subject = $this->generate_email_data_from_keys($email_data, $email_data->subject, $current_user, '', false);
                                $email_data->body = $this->generate_email_data_from_keys($email_data, $email_data->body,  $current_user, '', false,true);
                                $this->send_email_notification((object)$email_template, $email_data, $user_data, 'etmp_');
                                $return_arr['status'] = 'success';
                                $return_arr['msg'] = customTrans('users.forgot_pwd_success_msg');
                                return $this->success('success', 200, $return_arr);
                            }
                 }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
	}

    public function send_user_feedback(Request $request)
    {
        try{
            $email_jnl_to   =   "";
            $status         =   "error";
            $post_data      =   $request->all();
            
            if(count($post_data) > 0) {
                $validator  =   Validator::make($post_data, [
                                    'contact_usrname' => 'required',
                                    'contact_subject' => 'required',
                                    'contact_email' => 'required|email',
                                    'contact_comments' => 'required'
                                ]);
                if($validator->fails())
                {
                    return  $this->failure('Failed',422,$validator->errors());
                }
                
                // start ----- ReView validation function for SQL injection
                $namearray      =   array('input'=>$post_data['contact_usrname'],'type'=>'text', 'enc_data'=>FALSE);
                $namevalidation =   $this->Rv_validator($namearray);
                $subjarray      =   array('input'=>$post_data['contact_subject'],'type'=>'text', 'enc_data'=>FALSE);
                $subjvalidation =   $this->Rv_validator($subjarray);
                $mailarray      =   array('input'=>$post_data['contact_email'],'type'=>'email', 'enc_data'=>FALSE);
                $mailvalidation =   $this->Rv_validator($mailarray);
                $cmtsarray      =   array('input'=>$post_data['contact_comments'],'type'=>'text', 'enc_data'=>FALSE);
                $cmntvalidation =   $this->Rv_validator($cmtsarray);
                $cjnvalidation   = true;
                if($post_data['contact_jnlname'] != ''){
                $Journals = (new \App\Models\Journals())->getTable();
                $criteria = array(
                    'jnl_journal_status' => 'y',
                    'jnl_standalone' => 'n',
                    'jnl_journal_code' =>$post_data['contact_jnlname']
                );
                $standalone_journal_group = session('group')??null;
                $standalone_journal_id  = Journals::get_single_record_with_bind_cond('jnl_id', null, "jnl_journal_status = ?  AND jnl_standalone_group = ? ", ['y', $standalone_journal_group])?->jnl_id;
                if ($standalone_journal_id != null) {
                    unset($criteria['jnl_standalone']);
                    $criteria['jnl_id'] = $standalone_journal_id;
                }

                $all_active_journals = Journals::get_single_record_with_bind_cond('jnl_id', $criteria);
                if(empty($all_active_journals)){
                    return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));	
                }
                } 
                $artvalidation  =   true;
                if($post_data['contact_article_id'] != ''){
                    $artarray       =   array('input'=>$post_data['contact_article_id'],'type'=>'text', 'enc_data'=>FALSE);
                    $artvalidation  =   $this->Rv_validator($artarray);
                }
                $jnl_id     =   $post_data['jnl_id'];
                if($jnl_id != '')
                {
                $cjnarray      =   array('input'=>$jnl_id,'type'=>'number', 'enc_data'=>FALSE);
                $cjnvalidation =   $this->Rv_validator($cjnarray);
                if (!empty($all_active_journals) && $all_active_journals->jnl_id != $post_data['jnl_id']) {
                    return $this->warning('Failed', 422, customTrans('viewarticle.invalid_data'));
                }
                }        

                // echo $namevalidation."|".$subjvalidation."|".$mailvalidation."|".$cmntvalidation."|".$artvalidation;
                if($namevalidation != TRUE || $subjvalidation != TRUE || $mailvalidation != TRUE || $cmntvalidation != TRUE || $artvalidation != TRUE || $cjnvalidation != TRUE){
                    return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));	
                }
                // end ----- ReView validation function for SQL injection

                $jnl_id     =   $post_data['jnl_id'];
                if(((isset($this->current_client->functionality->cfty_enable_journal_reply_to)) && ($this->current_client->functionality->cfty_enable_journal_reply_to == 'y'))
                && ($jnl_id != '')) {
                    $jrnl_grp   =   Journal_settings::get_single_record('jset_reply_to_email',"jset_jnl_id={$jnl_id}");
                    if(isset($jrnl_grp->jset_reply_to_email) && ($jrnl_grp->jset_reply_to_email != '')) {                    
                        $email_jnl_to = $jrnl_grp->jset_reply_to_email;                    
                    }
                }
                if($email_jnl_to == '')
                    $email_jnl_to     =   Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['reply_to_email'];// TASK #8907 contact us mail
                
                DB::beginTransaction();
                $mail_status =  $this->user_feedback_notification($post_data, $email_jnl_to);
                DB::commit();
                
                if ($mail_status == FALSE) {
                    $data['fd_email_status']    =   'n';
                    $return_arr['message']      =   'Message sending failed';
                    $status                     =   "error";
                    return  $this->warning('Warnings',200,$return_arr,'warning');
                } else {
                    $data['fd_email_status']    =   'y';
                    $return_arr['message']      =   'Message sent successfully';
                    $status                     =   "success";
                    return $this->success($status, 200, $return_arr);
                }
            }
          
        }  
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function export_to_xml(Request $request)
    {
        try{
        $form_data=$request->all();
        $jnl_code=$form_data['jnl_code'];
        $export_type =$form_data['export_type'];
        $validator = Validator::make($request->all(), [
            'jnl_code'      => 'required',
            'export_type'      => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed',200,$validator->errors());
        }
        else
        {
            if(!empty($export_type))
            {
                ini_set('memory_limit', '2G');
                ini_set('max_execution_time', 300);
                        
                        $select = "jnl_id,jnl_journal_code,usr_id,usr_user_legacy_id,usr_title,usr_username,usr_first_name,usr_middle_name,usr_last_name,usr_email as primary_email,usr_status";
                        $select .= ',GROUP_CONCAT(DISTINCT role_name SEPARATOR ", ") as user_journal_roles';
                        $select .= ',GROUP_CONCAT(DISTINCT kwd_name SEPARATOR "---") as user_keywords';
                        $User_to_journals = (new \App\Models\User_to_journals())->getTable();
                        $Journals = (new \App\Models\Journals())->getTable();
                        $Users = (new \App\Models\User())->getTable();
                        $Roles = (new \App\Models\Roles())->getTable();
                        $User_keywords = (new \App\Models\Userkeywords())->getTable();
                        $Keywords = (new \App\Models\Keywords())->getTable();


                        $tables = array(
                            'main_table' => $User_to_journals,
                            'join_table' => array(
                                $Journals => array($Journals. '.jnl_id', $User_to_journals . '.usrj_jnl_id', "left"),
                                $Users => array($Users . '.usr_id', $User_to_journals . '.usrj_usr_id', "left"),
                                $Roles  => array($Roles. '.role_id', $User_to_journals . '.usrj_role_id', "left"),
                                $User_keywords => array($User_keywords . '.ukwd_usr_id', $User_to_journals . '.usrj_usr_id', "left"),
                                $Keywords => array($Keywords. '.kwd_id', $User_keywords . '.ukwd_kwd_id', "left"),
                            )
                        );
                        if($export_type == 'all_normal_journals')
                        {
                            $xml_path = 'all_normal_'. env('PLATFORMTYPE').'_users';
                            $condi= "jnl_standalone='n' AND usr_id is not null";
                        }
                        elseif($export_type == 'specific_journals')
                        {
                            $condi= "jnl_journal_code='".$jnl_code."' AND usr_id is not null";
                        }
                        $usrs_to_jnl        = User_to_journals::get_results_using_joins($tables,$select,$condi,'all',NULL,NULL,'',NULL,NULL,FALSE,'usr_id',FALSE,array(),'usr_id');
                        if(count($usrs_to_jnl)>0)
                        {
                            $xml_string = '<?xml version="1.0"  encoding="UTF-8"?>'
                            . '<roster orgName="iet-com"></roster>';
                        if($export_type == 'specific_journals')
                        $xml_path = $usrs_to_jnl[0]->jnl_journal_code;
                        $file_location = storage_path() . '/app/public/uploads' . DIRECTORY_SEPARATOR . $xml_path ;
                        if (!file_exists($file_location))
                        mkdir($file_location, 0765, TRUE);
                        $client_details = $this->get_client_details();
                        $client_code = $client_details->clnt_client_code;
                        $file_location = $file_location . DIRECTORY_SEPARATOR . $client_code. '-' . $xml_path . '.xml';
                        if (file_exists($file_location))
                        unlink($file_location);
                        file_put_contents($file_location, $xml_string);
                        $destination = storage_path() . '/app/public/uploads' . $file_location;
                        $doc = new DOMDocument();
                        $doc->formatOutput = false;
                        $doc->documentURI=$destination;
                        $xpath = new DOMXpath($doc);
                        $root_element = $xpath->query('//roster');
                        $root_node = $root_element->item(0);
                        $root_node = $doc->createElement(env('PLATFORMTYPE').'_users');
                        $doc->appendChild($root_node);
                        
                        $i=0;
                        foreach($usrs_to_jnl as $each_user) 
                        {
                            if(!empty($each_user->usr_id))    
                            {
                                $user_attribute_set = array(
                                    'userName' => $each_user->usr_username,
                                    'salutation' => $each_user->usr_title,
                                    'firstName' => trim($each_user->usr_first_name),
                                    'middleName' => trim($each_user->usr_middle_name),
                                    'lastName' => trim($each_user->usr_last_name),
                                    // 'membershipStatusType' => $this->user->user_status[$each_user->usr_status],
                                    'legacyUserId' => $each_user->usr_user_legacy_id
                                );
                                $pearson_node = $doc->createElement('person');
                                $this->set_node_attribute($pearson_node,$user_attribute_set);
                                $root_node->appendChild($pearson_node);
                                
                                $User_affiliation = (new \App\Models\User_affiliations())->getTable();
                                $Country = (new \App\Models\Country())->getTable();
                                $select_aff        = "usaff_company as institution,usaff_department as department,usaff_ringgold_id as ringgold_id,usaff_address_line1 as addressLine1,usaff_address_line2 as addressLine2,usaff_postal_code as postalCode,cnt_country as country,usaff_phone as phone,usaff_type as type,IF (usaff_prime_affiliation='y','true','false')as is_primary";
                                $join_tables = array(
                                    'main_table' => $User_affiliation,
                                    'join_table' => array(
                                        $Country => array($Country. '.cnt_id', $User_affiliation . '.usaff_cnt_id', "join"),
                                        
                                        )
                                    );
                                $condition_aff     =  array('usaff_user_id' => $each_user->usr_id);
                                $result_set['create_element']        = 'department';
                                $result_set['attribute_set']        = User_affiliations::get_results_using_joins($join_tables,$select_aff,$condition_aff,'all',);
                                $this->set_node_attribute(Null,NULL,$doc,$pearson_node,$result_set);
                                //user email tag
                                $primary_email              = new stdClass();   
                                $primary_email->email_id       = $each_user->primary_email;
                                $primary_email->is_primary  = 'true';
                                $select_em        = "uml_email as email_id, IF(uml_email IS NULL,'true','false') AS is_primary";
                                $condition_em     =  array('uml_user_id' => $each_user->usr_id);
                                $result_set['create_element']       = 'emailAddress';
                                $result_set['attribute_set']        = User_emails::get_all_records_with_bind_cond($select_em,$condition_em);
                                $result_set['attribute_set'][]      = $primary_email;
                                $this->set_node_attribute(Null,NULL,$doc,$pearson_node,$result_set);
                                //user keyword tag
                            $keyword_attribute_set =array(
                                'name' =>   'keyword'
                            );
                            $attr_key_node = $doc->createElement('attributeTypeRef');
                            $this->set_node_attribute($attr_key_node,$keyword_attribute_set);
                            $pearson_node->appendChild($attr_key_node);
                            $user_keywords = explode('---',$each_user->user_keywords);
                            $user_keywords = array_map(function($e) {
                                $usr_keys['name'] = $e;                               
                                    return($usr_keys);
                            }, $user_keywords);
                            $result_set['create_element'] = 'attribute';
                            $result_set['attribute_set']  = $user_keywords;
                            $this->set_node_attribute(Null,NULL,$doc,$attr_key_node,$result_set);
                            
                            //user role tag
                            $role_attribute_set =array(
                                'name' =>   'journalUserRoles'
                            );
                            $attr_role_node = $doc->createElement('attributeTypeRef');
                            $this->set_node_attribute($attr_role_node,$role_attribute_set);
                            $pearson_node->appendChild($attr_role_node);
                            
                            $user_roles = explode(', ',$each_user->user_journal_roles);
                            $user_roles = array_map(function($e) {
                                $usr_roles['name'] = $e;                               
                                    return($usr_roles);
                            }, $user_roles);
                            $result_set['create_element'] = 'attribute';
                            $result_set['attribute_set']  = $user_roles;
                            $this->set_node_attribute(Null,NULL,$doc,$attr_role_node,$result_set);     
                            }
                        }
                       
                        $doc->saveXML();
                        $search_data['location']=$doc->save($file_location);
                        $search_data['file_path']=encrypt_link($file_location);
                        $search_data['filename']=basename($file_location);
                        return $this->success('success',200,$search_data);
                        $root_node = $root_element->item(0);
                        
                        }    
                       
            }
        }
    }catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }
        

    }
    public function set_node_attribute($current_node,$attribute_set=NULL,$doc=null,$parent_node=null,$join_attribute_set=NULL)
    {
        if($attribute_set!=NULL && is_array($attribute_set))
        {
            foreach ($attribute_set as $key=>$value)
            {
                $current_node->setAttribute($key, $value);
            }
        }
        elseif(!empty($join_attribute_set))
        {
            $attribute_set = $join_attribute_set['attribute_set'];
            foreach($attribute_set as $each_set)
            {
                $current_node = $doc->createElement($join_attribute_set['create_element']);
                foreach($each_set as $attr_key=>$attr_val)
                {
                    $current_node->setAttribute($attr_key, $attr_val);
                }
                $parent_node->appendChild($current_node);
            }
        }
    }
    public function force_download($filename = '', $data = '', $set_mime = FALSE)
	{
		if ($filename === '' OR $data === '')
		{
			return;
		}
		elseif ($data === NULL)
		{
			if ( ! @is_file($filename) OR ($filesize = @filesize($filename)) === FALSE)
			{
				return;
			}

			$filepath = $filename;
			$filename = explode('/', str_replace(DIRECTORY_SEPARATOR, '/', $filename));
			$filename = end($filename);
		}
		else
		{
			$filesize = strlen($data);
		}

		// Set the default MIME type to send
		$mime = 'application/octet-stream';

		$x = explode('.', $filename);
		$extension = end($x);

		if ($set_mime === TRUE)
		{
			if (count($x) === 1 OR $extension === '')
			{
				/* If we're going to detect the MIME type,
				 * we'll need a file extension.
				 */
				return;
			}

			// Load the mime types
			$mimes =& get_mimes();

			// Only change the default MIME if we can find one
			if (isset($mimes[$extension]))
			{
				$mime = is_array($mimes[$extension]) ? $mimes[$extension][0] : $mimes[$extension];
			}
		}

		/* It was reported that browsers on Android 2.1 (and possibly older as well)
		 * need to have the filename extension upper-cased in order to be able to
		 * download it.
		 *
		 * Reference: http://digiblog.de/2011/04/19/android-and-the-download-file-headers/
		 */
		if (count($x) !== 1 && isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/Android\s(1|2\.[01])/', $_SERVER['HTTP_USER_AGENT']))
		{
			$x[count($x) - 1] = strtoupper($extension);
			$filename = implode('.', $x);
		}

		if ($data === NULL && ($fp = @fopen($filepath, 'rb')) === FALSE)
		{
			return;
		}

		// Clean output buffer
		if (ob_get_level() !== 0 && @ob_end_clean() === FALSE)
		{
			@ob_clean();
		}

		// Generate the server headers
		header('Content-Type: '.$mime);
		header('Content-Disposition: attachment; filename="'.$filename.'"');
		header('Expires: 0');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: '.$filesize);
		header('Cache-Control: private, no-transform, no-store, must-revalidate');

		// If we have raw data - just dump it
		if ($data !== NULL)
		{
			exit($data);
		}

		// Flush 1MB chunks of data
		while ( ! feof($fp) && ($data = fread($fp, 1048576)) !== FALSE)
		{
			echo $data;
		}

		fclose($fp);
		exit;
	}
    //Task#605-Export users from ReView as XML
	public function get_all_journals(Request $request)
	{
        try{
            $Journals=new \App\Models\Journals();
            $journals_data = $Journals::get_all_records_with_bind_cond('jnl_journal_code,jnl_journal_name');
            $status='Success';
            return $this->success($status, 200, $journals_data );
        }  
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
	}
    public function getstandalone(Request $request)
    {
        try{
            if ($this->current_client->modules->mdl_standalone_journals == 'y')
            {
                $standalone_journals = Journals::get_all_records_with_bind_cond('jnl_id,jnl_journal_name', array(
                    'jnl_standalone' => 'y'
                ));
                /*
                $all_users_object = new \stdClass();
                $all_users_object->jnl_id = '';
                $all_users_object->jnl_journal_name = customTrans('users.normal_user');
                // Add the object to the beginning of the collection
                $standalone_journals->prepend($all_users_object);
                */
                return $this->success('success', 200, $standalone_journals );
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e); 
        }     
    }


    public function check_same_usr_jnl_flg_exists(Request $request) {
        try {
            $flagsArr   =   array();
            $userid     =  '';

            $form_data  =   $request->all();
            if(isset($form_data['flags'])){
                foreach($form_data['flags'] as $key => $arr) {
                    $flagsArr[]    =   $arr['value'];
                }
            }
            if($this->current_client->platform_type == 'journal')
                $platform   =   'j';
            else if($this->current_client->platform_type == 'book')
                $platform   =   'b';
            else
                $platform   =   'c';

            if(isset($form_data['userid']))
                $userid     =   $this->decrypt_data($form_data['userid']);
            
            $lblArr     =   array();
            if(count($flagsArr) > 0){
                $resArr     =   array();
                $flags      =   implode(",", $flagsArr);
                $cusr_jnl_flgs = User_flags::fetch_all_usr_jnl_flags($flags, $userid, $platform);
                if(count($cusr_jnl_flgs) > 0) {
                    foreach($cusr_jnl_flgs as $key => $obj) {
                        $resArr[$obj->flag_name][]  =   '<b>'.$obj->jnl_journal_name.'</b>';
                    }
                }
                
                if(count($resArr) > 0) {
                    foreach($resArr as $flg => $jnlarr) {
                        $jnls       =   preg_replace("/,([^,]+)$/", " and $1", implode(", ", $jnlarr));
                        $lblArr[]   =   '"<b>'.$flg.'</b>" flag wil be removed from '.$jnls.' for this user.';
                    }
                }
            }
            return $this->success('success', 200, $lblArr );
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function resetMFA(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $post_data=$request->all();
            $useridarray = array('input'=>$post_data['user_id'],'type'=>'string', 'enc_data'=>TRUE );
            $useridvalidation = $this->Rv_validator($useridarray);
            if($useridvalidation != true){
                return  $this->warning('Warning',200,customTrans('viewarticle.invalid_data'),'Warning');
            }
            $return_array=array();
            $user_id=Rv_decrypt($post_data['user_id']);
            $this->current_user = $this->get_current_user_details();
            if(isset($this->current_user['roles']) && in_array('sudo',$this->current_user['roles'])){
                $select = 'usr_id,usr_mfa_token,usr_alt_totps';
                $updt_data = array(
                    'usr_mfa_token' => null,
                    'usr_alt_totps' => null
                );
                $condition = ['usr_id'=>$user_id];
                $User=new \App\Models\User();
                $userDetails=$User::get_single_record_with_bind_cond($select,$condition);
                if($userDetails){
                    $User::update_record($updt_data,$condition);
                    $return_array['status']='Success';
                    $return_array['msg']='MFA reset successfully';
                }else{
                    $return_array['status']='Failed';
                    $return_array['msg']='User not found';
                }
                //$userDetail = User::get_single_record($select,"usr_id={$user_id}");
            }
            return  $this->success($return_array['status'],200,$return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function generate_sudo_password(Request $request)
    {
        try{
        $password = '';
        $passwordSets = ['1234567890', '!@#$%^&*()_+=-}{[}]\|;:<>?/', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijkmnpqrstuvwxyz'];
        //Get random character from the array
        foreach ($passwordSets as $passwordSet) {
            $password .= $passwordSet[array_rand(str_split($passwordSet))];
        }
    
        // 10 is the length of password we want
        while (strlen($password) < 10) {
            $randomSet = $passwordSets[array_rand($passwordSets)];
            $password .= $randomSet[array_rand(str_split($randomSet))];
        }
        $return_array['status'] = 'success';
        $return_array['sudo_password'] = $password;
        return $this->success('Success',200,$return_array);
    } catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }
    }
    public function update_sudo_password($post_data)
    {
        try{
               if(isset($post_data['generate_password'])) 
               {
             $user_id = $post_data['user_id'];
             $userval = User::get_single_record_with_bind_cond('usr_pwd',array('usr_id'=>$user_id));
             $password = Hash::make($post_data['generate_password']);
             $check_pass=(new Manage_Register_Api())->check_recent_passwords($user_id,$post_data['generate_password']);
             if($check_pass==true && !empty($check_pass))
             {
                  return array(
                    'status' => 'warning',
                    'msg' => customTrans('users.resetpasswordvalid')
                );
             }
            else
             {
             $userdata = array(
                'user_id' => $user_id,
                'proxy_user_id' => 0,
            );
            $edit_user = 'usr_id=' . $user_id;
            $data['usr_pwd'] = $password;
            $data['usr_f_status'] = 'n';
            User::update_record($data, $edit_user, $userdata);
            $this->update_password_history($password, $user_id, $userdata);
            $user_data = array("password" => $post_data['generate_password'], "user_id" => $user_id);
            $this->send_change_password_success($user_data);
                    return array(
                        'status' => 'success',
                        'msg' => "Password changed successfully"
                    );
                }        
            }

        } catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }
    }
    public function manage_users_journal($user_journal)
    {
        try {
            if (
                isset($user_journal['journal_user_name']) &&
                !empty($user_journal['journal_user_name']) &&
                isset($user_journal['journal_user_role']) &&
                !empty($user_journal['journal_user_role'])
            ) {
                DB::beginTransaction();
                $this->current_user = $this->get_current_user_details();
                $return_arr['roles_insert']= '';
                if (is_array($user_journal['journal_user_role'])) {
                    $new_roles = $user_journal['journal_user_role'];
                } else {
                    $new_roles = explode(",", $user_journal['journal_user_role']);
                }

                $cond = array(
                    'usrj_jnl_id' => $user_journal['hdn_jnl_id'],
                    'usrj_usr_id' => $user_journal['journal_user_name'],
                    'usrj_artp_id' => NULL
                );

                $current_roles = User_to_journals::get_all_records_with_bind_cond('usrj_id,usrj_role_id', $cond);
                $cur_role_record_ids = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE), 'usrj_id') : array();

                $cur_user_roles_in_jrnl = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE), 'usrj_role_id') : array();

                $return_arr['removal_failed_roles'] = array();
                if (!empty($cur_user_roles_in_jrnl) && !empty($new_roles)) {
                    $remove_roles = array_diff($cur_user_roles_in_jrnl, $new_roles);

                    if (!empty($remove_roles) && isset($remove_roles)) {

                        $return_arr['removal_failed_roles_msg'] = customTrans('platform_settings.role_removal_failed') . '<br>';

                        foreach ($remove_roles as $key => $r_roles) { //check role required

                            $role_required = $this->check_role_required('j', $user_journal['hdn_jnl_id'], $user_journal['journal_user_name'], $r_roles);


                            if ($role_required['status'] !== false) {

                                unset($remove_roles[$key]);
                                $condition = "role_id={$r_roles}";
                                $temp = Roles::get_single_record('role_name', $condition);

                                $role_required_exists = false;
                                foreach ($return_arr['removal_failed_roles'] as $element) {
                                    if ($element['reason'] === $role_required['reason']) {
                                        $role_required_exists = true;
                                    }
                                }
                                if (!$role_required_exists) {
                                    array_push($return_arr['removal_failed_roles'], array(
                                        'role_name' => $temp->role_name,
                                        'reason' => $role_required['reason']
                                    )
                                    );
                                    $return_arr['removal_failed_roles_msg'] .= $temp->role_name . '-' . $role_required['reason'] . '.<br>';
                                }

                            }
                        }

                        if (!empty($remove_roles)) {
                            $user_data = array(
                                'usrj_jnl_id' => $user_journal['hdn_jnl_id'],
                                'usrj_usr_id' => $user_journal['journal_user_name'],
                            );
                            $del_result = User_to_journals::delete_records_wherein($user_data, $this->current_user,$remove_roles,'usrj_role_id','');
                            // $del_result = User_to_journals::del_user_roles($user_data, $remove_roles);


                        }
                    }
                }
                if (count($new_roles) > 0) {
                    $insert_bulk_data = array();
                    for ($k = 0; $k < count($new_roles); $k++) {
                        if (!in_array($new_roles[$k], $cur_user_roles_in_jrnl)) // need to insert only new role
                        {
                            $res = Roles::get_all_records_with_bind_cond('role_assigned_role', array('role_id' => $new_roles[$k]));
                            //Check user role
                            $article_user_role = $this->RolesConfigdata('article_user_role')['article_user_role'];
                            $article_roles = array_keys($article_user_role);
                            $role_used = $this->RolesConfigdata('privileged_user_roles');
                            $privillaged_users = $role_used['privileged_user_roles'];
                            if (in_array($res[0]->role_assigned_role, $article_roles) || in_array($res[0]->role_assigned_role, $privillaged_users)) {
                                $article_data = array();

                                $article_data = Article_types::get_all_records_with_bind_cond('artp_id', array('artp_jnl_id' => $user_journal['hdn_jnl_id']));


                                foreach ($article_data as $article) {
                                    $data = array(
                                        'usrj_jnl_id' => $user_journal['hdn_jnl_id'],
                                        'usrj_usr_id' => $user_journal['journal_user_name'],
                                        'usrj_role_id' => $new_roles[$k],
                                        'usrj_artp_id' => $article->artp_id,
                                        'usrj_posted_by' => $this->current_user['user_id'],
                                        'usrj_proxy_id' => $this->current_user['proxy_user_id'],
                                        'usrj_posted_date' => date('Y-m-d H:i:s'),
                                    );
                                    array_push($insert_bulk_data,$data);	
                                   


                                }
                              
                                $return_arr['roles_insert']= User_to_journals::insert_batch($insert_bulk_data);
                            }
                            $data = array(
                                'usrj_jnl_id' => $user_journal['hdn_jnl_id'],
                                'usrj_usr_id' => $user_journal['journal_user_name'],
                                'usrj_role_id' => $new_roles[$k],
                                //'usrj_status' => 's',
                            );
                            $return_arr['roles_insert'] = User_to_journals::insert_record($data, $this->current_user);

                       
                        }

                    }
                }
            }
             
            if (DB::commit() !== FALSE && ($return_arr['roles_insert']== TRUE || isset($del_result))) {
                if(env('VITE_CONFERENCE_PROCEEDINGS') === true){
                    $pltFrm     =  'Conference';
                }
                else {
                    $pltFrm     =   $this->current_client->platform_type;
                }
                $return_arr['msg'] = customTrans('platform_settings.jnlroleupdates') . ' ' . $pltFrm;
            }
            else
            {
                $return_arr['msg'] ='';
            }
           
            return $return_arr;

        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_unsubscribe_email(Request $request)
    {
        try {
            $form_data = $request->all();
            $ip_address = $request->ip();
            $parms = $form_data['user_url'] ?? '';
            if (!$parms) {
            return $this->failure('Missing parameters', 400);
            }
            parse_str(decrypt_link($parms), $data);
            $selectedEmail = $form_data['selected_email'] ?? ($data['email'] ?? '');
            if (!filter_var($selectedEmail, FILTER_VALIDATE_EMAIL)) {
            return $this->failure('Missing parameters', 400);
            }
            $key = isset($data['key']) ? $data['key'] : '';
             $return_array = [
            'email' => [],
            'unsubscribe' => false
            ];

            if (isset($data['email']) && $data['email'] != '') {
                $emails = explode(',', $data['email']); 
                $return_array['email'] = $emails; 
                $emailexist = Unsuscribe_email::get_single_record_with_bind_cond(
                    '`usl_id`, `usl_email`, `usl_status`,`usl_token`',
                    ['usl_email' => $selectedEmail]
                );
                if ($emailexist) {
                if($emailexist->usl_token ==$key){
                    $condition = ['usl_email' => $emailexist->usl_email];
                    $update_data = [
                                    'usl_status'      =>'y',
                                    'usl_cc_status'   => 'y',
                                    'usl_posted_date' => now(),
                                    'usl_ipaddress'   => $ip_address,
                                    'usl_token'       => '',
                                ];
            Unsuscribe_email::update_record($update_data, $condition);
            $return_array['unsubscribe'] = false;
            return $this->success('Success', 200, $return_array);
                }
                else
                {
                    $return_array['subscribe_email'] =true;
                    $return_array['unsub_msg'] = "Invalid Link";
                }
                }
        
        if ($emailexist && $emailexist->usl_status == 'y') {
            $return_array['unsubscribe'] = false;
        }
        else{
            $return_array['unsubscribe'] = true;
        }

                return $this->success('Success', 200, $return_array);
            }

            return $this->failure('Email not found', 400);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e->getMessage());
        }
    }
     public function unsubscribe_email(Request $request)
    {
        try {
            $form_data = $request->all();
            $parms=$form_data['user_url'];
            $return_array=array();
            $emaildata=array();
            $current_user =array();
            $comment=isset($form_data['usl_comment'])?$form_data['usl_comment']:'';
            $usl_email= isset($form_data['usl_email'])?$form_data['usl_email']:'';
            parse_str(decrypt_link($parms), $data);
            $usl_batch_id= isset($data['batch_id'])?$data['batch_id']:'';
            $sendemaildata['clnt_client_code']= isset($data['clnt_client_code'])?$data['clnt_client_code']:'';
            $email = $form_data['usl_email'] ?? null;
            $email =empty($email)?$data['email']:$form_data['usl_email'];
            if (empty($email)) {
                return $this->failure('Email is required', 422);
            }
            $key = Str::random(20);
            $ip_address = trim(shell_exec("dig +short myip.opendns.com @resolver1.opendns.com"));
            $get_email_record =User::get_single_record_with_bind_cond('usr_id',array('usr_email'=>trim($email)));
            $usr_id= isset($get_email_record->usr_id)?$get_email_record->usr_id:'';
            $sendemaildata['usl_batch_id']=$usl_batch_id;
            $sendemaildata['email']=$email;
            $sendemaildata['key']=$key;
            $sendemaildata['usl_user_id']=$usr_id;
            $emaildata = [
            'usl_user_id'     =>$usr_id,
            'usl_status'      =>'n',
            'usl_cc_status'   => 'n',
            'usl_posted_date' => date('Y-m-d H:i:s'),
            'usl_posted_by'   => 0,
            'usl_email'       => $email,
            'usl_token'       => $key,
            'usl_ipaddress'   => $ip_address,
            'usl_esl_batch_id'=> $usl_batch_id,
            'usl_comments'    => $comment
            ];
            $current_user = array(
                                'user_id' => $emaildata['usl_user_id'],
                                'usr_jnl_standalone' => auth()->user()->usr_jnl_standalone ??'',
                                'proxy_user_id' => 0
                            );
            $emailexist=Unsuscribe_email::get_single_record_with_bind_cond('`usl_id`, `usl_user_id`, `usl_status`, `usl_posted_date`, `usl_posted_by`, `usl_email`, `usl_esl_batch_id`, `usl_comments`', array('usl_email'=>$email));
            if ($emailexist && $emailexist->usl_status == 'n') {
            $condition = ['usl_id' => $emailexist->usl_id];
            $update_data = [
                'usl_posted_date' => now(),
                'usl_ipaddress'   => $ip_address,
                'usl_token'       => $key,
            ];
            Unsuscribe_email::update_record($update_data, $condition);
            $return_array['sel_unsubscribe'] = true;
           
            }
            else{
                 if(!empty($emailexist)){
                        $whereCondition = ['usl_email' => $emailexist->usl_email];
                            Unsuscribe_email::delete_records($whereCondition, '', $current_user);
                            $return_array['subscribe_email'] = false;
                            $return_array['unsubscribe'] = true;
                        $return_array['msg']=customTrans('manageusers.your-response-successfully-saved');
                         return $this->success('Success', 200, $return_array);
                       }
                       else{
                        Unsuscribe_email::insert_record($emaildata,$current_user);
                        $return_array['unsubscribe'] = false;
                        $return_array['msg']=customTrans('manageusers.your-response-successfully-saved');
                       }

            }
            //   trigger unsubscribe mail
           $resmail =$this->unsubscribe_email_trigger($sendemaildata);
            return  $this->success('Success',200,$return_array);  

        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
            
        }
    }

}
