<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Config;
use DB;
use App\Models\Articles;
use App\Models\Article_keywords;
use App\Models\Article_flow;
use App\Http\Traits\StagemovementTrait;
use App\Models\Roles;
use App\Models\Ithenticate_autosubmission;
use Illuminate\Support\Facades\URL;
use App\Http\Traits\SubmissionTrait;
use Illuminate\Support\Str;
use App\Http\Traits\ArticlelistTrait;
use App\Http\Traits\IthenticateTrait;
use App\Models\Authors;
use App\Models\Attachment_files;
use App\Models\Article_pdf;
use App\Models\Article_classification;
use App\Models\User_to_journals;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\ViewarticleTrait;
use App\Models\Issue_management;
use App\Models\Issues;
use App\Models\Article_generic_form_data;
use App\Models\Suspecious_activity;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\ReviewerListTrait;
use App\Http\Traits\UserDataTrait;
use App\Models\Generic_flows;
use App\Models\Stage_email_tmpl_reference;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\WorkflowAssignmentTypeTrait;
use App\Models\Article_type_advance_options;
use App\Models\Email_attachments;
use App\Models\Email_templates;
use App\Models\Stage_email_templates;
use App\Models\Generic_forms;
use App\Models\Email_send_log;
use App\Models\Article_custom_reasons;
use App\Models\Research_integrity_reports;
use \stdClass;
use \Mpdf\Mpdf as PDF;
use File;
use  App\Http\Traits\RolesConfigTrait;
use App\Models\ConveyData;
use App\Models\User_to_journal_orcid_details;
use Carbon\Carbon;
use Response;
use Exception;
use Log;
use Illuminate\Support\Collection;
use App\Http\Traits\ResearchIntegrityTrait;
use App\Models\Copyright_request;
use App\Models\Article_notification_emails;
use Illuminate\Support\Facades\Request as RequestFacade;

class Manage_Viewarticle_Api extends Controller
{
    use StagemovementTrait;
    use SubmissionTrait;
    use ArticlelistTrait;
    use StandaloneDataTrait;
    use IthenticateTrait;
    use UtilityTrait;
    use ReviewerListTrait;
    use WorkflowAssignmentTypeTrait;
    use RolesConfigTrait;
    use ViewarticleTrait;
    use ResearchIntegrityTrait;
    
    public $current_user;
    public $repeatedstagearray;
    public $currentstatusid;
    public $reviewflow;

    //*** used for displaying header and basic details starts  ***/
    public function get_article_basicdetails(Request $request)
    {
       try {
            $this->current_user = $this->get_current_user_details();
            $articletype_table = (new \App\Models\Article_types())->getTable();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnlcode' => 'required',
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'role_id'=> 'required',
                'type'=>'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']):'';
            $art_id = isset($post_data['art_id']) ? Rv_decrypt($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ? Rv_decrypt($post_data['art_flow_id']) : '';
            $role_id = isset($post_data['role_id']) ? Rv_decrypt($post_data['role_id']) : '';
            $type = isset($post_data['type']) ? Rv_decrypt($post_data['type']) : '';
            $version = isset($post_data['version']) ? $post_data['version'] : '';
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnlcode);
            if($existrecord === false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $platform_id = $platform_data->jnl_id;
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $workflow_arr  = Config::get($workflow_config);
            $date_format = static::date_format_map($platform_data->jset_date_format);
            // Task #3393 Copyright Aipp New tile for author
            $select_article_details = 'art_id,art_artp_id,art_code,artp_prefix_article_no,art_title,art_abstract,art_resubmission_no,art_status,DATE_FORMAT(art_submission_date, "' . $date_format . '") as submitted_date,art_submission_date,art_doi,art_submitted_by,artp_article_type,art_published_article_type,(select artp_article_type from ' . $articletype_table . ' where  artp_id = art_published_article_type) as published_artp_name,art_prev_article_id,DATE_FORMAT(art_decision_date, "' . $date_format . '") as decision_date,art_receive_funding,art_stub,art_version_no,datediff(NOW(),art_submission_date) as days_since_submission,art_article_upload_path,art_transfer_status,art_skipped_assignment_roles,art_delete_status,art_publication_issue,jwf_status_name,jwf_stage_name,jwf_forms,jnl_journal_name,artp_fwm_id,art_stage_submission_method,auth_usr_id,aflw_id,jnl_id,jnl_journal_code,artp_jpm_id,artp_jpm_id,artp_id,aflw_parent_flow_id,DATE_FORMAT(art_merge_date, "' . $date_format . '") as art_merge_date,aflw_status,jwf_stage_type,artp_abbr_article_type,artp_special_issue,art_publication_issue,art_stub,jwf_article_editable,art_pre_all_ids,jwf_role_id,jwf_parent_user_roles,jwf_who_can_invite,jwf_assignment,aflw_usr_id,art_transfer_article,aflw_jwf_id,art_es_document_status,art_es_document_type,art_copyright_request';

            if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
            {
                $select_article_details .= ',DATE_FORMAT(art_epub_date, "' . $date_format . '") as epub_date,DATEDIFF(art_epub_date, CURDATE()) AS date_difference';
            }
            if ($this->current_client->modules->mdl_review_for_doc == 'y')
            {
                $select_article_details .= ',DATE_FORMAT(art_update_last_date, "' . $date_format . '") as update_last_date';
            }

            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y'){
                $select_article_details .= ', absc_category as abstract_category';
            }

            $condition = "aflw_art_id=:art_id and jnl_id=:jnl_id and auth_corr_author=:authorstatus";
            $condition_arr=array(
                'art_id' => $art_id,
                'jnl_id'=>$platform_id,
                'authorstatus'=>'y'
            );
            if (!empty($art_flow_id)) {
                $condition .= " and aflw_id=:aflw_id";
                $condition_arr=array(
                    'art_id' => $art_id,
                    'jnl_id'=>$platform_id,
                    'authorstatus'=>'y',
                    'aflw_id'=>$art_flow_id
                );
            }
            $article_details = Articles::get_article_details($select_article_details, $condition, null, true, false,null,$condition_arr);
            $Issues = new \App\Models\Issues();
            if(!empty($article_details))
            {
            foreach ($article_details as $article) {

                if($article->art_delete_status == 'y')
                {
                    return  $this->warning('Failed', 200, "redirectdashboard");
                }

                $article->art_code_display = $article->art_code;
                $array_data['user_id'] = $article->art_submitted_by;
                $array_data['journal_id'] = $platform_id;
                $array_data['flag'] = true;
                $array_data['article_id'] = $article->art_id;
                $array_data['jnl_code'] = $jnlcode;
                $article->original_article_code = '';
                if($article->art_status == 'n' && $article->art_stage_submission_method == 'o' && $article->art_submission_date == null) {
                    $original_article_code_preview = $this->create_article_code($article->artp_id, $article->artp_prefix_article_no);
                    $article->original_article_code = $original_article_code_preview;
                }
                $article->submitted_user = $this->get_user_display_name($array_data);
                $array_data['user_id'] = $article->auth_usr_id;
                $article->corresponding_user = $this->get_user_display_name($array_data);
                if (isset($article->art_publication_issue) && !empty($article->art_publication_issue)) {
                    $iss_conditon="iss_id=:publ_iss";
                    $iss_arr=array('publ_iss'=>$article->art_publication_issue);
                    $issues = $Issues::get_single_record('iss_hard_end_date,iss_special_issue', $iss_conditon,NULL,'',NULL,$iss_arr);
                    $article->iss_hard_end_date = isset($issues->iss_hard_end_date) ? $issues->iss_hard_end_date : '';
                    $article->iss_special_issue = isset($issues->iss_special_issue) ? $issues->iss_special_issue : '';
                } else {
                    $article->iss_hard_end_date = '';
                    $article->iss_special_issue = '';
                }
                $is_special = $this->check_special_issue_in_article($article);
                $is_invited = false;
                if (isset($article->art_stub) && $article->art_stub != 'n') {
                    $is_invited = true;
                }
                $article_code = $this->get_article_display_code($article->art_id, $platform_id, $is_special, $is_invited,role_id:$role_id);
                $article->art_code = $article_code;
                //Article Flags
                $article->articleFlags = $this->get_article_flags_formatted($article->art_id,$jnlcode);
                $article->istransfer=($article->art_transfer_article=='y')?true:false;
                $article->intial_submitted ='';
                if($article->art_pre_all_ids!='')
                {
                    $pre_add_ids=explode(',',$article->art_pre_all_ids);
                    $intial_id=$pre_add_ids[0];
                    $select_article_details = 'DATE_FORMAT(art_submission_date, "' . $date_format . '") as submitted_date';
                    $art_conditon='art_id=:intial_id';
                    $art_arr = array('intial_id'=>$intial_id);
                    $article_record = Articles::get_single_record($select_article_details,$art_conditon,null,'',null,$art_arr);
                    // TASK #8589 While viewing an article as an Associate Editor, a TypeError occurred when retrieving article details
                    if(isset($article_record)&&$article_record->submitted_date)
                    {
                        $article->intial_submitted = $article_record->submitted_date;
                    }
                }
                $cutstagedata =$workflow_arr[$article->jwf_stage_type];
                $stage_for =$cutstagedata['stage_for'];
                $article->submitting_author = $article->art_submitted_by == $this->current_user['user_id'];
            }
            $return_array['article_details'] = $article_details;
            $typedata =(isset($stage_for) && $stage_for=="review")?false:true;
            $return_array['production_stage']=$typedata;
            $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $article_keywords = Article_keywords::get_article_keywords($art_id, false, false, $hierachy, $platform_id);
            $article_basics = json_decode(json_encode($article_details[0]), false);


            //On submitting check for the forms in workflow, and remove unwanted forms if not added in the workflow.--Starts
            $formatted_journal_code = '_'.$article_basics->jnl_journal_code;
            if(!empty($article_basics->jwf_forms) && count(json_decode($article_basics->jwf_forms)) > 0 && $article_basics->aflw_status == 'a'){
                $form_ids = implode(',',json_decode($article_basics->jwf_forms));
                $element_condition = "gdata_atf_id NOT IN (". $form_ids .") AND gdata_art_id = " .$article_basics->art_id. " AND gdata_artflw_id = " .$article_basics->aflw_id;
                $existdata = Article_generic_form_data::get_all_records("gdata_id,gdata_atf_id,gdata_art_id,gdata_artflw_id",$element_condition,null,null,$formatted_journal_code);
                if(!empty($existdata)) {
                    Article_generic_form_data::delete_records($element_condition, $formatted_journal_code, $this->current_user);
                }
            }
            //On submitting check for the forms in workflow, and remove unwanted forms if not added in the workflow.--ends

            $article_privilages = $this->article_privilages($article_basics, $art_flow_id, $jnlcode);
            $show_comments_es=true;
            if($article_privilages['privilaged'] === false)
            {

                        $Article_flow = new \App\Models\Article_flow();
                        $articleflow_table = (new \App\Models\Article_flow)->getTable();
                        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
                        $tables = array(
                            'main_table' =>  $articleflow_table,
                            'join_table' => array(
                                $genericflow_table => array($genericflow_table . '.jwf_id', $articleflow_table . '.aflw_jwf_id', "join")
                            )
                        );
                $condition = "aflw_art_id=? AND aflw_usr_id=? AND aflw_status in('a','u')";
                $binding_arr = array($article->art_id,$this->current_user['user_id']);
                $original_art_data_es = Article_flow::get_results_using_joins($tables, 'aflw_id', $condition, 'all', null, null,'',null,null,false,null,false,$binding_arr);
                if(!empty($original_art_data_es) && count($original_art_data_es)>0)
                {
                    $show_comments_es=true;
                } else{
                    $show_comments_es=false;
                }

                //Allow add notes for co-authors if current stage is author stage
                if($show_comments_es===false)
                {
                    $criteria2 = array("auth_usr_id"=>$this->current_user['user_id'],"auth_art_id"=>$article->art_id,"auth_confirm_status"=>'y');
                    $co_authors = Authors::get_single_record_with_bind_cond('auth_id',$criteria2);

                    if(!empty($co_authors))
                    {
                        $Article_flow = new \App\Models\Article_flow();
                        $articleflow_table = (new \App\Models\Article_flow)->getTable();
                        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
                        $roles_table = (new \App\Models\Roles)->getTable();
                        $tablesnew = array(
                            'main_table' =>  $articleflow_table,
                            'join_table' => array(
                                $genericflow_table => array($genericflow_table . '.jwf_id', $articleflow_table . '.aflw_jwf_id', "join"),
                                $roles_table => array($roles_table . '.role_id', $genericflow_table . '.jwf_role_id', "join")
                            )
                        );
                        $conditionnew = "aflw_art_id=? AND aflw_status in('a','u') AND role_assigned_role='author'";
                        $binding_arr = array($article->art_id);
                        $original_art_data_co_author = Article_flow::get_results_using_joins($tablesnew, 'aflw_id', $conditionnew, 'all', null, null,'',null,null,false,null,false,$binding_arr);
                        if(!empty($original_art_data_co_author) && count($original_art_data_co_author)>0)
                        {
                            $show_comments_es=true;
                        }
                    }

                }
            }

            $return_array['show_comments_es'] = $show_comments_es;
            $return_array['article_privilages'] = $article_privilages;
            $user_roles = $this->validate_user_journal($article_basics->jnl_journal_code, $this->current_user['user_id'], $article_basics->art_artp_id);
            $array_data['user_roles'] = $user_roles;
            if($version == "current")
            {
            $check_user_permission =$this->checkuserhaspermission($article_privilages,$user_roles,$article_basics,$this->current_user['user_id'],$platform_id,$jnlcode);
            if($check_user_permission===false)
            {
                return  $this->warning('Failed', 200, "permission_denied");
            }
            }
            $return_array['currentstatus'] =$this->get_current_status($article_basics,$article_privilages,true,$role_id);
            if($type =="basic")
            {
            $select = "jp_edit_articles";
            $condition = "artp_id=:artp_id";
            $permissions = $this->get_article_type_permission($select, $condition,array('artp_id'=>$article_basics->artp_id));
            $article_details_edit_mode = false;
            if ($article_privilages['privilaged'] === true && (isset($permissions->jp_edit_articles) && $permissions->jp_edit_articles != null) && (!in_array($article_basics->art_status, array(
                'r',
                'c'
            ))) && count(array_intersect(json_decode($permissions->jp_edit_articles), $user_roles['role_id'])) > 0 && $article_basics->aflw_parent_flow_id == null) {
                $article_details_edit_mode = true;
            }
            elseif ($article_privilages['author'] === true && $article_basics->aflw_status == 'a')
            {
                if ($article_basics->art_submitted_by == $this->current_user['user_id'] && (in_array($article_basics->jwf_stage_type, array(
                        'author_submission',
                        'resubmission')) || ( $article_basics->jwf_stage_type == 'revision' && $article_basics->jwf_article_editable === true ) || ( $article_basics->art_transfer_status == 'y')) && $article_basics->aflw_status != 'c')
                {
                    $article_details_edit_mode = true;
                }
            }
            $return_array['article_details_edit_mode'] = $article_details_edit_mode;
            }

            if($type =="basic" && $article_privilages['reviewer'] == false)
            {
                $suggest_oppose_reviewer_show = true;
                if (isset($article_details->jwf_id))
                {
                    $Article_flow_table = (new \App\Models\Article_flow)->getTable();
                    $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
                    $Roles_table = (new \App\Models\Roles)->getTable();

                    $sql = 'SELECT count(aflw_id) as cnt FROM ' . $Article_flow_table. ' aflw JOIN ' . $Generic_flows_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' . $Roles_table. ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role =:role_assigned_role AND jwf.jwf_id=:jwf_id  AND aflw.aflw_usr_id = :aflw_usr_id AND aflw_art_id =:aflw_art_id';
                    $condition_arr=array('role_assigned_role'=>'reviewer','jwf_id'=>$article_details->jwf_id,'aflw_usr_id'=>$this->current_user['user_id'],'aflw_art_id'=>$art_id);
                    $article_reviewer = Article_flow::get_records_by_raw_query($sql,false,$condition_arr);
                    if (isset($article_reviewer[0]->cnt) && $article_reviewer[0]->cnt > 0)
                    {
                        $suggest_oppose_reviewer_show = false;
                    }
                }

                
                //*end -- not show suggest/oppose reviewers who having reviewer role in review stage*//
                $return_array['suggest_oppose_reviewer_show'] = $suggest_oppose_reviewer_show;
                
            }
            else
            {
            $return_array['suggest_oppose_reviewer_show'] = false;
            }

            if($type == "basic") {
            $Journal_settings = new \App\Models\Journal_settings();
            $user_permission_roles = $Journal_settings::get_single_record('jset_add_article_to_issue,jset_blind_articles', "jset_jnl_id=:jnl_id",null,'',null,array('jnl_id'=>$platform_id));

            $assign_issue = false;
            if (isset($article_details) && ($article_details[0]->art_status =='y' || $article_details[0]->art_status =='n' || $article_details[0]->art_status =='a' || ($article_details[0]->art_status =='c' && ($article_basics->aflw_status == 'u'|| $article_basics->aflw_status == 'a'))) && isset($user_permission_roles->jset_add_article_to_issue)  && $user_permission_roles->jset_add_article_to_issue != null && count(array_intersect(json_decode($user_permission_roles->jset_add_article_to_issue), $user_roles['role_id'])) > 0) {
                $assign_issue = true;
            }
            $return_array['assign_issue'] = $assign_issue;

            $User_unregister = new \App\Models\User_unregister();
            $unregister_flag = false;
            $unregister_sub_user = $User_unregister::get_single_record("uur_request_status", "uur_usr_id=:submited and uur_request_status=:request",null,'',null,array('submited'=>$article_basics->art_submitted_by,'request'=>'y'));
            if (!empty($unregister_sub_user) && isset($unregister_sub_user->uur_request_status)) {
                $unregister_flag = true;
            }
            $return_array['unregister_flag'] = $unregister_flag;
            $edit_author_article_type = false;
            /* Task #444 View  Author and published article edit icon Shown */
            $author_stage_array = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright');
            if (isset($article_basics->aflw_status) && ($article_basics->aflw_status != 'c') && (isset($article_basics->jwf_stage_type) && (!in_array($article_basics->jwf_stage_type, $author_stage_array)))) {
                $edit_author_article_type = true;
            }
            $return_array['edit_author_article_type'] = $edit_author_article_type;
        }
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            // Task #925 atotp_research_integrity
            $article_type_advance =$Article_type_advance_options::get_single_record('atotp_classification,atotp_classification_title,atotp_review_method, atotp_custom_blind_params,atotp_user_input_keyword,atotp_separate_adhoc_keywords,atotp_ithsubmission_type,atotp_plagiarism_checking,atotp_artp_id,atotp_research_integrity,atotp_rvrisubmission_type,atotp_rvriauto_submissions',"atotp_artp_id=:atotp_artp_id",null,'',null,array('atotp_artp_id'=>$article_basics->art_artp_id));
            $return_array['article_type_advance'] = $article_type_advance;
            //* start view pdf*/
            if($type === "basic") {

                //ithenticate code
                $aflw_select='aflw_id,jwf_stage_name, jwf_status_name,jwf_stage_type, aflw_usr_id, jwf_enable_ithenticate,jwf_role_id,jwf_forms';
                $condition6 ="art_id ={$article_basics->art_id} AND jwf_stage_type='author_submission' ";
                $submission_stage_details = Article_flow::get_article_stage_data($aflw_select, $condition6, true);
              $ithenticate= $this->get_article_ithenticate_details($jnlcode,$article_details, $article_type_advance,$article_basics,$article_privilages,$submission_stage_details);
              $return_array['pdf_data'] = $ithenticate;
              // // Task #925 research integrity
              $return_array['rvri_data']= $this->get_article_rvri_details($art_id, $platform_id, $article_basics->aflw_id);
            
            $Article_pdf = new \App\Models\Article_pdf();
            $pdf_detail = $Article_pdf::get_single_record('pdf_id,pdf_art_attachement_order', "pdf_art_id=:art_id AND pdf_show_status=:status", null, '', 'pdf_id desc',array('art_id'=>$article_basics->art_id,'status'=>'y'));
            $link = '';  $view_pdf = false;
            if (!empty($pdf_detail)) {
                $attachmentfile_table = (new \App\Models\Attachment_files)->getTable();
                $attachment_file_description_table = (new \App\Models\Attachment_file_description)->getTable();
                $Attachment_files = new \App\Models\Attachment_files();
                $tables = array(
                    'main_table' => $attachmentfile_table,
                    'join_table' => array(
                        $attachment_file_description_table => array($attachment_file_description_table . '.afdec_id', $attachmentfile_table . '.atmnt_label', "join")
                    )
                );
                $condition = "afdec_exclude_file='n' AND atmnt_art_id={$article_basics->art_id} AND atmnt_designated_to like '%r%'";
                $get_review_status = $Attachment_files::get_results_using_joins($tables, "count(atmnt_id) as cnt", $condition, 'single');
                $pdf_review_cnd = 'atmnt_art_id = ' . $article_basics->art_id . ' AND SUBSTRING_INDEX(atmnt_file_name,".",-1) != "zip" AND afdec_exclude_file="n"';
                if ($get_review_status->cnt > 0) {
                    $pdf_review_cnd .= ' AND atmnt_designated_to like "%r%"';
                }
                $form_select = 'atmnt_id,atmnt_file_name';
                $all_review_files = $Attachment_files::get_results_using_joins($tables, $form_select, $pdf_review_cnd, 'all', "atmnt_order");
                $current_order = array();
                if (!empty($all_review_files)) {
                    $current_order = array_column(json_decode(json_encode($all_review_files), true), 'atmnt_id');
                }
                $generated_order = json_decode($pdf_detail->pdf_art_attachement_order);
                if (($generated_order == $current_order && ($article_basics->aflw_status != 'i' || ($article_basics->aflw_status == 'i' && $article_basics->aflw_usr_id != $this->current_user['user_id'])) )) {
                    $link = '/' . $this->current_client->platform_type . '/' . $jnlcode . '/' . $article_basics->artp_abbr_article_type . '/view-pdf/' . $this->encrypt_data($article_basics->art_id) . '/' . $this->encrypt_data($pdf_detail->pdf_id);
                    $view_pdf = true;
                }
            }
        }
            $User_articles = new \App\Models\User_articles();
            $User_articles_table = ($User_articles)->getTable();
            $Roles_table = (new \App\Models\Roles())->getTable();
            $join_tables_users = array(
                'main_table' => $User_articles_table,
                'join_table' => array(
                    $Roles_table => array($Roles_table . '.role_id', $User_articles_table . '.usra_role_id')
                )
            );
            $select_users = 'role_name,usra_usr_id,usra_art_id,role_id';
            $where_users = 'usra_art_id=:art_id';
            $article_users = $User_articles::get_results_using_joins($join_tables_users, $select_users, $where_users, 'all',null, null, '', null, null,false,null,false,array('art_id'=>$article->art_id));
            $assignedrole =array(); $user_array =array();$assigned_roleids=array();
            if (!empty($article_users)) {
                foreach ($article_users as $assigned_users) {
                    $array_data['user_id'] = $assigned_users->usra_usr_id;
                    $array_data['journal_id'] = $article->jnl_id;
                    $array_data['flag'] = true;
                    $array_data['article_id'] = $article->art_id;
                    $array_data['jnl_code'] = $jnlcode;
                    if(!in_array($assigned_users->role_name, $assignedrole, true)){
                        array_push($assignedrole, $assigned_users->role_name);
                        /*TASK #5287 Change the assignment label on the Basic Details page      */
                        array_push($assigned_roleids,$assigned_users->role_id);
                        /*TASK #5287 End      */
                    }
                    $user_array[$assigned_users->role_name][]=$this->get_user_display_name($array_data);
                }
            }
            /*TASK #5287 Change the assignment label on the Basic Details page      */
            $main_skip_array=array();
            $Article_flow_table = (new \App\Models\Article_flow)->getTable();
            $User_articles_table = (new \App\Models\User_articles)->getTable();
            $sql_skip_roles =' SELECT GROUP_CONCAT(`aflw_skip_assignment`) as skip_roles FROM '.$Article_flow_table.' WHERE aflw_art_id ='.$art_id.' AND aflw_skip_assignment NOT IN( SELECT `usra_role_id` FROM '.$User_articles_table.' WHERE `usra_art_id` ='.$art_id.')';
            //$skipped_roles=Article_flow::get_single_record_with_bind_cond('GROUP_CONCAT(`aflw_skip_assignment`) as skip_roles',array("aflw_art_id"=>$art_id));
            $skipped_role_rslt = Article_flow::get_records_by_raw_query($sql_skip_roles);
            $skipped_roles = $skipped_role_rslt[0];
            if(isset($skipped_roles->skip_roles)&&$skipped_roles->skip_roles!='')
            {
            $skip_role_array=explode(',',$skipped_roles->skip_roles);

              if(!empty($skip_role_array))
              {
                 foreach($skip_role_array as $role)
                 {
                  if(!in_array($role,$main_skip_array, true)&&!in_array($role,$assigned_roleids, true))
                  {

                    array_push($main_skip_array,(int)$role);

                   }
                }
              }
            }
              /* End  TASK #5287  */

            if($type == "basic") {
            //article classification
            $article_classification = array();
            $condition ="arcls_art_id =:art_id";
            $checkBoxData = Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,null,'',null,array('art_id'=>$article->art_id));
            if(!empty($checkBoxData->checkData)){
                $article_classification = json_decode(json_encode(explode(',', $checkBoxData->checkData)));
            }
            $Article_types = new \App\Models\Article_types();
            $all_article_types = $Article_types::get_all_records('artp_id,artp_article_type', 'artp_jnl_id='.$article->jnl_id);

            //#4543 Manage author data listing (normalization)
            $Authors = new \App\Models\Authors();
            $Authors_table = (new \App\Models\Authors())->getTable();
            $User_table = (new \App\Models\User())->getTable();
            $join_tables = array(
                'main_table' => $Authors_table,
                'join_table' => array(
                    $User_table => array($User_table . '.usr_id', $Authors_table . '.auth_usr_id')
                )
            );
			$select_fields ='DISTINCT(auth_usr_id),concat(usr_first_name,\' \',	usr_last_name) as author_name';
			$criteria = 'auth_art_id='.$art_id;
			$order_by = 'author_name';
			$author_list_dtls = $Authors::get_results_using_joins($join_tables, $select_fields, $criteria, $order_by);
			if (!empty($author_list_dtls))
			{
				foreach ($author_list_dtls as $authors)
				{
                    $condition = "uur_request_status = "."'y'";
                    $condition = $condition." AND uur_usr_id = ".$authors->auth_usr_id;
                    $User_unregister = new \App\Models\User_unregister();
					$unregister_user = $User_unregister->get_single_record("*", $condition);
					if (empty($unregister_user))
					{
						$authors->unreg_flag = false;
					}
					else
					{
						$authors->unreg_flag = true;
					}
				}
			}
        }
            $show_author_details = true;
            if (($article_type_advance->atotp_review_method == 'd' && $article_privilages['reviewer'] == true) || $this->is_custom_blinded('author', $art_id ,jnl:$jnlcode))
            {
                $show_author_details = false;
                $article->submitted_user ='';
                $article->corresponding_user='';
            }
            $return_array['show_author_details'] = $show_author_details;
            #1971 Allow to add article from any stage by privilaged users
            if($type == "basic") {
            $issue_mng_data = $this->get_all_issue_mng_data_by_article_id($art_id, $platform_data->jnl_id, $role_id, $article->art_artp_id);
            //User info original value true.
            $select = "jp_blind_articles";
            $condition = "artp_id={$article->art_artp_id}";
            $articleTypeAdvance = $this->get_article_type_permission($select, $condition);
            $allowBlindRoles = json_decode($articleTypeAdvance->jp_blind_articles);
            $articleBlindPermission = false;
            if ($article_basics->art_status !='n' && !empty($allowBlindRoles) && in_array($role_id, $allowBlindRoles)) {
                $articleBlindPermission = true;
            }
            //Disclosure Permission 
            $disclosurepermission = false;
            if (isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y'){
                $select = "jp_view_disclosures";
                $condition = "artp_id={$article->art_artp_id}";
                $articleTypeAdvance = $this->get_article_type_permission($select, $condition);
                $allowDisclosure = json_decode($articleTypeAdvance->jp_view_disclosures);
                if ($article_basics->art_status !='n' && (!empty($allowDisclosure) && in_array($role_id, $allowDisclosure)||($article_privilages['author'] === true))) {
                    $disclosurepermission = true;
                }
            }
            //Disclosure permission ends
		    $return_array['disclosurepermission'] = $disclosurepermission;
		    $return_array['articleBlindPermission'] = $articleBlindPermission;
		    $return_array['blinded_usr_details'] = $this->get_blinded_users($jnlcode, $art_id,true);
            $return_array['issue_mng_data'] = $issue_mng_data;
			$return_array['author_list'] = $author_list_dtls;
            $return_array['all_article_types'] = $all_article_types;
            $author_permission = false;
            if($article_privilages['author'] == true)
            {
                if($return_array['currentstatus']['result_art_status'] && ($return_array['currentstatus']['result_art_status'][0]->jwf_stage_type == 'revision' || ($return_array['currentstatus']['result_art_status'][0]->jwf_stage_type == 'resubmission' && $return_array['article_details'][0]->aflw_status == 'a')))
                {
                    $author_permission = true;
                }
                if($return_array['currentstatus']['status'] == 'Transfer')
                {
                    $author_permission = true;
                }
                $esarray['article_id']=$art_id;
                $checkdata=$this->check_espermission_access($esarray);
                //if($article_basics->art_es_document_status == 'y' && $this->current_client->modules->mdl_es_integration == 'y' && $article_basics->art_status == 'n')
                if($checkdata==true && $article_basics->art_es_document_status == 'y' && $article_basics->art_status == 'n')
                {
                    $author_permission = true;
                }
            }
            $return_array['author_permission'] = $author_permission;
            }

           /*TASK #5287 Change the assignment label on the Basic Details page      */
            $return_array['skippedrole'] = $main_skip_array;
            $return_array['shortlistrole_ids']=$assigned_roleids;
            /*End TASK #5287  */
            $return_array['assignedrole'] = $assignedrole;
            $return_array['assigned_userdetails'] = $user_array;
            $show_assigned_users=$this->current_client->functionality->cfty_show_assigned_users;
            if(($show_assigned_users == true && ($article_privilages['reviewer'] == true || $article_privilages['author'] ==  true)) || $typedata == "manageproduction")
            {
                $show_assigned_users =false;
            }
            $return_array['show_assigned_users'] = $show_assigned_users;
            if($type == "basic") {
            $return_array['view_pdf'] = $view_pdf;
            $return_array['view_pdf_link'] = $link;
            $return_array['article_keywords'] = $article_keywords;
            $return_array['article_classification'] = $article_classification;
            $return_array['is_privilaged'] = $article_privilages['privilaged'];
            }

            if (isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y') {
                $has_convey = ConveyData::where('rcd_art_id', $art_id)->get(['rcd_id'])->count();
                if ($has_convey) {
                    $return_array['article_details'][0]->has_convey = true;
                } else {
                    $return_array['article_details'][0]->has_convey = false;
                }
            }
            //echo '<pre>';print_r($return_array);exit;
           return  $this->success('Success', 200, $return_array);
            }
        } catch (\Exception $e) {


            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** used for displaying header and basic details end  ***/
    public function customform_all_attachment(Request $request)
    {
        try {
            $customform_attachments = array();
            $return = array();
            $post_data = $request->all();
            $article_id = isset($post_data['art_id']) ? decrypt_link($post_data['art_id']) : '';
            $jnl_code = isset($post_data['jnl_code']) ? $post_data['jnl_code'] : '';
            $core_role = isset($post_data['core_role']) ? $post_data['core_role'] : '';
            $role_id = isset($post_data['role_id']) ? $post_data['role_id'] : ''; // Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
            $showflag=false;
            $element_viewstatus=FALSE;			// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
            $user_access = FALSE;		// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
            // TASK #7033 SQL injection customformallattachment
            if(isset($post_data['art_id']) && !empty( $post_data['art_id'])){
                $artidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>true );
                $artidvalidation= $this->Rv_validator($artidarray);
                if($artidvalidation != true){
                    return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
                }
            }
            // end TASK #7033 SQL injection customformallattachment
            if (isset($this->current_client->functionality->cfty_others_attachment_all_customform) && $this->current_client->functionality->cfty_others_attachment_all_customform == 'y')
            {
                if(!empty($article_id) && !empty($jnl_code))
                {
                $platform_data = $this->platform_basic_settings_data($jnl_code);
                $jnl_id = $platform_data->jnl_id;
                $date_format = $this->get_platform_date_format($jnl_id);
                $date_format = date_format_map($date_format);
                $date_format = $date_format.' %H:%i:%s';
                $review_method='';
                $select = 'art_code,art_title,art_abstract,art_artp_id,art_article_upload_path';
		        $get_article_details = Articles::get_single_record($select,"art_id={$article_id}");
                if(!empty($get_article_details))
                {
                $Article_types = new \App\Models\Article_type_advance_options();
                $article_type_data=$Article_types::get_single_record('atotp_review_method',"atotp_artp_id=:atotp_artp_id",null,'',null, array("atotp_artp_id"=>$get_article_details->art_artp_id));
                    if(!empty($article_type_data))
                    {
                        $review_method= $article_type_data->atotp_review_method;
                    }
                }
                $Stage_email_templates= new \App\Models\Stage_email_templates();
                $Generic_form_files = new \App\Models\Generic_form_files;
                $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
                $Article_flow_table = (new \App\Models\Article_flow)->getTable();
                $user_table = (new \App\Models\User())->getTable();
                $Generic_form_files_table = (new \App\Models\Generic_form_files())->getTable();
                $tables = array(
                    'main_table' => $Generic_flows_table,
                    'join_table' => array(
                        $Article_flow_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id',"inner")
                        )
                );
                $select = 'DISTINCT(aflw_jwf_id) as aflw_jwf_id,jwf_stage_name,jwf_stage_type,jwf_role_id';
                $where = 'aflw_art_id=' .$article_id . ' AND aflw_usr_id IS NOT null AND jwf_stage_type!=\'author_submission\' AND jwf_stage_type!=\'resubmission\' ';
                $journal_wfids = Generic_flows::get_results_using_joins($tables, $select, $where);
                if (!empty($journal_wfids))
                    {
                        foreach ($journal_wfids as $jwf)
                        {
                            $stage_form_result = $Stage_email_templates::get_generic_form_data_files_allcustoms($article_id, $jnl_code,$jwf->aflw_jwf_id);
                            if (!empty($stage_form_result))
                            {
                                foreach ($stage_form_result as $stg)
                                {
                                    // Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
                                    if($stg->gdata_element_type=='file')
                                    {   
                                        $element_viewstatus=FALSE;
                                        $condition = "art_id=:mainart_id";
                                        $condition_arr = array(
                                            'mainart_id' => $article_id
                                        );
                                        $article_data = Articles::get_article_details('artp_jpm_id,artp_id,art_version_no,art_id,artp_fwm_id,art_status,aflw_parent_flow_id,jwf_stage_type,art_code,art_delete_status,aflw_status', $condition, null, true, false, null, $condition_arr);
                                        $article_data = $article_data[0];
                                        $article_privilages = $this->article_privilages($article_data, null, $jnl_code);
                                        if ($article_privilages['privilaged'] == TRUE)
                                        {		$user_access =TRUE;
                                            if (isset($article_privilages['author'])&& $article_privilages['author'] == TRUE) {
                                                $user_access = FALSE;
                                            }                    
                                        }
                                        $emt_viewable_rls = explode(',', $stg->gdata_user_roles);
                                        if(in_array($role_id, $emt_viewable_rls)||(empty($stg->gdata_user_roles)&&$user_access==TRUE)) {
                                            $element_viewstatus=TRUE;                                          
                                        }
                                    if($stg->gdata_dynamic_status=='y')
                                    {
                                        $temp_arr = json_decode($stg->gdata_data);
                                        $commaSeparatedValues = '';
                                        // Iterate through the array and concatenate values with commas
                                        foreach ($temp_arr as $subArray) {
                                            $commaSeparatedValues .= implode(',', $subArray) . ',';
                                        }
                                        $commaSeparatedValues = rtrim($commaSeparatedValues, ',');
                                        // Print the comma-separated values
                                        $file_ids=$commaSeparatedValues;

                                    }else{
                                    $file_ids = ($stg->gdata_data != "") ? join(",", array_filter(json_decode($stg->gdata_data))) : '';
                                    }
                                    if ($file_ids != "" && isset($get_article_details->art_article_upload_path))
								    {
                                        $selectdata = 'agf_name,agf_id,agf_file_size,agf_label,DATE_FORMAT(agf_file_uploaded_date, "' . $date_format . '") as agf_file_uploaded_date,CONCAT(usr_first_name," ",usr_last_name) as posted_user,usr_id';
                                        $wherecondition = 'agf_id in (' . $file_ids . ') ';
                                        $tablesdata = array(
                                            'main_table' => $Generic_form_files_table,
                                            'join_table' => array(
                                                $user_table => array($user_table . '.usr_id', $Generic_form_files_table . '.agf_posted_by',"inner")
                                                )
                                        );
                                        $file_details = $Generic_form_files::get_results_using_joins($tablesdata, $selectdata, $wherecondition, 'all');
                                        if (!empty($file_details))
									    {
                                            foreach ($file_details as $ft)
                                            {
                                            $customform_attachments[$ft->agf_id]['document_size'] = $ft->agf_file_size;
											$customform_attachments[$ft->agf_id]['atmnt_file_name'] = $ft->agf_name;
											$customform_attachments[$ft->agf_id]['path'] = 'uploads/' . $get_article_details->art_article_upload_path . '/' . $ft->agf_name;
											$customform_attachments[$ft->agf_id]['atmnt_id'] = $ft->agf_id;
											$customform_attachments[$ft->agf_id]['art_id'] = $article_id;
											$customform_attachments[$ft->agf_id]['jnl_code'] = $jnl_code;
                                            $customform_attachments[$ft->agf_id]['posted_user'] = $ft->posted_user;
                                            if(!empty($review_method))
                                            {
                                                if(($review_method=='s' || $review_method=='d') && $core_role=='author' && isset($jwf->jwf_stage_type) && $jwf->jwf_stage_type=='review')
                                                {
                                                    if(isset($jwf->jwf_role_id) && !empty($jwf->jwf_role_id))
                                                    {
                                                    $name = Roles::find($jwf->jwf_role_id, ['role_name'])?->role_name;
                                                    }else{ $name='';}
                                                    $customform_attachments[$ft->agf_id]['posted_user'] = $name;
                                                }
                                                if($review_method=='c')
                                                {
                                                    $is_blinded = $this->is_custom_blinded($jwf->jwf_role_id,$article_id,artp:$get_article_details->art_artp_id,jnl:$jnl_code, blinded_user:$ft->usr_id);
                                                     if($is_blinded){
                                                        $customform_attachments[$ft->agf_id]['posted_user'] =$is_blinded;
                                                     }
                                                }
                                            }
                                            $customform_attachments[$ft->agf_id]['jwf_stage_name'] = $jwf->jwf_stage_name;
                                            $customform_attachments[$ft->agf_id]['custom_filedescription'] = $ft->agf_label;
                                            $customform_attachments[$ft->agf_id]['agf_file_uploaded_date'] = $ft->agf_file_uploaded_date;
                                            $showflag=true;
                                            }

                                        }
                                    }
                                }
                                }

                            }

                        }

                    }
                }
            }
            $return['showflag'] =$showflag;
            $return['element_viewstatus'] =$element_viewstatus;  // Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
            $return['othercustomform_attachments'] =$customform_attachments;
            return $this->success("success",200, $return );

        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_article_ithenticate_details($jnlcode,$article_details, $article_type_advance,$article_basics, $privillaged_user,$submission_stage_details = null,$showpdf_icon = true)
    {
        try {
            $pdf_file = array();
            $article_id=$article_basics->art_id;
            $jnlid=$article_basics->jnl_id;
           
            $ithenticate_component=false;
           $jnlcode=$jnlcode;
            $date_format = $this->get_platform_date_format($jnlid);
            $ith_v2 = false;
            $sid = null;
            $currentUser = $this->get_current_user_details();
            $ith_api_condition = array(
                'acrd_clnt_id' => $this->current_client->clnt_id,
                'acrd_api_name' => 'ithenticate',
                'acrd_artp_id' => $article_type_advance->atotp_artp_id,
                'acrd_jnl_id' => $article_basics->jnl_id
            );
            if ($article_type_advance->atotp_plagiarism_checking == 'y')
            {
                if (isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
                {
                    $ith_v2 = true;
                }
                
               $sid = $this->login_ithenticate($ith_api_condition);
            }
            $condition_status = "art_id={$article_id} and (aflw_status= 'a' or aflw_status= 'u') and aflw_parent_flow_id IS null";
            $parameter_head_array['select']= 'jwf_stage_name, jwf_status_name,jwf_stage_type, aflw_usr_id, jwf_enable_ithenticate, atotp_plagiarism_checking,jwf_role_id';
            $parameter_head_array['condition']=$condition_status;
            $article_current_status_check = Article_flow::get_articles_and_status($parameter_head_array);
            $user_roles = $this->validate_user_journal($article_basics->jnl_journal_code, $currentUser['user_id'], $article_basics->art_artp_id);
            $assigned_roles = $user_roles['role_id'];
            $itheulaFlag = false;
            $Article_pdf = new \App\Models\Article_pdf();
            // $pdf_detail = $Article_pdf::get_single_record('*', "pdf_art_id={$article_basics->art_id} AND pdf_show_status='y'", null, '', 'pdf_id desc');
            $article_pdf_table = (new \App\Models\Article_pdf)->getTable();
            $ithenticate_auto_submit_table = (new \App\Models\Ithenticate_autosubmission)->getTable();
            if($article_type_advance->atotp_ithsubmission_type == 'auto' && isset($article_current_status_check[0]->jwf_enable_ithenticate) && $article_current_status_check[0]->jwf_enable_ithenticate=='n')
            {
                $query2 = "SELECT max(ias_id) from ".$article_pdf_table." join ".$ithenticate_auto_submit_table." on pdf_id = ias_pdf_id where pdf_art_id = ".$article_basics->art_id;

                $query1 = "SELECT * from ".$article_pdf_table." join ".$ithenticate_auto_submit_table." on pdf_id = ias_pdf_id where pdf_art_id = ".$article_basics->art_id."   AND ias_id = ({$query2})" ;
               $tempdata = $Article_pdf::get_records_by_raw_query($query1);

                $pdf_detail =  isset($tempdata[0]) ? $tempdata[0] : array();
            }
            else
            {
            $pdf_detail = $Article_pdf::get_single_record('*', "pdf_art_id={$article_basics->art_id} AND pdf_show_status='y'", null, '', 'pdf_id desc');
            }

            if (!empty($pdf_detail) && $article_type_advance->atotp_plagiarism_checking == 'y')
			{
                $Article_pdf_table = (new \App\Models\Article_pdf)->getTable();
                $articleflow_table = (new \App\Models\Article_flow)->getTable();
                $genericflow_table = (new \App\Models\Generic_flows)->getTable();
                $User_table = (new \App\Models\User)->getTable();
                $tables = array(
					'main_table' => $Article_pdf_table,
					'join_table' => array(
                        $User_table => array($Article_pdf_table . '.pdf_posted_by', $User_table . '.usr_id'),
                        $articleflow_table => array('pdf_aflw_id', 'aflw_id'),
                        $genericflow_table => array('aflw_jwf_id', 'jwf_id'),
				));

                $select_fields ='CONCAT(usr_first_name, IF(usr_middle_name IS null or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as first_name , pdf_ith_submission_status';
                $criteria = "pdf_art_id ={$article_id} AND pdf_show_status = 'y' AND  pdf_ith_document_id IS null AND jwf_stage_type NOT IN ('author_submission','revision','resubmission') ";
                $itenticatedetails =  $Article_pdf::get_results_using_joins($tables,$select_fields,$criteria,'single','pdf_posted_date DESC,pdf_id DESC');
                $pdf_file = array(
					'pdf_id' => $pdf_detail->pdf_id);

                $pdf_file['idetifier_html']= '';
                $pdf_file['ith_version_change'] = false;
                $pdf_file['pdf_ith_submission_status'] = isset($itenticatedetails->pdf_ith_submission_status)?$itenticatedetails->pdf_ith_submission_status:'';
                $pdf_file['ithenticate_enabled'] = false;
                $acrd_eula = null;
                $credential = array();
                if($this->current_client->modules->mdl_ithenticate == 'y'){
                    $credential = $this->get_credentials($ith_api_condition);
                    
                    if(isset($credential['details']['acrd_eula']))
                    {
                        if($credential['details']['acrd_eula'] == null)
                        {
                            $acrd_eula = $this->setEULA($credential,true,$credential['details']['acrd_id']);
                        }
                        else
                        {
                            $acrd_eula = $credential['details']['acrd_eula'];
                        }
                    }
                }
                
                if ($privillaged_user['privilaged'] === true && $this->current_client->modules->mdl_ithenticate == 'y')
                {

                    $condition_status = "art_id={$article_id} and (aflw_status= 'a' or aflw_status= 'u') and aflw_parent_flow_id IS null";
                    $parameter_head_array['select']= 'jwf_stage_name, jwf_status_name,jwf_stage_type, aflw_usr_id, jwf_enable_ithenticate, atotp_plagiarism_checking,jwf_role_id';
					$parameter_head_array['condition']=$condition_status;
                    $article_current_status = Article_flow::get_articles_and_status($parameter_head_array);
                    if ($article_type_advance->atotp_ithsubmission_type == 'manual' && isset($article_current_status[0]->jwf_enable_ithenticate) && $article_current_status[0]->jwf_enable_ithenticate == 'y')
					{
                        $ithenticate_component=true;
                        $pdf_file['ithenticate_enabled'] = true;
					}
                    if (!empty($pdf_detail->pdf_ith_document_id))
					{
                        $ithenticate_component=true;
                        if ($article_type_advance->atotp_plagiarism_checking == 'y')
						{
                            if (empty($pdf_detail->pdf_ith_view_only_url) && !empty($pdf_detail->pdf_ith_document_id))
							{
                                $similarity_report = $this->similarity_report($pdf_detail->pdf_ith_document_id, $sid, $ith_api_condition,$article_type_advance->atotp_artp_id);
                                if (isset($similarity_report['is_pending']) && $similarity_report['is_pending'] == true)
								{
									$pdf_file['submit_to_ithenticate'] = false;
								}else
								{
									$pdf_file['ith_view_url'] = $similarity_report['view_only_url'];
									$pdf_file['ith_percent_match'] = $similarity_report['percent_match'];
									$pdf_file['words'] = $similarity_report['words'];
									$pdf_file['pdf_ith_report_date'] = $similarity_report['response_timestamp'];
                                    $pdf_file['pdf_ith_sub_date']	=	' as on '.date($date_format. ' h:i:s A', strtotime($pdf_file['pdf_ith_report_date']));
                                    $pdf_file['url'] =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnlcode . '/show-similarity-report/' . $this->encrypt_data($pdf_detail->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($jnlid);
								}

                            }elseif (!empty($pdf_detail->pdf_ith_view_only_url) && !empty($pdf_detail->pdf_ith_document_id))
                            {
                                if (isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y' && $pdf_detail->pdf_ith_version == 'v1')
                                {
                                    $pdf_file['ith_version_change'] = true;
                                }
                                
                                $pdf_file['ith_view_url'] = $pdf_detail->pdf_ith_view_only_url;
								$pdf_file['ith_percent_match'] = $pdf_detail->pdf_ith_similarity_percentage;
								$pdf_file['words'] = $pdf_detail->pdf_word_count;
								$pdf_file['pdf_ith_report_date'] = $pdf_detail->pdf_ith_report_date;
                                $pdf_file['pdf_ith_sub_date']	=	' as on '.date($date_format. ' h:i:s A', strtotime($pdf_file['pdf_ith_report_date']));
                                $pdf_file['url'] =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnlcode . '/show-similarity-report/' . $this->encrypt_data($pdf_detail->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($jnlid);
                            }


                            $generic_forms_table = (new \App\Models\Generic_forms)->getTable();
                            $generic_form_elements_table = (new \App\Models\Generic_form_elements)->getTable();
                            $auth_tables_identifier = array(
                            'main_table' => 'rvw_article_gnf_form_data_' . $jnlcode,
                            'join_table' => array(
                            $generic_forms_table => array( $generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id'),
                            $generic_form_elements_table => array($generic_form_elements_table.'.emt_gucf_id',$generic_forms_table.'.gncf_id')
                            ));

                                $where_cond = "gdata_art_id ={$article_id} AND gncf_form_type='author_submission' and gdata_unique_identifier IS NOT null  AND emt_identifier_type IS NOT null AND emt_identifier_type!='custom' AND emt_identifier_type !='' AND gdata_unique_identifier='PRE_PRINT_IDENTIFIER' ";
                                $unique_identifier = Article_generic_form_data::get_results_using_joins($auth_tables_identifier,  'gdata_data,gdata_display_data', $where_cond,'all');
                                $identifier_flag=false;
                                if (isset($unique_identifier) && !empty($unique_identifier))
                                    {
                                        foreach($unique_identifier as $identifier)
                                            {
                                                if(!empty($identifier->gdata_data) && isset($identifier->gdata_data) && $identifier->gdata_data=='y')
                                                    {
                                                        $identifier_flag=true;

                                                    }
                                            }
                                    }
                                $count_html='';
                                if($identifier_flag==true)
                                {
                                    $count_html.= '<div id="identifier_id_new" class="alert-idetification-message">'.customTrans('ithenticate.system_identification').'</div>';
                                    $count_html.= '<div id="identifier_id" class="alert-idetification-message remark">'.customTrans('ithenticate.system_identification_remark').'</div>';

                                }
                            $pdf_file['idetifier_html']=$count_html;

                        }
                    }elseif ($article_type_advance->atotp_ithsubmission_type == 'auto' || (isset($pdf_detail->pdf_ith_submission_status) && $pdf_detail->pdf_ith_submission_status == 'i'))
					{
                        //Task 7850 ith_v2  Request retry  (pdf_ith_submission_status = i)
                        $ithenticate_auto_submit_table = (new \App\Models\Ithenticate_autosubmission)->getTable();
                        $article_pdf_table = (new \App\Models\Article_pdf)->getTable();
                                $ith_auto_submit_sql = "
                        SELECT `ias_status`, `ias_retry_count`, `pdf_ith_submission_status`, `pdf_ith_submission_message`
                        FROM {$ithenticate_auto_submit_table}
                        LEFT JOIN {$article_pdf_table} ON `pdf_id` = `ias_pdf_id`
                        WHERE `ias_pdf_id` IN (
                            SELECT `pdf_id`
                            FROM {$article_pdf_table}
                            WHERE `pdf_art_id` = {$article_id} AND ias_pdf_id={$pdf_detail->pdf_id}
                        )";
                        $ith_auto_submission = Ithenticate_autosubmission::get_records_by_raw_query($ith_auto_submit_sql);
                        if (!empty($ith_auto_submission))
						{
                            $ithenticate_component=true;
                            $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
                            $ithenticateconfig  = Config::get($ithenticate_config);
                            $pdf_file['submit_to_ithenticate'] = false;
                            if ($ith_auto_submission[0]->ias_status == 'm' || ($ith_auto_submission[0]->ias_status == 'n' && $ith_auto_submission[0]->ias_retry_count >= $ithenticateconfig['retry_submission_limit']))
							{
                                // If auto submission satatus failed
								if ($ith_auto_submission[0]->pdf_ith_submission_status == 'F' || $ith_auto_submission[0]->pdf_ith_submission_status == 'i' || $ith_auto_submission[0]->ias_status == 'm')
								{
									// Load appropritate functions for manual ithenticate
									$pdf_file['ithenticate_enabled'] = true;

									// Show manual ithenticate link
									$pdf_file['submit_to_ithenticate'] = true;

									// Show auto ithenticate failure reason
									$pdf_file['auto_submission_failed_reason'] = $ith_auto_submission[0]->pdf_ith_submission_message;
								}

                            }
                            elseif($article_type_advance->atotp_plagiarism_checking == 'y' && $ith_auto_submission[0]->ias_status != 'n')
                            {
                                $select = 'count(pdf_id) as cnt';
                                $tables = array(
                                    'main_table' => $Article_pdf_table,
                                    'join_table' => array(
                                        $articleflow_table => array('pdf_aflw_id', 'aflw_id'),
                                        $genericflow_table => array('aflw_jwf_id', 'jwf_id'),
                                ));
                
                                $criteria = "pdf_art_id ={$article_id} AND pdf_id= {$pdf_detail->pdf_id} AND pdf_show_status = 'y' AND  pdf_ith_document_id IS null AND jwf_stage_type NOT IN ('author_submission','revision','resubmission')  AND pdf_ith_submission_status != 'i'";
                                //DB::enableQueryLog();
                                $active_ithenticate =  $Article_pdf::get_results_using_joins($tables,$select,$criteria,'single');
                                if($active_ithenticate->cnt > 0)
                                {
                                    $ithenticate_component=true;
                                    $pdf_file['submit_to_ithenticate'] = true;
                                }
                            }
                        }
                        if (isset($article_current_status[0]->jwf_enable_ithenticate) && $article_current_status[0]->jwf_enable_ithenticate == 'y' && isset($article_current_status[0]->jwf_role_id) && (in_array($article_current_status[0]->jwf_role_id,$assigned_roles )))
						{
							$pdf_file['submit_to_ithenticate'] = true;
                            $ithenticate_component=true;
						}

                    }elseif ($article_type_advance->atotp_ithsubmission_type == 'manual')
					{
                        if (isset($article_current_status[0]->jwf_enable_ithenticate) && $article_current_status[0]->jwf_enable_ithenticate == 'y')
						{
							$pdf_file['submit_to_ithenticate'] = true;
						}
                        
					}/*elseif ($article_type_advance->atotp_ithsubmission_type == 'manual' && isset($submission_stage_details->jwf_enable_ithenticate) && $submission_stage_details->jwf_enable_ithenticate == 'y')
					{
						$pdf_file['submit_to_ithenticate'] = true;
					}*/
                    
                    //Task 7850  iThenticate v2 enhancement
                    //$pdf_file['eulatnc'] = '';
                    
                    if($ith_v2 == true && $acrd_eula == 'y' && ((isset($pdf_file['submit_to_ithenticate']) && $pdf_file['submit_to_ithenticate'] == true) || $pdf_detail->pdf_ith_version == 'v1')) 
                    {
                        $ithenticate_component=true;
                        $itheulaFlag = true;
                    }
                }
                elseif($this->current_client->modules->mdl_ithenticate == 'y' && $ith_v2 === true  &&  $article_type_advance->atotp_ithsubmission_type == 'auto' &&  $acrd_eula == 'y' && $pdf_detail->pdf_ith_version == 'v1' && $privillaged_user['author'] === true && isset($article_details[0]->art_submitted_by) && $article_details[0]->art_submitted_by == $currentUser['user_id'] )
                {
                    $ithenticate_component=true;
                    $itheulaFlag = true;
                }
                if(isset($itenticatedetails) && ($itenticatedetails->pdf_ith_submission_status==null) && !empty($itenticatedetails->first_name))
                {
                    $pdf_file['resend_to_iThenticate'] = customTrans('ithenticate.resend_to_iThenticate_msg1').' '.$itenticatedetails->first_name.customTrans('ithenticate.resend_to_iThenticate_msg2');
                }
                else
                {
                    //$pdf_file['resend_to_iThenticate'] = customTrans('ithenticate.resend_to_iThenticate');
                }
                $pdf_file['submission_type'] = $article_type_advance->atotp_ithsubmission_type;
                $recent_pdf_id = $pdf_file['pdf_id'];

            }
            $recent_pdf_id = '';

            if (!empty($pdf_file))
             {
            //Task 7850  iThenticate v2 enhancement
            $pdf_file['eulatnc'] = '';
            if($itheulaFlag === true && $sid != null)
            {
                $ithv2_url = null;
                //$credential = $this->get_credentials($ith_api_condition);
                if(isset($credential['username']))
                {
                    $ithv2_url = $credential['username'];
                }

                $pdf_file['eulatnc'] = $this->geteulaTNC($ithv2_url,$sid,$currentUser['user_id']);
            }
            $recent_pdf_id = $pdf_file['pdf_id'];
            $condition_privious = "pdf_art_id={$article_basics->art_id} AND pdf_ith_document_id IS NOT null  AND pdf_ith_report_url IS NOT null AND pdf_ith_view_only_url IS NOT null AND pdf_ith_report_date is NOT null AND  pdf_id!={$recent_pdf_id}";

            }else{
                $condition_privious = "pdf_art_id={$article_basics->art_id} AND pdf_ith_document_id IS NOT null AND pdf_ith_report_url IS NOT null AND pdf_ith_view_only_url IS NOT null";
            }
            
            $previous_ithenticate_reports=array();
            $previours_record = Article_pdf::get_all_records('*', $condition_privious, 'pdf_id');
            if(!empty($previours_record) && count($previours_record) > 0)
            {
                $ithenticate_component=true;
                foreach ($previours_record as $prithen) {
                    $pr_url =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnlcode . '/show-similarity-report/' . $this->encrypt_data($prithen->pdf_id) . '/' . $this->encrypt_data($article_id). '/' . $this->encrypt_data($jnlid);
                    $previous_ithenticates = array(
                        'pdf_id' => $prithen->pdf_id,
                        'pdf_art_id' => $prithen->pdf_art_id,
                        'pdf_ith_document_id' =>$prithen->pdf_ith_document_id,
                        'pdf_ith_similarity_percentage' => $prithen->pdf_ith_similarity_percentage,
                        'pdf_word_count' => $prithen->pdf_word_count,
                        'pdf_ith_report_url' => $prithen->pdf_ith_report_url,
                        'pdf_ith_view_only_url' => $prithen->pdf_ith_view_only_url,
                        'pdf_ith_report_date' => $prithen->pdf_ith_report_date,
                        'pdf_ith_sub_date'	=>	' as on '.date($date_format. ' h:i:s A', strtotime($prithen->pdf_ith_report_date)),
                        'pr_url' =>$pr_url
                    );
                    $previous_ithenticates['ith_ver_change'] = false;
                    if($ith_v2 == true && $prithen->pdf_ith_version == 'v1' && !empty($prithen->pdf_ith_report_url))
                    {
                        $previous_ithenticates['ith_ver_change'] = true;
                    }
                    array_push($previous_ithenticate_reports,$previous_ithenticates);
                }
            }
            $pdf_file['prev_ithenticate_reports'] = $previous_ithenticate_reports;
            $pdf_file['ithenticate_component'] = $ithenticate_component;
            return $pdf_file;

        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }

    }
    //*** used for displaying action buttons and stage assigned details starts  ***/
    public function get_action_buttons(Request $request)
    {
       try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnlcode' => 'required',
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ?  Rv_decrypt($post_data['art_flow_id']) : '';
            $platform_id = isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $role_id = isset($post_data['role_id']) ? Rv_decrypt($post_data['role_id']) : '';
            $version = isset($post_data['version']) ? $post_data['version'] : '';
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($platform_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $platform_id = $platform_data->jnl_id;
            }
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $date_format = static::date_format_map($platform_data->jset_date_format);
            $select_article_details = 'art_id,art_artp_id,art_code,art_title,art_abstract,art_resubmission_no,art_status,art_submission_date,art_doi,art_submitted_by,artp_article_type,art_published_article_type,art_article_upload_path,art_transfer_status,art_skipped_assignment_roles,art_delete_status,art_publication_issue,jwf_status_name,jwf_stage_name,jnl_journal_name,artp_fwm_id,art_stage_submission_method,auth_usr_id,aflw_id,jnl_id,jnl_journal_code,artp_id,jwf_assignment,aflw_parent_flow_id,aflw_status,aflw_usr_id,art_status,jwf_stage_type,aflw_id,jwf_who_can_invite,jwf_parent_user_roles,aflw_skip_review,aflw_reopened_min_user_count,jwf_fwm_id,jwf_stage_name,jwf_fwm_id,aflw_level,jwf_parent_stages,jwf_enable_transfer,jwf_role_id,aflw_jwf_id,jwf_connect_to_es,aflw_usr_id,jwf_flow_proceed_type,jwf_child_stages,artp_abbr_article_type,artp_jpm_id,jwf_article_editable,art_es_document_status,aflw_stage_min_users,artp_fwm_id,art_es_document_type';
            $group_by = 'aflw_id';

            $condition = "aflw_art_id=:art_id and jnl_id=:jnl_id and auth_corr_author=:authorstatus";
            $condition_arr=array(
                'art_id' => $art_id,
                'jnl_id'=>$platform_id,
                'authorstatus'=>'y'
            );
            if (!empty($art_flow_id)) {
                $condition .= " and aflw_id=:aflw_id";
                $condition_arr=array(
                    'art_id' => $art_id,
                    'jnl_id'=>$platform_id,
                    'authorstatus'=>'y',
                    'aflw_id'=>$art_flow_id
                );
            }
            $basicdata = Articles::get_article_details($select_article_details, $condition, null, true, true, $group_by, $condition_arr);
            $array_data = array();
            if (!empty($basicdata) && (isset($basicdata[0]) && !empty($basicdata[0]))) {

                $Journal_permission = new \App\Models\Journal_permission();
                $article_basic = $basicdata[0];
                $article_basics = json_decode(json_encode($article_basic), false);
                $article_privilages = $this->article_privilages($article_basics, $article_basics->aflw_id, $article_basics->jnl_journal_code);
                $array_data['article_data'] = $article_basics;
                $array_data['article_privilages'] = $article_privilages;
                $array_data['advanced_search'] = isset($post_data['advn']) ? $post_data['advn'] : false;
                $array_data['bulksubmission'] = isset($post_data['bulksubmission']) ? $post_data['bulksubmission'] : false;
                $all_user_roles = $this->validate_user_journal($article_basics->jnl_journal_code, $this->current_user['user_id'], $article_basics->art_artp_id);
                $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
                $user_array = array();
                $user_array['user_roles'] = $all_user_roles;
                $user_array['article_id'] = $art_id;
                $user_array['all_roles'] = $all_roles;
                $user_array['article_privilages'] = $article_privilages;
                $user_array['jnl_id'] = $platform_id;
                $user_array['user_id'] = $this->current_user['user_id'];
                $user_roles = $this->get_article_user_roles($user_array);
                $array_data['user_roles'] = $user_roles;
                if($version == "current")
                {
                $check_user_permission =$this->checkuserhaspermission($article_privilages,$user_roles,$article_basics,$this->current_user['user_id'],$platform_id,$jnlcode);

                if($check_user_permission==false)
                {
                    return  $this->warning('Failed', 200, "permission_denied");
                }
                }
                //check review stage exist in this flow
                $Article_flow = new \App\Models\Article_flow;
                $Generic_flows = new \App\Models\Generic_flows;
                $sql = 'SELECT COUNT(aflw_id) AS cnt FROM ' . $Article_flow->getTable() . ' left join ' . $Generic_flows->getTable() . ' on aflw_jwf_id=jwf_id WHERE jwf_assignment = :assign AND aflw_art_id = :art_id';
                $reviewexist = Article_flow::get_records_by_raw_query($sql,false,array('assign'=>'invitation','art_id'=>$art_id));
                $array_data['review_exists'] = false;
                if (count($reviewexist)>0) {
                    $array_data['review_exists'] = true;
                }
                 // Task #925 jp_view_research_integrity_report
                $select = "jp_edit_articles,jp_reset_article,jp_rescind_article,jp_transfer_article,jp_change_usr_assigmnts,jp_download_review,jp_prevent_edit,jp_request_rescind,jp_edit_article_files,jp_view_research_integrity_report";
                $option_settings = $Journal_permission::get_single_record($select, 'jp_jpm_id=:jpm_id',null,'',null,array('jpm_id'=>$article_basics->artp_jpm_id));
                $array_data['article_type_advance'] = $option_settings;
                $condition = 'role_id=:roleid';
                $stage_role = Roles::get_single_record('role_id,role_name,role_assigned_role', $condition,null,'',null,array('roleid'=>$article_basics->jwf_role_id));
                $array_data['stage_role'] = $stage_role;
                $return_array['article_basic'] = $article_basic;
                $criteriauser="usra_art_id=:usra_art_id and usra_role_id=:usra_role_id";
                $criteriaarr= array(
                    'usra_art_id' => $art_id,
                    'usra_role_id' => $role_id
                );
                $User_articles = new \App\Models\User_articles();
                $user_assigned = $User_articles::get_all_records('usra_usr_id',$criteriauser, null, null,'',null,null,'ASC',$criteriaarr);
                $criteriaartp="usrj_usr_id=:usrj_usr_id and usrj_artp_id=:usrj_artp_id and usrj_role_id=:usrj_role_id";
                $criteriaartparr= array(
                    'usrj_usr_id' => $this->current_user['user_id'],
                    'usrj_artp_id' => $article_basics->art_artp_id,
                    'usrj_role_id' => $role_id
                );
                $User_to_journals = new \App\Models\User_to_journals();
                $user_in_artp = $User_to_journals::get_single_record('usrj_usr_id',$criteriaartp,null,'',null,$criteriaartparr);
                $user_assigned_list = array();
                if (!empty($user_assigned))
                {
                    foreach ($user_assigned as $each_user_assigned)
                    {
                        $user_assigned_list[] = $each_user_assigned->usra_usr_id;
                    }
                }
                /* Article action buttons */
                if((!empty($user_assigned_list) && in_array($this->current_user['user_id'],$user_assigned_list)) || empty($user_assigned_list) && !empty($user_in_artp) || (!empty($article_basic->aflw_usr_id) && $article_basic->aflw_usr_id==$this->current_user['user_id']))
                {
                    $array_data['role_id'] = $role_id;
                    $return_array['action_buttons'] = $this->article_action_buttons($array_data);
                }
                else
                {
                    $return_array['action_buttons'] = array();
                }
                $auto_scroll = false;
                if (isset($this->current_client->functionality->cfty_view_article_autoscroll) && $this->current_client->functionality->cfty_view_article_autoscroll == 'y')
                {
                    $auto_scroll = true;
                }
                $check_es_article = $this->check_espermission_access(array('article_id' => $art_id));
                if($check_es_article == true)
                {
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
				    $es_api_data  = Config::get($es_config);
				    $return_array['es_url'] = $es_api_data['api_url'];
                }
                $return_array['view_art_autoscroll'] = $auto_scroll;
                if ($article_privilages['privilaged'] == true && $article_basics->aflw_status != 'u') {
                    $current_stage_detials = Article_flow::get_stage_details('aflw_id=:aflw_id', 'aflw_usr_id,aflw_accepted_date,aflw_status,DATE_FORMAT(aflw_accepted_date, "' . $date_format . ' ") as accepted_date,IF(aflw_status= "a" && jwf_stage_type != "author_submission",DATE_FORMAT(aflw_due_date,"' . $date_format . '"),null) as duedate_details, IF(aflw_status= "a" && now() > aflw_due_date && jwf_stage_type != "author_submission",CONCAT(\'(Overdue : \',DATEDIFF(now(),aflw_due_date),\' days)\'),null) as overdue',null, null,null, null,false,array(),array('aflw_id'=>$article_basics->aflw_id));
                    $current_activity = array();
                    if ($article_basics->aflw_usr_id != null && $current_stage_detials->aflw_status == 'a' && $article_privilages['author'] == false) {
                        $current_activity['user_role'] = $stage_role->role_name;
                        $array_data['user_id'] = $article_basics->aflw_usr_id;
                        $array_data['journal_id'] = $article_basics->jnl_id;
                        $array_data['flag'] = true;
                        $array_data['article_id'] = $article_basics->art_id;
                        $array_data['jnl_code'] = $article_basics->jnl_journal_code;
                        if ($current_stage_detials->duedate_details == str_replace('%', '', date($date_format, strtotime(date('d-m-Y'))))) {
                            $current_stage_detials->overdue = '';
                        }
                        $user_name = $this->get_user_display_name($array_data);
                        $current_activity['user_name'] = $user_name;
                        $current_activity['current_stage_detials'] = $current_stage_detials;
                        $return_array['user_details'] = $current_activity;
                    } elseif (in_array($current_stage_detials->aflw_status, array("p", "w"))) {
                        $assigning_roles = json_decode($article_basic->jwf_parent_user_roles);
                        $current_stage_detials->who_can_assign = '';
                        if ($assigning_roles != '') {
                            $current_stage_detials->who_can_assign = $this->get_users_in_role($art_id, $article_basic->artp_id, $assigning_roles, $article_basics->jnl_id, $article_basics->jnl_journal_code, true);
                        }

                        $current_stage_detials->who_can_invite = '';
                        if ($article_basic->jwf_assignment == 'invitation') {
                            // role who is inviting users
                            $inviting_roles = json_decode($article_basic->jwf_who_can_invite);
                            if ($inviting_roles != '') {
                                $current_stage_detials->who_can_invite = $this->get_users_in_role($art_id, $article_basic->artp_id, $inviting_roles, $article_basics->jnl_id, $article_basics->jnl_journal_code, true);
                            }
                        }
                        $current_activity['current_stage_detials'] = $current_stage_detials;
                        $return_array['user_details'] = $current_activity;
                    }
                }
                $enable_withdrawn_btn = false;
                //$current_stage_detials->jnl_code = $this->jnl_data->jnl_journal_code;
                $approved_stages = array('resubmission');
                $approved_status = array('u','a');
                if(isset($this->current_client->functionality->cfty_enable_article_withdraw) && $this->current_client->functionality->cfty_enable_article_withdraw == 'y' && in_array($article_basics->jwf_stage_type,$approved_stages) && $article_privilages['author'] == true && in_array($article_basics->aflw_status, $approved_status))
                {
                    $enable_withdrawn_btn = true;
                    if(isset($article_basic->art_delete_status) && $article_basic->art_delete_status=='w')
                    {
                        $enable_withdrawn_btn = false;
                    }
                }
                $return_array['enable_withdrawn_btn'] = $enable_withdrawn_btn;
                  //start---RVdashboard #1588 Letting authors do ad hoc emails
                  $adhoc_mail_for_author  =   false;
                  $to_users               =   array();

                  //fetch all authors included in that article
                  $Authors = new \App\Models\Authors();
                  $fetch_authors_arr  =   $Authors::get_all_records('auth_usr_id','auth_art_id=:art_id',null, null,'', null, null,'ASC',array('art_id'=>$art_id));
                  $authors_arr = array_column(json_decode(json_encode($fetch_authors_arr), true), 'auth_usr_id');

                  if($article_privilages['author'] == true && (isset($this->current_client->functionality->cfty_enable_adhoc_mail_for_author) && $this->current_client->functionality->cfty_enable_adhoc_mail_for_author == 'y') && (in_array($this->current_user['user_id'], $authors_arr) == true))
                  {
                    $adhoc_mail_for_author  =   true;
                    $to_users               =   $this->fetch_privileged_users_involved_ina_article($art_id,$article_basics->art_artp_id,$platform_id);
                  }
                  $return_array['adhoc_mail_for_author'] = $adhoc_mail_for_author;
                  $return_array['to_users_for_adhoc_mail'] = $to_users;
                  //stop---RVdashboard #1588 Letting authors do ad hoc emails
                  $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
                    $article_keywords = Article_keywords::get_article_keywords($art_id, false, false, $hierachy, $platform_id);
                    $return_array['article_keywords']=$article_keywords;
                $return_array['article_privilages']=$article_privilages;
                $show_accept_warning = false;
                /*Taskbot Task - 1447 When clicking on 'View Article' in the Preassessment stage (Pool), if another Preassessment task is already in progress, the pool notification should not be shown to other users who currently have a task in progress. */
                if($article_basic->jwf_assignment=="invitation" && $article_basic->aflw_parent_flow_id!='' && $article_basic->aflw_status == 'a' && $article_basic->aflw_usr_id == $this->current_user['user_id'])
                {
                    $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                    $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                    $gen_sql="select jwf_assignment from ".$Generic_flows_table." left join ". $Article_flow_table." on jwf_id=aflw_jwf_id where aflw_id=". $article_basic->aflw_parent_flow_id;
                    $parentrecord=Article_flow::get_records_by_raw_query($gen_sql);
                    if(!empty($parentrecord) && (isset($parentrecord[0]->jwf_assignment) && $parentrecord[0] ->jwf_assignment!='invitation'))
                    {
                        $show_accept_warning = true;
                    }
                }
                $return_array['show_accept_warning']=$show_accept_warning;
                $return_array['es_article'] = false;
                $esarray['article_id']=$art_id;
                $checkdata=$this->check_espermission_access($esarray);
                //if($this->current_client->modules->mdl_es_integration == 'y' && $article_basics->art_es_document_status == 'y')
                if($checkdata==true && $article_basics->art_es_document_status == 'y')
                {
                    $return_array['es_article'] = true;

                }

                return  $this->success('Success', 200, $return_array);
            }
        } catch (\Exception $e) {
           // print_r($e);
            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** used for displaying action buttons and stage assigned details starts  ***/

    //*** used to start a stage and move article to next stage when the it's in progress status starts ***/
    public function change_article_status(Request $request)
    {
        try {
            $post_data = $request->all();

            $validator = Validator::make($post_data, [
                'art_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                //'data_choice' => 'required'

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', $validator->errors());
            }
            DB::beginTransaction();
            $orginal_art_id  = $post_data['art_id'];
            $multi_article = is_array($post_data['art_id']);

            $art_ids = is_array($post_data['art_id']) ? $post_data['art_id'] : [$post_data['art_id'] => $post_data['art_flow_id']];
            foreach($art_ids as $art_id => $flow_id){
                $post_data['art_id'] = $art_id;
                $post_data['art_flow_id'] = $flow_id;
                $change_article_status =$data[$this->decrypt_data($art_id)] = $this->change_article_status_service($post_data);
            }
            
            $resp = '';
            if($multi_article){
                $success_arr = array_filter(array_column($data, 'status'), function ($item) {
                    return  ($item == 'success' && $item == 'Success');
                });
                $warning_arr = array_filter(array_column($data, 'status'), function ($item) {
                    return  ($item == 'warning' && $item == 'Warning');
                });
                $failed_arr = array_filter(array_column($data, 'status'), function ($item) {
                    return  ($item == 'failed' && $item == 'Failed');
                });
                // print_r(['fail_ar' => $failed_arr,'data' => $data, 'fc' => count($failed_arr), 'ac' => count($art_ids)]);exit;
                if(count($failed_arr) == count($art_ids)){
                    return  $this->failure('Failed', 500);
                }
                if(count($success_arr) == count($art_ids)){
                    $resp = $this->success('Success', 200, $data);
                }
                elseif(count($warning_arr) <= count($art_ids)){
                    $resp = $this->warning('Warning', 200, $data);
                }
            }else{
                // print_r($data);
                $art_id = $this->decrypt_data($orginal_art_id);
                $status = $data[$art_id]['status'];
                $resp_data = $data[$art_id]['data'];
                $msg = $data[$art_id]['msg'] ?? $status;
                if($status == 'Success' || $status == 'success'){
                    $resp = $this->success($msg, 200, $resp_data);
                }elseif($status == 'Warning' || $status == 'warning'){
                    $resp = $this->warning($msg, 200, $resp_data);
                }else{
                    $resp = $this->failure(data: $resp_data);
                }
            }
            if(isset($change_article_status['status']) && $change_article_status['status']=="Success")
            {
                if(!isset($change_article_status['data']['trans_complete']))
                {
                    DB::commit();
                }
            }
            return $resp;

        } catch (\Exception $e) {
            DB::rollback();
           return  $this->failure('Failed', 500, $e);
        }
    }

    public function change_article_status_service($post_data)
    {
            try{
            $Journal_permission = new \App\Models\Journal_permission();
            $Authors_affiliation = new \App\Models\Authors_affiliation();
             $Users = new \App\Models\User();
            $validator = Validator::make($post_data, [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                //'data_choice' => 'required'

            ]);
            if ($validator->fails()) {
                return  ['status' => 'Failed', 'data' => $validator->errors()];
            }

           // DB::beginTransaction();
            $resubmission_flag = true; $new_article_id='';
            $art_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : '';
            $platform_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $data_choice = isset($post_data['data_choice']) ?$this->decrypt_data($post_data['data_choice']) : '';
            $nextidrequired = isset($post_data['nextidrequired']) ?$post_data['nextidrequired'] : false;
            $force_change_status= isset($post_data['force_move']) ?$post_data['force_move'] : false;
            if($force_change_status==true)
            $nextidrequired =true;
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  ['status' => 'Warning','data' => "redirectdashboard", 'msg' => 'Failed'];
            }
            if($platform_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $platform_id = $platform_data->jnl_id;
            }
            $Article_type_advance_options = (new \App\Models\Article_type_advance_options)->getTable();
            // Task #925 jwf_enable_research_integrity
            $select_article_details = 'art_id,art_artp_id,artp_abbr_article_type,art_code,art_title,art_abstract,art_resubmission_no,art_status,art_submission_date,art_doi,art_submitted_by,artp_article_type,art_published_article_type,art_article_upload_path,art_transfer_status,art_skipped_assignment_roles,art_delete_status,art_es_document_status,art_publication_issue,art_es_document_status,art_es_document_type,jwf_forms,jwf_status_name,jwf_stage_name,jwf_temporary_status_name,jnl_journal_name,artp_fwm_id,art_stage_submission_method,auth_usr_id,aflw_id,jnl_id,jnl_journal_code,artp_id,jwf_assignment,aflw_parent_flow_id,aflw_status,aflw_usr_id,jwf_stage_type,jwf_who_can_invite,jwf_parent_user_roles,aflw_skip_review,aflw_reopened_min_user_count,jwf_fwm_id,jwf_stage_name,aflw_level,jwf_parent_stages,jwf_enable_transfer,jwf_role_id,aflw_jwf_id,jwf_connect_to_es,aflw_usr_id,jwf_flow_proceed_type,artp_jpm_id,aflw_stage_min_users,art_prev_article_id,(select atotp_article_submission_type from ' . $Article_type_advance_options . ' where atotp_artp_id = art_artp_id ) as art_submission_type,jwf_enable_popup_after_completion,jwf_enable_research_integrity';
            $group_by = 'aflw_id';
            $condition = "aflw_art_id=:art_id and jnl_id=:jnl_id and auth_corr_author=:authorstatus";
            $condition_arr=array(
                'art_id' => $art_id,
                'jnl_id'=>$platform_id,
                'authorstatus'=>'y'
            );
            if (!empty($art_flow_id)) {
                $condition .= " and aflw_id=:aflw_id";
                $condition_arr=array(
                    'art_id' => $art_id,
                    'jnl_id'=>$platform_id,
                    'authorstatus'=>'y',
                    'aflw_id'=>$art_flow_id
                );
            }
            $adv_flow_id = '';
            $basicdata = Articles::get_article_details($select_article_details, $condition, null, true, false, $group_by,$condition_arr);
            $stage_email_ids = array();
            if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y')
            {
                $init_emails = (isset($post_data['on_complete_email'])&&$post_data['on_complete_email'] != "") ?  $post_data['on_complete_email']: array();
                if (!empty($init_emails))
                {
                    $stage_email_ids['complete'] = $init_emails;
                }
            }
            $init_emails = (isset($post_data['on_init_email'])&&$post_data['on_init_email'] != "") ?  $post_data['on_init_email']: array();
            if (!empty($init_emails))
            {
                $stage_email_ids['initialization'] = $init_emails;
            }
            $init_emails = (isset($post_data['unassign_email'])&&$post_data['unassign_email'] != "") ?  $post_data['unassign_email']: array();
            if (!empty($init_emails))
            {
                $stage_email_ids['unassign'] = $init_emails;
            }
            $nextstageid = isset($post_data['nextstageid']) ? $post_data['nextstageid'] : '';
            $decision_stage_type= Generic_flows::get_single_record_with_bind_cond('jwf_stage_type',array('jwf_id'=>$nextstageid));
            $array_decision_stages = array('accept', 'reject', 'decision_revision');
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('article-proposal');
            if($proceedingArr['change_submitting_author'] == true){
            if (
        !empty($decision_stage_type) &&
        isset($decision_stage_type->jwf_stage_type) &&
        in_array($decision_stage_type->jwf_stage_type, $array_decision_stages, true)
              ) {
                $authorList = Authors::get_all_records_with_bind_cond(
                    'auth_id,auth_usr_id', 
                    ['auth_art_id' => $art_id]
                );
                $missingAuthors = [];

                foreach ($authorList as $eachAuthor) {
                    $sel = 'auaff_id, auaff_auth_id';
                    $aff = $Authors_affiliation::get_single_record_with_bind_cond(
                        $sel,
                        ['auaff_auth_id' => $eachAuthor->auth_id, 'auaff_prime_affiliation' => 'y']
                    );

                    if (empty($aff)) {
                        $missingAuthors[] = $eachAuthor->auth_usr_id;
                    }
                }

                if (!empty($missingAuthors)) {
                    $missingAuthorNames = [];

                    foreach ($missingAuthors as $authId) {
                        $user = $Users::get_single_record_with_bind_cond(
                            'usr_first_name, usr_middle_name, usr_last_name',
                            ['usr_id' => $authId] 
                        );

                        if ($user) {
                            $fullname = $user->usr_first_name
                                . (!empty($user->usr_middle_name) ? (' ' . $user->usr_middle_name . ' ') : ' ')
                                . (!empty($user->usr_last_name) ? $user->usr_last_name : '');

                            $missingAuthorNames[] = trim($fullname);
                        }
                    }
                    $boldNames = array_map(function($name) {
                        return "<b>{$name}</b>";
                    }, $missingAuthorNames);

                    $return_arr['msg'] = customTrans('viewarticle.grp_affiliation_missing') . "<br>" . implode(", ", $boldNames);
                     return ['status' => 'Warning','data' => $return_arr];
                }
            }
                    }
            $this->current_user = $this->get_current_user_details();
            $move_next_data_array = array();
            $this_stage = array();
            $enable_attachment=false;
            if (!empty($basicdata)) {
                $article_basic = $basicdata[0];
                // Task #925 check rvri report is generated
                /*if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y') {
                    
                    if($this->check_rvri_report_generated($article_basic) == false) {
                        $return_arr['msg'] = 'Research integrity report is not generated';
                        return ['status' => 'Warning', 'data' => $return_arr];
                    }
                }*/

             
                /*Task #401 Taskbot move next generate pdf issue */
              
                $stage_attachment_status=Generic_flows::get_single_record_with_bind_cond('jwf_article_attachment_status', array("jwf_stage_type"=>"author_submission","jwf_fwm_id"=>$article_basic->jwf_fwm_id));
                if(isset($stage_attachment_status->jwf_article_attachment_status)&&$stage_attachment_status->jwf_article_attachment_status=='y')
                {
                    $enable_attachment=true;
                }
              
                /*End Task #401*/
                $article_basics = json_decode(json_encode($article_basic), false);
                $art_submission_types = json_decode($article_basics->art_submission_type);
                $es_article = false;
                $esarray['article_id']=$art_id;
                $checkdata=$this->check_espermission_access($esarray);
                if($checkdata==true && $article_basics->art_es_document_status !== 'n')
                {
                    $es_article = true;
                }
                $update_article_transfer_status = ($article_basics->art_status == 't' && $article_basics->art_transfer_status == 'y') ? true : false;
                if ($update_article_transfer_status == true) {
                    $error_data= $this->validate_transfered_article_details_completed($article_basics, true, false,$es_article);
                    if ($error_data['has_error'] == true) {
                        if($error_data['section']=="pdf")
                        {
                        $return_arr['msg'] = customTrans('viewarticle.pdf_warning_msg');
                        $return_arr['enablepdfgenerate'] = true;
                        }
                        else
                        {
                        $return_arr['msg'] = customTrans('viewarticle.article_complete_all');
                        }
                        $return_arr['redirect_to'] = 'edit-article';
                        $return_arr['artp_abbr_article_type'] = $article_basics->artp_abbr_article_type;
                        $return_arr['redirect'] = true;
                        $return_arr['link'] = 'author-article';
                        return ['status' => 'Warning','data' => $return_arr];
                    }
                    if($es_article == true && $article_basics->art_es_document_type == 'u')
                    {
                        $count_description = Attachment_files::get_single_record_with_bind_cond('count(atmnt_id) as cnt',array('atmnt_art_id' => $article_basics->art_id,'atmnt_label' => 0));
                        if($count_description->cnt > 0)
                        {
                            $return_arr['msg'] = 'Please select descriptions to all attachments';
                            return ['status' => 'Warning', 'data' => $return_arr];
                        }
                        $attchment_table = (new \App\Models\Attachment_files())->getTable();

                        $description_tbl = (new \App\Models\Attachment_file_description())->getTable();

                        $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id')
                            )
                        );
                        $select_fields = 'afdec_main_document';
                        $criteria = 'atmnt_art_id=' . $article_basics->art_id.' AND afdec_main_document =\'y\'';
                        $get_all_attach_details = Attachment_files::get_results_using_joins($tables, $select_fields, $criteria, 'all');
                        if(count($get_all_attach_details) == 0)
                        {
                            $return_arr['msg'] = 'Main document is mandatory';
                            return ['status' => 'Warning', 'data' => $return_arr];
                        }
                    }
                }
                $post_data['data_choice'] = $data_choice;
                $article_privilages = $this->article_privilages($article_basics, $article_basics->aflw_id, $article_basics->jnl_journal_code);
                $privileged_user = $article_privilages['privilaged'];
                $isauthor = $article_privilages['author'];
                $isreviewer=$article_privilages['reviewer'];
                $user_allocated=$article_privilages['user_allocated'];
                if($data_choice=="checkout" && ($isauthor==true || ($isreviewer==true && $user_allocated == false)))
                {
                    return  ['status' => 'Warning','data' => "redirectdashboard", 'msg' => 'Failed'];
                }
                $post_data['jnl_id'] = $platform_id;
                $duplicate = $this->validate_duplicate_entry($post_data, $article_basics);
                if (!empty($duplicate) && isset($duplicate['status'])) {
                    return ['status' => 'Warning','data' => $duplicate];
                }
                if ($data_choice != "checkout") {
                    $casrai_orcid = $this->check_casrai_and_orcid($article_basics->jwf_stage_type, $art_flow_id, $art_id, $article_basics->jnl_journal_code);
                    if (isset($casrai_orcid['msg'])) {
                        return ['status' => 'Warning','data' => $casrai_orcid];
                    }
                }

                if ($article_basics->jwf_stage_type == 'revision' || $article_basics->jwf_stage_type == 'resubmission') {
                    $this->update_with_default_attach_description($art_id, $article_basics->art_artp_id);
                }
                if ($data_choice == 'transit') {
                    $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
                    //return $this->transfer_article($article_id, $current_status_id, $journa_id_input, $journal_code);
                    $transfer_details = $Article_transfer_suggestion::get_single_record('ats_art_id,ats_dst_artp,ats_dst_jnl,ats_dst_stage,ats_article_data,ats_author_action,ats_src_artp,ats_dst_artp,ats_src_jnl', 'ats_art_id=:art_id and ats_aflw_id=:art_flow_id and ats_src_jnl=:platform_id',null,'',null,array('art_id'=>$art_id,'art_flow_id'=>$art_flow_id,'platform_id'=>$platform_id));
                    $author_action = $transfer_details->ats_author_action;
                    $transfer_mode = $transfer_details->ats_article_data; //1 - resubmit 2 - move to particular stage

                    if ($author_action == 1 && $transfer_mode == 2) // Author accept Transfer article
                    {
                        $transfer_stgae = $this->transfer_article_with_stage($transfer_details, $art_id, $art_flow_id, $platform_id, $article_basics->jnl_journal_code);
                        // TASK #9554 Due date and initialization mail missing during article type transfer within the same journal
                        //next stage initialization after tranist complete
                        $next_flowid=$transfer_stgae['insertid']?$transfer_stgae['insertid']:'';
                        if(!empty($next_flowid))
                        {
                            $Stage_email_templates = new \App\Models\Stage_email_templates();
                            //check stage exists in articleflow table
                            $new_flow_details= Article_flow::get_single_record_with_bind_cond('aflw_id,aflw_jwf_id',array('aflw_art_id'=>$art_id,'aflw_id'=>$next_flowid));
                            // Fetch email template
                            $email_template =  $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_action,stage_etmp_to,stage_etmp_id', "stage_etmp_action = 'initialization' AND setr_jwf_id = {$new_flow_details->aflw_jwf_id}");
                             if (!empty($email_template))
                             {
                                 foreach ($email_template as $template)
                                 {
                                    if (isset($transfer_details->ats_src_artp, $article_basics->jnl_id, $article_basics->jnl_journal_code, $article_basics->art_submitted_by)) 
                                    {
                                        $custom_data = array(
                                            'article_id'=> $art_id,
                                            'artp_id'=> $transfer_details->ats_src_artp,
                                            'stage_etmp_action' => $template->stage_etmp_action,
                                            'stage_etmp_to'     => $template->stage_etmp_to,
                                            'template_id'     => $template->stage_etmp_id,
                                            'jnl_id'=>$article_basics->jnl_id,
                                            'jnl_code'=>$article_basics->jnl_journal_code,
                                            'src_jnl_id'=>$article_basics->jnl_id,
                                            'aflw_id'=>$next_flowid,
                                        );
                                        $email_data = array(
                                            'type' => 'stage',
                                            'action' => 'send',
                                            'aflw_id'=>$next_flowid,
                                            'email_with_login' => TRUE,
                                            'user_id' => $article_basics->art_submitted_by,
                                            'jnl_user_role'=>array(
                                            'core_role'=>'',
                                            'role_name'=>'',
                                            'jnl_journal_code'=> $article_basics->jnl_journal_code,
                                            'jnl_id'=>$article_basics->jnl_id
                                        ),
                                            'custom_data' => $custom_data
                                        );
                                        $this->master_email_details($email_data);
                                    }
                                 }
                             }
                        }
                        if (isset($transfer_stgae['alert']) && $transfer_stgae['alert'] == "success") {
                            return ['status' => 'Success', 'data' =>  $transfer_stgae];
                        } else {
                            return ['status' => 'Warning','data' => $transfer_stgae];
                        }
                    } elseif ($author_action != 1) {
                        $transfer_reject = $this->transfer_article_reject($art_id, $art_flow_id, $platform_id, $article_basics->jnl_journal_code);
                        if (isset($transfer_reject['alert']) && $transfer_reject['alert'] == "success") {
                            return ['status' => 'Success','data' => $transfer_reject];
                        } else {
                            return ['status' => 'Warning','data' => $transfer_reject];
                        }
                    }
                }

                /* End --- if the current status name is trasit */

                /* Start --- if article is in transit stage then redirect to journal home */
                /*if (isset($article_basics->art_status) && $article_basics->art_status == 't') {
                    $return_arr['msg'] = customTrans('viewarticle.move_article_failed');
                    $return_arr['redirect'] = true;
                    $return_arr['redirectto'] = 'dashboard';
                    return $this->warning('Warning', 200, $return_arr);
                }*/
                if ($data_choice == 'license_check') {
                    $Copyright = new \App\Models\Copyright();
                    $copyright_details = $Copyright::get_copyright('crt_art_id=' . $art_id);
                    if ($copyright_details->crtm_payment == 'o') {
                        /*if($this->current_client->functionality->cfty_rightslink_api_v2 = 'y')
                        {
                            $this->config->load('clients/' . $this->current_client->clnt_client_code . '/rightslink_v2');
                            $this->load->library('rightslink_lib', $this->config->item('rightslink'));
                        }
                        else
                        {
                            $this->config->load('clients/' . $this->current_client->clnt_client_code . '/rightslink');
                            $this->load->library('rightslink_lib', $this->config->item('rightslink'));
                        }
                        $this->load->model('journals/Journal_metadata');
                        $load_models['Journal_metadata'] = $this->Journal_metadata;
                        $load_libraries['Rightslink_lib'] = $this->rightslink_lib;*/
                    }
                }


                $user_roles = $this->validate_user_journal($article_basics->jnl_journal_code, $this->current_user['user_id'], $article_basics->art_artp_id);
                //$array_data['user_roles'] = $user_roles;
                $check_user_permission =$this->checkuserhaspermission($article_privilages,$user_roles,$article_basics,$this->current_user['user_id'],$platform_id,$jnlcode);
                if($check_user_permission==false)
                {
                    return  ['status' => 'Warning','data' => "permission_denied", 'msg' => 'Failed'];
                }

                $this_stage['aflw_status'] = $article_basics->aflw_status;
                $this_stage['aflw_jwf_id'] = $article_basics->aflw_jwf_id;
                $this_stage['aflw_art_id'] = $article_basics->art_id;
                $this_stage['aflw_level'] = $article_basics->aflw_level;
                $this_stage['jwf_stage_type'] = $article_basics->jwf_stage_type;
                //$this_stage['jwf_id'] = $article_basics->aflw_jwf_id;
                $checkout_article = false;
                $auto_assign_role = false;
                if ($data_choice == "checkout" || $data_choice == 'resubmission') {
                    $checkout_article = true;
                    if ($this->current_client->functionality->cfty_auto_assign_user_for_role == 'y') {
                        //$artp_opt = $Article_type_advance_options::get_single_record('atotp_auto_assign_role', 'atotp_artp_id=' . $article_basics->art_artp_id);
                        $select = "jp_auto_assign_role";
                        $artp_opt = $Journal_permission::get_single_record($select, 'jp_jpm_id=:artp_jpm_id',null,'',null,array('artp_jpm_id'=>$article_basics->artp_jpm_id));
                        if (isset($artp_opt->jp_auto_assign_role) && $artp_opt->jp_auto_assign_role != '') {
                            $roles = json_decode($artp_opt->jp_auto_assign_role);
                            if (in_array($article_basics->jwf_role_id, $roles)) {
                                $auto_assign_role = true;
                            }
                        }
                    }
                } elseif ($data_choice == "move_to_advance_selected") {
                    $adv_flow_id = isset($post_data['nextstageid']) ? $post_data['nextstageid'] : '';
                    $move_next_data_array['adv_flow_id'] = $adv_flow_id;
                    $nextstageid = null;
                }
                elseif($nextidrequired == false && $article_basics->jwf_flow_proceed_type == null)
                {
                    $nextstageid = null;
                }
                /*elseif ($article_basics->jwf_assignment == "invitation" && $article_basics->aflw_parent_flow_id != null) {
                    $nextstageid = null;
                }*/

                /* start --  check article attachment change */
                if ($checkout_article == false) {
                    $Article_type_advance_options =new \App\Models\Article_type_advance_options();
                    $get_article_advance_options = $Article_type_advance_options::get_single_record('atotp_suggest_reviewers,atotp_suggest_reviewers_mandatory,atotp_oppose_reviewers,atotp_oppose_reviewers_mandatory', 'atotp_artp_id=:atotp_artp_id',null,'',null,array('atotp_artp_id'=>$article_basics->art_artp_id));
                    $get_pdf_status = $this->get_article_pdf_status($article_basics->art_id);
                    //TASK #4482 - Error fix - to avoid pdf generation warning for the user who has not the peermission to add/delete submitted files.
                    $show_pdf_generation_warning = true;
                    $select = "jp_edit_article_files";
                    $condition = "artp_id=:artp_id";
                    $permissions = $this->get_article_type_permission($select, $condition,array('artp_id'=>$article_basics->artp_id));
                    // if($article_privilages['author'] == false && (empty($permissions->jp_edit_article_files) || (!empty(json_decode($permissions->jp_edit_article_files)) && count(array_intersect(json_decode($permissions->jp_edit_article_files), $user_roles['role_id'])) <= 0)))
                    // {
                    //     $show_pdf_generation_warning = false;
                    // }
                    // echo 'show pdf warning ->'.$show_pdf_generation_warning;exit;
                    //TASK #4482 - End  
                     /*Task #401 Taskbot move next generate pdf issue */           
                   if ($get_pdf_status['status'] == false && $show_pdf_generation_warning == true && in_array('fu', $art_submission_types) && $es_article == false && $enable_attachment==true) {
                        //if($data_choice =="resubmitauthor")
                            $error_msg = customTrans('viewarticle.pdf_warning_msg'); 
                        /*else
                            $error_msg = customTrans('viewarticle.preview_pdf_error_stage');*/
                        //To hide pdf generation button at the move next stage warning popup if the user has not the permission to add edit files.
                        $enable_pdf_generate = true;
                        if($article_privilages['author'] == false && (empty($permissions->jp_edit_article_files) || (!empty(json_decode($permissions->jp_edit_article_files)) && count(array_intersect(json_decode($permissions->jp_edit_article_files), $user_roles['role_id'])) <= 0)))
                        {
                                $enable_pdf_generate = false;                            
                                $error_msg = customTrans('viewarticle.pdf_warning_non_privilege');
                        }
                        
                        if ($data_choice == 'resubmission')
                            $error_msg = customTrans('viewarticle.resubmit_pdf_error_edit_page');
                            $return_arr['msg'] = $error_msg;
                            $return_arr['redirect'] = true;
                            $return_arr['enablepdfgenerate'] = $enable_pdf_generate;
                            $return_arr['arttypecode'] = true;
                            if($data_choice =="resubmitauthor")
                            {
                            $return_arr['arttypeid'] = $article_basics->art_artp_id;
                            $return_arr['arttype'] = $article_basics->artp_article_type;
                            }
                           return ['status' => 'Warning','data' => $return_arr];
                    }
                    if($es_article == true && $article_basics->art_es_document_type == 'u')
                    {
                        $count_description = Attachment_files::get_single_record_with_bind_cond('count(atmnt_id) as cnt',array('atmnt_art_id' => $article_basics->art_id,'atmnt_label' => 0));
                        if($count_description->cnt > 0)
                        {
                            $return_arr['msg'] = 'Please select descriptions to all attachments';
                            return  [ 'status' => 'Warning', 'data' => $return_arr];
                        }
                        $attchment_table = (new \App\Models\Attachment_files())->getTable();

                        $description_tbl = (new \App\Models\Attachment_file_description())->getTable();

                        $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id')
                            )
                        );
                        $select_fields = 'afdec_main_document';
                        $criteria = 'atmnt_art_id=' . $article_basics->art_id.' AND afdec_main_document =\'y\'';
                        $get_all_attach_details = Attachment_files::get_results_using_joins($tables, $select_fields, $criteria, 'all');
                        if(count($get_all_attach_details) == 0)
                        {
                            $return_arr['msg'] = 'Main document is mandatory';
                            return [ 'status'=> 'Warning', 'data' => $return_arr];
                        }
                    }
                    if($article_basics->art_status=='n' && empty($article_basics->art_prev_article_id))
                    {
                        //$oppose_revr = true;
                        //$suggest_revr = true;
                        $Article_reviewers = new \App\Models\Article_reviewers();
                        if ($get_article_advance_options->atotp_oppose_reviewers == 'y' && $get_article_advance_options->atotp_oppose_reviewers_mandatory == 'y') {
                            $oppose_sql = 'SELECT COUNT(sorw_id) AS oppose_reviewer_cnt FROM ' . $Article_reviewers->getTable() . ' WHERE sorw_art_id = :art_id AND sorw_action = :action ';
                            $oppose_reviewers = $Article_reviewers::get_records_by_raw_query($oppose_sql,false,array('art_id'=>$art_id,'action'=>'o'));
                        }
                        if ($get_article_advance_options->atotp_suggest_reviewers == 'y' && $get_article_advance_options->atotp_suggest_reviewers_mandatory == 'y') {
                            $suggest_sql = 'SELECT COUNT(sorw_id) AS suggest_reviewer_cnt FROM ' . $Article_reviewers->getTable() . ' WHERE sorw_art_id = :art_id  AND sorw_action = :action';
                            $suggest_reviewers = $Article_reviewers::get_records_by_raw_query($suggest_sql,false,array('art_id'=>$art_id,'action'=>'s'));
                        }
                        if ($get_article_advance_options->atotp_suggest_reviewers == 'y' && $get_article_advance_options->atotp_suggest_reviewers_mandatory == 'y' && $get_article_advance_options->atotp_oppose_reviewers == 'y' && $get_article_advance_options->atotp_oppose_reviewers_mandatory == 'y') {
                            $suggest_oppose_sql = 'SELECT COUNT(sorw_id) AS suggest_oppose_reviewer_cnt FROM ' .$Article_reviewers->getTable() . ' WHERE sorw_art_id = ' . $art_id . ' AND sorw_action  IN (\'s\',\'o\') ';
                            $get_suggest_oppose_rvr_rec = $Article_reviewers::get_records_by_raw_query($suggest_oppose_sql);
                        }

                        if (json_decode($get_article_advance_options->atotp_suggest_reviewers == 'y' && $get_article_advance_options->atotp_suggest_reviewers_mandatory == 'y' && $get_article_advance_options->atotp_oppose_reviewers == 'y' && $get_article_advance_options->atotp_oppose_reviewers_mandatory == 'y') && $get_suggest_oppose_rvr_rec[0]->suggest_oppose_reviewer_cnt == 0) {
                            //$suggest_revr = false;
                            //$oppose_revr = false;
                            $error_msg = customTrans('viewarticle.suggest_oppose_rvr');
                            $return_arr['msg'] = $error_msg;
                            $return_arr['redirect'] = true;
                            return ['status' => 'Warning','data' => $return_arr];
                        }
                        elseif (json_decode($get_article_advance_options->atotp_oppose_reviewers == 'y' && $get_article_advance_options->atotp_oppose_reviewers_mandatory == 'y') && $oppose_reviewers[0]->oppose_reviewer_cnt == 0) {
                            //$oppose_revr = false;
                            $error_msg =  customTrans('viewarticle.oppose_rvr');
                            $return_arr['msg'] = $error_msg;
                            $return_arr['redirect'] = true;
                            return ['status' => 'Warning','data' => $return_arr];
                        }
                        elseif (json_decode($get_article_advance_options->atotp_suggest_reviewers == 'y' && $get_article_advance_options->atotp_suggest_reviewers_mandatory == 'y') && $suggest_reviewers[0]->suggest_reviewer_cnt == 0 && $article_basics->art_stage_submission_method !== 'n') {
                            //$suggest_revr = false;
                            $error_msg = customTrans('viewarticle.suggest_rvr');
                            $return_arr['msg'] = $error_msg;
                            $return_arr['redirect'] = true;
                            return ['status' => 'Warning','data' => $return_arr];
                        }
                    }
                } elseif ($checkout_article == true && $data_choice == 'resubmission') {
                    $new_article_id = $this->create_article_copy($art_id, $this->current_user, '', false, $this->current_client);
                    $Article_flag = new \App\Models\Article_flag();
                    $get_current_art_flg = $Article_flag::get_all_records('aflg_flag_id,aflg_merge_date', 'aflg_art_id=:art_id',null, null,'', null, null,'ASC',array('art_id'=>$art_id));
                    if (!empty($get_current_art_flg)) {
                        foreach ($get_current_art_flg as $single_art_flg) {
                            $flag_data = array(
                                'aflg_flag_id' => $single_art_flg->aflg_flag_id,
                                'aflg_art_id' => $new_article_id,
                                'aflg_jnl_id' => $platform_id,
                                'aflg_posted_by' => 0,
                                'aflg_posted_date' => date('Y-m-d H:i:s'),
                                'aflg_merge_date' => $single_art_flg->aflg_merge_date,
                                'aflg_proxy_id' => $this->current_user['proxy_user_id'],
                                'aflg_operation' => 'i'
                            );
                            $insert_new_flags = $Article_flag->insert_record($flag_data);
                        }
                    }
                    if(isset($post_data['es_article']) && $post_data['es_article'] == true)
                    {
                        $current_user = $this->get_current_user_details();
                        $Users = new \App\Models\User();
                        $user_data = $Users::get_single_record_with_bind_cond('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,concat(usr_first_name,\' \',usr_last_name) as user_name',array('usr_id' => $current_user['user_id']));
                        $data_to_editor = $this->set_data_for_editor($new_article_id,$art_flow_id,$user_data,$post_data['auth_id'],$post_data['current_role']);
                        $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                        $es_api_data  = Config::get($es_config);
                        $apiUrl = $es_api_data['register_new_version'];
                        $data_to_editor = http_build_query($data_to_editor);
                        $response = $this->es_curl_request($apiUrl,$data_to_editor);
                        $response = json_decode($response);
                    }
                }
                $ithenticate_enabled = false;
                if (isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y') {
                    $ithenticate_enabled = true;
                }
                // Task #925 check rvri report is enabled
                $rvri_enabled = false;
                if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y') {
                    $rvri_enabled = true;
                }
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);
                $production_status = false;
                if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
                {
                    $mng_production = $this->is_article_in_production_management($art_id,$art_flow_id);
                    $production_status=$mng_production['status'];
                }
                $passing_array = array();
                if(isset($post_data['hdn_user_art_allocation']) && $post_data['hdn_user_art_allocation'] == 'y')
                {
                    $passing_array['allocation_done'] = true;
                }
                $platform_data = $this->platform_basic_settings_data($article_basics->jnl_journal_code);
                $reply_to_email = $platform_data->jset_reply_to_email;
                if(isset($review_flow[$article_basics->jwf_stage_type]['stage_for']) && $review_flow[$article_basics->jwf_stage_type]['stage_for'] == 'manageproduction' && isset($platform_data->jset_reply_to_email_traction) && $platform_data->jset_reply_to_email_traction != "" && $platform_data->jset_reply_to_email_traction != null)
                {
                    $reply_to_email = $platform_data->jset_reply_to_email_traction;
                }
                if($post_data['data_choice'] == 'resubmitauthor' && $article_basics->art_es_document_status == 'y')
                {
                    $current_user = $this->get_current_user_details();
                    $Users = new \App\Models\User();
                    $user_data = $Users::get_single_record_with_bind_cond('usr_email',array('usr_id' => $current_user['user_id']));
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    if(isset($es_api_data['check_unresolved_comments']))
                    {
                        $apiUrl = $es_api_data['check_unresolved_comments'];
                        $pass_data = array('article_id' => Rv_encrypt($article_basic->art_id),'user_email' => $user_data->usr_email);
                        $pass_data = http_build_query($pass_data);
                        $response = $this->es_curl_request($apiUrl,$pass_data);
                        $response = json_decode($response);
                        if(isset($response->no_reply_comment) || isset($response->unresolved_changes))
                        {
                            $editor_exe_found = false;
                            $error_msg = '';
                            if(isset($response->no_reply_comment) && $response->no_reply_comment == true)
                            {
                                $editor_exe_found = true;
                                $error_msg = trans('viewarticle.editor_cannont_complete').'<br><br> <ul> <li class="text-left">'.str_replace(":count",$response->count,trans('viewarticle.editor_undressed_msg')).'</li>';
                            }
                            if(isset($response->unresolved_changes) && $response->unresolved_changes == true)
                            {
                                $editor_exe_found = true;
                                if($error_msg !== '')
                                {
                                    $error_msg = $error_msg.'<li class="text-left">'.str_replace(":count",$response->changes_count,trans('viewarticle.editor_unresolved_msg')).'</li></ul>';
                                }
                                else
                                {
                                    $error_msg = trans('viewarticle.editor_cannont_complete').'<br> <ul> <li class="text-left">'.str_replace(":count",$response->changes_count,trans('viewarticle.editor_unresolved_msg')).'</li></ul>';
                                }
                            }
                            elseif($error_msg !== '')
                            {
                                $error_msg = $error_msg.'</li></ul>';
                            }

                            if($editor_exe_found == true)
                            {
                                $es_site_url = $es_api_data['api_url'];
                                $return_arr['msg'] = $error_msg;
                                $return_arr['redirect'] = false;
                                $return_arr['link_to_es'] = $es_site_url;
                                return ['status' => 'Warning', 'data' => $return_arr];
                            }
                        }
                    }
                }
        
                $move_next_data_array['force_move'] = $force_change_status; 
                $move_next_data_array['checkout_article'] = $checkout_article;
                $move_next_data_array['article_id'] = $article_basics->art_id;
                $move_next_data_array['current_user'] = $this->current_user;
                $move_next_data_array['master_flow_id'] = $article_basics->artp_fwm_id;;
                $move_next_data_array['current_jwf_id'] =$article_basics->aflw_jwf_id;
                $move_next_data_array['current_stage'] = $article_basics->aflw_id;
                $move_next_data_array['artp_id'] = $article_basics->art_artp_id;
                $move_next_data_array['ithenticate_enabled']=$ithenticate_enabled;
                $move_next_data_array['rvri_enabled']=$rvri_enabled;
                $move_next_data_array['current_client'] = $this->current_client;
                $move_next_data_array['this_stage'] = $this_stage;
                $move_next_data_array['trans_started'] = true;
                $move_next_data_array['role_id'] = $article_basics->jwf_role_id;
                $move_next_data_array['auto_assign_role'] = $auto_assign_role;
                $move_next_data_array['new_article_id'] = $new_article_id;
                $move_next_data_array['stage_email_ids'] = $stage_email_ids;
                $move_next_data_array['art_prev_article_id'] = $article_basics->art_prev_article_id;
                //$move_next_data_array['stage']=$stagename;
                $move_next_data_array['next_stage'] = $nextstageid;
                $stage_move_result = $this->move_next_stage($move_next_data_array);
                
            
            if (isset($data_choice) && $data_choice!="checkout" ) {
                $this->suspecious_activity_check($move_next_data_array);

                $esarray['article_id']=$article_basics->art_id;
                $checkdata=$this->check_espermission_access($esarray);
                if($checkdata == TRUE)
                {
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    if(isset($es_api_data['create_stage_backup']))
                        {
                            $apiUrl = $es_api_data['create_stage_backup'];
                            $data_to_editor = array('documentId' => $article_basics->art_id,'currentFlowId' => $article_basics->aflw_id,'systemType' => 1,'stage_name_privillaged' => $article_basics->jwf_stage_name,'stage_name_non_privillaged' => $article_basics->jwf_temporary_status_name  == NULL ? $article_basics->jwf_stage_name : $article_basics->jwf_temporary_status_name,'current_user' => $this->current_user);
                            $data_to_editor = http_build_query($data_to_editor);
                            $response = $this->es_curl_request($apiUrl,$data_to_editor);
                            $response = json_decode($response);
                        }
                }
                }
                
                if ($data_choice == 'resubmission' && !empty($article_basics->art_publication_issue) && $checkout_article == true) {
                    $Issue_management = new \App\Models\Issue_management();
                    $data        = array(
                        'ism_art_page_cnt' => 0,
                        'ism_iss_id' =>  $article_basics->art_publication_issue,
                        'ism_art_id' =>  $new_article_id,
                        'ism_order'  =>  1
                    );
                    Issue_management::insert_record($data, $this->current_user);
                }
                //task-3133 - Attach notify to author (file description setting) PDF to Author -- start
                if($article_basics->jwf_stage_type === 'publish'){
                    $Stage_email_tmpl_reference_tbl = (new \App\Models\Stage_email_tmpl_reference)->getTable();
                    $Stage_email_templates_tbl = (new \App\Models\Stage_email_templates)->getTable();

                    $article_data['ane_id'] = '';
                    $article_data = (array)$article_basics;
                    $join_tables = array(
                        'main_table' => $Stage_email_tmpl_reference_tbl,
                        'join_table' => array(
                            $Stage_email_templates_tbl => array($Stage_email_templates_tbl . '.stage_etmp_id', $Stage_email_tmpl_reference_tbl . '.setr_stage_etmp_id')
                        )
                    );
                    $select_fields ='setr_id,setr_stage_etmp_id';
                    $criteria = 'setr_jwf_id='.$article_data['aflw_jwf_id'];
                    $order_by = 'author_name';
                    $stage_email_ids = Stage_email_tmpl_reference::get_results_using_joins($join_tables, $select_fields, $criteria, $order_by);
                    if(!empty($stage_email_ids)){
            			$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
                        $prefixPath = storage_path()  . $file_storage_path;
			            $basic_path = $prefixPath . APP_DOC_PATH . 'email_attachments/' . $art_id;
                        if (!file_exists($basic_path)) {
                            mkdir($basic_path, 0765, true);
                        }
                        foreach($stage_email_ids as $tmpl_id){
                            $article_details = array();
                            $article_details['setr_id'] = $tmpl_id->setr_id;
                            $article_details['id'] = encrypt_link($tmpl_id->setr_stage_etmp_id);
                            $article_details['art_id'] = encrypt_link($article_data['art_id']);
                            $article_details['aflw_id'] = encrypt_link($article_data['aflw_id']);
                            // print_r($article_details);
                            $ane_id = $this->save_article_email_notification($article_details, 'default_save');
                            $base_production_path= APP_DOC_PATH . $article_basics->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/';
                            $attach_to_author=$this->get_attach_to_author_files($article_basics->art_id);
                            if (!empty($attach_to_author))
                            {
                                foreach($attach_to_author as $attach)
                                {
                                    $attachment_file_name = $attach->paf_file_name;
                                    $source_path = $prefixPath . APP_DOC_PATH . $article_basics->jnl_journal_code . '/' . $article_basics->artp_abbr_article_type . '/' . $art_id . '/production/' . $attach->paf_aflw_id . '/' . $attachment_file_name;
                                    if (file_exists($source_path)) {
                                        $destination_path = $basic_path . '/' . $attachment_file_name;
                                        if (file_exists($destination_path)) {
                                            $i = 1;
                                            $got_new_file = false;
                                            while ($got_new_file == false) {
                                                $ext = pathinfo($destination_path, PATHINFO_EXTENSION);
                                                $file_name = basename($attachment_file_name, '.' . $ext);
                                                if (!file_exists($basic_path . '/' . $file_name . ' (' . $i . ').' . $ext)) {
                                                    $got_new_file = true;
                                                    $attachment_file_name = $file_name . ' (' . $i . ').' . $ext;
                                                }
                                                $i++;
                                            }
                                            $destination_path = $basic_path . '/' . $attachment_file_name;
                                        }
                                        if (copy($source_path, $destination_path)) {
                                            $insert_data = array(
                                                'emat_file_name' => $attachment_file_name,
                                                'emat_ane_id' => $ane_id,
                                                'emat_document_size' => $attach->paf_document_size,
                                                'emat_art_id'=>$article_basics->art_id
                                            );
                                            $already_exist = Email_attachments::get_single_record_with_bind_cond('count(emat_id) as cnt',$insert_data);
                                            if(isset($already_exist->cnt) && $already_exist->cnt < 1)
                                                Email_attachments::insert_record($insert_data);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
                //task-3133 - end
                $mode = ''; $publons_msg='';
                if (!empty($stage_move_result)) {
                   if ($update_article_transfer_status == true) {
                        $msg = customTrans('viewarticle.copy_article_success');

                        Articles::update_record(array(
                            'art_status' => 'y',
                            'art_transfer_status' => 'n',
                            'art_operation' => 't',
                            "art_decision_date" => date('Y-m-d H:i:s')
                        ), 'art_id=' . $article_basics->art_id, $this->current_user);
                    }
                    if (isset($stage_move_result['publons_msg']) && $stage_move_result['publons_msg'] != "")
                        $publons_msg = $stage_move_result['publons_msg'];
                    if ($article_basics->art_status == 'n') {
                        //incase of move to next stage from resubmission, the art_status should be updated
                        Articles::update_record(array(
                            'art_status' => 'y',
                            "art_decision_date" => date('Y-m-d H:i:s')
                        ), 'art_id=' . $article_basics->art_id, $this->current_user);
                    }
                    if ($resubmission_flag == true) //*UPDATE GENERIC FORM*//
                    {
                        $Article_generic_form_data = new \App\Models\Article_generic_form_data();
                        $Article_generic_form_data::update_newarticle_gen_formdata($new_article_id, "_" . $article_basics->jnl_journal_code);
                    }
                    $stage_move_result['privileged_user'] = $privileged_user;
                    $stage_move_result['prev_aflw_id'] = $this->encrypt_data($article_basics->aflw_id);
                    $stage_move_result['isauthor'] = $isauthor;
                    $stage_move_result['isreviewer'] = $isreviewer;
                    $stage_move_result['viewlink'] = ($isauthor==true)?'author-article':'view-article';
                    //if ($nextstageid != '' || $adv_flow_id != '' || $checkout_article === false) {
                        if ($checkout_article === false) {

                            //Custome FTP export -- start
                            $this->upload_article_data_to_custom_ftp($article_basics->art_id, $article_basics->aflw_id, 'c', $stage_move_result);
                            //Custome FTP export -- End

                            //On submitting check for the forms in workflow, and remove unwanted forms if not added in the workflow.--Starts
                            $formatted_journal_code = '_'.$article_basics->jnl_journal_code;
                            if(!empty($article_basics->jwf_forms) && count(json_decode($article_basics->jwf_forms)) > 0){
                                $form_ids = implode(',',json_decode($article_basics->jwf_forms));
                                $element_condition = "gdata_atf_id NOT IN (". $form_ids .") AND gdata_art_id = " .$article_basics->art_id. " AND gdata_artflw_id = " .$article_basics->aflw_id;
                                $existdata = Article_generic_form_data::get_all_records("gdata_id,gdata_atf_id,gdata_art_id,gdata_artflw_id",$element_condition,null,null,$formatted_journal_code);
                                if(!empty($existdata)) {
                                    Article_generic_form_data::delete_records($element_condition, $formatted_journal_code, $this->current_user);
                                }
                            }
                            //On submitting check for the forms in workflow, and remove unwanted forms if not added in the workflow.--ends

                        if (isset($stage_move_result['action']) && $stage_move_result['action'] == 'moved_to_next' && $privileged_user == true && $isreviewer == false) {
                            if(!empty($stage_move_result['stage_id']))
                            {
                            $newstagetype = gettype($stage_move_result['stage_id']);
                            if($newstagetype == 'array')
                            {
                                if(isset($stage_move_result['stage_id'][0][0]))
                                {
                                    $stage_id = $stage_move_result['stage_id'][0][0];
                                }
                                elseif(isset($stage_move_result['stage_id'][0])){
                                    $stage_id = $stage_move_result['stage_id'][0];
                                }
                            }
                            else{
                                $stage_id =$stage_move_result['stage_id'];
                            }

                            $stage_move_result['stageid'] = isset($stage_id)?$this->encrypt_data($stage_id):'';
                            }
                            else{
                            $stage_move_result['stageid'] = '';
                            }
                            $stage_move_result['article_id'] = $this->encrypt_data($article_basics->art_id);
                        }
                        // success message while article not moved to next stage due to waiting form parallel stage completion (Bug #1009	manage parallel stage decision buttons and stage info modal window)
                        elseif (isset($stage_move_result['action']) && $stage_move_result['action'] == 'incomplete_parallel_stages' && $privileged_user == true) {
                            $mode = 'hold';
                        }
                        $stage_move_result['mode'] = $mode;

                        $redirect_to = 'dashboard';
                        if(!empty($stage_id))
                        {
                        $current_stage_detials = Article_flow::get_stage_details('aflw_id=' . $stage_id, 'aflw_id,jwf_stage_type,jwf_id,aflw_status,aflw_usr_id,jwf_stage_name,jwf_role_id,jwf_assignment,jwf_parent_user_roles,jwf_who_can_invite,jwf_child_stages,aflw_parent_flow_id,art_artp_id');
                        $data =  array();
                        $assigned_roles = $user_roles['role_id'];
                        $jwf_parent_user_roles = json_decode($current_stage_detials->jwf_parent_user_roles, true);
                        $jwf_who_can_invite = json_decode($current_stage_detials->jwf_who_can_invite, true);
                        $jwf_role_id = $current_stage_detials->jwf_role_id;
                        if (!empty(array_intersect($assigned_roles, $jwf_parent_user_roles)) || !empty(array_intersect($assigned_roles, $jwf_who_can_invite)) || (in_array($jwf_role_id, $assigned_roles) && ($current_stage_detials->aflw_usr_id== null || $current_stage_detials->aflw_usr_id == $this->current_user['user_id']))) {
                            $redirect_to = 'next task';
                        }
                        }
                        $stage_move_result['redirect_to'] = $redirect_to;

                        //Modification based on the bug IET0111
                        if ($isauthor == false) {
                            //Task#366-Generic solution to switch on/off popup after completing a step---starts
                            $show_modal = true;
                            $manage_popup_on_completion = $this->current_client->functionality->cfty_manage_popup_on_completion;
                            if (isset($manage_popup_on_completion) && ($manage_popup_on_completion == 'y') && isset($article_basics) && $article_basics->jwf_enable_popup_after_completion == 'n') {
                                //$show_modal = 'redirect';
                                $show_modal = false;
                            }
                            $stage_move_result['show_modal'] = $show_modal;
                            if($isreviewer==true && $article_basics->jwf_assignment == 'invitation')
                            {
                                $stage_move_result['show_modal'] = false;
                                $msg = customTrans('viewarticle.thanks_status') . $article_basics->jwf_stage_name;
                                if ($publons_msg != '')
                                    $msg .= " and " . $publons_msg;
                                $stage_move_result['message'] = $msg;
                            }
                        }
                        //if stage submitted user (eg: reviewer) has no privilage exist in current stage completed mode
                        else {
                            //$redirection_link = $this->session->userdata('redirect_after_stage_completion');
                            if ($article_basics->jwf_stage_type == 'resubmission') {

                                $stage_move_result['jwf_stage_type'] = $article_basics->jwf_stage_type;
                                $stage_move_result['resubmission_complted_msg'] = customTrans('viewarticle.artcle-resubmission-success');
                            }
                            $stage_move_result['show_modal'] = false;
                        }
                    }
                    elseif($new_article_id!='' && $data_choice == 'resubmission')
                    {
                        $stage_move_result['article_id'] = $this->encrypt_data($new_article_id);
                        $stage_move_result['insert_stage_id'] = $this->encrypt_data($art_flow_id);
                        $stage_move_result['action'] = 'moved_to_next';
                        if(isset($post_data['es_article']) && $post_data['es_article'] == true)
                        {
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            $stage_move_result['es_url'] = $es_api_data['api_url'];
                        }
                    }
                    /*if ($article_basics->jwf_stage_type == "review" && $stage_role->role_assigned_role == "reviewer")
                    {
                         //Feature #1516 IN the case of orcid integration
                        if ($this->current_client->functionality->cfty_review_to_orcid == 'y' && $this->current_client->modules->mdl_orcid == 'y')
                        {
                            $user_jnl_orcid_with_oldreview = $this->User_to_journal_orcid_details->get_single_record('ujo_update_reviews', array(
                                'ujo_usr_id' => $this->current_user['user_id'],
                                'ujo_jnl_id' => $this->jnl_data->jnl_id
                            ));
                            $update_review_with_profile = false;
                            if (isset($user_jnl_orcid_with_oldreview->ujo_update_reviews) && $user_jnl_orcid_with_oldreview->ujo_update_reviews == 'y')
                                $update_review_with_profile = true;

                            if ($update_review_with_profile == true)
                            {
                                $redirection_link = base_url('journal/' . $cur_journal_record->jnl_journal_code . '/' . $url_segmnt . '?' . encrypt_link('article_id=' . $article_id . '&status_id=' . $current_status_id));
                            }
                        }
                        else
                        {
                            $redirection_link = base_url('journal/' . $cur_journal_record->jnl_journal_code);
                        }
                        $this->session->set_userdata('review_complted_msg', $msg);
                        $this->session->set_flashdata('msg', json_encode(array(
                            'alert' => 'success',
                            'msg' => $msg)));

                        $stage_move_result['msg']=$msg;
                    }*/
                    if(isset($stage_move_result) && isset($stage_move_result['action']) && ($stage_move_result['action'] == 'moved_to_next' || $stage_move_result['action'] == 'incomplete_parallel_stages') && $article_basics->art_es_document_status == 'y')
                    {
                        $esarray['article_id']=$article_basics->art_id;
                        $checkdata=$this->check_espermission_access($esarray);
                        //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $article_basics->art_es_document_status !== 'n')
                        if($checkdata==true)
                        {
                            $message_to_rvrite =customTrans('viewarticle.stage_completed_rvrite');
                            $message_to_rvrite = str_replace('##STAGE_NAME##', $article_basics->jwf_stage_name,$message_to_rvrite);
                            $stage_move_result['message_to_rvrite'] = $message_to_rvrite;
                            /*$es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            if(isset($es_api_data['send_back_to_review']))
                            {
                                $apiUrl = $es_api_data['send_back_to_review'];
                                $data_to_editor = array('art_id' => $article_basics->art_id);
                                $data_to_editor = http_build_query($data_to_editor);
                                $response = $this->es_curl_request($apiUrl,$data_to_editor);
                                $response = json_decode($response);
                            }*/
                        }
                    }
                     return  ['status' => 'Success','data' => $stage_move_result];
                }
               // DB::commit();
            }
        }catch(Exception $e){
           // echo '<pre>'; print_r($e);
                DB::rollback();
                Log::warning($e->getTraceAsString());
                return ['status' => 'Failed', 'data' => $e];
            }
    }
    //*** used to start a stage and move article to next stage when the it's in progress status end ***/

    public function set_movenextstage_action(Request $request) {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'role_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ?  Rv_decrypt($post_data['art_flow_id']) : '';
            $platform_id = isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $role_id = isset($post_data['role_id']) ? Rv_decrypt($post_data['role_id']) : '';
            $this->current_user = $this->get_current_user_details();
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' ) {
                $return_array['conference'] = true;
                $Article_next_task = new \App\Models\Article_next_task();

                $criteria = "ant_type= 'd' AND ant_jnl_id=? AND ant_usr_id=? AND ant_role_id=? ";
                $bind_arr[]=$platform_id;
                $bind_arr[]=$this->current_user['user_id'];
                $bind_arr[]=$role_id;
                $Next_task_conferancearray = $Article_next_task::get_single_record('*',$criteria,null,'',null,$bind_arr);
                if(!empty($Next_task_conferancearray)) {

                    if(isset($Next_task_conferancearray->ant_article_list) && $Next_task_conferancearray->ant_article_list!=null){
                        $artlistarray=json_decode($Next_task_conferancearray->ant_article_list,true);
                        //$collection = collect($artlistarray);




                    }

                    if(isset($Next_task_conferancearray->ant_articlecomplete_list) && $Next_task_conferancearray->ant_articlecomplete_list!=null){
                        $artlistarray=json_decode($Next_task_conferancearray->ant_articlecomplete_list,true);
                        $collection = collect($artlistarray);
                        $collectionAll = collect($artlistarray);
                        foreach ($artlistarray as $key => $values) {
                            //echo "Key: $key\n";
                            foreach ($values as $value) {
                                //echo "Value: $value\n";
                                $collectionAll->push($key.'^^'.$value);
                            }
                        }
                        // Check if the collection contains the array
                        $contains = $collectionAll->contains(function ($item) use ($art_id,$art_flow_id) {
                            return $item == $art_id.'^^'.$art_flow_id;
                        });
                        if(!$contains){
                        // Check if the key exists
                        if ($collection->has($art_id)) {
                            // Push the new value into the existing array
                            $collection = $collection->map(function ($values, $key) use ($art_flow_id, $art_id) {
                                if ($key == $art_id) {
                                    $values[] = $art_flow_id;
                                }
                                return $values;
                            });
                        } else {
                            // Add a new key-value pair if the key does not exist
                            $collection->put($art_id, [$art_flow_id]);
                        }
                        $data=array();
                        $current_userid=$this->current_user['user_id'];
                        $criteria =" ant_type='d' and ant_jnl_id ={$platform_id} and ant_usr_id ={$current_userid} and ant_role_id ={$role_id} ";
                        $data['ant_articlecomplete_list'] = json_encode($collection->all());
                        $Article_next_task::update_record($data, $criteria, $this->current_user);
                        }


                    }else {
                        $collection = collect([]);
                        $collection->put($art_id, [$art_flow_id]);
                        $data=array();
                        $current_userid=$this->current_user['user_id'];
                        $criteria =" ant_type='d' and ant_jnl_id ={$platform_id} and ant_usr_id ={$current_userid} and ant_role_id ={$role_id} ";
                        $data['ant_articlecomplete_list'] = json_encode($collection->all());
                        $Article_next_task::update_record($data, $criteria, $this->current_user);

                    }
                    $return_array['msg']='success';
                    return  $this->success('Success', 200, $return_array);

            }
        }

        } catch(Exception $e){
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function update_transactionid(Request $request)
    {
        try {
            $post_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
            $transaction_id = isset($post_data['transaction_id']) ?  ($post_data['transaction_id']) : '';
            if(!empty($art_id) && !empty($transaction_id))
            {
                $Payment_order = new \App\Models\Payment_order();
                $update_condition   =   "pmt_ord_art_id = {$art_id}";
                $update_arr = array(
                   'pmt_ord_price' => NULL,
					'pmt_ord_tax_amount' => NULL,
					'pmt_ord_discount'  =>NULL,
					'pmt_ord_netamount' =>NULL,
					'pmt_ord_currency'  =>NULL,
					'pmt_ord_payment_method'=>NULL,
					'pmt_ord_order_date' =>NULL,
					'pmt_ord_completed_date'=>NULL,
					'pmt_transaction_status'=>NULL,
					'pmt_ord_transaction_id'=>$transaction_id
                );
                $updated_result = $Payment_order::update_record($update_arr,$update_condition,$this->current_user);
                if($updated_result){
                    $return_array['msg']='success';
                    return  $this->success('Success', 200, $return_array);
                }else
                {
                    $return_array['msg']='failed';
                    return  $this->failure('Failure', 200, $return_array);
                 }
            }
            else
         {
            return $this->warning('Warnings',200,array('msg' => 'article id empty'));
        }
        }catch(Exception $e){
            return  $this->failure('Failed', 500, $e);
        }

    }
    //*** used to display next stage buttons starts***/
    public function get_nextstage_action_buttons(Request $request)
    {
        try {
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            //$Roles = new \App\Models\Roles();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $return_array['next_stage_button']=array();
            $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ?  Rv_decrypt($post_data['art_flow_id']) : '';
            $platform_id = isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $version = isset($post_data['version']) ? $post_data['version'] : '';
            $segment = isset($post_data['segment']) ? $post_data['segment'] : '';
            $decision = isset($post_data['decision']) ? $post_data['decision'] : array();
            $role_id = isset($post_data['role_id']) ? Rv_decrypt($post_data['role_id']) : '';
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {
                $tables = [
                'main_table' => (new Article_flow())->getTable(),
                'join_table' => [(new Generic_flows())->getTable() => ['jwf_id','aflw_jwf_id']]
                ];
                $enable_payment = Article_flow::get_results_using_joins($tables,'jwf_enable_payment,jwf_stage_type','aflw_id = ?','single',binding_arr:[$art_flow_id]);
                if ($enable_payment->jwf_enable_payment == 'y' && $enable_payment->jwf_stage_type = 'revision') {
                $pmnt_tbl = new \App\Models\Payment_order;
                $payment_status = $pmnt_tbl::get_single_record('count(pmt_ord_id) as cnt','pmt_ord_aflw_id =?',binding_arr:[$art_flow_id]);
                if ($payment_status->cnt < 1) {
                return $this->warning('warning',200,'Please make payment');
                }
                }
                }
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($platform_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $platform_id = $platform_data->jnl_id;
            }

            $select_article_details = 'art_id,art_artp_id,art_code,art_title,art_abstract,art_resubmission_no,art_status,art_submission_date,art_doi,art_submitted_by,art_stage_submission_method,artp_article_type,art_published_article_type,art_article_upload_path,art_transfer_status,art_skipped_assignment_roles,art_delete_status,art_publication_issue,jwf_status_name,jnl_journal_name,artp_fwm_id,art_stage_submission_method,auth_usr_id,aflw_id,jnl_id,jnl_journal_code,artp_id,jwf_assignment,aflw_parent_flow_id,aflw_status,aflw_usr_id,art_status,jwf_stage_type,jwf_who_can_invite,jwf_parent_user_roles,aflw_skip_review,aflw_reopened_min_user_count,jwf_fwm_id,jwf_stage_name,jwf_fwm_id,aflw_level,jwf_parent_stages,jwf_enable_transfer,jwf_role_id,aflw_jwf_id,jwf_connect_to_es,aflw_usr_id,jwf_flow_proceed_type,jwf_id,artp_abbr_article_type,jwf_button_title,art_prev_article_id,art_es_document_status,aflw_stage_min_users';
            $group_by = 'aflw_id';
            $condition = "aflw_art_id=:art_id and jnl_id=:jnl_id and auth_corr_author=:authorstatus";
            $condition_arr=array(
                'art_id' => $art_id,
                'jnl_id'=>$platform_id,
                'authorstatus'=>'y'
            );
            if (!empty($art_flow_id)) {
                $condition .= " and aflw_id=:aflw_id";
                $condition_arr=array(
                    'art_id' => $art_id,
                    'jnl_id'=>$platform_id,
                    'authorstatus'=>'y',
                    'aflw_id'=>$art_flow_id
                );
            }
            $basicdata = Articles::get_article_details($select_article_details, $condition, null, true, true, $group_by,$condition_arr);
            $this->current_user = $this->get_current_user_details();
            $array_data = array();
            if (!empty($basicdata) && isset($basicdata[0])) {
                $article_basic = $basicdata[0];
                $article_basics = json_decode(json_encode($article_basic), false);
                $article_privilages = $this->article_privilages($article_basics, $article_basics->aflw_id, $article_basics->jnl_journal_code);
                $array_data['article_data'] = $article_basics;
                $array_data['article_privilages'] = $article_privilages;
                $select = "jp_edit_articles,jp_reset_article,jp_rescind_article,jp_transfer_article,atotp_review_open_decision,jp_reinstantiate_payment,jp_move_article_from_payment,jp_edit_article_files";
                $condition = "artp_id={$article_basics->art_artp_id}";
                $option_settings = $this->get_article_type_permission($select, $condition);

                $array_data['article_type_advance'] = $option_settings;
                $user_roles = $this->validate_user_journal($article_basics->jnl_journal_code, $this->current_user['user_id'], $article_basics->art_artp_id);
                if($version == "current")
                {
                $check_user_permission =$this->checkuserhaspermission($article_privilages,$user_roles,$article_basics,$this->current_user['user_id'],$platform_id,$jnlcode);

                if($check_user_permission==false)
                {
                    return  $this->warning('Failed', 200, "permission_denied");
                }
                }
                $array_data['user_roles'] = $user_roles;
                $array_data['current_status_id'] = $article_basics->aflw_id;
                $array_data['trans_started'] = true;
                $condition = 'role_id=:role_id';
                $stage_role = Roles::get_single_record('role_id,role_name,role_assigned_role', $condition,null,'',null,array('role_id'=>$article_basics->jwf_role_id));
                $array_data['stage_role'] = $stage_role;
                $array_data['segment'] = $segment;
                $array_data['decision'] = $decision;
                $array_data['jnlcode'] = $jnlcode;
                $array_data['role_id'] = $role_id;
                $next_stage_button = $this->get_next_stage_buttons($array_data);
                // TASK #8653  Copy edit module Is On author can view copy edit stage
                $return_array['copyedit'] = false;

                if (isset($this->current_client->modules->mdl_copyedit) && $this->current_client->modules->mdl_copyedit == 'y' )  {
                    $flow_data = (new Article_flow())->select('aflw_id', 'aflw_status')->whereHas('journal_workflow', function ($query) {$query->where('jwf_stage_type', 'publish'); })->where('aflw_status', 'c') ->where('aflw_art_id', $art_id)->first()?->toArray();
                    if(!empty($flow_data)){
                        $btn_conference = collect([]);
                        $next_stage_button_conference = collect([]);
                        // ->select(DB::raw('paf_id,paf_art_id,paf_aflw_id,paf_file_name'))
                        $resultproduction = DB::table('rvw_production_attachment_files AS prod_attach')                            
                            ->select(DB::raw('GROUP_CONCAT(paf_id) as paf_ids,paf_art_id,paf_aflw_id'))
                            ->join('rvw_attachment_file_description AS file_desc', 'prod_attach.paf_description_id', '=', 'file_desc.afdec_id')
                            ->where('file_desc.afdec_attach_to_author', 'y')
                            ->where('prod_attach.paf_art_id', $art_id)
                            ->whereIn('prod_attach.paf_aflw_id', function($query) use ($art_id) {
                                $query->select(DB::raw('MAX(paf_aflw_id)'))
                                    ->from('rvw_production_attachment_files')
                                    ->join('rvw_attachment_file_description', 'afdec_id', '=', 'paf_description_id')
                                    ->join('rvw_article_flow', 'paf_aflw_id', '=', 'aflw_id')
                                    ->where('paf_art_id', $art_id)
                                    ->where('afdec_attach_to_author', 'y');
                                })
                            ->first();



                            if($resultproduction){
                                $array_en =array();
                                $array = explode(",", $resultproduction->paf_ids);
                                foreach ($array as $item) {
                                    array_push($array_en,$this->encrypt_data($item));
                                }
                                
                                $return_array['copyedit'] = true;
                                $btn_conference->push((object)['id' => 1, 'label' => 'Download file', 'className'=>'btn-success mr-2','type'=>'b','name'=>'downloadfile','path_url'=>'','copyedit_art_id'=>$this->encrypt_data($art_id),'copyedit_flow_id'=>$this->encrypt_data($resultproduction->paf_aflw_id),
                                'copyedit_paf_id'=>$array_en,
                                'attach_type'=>'ps',
                                'file_name'=>'Copyedit_'.$article_basics->art_code.'.zip'
                            ]);

                                // Merge the objects into the collection
                                $next_stage_button_conference = $next_stage_button_conference->merge($btn_conference);

                                $return_array['next_stage_button_copyedit'] = $next_stage_button_conference;
    
                            }

                     
                    
                    }
                }



                if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' && !empty($next_stage_button) && is_array($next_stage_button) && $role_id!='') {
                    $return_array['conference'] = false;
                    $condition=array("role_id"=>$role_id);
                    $role_data=Roles::get_single_record_with_bind_cond('role_assigned_role',$condition);
                    $non_prev=array('author','reviewer');
                    if(!empty($role_data)) {
                        if (!in_array($role_data->role_assigned_role,$non_prev)) {
                            $return_array['conference'] = true;
                        }
                    }

                    $Article_next_task = new \App\Models\Article_next_task();
                    $Journals = new \App\Models\Journals();

                    $condition=array("jnl_journal_code"=>$jnlcode);
                    $jnl_data=$Journals::get_single_record_with_bind_cond('*',$condition);

                    // next controller function
                    $controller = new Manage_Dashboard_Api();
                    $decisionmenu_array['menu_links']=$controller->left_menu_links($jnl_data,$this->current_user['user_id'],$role_id);


                    $criteria = "ant_type= 'd' AND ant_jnl_id=? AND ant_usr_id=? AND ant_role_id=? ";
                    $bind_arr[]=$platform_id;
                    $bind_arr[]=$this->current_user['user_id'];
                    $bind_arr[]=$role_id;
                    $Next_task_conferancearray = $Article_next_task::get_single_record('*',$criteria,null,'',null,$bind_arr);

                    if(!empty($Next_task_conferancearray)) {
                        $return_array['conference_jnl'] = $platform_id;
                        $return_array['conference_usrid'] = $this->current_user['user_id'];
                        $return_array['conference_role'] = $role_id;
                        $artlistarray=json_decode($Next_task_conferancearray->ant_article_list,true);
                        $artlistcompletearray=array();



                    //print_r($artlistarray);die;
                    $next_artid='';
                    $next_flowid='';
                    $movenext_btn_status=false;
                    $collection = collect([]);
                    $collection_complete = collect([]);
                    $btn_conference = collect([]);
                    $next_stage_button_conference = collect([]);
                    foreach ($artlistarray as $key => $values) {
                        //echo "Key: $key\n";
                        foreach ($values as $value) {
                            //echo "Value: $value\n";
                            $collection->push($key.'^^'.$value);
                        }
                    }


                    if(isset($Next_task_conferancearray->ant_articlecomplete_list) && $Next_task_conferancearray->ant_articlecomplete_list!=null){
                        $artlistcompletearray=json_decode($Next_task_conferancearray->ant_articlecomplete_list,true);
                        foreach ($artlistcompletearray as $key => $values) {
                            //echo "Key: $key\n";
                            foreach ($values as $value) {
                                //echo "Value: $value\n";
                                $collection_complete->push($key.'^^'.$value);
                            }
                        }

                        // Check if the collection contains the array
                        $contains = $collection_complete->contains(function ($item) use ($art_id,$art_flow_id) {
                            return $item == $art_id.'^^'.$art_flow_id;
                        });
                        $movenext_btn_status=$contains;
                    }


                    if(count($artlistarray)>0) {
                        // Loop through each key-value pair
                        foreach ($artlistarray as $key => $values) {
                            // Check if the value 456 exists in the array
                            if (($index = array_search($art_flow_id, $values)) !== false) {
                                // Remove the value 456 from the array
                                unset($artlistarray[$key][$index]);
                                if($art_id==$key && count($artlistarray[$key])==0){
                                //echo count($array[$key]);
                                    unset($artlistarray[$key]);
                                } else{
                                    // Re-index the array to remove any gaps in the indices
                                    $artlistarray[$key] = array_values($artlistarray[$key]);
                                }
                            }
                        }
                        $data=array();
                        $current_userid=$this->current_user['user_id'];
                        $criteria =" ant_type='d' and ant_jnl_id ={$platform_id} and ant_usr_id ={$current_userid} and ant_role_id ={$role_id} ";
                        $data['ant_article_list'] = json_encode($artlistarray);
                        $Article_next_task::update_record($data, $criteria, $this->current_user);

                        //$query = DB::getQueryLog();

                    }

                    // Remove the value if it exists
                    $collection = $collection->reject(function ($value) use ($art_id,$art_flow_id) {
                        return $value === $art_id.'^^'.$art_flow_id;
                    });

                    $count = $collection->count();

                    if($movenext_btn_status==true || $count==0) {
                        $btn_conference->push((object)['id' => 1, 'label' => 'Go to dashboard', 'className'=>'btn-success mr-2','type'=>'b','name'=>'goto_dashboard','path_url'=>'']);
                    }

                    $abstract_added_to_queue    =   '';
                    if (isset($decisionmenu_array['menu_links'])&&is_array($decisionmenu_array['menu_links'])&&in_array('batch_decision_assignment',$decisionmenu_array['menu_links'])) {
                        $article_redirect_decision_link ='/decision';
                        $btn_conference->push((object)['id' => 2, 'label' => 'Go to batch decision page', 'className'=>'btn-primary mr-2','type'=>'b','name'=>'goto_decision','path_url'=>$article_redirect_decision_link]);
                    } else {
                        $abstract_added_to_queue    =   'Abstract has been added to the batch decision queue';
                    }
                    $return_array['abstract_added_to_queue'] = $abstract_added_to_queue;

                    if($movenext_btn_status==false){
                        if($count>0) {
                        $first = $collection->first();
                        list($next_artid,$next_flowid)=explode('^^',$first);
                        $article_redirect_link = URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnlcode .'/view-abstract/' . $this->encrypt_data($next_artid) .'/'. $this->encrypt_data($next_flowid) ;
                        // $article_redirect_link = '/'. $this->current_client->platform_type.'/'. $jnlcode .'/view-abstract/' . $this->encrypt_data($next_artid) .'/'. $this->encrypt_data($next_flowid) ;
                        //$article_redirect_link = '/view-abstract/' . $this->encrypt_data($next_artid) .'/'. $this->encrypt_data($next_flowid);
                        $btn_conference->push((object)['id' => 3, 'label' => 'Move to next task', 'className'=>'btn-success mr-2','type'=>'b','name'=>'move_tonext_task','path_url'=>$article_redirect_link]);
                        }
                    }

                    // Merge the objects into the collection
                    $next_stage_button_conference = $next_stage_button_conference->merge($btn_conference);

                    $return_array['next_stage_button_conference'] = $next_stage_button_conference;

                    // $query = DB::getQueryLog();
                    // $query = end($query);
                    // print_r($query);exit;
                }
                }
                $transit_msg ='';
                if (!empty($next_stage_button) && is_array($next_stage_button)) {
                    $return_array['next_stage_button'] = $next_stage_button;
                }
                elseif($next_stage_button == 'transit_msg')
                {
                    $transit_msg=customTrans('viewarticle.article_transit_stage_warning');
                }
                $return_array['transit_msg'] = $transit_msg;
                $return_array['article_basic'] = $article_basic;
                $return_array['client_functionality'] = $this->current_client->functionality;
                $required_descrip_arr =[];
                $Required_file_type = new \App\Models\Required_file_type();
                $fileDescriptionSettings=Config::get('clients.'.$this->current_client->clnt_client_code.'.upload_file_description_settings.file_description');
                $file_desc_condition = '';
                if($article_basic->art_prev_article_id == null)
                {
                    $file_desc_condition = ' AND afdec_description_type !=\'r\'';
                }
                else
                {
                    $file_desc_condition = ' AND afdec_description_type !=\'o\'';
                }
                $attach_file_description = $Required_file_type::get_file_description('afdec_id,afdec_description,afdec_exclude_file,afdec_description_type,afdec_file_type_id,rft_file_desp_id,rft_req_count,rft_req_fld', "rft_artp_id={$article_basics->art_artp_id}".$file_desc_condition);
                // print_r($file_type_data);die;
                $author_role = Roles::get_single_record('role_id',"role_assigned_role='author'");
                $Article_type_table = new \App\Models\Article_types();
                $article_type_data =$Article_type_table::get_single_record('artp_fwm_id','artp_id='.$article_basics->art_artp_id);
                $artp_fwm_id = $article_type_data->artp_fwm_id;
                $condition = "jwf_role_id=".$author_role->role_id." AND jwf_article_attachment_status ='y' AND jwf_fwm_id = ".$artp_fwm_id." AND jwf_stage_type!='transit'";
                $stage_attachment_status = Generic_flows::get_all_records_with_bind_cond('jwf_stage_name,jwf_role_id,jwf_article_attachment_status', array(), $condition);
                if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' && count($stage_attachment_status) > 0)
                {
                    foreach ($attach_file_description as $val) {

                        if($val->rft_req_fld == 'y' && $fileDescriptionSettings['required_descriptions'] == true){
                            $required_descrip_arr[] = array('afdec_id' => $val->afdec_id,'afdec_description' => $val->afdec_description);
                        }
                    }
                }
                $return_array['required_descrip_arr'] = $required_descrip_arr;
                $filelables=[];
                $pdf_review_cndition = "atmnt_art_id={$art_id}";
                //$pdf_review_cndition .= " AND atmnt_designated_to like '%r%' ";
                $all_review_files = Attachment_files::get_all_records('atmnt_label', $pdf_review_cndition, 'atmnt_order');
                foreach ($all_review_files as $val) {
                   $filelables[] =$val->atmnt_label;
                }
                $return_array['filelables'] = $filelables;
                
                $es_pdfgenerate_flag=false;
                $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                $espdf_array_check   = Config::get($client_default);
                if(isset($espdf_array_check['es_pdfgenerate_flag']))
                {
                    $es_pdfgenerate_flag=$espdf_array_check['es_pdfgenerate_flag'];
                }
                $return_array['es_pdfgenerate_flag'] = $es_pdfgenerate_flag;
                if(!empty($art_id))
                {
                    $esarray['article_id']=$art_id;
                    $checkdata=$this->check_espermission_access($esarray);
                    $return_array['es_enable'] = $checkdata;
                }
                return  $this->success('Success', 200, $return_array);
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** used to display next stage buttons ends ***/

    //*** used to display the current stage details starts ***/
    public function get_stage_details(Request $request)
    {
        try {
            $return_array = array();
            $Generic_forms = new \App\Models\Generic_forms();
            $Article_Rating = new \App\Models\Article_rating();
            $article_flow_table = (new \App\Models\Article_flow())->getTable();
            $Form_edithistory_table = (new \App\Models\Form_edithistory())->getTable();
            $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
            $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
                    
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'roleid' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ?  Rv_decrypt($post_data['art_flow_id']) : '';
            $platform_id = isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $roleid = isset($post_data['roleid']) ? Rv_decrypt($post_data['roleid']) : '';
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($platform_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $platform_id = $platform_data->jnl_id;
            }
            //Task:8005 Correction in Completed form edit - correction
            $editformcmt = false;
            if (isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
            {
                $editformcmt = true;
                $date_format = $this->get_platform_date_format($platform_id);
                $date_format = $this->date_format_map($date_format);
            }
            
            $review_to_orcid = false;
            $remove_tab_andform=true;
            $this->current_user = $this->get_current_user_details();
            $override_access = $this->is_access_overriding_user($jnlcode, $this->current_user['user_id'], $art_flow_id);
            if (!empty($art_flow_id)) {

                $condition = "aflw_id=:art_flow_id and jwf_stage_type!=:jwf_stage_type";
                $condition_arr = array('art_flow_id'=>$art_flow_id,'jwf_stage_type'=>"author_submission");
                $select="jwf_child_stages,aflw_level,jwf_flow_proceed_type,art_delete_status,aflw_stage_repeat_count,aflw_art_id,artp_jpm_id,jnl_id,jnl_journal_code,aflw_status,aflw_posted_by,aflw_usr_id,aflw_id,aflw_jwf_id,jwf_id,jwf_stage_name,jwf_stage_type,jwf_forms,artp_id,art_id,art_status,art_submitted_by,art_title,artp_id,artp_article_type,artp_fwm_id,jwf_role_id,jwf_tab_name,jwf_parent_user_roles,aflw_skip_review,jwf_who_can_invite,jwf_role_id,jwf_status_name,jwf_assignment,aflw_parent_flow_id,jwf_production_upload,art_transfer_article,jwf_enable_payment,jwf_scroll_viewarticle,jwf_enable_research_integrity,aflw_reviewer_added_by_stage_status";
                $flowdetails = Articles::get_article_details( $select, $condition, null, false,true,null,$condition_arr);
                if (!empty($flowdetails) && isset($flowdetails[0])) {
                    $flow_data = $flowdetails[0];
                    /* Task #1447 taskbot-The review form is visible to the reviewer even when the article is in the pre-review stage. */
                    if($flow_data->aflw_reviewer_added_by_stage_status == 'p')
                    {
                        return;
                    }
                    /*if($flow_data->aflw_usr_id != $this->current_user['user_id'] && $flow_data->jwf_assignment == "manual" && $flow_data->aflw_parent_flow_id!=null && $flow_data->aflw_status == 'a') 
                    {
                        $condition_arr = array('art_flow_id'=>$flow_data->aflw_parent_flow_id);
                        $flowdetails = Articles::get_article_details( $select, $condition, null, false,true,null,$condition_arr);
                        $flow_data = $flowdetails[0];
                    }*/
                    // TASK #7649 under review author single and double blind bug fix
                    $article_privilages = $this->article_privilages($flow_data, $flow_data->aflw_id, $flow_data->jnl_journal_code);
                    if($article_privilages['author'] == true && $flow_data->aflw_status == 'w')
                    {
                        return  $this->success('Success', 200, $return_array);
                    }
                    $flow_data->remove_unwanted_tab=$remove_tab_andform; // to do
                    if($flow_data->jwf_stage_type=="author_submission" && $flow_data->aflw_status!='c' && $article_privilages['author'] == false  && isset($this->current_client->functionality->submission_inprogress_view_article) &&$this->current_client->functionality->submission_inprogress_view_article == 'n' ) 
                    {
                        $return_array["status"]=customTrans('viewarticle.user_permission_denied');
                        return  $this->warning('Warnings',200,$return_array,'warning');
                    }
                    elseif($flow_data->jwf_stage_type == "review" && empty($flow_data->aflw_parent_flow_id) && $article_privilages['reviewer'] == true && $article_privilages['user_allocated'] == false )
                    {
                        $return_array["status"]="lost_privilage";
                        $return_array["message"]=customTrans('viewarticle.user_lost_permission_temp');
                        if(isset($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer) && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                        $return_array["message"]=customTrans('viewarticle.user_lost_permission_completely');
                        return  $this->warning('Warnings',200,$return_array,'warning');
                    }
                    
                    if ($this->current_client->modules->mdl_orcid == 'y' && $this->current_client->functionality->cfty_review_to_orcid == 'y' && $flow_data->jwf_stage_type == 'review') {
                        $review_to_orcid = true;
                    }
                    if($flow_data->jwf_assignment=="invitation" && $flow_data->aflw_parent_flow_id!='' && $flow_data->aflw_reviewer_added_by_stage_status!='p')
                    {
                        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                        $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                        $gen_sql="select jwf_assignment from ".$Generic_flows_table." left join ". $Article_flow_table." on jwf_id=aflw_jwf_id where aflw_id=". $flow_data->aflw_parent_flow_id;
                        $parentrecord=Article_flow::get_records_by_raw_query($gen_sql);
                        if(!empty($parentrecord) && (isset($parentrecord[0]->jwf_assignment) && $parentrecord[0] ->jwf_assignment!='invitation' && $parentrecord[0] ->jwf_assignment!='manual'))
                        {
                            $return_array["status"]=customTrans('viewarticle.user_permission_denied');
                            return  $this->warning('Warnings',200,$return_array,'warning');
                        }
                    }

                    //3313 Editing forms after stage complete
                    $return_array['edit_article_forms_flag'] = $this->iscmptformEdituser($art_id,$flow_data->artp_id);

                    //Feature#1804 similarity check list for current article
                    $return_array['duplicate_check_show']=false;
                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow  = Config::get($workflow_config);
                    //print_r($review_flow);
                    $stagetypepermission = isset($review_flow[$flow_data->jwf_stage_type]['permission'])?$review_flow[$flow_data->jwf_stage_type]['permission']:[];
            		if(isset($stagetypepermission)&&((in_array('duplicate_check', $stagetypepermission) === true))) {
                        $return_array['duplicate_check_show']=true;
                    }
                    //END Feature#1804 similarity check list for current article

                    // TASK #7649 under review author single and double blind bug fix comment this code 
                    //$article_privilages = $this->article_privilages($flow_data, $flow_data->aflw_id, $flow_data->jnl_journal_code);
                    if($article_privilages['privilaged'] == true && $article_privilages['reviewer'] == false && $flow_data->jwf_assignment == 'invitation' && $flow_data->aflw_usr_id != $this->current_user['user_id'] && !empty($flow_data->aflw_parent_flow_id))
                    {
                        $condition_arr = array('art_flow_id'=>$flow_data->aflw_parent_flow_id,'jwf_stage_type'=>"author_submission");
                        //$condition = 'aflw_id=' . $flow_data->aflw_parent_flow_id;
                        $flowdetails = Articles::get_article_details($select, $condition, null, false,false,null,$condition_arr);
                        $flow_data = $flowdetails[0];
                    }
                    
                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow  = Config::get($workflow_config);
                    $stage_flow = $review_flow[$flow_data->jwf_stage_type];
                    $stage_for =$stage_flow['stage_for'];
                    $production_stage =(isset($stage_for) && $stage_for=="review")?false:true;
                    $return_array['production_stage'] =$production_stage;

                    $auto_scroll = false;
                    if (isset($this->current_client->functionality->cfty_view_article_autoscroll) && $this->current_client->functionality->cfty_view_article_autoscroll == 'y')
                    {
                        $auto_scroll = true;
                    }
                    if(isset($flow_data->jwf_scroll_viewarticle) && $flow_data->jwf_scroll_viewarticle == 'y' && $auto_scroll == false)
                    {
                        if($flow_data->aflw_status == 'a' && $flow_data->aflw_usr_id == $this->current_user['user_id'])
                        {
                            $auto_scroll = true;
                        }
                        if($flow_data->aflw_status == 'w' || $flow_data->aflw_status == 'p')
                        {
                            $flow_privilages = $this->get_article_flow_privilages($art_id, $art_flow_id,$jnlcode,$platform_id);
                            $user_roles = $flow_privilages['user_roles'];
                            $article_flow_details = $flow_privilages['article_flow_details'];
                            $user_array_invite_shortlist=$this->get_who_can_shortlist_invite_users($flow_privilages,$art_id,$platform_id,$jnlcode);
                            if($flow_data->aflw_status == 'w')
                            {
                                $date_format=$this->get_platform_date_format($platform_id);
                                $date_format=$this->date_format_map($date_format);
                                $article_data = $flow_privilages['article_data'];
                                $user_roles = $flow_privilages['user_roles'];
                                $all_roles = $flow_privilages['all_roles'];
                                $all_roles = $this->rebuild_array_by_field($all_roles, 'role_id');
                                $is_previous=false;
                                $show_invited = ($article_flow_details->jwf_assignment == 'invitation' ) ? true : false;
                                $assigning_roles = ($article_flow_details->jwf_parent_user_roles != '') ? json_decode($article_flow_details->jwf_parent_user_roles) : array();
                                $inviting_roles = ($article_flow_details->jwf_who_can_invite != '') ? json_decode($article_flow_details->jwf_who_can_invite) : array();
                                $has_assign_permission = $has_invite_permission = false;
                                if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $assigning_roles)) > 0 &&(isset($user_array_invite_shortlist['assigned_user_ids']))&&(in_array($this->current_user['user_id'],$user_array_invite_shortlist['assigned_user_ids'])))
                                {
                                    $has_assign_permission = true;
                                }
                                if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $inviting_roles)) > 0&&(isset($user_array_invite_shortlist['who_can_invite_user_ids']))&&in_array($this->current_user['user_id'],$user_array_invite_shortlist['who_can_invite_user_ids']))
                                {
                                    $has_invite_permission = true;
                                }
                                $current_status_id= $art_flow_id;
                
                                $current_stage_active = ($current_status_id == $article_flow_details->aflw_id) ? true : false;
                                $enable_active = false;
                                if($this->current_client->modules->mdl_review_for_doc == 'n')
                                {
                                    if ($article_flow_details->aflw_status == 'c')
                                    {
                                        if ($article_data->atotp_review_open_decision == "y")
                                        {
                    
                                            $return_date = $article_flow_details->aflw_returned_date;
                                            $added_date = date('Y-m-d h:i:s', strtotime($return_date . ' +' . $article_data->atotp_review_open_count . ' days'));
                                            $current_date = date('Y-m-d h:i:s');
                    
                                            $date1 = new DateTime($current_date);
                                            $date2 = new DateTime($added_date);
                    
                                            if ($date1 > $date2)
                                            {
                                                $enable_active = false;
                                            }
                                        }
                                        else
                                        {
                                            $enable_active = false;
                                        }
                                    }
                                    if ($article_data->art_status != "y" || $is_previous === true)
                                    {
                                        $enable_active = false;
                                    }
                                    if (($article_flow_details->jwf_fwm_id != $article_data->artp_fwm_id) || ($article_data->art_status == 't'))
                                    {
                                        $enable_active = false;
                                        $current_stage_active = false;
                                    }
                                }
                                elseif($article_flow_details->aflw_status == 'c')
                                {
                                    $enable_active = false;
                                }
                    
                                if($article_flow_details->aflw_more_review_skip_status == 'y' || $article_flow_details->aflw_skip_review == 'y' )
                                {
                                    $enable_active = false;
                                }
                                $enable_active = false;
                                if ($has_invite_permission === true || $has_assign_permission === true)
                                {
                                    $enable_active = true;
                                }
                                if($enable_active == true && ($has_invite_permission === true || $has_assign_permission === true))
                                {
                                    $auto_scroll = true;
                                }
                            }
                            if($flow_data->aflw_status == 'p')
                            {
                                $check_childs_stages = Article_flow::get_single_record_with_bind_cond('count(aflw_status) as cnt',array('aflw_parent_flow_id' => $art_flow_id));
                                $has_assign_permission = false;
                                $assigning_roles = ($article_flow_details->jwf_parent_user_roles != '') ? json_decode($article_flow_details->jwf_parent_user_roles) : array();
                                if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $assigning_roles)) > 0 &&(isset($user_array_invite_shortlist['assigned_user_ids']))&&(in_array($this->current_user['user_id'],$user_array_invite_shortlist['assigned_user_ids'])))
                                {
                                    $has_assign_permission = true;
                                }
                                if($check_childs_stages->cnt < $article_flow_details->aflw_stage_min_users && $has_assign_permission == true)
                                {
                                    $auto_scroll = true;
                                }
                            }
                        }
                        
                    }
                    $return_array['view_art_autoscroll'] = $auto_scroll;

                    $user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $flow_data->artp_id);
                    $assigned_roles = $user_roles['role_id'];
                    $jwf_parent_user_roles = !empty($flow_data->jwf_parent_user_roles)?json_decode($flow_data->jwf_parent_user_roles, true):array();
                    $jwf_who_can_invite = !empty($flow_data->jwf_who_can_invite)?json_decode($flow_data->jwf_who_can_invite, true):array();
                    $jwf_role_id = $flow_data->jwf_role_id;
                    if($article_privilages['author'] == true && $article_privilages['privilaged'] == false && $flow_data->jwf_stage_type == 'review') {
                        $multiple_label = $flow_data->jwf_stage_name;
                    } elseif ($article_privilages['author'] == true && $article_privilages['privilaged'] == false) {
                        $multiple_label = $flow_data->jwf_stage_name;
                    } else {
                        $multiple_label = $flow_data->jwf_stage_name . " by  ";
                    }
                     $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
                    $article_keywords = Article_keywords::get_article_keywords($art_id, false, false, $hierachy, $platform_id);
                    $return_array['article_keywords']=$article_keywords;
                    $stage_upload = false;
                    $flow_data->allow_file_types = 'zip,pdf';
                    $flow_data->allow_file_size = 20;
                    $flow_data->stage_upload = $stage_upload;
                    if(isset($review_flow[$flow_data->jwf_stage_type]['upload']) && count($review_flow[$flow_data->jwf_stage_type]['upload']) > 0 && $flow_data->jwf_production_upload != 'n')
                    {
                        $stage_upload = true;
                        $flow_data->allow_file_types = implode(',', $review_flow[$flow_data->jwf_stage_type]['upload']);
                        $allow_file_size = UtilityTrait::Utility('rvt_upload_file_sizes')['rvt_upload_file_sizes'];
                        $flow_data->allow_file_size=$allow_file_size['production_mng_each_attachment'];
                        $flow_data->stage_upload = $stage_upload;
                    }
                    $upload_file_size_config = $this->get_uploaded_file_size_config();
                    $flow_data->allow_single_production_file_size=$upload_file_size_config['max_production_single_file_size'];
                    $flow_data->allow_single_production_file_size_in_mb=$upload_file_size_config['max_production_single_file_size_in_mb'];
                    $role_used = $this->RolesConfigdata('privileged_user_roles');
                    $privileged_user_roles = $role_used['privileged_user_roles'];
                     if (!empty(array_intersect($assigned_roles, $jwf_parent_user_roles)) || !empty(array_intersect($assigned_roles, $jwf_who_can_invite)) || in_array($jwf_role_id, $assigned_roles) || (!empty(array_intersect($user_roles['assigned_roles'], $privileged_user_roles)) && (($article_privilages['privilaged'] == true && $article_privilages['reviewer'] == false) || ( $article_privilages['privilaged'] == true && $article_privilages['reviewer'] == true && $article_privilages['user_allocated'] == true))  )) {
                        //echo $flowdetails[0]->jwf_stage_type; die;
                        $condition = 'role_assigned_role!=\'system\'';
                        $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role', $condition);
                        $article_privilages = $this->article_privilages($flow_data, $art_flow_id, $jnlcode);
                        $return_array['article_privilages'] = $article_privilages;
                        /* Roles assigned to this article */
                        $user_array = array();
                        $user_array['user_roles'] = $user_roles;
                        $user_array['article_id'] = $art_id;
                        $user_array['all_roles'] = $all_roles;
                        $user_array['article_privilages'] = $article_privilages;
                        $user_array['jnl_id'] = $platform_id;
                        $user_array['user_id'] = $this->current_user['user_id'];
                        $user_array['art_flow_id'] = $art_flow_id;
                        $user_roles = $this->get_article_user_roles($user_array);
                        $return_array['transfer_data'] = false;
                        if ($flow_data->aflw_status == 'a' && ($flow_data->aflw_usr_id == $this->current_user['user_id'] || $override_access)) {
                            //$Roles = new \App\Models\Roles();
                            //$Assign_permission = new \App\Models\Assign_permission();
                            $forms = json_decode($flow_data->jwf_forms, true);
                            if (!empty($forms)) {
                                $form_data = implode(',', $forms);
                                // $condition = "gncf_id in (" . $form_data . ")";
                                // $generic_forms = $Generic_forms::get_all_records('gncf_id,gncf_form_type,gncf_form_name,gncf_form_title', $condition);

                                $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
                                $sql= "select gncf_id,gncf_form_type,gncf_form_name,gncf_form_title from " . $Generic_forms_table. " where gncf_id in (" . $form_data . ") ORDER by FIELD(gncf_id,".$form_data .")";
                                $generic_forms=Generic_forms::get_records_by_raw_query($sql);
                                $return_array['formdata'] = $generic_forms;
                            } else
                                $return_array['formdata'] = array();
                            $return_array['flowdetails'] = $flow_data;
                            $array_data = array();
                            $array_data['user_id'] = $flow_data->aflw_usr_id;
                            $array_data['journal_id'] = $platform_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = $art_id;
                            $array_data['jnl_code'] = $jnlcode;
                            $array_data['fullname_only'] = false;
                            $user_data = $flow_data->user_data = $this->get_user_display_name($array_data);
                            $flow_data->display_data =isset($generic_forms[0]->gncf_form_title)?$generic_forms[0]->gncf_form_title:'';
                            //check assignment exist
                            $assignment_details=$this->assignment_details($flow_data,$platform_id,$this->current_user['user_id'],$stage_flow,$user_roles);
                            $return_array['roles_to_assign'] = $assignment_details['roles_to_assign'];
                            $return_array['assignment'] = $assignment_details['assignment'];

                            $return_array['manage_email_content']=array();
                            //manage email
                            $manage_email = false;
                            $on_complte_email_tab_name = 'Manage Email';
                            if ($article_privilages['author'] == false && $article_privilages['reviewer'] == false) {
                                if (isset($stage_flow['permission']) && in_array('notifications', $stage_flow['permission']) && $flow_data->art_status != 'n' && isset($flow_data->aflw_usr_id) && ($flow_data->aflw_usr_id == $this->current_user['user_id'] || $override_access))
                                {
                                    $on_complte_email_tab_name = 'Decision Letter';
                                }
                                $permission = (isset($stage_flow['permission']) && in_array('notifications', $stage_flow['permission'])) ? true : false;
                                if ($this->current_client->functionality->cfty_manage_on_complete_email == 'y' || $permission ==true) {
                                    $Stage_email_templates = new \App\Models\Stage_email_templates();
                                    $where = ' (stage_etmp_action = "declined" OR stage_etmp_action = "completed" ) AND stage_etmp_stage_type ="' . $flow_data->jwf_stage_type . '" AND setr_jwf_id=' . $flow_data->aflw_jwf_id.' AND stage_etmp_to != \'User\'';
                                    $on_complete_emails = $Stage_email_templates::get_stage_email_tmpl_to_trigger('count(*) as cnt', $where);
                                    if (isset($on_complete_emails[0]->cnt) && $on_complete_emails[0]->cnt > 0) {
                                        $manage_email = true;
                                        $content = $return_array['manage_email_content']= $this->get_email_contents($stage_flow, $flowdetails);
                                        if(empty($content))
                                        {
                                            $manage_email = false;
                                        }

                                    }
                                }
                            }
                            $return_array['on_complte_email_tab_name']= $on_complte_email_tab_name;
                            $return_array['manage_email'] = $manage_email;
                            //manage workflow assignment type for source stage
                             /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                            $return_array['source_assignment_types'] = array();
                            $return_array['source_assignment_type_status'] = false;
                            $stage_type = $flow_data->jwf_stage_type;
                            $workflow_id = $flow_data->jwf_id;
                            $flow_master_id = $flow_data->artp_fwm_id;
                            $workflow_assignment_type_selection = $this->workflow_assignment_type_seletion_status($stage_type);
                            $source_assign_status = $workflow_assignment_type_selection['source_assign_status'];
                            if($source_assign_status == true)
                            {
                                /* Task #1986 Reviewer Pool Still Visible After Completion or Skipping of Parallel Reviewer Stage */
                                $get_selected_workflow_assignment_for_source_stage = $this->get_selected_workflow_assignment_type_for_source_or_destination_stage_view_article($workflow_id,true,$flow_master_id,$art_id);
                                if(!empty($get_selected_workflow_assignment_for_source_stage))
                                    {
                                        $return_array['source_assignment_types'] = $get_selected_workflow_assignment_for_source_stage;
                                        $return_array['source_assignment_type_status'] = true;
                                    }
                            }
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                            $return_array['assign_tabs'] = '';
                            $return_array['formexistdata'] = $this->getexistdata_deatails($flow_data->jwf_forms, $art_id, $jnlcode, $art_flow_id);
                            //print_r($return_array['formexistdata']);die;

                            if(isset($flow_data->aflw_stage_repeat_count) && $flow_data->aflw_stage_repeat_count>0){
                                $existdata =$this->get_completed_multipleforms($flow_data, $article_privilages, $user_roles, $this->current_user, $jnlcode,$flow_data->aflw_stage_repeat_count);
                                if(isset($flow_data->completedform) && count($flow_data->completedform)==$flow_data->aflw_stage_repeat_count){
                                    $return_array['formexistdata'] = $this->getexistdata_deatails($flow_data->jwf_forms, $art_id, $jnlcode, $art_flow_id,$flow_data->aflw_stage_repeat_count);
                                }
                            }


                            if($flowdetails[0]->jwf_stage_type=="transit")
                            {
                                $titles = $this->UserConfigdata('titles')['titles'];
                                $return_array['transfer_data'] = true;
                                $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
                                $transfer_suggestions = $Article_transfer_suggestion::get_transfer_details($art_id, $art_flow_id);

                                $show_form = false;
                                if (isset($flowdetails[0]->aflw_status) && $flowdetails[0]->aflw_status == 'a')
                                {
                                    $show_form = true;
                                }
                                $is_editable = false;
                                if ($flowdetails[0]->art_transfer_article == 'n')
                                {
                                    $is_editable = true;
                                }

                                $return_array['enable_withdrawn_btn'] = false;
                                if(isset($this->current_client->functionality->cfty_enable_article_withdraw) && $this->current_client->functionality->cfty_enable_article_withdraw == 'y')
                                {
                                    $return_array['enable_withdrawn_btn'] = true;
                                }
                                $return_array['is_editable'] = $is_editable;
                                $return_array['show_form'] = $show_form;
                                if(!empty($transfer_suggestions)) {
                                    $user_name =  (isset($titles[$transfer_suggestions->usr_title])) ? $titles[$transfer_suggestions->usr_title] . ' ' : '';
                                    $user_name .=$transfer_suggestions->suggested_by;
                                    $transfer_suggestions->suggested_by=$user_name;
                                }
                                $return_array['transfer_suggestions'] = $transfer_suggestions;
                                $return_array['titles'] = $titles;
                            }
                        }
                        elseif ($flowdetails[0]->aflw_status == 'w' || $flowdetails[0]->aflw_status == 'p') {
                            $flow_data = $flowdetails[0];
                            $return_array['flowdetails'] = $flow_data;
                            $return_array['assign_tabs'] = ($flow_data->aflw_status == 'w') ? 'invitation' : 'assignment';
                            $return_array['hidesearchtab'] = false;
                            if($flowdetails[0]->aflw_status == 'p' )
                            {
                                if(array_intersect($user_roles['assigned_roles'], array("journal_admin","staff")) && empty(array_intersect($assigned_roles, $jwf_parent_user_roles)))
                                {
                                    $childrecord=Article_flow::get_single_record('aflw_id','aflw_parent_flow_id='. $flow_data->aflw_id);
                                    if(!isset($childrecord->aflw_id))
                                    {
                                        /*$return_array["status"]=customTrans('viewarticle.user_permission_denied');
                                        return  $this->warning('Warnings',200,$return_array,'warning');*/
                                        exit;
                                    }
                                    $return_array['hidesearchtab'] = true;
                                }
                                $assignment_details=$this->assignment_details($flow_data,$platform_id,$this->current_user['user_id'],$stage_flow,$user_roles);
                                if(!empty($assignment_details))
                                {
                                    $return_array['roles_to_assign'][] = $assignment_details['roles_to_assign'];
                                    $return_array['stage_assignment'] = $assignment_details['assignment'];
                                }
                            }
                            $completedformreviewarr=array();
                            $message='';


 /* Rescind review */
 $rescind_review_link = false;
 $is_previous = false;
 $decision_stage_article_status = array('a','r','c');

 $is_reviewer = false;
 if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') {
     $is_reviewer = $article_privilages['reviewer'];
 }

 $Journal_permission_mastertable = new \App\Models\Journal_permission_master;
 $journal_permission_master = (new \App\Models\Journal_permission_master())->getTable();
 $Journal_permission = (new \App\Models\Journal_permission())->getTable();
 $criteria = "jpm_id='{$flow_data->artp_jpm_id}'";
 $select = '*';
 $tables = array(
     'main_table' => $journal_permission_master,
     'join_table' => array(
         $Journal_permission => array($journal_permission_master . '.jpm_id', $Journal_permission . '.jp_jpm_id', "left")
     )
 );

 $article_permission_details = $Journal_permission_mastertable::get_results_using_joins($tables, $select, $criteria, 'single');


 if ($article_permission_details->jp_rescind_review != null && $flow_data->jwf_stage_type == 'review' && $is_previous == false && $is_reviewer == false) {
     if (in_array($roleid, json_decode($article_permission_details->jp_rescind_review)) && !in_array($flow_data->art_status, $decision_stage_article_status)) {
         $rescind_review_link = true;
     }
 }
    // TASK #7649 under review author single and double blind bug fix
    if($flow_data->aflw_status == 'w' && $article_privilages['author'] == false ) {
        $count=0;
        $returned_date ='';
        $reviewer_order ='';
        $Journal_settings = new \App\Models\Journal_settings;
        $jnl_date_format = $Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$platform_id}' ")->jset_date_format;

        $date_format = $this->date_format_map($jnl_date_format);

        //$art_flw_criteria = "aflw_parent_flow_id={$flow_data->aflw_id} and aflw_status in ('a','i','c','u')";

        if($article_privilages['reviewer'] == true && $flow_data->aflw_usr_id!='')
        {
            //$review_flowdetails =  Article_flow::get_all_records('*',"aflw_id={$flow->aflw_id} ");
            //TASK #4501 client functionality show_decline_reviewprocess_tab is not working in review3
            if (isset($this->current_client->functionality->cfty_show_decline_reviewprocess_tab) && $this->current_client->functionality->cfty_show_decline_reviewprocess_tab == 'y'){
                    $art_flw_criteria = "aflw_id={$flow_data->aflw_id} and aflw_status in ('a','i','c','u','d') ";
            }
            else {
                    $art_flw_criteria = "aflw_id={$flow_data->aflw_id} and aflw_status in ('a','i','c','u') ";
            }
        }
        else {
            if (isset($this->current_client->functionality->cfty_show_decline_reviewprocess_tab) && $this->current_client->functionality->cfty_show_decline_reviewprocess_tab == 'y'){
                    $art_flw_criteria = "aflw_parent_flow_id={$flow_data->aflw_id} and aflw_status in ('a','i','c','u','d')";
            }
            else {
                    //$review_flowdetails =  Article_flow::get_all_records('*',"aflw_parent_flow_id={$flow->aflw_id} ");
                    $art_flw_criteria = "aflw_parent_flow_id={$flow_data->aflw_id} and aflw_status in ('a','i','c','u')";
            }
        }
        // End TASK #4501 client functionality show_decline_reviewprocess_tab is not working in review3


        // TASK #7802 Reviewer re order issue in completed review tab
        $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $formatted_journal_code = '_' . $jnlcode;
                $select = 'distinct aflw_id,aflw_art_id,aflw_status,aflw_usr_id,jwf_stage_type,aflw_posted_by,aflw_remarks,jwf_status_name,jwf_stage_name';
                $art_flw_tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                    $Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id')
                    )
                );


                $article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'all', 'aflw_returned_date asc', null, '', null, null, true);


                $Article_type_advance_options = new \App\Models\Article_type_advance_options();
                $article_type_advance =$Article_type_advance_options::get_single_record('atotp_review_open_decision,atotp_review_open_count,atotp_review_method,atotp_custom_blind_params',"atotp_artp_id=:artp_id",null,'',null,array('artp_id'=>$flow_data->artp_id));

        if (count($article_flow_dets)>0) {
            foreach ($article_flow_dets as $usra) {
                $username_status=true;
                $returndate='';
                $author_stages = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission');
                $stage_author = false;
                if (in_array($usra->jwf_stage_type, $author_stages))
                $stage_author = true;
                $count++;
                $completedformreviewarr['flow'.$usra->aflw_id]=[];
                $completedformreviewflowarr['childflow_id']=$usra->aflw_id;
                if ($usra->aflw_status == 'a') {
                    $count--;
                }

                if (isset($usra->jwf_stage_type) && ($usra->jwf_stage_type == 'review') && $article_privilages['privilaged'] == true) {
                    $reviewer_order = "Reviewer #" . $count . " : ";
                }
                if(empty($returndate)) {
                    $returndate =  Article_flow::get_single_record('DATE_FORMAT(aflw_returned_date, "' . $date_format . ' ") as returned_date',"aflw_id={$usra->aflw_id}");
                    $returndate=$returndate->returned_date;
                }
                $reviewer_name =	' on ' . $returndate  ;
                //hide author name in double blind for reviewer
                if($stage_author == true && (($article_type_advance->atotp_review_method == 'd' && $article_privilages['reviewer'] == true && $article_privilages['privilaged'] == false) || $this->is_custom_blinded('author', $art_id, jnl:$jnlcode, blinded_user:$usra->aflw_usr_id))) {
                    $reviewer_name = ' Author';
                    $username_status = false;
                }
                if($article_type_advance->atotp_review_method != 'o' && $usra->jwf_stage_type == 'review' && ($article_privilages['author'] == true || $this->is_custom_blinded('reviewer', $art_id, jnl:$jnlcode, blinded_user:$usra->aflw_usr_id))) {
                    $reviewer_name ="Reviewer #" . $count ;
                    $username_status = false;
                    $return_array['priv']=$article_privilages;
                }
                if($article_privilages['author'] == true && $article_privilages['privilaged'] == false && $usra->jwf_stage_type == 'review') {
                    $multiple_label = $usra->jwf_status_name . " by  ";
                } elseif($article_privilages['author'] == true && $article_privilages['privilaged'] == false) {
                    $reviewer_name = '';
                    $username_status = false;
                }

                $where = ' gdata_artflw_id =  ' . $usra->aflw_id . ' AND gdata_art_id = ' . $usra->aflw_art_id;
                
                if ($usra->jwf_stage_type == 'review' || $usra->jwf_stage_type == 'author_submission') {
                    if (($article_privilages['author'] == true && isset($article_type_advance->atotp_review_method) && $article_type_advance->atotp_review_method != 'o')){
                        $author_role_id = $user_roles['role_id'][0]; // when user has author role in an article then other roles are removed
                        //author need to display all author form regardless of checking the viewable form
                        if ($stage_author == false) {
                        //1901 Reviewer comments not visible to author
                            $where .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true  END ';
                        }
                    } elseif ($article_privilages['author'] == false) {
                        $user_roles_form = $user_roles["role_id"];
                        if ($article_privilages['privilaged'] == true) {
                            $author_key = array_search("author", $user_roles["assigned_roles"]);
                            if ($author_key!==false && $author_key >= 0) {
                                unset($user_roles_form[$author_key]);
                            }
                        }
                        $where .= ' and CASE WHEN gncf_user_roles IS null THEN true WHEN gncf_user_roles = "[]" THEN true WHEN FIND_array_intersect(REPLACE(REPLACE(REPLACE(gncf_user_roles,\']\',\'\'),\'[\',\'\'),\'"\',\'\'), "' . implode(",", $user_roles_form) . '") >0 THEN true WHEN gdata_posted_by ='. $this->current_user["user_id"] .'  THEN true END';
                    }
                }

                //user_id
                // remove element form custom form settings bug fixed
                $form_select ="CASE WHEN emt_hideafterstage IS NULL THEN (SELECT emt_hideafterstage FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='label' order by tbk_id DESC limit 1) ELSE emt_hideafterstage END AS emt_hideafterstage, CASE WHEN emt_element_type IS NULL THEN (SELECT emt_element_type FROM tbk_generic_form_elements WHERE emt_id=gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date <=gdata_posted_date order by tbk_id DESC limit 1) ELSE emt_element_type END AS emt_element_type, CASE WHEN emt_tinymce_required IS NULL THEN (SELECT emt_tinymce_required FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='textarea' order by tbk_id DESC limit 1) ELSE emt_tinymce_required END AS emt_tinymce_required,";

                $form_select .= 'gdata_atfemt_id,gdata_dynamic_status,gdata_art_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_user_roles,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gdata_gfg_id,gncf_form_type,gncf_user_roles,gncf_posted_by,gncf_form_privilege_usr_edit';
                $author_role_id = $assigned_roles;

                $formatted_journal_code = '_' . $jnlcode;
                
                $details_tables = array(
                    'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
                    'join_table' => array(
                        $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
                        $Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id','left'),
                    )
                );
                $order_by = "gdata_data_order,gdata_posted_date asc";
                if ($editformcmt === true) {
                    $where = str_replace('gdata_posted_by','aflw_usr_id',$where);
                    $form_select .= ',tb1.feh_posted_by, DATE_FORMAT(tb1.feh_posted_date, "' . $date_format . '") as feh_posted_date';
                    $query = 'select ' . $form_select . ' from rvw_article_gnf_form_data' . $formatted_journal_code . ' join ' . $Generic_forms_table . ' on gncf_id = gdata_atf_id left join ' . $Generic_form_elements_table . ' on gdata_atfemt_id=emt_id join '.$article_flow_table.'  on aflw_id = gdata_artflw_id left join (SELECT feh_id,feh_gncf_id,feh_posted_by,feh_posted_date FROM ' . $Form_edithistory_table . ' WHERE feh_id IN (SELECT max(feh_id) from ' . $Form_edithistory_table . ' where `feh_art_id` = ' . $usra->aflw_art_id . ' GROUP by `feh_gncf_id`,feh_aflw_id)) as tb1 on (gdata_feh_id = tb1.feh_id and tb1.feh_gncf_id = gdata_atf_id)where ' . $where . ' order by ' . $order_by;
                    $reviewforms = Article_flow::get_records_by_raw_query($query);
                }
                else
                {
                    $reviewforms = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', $order_by, null, '', null, null, true);
                }
                
                $arraydata=array(
                    'reviewforms'=>$reviewforms,
                    'flow'=>$flow_data,
                    'usra'=>$usra,
                    'completedformreviewarr'=>$completedformreviewarr,
                    'functional_type'=>'s',
                    'version'=>'current',
                    'count'=>$count,
                    'article_privilages'=>$article_privilages,
                    'multiple_label'=>$multiple_label,
                    'article_permission_details'=>$article_permission_details,
                    'roleid'=>$roleid,
                    'rescind_review_link'=>$rescind_review_link,
                    'review_to_orcid'=>$review_to_orcid,
                    'username_status'=>$username_status,
                    'reviewer_name'=>$reviewer_name,
                    'reviewer_order'=>$reviewer_order,
                    'user_roles'=>$user_roles,
                    'remove_tab_andform'=>$remove_tab_andform,
                    'is_previous'=>false,
                    'platform_id'=>$platform_id,
                    'atotp_review_method'=>$article_type_advance->atotp_review_method,
                );
                $res=$this->get_viewarticle($arraydata);
                if(!empty($res)) {
                    $completedformreviewarr=$res['completedformreviewarr'];
                    $count=$res['count'];
                }



                                    }
                                }



                            }



                            if(count($completedformreviewarr)>0){
                                $found=0;
                                foreach ($completedformreviewarr as $key => $value) {
                                    if(!empty($value)){
                                        $found=1;
                                    }
                                }
                                if($found==0) {
                                    $message = 'Stage <strong>' . $usra->jwf_stage_name . '</strong> in progress';
                                }else {
                                    $flowdetails[0]->review_childstages = $completedformreviewarr;
                                }
                            }
                            if(count($completedformreviewarr)==0) {
                                $message = 'Stage <strong>' . $flow_data->jwf_stage_name . '</strong> in progress';
                            }


                            // if (empty($completed_forms) && !empty($completed_forms_exist)){
                            //     $message = "<p class='text-warning' >You are not permitted to see this content.";
                            // }
                            $flowdetails[0]->messsage = $message;
                        }
                    }
                }
                /* TASK #6282 Implement Review Article grading System*/
                $return_array['manage_rating']=false;
                $return_array['article_rating_data']=array();
                if (isset($this->current_client->functionality->city_enable_article_rating)&&($this->current_client->functionality->city_enable_article_rating == "y")&&(isset($flow_data->jwf_stage_type)&&$flow_data->jwf_stage_type=='post_assessment')&&(isset($flow_data->aflw_status)&&$flow_data->aflw_status=='a'))
                {
                $return_array['manage_rating']=true;
                }
                if(isset($art_id)&&$art_id!=null&&isset($art_flow_id)&&$art_flow_id!=null)
                $return_array['article_rating_data']=$check_exist=$Article_Rating::get_single_record_with_bind_cond('	rat_star_value,rat_star_comments',array('rat_art_id'=>$art_id,'rat_aflw_id'=>$art_flow_id));
            /* Task End */

            }

            return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }


    //*** used to display the current stage details ends ***/


    public function check_form_completion(Request $request)
    {
        try {
            $data = $request->all();
            $jnlcode = $this->decrypt_data($data['jnl_code']);
            $art_array = $this->decrypt_data($data['art_array']);
            $art_array = json_decode($art_array);
            $resp_arr = array();
            foreach ($art_array as  $art_id => $art_flow_id ) {
                $condition = "aflw_id=:art_flow_id";
                $condition_arr = array('art_flow_id' => $art_flow_id);
                $flowdetails = Articles::get_article_details("jwf_forms, aflw_stage_repeat_count", $condition, null, false, true, null, $condition_arr);
                $flow_data = $flowdetails[0];
                $form_complete_detail = $this->getexistdata_deatails($flow_data->jwf_forms, $art_id, $jnlcode, $art_flow_id);

                if (isset($flow_data->aflw_stage_repeat_count) && $flow_data->aflw_stage_repeat_count > 0) {
                    if (count($flow_data->completedform) == $flow_data->aflw_stage_repeat_count) {
                        $form_complete_detail = $this->getexistdata_deatails($flow_data->jwf_forms, $art_id, $jnlcode, $art_flow_id, $flow_data->aflw_stage_repeat_count);
                    }
                }
                $resp_arr[$art_id] =  $form_complete_detail['form_valid'] ? $form_complete_detail['form_complete'] : true;
            }

            return $this->success('success', data: $resp_arr);
        } catch (Exception $e) {
            return $this->failure(data: $e);
        }
    }

    //*** used to get all keywords for that journal starts ***/
    public function get_all_keywords(Request $request)
    {
        try {
            $return_array = array();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $Keywords = new \App\Models\Keywords();
            $results = array();
            $jnl_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $selected = isset($post_data['selected']) ? $post_data['selected'] : '';
            $art_flow_id = isset($post_data['art_flow_id']) ? $this->decrypt_data($post_data['art_flow_id']) : '';
            if($jnl_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $jnl_id = $platform_data->jnl_id;
            }
            $category = null;
            $where = '';
            //$post_data['data']['q']
            if ($this->current_client->functionality->cfty_keyword_hierarchy == "j") {
                $select = 'kwd_id,kwd_name,kwdrl_id,kwdrl_inactive';
                $group_by = 'kwd_id';
                $where = " kwdrl_jnl_id=" . $jnl_id;
                if (isset($post_data['selected'])) {
                    $kwd_name = htmlspecialchars($post_data['selected'], ENT_QUOTES);
                    $where .= ' AND kwd_name LIKE "' . $kwd_name . '%"';
                }
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y') {
                    if ($article_id !== 'undefined' && $article_id !== '')
                        $where .= ' AND (kwdrl_inactive = \'n\' OR ak_art_id = ' . $article_id . ' )';
                    else
                        $where .= ' AND kwdrl_inactive = \'n\'';
                }
                $keywords = $Keywords::get_keywords($where, $select, null, null, $group_by, $this->current_client->functionality->cfty_keyword_hierarchy, null, null, null, null, null, false, true);
                if (!empty($keywords)) {
                    foreach ($keywords as $key) {
                        $results[] = array(
                            'label' => $key->kwd_name,
                            'value' => $key->kwd_id,
                            'id'=>$key->kwd_id
                        );
                    }
                }
            } else {
                if (isset($post_data['data'])) {
                    $kwd_name = htmlspecialchars($post_data['data'], ENT_QUOTES);
                    $where = 'kwd_name LIKE "%' . $kwd_name . '%"';
                }
                $keywords = $Keywords::get_keywords_by_category($jnl_id, $where);
                foreach ($keywords as $key) {
                    $results[] = array(
                        'label' => $key->kwd_name,
                        'value' => $key->kwd_id,
                        'id'=>$key->kwd_id
                    );
                }
            }
            $show_keyword_insearch = true;
            $generic_flows_data = Article_flow::get_generic_flow('jwf_stage_type','aflw_id='.$art_flow_id);
            if(!empty($generic_flows_data))
            {
                $stagetype = $generic_flows_data[0]->jwf_stage_type;
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $workflow_arr  = Config::get($workflow_config);
                $cutstagedata =$workflow_arr[$stagetype];
                $stage_for =$cutstagedata['stage_for'];
                if($stage_for !="review" || (isset($this->current_client->functionality->cfty_assign_autofill_keyword) && $this->current_client->functionality->cfty_assign_autofill_keyword == 'n'))
                {
                    $show_keyword_insearch = false;
                }
            }
            $return_array = array(
                'data' => $post_data['data'],
                "results" => $results,
                'enable_keyword_search'=>$show_keyword_insearch
            );
            return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** used to get all keywords for that journal ends ***/

    //*** get the search result for article assignment and stage assignment starts ***/
    public function get_assignment(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'roleid' => 'required',
                //'type' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $order = isset($post_data['order']) ? $post_data['order'] : '';
            $journal_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $role_id = isset($post_data['roleid']) ? $this->decrypt_data($post_data['roleid']) : '';
            $type = isset($post_data['type']) ? $this->decrypt_data($post_data['type']) : '';
            $flow_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : '';
            $existrecord =$this->checkValidRecord($article_id, $flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($journal_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $journal_id = $platform_data->jnl_id;
            }
            $orderby = $post_data['sort_field'] ?? 'name';
            $sortby =  $post_data['sort_order'] ?? 'asc';
            $order_column=$post_data['sort_field'] ?? 'name';
            //echo $journal_id; die;
            $changeassign =isset($post_data['changeassign']) ? $post_data['changeassign'] : false;
            $srch_details = isset($post_data['srch_details']) ? $post_data['srch_details'] : null;
            $User_articles = new \App\Models\User_articles();
            $Authors = new \App\Models\Authors();
            //$Journal_terms = new \App\Models\Journal_terms();
            //$User_journal_classifications = new \App\Models\User_journal_classifications();
            $User = new \App\Models\User();
            $select = 'usr_id,usr_email';
            $where = '';
            $and = '';
            $user_keyword_search='';
            $keywords =array(); $keywordhighligt=array(); $keywords_value='';
            $keyword_like = '';
           // echo '<pre>'; print_r($post_data['paramsdet']);// die;
            if ($srch_details == null) {
                $search_details = isset($post_data['paramsdet']) ? $post_data['paramsdet'] : null;
                if (isset($search_details['keyword_operator'.$role_id]) && !empty($search_details['keyword_operator'.$role_id])) {
                   $keyword_like = $search_details['keyword_operator'.$role_id];
                }
                $search_details['kwd_id'] = "";
                if (isset($search_details['keywords'.$role_id]) && (!empty($search_details['keywords'.$role_id])) && ($keyword_like=='OR' || $keyword_like=='AND')) {
                    $keywords_value = $keywords =$search_details['keywords'.$role_id];
                    if(!empty($keywords) && $keywords!='[]')
                    {
                        foreach ($keywords as $row) {
                            //$keywordhighligt[]['kwd_id']=$row;
                            if (!is_numeric($row)) {
                                $row = $this->decrypt_data($row);
                            }
                            if(empty($search_details['kwd_id']))
                            $search_details['kwd_id'] .=  $row;
                            else
                            $search_details['kwd_id'] .= ',' . $row;
                        }
                    }
                    $user_keyword_search='ID';
                    if(!empty($keywords_value))
                    {
                        $where .=" ukwd_kwd_id IN (".implode(',',$keywords_value)." )";
                        $and = ' and ';
                    }
                }
                if (isset($search_details['keyword_like'.$role_id]) && (!empty($search_details['keyword_like'.$role_id])) && $keyword_like=="LIKE") {
                    $keywords_value = $keywords =$search_details['keyword_like'.$role_id];
                    $user_keyword_search='WORD';
                    if(!empty($keywords_value))
                    {
                        $where .=" kwd_name LIKE '%" . $keywords_value . "%'";
                        $and = ' and ';
                        $select .= ',GROUP_CONCAT(kwd_id) as keysearch';
                    }
                }
            } else {
                $search_details = $srch_details;
                $flow_id = $this->decrypt_data($srch_details['flow']);
            }

            $is_users_assigned = false;
            /*$request_from_change = false;
            if (isset($search_details['change_assmnt']) && $search_details['change_assmnt'] == true) {
                $request_from_change = true;
            }*/

            $user_articles = $usr_ids = array();
            $exclude_users = array();
            $article_types =  Articles::get_single_record('art_artp_id', 'art_id=:article_id',null,'',null,array('article_id'=>$article_id));
            $article_type_id = $article_types->art_artp_id;
            //$type =  isset($search_details['type']) ? $search_details['type'] : '';
            /*if ($request_from_change == true) {
                $type = $this->decrypt_data($search_details['type']);
            }*/
            $usra_where = '';
            //$jwf_id = null;
            //$role_id = $this->decrypt_data($search_details['role']);
            $no_ajax = 'n';
            $keyword_arr = array();
            $keyword_element = '';


            $article_flow_dets = Article_flow::get_single_record('aflw_id,aflw_jwf_id,aflw_skip_assignment,aflw_usr_id', 'aflw_id=:flow_id',null,'',null,array('flow_id'=>$flow_id));
            $assign_select = 'group_concat(aflw_skip_assignment) as aflw_skip_assignment';
            $assign_where = 'aflw_art_id=:article_id and aflw_usr_id=:userid';
            $assign_dets = Article_flow::get_article_flow_details($assign_select, $assign_where,false,array('article_id'=>$article_id,'userid'=>$this->current_user['user_id']));
            $skipped_roles = (isset($assign_dets[0]) && $assign_dets[0]->aflw_skip_assignment != null) ? array_filter(explode(',', $assign_dets[0]->aflw_skip_assignment)) : array();
            $skip_button = false;
            if (!in_array($role_id, $skipped_roles) && $type == 'article') {
                $skip_button = true;
            }
            $usra_where = 'usra_art_id=:article_id and usra_role_id=:role_id';
            $user_articles = $User_articles::get_all_records('usra_usr_id', $usra_where, null, null,'', null, null,'ASC',array('article_id'=>$article_id,'role_id'=>$role_id));
            if (!empty($user_articles) && isset($user_articles[0])) {
                $usr_ids = array_column(json_decode(json_encode($user_articles), true), 'usra_usr_id');
                if ($type == 'article') {
                    $exclude_users = $usr_ids;
                    $usr_ids = array();
                    $skip_button = false;
                    $no_ajax = 'y';
                } elseif ($type == 'stage' && $changeassign== false) {
                    /*if ($request_from_change == true) {
                        if (count($usr_ids) > 1) {
                            $where .= $and . ' usr_id IN ( ' . join(',', $usr_ids) . ' )';
                            $and = ' AND ';
                        }
                    } else {*/
                        $where .= $and . ' usr_id IN ( ' . join(',', $usr_ids) . ' )';
                        $and = ' AND ';
                   // }
                } else {
                    if (count($usr_ids) > 1) {
                        $where .= $and . ' usr_id IN ( ' . join(',', $usr_ids) . ' )';
                        $and = ' AND ';
                    }
                }
                $is_users_assigned = true;
            }
            $jwf_id=$article_flow_dets->aflw_jwf_id;
            if ($type == 'stage') {
                $article_flow_users = Article_flow::get_all_records('aflw_usr_id', 'aflw_art_id=:article_id  and   aflw_jwf_id=:aflw_jwf_id AND aflw_parent_flow_id=:flow_id', null, null,'', null, null,'ASC',array('article_id'=>$article_id,'aflw_jwf_id'=>$article_flow_dets->aflw_jwf_id,'flow_id'=>$flow_id));
                if (!empty($article_flow_users)) {
                    $aflw_usrs = $this->get_column_array($article_flow_users, 'aflw_usr_id');
                    $exclude_users = array_merge($exclude_users, $aflw_usrs);
                }
            }
            $flow_roledata =Generic_flows::get_single_record('jwf_role_id', 'jwf_id=:jwf_id',null,'',null,array('jwf_id'=>$article_flow_dets->aflw_jwf_id));
            if($article_flow_dets->aflw_usr_id!=null && $flow_roledata->jwf_role_id==$role_id && $changeassign == true)
            {
                $exclude_users = array_merge($exclude_users, array($article_flow_dets->aflw_usr_id));
            }
            $article_authors = $Authors::get_all_records('auth_usr_id', 'auth_art_id=:article_id', null, null,'', null, null,'ASC',array('article_id'=>$article_id));
            $auth_usrs = $this->get_column_array($article_authors, 'auth_usr_id');
            $exclude_users = array_merge($exclude_users, $auth_usrs);
            if ($this->current_client->functionality->cfty_self_assignment == 'n') {
                $exclude_users[] = $this->current_user['user_id'];
            }
            $blinded_users = $this->get_blinded_users($jnlcode,$article_id);
            $blinded_users_arr = array();
            if(!empty($blinded_users))
            {
                foreach ($blinded_users as $usr)
                {
                    $blinded_users_arr[]= $usr->usr_id;
                }
            }
            $exclude_users = array_merge($exclude_users, $blinded_users_arr);
            // print_r($exclude_users);die;
            if (!empty(array_filter($exclude_users))) {
                $where .= $and . ' usr_id NOT IN ( ' . join(',', array_unique(array_filter($exclude_users))) . ' )';
                $and = ' AND ';
            }
            if (isset($search_details['username'.$role_id]) && $search_details['username'.$role_id] != '') {
                $where .= $and . ' concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) LIKE "%' . $search_details['username'.$role_id] . '%" ';
                $and = ' AND ';
            }
            if (isset($search_details['email'.$role_id]) && $search_details['email'.$role_id] != '') {
                $where .= $and . ' usr_email = "' . $search_details['email'.$role_id] . '"';
                $and = ' AND ';
            }
            /*$primary_classification_terms = $secondary_classification_terms = array();
            if (isset($search_details['primary']) && count($search_details['primary']) > 0) {
                $primary_classification_terms = $search_details['primary'];
            }
            if (isset($search_details['secondary']) && count($search_details['secondary']) > 0) {
                $secondary_classification_terms = $search_details['secondary'];
            }
            if (!empty($secondary_classification_terms)) {
                foreach ($secondary_classification_terms as $sec_terms) {
                    $sec_term_id = $Journal_terms::get_single_record('jntm_term_id', 'jntm_id=' . $this->decrypt_data($sec_terms));
                    $sec_corre_id = $Journal_terms::get_all_records('jntm_id', 'jntm_term_id=' . $sec_term_id->jntm_term_id . ' and jntm_artp_id=' . $article_type_id . ' and jntm_type=\'s\'');
                    foreach ($sec_corre_id as $secondary) {
                        if (!in_array($this->encrypt_data($secondary->jntm_id), $secondary_classification_terms)) {
                            array_push($secondary_classification_terms, $this->encrypt_data($secondary->jntm_id));
                        }
                    }
                }
            }
            $classification_terms = array_merge($primary_classification_terms, $secondary_classification_terms);
            $has_results = true;
            if (!empty($classification_terms)) {
                array_walk($classification_terms, function (&$value, $key) {
                    $value = $this->decrypt_data($value);
                });
                $classification_users = $User_journal_classifications::get_all_records('jucl_usr_id', 'jucl_artp_id = ' . $article_type_id . ' AND jucl_jntm_id IN (' . join(',', $classification_terms) . ')');
                $jucl_usr_id = $this->get_column_array($classification_users, 'jucl_usr_id');
                if (!empty($jucl_usr_id)) {
                    $where .= $and . ' usr_id IN ( ' . join(',', array_unique($jucl_usr_id)) . ' )';
                } else {
                    $has_results = false;
                }
            }*/
            $has_results = true;
            if($changeassign == true && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
            {
                 $where .=$and.' usrj_usr_id not in (select concat(sorw_suggested_reviewer_id) from rvw_article_reviewers where sorw_art_id='.$article_id.' )';
            }
            if($changeassign == true && $article_flow_dets->aflw_usr_id!='' && $flow_roledata->jwf_role_id==$role_id)
            {
                $where .= $and . ' usrj_usr_id!='.$article_flow_dets->aflw_usr_id;
            }
            $where .= $and . ' usr_status = \'a\' AND usrj_jnl_id = ' . $journal_id . ' AND usrj_artp_id = ' . $article_type_id . ' AND usrj_role_id = ' . $role_id . ' AND usrj_role_retired = "n"';

            $search_result = array();
            if ($has_results) {
                $search_result = $User::get_user_search_result($select, $where, $orderby, $order_column, $journal_id,$sortby,$user_keyword_search);
                //$query=DB::getQueryLog();
            }
            $tat_dates = array();
            if ($jwf_id != null) {
                $tat_dates = $this->get_tat_dates($jwf_id);
            }
            $userarticle_table = $User_articles->getTable();
            $article_table = (new \App\Models\Articles)->getTable();
            $articletype_table = (new \App\Models\Article_types)->getTable();
            if (!empty($search_result)) {
                $tables = array(
                    'main_table' => $userarticle_table,
                    'join_table' => array(
                        $article_table => array($article_table . '.art_id', $userarticle_table . '.usra_art_id', "left"),
                        $articletype_table => array($articletype_table . '.artp_id', $article_table . '.art_artp_id', "left")
                    )
                );
                $result_criteria = 'art_status = \'y\'';
                foreach ($search_result as $search) {
                    $availability = true;
                    $date_bwn = '';
                    $unavailable_reason = '';
                    //$users_unavailability = array();
                    if (!empty($tat_dates)) {
                        $users_unavailability = $this->get_users_unavailability($search->usr_id, $tat_dates);
                        if ($users_unavailability != null) {
                            $availability = false;
                            if ($users_unavailability[0]->unavail_start_date != $users_unavailability[0]->unavail_end_date) {

                                $date_bwn = ' between ' . date('d-m-Y', strtotime($users_unavailability[0]->unavail_start_date)) . ' and ' . date('d-m-Y', strtotime($users_unavailability[0]->unavail_end_date));
                            } else {
                                $date_bwn = ' on ' . date('d-m-Y', strtotime($users_unavailability[0]->unavail_start_date));
                            }

                            $unavailable_reason = $users_unavailability[0]->unavail_reason;
                        }
                    }
                    $search->date_between = $date_bwn;
                    $search->unavailable_reason = $unavailable_reason;
                    $search->availability = $availability;


                    //$search->encusr_id = $this->encrypt_data($search->usr_id);
                    $array_data['user_id'] = $search->usr_id;
                    $array_data['journal_id'] = $journal_id;
                    $array_data['flag'] = true;
                    $array_data['article_id'] = $article_id;
                    $array_data['jnl_code'] = $jnlcode;
                    $array_data['availability'] = $availability;
                    $array_data['unavailable_msg']= ($availability==false)?' The user unavailable '.$date_bwn .' <br><b>Reason:</b> '.$unavailable_reason:'';
                    $is_blinded = false;
                    $search->name = $this->get_user_display_name($array_data, $is_blinded);
                    if($is_blinded){
                        $search->usr_email = '**Email Hidden**';
                    }
                    //Bug #2461 	The number of assigned papers showing for AEs is incorrect IET feedback
                    $articleflow_table = (new \App\Models\Article_flow)->getTable();
                    $genericflow_table = (new \App\Models\Generic_flows)->getTable();
                    $table_join = array(
                        'main_table' => $articleflow_table,
                        'join_table' => array(
                            $article_table => array($article_table . '.art_id', $articleflow_table . '.aflw_art_id', "left"),
                            $articletype_table => array($articletype_table . '.artp_id', $article_table . '.art_artp_id', "left"),
                            $genericflow_table => array($articleflow_table . '.aflw_jwf_id', $genericflow_table . '.jwf_id', "left"),
                        )
                    );

                    $tb_condition = 'aflw_usr_id =' . $search->usr_id . ' AND aflw_status = \'a\' AND art_delete_status  = \'n\' AND jwf_stage_type NOT IN (\'author_submission\',\'transit\',\'authors_declaration\',\'revision\',\'resubmission\',\'copyright\') and art_status IN (\'y\',\'a\')';
                    $tb_condition_exclude_curjnl = $tb_condition_only_curjnl = $tb_condition;

                    $tb_condition_only_curjnl .= ' and artp_jnl_id=' . $journal_id;
                    $tasks = Article_flow::get_results_using_joins($table_join, 'count(aflw_id) as cnt', $tb_condition_only_curjnl, 'single');
                    //$search->tasks_in_progress = $tasks->cnt;
                    $tb_condition_exclude_curjnl .= ' and artp_jnl_id!=' . $journal_id;
                    $tasks_exclude = Article_flow::get_results_using_joins($table_join, 'count(aflw_id) as cnt', $tb_condition_exclude_curjnl, 'single');
                    //$search->tasks_exclude = $tasks_exclude->cnt;
                    $current_assignmets['jnl']=$tasks->cnt;
                    $current_assignmets['global']=$tasks_exclude->cnt;
                    $current_assignmets['jnlmsg']= customTrans('viewarticle.user_current_jnl');
                    $current_assignmets['globalmsg']=customTrans('viewarticle.user_other_jnl');
                    $search->taskhand =$current_assignmets;


                    $result_criteria = 'usra_usr_id=' . $search->usr_id . ' and artp_jnl_id=' . $journal_id.' and art_status="y"';
                    $user_art_count = $User_articles::get_results_using_joins($tables, 'count(usra_art_id) as cnt', $result_criteria, 'single');
                    //$search->assigned_articles_in_jnl = $user_art_count->cnt;
                    $res_consition = 'usra_usr_id=' . $search->usr_id . ' and artp_jnl_id !=' . $journal_id . ' and art_status="y"';
                    $user_art_count_exclude_curjnl = $User_articles::get_results_using_joins($tables, 'count(usra_art_id) as cnt', $res_consition, 'single');
                    //$search->assigned_articles_out_jnl = $user_art_count_exclude_curjnl->cnt;
                    $current_assignmets['jnl']=$user_art_count->cnt;
                    $current_assignmets['global']=$user_art_count_exclude_curjnl->cnt;
                    $current_assignmets['jnlmsg']=customTrans('viewarticle.art_current_jnl');
                    $current_assignmets['globalmsg']=customTrans('viewarticle.art_other_jnl');

                    $search->articleassigned =$current_assignmets;

                    $search->role_id = $role_id;
                    $Userkeywords = new \App\Models\Userkeywords();
                    $userkeyword_table = ($Userkeywords)->getTable();

                    $order = array();
                    if (!empty($keyword_element)) {
                        $order = sprintf('FIELD(kwd_id, %s)', $keyword_element) . " DESC";
                    }
                    $Keywords = new \App\Models\Keywords();
                    $keyword_table = ($Keywords)->getTable();
                    $join_table_details = array(
                        'main_table' => $keyword_table,
                        'join_table' => array(
                            $userkeyword_table => array($keyword_table . '.kwd_id', $userkeyword_table . '.ukwd_kwd_id')
                        )
                    );
                    $shortlist_user_keywords = $Keywords::get_results_using_joins($join_table_details, 'kwd_name,kwd_id', 'ukwd_usr_id=' . $search->usr_id, 'all', $order);
                    $search->user_keywords = $shortlist_user_keywords;

                }
            }
            if ((isset($search_details['kwd_id']) && !empty($search_details['kwd_id'])) || (isset($search_details['keyword_like'.$role_id]) && !empty($search_details['keyword_like'.$role_id]) && $search_details['keyword_operator'.$role_id]=="LIKE")) {
            //if ((isset($search_details['kwd_id']) && !empty($search_details['kwd_id']))) {
               // $kwd_array = explode(',', $search_details['kwd_id']);
                $user_keyword_found = "";
                $User_to_journals = new \App\Models\User_to_journals();
                $user_keyword_found = $User_to_journals::get_user_with_keyword($search_details, $role_id, $article_type_id, $journal_id);
                $match_value = ""; $exist_data=array();
                 $searchkeywordtext =array();
                if (!empty($user_keyword_found)) {
                   foreach ($search_result as $key => $users) {
                        if(isset($users->keysearch))
                        {
                            $keyids=explode(',',$users->keysearch);
                            foreach($keyids as $k)
                            {
                               array_push($searchkeywordtext,(int)$k);
                            }

                        }
                        if (isset($search_details['keyword_like'.$role_id]) && !empty($search_details['keyword_like'.$role_id])) {
                            $temp_data = $User::get_profile_keywords_assignment($users->usr_id, null, $search_details['keyword_like'.$role_id]);
                            $users->user_keywords = $temp_data;
                        }
                        foreach ($user_keyword_found as $ind => $kwd_user_id) {
                            if ($users->usr_id == $kwd_user_id->usrj_usr_id) {
                                $match_value = 1;
                            }
                        }
                        if ($match_value != 1) {
                            unset($search_result[$key]);
                        }
                        else{
                            $exist_data[]=$search_result[$key];
                        }
                        $match_value = "";
                    }
                    $keywordhighligt=array_values(array_unique($searchkeywordtext));
                } else {
                    $search_result = array();
                }
                if(sizeof($exist_data)>0)
                {
                    $search_result=$exist_data;
                }
                if(empty($search_result))
                {
                    $search_result['total']=0;
                }
                else
                {
                    $result =array();
                    $result['data']=$search_result;
                    $result['current_page']=1;
                    $result['total']= count($search_result);
                    $result['per_page']=10;
                    $result['from']=1;
                    $result['last_page']=1;


                    $search_result= $result;

                }
            }


            /* Customisation #2574
		 * Remove skip button from assignment steps if client functionality->cfty_remove_skip_from_assignments value is yes.
		 * Otherwise keep the skip buttons.
		 * if $skip_button is true, check this condition also
		 */
            if ($skip_button == true) {
                if (isset($this->current_client->functionality->cfty_remove_skip_from_assignments) && $this->current_client->functionality->cfty_remove_skip_from_assignments == 'y') {
                    $skip_button = false;
                }
            }

            $exist_record = false;
            if (count($search_result) > 0)
            {
                $exist_record = true;
            }

            $assigned_core_role = Roles::get_single_record('role_name,role_assigned_role', 'role_id=:role_id',null,'',null,array('role_id'=>$role_id));
            $resultdata[$role_id] = $search_result;
            $data = array(
                'search_result' => $resultdata,
                'type' => $type,
                'skip_button' => $skip_button,
                'article_flow' => $article_flow_dets,
                'role_id' => $role_id,
                'core_role' => $assigned_core_role->role_assigned_role,
                //'client_functionality' => $this->current_client->functionality,
                'article_id' => $article_id,
                'is_users_assigned' => $is_users_assigned,
                'searched_keyword' => $keyword_arr,
                'srch_keyword_match' => $keyword_like,
                'client' => isset($this->current_client->clnt_client_code) ? $this->current_client->clnt_client_code : '',
                'role_name' => $assigned_core_role->role_name,
                'exist_record' => $exist_record,
                'keyword_accordion' => $this->current_client->functionality->cfty_show_reviewer_keyword_accordion,
                'keywordhighligt'=>$keywordhighligt,
                'keywords'=>$keywords_value
            );
            if ((isset($search_details['change_user']) && !empty($search_details['change_user'])) && (isset($search_details['assignment']) && !empty($search_details['assignment']))) {
                $data['change_user'] = $search_details['change_user'];
                $data['stage_id'] = $search_details['stage'];
            }
            return  $this->success('Success', 200, $data);
       } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** get the search result for article assignment and stage assignment ends ***/

    //*** used to display right icons according to the permission starts */
    public function get_article_right_icon_status(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'current_status_id' => 'required',
                'jnl_code' => 'required',
                'role_id' => 'required',
                'core_role' => 'required',
                'jnl_id' => 'required'
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article = Rv_decrypt($post_data['article_id']);
            $current_article = Rv_decrypt($post_data['current_article']);
            $current_status_id = Rv_decrypt($post_data['current_status_id']);
            $journal_code = Rv_decrypt($post_data['jnl_code']);
            $jnl_id = Rv_decrypt($post_data['jnl_id']);
            $role_id = Rv_decrypt($post_data['role_id']);
            $core_role = Rv_decrypt($post_data['core_role']);
            $existrecord =$this->checkValidRecord($current_article, $current_status_id,$journal_code);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($jnl_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($journal_code);
            $jnl_id = $platform_data->jnl_id;
            }
            //$article_data = $this->Articles->get_single_record('art_stub,art_id,art_artp_id,art_status',array('art_id'=>$article));
            $is_reviewer_in_version = false;
            if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                // $is_reviewer_in_version = $this->check_user_as_reviewer_version($current_article, $this->current_user['user_id'] );
            }
            $Articles = new \App\Models\Articles();
            $Roles = new \App\Models\Roles();
            $Article_notes = new \App\Models\Article_notes();
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            $Article_pdf = new \App\Models\Article_pdf();
            $articleflow_table = (new \App\Models\Article_flow)->getTable();
            $genericflow_table = (new \App\Models\Generic_flows)->getTable();

            $article_basic_data = $Articles::get_single_record('art_version_no,art_artp_id', "art_id={$article}");

            if (!empty($article_basic_data)) {
                $return_data['status'] = 'success';
                $return_data['article_basic_data'] = $article_basic_data;
                $article_data = $Articles::get_article_data($article);

                $article_type = $article_data->artp_id;
                $article_privilages = $this->article_privilages($article_data, $current_status_id, $journal_code);

                //$user_roles = $this->validate_user_journal($this->journal_code, $this->current_user['user_id'], $article_type);


                /* Roles assigned to current user in the article type */
                $all_user_roles = $this->validate_user_journal($journal_code, $this->current_user['user_id'], $article_data->artp_id);

                $all_roles = $Roles::get_all_records('role_id,role_name,role_assigned_role');
                /* Roles assigned to this article */
                $user_array = array();
                $user_array['user_roles'] = $all_user_roles;
                $user_array['article_id'] = $article;
                $user_array['all_roles'] = $all_roles;
                $user_array['article_privilages'] = $article_privilages;
                $user_array['jnl_id'] = $jnl_id;
                $user_roles = $this->get_article_user_roles($user_array);
                $user_rls = isset($user_roles['role_id']) ? $user_roles['role_id'] : array();
                // $article_type_advance =$Article_type_advance_options::get_single_record('atotp_add_notes,atotp_flag_articles,atotp_view_auditrail,atotp_view_email_log,atotp_edit_articles,atotp_stage_manual_reminder,atotp_view_file_inventory',"atotp_artp_id={$article_type}");
                $select = "artp_abbr_article_type,jp_add_notes,jp_flag_articles,jp_view_auditrail,jp_view_email_log,jp_edit_articles,jp_stage_manual_reminder,jp_view_file_inventory,jp_generic_discussion";
                $condition = "artp_id={$article_type}";
                $article_type_advance = $this->get_article_type_permission($select, $condition);

                $tables = array(
                    'main_table' =>  $articleflow_table,
                    'join_table' => array(
                        $genericflow_table => array($genericflow_table . '.jwf_id', $articleflow_table . '.aflw_jwf_id', "join")
                    )
                );
                $select_cur = 'aflw_id,jwf_stage_type,aflw_jwf_id,aflw_status,aflw_usr_id,jwf_forms,jwf_stage_name,jwf_role_id,jwf_assignment,aflw_parent_flow_id,jwf_article_editable';
                $current_stage_detials = Article_flow::get_results_using_joins($tables, $select_cur, "aflw_id={$current_status_id}", 'single');
                /*  $current_stage_detials = $this->Article_flow->get_results_using_joins($tables, 'single', $select_cur, array(
                    'aflw_id' => $current_status_id));
    */

                $jnl_user_roles = User_to_journals::get_user_jnl_roles($this->current_user['user_id'], $jnl_id);
                if ($jnl_user_roles[0]->role_ids != '') {
                    $current_user_roles = explode(';', $jnl_user_roles[0]->role_ids);
                }

                $all_roles = $this->rebuild_array_by_field($all_roles, 'role_id');

                $stage_role = $all_roles[$current_stage_detials->jwf_role_id];
                $current_stage_detials->role_name = $stage_role->role_name;
                $current_stage_detials->role_assigned_role = $stage_role->role_assigned_role;

                /* Article notes */

                if ($article_type_advance->jp_add_notes != '') {
                    $allow_note_roles = json_decode($article_type_advance->jp_add_notes);

                    $article_ids = $this->get_all_version_art_ids($article_data->art_id);
                    $art_note_roles = $Article_notes::get_all_records('an_to,an_read_users,an_posted_by', 'an_art_id IN (' . $article_ids . ')');
                    $note_roles = array();
                    $unread_cnt = 0;
                    $total_cnt = 0;


                    $authr_role_id = Roles::get_role_ids("role_assigned_role IN('author')");
                    $revr_role_id = Roles::get_role_ids("role_assigned_role IN('reviewer')");

                    $revr_role_ids = explode(';', $revr_role_id->role_ids);

                    $jnl_admin_role_id = Roles::get_role_ids("role_assigned_role IN('journal_admin')");
                    $staff_role_id = Roles::get_role_ids("role_assigned_role IN('staff')");
                    $staff_role_ids = explode(';', $staff_role_id->role_ids);
                    $temp_user_roles_notes = array();

                    if (!empty($art_note_roles)) {
                        foreach ($art_note_roles as $an) {

                            $an_roles = ($an->an_to != '') ? json_decode($an->an_to) : array();
                            $an_roles = array_merge((array) $jnl_admin_role_id->role_ids, $an_roles);
                            $an_roles = array_merge($staff_role_ids, $an_roles);
                            $an_roles = array_unique($an_roles);

                            if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && $article_privilages['reviewer'] == true && ($key = array_search($jnl_admin_role_id->role_ids, $an_roles)) !== false) {
                                unset($an_roles[$key]);
                            }
                            if (($key = array_search($authr_role_id->role_ids, $an_roles)) !== false && $article_privilages['author'] == false) {
                                unset($an_roles[$key]);
                            }
                            if (count(array_intersect($revr_role_ids, $user_roles['role_id'])) > 0 && $article_privilages['reviewer'] == false) {
                                $temp_user_roles_notes = array_intersect($revr_role_ids, $user_roles['role_id']);
                            }

                            $an_roles = array_diff($an_roles, $temp_user_roles_notes);

                            $note_roles = array_merge($note_roles, $an_roles);
                            if ($this->current_user['user_id'] != $an->an_posted_by && ((count(array_intersect($user_rls, $allow_note_roles)) > 0 || count(array_intersect($user_rls, $an_roles)) > 0))) {
                                $an_read_users = ($an->an_read_users != '') ? json_decode($an->an_read_users) : array();
                                if (!in_array($this->current_user['user_id'], $an_read_users) && (count(array_intersect($user_rls, $an_roles)) > 0)) {
                                    $unread_cnt++;
                                }
                                if ((count(array_intersect($user_rls, $an_roles)) > 0)) {
                                    $total_cnt++;
                                }
                            } elseif ($this->current_user['user_id'] == $an->an_posted_by) {
                                $total_cnt++;
                            }
                        }
                    }
                    $is_resubmission_stage = false;
                    if ($current_stage_detials->jwf_stage_type == 'resubmission') {
                        $is_resubmission_stage = true;
                    }
                    $enable_note = true;
                    if ($article_data->art_stub != 'y' && (count(array_intersect($user_rls, $allow_note_roles)) > 0 || count(array_intersect($user_rls, $note_roles)) > 0)) {
                        $return_data['show_notes'] = true;
                        $return_data['total_notes_unread'] = $unread_cnt;
                        $return_data['total_notes'] = $total_cnt;
                    }
                    // if (count(array_intersect($current_user_roles, $allow_note_roles)) == 0) {
                    //     $return_data['show_notes'] = false;
                    // }
                    if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && (isset($current_stage_detials) && $current_stage_detials->jwf_stage_type == 'review' && !in_array($current_stage_detials->jwf_role_id, $note_roles) && $article_privilages['reviewer'] == true) && $current_article == $article) {
                        $return_data['show_notes'] = false;
                    }
                    if ($article_data->art_status == 'n' && $is_resubmission_stage == false)
                        $enable_note = false;
                    $show_notes_js = false;

                    $return_data['enable_note'] = $enable_note;
                }
                /* notes */

                // start Generic discussion
                if (isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion == 'y') {

                    $Generic_discussion = new \App\Models\Generic_discussion();
                    $Generic_discussion_comments = new \App\Models\Generic_discussion_comments();
                    $Generic_discussion_read = new \App\Models\Generic_discussion_read();
                    $Discussion_type = new \App\Models\Discussion_type();
                    $Generic_discussion_table = (new \App\Models\Generic_discussion)->getTable();
                    $current_role = $role_id;
                    $core_role = $core_role;
                    $gen_disc_particpants_role_ids = array();
                    $gen_disc_particpants_user_ids = array();
                    $show_discn = false;
                    $gen_total_count = 0;
                    $gen_total_cmnts = 0;
                    $client_code = $this->current_client->clnt_client_code;
                    $client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default.max_disc_commnt_size';
                    $commnt_size   = Config::get($client_default);
                    // $review_config = $this->config->load('clients/' . $client_code . '/client_default');
                    // $commnt_size = $this->config->item('max_disc_commnt_size');
                    $return_data['cmmnt_limit'] = $commnt_size;

                   $gen_sql ='SELECT gdis_participants_by_usr_id,gdis_dsctp_id,gdis_started_by,gdis_participants_by_role_id,
                   IF(tbl_disc_read.total IS NOT null,tbl_disc_read.total, 0) AS unread, tbl_totl_cmnt.total_cmnts
                   FROM '.$Generic_discussion_table.' LEFT JOIN(SELECT  gdsc_gdis_id,GROUP_CONCAT(gdsc_id) as disc_cmnt_id,
                   COUNT(rvw_generic_discussion_cmts.gdsc_gdis_id) AS total FROM rvw_generic_discussion INNER JOIN
                   rvw_generic_discussion_cmts ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id
                   WHERE gdsc_id NOT IN(SELECT gdrs_gdsc_id FROM rvw_generic_discussion_read_status WHERE
                   gdrs_posted_by = '.$this->current_user['user_id'].') AND gdsc_posted_by <>'.$this->current_user['user_id'].'
                   AND gdis_art_id = '.$article.' group by gdis_id) AS tbl_disc_read ON  gdis_id = tbl_disc_read.gdsc_gdis_id LEFT JOIN
                    (SELECT  gdsc_gdis_id,COUNT(gdsc_id) AS total_cmnts FROM rvw_generic_discussion INNER JOIN rvw_generic_discussion_cmts
                    ON rvw_generic_discussion.gdis_id = rvw_generic_discussion_cmts.gdsc_gdis_id WHERE gdsc_id IN(SELECT gdrs_gdsc_id FROM
                    rvw_generic_discussion_read_status WHERE gdrs_posted_by = '.$this->current_user['user_id'].')
                    AND gdis_art_id = '.$article.' AND gdsc_posted_by <> '.$this->current_user['user_id'].' GROUP BY gdis_id)
                    as tbl_totl_cmnt ON gdis_id = tbl_totl_cmnt.gdsc_gdis_id WHERE gdis_art_id='.$article_data->art_id.'
                    AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT null OR
                    gdis_started_by='.$this->current_user['user_id'].') ORDER BY gdis_id ASC' ;
		    $gen_disc_role_ids = $Generic_discussion::get_records_by_raw_query($gen_sql);


            if(!empty($gen_disc_role_ids))
            {
                foreach($gen_disc_role_ids as $disc_user_ids)
                {

                     if(!empty(json_decode($disc_user_ids->gdis_participants_by_usr_id)))
                     {
                        $gen_disc_particpants_user_ids=json_decode($disc_user_ids->gdis_participants_by_usr_id);

                     }
                     $gen_disc_particpants_user_ids[] = $disc_user_ids->gdis_started_by;
                     $gen_total_count = $gen_total_count +$disc_user_ids->unread;
                     $gen_total_cmnts = $gen_total_cmnts + $disc_user_ids->total_cmnts;
                }
            }

                    if (isset($article_type_advance->jp_generic_discussion) && ($article_type_advance->jp_generic_discussion != '')) {
                        $allow_generic_discussion = json_decode($article_type_advance->jp_generic_discussion);
                        if ($core_role == 'reviewer') {
                            if ($current_stage_detials != null && ($current_stage_detials->aflw_status == 'a' || $current_stage_detials->aflw_status == 'c') && (in_array($this->current_user['user_id'], $gen_disc_particpants_user_ids) ||  in_array($current_role, $gen_disc_particpants_role_ids))) {
                                $show_discn = true;
                            }
                        } else {

                            if (in_array($current_role, $gen_disc_particpants_role_ids) || in_array($current_role, $allow_generic_discussion) || in_array($this->current_user['user_id'], $gen_disc_particpants_user_ids)) {
                                $show_discn = true;
                            }
                        }
                    }

                    $return_data['total_comments'] = $gen_total_cmnts;
                    $return_data['total_gen_unread'] = $gen_total_count;
                    $return_data['show_discussion'] = $show_discn;
                }
                /* end generic discussion*/
                /* Task #406: JPR-452 ED/DE/SE/ASs - ability to see auto chase emails and manual (ad-hoc emails sent to reviewers) */

                $enable_email_log = true;
                if ($article_type_advance->jp_view_email_log != '' && (!isset($this->current_user['insist_view_article']) || $current_stage_detials->aflw_status == 'a')) {
                    $allow_emaillog_roles = json_decode($article_type_advance->jp_view_email_log);
                   /*
                    * This code is commented out because it does not check the privillage for user roles to see the Article Rights link email log icon.
                    if($this->current_client->functionality->cfty_receive_email_response == 'y' && (count(array_intersect($user_rls, $allow_emaillog_roles)) > 0)){
                       $return_data['show_email_log'] = true;
                    }
                elseif ($article_data->art_stub != 'y' && (count(array_intersect($user_rls, $allow_emaillog_roles)) > 0)) {
                    */
                    if ($article_data->art_stub != 'y' && (count(array_intersect($user_rls, $allow_emaillog_roles)) > 0)) {
                        $return_data['show_email_log'] = true;
                    }
                    /* Task #9432 Please implement an option to view ad-hoc emails for authors associated with in-progress articles.*/
                    if ( $is_resubmission_stage == false) {
                        $enable_email_log = false;
                    }
                    $return_data['enable_email_log'] = $enable_email_log;
                }

                //Task - 321 switching Issue
                if ($article_privilages['privilaged'] == true && $is_reviewer_in_version != true) {
                    /* Timeline */
                    $enable_timeline = true;
                    $return_data['show_timeline'] = false;
                    if ($article_type_advance->jp_view_auditrail != '') {
                        $allow_audit_roles = json_decode($article_type_advance->jp_view_auditrail);
                        if ($article_data->art_stub != 'y' && (count(array_intersect($user_rls, $allow_audit_roles)) > 0)) {
                            $return_data['show_timeline'] = true;
                        }
                        if (($article_data->art_status == 'n' && $is_resubmission_stage == false) || $article_privilages['author'] == true) {
                            $enable_timeline = false;
                        }
                        $return_data['enable_timeline'] = $enable_timeline;
                    }
                    /* end timeline */



                    //Task 662 Send manual reminder from to stage users like reviewers and authors
                    $return_data['enable_manual_reminder'] = false;
                    $enable_manual_reminder = false;
                    if ($article_type_advance->jp_stage_manual_reminder != '') {
                        $allow_manual_reminder_roles = json_decode($article_type_advance->jp_stage_manual_reminder);
                        if ($article_data->art_stub != 'y' && (count(array_intersect($user_rls, $allow_manual_reminder_roles)) > 0)) {
                            $enable_manual_reminder = true;
                        }
                        if ($article_data->art_status == 'n'  && $is_resubmission_stage == false) {
                            $enable_email_log = false;
                        }
                        if ($current_article !== $article) {
                            $enable_manual_reminder = false;
                        }
                        //Task #476 taskbot CC and BCC emails are not sent in manual reminder
                        if($current_stage_detials->jwf_stage_type == 'review')
                        {
                            $enable_manual_reminder = false;
                        }
                        $return_data['enable_manual_reminder'] = $enable_manual_reminder;
                    }

                    /* Article flags */
                    $enable_flag = true;
                    if ($article_type_advance->jp_flag_articles != '' && $current_article == $article) {
                        $allow_flag_roles = json_decode($article_type_advance->jp_flag_articles);
                        if ($article_data->art_stub != 'y' && (count(array_intersect($user_rls, $allow_flag_roles)) > 0)) {

                            $return_data['show_flag'] = true;
                        }
                        if (($article_data->art_status == 'n'  && $is_resubmission_stage == false) || $article_privilages['author'] == true) {
                            $enable_flag = false;
                        }
                        $isCurrentVersion =Articles::get_single_record('GROUP_CONCAT(art_id) as art_ids',"FIND_IN_SET( {$article}, art_pre_all_ids)")->art_ids;
                        if(!empty($isCurrentVersion)){
                            $enable_flag = false;
                        }
                        if (count(array_intersect($user_rls, $allow_flag_roles)) == 0) {
                            $enable_flag = false;
                        }
                        $return_data['enable_flag'] = $enable_flag;
                    }

                    $enable_inventory = false;
                    if ($article_type_advance->jp_view_file_inventory != '') {
                        $allow_inventory_roles = json_decode($article_type_advance->jp_view_file_inventory);
                        if ((count(array_intersect($user_rls, $allow_inventory_roles)) > 0)) {
                            $enable_inventory = true;
                        }
                        if ($article_data->art_status == 'n'  && $is_resubmission_stage == false) {
                            $enable_inventory = false;
                        }
                    }

                    $return_data['enable_inventory'] = $enable_inventory;

                    $return_data['current_usr'] = $this->current_user['user_id'];

                    $return_data['uri_segm'] = 'view-article';

                    $return_data['art_id'] = $article;

                    //* end flag*/
                }
                $return_data['article_edit_sections'] = false;
                $return_data['article_edit_mode'] = false;

                if ($current_article == $article) {
                    //* start edit article*/
                    $checkout_mode = false;
                    if ($current_stage_detials->aflw_status == 'u' && $current_stage_detials->jwf_assignment == 'self_service' && $current_stage_detials->jwf_stage_type != 'resubmission' && isset($user_roles['role_id']) && in_array($current_stage_detials->jwf_role_id, $user_roles['role_id']) && $article_data->art_status != 't' && ($current_stage_detials->role_assigned_role != 'author' || ($current_stage_detials->role_assigned_role == 'author' && $current_stage_detials->aflw_usr_id == $this->current_user['user_id'])) && $article_privilages['proxy_non_privilaged'] == false) {
                        $checkout_mode = true;
                    }
                    if ($article_privilages['author'] == true && $current_stage_detials->aflw_status == 'a') {

                        if ($article_data->art_submitted_by == $this->current_user['user_id'] && (in_array($current_stage_detials->jwf_stage_type, array(
                            'author_submission',
                            'resubmission'
                        )) || ($current_stage_detials->jwf_stage_type == 'revision' && $current_stage_detials->jwf_article_editable == true) || ($article_data->art_transfer_status == 'y'))) {

                            //  $edit_url = base_url() . 'journal/' . $this->jnl_data->jnl_journal_code . '/' . $article_data->artp_abbr_article_type . '/edit-article/' . encrypt_link($article_data->art_id);

                            // $this->data['article_edit_url'] = $edit_url;
                            if ($current_stage_detials->aflw_status != 'c' && $article_data->art_delete_status == 'n') {
                                $return_data['article_edit_sections'] = true;
                                $return_data['article_edit_mode'] = true;
                            }
                        }
                    } elseif ($article_privilages['privilaged'] == true && $article_type_advance->jp_edit_articles != null && (!in_array($article_data->art_status, array(
                        'r',
                        'n',
                        'c'
                    ))) && count(array_intersect(json_decode($article_type_advance->jp_edit_articles), $user_roles['role_id'])) > 0 && $current_stage_detials->aflw_parent_flow_id == null && $checkout_mode == false &&$article_data->art_delete_status == 'n') {
                        $return_data['article_edit_mode'] = true;
                        $edit_article = true;

                    }
                    if( isset($return_data['article_edit_mode'])&&( $return_data['article_edit_mode']==true))
                    {
                    //* end edit article*/
                    $edit_url = '/' . $this->current_client->platform_type . '/' . $journal_code . '/' . $article_type_advance->artp_abbr_article_type . '/edit-article/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($current_status_id);
                    if(isset($article_data->art_stage_submission_method) && $article_data->art_stage_submission_method == 'n')
                    {
                        $edit_url = '/' . $this->current_client->platform_type . '/' . $journal_code . '/' . $article_type_advance->artp_abbr_article_type . '/edit-article-production/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($current_status_id);
                    }
                    //    $edit_url =  'journal/' . $this->jnl_data->jnl_journal_code . '/' . $article_data->artp_abbr_article_type . '/article-correction/' . encrypt_link($article_data->art_id) . '/' . encrypt_link($current_status_id);
                    $return_data['article_edit_url'] = $edit_url;
                    }
                }

                //* start view pdf*/
                $pdf_detail = $Article_pdf::get_single_record('*', "pdf_art_id={$article} AND pdf_show_status='y'", '', '', 'pdf_id desc');
                $link = '';


                if (!empty($pdf_detail)) {
                    $attachmentfile_table = (new \App\Models\Attachment_files)->getTable();
                    $attachment_file_description_table = (new \App\Models\Attachment_file_description)->getTable();
                    $Attachment_files = new \App\Models\Attachment_files();
                    $tables = array(
                        'main_table' => $attachmentfile_table,
                        'join_table' => array(
                            $attachment_file_description_table => array($attachment_file_description_table . '.afdec_id', $attachmentfile_table . '.atmnt_label', "join")
                        )
                    );

                    $condition = "afdec_exclude_file='n' AND atmnt_art_id={$article} AND atmnt_designated_to like '%r%'";
                    $get_review_status = $Attachment_files::get_results_using_joins($tables, "count(atmnt_id) as cnt", $condition, 'single');


                    $pdf_review_cnd = 'atmnt_art_id = ' . $article . ' AND SUBSTRING_INDEX(atmnt_file_name,".",-1) != "zip" AND afdec_exclude_file="n"';
                    if ($get_review_status->cnt > 0) {
                        $pdf_review_cnd .= ' AND atmnt_designated_to like "%r%"';
                    }
                    $form_select = 'atmnt_id,atmnt_file_name';
                    $all_review_files = $Attachment_files::get_results_using_joins($tables, $form_select, $pdf_review_cnd, 'all', "atmnt_order");

                    $current_order = array();
                    if (!empty($all_review_files)) {
                        $current_order = array_column(json_decode(json_encode($all_review_files), true), 'atmnt_id');
                    }

                    $pdf_file = array(
                        'pdf_id' => $pdf_detail->pdf_id
                    );
                    $pdf_file['preview'] = false;
                    $generated_order = json_decode($pdf_detail->pdf_art_attachement_order);
                    if ($article_privilages['privilaged'] == true || ($generated_order == $current_order && $current_stage_detials->aflw_status != 'i') || $current_article != $article) {
                        //$pdf_file['preview'] = true;
                        $link = '/' . $this->current_client->platform_type . '/' . $journal_code . '/' . $article_type_advance->artp_abbr_article_type . '/view-pdf/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($pdf_detail->pdf_id);
                        // $link = base_url('journal/' . $article_data->jnl_journal_code . '/view-pdf') . '/' . $this->encrypt_data($article_data->art_id) . '/' . $this->encrypt_data($pdf_detail->pdf_id);
                        $return_data['view_pdf'] = true;
                        $return_data['view_pdf_link'] = $link;
                    }
                    //}
                }
                if($this->current_client->functionality->cfty_receive_email_response == 'y'){
                    $notify_email_count_select = "count(esl_id) as count";
                    $notify_email_count_condition = "esl_user_id ={$this->current_user['user_id']} AND esl_article_id = {$article} AND esl_trans_mode='r' AND esl_read_status='u' ";
                    $notify_email_count = Email_send_log::get_all_records($notify_email_count_select,$notify_email_count_condition);
                   if(!empty($notify_email_count)) {
                       $return_data['show_notify_mail'] = $notify_email_count[0]->count;
                    }
                 }
               // get_article_data
               $esarray['article_id']=$article;
               $checkdata=$this->check_espermission_access($esarray);
               $has_es_main_doc_permission = false;
               if($checkdata == true)
               {
                   $check_arr = array('art_id' => $article_data->art_id,'artp_id' => $article_data->artp_id,'role_id' => $role_id,'core_role' => $core_role,'article_privillages' => $article_privilages);
                   $has_es_main_doc_permission = $this->main_doc_permission($check_arr);
               }
                //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && $article_data->art_es_document_type !== null && in_array($article_data->art_es_document_status,['a','y']) && ($article_data->art_status !== 'n' ||  ($article_privilages['author'] == true && $current_stage_detials->aflw_status !== 'i')) && ($article_privilages['reviewer'] == false || ($article_privilages['reviewer'] == true && $current_stage_detials->aflw_status == 'a' && $current_stage_detials->aflw_usr_id == $this->current_user['user_id'])))
                // if($has_es_main_doc_permission==true && $article_data->art_es_document_type !== null && in_array($article_data->art_es_document_status,['a','y']) && ($article_data->art_status !== 'n' ||  ($article_privilages['author'] == true && $current_stage_detials->aflw_status !== 'i')) && ($article_privilages['reviewer'] == false || ($article_privilages['reviewer'] == true && $current_stage_detials->aflw_status == 'a' && $current_stage_detials->aflw_usr_id == $this->current_user['user_id'])))
                // {
                //     $Attachment_file_description_tbl = new \App\Models\Attachment_file_description();
                //     $filediscription_valid = $Attachment_file_description_tbl::get_single_record('afdec_id', 'afdec_main_document="y" AND FIND_IN_SET(' . $role_id . ',afdec_viewable_roles)', '', '', 'afdec_id DESC');  
                //     if($filediscription_valid !== null || $core_role == 'journal_admin' || $article_privilages['author'] == true)
                if($article_data->art_status == 'n' && $article_data->art_prev_article_id == null)
                {
                    $return_data['article_edit_mode'] = false;
                }
                if($has_es_main_doc_permission==true && $article_data->art_es_document_type !== null && in_array($article_data->art_es_document_status,['a','y']) && (($article_data->art_status !== 'n' || $article_data->art_prev_article_id !== null) ||  ($article_privilages['author'] == true && $current_stage_detials->aflw_status !== 'i')) && ($article_privilages['reviewer'] == false || ($article_privilages['reviewer'] == true && $current_stage_detials->aflw_status == 'a' && $current_stage_detials->aflw_usr_id == $this->current_user['user_id'])))
                {
                    $Attachment_file_description_tbl = new \App\Models\Attachment_file_description();
                    $Atmnt_file_descp_tbl_nme = (new \App\Models\Attachment_file_description())->getTable();
                    $Required_file_type_name = (new \App\Models\Required_file_type())->getTable();
                    $criteria = "rft_artp_id=:article_type_id AND afdec_main_document ='y'";
                    $binding_arr = array('article_type_id' => $article_basic_data->art_artp_id);
                    $select = 'afdec_viewable_roles';
                    $tables = array(
                        'main_table' => $Atmnt_file_descp_tbl_nme,
                        'join_table' => array(
                            $Required_file_type_name => array($Required_file_type_name . '.rft_file_desp_id', $Atmnt_file_descp_tbl_nme . '.afdec_id', "left")
                        )
                    );
                    $article_permission_details = $Attachment_file_description_tbl::get_results_using_joins($tables, $select, $criteria, 'single', null, null, '', null, null, false, null, false, $binding_arr);
                    if($article_permission_details !== null)
                    {
                        $view_permissions = explode(',',$article_permission_details->afdec_viewable_roles);
                        if(in_array($role_id,$view_permissions) || $article_privilages['author'] == true || $core_role == 'journal_admin')
                        {
                            $return_data['open_in_rv_rite'] = true;
                        }
                    }

                }

                //icon for show payment by sinan
               // $return_data['show_payment'] = isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y';
            }
            return  $this->success('Success', 200, $return_data);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** used to display right icons according to the permission ends */

    //*** used to save article and stage assignmnent starts ***/
    public function assign_users_to_article(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $User_articles = new \App\Models\User_articles();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'role_id' => 'required',
                'userids' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $journal_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $role_id = isset($post_data['role_id']) ? $this->decrypt_data($post_data['role_id']) : '';
            $stage_id = isset($post_data['art_flow_id']) ? $this->decrypt_data($post_data['art_flow_id']) : '';
            $buttonname = isset($post_data['buttonname']) ? $this->decrypt_data($post_data['buttonname']) : '';
            $existrecord =$this->checkValidRecord($article_id, $stage_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($journal_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $journal_id = $platform_data->jnl_id;
            }
            $users = array();
            if ($post_data['userids'] != '') {
                $users = explode(',', $this->decrypt_data($post_data['userids']));
            }
            if (count($users) > 0) {
                $insert_data = array();
                $selected_user_name = '';
                $cur_reviewers = '';
                foreach ($users as $key => $user) {
                    if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'n') {
                        $chk_user_assigned = $this->check_user_allocate($user, $article_id);
                        if ($chk_user_assigned == false) {
                            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                            $tables = array(
                                'main_table' => $Article_flow_table,
                                'join_table' => array(
                                    $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id')
                                )
                            );
                            //
                            $reviewer_criteria = "aflw_art_id=:article_id AND jwf_assignment=:assignment AND aflw_usr_id=:user" ;
                            $reviwer_role_count = Article_flow::get_results_using_joins($tables, 'count(aflw_id) as cnt', $reviewer_criteria, 'single',null, null, '', null, null,false,null,false,array('article_id'=>$article_id,'assignment'=>'invitation','user'=>$user),"aflw_status IN ('u','i','a')");
                            if ($reviwer_role_count->cnt > 0) {
                                $array_data['user_id'] = $user;
                                $array_data['journal_id'] = $journal_id;
                                $array_data['flag'] = true;
                                $array_data['article_id'] = $article_id;
                                $array_data['jnl_code'] = $jnlcode;
                                $username = $this->get_user_display_name($array_data);
                                if ($selected_user_name != '') $selected_user_name .= ',';
                                $selected_user_name .= $username['fullname'];
                            }
                        }
                    } elseif ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                        $is_reviewer =  $this->check_user_as_reviewer_version($article_id, $user);
                        if ($is_reviewer == true) {
                            $array_data['user_id'] = $user;
                            $array_data['journal_id'] = $journal_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = $article_id;
                            $array_data['jnl_code'] = $jnlcode;
                            $username = $this->get_user_display_name($array_data);
                            if ($selected_user_name != '') $selected_user_name .= ',';
                            $selected_user_name .= $username['fullname'];
                        }
                    }
                    if (empty($selected_user_name) && $buttonname != "allocate-stage-users") {
                        $insertarr_data = array();
                        $insertarr_data['usra_art_id'] = $article_id;
                        $insertarr_data['usra_aflw_id'] = $stage_id;
                        $insertarr_data['usra_role_id'] = $role_id;
                        $insertarr_data['usra_usr_id'] = $user;
                        $insertarr_data['usra_posted_by'] = $this->current_user['user_id'];
                        $insertarr_data['usra_posted_date'] = date('Y-m-d H:i:s');
                        $insertarr_data['usra_operation'] = 'i';
                        $insertarr_data['usra_proxy_id'] = $this->current_user['proxy_user_id'];
                        $insert_data[] = $insertarr_data;
                    }
                }
                if (empty($selected_user_name)) {
                    if ($buttonname == "allocate-stage-users") {
                        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                        $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                        $tables = array(
                            'main_table' => $Article_flow_table,
                            'join_table' => array(
                                $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id')
                            )
                        );
                        $criteria = "aflw_art_id=:article_id AND aflw_id=:stage_id";
                        $previous_data = Article_flow::get_results_using_joins($tables, 'aflw_jwf_id,aflw_level,jwf_tat_complete', $criteria, 'single',null, null, '', null, null,false,null,false,array('article_id'=>$article_id,'stage_id'=>$stage_id));
                        $today = date('Y-m-d H:i:s', time());
                        $insertarr_data['aflw_parent_flow_id'] = $stage_id;
                        $insertarr_data['aflw_art_id'] = $article_id;
                        $insertarr_data['aflw_jwf_id'] = $previous_data->aflw_jwf_id;
                        $insertarr_data['aflw_usr_id'] = $users[0];
                        $insertarr_data['aflw_assigned_date'] = $today;
                        $insertarr_data['aflw_accepted_date'] = $today;
                        $insertarr_data['aflw_status'] = 'a';
                        $insertarr_data['aflw_level'] = $previous_data->aflw_level;
                        $due_date = new \DateTime($today);
                        //$due_date = $due_date->modify('+' . $previous_data->jwf_tat_accept . ' days');
                        // $due_date = $due_date->modify('+' . $previous_data->jwf_tat_complete . ' days');
                        // $due_date = $due_date->format('Y-m-d H:i:s');
                        $due_date = $this->get_due_date_for_article($article_id, $previous_data->jwf_tat_complete);
                        $insertarr_data['aflw_due_date'] = $due_date;
                        $new_flow_id = Article_flow::insert_record($insertarr_data, $this->current_user);

                        $Article_type_advance_options = (new \App\Models\Article_type_advance_options)->getTable();
                        $select_article_details = 'art_id,art_artp_id,art_code,art_title,art_abstract,art_resubmission_no,art_status,art_submission_date,art_doi,art_submitted_by,artp_article_type,art_published_article_type,art_article_upload_path,art_transfer_status,art_skipped_assignment_roles,art_delete_status,art_publication_issue,jwf_status_name,jwf_stage_name,jnl_journal_name,artp_fwm_id,art_stage_submission_method,auth_usr_id,aflw_id,jnl_id,jnl_journal_code,artp_id,jwf_assignment,aflw_parent_flow_id,aflw_status,aflw_usr_id,jwf_stage_type,jwf_who_can_invite,jwf_parent_user_roles,aflw_skip_review,aflw_reopened_min_user_count,jwf_fwm_id,jwf_stage_name,aflw_art_id,aflw_level,jwf_parent_stages,jwf_enable_transfer,jwf_role_id,aflw_jwf_id,jwf_id,jwf_connect_to_es,aflw_usr_id,jwf_flow_proceed_type,artp_jpm_id,aflw_stage_min_users,art_prev_article_id,(select atotp_article_submission_type from ' . $Article_type_advance_options . ' where atotp_artp_id = art_artp_id ) as art_submission_type,jwf_enable_popup_after_completion';
                            $condition = " aflw_id=:aflw_id";
                            $condition_arr=array(
                                'aflw_id'=>$new_flow_id
                            );

                        $article_cur_stage_assignment = Articles::get_article_details($select_article_details, $condition, null, true, false,null,$condition_arr);
                        $this->get_stage_assignment_emaildetails($users,$article_cur_stage_assignment, $journal_id, $jnlcode);
                    } else {
                        $insert_ids = $User_articles::insert_batch($insert_data, $this->current_user);
                        $return_arr['alloc_users_cnt'] = count($insert_data);
                    }
                    $return_arr['status'] = 'success';
                    $return_arr['forms_validated'] = $this->validate_stage_forms($stage_id, $journal_id, $jnlcode);
                } else {
                    if ($selected_user_name != '') {
                        $return_arr['status'] = 'warning';
                        $return_arr['msg'] = str_replace('%user full name%', trim($selected_user_name, ', '), customTrans('viewarticle.restrict_assign_to_usr_article'));
                    } elseif ($cur_reviewers != '') {
                        $return_arr['status'] = 'warning';
                        $return_arr['msg'] = str_replace('%user full name%', trim($cur_reviewers, ', '), customTrans('viewarticle.restrict_assign_shortlist'));
                    }
                }
            } else {
                $return_arr['msg'] = customTrans('viewarticle.user_not_selected');
            }
            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    //*** used to save article and stage assignmnent ends ***/

    //*** check user is a reviewer in any version starts ***/
    public function check_user_as_reviewer_version($article_id, $user_id)
    {
        $Article_versions_reviewers = new \App\Models\Article_versions_reviewers();
        $Article_versions_reviewers_table = ($Article_versions_reviewers)->getTable();
        $qry = 'SELECT count(artvr_id) as count FROM ' . $Article_versions_reviewers_table . ' WHERE `artvr_user_id` = ' . $user_id . ' AND ((FIND_IN_SET(' . $article_id . ', artvr_previous_art_ids) > 0 ) OR artvr_article_id=' . $article_id . ')';
        //
        $reviewer_exist = $Article_versions_reviewers::get_records_by_raw_query($qry, true);
        $is_reviewer_in_version = (isset($reviewer_exist->count) && $reviewer_exist->count > 0) ? true : false;
        return $is_reviewer_in_version;
    }
    //*** check user is a reviewer in any version ends ***/

    //***  display allocated user list (stage & article assignment) starts ***/
    public function get_assignment_to_article(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'roles' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $journal_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $roles = isset($post_data['roles']) ? $post_data['roles'] : '';
            $flow_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : '';
            $existrecord =$this->checkValidRecord($article_id, $flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($journal_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $journal_id = $platform_data->jnl_id;
            }
            $type =isset($post_data['type']) ? $this->decrypt_data($post_data['type']) : '';
            $skipped_roles = array();
            //$condition= 'aflw_id=' . $flow_id . ' and aflw_usr_id=' . $this->current_user['user_id'];
            $condition='aflw_art_id=:article_id and aflw_usr_id=:aflw_usr_id and aflw_skip_assignment is NOT null';
            $article_details = Article_flow::get_single_record('aflw_skip_assignment',$condition,null,'',null,array('article_id'=>$article_id,'aflw_usr_id'=>$this->current_user['user_id']));
            if (isset($article_details) && $article_details->aflw_skip_assignment != null) {
                $skipped_roles = array_filter(explode(',', $article_details->aflw_skip_assignment));
            }
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
            $tables = array(
                'main_table' => $Article_flow_table,
                'join_table' => array(
                    $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id')
                )
            );
            $criteria = "aflw_art_id=:article_id AND aflw_id=:flow_id";
            $assignmenttype = Article_flow::get_results_using_joins($tables, 'jwf_assignment', $criteria, 'single', null, null, '', null, null,false,null,false,array('article_id'=>$article_id,'flow_id'=>$flow_id));
            $assignmentprivilage = $assignmenttype->jwf_assignment;
            $User_articles = new \App\Models\User_articles();
            $result = array();
            $user_role_arr = array();  $data =array();
            /*if ($assignmentprivilage != 'manual') {

                foreach ($roles as $role) {
                    $assigned_users = $User_articles::get_all_records('usra_id,usra_usr_id,usra_posted_by,usra_merge_date,usra_role_id', 'usra_art_id=' . $article_id . ' and usra_role_id=' . $role['role_id']);
                    print_r($assigned_users); die;
                    if (!empty($assigned_users)) {
                        foreach ($assigned_users as $ak => $assign) {
                            $array_data['user_id'] = $assign->usra_usr_id;
                            $array_data['journal_id'] = $journal_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = $article_id;
                            $array_data['jnl_code'] = $jnlcode;
                            $assign->usr_full_name = $this->get_user_display_name($array_data);
                            $user_role_arr[$role['role_id']][] = $assign->usra_usr_id;
                        }
                    }
                    $data[][$role['role_id']]['user'] = $assigned_users;
                }
            } else {*/
                foreach ($roles as $role) {
                    if($type!='article')
                    {
                    $criteria = "aflw_art_id=:article_id AND aflw_parent_flow_id=:flow_id and jwf_role_id=:role";
                    $platform_data = $this->platform_basic_settings_data($jnlcode);
                    $date_format = static::date_format_map($platform_data->jset_date_format);
                    $getdetails = Article_flow::get_results_using_joins($tables, 'aflw_usr_id,DATE_FORMAT(aflw_accepted_date, "' . $date_format . ' ") as accepted_date,aflw_jwf_id,aflw_posted_by,aflw_id', $criteria, 'single', null, null, '', null, null,false,null,false,array('article_id'=>$article_id,'flow_id'=>$flow_id,'role'=>$role['role_id']));
                    $user_array = array();
                    if (isset($getdetails->aflw_usr_id)) {
                        $array_data['user_id'] =  $getdetails->aflw_usr_id;
                        $array_data['journal_id'] = $journal_id;
                        $array_data['flag'] = true;
                        $array_data['article_id'] = $article_id;
                        $array_data['jnl_code'] = $jnlcode;
                        $user_array['usr_full_name'] = $this->get_user_display_name($array_data);
                        $array_data['user_id'] =  $getdetails->aflw_posted_by;;
                        $user_array['posteduser'] = $this->get_user_display_name($array_data);
                        $user_array['accepted_date'] = $getdetails->accepted_date;
                        $user_array['aflw_jwf_id'] = $getdetails->aflw_jwf_id;
                        $user_array['aflw_id'] = $getdetails->aflw_id;
                        $user_array['aflw_usr_id'] = $getdetails->aflw_usr_id;
                        $user_arrays[] = $user_array;
                        $data[][$role['role_id']]['user'] = $user_arrays;
                        $user_role_arr[$role['role_id']][] = $getdetails->aflw_usr_id;
                    }
                    }
                    if($type!='stage')
                    {
                    $assigned_users = $User_articles::get_all_records('usra_id,usra_usr_id,usra_posted_by,usra_merge_date,usra_role_id', 'usra_art_id=:article_id and usra_role_id=:roleid',null, null,'', null, null,'ASC',array('article_id'=>$article_id,'roleid'=>$role['role_id']));
                    if (!empty($assigned_users)) {
                        foreach ($assigned_users as $ak => $assign) {
                            $array_data['user_id'] = $assign->usra_usr_id;
                            $array_data['journal_id'] = $journal_id;
                            $array_data['flag'] = true;
                            $array_data['article_id'] = $article_id;
                            $array_data['jnl_code'] = $jnlcode;
                            $assign->usr_full_name = $this->get_user_display_name($array_data);
                            $user_role_arr[$role['role_id']][] = $assign->usra_usr_id;
                        }
                    }

                    $data[][$role['role_id']]['user'] = $assigned_users;
                }
                }
           // }
            $result['skipped_roles'] = $skipped_roles;
            $result['user_role_arr'] = $user_role_arr;

            $result['allocation'] = $data;
            return  $this->success('Success', 200, $result);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }
    //***  display allocated user list (stage & article assignment) ends ***/

    //***  get all article assignment users along with role starts ***/
    public function get_all_assigned_user(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $user_role_arr = array();
            $user_array = array();
            $article_id = isset($post_data['art_id']) ? Rv_decrypt($post_data['art_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $journal_id = isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']) : '';
            $flow_id = isset($post_data['art_flow_id']) ? Rv_decrypt($post_data['art_flow_id']) : '';
            $existrecord =$this->checkValidRecord($article_id, $flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($journal_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $journal_id = $platform_data->jnl_id;
            }
            $User_articles = new \App\Models\User_articles();
            $User_articles_table = ($User_articles)->getTable();
            $Roles_table = (new \App\Models\Roles())->getTable();
            $userjournal_table = (new \App\Models\User_to_journals())->getTable();
            $join_tables_users = array(
                'main_table' => $User_articles_table,
                'join_table' => array(
                    $Roles_table => array(
                        $Roles_table . '.role_id', 
                        $User_articles_table . '.usra_role_id'
                    ),
                    $userjournal_table => array(
                        $userjournal_table . '.usrj_usr_id', 
                        $User_articles_table . '.usra_usr_id', 
                        'left' 
                    )
                ),
                'raw_condition' => $userjournal_table . '.usrj_role_id = ' . $User_articles_table . '.usra_role_id'
            );
            $select_users = 'DISTINCT(usra_usr_id),role_name,usra_art_id, usra_art_id,usrj_role_retired';
            $where_users = 'usra_art_id=:article_id';
            $group_by = 'usra_usr_id';
            $article_users = $User_articles::get_results_using_joins($join_tables_users, $select_users, $where_users, 'all',null, null, '', null, null,false,$group_by,false,array('article_id'=>$article_id));
            if (!empty($article_users)) {
                foreach ($article_users as $assigned_users) {
                    // $user_array[$assigned_users->usra_usr_id]['role_name'][] =  $assigned_users->role_name;
                      //TASK #9647 Users assigned: If any retired role exists in the user's assigned list, it should be marked as retired.
                    $user_array[$assigned_users->usra_usr_id]['role_name'][] = [
                        'name' => $assigned_users->role_name,
                        'retired' => $assigned_users->usrj_role_retired // Add retirement status
                        ];
                    $array_data['user_id'] = $assigned_users->usra_usr_id;
                    $array_data['journal_id'] = $journal_id;
                    $array_data['flag'] = true;
                    $array_data['article_id'] = $article_id;
                    $array_data['jnl_code'] = $jnlcode;
                    $user_array[$assigned_users->usra_usr_id]['user_full_name'] = $this->get_user_display_name($array_data);
                }
            }
            $result['assign_user'] = $user_array;
            return  $this->success('Success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    //***  get all article assignment users along with role ends ***/

    //***  save data when user skips assignment for a particular role starts ***/
    public function skip_user_assignment(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'stage_id' => 'required',
                'art_id' => 'required',
                'role_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $art_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $aflw_id = isset($post_data['stage_id']) ? $this->decrypt_data($post_data['stage_id']) : '';
            $role_id = isset($post_data['role_id']) ? $this->decrypt_data($post_data['role_id']) : '';
            $jnl_code = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $jnl_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $existrecord =$this->checkValidRecord($art_id, $aflw_id,$jnl_code);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($jnl_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnl_code);
            $jnl_id = $platform_data->jnl_id;
            }
            $article_details = Article_flow::get_single_record('aflw_skip_assignment', 'aflw_id=:aflw_id',null,'',null,array('aflw_id'=>$aflw_id));
            $skipped_roles = array();
            if ($article_details->aflw_skip_assignment != null) {
                $skipped_roles = array_filter(explode(',', $article_details->aflw_skip_assignment));
            }

            $skipped_roles[] = $role_id;
            $skipped_role_str = join(',', array_unique($skipped_roles));
            $update_result = Article_flow::update_record(array(
                'aflw_skip_assignment' => $skipped_role_str
            ), 'aflw_id=' . $aflw_id, $this->current_user,'','k');
            if ($update_result > 0) {
                $result =  array(
                    'forms_validated' => $this->validate_stage_forms($aflw_id, $jnl_id, $jnl_code),
                    'message' => customTrans('viewarticle.skip-user-assignment-success')
                );
                return $this->success('Success', 200, $result);
            } else {
                $result = array(
                    'message' => customTrans('viewarticle.skip-user-assignment-failed')
                );
                return $this->warning('failed', 402, $result);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    //***  save data when user skips assignment for a particular role ends ***/

    //***  delete allocated article user starts ***/
    public function delete_allocated_article_user(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $id = isset($post_data['id']) ? $this->decrypt_data($post_data['id']) : '';
            $User_articles = new \App\Models\User_articles();
            $where_users = 'usra_id=' . $id;
            $article_users = $User_articles::delete_records($where_users, '', $this->current_user);
            if (!empty($article_users)) {
                $result = array(
                    'message' => customTrans('viewarticle.user_remove_success')
                );
            }
            return  $this->success('Success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    //***  delete allocated article user starts ***/
// suspecious changes
public function get_suspecious_user_details(Request $request)
{
    try {
        $this->current_user = $this->get_current_user_details();
        $current_client   = $this->current_client;
        $post_data = $request->all();
        $return_arr = array();
        $art_id = isset($post_data['art_id']) ? ($post_data['art_id']) : '';
        $journalCode = isset($post_data['jnl_code']) ? ($post_data['jnl_code']) : '';
        $Journals         = new \App\Models\Journals;
        $journalData      = $Journals::get_journal_data($journalCode);
        $jset_date_format =  $this->get_platform_date_format($journalData->jnl_id);
         if (isset($jset_date_format) && !empty($jset_date_format)) {
                $dateFormat = $jset_date_format;
            } else {
                $dateFormat = $current_client->settings->cs_date_format;
            }
        if(!empty($art_id))  
        {
        //$groupBy = "sup_ltk_id";
        $dateFormat = date_format_map($dateFormat);
        $suspecious_activity_table = (new \App\Models\Suspecious_activity)->getTable();;
        $login_tracking_table = (new \App\Models\Login_tracking())->getTable();
        $User_tbl_name = (new \App\Models\User())->getTable();
        $Roles_name_tbl = (new \App\Models\Roles())->getTable();
        $articleFlow_tbl    = (new \App\Models\Article_flow())->getTable();
        $GenericFlows_tbl    = (new \App\Models\Generic_flows())->getTable();
        $select='role_name,sup_ltk_id,ltk_ip,sup_ref_ltk_id,sus_flag_status,sup_id,ltk_browser,DATE_FORMAT(sup_submission_date, "' . $dateFormat . ' %h:%i %p") as ltk_posted_date,jwf_stage_name,usr_id';
        $condition_array = "sup_art_id=? AND sus_flag_status=?";
        $binding_arr1 = array($art_id,'y');    
        $tables = array(
            'main_table' => $suspecious_activity_table,
            'join_table' => array(
                $login_tracking_table => array($login_tracking_table . '.ltk_id', $suspecious_activity_table . '.sup_ltk_id', "join"),
                $User_tbl_name => array($User_tbl_name . '.usr_id', $suspecious_activity_table . '.sup_usr_id', "join"),
                $Roles_name_tbl => array($Roles_name_tbl . '.role_id', $suspecious_activity_table . '.sup_role_id', "join"),
                $articleFlow_tbl => array($articleFlow_tbl . '.aflw_id', $suspecious_activity_table . '.sup_aflw_id', "join"),
                $GenericFlows_tbl => array($GenericFlows_tbl . '.jwf_id', $articleFlow_tbl . '.aflw_jwf_id', "left"),
            )
        );
        $details = Suspecious_activity::get_results_using_joins($tables, $select, $condition_array, 'all',NULL,NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr1);
        $detailsArray = [];
        $array_data_sus = [];
        if (!empty($details)) {
            foreach ($details as $key => $row) {
                $id = $row->sup_ref_ltk_id;
                if (!isset($detailsArray[$id])) {
                    $detailsArray[$id] = [
                        'id' => [],
                        'shortdetails' => [],
                        'fullname' => [],
                        'role_name' => [],
                        'ltk_ip' => [],
                        'stage_name' => [],
                        'ltk_browser' => [],
                        'ltk_posted_date' => [],
                    ];
                }
                // Append data to respective keys
                $name='';
                $array_data_sus['user_id']      = $row->usr_id;
                $array_data_sus['journal_id']   = $journalData->jnl_id;
                $array_data_sus['article_id']   = $art_id;
                $blind_user = $this->get_user_display_name($array_data_sus);
                if(isset($blind_user['fullname']))
                {
                    $name= $blind_user['fullname'];
                }
                
                $detailsArray[$id]['id'][] = $id;
                $detailsArray[$id]['shortdetails'][] = "{$name} [{$row->role_name}] (stage- {$row->jwf_stage_name})";
                $detailsArray[$id]['fullname'][] = "{$name}";
                $detailsArray[$id]['role_name'][] = strtoupper($row->role_name);
                $detailsArray[$id]['ltk_ip'][] = $row->ltk_ip;
                $detailsArray[$id]['stage_name'][] = $row->jwf_stage_name;
                $detailsArray[$id]['ltk_browser'][] = $row->ltk_browser;
                $detailsArray[$id]['ltk_posted_date'][] = $row->ltk_posted_date;
                $detailsArray[$id]['id'] = array_unique($detailsArray[$id]['id']);
                
            }
        }
        
   
        if(!empty($details))
        {
            $return_arr['success']=true;
            $return_arr['data']=$detailsArray;
        }else
        {
            $return_arr['success']=false;
            $return_arr['data']=$detailsArray;  
        }
        }else
        {
            $return_arr['success']=false;
            $return_arr['data']='';   
        }
        return $this->success("Success",200,$return_arr);

    }catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }

}

    //***  get all the stages till completed and also inviation stage when its not active starts ***/
    public function get_compeltedstage_details(Request $request)
    {
        try {
            $message = '';
            $return_array = array();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'roleid' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $User = new \App\Models\User();
            $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['art_flow_id']) ?  Rv_decrypt($post_data['art_flow_id']) : '';
            $platform_id = isset($post_data['jnl_id']) ? Rv_decrypt($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $roleid = isset($post_data['roleid']) ? Rv_decrypt($post_data['roleid']) : '';
            $core_role = isset($post_data['core_role']) ? Rv_decrypt($post_data['core_role']) : '';
            $version = isset($post_data['version']) ? $post_data['version'] : '';
            $mainart_id = isset($post_data['mainart_id']) ? Rv_decrypt($post_data['mainart_id']) : '';
            $existrecord = $this->checkValidRecord($art_id, $art_flow_id, $jnlcode);
            $inprogress_stage = false;
            if ($existrecord == false) {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if ($platform_id == '') {
                $platform_data = $this->platform_basic_settings_data($jnlcode);
                $platform_id = $platform_data->jnl_id;
            }
            $this->current_user = $this->get_current_user_details();
            $this->repeatedstagearray =   array();
            $review_to_orcid = false;
            $flowdetails = array();
            $newarray = array();
            $is_reviewer_in_version = false;
            $remove_tab_andform = true;
            $aflow_ids ='';
            $group_by = 'aflw_posted_date,aflw_jwf_id';
            $criteria = 'aflw_art_id =' . $art_id;
            $article_flow_table = (new \App\Models\Article_flow())->getTable();
            if (!empty($art_flow_id)) {
                if ($version == "old") {

                    $condition = "art_id=:mainart_id";
                    $condition_arr = array(
                        'mainart_id' => $mainart_id
                    );
                    $article_data = Articles::get_article_details('artp_jpm_id,artp_id,art_version_no,art_id,artp_fwm_id,art_status,aflw_parent_flow_id,jwf_stage_type,art_code,art_delete_status,aflw_status', $condition, null, true, false, null, $condition_arr);
                    $article_data = $article_data[0];
                } else {
                    $condition = "aflw_id=:art_flow_id";
                    $condition_arr = array(
                        'art_flow_id' => $art_flow_id
                    );
                    $article_data = Articles::get_article_details('artp_jpm_id,artp_id,art_version_no,art_id,artp_fwm_id,art_status,aflw_parent_flow_id,jwf_stage_type,art_code,art_delete_status,aflw_status', $condition, null, true, false, null, $condition_arr);
                    $article_data = $article_data[0];
                }

                if ($this->current_client->modules->mdl_orcid == 'y' && $this->current_client->functionality->cfty_review_to_orcid == 'y' && $article_data->jwf_stage_type == 'review') {
                    $review_to_orcid = true;
                }
                $Article_type_advance_options = new \App\Models\Article_type_advance_options();
                $article_type_advance = $Article_type_advance_options::get_single_record('atotp_review_open_decision,atotp_review_open_count', "atotp_artp_id=:artp_id", null, '', null, array('artp_id' => $article_data->artp_id));
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $workflow_arr  = Config::get($workflow_config);
                $cutstagedata = $workflow_arr[$article_data->jwf_stage_type];
                $stage_for = $cutstagedata['stage_for'];
                //echo '<pre>'; print_r($article_data); die;

                if ($version == "old") {
                    $article_privilages = $this->article_privilages($article_data, null, $jnlcode);
                } else {
                    $article_privilages = $this->article_privilages($article_data, $art_flow_id, $jnlcode);
                }

                //TASK #8653 Once an article reaches the publishing stage, the author can view the attachment if the mdl_copyedit module is active, and the file description visibility is set to 'Author.
                if (isset($this->current_client->modules->mdl_copyedit) && $this->current_client->modules->mdl_copyedit == 'y' && $article_privilages['author'] == true)  {
                    $flow_data = (new Article_flow())->select('aflw_jwf_id', 'aflw_status')->whereHas('journal_workflow', function ($query) {$query->where('jwf_stage_type', 'publish'); })->where('aflw_status', 'c') ->where('aflw_art_id', $art_id)->first()?->toArray();
                    if(!empty($flow_data)){
                        $stage_for ='manageproduction';
                            $aflow_ids = DB::table('rvw_production_attachment_files AS prod_attach')
                            ->select(DB::raw('GROUP_CONCAT(prod_attach.paf_aflw_id) AS aflow_ids'))
                            ->join('rvw_attachment_file_description AS file_desc', 'prod_attach.paf_description_id', '=', 'file_desc.afdec_id')
                            ->where('file_desc.afdec_attach_to_author', 'y')
                            ->where('prod_attach.paf_art_id', $art_id)
                            ->whereNotIn('prod_attach.paf_aflw_id', function($query) use ($art_id) {
                                $query->select(DB::raw('MAX(paf_aflw_id)'))
                                    ->from('rvw_production_attachment_files')
                                    ->join('rvw_attachment_file_description', 'afdec_id', '=', 'paf_description_id')
                                    ->join('rvw_article_flow', 'paf_aflw_id', '=', 'aflw_id')
                                    ->where('paf_art_id', $art_id)
                                    ->where('afdec_attach_to_author', 'y')
                                    ->groupBy('aflw_jwf_id');
                                })
                            ->first();
                        }
                }
                
                $user_permited_roles = $this->user_permitted_role($this->current_user['user_id'], $jnlcode, $article_data->artp_id);
                if ($this->current_client->modules->mdl_review_for_doc == 'n') {
                    $user_allocate = $this->check_user_allocate($this->current_user['user_id'], $art_id);

                    if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y' && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') {
                        if ($user_allocate == false && $user_permited_roles == false) {
                            $is_reviewer_in_version = $this->check_user_as_reviewer_version($article_data->art_version_no, $this->current_user['user_id']);
                        }
                    }
                }

                $show_review_for_author = false;
                $show_author_for_reviewer = false;
                if ($article_privilages['author'] == true)
                    $viewable_role = 'author';
                elseif ($article_privilages['reviewer'] == true)
                    $viewable_role = 'reviewer';

                $all_user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $article_data->artp_id);
                if (isset($all_user_roles['role_id']) && empty($all_user_roles['role_id'])) {
                    return  $this->success('Success', 200, $return_array);
                }
                $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
                /* Roles assigned to this article */
                $user_array = array();
                $user_array['user_roles'] = $all_user_roles;
                $user_array['article_id'] = $art_id;
                $user_array['all_roles'] = $all_roles;
                $user_array['article_privilages'] = $article_privilages;
                $user_array['jnl_id'] = $platform_id;
                $user_roles = $this->get_article_user_roles($user_array);
                // echo '<pre>';  print_r($article_privilages); die;
                //print_r($user_roles['role_id']);
                if (!empty($viewable_role)) {

                    $tab_status = $this->show_tab($user_roles, $art_id, $viewable_role, $jnlcode, $roleid, $this->current_user["user_id"]);

                    ($viewable_role == 'author') ? $show_review_for_author = $tab_status : $show_author_for_reviewer = $tab_status;
                }
                $articleflow_table = (new \App\Models\Article_flow)->getTable();
                $Generic_forms_table = (new \App\Models\Generic_forms)->getTable();
                $join_table = '';
                if ($article_privilages['author'] == true) { //Get tabs for authors

                    $author_role_id = $user_roles['role_id'][0];

                    //1901 Reviewer comments not visible to author
                    //$group_by = 'aflw_jwf_id';
                    $group_by = 'aflw_posted_date,aflw_jwf_id';
                    //$group_by='';// transfer data is not displaying for author once completed and also when when the suggesting transfer more than once.

                    $join_table = '(SELECT IF(aflw_parent_flow_id IS NOT null,aflw_parent_flow_id,aflw_id) as id from ' . $articleflow_table . ',rvw_article_gnf_form_data_' . $jnlcode . ',' . $Generic_forms_table;
                    $join_table .= ' where aflw_id = gdata_artflw_id AND gncf_id = gdata_atf_id AND aflw_status IN (\'w\',\'c\') AND gdata_art_id = "' . $art_id . '"  AND CASE WHEN FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true END ) as tb1';
                    $author_stages = "'transit','authors_declaration','revision','resubmission','copyright'";
                    if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') && $stage_for != "review") {
                        $author_stages = "'pro_revision'";
                    }
                    $criteria .= ' AND jwf_stage_type != "author_submission" AND ((( jwf_stage_type IN ( ' . $author_stages . ' ) AND aflw_status = "c"  ) ';

                    if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') && $stage_for != "review") {
                        $usr_roles_id = implode(',', $user_roles['role_id']);
                        $attach_designate_sql = 'WHEN FIND_array_intersect(\'' . $usr_roles_id . '\',adr_role_id)=1 THEN true';
                        $criteria .= ' OR (aflw_status = "c" and ( CASE WHEN aflw_usr_id = ' . $this->current_user['user_id'] . ' THEN  true ' . $attach_designate_sql . ' WHEN FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true ELSE false END ) )';
                    }
                    //$criteria .= '  and case when aflw_status=\'w\' then aflw_id !=' . $art_flow_id.' else true end';
                    if ($article_privilages['proxy_non_privilaged'] == false) {
                        if (isset($this->currentstatusid)) {
                            $criteria .= 'OR ( aflw_status IN ("a") AND aflw_usr_id =  ' . $this->current_user['user_id'] . '  AND aflw_id = ' . $this->currentstatusid . ' )';
                        }
                        $criteria .= ' )';
                        /*
                        // When the author acts as a proxy, an empty stakeholder tab is displayed if no form or element with a viewable role is assigned to the author.
                        //TASK Bolt #90 Restrict Authors from Viewing Reviewers' Comments. 
                        if (($article_data->art_status == 'a' || $article_data->art_status == 'c') && $show_review_for_author == true) {
                            $criteria .= ' OR ( jwf_assignment = "invitation" AND aflw_parent_flow_id IS null  AND aflw_status = "c") ';
                        }*/
                        if ($stage_for == 'review')
                        $criteria .= 'OR ( tb1.id = aflw_id )';
                        $criteria .= ' )';
                    } else
                        $criteria .= ' ))';
                } elseif (($article_privilages['privilaged'] == false && $article_privilages['reviewer'] == true) || ($article_privilages['privilaged'] == true && $article_privilages['reviewer'] == true && $article_privilages['user_allocated'] == false)) { // For reviewers
                    $author_stages = "'revision','resubmission'";
                    //$group_by = 'aflw_jwf_id';

                    $join_table = '(SELECT IF(aflw_parent_flow_id IS NOT null,aflw_parent_flow_id,aflw_id) as id from ' . $articleflow_table . ',rvw_article_gnf_form_data_' . $jnlcode . ',' . $Generic_forms_table;
                    $join_table .= ' where aflw_id = gdata_artflw_id AND gncf_id = gdata_atf_id AND aflw_status IN (\'w\',\'c\') AND gdata_art_id = "' . $art_id . '"  AND CASE WHEN FIND_IN_SET("' . $roleid . '",REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $roleid . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true END ) as tb1 ';

                    $criteria .= ' AND (( (aflw_usr_id =  ' . $this->current_user['user_id'];
                    $sub_criteria = '';

                    if (isset($this->currentstatusid)) {
                        $criteria .= ' OR aflw_id = ' . $this->currentstatusid;
                        $sub_criteria = ' OR aflw_status ="a" ';
                    }
                    $criteria .= ' )  AND ( aflw_status ="c" ' . $sub_criteria . ')) OR (tb1.id = aflw_id and aflw_usr_id is not null)';
                    //$criteria .= ' )  AND ( aflw_status ="c" '.$sub_criteria.'))';
                    if ($show_author_for_reviewer == true)
                        $criteria .= ' OR jwf_stage_type IN ( ' . $author_stages . ' )';
                    $criteria .= ') AND jwf_stage_type != "author_submission"';
                } elseif ($article_privilages['privilaged'] == true && $is_reviewer_in_version != true) {
                    // Get all  tabs or own tabs for privileged users
                    if ($stage_for == "review" || $core_role == 'journal_admin') {
                        $criteria .= ' and jwf_stage_type != "author_submission"  AND ( (
                        CASE WHEN jwf_assignment="invitation" and aflw_parent_flow_id is null THEN true WHEN jwf_assignment!="invitation" and aflw_status="c" and aflw_usr_id is NOT null THEN true WHEN jwf_stage_type="payment" THEN true ELSE false END';

                        $article_flow_table = (new \App\Models\Article_flow)->getTable();;
                        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                        $tables = array(
                            'main_table' => $article_flow_table,
                            'join_table' => array(
                                $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "left")
                            )
                        );
                        $reviewerflwid = !empty($art_flow_id) ? $art_flow_id : $article_data->aflw_parent_flow_id;
                        $reviewer_criteria = "aflw_art_id=:aflw_art_id AND jwf_assignment=:jwf_assignment AND aflw_usr_id=:aflw_usr_id and aflw_status=:aflw_status and aflw_id=:aflw_id";
                        $binding_arr = array(
                            'aflw_art_id' => $art_id,
                            'jwf_assignment' => 'invitation',
                            'aflw_usr_id' => $this->current_user['user_id'],
                            'aflw_status' => 'c',
                            'aflw_id' => $reviewerflwid
                        );

                        $reviwer_role_count = Article_flow::get_results_using_joins($tables, 'count(aflw_id) as cnt', $reviewer_criteria, 'single', null, null, '', null, null, false, null, false, $binding_arr);
                        $is_reviewer = (isset($reviwer_role_count->cnt) && $reviwer_role_count->cnt > 0) ? true : false;
                        $skipflow = '';
                        if (!empty($article_data->aflw_parent_flow_id)) {
                            if ($is_reviewer == false) {
                                $skipflow = " and aflw_id !={$article_data->aflw_parent_flow_id} ";
                            }

                            $criteria .= "  and case when aflw_status!='w' then true when aflw_status='w' " . $skipflow . " then true else false end  ";
                        } else {
                            if ($is_reviewer == false) {
                                $skipflow = " and aflw_id !={$art_flow_id} ";
                            }
                            $criteria .= "  and case when aflw_status!='w' then true when aflw_status='w' " . $skipflow . " then true else false end  ";
                        }
                        $close = ')';
                        $criteria .= $close . ' )';
                    }
                    if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') && $stage_for != "review") {
                        if ($core_role != 'journal_admin' && $core_role != 'production_manager') {
                            $criteria .= ' and aflw_status=\'c\'';
                            $usr_roles_id = implode(',', $user_roles['role_id']);

                            $attach_designate_sql = 'WHEN FIND_array_intersect(\'' . $usr_roles_id . '\',adr_role_id)=1 THEN true';
                            $criteria .= ' AND ( CASE WHEN aflw_usr_id = ' . $this->current_user['user_id'] . ' THEN  true ' . $attach_designate_sql . ' WHEN gncf_user_roles IS null THEN true WHEN gncf_user_roles = "[]" THEN true WHEN  FIND_array_intersect(\'' . $usr_roles_id . '\',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) = 1 THEN true END ) ';
                        } else {
                            $criteria .= ' and aflw_status=\'c\'';
                        }
                    }
                } else {
                    $criteria .= ' and aflw_status=\'c\' and  jwf_stage_type!="author_submission"';
                }
                $stages = array();
                $Journal_settings = new \App\Models\Journal_settings;
                $jnl_date_format = $Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$platform_id}' ")->jset_date_format;
                $date_format = $this->date_format_map($jnl_date_format);
                if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') && $core_role != 'journal_admin') {
                    $typedata = (isset($stage_for) && $stage_for == "review") ? true : false;
                    $review_stages = $this->get_production_stages_keys(false, $typedata);
                    //echo '<pre>'; print_r($review_stages); die;
                    $criteria .= trim($criteria) != '' ? ' and ' : '';
                    $criteria .= " jwf_stage_type  in ('" . implode("','", $review_stages) . "')";
                }

                if ($criteria != '') {
                     //iframe request from RvRite
                    if(isset($post_data['fetch_only_latest']) && $post_data['fetch_only_latest'] == true)
                    {
                        $criteria .= " AND jwf_stage_type='review' AND aflw_usr_id=".$this->current_user['user_id'];
                    }
                    //TASK #8653 Once an article reaches the publishing stage, the author can view the attachment if the mdl_copyedit module is active, and the file description visibility is set to 'Author.
                    if (isset($this->current_client->modules->mdl_copyedit) && $this->current_client->modules->mdl_copyedit == 'y' && $article_privilages['author'] == true)  {
                        if(!empty($aflow_ids) && isset($aflow_ids->aflow_ids) && !empty($aflow_ids->aflow_ids)  ){
                            $criteria .= " AND aflw_id  not in ('" . implode("','", explode(",",$aflow_ids->aflow_ids)) . "')";
                        }
                    }
                   // DB::enableQueryLog();
                    // TASK BOlt 90  Restrict Authors from Viewing Reviewers' Comments
                    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                    $flowdetails = Article_flow::getcompletedstages('aflw_stage_repeat_count,jwf_stage_type,jwf_stage_name,aflw_id,aflw_jwf_id,aflw_status,jwf_tab_name,jwf_no_of_min_users,jwf_no_of_max_users,jwf_parent_user_roles,jwf_who_can_invite,aflw_stage_min_users,jwf_role_id,aflw_parent_flow_id,jwf_reviewers_discuss_forum,jwf_forms,aflw_skip_assignment,aflw_usr_id,DATE_FORMAT(aflw_returned_date, "' . $date_format . ' ") as returned_date,jwf_assignment,aflw_skip_review,aflw_more_review_skip_status,aflw_bypassed_status,aflw_art_id,atotp_review_method,aflw_posted_date,aflw_posted_by,artp_id,art_id,artp_fwm_id,jwf_child_stages,jwf_flow_proceed_type,aflw_level,art_delete_status,jwf_status_name,aflw_stage_max_users,jwf_fwm_id,aflw_returned_date,jwf_parent_stages,jwf_id,atotp_custom_blind_params,art_status,art_submitted_by,aflw_assignment_type_id,aflw_source_assignment_id,atotp_author_viewable_content', $criteria, $group_by, $join_table, $jnlcode, $stage_for);
                }

//                 $query = DB::getQueryLog();
// $query = end($query); 
// print_r($query);exit;
                /* Set flag for inprogress stage to set scroll  **/
                $stage_inpro = Article_flow::get_stage_details('aflw_usr_id =  ' . $this->current_user['user_id'].' AND aflw_id='.$art_flow_id.' AND aflw_status=\'a\' and aflw_art_id ='.$art_id, 'count(aflw_id) as cnt');
             
               if($stage_inpro->cnt)
               {
                   $inprogress_stage = true;
               }
               
               /* Set flag for inprogress stage to set scroll  **/
                $count = 0;
                $prevcount = '';
                $prevflow = '';
                $open_forms = array();
                $review_exists = false;
                $flw_id_array = array();
                $flworder = 0;
                $newarray = array();
                $conflict_interest = array();
                if ($this->current_client->modules->mdl_review_for_doc == 'n') {
                    $conflict_interest = $this->get_article_conflict_array($art_id);
                }
                foreach ($flowdetails as $index_flow => $flow) {
                    $flow->remove_unwanted_tab = $remove_tab_andform; // to do
                    // TASK BOlt 90  Restrict Authors from Viewing Reviewers' Comments
                    $author_viewablecontent=isset($flow->atotp_author_viewable_content)?$flow->atotp_author_viewable_content:'n';



                    if ($article_privilages['author'] == true && $author_viewablecontent=='y') {
                        $array_data['visble_status']='TRUE';
                        $array_data['authorcanviewcontent']=$author_viewablecontent;
                        $array_data['art_id']=$art_id;
                        $array_data['flow']=$flow;
    
                        $resaurhorcomment=$this->checkParentstgeisauthorstage($array_data);
                        $flow->aurhorcomment=$resaurhorcomment;
                        if($resaurhorcomment=='n'){
                            continue;
                        }

                    }

                    if($article_privilages['privilaged'] == false && $article_privilages['author'] == true && $flow->jwf_assignment=="invitation" && $flow->aflw_status =='w')
                    {
                        $completed_reviews = Article_flow::get_single_record('count(*) as completed','aflw_status = \'c\' and aflw_parent_flow_id='.$flow->aflw_id);
                        if($completed_reviews->completed < $flow->aflw_stage_min_users)
                        {
                            continue;
                        }
                    }
                    if ($article_privilages['privilaged'] == false && $article_privilages['reviewer'] == true && $article_privilages['user_allocated'] == false) {
                        if (in_array($flow->aflw_jwf_id, $flw_id_array) && $flow->aflw_status == 'c' && $flow->aflw_parent_flow_id != '') {
                            //unset($flowdetails[$flworder]);
                            continue;
                        }
                        $flw_id_array[] = $flow->aflw_jwf_id;
                    }
                    $completedformarr = array();
                    $completedformreviewarr = array();
                    $completedformreviewflowarr = array();
                    //$article_privilages = $this->article_privilages($flow, $flow->aflw_id, $jnlcode);
                    //$user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $flow->art_artp_id);
                    $completed_forms = $this->get_completed_forms($flow, $article_privilages, $all_user_roles, $this->current_user, $jnlcode, null, $platform_id, $roleid);
                    $completed_forms_exist = $completed_forms['forms_exist'];
                    $completed_forms = $completed_forms['forms'];

                    $i = 0;
                    $completedformarr[$flow->aflw_id] = [];

                    $author_stages = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission');
                    $stage_author = false;
                    if (in_array($flow->jwf_stage_type, $author_stages))
                        $stage_author = true;
                    $username_status = true;
                    $reviewer_order = '';
                    $reviewer_name = '';
                    $multiple_label = '';
                    if ($flow->aflw_usr_id != '' || $flow->aflw_posted_by != '') {
                        if ($flow->aflw_usr_id == '')
                            $flow_usr_id = $flow->aflw_posted_by;
                        else
                            $flow_usr_id = $flow->aflw_usr_id;
                        $array_data['user_id'] = $flow_usr_id;
                        $array_data['journal_id'] = $platform_id;
                        $array_data['flag'] = true;
                        $array_data['article_id'] = $art_id;
                        $array_data['jnl_code'] = $jnlcode;
                        $array_data['fullname_only'] = true;
                        $array_data['jwf_role_id'] = $flow->jwf_role_id;
                        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                        $conflict = array();
                        $array_data['conflict_interest'] = '';
                        if (isset($flow->aflw_usr_id) && ($flow->aflw_usr_id != null)) {
                            $conflict = $this->get_user_conflict_of_interest($conflict_interest, $flow->aflw_usr_id);
                            if (!empty($conflict) && $conflict != null) {
                                $array_data['conflict_interest'] = $conflict;
                            }
                        }
                        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                        $flow->completeuser = $this->get_user_display_name($array_data);
                    }
                    /* Rescind review */
                    $rescind_review_link = false;
                    $is_previous = false;
                    $decision_stage_article_status = array('a', 'r', 'c');

                    $is_reviewer = false;
                    if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') {
                        $is_reviewer = $article_privilages['reviewer'];
                    }

                    $Journal_permission_mastertable = new \App\Models\Journal_permission_master;
                    $journal_permission_master = (new \App\Models\Journal_permission_master())->getTable();
                    $Journal_permission = (new \App\Models\Journal_permission())->getTable();
                    $criteria = "jpm_id='{$article_data->artp_jpm_id}'";
                    $select = '*';
                    $tables = array(
                        'main_table' => $journal_permission_master,
                        'join_table' => array(
                            $Journal_permission => array($journal_permission_master . '.jpm_id', $Journal_permission . '.jp_jpm_id', "left")
                        )
                    );

                    $article_permission_details = $Journal_permission_mastertable::get_results_using_joins($tables, $select, $criteria, 'single');


                    if ($article_permission_details->jp_rescind_review != null && $flow->jwf_stage_type == 'review' && $is_previous == false && $is_reviewer == false) {
                        if (in_array($roleid, json_decode($article_permission_details->jp_rescind_review)) && !in_array($article_data->art_status, $decision_stage_article_status)) {
                            $rescind_review_link = true;
                        }
                    }



                    $msg = '';

                    if ($flow->aflw_id != $prevflow)
                        $count = 0;
                    $permission_form = false;
                    $reviewpermission_form = false;
                    $excluded_deleted_status_arr = array(
                        'w',
                        'h'
                    );
                    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                    $stage_type = $flow->jwf_stage_type;
                    $workflow_id = $flow->jwf_id;
                    $flow_master_id = $flow->artp_fwm_id;
                    $workflow_assignment_type_selection = $this->workflow_assignment_type_seletion_status($stage_type);
                    $source_assign_status = $workflow_assignment_type_selection['source_assign_status'];
                    $get_selected_workflow_assignment_for_source_stage = array();
                    $source_assigned_users = array();
                    if ($source_assign_status == true) {
                        $get_selected_workflow_assignment_for_source_stage = $this->get_selected_workflow_assignment_type_for_source_or_destination_stage_view_article($workflow_id, true, $flow_master_id);
                        if (!empty($get_selected_workflow_assignment_for_source_stage)) {
                            $data_array['get_selected_workflow_assignment_for_source_stage'] = $get_selected_workflow_assignment_for_source_stage;
                            $data_array['workflow_id'] = $workflow_id;
                            $data_array['art_id'] = $flow->art_id;
                            $data_array['date_format'] = $date_format;
                            $data_array['article_data'] = $article_data;
                            $data_array['jnl_code'] = $jnlcode;
                            $source_assigned_users = $this->get_source_assigend_users($data_array);
                            if (!empty($source_assigned_users)) {
                                $flow->source_assigned_users = $source_assigned_users;
                            }
                        }
                    }
                    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                    if ($flow->jwf_assignment == 'invitation') {
                        $review_exists = true;
                        $show_invited = true;
                        $data['show_invited'] = $show_invited;
                        if ($article_privilages['privilaged'] == true && $article_privilages['author'] == false) {

                            $article_flow_table = (new \App\Models\Article_flow())->getTable();
                            $article_reviwers_table = (new \App\Models\Article_reviewers())->getTable();
                            $reject_reason_table = (new \App\Models\Reject_reasons())->getTable();
                            $article_flow_alternativereviewer_priorityorder_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();
                            $usertable = (new \App\Models\User())->getTable();

                            $join_flow_reviwewer = " FROM " . $article_flow_table . " as af INNER JOIN " . $article_reviwers_table . " ON sorw_aflw_id=aflw_id";
                            $reject_reson_join = '';
                            $alternative_reviwer_join = '';
                            /*$assg_tables = array(
                    'main_table' => Article_flow::$tbl_name . ' as af ',
                    'join_table' => array(
                        Article_reviewers::$tbl_name => 'sorw_aflw_id=af.aflw_id'
                    ));*/
                            $assg_criteria = " WHERE aflw_parent_flow_id={$flow->aflw_id}";
                            $show_invited = ($flow->jwf_assignment == 'invitation') ? true : false;
                            $order_by = '';
                            $select = 'SELECT sorw_id,aflw_id,aflw_usr_id,aflw_status,sorw_invited_by,sorw_suggested_user_id,aflw_due_date,DATE_FORMAT(sorw_suggested_on, "' . $date_format . '") as suggested_date,DATE_FORMAT(sorw_invited_on, "' . $date_format . '") as invited_date,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as due_date,aflw_posted_by,aflw_remarks,aflw_returned_date,aflw_usr_review_reopen,sorw_author_suggested';

                            $select .= ',IF(((select max(b.aflw_id) from ' . $article_flow_table . ' as b  where b.aflw_usr_id = af.aflw_usr_id and b.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id) && rjct_reinvite_flag ="y"  && (select count(aflw_id) from ' . $article_flow_table . ' as c  where c.aflw_usr_id = af.aflw_usr_id and c.aflw_parent_flow_id = af.aflw_parent_flow_id and c.aflw_status != "i" and c.aflw_status !="a" and c.aflw_status !="c")>0,1,0) as reinvte_condition,IF( ( ( SELECT MAX(d.aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id and af.aflw_status = "g" ) > 0, 1, 0 ) AS reinvte_unassigned_condition,(select count(aflw_id) from ' . $article_flow_table . ' as d  where d.aflw_usr_id = af.aflw_usr_id and d.aflw_parent_flow_id = af.aflw_parent_flow_id) as reviewer_invite_count,IF( ( ( SELECT MAX(e.aflw_id) FROM rvw_article_flow AS e WHERE e.aflw_usr_id = af.aflw_usr_id AND e.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id ) &&( SELECT COUNT(aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_parent_flow_id = af.aflw_parent_flow_id AND d.aflw_status = "d") <= 1, 1, 0 ) AS reviewer_invite_condition,sorw_usr_source';
                            $reject_reson_join = " LEFT JOIN " . $reject_reason_table . " ON sorw_rjct_id=rjct_id";


                            if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')) {
                                $select .= ',afap_id,afap_number';
                                $order_by = ' ORDER BY afap_number ASC';
                                $alternative_reviwer_join = " LEFT JOIN " . $article_flow_alternativereviewer_priorityorder_table . " ON afap_aflw_id = aflw_id";
                            }
                            /* to recognise if added through reviewer on fly or not */
                            $select .= ',(CASE WHEN sorw_usr_source=\'p\' THEN \'n\' WHEN `sorw_posted_by`=`sorw_suggested_user_id` and EXISTS(
                    SELECT `usr_id` FROM ' . $usertable . ' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
                    and `usr_status`=\'w\')   then \'y\' else \'n\' end ) as added_through_fly, (SELECT DATE_FORMAT(usr_posted_date, "' . $date_format . '") as user_posted FROM ' . $usertable . ' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
                    and `usr_status`=\'w\') as user_posted_date';
                            /* to recognise if added through reviewer on fly or not */

                            $assigned_users_sql = $select . $join_flow_reviwewer . $reject_reson_join . $alternative_reviwer_join . $assg_criteria . $order_by;

                            //$assigned_users = $this->Article_flow->get_results_using_joins($assg_tables, 'all', $select, $assg_criteria,$order_by);
                            $assigned_users = Article_flow::get_records_by_raw_query($assigned_users_sql);
                            $conflict_interest = array();
                            if ($this->current_client->modules->mdl_review_for_doc == 'n') {
                                $conflict_interest = $this->get_article_conflict_array($flow->art_id);
                            }
                            $flow_privilages = array();
                            $data_flw = array('jwf_parent_user_roles' => $flow->jwf_parent_user_roles, 'jwf_who_can_invite' => $flow->jwf_who_can_invite);
                            $flow_privilages['article_flow_details'] = (object) $data_flw;
                            $flow_privilages['article_data'] = (object) array('artp_id' => $article_data->artp_id);
                            $user_array_invite_shortlist = $this->get_who_can_shortlist_invite_users($flow_privilages, $art_id, $platform_id, $jnlcode);
                            $assigning_roles = ($flow->jwf_parent_user_roles != '') ? json_decode($flow->jwf_parent_user_roles) : array();
                            $inviting_roles = ($flow->jwf_who_can_invite != '') ? json_decode($flow->jwf_who_can_invite) : array();
                            $has_assign_permission = $has_invite_permission = false;

                            if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $assigning_roles)) > 0 && (isset($user_array_invite_shortlist['assigned_user_ids'])) && (in_array($this->current_user['user_id'], $user_array_invite_shortlist['assigned_user_ids']))) {
                                $has_assign_permission = true;
                            }

                            if (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'], $inviting_roles)) > 0 && (isset($user_array_invite_shortlist['who_can_invite_user_ids'])) && (in_array($this->current_user['user_id'], $user_array_invite_shortlist['who_can_invite_user_ids']))) {
                                $has_invite_permission = true;
                            }



                            $data['has_invite_permission'] = $has_invite_permission;
                            $data['has_assign_permission'] = $has_assign_permission;
                            $is_previous = false;
                            //if ($flow->jwf_stage_type == 'review')
                            //{
                            /*$current_status_id=decrypt_link($post_data['current_status_id']);
			        $current_stage_active = ($current_status_id == $flow->aflw_id) ? true : false;*/
                            $current_stage_active = false;
                            $data['current_stage_active'] = $current_stage_active;



                            $show_next_stage_button = false;
                            $child_stage_count = Article_flow::get_single_record('SUM(CASE WHEN aflw_status ="c" THEN 1 ELSE 0 END) AS completed_child_stages', "aflw_parent_flow_id={$flow->aflw_id}");
                            if ($is_previous == false && $flow->aflw_status == 'w' && $article_data->art_status == "y") {
                                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                                $review_flow  = Config::get($workflow_config);
                                //	$next_stage = $this->get_next_stages($article_flow_details->jwf_id, $article_flow_details->jwf_fwm_id, $article_id,false,$review_flow);
                                $next_stage = array(
                                    'proceed_type' => 'manual',
                                    'stages' => array()
                                );
                                if (isset($next_stage['stages'][0])) {

                                    if (isset($next_stage['stages']) && $next_stage['stages'][0]['stage_type'] == "post_assessment") {
                                        $next_stage['stages'][0]['confirm_msg'] = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
                                    }
                                    $data['move_next_stage'] = $next_stage['stages'][0];
                                    $data['next_stage_id'] = $next_stage['stages'][0]['stage_id'];
                                }

                                if ($child_stage_count->completed_child_stages >= $flow->aflw_stage_min_users) {
                                    if (isset($article_data->jp_edit_reviewer_count) && count(array_intersect($user_roles['role_id'], json_decode($article_data->jp_edit_reviewer_count))) > 0) {
                                        $show_next_stage_button = true;
                                    }

                                    if (
                                        !empty($next_stage['stages']) && (!isset($flow->aflw_reopened_flow_id) || (isset($flow->aflw_reopened_flow_id) && $flow->aflw_reopened_flow_id == null))
                                    ) {

                                        foreach ($next_stage['stages'] as $stg) {
                                            $next_stages = Article_flow::get_single_record('count(aflw_id) as count', "aflw_art_id={$art_id} AND aflw_jwf_id={$stg['stage_id']}");
                                            if ($next_stages->count > 0) {
                                                $show_next_stage_button = false;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            $enable_button_active = false;
                            if ($has_invite_permission == true || $has_assign_permission == true) {
                                $enable_button_active = true;
                            }

                            //$stage_completed = ($child_stage_count->completed_child_stages == $article_flow_details->aflw_stage_min_users || $article_flow_details->aflw_satus == 'c') ? true : false;
                            if ($this->current_client->modules->mdl_review_for_doc == 'n') {
                                if ($flow->aflw_status == 'c') {
                                    if ($article_type_advance->atotp_review_open_decision == "y") {

                                        $return_date = $flow->aflw_returned_date;
                                        $added_date = date('Y-m-d h:i:s', strtotime($return_date . ' +' . $article_type_advance->atotp_review_open_count . ' days'));
                                        $current_date = date('Y-m-d h:i:s');

                                        $date1 = new \DateTime($current_date);
                                        $date2 = new \DateTime($added_date);

                                        if ($date1 > $date2)
                                            $enable_button_active = false;
                                    } else {
                                        $enable_button_active = false;
                                    }
                                }
                                if ($article_data->art_status != "y" || $is_previous == true) {
                                    $enable_button_active = false;
                                }
                                if (($flow->jwf_fwm_id != $article_data->artp_fwm_id) || ($article_data->art_status == 't')) {
                                    $enable_button_active = false;
                                    $data['current_stage_active'] = false;
                                }
                            } elseif ($flow->aflw_status == 'c') {
                                $enable_button_active = false;
                            }

                            if ($flow->aflw_more_review_skip_status == 'y' || $flow->aflw_skip_review == 'y') {
                                $enable_button_active = false;
                            }

                            $flow_id = ($flow->aflw_parent_flow_id == null) ? $flow->aflw_id : $flow->aflw_parent_flow_id;

                            $data['enable_button_active'] = $enable_button_active;
                            $data['readonly_button'] = 'Edit reviewer list';

                            $data['article_flow_details'] = $flow;
                            $data['show_next_stage_button'] = $show_next_stage_button;
                            //$data['client_functionality'] = $this->current_client->functionality;
                            $data['show_multiple_checkbox'] = true;

                            $data['read_only'] = false;
                            //	$assignment_editable_roles = json_decode($article_data->atotp_edit_reviewer_count);
                            /*if ($assignment_editable_roles != null && $current_stage_active == true && (count(array_intersect($user_roles['role_id'], $assignment_editable_roles)) > 0))
                    {
                        $data['read_only'] = false;
                    }*/
                            if (in_array($article_data->art_delete_status, $excluded_deleted_status_arr)) {
                                $data['current_stage_active'] = false;
                                $data['read_only'] = true;
                                $enable_button_active = $data['enable_button_active'] = false;
                            }
                            if ((isset($article_data->art_status)) && ($article_data->art_status == 'c')) {
                                $data['current_stage_active'] = false;
                            }
                            $skip_content = '';
                            $flow->skip_content = $skip_content;
                            if ($flow->aflw_more_review_skip_status == 'y') {
                                $sql1 = 'select aflw_posted_date from tbk_article_flow where aflw_usr_id is null and  aflw_art_id=' . $art_id . ' and aflw_reopened_min_user_count!=\'0\' and aflw_reopened_min_user_count=aflw_stage_min_users';
                                $res1 = Article_flow::get_records_by_raw_query($sql1);
                                $sql2 = 'select aflw_posted_date from tbk_article_flow where aflw_more_review_skip_status =\'y\' and aflw_art_id=' . $art_id . ' and aflw_parent_flow_id is null and aflw_reopened_flow_id=0';
                                $res2 = Article_flow::get_records_by_raw_query($sql2);

                                $i = 0;


                                if (!empty($res1) && !empty($res2)) {
                                    foreach ($res1 as $res) {
                                        if (isset($res2[$i])) {
                                            if ($i > 0)
                                                $skip_content .= '<hr class="seperator"/>';
                                            $skip_content .= 'Received for more review on ' . str_replace('%', '', date_format(date_create($res->aflw_posted_date), $date_format)) . ' and skipped on ' . str_replace('%', '', date_format(date_create($res2[$i]->aflw_posted_date), $date_format));
                                            $i++;
                                        }
                                    }
                                }
                                $flow->skip_content = $skip_content;
                            }
                            $data['skip_content'] = $skip_content;
                            //#3323 Setting re-open review button on the reviewer list
                            $data['article_data_set'] = $article_data;
                            $data['is_previous'] = $is_previous;
                            $data['is_previous'] = $is_previous;
                            $data['assignment_only'] = false;
                            $data['reopen'] = false;
                            //$data['cfty_enable_review_resubmit']=$this->current_client->functionality->cfty_enable_review_resubmit;
                            $arr_set = array('a', 'r', 'c');
                            if (isset($this->current_client->functionality->cfty_enable_review_resubmit) && $this->current_client->functionality->cfty_enable_review_resubmit == 'y' && (isset($article_data->art_status) && !in_array($article_data->art_status, $arr_set)) && (isset($is_previous) && $is_previous == false) && $article_data->art_delete_status == 'n') {
                                $data['reopen'] = true;
                            }

                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                            $array_data['assigned_users'] = $assigned_users;
                            $array_data['art_id'] = $art_id;
                            $array_data['platform_id'] = $platform_id;
                            $array_data['conflict_interest'] = $conflict_interest;
                            $array_data['data'] = $data;
                            $flow->assigned_users = $this->get_assigned_user_array($array_data);
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */

                            $flow->shortlistinfo = $this->get_short_list_details($flow->aflw_id);
                            $flow->enable_button_active = $enable_button_active;
                            $flow->has_invite_permission = $has_invite_permission;
                            $flow->has_assign_permission = $has_assign_permission;
                        }



                        if ($article_privilages['author'] == true && $article_privilages['privilaged'] == false && $flow->jwf_stage_type == 'review') {
                            $multiple_label = $flow->jwf_stage_name;
                        } elseif ($article_privilages['author'] == true && $article_privilages['privilaged'] == false) {
                            $multiple_label = $flow->jwf_stage_name;
                        } else {
                            $multiple_label = $flow->jwf_stage_name . " by  ";
                        }


                        if ($article_privilages['privilaged'] == true || (($article_privilages['reviewer'] == true || $article_privilages['author'] == true))) {
                            $parent_flow_id = ($article_data->aflw_parent_flow_id != null) ? $article_data->aflw_parent_flow_id : $art_flow_id;
                            if ($article_privilages['reviewer'] == false) {
                                $accepted_article_flows = Article_flow::get_single_record('GROUP_CONCAT(aflw_id) as flow_id,GROUP_CONCAT(aflw_usr_id) as flow_usr_id', 'aflw_parent_flow_id =' . $parent_flow_id . ' AND aflw_status  IN ("a")'); // before form submit no ned to display form
                            }
                        }



                        if ($article_privilages['reviewer'] == true && $flow->aflw_usr_id != '') {
                            //$review_flowdetails =  Article_flow::get_all_records('*',"aflw_id={$flow->aflw_id} ");
                            //TASK #4501 client functionality show_decline_reviewprocess_tab is not working in review3
                            if (isset($this->current_client->functionality->cfty_show_decline_reviewprocess_tab) && $this->current_client->functionality->cfty_show_decline_reviewprocess_tab == 'y') {
                                $art_flw_criteria = "aflw_id={$flow->aflw_id} and aflw_status in ('a','i','c','u','d') ";
                            } else {
                                $art_flw_criteria = "aflw_id={$flow->aflw_id} and aflw_status in ('a','i','c','u') ";
                            }
                        } elseif ($article_privilages['reviewer'] == true && $flow->aflw_usr_id == '') {
                            $art_flw_criteria = "aflw_parent_flow_id={$flow->aflw_id} and aflw_status ='c'";
                        } else {
                            if (isset($this->current_client->functionality->cfty_show_decline_reviewprocess_tab) && $this->current_client->functionality->cfty_show_decline_reviewprocess_tab == 'y') {
                                $art_flw_criteria = "aflw_parent_flow_id={$flow->aflw_id} and aflw_status in ('a','i','c','u','d')";
                            } else {
                                if ($article_privilages['author'] == true && $flow->jwf_stage_type == 'review') {
                                    $art_flw_criteria = "aflw_parent_flow_id={$flow->aflw_id} and aflw_status in ('c')";
                                } else {
                                    //$review_flowdetails =  Article_flow::get_all_records('*',"aflw_parent_flow_id={$flow->aflw_id} ");
                                    $art_flw_criteria = "aflw_parent_flow_id={$flow->aflw_id} and aflw_status in ('a','i','c','u')";
                                }
                            }
                            //End TASK #4501 client functionality show_decline_reviewprocess_tab is not working in review3
                        }
                        // TASK #7802 Reviewer re order issue in completed review tab
                        $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                        
                        $formatted_journal_code = '_' . $jnlcode;
                        $select = 'distinct aflw_id,aflw_art_id,aflw_status,aflw_usr_id,jwf_stage_type,jwf_stage_name,aflw_posted_by,aflw_remarks,jwf_status_name';
                        $art_flw_tables = array(
                            'main_table' => $article_flow_table,
                            'join_table' => array(
                                $Generic_flows_table => array($article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id')
                            )
                        );

                        $article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'all', 'aflw_returned_date asc', null, '', null, null, true);
                        if (count($article_flow_dets) > 0) {
                            foreach ($article_flow_dets as $usra) {
                                $count++;
                                $completedformreviewarr['flow' . $usra->aflw_id] = [];
                                $completedformreviewflowarr['childflow_id'] = $usra->aflw_id;

                                if ($usra->aflw_status == 'a') {
                                    $count--;
                                }

                                if (isset($flow->jwf_stage_type) && ($flow->jwf_stage_type == 'review') && $article_privilages['privilaged'] == true) {
                                    $reviewer_order = "Reviewer #" . $count . " : ";
                                }
                                $returndate = '';
                                // $returndate=$flow->returned_date;
                                if (empty($returndate)) {
                                    $returndate =  Article_flow::get_single_record('DATE_FORMAT(aflw_returned_date, "' . $date_format . ' ") as returned_date', "aflw_id={$usra->aflw_id}");
                                    $returndate = $returndate->returned_date;
                                }
                                $reviewer_name =    ' on ' . $returndate;
                                //hide author name in double blind for reviewer
                                if ($stage_author == true && (($flow->atotp_review_method == 'd' && $article_privilages['reviewer'] == true && $article_privilages['privilaged'] == false) || $this->is_custom_blinded('author', $art_id, jnl: $jnlcode, blinded_user:$usra->aflw_usr_id))) {
                                    $reviewer_name = ' Author';
                                    $username_status = false;
                                }
                                if ($flow->atotp_review_method != 'o' && (($flow->atotp_review_method != 'c' && $flow->jwf_stage_type == 'review' && $article_privilages['author'] == true) || ($this->is_custom_blinded($flow->jwf_role_id, $art_id, jnl: $jnlcode, blinded_user:$usra->aflw_usr_id)))) {
                                    $reviewer_name = "Reviewer #" . $count;
                                    $username_status = false;
                                    $return_array['priv'] = $article_privilages;
                                }
                                if ($article_privilages['author'] == true && $article_privilages['privilaged'] == false && $flow->jwf_stage_type == 'review') {
                                    $multiple_label = $flow->jwf_status_name . " by  ";
                                } elseif ($article_privilages['author'] == true && $article_privilages['privilaged'] == false) {
                                    $reviewer_name = '';
                                    $username_status = false;
                                }

                                $where = ' gdata_artflw_id =  ' . $usra->aflw_id . ' AND gdata_art_id = ' . $usra->aflw_art_id;

                                if ($flow->jwf_stage_type == 'review' || $flow->jwf_stage_type == 'author_submission') {
                                    if ($article_privilages['author'] == true && isset($flow->atotp_review_method) && $flow->atotp_review_method != 'o') {
                                        $author_role_id = $user_roles['role_id'][0]; // when user has author role in an article then other roles are removed
                                        //author need to display all author form regardless of checking the viewable form
                                        if ($stage_author == false) {
                                            //$where.=' and CASE WHEN (gncf_user_roles is null or gncf_user_roles="[]") and gdata_posted_by!=' . $this->current_user["user_id"] . ' THEN false ELSE JSON_SEARCH(gncf_user_roles,"one","' . $author_role_id . '") IS NOT null OR gdata_posted_by =' . $this->current_user["user_id"] . ' END';

                                            //$criteria = 'aflw_status IN ("c")  and gdata_art_id ='.$article_id ;
                                            //1901 Reviewer comments not visible to author
                                            $where .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true END ';
                                        }
                                    } elseif ($article_privilages['author'] == false && $article_privilages['reviewer'] == false) {
                                        //$where .= ' and CASE WHEN gncf_user_roles is null or gncf_user_roles="[]"  THEN true ELSE JSON_SEARCH(gncf_user_roles,"one","' . $this->current_user['jnl_user_role'][$this->jnl_data->jnl_journal_code]['role_id'] . '") IS NOT null OR gdata_posted_by =' . $this->current_user["user_id"] . ' END ';
                                        $user_roles_form = $user_roles["role_id"];
                                        if ($article_privilages['privilaged'] == true) {
                                            $author_key = array_search("author", $user_roles["assigned_roles"]);
                                            if ($author_key !== false && $author_key >= 0) {

                                                unset($user_roles_form[$author_key]);
                                            }
                                        }
                                        $where .= ' and CASE WHEN gncf_user_roles IS null THEN true WHEN gncf_user_roles = "[]" THEN true WHEN FIND_array_intersect(REPLACE(REPLACE(REPLACE(gncf_user_roles,\']\',\'\'),\'[\',\'\'),\'"\',\'\'), "' . implode(",", $user_roles_form) . '") >0 THEN true WHEN gdata_posted_by =' . $this->current_user["user_id"] . ' THEN true END';

                                        //$where .= ' and (gncf_user_roles is null or gncf_user_roles="[]"  or FIND_array_intersect(REPLACE(REPLACE(REPLACE(gncf_user_roles,\']\',\'\'),\'[\',\'\'),\'"\',\'\'), "'.implode(",",$user_roles_form).'") >0 OR gdata_posted_by =' . $this->current_user["user_id"].')';

                                    } elseif ($article_privilages['reviewer'] == true) {
                                        $user_role_key = $roleid;
                                        $reviewer_key = array_search("reviewer", $user_roles["assigned_roles"]);
                                        if ($reviewer_key !== false && $reviewer_key >= 0) {
                                            $user_role_key = $user_roles['role_id'][$reviewer_key];
                                        }
                                        $where .= ' AND CASE WHEN gdata_posted_by =' . $this->current_user["user_id"] . ' THEN true  WHEN FIND_IN_SET(' . $user_role_key . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $user_role_key . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true END';
                                    }
                                }
                                // remove element form custom form settings bug fixed
                                $form_select ="CASE WHEN emt_hideafterstage IS NULL THEN (SELECT emt_hideafterstage FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='label' order by tbk_id DESC limit 1) ELSE emt_hideafterstage END AS emt_hideafterstage, CASE WHEN emt_element_type IS NULL THEN (SELECT emt_element_type FROM tbk_generic_form_elements WHERE emt_id=gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date <=gdata_posted_date order by tbk_id DESC limit 1) ELSE emt_element_type END AS emt_element_type, CASE WHEN emt_tinymce_required IS NULL THEN (SELECT emt_tinymce_required FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='textarea' order by tbk_id DESC limit 1) ELSE emt_tinymce_required END AS emt_tinymce_required,";


                                $form_select .= 'gdata_dynamic_status,gdata_art_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_user_roles,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gdata_gfg_id,gncf_form_type,gncf_user_roles,gncf_posted_by,gncf_form_privilege_usr_edit,gdata_atfemt_id';
                                $author_role_id = $all_user_roles['role_id'][0];

                                $formatted_journal_code = '_' . $jnlcode;
                                $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
                                $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
                                $details_tables = array(
                                    'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
                                    'join_table' => array(
                                        $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
                                        $Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id','left'),
                                    )
                                );

                                $order_by = "gdata_data_order,gdata_posted_date asc";
                                if (count(json_decode($flow->jwf_forms)) > 0) {
                                    $form_order = implode(',', (json_decode($flow->jwf_forms)));
                                    $order_by = "FIELD(gdata_atf_id," . $form_order . "),gdata_data_order,gdata_posted_date asc";
                                }

                                if (isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y') {
                                    $Form_edithistory_table = (new \App\Models\Form_edithistory())->getTable();
                                    $article_flow_table = (new \App\Models\Article_flow())->getTable();
                                    $date_format = $this->get_platform_date_format($platform_id);
                                    $date_format = $this->date_format_map($date_format);
                                    $where = str_replace('gdata_posted_by','aflw_usr_id',$where);
                                    $form_select .= ',tb1.feh_posted_by, DATE_FORMAT(tb1.feh_posted_date, "' . $date_format . '") as feh_posted_date';
                                    $query = 'select ' . $form_select . ' from rvw_article_gnf_form_data' . $formatted_journal_code . ' join ' . $Generic_forms_table . ' on gncf_id = gdata_atf_id left join ' . $Generic_form_elements_table . ' on gdata_atfemt_id=emt_id join '.$article_flow_table.'  on aflw_id = gdata_artflw_id left join (SELECT feh_id,feh_gncf_id,feh_posted_by,feh_posted_date FROM ' . $Form_edithistory_table . ' WHERE feh_id IN (SELECT max(feh_id) from ' . $Form_edithistory_table . ' where `feh_art_id` = ' . $flow->art_id . ' GROUP by `feh_gncf_id`,feh_aflw_id)) as tb1 on (gdata_feh_id = tb1.feh_id and tb1.feh_gncf_id = gdata_atf_id)where ' . $where . ' order by ' . $order_by;
                                    $reviewforms = Article_flow::get_records_by_raw_query($query);
                                } else {
                                    $reviewforms = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', $order_by, null, '', null, null, true);
                                }
                                
                                $arraydata = array(
                                    'reviewforms' => $reviewforms,
                                    'flow' => $flow,
                                    'usra' => $usra,
                                    'completedformreviewarr' => $completedformreviewarr,
                                    'functional_type' => 'c',
                                    'version' => $version,
                                    'count' => $count,
                                    'article_privilages' => $article_privilages,
                                    'multiple_label' => $multiple_label,
                                    'article_permission_details' => $article_permission_details,
                                    'roleid' => $roleid,
                                    'rescind_review_link' => $rescind_review_link,
                                    'review_to_orcid' => $review_to_orcid,
                                    'username_status' => $username_status,
                                    'reviewer_name' => $reviewer_name,
                                    'reviewer_order' => $reviewer_order,
                                    'user_roles' => $user_roles,
                                    'remove_tab_andform' => $remove_tab_andform,
                                    'is_previous' => $is_previous,
                                    'platform_id' => $platform_id,
                                    'atotp_review_method' => $flow->atotp_review_method,
                                );
                                $res = $this->get_viewarticle($arraydata);
                                if (!empty($res)) {
                                    $completedformreviewarr = $res['completedformreviewarr'];
                                    $count = $res['count'];
                                }
                            }
                        }

                        $flworder++;
                    }

                    if (count($completedformreviewarr) > 0) {
                        if (isset($completedformreviewarr['flow' . $usra->aflw_id]['group'])) {
                            $completedformreviewarr['flow' . $usra->aflw_id]['group'] = array_values($completedformreviewarr['flow' . $usra->aflw_id]['group']);
                        }
                        $found = 0;
                        foreach ($completedformreviewarr as $key => $value) {
                            if (!empty($value)) {
                                $found = 1;
                            }
                        }
                        if ($found == 0) {
                            $messages = 'Stage <strong>' . $flow->jwf_stage_name . '</strong> in progress';
                        } else {
                            $flow->review_childstages = $completedformreviewarr;
                        }
                    }
                    //uncommented code because the fix is applied in query
                   /* if ($flow->jwf_assignment == 'invitation') {
                        if (!isset($flow->review_childstages)) {
                            //unset($flowdetails[$index_flow]);
                            //continue;
                            $flow->hide_completedreviews = true;
                            if (($article_privilages['privilaged'] == false && $article_privilages['reviewer'] == true &&  $article_privilages['user_allocated'] == false )  || $article_privilages['author'] == true) {
                                unset($flowdetails[$index_flow]);
                                continue;
                            }
                        }
                    }*/

                    if (empty($completed_forms) && !empty($completed_forms_exist)) {
                        $message = "<p class='text-warning' >You are not permitted to see this content.";
                    }


                    $pdf_link = '';
                    if (isset($art_id)) {

                        $Article_pdf = new \App\Models\Article_pdf();
                        $pdf_detail = $Article_pdf::get_single_record('pdf_id', "pdf_art_id={$art_id} AND pdf_show_status='y'", null, '', 'pdf_id desc');
                        $link = '';
                        $view_pdf = false;
                        if (isset($jnlcode) && (isset($pdf_detail->pdf_id))) {
                            $article_stages = array("resubmission", "revision");
                            if (isset($flow->jwf_stage_type) && (in_array($flow->jwf_stage_type, $article_stages))) {
                                $pdf_link = 'viewpdf' . '/' . encrypt_link($art_id) . '/' . encrypt_link($pdf_detail->pdf_id);
                                $flow->pdf_link = $pdf_link;
                            }
                        }
                    }

                    // permission_form

                    // to do
                    /*$hide_tab_form_status=array();
                    $hide_tab_form_status['tab_hide']=false;
                    $hide_tab_form_status['forms_count']=0;
                    $hide_tab_form_status['form_visible']=0;*/
                    if ($flow->jwf_assignment != 'invitation') {
                        $hide_tab_form_status = array();
                        $view_form = collect([]);
                        $all_form = collect([]);

                        $array_data = array(
                            'completedformarr' => $completedformarr,
                            'completed_forms' => $completed_forms,
                            'flow' => $flow,
                            'user_roles' => $user_roles,
                            'article_privilages' => $article_privilages,
                            'atotp_review_method' => $flow->atotp_review_method,
                            'platform_id' => $platform_id,
                            'functional_type' => 'c', // completed all stage form
                        );
                        $res = $this->getCompletedstageORsubmissionformdetails($array_data);
                        if (!empty($res)) {
                            $completedformarr = $res['completedformarr'];
                            $view_form = $res['view_form'];
                            $all_form = $res['all_form'];
                            $hide_tab_form_status = $res['hide_tab_form_status'];
                        }
                    }
                    if ($remove_tab_andform == true && $flow->jwf_assignment != 'invitation' && count($hide_tab_form_status) > 0) {
                        // reset form with You are not permitted to see this content .
                        if (count($completedformarr) > 0) {
                            if (isset($completedformarr[$flow->aflw_id]['group'])) {
                                foreach ($completedformarr[$flow->aflw_id]['group'] as $findex => $row) {
                                    $visible_elem = !empty(array_column($completedformarr[$flow->aflw_id]['group'][$findex], 'element_visible')) && in_array(1, array_column($completedformarr[$flow->aflw_id]['group'][$findex], 'element_visible')) ? true : false;
                                    if (!$visible_elem || $row['permission_form'] == false) {
                                        unset($completedformarr[$flow->aflw_id]['group'][$findex]);
                                    }
                                }
                            }
                        }
                        // reset tab with all form You are not permitted to see this content .
                        $difference = $all_form->diff($view_form);
                        $hide_tab_form_status['visible_form'] = $view_form;
                        $hide_tab_form_status['all_form'] = $all_form;
                        $hide_tab_form_status['hide_form'] = $difference->all();

                        $pool_exist=false;
                        if(!empty($flow->aflw_jwf_id))
                        {
                            $workflow_assignment_reference_table = (new \App\Models\Workflow_Assignment_reference())->getTable();
                            $sql='select count(aflw_id) as workflw from '.$article_flow_table.','.$workflow_assignment_reference_table .' where aflw_source_assignment_id ='.$flow->aflw_jwf_id.' and aflw_art_id='.$art_id.' and FIND_array_intersect('.$flow->aflw_jwf_id.',REPLACE(REPLACE(REPLACE(war_Jwf_id,\'"\',""),"]",""),"[","")) = 1';
                            $poolassign=Article_flow::get_records_by_raw_query($sql);
                            if(!empty($poolassign) && (isset($poolassign[0]->workflw) && $poolassign[0]->workflw > 0) )
                            {
                                $pool_exist=true;
                            }
                        }
                      
                        if (count($all_form) > 0 && (json_encode($all_form) === json_encode($difference->all())) && $pool_exist == false) {
                            $hide_tab_form_status['tab_hide'] = true;
                            $hide_tab_form_status['index_flow'] = $index_flow;
                            unset($flowdetails[$index_flow]);
                            continue;
                        }
                        $flow->hide_tab_form_status = $hide_tab_form_status; // to do
                    }

                    if (count($completedformarr) > 0) {
                        if (isset($completedformarr[$flow->aflw_id]['group'])) {
                            $completedformarr[$flow->aflw_id]['group'] = array_values($completedformarr[$flow->aflw_id]['group']);
                        }
                        $flow->completedform = $completedformarr;
                    }

                    //if((isset($completedformarr[$flow->aflw_id]) && empty($completedformarr[$flow->aflw_id]))  || $flow->jwf_assignment=="manual")
                    //assignment section visible custom form suggested by Gijo
                    if ((isset($completedformarr[$flow->aflw_id]) && empty($completedformarr[$flow->aflw_id]))) {
                        if ((($article_privilages['reviewer'] == false || ($article_privilages['reviewer'] == true && $flow->jwf_stage_type == 'review')) || $article_privilages['author'] == false) && $flow->art_delete_status == 'h')
                        $message = customTrans('viewarticle.article_onhold');
                        $is_empty_content = true;
                        if ($article_privilages['privilaged'] == true && !in_array($flow->aflw_status, array("a", "u", "p"))) {
                            $message = '<p>Completed stage <strong>' . $flow->jwf_stage_name . '</strong></p>';
                        }

                        if ($flow->aflw_status == 'c' && $article_privilages['privilaged'] == true) {
                            $message = '<p>Completed stage <strong>' . $flow->jwf_stage_name . '</strong></p>';
                            $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                            $article_flow_table = (new \App\Models\Article_flow())->getTable();
                            $select = 'jwf_stage_name';
                            $art_flw_tables = array(
                                'main_table' => $article_flow_table,
                                'join_table' => array(
                                    $Generic_flows_table => array($article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id')
                                )
                            );

                            $childstges = json_decode($flow->jwf_child_stages);

                            $level_min_1 = $flow->aflw_level - 1;
                            $level_plus_1 = $flow->aflw_level + 1;

                            //$art_flw_criteria = 'aflw_art_id = '.$article_id.' AND aflw_level >='.$article_flow_details->aflw_level;
                            $art_flw_criteria = 'aflw_art_id = ' . $art_id . ' AND aflw_level IN (' . $level_min_1 . ',' . $flow->aflw_level . ',' . $level_plus_1 . ') AND aflw_id > ' . $flow->aflw_id;

                            $article_flow_dets = array();
                            if (count($childstges) > 0) {
                                if (count($childstges) > 1 && ($flow->jwf_flow_proceed_type == 'parallel' || $flow->jwf_flow_proceed_type == 'advance')) {
                                    $select = 'group_concat(distinct jwf_stage_name) as jwf_stage_name';
                                }
                                $art_flw_criteria .= ' AND aflw_jwf_id IN (' . implode(', ', $childstges) . ')';

                                $article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'single');
                            }
                            $flow->privilagedemo = $article_privilages['privilaged'];
                            //Check stage name value set
                            if (!empty($article_flow_dets) && (isset($article_flow_dets->jwf_stage_name) && $article_flow_dets->jwf_stage_name != '')) {
                                $message = '<p>Moved to stage <strong>' . str_replace(',', ', ', $article_flow_dets->jwf_stage_name) . '</strong></p>';
                            }
                        } elseif ($flow->aflw_status == 'c' && $article_privilages['privilaged'] == false) {
                            $message = '<p>Completed stage <strong>' . $flow->jwf_status_name . '</strong></p>';
                        } elseif (in_array($flow->aflw_status, array("w", "p")) && $article_privilages['privilaged'] == true && $flow->jwf_stage_type == 'review' && $flow->aflw_skip_review != "y") {
                            $message = '<p>Stage <strong>' . $flow->jwf_stage_name . '</strong> in progress</p>';
                        }

                        $flow->messsage = $message;
                    } else
                        $flow->messsage = '';



                    if ($flow->aflw_stage_repeat_count > 0) {
                        $this->get_completed_multipleforms($flow, $article_privilages, $user_roles, $this->current_user, $jnlcode, $flow->aflw_stage_repeat_count + 1);
                    }
                    $open_status_array = array(
                        'a',
                        'w',
                        'p'
                    );
                    /*if (((isset($article_data) && $review_exists == true && in_array($article_data->aflw_status, $open_status_array) && $article_privilages['privilaged'] == true ) || (isset($article_data) && $article_privilages['privilaged'] == false && $article_privilages['reviewer'] == true && $article_data->jwf_stage_type == 'review') || (isset($article_data) && $article_privilages['privilaged'] == true && $flow->jwf_stage_type == 'resubmission')) && $stage_for=="review")*/
                    if (((isset($article_data) && $review_exists == true && in_array($article_data->aflw_status, $open_status_array)) || (isset($article_data) && $article_privilages['privilaged'] == false && (($article_privilages['reviewer'] == true && $article_data->jwf_stage_type == 'review') || ($article_privilages['author'] == true && $article_data->jwf_stage_type == 'copyright'))) || (isset($article_data) && $article_privilages['privilaged'] == true && $flow->jwf_stage_type == 'resubmission')) && $version == "current" && $stage_for == "review") {
                        $open_forms[] = $flow->aflw_id;
                    }
                    // /* Review staging extsts */
                    if ($flow->jwf_stage_type == 'review' && $article_privilages['privilaged'] == true && $review_exists == TRUE)
                    {
                        $open_forms[] = $flow->aflw_id;
                    }

                    $attachments = [];
                    $flow->permission_to_designate_roles = false;
                    if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') && $stage_for != "review") {

                        $flowstagedata = $workflow_arr[$flow->jwf_stage_type];
                        $flow_stage_for = $flowstagedata['stage_for'];
                        $flow_production_stage = (isset($flow_stage_for) && $flow_stage_for == "review") ? false : true;
                        if ($flow_production_stage == true && (isset($article_data) && in_array($article_data->aflw_status, $open_status_array) && ($article_privilages['privilaged'] == true || in_array($article_data->jwf_stage_type, array('proof_reading', 'pro_revision'))))) {
                            $open_forms[] = $flow->aflw_id;
                        }


                        $flow_id = $flow->aflw_id;
                        if ($flow->jwf_assignment == "manual") {
                            //get single records
                            $flow_details = Article_flow::get_single_record('aflw_id', 'aflw_parent_flow_id=' . $flow_id);
                            if (!empty($flow_details)) {
                                $flow_id = $flow_details->aflw_id;
                            }
                        }
                        $attachment_array = $this->get_productionfile($flow_id, $core_role, $roleid, $date_format, $art_id, "production");
                        $attachments = $attachment_array['attachments'];
                        $flow->permission_to_designate_roles = $attachment_array['permission_to_designate_roles'];

                        if (isset($attachments[0]) && in_array($roleid, explode(',', $attachments[0]->designated_roles))) {
                            $this->repeatedstagearray[$flow->aflw_jwf_id]   =   $flow->aflw_id;
                        }
                    }

                    $flow->production_stage_files = $attachments;
                    /* TASK #6282 Implement Review Article grading System*/
                    $art_rating_array = array();
                    if (isset($art_id) && $art_id != null && isset($flow->aflw_id) && $flow->aflw_id != null) {
                        $Article_Rating = new \App\Models\Article_rating();
                        $art_rating_array = $check_exist = $Article_Rating::get_single_record_with_bind_cond('	rat_star_value,rat_star_comments', array('rat_art_id' => $art_id, 'rat_aflw_id' => $flow->aflw_id));
                    }
                    $flow->article_rating_array = $art_rating_array;
                    /*TASK #6282 */
                    $newarray[] = $flow;
                }
                $production_roles = [];
                if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')) {
                    $user_desinated_roles = $this->UserConfigdata('production_designated_roles');
                    $criteria4 = 'role_assigned_role  IN("' . implode('","', $user_desinated_roles['production_designated_roles']) . '")';
                    $production_roles = Roles::get_all_records('role_id,role_name,role_assigned_role', $criteria4);
                }
                $return_array['production_roles'] = $production_roles;
            }
            //echo '<pre>'; print_r($newarray);
            
             //die;
            $return_array['flowdetails'] = $newarray;
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
            $Generic_flowstable = (new \App\Models\Generic_flows())->getTable();

            //start------#2262 fetch parallel stages and prev stages for open and other stages collaspe as default
            if (count($open_forms) > 0 && count($newarray) > 0 && $stage_for != "review") {
                if (in_array($core_role, main_production_roles())) {
                    $end_left_tabs      =   end($newarray);
                    $last_aflw_id       =   $end_left_tabs->aflw_id;
                    if (in_array($last_aflw_id, $open_forms)) {
                        $open_forms         =   array();
                        $prev_flw_id        =   array();
                        $prev_flw_id[]      =   $art_flow_id;
                        $prev_stage_lvl     =   $end_left_tabs->aflw_level;
                        $prev_parent_stages =   $end_left_tabs->jwf_parent_stages;
                        $prev_sql           =   'SELECT aflw_id '
                        . 'FROM ' . $article_flow_table . ' AS `c_flw` '
                        . 'JOIN ' . $Generic_flowstable . ' AS `c_stg` ON `c_flw`.`aflw_jwf_id` = `c_stg`.`jwf_id` '
                        . 'WHERE  c_flw.aflw_level = ' . $prev_stage_lvl . ' '
                            . 'AND `aflw_art_id` = ' . $art_id . ' AND jwf_parent_stages in (\'' . $prev_parent_stages . '\') '
                            . 'group by aflw_id';
                        $prev_stages        =   Article_flow::get_records_by_raw_query($prev_sql);
                        if (count($prev_stages) > 0) {
                            foreach ($prev_stages as $ps => $ky) {
                                $open_forms[]  =   $ky->aflw_id;
                            }
                        } else {
                            $open_forms[]  =  $last_aflw_id;
                        }
                    }
                    //#2614 stages which has files attached need to open (dont collapse) for JP and TSP and for "who can view" users
                    $this->repeatedstagearray =   array_values($this->repeatedstagearray);
                    foreach ($newarray as $ps => $ky) {
                        if (count($ky->production_stage_files) > 0 && !in_array($ky->aflw_id, $open_forms) && in_array($ky->aflw_id, $this->repeatedstagearray)) {
                            $open_forms[]  =  $ky->aflw_id;
                        }
                    }
                } else {

                    foreach ($newarray as $ps => $ky) {
                        if (in_array($ky->aflw_id, $open_forms)) {
                            if (count($ky->production_stage_files) == 0 && ($ky->messsage != '' || (!isset($ky->completedform[$ky->aflw_id]['group'][0]['form_visible']) || (isset($ky->completedform[$ky->aflw_id]['group'][0]['form_visible']) && $ky->completedform[$ky->aflw_id]['group'][0]['form_visible'] == 0)))) {
                                $key = array_search($ky->aflw_id, $open_forms);
                                unset($open_forms[$key]);
                            }
                        } elseif (count($ky->production_stage_files) > 0 || ($ky->messsage == '' && (isset($ky->completedform[$ky->aflw_id]['group'][0]['form_visible']) && $ky->completedform[$ky->aflw_id]['group'][0]['form_visible'] == 1))) {
                            $open_forms[]  =  $ky->aflw_id;
                        }
                    }
                }
            }
            $open_forms = array_values($open_forms);

            //print_r($open_forms); die;
            //end------#2262 fetch parallel stages and prev stages for open and other stages collaspe as default

            $show_decision_letter_log = false;
            $art_auth_arr = array();
            $decision_letter = array();
            $decision_date = '';
            $show_final_decision = false;
            $decision_date = '';
            if (isset($this->current_client->functionality->cfty_show_decision_letter_email_log) && $this->current_client->functionality->cfty_show_decision_letter_email_log == 'y' && $article_privilages['author'] == true) {
                $Authors = new \App\Models\Authors();
                $article_authors = $Authors::get_single_record('GROUP_CONCAT(auth_usr_id) as auth_ids', 'auth_art_id=' . $art_id);
                $art_auth_arr = explode(',', $article_authors->auth_ids);
                $Email_send_log_table = (new \App\Models\Email_send_log())->getTable();
                $tables = array(
                    'main_table' => $Email_send_log_table,
                    'join_table' => array(
                        $article_flow_table => array($article_flow_table . '.aflw_id', $Email_send_log_table . '.esl_aflw_id'),
                        $Generic_flowstable => array($Generic_flowstable . '.jwf_id', $article_flow_table . '.aflw_jwf_id'),
                    )
                );
                $select = 'esl_id as id,esl_subject as subject, esl_content as content, esl_attachments, esl_to as userto, esl_bcc as bcc, esl_cc as cc';
                $Email_send_log = new \App\Models\Email_send_log();
                $decision_letter = $Email_send_log::get_results_using_joins($tables, $select, 'esl_article_id =' . $art_id . ' AND esl_user_id IN (' . $article_authors->auth_ids . ') AND jwf_stage_type IN (\'reject\',\'accept\')' . 'AND esl_etmp_action IN (\'completed\',\'declined\')', 'all');
                if (count($decision_letter) > 0)
                    $show_decision_letter_log = true;

                if (isset($this->current_client->functionality->cfty_attachment_to_author) && $this->current_client->functionality->cfty_attachment_to_author == 'y') {
                    foreach ($decision_letter as $eml) {
                        $esl_attach = ($eml->esl_attachments != null) ? json_decode($eml->esl_attachments, true) : array();
                        $email_attach = array();
                        if (!empty($esl_attach)) {
                            if (isset($esl_attach['article']) && !empty($esl_attach['article'])) {
                                foreach ($esl_attach['article'] as $eat) {
                                    $email_attach[$eat] = 'uploads/' . $article_data->art_article_upload_path . '/' . $eat;
                                }
                            } elseif (isset($esl_attach['modified']) && !empty($esl_attach['modified'])) {
                                foreach ($esl_attach['modified'] as $eat) {
                                    $email_attach[$eat] = 'uploads/email_attachments/' . $article_data->art_id . '/' . $eat;
                                }
                            }
                        }
                        $eml->email_attachments = $email_attach;
                    }
                }

                //$data['decision_email_sent_data'] = $decision_letter;
                //$data['journal_code'] = $this->jnl_data->jnl_journal_code;

                //#3525 Needs a final decision status for author
                $stat_arr = array('a', 'r');
                if (in_array($article_data->art_status, $stat_arr)) {
                    $date_format =  $this->get_platform_date_format($platform_id);
                    $date_format = date_format_map($date_format);
                    $show_final_decision = true;
                    //',DATE_FORMAT(art_update_last_date, "' . $date_format . '") as update_last_date'
                    $decision_date = Articles::get_single_record('DATE_FORMAT(art_decision_date, "' . $date_format . '") as art_decision_date', 'art_id=' . $art_id)->art_decision_date;
                }
            }
            $gnf_table = 'rvw_article_gnf_form_data_' . $jnlcode;
            $usr_id = $this->current_user["user_id"];
            $form_ids = DB::selectOne("select group_concat(distinct gdata_artflw_id) as flow_ids from $gnf_table as gnf, rvw_article_flow as flw where flw.aflw_id = gnf.gdata_artflw_id and aflw_usr_id = $usr_id and gnf.gdata_art_id = $art_id")?->flow_ids;
            $return_array['decision_status'] = (isset($article_data->art_status) && $article_data->art_status=='a')?'Accepted':'Rejected';
            $return_array['articlecode'] = $article_data->art_code;
            $return_array['decision_date'] = $decision_date;
            $return_array['decision_letter'] = $decision_letter;
            $return_array['show_final_decision'] = $show_final_decision;
            $return_array['show_decision_letter_log'] = $show_decision_letter_log;
            $return_array['article_privilages'] = $article_privilages;
            $return_array['open_forms'] = $open_forms;
            $return_array['user_forms'] = $form_ids ? explode(',',$form_ids) : [];
            $return_array['inprogress_stage'] = $inprogress_stage ;
            //3313 Editing forms after stage complete
            $return_array['edit_article_forms_flag'] = $this->iscmptformEdituser($article_data->art_id, $article_data->artp_id);

            return  $this->success('Success', 200, $return_array);
        } catch (\Exception $e) {
            $this->customErrorAction('manage_proposal', $e);
            return $this->failure('Failed', 500, $e);
        }
    }
    //***  get all the stages till completed and also inviation stage when its not active starts ***/

    //3313 Editing forms after stage complete
    public function iscmptformEdituser($art_id,$artp)
    {
        $return = false;
        if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
        {
            $User_articles_table = new \App\Models\User_articles();
            $articletype_table = new \App\Models\Article_types();
            $User_to_journals_table = new \App\Models\User_to_journals();
            $articletype_table_name = (new \App\Models\Article_types())->getTable();
            $Journal_permission_table = (new \App\Models\Journal_permission())->getTable();

            //fetch completed form edit permitted roles in article type
            $edited_roles = 'jp_edit_article_forms';
            $join_tables = array(
                'main_table' => $articletype_table_name,
                'join_table' => array(
                    $Journal_permission_table => array('jp_jpm_id','artp_jpm_id')
                ));
            $where = array(
                'artp_id' => $artp
            );

            $editedPermission_roles_data = $articletype_table::get_results_using_joins($join_tables, $edited_roles, $where, 'single');

            $edited_roles_arr = array();

            if(isset($editedPermission_roles_data->jp_edit_article_forms) && $editedPermission_roles_data->jp_edit_article_forms != '')
            {
                $this->current_user = $this->get_current_user_details();
                $edited_roles_arr = json_decode($editedPermission_roles_data->jp_edit_article_forms);

                //get allocated users in article
                $select = 'usra_role_id,group_concat(usra_usr_id) as user_ids';
                $cond = array(
                    'usra_art_id' => $art_id
                );
                $allocated_users = $User_articles_table::get_assigned_users($select,$cond,'usra_usr_id');
                $allocated_users = array_column(json_decode(json_encode($allocated_users), true), 'user_ids', 'usra_role_id');

                $cond = array(
                    'usrj_artp_id' => $artp,
                    'usrj_usr_id'=>$this->current_user["user_id"]
                );
                //DB::enableQueryLog();
                $user_artp_roles = $User_to_journals_table::get_single_record_with_bind_cond('group_concat(usrj_role_id) as roles,GROUP_CONCAT(IF(usrj_role_retired = \'n\',usrj_role_id,null)) as except_retire_roles',$cond,'',array(),'usrj_artp_id');
                //$query = DB::getQueryLog();$query = end($query);print_r($query);exit;

                $artp_userroles = array();
                if(!empty($user_artp_roles))
                {
                    $artp_userroles = explode(',',$user_artp_roles->roles);
                    if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y')
                    {
                        $artp_userroles = explode(',',$user_artp_roles->except_retire_roles);
                    }
                }

                foreach($edited_roles_arr as $role)
                {
                    //check current user have allocation
                    if(isset($allocated_users[$role]))
                    {
                        $alct_usrs = explode(',',$allocated_users[$role]);
                        if(in_array($this->current_user['user_id'],$alct_usrs))
                        {
                            $return = true;
                            break;
                        }
                        else
                        {
                            $key = array_search($role,$artp_userroles);
                            if($key != false)
                            {
                                unset($artp_userroles[$key]);
                            }
                        }
                    }
                    //user have role in article type
                    if(in_array($role,$artp_userroles))
                    {
                        $return = true;
                        break;
                    }
                }
            }
        }

        return $return;
    }

    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    public function get_source_assigend_users($array_data)
    {
        try{
            $workflow_id = isset($array_data['workflow_id']) ? $array_data['workflow_id'] : null;
            $get_selected_workflow_assignment_for_source_stage = isset($array_data['get_selected_workflow_assignment_for_source_stage']) ? $array_data['get_selected_workflow_assignment_for_source_stage'] : null;
            $art_id = isset($array_data['art_id']) ? $array_data['art_id'] : null;
            $date_format = isset($array_data['date_format']) ? $array_data['date_format'] : null;
            $article_data = isset($array_data['article_data']) ? $array_data['article_data'] : null;
            $jnl_code = isset($array_data['jnl_code']) ? $array_data['jnl_code'] : null;
            $platform_data = $this->platform_basic_settings_data($jnl_code);
            $platform_id = $platform_data->jnl_id;
            $data['current_stage_active'] = false;
            $data['show_invited'] = false;
            $data['has_invite_permission'] = false;
            $data['enable_button_active']= false;
            $data['is_previous'] = false;
            $data['article_data_set'] = $article_data;
            $data['has_assign_permission'] = false;
            $conflict_interest = array();
            if ($this->current_client->modules->mdl_review_for_doc == 'n')
            {
                $conflict_interest = $this->get_article_conflict_array($art_id);
            }
            $array_data['art_id'] = $art_id;
            $array_data['platform_id'] = $platform_id;
            $array_data['conflict_interest'] = $conflict_interest;
            $array_data['data'] = $data;
            $source_assigned_users_list = array();

            $article_flow_table = (new \App\Models\Article_flow())->getTable();
            $article_reviwers_table = (new \App\Models\Article_reviewers())->getTable();
            $reject_reason_table = (new \App\Models\Reject_reasons())->getTable();
            $article_flow_alternativereviewer_priorityorder_table = (new \App\Models\Article_flow_alternativereviewer_priorityorder())->getTable();

            foreach ($get_selected_workflow_assignment_for_source_stage as $each_source)
            {
            
            $usertable = (new \App\Models\User())->getTable();

            $join_flow_reviwewer = " FROM " . $article_flow_table . " as af INNER JOIN " . $article_reviwers_table . " ON sorw_aflw_id=aflw_id";
            $reject_reson_join = '';
            $alternative_reviwer_join = '';
            $assg_criteria = " WHERE aflw_assignment_type_id={$each_source['pool_id']} AND aflw_source_assignment_id = {$workflow_id} AND aflw_jwf_id = {$each_source['pool_workflow_assignment_desination_id']} AND aflw_art_id = {$art_id}";
            $order_by = '';
            $select = 'SELECT sorw_id,aflw_id,aflw_usr_id,aflw_status,sorw_invited_by,sorw_suggested_user_id,aflw_due_date,DATE_FORMAT(sorw_suggested_on, "' . $date_format . '") as suggested_date,DATE_FORMAT(sorw_invited_on, "' . $date_format . '") as invited_date,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as due_date,aflw_posted_by,aflw_remarks,aflw_returned_date,aflw_usr_review_reopen,sorw_author_suggested';

            $select .= ',IF(((select max(b.aflw_id) from ' . $article_flow_table . ' as b  where b.aflw_usr_id = af.aflw_usr_id and b.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id) && rjct_reinvite_flag ="y"  && (select count(aflw_id) from ' . $article_flow_table . ' as c  where c.aflw_usr_id = af.aflw_usr_id and c.aflw_parent_flow_id = af.aflw_parent_flow_id and c.aflw_status != "i" and c.aflw_status !="a" and c.aflw_status !="c")>0,1,0) as reinvte_condition,IF( ( ( SELECT MAX(d.aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id and af.aflw_status = "g" ) > 0, 1, 0 ) AS reinvte_unassigned_condition,(select count(aflw_id) from ' . $article_flow_table . ' as d  where d.aflw_usr_id = af.aflw_usr_id and d.aflw_parent_flow_id = af.aflw_parent_flow_id) as reviewer_invite_count,IF( ( ( SELECT MAX(e.aflw_id) FROM rvw_article_flow AS e WHERE e.aflw_usr_id = af.aflw_usr_id AND e.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id ) &&( SELECT COUNT(aflw_id) FROM rvw_article_flow AS d WHERE d.aflw_usr_id = af.aflw_usr_id AND d.aflw_parent_flow_id = af.aflw_parent_flow_id AND d.aflw_status = "d") <= 1, 1, 0 ) AS reviewer_invite_condition,sorw_usr_source';
            $reject_reson_join = " LEFT JOIN " . $reject_reason_table . " ON sorw_rjct_id=rjct_id";


            if (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y')) {
                $select .= ',afap_id,afap_number';
                $order_by = ' ORDER BY afap_number ASC';
                $alternative_reviwer_join = " LEFT JOIN " . $article_flow_alternativereviewer_priorityorder_table . " ON afap_aflw_id = aflw_id";
            }
            /* to recognise if added through reviewer on fly or not */
            $select .= ',(CASE WHEN sorw_usr_source=\'p\' THEN \'n\' WHEN `sorw_posted_by`=`sorw_suggested_user_id` and EXISTS(
        SELECT `usr_id` FROM ' . $usertable . ' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
        and `usr_status`=\'w\')   then \'y\' else \'n\' end ) as added_through_fly,(SELECT DATE_FORMAT(usr_posted_date, "' . $date_format . '") as user_posted FROM '.$usertable.' where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
and `usr_status`=\'w\') as user_posted_date';
            /* to recognise if added through reviewer on fly or not */

            $source_assigned_users_sql = $select . $join_flow_reviwewer . $reject_reson_join . $alternative_reviwer_join . $assg_criteria . $order_by;
            $source_assigned_users = Article_flow::get_records_by_raw_query($source_assigned_users_sql);
            if(!empty($source_assigned_users) && count($source_assigned_users) > 0)
            {
            $pool_details['pool_id'] = $each_source['pool_id'];
            $pool_details['pool_name'] = $each_source['pool_workflow_assignment_name'];
            $pool_details['pool_destination'] = $each_source['pool_workflow_assignment_desination_id'];
            $pool_details['assignment_tab_name'] =$each_source['pool_workflow_assignment_name'] .' for <b> stage: '.$each_source['pool_workflow_assignment_destination_stage_name'].'</b>'; /* TASK #3044, Ability for AEs to shortlist reviewers during Pre-Review "stage : stakeholder review" phrase is missing issue fix */
            $array_data['assigned_users'] = $source_assigned_users;
            $source_assigned_users = $this->get_assigned_user_array($array_data);
            $pool_details['source_assigned_users'] = $source_assigned_users;
            $source_assigned_users_list[] = $pool_details;
            }

        }


        return $source_assigned_users_list;
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
    }
    public function get_assigned_user_array($data_array)
    {
        try {

            $art_id = isset($data_array['art_id']) ? $data_array['art_id'] : null;
            $platform_id = isset($data_array['platform_id']) ? $data_array['platform_id'] : null;
            $assigned_users = isset($data_array['assigned_users']) ? $data_array['assigned_users'] : '';
            $conflict_interest = isset($data_array['conflict_interest']) ? $data_array['conflict_interest'] : array();
            $data = isset($data_array['data']) ? $data_array['data'] : array();
            $notinviteduser=array();
            if (!empty($assigned_users))
            {

                foreach ($assigned_users as $assg)
                {
                    $due_date = $assg->aflw_due_date;
                    $date_diff=time() - strtotime($due_date);
                    $days = round($date_diff / (60 * 60 * 24));
                    $assg->due_date_danger=false;
                    if($days>0)
                    {
                        $assg->due_date_danger=true;
                        $assg->due_date= $assg->due_date;
                    }
                    $alt_txt = null;
                    if(isset($assg->afap_number))
                    {
                        $alt_txt = $assg->afap_number;
                    }
                    $array_data['user_id'] = $assg->aflw_usr_id;
                    $array_data['journal_id'] =$platform_id;
                    $array_data['flag']=true;
                    $array_data['article_id']= $art_id;
                    if($alt_txt!=null)
                    $array_data['alternate_no']= $alt_txt;
                    $array_data['availability']= true;
                    $array_data['fullname_only']=false;
                    if (isset($assg->aflw_usr_id) && ($assg->aflw_usr_id != NULL))
                    {
                        $array_data['conflict_interest'] = $this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                    }
                    $assg->short_listed_user = $this->get_user_display_name($array_data);
                    $assg->suggested_user = '';
                    $array_data['conflict_interest'] = '';
                    if ($assg->sorw_suggested_user_id != null)
                    {
                        $array_data['user_id'] = $assg->sorw_suggested_user_id;
                        $array_data['journal_id'] =$platform_id;
                        $array_data['flag']=true;
                        $array_data['article_id']= $art_id;
                        $array_data['availability']= true;
                        $array_data['alternate_no']= '';
                        $array_data['fullname_only']=false;
                        $assg->suggested_user = $this->get_user_display_name($array_data);
                    }
                    $assg->invited_user = '';
                    if ($assg->sorw_invited_by != null)
                    {
                        $array_data['user_id'] = $assg->sorw_invited_by;
                        $array_data['journal_id'] =$platform_id;
                        $array_data['flag']=true;
                        $array_data['article_id']= $art_id;
                        $array_data['availability']= true;
                        $array_data['alternate_no']= '';
                        $array_data['fullname_only']=false;
                        $assg->invited_user = $this->get_user_display_name($array_data);

                        if($assg->sorw_invited_by == 0)
                        {

                            $assg->invited_user='system';
                        }
                    }
                    $assg->invited_user_id=$assg->sorw_invited_by;
                    $show_conflict_interest_message = array();
                    if (!empty($conflict_interest))
                    {
                        $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                    }
                    $assg->conflict_message = $show_conflict_interest_message;
                    $assg->unregistered_user = $this->check_usr_account($assg->aflw_usr_id);
                       if($assg->aflw_status=='u'&&$assg->unregistered_user==false)
                       {
                        array_push($notinviteduser,$assg->aflw_usr_id);

                       }
                    $assg->invitationstatus=$this->check_invitation_status($data,$assg);
                }
            }
            return $assigned_users;
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
    public function get_completed_forms($article_flow_details, $privilages, $user_roles, $current_user, $jnlcode,$editing_user = null,$jnl_id = null,$roleid='')

    {
        $article_flow_table = (new \App\Models\Article_flow)->getTable();
        $edit_form_comment_flag = false;
        if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
        {
            $edit_form_comment_flag = true;
        }
        $where = '';
        $child_article_flows = array();
        $author_stages = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission');
        if ($this->current_client->modules->mdl_production == 'y') {
            $author_stages[] = 'pro_revision';
        }

        $stage_author = false;
        if (in_array($article_flow_details->jwf_stage_type, $author_stages))
            $stage_author = true;
        if ($article_flow_details->jwf_assignment == 'self_service') {
            $where = ' gdata_artflw_id =  ' . $article_flow_details->aflw_id . ' AND gdata_art_id = ' . $article_flow_details->aflw_art_id;
            // TASK #9479 The privileged user cannot view the custom form.
            if ($stage_author == false && $privilages['author'] == true) {
                $author_role_id = $user_roles['role_id'][0];
                //1901 Reviewer comments not visible to author
                // co-author can able to view the form
                $Authors_table = (new \App\Models\Authors)->getTable();
                $where .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true  WHEN gdata_posted_by =' . $current_user["user_id"] . ' THEN true  END ';

                /*$where .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true  WHEN gdata_posted_by =' . $current_user["user_id"] . ' THEN true WHEN FIND_IN_SET('.$current_user["user_id"].',(SELECT GROUP_CONCAT(auth_usr_id)
                FROM '.$Authors_table.'
                WHERE auth_art_id = '.$article_flow_details->aflw_art_id.'))>0 THEN true END ';*///commented this code as the author can see all fields on the form if a single element is assigned for a privilaged stage.Instead of this show author stage for coauthor regardless of checking form permission as in the completed form that is instead of checking the author role check author stage

            }
            if($privilages['reviewer'] == true )
            {
             $where .= ' AND CASE WHEN FIND_IN_SET('.$roleid.',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $roleid . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN gdata_posted_by =' . $current_user["user_id"].' THEN true END ';
            }
        } else {
            if ($privilages['privilaged'] == true || (($privilages['reviewer'] == true || $privilages['author'] == true))) {

                $parent_flow_id = ($article_flow_details->aflw_parent_flow_id != null) ? $article_flow_details->aflw_parent_flow_id : $article_flow_details->aflw_id;

                $where_r = '';
                if ($privilages['privilaged'] == false && $privilages['reviewer'] == true) {
                    $where_r .= ' and aflw_usr_id =  ' . $this->current_user['user_id'] . '';
                }
                $article_flow_table = (new \App\Models\Article_flow)->getTable();
                //when decline & re-invite the same reviewer then avoid that record
                $where_review = 'aflw_parent_flow_id =' . $parent_flow_id . ' AND (aflw_status =\'c\' or (aflw_status=\'d\' and aflw_usr_id not in (select aflw_usr_id from ' . $article_flow_table . ' where aflw_status in ("a","i","c","u") and aflw_parent_flow_id =' . $parent_flow_id . ' and aflw_art_id=' . $article_flow_details->aflw_art_id . ')))' . $where_r . '';
                if (isset($this->current_client->functionality->cfty_show_decline_reviewprocess_tab) && $this->current_client->functionality->cfty_show_decline_reviewprocess_tab == 'n')
                    $where_review .= ' and aflw_status!=\'d\'';
                $child_article_flows = Article_flow::get_single_record('GROUP_CONCAT(aflw_id) as flow_id,SUM(CASE WHEN aflw_status ="c" THEN 1 ELSE 0 END) AS completed_count', $where_review);

                if ($child_article_flows->flow_id != '') {
                    $where = 'gdata_artflw_id IN (' . $child_article_flows->flow_id . ') AND gdata_art_id = ' . $article_flow_details->aflw_art_id;
                }
            } else {
                $where = 'gdata_artflw_id =' . $article_flow_details->aflw_id . ' AND gdata_art_id = ' . $article_flow_details->aflw_art_id;;
            }
        }
        $forms = array();
        $forms_exist = array();
        if ($where != '') {

            $where_exist=$where;
            if ($article_flow_details->jwf_stage_type == 'review' || $article_flow_details->jwf_stage_type == 'author_submission') {
                if ($privilages['author'] == true && isset($article_flow_details->atotp_review_method) && $article_flow_details->atotp_review_method != 'o') {
                    $author_role_id = $user_roles['role_id'][0]; // when user has author role in an article then other roles are removed
                    //author need to display all author form regardless of checking the viewable form
                    if ($stage_author == false) {

                        //1901 Reviewer comments not visible to author
                        $where .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $roleid . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true END ';
                    }
                } elseif ($privilages['author'] == false && $privilages['reviewer'] == false) {
                    $user_roles_form = $user_roles["role_id"];
                    if ($privilages['privilaged'] == true) {
                        $author_key = array_search("author", $user_roles["assigned_roles"]);
                        if ($author_key!==false && $author_key >= 0) {

                            unset($user_roles_form[$author_key]);
                        }
                    }
                    $where .= ' and CASE WHEN gncf_user_roles IS null THEN true WHEN gncf_user_roles = "[]" THEN true WHEN FIND_array_intersect(REPLACE(REPLACE(REPLACE(gncf_user_roles,\']\',\'\'),\'[\',\'\'),\'"\',\'\'), "' . implode(",", $user_roles_form) . '") >0 THEN true WHEN gdata_posted_by =' . $current_user["user_id"] . ' THEN true END';
                } elseif($privilages['reviewer'] == true) {
					$where .= ' AND CASE WHEN FIND_IN_SET('.$roleid.',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $roleid . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN gdata_posted_by =' . $this->current_user["user_id"].' THEN true END';
				}
            }
            // remove element form custom form settings bug fixed
            $form_select ="CASE WHEN emt_hideafterstage IS NULL THEN (SELECT emt_hideafterstage FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='label' order by tbk_id DESC limit 1) ELSE emt_hideafterstage END AS emt_hideafterstage, CASE WHEN emt_element_type IS NULL THEN (SELECT emt_element_type FROM tbk_generic_form_elements WHERE emt_id=gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date <=gdata_posted_date order by tbk_id DESC limit 1) ELSE emt_element_type END AS emt_element_type, CASE WHEN emt_tinymce_required IS NULL THEN (SELECT emt_tinymce_required FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='textarea' order by tbk_id DESC limit 1) ELSE emt_tinymce_required END AS emt_tinymce_required,";

            $form_select .= 'gdata_dynamic_status,gdata_art_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_user_roles,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gdata_gfg_id,gncf_form_type,gncf_user_roles,gncf_posted_by,gncf_form_privilege_usr_edit,gdata_atfemt_id';

            $formatted_journal_code = '_' . $jnlcode;
            $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
            $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();

            $details_tables = array(
                'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
                'join_table' => array(
                    $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
                    $Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id','left'),

                )
            );
            $order_by = "gdata_data_order,gdata_posted_date asc";
            if(!empty($article_flow_details->jwf_forms) && count(json_decode($article_flow_details->jwf_forms))>0){
                $form_order = implode(',',(json_decode($article_flow_details->jwf_forms)));
                $order_by = "FIELD(gdata_atf_id,".$form_order."),gdata_data_order,gdata_posted_date asc";
            }

            // print_r($forms);die;
//DB::enableQueryLog();
            if ($edit_form_comment_flag == true) {
                $Form_edithistory_table = (new \App\Models\Form_edithistory())->getTable();
                $Article_flag_table = (new \App\Models\Article_flag())->getTable();
                $date_format = $this->get_platform_date_format($jnl_id);
                $date_format = $this->date_format_map($date_format);

                $where = str_replace('gdata_posted_by', 'aflw_usr_id', $where);
                // Select additional column from Article_flag_table
                $form_select .= ', ' . $Article_flag_table . '.aflg_id,rvw_article_gnf_form_data'. $formatted_journal_code.'.gdata_flag_id ,rvw_article_gnf_form_data'. $formatted_journal_code.'.gdata_flag_deletestatus,(select count(*) from rvw_article_gnf_form_data'. $formatted_journal_code.' where aflg_flag_id = rvw_article_gnf_form_data'. $formatted_journal_code.'.gdata_flag_id AND aflg_aflw_id = rvw_article_gnf_form_data'. $formatted_journal_code.'.gdata_artflw_id ) as gdata_flag_count';
                $form_select .= ', tb1.feh_posted_by, DATE_FORMAT(tb1.feh_posted_date, "' . $date_format . '") as feh_posted_date';
                $query = 'SELECT ' . $form_select . ' 
                            FROM rvw_article_gnf_form_data' . $formatted_journal_code . ' 
                            JOIN ' . $Generic_forms_table . ' ON gncf_id = gdata_atf_id 
                            LEFT JOIN ' . $Generic_form_elements_table . ' ON gdata_atfemt_id = emt_id 
                            JOIN ' . $article_flow_table . ' ON aflw_id = gdata_artflw_id 
                            LEFT JOIN ' . $Article_flag_table . ' ON aflg_flag_id = gdata_flag_id AND aflg_art_id = gdata_art_id
                            LEFT JOIN (
                                SELECT feh_id, feh_gncf_id, feh_posted_by, feh_posted_date 
                                FROM ' . $Form_edithistory_table . ' 
                                WHERE feh_id IN (
                                    SELECT MAX(feh_id) 
                                    FROM ' . $Form_edithistory_table . ' 
                                    WHERE feh_art_id = ' . $article_flow_details->aflw_art_id . ' 
                                    GROUP BY feh_gncf_id
                                )
                            ) AS tb1 ON (gdata_feh_id = tb1.feh_id AND tb1.feh_gncf_id = gdata_atf_id)
                            WHERE ' . $where . ' 
                            ORDER BY ' . $order_by;

                            $forms = Article_flow::get_records_by_raw_query($query);
            }
            else
            {
                $forms = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', $order_by, null, '', null, null, true);
            }
            //$res= DB::getQueryLog();
            //dd($res);
            //DB::enableQueryLog();
            $forms_exist = Article_flow::get_results_using_joins($details_tables,'GROUP_CONCAT(DISTINCT gdata_artflw_id) as gdata_artflw_id', $where_exist,'single', 'gdata_data_order asc', null, '', null, null, true);
            //$res= DB::getQueryLog();
            //dd($res);

        }
        $return_arr =array('forms'=>$forms,'forms_exist'=>$forms_exist,'child_article_flows'=>$child_article_flows);
        return $return_arr;
    }
    //***  get completed forms for a stage & also messages ends ***/

    //***  get previous article data (id, last flowid) starts ***/
    public function get_previous_articledata(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'artflow_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $previous_array_data = array();
            if (!empty($post_data['art_id'])) {
                $art_id = isset($post_data['art_id']) ?  Rv_decrypt($post_data['art_id']) : '';
                $artflow_id= isset($post_data['artflow_id']) ?  Rv_decrypt($post_data['artflow_id']) : '';
                $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
                $existrecord =$this->checkValidRecord($art_id, $artflow_id,$jnlcode);
                if($existrecord == false)
                {
                    return  $this->warning('Failed', 200, "redirectdashboard");
                }
                $articleids = Articles::get_single_record('art_pre_all_ids', 'art_id=:art_id',null,'',null,array('art_id'=>$art_id));
                if (!empty($articleids->art_pre_all_ids)) {
                    $prev_art_ids = explode(",", $articleids->art_pre_all_ids);
                    rsort($prev_art_ids);
                    if (!empty($prev_art_ids)) {
                        foreach ($prev_art_ids as $art_id) {
                            $select_article_details = "max(aflw_id) as max_id,art_version_no,jnl_journal_code,jnl_id";
                            //$condition = "aflw_art_id=" . $art_id;
                            $condition = "aflw_art_id=:art_id";
                            $condition_arr=array('art_id'=>$art_id);
                            $group_by = 'art_id';
                            $article_flow_dets = Articles::get_article_details($select_article_details, $condition, null, false, false, $group_by,$condition_arr);
                            if(isset($article_flow_dets[0]))
                            {
                                $previous_array_data[] = array(
                                    'aflw_id' => $this->encrypt_data($article_flow_dets[0]->max_id),
                                    'art_id' => $this->encrypt_data($art_id),
                                    'version' => $article_flow_dets[0]->art_version_no,
                                    'jnl_id' => $article_flow_dets[0]->jnl_id,
                                    'jnl_journal_code' => $article_flow_dets[0]->jnl_journal_code
                                );
                            }
                        }
                    }
                }
            }
            return  $this->success('Success', 200, $previous_array_data);
        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }
    //***  get previous article data (id, last flowid) ends ***/


    public function show_tab($user_roles, $article_id, $viewable_role, $jnl_journal_code, $roleid, $user_id)
    {
        $criteria = '';
        $show_tab = false;
        $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
        $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
        $tables = array(
            'main_table' => 'rvw_article_gnf_form_data_' . $jnl_journal_code,
            'join_table' => array(
                $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data_' . $jnl_journal_code . '.gdata_atf_id'),
                $Article_flow_table => array($Article_flow_table . '.aflw_id', 'rvw_article_gnf_form_data_' . $jnl_journal_code . '.gdata_artflw_id'),
                $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id'),

            )
        );
        if ($viewable_role == 'author') { 
            $author_role_id = $user_roles['role_id'][0]; // when user has author role in a article then other roles are removed

            $criteria = 'aflw_status IN ("c") AND jwf_assignment=\'invitation\' AND gdata_art_id =' . $article_id;
            $criteria .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true  END ';
        } elseif ($viewable_role == 'reviewer') {
            $criteria .= ' jwf_stage_type IN ( \'revision\',\'resubmission\') and CASE WHEN gncf_user_roles is null or gncf_user_roles="[]"  THEN (gdata_posted_by=' . $user_id . ') ELSE JSON_SEARCH(gncf_user_roles,"one","' . $roleid . '") IS NOT null OR gdata_posted_by=' . $user_id . ' END';
        }
        $criteria .=' AND gdata_art_id ='.$article_id;
        $Article_generic_form_data = new \App\Models\Article_generic_form_data();
        $stages_count = $Article_generic_form_data::get_results_using_joins($tables, 'count(*) as cnt', $criteria, 'single', null, null, '', null, null, true);
        if ($stages_count->cnt > 0) {
            $show_tab = true;
        }
        return $show_tab;
    }
    //*** save data when review is skipped using proceed with out review starts */
    public function proceed_without_review(Request $request)
    {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $this->current_user = $this->get_current_user_details();
            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $current_status_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : '';
            $journa_id_input = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $journal_code = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $existrecord =$this->checkValidRecord($article_id, $current_status_id,$journal_code);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $Stage_email_templates = new \App\Models\Stage_email_templates();
            $Unassign_reviewer = new \App\Models\Unassign_reviewer;
            $User = new \App\Models\User;
            if($journa_id_input=='')
            {
            $platform_data = $this->platform_basic_settings_data($journal_code);
            $journa_id_input = $platform_data->jnl_id;
            }
            if (isset($post_data['invite_tmpl_to_cust_cc'])) {
                $post_data['invite_tmpl_to_cust_cc'] = !empty($post_data['invite_tmpl_to_cust_cc']) ? implode(',', $post_data['invite_tmpl_to_cust_cc']) : '';
            }
            if (isset($post_data['invite_tmpl_to_cust_bcc'])) {
                $post_data['invite_tmpl_to_cust_bcc'] = !empty($post_data['invite_tmpl_to_cust_bcc']) ? implode(',', $post_data['invite_tmpl_to_cust_bcc']) : '';
            }
            //$art_type_id = decrypt_link($post_data['article_type_id']);

            //$current_status_name = decrypt_link($post_data['hdn_stage_type']);
            //select next stage
            $Generic_flows = new \App\Models\Generic_flows;
            $next_stage_data = $Generic_flows::get_article_next_stage($current_status_id);
            $selected_next_stage = json_decode($next_stage_data->jwf_child_stages);
            $selected_next_stage = $selected_next_stage[0];

            $curr_stage_review_count = Article_flow::get_single_record('count(*) as cnt', 'aflw_parent_flow_id =:current_status_id and aflw_status =:status',null,'',null,array('current_status_id'=>$current_status_id,'status'=>'c'));

            $current_stage = Article_flow::get_aticle_statuses($article_id, $this->current_user, $current_status_id, true);
            $curr_stage_child = json_decode($current_stage[0]->jwf_child_stages);
            $is_valid = false;
            $user_roles = $this->validate_user_journal($journal_code, $this->current_user['user_id']);

            if ($current_stage[0]->jwf_assignment == 'invitation' && count($curr_stage_child) == 1 && $current_stage[0]->aflw_skip_review == 'n' && (count(array_intersect($user_roles['role_id'], json_decode($current_stage[0]->jwf_parent_user_roles))) > 0 || count(array_intersect($user_roles['role_id'], json_decode($current_stage[0]->jwf_who_can_invite))) > 0) && $curr_stage_review_count->cnt == 0 && $this->current_client->functionality->cfty_proceed_without_review == 'y') {
                $is_valid = true;
            }
            $return_data = array(

            );
            $assigned = false;
            if ($current_stage[0]->jwf_assignment == 'invitation') {
                $invite_roles = $assign_roles = array();
                $invite_roles = json_decode($current_stage[0]->jwf_who_can_invite);
                $assign_roles = json_decode($current_stage[0]->jwf_parent_user_roles);

                $invite_assign_role = array_unique(array_merge($invite_roles, $assign_roles));
                $role_assigned = array();
                if (!empty($invite_assign_role)) {
                    $User_articles = new \App\Models\User_articles;
                    foreach ($invite_assign_role as $inv) {
                        $usr_list = array();
                        $usr_list = $User_articles::get_single_record('GROUP_CONCAT(usra_usr_id) as user', 'usra_role_id=:inv and usra_art_id=:article_id',null,'',null,array('inv'=>$inv,'article_id'=>$article_id));
                        $role_assigned[$inv] = (!empty($usr_list) && isset($usr_list->user)) ? $usr_list->user : array();
                    }
                    foreach ($role_assigned as $rl) {
                        $rl_array = array();
                        if (empty($rl)) {
                            $assigned = true;
                        } else {
                            $rl_array = explode(',', $rl);
                            if (in_array($this->current_user['user_id'], $rl_array)) {
                                $assigned = true;
                            }
                        }
                    }
                }
            }
            if ($is_valid == false || $assigned == false) {
                return $this->warning('Warning', 200, customTrans('viewarticle.invalid_access'));
            }
            $Article_types = new \App\Models\Article_types;
            $cur_art_type_record = $Article_types::get_single_record('artp_jnl_id, artp_fwm_id', 'artp_id=:art_artp_id',null,'',null,array('art_artp_id'=>$current_stage[0]->art_artp_id));
            $flow_master_id = $cur_art_type_record->artp_fwm_id;
            $checkout_article = false;
            $new_article_id = null;
            $ithenticate_enabled = false;
            $force_change_status = false;

            $invited_reviewers_list = Article_flow::get_all_records('aflw_usr_id,aflw_id', 'aflw_parent_flow_id = ' . $current_status_id . ' and  aflw_status IN (\'i\',\'a\')');
            DB::beginTransaction();
            $move_next_data_array['checkout_article'] = $checkout_article;
            $move_next_data_array['article_id'] = $article_id;
            $move_next_data_array['current_user'] = $this->current_user;
            $move_next_data_array['master_flow_id'] = $flow_master_id;
            $move_next_data_array['current_stage'] = $current_status_id;
            $move_next_data_array['current_jwf_id'] = $current_stage[0]->jwf_id;
            $move_next_data_array['artp_id'] = $current_stage[0]->art_artp_id;
            //$move_next_data_array['ithenticate_enabled']=$ithenticate_enabled;
            $move_next_data_array['current_client'] = $this->current_client;
            //$move_next_data_array['this_stage'] = $this_stage;
            $move_next_data_array['trans_started'] = true;
            //$move_next_data_array['role_id'] = $article_basics->jwf_role_id;
            //$move_next_data_array['auto_assign_role'] = $auto_assign_role;
            //$move_next_data_array['stage']=$stagename;
            $move_next_data_array['next_stage'] = $curr_stage_child[0];
            $move_next_data_array['force_move'] = $force_change_status;
            $Journal_settings = new \App\Models\Journal_settings;
            $jset_reply_to_email = $Journal_settings::get_single_record('jset_reply_to_email', "jset_jnl_id = '{$journa_id_input}' ")->jset_reply_to_email;
            $move_next_data_array['jset_reply_to_email'] = $jset_reply_to_email;
            $move_next_data_array['proceed_wo_review'] = true;
            $stage_move_result = $this->move_next_stage($move_next_data_array);
            //send article flow id to es module
            if (isset($stage_move_result['action']) && $stage_move_result['action'] == 'moved_to_next' ) {
            $esarray['article_id']=$article_id;
            $checkdata=$this->check_espermission_access($esarray);
            if($checkdata == TRUE)
            {
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                if(isset($es_api_data['create_stage_backup']))
                        {
                            $apiUrl = $es_api_data['create_stage_backup'];
                            $data_to_editor = array('documentId' => $article_id,'currentFlowId' => $current_status_id,'systemType' => 1,'stage_name_privillaged' => $current_stage[0]->jwf_stage_name,'stage_name_non_privillaged' => $current_stage[0]->jwf_temporary_status_name  == NULL ? $current_stage[0]->jwf_stage_name : $current_stage[0]->jwf_temporary_status_name,'current_user' => $this->current_user);
                            $data_to_editor = http_build_query($data_to_editor);
                            $response = $this->es_curl_request($apiUrl,$data_to_editor);
                            $response = json_decode($response);
                        }
            }
            }
             if (count($invited_reviewers_list) >= 1) {
                $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept';
                $condition="aflw_id=:aflw_id";
                $condition_arr = array('aflw_id'=>$current_status_id);
                $article_details = Articles::get_article_details($select,$condition ,null,false,false,null,$condition_arr);
                $article_details = $article_details[0];

                $invite_tmpl_name=decrypt_link($post_data['invite_tmpl_name']);
                $condition = "stage_etmp_action='unassign_user' AND stage_etmp_id= {$invite_tmpl_name}";
                $email_template = $Stage_email_templates::get_single_record('*', $condition);

                if (!empty($email_template)) {
                    $post_data['art_id'] = $article_id;
                    $insert_data = array(
                        'unsn_reason' => $post_data['postdata']['unassign_reason'],
                    );
                    if (isset($post_data['postdata']['stage_template_to_mail'])) {
                        $post_data['unassign_email_reply_to'] = $post_data['postdata']['stage_template_to_mail'];
                    }
                    // if (isset($post_data['postdata']['stage_template_to_cc'])) {
                    //     $post_data['unassign_tmpl_to_cc'] = $post_data['postdata']['stage_template_to_cc'];
                    // }
                    // if (isset($post_data['postdata']['stage_cust_cc'])) {
                    //     $post_data['unassign_tmpl_to_cust_cc'] = $post_data['postdata']['stage_cust_cc'];
                    // }
                    // if (isset($post_data['postdata']['stage_template_to_bcc'])) {
                    //     $post_data['unassign_tmpl_to_bcc'] = $post_data['postdata']['stage_template_to_bcc'];
                    // }
                    // if (isset($post_data['postdata']['stage_cust_bcc'])) {
                    //     $post_data['unassign_tmpl_to_cust_bcc'] = $post_data['postdata']['stage_cust_bcc'];
                    // }
                    if (!empty($post_data['postdata']['stage_template_to_cc'])) {
                        // $stage_etmp_cc = json_encode($post_data['postdata']['stage_template_to_cc']);
                        $post_data['unassign_tmpl_to_cc'] = $post_data['postdata']['stage_template_to_cc'];
                        $optccvalue = array();
                        if (isset($post_data['postdata']['stage_cust_cc'])) {
                            $custm_cc = $post_data['postdata']['stage_cust_cc'];
                            for ($i = 0; $i < count($custm_cc); $i++) {
                                $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                                $cust_value = str_replace('\\', '"', $cust_value);
                                $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                                array_push($optccvalue, $cust_value);

                            }
                            $post_data['unassign_tmpl_to_cust_cc'] = implode(',', $optccvalue);

                        }
                        else{
                            $post_data['unassign_tmpl_to_cust_cc'] = '';
                        }

                    }
                    if (!empty($post_data['postdata']['stage_template_to_bcc'])) {
                        // $stage_etmp_bcc = json_encode($post_data['postdata']['stage_template_to_bcc']);
                        $post_data['unassign_tmpl_to_bcc'] = $post_data['postdata']['stage_template_to_bcc'];
                        $optbccvalue = array();
                        if (isset($post_data['postdata']['stage_cust_bcc'])) {
                            $custm_bcc = $post_data['postdata']['stage_cust_bcc'];
                            for ($i = 0; $i < count($custm_bcc); $i++) {
                                $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                                $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                                $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                                array_push($optbccvalue, $cust_bcc_value);

                            }
                            $post_data['unassign_tmpl_to_cust_bcc'] = implode(',', $optbccvalue);
                        }
                        else{
                            $post_data['unassign_tmpl_to_cust_bcc']='';
                        }

                    }
                    foreach ($invited_reviewers_list as $invited) {
                        $usr_details = $User::get_single_record('usr_email,usr_id',"usr_id={$invited->aflw_usr_id}");

                        //update the unassign reason
                        $insert_data['unsn_rvr_id'] = $invited->aflw_usr_id;
                        $insert_data['unsn_aflw_id'] = $invited->aflw_id;

                        $Unassign_reviewer::insert_record($insert_data, $this->current_user);
                        $post_data['esl_aflw_id'] = $invited->aflw_id;
                        $replace_button = array('<button contenteditable="false">', '</button>');
                        $post_data['postdata']['stage_template_content'] = str_replace($replace_button, '##', $post_data['postdata']['stage_template_content']);
                        $this->send_unassign_email($email_template, $post_data, $article_details, $usr_details,$journa_id_input,$journal_code);
                    }
                }
            }

            $tmp_status_id = $current_status_id;
            if (isset($stage_move_result['action']) && $stage_move_result['action'] == 'moved_to_next') {
                $msg = customTrans('viewarticle.move_next_success') . implode(',', $stage_move_result['stage_name']);
                $tmp_status_id = is_array($stage_move_result['stage_id']) ? $stage_move_result['stage_id'][0] : $stage_move_result['stage_id'];
                $return_data['action']=$stage_move_result['action'];
                //Modified for the task Feature #887 Informative update message

                $return_data['status'] = 'success';
                $return_data['msg'] = $msg;
                $return_data['stageid'] = $tmp_status_id;
                $return_data['article_id'] = $article_id;
                $return_data['show_modal'] = true;
                //$return_data['url'] = $redirection_link;
            }

            if (isset($stage_move_result['skipped_by_advanced']) && $stage_move_result['skipped_by_advanced'] == true) {
                $where_condition = 'aflw_art_id=' . $article_id . ' and apfm_status=\'a\'';
                $add_where = 'FIND_IN_SET(' . $selected_next_stage . ',apfm_end_stg_jwf_id) > 0';
                $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
                $orderby = 'apfm_id desc';
                $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement;
                $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where, $orderby);
                if (count($get_path_having_jwf) > 0) {
                   $return_data['msg'] = customTrans('viewarticle.move_restrict');

                    $return_data['stageid'] = $current_status_id;
                    $return_data['article_id'] = $article_id;
                    $return_data['show_modal'] = true;
                    return $this->warning('Warning', 200, $return_data);

                } else {

                    $return_data['show_modal'] = true;
                    $return_data['article_id'] = $article_id;
                    $return_data['stageid'] = $current_status_id;

                }
            }
            if(isset($stage_move_result) && isset($stage_move_result['action']) && ($stage_move_result['action'] == 'moved_to_next' || $stage_move_result['action'] == 'incomplete_parallel_stages'))
                    {
                        $get_art_es_status = Articles::get_single_record_with_bind_cond('art_es_document_status',array('art_id' => $article_id));
                        $esarray['article_id']=$article_id;
                        $checkdata=$this->check_espermission_access($esarray);
                        //if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && count($get_art_es_status)>0 && $get_art_es_status->art_es_document_status !== 'n')
                        if($checkdata==true && !empty($get_art_es_status) && $get_art_es_status->art_es_document_status !== 'n')
                        {
                            $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                            $es_api_data  = Config::get($es_config);
                            if(isset($es_api_data['send_back_to_review']))
                            {
                                $apiUrl = $es_api_data['send_back_to_review'];
                                $data_to_editor = array('art_id' => $article_id);
                                $data_to_editor = http_build_query($data_to_editor);
                                $response = $this->es_curl_request($apiUrl,$data_to_editor);
                                $response = json_decode($response);
                            }
                        }
                    }
            return  $this->success('Success', 200, $return_data);
        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }
    //*** save data when review is skipped using proceed with out review ends */

    public function validate_transfered_article_details_completed($article_details, $redirect = false, $return_basic = false,$es_article = false)
    {
        $current_status_id = $article_details->aflw_id;
        $current_status_name = $article_details->jwf_stage_type;
        $has_error = false; $section ='';
        $article_id = $article_details->art_id;

        if ($article_details->art_title == "") {
            $has_error = true;
            $section = "basic";
        }
        if ($article_details->art_abstract == "") {
            $has_error = true;
            $section = "basic";
        };
        $Journal_settings = new \App\Models\Journal_settings;
        $jset_min_keyworddata = $Journal_settings::get_single_record('jset_min_keyword', "jset_jnl_id = :jset_jnl_id",null,'',null,array('jset_jnl_id'=>$article_details->jnl_id));
        $jset_min_keyword=$jset_min_keyworddata->jset_min_keyword;
        if ($jset_min_keyword > 0) {
            $article_keyword = Article_keywords::get_single_record('count(*) as cnt', 'ak_art_id=:article_id',null,'',null,array('article_id'=>$article_id));
            if ($article_keyword->cnt < $jset_min_keyword) {
                $has_error = true;
                $section = "keyword";
            }
        }

        $Article_type_advance_options = new \App\Models\Article_type_advance_options();
        $article_type_advance = $Article_type_advance_options::get_single_record('atotp_classification','atotp_artp_id='.$article_details->art_artp_id);
        if($article_type_advance->atotp_classification == 'y')
        {
            $Article_classification = new \App\Models\Article_classification;
            $old_art_classification = $Article_classification::get_single_record('count(arcls_cls_id) as cnt','arcls_art_id='.$article_id);
            if($old_art_classification->cnt == 0)
			{
				$has_error = true;
                $section = "classification";
			}
        }


        if ($return_basic == true) {
            return array('has_error'=>$has_error,'section'=>$section);
            exit;
        }

        $get_status = $this->get_article_pdf_status($article_id);
        if ($get_status['status'] == false && $es_article == false) {
            $has_error = true;
            $section = "pdf";
        }


        if ($current_status_name != 'transit') {
            $validate_forms = $this->validate_stage_forms($current_status_id, $article_details->jnl_id, $article_details->jnl_journal_code);
            $has_error =  ($validate_forms == false) ? true : $has_error;
            $section ="form";
        }
        return array('has_error'=>$has_error,'section'=>$section);
    }

    public function check_casrai_and_orcid($current_status_name, $current_status_id, $article_id, $journal_code)
    {
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow = Config::get($workflow_config);

        if ($current_status_id != '') {
            $rev_record = Article_flow::get_single_record('aflw_jwf_id', 'aflw_id=' . $current_status_id);
        } else {
            $rev_record = Article_flow::get_single_record('aflw_jwf_id', 'aflw_art_id=' . $article_id . ' and aflw_returned_date is null');
        }
        $Generic_flows = new \App\Models\Generic_flows();
        $rev_stage = $Generic_flows::get_journal_workflow_details('jwf_confirm_casrai_credits,jwf_confirm_orcid,role_assigned_role', 'jwf_id=' . $rev_record->aflw_jwf_id);
        $rev_stage = $rev_stage[0];
        //$casrai_orcid_module = $this->Modules->get_single_record('mdl_casrai_credit,mdl_orcid');
        $casrai_orcid_module = $this->current_client->modules;
        $cas_confirmed = $orcid_confirmed = 1;
        if ($casrai_orcid_module->mdl_casrai_credit == 'y' && $rev_stage->jwf_confirm_casrai_credits == 'y' && isset($review_flow[$current_status_name]['enable_casrai_credits_confirm']) && $review_flow[$current_status_name]['enable_casrai_credits_confirm'] == true) {
            $Author_credits = new \App\Models\Author_credits();
            $cas_authors = $Author_credits::get_authors_casrai_credits($article_id);
            if (!empty($cas_authors)) {
                $cas_confirmed = 0;
            }
        }

        if ($casrai_orcid_module->mdl_orcid == 'y' && $rev_stage->jwf_confirm_orcid == 'y' && isset($review_flow[$current_status_name]['enable_orcid_confirm']) && $review_flow[$current_status_name]['enable_orcid_confirm'] == true) {
            $Authors = new \App\Models\Authors();
            $orcid_authors = $Authors::get_orcid_authors($article_id);
            if (!empty($orcid_authors)) {
                $orcid_confirmed = 0;
            }
        }

        if (!$orcid_confirmed || !$cas_confirmed) {
            if (!$orcid_confirmed && !$cas_confirmed) {
                $msg = customTrans('viewarticle.confirm_casari_orcid_msg');
            } elseif (!$orcid_confirmed) {
                $msg = customTrans('viewarticle.confirm_orcid_msg');
            } else {
                $msg = customTrans('viewarticle.confirm_casrai_msg');
            }

            $view_article = $rev_stage->role_assigned_role == 'author' ? 'author-article' : 'view-article';
            /*$redirection_link = base_url('journal/' . $journal_code . '/' . $view_article) . '?' . encrypt_link("article_id={$article_id}&&status_id={$current_status_id}");
			$this->session->set_flashdata('msg_view_article', $msg);
			redirect($redirection_link);*/
            $return_data = array('msg' => $msg, 'view_article' => $view_article);
            return $return_data;
        }
    }

    //*** to transfer data from article type to another articletype and journal to journal  starts */
    function transfer_article_with_stage($transfer_details, $article_id, $current_status_id, $journa_id_input, $journal_code, $author_without_confirmation = false)
    {
        $User_articles = new \App\Models\User_articles();
        $this->current_user = $this->get_current_user_details();
        if (!empty($article_id) && !empty($current_status_id) && !empty($journa_id_input)) {
            if (isset($transfer_details->ats_art_id) && $transfer_details->ats_art_id!='') {
                $article_id = $transfer_details->ats_art_id;
                $article_type = $transfer_details->ats_dst_artp;
                $journal_id = $transfer_details->ats_dst_jnl;
                $stage = $transfer_details->ats_dst_stage;
                $generic_data_transfer = true;
                $transfer_mode = $transfer_details->ats_article_data; //1 - resubmit 2 - move to particular stage
                $author_action = $transfer_details->ats_author_action;

                if ($author_action == 1) // Author accept Transfer article
                {
                    //Task #4768 Article types use journal workflow
                    $both_artp_user_same_workflow = false;
                    if ($transfer_details->ats_src_jnl == $transfer_details->ats_dst_jnl) {
                        $Article_types = new \App\Models\Article_types();
                        $source_artp = $Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',null,'',null,array('artp_id'=>$transfer_details->ats_src_artp));

                        $destination_artp = $Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',null,'',null,array('artp_id'=>$transfer_details->ats_dst_artp));
                        //if both source and destination article types sharing same workflow
                        if (isset($source_artp->artp_fwm_id) && isset($destination_artp->artp_fwm_id) && $source_artp->artp_fwm_id == $destination_artp->artp_fwm_id) {
                            $both_artp_user_same_workflow = true;
                        }
                    }

                    $article_data = Articles::get_article_data($article_id);
                    $Journals = new \App\Models\Journals();
                    $destination_journal_data = $Journals::get_single_record('jnl_journal_code', 'jnl_id=:journal_id',null,'',null,array('journal_id'=>$journal_id));

                    //if transfer article in the same journal then no need to shift generic form data
                    if ($destination_journal_data->jnl_journal_code == $article_data->jnl_journal_code) {
                        $generic_data_transfer = false;
                    }
                    $transit_jwf_id = Article_flow::get_single_record('aflw_jwf_id', 'aflw_id=:current_status_id',null,'',null,array('current_status_id'=>$current_status_id));

                    $condition = '(aflw_status = "a" or aflw_status = "w" or aflw_status = "p") and aflw_art_id=' . $article_id;
                    $del_condition    = ' aflw_art_id = ' . $article_id . ' AND aflw_status = \'u\'';

                    if ($both_artp_user_same_workflow == true) {
                        $cnd_txt = ' AND aflw_jwf_id != ' . $stage;
                        $condition .= $cnd_txt;
                        $del_condition .= $cnd_txt;
                    }
                    if ($author_without_confirmation == false) {
                        Article_flow::update_flow(array(
                            'aflw_status' => 'c',
                            'aflw_returned_date' => date('Y-m-d H:i:s'),
                            'aflw_posted_date' => date('Y-m-d H:i:s'),
                        ), $condition);
                        // TASK #9554 Due date and initialization mail missing during article type transfer within the same journal
                        //get transit complete email template
                       if (!empty($transit_jwf_id))
                       {  // Fetch email template
                           $Stage_email_templates = new \App\Models\Stage_email_templates();
                           $email_template =  $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_action,stage_etmp_to,stage_etmp_id', "stage_etmp_action = 'completed' AND setr_jwf_id = {$transit_jwf_id->aflw_jwf_id}");                          
                           if (!empty($email_template))
                            {
                                foreach ($email_template as $template)
                                {
                                    if (isset($transfer_details->ats_src_artp, $article_data->jnl_id, $article_data->jnl_journal_code, $article_data->art_submitted_by)) 
                                    {
                                        $custom_data = array(
                                            'prev_article_id'=> $article_id,
                                            'article_id'=> $article_id,
                                            'artp_id'=> $transfer_details->ats_src_artp,
                                            'stage_etmp_action' => $template->stage_etmp_action,
                                            'stage_etmp_to'     => $template->stage_etmp_to,
                                            'template_id'     => $template->stage_etmp_id,
                                            'jnl_id'=>$article_data->jnl_id,
                                            'jnl_code'=>$journal_code,
                                            'src_jnl_id'=>$article_data->jnl_id,
                                            'aflw_id'=>$current_status_id,
                                        );
                                        $email_data = array(
                                            'type' => 'stage',
                                            'action' => 'send',
                                            'aflw_id'=>$current_status_id,
                                            'email_with_login' => TRUE,
                                            'user_id' => $article_data->art_submitted_by,
                                            'jnl_user_role'=>array(
                                            'core_role'=>'',
                                            'role_name'=>'',
                                            'jnl_journal_code'=> $journal_code
                                        ),
                                            'custom_data' => $custom_data
                                        );
                                        
                                        $this->master_email_details($email_data);
                                    }
                                }
                            }
                        }
                    }
                    if ($both_artp_user_same_workflow == false) {
                    Article_flow::delete_records($del_condition, '', $this->current_user);
                    }
         
                    if ($transfer_mode == 2) { // move trasnfer mode
                        //update article tb
                        $old_article_update = array(
                            'art_transfer_article' => 'y',
                            'art_transfer_status' => 'n',
                            'art_pdf_status' => 'n',
                            'art_status' => 'y',
                            'art_artp_id' => $article_type,
                            //'art_code' => $new_article_code
                        );
                        //update article tb
                        Articles::update_record($old_article_update, 'art_id=' . $article_id, $this->current_user);

                        //update rvw_article_flag tb
                        $Article_flag = new \App\Models\Article_flag();
                        $Article_flag::update_record(array(
                            'aflg_jnl_id' => $journal_id
                        ), 'aflg_art_id=' . $article_id, $this->current_user);

                        //insert in rvw_article_flow tb
                        $today = date('Y-m-d H:i:s');
                        $data_list = array(
                            'aflw_art_id' => $article_id,
                            'aflw_jwf_id' => $stage,
                            'aflw_assigned_date' => $today,
                            //'aflw_status' => 'u'
                        );
                        /* RVW1480 - Deadlock situation when the article transfered to an assignment stage. */
                        $Generic_flows = new \App\Models\Generic_flows();
                        $flow_details = $Generic_flows::get_single_Record('jwf_assignment,jwf_no_of_min_users,jwf_no_of_max_users,jwf_role_id,jwf_tat_complete', 'jwf_id=:stage',null,'',null,array('stage'=> $stage));
                        $due_date_str = $this->get_due_date_for_article($article_id, $flow_details->jwf_tat_complete);
                        $data_list['aflw_due_date'] = $due_date_str;
                        $data_list['aflw_status'] = 'u';
                        if ($flow_details->jwf_assignment != 'self_service') {
                            $data_list['aflw_status'] = ($flow_details->jwf_assignment == 'invitation') ? 'w' : 'p';
                            $data_list['aflw_stage_min_users'] = $flow_details->jwf_no_of_min_users;
                            $data_list['aflw_stage_max_users'] = $flow_details->jwf_no_of_max_users;
                        } // RVW1480 - Deadlock situation when the article transfered to an assignment stage.
                        else {

                            $article_assgned_user = $User_articles::get_all_records('usra_usr_id', 'usra_art_id=:article_id  and usra_role_id=:jwf_role_id',null, null,'', null, null,'ASC',array('article_id'=>$article_id,'jwf_role_id'=>$flow_details->jwf_role_id));
                            if (count($article_assgned_user) == 1) {
                                $data_list['aflw_status'] = 'a';
                                $data_list['aflw_accepted_date'] = $today;
                                $due_date = new \DateTime($today);
                                $due_date_str = $this->get_due_date_for_article($article_id, $flow_details->jwf_tat_complete);
                                $data_list['aflw_due_date'] = $due_date_str;
                                $data_list['aflw_usr_id'] = $article_assgned_user[0]->usra_usr_id;
                            }
                        }
                        $max_flow = Article_flow::get_single_record('max(aflw_level) as max_aflw_level', 'aflw_art_id=:article_id',null,'',null,array('article_id'=>$article_id));
                        $data_list['aflw_level'] = (isset($max_flow->max_aflw_level)) ? $max_flow->max_aflw_level + 1 : 1;

                        //Task #4768 Article types use journal workflow

                        $insert_flow=true; $insertid ="";
                        if ($both_artp_user_same_workflow == true)
                        {
                            //check stage exists in articleflow table
                            $flow_exist = Article_flow::get_single_record('aflw_id', 'aflw_art_id=:article_id and aflw_jwf_id=:aflw_jwf_id and aflw_status!=:aflw_status',null,'',null,array('article_id'=>$article_id,'aflw_jwf_id'=>$stage,'aflw_status'=>'c'));
                            if(!empty($flow_exist) && (isset($flow_exist->aflw_id) && !empty($flow_exist->aflw_id)))
                            {
                                $insert_flow = false;
                                $insertid =$flow_exist->aflw_id;
                            }
                        }

                        if($insert_flow == true) 
                        {
                            $insertid = Article_flow::insert_record($data_list, $this->current_user);
                        }

                        if ($generic_data_transfer == true && $both_artp_user_same_workflow == false) {
                            $Article_generic_form_data = new \App\Models\Article_generic_form_data();
                            $Article_generic_form_data::copy_generic_form_data($article_id, $article_data->jnl_journal_code, $destination_journal_data->jnl_journal_code);

                            $Article_generic_form_data::delete_records('gdata_art_id=' . $article_id, "_" . $article_data->jnl_journal_code, $this->current_user);
                        }
                        $new_article_id = $article_id;
                        $article_new_data = Articles::get_article_data($new_article_id);

                        /* Bug #1624 Add reviewers to article */
                        $this->add_users_to_article($article_id, $article_new_data, 'reviewer');
                        /* Bug #1624 Add reviewers to article */



                        $new_upload_path = $article_new_data->jnl_journal_code . '/' . $article_new_data->artp_abbr_article_type . '/' . $new_article_id;
                        //update article tb
                        Articles::update_record(array(
                            'art_article_upload_path' => $new_upload_path,
                        ), 'art_id=' . $new_article_id, $this->current_user);
                    }

                    /* Bug  Add authors to article */
                    $this->add_users_to_article($article_id, $article_new_data, 'author');
                    /* Bug  Add authors to article */


                    /* Remove users from article - suggestion by IET JIRA - Commented because they asked to keep the assignment as before */

                    /* Add users to article type */
                    $user_assigned_in_article = $User_articles::get_all_records('usra_usr_id,usra_role_id', 'usra_art_id=' . $new_article_id);
                    if (!empty($user_assigned_in_article)) {

                        foreach ($user_assigned_in_article as $usra) {
                            $inp_array = 'usrj_usr_id=' . $usra->usra_usr_id . ' and usrj_artp_id=' . $article_new_data->artp_id . ' and usrj_jnl_id=' . $article_new_data->jnl_id . ' and usrj_role_id=' . $usra->usra_role_id;
                            $User_to_journals = new \App\Models\User_to_journals();
                            $user_jnl_exists = $User_to_journals::get_single_record('count(*) as cnt', $inp_array);
                            $data_inp_ar = array(
                                'usrj_usr_id'=>$usra->usra_usr_id,
                                'usrj_artp_id'=>$article_new_data->artp_id,
                                'usrj_jnl_id'=> $article_new_data->jnl_id,
                                'usrj_role_id' => $usra->usra_role_id
                            );
                            if ($user_jnl_exists->cnt == 0) {

                                $User_to_journals::insert_record($data_inp_ar, $this->current_user);
                            }
                        }
                    }


                    if (empty($insertid) && $both_artp_user_same_workflow == false) {
                        $return_arr['msg'] = customTrans('viewarticle.copy_article_err');
                        $return_arr['alert'] = 'error';
                        $return_arr['redirect'] = false;
                    } else {

                        $return_arr['msg'] = customTrans('viewarticle.copy_article_success');
                        $return_arr['alert'] = 'success';
                        $return_arr['redirect'] = false;
                        $return_arr['insertid'] = $insertid;
                    }
                }                
            } else {
                $return_arr['msg'] = customTrans('viewarticle.not_valid_frm');
                $return_arr['alert'] = 'error';
                $return_arr['redirect'] = false;
            }
        } else {
            $return_arr['msg'] = customTrans('viewarticle.not_valid_frm');
            $return_arr['alert'] = 'error';
            $return_arr['redirect'] = false;
        }
        if ($author_without_confirmation == false) {
            $return_arr['redirect'] = true;
        }
        return $return_arr;
    }
    //*** to transfer data from article type to another articletype and journal to journal  ends */

    //*** to transfer data and reject starts */
    function transfer_article_reject($article_id, $current_status_id, $journa_id_input, $journal_code)
    {
        $this->current_user = $this->get_current_user_details();
        //$redirection_link = base_url('journal/' . $journal_code);
        if (!empty($article_id) && !empty($current_status_id) && !empty($journa_id_input)) {
            $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
            $transfer_details = $Article_transfer_suggestion::get_single_record('ats_art_id,ats_dst_artp,ats_dst_jnl,ats_dst_stage,ats_article_data,ats_author_action,ats_src_artp,ats_dst_artp', 'ats_art_id=:article_id and ats_aflw_id=:current_status_id and ats_src_jnl=:journa_id_input',null,'',null,array('article_id'=>$article_id,'current_status_id'=>$current_status_id,'journa_id_input'=>$journa_id_input));
            if (isset($transfer_details->ats_art_id) && $transfer_details->ats_art_id!='') {
                $article_id = $transfer_details->ats_art_id;
                $article_type = $transfer_details->ats_dst_artp;
                $journal_id = $transfer_details->ats_dst_jnl;
                $stage = $transfer_details->ats_dst_stage;
                $generic_data_transfer = true;

                $transfer_mode = $transfer_details->ats_article_data; //1 - resubmit 2 - move to particular stage
                $author_action = $transfer_details->ats_author_action;


                //Article_flow::trans_start();
                //DB::beginTransaction();
                Article_flow::update_record(array(
                    'aflw_returned_date' => date('Y-m-d H:i:s'),
                    'aflw_status' => 'c'
                ), 'aflw_id=' . $current_status_id . ' and aflw_art_id=' . $article_id, $this->current_user);
                Articles::update_record(array(
                    'art_status' => 'y'
                ), 'art_id=' . $article_id, $this->current_user);
                //DB::commit();
                $return_arr['msg'] = customTrans('viewarticle.transfer_article_declined');
                $return_arr['redirect'] = false;
                $return_arr['alert'] = 'success';

            } else {
                $return_arr['msg'] = customTrans('viewarticle.not_valid_frm');
                $return_arr['alert'] = 'error';
                $return_arr['redirect'] = false;
            }
        } else {

            $return_arr['msg'] = customTrans('viewarticle.not_valid_frm');
            $return_arr['alert'] = 'error';
            $return_arr['redirect'] = false;
        }
        return $return_arr;

        //redirect($redirection_link);
    }
    //*** to transfer data and reject ends */

    //*** add user to journal and article type starts */
    public function add_users_to_article($article_id, $article_new_data, $role = 'reviewer')
    {
        $this->current_user = $this->get_current_user_details();
        $journal_id = $article_new_data->jnl_id;
        $article_users = array();
        if ($role == 'reviewer') {
            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $genericflows_table = (new \App\Models\Generic_flows())->getTable();
            $sql = 'SELECT aflw_usr_id as user_id,jwf_role_id as role_id FROM ' . $articleflow_table . ' as aflw JOIN ' . $genericflows_table . ' as jwf ON aflw_jwf_id = jwf_id WHERE aflw_art_id =' . $article_id . ' AND jwf_stage_type = "review" AND aflw_status !="d" AND aflw_usr_id IS NOT null';

            $article_users = Article_flow::get_records_by_raw_query($sql);
        }
        if ($role == 'author') {
            $Authors = new \App\Models\Authors();
            $author_role = Roles::get_single_record('role_id', "role_assigned_role='author'");
            $article_users = $Authors::get_all_records('auth_usr_id as user_id,' . $author_role->role_id . ' as role_id', 'auth_art_id=' . $article_id);
        }

        if (!empty($article_users)) {
            foreach ($article_users as $art) {
                $User_to_journals = new \App\Models\User_to_journals();
                $user_in_journal = $User_to_journals::find_user_in_journal($article_new_data->jnl_id, $art->user_id, $role, $article_new_data->artp_id, $art->role_id);


                $insert_fields = array(
                    'usrj_jnl_id' => $journal_id,
                    'usrj_usr_id' => $art->user_id,
                    'usrj_role_id' => $art->role_id
                );
                if(isset($user_in_journal[0]))
                {
                if ($user_in_journal[0]->user_in_jnl == 0) { //add user in journal
                    $User_to_journals::insert_record($insert_fields, $this->current_user);
                }

                if ($user_in_journal[0]->user_in_artp == 0) { //add user in article type
                    $insert_fields['usrj_artp_id'] = $article_new_data->artp_id;
                    $User_to_journals::insert_record($insert_fields, $this->current_user);
                }
                }
            }
        }
    }
     //*** add user to journal and article type ends */

    public function update_article_attachfile_desigfor(Request $request)
	{
        try
        {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                    'file' => 'required',
                    'name' => 'required',
                    'status' => 'required',
                    'art_id' => 'required',
                    'type' => 'required'
                ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $file_id = $request->file;
            $location_desig = $request->name;
            $status = $request->status;
            $art_id = $this->decrypt_data($request->art_id);
            $type = $request->type;
            $current_art_st_id = null;
    //		if ($this->input->post('current_art_st_id') != '')
    //			$current_art_st_id = decrypt_link($this->input->post('current_art_st_id'));
            $return_arr = array(
                'status' => 'err'
            );
            if ($location_desig != '' && $file_id != '')
            {
                if($type == 'single') {

                    $file_id = $this->decrypt_data($file_id);

                    $condition = "atmnt_id={$file_id}";
                    $attch_data = Attachment_files::get_single_record('atmnt_designated_to', $condition);
                    $atmnt_designated_to = json_decode($attch_data->atmnt_designated_to);

                    if ($status)
                    {
                        $atmnt_designated_to[] = $location_desig;
                    }
                    elseif (!$status)
                    {
                        foreach ($atmnt_designated_to as $key => $value)
                        {
                            if ($location_desig == trim($value))
                            {
                                unset($atmnt_designated_to[$key]);
                            }
                        }
                    }

                    $atmnt_designated_to = array_values($atmnt_designated_to);
                    $data_list = array(
                        'atmnt_designated_to' => json_encode($atmnt_designated_to)
                    );
                    $result = Attachment_files::update_record($data_list, $condition,$this->current_user);
                }
    //#385 TASK JPR-476 Select all/Deselect all option for review and production marking of attachment
                elseif ($type == 'all')
                {
                    //select all / unselect all
                    if (!empty($file_id) && !empty($location_desig))
                    {

                        $atmnt_designated_to = array();
                        foreach ($file_id as $val)
                        {
                            $condition[] = $this->decrypt_data($val);
                        }
                        //fetch current values from db
                        $attachment_files_table = (new \App\Models\Attachment_files())->getTable();
                        $sql = 'SELECT atmnt_id, atmnt_designated_to FROM ' . $attachment_files_table . ' WHERE atmnt_id IN ('.implode(',',$condition).')';
                        $attch_data = Attachment_files::get_records_by_raw_query($sql, false);
                        foreach ($attch_data as $data)
                        {
                            $atmnt_designated_to[] = json_decode($data->atmnt_designated_to);
                        }
                        if ($status)
                        {
                            foreach ($file_id as $key => $file)
                            {
                                if (!in_array($location_desig[$key], $atmnt_designated_to[$key]))
                                    array_push($atmnt_designated_to[$key], $location_desig[$key]);
                            }
                        }
                        else
                        {
                            foreach ($file_id as $k => $file)
                            {

                                if (!empty($atmnt_designated_to[$k]))
                                {


                                    if (in_array($location_desig[$k], $atmnt_designated_to[$k]))
                                    {
                                        $pos = array_search($location_desig[$k], $atmnt_designated_to[$k]);
                                        unset($atmnt_designated_to[$k][$pos]);
                                        //to reorder array
                                        $atmnt_designated_to[$k] = array_values($atmnt_designated_to[$k]);
                                    }
                                }
                            }
                        }

                        foreach ($atmnt_designated_to as $val => $designated)
                        {
                            $data_list[] = array(
                                'atmnt_designated_to' => json_encode($designated),
                                'atmnt_id' => $this->decrypt_data($file_id[$val]));
                            $criteria = "atmnt_id = {$this->decrypt_data($file_id[$val])}";
                            $result = Attachment_files::update_record(array('atmnt_designated_to' => json_encode($designated)), $criteria, $this->current_user);
                        }
                        //exit;
                        //$result = Attachment_files::update_batch($data_list, 'atmnt_id');
                    }
                }////#385 TASK JPR-476 ends

                $task = 'p'; //check whether generate pdf or preview pdf link to show
                $pdf_status = 'y';
                $criteria = "art_id ={$art_id}";
                $preview_link = '';
                $ithenticate_link = '';

                $article_pdf_status = $this->get_article_pdf_status($art_id, true, $current_art_st_id);
                if ($article_pdf_status['status'] == false)
                {
                    $task = 'g';
                    $pdf_status = 'n';
                }
                else
                {
                    $preview_link = $article_pdf_status['view_pdf_link'];
                    $ithenticate_link = $article_pdf_status['ithenticate_link'];
                    /* $preview_link = base_url('view-pdf') . '/' . encrypt_link($art_id) . "/" . encrypt_link($article_pdf_status['pdf_id']); */
                }

                /*
                $last_generated_file_data = $this->Article_pdf->get_single_record('pdf_art_attachement_order,pdf_id', array(
                'pdf_art_id' => $art_id,
                'pdf_show_status' => 'y'));
                $last_generated_file_order = null;
                if (isset($last_generated_file_data->pdf_art_attachement_order))
                $last_generated_file_order = json_decode($last_generated_file_data->pdf_art_attachement_order);


                $task = 'p'; //check whether generate pdf or preview pdf link to show
                $all_review_files = $this->Attachment_files->get_all_records('atmnt_id', array(
                'atmnt_art_id' => $art_id,
                'atmnt_designated_to LIKE' => '%"r"%'), 'atmnt_order');
                $current_order = array();
                foreach ($all_review_files as $val => $key)
                {
                $current_order[] = $key->atmnt_id;
                }

                $preview_link = '';
                if ($last_generated_file_order == null || $last_generated_file_order != $current_order)
                {
                $task = 'g';
                $pdf_status = 'n';
                }
                else
                {
                $preview_link = base_url('view-pdf') . '/' . encrypt_link($art_id) . "/" . encrypt_link($last_generated_file_data->pdf_id);
                }
                */
                if ($result)
                {
                    $result = Articles::update_record(array(
                        'art_pdf_status' => $pdf_status
                        ), $criteria, $this->current_user);
                    $return_arr['preview_link'] = $preview_link;
                    $return_arr['ithenticate_link'] = $ithenticate_link;
                    $return_arr['status'] = 'success';
                    $return_arr['task'] = $task; //preview(p) or generate(g) pdf
                    $return_arr['pdf_status'] = $pdf_status;
                    return  $this->success('Success', 200, $return_arr);
                }

            }

        }
        catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
	}

    //*** get article type submission form data,decision control buttons and permiison for diaplaying next button starts */
    public function get_submissioninfo_form(Request $request) {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = isset($post_data['art_id'])?Rv_decrypt($post_data['art_id']):'';
            $jnlcode=isset($post_data['jnlcode'])?Rv_decrypt($post_data['jnlcode']):'';
            $jnl_id=isset($post_data['jnl_id'])?Rv_decrypt($post_data['jnl_id']):'';
			$flow_id = isset($post_data['art_flow_id'])?Rv_decrypt($post_data['art_flow_id']):'';
            $roleid = isset($post_data['roleid']) ? Rv_decrypt($post_data['roleid']) : '';
            $existrecord =$this->checkValidRecord($article_id, $flow_id,$jnlcode);
            $remove_tab_andform=true;
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
			$curent_article_id = Rv_decrypt($post_data['curent_article']);
            $this->current_user = $this->get_current_user_details();
            $articleflowtable = (new \App\Models\Article_flow)->getTable();
            $genericflowstable = (new \App\Models\Generic_flows)->getTable();
            $rolesstable = (new \App\Models\Roles)->getTable();
            $Article_flow = new \App\Models\Article_flow();
            $formcomplete=array();

            $tables = array(
                'main_table' => $articleflowtable,
                'join_table' => array(
                    $genericflowstable => array($genericflowstable . '.jwf_id', $articleflowtable . '.aflw_jwf_id', "join"),
                    $rolesstable => array($genericflowstable . '.jwf_role_id', $rolesstable . '.role_id', "left")
                )
            );
            $condition = "aflw_art_id={$article_id} AND aflw_id={$flow_id} ";
            $getflowdetails = $Article_flow::get_results_using_joins($tables, "aflw_usr_id,aflw_parent_flow_id,jwf_assignment,jwf_stage_type,jwf_stage_name,jwf_fwm_id,jwf_role_id,jwf_forms,jwf_tab_name,aflw_stage_repeat_count,aflw_id,jwf_tab_name,jwf_id,aflw_level,jwf_parent_user_roles,jwf_who_can_invite,aflw_skip_review,jwf_reviewers_discuss_forum,aflw_status,aflw_returned_date,aflw_stage_min_users,aflw_stage_max_users,aflw_art_id,aflw_more_review_skip_status,jwf_status_name,jwf_child_stages,jwf_flow_proceed_type,role_name", $condition, 'single');


            //$condition = 'art_id=' . $article_id;
            $condition = "art_id=:article_id";
            $condition_arr=array('article_id'=>$article_id);
            $article_data = Articles::get_article_details('art_submitted_by,art_delete_status,artp_id,art_version_no,art_id,artp_fwm_id,art_status', $condition, null, true, false,null,$condition_arr);
            $article_data = $article_data[0];
            $article_privilages = $this->article_privilages($article_data, $flow_id, $jnlcode);
            $user_permited_roles = $this->user_permitted_role($this->current_user['user_id'], $jnlcode, $article_data->artp_id);
            $all_user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $article_data->artp_id);

        $Article_type_advance_options = new \App\Models\Article_type_advance_options();
        $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method',"atotp_artp_id={$article_data->artp_id}");

            $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
            /* Roles assigned to this article */
            $user_array = array();
            $user_array['user_roles'] = $all_user_roles;
            $user_array['article_id'] = $article_id;
            $user_array['all_roles'] = $all_roles;
            $user_array['article_privilages'] = $article_privilages;
            $user_array['jnl_id'] = $jnl_id;
            $user_roles = $this->get_article_user_roles($user_array);
            $formid_emt = 0;
            $nodatafilled=false;
            $completed_forms = $this->get_completed_forms($getflowdetails, $article_privilages, $all_user_roles, $this->current_user, $jnlcode,null,$jnl_id,$roleid);
            $completed_forms =$completed_forms['forms'];
            $completedformarr[$getflowdetails->aflw_id]=[];
        if(!empty($completed_forms)) {
            $getflowdetails->art_id=$article_data->art_id;
            $getflowdetails->art_submitted_by=$article_data->art_submitted_by;
            $hide_tab_form_status=array();
            $view_form = collect([]);
            $all_form = collect([]);
            $array_data=array(
                'completedformarr'=>$completedformarr,
                'completed_forms'=>$completed_forms,
                'flow'=>$getflowdetails,
                'user_roles'=>$user_roles,
                'article_privilages'=>$article_privilages,
                'atotp_review_method'=>$artp_settings->atotp_review_method,
                'platform_id'=>$jnl_id,
                'functional_type'=>'a',// completed article submission form
            );
            $res=$this->getCompletedstageORsubmissionformdetails($array_data);
            if(!empty($res)) {
                $completedformarr=$res['completedformarr'];
                $view_form=$res['view_form'];
                $all_form=$res['all_form'];
                $hide_tab_form_status=$res['hide_tab_form_status'];
            }



            if($remove_tab_andform==true && $getflowdetails->jwf_assignment != 'invitation' ){
                //reset tab with all form You are not permitted to see this content .
                //$hide_tab_form_status=array();
                $difference = $all_form->diff($view_form);
                $hide_tab_form_status['visible_form']=$view_form;
                $hide_tab_form_status['all_form']=$all_form;
                $hide_tab_form_status['hide_form']=$difference->all();
                $getflowdetails->hide_tab_form_status=$hide_tab_form_status; // to do

                if(count($completedformarr)>0){
                    if(isset($hide_tab_form_status['hide_form'])){
                        foreach ($hide_tab_form_status['hide_form'] as $row) {
                            unset($completedformarr[$getflowdetails->aflw_id]['group'][$row]);
                        }
                    }
                }
            }

            if(empty($completedformarr[$getflowdetails->aflw_id])){
                unset($completedformarr[$getflowdetails->aflw_id]);
            }
        } else{
            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $genericflows_table = (new \App\Models\Generic_flows())->getTable();
            $tables = array(
                'main_table' => $articleflow_table,
                'join_table' => array(
                    $genericflows_table => array($articleflow_table . '.aflw_jwf_id', $genericflows_table . '.jwf_id', "left")
                )
            );

            $condition = "aflw_art_id=? AND jwf_stage_type='author_submission'";
            $binding_arr = array($article_id);
            $original_art_data = Article_flow::get_results_using_joins($tables, 'aflw_id,jwf_forms', $condition, 'single', null, null,'',null,null,false,null,false,$binding_arr);


            if(!empty($original_art_data)){
                $flowid=$original_art_data->aflw_id;


            $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
            $Article_generic_form_data_tbl = $article_generic_form_data_table.'_'.$jnlcode;

            $implode_role_data = implode(',', json_decode($original_art_data->jwf_forms, true));
            $sql = "SELECT count(gdata_art_id) as count FROM " . $Article_generic_form_data_tbl . " WHERE gdata_art_id ={$article_id} and gdata_artflw_id={$original_art_data->aflw_id} and gdata_atf_id IN({$implode_role_data})";
            $data_sql = Article_generic_form_data::get_records_by_raw_query($sql);
            if($data_sql[0]->count==0){
                $nodatafilled=true;
            }
            }
        }



			$message = '';

            if(count($completedformarr)>0){
                if(isset($completedformarr[$getflowdetails->aflw_id]['group'])  && !empty($completedformarr[$getflowdetails->aflw_id]['group'])){
                    $completedformarr[$getflowdetails->aflw_id]['group'] = array_values($completedformarr[$getflowdetails->aflw_id]['group']);
                    $getflowdetails->completedform = $completedformarr;
                }

                if(isset($completedformarr[$getflowdetails->aflw_id]['group'])  && empty($completedformarr[$getflowdetails->aflw_id]['group'])){
                    $completedformarr=array();
                }

            }


        if(count($completedformarr)==0 || (isset($completedformarr[$getflowdetails->aflw_id]) && empty($completedformarr[$getflowdetails->aflw_id]))) {
            // unset $completedformarr if its empty
            $completedformarr=array();
			$is_empty_content = true;
			if ($article_privilages['privilaged'] == true && !in_array($getflowdetails->aflw_status, array("a","u","p"))) {
				$message = 'Completed stage <strong>' . $getflowdetails->jwf_stage_name . '</strong>';
			}
			if ($getflowdetails->aflw_status == 'c' && $article_privilages['privilaged'] == true) {
				$message = 'Completed stage <strong>' . $getflowdetails->jwf_stage_name . '</strong>';
				$Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $select = 'jwf_stage_name';
                $art_flw_tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                    $Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id'))
                );

                $childstges = json_decode($getflowdetails->jwf_child_stages);

                $level_min_1 = $getflowdetails->aflw_level - 1;
                $level_plus_1 = $getflowdetails->aflw_level + 1;

                //$art_flw_criteria = 'aflw_art_id = '.$article_id.' AND aflw_level >='.$article_flow_details->aflw_level; art_id
                $art_flw_criteria = 'aflw_art_id = '.$article_data->art_id.' AND aflw_level IN ('.$level_min_1.','.$getflowdetails->aflw_level.','.$level_plus_1.') AND aflw_id > '.$getflowdetails->aflw_id;

                $article_flow_dets = array();
                if(count($childstges) > 0) {
                    if(count($childstges) > 1 && ($getflowdetails->jwf_flow_proceed_type == 'parallel' || $getflowdetails->jwf_flow_proceed_type == 'advance') ) { // warning commit for Shameer
                        $select = 'group_concat(distinct jwf_stage_name) as jwf_stage_name';
                    }
                    $art_flw_criteria .= ' AND aflw_jwf_id IN ('. implode(', ',$childstges).')';

                    $article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'single');
                }
                //Check stage name value set
                if (!empty($article_flow_dets)&&(isset($article_flow_dets->jwf_stage_name)&&$article_flow_dets->jwf_stage_name!='')) {
                    $message = 'Moved to stage <strong>' . str_replace(',',', ',$article_flow_dets->jwf_stage_name) . '</strong>';
                }
			} elseif ($getflowdetails->aflw_status == 'c' && $article_privilages['privilaged'] == false) {
				$message = 'Completed stage <strong>' . $getflowdetails->jwf_status_name . '</strong>';
			}

            $getflowdetails->message = $message;

        }

        if($nodatafilled==true) {
            $getflowdetails->message = "<span class='text-danger' >No data filled yet</span>";
        }


            $return_array['flowdetails'][0] = $getflowdetails;
            return $this->success('success', 200, $return_array);

        } catch (\exception $e) {


            return $this->failure('Failed', 500, $e);
        }

    }
    //*** get article type submission form data,decision control buttons and permiison for diaplaying next button ends */

    public function get_submissionflow(Request $request) {
        try {
            $result = array();
            $submission_tab = true;
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'aflw_id' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $this->current_user = $this->get_current_user_details();
            $article_id = isset($post_data['art_id']) ?Rv_decrypt($post_data['art_id']):'';
            $art_flow_id = isset($post_data['aflw_id']) ?Rv_decrypt($post_data['aflw_id']):'';
            $jnlcode = isset($post_data['jnlcode']) ? Rv_decrypt($post_data['jnlcode']) : '';
            $existrecord =$this->checkValidRecord($article_id, $art_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $Article_flow = new \App\Models\Article_flow();
            //$condition = " aflw_id={$art_flow_id}";
            $condition = " aflw_id=:art_flow_id";
            $condition_arr=array('art_flow_id'=>$art_flow_id);
            $select_article_details='art_prev_article_id,artp_fwm_id,artp_id,art_id,jnl_id,jnl_journal_code,art_status,art_stage_submission_method,aflw_status,jwf_stage_type,art_transfer_article,art_submission_date,art_delete_status,art_es_document_status,art_es_document_type';
            $article_data = Articles::get_article_details($select_article_details, $condition, null, true, false,null,$condition_arr);
            $article_privilages = $this->article_privilages($article_data[0], $art_flow_id, $article_data[0]->jnl_journal_code,"all");

            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $workflow_arr  = Config::get($workflow_config);
            $cutstagedata =$workflow_arr[$article_data[0]->jwf_stage_type];
            $stage_for =$cutstagedata['stage_for'];
            $production_stage =(isset($stage_for) && $stage_for=="review")?false:true;
            $user_roles = $this->validate_user_journal($article_data[0]->jnl_journal_code, $this->current_user['user_id'], $article_data[0]->artp_id);
            $author_role = Roles::get_single_record('role_id',"role_assigned_role='author'");
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$article_data[0]->artp_id}");
            if((isset($article_data[0]->art_prev_article_id) && $article_data[0]->art_prev_article_id!='' && $article_data[0]->art_transfer_article=='n') || (isset($article_privilages['reviewer']) && $article_privilages['reviewer']== true && (isset($artp_settings) &&  $artp_settings->atotp_review_method=='d')) || ($this->is_custom_blinded('reviewer', $article_id, jnl:$jnlcode)) || ($production_stage == true && empty(array_intersect($user_roles['assigned_roles'], array("journal_admin","staff")))) || $article_data[0]->art_submission_date==null || ($article_data[0]->art_stage_submission_method=='n' || $article_data[0]->art_stage_submission_method=='z'))
            {
                $submission_tab = false;
            }
            // TASK #9062 Missing Information on Files to be Copyedited in Author's Custom Form at Submission Stage
            // production user can view article submission suggusted by gijo so set mdl_copyedit is on
            if(isset($this->current_client->modules->mdl_copyedit) && $this->current_client->modules->mdl_copyedit == 'y'){
                $submission_tab = true;
            } 

            $getforms = $Article_flow::get_submissionflow('author_submission', $article_id);
            $result['getforms']=$getforms;
            //$condition = "jwf_id=" . $article_data[0]->jwf_id;
            $Article_type_table = new \App\Models\Article_types();
            $article_type_data =$Article_type_table::get_single_record('artp_fwm_id','artp_id='.$article_data[0]->artp_id);
            $artp_fwm_id = $article_type_data->artp_fwm_id;
            $condition = "jwf_role_id=".$author_role->role_id." AND jwf_article_attachment_status ='y' AND jwf_fwm_id = ".$artp_fwm_id." AND jwf_stage_type!='transit'";
            $stage_attachment_status = Generic_flows::get_all_records_with_bind_cond('jwf_stage_name,jwf_role_id,jwf_article_attachment_status', array(), $condition);
            $Authors = new \App\Models\Authors();
            $chk_author = $Authors::get_single_record('count(auth_id) as count', 'auth_usr_id=' . $this->current_user['user_id'] . ' AND auth_art_id=' . $article_id);
            $is_author = (isset($chk_author->count) && $chk_author->count > 0) ? true : false;
            $show_attachment = true;
            //Condition to hide attachment in the view article tab.
            if($article_privilages['privilaged'] == false && (!empty($user_roles) && !in_array('journal_admin', $user_roles['assigned_roles'])))
            {

                if($article_data[0]->art_delete_status =='w' )
                {
                    $show_attachment = false;
                }

                // if($article_data[0]->jwf_stage_type =='review' && $article_privilages['reviewer'] == true && (isset($this->current_client->functionality->cfty_show_attachments_for_reveiwers) && $this->current_client->functionality->cfty_show_attachments_for_reveiwers == 'n'))

                if($article_privilages['reviewer'] == true && (isset($this->current_client->functionality->cfty_show_attachments_for_reveiwers) && $this->current_client->functionality->cfty_show_attachments_for_reveiwers == 'n') &&  $is_author ==false)
                {
                    $show_attachment = false;
                }
                if($article_data && ($article_data[0]->art_stage_submission_method =='b' && $article_data[0]->aflw_status =='i'))
                {
                    $show_attachment = false;
                }
            }
            elseif($article_privilages['privilaged'] == true && $article_privilages['reviewer'] == true &&$article_privilages['user_allocated'] == false && $article_data[0]->jwf_stage_type =='review' && (isset($this->current_client->functionality->cfty_show_attachments_for_reveiwers) && $this->current_client->functionality->cfty_show_attachments_for_reveiwers == 'n') )
            {
                $show_attachment = false;
            }
            /* Start - Show attachment for conference */
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' && $article_privilages['privilaged'] == true && count($stage_attachment_status) <= 0)
            {
                $show_attachment = false;
            }
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' &&  $is_author == true && count($stage_attachment_status) <= 0)
            {
                $show_attachment = false;
            }
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y' &&  $article_privilages['reviewer'] == true && count($stage_attachment_status) <= 0)
            {
                $show_attachment = false;
            }
            /* End - Show attachment for conference */
            $attachment_edit_mode = true;
            $condition = "art_prev_article_id={$article_id}";
            $article_status_check = Articles::get_single_record('art_id', $condition);
            if(!empty($article_status_check))
            {
                $attachment_edit_mode = false;
            }
            $result['show_attachment'] = $show_attachment;
            $result['attachment_edit_mode'] = $attachment_edit_mode;
            $result['submission_tab']=$submission_tab;
            $result['is_author']=$is_author;

            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $workflow_arr  = Config::get($workflow_config);

            //$cutstagedata =$workflow_arr[$article_data[0]->jwf_stage_type];
            //$stage_for =$cutstagedata['stage_for'];
            //$typedata =(isset($stage_for) && $stage_for=="review")?false:true;
            $result['production_stage']=$production_stage;
            if($article_data[0]->jwf_stage_type =="pro_revision" && $is_author==true)
            {
                $result['show_attachment'] = false;
            }
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            $article_type_advance =$Article_type_advance_options::get_single_record('atotp_classification,atotp_classification_title,atotp_review_method, atotp_custom_blind_params,atotp_user_input_keyword,atotp_separate_adhoc_keywords,atotp_ithsubmission_type,atotp_plagiarism_checking,atotp_artp_id,atotp_research_integrity,atotp_rvrisubmission_type,atotp_rvriauto_submissions',"atotp_artp_id=:artp_id",null,'',null,array('artp_id'=>$article_data[0]->artp_id));
            $show_author_details = true;
            if (($article_type_advance->atotp_review_method == 'd' && $article_privilages['reviewer'] == true) || $this->is_custom_blinded('author', $article_id, jnl:$jnlcode))
            {
                $show_author_details = false;
            }
            $result['show_author_details'] = $show_author_details;
            $user_prsnt_cnt=0;
            if (isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion == 'y')
		    {
                $Generic_discussion = new \App\Models\Generic_discussion();
                $Generic_discussion_table = ($Generic_discussion)->getTable();
                $chck_discus_participant_sql = 'SELECT count(*) as cnt from '.$Generic_discussion_table.' WHERE gdis_art_id = '.$article_id.' AND JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$this->current_user['user_id'].') is NOT null';
                $user_prsnt_in_disc = $Generic_discussion::get_records_by_raw_query($chck_discus_participant_sql);
                $user_prsnt_cnt = $user_prsnt_in_disc[0]->cnt;
			}
            $result['user_prsnt_cnt'] = $user_prsnt_cnt;
            $show_original_tab = true;
            /*$current_role_status = $this->check_user_production_status($article_id,$this->current_user['user_id']);
             if($current_role_status == "production_only")
            {
                $show_original_tab = false;
            }*/
            if($production_stage==true && !in_array('journal_admin', $user_roles['assigned_roles']))
            {
                $show_original_tab = false;
            }
            $result['show_original_tab'] = $show_original_tab;
            $result['show_attachments_tab'] = true;
            if($article_data[0]->art_status == 'n' && $article_data[0]->jwf_stage_type == 'author_submission' && $article_privilages['author'] == false)
            {
                $result['show_attachments_tab'] = false;
            }
            
            $result['ithenticate_enabled'] = false;
            $result['rvri_enabled'] = false;
            if ($article_privilages['privilaged'] == true && (isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y')) {
                $platform_data = $this->platform_basic_settings_data($jnlcode);
                $platform_id    =   $platform_data->jnl_id;
                $date_format = static::date_format_map($platform_data->jset_date_format);
                $articletype_table = (new \App\Models\Article_types())->getTable();
                $sel_art_details = 'art_id,art_artp_id,art_code,artp_prefix_article_no,art_title,art_abstract,art_resubmission_no,art_status,DATE_FORMAT(art_submission_date, "' . $date_format . '") as submitted_date,art_submission_date,art_doi,art_submitted_by,artp_article_type,art_published_article_type,(select artp_article_type from ' . $articletype_table . ' where  artp_id = art_published_article_type) as published_artp_name,art_prev_article_id,DATE_FORMAT(art_decision_date, "' . $date_format . '") as decision_date,art_receive_funding,art_stub,art_version_no,datediff(NOW(),art_submission_date) as days_since_submission,art_article_upload_path,art_transfer_status,art_skipped_assignment_roles,art_delete_status,art_publication_issue,jwf_status_name,jwf_stage_name,jwf_forms,jnl_journal_name,artp_fwm_id,art_stage_submission_method,auth_usr_id,aflw_id,jnl_id,jnl_journal_code,artp_jpm_id,artp_jpm_id,artp_id,aflw_parent_flow_id,DATE_FORMAT(art_merge_date, "' . $date_format . '") as art_merge_date,aflw_status,jwf_stage_type,artp_abbr_article_type,artp_special_issue,art_publication_issue,art_stub,jwf_article_editable,art_pre_all_ids,jwf_role_id,jwf_parent_user_roles,jwf_who_can_invite,jwf_assignment,aflw_usr_id,art_transfer_article,aflw_jwf_id,art_es_document_status,art_es_document_type';

                if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
                {
                    $sel_art_details .= ',DATE_FORMAT(art_epub_date, "' . $date_format . '") as epub_date,DATEDIFF(art_epub_date, CURDATE()) AS date_difference';
                }
                if ($this->current_client->modules->mdl_review_for_doc == 'y')
                {
                    $sel_art_details .= ',DATE_FORMAT(art_update_last_date, "' . $date_format . '") as update_last_date';
                }

                if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y'){
                    $sel_art_details .= ', absc_category as abstract_category';
                }

                $condition = "aflw_art_id=:art_id and jnl_id=:jnl_id and auth_corr_author=:authorstatus";
                $condition_arr=array(
                    'art_id' => $article_id,
                    'jnl_id'=>$platform_id,
                    'authorstatus'=>'y'
                );
                if (!empty($art_flow_id)) {
                    $condition .= " and aflw_id=:aflw_id";
                    $condition_arr=array(
                        'art_id' => $article_id,
                        'jnl_id'=>$platform_id,
                        'authorstatus'=>'y',
                        'aflw_id'=>$art_flow_id
                    );
                }
                $article_details = Articles::get_article_details($sel_art_details, $condition, null, true, false,null,$condition_arr);

                $article_basics = json_decode(json_encode($article_details[0]), false);
                $aflw_select='aflw_id,jwf_stage_name, jwf_status_name,jwf_stage_type, aflw_usr_id, jwf_enable_ithenticate,jwf_role_id,jwf_forms';
                $condition6 ="art_id ={$article_basics->art_id} AND jwf_stage_type='author_submission' ";
                $submission_stage_details = Article_flow::get_article_stage_data($aflw_select, $condition6, true);
                $ithenticate= $this->get_article_ithenticate_details($jnlcode,$article_details, $article_type_advance,$article_basics,$article_privilages,$submission_stage_details);
                // if(!empty($ithenticate) && (isset($ithenticate['ithenticate_enabled']) && $ithenticate['ithenticate_enabled'] == true))
                if(!empty($ithenticate) && (isset($ithenticate['pdf_id']) && $ithenticate['pdf_id'] != '') && (isset($ithenticate['ithenticate_component']) && $ithenticate['ithenticate_component'] == true))
                {
                    $result['ithenticate_enabled'] = true;
                }
            }
            if ($article_privilages['privilaged'] == true && (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')) {
                $rvri_data= $this->get_article_rvri_details($article_id, $article_data[0]->jnl_id, $art_flow_id);
                $result['rvri_data'] = $rvri_data;
                $result['rvri_enabled'] = true;
            }
            
            return $this->success('success', 200, $result);
        } catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function check_opened_discussion(Request $request)
	{
        try {
            $post_data = $request->all();
            if(!empty($post_data))
            {
            $this->current_user = $this->get_current_user_details();
            $Generic_discussion=new \App\Models\Generic_discussion();
            $return_data = array(
                'is_result'=> 'n'
            );
            if(isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion=='y')
            {
            $article_id = $this->decrypt_data($post_data['art_id']);
            $art_flow_id = $this->decrypt_data($post_data['art_flow_id']);
            $artclearray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>true );
            $flowarray = array('input'=>$post_data['art_flow_id'],'type'=>'number', 'enc_data'=>true );
            $artclevalidation= $this->Rv_validator($artclearray);
            $flowvalidation= $this->Rv_validator($flowarray);
            if($artclevalidation==false)
            {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }
            if($flowvalidation==false)
            {
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
            }
            //$article_id =409;
            //$art_flow_id =4419;
            if(!empty($article_id) && !empty($art_flow_id))
            {
            $opened_disc_sql = 'SELECT
            Group_concat(gdis_id SEPARATOR ",") as gdis_id ,
            tbl_aflw.aflw_parent_flow_id,
            Group_concat(gdis_title SEPARATOR ",") as title
          FROM
            rvw_generic_discussion

            LEFT JOIN
            (
                 SELECT
               aflw_parent_flow_id
            FROM
              `rvw_article_flow`
            WHERE
              `aflw_art_id` = '.$article_id.' AND aflw_id = '.$art_flow_id.'
             ) as tbl_aflw
           ON
           tbl_aflw.aflw_parent_flow_id = gdis_aflw_id
          WHERE
            gdis_art_id = '.$article_id.' AND gdis_status ="o" AND gdis_hold_task ="y" AND
            (CASE
            WHEN tbl_aflw.aflw_parent_flow_id IS NOT null
               THEN gdis_aflw_id = tbl_aflw.aflw_parent_flow_id ELSE gdis_aflw_id = '.$art_flow_id.' END) ';
               $opened_disc = $Generic_discussion::get_records_by_raw_query($opened_disc_sql);
               if(!empty($opened_disc) && $opened_disc[0]->gdis_id !='')
		        {
                    $return_data = array(
                        'is_result'=> 'y',
                        'title' =>$opened_disc
                    );
                }
            }
        }
            return $this->success('success', 200, $return_data);
            }

        }catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }

    //*** show emails for unassignmnet & uninvite mail while clicking proced without review starts */
    public function get_proceed_without_review_info(Request $request)
	{
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = isset($post_data['art_id'])?$this->decrypt_data($post_data['art_id']):'';
            $current_flow_id = isset($post_data['art_flow_id'])?$this->decrypt_data($post_data['art_flow_id']):'';
            $reopened_skip = (isset($post_data['act']) && $post_data['act'] == 'move_to') ? true : false;
            $jnlcode = isset($post_data['jnlcode'])?$this->decrypt_data($post_data['jnlcode']):'';
            $jnl_id = isset($post_data['jnl_id'])?$this->decrypt_data($post_data['jnl_id']):'';
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $existrecord =$this->checkValidRecord($article_id, $current_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $jnl_id = $platform_data->jnl_id;
            if ($reopened_skip == false)
            {
                $curr_stage_review_count = Article_flow::get_single_record('count(*) as cnt', 'aflw_parent_flow_id = :current_flow_id  and aflw_status = :status',null,'',null,array('current_flow_id'=>$current_flow_id,'status'=>'c'));
                if ($curr_stage_review_count->cnt > 0)
                {
                    $return_arr['msg'] = customTrans('viewarticle.reviewer_submit');
                    return $this->warning('Warning', 200, $return_arr);
                }
            }

            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_child_stages,jwf_who_can_invite,jwf_parent_user_roles,jwf_assignment';
            //$condition ='aflw_id='.$current_flow_id;
            $condition = "aflw_id=:aflw_art_id";
            $condition_arr=array(
                'aflw_art_id' => $current_flow_id,
            );
            $article_details = Articles::get_article_details($select, $condition,null,false,false,null,$condition_arr);
            $article_details = $article_details[0];
            $article_id = $article_details->art_id;

            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow = Config::get($workflow_config);
            $reviewflow = $review_flow[$article_details->jwf_stage_type];
            $assigned = false;
            if ($article_details->jwf_assignment == 'invitation')
            {
                $invite_roles = $assign_roles = array();
                $invite_roles = json_decode($article_details->jwf_who_can_invite);
                $assign_roles = json_decode($article_details->jwf_parent_user_roles);

                $invite_assign_role = array_unique(array_merge($invite_roles, $assign_roles));
                $role_assigned = array();
                if (!empty($invite_assign_role))
                {
                    $User_articles = new \App\Models\User_articles();
                    foreach ($invite_assign_role as $inv)
                    {
                        $usr_list = array();
                        $usr_list = $User_articles::get_single_record('GROUP_CONCAT(usra_usr_id) as user','usra_role_id=:inv and usra_art_id=:article_id',null,'',null,array('inv'=>$inv,'article_id'=>$article_id));
                        $role_assigned[$inv] = (!empty($usr_list) && isset($usr_list->user)) ? $usr_list->user : array();
                    }
                    foreach ($role_assigned as $rl)
                    {
                        $rl_array = array();
                        if (empty($rl))
                        {
                            $assigned = true;
                        }
                        else
                        {
                            $rl_array = explode(',', $rl);
                            if (in_array($this->current_user['user_id'], $rl_array))
                            {
                                $assigned = true;
                            }
                        }
                    }
                }
            }
            $proceed_to_stage_title = 'next';
            if ($reopened_skip == false && $assigned == false)
            {
               return $this->warning('Warning', 200, customTrans('viewarticle.invalid_access'));
            }
            $invited_reviewers_list = Article_flow::get_all_records('aflw_usr_id,aflw_id', 'aflw_parent_flow_id = ' . $current_flow_id . ' and aflw_status in (\'i\',\'a\')');
            $stage_etmp_id='';
            if (isset($post_data['stage_etmp_id']) && $post_data['stage_etmp_id'] != "")
            {
                $stage_etmp_id=$post_data['stage_etmp_id'];
            }
            $user_info = '';
            $user_id = array();
            $all_templates = array();
            if (count($invited_reviewers_list) >= 1)
            {
                    $data = array(
                    'type' => 'email',
                    'current_flow_id' => $current_flow_id,
                    'stage_etmp_id' => $stage_etmp_id,
                    'article_details' => $article_details,
                    'invited_reviewers_list' => $invited_reviewers_list
                );
                /* $Stage_email_templates = new \App\Models\Stage_email_templates();
                $condition = "stage_etmp_stage_type='".$article_details->jwf_stage_type."' and setr_jwf_id='".$article_details->jwf_id."' and stage_etmp_action='unassign_user'";
                $email_templates = $Stage_email_templates::get_stage_email_tmpl_to_trigger('stage_etmp_id, stage_etmp_name', $condition);

                if (empty($email_templates))
                {
                    $return_data['status'] = 'tmpl_err';
                    $return_data['msg'] = customTrans('viewarticle.undefined_template');
                    return $this->warning('Warning', 200, $return_data);
                }
                foreach ($email_templates as $email_key => $email_value)
                {
                    $encrpt_id = encrypt_link($email_value->stage_etmp_id);
                    $email_value->encrpt_id = $encrpt_id;
                }
                if (isset($post_data['stage_etmp_id']) && $post_data['stage_etmp_id'] != "")
                {
                    $condition.="stage_etmp_id=".$this->decrypt_data($post_data['stage_etmp_id']);
                    //$condition['stage_etmp_id'] = decrypt_link($post_data['stage_etmp_id']);
                }
                $template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
                $rvr_aflw_id = '';
                $all_templates = $template;
                // var_dump($template);die;
                if (!empty($template))
                {
                    $data = array(
                        'status' => 'success',
                        'type' => 'email',
                        'template' => $template,
                        'stage_etmp_id' => $article_id,
                        'article_id' => $article_id,
                        'invited_reviewers_list' => $invited_reviewers_list
                    );

                    $template = $template[0];
                    $this->load->library('user');
                    $email_data = new stdClass;
                    $email_data->article_id = $article_id;
                    $email_data->all_user_roles = $this->User_to_journals->get_user_role_classification($article_id, 'a');


                    $this->load->library('email');
                    $this->load->library('Sendemail', array(
                        'client' => $this->current_client));
                    $this->load->model(array(
                        'Custom_email_template_tags',
                        'workflow/Stage_email_templates',
                        'workflow/Generic_forms',
                        'workflow/Generic_form_elements',
                        'Article_generic_form_data'));
                    $load = array(
                        'users' => $this->Users,
                        'Custom_email_template_tags' => $this->Custom_email_template_tags,
                        'utility' => $this->utility,
                        'Stage_email_templates' => $this->Stage_email_templates,
                        'email' => $this->email,
                        'email_log' => $this->Email_send_log,
                        'Article_pdf' => $this->Article_pdf,
                        'Roles' => $this->Roles,
                        'Generic_form_elements' => $this->Generic_form_elements
                    );

                    $this->load->library('workflow');
                    $email_data->artp_id = $article_details->art_artp_id;
                    $email_data->jnl_id = $this->jnl_data->jnl_id;
                    $email_data->jnl_journal_code = $this->jnl_data->jnl_journal_code;
                    $email_data->email_templates_config = $this->workflow->email_templates_config;
                    if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                        $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                    $email_data->join_config = $this->workflow->join_config;
                    $email_data->join_dependency_config = $this->workflow->join_dependency_config;
                    $email_data->user_role_tags = $this->workflow->user_role_tags;
                    if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                        $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

                    $this->load->library('user');
                    $user_titles = $this->user->titles;
                    $preview_recipient = false;
                    if ((count($invited_reviewers_list) == 1))
                    {
                        $preview_recipient = true;
                        $reviewer_id = $invited_reviewers_list[0]->aflw_usr_id;
                        $rvr_aflw_id = $invited_reviewers_list[0]->aflw_id;
                        $reviewer = $this->Users->get_single_record('usr_id,usr_image,usr_title,usr_username,usr_first_name,usr_last_name,usr_email', array(
                            'usr_id' => $reviewer_id));
                        $email_data->user_name = $reviewer->usr_username;
                        $email_data->name = $reviewer->usr_first_name . ' ' . $reviewer->usr_last_name;
                        $email_data->user_email = $reviewer->usr_email;
                        $email_data->user_id = $reviewer_id;
                        $reviewer->user_titles = $this->user->titles;
                        $reviewer->modal_title = 'Email preview';
                                            //#431 Not showing user middle name in adhoc email popup
                                            $reviewer->full_name = $this->get_user_display_name($reviewer_id,'','','','', '','','',true,'','',true);
                        $user_info = $this->load->view('view_article/templates/tmpl_reviewer_info', $reviewer, true);
                        $user_id[] = encrypt_link($reviewer_id);
                    }
                    else
                    {
                        $preview_recipient = false;
                        $user_info = '<div class="col-lg-offset-2">';
                        foreach ($invited_reviewers_list as $invited)
                        {
                            $user_id[] = encrypt_link($invited->aflw_usr_id);
                            $user = $this->Users->get_single_record('usr_title,usr_first_name,usr_last_name,usr_email', array(
                                'usr_id' => $invited->aflw_usr_id));
                            $user_info .= $this->load->view('view_article/templates/tmpl_unassign_user_info', $user, true);
                        }
                        $user_info .= '</div><br/>';
                    }

                    $body = $this->sendemail->generate_email_data_from_keys($email_data, $template->stage_etmp_content, $load, $this->current_user, $user_titles, $preview_recipient);
                    $subject = $this->sendemail->generate_email_data_from_keys($email_data, $template->stage_etmp_subject, $load, $this->current_user, $user_titles, $preview_recipient);
                    $reply_to = '';
                    if (isset($this->current_client->email_settings['reply_to_email']) && $this->current_client->email_settings['reply_to_email'] != '')
                    {
                        $reply_to = $this->current_client->email_settings['reply_to_email'];
                    }
                    if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y")
                    {
                        if ($this->jnl_data->jset_reply_to_email != "" && $this->jnl_data->jset_reply_to_email != null)
                            $reply_to = $this->jnl_data->jset_reply_to_email;
                    }

                    //Bug #1809 : JPR-260 Remove options for cc and bcc roles in invitation email
                    $to_cc_arr = json_decode($template->stage_etmp_cc);
                    $to_bcc_arr = json_decode($template->stage_etmp_bcc);
                    $cc_bcc_roles = array();
                    $disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
                    //restrict unwanted fetch
                    //if ($disable_cc_bcc_editable == 'y')
                    //{
                        if ((!empty($to_cc_arr) && count(array_diff($to_cc_arr, array(
                                'Custom'))) >= 1) || (!empty($to_bcc_arr) && count(array_diff($to_bcc_arr, array(
                                'Custom'))) >= 1))
                        {
                            //$privileged_roles = privileged_user_roles();
                            //$user_roles = $this->Roles->get_all_records('role_name, role_assigned_role', 'role_assigned_role IN ("' . implode('","', $privileged_roles) . '")');
                            $role_cond = 'role_assigned_role NOT IN ("system", "author")';
                            if(isset($reviewflow['stage_for']))
                            {
                                if($reviewflow['stage_for'] == 'review')
                                    $role_cond.=' and FIND_IN_SET("r", role_used_in)';
                                elseif($reviewflow['stage_for'] == 'manageproduction')
                                    $role_cond.=' and FIND_IN_SET("p", role_used_in)';
                            }

                            $user_roles = $this->Roles->get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                            if (!empty($user_roles))
                            {
                                foreach ($user_roles as $usrole)
                                {
                                    $role_label = "All " . strtolower($usrole->role_name) . "s";
                                    $cc_bcc_roles[$usrole->role_name] = $role_label;
                                }
                            }
                        }
                        $cc_bcc_roles['Custom'] = 'Specific email ID';
                    //}
                    $curr_stage_child = json_decode($article_details->jwf_child_stages);
                    if (isset($curr_stage_child[0]))
                    {
                        $next_stage_data = $this->Generic_flows->get_single_record('jwf_stage_name', array(
                            'jwf_id' => $curr_stage_child[0]));

                        $proceed_to_stage_title = $next_stage_data->jwf_stage_name;
                    }

                    $usr_ids = join(',', $user_id);
                    $data = array(
                        'status' => 'success',
                        'cc_bcc_roles' => $cc_bcc_roles,
                        'user_ids' => $usr_ids,
                        'aflw_id' => $current_flow_id,
                        'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
                        'to_cc' => $to_cc_arr,
                        'to_bcc' => $to_bcc_arr,
                        'cust_cc' => $template->stage_etmp_cust_cc,
                        'cust_bcc' => $template->stage_etmp_cust_bcc,
                        'reply_to' => $reply_to,
                        'subject' => $subject,
                        'content' => $body,
                        'invite_templates' => $all_templates,
                        'template_action' => 'unassign',
                        'user_info' => $user_info);
                    $btn_id = 'btn_unassgn_rvr';
                    $btn_name = 'btn_unassgn_rvr';
                    $form_name = 'form_preview_unassgn';
                    $form_id = 'form_preview_unassgn';
                    $btn_text = 'Proceed without review ';
    //					echo '<pre>';  print_r($data);echo '</pre>';
                    $data['btn_id'] = $btn_id;
                    $data['title'] = 'Unassign user';
                    $data['hold'] = 'skip';
                    $data['form_name'] = $form_name;
                    $data['form_id'] = $form_id;
                    $data['btn_name'] = $btn_name;
                    $data['btn_text'] = $btn_text;
                    $content = $this->load->view('view_article_modification/email_preview_modal', $data, true);
                    $return_data = array(
                        'status' => 'success',
                        'msg' => 'success',
                        'content' => $content
                    );
               } */
            }
            else
            {

                $shortlisted_reviewers_list = Article_flow::get_single_record('count(aflw_usr_id) as cnt', 'aflw_parent_flow_id = :current_flow_id and aflw_status = :status',null,'',null,array('current_flow_id'=>$current_flow_id,'status'=>'u'));
                $child_exists = Article_flow::get_single_record('count(aflw_usr_id) as cnt', 'aflw_parent_flow_id = ' . $current_flow_id . ' AND aflw_status NOT IN (\'g\',\'d\')');

                if ($reopened_skip == true || ( $reopened_skip == false && ($shortlisted_reviewers_list->cnt > 0 || $child_exists->cnt == 0)))
                {
                    $Generic_flows=new \App\Models\Generic_flows;
                    $curr_stage_child = json_decode($article_details->jwf_child_stages);
                    $msg = customTrans('viewarticle.movedtopost');
                    if ($reopened_skip == true)
                    {
                        $hide_flow_id = $this->decrypt_data($post_data['hdn_hold_status_id']);
                        $hide_flow = Article_flow::get_single_record('aflw_jwf_id','aflw_id=:hide_flow_id',null,'',null,array('hide_flow_id'=>$hide_flow_id));
                        $next_stage_data = $Generic_flows::get_single_record('jwf_stage_name','jwf_id=:aflw_jwf_id',null,'',null,array('aflw_jwf_id'=>$hide_flow->aflw_jwf_id));
                        $msg = customTrans('viewarticle.movedto'). $next_stage_data->jwf_stage_name;
                    }
                    elseif (isset($curr_stage_child[0]))
                    {
                        $next_stage_data = $Generic_flows->get_single_record('jwf_stage_name','jwf_id=:jwf_id',null,'',null,array('jwf_id'=>$curr_stage_child[0]));
                        $msg = customTrans('viewarticle.movedto'). $next_stage_data->jwf_stage_name;
                        $proceed_to_stage_title = $next_stage_data->jwf_stage_name;
                    }
                    $data = array(
                        'status' => 'success',
                        'type' => 'message',
                        'unassign_message' => $msg,
                        'title' => 'Proceed to ' . $proceed_to_stage_title,
                        'proceed_to_stage_title' => $proceed_to_stage_title
                    );
                    //$content = $this->load->view('view_article_modification/email_preview_unassgn_rvr', $data, true);
                    /*$return_data = array(
                        'status' => 'success',
                        'msg' => 'success',
                        'content' => $data
                    );*/
                }
            }
            $return_data['email_data'] = (isset($data)) ? $data : null;
            return $this->success('success', 200, $return_data);
        }
        catch (\exception $e) {

                return $this->failure('Failed', 500, $e);
        }
	}


    //Feature #1493   JPR-100 - Re-assigning Users on Articles  (list article assignments and stage assignment)
	public function get_change_assignment_list(Request $request)
	{
		try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $post = true;
            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : '';
            $artflow_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : '';
            $jnl_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $this->current_user = $this->get_current_user_details();
            $usr_id =  isset($post_data['usr_id']) ? $post_data['usr_id'] : array();
            $assign =  isset($post_data['assign']) ? $post_data['assign'] : '';
            $existrecord =$this->checkValidRecord($article_id, $artflow_id,$jnlcode,$jnl_id);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if($jnl_id=='')
            {
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $jnl_id = $platform_data->jnl_id;
            }

            if ($article_id == '' || $artflow_id == '' || (isset($this->current_client->functionality->cfty_change_assignment) && $this->current_client->functionality->cfty_change_assignment == 'n'))
            {
                $return_arr['status'] = 'failed';
                return $this->warning('Warning', 200, $return_arr);
            }
            if(!empty($usr_id))
            {
                $usr_ids =  explode(',',$usr_id);
                if(!empty($usr_ids))
                {
                    $usrs=array();
                    foreach($usr_ids as $us)
                    {
                        $usrs[]=decrypt_link($us);
                    }
                    $usr_ids=$usrs;
                }
            }
            $art_record=Articles::get_single_record('art_artp_id','art_id=:article_id',null,'',null,array('article_id'=>$article_id));
            $Article_types=new \App\Models\Article_types;
            $arttype_record=$Article_types::get_single_record('artp_id,artp_jpm_id,artp_fwm_id','artp_id=:art_artp_id',null,'',null,array('art_artp_id'=>$art_record->art_artp_id));
            $art_artp_id=$arttype_record->artp_id;
            $artp_jpm_id=$arttype_record->artp_jpm_id;

            $user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'],$art_artp_id);
            $where = 'usra_art_id = '.$article_id;
            $default_filter = 'clients.' . $this->current_client->clnt_client_code . '.reviewer_search_default_filters.default_filters';
            $default_filters_keyword = Config::get($default_filter);
            $default_filter_key = false;
            if(isset($default_filters_keyword['sbkeyword']))
            {
                $default_filter_key = true;
            }
            $review_data = Article_flow::get_generic_flow('jwf_stage_type','aflw_id='.$artflow_id);
            $review_data->art_id=$article_id;
            $review_data->artp_id = $art_artp_id;
            $review_data->artp_fwm_id = $arttype_record->artp_fwm_id;
            $article_privilages = $this->article_privilages($review_data, $artflow_id, $jnlcode);
            $privileged_user = $article_privilages['privilaged'];
            $isauthor = $article_privilages['author'];
            $isreviewer=$article_privilages['reviewer'];
            $user_allocated=$article_privilages['user_allocated'];
            if($isauthor==true || ($isreviewer==true && $user_allocated == false))
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }


            //Task #3996 Allow change assignment in TrAction stages
            if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
            {
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
				$review_workflow = Config::get($workflow_config);
                if(isset($review_data[0]->jwf_stage_type))
                {
                    $stage_type = $review_data[0]->jwf_stage_type;
                    if(isset($review_workflow[$stage_type]['stage_for']) && $review_workflow[$stage_type]['stage_for'] == 'manageproduction')
                    {
                        $where .= ' AND FIND_IN_SET(\'p\',role_used_in) ';
                    }
                }
            }

            if (isset($this->current_client->functionality->cfty_self_assignment) && $this->current_client->functionality->cfty_self_assignment == 'n')
            {
                $where .= ' AND usra_usr_id != '.$this->current_user['user_id'];
            }
            elseif((isset($this->current_client->functionality->cfty_self_assignment) && $this->current_client->functionality->cfty_self_assignment == 'y') && (isset($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer) && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y') && $assign == true)
            {
                if(in_array($this->current_user['user_id'],$usr_ids))
                {
                    $where .= ' AND usra_usr_id != '.$this->current_user['user_id'];
                }
            }
            $Journal_permission=new \App\Models\Journal_permission();
            $Journal_permission_table = (new \App\Models\Journal_permission())->getTable();
            //DB::enableQueryLog();
            $sql = 'select FIND_array_intersect(\'' . implode(',',  $user_roles['role_id']) . '\',REPLACE(REPLACE(REPLACE(jp_change_usr_assigmnts,"]",""),"[","")," ","")) as change_usr_assign,FIND_array_intersect(\''.implode(',', $user_roles['role_id']) . '\',REPLACE(REPLACE(REPLACE(REPLACE(jp_change_usr_assigmnts,\'"\',""),"]",""),"[","")," ","")) as change_usr_assignold from ' . $Journal_permission_table.' where `jp_jpm_id` ='.$artp_jpm_id;
            $res = $Journal_permission::get_records_by_raw_query($sql);
            //$res = DB::getQueryLog();
           // dd($res);
            if(isset($res[0]) && ($res[0]->change_usr_assign === false && $res[0]->change_usr_assignold === false))
            {
                $where.=' AND usra_posted_by='.$this->current_user['user_id'].' and usra_aflw_id='.$artflow_id;
            }
            $User_articles=new \App\Models\User_articles();
            $article_assignment = $User_articles::get_allocate_user_with_role('usra_art_id,usra_usr_id as usr_id,usra_role_id as role_id,role_name', $where, 'role_name',false,true);
            if (count($article_assignment) > 0)
            {
                $flowdata = new \stdClass();
                $flowdata->artp_id = $art_artp_id;
                $flowdata->artp_fwm_id = $arttype_record->artp_fwm_id;
                $flowdata->art_id = $article_id;
                $flowdata->aflw_id = $artflow_id;
                //$flowdata=array('artp_id'=>$art_artp_id,'artp_fwm_id'=>$arttype_record->artp_fwm_id,'art_id'=>$article_id,'aflw_id'=>$artflow_id);
                $article_assignment = $this->check_assignment_tab_visibility($flowdata,$article_assignment, $review_data[0]->jwf_stage_type); // To remove the assignment tab if child stages don't have the roles.
            }
            $where_cond='aflw_id='.$artflow_id;
            $select='jwf_stage_name';
            $Generic_flows = new \App\Models\Generic_flows();
            $current_stage = $Generic_flows::get_artcle_flow($select, $where_cond);
            $article_assign=[];
            if (count($article_assignment) > 0)
            {
                //article assignment section - start
                $user_name_arr = array();
                foreach ($article_assignment as $art_asmt)
                {
                    $role = $art_asmt->role_id;
                    $art_asmt->act_class = 'art_assign';
                    if (!isset($user_name_arr[$art_asmt->usr_id]))
                    {
                        $array_data['user_id'] = $art_asmt->usr_id;
                        $array_data['journal_id'] = $jnl_id;
                        $array_data['flag'] = true;
                        $array_data['article_id'] = $article_id;
                        $array_data['jnl_code'] = $jnlcode;
                        $user_fullname= $this->get_user_display_name($array_data);
                        $user_name_arr[$art_asmt->usr_id] = $user_fullname;
                    }
                    else
                        $user_fullname = $user_name_arr[$art_asmt->usr_id];

                    $art_asmt->user_full_name = $user_fullname;
                    $art_asmt->flow_id = $artflow_id;
                    $art_asmt->assignment = 'article';
                    $art_asmt->art_id = $article_id;
                    $article_assign[]=$art_asmt;
                    //array_merge( $array_data_merge,$article_assign);
                    //$article_asmt_html .= $this->load->view('view_article_modification/templates/tmpl_change_asmt_row', $art_asmt, true);
                }
               //echo '<pre>'; print_r($article_assign); die;
                //article assignment section - end
                //stage assignment section - start
                $stage_asmt_html = '';
                $select = 'aflw_usr_id  as usr_id,jwf_stage_name,jwf_role_id as role_id,role_name';
                $where='aflw_id='.$artflow_id.' and aflw_status="a" and jwf_assignment !="invitation"';
                if (isset($this->current_client->functionality->cfty_self_assignment) && $this->current_client->functionality->cfty_self_assignment == 'n')
                {
                    $where.=' and aflw_usr_id !='.$this->current_user['user_id'];
                }
                $stage_assignment = Article_flow::get_article_flow_details($select, $where);
                $stage_details = array();
                $author_roles = Roles::get_single_record('group_concat(role_id) as role_ids',"role_assigned_role='author'");
                $auth_roles=explode(',',$author_roles->role_ids);
                if ((isset($stage_assignment[0])  && !in_array($stage_assignment[0]->role_id,$auth_roles) && (isset($res[0]) && ($res[0]->change_usr_assign == true || $res[0]->change_usr_assignold == true))) )
                {
                    if (!isset($user_name_arr[$stage_assignment[0]->usr_id]))
                    {
                        $array_data['user_id'] = $stage_assignment[0]->usr_id;
                        $array_data['journal_id'] = $jnl_id;
                        $array_data['flag'] = true;
                        $array_data['article_id'] = $article_id;
                        $array_data['jnl_code'] = $jnlcode;
                        $user_fullname= $this->get_user_display_name($array_data);
                        $user_name_arr[$stage_assignment[0]->usr_id] = $user_fullname;
                    }
                    else
                        $user_fullname = $user_name_arr[$stage_assignment[0]->usr_id];
                    //echo $user_fullname.'sss'; die;
                    $stage_assignment[0]->user_full_name = $user_fullname;
                    $stage_assignment[0]->act_class = 'stg_assign';
                    $stage_assignment[0]->flow_id = $artflow_id;
                    $stage_assignment[0]->assignment = 'stage';
                    $stage_assignment[0]->art_id = $article_id;
                   // $stage_asmt_html .= $this->load->view('view_article_modification/templates/tmpl_change_asmt_row', $stage_assignment[0], true);
                    //$stage_details = $stage_assignment[0];
                }
                else
                {
                    $stage_assignment = array();
                }

                //echo '<pre>';print_r($stage_assignment);die;
                //stage assignment section - end


                $return_arr = array(
                    'article_assignment' => $article_assign,
                    'stage_assignment' => $stage_assignment,
                    //'stage_details' => $stage_details,
                    'change_user' => '',
                    'title'=>'Change assignment'
                );
                //$change_assignment_html = $this->load->view('view_article_modification/change_assignment_master', $data_arr, true);
                //$return_arr['html'] = $change_assignment_html;
                //$return_arr['data'] = $data_arr;
                $return_arr['status'] = 'success';
            }
            else
            {
                $return_arr = $this->get_stage_change_assignment($article_id, $artflow_id,$jnl_id,$jnlcode);
                $return_arr['stage'] = true;
            }

		if ($post == false)
		{
			return $return_arr;
		}
		else
		{
			$hierachy = isset($this->current_client->functionality->cfty_keyword_hierarchy)?$this->current_client->functionality->cfty_keyword_hierarchy:'n';
			$where = array();
			/*if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
				$where = array(
					"kwdrl_inactive" => 'n');*/

			$article_keywords = Article_keywords::get_article_keywords($article_id, false, false, $hierachy, $jnl_id, $where);

			$keywords = array();
			if (!empty($article_keywords))
			{
				foreach ($article_keywords as $keys)
				{
//					$keywords[encrypt_link($keys->kwd_id)] = $keys->kwd_name;
					$keywords[($keys->kwd_id)] = $keys->kwd_name;
				}
			}
			$return_arr['article_keywords'] = $keywords;

			//echo json_encode($return_arr);

            return $this->success('success', 200, $return_arr);
        }
       } catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }
	}
    //*** show emails for unassignmnet & uninvite mail while clicking proced without review starts */

	//Feature #1493   JPR-100 - Re-assigning Users on Articles  (fetch the change assignment form)
	public function get_stage_change_assignment($article_id = null, $artflow_id = null,$jnl_id = null,$jnl_code = null)
	{
        try {
            //$post_data = $request->all();
            /*$validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }*/
            $post = false;
            $assignment = 'stage';
            if ($article_id == null)
            {
                $post = true;
                $assignment = isset($post_data['asmt']) ?  $this->decrypt_data($post_data['asmt']) : '';
                $curr_stage_role = isset($post_data['rle']) ?  $this->decrypt_data($post_data['rle']) : '';
                $ch_user = isset($post_data['ch_user']) ?  $this->decrypt_data($post_data['ch_user']) : '';
            }

            $article_id = isset($post_data['art_id']) ?  $this->decrypt_data($post_data['art_id']) : $article_id;
            $artflow_id = isset($post_data['art_flow_id']) ?  $this->decrypt_data($post_data['art_flow_id']) : $artflow_id;
            $jnl_id = isset($post_data['jnl_id']) ? $post_data['jnl_id'] : $jnl_id;
            $jnlcode = isset($post_data['jnlcode']) ? $post_data['jnlcode'] : $jnl_code;

		    $global_role = "";
            $classification_hierarchy = false;
            $client_code = $this->current_client->clnt_client_code;
            $default_filter = 'clients.' . $this->current_client->clnt_client_code . '.reviewer_search_default_filters.default_filters';
            $default_filters_keyword = Config::get($default_filter);
            $default_filter_key = false;
            if(isset($default_filters_keyword['sbkeyword']))
            {
                $default_filter_key = true;
            }

            //add code for keywords
            if ($article_id == '' || $artflow_id == '' || $this->current_client->functionality->cfty_change_assignment == 'n')
            {
                $return_arr['status'] = 'failed';
                return $this->warning('Warning', 200, $return_arr);
            }
            //Customisation #2604 - JPR-374 Browse Keywords
            $enable_browse = false;
            $where_key = array();

            if (isset($this->current_client->functionality->cfty_browse_keywords_in_submission) && $this->current_client->functionality->cfty_browse_keywords_in_submission == 'y')
            {
                if (isset($this->current_client->functionality->cfty_keyword_inactive) && $this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $where_key = "kwdrl_inactive='n'";
                $Keywords = new \App\Models\Keywords();
                $total = $Keywords::search_journal_keywords($jnl_id, false, $this->current_client->functionality->cfty_keyword_hierarchy, false, null, null, true, $where_key);
                if (isset($total) && $total[0]->cnt > 0)
                    $enable_browse = true;
            }

		//get artile flow details
        $articleflowtable = (new \App\Models\Article_flow())->getTable();
        $generictable = (new \App\Models\Generic_flows())->getTable();
        $articletable = (new \App\Models\Articles())->getTable();
		$select = 'aflw_jwf_id,aflw_usr_id,aflw_status,jwf_role_id,art_artp_id,jwf_stage_name';
		$sql = 'select ' . $select . ' from ' . $articleflowtable . ',' .$generictable . ',' . $articletable . '  where aflw_art_id = art_id  and  aflw_jwf_id = jwf_id and aflw_id=' . $artflow_id;
		$article_flow_dets = Article_flow::get_records_by_raw_query($sql);
		if (isset($article_flow_dets[0]))
		{
			$data_arr = array();
			$artp = $article_flow_dets[0]->art_artp_id;
			if ($assignment == 'stage')
				$curr_stage_role = $article_flow_dets[0]->jwf_role_id;
			//get user role
			$get_user_role = Roles::get_single_record('role_name,role_assigned_role','role_id='.$curr_stage_role);
			$global_role = $get_user_role->role_assigned_role;

			if ($assignment == 'article')
			{
				$return_arr['title'] = 'Change assignment for ' . $get_user_role->role_name;
			}
			else
			{
				$return_arr['title'] = 'Change assignment of  " ' . $article_flow_dets[0]->jwf_stage_name .' " stage';
			}

			if ($post == false)
			{
				$ch_user = encrypt_link($article_flow_dets[0]->aflw_usr_id);
			}
			//for currently allocateduser
			$return_arr['stage_user_role'] =  $data_arr['stage_user_role'] = $get_user_role->role_name;
			//$data_arr['jnl_data'] = $this->jnl_data;

			//getting article type settings data
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            $article_type_settings_data=array();
			/*$artp_select = 'atotp_primary_class,atotp_classification_hierarchy,atotp_primary_class_alias,atotp_secondary_class,atotp_secondary_class_alias';
			$article_type_settings_data = $Article_type_advance_options->get_single_record($artp_select,'atotp_artp_id='.$artp);*/
			$classification = false;
			$show_secondary = false;
			$primary_classifications = array();
			$secondary_classifications = array();
			/*if ($article_type_settings_data->atotp_primary_class == 'y' && $global_role == "associate_editor")
			{

				$classification = true;
				if ($article_type_settings_data->atotp_primary_class_alias == '')
					$article_type_settings_data->atotp_primary_class_alias = 'Primary';
				if ($article_type_settings_data->atotp_secondary_class_alias == '')
					$article_type_settings_data->atotp_secondary_class_alias = 'Secondary';

				// start -- article primary term data fetching//
				$primary_classifications = $this->Journal_terms->get_primary_in_journal($artp, 'artp', $article_id, $this->jnl_data->jnl_id);

				// end -- article primary term data fetching//
				// start -- article secondary term data fetching//
				if ($article_type_settings_data->atotp_classification_hierarchy == 'n' && $article_type_settings_data->atotp_secondary_class == 'y')
				{
					$show_secondary = true;
					$secondary_classifications = $this->Journal_terms->get_secondary_in_journal(array(
						'jntm_artp_id' => $artp,
						'jntm_type' => 's',
						'jntm_jnl_id' => $this->jnl_data->jnl_id
						), 'artp', $article_id);
				}
				elseif ($article_type_settings_data->atotp_classification_hierarchy == 'y')
				{
					$show_secondary = true;
					$classification_hierarchy = true;
					$secondary_classifications = $this->User_journal_classifications->gt_usr_cls_keyword($artp, 'a', $article_id);
				}
				// end -- article secondary term data fetching//
				//print_r($secondary_classifications);exit;
			}*/

			$article_data['article_basic_data'] = (object) array(
					'art_id' => $article_id
			);
			$data_arr['get_article_data']['article_type_settings_data'] = $article_type_settings_data;

			$data_arr['get_article_data']['article_data'] = $article_data;
			$data_arr['get_article_data']['article_type_data'] = (object) array(
					'artp_id' => $artp
			);

			$classific_role = Roles::get_role_ids("role_assigned_role IN('associate_editor')");
			$data_arr['classific_role_data'] = explode(';', $classific_role->role_ids);
			$data_arr['back_chn_asmt_btn'] = $post;

			//for getting filter
			$tmp = new \stdClass();
			$tmp->id_sufix = '_' . $curr_stage_role;
			$tmp->search_purpose = 'article_level_permission';
			$tmp->jwf_role_id = $curr_stage_role;
			$tmp->aflw_id = $artflow_id;

			$data_arr['stage'] = $artflow_id;
			$data_arr['assignment'] = $this->encrypt_data($assignment);
			$data_arr['ch_user'] = (!empty($ch_user)?$ch_user:$this->encrypt_data($this->current_user['user_id'])); //change user
			$data_arr['class_hierarchy'] = $classification_hierarchy;
			$data_arr['show_classification_search'] = $classification;
			$data_arr['show_secondary'] = $show_secondary;
			$data_arr['primary_classifications'] = $primary_classifications;
			$data_arr['secondary_classifications'] = $secondary_classifications;
			$data_arr['article_id'] = $article_id;
			$data_arr['role'] = $curr_stage_role;
			$data_arr['artp'] = $artp;
			$data_arr['enable_browse'] = $enable_browse;
			$data_arr['default_filter_key'] = $default_filter_key;
			$data_arr['disable_default_classificaton_select'] = (isset($this->current_client->functionality->cfty_disable_default_classificaton_select))? $this->current_client->functionality->cfty_disable_default_classificaton_select: '';

			//$change_assignment_html = $this->load->view('view_article_modification/change_assignment', $data_arr, true);
			if ($post == false)
			{
				$data_arr = array(
					'article_assignment' => '',
					'assignment_title' => $return_arr['title'],
					'stage_assignment' => '',
					'stage_details' => array(),
					//'change_user' => $change_assignment_html,
				);
				//$change_assignment_html = $this->load->view('view_article_modification/change_assignment_master', $data_arr, true);
			}

            $return_arr['data_arr'] = $data_arr;
			$return_arr['status'] = 'success';
            $return_arr['curr_stage_role'] = $curr_stage_role;

			//$return_arr['id_sufix'] = $tmp->id_sufix;
			//$return_arr['html'] = $change_assignment_html;
		}

		if ($post == false)
			return $return_arr;
		else
		{
			$hierachy = isset($this->current_client->functionality->cfty_keyword_hierarchy)?$this->current_client->functionality->cfty_keyword_hierarchy:'n';
			//$journal_id = $this->jnl_data->jnl_id;
			$where = array();
			/*if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
				$where = array(
					"kwdrl_inactive" => 'n');*/
            $Article_keywords = new \App\Models\Article_keywords();
			$article_keywords = $Article_keywords::get_article_keywords($article_id, false, false, $hierachy, $jnl_id, $where);

			$keywords = array();
			if (!empty($article_keywords))
			{
				foreach ($article_keywords as $keys)
				{
					$keywords[($keys->kwd_id)] = $keys->kwd_name;
				}
			}
			$return_arr['article_keywords'] = $keywords;
			//echo json_encode($return_arr);

        return $this->success('success', 200, $return_arr);
        }
    } catch (\exception $e) {
        return $this->failure('Failed', 500, $e);
    }
}

//*** convert old url to new in viewarticle ***/
public function convert_params_format(Request $request)
{
   try
        {
            $post_data=$request->all();
            parse_str($this->decrypt_data($post_data['url']), $_GET);
            $User=new \App\Models\User();
            if($post_data['url']!=null)
            {
                $article_id=isset($_GET['article_id']) ? $_GET['article_id'] : '';
                $flow_id=isset($_GET['status_id']) ? $_GET['status_id'] : '';
                $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
                if($article_id!=null&&$flow_id!=null)
                {
                    $verifydata=$this->checkValidRecord($article_id,$flow_id,$jnlcode);
                    if($verifydata==true)
                    {
                        $return_array['art_id']=$this->encrypt_data($article_id);
                        $return_array['flow_id']=$this->encrypt_data($flow_id);
                    }
                    else{
                        return  $this->warning('Failed', 200, "redirectdashboard");
                    }
                }
                return  $this->success('Success',200,$return_array);
            }

        }
        catch(\Exception $e)
        {
           return  $this->failure('Failed',500,$e);
        }
    }

    //Feature #1493   JPR-100 - Re-assigning Users on Articles  (save change assignment)
    public function save_stage_change_assignment(Request $request)
    {
        try
        {
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'article_flow_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'changerole'=> 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            if (!isset($post_data['article_id']) || !isset($post_data['usr']) || !isset($post_data['article_flow_id']) || !isset($post_data['changerole']) || $this->current_client->functionality->cfty_change_assignment == 'n')
            {
                $return_arr['status'] = 'failed';
                return $this->warning('Warning', 200, $return_arr);
            }
            $data = array();
            //$data['article_type'] = $article_type = $this->decrypt_data($search_data['article_type']);
            $data['article_id'] = $article_id = isset($post_data['article_id'])?$this->decrypt_data($post_data['article_id']):'';
            $data['aflw_id'] = $stage_id = isset($post_data['article_flow_id'])?$this->decrypt_data($post_data['article_flow_id']):'';
            $data['assignment'] = $assignment = $post_data['type'];
            $data['change_user'] = $old_user = isset($post_data['usr'])? $this->decrypt_data($post_data['usr']):'';
            $data['role'] = $role = isset($post_data['changerole'])?$post_data['changerole']:'';
            $jnlcode = isset($post_data['jnlcode'])?$this->decrypt_data($post_data['jnlcode']):'';
            $jnlid =  isset($post_data['jnl_id'])?$this->decrypt_data($post_data['jnl_id']):'';
            $existrecord =$this->checkValidRecord($article_id, $stage_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $this->current_user = $this->get_current_user_details();
            $art_record=Articles::get_single_record('art_artp_id','art_id='.$article_id);
            $data['article_type'] = $article_type =$art_record->art_artp_id;
            $select = 'jwf_tat_complete,jwf_role_id,aflw_usr_id,aflw_parent_flow_id,aflw_status,jwf_stage_type,jwf_role_id,art_id,art_status,artp_fwm_id,artp_id,aflw_id,jwf_assignment';
            //$article_details = Article_flow::get_stage_details('aflw_id='.$stage_id, $select);
            $article_details = Articles::get_article_details($select,'aflw_id='.$stage_id, null, true, false,null);
            $article_details=$article_details[0];

            $article_privilages = $this->article_privilages($article_details, $stage_id, $jnlcode);
            $privileged_user = $article_privilages['privilaged'];
            $isauthor = $article_privilages['author'];
            $isreviewer=$article_privilages['reviewer'];
            $user_allocated=$article_privilages['user_allocated'];
            if($isauthor==true || ($isreviewer==true && $user_allocated == false))
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }

            //CHECK USER HAING CHANGE ASSINMENT ACTION -- PERMISSION -- START
            $Authors = new \App\Models\Authors();
            $art_authors = $Authors::get_single_record('count(auth_id) as cnt','auth_art_id='.$article_id.' and auth_usr_id='.$this->current_user['user_id']);
            $article_privilages = array();
            if ($art_authors->cnt > 0)
            {
                $article_privilages['author'] = true;
            }
            $user_roles = $this->validate_user_journal($jnlcode, $this->current_user['user_id'], $article_type);
            $all_roles = Roles::get_all_records('role_id,role_name,role_assigned_role');
            $user_array = array();
            $user_array['user_roles'] = $user_roles;
            $user_array['article_id'] = $article_id;
            $user_array['all_roles'] = $all_roles;
            $user_array['article_privilages'] = $article_privilages;
            $user_array['jnl_id'] = $jnlid;
            $user_array['user_id'] = $this->current_user['user_id'];
            $user_roles = $this->get_article_user_roles($user_array);
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
            $article_details->artp_id = $article_type;
            $change_assignment = $this->change_assignment_permission($article_details, $user_roles, $review_flow);
            if ($change_assignment == false)
            {
                $return_arr['status'] = 'no_pri_failed';
                $return_arr['msg']=customTrans('viewarticle.ch_assignment_permission_false');
                return $this->warning('Warning', 200, $return_arr);
            }
            //CHECK USER HAING CHANGE ASSINMENT ACTION -- PERMISSION -- STOP
            $new_user = $this->decrypt_data($post_data['newuser']);

            //Article_flow::trans_start();
            $proxy_id = 0;
            if ($this->current_user['user_id'] !== $this->current_user['proxy_user_id'])
            {
                $proxy_id = $this->current_user['proxy_user_id'];
            }

            //CALCULATE DUE DATE -- START
            $today = date('Y-m-d H:i:s', time());
            $due_date = new \DateTime($today);

            // $due_date = $due_date->modify('+' . $article_details->jwf_tat_complete . ' days');
            // $due_date = $due_date->format('Y-m-d H:i:s');
            $due_date = $this->get_due_date_for_article($article_id, $article_details->jwf_tat_complete);
            //CALCULATE DUE DATE -- STOP
            //updation in article flow
            $update_arr = array(
                'aflw_usr_id' => $new_user,
                'aflw_change_assign' => 'y',
                'aflw_assigned_date' => $today,
                'aflw_accepted_date' => $today,
                'aflw_due_date' => $due_date,
            );

            $condition = 'aflw_id='.$stage_id;
            //insert in Change_assignment table
            $data_insert = array(
                'cag_art_id' => $article_id,
                'cag_aflw_id' => $stage_id,
                'cag_old_usr_id' => $old_user,
                'cag_new_usr_id' => $new_user,
                'cag_usr_role_id' => $role
                //'cag_user_article' => $change_user_article,
            );

            $mail_send = false;
            $notify_email = false;
            $User_articles=new \App\Models\User_articles();
            $User_articles_table = (new \App\Models\User_articles())->getTable();
            $Change_assignment=new \App\Models\Change_assignment();
            if ($assignment == 'article')
            {

                //delete old user from user article table
                $User_articles::delete_records('usra_art_id='.$article_id.' and usra_usr_id='.$old_user.' and usra_role_id='.$role, '', $this->current_user);

                //inser new user
                $sql = 'INSERT IGNORE into ' .$User_articles_table . ' (usra_art_id,usra_usr_id,usra_role_id,usra_aflw_id,	usra_posted_by,	usra_posted_date,usra_proxy_id,usra_operation) VALUES (' . $article_id . ',' . $new_user . ',' . $role . ',' . $stage_id . ',' . $this->current_user['user_id'] . ',"' . date('Y-m-d H:i:s') . '",' . $proxy_id . ',"i")';
                $User_articles::execute_query($sql);

                //change user from current article flow assignment
                $data_insert['cag_user_article'] = 'y';
                if (isset($post_data['change_user_allocation']) && $post_data['change_user_allocation']== true)
                {
                    Article_flow::update_record($update_arr, $condition, $this->current_user);
                    $mail_send = true;
                }
                $change_assign_id = $Change_assignment::insert_record($data_insert, $this->current_user);

                if (isset($post_data['postdata']))
                    $notify_email = true;
            }
            else //stage
            {
                //echo $article_details->jwf_tat_accept;die;

                $change_user_article = 'n';
                if (isset($post_data['change_user_allocation']) && $post_data['change_user_allocation']== true)//manage from user article table
                {
                    $change_user_article = 'y';

                    //delete old user
                    $User_articles::delete_records('usra_art_id='.$article_id.' and usra_usr_id='.$old_user.' and usra_role_id='.$role, '', $this->current_user);
                    //inser new user
                    $sql = 'INSERT IGNORE into ' . $User_articles_table . ' (usra_art_id,usra_usr_id,usra_role_id,usra_aflw_id,	usra_posted_by,	usra_posted_date,usra_proxy_id,usra_operation) VALUES (' . $article_id . ',' . $new_user . ',' . $role . ',' . $stage_id . ',' . $this->current_user['user_id'] . ',"' . date('Y-m-d H:i:s') . '",' . $proxy_id . ',"i")';
                    $User_articles::execute_query($sql);
                }
                $data_insert['cag_user_article'] = $change_user_article;
                //$update_arr['aflw_due_date'] = $due_date;
                Article_flow::update_record($update_arr, $condition, $this->current_user);
                $change_assign_id = $Change_assignment::insert_record($data_insert, $this->current_user);
            }

            if ($assignment == 'stage' || $mail_send == true || $notify_email == true)
            {

                $assign_email_log = array();
                if ($notify_email == true)
                {
                    $data['user_id'] = $new_user;
                    $data['role_id'] = $role;
                    $data['event_template'] = $post_data['postdata'];
                    $data['jnlcode'] = $jnlcode;
                    $data['jnlid'] = $jnlid ;
                    $data['core_role'] =isset($post_data['core_role'])?$this->decrypt_data($post_data['core_role']):'';
                    $data['role_name'] = isset($post_data['role_name'])?$this->decrypt_data($post_data['role_name']):'';
                    $data['jwf_stage_type']=isset($article_details->jwf_stage_type) ?$article_details->jwf_stage_type : '';
                    $sent_bactch_id = $this->send_change_assign_notify_email($data);
                    if ($sent_bactch_id != '')
                        $assign_email_log[] = $sent_bactch_id;

                    $data_update = array(
                        'cag_new_usr_esl_batch_id' => implode(',', $assign_email_log), //update later
                    );

                    $Change_assignment::update_record($data_update, 'cag_id='.$change_assign_id, $this->current_user);
                }

                if (isset($post_data['tmpl_assign_eml_chk']) && isset($post_data['tmpl_unassign_eml_chk']) && count($post_data['tmpl_assign_eml_chk']) > 0 && count($post_data['tmpl_unassign_eml_chk']) > 0)
                {
                    $assign_email_tmpls = $post_data['tmpl_assign_eml_chk'];
                    $unassign_email_tmpls = $post_data['tmpl_unassign_eml_chk'];
                    $assign_tmpl_evt = $post_data['assign_tmpl_evt'];
                    $unassign_tmpl_evt = $post_data['unassign_tmpl_evt'];

                    //Assign email templatesend email section
                    foreach ($assign_email_tmpls as $assign_tmpl)
                    {
                        $data['user_id'] = $new_user;
                        $data['tmpl_id'] = decrypt_link($assign_tmpl);
                        $sent_bactch_id = $this->send_change_assign_email($data,false,$assign_tmpl_evt,$jnlid,$jnlcode);
                        if ($sent_bactch_id != '')
                            $assign_email_log[] = $sent_bactch_id;
                    }

                    //unassign email templatesend email section
                    $unassign_email_log = array();
                    foreach ($unassign_email_tmpls as $assign_tmpl)
                    {
                        $data['user_id'] = $old_user;
                        $data['tmpl_id'] = decrypt_link($assign_tmpl);
                        $unassign_bactch_id = $this->send_change_assign_email($data,false,$unassign_tmpl_evt,$jnlid,$jnlcode);
                        if ($unassign_bactch_id != '')
                            $unassign_email_log[] = $unassign_bactch_id;
                    }

                    $data_update = array(
                        'cag_old_usr_esl_batch_id' => implode(',', $unassign_email_log), //update later
                        'cag_new_usr_esl_batch_id' => implode(',', $assign_email_log), //update later
                    );

                    $Change_assignment::update_record($data_update, 'cag_id='.$change_assign_id, $this->current_user);
                }
                if ($notify_email == false)
                {

                    $return_arr['msg_success'] =customTrans('viewarticle.succ_ch_assignment');
                    $return_arr['status'] = 'success';
                    $return_arr['msg'] = '';
                }
            }

            if ($notify_email == true || $assignment == 'article')
            {
                $return_arr['msg_success'] =customTrans('viewarticle.succ_ch_assignment');
                $return_arr['status'] = 'success';
                $return_arr['msg'] = '';

            }
            return  $this->success('Success',200,$return_arr);
        }
        catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }


    //Feature #1493   JPR-100 - Re-assigning Users on Articles  (send emails of assigned, assigned users)
	//Bug#2733 Assignment email not send
	public function send_change_assign_email($data,$stage_assignment = false,$evnt_tmpl = false,$jnl_id='',$jnlcode='')
	{
        $this->current_user = $this->get_current_user_details();
        $core_role=(isset($data['core_role']))?$data['core_role']:'';
        $role_name=(isset($data['role_name']))?$data['role_name']:'';
		$prefix = 'stage_etmp_';
		$email_template = array();
		if($evnt_tmpl == true)
		{
			$prefix = 'etmp_';
			$condition_field = 'ane_event_etmp_id';
		}
		else
		{
			$condition_field = 'ane_stage_etmp_id';
		}
		if($stage_assignment == false)
		{
            //TASK #10010 Change Assignment: Assign/Unassign email retains previous edits even after sending. Edits should clear and reset to the default template after each send.
            $condition=$condition_field.'='.$data['tmpl_id'].' and ane_art_id='. $data['article_id'].' and ane_status != 1 and ane_aflw_id='.$data['aflw_id'];
            $Article_notification_emails=new \App\Models\Article_notification_emails();
			$email_template = $Article_notification_emails::get_single_record(
				$condition_field.' as stage_etmp_id, ane_to as touser,ane_id, ane_cc as ' . $prefix . 'cc, ane_bcc as ' . $prefix . 'bcc, ane_subject as ' . $prefix . 'subject, ane_content as ' . $prefix . 'email_template, ane_cust_to as ' . $prefix . 'cust_to, ane_cust_cc as ' . $prefix . 'cust_cc, ane_cust_bcc as ' . $prefix . 'cust_bcc, ane_reply_to as reply_to',$condition);
			if(!empty($email_template) && isset($email_template->etmp_email_template))
			{
				//Assigned as stage email template to prevent no more changes in the library.
				$email_template->stage_etmp_email_template = $email_template->etmp_email_template;
			}
		}
		$saved_template = true;
		$sent_bactch_id = '';

		if (empty($email_template))
		{
			$saved_template = false;
			if($evnt_tmpl == true)
			{
                $Email_templates=new \App\Models\Email_templates();
				$email_template = $Email_templates::get_single_record('*, etmp_notification as touser, etmp_email_template AS stage_etmp_email_template', 	'etmp_id='.$data['tmpl_id']);
			}
			else
			{
                $Stage_email_templates=new \App\Models\Stage_email_templates();
			    $email_template = $Stage_email_templates::get_single_record('*, stage_etmp_to as touser, stage_etmp_content AS stage_etmp_email_template', 'stage_etmp_id='.$data['tmpl_id']);
			}
		}
        
		$redirect_base_url = URL::to('/');
        $jnl_criteria = "jnl_id ={$jnl_id}";
        $Journals = new \App\Models\Journals();
        $jrnl_grp_name = $Journals::get_single_record('jnl_standalone_group', $jnl_criteria);
        if ($jrnl_grp_name->jnl_standalone_group != null)
		{
			$redirect_base_url = $this->build_url_standalone($jrnl_grp_name);
		}
		//$article_url = $redirect_base_url . 'journal/' . $jnlcode . '/view-article'.'?' . encrypt_link('&article_id=' . $data['article_id'] . '&status_id=' . $data['aflw_id']);
        $article_url =  $redirect_base_url.'/'. $this->current_client->platform_type.'/'. $jnlcode . '/view-article?' . encrypt_link('&article_id=' . $data['article_id']. '&status_id=' .$data['aflw_id']);

		$sent_bactch_id='';
		if (!empty($email_template))
		{
			$email_data = new stdClass;
			$email_data->article_id = $data['article_id'];
			$email_data->user_id = $data['user_id'];
			$email_data->jnl_journal_code = $jnlcode;
			$email_data->artp_id = $data['article_type'];
			$email_data->jnl_id = $jnl_id;
			$email_data->aflw_id = $data['aflw_id'];
			$select = 'jwf_stage_type';
			$where = 'aflw_art_id='.$email_data->article_id.' and aflw_id='.$email_data->aflw_id;

			$current_status = Article_flow::get_generic_flow($select, $where);
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);


			$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;

			$email_data->email_templates_config = $this->email_templates_config();

			$email_data->ARTICLE_STATUS_LINK = $article_url;

			$reply_to = '';

			$send_mail_to = '';
			$send_mail_to_usr_ids = '';
			if ($email_template->touser == 'User')
			{
                $Users=new \App\Models\User();
				$usr_detail = $Users::get_single_record('usr_email','usr_id='.$data['user_id']);
				$send_mail_to = $usr_detail->usr_email;
				$send_mail_to_usr_ids = $data['user_id'];
			}
			elseif ($email_template->touser != 'Custom')
			{
				$cfty_retire_role = false;
				if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
				{
					$cfty_retire_role = true;
				}
				$send_mail_to_detail = $this->send_email_to($email_template->touser, $jnlcode, $data['article_type'], $data['article_id'],$cfty_retire_role);
				$send_mail_to = $send_mail_to_detail['email_ids'];
				$send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
			}
            $send_mail_to = trim($send_mail_to);
            $send_mail_to=str_replace(' ', '', $send_mail_to);
            $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
            $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);
			if ($send_mail_to != '' || $email_template->touser == 'Custom')
			{
				$email_data->user_email = $send_mail_to;
				$email_data->mail_recipient_ids = $send_mail_to_usr_ids;

				if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
				{
					$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
				}
				$email_data->join_config = $this->join_config();
				$email_data->join_dependency_config = $this->join_dependency_config();
                $User_to_journals = new \App\Models\User_to_journals();
				$email_data->all_user_roles = $User_to_journals::get_user_role_classification($data['article_id'], 'a');
				$email_data->user_role_tags = $this->user_role_tags();
				if ($saved_template == false)
				{
                      //reply_to start
                    $current_status = array();
                    $article_flow_table = (new \App\Models\Article_flow);
                    if((isset($data['article_id'])&&$data['article_id']!=null)&&(isset($data['aflw_id'])&&$data['aflw_id']!=null))
                    {
                    $select = 'jwf_stage_type,jwf_role_id';
                    $where ="aflw_art_id={$data['article_id']} AND aflw_id={$data['aflw_id']}";
                    $current_status = $article_flow_table::get_generic_flow($select, $where);
                    }
                      //reply_to end
                    $reply_to=$this->get_reply_to_email($jnl_id,$current_status);
				}
				elseif ($saved_template == true)
				{
					$reply_to = $email_template->reply_to;
				}
				if (!empty($reply_to))
					$email_data->reply_to = $reply_to;
				if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
					$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
				if (strpos($email_template->stage_etmp_email_template,"OPENING_PARAGRAPH") > 0)
				$email_template->stage_etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->stage_etmp_email_template);
				if($evnt_tmpl == true)
				{
					$email_data->status_link_blind_event = true;
				}
				$core_role=(isset($core_role))?$core_role:'';
				$email_data->core_role = $core_role;
				$core_role_name=(isset($role_name))?$role_name:'';
				$email_data->core_role_name = $core_role_name;
                $data = array(
                    'record' => $email_template,
                    'email_data' => $email_data,
                    'user_data' =>$this->current_user,
                    'column_prefix' =>$prefix,
                    'return_batch_id' =>true,
                );
                $sent_bactch_id = $this->notify_mail($data);
			}
		}
		return $sent_bactch_id;
	}


    //Feature #1493   JPR-100 - Re-assigning Users on Articles  (fetch the change assignment email templates  -- unassign,assign)
    public function get_stage_change_assignment_emails(Request $request)
    {
       try{
            $post_data=$request->all();
            $validator = Validator::make($request->all(), [
                'art' => 'required',
                'aflw_id' => 'required',
                'jnl_id' => 'required',
                'jnlcode' => 'required',
                'asmt'=> 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $return_arr = array(
                'status' => 'failed',
                'msg' => '',
            );
            $art_id = isset($post_data['art']) ?  $this->decrypt_data($post_data['art']) : '';
            $artflow_id = isset($post_data['aflw_id']) ?  $this->decrypt_data($post_data['aflw_id']) : '';
            $jnl_id = isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']) : '';
            $jnlcode = isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']) : '';
            $user_id = isset($post_data['usr']) ?  $this->decrypt_data($post_data['usr']) : '';
            $assignment = isset($post_data['asmt']) ?  $post_data['asmt'] : '';
            $change_user = isset($post_data['ch_user']) ?  $this->decrypt_data($post_data['ch_user']) : '';
            $role_id = isset($post_data['rle']) ?  $this->decrypt_data($post_data['rle']) : '';
            if ($user_id == '' || $artflow_id == '' || $role_id == '' || $art_id == '')
            {
                return $this->warning('Warning', 200, $return_arr);
            }
            $existrecord =$this->checkValidRecord($art_id, $artflow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            if ($this->current_client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y'
                    && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'n')
            {
                $select = 'aflw_usr_id  as usr_id,jwf_stage_name,jwf_role_id as role_id,role_name';
                // $where = "aflw_art_id = ".$art_id." AND jwf_stage_type = 'review' AND aflw_usr_id =".$user_id." AND aflw_status IN ('u','i','a')";
                $where = "aflw_art_id = ? AND jwf_stage_type = 'review' AND aflw_usr_id = ? AND aflw_status IN ('u','i','a')";
                $stage_assignment_revwr = Article_flow::get_article_flow_details($select, $where,condition_arr:[$art_id,$user_id]);
                if( !empty($stage_assignment_revwr) && isset($stage_assignment_revwr->usr_id))
                {
                    $array_data['user_id'] = $user_id;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['flag'] = true;
                    $array_data['article_id'] = $art_id;
                    $array_data['jnl_code'] = $jnlcode;
                    $array['salutation']=true;
                    $array['fullname_only']=true;
                    $selected_user_name = $this->get_user_display_name($array_data);
                    $return_data['status'] = 'warning_restrict';
                    $msg=customTrans('viewarticle.restrict_assign_due_currently_reviewing');
                    $return_data['msg']  =  str_replace('##user full name##', $selected_user_name,$msg);
                    return $this->warning('Warning', 200, $return_data);
                }
            }

            if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
            {

                $select = 'aflw_usr_id  as usr_id,jwf_stage_name,jwf_role_id as role_id,role_name';
                // $where = "aflw_art_id = {$art_id} and jwf_stage_type ='review' and aflw_usr_id = {$user_id}";
                $where = "aflw_art_id = ? and jwf_stage_type ='review' and aflw_usr_id = ?";
                $stage_assignment_revwr = Article_flow::get_article_flow_details($select, $where,condition_arr:[$art_id,$user_id]);
                $chk_revwr_as_prev_version = $this->check_privileged_user_as_reviewer($art_id,$user_id);

                if ((!empty($stage_assignment_revwr) && isset($stage_assignment_revwr->usr_id) )|| $chk_revwr_as_prev_version == true )
                {
                    $array_data['user_id'] = $user_id;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['flag'] = true;
                    $array_data['article_id'] = $art_id;
                    $array_data['jnl_code'] = $jnlcode;
                    $array['salutation']=true;
                    $array['fullname_only']=true;
                    $selected_user_name = $this->get_user_display_name($array_data);
                    $return_data['status'] = 'warning_restrict';
                    $msg=customTrans('viewarticle.restrict_assign_due_currently_reviewing');
                    $return_data['msg']  =  str_replace('##user full name##', $selected_user_name,$msg);
                    return $this->warning('Warning', 200, $return_data);
                }
            }
            // $result_artflow = Article_flow::get_single_record('aflw_jwf_id,aflw_usr_id,aflw_status', 'aflw_id='.$artflow_id);
            $result_artflow = Article_flow::get_single_record('aflw_jwf_id,aflw_usr_id,aflw_status', 'aflw_id= ?',binding_arr:[$artflow_id]);
            if (!isset($result_artflow->aflw_jwf_id))
            {
                return $this->warning('Warning', 200, $return_arr);
            }
            $Generic_flows = new \App\Models\Generic_flows();
            $result_stage = $Generic_flows::get_single_record('jwf_stage_name,jwf_role_id,jwf_assignment', 'jwf_id='.$result_artflow->aflw_jwf_id);
            $email_section = true;
            $event_notify_email = false;
            $article_allocation_checkbox = true;
            //$event_notify_email_details = '';
            if ($assignment == 'article')
            {
                $Roles = new \App\Models\Roles();
                // $role_det = $Roles::get_single_record('role_name','role_id='.$role_id);
                $role_det = $Roles::get_single_record('role_name','role_id= ?',binding_arr:[$role_id]);

                $temp_msg = ' Please complete the action';
                if ($result_stage->jwf_role_id != $role_id)
                {
                    $email_section = false;
                    $temp_msg = ' Please confirm';
                }

                $array_data['user_id'] = $change_user;
                $array_data['journal_id'] = $jnl_id;
                $array_data['flag'] = true;
                $array_data['article_id'] = $art_id;
                $array_data['jnl_code'] = $jnlcode;
                $array['salutation']=true;
                $array['fullname_only']=true;
                $tat_dates = $this->get_tat_dates($result_artflow->aflw_jwf_id);
                $users_unavailability = $this->get_users_unavailability($change_user, $tat_dates);
                $return_arr['change_users_availability']=($users_unavailability != null)?false:true;
                $change_username = $this->get_user_display_name($array_data);
                $array_data['user_id'] = $user_id;
                $users_unavailability = $this->get_users_unavailability($user_id, $tat_dates);
                $return_arr['current_users_availability']=($users_unavailability != null)?false:true;
                $usrname = $this->get_user_display_name($array_data);

                $title_html = 'You are changing the assignee for ' . $role_det->role_name . ' from ';
                $title_html_end='.  Please complete the action';
                //$title_html = '<h4>You are changing the assignee for ' . $role_det->role_name . ' from ' . $change_username . ' to ' . $usrname. '. ' . $temp_msg . ' </h4>';

                $question_label = str_replace('##STAGE_NAME##', $result_stage->jwf_stage_name, customTrans('viewarticle.change_stage_user'));
                $change_user_chekcbox = 'change_user_stage';
                $data_list['change_user_chekcbox']=$change_user_chekcbox;

                //alert email to allocated user for short list/invite
                if ($result_stage->jwf_assignment=="invitation" || $result_artflow->aflw_status == 'p')
                {
                    // $where = ' aflw_id =' . $artflow_id . ' and (FIND_array_intersect("' . $role_id . '",REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),\']\',"") , \'[\', "")) = 1 OR FIND_array_intersect("' . $role_id . '",REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),\']\',"") , \'[\', "")) = 1)';
                    $where = ' aflw_id = ? and (FIND_array_intersect(? ,REPLACE(REPLACE(REPLACE(jwf_parent_user_roles,\'"\',""),\']\',"") , \'[\', "")) = 1 OR FIND_array_intersect(? ,REPLACE(REPLACE(REPLACE(jwf_who_can_invite,\'"\',""),\']\',"") , \'[\', "")) = 1)';
                    $allocate_role_result = Article_flow::get_stage_details($where, 'count(aflw_id) AS cnt',wherearr:[$artflow_id,$role_id,$role_id]);
                    if ($allocate_role_result->cnt > 0)
                    {
                        $event_notify_email = true;
                    }
                }
            }
            else // stage
            {
                $User_articles = new \App\Models\User_articles();
                // $article_allocation = $User_articles::get_single_record('count(usra_id) as cnt', 'usra_art_id='.$art_id.' and usra_role_id='.$role_id);
                $article_allocation = $User_articles::get_single_record('count(usra_id) as cnt', 'usra_art_id= ? and usra_role_id= ?',binding_arr:[$art_id,$role_id]);

                if ($article_allocation->cnt == 0)
                    $article_allocation_checkbox = false;
                $array_data['user_id'] = $result_artflow->aflw_usr_id;
                $array_data['journal_id'] = $jnl_id;
                $array_data['flag'] = true;
                $array_data['article_id'] = $art_id;
                $array_data['jnl_code'] = $jnlcode;
                $array['salutation']=true;
                $array['fullname_only']=true;
                //$array['availability']=true;
                $change_username ='';  $users_unavailability ='';
                $tat_dates = $this->get_tat_dates($result_artflow->aflw_jwf_id);
                if($result_artflow->aflw_usr_id!='')
                $users_unavailability = $this->get_users_unavailability($result_artflow->aflw_usr_id, $tat_dates);
                $return_arr['change_users_availability']=($users_unavailability != null)?false:true;
                if($result_artflow->aflw_usr_id!='')
                $change_username = $this->get_user_display_name($array_data);

                $array_data['user_id'] = $user_id;
                $users_unavailability = $this->get_users_unavailability($user_id, $tat_dates);
                $return_arr['current_users_availability']=($users_unavailability != null)?false:true;
                $usrname = $this->get_user_display_name($array_data);
                if($change_username !='')
                $title_html = 'You are changing the assignee of ' . $result_stage->jwf_stage_name . ' from ';
                else
                $title_html = 'You are changing the assignee of ' . $result_stage->jwf_stage_name ;
                $title_html_end='.  Please complete the action';


                $question_label = customTrans('viewarticle.change_article_user');
                $change_user_chekcbox = 'change_user_article';
            }

            $data_list = array(
                //'email_templates_assign' => $email_templates_assign,
                //'email_templates_unassign' => $email_templates_unassign,
                'question_label' => $question_label,
                'change_user_chekcbox' => $change_user_chekcbox,
                'article_allocation_checkbox' => $article_allocation_checkbox,
                'stage' => $artflow_id,
                'role_id' => $role_id,
                'event_notify_email' => $event_notify_email,
                //'email_section' => $email_section,
                'assignment' => $assignment,
                //'event_notify_email_details' => $event_notify_email_details,
                'user_id' => $user_id,
                'art_id' => $art_id,
            );
            if ($result_artflow->aflw_status == 'a')
            {
                $select = 'stage_etmp_id,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_reminder_format,stage_etmp_remind_days,stage_etmp_remind_months,stage_etmp_remind_after,stage_etmp_to,stage_etmp_cust_to,stage_etmp_cc,stage_etmp_cust_cc,stage_etmp_bcc,stage_etmp_cust_bcc,stage_etmp_subject,stage_etmp_content,stage_etmp_journal_id,setr_id';
                $Stage_email_templates = new \App\Models\Stage_email_templates();
                $condition = "setr_jwf_id=".$result_artflow->aflw_jwf_id." AND stage_etmp_action='assigned'";
                $email_templates_assign = $Stage_email_templates::get_stage_email_tmpl_to_trigger($select, $condition);
               if(count($email_templates_assign)==0)
               {
                        $Email_templates = new \App\Models\Email_templates();
                    $event_based_condition = "etmp_name='change_assign_assignment'";
                    $event_based_email = $Email_templates::get_single_record('etmp_templete_name,etmp_id',$event_based_condition);
                    if(!empty($event_based_email))
                    {
                        $email_templates_assign[0] = $event_based_email;
                    }
                }

                $unassign_condition= "setr_jwf_id=".$result_artflow->aflw_jwf_id." AND stage_etmp_action='unassign_user'";

                $email_templates_unassign = $Stage_email_templates::get_stage_email_tmpl_to_trigger($select, $unassign_condition);
                if((count($email_templates_unassign)==0))
                {
                    $Email_templates = new \App\Models\Email_templates();
                    $event_based_condition ="etmp_name='change_assign_unassignment'";
                    $event_based_email = $Email_templates::get_single_record('etmp_templete_name,etmp_id',$event_based_condition);
                    if(!empty($event_based_email))
                    {
                        $email_templates_unassign[0] = $event_based_email;
                    }
                }
                $data_list['email_templates_assign'] = $email_templates_assign;
                $data_list['email_templates_unassign'] = $email_templates_unassign;
            }
            else
                $email_section = false;


            $data_list['email_section'] = $email_section;
            $data_list['confirm_pop_up'] = "";
            if ($this->current_client->functionality->cfty_disable_unnecessary_confirm == "y")
            {
                $data_list['confirm_pop_up'] = "y";
            }
            else
            {
                $data_list['confirm_pop_up'] = "n";
            }

            //$email_list_html = $this->load->view('view_article_modification/change_assignment_email_list', $data_list, true);
            $return_arr['data_list'] = $data_list;
            $return_arr['status'] = 'success';
            $return_arr['assignment'] = $assignment;
            //$return_arr['email_list_html'] = $email_list_html;
            $return_arr['email_title_html'] = $title_html;
            $return_arr['email_title_html_end'] = $title_html_end;
            $return_arr['currentuser'] = $change_username;
            $return_arr['changeuser'] = $usrname;
            return  $this->success('Success',200,$return_arr);
        } catch (\exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }

    //*** show details in more review popup starts */
    public function reopen_review_stage(Request $request)
    {
        try{
            $post_data=$request->all();
            $Email_templates = new \App\Models\Email_templates;
            $Roles=new \App\Models\Roles();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $article_id = $this->decrypt_data($post_data['art_id']);
            if (!empty($article_id))
            {
                $condition = "jwf_assignment='invitation' and aflw_art_id=".$article_id." and aflw_parent_flow_id IS null";
                if (!empty($post_data['art_flow_id']))
                    $condition.=' and aflw_id='.$this->decrypt_data($post_data['art_flow_id']);
                $jnlcode = isset($post_data['jnlcode'])?$post_data['jnlcode']:'';
                $order_by = "aflw_id";
                $review_stages_data = Article_flow::get_generic_flow('aflw_stage_min_users as min_review,aflw_stage_max_users as max_review,aflw_id,aflw_art_id,jwf_fwm_id,jwf_id,jwf_stage_name,jwf_stage_type,jwf_role_id,jwf_status_name', $condition, $order_by);
                $review_stages_data[0]->art_id=$article_id;
                $article_types =  Articles::get_single_record('art_artp_id,art_title', 'art_id=:article_id',null,'',null,array('article_id'=>$article_id));
                $review_stages_data[0]->artp_id = $article_types->art_artp_id;
                $Article_types = new \App\Models\Article_types();
                $article_types_data =  $Article_types::get_single_record('artp_fwm_id', 'artp_id=:artp_id',null,'',null,array('artp_id'=>$review_stages_data[0]->artp_id));
                $review_stages_data[0]->artp_fwm_id = $article_types_data->artp_fwm_id;
                $stage_name_arr = array();
                $review_stages = array();
                $article_privilages = $this->article_privilages($review_stages_data[0], $review_stages_data[0]->aflw_id, $jnlcode);
                $privileged_user = $article_privilages['privilaged'];
                $isauthor = $article_privilages['author'];
                $isreviewer=$article_privilages['reviewer'];
                $user_allocated=$article_privilages['user_allocated'];
                 /** more rw email template prview */

                   $more_rw_tmplt = $Email_templates::get_single_record('*', "etmp_name='article_more_reviewers_mail' and etmp_notification='User'");
                   if(!empty($more_rw_tmplt))
                {
                    $email_data = new stdClass;

                    $email_data->article_id = $article_id;
                    $email_data->article_title = $article_types->art_title;
                    $email_data->status_link_blind_event = TRUE;
					//$email_data->user_name = $user->usr_username;
					//$email_data->name = $user->usr_first_name . ' ' . $user->usr_last_name;
					//$email_data->user_email = $user->usr_email;
					//$email_data->user_id = $userid;

						//$core_role_details=$Roles::get_single_record('role_name,role_assigned_role',"role_id={$core_role_id}");
						$email_data->core_role=$post_data['core_role'];
						$email_data->core_role_name=$post_data['role_name'];


                        $email_data->artp_id = $article_types->art_artp_id;
						$email_data->jnl_id = $post_data['jnl_id'];
						$email_data->jnl_journal_code = $post_data['jnlcode'];
						$email_data->email_templates_config = $this->email_templates_config();
						if($this->current_client->functionality->cfty_article_authors_tag == 'y')
							$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
						$email_data->join_config = $this->join_config();
						$email_data->join_dependency_config = $this->join_dependency_config();
						$email_data->user_role_tags = $this->user_role_tags();

                        $cc_roles = array();
                        $bcc_roles = array();

                        $disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
                        if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
                        {
                        $role_cond = 'role_assigned_role NOT IN ("system", "author","reviewer")';
                        
                        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                        $review_flow = Config::get($workflow_config);
    
                        $reviewflow = $review_flow['author_submission'];
                        if(isset($reviewflow['stage_for']))
                        {
                                if($reviewflow['stage_for'] == 'review')
                                {
                                    $role_cond.=' and FIND_IN_SET("r", role_used_in)';
                                }
                                elseif($reviewflow['stage_for'] == 'manageproduction')
                                {
                                    $role_cond.=' and FIND_IN_SET("p", role_used_in)';
                                }
                        }
                        $user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                        if (!empty($user_roles))
                        {
                            foreach ($user_roles as $usrole)
                            {
                                $role_label = "All " . $usrole->role_name . "s";
                                $cc_roles[$usrole->role_name] = $role_label;
                                $bcc_roles[$usrole->role_name] = $role_label;
                            }
                        }
                    }
                        $cc_roles['Custom_cc'] = 'Specific email ID';
                        $bcc_roles['Custom_bcc'] = 'Specific email ID';
                    }
                    $reply_to=$this->get_reply_to_email($post_data['jnl_id'], $review_stages_data);
                /** more rw email template prview */

                if($isauthor==true || ($isreviewer==true && $user_allocated == false))
                {
                    return  $this->warning('Failed', 200, "redirectdashboard");
                }

                foreach ($review_stages_data as $stage)
                {
                    $stage_name = $stage->jwf_stage_name;

                    if (sizeof($stage_name_arr) <= 0)
                    {
                        array_push($stage_name_arr, $stage_name);
                        $review_stages[] = $stage;
                    }
                    else
                    {
                        if (!in_array($stage_name, $stage_name_arr))
                        {
                            array_push($stage_name_arr, $stage_name);
                            $review_stages[] = $stage;
                        }
                    }
                    $email_data->aflw_id=$stage->aflw_id;
                    $email_data->article_status_details_for_init[0] = array(
                        'ARTICLE_STATUS_NAME' => $stage->jwf_status_name,
                        'ARTICLE_STAGE_NAME' => $stage_name
                        );
                    if($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
						$email_data->cfty_unique_hide_control_label_email=$this->current_client->functionality->cfty_unique_hide_control_label_email;

                        $tmpl_subject = $more_rw_tmplt->etmp_subject;
						$tmpl_body = $more_rw_tmplt->etmp_email_template;

                        if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0)
						$tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);
                        //$email_data->mail_type = 'preview';
                        $body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->current_user,'',true, false);

						$subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject, $this->current_user,'', true);
                        preg_match_all('/##([^##]*)##/', $body, $matches);
                        $keys = $matches[1];

                        for ($i = 0; $i < count($keys); $i++) {
                            $element = $keys[$i];
                            if(!empty($element))
                            {
                            $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
                            $body = $tmpl_data;
                            }
                        }
                        $body = str_ireplace('##', '', $body);
                        $body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
                        $body=  str_ireplace('</button></button>','</button>', $body);

                        $more_rw_tmplt->etmp_subject = $subject;
                        $more_rw_tmplt->etmp_email_template = $body;
                        $stage->aflw_id = $this->encrypt_data($stage->aflw_id);
                        $stage->jwf_id = $this->encrypt_data($stage->jwf_id);
                        $stage->more_rw_email_tmplt = $more_rw_tmplt;
                }
                if (count($review_stages) == 1)
                {
                    $review_stages[0]->aflw_id = $this->decrypt_data($review_stages[0]->aflw_id);
                    $current_stage_cnt_info = Article_flow::get_single_record('count(*)as review_submit_cnt',"aflw_parent_flow_id={$review_stages[0]->aflw_id} and aflw_status='c' and aflw_art_id={$article_id}");
                    $review_stages[0]->total_review_comp = $current_stage_cnt_info->review_submit_cnt;
                    $review_stages[0]->aflw_id = $this->encrypt_data($review_stages[0]->aflw_id);

                    $review_stages[0]->aflw_art_id = $this->encrypt_data($review_stages[0]->aflw_art_id);
                    $review_stages[0]->jwf_fwm_id = $this->encrypt_data($review_stages[0]->jwf_fwm_id);
                    //$review_stages[0]->jwf_id = $this->encrypt_data($review_stages[0]->jwf_id);

                    $review_stage_details = $review_stages[0];
                    $data = array(
                        'review_stage_details' => $review_stage_details,
                        'show_resume_current_stage' => $this->current_client->functionality->cfty_resume_current_stage_after_review
                    );
                    $return_arr = array(
                        'status' => 'success',
                        'cc_roles' => $cc_roles,
                        'bcc_roles' => $bcc_roles,
                        'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
                        'type' => 'morereview',
                        'reply_to' =>$reply_to,
                        'message' => 'success',
                        'review_stage_details' => $review_stage_details,
                        'show_resume_current_stage'=>$this->current_client->functionality->cfty_resume_current_stage_after_review,
                        'multiple_stage'=>false,
                        'more_rw_email_tmplt' => $more_rw_tmplt);
                }
                elseif (count($review_stages) > 1)
                {
                    $return_arr = array(
                        'status' => 'success',
                        'cc_roles' => $cc_roles,
                        'bcc_roles' => $bcc_roles,
                        'reply_to' => $reply_to,
                        'type' => 'reviewstages',
                        'message' => 'success',
                        'review_stages' => $review_stages,
                        'review_select_title'=>customTrans('viewarticle.review_select_title'),
                        'select_modal_title'=>customTrans('viewarticle.select_modal_title'),
                        'multiple_stage'=>true,
                        'show_resume_current_stage'=>$this->current_client->functionality->cfty_resume_current_stage_after_review
                    );
                }
            }
            //echo json_encode($return_arr);
            return  $this->success('Success',200,$return_arr);
        } catch (\exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    //*** show details in more review popup ends */

        public function edit_publication_art_type(Request $request)
        {
            try
            {
                $current_user = $this->get_current_user_details();
                $post_data = $request->all();

                $validator = Validator::make($post_data, [
                'article_id' => 'required',
                'publish_type' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',422);
                }

                $article_id = decrypt_link($request->article_id);
                $publish_art_type = decrypt_link($request->publish_type);

                if ($article_id != '' && $publish_art_type != '')
                {
                    $Articles = new \App\Models\Articles();
                    $result = $Articles::update_record(['art_published_article_type' => $publish_art_type],'art_id = '.$article_id, $current_user, '', 'p');
                    if($result)
                    {
                        $return_arr['status'] = 'success';
                        return  $this->success('Success',200,$return_arr);
                    }
                    else
                    {
                        $return_arr['status'] = 'failed';
                        return $this->warning('Failed', 200, $return_arr);
                    }

                }
                $return_arr['status'] = 'failed';
                return $this->warning('Failed', 200, $return_arr);

            } catch (\exception $e) {
                return $this->failure('Failed', 200, $e);
            }
        }
        public function edit_art_submitted_author(Request $request)
        {
            try
            {
                $current_user = $this->get_current_user_details();
                $post_data = $request->all();
                $validator = Validator::make($post_data, [
                'article_id' => 'required',
                'auth_user_id' => 'required',
                ]);
                if ($validator->fails()) {
                    return $this->failure('error',422);
                }
            $article_id = decrypt_link($request->article_id);
            $selected_author = decrypt_link($request->auth_user_id);
            $article_flow_id = decrypt_link($request->article_flow_id);
            $jnl_id = decrypt_link($request->jnl_id);
            if ($article_id != '' && $selected_author != '')
            {
                if($article_flow_id!='')
                {
                $articleFlow = DB::select("
                        SELECT 
                            jowf.jwf_role_id,jowf.jwf_id,aflw.aflw_jwf_id,
                            art.art_submitted_by,aflw.aflw_status
                        FROM rvw_article_flow AS aflw
                        LEFT JOIN rvw_journal_workflows AS jowf
                            ON aflw.aflw_jwf_id = jowf.jwf_id
                        LEFT JOIN rvw_articles AS art
                            ON art.art_id = aflw.aflw_art_id
                        WHERE art.art_id = :art_id 
                        AND aflw.aflw_id = :aflw_id
                    ", ['art_id' => $article_id, 'aflw_id' => $article_flow_id]);
                $flow_role = Roles::find($articleFlow[0]->jwf_role_id)?->role_assigned_role;
                $change_submitted_by = [
                                    'flow_role'   => $flow_role,
                                    'aflw_status' => $articleFlow[0]->aflw_status,
                                    'aflw_id' => $article_flow_id,
                                    'workflo_flow_id' => $articleFlow[0]->jwf_id,
                                    'aflw_jwf_id' => $articleFlow[0]->aflw_jwf_id,
                                    'new_user_id' => $selected_author,
                                    'old_user_id' => $articleFlow[0]->art_submitted_by,
                                    'article_id'  => $article_id,
                                    'jnl_id'      => $jnl_id
                                ];
                $this->change_submitted_by_in_article($change_submitted_by);
                }
                $Articles = new \App\Models\Articles();
                $result = $Articles::update_record(array('art_submitted_by' => $selected_author,'art_merge_date' => null,), 'art_id = '.$article_id, $current_user, '', 's');

                if($result)
                {
                    $return_arr['status'] = 'success';
                    return  $this->success('Success',200,$return_arr);
                }
                else
                {
                    $return_arr['status'] = 'failed';
                    return $this->warning('Failed', 200, $return_arr);
                }
            }

            } catch (\exception $e) {
                return $this->failure('Failed', 200, $e);
            }
        }
        public function add_article_to_issue(Request $request)
        {
            try
            {
                $validator = Validator::make($request->all(), [
                    'iss_id' => 'required',
                    'art_id' => 'required',
                    'jnl_code' => 'required',
                    'role_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }

                $current_user = $this->get_current_user_details();

                //Get neccessary ids
                $result = NUll;

                $post_data  = $request->all();
                $iss_id = decrypt_link($post_data['iss_id']);
                $art_id = decrypt_link($post_data['art_id']);
                $jnl_code = decrypt_link($post_data['jnl_code']);
                $platform_data = $this->platform_basic_settings_data($jnl_code);
                $jnl_id = $platform_data->jnl_id;
                $role_id = decrypt_link($post_data['role_id']);
                $today = date('Y-m-d H:i:s', time());

                //Code for validation before change issue.
                $current_issue_data = array();
                $issue_data = array();
                if(isset($iss_id))
                {
                    $criteria = "iss_id = '$iss_id'";
                    $issue_data = Issues::get_single_record("iss_id,iss_title,iss_status", $criteria);
                    if(!empty($issue_data) && $issue_data->iss_status == 'c')
                    {
                        $return_arr['msg'] = 'issue_closed';
                        return  $this->warning('Failed', 200, $return_arr);
                    }
                }
                if(isset($art_id))
                {
                    $issue_record = Issue_management::get_single_record('ism_id,ism_iss_id','ism_art_id='.$art_id);
                    if($issue_record)
                    {
                        $criteria = "iss_id = '$issue_record->ism_iss_id'";
                        $current_issue_data = Issues::get_single_record("iss_id,iss_status", $criteria);
                        if(!empty($current_issue_data) && $current_issue_data->iss_status == 'c')
                        {
                            $return_arr['msg'] = 'current_issue_closed';
                            return  $this->warning('Failed', 200, $return_arr);
                        }
                    }  
                }   
                if(isset($art_id))
                {
                    if(isset($iss_id))
                    {
                        $pdf_pages = $this->issue_management_page_count($art_id,$jnl_code);
                        $data = array(
                            'ism_art_page_cnt' => $pdf_pages,
                            // 'ism_art_page_cnt' => 4,
                            'ism_iss_id' =>  $iss_id,
                            'ism_art_id' =>  $art_id,
                            'ism_order'  =>  1
                        );
                        $issue_record = Issue_management::get_single_record('ism_id','ism_art_id='.$art_id);
                        if(!isset($issue_record))
                        {
                            $result = Issue_management::insert_record($data, $current_user);
                        }
                        else
                        {
                            $result = Issue_management::update_record($data,'ism_art_id='.$art_id, $current_user);
                        }
                        $article_up = Articles::update_record(array('art_publication_issue'=>$iss_id),'art_id='.$art_id, $current_user);
                        $return_arr = $this->get_all_issue_mng_data_by_article_id($art_id, $jnl_id, $role_id);

                    }
                    else
                    {
                        $result = Issue_management::delete_records('ism_art_id='.$art_id);
                        $article_up = Articles::update_record(array('art_publication_issue'=>''),'art_id='.$art_id, $current_user);
                        $return_arr = $this->get_all_issue_mng_data_by_article_id($art_id, $jnl_id, $role_id);
                    }
                    $special_issue = $is_invited_art =false;
                    $article_record = Articles::get_single_record('art_publication_issue,art_stub','art_id='.$art_id);
                    if((isset($article_record->art_publication_issue) && !empty($article_record->art_publication_issue)) && (isset($return_arr['assigned_issue_data']['hardend_date']) && !empty($return_arr['assigned_issue_data']['hardend_date'])))
                    {
                        $special_issue = true;
                    }
                    if ($article_record->art_stub != 'n') //show icon for invited article
                         $is_invited_art = true;
                    $art_title = $this->get_article_display_name($art_id, $jnl_code, true, $special_issue, $is_invited_art);
                    $return_arr['art_title'] = $art_title;
                    $return_arr['status'] = 'success';
                    return  $this->success('Success', 200, $return_arr);
                }
                return  $this->failure('Failed', 200);
                
            } catch (\Exception $e) {
                return  $this->failure('Failed', 500, $e);
            }
        }
        public function show_user_list(Request $request)
        {
            try
            {
                $validator = Validator::make($request->all(), [
                    'art_id' => 'required',
                    'jnl_code' => 'required'
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }
                $return_arr['status'] = false;
                $post_data = $request->all();
                if (isset($post_data))
                {
                    $art_id    = decrypt_link($post_data['art_id']);
                    $jnl_code  = decrypt_link($post_data['jnl_code']);
                    $data	= array();
                    //get blinded users
                    $blinded_users = $this->get_blinded_users($jnl_code, $art_id);
                    $results = array();
                    if(!empty($blinded_users))
                    {
                        foreach ($blinded_users as $usr)
                        {
                            $results[] = array(
                                'id' => $usr->usr_id,
                                'text' => $usr->user . '(' .$usr->roles . ')');
                        }
                    }

                // $html_content = $this->load->view('view_article_modification/templates/tmpl_blind_user_modal_content', $data, true);

                    $return_arr = array(
                        'status' => 'success',
                        'art_id' => encrypt_link($art_id),
                        'blinded_usr_details' => $results
                    );
                return  $this->success('Success', 200, $return_arr);
                }
            } catch (\Exception $e) {
                return  $this->failure('Failed', 500, $e);
            }
        }
        public function get_users_to_blind_article(Request $request)
        {
            try
            {
                $validator = Validator::make($request->all(), [
                    'search_key' => 'required',
                    'art_id' => 'required',
                    'jnl_code' => 'required',
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }
                $post_data = $request->all();
                $results = array();
                if (!empty($post_data['search_key']))
                {
                    $post_data_search = htmlspecialchars($post_data['search_key'], ENT_QUOTES);
                    $art_id = decrypt_link($post_data['art_id']);
                    $jnl_code = decrypt_link($post_data['jnl_code']);
                    $all_users = $this->get_all_users($post_data_search,$art_id,'',$jnl_code);
                    if(!empty($all_users))
                    {
                        foreach ($all_users as $usr)
                        {
                            $results[] = array(
                                'id' => $usr->usr_id,
                                'text' => $usr->user . '(' .$usr->roles . ')');
                        }
                    }

                    $return_arr['user_to_blind'] =  $results;
                    return  $this->success('Success', 200, $return_arr);
                }
            } catch (\Exception $e) {
                return  $this->failure('Failed', 500, $e);
            }
        }
        public function save_blind_user_list(Request $request)
        {
            try
            {
                $Blind_user_articles = new \App\Models\Blind_user_articles();
                $Blind_user_articles_table = ($Blind_user_articles)->getTable();

                $post_data = $request->all();
                $art_id = decrypt_link($post_data['art_id']);
                $user_data = $current_user = $this->get_current_user_details();
                if(!empty($post_data['blind_usr']))
                {
                    $jnlcode = $post_data['jnlcode'];
                    $platform_data = $this->platform_basic_settings_data($jnlcode);
                    $journal_id = $platform_data->jnl_id;
                    $blind_user_ids = array();
                    foreach($post_data['blind_usr'] as $data)
                    {
                        if($data['value'] != '')
                        {
                            $blind_user_ids[] = decrypt_link($data['value']);
                        }
                    }
                    $blind_user_ids = json_encode($blind_user_ids);
                    $blind_usr_records = $Blind_user_articles::get_all_records('bau_id,bau_art_id,bau_jnl_id,bau_usr_ids','bau_art_id = '. $art_id);
                    $bind_user_arr = array(
                        'bau_art_id' => $art_id,
                        'bau_jnl_id' => $journal_id,
                        'bau_usr_ids' => $blind_user_ids
                    );
                    if(count($blind_usr_records)>0)
                    {
                        $update_condition =  'bau_art_id = '.$art_id;
                        $Blind_user_articles::update_record($bind_user_arr,$update_condition,$user_data);
                        $return_arr['msg'] = 'Blind user list for the article has been updated';
                    }
                    else{
                        $Blind_user_articles::insert_record($bind_user_arr,$user_data);
                        $return_arr['msg'] = 'Blind user list for the article has been added';
                    }
                    //previous value true.
                    $return_arr['data'] = $this->get_blinded_users($jnlcode,$art_id,true);
                    $return_arr['status'] = 'success';
                }
                else
                {
                    $delete_stat = $Blind_user_articles::delete_records('bau_art_id='.$art_id);
                    if($delete_stat == true){
                    //$return_arr['data'] = '<span id="span_userList"><a class="text-light add_userList" data-artid="'.encrypt_link($art_id).'">Select user</a></span>';
                    $return_arr['data'] = [];
                    $return_arr['msg'] = 'Blind user list for the article has been deleted';
                    $return_arr['status'] = 'success';
                    }else{
                        $return_arr['status'] = 'validation_error';
                        $return_arr['msg'] = 'Please select a user to blind article.';
                    }
                }
                $return_arr['art_id'] = encrypt_link($art_id);
                //$return_arr['results'] =  $results;
                return  $this->success('Success', 200, $return_arr);
            } catch (\Exception $e) {

                return  $this->failure('Failed', 500, $e);
            }
        }


    //*** show unassign & uninvite emails if exists while clicking the proceed to stage button in review starts */
    public function return_toholded_stage(Request $request)
	{
       try{
            $current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($post_data, [
            'art_id' => 'required',
            'art_flow_id' => 'required',
            'jnl_id'=> 'required',
            'template'=>'required'

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $return_arr=array();
            $current_stage_id = isset($post_data['art_flow_id']) ?$this->decrypt_data($post_data['art_flow_id']):'';
            $user_id = isset($post_data['user_id']) ? $post_data['user_id'] : '';
            $tmpl_id = isset($post_data['tmpl_id']) ? decrypt_link($post_data['tmpl_id']) : '';
            $template_view = $post_data['view'];
            $template_action = isset($post_data['template']) ? decrypt_link($post_data['template']):'';
            $event_based = (isset($post_data['event_based'])) ? $post_data['event_based'] : false;
            $article_id=isset($post_data['art_id']) ? $this->decrypt_data($post_data['art_id']) : '';
            $jnl_id=isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']) : '';
            $hold = isset($post_data['hold']) ? $post_data['hold'] : '';
            $usr_ids = $user_id;

            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,aflw_deeplink_token,aflw_usr_id,jwf_child_stages';
            $condition = "aflw_art_id=:aflw_art_id";
            $condition_arr=array(
                'aflw_art_id' => $article_id,
            );
            $article_details = Articles::get_article_details($select, $condition,null,false,false,null,$condition_arr);
           // print_r($article_details); die;
            $article_details = $article_details[0];
            $article_id = $article_details->art_id;
			$article_details->TASK_DUE_DATE = $this->get_due_date_for_article($article_id, $article_details->jwf_tat_accept);
            $remaining_days = Carbon::parse($article_details->TASK_DUE_DATE)->diffInDays(Carbon::now(), false);
            $article_details->TASK_REMAINING_DAYS = $remaining_days > 0 ?  $remaining_days : 0;
            $all_templates = array();
            if ($event_based == false)
            {
				if ($template_action == 'unassign' || $template_action == 'unassign-reviewer' || $template_action == 'uninvite')
				{
					$tmp_act = 'unassign_user';
					if ($template_action == 'uninvite')
						$tmp_act = 'uninvite_user';

					$condition = "stage_etmp_stage_type='{$article_details->jwf_stage_type}' and setr_jwf_id='{$article_details->jwf_id}' and stage_etmp_action='{$tmp_act}'";

					if ($user_id == '' || $user_id == null)
					{
						$accepted_child = Article_flow::get_all_records('aflw_usr_id', 'aflw_parent_flow_id =' . $current_stage_id . ' AND aflw_status IN ("a","i")');

						if (!empty($accepted_child))
						{
							$user_id = $this->get_column_array($accepted_child, 'aflw_usr_id');
							//array_walk($condition, $callback)
							array_walk($user_id, function(&$value, $key)
							{
								$value = encrypt_link($value);
							});
							$user_id = join(',', $user_id);
						}
					}
				}
				else
				{
					$condition = "stage_etmp_stage_type='{$article_details->jwf_stage_type}' and setr_jwf_id='{$article_details->jwf_id}' and stage_etmp_action='assigned'";
				}

				if ($template_action == 'review_resubmit' )
				{
					$condition = "stage_etmp_stage_type='{$article_details->jwf_stage_type}' and setr_jwf_id='{$article_details->jwf_id}' and stage_etmp_action='review_resubmit'";
				}
				$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);

				$reviewflow = $review_flow[$article_details->jwf_stage_type];
				$invitation_id = isset($post_data['invite_email_id']) ? $post_data['invite_email_id'] : '';

				$enable_priority_userinvitation_email = false;
				if (isset($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority) && ($this->current_client->functionality->cfty_enable_userbased_alternativereviewer_priority == 'y' ) || (isset($this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority) && $this->current_client->functionality->cfty_enable_articlebased_alternativereviewer_priority == 'y'))
				{
					$enable_priority_userinvitation_email = true;
				}

                $Stage_email_templates = new \App\Models\Stage_email_templates();
				if ($invitation_id != "" && $template_action == 'invitation' && $enable_priority_userinvitation_email == true)
				{
					$Article_autoinvitation_emails = new \App\Models\Article_autoinvitation_emails();
					$condition_autoinvited ='aae_id='.$this->decrypt_data($invitation_id);

					$template = $Article_autoinvitation_emails::get_all_records('aae_to as stage_etmp_to,aae_cc as 	stage_etmp_cc,aae_bcc as stage_etmp_bcc,aae_subject as stage_etmp_subject,aae_content as stage_etmp_content,aae_cust_to as stage_etmp_cust_to,aae_cust_cc as stage_etmp_cust_cc,aae_cust_bcc as stage_etmp_cust_bcc,aae_stage_etmp_id as stage_etmp_id,aae_template_name as stage_etmp_name', $condition_autoinvited);

				    if (empty($template))
					{
						if ($tmpl_id != "")
						{
							$condition.='stage_etmp_id='.$tmpl_id;
						}
						$template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
					}
				}
				else
				{
				if ($tmpl_id != "")
				{
					$condition.='stage_etmp_id='.$tmpl_id;
				}
				$template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
					}
				if (!empty($template) && !$template->isEmpty())
				{
                    $all_templates = $template;
					$template = $template[0];
				}

			}
			else
			{
                $Email_templates = new \App\Models\Email_templates();
				$template = $Email_templates::get_single_record('*',"etmp_name={$template_action} and etmp_notification='User'");

				if ($template != null)
				{
					/*$template->stage_etmp_to = $template->etmp_notification;
					$template->stage_etmp_subject = $template->etmp_subject;
					$template->stage_etmp_content = $template->etmp_email_template;
					$template->stage_etmp_subject = $template->etmp_subject;
					$template->stage_etmp_cc = $template->etmp_cc;
					$template->stage_etmp_bcc = $template->etmp_bcc;
					$template->stage_etmp_cust_cc = $template->etmp_cust_cc;
					$template->stage_etmp_cust_bcc = $template->etmp_cust_bcc;*/
				}
			}
			$Users = new \App\Models\User();
			if (!empty($user_id))
			{
				$user_ids = explode(',', $user_id);
				$reviewer = new \stdClass();
				$preview_recipient = false;
				$replace_all_tags = true;
				$user_info = '';
				//$this->load->library('user');
				//if($template_view == 'n')
				//{

				if (count($user_ids) == 1 && !empty($template) && isset($template->stage_etmp_to))
				{
                    if (!empty($template))
					{
						if ($template->stage_etmp_to == 'User')
						{
							$preview_recipient = true;
						}
					}
					$user_id = $this->decrypt_data($user_ids[0]);
					$reviewer = $Users::get_single_record('*', 'usr_id='.$user_id);
					$reviewer->user_titles = $this->UserConfigdata('titles')['titles'];
					$reviewer->modal_title = 'Email preview';
                    //#431 Not showing user middle name in adhoc email popup
                    //$reviewer->full_name = $this->get_user_display_name($user_id,'','','','', '','','',true,'','',true);

                    $array_data['user_id'] = $user_id;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['flag'] = true;
                    $array_data['article_id'] = $article_id;
                    // $array_data['jnl_code'] = $jnlcode;
                    $reviewer->full_name = $this->get_user_display_name($array_data);
                    $return_arr['reviewer']=$reviewer;
					//$user_info = $this->load->view('view_article/templates/tmpl_reviewer_info', $reviewer, true);
				}
				else
				{
					//$replace_all_tags = false;
					//$user_info = '<div class="col-lg-offset-2">';
                    $user_array = array();
					foreach ($user_ids as $u_id)
					{
                        $condition='usr_id='.decrypt_link($u_id);
						$user = $Users::get_single_record('usr_title,usr_first_name,usr_last_name,usr_email',$condition);
                        $user_array[]=$user;
						//$user_info .= $this->load->view('view_article/templates/tmpl_unassign_user_info', $user, true);
					}
                    $return_arr['user_array']=$user_array;
					//$user_info .= '</div><br/>';
				}
				//}

				if ($template != null)
				{

					//$this->load->helper('string');
					$update_deeplink = false;
					$link = $accept_link = $reject_link = '';
					if (count($user_ids) == 1 && !empty($reviewer) && isset($reviewer->usr_status))
					{
						if ($reviewer->usr_status == 'w')
						{
							if (!empty($reviewer->usr_deeplink_token))
							{
								$aflw_deeplink_token = $reviewer->usr_deeplink_token;
								if ($article_details->aflw_deeplink_token != $reviewer->usr_deeplink_token)
								{
									$update_deeplink = true;
								}
							}
							else
							{
                                $randomString = Str::random(20);
                                $aflw_deeplink_token = $data['usr_deeplink_token'] =  $randomString;
								//$aflw_deeplink_token = random_string('alnum', 16);
								$Users::update_record(array(
									'usr_deeplink_token' => $aflw_deeplink_token),'usr_id='.$reviewer->usr_id);
								$update_deeplink = true;
							}
						}
						else
						{
							if ($article_details->aflw_deeplink_token == null || $article_details->aflw_deeplink_token == '')
							{
								$update_deeplink = true;
                                $aflw_deeplink_token = Str::random(20);
								//$aflw_deeplink_token = random_string('alnum', 16);
							}
							else
							{
								$aflw_deeplink_token = $article_details->aflw_deeplink_token;
							}
						}

						$condition = 'aflw_parent_flow_id='.$current_stage_id.' and aflw_usr_id='.$user_id;

						$get_flow_rcrd = Article_flow::get_single_record('aflw_id', $condition);
						if (!empty($get_flow_rcrd))
						{
							$article_details->aflw_id = $current_stage_id = $get_flow_rcrd->aflw_id;
						}

						if ($update_deeplink == true && $article_details->aflw_status !== 'd')
						{
							Article_flow::update_record(array(
								'aflw_deeplink_token' => $aflw_deeplink_token), 'aflw_id='.$current_stage_id);
						}



						//$link = base_url() . 'journal/' . $this->jnl_data->jnl_journal_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&article_flow_id=' . $article_details->aflw_id);
						//$accept_link = base_url('journal/' . $this->jnl_data->jnl_journal_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&user_role=reviewer'));

                        //#581 hide terms & conditions popup for reviewers on decline invitation
                        //$reject_link = base_url('journal/' . $this->jnl_data->jnl_journal_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide'));
					}



					// 2.1 if templates found,generate email data
					/*$email_data = new stdClass;
					$email_data->article_id = $article_id;
					if ($preview_recipient == true)
					{
						$email_data->CONFIRMATION_URL = $link;
						$email_data->DIRECT_ACCEPT = $accept_link;
						$email_data->DIRECT_REJECT = $reject_link;
						$email_data->user_name = $reviewer->usr_username;
						$email_data->name = $reviewer->usr_first_name . ' ' . $reviewer->usr_last_name;
						$email_data->user_email = $reviewer->usr_email;
						$email_data->user_id = $user_id;
					}

					if ($template->stage_etmp_to == 'User' && $preview_recipient == false)
					{
						$email_data->replace_email_link_tags = true;
					}

					$email_data->aflw_id = $article_details->aflw_id;
					$select = 'jwf_stage_type';
					$where = 'aflw_art_id='.$email_data->article_id.' and aflw_id='.$email_data->aflw_id;

					$current_status = Article_flow::get_generic_flow($select, $where);

                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow  = Config::get($workflow_config);
                    $User_to_journals = new \App\Models\User_to_journals();
					$email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_id, 'a');

                    $email_data->artp_id = $article_details->art_artp_id;
					$email_data->jnl_id = $this->jnl_data->jnl_id;
					$email_data->jnl_journal_code = $this->jnl_data->jnl_journal_code;
					$email_data->email_templates_config = $this->workflow->email_templates_config;
					if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
						$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
					$email_data->join_config = $this->workflow->join_config;
					$email_data->join_dependency_config = $this->workflow->join_dependency_config;
					$email_data->user_role_tags = $this->workflow->user_role_tags;
					if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
						$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
					//				$this->sendemail->notify_mail($template, $email_data, $load, $user_data, 'stage_etmp_');
					// clearing user_email after each mail send, to avoid merging on "custom to"
					$email_data->user_email = '';
					//				}
					$tmpl_subject = $template->stage_etmp_subject;
					$tmpl_body = $template->stage_etmp_content;
					//$this->load->library('user');
					//$user_titles = $this->user->titles;
                    $user_titles = $this->UserConfigdata('titles')['titles'];
					//since due_date get only after send : calculate for preview
					$email_data->article_status_details_for_init[0] = array(
						'ARTICLE_STATUS_NAME' => $article_details->jwf_status_name,
						'ARTICLE_STAGE_NAME' => $article_details->jwf_stage_name,
						'TASK_DUE_DATE' => $article_details->TASK_DUE_DATE,
						'TASK_REMAINING_DAYS' => $article_details->TASK_REMAINING_DAYS
					);
					if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0)
				$tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);

				if ($template_action == 'reopen_review' ){
					$replace_all_tags = false;
				}
				$body = $this->sendemail->generate_email_data_from_keys($email_data, $tmpl_body, $load, $this->current_user, $user_titles, $preview_recipient, $replace_all_tags);
					$subject = $this->sendemail->generate_email_data_from_keys($email_data, $tmpl_subject, $load, $this->current_user, $user_titles, $preview_recipient);
					//bug with link tags DIRECT_ACCEPT, DIRECT_REJECT, CONFIRMATION_URL if multiple user invitation
					if ($template->stage_etmp_to != 'User')
					{
						$body = str_ireplace('##CONFIRMATION_URL##', '', $body);
						$body = str_ireplace('##DIRECT_ACCEPT##', '', $body);
						$body = str_ireplace('##DIRECT_REJECT##', '', $body);
					}
					$reply_to = '';
					if (isset($this->current_client->email_settings['reply_to_email']) && $this->current_client->email_settings['reply_to_email'] != '')
					{
						$reply_to = $this->current_client->email_settings['reply_to_email'];
					}
					if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y")
					{
						if ($this->jnl_data->jset_reply_to_email != "" && $this->jnl_data->jset_reply_to_email != null)
							$reply_to = $this->jnl_data->jset_reply_to_email;
					}
					if(isset($review_flow[$current_status[0]->jwf_stage_type]['stage_for']) && $review_flow[$current_status[0]->jwf_stage_type]['stage_for'] == 'manageproduction')
					{
						if (isset($this->jnl_data->jset_reply_to_email_traction) && $this->jnl_data->jset_reply_to_email_traction != "" && $this->jnl_data->jset_reply_to_email_traction != null)
							$reply_to = $this->jnl_data->jset_reply_to_email_traction;
					}
					//Bug #1809 : JPR-260 Remove options for cc and bcc roles in invitation email
					$to_cc_arr = json_decode($template->stage_etmp_cc);
					$to_bcc_arr = json_decode($template->stage_etmp_bcc);
					$cc_bcc_roles = array();
					$disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
					if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
					{
					$roles_condition = null;
					$role_cond = 'role_assigned_role NOT IN ("system", "author")';
					if ($event_based == false)
					{
						if(isset($reviewflow['stage_for']))
						{
							 if($reviewflow['stage_for'] == 'review')
								 $role_cond.=' and FIND_IN_SET("r", role_used_in)';
							 elseif($reviewflow['stage_for'] == 'manageproduction')
								 $role_cond.=' and FIND_IN_SET("p", role_used_in)';
						}
						//$roles_condition = 'role_assigned_role IN("' . implode('","', privileged_user_roles()) . '")';
					}
                    $Roles = new \App\Models\Roles();
					$user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
					if (!empty($user_roles))
					{
						foreach ($user_roles as $usrole)
						{
							$role_label = "All " . $usrole->role_name . "s";
							$cc_bcc_roles[$usrole->role_name] = $role_label;
						}
					}
					}
					$cc_bcc_roles['Custom'] = 'Specific email ID';

					// print_r($template);die;
					$noti_condition = 'ane_art_id='.$article_id.' and ane_aflw_id='.$current_stage_id;
					if(isset($template->stage_etmp_id))
						$noti_condition['ane_stage_etmp_id'] = $template->stage_etmp_id;
					elseif(isset($template->etmp_id))
						$noti_condition['ane_event_etmp_id'] = $template->etmp_id;
                    $Article_notification_emails= new \App\Models\Article_notification_emails();
					$article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to', $noti_condition);
					$attch_file_html='';
					if(!empty($article_notification))
					{
						//$attch_file_html = $this->get_invite_email_attachments($article_id,$article_notification->ane_id);
					}

					$data = array(
						'status' => 'success',
						'cc_bcc_roles' => $cc_bcc_roles,
						'user_ids' => $usr_ids,
						'aflw_id' => $current_stage_id,
						'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
						'to_cc' => $to_cc_arr,
						'to_bcc' => $to_bcc_arr,
						'cust_cc' => $template->stage_etmp_cust_cc,
						'cust_bcc' => $template->stage_etmp_cust_bcc,
						'reply_to' => $reply_to,
						'subject' => $subject,
						'content' => $body,
                        'attch_file_html' => (isset($attch_file_html)?$attch_file_html:''),
						'invite_templates' => $all_templates,
						'user_info' => $user_info);*/
				}
				else
				{
					$data = array(
						'status' => 'template_err',
						//'user_info' => $user_info,
						'aflw_id' => $current_stage_id,
						'msg' => customTrans('viewarticle.undefined_template'),
                    );
                    $return_array['data']=$data;
					if ($event_based == true)
					{
						return  $this->success('Success',200,$return_array);
					}
				}
				$content = '';
				$return_arr = array();
				$allowed_tmpl_actn = array('invitation','reopen_review');
				if(in_array($template_action,$allowed_tmpl_actn))
				{
					$data['enable_attachments'] = true;
					$data['enable_inventory_files'] = true;
					$data['is_reopen'] = false;
					if($template_action == 'reopen_review')
						$data['is_reopen'] = true;
				}
				if ($template_view == 'y')
				{
					//$content = $this->load->view('view_article_modification/templates/tmpl_email_preview_contents', $data, true);
				}
				else
				{
					$data['template_action'] = $template_action;
					$confirm_msg = "";
					if ($template_action == 'uninvite')
					{
						$btn_id = 'btn_uninvite_invitation';
						$btn_name = 'btn_uninvite_invitation';
						$confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					else
					{
						$btn_id = 'btn_send_invitation';
						$btn_name = 'btn_send_invitation';
						$confirm_msg = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
					$btn_text = 'Send';
					$form_id = "form_invite_email_preview";
					$form_name = "form_invite_email_preview";
					$stage_name = "";
					if ($template_action == 'unassign' || $template_action == 'unassign-reviewer')
					{
						$btn_id = 'btn_unassgn_rvr';
						$btn_name = 'btn_unassgn_rvr';
						$form_name = 'form_preview_unassgn';
						$form_id = 'form_preview_unassgn';
						if ($hold != '')
						{
							//$btn_id = 'btn_without_review_action';
							//$btn_name = 'btn_without_review_action';
							$hold_id = decrypt_link($hold);
                            $condition = "aflw_id=:hold_id";
                            $condition_arr=array(
                                'hold_id' => $hold_id,
                            );
							$hold_article_details = Articles::get_article_details('jwf_stage_name',$condition,null,false,false,null,$condition_arr);
							$stage_name = $hold_article_details[0]->jwf_stage_name;
							$btn_text = 'Proceed to ' . $hold_article_details[0]->jwf_stage_name;
						}
					}

					if ($template_action == 'review_resubmit' || $template_action == 'reopen_review')
					{
						$btn_id = 'btn_review_resubmit';
						$btn_name = 'btn_review_resubmit';
					}

					$data['form_name'] = $form_name;
					$data['form_id'] = $form_id;
					$data['btn_id'] = $btn_id;
					$data['btn_name'] = $btn_name;
					$data['btn_text'] = $btn_text;
					$data['btn_confirm_msg'] = $confirm_msg;

					if ($event_based == true)
					{
						$title = '';
						if ($template_action == 'reviewer_on_fly_email_change')
						{
							$return_arr['userdata'] = $reviewer;
							$title = customTrans('viewarticle.edit_reviewer_info');

							$data['form_name'] = 'reviewer_on_fly_email_change';
							$data['form_id'] = 'reviewer_on_fly_email_change';
							$data['btn_id'] = 'reviewer_on_fly_email_change_button';
							$data['btn_name'] = 'reviewer_on_fly_email_change_button';
							$data['btn_text'] = 'Change';
							$return_arr['instruction'] = str_replace('%link%', ' <a id=\'edit_fly_email_template\'>here</a> ', str_replace('%email%', $reviewer->usr_email, customTrans('viewarticle.change_added_on_fly_user_email_instruction')));
						}
						elseif ($template_action == 'reopen_review')
						{
							$title = 'Review reopen';
						}
					}
					else
					{
						// $title = ($template_action == 'unassign' || $template_action == 'unassign-reviewer') ? 'Unassign user' : ($template_action == 'uninvite')? 'Uninvite user':'Invite user';
						if ($template_action == 'unassign' || $template_action == 'unassign-reviewer')
						{
							$title = 'Unassign user';
						}
						elseif ($template_action == 'uninvite')
						{
							$title = 'Uninvite user';
						}
						elseif ($template_action == 'review_resubmit')
						{
							$title = 'Review resubmit';
						}
						else
						{
							$title = 'Invite user';
						}
					}

					$data['stage_name'] = $stage_name;
					$data['title'] = $title;
					$data['hold'] = $hold;
					//$content = $this->load->view('view_article_modification/email_preview_modal', $data, true);
				}
				$return_arr['status'] = 'success';
				$return_arr['msg'] = 'success';
				$return_arr['template_view'] = $template_view;
				$return_arr['content'] = $data;
			}
			elseif ($template_action == 'unassign-reviewer')
			{
				$curr_stage_child = json_decode($article_details->jwf_child_stages);
                $Generic_flows = new \App\Models\Generic_flows();
				$next_stage_data = $Generic_flows::get_single_record('jwf_stage_name', 'jwf_id='.$curr_stage_child[0]);


				$stage_name = $next_stage_data->jwf_stage_name;
				$btn_id = 'btn_unassgn_rvr';
				$btn_name = 'btn_unassgn_rvr';
				$form_name = 'form_preview_unassgn';
				$form_id = 'form_preview_unassgn';
				if ($hold != '')
				{

					$hold_id = $this->decrypt_data($hold);
                    $condition = "aflw_id=:hold_id";
                    $condition_arr=array(
                        'hold_id' => $hold_id,
                    );
                    $hold_article_details = Articles::get_article_details('jwf_stage_name,jwf_stage_type',$condition,null,false,false,null,$condition_arr);
					//$hold_article_details =Articles::get_article_details('jwf_stage_name, jwf_stage_type','aflw_id='.$hold_id);

					$stage_name = $hold_article_details[0]->jwf_stage_name;
					$btn_text = 'Proceed to ' . $hold_article_details[0]->jwf_stage_name;
					if ($hold_article_details[0]->jwf_stage_type == "post_assessment")
					{
						$data['btn_confirm_msg'] = $this->current_client->functionality->cfty_disable_unnecessary_confirm;
					}
				}
				$msg = 'You are moving to ' . $stage_name;

				$data['stage_name'] = $stage_name;
				$data['form_name'] = $form_name;
				$data['form_id'] = $form_id;
				$data['btn_id'] = $btn_id;
				$data['status'] = 'proceed';
				$data['title'] = 'Proceed';
				$data['hold'] = $hold;
				$data['aflw_id'] = $current_stage_id;
				$data['msg'] = $msg;
				$data['btn_name'] = $btn_name;
				$data['btn_text'] = $btn_text;
				//$content = $this->load->view('view_article_modification/email_preview_modal', $data, true);
				$return_arr = array(
					'status' => 'success',
					'msg' => 'success',
					'template_view' => $template_view,
					//'content' => $content
				);
			}
		    $return_arr['email_data'] = (isset($data)) ? $data : null;
            return  $this->success('Success',200,$return_arr);
        } catch (\exception $e) {
            return $this->failure('Failed', 200, $e);
        }
    }
    //*** show unassign & uninvite emails if exists while clicking the proceed to stage button in review starts */

    //***  moving article from review stage to the holded stage(more review is intiated) starts */
    public function returned_to_reopened_stage(Request $request)
	{
        try{
            $current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($post_data, [
            'art_id' => 'required',
            'art_flow_id' => 'required',
            'hold_stage_id'=> 'required',
            'jnlcode'=> 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
		    $article_flow_id = isset($post_data['art_flow_id'])?$this->decrypt_data($post_data['art_flow_id']):'';
            $hold_stage_flow_id =isset($post_data['hold_stage_id'])?$this->decrypt_data($post_data['hold_stage_id']):'';
            $art_id = isset($post_data['art_id'])?$this->decrypt_data($post_data['art_id']):'';
            $jnlcode = isset($post_data['jnlcode'])?$this->decrypt_data($post_data['jnlcode']):'';
            $existrecord =$this->checkValidRecord($art_id, $article_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            //print_r($hold_stage_flow_id); die;
            if ($article_flow_id != '' && $hold_stage_flow_id != '' && $this->current_client->functionality->cfty_proceed_without_review == 'y')
            {

                $article_flow = Article_flow::get_single_record('aflw_resume_source_of,aflw_reopened_stage_min_max_count,aflw_art_id,aflw_jwf_id',     'aflw_id='.$hold_stage_flow_id);
                if (!empty($article_flow))
                {
                    $invited_reviewers_list = Article_flow::get_all_records('aflw_usr_id,aflw_id', 'aflw_parent_flow_id = ' . $article_flow->aflw_resume_source_of . ' and (aflw_status = \'i\' or aflw_status = \'a\') ');
                    //print "<pre>"; print_r($invited_reviewers_list);exit;
                    $article_id = $article_flow->aflw_art_id;
                    $review_flow_id = $article_flow->aflw_resume_source_of;
                    $previous_min_max_count = json_decode($article_flow->aflw_reopened_stage_min_max_count);
                    $current_completed_reviews = Article_flow::get_single_record('count(*) as completed','aflw_status = \'c\' and aflw_parent_flow_id='.$review_flow_id);
                    $Article_reviewers=new \App\Models\Article_reviewers();
                    $reviewers_count = $Article_reviewers::get_single_record('count(sorw_id) as reviewers','sorw_art_id='.$art_id);
                    $flow_review_main = Article_flow::get_single_record('aflw_jwf_id','aflw_id='.$review_flow_id);
				// Commented the condition Bug #2046 - Reducing number of required reviewers
				// if (!empty($current_completed_reviews) && isset($current_completed_reviews->completed) && (int) $current_completed_reviews->completed <= (int) $previous_min_max_count[2]) {
				$reviw_update_array = array(
					'aflw_stage_min_users' => $previous_min_max_count[0],
					'aflw_stage_max_users' => $previous_min_max_count[1],
					'aflw_more_review_skip_status' => 'y'
				);
				if($reviewers_count->reviewers == 0)
				{
					$reviw_update_array['aflw_skip_review'] = 'y';
				}
				if ($article_flow_id == $hold_stage_flow_id)
					$reviw_update_array['aflw_reopened_flow_id'] = null;
				//Article_flow::trans_start();
				Article_flow::update_record($reviw_update_array,'aflw_id='.$review_flow_id, $current_user);
				Article_flow::update_record(array(
					'aflw_status' => 'g'), 'aflw_status IN ("a", "i") AND aflw_parent_flow_id = ' . $review_flow_id); //unassign reviewers
				$where_condition = 'aflw_art_id='.$article_id.' and apfm_status=\'a\'';
				$add_where = 'FIND_array_intersect("'.$flow_review_main->aflw_jwf_id.'",apfm_travel_path_ids) > 0';
				$select = "group_concat(apfm_id) as ids";
                $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
				$get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select,$where_condition,$add_where);
				if(!empty($get_path_having_jwf))
				{
					$ids = $get_path_having_jwf[0]->ids;
					if(!empty($ids))
					{
						$sql = "update rvw_article_parallel_flow_movement set apfm_status = 'c' where apfm_id IN (".$ids.")";
						$update_records = $Article_parallel_flow_movement::execute_query($sql,true);
					}
				}


				$select = 'art_artp_id, jwf_id, jwf_fwm_id';
                $condition = "aflw_id=:review_flow_id";
                $condition_arr=array(
                    'review_flow_id' => $review_flow_id,
                );
                $article_details = Articles::get_article_details($select,$condition,null,false,false,null,$condition_arr);
                $article_details =$article_details[0];
				$flow_master_sql = "SELECT * FROM rvw_journal_workflows WHERE jwf_fwm_id = " . $article_details->jwf_fwm_id;
                $Generic_flows = new \App\Models\Generic_flows();
				$get_flow = $Generic_flows::get_records_by_raw_query($flow_master_sql);
				$current_jwf = $article_details->jwf_id;
				$workflow = $this->process_flow($get_flow);
				$select = 'aflw_id,aflw_art_id,aflw_level, (select role_name from rvw_roles where role_id = jwf_role_id) as role_name';
				$this_stage = Article_flow::get_stage_details('aflw_id='.$review_flow_id, $select);
                $array_data = array();
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);
                $array_data['current_jwf'] = $current_jwf;
                $array_data['this_workflow'] = $workflow;
                $array_data['article_id'] = $article_id;
                $array_data['current_user'] = $current_user;
                $array_data['parent_stage'] = $array_data['this_stage'] = $this_stage;
                $array_data['aflw_id'] = $article_flow_id;
                $array_data['art_artp_id'] = $article_details->art_artp_id;
                $array_data['artp_id'] = $article_details->art_artp_id;
                $array_data['current_client'] = $this->current_client;
                $array_data['review_flow'] = $review_flow;
                $array_data['article_details'] = $article_details;
                $array_data['next_stage'] = $article_flow->aflw_jwf_id;
                $tmp_status_id = $this->update_reopened_stages($array_data);

                $return['status'] = 'success';
                $return['prev_status_id'] = $review_flow_id;
                $return['status_id'] = $tmp_status_id;
                $return['show_modal'] = true;
				if (isset($invited_reviewers_list) && count($invited_reviewers_list) >= 1)
				{
					$select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept';
                    $condition = "aflw_id=:article_flow_id";
                    $condition_arr=array(
                        'article_flow_id' => $article_flow_id,
                    );
					$article_details = Articles::get_article_details($select,$condition,null,false,false,null,$condition_arr);
					$article_details = $article_details[0];
					$condition = "stage_etmp_action='unassign_user' and stage_etmp_id=".$this->decrypt_data($post_data['invite_tmpl_name']);
                    $Stage_email_templates = new \App\Models\Stage_email_templates;
					$email_template = $Stage_email_templates::get_single_record('*', $condition);
					if (!empty($email_template))
					{
						$post_data['art_id'] = $article_id;
						$insert_data = array(
							'unsn_reason' => (isset($post_data['unassign_reason'])) ? $post_data['unassign_reason'] : '',
						);
						foreach ($invited_reviewers_list as $invited)
						{
                            $Users = new \App\Models\User();
							$usr_details = $Users::get_single_record('usr_email,usr_id','usr_id='.$invited->aflw_usr_id);

							//update the unassign reason
							$insert_data['unsn_rvr_id'] = $invited->aflw_usr_id;
							$insert_data['unsn_aflw_id'] = $invited->aflw_id;
                            $Unassign_reviewer = new \App\Models\Unassign_reviewer();
							$Unassign_reviewer::insert_record($insert_data, $this->current_user);
							$post_data['esl_aflw_id'] = $invited->aflw_id;

							$post_data['unassign_email_reply_to'] = $post_data['invite_email_reply_to'];
							if (isset($post_data['invite_tmpl_to_cc']))
							{
								$post_data['unassign_tmpl_to_cc'] = $post_data['invite_tmpl_to_cc'];
							}
							if (isset($post_data['invite_tmpl_to_cust_cc']))
							{
								$post_data['unassign_tmpl_to_cust_cc'] = $post_data['invite_tmpl_to_cust_cc'];
							}

							if (isset($post_data['unassign_tmpl_to_bcc']))
							{
								$post_data['unassign_tmpl_to_bcc'] = $post_data['invite_tmpl_to_bcc'];
							}
							if (isset($post_data['invite_tmpl_to_cust_bcc']))
							{
								$post_data['unassign_tmpl_to_cust_bcc'] = $post_data['invite_tmpl_to_cust_bcc'];
							}

							$this->send_unassign_email($email_template, $post_data, $article_details, $usr_details);
						}
					}
				}
				// }
			}
        }
		    //Article_flow::trans_complete();
		    return  $this->success('Success',200,$return);
        } catch (\exception $e) {
            return $this->failure('Failed', 200, $e);
        }
    }
    //***  moving article from review stage to the holded stage(more review is intiated) ends */

    //***  for listing suggest and oppose reviewers starts */
    public function suggest_and_oppose(Request $request)
    {
        try{
            $current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($post_data, [
            'art_id' => 'required',
            'art_flow_id' => 'required',
            'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
		    $article_flow_id = isset($post_data['art_flow_id'])?Rv_decrypt($post_data['art_flow_id']):'';
            $article_id = isset($post_data['art_flow_id'])?Rv_decrypt($post_data['art_id']):'';
            $jnlcode = isset($post_data['jnlcode'])?Rv_decrypt($post_data['jnlcode']):'';
            $existrecord =$this->checkValidRecord($article_id, $article_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $select = 'jwf_id';
            $condition = "aflw_id=:article_flow_id";
            $condition_arr=array(
                'article_flow_id' => $article_flow_id,
            );
			$article_details = Articles::get_article_details($select,$condition,null,false,false,null,$condition_arr);
            $suggest_oppose_reviewer_show = true;
			if (isset($article_details[0]) && $article_details[0]->jwf_id)
			{
                $article_details=$article_details[0];
                $Article_flow_table = (new \App\Models\Article_flow)->getTable();
                $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
                $Roles_table = (new \App\Models\Roles)->getTable();

                $sql = 'SELECT count(aflw_id) as cnt FROM ' . $Article_flow_table. ' aflw JOIN ' . $Generic_flows_table . ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' . $Roles_table. ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer" AND jwf.jwf_id=' . $article_details->jwf_id . '  AND aflw.aflw_usr_id = ' . $current_user['user_id'] . ' AND aflw_art_id =' . $article_id;

				$article_reviewer = Article_flow::get_records_by_raw_query($sql);
				if (isset($article_reviewer[0]->cnt) && $article_reviewer[0]->cnt > 0)
				{
					$suggest_oppose_reviewer_show = false;
				}
                $Article_reviewers = new \App\Models\Article_reviewers();
                $Country_table = (new \App\Models\Country())->getTable();
                // For getting suggest reviewers
                $return_array['suggest_review_details'] = $Article_reviewers::get_all_records('*,(select cnt_country from ' . $Country_table . ' where sorw_cnt_id = cnt_id) as country_name', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='s'");

                // // For getting suggest reviewers skip
                // $return_data['get_sugg_rvr_details'] = $Article_reviewers::get_all_records('*', "sk_art_id={$article_id} AND sk_skip_action='skip_suggest'");

                // //For getting oppose reviewer
                $return_array['oppose_review_details'] = $Article_reviewers::get_all_records('*,(select cnt_country from ' . $Country_table . ' where sorw_cnt_id = cnt_id) as country_name', "sorw_art_id={$article_id} AND sorw_suggested_user_role='a' AND sorw_action='o'");

                // //For getting oppose reviewer skip
                // $return_data['get_sugg_rvr_details'] = $Article_reviewers::get_all_records('*', "sk_art_id={$article_id} AND sk_skip_action='skip_oppose'");

            }
			$suggest_oppose_reviewer_show = $suggest_oppose_reviewer_show;
			//*end -- not show suggest/oppose reviewers who having reviewer role in review stage*//
            $return_array['suggest_oppose_reviewer_show'] = $suggest_oppose_reviewer_show;
            return  $this->success('Success',200,$return_array);
        } catch (\exception $e) {
            return $this->failure('Failed', 200, $e);
        }
    }
    //***  for listing suggest and oppose reviewers starts */

    // for getting the reason for delete starts
    public function delete_article_reason(Request $request)
    {
        try{
            //$current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $Article_deletion_reasons = new \App\Models\Article_deletion_reasons();
            $del_reasons = $Article_deletion_reasons::get_all_records();
            if (!empty($del_reasons))
			{
				foreach ($del_reasons as $del)
				{
					$delete_reasons[$del->adel_id] = $del->adel_reason;
				}
			}
			$delete_reasons = (!empty($delete_reasons)) ? $delete_reasons : UtilityTrait::Utility('reason_to_delete_article')['reason_to_delete_article'];
            // $delete_reasons['custom']='Other reason';
            $return_array['delete_reasons']=$delete_reasons;
            return  $this->success('Success',200,$return_array);
        } catch (\exception $e) {
            return $this->failure('Failed', 200, $e);
        }
    }
    // for getting the reason for delete ends

    public function get_all_productionfiles(Request $request)
	{
        try
        {
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'jnl_code' => 'required',
                'art_flow_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $current_user = $this->get_current_user_details();
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Production_attachment_files_table = ($Production_attachment_files)->getTable();
            $Generic_flows = new \App\Models\Generic_flows();
            $Generic_flows_table = ($Generic_flows)->getTable();
            $Article_flow = new \App\Models\Article_flow();
            $Article_flow_table = ($Article_flow)->getTable();
            $Articles = new \App\Models\Articles();
            $Articles_table = ($Articles)->getTable();
            $Attachment_files = new \App\Models\Attachment_files();
            $Attachment_files_table = ($Attachment_files)->getTable();
            $Roles = new \App\Models\Roles();
            $Roles_table = ($Roles)->getTable();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Attachment_designated_roles_table = ($Attachment_designated_roles)->getTable();
            $Attachment_file_description = new \App\Models\Attachment_file_description();
            $Attachment_file_description_table = ($Attachment_file_description)->getTable();
            $post_data = $request->all();
            $art_id = isset($post_data['art_id'])?decrypt_link($post_data['art_id']):'';
            $jnl_code = isset($post_data['jnl_code'])?decrypt_link($post_data['jnl_code']):'';
            $art_flow_id = isset($post_data['art_flow_id'])?decrypt_link($post_data['art_flow_id']):'';
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnl_code);
            $platform_code = $request->segment(3);
            $user_roles = $this->validate_user_journal($platform_code, $current_user['user_id']);
		    $customform_details = array();// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $attachment_type="attachment_type";
            // $core_role = decrypt_link($post_data['core_role']);
            // $role_id = decrypt_link($post_data['role_id']);
            $article_details = Articles::get_single_record('art_code,art_es_document_status,art_es_document_type,art_artp_id', 'art_id='.$art_id);
            $platform_data = $this->platform_basic_settings_data($jnl_code);
            $view_article = false;
            $article_flow_data = Article_flow::get_generic_flow('jwf_stage_type,jwf_fwm_id','aflw_id = '.$art_flow_id);
            if(isset($post_data['page']))
            {
                $view_article = true;
            }
            $date_format = static::date_format_map($platform_data->jset_date_format);


            $table_join = array(
                    'main_table' => $Production_attachment_files_table,
                    'join_table' => array(
                                $Article_flow_table => array($Article_flow_table . '.aflw_id', $Production_attachment_files_table . '.paf_aflw_id', ""),
                                $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', ""),
                                $Articles_table => array($Articles_table . '.art_id', $Production_attachment_files_table . '.paf_art_id', ""),
                                $Attachment_designated_roles_table => array($Attachment_designated_roles_table . '.adr_paf_id', $Production_attachment_files_table . '.paf_id', "left"),
                                $Attachment_file_description_table => array($Attachment_file_description_table . '.afdec_id', $Production_attachment_files_table . '.paf_description_id', "left")
                    )
            );
            $role_id='';
            $core_role='';
            $production_role  = false;
            $review_role = false;
            if(isset($post_data['role_id']) && isset($post_data['core_role']))
            {
                   // $logged_user_role = $post_data['jnl_code']];
                    $role_id = decrypt_link($post_data['role_id']);
                    $core_role = decrypt_link($post_data['core_role']);
                    $check_role = Roles::get_single_record('role_used_in','role_id='.$role_id);
                    if(!empty($check_role))
                    {
                                    $role_used_in_arr = explode(',', $check_role->role_used_in);
                                    if(in_array('p', $role_used_in_arr))
                                    {
                                        $production_role = true;
                                    }
                                    if(in_array('r', $role_used_in_arr))
                                    {
                                        $review_role = true;
                                    }
                    }

            }
            $max_flow_level = Article_flow::get_single_record("max(aflw_level) as level","aflw_art_id=".$art_id);
            $get_all_top_levels = Article_flow::get_all_records("aflw_jwf_id","aflw_level =".$max_flow_level->level." AND aflw_art_id =".$art_id);

            $production_article = false;
            $client_code = $this->current_client->clnt_client_code;
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';

            $review_flow  = Config::get($review_config);
            $workflow_config    =   'clients.' . $client_code . '.workflow_config.review_flow';
            $review_flow        =   Config::get($workflow_config);

            foreach($get_all_top_levels as $single_all_top_level)
            {
                $stage_type = Generic_flows::get_single_record("jwf_stage_type","jwf_id = ".$single_all_top_level->aflw_jwf_id);


                if(isset($review_flow[$stage_type->jwf_stage_type]['stage_for']) && $review_flow[$stage_type->jwf_stage_type]['stage_for'] == "manageproduction")
                {
                    $production_article = true;
                }
            }
            $data['show_viewable_file_permission_manage']=true;
            $manage_role = main_production_roles();
            $art_criteria='paf_art_id = "' . $art_id .'"  AND aflw_status IN("c")';
            if (!in_array($core_role, $manage_role))
            {
                $art_criteria.=' AND  (FIND_array_intersect(\''.$role_id.'\',adr_role_id) = 1';
                $art_criteria.=' OR aflw_usr_id='.$current_user['user_id'].')';
                $data['show_viewable_file_permission_manage']=false;
            }
            $attachments = Article_flow::get_results_using_joins($table_join, 'paf_id,paf_art_id,paf_aflw_id,jwf_stage_name,jwf_id,paf_file_name,paf_document_size,paf_designated_to,paf_posted_by,DATE_FORMAT(paf_posted_date, "' . $date_format . '") as uploaded_date,art_article_upload_path,adr_role_id as designated_roles,adr_id,afdec_description', $art_criteria);
            foreach($attachments as $item){
                $item->$attachment_type ='Production Stage Files';
            }
            $table_auth_join = array(
                    'main_table' => $Attachment_files_table,
                    'join_table' => array(
                        $Article_flow_table => array($Article_flow_table . '.aflw_id', $Attachment_files_table . '.atmnt_aflw_id', "left"),
                        $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', "left"),
                        $Articles_table => array($Articles_table . '.art_id', $Attachment_files_table . '.atmnt_art_id', "left"),
                        $Attachment_designated_roles_table => array($Attachment_designated_roles_table . '.adr_atmnt_id', $Attachment_files_table . '.atmnt_id', "left"),
                        $Attachment_file_description_table => array($Attachment_file_description_table . '.afdec_id', $Attachment_files_table . '.atmnt_label', "left")
                    )
            );
            $where_file_condition = '';
            $current_user_roles = implode(',',$user_roles['role_id']);
            if($production_article == false && $production_role == false)
            {
                $where_file_condition = 'atmnt_art_id =' .$art_id. ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1';
                if (!in_array($core_role, $manage_role)) {
                            $where_file_condition.=' AND  (FIND_array_intersect("'.$current_user_roles.'",adr_role_id) = 1';
                            $where_file_condition.=' OR aflw_usr_id='.$current_user['user_id'].')';

                }
            }
            else
            {
                    $where_file_condition = 'atmnt_art_id =' .$art_id;
                    if (!in_array($core_role, $manage_role))
                    {
                        $where_file_condition .= ' AND ((FIND_array_intersect("'.$current_user_roles.'",'.$Attachment_file_description_table .'.afdec_viewable_roles)) = 1 OR atmnt_posted_by = '.$current_user['user_id'].' ) ';
                    }
            }
                //	$author_attachment=$this->Attachment_files->get_all_records('*', $where_file_condition);
            $article_flow_details = Article_flow::get_stage_details('aflw_id='.$art_flow_id, 'jwf_stage_name');
            $es_integration = false;
            $esarray['article_id']=$art_id;
            $checkdata=$this->check_espermission_access($esarray);
            $has_es_main_doc_permission = false;
            if($checkdata == true)
            {
                $article_data = (object) [
                    'artp_id' =>$article_details->art_artp_id,
                    'art_id' =>$art_id,
                    'artp_fwm_id'=>$article_flow_data[0]->jwf_fwm_id,
                    'jnl_journal_code'=>$jnl_code,
                    'art_artp_id'=>$article_details->art_artp_id
                ];
                $article_privilages = $this->article_privilages($article_data,NULL,$jnl_code,'all',TRUE);
                $check_arr = array('art_id' =>$art_id,'artp_id' => $article_details->art_artp_id,'role_id' => $role_id,'core_role' => $core_role,'article_privillages' => $article_privilages);
                $has_es_main_doc_permission = $this->main_doc_permission($check_arr);
            }
            $es_attachments = array();
            //if($this->current_client->modules->mdl_es_integration == 'y' &&  $article_details->art_es_document_status !== 'n')
            if($has_es_main_doc_permission==true)
            {
                $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
                $es_site_url = $es_api_data['api_url'];
                $data['es_download_url'] = $es_api_data['doc_download_url'] ;
                $es_integration = true;
                if($article_details->art_es_document_type == 'n')
                {
                    $es_data = array();
                    $query_string = 'article_id='.$art_id;
                    $encrypted_string = Rv_encrypt($query_string);
                    $pass_data = array('encryptedData' => $encrypted_string);
                    $pass_data = http_build_query($pass_data);
                    $es_config = 'clients.' .$this->current_client->clnt_client_code. '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    $apiUrl = $es_api_data['main_doc_dtls'];
                    $response = $this->es_curl_request($apiUrl,$pass_data);
                    $response = json_decode($response);
                    $es_data = array();
                    $es_data['file_name'] = '';
                    $es_data['file_size'] = '--';
                    $es_data['created_date'] = '';
                    if(isset($response->status) && $response->status == 200)
                    {
                        $es_data['file_name'] = $response->file_name;
                        $es_data['file_size'] = $response->file_size;
                        $created_date = Carbon::parse($response->created_at);
                        $mysqlDateTime = $created_date->toDateTimeString();
                        $journal_date_frmt = $platform_data->jset_date_format;
                        if($journal_date_frmt !== '')
                        {
                            $es_data['created_date'] = Carbon::parse($mysqlDateTime)->format($journal_date_frmt);
                        }
                        else
                        {
                            $es_data['created_date'] = $response->created_at;
                        }
                    }
                    $Required_file_type_tbl = (new \App\Models\Required_file_type())->getTable();
                    $join_tbls = array(
                        'main_table' => $Attachment_file_description_table,
                        'join_table' => array(
                            $Required_file_type_tbl => array($Required_file_type_tbl . '.rft_file_desp_id', $Attachment_file_description_table . '.afdec_id')
                        )
                    );
                    $select_fields_decripin = 'afdec_description';
                    $criteria_check = 'rft_artp_id=' .$article_details->art_artp_id.' AND afdec_main_document =\'y\'';
                    $get_main_attachment = $Attachment_file_description::get_results_using_joins($join_tbls, $select_fields_decripin, $criteria_check, 'single');
                    $es_data['main_doc_desc'] = isset($get_main_attachment->afdec_description) ? $get_main_attachment->afdec_description : '';
                    $article_type_tbl = (new \App\Models\Article_types())->getTable();
                    $join_tbls = array(
                        'main_table' => $Articles_table,
                        'join_table' => array(
                            $article_type_tbl => array($article_type_tbl . '.artp_id', $Articles_table . '.art_artp_id'),
                            $Generic_flows_table => array($Generic_flows_table.'.jwf_fwm_id',$article_type_tbl.'.artp_fwm_id')
                        )
                    );
                    $criteria_check = 'art_id=' .$art_id.' AND jwf_stage_type =\'author_submission\'';
                    $select_fields_decripin = 'jwf_stage_name';
                    $get_stage_name = $Articles::get_results_using_joins($join_tbls, $select_fields_decripin, $criteria_check, 'single');
                    $es_data['stage_name'] = isset($get_stage_name->jwf_stage_name) ? $get_stage_name->jwf_stage_name : '';
                    $data['es_created_data'] = $es_data;
                }
            }
            else
            {
                $where_file_condition .= ' AND afdec_main_document =\'n\' ';
            }
            // Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
            $data_arr=array(
                'art_id'=>$art_id,
                'jnl_code'=>$jnl_code,
                'role_id'=>$role_id,
                'core_role'=>$core_role,
            );
            $customform_details=(new Manage_Email_Api())->get_all_customform_files($data_arr);
            $data['showflag'] =$customform_details['showflag'];
            $data['element_viewstatus'] =$customform_details['element_viewstatus'];
		    $data['othercustomform_attachments'] =$customform_details['customform_attachments'];

            $author_attachment = array();
            $author_attachment = Article_flow::get_results_using_joins($table_auth_join, 'atmnt_id,atmnt_art_id,atmnt_aflw_id,jwf_stage_name,jwf_id,atmnt_file_name,atmnt_document_size,DATE_FORMAT(atmnt_file_uploaded_date, "' . $date_format . '") as uploaded_date,atmnt_posted_by,atmnt_posted_date,art_article_upload_path,adr_role_id as designated_roles,adr_id,afdec_description,afdec_main_document,atmnt_orginal_upload_path ',$where_file_condition);
            foreach($author_attachment as $item){
                $item->$attachment_type ='Submission Files';
            }
            $data['es_integration'] = $es_integration;
            $data['journal_code'] = $jnl_code;
            $data['production_stage_files'] = $attachments;
            $data['production_author_attachment']=$author_attachment;
            $data['production_designated_roles']=array();
            $user_desinated_roles = $this->UserConfigdata('production_designated_roles');
            $production_roles = Roles::get_all_records('role_id,role_name, role_assigned_role', 'role_assigned_role IN ("' . implode('","', $user_desinated_roles['production_designated_roles']) . '")');
            $data['production_designated_roles'] = $production_roles;
            $data['permission_to_designate_roles'] = false;
            $data['production_article'] = $production_article;
            $data['view_article'] = $view_article;
            $data['article_details'] = $article_details;
            $data['article_flow_details'] = $article_flow_details;
            $enable_viewrole_row= false;
            if(count($data['production_stage_files']) > 0 && $core_role =='journal_admin')
            {
                $enable_viewrole_row= true;
            }
            $data['enable_viewrole_row'] = $enable_viewrole_row;
            //$table_body = $this->load->view('production_view/template/tmpl_production_attachment_list', $data, true);
            //$return_arr['attach_list']=$table_body;
            //$footer_attach_btn=$this->load->view('production_view/template/tmpl_attach_list_btn_list', $data, true);
            //$return_arr['footer_btn']=$footer_attach_btn;
            return $this->success('Success', 200, $data);


        } catch (\exception $e) {

            return $this->failure('Failed', 200, $e);
        }


	}
    public function download_file(Request $request)
	{
		try{
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'file' => 'required',
                'jnlcode' => 'required',
                'type' => 'required',
                'view' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
			$post_data = $request->all();
            if(isset($post_data))
            {
                $current_user = $this->get_current_user_details();
                $array['article_id'] = $this->decrypt_data($post_data['article_id']);
                $array['file'] = $file_id = $this->decrypt_data($post_data['file']);
                $array['type'] = $this->decrypt_data($post_data['type']); //for generic form files = generic,  for attachment files == attachment //for supplementary files == supplementary
                $array['view'] = $this->decrypt_data($post_data['view']);
                $jnl_code = $this->decrypt_data($post_data['jnlcode']);
                //	$path = $this->input->get('path');
                //$downloaddata=$this->get_attachment_data($array,$jnl_code,$current_user);
                $file_data = Attachment_files::get_single_record('atmnt_orginal_upload_path,atmnt_file_name as file_name',"atmnt_id={$file_id}");
                if(!empty($file_data))
                {
                    $folder_path = $file_data->atmnt_orginal_upload_path;
                    $file_path = $folder_path . '/' . $file_data->file_name;
                    $filepathfolder = $this->get_upload_data($file_path);
                    $filepath = $this->upload_folder_path("uploads/".$file_path);

                    // $headers = [
                    //     'Content-Type: text/xml',
                    // ];
                    // $headers = array(
                    //     'Content-Type: application/pdf',
                    // );
                    return Response::download($filepath);
                }

            }

		}
		catch (\Exception $e) {

			return  $this->failure('Failed',500,$e);
		   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
		}
	}
    public function select_download_stage_file($data = null)
	{
        try
        {
            $post_data = json_decode($data);
            $stage_id = decrypt_link($post_data->article_flow_id);
            $art_id = decrypt_link($post_data->art_id);
            $prod_fileids = $post_data->prod_fileids;
            $attach_type = $post_data->attach_type;
            $author_fileids = $post_data->author_fileids;
            $custom_fileids = $post_data->custom_fileids;
            $custom_atta_ids=array();
            $custom_file_ids='';
            $patc_ids = array();
            $prod_file_ids = '';
            $au_atta_ids=array();
            $auth_file_ids='';
            $stage_name = '';
            if(!empty($prod_fileids))
            {
                foreach ($prod_fileids as $val)
                {
                    $patc_ids[] = decrypt_link($val);

                }
                $prod_file_ids=implode(',',$patc_ids);
            }
            if(!empty($author_fileids))
            {
                foreach($author_fileids as $auth_fileid)
                {
                    $au_atta_ids[]= decrypt_link($auth_fileid);
                }
                $auth_file_ids = implode(',',$au_atta_ids);
            }
            if(!empty($custom_fileids))
            {
                foreach($custom_fileids as $custom_fileid)
                {
                    $custom_atta_ids[]= decrypt_link($custom_fileid);
                }
                $custom_file_ids = implode(',',$custom_atta_ids);
            }
            $article_details = Articles::get_single_record('art_code,art_article_upload_path', 'art_id='.$art_id);
            if($attach_type == 'as')
                {
                    $path = 'uploads'.DIRECTORY_SEPARATOR . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR ;
                    $stage_name = 'Author submitted files';
                    $params = array(
                        'art_id' => $art_id,
                        'art_code' => $article_details->art_code,
                        'file_id' =>  $auth_file_ids,
                        'custom_file_ids' =>  $custom_file_ids,
                        'path' => $path,
                        'stage_name' => str_replace(' ', '_', $stage_name)
                    );
                    $this->download_author_files($params);
                }
                elseif($attach_type=='all_ps')
                {
                    $path = 'uploads'.DIRECTORY_SEPARATOR . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/';
                    $stage_name = 'Production files';
                    $params = array(
                        'art_id' => $art_id,
                        'art_code' => $article_details->art_code,
                        'prod_file_ids' =>  $prod_file_ids,
                        'auth_file_ids' =>  $auth_file_ids,
                        'custom_file_ids' =>  $custom_file_ids,
                        'path' => $path,
                        'stage_name' => str_replace(' ', '_', $stage_name)
                    );
                    $this->download_production_files($params);
                }
                else
                {
                    if($stage_id != '')
                    {
                        $select = 'jwf_stage_name';
                        $article_flow_details = Article_flow::get_stage_details('aflw_id='.$stage_id, $select);
                        $stage_name = $article_flow_details->jwf_stage_name;
                    }
                    $path = 'uploads'.DIRECTORY_SEPARATOR . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/';
                    $params = array(
                        'art_id' => $art_id,
                        'art_code' => $article_details->art_code,
                        'file_id' =>  $prod_file_ids,
                        'path' => $path,
                        'stage_name' => str_replace(' ', '_', $stage_name),
                        'flow_id' => $stage_id
                    );
                    $this->download_stage_files($params);
                }
        }
        catch (\Exception $e) {

			return  $this->failure('Failed',500,$e);
		   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
		}

    }
    /* #2069 View article modifications Start  */
	public function download_production_files($data = array())
	{
		$path = $this->upload_folder_path($data['path']);
        $art_id = $data['art_id'];
		$art_code = $data['art_code'];
		$prod_file_ids = $data['prod_file_ids'];
		$auth_file_ids = $data['auth_file_ids'];
        $stage_name = $data['stage_name'];
		$custom_file_ids = $data['custom_file_ids'];
        $all_files = [];
		if($path != '' && ($prod_file_ids!='' || $auth_file_ids|| $custom_file_ids))
		{
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Production_attachment_files_table = ($Production_attachment_files)->getTable();
            $Attachment_files = new \App\Models\Attachment_files();
            $Attachment_files_table = ($Attachment_files)->getTable();
            $Generic_flows = new \App\Models\Generic_flows();
            $Generic_flows_table = ($Generic_flows)->getTable();
            $Article_flow = new \App\Models\Article_flow();
            $Article_flow_table = ($Article_flow)->getTable();
            $Articles = new \App\Models\Articles();
            $Articles_table = ($Articles)->getTable();
			$results = array();
			$author_attachment = array();
            $prod_attachments = array();
		    $where_file_condition ='art_id='.$art_id ;
			if(isset($prod_file_ids)&&($prod_file_ids!=""))
			{
                $where_file_condition .=" AND paf_id IN(".$prod_file_ids.")";
				 $table_join = array(
                    'main_table' => $Production_attachment_files_table,
                    'join_table' => array(
                        $Article_flow_table => array($Article_flow_table . '.aflw_id', $Production_attachment_files_table . '.paf_aflw_id', "left"),
                        $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', "left"),
                        $Articles_table => array($Articles_table . '.art_id', $Production_attachment_files_table . '.paf_art_id', "left"),
                    )
                );
               $prod_attachments = Article_flow::get_results_using_joins($table_join, '*' ,$where_file_condition);
		    }
			if(isset($auth_file_ids)&&($auth_file_ids!=''))
			{
                $where_file_auth_condition = 'atmnt_id IN ('.$auth_file_ids.')';
                $table_join = array(
                    'main_table' => $Attachment_files_table,
                    'join_table' => array(
                        $Article_flow_table => array($Article_flow_table . '.aflw_id', $Attachment_files_table . '.atmnt_aflw_id', "left"),
                        $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', "left"),
                        $Articles_table => array($Articles_table . '.art_id', $Attachment_files_table . '.atmnt_art_id', ""),
                    )
                );
                $author_attachment = Article_flow::get_results_using_joins($table_join, '*' ,$where_file_auth_condition);

			}
			$stage_name = $stage_name.'_'.$art_code;
			if(!empty($prod_attachments) || !empty($author_attachment)||(isset($custom_file_ids)&&($custom_file_ids!='')))
			{
				if(!file_exists($path.$stage_name))
                $this->addDireactory($path.$stage_name, true, 0765, true);
                if(!empty($prod_attachments))
                {
                    foreach($prod_attachments as $res)
                    {
                        $stage_id = $res->paf_aflw_id;
                        $current_stage = $res->jwf_stage_name;
                        $file_loc = $path.$stage_id.'/'.$res->paf_file_name;
                        if((isset($this->current_client->enable_upload_s3_bucket) && $this->current_client->enable_upload_s3_bucket == 'y'))
                        {
                            $file_loc = $attch_path.'/'.$res->atmnt_file_name;
                            $headers = get_headers($file_loc);
                            $exists = strpos($headers[0], '200 OK') !== false;
                            // if($exists)
                            // {
                                //Process from s3 bucket need to implement.
                                if(!file_exists($path.$stage_name.'/'.$current_stage))
                                {   
                                    $this->addDireactory($path.$stage_name.'/'.$current_stage, true , 0765, true);
                                }
                                $stage_id = $res->paf_aflw_id;
                                $file_loc = $path.$stage_id.'/'.$res->paf_file_name;
                                if(file_exists($file_loc))
                                {
                                    $temp = explode('/', $res->paf_file_name);
                                    $temp_filename = end($temp);
                                    copy($file_loc, $path.$stage_name.'/'.$current_stage.'/'.$temp_filename);
                                }
                            // }
                        }
                        else
                        {
                            if(!file_exists($path.$stage_name.'/'.$current_stage))
                            {
                                $this->addDireactory($path.$stage_name.'/'.$current_stage, true , 0765, true);
                            }
                            $stage_id = $res->paf_aflw_id;
                            $file_loc = $path.$stage_id.'/'.$res->paf_file_name;
                            if(file_exists($file_loc))
                            {
                                $temp = explode('/', $res->paf_file_name);
                                $temp_filename = end($temp);
                                copy($file_loc, $path.$stage_name.'/'.$current_stage.'/'.$temp_filename);
                            }
                        }
                    }
                    $all_files[] = $stage_name;
                }
                if(!empty($author_attachment))
                {
                    $auth_stage='Author submission';
                    if(!file_exists($path.$stage_name.'/'.$auth_stage))
                    {
                        $this->addDireactory($path.$stage_name.'/'.$auth_stage, true, 0765, true);
                    }
                    foreach($author_attachment as $attach)
                    {
                        if($this->current_client->enable_upload_s3_bucket == 'y')
                        {
                            $file_loc = $attch_path.'/'.$res->atmnt_file_name;
                            $headers = get_headers($file_loc);
                            $exists = strpos($headers[0], '200 OK') !== false;
                            // if($exists)
                            // {
                                //Process from s3 bucket need to implement.
                                $file_loc = 'storage/uploads/'.$attach->atmnt_orginal_upload_path . DIRECTORY_SEPARATOR . $attach->atmnt_file_name;
                                if(file_exists($file_loc))
                                {
                                    $temp = explode('/', $attach->atmnt_file_name);
                                    $temp_filename = end($temp);
                                    copy($file_loc, $path.$stage_name.'/'.$auth_stage.'/'.$temp_filename);
                                }
                            // }
                        }
                        else
                        {
                            $file_loc = 'storage/uploads/'.$attach->atmnt_orginal_upload_path . DIRECTORY_SEPARATOR . $attach->atmnt_file_name;
                            if(file_exists($file_loc))
                            {
                                $temp = explode('/', $attach->atmnt_file_name);
                                $temp_filename = end($temp);
                                copy($file_loc, $path.$stage_name.'/'.$auth_stage.'/'.$temp_filename);
                            }
                        }
                    }
                    $all_files[] = $stage_name;
                }
                if(isset($custom_file_ids)&&($custom_file_ids!=''))
                {
                        $data=array(
                            'custom_file_ids'=>$custom_file_ids,
                            'path'=>$path,
                            'stage_name'=>$stage_name,
                            'mode'=>'production'
                        );
    
                       $stage_name= $this->download_custom_files($data);
                        $all_files[] = $stage_name;
                        $stage_name = $data['stage_name'];
              
                }
                $folders = implode(" ",$all_files);
				$this->create_zip_and_download($path,$stage_name.'.zip',$folders,true);
			}
		}
	}
    public function download_stage_files($data = array())
	{
        $path = $this->upload_folder_path($data['path']);
		$stage_id = $data['flow_id'];
		$art_code = $data['art_code'];
		$file_ids = $data['file_id'];
        $art_id =$data['art_id'];
        $stage_name = $data['stage_name'];
		if($path != '' && $stage_id != '' && $stage_name!= '')
		{
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Production_attachment_files_table = ($Production_attachment_files)->getTable();

			$where_file_condition ='paf_aflw_id='. $stage_id;
           // $where_file_condition = '';
			if(isset($file_ids)&&($file_ids!=""))
            {
                $where_file_condition.=" AND paf_id IN(".$file_ids.")";
            }
			$results = $Production_attachment_files::get_all_records('paf_file_name',$where_file_condition);
			$stage_name=$stage_name.'_'.$art_code;
			if(count($results) > 0)
			{
				if(!file_exists($path.$stage_name))
                {
                    mkdir($path.$stage_name, 0765, true);
                }
				foreach($results as $res)
				{
                    $file_loc = $path.$stage_id.'/'.$res->paf_file_name;
                    if($file_loc != '' && $this->current_client->enable_upload_s3_bucket == 'y'){
                        $file_loc = $attch_path.'/'.$res->atmnt_file_name;
                        $headers = get_headers($file_loc);
                        $exists = strpos($headers[0], '200 OK') !== false;
                        // if($exists)
                        // {
                            //Process from s3 bucket need to implement.
                            $path = storage_path() . '/app/public/'.$data['path'];
                            $file_loc = storage_path() . '/app/public/uploads/' .$res->atmnt_orginal_upload_path.'/'.$res->atmnt_file_name;
                            if(file_exists($file_loc))
                            {
                                $temp = explode('/', $res->atmnt_file_name);
                                $temp_filename = end($temp);
                                copy($file_loc, $path.$stage_name.'/'.$temp_filename);
                            }
                        // }
                    }
                    else
                    {
                        if(file_exists($file_loc))
                        {
                            $temp = explode('/', $res->paf_file_name);
                            $temp_filename = end($temp);
                            copy($file_loc, $path.$stage_name.'/'.$temp_filename);
                        }
                    }

				}
				$this->create_zip_and_download($path,$stage_name.'.zip',$stage_name,true);
			}
		}
	}
    public function download_author_files($data = array())
	{
        //$path = $this->upload_folder_path($data['path']);
        $path = storage_path() . '/app/public/' . $data['path'];
		$stage_name = $data['stage_name'];
		$art_code = $data['art_code'];
		$file_ids = $data['file_id'];
        $custom_file_ids = $data['custom_file_ids'];
        $art_id = $data['art_id'];
		if($path != '' && $stage_name!= '')
		{
            $Attachment_files = new \App\Models\Attachment_files();
            $Attachment_files_table = ($Attachment_files)->getTable();

            $where_file_condition = 'atmnt_art_id =' .$art_id. ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1';
			if(isset($file_ids)&&($file_ids!=""))
                $where_file_condition.=" AND atmnt_id IN(".$file_ids.")";
		    $results = Attachment_files::get_all_records('*', $where_file_condition);
            $stage_name = $stage_name.'_'.$art_code;
           $all_files = [];
            if(isset($custom_file_ids)&&($custom_file_ids!=''))
			{

                $data=array(
                    'custom_file_ids'=>$custom_file_ids,
                    'path'=>$path,
                    'stage_name'=>$stage_name,
                    'mode'=>'',
                    'art_code'=>$art_code
                );

               $stage_name= $this->download_custom_files($data);
                $all_files[] = $stage_name;
                $stage_name = $data['stage_name'];
         
			}
			if(count($results) > 0)
			{
				if(!file_exists($path.$stage_name))
                {
                    $this->addDireactory($path.$stage_name, true , 0765, true);
                }
				foreach($results as $res)
				{
					if(isset($res->atmnt_orginal_upload_path)&&$res->atmnt_orginal_upload_path!='')
                    {
                        $attch_path = $this->upload_folder_path('uploads/'.$res->atmnt_orginal_upload_path);
                    }

					else
                    {
                        $attch_path = $path;
                    }
                    if($this->current_client->enable_upload_s3_bucket == 'y'){
                        $file_loc = $attch_path.'/'.$res->atmnt_file_name;
                        $headers = get_headers($file_loc);
                            //Process from s3 bucket need to implement.
                            $file_loc = storage_path() . '/app/public/uploads/' .$res->atmnt_orginal_upload_path.'/'.$res->atmnt_file_name;
                            if(file_exists($file_loc))
                            {
                                $temp = explode('/', $res->atmnt_file_name);
                                $temp_filename = end($temp);
                               copy($file_loc, $path.$stage_name.'/'.$temp_filename);
                            }
                    }
                    else
                    {
                        $file_loc = $attch_path.'/'.$res->atmnt_file_name;
                        if(file_exists($file_loc))
                        {
                            $temp = explode('/', $res->atmnt_file_name);
                            $temp_filename = end($temp);
                            copy($file_loc, $path.$stage_name.'/'.$temp_filename);
                        }
                    }

				}
                $all_files[] = $stage_name;
			}
            $folders = implode(" ",$all_files);
            $this->create_zip_and_download($path,$stage_name.'.zip', $folders,true);
		}
	}
    public function download_custom_files($data=array()){
      
        $custom_file_ids=$data['custom_file_ids'] ?? '';
        $path=$data['path'] ?? '';
        $stage_name=$data['stage_name'] ?? '';
        $mode=$data['mode'] ?? '';
        $art_code=$data['art_code'] ?? '';
        if(isset($custom_file_ids)&&($custom_file_ids!=''))
        {
            $Generic_form_files = new \App\Models\Generic_form_files;
            $Generic_form_files = new \App\Models\Generic_form_files;
            $where_file_auth_condition = 'agf_id IN ('.$custom_file_ids.')';
            $file_details = $Generic_form_files::get_all_records('agf_name,agf_original_upload_path',$where_file_auth_condition);
            if(count($file_details) > 0)
             {
                $stage_name = $mode === 'production' ?$stage_name:'CustomForm_files_'.$art_code;
                $filePath = $mode === 'production' ? '/custom form files' : '';
            if(!file_exists($path.$stage_name.$filePath))
            {                
                $this->addDireactory($path.$stage_name.$filePath, true, 0765, true);
            }
            foreach($file_details as $res)
            {
                if(isset($res->agf_original_upload_path)&&$res->agf_original_upload_path!='')
                {
                    $attch_path = $this->upload_folder_path('uploads/'.$res->agf_original_upload_path);
                }

                else
                {
                    $attch_path = $path;
                }
                if($this->current_client->enable_upload_s3_bucket == 'y'){
                    $file_loc = $attch_path.'/'.$res->agf_name;
                    $file_loc = storage_path() . '/app/public/uploads/' .$res->agf_original_upload_path.'/'.$res->agf_name;
                     if ($mode === 'production') {
                        $path=$data['path'];
                        $file_loc = 'storage/uploads/' . $res->agf_original_upload_path . DIRECTORY_SEPARATOR . $res->agf_name;
                    }
            
                    if(file_exists($file_loc))
                    {
                        $temp = explode('/', $res->agf_name);
                        $temp_filename = end($temp);
                        copy($file_loc, $path.$stage_name.$filePath.'/'.$temp_filename);
                    }
                }
                else
                {
                    $file_loc = $attch_path.'/'.$res->agf_name;
                    if ($mode === 'production') {
                        $file_loc = 'storage/uploads/' . $res->agf_original_upload_path . DIRECTORY_SEPARATOR . $res->agf_name;
                    }
                    if(file_exists($file_loc))
                    {
                        $temp = explode('/', $res->agf_name);
                        $temp_filename = end($temp);
                        copy($file_loc, $path.$stage_name.$filePath.'/'.$temp_filename);
                    }
                                    }

            }
            return $stage_name;
        }
        }
    }
    public function  create_zip_and_download($source_location,$zip_name,$source_file,$del_source_file = false)
	{
		if(file_exists($source_location))
		{
			chdir($source_location);
			//create zip
			$cmd = 'zip -r '.$zip_name.' '.$source_file;
			shell_exec($cmd);
			if(file_exists($zip_name))
			{
				if($del_source_file == true)
				{
					$cmd = 'rm -r '.$source_file;
					shell_exec($cmd);
				}
				$this->download_zip_file($source_location.$zip_name,'force-download');

				unlink($zip_name);
			}
		}
	}
    public function download_zip_file($file_path, $file_type,$new_name_with_location = null)
	{
		switch ($file_type)
		{
			case 'pdf':
				$mime = 'application/pdf';
				break;
			case 'zip':
				$mime = 'application/zip';
				break;
			case 'jpeg':
			case 'jpg':
				$mime = 'image/jpg';
				break;
			default:
				$mime = 'application/force-download';
				break;
		}
		if($new_name_with_location == null)
			$new_name_with_location = $file_path;
		header('Pragma: public');  // required
		header('Expires: 0');  // no cache
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Last-Modifi$file_pathed: ' . gmdate('D, d M Y H:i:s', filemtime($file_path)) . ' GMT');
		header('Cache-Control: private', false);
		header('Content-Type: ' . $mime);
		header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
		//header('Content-Disposition: attachment; filename="' . basename($new_name_with_location) . '"');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: ' . filesize($file_path)); // provide file size
		header('Connection: close');
        readfile($file_path);
	}

    public function attachment_assigned_role_selection(Request $request)
	{
		try
		{

            $Roles = new \App\Models\Roles();
            $Roles_table = ($Roles)->getTable();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Attachment_designated_roles_table = ($Attachment_designated_roles)->getTable();
            /*$validator = Validator::make($request, [
                'prod_fields' => 'required',
                'author_fileids' => 'required'
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }*/
			//$file_ids = $request->file_ids;

			$file_ids = $request->prod_fields;
			$author_file_ids = $request->author_fileids;
            if(!isset($file_ids))
            {
                $file_ids = array();
            }
            if(!isset($author_file_ids))
            {
                $author_file_ids = array();
            }
		    $role_id_list='';
		   $selected_roles = array();
		   if(!empty($author_file_ids))
		   {
			  foreach($author_file_ids as $single_author_files)
			  {
				$single_field = decrypt_link($single_author_files);
				$assigned_roles = $Attachment_designated_roles::get_single_record('adr_role_id',"adr_atmnt_id=".$single_field);
				if(!empty($assigned_roles))
				{
					if($assigned_roles->adr_role_id !== "")
					{
						$assigned_roles_arr = explode(",", $assigned_roles->adr_role_id);
						foreach($assigned_roles_arr as $single_assigned)
						{
							if(!in_array($single_assigned, $selected_roles))
							{
								array_push($selected_roles,$single_assigned);
							}
						}
					}
				}
			  }
		   }
		   if(!empty($file_ids))
		   {
				foreach($file_ids as $single_file_ids)
				  {
					$single_field = decrypt_link($single_file_ids);
					$assigned_roles = $Attachment_designated_roles::get_single_record('adr_role_id',"adr_paf_id=".$single_field);
					if(!empty($assigned_roles))
					{
						if($assigned_roles->adr_role_id !== "")
						{
							$assigned_roles_arr = explode(",", $assigned_roles->adr_role_id);
							foreach($assigned_roles_arr as $single_assigned)
							{
								if(!in_array($single_assigned, $selected_roles))
								{
									array_push($selected_roles,$single_assigned);
								}
							}
						}
					}
				  }
		   }
            $file_list= array_merge ($file_ids, $author_file_ids);
            $user_desinated_roles = UserDataTrait::UserConfigdata('production_designated_roles');
            $production_roles = $Roles::get_all_records('role_id,role_name, role_assigned_role', 'role_assigned_role IN ("' . implode('","', $user_desinated_roles['production_designated_roles']) . '")');
			$data['selected_roles'] = $selected_roles;
		    $data['production_designated_roles'] = $production_roles;
			$data['author_stage_fileids'] = $author_file_ids;
			$data['file_ids'] = $file_ids;
            $data['selected_role_id_list'] = $role_id_list;
			//$table_body = $this->load->view('production_view/template/tmpl_attach_assigned_roles', $data, true);
			//$return_arr['assigned_roles']=$table_body;
			//$footer_btn=$this->load->view('production_view/template/tmpl_attach_role_designated_btn_list',$data, true);
			//$return_arr['footer_btn']=$footer_btn;
            return  $this->success('Success',200, $data);
        } catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }
	}
    public function save_attachment_role_designation(Request $request)
	{
		try
		{
            /*$validator = Validator::make($request->all(), [
                //'author_fileids' => 'required',
                //'fileids' => 'required',
                'role_ids'=> 'required',
                'art_id'=>'required'

            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }*/
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Production_attachment_files_table = ($Production_attachment_files)->getTable();
            $Attachment_files = new \App\Models\Attachment_files();
            $Attachment_files_table = ($Attachment_files)->getTable();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Attachment_designated_roles_table = ($Attachment_designated_roles)->getTable();

			$author_file_ids = $request->author_fileids;
			$stage_file_ids = $request->prod_fileids;
		    $role_ids = $request->role_ids;
			$article_id = $request->art_id;
			$author_file_id_array = $author_file_ids;
			$stage_file_id_array = $stage_file_ids;

			$role_id_list = array();
			if(!empty($role_ids))
			{

				foreach($role_ids as $role)
				{
					$role_id_list[]= decrypt_link($role);
				}
			}
			if(!empty($author_file_id_array))
			{
				$auth_file_ids=array();
				foreach($author_file_id_array as $auth_files)
				{
					$auth_file_ids[] = decrypt_link($auth_files);
				}
				if(!empty($auth_file_ids))
				{
					foreach($auth_file_ids as $auth_file)
					{
						$condition = 'adr_atmnt_id = '.$auth_file;
					    $check_attachment_desig_roles = $Attachment_designated_roles::get_single_record('adr_id,adr_role_id', $condition);
                        if(!empty($check_attachment_desig_roles))
                        {
                            $attach_role_idlist = array();
                            $attach_role_idlist = explode(",",$check_attachment_desig_roles->adr_role_id);
                           // $array_list_authids = array_unique (array_merge ($attach_role_idlist, $role_id_list));
                           $array_list_authids=$role_id_list;
                            $attach_role_ids = implode(',',$array_list_authids);
                            $data_update = array(
                            'adr_role_id' => $attach_role_ids);
                            $update_condition ='adr_id = '.$check_attachment_desig_roles->adr_id;
                            $update_designated_id = $Attachment_designated_roles::update_record($data_update, $update_condition);
                        }
                        else
                        {
                            $attach_role_ids = implode(',',$role_id_list);
                            $data = array(
                                'adr_atmnt_id' => $auth_file,
                                'adr_role_id' => $attach_role_ids,
                                'adr_submitted_type' => 'as',
                            );
                            $attach_designated_id = $Attachment_designated_roles::insert_record($data);
                        }

					}
				}

			}
			if(!empty($stage_file_id_array))
			{
				$stage_file_ids = array();
				foreach($stage_file_id_array as $stagefiles)
				{
					$stage_file_ids[] = decrypt_link($stagefiles);
				}

				if(!empty($stage_file_ids))
				{
                     foreach($stage_file_ids as $stage_file)
					{
						$condition = 'adr_paf_id = '.$stage_file;
					    $check_attachment_desig_roles = $Attachment_designated_roles::get_single_record('adr_id,adr_role_id', $condition);
                        if(!empty($check_attachment_desig_roles))
                        {
                            $attach_role_idlist = array();
                            $attach_role_idlist = explode(",",$check_attachment_desig_roles->adr_role_id);
                          //  $array_list_stageids = array_unique (array_merge ($attach_role_idlist, $role_id_list));
                            $array_list_stageids=$role_id_list;
                            $attach_role_ids = implode(',',$array_list_stageids);

                            $data_update = array(
                                'adr_role_id' => $attach_role_ids
                            );
                            $update_condition = 'adr_id = '.$check_attachment_desig_roles->adr_id;
                            $update_designated_id = $Attachment_designated_roles::update_record($data_update, $update_condition);
                        }
                        else
                        {
                            $attach_role_ids = implode(',',$role_id_list);
                            $data = array(
                                'adr_paf_id' => $stage_file,
                                'adr_role_id' => $attach_role_ids,
                                'adr_submitted_type' => 'ps',
                            );
                            $attach_designated_id = $Attachment_designated_roles::insert_record($data);
                        }

					}
				}
			}
            return  $this->success('Success',200, []);
        } catch (\exception $e) {

            return $this->failure('Failed',200, $e);
        }
	}
    public function update_attach_role_designation(Request $request)
	{
		try
		{
            $validator = Validator::make($request->all(), [
                'adr_id' => 'required',
                'role_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Attachment_designated_roles_table = ($Attachment_designated_roles)->getTable();
            $adr_id = decrypt_link($request->adr_id);
            $role_id = decrypt_link($request->role_id);
            $condition = 'adr_id = '.$adr_id;
            $check_attachment_desig_roles = $Attachment_designated_roles::get_single_record('adr_id,adr_role_id', $condition);
            if(!empty($check_attachment_desig_roles))
            {
                if(isset($check_attachment_desig_roles->adr_role_id)&&($check_attachment_desig_roles->adr_role_id!=''))
                {
                    $array_designated_roles = explode(',',$check_attachment_desig_roles->adr_role_id);
                    if (($key = array_search($role_id, $array_designated_roles)) !== false) {
                        unset($array_designated_roles[$key]);
                        $role_id_list = implode(',',$array_designated_roles);
                        $data_update = array('adr_role_id' => $role_id_list);
                        $update_condition = 'adr_id = '.$check_attachment_desig_roles->adr_id;
                        $update_designated_id = $Attachment_designated_roles::update_record($data_update, $update_condition);
                        return  $this->success('Success',200, []);
                    }
                }
            }
        } catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }

	}
    function stage_based_upload_production_file(Request $request)
	{
        try
        {
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'stage_id' => 'required',
                'art_file_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $art_id = decrypt_link($request->art_id);
            $stage_id = decrypt_link($request->stage_id);
            $file_id = decrypt_link($request->art_file_id);

            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Production_attachment_files_table = ($Production_attachment_files)->getTable();
            $Articles = new \App\Models\Articles();
            $Articles_table = ($Articles)->getTable();
            $Generic_flows = new \App\Models\Generic_flows();
            $Generic_flows_table = ($Generic_flows)->getTable();
            $Article_flow = new \App\Models\Article_flow();
            $Article_flow_table = ($Article_flow)->getTable();
            $Article_types = new \App\Models\Article_types();
            $Article_types_table = ($Article_types)->getTable();
            $article_data =Articles::get_single_record('art_artp_id','art_id='.$art_id);
            $art_type_id = $article_data->art_artp_id;
            $article_type_data = $Article_types::get_single_record('artp_id,artp_fwm_id,artp_jnl_id,artp_abbr_article_type', 'artp_id='.$art_type_id);

            $criteria = 'aflw_art_id ='.$art_id.' AND jwf_id='.$stage_id;
            $select = 'aflw_id,jwf_id,jwf_stage_name,jwf_stage_type,jwf_assignment,aflw_art_id as art_id';
            $table_join = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                        $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', "left"),
                    )
            );
            $art_stage_details = Article_flow::get_results_using_joins($table_join, $select ,$criteria);
			$data['art_stage_details'] = $art_stage_details;
	    	$data['art_type_data'] = $article_type_data;
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);

            $stage_type = $art_stage_details[0]->jwf_stage_type;

			$data['allow_file_types'] = 'zip,pdf';
			$data['allow_file_size'] = 20;
			if(isset($review_flow[$stage_type]['upload']))
			{
				$data['allow_file_types'] = implode(',', $review_flow[$stage_type]['upload']);
				// $data['allow_file_size'] = $this->utility->rvt_upload_file_sizes['production_mng_each_attachment'];

                $allow_file_size = UtilityTrait::Utility('rvt_upload_file_sizes')['rvt_upload_file_sizes'];
                $data['allow_file_size'] = $allow_file_size['production_mng_each_attachment'];
			}
            if(isset($file_id)&&$file_id!='')
			{
				$production_file_details = $Production_attachment_files::get_single_record('paf_id,paf_file_name', 'paf_id='.$file_id);
				$data['pro_file_details'] = $production_file_details;
				$data['updated_upload'] = true;
				// $return_arr['upload_contents'] = $this->load->view('production_view/template/tmpl_replace_production_uploads', $data, true);
			}
			else
			{
				$data['updated_upload']=false;
				// $return_arr['upload_contents'] = $this->load->view('production_view/template/tmpl_additionupload_section_file_inventry', $data, true);
			}
			return  $this->success('Success', 200, $data);
        } catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }
	}
	public function get_payment_details(Request $request)   // payment form
	{
        try {
            $post_data = $request->all();
            $article_id = decrypt_link($post_data['article_id']);
            $jnl_id = decrypt_link($post_data['jnl_id']);
            $data = array();
            $cond = "pmt_ord_art_id={$article_id} ";
            $Payment_order = new \App\Models\Payment_order();
            $Payment_discounts=new \App\Models\Payment_discounts();
            $Payment_order_table = ($Payment_order)->getTable();
            $Payment_discounts_table = ($Payment_discounts)->getTable();
            $payment_orders = $Payment_order::get_single_record('*', $cond);

            $payment_discounts_array = array();
            if (!empty($payment_orders))
            {
                $criteria = 'pmt_ord_art_id ='.$article_id;
                $select = 'pmt_disc_type,pmt_disc_display_value,pmt_disc_amount';
                $table_join = array(
                        'main_table' => $Payment_order_table,
                        'join_table' => array(
                            $Payment_discounts_table => array($Payment_discounts_table . '.pmt_disc_payment_id', $Payment_order_table . '.pmt_ord_id'),
                        )
                );
                $payment_discounts_array = $Payment_discounts::get_results_using_joins($table_join, $select ,$criteria,'all');
                $order_status = '';
			    $color_class = '';
                if (isset($payment_orders->pmt_transaction_status))
                {
                    if ($payment_orders->pmt_transaction_status == 'CC')
                    {
                        $order_status = 'Invoice generated';
                        $color_class = 'text-primary';
                    }
                    elseif ($payment_orders->pmt_transaction_status == 'FN')
                    {
                        $order_status = 'Payment completed';
                        $color_class = 'text-success';
                    }
                    elseif ($payment_orders->pmt_transaction_status == 'CL')
                    {
                        $order_status = 'Cancelled';
                        $color_class = 'text-danger';
                    }
                }if (isset($payment_orders->pmt_ord_manuscript_posted_date))
                {
                    $Journal_settings = new \App\Models\Journal_settings;
                   // $jnl_date_format = $Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
                   // $date_format = $this->date_format_map($jnl_date_format);
                   $date_format=$this->get_platform_date_format($jnl_id);
                    $date_time = explode(" ", $payment_orders->pmt_ord_manuscript_posted_date);
                    $paydate = $date_time[0];
                    $paytime = $date_time[1];
                    if (isset($paydate) && isset($paytime) && isset($date_format))
                    {
                        $payment_orders->pmt_ord_manuscript_posted_date = date($date_format, strtotime($paydate)) . " " . $paytime;
                    }

                }
                $payment_orders->color_class = $color_class;
			    $payment_orders->order_status = $order_status;
            }

            $data['payment_order'] = $payment_orders;
		    $data['payment_discounts'] = $payment_discounts_array;
            return  $this->success('Success', 200, $data);
        }catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }
    }

    public function get_static_form_details_attachment(Request $request)   // copyright attachment
	{

        try {
            $post_data = $request->all();
            $article_id = decrypt_link($post_data['article_id']);
            $type = $post_data['type'];
            $jnl_id = $post_data['jnl_id'];
            $jnl_code = $post_data['jnl_code'];
            $return_array=array();
            if ($type == 'action_form_copyright' || $type == 'completed_copyright') {
				$flow_id = decrypt_link($post_data['flow']);

                $Journal_settings = new \App\Models\Journal_settings();
                $Copyright = new \App\Models\Copyright();
                $Copyright_master = new \App\Models\Copyright_master();

                $Journal_settings_table = ($Journal_settings)->getTable();

                $jrnl_license_mode = $Journal_settings::get_single_record('jset_license_type',"jset_jnl_id={$jnl_id}")->jset_license_type;

                $cprt_condition = "crt_aflw_id={$flow_id} ";

                if ($type == 'action_form_copyright') {
				    if ($jrnl_license_mode != 'all') {
                        $cprt_condition .=" and crtm_payment={$jrnl_license_mode}" ;
				    }
			    }

                $date_format = $this->get_platform_date_format($jnl_id);
                $date_format= date_format_map($date_format);

                if ($this->current_client->functionality->cfty_hide_date_in_copyright == "n") {
                    $copyright = $Copyright::get_copyright($cprt_condition, '*, DATE_FORMAT(crt_date,"' . $date_format . '") as crt_date');
                } else {
                    $copyright = $Copyright::get_copyright($cprt_condition, '*, "" as crt_date');
                }
                $data['show_fee_waiver_requests'] = $this->current_client->functionality->cfty_fee_waiver_requests;

                if ($type == 'action_form_copyright') {
                    $return_array['cfty_enable_copyright_attachment'] = $this->current_client->functionality->cfty_enable_copyright_attachment;
                    $copyright_crtm_payment = '';
                    $jnl_copyright_license = array();
                    $copyright_types = array();
                    $copyright_licenses = $Copyright_master::get_all_records();
                    $jnl_licenses_id = $Journal_settings::get_single_record('jset_license_id',"jset_jnl_id={$jnl_id}");
                    $return_array['copyright'] = $copyright;
                    $return_array['aflw_id'] = $flow_id;
                    //$data['jnl_data'] = $this->jnl_data;// to do later
                    $return_array['jrnl_license_mode'] = $jrnl_license_mode;
                    $return_array['copyright_licenses'] = $copyright_licenses;
                    if ($jnl_licenses_id->jset_license_id != null) {
                        $jnl_copyright_license = json_decode($jnl_licenses_id->jset_license_id);
                        $copyright_types = $Copyright_master::get_copyright_types('crtm_payment,count(`crtm_id`) as license_cnt', $jnl_copyright_license);
                        if (count($jnl_copyright_license) == 1) {
                            $copyright_crtm_payment = $copyright_types[0]->crtm_payment;
                        }
                    }


                    $return_array['jnl_copyright_licenses'] = $jnl_copyright_license;
                    $return_array['copyright_crtm_payment'] = $copyright_crtm_payment;
                    $return_array['copyright_types'] = $copyright_types;
                    $return_array['art_id'] = $article_id;
                    $return_array['hide_date'] = $this->current_client->functionality->cfty_hide_date_in_copyright;
                    $copyright_mode_array=$this->Utility('copyright_mode_array');
                    $return_array['copyright_mode'] = $copyright_mode_array['copyright_mode_array'];
                    $return_array['content_exists'] = (!empty($copyright)) ? true : false;
                    return  $this->success('Success', 200, $return_array);
                }

		}

        } catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
		}
	}

	public function get_static_form_details(Request $request) { // copy right form
        try {
            $validator = Validator::make($request->all(), [
                'jnl_code' => 'required',
                'article_id' => 'required',
                'flow' => 'required',
                'type' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $post_data = $request->all();

            //print_r($post_data);die;
            $article_id = isset($post_data['article_id'])?decrypt_link($post_data['article_id']):'';
            $type = isset($post_data['type'])?decrypt_link($post_data['type']):'';
            $flow_id = isset($post_data['flow'])?decrypt_link($post_data['flow']):'';
            $jnl_id = isset($post_data['jnl_id'])?decrypt_link($post_data['jnl_id']):'';
            $jnl_code = isset($post_data['jnl_code'])?decrypt_link($post_data['jnl_code']):'';
            $existrecord =$this->checkValidRecord($article_id, $flow_id,$jnl_code);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $return_array=array();


            $input_arr = array('input' => $jnl_id,'type'=> 'number');
            $jnl_id_validate = $this->Rv_validator($input_arr);


            $input_arr = array('input' => $jnl_code);
            $jnl_code_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $flow_id,'type'=> 'number');
            $flow_id_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $article_id,'type'=> 'number');
            $art_id_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $type);
            $type_validate = $this->Rv_validator($input_arr);

        if($jnl_id_validate==true && $jnl_code_validate==true && $flow_id_validate==true && $art_id_validate==true && $type_validate==true ){

            if ($type == 'action_form_copyright' || $type == 'completed_copyright') {
            $Journal_settings = new \App\Models\Journal_settings();
            $copyright_table = new \App\Models\Copyright();
            $Copyright_master = new \App\Models\Copyright_master();

            $Journal_settings_table = ($Journal_settings)->getTable();

			$jrnl_license_mode = $Journal_settings::get_single_record('jset_license_type',"jset_jnl_id={$jnl_id}")->jset_license_type;

			$cprt_condition = "crt_aflw_id={$flow_id} ";

			if ($type == 'action_form_copyright') {
				if ($jrnl_license_mode != 'all') {
                    $cprt_condition .=" and crtm_payment='{$jrnl_license_mode}'" ;
				}
			}
            $date_format = $this->get_platform_date_format($jnl_id);
            $date_format= date_format_map($date_format);

			if ($this->current_client->functionality->cfty_hide_date_in_copyright == "n") {
				$copyright = $copyright_table::get_copyright($cprt_condition, '*,crt_date as crt_date_orginal, DATE_FORMAT(crt_date,"' . $date_format . '") as crt_date');
			} else {
				$copyright = $copyright_table::get_copyright($cprt_condition, '*,"" as crt_date_orginal, "" as crt_date');
			}
			$return_array['show_fee_waiver_requests'] = $this->current_client->functionality->cfty_fee_waiver_requests;
            $return_array['upload_file_size_config']=$this->get_uploaded_file_size_config();
			if ($type == 'action_form_copyright') {
				$return_array['cfty_enable_copyright_attachment'] = $this->current_client->functionality->cfty_enable_copyright_attachment;
				/* print "<pre>"; print_r($copyright); */
				$copyright_crtm_payment = '';
				$jnl_copyright_license = array();
				$copyright_types = array();
                //
				$copyright_licenses = $Copyright_master::get_all_records();
                $cfty_copyright_upload = $this->current_client->functionality->cfty_copyright_upload;
                //$filepathfolder=$this->get_upload_data('copyright_licence') .'/'.$this->current_client->clnt_client_code;
                $filepathfolder = 'storage/uploads/copyright_licence/'.$this->current_client->clnt_client_code;
                $copyright_licenses->map(function ($copyright, $index) use($cfty_copyright_upload,$filepathfolder) {
                    $copyright->crtm_textBit = 0;
                    $copyright->crtm_uploadBit = 0;
                    if($cfty_copyright_upload == 'y'){
                        $path = $filepathfolder . '/' . $copyright->crtm_id .'.pdf';
                        $copyright->crtm_uploadBit = (file_exists($path))?1:0;
                    }else{
                        if($copyright->crtm_license_content!=""){
                            $copyright->crtm_textBit = 1;
                        }
                    }
                    return $copyright;
                });
				$jnl_licenses_id = $Journal_settings::get_single_record('jset_license_id',"jset_jnl_id={$jnl_id}");
				$return_array['copyright'] = (count($copyright)>0)?$copyright[0]:[];
				$return_array['aflw_id'] = $flow_id;
				//$data['jnl_data'] = $this->jnl_data;// to do later
				$return_array['jrnl_license_mode'] = $jrnl_license_mode;
				$return_array['copyright_licenses'] = $copyright_licenses;
                //print_r($jnl_licenses_id->jset_license_id);die;
				if ($jnl_licenses_id->jset_license_id != null) {
					$jnl_copyright_license = json_decode($jnl_licenses_id->jset_license_id);
					$copyright_types = $Copyright_master::get_copyright_types('crtm_payment,count(`crtm_id`) as license_cnt', $jnl_copyright_license);
                    if (count($jnl_copyright_license) == 1) {
						$copyright_crtm_payment = $copyright_types[0]->crtm_payment;
					}
				}

				$return_array['jnl_copyright_licenses'] = $jnl_copyright_license;
				$return_array['copyright_crtm_payment'] = $copyright_crtm_payment;
				$return_array['copyright_types'] = $copyright_types;
				$return_array['art_id'] = $article_id;
				$return_array['hide_date'] = $this->current_client->functionality->cfty_hide_date_in_copyright;
                $copyright_mode_array=$this->Utility('copyright_mode_array');
	            $return_array['copyright_mode'] = $copyright_mode_array['copyright_mode_array'];
				$return_array['content_exists'] = (count($copyright)>0) ? true : false;
                return  $this->success('Success', 200, $return_array);
			} else {
				$copyright_details = array();
				$copyright_pdf_view = '';
				$copyright_pdf_attachment ='';
				$attachment_name='';
				$copyright_found = 'not_found';
                $copyright = (count($copyright)>0)?$copyright[0]:[];
                $current_user = $this->get_current_user_details();
				if (!empty($copyright)) {
					$copyright_details = $Copyright_master::get_single_record('crtm_license_name,crtm_license_details',"crtm_id={$copyright->crt_crtm_id}");
                    $copyright_pdf_view = $this->encrypt_data($copyright->crt_id);
                    $return_array['copyright_pdf_view'] = $copyright_pdf_view;
					if(!empty($copyright->copy_location) && !empty($copyright->copy_att_name)) {
					$copyright_pdf_attachment = $this->encrypt_data('path=' . $copyright->copy_location . $copyright->copy_att_name . '&view=true');
                    $return_array['copyright_pdf_attachment'] = $copyright_pdf_attachment;
					$attachment_name=$copyright->copy_att_name;
					}
					$copyright_path_find = $copyright_table::get_copyright_wtih_article($copyright->crt_id);
                    $copyright_path_find = (count($copyright_path_find)>0)?$copyright_path_find[0]:[];
					$pdf_path_copy = $copyright_path_find->art_article_upload_path;
					$download_path_copy ='uploads/' . $pdf_path_copy . '/' . $copyright_path_find->art_copyright_pdf_name;
					if(file_exists($download_path_copy)) {
						$copyright_found = 'found';
					}
				}

				$return_array['hide_date'] = $this->current_client->functionality->cfty_hide_date_in_copyright;
				$return_array['copyright'] = $copyright;
				$return_array['copyright_details'] = $copyright_details;
                $is_blinded = false;
				if (!empty($copyright) && isset($copyright->crt_posted_by) && $copyright->crt_posted_by == $current_user['user_id']) {
                    $array_data['flag']=true;
                    $array_data['availability'] = true;
                    $array_data['save_coauthor'] = false;
                    $array_data['remove_user'] = false;
                    $array_data['source'] = false;
                    $array_data['salutation'] = true;
                    $array_data['flag_only'] = false;
                    $array_data['inactive_user']=false;
                    $array_data['fullname_only']=false;
                    $array_data['user_id'] =  $copyright->crt_posted_by;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['jnl_code'] = $jnl_code;
                    $array_data['article_id'] = $article_id;
                    $return_array['filled_by'] = $this->get_user_display_name($array_data, $is_blinded);
				} else {
                    $array_data['flag']=true;
                    $array_data['availability'] = true;
                    $array_data['save_coauthor'] = false;
                    $array_data['remove_user'] = false;
                    $array_data['source'] = false;
                    $array_data['salutation'] = true;
                    $array_data['flag_only'] = false;
                    $array_data['inactive_user']=false;
                    $array_data['fullname_only']=false;
                    $array_data['user_id'] =  $copyright->crt_posted_by;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['jnl_code'] = $jnl_code;
                    $array_data['article_id'] = $article_id;
                    $return_array['filled_by'] = $this->get_user_display_name($array_data, $is_blinded);
				}
				$return_array['attachment_name'] = $attachment_name;
				$return_array['view_attachment_pdf'] = $copyright_pdf_attachment;
				$return_array['view_licence_pdf'] = $is_blinded ? '' : $copyright_pdf_view ;
				$return_array['copyright_found'] = $copyright_found;
                $return_array['copyright_pdf_view'] = $is_blinded ? '' : $copyright_pdf_view ;
                return  $this->success('Success', 200, $return_array);
			}
		}
    }
    else {
        $res['msg']=customTrans('auth.invalid_data');
        return $this->warning('Warning',200,$res,'warning');
    }

        } catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
    }

    //*** get all production files for a stage according to the permission starts */
    public function get_productionfile($aflw_id,$core_role,$roleid,$date_format,$art_id,$type)
    {
        $this->current_user = $this->get_current_user_details();

        $permission_to_designate_roles=true;
        $manage_role=main_production_roles();

        if($type=='production')
        $art_criteria="paf_art_id = '" . $art_id ."' and aflw_id='".$aflw_id."'  AND aflw_status IN('c')";
        else
        $art_criteria = 'atmnt_art_id =' . $art_id . ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1 ';
        if (!in_array($core_role, $manage_role)) {
        $art_criteria.=" AND  (FIND_array_intersect('".$roleid."',adr_role_id) = 1";
        $art_criteria.=' OR aflw_usr_id='.$this->current_user['user_id'].')';
        $permission_to_designate_roles=false;
        }
        if($type=="production")
        {
            $group_by='';
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Production_attachment_files_table = ($Production_attachment_files)->getTable();
            $Generic_flows = new \App\Models\Generic_flows();
            $Generic_flows_table = ($Generic_flows)->getTable();
            $Article_flow = new \App\Models\Article_flow();
            $Article_flow_table = ($Article_flow)->getTable();
            $Articles = new \App\Models\Articles();
            $Articles_table = ($Articles)->getTable();
            //$Attachment_files = new \App\Models\Attachment_files();
            //$Attachment_files_table = ($Attachment_files)->getTable();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Attachment_designated_roles_table = ($Attachment_designated_roles)->getTable();
            $Attachment_file_description = new \App\Models\Attachment_file_description();
            $Attachment_file_description_table = ($Attachment_file_description)->getTable();
            //DB::enableQueryLog();
            $table_join = array(
                'main_table' => $Production_attachment_files_table,
                'join_table' => array(
                            $Article_flow_table => array($Article_flow_table . '.aflw_id', $Production_attachment_files_table . '.paf_aflw_id', "left"),
                            $Generic_flows_table => array($Generic_flows_table . '.jwf_id', $Article_flow_table . '.aflw_jwf_id', "left"),
                            $Articles_table => array($Articles_table . '.art_id', $Production_attachment_files_table . '.paf_art_id', "left"),
                            $Attachment_designated_roles_table => array($Attachment_designated_roles_table . '.adr_paf_id', $Production_attachment_files_table . '.paf_id', "left"),
                            $Attachment_file_description_table => array($Attachment_file_description_table . '.afdec_id', $Production_attachment_files_table . '.paf_description_id', "left")
                )
            );
            $select='paf_id,paf_art_id,paf_aflw_id,jwf_stage_name,jwf_id,paf_file_name,paf_document_size,paf_designated_to,paf_posted_by,DATE_FORMAT(paf_posted_date, "' . $date_format . '") as uploaded_date,art_article_upload_path,adr_role_id as designated_roles,adr_id,afdec_description';
        }
        else{
            $group_by='atmnt_id';

            $Attachment_files = new \App\Models\Attachment_files();
            $Attachment_files_table = ($Attachment_files)->getTable();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Attachment_designated_roles_table = ($Attachment_designated_roles)->getTable();
            $Attachment_file_description = new \App\Models\Attachment_file_description();
            $Attachment_file_description_table = ($Attachment_file_description)->getTable();

            //DB::enableQueryLog();
            $Article_flow = new \App\Models\Article_flow();
            $Article_flow_table = ($Article_flow)->getTable();
            $table_join = array(
                'main_table' => $Attachment_files_table,
                'join_table' => array(
                            $Article_flow_table => array($Article_flow_table . '.aflw_id', $Attachment_files_table . '.atmnt_aflw_id', "left"),
                            $Attachment_designated_roles_table => array($Attachment_designated_roles_table . '.adr_atmnt_id', $Attachment_files_table . '.atmnt_id', "left"),
                            $Attachment_file_description_table => array($Attachment_file_description_table . '.afdec_id', $Attachment_files_table . '.atmnt_label', "left")
                )
            );
            $select="atmnt_id as paf_id,
            atmnt_art_id as paf_art_id,
            atmnt_aflw_id as paf_aflw_id,
            'article_submission' as jwf_stage_name,
            '' as jwf_id,
            atmnt_file_name as paf_file_name,
            atmnt_document_size as paf_document_size,
            '' as paf_designated_to,
            atmnt_posted_by as paf_posted_by,
            DATE_FORMAT(atmnt_posted_date, '" . $date_format . "') as uploaded_date,
            atmnt_orginal_upload_path as art_article_upload_path,
            GROUP_CONCAT(adr_role_id) AS designated_roles,
            afdec_description,
            atmnt_orginal_upload_path,
            adr_id";
        }
        $attachments = Article_flow::get_results_using_joins($table_join, $select,$art_criteria, 'all',null,null,'',null,null,false,$group_by);
        //$query = DB::getQueryLog();
		//dd($query); die;

        $attachment_array['attachments']=$attachments;
        $attachment_array['permission_to_designate_roles']=$permission_to_designate_roles;
        return $attachment_array;
    }
    //*** get all production files for a stage ends */

    public function get_production_attachfile(Request $request)
    {
       try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnlcode' => 'required',
                'art_id' => 'required',
                'article_flow_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $jnlcode =  isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']):'';
            $art_id = isset($post_data['art_id']) ? $this->decrypt_data($post_data['art_id']) : '';
            $art_flow_id = isset($post_data['article_flow_id']) ? $this->decrypt_data($post_data['article_flow_id']) : '';
            $role_id = isset($post_data['role_id']) ? $this->decrypt_data($post_data['role_id']) : '';
            $core_role = isset($post_data['core_role']) ? $post_data['core_role'] : '';
            $existrecord =$this->checkValidRecord($art_id, $art_flow_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            //$platform_id = $platform_data->jnl_id;
            $date_format = static::date_format_map($platform_data->jset_date_format);

            $attachment_array=$this->get_productionfile($art_flow_id,$core_role,$role_id,$date_format,$art_id,"article");

            $production_roles=[];
            if ((isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y'))
            {
            $user_desinated_roles = $this->UserConfigdata('production_designated_roles');
            $criteria4='role_assigned_role  IN("' . implode('","', $user_desinated_roles['production_designated_roles']) . '")';
            $production_roles= Roles::get_all_records('role_id,role_name,role_assigned_role',$criteria4);
            }
            $attachment_array['production_roles'] = $production_roles;
            $article_details = Articles::get_single_record('art_code', 'art_id='.$art_id);
            if(!empty($article_details) && isset($article_details->art_code))
            {
                $attachment_array['article_code'] = $article_details->art_code;
            }
            return  $this->success('Success',200, $attachment_array);
        } catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }
    }
    //*** get all production files for a stage according to the permission ends */

    //*** transfer article from one journal to another or another article type in privilaged user section */
    public function transfer_article(Request $request)
	{
        try {

            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_type' => 'required',
                'jnlcode' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $return_arr = array(
                'status' => 'failed',
                'msg' =>  customTrans('viewarticle.invalid_data')
            );
            $article_dst_type =  isset($post_data['article_type']) ? $post_data['article_type']:'';
            $jnlcode =  isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']):'';
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $bypass_flag = false;
            $Article_types = new \App\Models\Article_types();
            $Journal_settings = new \App\Models\Journal_settings();
            if($article_dst_type != '')
            {
            $Generic_flows = new \App\Models\Generic_flows();
            
            $destination_fwm_id = $Article_types::get_single_record('artp_fwm_id,artp_article_type',"artp_id={$article_dst_type}");
            $destination_role_details = $Generic_flows::get_single_record('jwf_role_id',"jwf_fwm_id={$destination_fwm_id->artp_fwm_id} and jwf_stage_type='transit' ");
            if($destination_role_details->jwf_role_id == null)
            {
                $msg = str_replace('%Article type%', $destination_fwm_id->artp_article_type, customTrans('viewarticle.destination_stage_role_warning'));
                $Journals = new \App\Models\Journals();
                $jnl_name   =    $Journals::get_single_record('jnl_journal_name', "jnl_id={$post_data['journal']}");
                $return_arr['msg'] = str_replace('%Journal%', $jnl_name->jnl_journal_name, $msg);
                return  $this->warning('Warnings',200,$return_arr,'warning');
            }
            }
            if($post_data['article_data'] == 2 && $post_data['article_type'] != '' && (!isset($post_data['stage']) || (isset($post_data['stage']) && $post_data['stage'] == '')))
            {
                $artp_res = $Article_types::get_single_record('artp_fwm_id','artp_id=:article_dst_type',null,'',null,array('article_dst_type'=>$article_dst_type));
                if(!empty($artp_res))
                {
                    if($platform_data->jnl_fwm_id == $artp_res->artp_fwm_id)
                    {
                        $bypass_flag = true;
                    }
                }
            }

		if (isset($post_data['article_type']) && $post_data['journal'] != '' && $post_data['article_type'] != '' && $post_data['article_id'] != '' && isset($post_data['author_notes']) && $post_data['author_notes'] != '' && isset($post_data['article_data']) && ($post_data['article_data'] == 1 || ( $post_data['article_data'] == 2 && ((isset($post_data['stage']) &&$post_data['stage'] != '' ) || $bypass_flag == true)) ) && isset($post_data['ats_src_jnl']) && $post_data['ats_src_jnl'] != ''  && isset($post_data['ats_src_flwid']) && $post_data['ats_src_flwid'] != '')
		{
            $src_jnl = decrypt_link($post_data['ats_src_jnl']);
			$src_jnl_code = decrypt_link($post_data['ats_src_jnl_code']);
			//$src_artp = decrypt_link($post_data['ats_src_artp']);
			$src_flwid = decrypt_link($post_data['ats_src_flwid']);
            $article_id = decrypt_link($post_data['article_id']);
            $articletypedata = Articles::get_single_record('art_artp_id','art_id=:art_id',null,'',null,array('art_id'=>$article_id));
            $src_artp= $articletypedata->art_artp_id;

            $arttype_record=$Article_types::get_single_record('artp_id,artp_jpm_id,artp_fwm_id','artp_id=:art_artp_id',null,'',null,array('art_artp_id'=>$src_artp));
            $source_role_details = $Generic_flows::get_single_record('jwf_role_id',"jwf_fwm_id={$arttype_record->artp_fwm_id} and jwf_stage_type='transit' ");
            if($source_role_details->jwf_role_id == null)
            {
                $return_arr['msg'] = customTrans('viewarticle.source_stage_role_warning');
                return  $this->warning('Warnings',200,$return_arr,'warning');
            }
            $review_data = Article_flow::get_generic_flow('jwf_stage_type','aflw_id='.$src_flwid);
            $review_data->art_id=$article_id;
            $review_data->artp_id = $src_artp;
            $review_data->artp_fwm_id = $arttype_record->artp_fwm_id;
            $article_privilages = $this->article_privilages($review_data, $src_flwid, $jnlcode);
            $privileged_user = $article_privilages['privilaged'];
            $isauthor = $article_privilages['author'];
            $isreviewer=$article_privilages['reviewer'];
            $user_allocated=$article_privilages['user_allocated'];
            if($isauthor==true || ($isreviewer==true && $user_allocated == false))
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }


            $transfer_to_current_jnl = ($platform_data->jnl_id == $post_data['journal']) ? true : false;


			$journal_dst_id = $post_data['journal'];
            $journal_setting_details=$Journal_settings::get_single_record('jset_jnl_id ,jset_author_confirmation_bw_article_types,jset_author_confirmation_jnl',"jset_jnl_id={$journal_dst_id}");

            //echo $journal_dst_id."ddd".$post_data['journal']; die;
			$stage = 0;
			if(isset($post_data['stage']))
			{
				$stage = $post_data['stage'];
			}
			elseif($bypass_flag == true)
			{
				$active_art_stage = Article_flow::get_single_record('aflw_id','aflw_art_id=:article_id and aflw_status=:status',null,'',null,array('article_id'=>$article_id,'status'=>'a'));
				if(!empty($active_art_stage))
				{
					$stage = $active_art_stage->aflw_id;
				}
			}
			$author_notes = $post_data['author_notes'];


			//echo $src_artp.'--'.$article_dst_type; die;

            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
			$submission_types = $Article_type_advance_options::get_all_records('atotp_article_submission_type, atotp_artp_id', 'atotp_artp_id IN( ' . $src_artp . ',' . $article_dst_type . ')');

			if ($src_artp == $submission_types[0]->atotp_artp_id)
			{
				$src_submsn_type = json_decode($submission_types[0]->atotp_article_submission_type);
				$dest_submsn_type = json_decode($submission_types[1]->atotp_article_submission_type);
			}
			else
			{
				$src_submsn_type = json_decode($submission_types[1]->atotp_article_submission_type);
				$dest_submsn_type = json_decode($submission_types[0]->atotp_article_submission_type);
			}
			if ((!in_array("fu", $src_submsn_type)) && in_array("fu", $dest_submsn_type))
			{
				$return_arr['msg'] = customTrans('viewarticle.submission_type_mismatch');
                return $this->warning('Warning', 200, $return_arr);
			}

			//$article_data = Articles::get_article_data($article_id);
            $article_data =Articles::get_single_record('art_submitted_by,art_proxy_id','art_id=:article_id',null,'',null,array('article_id'=>$article_id));
			$submited_user = array(
				'user_id' => $article_data->art_submitted_by,
				'proxy_user_id' => $article_data->art_proxy_id
			);

			$article_flw = $Article_types::get_single_record('artp_fwm_id', 'artp_id=:src_artp',null,'',null,array('src_artp'=>$src_artp));
            $Generic_flows = new \App\Models\Generic_flows();
			$transit_stage_id = $Generic_flows::get_single_record('jwf_id, jwf_tat_complete, jwf_role_id',"jwf_stage_type=:type and jwf_fwm_id=:artp_fwm_id",null,'',null,array('type'=>'transit','artp_fwm_id'=>$article_flw->artp_fwm_id));

			//Article_flow::trans_start();

			$author_without_confirmation = false;
            //#Task-666 Transfer article without author confirmation
			if( $this->current_client->functionality->cfty_allow_transfer_without_au_confirmation == 'y' )
			{
                if($transfer_to_current_jnl == true && $journal_setting_details->jset_author_confirmation_bw_article_types == 'n' )
				{
				  $author_without_confirmation = true;

				}elseif($transfer_to_current_jnl == false && $journal_setting_details->jset_author_confirmation_jnl == 'n')
				{
					$author_without_confirmation = true;
				}

			}
			$flow_user_id = $submited_user['user_id'];
			$flow_status = 'a';
			$transfer_complete_user_role_without_confirmation = 0;
			if($author_without_confirmation == true && ($post_data['article_data'] == 1 || $post_data['article_data'] == 2 ))
			{
                $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
				$flow_user_id = $this->current_user['user_id'];
				$flow_status = 'c';
				$cur_query = 'SELECT  jwf_role_id FROM ' .  $Article_flow_table . '  JOIN ' . $Generic_flows_table. ' ON jwf_id = aflw_jwf_id WHERE aflw_id = :src_flwid';
				$current_stage_role = $Generic_flows::get_records_by_raw_query($cur_query,false,array('src_flwid'=>$src_flwid));
				$transfer_complete_user_role_without_confirmation = (!empty($current_stage_role) && isset($current_stage_role[0]->jwf_role_id)) ? $current_stage_role[0]->jwf_role_id : 0;
			}
			// insert trasit stage to flow table
			$flow_insert_array = array(
				'aflw_jwf_id' => $transit_stage_id->jwf_id,
				'aflw_art_id' => $article_id,
				'aflw_usr_id' => $flow_user_id,
				'aflw_status' => $flow_status,
				'aflw_assigned_date' => date('Y-m-d H:i:s'),
				'aflw_accepted_date' => date('Y-m-d H:i:s')
			);
			// $due_date = new \DateTime(date('Y-m-d H:i:s', time()));
			// $due_date = $due_date->modify('+' . $transit_stage_id->jwf_tat_complete . ' days');
            if(isset($transit_stage_id->jwf_tat_complete) && !empty($transit_stage_id->jwf_tat_complete))
            {
                $due_date = $this->get_due_date_for_article($article_id, $transit_stage_id->jwf_tat_complete);
			    $flow_insert_array['aflw_due_date'] = $due_date;
            }

			if($author_without_confirmation == true)
			{
				$flow_insert_array['aflw_returned_date'] = date('Y-m-d H:i:s');
				$flow_insert_array['aflw_posted_date'] = date('Y-m-d H:i:s');
            }

			$insert_id = Article_flow::insert_record($flow_insert_array, $this->current_user);

			//insert transfer suggestion data in transfer_suggestion table
			$transfer_suggestion = array(
				'ats_art_id' => $article_id,
				'ats_aflw_id' => $insert_id,
				'ats_src_jnl' => $src_jnl,
				'ats_src_artp' => $src_artp,
				'ats_dst_jnl' => $journal_dst_id,
				'ats_dst_artp' => $article_dst_type,
				'ats_dst_stage' => $stage,
				'ats_article_data' => $post_data['article_data'],
				'ats_author_notes' => $post_data['author_notes'],
				'ats_suggested_by' => $this->current_user['user_id'],
				'ats_without_au_confirmation_usr_role' => $transfer_complete_user_role_without_confirmation
			);
            $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
            $Article_transfer_suggestion::insert_record($transfer_suggestion, $this->current_user);
			//Update article to transit stage
//			if($author_without_confirmation == false)
//			{
			$article_update = array(
				'art_status' => 't',
			);
			Articles::update_record($article_update,'art_id='.$article_id, $this->current_user);
			//}

			/*if (Article_flow::trans_complete() === false)
			{
				$return_arr['msg'] = lang('copy_article_err');
			}
			else
			{*/
				$return_arr['status'] = 'success';
				$return_arr['msg'] = customTrans('viewarticle.transfer_article_success');
				//$return_arr['redirect'] = base_url('journal/' . $src_jnl_code);
				$return_arr['without_confirmation'] = $author_without_confirmation;
				$return_arr['art_id'] = encrypt_link($article_id);
			    $return_arr['flow_id'] = encrypt_link($insert_id);
				$return_arr['art_type_id'] = encrypt_link($article_dst_type);
				$return_arr['transfer_mode'] = $post_data['article_data'];
				/*$this->session->set_flashdata('msg', json_encode(array(
					'alert' => 'success',
					'msg' => lang('transfer_article_success'))));
				*/
				//* start -- send email*//
				if($author_without_confirmation == false )
				{
					//Email_templates::trans_start();
                    $Email_templates = new \App\Models\Email_templates();
					$email_template_data = $Email_templates::get_single_record('*',"etmp_name='transfer_article' and etmp_notification= 'User'");
                    if ($email_template_data!='')
					{
                        $Users = new \App\Models\User();
						$user_data = $Users::get_single_record('usr_email,concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id='.$submited_user['user_id']);
						$jnl_settings = $Journal_settings::get_single_record('jset_date_format','jset_jnl_id='.$src_jnl);
                        $custom_data = array(
                            'usr_email'=>$user_data->usr_email,
                            'mail_recipient_ids'=> $submited_user['user_id'],

                             'esl_etmp_action'=>'transfer_article',
                             'transfer_article'=>true,
                             'prev_article_id'=> $article_id,
                             'article_id'=> $article_id,
                             'artp_id'=> $src_artp,
                             'jnl_id'=>$src_jnl,
                             'jnl_code'=>$src_jnl_code,
                             'src_jnl_id'=>$src_jnl,
                             'aflw_id'=>$src_flwid,
                         );
                         $email_data = array(
                             'type' => 'global',
                             'action' => 'send',
                             'email_with_login' => true,
                             'user_id' =>  $submited_user['user_id'],
                             'empt_name' => 'transfer_article',
                             'jnl_user_role'=>array(
                             'core_role'=>'',
                             'role_name'=>'',
                             'jnl_journal_code'=> $src_jnl_code
                         ),
                             'custom_data' => $custom_data
                         );
                         $this->master_email_details($email_data);

					}
					//Email_templates::trans_complete();
				//}
				//* end -- send email*//
			}
		}


        return  $this->success('Success',200, $return_arr);
        } catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }
	}
    //*** transfer article from one journal to another or another article type in privilaged user section ends */

    //*** get all journal names starts */
    public function get_all_journals(Request $request)
    {
        try {

            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($post_data, [
                'article_id' => 'required',
                'type' => 'required',
                //'jnlcode'=> 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $article_id=  isset($post_data['article_id']) ? $this->decrypt_data($post_data['article_id']):'';
            $type=isset($post_data['type']) ? $post_data['type']:'';
            $art_flw_id=  isset($post_data['art_flw_id']) ? $this->decrypt_data($post_data['art_flw_id']):'';
            if($type == 'journal')
            {
                $jnlcode =  isset($post_data['jnlcode']) ? $this->decrypt_data($post_data['jnlcode']):'';
                $platform_data = $this->platform_basic_settings_data($jnlcode);
            $is_stand_alone = ($platform_data->jnl_standalone == 'y') ? true : false;
            $existrecord =$this->checkValidRecord($article_id, $art_flw_id,$jnlcode);
            if($existrecord == false)
            {
                return  $this->warning('Failed', 200, "redirectdashboard");
            }
            $Generic_flows = new \App\Models\Generic_flows();
            $Generic_flows_table = ($Generic_flows)->getTable();
            $Journals_table = (new \App\Models\Journals())->getTable();
			$join_tables = array(
				'main_table' =>$Generic_flows_table,
				'join_table' => array(
					$Journals_table => array($Journals_table . '.jnl_fwm_id',$Generic_flows_table.'.jwf_fwm_id')
			));
           	if ($is_stand_alone == true)
			{
				$jour_id = $platform_data->jnl_id;
				$article_types = $this->get_article_types_for_transfer($jour_id, $article_id);
                $return_arr['article_types']=$article_types;
			}
			else
			{
				$criteria = "jnl_journal_status='y' and jwf_stage_type='production' and jnl_standalone= 'n'";
                if(isset($this->current_client->functionality->cfty_enable_stop_submission_in_journal) && $this->current_client->functionality->cfty_enable_stop_submission_in_journal == "y") {
                    $criteria.=" and jnl_article_submission_status = 'y'";
                }
                $select = 'jnl_id,jnl_journal_name';
                $journals = $Generic_flows::get_results_using_joins($join_tables, $select, $criteria, 'all');
                $return_arr['journals']=$journals;
			}
            $return_arr['is_stand_alone']=$is_stand_alone;

        }
        elseif ($type == 'articletype')
		{
            $jnl_id =  isset($post_data['jnl_id']) ? $this->decrypt_data($post_data['jnl_id']):'';
			$article_types= $this->get_article_types_for_transfer($jnl_id, $article_id);
            $return_arr['article_types']=$article_types;
		}
        $return_arr['es_module'] = $this->current_client->modules->mdl_es_integration;
        return  $this->success('Success',200, $return_arr);
        } catch (\exception $e) {
            return $this->failure('Failed',200, $e);
        }
    }
    //*** get all journal names ends */

    //***  get all article types in a journal neglecting the current article type and their workflow is completed starts */
    public function get_article_types_for_transfer($jnl_id, $article_id)
	{
        $Generic_flows = new \App\Models\Generic_flows();
        $Generic_flows_table = ($Generic_flows)->getTable();
        $Article_types = new \App\Models\Article_types();
        $Article_types_table = ($Article_types)->getTable();
		$join_tables = array(
			'main_table' => $Generic_flows_table,
			'join_table' => array(
				$Article_types_table => array($Article_types_table.'.artp_fwm_id',$Generic_flows_table.'.jwf_fwm_id')
		));

		$article = Articles::get_single_record('art_artp_id','art_id='.$article_id);

		$select = 'artp_id,artp_article_type,jwf_fwm_id,artp_es_document_type';
		$criteria = "artp_jnl_id= {$jnl_id} and artp_id !={$article->art_artp_id} and jwf_stage_type= 'production'";
                #2653 show only article types which its article submission is not stopped (if client fnlty is ON)
                if(isset($this->current_client->functionality->cfty_enable_stop_submission_in_article_type) && $this->current_client->functionality->cfty_enable_stop_submission_in_article_type == 'y') {
                    $criteria.= " and artp_article_submission_status = 'y'";
                }
		$article_types = Generic_flows::get_results_using_joins($join_tables, $select, $criteria, 'all');
		return $article_types;
	}
    //***  get all article types in a journal neglecting the current article type and their workflow is completed ends */

    public function production_upload(Request $request)
    {
        try
        {
            $post_data=$request->all();
            $this->current_user = $this->get_current_user_details();

            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
               // 'art_type_id' => 'required',
                'article_id' => 'required',
                'file' => 'clamav',
                'article_flow_id' => 'required',
                'jnl_code'=>'required'
            ],[
                'file.clamav' => 'The :attribute contains a virus!',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'error' => $validator->errors()->first('file'),
                    'file'=>$post_data['file']->getClientOriginalName(),
                    'type'=>'clamav'
                ], 200);


            }
            $journal_id =isset($post_data['jnl_id'])?$post_data['jnl_id']:'';
			//$articletype_id =$post_data['art_type_id'];
			$article_id =isset($post_data['article_id'])?$post_data['article_id']:'';
			$artflow_id = isset($post_data['article_flow_id'])?$post_data['article_flow_id']:'';
            $attachment_file = isset($post_data['file'])?$post_data['file']:'';
            $jnl_code=isset($post_data['jnl_code'])?$post_data['jnl_code']:'';
            $file_annotate=false;
            if(isset($post_data['pafid']))
            {
                $artpaf_id = $post_data['pafid'];
            }
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();

            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Article_flow = new \App\Models\Article_flow();
            $Generic_flows = new \App\Models\Generic_flows();
            $File_upload_type = new \App\Models\File_upload_type();
            $Required_file_type = new \App\Models\Required_file_type();
            $Attachment_file_description = new \App\Models\Attachment_file_description();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
            $Issue_management = new \App\Models\Issue_management();
            $Articles=new \App\Models\Articles();
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
            $return_array = array();
            $art_flow_table = (new \App\Models\Article_flow)->getTable();
            $generic_flow_table = (new \App\Models\Generic_flows)->getTable();
            $Attachment_files = new \App\Models\Attachment_files();
            $criteria="art_id={$article_id}";
            $article_data=$Articles::get_single_record('art_artp_id',$criteria);
            $articletype_id=$article_data->art_artp_id;
            $tables = array(
                    'main_table' => $art_flow_table,
                    'join_table' => array(
                        $generic_flow_table => array($generic_flow_table . '.jwf_id', $art_flow_table . '.aflw_jwf_id', "join")
                    )
            );
            $condition = "aflw_id={$artflow_id}";
            $current_stage_detials = $Article_flow::get_results_using_joins($tables, "aflw_id,jwf_stage_type,jwf_afdec_ids", $condition, 'single');
            $stage_type = $current_stage_detials->jwf_stage_type;
            $this->reviewflow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow'); 
            if(isset($this->reviewflow[$stage_type]['file_annotate']))
            {
                $file_annotate=$this->reviewflow[$stage_type]['file_annotate'];
            }
            $art_typ_rec = $Article_type_advance_options->get_single_record('atotp_file_type',"atotp_artp_id={$articletype_id}");
            if(!empty($art_typ_rec))
            {
                $art_file_type = implode('|', json_decode($art_typ_rec->atotp_file_type));
            }
            if (isset($article_id) && $article_id != '')
            {
                $article_data = $Articles::get_single_record('art_article_upload_path',"art_id={$article_id}");
                $name = $attachment_file->getClientOriginalName();
                $path = $article_data->art_article_upload_path.DIRECTORY_SEPARATOR . 'production/'.$artflow_id.'/';
                $uploaded_file_details = $this->upload_file_handler($path, $attachment_file, $name);
                if ($uploaded_file_details['error'] == false)
                {
                    //Feature#2549 Select file description for workflow stage.
                    $permitted_file_description = null;
                    if(!empty(json_decode($current_stage_detials->jwf_afdec_ids)))
                    {
                        $permitted_file_description = implode(',',json_decode($current_stage_detials->jwf_afdec_ids));
                    }

                    $file_description_array=$this->get_file_description_values($articletype_id,$name,$permitted_file_description);

                    $file_description_select_id='';
                    $attach_file_description=array();
                    $descrption=array();
                    if(isset($file_description_array['attach_file_description']))
                    {
                        $attach_file_description=$file_description_array['attach_file_description'];
                    }
                    if(isset($file_description_array['production_description']))
                    {
                        $file_description_select_id=$file_description_array['production_description'];
                    }
                    if(isset($file_description_array['file_des_type']))
                    {
                        $descrption=$file_description_array['file_des_type'];
                    }

                    $insert_arr = array(
                        'paf_art_id' => $article_id,
                        'paf_aflw_id' => $artflow_id,
                        'paf_file_name' => $uploaded_file_details['name'],
                        'paf_document_size' => $this->file_size_convert_to_kb($uploaded_file_details['size']),
                        'paf_description_id'=>$file_description_select_id
                    );
                    $attachdesignated_role=array();
                    if(isset($artpaf_id)&&($artpaf_id!=''))
                    {
                        $condition ="paf_id={$artpaf_id}";
                        $attach_file=$Production_attachment_files::get_single_record('paf_file_name',"paf_id={$artpaf_id}");
                        if(!empty($attach_file)) {
                        $path_exist_file = 'uploads/'.$article_data->art_article_upload_path.'/production/'.$artflow_id.'/'.$attach_file->paf_file_name;
                        $path_exist_file = $this->upload_folder_path($path_exist_file);
                        if(file_exists($path_exist_file))
                        {
                            unlink($path_exist_file);
                        }
                        $insert_id = $Production_attachment_files::update_record($insert_arr,$condition,$this->current_user);
                        $attachdesignated_role=$Attachment_designated_roles::get_single_record('adr_id,adr_paf_id',"adr_paf_id={$artpaf_id}");
                        $insert_id=$artpaf_id;
                        } else {
                            $insert_id = $Production_attachment_files::insert_record($insert_arr,$this->current_user);
                        }
                    }
                    else
                    {
                        $insert_id = $Production_attachment_files::insert_record($insert_arr,$this->current_user);
                    }
                    if($file_description_array['deault_desciption_count']==true && ($file_description_select_id!=''))
                    {
                        $description_id="afdec_id={$file_description_select_id}";
                        $description_details=$Attachment_file_description::get_single_record('afdec_id,afdec_viewable_roles', $description_id);
                        $viewable_roles=$description_details->afdec_viewable_roles;
                        $data = array(
                                'adr_paf_id' => $insert_id,
                                'adr_role_id' => $viewable_roles,
                                'adr_submitted_type' => 'ps',
                        );
                        if(!empty($attachdesignated_role))
                        {
                            $updated_array=array('adr_role_id' => $viewable_roles);
                            $designated_condition="adr_id={$attachdesignated_role->adr_id}";
                            $attach_desinated_id = $Attachment_designated_roles::update_record($updated_array,$designated_condition,$this->current_user);
                        }
                        else
                        {
                            $attach_desinated_id = $Attachment_designated_roles->insert_record($data,$this->current_user);
                        }
                        $file_id_arr[] = $insert_id;
                        $insert_arr['paf_id'] = $insert_id;
                        $insert_arr['jnl_code'] = $jnl_code;
                        //$insert_arr['path'] = $uploaded_file_details['name'];
                        //$insert_arr['atmnt_id'] = $insert_id;
                        $insert_arr['file_annotate_permission']=$file_annotate;
                        $insert_arr['production_attach_file_description']=  $attach_file_description;
                        $insert_arr['production_description']=$file_description_select_id;
                        $insert_arr['file_des_type'] = $descrption;
                        $return_array['insert_data'][0] = $insert_arr;
                    }

                }
                else
                {
                    return  $this->warning('Warning', 200, 'Upload failed');
                }

                }
                return  $this->success('Success', 200, $return_array);
        }
        catch (\exception $e) {

            return $this->failure('Failed',200, $e);
        }

    }
    public function get_uploaded_productionfiles(Request $request){
        try{
            $post_data=$request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'flow_id' => 'required',
                'article_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $Articles=new \App\Models\Articles();
            $art_flow_id=$post_data['flow_id'];
            $article_id =$post_data['article_id'];
            if(isset($post_data['attach_id']))
            $attachment_id=$post_data['attach_id'];
            else
            $attachment_id='';
            $criteria="art_id={$article_id}";
            $article_data=$Articles::get_single_record('art_artp_id',$criteria);

            $art_type_id=$article_data->art_artp_id;
           // $art_type_id=$post_data['art_type_id'];
            $Article_type_advance_options = new \App\Models\Article_type_advance_options();
            $Production_attachment_files = new \App\Models\Production_attachment_files();
            $Article_flow = new \App\Models\Article_flow();
            $Generic_flows = new \App\Models\Generic_flows();
            $File_upload_type = new \App\Models\File_upload_type();
            $Required_file_type = new \App\Models\Required_file_type();
            $Attachment_file_description = new \App\Models\Attachment_file_description();
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();

            $production_attach_file_table = (new \App\Models\Production_attachment_files)->getTable();
            $attach_file_description_table=(new \App\Models\Attachment_file_description)->getTable();

            $art_flow_table = (new \App\Models\Article_flow)->getTable();
            $generic_flow_table = (new \App\Models\Generic_flows)->getTable();
                $tablesfirst = array(
                    'main_table' => $art_flow_table,
                    'join_table' => array(
                        $generic_flow_table => array($generic_flow_table . '.jwf_id', $art_flow_table . '.aflw_jwf_id', "join")
                    )
                );
                $condition = "aflw_id={$art_flow_id}";
                $current_stage_detials = $Article_flow::get_results_using_joins($tablesfirst, "aflw_id,jwf_stage_type,jwf_afdec_ids", $condition, 'single');
            $tables = array(
                'main_table' => $production_attach_file_table,
                'join_table' => array(
                    $attach_file_description_table => array($attach_file_description_table . '.afdec_id', $production_attach_file_table . '.paf_description_id', "left")
                )
            );
            $condition = "paf_aflw_id={$art_flow_id}";
            if($attachment_id!=''&&isset($post_data['type'])&&$post_data['type']=='replace-file')
            {
                //$condition .= " AND paf_id={$attachment_id}";
                $condition = "paf_id={$attachment_id}";
            }
            $stage_uploaded_files = $Production_attachment_files::get_results_using_joins($tables, "paf_id,paf_art_id,paf_aflw_id,paf_file_name,paf_designated_to,paf_description_id", $condition, 'all');
//echo '<pre>'; print_r($stage_uploaded_files); die;
            $stage_details=array();
            $file_description_list=array();
                if(!empty($stage_uploaded_files))
                {
                                        //Feature#2549 Select file description for workflow stage.
                        $permitted_file_description = null;
                        if(!empty($current_stage_detials->jwf_afdec_ids))
                        {
                        $permitted_file_description = implode(',',json_decode($current_stage_detials->jwf_afdec_ids));
                        }
                    foreach($stage_uploaded_files as $upload_file)
                    {
                    $file_description_array=$this->get_file_description_values($art_type_id,$upload_file->paf_file_name,$permitted_file_description);

                    $upload_file->production_attach_file_description=$file_description_array['attach_file_description'];
                    $upload_file->file_des_type=$file_description_array['file_des_type'];

                    }
                 }
                    if(!empty($file_description_array['file_des_type']))
                    $file_description_list=$file_description_array['file_des_type'];
                    $stage_details['file_decription_list']=$file_description_list;

                $stage_details['uploaded_files'] = $stage_uploaded_files;
                return  $this->success('Success', 200, $stage_details);

        }
        catch (\exception $e) {

            return $this->failure('Failed',200, $e);
        }
    }
    public function update_production_attachment_description(Request $request)
	{
			try
            {
            $post_data=$request->all();
            $this->current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'file_id' => 'required',
                'file_caption_id' => 'required',
                'art_id' => 'required',
                'jnl_code'=>'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
			$file_id= decrypt_link($post_data['file_id']);
			$file_caption=decrypt_link($post_data['file_caption_id']);
			$article_id = decrypt_link($post_data['art_id']);
            $jnl_code=$post_data['jnl_code'];
            $return_array = array();
           if($file_caption != '' && $file_id != '')
		    {
                $Production_attachment_files = new \App\Models\Production_attachment_files();
                $Required_file_type = new \App\Models\Roles();
                $Attachment_file_description = new \App\Models\Attachment_file_description();
                $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
                $Issue_management = new \App\Models\Issue_management();


					$data = array(
				'paf_description_id' => $file_caption,
			);
			$condition="paf_id={$file_id}";

			$res = $Production_attachment_files::update_record($data,$condition,$this->current_user);
				$description_id="afdec_id={$file_caption}";
				$description_details=$Attachment_file_description::get_single_record('afdec_id,afdec_viewable_roles', $description_id);
			$viewable_roles=$description_details->afdec_viewable_roles;
			 $condition ="adr_paf_id={$file_id}";
		$check_attachment_desig_roles = $Attachment_designated_roles::get_single_record('adr_id,adr_role_id', $condition);

			if(!empty($check_attachment_desig_roles))
			{

			  $data_update=array('adr_role_id'=>$viewable_roles);
			$update_condition="adr_id={$check_attachment_desig_roles->adr_id}";
			  $update_designated_id=$Attachment_designated_roles::update_record($data_update, $update_condition,$this->current_user);
			}
			else
			{
				$data = array(
						'adr_paf_id' => $file_id,
						'adr_role_id' => $viewable_roles,
						'adr_submitted_type' => 'ps',
				    );
				$attach_desinated_id = $Attachment_designated_roles::insert_record($data,$this->current_user);
			}
			$issue_record=$Issue_management::get_single_record('ism_id',"ism_art_id={$article_id}");
			if(!empty($issue_record))
			{
			$issue_page_count = $this->issue_management_page_count($article_id,$jnl_code);
			$ism_data['ism_art_page_cnt']   = $issue_page_count;
			$Issue_management::update_record($ism_data,"ism_art_id={$article_id}",$this->current_user);
			}
			//$return_arr['status'] = 'success';

		    }
            return  $this->success('Success', 200, $return_array);
        }
        catch (\exception $e) {

            return $this->failure('Failed',200, $e);
        }

	}

    public function remove_production_attachment(Request $request)
	{
         try
         {
         $post_data=$request->all();
         $this->current_user = $this->get_current_user_details();
         $validator = Validator::make($request->all(), [
            'attachment_id' => 'required',
            'art_id' => 'required',
            'jnl_code'=>'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
         $att_id=decrypt_link($post_data['attachment_id']);
         $art_id=$post_data['art_id'];
         $jnl_code=$post_data['jnl_code'];
         $return_arr=array();
			if ($att_id != '' && $art_id != '')
			{
                $Production_attachment_files = new \App\Models\Production_attachment_files();
                $Articles = new \App\Models\Articles();
                $Attachment_designated_roles = new \App\Models\Attachment_designated_roles();
                $Issue_management = new \App\Models\Issue_management();

                $production_attach_file_table = (new \App\Models\Production_attachment_files)->getTable();
                $article_table=(new \App\Models\Articles)->getTable();

                    $tablesfirst = array(
                        'main_table' => $production_attach_file_table,
                        'join_table' => array(
                            $article_table => array($article_table . '.art_id', $production_attach_file_table . '.paf_art_id', "join")
                        )
                    );
                    $condition = "paf_id={$att_id}";
                    $pro_file_data = $Production_attachment_files::get_results_using_joins($tablesfirst, "art_article_upload_path,paf_aflw_id,paf_file_name", $condition, 'single');

				if(!empty($pro_file_data))
				{
					$del_res = $Production_attachment_files::delete_records("paf_id={$att_id}",'',$this->current_user);
					$condition ="adr_paf_id={$att_id}";
					$check_attachment_desig_roles = $Attachment_designated_roles::get_single_record('adr_id', $condition);
					if(!empty($check_attachment_desig_roles))
					{
						$del_res = $Attachment_designated_roles::delete_records("adr_id={$check_attachment_desig_roles->adr_id}",'',$this->current_user);
					}
                    $folder_path=$pro_file_data->art_article_upload_path.'/production/'.$pro_file_data->paf_aflw_id.'/';
                    $file_path = public_path() . '/storage/uploads/' .$folder_path;
                    //   $file_path = APP_DOC_PATH . $folder_path . '/';


                    //Upgrade #2293 Manage review uploads
                    $aws_path="uploads/" . $folder_path . "/";



					if(!empty($del_res))
					{
                        $this->remove_fileinfolder($file_path,$pro_file_data->paf_file_name,$aws_path);
					}
					$issue_record=$Issue_management::get_single_record('ism_id',"ism_art_id={$art_id}");
					if(!empty($issue_record))
					{
					$issue_page_count = $this->issue_management_page_count($art_id,$jnl_code);
					$ism_data['ism_art_page_cnt']   = $issue_page_count;
					$Issue_management::update_record($ism_data,"ism_art_id={$art_id}", $this->current_user);
					}
					$return_arr['status'] = 'success';
					$return_arr['msg'] ='File deleted';
					//$validate_stage = $this->validate_production_stage($pro_file_data->paf_aflw_id,null,true);
					//$return_arr['forms_validated'] = $validate_stage['status'];
				}
			}
            return  $this->success('Success', 200, $return_arr);

        }
        catch (\exception $e) {

            return $this->failure('Failed',200, $e);
        }
	}
    public function get_file_description_values($articletype_id,$file_name,$permitted_file_description = null)
	{
        $Article_type_advance_options = new \App\Models\Article_type_advance_options();
        $Required_file_type = new \App\Models\Required_file_type();
        $Attachment_file_description = new \App\Models\Attachment_file_description();
        $File_upload_type = new \App\Models\File_upload_type();

		$allowd_filetype = $Article_type_advance_options::get_single_record('atotp_file_type,atotp_file_description',"atotp_artp_id={$articletype_id}");
                $fdec_where = 'rft_artp_id =' . $articletype_id;
                //Feature#2549 Select file description for workflow stage.
                if(!empty($permitted_file_description))
                {

                    $fdec_where .= ' AND rft_file_desp_id IN (' . $permitted_file_description .')';
                }

		$file_description_data = $Required_file_type::get_all_records('*', $fdec_where);

		$file_description_arr = array();
		$file_description = '';
		if (!empty($file_description_data))
		{
			foreach ($file_description_data as $fd)
			{
				array_push($file_description_arr, $fd->rft_file_desp_id);
			}
			$file_description = implode(',', $file_description_arr);
		}

		$attach_file_description=array();
		$file_description_select_id='';
		$default_description=false;
		$descrption=array();

		if(isset($file_description)&&$file_description!='')
		{
		$allowd_filetype->description = $file_description;


		$attach_file_description = $Attachment_file_description::get_all_records('*', 'afdec_id IN (' . $allowd_filetype->description . ') AND FIND_IN_SET("p", afdec_apply_stage_type) ', 'afdec_description');

		$attach_file_default_desc=array();
		if(isset($file_name)&&$file_name!="")
		{
			$file_extension_arr = explode(".", $file_name);
					$file_extension = strtolower(end($file_extension_arr));
					$fup_data = $File_upload_type::get_single_record('fut_id',"fut_name='{$file_extension}'");

						$at_where = '(afdec_id IN (' . $allowd_filetype->description . ') AND afdec_default != "s"  AND FIND_IN_SET("p", afdec_apply_stage_type))';
						$where_condition = 'FIND_array_intersect("'. $fup_data->fut_id .'",REPLACE(REPLACE(REPLACE(afdec_file_type_id,\'"\',""),"]",""),"[","")) = 1 and afdec_id IN (' . $allowd_filetype->description . ') AND afdec_default != "s" AND FIND_IN_SET("p", afdec_apply_stage_type)';
						$def_where = '(afdec_id IN (' . $allowd_filetype->description . ')  )';

					$attach_file_description = $Attachment_file_description::get_all_records('*', $at_where, 'afdec_description');

$attach_file_default_desc = $Attachment_file_description::get_single_record('afdec_id', $def_where);

		}
		else
		{

			$where_condition = "afdec_id IN (" . $allowd_filetype->description . ") AND afdec_default != 's' AND FIND_IN_SET('p', afdec_apply_stage_type)";
		}
			$descrption = $Attachment_file_description::get_all_records('*', $where_condition);



				if (!empty($descrption)&&count($descrption)>0)
					{

						if (count($descrption) > 1)
						{
							$file_description_select_id = '';
						}
						else
						{
							$file_description_select_id = $descrption[0]->afdec_id;
							$default_description=true;

						}
					}
					elseif (!empty($attach_file_default_desc))
					{

						$file_description_select_id= $attach_file_default_desc->afdec_id;
						$default_description=true;
					}
		     }

					$file_desc['attach_file_description']=  $attach_file_description;
					//$insert_arr['attach_file_description']=$file_description_select_id;
					$file_desc['production_description']=$file_description_select_id;

					$file_desc['file_des_type'] = $descrption;
					$file_desc['deault_desciption_count']=$default_description;

					return $file_desc;
	}
    public function transferstagetype(Request $request)
	{
         try
         {
         $post_data=$request->all();
         $validator = Validator::make($post_data, [
            'articletype' => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
         $this->current_user = $this->get_current_user_details();
         $article_type =  isset($post_data['articletype']) ? decrypt_link($post_data['articletype']):'';
         $article_id =  isset($post_data['article_id']) ? decrypt_link($post_data['article_id']):'';
         $articletypestb = new \App\Models\Article_types();
         $articleflow = new \App\Models\Article_flow();
        $articlesTable = ($articleflow)->getTable();
        $Generic_flows = new \App\Models\Generic_flows;
        $genericflowTable = ($Generic_flows)->getTable();
        $articletypedata =$articletypestb::get_single_record('artp_fwm_id','artp_id='.$article_type);
         $artp_fwm_id = $articletypedata->artp_fwm_id;
         $sql='select GROUP_CONCAT(DISTINCT jwf_stage_type) as stagetype from '.$articlesTable.' left join '.$genericflowTable.' on jwf_id=aflw_jwf_id WHERE aflw_art_id='.$article_id.' and aflw_parent_flow_id IS null';
         $articleflowdata =$articleflow::get_records_by_raw_query($sql,true);
         $genericflowcondition="jwf_fwm_id=".$artp_fwm_id;
         if(!empty($articleflowdata) && isset($articleflowdata->stagetype))
         {  
            $stage_types = $articleflowdata->stagetype;
            $stage_typesexp =explode(",",$stage_types);
            $genericflowcondition.=' and jwf_stage_type IN (\'' . implode('\',\'', $stage_typesexp) . '\')';
         }
         //DB::enableQueryLog();
         $genericflowdata =$Generic_flows::get_all_records('jwf_id,jwf_stage_name,jwf_stage_name,jwf_stage_type',$genericflowcondition);
         //$result=DB::getQueryLog();
         //dd($result);
         $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $stagetypearray=array();
          foreach($genericflowdata as $genericdata)
          {
            $flowstagetype = $review_flow[$genericdata->jwf_stage_type];
            if(isset($flowstagetype['permission']) && in_array('transfer', $flowstagetype['permission']))
            {
                $stagetypearray[]=$genericdata;
            }
          }
            $return_arr['stagetypearray'] = $stagetypearray;
        return  $this->success('Success', 200, $return_arr);

    }
    catch (\exception $e) {

        return $this->failure('Failed',200, $e);
    }
}

public function production_additional_attachment_file(Request $request)
{
    try
     {
       $post_data=$request->all();
       $validator = Validator::make($post_data, [
        'art_id' => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }

        $art_id= decrypt_link($post_data['art_id']);
        //$art_type_id=$post_data['art_type_id'];

        $Articles = new \App\Models\Articles();
        $Generic_flows = new \App\Models\Generic_flows();
        $Article_flow = new \App\Models\Article_flow();

        $client_code = $this->current_client->clnt_client_code;
        $this->reviewflow= Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
        $stages=$this->get_production_stages_keys($this->reviewflow,false,true);
                $review_stages=$stages['review'];
                $prdn_stages=$stages['production'];
                  $where_cond='';
                if(!empty($prdn_stages))
                    $where_cond =' and jwf_stage_type in ("' . implode('","', $prdn_stages) . '")';

                    $article_flow_table = (new \App\Models\Article_flow)->getTable();
                    $generic_flow_table=(new \App\Models\Generic_flows)->getTable();

                        $tablesfirst = array(
                            'main_table' => $article_flow_table,
                            'join_table' => array(
                                $generic_flow_table => array($generic_flow_table . '.jwf_id', $article_flow_table . '.aflw_jwf_id', "join")
                            )
                        );
                        $criteria=' aflw_art_id='.$art_id. ' and aflw_parent_flow_id IS null and aflw_status IN ("c")';
                        if(!empty($where_cond)) $criteria.= $where_cond;
                        $article_type_stages =$Article_flow::get_results_using_joins($tablesfirst, "aflw_id,jwf_id,jwf_stage_name,jwf_stage_type,jwf_assignment", $criteria, 'all');
        //To assign child flow id.
        for ($i = 0; $i < count($article_type_stages); $i++)
        {
            if($article_type_stages[$i]->jwf_assignment == 'manual')
            {
                //get single records
                $flow_details=$Article_flow::get_single_record('aflw_id','aflw_parent_flow_id='.$article_type_stages[$i]->aflw_id);
                if(!empty($flow_details))
                {
                    $article_type_stages[$i]->aflw_id =$flow_details->aflw_id;
                }
            }
        }
        $data['stage_list']=$article_type_stages;
        return  $this->success('Success', 200, $data);
        }

        catch (\exception $e) {

            return $this->failure('Failed',200, $e);
        }


}
public function get_uploadstagedetails(Request $request){
    try{
        $current_stage = $request->all();
        $validator = Validator::make($current_stage, [
            'art_flow_id' => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->failure('Failed', 422, $validator->errors());
        }
        $Articles = new \App\Models\Articles();
        $Generic_flows = new \App\Models\Generic_flows();
        $role_table = (new \App\Models\Roles())->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $art_flow_id = decrypt_link($current_stage['art_flow_id']);
        $jnl_data_set=true;
        //  $jwf_id=3542;
        /*get stage id based data get in workflow table */
        $condition = 'aflw_id=' . $art_flow_id;
        $condition = "aflw_id=:art_flow_id";
        $condition_arr=array(
            'art_flow_id' => $art_flow_id,
        );
		$flowdetails = $Articles::get_article_details("aflw_art_id,artp_jpm_id,jnl_id,jnl_journal_code,aflw_status,aflw_posted_by,aflw_usr_id,aflw_id,aflw_jwf_id,jwf_id,jwf_stage_name,jwf_stage_type,jwf_forms,artp_id,art_id,art_status,art_title,artp_id,artp_article_type,artp_fwm_id,jwf_role_id,jwf_tab_name,jwf_parent_user_roles,aflw_skip_review,jwf_who_can_invite,jwf_role_id,jwf_status_name,jwf_assignment,aflw_parent_flow_id,jwf_production_upload,art_transfer_article", $condition,null,false,false,null,$condition_arr);
        $flow_data = $flowdetails[0];
        $stage_upload = false;
        $flow_data->allow_file_types = 'zip,pdf';
        $flow_data->allow_file_size = 20;
        $flow_data->stage_upload = $stage_upload;
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);

        if(isset($review_flow[$flow_data->jwf_stage_type]['upload']) && count($review_flow[$flow_data->jwf_stage_type]['upload']) > 0 && $flow_data->jwf_production_upload != 'n')
        {
            $stage_upload = true;
            $flow_data->allow_file_types = implode(',', $review_flow[$flow_data->jwf_stage_type]['upload']);
            $allow_file_size = UtilityTrait::Utility('rvt_upload_file_sizes')['rvt_upload_file_sizes'];
            $flow_data->allow_file_size=$allow_file_size['production_mng_each_attachment'];

            $flow_data->stage_upload = $stage_upload;
        }


         $stage_upload = false;
                    $flow_data->allow_file_types = 'zip,pdf';
                    $flow_data->allow_file_size = 20;
                    $flow_data->stage_upload = $stage_upload;
                    if(isset($review_flow[$flow_data->jwf_stage_type]['upload']) && count($review_flow[$flow_data->jwf_stage_type]['upload']) > 0 && $flow_data->jwf_production_upload != 'n')
                    {
                        $stage_upload = true;
                        $flow_data->allow_file_types = implode(',', $review_flow[$flow_data->jwf_stage_type]['upload']);
                        $allow_file_size = UtilityTrait::Utility('rvt_upload_file_sizes')['rvt_upload_file_sizes'];
                        $flow_data->allow_file_size=$allow_file_size['production_mng_each_attachment'];
                        $flow_data->stage_upload = $stage_upload;
                    }
                    $upload_file_size_config = $this->get_uploaded_file_size_config();
                    $flow_data->allow_single_production_file_size=$upload_file_size_config['max_production_single_file_size'];
                    $flow_data->allow_single_production_file_size_in_mb=$upload_file_size_config['max_production_single_file_size_in_mb'];
                   $data['stagedetails']=$flow_data;

        return  $this->success('Success', 200, $data);
    }
    catch (\exception $e) {

        return $this->failure('Failed',200, $e);
    }


}

    public function save_copyright(Request $request) { // copy right license

        try {
            $validator = Validator::make($request->all(), [
                'aflw_id' => 'required',
                'jnl_id' => 'required',
                'jnl_code'=>'required'
            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $copyright = $request->all();
			$license_id='';
            $license_date = '';
            $license_content_edited='';
            $crtm_license_name='';
			$lice_jnl_name = '';
            $aflw_id = decrypt_link($copyright['aflw_id']);
            $jnl_id=$copyright['jnl_id'];
            $jnl_code=$copyright['jnl_code'];
            $platform_data = $this->platform_basic_settings_data($jnl_code);
            $date_format = $platform_data->jset_date_format;
            $input_arr = array('input' => $jnl_id,'type'=> 'number');
            $jnl_id_validate = $this->Rv_validator($input_arr);


            $input_arr = array('input' => $jnl_code);
            $jnl_code_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $aflw_id,'type'=> 'number');
            $flow_id_validate = $this->Rv_validator($input_arr);

            if($jnl_id_validate==true && $jnl_code_validate==true && $flow_id_validate==true ){


			if (isset($copyright['license'])) {
                $license_id = is_array($copyright['license'])?$copyright['license'][0]:$copyright['license'];
                $input_arr = array('input' => $license_id,'type'=> 'number');
                $license_id_validate = $this->Rv_validator($input_arr);
                if($license_id_validate!=true) {
                    return $this->warning('Failed',422,customTrans('auth.invalid_data'));
                }
            }
			if (isset($copyright['copyright_date'])) {
                $license_date = $copyright['copyright_date'];
                $input_arr = array('input' => $license_date,'type'=> 'date');
                $license_date_validate = $this->Rv_validator($input_arr);
                if($license_date_validate!=true) {
                    return $this->warning('Failed',422,customTrans('auth.invalid_data'));
                }
            } else {
                $license_date = date("Y-m-d");
            }
			//print_r($copyright);die;
			$fee_waiver = isset($copyright['fee_waiver']) ? $copyright['fee_waiver'] : 'n';
            if(empty($fee_waiver)){
                $fee_waiver ='n';
            }

			if ($fee_waiver == 'y') {
                if($copyright['fee_waiver_reason']=='') {
                    return  $this->warning('Warnings',200,'Required','warning');
                }
			}



			$fee_waiver_reason = (isset($copyright['fee_waiver_reason']) && $fee_waiver == 'y') ? $copyright['fee_waiver_reason'] : '';

            $this->current_user = $this->get_current_user_details();
            $article_status = Article_flow::get_article_status_details($aflw_id,true);
            DB::beginTransaction();
            $Copyright_table = new \App\Models\Copyright();
            $Copyright_master = new \App\Models\Copyright_master();
            $Journals = new \App\Models\Journals();
			$master_copyright = $Copyright_master::get_single_record('*',"crtm_id={$license_id}");
            $copyright_condition = "crt_aflw_id= {$aflw_id} and crt_posted_by={$this->current_user['user_id']}";
			$copyright_exist = $Copyright_table::get_single_record('*',$copyright_condition);

            // $lice_ip_address=trim(shell_exec("dig +short myip.opendns.com @resolver1.opendns.com"));
            $lice_ip_address=$request->ip();

            $copyright_keys = WorkflowTrait::copyright_keys();
            $lice_jnl_name   =    $Journals::get_single_record('jnl_journal_name', "jnl_id={$jnl_id}")->jnl_journal_name;
            $jset_date_format   =  $this->get_platform_date_format($jnl_id);

			if(!empty($master_copyright)) {
			    $license_content_edited = $master_copyright->crtm_license_content;
			    $crtm_license_name = $master_copyright->crtm_license_name;
			}

            if(!empty($article_status->art_id)){
            $authors_table = (new \App\Models\Authors)->getTable();
            $user_table=(new \App\Models\User)->getTable();
            $user_aff = (new \App\Models\Authors_affiliation)->getTable();

                $tablesfirst = array(
                    'main_table' => $authors_table,
                    'join_table' => array(
                        $user_table => array($user_table . '.usr_id', $authors_table . '.auth_usr_id', "join"),
                        $user_aff => array($authors_table . '.auth_id', $user_aff . '.auaff_auth_id', "left")
                    )
                );
                // $criteria=' auth_art_id='.$article_status->art_id . ' AND auaff_prime_affiliation ="y"';
                $criteria = array(
                'auth_art_id' => $article_status->art_id,
                'auaff_prime_affiliation' =>'y'
                );
                $article_auth_details =Article_flow::get_results_using_joins($tablesfirst, "*", $criteria, 'all');
                $auth_list = '';
                $all_authors = '';
                if(!empty($article_auth_details)){
                foreach($article_auth_details as $key) {
                    $auth_list = "
                    $auth_list 
                    <li>
                    $key->usr_first_name $key->usr_last_name, $key->auaff_company, $key->usr_email <br> 
                    </li>
                    ";    

                    //Task #3333 all authors and all editors
                    $all_authors = "
                    $all_authors 
                    <li>
                    $key->usr_first_name $key->usr_last_name <br> 
                    </li>
                    ";    
                }
                $auth_list = "<ol>$auth_list</ol>";
                $all_authors = "<ol>$all_authors</ol>";
            }   
            $author_name = $article_status->usr_first_name . ' ' . $article_status->usr_last_name;
            }

             //Task #3333 all authors and all editors
            $jnl_edtrs_md_res   =   '';
            $cpyt_owners   =   '';
            $us_gvt_inst   =   '';
            $us_gvt_empl   =   '';
            $contr_nmbrs   =   '';

            if($jnl_code != '') {
                //    Task #3703 new COPYRIGHT tags
                $jnl_edtrs_md_res =   $this->convert_submission_stage_unique_identifiers('CONF_ALL_EDITORS', 'metadata', null, $jnl_code);
                $jnl_title =   $this->convert_submission_stage_unique_identifiers('JNL_TITLE', 'metadata', null, $jnl_code);
                
               $cpyt_owners =   $this->convert_submission_stage_unique_identifiers('COPYRIGHT_OWNERS_IDENTIFIER', 'author_submission', $article_status->art_id, $jnl_code);
               $us_gvt_inst =   $this->convert_submission_stage_unique_identifiers('US_GOVT_INSTITUTION_IDENTIFIER', 'author_submission', $article_status->art_id, $jnl_code);
               $us_gvt_empl =   $this->convert_submission_stage_unique_identifiers('US_GOVT_EMPLOYEE_AUTHOR_IDENTIFIER', 'author_submission', $article_status->art_id, $jnl_code);
               $contr_nmbrs =   $this->convert_submission_stage_unique_identifiers('AUTHOR_CONTRACT_NUMBERS_IDENTIFIER', 'author_submission', $article_status->art_id, $jnl_code);
               //    Task #3703 new COPYRIGHT tags
            }
            foreach (array_keys($copyright_keys) as $key) {
				$replace_with = '';
				switch ($key) {
					case 'journal_name': $replace_with = $lice_jnl_name;
						break;
					case 'conference_name': $replace_with = $lice_jnl_name;
						break;
                    case 'ip_address' : $replace_with = $lice_ip_address;
                        break;
					case 'manuscript_id': $replace_with = $article_status->art_code;
						break;
                    case 'article_id': $replace_with = $article_status->art_code;
						break;
					case 'article_title': $replace_with = strip_tags($article_status->art_title);
						break;
                    case 'copyright_date':
                        $replace_with = ($this->current_client->platform_type !== 'conference')
                            ? ($license_date
                                ? date($jset_date_format, strtotime($license_date))
                                : "")
                            : ($copyright_exist
                                ? $copyright_exist->crt_posted_date
                                : date($date_format));
                        break;
					case 'author_name': $replace_with = strtoupper($author_name);
						break;
					case 'copyright': $replace_with = $crtm_license_name;
						break;
                    case 'author_details': $replace_with = $auth_list;
                        break;
                    // case 'print_name': $replace_with = strtoupper($author_name);
                    //     break;
                    case 'author_title': $replace_with = strtoupper($article_status->usr_title);
                        break;
                    case 'current_date': $replace_with = date($date_format,time());
                        break;
                    //Task #3333 all authors and all editors
                    case 'all_authors': $replace_with = $all_authors;
                        break;
                    case 'all_editors': $replace_with = $jnl_edtrs_md_res;
                        break;
                    //    Task #3703 new COPYRIGHT tags
                    case 'jnl_title': $replace_with = $jnl_title;
                        break;
                    case 'copyright_owners': $replace_with = $cpyt_owners;
                        break;
                    case 'us_govt_institution': $replace_with = $us_gvt_inst;
                        break;
                    case 'us_govt_employee_author': $replace_with = $us_gvt_empl;
                        break;
                    case 'contract_numbers': $replace_with = $contr_nmbrs;
                        break;
                    //    Task #3703 new COPYRIGHT tags
				}

                $replace_button = array('<button contenteditable="false">', '</button>');
                $license_content_edited = str_replace($replace_button, '##', $license_content_edited);
                
				$license_content_edited = str_replace('%' . strtolower($key) . '%', $replace_with, $license_content_edited);
				$license_content_edited = str_replace('%' . strtoupper($key) . '%', $replace_with, $license_content_edited);
				$license_content_edited = str_replace('##' . strtolower($key) . '##', $replace_with, $license_content_edited);
				$license_content_edited = str_replace('##' . strtoupper($key) . '##', $replace_with, $license_content_edited);
			}

			$update_data = array(
				'crt_aflw_id' => $aflw_id,
				'crt_art_id' => $article_status->art_id,
				'crt_crtm_id' => $license_id,
				'crt_license_content' => $license_content_edited,
				'crt_fee_waiver' => $fee_waiver,
				'crt_fee_waiver_reason' => $fee_waiver_reason);

			if (isset($copyright['copyright_date']) && $license_date != '') {
                $update_data['crt_date'] = convert_dmy_to_ymd($license_date, $jset_date_format);
            }
            $copyright_condition = "crt_aflw_id= {$aflw_id} and crt_posted_by={$this->current_user['user_id']}";
            if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y') {
                $copyright_condition = "crt_art_id = $article_status->art_id"; //for conference copyright 
                // Task #3393 Copyright Aipp New tile for author
                $Articles   =   new \App\Models\Articles();
                $art_data    =   $Articles::get_single_record('art_submitted_by,art_artp_id,art_copyright_request','art_id = ? ',binding_arr:[$article_status->art_id]);
                if(!empty($art_data)){
                    if($art_data->art_copyright_request=='y'){
                        $article_update = array(
                            'art_copyright_request' => 'c'
                        );
                        $Articles::update_record($article_update,"art_id={$article_status->art_id}", $this->current_user);
                        $dataarray = array(
                            'crr_art_id' => $article_status->art_id,
                            'crr_request_to' => $art_data->art_submitted_by,
                            'crr_request_from' => $this->current_user['user_id'],
                            'crr_request_status' => 'c'
                        );

                        Copyright_request::insert_record($dataarray, $this->current_user);
                    }
                }
            }
			$copyright_exist = $Copyright_table::get_single_record('*',$copyright_condition);
            
			$crt_id = 0;
			$pdf_path = '';
			if ($copyright_exist == '') {
				$crt_id = $Copyright_table::insert_record($update_data, $this->current_user);
				$result['msg'] = 'Copyright license added successfully';
				$old_license_id = '';
			} else {
				$Copyright_table::update_record($update_data,$copyright_condition, $this->current_user);
				$crt_id = $copyright_exist->crt_id;
				$result['msg'] = 'Copyright license updated successfully';
				$old_license_id = $copyright_exist->crt_crtm_id;
				if ($license_id != $old_license_id) {
					Articles::update_record(array(
						'art_copyright_pdf_status' => 'n',
						'art_copyright_pdf_name' => ''
						),"art_id={$article_status->art_id}");
					$unlink_path = 'uploads/' . $article_status->art_article_upload_path . '/' . $article_status->art_copyright_pdf_name;
					if (!empty($article_status->art_copyright_pdf_name)) {
                        $folder_path=$article_status->art_article_upload_path.'/';
                        $file_path = public_path() . '/storage/uploads/' .$folder_path;
                        $aws_path="uploads/" . $folder_path . "/";
                        $this->remove_fileinfolder($file_path,$article_status->art_copyright_pdf_name,$aws_path);
                    }
                }
			}

            if ($crt_id != 0) {
				$result['status'] = 'success';
				//$result['result'] = base_url('journal/' . $jnl_code . '/copyright-pdf-view') . '?' . encrypt_link('crt_id=' . $crt_id);
				$result['link_id'] = encrypt_link('crt_id=' . $crt_id);
			}
			//$result['forms_validated'] = $this->validate_stage_forms($aflw_id,$jnl_id,$jnl_code);
			$result['license'] = $license_id;
            $gen_pdf = 'on_download';
            $this->download_copyright($crt_id,$gen_pdf,$jnl_code);
            DB::commit();
            return  $this->success('Success', 200, $result);

        } else {
            DB::rollback();
            return $this->warning('Failed',422,customTrans('auth.invalid_data'));
        }

        } catch (\Exception $e) {
            DB::rollback();
            return  $this->failure('Failed',500,$e);
		}

	}

    public function copyright_attachments(Request $request) { // copy right
        try {
            $validator = Validator::make($request->all(), [
                'aflw_id'      => 'required',
			    'jnl_code'      => 'required',
			    'jnlid'      => 'required',
			    'file'      => 'required',
		    ]);
		    if ($validator->fails()) {
			    return  $this->warning('Warnings',200,$validator->errors(),'warning');
		    }
            $result=array();
            $this->current_user = $this->get_current_user_details();
            $form_data = $request->all();


            $aflw_id=$this->decrypt_data($form_data['aflw_id']);
            $jnl_code=$form_data['jnl_code'];
            $jnl_id=$form_data['jnlid'];
            $attachment_file = $form_data['file'];

            $input_arr = array('input' => $jnl_id,'type'=> 'number');
            $jnl_id_validate = $this->Rv_validator($input_arr);


            $input_arr = array('input' => $jnl_code);
            $jnl_code_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $aflw_id,'type'=> 'number');
            $flow_id_validate = $this->Rv_validator($input_arr);


if($jnl_id_validate==true && $jnl_code_validate==true && $flow_id_validate==true ){



            $Copyright_table = new \App\Models\Copyright();

            $article_status = Article_flow::get_article_status_details($aflw_id,true);

            // $attach_dir = 'uploads/' .$article_status->art_article_upload_path.'/'.'copyright/';
            // if (!file_exists($attach_dir)) {
            //     mkdir($attach_dir, 0765, true);
            // }



            if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
                $attach_dir = 'uploads/' .$article_status->art_article_upload_path.'/'.'copyright/';
            } else {
                $attach_dir = 'uploads/' .$article_status->art_article_upload_path.'/'.'copyright/';
                $this->addDireactory($attach_dir);
            }
            //print_r($attach_dir);die;

            $name = $attachment_file->getClientOriginalName();
            $path = $article_status->art_article_upload_path;

            $uploaded_file_details = $this->upload_file_handler($path.'/'.'copyright/', $attachment_file, $name);
            //print_r($uploaded_file_details);die;
            if ($uploaded_file_details['error'] == false) {


                $data['isat_location']  = $attach_dir;
                $data['isat_size']      = $this->file_size_convert_to_kb($uploaded_file_details['size']);
                $att_name               = $uploaded_file_details['name'];
                $data['isat_name']      = $att_name;
                $att_pages              = 1;
                if(isset($uploaded_file_details['type']) && !empty($uploaded_file_details['type'])) {
                    if($uploaded_file_details['type'] == 'application/pdf') {
                        $att_path = $attach_dir . $att_name;
                    }
                }
                $data['isat_page']      = $att_pages;

                $cond_copyright = array(
                    'crt_aflw_id' => $aflw_id,
                    'crt_posted_by' => $this->current_user['user_id']);

                $copyright_exist = $Copyright_table::get_single_record('*',"crt_aflw_id={$aflw_id} and crt_posted_by={$this->current_user['user_id']}");
                if ($copyright_exist == '') {
                    $license_id='';
                    $update_data = array(
                        'crt_aflw_id' => $aflw_id,
                        'crt_art_id' => $article_status->art_id,
                        'crt_crtm_id' => $license_id
                    );
                    $Copyright_table::insert_record($update_data,$this->current_user);
                } else {
                    if(!empty($copyright_exist) && !empty($copyright_exist->copy_location) && !empty($copyright_exist->copy_att_name)) {
                    $file_path = public_path() . '/storage/'.$copyright_exist->copy_location;
                    //Upgrade #2293 Manage review uploads
                    $aws_path=$copyright_exist->copy_location;
                    $this->remove_fileinfolder($file_path,$copyright_exist->copy_att_name,$aws_path);
                    }
                }


                $update_data = array(
                    'copy_location' => $data['isat_location'],
                    'copy_att_name' => $data['isat_name']
                    );
                $isat_id    = $Copyright_table::update_record($update_data, "crt_aflw_id={$aflw_id} and crt_art_id={$article_status->art_id} and crt_posted_by={$this->current_user['user_id']}");

                $att_link = encrypt_link('path=' . $attach_dir . $att_name . '&view=true');
                $data['isat_link'] = $att_link;
                //$uploaded_file_details['files'][0]->issue_attachment_html = $this->load->view('journals/templates/tmpl_copyright_atmnt_row', $data, true);
                //$uploaded_file_details['files'][0]->forms_validated = $this->validate_stage_forms($aflw_id);
                //$this->uploadhandler->generate_response($uploaded_file_details);
                //$result['Copyright']   = $Copyright_table::get_single_record('*', "crt_aflw_id={$aflw_id} and crt_art_id={$article_status->art_id} and crt_posted_by={$this->current_user['user_id']}");
                return  $this->success('Success', 200, $data);


            } else {
                return  $this->warning('Warning', 200, 'Upload failed');
            }

        } else {
            return $this->warning('Failed',422,customTrans('auth.invalid_data'));
        }



        } catch(\Exception $e) {
		    //DB::rollback();

		    return  $this->failure('Failed',500,$e);
	    }

	}



    public function view_copyright_license(Request $request) { //copy right

        try {
            $validator = Validator::make($request->all(), [
                'license'      => 'required',
                'jnl_code'      => 'required',
		    ]);
		    if ($validator->fails()) {
			    return  $this->warning('Warnings',200,$validator->errors(),'warning');
		    }
            $result=array();
            $form_data = $request->all();
            $license_id=$this->decrypt_data($form_data['license']);
            $jnl_code=$form_data['jnl_code'];


            $input_arr = array('input' => $license_id,'type'=> 'number');
            $license_id_validate = $this->Rv_validator($input_arr);


            $input_arr = array('input' => $jnl_code);
            $jnl_code_validate = $this->Rv_validator($input_arr);

            if($license_id_validate==true && $jnl_code_validate==true ){

            $Copyright_master = new \App\Models\Copyright_master();
            $copyright_stt = $Copyright_master::get_single_record('*',"crtm_id={$license_id}");
            $result['status'] = 'success';
			$result['license_data'] = $copyright_stt;
			$result['pdf_div'] = $copyright_stt->crtm_license_content;
            $result['cfty_copyright_upload'] = $this->current_client->functionality->cfty_copyright_upload;
			if ($this->current_client->functionality->cfty_copyright_upload == 'y') {
				// $pdf_path = 'uploads/copyrights/' . $this->current_client->clnt_client_code . '/';
				// $pdf_file = $copyright_stt->crtm_id . '.pdf';


				// $pdf_path = 'uploads/copyrights/' . $this->current_client->clnt_client_code . '/' . $pdf_file;

                $filepathfolder=$this->get_upload_data('copyright_licence');
                if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
                    $result['pdf_div'] = $filepathfolder  .'/'.$this->current_client->clnt_client_code.'/'.$copyright_stt->crtm_id.'.pdf';
                } else {
                    $result['pdf_div'] = $filepathfolder  .'/'.$this->current_client->clnt_client_code.'/'.$copyright_stt->crtm_id.'.pdf';
                }
				//$result['pdf_div'] = '<div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button><h4 class="modal-title">Copyright</h4></div><div class="modal-body" ><div id="pdf_viewer_parent" >   <object  data="' . base_url($pdf_path) . '" type="application/pdf"   style="  width:100%; background-color:#abc; position:relative;" height="450">    alt : <a href="' . base_url($pdf_path) . '">' . base_url($pdf_path) . '</a>    </object></div></div> ';
			}
            return  $this->success('Success', 200, $result);

        } else {
            return $this->warning('Failed',422,customTrans('auth.invalid_data'));
        }

        } catch(\Exception $e) {
		    //DB::rollback();

		    return  $this->failure('Failed',500,$e);
	    }
	}


    public function view_copyright_pdf(Request $request) { // copy right
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'crt_id' => 'required',
                'jnl_code' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $result=array();
            $form_data = $request->all();
            $crt_id=$this->decrypt_data($form_data['crt_id']);
            $jnl_code=$form_data['jnl_code'];

            $input_arr = array('input' => $crt_id,'type'=> 'number');
            $crt_id_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $jnl_code);
            $jnl_code_validate = $this->Rv_validator($input_arr);


          if($crt_id_validate==true && $jnl_code_validate==true) {
            $copyright_table = new \App\Models\Copyright();
            $copyright = $copyright_table::get_copyright_wtih_article($crt_id);
            $filepathfolder=$this->get_upload_data($copyright[0]->art_article_upload_path);
            $result['view_pdf_link'] = $filepathfolder  .'/'. $copyright[0]->art_copyright_pdf_name;
            if((isset($this->current_client->enable_upload_s3_bucket) && $this->current_client->enable_upload_s3_bucket == 'y')) {

                $pdf_path = $copyright[0]->art_article_upload_path;
                $fullpath = "uploads" . DIRECTORY_SEPARATOR . $pdf_path;
                $pdf_name = $copyright[0]->art_copyright_pdf_name;
                $file_path = Config::get('general_config.file_retrieval')['file_path'];

                if($this->fileExistsS3(public_path() . $file_path . "/" . $pdf_path . DIRECTORY_SEPARATOR, $pdf_name,$fullpath)==false){
                    $file_path = Config::get('general_config.file_retrieval')['file_path'];
                    $uploaded = asset($file_path . '/' . $copyright[0]->art_article_upload_path . '/' . $copyright[0]->art_copyright_pdf_name);
                    $result['view_pdf_link'] = $uploaded;
                }
            }
            return $this->success('Success', 200, $result);
           } else {
            return $this->warning('Failed',422,customTrans('auth.invalid_data'));
           }
        } catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }

	}

    public function download_copyright($crt_id,$gen_pdf,$jnlcode) {
        $result=array();
        $copyright_table = new \App\Models\Copyright();
        $copyright = $copyright_table::get_copyright_wtih_article($crt_id);
        $platform_data = $this->platform_basic_settings_data($jnlcode);
        $date_format = $platform_data->jset_date_format;

        $date = date($date_format . '_h-i-s');
		if (count($copyright) > 0) {
            $copyright=$copyright[0];
			$pdf_path = $copyright->art_article_upload_path;
            $pdf_name = 'copyright_' . $date . '_' . $copyright->crt_crtm_id . '.pdf';
            $path = public_path().'/storage/uploads/'.$pdf_path . '/';
            if (!file_exists($path)) {
                mkdir($path, 0765, true);
            }
            if ($this->current_client->functionality->cfty_copyright_upload == 'y') {
                if(file_exists($path.''.$copyright->art_copyright_pdf_name) && $copyright->art_copyright_pdf_name != '') {
                    unlink($path.''.$copyright->art_copyright_pdf_name);
                }

                $master_pdf_path = public_path().'/storage/uploads/copyright_licence/' . $this->current_client->clnt_client_code . '/' . $copyright->crt_crtm_id . '.pdf';
                if (!file_exists($master_pdf_path)) {
                    mkdir($master_pdf_path, 0765, true);
                }
                $file_path = Config::get('general_config.file_retrieval')['file_path'];
                $fullpath = "uploads" . DIRECTORY_SEPARATOR . $pdf_path;
                $aws = false;
                if (isset ($this->current_client->enable_upload_s3_bucket) && $this->current_client->enable_upload_s3_bucket == 'y') {
                    $aws = true;
                }
                $name = $this->rename_file(public_path() . $file_path . "/" . $pdf_path . DIRECTORY_SEPARATOR, $pdf_name,$aws,$fullpath);
                $files = File::allFiles(storage_path()."/app/public/uploads/copyright_licence/".$this->current_client->clnt_client_code.'/');
                if (sizeof($files) > 0) {
                    foreach ($files as $file) {
                        $path_info = pathinfo($file);
                        $file_name = $path_info['filename'] . '.' . $path_info['extension'];
                        if($file_name==$copyright->crt_crtm_id . '.pdf') {
                            $path = $copyright->art_article_upload_path.DIRECTORY_SEPARATOR;
                            $uploaded_file_details = $this->upload_file_handler($path, $file, $name);
                        }
                    }
                }
            }else {
                if(file_exists($path.''.$copyright->art_copyright_pdf_name) && $copyright->art_copyright_pdf_name != '') {
                   unlink($path.''.$copyright->art_copyright_pdf_name);
                }

                $document = new PDF( [
                    'mode' => 'utf-8',
                    'format' => 'A4',
                    'margin_header' => '3',
                    'margin_top' => '20',
                    'margin_bottom' => '20',
                    'margin_footer' => '2',
                ]);
                $data2['content_view']=$copyright->crt_license_content;
                $this->current_user = $this->get_current_user_details();
                $Users=new \App\Models\User();
                $user_data = $Users::get_single_record('concat_ws(" ",usr_first_name,usr_middle_name,usr_last_name) as display_name',"  usr_id={$this->current_user['user_id']}");
                //task #3703 change the footer for copyright 
                $data2['footer_view']="<div style='text-align:center;font-size:10px;'>Generated from ip: ".RequestFacade::ip().", on: ".date($date_format." h:i:s A",time()).", by: ".$user_data->display_name.". <br/>This document is an automatically generated record of the author’s copyright agreement. This does not require a physical signature.</div>";
                $data['content_view'] = view('template.pdf')->with($data2);
                $document->WriteHTML($data['content_view']);
                $document->Output(public_path().'/storage/uploads/'.$pdf_path .'/'. $pdf_name, 'F');
            }

            $art_data = array(
                'art_copyright_pdf_status' => 'y',
                'art_copyright_pdf_name' => $pdf_name
            );

            Articles::update_record($art_data,"art_id={$copyright->art_id}");
            return $this->success('Success', 200, $result);

			// if ($gen_pdf == 'on_download')
			// 	$this->render_pdf('copyright_pdf', encrypt_link($download_path));
		}
		else
		{
			return  $this->warning('Warning', 200, 'download failed');
		}
	}

    public function get_transitdetails(Request $request) {
        try {
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'article_id' => 'required',
                'flow' => 'required',
                'jnl_code' => 'required',
                'jnl_id' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $result=array();

            $art_id=$this->decrypt_data($post_data['article_id']);
            $art_flow_id=$this->decrypt_data($post_data['flow']);
            $jnl_code=$post_data['jnl_code'];
            $jnl_id=$post_data['jnl_id'];
            $disable_do_not_transfer = (isset($this->current_client->functionality) && isset($this->current_client->functionality->cfty_disable_do_not_transfer_button) && $this->current_client->functionality->cfty_disable_do_not_transfer_button === 'y'); /* Task #732 Remove do not transfer option from Author's page*/

            $input_arr = array('input' => $art_id,'type'=> 'number');
            $art_id_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $art_flow_id,'type'=> 'number');
            $flow_id_validate = $this->Rv_validator($input_arr);

            $input_arr = array('input' => $jnl_code);
            $jnl_code_validate = $this->Rv_validator($input_arr);


          if($art_id_validate==true && $flow_id_validate==true && $jnl_code_validate==true) {


            $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
            $transfer_suggestions = $Article_transfer_suggestion::get_transfer_details($art_id, $art_flow_id);
            $titles = $this->UserConfigdata('titles')['titles'];
            if(!empty($transfer_suggestions)) {
                $user_name =  (isset($titles[$transfer_suggestions->usr_title])) ? $titles[$transfer_suggestions->usr_title] . ' ' : '';
                $user_name .=$transfer_suggestions->suggested_by;
                $transfer_suggestions->suggested_by=$user_name;
            }
            $result['transfer_suggestions']=$transfer_suggestions;

            $Article_deletion_reasons = new \App\Models\Article_deletion_reasons();
            $del_reasons = $Article_deletion_reasons::get_all_records();
            if (!empty($del_reasons))
			{
				foreach ($del_reasons as $del)
				{
					$delete_reasons[$del->adel_id] = $del->adel_reason;
				}
			}
			$delete_reasons = (!empty($delete_reasons)) ? $delete_reasons : UtilityTrait::Utility('reason_to_delete_article')['reason_to_delete_article'];
            $delete_reasons['custom']='Other reason';
            $result['delete_reasons']=$delete_reasons;
            $result['disable_do_not_transfer']=$disable_do_not_transfer; /* Task #732 Remove do not transfer option from Author's page*/
            

            return $this->success('Success', 200, $result);
          }else {
            return $this->warning('Failed',422,customTrans('auth.invalid_data'));
          }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
    public function get_manual_reminder_details(Request $request){
        try{
            $Article_flow_table = (new \App\Models\Article_flow)->getTable();
            $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
            $Stage_email_templates = new \App\Models\Stage_email_templates();
            $Stage_email_templates_table = (new \App\Models\Stage_email_templates)->getTable();
            $User_table = (new \App\Models\User())->getTable();
            $Articles_table = (new \App\Models\Articles())->getTable();
            $Stage_email_tmpl_reference = (new \App\Models\Stage_email_tmpl_reference)->getTable();
            $post_data = $request->all();
		    $flow_id = decrypt_link($post_data['aflid']);
            if($flow_id != '')
		    {
                $only_template_contents = false;
			    $multiple_users = false;
			    $user = '';
                if(isset($post_data['usr']) && $post_data['usr'] != '')
			    {
				$usrdata = decrypt_link($post_data['usr']);
				$usr_arr = explode('##', $usrdata);
				$user = (isset($usr_arr[0]))? $usr_arr[0]:'';
				$only_template_contents = true;
				$multiple_users = true;
			    }
                $tmpl_id = '';
			    if(isset($post_data['tmpl']) && $post_data['tmpl'] != '')
			    {
				$only_template_contents = true;
				$tmpl_id = decrypt_link ($post_data['tmpl']);
			    }
                $tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                        $Generic_flows_table => array('jwf_id', 'aflw_jwf_id'),
                        $User_table => array('usr_id', 'aflw_usr_id', 'left'),
                        $Articles_table  => array('art_id', 'aflw_art_id', 'left')
                    )
                );
                $select_cur = 'art_artp_id,art_id,aflw_id,aflw_jwf_id,aflw_status,jwf_stage_type,jwf_role_id,jwf_status_name,jwf_stage_name,usr_image,usr_email,usr_id,usr_title,usr_first_name,usr_last_name,usr_status,usr_deeplink_token,aflw_deeplink_token,aflw_due_date,(CASE WHEN(DATEDIFF(aflw_due_date,NOW())<0) THEN "0" ELSE DATEDIFF(aflw_due_date,NOW()) END) AS TASK_REMAINING_DAYS,CONCAT_WS(\' \',usr_first_name,usr_middle_name,usr_last_name) AS user_fullname';
                $where = '(aflw_id ='.$flow_id.' OR aflw_parent_flow_id = '.$flow_id.')  AND aflw_status IN (\'i\',\'a\')';
                if($user != '')
			    {
				$where .= ' AND aflw_usr_id ='.$user;
			    }
                $current_stage_users = Article_flow::get_results_using_joins($tables,$select_cur,$where,'all');
                $user_titles = $this->UserConfigdata('titles')['titles'];
                $user_info = '';
			    $page_data = array();
			    $template_contents = '';
			    $template_err_msg = '';
                if($current_stage_users->isNotEmpty())
			    {
                $page_data['artflow_id'] = $flow_id;
				$page_data['artp_id'] = $current_stage_users[0]->art_artp_id;
				$page_data['art_id'] = $current_stage_users[0]->art_id;
				$workflow_id = $current_stage_users[0]->aflw_jwf_id;
                if(count($current_stage_users) == 1 && $multiple_users == false)
				{
                    $user_data = $current_stage_users[0];
					$user_data->user_titles = $user_titles;
					$user_data->modal_title = 'Email preview';

                    $array_data['user_id'] = $user_data->usr_id;
                    $array_data['salutation'] = true;
                    $array_data['fullname_only'] = true;
                    //#431 Not showing user middle name in adhoc email popup
                    $user_data->full_name = $this->get_user_display_name($array_data);
					// $page_data['single_user'] = $this->load->view('view_article/templates/tmpl_reviewer_info', $user_data, true);
					$page_data['single_user_data'] = $user_data;
                }
                else
				{
					$page_data['multi_users'] = $current_stage_users;
					$page_data['user_titles'] = $user_titles;
				}

                $tables = array(
                    'main_table' => $Stage_email_tmpl_reference,
                    'join_table' => array(
                        $Stage_email_templates_table => array('stage_etmp_id','setr_stage_etmp_id'),
                    ),
                );
                $select_cur = 'stage_etmp_id,stage_etmp_name,stage_etmp_subject,stage_etmp_content,stage_etmp_cc,stage_etmp_bcc,stage_etmp_cust_cc,stage_etmp_cust_bcc';
                $where = array(
                    'setr_jwf_id' => $workflow_id,
                    'stage_etmp_action' => 'manual_reminder' );
                    if($tmpl_id != '')
                    $where['stage_etmp_id'] = $tmpl_id;
                    $email_templates =Stage_email_tmpl_reference::get_results_using_joins($tables,$select_cur,$where,'all');
                $page_data['global_tmpl'] = false;
                if(($email_templates->isEmpty()) || count($email_templates)==0)
				{
                    // $tml_condition = "etmp_name ='global_manual_remainder'";
                    $tml_condition = array(
                        'etmp_name'=>'global_manual_remainder'
                    );
                    $Email_templates=new \App\Models\Email_templates();
					$evt_based_tmpl =$Email_templates::get_all_records_with_bind_cond("etmp_id,etmp_platform,etmp_name,etmp_templete_name,etmp_cust_to,etmp_cc,etmp_cust_cc,etmp_bcc,etmp_cust_bcc,etmp_content_type,etmp_subject,etmp_email_template",$tml_condition);
					if($evt_based_tmpl->isNotEmpty())
					{
                        $evnt_temp_name=UtilityTrait::Utility('email_hooks')['email_hooks']['global_manual_remainder']['name'];
						$email_tmplte_array = array();
						$email_tmplte_array[0]['stage_etmp_subject'] = $evt_based_tmpl[0]->etmp_subject;
						$email_tmplte_array[0]['stage_etmp_content'] = $evt_based_tmpl[0]->etmp_email_template;
						$email_tmplte_array[0]['stage_etmp_cc'] = $evt_based_tmpl[0]->etmp_cc;
						$email_tmplte_array[0]['stage_etmp_bcc'] = $evt_based_tmpl[0]->etmp_bcc;
						$email_tmplte_array[0]['stage_etmp_cust_cc'] = $evt_based_tmpl[0]->etmp_cust_cc;
						$email_tmplte_array[0]['stage_etmp_cust_bcc'] = $evt_based_tmpl[0]->etmp_cust_bcc;
                        $email_tmplte_array[0]['stage_etmp_name'] = $evnt_temp_name;
                        $email_tmplte_array[0]['stage_etmp_id'] = $evt_based_tmpl[0]->etmp_id;
						$email_templates = json_decode(json_encode($email_tmplte_array));
                        // $email_templates = json_encode($email_tmplte_array);
                        // $email_templates =$email_tmplte_array;
						$page_data['global_tmpl'] = true;
					}
                }
                // print_r($evt_based_tmpl[0]->etmp_id );exit;
                $page_data['reminder_templates'] = $email_templates;
				$page_data['reminder_template_content'] = '';
				$return_arr['emaildata'] = '';
				$page_data['selected_tmpl'] = '';
				$page_data['valid_email_content'] = 'false';
                //let do
                //set email contents
				if(count($email_templates) > 0)
				{
					if($current_stage_users[0]->jwf_stage_type == 'review' && $current_stage_users[0]->aflw_status == 'a')
					{
						if(strpos($email_templates[0]->stage_etmp_content,'##DIRECT_ACCEPT##') > 0 || strpos($email_templates[0]->stage_etmp_content,'##DIRECT_REJECT##') > 0)
						{
							$template_err_msg = 'invalid links';
						}
					}
					$processed_data = $this->set_email_preview($email_templates[0],$current_stage_users[0],$user_titles,$post_data);

					if($processed_data['content'] != '')
						$page_data['valid_email_content'] = 'true';

					$page_data['reminder_template_content'] = $processed_data['content'];
					$template_contents = $processed_data['content'];
					$return_arr['emaildata'] = $processed_data['email_data'];
					$return_arr['valid_data'] = 'true';
				}
				else
				{
					$page_data['no_users_msg'] ="Manual reminder email is not configured. Please contact the administrator to configure manual reminders.";
                    $page_data['empty_flag'] =true;
				}
                //let compleet
                }
                else
			{
				$page_data['no_users_msg'] ="There are currently no users to send manual reminders to.";
                $page_data['empty_flag'] =true;
			}
            $return_arr['tmpl_contents'] = 'false';
			$page_data['template_err_msg'] = $template_err_msg;
			if($only_template_contents == true)
			{
				$content = $template_contents;
				$return_arr['tmpl_contents'] = 'true';
			}
            else
            {

                $return_arr['status'] = 'success';
                $return_arr['page_data'] =$page_data;
                if(isset($email_templates)){
                    foreach ($email_templates as $email_template)
                    {
                        if(isset($email_template->stage_etmp_cc) &&$email_template->stage_etmp_cc !='')
                        {
                            $email_template->stage_etmp_cc=json_decode($email_template->stage_etmp_cc);
                        }
                        if(isset($email_template->stage_etmp_bcc) &&$email_template->stage_etmp_bcc !='')
                        {
                            $email_template->stage_etmp_bcc=json_decode($email_template->stage_etmp_bcc);
                        }
                    }
                }
                $return_arr['email_templates']=isset($email_templates)?$email_templates:'';

            }
        }
                 return $this->success('Success', 200, $return_arr);
        }
        catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }

    }
    //Task 662 Send manual reminder from to stage users like reviewers and authors
	public function set_email_preview($template,$stage_data,$user_titles,$post_data)
	{
		$template_contents = '';
		$data = array();
		if(!empty($template))
		{
			$user_roles = User_to_journals::get_user_role_classification($stage_data->art_id, 'a');
			$email_data =(object) array(
				'article_id' => $stage_data->art_id,
				'name' => $stage_data->user_fullname,
				'user_email' => $stage_data->usr_email,
				'user_id' => $stage_data->usr_id,
				'replace_email_link_tags' => true,
				'aflw_id' => $stage_data->aflw_id,
				'all_user_roles' => $user_roles
			);
            $this->current_user = $this->get_current_user_details();
			// $this->load->library('email');
			// $this->load->library('Sendemail', array(
			// 	'client' => $this->current_client));

			// $load = array(
			// 	'users' => $this->Users,
			// 	'Custom_email_template_tags' => $this->Custom_email_template_tags,
			// 	'utility' => $this->utility,
			// 	'Stage_email_templates' => $this->Stage_email_templates,
			// 	'email' => $this->email,
			// 	'email_log' => $this->Email_send_log,
			// 	'Article_pdf' => $this->Article_pdf,
			// 	'Generic_form_elements' => $this->Generic_form_elements
			// );
			$select = 'jwf_stage_type';
            $where ="aflw_art_id ={$email_data->article_id} AND aflw_id={$email_data->aflw_id} ";
			$current_status = Article_flow::get_generic_flow($select, $where);
			$client_code = $this->current_client->clnt_client_code;
			// $review_config = $this->config->load('clients/' . $client_code . '/workflow_config');
            $review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
			// $review_flow = $this->config->item('review_flow');
			// $this->load->library('workflow');
			$email_data->artp_id = $stage_data->art_artp_id;
			$email_data->jnl_id = $this->decrypt_data($post_data['jnlid']);
			$email_data->jnl_journal_code = $post_data['jnl_code'];
			$email_data->email_templates_config = $this->email_templates_config();
			if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
				$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];

			$email_data->join_config = $this->join_config();
			$email_data->join_dependency_config = $this->join_dependency_config();
			$email_data->user_role_tags = $this->user_role_tags();
			if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
				$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

			// clearing user_email after each mail send, to avoid merging on "custom to"
			$email_data->user_email = '';

			$tmpl_subject = $template->stage_etmp_subject;
			$tmpl_body = $template->stage_etmp_content;
			//since due_date get only after send : calculate for preview
			$email_data->article_status_details_for_init[0] = array(
				'ARTICLE_STATUS_NAME' => $stage_data->jwf_status_name,
				'ARTICLE_STAGE_NAME' => $stage_data->jwf_stage_name,
				// 'TASK_DUE_DATE' => $stage_data->aflw_due_date,
				// 'TASK_REMAINING_DAYS' => $stage_data->TASK_REMAINING_DAYS
			);
            //let do $loaddata
			$email_data = $this->build_email_links($email_data,$stage_data);


			if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0)
				$tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);

			$body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->current_user, $user_titles, true, true);

            preg_match_all('/##([^##]*)##/', $body, $matches);
            $keys = $matches[1];
            for ($i = 0; $i < count($keys); $i++) {
                $element = $keys[$i];
                if(!empty($element))
                {
                $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
                $body = $tmpl_data;
                }
            }
            $body = str_ireplace('##', '', $body);
            $body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
            $body=  str_ireplace('</button></button>','</button>', $body);
			//echo $body;die;
			$subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject, $this->current_user, $user_titles, true);

			$reply_to = '';
            //reply_to start
            $current_status = array();
            $article_flow_table = (new \App\Models\Article_flow);
            if((isset($email_data->article_id)&&$email_data->article_id!=null)&&(isset($email_data->aflw_id )&&$email_data->aflw_id!=null))
            {
            $select = 'jwf_stage_type,jwf_role_id';
            $where ="aflw_art_id={$email_data->article_id} AND aflw_id={$email_data->aflw_id}";
            $current_status = $article_flow_table::get_generic_flow($select, $where);
            }
            $reply_to=$this->get_reply_to_email($email_data->jnl_id,$current_status);
            //reply_to end
            /*
			if (isset($this->current_client->email_settings['reply_to_email']) && $this->current_client->email_settings['reply_to_email'] != '')
			{
				$reply_to = $this->current_client->email_settings['reply_to_email'];
			}
			if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y")
			{
				if ($this->jnl_data->jset_reply_to_email != "" && $this->jnl_data->jset_reply_to_email != null)
					$reply_to = $this->jnl_data->jset_reply_to_email;
			}
			if(isset($review_flow[$current_status[0]->jwf_stage_type]['stage_for']) && $review_flow[$current_status[0]->jwf_stage_type]['stage_for'] == 'manageproduction')
			{
				if (isset($this->jnl_data->jset_reply_to_email_traction) && $this->jnl_data->jset_reply_to_email_traction != "" && $this->jnl_data->jset_reply_to_email_traction != null)
					$reply_to = $this->jnl_data->jset_reply_to_email_traction;
			}
            */

			//Bug #1809 : JPR-260 Remove options for cc and bcc roles in invitation email
			$to_cc_arr = json_decode($template->stage_etmp_cc);
			$to_bcc_arr = json_decode($template->stage_etmp_bcc);
			$cc_bcc_roles = array();
			$disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
			if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
			{
            $role_used = $this->RolesConfigdata('privileged_user_roles');
            $privileged_roles = $role_used['privileged_user_roles'];
			$roles_condition = 'role_assigned_role IN("' . implode('","', $privileged_roles) . '")';
			 $user_roles = Roles::get_all_records('role_name, role_assigned_role', $roles_condition);
			if (!empty($user_roles))
			{
				foreach ($user_roles as $usrole)
				{
					$role_label = "All " . $usrole->role_name . "s";
					$cc_bcc_roles[$usrole->role_name] = $role_label;
				}
			}
			}
			$cc_bcc_roles['Custom'] = 'Specific email ID';
			$data = array(
				'status' => 'success',
				'cc_bcc_roles' => $cc_bcc_roles,
				//'user_ids' => $usr_ids,
				//'aflw_id' => $stage_data->aflw_id,
				'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
				'to_cc' => $to_cc_arr,
				'to_bcc' => $to_bcc_arr,
				'cust_cc' => $template->stage_etmp_cust_cc,
				'cust_bcc' => $template->stage_etmp_cust_bcc,
				'stage_etmp_id' => $template->stage_etmp_id,
				'reply_to' => $reply_to,
				'subject' => $subject,
				'content' => $body,
				'btn_confirm_msg' => $this->current_client->functionality->cfty_disable_unnecessary_confirm,
				//'invite_templates' => $all_templates,
				//'user_info' => $user_info
				);
		}

		return array(
			'content' => $template_contents,
			'email_data' => $data
		);
	}
    //$email_data is an object array
	public function build_email_links($email_data,$user_details)
	{
		// $this->load->helper('string');
		$update_deeplink = false;
		$link = $accept_link = $reject_link = $aflw_deeplink_token = '';

		if(isset($user_details->usr_id) && $user_details->usr_id != '')
		{

			if ($user_details->usr_status == 'w')
			{
				if (!empty($user_details->usr_deeplink_token))
				{
					$aflw_deeplink_token = $user_details->usr_deeplink_token;
					if ($user_details->aflw_deeplink_token != $user_details->usr_deeplink_token)
					{
						$update_deeplink = true;
					}
				}
				else
				{
					//$aflw_deeplink_token = random_string('alnum', 16);
                    $aflw_deeplink_token = Str::random(20);
                    //let do
                    /*
					$load_models['Users']->update_record(array(
						'usr_deeplink_token' => $aflw_deeplink_token), array(
						'usr_id' => $user_details->usr_id));
                    */
					$update_deeplink = true;
				}
			}
			else
			{
                if ($user_details->aflw_deeplink_token == null || $user_details->aflw_deeplink_token == '')
				{
                    $update_deeplink = true;
                    $aflw_deeplink_token = Str::random(20);
					// $aflw_deeplink_token = random_string('alnum', 16);
				}
				else
				{
					$aflw_deeplink_token = $user_details->aflw_deeplink_token;
				}
			}

			$condition = array(
				'aflw_id' => $user_details->aflw_id,
				'aflw_usr_id' => $user_details->usr_id
			);
			if ($update_deeplink == true)
			{
                //let do
                /*
                Article_flow::update_record(array(
                    'aflw_deeplink_token' => $aflw_deeplink_token), array(
                        'aflw_id' => $user_details->aflw_id,
                        'aflw_flow_operation'=>'e'));
                        */
                    }


			$link = URL::to('journal/' . $email_data->jnl_journal_code  . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_details->usr_id . '&article_flow_id=' . $user_details->aflw_id));

			$accept_link =  URL::to('journal/' . $email_data->jnl_journal_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_details->usr_id . '&btn=accept' . '&article_id=' . $user_details->art_id . '&status_id=' . $user_details->aflw_id . '&user_role=reviewer'));

			$reject_link =  URL::to('journal/' . $email_data->jnl_journal_code . '/accept-reject-review' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_details->usr_id . '&btn=reject' . '&article_id=' . $user_details->aflw_id . '&status_id=' . $user_details->art_id . '&show_user_terms_condition_modal=hide'));

		}

		$reset_link = URL::to('reset-password?' . encrypt_link('&userid=' . $user_details->usr_id . '&datetime=' . date("Y-m-d H:i:s")));
		$set_link = URL::to('set-password?' . encrypt_link('&userid=' . $user_details->usr_id . '&datetime=' . date("Y-m-d H:i:s")));
		$email_data->CONFIRMATION_URL = $link;
		$email_data->DIRECT_ACCEPT = $accept_link;
		$email_data->DIRECT_REJECT = $reject_link;
		$email_data->RESET_PASSWORD_LINK = $reset_link;
		$email_data->SET_PASSWORD_LINK = $set_link;

		$current_date_time = date('Y-m-d H:i:s');

		$verifyactivation_url = md5(uniqid(rand(), true) . '' . $current_date_time);

        $encrypted_userid = encrypt_link($user_details->usr_id);

        $email_data->VERIFY_EMAIL = URL::to('verify-user/primary-email?token=' . $verifyactivation_url . '&id=' . $encrypted_userid);
        $email_data->REVERT_EMAIL = URL::to('revert-user/primary-email?token=' . $verifyactivation_url . '&id=' . $encrypted_userid);

		return $email_data;
	}
    //Task 662 Send manual reminder from to stage users like reviewers and authors
	public function send_manual_reminder(Request $request)
	{
        try{
        $this->current_user = $this->get_current_user_details();
        $post_data=$request->reminder;

		$return_arr = array(
			'status'=> 'failed',
			'msg' => 'invalid_data'
        );
        if (is_array($post_data['to'])) {
        foreach ($post_data['to'] as $encrypted_email) {
            $decrypted_email = decrypt_link($encrypted_email);
            $to_data[] = $decrypted_email;

        }
        }else{
            $to_data[] =decrypt_link($post_data['to']);
        }
        $send_mail_to_usr_ids = [];
        $send_mail_to = [];

        foreach ($to_data as $item) {
            $parts = explode('##', $item); // Split on the delimiter

            if (count($parts) === 2) { // Ensure valid format (ID and email)
                $id = (int) $parts[0]; // Cast to integer for ID
                $email = $parts[1];

                $send_mail_to_usr_ids[] = $id;
                $send_mail_to[] = $email;
            }
        }
		if($send_mail_to != '' && $send_mail_to_usr_ids != ''  && $post_data['template'] != '' && $post_data['stage_template_sub'] && $post_data['stage_template_content'] != '' && $post_data['hdn_artp'] != '' && $post_data['hdn_art_id'] != '')
		{
			$artp_id = decrypt_link($post_data['hdn_artp']);
			$art_id = decrypt_link($post_data['hdn_art_id']);
             if (is_array($post_data['to'])) {
                
                    $aflw_id = $post_data['hdn_stage'];  
             }
            else
            {
                $aflw_id = decrypt_link($post_data['hdn_stage']);
            }
			if($post_data['template'] !== "global_template")
			{
				$tmpl_condition = array(
					'stage_etmp_id' => decrypt_link($post_data['template']),
					'stage_etmp_action' => 'manual_reminder'
				);
				$template = Stage_email_templates::get_single_record_with_bind_cond('*, stage_etmp_content AS stage_etmp_email_template', $tmpl_condition);
			}
			else
			{
                $tml_condition = array(
                    'etmp_name'=>'global_manual_remainder'
                );
				$evt_based_tmpl = Email_templates::get_single_record_with_bind_cond("*",$tml_condition);
				if(!empty($evt_based_tmpl))
				{
					$email_tmplte_array = array();
					$email_tmplte_array['stage_etmp_action'] = "manual_reminder";
					$email_tmplte_array['stage_etmp_to'] = $evt_based_tmpl->etmp_notification;
					$email_tmplte_array['stage_etmp_cust_to'] = $evt_based_tmpl->etmp_cust_to;
					$email_tmplte_array['stage_etmp_subject'] = $evt_based_tmpl->etmp_subject;
					$email_tmplte_array['stage_etmp_content'] = $evt_based_tmpl->etmp_email_template;
					$email_tmplte_array['stage_etmp_cc'] = $evt_based_tmpl->etmp_cc;
					$email_tmplte_array['stage_etmp_bcc'] = $evt_based_tmpl->etmp_bcc;
					$email_tmplte_array['stage_etmp_cust_cc'] = $evt_based_tmpl->etmp_cust_cc;
					$email_tmplte_array['stage_etmp_cust_bcc'] = $evt_based_tmpl->etmp_cust_bcc;
					$email_tmplte_array['stage_etmp_email_template'] = $evt_based_tmpl->etmp_email_template;
					$template = json_decode(json_encode($email_tmplte_array));

				}
			}
			$email_data = new stdClass;
			$email_data->article_id = $art_id;
			if (is_array($send_mail_to_usr_ids)) {
                $email_data->user_id = implode(',', $send_mail_to_usr_ids);
            } else {
                $email_data->user_id = $send_mail_to_usr_ids;
            }            
			$email_data->jnl_journal_code = $this->decrypt_data($post_data['jnl_journal_code']);
			$email_data->artp_id = $artp_id;
			$email_data->jnl_id =$this->decrypt_data($post_data['jnl_id']);
			$email_data->aflw_id = $aflw_id;
			$select = 'jwf_stage_type,jwf_role_id';
            $art_flow=[];
            if (is_array($email_data->aflw_id)) {
            foreach ($email_data->aflw_id as $item) {
                if (isset($item)) {
                    $art_flow[]= decrypt_link($item);
                }
            }
        
            if(isset($art_flow) && is_array($art_flow)){
                $email_data->aflw_id = $art_flow[count($art_flow)-1];
            }
            else{
                $email_data->aflw_id = $art_flow;
            }
        }else
        {

            $art_flow[]= $email_data->aflw_id;
            $email_data->aflw_id = $art_flow[0];
        }
            $where = 'aflw_art_id = ' . $email_data->article_id . ' AND aflw_id IN (' . implode(',', $art_flow) . ')'; 
			$current_status = Article_flow::get_generic_flow($select, $where);
			$client_code = $this->current_client->clnt_client_code;
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
			$reply_to = '';

			if($post_data['stage_template_to_mail'] != '')
			{	$reply_to = $post_data['stage_template_to_mail'];}
			else{
                //reply_to start
                $current_status = array();
                $article_flow_table = (new \App\Models\Article_flow);
                if((isset($art_id)&&$art_id !=null)&&(isset($aflw_id)&&$aflw_id!=null))
                {
                $select = 'jwf_stage_type,jwf_role_id';       
                $where = "aflw_art_id = {$email_data->article_id} AND aflw_id IN (" . implode(',', $art_flow) . ")";
                $current_status = $article_flow_table::get_generic_flow($select, $where);
                }
                $reply_to=$this->get_reply_to_email($email_data->jnl_id,$current_status);
                //reply_to end
            }
			if ($reply_to != '')
				$email_data->reply_to = $reply_to;
			$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
            if (is_array($send_mail_to)) {
                $email_data->user_email = implode(',', $send_mail_to);
            } else {
                $email_data->user_email = $send_mail_to;
            } 
            if (is_array($send_mail_to_usr_ids)) {
                $email_data->mail_recipient_ids = implode(',', $send_mail_to_usr_ids);
            } else {
                $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
            } 
			$email_data->all_user_roles = User_to_journals::get_user_role_classification($art_id, 'a');
			$email_data->subject = trim($post_data['stage_template_sub']);
            $replace_button = array('<button contenteditable="false">', '</button>');
            $post_data['stage_template_content'] = str_replace($replace_button, '##', $post_data['stage_template_content']);
			$email_data->body = trim($post_data['stage_template_content']);
			$template->stage_etmp_cc = $template->stage_etmp_bcc = '';
			$template->stage_etmp_cust_cc = $template->stage_etmp_cust_bcc = '';
			if (!empty($post_data['stage_template_to_cc']))
			{
				$template->stage_etmp_cc = json_encode($post_data['stage_template_to_cc']);
				if (in_array('Custom', $post_data['stage_template_to_cc']))
                {
                $optccvalue = array();
				if (isset($post_data['stage_cust_cc'])) {
					$custm_cc = $post_data['stage_cust_cc'];
					for ($i = 0; $i < count($custm_cc); $i++) {
						$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
						$cust_value = str_replace('\\', '"', $cust_value);
						$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
						array_push($optccvalue, $cust_value);
					}
					$post_data['stage_cust_cc'] = implode(',', $optccvalue);
                    $template->stage_etmp_cust_cc = trim($post_data['stage_cust_cc']);

				}
				else{
					$post_data['stage_cust_cc']='';
				}
                }

			}
			if (!empty($post_data['stage_template_to_bcc']))
			{
				$template->stage_etmp_bcc = json_encode($post_data['stage_template_to_bcc']);
				if (in_array('Custom', $post_data['stage_template_to_bcc']))
                $optccvalue = array();
				if (isset($post_data['stage_cust_bcc'])) {
					$custm_cc = $post_data['stage_cust_bcc'];
					for ($i = 0; $i < count($custm_cc); $i++) {
						$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
						$cust_value = str_replace('\\', '"', $cust_value);
						$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

						array_push($optccvalue, $cust_value);


					}
					$post_data['tmpl_cust_bcc'] = implode(',', $optccvalue);
                    $template->stage_etmp_cust_bcc = trim($post_data['tmpl_cust_bcc']);

				}
				else{
					$post_data['tmpl_cust_bcc']='';
				}
			}
			$email_data->email_templates_config = $this->email_templates_config();
			if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
				$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];


			$email_data->email_templates_config =$this->email_templates_config();
			if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
				$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->user_role_tags = $this->user_role_tags();
			if (strpos($template->stage_etmp_email_template,"OPENING_PARAGRAPH") > 0)
				$template->stage_etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$template->stage_etmp_email_template);
			$artp_settings = Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params', "atotp_artp_id={$artp_id}");
			if(!empty($artp_settings))
			{
				$template->review_method = $template->assignments='';
				if(isset($post_data['jnl_journal_code']) && isset($this->current_user['jnl_user_role']))
				{
					$core_role = $this->current_user['jnl_user_role'][$post_data['jnl_journal_code']]['core_role'];
				}
				elseif(isset($current_status[0]->jwf_role_id))
				{
					$roles = Roles::get_single_record('role_assigned_role',"role_id={$current_status[0]->jwf_role_id}");
					$core_role = $roles->role_assigned_role;
				}
				if($core_role == 'reviewer' && ($template->stage_etmp_to == 'submit_author' || $template->stage_etmp_to == 'Author' || $template->stage_etmp_to == 'article_authors' || $template->stage_etmp_to == 'Authors'))
				{
					$template->review_method = $artp_settings->atotp_review_method;
				}
			}
			$core_role=(isset($this->current_user['jnl_user_role'][$post_data['jnl_journal_code']]))?$this->current_user['jnl_user_role'][$post_data['jnl_journal_code']]['core_role']:'';
			$email_data->core_role = $core_role;
			$core_role_name=(isset($this->current_user['jnl_user_role'][$post_data['jnl_journal_code']]))?$this->current_user['jnl_user_role'][$post_data['jnl_journal_code']]['role_name']:'';
			$email_data->core_role_name = $core_role_name;
            $email_data->body = $this->generate_email_data_from_keys($email_data,$email_data->body,$this->current_user);
			$result = $this->send_email_notification($template, $email_data, $this->current_user, 'stage_etmp_');
            /** Task #8549, Incorrect toast message "invalid_data" appears while sending a global manual reminder issue fix ->start */
            if($result === 'no_active_user')
                {
                    $return_arr['status'] = 'success';
                    $return_arr['msg'] = customTrans('email_template.no_active_users');
                    $return_arr['flag'] = 'no_active_users';
                }
            else if($result == true)
            {
                $return_arr['status'] = 'success';
                $return_arr['msg']=customTrans('email_template.email_snt');
                }
            /** Task #8549, Incorrect toast message "invalid_data" appears while sending a global manual reminder issue fix ->end */
		}
		return $this->success('Success', 200, $return_arr);
    }
        catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
	}

    //*** transfer data with out author confirmation */
    public function transfer_without_confirmation(Request $request)
	{
        try{
            $current_user= $this->get_current_user_details();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnlcode' => 'required',
                'art_id' => 'required',
                'flow_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $user_id = $current_user['user_id'];
            $jnlcode=decrypt_link($post_data['jnlcode']);
            $article_id = decrypt_link($post_data['art_id']);
            $cur_status_id = decrypt_link($post_data['flow_id']);
            $platform_data = $this->platform_basic_settings_data($jnlcode);
            $jnl_id = $platform_data->jnl_id;
           // DB::enableQueryLog();
            $condition="ats_art_id=:article_id and ats_src_jnl=:jnl_id and ats_aflw_id=:cur_status_id";
            $condition_arr = array(
                'article_id' => $article_id,
                'jnl_id' => $jnl_id,
                'cur_status_id' => $cur_status_id);
            $Article_transfer_suggestion = new \App\Models\Article_transfer_suggestion();
            $existing_data = $Article_transfer_suggestion::get_single_record('ats_author_action,ats_article_data', $condition,null,'',null,$condition_arr);
            //$result=DB::getQueryLog();
            //dd($result);

            $insert_data['ats_author_action'] = 1;
            $insert_data['ats_action_time'] = date('Y-m-d H:i:s');
           //     print_r($existing_data); die;
		if ($existing_data != null)
		{
            $conditiondata="ats_art_id={$article_id} and ats_src_jnl={$jnl_id} and ats_aflw_id={$cur_status_id}";
            $save_status = $Article_transfer_suggestion::update_record($insert_data, $conditiondata, $current_user);
			$author_action = $existing_data->ats_author_action;
			$transfer_mode = $existing_data->ats_article_data; //1 - resubmit 2 - move to particular stage
			$transfer_details = $Article_transfer_suggestion::get_single_record('*', $condition,null,'',null,$condition_arr);
            $this->transfer_article_create_new($article_id, $cur_status_id, true,$jnl_id, $jnlcode);

			if ($transfer_mode == 2) // Author accept Transfer article
			{
                $transfer_stgae = $this->transfer_article_with_stage($transfer_details, $article_id, $cur_status_id, $jnl_id, $jnlcode, true);
                $next_flowid=$transfer_stgae['insertid']?$transfer_stgae['insertid']:'';
                $return_data['next_flowid']= $next_flowid;
            }

		}

        $iss_conditon="art_id=:art_id";
        $iss_arr=array('art_id'=>$article_id);
        $articledata = Articles::get_single_record('art_artp_id', $iss_conditon,null,'',null,$iss_arr);
        $iss_conditon="artp_id=:artp_id";
        $iss_arr=array('artp_id'=>$articledata->art_artp_id);
        $Article_types = new \App\Models\Article_types();
        $articletypes = $Article_types::get_single_record('artp_article_type', $iss_conditon,null,'',null,$iss_arr);
        $return_data['arttypeid']= $articledata->art_artp_id;
        $return_data['arttype']= $articletypes->artp_article_type;
		//$return_data['msg']= 'success';
		return $this->success('Success', 200, $return_data);
    }
    catch (\Exception $e) {

        return $this->failure('Failed', 500, $e);
    }
	}
    //*** transfer data with out author confirmation */

// Assignment email  send
public function get_stage_assignment_emaildetails($assigned_users,$article_cur_stage,$jnl_id='',$jnlcode='')
{

    $Stage_email_templates = new \App\Models\Stage_email_templates();
    $article_cur_stage=$article_cur_stage[0];
    $select = 'stage_etmp_id';
    $condition ="setr_jwf_id={$article_cur_stage->jwf_id} AND stage_etmp_action='assigned'";
    $email_templates_assign = $Stage_email_templates::get_stage_email_tmpl_to_trigger($select, $condition);

    if(count($assigned_users) > 0 && count($email_templates_assign) > 0)
    {
        foreach ($assigned_users as $user)
        {
            $data = array();
            foreach ($email_templates_assign as $emil_temp)
            {
                $data['tmpl_id'] = $emil_temp->stage_etmp_id;
                $data['article_id'] = $article_cur_stage->aflw_art_id;
                $data['user_id'] = $user;
                $data['article_type'] = $article_cur_stage->art_artp_id;
                $data['aflw_id'] = $article_cur_stage->aflw_id;

                $this->send_change_assign_email($data,true,false,$jnl_id,$jnlcode);
            }
        }
    }
    return;
}


public function removecopyright_attachments(Request $request) { // copy right
    try {
        $validator = Validator::make($request->all(), [
            'copyright_id'      => 'required'
        ]);
        if ($validator->fails()) {
            return  $this->warning('Warnings',200,$validator->errors(),'warning');
        }
        $result=array();
        $this->current_user = $this->get_current_user_details();
        $form_data = $request->all();


        $copyright_id=$this->decrypt_data($form_data['copyright_id']);
        $jnl_code=$form_data['jnl_code'];
        $jnl_id=$form_data['jnl_id'];

        $input_arr = array('input' => $jnl_id,'type'=> 'number');
        $jnl_id_validate = $this->Rv_validator($input_arr);


        $input_arr = array('input' => $jnl_code);
        $jnl_code_validate = $this->Rv_validator($input_arr);

        $input_arr = array('input' => $copyright_id,'type'=> 'number');
        $copy_id_validate = $this->Rv_validator($input_arr);

        if($jnl_id_validate != true || $jnl_code_validate != true || $copy_id_validate != true ){
            $res['msg']=customTrans('viewarticle.invalid_data');
            return  $this->warning('Warnings',200,$res,'warning');
        }
        $jnlcodevalid = $this->validatecode(array('jnl_code'=>$form_data['jnl_code']));
        if($jnlcodevalid['jnl_code'] != true ){
            $res['msg']=customTrans('viewarticle.invalid_data');
            return  $this->warning('Warnings',200,$res,'warning');
        }


if($jnl_id_validate==true && $jnl_code_validate==true && $copy_id_validate==true ){



        $Copyright_table = new \App\Models\Copyright();

        $copyrightresult = $Copyright_table::get_single_record('copy_location,copy_att_name,crt_posted_by',"crt_id={$copyright_id}");


        if (!empty($copyrightresult)) {

            if($copyrightresult->crt_posted_by!=$this->current_user['user_id']) {
                $res['msg']='User has no permission to delete this file';
                return  $this->warning('Warning', 200,$res,'warning');
            }

            $update_data = array(
                'copy_location' => null,
                'copy_att_name' => null
            );
            $isat_id    = $Copyright_table::update_record($update_data, "crt_id={$copyright_id} and crt_posted_by={$this->current_user['user_id']}");

            $file_path = public_path() . '/storage/'.$copyrightresult->copy_location;

            //Upgrade #2293 Manage review uploads
            $aws_path=$copyrightresult->copy_location;


            $this->remove_fileinfolder($file_path,$copyrightresult->copy_att_name,$aws_path);


            return $this->success('Success', 200, 'Successfully deleted');


        } else {
            $res['msg']='Remove file failed';
            return  $this->warning('Warnings',200,$res,'warning');
        }

    } else {
        $res['msg']=customTrans('viewarticle.invalid_data');
        return  $this->warning('Warnings',200,$res,'warning');
    }



    } catch(\Exception $e) {
        //DB::rollback();
        return  $this->failure('Failed',500,$e);
    }

}

    public function get_original_flow_id(Request $request)
    {
        try{
            $validator = Validator::make($request->all(), [
                'jwf_assignment' => 'required',
                'aflw_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }
            $post_data = $request->all();
            $jwf_assignment = isset($post_data['jwf_assignment']) ? $post_data['jwf_assignment']:null;
            $aflw_id = isset($post_data['aflw_id']) ? $post_data['aflw_id']:null;
            if($jwf_assignment == 'manual' && $aflw_id != null) {
                $child_stagedata = Article_flow::get_single_record('aflw_id',"aflw_parent_flow_id={$aflw_id}");
                if($child_stagedata && isset($child_stagedata->aflw_id))
                {
                    $child_stage_id = $child_stagedata->aflw_id;
                    $result = array(
                        'child_stage_id' => $child_stage_id
                    );
                }
                else
                {
                    $result = array(
                        'child_stage_id' => $aflw_id
                    );
                }
                return $this->success('Success', 200, $result);
            }
            else
            {
                $result = array(
                    'child_stage_id' => $aflw_id
                );
                return $this->success('Success', 200, $result);
            }
        } catch(\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function get_completed_multipleforms($article_flow_details, $privilages, $user_roles, $current_user, $jnlcode,$aflw_stage_repeat_count)
    {
        $where = '';
        $message='';
        $article_privilages=$privilages;
        $child_article_flows = array();
        $author_stages = array('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission');
        if ($this->current_client->modules->mdl_production == 'y') {
            $author_stages[] = 'pro_revision';
        }
        $this->current_user = $this->get_current_user_details();
        $Article_type_advance_options = new \App\Models\Article_type_advance_options();
        $article_type_advance =$Article_type_advance_options::get_single_record('atotp_review_open_decision,atotp_review_open_count,atotp_review_method,atotp_custom_blind_params',"atotp_artp_id=:artp_id",null,'',null,array('artp_id'=>$article_flow_details->artp_id));

        $stage_author = false;
        if (in_array($article_flow_details->jwf_stage_type, $author_stages))
            $stage_author = true;

        $where = ' gdata_artflw_id =' . $article_flow_details->aflw_id . ' AND gdata_artflw_stage_repeat_count < ' . $aflw_stage_repeat_count;
        $forms = array();
        $forms_exist = array();
        if ($where != '') {

            $where_exist=$where;
           // if ($article_flow_details->jwf_stage_type == 'review' || $article_flow_details->jwf_stage_type == 'author_submission') { //code is commented as user can see all the elements in the form when a single element is assigned for a privilaged stage.
                if ($privilages['author'] == true && isset($article_type_advance->atotp_review_method) && $article_type_advance->atotp_review_method != 'o') {
                    $author_role_id = $user_roles['role_id'][0]; // when user has author role in an article then other roles are removed
                    //author need to display all author form regardless of checking the viewable form
                    if ($stage_author == false) {

                        //1901 Reviewer comments not visible to author
                        $where .= ' AND CASE WHEN FIND_IN_SET(' . $author_role_id . ',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND  FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true END ';
                    }
                } elseif($privilages['author'] == false && $privilages['reviewer'] == false) {
                    $user_roles_form = $user_roles["role_id"];
                    if ($privilages['privilaged'] == true) {
                        $author_key = array_search("author", $user_roles["assigned_roles"]);
                        if ($author_key!==false && $author_key >= 0) {

                            unset($user_roles_form[$author_key]);
                        }
                    }
                    $where .= ' and CASE WHEN gncf_user_roles IS null THEN true WHEN gncf_user_roles = "[]" THEN true WHEN FIND_array_intersect(REPLACE(REPLACE(REPLACE(gncf_user_roles,\']\',\'\'),\'[\',\'\'),\'"\',\'\'), "' . implode(",", $user_roles_form) . '") >0 THEN true WHEN gdata_posted_by =' . $current_user["user_id"] . ' THEN true END';

				} elseif($privilages['reviewer'] == true) {
                    $author_role_id = $user_roles['role_id'][0];
					$where .= ' AND CASE WHEN FIND_IN_SET('.$author_role_id.',REPLACE(REPLACE(REPLACE(gncf_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true WHEN (gncf_user_roles IS null OR gncf_user_roles = "[]") AND FIND_IN_SET("' . $author_role_id . '",REPLACE(REPLACE(REPLACE(gdata_user_roles,\'"\',""),"]",""),"[","")) > 0 THEN true  WHEN gdata_posted_by =' . $this->current_user["user_id"].' THEN true END';
				}
            //}
            //$query = DB::enableQueryLog();
            // remove element form custom form settings bug fixed
            $form_select ="CASE WHEN emt_hideafterstage IS NULL THEN (SELECT emt_hideafterstage FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='label' order by tbk_id DESC limit 1) ELSE emt_hideafterstage END AS emt_hideafterstage, CASE WHEN emt_element_type IS NULL THEN (SELECT emt_element_type FROM tbk_generic_form_elements WHERE emt_id=gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date <=gdata_posted_date order by tbk_id DESC limit 1) ELSE emt_element_type END AS emt_element_type, CASE WHEN emt_tinymce_required IS NULL THEN (SELECT emt_tinymce_required FROM tbk_generic_form_elements WHERE emt_id = gdata_atfemt_id and emt_gucf_id=gdata_atf_id and emt_posted_date<=gdata_posted_date and emt_element_type='textarea' order by tbk_id DESC limit 1) ELSE emt_tinymce_required END AS emt_tinymce_required,";


            $form_select .= 'gdata_dynamic_status,gdata_art_id,gdata_gform_title,gdata_group_name,gdata_label,gdata_user_roles,gdata_element_type,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_atf_id,gdata_artflw_id,gdata_posted_by,gdata_gfg_id,gncf_form_type,gncf_user_roles,gncf_posted_by,gncf_form_privilege_usr_edit';

            $formatted_journal_code = '_' . $jnlcode;
            $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
            $Generic_forms_table = (new \App\Models\Generic_forms())->getTable();

            $details_tables = array(
                'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
                'join_table' => array(
                    $Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
                    $Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id','left'),

                )
            );

            $completedforms = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', 'gdata_data_order,gdata_posted_date asc', null, '', null, null, true);
            //$forms_exist = Article_flow::get_results_using_joins($details_tables,'GROUP_CONCAT(DISTINCT gdata_artflw_id) as gdata_artflw_id', $where_exist,'single', 'gdata_data_order asc', null, '', null, null, true);

        }

         //$query = DB::getQueryLog();
         //dd($query);
        // print_r($query);exit;
        //$return_arr =array('forms'=>$forms,'forms_exist'=>$forms_exist,'child_article_flows'=>$child_article_flows);


        $completedformarr=array();

        if($article_flow_details->jwf_assignment != 'invitation') {
            $viewable_emt = 0;
            $formid_emt=0;
            $incval=0;
            if(!empty($completedforms)) {
                $forms=count($completedforms);
            }
            foreach ($completedforms as $formdata) { $incval++;
                //foreach ($form as $formdata) {
                    if($formid_emt!=$formdata->gdata_atf_id){
                        $permission_form=false;
                        $formid_emt = $formdata->gdata_atf_id;
                        $viewable_emt = 0;
                        $completedformarr['count'.$formdata->gdata_artflw_stage_repeat_count][$article_flow_details->aflw_id]['group'][$formdata->gdata_atf_id]['form_visible'] = 0;

                    }
                    $gncf_user_roles = json_decode($formdata->gncf_user_roles);
                    if (!empty($gncf_user_roles) && $formdata->gdata_posted_by != $this->current_user["user_id"]) {

                        foreach ($user_roles['role_id'] as $ri) {
                            if (in_array($ri, $gncf_user_roles)) {
                                $permission_form = true;
                                break;
                            }
                        }
                    } elseif ($formdata->gdata_posted_by == $this->current_user["user_id"] || empty($gncf_user_roles)) {
                        $permission_form = true;
                    }

                    $stg_flw_user_id =  $formdata->gdata_posted_by;

                    if ($formdata->gncf_form_type == 'resubmission' &&  $this->current_client->functionality->cfty_edit_author_response_form == 'y') {
                        $stg_flw_user_id =  Article_flow::get_single_record('aflw_usr_id',"aflw_id={$formdata->gdata_artflw_id}")->aflw_usr_id;
                        if($stg_flw_user_id == $this->current_user["user_id"]) {
                            $permission_form = true;
                        }
                    }

                    //$user_data = $User::get_single_record('usr_first_name, usr_middle_name, usr_last_name,usr_orcid_id',"usr_id={$stg_flw_user_id}");
                    $completedformarr['count'.$formdata->gdata_artflw_stage_repeat_count][$article_flow_details->aflw_id]['group'][$formdata->gdata_atf_id]['form_id'] = $formdata->gdata_atf_id;
                    $completedformarr['count'.$formdata->gdata_artflw_stage_repeat_count][$article_flow_details->aflw_id]['group'][$formdata->gdata_atf_id]['form_title'] = $formdata->gdata_gform_title;
                    $completedformarr['count'.$formdata->gdata_artflw_stage_repeat_count][$article_flow_details->aflw_id]['group'][$formdata->gdata_atf_id]['permission_form'] = $permission_form;

                    $formdata->element_viewstatus=true;

                    if(!empty($formdata->gdata_user_roles) && isset($user_roles['role_id']) && $this->current_user["user_id"] != $formdata->gdata_posted_by   ) {
                        $emt_viewable_rls = explode(',', $formdata->gdata_user_roles);
                        if(count(array_intersect($user_roles['role_id'], $emt_viewable_rls)) == 0) {
                            $formdata->element_viewstatus=false;
                            continue;
                        }
                    }



                    $viewable_emt++;
                    $order=$formdata->gdata_data_order;
                    if(empty($order)){
                        $order=$forms;
                    }

                    if($permission_form==true) {
                        if ($formdata->gdata_element_type == 'file' && $formdata->gdata_data != '') {
                            $temp_arr = json_decode($formdata->gdata_data);
                            $file_view_permission = false;
                            $gen_file = array();
                            if(count($temp_arr) > 0) {
                                $file_array = implode(',',$temp_arr);
                                $Generic_form_files = new \App\Models\Generic_form_files;
                                $gen_file = $Generic_form_files::get_all_records('agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_array . ')');
                                if ($privilages['privilaged'] == true || $privilages['reviewer'] == true || $privilages['author'] == true || ( isset($article_type_advance->atotp_review_method) && $article_type_advance->atotp_review_method == 'o' && $article_flow_details->art_submitted_by == $this->current_user['user_id'])) {
                                    $file_view_permission = true;
                                }
                            }
                            $formdata->gen_filenames = $gen_file;
                            $formdata->file_view_permission = $file_view_permission;
                        }

                    }
                    $completedformarr['count'.$formdata->gdata_artflw_stage_repeat_count][$article_flow_details->aflw_id]['group'][$formdata->gdata_atf_id][$order] = $formdata;
                    $completedformarr['count'.$formdata->gdata_artflw_stage_repeat_count][$article_flow_details->aflw_id]['group'][$formdata->gdata_atf_id]['form_visible'] = $viewable_emt;
               // }
                //$completedformarr[$flow->aflw_id] = $form;
            }
            if(count($completedformarr)>0){
                $article_flow_details->completedform = $completedformarr;
            }
        }


            //if((isset($completedformarr[$flow->aflw_id]) && empty($completedformarr[$flow->aflw_id]))  || $flow->jwf_assignment=="manual")
            //assignment section visible custom form suggested by Gijo
            if(count($completedformarr)==0  )
            {
                if ((($privilages['reviewer'] == false || ($privilages['reviewer'] == true && $article_flow_details->jwf_stage_type=='review')) || $privilages['author'] == false) && $article_flow_details->art_delete_status == 'h')
    $message = customTrans('viewarticle.article_onhold');
    $is_empty_content = true;
    if ($privilages['privilaged'] == true && !in_array($article_flow_details->aflw_status, array("a","u","p"))) {
        $message = '<p>Completed stage <strong>' . $article_flow_details->jwf_stage_name . '</strong></p>';
    }

    if ($article_flow_details->aflw_status == 'c' && $privilages['privilaged'] == true) {
        $message = '<p>Completed stage <strong>' . $article_flow_details->jwf_stage_name . '</strong></p>';
        $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
        $select = 'jwf_stage_name';
        $art_flw_tables = array(
            'main_table' => $Article_flow_table,
            'join_table' => array(
            $Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id'))
        );

        $childstges = json_decode($article_flow_details->jwf_child_stages);

        $level_min_1 = $article_flow_details->aflw_level - 1;
        $level_plus_1 = $article_flow_details->aflw_level + 1;

        //$art_flw_criteria = 'aflw_art_id = '.$article_id.' AND aflw_level >='.$article_flow_details->aflw_level;
        $art_flw_criteria = 'aflw_art_id = '.$article_flow_details->art_id.' AND aflw_level IN ('.$level_min_1.','.$article_flow_details->aflw_level.','.$level_plus_1.') AND aflw_id > '.$article_flow_details->aflw_id;

        $article_flow_dets = array();
        if(count($childstges) > 0) {
            if(count($childstges) > 1 && ($article_flow_details->jwf_flow_proceed_type == 'parallel' || $article_flow_details->jwf_flow_proceed_type == 'advance') ) {
                $select = 'group_concat(distinct jwf_stage_name) as jwf_stage_name';
            }
            $art_flw_criteria .= ' AND aflw_jwf_id IN ('. implode(', ',$childstges).')';

            $article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'single');
        }

        //Check stage name value set
        if (!empty($article_flow_dets)&&(isset($article_flow_dets->jwf_stage_name)&&$article_flow_dets->jwf_stage_name!='')) {
            $message = '<p>Moved to stage <strong>' . str_replace(',',', ',$article_flow_dets->jwf_stage_name) . '</strong></p>';
        }
    }elseif ($article_flow_details->aflw_status == 'c' && $privilages['privilaged'] == false) {
        $message = '<p>Completed stage <strong>' . $article_flow_details->jwf_status_name . '</strong></p>';
    }
    elseif (in_array($article_flow_details->aflw_status, array("w","p")) && $privilages['privilaged'] == true && $article_flow_details->jwf_stage_type == 'review' && $article_flow_details->aflw_skip_review != "y")
    {
        $message = '<p>Stage <strong>' . $article_flow_details->jwf_stage_name . '</strong> in progress</p>';
    }

                            $article_flow_details->messsage =$message;
            }
                        else
                            $article_flow_details->messsage ='';


    }

    public function get_compeltedForm_details(Request $request)
    {
        try
        {
            $return_array = $completed_forms = array();
            $post_data = $request->all();

            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'flow_id' => 'required',
                //'jnl_id' => 'required',
                'jnl_code' => 'required',
                'frm_id' => 'required',
               // 'stage_type' => 'required',
            ]);

            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            else
            {//$frm_ids, $art_id, $jnlcode, $flow
                $return_arr = array();
                //validation section
                $input_arr = array(
					'input' => $post_data['frm_id'],
					'type'=> 'number',
                    'enc_data'=> true
				);
				$frm_id_validate = $this->Rv_validator($input_arr);

                $input_arr['input'] = $post_data['flow_id'];
                $flow_id_validate = $this->Rv_validator($input_arr);

                $input_arr['input'] = $post_data['art_id'];
                $art_id_validate = $this->Rv_validator($input_arr);

                // $input_arr['input'] = $post_data['stgusr'];
                // $stgusr_validate = $this->Rv_validator($input_arr);

                $input_arr['input'] = $post_data['jnl_code'];
                $input_arr['type'] = 'string';
                $jnlcode_validate = $this->Rv_validator($input_arr);

                $editcmtfrm = false;
                if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y' && isset($post_data['editcmtfrm']))
                {
                    $editcmtfrm=$post_data['editcmtfrm'];
                }

                if($frm_id_validate == true && $flow_id_validate == true && $art_id_validate == true && $jnlcode_validate == true)
                {
                    $flow = decrypt_link($post_data['flow_id']);
                    //$jnl_id = $this->decrypt_data($post_data['jnl_id']);
                    $art_id = decrypt_link($post_data['art_id']);
                    //$stage_user['user_id'] = decrypt_link($post_data['stgusr']);
                    $jnlcode = decrypt_link($post_data['jnl_code']);
                    $frm_id = decrypt_link($post_data['frm_id']);

                    $frm_ids = json_encode(array($frm_id));
                    $completed_forms = $this->getexistdata_deatails($frm_ids, $art_id, $jnlcode, $flow,0,$editcmtfrm);
                    //echo '<pre>';print_r($completed_forms);exit;

                }
                else
                {
                    return $this->warning('Failed',422,customTrans('auth.invalid_data'));
                }




                return $this->success('success', 200, $completed_forms);
            }

        }catch(\Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
    }
    public function update_unread_mail_responses(Request $request)
    {
        try
        {
            $return_array = array();
            $post_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            else
            {
                $return_arr = array();
                $input_arr = array( 'input' => $post_data['art_id'], 'type'=> 'number', 'enc_data'=> true );
                $input_arr['input'] = $post_data['art_id'];
                $art_id_validate = $this->Rv_validator($input_arr);
                if($art_id_validate == true)
                {
                    $art_id = decrypt_link($post_data['art_id']);
                    $current_user = $this->get_current_user_details();
                    $select_email_condition = "esl_user_id ={$current_user['user_id']} AND esl_article_id = {$art_id} AND esl_trans_mode='r' AND esl_read_status='u' ";
                    $email_result = Email_send_log::get_all_records('esl_id',$select_email_condition);
                    if(!empty($email_result)) {
                        foreach($email_result as $email_log_data){
                            // Task #206 , Reply-mail email send log during all mail read status fix
                            $update_array = array( 'esl_read_status'=> 'r','esl_operation' => 'm' );
                            Email_send_log::update_receive_record($update_array, 'esl_id=' . $email_log_data->esl_id);
                        }
                        $return_data['msg'] = true;
                    }
                }
                else
                {
                    return $this->warning('Failed',422,trans('auth.invalid_data'));
                }
                return $this->success('success', 200, $return_data);
            }

        }catch(\Exception $e)
        {
            return  $this->failure('Failed',500,$e);
        }
    }
    // check privileged user as reviewer in previous article version
		public function check_privileged_user_as_reviewer($article_id, $user_id)
		{

			$reviewer_cnt = 0;
			$article_data = Articles::get_article_data($article_id);

			if (!empty($article_data) && $article_data->art_pre_all_ids != '')
			{
					$prev_art_ids = explode(',', $article_data->art_pre_all_ids);

					if(!empty($prev_art_ids))
					{
						$Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
                        $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                        $tables = array(
                            'main_table' => $Article_flow_table,
                            'join_table' => array(
                            $Generic_flows_table => array($Generic_flows_table . '.jwf_id',$Article_flow_table . '.aflw_jwf_id'))
                        );

                        foreach ($prev_art_ids as $art_id)
						{

							// $reviewer_criteria = 'aflw_art_id='.$art_id.' and jwf_stage_type=\'review\' and aflw_usssr_id='. $user_id;
                            $reviewer_criteria = 'aflw_art_id= ? and jwf_stage_type=\'review\' and aflw_usr_id= ?';
							$reviwer_role_count = Article_flow::get_results_using_joins($tables,'count(aflw_id) as cnt',$reviewer_criteria ,'single',binding_arr:[$art_id,$user_id]);
							$is_reviewer = (isset($reviwer_role_count->cnt) && $reviwer_role_count->cnt > 0) ? true : false;

							if ($is_reviewer == true)
							{

								$reviewer_cnt++;
							}
						}
					}
			}

			if ($reviewer_cnt > 0)

				return true;
			else
				return false;
    }

    public function set_data_for_editor($article_id,$article_flow_id,$user_data,$auth_id,$current_role)
    {
            $article_model = (new \App\Models\Articles());
            $article_data = $article_model::get_single_record_with_bind_cond('art_id,art_artp_id,art_title,art_abstract,art_es_document_status,art_es_document_type,art_prev_article_id,art_submitted_by,art_code,art_submission_date,art_version_no',array('art_id' => $article_id));
            $attchment_table = (new \App\Models\Attachment_files())->getTable();
            $description_tbl = (new \App\Models\Attachment_file_description())->getTable();
            $article_tbl = (new \App\Models\Articles())->getTable();
            $article_type_tbl = (new \App\Models\Article_types())->getTable();
            $jnl_table = (new \App\Models\Journals())->getTable();
            $attch_tbl = new \App\Models\Attachment_files();
            $generic_flw_tbl = (new \App\Models\Generic_flows())->getTable();
            $article_flow_tbl_name = (new \App\Models\Article_flow())->getTable();
            $article_flow_tbl = new \App\Models\Article_flow();

            $auth_data_arr = array();
            $Authors_tbl_name = (new \App\Models\Authors())->getTable();
            $User_tbl_name = (new \App\Models\User())->getTable();
            $join_tbls_author = array(
                'main_table' => $article_tbl,
                'join_table' => array(
                    $Authors_tbl_name => array(
                        $Authors_tbl_name.'.auth_art_id', $article_tbl.'.art_id'),
                        $User_tbl_name => array(
                            $User_tbl_name.'.usr_id', $Authors_tbl_name.'.auth_usr_id')
                )
            );
            $select = 'usr_id,CONCAT( IF( usr_title IS null OR usr_title = "", " ", CONCAT( UPPER(SUBSTR(usr_title, 1, 1)), LOWER(SUBSTR(usr_title, 2)) ) )," ", usr_first_name, IF(usr_middle_name IS null or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user_name,usr_email,auth_corr_author';
            $wherecondition = 'art_id=' .$article_id;
            $articles_authors = $article_model::get_results_using_joins($join_tbls_author, $select, $wherecondition);
            if(!empty($articles_authors))
            {
                $authors_key = array();
                foreach($articles_authors as $authors_list)
                {
                    if($authors_list->auth_corr_author=='y')
                    {
                        $auth_data_arr['user_global_id'] = $authors_list->usr_id;
                        $auth_data_arr['user_name'] = $authors_list->user_name;
                        $auth_data_arr['usr_email'] = $authors_list->usr_email;
                        $auth_data_arr['corresponding_author'] = 'y';
                     }
                     else
                    {
                        $auth_co_author['user_global_id'] = $authors_list->usr_id;
                        $auth_co_author['user_name'] = $authors_list->user_name;
                        $auth_co_author['usr_email'] = $authors_list->usr_email;
                        $auth_co_author['corresponding_author'] = 'n';
                        array_push($authors_key, $auth_co_author);
                    }

                }
                $auth_data_arr['list_co_authors']= $authors_key;

            }


            $join_tbls = array(
                'main_table' => $article_flow_tbl_name,
                'join_table' => array(
                    $generic_flw_tbl => array(
                        $generic_flw_tbl.'.jwf_id', $article_flow_tbl_name.'.aflw_jwf_id'
                    )
                )
            );
            $work_criteria = 'aflw_id ='.$article_flow_id;
            $get_all_workflow_details = $attch_tbl::get_results_using_joins($join_tbls, 'jwf_stage_name',$work_criteria, 'all');

            $tables = array(
                            'main_table' => $attchment_table,
                            'join_table' => array(
                                $description_tbl => array($attchment_table . '.atmnt_label', $description_tbl . '.afdec_id'),
                                $article_tbl => array($attchment_table.'.atmnt_art_id',$article_tbl.'.art_id'),
                                $article_type_tbl => array($article_tbl.'.art_artp_id',$article_type_tbl.'.artp_id'),
                                $jnl_table => array($article_type_tbl.'.artp_jnl_id',$jnl_table.'.jnl_id')
                            )
                        );
            $select_fields = 'atmnt_id,atmnt_orginal_upload_path,atmnt_file_name,atmnt_send_to_es,afdec_main_document,jnl_journal_code,artp_abbr_article_type,art_es_document_status,art_es_document_type';
            $criteria = 'atmnt_art_id=' . $article_id;
            $get_all_attach_details = $attch_tbl::get_results_using_joins($tables, $select_fields, $criteria, 'all');
            $return_arr = array();
            $return_arr['article_data'] = [];
            $return_arr['document_created_at_rv_rite'] = $article_data->art_es_document_type == 'n' ? 'y' : 'n';
            $return_arr['article_data']['art_previous_id'] = $article_data->art_prev_article_id;
            $return_arr['main_document'] = '';
            $return_arr['document_id'] = '';
            $return_arr['article_data']['current_stage_name'] = $get_all_workflow_details[0]->jwf_stage_name;
            $return_arr['article_data']['current_status'] = $article_flow_id;
            $return_arr['article_data']['art_submitted_by'] = $article_data->art_submitted_by;
            $return_arr['article_data']['art_id'] = $article_data->art_id;
            $return_arr['article_data']['art_code'] = $article_data->art_code;
            $return_arr['article_data']['art_title'] = $article_data->art_title;
            $return_arr['article_data']['art_abstract'] = $article_data->art_abstract;
            $return_arr['article_data']['art_submission_date'] = $article_data->art_submission_date;
            $return_arr['article_data']['art_version'] = 'R'.$article_data->art_version_no;
            $return_arr['article_data']['art_authors'] = $auth_data_arr;
            $article_keywords_table = new \App\Models\Article_keywords();
            $article_type_table = new \App\Models\Article_types();
            $art_jnl = $article_type_table::get_single_record_with_bind_cond('artp_jnl_id',array('artp_id' => $article_data->art_artp_id));
            $hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $article_keywords = $article_keywords_table::get_article_keywords($article_id, false, false, $hierachy, $art_jnl->artp_jnl_id);
            $return_arr['article_data']['art_keywords'] = [];
            $return_arr['article_data']['art_classification'] = [];
            if(!empty($article_keywords))
            {
                $art_kwd_arr = array();
                foreach($article_keywords as $single_art_keyword)
                {
                    array_push($art_kwd_arr,$single_art_keyword->kwd_name);
                }
                $return_arr['article_data']['art_keywords'] = $art_kwd_arr;
            }
            $condition ="arcls_art_id =:art_id";
            $Article_classification = new \App\Models\Article_classification();
            $classification_tbl =  new \App\Models\Classifications();

            $cls_table = (new \App\Models\Classifications())->getTable();
            $checkBoxData = $Article_classification::get_single_record('GROUP_CONCAT(arcls_cls_id) as checkData', $condition,null,'',null,array('art_id'=>$article_id));
            if(!empty($checkBoxData->checkData)){
                $class_id = explode(',', $checkBoxData->checkData);
                $art_class_arr = array();
                $term_table = (new \App\Models\Terms())->getTable();

                foreach($class_id as $single_class_id)
                {
                    $criteria = 'cls_id =' . $single_class_id;
                    $join_tbls =  array(
                        'main_table' => $cls_table,
                        'join_table' => array(
                            $term_table => array($term_table . '.term_id', $cls_table . '.cls_term_id')
                        )
                    );
                    $cls_dtls = $classification_tbl::get_results_using_joins($join_tbls,'term_name', $criteria, 'all');
                    array_push($art_class_arr,$cls_dtls[0]->term_name);
                }
                $return_arr['article_data']['art_classification'] = $art_class_arr;
            }
            $client_code = $this->current_client->clnt_client_code;
            if(count($get_all_attach_details) > 0)
            {
                $other_docs = array();
                foreach($get_all_attach_details as $single_attac)
                {
                    if($single_attac->afdec_main_document == 'y')
                    {
                        $return_arr['document_id'] = $single_attac->atmnt_id;
                        $return_arr['main_document'] = $single_attac->atmnt_file_name;
                        $return_arr['file_ftp_location'] = $single_attac->jnl_journal_code.'/'.$single_attac->artp_abbr_article_type.'/'.$article_id.'/'.urlencode($single_attac->atmnt_file_name);
                    }
                    else
                    {
                        array_push($other_docs,$single_attac->atmnt_file_name);
                    }
                }
                $return_arr['other_documents'] = null;
                if(count($other_docs) > 0)
                {
                    $return_arr['other_documents'] = $other_docs;
                }
            }
            $return_arr['user_email'] = $user_data->usr_email;
            $return_arr['user_first_name'] = $user_data->usr_first_name;
            $return_arr['user_id'] = $user_data->usr_id;
            $return_arr['user_last_name'] = $user_data->usr_last_name;
            $return_arr['user_middle_name'] = $user_data->usr_middle_name;
            $return_arr['user_name'] = $user_data->user_name;
            $return_arr['user_current_auth_id'] = $auth_id;
            $return_arr['user_current_role'] = $current_role;
            $return_arr['article_data']['current_role'] = $current_role;
            return $return_arr;
    }
    // Task #6007: Grant request Access starts
    public function grant_author_access_request(Request $request){
        DB::beginTransaction();
        try {
            $rules = [
                'art_id' => 'required',
                'art_flow_id' => 'required',
                'jnl_id' => 'required',
                'authorize_bit' => 'required',
            ];
            $post_data = $request->all();
            $authorize_bit = Rv_decrypt($post_data['authorize_bit']);
            if($post_data['authorize_bit'] == 'r'){
                $rules['rej_reason'] = 'required';
            }
            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors()->first());
            }
            $this->current_user = $this->get_current_user_details();
            $userId = $this->current_user['user_id'];
            $jnl_id = Rv_decrypt($post_data['jnl_id']);
            $article_id = Rv_decrypt($post_data['art_id']);
            $art_flow_id = Rv_decrypt($post_data['art_flow_id']);

            $condition = [
                'cusr_action_type' => 'prevent_edit_request_access',
                'cusr_art_id' => $article_id,
                'cusr_aflw_id' => $art_flow_id,
                'cusr_status' => 'p',
                'cusr_status_change_by' => null
            ];
            $return_array = array();
            $requestExist = Article_custom_reasons::get_single_record_with_bind_cond('cusr_id', $condition);
            $return_array = [
                'message' => '',
                'authorize_bit' => $authorize_bit,
            ];
            if($requestExist){
                $reason_data = array(
                    'cusr_art_id' => $article_id,
                    'cusr_aflw_id' => $art_flow_id,
                    'cusr_action_type' => 'prevent_edit_decline_access',
                    'cusr_status_change_by' => $requestExist->cusr_id,
                    'cusr_status_change_reason' => $post_data['rej_reason'] ?? null,
                    'cusr_status' => $authorize_bit,
                );
            if($authorize_bit == 'r'){
                $reason_data['cusr_action_type'] = 'prevent_edit_decline_access';
                $records = Email_templates::get_single_record('*', "etmp_name ='prevent_edit_decline_access'");

                $return_array['message'] = 'Authorization request rejected successfully';
            }else{
                $reason_data['cusr_action_type'] = 'prevent_edit_approve_access';
                $return_array['message'] = 'Authorization request approved successfully';
                $records = Email_templates::get_single_record('*', "etmp_name ='prevent_edit_approve_access'");
            }
            $grant_id = Article_custom_reasons::insert_record($reason_data,$this->current_user);
            Article_custom_reasons::update_record(['cusr_status_change_by' => $grant_id], $condition);  // Updating Custom Reason Entry
            $artp_id = Articles::get_single_record('art_artp_id','art_id = ? ',binding_arr:[$article_id])->art_artp_id;
            if (!empty($records)) {
            $cfty_retire_role = false;
            if ((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y') {
                $cfty_retire_role = true;
            }
            $send_mail_to_detail = $this->send_email_to($records->etmp_notification,$jnl_id,$artp_id,$article_id,$cfty_retire_role);
            if ($send_mail_to_detail) {
                $user_id = explode(',',$send_mail_to_detail['usr_ids']);
                $user_email =  explode(',',$send_mail_to_detail['email_ids']);
                if(isset($article_id)){
                    $Articles = new \App\Models\Articles;
                    $jnl_journal_code = $Articles::get_art_jnl_column_val($article_id, 'jnl_journal_code');
                }
                foreach ($user_email as $key => $value) {
                $email_data = [
                    'type'=>'global',
                    'action'=>'send',
                    'email_temp'=>'global',
                    'action'=>'send',
                    'email_with_login'=>false,
                    'user_id'=> $user_id[$key],
                    'empt_name'=> 'prevent_edit_approve_access',
                    'custom_data' => [
                        'user_data' => $this->current_user,
                        'user_email' => $value,
                        'article_id' => $article_id,
                        'return_batch_id' => true,
                        'artp_id' => $artp_id,
                        'etmp_notification' => $records->etmp_notification,
                        'esl_etmp_action' => 'author_request_approve',
                        'jnl_id' => $jnl_id,
                        'jnl_code'=> $jnl_journal_code
                    ],
                ];
                if(isset($post_data['rej_reason'])){
                    $email_data['empt_name'] = 'prevent_edit_decline_access';
                    $email_data['custom_data']['prevent_edit_decline_access_reason'] = $post_data['rej_reason'];
                    $email_data['custom_data']['esl_etmp_action'] = 'author_request_reject';
                }
                $this->master_email_details($email_data);
                }
            }
            }
        }
        DB::commit();
        return $this->success('Success', 200, $return_array);
        }catch(Exception $e){
        DB::rollback();
        return $this->failure('Failed', 500, $e);
        }
    }
  // Task #6007: Grant request access ends

  /*
  * Task #925 check research integrity report is generated, 
  * task #4018 not necessary of this function. its not called anywhere
  */
  /*public function check_rvri_report_generated($article_basic) {
    try{
        if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y') {
            $retrn          =   true;
            $art_id         =   $article_basic->art_id;   
            $aflw_id        =   $article_basic->aflw_id;
            $aflw_status    =   $article_basic->aflw_status; 
            $artp_id        =   $article_basic->art_artp_id; 
            $jwf_stage_type =   $article_basic->jwf_stage_type;  

            $this->current_user = $this->get_current_user_details();
            $clnt_code = 'clients.' . $this->current_client->clnt_client_code;
            $ric_config = Config::get($clnt_code . '.research_integrity_config');

            $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type, atotp_rvriauto_submissions', 'atotp_artp_id=' . $artp_id);
            
            $mandate_report_generation    =   $ric_config['mandate_report_generation'];
            // research integrity checking is mandatory for the current client
            // if research integrity checking is enabled in the curent stage
            if($aflw_status != 'u' && $mandate_report_generation == true && $article_type_options->atotp_research_integrity == 'y') {
                $result     =   Research_integrity_reports::get_latest_research_integrity_report($art_id);
                // if the report is not generated
                if((empty($result) && $article_type_options->atotp_rvrisubmission_type == 'manual') || 
                (!empty($result) && $result->rri_status == 'n')) {
                    if ($article_type_options->atotp_rvrisubmission_type == 'auto' && in_array($jwf_stage_type, json_decode($article_type_options->atotp_rvriauto_submissions)) == true) {
                        $this->generateresearchintegrity($art_id, $aflw_id);
                    }
                    $retrn  =   false;
                }
            }
        } else {
            $retrn  =   true;
        }
        return $retrn;
    } catch(Exception $e){
        return $this->failure('Failed', 500, $e);
    }

  }*/
}
