<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\StandaloneDataTrait;

use App\Models\Roles;
use App\Models\User;
use App\Models\User_emails;
use App\Models\User_affiliations;
use App\Models\User_to_journals;
use App\Models\Article_types;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\DB;
use App\Consts;

class Manage_bulk_author_uploads extends Controller
{
    use StandaloneDataTrait;
    
    /*
    * function that operates bulk author import 
    */
    public function bulkauthorimport(Request $request)
    {
        try{
            $status='';
            $post_data=$request->all();
            if($post_data['file'])
            { 
                 $path = $post_data['file']->store('public/uploads');
                 $return_data=$this->read_upload_authors($path, $post_data);
                 return $this->success($status, 200, $return_data);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('failure', 500, $e);
        }
    }

    /*
    * function that reads the file and save the data into the databse
    */
    public function read_upload_authors($path, $post_data)
    {
        try{
            if(isset($post_data['file']))
            {
                $rows           =   [];
                //fetch the duplicate rows encountered
                $duplicates     =   [];
                $lineNumber     =    1;

                //fetch the duplicate users encountered
                $existing       =   [];
                $rowNumber      =    0;

                $user_data      =   $this->get_current_user_details();
                $file_path      =   storage_path().'/app/'.$path;
                $file_read      =   fopen($file_path, 'r');

                $jnl_id             =   $post_data['jnl_id'];
                $art_type_id        =   '';
                if(isset($post_data['art_type_id']))
                {
                    $art_type_id    =   decrypt_link($post_data['art_type_id']);
                }

                $rolesArr           =   array();
                if(isset($post_data['role_id'])) {
                    $rolesArr = explode(',', $post_data['role_id']);
                }
                $roles = array_filter($rolesArr, function ($value) {
                    return !empty($value); // Remove empty values (null, "", false)
                });
                
                $headers        =   fgetcsv($file_read); // Read headers

                // Check if the file has a header and at least one data row
                $rowCount   =   0;
                $maxLmt 	= 	Consts::MaxUserImpRowLmt;

                // Loop through the rows and count non-empty rows
                while (($row = fgetcsv($file_read)) !== false) {
                    if (!empty(array_filter($row))) { // Ignore empty rows
                        $rowCount++;
                        if ($rowCount > $maxLmt) {
                            fclose($file_read);
                            break;
                        }
                    }
                }
                if($rowCount == 0)
                {
                    $return_data    =   array(
                        'status'     => 'error',
                        'message'    => 'No user data found in this csv file.'
                    ); 
                    return response()->json($return_data, 500);
                }
                elseif($rowCount > $maxLmt) {
                        $return_data    =   array(
                            'status'        => 'error',
                            'message'    => 'The uploaded CSV file exceeds the '.$maxLmt.' row limit. Please upload a smaller file.' ,
                        ); 
                        return response()->json($return_data, 500);
                }

                // Reset file pointer to start from the beginning
                rewind($file_read);

                $filtered_headers = array_values(array_filter($headers, function($value) {
                    return !empty($value);
                }));

                $keys           =   $this->escape_string($filtered_headers);
                if(in_array('First name', $keys) && in_array('Last name', $keys) && in_array('Email', $keys))
                {
                    $title_column_key   =   array_search('Title',$keys);
                    $f_name_column_key  =   array_search('First name',$keys);
                    $l_name_column_key  =   array_search('Last name',$keys);
                    $email_column_key   =   array_search('Email',$keys);
    
                    $userarr        =   array();
                    $usrjrnlsTmp    =   array();

                    $db_fields      =   User::get_field_names();
                    $valid_emails   =   array();
                    $headers        =   fgetcsv($file_read); // Read headers
                    while(($row = fgetcsv($file_read)) !== FALSE)
                    {
                        array_filter($row, function($value) { return !is_null($value) && $value !== ''; });
                        if(empty($row))
                        {
                            unset($row);
                        }
                        if(isset($row))
                        {
                            $rowNumber++;
                            if($row != NULL && !empty($row[$email_column_key]) && !empty($row[$f_name_column_key]) && !empty($row[$l_name_column_key]))
                            {
                                $lineNumber++; // Increment line number for each row
                                $rowSerialized = serialize($row); // Convert row to a string for comparison
                                if (isset($rows[$rowSerialized])) {
                                    // If the row is already in the array, it's a duplicate
                                    $duplicates[] = [
                                        'line_number' => $lineNumber,
                                        'row' => $row
                                    ];
                                } else {
                                    // Otherwise, add it to the array of unique rows
                                    $rows[$rowSerialized] = $lineNumber;
                                }
                                $values = $row;
                                if(count($keys) == count($values))
                                {
                                    $artp_id_arr =   array();
                                    $new_values  =   $this->escape_string($values);
                                    $usr_title   =   $this->get_corresponding_titles(trim($new_values[$title_column_key]));
                                    $usr_fname   =   trim($new_values[$f_name_column_key]);
                                    $usr_lname   =   trim($new_values[$l_name_column_key]);
                                    $usr_mail    =   trim($new_values[$email_column_key]);
                                    $usrname     =   trim($new_values[$email_column_key]);

                                    $userexist_check = User::get_single_record_with_bind_cond('count(usr_id) as cnt',array(
                                        'usr_email' => $usr_mail
                                    ));
                                    if($userexist_check->cnt == 0 ){
                                        $valid_emails[]   =   $usr_mail;
                                        $is_existing_usrname = User::get_single_record('usr_username','usr_username = "'.$usrname.'"');
                                        if(isset($is_existing_usrname)){
                                            $usrname= $usr_mail;
                                        } 
                                        $tokenkey= Str::random(20);

                                        $enable_terms = 'y';
                                        if (isset($this->current_client->functionality->cfty_show_terms_conditions) && $this->current_client->functionality->cfty_show_terms_conditions == 'y') {
                                            $enable_terms = 'n';
                                        }
                                        
                                        //push user data to user array
                                        array_push($userarr, array(
                                            'usr_username' => $usrname,
                                            'usr_title' => (isset($usr_title) && $usr_title != '' ? $usr_title : NULL),
                                            'usr_first_name' => $usr_fname,
                                            'usr_last_name' => $usr_lname,
                                            'usr_email' => $usr_mail,
                                            'usr_deeplink_token' => $tokenkey,
                                            'usr_status' =>  'a',
                                            'usr_terms_condition' => $enable_terms,
                                            'usr_operation' => 'b',    //bulk import
                                            'usr_posted_date' => date('Y-m-d H:i:s')
                                        ));

                                        //push user data to user to jouranls array
                                        $condition          =   'artp_jnl_id = '.$jnl_id;
                                        if($art_type_id != '')
                                        {
                                            $artp_id_arr[]    =   decrypt_link($post_data['art_type_id']);
                                        }
                                        else 
                                        {
                                            $article_types      =   Article_types::get_all_records('artp_id', $condition);
                                            foreach ($article_types as $type) {
                                                $artp_id_arr[]  =   $type->artp_id;
                                            }
                                        }
                                        foreach($roles as $rVal)
                                        {
                                            $role_id        =   decrypt_link($rVal);
                                            $usrjrnlsTmp[]  =   array(
                                                                    'usrj_jnl_id' => $jnl_id,
                                                                    'usrj_role_id' => $role_id,
                                                                    'usrj_artp_id' => null
                                                                );
                                            foreach ($artp_id_arr as $arttyp) {
                                                $usrjrnlsTmp[]  =   array(
                                                                        'usrj_jnl_id' => $jnl_id,
                                                                        'usrj_artp_id' => $arttyp,
                                                                        'usrj_role_id' => $role_id
                                                                    );
                                            }
                                        }
                                        // Remove duplicates
                                        $uniqueArray2 = array_unique(array_map('serialize', $usrjrnlsTmp));
                                        $usrjrnlsarr = array_map('unserialize', $uniqueArray2);
                                    } else {
                                        $existing[] =   $rowNumber;
                                    }
                                }
                            }
                        }
                    }
                    fclose($file_read);
                    
                    if (empty($duplicates)) {
                        DB::beginTransaction();
                        // Insert users and get their IDs
                        foreach ($userarr as $kry => $user) {
                            $tokenkey   =   $user['usr_deeplink_token'];
                            $userId     =   User::insert_record($user, $user_data);

                            // Insert into usr_to_journals table
                            foreach($usrjrnlsarr as $utj) {
                                $utj['usrj_usr_id']   =   $userId;
                                User_to_journals::insert_record($utj, $user_data);
                            }

                            $stndalon_jnl = $this->get_standalone_journal_data();
                            if($stndalon_jnl == NULL)
                            {
                                if($this->current_client->functionality->cfty_show_terms_conditions=='y')
                                {
                                    $link =URL::to('/') . "/confirmation/" . encrypt_link("&key=" . $tokenkey . "&userid=" . $userId."&name=add_user_confirmation");
                                }
                                else 
                                {
                                    $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $tokenkey . "&userid=" . $userId."&name=add_user_confirmation");
                                }
                            }
                            else
                            {
                                if($this->current_client->functionality->cfty_show_terms_conditions=='y')
                                {
                                    $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $tokenkey . "&userid=" . $userId."&name=add_user_confirmation");
                                }
                                else
                                {
                                    $link =URL::to('/') . "/confirmation/" . $this->encrypt_data("&key=" . $tokenkey . "&userid=" . $userId."&name=add_user_confirmation");
                                }
                            }
                            //SEND EMAIL
                            $userData=array("user_id"=>$userId,'activation_link'=>$link);
                            $ccuser_data=array("usr_id"=>$userId,'activation_link'=>$link);
                            $this->send_email_confirmation_user($userData,$ccuser_data);
                        }
                        DB::commit();
                    } else {
                        // Display duplicates to the user
                        $addThis    =   '';
                        if (!empty($duplicates)) {
                            $addThis    .=   " Duplicate row found in uploaded csv file in line no. ";
                            foreach ($duplicates as $duplicate) {
                                $addThis    .=   $duplicate['line_number'].', ';
                            }
                            $addThis    =   rtrim($addThis, ", ");
                        }
                        return response()->json(['status'=>'error', 'message' => $addThis], 200);
                    }
                    $msgbl     =   '';
                    if(count($userarr) > 0) {
                        $usrLbl =   (count($userarr) == 1) ? 'user' : 'users';
                        $msgbl  =   count($userarr) . ' '.$usrLbl.' imported successfully.';
                    }
                    $sameexistsLbl  =   '';
                    if(count($existing) > 0)
                    {
                        $rwLbl = implode(', ', $existing);
                        $usrLbl =   (count($existing) == 1) ? 'User' : 'Users';
                        $sameexistsLbl  =   ' '.$usrLbl.' in row number '.$rwLbl.' already exists in our system.';
                    }

                    if( $msgbl != '')
                        return response()->json(['status'=>'success', 'message' => $msgbl.$sameexistsLbl], 200);
                    else
                        return response()->json(['status'=>'error', 'message' => $sameexistsLbl], 500);
                }
            } 
            else {
                return response()->json(['status'=>'error', 'message' => 'CSV file not found'], 500);
            }
        }
        catch (\Exception $e) {
            DB::rollBack();
            return  $this->failure('failure', 500, $e);
        }
    }

    /*
    * Function to create title for names
    * returns string 
    */
    public function  get_corresponding_titles($title)
    {
        $user_titles =  $this->UserConfigdata('titles')['titles'];
        $title = strtolower(str_replace('.', '', $title));
        $title = strtolower(str_replace(',', '', $title));
        if($title == 'prof' || $title == 'professor' || strpos($title,"prof") > 0)
            $title = 'pr';
        elseif($title == 'ms' || $title == 'miss')
            $title = 'mis';
        elseif(strpos($title,"dr") > 0)
            $title = 'dr';

        if (array_key_exists($title, $user_titles)) {
            return $title;
        } else {
            return '';
        }
    }
}
