<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\StagemovementTrait;
use App\Models\Abstract_category;
use App\Models\Volumes;
use App\Models\Article_types;
use App\Models\Journals;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Generic_flows;
use App\Models\User;
use App\Models\Stage_email_templates;
use App\Models\Issues;
use App\Models\Journal_settings;
use App\Models\User_to_journals;
use App\Models\Article_type_advance_options;
use App\Models\Authors;
use App\Models\User_affiliations;
use App\Models\Authors_affiliation;
use App\Models\Issue_management;
use App\Models\Article_notes;
use App\Models\Article_notification_emails;
use App\Models\Roles;
use App\Models\Article_tab_status;
use Illuminate\Support\Facades\URL;
use \stdClass;
use DateTime;
use App\Models\Required_file_type;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;
use Symfony\Component\HttpFoundation\File\File as SymfonyFile;
use ZipArchive;
use App\Consts;
use App\Http\Controllers\Manage_Article_Submission_Api;
use App\Models\Journal_permission;
use Config;
use DB;
use App\Models\Email_templates;
use App\Models\Event_invited_users;
use App\Models\Attachment_files;
use App\Models\Terms;
use App\Models\File_upload_type;
use Exception;
use phpDocumentor\Reflection\PseudoTypes\False_;
use Illuminate\Support\Facades\Storage;
use App\Models\Article_classification;
use App\Models\Sheet_view_optional_selected_colums;
use App\Models\Article_order;
use App\Models\Article_order_details;
use Illuminate\Support\Arr;
use App\Models\Events_model;    //Task #3791 save a record in events table when notifing a organizer or a cp team member 
use App\Http\Traits\WorkflowTrait; // Task #3890 Organizer email no edited content is sent 
/* Task start #3059 Chunk upload in article upload*/
use Log;
use Symfony\Component\HttpFoundation\StreamedResponse;
/* Task end #3059 Chunk upload in article upload*/

Class Manage_bulk_invite_proposal_Api extends Controller {
    use UtilityTrait;
    use StagemovementTrait;
    use WorkflowTrait; // Task #3890 Organizer email no edited content is sent 
    public $currentuser;
    public function basic_articleprposal(Request $request) {
        try {
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $res=array();
            $jnlidarray = array('input'=>$form_data['jnl_id'],'type'=>'number', 'enc_data'=>true );
            $jnlidvalidation = $this->Rv_validator($jnlidarray);

            if($jnlidvalidation !== true){
				$res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
			}
            $is_proceeding=$this->check_client_proceeding();
            $result=array();
            $result['article_status'] = array(
                'u' => 'Not Invited',
                'i' => 'Invited',
                'd' => 'Declined',
                'c' => 'Submitted',
                'a' => 'Submission In Progress',
            );
            $jnl_id=$this->decrypt_data($form_data['jnl_id']);
            $activerole=$form_data['activerole'];
            $this->current_user = $this->get_current_user_details();
            $result['show_page_title']  =   true;
            $condition                      =   array("vol_jnl_id"=>$jnl_id);
            $result['volumes']  =   Volumes::get_all_records_with_bind_cond('vol_id,vol_jnl_id,vol_title,vol_posted_by,vol_posted_date,vol_proxy_id,vol_operation',$condition);
            $bind_arr = array();
            // Show only article types that are by invitation.
            $inv='["i"]';
            $jnl_code = Journals::find($jnl_id, ['jnl_journal_code'])?->jnl_journal_code;
            $val_artp_conditiion = "artp_jnl_id = ? and artp_article_submission_status='y' and JSON_CONTAINS(artp_login_user_type, '{$inv}' ) ";
            $bind_arr[]=  $jnl_id;
            $all_article_types =  Article_types::get_all_valid_articletype('artp_id,artp_article_type,artp_fwm_id,artp_jpm_id', $val_artp_conditiion,$bind_arr);
            $user_roles = $this->validate_user_journal($jnl_code, session('user_id'));
            $active_default_role=$this->set_dashboard_default_role_active($user_roles,$jnl_id, session('user_id'));  /*Task #1787 Due date in settings page */
            if (count($all_article_types) > 0)
            {
                $main_array=array();
                foreach ($all_article_types as $article_type)
                {
                    $fwm_id = $article_type->artp_fwm_id;
                    if($this->current_client->modules->mdl_review_for_doc =='n')
                    {
                        $proper_flow = $this->validate_journal($fwm_id, $article_type->artp_id, 'a');

                        if ($proper_flow['status'] === false)
                        {
                            continue;
                        }
                        else{
                            
                            $main_array[]= $article_type;
                        }
                    }
                }
                $result['all_article_types'] = json_decode(json_encode($main_array), false);
            }
            else{
                $result['all_article_types'] =$all_article_types;
            }
            $jnl_setting = Journal_settings::get_single_record_with_bind_cond('jset_date_format,jset_classification,jset_classification_title',array("jset_jnl_id"=>$jnl_id));
            $jnl_date_format = isset($jnl_setting->jset_date_format)?$jnl_setting->jset_date_format:"";
            $array_date=platform_date_format();

            $result['jnldate_format'] = $array_date[$jnl_date_format];
            $jounal_data = Journals::get_single_record_with_bind_cond('jnl_id,jnl_fwm_id,jnl_jpm_id',array("jnl_id"=>$jnl_id));
            $proper_flow = $this->validate_journal($jounal_data->jnl_fwm_id, $jounal_data->jnl_id);
            $result['valid_jnl']['status'] = isset($proper_flow['status'])?$proper_flow['status']:true;
            $result['valid_jnl']['msg'] = isset($proper_flow['err_msg'][0])?$proper_flow['err_msg'][0]:customTrans('viewarticle.invalid_journal');
             /*Task #1787 Due date in settings page */
            if(isset($jnl_id) && isset($this->current_client->functionality->cfty_conf_article_submission_due_date)&& $this->current_client->functionality->cfty_conf_article_submission_due_date == 'y' && $is_proceeding == true && isset($active_default_role['core_role']) ){
                $creation_due_date_exceeded= $this->check_creation_due_date($jnl_id,$active_default_role);
                $result['creation_due_date_exceeded'] = $creation_due_date_exceeded;
            }
             /*end Task #1787 Due date in settings page */

             // checking the current role has the privilege to import articles
            $result['bulk_import_articles_permission'] = false;
            if ($this->current_client->functionality->cfty_import_articles == 'y') {
                $jnl_permission  = Journal_permission::get_single_record('jp_import_article', 'jp_jpm_id='.$jounal_data->jnl_jpm_id);
                $who_can_import_article = array();
                if($jnl_permission->jp_import_article != NULL)
                    $who_can_import_article= json_decode($jnl_permission->jp_import_article);

                if(in_array($activerole, $who_can_import_article))
                    $result['bulk_import_articles_permission'] = true;
            }
            //fetch the client's proceeding config array
            $result['proceedingArr']  =   $this->fetch_client_proceeding_config_array('article-proposal');
            
            // Task #2055 Starts
            $affl_config = 'clients.' . $this->current_client->clnt_client_code;
            $proposalList = Config::get($affl_config . '.proposal_article');
            $proposalListTable = $proposalList['columns'];
            $optionalListTable = $proposalList['optional_column'];
            $proposalListTable = array_merge($proposalListTable, $optionalListTable);
            $proposalListTable = array_map(function ($columnKey) {
                return customTrans($columnKey);
            }, $proposalListTable);
            $optionColumn = array_keys($optionalListTable);
            $key = array_search('classification', $optionColumn);
            if($jnl_setting->jset_classification == 'n' && isset($optionColumn[$key])){
                unset($optionColumn[$key]);
                unset($optionalListTable['classification']);
                unset($proposalListTable['classification']);
            }else{
                $optionalListTable['classification'] = $jnl_setting->jset_classification_title;
                $proposalListTable['classification'] = $jnl_setting->jset_classification_title;
            }
            $column = array_keys($proposalListTable);

            $optionalListTable = array_map(function ($columnKey) {
                return customTrans($columnKey);
            }, $optionalListTable);
            
            $actionButton = [
                "stats" => "Status",
                "action" => "Actions"
            ];
            $proposalListTable = array_merge($proposalListTable, $actionButton);
            $result['column'] = $column;
            $result['proposal_list_table'] = $proposalListTable;
            $result['optional_column'] = $optionColumn;
            $result['optional_list_table'] = $optionalListTable;

            // Task #3791 No edit, attachments, and re-order for Organizer
            $proposals = $this->get_proposals(null, $jnl_id);
            $result['article_cnt'] = $proposals['tot_count'];

            //Task #4018 informational message for Organizer
            if($is_proceeding == true) {
                $result['warnings_organizers'] = $this->fetch_warnings_organizers($jnl_id,$activerole,$proposals['tot_count']);
            } else {
                $result['warnings_organizers'] = '';
            }

            // Task #2055 Ends
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return $this->customErrorAction('manage_proposal',$e);
        }
    }

    /*
    * Task #4018 informational message for Organizer
    */
    public function fetch_warnings_organizers($jnl_id, $active_role, $art_count) {
        $label  =   '';
        $user_roles = Roles::get_single_record('role_name', 'role_id = '.$active_role.' and role_assigned_role = "editor_in_chief"');
        // static check using 'organizer' is written after discussion with gijo
        if(!empty($user_roles) && ($user_roles->role_name == 'Organiser' || $user_roles->role_name == 'Organizer')) 
        {
            //If organiser article creation due date is expired, then return false
            $b4duedatelabel   =   false;
            $aftrduedatelabel   =   false;
            $duedatenulllabel    =   false;
            $frmtd_duedate  =   '';
            $dateformat_res =   $this->get_platform_date_format($jnl_id);
            $date_format    =   date_format_map($dateformat_res);
            
            $jset_conf_duedate_qry = Journal_settings::get_single_record_with_bind_cond('jset_conf_duedate, DATE_FORMAT(jset_conf_duedate, "' . $date_format . '") as due_date',['jset_jnl_id' => $jnl_id]);
            if ($jset_conf_duedate_qry && !empty($jset_conf_duedate_qry->jset_conf_duedate)) {
                $duedate = new DateTime($jset_conf_duedate_qry->jset_conf_duedate);
                $frmtd_duedate= $jset_conf_duedate_qry->due_date;
                $today = new DateTime('today');
                if($art_count > 0 && $duedate != null && $duedate != '' && $duedate < $today) {
                    $aftrduedatelabel  =   true;
                } 
                if($duedate != null && $duedate != '' && $duedate > $today) {
                    $b4duedatelabel  =   true;
                } 
            } else {
                if($art_count > 0)
                    $duedatenulllabel  =   true;
            }

            //Check if any articles has assigned or moved to next stages, then return false
            $assignedlabel  =   false;
            $assi_art_cnt_qry       =   "SELECT
                                            count(art_id) cnt
                                        FROM
                                            `rvw_articles`
                                        JOIN rvw_article_flow ON (art_id = aflw_art_id)
                                        JOIN rvw_journal_workflows ON (aflw_jwf_id = jwf_id)
                                        JOIN rvw_article_types ON (`art_artp_id` = artp_id)
                                        WHERE
                                            aflw_status !='u' and art_proposal_method = 'assign' AND artp_jnl_id = $jnl_id 
                                            AND art_delete_status = 'n' and jwf_stage_type = 'author_submission'";
            $assi_art_cnt_res      =   Articles::get_records_by_raw_query($assi_art_cnt_qry);
            if(isset($assi_art_cnt_res) && $art_count > 0) {
                if($assi_art_cnt_res[0]->cnt > 0) {
                   $assignedlabel  =   true;
                }
            }

            //Check if a organiser has informed the cp team member after articles has created, then return false
            $notifylabel    =   false;
            $events_table   =   (new \App\Models\Events_model())->getTable();
            $sel_sql1		=	"SELECT event_id FROM ".$events_table." WHERE event_name='Notify cp_team_members'";
            $results1 		= 	Events_model::get_records_by_raw_query($sel_sql1);
            $event_id       =   '';
            if ($art_count > 0 && !empty($results1)) {
                $event_id   =   $results1[0]->event_id;

                if($event_id != '')
                {
                    $email_already_exists    =   Event_invited_users::get_single_record_with_bind_cond('count(evu_id) as cnt', array('evu_jnl_id' =>$jnl_id, 'evu_event_id'=>$event_id, 'evu_submit_status' => 'i'));
                    if($email_already_exists->cnt > 0) 
                    {            
                        $notifylabel  =   true;
                    }
                }
            }
            if($duedatenulllabel == true || $b4duedatelabel == true || $aftrduedatelabel  ==   true || $assignedlabel == true || $notifylabel  ==   true) {
                $label  =   '<div>';
                if($aftrduedatelabel == true) {
                    $label  .=   '<span>The due date for uploading articles ('.$frmtd_duedate.') has passed. You can no longer upload or edit articles.</span>';
                }
                if($b4duedatelabel == true) {
                    return  '<span><i class="fa fa-exclamation-triangle"></i> Reminder: Please note that the deadline for article submission is '.$frmtd_duedate.'.</span><br/>
                    <span><i class="fa fa-exclamation-triangle"></i> Important: Once you submit to AIP Publishing, you will no longer be able to add, upload or edit articles.</span>';
                }
                if($duedatenulllabel == true && $aftrduedatelabel == false && $b4duedatelabel == false) {
                    return  '<span><i class="fa fa-exclamation-triangle"></i> Important: Once you submit to AIP Publishing, you will no longer be able to add, upload or edit articles.</span>';
                }
                if($aftrduedatelabel == false && ($assignedlabel == true || $notifylabel == true)) {
                    if($label != '<div>') {
                        $label  .=   '<br/>';
                    }
                    $label  .=   '<span>You have informed the CP team member about the submitted articles. Further article uploads or edits are now disabled.</span>';
                }
                $label  .=   '</div>';
            }
        }
        return $label;
    }

    public function hasJournalPermission($permission_for, $user_roles, $artp_jpm_id){
        $journal_permission = Journal_permission::where('jp_jpm_id',$artp_jpm_id)->get([$permission_for])?->first()?->$permission_for;
        if($journal_permission){
            $intersect = array_intersect($user_roles, json_decode($journal_permission));
            if($intersect){
                return true;
            }
        }

        return false;
    }

    public function getarticle_types(Request $request) {
        try {
            $where_cndtn ='';

            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $res=array();
            $jnlidarray = array('input'=>$form_data['jnl_id'],'type'=>'number', 'enc_data'=>true );
            $jnlidvalidation = $this->Rv_validator($jnlidarray);

            if($jnlidvalidation !== true){
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
			}

            $srch_term=isset($form_data['srch_term']) ? $form_data['srch_term']: '';
            $jnl_id=$this->decrypt_data($form_data['jnl_id']);
            $activerole=$form_data['activerole'];
            // Show only article types that are by invitation.
            $inv='["i"]';
            $arttypebind_arr = array();
            $val_artp_conditiion            =   "artp_jnl_id = ? and JSON_CONTAINS(artp_login_user_type, '{$inv}' ) ";
            $arttypebind_arr[]=  $jnl_id;
            $result['all_article_types'] =   Article_types::get_all_valid_articletype('artp_fwm_id,artp_id,artp_article_type', $val_artp_conditiion,$arttypebind_arr);

            $single_multi_invite_btn_stat = $this->single_multi_invite_btn_stat($jnl_id,$activerole);
            $result['show_single_invite_unvite_btn'] = $single_multi_invite_btn_stat['show_single_btn'];
            $result['show_multi_invite_unvite_btn']  = $single_multi_invite_btn_stat['show_multi_btn'];


            $article_table = (new \App\Models\Articles())->getTable();
            $user_table = (new \App\Models\User())->getTable();
            $select = 'usr_id,(CONCAT(usr_first_name,  IF(usr_middle_name IS NULL OR usr_middle_name = ""," ",CONCAT(" ", usr_middle_name, " ")), usr_last_name)) as usr_full_name, usr_email as user_email';
            $bind_arr = array();
            if(!empty($srch_term)) {
                $where_cndtn = ' AND (concat(usr_first_name, " " ,usr_last_name) LIKE ? OR usr_email LIKE ?)';
                $bind_arr[]=  "%".$srch_term["q"]."%";
                $bind_arr[]=  "%".$srch_term["q"]."%";
            }

            $query ="SELECT {$select} FROM {$article_table} INNER JOIN {$user_table} ON art_submitted_by = usr_id WHERE art_delete_status = 'n'  {$where_cndtn} GROUP BY usr_id ORDER BY usr_first_name ASC";
       
            $queryresult = Articles::get_records_by_raw_query($query,false,$bind_arr);

            $resultsusers = [];
            if(!empty($queryresult)) {
            foreach($queryresult as $list) {
                $resultsusers[] = array(
                    'id'=> $this->encrypt_data($list->usr_id),
                    'text'=> $list->usr_full_name .'['.$list->user_email.']'
                );
            }}

            $result['filter_users'] = $resultsusers;
            $result['all_star_rating']=array(
                '1' => '1.0 Star',
                '1.5' => '1.5 Star',
                '2' => '2.0 Star',
                '2.5' => '2.5 Star',
                '3' => '3.0 Star',
                '3.5'=>'3.5 Star',
                '4'=>'4.0 Star',
                '4.5'=>'4.5 Star',
                '5'=>'5.0 Star'
            );
            return $this->success('success', 200, $result);

        } catch (\Exception $e) {
            $this->customErrorAction('manage_proposal',$e);
        }
    }

    public function manage_proposal(Request $request) {
        $form_data = $request->all();
        try {
            $is_proceeding=$this->check_client_proceeding();
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $res=array();
            $articleflow_table = (new \App\Models\Article_flow())->getTable();
            $genericflows_table = (new \App\Models\Generic_flows())->getTable();
            $result=array();
            $result['article_status'] = array(
                'u' => 'Not Invited',
                'i' => 'Invited',
                'd' => 'Declined',
                'c' => 'Submitted',
                'a' => 'Submission In Progress',
            );

            $validsortorder=array('ASC','asc','desc','DESC');
            $validsortfield=array('id','art_id','art_title','artp_abbr_article_type','artp_article_type','art_invitation_due','art_submission_date','art_title_editable','usr_first_name','classification','art_chapter_order');

            $jnlidarray = array('input'=>$form_data['jnl_id'],'type'=>'number', 'enc_data'=>true );
            $jnlcodearray = array('input'=>$form_data['jnl_code']);
            $jnlidvalidation = $this->Rv_validator($jnlidarray);
            $jnlcodevalidation = $this->Rv_validator($jnlcodearray);

            if($jnlidvalidation !== true || $jnlcodevalidation !== true ){
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
			}


            $jnlcodevalid = $this->validatecode(array('jnl_code'=>$form_data['jnl_code']),false);
            if($jnlcodevalid['jnl_code'] !== true ){
                $res['msg']=customTrans('viewarticle.invalid_data');
                return  $this->warning('Warnings',200,$res,'warning');
			}



            $jnl_id=$this->decrypt_data($form_data['jnl_id']);
            $journal_code=$form_data['jnl_code'];
            $activerole=$form_data['activerole'];



            $this->current_user = $this->get_current_user_details();
            $result['show_page_title']  =   true;

            $condition                      =   array("vol_jnl_id"=>$jnl_id);
            $result['volumes']  =   Volumes::get_all_records_with_bind_cond('vol_id,vol_jnl_id,vol_title,vol_posted_by,vol_posted_date,vol_proxy_id,vol_operation',$condition);
            $this->currentuser = $this->get_current_user_details();

            

            $single_multi_invite_btn_stat = $this->single_multi_invite_btn_stat($jnl_id,$activerole);
            $show_single_invite_unvite_btn = $single_multi_invite_btn_stat['show_single_btn'];
            $show_multi_invite_unvite_btn  = $single_multi_invite_btn_stat['show_multi_btn'];

            $user_permission_roles          =   Journal_settings::get_single_record_with_bind_cond('jset_draft_proposal_invite, jset_classification, jset_classification_title',array("jset_jnl_id"=>$jnl_id));
            $manage_bulk_users              =   array();

            if(isset($user_permission_roles->jset_draft_proposal_invite) && $user_permission_roles->jset_draft_proposal_invite != null) {
                $manage_bulk_users      =   json_decode($user_permission_roles->jset_draft_proposal_invite);
            }

            $jset_classification = optional($user_permission_roles)->jset_classification ?? 'n';
            $jset_classification_title = optional($user_permission_roles)->jset_classification_title ?? 'Classification';
            if(!in_array($activerole, $manage_bulk_users)) {
                $res['msg']='gotodashboard';
                return  $this->warning('Warnings',200,$res,'warning');
            }

        $post_data['start'] = isset($form_data['start']) ? $form_data['start'] : '0';
        $post_data['sort_order'] = isset($form_data['sort_order']) ? $form_data['sort_order'] : '';
        $post_data['sort_field'] = isset($form_data['sort_field']) ? $form_data['sort_field'] : '';
        $post_data['per_page'] = isset($form_data['per_page']) ? $form_data['per_page'] : '';
        $post_data['jnl_id'] = $jnl_id;
        $post_data['manage_proposal']['article_id'] =isset($form_data['paramsdet']['article_id']) ? $form_data['paramsdet']['article_id'] : '';
        $post_data['manage_proposal']['article_title'] =isset($form_data['paramsdet']['article_title']) ? $form_data['paramsdet']['article_title'] : '';
        $post_data['manage_proposal']['article_type'] =isset($form_data['paramsdet']['article_type']) ? $form_data['paramsdet']['article_type'] : '';

        $post_data['manage_proposal']['date_selection'] =isset($form_data['paramsdet']['date_selection']) ? $form_data['paramsdet']['date_selection'] : '';
        $post_data['manage_proposal']['invitation_date'] =isset($form_data['paramsdet']['invitation_date']) ? $form_data['paramsdet']['invitation_date'] : '';
        $post_data['manage_proposal']['invitation_startdate'] =isset($form_data['paramsdet']['invitation_startdate']) ? $form_data['paramsdet']['invitation_startdate'] : '';
        $post_data['manage_proposal']['invitation_enddate'] =isset($form_data['paramsdet']['invitation_enddate']) ? $form_data['paramsdet']['invitation_enddate'] : '';
        $post_data['manage_proposal']['submission_date'] =isset($form_data['paramsdet']['submission_date']) ? $form_data['paramsdet']['submission_date'] : '';
        $post_data['manage_proposal']['submission_startdate'] =isset($form_data['paramsdet']['submission_startdate']) ? $form_data['paramsdet']['submission_startdate'] : '';
        $post_data['manage_proposal']['submission_enddate'] =isset($form_data['paramsdet']['submission_enddate']) ? $form_data['paramsdet']['submission_enddate'] : '';
        $post_data['manage_proposal']['filtr_by_auth'] =isset($form_data['paramsdet']['filtr_by_auth']) ? $form_data['paramsdet']['filtr_by_auth'] : '';
        $post_data['manage_proposal']['status_selection'] =isset($form_data['paramsdet']['status_selection']) ? $form_data['paramsdet']['status_selection'] : '';;
        $post_data['manage_proposal']['show_entries'] ='';
        $post_data['manage_proposal']['classification'] =isset($form_data['paramsdet']['classifications']) ? $form_data['paramsdet']['classifications'] : '';
        if(isset($form_data['paramsdet']['article_id'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['article_id']);
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid :article id you have entered');
                return  $this->warning('Warnings',200,$res,'warning');
			}

        }

        if(isset($form_data['paramsdet']['article_title'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['article_title']);
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid :article title you have entered');
                return  $this->warning('Warnings',200,$res,'warning');
			}

        }

        if(isset($form_data['paramsdet']['article_type'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['article_type'],'type'=>'number', 'enc_data'=>TRUE);
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid :article type you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['classification'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['classification'],'type'=>'number');
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid '. $jset_classification_title.' you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['date_selection'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['date_selection']);
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid date selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['invitation_date'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['invitation_date'],'type'=>'date' );
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid invitation date selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['invitation_startdate'])) {
            $artcodearray = array('input'=>date('Y-m-d',strtotime($form_data['paramsdet']['invitation_startdate'])),'type'=>'date' );
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid invitation date selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['invitation_enddate'])) {
            $artcodearray = array('input'=>date('Y-m-d',strtotime($form_data['paramsdet']['invitation_enddate'])),'type'=>'date' );
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid invitation date selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }


        if(isset($form_data['paramsdet']['submission_date'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['submission_date'],'type'=>'date' );
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid submission date selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['submission_startdate'])) {
            $artcodearray = array('input'=>date('Y-m-d',strtotime($form_data['paramsdet']['submission_startdate'])),'type'=>'date' );
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid submission date selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['submission_enddate'])) {
            $artcodearray = array('input'=>date('Y-m-d',strtotime($form_data['paramsdet']['submission_enddate'])),'type'=>'date' );
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']='Invalid submission date selection you have selected';
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['status_selection'])) {
            $artcodearray = array('input'=>$form_data['paramsdet']['status_selection']);
            $artcodevalidation = $this->Rv_validator($artcodearray);
            if($artcodevalidation !== true ){
                $res['msg']=customTrans('Invalid proposal status you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if(isset($form_data['paramsdet']['filtr_by_auth'])) {
            $searchauthorflag=true;
            $searchauthor=$form_data['paramsdet']['filtr_by_auth'];
            for($i=0;$i<count($searchauthor);$i++) {
                $artcodearray = array('input'=>$searchauthor[$i],'type'=>'number', 'enc_data'=>true);
                $artcodevalidation = $this->Rv_validator($artcodearray);
                if($artcodevalidation !== true ){
                    $searchauthorflag=false;
                }
            }

            if($searchauthorflag !== true ){
                $res['msg']=customTrans('Invalid author selection you have selected');
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }


        if (isset($post_data['per_page']) && $post_data['per_page'] != ''){
            $fieldarray = array('input'=>$post_data['per_page'],'type'=>'number');
            $fieldvalidation = $this->Rv_validator($fieldarray);
            if($fieldvalidation !== true ){
                $res['msg']='Invalid data';
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }


        if (isset($post_data['sort_field']) && $post_data['sort_field'] != ''){
            $fieldarray = array('input'=>$post_data['sort_field']);
            $fieldvalidation = $this->Rv_validator($fieldarray);
            if($fieldvalidation !== true ){
                $res['msg']='Invalid data';
                return  $this->warning('Warnings',200,$res,'warning');
			}
        }

        if (isset($post_data['sort_order']) && $post_data['sort_order'] != '' && !in_array($post_data['sort_order'], $validsortorder)){
                $res['msg']='Invalid data';
                return  $this->warning('Warnings',200,$res,'warning');
            }
            

        if (isset($post_data['sort_field']) && $post_data['sort_field'] != '' && !in_array($post_data['sort_field'], $validsortfield)){
                $res['msg']='Invalid data';
                return  $this->warning('Warnings',200,$res,'warning');
            }
            


        $data           = array();
        $result = $this->get_proposals(null,$jnl_id,$post_data,$jset_classification);
        $total_records  = $result['tot_count'];
        $article_result = $result['articles'];
        $lastPage = $result['lastPage'];

        $currentPage = $result['currentPage'];
        $perPage     = $result['per_page'];
        $total       = $result['tot_count'];
        $to          = $currentPage * $perPage;
        $from        = (($currentPage - 1) * $perPage) + 1;
        if($lastPage == $currentPage){
            $to = $total;
        }

        $k=0;
        if (count($article_result) > 0) {
                $show_single_invite_unvite_btn = $single_multi_invite_btn_stat['show_single_btn'];
                $show_multi_invite_unvite_btn  = $single_multi_invite_btn_stat['show_multi_btn'];
                $artIds = $article_result->pluck('art_id')->toArray();   //Task #1850
                // $classification = Article_classification::get_article_classification($artIds,'multiple');
                // $classification = !empty($classification)?$classification->pluck('term_name','art_id')->toArray():"";
                foreach($article_result as $val) {
                    $show_view_article = false;
                    $k++;
                    $prev_art_ids_arr =  explode(',',$val->art_pre_all_ids);
                    $original_art_id  =  $prev_art_ids_arr[0];

                    if($val->usr_id==0){
                        continue;
                    }

                    $tables = array(
                        'main_table' => $articleflow_table,
                        'join_table' => array(
                            $genericflows_table => array($articleflow_table . '.aflw_jwf_id', $genericflows_table . '.jwf_id', "left")
                        )
                    );

                    $condition = "aflw_art_id='{$original_art_id}' AND jwf_stage_type='author_submission'";


                    $date_format = $this->get_platform_date_format($jnl_id);
                    $date_format= date_format_map($date_format);
                    //
                    $original_art_data = Article_flow::get_results_using_joins($tables, 'DATE_FORMAT(aflw_due_date, "' . $date_format . '") as due_date', $condition, 'single');

                    if(!empty($val->art_pre_all_ids))
                    {
                        $val->due_date = $original_art_data->due_date;
                    }
                    $tmpl = '';
                    $hide_stat = 'hide';
                    $stage_flag = 'false';
                    if($val->jwf_stage_type == 'author_submission')
                    {
                        $stage_flag = 'true';
                        if($val->aflw_status == 'u')
                        {
                            $tmpl = 'invitation';
                            $hide_stat = '';
                        }
                        elseif($val->aflw_status == 'i')
                        {
                            $tmpl = 'uninvite';
                        }
                        elseif($val->aflw_status == 'a')
                        {
                            if($val->art_proposal_method == 'assign')
                            {
                            $tmpl = 'unassign';
                            }
                            $check_arr = array();
                            $check_arr['role_id'] = $form_data['activerole'];
                            $check_arr['jnl_id'] = $post_data['jnl_id'];
                            $show_view_article = $this->check_view_article_on_submission($check_arr);
                        }
                    }
                    $invitation_expired_status = 'n';
                    $submission_date_expired_status = 'n';
                    $submission_date_warning = 'n'; 
                    $clientCode = $this->current_client->clnt_client_code;
                    $configKey = 'clients.' . $clientCode . '.client_default';
                    $submission_due_date = Config::get($configKey);
                    $minSubmissionDate=$submission_due_date['min_submission_date'];
                    if($val->author_response_due_remaining < 0)
                    {
                        $invitation_expired_status = 'y';
                    }
                    if($val->submission_due_remaining < 0)
                    {
                        $submission_date_expired_status = 'y';
                    }
                    elseif (isset($minSubmissionDate) && $minSubmissionDate !== null && $val->aflw_due_date !='' && $val->submission_due_remaining <= $minSubmissionDate) {
                        // if $val->aflw_due_date is not null then show the warning
                        // Submission is close to expiring — too short
                        $submission_date_warning = 'y'; 
                    }
                  
                    $status_chk         = ($val->aflw_status == 'i' && $val->jwf_stage_type == 'author_submission') ? 'i' : 'a';
                    $check_box_html = '<input id="invite_checkbox_'.$this->encrypt_data($val->art_id).'" 
                    type="checkbox" 
                    class="article_select" 
                    name="articles'.$k.'" 
                    data-tmpl="'. $tmpl .'" 
                    data-aflw_stat="'. $status_chk .'" 
                    data-show_invite_btn="'. $val->show_invite_btn .'" 
                    data-artp_id="'. $this->encrypt_data($val->art_artp_id) . '" 
                    data-art_id = "'. $this->encrypt_data($val->art_id).'" 
                    data-aflw_id = "'. $this->encrypt_data($val->aflw_id). '" 
                    data-user_id = "'. $this->encrypt_data($val->usr_id). '" 
                    data-expired_status = "'. $invitation_expired_status .'" 
                    data-submission_date_expired_status = "'. $submission_date_expired_status .'" 
                    data-stage_etmp_id="'. $this->encrypt_data($val->stage_etmp_id) .'" 
                    id="check_'. $this->encrypt_data($val->art_id) .'" 
                    value="'. $this->encrypt_data($val->art_id) .'">';
                    $invite_due_date_html= '<span id="invite_due_date_'. $this->encrypt_data($val->art_id).'">'.$val->author_response_due.'</span>';
                    $sub_due_date_html   = '<span id="sub_due_date_'. $this->encrypt_data($val->art_id).'">'.$val->due_date.'</span>';
                    $sub_due_date_html= $val->due_date;
                    $email_tmpl_html     = '<span id="stage_name_div_'. $this->encrypt_data($val->art_id).'">'. $val->stage_etmp_name.'</span>&nbsp;
                    <a href="javascript:void()" class="p-r-10 '. $hide_stat .'" id="edit_emailtemplate_'. $this->encrypt_data($val->art_id).'"  name="edit_emailtemplate" data-show-editpage="" data-editurl="">
                    <i class="glyphicon glyphicon-edit edit_this_template" id="edit_this_template_'. $this->encrypt_data($val->art_id) .'" data-artp_id="'. $this->encrypt_data($val->art_artp_id) .'" data-art_id="'. $this->encrypt_data($val->art_id) .'" data-aflw_id="'. $this->encrypt_data($val->aflw_id) .'" data-user_id="'. $this->encrypt_data($val->usr_id) .'" data-stage_etmp_id="'. $this->encrypt_data($val->stage_etmp_id) .'" data-tmpl="'. $tmpl .'" title="Edit"></i>
                    </a>';
                    $displayarray=array();
                    $displayarray['user_id']=$val->usr_id;
                    $displayarray['jnl_code']=$journal_code;
                    $displayarray['flag']=true;
                    $displayarray['article_id']=$val->art_id;
                    $displayarray['availability']=true;
                    $displayarray['save_coauthor']=false;
                    $displayarray['remove_user']=false;
                    $displayarray['source']=false;
                    $displayarray['salutation']=true;
                    $displayarray['flag_only']=false;
                    $displayarray['inactive_user']=false;
                    $displayarray['fullname_only']=false;
                    $displayarray['journal_id'] = $jnl_id;
                    $title_html          = $this->get_user_display_name($displayarray);

                    $class               = $val->article_status['class'];
                    $title               = $val->article_status['title'];

                    $show_invite = 'hide';
                    $show_uninvite = 'hide';
                    $show_unassign = 'hide';
                    $val->tab_status_array = json_decode($val->tab_status_array, true) ?? [];
                    if ($val->jwf_stage_type == 'author_submission') {
                        if ($val->aflw_status == 'u') {
                            $show_invite = '';
                        }
                        if ($val->aflw_status == 'i') {
                            $show_uninvite = '';
                        }
                        if ($val->aflw_status == 'a' && $val->art_proposal_method == 'assign' && isset($val->tab_status_array['tab_article_details']) && $val->tab_status_array['tab_article_details'] !='c') {
                            $show_unassign = '';
                        }
                        if ($is_proceeding == true && ($val->aflw_status == 'u' || $val->aflw_status == 'i' ||  ($val->aflw_status == 'a' && $val->art_proposal_method  =='assign'))) {
                            $user_roles = $this->validate_user_journal($journal_code, session('user_id'));

                            // task #3137 removed the permission jp_imported_article_assigner
                            $show_multi_invite_unvite_btn = false;
                            $jnl_permit_roles_data = Journal_settings::get_single_record_with_bind_cond('jset_bulk_invite_submission',array('jset_jnl_id'=>$jnl_id));
                            $permited_bulk_invite_roles = json_decode($jnl_permit_roles_data->jset_bulk_invite_submission);
                            if(!empty($permited_bulk_invite_roles) && in_array($activerole, $permited_bulk_invite_roles))
                            {
                                $show_multi_invite_unvite_btn = true;
                            }
                            // $has_permission = $this->hasJournalPermission('jp_imported_article_assigner', $user_roles['role_id'], $val->jnl_jpm_id);
                            if ($show_multi_invite_unvite_btn === true) {
                                if ($val->aflw_status == 'u') {
                                    $show_invite = '';
                                }
                                if ($val->aflw_status == 'i') {
                                    $show_uninvite = '';
                                }
                                if ($val->aflw_status == 'a' && $val->art_proposal_method == 'assign' && isset($val->tab_status_array['tab_article_details']) && $val->tab_status_array['tab_article_details'] !='c') {
                                    $show_unassign = '';
                                }
                            }else{
                                if ($val->aflw_status == 'u') {
                                    $show_invite = 'hide';
                                }
                                if ($val->aflw_status == 'i') {
                                    $show_uninvite = 'hide';
                                }
                                if ($val->aflw_status == 'a' && $val->art_proposal_method == 'assign') {
                                    $show_unassign = 'hide';
                                }
                            }
                        }
                    }

                    $article_attchment_cnt = Attachment_files::get_single_record('count(atmnt_id) as count', "atmnt_art_id={$val->art_id}");

                    if($article_attchment_cnt->count == 0 && $is_proceeding == true) {
                        $title  .=  ' <span class="text-danger">(No attachments found)</span>';
                    }
                    $classification = isset($val->classification)?$val->classification:"";
                    // $term_name = "";                                                            //Task #1850
                    // if(env('VITE_CONFERENCE_PROCEEDINGS') === true && $classification!=""){
                    //     //$classification = Article_classification::get_article_classification($val->art_id);
                    //     $term_name = isset($classification[$val->art_id])?$classification[$val->art_id]:"";
                    // }
                    $Stage_email_templates= new \App\Models\Stage_email_templates();
                   $revoke_template_id='';
                    $tmpl_action = (isset($val->art_proposal_method) && $val->art_proposal_method === 'assign')
                            ? 'unassign_user'
                            : 'uninvite_user';
                   if (
                    isset($val->jwf_stage_type, $val->jwf_id) &&
                    !empty($val->jwf_stage_type) &&
                    !empty($val->jwf_id) && (($val->aflw_status == 'i' && $tmpl_action == 'uninvite_user')|| ($val->aflw_status == 'a' && $tmpl_action == 'unassign_user'))
                ) {
                        $condition="stage_etmp_stage_type='{$val->jwf_stage_type}' AND setr_jwf_id={$val->jwf_id} AND stage_etmp_action='{$tmpl_action}'";
                        $template = $Stage_email_templates::get_stage_email_tmpl_to_trigger('*', $condition);
                        if (!empty($template)) {
                       $revoke_template_id = $template->pluck('stage_etmp_id')->toArray();
                    
                }
            }                   
                    $data[] = array(
                       "nullField"  => '',
                       "checkbox"   => $check_box_html,
                       "data_tmpl"   => $tmpl,
                       "data_aflw_stat"   => $status_chk,
                       "data_show_invite_btn"   => $val->show_invite_btn,
                       "art_id"     => $val->art_code,
                       "art_title"  => trim(strip_tags($val->art_title)),
                       "perm_status"  => $val->perm_status,
                       "artp_article_type"  => $val->artp_article_type,
                       "art_invitation_due" => $invite_due_date_html,
                       "art_submission_date"=>$sub_due_date_html,
                       "email_templ"=> $email_tmpl_html,
                       "art_title_editable" => ($val->art_title_editable == 'y') ? 'Yes': 'No',
                       "usr_first_name"     => $title_html,
                       "title_class"      => $class,
                       "aflw_status"      => $val->aflw_status,
                       "auth_sub_aflw_status"      => $val->auth_sub_aflw_status,
                       "jnl_code"      => $journal_code,
                       "draft_status"=>$hide_stat,
                       "title"      => $title,
                       "show_single_invite_unvite_btn"=>$show_single_invite_unvite_btn,
                       "show_invite"=>$show_invite,
                       "show_uninvite"=>$show_uninvite,
                       "expired_status"=>$invitation_expired_status,
                       "encrypt_art_id"=>$this->encrypt_data($val->art_id),
                       "encrypt_artp_id"=>$this->encrypt_data($val->art_artp_id),
                       "encrypt_usr_id"=>$this->encrypt_data($val->usr_id),
                       "encrypt_jwf_fwm_id"=>$this->encrypt_data($val->jwf_fwm_id),
                       "encrypt_aflw_id"=>$this->encrypt_data($val->aflw_id),
                       "encrypt_stage_etmp_id"=>$this->encrypt_data($val->stage_etmp_id),
                       "encrypt_type_code"=>$this->encrypt_data($val->artp_abbr_article_type),
                       "encrypt_jnl_id" => $this->encrypt_data($jnl_id),
                       "show_view_article" => $show_view_article,
                       "art_proposal_method" => $val->art_proposal_method,
                       "article_attchment_cnt" => $article_attchment_cnt->count,
                       'classification' => $classification,                          //Task #1850
                       "submission_date_expired_status" => $submission_date_expired_status,
                       "submission_date_warning"=>$submission_date_warning,
                       "show_unassign"=>$show_unassign,
                       "tab_status_array" => $val->tab_status_array['tab_article_details'] ?? '',
                       "stage_flag"=>$stage_flag,
                       "art_chapter_order"=>$val->art_chapter_order,
                       "show_reorder_btn"=>$val->show_reorder_btn,
                       "art_delete_status" =>$val->art_delete_status,
                       "art_status"=>$val->art_status,
                       'revoke_template_id'=>$revoke_template_id

                    );
                 }
            }
            /*$not_assi_art_cnt       =   0;
            $not_assi_art_cnt_qry   =   "SELECT
                                            count(art_id) cnt
                                        FROM
                                            `rvw_articles`
                                        JOIN rvw_article_flow ON
                                            (art_id = aflw_art_id)
                                        JOIN rvw_journal_workflows ON (aflw_jwf_id = jwf_id)
                                        JOIN rvw_article_types ON
                                            (`art_artp_id` = artp_id)
                                        WHERE
                                            aflw_status ='u' and art_proposal_method = 'assign' AND artp_jnl_id = $jnl_id 
                                            AND art_delete_status = 'n' and jwf_stage_type = 'author_submission'";
            $not_assi_art_cnt_res      =   Articles::get_records_by_raw_query($not_assi_art_cnt_qry);
            if(isset($not_assi_art_cnt_res)) {
                $not_assi_art_cnt   =   $not_assi_art_cnt_res[0]->cnt;
            }*/

            //Task #3027 id search is done, then no need to show the re-order button for each articles
            $srchFlg   =   false;
            // if((isset($form_data['paramsdet']) && count($form_data['paramsdet']) > 0) || (isset($form_data['sort_field']) && $form_data['sort_field'] != ''))
            // {
            //     $srchFlg   =   true;
            // }

            //fetch the client's proceeding config array
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('article-proposal');
            
            // Task #3791 No edit, attachments, and re-order for Organizer
            $organiser_permission  =   true;
            if($is_proceeding == true) {
                $organiser_permission  =   $this->check_organiser_permission($jnl_id, $activerole);
            }

             $response = array(
                'data'              => $data,
                'last_page'      => $lastPage,
                'total_records'   => $total_records,
                'organiser_permission'   => $organiser_permission,
                'show_multi_invite_unvite_btn' => $show_multi_invite_unvite_btn,
                'per_page'       => $perPage,
                'currentPage'    => $currentPage,
                'to' => $to,
                'from' => $from,
                'proceedingArr' => $proceedingArr,
                'srchFlg' => $srchFlg
            );

            return $this->success('success', 200, $response);

        } catch(\Exception $e) {
            $this->customErrorAction('manage_proposal',$e);
            return  $this->failure('Failed',500,$e);
        }
    }

    /*
     * Task #3791 No edit, attachments, and re-order for Organizer
     * return boolean true or false
    */
    public function check_organiser_permission($jnl_id, $role_id) {
        // $activerole
        $user_roles = Roles::get_single_record('role_name', 'role_id = '.$role_id.' and role_assigned_role = "editor_in_chief"');
        // static check using 'organizer' is written after discussion with gijo
        if (!empty($user_roles) && ($user_roles->role_name == 'Organiser' || $user_roles->role_name == 'Organizer'))
        {
            //If organiser article creation due date is expired, then return false
            $jset_conf_duedate_qry = Journal_settings::get_single_record_with_bind_cond('jset_conf_duedate',['jset_jnl_id' => $jnl_id]);
            $show_jset_conf_duedate     =   false;
            if ($jset_conf_duedate_qry && !empty($jset_conf_duedate_qry->jset_conf_duedate)) {
                $duedate = new DateTime($jset_conf_duedate_qry->jset_conf_duedate);
                $today = new DateTime('today');
                if($duedate != null && $duedate != '' && $duedate < $today) {
                    return false;
                }
            }

            //Check if any articles has assigned or moved to next stages, then return false
            $assi_art_cnt_qry       =   "SELECT
                                            count(art_id) cnt
                                        FROM
                                            `rvw_articles`
                                        JOIN rvw_article_flow ON (art_id = aflw_art_id)
                                        JOIN rvw_journal_workflows ON (aflw_jwf_id = jwf_id)
                                        JOIN rvw_article_types ON (`art_artp_id` = artp_id)
                                        WHERE
                                            aflw_status !='u' and art_proposal_method = 'assign' AND artp_jnl_id = $jnl_id 
                                            AND art_delete_status = 'n' and jwf_stage_type = 'author_submission'";
            $assi_art_cnt_res      =   Articles::get_records_by_raw_query($assi_art_cnt_qry);
            if(isset($assi_art_cnt_res)) {
                if($assi_art_cnt_res[0]->cnt > 0) {
                    return false;
                }
            }

            //Check if a organiser has informed the cp team member after articles has created, then return false
            $events_table   =   (new \App\Models\Events_model())->getTable();
            $sel_sql1		=	"SELECT event_id FROM ".$events_table." WHERE event_name='Notify cp_team_members'";
            $results1 		= 	Events_model::get_records_by_raw_query($sel_sql1);
            $event_id       =   '';

            if (!empty($results1)) {
                $event_id   =   $results1[0]->event_id;

                if($event_id != '')
                {
                    $email_already_exists    =   Event_invited_users::get_single_record_with_bind_cond('count(evu_id) as cnt', array('evu_jnl_id' =>$jnl_id, 'evu_event_id'=>$event_id, 'evu_submit_status' => 'i'));
                    if($email_already_exists->cnt > 0) 
                    {            
                        return false;
                    }
                }
            }
        }

        return true;
    }


    public function get_proposals($article_id = null, $jnl_id = null, $post_data = null,$classificationEnable = 'n')
    {
        $articles_per_page = 10;
        $articleflow_table = (new \App\Models\Article_flow())->getTable();
        $journalworkflow_table = (new \App\Models\Generic_flows())->getTable();
        $bind_arr = array();
        if (isset($post_data['manage_proposal']) && !empty($post_data['manage_proposal'])) {
            $form_data = $post_data['manage_proposal'];
        }
        if (isset($post_data['per_page']) && $post_data['per_page'] != '') {
            $articles_per_page  =   $post_data['per_page'];
        }
        $affl_config = 'clients.' . $this->current_client->clnt_client_code;
        $sort = Config::get($affl_config . '.proposal_article')['sort'];
        //setting sort
        $orderby_field = '';
        if (isset($post_data['sort_field']) && $post_data['sort_field'] != '') {
            if ($post_data['sort_field'] == 'art_id') {
                $orderby_field = 'art_code';
            } elseif ($post_data['sort_field'] == 'id') {
                $orderby_field = 'art_id';
            } elseif ($post_data['sort_field'] == 'art_submission_date') {
                $orderby_field = 'due_date';
            }elseif ($post_data['sort_field'] == 'classification') {
                $orderby_field = 'term_id';
            } else {
                $orderby_field = $post_data["sort_field"];
            }
        }else
            $orderby_field = $sort["field"];
        // Setting orderby
        $orderby_mode = '';
        if (isset($post_data["sort_order"]) && ($post_data["sort_order"] != 0 && $post_data["sort_order"] != "")) {
            $orderby_mode = $post_data["sort_order"];
        }else
            $orderby_mode = $sort["order"];
        //core conditions

        //Task #3027 is article numbering func is ON, then show the dleted aryicles also. because if it is no showing then the re-ordering will be error
        if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y'){
            $delQry     =   '';
        } else {
            $delQry     =   'AND art_delete_status = \'n\'';
        }

        $condition = 'jnl_id = ? '.$delQry.' AND art_stage_submission_method=\'b\'';
        $bind_arr[] =  $jnl_id;
        if ($article_id != null) {
            $condition .= ' AND art_id = ? ';
            $bind_arr[] =  $article_id;
        }
        //Additional conditions
        $additional_having = array();
        //article id search
        if (isset($form_data['article_id']) && $form_data['article_id'] != '') {
            $form_data['article_id'] = trim($form_data['article_id']);
            $condition = $condition . " AND  `art_code` LIKE ? ";
            $bind_arr[] =  "%" . $form_data['article_id'] . "%";
        }
        //article title search
        if (isset($form_data['article_title']) && $form_data['article_title'] != '') {
            $form_data['article_title'] = trim($form_data['article_title']);
            $condition = $condition . " AND `art_title` LIKE ? ";
            $bind_arr[] =  "%" . $form_data['article_title'] . "%";
        }
        //article type search
        if (isset($form_data['article_type']) && $form_data['article_type'] != '') {
            $condition = $condition . " AND  `art_artp_id` = ? ";
            $bind_arr[] =  $this->decrypt_data($form_data['article_type']);
        }
        //author invitation date
        if (isset($form_data['date_selection']) && $form_data['date_selection'] != '') {
            if ($form_data['invitation_date'] != '' && $form_data['date_selection'] == 'id') {
                $invitation_date = $form_data['invitation_date'];
                $condition = $condition . " AND `art_invitation_due` LIKE ? ";
                $bind_arr[] =  "%" . $invitation_date . "%";
            } elseif ($form_data['invitation_startdate'] != '' && $form_data['invitation_enddate'] != '' && $form_data['date_selection'] == 'idr') {
                $invitation_start_date = $form_data['invitation_startdate'];
                $invitation_end_date = $form_data['invitation_enddate'];
                $condition = $condition . " AND `art_invitation_due` BETWEEN ? AND ? ";
                $bind_arr[] =  $invitation_start_date;
                $bind_arr[] =  $invitation_end_date;
            } elseif ($form_data['submission_date'] != '' && $form_data['date_selection'] == 'sd') {
                $submission_date = $form_data['submission_date'];
                $additional_having[] = " auth_sub_aflw_due_date LIKE ? ";
                $bind_arr[] =  "%" . $submission_date . "%";
            } elseif ($form_data['submission_startdate'] != '' && $form_data['submission_enddate'] != '' && $form_data['date_selection'] == 'sdr') {
                $submission_start_date = $form_data['submission_startdate'];
                $submission_end_date = $form_data['submission_enddate'];
                $additional_having[] = " auth_sub_aflw_due_date BETWEEN ? AND ? ";
                $bind_arr[] =  $submission_start_date;
                $bind_arr[] =  $submission_end_date;
            }
        }
        if (isset($form_data['filtr_by_auth']) && $form_data['filtr_by_auth'] != '' && count($form_data['filtr_by_auth']) > 0) {
            $temp_ar = array();
            foreach ($form_data['filtr_by_auth'] as $authflt) {
                $temp_ar[] = $this->decrypt_data($authflt);
            }
            $auth_filtr = implode(',', $temp_ar);
            $condition = $condition . " AND if(art_submitted_by IS not null,FIND_array_intersect(art_submitted_by,?)=1,false)  ";
            $bind_arr[] =  $auth_filtr;
        }
        // proposal status
        if (isset($form_data['status_selection']) && !empty($form_data['status_selection'])) {
            if ($form_data['status_selection'] == 'c') {
                $condition = $condition . " AND CASE WHEN `art_pre_all_ids` IS NULL THEN `art_status` != 'n' ELSE TRUE END ";
            } else {
                $prop_method = null;
                if ($form_data['status_selection'] === 'ua') {
                    $prop_method = 'assign';
                    $form_data['status_selection'] = 'u';
                }elseif ($form_data['status_selection'] === 'ui') {
                    $prop_method = 'invite';
                    $form_data['status_selection'] = 'u';
                }
                $condition = $condition . " AND `aflw_status` = ? AND `jwf_stage_type` LIKE 'author_submission' ";
                $bind_arr[] =  $form_data['status_selection'];
                if ($prop_method !== null) {
                    $condition .= " AND `art_proposal_method` = '$prop_method'";
                }
            }
        }
        // if (isset($form_data['classification']) && !empty($form_data['classification'])) {
        //     $classification = implode(',', array_map('intval', $form_data['classification']));
        //     $condition = $condition . " AND `cls_id` IN (".$classification.")";
        //    // $bind_arr[] = implode(',', array_map('intval', $form_data['classification']));
        // }
        $ArticleClassificationTable     = (new \App\Models\Article_classification())->getTable();
        $ClassificationTable            = (new \App\Models\Classifications())->getTable();
         $Classification           = new \App\Models\Classifications();
           if (!empty($form_data['classification']) && is_array($form_data['classification'])) {
         $classification_array = $form_data['classification'];

         $classification_articles = [];
         $criteria = 'rvw_classifications.cls_id IN (' . implode(',', array_map('intval', $classification_array)) . ')';

         $select_fields = "$ArticleClassificationTable.arcls_art_id";
          $tables = [
        'main_table' => $ClassificationTable,
        'join_table' => [
            $ArticleClassificationTable => [
                $ArticleClassificationTable . '.arcls_cls_id', 
                $ClassificationTable . '.cls_id'
            ]
        ]
       ];
    $result_obj = $Classification::get_results_using_joins($tables, $select_fields, $criteria, 'all');
 
    foreach ($result_obj as $data) {
        $classification_articles[] = $data->arcls_art_id;
    }
    $classification_articles = array_unique($classification_articles);
    if (count($classification_articles) > 0) {
        $additional_having[] = "art_id IN (" . implode(',', $classification_articles) . ")";
    } else {
        $additional_having[] = "0 = 1"; // ensures no results if no matching classification
    }
    }
        $date_format = $this->get_platform_date_format($jnl_id);
        $date_format = date_format_map($date_format);
        //to fetch the aflw_status of article submission (c,u,i,a,d)
        $chap_sub_aflw_id_sql   =   ', (SELECT `aflw_status` FROM ' . $articleflow_table . ' AS `fl2` JOIN '. $journalworkflow_table . ' `jw2` ON (`fl2`.`aflw_jwf_id` = `jw2`.`jwf_id`) WHERE `fl2`.`aflw_art_id` = `art_id` AND `jw2`.`jwf_stage_type` = "author_submission" and `jw2`.`jwf_fwm_id` = `jwf_fwm_id` ) as auth_sub_aflw_status, (SELECT `aflw_due_date` FROM ' . $articleflow_table . ' AS `fl2` JOIN ' . $journalworkflow_table . ' `jw2` ON (`fl2`.`aflw_jwf_id` = `jw2`.`jwf_id`) WHERE `fl2`.`aflw_art_id` = `art_id` AND `jw2`.`jwf_stage_type` = "author_submission" and `jw2`.`jwf_fwm_id` = `jwf_fwm_id` ) as auth_sub_aflw_due_date, (SELECT DATE_FORMAT(aflw_due_date, "' . $date_format . '") AS due_date FROM ' . $articleflow_table . ' AS `fl2` JOIN ' . $journalworkflow_table . ' `jw2` ON (`fl2`.`aflw_jwf_id` = `jw2`.`jwf_id`) WHERE `fl2`.`aflw_art_id` = `art_id` AND `jw2`.`jwf_stage_type` = "author_submission" and `jw2`.`jwf_fwm_id` = `jwf_fwm_id` ) as due_date';
        $filter_older_version = " AND( `art_status` IN('n', 'a', 'r', 't', 'y') OR( CASE WHEN art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a' END ) )";
        $condition .= ' AND fl1.aflw_id = (select max(aflw_id) from ' . $articleflow_table . ' as fl2 where fl2.aflw_art_id = fl1.aflw_art_id)' . $filter_older_version;
        $select =  ' art_id,art_code,art_proposal_method,art_title,art_status,artp_article_type,artp_jpm_id,jnl_jpm_id,art_pre_all_ids,art_absc_id, art_title_editable,art_chapter_order,art_delete_status,art_submitted_by,tab_status_array,usr_id,(CONCAT(usr_first_name, IF( usr_middle_name IS NULL OR usr_middle_name = "", " ", CONCAT(" ", usr_middle_name, " ") ), usr_last_name)) as usr_full_name, (DATEDIFF(`art_invitation_due`, NOW())) AS author_response_due_remaining, (DATEDIFF(`aflw_due_date`, NOW())) AS submission_due_remaining,aflw_id,art_artp_id,usr_email,aflw_status,jwf_stage_name,jwf_stage_type,aflw_posted_by,aflw_usr_id,jwf_fwm_id, artp_abbr_article_type,jnl_journal_code,jwf_child_stages,jwf_role_id,aflw_jwf_id,jwf_id,stage_etmp_id,stage_etmp_name, DATE_FORMAT(art_invitation_due, "' . $date_format . '") as author_response_due,art_invitation_due, DATE_FORMAT(aflw_due_date, "' . $date_format . '") as submission_due_date,aflw_due_date' . $chap_sub_aflw_id_sql;
        if ($article_id !== null) {
            $select .= ',art_ppub_date,DATE_FORMAT(art_ppub_date, "' . $date_format . '") as publication_date,art_email_template,art_publication_volume,art_publication_issue,iss_id,iss_title,vol_id,vol_title';
        }
        //$select .= ($classificationEnable == 'y')?',cls_id AS classification':"";

        //building sql
        $additional_having      = implode(' ', $additional_having);
        $artproposal_details = Articles::articleproposal_paginated_records($select, $condition, $additional_having, $orderby_field, $orderby_mode, $articles_per_page, $bind_arr,$classificationEnable);
        $proposed_articles = $artproposal_details['article_result'];
        if (!empty($proposed_articles)) {
            foreach ($proposed_articles as $article) {
                if($classificationEnable == 'y'){
                   $article_classification = [];
        $condition = array("arcls_art_id"=>$article->art_id);
        $checkBoxData = Article_classification::get_single_record_with_bind_cond(
            'GROUP_CONCAT(arcls_cls_id) as checkData',
            $condition
        );
    //    var_dump($checkBoxData);exit;
        if (!empty($checkBoxData->checkData)) {
            $article_classification = explode(',', $checkBoxData->checkData);
        }
        $article->classification = $article_classification;
    }               
    $select_fields = 'aflw_status ,aflw_id,jwf_stage_type,jwf_stage_name, jwf_status_name, aflw_parent_flow_id';
                $where_condition = "aflw_status IN('u', 'i', 'a', 'w', 'p') AND aflw_art_id = " . $article->art_id . " AND IF( aflw_status = 'u', aflw_parent_flow_id IS NULL, TRUE ) AND( IF( rvw_article_flow.aflw_status = 'w', aflw_more_review_skip_status = 'n' AND aflw_skip_review = 'n' AND( rvw_article_flow.aflw_stage_min_users >( SELECT COUNT(inn_tb.aflw_id) AS cnt FROM $articleflow_table AS inn_tb WHERE inn_tb.aflw_parent_flow_id = rvw_article_flow.aflw_id AND inn_tb.aflw_status IN('u', 'i', 'a', 'c') ) OR rvw_article_flow.aflw_stage_min_users >( SELECT COUNT(inn_tb.aflw_id) AS cnt FROM $articleflow_table AS inn_tb WHERE inn_tb.aflw_parent_flow_id = rvw_article_flow.aflw_id AND inn_tb.aflw_status IN('i', 'a', 'c') ) ), IF( rvw_article_flow.aflw_status = 'p', aflw_skip_review = 'n' AND rvw_article_flow.aflw_stage_min_users >( SELECT COUNT(inn_tb.aflw_id) AS cnt FROM " . $articleflow_table . " AS inn_tb WHERE inn_tb.aflw_parent_flow_id = rvw_article_flow.aflw_id AND inn_tb.aflw_status IN('a', 'c') ), TRUE ) ) ) AND (IF( `aflw_status` IN('u', 'i', 'a') AND `aflw_parent_flow_id` IS NOT NULL, (SELECT aflw_stage_min_users FROM " . $articleflow_table . " AS inn_tb1 WHERE inn_tb1.aflw_id=rvw_article_flow.aflw_parent_flow_id )>( SELECT COUNT(inn_tb.aflw_id) AS cnt FROM " . $articleflow_table . " AS inn_tb WHERE inn_tb.aflw_parent_flow_id = rvw_article_flow.aflw_parent_flow_id AND `inn_tb`.`aflw_status` IN('c') ), TRUE ))";
                $article_details = Articles::get_article_details($select_fields, $where_condition, null, true, true);
                $perm_status = true;
                $show_invite_btn = false;
                $show_edit_page = false;
                $url_edit_page = '';
                if (($article->aflw_status === 'u') && ($article->jwf_stage_type === 'author_submission')) {
                    $show_invite_btn = true;
                    $article->jwf_stage_name = '';
                }
                $status = '';
                $article_stage_name = array();
                if ($article->jwf_stage_type != 'author_submission' || ($article->aflw_status == 'a' && $article->jwf_stage_type === 'author_submission')) {
                    $article->article_status['class'] = '';
                    $article->article_status['title'] = '';
                    foreach ($article_details as $article_detail) {
                        if ($article_detail->aflw_status == 'a' || $article_detail->aflw_status == 'w' || $article_detail->aflw_status == 'i') {
                            $status = 'in-progress';
                        } elseif ($article_detail->aflw_status == 'p') {
                            $status = 'Awaiting assignment';
                        } elseif ($article_detail->aflw_status == 'u') {
                            $status = 'ready';
                        }
                        if (!in_array($article_detail->jwf_stage_name, $article_stage_name)) {
                            $article->article_status['title'] .= 'Stage <b>' . $article_detail->jwf_stage_name . '</b>: <i>' . $status . '</i><br>';
                            $article_stage_name[] = $article_detail->jwf_stage_name;
                        }
                    }
                    if ($article->jwf_stage_type == 'production' && $article->aflw_status == 'c') {
                        $article->article_status['title'] .= 'Stage <b>' . $article->jwf_stage_name . '</b>: <i>exported</i><br>';
                    }elseif ($article->aflw_status == 'c') {
                        $article->article_status['title'] .= 'Stage <b>' . $article->jwf_stage_name . '</b>';
                        // TASK #8161 Abstract Proposal Status Missing at Decision Reject Stage
                    }
                } else {
                    $invite_status = article_invitation_status();
                    if($article->art_proposal_method == 'assign' && $article->aflw_status == 'u')
                    $article->article_status['title'] = 'Not assigned';
                    else
                    $article->article_status['title'] = $invite_status[$article->aflw_status]['title'];
                
                    $article->article_status['class'] = $invite_status[$article->aflw_status]['class'];
                }
                if ($article->aflw_status == 'c') {
                    $article->redirect_link = '/' . $this->current_client->platform_type . '/' .  $article->jnl_journal_code . '/view-article/' . $this->encrypt_data($article->art_id) . '/' . $this->encrypt_data($article->aflw_id);
                } else {
                    $article->redirect_link = '';
                }
                $article->proceeding_arr  =   $this->fetch_client_proceeding_config_array('article-proposal');
                $article->show_edit_page = $show_edit_page;
                $article->url_edit_page = $url_edit_page;
                $article->perm_status = $perm_status;
                $article->show_invite_btn = $show_invite_btn;
                
                // Task #3027 Only if the cfty_article_numbering is ON
                // If any of the articles is assigned or in other stages then article re-ordering cannot be done. 
                $show_reorder_btn = false;
                if (($article->aflw_status === 'u') && ($article->jwf_stage_type === 'author_submission')) {
                    $show_reorder_btn = true;
                }
                $article->show_reorder_btn = $show_reorder_btn;
            }
        }
        $rtn_arr = array(
            'tot_count' => $proposed_articles->total(),
            'articles'  => $proposed_articles,
            'lastPage' => $proposed_articles->lastPage(),
            'per_page'       => $proposed_articles->perPage(),
            'currentPage'    => $proposed_articles->currentPage()
        );
        if ($article_id != null) {
            $rtn_arr = $proposed_articles;
        }
        return $rtn_arr;
    }

    public function single_multi_invite_btn_stat($jnl_id,$active_role_id)
    {
        $show_single_invite_unvite_btn = true;//no currently no permission is required to show single invite btn
        $show_multi_invite_unvite_btn = false;
        $rtn_data = array();
        if($active_role_id) {
            $jnl_permit_roles_data = Journal_settings::get_single_record_with_bind_cond('jset_create_article_stub,jset_bulk_invite_submission',array('jset_jnl_id'=>$jnl_id));
            $permited_single_invite_roles = json_decode($jnl_permit_roles_data->jset_create_article_stub);
            $permited_multi_invite_roles = json_decode($jnl_permit_roles_data->jset_bulk_invite_submission);
            if(!empty($permited_single_invite_roles) && in_array($active_role_id, $permited_single_invite_roles))
            {
                $show_single_invite_unvite_btn = true;
            }
            if(!empty($permited_multi_invite_roles) && in_array($active_role_id, $permited_multi_invite_roles))
            {
                $show_multi_invite_unvite_btn = true;
            }
        }
        $rtn_data = array(
            'show_single_btn' => $show_single_invite_unvite_btn,
            'show_multi_btn' => $show_multi_invite_unvite_btn,
        );
        return $rtn_data;
    }

    public function get_assigned_emailtemplate(Request $request) {
       
        try {
            $result=array();
            $post_data = $request->all();
            $is_proceeding=$this->check_client_proceeding();
            $Roles=new \App\Models\Roles();
            $artype=$post_data['artype'];
            $emailid=$post_data['emailid'];
            $propsl_methd = (isset($post_data['proposalmethod'])) ? $post_data['proposalmethod']: '';
            // $result['notes_to'] =$notes_to= User_to_journals::get_all_roles("usrj_artp_id='{$artype}' " , FALSE, 'a');// TASK #4943 getassignedemailtemplate sql injection
            $result['notes_to'] =$notes_to= User_to_journals::get_all_roles("usrj_artp_id=?" , false, 'a',binding_arr:[$artype]); // TASK #4943 getassignedemailtemplate sql injection
            $jnl_code = (isset($post_data['jnl_code']))? $post_data['jnl_code'] : '';
            $nots_to_rls = array();
            if(!empty($notes_to)) {
                foreach ($notes_to as $role) {
                    if (($role->role_assigned_role == 'journal_admin') || ($role->role_assigned_role == 'staff')) {
                        array_push($nots_to_rls,"".$role->role_id."");
                    }
                }
            }

            $result['default_noteto'] =json_encode($nots_to_rls);
            $getforms = Article_types::get_form_onstage('author_submission', $artype);
            if(!empty($getforms)) {
                $jwf_id =$getforms[0]->jwf_id;
                $condition ='setr_jwf_id ='.$jwf_id.' and stage_etmp_action=\'assigned\'';
                $template = Stage_email_templates::get_stage_email_tmpl_to_trigger('*', $condition);
            }
            $result['title_length'] =   Article_type_advance_options::get_single_record('atotp_title_length','atotp_artp_id = ?',binding_arr:[$artype])->atotp_title_length;
    /* Article proposal assignment  */
         $result['email_data'] = '';
            if($propsl_methd == "assign" && $emailid!='')
            {
               $condition ='setr_jwf_id='.$jwf_id.' and stage_etmp_action=\'assigned\' and stage_etmp_id ='.$emailid;
               $tmplt = Stage_email_templates::get_stage_email_tmpl_to_trigger('*', $condition); 
               $tmplt = $tmplt[0];
               $replace_all_tags = true;
               $preview_recipient = false;
               $this->currentuser=$this->get_current_user_details();
               $email_data = new stdClass;
               $email_data->artp_id = $artype;
               $email_data->mail_type = 'preview';
               $email_data->submsn_type = 'proposal';
               $email_data->jnl_journal_code = $jnl_code;
               $tmpl_subject = $tmplt->stage_etmp_subject;
               $tmpl_body = $tmplt->stage_etmp_content;
               $user_titles =  $this->UserConfigdata('titles')['titles'];
               if($jnl_code != '')
              {
               $jnl_user_role[$jnl_code]= array(
                   'role_id' => (isset($post_data['defaultrole']['role_id'])) ? $post_data['defaultrole']['role_id']: '',
                   'role_name' => (isset($post_data['defaultrole']['role_name'])) ? $post_data['defaultrole']['role_name']: '',
                   'core_role' => (isset($post_data['defaultrole']['core_role'])) ? $post_data['defaultrole']['core_role']: '',
               );
               $this->currentuser['jnl_user_role']=$jnl_user_role;
              }

               if ($tmplt->stage_etmp_to == 'User')
                {
                    $email_data->replace_email_link_tags = true;
                }
               $email_data->email_templates_config = $this->email_templates_config();
               if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
               {
                   $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
               }
               $email_data->join_config = $this->join_config();
               $email_data->join_dependency_config = $this->join_dependency_config();
               $email_data->user_role_tags = $this->user_role_tags();
               if (strpos($tmpl_body,"OPENING_PARAGRAPH") > 0){
                $tmpl_body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$tmpl_body);
                }
               if ($this->current_client->functionality->cfty_unique_hide_control_label_email == 'y'){
                   $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
               }
               $body = $this->generate_email_data_from_keys($email_data, $tmpl_body, $this->currentuser, $user_titles, $preview_recipient, $replace_all_tags);
               $subject = $this->generate_email_data_from_keys($email_data, $tmpl_subject, $this->currentuser, $user_titles, $preview_recipient);
               preg_match_all('/##([^##]*)##/', $body, $matches);
               $keys = $matches[1];
               for ($i = 0; $i < count($keys); $i++) {
                   $element = $keys[$i];
                   if(!empty($element))
                   {
                   $tmpl_data = str_ireplace('##'.$element.'##', '<button contenteditable="false">' . $element . '</button>',$body);
                   $body = $tmpl_data;
                   }
               }
               $body = str_ireplace('##', '', $body);
               $body=  str_ireplace('<button contenteditable="false"><button contenteditable="false">','<button contenteditable="false">', $body);
               $body=  str_ireplace('</button></button>','</button>', $body);
            
               $tmplt->stage_etmp_subject = $subject;
               $tmplt->stage_etmp_content = $body;
                    $to_cc_arr = json_decode($tmplt->stage_etmp_cc);
                    $to_bcc_arr = json_decode($tmplt->stage_etmp_bcc);
                    $cc_roles = array();
                    $bcc_roles = array();
                    $disable_cc_bcc_editable = $this->current_client->functionality->cfty_disable_email_cc_bcc_editable;
                    if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
                    {
                    $role_cond = 'role_assigned_role NOT IN ("system", "author")';
                    
                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow = Config::get($workflow_config);

                    $reviewflow = $review_flow['author_submission'];
                    if(isset($reviewflow['stage_for']))
                    {
                            if($reviewflow['stage_for'] == 'review')
                            {
                                $role_cond.=' and FIND_IN_SET("r", role_used_in)';
                            }
                            elseif($reviewflow['stage_for'] == 'manageproduction')
                            {
                                $role_cond.=' and FIND_IN_SET("p", role_used_in)';
                            }
                    }
                    $user_roles = $Roles::get_all_records('role_id, role_name, role_assigned_role', $role_cond);
                    if (!empty($user_roles))
                    {
                        foreach ($user_roles as $usrole)
                        {
                            $role_label = "All " . $usrole->role_name . "s";
                            $cc_roles[$usrole->role_name] = $role_label;
                            $bcc_roles[$usrole->role_name] = $role_label;
                        }
                    }
                }
                    $cc_roles['Custom_cc'] = 'Specific email ID';
                    $bcc_roles['Custom_bcc'] = 'Specific email ID';
				    $data = array(
                        'cc_roles' => $cc_roles,
                        'bcc_roles' => $bcc_roles,
                        'disable_cc_bcc_editable' => $disable_cc_bcc_editable,
                        'to_cc' => $to_cc_arr,
                        'to_bcc' => $to_bcc_arr,
                        'cust_cc' => $tmplt->stage_etmp_cust_cc !== '' ? explode(',',$tmplt->stage_etmp_cust_cc):'',
                        'cust_bcc' => $tmplt->stage_etmp_cust_bcc !=='' ? explode(',',$tmplt->stage_etmp_cust_bcc):'', 
                        'body' => $body,
                        'subject' => $subject
                    );
                    
                    $result['email_data'] =$data;
            }
           
                $result['emailtemplate'] = $template;

                // for AIPP article import
                $result['maxartimprowlmt'] = '';
                if($is_proceeding == true){
                    $result['maxartimprowlmt'] = Consts::MaxArtImpRowLmt;
                }
            
         /* Article proposal assignment  */
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }


    public function search_article_author(Request $request) {
        try {
            $userresult=array();
            $post_data = $request->all();
            $is_search=TRUE;
            $art_id         =   '';
            if($post_data['articleid'] != '') {
                $art_id =   $this->decrypt_data($post_data['articleid']);
            }
            $journal_code=$post_data['jnlcode'];
            $user_email     =   trim($post_data['user_email']);
             // TASK #4943 searcharticleauthor sql injection
            $jnl_id = Journals::get_single_record('jnl_id', "jnl_journal_code = ? ",binding_arr:[$journal_code])->jnl_id; 
            $userresult =  $this->fetch_search_users_result_view($user_email, $is_search, $art_id,$jnl_id,$journal_code);
            return $this->success('success', 200, $userresult);

        } catch (\Exception $e) {

            $this->customErrorAction('manage_proposal',$e);
            return $this->failure('Failed', 500, $e);
        }

    }



    public function fetch_search_users_result_view($user_email, $is_search = FALSE, $art_id = '',$jnl_id='',$journal_code='') {
        $userresult=array();
        $status         =   'success';
        $msg            =   '';
        $submitted_by  = null;
        $coauthor_fullname = null;
        $usr_id =null;
        $retain_author = true;
        if($user_email != '') {
            $condition          =   'usr_email = "'.$user_email.'"';
            $userresult  =  User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,"no" as art_decl_status', $condition);
            if($userresult!='' && $art_id != '') {
                $article_record      =   $this->get_proposals($art_id,$jnl_id);
                $fwm_id              =   $article_record[0]->jwf_fwm_id;
                $usr_id             =   $userresult->usr_id;

                $user_declined_res  =  Articles::is_user_have_declined_invitation($art_id,$fwm_id,$usr_id);
                if(sizeof($user_declined_res) > 0) {
                    $userresult->art_decl_status   =  $result['art_decl_status'] = 'yes';

                }
            }
        }
        if (!empty($art_id)) {
         $art_sub_by = Articles::get_single_record_with_bind_cond('art_submitted_by',['art_id' => $art_id]);
         $submitted_by  = $art_sub_by?->art_submitted_by ?? null;   
         if($usr_id  && $submitted_by == $usr_id)
         {
            $retain_author =false;
         }
        if($retain_author ==true && $submitted_by)
        {
                    $displayarray=array();
                    $displayarray['user_id']=$submitted_by;
                    $displayarray['jnl_code']=$journal_code;
                    $displayarray['flag']=true;
                    $displayarray['article_id']=$art_id;
                    $displayarray['availability']=true;
                    $displayarray['save_coauthor']=false;
                    $displayarray['remove_user']=false;
                    $displayarray['source']=false;
                    $displayarray['salutation']=true;
                    $displayarray['flag_only']=false;
                    $displayarray['inactive_user']=false;
                    $displayarray['fullname_only']=false;
                    $displayarray['journal_id'] = $jnl_id;
                     $displayarray['linkable'] = true;
                   $coauthor_fullname = $this->get_user_display_name($displayarray);
        }
        }
        if (empty($userresult)) {
            $status     =   'no_user';
            $msg        =   '';
        } else  {
            $user_status    =   $this->fetch_user_status($userresult,$is_search);
            if($user_status['status'] != 'active_user') {
                $status         =   $user_status['status'];
                $msg            =   $user_status['msg'];
            }

        }
        return array('userdata' => $userresult, 'status' => $status, 'msg' => $msg,'retain_author'=>$retain_author,'coauthor_fullname' => $coauthor_fullname);
    }


    public function fetch_user_status($usr_res, $is_search = false){

        $return_arr     =   array('status' => 'no_user', 'msg' => customTrans('articleproposal.no_authors_found'));

        if($usr_res!='') {
            $status         =   'success';
            $msg            =   '';

            if(isset($usr_res->art_decl_status) && $usr_res->art_decl_status == 'yes') {
                $status     =   'declined_user';
                $msg        =   customTrans('articleproposal.user_already_declined');
            }
            else {
                if($is_search === true) {
                    if($usr_res->usr_status == 'a') {
                        $status     =   'active_user';
                        $msg        =   customTrans('articleproposal.user_already_reg'). 'active.';
                    }
                    elseif($usr_res->usr_status == 'n') {
                        $status     =   'inactive_user';
                        $msg        =   customTrans('articleproposal.user_already_reg') . 'inactive.';
                    }
                    elseif($usr_res->usr_status == 's') {
                        $status     =   'suspended_user';
                        $msg        =   customTrans('articleproposal.user_already_reg') . 'suspended.';
                    }
                    elseif($usr_res->usr_status == 'u') {
                        $status     =   'unregistered_user';
                        $msg        =   customTrans('articleproposal.user_already_reg') . 'unregistered.';
                    }
                }
                else {
                    $status     =   'no_user';
                    $msg        =   customTrans('articleproposal.user_already_exists');
                }
            }
            $return_arr     =   array('status' => $status, 'msg' => $msg);
        }
        return $return_arr;
    }



    public function article_save_master_data(Request $request) {
        try {
            $validator = Validator::make($request->all(), [
                'article_type'      => 'required',
                'email_template'    => 'required',
                'is_title_editable' => 'required',
                'art_title'    => 'required',

             ]);
            if ($validator->fails()) {
                return  $this->warning('Warnings',200,$validator->errors(),'warning');
            }

            $result=array();
            $article_id         =   null;
            $this->currentuser = $this->get_current_user_details();
            $form_data = $request->all();
            $article_type_id=$form_data['article_type'];
            $art_title= $form_data['art_title'];
            $submission_duedate=$form_data['submission_due_date'];
            //article id is not empty only in edit
            if(isset($form_data['articleid']) && $form_data['articleid'] != '') {
                $article_id     =   $this->decrypt_data($form_data['articleid']);
            }
            $is_proceeding=$this->check_client_proceeding();
            $article_details    =   Article_type_advance_options::get_all_records('*', "atotp_artp_id='{$article_type_id}'" );
            $art_title = strip_tags($art_title);
            $art_title = str_replace(' ', '', $art_title);
            $art_title = str_replace('&nbsp;', '', $art_title);
            $art_title = trim($art_title);
            $title_length = isset($article_details[0]->atotp_title_length) ? $article_details[0]->atotp_title_length:250;
            if (strlen($art_title) > $title_length) { //checking the article title length
                $arraymsg['message'] = "Maximum characters allowed: {$title_length}";
                $arraymsg['status'] = 'failed';
                return  $this->warning('Warnings', 200, $arraymsg,'warning');
            }
		    $article_jnlid      =   Article_types::get_single_record('artp_jnl_id, artp_fwm_id,artp_prefix_article_no,artp_abbr_article_type,artp_article_type,artp_es_document_type',"artp_id='{$article_type_id}'");
            //validate and insert article basic datas
            $journal_code=$form_data['jnlcode'];
            $jnl_id = Journals::get_single_record('jnl_id', "jnl_journal_code = ? ",null,'',null,[$journal_code])->jnl_id;
            $jnl_date_format = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
            $article_data_list      =   array();
            if (isset($form_data['author_response_due']) && !empty($form_data['author_response_due']) && ($form_data['article_stage_type'] == 'author_submission'  || $article_id == null)) {
                $article_data_list['art_invitation_due'] = $form_data['author_response_due'];
            }
            $article_data_list['art_email_template']  =   $form_data['email_template'];
            $article_data_list['art_ppub_date'] = null;
            if (isset($form_data['target_publication_date']) && !empty($form_data['target_publication_date'])) {
                $article_data_list['art_ppub_date'] = $form_data['target_publication_date'];
            }

            if(isset($form_data['abstract_category'])){
                $article_data_list['art_absc_id']  =   $form_data['abstract_category'];
            }
            if(isset($form_data['proposal_method']) && !empty($form_data['proposal_method']))
            {
                $article_data_list['art_proposal_method'] = $form_data['proposal_method'];
            } elseif (isset($this->current_client->modules->mdl_conference)&&$this->current_client->modules->mdl_conference == 'y') {
                $article_data_list['art_proposal_method'] = 'invite';
            }
            $volume_id  = null;
            if (isset($form_data['publication_volume']) && !empty($form_data['publication_volume']) && is_array($form_data['publication_volume'])) {
                    if (isset($form_data['publication_volume']['__isNew__']) && $form_data['publication_volume']['__isNew__'] === true) {
                        $volume_data['volume_title'] = trim($form_data['publication_volume']['label']);
                        $data = array(
                            'vol_jnl_id'            => $jnl_id,
                            'vol_title'             => $volume_data['volume_title'],
                        );
                        $volume_id = Volumes::insert_record($data,$this->currentuser);
                        $condition='vol_jnl_id='.$jnl_id;
                        $result['volumes']= Volumes::get_all_records('*',$condition);
                    } else {
                        $volume_id  =   $form_data['publication_volume']['value'];
                    }

            }


            $issue_id = null;
            if (isset($form_data['publication_issue']) && !empty($form_data['publication_issue']) && is_array($form_data['publication_issue'])) {
                if (isset($form_data['publication_issue']['__isNew__']) && $form_data['publication_issue']['__isNew__'] === true) {
                        $volume_data['issue_title'] = $form_data['publication_issue']['label'];

                        $min = 1000;
                        $max = 9999;
                        $randum=rand($min, $max);
                        $currentdate=date('Y-m-d H:i:s');
                        $issuearray=array('iss_vol_id'=>$volume_id,
                            'iss_number'=>$randum,
                            'iss_title'=>$volume_data['issue_title'],
                            'iss_description'=>'',
                            'iss_page_limit'=>'100',
                            'iss_due_date'=>$currentdate
                        );
                        $issue_id = Issues::insert_record($issuearray,$this->currentuser);
                    } else {
                        $issue_id = $form_data['publication_issue']['value'];
                    }
            }
            $article_data_list['art_publication_volume']  =   $volume_id;
            $article_data_list['art_publication_issue']  =   $issue_id;

            if (isset($form_data['submission_due_date']) && !empty($form_data['submission_due_date']) && ($form_data['article_stage_type'] == 'author_submission' || $article_id == null)) {
                $dateTime = new \DateTime($form_data['submission_due_date']);
                $date = $dateTime->format('Y-m-d');
                $time = $dateTime->format('H:i:s');
                $submission_duedate = convert_dmy_to_ymd($date,$jnl_date_format);
                $submission_duedate = ($submission_duedate.' '.$time);
            }
            if(isset($form_data['author_first_name']) && isset($form_data['author_email']) && isset($form_data['author_last_name'])) {

                $validator = Validator::make($request->all(), [
                    'author_first_name'      => 'required',
                    'author_email'    => 'required',
                    'author_last_name'    => 'required',

                ]);

                if ($validator->fails()) {
                    return  $this->warning('Warnings',200,$validator->errors(),'warning');
                }

                $on_fly_res     =   $this->add_new_author_on_fly($form_data,$jnl_id);
                if($on_fly_res['status'] == 'success') {
                    $form_data['user_id']    =   $on_fly_res['user_id'];
                } else {
                    $resu['msg']=$on_fly_res['message'];
                    return $this->warning('Warnings',200,$resu,'warning');
                }
            }

            //set array to insert rvw_article
            $article_data_list['art_artp_id']=$article_type_id;
            $article_data_list['art_title']         =   trim($form_data['art_title']);
            $article_data_list['art_title_editable']=   $form_data['is_title_editable'];
            $article_data_list['art_stage_submission_method'] ='b';
            if(isset($form_data['user_id'])) {
                $user_id                                =   $this->decrypt_data($form_data['user_id']);
                $article_data_list['art_submitted_by']  =   $user_id;
            } elseif(isset($form_data['hid_usr_id'])) {
                $user_id                                =   $form_data['hid_usr_id'];
                $article_data_list['art_submitted_by']  =   $user_id;
            }
            $data       =   array();
            if ($article_id === null) {
                //*starting -- create article id*//
                $article_data_list['art_article_upload_path']   = '';
                $article_data_list['art_code'] = $this->create_article_code($article_type_id, $article_jnlid->artp_prefix_article_no);
                //*end -- create article id*//

                // Task #3027 Fetch the articles for article number re-ordering
                if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y'){
                    $article_data_list['art_chapter_order'] = $this->create_article_order($jnl_id);
                }

                //fetch the ordering number for the new article
                // $fetch_total_articles   =   Articles::get_single_record('count(art_id) as cnt', "art_artp_id= ? ",null,'',null,[$article_type_id]);
                // $total_articles         =   $fetch_total_articles->cnt + 1;
                // $article_data_list['art_chapter_order']      =   $total_articles;

               //load doi library
                $article_code =   $article_data_list['art_code'];
                $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                $doi_details  = Config::get($doi);
                $doi_data = $this->create_article_doi($article_id, $doi_details, 'n',$article_code);
                $article_data_list['art_doi']   =   $doi_data['doi'];
                //*End article doi creating
                //insert into rvw_article
                $article_data_list['art_es_document_status'] = 'n';
                if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y' && isset($article_jnlid->artp_es_document_type) && $article_jnlid->artp_es_document_type=='y')
                {
                    $article_data_list['art_es_document_status'] = 'a';
                }
                
                $article_id         =   Articles::insert_record($article_data_list, $this->currentuser);
                //insertion to journal users and article flow table

                //for conf proceedings, a new vble 'submission_method' is defined to save the aflw_status as 'u'
                if($is_proceeding == true) {
                    $form_data['submission_method']    =   'b';
                }
                $new_aflw_id        =   $this->article_move_next_stage($article_id, $form_data, $article_type_id, $article_jnlid, $article_data_list,$submission_duedate);
                //save corr author to article_authors table
                $this->save_corr_author($user_id, $article_id);
                //* start -- update article uploaded files path*//
                $upload_path = $journal_code . '/' . $article_jnlid->artp_abbr_article_type . '/' . $article_id;
                if (!Storage::disk('public')->exists('uploads/'.$upload_path)) {

                    // mkdir('uploads/' . $upload_path, 0777, true);
                    Storage::disk('public')->makeDirectory('uploads/' . $upload_path);
                   // Storage::makeDirectory('uploads/' . $upload_path);
                }
               /* if (!file_exists('uploads/' . $upload_path))
                {
                    // mkdir('uploads/' . $upload_path, 0777, true);
                    Storage::makeDirectory('uploads/' . $upload_path);
                }*/

                Articles::update_record(array(
                    'art_article_upload_path' => $upload_path
                    ), "art_id={$article_id}",$this->currentuser, '', 'e');
                //* end -- update article uploaded files path*//

                if ($issue_id !== null) {
                    // insertion into issue management
                    $issue_management_data = array(
                        'ism_iss_id' => $issue_id,
                        'ism_art_id' => $article_id,
                        'ism_order' => 1
                    );
                    Issue_management::insert_record($issue_management_data, $this->currentuser);
                }
                /** article proposal note  **/
                if(isset($form_data['hd_art_note_prop_chk']) && $form_data['hd_art_note_prop_chk'] == 'y') {
                    $propsl_notes = array(
                        'an_art_id' => $article_id,
                        'an_title' => $form_data['sub'],
                        'an_note' => trim($form_data['prpsl_note_content']),
                        'an_note_by_proposal' => 'y'
                    );

                    if (isset($form_data['propsl_notesto']) && !in_array('-1', $form_data['propsl_notesto']))
                    {
                        $propsl_notes['an_to'] = json_encode(array_values($form_data['propsl_notesto']));
                    }
                    Article_notes::insert_record($propsl_notes, $this->currentuser);
                }
                     /** article proposal note  **/
                $data['journal_code']   = $journal_code;
                $result['action']  = 'save';
                $result['msg']='Draft saved successfully';

            } else { // edit
                $condition = "art_id={$article_id}";
                $an_id = $form_data['note_id'];
                $arry_diff = array();
                $art_updation = false;
                $generate_pdf = null;
                /** start-- article proposal note update **/

                if(isset($form_data['hd_art_note_prop_chk']) ) {

                    $propsl_notes = array(
                        'an_art_id' => $article_id,
                        'an_title' => $form_data['sub'],
                        'an_note' => trim($form_data['prpsl_note_content']),
                        'an_note_by_proposal' => 'y'
                    );

                    $art_dtls = Articles::get_single_record('art_status,art_email_template,art_ppub_date,art_publication_volume,art_publication_issue,art_artp_id,art_title,art_title_editable,art_stage_submission_method,art_submitted_by', $condition);
                    $arry_diff = array_diff($article_data_list,(array)$art_dtls); /* comparing posted record and original record whether to update article table or not */
                    if (isset($form_data['propsl_notesto']) && !in_array('-1', $form_data['propsl_notesto'])) {
                        $propsl_notes['an_to'] = json_encode(array_values($form_data['propsl_notesto']));
                    }
                    if($an_id === null && $form_data['hd_art_note_prop_chk']=='y') {
                        $return_id_note =  Article_notes::insert_record($propsl_notes, $this->currentuser);
                    } elseif($an_id !== null && $form_data['hd_art_note_prop_chk']=='n') {
                        $return_id_note = Article_notes::delete_records("an_id={$an_id}");
                    } else {
                        if($an_id!== null) {
                            $return_id_note =  Article_notes::update_record($propsl_notes,"an_id={$an_id}", $this->currentuser);
                        }
                    }
                }
                            /** end---article proposal note update **/
                //update into rvw_article
                $article_flow_update = array();
                if($art_dtls->art_artp_id != $article_data_list['art_artp_id']) {
                    $article_data_list['art_code'] = $this->create_article_code($article_type_id, $article_jnlid->artp_prefix_article_no);
                    $flow_update_condition="aflw_art_id={$article_id}";
                    $article_type_table = (new \App\Models\Article_types())->getTable();
                    $gneneric_flow_table = (new \App\Models\Generic_flows())->getTable();
                    $sql_condition="artp_id= ? and jwf_stage_type='author_submission'";
                    $sql_stages = 'SELECT jwf_id FROM ' . $article_type_table . ' JOIN ' . $gneneric_flow_table . ' ON artp_fwm_id = jwf_fwm_id WHERE ' . $sql_condition;
                    $stage_data = Article_types::get_records_by_raw_query($sql_stages,false,[$article_type_id]);
                    if(isset($stage_data[0]) && !empty($stage_data[0]->jwf_id))
                    {
                        $article_flow_update['aflw_jwf_id']=$stage_data[0]->jwf_id;
                    }
                    /* if (!file_exists('uploads/' . $upload_path))
                    {
                        // mkdir('uploads/' . $upload_path, 0777, true);
                        Storage::makeDirectory('uploads/' . $upload_path);
                    }*/
                    $upload_path = $journal_code . '/' . $article_jnlid->artp_abbr_article_type . '/' . $article_id;
                    if (!Storage::disk('public')->exists('uploads/'.$upload_path)) {

                        // mkdir('uploads/' . $upload_path, 0777, true);
                        Storage::disk('public')->makeDirectory('uploads/' . $upload_path);
                    // Storage::makeDirectory('uploads/' . $upload_path);
                    }
                    $article_data_list['art_article_upload_path'] = $upload_path;
                }
                if(!empty($arry_diff))
                {
                $proceedingArr  =   $this->fetch_client_proceeding_config_array('article-proposal');
                 $art_operation ='u';
                if($proceedingArr['change_submitting_author'] == true &&  $user_id != $art_dtls->art_submitted_by && $art_dtls->art_status=='y')
                 { 
                  $art_operation= 's';  
                 }
                if(Articles::update_record($article_data_list, $condition, $this->currentuser,NULL,$art_operation)) {
                    if(!empty($article_flow_update))
                    {
                        Article_flow::update_record($article_flow_update, $flow_update_condition, $this->currentuser);
                        $this->save_to_user_journals($article_type_id, $article_jnlid, $article_data_list);
                    }
                    $chap_record =   $this->get_proposals($article_id,$jnl_id);
                    if(count($chap_record) > 0) {
                        $art_flw_data_arr =array();
                        $flow_role = Roles::find($chap_record[0]->jwf_role_id)?->role_assigned_role;
                        
                        if($proceedingArr['change_submitting_author'] == true && $chap_record[0]->art_status == 'y' && $form_data['article_stage_type'] != 'author_submission' && $user_id != $art_dtls->art_submitted_by)
                           {  
                            
                            $get_pdf_status = $this->get_article_pdf_status($article_id,TRUE);
                            if (isset($get_pdf_status['status']) && $get_pdf_status['status'] === true) 
                            {
                            $generate_pdf=[
                                'aflw_id' => $chap_record[0]->aflw_id,
                                'generate_pdf' =>true
                            ];
                            }
                            $usercondition = ['usr_id' => $user_id];
                            $get_user_data = User::get_single_record_with_bind_cond('*',$usercondition);
                            if(!empty($get_user_data) && isset($get_user_data->usr_status) && $get_user_data->usr_status == 'w') {
                            $this->create_user_email($get_user_data, $this->currentuser);
                            }
                              $this->save_to_user_journals($article_type_id, $article_jnlid, $article_data_list);
                                $change_submitted_by = [
                                    'flow_role'   => $flow_role,
                                    'aflw_status' => $chap_record[0]->aflw_status,
                                    'aflw_id' => $chap_record[0]->aflw_id,
                                    'workflo_flow_id' => $chap_record[0]->jwf_id,
                                    'aflw_jwf_id' => $chap_record[0]->aflw_jwf_id,
                                    'new_user_id' => $user_id,
                                    'old_user_id' => $art_dtls->art_submitted_by,
                                    'article_id'  => $article_id,
                                    'jnl_id'      => $article_jnlid->artp_jnl_id,
                                    'art_type_id' =>$article_type_id 
                                ];
                            // Step 1: Delete old submitting author if retain_coauthor = 'n'
                            if (isset($form_data['retain_coauthor']) && $form_data['retain_coauthor'] === 'n') {
                                Authors::delete_records([
                                    'auth_art_id' => $article_id,
                                    'auth_usr_id' => $art_dtls->art_submitted_by,
                                ]);
                            }

                            // Step 2: Check if any corresponding author exists
                            $corr_author_exist_criteria = [
                                "auth_art_id" => $article_id,
                                "auth_corr_author" => "y"
                            ];
                            $corrauthor_exist = Authors::get_single_record_with_bind_cond('auth_id', $corr_author_exist_criteria);

                            // Step 3: Check if new author already exists
                            $new_author_criteria = [
                                "auth_art_id" => $article_id,
                                "auth_usr_id" => $user_id
                            ];
                            $new_author_exist = Authors::get_single_record_with_bind_cond('auth_id', $new_author_criteria);

                            // Step 4: Determine if we need to save author
                            if (empty($new_author_exist->auth_id) || empty($corrauthor_exist)) {
                                // Only save if user is new OR no corr author exists
                                $corres = empty($corrauthor_exist) ? TRUE : FALSE;
                                $operation = empty($new_author_exist->auth_id) ? 'insert' : 'update';
                                $this->save_corr_author($user_id, $article_id, $corres, $operation);
                            }

                                // Step 5: Update Submitted By in article
                                    $this->change_submitted_by_in_article($change_submitted_by);

                           }
                      else{

                        if($form_data['article_stage_type'] == 'author_submission' && $user_id != $chap_record[0]->aflw_usr_id) {
                            //updation to article flow table
                            $art_flw_data_arr   =   array(
                                                    'aflw_usr_id' => $user_id,
                                                    'aflw_status' => 'u',
                                                    'aflw_deeplink_token' => null,
                                                    'aflw_assigned_date' => date('Y-m-d H:i:s'),
                                                    'aflw_accepted_date' => null,
                                                    'aflw_returned_date' => null,
                                                    );
                            //delete all unnecessary notification email templates

                            Article_notification_emails::delete_records("ane_stage_type='author_submission' and ane_art_id={$article_id} and ane_action='assigned'");
                            //insertion to journal_users table
                            $this->save_to_user_journals($article_type_id, $article_jnlid, $article_data_list);

                            //delete and save new corr author to article_authors table                            ;
                            if(Authors::delete_records("auth_art_id={$article_id}"))
                            {
                                $this->save_corr_author($user_id, $article_id);
                            }
                        }
                        if($form_data['article_stage_type'] == 'author_submission' || $article_id == null)
                        {
                        $art_flw_data_arr['aflw_due_date'] =$submission_duedate;
                        }
                        //for conf proceedings in article assignment no need to change article status to 'in-progress'
                        if(isset($form_data['proposal_method']) && $form_data['proposal_method'] == 'assign' && $chap_record[0]->aflw_status == 'u')
                        {
                            $artinvite_due['art_invitation_due'] = null;
                            Articles::update_record($artinvite_due,"art_id={$article_id}",$this->currentuser);
                        }
                        
                        Article_flow::update_record($art_flw_data_arr,"aflw_id={$chap_record[0]->aflw_id} and aflw_art_id={$article_id}",$this->currentuser);
                    }
                    }
                    $data['journal_code']   = $form_data['jnlcode'];
                    // update issue management
                    $issue_management_data = array(
                        'ism_iss_id' => $issue_id
                    );
                    Issue_management::update_record($issue_management_data,"ism_art_id={$article_id}",$this->currentuser);
                    $art_updation = true;
                }
            }
            if(isset($return_id_note) || $art_updation === true)
            {
                $result['action'] ='update';
                $result['msg']='Updated successfully';
                $result['generate_pdf']=$generate_pdf;
            }

            }
             //Task #3457 Basecamp Ticket: Author Ability to Select Section -start
                if (
            isset($article_id) && 
            !empty($article_id) && 
            isset($form_data['classifications']) && 
            !empty($form_data['classifications']) && 
            isset($this->current_client->functionality->cfty_disable_author_classification_edit) && 
            $this->current_client->functionality->cfty_disable_author_classification_edit === 'y'
        ) {
                
            $this->saveClassification($article_id, $form_data['classifications']);
            
        }
        //Task #3457 Basecamp Ticket: Author Ability to Select Section -end
            $this->create_author_menu($article_jnlid->artp_jnl_id,$article_type_id);
            $tabarray = 'clients.' . $this->current_client->clnt_client_code . '.tabconfig';
            $art_submission_tab_arr = Config::get($tabarray);
            $art_submission_tab = array();
            $article_tab_details    =   Article_tab_status::get_all_records_with_bind_cond('tab_status_id',['tab_status_art_id' => $article_id]);
            if (!$article_tab_details || $article_tab_details->isEmpty())
                {
                $art_submission = array();
                foreach ($art_submission_tab_arr as $art_tab_key => $art_tab_val) {

                    if ($art_tab_key == "tab_article_details" || $art_tab_key == "tab_co_author") {
                        //initially it set to p
                        //$art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "c" : "p";
                        $art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "p" : "";

                    } else {
                        $art_submission["$art_tab_key"] = $art_tab_val;
                    }
                }
                $tab_data['tab_status_art_id'] = $article_id;

                if ($article_details[0]->atotp_suggest_reviewers == 'n' && $article_details[0]->atotp_oppose_reviewers == 'n') {
                    unset($art_submission['tab_review_preference']);
                }
                $tab_data["tab_status_array"] = json_encode($art_submission);
                Article_tab_status::insert_record($tab_data, $this->currentuser);
            }
        

            return  $this->success('Success',200,$result);
        } catch (\Exception $e) {
            $this->customErrorAction('manage_proposal',$e);
            return $this->failure('Failed', 500, $e);
        }

    }


    public function add_new_author_on_fly($form_data,$jnl_id) {
        //$article_type_id,$art_id
        $this->currentuser = $this->get_current_user_details();
        $user_id    =   "";
        if ($form_data !== false) {
            $usr_first_name     =   trim($form_data['author_first_name']);
            $usr_middle_name      =   trim($form_data['author_middle_name']);
            $usr_last_name      =   trim($form_data['author_last_name']);
            $usr_email          =   trim($form_data['author_email']);
            $art_id             =   trim($form_data['articleid']);
            //
            $condition          =   'usr_username = "'.$usr_email.'" OR usr_email = "'.$usr_email.'"';
            $user_rslt          =   User::get_single_record('usr_id,usr_email,usr_first_name,usr_middle_name,usr_last_name,usr_status,"no" as art_decl_status', $condition);

            if($user_rslt!='') {
                if($art_id !== null) {
                    $article_record      =   $this->get_proposals($art_id,$jnl_id);
                    $fwm_id             =   $article_record[0]->jwf_fwm_id;
                    $usr_id             =   $user_rslt->usr_id;

                    $user_declined_res  =   Articles::is_user_have_declined_invitation($art_id,$fwm_id,$usr_id);
                    if($user_declined_res!='') {
                        $user_rslt->art_decl_status   =   'yes';
                    }
                }
                $user_status        =   $this->fetch_user_status($user_rslt, false);
                return array('status' => $user_status['status'], 'message' => $user_status['msg']);
            }

            $pass = random_int(10000000, 99999999);
            $token = Str::random(8);
            $user_data  =   array(
                                'usr_title' => '',
                                'usr_username' => $usr_email,
                                'usr_first_name' => $usr_first_name,
                                'usr_middle_name' =>$usr_middle_name,
                                'usr_last_name' => $usr_last_name,
                                'usr_email' => $usr_email,
                                'usr_roles' => null,
                                'usr_f_status' => 'n',
                                'usr_jnl_standalone' => null,
                                'usr_status' => 'w',
                                'usr_deeplink_token' => $token,
                                'usr_pwd' => md5($pass)
                            );

            //inserting
            $user_id = User::insert_record($user_data, $this->currentuser);
            if ($user_id) {
                $newusername=$usr_first_name.$user_id;
                $data_username_new = array('usr_username' =>$newusername);
                $user_condition = "usr_id = {$user_id}";
                User::update_record($data_username_new, $user_condition, $this->currentuser);
                return array('status' => 'success', 'user_id' => $this->encrypt_data($user_id));
            }
        }
        else {
            return array('status' => 'error', 'message' => customTrans('articleproposal.cmn_db_error'));
        }
    }

    public function article_move_next_stage($article_id, $article_data, $article_type_id, $article_jnlid, $article_data_list,$submission_duedate) {
        //insertion to journal_users table
        $this->save_to_user_journals($article_type_id, $article_jnlid, $article_data_list);
        $usr_arr            =   array();
        $usr_arr['user_id'] =   $this->decrypt_data($article_data['user_id']);
        $usr_arr['proxy_user_id']=0;
        //insertion to article_flow table
        $move_next_data_array = array();
        $move_next_data_array['article_id'] = $article_id;
        $move_next_data_array['current_user'] = $usr_arr;
        $move_next_data_array['master_flow_id'] = $article_jnlid->artp_fwm_id;
        $move_next_data_array['current_client'] = $this->current_client;
        $move_next_data_array['bulk_import'] = true;
        $move_next_data_array['proposal_status'] = true;
        $move_next_data_array['submission_duedate'] = $submission_duedate;
        $move_next_data_array['proposal_method'] = $article_data['proposal_method'];

        if(isset($article_data['submission_method']) && $article_data['submission_method'] == 'b') {
            $move_next_data_array['submission_method'] = $article_data['submission_method'];
        }

        $art_flow_arr  =  $this->move_next_stage($move_next_data_array);
        if($art_flow_arr !== null) {
            return $art_flow_arr[0];
        }
    }

    public function save_to_user_journals($article_type_id, $article_jnlid, $article_data_list) {
        $this->currentuser = $this->get_current_user_details();
        $condition          =   'jwf_fwm_id ='.$article_jnlid->artp_fwm_id.' and jwf_stage_type =\'author_submission\'';
        $journal_user_role  =   Generic_flows::get_single_record('jwf_role_id', $condition);
        $assigned_role      =   $journal_user_role->jwf_role_id;
        $art_submitted_by=$article_data_list['art_submitted_by'];
        $art_artp_id=$article_data_list['art_artp_id'];
        $user_artp_arr       =   "usrj_jnl_id = '{$article_jnlid->artp_jnl_id}' and usrj_usr_id = '{$art_submitted_by}' and
        usrj_role_id = '{$assigned_role}' and
        usrj_artp_id = '{$art_artp_id}' ";

        $user_in_artp       =   User_to_journals::get_single_record('count(usrj_id) as cnt', $user_artp_arr);

        if (isset($user_in_artp->cnt) && $user_in_artp->cnt == 0) {
            $user_artp_arr       =   array(
                'usrj_jnl_id' => $article_jnlid->artp_jnl_id,
                'usrj_usr_id' => $article_data_list['art_submitted_by'],
                'usrj_role_id' => $assigned_role,
                'usrj_artp_id' => $article_data_list['art_artp_id'],
            );
            User_to_journals::insert_record($user_artp_arr, $this->currentuser);
        }
    //if the user doesnt have a role in journal level then insert the role
         $user_role_details = [
            'usrj_jnl_id' => $article_jnlid->artp_jnl_id,
            'usrj_usr_id' => $article_data_list['art_submitted_by'],
            'usrj_role_id'=> $assigned_role,
            'usrj_artp_id'=> null,
                    ];

            $jnl_author_record = User_to_journals::get_single_record_with_bind_cond(
                'usrj_id',
                $user_role_details
            );

            if ($jnl_author_record === null) {
                $user_role_details['usrj_invite'] = 'n';
                User_to_journals::insert_record($user_role_details, $this->currentuser);
            }
    }

    public function save_corr_author($user_id, $article_id,$corres=TRUE,$operation ='insert') {
        $this->currentuser = $this->get_current_user_details();
        if ($user_id != "" && $article_id != "") {
            $data = array(
                'auth_usr_id' => $user_id,
                'auth_art_id' => $article_id,
                'auth_corr_author' =>$corres?'y':'n',
                'auth_confirm_status' => 'y'
            );
            if($operation =='update')
            {
            // Update existing author record
            $author_criteria = array("auth_usr_id"=>$user_id,"auth_art_id" => $article_id);
            Authors::update_record($data,$author_criteria,$this->currentuser);
            }else{
            // Insert new author record
            $auth_id = Authors::insert_record($data, $this->currentuser);
           
            if ($auth_id == true) {
				$affiliation_data_arr =     array();
                $user_affliation = User_affiliations::get_all_records('*',"usaff_user_id={$user_id}");
				if ($user_affliation!='') {
					$this->copy_user_affliation_to_author($affiliation_data_arr, $user_affliation, $auth_id);
                }
            }
        }
        }
    }


    public function copy_user_affliation_to_author($affiliation_data_arr, $user_affliation, $auth_id, $prime_aff_status = 'n') {
        $this->currentuser = $this->get_current_user_details();
		foreach ($user_affliation as $us_value) {
			$usraff_row = array(
				'auaff_auth_id' => $auth_id,
				'auaff_email' => $us_value->usaff_email,
				'auaff_department' => $us_value->usaff_department,
				'auaff_company' => $us_value->usaff_company,
				'auaff_ringgold_id' => $us_value->usaff_ringgold_id,
				'auaff_ringgold_family' => $us_value->usaff_ringgold_family,
				'auaff_address_line1' => $us_value->usaff_address_line1,
				'auaff_address_line2' => $us_value->usaff_address_line2,
				'auaff_cnt_id' => $us_value->usaff_cnt_id,
                'auaff_state' => $us_value->usaff_state,
				'auaff_postal_code' => $us_value->usaff_postal_code,
				'auaff_phone' => $us_value->usaff_phone,
				'auaff_posted_by' => $this->currentuser['user_id'],
				'auaff_posted_date' => date('Y-m-d H:i:s'),
                'auaff_prime_affiliation' => ($prime_aff_status == 'n') ? $us_value->usaff_prime_affiliation : 'n'
            );
			array_push($affiliation_data_arr, $usraff_row);
        }
		Authors_affiliation::insert_batch($affiliation_data_arr);
    }


public function edit_articles(Request $request) {
    try {
        $result=array();
        $dec_html='';
        $declined_cnt   =0;
        $form_data = $request->all();
        $art_id=$this->decrypt_data($form_data['articleid']);
        $article_type_id=$this->decrypt_data($form_data['articletype']);
        $journal_code=$form_data['jnlcode'];
        $jnl_id = Journals::get_single_record('jnl_id', "jnl_journal_code = '{$journal_code}' ")->jnl_id;
        $article_record =  $this->get_proposals($art_id,$jnl_id);
        $result['article_record']=$article_record[0];
        $decision_stage_type = null;
        $result['has_decision_stage_flag']= false;
        $articleClassificationSet = null;
        if (isset($article_record[0]->aflw_jwf_id)) {
            $decision_stage_type = Generic_flows::get_single_record_with_bind_cond(
                'jwf_stage_type',
                ['jwf_id' => $article_record[0]->aflw_jwf_id]
            );
        }
        
        $array_decision_stages = ['accept', 'reject', 'decision_revision'];
            if (
            !empty($decision_stage_type) &&
            isset($decision_stage_type->jwf_stage_type) &&
            in_array(strtolower($decision_stage_type->jwf_stage_type), $array_decision_stages)
        ) {
            $result['has_decision_stage_flag'] = true;
        }
        $jnl_date_format = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
        $jnl_date_format = $this->date_format_map($jnl_date_format);
        $emailtmp_id = isset($form_data['emailtempid'])? $this->decrypt_data($form_data['emailtempid']) : '';
        if(count($article_record) > 0) {
            $result['user_html']   = 	$this->fetch_search_users_result_view($article_record[0]->usr_email);

            $fwm_id             =   $article_record[0]->jwf_fwm_id;
            $fetch_declined     =   Articles::get_invitation_data($art_id,$fwm_id,$jnl_date_format,'d');
            if(count($fetch_declined) > 0) {
                $declined_cnt   =   count($fetch_declined);
                $dec_html       .=  '<div class="table-responsive"><table class="table table-striped table-bordered"><tbody>';
                foreach($fetch_declined as $val) {
                    $dec_html   .=  '<tr><td style="font-size:12px;"><strong>'.$val->invited_username.'</strong><span class="text-muted"> (<i>'.$val->usr_email.'<i>)</span></td></tr>';
                }
                $dec_html       .=  '</tbody></table></div>';
                $result['declined_cnt'] = $declined_cnt;
                $result['dec_html'] = $dec_html;
            }
            /** article proposal note **/
            $nots_to_rls = array();
            $result['notes_to'] =$notes_to= User_to_journals::get_all_roles("usrj_artp_id='{$article_type_id}' " , FALSE, 'a');
            $prpsl_note_cond    = " an_art_id={$art_id} and an_note_by_proposal='y' ";
            $result['art_prpsl_note']   =   Article_notes::get_single_record('an_id,an_title,an_to,an_note', $prpsl_note_cond);


            if(!empty($notes_to)) {
                foreach ($notes_to as $role) {
                    if (($role->role_assigned_role == 'journal_admin') || ($role->role_assigned_role == 'staff')) {
                        array_push($nots_to_rls,"".$role->role_id."");
                    }
                }
            }

            $result['default_noteto'] =json_encode($nots_to_rls);

            $getforms = Article_types::get_form_onstage('author_submission', $article_type_id);
            if(!empty($getforms)) {
                $jwf_id =$getforms[0]->jwf_id;
                $condition ='setr_jwf_id='.$jwf_id.' and stage_etmp_action=\'assigned\'';
                if(isset($emailtmp_id) && $emailtmp_id !='')
                {
                    $condition .= ' and stage_etmp_id='.$emailtmp_id;
                }
                $result['emailtemplate'] = Stage_email_templates::get_stage_email_tmpl_to_trigger('*', $condition);
            }
            $condition                      =   'vol_jnl_id='.$jnl_id;
            $result['volumes']  =   Volumes::get_all_records('*',$condition);

            if(!empty($result['article_record']->vol_id)) {
                $condition ='iss_vol_id='.$result['article_record']->vol_id . ' and iss_status !=\'c\'';
                $result['issues'] = Issues::get_all_records('*', $condition);
            }

            if($result['article_record']->art_status =='n'&& ($result['article_record']->aflw_status=='u' || $result['article_record']->aflw_status=='i')){
                $val_artp_conditiion = "artp_jnl_id = ? and artp_article_submission_status='y' " ;
                $bind_arr[]=  $jnl_id;
            } else {
                $val_artp_conditiion = "artp_jnl_id = ? and artp_article_submission_status='y' and artp_id= ? " ;
                $bind_arr[]=  $jnl_id;
                $bind_arr[]=  $article_type_id;
            }

            $all_article_types =  Article_types::get_all_valid_articletype('artp_fwm_id,artp_id,artp_article_type', $val_artp_conditiion,$bind_arr);
            if (count($all_article_types) > 0)
            {
                $main_array=array();
                foreach ($all_article_types as $article_type)
                {
                    $fwm_id = $article_type->artp_fwm_id;
                    if($this->current_client->modules->mdl_review_for_doc =='n')
                    {
                        $proper_flow = $this->validate_journal($fwm_id, $article_type->artp_id, 'a');

                        if ($proper_flow['status'] === false)
                        {
                            continue;
                        }
                        else{
                             $main_array[]=$article_type;

                        }
                    }
                }
               // print_r($main_array); die;
                //if ($i == 0)
                $result['all_article_types'] = json_decode(json_encode($main_array), FALSE);
            }
            else{
                $result['all_article_types'] =$all_article_types;
            }
           $condition = array("arcls_art_id"=>$art_id);
           $checkBoxData = Article_classification::get_single_record_with_bind_cond('GROUP_CONCAT(arcls_cls_id) as checkData',$condition);   
                if(!empty($checkBoxData->checkData)){
                    $articleClassificationSet = json_decode(json_encode(explode(',', $checkBoxData->checkData)));
                    
                }
            //get all clasificaciones
            $term_table = (new \App\Models\Terms())->getTable();
            $classification_table = (new \App\Models\Classifications())->getTable();
             $Classification           = new \App\Models\Classifications();
            $cls_criteria = "cls_artp_id='{$article_type_id}'";
            $select = '*';
            $tables = array(
                'main_table' => $term_table,
                'join_table' => array(
                    $classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
                )
            );
            $classification_details = $Classification::get_results_using_joins($tables, $select, $cls_criteria, '');
            $res = [];
            if (count($classification_details) > 0) {
                foreach ($classification_details as $e) {
                    $this->convertToArr($res, $e);
                }
            }
            // print_r($res);die;
           $condition = array("cls_jnl_id"=>$jnl_id);
            $parent_keys =  $Classification::get_single_record_with_bind_cond(' GROUP_CONCAT(DISTINCT cls_primary_id) as parent_keys',$condition);
            $return['parentSet'] = (!empty($parent_keys->parent_keys)) ? Rv_encrypt($parent_keys->parent_keys) : '';
			$classification_treedata=json_decode(json_encode($res));
            $return['classification_treedata'] = $classification_treedata;
            $result['articleClassification'] = $articleClassificationSet;
            if(isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference){
                $result['all_abstract_categories'] = Abstract_category::get_abstract_categories();
            }
            $result['title_length'] =   Article_type_advance_options::get_single_record('atotp_title_length','atotp_artp_id = ?',binding_arr:[$article_type_id])->atotp_title_length; 

            //fetch the client's proceeding config array
            $result['proceedingArr']  =   $this->fetch_client_proceeding_config_array('article-proposal');
    }


        return $this->success('success', 200, $result);
    } catch (\Exception $e) {
        $this->customErrorAction('edit_articles',$e);

        return $this->failure('Failed', 500, $e);
    }
}


public function get_issues_volume(Request $request) {
    try {
        $result=array('issues'=>'');
        $post_data = $request->all();
        $validator = Validator::make($request->all(), [
            'publication_volume'      => 'required',
           ]);
        if ($validator->fails()) {
            return  $this->warning('Warnings',200,$validator->errors(),'warning');
        }
        $volumes=$post_data['publication_volume'];

        if($volumes!='') {
            $condition ='iss_vol_id='.$volumes . ' and iss_status !=\'c\'';
            $result['issues'] = Issues::get_all_records('*', $condition);
        }

        return $this->success('success', 200, $result);
    } catch (\Exception $e) {
        $this->customErrorAction('get_issues_volume',$e);

        return $this->failure('Failed', 500, $e);
    }
}

public function delete_selected_article(Request $request) {
    try {
        DB::beginTransaction();
        $article_ids_arr=array();
        $post_data = $request->all();
        $article_ids    = $post_data['articleid'];
        $this->currentuser = $this->get_current_user_details();
        $multiple_delte =(isset($post_data['multiple'])?$post_data['multiple']:'');
        $es_article = false;
        if($multiple_delte ===  true){
        array_push($article_ids_arr,$article_ids);
        }
        else{
        $article_ids_arr = explode(',',$article_ids);
        }
		$today = date('Y-m-d H:i:s');
        foreach($article_ids_arr as $article_id) {
            $article_id = $this->decrypt_data($article_id);
            //check article ID exist or not
            $check_article = Articles::get_single_record('art_id',"art_id={$article_id}");
            if(!empty($check_article)) {
                //update the article status to 'd'
                Articles::update_record(array('art_delete_status' => 'y', 'art_deleted_by' => $this->currentuser['user_id'], 'art_deleted_date' => $today),"art_id={$article_id}");
                $esarray['article_id']=$article_id;
                $checkdata=$this->check_espermission_access($esarray);
                if($checkdata==true)
                {                 
                    $es_article = true;
                    $aflw_ids = Article_flow::get_single_record_with_bind_cond('GROUP_CONCAT(aflw_id) as aflw_id_list ', array('aflw_art_id' => $article_id));
                    $msg_arr['redirect_flows'] = $aflw_ids->aflw_id_list;
                    $msg_arr['redirect_msg'] = 'Proposal has been deleted.';
                }
            }
        }
        DB::commit();
        $msg_arr['message']=customTrans('articleproposal.art_delete_success');
        $msg_arr['es_article'] = $es_article;
        return $this->success('success',201,$msg_arr);

    } catch (\Exception $e) {
        DB::rollback();
        $this->customErrorAction('delete_selected_article',$e);
        return $this->failure('Failed', 500, $e);
    }
}

public function author_invitation_history(Request $request) {
    try {
        $invitation_history     =   array();
        $art_pre_all_ids        =   array();
        $result        =   array();
        $post_data = $request->all();
        $art_id    = $this->decrypt_data($post_data['art_id']);
        $fwm_id    = $this->decrypt_data($post_data['jwf_fwm_id']);
        $jnl_id    = $this->decrypt_data($post_data['jnl_id']);
        $jnl_date_format = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$jnl_id}' ")->jset_date_format;
        $jnl_date_format = $this->date_format_map($jnl_date_format);
        $invitation_history[$art_id]['art_data']      =   Articles::get_single_record('art_id, art_code, art_version_no,art_proposal_method',"art_id={$art_id}");
        $invitation_history[$art_id]['invit_data']    =   Articles::get_invitation_data($art_id,$fwm_id,$jnl_date_format,NULL,$invite_history = TRUE);
        $invitation_history[$art_id]['version']    = customTrans('articleproposal.current_version_text');
        if($art_id != '') {
            $pre_all_data       =   Articles::get_single_record('art_pre_all_ids',"art_id={$art_id}");
            if(isset($pre_all_data->art_pre_all_ids) && $pre_all_data->art_pre_all_ids != '') {
                $art_pre_all_ids    =   explode(',', $pre_all_data->art_pre_all_ids);
            }
        }
        if(count($art_pre_all_ids) > 0) {
            rsort($art_pre_all_ids);
            foreach($art_pre_all_ids as $val) {
                $art_data       =   Articles::get_single_record_with_bind_cond('art_id, art_code, art_version_no,art_proposal_method',array('art_id'=>$val));
                if($art_data->art_id != '') {
                    $invitation_history[$val]['art_data']       =   $art_data;
                    $invitation_history[$val]['invit_data']     =   Articles::get_invitation_data($val,$fwm_id,$jnl_date_format,null,$invite_history = true);
                    $invitation_history[$val]['version']    =customTrans('articleproposal.previous_version_text').' '. $art_data->art_version_no;;
                }
            }
        }
        $result['invitation_history']     =   $invitation_history;
        return $this->success('success',201,$result);
    } catch (\Exception $e) {
        $this->customErrorAction('author_invitation_history',$e);

        return $this->failure('Failed', 500, $e);
    }
}

public function check_active_user_permission($article_type_id,$field,$jnl_code) {
    $active_role_id         =   '';
    $manage_article_type    =   array();
    $this->currentuser = $this->get_current_user_details();
    if(isset($this->currentuser['jnl_user_role'][$jnl_code])) {
        $temp_role      = $this->currentuser['jnl_user_role'][$jnl_code];
        $active_role_id = $temp_role['role_id'];
    }
    $permission_roles = Article_type_advance_options::get_single_record($field,"atotp_artp_id={$article_type_id}");
    if($permission_roles->atotp_edit_articles !== null) {
        $manage_article_type    = json_decode($permission_roles->atotp_edit_articles);
    }
    $view_permission = false;
    if(in_array($active_role_id, $manage_article_type)) {
        $view_permission = true;
    }
    return $view_permission;
}


public function save_email_preview(Request $request) {
    try {
		$post_data = $request->all();
        $validator = Validator::make($request->all(), [
			'artp_id' => 'required',
			'art_id' => 'required',
			'aflw_id' => 'required',
		]);

        if($validator->fails())
        {
                return  $this->failure('Failed',422,$validator->errors());
        }
        $flowidarray = array('input'=>$post_data['aflw_id'],'type'=>'number', 'enc_data'=>true );
        $articletypeidarray = array('input'=>$post_data['artp_id'],'type'=>'number', 'enc_data'=>true );
            $articleidarray = array('input'=>$post_data['art_id'],'type'=>'number', 'enc_data'=>true );
            $flowidvalidation= $this->Rv_validator($flowidarray);
            $articleidvalidation= $this->Rv_validator($articleidarray);
            $articletypevalidation= $this->Rv_validator($articletypeidarray);


        if($flowidvalidation !== true || $articleidvalidation !== true || $articletypevalidation !== true ){
            return $this->warning('Failed',422,customTrans('viewarticle.invalid_data'));
        }
        $this->currentuser = $this->get_current_user_details();
        $art_id     = $this->decrypt_data($post_data['art_id']);
        $aflw_id    = $this->decrypt_data($post_data['aflw_id']);
        $invite_tmpl_name    = $post_data['postdata']['stage_name'];
        $stage_name    ='';
        if(isset($invite_tmpl_name))
        {
            foreach ($invite_tmpl_name as $invite_tmpl_name)
            {
                if($invite_tmpl_name['value']==$post_data['postdata']['invite_tmpl_name'])
                {
                    $stage_name    = $invite_tmpl_name['label'];
                }
            }
        }
        $stage_etmp_id = ($post_data['stage_etmp_id'] != "") ? $this->decrypt_data($post_data['stage_etmp_id']) : "";
        $stage_etmp_cc = $stage_etmp_bcc = $stage_etmp_cust_cc = $stage_etmp_cust_bcc = '';



        if (!empty($post_data['postdata']['stage_template_to_cc'])) {
            $stage_etmp_cc = json_encode($post_data['postdata']['stage_template_to_cc']);
            $optccvalue = array();
            if (isset($post_data['postdata']['stage_cust_cc'])) {
                $custm_cc = $post_data['postdata']['stage_cust_cc'];
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                    array_push($optccvalue, $cust_value);


                }
                $stage_etmp_cust_cc = implode(',', $optccvalue);

            }
            else{
                $stage_etmp_cust_cc='';
            }

        }
        if (!empty($post_data['postdata']['stage_template_to_bcc'])) {
            $stage_etmp_bcc = json_encode($post_data['postdata']['stage_template_to_bcc']);

            $optbccvalue = array();
            if (isset($post_data['postdata']['stage_cust_bcc'])) {
                $custm_bcc = $post_data['postdata']['stage_cust_bcc'];
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                    array_push($optbccvalue, $cust_bcc_value);

                }
                $stage_etmp_cust_bcc = implode(',', $optbccvalue);
            }
            else{
                $stage_etmp_cust_bcc='';
            }

        }

        $replace_button = array('<button contenteditable="false">', '</button>');
        $post_data['postdata']['stage_template_content'] = str_replace($replace_button, '##', $post_data['postdata']['stage_template_content']);

        $article_notification = Article_notification_emails::get_single_record('ane_id'," ane_stage_etmp_id='{$stage_etmp_id}' and
        ane_art_id='{$art_id}' and ane_aflw_id='{$aflw_id}' ");

        if(!empty($article_notification))
        {
            $formdata = array(
                'ane_subject' => $post_data['postdata']['stage_template_sub'],
                'ane_content' => $post_data['postdata']['stage_template_content'],
                'ane_cc' => $stage_etmp_cc,
                'ane_bcc' => $stage_etmp_bcc,
                'ane_cust_cc' => $stage_etmp_cust_cc,
                'ane_cust_bcc' => $stage_etmp_cust_bcc,
                'ane_reply_to' => $post_data['postdata']['stage_template_to_mail']
            );
            $status = Article_notification_emails::update_record($formdata,"ane_id='{$article_notification->ane_id}'",$this->currentuser);

            if ($status)
            {
                $return_arr['status'] = 'success';
                $return_arr['art_id'] = $this->encrypt_data($art_id);
                $return_arr['stage_name'] = $stage_name;
                $return_arr['stage_etmp_id'] = $this->encrypt_data($stage_etmp_id);
                $return_arr['msg'] = customTrans('email_template.email_tmpl_updated');
            }
            
        }
        else
        {
            $stage_email = Stage_email_templates::get_single_record('stage_etmp_to,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_cust_to',
            "stage_etmp_id='{$stage_etmp_id}'");
                $formdata = array(
                    'ane_stage_etmp_id' => $stage_etmp_id,
                    'ane_art_id' => $art_id,
                    'ane_stage_type' => $stage_email->stage_etmp_stage_type,
                    'ane_aflw_id' => $aflw_id,
                    'ane_action' => $stage_email->stage_etmp_action,
                    'ane_to' => $stage_email->stage_etmp_to,
                    'ane_subject' => $post_data['postdata']['stage_template_sub'],
                    'ane_content' => $post_data['postdata']['stage_template_content'],
                    'ane_template_name' => $stage_email->stage_etmp_name,
                    'ane_cc' => $stage_etmp_cc,
                    'ane_bcc' => $stage_etmp_bcc,
                    'ane_cust_to' => $stage_email->stage_etmp_cust_to,
                    'ane_cust_cc' => $stage_etmp_cust_cc,
                    'ane_cust_bcc' => $stage_etmp_cust_bcc,
                    'ane_reply_to' => $post_data['postdata']['stage_template_to_mail']
                );

			$status = Article_notification_emails::insert_record($formdata, $this->currentuser);

            if ($status)
			{
				$return_arr['status'] = 'success';
                $return_arr['art_id'] = encrypt_link($art_id);
                $return_arr['stage_name'] = $stage_name;
				$return_arr['stage_etmp_id'] = encrypt_link($stage_etmp_id);
				$return_arr['msg'] = customTrans('email_template.email_tmpl_added');
			}
			
        }
        Articles::update_record(array('art_email_template' => $stage_etmp_id),"art_id='{$art_id}'", $this->currentuser);

		return $this->success('success',201,$return_arr);

    } catch (\Exception $e) {
        $this->customErrorAction('author_invitation_history',$e);
        return $this->failure('Failed', 500, $e);
    }

    }


    public function send_author_invitation(Request $request) {
        try {
        $post_data = $request->all();
		$article_set = $post_data['article_set'];
        $type = isset($post_data['type']) ? $post_data['type'] : '';
		$return_data['status'] = 'failed';
		$return_data['msg'] = 'invalid access';
        $jnl_id=$this->decrypt_data($post_data['jnl_id']);
        $jnl_code=$post_data['jnl_code'];
        $core_role=$post_data['core_role'];
        $this->currentuser = $this->get_current_user_details();
        $optccvalue = array();
        if (isset($post_data['postdata']['stage_cust_cc'])) {
            $custm_cc = $post_data['postdata']['stage_cust_cc'];
            for ($i = 0; $i < count($custm_cc); $i++) {
                $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                $cust_value = str_replace('\\', '"', $cust_value);
                $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                array_push($optccvalue, $cust_value);


            }
            $post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);

        }
        else{
            $post_data['postdata']['stage_cust_cc']='';
        }
        $optbccvalue = array();
        if (isset($post_data['postdata']['stage_cust_bcc'])) {
            $custm_bcc = $post_data['postdata']['stage_cust_bcc'];
            for ($i = 0; $i < count($custm_bcc); $i++) {
                $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

                array_push($optbccvalue, $cust_bcc_value);

            }
            $post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
        }
        else{
            $post_data['postdata']['stage_cust_bcc']='';
        }
        $invitation_send = false;
        $invitation_send_fail = false;
        $current_stage_ids = array();

        $date_format = $this->get_platform_date_format($jnl_id);
        $date_format= date_format_map($date_format);
        $art_codes = array();
        foreach ($article_set as $article) {
            $expired_status = $article['expired_status'];
            if($expired_status == 'y') {
                $art_id = $this->decrypt_data($article['art_id']);
                $article_code = Articles::get_single_record('art_code', "art_id='{$art_id}'");
                $art_code[] =$article_code->art_code;
                $art_codes = implode(', ',$art_code);
            }
        }

        if($art_codes == null) {

        foreach ($article_set as $article) {
            $art_id = $this->decrypt_data($article['art_id']);
            $current_stage_id = $this->decrypt_data($article['aflw_id']);
            $user_id = $this->decrypt_data($article['user_id']);
            $stage_etmp_id = $this->decrypt_data($article['stage_etmp_id']);

            $aflw_deeplink_token = Str::random(16);
            $condition =  array("aflw_usr_id"=>$user_id,
                                "aflw_id" => $current_stage_id );
			$current_aflw_id_rec = Article_flow::get_single_record_with_bind_cond('aflw_id,aflw_deeplink_token,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as aflw_due_date', $condition);

            if(!empty($current_aflw_id_rec))
            {
            $aflw_deeplink_token = ($current_aflw_id_rec->aflw_deeplink_token != '' ) ? $current_aflw_id_rec->aflw_deeplink_token : $aflw_deeplink_token;

            $current_aflw_id = $current_aflw_id_rec->aflw_id;
            $data['aflw_status'] = 'i';
            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jnl_journal_type, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles,art_proposal_method';
			$article_details = Articles::get_article_details($select,"aflw_id='{$current_aflw_id}'");

            $article_details = $article_details[0];
            $article_id = $article_details->art_id;
            $template = null;
            $attachments = $files_attached = array();
            if (isset($stage_etmp_id) && $stage_etmp_id !== null) {
                $template_condition = array(
                        'stage_etmp_id' => $stage_etmp_id,
                        'stage_etmp_action' => "assigned"
                );
				$template = Stage_email_templates::get_single_record_with_bind_cond('*, stage_etmp_content AS stage_etmp_email_template',$template_condition);
                $article_notification_condition = array(
                    'ane_stage_etmp_id' => $stage_etmp_id,
                    'ane_art_id' => $article_id,
                    'ane_aflw_id' => $current_stage_id
                );
                $article_notification = Article_notification_emails::get_single_record_with_bind_cond('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',$article_notification_condition);
                $cc_list = [];
                $bcc_list = [];
                if (!empty($article_notification)) {
                               
                $template->stage_etmp_subject   = $article_notification->ane_subject;
                $template->stage_etmp_content   = $article_notification->ane_content;
                $template->stage_etmp_cust_cc   = $article_notification->ane_cust_cc;
                $template->stage_etmp_cust_bcc  = $article_notification->ane_cust_bcc;
                if (!empty($article_notification->ane_cc)) {
                $cc_list  = json_decode($article_notification->ane_cc, true);
                $cc_list  = is_array($cc_list) ? $cc_list : [];
                 }
                 if (!empty($article_notification->ane_bcc)) {
                $bcc_list  = json_decode($article_notification->ane_bcc, true);
                $bcc_list  = is_array($bcc_list) ? $bcc_list : [];
                 }

                } else {
                               
                    $cc_list=$post_data['postdata']['stage_template_to_cc']??[];
                    $bcc_list= $post_data['postdata']['stage_template_to_bcc']??[] ;
                    $template->stage_etmp_cust_cc= $post_data['postdata']['stage_cust_cc']??[];
                    $template->stage_etmp_cust_bcc=$post_data['postdata']['stage_cust_bcc']?? [];

                
                }
                $post_data['postdata']['stage_cust_cc']  = $template->stage_etmp_cust_cc ?? [];
                $post_data['postdata']['stage_cust_bcc'] = $template->stage_etmp_cust_bcc ?? [];
                $post_data['postdata']['stage_template_to_cc']  = $cc_list;
                $post_data['postdata']['stage_template_to_bcc'] = $bcc_list;
                if(!empty($article_notification)) {
                    $email_attachments	=	$this->get_invite_email_attachments($article_id,$article_notification->ane_id,false);
                    if(!empty($email_attachments)) {
                        $attachments = $email_attachments['attachments'];
                        $files_attached = $email_attachments['files_attached'];
                    }
                }
			}

            if ($template !== null) {
                $today = date('Y-m-d H:i:s', time());
                $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                $data['aflw_decline_clk_count'] = 0;
				$data['aflw_accept_clk_count'] = 0;
                $data['aflw_assigned_date'] = $today;
                $update_status_condition = array(
                    'aflw_usr_id' => $user_id,
                    'aflw_id' => $current_stage_id
                );
                Article_flow::update_record($data,$update_status_condition,$this->currentuser);

                //if the author doesnt have a role in journal level then insert the role
                $author_role_id = $article_details->jwf_role_id;
                $user_role_details = array(
                    'usrj_jnl_id' => $jnl_id,
                    'usrj_usr_id' => $user_id,
                    'usrj_role_id' => $author_role_id,
                    'usrj_artp_id' => null
                );
                $jnl_author_record = User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details);
                if ($jnl_author_record === null)
                {
                    $user_role_details = array(
                        'usrj_jnl_id' => $jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $author_role_id,
                        'usrj_artp_id' => null,
                        'usrj_invite' => 'n',
                    );
                    User_to_journals::insert_record($user_role_details, $this->currentuser);
                }
                $artp_user_role_details = array(
                    'usrj_jnl_id' => $jnl_id,
                    'usrj_usr_id' => $user_id,
                    'usrj_role_id' => $author_role_id,
                    'usrj_artp_id' => $article_details->art_artp_id
                );
                $artyp_author_record = User_to_journals::get_single_record_with_bind_cond('usrj_id', $artp_user_role_details);
                if ($artyp_author_record === null)
                {
                    $artp_user_role_details = array(
                        'usrj_jnl_id' => $jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $author_role_id,
                        'usrj_artp_id' => $article_details->art_artp_id,
                        'usrj_invite' => 'n',
                    );
                    User_to_journals::insert_record($artp_user_role_details,$this->currentuser);
                }

                $author_role = Roles::get_single_record('role_id', 'role_assigned_role = "author" and FIND_IN_SET("r", role_used_in)');
                $role_id = $author_role->role_id;
                $custom_data=array(
                    'link'=> URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code . '/confirm-and-accept?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&user_role_id=' . $role_id . '&article_flow_id=' . $article_details->aflw_id.'&bulksubmission=true'),
                    'accept_link'=>URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code  . '/accept-reject-submittion' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=accept' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id.'&bulksubmission=true'),
                    'reject_link'=>URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_code  . '/accept-reject-submittion' . '?' . encrypt_link('&key=' . $aflw_deeplink_token . '&userid=' . $user_id . '&btn=reject' . '&article_id=' . $article_id . '&status_id=' . $article_details->aflw_id . '&show_user_terms_condition_modal=hide&bulksubmission=true'),
                    'email_id'=>'proposal',
                    'article_id'=>$article_id,
                    'artp_id'=>$article_details->art_artp_id,
                    'jnl_id'=>$jnl_id,
                    'jnl_code'=>$jnl_code,
                    'aflw_id'=> $article_details->aflw_id,
                );
                if(isset($attachments)){
                    $post_data['postdata']['attachments'] = $attachments;
                    $post_data['postdata']['files_attached'] = $files_attached;
                }
                if($type !='' && $type == 'multiinvite')
                {
                    $post_data['postdata']['stage_template_sub'] =$template->stage_etmp_subject ;
                    $post_data['postdata']['stage_template_content'] =$template->stage_etmp_content;
                }
                
                $replace_button = array('<button contenteditable="false">', '</button>');
                $post_data['postdata']['stage_template_content'] = str_replace($replace_button, '##', $post_data['postdata']['stage_template_content']);
                
                $email_data=array(
                    'type'=>'custom',
                    'action'=>'send',
                    'email_with_login'=>true,
                    'article_id'=>$article_id,
                    'user_id'=> $user_id,
                    'aflw_id'=> $article_details->aflw_id,
                    'post_data'=>$post_data,
                    'aflw_deeplink_token'=>$aflw_deeplink_token,
                    'role_id'=>$role_id,
                    'template'=> $template,
                    'jnl_id'=> $jnl_id,
                    'custom_data'=>$custom_data,
                    'jnl_user_role'=>array(
                        'core_role'=>$core_role,
                        // 'role_name'=>$jnl_array['role_name'],
                        'jnl_id'=> $jnl_id,
                        'jnl_journal_code'=> $jnl_code
                    ),
                );
                $this->master_email_details($email_data);
                $invitation_send = true;
                $current_stage_ids[] = $current_stage_id;
                $submittion_date[encrypt_link($article_id)] = $current_aflw_id_rec->aflw_due_date;

                //delete all unnecessary notification email templates
                Article_notification_emails::delete_records("ane_stage_etmp_id!={$stage_etmp_id} and ane_art_id={$article_id} and ane_aflw_id={$current_stage_id} ");
            }
        }
        else
        {
            $invitation_send_fail = true;
        }
        }
        if($invitation_send_fail === true)
        {
            $return_data['status'] = 'invitation_error';
            $return_data['msg'] = 'Shorlist user details not exists';
            return  $this->success('Success', 201, $return_data);
        }
        $invited_usrs = Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt ', "aflw_id IN (" . implode(',',$current_stage_ids) . ") AND aflw_status = 'u'");
        $return_data['invite_complete'] = false;
        if ($invited_usrs->cnt == 0)
        {
            $return_data['invite_complete'] = true;
        }
            if ($invitation_send === true) {
                $return_data['msg'] = 'User invited successfully';
                $return_data['status'] = 'success';
            } else {
			    $return_data['status'] = 'tmpl_err';
                $return_data['msg'] ='You have not defined any email templates';
		    }
    } else {
        $return_data['status'] = 'invitation_error';
        $return_data['msg'] = customTrans('Invitation due date has expired for the following :articles <br>').$art_codes;
    }
    return  $this->success('Success', 201, $return_data);

    } catch (\Exception $e) {
        $this->customErrorAction('author_invitation_history',$e);
        return $this->failure('Failed', 500, $e);
    }

    }

    public function send_author_uninvitation(Request $request) {
        try {
        $post_data = $request->all();
		$article_set = $post_data['article_set'];
		$return_data['status'] = 'failed';
		$return_data['msg'] = 'invalid access';
        $jnl_id=$this->decrypt_data($post_data['jnl_id']);
        $jnl_code=$post_data['jnl_code'];
        $core_role=$post_data['core_role'];
        $this->currentuser = $this->get_current_user_details();

        $optccvalue = array();
				if (isset($post_data['postdata']['stage_cust_cc'])) {
					$custm_cc = $post_data['postdata']['stage_cust_cc'];
					for ($i = 0; $i < count($custm_cc); $i++) {
						$cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
						$cust_value = str_replace('\\', '"', $cust_value);
						$cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

						array_push($optccvalue, $cust_value);


					}
					$post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);

				}
				else{
					$post_data['postdata']['stage_cust_cc']='';
				}
				$optbccvalue = array();
				if (isset($post_data['postdata']['stage_cust_bcc'])) {
					$custm_bcc = $post_data['postdata']['stage_cust_bcc'];
					for ($i = 0; $i < count($custm_bcc); $i++) {
						$cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
						$cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
						$cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

						array_push($optbccvalue, $cust_bcc_value);

					}
					$post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
				}
				else{
					$post_data['postdata']['stage_cust_bcc']='';
				}

        $current_stage_ids = array();

        $date_format = $this->get_platform_date_format($jnl_id);
        $date_format= date_format_map($date_format);


		foreach ($article_set as $article) {
            $template = null;
			$current_stage_id = $this->decrypt_data($article['aflw_id']);
            $user_id = $this->decrypt_data($article['user_id']);

			if (isset($post_data['invite_tmpl_name']) && $post_data['invite_tmpl_name'] !== null)
			{
                $invite_tmpl_id = $this->decrypt_data($post_data['invite_tmpl_name']);

                $temp_action = (isset($article['proposal_method']) && $article['proposal_method'] === 'assign')
                ? 'unassign_user'
                : 'uninvite_user';
                $template = Stage_email_templates::get_single_record_with_bind_cond(
                    '*, stage_etmp_content AS stage_etmp_email_template',
                    [
                        'stage_etmp_id'     => $invite_tmpl_id,
                        'stage_etmp_action' => $temp_action,
                    ]
                );
            $templates = $template ? [$template] : [];
			}
            elseif(isset($post_data['bulk_revoke']) && $post_data['bulk_revoke'] == 'y') {
                 $revoke_temp_data = $article['revoke_temp_id'] ?? '';
                  $revoke_temp_ids = array_filter(explode(',', $revoke_temp_data));
                  $temp_action = (isset($article['proposal_method']) && $article['proposal_method'] === 'assign')
                ? 'unassign_user'
                : 'uninvite_user';
                $templates = Stage_email_templates::whereIn('stage_etmp_id', $revoke_temp_ids)
                ->where('stage_etmp_action', $temp_action)
                ->select('*', 'stage_etmp_content AS stage_etmp_email_template')
                ->get();
			}
            $status = 'i'; 
            if (isset($article['proposal_method']) && $article['proposal_method'] === 'assign') {
                $status = 'a';
			}

            $invite_user_data = Article_flow::get_single_record_with_bind_cond(
                'aflw_id',
                array(
                    'aflw_usr_id' => $user_id,
                    'aflw_id' => $current_stage_id,
                    'aflw_status' => $status
                )
            );
            if (!empty($invite_user_data))
			{
                $up_flw_id = $invite_user_data->aflw_id;
				$update_result = Article_flow::update_record(array(
                        'aflw_status' => 'u',
                    	'aflw_deeplink_token' => null),"aflw_id={$up_flw_id}", $this->currentuser);
                       if (!empty($update_result) && $templates !== null)
                        {
                            $aflw_id=decrypt_link($article['aflw_id']);
                            $select = 'art_id, art_artp_id, art_title, DATE_FORMAT(art_invitation_due, "' . $date_format . '") as art_invitation_due, artp_article_type, jnl_journal_name, jnl_journal_type, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                            $article_details = Articles::get_article_details($select,"aflw_id={$aflw_id}");
                            $article_details = $article_details[0];
                            $article_id = $article_details->art_id;
                            Article_notification_emails::delete_records("ane_stage_type='author_submission' and ane_art_id={$article_id} and ane_action='assigned'");
                            foreach ($templates as $template) {
                                if(isset($post_data['bulk_revoke']) && $post_data['bulk_revoke'] == 'y') {
                                    $post_data['postdata']['stage_template_sub'] =$template->stage_etmp_subject ;
                                    $post_data['postdata']['stage_template_content'] =$template->stage_etmp_content;
                                    $cc_list  = [];
                                    $bcc_list = [];

                                    if (!empty($template->stage_etmp_cc)) {
                                        $cc_list  = json_decode($template->stage_etmp_cc, true);
                                        $cc_list  = is_array($cc_list) ? $cc_list : [];
                                    }

                                    if (!empty($template->stage_etmp_bcc)) {
                                        $bcc_list  = json_decode($template->stage_etmp_bcc , true);
                                        $bcc_list  = is_array($bcc_list) ? $bcc_list : [];
                                    }
                                     
                                    $post_data['postdata']['stage_template_to_cc']   = $cc_list;
                                    $post_data['postdata']['stage_template_to_bcc']  = $bcc_list;
                                    $post_data['postdata']['stage_cust_cc']          = $template->stage_etmp_cust_cc ?? '';
                                    $post_data['postdata']['stage_cust_bcc']         = $template->stage_etmp_cust_bcc ?? '';
                                }

                             $email_data=array(
                            'type'=>'custom',
                            'action'=>'send',
                            'email_with_login'=>true,
                            'article_id'=>$article_id,
                            'user_id'=> $user_id,
                            'aflw_id'=>decrypt_link($article['aflw_id']),
                            'post_data'=>$post_data,
                            'template'=> $template,
                            'jnl_user_role'=>array(
                                'core_role'=>$core_role,
                                // 'role_name'=>$jnl_array['role_name'],
                                'jnl_id'=> $jnl_id,
                                'jnl_journal_code'=> $jnl_code
                            ),
                        );
                        $this->master_email_details($email_data);
                    }
				}
			}
            $current_stage_ids[] = $current_stage_id;
		}
        $uninvited_usrs = Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt ', "aflw_id IN (" . implode(',',$current_stage_ids) . ") AND aflw_status IN ('i', 'a') ");
        if ($uninvited_usrs->cnt == 0) {
            $return_data['msg'] = '';
            $return_data['status'] = 'success';
        }
		return  $this->success('Success', 201, $return_data);
    } catch (\Exception $e) {
        $this->customErrorAction('author_invitation_history',$e);
        return $this->failure('Failed', 500, $e);
    }




    }

    function create_author_menu($artp_jnl_id,$art_artp_id) {
        return false;
        $jnl_journal_type   =   $this->jnl_data->jnl_journal_type;
        $menu_arr           =   array();

        if($jnl_journal_type == 'authored_book') {
            //loading models
            $this->load->model(array(
                'journals/User_to_journals',
                'user/Roles'
            ));
            $current_user       =   $this->session->userdata('logged_user');
            $curr_user_id       =   $current_user['user_id'];

            $role_cond          =   'role_assigned_role = "author" and FIND_IN_SET("b", role_used_in)';
            $author_role   =   $this->Roles->get_single_record('role_id,role_name', $role_cond);
            $role_id            =   $author_role->role_id;
            $role_name          =   $author_role->role_name;

            $user_artp_arr      =   array(
                'usrj_jnl_id' => $artp_jnl_id,
                'usrj_usr_id' => $curr_user_id,
                'usrj_role_id' => $author_role->role_id,
                'usrj_artp_id' => $art_artp_id,
            );
            $user_in_artp       =   $this->User_to_journals->get_single_record('count(usrj_id) as cnt', $user_artp_arr);
            if ($user_in_artp->cnt > 0)
            {
                $menu_arr  =   array('role_id' => encrypt_link($role_id), 'role_name'=>$role_name);
            }
        }
        return $menu_arr;
    }

/*  Article proposal assignment  */
    public function send_author_assigment($article_id,$form_data,$new_aflw_id,$jnl_id)
    {
          
            $return_data['status'] = 'failed';
            $return_data['msg'] = 'invalid access';
            $jnl_code=$form_data['jnlcode'];
            $this->currentuser = $this->get_current_user_details();
            $optccvalue = array();
            if (isset($form_data['stage_cust_cc'])) {
                $custm_cc = $form_data['stage_cust_cc'];
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
    
                    array_push($optccvalue, $cust_value);
    
    
                }
                $post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);
    
            }
            else{
                $post_data['postdata']['stage_cust_cc']='';
            }
            $optbccvalue = array();
            if (isset($form_data['stage_cust_bcc'])) {
                $custm_bcc = $form_data['stage_cust_bcc'];
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);
    
                    array_push($optbccvalue, $cust_bcc_value);
    
                }
                $post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
            }
            else{
                $post_data['postdata']['stage_cust_bcc']='';
            }
            if(isset($form_data['stage_template_to_cc']))
            {
                $post_data['postdata']['stage_template_to_cc']=$form_data['stage_template_to_cc'] ;
            }
            
            if(isset($form_data['stage_template_to_bcc']))
            {
                $post_data['postdata']['stage_template_to_bcc']=$form_data['stage_template_to_bcc'] ;
            }
            
            $current_stage_ids = array();
    
            $date_format = $this->get_platform_date_format($jnl_id);
            $date_format= date_format_map($date_format);
            
                $current_stage_id = $new_aflw_id;
                $user_id = $this->decrypt_data($form_data['user_id']);
                $stage_etmp_id = $form_data['email_template'];
    
                $aflw_deeplink_token = Str::random(16);
                $condition =  array("aflw_usr_id"=>$user_id,
                                    "aflw_id" => $current_stage_id );
                $current_aflw_id_rec = Article_flow::get_single_record_with_bind_cond('aflw_id,aflw_deeplink_token,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as aflw_due_date', $condition);
                 
                
                if(!empty($current_aflw_id_rec))
                {
                $aflw_deeplink_token = ($current_aflw_id_rec->aflw_deeplink_token != '' ) ? $current_aflw_id_rec->aflw_deeplink_token : $aflw_deeplink_token;
    
                $current_aflw_id = $current_aflw_id_rec->aflw_id;
                $select = 'art_id, art_code, art_artp_id, art_title, artp_article_type, jnl_journal_name, jnl_journal_type, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                $article_details = Articles::get_article_details($select,"aflw_id='{$current_aflw_id}'");
    
                $article_details = $article_details[0];
                 $article_set = array(
                     'art_code' => $article_details->art_code,
                     'art_id' => $article_details->art_id,
                     'artp_id' => $article_details->art_artp_id,
                     'aflw_id'=>$article_details->aflw_id,
                     'user_id' =>$user_id,
                     'stage_etmp_id' => $form_data['email_template'],
                     'expired_status' => ''

                 );
                $post_data['article_set'][] = $article_set;
                $template = null;
                if (isset($stage_etmp_id) && $stage_etmp_id !== null) {
                    $template_condition = array(
                            'stage_etmp_id' => $stage_etmp_id,
                            'stage_etmp_action' => "assigned"
                    );
                    $template = Stage_email_templates::get_single_record_with_bind_cond('*, stage_etmp_content AS stage_etmp_email_template',$template_condition);
                   
                }
                
            
                if ($template !== null) {
                    $today = date('Y-m-d H:i:s', time());
                    $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                    $data['aflw_decline_clk_count'] = 0;
                    $data['aflw_accept_clk_count'] = 0;
                    $data['aflw_assigned_date'] = $today;
                    $data['aflw_due_date'] = date('Y-m-d H:i:s', strtotime('+2 days'));
                    $update_status_condition = array(
                        'aflw_usr_id' => $user_id,
                        'aflw_id' => $current_stage_id
                    );
                    Article_flow::update_record($data,$update_status_condition,$this->currentuser);
    
                    /*if the author doesnt have a role in journal level then insert the role*/
                    $author_role_id = $article_details->jwf_role_id;
                    $user_role_details = array(
                        'usrj_jnl_id' => $jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $author_role_id,
                        'usrj_artp_id' => null
                    );
                    $jnl_author_record = User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details);
                    if ($jnl_author_record === null)
                    {
                        $user_role_details = array(
                            'usrj_jnl_id' => $jnl_id,
                            'usrj_usr_id' => $user_id,
                            'usrj_role_id' => $author_role_id,
                            'usrj_artp_id' => null,
                            'usrj_invite' => 'n',
                        );
                        User_to_journals::insert_record($user_role_details, $this->currentuser);
                    }
                    $artp_user_role_details = array(
                        'usrj_jnl_id' => $jnl_id,
                        'usrj_usr_id' => $user_id,
                        'usrj_role_id' => $author_role_id,
                        'usrj_artp_id' => $article_details->art_artp_id
                    );
                   
                    $artyp_author_record = User_to_journals::get_single_record_with_bind_cond('usrj_id', $artp_user_role_details);
                    if ($artyp_author_record === null)
                    {
                        $artp_user_role_details = array(
                            'usrj_jnl_id' => $jnl_id,
                            'usrj_usr_id' => $user_id,
                            'usrj_role_id' => $author_role_id,
                            'usrj_artp_id' => $article_details->art_artp_id,
                            'usrj_invite' => 'n',
                        );
                        User_to_journals::insert_record($artp_user_role_details,$this->currentuser);
                    }
    
                    $author_role = Roles::get_single_record('role_id', 'role_assigned_role = "author" and FIND_IN_SET("r", role_used_in)');
                    $role_id = $author_role->role_id;

                    $custom_data=array(
                        'link'=> '',
                        'accept_link'=> '',
                        'reject_link'=> '',
                        'email_id'=>'proposal',
                        'article_id'=>$article_id,
                        'artp_id'=>$article_details->art_artp_id,
                        'jnl_id'=>$jnl_id,
                        'jnl_code'=>$jnl_code,
                        'aflw_id'=> $article_details->aflw_id,
                    );
                
                    $post_data['jnl_code'] =$jnl_code;
                    $post_data['jnl_id'] =$this->encrypt_data($jnl_id);
                    $post_data['postdata']['stage_template_to_mail'] = $form_data['email'];
                    $post_data['postdata']['invite_tmpl_name'] = $stage_etmp_id;
                    $post_data['postdata']['stage_template_sub'] = $form_data['stage_etmp_subject'] ;

                    $replace_button = array('<button contenteditable="false">', '</button>');
                    $replaceval = str_replace($replace_button, '##', $form_data['stage_etmp_content']);
                    $post_data['postdata']['stage_template_content'] = $replaceval;
                    
                    $condition = 'usr_id ='.$user_id;
			        $get_user_data = User::get_single_record('*',$condition);
                    if(!empty($get_user_data) && isset($get_user_data->usr_status) && $get_user_data->usr_status == 'w') {
                    $this->create_user_email($get_user_data, $this->currentuser);
                   }
                    $email_data=array(
                        'type'=>'custom',
                        'action'=>'send',
                        'email_with_login'=>true,
                        'article_id'=>$article_id,
                        'user_id'=> $user_id,
                        'aflw_id'=> $article_details->aflw_id,
                        'post_data'=>$post_data,
                        'aflw_deeplink_token'=>$aflw_deeplink_token,
                        'role_id'=>$role_id,
                        'template'=> $template,
                        'jnl_id'=> $jnl_id,
                        'custom_data'=>$custom_data,
                        'jnl_user_role'=>array(
                            'core_role'=>$form_data['corerole'],
                            // 'role_name'=>$jnl_array['role_name'],
                            'jnl_id'=> $jnl_id,
                            'jnl_journal_code'=> $jnl_code
                        ),
                    );
                    $this->master_email_details($email_data);
                
                    $email_send = true;
                    $current_stage_ids[] = $current_stage_id;
                    $submittion_date[encrypt_link($article_id)] = $current_aflw_id_rec->aflw_due_date;
    
                }
            }
            
                if ($email_send === true) {
                  
                    $return_data['status'] = 'success';
                } else {
                    $return_data['status'] = 'failed';
                   
                }
         
        return  $this->success('Success', 201, $return_data);
    }

    /*
    * function that operates bulk article import 
    */
    public function bulkarticleimport(Request $request)
    {
        try{
            $post_data=$request->all();
            if($post_data['file'])
            {
                $currDate       =   strtotime("now");
                $this->current_user = $this->get_current_user_details();

                $jnl_id             =   decrypt_link($post_data['jnl_id']);
                $email_id           =   decrypt_link($post_data['email_template']);
                $stage_etmp_subject =   $post_data['stage_etmp_subject'];
                $stage_etmp_content =   $post_data['stage_etmp_content'];
                $journal_code       =   Journals::get_single_record('jnl_journal_code', "jnl_id = ? ",binding_arr:[$jnl_id])->jnl_journal_code;
                $corerole           =   $post_data['corerole'];
                $failArtArr         =   [];
                $jnl_setting        =   Journal_settings::get_single_record_with_bind_cond('jset_date_format,jset_classification,jset_classification_title',array("jset_jnl_id"=>$jnl_id));
                $jnl_classification = isset($jnl_setting->jset_classification)?$jnl_setting->jset_classification:'n';
                $art_typ_id         =   decrypt_link($post_data['art_typ_id']);
                $article_details    =   Article_type_advance_options::get_all_records('*', "atotp_artp_id='{$art_typ_id}'" );
                $title_length       =   isset($article_details[0]->atotp_title_length) ? $article_details[0]->atotp_title_length:250;
            
                $article_jnlid      =   Article_types::get_single_record('artp_jnl_id, artp_fwm_id,artp_prefix_article_no,artp_abbr_article_type,artp_article_type,artp_es_document_type',"artp_id='{$art_typ_id}'");
            
                // Get the uploaded ZIP file
                $zipFile = $request->file('file');

                if (!$zipFile) {
                    return response()->json(['error' => 'No file uploaded'], 400);
                }

                // Define Paths
                $zipTempPath = storage_path('/app/public/temp_uploads/' . $zipFile->getClientOriginalName());
                $folderName = pathinfo($zipFile->getClientOriginalName(), PATHINFO_FILENAME);
                $extractPath = storage_path('/app/public/extracted_files_' . $currDate);

                // Ensure directories exist
                File::ensureDirectoryExists(storage_path('/app/public/temp_uploads')); // For temp storage
                File::ensureDirectoryExists($extractPath); // For extraction

                // Move the uploaded ZIP to temp directory
                $zipFile->move(storage_path('/app/public/temp_uploads/'), $zipFile->getClientOriginalName());

                $zip = new \ZipArchive;
                $innerFldrPath  =   '';
                $directoryPath  =   '';

                if ($zip->open($zipTempPath) === TRUE) 
                {
                    $zip->extractTo($extractPath); // Extract files
                    $csvfile    =   '';
                    $csvFound   = false;
                    $encoding = 'UTF-8';
                    $sample = "";
                    // Open a directory, and read its contents
                    if (is_dir($extractPath)){
                        if($dh = opendir($extractPath))
                        {
                            $directories = File::directories( storage_path('/app/public/extracted_files_' . $currDate));
                            $innerFldrPath = $directories ? $directories[0]."/" : null;
                            if(!$innerFldrPath){
                                throw new Exception("Unable to Extract Files");
                            }
                            if (is_dir($innerFldrPath)){
                                if($innrdh = opendir($innerFldrPath))
                                {
                                    $csvfile = $this->findCsvFile($innerFldrPath);
                                    if($csvfile != null) {
                                        $sample = file_get_contents($csvfile);                                
                                        $encoding = mb_detect_encoding($sample, ['UTF-8', 'WINDOWS-1252', 'ISO-8859-1', 'ASCII'], true);
                                        $csvFound   = true;
                                    } else {
                                        $this->deleteDirectory($extractPath);

                                        $return_data    =   array(
                                            'status'        => 'error',
                                            'message'    => 'CSV file not found in the zip file' ,
                                        ); 
                                        return response()->json($return_data, 200);
                                    }
                                }
                            }
                        }
                    }
                    // Get the directory path (without the file name)
                    $directoryPath = dirname($csvfile) . DIRECTORY_SEPARATOR;

                    $message        =   '';
                    $insertedCount  =   0;
                    $duplicates     =   [];

                    //Return response
                    if ($csvFound == true && ($file_read = fopen($csvfile, 'r')) !== false) 
                    {
                        $rowCount   =   0;
                        while (($row = fgetcsv($file_read)) !== false) {
                            $rowCount++;
                        }
                        // Reset file pointer to start from the beginning
                        rewind($file_read);

                        $maxLmt 	= 	Consts::MaxArtImpRowLmt;
                        if($rowCount > $maxLmt) {
                            $this->deleteDirectory($extractPath);
                            $return_data    =   array(
                                'status'        => 'error',
                                'message'    => 'The uploaded CSV file exceeds the '.$maxLmt.' row limit. Please upload a smaller file.' ,
                            ); 
                            return response()->json($return_data, 200);
                        }

                        $headers        =   fgetcsv($file_read); // Read headers
                        $filtered_headers = array_values(array_filter($headers, function($value) {
                            return !empty($value);
                        }));

                        $keyArr           =   $this->escape_string($filtered_headers);
                        // Convert to lowercase and remove spaces
                        $keys = array_map(function($value) {
                            //task #3419 remove non-printable or invisible character
                            return strtolower(str_replace(' ', '', trim(preg_replace('/[^\P{C}\n]+/u', '', $value), "\xEF\xBB\xBF\xC2\xA0")));
                        }, $keyArr);

                        // Required keys with their labels
                        $requiredKeys = [
                            'firstname' => 'First name',
                            'lastname' => 'Last name',
                            'email' => 'Email',
                            'title' => 'Title',
                            // 'abstract' => 'Abstract', // for aipp removed abstract
                            'folder' => 'Folder'
                        ];
                        // Find missing keys

                        //Task #1896 Starts
                        $section_db_ky = 'section';
                        if($jnl_classification == 'y'){
                            $section_db_ky = strtolower($jnl_setting->jset_classification_title);
                            $requiredKeys[$section_db_ky] = $jnl_setting->jset_classification_title ?? 'Section';
                        }
                        //Task #1896 Ends

                        $missingKeys = array_diff(array_keys($requiredKeys), $keys);
                        if (!empty($missingKeys)) {
                            $this->deleteDirectory($extractPath);
                            $missingMessages = [];
                            foreach ($missingKeys as $key) {
                                $missingMessages[] = $requiredKeys[$key];
                            }
                            $status     =   'error';
                            $message    =   "Missing columns in the csv file: " . implode(', ', $missingMessages);
                            return response()->json(['status'=>$status, 'message' => $message], 200);
                        }

                        //task #3419 moved $excesskeys line from 3088 to here
                        $excessKeys = array_diff($keys, array_keys($requiredKeys));
                        // Then, check for unexpected EXCESS columns
                        if (!empty($excessKeys)) {
                            $this->deleteDirectory($extractPath);
                            $excessMessages = [];
                            // If your $requiredKeys array maps to human names, you can't reverse it easily for excess.
                            // So, we just show the technical column names from the CSV.
                            foreach ($excessKeys as $key) {
                                $excessMessages[] = $key;
                            }
                            $status     =   'error';
                            $message    =   "Unexpected columns found in the CSV file: " . implode(', ', $excessMessages);
                            return response()->json(['status' => $status, 'message' => $message], 200);
                        }
                        // && in_array('abstract', $keys) for aipp removed abstract
                        if(empty($missingKeys) && in_array('firstname', $keys) && in_array('lastname', $keys) && in_array('email', $keys)
                        && in_array('title', $keys) && in_array('folder', $keys))
                        {
                            $art_title_ky           =   array_search('title',$keys);
                            // $art_abstract_ky        =   array_search('abstract',$keys); // or aipp removed abstract 
                            $art_author_email_ky    =   array_search('email',$keys);
                            $auth_fname_ky          =   array_search('firstname',$keys);
                            $auth_lname_ky          =   array_search('lastname',$keys);
                            $file_name_ky           =   array_search('folder',$keys);

                            if($jnl_classification == 'y')
                                $section_ky         =   array_search($section_db_ky,$keys);
                            
                            
                            while(($row = fgetcsv($file_read)) !== FALSE)
                            {
                                array_filter($row, function($value) { return !is_null($value) && $value !== ''; });
                                if ($encoding !== 'UTF-8') {
                                    $row = array_map(function ($value) use($encoding) {
                                        $utf8Content = mb_convert_encoding($value, 'UTF-8', $encoding);
                                        $utf8Content = preg_replace('/^\xEF\xBB\xBF/', '', $utf8Content);
                                        return $utf8Content;
                                    }, $row);
                                }
                                if(empty($row))
                                {
                                    unset($row);
                                }
                                if(isset($row))
                                {
                                    if($row != NULL && !empty($row[$art_title_ky]) && !empty($row[$art_author_email_ky]))
                                    {
                                        $values = $row;
                                        if(count($keys) == count($values))
                                        {
                                            $new_values         =   $this->escape_string($values);
                                            $art_title          =   htmlentities(strip_tags($new_values[$art_title_ky]));
                                            $art_title          =   $this->unicode_correction_export(trim($art_title));

                                            // $art_abstract       =   $this->unicode_correction_export(htmlentities(strip_tags($new_values[$art_abstract_ky]))); // or aipp empty abstract value

                                            $art_abstract       = '';

                                            $auth_email         =   trim($new_values[$art_author_email_ky]);
                                            if (!filter_var($auth_email, FILTER_VALIDATE_EMAIL)) {
                                              continue; // Skip this record
                                             }
                                            $file_name          =   trim($new_values[$file_name_ky]);
                                            //$submission_date    =   trim($new_values[$submission_date_ky]);
                                            $sectionExist = true;
                                            if($jnl_classification == 'y'){
                                                $section        =   trim(preg_replace('/[^a-zA-Z0-9\s]/u', '', $new_values[$section_ky]));;
                                                ($section == "")?$sectionExist = false:"";
                                            }
                                     
                                        //    //Task #1850 Starts
                                        //     $dateTime = \DateTime::createFromFormat('y-m-d', $submission_date);   
                                        //     $date = $dateTime->format('Y-m-d');
                                        //     $time = $dateTime->format('H:i:s');
                                        //     $submission_date = convert_dmy_to_ymd($date,$jnl_date_format);
                                        //     $submission_date = ($submission_date.' '.$time);
                                        //     $now = new \DateTime(); // current date and time
                                        //     if ($dateTime <= $now) {
                                        //         $failArtArr[] = $art_title;
                                        //         continue;
                                        //     }
                                        //     //Task #1850 Ends
                                        //task #3419 Issues in maange copyright statment (removed empty($section) )
                                            if(empty($art_title) || empty($auth_email) || empty($file_name) || ($jnl_classification == 'y' && !$sectionExist)){
                                                return response()->json(['status'=>'error', 'message' => 'Mandatory fields are missing in article entry'], 200); 
                                            }
                                            DB::beginTransaction();
                                            $art_code   =   $this->create_article_code($art_typ_id);

                                            // Task #3027 Fetch the articles for article number re-ordering
                                            if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y'){
                                                $art_order  =   $this->create_article_order($jnl_id);
                                            } else{
                                                $art_order  =   0;
                                            }

                                            $article_data_list  =   array(
                                                                        'art_code'   =>   $art_code,
                                                                        'art_chapter_order' => $art_order,
                                                                        'art_artp_id' => $art_typ_id,
                                                                        'art_title'   =>   $art_title,
                                                                        'art_abstract' =>   $art_abstract,
                                                                        'art_stage_submission_method' => 'b',
                                                                        'art_status' => 'n',
                                                                        'art_title_editable' => 'n',
                                                                        'art_delete_status' => 'n',
                                                                        'art_email_template' => $email_id,
                                                                        'art_proposal_method' => 'assign'
                                                                    );
                                            // Check for duplicate art_code
                                            $cond1 =    'art_code = "'.$art_code.'"';
                                            $existingArticle = Articles::get_single_record('art_id',$cond1);

                                            if (!empty($existingArticle)) {
                                                $duplicates[] = $existingArticle->art_id;
                                            } 
                                            else 
                                            {
                                                // Check for duplicate art_code
                                                $cond2 =    'usr_email = "'.$auth_email.'"';
                                                $existingUser = User::get_single_record('usr_id', $cond2);
                                                if (!empty($existingUser)) {
                                                    //if the user exists
                                                    $article_data_list['art_submitted_by']  =  $existingUser->usr_id;
                                                }
                                                else {
                                                    //if the user does not exists
                                                    $username           =   trim($new_values[$art_author_email_ky]);
                                                    $auth_fname         =   trim($new_values[$auth_fname_ky]);
                                                    $auth_lname         =   trim($new_values[$auth_lname_ky]);

                                                    $is_existing_usrname = User::get_single_record('usr_username','usr_username = "'.$username.'"');
                                                    if(isset($is_existing_usrname)){
                                                        $username   = $auth_email;
                                                    } 
                                                    $tokenkey= Str::random(20);
                                                    //push user data to user array
                                                    $userarr = array(
                                                                    'usr_username' => $username,
                                                                    'usr_first_name' => $auth_fname,
                                                                    'usr_last_name' => $auth_lname,
                                                                    'usr_email' => $auth_email,
                                                                    'usr_deeplink_token' => $tokenkey,
                                                                    'usr_status' =>  'w',
                                                                    'usr_operation' => 'b',    //bulk import
                                                                    'usr_posted_date' => date('Y-m-d H:i:s')
                                                                );
                                                    $userId     =   User::insert_record($userarr, $this->current_user);
                                                    $article_data_list['art_submitted_by']  =  $userId;
                                                }
                                                // Insert into database
                                                $new_usr_id     =   $article_data_list['art_submitted_by'];
                                                $article_id = Articles::insert_record($article_data_list, $this->current_user);
                                                if($article_id)
                                                {
                                                    if($jnl_classification == 'y')
                                                        $resultSet = $this->createOrUpdateClassification($section,$jnl_id,$art_typ_id,$article_id);          //Task #1850

                                                    $form_data          =   array('user_id' => encrypt_link($new_usr_id), 'is_title_editable' => 'n', 'hd_art_note_prop_chk' => 'n',
                                                                                'proposal_method' => 'assign', 'article_type' => $art_typ_id, 'articleid' => '', 'art_title' => $art_title,
                                                                                'jnlcode'=>$journal_code, 'email' => $auth_email,  'author_first_name' => '', 'sub' => '',
                                                                                'art_note_prop_chk' => '', 'target_publication_date' => '', 'author_last_name' =>  '', 'corerole' => $corerole,
                                                                                'newuserstatus' =>  '', 'author_email' => '', 'publication_volume' =>  '', 'publication_issue' => '', 
                                                                                'validemail' => '', 'prpsl_note_content' => '', 'article_stage_type' => '', 'email_template' => $email_id,
                                                                                'stage_etmp_subject' => $stage_etmp_subject, 'stage_etmp_content' => $stage_etmp_content, 'note_id' => '', 'hid_usr_id' => '',
                                                                                'propsl_notesto' => array(), 'author_response_due' => null, 'submission_due_date' => null, 'submission_method' =>'b');
                                                                                
                                                    $new_aflw_id        =   $this->article_move_next_stage($article_id, $form_data, $art_typ_id, $article_jnlid, $article_data_list,null);

                                                    //save corr author to article_authors table
                                                    $this->save_corr_author($new_usr_id, $article_id);
                                                    
                                                    //* start -- update article uploaded files path*//
                                                    $upload_path = $journal_code . '/' . $article_jnlid->artp_abbr_article_type . '/' . $article_id;
                                                    if (!file_exists(public_path() . '/storage/uploads/' . $upload_path))
                                                    {
                                                        // mkdir(public_path() . '/storage/uploads/' . $upload_path, 0777, true);
                                                        Storage::makeDirectory(public_path() . '/storage/uploads/' . $upload_path);
                                                    }


                                                    //art doi
                                                    $doi            = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                                                    $doi_details    = Config::get($doi);
                                                    $doi_data       = $this->create_article_doi($article_id, $doi_details, 'n',$art_code);
                                                    $article_doi    =   $doi_data['doi'];

                                                    Articles::update_record(array(
                                                        'art_article_upload_path' => $upload_path,
                                                        'art_doi' => $article_doi
                                                    ), "art_id={$article_id}",$this->currentuser, '', 'e');
                                                    //* end -- update article uploaded files path*//

                                                    $this->create_author_menu($article_jnlid->artp_jnl_id,$art_typ_id);
                                                    $tabarray = 'clients.' . $this->current_client->clnt_client_code . '.tabconfig';
                                                    $art_submission_tab_arr = Config::get($tabarray);
                                                    $art_submission_tab = array();
                                                    $article_tab_details    =   Article_tab_status::get_all_records('*',"tab_status_art_id={$article_id}");


                                                    if(count($article_tab_details)>0) {
                                                        foreach ($art_submission_tab_arr as $art_tab_key => $art_tab_val)
                                                        {
                                                            $art_submission_tab["$art_tab_key"] = $art_tab_val;
                                                        }
                                                        Article_tab_status::update_record(array("tab_status_array" => json_encode($art_submission_tab)),"tab_status_art_id={$article_id}", $this->currentuser);
                                                    } else {
                                                        $art_submission = array();
                                                        foreach ($art_submission_tab_arr as $art_tab_key => $art_tab_val) {
                                                            if ($art_tab_key == "tab_article_details" || $art_tab_key == "tab_co_author") {
                                                                //initially it set to p
                                                                //$art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "c" : "p";
                                                                $art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "p" : "";
                                                            } else {
                                                                $art_submission["$art_tab_key"] = $art_tab_val;
                                                            }
                                                        }
                                                        $tab_data['tab_status_art_id'] = $article_id;

                                                        if ($article_details[0]->atotp_suggest_reviewers == 'n' && $article_details[0]->atotp_oppose_reviewers == 'n') {
                                                            unset($art_submission['tab_review_preference']);
                                                        }
                                                        $tab_data["tab_status_array"] = json_encode($art_submission);
                                                        Article_tab_status::insert_record($tab_data, $this->currentuser);
                                                    }
                                                    
                                                    // insert to rvw_article_attachments
                                                    // Define the folder path based on the art_code
                                                    $attachmentFolderPath = $directoryPath.$file_name;
                                                    // Check if the folder exists
                                                    if (File::exists($attachmentFolderPath) && File::isDirectory($attachmentFolderPath)) 
                                                    {
                                                        // Get all files inside the folder
                                                        $files = File::files($attachmentFolderPath);
                                                        // Convert the SplFileInfo objects to file names
                                                        // $fileNames = array_map(fn($file) => $file->getFilename(), $files);
                                                        $fileNames = array_map(fn($file) => [
                                                            'name' => $file->getFilename(),
                                                            'path' => $file->getPathname(),
                                                            'size' => $file->getSize() // Size in bytes
                                                        ], $files);

                                                        foreach($fileNames as $fn)
                                                        {
                                                            $update_attachment_table_array  =   array();
                                                            $attch_files  =   array();
                                                            $path = $fn['path'];
                                                            $fle = new SymfonyFile($path);
                                                            $attachment_file = new UploadedFile(
                                                                $fle->getPathname(), // The full path to the file
                                                                $fle->getFilename(), // The original file name
                                                                $fle->getMimeType(), // The mime type of the file
                                                                0, // The error code (UPLOAD_ERR_OK)
                                                                true // Whether the test mode is enabled (skip move verification)
                                                            );
                                                           
                                                            $uploaded = $this->upload_file_handler($upload_path, $attachment_file, $fn['name']);
                                                            $fn['name'] = $uploaded['name'];
                                                            $attch_files[] = array(
                                                                'filename' => $fn['name'],
                                                                'filepath' => $fn['path'],
                                                                'filesize' => $fn['size']
                                                            );
                                                            $allowd_filetype = Article_type_advance_options::get_single_record('atotp_file_type,atotp_file_description', "atotp_artp_id={$art_typ_id}");
                                                            $file_description_data = Required_file_type::get_all_records('*', "rft_artp_id={$art_typ_id}");
                                                            $file_description = array();
                                                            $file_description_arr = array();
                                                            if (!empty($file_description_data)) {
                                                                foreach ($file_description_data as $fd) {
                                                                    array_push($file_description_arr, $fd->rft_file_desp_id);
                                                                }
                                                                $file_description = implode(',', $file_description_arr);
                                                            }
                                                            $allowd_filetype->description = $file_description;
                                                            $update_attachment_table_array['attach_file'] = $attch_files;
                                                            $update_attachment_table_array['article_id'] = $article_id;
                                                            $update_attachment_table_array['article_type_id'] = $art_typ_id;
                                                            $update_attachment_table_array['allowed_file_type'] = $allowd_filetype;
                                                            $update_attachment_table_array['article_type_code'] = $article_jnlid->artp_abbr_article_type;
                                                            $update_attachment_table_array['article_upload_path'] = $upload_path;
                                                            $update_attachment_table_array['artflow_id'] = $new_aflw_id;
                                                            $update_attachment_table_array['article_editable'] = false;
                                                            $update_attachment_table_array['author_attachment'] = true;
                                                            $update_attachment_table_array['platform_code'] = $journal_code;


                                                            (new Manage_Article_Submission_Api)->update_to_attachment_table($update_attachment_table_array);
                                                        }
                                                    }
                                                    $insertedCount++;
                                                }
                                            }
                                            DB::commit();
                                        }
                                    }
                                }
                            }
                        } 
                        fclose($file_read); // Close file after reading
                        // Return response if any artciles added
                        if($insertedCount > 0) {
                            $status     =   'success';
                            $message   =    $insertedCount . ' articles added successfully. ';
                        }
                        else {
                            $status     =   'error';
                            $message   =    'Articles addition failed. ';
                        }
                        
                        $zip->close();
                        $this->deleteDirectory($extractPath);
                        return response()->json(['status'=>$status, 'message' => $message], 200);
                    } else {
                        return response()->json(['status'=>'error', 'message' => 'CSV file missing in the zip file'], 200);
                    }
                }
            } else {
                return response()->json(['status'=>'error', 'message' => 'ZIP file not found'], 200);
            }
        }
        catch (\Exception $e) {
            DB::rollBack();
            return  $this->failure('failure', 500, $e);
        }

    }


    /* Task start #3059 Chunk upload in article upload*/
      /*
    * function that operates bulk article import  for stream function  to 
    */


    public function chunkInitFile(Request $request)
    {
    try {
        $originalName = $request->input('file_name');
        $uploadId = uniqid('upload_', true);

        $tempDir = storage_path("app/chunks/{$uploadId}");
        if (!file_exists($tempDir)) {
            mkdir($tempDir, 0777, true);
        }

        return response()->json([
            'status' => 'ok',
            'uploadId' => $uploadId,
            'fileName' => $originalName,
        ]);
    }
        catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
    }

    /**
     * 2️⃣ Receive file chunks
     */
    public function chunkUpload(Request $request)
    {
        try {
        $uploadId = $request->input('uploadId');
        $chunkIndex = $request->input('chunkIndex');
        $file = $request->file('file');

        if (!$file || !$uploadId) {
            return response()->json(['status' => 'error', 'message' => 'Invalid request'], 400);
        }

        $tempDir = storage_path("app/chunks/{$uploadId}");
        if (!file_exists($tempDir)) {
            mkdir($tempDir, 0777, true);
        }

        // Save the chunk
        $file->move($tempDir, "chunk_{$chunkIndex}");

        return response()->json([
            'status' => 'ok',
            'message' => "Chunk {$chunkIndex} uploaded",
        ]);
         }
        catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
     }
    }

    /**
     * 3️⃣ Merge chunks into a single file (preserve original filename)
     */
    public function chunkMerge(Request $request)
    {
        try {
        $uploadId = $request->input('uploadId');
        $fileName = $request->input('fileName');

        if (!$uploadId || !$fileName) {
            return response()->json(['status' => 'error', 'message' => 'Missing parameters'], 400);
        }

        $tempDir = storage_path("app/chunks/{$uploadId}");
        $finalDir = storage_path('app/public/temp_uploads');
        if (!file_exists($finalDir)) {
            mkdir($finalDir, 0777, true);
        }

        $finalPath = "{$finalDir}/{$fileName}";
        $chunks = glob("{$tempDir}/chunk_*");
        natsort($chunks);

        $out = fopen($finalPath, 'wb');
        foreach ($chunks as $chunk) {
            $in = fopen($chunk, 'rb');
            stream_copy_to_stream($in, $out);
            fclose($in);
        }
        fclose($out);

        // Cleanup chunks
        foreach ($chunks as $chunk) {
            unlink($chunk);
        }
        @rmdir($tempDir);

        return response()->json([
            'status' => 'merged',
            'fileName' => $fileName,
            'filePath' => $finalPath,
        ]);
    }
    catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
        }
    }
public function bulk_article_analyze(Request $request)
{
    return new StreamedResponse(function () use ($request) {
        try {
            $postData = $request->all();
            $this->current_user = $this->get_current_user_details();

            if (empty($postData['file'])) {
                return $this->set_error_response_stream(['status' => 'error', 'message' => 'ZIP file not found']);
            }

            $currDate = time();
            $jnl_id   = decrypt_link($postData['jnl_id']);
            $email_id = decrypt_link($postData['email_template']);

            // === JOURNAL SETTINGS ===
            $jnl_setting = Journal_settings::get_single_record_with_bind_cond(
                'jset_date_format,jset_classification,jset_classification_title',
                ["jset_jnl_id" => $jnl_id]
            );
            $jnl_classification = $jnl_setting->jset_classification ?? 'n';
            $sectionKey = strtolower($jnl_setting->jset_classification_title ?? '');

            // === ARTICLE TYPE ===
            $art_typ_id      = decrypt_link($postData['art_typ_id']);
            $article_details = Article_type_advance_options::get_all_records_with_bind_cond('*', ["atotp_artp_id" => $art_typ_id]);
            $title_length    = $article_details[0]->atotp_title_length ?? 250;

            // === FILE PATH SETUP ===
            $zipPath     = storage_path('app/public/temp_uploads/' . $postData['file']);
            $extractPath = storage_path('app/public/extracted_files_' . $currDate);
            File::ensureDirectoryExists($extractPath);

            // === EXTRACT ZIP ===
            $zip = new \ZipArchive;
            if ($zip->open($zipPath) !== true) {
                return $this->set_error_response_stream(['status' => 'error', 'message' => 'Unable to open ZIP file']);
            }
            $zip->extractTo($extractPath);
            $zip->close();

            // === FIND INNER FOLDER ===
            $directories = File::directories($extractPath);
            if (empty($directories)) {
                return $this->set_error_response_stream(['status' => 'error', 'message' => 'No inner folder found after extraction']);
            }
            $innerFolder = $directories[0] . "/";

            // === FIND CSV FILE ===
            $csvFile = $this->findCsvFile($innerFolder);
            if (!$csvFile) {
                $this->deleteDirectory($extractPath);
                return $this->set_error_response_stream(['status' => 'error', 'message' => 'CSV file not found in ZIP']);
            }

            // === OPEN CSV ===
            $sample   = file_get_contents($csvFile);
            $encoding = mb_detect_encoding($sample, ['UTF-8', 'WINDOWS-1252', 'ISO-8859-1', 'ASCII'], true);
            $directoryPath = dirname($csvFile) . DIRECTORY_SEPARATOR;
            
            $fileRead = fopen($csvFile, 'r');
            if (!$fileRead) {
                return $this->set_error_response_stream(['status' => 'error', 'message' => 'Unable to open CSV file']);
            }

            // === ROW COUNT ===
            $rowCount = 0;
            while (($row = fgetcsv($fileRead)) !== false) $rowCount++;
            rewind($fileRead);
            $rowCount = max(0, $rowCount - 1);

            // === HEADERS ===
            $headers = fgetcsv($fileRead);
            if (!$headers) {
                return $this->set_error_response_stream(['status' => 'error', 'message' => 'CSV has no headers']);
            }

            // === NORMALIZE HEADERS ===
            $filteredHeaders = array_values(array_filter($headers, fn($v) => !empty($v)));
            $keys = array_map(fn($v) => strtolower(str_replace(' ', '', $v)), $filteredHeaders);

            // === REQUIRED COLUMNS ===
            $requiredKeys = [
                'firstname' => 'First name',
                'lastname'  => 'Last name',
                'email'     => 'Email',
                'title'     => 'Title',
                'folder'    => 'Folder',
            ];
            if ($jnl_classification === 'y') {
                $requiredKeys[$sectionKey] = $jnl_setting->jset_classification_title ?? 'Section';
            }

            // === VALIDATE COLUMN PRESENCE ===
            $missingColumns = array_diff(array_keys($requiredKeys), $keys);
            $extraColumns   = array_diff($keys, array_keys($requiredKeys));

            if (!empty($missingColumns)) {
                $missingLabels = array_map(fn($key) => $requiredKeys[$key] ?? $key, $missingColumns);
                return $this->set_error_response_stream([
                    'status'  => 'error',
                    'message' => 'Missing columns: ' . implode(', ', $missingLabels)
                ]);
            }

            if (!empty($extraColumns)) {
                return $this->set_error_response_stream([
                    'status'  => 'error',
                    'message' => 'Unexpected columns found: ' . implode(', ', $extraColumns)
                ]);
            }

            // === HEADER POSITIONS ===
            $colIndex = fn($key) => array_search($key, $keys);
            $indices = [
                'title'     => $colIndex('title'),
                'email'     => $colIndex('email'),
                'firstname' => $colIndex('firstname'),
                'lastname'  => $colIndex('lastname'),
                'folder'    => $colIndex('folder'),
                'section'   => $jnl_classification === 'y' ? $colIndex($sectionKey) : null,
            ];

            // === PROCESS ROWS ===
            $processed = 0;
            $analyzeCount = 0;
            $duplicates = [];
            $failedRows = [];
            $progress = [];

            while (($row = fgetcsv($fileRead)) !== false) {
                $processed++;
                $analyzeCount++;
                if (!is_array($row) || empty($row)) continue;

                if ($encoding !== 'UTF-8') {
                    $row = array_map(fn($v) => preg_replace('/^\xEF\xBB\xBF/', '', mb_convert_encoding($v, 'UTF-8', $encoding)), $row);
                }
              
                $values = $this->escape_string($row);
                $missingInRow = [];
                 $rowErrors     = [];
                // === Check missing required fields ===
          // === Check for missing required fields ===
                foreach ($requiredKeys as $key => $label) {
                    $value = $values[$colIndex($key)] ?? '';
                    if (empty(trim($value))) {
                        $rowErrors[] = [
                            'field' => $key,
                            'value' => '',
                            'error' => "{$label} is missing"
                        ];
                    }
                }
                $rowNum = $processed + 1;
              if (!empty($rowErrors)) {
                foreach ($rowErrors as $err) {
                    $failedRows[] = [
                        'row'   => $rowNum,
                        'field' => $err['field'],
                        'value' => $err['value'],
                        'error' => $err['error'],
                    ];
                }
                continue;
            }
                                    // === Validate First Name, Last Name, Email, and Section (if required) ===
                $firstName     = trim($values[$indices['firstname']] ?? '');
                $lastName      = trim($values[$indices['lastname']] ?? '');
                $auth_email    = trim($values[$indices['email']] ?? '');
                $sectionValue  = $jnl_classification === 'y' ? trim($values[$indices['section']] ?? '') : '';
                $file_name  = trim($values[$indices['folder']] ?? '');

                                    // === First Name validation (alphabets & hyphen only) ===
                if (!preg_match('/^[\p{L}\p{M}\s-]+$/u', $firstName)) {
                        $rowErrors[] = [
                            'field' => 'firstname',
                            'value' => $firstName,
                            'error' => 'Invalid first name (only letters, spaces, and hyphens allowed)'
                        ];
                    }

                    // === Last Name validation ===
                    if (!preg_match('/^[\p{L}\p{M}\s-]+$/u', $lastName)) {
                        $rowErrors[] = [
                            'field' => 'lastname',
                            'value' => $lastName,
                            'error' => 'Invalid last name (only letters, spaces, and hyphens allowed)'
                        ];
                    }


             // === Email validation ===
                if (!empty($auth_email)) {
                    // Check regex format (same as Yup)
                    if (!preg_match('/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/', $auth_email)) {
                        $rowErrors[] = [
                            'field' => 'email',
                            'value' => $auth_email,
                            'error' => 'Invalid email format'
                        ];
                    }
                } else {
                    // Required check
                    $rowErrors[] = [
                        'field' => 'email',
                        'value' => $auth_email,
                        'error' => 'Email is required'
                    ];
                }

                // === Section (classification) validation ===
                if ($jnl_classification === 'y') {
                                if (empty($sectionValue)) {
                        $rowErrors[] = [
                            'field' => $sectionKey,
                            'value' => '',
                            'error' => 'Section missing'
                        ];
                    } elseif (!preg_match("/^[0-9A-Za-zÀ-ú\-_,.:à&'()\/\s]+$/u", $sectionValue)) {
                        $rowErrors[] = [
                            'field' => $sectionKey,
                            'value' => $sectionValue,
                            'error' => 'Invalid section value (only letters, numbers, spaces, underscores, and hyphens allowed)'
                        ];
                    }
                     }

                            // === Folder path from CSV (normalize + basic security) ===
                    $file_name = (string) ($values[$indices['folder']] ?? '');
                    $file_name = preg_replace('/^\xEF\xBB\xBF/', '', $file_name);      // strip BOM if any
                    $file_name = trim($file_name, " \t\n\r\0\x0B\"'");                 // trim quotes/space
                    $file_name = str_replace('\\', DIRECTORY_SEPARATOR, $file_name);   // normalize slashes

                    // Block traversal
                    if ($file_name === '' || str_contains($file_name, '..')) {
                        $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => 'folder',
                            'value' => $values[$indices['folder']] ?? '',
                            'error' => 'Invalid folder value'
                        ];
                    
                    }

                    // Build absolute folder path safely
                    $attachmentFolderPath = rtrim($directoryPath, "/\\") . DIRECTORY_SEPARATOR . ltrim($file_name, "/\\");
                    $attachmentFolderPath = preg_replace('#[\\/]+#', DIRECTORY_SEPARATOR, $attachmentFolderPath);

                    // === Validate existence BEFORE listing files ===
                    if (!is_dir($attachmentFolderPath)) {
                        $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => 'folder',
                            'value' => $file_name,
                            'error' => "Folder '{$file_name}' not found in extracted files"
                        ];
                    
                    }
                    // === Get list of files inside folder ===
                    $paths = glob($attachmentFolderPath . DIRECTORY_SEPARATOR . '*');
                    $files = [];
                    if (is_array($paths)) {
                        foreach ($paths as $p) {
                            if (is_file($p)) {
                                $files[] = new \SplFileInfo($p);
                            }
                        }
                    }

                    if (empty($files)) {
                        $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => 'folder',
                            'value' => $file_name,
                            'error' => "Folder '{$file_name}' is empty"
                        ];
                    
                    }
                    else
                    {
                     foreach ($files as $sf) {
                                        
                    /** @var \SplFileInfo $sf */
                    $path     = $sf->getPathname();
                    $basename = $sf->getBasename();
                    $ext      = strtolower($sf->getExtension());
                    $size     = (int) $sf->getSize();

                    // Skip hidden/system files
                    if ($basename[0] === '.' || in_array(strtolower($basename), ['thumbs.db', 'desktop.ini'], true)) {
                        continue;
                    }

                        // --- (Optional) filename character & multiple spaces validation ---
                        $filenameWithoutExtension = pathinfo($basename, PATHINFO_FILENAME);

                        // Allowed: letters, digits, spaces, hyphen, underscore, parentheses, comma, caret
                        if (!preg_match('/^[a-zA-Z0-9()_,^ -]+$/', $filenameWithoutExtension)) {
                            $failedRows[] = [
                                'row'   => $rowNum,
                                'field' => 'filename',
                                'value' => $basename,
                                'error' => "File '{$basename}' in folder '{$file_name}' contains invalid characters. Allowed: letters, numbers, spaces, hyphens (-), underscores (_), parentheses (), commas (,), and ^"
                            ];
                            
                        }

                        if (preg_match('/\s{2,}/', $filenameWithoutExtension)) {
                            $failedRows[] = [
                                'row'   => $rowNum,
                                'field' => 'filename',
                                'value' => $basename,
                                'error' => "File '{$basename}' in folder '{$file_name}' contains multiple consecutive spaces — please use single spaces"
                            ];
                                
                        }

                        if (preg_match('/\.(php\d?|phtml|phar|cgi|pl|sh|exe|bat|cmd|dll|js)(\..+)?$/i', $basename)) {
                        $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => 'filename',
                            'value' => $basename,
                            'error' => "Folder '{$file_name}' Unsafe file extension"
                        ];
                        
                    }

                    $file_extension_arr = explode(".",  $basename);
                    $file_extension = strtolower(end($file_extension_arr));
                    $allowd_filetype = Article_type_advance_options::get_single_record_with_bind_cond('atotp_file_type,atotp_file_description',array("atotp_artp_id"=>$art_typ_id));
                if(isset($allowd_filetype->atotp_file_type)&&!empty($allowd_filetype->atotp_file_type))
                {
                    $allowed_type=json_decode($allowd_filetype->atotp_file_type);
                }
                else
                {
                    $allowed_type=null;
                }
                    
                    if(!empty($allowd_filetype->atotp_file_type))
                    {
                        $extWithDot = (str_starts_with($ext, '.')) ? $ext : '.' . $ext;
                        if(!in_array($extWithDot,$allowed_type))
                        {
                                $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => $file_name,
                            'value' => $basename,
                            'error' => "Folder '{$file_name}' Article type not allowed file type '{$ext}' ( Article type allowed: " . implode(', ', $allowed_type) . ")"
                        ];
                        }
                            

                    $fup_data = File_upload_type::get_single_record_with_bind_cond('fut_id', array("fut_name"=>$file_extension));
                    
                    if(empty($fup_data)&&isset($allowd_filetype->atotp_file_type))
                    {
                            $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => $file_name,
                            'value' => $basename,
                            'error' => "Folder '{$file_name}' Invalid expected file type '{$file_extension}' (allowed: " . implode(', ', $allowed_type) . ")"
                        ];
                    
                    }  
                    }
                


                      }
                    }

                            
        // === If any validation errors exist, log and skip the row ===
                        if (!empty($rowErrors)) {
                    foreach ($rowErrors as $err) {
                        $failedRows[] = [
                            'row'   => $rowNum,
                            'field' => $err['field'],
                            'value' => $err['value'],
                            'error' => $err['error']
                        ];
                    }
                    continue;
                }


                                      
                         
                // === Progress Output ===
                $progress[] = [
                    'status'   => 'progress',
                    'row'      => $processed,
                    'total'    => $rowCount,
                    'analyse' => $analyzeCount
                ];
                echo json_encode(end($progress)) . "\n";
                if (ob_get_level() > 0) ob_flush();
                flush();
            }

            fclose($fileRead);
            $this->deleteDirectory($extractPath);

            // === FINAL RESPONSE ===
            echo json_encode([
                'status'      => 'done',
                'analyse'    => $analyzeCount,
                'total'       => $rowCount,
                'duplicates'  => count($duplicates),
                'failed_data' => $failedRows,
            ]) . "\n";

        } catch (\Exception $e) {

            if (DB::transactionLevel() > 0) DB::rollBack();
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]) . "\n";
        }
    }, 200, [
        'Content-Type'      => 'application/x-ndjson',
        'Cache-Control'     => 'no-cache',
        'X-Accel-Buffering' => 'no'
    ]);
}
public function bulk_article_stream_import(Request $request)
{    
    return new StreamedResponse(function () use ($request) {
        try {
            
            $post_data = $request->all();
            if (empty($post_data['file'])) {
                return $this->warning('Warning',200,'ZIP file not found','Warning');
                //echo json_encode(['status' => 'error', 'message' => 'ZIP file not found']) . "\n";
                //return;
            }

            $currDate       = time();
    
            $this->current_user = $this->get_current_user_details();

            $jnl_id             = decrypt_link($post_data['jnl_id']);
            $email_id           = decrypt_link($post_data['email_template']);
            //$stage_etmp_subject = $post_data['stage_etmp_subject'];
            //$stage_etmp_content = $post_data['stage_etmp_content'];
            $journal_code       = Journals::get_single_record(
                'jnl_journal_code',
                "jnl_id = ? ",
                binding_arr: [$jnl_id]
            )->jnl_journal_code;

            $corerole    = $post_data['corerole'];
            $jnl_setting = Journal_settings::get_single_record_with_bind_cond(
                'jset_date_format,jset_classification,jset_classification_title',
                ["jset_jnl_id" => $jnl_id]
            );
            $jnl_classification = $jnl_setting->jset_classification ?? 'n';

            $art_typ_id      = decrypt_link($post_data['art_typ_id']);
            $article_details = Article_type_advance_options::get_all_records_with_bind_cond('*',array("atotp_artp_id"=>$art_typ_id));
            $title_length    = $article_details[0]->atotp_title_length ?? 250;

            $article_jnlid = Article_types::get_single_record_with_bind_cond(
                'artp_jnl_id, artp_fwm_id, artp_prefix_article_no, artp_abbr_article_type, artp_article_type, artp_es_document_type',array("artp_id"=>$art_typ_id)
            );
          
            // --- ZIP Extract ---
            //$zipFile     = $request->file('file');
                 
            //$zipTempPath = storage_path('app/public/temp_uploads/' . $zipFile->getClientOriginalName());
            $zipTempPath = storage_path('app/public/temp_uploads/' .  $post_data['file']);
           
            $extractPath = storage_path('app/public/extracted_files_' . $currDate);

            File::ensureDirectoryExists(storage_path('app/public/temp_uploads'));
            File::ensureDirectoryExists($extractPath);

          //  $zipFile->move(storage_path('app/public/temp_uploads/'), $zipFile->getClientOriginalName());

            $zip = new \ZipArchive;
            $innerFldrPath  =   '';
            $directoryPath  =   '';
            if ($zip->open($zipTempPath) !== TRUE) {
                $this->write_log_bulkarticle_upload("failed",['error'=>['status' => 'error', 'message' => 'Unable to open ZIP']]);
                // return response()->json(['status' => 'error', 'message' => 'Unable to open ZIP'], 200);
                $this->set_error_response_stream(['status' => 'error', 'message' => 'Unable to open ZIP']);
             
            }
     
            $zip->extractTo($extractPath);
            $zip->close();

          // --- Directories after extract ---
           $directories = File::directories($extractPath);
            if (!empty($directories) && is_iterable($directories)) {
            $innerFldrPath = $directories[0] . "/";
           } else {
             $this->write_log_bulkarticle_upload("Success",['error'=>['status' => 'error', 'message' => 'No inner folder found after extraction']]);
             $this->set_error_response_stream(['status' => 'error', 'message' => 'No inner folder found after extraction']);
          //  echo json_encode(['status' => 'error', 'message' => 'No inner folder found after extraction']) . "\n";
           // return;
           }


            if (!$innerFldrPath) {
                $this->write_log_bulkarticle_upload("Success",['error'=>['status' => 'error', 'message' => 'Unable to extract files']]);
                $this->set_error_response_stream(['status' => 'error', 'message' => 'Unable to extract files']);
               // echo json_encode(['status' => 'error', 'message' => 'Unable to extract files']) . "\n";
                //return;
            }

            $csvfile = $this->findCsvFile($innerFldrPath);
            if (!$csvfile) {
                $this->deleteDirectory($extractPath);
                $this->write_log_bulkarticle_upload("Success",['error'=>['status' => 'error', 'message' => 'CSV file not found in the ZIP']]);
                 $this->set_error_response_stream(['status' => 'error', 'message' => 'CSV file not found in the ZIP']);
               // echo json_encode(['status' => 'error', 'message' => 'CSV file not found in the ZIP']) . "\n";
                //return;
            }

            // --- CSV Read ---
            $sample   = file_get_contents($csvfile);
            $encoding = mb_detect_encoding($sample, ['UTF-8', 'WINDOWS-1252', 'ISO-8859-1', 'ASCII'], true);
            $directoryPath = dirname($csvfile) . DIRECTORY_SEPARATOR;
            $insertedCount = 0;
            $duplicates    = [];

            if (($file_read = fopen($csvfile, 'r')) === false) {
                $this->write_log_bulkarticle_upload("failed",['error'=>['status' => 'error', 'message' => 'Unable to open CSV file']]);
                $this->set_error_response_stream(['status' => 'error', 'message' => 'Unable to open CSV file']);
               // echo json_encode(['status' => 'error', 'message' => 'Unable to open CSV file']) . "\n";
                //return;
            }
             $array_missing_row=array();
            // Count rows
             $rowCount   =   0;
             while (($row = fgetcsv($file_read)) !== false) {
                $rowCount++;
                }
            rewind($file_read);
            $rowCount = max(0, $rowCount - 1);

            /*$maxLmt = Consts::MaxArtImpRowLmt;
            if ($rowCount > $maxLmt) {
                $this->deleteDirectory($extractPath);
                echo json_encode(['status' => 'error', 'message' => "CSV exceeds {$maxLmt} rows"]) . "\n";
                return;
            }*/

            $headers = fgetcsv($file_read);
            if (!$headers || !is_array($headers)) {
                 $this->write_log_bulkarticle_upload("failed",['error'=>['status' => 'error', 'message' => 'CSV has no headers']]);
               // echo json_encode(['status' => 'error', 'message' => 'CSV has no headers']) . "\n";
                //return;
                 $this->set_error_response_stream(['status' => 'error', 'message' => 'CSV has no headers']);
            }
         
          
                        $filtered_headers = array_values(array_filter($headers, function($value) {
                            return !empty($value);
                        }));

                       
                        $keyArr           =   $this->escape_string($filtered_headers);
                        // Convert to lowercase and remove spaces
                        $keys = array_map(function($value) {
                            return strtolower(str_replace(' ', '', $value));
                        }, $keyArr);
        
            // --- Required columns ---
            $requiredKeys = [
                'firstname' => 'First name',
                'lastname'  => 'Last name',
                'email'     => 'Email',
                'title'     => 'Title',
               // 'abstract'  => 'Abstract',
                'folder'    => 'Folder',
            ];
            if ($jnl_classification == 'y') {
                $section_db_ky = strtolower($jnl_setting->jset_classification_title);
                $requiredKeys[$section_db_ky] = $jnl_setting->jset_classification_title ?? 'Section';
            }
        
            $missingKeys = array_diff(array_keys($requiredKeys), $keys);
             $excessKeys = array_diff($keys, array_keys($requiredKeys));
      
            if (!empty($missingKeys)) {
       
                $this->deleteDirectory($extractPath);
                $missingMessages = [];
                foreach ($missingKeys as $key) {
                $missingMessages[] = $requiredKeys[$key];
                 }
                 $status     =   'error';
                 $message    =   "Missing columns in the csv file: " . implode(', ', $missingMessages);
                $this->write_log_bulkarticle_upload("Success",['error'=>['status' => 'error', 'message' => $message]]);

                $this->set_error_response_stream(['status' => 'error', 'message' => 'Missing columns: ' . implode(', ', $missingKeys)]);
                // echo json_encode(['status' => 'error', 'message' => 'Missing columns: ' . implode(', ', $missingKeys)]) . "\n";
               // return;
            }
                         // Then, check for unexpected EXCESS columns
            if (!empty($excessKeys)) {
                    $this->deleteDirectory($extractPath);
                    $excessMessages = [];
                    // If your $requiredKeys array maps to human names, you can't reverse it easily for excess.
                    // So, we just show the technical column names from the CSV.
                    foreach ($excessKeys as $key) {
                        $excessMessages[] = $key;
                    }
                    $status     =   'error';
                    $message    =   "Unexpected columns found in the CSV file: " . implode(', ', $excessMessages);
                    
                    $this->write_log_bulkarticle_upload("failed",['error'=>['status' => 'error', 'message' => $message]]);
                        $this->set_error_response_stream(['status' => 'error', 'message' => $message]);
                    // header('Content-Type: application/json');
                    //echo json_encode(['status' => 'error', 'message' => $message]) ;
                    // return;
           }
        if(empty($missingKeys) && in_array('firstname', $keys) && in_array('lastname', $keys) && in_array('email', $keys)
         && in_array('title', $keys) && in_array('folder', $keys))
        {
            // --- Map header positions ---
            $art_title_ky       = array_search('title', $keys);
        //    $art_abstract_ky    = array_search('abstract', $keys);
            $art_author_email_ky= array_search('email', $keys);
            $auth_fname_ky      = array_search('firstname', $keys);
            $auth_lname_ky      = array_search('lastname', $keys);
            $file_name_ky       = array_search('folder', $keys);
            if ($jnl_classification == 'y') {
                $section_ky = array_search($section_db_ky, $keys);
            }

            $processed = 0;

            if (($file_read = fopen($csvfile, 'r')) !== false) {
                // skip headers
                fgetcsv($file_read);
                $proccessed_array=[];
                while (($row = fgetcsv($file_read)) !== false) {
                    $processed++;

                    if (!is_array($row) || empty($row)) {
                        continue;
                    }

                    if ($encoding !== 'UTF-8') {
                        $row = array_map(fn($v) => preg_replace('/^\xEF\xBB\xBF/', '', mb_convert_encoding($v, 'UTF-8', $encoding)), $row);
                    }

                    try {
                        DB::beginTransaction();

                        $new_values = $this->escape_string($row);
                        
                       // $art_title  = $this->unicode_correction_export(htmlentities(strip_tags($new_values[$art_title_ky] ?? '')));
                        $raw_title = $new_values[$art_title_ky] ?? '';
                        $clean_title = strip_tags($raw_title); // remove HTML
                        $clean_title = html_entity_decode($clean_title, ENT_QUOTES | ENT_HTML5, 'UTF-8'); // decode any HTML entities safely
                        $art_title = $this->unicode_correction_export($clean_title);
                       $art_abs='';
                      //  $art_abs    = $this->unicode_correction_export(htmlentities(strip_tags($new_values[$art_abstract_ky] ?? '')));
                        $auth_email = trim($new_values[$art_author_email_ky] ?? '');
                        $auth_firstname=trim($new_values[$auth_fname_ky] ?? '');
                        $auth_lastname=trim($new_values[$auth_lname_ky] ?? '');
                        $missing_in_row = [];
             
                        foreach ($requiredKeys as $key => $label) {
                        // Find the CSV header position
                        $index = array_search($key, $keys);
                        $value = $new_values[$index] ?? '';
                       
                        if (empty(trim($value))) {
                         
                            $missing_in_row[] = $label; // Use human-readable label
                        }
                        }
                       
// ✅ If any required fields are missing in this row
                        $row_data_processed=$processed+1;
                        if (!empty($missing_in_row)) {
                                $this->write_log_bulkarticle_upload("failed", [
                                        'error' => [
                                        'status'  => 'error',
                                        'row'     => $row_data_processed,
                                        'message' => "Row {$row_data_processed}: missing " . implode(', ', $missing_in_row)
                                     ]
                                 ]);
                                
                                   /* echo json_encode([
                                        'status'  => 'error',
                                    'row'     => $processed,
                                    'message' => "Missing fields: " . implode(', ', $missing_in_row)
                                    ]) . "\n";*/
                                $array_missing_row[] = [
                                 'row' => $row_data_processed,
                                  'missing' => $missing_in_row
                                 ];     
                               // array_push($array_missing_row,"Row {$row_data_processed}: missing " . implode(', ', $missing_in_row));
                                if (ob_get_level() > 0) ob_flush();
                                flush();
                                    continue; // Skip this row
                         }
            
                        $file_name  = trim($new_values[$file_name_ky] ?? '');

                        $sectionExist = true;
                        if ($jnl_classification == 'y') {
                            $section = trim(preg_replace('/[^a-zA-Z0-9\s]/u', '', $new_values[$section_ky] ?? ''));
                            if ($section == "") $sectionExist = false;
                        }

                        if (empty($art_title) || empty($auth_email) || empty($file_name)||!$sectionExist) {
                         //  $this->write_log_bulkarticle_upload("failed",['error'=>['status' => 'error','row' => $processed, 'message' => 'Mandatory fields missing']]);
                           // echo json_encode(['status' => 'error', 'row' => $processed, 'message' => 'Mandatory fields missing']) . "\n";,
                            continue;
                        }
                                   // ✅ Validate email format
                        $validator = Validator::make(
                           ['email' => $auth_email],
                           ['email' => 'required|email']
                             );

                      if ($validator->fails()) {
                        $this->write_log_bulkarticle_upload("failed", [
                                    'error' => [
                                    'status'  => 'error',
                                    'row'     => $processed,
                                    'message' => "Invalid email format: {$auth_email}"
                                   ]
                                 ]);

        

                            if (ob_get_level() > 0) ob_flush();
                            flush();

                            continue; // Skip invalid row
                          }

                        $art_code = $this->create_article_code($art_typ_id);
                               // Task #3027 Fetch the articles for article number re-ordering
                         if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y'){
                         $art_order  =   $this->create_article_order($jnl_id);
                         } else{
                        $art_order  =   0;
                        }
                        $article_data_list = [
                            'art_code'                 => $art_code,
                            'art_chapter_order' => $art_order,
                            'art_artp_id'              => $art_typ_id,
                            'art_title'                => $art_title,
                            'art_abstract'             => $art_abs,
                            'art_stage_submission_method' => 'b',
                            'art_status'               => 'n',
                            'art_title_editable'       => 'n',
                            'art_delete_status'        => 'n',
                            'art_email_template'       => $email_id,
                            'art_proposal_method'      => 'assign'
                        ];

                           // Check for duplicate art_code
                       # $cond1 =    'art_code = "'.$art_code.'"';
                        $existingArticle = Articles::get_single_record_with_bind_cond('art_id',array("art_code"=>$art_code));
                        if (!empty($existingArticle)) {
                            $duplicates[] = $existingArticle->art_id;
                        } else {
                            // --- Handle user ---
                           # $cond2 = 'usr_email="' . $auth_email . '"';
                            $existingUser = User::get_single_record_with_bind_cond('usr_id',array("usr_email"=>$auth_email));

                            if (!empty($existingUser)) {
                                $article_data_list['art_submitted_by'] = $existingUser->usr_id;
                            } else {
                                $username           =   trim($new_values[$art_author_email_ky]);
                                $auth_fname = trim(html_entity_decode($new_values[$auth_fname_ky] ?? '', ENT_QUOTES | ENT_HTML5, 'UTF-8'));

                                $auth_lname = trim( html_entity_decode($new_values[$auth_lname_ky] ?? '', ENT_QUOTES | ENT_HTML5, 'UTF-8')
                                );
                                $is_existing_usrname = User::get_single_record_with_bind_cond('usr_username',array('usr_username'=>$username));
                                if(isset($is_existing_usrname)){
                                $username   = $auth_email;
                                } 
                                $tokenkey   = Str::random(20);
                                $userarr = array('usr_username' => $username,
                                                 'usr_first_name' => $auth_fname,
                                                 'usr_last_name' => $auth_lname,
                                                 'usr_email' => $auth_email,
                                                 'usr_deeplink_token' => $tokenkey,
                                                 'usr_status' =>  'w',
                                                 'usr_operation' => 'b',    //bulk import
                                                 'usr_posted_date' => date('Y-m-d H:i:s')
                                                );
                                $userId     =   User::insert_record($userarr, $this->current_user);

                                $article_data_list['art_submitted_by'] = $userId;
                            }
                            $new_usr_id     =   $article_data_list['art_submitted_by'];
                            $article_id = Articles::insert_record($article_data_list, $this->current_user);
                    
                             if($article_id)
                             {
                            if ($jnl_classification == 'y') {
                                $this->createOrUpdateClassification($section, $jnl_id, $art_typ_id, $article_id);
                            }
                                  $template_condition = array(
                            'stage_etmp_id' => $email_id
                            );
                            $template = Stage_email_templates::get_single_record_with_bind_cond('*',$template_condition);
                            $stage_etmp_subject=$template->stage_etmp_subject??'';
                            $stage_etmp_content=$template->stage_etmp_subject??'';

                                $form_data          =   array('user_id' => encrypt_link($new_usr_id), 'is_title_editable' => 'n', 'hd_art_note_prop_chk' => 'n',
                                                                                'proposal_method' => 'assign', 'article_type' => $art_typ_id, 'articleid' => '', 'art_title' => $art_title,
                                                                                'jnlcode'=>$journal_code, 'email' => $auth_email,  'author_first_name' => '', 'sub' => '',
                                                                                'art_note_prop_chk' => '', 'target_publication_date' => '', 'author_last_name' =>  '', 'corerole' => $corerole,
                                                                                'newuserstatus' =>  '', 'author_email' => '', 'publication_volume' =>  '', 'publication_issue' => '', 
                                                                                'validemail' => '', 'prpsl_note_content' => '', 'article_stage_type' => '', 'email_template' => $email_id,
                                                                                'stage_etmp_subject' => $stage_etmp_subject, 'stage_etmp_content' => $stage_etmp_content, 'note_id' => '', 'hid_usr_id' => '',
                                                                                'propsl_notesto' => array(), 'author_response_due' => null, 'submission_due_date' => null, 'submission_method' =>'b');
                                                                                
                                                    $new_aflw_id        =   $this->article_move_next_stage($article_id, $form_data, $art_typ_id, $article_jnlid, $article_data_list,null);

                                                    $this->save_corr_author($new_usr_id, $article_id);
                                          //* start -- update article uploaded files path*//
                                                    $upload_path = $journal_code . '/' . $article_jnlid->artp_abbr_article_type . '/' . $article_id;
                                                    if (!file_exists(public_path() . '/storage/uploads/' . $upload_path))
                                                    {
                                                        // mkdir(public_path() . '/storage/uploads/' . $upload_path, 0777, true);
                                                       // Storage::makeDirectory(public_path() . '/storage/uploads/' . $upload_path);
                                                    }
                             //art doi
                                                    $doi            = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                                                    $doi_details    = Config::get($doi);
                                                    $doi_data       = $this->create_article_doi($article_id, $doi_details, 'n',$art_code);
                                                    $article_doi    =   $doi_data['doi'];

                                                    Articles::update_record(array(
                                                        'art_article_upload_path' => $upload_path,
                                                        'art_doi' => $article_doi
                                                    ), "art_id={$article_id}",$this->currentuser, '', 'e');
                                                    //* end -- update article uploaded files path*//

                            // --- Attachments ---
                                                  
                                                    $tabarray = 'clients.' . $this->current_client->clnt_client_code . '.tabconfig';
                                                    $art_submission_tab_arr = Config::get($tabarray);
                                                    $art_submission_tab = array();
                                                    $article_tab_details    =   Article_tab_status::get_all_records_with_bind_cond('*',array("tab_status_art_id"=>$article_id));


                                                    if(count($article_tab_details)>0) {
                                                        foreach ($art_submission_tab_arr as $art_tab_key => $art_tab_val)
                                                        {
                                                            $art_submission_tab["$art_tab_key"] = $art_tab_val;
                                                        }
                                                        Article_tab_status::update_record(array("tab_status_array" => json_encode($art_submission_tab)),"tab_status_art_id={$article_id}", $this->currentuser);
                                                    } else {
                                                        $art_submission = array();
                                                        foreach ($art_submission_tab_arr as $art_tab_key => $art_tab_val) {
                                                            if ($art_tab_key == "tab_article_details" || $art_tab_key == "tab_co_author") {
                                                                //initially it set to p
                                                                //$art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "c" : "p";
                                                                $art_submission["$art_tab_key"] = $art_tab_key == "tab_article_details" ? "p" : "";
                                                            } else {
                                                                $art_submission["$art_tab_key"] = $art_tab_val;
                                                            }
                                                        }
                                                        $tab_data['tab_status_art_id'] = $article_id;

                                                        if ($article_details[0]->atotp_suggest_reviewers == 'n' && $article_details[0]->atotp_oppose_reviewers == 'n') {
                                                            unset($art_submission['tab_review_preference']);
                                                        }
                                                        $tab_data["tab_status_array"] = json_encode($art_submission);
                                                        Article_tab_status::insert_record($tab_data, $this->currentuser);
                                                    }
                                                    
                            
                                                    // insert to rvw_article_attachments
                                                    // Define the folder path based on the art_code
                                                    $attachmentFolderPath = $directoryPath.$file_name;
                                                    // Check if the folder exists
                                                    if (File::exists($attachmentFolderPath) && File::isDirectory($attachmentFolderPath)) 
                                                    {
                                                        // Get all files inside the folder
                                                        $files = File::files($attachmentFolderPath);
                                                        // Convert the SplFileInfo objects to file names
                                                        // $fileNames = array_map(fn($file) => $file->getFilename(), $files);
                                                        $fileNames = array_map(fn($file) => [
                                                            'name' => $file->getFilename(),
                                                            'path' => $file->getPathname(),
                                                            'size' => $file->getSize() // Size in bytes
                                                        ], $files);

                                                        foreach($fileNames as $fn)
                                                        {
                                                            $update_attachment_table_array  =   array();
                                                            $attch_files  =   array();
                                                            $path = $fn['path'];
                                                            $fle = new SymfonyFile($path);
                                                            $attachment_file = new UploadedFile(
                                                                $fle->getPathname(), // The full path to the file
                                                                $fle->getFilename(), // The original file name
                                                                $fle->getMimeType(), // The mime type of the file
                                                                0, // The error code (UPLOAD_ERR_OK)
                                                                true // Whether the test mode is enabled (skip move verification)
                                                            );
                                                           
                                                            $uploaded = $this->upload_file_handler($upload_path, $attachment_file, $fn['name']);
                                                            $fn['name'] = $uploaded['name'];
                                                            $attch_files[] = array(
                                                                'filename' => $fn['name'],
                                                                'filepath' => $fn['path'],
                                                                'filesize' => $fn['size']
                                                            );
                                                            $allowd_filetype = Article_type_advance_options::get_single_record_with_bind_cond('atotp_file_type,atotp_file_description', array("atotp_artp_id"=>$art_typ_id));
                                                            $file_description_data = Required_file_type::get_all_records_with_bind_cond('*', array("rft_artp_id"=>$art_typ_id));
                                                            $file_description = array();
                                                            $file_description_arr = array();
                                                            if (!empty($file_description_data)) {
                                                                foreach ($file_description_data as $fd) {
                                                                    array_push($file_description_arr, $fd->rft_file_desp_id);
                                                                }
                                                                $file_description = implode(',', $file_description_arr);
                                                            }
                                                            $allowd_filetype->description = $file_description;
                                                            $update_attachment_table_array['attach_file'] = $attch_files;
                                                            $update_attachment_table_array['article_id'] = $article_id;
                                                            $update_attachment_table_array['article_type_id'] = $art_typ_id;
                                                            $update_attachment_table_array['allowed_file_type'] = $allowd_filetype;
                                                            $update_attachment_table_array['article_type_code'] = $article_jnlid->artp_abbr_article_type;
                                                            $update_attachment_table_array['article_upload_path'] = $upload_path;
                                                            $update_attachment_table_array['artflow_id'] = $new_aflw_id;
                                                            $update_attachment_table_array['article_editable'] = false;
                                                            $update_attachment_table_array['author_attachment'] = true;
                                                            $update_attachment_table_array['platform_code'] = $journal_code;


                                                            (new Manage_Article_Submission_Api)->update_to_attachment_table($update_attachment_table_array);
                                                        }
                                                    }
                            $insertedCount++;
                                    }
                        }

                        DB::commit();
                    } catch (\Exception $ex) {
                        if (DB::transactionLevel() > 0) DB::rollBack();
                          $this->write_log_bulkarticle_upload("failed",['status' => 'error', 'row' => $processed, 'message' => $ex->getMessage()]);
                        echo json_encode(['status' => 'error', 'row' => $processed, 'message' => $ex->getMessage()]) . "\n";
                    }
                    array_push($proccessed_array, [
                         'status'   => 'progress',
                         'row'      => $art_code,
                         'total'    => $rowCount,
                         'inserted' => $insertedCount
                         ]);
                    echo json_encode([
                        'status'   => 'progress',
                        'row'      => $processed,
                        'total'    => $rowCount,
                        'inserted' => $insertedCount
                    ]) . "\n";
              
                    if (ob_get_level() > 0) ob_flush();
                    flush();
                }
            }
        }
            fclose($file_read);
            $this->deleteDirectory($extractPath);
            $this->write_log_bulkarticle_upload("Success",['success'=>$proccessed_array]);
            echo json_encode([
                'status'    => 'done',
                'inserted'  => $insertedCount,
                 'total'    => $rowCount,
                'duplicates'=> count($duplicates),
                'failed_data'=>$array_missing_row
            ]) . "\n";

        } catch (\Exception $e) {
            if (DB::transactionLevel() > 0) DB::rollBack();
             $this->write_log_bulkarticle_upload("Success",['success'=>'']);
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]) . "\n";
        }
    }, 200, [
        'Content-Type'      => 'application/x-ndjson',
        'Cache-Control'     => 'no-cache',
        'X-Accel-Buffering' => 'no'
    ]);
}


  public function write_log_bulkarticle_upload($type,$array_data)
  {
    
    Log::channel('bulk_article_upload')->info($type,$array_data);
  }
public function set_error_response_stream($response)
{
    // Make sure no previous output is buffered
    while (ob_get_level() > 0) {
        ob_end_clean();
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit; // stop execution here
}
    public function deleteDirectory($dir) {
        if (!is_dir($dir)) {
            return false;
        }
    
        $files = array_diff(scandir($dir), ['.', '..']);
    
        foreach ($files as $file) {
            $filePath = "$dir/$file";
            if (is_dir($filePath)) {
                $this->deleteDirectory($filePath); // Recursively delete subdirectory
            } else {
                unlink($filePath); // Delete file
            }
        }
    
        return rmdir($dir); // Now remove the empty directory
    }

    /*
    *  Send article assignment
    */
    public function send_author_assignment(Request $request) 
    {
        try {
            $post_data = $request->all();
            $is_proceeding=$this->check_client_proceeding();
            $article_set = $post_data['article_set'];
            $type = isset($post_data['type']) ? $post_data['type'] : '';
            $return_data['status'] = 'failed';
            $return_data['msg'] = 'invalid access';
            $jnl_id=$this->decrypt_data($post_data['jnl_id']);
            $jnl_code=$post_data['jnl_code'];
            $core_role=$post_data['core_role'];
            $this->currentuser = $this->get_current_user_details();
            $optccvalue = array();
            if (isset($post_data['postdata']['stage_cust_cc'])) {
                $custm_cc = $post_data['postdata']['stage_cust_cc'];
                for ($i = 0; $i < count($custm_cc); $i++) {
                    $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                    $cust_value = str_replace('\\', '"', $cust_value);
                    $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);
                    array_push($optccvalue, $cust_value);
                }
                $post_data['postdata']['stage_cust_cc'] = implode(',', $optccvalue);
            }
            else{
                $post_data['postdata']['stage_cust_cc']='';
            }
            $optbccvalue = array();
            if (isset($post_data['postdata']['stage_cust_bcc'])) {
                $custm_bcc = $post_data['postdata']['stage_cust_bcc'];
                for ($i = 0; $i < count($custm_bcc); $i++) {
                    $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
                    $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
                    $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);
                    array_push($optbccvalue, $cust_bcc_value);
                }
                $post_data['postdata']['stage_cust_bcc'] = implode(',', $optbccvalue);
            }
            else{
                $post_data['postdata']['stage_cust_bcc']='';
            }
            $invitation_send = false;
            $invitation_send_fail = false;
            $current_stage_ids = array();

            $date_format = $this->get_platform_date_format($jnl_id);
            $date_format= date_format_map($date_format);

            $art_codes = array();
            $no_attachments     =   array();
            foreach ($article_set as $article) {
                $expired_status = $article['expired_status'];
                $art_id = $this->decrypt_data($article['art_id']);
                $article_code = Articles::get_single_record('art_code', "art_id='{$art_id}'");
                if($expired_status == 'y') {
                    $art_code[] =$article_code->art_code;
                    $art_codes = implode(', ',$art_code);
                } else {
                    $article_attchment_cnt = Attachment_files::get_single_record('count(atmnt_id) as count', "atmnt_art_id={$art_id}");
                    if($article_attchment_cnt->count == 0 && $is_proceeding == true) {
                        $no_attachments[]   =   "'".$article_code->art_code."'";
                    }
                }
            }
            
            $string_version     =   '';
            if (!empty($no_attachments)) {
                if (count($no_attachments) > 1) {
                    $last_item = array_pop($no_attachments); // Remove and store the last item
                    $string_version = implode(', ', $no_attachments) . ' and ' . $last_item;
                } else {
                    $string_version = implode('', $no_attachments); // Handle single-item case
                }

                if( $string_version != '') {
                    $return_data['status'] = 'error';
                    $return_data['msg'] = 'Attachments are missing for the articles '.$string_version.'. Please upload the required attachments.';
                    return  $this->failure('Failed', 201, $return_data);
                }
            }

            if($art_codes == null) 
            {
                $no_attachments     =   [];
                foreach ($article_set as $article) 
                {
                    $art_id = $this->decrypt_data($article['art_id']);
                    $new_aflw_id = $this->decrypt_data($article['aflw_id']);
                    $user_id = $this->decrypt_data($article['user_id']);
                    $stage_etmp_id = $this->decrypt_data($article['stage_etmp_id']);
                    $current_stage_id = $new_aflw_id;  

                    $aflw_deeplink_token = Str::random(16);
                    $condition =  array("aflw_usr_id"=>$user_id, "aflw_id" => $current_stage_id );
                    $current_aflw_id_rec = Article_flow::get_single_record_with_bind_cond('aflw_id,aflw_deeplink_token,DATE_FORMAT(aflw_due_date, "' . $date_format . '") as aflw_due_date', $condition);


                    if(!empty($current_aflw_id_rec))
                    {
                        $aflw_deeplink_token = ($current_aflw_id_rec->aflw_deeplink_token != '' ) ? $current_aflw_id_rec->aflw_deeplink_token : $aflw_deeplink_token;

                        $current_aflw_id = $current_aflw_id_rec->aflw_id;
                        $select = 'art_id, art_code, art_artp_id, art_title, artp_article_type, jnl_journal_name, jnl_journal_type, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
                        $article_details = Articles::get_article_details($select,"aflw_id='{$current_aflw_id}'");

                        $article_details = $article_details[0];
                        $article_set = array(
                                        'art_code' => $article_details->art_code,
                                        'art_id' => $article_details->art_id,
                                        'artp_id' => $article_details->art_artp_id,
                                        'aflw_id'=>$article_details->aflw_id,
                                        'user_id' =>$user_id,
                                        'stage_etmp_id' =>  $stage_etmp_id,
                                        'expired_status' => ''
                                    );
                        $post_data['article_set'][] = $article_set;
                        $template = null;
                        $attachments = $files_attached = array();
                        if (isset($stage_etmp_id) && $stage_etmp_id !== null) 
                        {
                            $template_condition = array(
                            'stage_etmp_id' => $stage_etmp_id,
                            'stage_etmp_action' => "assigned"
                            );
                            $template = Stage_email_templates::get_single_record_with_bind_cond('*, stage_etmp_content AS stage_etmp_email_template',$template_condition);
                            //Task #3960 Updated Assignment Email Not Triggering in Bulk Assignment
                            $article_notification_condition = array(
                            'ane_stage_etmp_id' => $stage_etmp_id,
                            'ane_art_id' => $article_details->art_id,
                            'ane_aflw_id' => $article_details->aflw_id
                        );
                         $article_notification = Article_notification_emails::get_single_record_with_bind_cond('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',$article_notification_condition);
                            $cc_list = [];
                            $bcc_list = [];

                            if (!empty($article_notification)) {
                               
                                $template->stage_etmp_subject   = $article_notification->ane_subject;
                                $template->stage_etmp_content   = $article_notification->ane_content;
                                $template->stage_etmp_cust_cc   = $article_notification->ane_cust_cc;
                                $template->stage_etmp_cust_bcc  = $article_notification->ane_cust_bcc;
                                $template->stage_template_to_cc  = $article_notification->ane_cc;
                                $template->stage_template_to_bcc  = $article_notification->ane_bcc;
                                if (!empty($article_notification->ane_cc)) {
                                    $cc_list  = json_decode($article_notification->ane_cc, true);
                                    $cc_list  = is_array($cc_list) ? $cc_list : [];
                                }

                                if (!empty($article_notification->ane_bcc)) {
                                     $bcc_list  = json_decode($article_notification->ane_bcc, true);
                                     $bcc_list  = is_array($bcc_list) ? $bcc_list : [];
                                }

                            } else {
                               
                            $cc_list=$post_data['postdata']['stage_template_to_cc']??[];
                            $bcc_list= $post_data['postdata']['stage_template_to_bcc']??[] ;
                            $template->stage_etmp_cust_cc= $post_data['postdata']['stage_cust_cc']??[];
                            $template->stage_etmp_cust_bcc=$post_data['postdata']['stage_cust_bcc']?? [];
                               
                              
                            }
                      
                            $post_data['postdata']['stage_cust_cc']  = $template->stage_etmp_cust_cc ?? [];
                            $post_data['postdata']['stage_cust_bcc'] = $template->stage_etmp_cust_bcc ?? [];
                            $post_data['postdata']['stage_template_to_cc']  = $cc_list;
                            $post_data['postdata']['stage_template_to_bcc'] = $bcc_list;
                           
                            if (!empty($article_notification)) {
                                $email_attachments = $this->get_invite_email_attachments(
                                    $article_details->art_id,
                                    $article_notification->ane_id,
                                    false
                                );

                                if (!empty($email_attachments)) {
                                    $attachments = $email_attachments['attachments'];
                                    $files_attached = $email_attachments['files_attached'];
                                }
                            }
                        }

                        if ($template !== null) 
                        {
                            $today = date('Y-m-d H:i:s', time());
                            $data['aflw_deeplink_token'] = $aflw_deeplink_token;
                            $data['aflw_decline_clk_count'] = 0;
                            $data['aflw_accept_clk_count'] = 0;
                            $data['aflw_assigned_date'] = $today;
                            $data['aflw_accepted_date'] = $today;

                            if($current_aflw_id_rec->aflw_due_date == null || $current_aflw_id_rec->aflw_due_date == '')
                            $data['aflw_due_date'] = date('Y-m-d H:i:s', strtotime('+5 days')); // 5days for aipp
                            $data['aflw_status'] = 'a';
                            $update_status_condition = array(
                                'aflw_usr_id' => $user_id,
                                'aflw_id' => $current_stage_id
                            );
                            Article_flow::update_record($data,$update_status_condition,$this->currentuser);

                            /*if the author doesnt have a role in journal level then insert the role*/
                            $author_role_id = $article_details->jwf_role_id;
                            $user_role_details = array(
                                'usrj_jnl_id' => $jnl_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $author_role_id,
                                'usrj_artp_id' => null
                            );
                            $jnl_author_record = User_to_journals::get_single_record_with_bind_cond('usrj_id', $user_role_details);
                            if ($jnl_author_record === null)
                            {
                                $user_role_details = array(
                                    'usrj_jnl_id' => $jnl_id,
                                    'usrj_usr_id' => $user_id,
                                    'usrj_role_id' => $author_role_id,
                                    'usrj_artp_id' => null,
                                    'usrj_invite' => 'n',
                                );
                                User_to_journals::insert_record($user_role_details, $this->currentuser);
                            }

                            $artp_user_role_details = array(
                                'usrj_jnl_id' => $jnl_id,
                                'usrj_usr_id' => $user_id,
                                'usrj_role_id' => $author_role_id,
                                'usrj_artp_id' => $article_details->art_artp_id
                            );

                            $artyp_author_record = User_to_journals::get_single_record_with_bind_cond('usrj_id', $artp_user_role_details);
                            if ($artyp_author_record === null)
                            {
                                $artp_user_role_details = array(
                                        'usrj_jnl_id' => $jnl_id,
                                        'usrj_usr_id' => $user_id,
                                        'usrj_role_id' => $author_role_id,
                                        'usrj_artp_id' => $article_details->art_artp_id,
                                        'usrj_invite' => 'n',
                                        );
                                User_to_journals::insert_record($artp_user_role_details,$this->currentuser);
                            }

                            $author_role = Roles::get_single_record('role_id', 'role_assigned_role = "author" and FIND_IN_SET("r", role_used_in)');
                            $role_id = $author_role->role_id;

                            $custom_data=array(
                                            'link'=> '',
                                            'accept_link'=> '',
                                            'reject_link'=> '',
                                            'email_id'=>'proposal',
                                            'article_id'=>$art_id,
                                            'artp_id'=>$article_details->art_artp_id,
                                            'jnl_id'=>$jnl_id,
                                            'jnl_code'=>$jnl_code,
                                            'aflw_id'=> $article_details->aflw_id,
                                        );

                            $post_data['jnl_code'] =$jnl_code;
                            $post_data['jnl_id'] =$this->encrypt_data($jnl_id);
                            if(isset($attachments)){
                            $post_data['postdata']['attachments'] = $attachments;
                            $post_data['postdata']['files_attached'] = $files_attached;
                                }

                            if($type !='' && $type == 'multiinvite')
                            {
                                $post_data['postdata']['stage_template_sub'] =$template->stage_etmp_subject ;
                                $post_data['postdata']['stage_template_content'] =$template->stage_etmp_content;
                            }

                            $replace_button = array('<button contenteditable="false">', '</button>');
                            $replaceval = str_replace($replace_button, '##', $post_data['postdata']['stage_template_content']);
                            $post_data['postdata']['stage_template_content'] = $replaceval;

                            $condition = 'usr_id ='.$user_id;
                            $get_user_data = User::get_single_record('*',$condition);                            
                            if(!empty($get_user_data) && isset($get_user_data->usr_status) && $get_user_data->usr_status == 'w') {
                                $this->create_user_email($get_user_data, $this->currentuser);
                            }
                            $email_data=array(
                                            'type'=>'custom',
                                            'action'=>'send',
                                            'email_with_login'=>false,
                                            'article_id'=>$art_id,
                                            'user_id'=> $user_id,
                                            'aflw_id'=> $article_details->aflw_id,
                                            'post_data'=>$post_data,
                                            'aflw_deeplink_token'=>$aflw_deeplink_token,
                                            'role_id'=>$role_id,
                                            'template'=> $template,
                                            'jnl_id'=> $jnl_id,
                                            'custom_data'=>$custom_data,
                                            'jnl_user_role'=>array(
                                            'core_role'=>$post_data['core_role'],
                                            // 'role_name'=>$jnl_array['role_name'],
                                            'jnl_id'=> $jnl_id,
                                            'jnl_journal_code'=> $jnl_code
                                            ),
                                        );
                            $this->master_email_details($email_data);

                            $invitation_send = true;
                            $current_stage_ids[] = $current_stage_id;
                            $submittion_date[encrypt_link($art_id)] = $current_aflw_id_rec->aflw_due_date;
                        }
                    }
                    else {
                        $invitation_send_fail = true;
                    }
                }
                if($invitation_send_fail === true)
                {
                    $return_data['status'] = 'invitation_error';
                    $return_data['msg'] = 'Shortlist user details not exists';
                    return  $this->failure('Failed', 500, $return_data);
                }
                $invited_usrs = Article_flow::get_single_record('count( DISTINCT aflw_usr_id) as cnt ', "aflw_id IN (" . implode(',',$current_stage_ids) . ") AND aflw_status = 'u'");
                $return_data['invite_complete'] = false;
                if ($invited_usrs->cnt == 0)
                {
                    $return_data['invite_complete'] = true;
                }
                if ($invitation_send === true) {
                    $return_data['msg'] = 'User assigned successfully';
                    $return_data['status'] = 'success';
                } else {
                    $return_data['status'] = 'tmpl_err';
                    $return_data['msg'] ='You have not defined any email templates';
                }
            }
            else {
                $return_data['status'] = 'invitation_error';
                $return_data['msg'] = customTrans('Assignment due date has expired for the following :articles <br>').$art_codes;
            }
            return  $this->success('Success', 201, $return_data);
        } catch (\Exception $e) {
            $this->customErrorAction('author_invitation_history',$e);
            return $this->failure('Failed', 500, $e);
        }
    }

    public function notify_user_in_journal(Request $request) {
        try {
        $form_data = $request->all();
        $jnl_id     =   decrypt_link($form_data['jnl_id']);
        $journal_code     =   decrypt_link($form_data['journal_code']);
        $role_ids     =   decrypt_link($form_data['role_ids']);
        $user_id     =   decrypt_link($form_data['user_id']);
        $user_email     =   decrypt_link($form_data['user_email']);
        $user_data = $this->get_current_user_details();
        // Task #3890 Organizer email no edited content is sent start
        $etmp_name = 'send_notification_to_organiser'; /*Task #1897 Seperate email template for invitation of organizers */
        $criteria = "etmp_name = '{$etmp_name}' AND etmp_notification = 'User'";
            $email_template_data = Email_templates::get_single_record('*', $criteria);
            if (!empty($email_template_data)) {
                // eventhough the checkbox is checked, we should check whether there is any email template for this purpose
                // Task #3791 save a record in events table when notifing a organizer or a cp team member 
                $this->save_event_details($user_id, $jnl_id, 'Notify organizers', $user_email);     

                $usrj_invite = 'y';
            
                $this->current_user = $this->get_current_user_details();
                $artp_id     =   isset($form_data['artp_id'])?decrypt_link($form_data['artp_id']):'';
                $form_data['jnl_code']=  decrypt_link($form_data['journal_code']);
                $email_template_data->etmp_subject    =   $form_data['stage_etmp_subject'];
                $email_template_data->etmp_email_template =  $form_data['stage_etmp_content'];
                $email_template_data->etmp_cc= '';
                $email_template_data->etmp_bcc= '';
                if (isset($form_data['stage_template_to_cc']) && !empty($form_data['stage_template_to_cc']) && $form_data['stage_template_to_cc'] != 'undefined' && $form_data['stage_template_to_cc'] != '[]') {
                    $cc_data = is_string($form_data['stage_template_to_cc']) ? json_decode($form_data['stage_template_to_cc'], true) : $form_data['stage_template_to_cc'];
                    if (is_array($cc_data)) {
                        $email_template_data->etmp_cc = json_encode($cc_data); 
                    } else {
                        $email_template_data->etmp_cc= json_encode([$cc_data]); 
                    }
                }
                if (isset($form_data['stage_template_to_bcc']) && !empty($form_data['stage_template_to_bcc']) && $form_data['stage_template_to_bcc'] != 'undefined' && $form_data['stage_template_to_bcc'] != '[]') {
                    $bcc_data = is_string($form_data['stage_template_to_bcc']) ? json_decode($form_data['stage_template_to_bcc'], true) : $form_data['stage_template_to_bcc'];
                    if (is_array($bcc_data)) {
                        $email_template_data->etmp_bcc = json_encode($bcc_data);
                    } else {
                        $email_template_data->etmp_bcc = json_encode($bcc_data);
                    }
                }
                $post_stage_cust_cc=isset($form_data['stage_cust_cc'])?$form_data['stage_cust_cc']:'';
                $post_stage_cust_bcc=isset($form_data['stage_cust_bcc'])?$form_data['stage_cust_bcc']:'';
                $get_formated_custom_cc_bcc=$this->get_specific_cc_bcc_values($post_stage_cust_cc,$post_stage_cust_bcc);
                if(isset($get_formated_custom_cc_bcc['cust_cc'])&&$get_formated_custom_cc_bcc['cust_cc']!=NULL)
                {$email_template_data->etmp_cust_cc=$get_formated_custom_cc_bcc['cust_cc'];}
                if(isset($get_formated_custom_cc_bcc['cust_bcc'])&&$get_formated_custom_cc_bcc['cust_bcc']!=NULL)
               {
                $email_template_data->etmp_cust_bcc=$get_formated_custom_cc_bcc['cust_bcc'];
               }
                $user_data = User::get_single_record('usr_email,concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $user_id);
                $email_data = new stdClass();
                $email_data->user_id = $user_id;
                $email_data->user_email = $user_data->usr_email;
                $email_data->mail_recipient_ids = $user_id;
                $email_data->artp_id = $artp_id;
                $email_data->jnl_id = $jnl_id;
                $email_data->jnl_journal_code = $journal_code;
                $email_data->email_templates_config = $this->email_templates_config();
                if (isset($this->current_client->functionality->cfty_article_authors_tag) && $this->current_client->functionality->cfty_article_authors_tag == 'y')
                    $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                $email_data->join_config = $this->join_config();
                $email_data->join_dependency_config =$this->join_dependency_config();
                $email_data->user_role_tags = $this->user_role_tags();
                $user_titles =  $this->UserConfigdata('titles')['titles'];
                $replace_button = array('<button contenteditable="false">', '</button>');
                $replaceval = str_replace($replace_button, '##', $email_template_data->etmp_email_template);
                $email_template_data->etmp_email_template = $replaceval;
                $email_template_data->etmp_email_template   = $this->generate_email_data_from_keys($email_data, $email_template_data->etmp_email_template , $this->current_user, $user_titles);
                $email_template_data->etmp_subject  = $this->generate_email_data_from_keys($email_data, $email_template_data->etmp_subject  ,  $this->current_user, $user_titles);
                $reply_to = '';
                $reply_to=$this->get_reply_to_email($jnl_id);
                if (isset($reply_to) && $reply_to != '')
                {$email_data->reply_to = $reply_to;}
                $email_data->esl_etmp_action = 'send_notification_to_organiser';
                $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
                if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                    $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
                    $data = array(
                        'record' => $email_template_data,
                        'email_data' => $email_data,
                        'user_data' =>$this->current_user,
                        'column_prefix' =>'etmp_',
                    );
                    $this->notify_mail($data);
                // Task #3890 Organizer email no edited content is sent end

        }
        $return_data['status'] = 'success';
        $return_data['msg'] = 'Mail sent successfully';

        return  $this->success('Success', 201, $return_data);
        } catch (\Exception $e) {
            $this->customErrorAction('author_invitation_history',$e);
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
	* Task #3791 save a record in events table when notifing a organizer or a cp team member 
	*/
    public function save_event_details($user_id, $jnl_id, $event_str, $user_email) {
        try {
            $events_table   =   (new \App\Models\Events_model())->getTable();
            $sel_sql1		=	"SELECT event_id FROM ".$events_table." WHERE event_name='".$event_str."'";
            $results1 		= 	Events_model::get_records_by_raw_query($sel_sql1);
            $event_id       =   '';

            if (!empty($results1)) {
                $event_id   =   $results1[0]->event_id;
                $user_data  =   $this->get_current_user_details();

                if($event_id != '')
                {
            $email_already_exists    =   Event_invited_users::get_single_record_with_bind_cond('count(evu_id) as cnt', array('evu_jnl_id' =>$jnl_id, 'evu_user_id'=>$user_id, 'evu_submit_status' => 'i'));
                    if($email_already_exists->cnt == 0) 
                    {            
                $data_list   =   array(
                                'evu_jnl_id' => $jnl_id,
                                        'evu_event_id' => $event_id,
                                'evu_user_id' => $user_id,
                                'evu_user_email' => $user_email,
                                'evu_submit_status' => 'i'
                            );
                            
                Event_invited_users::insert_record($data_list,$user_data);
            }
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    * WHen a organizer completed uploading the articles, he needs to inform the CP team member to start assigning the articles
    * IN conference proceedings
    */
    public function send_notification_mail(Request $request) {
        try {
        $form_data  = $request->all();
        $jnl_id     =   decrypt_link($form_data['jnl_id']);
        $user_data  = $this->get_current_user_details();
        // Task #3563 Collecting Supporting Documents for Conference
        $validform=$this->validate_supportingdataforms($jnl_id);
        if($validform===false) {
            $res['msg']=customTrans('customform.supportingform-req-fill');            
            return  $this->warning('Warnings',200,$res,'warning');
        }
        
        $etmp_name = 'send_notification_to_user';
        $criteria = "etmp_name = '{$etmp_name}' AND etmp_platform = 'g'";
        $email_tmpls = Email_templates::get_single_record('*', $criteria);
        
        if ($email_tmpls != null) { 
            // Task #3791 save a record in events table when notifing a organizer or a cp team member 
            $journal_user_sql   =   "SELECT distinct
                                        `usrj_usr_id`, `usr_email`
                                    FROM
                                        `rvw_user_journals`
                                    JOIN rvw_roles ON (`usrj_role_id` = role_id)
                                    JOIN rvw_users ON (`usrj_usr_id` = usr_id)
                                    WHERE
                                        role_assigned_role = 'staff' and role_name ='CP Team member' 
                                        AND usrj_role_retired = 'n' AND `usrj_jnl_id` = $jnl_id";
            $staff_role_ids= Roles::get_records_by_raw_query($journal_user_sql);

            $journal_code = Journals::find($jnl_id, ['jnl_journal_code'])?->jnl_journal_code;

            $custom_data = array(
                'esl_etmp_action' => 'notify_staff_in_conference',
                'jnl_id' => $jnl_id,
                'jnl_code' => $journal_code,
                'user_id' => $user_data['user_id']
            );
            if(count($staff_role_ids) > 0) {
                foreach($staff_role_ids as $key){
                    $usrj_usr_id    =   $key->usrj_usr_id;
                    $user_email     =   $key->usr_email;
                    // Task #3791 save a record in events table when notifing a organizer or a cp team member 
                    $this->save_event_details($usrj_usr_id, $jnl_id, 'Notify cp_team_members', $user_email);   

                    $email_data = array(
                        'type' => 'global',
                        'action' => 'send',
                        'email_with_login' => true,
                        'user_id' => $usrj_usr_id,
                        'empt_name' => $etmp_name,
                        'custom_data' => $custom_data,
                    );
                    $this->master_email_details($email_data);
                }
            }
        }
        $return_data['status'] = 'success';
        $return_data['msg'] = 'Email sent to CP team members successfully';

        return  $this->success('Success', 201, $return_data);
        } catch (\Exception $e) {
            $this->customErrorAction('author_invitation_history',$e);
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    * Function to find the csv file in main folder or sub folders
    * returns null if not found, and returns the path if csv found
    */
    public function findCsvFile($folderPath) {
        $csvFile = null;
    
        // Open the directory
        if ($dh = opendir($folderPath)) {
            while (($fileName = readdir($dh)) !== false) {
                // Skip "." and ".." entries
                if ($fileName == '.' || $fileName == '..') {
                    continue;
                }
    
                // Get the full path
                $filePath = $folderPath . $fileName . '/';
    
                // Check if it's a directory - search recursively
                if (is_dir($filePath)) {
                    $csvFile =$this->findCsvFile($filePath);
                    if ($csvFile) {
                        $csvFile     =   rtrim($csvFile, '/');
                        return $csvFile; // CSV found in subdirectory
                    }
                }
    
                // Check if it's a CSV file
                if (strtolower(pathinfo($fileName, PATHINFO_EXTENSION)) === 'csv') {
                    $filePath     =   rtrim($filePath, '/');
                    return $filePath; // Return the first CSV found
                }
            }
            closedir($dh);
        }
        return null; // No CSV found
    }

    /*
    * Notify user email preview
    * When a organizer is added in a conference, a email has to be send to the user
    *
    * Organizer notify cp team member email preview
    * When a organizer created articles in a conference, he should send a notification to cp team memebr for assigning
    */
    public function preview_notify_user_in_journal(Request $request) {
        try {
            $current_user =   $this->get_current_user_details();

            $Email_templates    =   new \App\Models\Email_templates();
            $Roles              =   (new \App\Models\Roles());
            $post_data          =   $request->all();

            $validator = Validator::make($request->all(), [
				'jnl_code' => 'required',
				'jnl_id' => 'required',
				'user_id' => 'required',
				'tmp_name' => 'required',
			]);
            
			if ($validator->fails()) {
				return $this->failure('Failed', 422, $validator->errors());
			}

            $jnl_id         = isset($post_data['jnl_id']) ? decrypt_link($post_data['jnl_id']): '';
            $user_id        = isset($post_data['user_id']) ? decrypt_link($post_data['user_id']): '';
			$journal_code   = isset($post_data['jnl_code']) ? decrypt_link($post_data['jnl_code']): '';
			$tmp_name       = isset($post_data['tmp_name']) ? decrypt_link($post_data['tmp_name']): '';
            if($tmp_name == 'journal_invitation') {
                $roleName = 'Organizer';    //Task #4018 organiser renamed to organizer
            }
            elseif($tmp_name == 'send_notification_to_user') {
                $roleName = 'CP Team member';
                /*Task #1897 Seperate email template for invitation of organizers */
            }elseif($tmp_name == 'send_notification_to_organiser') {
                $roleName = 'Organizer';    //Task #4018 organiser renamed to organizer
                /*end Task #1897 Seperate email template for invitation of organizers */
            }
            
            $select         =   "email_hooks";
            $email_hooks    =   $this->Utility($select);
            // 'journal_invitation' notify organizer
            // 'send_notification_to_user' notify cp team mmember
            $hook_data      =   $email_hooks['email_hooks'][$tmp_name];
            $user_roles     =   array();
            $recipient_roles=   array();
            $hook_recipient =   $hook_data['to'];
        
            $criteria       =   'role_assigned_role != "system"';
            $roles          =   $Roles::get_all_records('*', $criteria);
            if(isset($this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users) && $this->current_client->functionality->cfty_restrict_cc_bcc_from_privileged_users=='n')
            { // Task #3890 Organizer email no edited content is sent 
            if (!empty($roles)) {
                foreach ($roles as $usrole) {
                    $usrole->role_label = "";
                    if ($usrole->role_assigned_role != 'author' and $usrole->role_assigned_role != 'system') {
                        $usrole->role_label = "All " . $usrole->role_name . "s";
                    } 
                    else if ($usrole->role_assigned_role == 'author') {
                        $usrole->role_label = 'Corresponding Author';
                    } else {
                        $usrole->role_label = $usrole->role_name;
                    }
                    if(strtolower($usrole->role_name) != strtolower($roleName))
                    {
                        $user_roles[$usrole->role_name] = $usrole->role_label;
                    }
                }
            }
            }
            foreach ($roles as $role) {
                if($tmp_name == 'journal_invitation') {
                    $user_roles['User'] = 'Stage User';
                }
                elseif($tmp_name == 'send_notification_to_user') {
                    $user_roles['User'] = 'All CP Team Members';
                    /*Task #1897 Seperate email template for invitation of organizers */
                }elseif($tmp_name == 'send_notification_to_organiser'){
                    $user_roles['User'] = 'Stage User';
                    /*end Task #1897 Seperate email template for invitation of organizers */
                }


            }
            if (!empty($hook_recipient)) {
                foreach ($hook_recipient as $recipient) {
                    if (array_key_exists($recipient, $user_roles)) {
                        $recipient_roles[$recipient] = $user_roles[$recipient];
                    }
                }
            } else {
                $recipient_roles = $user_roles;
            }
            // Remove the 'User' key
            unset($user_roles['User']);
            $cc_roles = $bcc_roles = $user_roles;

            $email_template_data = $Email_templates::get_single_record('*',"etmp_name='".$tmp_name."'");
             // Task #3890 Organizer email no edited content is sent start
             if (empty($email_template_data))
             {   
                 $return_data['data'] = 'tmpl_err';
                 $return_data['msg'] = 'You have not defined any email templates';
                 return $this->warning('Warning', 200, $return_data);
             }
             $cc_roles['Custom_cc'] = 'Specific email ID';
             $bcc_roles['Custom_bcc'] = 'Specific email ID';
             // Task #3890 Organizer email no edited content is sent end
            if(!empty($email_template_data)) 
            {
                $email_template_data->reply_to =    $this->get_reply_to_email($jnl_id);
                $email_data = new stdClass;
                $email_data->jnl_id = $jnl_id;
                $email_data->user_id = $user_id;
                $email_data->jnl_journal_code = $journal_code;
                $email_data->email_templates_config = $this->email_templates_config();
                $email_data->join_config = $this->join_config();
                $email_data->join_dependency_config = $this->join_dependency_config();
                $email_data->user_role_tags = $this->user_role_tags();
                $email_data->mail_type = 'edit';
                $user_titles = $this->UserConfigdata('titles')['titles'];
                $content =$email_template_data->etmp_email_template;
                $subject = $email_template_data->etmp_subject;
                $email_data->template_name='send_notification_to_organiser';/*Task #1897 Seperate email template for invitation of organizers */
                $email_template_data->etmp_subject = $this->generate_email_data_from_keys($email_data, $subject, $current_user, $user_titles, true);
                $email_template_data->etmp_email_template =   $this->generate_email_data_from_keys($email_data, $content, $current_user, $user_titles, TRUE);
                preg_match_all('/##([^##]*)##/', $email_template_data->etmp_email_template, $matches);
                $keys = $matches[1];
                for ($i = 0; $i < count($keys); $i++) {
                    $element = $keys[$i];
                    if (!empty($element)) {
                        $tmpl_data = str_ireplace('##' . $element . '##', '<button contenteditable="false">' . $element . '</button>',  $email_template_data->etmp_email_template);
                        $email_template_data->etmp_email_template = $tmpl_data;
                    }
                }
                $email_template_data->recipient_roles = $recipient_roles;
                $email_template_data->cc_roles = $cc_roles;
                $email_template_data->bcc_roles = $bcc_roles; 
                return $this->success('success', data:['component' => 'email_preview', 'data' => $email_template_data]);
            }
            else {
                return $this->success('failed', data:['msg' => 'Email template not found']);
            }
        }
		catch (\Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
    }

    /*
    * Task #3027 Fetch the articles for article number re-ordering
    * params art_id and jnl_id
    * returns array
    */
    public function fetcharticlenumberreordering(Request $request) {
        try {
            $results    =   array();
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $art_id     = $this->decrypt_data($form_data['art_id']);
            $jnl_id     = $this->decrypt_data($form_data['jnl_id']);

            $select_fields = 'art_id, art_code, art_title, art_status, art_chapter_order';
            $where_condition = "art_id = " . $art_id . "";
            $article_details = Articles::get_article_details($select_fields, $where_condition, null, true, true, NULL, array(), 1);
            if ($article_details->isNotEmpty()) {
                $article_details    =   $article_details[0];

                $fetchothArtSql 	=	"SELECT
                                            art_id,
                                            art_code,
                                            art_title,
                                            art_status,
                                            art_chapter_order
                                        FROM
                                            `rvw_articles`
                                        LEFT JOIN `rvw_article_flow` AS `fl1` ON `art_id` = `fl1`.`aflw_art_id`
                                        LEFT JOIN `rvw_article_types` ON `art_artp_id` = `artp_id`
                                        LEFT JOIN `rvw_journals` ON `artp_jnl_id` = `jnl_id`
                                        LEFT JOIN `rvw_journal_workflows` ON `aflw_jwf_id` = `jwf_id`
                                        WHERE
                                            jnl_id = $jnl_id AND art_delete_status = 'n' AND art_stage_submission_method = 'b' AND fl1.aflw_id =(
                                            SELECT
                                                MAX(aflw_id)
                                            FROM
                                                rvw_article_flow AS fl2
                                            WHERE
                                                fl2.aflw_art_id = fl1.aflw_art_id
                                        ) AND(
                                            `art_status` IN('n', 'a', 'r', 't', 'y') OR(
                                                CASE WHEN art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a'
                                            END
                                        )) AND art_id != ".$art_id."
                                            ORDER BY `art_chapter_order` ASC LIMIT 10";
                
                $othArts = Articles::get_records_by_raw_query($fetchothArtSql);

                $article_details->art_title = strip_tags($article_details->art_title);
                $results['main_article']  =   $article_details;
                $results['oth_articles']  =   $othArts;

                return $this->success('Success', 200, $results);
            } else {
                return $this->warning('No article found',200, $results,'warning');
            }

        }
		catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }


    /*
    * Task #3027 Re-order the article's order
    * params source_art_id - The article's ID whose order needs to be change
    * params desti_art_id - The article ID before/after which the source article has to be placed.
    * params jnl_id - jrnl id
    * params action - before/after
    * returns array
    */
    public function update_article_order(Request $request) 
    {
        try {
            if(isset($this->current_client->functionality->cfty_article_numbering) && $this->current_client->functionality->cfty_article_numbering == 'y'){
                $results    =   array();
                $form_data = $request->all();
                $validator = Validator::make($request->all(), [
                    'source_art_id' => 'required',
                    'desti_art_id' => 'required',
                    'jnl_id' => 'required',
                    'action' => 'required'
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed', 422, $validator->errors());
                }

                $source_art_id  = $this->decrypt_data($form_data['source_art_id']);
                $desti_art_id   = $this->decrypt_data($form_data['desti_art_id']);
                $source_art_posi  = $form_data['source_art_posi'];
                $desti_art_posi   = $form_data['desti_art_posi'];
                $jnl_id         = $this->decrypt_data($form_data['jnl_id']);
                $action         = $form_data['action'];

                DB::beginTransaction();
                $articletype_table  = (new \App\Models\Article_types())->getTable();
                $articles_table     = (new \App\Models\Articles())->getTable();

                // Get all articles ordered by current order
                $artOrdSql    =   "SELECT MIN(art_chapter_order) as min_order, MAX(art_chapter_order) as max_order  FROM " . $articles_table. " 
                                left join ".$articletype_table." on art_artp_id=artp_id 
                                WHERE artp_jnl_id=".$jnl_id." and art_stage_submission_method ='b' 
                                ORDER BY art_chapter_order ASC";
                $art_ord_starting_ending= Articles::get_records_by_raw_query($artOrdSql);
                $art_ord_starting   =   $art_ord_ending   =   0;

                if(!empty($art_ord_starting_ending)) {
                    $art_ord_starting   = $art_ord_starting_ending[0]->min_order;
                    $art_ord_ending    = $art_ord_starting_ending[0]->max_order;
                }

                // Get all articles ordered by current order
                $artSql    =   "SELECT art_id, art_code, art_title, art_chapter_order, artp_prefix_article_no, aflw_status, jwf_stage_type, art_delete_status 
                                FROM " . $articles_table. " 
                                left JOIN ".$articletype_table." on art_artp_id=artp_id 
                                LEFT JOIN `rvw_article_flow` AS fl1 ON `art_id` = `aflw_art_id`
                                LEFT JOIN `rvw_journals` ON `artp_jnl_id` = `jnl_id`
                                LEFT JOIN `rvw_journal_workflows` ON `aflw_jwf_id` = `jwf_id`
                                WHERE artp_jnl_id=".$jnl_id."  and art_stage_submission_method ='b' 
                                and art_chapter_order BETWEEN LEAST($source_art_posi, $desti_art_posi) AND GREATEST($source_art_posi, $desti_art_posi) 
                                AND fl1.aflw_id =(
                                    SELECT
                                        MAX(aflw_id)
                                    FROM
                                        rvw_article_flow AS fl2
                                    WHERE
                                        fl2.aflw_art_id = fl1.aflw_art_id
                                )
                                GROUP BY art_id 
                                ORDER BY art_chapter_order ASC";

                $articles= Articles::get_records_by_raw_query($artSql);

                // Rebuild order in memory
                $ordered    =   array_map(function ($item) {
                                    return ['art_id'=>$item->art_id, 
                                    'art_code'=>$item->art_code, 
                                    'art_title'=>$item->art_title, 
                                    'curr_art_chapter_order'=>$item->art_chapter_order, 
                                    'prefix'=>$item->artp_prefix_article_no,
                                    'aflw_status'=>$item->aflw_status,
                                    'jwf_stage_type' => $item->jwf_stage_type,
                                    'art_delete_status' => $item->art_delete_status
                                ];
                                }, $articles);
                                
                // Find all elements where aflw_status != 'u'
                $aflw_result = array_filter($ordered, function ($row) {
                    return ($row['aflw_status'] !== 'u' || $row['jwf_stage_type'] !== 'author_submission' || $row['art_delete_status'] !== 'n');
                });

                // Check if any found
                if (!empty($aflw_result)) {
                    return response()->json(['status'=>'error', 'message' => 'Re-ordering is not allowed because one or more articles have already been invited, submitted, moved to the next stage or have been removed.'], 200);
                }

                // Remove the source article
                $ordered = array_values(array_filter($ordered, function ($item) use ($source_art_id) {
                    return $item['art_id'] != $source_art_id;
                }));

                if ($desti_art_posi === false) {
                    throw new \Exception("Destination article not found");
                }

                // Compute insert position
                if($action == 'before') {
                    if($desti_art_posi == 1){
                        $insertIndex = 1;
                    } else {
                        $insertIndex = $desti_art_posi -1;
                    }
                } else {
                    if($desti_art_posi == $art_ord_ending){
                        $insertIndex = $desti_art_posi;
                    } else {
                        $insertIndex = $desti_art_posi +1;
                    }
                }
                if($insertIndex == $source_art_posi)
                {
                    return response()->json(['status'=>'error', 'message' => 'Cannot re-order an article to its same position'], 200);
                }

                // Insert source article at the new position
                $src_artSql    =   "SELECT art_id, art_code, art_title, art_chapter_order, artp_prefix_article_no  
                                FROM " . $articles_table. " 
                                left join ".$articletype_table." on art_artp_id=artp_id 
                                WHERE art_id = ".$source_art_id."";
                $src_article= Articles::get_records_by_raw_query($src_artSql);

                $new    =   array(
                                'art_id' => $source_art_id, 
                                'art_code'=>$src_article[0]->art_code,  
                                'art_title'=>$src_article[0]->art_title,  
                                'curr_art_chapter_order' => $src_article[0]->art_chapter_order, 
                                'prefix' => $src_article[0]->artp_prefix_article_no
                            );
                // $new_ordered_arr = $this->insertAtPosition($ordered, $new, $desti_art_posi, $insertIndex, $action);

                $new_ordered_arr = $this->reorderArticles($ordered, $new, $source_art_id, $desti_art_id, $insertIndex, $action);

                // Extract only art_id
                $ids = array_column($new_ordered_arr, 'art_id');

                // Convert to comma separated string
                $idString = implode(',', $ids);


                $caseTemp = "CASE art_id ";
                $caseCode = "CASE art_id ";
                $caseNum  = "CASE art_id ";
                $caseDoi  = "CASE art_id ";

                $art_new_arr    =   array();
                foreach ($new_ordered_arr as $index => $data) {
                    $dtArr  =   $this->update_article_code_after_reordering($data);
                    $caseNum  .= "WHEN {$data['art_id']} THEN {$data['art_chapter_order']} ";            
                    $newArtnum   =   $index + 1;
                    $temp_art_code    =   '_tmp' . $newArtnum;
                    $caseTemp .= "WHEN {$data['art_id']} THEN CONCAT(art_code, '".$temp_art_code."') ";
                    $caseCode .= "WHEN {$data['art_id']} THEN '{$dtArr['art_code']}' ";

                    $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
                    $doi_details  = Config::get($doi);
                    $doi_data = $this->create_article_doi($data['art_id'], $doi_details, 'n', $dtArr['art_code']);
                    $caseDoi .= "WHEN {$data['art_id']} THEN '{$doi_data['doi']}' ";

                    $art_new_arr[]  =   array(
                                            'art_id' => $data['art_id'], 
                                            'art_old_artcode' => $data['art_code'], 
                                            'art_new_artcode' => $dtArr['art_code'], 
                                            'art_old_order' => $data['curr_art_chapter_order'], 
                                            'art_new_order' => $data['art_chapter_order'], 
                                        );

                }
                $caseTemp .= "END";
                $caseCode .= "END";
                $caseNum  .= "END";
                $caseDoi  .= "END";

                $tempcodeSql = "UPDATE ".$articles_table." SET art_code = $caseTemp, art_operation = 'e' WHERE art_id IN ($idString)";
                Articles::get_records_by_raw_query($tempcodeSql);

                $updSql = "UPDATE ".$articles_table." SET art_code = $caseCode, art_chapter_order = $caseNum, art_doi = $caseDoi WHERE art_id IN ($idString)";
                Articles::get_records_by_raw_query($updSql);

                $posi = ($action == 'before') ? 'b' : 'a';
                $logarr = array(
                                'src_art_id' => $source_art_id,
                                'des_art_id' => $desti_art_id,
                                'ord_position' => $posi,
                                'art_new_arr' => $art_new_arr
                            );
                // Task #3027-1 Save the reordered articles in table
                $this->insert_article_reorder_log($logarr);

                DB::commit(); 
                              
                return response()->json(['status'=>'success', 'message' => 'Article order changed successfully'], 200);
            } else {
                return  $this->failure('Failed', 422, "Cannot do article re-ordering");
            }
        }
		catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }

    /*
    * Task #3027-1 Save the reordered articles in table
    * param $data : array with re-ordered array details
    */
    public function insert_article_reorder_log($data) {
        $this->current_user = $this->get_current_user_details();
        $logarr = array(
                        'src_art_id' => $data['src_art_id'],
                        'des_art_id' => $data['des_art_id'],
                        'ord_position' => $data['ord_position']
                    );
        //Article_order
        if($aod_ord_id  =   Article_order::insert_record($logarr, $this->current_user)) {
            $art_new_arr    =   $data['art_new_arr'];

            //Article_order_details
            foreach ($art_new_arr as $key => $arr) {
                $logdetailsarr = array(
                                    'aod_ord_id' => $aod_ord_id,
                                    'aod_art_id' => $arr['art_id'],
                                    'aod_art_old_artcode' => $arr['art_old_artcode'],
                                    'aod_art_new_artcode' => $arr['art_new_artcode'],
                                    'aod_art_old_order' => $arr['art_old_order'],
                                    'aod_art_new_order' => $arr['art_new_order']
                                );
                Article_order_details::insert_record($logdetailsarr, $this->current_user);
            }
        }
    }

    /*
    * Reordr the articles
    * param $ordered : the existing articles array
    * param $new : the new article array
    * param $desti_art_id : the article id where the source article need to push b4 / aftr
    * param $insertIndex : the source article array
    * param $action : b4 / aftr
    */
    public function reorderArticles(array $ordered, array $new, int $source_art_id, int $desti_art_id, int $insertIndex, string $action): array 
    {
        // remove existing occurrence of $new (by art_id) to avoid duplicates
        $ordered = array_values(array_filter(
            $ordered,
            fn($r) => $r['art_id'] !== ($new['art_id'] ?? null)
        ));

        // Find index of destination
        $index = array_search($desti_art_id, array_column($ordered, 'art_id'));

        if ($index !== false) {
            // $new['art_chapter_order']  =   $insertIndex;
            // Insert before $index element
            if ($action === 'before') {
                array_splice($ordered, $index, 0, [$new]);
            } elseif ($action === 'after') {
                array_splice($ordered, $index + 1, 0, [$new]);
            }
        }

        // Extract just art_chapter_order
        $orders = array_column($ordered, 'curr_art_chapter_order');

        // Sort art_chapter_order in ascending
        sort($orders);

        // Replace art_chapter_order values in $data
        foreach ($ordered as $i => &$row) {
            $row['art_chapter_order'] = $orders[$i];
        }

        //remove the array which has same its curr_art_chapter_order and art_chapter_order (new) are same
        //bcoz same order then there si no changenin art code or art order
        $filtered = array_filter($ordered, function($item) {
            return $item['curr_art_chapter_order'] != $item['art_chapter_order'];
        });

        // Re-index array if needed
        $filtered = array_values($filtered);
        return $filtered;
    }

    /*
    * Task #3027 update the articles code using the position for reordering
    * params #row article's array
    * returns array
    */
    public function update_article_code_after_reordering($row) {
        // Find number of # in the string
        $prefix     =   $row['prefix'];
        $art_id     =   $row['art_id'];
        preg_match('/#+/', $prefix, $matches);
        $hashCount = strlen($matches[0]); // count of # (2, 3, 4...)

        // Pad the number with leading zeros based on # count
        $number = str_pad($row["art_chapter_order"], $hashCount, "0", STR_PAD_LEFT);

        // Replace only the sequence of # with padded number
        $Articles = new \App\Models\Articles;
        $articlesTable =  (new \App\Models\Articles)->getTable();
        $articleTypesTable =  (new \App\Models\Article_types)->getTable();
        $journalsTable     = (new \App\Models\Journals())->getTable();
        $jnl_code = $Articles::query()
            ->join($articleTypesTable, $articleTypesTable.'.artp_id', '=', $articlesTable.'.art_artp_id')
            ->join($journalsTable, $articleTypesTable.'.artp_jnl_id', '=', $journalsTable.'.jnl_id')
            ->where($articlesTable.'.art_id', $art_id)
            ->value($journalsTable.'.jnl_journal_code');
        $proceedingArr  =   $this->fetch_client_proceeding_config_array('coference_settings');

        $newArtcode = preg_replace('/#+/', $number, $prefix, 1);
        if(!empty($jnl_code)){
            $newArtcode = !empty($proceedingArr['conference_acronym'])? str_replace('{CA}', strtoupper($jnl_code), $newArtcode):str_replace('{CA}','CA', $newArtcode);
        }

        $tempArtcode  =   str_replace('{M}', date('m'), $newArtcode);
        $finArtcode   =   str_replace('{Y}', date('Y'), $tempArtcode);     
        $row["art_code"] = $finArtcode;
        unset($row['prefix']);
        return $row;
    }

    /*
    * Task #3027 Search the articles or position for reordering
    * params art_id and jnl_id
    * returns array
    */
    public function searcharticlesforreordering(Request $request) {
        try {
            $results    =   array();
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'source_art_id' => 'required',
                'value' => 'required',
                'jnl_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $source_art_id  = $this->decrypt_data($form_data['source_art_id']);
            $value          = htmlentities(strip_tags($form_data['value']));
            $jnl_id         = $this->decrypt_data($form_data['jnl_id']);

            // -- formatted string match (ignoring spaces and special characters)
            // -- like 1. AIP20251001 (My first Article title)
            $subqry     =       " OR (CONCAT(
                                    art_chapter_order,
                                    '. ',
                                    art_code,
                                    ' (',
                                    art_title,
                                    ')'
                                ) LIKE '%$value%')";

            $fetchothArtSql =	"SELECT
                                    art_id,
                                    art_code,
                                    art_title,
                                    art_chapter_order
                                FROM
                                    `rvw_articles`
                                LEFT JOIN `rvw_article_flow` AS `fl1` ON `art_id` = `fl1`.`aflw_art_id`
                                LEFT JOIN `rvw_article_types` ON `art_artp_id` = `artp_id`
                                LEFT JOIN `rvw_journals` ON `artp_jnl_id` = `jnl_id`
                                LEFT JOIN `rvw_journal_workflows` ON `aflw_jwf_id` = `jwf_id`
                                WHERE
                                    jnl_id = $jnl_id AND art_delete_status = 'n' AND art_stage_submission_method = 'b' AND fl1.aflw_id =(
                                    SELECT
                                        MAX(aflw_id)
                                    FROM
                                        rvw_article_flow AS fl2
                                    WHERE
                                        fl2.aflw_art_id = fl1.aflw_art_id
                                ) AND(
                                    `art_status` IN('n', 'a', 'r', 't', 'y') OR(
                                        CASE WHEN art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a'
                                    END
                                )) AND art_id != ".$source_art_id." AND (art_title LIKE '%$value%' OR art_code LIKE '%$value%' OR art_chapter_order LIKE '%$value%' "." $subqry)
                                ORDER BY `art_chapter_order` ASC 
                                LIMIT 10";
            
            $articles = Articles::get_records_by_raw_query($fetchothArtSql);
            return response()->json(['status'=>'success', 'data' => $articles], 200);
        }
		catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

    public function articlereorderinghistory(Request $request) 
    {
        try {
            $results    =   array();
            $form_data = $request->all();
            $validator = Validator::make($request->all(), [
                'art_id' => 'required',
                'jnl_id' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }

            $art_id     =   $this->decrypt_data($form_data['art_id']);
            $jnl_id     =   $this->decrypt_data($form_data['jnl_id']);

            $art_dtls   =   Articles::get_single_record('*', 'art_id='.$art_id);
            if(!empty($art_dtls)) 
            {
                $results    =   array(
                                    'art_id' => $art_dtls->art_id, 
                                    'art_code' => $art_dtls->art_code, 
                                    'art_title' => trim(strip_tags($art_dtls->art_title))
                                );

                $articleorder_tbl           = (new \App\Models\Article_order())->getTable();
                $articleorderdetails_tbl    = (new \App\Models\Article_order_details())->getTable();

                $pf_date_format     =   $this->get_platform_date_format($jnl_id);
                $date_format        =   date_format_map($pf_date_format);

                // Get all articles ordered by current order
                $artSql    =   'SELECT
                                    l.ord_id,
                                    IF(
                                        l.ord_position = \'b\',
                                        \'before\',
                                        \'after\'
                                    ) AS place,
                                    dl.aod_art_old_artcode,
                                    dl.aod_art_new_artcode,
                                    dl.aod_art_old_order,
                                    dl.aod_art_new_order,
                                    a1.art_id AS src_art_id,
                                    a1.art_title AS src_art_title,
                                    a2.art_id AS dest_art_id,
                                    a2.art_title AS dest_art_title,
                                    DATE_FORMAT(dl.aod_posted_date, "' . $date_format . ' %h:%i:%p") as posted_date
                                FROM
                                    `rvw_article_order_details_log` dl
                                LEFT JOIN `rvw_article_order_log` l ON
                                    (
                                        `aod_ord_id` = `ord_id` AND dl.aod_art_id = l.src_art_id
                                    )    
                                LEFT JOIN `rvw_articles` a1 ON
                                    (a1.`art_id` = dl.aod_art_id)
                                LEFT JOIN `rvw_articles` a2 ON
                                    (a2.`art_id` = l.des_art_id)
                                WHERE
                                    dl.aod_art_id = '.$art_id.'
                                ORDER BY
                                    dl.aod_posted_date
                                DESC';

                $reordering_details= Articles::get_records_by_raw_query($artSql);
                if(!empty($reordering_details)) {
                    $orderArr    =   array();
                    foreach($reordering_details as $key => $arr) {
                        if($arr->ord_id == NULL){
                            $activity = 'This article is moved from position <b>'.$arr->aod_art_old_order.'</b> to <b>'.$arr->aod_art_new_order.'</b>. The article code was updated from <b>'.$arr->aod_art_old_artcode.'</b> to  <b>'.$arr->aod_art_new_artcode.'</b>.';
                        } else {
                            // Remove paragraph, bold, and italic tags from src_art_title
                            $art_title = str_replace(["<p>", "</p>", "<b>", "</b>", "<i>", "</i>"], "", $arr->src_art_title);
                            $activity = 'This article is moved from position <b>'.$arr->aod_art_old_order.'</b> to <b>'.$arr->aod_art_new_order.'</b>, '.$arr->place.' the article "'.$art_title.'". The article code was updated from <b>'.$arr->aod_art_old_artcode.'</b> to  <b>'.$arr->aod_art_new_artcode.'</b>.';
                        }
                        $orderArr[] =   array(
                                            'date' =>  $arr->posted_date,
                                            'activity' => $activity
                                        );
                    }
                    $results['re_ordering_data']    =   $orderArr;
                    return response()->json(['status'=>'success', 'data' => $results], 200);
                }
                else{
                    return response()->json(['status'=>'success', 'msg' => 'No re-ordering details found'], 200);
                }
            } else {
                return response()->json(['status'=>'success', 'msg' => 'No article found'], 200);
            }
        }
		catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
}
