<?php

namespace App\Http\Controllers;

use App\Models\Roles;
use App\Models\User;
use App\Models\User_emails;
use App\Models\User_affiliations;
use App\Models\User_to_journals;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use Response;

class Manage_bulk_user_uploads extends Controller
{
    public function bulkuserupload(Request $request)
    {
        try{
            $status='';
            $post_data=$request->all();
            if($post_data['file'])
            { 
                 $aff_status=$post_data['aff_status'];
                 $path = $post_data['file']->store('public/uploads');
                 $return_data=$this->read_upload_users($path,$aff_status);
                 return $this->success($status, 200, $return_data);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

   
}
public function read_upload_users($path,$aff_status)
    {
        try{
        $i = 0;
        $email_exist_cnt = 0;
        $return_data    = array(
            'status' => 'error',
            'msg'    => ''
        );
        $email_legacy_check=array();
        $csvData        = array();
        $email_arr_set  = array();
        $duplicated_row = array();
        $email_arr      = array();
        $arr_duplicate  = array();
        $arr_duplicate_new=array();
        $email_legacy_arr=array();
        $originalArray=array();
        $unsetemailArray=array();
        $invalid_legacyid=array();
        $user_legacy_valid_check=array();
        $unsetArray = []; 
        $duplicated_row_list = '';
        $status='';
        $file_path=storage_path().'/app/'.$path;
        $file_read = fopen($file_path, 'r');
        $fields         = fgetcsv($file_read);
        $keys           = $this->escape_string($fields);
        $db_fields      = User::get_field_names();
        $dbaff_fields      = User_affiliations::get_field_names();
        $user_data = $this->get_current_user_details();
        if(in_array('usr_first_name', $keys) && in_array('usr_last_name', $keys) && in_array('usr_email', $keys))
        {
            $email_column_key = array_search('usr_email',$keys);
            $f_name_column_key = array_search('usr_first_name',$keys);
            $m_name_column_key = array_search('usr_middle_name',$keys);
            $alter_email=array_search('uml_email',$keys);
            $l_name_column_key = array_search('usr_last_name',$keys);
            $usr_keyword_column_key = array_search('usr_keywords',$keys);
            $usr_legacy_column_key = array_search('usr_user_legacy_id',$keys);
            $usr_role_column_key = array_search('usr_role',$keys);
            while(($row = fgetcsv($file_read)) !== FALSE)
            {
                array_filter($row, function($value) { return !is_null($value) && $value !== ''; });
                if(empty($row))
                {
                    unset($row);
                }
                if(isset($row))
                {
                    if($row != NULL && !empty($row[$email_column_key]) && !empty($row[$f_name_column_key]) && !empty($row[$l_name_column_key]))
                    {
                        $values = $row;
                        if(count($keys) == count($values))
                        {
                            $arr        = array();
                            $aff_arr    = array();
                            $new_values = array();
                            $new_values = $this->escape_string($values);
                            //email duplication check with db
                            $email_check = User::get_single_record_with_bind_cond('count(usr_email) as cnt, usr_id',array(
                                'usr_email' => $new_values[$email_column_key]
                            ));
                            //email legacy id duplication check with db
                            if($new_values[$usr_legacy_column_key] && (is_numeric($new_values[$usr_legacy_column_key]) ==false)){
                                array_push($user_legacy_valid_check, $new_values[$usr_legacy_column_key]);     
                            }
                            if(isset($usr_legacy_column_key) && $new_values[$usr_legacy_column_key]>0){
                                $email_legacy_check = User::get_single_record_with_bind_cond('count(usr_email) as cnt, usr_id',array(
                                    'usr_user_legacy_id' => $new_values[$usr_legacy_column_key]
                                ));
                            }
                            if(isset($email_legacy_check) && isset($email_legacy_check->cnt) && $email_legacy_check->cnt >0){
                                array_push($invalid_legacyid, $new_values[$usr_legacy_column_key]);

                            }
                           
                           
                            //email dulication with other rows in the uploaded file
                            if(!empty($csvData))
                            {
                                $email_arr = (array_column($csvData, 'usr_email'));
                            }
                             //email user id dulication with other rows in the uploaded file
                             if(!empty($csvData) && $new_values[$usr_legacy_column_key] >    0)
                             {
                                 $email_legacy_arr = (array_column($csvData, 'usr_user_legacy_id'));                       
                             }

                            if($email_check->cnt == 0 && !in_array($new_values[$email_column_key],$email_arr)  && !in_array($new_values[$email_column_key],$email_legacy_arr))
                            {
                                
                                
                                for($j = 0; $j < count($keys); $j++)
                                {
                                    if($keys[$j] == 'uml_email')
                                        {
                                            $arr['uml_email']=$new_values[$j];
                                        }
                                    if($keys[$j] != "" && in_array($keys[$j], $db_fields))
                                    {                                       
                                        if($keys[$j] == 'usr_title')
                                        {
                                            $usr_title      = $this->get_corresponding_titles($new_values[$j]);
                                            $arr[$keys[$j]] = $usr_title;   
                                        }
                                        
                                        elseif($keys[$j] == 'usr_user_legacy_id' && $new_values[$j] !=0){
                                            $usr_user_legacy_id      = $new_values[$j];
                                            $arr[$keys[$j]]=(isset($usr_user_legacy_id)&& $usr_user_legacy_id !='')? $usr_user_legacy_id:null;
                                        }                                      
                                        elseif($keys[$j] == 'usr_reg_date' && !empty($new_values[$j]))
                                        {
                                            $origDate = str_replace('/', '-', $new_values[$j]);
                                            $newDate = date("Y-m-d H:i:s", strtotime($origDate));
                                            $arr[$keys[$j]] = $newDate;
                                        }
                                        else
                                        {
                                            $arr[$keys[$j]] = $new_values[$j];
                                        }
                                    }
                                    elseif($keys[$j] != "" && in_array($keys[$j], $dbaff_fields)){
                                        if($keys[$j] == 'usaff_company'){
                                            $primary_org      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$primary_org ;
                                        }
                                        elseif($keys[$j] == 'usaff_department'){
                                            $usaff_dep      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_dep;

                                        }
                                        elseif($keys[$j] == 'usaff_address_line1'){
                                            $usaff_add1      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_add1;

                                        }
                                        elseif($keys[$j] == 'usaff_address_line2'){
                                            $usaff_add2     = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_add2;

                                        }
                                        elseif($keys[$j] == 'usaff_cnt_id'){
                                            $usaff_cnt_id      = $this->get_corresponding_country_titles($new_values[$j]);
                                            if(isset($usaff_cnt_id->cnt_id))
                                            $usaff_cnt      = $usaff_cnt_id->cnt_id;
                                        else
                                            $usaff_cnt='';
                                            $aff_arr [$keys[$j]]=$usaff_cnt;

                                        }
                                        elseif($keys[$j] == 'usaff_website'){
                                            $usaff_website      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_website;

                                        }
                                        elseif($keys[$j] == 'usaff_phone'){
                                            $usaff_phone      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_phone;

                                        }
                                        elseif($keys[$j] == 'usaff_state'){
                                            $usaff_state      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_state;

                                        }
                                        elseif($keys[$j] == 'usaff_postal_code'){
                                            $usaff_postal_code      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_postal_code;

                                        } 
                                        elseif($keys[$j] == 'usaff_city'){
                                            $usaff_city      = $new_values[$j];
                                            $aff_arr [$keys[$j]]=$usaff_city;
                                        } 
                                    }
                                    elseif($keys[$j] == 'usr_sufix')
                                    {
                                        $arr['usr_last_name'] = $arr['usr_last_name'] . ' '. $new_values[$j];
                                    }
                                    

                                }
                                $email_arr_set[]= $new_values[$email_column_key];
                                if (empty($new_values[array_search('usr_username', $keys)])) {
                                    $arr['usr_username'] = $arr['usr_email'];
                                }
                                $username_check = User::get_single_record_with_bind_cond('count(usr_username) as cnt, usr_id',array(
                                    'usr_username' => $arr['usr_username']
                                ));
                                $usernamekey= $arr['usr_user_legacy_id'];
                                if($username_check->cnt != 0 ){
                                    if(empty($usernamekey))
                                    {
                                        $usernamekey= $arr['usr_email'];
                                    }
                                    $arr['usr_username'] = 'RVUSER_'.$usernamekey;
                                    
                                }
                                $key= Str::random(20);
                                $arr['usr_deeplink_token'] = $key;
                                $arr['usr_status']      = 'a';
                                $arr['usr_operation']   = 'b';
                                $arr['usr_posted_date'] = date('Y-m-d H:i:s');
                                //upload user affiliation to rvw_user_affiliation table
                                $aff_arr['usaff_posted_by'] = $user_data['user_id'];
                                $aff_arr['usaff_posted_date'] = date('Y-m-d H:i:s');
                                $aff_arr['usaff_operation'] ='u';
                                $aff_arr['usr_email'] = $arr['usr_email'];
                                $aff_arr['usaff_prime_affiliation'] ='y';
                                $aff_arr['usaff_type'] ='';
                                $csvData['aff'][$i]=$aff_arr;
                                $csvData[$i] = $arr;
                                
                            }
                            
                            else
                            {

                                $email_check = User::get_single_record_with_bind_cond('count(usr_email) as cnt, usr_id',array(
                                    'usr_email' => $new_values[$email_column_key]
                                ));
                                         
                                for($t = 0; $t < count($keys); $t++)
                                {
                                    
                                    if($keys[$t] == 'usr_email')
                                     {
                                        $arr_duplicate[$keys[$t]]=$new_values[$t];
                                        }
                                    if($keys[$t] != "" && in_array($keys[$t], $dbaff_fields))
                                    {  
                                        if($keys[$t] == 'usaff_cnt_id'){
                                            $usaff_cnt_id      = $this->get_corresponding_country_titles($new_values[$t]);
                                            if(isset($usaff_cnt_id->cnt_id))
                                            {
                                            $usaff_cnt      = $usaff_cnt_id->cnt_id;
                                            
                                            }
                                        else
                                            $usaff_cnt='';
                                            $new_values[$t]=$usaff_cnt;

                                        }
                                        $arr_duplicate[$keys[$t]]=$new_values[$t];
                                    }
                                
                            }
                            array_push($arr_duplicate_new, $arr_duplicate);
                                $email_exist_cnt++;
                                $duplicated_row[] = $i+2;
                            }
                        }
                    }
                        else
                    {
                        $status='Failed';
                        $return_msg ='Empty fields detected,please correct the csv and upload again.';
                        /*
                        $return_data    = array(
                            'status' => 'empty_row_error',
                            'return_msg'    => 'Empty fields detected,<br/>please correct the csv and upload again.',
                            'redirect'    => 'bulk-user-upload',
                        ); 
                        return $return_data;
                        */    
                    }
                    $i++;
                }
            }
            if(!empty($duplicated_row))
            {
                $duplicated_row      = join(' and ', array_filter(array_merge(array(join(', ', array_slice($duplicated_row, 0, -1))), array_slice($duplicated_row, -1)), 'strlen'));
                $duplicated_row_list = 'Duplicated records found at the following row(s) - ' . $duplicated_row;
            }
            
            
            if(!empty($csvData))
            {
                $newArrayOfArrays = array_map(function($item) {
                    if(!empty($item['uml_email'])) {
                        return [
                            'uml_email' => $item['uml_email'],
                            'usr_email' => $item['usr_email']
                        ];
                    }
                    // Return null for cases where uml_email is empty
                    return null;
                }, $csvData);
                
                $userDataWithoutAff = array_map(function($user) {
                    $userWithoutAff = $user;
                    unset($userWithoutAff['uml_email']);
                    return $userWithoutAff;
                }, $csvData);
                $newaffData = array_merge(
                    array_filter($userDataWithoutAff, function ($key) {
                        return $key === 'aff';
                    }, ARRAY_FILTER_USE_KEY),
                    [] // Create an empty array
                );    
                unset($userDataWithoutAff['aff']);
                // Initialize an empty array to store unset elements
                $filteredArray = [];  // Initialize an empty array to store valid emails

                foreach ($userDataWithoutAff as $item) {
                    $validator = Validator::make(['email' => $item['usr_email']], [
                        'email' => 'required|email',
                    ]);

                    if ($validator->fails()) {
                        $unsetArray[] = $item;  // Add the unset item to the unsetArray
                        unset($item); // Remove the item from the original array (userDataWithoutAffCopy)
                    } else {
                        $filteredArray[] = $item;  // Add valid email data to the filteredArray
                    }
                }

                $filteredData = array_filter($newArrayOfArrays);
                $filteredaffData = array_filter($newaffData['aff']);
               try{
                if(!empty($filteredaffData) && count($filteredaffData)>0){
                foreach ($filteredaffData as $item) {
                    $result_aff[] = $item;
                }
                    }
                    if($aff_status=='y'){
                        $arr_duplicate_new=[];
                    }
                //remove  emails from main array
                $originalArray=$filteredArray;
                $filteredArray = array_filter($filteredArray, function ($item, $key) { // Add $key parameter
                    $validator = Validator::make(['email' => $item['usr_email'] ?? null], ['email' => 'regex:/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/']);
                    return !$validator->fails();
                }, ARRAY_FILTER_USE_BOTH); // Use ARRAY_FILTER_USE_BOTH to access both value and key
                
                // To get the unset array:
                $unsetemailArray = array_diff_key(array_flip(array_keys($originalArray)), array_flip(array_keys($filteredArray)));
                $unsetemailArray = array_flip($unsetemailArray);
                $unsetArray['unsetemailArray'] = array_intersect_key($originalArray,$unsetemailArray);
                $duplicateLegacyIds = [];
                $uniqueLegacyIds = []; // Keep track of processed legacy IDs

                // Filter out duplicate legacy IDs from the already filtered array:
                $filteredArray = array_filter($filteredArray, function ($item) use (&$duplicateLegacyIds, &$uniqueLegacyIds, $invalid_legacyid) {
                    if (isset($item['usr_user_legacy_id']) && (in_array($item['usr_user_legacy_id'], $invalid_legacyid) || in_array($item['usr_user_legacy_id'], $uniqueLegacyIds))) {
                        $duplicateLegacyIds[] = $item;
                        return false; // Remove the item
                    } elseif(isset($item['usr_user_legacy_id'])){
                        $uniqueLegacyIds[] = $item['usr_user_legacy_id'];
                        return true; // Keep the item
                    }
                    return true; // Keep the item if it does not have a legacy id
                });
                $unsetArray['duplicateLegacyIds'] = $duplicateLegacyIds;
               // end
                  
                // Add elements from array1 to the result array
                if(!empty($arr_duplicate_new) && count($arr_duplicate_new)>0){
                foreach ($arr_duplicate_new as $item) {
                    $result_aff[] = $item;
                }
                }
                if(!empty($filteredArray) && count($filteredArray)>0){
                $userid=User::insert_batch($filteredArray);
                }
                if(!empty($result_aff) && count($result_aff)>0)
                {                   
                    foreach ($result_aff as $item=>$key) {
                        $email_check = User::get_single_record_with_bind_cond('usr_id',array(
                            'usr_email' => $key['usr_email']
                        ));             
                        if(isset($email_check) && !empty($email_check->usr_id))
                        {
                        unset($key['usr_email']);
                        $key['usaff_user_id'] = $email_check->usr_id;
                        $shouldInsert = !empty(array_filter([
                            $key['usaff_cnt_id'],
                            $key['usaff_state'],
                            $key['usaff_postal_code'],
                            $key['usaff_address_line1'],
                            $key['usaff_department'],
                            $key['usaff_company'],
                        ]));
                        if ($shouldInsert) {
                            User_affiliations::insert_record($key);
                        }
                        }
                    }
                }
               }
               catch (\Exception $e){
                $errorMessage ='Duplicate fields detected,please correct the csv and upload again.';
                return $this->warning($errorMessage,200,'Invalid Request','Warning');
               }
                $cc_data = [];
                if(isset($userid))
                {
                    foreach ($filteredData as $item) {
                        $email_check = User::get_single_record_with_bind_cond('usr_id',array(
                            'usr_email' => $item['usr_email']
                        ));
                        $implodedString =explode(',',$item['uml_email']);
                        
                        if(isset($implodedString) && !empty($email_check->usr_id)){
                            foreach($implodedString as $altvalue)
                            {
                                if($item['usr_email'] !=$altvalue)
                                {
                                    $cc_data['uml_user_id'] = $email_check->usr_id;
                                    $cc_data['uml_email'] = $altvalue;
                                    $cc_data['uml_status'] = 'c';    //admin added alternate mail confirmed directly : Bug #1249
                                    $cc_data['uml_posted_by'] = $user_data['user_id'];
                                    User_emails::insert_record($cc_data);
                                }
                            
                            }
                        }
                        
                        
                    }
                }
                if(count($filteredArray)==0){
                $return_msg = 'No new users imported. All users in the file already exist '. $duplicated_row_list;
                }
                else{
                    $return_msg = count($filteredArray) .' user records have been added successfully.'. $duplicated_row_list;

                }
                
                $status = 'success';
    //          $this->send_bulk_confirmation_mail($email_arr_set);
            }
            else
            { 
                $duplicated_row_list=(isset($duplicated_row_list) && !empty($duplicated_row_list))? $duplicated_row_list.' No new users imported. All users in the file already exist':'No new users imported.Empty user records.';
                $return_msg = (isset($duplicated_row_list) && !empty($duplicated_row_list))?$duplicated_row_list:'No new users imported.Empty user records.';
            }
                          
        
        }
        else
        {
            $status='Failed';
            $return_msg ='Empty fields detected,please correct the csv and upload again.';  
        }
        /*
        $file_read      = @fopen($file_path, "r");
        $fields         = fgetcsv($file_read);
        $keys           = $this->escape_string($fields);
        */
        $return_data    = array(
            'status' => $status,
            'return_msg'    => $return_msg ,
            'unset_arr'=>$unsetArray,
        ); 
        return $return_data;
    }
    catch (\Exception $e) {
        return  $this->failure('Failed', 500, $e);
    }
    }
    public function  get_corresponding_titles($title)
    {
        $title = strtolower(str_replace('.', '', $title));
        $title = strtolower(str_replace(',', '', $title));
        if($title == 'prof' || $title == 'professor' || strpos($title,"prof") > 0)
            $title = 'pr';
        elseif($title == 'ms' || $title == 'miss')
            $title = 'mis';
        elseif(strpos($title,"dr") > 0)
            $title = 'dr';
        return($title);
    }
    public function  get_corresponding_country_titles($country)
    {
        $country_id='';
        $Country = (new \App\Models\Country());
        $country_criteria=array("cnt_country"=>$country);
        $country_id = $Country::get_single_record_with_bind_cond('cnt_id', $country_criteria);
       return $country_id;
    }
    public function download_user_export_file($file_data)
    {
        try
		{    
        $post_data = json_decode($file_data);
        $filepath=decrypt_link($post_data->file_path);
        if(file_exists($filepath))
			{
                return Response::download($filepath)->deleteFileAfterSend(true);    
			}
			else
			{
				$this->warning('Failed',500,'file not exist');
			}
        }
		catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}		
		
    }
    
}
