<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Roles;
use App\Models\Flags;
use  App\Http\Traits\RolesConfigTrait;
use Illuminate\Support\Facades\Validator;
class Manage_flags_Api extends Controller
{
    use RolesConfigTrait;
   /*
    get pagination manage flags
    commited date :-  08-08-2022
    Request type :- POST
    */
    public function index(Request $request)
    {
   try{
    $form_data= $request->all();	
    $this->current_user = $this->get_current_user_details();
    $return_array=[];
    $all_roles =Roles::get_all_records();
	if(!empty($all_roles )) {
		foreach($all_roles as $row) {
			$return_array['all_roles'][$row->role_id]=$row->role_name;
		}
	}
	// $return_array['priorityroles']=Roles::get_all_records();
    $sort_field = $form_data['sort_field'] ?? 'flag_id';
	$sort_order =  $form_data['sort_order'] ?? 'asc';
	$limit = $form_data['per_page'] ?? 5;
    $select = '*';
	/**
    * TASK #8446 article flags changes
    * changed due to display only active flags for flag list where flag status is 'y'
    * $criteria = NULL;
    */
	$criteria = "flag_status = 'y'";
    $return_array['all_flags'] = Flags::get_paginated_records($select,$criteria,$sort_field, $sort_order, $limit);
    $return_array['client_functionality'] =  $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);
    $return_array['flag_icon_selector'] =$return_array['client_functionality']->cfty_flag_icon_selector;
    return $this->success('success',200,$return_array);
    } catch (exception $e) {
        return  $this->failure('Failed',500,$e);
        }
    }
    public function save_flag(Request $request)
	{
        try{
            $posted_data = $request->all();
			$this->current_user = $this->get_current_user_details();
			$validator = Validator::make($posted_data, [
				'flagname'     => 'required',
				'flagtype'  => 'required',
				'visible_role' => 'required',
				]);
				if ($validator->fails()) {
				return $this->warning('warning',200,$msg,'warning');
				}
            if ($posted_data != '')
		    {
			$admin_roles=explode(",",$posted_data['visible_role']);
            $data['flag_name'] = $posted_data['flagname'];
			$data['flag_type'] = $posted_data['flagtype'];
			$data['flag_role'] = json_encode($admin_roles);
			$data['flag_color'] = $posted_data['color'];
			$data['flag_icon'] = null;
			$data['flag_prefix'] = 'fa';

            $flag_icon_selector = $this->current_client->functionality->cfty_flag_icon_selector;
            if ($flag_icon_selector == 'y')
			{
				if($posted_data['icon'] != '') {
					$iconText	=	explode(" ", $posted_data['icon']);
					$data['flag_prefix'] = $iconText['0'];
					$data['flag_icon'] = $iconText['1'];
				}
			}

			$msg = '';
            // $replace_flag_type = ($data['flag_type'] == 'u') ? 'User' : customTrans(':Article');
			if (isset($data['flag_type'])) {
				if ($data['flag_type'] === 'u') {
					$replace_flag_type = 'User';
				} elseif ($data['flag_type'] === 's') {
					$replace_flag_type = 'System';
					/* Restrict same name System flag  start*/
					$where_condition =array(
						'flag_name'=>$data['flag_name'],
						'flag_type'=>$data['flag_type']
					);
					$system_flag_details = Flags::get_single_record_with_bind_cond('count(flag_id) as cnt',$where_condition);
					if ($system_flag_details->cnt > 0){
					$msg = customTrans('flags.flag_name_exist');
					return $this->warning($msg,200,array(),'warning');
					}
					/* Restrict same name System flag  end*/
				} else {
					$replace_flag_type = customTrans(':Article');
				}
			} else {
				$replace_flag_type = customTrans(':Article');
			}
			if ($posted_data['hdn_flag_id'] == "")
			{
				if ($flag_icon_selector == 'y')
				{
					// $select = 'count(*) as cnt';
					$criteria = 'flag_color="' . $data['flag_color'] . '" and flag_icon ="' . $data['flag_icon'] . '"';
					$flag_details = Flags::get_single_record('count(*) as cnt',$criteria);
				}	
				else
				{
					$criteria1 = 'flag_color="' . $data['flag_color'] . '" and flag_type ="' . $data['flag_type'] . '"';
					$select = '*';	
					$flag_details = Flags::get_single_record('count(*) as cnt',$criteria1);
				}	
				if ($flag_details->cnt == 0)
				{	
					$data['flag_id'] = Flags::insert_record($data,$this->current_user);
					$data['flagformstatus'] = 'insert';
					//$msg =customTrans('flags.flag_add_successfully');	
					$msg = str_replace('REPLACE_FLAG_TYPE',$replace_flag_type,  customTrans('flags.flag_add_successfully')); 
				}	
				else
				{
					$msg = customTrans('flags.flag_color_exist');
					return $this->warning($msg,200,array(),'warning');
				}
			}
			else
			{
				$exist_condtn= 'flag_color="' . $data['flag_color'] . '" and flag_id !="' . $this->decrypt_data($posted_data['hdn_flag_id']) . '"';
				//issue occur when client functionality is changed alternatively
				if($flag_icon_selector == 'y')
				$exist_condtn.=' and flag_icon ="'.$data['flag_icon'].'"';
				$flag_details = Flags::get_single_record('count(*) as cnt',$exist_condtn);
				if ($flag_details->cnt == 0)
				{
					$criteria='flag_id='.$this->decrypt_data($posted_data['hdn_flag_id']);
					Flags::update_record($data,$criteria,$this->current_user);
					$data['flagformstatus'] = 'update';
					$data['flag_id'] = $this->decrypt_data($posted_data['hdn_flag_id']);
					$msg = str_replace('REPLACE_FLAG_TYPE',$replace_flag_type,  customTrans('flags.flag_updt_successfully'));
				}
				else
				{
					$msg = customTrans('flags.flag_color_exist');
					return $this->warning($msg,200,array(),'warning');
				}
			}
			$data['all_roles'] = Roles::get_all_records();
			$data['flag_icon_selector'] = $flag_icon_selector;
			if ($data['flag_id'])
			return $this->success($msg,200,$data);
            }
        } 
		catch (exception $e) {
			return  $this->failure('Failed',500,$e);
            }
	}
	public function get_flag(Request $request)
	{
		try{
			$posted_data = $request->all();
			$flag_id = $this->decrypt_data($posted_data['flag_id']);
			if ($flag_id != "")
			{
            $criteria = 'flag_id="' . $flag_id . '"';
			$role_details = Flags::get_single_record('*', $criteria);
			$role_details->flag_role=json_decode($role_details->flag_role);
			return $this->success('success',200,$role_details);
			}		
			else
			{
				$msg=customTrans('flags.invalid_data');
				return  $this->success('Failed',204,$msg);
			}  
		}
		catch (exception $e) {
            return  $this->failure('Failed',500,$e);
            }
	}
	public function get_allroles(Request $request)
	{
		try{
			$posted_data = $request->all();
			$flag_id = $this->decrypt_data($posted_data['flag_id']);
			if ($flag_id != "")
			{
            // $this->data['all_roles'] = $this->getcoreuserrole();
            $criteria = 'flag_id="' . $flag_id . '"';
			$role_details = Flags::get_single_record('*', $criteria);
			return $this->success('success',200,$role_details);
			}		
			else
			{
				$msg=customTrans('flags.invalid_data');
				return  $this->success('Failed',204,$msg);
			}  
		}
		catch (exception $e) {
            return  $this->failure('Failed',500,$e);
            }
	}
	public function delete_flag(Request $request)
	{
		
		try{
			// DB::beginTransaction();
			$posted_data = $request->all();
			$this->current_user = $this->get_current_user_details();
			$Article_flag = new \App\Models\Article_flag();
			$flag_id = $this->decrypt_data($posted_data['flag_id']);
			if (isset($flag_id) && $flag_id != '')
		    {
				$criteria = 'flag_id="' . $flag_id . '"';
				$flag_type = Flags::get_single_record('flag_type', $criteria);
				$msg = '';
				$replace_flag_type = ($flag_type->flag_type == 'u') ? 'User' :customTrans(':Article');
				//$msg = $replace_flag_type .' ' .customTrans('flags.delete_flags');
				$msg = str_replace('REPLACE_FLAG_TYPE',$replace_flag_type,  customTrans('flags.delete_flags'));
				$article_flags = $Article_flag::get_article_flags('count(flag_id) as count', $criteria);
				$count = $article_flags->first()->count ?? 0;
				if ($count > 0) {
					return $this->warning(customTrans('flags.flag-del-err'), 200, [], 'warning');
				}
				/**
    			* TASK #8446 article flags changes
    			* changed article flag status into 'n' for keeping the flag data for article flags and users flags 
				* $result = Flags::delete_records($criteria,'',$this->current_user);
    			*/
				$flag_array = array(
					'flag_status' => 'n'
				);
				$result = Flags::update_record($flag_array,$criteria,$this->current_user);
				if(!empty($result))
				return $this->success($msg,200,array());
			}
		}
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
            }
	}

}
