<?php

namespace App\Http\Controllers;

use App\Models\Attachment_files;
use Illuminate\Http\Request;
use App\Http\Traits\GeneralEmailTrait;
use Illuminate\Support\Facades\Schema;
use DB;
use Log;
use Config;
use stdClass;
use Exception;



class Manage_merge_user extends Controller
{
	use GeneralEmailTrait;
    public function get_merge_data(Request $request)
    {
        try
        {
            $return_arr = array();
            $post_data = $request->all();
            $user_ids = array();
            foreach ($post_data['usr_ids'] as $ids)
            {
                $user_ids[] = decrypt_link($ids);
            }
            $User = new \App\Models\User();
            $user_data = $User::get_all_records('usr_id, CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user_name, usr_email', 'usr_id IN (' . implode(',', $user_ids) . ')');
            $return_arr['user_data'] = $user_data; 
            return $this->success('success', 200, $return_arr);
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }


    public function merge_mismatch_data(Request $request)
    {
        try
        {
            $user_affiliations = new \App\Models\User_affiliations();
            $article_flow = new \App\Models\Article_flow();
            $post_data = $request->all();
            $master_user_id = $post_data['primary'];
            $asso_user_ids = $post_data['merge_acc'];
            if(!empty($master_user_id) && !empty($asso_user_ids))
		    {
			$master_user_id = decrypt_link($master_user_id);
            foreach($asso_user_ids as $key=>$id)
            {
				$asso_user_ids[$key] = decrypt_link($id);
            }
            $master_aff = $user_affiliations::get_all_records('usaff_company', 'usaff_user_id = ' . $master_user_id. ' AND usaff_company IS NOT NULL');
            $master_institute = '"' .implode('","', array_column(json_decode(json_encode($master_aff), TRUE), 'usaff_company')). '"';
            
            $User=new \App\Models\User();
            $user_records = $User::get_all_records('usr_id, usr_first_name, usr_middle_name, usr_last_name, usr_status', 'usr_id IN('.implode(',', $asso_user_ids).',' . $master_user_id . ')');
			$key = array_search($master_user_id, array_column(json_decode(json_encode($user_records), TRUE), 'usr_id'));
            
            $master_user_data = $user_records[$key];
			unset($user_records[$key]);
			$conflict_message = array();
			if($master_user_data->usr_status != 'a')
			{
				$conflict_message[] = $master_user_data->usr_first_name. ' ' . $master_user_data->usr_middle_name. ' '.$master_user_data->usr_last_name . ' is not an active user';
            }
            foreach ($user_records as $record)
			{
				$msg = '';
				$mismatch_fields = array();
				if(strcasecmp($master_user_data->usr_first_name, $record->usr_first_name) != 0)
					$mismatch_fields[] = 'first name';
				if(strcasecmp($master_user_data->usr_middle_name, $record->usr_middle_name) != 0)
					$mismatch_fields[] = 'middle name';
				if(strcasecmp($master_user_data->usr_last_name, $record->usr_last_name) != 0)
					$mismatch_fields[] = 'last name';

				if(count($mismatch_fields) > 0)
				{
					$msg = implode(', ', $mismatch_fields);
					$msg .= ' mismatches';
				}
				if(!empty($master_institute)) {
					$usr_aff = $user_affiliations::get_single_record('count(usaff_id) as cnt', 'usaff_user_id = ' . $record->usr_id. ' AND usaff_company IN (' . $master_institute. ')');
					if($usr_aff->cnt == 0)
					{
						$msg .= !empty($msg) ? ' and ' : '';
						$msg .= 'are not from the same institution';
					}
				}
				if(!empty($msg))
				{
					$mid_name = !empty($record->usr_middle_name) ? ' ' .$record->usr_middle_name.' ' : ' ';
					$conflict_message[] = $record->usr_first_name. $mid_name . $record->usr_last_name . ' '. $msg;
				}					
            }

            $sql = 'SELECT aflw_parent_flow_id, count(aflw_id) as cnt, GROUP_CONCAT(DISTINCT aflw_usr_id) as usr_ids FROM rvw_article_flow WHERE aflw_usr_id IN('.implode(',', $asso_user_ids).',' . $master_user_id .') AND aflw_parent_flow_id IS NOT NULL GROUP BY aflw_parent_flow_id HAVING COUNT(aflw_id)>1';
			$flow_record = $article_flow::get_records_by_raw_query($sql);
			if(!empty($flow_record))
			{
				foreach ($flow_record as $record)
				{
					$usrs = explode(',', $record->usr_ids);
					if(count($usrs)>1)
					{
						$conflict_message[] = customTrans('The users mentioned above have been identified as working in the same stages of the same :articles.');
						break;
					}
				}
			}
			if(!empty($conflict_message))
			{
				$return_data['status'] = 'mismatch_found';
				$return_data['msg'] = $conflict_message;
            }
                return $this->success('success',200,$return_data);
            }
        }
        catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function execute_merge_user(Request $request,$direct_merge = FALSE)
    {
        try
        {  
            $post_data = $request->all();
            $return_data = array(
                'status' => 'failed',
                'msg' => 'Merge operation failed');
            $load_models = array();
            $current_user = $this->get_current_user_details();
            // if($direct_merge == FALSE)
            // {
                $master_user_id =  $post_data['primary'];
                $asso_user_ids =  $post_data['all_users'];
            // }
            if (!empty($asso_user_ids)) //to avoid chances of risk
            {
                $asso_user_ids = array_diff($asso_user_ids, array(
                    $master_user_id));
            }
			$warning_msg = json_encode($post_data['mis_match']);
            if (!empty($master_user_id) && !empty($asso_user_ids))
		    {
                $master_user_id = decrypt_link($master_user_id);
                foreach ($asso_user_ids as $key => $id)
                {
                    $asso_user_ids[$key] = decrypt_link($id);
                }
                $asso_user_ids = array_unique($asso_user_ids);
                $comma_ids = implode(',', $asso_user_ids);
                
                $no_conflict = $this->check_author_reviewer_conflict($master_user_id, $comma_ids);
                if (!empty($no_conflict['msg']))
                {
                    $return_data['status'] = 'conflict';
                    $return_data['msg'] = ($no_conflict['msg']);
                    $return_data['details'] = encrypt_link(json_encode($no_conflict['art_id']));
                    $return_data['frcmrg'] = encrypt_link(json_encode($no_conflict['action']));
                    
                    if($direct_merge == TRUE)
                    {
                        return $return_data;
                    }
                    else
                    {
                        return  $this->success('Failed', 200, $return_data);
                    }
                }
                $Users = new \App\Models\User();
                $master_details = $Users::get_single_record('usr_title, usr_first_name, usr_last_name, usr_email, usr_roles','usr_id = '.$master_user_id);
                $journal_tbl = new \App\Models\Journals();
                $all_journals_records = $journal_tbl::get_all_records('jnl_journal_code');
				$all_journal_code = array_column(json_decode(json_encode($all_journals_records), TRUE), 'jnl_journal_code');
				DB::beginTransaction();
                //Manage user roles in journal and article type
			    $this->tbl_user_journals($master_user_id, $comma_ids, $current_user);
                //Manage rvw_article_flow
                $this->merge_article_flow($master_user_id,$all_journal_code,$asso_user_ids);
                //Manage rvw_article_flow_legacydata
			    $this->tbl_article_flow_legacydata($master_user_id, $comma_ids);
                //Manage article authors
                $this->tbl_article_authors($master_user_id, $comma_ids, $master_details);
                //Manage generic form datas of all journals
                $this->tbl_article_generic_form_data($master_user_id, $comma_ids, $all_journal_code);
                $this->tbl_article_legacydata($master_user_id, $comma_ids, $asso_user_ids);
                
                if ($this->current_client->modules->mdl_publons == 'y')
                {
                    $this->tbl_article_publons($master_user_id, $comma_ids);
                }

                $this->tbl_user_articles($master_user_id, $comma_ids);

                $this->tbl_user_emails($master_user_id, $comma_ids);

                $this->tbl_user_flags($master_user_id, $comma_ids);

                $this->tbl_user_global_flags($master_user_id, $comma_ids);

                $this->tbl_user_journal_classifications($master_user_id, $comma_ids);

                $this->tbl_user_journal_filter_keys($master_user_id, $comma_ids);

                $this->tbl_user_journal_preference($master_user_id, $comma_ids);

                //Manage rvw_user_panel_collapsible_view, rvw_usr_unavailability, rvw_user_meta, rvw_user_meta_files
                $this->tbl_users_other_profiles($master_user_id, $comma_ids);
                
                if ($this->current_client->modules->mdl_orcid == 'y' && $this->current_client->functionality->cfty_review_to_orcid == 'y')
                {
                    $this->tbl_user_journal_orcid_details($master_user_id, $comma_ids);
                }
                //Manage table containing only posted_by and proxy_id and other columns recording usr_id
			    $this->manage_tbl_col($master_user_id, $comma_ids);
				
                $this->tbl_user_keywords($master_user_id, $comma_ids);

                if ($this->current_client->modules->mdl_generic_discussion == 'y')
                {
                    $this->tbl_generic_discussion($master_user_id, $comma_ids);
                }
				$this->emailchecker($master_details->usr_email,$master_user_id,$current_user);

                //Copy admin roles like super_admin, admin, report_operator
			    $other_usr_admin_roles = $Users::get_all_records('usr_roles', 'usr_id IN(' . $comma_ids . ') AND usr_roles IS NOT NULL AND trim(usr_roles) != ""');
			    $o_admin_roles = FALSE;
			    $master_admin_roles = (!empty($master_details->usr_roles)) ? json_decode($master_details->usr_roles) : array();
                $default_arr = array();

                $default_arr = array_merge($default_arr, $master_admin_roles);
			    $default_arr = array_unique($default_arr);

				$master_admin_roles = json_encode($default_arr);
			    $Users::get_records_by_raw_query("UPDATE " . $Users->getTable() . " SET usr_roles ='" . $master_admin_roles . "', usr_operation='m' WHERE usr_id = " . $master_user_id);
                $this->send_email_to_delete_user($master_user_id, $asso_user_ids, $warning_msg,$current_user);
				DB::commit();
				$return_data['status'] = 'success';
				$return_data['msg'] = 'Users merged';
				if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
                {
                    $es_config = 'clients.' . $this->current_client->clnt_client_code . '.es_integration';
                    $es_api_data  = Config::get($es_config);
                    if(isset($es_api_data['merge_user_api']))
                    {
                        $apiUrl = $es_api_data['merge_user_api'];
                        $data_to_editor = array();
                        $data_to_editor['mergeTo'] = $master_user_id;
                        $data_to_editor['mergeFrom'] = $asso_user_ids;
						$data_to_editor = http_build_query($data_to_editor);
						$response = $this->es_curl_request($apiUrl,$data_to_editor);
                    }
                }
			
            }
            if($direct_merge == TRUE)
            {
                return $return_data;
            }
            else
            {
                return $this->success('success', 200, $return_data);
            }
        }
        catch(\Exception $e){
			DB::rollback();
            return  $this->failure('Failed', 500, $e);
        }
    }

	private function check_author_reviewer_conflict($master_user_id, $comma_ids)
	{
		$conflict_msg = '';
		$article_id_array = [];
		$revoke_invitaion_for_merge = 'false';
		$Generic_table = new \App\Models\Generic_flows();
		$Article_flow_table = new \App\Models\Article_flow();
		$role_tbl = new \App\Models\Roles();
		$article_tbl = new \App\Models\Articles();
		$Users = new \App\Models\User();
		DB::enableQueryLog();

		$review_article_sql = 'SELECT DISTINCT aflw_art_id FROM ' . $Article_flow_table->getTable() . ',' . $Generic_table->getTable() . ' WHERE jwf_id = aflw_jwf_id AND jwf_stage_type = "review" AND aflw_parent_flow_id IS NOT NULL AND aflw_status IN ("c","a","i") AND aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')';
		$review_article_arr = $Article_flow_table->get_records_by_raw_query($review_article_sql);
		$review_article_list = array_column(json_decode(json_encode($review_article_arr), TRUE), 'aflw_art_id');
		/* TASK #5001 , If reviewers who have worked on the same article and submitted their reviews, merging them should not be possible; it should be restricted */
		// $user_review_submission_check_sql = 'SELECT DISTINCT COUNT(aflw_art_id) AS user_review_submission_count,GROUP_CONCAT(aflw_status) AS user_flow_status , GROUP_CONCAT(CASE WHEN aflw_status = "c" THEN aflw_posted_by ELSE aflw_usr_id END ) AS submitted_user_id,aflw_art_id FROM ' . $Article_flow_table->getTable() . ' WHERE aflw_status IN ("c", "a", "i") AND (aflw_posted_by IN(' . $master_user_id . ',' . $comma_ids . ') OR aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')) GROUP BY aflw_art_id';
		$user_review_submission_check_sql = 'SELECT DISTINCT COUNT(aflw_art_id) AS user_review_submission_count,GROUP_CONCAT(aflw_status) AS user_flow_status , GROUP_CONCAT(aflw_usr_id) AS submitted_user_id,aflw_jwf_id AS user_stage_id,aflw_art_id FROM ' . $Article_flow_table->getTable() . ' WHERE aflw_status IN ("c", "a", "i") AND aflw_jwf_id IN ( SELECT jwf_id FROM `rvw_journal_workflows` WHERE jwf_stage_type = "review") AND (aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')) GROUP BY aflw_art_id,aflw_jwf_id';
		$user_review_submission_check = $Article_flow_table->get_records_by_raw_query($user_review_submission_check_sql);
		$auth_if = '';
		$prod_auth_stage = '';
		if (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y') {
			$prod_auth_stage = ',"pro_revision"';
			$author_ids = $role_tbl::get_single_record('group_concat(role_id) as role_ids', 'role_assigned_role = "author"');
			if (isset($author_ids->role_ids) && !empty($author_ids->role_ids)) {
				$auth_if = ' AND (IF(jwf_stage_type = \'proof_reading\',jwf_role_id NOT IN(' . $author_ids->role_ids . '),TRUE)) ';
			}
		}

		$privilage_article_sql = 'SELECT DISTINCT aflw_art_id FROM ' . $Article_flow_table->getTable() . ',' . $Generic_table->getTable() . ' WHERE jwf_id = aflw_jwf_id AND jwf_stage_type NOT IN("review", "author_submission","transit", "authors_declaration", "revision","resubmission", "copyright"' . $prod_auth_stage . ') AND aflw_usr_id IS NOT NULL ' . $auth_if . ' AND aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')';
		$privilage_article_arr = $Article_flow_table->get_records_by_raw_query($privilage_article_sql);
		$privilage_article_list = array_column(json_decode(json_encode($privilage_article_arr), TRUE), 'aflw_art_id');
		// //**FETCH PRIVILAGE ROLE ARTICLE LIST** STOP**//

		if (count($review_article_list) > 0 || count($privilage_article_list) > 0) {
			$author_table = new \App\Models\Authors();
			$author_article_sql = 'SELECT DISTINCT auth_art_id,auth_usr_id FROM ' . $author_table->getTable() . ' WHERE auth_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')';
			$author_article_arr = $author_table::get_records_by_raw_query($author_article_sql);
			$author_article_list = array_column(json_decode(json_encode($author_article_arr), TRUE), 'auth_art_id');
			if (count(array_intersect($review_article_list, $author_article_list)) > 0) {
				$art_id_array = array_intersect($review_article_list, $author_article_list);
				$article_id_array = [];
				$conflict_msg .= 'Unable to merge users due to potential conflict. This will lead to a situation where the same user has acted as both the author and reviewer for article';
				foreach ($art_id_array as $key => $value) {
					$error_msg = '';
					$rvw_action = '';
					$art_condition = "art_id ={$value}";
					$art_data = $article_tbl::get_single_record('art_code', $art_condition);
					$review_article_sql = 'SELECT DISTINCT aflw_usr_id,aflw_art_id,aflw_status FROM ' . $Article_flow_table->getTable() . ',' . $Generic_table->getTable() . ' WHERE jwf_id = aflw_jwf_id AND jwf_stage_type = "review" AND aflw_parent_flow_id IS NOT NULL AND aflw_art_id =' . $value . ' AND aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')';
					$review_article_arr = $Article_flow_table->get_records_by_raw_query($review_article_sql);

					$author_article_sql = 'SELECT DISTINCT auth_usr_id FROM ' . $author_table->getTable() . ' WHERE auth_art_id =' . $value . ' AND auth_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')';
					$author_article_arr = $author_table::get_records_by_raw_query($author_article_sql);
					$sub_user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $author_article_arr[0]->auth_usr_id);
					$error_msg = $art_data->art_code . ' submitted by ' . $sub_user_data->fullname . ', ';
					$i = 0;
					foreach ($review_article_arr as $value) {
						if ($value->aflw_status === 'i') {
							$rvw_action = 'invited for reviewing the article';
						} else if ($value->aflw_status === 'a') {
							$rvw_action = 'accepted the invitation for reviewing the article';
						} else if ($value->aflw_status === 'c') {
							$rvw_action = 'reviewed the article';
						}
						$rev_user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $review_article_arr[$i]->aflw_usr_id);
						$i++;
						$error_msg .= (count($review_article_arr) > $i) ? $rev_user_data->fullname . ' ' . $rvw_action . ' and ' : ((count($review_article_arr) == $i) ? $rev_user_data->fullname . ' ' . $rvw_action . '.' : '');
					}
					if (count($art_id_array) == 1) {
						$conflict_msg .= ' (' . $art_data->art_code . '). ';
					} else {
						if (!empty($art_data->art_code)) {
							array_push($article_id_array, $error_msg);
						}
					}
				}
			}
			if (count(array_intersect($privilage_article_list, $author_article_list)) > 0) {
				$matchedUserDetails = [];
				$art_id_array = array_intersect($privilage_article_list, $author_article_list);
				$author_article_sql = 'SELECT DISTINCT auth_usr_id,auth_art_id FROM ' . $author_table->getTable() . ' WHERE auth_art_id IN (' . implode(',', $art_id_array) . ') AND auth_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')';
				$author_article_arr = $author_table::get_records_by_raw_query($author_article_sql);
				$article_id_array = [];
				$conflict_msg .= ($conflict_msg == '') ? 'Unable to merge users due to potential conflict. This will lead to a situation where the user acted as both the author and privileged user for the article' : ' And also this will lead to a situation where the user acted as both the author and privileged user for the article';
				foreach ($author_article_arr as $data) {
					$detailsArray = [];
					if (in_array($data->auth_art_id, array_intersect($privilage_article_list, $author_article_list))) {
						$art_condition = "art_id ={$data->auth_art_id}";
						$art_data = $article_tbl::get_single_record('art_code,art_submitted_by', $art_condition);
						$detailsArray['art_code'] = $art_data->art_code;
						$sub_user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $data->auth_usr_id);
						$detailsArray['auth_name'] = ($art_data->art_submitted_by == $data->auth_usr_id ? ' submitted by ' : ' co-authored by ') . $sub_user_data->fullname;
						// $priv_user_check_sql = "SELECT CONCAT( '[', GROUP_CONCAT( CONCAT( '".', jwf_role_id, '."', '=>', '".', priv_users, '."' ) ), ']' ) AS combined_array FROM ( SELECT DISTINCT jwf_role_id, GROUP_CONCAT(DISTINCT aflw_usr_id) AS priv_users FROM rvw_article_flow,rvw_journal_workflows WHERE jwf_id = aflw_jwf_id AND jwf_stage_type NOT IN('review', 'author_submission','transit', 'authors_declaration', 'revision','resubmission', 'copyright') AND aflw_usr_id IS NOT NULL  AND aflw_usr_id IN(" . $master_user_id . "," . $comma_ids . ") AND aflw_art_id = " . $data->auth_art_id . " GROUP BY aflw_art_id";
						// $priv_user_check_sql = "SELECT GROUP_CONCAT(DISTINCT jwf_role_id) AS priv_usr_roles, GROUP_CONCAT(DISTINCT aflw_usr_id) AS priv_users FROM rvw_article_flow,rvw_journal_workflows WHERE jwf_id = aflw_jwf_id AND jwf_stage_type NOT IN('review', 'author_submission','transit', 'authors_declaration', 'revision','resubmission', 'copyright') AND aflw_usr_id IS NOT NULL  AND aflw_usr_id IN(" . $master_user_id . "," . $comma_ids . ") AND aflw_art_id = " . $data->auth_art_id . " GROUP BY aflw_art_id";
						$priv_user_check_sql = "SELECT GROUP_CONCAT(jwf_role_id) AS priv_usr_roles, GROUP_CONCAT(aflw_usr_id) AS priv_users FROM rvw_article_flow,rvw_journal_workflows WHERE jwf_id = aflw_jwf_id AND jwf_stage_type NOT IN('review', 'author_submission','transit', 'authors_declaration', 'revision','resubmission', 'copyright') AND aflw_usr_id IS NOT NULL  AND aflw_usr_id IN(" . $master_user_id . "," . $comma_ids . ") AND aflw_art_id = " . $data->auth_art_id . " GROUP BY aflw_art_id";
						$priv_user_check = $Article_flow_table->get_records_by_raw_query($priv_user_check_sql);
						$worked_users_data = array();
						$priv_roles = explode(',', $priv_user_check[0]->priv_usr_roles);
						$prin_users = explode(',', $priv_user_check[0]->priv_users);
						$worked_users_data = array_combine($priv_roles, $prin_users);
						$priv_usr_data = '';
						$i = 0;
						foreach ($worked_users_data as $key => $value) {
							$i++;
							$priv_user_name = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $value);
							// $priv_user_role_check_sql = "SELECT DISTINCT jwf_role_id AS priv_usr_roles FROM rvw_article_flow,rvw_journal_workflows WHERE jwf_id = aflw_jwf_id AND jwf_stage_type NOT IN('review', 'author_submission','transit', 'authors_declaration', 'revision','resubmission', 'copyright') AND aflw_usr_id IS NOT NULL  AND aflw_usr_id IN({$value}) AND aflw_art_id = " . $data->auth_art_id . " GROUP BY aflw_art_id";
							// $priv_user_role_check = $Article_flow_table->get_records_by_raw_query($priv_user_role_check_sql);
							// $priv_user_role = $role_tbl::get_single_record('role_name', 'role_id=' . $key);
							$priv_user_role = $role_tbl::get_single_record('role_name', 'role_id=' . $key);
							$priv_usr_data .= $priv_user_name->fullname . ' worked as ' . $priv_user_role->role_name . (count($worked_users_data) > $i ? ', while ' : '');
						}
						$detailsArray['priv_usr_details'] = $priv_usr_data;
						$matchedUserDetails[] = $detailsArray;
					}
				}
				foreach ($matchedUserDetails as $msgValue) {
					$error_msg = '';
					$error_msg = $msgValue['art_code'] . $msgValue['auth_name'] . ', and ';
					$error_msg .= $msgValue['priv_usr_details'] . ' in the article. ';
					if (count($matchedUserDetails) == 1 && count(array_intersect($privilage_article_list, $author_article_list)) == 1) {
						$conflict_msg .= ' (' . $art_data->art_code . ')';
					} else {
						if (!empty($art_data->art_code)) {
							array_push($article_id_array, $error_msg);
						}
					}
				}
				// $conflict_msg .= 'Conflict may occur in user privileges';
			}
		}
		/* TASK #5001 , If reviewers who have worked on the same article and submitted their reviews, merging them should not be possible; it should be restricted */
		if (empty($conflict_msg) && !empty($user_review_submission_check) && count($user_review_submission_check) != 0) {
			$submitted_users_validation_array = [];
			$accepted_users_validation_array = [];
			$invited_users_validation_array = [];
			$accept_invited_users_validation_array = [];
			$conflict_type_array = array();
			foreach ($user_review_submission_check as $submission_data) {
				if ($submission_data->user_review_submission_count > 1) {
					$checked_user_name = ' ';
					$checked_users_progress = '';
					$submitted_users_count = 0;
					$submitted_users_key = [];
					$invited_users_count = 0;
					$invited_users_key = [];
					$accepted_users_count = 0;
					$accepted_users_key = [];
					$checked_users_id = explode(',', $submission_data->submitted_user_id);
					$checked_stage_id = $submission_data->user_stage_id;
					$checked_users_status = explode(',', $submission_data->user_flow_status);
					foreach ($checked_users_status as $index => $status) {
						if ($status === 'c') {
							$submitted_users_count++;
							$submitted_users_key[] = $index;
						} elseif ($status === 'a') {
							$accepted_users_count++;
							$accepted_users_key[] = $index;
						} elseif ($status === 'i') {
							$invited_users_count++;
							$invited_users_key[] = $index;
						}
					}
					$art_data_condition = "art_id ={$submission_data->aflw_art_id}";
					$art_data = $article_tbl::get_single_record('art_code', $art_data_condition);
					$stage_data = $Generic_table::get_single_record('jwf_stage_name', 'jwf_id=' . $checked_stage_id);
					if ($submitted_users_count >= 2) {
						$i = 0;
						$array_value = '';
						foreach ($submitted_users_key as $key => $value) {
							$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$value]);
							$checked_user_name .= $user_data->fullname;
							if (($accepted_users_count == 1 || $invited_users_count == 1)) {
								$checked_user_name .= ($i == ($submitted_users_count - 1) ? '' : (($i == ($submitted_users_count - 2)) ? (($accepted_users_count == 1 || $invited_users_count == 1) ? ' and ' : ', ') : ''));
							} else {
								$checked_user_name .= ($i != ($submitted_users_count - 2) ? ($i < ($submitted_users_count - 2) ? ', ' : '') : ' and ');
							}
							$i++;
						}
						$checked_users_progress = (($accepted_users_count == 1 || $invited_users_count == 1) ? 'have reviewed' : 'have already reviewed');
						$array_value = (($accepted_users_count == 1 || $invited_users_count == 1) ? ' both ' : '') . '' . $checked_user_name . ' ' . $checked_users_progress . ' the article ' . $art_data->art_code . ' on the stage "'.$stage_data->jwf_stage_name.'".';
						array_push($submitted_users_validation_array, $array_value);
						$conflict_type = 'submitted_users';
						if(!in_array($conflict_type,$conflict_type_array)){
							array_push($conflict_type_array,$conflict_type);
						}
					} elseif ($submitted_users_count === 1 && $accepted_users_count >= 1) {
						$i = 0;
						$array_value = '';
						foreach ($accepted_users_key as $key => $value) {
							$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$value]);
							$checked_user_name .= $user_data->fullname;
							$checked_user_name .= ($i == ($accepted_users_count - 1) ? '' : (($i == ($accepted_users_count - 2)) ? ' and ' : ''));
							$i++;
						}
						$array_value = $checked_user_name . ($accepted_users_count == 1 ? ' has ' : ' have ') . 'accepted review invitation' . ($accepted_users_count == 1 ? '' : 's') . ', and';
						$checked_user_name = ' ';
						$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$submitted_users_key[0]]);
						$checked_user_name .= $user_data->fullname . ' has already reviewed the article ' . $art_data->art_code . ' on the stage "'.$stage_data->jwf_stage_name.'".';
						$array_value .= $checked_user_name;
						array_push($accepted_users_validation_array, $array_value);
						$conflict_type = 'accepted_users';
						if(!in_array($conflict_type,$conflict_type_array)){
							array_push($conflict_type_array,$conflict_type);
						}
					} elseif ($submitted_users_count === 1 && $invited_users_count >= 1) {
						$i = 0;
						$array_value = '';
						foreach ($invited_users_key as $key => $value) {
							$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$value]);
							$checked_user_name .= $user_data->fullname;
							$checked_user_name .= ($i == ($invited_users_count - 1) ? '' : (($i == ($invited_users_count - 2)) ? ' and ' : ''));
							$i++;
						}
						$array_value = $checked_user_name . ($invited_users_count == 1 ? ' has ' : ' have ') . 'been invited to review, and';
						$checked_user_name = ' ';
						$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$submitted_users_key[0]]);
						$checked_user_name .= $user_data->fullname;
						$array_value .= $checked_user_name . ' has already reviewed the article ' . $art_data->art_code . ' on the stage "'.$stage_data->jwf_stage_name.'".';
						array_push($invited_users_validation_array, $array_value);
						$conflict_type = 'inviteted_users';
						if(!in_array($conflict_type,$conflict_type_array)){
							array_push($conflict_type_array,$conflict_type);
						}
					} elseif ($submitted_users_count === 0 && ($accepted_users_count > 0 && $invited_users_count > 0)){
						$i = 0;
						$array_value = '';
						foreach ($accepted_users_key as $key => $value) {
							$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$value]);
							$checked_user_name .= $user_data->fullname;
							$checked_user_name .= ($i == ($accepted_users_count - 1) ? '' : (($i == ($accepted_users_count - 2)) ? ' and ' : ''));
							$i++;
						}
						$checked_user_name .=($accepted_users_count == 1 ? ' has ' : ' have ') . 'accepted review invitation, ';
						$j = 0;
						foreach ($invited_users_key as $key => $value) {
							$user_data = $Users::get_single_record('concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $checked_users_id[$value]);
							$checked_user_name .= $user_data->fullname;
							$checked_user_name .= ($j == ($invited_users_count - 1) ? '' : (($j == ($invited_users_count - 2)) ? ' and ' : ''));
							$j++;
						}
						$checked_user_name .=($invited_users_count == 1 ? ' has ' : ' have ') . 'been invited to review for the article ';
						$array_value .=  $checked_user_name . $art_data->art_code . ' on the stage "'.$stage_data->jwf_stage_name.'".';
						array_push($accept_invited_users_validation_array, $array_value);
						$conflict_type = 'accept_invite_users';
						if(!in_array($conflict_type,$conflict_type_array)){
							array_push($conflict_type_array,$conflict_type);
						}
					}
				}
			}
			if (count($submitted_users_validation_array) > 0) {
				$conflict_msg .= (($conflict_msg == '') ? 'Unable to merge these users due to potential conflict. This will lead to a situation where the same user has reviewed multiple times in ' . ((count($submitted_users_validation_array) == 1) ? 'the same' : ' an') . ' article.' : ' Also this will lead to a situation where the same user has reviewed multiple times in ' . ((count($submitted_users_validation_array) == 1) ? 'the same' : ' an') . ' article.');
				$conflict_msg .= (count($submitted_users_validation_array) == 1) ? ' Here' . $submitted_users_validation_array[0] : '';
				if (count($submitted_users_validation_array) > 1) {
					$article_id_array = array_merge($article_id_array, $submitted_users_validation_array);
				}
			}

			if (count($accepted_users_validation_array) > 0) {
				$conflict_msg .= (($conflict_msg == '') ? 'Unable to merge these users due to potential conflict. This will lead to a situation where the same user has reviewed and accepted invitation for review in ' . ((count($accepted_users_validation_array) == 1) ? 'the same' : ' an') . ' article.' : ' Also this will lead to a situation where the same user has reviewed and accepted invitation for review in ' . ((count($accepted_users_validation_array) == 1) ? 'the same' : ' an') . ' article.');
				$conflict_msg .= (count($article_id_array) == 0 && count($accepted_users_validation_array) == 1) ? ' Here' . $accepted_users_validation_array[0] : '';
				if((count($article_id_array) > 0 && count($accepted_users_validation_array) > 0) || (count($article_id_array) == 0 && count($accepted_users_validation_array) > 1)){
					$article_id_array = array_merge($article_id_array, $accepted_users_validation_array);
				}
			}

			if (count($invited_users_validation_array) > 0) {
				$conflict_msg .= (($conflict_msg == '') ? 'Unable to merge these users due to potential conflict. This will lead to a situation where the same user has reviewed and invited for review in ' . ((count($invited_users_validation_array) == 1) ? 'the same' : ' an') . ' article.' : ' Also this will lead to a situation where the same user has reviewed and invited for review in ' . ((count($invited_users_validation_array) == 1) ? 'the same' : ' an') . ' article.');
				$conflict_msg .= (count($article_id_array) == 0 && count($invited_users_validation_array) == 1) ? ' Here' . $invited_users_validation_array[0] : '';
				if ((count($article_id_array) > 0 && count($invited_users_validation_array) > 0) || (count($article_id_array) == 0 && count($invited_users_validation_array) > 1)) {
					$article_id_array = array_merge($article_id_array, $invited_users_validation_array);
				}
			}

			if (count($accept_invited_users_validation_array) > 0) {
				$conflict_msg .= (($conflict_msg == '') ? 'Unable to merge these users due to potential conflict. This will lead to a situation where the user accepted the invitation and invited for review the same article.' : ' Also this will lead to a situation where the same user has reviewed and invited for review in ' . ((count($accept_invited_users_validation_array) == 1) ? 'the same' : ' an') . ' article.');
				$conflict_msg .= (count($article_id_array) == 0 && count($accept_invited_users_validation_array) == 1) ? ' Here' . $accept_invited_users_validation_array[0] : '';
				if ((count($article_id_array) > 0 && count($invited_users_validation_array) > 0) || (count($article_id_array) == 0 && count($accept_invited_users_validation_array) > 1)) {
					$article_id_array = array_merge($article_id_array, $accept_invited_users_validation_array);
				}
			}
			if(count($conflict_type_array) == 1){
				if (count($article_id_array) > 0) {
					$revoke_invitaion_for_merge = (count($article_id_array) == count($invited_users_validation_array)) ? 'revokeandmerge' : ((count($article_id_array) == count($accept_invited_users_validation_array))?'acceptinvitemerge': 'false');
				} else {
					$revoke_invitaion_for_merge = (count($invited_users_validation_array) == 1) ? 'revokeandmerge' : ((count($accept_invited_users_validation_array) == 1)?'acceptinvitemerge':'false');
				}
			}
		}
		if (empty($conflict_msg)) {
			$master_user_article_flow_check_sql = 'SELECT DISTINCT aflw_id,aflw_art_id AS art_id FROM ' . $Article_flow_table->getTable() . ' WHERE aflw_status NOT IN ("c", "a", "i") AND aflw_jwf_id IN ( SELECT jwf_id FROM `rvw_journal_workflows` WHERE jwf_stage_type = "review") AND (aflw_posted_by IN(' . $master_user_id . ') OR aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ')) GROUP BY aflw_art_id,aflw_jwf_id';
			$master_user_article_flow_check = $Article_flow_table->get_records_by_raw_query($master_user_article_flow_check_sql);
			$master_user_article_flow_list = array_column(json_decode(json_encode($master_user_article_flow_check), TRUE), 'art_id');
			$author_table = new \App\Models\Authors();
			$non_master_user_article_submission_check_sql = 'SELECT DISTINCT auth_art_id AS art_id FROM ' . $author_table->getTable() . ' WHERE auth_usr_id IN(' . $comma_ids . ')';
			$non_master_user_article_submission_check = $author_table::get_records_by_raw_query($non_master_user_article_submission_check_sql);
			$non_master_user_article_submission_list = array_column(json_decode(json_encode($non_master_user_article_submission_check), TRUE), 'art_id');
			if (!empty($master_user_article_flow_check) && count($master_user_article_flow_check) > 0 && !empty($non_master_user_article_submission_check) && count($non_master_user_article_submission_check) > 0) {
				$conflict_occur_art_id_array = array_intersect($master_user_article_flow_list, $non_master_user_article_submission_list);
				if (count($conflict_occur_art_id_array) > 0) {
					foreach ($master_user_article_flow_check as $masterdata) {
						if (in_array($masterdata->art_id, $conflict_occur_art_id_array)) {
							$this->remove_master_user_article_flow_data($masterdata->aflw_id);
						}
					}
				}
			}
		}
		$return_arr = array(
			'msg' => $conflict_msg,
			'art_id' => $article_id_array,
			'action' => $revoke_invitaion_for_merge,
		);
		return $return_arr;
	}
    
	private function tbl_user_journals($master_user_id, $comma_ids, $current_user)
	{
        $user_journals = new \App\Models\User_to_journals();
		//Manage journal and article type roles. Check the associated user has any extra roles other than master user has either in article type or journal. If has, add role to master user. Remove all the associate user records from rvw_user_journals
        $user_jou_table = $user_journals->getTable();
		$extra_roles = $user_journals::get_records_by_raw_query('SELECT usrj_jnl_id, usrj_artp_id, GROUP_CONCAT(DISTINCT usrj_role_id) as roles FROM ' . $user_jou_table . ' uj1 WHERE usrj_usr_id IN(' . $comma_ids . ') AND usrj_role_id NOT IN (SELECT usrj_role_id FROM ' . $user_jou_table . ' WHERE usrj_usr_id = ' . $master_user_id . ' AND usrj_jnl_id = uj1.usrj_jnl_id)AND usrj_artp_id IS NULL GROUP BY usrj_jnl_id');    
		$this->add_user_role_to_master($master_user_id, $extra_roles, $current_user, TRUE);
		$extra_roles = $user_journals::get_records_by_raw_query('SELECT usrj_jnl_id, usrj_artp_id, GROUP_CONCAT(DISTINCT usrj_role_id) as roles FROM ' . $user_jou_table . ' uj1 WHERE usrj_usr_id IN(' . $comma_ids . ') AND usrj_role_id NOT IN (SELECT usrj_role_id FROM ' . $user_jou_table . ' WHERE usrj_usr_id = ' . $master_user_id . ' AND usrj_artp_id = uj1.usrj_artp_id) AND usrj_artp_id IS NOT NULL GROUP BY usrj_artp_id');
		$this->add_user_role_to_master($master_user_id, $extra_roles, $current_user, FALSE);

		$user_journals::get_records_by_raw_query('DELETE FROM ' . $user_jou_table . ' WHERE usrj_usr_id IN(' . $comma_ids . ') ');
		$user_journals::get_records_by_raw_query('UPDATE ' . $user_jou_table . ' SET usrj_posted_by=' . $master_user_id . ', usrj_operation="m" WHERE usrj_posted_by IN(' . $comma_ids . ')');
		$user_journals::get_records_by_raw_query('UPDATE ' . $user_jou_table . ' SET usrj_proxy_id=' . $master_user_id . ', usrj_operation="m" WHERE usrj_proxy_id IN(' . $comma_ids . ')');

    }

    private function add_user_role_to_master($master_user_id, $extra_roles, $current_user, $insert_jnl = TRUE)
	{
        $user_journals = new \App\Models\User_to_journals();
		$insert_role_array = array();
		if (count($extra_roles) > 0)
		{
			foreach ($extra_roles as $xt_rol)
			{
				if (!empty($xt_rol->roles))
				{
					$roles = explode(',', $xt_rol->roles);
					foreach ($roles as $rls)
					{
						$temp_arr = array(
							'usrj_jnl_id' => $xt_rol->usrj_jnl_id,
							'usrj_usr_id' => $master_user_id,
							'usrj_role_id' => $rls,
							'usrj_posted_by' => $current_user['user_id'],
							'usrj_posted_date' => date('Y-m-d H:i:s'),
							'usrj_proxy_id' => $current_user['proxy_user_id'],
							'usrj_operation' => 'i');

						if ($insert_jnl == FALSE)
							$temp_arr['usrj_artp_id'] = $xt_rol->usrj_artp_id;

						$insert_role_array[] = $temp_arr;
					}
				}
			}
		}

		if (count($insert_role_array) > 0)
		{
			$user_journals::insert_batch($insert_role_array);
		}
    }
    

	private function merge_article_flow($master_user,$all_journal_code,$assoc_user = array())
	{
		$comma_ids = implode(',', $assoc_user);
		$status = array();
        $flw_id = array();
        $Article_flow_table = new \App\Models\Article_flow();
        $Article_reviewer_table = new \App\Models\Article_reviewers();
		$Email_send_log = new \App\Models\Email_send_log();
		$Change_due_date = new \App\Models\Change_due_date();
		$Review_rating = new \App\Models\Review_rating();
		//get all possible flow details that may cause duplicate entry for same stage on merging
		$qry = 'SELECT aflw_parent_flow_id, GROUP_CONCAT(aflw_id) as grp_aflw_id, GROUP_CONCAT(aflw_status) as grp_status FROM ' . $Article_flow_table->getTable() . ' WHERE aflw_usr_id IN(' . $comma_ids . ',' . $master_user . ') AND aflw_parent_flow_id IS NOT NULL GROUP BY aflw_parent_flow_id HAVING COUNT(DISTINCT aflw_usr_id) > 1';
		$art_flow_data = $Article_flow_table::get_records_by_raw_query($qry);
		if (!empty($art_flow_data))
		{
			//Maintain all completed review records of user even if duplication occurs and keep only 1 record for the stage if aflw_status other than 'c' only.
			//Consider aflw_status priority as : 'c', 'a', 'i', 'u', 'd', 'g' 
			$removed_flow_id = array();
			$completed_flow_id = array();
			foreach ($art_flow_data AS $flw_data)
			{
				$status = explode(',', $flw_data->grp_status);
				$flw_id = explode(',', $flw_data->grp_aflw_id);

				$status_keys = array_keys($status, "c");
				if (!empty($status_keys))
				{
					//get completed flow ids and get remaining flow ids to delete
					foreach ($status_keys AS $key)
					{
						$completed_flow_id[] = $flw_id[$key];
					}
					$removed_flow_id[] = array_diff($flw_id, $completed_flow_id);
				}
				elseif ($key = array_search('a', $status) !== FALSE)
				{
					//if there is no completed reviews check there is any assigned reviews, if yes, hold 1 record even if there is more and delete the remaining
					$completed_flow_id[] = $flw_id[$key];
					$removed_flow_id[] = array_diff($flw_id, $completed_flow_id);
				}
				elseif ($key = array_search('i', $status) !== FALSE)
				{
					//keep any 1 invited record for the stage
					$completed_flow_id[] = $flw_id[$key];
					$removed_flow_id[] = array_diff($flw_id, $completed_flow_id);
				}
				elseif ($key = array_search('u', $status) !== FALSE)
				{
					//keep any 1 shorlisted record
					$completed_flow_id[] = $flw_id[$key];
					$removed_flow_id[] = array_diff($flw_id, $completed_flow_id);
				}
				elseif ($key = array_search('g', $status) !== FALSE)
				{
					//keep any 1 unassigned record
					$completed_flow_id[] = $flw_id[$key];
					$removed_flow_id[] = array_diff($flw_id, $completed_flow_id);
				}
				elseif ($key = array_search('d', $status) !== FALSE)
				{
					//keep any 1 declined record
					$completed_flow_id[] = $flw_id[$key];
					$removed_flow_id[] = array_diff($flw_id, $completed_flow_id);
				}
			}

			$completed_flow_id = implode(',',$completed_flow_id);
			if (!empty($removed_flow_id))
			{

				/* 
				function impl_multD_arr(&$flwid_arr)
				{
					$flwid_arr = implode(',', $flwid_arr);
				}

				array_walk($removed_flow_id, 'impl_multD_arr');
				*/ 
				$flow_id_array = array();
				foreach ($removed_flow_id as $key => $rmvflwid) {
					if (is_array($rmvflwid)) {
						foreach ($rmvflwid as $key => $rmflwdata) {
							array_push($flow_id_array, strval($rmflwdata));
						}
					} else {
						array_push($flow_id_array, strval($rmvflwid));
					}
				}
				$removed_flow_id = implode(',', array_filter($flow_id_array));
				//remove flow ids from rvw_article_flow and from other tables containing this flow ids
				if (!empty($removed_flow_id))
				{
					$Article_flow_table::get_records_by_raw_query('DELETE FROM '.$Article_flow_table->getTable().' WHERE aflw_id IN(' . $removed_flow_id . ')');
					$Article_flow_table::get_records_by_raw_query('DELETE FROM '.$Article_flow_table::$tbk_table.' WHERE aflw_id IN(' . $removed_flow_id . ')');
					// for keep reviewer history in view article review section
					$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_suggested_reviewer_id =' . $master_user . ' WHERE sorw_aflw_id IN(' . $completed_flow_id . ') AND sorw_suggested_reviewer_id IN(' . $comma_ids . ')');
					$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_suggested_user_id =' . $master_user . ' WHERE sorw_aflw_id IN(' . $completed_flow_id . ') AND sorw_suggested_user_id IN(' . $comma_ids . ')');
					$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_invited_by =' . $master_user . ' WHERE sorw_aflw_id IN(' . $completed_flow_id . ') AND sorw_invited_by IN(' . $comma_ids . ')');
					$Article_flow_table::get_records_by_raw_query('DELETE FROM '.$Email_send_log->getTable().' WHERE  	esl_aflw_id IN(' . $removed_flow_id . ')');
					
					$Article_flow_table::get_records_by_raw_query('DELETE FROM '.$Change_due_date::$tbk_table.' WHERE cd_aflw_id IN(' . $removed_flow_id . ')');
					$Article_flow_table::get_records_by_raw_query('DELETE FROM '.$Review_rating::$tbk_table.' WHERE rvr_aflw_id IN(' . $removed_flow_id . ')');
				}
			}
		}
		else{
			$qry = 'SELECT aflw_parent_flow_id, GROUP_CONCAT(aflw_id) as grp_aflw_id, GROUP_CONCAT(aflw_status) as grp_status FROM ' . $Article_flow_table->getTable() . ' WHERE aflw_usr_id IN(' . $comma_ids . ',' . $master_user . ') AND aflw_parent_flow_id IS NOT NULL GROUP BY aflw_parent_flow_id';
			$art_flow_data = $Article_flow_table::get_records_by_raw_query($qry);
			if (!empty($art_flow_data)) {
				$article_flow_ids = implode(',',(array_column($art_flow_data, 'grp_aflw_id')));
				$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_suggested_reviewer_id = ' . $master_user . ' WHERE sorw_aflw_id IN (' . $article_flow_ids . ') AND sorw_suggested_reviewer_id IN (' . $comma_ids . ')');
				$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_suggested_user_id = ' . $master_user . ' WHERE sorw_aflw_id IN (' . $article_flow_ids . ') AND sorw_suggested_user_id IN (' . $comma_ids . ')');
				$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_invited_by = ' . $master_user . ' WHERE sorw_aflw_id IN (' . $article_flow_ids . ') AND sorw_invited_by IN (' . $comma_ids . ')');
			}
		}
		$Article_flow_table::get_records_by_raw_query('UPDATE ' . $Article_flow_table->getTable() . ' SET aflw_usr_id =' . $master_user . ',aflw_merge_date = "' . date('Y-m-d h:m:i') . '", aflw_operation="m" WHERE aflw_usr_id IN (' . $comma_ids . ')');

		$Article_flow_table::get_records_by_raw_query('UPDATE '.$Article_flow_table::$tbk_table.' SET aflw_usr_id =' . $master_user . ',aflw_merge_date = "' . date('Y-m-d h:m:i') . '" WHERE aflw_usr_id IN (' . $comma_ids . ')');

		$Article_flow_table::get_records_by_raw_query('UPDATE ' . $Article_flow_table->getTable() . ' SET aflw_posted_by =' . $master_user . ' ,aflw_operation= "m" WHERE aflw_posted_by IN(' . $comma_ids . ')');
		$Article_flow_table::get_records_by_raw_query("UPDATE " .$Article_flow_table::$tbk_table." SET aflw_posted_by =" . $master_user . " WHERE  aflw_posted_by IN(" . $comma_ids . ")");

		$Article_flow_table::get_records_by_raw_query('UPDATE ' . $Article_flow_table->getTable() . ' SET aflw_proxy_id =' . $master_user . ' ,aflw_operation= "m" WHERE  aflw_proxy_id IN(' . $comma_ids . ')');
		$Article_flow_table::get_records_by_raw_query("UPDATE ".$Article_flow_table::$tbk_table." SET aflw_proxy_id =" . $master_user . " WHERE  aflw_proxy_id IN(" . $comma_ids . ")");
    }
    
    private function tbl_article_flow_legacydata($master_user_id, $comma_ids)
	{
        $aflw_legacy_table = new \App\Models\Article_flow_legacy();
		$aflw_legacy_table::get_records_by_raw_query('UPDATE ' . $aflw_legacy_table->getTable() . ' SET afld_user_id=' . $master_user_id . '  WHERE afld_user_id IN(' . $comma_ids . ')');
		$qry = "SELECT afld_arld_id,afld_stage_name,afld_stage_type,afld_stage_role,afld_id,count('afld_id'),MAX(afld_id) AS currenr_id FROM ".$aflw_legacy_table->getTable()." WHERE afld_user_id = " . $master_user_id ." GROUP BY afld_arld_id,afld_stage_name,afld_stage_type,afld_stage_role HAVING COUNT(*) > 1";

		$duplicate_values = $aflw_legacy_table::get_records_by_raw_query($qry);

		if (!empty($duplicate_values))
		{
			foreach ($duplicate_values AS $val)
			{
				$current_id = $val->currenr_id;
				$query = "DELETE FROM " . $aflw_legacy_table->getTable() . " WHERE 
                           afld_arld_id = " . $val->afld_arld_id . " AND
                           afld_stage_name = '" . $val->afld_stage_name . "' AND
                           afld_stage_type = '" . $val->afld_stage_type . "' AND
                           afld_stage_role = '" . $val->afld_stage_role . "' AND
                           afld_id != '" . $current_id . "' AND
                           afld_user_id = " . $master_user_id;
				$del_duplicate =$aflw_legacy_table::get_records_by_raw_query($query);
			}
		}
    }
    
    private function tbl_article_authors($master_user_id, $comma_ids, $master_details)
	{
		//#4543 Manage author data listing (normalization)
        $author_table = new \App\Models\Authors();
        $attach_art_table = new \App\Models\Attachment_files();
		$get_art_ids = $author_table::get_all_records("GROUP_CONCAT(DISTINCT auth_art_id) AS auth_id_array","auth_usr_id IN({$comma_ids})");
		if (!empty($get_art_ids) && $get_art_ids[0]->auth_id_array != '') {
			$author_art_id = explode(',', $get_art_ids[0]->auth_id_array);
			foreach ($author_art_id as $value) {
				$attach_array = $attach_art_table::get_all_records('*', "atmnt_art_id={$value}");
				if (!empty($attach_array) && count($attach_array) > 0) {
				$attach_art_table::get_records_by_raw_query('UPDATE ' . $attach_art_table->getTable() . ' SET atmnt_old_label= 101010 WHERE atmnt_art_id IN(' . $value . ')');
				}
			}
		}
		$author_table::get_records_by_raw_query('UPDATE '. $author_table->getTable().' SET auth_usr_id=' . $master_user_id . ', auth_merge_date="' . date('Y-m-d H:i:s') . '", auth_operation="m" WHERE auth_usr_id IN(' . $comma_ids . ')');
		
		$author_table::get_records_by_raw_query('UPDATE '.$author_table::$tbk_table.' SET auth_usr_id=' . $master_user_id . ', auth_merge_date="' . date('Y-m-d H:i:s') . '" WHERE auth_usr_id IN(' . $comma_ids . ')');
		//remove duplicate author entry for an article after merging. Keep corresponding author record if the user is corr. author else keep record with maximum auth id
		
		$duplicate_authors = $author_table::get_records_by_raw_query('SELECT auth_art_id, max(auth_id) as max_auth_id FROM ' . $author_table->getTable() . ' WHERE auth_usr_id = ' . $master_user_id . ' GROUP BY auth_art_id HAVING COUNT(auth_id)>1');
		
		
		foreach ($duplicate_authors as $auth_art)
		{
			$exclude_id = $auth_art->max_auth_id;
            $record_condition = ' auth_usr_id ='. $master_user_id .' && auth_art_id ='.$auth_art->auth_art_id;
			$record = $author_table::get_all_records('auth_id, auth_corr_author', $record_condition);

			if (gettype($record) === 'object') {
				$record = $record->toArray();
			} 
				$record_filter = array_filter($record, function ($arr) {
					if ($arr->auth_corr_author == 'y')
						return $arr;
				});
			if (!empty($record_filter))
			{
				$key = array_keys($record_filter);
				$exclude_id = $record_filter[$key[0]]->auth_id;
			}

			$author_table::get_records_by_raw_query('DELETE FROM ' . $author_table->getTable() . ' WHERE auth_usr_id = ' . $master_user_id . ' AND auth_art_id = ' . $auth_art->auth_art_id . ' AND auth_id !=' . $exclude_id);
			$author_table::get_records_by_raw_query('DELETE FROM '.$author_table::$tbk_table.' WHERE auth_usr_id = ' . $master_user_id . ' AND auth_art_id = ' . $auth_art->auth_art_id . ' AND auth_id !=' . $exclude_id);

			$rem_auth_ids = array_diff(array_column(json_decode(json_encode($record), TRUE), 'auth_id'), array(
				$exclude_id));
			if (!empty($rem_auth_ids))
			{
				//$load_models['Authors']->execute_query('DELETE FROM tbk_author_affiliation WHERE auaff_auth_id IN(' . implode(',', $rem_auth_ids) . ')');
				//Delete authors from  rvw_casrai_conflicts
				if ($this->current_client->modules->mdl_casrai_credit == 'y')
				{
					$author_table::get_records_by_raw_query('DELETE FROM rvw_casrai_conflicts WHERE con_auth_id IN(' . implode(',', $rem_auth_ids) . ')');
					$author_table::get_records_by_raw_query('DELETE FROM tbk_casrai_conflicts WHERE con_auth_id IN(' . implode(',', $rem_auth_ids) . ')');
				}
			}
		}

		//update proxy_id and posted_by
		$author_table::get_records_by_raw_query('UPDATE ' . $author_table->getTable() . ' SET auth_posted_by=' . $master_user_id . ', auth_operation="m" WHERE auth_posted_by IN(' . $comma_ids . ')');
		$author_table::get_records_by_raw_query('UPDATE '.$author_table::$tbk_table.' SET auth_posted_by=' . $master_user_id . ' WHERE auth_posted_by IN(' . $comma_ids . ')');

		$author_table::get_records_by_raw_query('UPDATE ' . $author_table->getTable() . ' SET auth_proxy_id=' . $master_user_id . ', auth_operation="m" WHERE auth_proxy_id IN(' . $comma_ids . ')');
		$author_table::get_records_by_raw_query('UPDATE '.$author_table::$tbk_table.' SET auth_proxy_id=' . $master_user_id . ' WHERE auth_proxy_id IN(' . $comma_ids . ')');
    }
    
    private function tbl_article_generic_form_data($master_user_id, $comma_ids, $all_journal_code)
	{
        $generic_form_table = new \App\Models\Generic_forms();
		foreach ($all_journal_code as $code)
		{
			$table_name ='rvw_article_gnf_form_data_'. $code; // TASK #5001 When merging a "Submitted Reviewer" with a "Shortlisted Reviewer," the name of the submitted reviewer is not displayed on the "Completed Review" tab.
			$table_name_tbk = 'tbk_article_gnf_form_data_' . $code;
			if(Schema::hasTable($table_name))
			{
				$generic_form_table::get_records_by_raw_query('UPDATE ' . $table_name . ' SET gdata_posted_by=' . $master_user_id . ',gdata_operation="m" WHERE gdata_posted_by IN(' . $comma_ids . ')');
				$generic_form_table::get_records_by_raw_query('UPDATE ' . $table_name . ' SET gdata_proxy_id=' . $master_user_id . ',gdata_operation="m" WHERE gdata_proxy_id IN(' . $comma_ids . ')');
			}
			
		}
    }
    

	private function tbl_article_legacydata($master_user_id, $comma_ids, $asso_user_ids)
	{
        $article_legacy = new \App\Models\Article_legacydata();

		$article_legacy::get_records_by_raw_query('UPDATE ' . $article_legacy->getTable() . ' SET arld_submitted_by=' . $master_user_id . ' WHERE arld_submitted_by IN(' . $comma_ids . ')');
		$article_legacy::get_records_by_raw_query('UPDATE ' . $article_legacy->getTable() . ' SET arld_decision_by=' . $master_user_id . ' WHERE arld_decision_by IN(' . $comma_ids . ')');
		$article_legacy::get_records_by_raw_query('UPDATE ' . $article_legacy->getTable() . ' SET arld_corresp_author_id=' . $master_user_id . ' WHERE arld_corresp_author_id IN(' . $comma_ids . ')');
		foreach ($asso_user_ids as $aso_usr_id)
		{
			$update_data = array();
			$get_record = $article_legacy::get_records_by_raw_query('SELECT arld_id,arld_author_id, arld_reviewers,arld_editors, arld_users FROM ' . $article_legacy->getTable() . ' WHERE FIND_IN_SET(' . $aso_usr_id . ',arld_author_id) OR FIND_IN_SET(' . $aso_usr_id . ',arld_reviewers) OR FIND_IN_SET(' . $aso_usr_id . ',arld_editors) OR FIND_IN_SET(' . $aso_usr_id . ',arld_users)');

			foreach ($get_record as $record)
			{
				$author_id = explode(',', $record->arld_author_id);
				$reviewers = explode(',', $record->arld_reviewers);
				$editors = explode(',', $record->arld_editors);
				$users = explode(',', $record->arld_users);
				if (in_array($aso_usr_id, $author_id))
				{
					$author_id = array_diff($author_id, array(
						$aso_usr_id));
					array_push($author_id, $master_user_id);
				}
				if (in_array($aso_usr_id, $reviewers))
				{
					$reviewers = array_diff($reviewers, array(
						$aso_usr_id));
					array_push($reviewers, $master_user_id);
				}
				if (in_array($aso_usr_id, $editors))
				{
					$editors = array_diff($editors, array(
						$aso_usr_id));
					array_push($editors, $master_user_id);
				}
				if (in_array($aso_usr_id, $users))
				{
					$users = array_diff($users, array(
						$aso_usr_id));
					array_push($users, $master_user_id);
				}

				$author_id = !empty($author_id) ? implode(',', $author_id) : NULL;
				$reviewers = !empty($reviewers) ? implode(',', $reviewers) : NULL;
				$editors = !empty($editors) ? implode(',', $editors) : NULL;
				$users = !empty($users) ? implode(',', $users) : NULL;

				$update_data[] = array(
					'arld_id' => $record->arld_id,
					'arld_author_id' => $author_id,
					'arld_reviewers' => $reviewers,
					'arld_editors' => $editors,
					'arld_users' => $users
				);
			}
			if (!empty($update_data))
            $article_legacy::update_batch($update_data, 'arld_id');
		}
    }
    
    private function tbl_article_publons($master_user_id, $comma_ids)
	{
        $article_publons = new \App\Models\Article_publons();
        $publon_table = $article_publons->getTable();

		$article_publons::get_records_by_raw_query('UPDATE ' . $publon_table . ' SET pub_usr_id=' . $master_user_id . ' WHERE pub_usr_id IN(' . $comma_ids . ')');
		$article_publons::get_records_by_raw_query('UPDATE ' . $publon_table . ' SET pub_posted_by=' . $master_user_id . ' WHERE pub_posted_by IN(' . $comma_ids . ')');
		$article_publons::get_records_by_raw_query('UPDATE ' . $publon_table . ' SET pub_proxy_id=' . $master_user_id . ' WHERE pub_proxy_id IN(' . $comma_ids . ')');

		//delete duplicate entry : keep record with pub_status = y if any, else keep record with max.pub_id 
		$duplicate_publon_entry = $article_publons::get_records_by_raw_query('SELECT pub_art_id, pub_jnl_id, pub_usr_id, max(pub_id) as max_pub_id FROM ' . $publon_table . ' WHERE pub_usr_id = ' . $master_user_id . ' GROUP BY pub_art_id, pub_jnl_id, pub_usr_id HAVING COUNT(pub_id)>1');

		if (!empty($duplicate_publon_entry))
		{
			foreach ($duplicate_publon_entry as $pub)
			{
                $status_condition = 'pub_art_id ='. $pub->pub_art_id .' && pub_jnl_id='.$pub->pub_jnl_id.' && pub_usr_id ='. $master_user_id . ' && pub_status = "y"';
				$check_for_ystatus = $article_publons::get_single_record('pub_id', $status_condition);
                if (!empty($check_for_ystatus) && !empty($check_for_ystatus->pub_id))
                {
                    $hold_id = $check_for_ystatus->pub_id;
                }
                else
                {
                    $hold_id = $pub->max_pub_id;
                }
                $this->current_user = $this->get_current_user_details();
                $publon_delete_condition = " pub_art_id={$pub->pub_art_id} && pub_jnl_id={$pub->pub_jnl_id} && pub_usr_id={$master_user_id} && pub_id !={$hold_id} ";
				$article_publons::delete_records($publon_delete_condition,'',$this->current_user);
			}
		}
    }
    
    private function tbl_user_articles($master_user_id, $comma_ids)
	{
        //SET UPDATAE ON USER ARTICLE TABLE ** START
        $user_articles = new \App\Models\User_articles();
        $user_article_table = $user_articles->getTable();
		$user_articles::get_records_by_raw_query('UPDATE IGNORE ' . $user_article_table . ' SET usra_usr_id=' . $master_user_id . ', usra_merge_date="' . date('Y-m-d h:m:i') . '", usra_operation="m" WHERE usra_usr_id IN(' . $comma_ids . ')');

		$where_cond = ' usra_usr_id IN (' . $comma_ids . ')';
		$result_still_comma_ids = $user_articles::get_all_records('usra_id', $where_cond);
		$old_users = array_column(json_decode(json_encode($result_still_comma_ids), TRUE), 'usra_id');
		//SET UPDATAE ON USER ARTICLE TABLE ** STOP
		//SET UPDATAE ON TBK-USER ARTICLE TABLE ** START
		if (count($old_users) > 0)
		{
			$del_sql = 'DELETE FROM ' . $user_article_table . ' WHERE usra_id IN (' . implode(',', $old_users) . ')';
			$del_sql_tbk = 'DELETE FROM '.$user_article_table::$tbk_table.' WHERE usra_id IN (' . implode(',', $old_users) . ')';
			$user_articles::get_records_by_raw_query($del_sql);
			$user_articles::get_records_by_raw_query($del_sql_tbk);
		}

		$user_articles::get_records_by_raw_query('UPDATE '.$user_articles::$tbk_table.' SET usra_usr_id=' . $master_user_id . ', usra_merge_date="' . date('Y-m-d h:m:i') . '" WHERE usra_usr_id IN(' . $comma_ids . ')');
		//SET UPDATAE ON TBK-USER ARTICLE TABLE ** STOP
		$user_articles::get_records_by_raw_query('UPDATE ' . $user_article_table . ' SET usra_posted_by=' . $master_user_id . ', usra_operation="m" WHERE usra_posted_by IN(' . $comma_ids . ')');
		$user_articles::get_records_by_raw_query('UPDATE '.$user_articles::$tbk_table.' SET usra_posted_by=' . $master_user_id . ' WHERE usra_posted_by IN(' . $comma_ids . ')');

		$user_articles::get_records_by_raw_query('UPDATE ' . $user_article_table . ' SET usra_proxy_id=' . $master_user_id . ', usra_operation="m" WHERE usra_proxy_id IN(' . $comma_ids . ')');
		$user_articles::get_records_by_raw_query('UPDATE '.$user_articles::$tbk_table.' SET usra_proxy_id=' . $master_user_id . ' WHERE usra_proxy_id IN(' . $comma_ids . ')');
    }
    
    private function tbl_user_emails($master_user_id, $comma_ids)
	{
        //not use tbk table. no trigger
        $user_email = new \App\Models\User_emails();
        $user_email_table = $user_email->getTable();
		$get_master_user_cc_emails = $user_email::get_records_by_raw_query('SELECT DISTINCT uml_email FROM rvw_user_emails WHERE uml_user_id = ' . $master_user_id);
		$get_master_user_cc_emails = array_column(json_decode(json_encode($get_master_user_cc_emails), TRUE), 'uml_email');

		//since allow only 5 alternate emails in our system
		if (count($get_master_user_cc_emails) >= 5)
		{
			$user_email::get_records_by_raw_query('DELETE FROM ' . $user_email_table . ' WHERE uml_user_id IN( ' . $comma_ids . ')');
		}
		else
		{
			$xtra_condtn = '';
			$rem_count = 5 - count($get_master_user_cc_emails);

            $where_cond = ' usr_id IN (' . $comma_ids . ')';
            $user_table = new \App\Models\User();
			$other_users_primary_emails = $user_table::get_single_record('group_concat(usr_email) as usr_pri_email', $where_cond);

			$old_users = array();
			if ($other_users_primary_emails->usr_pri_email != '')
			{
				$old_users = explode(',', $other_users_primary_emails->usr_pri_email);

				foreach ($old_users as $old_eml)
				{
					if ($rem_count > 0)
					{
						$insert_sql = ' INSERT IGNORE INTO ' . $user_email_table . '(uml_user_id,uml_email,uml_cc_email,uml_url,uml_status,uml_posted_by,uml_posted_date,uml_proxy_id,uml_operation) VALUES(' . $master_user_id . ',"' . $old_eml . '","n","","n",' . $master_user_id . ',"' . date('Y-m-d H:i:s') . '",0,"i") ';

						$res = $user_email::get_records_by_raw_query($insert_sql, TRUE);
						if ($res > 0)
						{
							$rem_count = $rem_count - 1;
						}
					}
					else
						break;
				}
			}

			if ($rem_count > 0)
			{
				$where_cond_user_email = ' uml_user_id IN (' . $comma_ids . ')';
				if (!empty($get_master_user_cc_emails))
					$where_cond_user_email .= ' AND uml_email NOT IN ("' . implode('","', $get_master_user_cc_emails) . '") AND trim(uml_email) != ""';

				$other_users_secondary_emails = $user_email::get_all_records('uml_id', $where_cond_user_email);
				if (count($other_users_secondary_emails) > 0)
				{
					foreach ($other_users_secondary_emails as $other_usr_sec_mail)
					{
						if ($rem_count > 0)
						{
							$result = $user_email::get_records_by_raw_query('UPDATE IGNORE ' . $user_email_table . ' SET uml_user_id=' . $master_user_id . ', uml_operation="m" WHERE uml_id= ' . $other_usr_sec_mail->uml_id, TRUE);
							if ($result > 0)
							{
								$rem_count = $rem_count - 1;
							}
						}
						else
							break;
					}
					$user_email::get_records_by_raw_query('DELETE FROM ' . $user_email_table . ' WHERE uml_user_id IN(' . $comma_ids . ')');
				}
			}
		}

		$user_email::get_records_by_raw_query('UPDATE ' . $user_email_table . ' SET uml_posted_by=' . $master_user_id . ', uml_operation="m" WHERE uml_posted_by IN(' . $comma_ids . ')');

		$user_email::get_records_by_raw_query('UPDATE ' . $user_email_table . ' SET uml_proxy_id=' . $master_user_id . ', uml_operation="m" WHERE uml_proxy_id IN(' . $comma_ids . ')');
	}

	private function tbl_user_flags($master_user_id, $comma_ids)
	{
        $user_flag = new \App\Models\User_flags();
        $user_flag_table = $user_flag->getTable();
		$user_flag::get_records_by_raw_query('UPDATE IGNORE ' . $user_flag_table . ' SET uf_usr_id=' . $master_user_id . ', uf_operation= "m" WHERE uf_usr_id IN(' . $comma_ids . ')');
		$user_flag::get_records_by_raw_query('DELETE FROM ' . $user_flag_table . ' WHERE uf_usr_id IN(' . $comma_ids . ')');
		$user_flag::get_records_by_raw_query('UPDATE ' . $user_flag_table . ' SET uf_posted_by=' . $master_user_id . ', uf_operation= "m" WHERE uf_posted_by IN(' . $comma_ids . ')');
		$user_flag::get_records_by_raw_query('UPDATE ' . $user_flag_table . ' SET uf_proxy_id=' . $master_user_id . ', uf_operation= "m" WHERE uf_proxy_id IN(' . $comma_ids . ')');
    }
    
    private function tbl_user_global_flags($master_user_id, $comma_ids)
	{
        $user_global_flag =  new \App\Models\User_global_flags();
        $user_global_flg_tbl = $user_global_flag->getTable();
		$user_global_flag::get_records_by_raw_query('UPDATE IGNORE ' . $user_global_flg_tbl . ' SET ugf_user_id=' . $master_user_id . ',ugf_operation="m" WHERE ugf_user_id IN(' . $comma_ids . ')');

		$user_global_flag::get_records_by_raw_query('DELETE FROM ' . $user_global_flg_tbl . '  WHERE ugf_user_id IN(' . $comma_ids . ')');

		$user_global_flag::get_records_by_raw_query('UPDATE ' . $user_global_flg_tbl . ' SET ugf_posted_by	=' . $master_user_id . ',ugf_operation="m" WHERE ugf_posted_by IN(' . $comma_ids . ')');

		$user_global_flag::get_records_by_raw_query('UPDATE ' . $user_global_flg_tbl . ' SET ugf_proxy_id=' . $master_user_id . ',ugf_operation="m" WHERE ugf_proxy_id IN(' . $comma_ids . ')');
    }
    

	private function tbl_user_journal_classifications($master_user_id, $comma_ids)
	{
        $usr_jour_class = new \App\Models\User_journal_classifications();
        $usr_jour_class_tbl = $usr_jour_class->getTable();

		$usr_jour_class::get_records_by_raw_query('UPDATE IGNORE ' . $usr_jour_class_tbl . ' SET jucl_usr_id=' . $master_user_id . ',jucl_operation="m" WHERE jucl_usr_id IN(' . $comma_ids . ')');

		//remove duplicates -- start
		$sql = 'SELECT jucl_jntm_id, MAX(jucl_id) AS max_jucl_id FROM ' . $usr_jour_class_tbl . ' WHERE jucl_usr_id = ' . $master_user_id . ' AND jucl_artp_id IS NULL GROUP BY jucl_jntm_id HAVING COUNT(jucl_id) > 1';
		//REMOVE ROWS WHICH ARTICLE TYPE IS NULL
		$duplicate_class_for_jnl = $usr_jour_class::get_records_by_raw_query($sql);
		foreach ($duplicate_class_for_jnl as $class)
		{
            $usr_jour_class::get_records_by_raw_query('DELETE FROM ' . $usr_jour_class_tbl . ' WHERE jucl_usr_id = ' . $master_user_id . ' AND jucl_artp_id IS NULL AND jucl_jntm_id = ' . $class->jucl_jntm_id . ' AND jucl_id !=' . $class->max_jucl_id);
		}
		//REMOVE ROWS WHICH ARTICLE TYPE IS NOT NULL
		$usr_jour_class::get_records_by_raw_query('DELETE FROM ' . $usr_jour_class_tbl . ' WHERE jucl_artp_id IS NOT NULL AND jucl_usr_id IN(' . $comma_ids . ')');
		$usr_jour_class::get_records_by_raw_query('UPDATE ' . $usr_jour_class_tbl . ' SET jucl_posted_by	=' . $master_user_id . ',jucl_operation="m" WHERE jucl_posted_by IN(' . $comma_ids . ')');
		$usr_jour_class::get_records_by_raw_query('UPDATE ' . $usr_jour_class_tbl . ' SET jucl_proxy_id=' . $master_user_id . ',jucl_operation="m" WHERE jucl_proxy_id IN(' . $comma_ids . ')');
    }
    
	private function tbl_user_journal_filter_keys($master_user_id, $comma_ids)
	{
        $usr_jour_fil_keys = new \App\Models\User_journal_filter_keys();
        $usr_jour_fil_keys_tbl = $usr_jour_fil_keys->getTable();

		$usr_jour_fil_keys::get_records_by_raw_query('UPDATE  IGNORE ' . $usr_jour_fil_keys_tbl . ' SET ujfk_usr_id=' . $master_user_id . ',ujfk_operation="m" WHERE ujfk_usr_id IN(' . $comma_ids . ')');

		$usr_jour_fil_keys::get_records_by_raw_query('DELETE FROM ' . $usr_jour_fil_keys_tbl . ' WHERE ujfk_usr_id IN(' . $comma_ids . ')');

		$usr_jour_fil_keys::get_records_by_raw_query('UPDATE ' . $usr_jour_fil_keys_tbl . ' SET ujfk_posted_by=' . $master_user_id . ',ujfk_operation="m" WHERE ujfk_posted_by IN(' . $comma_ids . ')');

		$usr_jour_fil_keys::get_records_by_raw_query('UPDATE ' . $usr_jour_fil_keys_tbl . ' SET ujfk_proxy_id=' . $master_user_id . ',ujfk_operation="m" WHERE ujfk_proxy_id IN(' . $comma_ids . ')');
    }
    

	private function tbl_user_journal_preference($master_user_id, $comma_ids)
	{
        $usr_preference = new \App\Models\User_journal_preference();
        $usr_prefer_table = $usr_preference->getTable();
        $usr_preference::get_records_by_raw_query('UPDATE IGNORE ' . $usr_prefer_table . ' SET pref_usr_id=' . $master_user_id . ', pref_operation="m" WHERE pref_usr_id IN(' . $comma_ids . ')');
		$usr_preference::get_records_by_raw_query('DELETE FROM ' . $usr_prefer_table . '  WHERE pref_usr_id IN(' . $comma_ids . ')');
		$usr_preference::get_records_by_raw_query('UPDATE ' . $usr_prefer_table . ' SET pref_posted_by =' . $master_user_id . ', pref_operation="m" WHERE pref_posted_by IN(' . $comma_ids . ')');
		$usr_preference::get_records_by_raw_query('UPDATE ' . $usr_prefer_table . ' SET pref_proxy_id=' . $master_user_id . ', pref_operation="m" WHERE pref_proxy_id IN(' . $comma_ids . ')');
    }

    private function tbl_users_other_profiles($master_user_id, $comma_ids)
    {
        //rvw_user_meta
        $user_meta = new \App\Models\User_meta();
		$user_meta::get_records_by_raw_query('DELETE FROM ' . $user_meta->getTable() . ' WHERE urg_user_id IN(' . $comma_ids . ')');
        
        //rvw_user_panel_collapsible_view
        
        $user_collapse = new \App\Models\User_panel_collapsible_view();
		$user_collapse::get_records_by_raw_query('DELETE FROM ' . $user_collapse->getTable() . '  WHERE upcv_user_id IN( ' . $comma_ids . ')');

        //rvw_usr_unavailability
        $user_unavail = new \App\Models\Users_unavailability();
		$user_unavail::get_records_by_raw_query('DELETE FROM ' . $user_unavail->getTable() . '  WHERE unavail_user_id IN( ' . $comma_ids . ')');
    }
    
    private function tbl_user_journal_orcid_details($master_user_id, $comma_ids)
	{
        $user_orcid_journal = new \App\Models\User_to_journal_orcid_details();
        $user_orcid_tbl = $user_orcid_journal->getTable();
		$user_orcid_journal::get_records_by_raw_query('UPDATE IGNORE ' . $user_orcid_tbl . ' SET ujo_usr_id=' . $master_user_id . ', ujo_operation="m" WHERE ujo_usr_id IN( ' . $comma_ids . ') ');

		$user_orcid_journal::get_records_by_raw_query('DELETE FROM ' . $user_orcid_tbl . ' WHERE ujo_usr_id IN( ' . $comma_ids . ')');

		$user_orcid_journal::get_records_by_raw_query('UPDATE ' . $user_orcid_tbl . ' SET ujo_posted_by =' . $master_user_id . ', ujo_operation="m" WHERE ujo_posted_by IN(' . $comma_ids . ')');

		$user_orcid_journal::get_records_by_raw_query('UPDATE ' . $user_orcid_tbl . ' SET ujo_proxy_id=' . $master_user_id . ', ujo_operation="m" WHERE ujo_proxy_id IN(' . $comma_ids . ')');
    }

    private function tbl_user_keywords($master_user_id, $comma_ids)
	{
        $user_keywords = new \App\Models\Userkeywords();
        $user_kwd_tbl = $user_keywords->getTable();

		$user_keywords::get_records_by_raw_query('UPDATE IGNORE ' . $user_kwd_tbl . ' SET ukwd_usr_id=' . $master_user_id . ', ukwd_operation="m" WHERE ukwd_usr_id IN(' . $comma_ids . ')');

		$user_keywords::get_records_by_raw_query('DELETE FROM ' . $user_kwd_tbl . ' WHERE ukwd_usr_id IN( ' . $comma_ids . ')');

		$user_keywords::get_records_by_raw_query('UPDATE ' . $user_kwd_tbl . ' SET ukwd_posted_by =' . $master_user_id . ',  ukwd_operation="m" WHERE ukwd_posted_by IN(' . $comma_ids . ')');

		$user_keywords::get_records_by_raw_query('UPDATE ' . $user_kwd_tbl . ' SET ukwd_proxy_id=' . $master_user_id . ',  ukwd_operation="m" WHERE ukwd_proxy_id IN(' . $comma_ids . ')');
    }
    
    private function tbl_generic_discussion($master_user_id, $comma_ids)
	{ 
		if(!empty($comma_ids))
		{
            $generic_discussion = new \App\Models\Generic_discussion();
            $generic_disc_table = $generic_discussion->getTable();
            $generic_disc_cmt = new \App\Models\Generic_discussion_comments();
			$generic_disc_cmt_read = new \App\Models\Generic_discussion_read();
			$comma_ids_arr = explode(',',$comma_ids);
			foreach($comma_ids_arr as $single_id)
			{
				$get_discussion_user_ids = $generic_discussion::get_records_by_raw_query('SELECT gdis_participants_by_usr_id as userids ,gdis_id FROM `rvw_generic_discussion` WHERE JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$single_id.') is NOT NULL');	
				if(!empty($get_discussion_user_ids))
				{ 
					
					$comma_ids_arry = explode(',',$single_id);
					foreach ($get_discussion_user_ids as  $userids)
					{
						$usrids = (!empty($userids->userids)) ? json_decode($userids->userids) : array();
						foreach($usrids as $key=>$ids)
						{ 
						if(in_array($ids,$comma_ids_arry))
						{ 
							unset($usrids[$key]);
						}
						}
						array_push($usrids,$master_user_id);
						sort($usrids);
						$usrids_dec = json_encode($usrids);
						$generic_discussion::get_records_by_raw_query("UPDATE " . $generic_disc_table . " SET gdis_participants_by_usr_id ='" . $usrids_dec . "', gdis_operation='m' WHERE gdis_id = " .$userids->gdis_id);
					}	
				}
			}
        } 
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_table . ' SET gdis_started_by =' . $master_user_id . ',  gdis_operation="m" WHERE gdis_started_by IN(' . $comma_ids . ')');
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_table . ' SET gdis_posted_by=' . $master_user_id . ',  gdis_operation="m" WHERE gdis_posted_by IN(' . $comma_ids . ')');
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_table . ' SET gdis_proxy_id=' . $master_user_id . ',  gdis_operation="m" WHERE gdis_proxy_id IN(' . $comma_ids . ')');
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_cmt->getTable() . ' SET gdsc_posted_by=' . $master_user_id . ', gdsc_operation="m" WHERE gdsc_posted_by IN(' . $comma_ids . ')');	
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_cmt->getTable() . ' SET gdsc_proxy_id=' . $master_user_id . ', gdsc_operation="m" WHERE gdsc_proxy_id IN(' . $comma_ids . ')');
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_cmt_read->getTable() . ' SET gdrs_posted_by=' . $master_user_id . ', gdrs_operation="m" WHERE gdrs_posted_by IN(' . $comma_ids . ')');	
        $generic_discussion::get_records_by_raw_query('UPDATE ' . $generic_disc_cmt_read->getTable() . ' SET gdrs_proxy_id=' . $master_user_id . ', gdrs_operation="m" WHERE gdrs_proxy_id IN(' . $comma_ids . ')');
	}

    private function manage_tbl_col($master_user_id, $comma_ids)
	{
		//$Articles = new \App\Models\Articles();
		$Casrai_credits= (new \App\Models\Casrai_credits());

		$model_arr = array(
					'Articles' => array(
						'upt_columns' => array(
							'stub_created_by',
							'deleted_by',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_articles',
						'pk' => 'art_id',
						'merged' => array(
							'submitted_by')),
					'Attachment_files' => array(
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_attachment_files',
						'pk' => 'atmnt_id',
						'merged' => array(
							'posted_by')),
					'Article_biorxiv_export' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'bexp_id',
						'merged' => array()),
					'Article_biorxiv_import' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'bimp_id',
						'merged' => array()),
					'Article_deletion_reasons' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_delete_reasons'
						'pk' => 'adel_id',
						'merged' => array()),
					'Article_export_data' => array(
						'upt_columns' => array(
							'user_id',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'exp_id',
						'merged' => array(
							'posted_by')),
					'Article_flag' => array(
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_flag',
						'pk' => 'aflg_id',
						'merged' => array(
							'posted_by')),
					'Article_funder_details' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_funder_details',
						'pk' => 'afd_id',
						'merged' => array()),
					'Generic_form_files' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_generic_form_files'
						'pk' => 'agf_id',
						'merged' => array()),
					'Article_keywords' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_keywords'
						'pk' => 'ak_id',
						'merged' => array()),
					'Article_notes' => array(
					//	'this_model' => $this->Article_notes,
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_notes',
						'pk' => 'an_id',
						'merged' => array(
							'posted_by')),
					'Article_notification_emails' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_notification_emails'
						'pk' => 'ane_id',
						'merged' => array()),
					'Article_pdf' => array(
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_pdf',
						'pk' => 'pdf_id',
						'merged' => array(
							'posted_by')),
					'Article_primary_classification' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_primary_classification'
						'pk' => 'atp_id',
						'merged' => array()),
					'Article_reviewers' => array(
						'upt_columns' => array(
							'suggested_reviewer_id',
							'suggested_user_id',
							'invited_by',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_reviewers'
						'pk' => 'sorw_id',
						'merged' => array()),
					'Article_reviewer_suggest' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_reviewers_suggest'
						'pk' => 'ars_id',
						'merged' => array()),
					'Article_reviewer_legacydata' => array(
						'upt_columns' => array(
							'user_id'),
						'tbk' => FALSE,
						'tbk_name' => '',
						'pk' => 'arev_id', //no operation column for this table
						'merged' => array()),
					'Article_secondary_classification' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, 
						'pk' => 'ats_id',
						'merged' => array()),
					'Article_transfer_suggestion' => array(
						'upt_columns' => array(
							'suggested_by',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_transfer_suggestion',
						'pk' => 'ats_id',
						'merged' => array()),
					'Article_types' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_types'
						'pk' => 'artp_id',
						'merged' => array()),
					'Article_type_advance_options' => array(
					//	'this_model' => $this->Article_type_advance_options,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_article_type_advance_options'
						'pk' => 'atotp_id',
						'merged' => array()),
					'Assign_permission' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_assign_permission'
						'pk' => 'asgm_id',
						'merged' => array()),
					'Attachment_file_description' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'	//here no proxy
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_attachment_file_description'
						'pk' => 'afdec_id',
						'merged' => array()),
					'Authors_affiliation' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_author_affiliation'
						'pk' => 'auaff_id',
						'merged' => array()),
					'Change_due_date' => array(
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_change_due_date',
						'pk' => 'cd_id',
						'merged' => array(
							'posted_by')),
					'Copyright' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_copyright'
						'pk' => 'crt_id',
						'merged' => array()),
					'Copyright_master' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_copyright_master'
						'pk' => 'crtm_id',
						'merged' => array()),
					'Custom_email_template_tags' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_custom_email_template_tags'
						'pk' => 'cettag_id',
						'merged' => array()),
					'Email_send_log' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'esl_id',
						'merged' => array(
							'user_id')),
					'Email_templates' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_email_tmpls'
						'pk' => 'etmp_id',
						'merged' => array()),
					'Excluded_journal_keywords' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_excluded_journal_keywords'
						'pk' => 'ejk_id',
						'merged' => array()),
					'File_upload_type' => array(
						'upt_columns' => array(
							'posted_by'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_file_upload_type'
						'pk' => 'fut_id',
						'merged' => array()),
					'Flags' => array(
						'upt_columns' => array(
							'posted_by'), 
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_flags'
						'pk' => 'flag_id',
						'merged' => array()),
					'Flow_master' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_flow_master'
						'pk' => 'fwm_id',
						'merged' => array()),
					'Funders' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_funders' 
						'pk' => 'funder_id',
						'merged' => array()),
					'General_permission' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => FALSE,
						'tbk_name' => '', //tbk_general_permissions not in use. no trigger
						'pk' => 'id',
						'merged' => array()),
					'Generic_forms' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_generic_forms'
						'pk' => 'gncf_id',
						'merged' => array()),
					'Generic_form_elements' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_generic_form_elements'
						'pk' => 'emt_id',
						'merged' => array()),
					'Generic_form_groups' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_generic_form_group'
						'pk' => 'gfg_id',
						'merged' => array()),
					'Journals' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_journals'
						'pk' => 'jnl_id',
						'merged' => array()),
					'Journal_metadata' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_journal_metadata'
						'pk' => 'jm_id',
						'merged' => array()),
					'Journal_settings' => array(
						'upt_columns' => array(
							'editorial_production_assistant',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_journal_settings'
						'pk' => 'jset_id',
						'merged' => array()),
					'Journal_terms' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_journal_terms'
						'pk' => 'jntm_id',
						'merged' => array()),
					'Generic_flows' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_journal_workflows'
						'pk' => 'jwf_id',
						'merged' => array()),
					'Keywords' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_keywords'
						'pk' => 'kwd_id',
						'merged' => array()),
					'Keyword_category' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_keywords_category'
						'pk' => 'kwc_id',
						'merged' => array()),
					'Keyword_relationship' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_keyword_relationship'
						'pk' => 'kwdrl_id',
						'merged' => array()),
					'Payment_discounts' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_payment_discounts'
						'pk' => 'pmt_disc_id',
						'merged' => array()),
					'Payment_order' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_payment_order'
						'pk' => 'pmt_ord_id',
						'merged' => array()),
					'Reports_model' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_reports'
						'pk' => 'rep_id',
						'merged' => array()),
					'Reports_email' => array(
						'upt_columns' => array(
							'posted_by'), //'proxy_id'
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_report_email'
						'pk' => 'rmil_id',
						'merged' => array()),
					'Rescind_reset_record' => array(
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_rescind_reset_record',
						'pk' => 'rsc_id',
						'merged' => array(
							'posted_by')),
					'Review_discussion' => array(
					//	'this_model' => $this->Review_discussion,
						'upt_columns' => array(
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_review_discussions'
						'pk' => 'rvd_id',
						'merged' => array(
							'posted_by')),
					'Review_rating' => array(
					//	'this_model' => $this->Review_rating,
						'upt_columns' => array(
							'reviewer_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_review_rating',
						'pk' => 'rvr_id',
						'merged' => array(
							'rated_by')),
					'Reject_reasons' => array(
					//	'this_model' => $this->Reject_reasons,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_review_reject_reasons'
						'pk' => 'rjct_id',
						'merged' => array()),
					'Roles' => array(
					//	'this_model' => $this->Roles,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_roles'
						'pk' => 'role_id',
						'merged' => array()),
					'Stage_email_form_data' => array(
					//	'this_model' => $this->Stage_email_form_data,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_stage_email_form_data'
						'pk' => 'stg_fmdata_id',
						'merged' => array()),
					'Stage_email_templates' => array(
					//	'this_model' => $this->Stage_email_templates,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_stage_email_tmpls'
						'pk' => 'stage_etmp_id',
						'merged' => array()),
					'Terms' => array(
					//	'this_model' => $this->Terms,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_terms'
						'pk' => 'term_id',
						'merged' => array()),
					'Unassign_reviewer' => array(
					//	'this_model' => $this->Unassign_reviewer,
						'upt_columns' => array(
							'rvr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'unsn_id',
						'merged' => array()),
					'User' => array(
					//	'this_model' => $this->Users,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_users'
						'pk' => 'usr_id',
						'merged' => array()),
					'User_attachment_files' => array(
					//	'this_model' => $this->User_attachment_files,
						'upt_columns' => array(
							'user_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_user_attachment_files'
						'pk' => 'usatmnt_id',
						'merged' => array()),
					'User_note' => array(
					//	'this_model' => $this->User_note,
						'upt_columns' => array(
							'user_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_user_notes'
						'pk' => 'usnote_id',
						'merged' => array()),
					'User_meta' => array(
					//	'this_model' => $this->User_meta,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_user_meta'
						'pk' => 'urg_id',
						'merged' => array()),
					'User_panel_collapsible_view' => array(
					//	'this_model' => $this->User_panel_collapsible_view,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_user_panel_collapsible_view'
						'pk' => 'upcv_id',
						'merged' => array()),
					'Stage_email_tmpl_reference' => array(
					//	'this_model' => $this->Stage_email_tmpl_reference,
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_stage_email_tmpl_reference'
						'pk' => 'setr_id',
						'merged' => array()),
					'Reviewed_privilaged_users' => array(
					//	'this_model' => $this->Reviewed_privilaged_users,
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL, //'tbk_reviewed_privilaged_users'
						'pk' => 'rvp_id',
						'merged' => array()),
					'User_affiliations' => array(
						'upt_columns' => array(
							'user_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL,
						'pk' => 'usaff_id',
						'merged' => array()),
					'Article_rescind_request' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_rescind_request',
						'pk' => 'rrq_id',
						'merged' => array('posted_by')),	
					'Article_alternativereviewer_priority_settings' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'aaps_id',
						'merged' => array()),
					'Article_autoinvitation_emails' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'aae_id',
						'merged' => array()),
					'Article_flow_alternativereviewer_priorityorder' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'afap_id',
						'merged' => array()),
					'Article_next_task' => array(	
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'ant_id',
						'merged' => array()),
					'Article_parallel_flow_movement' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_article_parallel_flow_movement',
						'pk' => 'apfm_id',
						'merged' => array()),
					'Article_status_link_statistics' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'aslnks_id',
						'merged' => array()),
					'Article_tab_status' => array(
						'upt_columns' => array(
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'tab_status_id',
						'merged' => array()),
					'Article_user_alternativereviewer_priorityorder' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'auap_id',
						'merged' => array()),
					'Article_versions_reviewers' => array(
						'upt_columns' => array(
							'user_id',
							'proxy_id',
							'posted_by'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'artvr_id',
						'merged' => array()),
					'Attachment_designated_roles' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_attachment_designated_roles',
						'pk' => 'adr_id',
						'merged' => array()
					),
					'Primary_email' => array(
						'upt_columns' => array(
							'usr_id',
							'posted_by',
							'proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => NULL,
						'pk' => 'cpe_id',
						'merged' => array()
					),
					'Classifications' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_classifications',
						'pk' => 'cls_id',
						'merged' => array()
					),
					'Discussion_type' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_discussion_type',
						'pk' => 'dsctp_id',
						'merged' => array()
					),
					'Email_attachments' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_email_attachments',
						'pk' => 'emat_id',
						'merged' => array()
					),
					'Email_deeplink_clicktracking' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'edt_id',
						'merged' => array()
					),
					'Issues' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_issues',
						'pk' => 'iss_id',
						'merged' => array()
					),
					'Issue_attachments' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_issue_attachments',
						'pk' => 'isat_id',
						'merged' => array()
					),
					'Issue_management' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_issue_management',
						'pk' => 'ism_id',
						'merged' => array()
					),
					'Volumes' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_issue_volumes',
						'pk' => 'vol_id',
						'merged' => array()
					),
					'Journal_export_config' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_journal_export_config',
						'pk' => 'cje_id',
						'merged' => array()
					),
					'Production_attachment_files' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_production_attachment_files',
						'pk' => 'paf_id',
						'merged' => array()
					),
					'Production_stages_info' => array(
						'upt_columns' => array(
							'proxy_id','posted_by'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_production_stages_info',
						'pk' => 'psi_id',
						'merged' => array()
					),
					'Article_remove_reviewer_suggest' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'arw_id',
						'merged' => array()
					),
					'Resent_forward_emails_attachments' => array(
						'upt_columns' => array(
							'user_id','posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_resent_forward_email_attachments',
						'pk' => 'rfa_id',
						'merged' => array()
					),
					'Reviewer_filter_keys' => array(
						'upt_columns' => array(
							'usr_id','posted_by','proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'rvfk_id',
						'merged' => array() 
					),
					'Suggest_oppose_reviewer_skip' => array(
						'upt_columns' => array(
							'posted_by','proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'sk_id',
						'merged' => array()
					),
					'User_home_filter_sort_keys' => array(
						'upt_columns' => array(
							'usr_id','posted_by','proxy_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'uhfs_id',
						'merged' => array()
					),
					'User_journal_sort_keys' => array(
						'upt_columns' => array(
							'usr_id','posted_by','proxy_id'),
						'tbk' => TRUE,
						'tbk_name' => 'tbk_user_journal_sort_keys',
						'pk' => 'ujsk_id',
						'merged' => array()
					),
					// to keep merge history into new master user's info data
					'Merged_users' => array(
						'upt_columns' => array(
							'master_usr_id'),
						'tbk' => FALSE,
						'tbk_name' => NULL,
						'pk' => 'musr_id',
						'merged' => array()
					)
        );
		if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
		{
			$model_arr['Form_edithistory'] = array(
				'upt_columns' => array(
					'proxy_id'),
				'tbk' => FALSE, //need to update 
				'tbk_name' => NULL, 
				'pk' => 'feh_id',
				'merged' => array(
					'posted_by'
				));
		}

		if ($this->current_client->functionality->cfty_adhoc_user_role == 'y')
		{
			$model_arr['Adhoc_user_role'] = array(
				'upt_columns' => array(
					'usr_id',
					'posted_by',
					'proxy_id'),
				'tbk' => TRUE, //need to update 
				'tbk_name' => NULL, //tbk_adhoc_user_role  --> for avoid update tbk table
				'pk' => 'aur_id',
				'merged' => array());
		}

		if ($this->current_client->functionality->cfty_change_assignment == 'y')
		{
			$model_arr['Change_assignment'] = array(
				'upt_columns' => array(
					'posted_by',
					'proxy_id'),
				'tbk' => FALSE,
				'tbk_name' => NULL,
				'pk' => 'cag_id',
				'merged' => array(
					'old_usr_id' => 'old_usr_merge_date',
					'new_usr_id' => 'new_usr_merge_date',
				),
				'merged_anomaly' => TRUE,
			);
		}

		if ($this->current_client->modules->mdl_supplementary_files == 'y')
		{
			$model_arr['Article_supplementary_files'] = array(
				'upt_columns' => array(
					'posted_by',
					'proxy_id'),
				'tbk' => TRUE,
				'tbk_name' => NULL, //'tbk_article_supplementary_files'
				'pk' => 'asup_id',
				'merged' => array());
		}
		if ($this->current_client->modules->mdl_casrai_credit == 'y')
		{
			$model_arr['Author_credits'] = array(
				'upt_columns' => array(
					'posted_by',
					'proxy_id'),
				'tbk' => TRUE,
				'tbk_name' => 'tbk_author_credits',
				'pk' => 'acr_id',
				'merged' => array());
			$model_arr['Casrai_conflicts'] = array(
				'upt_columns' => array(
					'posted_by',
					'proxy_id'),
				'tbk' => TRUE,
				'tbk_name' => 'tbk_casrai_conflicts',
				'pk' => 'con_id',
				'merged' => array());

			$model_arr['Casrai_credits'] = array(
				'this_model' => $Casrai_credits,
				'upt_columns' => array(
					'posted_by',
					'proxy_id'),
				'tbk' => TRUE,
				'tbk_name' => NULL, //'tbk_casrai_credits'
				'pk' => 'cas_id',
				'merged' => array());
		}

		//Feature #135 JPR-121 Figshare API	
		if ($this->current_client->modules->mdl_figshare == 'y' && isset($this->jnl_data->jset_enable_figshare) && $this->jnl_data->jset_enable_figshare == 'y')
		{
			$model_arr['Figshare_docs'] = array(
				'this_model' => $this->Figshare_docs,
				'upt_columns' => array(
					'proxy_id'),
				'tbk' => TRUE,
				'tbk_name' => 'tbk_article_figshare_docs',
				'pk' => 'figshare_id',
				'merged' => array(
					'posted_by'));
		}
		
        foreach ($model_arr as $model => $mdl)
		{
			//update merge date column
			$operation_col_updt = '';
			$model_class = "App\Models\\".$model;
			$model = new $model_class;
		
			if ($mdl['tbk'] === TRUE)
			{  
				$operation_col_updt = ',' . $model::$column_prefix . 'operation = "m"';
			}
			if (!empty($mdl['merged']))
			{
				foreach ($mdl['merged'] as $key => $value)
				{
					if (isset($mdl['merged_anomaly']) && $mdl['merged_anomaly'] == TRUE)
					{
						$column_name = $key;
						$merge_date = $value;
					}
					else
					{
						$column_name = $value;
						$merge_date = 'merge_date';
					}
					$model::get_records_by_raw_query('UPDATE ' . $model->table . ' SET ' . $model::$column_prefix . $column_name . '=' . $master_user_id . ',' . $model::$column_prefix . $merge_date . ' ="' . date('Y-m-d h:m:i') . '"' . $operation_col_updt . ' WHERE ' . $model::$column_prefix . $column_name . ' IN(' . $comma_ids . ')');

					if ($mdl['tbk'] === TRUE && $mdl['tbk_name'] != NULL)
					{
						$model::get_records_by_raw_query('UPDATE ' . $mdl['tbk_name'] . ' SET ' . $model::$column_prefix . $column_name . '=' . $master_user_id . ',' . $model::$column_prefix . $merge_date . ' ="' . date('Y-m-d h:m:i') . '" WHERE ' . $model::$column_prefix . $column_name . ' IN(' . $comma_ids . ')');
					}
				}
			}

			//update other columns
			foreach ($mdl['upt_columns'] as $colmns) {
				$this->update_merge_table_data($model, $colmns, $operation_col_updt, $master_user_id, $comma_ids);
			}
			if ($mdl['tbk'] === TRUE && $mdl['tbk_name'] != NULL)
			{
				foreach ($mdl['upt_columns'] as $colmns)
				{
					$model::get_records_by_raw_query('UPDATE ' . $model->table . ' SET ' . $model::$column_prefix . $colmns . '=' . $master_user_id . ' WHERE ' . $model::$column_prefix . $colmns . ' IN(' . $comma_ids . ')');
				}
			}
		}
	}
	
	private function send_email_to_delete_user($master_user_id, $asso_user_ids, $warning_msg,$cur_usr)
	{
		$custom_data = array(
			'esl_etmp_action'=>'merge_notification',
			'merge_user_id'=>$master_user_id,
		);
		$email_data = array(
			'type' => 'global',
			'action' => 'send',
			'email_with_login' => FALSE,
			'empt_name' => 'merge_notification',
			'custom_data' => $custom_data
		);
		$merge_user = new \App\Models\Merged_users();
		$users_tbl = new \App\Models\User();

		$batch_id = $merge_user::get_single_record('max(musr_batch_id) as max_id');
		$batch_id = $batch_id->max_id + 1;
		$today = date('Y-m-d H:i:s');
		foreach ($asso_user_ids as $usr_id)
		{
			$sql = "INSERT INTO " . $merge_user->getTable() . "  (musr_usr_id,musr_master_usr_id,musr_batch_id,musr_user_legacy_id,musr_username,musr_pwd,musr_title,musr_first_name,musr_middle_name,musr_last_name,musr_email,musr_twitter_id,musr_github_id,musr_dnd,musr_dnd_jnls,musr_status,musr_institution,musr_postal_code,musr_phone_no,musr_registered,musr_filter_key,musr_home_filter_keys,musr_url,musr_activation,musr_deeplink_token,musr_roles,musr_jnl_standalone,musr_image,musr_thumb_preference,musr_f_status,musr_terms_condition,musr_last_review_invite,musr_posted_by,musr_posted_date,musr_proxy_id,musr_operation,musr_orcid_id,musr_orcid_token) SELECT " . $usr_id . "," . $master_user_id . "," . $batch_id . ",usr_user_legacy_id,usr_username,usr_pwd,usr_title,usr_first_name,usr_middle_name,usr_last_name,usr_email,usr_twitter_id,usr_github_id,usr_dnd,usr_dnd_jnls,usr_status,usr_institution,usr_postal_code,usr_phone_no,usr_registered,usr_filter_key,usr_home_filter_keys,usr_url,usr_activation,usr_deeplink_token,usr_roles,usr_jnl_standalone,usr_image,usr_thumb_preference,usr_f_status,usr_terms_condition,usr_last_review_invite," . $cur_usr['user_id'] . ",'" . $today . "'," . $cur_usr['proxy_user_id'] . ",usr_operation,usr_orcid_id,usr_orcid_token FROM " . $users_tbl->getTable() . " WHERE usr_id=" . $usr_id;
			$merge_user::get_records_by_raw_query($sql);
			$email_data['user_id']= $usr_id;
			$this->master_email_details($email_data);
		}

		$warning_text = NULL;
		if($warning_msg != '')
		{
			$warning_text = $warning_msg;
		}
		$merge_warning = new \App\Models\Merge_user_warning_log();
		$merge_warning::insert_record(array(
			'muwl_warning_text' => $warning_text,
			'muwl_batch_id' => $batch_id), $cur_usr);
		$users_tbl::delete_records('usr_id IN(' . implode(',', $asso_user_ids) . ')');
	}
	public function update_merge_table_data($model, $colmns, $operation_col_updt, $master_user_id, $comma_ids)
	{
		try {
			$model::get_records_by_raw_query('UPDATE ' . $model->table . ' SET ' . $model::$column_prefix . $colmns . '=' . $master_user_id . $operation_col_updt . ' WHERE ' . $model::$column_prefix . $colmns . ' IN(' . $comma_ids . '); ');
		} catch (Exception $e) {
			if(str_contains($e->getMessage(),'Duplicate entry')){
				$usr_id_array = explode(',', $comma_ids);
				$usr_id_array = array_map('intval', $usr_id_array);
				$model::whereIn($model::$column_prefix . $colmns, $usr_id_array)->delete();
			}
			else{
				Log::warning($e->getMessage());
				throw new Exception("Merge failed ", 1);
			}
		}
	}
	//Task 5001, revoke invitaions of the users where user flow status was invited 'i' 
	public function revoke_invitation_merge_user(Request $request)
	{
		try {
			$post_data = $request->all();
			$return_data = array(
				'status' => 'failed',
				'msg' => 'Revoke invitation operation failed'
			);
			$master_user_id = $post_data['primary'];
			$asso_user_ids = $post_data['all_users'];
			if (!empty($asso_user_ids)) //to avoid chances of risk
			{
				$asso_user_ids = array_diff($asso_user_ids, array($master_user_id));
			}
			$master_user_id = decrypt_link($master_user_id);
			foreach ($asso_user_ids as $key => $id) {
				$asso_user_ids[$key] = decrypt_link($id);
			}
			$asso_user_ids = array_unique($asso_user_ids);
			$comma_ids = implode(',', $asso_user_ids);
			$results = $this->revoke_invitations($master_user_id, $comma_ids);
			if ($results === 'true') {
				$result_data = $this->execute_merge_user($request, false);
				$return_data = $result_data->original['result'];
				return $this->success('success', 200, $return_data);
			} else {
				return $this->failure('Failed', 200, $return_data);
			}
		} catch (Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}

	//Task 5001, revoke invitaion and merge the users having art status submitted 'c' with invited 'i' 
	private function revoke_invitations($master_user_id, $comma_ids)
	{
		try {
			$return_val = 'true';
			$Article_flow_table = new \App\Models\Article_flow();
			$select_revoke_invitation_criteria = 'SELECT (aflw_id) AS art_flow_id,(aflw_status) AS user_flow_status ,(aflw_usr_id) AS submitted_user_id,aflw_art_id FROM ' . $Article_flow_table->getTable() . ' WHERE aflw_status IN ("i") AND aflw_jwf_id IN ( SELECT jwf_id FROM `rvw_journal_workflows` WHERE jwf_stage_type = "review") AND (aflw_posted_by IN(' . $master_user_id . ',' . $comma_ids . ') OR aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . '))';
			$select_revoke_invitation = $Article_flow_table->get_records_by_raw_query($select_revoke_invitation_criteria);
			if (count($select_revoke_invitation) > 0) {
				foreach ($select_revoke_invitation as $value) {
					DB::delete('DELETE FROM ' . $Article_flow_table->table . ' WHERE ' . $Article_flow_table::$column_prefix . 'id  = ' . $value->art_flow_id);
				}
			}
			return $return_val;
		} catch (Exception $e) {
			$return_val = 'false';
			return $return_val;
		}
	}
	//Task 5001, Remove article flow data from article_flow table for merge functionality
	private function remove_master_user_article_flow_data($article_flow_id)
	{
		try {
			$return_val = 'true';
			$Article_flow_table = new \App\Models\Article_flow();
			DB::delete('DELETE FROM ' . $Article_flow_table->table . ' WHERE ' . $Article_flow_table::$column_prefix . 'id  IN (' . $article_flow_id . ')');
			return $return_val;
		} catch (Exception $e) {
			$return_val = 'false';
			return $return_val;
		}
	}

	//Task 5001, Force full merge to select art flows in review section
	public function merge_review_invite_accept_users_forcefully(Request $request)
	{
		try {
			$return_data = array();
			$return_arr = array();
			$post_data = $request->all();
			$master_user_id = $post_data['primary'];
			$asso_user_ids = $post_data['all_users'];
			if (!empty($asso_user_ids)) //to avoid chances of risk
			{
				$asso_user_ids = array_diff($asso_user_ids, array($master_user_id));
			}
			$master_user_id = decrypt_link($master_user_id);
			foreach ($asso_user_ids as $key => $id) {
				$asso_user_ids[$key] = decrypt_link($id);
			}
			$asso_user_ids = array_unique($asso_user_ids);
			$comma_ids = implode(',', $asso_user_ids);
			$Article_flow_table = new \App\Models\Article_flow();
			$article_tbl = new \App\Models\Articles();

			$select_accept_invite_criteria = 'SELECT GROUP_CONCAT(DISTINCT aflw_art_id) AS art_id,GROUP_CONCAT(CONCAT((CONCAT( rvusr.usr_first_name, " ", rvusr.usr_last_name ) ), " (", ( CASE WHEN aflw_status = "i" THEN " Invited " WHEN aflw_status = "a" THEN " In progress " END ), ")" )) AS name, GROUP_CONCAT(aflw_id) as aflw_id FROM rvw_article_flow LEFT JOIN rvw_users AS rvusr ON rvusr.usr_id = rvw_article_flow.aflw_usr_id  WHERE aflw_status IN ("i","a") AND aflw_jwf_id IN ( SELECT jwf_id FROM `rvw_journal_workflows` WHERE jwf_stage_type = "review") AND aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ') GROUP BY aflw_art_id';
			$select_accept_invite_data = $Article_flow_table->get_records_by_raw_query($select_accept_invite_criteria);
			if (count($select_accept_invite_data) > 0) {
				foreach ($select_accept_invite_data as $key => $value) {
					$art_condition = "art_id ={$value->art_id}";
					$art_data = $article_tbl::get_single_record('art_code', $art_condition);
					$return_arr[$art_data->art_code] = $value;
				}
				$return_data = array_push($return_data,$select_accept_invite_data);
				return $this->success('success', 200, $return_arr);
			}
		} catch (Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}
	//Task 5001, Force fully merge selected art flow in review section
	public function merge_forcefull_invite_accept_users(Request $request)
	{
		try {
			$post_data = $request->all();
			$return_data = array(
				'status' => 'failed',
				'msg' => 'Forcefull merge operation failed'
			);
			$master_user_id = $post_data['primary'];
			$asso_user_ids = $post_data['all_users'];
			if (!empty($asso_user_ids))
			{
				$asso_user_ids = array_diff($asso_user_ids, array($master_user_id));
			}
			$master_user_id = decrypt_link($master_user_id);
			foreach ($asso_user_ids as $key => $id) {
				$asso_user_ids[$key] = decrypt_link($id);
			}
			$asso_user_ids = array_unique($asso_user_ids);
			$comma_ids = implode(',', $asso_user_ids);
			
			$art_flow_array = Rv_decrypt($post_data['articleFlowData']);
			$Article_flow_table = new \App\Models\Article_flow();
			$Article_reviewer_table = new \App\Models\Article_reviewers();
			$select_flow_id_condition = 'SELECT aflw_id FROM rvw_article_flow WHERE aflw_status IN ("i","a") AND aflw_jwf_id IN ( SELECT jwf_id FROM `rvw_journal_workflows` WHERE jwf_stage_type = "review") AND aflw_id NOT IN ('.$art_flow_array.' ) AND aflw_usr_id IN(' . $master_user_id . ',' . $comma_ids . ') ';
			$select_art_flow_id_data = $Article_flow_table->get_records_by_raw_query($select_flow_id_condition);
			if(!empty($select_art_flow_id_data)){
				$delete_art_flow_id_array = array();
				foreach ($select_art_flow_id_data as $value) {
					array_push($delete_art_flow_id_array,$value->aflw_id);
				}
				$delete_art_flow_id_array = array_values($delete_art_flow_id_array);
				$delete_art_flow_id = implode(',', $delete_art_flow_id_array);
				$result =$this->remove_master_user_article_flow_data($delete_art_flow_id);
				//Task 5001, delete records of selected user from tbk for invitation history updation with force fully selected condition
				$Article_reviewer_table::get_records_by_raw_query('DELETE FROM '.$Article_reviewer_table::$tbk_table.' WHERE sorw_suggested_reviewer_id =' . $master_user_id . ' AND sorw_aflw_id IN(' . $delete_art_flow_id . ')');
				$Article_reviewer_table::get_records_by_raw_query('DELETE FROM '.$Article_reviewer_table::$tbk_table.' WHERE sorw_suggested_user_id =' . $master_user_id . ' AND sorw_aflw_id IN(' . $delete_art_flow_id . ')');
				$Article_reviewer_table::get_records_by_raw_query('DELETE FROM '.$Article_reviewer_table::$tbk_table.' WHERE sorw_invited_by =' . $master_user_id . ' AND sorw_aflw_id IN(' . $delete_art_flow_id . ')');

				$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_suggested_reviewer_id =' . $master_user_id . ' WHERE sorw_aflw_id IN(' . $art_flow_array . ') AND sorw_suggested_reviewer_id IN(' . $comma_ids . ')');
				$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_suggested_user_id =' . $master_user_id . ' WHERE sorw_aflw_id IN(' . $art_flow_array . ') AND sorw_suggested_user_id IN(' . $comma_ids . ')');
				$Article_reviewer_table::get_records_by_raw_query('UPDATE '.$Article_reviewer_table::$tbk_table.' SET sorw_invited_by =' . $master_user_id . ' WHERE sorw_aflw_id IN(' . $art_flow_array . ') AND sorw_invited_by IN(' . $comma_ids . ')');
				
				if ($result === 'true') {
					$result_data = $this->execute_merge_user($request, false);
					$return_data = $result_data->original['result'];
					return $this->success('success', 200, $return_data);
				} else {
					return $this->failure('Failed', 200, $return_data);
				}
			}
		} catch (Exception $e) {
			return $this->failure('Failed', 500, $e);
		}
	}

}
