<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Article_rescind_request;
use Config;
use stdClass;
use Illuminate\Support\Facades\Validator;

class Manage_rescind_request_Api extends Controller
{
    public function index(Request $request)
    {
        try {
            $sort_field = isset($request->sort_field) ? $request->sort_field : 'rrq_id';
            $sort_order = isset($request->sort_order) ? $request->sort_order : 'ASC';
            $per_page   = isset($request->per_page) ? $request->per_page:10;
            
            $select = 'rrq_id,rrq_art_id,rrq_aflw_id,rrq_reason,rrq_request_status,rrq_usr_id as user_id,art_code,art_title,rrq_posted_date,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as name,jwf_stage_name as current_stage';
            $data = Article_rescind_request::get_request_rescind_data($select,$sort_order,$sort_field,$per_page);
            $date_format = $this->current_client->settings->cs_date_format;
            foreach ($data as $value) {
                $value->rrq_posted_date = date($date_format, strtotime($value->rrq_posted_date));
            }
            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function approve_rescind_request(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'rrq_id' => 'required',
                'user' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $rrq_id = decrypt_link($request->rrq_id);
            $requested_user = decrypt_link($request->user);
            $role_id = isset($request->role_id) ? decrypt_link($request->role_id):'';
            $role_name = isset($request->role_name) ? $request->role_name:'';
            $Email_templates = new \App\Models\Email_templates();
            $email_template = $Email_templates::get_single_record("*","etmp_name = 'accepted_rescind_article' and etmp_notification = 'user'");
            if (empty($email_template)) {
                return $this->warning('Warning',200,customTrans('viewarticle.undefined_template'),'warning');
            }
            $current_user = $this->get_current_user_details();
            $update_data = Article_rescind_request::update_record(['rrq_request_status' => 'a'],'rrq_id = ? and rrq_request_status = "n"',$current_user,binding_arr:[$rrq_id]);
            if ($update_data) {
                $this->send_rescind_request_mail($rrq_id,$requested_user,$email_template,$current_user,$role_id,$role_name);
                $return = [
                    'status' => 'success',
                    'msg' => customTrans('rescindrequest.recind_approved')
                ];
                return $this->success('success', 200, $return);
            }
            return $this->warning('Warning',200,customTrans('rescindrequest.invalid'),'warning');
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function reject_rescind_request(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'rrq_id' => 'required',
                'user' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $rrq_id = decrypt_link($request->rrq_id);
            $requested_user = decrypt_link($request->user);
            $role_id = isset($request->role_id) ? decrypt_link($request->role_id):'';
            $role_name = isset($request->role_name) ? $request->role_name:'';
            $Email_templates = new \App\Models\Email_templates();
            $email_template = $Email_templates::get_single_record("*","etmp_name = 'rejected_rescind_article' and etmp_notification = 'user'");
            if (empty($email_template)) {
                return $this->warning('Warning',200,customTrans('viewarticle.undefined_template'),'warning');
            }
            $current_user = $this->get_current_user_details();
            $update_data = Article_rescind_request::update_record(['rrq_request_status' => 'r'],'rrq_id = ? and rrq_request_status = "n"',$current_user,binding_arr:[$rrq_id]);
            if ($update_data) {
                $this->send_rescind_request_mail($rrq_id,$requested_user,$email_template,$current_user,$role_id,$role_name);
                $return = [
                    'status' => 'success',
                    'msg' => customTrans('rescindrequest.rescind_rejected')
                ];
                return $this->success('success', 200, $return);
            }
            return $this->warning('Warning',200,customTrans('rescindrequest.invalid'),'warning');
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*to send email to the rescind requested user 
    rrq_id - int,requested_user-int,email_template-object,current_user-int,role_id-int,role_name-string
    */
    public function send_rescind_request_mail($rrq_id,$requested_user,$email_template,$current_user,$role_id,$role_name)
    {
        $User = new \App\Models\User();
        $Articles = new \App\Models\Articles();
        $article_type = (new \App\Models\Article_types())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();
        $article_data = Article_rescind_request::get_single_record('rrq_art_id,rrq_aflw_id','rrq_id = ?',binding_arr:[$rrq_id]);
        $user_data = $User::get_single_record('usr_username,usr_status,usr_registered,usr_email','usr_id = '.$current_user['user_id']);
        $data['usr_username'] = $user_data->usr_username;
        $data['usr_status'] = $user_data->usr_status;
        $data['usr_registered'] = $user_data->usr_registered;

        $data['user_id'] = $current_user['user_id'];
        $data['proxy_user_id'] = '0';

        $recpient_user_data = $User::get_single_record('usr_id,usr_email','usr_id = ?',binding_arr:[$requested_user]);
        $tables = [
            'main_table' => $Articles->table,
            'join_table' => [
                $article_type => ['art_artp_id','artp_id'],
                $journal_table => ['artp_jnl_id','jnl_id']
            ]
        ];
        $article_details = $Articles::get_results_using_joins($tables,'art_artp_id,jnl_id,jnl_journal_code',['art_id'=>$article_data->rrq_art_id],'single');

        $email_data = new stdClass;
        $email_data->user_id = $recpient_user_data->usr_id;
        $email_data->user_email = $recpient_user_data->usr_email;
        $email_data->mail_recipient_ids = $recpient_user_data->usr_id;
        $email_data->article_id = $article_data->rrq_art_id;
        $email_data->aflw_id = $article_data->rrq_aflw_id;
        $email_data->jnl_journal_code = $article_details->jnl_journal_code;
        $email_data->jnl_id = $article_details->jnl_id;
        $email_data->artp_id = $article_details->art_artp_id;
        $email_data->email_templates_config = $this->email_templates_config();
        $email_data->join_config = $this->join_config();
        $email_data->join_dependency_config = $this->join_dependency_config();
        $email_data->user_role_tags = $this->user_role_tags();
        $email_config = 'clients.' . $this->current_client->clnt_client_code;
        $email_config_data = Config::get($email_config . '.email');
        $email_data->reply_to= $email_config_data['email_settings']['reply_to_email'];
        $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
        if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y') {
            $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
        }
        if (isset($email_template->etmp_email_template) && strpos($email_template->etmp_email_template,"OPENING_PARAGRAPH") > 0) {
            $email_template->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->etmp_email_template);
        }
        $email_data->core_role = $role_id;
        $email_data->core_role_name = $role_name;

        $data_array = array(
            'record' => $email_template,
            'email_data' => $email_data,
            'user_data' =>$data,
            'column_prefix' =>'etmp_',
        );
        $this->notify_mail($data_array);
    }
}
