<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Workflow_Assignment_type;

class Mange_Workflow_Assignment_Api extends Controller
{
    public function index(Request $request)
    {
        try {
            
            $form_data = $request->all();
            $return_array=array();
            DB::enableQueryLog();
            $select = '*';
            $sort_field = $form_data['sort_field'] ?? 'wa_id';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
            $limit = $form_data['per_page'] ?? 5;
            $select = '*';
            $return_array['workflow_assignment_type'] = Workflow_Assignment_type::get_paginated_records($select, NULL, $sort_field, $sort_order, $limit);
            return $this->success('success', 200, $return_array);

        }catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }
    public function save_workflow_assignment_type(Request $request)
    {

        try {
            $current_user = $this->get_current_user_details();
            $post_data = $request->all();

            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'minimumuser' => 'required',
                'maximumuser' => 'required',
                // 'wa_destination_review_stage_id'=>'required'
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $criteria = array(
                "wa_name" => $post_data['name']
            );
            $exist_pool = Workflow_Assignment_type::get_single_record_with_bind_cond('*', $criteria);
            $data = array(
                'wa_name' => $post_data['name'],
                'wa_minimum_user' => $post_data['minimumuser'],
                'wa_maximum_user' => $post_data['maximumuser']
            );
            if (isset($post_data['hdn_id']) && ($post_data['hdn_id'] != '')) {
                $id = Rv_decrypt($post_data['hdn_id']);
                if (empty($exist_pool) || $exist_pool->wa_id == $id) {
                    $condition = array(
                        "wa_id" => $id
                    );
                    $result = Workflow_Assignment_type::update_record($data, $condition, $current_user);
                } else {
                    $return_arr['status'] = 'failed';
                    return  $this->warning('Failed', 200, $return_arr);
                }
            } else {
                if (empty($exist_pool)) {
                    $result = Workflow_Assignment_type::insert_record($data, $current_user);
                } else {
                    $return_arr['status'] = 'failed';
                    return  $this->warning('Failed', 200, $return_arr);
                }
            }
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_single_workflow_assignment_type(Request $request)
    {
        try
        {
        $current_user = $this->get_current_user_details();
        $post_data=$request->all();
        $validator = Validator::make($request->all(), [
            'edited_id' => 'required',
        ]);
        if($validator->fails())
        {
          return $this->failure('Failed',422,$validator->errors());
        }
        $id=Rv_decrypt($post_data['edited_id']);
        $condition=array(
            "wa_id"=>$id
        );
        $result=Workflow_Assignment_type::get_single_record_with_bind_cond('*',$condition);
        return $this->success('success',200,$result);
      }
      catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
    }
    }
   public function delete_workflow_assignment_type(Request $request)
  {
    try
    {
    $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
    $current_user = $this->get_current_user_details();
    $post_data=$request->all();
    $validator = Validator::make($request->all(), [
        'delete_id' => 'required',
    ]);
    if($validator->fails())
    {
      return $this->failure('Failed',422,$validator->errors());
    }
    $id=Rv_decrypt($post_data['delete_id']);
    $criteria=array(
        "war_wa_id"=>$id
    );
    $already_allocated_assignment = $workflow_assignment_reference::get_single_record_with_bind_cond('war_id', $criteria);
    if(empty($already_allocated_assignment->war_id))
    {
    $condition=array(
        "wa_id"=>$id
    );
    $result=Workflow_Assignment_type::delete_records($condition,'',$current_user);
    return $this->success('success',200,$result);
    }
    else
    {
        $return_arr['status'] = 'failed';
        return  $this->warning('Failed', 200, $return_arr);
    }
  }
  catch (\Exception $e) {
    return  $this->failure('Failed',500,$e);
}
  }

}