<?php

namespace App\Http\Controllers;
use App\Events\ArticleStatusUpdate;
use Illuminate\Routing\Controller as BaseController;
use App\Http\Controllers\ActivityTracker;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use \stdClass;
use  App\Models\Notification;
use App\Models\User;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Roles;
use App\Models\Users;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Broadcast;
use App\Models\User_to_journals;
use App\Http\Controllers\Manage_Article_Submission_Api;
   /**
     * Notification Controller  for insert and get data mongodb 
     *
     */
class NotificationController extends Controller
{
    /**
     * Get Notification List in Login User
     * 
     */
    public function index(Request $request)
    {
        try
        {
        $post_data=$request->all();
    
        $return_array=array();
        $user_data = $this->get_current_user_details();
        $return_array['total_numer']=0;
        $return_array['currentpage']=0;
        $return_array['lastpage']=0;
        $limit=$post_data['per_page']??10;
        $notifications = Notification::where('noti_user_id', $user_data['user_id']);
        if(isset( $post_data['type'])){
            $notifications->where('noti_read_status', $post_data['type']);
        }
        $notifications->orderBy('noti_created_on', 'desc');
        $notifications=$notifications->paginate($limit); 
        $notiunreadcount = Notification::where('noti_user_id', $user_data['user_id'])
        ->where('noti_read_status','n')
        ->count();
        if(!empty($notifications))
       {
        $return_array['currentpage']=$notifications->currentPage();
        $return_array['lastpage']=$notifications->lastPage();
        $return_array['total_numer']=$notifications->total();
       }
       $return_array['noti_unread'] = 0;
       if(!empty($notiunreadcount)){
        $return_array['noti_unread']=$notiunreadcount;
       }
       $notifcation_data=$this->get_formated_notification($notifications);
       $return_array['data']=$notifcation_data['message_data']??array();
       $return_array['totalread']=$notifcation_data['readcount']??0;
        return $this->success('success',200,$return_array);
        }
        catch (\Exception $e)
        {

        return  $this->failure('Failed',500,$e);
        }
    }
/**
 * Save Notification  Each Function 
 *
 */

    public function save_notification(Request $request)
    {
        try
        {
        $post_data=$request->all();
        $user_data = $this->get_current_user_details();
        $article_id=intval($post_data['article_id']);
        $flow_id=intval($post_data['noti_flow_id']);
        $role_id=intval($post_data['noti_role_id']);
        $user_id=intval($post_data['user_id']);
        $posted_by=intval($post_data['posted_by']);
        $art_type_code='';
        $jnl_code='';
        $event=$post_data['type'];
        $post_data=array("user_id"=>$user_id,"type"=>$event,'article_id'=>$article_id,'noti_flow_id'=>$flow_id,'noti_role_id'=>$role_id,'posted_by'=>$posted_by,"art_type_code"=>$art_type_code,"jnl_code"=>$jnl_code,"created_on"=>date('Y-m-d H:i:s'),"updated_on"=>date('Y-m-d H:i:s'),"user_id_array"=>array($user_id));
        
        $notify=$this->save_notification_data($post_data);
        return $this->success('success',200,$notify);
        }
        catch (\Exception $e) {
        
            return  $this->failure('Failed',500,$e);
          }
    
    }

    /**
 * Data Array include following mandatory Parameters
 *user_id,type,article_id,flow_id,posted_by,role_id,art_type,jnl_code
 * @param array $data_array
 */
    public function save_notification_data($data_array)
    {     
       $notify=array();
       $user_id=$data_array['user_id']??'';
       $type=$data_array['noti_type']??'';
       $article_id=$data_array['article_id']??'';
       $flow_id=$data_array['noti_flow_id']??'';
       $role_id=$data_array['noti_role_id']??'';
       $posted_by=$data_array['noti_posted_by']??'';
       $jnl_code=$data_array['jnl_code']??'';
       $art_type_code=$data_array['art_type_code']??'';
       $bradcast_user_array=$data_array['user_id_array']??array();
       $posted_role_id=$data_array['noti_posted_role_id']??'';
       if(env('VITE_REVERB_ENABLED',false) ===true && isset($this->current_client->functionality->cfty_enable_user_push_notification)&&$this->current_client->functionality->cfty_enable_user_push_notification=='y')
       {
         
       $action_message=$this->build_notification_message($data_array);

      // Broadcast(new ArticleStatusUpdate(array("title" =>"Invited Reviwer", "body" => $action_message, "tag" => Str::random(6)), array(3,4)));
       ArticleStatusUpdate::dispatch(array("title" =>$action_message['action_msg_title'], "body" => $action_message['action_msg_content'], "tag" => Str::random(6)), $bradcast_user_array);
      if(isset($bradcast_user_array)&&!empty($bradcast_user_array))
      {
        foreach($bradcast_user_array as $user_id)
        {
      $data_insert= array("noti_user_id"=>intval($user_id),"noti_type"=>$type,'noti_article_id'=>intval($article_id),'noti_flow_id'=>intval($flow_id),'noti_role_id'=>intval($role_id),"noti_art_type_code"=>$art_type_code,"noti_jnl_code"=>$jnl_code,'noti_posted_by'=>intval($posted_by),'noti_read_status'=>'n',"noti_created_on"=>date('Y-m-d H:i:s'),"noti_updated_on"=>date('Y-m-d H:i:s'));
      
       
  
       $notify = Notification::create($data_insert);
      
         
        }
      }
    }
       return $notify;
    }

    public function read_notification(Request $request){
      try{
        $post_data=$request->all();
        $readid=$post_data['id']??'';
        $return_array=array();
        $user_data = $this->get_current_user_details();
        $notificationstatus = DB::connection('mongodb')->collection('rvw_notification')
        ->where('noti_user_id', $user_data['user_id']);
        if($readid!=''){
            $notificationstatus
            ->where('_id',$readid)
            ->update(['noti_read_status'=>'y']);
            }
        else{
            $notificationstatus
            ->update(['noti_read_status'=>'y']);
            }
        $notiunreadcount = Notification::where('noti_user_id', $user_data['user_id'])
            ->where('noti_read_status','n')
            ->count();
        $return_array['noti_unread'] = 0;
         if(!empty($notiunreadcount)){
         $return_array['noti_unread']=$notiunreadcount;
        }
        $return_array['read_status']='success';
       return $return_array;
      }
      catch (\Exception $e) {
        return  $this->failure('Failed',500,$e);
      }
    }

    public function get_formated_notification($notification){

          if(!empty($notification))
          {

            $return_notify_array=array();
            $return_read_status_array=array();

            foreach($notification as $notify)
            {
               
                $return_data=array();
                $action_msg=$this->build_notification_message($notify);
                $return_data['id'] = (string) $notify['_id'];
                $return_data['action_time']=$notify['noti_updated_on'];
                $return_data['action_message']=$action_msg['action_msg_body'] ;
                $return_data['message_status']='not_read';
                $return_data['all_data']=$notify;
                $return_data['status_link']=$this->set_generated_link($notify);
                if(isset($notify['noti_read_status'])&&$notify['noti_read_status']=='y')
                {
                    $return_data['message_status']='read';
                    array_push($return_read_status_array, $return_data); 
                }
                array_push($return_notify_array,$return_data);
        
            }
            $return_array['readcount']=count($return_read_status_array);
            $return_array['message_data']=$return_notify_array;
            return $return_array;
          }
    }

    public function build_notification_message($notify){

        $name='';
        $article='';
        $eventaction='';
        $return_array=array();
        $title='';
        $formated_stagename='';
        $array_data['fullname_only']=true;
        $array_data['push_notify']=true;
   
       if(isset($notify['noti_flow_id'])&&$notify['noti_flow_id']!=''&&$notify['noti_flow_id']!=0)
       {
        $array_data['jwf_role_id']=$notify['noti_role_id'];
        $array_data['aflw_id']=$notify['noti_flow_id'];
        $flow_data=(new Article_flow())->setTable(Article_flow::$tbk_table)::select('aflw_jwf_id','aflw_status')->with('journal_workflow:jwf_id,jwf_stage_name,jwf_temporary_status_name,jwf_status_name')->find($notify['noti_flow_id'])?->toArray();
    if(!empty($flow_data)){
        $workflow_data=$flow_data['journal_workflow'];
        $stage_data=new stdClass();
        $stage_data->jwf_stage_name=$workflow_data['jwf_stage_name'];
        $stage_data->jwf_temporary_status_name=$workflow_data['jwf_temporary_status_name'];
        $stage_data->jwf_status_name=$workflow_data['jwf_status_name'];
        $stage_data->aflw_status=$flow_data['aflw_status'];
        
         $role_data=Roles::get_single_record_with_bind_cond('role_assigned_role',array('role_id'=>$notify['noti_role_id']));
         $core_role=$role_data->role_assigned_role;
         $privileged_user_arttype = false;
         $privileged_user_roles = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
         if (in_array($core_role, $privileged_user_roles)) {
            $privileged_user_arttype = true;
        }
        $formated_stagename = $this->display_stage_name($stage_data,$privileged_user_arttype);
    }
       }
        if(isset($notify['noti_article_id'])&&$notify['noti_article_id']!='')
        {
            $array_data['article_id']=$notify['noti_article_id'];
        $articledata=(new Articles())->setTable(Articles::$tbk_table)::get_single_record_with_bind_cond('art_code',array("art_id"=>$notify['noti_article_id']));
        if(!empty($articledata))
        {
        $article=$articledata->art_code;
        }
        }
        if ($notify['noti_type']=="reviewer_invitation")
        {
            $event_message=' Review invitation sent';
            $title='Invited as Reviewer';
            $eventaction='invited';
           
        }
        elseif($notify['noti_type']=='reviewer_uninvitation')
        {
            $event_message=' Review uninvitation sent';
            $title='Uninvited as Reviewer';
            $eventaction='uninvited';
            
        }
        elseif($notify['noti_type']=="author_invitation")
        {
            $event_message=' Proposal invitation sent';
            $title='Invited as Author';
        }
        elseif ($notify['noti_type']== 'assigned_user')
        {
            $event_message=' assign as ';
            $title='Assigned in Article';
        }
        elseif($notify['noti_type']== 'ready_for_new_stage')
        {
            $event_message="is available for  ";
            $title="Available for $formated_stagename  stage ";
        }
        else{
            $title='Added in journal';
            $event_message=' journal added ';
        }
        if(isset($notify['noti_user_id'])&&$notify['noti_user_id']!='')
        {
               
            $array_data['user_id']=$notify['noti_user_id'];
            $namedata=$this->get_user_display_name($array_data);
            $name=$namedata['fullname'];
        }
        if(in_array($notify['noti_type'],array('reviewer_invitation','reviewer_uninvitation')))
        {
            $array_data['user_id']=$notify['noti_posted_by'];
            //dump($array_data);
            $namedata=$this->get_user_display_name($array_data);
            $name=$namedata['fullname'];
        }
        if(!in_array($notify['noti_type'],array('ready_for_new_stage')))
        {
        $return_array['action_msg_body']= "You were $eventaction by <b>$name</b> to $event_message Article $article.";
        $return_array['action_msg_content']="You were $eventaction by $name to $event_message Article $article.";
        }
        else
        {
        $return_array['action_msg_body']= "$article $event_message  <b>$formated_stagename</b> stage inspection.";
        $return_array['action_msg_content']="$article $event_message  $formated_stagename stage inspection.";
        }
        $return_array['action_msg_title']=$title;
       return $return_array;
    }
    /*Set paper url link */
    public function set_generated_link($notify_data){
        $current_user = $this->get_current_user_details();
        $view_article = '';
        if(isset($notify_data['noti_article_id'])&&isset($notify_data['noti_user_id']))
        {
        $Authors = new \App\Models\Authors;
        $chk_author = $Authors::get_single_record_with_bind_cond('count(auth_id) as count',array("auth_usr_id"=>$current_user['user_id'],"auth_art_id"=>$notify_data['noti_article_id']));
        $is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;
        if($is_author == true){
                $view_article ='author-article';
        }
        else {

            if($this->current_client->platform_type == 'conference')
            {
                $paper =    'abstract';
            }
            else
            {
                $paper =    'article';
            }

                $view_article = 'view-'.$paper;
         }
        
    }
    return $view_article;
}
/* get Activity User Name  */
public function get_name_based_on_user_id($user_id)
{
    if(isset($user_id)&&$user_id!='')
    {
    $criteria = ['usr_id' =>$user_id];
    $namedata=(new User())->setTable(User::$tbk_table)::get_single_record_with_bind_cond('CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as notify_user',$criteria);
    
    return $namedata->notify_user;
    }
}
/*
 Get Role based User List
*/
    public function get_user_role_based_userids($role_data)
    {
        $user_id_list=array();
        if (isset($role_data['jnl_journal_code']) && $role_data['art_type_id']) {
            $art_type_id=$role_data['art_type_id'];
            if (isset($role_data['article_id'])&&$role_data['article_id'] != null) {
                $article_id=$role_data['article_id'];
                

                $manange_notification_privileged_user = '';
                $manange_notification_privileged_user_condtn = '';
          
                    $manange_notification_privileged_user = ' LEFT JOIN (SELECT art_artp_id, GROUP_CONCAT(auth_usr_id) as auth_usr_id FROM rvw_articles,rvw_article_authors WHERE art_id = '.$article_id.' and art_id = auth_art_id) as art_authors_tb ON  ( usrj_artp_id = art_authors_tb.art_artp_id ) ';
                    $manange_notification_privileged_user_condtn = ' AND FIND_array_not_in( art_authors_tb.auth_usr_id,usrj_usr_id )=1 ';
                
                $select = 'IF((SELECT COUNT("usra_id") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ) > 0, '
            . '(SELECT GROUP_CONCAT(usra_usr_id SEPARATOR ",") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ), '
            . '(SELECT GROUP_CONCAT(usrj_usr_id SEPARATOR ",")  FROM rvw_user_journals '.$manange_notification_privileged_user.' WHERE usrj_role_id = role_id AND usrj_role_retired = "n" AND usrj_artp_id = ' .  $art_type_id . ' '. $manange_notification_privileged_user_condtn . ') ) AS user_id';
                $where = "role_id='{$role_data['noti_role_id']}'";
                $usr_ids = Roles::get_single_record($select, $where);
               $user_id_list=explode(",",$usr_ids->user_id);
                
           
            } else {
                /*
                $condition = "role_id ={$role_data['role_id']} AND usrj_role_retired = 'n' AND jnl_journal_code='{$role_data['jnl_journal_code']}' AND artp_id={$art_type_id}";
                if (isset($userjournal)) {
                    
                    $cours_us = User_to_journals::get_user_from_jnl('GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_email', $condition);
                    if (count($cours_recp) > 0) {
                        $email_recipients = $cours_recp[0]->usr_email;
                    }
                }
            }*/
        }
   
         
        }
        return $user_id_list;
 }
}