<?php

namespace App\Http\Controllers\Orcid;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\URL;
use App\Models\Article_flow;
use App\Models\User;
use App\Http\Traits\OrcidlibTraits;
use App\Http\Traits\StandaloneDataTrait;
use App\Http\Traits\WorkflowTrait;
use App\Models\Article_type_advance_options;
use App\Models\Articles;
use App\Models\Country;
use App\Models\Email_templates;
use App\Models\Journal_metadata;
use App\Models\Journals;
use App\Models\Keywords;
use App\Models\User_affiliations;
use App\Models\User_emails;
use App\Models\User_to_journal_orcid_details;
use App\Models\Userkeywords;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class Orcid extends Controller
{
    use OrcidlibTraits;
    use WorkflowTrait;
    use StandaloneDataTrait;

    public function index(Request $request)
    {
        $post_data = $request->all();
        $redirect_url = '/';
        $set_userdata = [];
        $status = '';
        if (isset($post_data['error'])) {
            if ($post_data['error'] == 'User denied access') {
                $error_message = customTrans('orcid.orcid_signin_deny');
            } else {
                $error_message = customTrans('orcid.orcid_error_01');
            }
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => $error_message
                )
            ];
            $redirect_url = $this->get_redirect_link();
        } else if (isset($post_data['code'])) {
            $state = array();
            $jnl_id = NULL;
            $user_id = NULL;
            $review_flag = FALSE;
            $review_type = '';
            $aflw_id = '';
            if (isset($post_data['state'])) {
                parse_str(decrypt_link($post_data['state']), $state);
                if (isset($state['jnl_id']) && $state['jnl_id'] != "") {
                    $jnl_id = $state['jnl_id'];
                    $this->set_standalone_url($jnl_id);
                }
                if (isset($state['user']) && $state['user'] != "") {
                    $user_id = $state['user'];
                }
                if (isset($state['uri']) && $state['uri'] == 'review') {
                    $review_flag = TRUE;
                    $review_type = $state['review_type'];
                    $aflw_id = $state['aflw_id'];
                }
            }
            $return = Orcid::process_authorization_code($request, $post_data['code'], $user_id, $jnl_id);
            if ($return['status'] === true) {
                if ($review_flag == TRUE) {
                    //*REVIEW TYPES*//
                    //single_review : add single review presnet aflw_id
                    //jnl_review_all : update all reviews of journal
                    //all_jnls_review : update all journals reviews
                    //*REVIEW TYPES*//

                    $update_profile = $this->update_user_orcid_details($user_id);
                    if ($update_profile['result'] == TRUE) {
                        $user_orcid = $update_profile['orcid'];
                        $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
                        $orcid_config = Config::get($review_config);


                        $orcid_url = $orcid_config['orcid']['view_url'] . $user_orcid;
                        $link_url = $orcid_config['orcid']['link_url'] . $user_orcid;
                        $msg_link = ' <a href="' . $link_url . '" target="_blank" >  <img alt="ORCID logo" src="/img/orcid_16x16.png" width="16" height="16" hspace="4" />' . $link_url . '</a>';
                        $status = 'msg_success';
                        $msg = str_replace('##USER_ORCID_LINK##', $msg_link, customTrans('orcid.orcid_integrate_success'));
                    } else {
                        $status = 'msg_error';
                        $msg = customTrans('orcid.orcid_unexpected_error');
                    }
                    //need to update review data into orcid  
                    $msg = '';
                    $data = array();
                    if ($review_type == 'single_review') {
                        $result = $this->prepare_user_review_for_orcid_update($review_type, $user_id, $aflw_id, $jnl_id);
                        $msg = $result['msg'];
                        if ($result['status'] == 'success') {
                            $status = 'msg_success';
                        } else {
                            $status = 'msg_error';
                        }
                        $redirect_url = $result['redir_url'];
                    } elseif ($review_type == 'jnl_review_all') //update journal reviews
                    {
                        $journal_condition = "jnl_id = {$jnl_id}";
                        $jnl_data = Journals::get_single_record('jnl_journal_code', $journal_condition);
                        $jnl_code = $jnl_data->jnl_journal_code;
                        if ($jnl_code) {
                            $redirect_url = $redirect_url . 'journal/' . $jnl_code;
                        } else {
                            $redirect_url = $redirect_url;
                        }
                    }
                    $data['status'] = encrypt_link($status);
                    $data['message'] = encrypt_link($msg);
                    $data['redirect_url'] = encrypt_link($redirect_url);

                    return $this->success('success', 200, $data);

                    // $this->session->set_statusflashdata($status,$msg);
                    // redirect($redirect_url);  // create return data where thes etwo lines occurs
                }
                if (isset($return['user__id']) && $return['user__id'] != '') {
                    $data = array(
                        'orcid_id' => $return['orcid_id'],
                        'token' => $return['token'],
                        'token_response' => encrypt_link($return['token_response']),
                        'state' => encrypt_link(http_build_query($state)),
                        'user_id' => $return['user__id'],
                        'message' => isset($return['message']) ? $return['message'] : '',
                    );
                    $result = $this->orcid_registration($data);
                    $set_userdata = $result['set_userdata'];
                    $redirect_url = $result['redirect_url'];
                    // $query_strng = 'orcid_id=' . $return['orcid_id'] . '&user_id=' . $return['user__id'] . '&token=' . $return['token'] . '&state=' . encrypt_link(http_build_query($state)) . '&token_response=' . encrypt_link($return['token_response']);
                    // $redirect_url = $redirect_url . 'orcid-registration?' . encrypt_link($query_strng);
                } else if (isset($return['view_orcid_info']) && $return['view_orcid_info'] != '') {
                    $data = array(
                        'orcid_id' => $return['orcid_id'],
                        'token' => $return['token'],
                        'token_response' => encrypt_link($return['token_response']),
                        'state' => encrypt_link(http_build_query($state)),
                        'view_orcid_info' => str_replace("&", "##", json_encode($return['view_orcid_info'])),
                    );
                    $result = $this->orcid_registration($data);
                    $set_userdata = $result['set_userdata'];
                    $redirect_url = $result['redirect_url'];
                    // $query_strng = 'orcid_id=' . $return['orcid_id'] . '&token=' . $return['token'] . '&view_orcid_info=' . str_replace("&", "##", json_encode($return['view_orcid_info'])) . '&state=' . encrypt_link(http_build_query($state)) . '&token_response=' . encrypt_link($return['token_response']);
                    // $redirect_url = $redirect_url . 'orcid-registration?' . encrypt_link($query_strng);
                }
            } else { // Some error occurred
                $set_userdata = [
                    'login_with_orcid',
                    array(
                        'status' => false,
                        'error_message' => $return['error_message']
                    )
                ];
                $redirect_url = $redirect_url;
            }
        } else {
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => customTrans('orcid.orcid_error_01')
                )
            ];
            $redirect_url = $redirect_url;
        }
        $data['set_userdata'] = $set_userdata;
        $data['redirect_url'] = encrypt_link($redirect_url);
        return $this->success('success', 200, $data);
    }

    private function set_standalone_url($jnl_id)
    {
        $jnl_grp = $this->get_standalone_journal_data();
        if ($jnl_grp == null) {
            $jrnl_grp_condition = "jnl_id = {$jnl_id}";
            $jrnl_grp = Journals::get_single_record('*', $jrnl_grp_condition);

            // $this->redirect_base_url = journal_url(base_url(), null, $jrnl_grp->jnl_standalone_group);
        }
    }

    private function process_authorization_code($request, $code, $user_id = NULL, $jnl_id = "")
    {
        $base_url = $this->get_redirect_link();
        $return = $this->exchange_authorization_code($code, 'orcid', $base_url);
        if ($return['status'] === false) {
            if (strpos($return['error_message'], "Reused authorization code") !== false) {
                return array(
                    'status' => false,
                    'error_message' => customTrans('orcid.orcid_reused_access_code')
                );
            } else {
                return array(
                    'status' => false,
                    'error_message' => $return['error_message']
                );
            }
        }
        $orcid_id = $this->get_orcid_id();
        $token_response = $this->get_orcid_token_response();
        if ($jnl_id == "") {
            $jnl_id = NULL;
            $obj_usr_condition = "usr_orcid_id = '{$orcid_id}' AND usr_jnl_standalone IS NULL";
            $obj_usr_details = User::get_single_record('*', $obj_usr_condition);
        } else {
            $obj_usr_condition = "usr_orcid_id = '{$orcid_id}' AND usr_jnl_standalone = {$jnl_id}";
            $obj_usr_details = User::get_single_record('*', $obj_usr_condition);
        }
        if ($obj_usr_details !== null) {
            //in login by orcid but user account  in inactive/suspended status
            if ($obj_usr_details->usr_status == 'n' || $obj_usr_details->usr_status == 's') {
                return array(
                    'status' => false,
                    'error_message' => customTrans('orcid.inactive_user_msg')
                );
            } else {
                if ($obj_usr_details->usr_status == 'w') {
                    $token = '';
                    $link_msg = $obj_usr_details->usr_id;
                    // $msg = "Your account has already been created with this ORCID. Please activate your account by clicking the confirmation link sent to your email. If you are unable to locate the email, kindly click the link to ".$link_msg." resend the activation email</a>";
                    $msg = $obj_usr_details->usr_id;
                    $orcid_auth_record = array(
                        'status' => true,
                        'user__id' => encrypt_link($obj_usr_details->usr_id),
                        'token' => $token,
                        'token_response' => json_encode($token_response),
                        'orcid_id' => $orcid_id,
                        'message' => $msg,
                    );
                } else {
                    $this->set_login_tracker('in', $obj_usr_details->usr_id, $request->ip());
                    $token = $this->set_user_loggin($obj_usr_details->usr_id);
                    $orcid_auth_record = array(
                        'status' => true,
                        'user__id' => encrypt_link($obj_usr_details->usr_id),
                        'token' => json_encode($token),
                        'token_response' => json_encode($token_response),
                        'orcid_id' => $orcid_id
                    );
                }
            }
        } else {
            $token = $this->get_token();
            $ret_val = $this->orcid_details($user_id, $jnl_id);
            $orcid_auth_record = array(
                'status' => true,
                'view_orcid_info' => $ret_val,
                'token' => $token,
                'token_response' => json_encode($token_response),
                'orcid_id' => $orcid_id,
            );
        }
        return $orcid_auth_record;
    }

    public function orcid_details($user_id, $jnl_id)
    {
        $user_table = (new \App\Models\User())->getTable();
        $user_email_table = (new \App\Models\User_emails())->getTable();
        $set_userdata = [];
        $return_email = $this->get_primary_email($user_table, $user_id, $jnl_id);
        $return_val['email'] = '';
        $return_val['cc_email'] = array();
        $return_val['first_name'] = '';
        $return_val['last_name'] = '';
        if ($return_email['status'] === true) {
            $return_val['email'] = $return_email['email'];
            if ($return_email['check_email'] != NULL) {
                $return_val['check_email_msg'] = customTrans('orcid.orcid_email_exist');
            }
        } else {
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => $return_email['error_message']
                )
            ];
            $base_url = $this->get_redirect_link();
            redirect($base_url);
        }
        $secondary_email = $this->get_secondary_emails($user_email_table);
        if ($secondary_email['status'] == true) {
            $return_val['cc_email'] = $secondary_email['email_array'];
        } else {
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => $return_email['error_message']
                )
            ];
            $base_url = $this->get_redirect_link();
            redirect($base_url);
        }
        $return_personal_info = $this->get_personal_details();
        if ($return_personal_info['status'] === true) {
            $return_val['first_name'] = $return_personal_info['first_name'];
            $return_val['last_name'] = $return_personal_info['last_name'];
        } else {
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => $return_personal_info['error_message']
                )
            ];
            $base_url = $this->get_redirect_link();
            redirect($base_url);
        }
        $return_emp_affl_info = $this->get_employments();
        if ($return_emp_affl_info['status'] === true) {
            $return_val['employments'] = $return_emp_affl_info['employments'];
        } else {
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => $return_emp_affl_info['error_message']
                )
            ];
            $base_url = $this->get_redirect_link();
            redirect($base_url);
        }
        $return_edu_affl_info = $this->get_education_details();
        if ($return_edu_affl_info['status'] === true) {
            $return_val['educations'] = $return_edu_affl_info['educations'];
        } else {
            $set_userdata = [
                'login_with_orcid',
                array(
                    'status' => false,
                    'error_message' => $return_edu_affl_info['error_message']
                )
            ];
            $base_url = $this->get_redirect_link();
            redirect($base_url);
        }
        $return_array = [
            'return_val' => $return_val,
            'set_used_data' => $set_userdata
        ];
        return $return_array;
    }

    public function orcid_info_save(Request $request)
    {
        // $form_data = $request('orcid');
        $form_data = $request->all();
        $orcid_user_data = $form_data['userdetails'];
        $orcid_data = $form_data['orcid'];
        $formid = decrypt_link($form_data['feedbackData']['form_id']);
        $generic_form_data = [];
        $cc_mail_array = [];
        foreach ($form_data['feedbackData'] as $val => $values) {
            if (strpos($val, "form_") !== false && $val !== 'form_id') {
                $ind_val = explode('_', $val);
                $generic_form_data['form_' . $formid]['ctrl_' . $ind_val[2]] = $form_data['feedbackData'][$val];
            }
        }
        if ($form_data !== NULL) {
            $standalone_jnl_id = null;
            $jrnl_grp = $this->get_standalone_journal_data();
            if ($jrnl_grp != null)
                $standalone_jnl_id = $jrnl_grp->jnl_id;
            $state = $orcid_data['state'];
            if (isset($state) && $state != "") {
                $state = decrypt_link($state);
            }
            parse_str(decrypt_link($state), $state_input);
            $redirect = $this->get_redirect_url($state_input);
            if ($standalone_jnl_id != NULL) {
                $obj_usr_id_condition = "usr_email = '{$orcid_user_data['primaryemail']}' AND usr_jnl_standalone = {$standalone_jnl_id} ";
                $obj_usr_id = User::get_single_record('usr_id,usr_status', $obj_usr_id_condition);
            } else {
                $obj_usr_id_condition = "usr_email = '{$orcid_user_data['primaryemail']}' AND usr_jnl_standalone IS NULL ";
                $obj_usr_id = User::get_single_record('usr_id,usr_status', $obj_usr_id_condition);
            }
            if ($obj_usr_id !== null) {
                if ($obj_usr_id->usr_status != 'a') {
                    $set_userdata = [
                        'login_with_orcid',
                        array(
                            'status' => true,
                            'user__id' => encrypt_link($obj_usr_id->usr_id),
                            'msg' => 'await_confirm',
                            'redirect_url' => '',
                        )
                    ];
                } else {
                    $user_array = array(
                        'usr_orcid_id' => $orcid_data['orcid_id'],
                        'usr_orcid_response' => json_encode($orcid_data['token_response']),
                        'usr_orcid_token' => $orcid_data['token']
                    );
                    $user_update_condition = "usr_id  = {$obj_usr_id->usr_id}";
                    // User::update_record($user_array,$user_update_condition,$obj_usr_id->usr_id); // get user id only
                    User::update_record($user_array, $user_update_condition);
                    $set_userdata = [
                        'login_with_orcid',
                        array(
                            'status' => true,
                            'user__id' => encrypt_link($obj_usr_id->usr_id),
                            'redirect_url' => '',
                        )
                    ];
                }

            } else {
                $user_id = '';
                if (isset($orcid_user_data['firstname']) && ($orcid_user_data['firstname'] != '') || isset($orcid_user_data['lastname']) && ($orcid_user_data['lastname'] != '')) {
                    $standalone_jnl_id = null;
                    $jrnl_grp = $this->get_standalone_journal_data();
                    if ($jrnl_grp != null)
                        $standalone_jnl_id = $jrnl_grp->jnl_id;
                    $first_name = $orcid_user_data['firstname'];
                    $last_name = $orcid_user_data['lastname'];
                    // $this->load->helper('string');
                    $key = Str::random(8);
                    // Users::trans_start();
                    $users = array(
                        'usr_first_name' => $first_name,
                        'usr_last_name' => $last_name,
                        'usr_email' => (isset($orcid_user_data['primaryemail'])) ? $orcid_user_data['primaryemail'] : '',
                        'usr_username' => (isset($orcid_user_data['username'])) ? $orcid_user_data['username'] : $orcid_user_data['primaryemail'],
                        'usr_title' => (isset($orcid_user_data['title'])) ? $orcid_user_data['title'] : '',
                        // 'usr_city' => $form_data['city'],
                        'usr_deeplink_token' => $key,
                        'usr_registered' => 'y',
                        'usr_orcid_id' => $orcid_data['orcid_id'],
                        'usr_orcid_token' => $orcid_data['token'],
                        'usr_orcid_response' => (isset($orcid_data['token_response'])) ? json_encode($orcid_data['token_response']) : '',
                        'usr_jnl_standalone' => $standalone_jnl_id
                    );
                    User::insert_record($users);
                    $obj_usr_id_condition = "usr_email = '{$orcid_user_data['primaryemail']}' ";
                    $obj_usr_id = User::get_single_record('usr_id', $obj_usr_id_condition);
                    $user_id = $obj_usr_id->usr_id;
                    $mail_exists = false;
                    if (isset($user_id) && $user_id != NULL) {
                        if (!empty($orcid_user_data['cc_mail'])) {
                            foreach ($orcid_user_data['cc_mail'] as $key => $value) {
                                foreach ($cc_mail_array as $key => $mail) {
                                    if ($value["email"] === $mail) {
                                        $mail_exists = true;
                                    }
                                }
                                if (!$mail_exists) {
                                    array_push($cc_mail_array, $value['email']);
                                }
                                $mail_exists = false;
                            }
                        }
                        foreach (array_unique($cc_mail_array) as $array_key => $mail) {
                            $cc_data['uml_user_id'] = $user_id;
                            $cc_data['uml_email'] = $mail;
                            $cc_data['uml_posted_by'] = $user_id;
                            $user_data = array(
                                'user_id' => $user_id,
                                'proxy_user_id' => $user_id,
                            );
                            if (trim($mail) != '')
                                User_emails::insert_record($cc_data, $user_data);
                        }
                        $generic_data = $request->all();
                        unset($generic_data['orcid']);
                        unset($generic_data['orcid_aff']);
                        if (isset($generic_form_data)) {
                            $clnt_generic_form_identifier = NULL;
                            foreach ($generic_form_data as $key => $val) {
                                $customformdata = $val;
                                // $validdata = $this->custom_form_validation($formid, $formdata);
                                #Customisation #1345 : Update user table with DND
                                $this->save_generic_forms($user_id, $formid, $customformdata, $clnt_generic_form_identifier);
                            }
                        }
                        $users['user_id'] = $user_id;
                        $users['proxy_user_id'] = NULL;
                        $general_config = Config::get('general_config');
                        $email_templates_config = $general_config['email_templates'];
                        if (isset($email_templates_config['general']) && $email_templates_config['general'] == TRUE) {
                            // $current_date_time = date('Y-m-d H:i:s');
                            // $user_name = isset($orcid_user_data['username']) ? $orcid_user_data['username'] : '';
                            $this->send_orcid_reg_conform_mail($user_id);
                        }
                    }
                }
                $primary_affliation_inserted = FALSE;
                $check_primary_aff_condition = "usaff_user_id = {$user_id} AND usaff_prime_affiliation = 'y' ";
                $check_primary_aff = User_affiliations::get_single_record('COUNT(usaff_id) as cnt', $check_primary_aff_condition);
                if ($check_primary_aff->cnt > 0) {
                    $primary_affliation_inserted = TRUE;
                }
                if (isset($orcid_user_data['employments']) && count($orcid_user_data['employments']) > 0) {
                    $loop = 1;
                    foreach ($orcid_user_data['employments'] as $edu_aff) {
                        if ($loop == 1 && $primary_affliation_inserted == FALSE) {
                            $usaff_prime_affiliation = 'y';
                        } else {
                            $usaff_prime_affiliation = 'n';
                        }
                        $user_edu_affiliation = array(
                            'usaff_email' => '',
                            'usaff_department' => $edu_aff['department'],
                            'usaff_company' => $edu_aff['institution'],
                            'usaff_address_line1' => $edu_aff['city'],
                            'usaff_address_line2' => $edu_aff['region'],
                            'usaff_cnt_id' => $edu_aff['country'],
                            'usaff_put_code' => trim($edu_aff['put_code']),
                            'usaff_user_id' => $user_id,
                            'usaff_prime_affiliation' => $usaff_prime_affiliation,
                            'usaff_from_orcid' => 'y',
                            'usaff_type' => 'e'
                        );
                        $user_data = array(
                            'user_id' => $user_id,
                            'proxy_user_id' => $user_id,
                        );
                        $user_affiliation_status = User_affiliations::insert_record($user_edu_affiliation, $user_data);
                        $loop = 2;
                        $this->update_orcid_affiliation($orcid_data['orcid_id'], $orcid_data['token'], $edu_aff['put_code'], $user_id, $user_affiliation_status, 'e');
                    }
                }
                if (isset($orcid_user_data['educations']) && count($orcid_user_data['educations']) > 0) {
                    $loop = 1;
                    foreach ($orcid_user_data['educations'] as $empl) {
                        if ($loop == 1 && $primary_affliation_inserted == FALSE) {
                            $usaff_prime_affiliation = 'y';
                            $primary_affliation_inserted = TRUE;
                        } else {
                            $usaff_prime_affiliation = 'n';
                        }
                        $user_emp_affiliation = array(
                            'usaff_email' => '',
                            'usaff_department' => $empl['department'],
                            'usaff_company' => $empl['institution'],
                            'usaff_address_line1' => $empl['city'],
                            'usaff_address_line2' => $empl['region'],
                            'usaff_cnt_id' => $empl['country'],
                            'usaff_put_code' => trim($empl['put_code']),
                            'usaff_user_id' => $user_id,
                            'usaff_prime_affiliation' => $usaff_prime_affiliation,
                            'usaff_from_orcid' => 'y',
                            'usaff_type' => 'w'
                        );
                        $user_data = array(
                            'user_id' => $user_id,
                            'proxy_user_id' => $user_id,
                        );
                        $user_affiliation_status = User_affiliations::insert_record($user_emp_affiliation, $user_data);
                        $loop = 2;
                        $this->update_orcid_affiliation($orcid_data['orcid_id'], $orcid_data['token'], $empl['put_code'], $user_id, $user_affiliation_status, 'w');
                    }
                }
                //  if (Users::trans_complete() === TRUE) {
                $user_data_condition = "usr_id = {$user_id}";
                $user_data = User::get_single_record('*', $user_data_condition);
                //  if (!empty($user_data)) {
                //  $login_session = $this->set_login_session_data($user_data);
                //  $this->set_user_session_data($login_session, TRUE); 
                $set_userdata = [
                    'login_with_orcid',
                    array(
                        'status' => true,
                        'user_id' => encrypt_link($user_id),
                        'user_data' => $user_data,
                        'login' => TRUE,
                        'redirect_url' => 'user-registration/' . encrypt_link($user_id)
                    ),
                    'msg_success' => 'Successfully connected to ORCID'
                ];
                /* $set_flashdata = ['msg_success' => customTrans('orcid.user_connected')];
                 } else {
                     $set_userdata = [
                         'redirect_url' => $this->get_redirect_link(),
                     ];
                 } */
            }
        } else {
            $set_userdata = [
                'redirect_url' => $this->get_redirect_link(),
            ];
        }
        return $set_userdata;
    }

    /* public function index_old(Request $request)
    {
        $post_data = $request->all();
        define('OAUTH_CLIENT_ID', '0000-0001-5476-9382'); //client ID
        define('OAUTH_CLIENT_SECRET', 'fd52607f-a35f-4294-a39e-ad38e4e468be'); //client secret
        define('OAUTH_REDIRECT_URI', 'http://peer-review.rivervalleytechnologies.com/orcid'); //redirect URI
        define('OAUTH_AUTHORIZATION_URL', 'https://sandbox.orcid.org/oauth/authorize'); //authorization endpoint
        define('OAUTH_TOKEN_URL', 'https://api.sandbox.orcid.org/oauth/token'); //token endpoint
        if (isset($post_data['code'])) {
            //Build request parameter string
            $params = "client_id=" . OAUTH_CLIENT_ID . "&client_secret=" . OAUTH_CLIENT_SECRET . "&grant_type=authorization_code&code=" . $post_data['code'] . "&redirect_uri=" . OAUTH_REDIRECT_URI;
            //Initialize cURL session
            $ch = curl_init();
            //Set cURL options
            curl_setopt($ch, CURLOPT_URL, OAUTH_TOKEN_URL);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Accept: application/json'
            ));
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            //			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); //Turn off SSL certificate check for testing - remove this for production version!
            //			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); //Turn off SSL certificate check for testing - remove this for production version!
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            //Execute cURL command
            $result = curl_exec($ch);
            //Close cURL session
            curl_close($ch);
            //Transform cURL response from json string to php array
            $response = json_decode($result, true);
            var_dump($response);
            exit;
        }
        $this->load->view("orcid_test/login");
    } */

    /* public function login()
    {
        //		$this->data['content_view'] = 'orcid_test/login';
        $this->load->view("orcid_test/login");
    } */

    /* public function search(Request $request)
    {
        $post_data = $request->all();
        if (isset($post_data["q"])) {
            $fields = array(
                "client_id" => "0000-0001-5476-9382",
                "client_secret" => "fd52607f-a35f-4294-a39e-ad38e4e468be",
                "scope" => "/read-public",
                "grant_type" => "client_credentials"
            );
            $fields_string = "";
            foreach ($fields as $key => $value) {
                $fields_string .= $key . '=' . $value . '&';
            }
            rtrim($fields_string, '&');
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://sandbox.orcid.org/oauth/token");
            curl_setopt($ch, CURLOPT_POST, count($fields));
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Accept: application/json'
            ));
            $token = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $token_array = json_decode($token, TRUE);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://api.sandbox.orcid.org/v1.2/search/orcid-bio/?q=" . $post_data["q"]);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/orcid+xml',
                'Authorization: ' . $token_array['token_type'] . ' ' . $token_array['access_token'],
                'Accept: application/xml'
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            var_dump($result);
            exit;
        }
        // $this->load->view("orcid_test/login");
    } */

    /* public function bio(Request $request)
    {
        $post_data = $request->all();
        if (isset($post_data["bio"])) {
            $fields = array(
                "client_id" => "0000-0001-5476-9382",
                "client_secret" => "fd52607f-a35f-4294-a39e-ad38e4e468be",
                "scope" => "/read-public",
                "grant_type" => "client_credentials"
            );
            $fields_string = "";
            foreach ($fields as $key => $value) {
                $fields_string .= $key . '=' . $value . '&';
            }
            rtrim($fields_string, '&');
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://sandbox.orcid.org/oauth/token");
            curl_setopt($ch, CURLOPT_POST, count($fields));
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Accept: application/json'
            ));
            $token = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $token_array = json_decode($token, TRUE);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://pub.sandbox.orcid.org/v1.2/" . $post_data["bio"] . "/orcid-bio/");
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/orcid+xml',
                'Authorization: ' . $token_array['token_type'] . ' ' . $token_array['access_token'],
                'Accept: application/xml'
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            var_dump($result);
            exit;
        }
        // $this->load->view("orcid_test/login");
    } */

    /* public function affiliation(Request $request)
    {
        $post_data = $request->all();
        if (isset($post_data["affiliation"])) {
            $fields = array(
                "client_id" => "0000-0001-5476-9382",
                "client_secret" => "fd52607f-a35f-4294-a39e-ad38e4e468be",
                "scope" => "/read-public",
                "grant_type" => "client_credentials"
            );
            $fields_string = "";
            foreach ($fields as $key => $value) {
                $fields_string .= $key . '=' . $value . '&';
            }
            rtrim($fields_string, '&');
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://sandbox.orcid.org/oauth/token");
            curl_setopt($ch, CURLOPT_POST, count($fields));
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Accept: application/json'
            ));
            $token = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $token_array = json_decode($token, TRUE);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://pub.sandbox.orcid.org/v1.2/" . $post_data["bio"] . "/affiliations/");
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/orcid+xml',
                'Authorization: ' . $token_array['token_type'] . ' ' . $token_array['access_token'],
                'Accept: application/xml'
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            var_dump($result);
            exit;
        }
        // $this->load->view("orcid_test/login");
    } */

    /* protected function find_distance_to_stage($flow_array, $stage_type, $model, &$stage_count)
    {
        $results = $model->get_records_by_raw_query("select jwf_stage_type, jwf_child_stages from rvw_journal_workflows where jwf_id in (" . implode(",", $flow_array) . ")");

        foreach ($results as $result) {
            $stage_count++;
            if ($result->jwf_stage_type == $stage_type || $result->jwf_child_stages == NULL) {
                return;
            }
            $this->find_distance_to_stage(json_decode($result->jwf_child_stages), $stage_type, $model, $stage_count);
        }
    } */

    /* private function confirm_orcid($art_id, $current_status_id, $uri_seg = 'view-article')
    {

        $article_details = Articles::get_article_data($art_id);
        if (empty($article_details)) {
           $base_url = $this->get_redirect_link();
            redirect($base_url);
        }
        $jnl_journal_code = $article_details->jnl_journal_code;
        $arti_type_code = $article_details->artp_abbr_article_type;
        $base_url = $this->get_redirect_link();

        // if ($uri_seg == 'preview-article') {
        //     $redirect = $base_url . 'journal/' . $jnl_journal_code . '/' . $arti_type_code . '/preview-article' . '?' . encrypt_link("article_id={$art_id}&status_id={$current_status_id}");
        // } else if ($uri_seg == 'edit-article') {
        //     $redirect = $base_url . 'journal/' . $jnl_journal_code . '/' . $arti_type_code . '/edit-article/' . encrypt_link($art_id) . '?' . encrypt_link('current_flow_id=' . $current_status_id);
        // } else {
        //     $redirect = $base_url . 'journal/' . $jnl_journal_code . '/view-article?' . encrypt_link('article_id=' . $art_id . '&status_id=' . $current_status_id);
        // }

        // return $redirect;
    } */

    public function orcid_registration($data_array)
    {
        $post_data = $data_array;
        // if((!isset($_GET['orcid_id']) && !isset($_GET['token']) && !isset($_GET['state']))){
        // 	$this->session->set_flashdata("msg_error", "Invalid URL.");
        // 	redirect(site_url());
        // 	exit;
        // }
        parse_str(decrypt_link($post_data['state']), $state);

        $token_response = $data_array['token_response'];

        $redirect = $this->get_redirect_url($state);
        if (isset($post_data['user_id']) && !isset($state['permission_update'])) {
            if (isset($post_data['message'])) {
                $set_userdata = [
                    'login_with_orcid',
                    array(
                        'status' => true,
                        'user_id' => $post_data['user_id'],
                        'link' => $post_data['message']
                    )
                ];
            } else {
                $set_userdata = [
                    'login_with_orcid',
                    array(
                        'status' => true,
                        'user_id' => $post_data['user_id']
                    )
                ];
            }
            $data['set_userdata'] = $set_userdata;
            $data['redirect_url'] = $redirect;
            return $data;
        }

        if (isset($state['existing']) && $state['existing'] == TRUE) {
            // if(isset($state['permission_update']) && $state['permission_update'] == TRUE){
            // 	$update_array = array('usr_orcid_token' => $post_data['token']);
            // }else{
            // 	$update_array = array(
            // 		'usr_orcid_id' => $post_data['orcid_id'],
            // 		'usr_orcid_token' => $post_data['token']);
            // }

            $update_array = array(
                'usr_orcid_id' => $post_data['orcid_id'],
                'usr_orcid_token' => $post_data['token']
            );
            if (isset($state['token_response'])) {
                $update_array['usr_orcid_response'] = $state['token_response'];
            }

            $condition = "usr_id = {$state['user']}";
            $curr_user = array('user_id' => $state['user'], 'proxy_user_id' => $state['user']);
            $this->update_user_record($update_array, 'update', $condition, $curr_user);

            // Users::trans_start();
            // $user_dets = User::get_single_record('*', $condition);
            // Users::trans_complete();
            // $this->current_user = $user_dets;
            $set_userdata = ['redirect_session' => TRUE];
            $data['set_userdata'] = $set_userdata;
            $data['redirect_url'] = $redirect;
            return $data;
        }

        $data['country_list'] = Country::get_all_records('*', 'cnt_id != 0', 'cnt_country');
        $feedbackform_flag = 'n';
        $cs_tbl = new \App\Models\Client_settings();
        $client_settings = $cs_tbl::get_client_settings_using_client_code('cs_show_reg_feedback_frm', $this->current_client->clnt_client_code);
        if (!empty($client_settings)) {
            $feedbackform_flag = $client_settings[0]->cs_show_reg_feedback_frm;
        }
        $query_strng = 'orcid_id=' . $post_data['orcid_id'] . '&token=' . $post_data['token'] . '&view_orcid_info=' . str_replace("&", "##", json_encode($post_data['view_orcid_info'])) . '&fdform=' . Rv_encrypt($feedbackform_flag) . '&state=' . encrypt_link(http_build_query($state)) . '&token_response=' . encrypt_link($post_data['token_response']);
        $redirect = $redirect . 'orcid-registration?' . encrypt_link($query_strng);
        $set_userdata = ['account_registration' => TRUE];
        $data['set_userdata'] = $set_userdata;
        $data['redirect_url'] = $redirect;
        return $data;
    }

    private function get_redirect_url($data)
    {
        // $return = $this->get_redirect_link();
        $return = '/';
        $orcid_urls = array(
            'profile' => 'profile',
            'edit' => 'edit-article',
            'preview' => 'preview-article',
            'view' => 'view-article',
            'author' => 'author-article'
        );
        if (isset($data) && $data != []) {
            if (isset($orcid_urls[$data['uri']])) {
                if (isset($data['article']) && $data['article'] != "") {
                    $article_details = Articles::get_article_data($data['article']);
                    if (empty($article_details)) {
                        $return .= (isset($data['paremeters'])) ? $orcid_urls[$data['uri']] . '?' . $data['paremeters'] : $orcid_urls[$data['uri']];
                    }
                    $jnl_journal_code = $article_details->jnl_journal_code;
                    $arti_type_code = $article_details->artp_abbr_article_type;
                }
                switch ($data['uri']) {
                    case 'edit':
                        $return .= ($data['parameters'] != "") ? 'journal/' . $jnl_journal_code . '/' . $arti_type_code . '/edit-article/' . encrypt_link($data['article']) . '?' . $data['parameters'] : 'journal/' . $jnl_journal_code . '/' . $arti_type_code . '/edit-article/' . encrypt_link($data['article']);
                        break;
                    case 'preview':
                        $return .= 'journal/' . $jnl_journal_code . '/' . $arti_type_code . '/preview-article?' . $data['parameters'];
                        break;
                    case 'view':
                        $return .= 'journal/' . $jnl_journal_code . '/view-article?' . $data['parameters'];
                        break;
                    case 'author':
                        $return .= 'journal/' . $jnl_journal_code . '/author-article?' . $data['parameters'];
                        break;
                    default:
                        $return .= (isset($data['paremeters'])) ? $orcid_urls[$data['uri']] . '?' . $data['paremeters'] : $orcid_urls[$data['uri']];
                        break;
                }
            }
        }

        return $return;
    }

    public function update_user_record($user_data, $action = 'insert', $condition = NULL, $curr_user = NULL)
    {
        $result = FALSE;
        if ($action == 'update' && isset($condition)) {
            $result = User::update_record($user_data, $condition, $curr_user);
        } elseif ($action == 'insert') {
            $result = User::insert_record($user_data, $curr_user);
        }
        return $result;
    }


    public function update_user_orcid_details($user_id)
    {
        // update user details
        $token_response = $this->get_orcid_token_response();
        $data_list = array(
            'usr_orcid_id' => $token_response['orcid'],
            'usr_orcid_token' => $token_response['access_token'],
            'usr_orcid_response' => json_encode($token_response)
        );

        $condition = "usr_id = {$user_id}";
        $user_data = array(
            'user_id' => $user_id,
            'proxy_user_id' => $user_id,
        );
        $result = User::update_record($data_list, $condition, $user_data);

        return array(
            'result' => $result,
            'orcid' => $token_response['orcid']
        );
    }


    /* public function orcid_add_affiliation(Request $request)
    {
        $user_id = decrypt_link($request('user'));
        $affiliation_id = decrypt_link($request('affiliation'));
        // $put_code = trim($this->uri->segment(2));// get 
        $put_code = trim($request('url_segment_2'));
        $user_condition = "usr_id = {$user_id}";
        $affilitaion_condition = "usaff_user_id = {$user_id} AND usaff_id = {$affiliation_id}";
        $user = User::get_single_record('usr_orcid_id,usr_orcid_token', $user_condition);
        $affilitaion = User_affiliations::get_single_record('*', $affilitaion_condition);
        if (empty($user) || empty($affilitaion)) {
            echo json_encode(array('status' => 'failed', 'msg' => customTrans('orcid.invalid_request')));
            exit;
        }
        // validate here 
        if ($affilitaion->usaff_department == NULL || $affilitaion->usaff_company == NULL || $affilitaion->usaff_address_line1 == NULL || $affilitaion->usaff_cnt_id == NULL) {
            echo json_encode(array('status' => 'failed', 'msg' => customTrans('orcid.orcid_affiliation_err')));
            exit;
        }
        $postfields = array(
            "department-name" => $affilitaion->usaff_department,
            "organization" => array(
                "name" => $affilitaion->usaff_company,
                "address" => array(
                    "city" => $affilitaion->usaff_address_line1,
                    "country" => $affilitaion->usaff_cnt_id
                )
            )
        );
        //$client_code = $this->current_client->clnt_client_code;
        //$this->config->load('clients/' . $client_code . '/orcid');
        $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
        $config_orcid  = Config::get($review_config);
        // $config_orcid = $this->config->item('orcid');
        //$orcid = '0000-0001-7456-4333';
        //$access_token = 'e34be72a-2250-4f5c-8bc9-c47712037b45';
        $orcid = $user->usr_orcid_id;
        $access_token = $user->usr_orcid_token;
        $type = ($affilitaion->usaff_type == 'w') ? 'employment' : 'education';
        if ($put_code != "") { //update
            $postfields["put-code"] = $put_code;
            $url = $config_orcid['member_api_url'] . $orcid . '/' . $type . '/' . $put_code;
            $postfields = $this->process_affiliation_post($postfields, $affilitaion->usaff_orcid_last_response);
        } else { //add
            $url = $config_orcid['member_api_url'] . $orcid . '/' . $type;
        }
        $header_array = array(
            'Accept: application/vnd.orcid+json',
            'Content-type: application/vnd.orcid+json',
            'Authorization: Bearer ' . $access_token
        );
        $postfields = json_encode($postfields, JSON_NUMERIC_CHECK);
        if ($put_code == NULL) {
            $curl_result = $this->curl_add_update($url, $header_array, $postfields);
        } else {
            $curl_result = $this->curl_add_update($url, $header_array, $postfields, $put_code);
        }
        $httpCode = '';
        if (!empty($curl_result)) {
            $httpCode = $curl_result['httpCode'];
            $header_size = $curl_result['header_size'];
            $result = $curl_result['result'];
        }
        if ($httpCode == 403) {
            $orcid_uri = 'edit-profile';
            $jnl_id = NULL;
            $standalone_journal = $this->get_standalone_journal_data();
            if ($standalone_journal != null)
                $jnl_id = $standalone_journal->jnl_id;
            $orc_link = '<br/><a id="connect-orcid-link" href="' . $config_orcid['oauth_authorization_url'] . '?client_id=' . $config_orcid['oauth_client_id'] . '&response_type=code&scope=' . $config_orcid['scope'] . '&redirect_uri=' . $config_orcid['main_url'] . 'orcid&state=' . encrypt_link('uri=' . $orcid_uri . '&jnl_id=' . $jnl_id . '&existing=TRUE&user=' . $user_id . '&permission_update=TRUE') . '"><img id="orcid-id-logo" src="' . base_url('assets/images/orcid_16x16.png') . '" width="16" height="16" alt="ORCID logo" /> Create or Connect your ORCID</a>';
            echo json_encode(array('status' => 'failed', 'msg' => customTrans('orcid.orcid_affiliation_scope_err') . $orc_link));
            exit;
        } elseif ($httpCode == 201) {
            $header = substr($result, 0, $header_size);
            $header2 = strstr($header,  'Location');
            $put_code = trim($this->get_putCode($header2));
            User_affiliations::update_record(array('usaff_put_code' => $put_code), array('usaff_id' => $affiliation_id), $this->current_user);
            $this->update_orcid_affiliation($orcid, $access_token, $put_code, $user_id, $affiliation_id, $affilitaion->usaff_type);
            $element = '<a href="javascript:void(0)" title="' . customTrans('orcid.orcid_profile_update') . '" data-user="' . encrypt_link($user_id) . '" data-put_code="' . $put_code . '" data-aff="' . encrypt_link($affiliation_id) . '" class="update_orcid_aff connect-orcid-link">' . customTrans('orcid.orcid_profile_update') . '</a>';
            echo json_encode(array('status' => 'success', 'msg' => customTrans('orcid.orcid_affiliation_success'), 'element' => $element));
            exit;
        } elseif ($httpCode == 200) {
            $this->update_orcid_affiliation($orcid, $access_token, $put_code, $user_id, $affiliation_id, $affilitaion->usaff_type);
            $element = '<a href="javascript:void(0)" title="' . customTrans('orcid.orcid_profile_update') . '" data-user="' . encrypt_link($user_id) . '" data-put_code="' . $put_code . '" data-aff="' . encrypt_link($affiliation_id) . '" class="update_orcid_aff connect-orcid-link">' . customTrans('orcid.orcid_profile_update') . '</a>';
            echo json_encode(array('status' => 'success', 'msg' => customTrans('orcid.orcid_affiliation_success'), 'element' => $element));
            exit;
        } else {
            echo json_encode(array('status' => 'failed', 'msg' => customTrans('orcid.orcid_affiliation_wrong')));
            exit;
        }
    } */

    public function update_orcid_affiliation($orcid, $token, $put_code, $user_id, $usaff_id, $aff_type)
    {
        $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
        $config_orc = Config::get($review_config);
        // $config_orc = $this->config->item('orcid');
        $type = ($aff_type == 'w') ? 'employment/' : 'education/';
        $url = $config_orc['orcid']['member_api_url'] . $orcid . '/' . $type . $put_code;
        $header_array = array(
            'Accept: application/vnd.orcid+json',
            'Authorization: Bearer ' . $token
        );

        $unique_id = uniqid();
        $post_fields_array = [];
        //Log unique id along with the json_encoded header, url, post
        $this->log_cURL_request($unique_id, $url, $header_array, $post_fields_array);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        //curl_setopt($ch, CURLOPT_VERBOSE, 1);
        //curl_setopt($ch, CURLOPT_HEADER, 1);
        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $currlinfo = curl_getinfo($ch);
        $this->log_cURL_response($unique_id, $httpCode, $result . '<br/> Curl Info : ' . json_encode($currlinfo));

        if ($httpCode == 200) {
            $user_data = array(
                'user_id' => $user_id,
                'proxy_user_id' => $user_id,
            );
            User_affiliations::update_record(array('usaff_orcid_last_response' => $result), array('usaff_id' => $usaff_id), $user_data);
        }
    }

    /* private function process_affiliation_post($postfields, $orcid_last_response)
    {
        $response_array = json_decode($orcid_last_response, TRUE);
        // if(isset($response_array['created-date']['value']) && $response_array['created-date']['value'] != NULL){
        // 	$cr_date = $response_array['created-date']['value']/1000;
        // 	$postfields['created-date'] = array(
        // 									"year"=>date('Y',$cr_date),
        // 									"month"=>date('n',$cr_date),
        // 									"day"=>date('j',$cr_date)
        // 									);
        // }
        // if(isset($response_array['source']) && $response_array['source'] != NULL){
        // 	if(isset($response_array['source']['source-orcid']['uri']) && $response_array['source']['source-orcid']['uri'] != NULL && isset($response_array['source']['source-orcid']['path']) && $response_array['source']['source-orcid']['path'] != NULL && isset($response_array['source']['source-orcid']['host']) && $response_array['source']['source-orcid']['host'] != NULL){
        // 		$source['source-orcid'] = array(
        // 			"uri"=>$response_array['source']['source-orcid']['uri'],
        // 			"path"=>$response_array['source']['source-orcid']['path'],
        // 			"host"=>$response_array['source']['source-orcid']['host']
        // 		);
        // 	}
        // 	if(isset($response_array['source']['source-client-id']) && $response_array['source']['source-client-id'] != NULL){
        // 		$source['source-client-id'] = response_array['source']['source-client-id'];
        // 	}
        // 	if(isset($response_array['source']['source-name']['value']) && $response_array['source']['source-name']['value'] != NULL){
        // 		$source['source-name'] = response_array['source']['source-name']['value'];
        // 	}
            
        // 	$postfields['source'] = $source;
        // }
        if (isset($response_array['visibility']) && $response_array['visibility'] != NULL) {
            $postfields['visibility'] = $response_array['visibility'];
        }
        if (isset($response_array['path']) && $response_array['path'] != NULL) {
            $postfields['path'] = $response_array['path'];
        }
        if (isset($response_array['role-title']) && $response_array['role-title'] != NULL) {
            $postfields['role-title'] = $response_array['role-title'];
        }
        if (isset($response_array['start-date']) && $response_array['start-date'] != NULL) {
            $unix = strtotime($response_array['start-date']['year']['value'] . '-' . $response_array['start-date']['month']['value'] . '-' . $response_array['start-date']['day']['value']);
            $postfields['start-date'] = array(
                "year" => date("Y", $unix),
                "month" => date("n", $unix),
                "day" => date("j", $unix)
            );
            //$response_array['start-date'];
        }
        if (isset($response_array['end-date']) && $response_array['end-date'] != NULL) {
            $postfields['end-date'] = array(
                "year" => $response_array['end-date']['year']['value'],
                "month" => $response_array['end-date']['month']['value'],
                "day" => $response_array['end-date']['day']['value']
            );
        }

        return $postfields;
    } */

    /* public function orcid_update_keywords(Request $request)
    {
        $user_id = decrypt_link($request('user'));
        $user_keywords = Keywords::get_user_keywords($user_id);
        $user_condition = "usr_id = {$user_id}";
        $user = User::get_single_record('usr_orcid_id,usr_orcid_token', $user_condition);
        $success = 'success';
        if (!empty($user_keywords)) {
            $orcid = $user->usr_orcid_id;
            $access_token = $user->usr_orcid_token;
            $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
            $config_orcid  = Config::get($review_config);
            // $config_orcid = $this->config->item('orcid');
            $header_array = array(
                'Accept: application/vnd.orcid+json',
                'Content-type: application/vnd.orcid+json',
                'Authorization: Bearer ' . $access_token
            );
            $success = 'failed';
            foreach ($user_keywords as $uk) {
                $postfields = array('content' => $uk->kwd_name);
                $url = $config_orcid['member_api_url'] . $orcid . '/keywords';
                $uk_put_code = trim($uk->ukwd_put_code);
                if ($uk_put_code != NULL) {
                    $url = $config_orcid['member_api_url'] . $orcid . '/keywords/' . $uk_put_code;
                    $postfields['put-code'] = $uk_put_code;
                }
                $postfields = json_encode($postfields);
                $key_put_code = '';
                if ($uk_put_code == NULL) {
                    $curl_result = $this->curl_add_update($url, $header_array, $postfields);
                } else {
                    $curl_result = $this->curl_add_update($url, $header_array, $postfields, $uk_put_code);
                }
                $httpCode = '';
                if (!empty($curl_result)) {
                    $httpCode = $curl_result['httpCode'];
                    $header_size = $curl_result['header_size'];
                    $result = $curl_result['result'];
                }
                if ($httpCode == 403) {
                    $orcid_uri = 'edit-profile';
                    $jnl_id = NULL;
                    $standalone_journal = $this->get_standalone_journal_data();
                    if ($standalone_journal != null)
                        $jnl_id = $standalone_journal->jnl_id;
                    // $orc_link = '<br/><a id="connect-orcid-link" href="' . $config_orcid['oauth_authorization_url'] . '?client_id=' . $config_orcid['oauth_client_id'] . '&response_type=code&scope=' . $config_orcid['scope'] . '&redirect_uri=' . $config_orcid['main_url'] . 'orcid&state=' . encrypt_link('uri=' . $orcid_uri . '&jnl_id=' . $jnl_id . '&existing=TRUE&user=' . $user_id . '&permission_update=TRUE') . '"><img id="orcid-id-logo" src="' . base_url('assets/images/orcid_16x16.png') . '" width="16" height="16" alt="ORCID logo" /> Create or Connect your ORCID</a>';
                    $orc_link = '';
                    echo json_encode(array('status' => 'failed', 'msg' => customTrans('orcid.orcid_affiliation_scope_err') . $orc_link));
                    exit;
                } elseif ($httpCode == 201 || $httpCode == 200) {
                    if ($httpCode == 201) {
                        $header = substr($result, 0, $header_size);
                        $header2 = strstr($header,  'Location');
                        $key_put_code = $this->get_putCode($header2);
                    }
                    $success = 'success';
                    $user_data = array(
                    'user_id' => $user_id,
                    'proxy_user_id' => $user_id,
                      );
                    if ($key_put_code != '') {
                        $result = json_encode($result);
                        Userkeywords::update_record(array('ukwd_put_code' => $key_put_code, 'ukwd_orcid_last_response' => $result), array('ukwd_id' => $uk->ukwd_id), $user_data);
                    } else {
                        Userkeywords::update_record(array('ukwd_orcid_last_response' => $result), array('ukwd_id' => $uk->ukwd_id), $user_data);
                    }
                }
            }
        }
        $msg = ($success == 'success') ? customTrans('orcid.orcid_keyword_update_success') : customTrans('orcid.orcid_keyword_update_fail');
        echo json_encode(array('status' => $success, 'msg' => $msg));
    } */

    /* private function curl_add_update($url, $header_array, $postfields, $put_code = "")
    {
        $unique_id = uniqid();

        //Log unique id along with the json_encoded header, url, post
        $this->log_cURL_request($unique_id, $url, $header_array, $postfields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
        if ($put_code != "") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        } else {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HEADER, 1);
        }

        curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        //curl_setopt($ch, CURLOPT_VERBOSE, 1);

        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $currlinfo = curl_getinfo($ch);
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $this->log_cURL_response($unique_id, $httpCode, $result . '<br/> Curl Info : ' . json_encode($currlinfo));
        $return = array('result' => $result, 'httpCode' => $httpCode, 'currlinfo' => $currlinfo, 'header_size' => $header_size);
        return $return;
    } */
    public function add_user_review_for_orcid_update(Request $request)
    {
        try {
            $review_type = 'single_review';
            $aflw_id = Rv_decrypt($request['artflwid']);
            $jnl_id = Rv_decrypt($request['jnlid']);
            $current_user = $this->get_current_user_details();
            $user_id = $current_user['user_id'];
            $result = $this->prepare_user_review_for_orcid_update($review_type, $user_id, $aflw_id, $jnl_id);
            // print_r($result); // added to check orcid working functionality
            return $this->success('Success', 200, $result);
        } catch (\Exception $e) {
            return $this->failure('Failure', 500, $e);
        }
    }


    public function prepare_user_review_for_orcid_update($review_type = 'single_review', $user_id = NULL, $aflw_id = NULL, $jnl_id = NULL)
    {
        $current_client_details = $this->current_client;
        $return_arr = array(
            'status' => 'failed',
            'msg' => customTrans('orcid.orcid_unexpected_error')
        );

        $post = FALSE;
        $art_details_condition = "aflw_id = {$aflw_id}";
        $art_details = Article_flow::get_single_record('aflw_art_id', $art_details_condition);
        $article_id = $art_details->aflw_art_id;
        if ($user_id == NULL) {
            $post = TRUE;
            $aflw_id = decrypt_link($aflw_id);

            $temp_review_type = $review_type;
            if ($temp_review_type != '')
                $review_type = $temp_review_type;
            $current_user = $this->get_current_user_details();
            $user_id = $current_user['user_id'];

            if ($review_type == 'single_review' || $review_type == 'jnl_review_all') {
                $jnl_id = $jnl_id;
            }
        }
        $journal_condition = "jnl_id = {$jnl_id}";
        $jnl_data = Journals::get_single_record('jnl_journal_code', $journal_condition);
        $jnl_code = $jnl_data->jnl_journal_code;

        $link = '';
        if ($review_type == 'single_review' && $post == FALSE) {
            $art_details_condition = "aflw_id = {$aflw_id}";
            $art_details = Article_flow::get_single_record('aflw_art_id', $art_details_condition);

            $link = 'journal/' . $jnl_code . '/view-article?' . encrypt_link('article_id=' . $art_details->aflw_art_id . '&status_id=' . $aflw_id);
            $return_arr['redir_url'] = $link;
        }

        //Users::trans_start();
        $user_details_condition = "usr_id = {$user_id}";
        $user_details = User::get_single_record('usr_orcid_id,usr_orcid_token', $user_details_condition);

        $usr_orcid_id = $user_details->usr_orcid_id;
        $usr_orcid_token = $user_details->usr_orcid_token;

        //build journal loop
        $group_jnl_arr = array();
        $condition = '';
        if ($jnl_id != NULL) {
            $condition = "jnl_id = {$jnl_id}";
        }
        $select_field = 'jnl_journal_name,jnl_orcid_group_id,jnl_journal_code,jnl_id,jnl_journal_description,(select jm_meta_value from rvw_journal_metadata where jm_meta_name = \'issn\' and jnl_journal_code = jm_journal_code) as jnl_issn,(select jm_meta_value from rvw_journal_metadata where jm_meta_name = \'e_issn\' and jnl_journal_code = jm_journal_code) as jnl_e_issn,(select jm_meta_value from rvw_journal_metadata where jm_meta_name = \'iet_prefix\' and jnl_journal_code = jm_journal_code) as iet_prefix';
        $jnl_orcid_group = Journals::get_all_records($select_field, $condition);

        if (count($jnl_orcid_group) > 0) {
            $journal_group_arr = array();
            $client_orcid_details = $this->get_client_token();
            if ($client_orcid_details['status'] == FALSE) {
                if ($post == TRUE) {
                    echo json_encode($return_arr);
                } else {
                    return $return_arr;
                }
            }
            $client_orcid_token = $client_orcid_details['response']['access_token'];

            //build group for the journals
            foreach ($jnl_orcid_group as $jnl_group) {
                $orcid_group_id = '';
                $iet_prefix = 'n';
                if ($jnl_group->jnl_orcid_group_id != '') {
                    $orcid_group_id = 'orcid-generated:' . $jnl_group->jnl_journal_code . '-' . $jnl_group->jnl_id;
                    $existing_group_id = $this->get_existing_group_id($orcid_group_id, $client_orcid_token);
                    $existing_group_id_record = json_decode($existing_group_id['result']);
                    if ($existing_group_id['httpCode'] == 200 && !empty($existing_group_id_record->name)) {
                        $header_size = $existing_group_id['header_size'];
                        $header = substr($existing_group_id['result'], 0, $header_size);
                        $header2 = json_decode($header);
                        $put_code = $header2->{'put-code'};
                        $user_data = array(
                            'user_id' => $user_id,
                            'proxy_user_id' => $user_id,
                        );
                        $jnl_update_data = array(
                            'jnl_orcid_group_id' => $orcid_group_id,
                            'jnl_orcid_group_put_code' => $put_code,
                        );
                        $jnl_update_condition = "jnl_id = {$jnl_group->jnl_id}";
                        Journals::update_record($jnl_update_data, $jnl_update_condition, $user_data);

                    } else {
                        $group_arr = array(
                            'name' => strip_tags($jnl_group->jnl_journal_name),
                            'group-id' => $orcid_group_id,
                            'description' => strip_tags($jnl_group->jnl_journal_description),
                            'type' => 'journal',
                        );
                        $group_data = json_encode($group_arr);
                        $jnl_gropup = $this->create_journal_group($client_orcid_token, $group_data);

                        if ($jnl_gropup['status'] == TRUE && $jnl_gropup['http_code'] == 201) {
                            $put_code = $jnl_gropup['put_code'];
                            $user_data = array(
                                'user_id' => $user_id,
                                'proxy_user_id' => $user_id,
                            );
                            $jnl_update_data = array(
                                'jnl_orcid_group_id' => $orcid_group_id,
                                'jnl_orcid_group_put_code' => $put_code,
                            );
                            $jnl_update_condition = "jnl_id = {$jnl_group->jnl_id}";
                            Journals::update_record($jnl_update_data, $jnl_update_condition, $user_data);
                        } else {
                            if ($post == TRUE)
                                echo json_encode($return_arr);
                            else
                                return $return_arr;
                        }
                    }
                } else {
                    $orcid_group_id = $jnl_group->jnl_orcid_group_id;
                }

                if ($jnl_group->iet_prefix != NULL)
                    $iet_prefix = $jnl_group->iet_prefix;

                if ($orcid_group_id != '')
                    $journal_group_arr[$jnl_group->jnl_id] = array(
                        'orcid_group_id' => $orcid_group_id,
                        'iet_prefix' => $iet_prefix
                    );
            }

            //fetch user review data
            $review_condition = '';
            if ($aflw_id != '') {
                $review_condition .= " aflw_id = {$aflw_id} ";
            } elseif ($jnl_id != NULL) {
                $review_condition .= "jnl_id = {$jnl_id} AND aflw_usr_id = {$user_id} AND jwf_stage_type = 'review' ";
            } else {
                $review_condition .= " aflw_usr_id = {$user_id} AND jwf_stage_type = 'review' ";
            }
            $review_condition .= "AND aflw_status = 'c' AND aflw_orcid_putcode IS NULL ";
            // $review_condition .= "AND aflw_status = 'c' AND aflw_orcid_putcode IS NULL AND aflw_returned_date IS NULL ";

            $select_review = ' art_title,aflw_id,aflw_art_id,art_artp_id,jnl_journal_code,jnl_journal_name,jnl_id,DATE_FORMAT(aflw_returned_date,\'%d\') as review_day,DATE_FORMAT(aflw_returned_date,\'%m\') as review_month,DATE_FORMAT(aflw_returned_date,\'%Y\') as review_year';
            $review_data = Article_flow::get_article_stage_data($select_review, $review_condition, TRUE, TRUE);



            //Users::trans_complete();

            if (count($review_data) > 0) {
                $doi = 'clients.' . $current_client_details->clnt_client_code . '.doi.doi';
                $doi_details = config::get($doi);

                $article_doi_arr = array();
                $article_review_method_arr = array();
                foreach ($review_data as $rev_data) {
                    $aflw_id = $rev_data->aflw_id;

                    /*
                    if (!isset($article_doi_arr[$rev_data->aflw_art_id])) {
                        $iet_prefix = $journal_group_arr[$rev_data->jnl_id]['iet_prefix'];
                        $DOI_data = $this->create_article_doi($rev_data->aflw_art_id, $doi_details, $iet_prefix);
                        $article_doi = $DOI_data['doi'];
                        $article_doi_arr[$rev_data->aflw_art_id] = $article_doi;
                    } else {
                        $article_doi = $article_doi_arr[$rev_data->aflw_art_id];
                    }
                    $external_id_type = 'doi';
                    $reviewer_doi = $article_doi . '.j' . $rev_data->aflw_id;
                    */

                    //set article review method  double blind
                    if (!isset($article_review_method_arr[$rev_data->art_artp_id])) {
                        $artp_details_condition = "atotp_artp_id = {$rev_data->art_artp_id}";
                        $artp_details = Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params', $artp_details_condition);

                        $current_art_review_method = $artp_details->atotp_review_method;
                        $article_review_method_arr[$rev_data->art_artp_id] = $current_art_review_method;
                    } else {
                        $current_art_review_method = $article_review_method_arr[$rev_data->art_artp_id];
                    }
                    $external_id_type = 'issn';
                    $jnl_condition = "jnl_id= {$jnl_id}";
                    $jnl_data = Journals::get_single_record('*', $jnl_condition);
                    $generic_forms_table = (new \App\Models\Generic_forms);
                    $main_table = 'rvw_article_gnf_form_data_' . $jnl_data->jnl_journal_code;
                    $select_query = "SELECT `gdata_data` FROM rvw_article_gnf_form_data_" . ($jnl_data->jnl_journal_code) . " LEFT JOIN rvw_generic_form_elements ON rvw_generic_form_elements.emt_id = rvw_article_gnf_form_data_" . ($jnl_data->jnl_journal_code) . ".gdata_atfemt_id LEFT JOIN rvw_generic_forms ON rvw_generic_forms.gncf_id = rvw_generic_form_elements.emt_gucf_id WHERE `gdata_label` LIKE 'ISSN'";
                    $issn_record = $generic_forms_table::get_records_by_raw_query($select_query);
                    //$issn_record = array();
                    $jnl_issn = '';
                    if (isset($issn_record) && !empty($issn_record) && $issn_record[0]->gdata_data) {
                        $jnl_issn = $issn_record[0]->gdata_data;
                    } else {
                        $return_arr['msg'] = 'You cannot add this review to your ORCID record because the ISSN is not added for the corresponding journal. Please contact the editorial board to add the ISSN to the corresponding journal';
                        return $return_arr;
                    }

                    if ($current_art_review_method == 'd') //if review method is double blind then build encripted code
                    {
                        $reviewer_doi = $rev_data->jnl_journal_code . '-' . $rev_data->aflw_id;
                        $reviewer_doi = trim(strtr(base64_encode($reviewer_doi), array(
                            '+' => '',
                            '/' => '',
                            '=' => ''
                        )
                        ));
                        $external_id_type = 'source-work-id';
                    }

                    $review_arr = array(
                        "reviewer-role" => "REVIEWER",
                        "review-identifiers" => array(
                            "external-id" => array(
                                "external-id-relationship" => "SELF",
                                "external-id-type" => $external_id_type,
                                //"external-id-value" => $rev_data->jnl_journal_code.'-'.$rev_data->aflw_id,
                                "external-id-value" => $jnl_issn,
                            )
                        ),
                        "review-url" => "",
                        "review-type" => "REVIEW",
                        "review-completion-date" => array(
                            "year" => (int) $rev_data->review_year,
                            "month" => (int) $rev_data->review_month,
                            "day" => (int) $rev_data->review_day,
                        ),
                        "review-group-id" => $journal_group_arr[$rev_data->jnl_id]['orcid_group_id'],
                        // "subject-external-identifier" => array(
                        // "external-id-relationship" => "SELF",
                        // "external-id-type" => "doi",
                        // "external-id-value" => $article_doi,
                        // ),
                        "subject-container-name" => strip_tags($rev_data->jnl_journal_name),
                        "subject-type" => "JOURNAL_ARTICLE",
                        "subject-name" => array(
                            "title" => strip_tags($rev_data->art_title)
                        ),
                        "subject-url" => "",
                        "convening-organization" => array(
                            "name" => $current_client_details->clnt_client_name,
                            "address" => array(
                                "city" => $current_client_details->clnt_client_city,
                                "region" => $current_client_details->clnt_client_region,
                                "country" => $current_client_details->clnt_client_country,
                            ),
                        ),
                    );

                    if (isset($current_client_details->settings->cs_client_identifier) && $current_client_details->settings->cs_client_identifier != NULL) {
                        $org_identifier = array(
                            "disambiguated-organization-identifier" => $current_client_details->settings->cs_client_identifier,
                            "disambiguation-source" => $current_client_details->settings->cs_client_identifier_type,
                        );
                        $review_arr['convening-organization']['disambiguated-organization'] = $org_identifier;
                    }

                    $review_update_details = array(
                        'usr_orcid_id' => $usr_orcid_id,
                        'usr_orcid_token' => $usr_orcid_token,
                        'usr_review_content' => json_encode($review_arr),
                        'article_id' => $article_id
                    );
                    $result = $this->add_user_review_to_orcid($aflw_id, $review_update_details);
                    if ($result['status'] == 'err') {
                        $review_config = 'clients.' . $current_client_details->clnt_client_code . '.orcid';
                        $config_orcid = Config::get($review_config);

                        if ($review_type == 'single_review') {
                            $review_type = 'review_type=single_review';
                            $orcid_art_flow_id = 'aflw_id=' . $aflw_id . '&';
                        } elseif ($review_type == 'jnl_review_all') {
                            $review_type = 'review_type=jnl_review_all';
                            $orcid_art_flow_id = '';
                        }
                        // $base_url = $this->get_redirect_link();
                        // $connect_link = '<a id="connect-orcid-link" href="' . $config_orcid['orcid']['oauth_authorization_url'] . '?client_id=' . $config_orcid['orcid']['oauth_client_id'] . '&response_type=code&scope=' . $config_orcid['scope'] . '&redirect_uri=' . $this->get_redirect_link() . 'orcid&state=' . encrypt_link('uri=review&jnl_id=' . $rev_data->jnl_id . '&' . $review_type . '&' . $orcid_art_flow_id . 'user=' . $user_id . '&permission_update=TRUE') . '"><img id="orcid-id-logo" src="' . $this->get_redirect_link('assets/images/orcid_16x16.png') . '" width="16" height="16" alt="ORCID logo" /> Create or Connect your ORCID</a>';

                        // $return_arr['action_link'] = $connect_link;
                        $return_arr['msg'] = customTrans('orcid.orcid_scope_err');
                        if ($post == TRUE) {
                            echo json_encode($return_arr);
                        } else {
                            return $return_arr;
                        }
                        exit;
                    }
                }
                $return_arr['status'] = 'success';

                if ($post == TRUE) {
                    if ($review_type == 'single_review') {
                        $return_arr['msg'] = customTrans('orcid.orcid_review_success');
                        $return_arr['action_link'] = "<a href='#' name='delete_review_orcid' id='delete_review_orcid" . encrypt_link($aflw_id) . "' class='connect-orcid-link delete_review_orcid' data-bind='" . encrypt_link($aflw_id) . "'>" . customTrans('orcid.orcid_this_review_del_link') . "</a>";
                    } elseif ($review_type == 'jnl_review_all') {

                        $date = date("Y-m-d H:i:s");
                        $sql = 'Insert into ' . User_to_journal_orcid_details::$table . ' (ujo_jnl_id,ujo_usr_id,ujo_update_old_reviews,ujo_posted_date,ujo_posted_by,ujo_proxy_id,ujo_operation) values(' . $jnl_id . ',' . $user_id . ',"y","' . $date . '",' . $user_id . ',' . $user_id . ',"i") ON DUPLICATE KEY UPDATE ujo_update_old_reviews="y",ujo_operation="u"';
                        User_to_journal_orcid_details::execute_query($sql);
                        $return_arr['msg'] = customTrans('orcid.jnl_orcid_all_review_success');
                    }
                    // echo json_encode($return_arr);
                } else {
                    if ($review_type == 'single_review') {
                        $return_arr['msg'] = customTrans('orcid.orcid_review_success');
                        $link = 'journal/' . $jnl_code . '/view-article?' . encrypt_link('article_id=' . $article_id . '&status_id=' . $aflw_id);
                        $return_arr['redir_url'] = $this->get_redirect_link($link);
                    }
                    return $return_arr;
                }
            } else {
                $return_arr['msg'] = customTrans('orcid.orcid_no_review');
                if ($post == TRUE)
                    echo json_encode($return_arr);
                else
                    return $return_arr;
            }
        } else {
            if ($post == TRUE) {
                echo json_encode($return_arr);
            } else {
                return $return_arr;
            }
        }
    }

    //add review to orcid and response update to
    public function add_user_review_to_orcid($aflw_id, $review_update_details)
    {
        $return_arr = array(
            'status' => 'err'
        );
        $current_user = $this->get_current_user_details();
        $user_id = $current_user['user_id'];
        $user_orcid = $review_update_details['usr_orcid_id'];
        $user_orcid_token = $review_update_details['usr_orcid_token'];
        $user_review_data = $review_update_details['usr_review_content'];
        $article_id = $review_update_details['article_id'];
        $result = $this->add_review_to_orcid($user_orcid, $user_orcid_token, (array) json_decode($user_review_data),$article_id);
        if ($result['status'] == TRUE) {
            $put_code = $result['put_code'];
            $user_data = array(
                'user_id' => $user_id,
                'proxy_user_id' => $user_id,
            );
            $update_data = array(
                'aflw_orcid_putcode' => $put_code
            );
            $update_condition = "aflw_id = {$aflw_id}";
            $res = Article_flow::update_record($update_data, $update_condition, $user_data);

            if ($res) {
                $return_arr['status'] = 'success';
            }
        }
        return $return_arr;
    }

    public function integrate_user_review_to_orcid(Request $request)
    {

        $return_arr = array(
            'status' => 'failed',
            'msg' => customTrans('orcid.cmn_db_error')
        );
        $update_review = $request('update');
        $ujo_update_reviews = 'n';
        if ($update_review == 'on') {
            $ujo_update_reviews = 'y';
        }
        $current_user = $this->get_current_user_details();
        $user_id = $current_user['user_id'];
        $jnl_id = $request('jnl_id');
        $date = date("Y-m-d H:i:s");
        // convert into normal insert query
        $sql = 'Insert into ' . User_to_journal_orcid_details::$table . ' (ujo_jnl_id,ujo_usr_id,ujo_update_reviews,ujo_posted_date,ujo_posted_by,ujo_proxy_id,ujo_operation) values(' . $jnl_id . ',' . $user_id . ',"' . $ujo_update_reviews . '","' . $date . '",' . $user_id . ',' . $user_id . ',"i") ON DUPLICATE KEY UPDATE ujo_update_reviews="' . $ujo_update_reviews . '",ujo_operation="u"';

        $res = User_to_journal_orcid_details::execute_query($sql);
        if ($res) {
            $return_arr['status'] = 'success';
            $return_arr['msg'] = customTrans('orcid.update_suc_msg');
        }
        echo json_encode($return_arr);
    }

    public function delete_user_review_from_orcid(Request $request)
    {
        $return_arr = array(
            'status' => 'failed',
            'msg' => customTrans('orcid.cmn_db_error')
        );
        $aflw_id = Rv_decrypt($request['artflwid']);
        $current_user = $this->get_current_user_details();
        $user_id = $current_user['user_id'];
        $art_flow_data_condition = "aflw_id = {$aflw_id}";
        $user_data_condition = "usr_id = {$user_id}";
        $art_flow_data = Article_flow::get_single_record('aflw_orcid_putcode', $art_flow_data_condition);
        $user_data = User::get_single_record('usr_orcid_id,usr_orcid_token', $user_data_condition);
        if (!empty($art_flow_data) && (count(get_object_vars($art_flow_data)) == 0) || !empty($user_data) && (count(get_object_vars($user_data)) == 0)) {
            echo json_encode($return_arr);
        }
        $end_point = 'peer-review/' . $art_flow_data->aflw_orcid_putcode;
        $user_orcid = $user_data->usr_orcid_id;
        $user_token = $user_data->usr_orcid_token;
        $del_result = $this->delete_from_orcid($end_point, $user_token, $user_orcid);
        if ($del_result['httpCode'] == 204) {
            $user_data = array(
                'user_id' => $user_id,
                'proxy_user_id' => $user_id,
            );
            Article_flow::update_record(array('aflw_orcid_putcode' => NULL), array('aflw_id' => $aflw_id), $user_data);
            $return_arr['status'] = 'success';
            $return_arr['msg'] = customTrans('orcid.orcid_review_delete');
            // $return_arr['action_link'] = "<a href='#' name='update_review_orcid' id='update_review_orcid" . encrypt_link($aflw_id) . "' class='connect-orcid-link update_review_orcid' data-bind='" . encrypt_link($aflw_id) . "'>" . customTrans('orcid.orcid_this_review_add_link') . "</a>";
        }
        return $this->success('success', 200, $return_arr);
    }

    //funciton fetch all the reviews in the journal
    /* public function review_list()
    {
        $return_arr = array(
            'status' => 'failed',
            'msg' => customTrans('orcid.session_expired'),
        );

        $user_id = $this->current_user['user_id'];
        $jnl_id = $this->jnl_data->jnl_id;
    }*/
    public function get_redirect_link($link = '')
    {
        $review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
        $client_params = Config::get($review_config);
        if ($link !== '') {
            return $client_params['orcid']['main_url'] . $link;
        } else {
            return $client_params['orcid']['main_url'];
        }
    }
    public function resend_conform_mail(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'uid' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $return_array = [];
            $post_data = $request->all();
            $resend_mail = $this->send_orcid_reg_conform_mail(decrypt_link($post_data['uid']));
            return $this->success('success', 200, $return_array);
        } catch (\Exception $e) {
            return $this->failure('Failure', 500, $e);
        }
    }
    public function send_orcid_reg_conform_mail($user_id)
    {
        $key = Str::random(8);
        $user_data_condition = "usr_id = {$user_id}";
        $user_data = User::get_single_record('usr_email,usr_status', $user_data_condition);
        $user_email = isset($user_data->usr_email) ? $user_data->usr_email : '';
        // 'usr_deeplink_token' => $key,
        if ($user_data->usr_status == 'w') {
            $user_array = array(
                'usr_deeplink_token' => $key,
            );
            $user_data = array(
                'user_id' => $user_id,
                'proxy_user_id' => $user_id,
            );
            User::update_record($user_array, $user_data_condition, $user_data);
            $link = $this->get_redirect_link() . "confirmation/" . encrypt_link("&key=" . $key . "&userid=" . $user_id . "&name=add_user_confirmation");
            $custom_data = array(
                'confirmation_link' => $link,
                'user_email' => $user_email,
            );
            $email_data = array(
                'type' => 'global',
                'email_with_login' => FALSE,
                'user_id' => $user_id,
                'empt_name' => 'confirm_mail',
                'custom_data' => $custom_data
            );
            $this->master_email_details($email_data);
        }
    }
}
