<?php

namespace App\Http\Controllers\Pdf;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\JournalUserfunctionTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\StagemovementTrait;
use App\Models\Ithenticate_autosubmission;
use Http;
use Config;
use DB;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Articles;
use App\Models\Article_flow;
use App\Models\Production_attachment_files;
use App\Models\Email_attachments;
use App\Models\Article_supplementary_files;
use App\Models\Generic_form_files;
use App\Models\Authors;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Journal_settings;
use App\Models\Article_type_advance_options;
use App\Models\Generic_flows;
use App\Models\User;
use App\Models\User_affiliations;
use App\Models\Authors_affiliation;
use App\Models\Article_tab_status;
use App\Models\Required_file_type;
use App\Models\Attachment_file_description;
use App\Models\Attachment_designated_roles;
use App\Models\Attachment_files;
use App\Models\File_upload_type;
use App\Models\Article_pdf;
use App\Models\Article_keywords;
use App\Models\Resent_forward_emails_attachments;
use Illuminate\Support\Facades\Storage;
use \Mpdf\Mpdf as PDF;
use Response;
use File;
use Illuminate\Support\Facades\URL;

use PHPOffice\PhpWord\IOFactory;
use PHPOffice\PhpWord\PhpWord;
use PHPOffice\PhpWord\Settings;
use PhpOffice\PhpWord\Exception\Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\File as FacadesFile;
use App\Models\Research_integrity_reports;

class Manage_Pdf_Api extends Controller
{

   public function index(Request $request)
   {
    try
    {
		$post_data=$request->all();
		$validator = Validator::make($request->all(), [
            'article_id' => 'required',
            'platform_code' => 'required',
			//'art_type_code' => 'required',
            'art_flow_id' => 'required',
            //'art_type_id' => 'required',
        ]);
        if($validator->fails())
        {
            return  $this->failure('Failed',422,$validator->errors());
        }
		//TASK #7033 SQL injection pdfgenerate
		$artidarray = array('input'=>$post_data['article_id'],'type'=>'number', 'enc_data'=>TRUE );
		$artidvalidation= $this->Rv_validator($artidarray);
		$aflwidarray = array('input'=>$post_data['art_flow_id'],'type'=>'number', 'enc_data'=>TRUE );
		$aflwidvalidation= $this->Rv_validator($aflwidarray);
		if($artidvalidation != TRUE || $aflwidvalidation != TRUE){
			return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
            exit();
		}
		// end TASK #7033 SQL injection pdfgenerate
		$journal_code = $post_data['platform_code'];
		$article_id=$this->decrypt_data($post_data['article_id']);
		$current_stage_id=$this->decrypt_data($post_data['art_flow_id']);
		$article_type_id = isset($post_data['art_type_id']) ? $post_data['art_type_id'] : NULL;
		$array_pdf_not_coverted=array();
		$alter_autosumit = FALSE;
		if(isset($post_data['autosubmit']) && $post_data['autosubmit'] == true)
		{
			$alter_autosumit = TRUE;
		}
		$journal_code = $post_data['platform_code'];

		//Code to get article type for attachment section in view article.
		if($article_type_id == NULL)
		{
			$select_fields = "artp_id, artp_abbr_article_type";
			$condition = "art_id={$article_id}";
			$Article_types = (new \App\Models\Article_types())->getTable();
			$Articles = (new \App\Models\Articles())->getTable();
			$tables = array(
				'main_table' => $Articles,
				'join_table' => array(
					$Article_types => array($Article_types . '.artp_id', $Articles . '.art_artp_id','left')
				)
			);
			$art_type = Articles::get_results_using_joins($tables, $select_fields, $condition, 'single');
			$article_type_id = $art_type->artp_id;
		}
	    $where_cond="atmnt_label=0 AND atmnt_art_id={$article_id}";
		$attchment_description=Attachment_files::get_single_record('count(atmnt_id) AS count',$where_cond);
		if(isset($attchment_description->count)&&$attchment_description->count!=0)
		{
			$result['message'] = customTrans('pdf.description_empty');
			return  $this->warning('warning',200,$result,'warning');
		}
		$this->current_user=$this->get_current_user_details();

		$attachmenttable=(new \App\Models\Attachment_files())->getTable();
		$attachment_file_description_table=(new \App\Models\Attachment_file_description())->getTable();
        $doc_array = array(
			"docx",
			"doc",
			"odt",
			"ods",
			"rtf",
			"DOCX",
			"ODT",
			"ODS",
			"RTF");

		$tex_array = array(
			"tex",
			"TEX");
		$pdf_array = array(
			"pdf",
			"PDF");

		$graphic_array = array(
			"jpg",
			"jpeg",
			"png",
			"eps",
			"tif",
			"JPG",
			"JPEG",
			"PNG",
			"EPS",
			"TIF",
			"TIFF",
			"tiff");

		$doc_extra_array = array(
			"xlsx",
			"ppt",
			"pptx",
			"xls");

		//TASK#300 alert author that csv and xls filetypes will not include in composite PDF
		$excel_array = array(
			"csv",
			);

		//TASK#300 alert author that cdx (Compound Index File) filetype will not include in composite PDF
		$cdx_array = array(
			"cdx");

		$result = array(
			'status' => 'failed',
			'message' => customTrans('pdf.pdf_generation_failed'),
		);



		$article_type = Article_types::get_single_record("artp_abbr_article_type","artp_id={$article_type_id}");

		$article_data =Articles::get_single_record('art_article_upload_path,art_pdf_name, art_attachment_order,art_status,art_code,art_prev_article_id', "art_id={$article_id}");
		$condition="pdf_aflw_id={$current_stage_id} AND pdf_art_id={$article_id}";
        $article_pdf_details =Article_pdf::get_single_record('pdf_name',$condition);

		if ($article_data->art_article_upload_path == '')
		{
			return  $this->warning('Failed',500,$result);

		}

		$path = '' . $article_data->art_article_upload_path . "/";

//		$oldPdfUrl = $article_data->art_pdf_name;
		$oldPdfUrl = $article_pdf_details != NULL ? $article_pdf_details->pdf_name : '';

		//if author submission take all attachment files otherwise take review files only
		$pdf_review_cnd ="atmnt_art_id={$article_id}";
        $condition="atmnt_art_id={$article_id}  AND atmnt_designated_to  like '%r%'";
		$get_review_status = Attachment_files::get_single_record('count(atmnt_id) as cnt',$condition);

		//if($article_data->art_status != 'n')
		if ($get_review_status->cnt > 0){
			$pdf_review_cnd.=" AND atmnt_designated_to like '%r%' ";
		//	$pdf_review_cnd['atmnt_designated_to like '] = '%"r"%';
			//$condition['atmnt_designated_to like '] = '%"r"%';
		}
//305 TASK Exclude covering letters from composite PDF

		//fetch all attchments of the article
		$actual_article_attachments = Attachment_files::get_all_records("*", $pdf_review_cnd, "atmnt_order");

	   //fetch all attchments of the article in which the document type is not excluded from generating pdf

	   $criteria = "atmnt_art_id={$article_id} AND afdec_exclude_file='n' AND atmnt_label IS NOT NULL AND atmnt_designated_to like '%r%' ";
	   $select = '*';
	   $tables = array(
		   'main_table' => $attachmenttable,
		   'join_table' => array(
			$attachment_file_description_table => array($attachmenttable . '.atmnt_label', $attachment_file_description_table . '.afdec_id', "inner")
		   )
	   );
	   $article_attachments = Attachment_files::get_results_using_joins($tables, $select, $criteria, 'all','atmnt_order asc');
		/*** Bug #2372 - Incorrect popup message showing ***/
		if(count($article_attachments) == 0 && count($actual_article_attachments) == 0)
		{ 
			$result=array(
				'status' => 'warning',
				'message' => customTrans('pdf.attach_file_mandatory'),
			);
			return  $this->warning('Warning',200,$result);
		}
      //TASK #8218Generate pdf is not showing when required file is removed
		elseif (count($article_attachments) == 0 && count($actual_article_attachments) > 0)
		{
			
			//fetch the description which are excluded in this attachment
			$condition="atmnt_art_id={$article_id} AND afdec_exclude_file='y'";
			$excluded_descriptions = Attachment_files::get_results_using_joins($tables, 'afdec_description', $condition, 'all','atmnt_order asc');
			$notexcluded_condition="atmnt_art_id={$article_id} AND afdec_exclude_file='n'";
			$notexcluded_excluded_descriptions = Attachment_files::get_results_using_joins($tables, 'afdec_description', $notexcluded_condition, 'all','atmnt_order asc');
			//$excluded_descriptions = Attachment_files::get_results_using_joins($tables, 'all', 'afdec_description', $condition, "atmnt_order");
			$exclude_array = array();
			foreach ($excluded_descriptions as $key => $val)
			{
				if (!in_array($val->afdec_description, $exclude_array))
					$exclude_array[$key] = $val->afdec_description;
			}
			$descriptions = $this->string_with_comma_separation($exclude_array);
			if($notexcluded_excluded_descriptions->isEmpty())
			{
				$result=array(
					'status' => 'failed',
					'message' => 'Please upload another attachment, as the file uploaded with a file description ' . $descriptions . ' cannot be included in the composite PDF.',
				);	
				
			
		    }
		   else
		  {
			$description_cond = '';
			$fileDescriptionSettings=Config::get('clients.'.$this->current_client->clnt_client_code.'.upload_file_description_settings.file_description');
			$revised_article = $article_data->art_prev_article_id == NULL ? FALSE : TRUE;
			if($revised_article == TRUE)
			{
				$description_cond =  'AND afdec_description_type IN(\'b\',\'r\')';
			}
			else
			{
				$description_cond =  'AND afdec_description_type IN(\'b\',\'o\')';
			}
			$description_cond .= 'AND FIND_IN_SET("r", afdec_apply_stage_type)';
			$required_descrip_arr = array();
			$actual_descrip_arr = array();
			$non_excluded_required_arr =array();
			$attach_file_description = Required_file_type::get_file_description('afdec_id,afdec_description,rft_req_fld,afdec_exclude_file', "rft_artp_id={$article_type_id} {$description_cond}");
			foreach ($attach_file_description as $val) {
				if($val->rft_req_fld == 'y' && $fileDescriptionSettings['required_descriptions'] == true && $val->afdec_exclude_file == 'n'){
						$non_excluded_required_arr[] = $val->afdec_id; // Add to non-excluded required array
					
				}
			}
			if($non_excluded_required_arr && count($non_excluded_required_arr))
			{
				$result=array(
					'status' => 'failed',
					'message' => customTrans('pdf.designt_mandt_warning'),
				);
			}else
			{
			$result=array(
				'status' => 'failed',
				'message' =>customTrans('pdf.designt_warning'),
			);
		}
		
		  }
			return  $this->warning('Warning',200,$result,'warning');
		}
		 //TASK #8218Generate pdf is not showing when required file is removed
		/* Start - To show mandatory description warning */
		if(!empty($article_attachments))
		{
			$criteria = "atmnt_art_id={$article_id} AND atmnt_label IS NOT NULL";
			$select = '*';
			$tables = array(
				'main_table' => $attachmenttable,
				'join_table' => array(
					$attachment_file_description_table => array($attachmenttable . '.atmnt_label', $attachment_file_description_table . '.afdec_id', "inner")
				)
			);
			$all_article_attachments = Attachment_files::get_results_using_joins($tables, $select, $criteria, 'all','atmnt_order asc');
			$description_cond = '';
			$fileDescriptionSettings=Config::get('clients.'.$this->current_client->clnt_client_code.'.upload_file_description_settings.file_description');
			$revised_article = $article_data->art_prev_article_id == NULL ? FALSE : TRUE;
			if($revised_article == TRUE)
			{
				$description_cond =  'AND afdec_description_type IN(\'b\',\'r\')';
			}
			else
			{
				$description_cond =  'AND afdec_description_type IN(\'b\',\'o\')';
			}
			$description_cond .= 'AND FIND_IN_SET("r", afdec_apply_stage_type)';
			$required_descrip_arr = array();
			$actual_descrip_arr = array();
			$non_excluded_required_arr =array();
			$attach_file_description = Required_file_type::get_file_description('afdec_id,afdec_description,rft_req_fld,afdec_exclude_file', "rft_artp_id={$article_type_id} {$description_cond}");
			foreach ($attach_file_description as $val) {
				if($val->rft_req_fld == 'y' && $fileDescriptionSettings['required_descriptions'] == true){
					//$required_descriptions[] = $val->afdec_description.$file_types;
					//$required_descrip_arr[] = array('afdec_id' => $val->afdec_id,'afdec_description' => $val->afdec_description,'afdec_cnt' =>$val->rft_req_count);
					$required_descrip_arr[] = $val->afdec_id;
					if ($val->afdec_exclude_file == 'n') {
						$non_excluded_required_arr[] = $val->afdec_id; // Add to non-excluded required array
					}
				}
			}
			$allValuesPresent ='';
			$afdec_ids = $article_attachments->pluck('afdec_id')->toArray();
			$allValuesPresent = !array_diff($non_excluded_required_arr, $afdec_ids);
			$valid = FALSE;
			foreach($all_article_attachments as $value)
			{
				if($value->atmnt_label != NULL)
				{
					$actual_descrip_arr[] = $value->atmnt_label;
				}
				else if($value->atmnt_label == NULL && $value->atmnt_old_label != NULL)
				{
					$actual_descrip_arr[] = $value->atmnt_old_label;
				}
			}
			$required_desc_mandatory_warning = FALSE;
			$description_needed = '';
			foreach($required_descrip_arr as $req_val)
			{
				if(!in_array($req_val, $actual_descrip_arr))
				{
					$filtered_array = NULL;
					foreach($attach_file_description as $obj)
					{
						if($obj->afdec_id == $req_val)
						{
							$filtered_array = $obj;
						}
					}
					$description_needed = $description_needed == '' ? $filtered_array->afdec_description : $description_needed.', '.$filtered_array->afdec_description;
					$required_desc_mandatory_warning = TRUE;
				}
			}
			if($required_desc_mandatory_warning)
			{
				$result=array(
					'status' => 'failed',
					'message' => 'Please upload and ensure the file(s) with the file description(s) mentioned in the required file types list.',
				);
	
				return  $this->warning('Warning',200,$result,'warning');
			}
			if (!$allValuesPresent) {
				// If the counts are not the same
				$result=array(
					'status' => 'failed',
					'message' => customTrans('pdf.designt_mandt_warning'),
				);
	
				return  $this->warning('Warning',200,$result,'warning');
			} 
		}
		/* End - To show mandatory description warning */
		/*** Bug #1955 - JPR-308 Export includes not accepted file types -  Modification in zip extract﻿ **/
		$zip_count = 0;
		$temp_excel_arr		=	array();
                $pdf_cnt =   0;

		if(!empty($article_attachments))
		{
			foreach($article_attachments as $atch)
			{

				if(pathinfo($atch->atmnt_file_name, PATHINFO_EXTENSION) == 'zip')
				{
					$zip_count++;
				}
				//TASK#300 alert author that csv and xls filetypes will not include in composite PDF
				if (in_array(pathinfo($atch->atmnt_file_name, PATHINFO_EXTENSION), $excel_array))
				{
					$temp_excel_arr[]	=	$atch->atmnt_file_name;
				}
				//TASK#300 alert author that cdx filetype will not include in composite PDF
				if (in_array(pathinfo($atch->atmnt_file_name, PATHINFO_EXTENSION), $cdx_array))
				{
					$temp_cdx_arr[]	=	$atch->atmnt_file_name;
				}
                                //TASK#371 check if any pdf files are attached
				if (in_array(pathinfo($atch->atmnt_file_name, PATHINFO_EXTENSION), $pdf_array))
				{
					$pdf_cnt++;
				}
			}
		}

		if(count($article_attachments) == $zip_count)
		{
			$result['message'] = customTrans('pdf.only_zip_error');

		}
//		$pdfName = $journal_code . '-' . $article_type->artp_abbr_article_type . '-' . time() . '.pdf';
		$pdfName = $journal_code . '-' . $article_type->artp_abbr_article_type . '-' . time();

	//	$previewLink =  'uploads/' . $article_data->art_article_upload_path . "/" . $pdfName;
		$file_descriptons =Attachment_file_description::get_all_records("afdec_id,afdec_description");

		$attachment_file_desc = array();
		if(!empty($file_descriptons)){
			foreach($file_descriptons as $fk){
				$attachment_file_desc[$fk->afdec_id] = $fk->afdec_description;
			}
		}

		/* start for preventing regenteration of pre generated file with save order */
		$last_generated_file_order = array();
		$exclude_list = array('zip');
		foreach ($article_attachments as $key => $value)
		{
			$ext = pathinfo($value->atmnt_file_name, PATHINFO_EXTENSION);
			if(!in_array($ext,$exclude_list) ) {
				$last_generated_file_order[] = $value->atmnt_id;
			}
		}
		$last_generated_file_order_string = json_encode($last_generated_file_order);
		/* end  for preventing regenteration of pre generated file with save order */

//		$newPdfPath = $path . $pdfName;
		$new_pdf_filename = $pdfName;
//		$oldPdfUrl = $path . $oldPdfUrl;
		$oldPdfUrl = $oldPdfUrl;
		$file_array = array();
		//$this->load->library("m_pdf");
		$cover_page_pdf='';
		$cover_page_pdf = $this->create_cover_page($path, $journal_code, $article_type_id, $article_id);

		//$cover_page_pdf='0.pdf';

		$merge_order_array = array();
		$inline_ref_file_array = array();

		//$frontpath=$this->get_upload_path("uploads/".$path);
		$file_path = Config::get('general_config.file_retrieval')['file_path'];
		$frontpath=public_path() . $file_path . '/' . $path;
		$merge_order_array[] = array(
			'file_name' => $cover_page_pdf,
			'file_path' => $frontpath,
			'original_file_name' => $cover_page_pdf,
			'file_id' => 0,
			'file_ext' => 'pdf'
		);
		$tex_conversion_messages = array();
		$excel_conversion_messages = array();
		$cdx_conversion_messages	=	array();
		$log_error_array=array(); // TASK #3516 Alerting user about the corrupt files while generating pdf
		$msg = array();
		$status = 'success';
		$firstfile = TRUE;
		$embedd_msg_file = FALSE;
		$each_file_convert_to_pdf = TRUE;
		$pdf_settings=Config::get('pdf.pdf_settings');
	//	$this->load->config('pdf');
		//$pdf_settings = $this->config->item('pdf_settings');
		$tex_compiler = config('general_config.tex_compiler');
        $docker = trim(shell_exec("docker ps --filter 'name=texlive-full' --format '{{.Names}}'"));
        $tex_host = config('general_config.tex_host');
        $tex_port = config('general_config.tex_port');
		if (($tex_compiler == 'local' && file_exists($pdf_settings['PDFLATEX'])) || ($tex_compiler  == 'docker' && $docker == 'texlive-full') || ($tex_compiler == 'microservice' && $tex_host && $tex_port))
		{
		                //#371 checking pax package is installed
                      /*  if ($pdf_cnt > 0 && (isset($this->current_client->functionality->cfty_keep_the_links_unbroken_in_pdf) && $this->current_client->functionality->cfty_keep_the_links_unbroken_in_pdf == 'y') && shell_exec('kpsewhich pax.sty') == '')
                        {
                            $result = array(
                                    'status' => 'failed',
                                    'message' => lang('pax_package_missing'),
                            );
                            echo json_encode($result);
                            die;
                        }*/
			$missing_files=[]; // TASK #6026 Prevent pdf generation if uploaded files does not exist.
			foreach ($article_attachments as $attachment)
			{

				$tmp_msg = '';

				//$atch_file_path =$this->get_upload_path($attachment->atmnt_orginal_upload_path . "/",TRUE);
				$file_path = Config::get('general_config.file_retrieval')['file_path'];

				$atch_file_path=public_path() . $file_path . '/' . '' . $attachment->atmnt_orginal_upload_path . "/";

				$attachment_file_description =  isset($attachment_file_desc[$attachment->atmnt_label]) ? '('.$attachment_file_desc[$attachment->atmnt_label].')' : '' ;
				$ext = pathinfo($attachment->atmnt_file_name, PATHINFO_EXTENSION);
				/* TASK #6026 Prevent pdf generation if uploaded files does not exist.*/
				if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y'){
					//$s3_origin_path =$this->get_upload_path('uploads/'.$attachment->atmnt_orginal_upload_path . '/'.str_replace(" ", "+", $attachment->atmnt_file_name));
					// $s3_origin_path = $s3_file_path. str_replace(" ", "+", $attachment->atmnt_file_name); // TASK #7564
					//echo $s3_origin_path;
					// $headers = get_headers($s3_origin_path );
					// $exists = strpos($headers[0], '200 OK') !== false;
					$exists = storage::disk('s3')->exists('uploads/'.$attachment->atmnt_orginal_upload_path . '/'.str_replace(" ", "+", $attachment->atmnt_file_name));
					if ($exists !== true) {
						$missing_files[] = $attachment->atmnt_file_name;
					}
				}
				$file_origin= $atch_file_path . $attachment->atmnt_file_name;
				if(!isset($file_origin) || !file_exists($file_origin)){
					$missing_files[] = $attachment->atmnt_file_name;
				}
				if (empty($missing_files)) {
					/* end TASK #6026 Prevent pdf generation if uploaded files does not exist.		*/
				if ($attachment->atmnt_file_name != "" && file_exists($atch_file_path . $attachment->atmnt_file_name) && (!in_array($ext,$exclude_list) ))
				{
                                    //task#673-Remove file name form composite PDF created - start
                                    $original_file_name = $attachment->atmnt_file_name.' '.$attachment_file_description;
                                    if(isset($this->current_client->functionality->cfty_remove_filename_from_pdf) && $this->current_client->functionality->cfty_remove_filename_from_pdf== 'y')
                                    {
                                        $original_file_name = '';
                                    }
                                    //task#673-Remove file name form composite PDF created - end
					$path_parts = pathinfo($atch_file_path . $attachment->atmnt_file_name);
					$extension = strtolower($path_parts['extension']);
					if (in_array($extension, $tex_array))
					{
                        /* TASK #3516 Alerting user about the corrupt files while generating pdf */
						if($this->is_main_tex_file($atch_file_path,$attachment->atmnt_file_name))
						{

							$pdf_converted_tex_array = $this->compile_tex_to_pdf($atch_file_path, $attachment->atmnt_file_name, $pdf_settings);
							if(isset($pdf_converted_tex_array['converted_file_name'])&&$pdf_converted_tex_array['converted_file_name']!=NULL)
                            {
                                $pdf_converted_tex=$pdf_converted_tex_array['converted_file_name'];
                                if($pdf_converted_tex != NULL)
                                {
                                        $res_font_check = $this->check_pdf_embedded_subset($path,$atch_file_path,$pdf_converted_tex,$article_data->art_code,$attachment->atmnt_file_name,$firstfile);
                                        $firstfile = FALSE;

                                        if($res_font_check == 'success')
                                        {
                                            $merge_order_array[$attachment->atmnt_order] = array(
                                                'file_name' => $pdf_converted_tex,
                                                'file_path' => $atch_file_path,
                                                'original_file_name' => $original_file_name,
                                                'file_id' => $attachment->atmnt_id,
                                                'file_ext' => 'pdf'
                                            );

                                            $inner_files = $this->get_inner_files($atch_file_path, $attachment->atmnt_file_name);

                                            $tex_error_msgs = $this->get_tex_to_pdf_conversion_error($atch_file_path, $attachment->atmnt_file_name);
                                            if(!empty($tex_error_msgs))
                                            {
                                                $tex_conversion_messages[$attachment->atmnt_file_name] = $tex_error_msgs;
                                            }
                                            $inline_ref_file_array = array_unique(array_merge($inline_ref_file_array,$inner_files));


                                        }
                                        else
                                        {
                                            $status = 'failed';
                                            $embedd_msg_file = TRUE;
                                        }
                                    }
						    }
							else
							{
								$each_file_convert_to_pdf = FALSE;
								$status = 'failed';
								$tmp_msg = str_replace('%filename%', $attachment->atmnt_file_name, customTrans('pdf.tex_to_pdf_conversion_failed'));
								array_push($array_pdf_not_coverted,$attachment->atmnt_file_name);
								if(isset($pdf_converted_tex_array['log_file_status'])&&$pdf_converted_tex_array['log_file_status']==TRUE)
								{
									$tex_error_msgs = $this->get_failed_error_log($pdf_converted_tex_array['log_file_path']);
									if(!empty($tex_error_msgs))
									{
                                        $log_error_array[$attachment->atmnt_file_name] = $tex_error_msgs;
									}
								}
							}
						}
                         /*  End TASK #3516 */
						else
						{
							$inline_ref_file_array[] = $attachment->atmnt_file_name;
						}

					}
					elseif (in_array($extension, $doc_array))
					{
						if ($attachment->atmnt_pdf_name == NULL) //check pdf already generated
						{
							$file_extension = explode('.', $attachment->atmnt_file_name);
							$file_extension = end($file_extension);
							if(in_array($file_extension, $pdf_settings['OPEN_OFFICE_FILES']))
							{
								//$artpath = $this->get_upload_path("uploads/".$path);
								$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
								$artpath = storage_path() . $file_storage_path . "uploads/".$path;
								chdir($artpath);
								$oof_file_name = strpos($attachment->atmnt_file_name, '/') !== FALSE ? escapeshellarg('./'.$attachment->atmnt_file_name) : escapeshellarg($attachment->atmnt_file_name);
//								var_dump('unoconv -f pdf '.$oof_file_name);
//								exit;
								$output = shell_exec('unoconv -f pdf '.$oof_file_name);
//								$output = shell_exec('libreoffice --headless --convert-to pdf '.escapeshellarg($attachment->atmnt_file_name));
								$odt_pdf_name = rtrim($attachment->atmnt_file_name,$file_extension).'pdf';
								if(file_exists($atch_file_path.$odt_pdf_name))
								{
									$res_font_check = $this->check_pdf_embedded_subset($path,$atch_file_path,$odt_pdf_name,$article_data->art_code,$attachment->atmnt_file_name,$firstfile);
									$firstfile = FALSE;

									if($res_font_check == 'success')
									{

										Attachment_files::update_record(array(
											'atmnt_pdf_name' => $odt_pdf_name),"atmnt_id={$attachment->atmnt_id}", $this->current_user
										);

										$merge_order_array[$attachment->atmnt_order] = array(
											'file_name' => $odt_pdf_name,
											'file_path' => $atch_file_path,
											'original_file_name' => $original_file_name,
											'file_id' => $attachment->atmnt_id,
											'file_ext' => 'pdf'
										);
									}
									else
									{
										$status = 'failed';
										$embedd_msg_file = TRUE;
									}
								}
								else
								{
									$each_file_convert_to_pdf = FALSE;
									array_push($array_pdf_not_coverted,$attachment->atmnt_file_name);
									$status = 'failed';
									$tmp_msg = customTrans('pdf.pdf_generation_failed');
								}
							}
							else
							{
								$path_docx = 'public/uploads/docx/';

								if (!Storage::exists($path_docx))
								{

									$create_dir = Storage::makeDirectory($path_docx);
								}

								$doc_path = 'docx/' . $attachment->atmnt_id . '.' . $file_extension;
								File::copy($atch_file_path . $attachment->atmnt_file_name, public_path() .'/storage/uploads/' . $doc_path);

								$app_id = 'Peer-review : ' . $article_id;
								$doc_path=asset('/storage/uploads/'.$doc_path);
								$response=$this->windows_doc_convertion($app_id,$doc_path);

								if(isset($response['url'])&&$response['url']!='')
								{
								$curl = curl_init();
								curl_setopt($curl, CURLOPT_URL, $response['url']);
								curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
								curl_setopt($curl, CURLOPT_HEADER, false);
								$contents = curl_exec($curl);
								$info = curl_getinfo($curl);
								if (isset($response['status'])&&(isset($info['http_code']))&&$response['status'] == 200 // window server status
								&& $info['http_code'] == 200) // checking curl status
							    {
								$destination = $atch_file_path . $attachment->atmnt_id . '.pdf';
								file_put_contents($destination, $contents);
								if (file_exists($destination))
								{
									$this->remove_fileinfolder(public_path() . '/storage/uploads/docx/' , $attachment->atmnt_id . '.' . $file_extension);

								}
								$res_font_check = $this->check_pdf_embedded_subset($path,$atch_file_path,$attachment->atmnt_id . '.pdf',$article_data->art_code,$attachment->atmnt_file_name,$firstfile);
								$firstfile = FALSE;

								if($res_font_check == 'success')
								{

									Attachment_files::update_record(array(
										'atmnt_pdf_name' => $attachment->atmnt_id . '.pdf'),"atmnt_id={$attachment->atmnt_id}",$this->current_user
									);

									$merge_order_array[$attachment->atmnt_order] = array(
										'file_name' => $attachment->atmnt_id . '.pdf',
										'file_path' => $atch_file_path,
										'original_file_name' => $original_file_name,
										'file_id' => $attachment->atmnt_id,
										'file_ext' => 'pdf'
									);


								}
								else
								{
									$status = 'failed';
									$embedd_msg_file = TRUE;
								}
							}
							else
							{
								$each_file_convert_to_pdf = FALSE;
								array_push($array_pdf_not_coverted,$attachment->atmnt_file_name);
								$status = 'failed';
								$tmp_msg =customTrans('pdf.pdf_generation_failed');
							}
						}
						else{
							$each_file_convert_to_pdf = FALSE;
								array_push($array_pdf_not_coverted,$attachment->atmnt_file_name);
							$status = 'failed';
							$tmp_msg =customTrans('pdf.pdf_generation_failed');
						}


							//	$frontpath=$this->get_upload_path("uploads/".$path.'/'.$attachment->atmnt_file_name);
                        /* Php Word Library Using Doc Conversion */

						/*$doc_pdf_name = rtrim($attachment->atmnt_file_name,$file_extension).'pdf';
							$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
							$frontpath = storage_path() . $file_storage_path . "uploads/".$path.'/'.$attachment->atmnt_file_name;

								$sourcepath = storage_path() . $file_storage_path ."uploads/".$path;

								$doc_pdf_name = rtrim($attachment->atmnt_file_name,$file_extension).'pdf';

								$domPdfPath = base_path('vendor/dompdf/dompdf');
								\PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
								\PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
								$Content = \PhpOffice\PhpWord\IOFactory::load($frontpath);
								$PDFWriter = \PhpOffice\PhpWord\IOFactory::createWriter($Content,'PDF');
									$PDFWriter->save($sourcepath.'/'.$doc_pdf_name);


								$res_font_check = $this->check_pdf_embedded_subset($path,$atch_file_path,$attachment->atmnt_id . '.pdf',$article_data->art_code,$attachment->atmnt_file_name,$firstfile);
								$firstfile = FALSE;

								if($res_font_check == 'success')
								{
									Attachment_files::update_record(array(
										'atmnt_pdf_name' => $doc_pdf_name),"atmnt_id={$attachment->atmnt_id}",$this->current_user
									);

									$merge_order_array[$attachment->atmnt_order] = array(
										'file_name' => $doc_pdf_name,
										'file_path' => $sourcepath.'/',
										'original_file_name' =>$doc_pdf_name,
										'file_id' => $attachment->atmnt_id,
										'file_ext' => 'pdf'
									);

									$embedd_msg_file = FALSE;

								}*/

                            /* End Doc Conversion */

							}
							if($status == 'failed' && $tmp_msg != '')
							{
								$msg[] = $attachment->atmnt_file_name . ' : ' . $tmp_msg;
							}
						}
						elseif (file_exists($atch_file_path . $attachment->atmnt_pdf_name))
						{

							$res_font_check = $this->check_pdf_embedded_subset($path,$atch_file_path,$attachment->atmnt_file_name,$article_data->art_code,$attachment->atmnt_file_name,$firstfile);
							$firstfile = FALSE;
							if($res_font_check == 'success')
							{
								$merge_order_array[$attachment->atmnt_order] = array(
									'file_name' => $attachment->atmnt_pdf_name,
									'file_path' => $atch_file_path,
									'original_file_name' => $original_file_name,
									'file_id' => $attachment->atmnt_id,
									'file_ext' => 'pdf'
								);
							}
							else
								$embedd_msg_file = TRUE;
						}
					}
					elseif (in_array($extension, $pdf_array))
					{
						$res_font_check = $this->check_pdf_embedded_subset($path,$atch_file_path,$attachment->atmnt_file_name,$article_data->art_code,$attachment->atmnt_file_name,$firstfile);
						$firstfile = FALSE;
						if($res_font_check == 'success')
						{

							$merge_order_array[$attachment->atmnt_order] = array(
								'file_name' => $attachment->atmnt_file_name,
								'file_path' => $atch_file_path,
								'original_file_name' => $original_file_name,
								'file_id' => $attachment->atmnt_id,
								'file_ext' => $extension
							);
						}
						else
						{
							$embedd_msg_file = TRUE;
						}
					}
					elseif (in_array($extension, $graphic_array) || in_array($extension, $doc_extra_array))
					{

						$merge_order_array[$attachment->atmnt_order] = array(
							'file_name' => $attachment->atmnt_file_name,
							'file_path' => $atch_file_path,
							'original_file_name' => $original_file_name,
							'file_id' => $attachment->atmnt_id,
							'file_ext' => $extension
						);
					}
					//TASK#300 alert author that csv and xls filetypes will not include in composite PDF
					elseif (in_array($extension, $excel_array))
					{
						if(!empty($temp_excel_arr)) {
							$exlmessage		=	array(' will not include in composite PDF');
							foreach($temp_excel_arr as $key => $val) {
								$excel_conversion_messages[$val] = $exlmessage;
							}
						}
					}
					//TASK#300 alert author that cdx filetype will not include in composite PDF
					elseif (in_array($extension, $cdx_array))
					{
						if(!empty($temp_cdx_arr)) {
							$cdxmessage		=	array(' will not include in composite PDF');
							foreach($temp_cdx_arr as $key => $val) {
								$cdx_conversion_messages[$val] = $cdxmessage;
							}
						}
					}
				}
			}
			}
			if(isset($missing_files) && !empty($missing_files)){
				return $this->warning('Files not found', 200, 'The following files do not exist: ' . implode(', ', $missing_files), 'Warning');
			} // end TASK #6026 Prevent pdf generation if uploaded files does not exist.		
			if($each_file_convert_to_pdf == TRUE && $embedd_msg_file == FALSE)
			{
				$merge_list_avaoided = $this->avoid_inner_files_from_merge_list($merge_order_array,$inline_ref_file_array);
				$result['tex_convert_message'] = $tex_conversion_messages;
				$result['excel_conversion_message'] = $excel_conversion_messages;
				$result['cdx_conversion_message'] = $cdx_conversion_messages;
				$result['conversion_warning'] = false;
                /* TASK #3516 Alerting user about the corrupt files while generating pdf */
                $composite_data=$this->combine_pdf($merge_list_avaoided, $path, $new_pdf_filename, $pdf_settings['PDFLATEX'], $oldPdfUrl,TRUE,$journal_code,$article_id);
                if (isset($composite_data['pdfbuild'])&&$composite_data['pdfbuild']==TRUE)
                /* End TASK #3516 */
                {
					/*Task #9364 */
					$pdf_original_name= isset($composite_data['updatepdfname']) ? $composite_data['updatepdfname'] : $pdfName;
					/*Task #9364 End */
					$pdf_details = array(
						'pdf_art_id' => $article_id,
						'pdf_aflw_id' => $current_stage_id,
						'pdf_art_attachement_order' => $last_generated_file_order_string,
					//	'pdf_name' => $pdfName . '.pdf'
					     'pdf_name'=> $pdf_original_name . '.pdf' /*Task #9364 */
					);
					$pdf_id = 0;
					if ($oldPdfUrl == '')
					{
						$pdf_id = Article_pdf::insert_record($pdf_details, $this->current_user);
					}
					else
					{
						Article_pdf::update_record(array(
							'pdf_show_status' => 'n'),"pdf_aflw_id={$current_stage_id}");

						$pdf_id = Article_pdf::insert_record($pdf_details, $this->current_user);
					}

					if ($pdf_id > 0){
						$this->update_article_pdf_status($article_id, 'y');
						//#336 to update attachment prev file desc id to 'NULL' on every pdf generation
						if(!empty($actual_article_attachments)){
							Attachment_files::update_record(array('atmnt_old_label' => NULL),"atmnt_art_id={$article_id}", $this->current_user,'',"e");
         //$this->Attachment_files->update_description_old_label(array('atmnt_art_id' => $article_id));
						}
					}

					$get_pdf_status = $this->get_article_pdf_status($article_id, TRUE);
					if (!empty($get_pdf_status) && isset($get_pdf_status['ithenticate_link']))
					{
						$result['ithenticate_link'] = $get_pdf_status['ithenticate_link'];

						$ithenticate_auto_submit_table = (new \App\Models\Ithenticate_autosubmission())->getTable();
						$article_pdf_table= (new \App\Models\Article_pdf())->getTable();
						$article_type_advance = (new \App\Models\Article_type_advance_options())->getTable();
						$article_flow_table = (new \App\Models\Article_flow())->getTable();
						$generic_table = (new \App\Models\Generic_flows())->getTable();


						/**
						 *When pdf regenerate after article submission, autho itheticate entry in autho itheticate submission table is not properly update 
						*/
						if($alter_autosumit == TRUE)
						{
							$select = 'atotp_ithsubmission_type,atotp_ithauto_submissions';
							$cnd = 'atotp_artp_id = '.$article_type_id.' AND atotp_ithsubmission_type=\'auto\' AND atotp_ithauto_submissions like \'%author_submission%\' AND atotp_plagiarism_checking = \'y\' ';
							$artp_options = Article_type_advance_options::get_single_record($select,$cnd);
							
							if(!empty($artp_options))
							{
								$qry_cnd = ' jwf_stage_type = \'author_submission\' AND pdf_show_status = \'y\' AND pdf_art_id = '.$article_id;
								$select = 'pdf_id';

								$tables = array(
									'main_table' => $article_pdf_table,
									'join_table' => array(
										$article_flow_table => array('pdf_aflw_id','aflw_id'),
										$generic_table => array('aflw_jwf_id','jwf_id'),
									)
								);

								$pdf_active_data = Article_pdf::get_results_using_joins($tables, $select, $qry_cnd, 'single');
								
								if(isset($pdf_active_data->pdf_id))
								{
									$select = 'ias_id';
									$qry_cnd = ' jwf_stage_type = \'author_submission\' AND ias_status = \'n\' AND pdf_art_id = '.$article_id;
									$tables['join_table'][$ithenticate_auto_submit_table] = array('ias_pdf_id','pdf_id');
									$auto_ith_old_pdf_data = Article_pdf::get_results_using_joins($tables, $select, $qry_cnd, 'single');

									if(isset($auto_ith_old_pdf_data->ias_id))
									{
										Ithenticate_autosubmission::update_record(array(
											'ias_pdf_id' => $pdf_active_data->pdf_id),array(
												'ias_id'=>$auto_ith_old_pdf_data->ias_id
											),$this->current_user
										);
									}
								}
							}
							
						}

						/**
						 * Modified by Anoop Sanakar
						 * If the submission type is 'auto' then show link for manual submission after PDF generation.
						 * Also cancel the auto submission entry, if exists
						 */
						if (isset($get_pdf_status['ithsubmission_type'])&&$get_pdf_status['ithsubmission_type'] == 'auto')
						{

							$ith_auto_submit_sql="
							SELECT `ias_status`, `ias_retry_count`, `pdf_ith_submission_status`, `pdf_ith_submission_message`
							FROM {$ithenticate_auto_submit_table}
							LEFT JOIN {$article_pdf_table} ON `pdf_id` = `ias_pdf_id`
							WHERE `ias_pdf_id` IN (
								SELECT `pdf_id`
								FROM {$article_pdf_table}
								WHERE `pdf_art_id` = {$article_id}
							)";
				  			$ith_auto_submission =Ithenticate_autosubmission::get_records_by_raw_query($ith_auto_submit_sql);
							
							if (!empty ($ith_auto_submission))
							{
								$ith_auto_submit_id = $ith_auto_submission[0]->ias_id;
								Ithenticate_autosubmission::update_record(
									array(
										'ias_status' => 'm'
									),"ias_id={$ith_auto_submit_id}"
									,$this->current_user
								);
							}
							//$result['ithenticate_link'] = $get_pdf_status['manual_ith_link'];
						}
						if (isset($get_pdf_status['ithsubmission_type'])&&$get_pdf_status['ithsubmission_type'] == 'manual'  && isset($get_pdf_status['manual_ith_link']))
						{
							$result['ithenticate_link'] = $get_pdf_status['manual_ith_link'];
						}

						// Task #925 if any pdf changes done run the research integration report
						if(isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
						{
							// #3734 bug in rvri hybrid
							$Generic_flows_table 		= (new \App\Models\Generic_flows)->getTable();
							$is_research_inte_chk 		= Article_flow::get_single_record('(select jwf_stage_type from ' . $Generic_flows_table . ' where jwf_id = aflw_jwf_id) as jwf_stage_type, (select jwf_enable_research_integrity from ' . $Generic_flows_table . ' where jwf_id = aflw_jwf_id) as is_research_inte_enabled', "aflw_id={$current_stage_id}");
							
							if(!empty($is_research_inte_chk)) {
								$is_research_inte_enabled 	=	$is_research_inte_chk->is_research_inte_enabled;
								$enbld_stage_type 			=	$is_research_inte_chk->jwf_stage_type;
							}
							
							$article_type_options = Article_type_advance_options::get_single_record('atotp_rvrisubmission_type, atotp_rvriauto_submissions', 'atotp_research_integrity ="y" and atotp_artp_id=' . $article_type_id); 
							if(!empty($article_type_options)) {
							$art_submit_status = Articles::get_single_record('art_status', "art_id={$article_id}");
								$atotp_rvriauto_submissions = json_decode($article_type_options->atotp_rvriauto_submissions, true);	
								
								if((is_array($atotp_rvriauto_submissions) && in_array($enbld_stage_type, $atotp_rvriauto_submissions)) && $article_type_options->atotp_rvrisubmission_type =='auto' && $art_submit_status->art_status == 'y' && $is_research_inte_enabled == 'n'){
									$data_rri['rri_status'] = 'n';
									$data_rri['rri_new_report'] = 'n';
									$data_rri['rri_submission_type'] = 'a';
									$data_rri['rri_report'] = NULL;
									Research_integrity_reports::update_record($data_rri, 'rri_art_id=' . $article_id, $this->current_user);
								} else {
									$data_rri['rri_new_report'] = 'n';
								Research_integrity_reports::update_record($data_rri, 'rri_art_id=' . $article_id, $this->current_user);
								}
							}
						}
					}

                      $status=TRUE;
					$result['status'] = $status;

				//	$result['pdf_id'] = encrypt_link($pdf_id);
					if (count($msg) > 0)
					{
						$result['message'] = implode('<br>', $msg);
					}
					elseif (!empty($tex_conversion_messages))
					{
						$result['conversion_warning'] = true;
						$result['message'] = customTrans('pdf.pdf_generated_warning');
					}
					elseif (!empty($excel_conversion_messages))
					{
						$result['conversion_warning'] = true;
						$result['message'] = customTrans('pdf.pdf_generated_warning');
					}
					elseif (!empty($cdx_conversion_messages))
					{
						$result['conversion_warning'] = true;
						$result['message'] = customTrans('pdf.pdf_generated_warning');
					}
					else
					{
						$result['conversion_warning'] = false;
						$result['message'] = customTrans('pdf.pdf_generated');
					}
					if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
					$this->update_s3_files($path);
					}
					//$result['link'] = $previewLink;
				}
                /* TASK #3516 Alerting user about the corrupt files while generating pdf */
                else
                {
                    if(isset($composite_data['foldername'])&&isset($composite_data['logfilename']))
                    {
                        $log_file_path =$atch_file_path.'/'.$composite_data['foldername'].'/'.$composite_data['logfilename'];
                        $uploadlogcorrectfile=$this->get_corrupt_file($log_file_path);
                    }
                    $result['status'] = 'warning';
                    if(isset($uploadlogcorrectfile[0]))
                        $result['message'] ="We couldn't generate the PDF for a corrupt file: <br/><b>".$uploadlogcorrectfile[0]."</b>";

                }
                /* End TASK #3516 */
			}
			else
			{

					$result['status'] = 'failed';
					//$result['pdf_id'] = encrypt_link($pdf_id);
					if($embedd_msg_file == TRUE)
					{
						$txt_file_path = $path.$article_data->art_code.'.txt';
						//$download_link = base_url('journal/' . $this->jnl_data->jnl_journal_code. '/download-embedded-fontlist') . '?' . encrypt_link('path=' . $txt_file_path);
						$result['embedd_msg_link'] = $download_link;
					//	$message = '<a href="'.$download_link.'">click here</a>';
						$result['message'] = str_replace('%LINK%',$message,customTrans('pdf.embedded_font_dwn_msg'));
					}
					elseif (count($msg) > 0)
					{
						$result['message'] = implode('<br>', $msg);
					}
                     /* TASK #3516 Alerting user about the corrupt files while generating pdf */
					elseif (!empty($tex_conversion_messages))
					{
                        $result['tex_convert_message']=$log_error_array;
                        $result['status'] = 'failed_with_warning';
						$result['message'] = $result['message'] =" We couldn't generate the PDF for a corrupt file: <br/><b>".implode('<br>', $array_pdf_not_coverted)."</b>";
					}
					elseif (!empty($excel_conversion_messages))
					{
                        $result['excel_conversion_message']=$excel_conversion_messages;
                      //  $result['status'] = 'failed_with_warning';
                        $result['tex_convert_message']=$log_error_array;
                        // $result['message'] =customTrans('pdf.pdf_generation_failed');
                        $result['message'] = $result['message'] =" We couldn't generate the PDF for a corrupt file: <br/><b>".implode('<br>', $array_pdf_not_coverted)."</b>";
					}
					elseif (!empty($cdx_conversion_messages))
					{
						$result['message'] =  customTrans('pdf.pdf_generation_failed');
					}
					else
					{
						if(!empty($log_error_array))
                        {
                            $result['status'] = 'failed_with_warning';
                        }
                        if(!empty($array_pdf_not_coverted))
                        {
                            $result['tex_convert_message']=$log_error_array;
                            $result['message'] ="We couldn't generate the PDF for a corrupt file: <br/><b>".implode('<br>', $array_pdf_not_coverted)."</b>";

                        }
                        else
                        {
                            $result['message'] =  customTrans('pdf.pdf_generation_failed');
                        }

                     /*  End TASK #3516 */
					}
			}
		}
		else
		{

			$result['status'] = 'warning';
			$result['message'] =customTrans('pdf.pdflatex_missing');
		}
		/*TASK #7300 Undefined text is displayed in url in the preview pdf*/
		if (isset($art_type) && !empty($art_type->artp_abbr_article_type)) {
			$result['art_type_code'] = $art_type->artp_abbr_article_type;
		} elseif (isset($article_type) && !empty($article_type->artp_abbr_article_type)) {
			$result['art_type_code'] = $article_type->artp_abbr_article_type;
		} 	/* end TASK #7300 Undefined text is displayed in url in the preview pdf*/
		return  $this->success('Success',200,$result);
    }
    catch (\Exception $e)
    {
   		return  $this->failure('Failed',200,$e);
	}
   }
    /* TASK #3516 Alerting user about the corrupt files while generating pdf */
   public function get_corrupt_file($logFilePath) {
    $error_messages = [];
    $extracting = false;

    // Check if the log file exists
    if (file_exists($logFilePath)) {
        // Open the log file for reading
        $log_file = fopen($logFilePath, 'r');

        // Loop through each line of the log file
        while (($line = fgets($log_file)) !== false) {
            // Check if the line contains '!pdfTeX error'
            if (strpos($line, '!pdfTeX error') !== false) {
                $extracting = true;
            } elseif ($extracting) {
                // Extract the filename.extension from the current line
                if (preg_match('/\/([^\/]+\.[^:\s]+)\s*:\s*/', $line, $matches)) {
                    $filenameWithExtension = basename($matches[1]);
                    $filenameWithExtension = rtrim($filenameWithExtension, ')'); // Remove trailing bracket
                    $error_messages[] = $filenameWithExtension;
                } else {
                    // If the pattern doesn't match, stop extracting
                    $extracting = false;
                }
            }
        }

        fclose($log_file);
    }

    return $error_messages;
}
    /*  End TASK #3516 */
public function windows_doc_convertion($app_id,$doc_path)
{
	try
	{

      // Create a new Guzzle client
	  $client = new Client();
	  // Define the URL you want to send the POST request to
	  $pdf_settings = Config::get('pdf.pdf_settings');
      $url=$pdf_settings['WINDOW_SERVER'].'/api/wordtopdf';
	  // Define the data you want to send in the request body
	  $data = [
		  'app_id' =>$app_id,
		  'file_url' =>$doc_path,
		  'client_code'=>$this->current_client->clnt_client_code
	  ];

		  // Send the POST request
		  $response = $client->post($url, [
			  'json' => $data, // Use 'json' to send JSON data, or 'form_params' for form data
		  ]);

		  // Get the response body as a string
		  $responseBody = $response->getBody()->getContents();
		  // You can then process the response as needed
		  $responseData = json_decode($responseBody, true);

        return $responseData;
	}
	catch (\Exception $e)
    {

   		return  $this->failure('Failed',200,$e);
	}
}
public function get_pdf($app_id, $doc_path)
   {
	   require_once public_path() . '/lib/xmlrpc.inc';
	   //$this->load->config('pdf');
	   //$pdf_settings = $this->config->item('pdf_settings');
	   $pdf_settings = Config::get('pdf.pdf_settings');

	   // Make an object to represent our server.
	   $server = new xmlrpc_client('/wordtopdf/wordtopdf.php', $pdf_settings['WORD_TO_PDF_IP'], 80);

	   // Send a message to the server.
	   $message = new xmlrpcmsg('word.convert2pdf', array(
		   new xmlrpcval($app_id, 'string'),
		   new xmlrpcval(base_path() . $doc_path, 'string')));

	   $result = $server->send($message);

	   $return_array = array();
	   $status = 500;
	   // Process the response.
	   if (!$result)
	   {
		   $return_array['message'] = "Could not connect to HTTP server.";
	   }
	   elseif ($result->faultCode())
	   {
		   $return_array['message'] = $result->faultString();
	   }
	   else
	   {
		   $struct = $result->value();
		   $status = $struct->structmem('status')->scalarval();
		   $url = $struct->structmem('url')->scalarval();
		   $description = $struct->structmem('description')->scalarval();
		   $file_name = $struct->structmem('file_name')->scalarval();

//			var_dump($status, $url, $description);

		   $return_array['description'] = $description;
		   $return_array['url'] = $url;
		   $return_array['file_name'] = $file_name;
		   $return_array['message'] = 'Pdf generated successfully';
	   }
	   $return_array['status'] = $status;

	   return $return_array;
   }

 public function create_cover_page($path, $journal_code, $article_type_id, $article_id)
   {
	   $coverdata = array();

	  // $date_format = Articles::$date_format_map[$this->jnl_data->jset_date_format];
	  $journalData = Journals::get_single_record('jnl_id,jnl_journal_name,jnl_logo,jnl_journal_code',"jnl_journal_code='{$journal_code}'");
	$coverdata['journal'] = $journalData->jnl_journal_name;
	  $date_format=$this->get_platform_date_format( $journalData->jnl_id);
	  $date_format = static::date_format_map($date_format);
	   $select = 'art_title,art_code,art_submitted_by, date_format(art_submission_date,\'' . $date_format . '\') submitted_date';
	   if($this->current_client->modules->mdl_review_for_doc == 'y')
		   $select.=', date_format(art_update_last_date,\'' . $date_format . '\') update_last_date';
	   $article_data = Articles::get_single_record($select,"art_id={$article_id}");

	   $coverdata['article_title'] = $article_data->art_title;
	   $coverdata['article_submitted'] = $article_data->submitted_date;
	   if($this->current_client->modules->mdl_review_for_doc == 'y')
	   $coverdata['update_last_date'] = $article_data->update_last_date;
	   $articleTypeData =Article_types::get_single_record("artp_article_type,artp_abbr_article_type","artp_id={$article_type_id}");
	   $coverdata['article_type'] = $articleTypeData->artp_article_type;
	   $coverdata['article_code'] = $article_data->art_code;
	   $coauthor_details = Authors::coauthor_with_affiliation($article_id);
	   $auth_usr_names=$this->getcoauthornames($coauthor_details);
	   $articleKeywords = Article_keywords::get_article_keywords($article_id);
	   $keywords=$this->getkeyword($articleKeywords);
	   $coverdata['article_authors']=$auth_usr_names;
	   $coverdata['article_keywords']=$keywords;
	   $document = new PDF( [
		'mode' => 'utf-8',
		'format' => 'A4',
		'margin_header' => '3',
		'margin_top' => '20',
		'margin_bottom' => '20',
		'margin_footer' => '2',
	]);

	   $data = array();
	   $data['page_type'] = 'front';
	   $data['coverdata'] = $coverdata;

	   $client_functionality =  $this->get_client_functionalities($this->current_client->clnt_id, $this->current_client->clnt_client_code);

	   $data['review_logo']= public_path().'/img/rvt-logo.png';

	   $data['hide_submitted_author_in_cover'] = $client_functionality->cfty_hide_auth_name_in_cover;
	   $article_type_advance =Article_type_advance_options::get_single_record("atotp_review_method, atotp_custom_blind_params", "atotp_artp_id={$article_type_id}");
	   $data['review_method'] = $article_type_advance->atotp_review_method;
		if ($article_type_advance->atotp_review_method == 'c') {
			if ($article_type_advance->atotp_custom_blind_params) {
				$params = $article_type_advance->atotp_custom_blind_params;
				$params = json_decode($params, true);
				$author_role_id = Roles::where('role_assigned_role', '=', 'author')->get(['role_id'])->first()->role_id;
				foreach ($params as $param) {
					if (in_array($author_role_id, $param)) {
						$data['review_method'] = 'd';
					}
				}
			}
		}
	   $data['mdl_review_for_doc'] = $this->current_client->modules->mdl_review_for_doc;
	   $data['jnl_data']=$journalData;
	   $logo_path='uploads/'.$journalData ->jnl_journal_code.'/thumb_'.$journalData->jnl_logo;
	   $folder_path=public_path().'/storage/uploads/'.$journalData ->jnl_journal_code.'/thumb_'.$journalData->jnl_logo;
	  $data['folder_file_exist']=FALSE;
	   if (file_exists($folder_path)) {

	    $data['folder_file_exist']=TRUE;
	}

       $data['jnl_logo']=$this->get_upload_path($logo_path);

	   $data['content_view'] = view('template.tmpl_pdf_pages')->with($data);
	 $document->WriteHTML($data['content_view']);
	  /* TASK #6026 Error showing Article folder does not exist */
	 $art_id_path = public_path().'/storage/uploads/'.$path;	
	 if (file_exists($art_id_path)) {
		$document->Output(public_path().'/storage/uploads/'.$path . '0.pdf', 'F');
	}  /* TASK #6026 Error showing Article folder does not exist */
	   return '0.pdf';
   }
   public function compile_tex_to_pdf($path, $file_name, $pdf_settings)
   {
    /* TASK #3516 Alerting user about the corrupt files while generating pdf */
	try
	{
	   $converted_file = NULL;
	   $return_array_tex=array();
	   $return_array_tex['log_file_status']=FALSE;
	   if(file_exists($path.$file_name))
	   {
		   $ext = pathinfo($file_name, PATHINFO_EXTENSION);
		   $filename = pathinfo($file_name, PATHINFO_FILENAME);

		   if($ext == 'tex' || $ext == 'TEX')
		   {
			   $pdf_file_name = basename($file_name,'.'.$ext).'.pdf';
			   //when corrupted file is uploaded those  extension  are also created 
			   $log_tex_file_name = basename($file_name,'.'.$ext).'.log';
			     $aux_tex_file_name = basename($file_name,'.'.$ext).'.aux';
				$fdb_latexmk_tex_file_name = basename($file_name,'.'.$ext).'.fdb_latexmk';
			    $fls_tex_file_name = basename($file_name,'.'.$ext).'.fls';
				$nlo_tex_file_name = basename($file_name,'.'.$ext).'.nlo';
				$out_tex_file_name = basename($file_name,'.'.$ext).'.out';
				$toc_tex_file_name = basename($file_name,'.'.$ext).'.toc';
			   /*if(file_exists($path.$pdf_file_name))
			   {
				   unlink($path.$pdf_file_name);
			    }*/
				//Task #301 PDF generation failed
			FacadesFile::delete($path.$pdf_file_name);
			FacadesFile::delete($path.$log_tex_file_name);
            FacadesFile::delete($path.$aux_tex_file_name);
            FacadesFile::delete($path.$fdb_latexmk_tex_file_name);
            FacadesFile::delete($path.$fls_tex_file_name);
			FacadesFile::delete($path.$nlo_tex_file_name);
			FacadesFile::delete($path.$out_tex_file_name);
			FacadesFile::delete($path.$toc_tex_file_name);
		   }
		   $path_splited = explode('/', $file_name);
		   $tex_file_name = end($path_splited);

		   $tex_file_path = $path.rtrim($file_name,$tex_file_name);
		   $output = chdir($tex_file_path);
		   $tex_compiler = config('general_config.tex_compiler');
		   if($tex_compiler == 'local'){
			$output = shell_exec($pdf_settings['LATEXMK'].' -f --xelatex -pdf '."'$tex_file_name'");
		   }elseif($tex_compiler == 'docker'){
            $base_path = base_path();
            $output = shell_exec("$base_path/latex-script.sh LATEXMK '$tex_file_name'");
			// dd($tex_file_path);

            }elseif($tex_compiler == 'microservice'){
                $tex_host = config('general_config.tex_host');
                $tex_port = config('general_config.tex_port');
                $response = Http::post("http://$tex_host:$tex_port/execute", [
                    'command' => "latexmk -f --xelatex -pdf  '$tex_file_name'",
                    'working_dir' => $tex_file_path
                ]);
            }
	   }

	   $errors = $this->identifyErrorsInLog($path. rtrim($file_name,'tex').'log');
       if($errors){
        FacadesFile::delete($path.rtrim($file_name,'tex').'pdf');
       }

	   $pdf_file = $path. rtrim($file_name,'tex').'pdf';
       $return_array_tex['log_file_status']=FALSE;
	   if(file_exists($pdf_file))
	   {
		   $converted_file = str_replace($path, '', $pdf_file);
	   }
	   else
		{

            $return_array_tex['log_file_status']=TRUE;
            $return_array_tex['log_file_path']=$path.$log_tex_file_name ;
            $return_array_tex['log_root_path']=$path;
            $return_array_tex['log_file_name']=$log_tex_file_name ;
		}
	$return_array_tex['converted_file_name']=$converted_file;
    return $return_array_tex;
   /* End TASK #3516 Alerting user about the corrupt files while generating pdf */
	}
	catch (\Exception $e)
    {
   		return  false;
	}

   }

	private function identifyErrorsInLog($logFilePath)
	{
		if (!file_exists($logFilePath)) {
			return "Log file not found.";
		}

		$lines = file($logFilePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

		$errorLines = [];

		foreach ($lines as $line) {
			if (strpos(trim($line), '!') === 0) {
				$errorLines[] = $line;
			}
		}

		return $errorLines;
	}

   	/* Function to check the tex file contains documentclass
	 * $path - root upload path of the article
	 * $tex - tex files */
	public function is_main_tex_file($path, $tex)
	{
	try
	{
		$status = FALSE;
		$tex_file_path = $path.$tex;

		$tex_file = fopen($tex_file_path, 'r');

		// Loop through each lines of tex file until the system identify documenclass
		while (($content_line = fgets($tex_file,filesize($tex_file_path))) != FALSE)
		{
			preg_match('/(\\\\documentclass)(\[.*\])?(\{.*\})/', $content_line,$match_doc_class);
			if(count($match_doc_class) > 0)
			{
				$status = TRUE;
				break;
			}
		}

		fclose($tex_file);

		return $status;
	}
	catch (\Exception $e)
    {

   		return  false;
	}
	}

	//Feature #2575	JPR-376 PDF files generated in ReView
	public function check_pdf_embedded_subset($art_path,$file_path,$filename,$art_code,$org_filename = NULL,$firstfile = FALSE)
	{
		try
		{
		if (isset($this->current_client->functionality->cfty_viewpdf_embedded_subset_check) && $this->current_client->functionality->cfty_viewpdf_embedded_subset_check == 'y')
		{
			$return = 'failed';

			$url = $file_path . $filename;
			if(file_exists($url))
			{
				$sam_arr = array();
				$file = $art_path.'smp_text.txt';
				$article_text = $art_path.$art_code.'.txt';
				if($org_filename != NULL)
					$filename = $org_filename;


				/*
				//$output = shell_exec('pdffonts '.$url.' | awk \'{print $1}\' | grep -v + | sed \'s/name//g\' | sed \'s/-//g\'');
				$output = shell_exec('pdffonts -subst '.$file.' | awk \'{print $1}\' | sed \'s/name//g\' | sed \'s/-//g\'');

				*/


				$output = shell_exec('pdffonts -subst '.$url.' | awk \'{print $1}\' | sed \'s/name//g\' | sed \'s/-//g\'');
				$temp_str = trim($output);
				if(strlen($temp_str) > 0)
				{
					file_put_contents($file, $temp_str);
					$readfile = fopen($file, 'r');
					while (!feof($readfile))
					{
						$s = fgets($readfile);
						if(trim($s) != '')
							$sam_arr[] = trim(str_replace ('\n', '', $s));
					}
					$sam_arr = array_unique($sam_arr);
					fclose($readfile);
					unlink($file);

					$non_embedd_fonts = string_with_comma_separation($sam_arr);

					$output = shell_exec('pdffonts '.$url);

					$tmp_msg = str_replace('%FILE_NAME%', $filename, customTrans('pdf.pdf_non_embeddedfont_msg'));
					$error_msg = str_replace('%NON_EMBEDDED_FONTS%', $non_embedd_fonts, $tmp_msg)."\n\n".$output;

					if($firstfile == TRUE)
						file_put_contents($article_text, $error_msg);
					else
					{
						$error_msg = "\n\n".$error_msg;
						file_put_contents($article_text, $error_msg,FILE_APPEND);
					}
				}
				else
				{
					$return = 'success';
				}
			}
		}
		else  //if client funcitonality off
		{
			$return = 'success';
		}

		return $return;
	}
	catch (\Exception $e)
    {

   		return  false;
	}
	}

/* Function to get all inner files refered in the tex file
	 * $path - root upload path of the article
	 * $tex_file - tex file */
	public function get_inner_files($path, $tex_file)
	{
		try
		{
		$inner_files = array();

		$fls_file_path = $path.rtrim($tex_file,'.tex').'.fls';//gets .fls file name

		if(file_exists($fls_file_path))
		{
			$fls_file = fopen($fls_file_path, 'r');

			while (($content_line = fgets($fls_file, filesize($fls_file_path))) != FALSE)
			{
				//Regular expression to find the refered fils in the tex file
				preg_match('/^INPUT\s(\.?\/?.*\.(pdf|PDF|jpg|JPG|png|PNG|eps|EPS|tex|TEX|gif|GIF|jpeg|JPEG))/', $content_line,$match_inner_files);
				if(count($match_inner_files) > 0)
				{
					$inner_file_name = ltrim($match_inner_files[1],'./');
					//avoid eps converted pdf files
					if(!empty($inner_file_name) && $tex_file != $inner_file_name && strpos($inner_file_name, 'eps-converted-to') === FALSE && !in_array($inner_file_name, $inner_files))
					{
						$inner_files[] = $inner_file_name;
					}

				}
			}

			fclose($fls_file);
		}

		return $inner_files;
	}
	catch (\Exception $e)
    {

   		return  false;
	}
	}

	public function get_tex_to_pdf_conversion_error($path, $tex_file)
	{
		try
		{
		$tex_error_messages = array();
		$log_file_path = $path. rtrim($tex_file,'.tex').'.log';
		if(file_exists($log_file_path))
		{
			$log_file = fopen($log_file_path,'r');
			$log_details = fread($log_file, filesize($log_file_path));
			fclose($log_file);
			preg_match_all('/(\! LaTeX Error\:.*\n)|(LaTeX Warning\:.*\n)/', $log_details, $matches);
			if ($matches != NULL && is_array($matches))
			{
				$error_msgs = $matches[0];
				foreach ($error_msgs as $err_msg)
				{
					$tex_error_messages[] = '<span>' . str_replace('\! La', 'La', $err_msg) . '</span><br>';
				}
			}
		}
		return $tex_error_messages;
	}
	catch (\Exception $e)
    {

   		return  false;
	}
	}

	function avoid_inner_files_from_merge_list($merge_list, $inner_files)
	{
		foreach ($inner_files as $inner_file)
		{
			foreach ($merge_list as $file_order => $file_detail)
			{
				if(strpos($file_detail['file_name'], $inner_file) !== FALSE)
				{
					unset($merge_list[$file_order]);
					break;
				}
			}
		}

		return $merge_list;
	}

/*
	 * Function to merge files (Including tex converted pdf and cover page pdf) to one PDF
	 * $file_array - holding all files needs to be merged
	 * $path - root upload path of the article
	 * $new_pdf_filename - newly creating pdf file name
	 * $pdflatex - pdflatex settings
	 * $old_file_name - file name if there are any previously generated PDF for the article
	 */
	public function combine_pdf($file_array, $path, $new_pdf_filename, $pdflatex, $old_file_name = '',$sep_file_path = FALSE,$platform_code='',$article_id='')
	{
		try
		{
            $pdfbox_path                =   '';
            $usepackage_pax             =   '';
            //TASK#371 If pdf annot extractor is enabled, then make links clickable
           /* if (isset($this->current_client->functionality->cfty_keep_the_links_unbroken_in_pdf) && $this->current_client->functionality->cfty_keep_the_links_unbroken_in_pdf == 'y'){
                //#371 store the pdfbox lib path
                $pdfbox_path                =   APPPATH.'third_party/PDFBox-0.7.3/lib/PDFBox-0.7.3.jar';
                $usepackage_pax             =   '\usepackage{pax}';
            }
            */
			$platform_data=$this->platform_basic_settings_data($platform_code);
            $date_format=$platform_data->jset_date_format;
			$date_format = static::date_format_map($date_format);

			$condition="art_id={$article_id}";
			$select = 'art_title,art_code,art_submitted_by,art_artp_id,date_format(art_submission_date,\'' . $date_format . '\') AS submitted_date';
			$article_data=Articles::get_single_record($select,$condition);

	        $article_type_id=$article_data->art_artp_id;
			 $article_submitted =$article_data->submitted_date;
			 if($this->current_client->modules->mdl_review_for_doc == 'y')
			 $update_last_date = $article_data->update_last_date;
			// $coauthor_details = Authors::coauthor_with_affiliation($article_id);
			// $auth_usr_names=$this->getcoauthornames($coauthor_details);

	     $articleTypeData =Article_types::get_single_record("artp_article_type,artp_abbr_article_type","artp_id={$article_type_id}");
	       $article_type = $articleTypeData->artp_article_type;

		 // $join_template_file = $this->upload_folder_path($path . 'join_template.tex',true);
		 $join_template_file= 'uploads/' . $path. 'join_template.tex';

		if (file_exists($join_template_file))
			unlink($join_template_file);

		if (isset($old_file_name) && !empty($old_file_name))
		{
			$old_temp_directory = preg_replace('/\.pdf$/', '', $old_file_name);
			if (file_exists($path . $old_file_name) && is_dir($path . $old_temp_directory))
			{

				array_map('unlink', glob($path . $old_temp_directory . '/*.*'));
				rmdir($path . $old_temp_directory);
			}
			if (file_exists($path . $old_file_name))
				unlink($path . $old_file_name);
		}

		if (!is_dir($path . $new_pdf_filename . '.pdf') && file_exists($path . $new_pdf_filename . '.pdf'))
			unlink($path . $new_pdf_filename . '.pdf');


		$pdffooter = 'clients.' . $this->current_client->clnt_client_code . '.pdf.pdf_footer';
		$footer_text  = Config::get($pdffooter);

		$pdf_journal_title = $platform_data->jnl_journal_name;
	//$pdf_article_title = "dvdsv # $ % & ~ _ ^ \ { }.";

	//echo preg_replace_callback("|([\^\%~\\\\#\$%&_\{\}])|",latexSpecialChars,$pdf_article_title);

	    $pdf_article_title =$this->replace_latexspecialchars($article_data->art_title);

		$pdf_article_code = $this->replace_latexspecialchars($article_data->art_code);
		$pdf_article_type =$article_type;
		$pdf_rvt_logo_path = public_path()."/images/rvt-logo.png";
$join_template_file_content = '\documentclass[8pt,a4paper]{article}
\usepackage{grffile}
\usepackage[final]{pdfpages}
\usepackage[left=1cm, right=1cm, top=2cm, bottom=2cm]{geometry}
\usepackage[yyyymmdd,hhmmss]{datetime}
\usepackage{pgffor}
\usepackage{titleps}
\usepackage{graphicx}
'.$usepackage_pax.'
\usepackage[utf8x]{inputenc}
\usepackage[yyyymmdd,hhmmss]{datetime}%\
\usepackage[export]{adjustbox}
\usepackage{epstopdf}
\epstopdfDeclareGraphicsRule{.tif}{png}{.png}{convert #1 \OutputFile}
\AppendGraphicsExtensions{.tif}

\usepackage{tcolorbox}% http://ctan.org/pkg/tcolorbox
\definecolor{mycolor}{rgb}{0.122, 0.435, 0.698}% Rule colour
\makeatletter
\usepackage[export]{adjustbox}
%\newcommand{\mybox}[1]{%
%  \setbox0=\hbox{#1}%
%  \setlength{\@tempdima}{\dimexpr\wd0+13pt}%
%  \begin{tcolorbox}[colframe=mycolor,boxrule=0.5pt,arc=4pt,
%      left=6pt,right=6pt,top=6pt,bottom=6pt,boxsep=0pt,width=\@tempdima]
%    #1
%  \end{tcolorbox}
%}

\newpagestyle{main}{%
\setheadrule{0.4pt}
\sethead{\itshape\sffamily Auto-generated PDF by ReView}{}{\sffamily\itshape '. $pdf_journal_title .'}
\setfootrule{0.4pt}
%\setfoot{\itshape\sffamily\today\ \currenttime}{\itshape\sffamily ' . escapeshellcmd($footer_text) . '}{\sffamily\itshape\thepage}
\setfoot{\itshape\sffamily\scriptsize\ \name}{\itshape\sffamily ' . escapeshellcmd($footer_text) . '}{\sffamily\itshape\thepage}
%Uncomment following line to set the label
%\begin{picture}(0, 0)\put(-30,10){{\large\bfseries\name}}\end{picture}
%\begin{picture}(0, 0)\put(-43,10){\fboxsep=3pt\mybox{{\normalsize\bfseries\name}}}\end{picture}
}
\def\xincludepdf[#1]#2[#3]{\gdef\name{#3}\includepdf[#1]{#2}}

\begin{document}
';

		ksort($file_array);//sorting the files in the attachment order
		//itreate through files to create mearge template
		foreach ($file_array as $file_order => $file_detail)
		{
			//1.Upgrade #2293 Manage review uploads
			//$file_path = $this->upload_folder_path($path,true);
			$file_path ='uploads/' . $path;;
			if(isset($file_detail['file_path']) && $sep_file_path == TRUE)
			{
				$file_path = $file_detail['file_path'];
			}

			if (file_exists($file_path . $file_detail['file_name']))
			{

                                /*
                                 * TASK#371
                                 * hence we are using pax package, a bug found when we upload files that has space in its name.
                                 * in this case, the generated pdf will show the file name in the footer
                                 * so the attached file's name need to place between the double quotes (ie., "test 1".pdf, "test 2".jpg etc)
                                 */
								$nw_file_name = $file_detail['file_name'];
								$file_name_arr = explode('/',$file_detail['file_name']);
								if(count($file_name_arr) > 1)
								{
									$file_name_fr_path = end($file_name_arr);
									if(strpos($file_name_fr_path, ' ') !== false)
									{
										$fext    =   pathinfo($file_name_fr_path, PATHINFO_EXTENSION);
										$fname   =   basename($file_name_fr_path,".".$fext);
										$nw_file_name   =   '"'.$fname.'".'.$fext;
										array_pop($file_name_arr);
										$combined_path = implode('/',$file_name_arr);
										$nw_file_name = $combined_path.'/'.$nw_file_name;
									}
								}

                                /*if (strpos($file_detail['file_name'], ' ') !== false) {
                                    $fext    =   pathinfo($file_detail['file_name'], PATHINFO_EXTENSION);
                                    $fname   =   basename($file_detail['file_name'],".".$fext);
                                    $nw_file_name   =   '"'.$fname.'".'.$fext;
                                } else {
                                    $nw_file_name   =   $file_detail['file_name'];
                                }*/

				$page_style = $file_detail['file_name'] == '0.pdf' ? '\thispagestyle{empty}':'\thispagestyle{main}';

				if(strtolower($file_detail['file_ext']) == 'pdf')
				{
                                        $join_template_file_content .= '\xincludepdf[width=\textwidth,keepaspectratio,pages=-,pagecommand={'.$page_style.'}]{' . $file_path.$nw_file_name. '}['. escapeshellcmd($file_detail['original_file_name']).']
';
                                        //TASK#371 If pdf annot extractor is enabled, then make links clickable
                                        if (isset($this->current_client->functionality->cfty_keep_the_links_unbroken_in_pdf) && $this->current_client->functionality->cfty_keep_the_links_unbroken_in_pdf == 'y'){
                                            //#371 Extract annotations from pdf files and stores in <file_name>.pax file
                                            shell_exec("CLASSPATH='".$pdfbox_path.":%CLASSPATH%' pdfannotextractor ".escapeshellarg($file_path.$file_detail['file_name']));
                                            //#371 pax looks for the pdf with the links, reads them and puts the links in the right place.
                                            shell_exec("CLASSPATH='".$pdfbox_path.":%CLASSPATH%' pax ".escapeshellarg($file_path.$file_detail['file_name']));
                                        }

                                }
				elseif (in_array(strtolower($file_detail['file_ext']),array('tiff','tif')))
				{
					$nw_file_name = str_replace('"', "", $nw_file_name);
					$new_file_extension = pathinfo($nw_file_name, PATHINFO_EXTENSION);
					$jpg_file = rtrim($nw_file_name,$new_file_extension).'jpg';
					$convert_command = 'convert -layers flatten '.escapeshellarg($file_path.$file_detail['file_name']).' '.escapeshellarg($file_path.$jpg_file);
					$output = shell_exec($convert_command);
					if(file_exists($file_path.$jpg_file))
					{
						/*if(strpos($jpg_file, ' ') !== false)
						// {
                        //     $fext    =   pathinfo($jpg_file, PATHINFO_EXTENSION);
                        //     $fname   =   basename($jpg_file,".".$fext);
                        //     $jpg_file   =   '"'.$fname.'".'.$fext;
                        }*/
						$join_template_file_content .= '\xincludepdf[width=\textwidth,keepaspectratio,pages=-,pagecommand={'.$page_style.'}]{' . $file_path.$jpg_file. '}['. escapeshellcmd($file_detail['original_file_name']).']';
					}
				}
				elseif(in_array(strtolower($file_detail['file_ext']),array("xlsx","ppt","pptx","xls")))
				{
					$nw_file_name = str_replace('"', "", $nw_file_name);
					$actual_file_name = basename($nw_file_name,'.'.$file_detail['file_ext']);
					$convert_command = 'libreoffice --convert-to pdf '.escapeshellarg($actual_file_name).' --outdir '.escapeshellarg($file_path) .' '. escapeshellarg($file_path.$nw_file_name);
					$output = shell_exec($convert_command);
					if(file_exists($file_path.$nw_file_name))
					{
						if(strpos($actual_file_name, ' ') !== false)
						{
                            $actual_file_name   =   '"'.$actual_file_name.'"';
                        }
						//$actual_file_name = '"'.$actual_file_name.'"';
						$join_template_file_content .= '\xincludepdf[width=\textwidth,keepaspectratio,pages=-,pagecommand={'.$page_style.'}]{' .$file_path.'"'.$actual_file_name.'"'.'.pdf'. '}['. escapeshellcmd($file_detail['original_file_name']).']';

					}
				}
				else
				{
					$join_template_file_content .= '\xincludepdf[width=\textwidth,keepaspectratio,pages=-,pagecommand={'.$page_style.'}]{' .$file_path.$nw_file_name. '}['. escapeshellcmd($file_detail['original_file_name']).']';

                                        }
}
							}
		$join_template_file_content .= '\end{document}';

	$this->upload_file_content($join_template_file, $join_template_file_content);
    $temp_join_file_path = storage_path().'/app/public/uploads/'.$path . $new_pdf_filename . '/';
    //if (!file_exists($temp_convertion_path))
    //  mkdir($temp_join_file_path, 0777);
    $storagepath=public_path()."/storage/uploads/".$path;

    if(!file_exists($temp_join_file_path))
    File::makeDirectory($temp_join_file_path,$mode = 0777, true, true);
    chdir($storagepath);
	$tex_compiler = config('general_config.tex_compiler');
	if($tex_compiler == 'local'){
		$output = shell_exec($pdflatex . ' -output-directory=' . $temp_join_file_path . ' -jobname=' . $new_pdf_filename . ' -interaction=nonstopmode -shell-escape join_template.tex');
	}elseif($tex_compiler == 'docker'){
		$base_path = base_path();
		$output = shell_exec("$base_path/latex-script.sh PDFLATEX $new_pdf_filename");
	}elseif($tex_compiler == 'microservice'){
        $tex_host = config('general_config.tex_host');
        $tex_port = config('general_config.tex_port');
        $response = Http::post("http://$tex_host:$tex_port/execute", [
			'command' => 'pdflatex -output-directory=' . $temp_join_file_path . ' -jobname=' . $new_pdf_filename . ' -interaction=nonstopmode -shell-escape join_template.tex',
			'working_dir' => $storagepath
		]);
    }
/*Task #9364 Please use the manuscript number as the file name when downloading the manuscript PDF */
		$condition_array=array("art_id"=>$article_id);
		$article_info=Articles::get_single_record_with_bind_cond('art_code',$condition_array);
       $file_name= isset($article_info->art_code) ? $article_info->art_code : $new_pdf_filename;
/*Task #9364 End */
		if (file_exists($temp_join_file_path . $new_pdf_filename . '.pdf'))
		{
		/*Task #9364 Please use the manuscript number as the file name when downloading the manuscript PDF */
			copy($temp_join_file_path . $new_pdf_filename . '.pdf', $temp_join_file_path . "backup-".$new_pdf_filename . '.pdf');
			rename($temp_join_file_path . $new_pdf_filename . '.pdf', $storagepath . $file_name . '.pdf');
		/*Task #9364 End */
		}
        /* TASK #3516 Alerting user about the corrupt files while generating pdf */
		// return file_exists($storagepath . $new_pdf_filename . '.pdf');
		    $return_array['filename']=$new_pdf_filename . '.pdf';
			$return_array['logfilename']=$new_pdf_filename . '.log';
			$return_array['foldername']=$new_pdf_filename;
			$return_array['pdfbuild']=FALSE;
			$return_array['updatepdfname']=$file_name;/*Task #9364 */
    if(file_exists($storagepath . $file_name . '.pdf'))
    {
            $return_array['pdfbuild']=TRUE;
    }
    return $return_array;
    /* End TASK #3516 Alerting user about the corrupt files while generating pdf*/

	}
	catch (\Exception $e) {

		return false;
	   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
	}
	}



/*
Get Couathor name Article Based
*/

public function getcoauthornames($author_array)
{
	$author_name_array=array();
	$auth_usr_names='';
	if(!empty($author_array))
	{
		foreach($author_array as $auth)
		{
			array_push($author_name_array,$auth->usr_first_name." ".$auth->usr_middle_name." ".$auth->usr_last_name);
		}

	}
	if(!empty($author_name_array))
	{
		$auth_usr_names=implode(',', $author_name_array);
	}
    return $auth_usr_names;

}
public function getkeyword($keywordlist){
	$keyword_array=array();
	$keyword_names='';
	if(!empty($keywordlist))
	{
		foreach($keywordlist as $keyword)
		{
			array_push($keyword_array,$keyword->kwd_name);
		}

	}
	if(!empty($keyword_array))
	{
		$keyword_names=implode(',', $keyword_array);
	}
    return $keyword_names;
}
/*
Render Pdf
*/
public function renderpdf(Request $request)
{
	try
	{
		$post_data=$request->all();


	}
	catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
	}

}



public function download_article_attachments(Request $request)
	{
		try{

	     $post_data=$request->all();
		 $current_user=$this->get_current_user_details();
		parse_str($this->decrypt_data($post_data['select']), $_GET);

		//$article_id =$_GET['article_id'] ;
		//$file_id = $_GET['file'];
		//$type = $_GET['type']; //for generic form files = generic,  for attachment files == attachment //for supplementary files == supplementary
		//$view_type = $_GET['view'];
		$jnl_code=$post_data['jnlcode'];
		//$art_flow_id=$_GET['aflw_id'];

	//	$path = $this->input->get('path');
	    $download_attachment=$this->get_attachment_data($_GET,$jnl_code,$current_user);
		return $this->success('Success', 200, $download_attachment);
	}

	catch (\Exception $e) {

		return  $this->failure('Failed',500,$e);
	   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
	}
	}

	public function download_file_docs(Request $request)
	{
		try{
			$post_data=$request->all();
			$current_user=$this->get_current_user_details();
			$array['article_id']=$post_data['article_id'] ;
			$array['file'] =$post_data['file'];
			$array['type'] =$post_data['type']; //for generic form files = generic,  for attachment files == attachment //for supplementary files == supplementary
			$array['view'] =$post_data['view'];
			$jnl_code=$post_data['jnlcode'];
		//	$path = $this->input->get('path');
		$downloaddata=$this->get_attachment_data($array,$jnl_code,$current_user);
		$headers = [
			'Content-Type: text/xml',
		];
		$filepath=$this->upload_folder_path("uploads/".$downloaddata['downloadpath']);
		return Response::download($filepath);

		}
		catch (\Exception $e) {

			return  $this->failure('Failed',500,$e);
		   // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
		}
	}
	public function download_attach_file($file_data)
	{
		 try{
			$post_data = json_decode($file_data);
			if(isset($post_data))
			{
				$array['article_id']=$this->decrypt_data($post_data->article_id);
				$array['file'] =$this->decrypt_data($post_data->file);
				$array['type'] =$post_data->type; //for generic form files = generic,  for attachment files == attachment //for supplementary files == supplementary
				$array['view'] =$post_data->view;
				if(isset($post_data->adhocpath))
				{
					$array['adhoc_path'] = $this->decrypt_data($post_data->adhocpath);
				}
				else
				{
					$array['adhoc_path']='';
				}

				if(isset($post_data->aflow_id))
				{
					$array['aflw_id'] = $this->decrypt_data($post_data->aflow_id);
				}

				$jnl_code = $this->decrypt_data($post_data->jnlcode);
				$current_user = $this->get_current_user_details();
				$downloaddata = $this->get_attachment_data($array,$jnl_code,$current_user);
				if ($this->current_client->enable_upload_s3_bucket == 'y') {
					return Storage::disk('s3')->get("uploads/".$downloaddata['downloadpath']);
				}
				else
				{
					$filepath = $this->upload_folder_path("uploads/".$downloaddata['downloadpath']);
					if(file_exists($filepath))
					{
						return Response::download($filepath);
					}
					else
					{
						$this->warning('Failed',500,'file not exist');
					}
				}
		 	}
		}
		catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
         public function get_attachment_data($array_data,$jnl_code,$current_user){
			$article_id=isset($array_data['article_id'])?$array_data['article_id']:'';
			$file_id=isset($array_data['file'])?$array_data['file']:'';
			$type=isset($array_data['type'])?$array_data['type']:'';
			$view_type=isset($array_data['view'])?$array_data['view']:'';
			$path=isset($array_data['path'])?$array_data['path']:'';
			$adhoc_path=isset($array_data['adhocpath'])?$array_data['adhocpath']:'';
			if(empty($adhoc_path)){
				$adhoc_path=isset($array_data['adhoc_path'])?$array_data['adhoc_path']:'';
			}
			// $file_id=$array_data['file'];
			// $type=$array_data['type'];
			// $view_type=$array_data['view'];
			$privileged_user = $this->has_journal_privilege($jnl_code,$current_user['user_id']);

			if ($article_id != '' && $file_id != '' && $type != ''  /* && $privileged_user == TRUE */)
			{

				$article_details = Articles::get_single_record('art_article_upload_path',"art_id={$article_id}");
				$path_label = '';
				$suppl_path = '';//for supplementary files
				$file_path='';
				if ($type == 'generic')
				{

					$file_data = Generic_form_files::get_single_record('agf_name as file_name',"agf_id={$file_id}");
				}
				elseif ($type == 'supplementary')
				{

					$suppl_path = 'supplementary_files/';
					$file_data = Article_supplementary_files::get_single_record('asup_file_name as file_name',"asup_id={$file_id}");
				}
				elseif ($type == 'email_attachment'||$type == 'adhoc_email_attachment' || $type == 'reply_mail') // Task #206 , Reply-mail file-path issue fix
				{

					$file_data = Email_attachments::get_single_record('emat_file_name as file_name',"emat_id={$file_id}");

				}
				//#1954 Author designated file attach publish complete stage code Start
				elseif($type=='production_file')
				{

					$file_data = Production_attachment_files::get_single_record('paf_file_name as file_name',"paf_id={$file_id}");


				}
				//#1954 Author designated file attach publish complete stage code Start
				elseif($type=='generic_form_file')
				{
					$file_data = Generic_form_files::get_single_record('agf_name as file_name',"agf_id={$file_id}");
				}
				//attachments on resend/forward mails
				elseif($type=="resend_forward_mail"){
					$file_data = Resent_forward_emails_attachments::get_single_record('rfa_file_name as file_name', "rfa_id={$file_id}");
				}
				//#1954 Author designated file attach publish complete stage code end.
				elseif($type=="copyright_signed_attachment"){
					$Copyright  =   new \App\Models\Copyright();
					$file_data = $Copyright::get_single_record('copy_att_name as file_name,copy_location', "crt_id={$file_id}");
				}elseif($type=='generic_metadata_form_file'){
					$file_data = Generic_form_files::get_single_record('agf_name as file_name,agf_original_upload_path',"agf_id={$file_id}");
				}
				else
				{
					$path_label='Attachment_files';
					$file_data = Attachment_files::get_single_record('atmnt_orginal_upload_path,atmnt_file_name as file_name',"atmnt_id={$file_id}");
				}



				$folder_path = $type!='generic_metadata_form_file'?$article_details->art_article_upload_path:'';
				$return_array['file_name']=$file_data->file_name;
				if ($type == 'email_attachment' || $type == 'resend_forward_mail')
				{
					$file_path = 'email_attachments/' . $article_id . '/' . $file_data->file_name;
				}
				// Task #206 , Reply-mail file-path issue fix
				elseif(($type == 'adhoc_email_attachment' || $type == 'reply_mail')&&$adhoc_path!='')
				{
					if($type == 'reply_mail'){
						$file_path = (substr($adhoc_path, -1) === '/') ? ($adhoc_path . $file_data->file_name) : ($adhoc_path .'/'. $file_data->file_name) ;
					}else{
						$file_path = $adhoc_path . $file_data->file_name;
					}
				}
				//#1954 Author designated file attach publish complete stage Start
				elseif($type=='production_file')
				{

					if(isset($array_data['aflw_id']))
						$flow_id=$array_data['aflw_id'];
					else
					$flow_id='';

					$file_path = $folder_path  . '/production/'. $flow_id.'/'. $file_data->file_name;

				}
				//#1954 Author designated file attach publish complete stage code end
				elseif($type=="copyright_signed_attachment"){
					$folder_path = str_replace('uploads/', "", $file_data->copy_location);
					
					$file_path =  $folder_path.$file_data->file_name;
				}elseif($type=='generic_metadata_form_file'){
					$folder_path = $file_data->agf_original_upload_path;
					$file_path =  $folder_path.$file_data->file_name;
				}
				else
				{
					//Upgrade #2293 Manage review uploads
					if($path_label == 'Attachment_files')
					{
						$folder_path = $file_data->atmnt_orginal_upload_path;
					}

					$file_path =  $folder_path . '/' . $suppl_path.$file_data->file_name;
				}
				
				$filepathfolder=$this->get_upload_data($file_path);
				$return_array['file_path']=$filepathfolder;
				$temp_arr = explode('.', $file_data->file_name);
				$file_type = strtolower(end($temp_arr));
				 $return_array['view_type']='';
				if ($file_type == 'pdf' && $view_type != 'download')
				{
					$return_array['view_type']='pdf';
				//	$this->render_pdf('attachment_pdf', encrypt_link(base_url() . $file_path));
				}
				elseif ($view_type == 'true')
				{
					$return_array['view_type']='image';
					//$this->load->view('generic_templates/image_view', array(
					//	'file' => base_url() . $file_path
					//));
				}
				else
				{

					$return_array['view_type']='download';

					$return_array['downloadpath']=$file_path;


					//$this->download_file($file_path, $file_type);
				}

				return $return_array;
			} elseif(isset($path) && $path != ''){
				$romovedpath=trim($path, "uploads/");
				$filepathfolder=$this->get_upload_data($romovedpath);
				$return_array['file_path']=$filepathfolder;
				$temp_arr = explode('.', $path);
				$file_type = strtolower(end($temp_arr));
				$return_array['view_type']='';
				if ($file_type == 'pdf') {
					$return_array['view_type']='pdf';
				} elseif ($view_type == true) {
					$return_array['view_type']='image';
				} else {
					$return_array['view_type']='download';
					$return_array['downloadpath']=$file_path;
				}
				return $return_array;
			}


		



		 }

	public function render_pdf(Request $request) {
		try {
			$post_data=$request->all();
			$return_array=array();
			$article_id =$this->decrypt_data($post_data['article_id']);
			$pdf_id = $this->decrypt_data($post_data['pdf_id']);
			$type = $post_data['type'];
			$Articles = new \App\Models\Articles();
			$Article_pdf = new \App\Models\Article_pdf();
			$articleData = $Articles::get_single_record("art_article_upload_path","art_id={$article_id}");
			$pdf_detail = $Article_pdf::get_single_record('pdf_name', "pdf_id={$pdf_id}");
			$file_path = $articleData->art_article_upload_path . "/" . $pdf_detail->pdf_name;
			$filepathfolder=$this->get_upload_data($file_path);
			$return_array['file_path']=$filepathfolder;
			$return_array['view_type']='pdf';
			$return_array['file_name']=$pdf_detail->pdf_name;
			return $this->success('Success', 200, $return_array);
		}
		catch (\Exception $e) {

			return  $this->failure('Failed',500,$e);
		}
	}

/* TASK #3516 Alerting user about the corrupt files while generating pdf */
	public function get_failed_error_log($log_file_path)
{
        try
        {
            $tex_error_messages=array();
            if(file_exists($log_file_path))
            {
                $log_file = fopen($log_file_path,'r');
                $log_details = fread($log_file, filesize($log_file_path));
                fclose($log_file);
                preg_match_all('/(\! LaTeX Error\:.*\n)|(LaTeX Warning\:.*\n)/', $log_details, $matches);
                if ($matches != NULL && is_array($matches))
                {
                    $error_msgs = $matches[0];
                    foreach ($error_msgs as $err_msg)
                    {
                        $tex_error_messages[] = '<span>' . str_replace('\! La', 'La', $err_msg) . '</span><br>';
                    }
                }
            }
                return $tex_error_messages;
            }
            catch (\Exception $e) {

                return  false;
        }
}

public function write_tex_error($path,$data,$filename){
    try
    {
        $return_tex_status=array();
        $logname=$filename.date("dmY", time()) . ".log";
        $log_file = $path .$logname;

        $log_folder_name=rtrim($logname,'.log');
        if (!file_exists($log_folder_name)) {
            mkdir($log_folder_name, 0755, true);
        }
        $log_origin_path=$path.$log_folder_name.'/'.$logname;

        $handle = fopen($log_origin_path, "a+");
        fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $data . "\r\n\r\n\r\n");
        fclose($handle);
        $return_tex_status['log_file_status']=FALSE;
        if (file_exists($log_folder_name))
        {
            $return_tex_status['log_file_name']=$logname;
            $return_tex_status['log_file_status']=TRUE;
            $return_tex_status['log_file_path']=$log_file;

        }
        return $return_tex_status;
    }
    catch (\Exception $e) {

        return  false;
    }

}
/* End TASK #3516 */

	public function download_documents(Request $request){
		$encrypted = $request->query('payload');
		try{
			$payload = (array) json_decode(Rv_decrypt($encrypted));
			if(is_array($payload) && !empty($payload)){
				$article_details = Articles::get_single_record('art_article_upload_path',"art_id={$payload['article_id']}");
				$file_location = storage_path('/app/public/uploads/') . $article_details->art_article_upload_path . '/' . $payload['file_name'] ;
				// print_r($file_location);die;
				if (!file_exists($file_location)) {
					abort(404, 'File not found.');
				}
			}
			return response()->download(($file_location));
		} catch (\Exception $e) {
            return response()->json(['error' => 'Invalid or corrupted data.'], 400);
        }
	}
}







