<?php
//
namespace App\Http\Controllers\Platform;

use App\Http\Controllers\Controller;
use App\Http\Traits\IthenticateTrait;
use Illuminate\Http\Request;
use App\Models\Journals;
use App\Models\Journal_settings;
use App\Models\Generic_flows;
use App\Models\Generic_forms;
use App\Models\Advance_flow_movement;
use App\Models\Article_generic_form_data;
use App\Models\Flow_master;
use App\Models\Journal_permission_master;
use App\Models\Journal_permission;
use App\Models\Roles;
use App\Models\User;
use App\Models\Assign_permission;
use App\Models\Journal_terms;
use App\Models\Terms;
use App\Models\Copyright_master;
use App\Models\Api_credentials;
use App\Models\File_upload_type;
use App\Models\Attachment_file_description;
use App\Models\Article_type_advance_options;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\Articles;
use App\Models\Ftp;
use App\Models\Generic_form_groups;
use App\Models\Stage_email_templates;
use App\Models\User_journal_classifications;
use App\Models\Required_file_type;
use App\Http\Traits\PlatformTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Models\Classifications;
use App\Models\Article_classification;
use App\Models\Keywords;
use App\Models\Keyword_relationship;
use App\Models\Keyword_category;
use App\Models\Generic_form_elements;
use App\Models\Excluded_journal_keywords;
use App\Models\Stage_email_tmpl_reference;
use App\Http\Traits\KeywordTrait;
use App\Models\Temp_classification_import;
use App\Models\User_classification;
use App\Models\General_permission;
use Config;
use DateTime;
use DB;
use Exception;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Pagination\Paginator;
use JWTAuth;
use JWTAuthException;
use stdClass;
use Image;
use Mockery\Undefined;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Ods;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Response;
use App\Models\Event_invited_users;
use App\Consts;
use App\Http\Controllers\Manage_Generic_Form_Api;
use App\Http\Traits\ViewarticleTrait;
class Manage_Platform_Api extends Controller
{
	use PlatformTrait;
	use UtilityTrait;
	use RolesConfigTrait;
	use KeywordTrait;
	use IthenticateTrait;
	use ViewarticleTrait;
	public $currentuser;
	//
	/*
    get all platform
    commited date :-  13-03-2022
    Request type :- GET
    */
	public function index(Request $request)
	{

		try {
			$return_data=array();
			$filter_data = $request->all();
			$post_data = $filter_data['paramsdet'];
			$this->currentuser = $this->get_current_user_details();
			$select = '*';
			$sort_field = '';
			$sort_field = isset($filter_data ['sort_field']) ? $filter_data ['sort_field'] : 'jnl_id';
			$sort_order = isset($filter_data ['sort_order']) ? $filter_data ['sort_order'] : 'asc';
			$limit = isset($filter_data ['per_page']) ? $filter_data ['per_page'] : 10;
			$jnl_category = Journals::get_all_records('jnl_journal_type', array(), null, null, '', null, 'jnl_journal_type');
			$filterjounal = $this->PlatformConfigdata('filterjounal');
			$condition = '';
			if (!empty($post_data)) {

				if (isset($post_data['jnl_code']) && $post_data['jnl_code'] != null) {
					$condition = 'LOWER(jnl_journal_code) LIKE LOWER("%' . $post_data['jnl_code'] . '%")';
				}
				if (isset($post_data['jnl_name']) && $post_data['jnl_name'] != null) {
					($condition != null) ? $condition .= ' AND ' : '';
					$condition .= 'LOWER(jnl_journal_name) LIKE LOWER("%' . $post_data['jnl_name'] . '%")';
				}
				if (isset($post_data['category']) && $post_data['category'] != null) {
					($condition != null) ? $condition .= ' AND ' : '';
					$condition .= 'jnl_journal_type ="' . $post_data['category'] . '"';
				}
				if (isset($post_data['jounalfilter']) && $post_data['jounalfilter'] != null && $post_data['jounalfilter'] != 'all') {
					($condition != null) ? $condition .= ' AND ' : '';
					$option = $post_data['jounalfilter'];
					if ($this->current_client->modules->mdl_review_for_doc == 'n') {
						// journals filter with article submission granted and stopped in both normal and standalone
						switch ($option) {
							case 'normal':
								$condition .= 'jnl_standalone ="n"';
								break;
							case 'normal-active':
								$condition .= 'jnl_standalone ="n" AND jnl_journal_status ="y"';
								break;
							case 'normal-archive':
								$condition .= 'jnl_standalone ="n" AND jnl_journal_status ="n"';
								break;
							case 'standalone':
								$condition .= 'jnl_standalone ="y"';
								break;
							case 'standalone-active':
								$condition .= 'jnl_standalone ="y" AND jnl_journal_status ="y"';
								break;
							case 'standalone-archive':
								$condition .= 'jnl_standalone ="y" AND jnl_journal_status ="n"';
								break;
							case 'normal-granted-submission':
								$condition .= 'jnl_standalone ="n" AND jnl_article_submission_status ="y"';
								break;
							case 'standalone-granted-submission':
								$condition .= 'jnl_standalone ="y" AND jnl_article_submission_status ="y"';
								break;
							case 'normal-stopped-submission':
								$condition .= 'jnl_standalone ="n" AND jnl_article_submission_status ="n"';
								break;
							case 'standalone-stopped-submission':
								$condition .= 'jnl_standalone ="y" AND jnl_article_submission_status ="n"';
								break;
						}
					} else {
						$standalone_review_doc_condition = TRUE;
						switch ($option) {
							case 'normal':
								$condition .= 'jnl_standalone ="n"';
								break;
							case 'normal-active':
								$condition .= 'jnl_standalone ="n" AND jnl_journal_status ="y"';
								break;
							case 'normal-archive':
								$condition .= 'jnl_standalone ="n" AND jnl_journal_status ="n"';
								break;
							case 'normal-granted-submission':
								$condition .= 'jnl_standalone ="n" AND jnl_article_submission_status ="y"';
								break;
							case 'standalone-granted-submission':
								$condition .= 'jnl_standalone ="y" AND jnl_article_submission_status ="y"';
								break;
							case 'normal-stopped-submission':
								$condition .= 'jnl_standalone ="n" AND jnl_article_submission_status ="n"';
								break;
							case 'standalone-stopped-submission':
								$condition .= 'jnl_standalone ="y" AND jnl_article_submission_status ="n"';
								break;
						}
					}
				}
			}

			if ($this->current_client->modules->mdl_review_for_doc == 'y' && $standalone_review_doc_condition == FALSE) {
				if ($condition == '') {
					$condition .= 'jnl_standalone ="n" ';
				} else {
					$condition .= ' AND jnl_standalone ="n" ';
				}
			}

			$jounallist = Journals::get_paginated_records($select, $condition, $sort_field, $sort_order, $limit);
            $check_access=$this->check_admin_access("journals",$this->currentuser['roles']);
			foreach ($jounallist as $key => $jrnl) {
				// show manage article type if super admin or sudo and check journal completely configured with a valid workflow
				$proper_flow = $this->validate_journal($jrnl->jnl_fwm_id, $jrnl->jnl_id);

				if (!empty($this->currentuser['roles']) && in_array('super_admin', $this->currentuser['roles']) || in_array('sudo', $this->currentuser['roles']) || $check_access==TRUE) {

					if ($proper_flow['status'] == true) {
						$jounallist[$key]->validjournal = 'true';
					} else {
						$jounallist[$key]->validjournal = 'false';
						$jounallist[$key]->errormsg = $proper_flow['err_msg'][0];
					}
				}
			$jounallist[$key]->edit_permission_article_submission = '';
            $jounallist[$key]->view_permission_article_submission = '';
            if (isset($this->current_client->functionality->cfty_enable_stop_submission_in_journal) && $this->current_client->functionality->cfty_enable_stop_submission_in_journal == "y")
            {
                //change start/stop icon and denote super admin the journal start/stop status in text format
                if (in_array('sudo', $this->currentuser['roles'])) {
                    $jounallist[$key]->edit_permission_article_submission = 'true';
                    $jounallist[$key]->view_permission_article_submission = 'false';

                } else {
                    $jounallist[$key]->edit_permission_article_submission = 'false';
                    $jounallist[$key]->view_permission_article_submission = 'true';

                }
            }
			}
			$return_data['platformlist']=$jounallist;
			$return_data['categorylist']=$jnl_category;
			$return_data['platform_types']=$filterjounal;

			return $this->success(customTrans('platform_settings.list-records'),200,$return_data);
		}
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }

	}
	public function save_api_credentials(Request $request)
	{
		try
		{
			DB::beginTransaction();
			$result = array(
				'status' => 'failed',
				'message' => 'API Credential saving failed');
			$api_details = $request->all();
			$this->currentuser = $this->get_current_user_details();

			/// Task #925 research intgerity configuration save/update
			if($api_details['api_name'] == 'research_integrity')
			{
				$user_name = $api_details['rvri_api_url'];
				$key = $api_details['rvri_api_key'];
				$jnl_id = $api_details['jnl_id_research_integrity'] != '' ? $api_details['jnl_id_research_integrity'] : null;
				$artp_id = $api_details['artp_id'] != '' ? decrypt_link($api_details['artp_id']) : null;
				$api_name = $api_details['api_name'];
				$operation = $api_details['operation'];
				$client_id = $this->current_client->clnt_id;
				$api_config_data = array(
					'acrd_clnt_id' => $client_id,
					'acrd_api_name' => $api_name,
					'acrd_user_name' => $user_name,
					'acrd_key' => $key,
					'acrd_artp_id' => $artp_id,
					'acrd_jnl_id' => $jnl_id
				);
				if ($operation == 'add')
				{
					Api_credentials::insert_record($api_config_data, $this->currentuser);
					$result = array(
						'status' => 'success',
						'message' => 'Research Integrity API added successfully');
					}
				else
				{
					$condition = array(
									'acrd_clnt_id' => $client_id,
									'acrd_api_name' => $api_name,
									'acrd_artp_id' => $artp_id,
									'acrd_jnl_id' => $jnl_id
								);
					Api_credentials::update_record($api_config_data, $condition, $this->currentuser);
					$result = array(
								'status' => 'success',
								'message' => 'Research Integrity API updated successfully'
							);
				}
				if ($result['status'] == 'success')
				{
					if ($artp_id == null && $jnl_id != null)
					{
						$column_prefix = 'jset_';
						$condition = array(
							'jset_jnl_id' => $jnl_id);
							Journal_settings::update_record(array($column_prefix.'research_integrity' => 'y'), $condition, $this->currentuser);
					}else{
						$column_prefix = 'atotp_';
						$condition = array(
						'atotp_artp_id' => $artp_id);
						Article_type_advance_options::update_record(array($column_prefix.'research_integrity' => 'y'), $condition, $this->currentuser);
					}
				}
			}
			else {
			$user_name = $api_details['ithenticate_username'];
			$password = encrypt_link($api_details['ithenticate_password']);
			$jnl_id = $api_details['jnl_id_ithenticate'] != '' ? $api_details['jnl_id_ithenticate'] : null;
			$artp_id = $api_details['artp_id'] != '' ? decrypt_link($api_details['artp_id']) : null;
			$api_name = $api_details['api_name'] != '' ? $api_details['api_name'] : 'Ithenticate';
			$operation = $api_details['operation'];
			$client_id = $this->current_client->clnt_id;
			$api_config_data = array(
				'acrd_clnt_id' => $client_id,
				'acrd_api_name' => $api_name,
				'acrd_user_name' => $user_name,
				'acrd_password' => $password,
				'acrd_artp_id' => $artp_id,
				'acrd_jnl_id' => $jnl_id
			);

			$ithv2_flag = false;
			$ithData = array();
			if(isset($this->current_client->functionality->cfty_ithenticate_v2) &&  isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
			{
				$ithv2_flag = true;
				$ithData = array(
					'username' => $user_name,
					'pass' => $api_details['ithenticate_password']
				);

				if(isset($api_details['ithv2_viewsettings']))
					$api_config_data['acrd_ith_v2_view_settings'] = json_encode($api_details['ithv2_viewsettings']);
				if(isset($api_details['ithv2_add_to_index']))
					$api_config_data['acrd_ith_v2_add_to_index'] = json_encode($api_details['ithv2_add_to_index']);
				if(isset($api_details['ithv2_save_changes']))
					$api_config_data['acrd_ith_v2_save_changes'] = json_encode($api_details['ithv2_save_changes']);
				
				//Task 7850  iThenticate v2 enhancement
				$api_config_data['acrd_ex_mch_cnt'] = isset($api_details['excsmallmatch_length']) && $api_details['excsmallmatch_length']!=""?$api_details['excsmallmatch_length']:8;
				//Task 7850 ithenticate v2 enhancement
				if(!isset($api_details['eula'])){
					$api_config_data['acrd_eula'] = $this->setEULA($ithData);
				}
			}
			if ($operation == 'add')
			{
				Api_credentials::insert_record($api_config_data, $this->currentuser);
			$result = array(
				'status' => 'success',
				'message' => 'API Configuration added successfully');
			}else
			{
				$condition = array(
					'acrd_clnt_id' => $client_id,
					'acrd_api_name' => $api_name,
					'acrd_artp_id' => $artp_id,
					'acrd_jnl_id' => $jnl_id);
				Api_credentials::update_record($api_config_data, $condition, $this->currentuser);
				$result = array(
					'status' => 'success',
					'message' => 'API Configuration updated successfully');
			}
			if ($result['status'] == 'success')
			{
				if ($artp_id == null && $jnl_id != null)
				{
					$column_prefix = 'jset_';
					$condition = array(
						'jset_jnl_id' => $jnl_id);
						Journal_settings::update_record(array($column_prefix.'plagiarism_checking' => 'y'), $condition, $this->currentuser);
				}else{
					$column_prefix = 'atotp_';
					$condition = array(
					'atotp_artp_id' => $artp_id);
					Article_type_advance_options::update_record(array($column_prefix.'plagiarism_checking' => 'y'), $condition, $this->currentuser);
				}
			}
			}
			DB::commit();
			return $this->success('success',200,$result);

		}catch (\Exception $e) {
			DB::rollback();
            return  $this->failure('Failed',500,$e);
        }

	}
	public function get_ithenticateconfig_setting(Request $request)
	{
		try
		{
			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_code'      => 'required',
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}

			/**
			 * Task 5299 iThenticate V2 feature
			 */
			$ith_v2 = FALSE;
			if(isset($this->current_client->functionality->cfty_ithenticate_v2) && isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
			{
				$ith_v2 = TRUE;
			}

			$this->currentuser = $this->get_current_user_details();
			$jnl_code = $post_data['jnl_code'];
			$criteria = "jnl_journal_code='{$jnl_code}'";
			$platform_data = Journals::get_single_record('*', $criteria);
			$returndata['jnl_id']=$platform_data->jnl_id;
			$returndata['ith_v2'] = $ith_v2;
			$edit_record = isset($post_data['edit_record']) ? $this->decrypt_data($post_data['edit_record']) : '';
			if ($edit_record != '') {
				$ithenticate_api_config = NULL;
				if ($this->current_client->modules->mdl_ithenticate == 'y') {
					$ith_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'ithenticate', 'acrd_artp_id' => $edit_record, 'acrd_jnl_id' =>$platform_data->jnl_id);
				   $ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
					if ($ithenticate_api_config == NULL) {
					   $ith_api_condition['acrd_artp_id'] = NULL;
						$ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
						if ($ithenticate_api_config == NULL) {
						   $ith_api_condition['acrd_jnl_id'] = NULL;
						   $ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
					   }
					}
			   }
				// $returndata['form_data']['ithenticate_api_config'] = $ithenticate_api_config;

			}else{
				$ithenticate_api_config = NULL;
				if ($this->current_client->modules->mdl_ithenticate == 'y') {
					$ith_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'ithenticate', 'acrd_artp_id' => NULL, 'acrd_jnl_id' =>$platform_data->jnl_id);
					$ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
					if ($ithenticate_api_config == NULL) {
						$ith_api_condition['acrd_jnl_id'] = NULL;
						$ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
					}
				}
				//$returndata['form_data']['ithenticate_api_config'] = $ithenticate_api_config;
			}
			if(isset($this->current_client->functionality->cfty_ithenticate_v2) && isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
			{
				$ithenticate_api_config = $this->getIthV2SettVal($ithenticate_api_config);
			}
			$returndata['form_data']['ithenticate_api_config'] = $ithenticate_api_config;
			return $this->success('success',200,$returndata);
		}
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
	}
	public function get_basic_platform_setting(Request $request)
	{
		//data in article type tabs
		try
		{
			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_code'      => 'required',
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}
			$jnl_code = $post_data['jnl_code'];
			// TASK #7259 sql injection basicsettings
			if(isset($jnl_code) && !empty($jnl_code)){
				$jnlcodevalid = $this->validatecode(array('jnl_code'=>$jnl_code));
				if($jnlcodevalid['jnl_code'] != TRUE){
					return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
				}
			}
			if(isset($post_data['edit_record']) && !empty($post_data['edit_record'])){
				$editrecordarray = array('input' =>$post_data['edit_record'],'type'=> 'number','enc_data'=> TRUE);
				$editrecordvalidation =  $this->Rv_validator($editrecordarray);
				if($editrecordvalidation != TRUE){
					return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
				}
			}
			// end TASK #7259 sql injection basicsettings
			$edit_record = isset($post_data['edit_record']) ? $this->decrypt_data($post_data['edit_record']) : '';
			$this->currentuser = $this->get_current_user_details();
			$criteria = "jnl_journal_code='{$jnl_code}'";
			$platform_data = Journals::get_single_record('*', $criteria);

			$condition = "jset_jnl_id={$platform_data->jnl_id}";
			$jnl_data =Journal_settings::get_single_record('*',$condition);
			$returndata['form_data']['journal'] = $jnl_data;
			$returndata['art_submission_type'] = $jnl_data->jset_login_user_type;
			$returndata['EPA_text'] ='';
			/* end --- get the journal code from the url, validate the same */

			//Task #4768 Article types use journal workflow
			$show_create_flow_btn = false;
			$show_export_flow_btn = false;
			$show_import_flow_btn = true;
			if (isset($jnl_data->jset_date_format))
			{
			$jnl_date_format = $this->date_format_map($jnl_data->jset_date_format);
			}
			if (isset($platform_data->jnl_logo) && $platform_data->jnl_logo != '')
			{
				$jnl_image = $this->get_upload_data($jnl_code . '/' . $platform_data->jnl_logo);
				//$jnl_image = $this->get_upload_path('uploads/'.$jnl_code . '/' . $platform_data->jnl_logo);
				$exists=false;
				$path = $this->get_upload_path('uploads/' . $jnl_code . '/');
				$filePath = '';
				$filePath = $this->get_upload_path('uploads/' . $jnl_code . '/' . $platform_data->jnl_logo);
				if($filePath != '' && $this->current_client->enable_upload_s3_bucket == 'y'){
					$headers = get_headers($filePath);
					//$exists = strpos($headers[0], '200 OK') !== false;				
					$exists = storage::disk('s3')->exists('uploads/' . $jnl_code . '/' . $platform_data->jnl_logo);
				   }else{
					   $exists = $this->file_exist_folder($path,$platform_data->jnl_logo);
				   }
				$upload_path = ($exists) ? $jnl_image : '';
				$platform_data->jnl_logo=$upload_path;

			}
			$returndata['condition_disable_issue'] = FALSE;
			if ($edit_record != '') {
					$articletype_condition = "artp_id={$edit_record}";
					$article_record = Article_types::get_single_record('*,DATE_FORMAT(artp_start_date, "' . $jnl_date_format . '") as start_date,DATE_FORMAT(artp_soft_enddate, "' . $jnl_date_format . '") as soft_enddate,DATE_FORMAT(artp_hard_enddate, "' . $jnl_date_format . '") as hard_enddate,DATE_FORMAT(artp_production_deadline, "' . $jnl_date_format . '") as production_deadline', $articletype_condition);
					$platform_data->articleInfo = $article_record;
					$articletype_exist_condition = "art_artp_id={$edit_record}";
				$article_exist = Articles::get_single_record('count(art_id) as cnt',$articletype_exist_condition);
				if (!empty($article_record)) {
					$where_stg = "jwf_fwm_id = ".$article_record->artp_fwm_id ." and jwf_stage_type ='production'";

					if(isset($this->current_client->mdl_production) && $this->current_client->mdl_production == 'y')
					{
						$where_stg = "jwf_fwm_id = ".$article_record->artp_fwm_id ." and jwf_stage_type ='publish'";
					}
					$perfect_flow = Generic_flows::get_single_record('count(jwf_id) as cnt',$where_stg);
					if($perfect_flow->cnt > 0)
					{
						$show_export_flow_btn = TRUE;
					}
					if(!empty($article_record->artp_parent_artp_id))
					{
						$viewable_parentid=explode(',',$article_record->artp_parent_artp_id);
						$parentlist=array();
						foreach($viewable_parentid as $parentid) {
							$parentlist[]= $parentid;
						}
						$article_record->artp_parent_artp_id=$parentlist;
					}
					$returndata['form_data']['article_info'] = $article_record;
					$returndata['art_submission_type'] = $article_record->artp_login_user_type;
					$returndata['master_flow'] = $article_record->artp_fwm_id;
					//Task #4768 Article types use journal workflow
					if ($article_record->artp_fwm_id == $platform_data->jnl_fwm_id)
					{
						$show_import_flow_btn = FALSE;
						if($article_exist->cnt == 0)
							$show_create_flow_btn = TRUE;
					}
				}
				$returndata['article_exits'] = false;
				$articletype_count_condition = "art_artp_id={$edit_record} AND art_delete_status!='y'";
				$article_counts = Articles::get_single_record('count(art_id) as cnt',$articletype_count_condition);
				if($article_counts->cnt > 0)
				{
					$returndata['condition_disable_issue'] = TRUE;
					$returndata['article_exits'] = true;
				}

				//Tab: advance settings
				$conAdvOption="atotp_artp_id ='".$edit_record."'";
				$articletype_adv_options = Article_type_advance_options::get_single_record('*',$conAdvOption);
				/*TASK #7897 When an article type is opened in a tab and then deleted from the list of article types, 500 error occurs and persists even after a refresh.*/
				$return_art_type_not_found['art_type_not_found']=false;
				if(empty($articletype_adv_options)){
					$return_art_type_not_found = ['art_type_not_found' => true];
					return $this->warning('Warnings',200,$return_art_type_not_found);
				}
				/* end TASK #7897 When an article type is opened in a tab and then deleted from the list of article types, 500 error occurs and persists even after a refresh.*/
				$ith_view_settings = $ith_index_settings = $ith_save_changes = array();
				$ith_v2 = FALSE;
				if(isset($this->current_client->functionality->cfty_ithenticate_v2) && isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
				{
					$ith_v2 = TRUE;
					$ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
					$ithenticateconfig  = Config::get($ithenticate_config);
					$data_view_settings = $data_index_settings = $data_save_changes = array();
					if(isset($articletype_adv_options->atotp_ith_v2_view_settings) && $articletype_adv_options->atotp_ith_v2_view_settings != NULL)
					{
						$data_view_settings = json_decode($articletype_adv_options->atotp_ith_v2_view_settings);
					}
					if(isset($articletype_adv_options->atotp_ith_v2_add_to_index) && $articletype_adv_options->atotp_ith_v2_add_to_index != NULL)
					{
						$data_index_settings = json_decode($articletype_adv_options->atotp_ith_v2_add_to_index);
					}
					if(isset($articletype_adv_options->atotp_ith_v2_save_changes) && $articletype_adv_options->atotp_ith_v2_save_changes != NULL)
					{
						$data_save_changes = json_decode($articletype_adv_options->atotp_ith_v2_save_changes);
					}
					if(isset($ithenticateconfig['ithenticate_v2']['view_settings']))
					{
						foreach($ithenticateconfig['ithenticate_v2']['view_settings'] as $key=>$val)
						{
							if(isset($data_view_settings->$key))
							{
								$val['value'] = $data_view_settings->$key;
							}
							$ith_view_settings[] = array(
								'key'=>$key,
								'label'=>$val['label'],
								'value'=>$val['value']
							);
						}
					}
					if(isset($ithenticateconfig['ithenticate_v2']['indexing_settings']))
						{
							foreach($ithenticateconfig['ithenticate_v2']['indexing_settings'] as $key=>$val)
							{
								if(isset($data_index_settings->$key))
								{
									$val['value'] = $data_index_settings->$key;
								}
								$ith_index_settings[] = array(
									'key'=>$key,
									'label'=>$val['label'],
									'value'=>$val['value']
								);
							}
						}

						if(isset($ithenticateconfig['ithenticate_v2']['similarity_view_settings']))
						{
							foreach($ithenticateconfig['ithenticate_v2']['similarity_view_settings'] as $key=>$val)
							{
								if(isset($data_save_changes->$key))
								{
									$val['value'] = $data_save_changes->$key;
								}
								$ith_save_changes[] = array(
									'key'=>$key,
									'label'=>$val['label'],
									'value'=>$val['value']
								);
							}
						}
				}
				$returndata['ith_v2'] = $ith_v2;
				$params = [];
				if($articletype_adv_options->atotp_review_method == 'c'){
					if($articletype_adv_options->atotp_custom_blind_params){
						foreach(json_decode($articletype_adv_options->atotp_custom_blind_params) as $key => $val){
							$params[] = ['role' => $key, 'selectedOptions' => $val];
						}
					}
				}
				$articletype_adv_options->atotp_custom_blind_params = $params;
				$articletype_adv_options->atotp_ith_v2_view_settings = $ith_view_settings;
				$articletype_adv_options->atotp_ith_v2_add_to_index = $ith_index_settings;
				$articletype_adv_options->atotp_ith_v2_save_changes = $ith_save_changes;
				$returndata['form_data']['general'] = $articletype_adv_options;
				$returndata['form_data']['show_create_flow_btn'] = $show_create_flow_btn;
				$returndata['form_data']['show_import_flow_btn'] = $show_import_flow_btn;
				$returndata['form_data']['show_create_flow_btn_titles'] = customTrans('platform_settings.show_create_flow_btn_titles');
				$returndata['form_data']['show_export_flow_btn'] = $show_export_flow_btn;
				$clnt_mdl_production = $this->current_client->modules->mdl_production;
				if (isset($clnt_mdl_production) && $clnt_mdl_production == 'n') {
					// #4511 enable TrAction file formats for upload
					//$cond='rft_jnl_id = '.$this->jnl_data->jnl_id.' and rft_artp_id ='.$edit_record.' and afdec_apply_stage_type = "r"';
					$cond = 'rft_jnl_id ='.$platform_data->jnl_id.' and rft_artp_id ='.$edit_record.' and FIND_IN_SET("r", afdec_apply_stage_type)';
				} else {
					$cond = 'rft_jnl_id ='.$platform_data->jnl_id.' and rft_artp_id ='.$edit_record;
				}
				$file_description = Required_file_type::get_file_description('rft_file_desp_id,rft_req_count,rft_req_fld,afdec_description,rft_sort_order', $cond);
				$returndata['file_description']=$file_description;
				// $description_html = '';
				$data = array();

				$condtionUsrAssgn="asgm_jnl_id ='{$platform_data->jnl_id}' and asgm_artp_id='{$edit_record}'";
				$returndata['form_data']['user_assg_perm'] = Assign_permission::get_all_records('*', $condtionUsrAssgn);
				/* start --- get data for Add user tab */
				//get author role id.
				$conRole="role_assigned_role='author'";
				$author_role = Roles::get_all_records('role_id',$conRole);
				$returndata['author'] = $author_role[0]->role_id;
				//get associate editor, reviewer ids
				$conClassific="role_assigned_role IN('associate_editor')";
				$classific_role = Roles::get_role_ids($conClassific);
				$returndata['classific_role_data'] = explode(';', $classific_role->role_ids);
				$returndata['jnl_pge_name'] = ' Manage "' . $article_record->artp_article_type . '"';
				$returndata['show_page_title'] = TRUE;

				//Enhancement#2152 Partly import workflow
				$returndata['enable_reset_btn'] = FALSE;
				$manage_roles=$this->convert_string_array( $this->currentuser['roles']);

			} else {
				$returndata['jnl_pge_name'] = 'Manage Article type';
				$returndata['show_page_title'] = TRUE;
				if (isset($jnl_data->active_jnl_tab_id))
				{
					$jnl_data->active_jnl_tab_id = '';
				}
				if (isset($jnl_data->active_artp_tab_id))
				{
					$jnl_data->active_artp_tab_id = '';
				}
			}

			if ($this->current_client->functionality->cfty_jnl_EPA == 'y' && !empty($returndata['form_data']['journal']->jset_editorial_production_assistant))
			{
				$epa_user_id = $returndata['form_data']['journal']->jset_editorial_production_assistant;
				$check_standalne = ' AND usr_jnl_standalone IS NULL';
				if($platform_data->jnl_standalone=='y')
				{
					$check_standalne = ' AND usr_jnl_standalone = ' . $platform_data->jnl_id;
				}
				$epa_condtn = 'usr_id = ' . $epa_user_id . $check_standalne;
				$Users = new \App\Models\User();
				$User_to_journals =  new \App\Models\User_to_journals;
				$epa_name = $Users::get_single_record('CONCAT(usr_first_name,	IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as name', $epa_condtn);
				if (!empty($epa_name->name))
				{
					$epa_roles = $User_to_journals::get_user_roles($epa_user_id, $platform_data->jnl_id, 'j');
					$epa_jnl_role = '';
					if (!empty($epa_roles) && count($epa_roles)>0)
					{
						$epa_jnl_role = ' (' . implode(", ", array_column(json_decode(json_encode($epa_roles), TRUE), 'role_name')) . ')';
					}
					$returndata['EPA_text'] = $epa_name->name . $epa_jnl_role;
				}
			}


			$ithenticate_api_config = NULL;
			 if ($this->current_client->modules->mdl_ithenticate == 'y') {
				if($edit_record!='')
				{
			 	$ith_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'ithenticate', 'acrd_artp_id' => $edit_record, 'acrd_jnl_id' =>$platform_data->jnl_id);
				$ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
			 	if ($ithenticate_api_config == NULL) {
					$ith_api_condition['acrd_artp_id'] = NULL;
			 		$ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
			 		if ($ithenticate_api_config == NULL) {
						$ith_api_condition['acrd_jnl_id'] = NULL;
						$ithenticate_api_config = Api_credentials::get_single_record_with_bind_cond('*', $ith_api_condition);
					}
			 	}
				}
			}
			 $returndata['form_data']['ithenticate_api_config'] = $ithenticate_api_config;
			$conNotes="role_assigned_role <> 'author'";
			$returndata['form_data']['add_notes'] = Roles::get_all_records('role_id, role_name',$conNotes, 'role_name');
			$parent_arttype_condition="artp_special_issue='n' and artp_jnl_id='{$platform_data->jnl_id}'";
			if ($edit_record != '') {
				$parent_arttype_condition .=" and artp_id !='{$edit_record}'";
			}
			$role_table = (new \App\Models\Roles())->getTable();
			$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
			$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
			$non_previleged_user_role = $this->RolesConfigdata('non_privileged_user_roles');
			$non_previleged_role_string = "'" . implode("','", $non_previleged_user_role['non_privileged_user_roles']) . "'";
			$parent_role_arry=[];
			$parent_type = Article_types::get_all_records('artp_id, artp_article_type', $parent_arttype_condition, 'artp_article_type');
			if(!empty($parent_type)) {
                foreach($parent_type as $row) {
                    $parent_role_arry[$row->artp_id]=$row->artp_article_type;
                }
            }
			$returndata['form_data']['parent_article_types'] =$parent_role_arry;
			$criteria = "artp_jnl_id='{$platform_data->jnl_id}'";
			$returndata['form_data']['all_article_type']= Article_types::get_all_records("artp_id,artp_article_type",$criteria);
			$previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
			$allprevroles = Roles::get_records_by_raw_query($previleged_sql);
			$returndata['form_data']['user_roles'] = $allprevroles;

			// $returndata['form_data']['user_roles'] = Roles::get_records_where_in('*', 'role_assigned_role', privileged_user_roles(), '', 'role_name');
			// non privileged user role list for for managing who can view email history

			$non_previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$non_previleged_role_string}) ORDER BY role_name";
			$returndata['form_data']['non_privileged_user_roles'] = Roles::get_records_by_raw_query($non_previleged_sql);
			/*Feature#3884 Add permission to view review PDF for production users in Journal and Article type level */
			$sql_production_roles = "SELECT role_id, role_name, role_assigned_role FROM " . $role_table . " WHERE FIND_IN_SET('p',role_used_in)";
			$returndata['form_data']['production_roles'] = User::get_records_by_raw_query($sql_production_roles);

			//get roles assign based on priority in config
			$assignment_fulldata=[];
			foreach($allprevroles as $keyrole)
			{
				$assignment_fulldata[$keyrole->role_id]=$this->get_all_roles_can_assign($keyrole->role_id);
			}
			$returndata['enable_special_issue'] = $this->current_client->functionality->cfty_enable_issue_inarticletype;
			$returndata['form_data']['assignment_list']=$assignment_fulldata;
			/* Feature #1050 */
			$confirm_credits = 'no';

			//$casrai_module = $this->Modules->get_single_record('mdl_casrai_credit,mdl_orcid');
			$casrai_module = $this->current_client->modules;
			if ($casrai_module->mdl_casrai_credit == 'y') {
				$confirm_credits = 'yes';
			}
			$returndata['confirm_credits'] = $confirm_credits;
			/* Feature #1050 */

			$confirm_orcid = 'no';
			if ($casrai_module->mdl_orcid == 'y') {
				$confirm_orcid = 'yes';
			}
			$client_code = $this->current_client->clnt_client_code;
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$returndata['upload_type'] = File_upload_type::get_all_records();

			//task #672 show back btn (journals list) in article type settings page
			$returndata['show_back_to_journals'] = FALSE;
			if (in_array('super_admin', $this->currentuser['roles']) || in_array('sudo', $this->currentuser['roles'])) {
				$returndata['show_back_to_journals'] = TRUE;
			}
			
			$returndata['check_maindocument_count'] = false;
			if(isset($this->current_client->modules->mdl_es_integration) && $this->current_client->modules->mdl_es_integration == 'y')
			{
				if (isset($clnt_mdl_production) && $clnt_mdl_production == 'n') {
					$cond1=array(
						'rft_jnl_id' => $platform_data->jnl_id,
						'afdec_main_document' => 'y',
						'rft_req_fld' => 'y',
						'rft_artp_id' => $edit_record
					);
					$cond = 'FIND_IN_SET("r", afdec_apply_stage_type)';
					//$cond = 'rft_jnl_id ='.$platform_data->jnl_id.' and afdec_main_document="y" and rft_req_fld="y" and rft_artp_id ='.$edit_record.' and FIND_IN_SET("r", afdec_apply_stage_type)';
				} else {
					$cond1=array(
						'rft_jnl_id' => $platform_data->jnl_id,
						'afdec_main_document' => 'y',
						'rft_req_fld' => 'y',
						'rft_artp_id' => $edit_record
					);
					$cond = '';
					//$cond = 'rft_jnl_id ='.$platform_data->jnl_id.' and afdec_main_document="y" and rft_req_fld="y" and rft_artp_id ='.$edit_record;
				}
				$attach_select = 'afdec_main_document,afdec_id';
				$attach_file_description = Required_file_type::get_file_description($attach_select, $cond1,"{$cond}");
				if (!empty($attach_file_description) && count($attach_file_description)>1)
				{
					$returndata['check_maindocument_count'] = true;
				}
			}

			//CHecking any file description is marked for research integrity
			//If none of the file descriptions is marked, then show a warning msg
			if((isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y'))
			{
				$is_rvri_marked 	=	false;
				$fd_rvri_res = Attachment_file_description::get_all_records('afdec_id', 'afdec_submit_to_rvri = "y"');
				if (!$fd_rvri_res->isEmpty()) {
					$is_rvri_marked 	=	true;
				}

			} else {
				$is_rvri_marked 	=	true;
			}
			$returndata['is_rvri_marked'] = $is_rvri_marked;
			
			//fetch the client's proceeding config array
			$proceedingArr  =   $this->fetch_client_proceeding_config_array('basic-settings');
			$returndata['proceeding_arr'] = $proceedingArr;

			$platform_data->returnData = $returndata;

			return $this->success('success',200,$platform_data);
		}
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
	}
	/*
    get all platform category
    commited date :-  13-03-2022
    Request type :- GET
    */
	public function get_configurations(Request $request)
	{


		try {
			$jnl_category = Journals::get_all_records('jnl_journal_type', array(), NULL, NULL, '', NULL, 'jnl_journal_type');
			$jnl_dateformat_array = $this->Utility('date_format');
			$return_array['date_format'] = $jnl_dateformat_array['date_format'];
			$return_array['categorylist'] = $jnl_category;

			$this->currentuser = $this->get_current_user_details();
			// Task #3563 Collecting Supporting Documents for Conference
			if (isset($this->currentuser['roles']) && (in_array('sudo', $this->currentuser['roles']) || in_array('super_admin', $this->currentuser['roles']) || in_array('admin', $this->currentuser['roles']) )) {
				$condition = "gncf_metadata_status='m'";
				$return_array['metadata_list'] = $this->loadMetadata($condition);
			}


			// Task #3563 Collecting Supporting Documents for Conference
			if (isset($this->currentuser['roles']) && (in_array('sudo', $this->currentuser['roles']) || in_array('super_admin', $this->currentuser['roles']) || in_array('admin', $this->currentuser['roles']) )) {
				$condition = "gncf_metadata_status='s'";
				$return_array['supporting_forms'] = $this->loadMetadata($condition);
			}


			return $this->success('success',200,$return_array);

		}catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
	}
	/*
    get all platform Settings
    commited date :-  13-03-2022
    Request type :- POST
    */
	public function get_platform_permission_settings(Request $request)
	{
	try {
		$post_data = $request->all();
		$return_array['use_journal_permission']=false;
		if ($post_data['jnl_code'] != '')
		{
		$jnl_code = $post_data['jnl_code'];
			$column_prefix = 'jset_';

		$role_table = (new \App\Models\Roles())->getTable();

		$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
		$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
		$previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
			$return_array['user_roles'] = Roles::get_records_by_raw_query($previleged_sql);

		if (isset($jnl_code)) {
			// $criteria = "jnl_journal_code='{$jnl_code}'";
			$criteria = "jnl_journal_code= ?";
			$jounal_data = Journals::get_single_record('*', $criteria,binding_arr:[$jnl_code]);
			$assignmentcondition="asgm_jnl_id={$jounal_data->jnl_id} and `asgm_artp_id` IS NULL";
			$bind_arr = [];
			$perm_id='';
			$return_array['jounal_data'] = $jounal_data;
			if (!isset($post_data['hdn_permission_art_typid']))
			{
		$condition = "jset_jnl_id={$jounal_data->jnl_id}";
		$jounal_settings = Journal_settings::get_single_record('*', $condition);
		$return_array['journal_permission_settings'] = $jounal_settings;
		$perm_id=$jounal_data->jnl_jpm_id;

			}



		if (isset($post_data['hdn_permission_art_typid']))
			{
				$column_prefix = 'atotp_';
				$arttype_id=$this->decrypt_data($post_data['hdn_permission_art_typid']);
				$assignmentcondition="`asgm_jnl_id`='{$jounal_data->jnl_id}' and `asgm_artp_id`= ?";
				$bind_arr = [$arttype_id];
				$arttypecondition = "atotp_artp_id = ?";
				$arttype_permission_settings = Article_type_advance_options::get_single_record('*', $arttypecondition,binding_arr:$bind_arr);
				$return_array['arttype_permission_settings'] = $arttype_permission_settings;
				$condition = "artp_id= ?";
				$artp_data = Article_types::get_single_record("artp_jpm_id", $condition,binding_arr:$bind_arr);
			  if($jounal_data->jnl_jpm_id==$artp_data->artp_jpm_id)
				{
					$return_array['use_journal_permission']=true;
				}
				$perm_id=$artp_data->artp_jpm_id;
			}
			$common_condition = "jp_jpm_id={$perm_id}";
			$common_permission_settings = Journal_permission::get_single_record('*', $common_condition);

			if(!isset($this->current_client->functionality->cfty_edit_form_comment)|| (isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'n'))
			{
				unset($common_permission_settings->jp_edit_article_forms);
			}
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        	$review_flow  = Config::get($workflow_config);//dd(array_column($review_flow, 'prevent_edit'));
			$return_array['prevent_edit_exist'] = in_array(true,array_column($review_flow, 'prevent_edit'),true);

			$return_array['common_permission_settings'] = $common_permission_settings;
		$return_array['column_prefix'] = $column_prefix;
		$return_array['user_assg_perm'] = Assign_permission::get_all_records('*', $assignmentcondition,binding_arr:$bind_arr);

		//fetch the client's proceeding config array
            $proceedingArr  =   $this->fetch_client_proceeding_config_array('who-can-do-what');
            $return_array['proceeding_arr'] = $proceedingArr;
		}
		return $this->success('success',200,$return_array);

	}
	else{
		$return_array['msg'] = customTrans('invalil_code');
		return $this->success('success',200,$return_array);

	}

	} catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}
}


	public function get_users_for_jnl_epa(Request $request)
	{
		try {
			$post_data = $request->all();
			$search_txt =$post_data['user_name'];
			$jnl_id = $post_data['platform_id'];
			$jnl_code = $post_data['jnl_code'];
			$this->currentuser = $this->get_current_user_details();
			$condition = "jnl_id={$jnl_id}";
			$jounal_settings = Journals::get_single_record('jnl_standalone', $condition);
			$is_standalone=$jounal_settings->jnl_standalone;

			$search_data = array();
			$return_arr = array(
				'status' => 'err'
			);
			$Users = new \App\Models\User();
			$User_to_journals =  new \App\Models\User_to_journals;
			if ($search_txt != '' && $jnl_id != '')
			{
				$jnl_user_ids = array();
				$search_db_data = $User_to_journals::get_users_for_jrnal_epa($jnl_id, $search_txt, $is_standalone);
				$count = count($search_db_data); //set search limit - total 200
				$remain_limit = 100;
				if ($count > 0)
				{
					$count -= 1;
					$remain_limit = (100 - $count);
				}
				if(!empty($search_db_data))
				{
					foreach ($search_db_data as $user)
					{
						$jnl_user_ids[] = $user->usr_id;
						$search_data[] = array(
							'id' => $user->usr_id,
							'value' => $user->user . ' (' . $user->roles . ')'
						);
					}
				}
				$exclude_users = '';
				if (!empty($jnl_user_ids))
				$exclude_users = ' AND usr_id NOT IN (' . implode(',', $jnl_user_ids) . ')';
				$get_standalone_usrs = 'usr_jnl_standalone IS NULL';
				if ($is_standalone == 'y')
				$get_standalone_usrs = 'usr_jnl_standalone = ' . $jnl_id;
				$sql = 'SELECT usr_id, CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user FROM rvw_users WHERE ((CONCAT(usr_first_name,IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) LIKE "%' . $search_txt . '%" ) AND (`usr_roles` NOT LIKE "%sudo%" OR `usr_roles` IS NULL) AND ' . $get_standalone_usrs . $exclude_users . ') LIMIT ' . $remain_limit;
				$remaining_users = $Users::get_records_by_raw_query($sql);
				if(!empty($remaining_users))
				{
					foreach ($remaining_users as $user)
					{
					$search_data[] = array(
						'id' => $user->usr_id,
						'value' => $user->user
					);
					}
				}
			$return_arr['status'] = 'success';
			$return_arr['search_data'] = $search_data;
			return $this->success('success',200,$return_arr);
			}
		}catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
	public function get_platform_general_settings(Request $request)
	{
		try {
			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_code'      => 'required',
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}
			$jnl_code = $post_data['jnl_code'];  //only for edit case
			$this->currentuser = $this->get_current_user_details();
			$role_table = (new \App\Models\Roles())->getTable();
			$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
			$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
			$non_previleged_user_role = $this->RolesConfigdata('non_privileged_user_roles');
			$non_previleged_role_string = "'" . implode("','", $non_previleged_user_role['non_privileged_user_roles']) . "'";
			$criteria = "role_assigned_role !='author'";
			$return_array['proxy_login_roles'] = Roles::get_all_records('*', $criteria, 'role_name');
			$return_array['supporting_forms'] = Generic_forms::get_all_records_with_bind_cond('gncf_id,gncf_form_name,gncf_form_title', array('gncf_metadata_status' => 's'));
			$previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
			$return_array['user_roles'] = Roles::get_records_by_raw_query($previleged_sql);
			$return_array['EPA_text'] ='';
			$non_previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$non_previleged_role_string}) ORDER BY role_name";
			//$this->data['form_data']['non_privileged_user_roles'] = $this->Roles->get_records_where_in('*', 'role_assigned_role', non_privileged_user_roles(), '', 'role_name');
			$return_array['non_privileged_user_roles'] = Roles::get_records_by_raw_query($non_previleged_sql);
			/*Feature#3884 Add permission to view review PDF for production users in Journal and Article type level */
			$sql_production_roles = "SELECT role_id, role_name, role_assigned_role FROM {$role_table} WHERE FIND_IN_SET('p',role_used_in)";
			$return_array['production_roles'] = Roles::get_records_by_raw_query($sql_production_roles);
			if (isset($jnl_code)) {
					$criteria = "jnl_journal_code= ?";
					$jounal_data = Journals::get_single_record('*', $criteria,binding_arr:[$jnl_code]);
					$return_array['jounal_data'] = $jounal_data;
					//start - BUG#2547 - Image Resolution Issue
					if (isset($jounal_data->jnl_logo))
						$return_array['jnl_logo'] = $jounal_data->jnl_logo;
					//end - BUG#2547 - Image Resolution Issue

					//********SECOND  TAB DATA********//
					//journal settings data
					$condition = "jset_jnl_id={$jounal_data->jnl_id}";
					$jounal_settings = Journal_settings::get_single_record('*', $condition);

					$ith_view_settings = $ith_index_settings = $ith_save_changes = array();
					$ith_v2 = FALSE;
					if(isset($this->current_client->functionality->cfty_ithenticate_v2) && isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate== 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
					{
						$ith_v2 = TRUE;
						$ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
						$ithenticateconfig  = Config::get($ithenticate_config);

						$data_view_settings = $data_index_settings = $data_save_changes = array();

						if(isset($jounal_settings->jset_ith_v2_view_settings) && $jounal_settings->jset_ith_v2_view_settings != NULL)
						{
							$data_view_settings = json_decode($jounal_settings->jset_ith_v2_view_settings);
						}
						if(isset($jounal_settings->jset_ith_v2_add_to_index) && $jounal_settings->jset_ith_v2_add_to_index != NULL)
						{
							$data_index_settings = json_decode($jounal_settings->jset_ith_v2_add_to_index);
						}
						if(isset($jounal_settings->jset_ith_v2_save_changes) && $jounal_settings->jset_ith_v2_save_changes != NULL)
						{
							$data_save_changes = json_decode($jounal_settings->jset_ith_v2_save_changes);
						}
						if(isset($ithenticateconfig['ithenticate_v2']['view_settings']))
						{
							foreach($ithenticateconfig['ithenticate_v2']['view_settings'] as $key=>$val)
							{
								if(isset($data_view_settings->$key))
								{
									$val['value'] = $data_view_settings->$key;
								}
								$ith_view_settings[] = array(
									'key'=>$key,
									'label'=>$val['label'],
									'value'=>$val['value']
								);
							}
						}

						if(isset($ithenticateconfig['ithenticate_v2']['indexing_settings']))
						{
							foreach($ithenticateconfig['ithenticate_v2']['indexing_settings'] as $key=>$val)
							{
								if(isset($data_index_settings->$key))
								{
									$val['value'] = $data_index_settings->$key;
								}
								$ith_index_settings[] = array(
									'key'=>$key,
									'label'=>$val['label'],
									'value'=>$val['value']
								);
							}
						}

						if(isset($ithenticateconfig['ithenticate_v2']['similarity_view_settings']))
						{
							foreach($ithenticateconfig['ithenticate_v2']['similarity_view_settings'] as $key=>$val)
							{
								if(isset($data_save_changes->$key))
								{
									$val['value'] = $data_save_changes->$key;
								}
								$ith_save_changes[] = array(
									'key'=>$key,
									'label'=>$val['label'],
									'value'=>$val['value']
								);
							}
						}
					}
					$return_array['ith_v2'] = $ith_v2;
					$jounal_settings->jset_ith_v2_view_settings = $ith_view_settings;
					$params = [];
					if($jounal_settings->jset_review_method == 'c'){
						if($jounal_settings->jset_custom_blind_params){
							foreach(json_decode($jounal_settings->jset_custom_blind_params) as $key => $val){
								$params[] = ['role' => $key, 'selectedOptions' => $val];
							}
						}
					}
					$jounal_settings->jset_custom_blind_params = $params;
					$jounal_settings->jset_ith_v2_add_to_index = $ith_index_settings;
					$jounal_settings->jset_ith_v2_save_changes = $ith_save_changes;

					$return_array['general_jounal_settings'] = $jounal_settings;
					//$license_type =Journal_settings::get_single_record('jset_license_type', array('jset_jnl_id' => $this->jnl_data->jnl_id));
					$clnt_mdl_production = $this->current_client->modules->mdl_production;
					if (isset($clnt_mdl_production) && $clnt_mdl_production == 'n') {
							// #4511 enable TrAction file formats for upload
							// $cond='rft_jnl_id = '.$this->jnl_data->jnl_id.' and rft_artp_id is NULL  and afdec_apply_stage_type = "r"';
							$cond = 'rft_jnl_id = ' . $jounal_data->jnl_id . ' and rft_artp_id IS NULL and FIND_IN_SET("r", afdec_apply_stage_type)';
						} else {
							$cond = 'rft_jnl_id = ' . $jounal_data->jnl_id . ' and rft_artp_id IS NULL';
						}
						$return_array['file_description']=Required_file_type::get_file_description('rft_file_desp_id,rft_req_count,rft_req_fld,afdec_description,rft_sort_order',$cond);
						if ($this->current_client->functionality->cfty_jnl_EPA == 'y' && !empty($jounal_settings->jset_editorial_production_assistant))
						{
							$epa_user_id = $jounal_settings->jset_editorial_production_assistant;
							$check_standalne = ' AND usr_jnl_standalone IS NULL';
							if($jounal_data->jnl_standalone=='y')
								{
									$check_standalne = ' AND usr_jnl_standalone = ' . $jounal_data->jnl_id;
								}
								$Users = new \App\Models\User();
								$User_to_journals =  new \App\Models\User_to_journals;
								$epa_condtn = 'usr_id = ' . $epa_user_id . $check_standalne;
								$epa_name = $Users::get_single_record('CONCAT(usr_first_name,	IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as name', $epa_condtn);
								if (!empty($epa_name->name))
								{
									$epa_roles = $User_to_journals::get_user_roles($epa_user_id, $jounal_data->jnl_id, 'j');
									$epa_jnl_role = '';
									if (!empty($epa_roles) && count($epa_roles)>0)
									{
										$epa_jnl_role = ' (' . implode(", ", array_column(json_decode(json_encode($epa_roles), TRUE), 'role_name')) . ')';
									}
									$return_array['EPA_text'] = $epa_name->name . $epa_jnl_role;
								}
						}

					//echo $json_string; die;			;
					//EPA name and journal roles
					//if ($this->current_client->functionality->cfty_jnl_EPA == 'y' && !empty($this->data['form_data']['general']->jset_editorial_production_assistant))
					{
							/*$epa_user_id = $this->data['form_data']['general']->jset_editorial_production_assistant;
				$check_standalne = ' AND usr_jnl_standalone IS NULL';
				if ($this->jnl_data->jnl_standalone == 'y')
					$check_standalne = ' AND usr_jnl_standalone = ' . $jounal_data->jnl_id;
				$epa_condtn = 'usr_id = ' . $epa_user_id . $check_standalne;
				$epa_name = Users::get_single_record('CONCAT(usr_first_name,	IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as name', $epa_condtn);
				if (!empty($epa_name->name))
				{
					$epa_roles = $this->User_to_journals->get_user_roles($epa_user_id, $this->jnl_data->jnl_id, 'j');
					$epa_jnl_role = '';
					if (!empty($epa_roles))
						$epa_jnl_role = ' (' . implode(", ", array_column(json_decode(json_encode($epa_roles), TRUE), 'role_name')) . ')';
					$this->data['EPA_text'] = $epa_name->name . $epa_jnl_role;
				}
				else
					$this->data['form_data']['general']->jset_editorial_production_assistant = NULL;*/ }
					//Customisation #2604 - JPR-374 Browse Keywords
					/* $enable_browse = FALSE;
                        $where = array();
                        if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
                        {
                            $where = array(
                                "kwdrl_inactive" => 'n'
                            );
                        }
//                        echo '<pre>';print_r($this->jnl_data);die;
                        if ($this->uri->segment(3) == "settings")
                        {
                            if (isset($this->current_client->functionality->cfty_browse_keywords_in_submission) && $this->current_client->functionality->cfty_browse_keywords_in_submission == 'y')
                            {
                                if (isset($this->jnl_data))
                                {
                                    $total = $this->Excluded_journal_keywords->search_journal_keywords($this->jnl_data->jnl_id, FALSE, $this->current_client->functionality->cfty_keyword_hierarchy, FALSE, NULL, NULL, TRUE, $where);
                                    if (isset($total) && $total[0]->cnt > 0)
                                        $enable_browse = TRUE;
                                }
                            }
                        }
                        $this->data['enable_browse'] = $enable_browse;*/

					
					$condition = "asgm_jnl_id={$jounal_data->jnl_id} AND asgm_artp_id IS NULL";
					$return_array['user_assg_perm'] = Assign_permission::get_all_records('*', $condition);

					//********THIRD  TAB DATA********//
					//get all primary and secondary for manage user to journal
				
					//**************ADD USER*****************//
					//get author id
					$condition = "role_assigned_role='author'";
					$author_role = Roles::get_single_record('role_id', $condition);
					$return_array['author'] = $author_role->role_id;

					//get associate editor, reviewer ids
				
					//	$this->data['classific_role_data'] = explode(';', $classific_role->role_ids);


					//	$this->data['edit_record'] = $this->jnl_data->jnl_id;
					//**************END KEYWORD*****************//

					//	$this->data['journal'] = $this->jnl_data->jnl_id;

					//	$this->data['master_flow'] = $this->jnl_data->jnl_fwm_id;
					//Enhancement#2152 Partly import workflow
					//	$this->data['enable_reset_btn'] = FALSE;
					
				}



			/* Feature #1050 */
			$confirm_credits = 'no';

			$current_client_module = $this->current_client->modules;
			if ($current_client_module->mdl_casrai_credit == 'y') {
					$confirm_credits = 'yes';
				}

			$this->data['confirm_credits'] = $confirm_credits;
			/* Feature #1050 */

			$confirm_orcid = 'no';
			if ($current_client_module->mdl_orcid == 'y') {
					$confirm_orcid = 'yes';
				}

			$this->data['confirm_orcid'] = $confirm_orcid;



			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$review_flow  = Config::get($workflow_config);

			$carai_enabled = $orcid_enabled = array();

			if (!empty($review_flow)) {
					foreach ($review_flow as $rk => $rv) {

							if ((isset($rv['enable_casrai_credits_confirm'])) && $rv['enable_casrai_credits_confirm'] == true) {
									$carai_enabled[] = $rk;
								}
							if ((isset($rv['enable_orcid_confirm'])) && $rv['enable_orcid_confirm'] == true) {
									$orcid_enabled[] = $rk;
								}
						}
				}

			$show_export_details = FALSE;
			/*** Feature #2109 - JPR-101 User Accounts - unavailability ***/
			$search = array(
				'd',
				'm',
				'Y',
				'y'
			);
			$replace = array(
				'DD',
				'MM',
				'YYYY',
				'YY'
			);

			$return_array['show_export_details'] = $show_export_details;

			$return_array['carai_enabled'] = $carai_enabled;
			$return_array['orcid_enabled'] = $orcid_enabled;
			$jnl_dateformat_array = $this->Utility('date_format');

			$return_array['all_date_format'] = $jnl_dateformat_array['date_format'];
			//$this->data['all_roles'] = $this->utility->roles;
			$return_array['all_roles'] = Roles::get_all_records();
			if ($jounal_settings != '' && isset($jounal_settings->jset_license_type)) {
					if ($jounal_settings->jset_license_type == "all")
					{
						$copyright_type = array();
					}
					else
					{
						$copyright_type = array("crtm_payment" => $jounal_settings->jset_license_type);
					}

					//	$this->data['copyrights_list'] = $this->Copyright_master->get_all_records('crtm_id, crtm_license_name, crtm_payment', $copyright_type);
				}
				$client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
				$client_defaults  = Config::get($client_default);
				$return_array['jnl_logo_max_width']=$client_defaults['jnl_logo_max_width'];
				$return_array['jnl_logo_max_height']=$client_defaults['jnl_logo_max_height'];
				$return_array['inc_jnl_brkt']=$client_defaults['inc_jnl_brkt'];

			//task #672 show back btn (journals list) in journal settings page
			$return_array['show_back_to_journals'] = false;
				if ((in_array('super_admin', $this->currentuser['roles']) || in_array('sudo', $this->currentuser['roles'])) && isset($jnl_code) && $jnl_code != '') {
					$return_array['show_back_to_journals'] = true;
			}

			$return_array['core_role_priority'] = $this->RolesConfigdata('priority_roles');

			//CHecking any file description is marked for research integrity
			//If none of the file descriptions is marked, then show a warning msg
			if((isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y'))
			{
				$is_rvri_marked 	=	false;
				$fd_rvri_res = Attachment_file_description::get_all_records('afdec_id', 'afdec_submit_to_rvri = "y"');
				if (!$fd_rvri_res->isEmpty()) {
					$is_rvri_marked 	=	true;
				}

			} else {
				$is_rvri_marked 	=	true;
			}
			$return_array['is_rvri_marked'] = $is_rvri_marked;

			//#672 show manage article type tab only if super admin or sudo and check journal has completely configured valid workflow
			return $this->success('success',200,$return_array);

		} catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
	/*
	Advanced Setting Data
	committed date:-25-04-2022
	Request type :- POST
	*/
public function get_file_description_data(Request $request)
{
	try
	{
	$return_array['upload_type'] = File_upload_type::get_all_records();
	$condition = "afdec_default !='s'";
	$return_array['attach_file_description'] = Attachment_file_description::get_all_records('*', $condition, 'afdec_description');
	$copyright_mode_array=$this->Utility('copyright_mode_array');
	$return_array['avail_license_modes'] = $copyright_mode_array['copyright_mode_array'];
	return $this->success('success',200,$return_array);
	}
	catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}
}

	/*
   Save platform Settings
    commited date :-  13-03-2022
    Request type :- POST
    */
	public function save_settings(Request $request)
	{
		try {
			DB::beginTransaction();
			$validator = Validator::make($request->all(), [
                'platform_jounal_code' => 'required',
                'platform_jounal_name' => 'required',
              //  'platform_submission_type'   => 'required',
                'platform_date_format' => 'required',
                'platform_minimum_no_of_keyword' => 'required|numeric',
                'platform_maximum_no_of_keyword' => 'required|numeric',
                'platform_category' => 'required',
                'platform_description' => 'required',
                'platform_custom_keyword' => 'required',
                'platform_submission_type' => 'required',
			]);
			if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
			$this->currentuser = $this->get_current_user_details();
			$journal_data = $request->all();

			$journal_code = $journal_data['platform_jounal_code'];
			$jounal_name = $journal_data['platform_jounal_name'];
			$submission_type = $journal_data['platform_submission_type'];
			$jounal_desciption = $journal_data['platform_description'];
			$date_format = $journal_data['platform_date_format'];
			$platform_metadata = $journal_data['platform_metadata'];
			// Task #3563 Collecting Supporting Documents for Conference
			$platform_supporting_forms = isset($journal_data['supporting_data_forms'])?$journal_data['supporting_data_forms']:array();
			$platform_category = $journal_data['platform_category'];
			$jnl_id = (isset($journal_data['platform_id'])) ? $journal_data['platform_id'] : '';

			if ($this->current_client->modules->mdl_review_for_doc == 'y') {
				$journal_data['platform_submission_type'] = array('0' => 'a');
			}
			$action_msg=array();

		if (!preg_match('/^[A-Za-z0-9_]+$/', $journal_code))
		{
			$jnl_code_err=customTrans('platform_settings.invalid_jnl_code');
			array_push($action_msg,$jnl_code_err);
		}
			$edit_journal = FALSE;
			//check code duplicate
			if ($jnl_id != '') {
				$journal_id = $jnl_id;
				$journal_code_chk = "jnl_journal_code='{$journal_code}' AND jnl_id !='".$journal_id."'";
			$standalone_journal_group_chk=array();
				$journal_name_chk = 'jnl_journal_name="'.$jounal_name.'" AND jnl_id !="'.$journal_id.'"';
				if ($this->current_client->modules->mdl_standalone_journals == 'y') {
					$standalone_group = (isset($journal_data['standalone_group'])) ? $journal_data['standalone_group'] : '';
					$standalone_journal_group_chk = array(
					'jnl_standalone_group' => (isset($journal_data['standalone_group'])) ? $journal_data['standalone_group'] : '',
					'jnl_id !=' => $journal_id
				);
					$standalone_journal_group_chk = "jnl_standalone_group='{$standalone_group}' AND jnl_id!='".$journal_id."'";
				}
				$edit_journal = TRUE;
			} else {
				$journal_code_chk = "jnl_journal_code='{$journal_code}'";
				$journal_name_chk = 'jnl_journal_name="'.$jounal_name.'"';

				if ($this->current_client->modules->mdl_standalone_journals == 'y') {
						$standalone_group = (isset($journal_data['standalone_group'])) ? $journal_data['standalone_group'] : '';
						$standalone_journal_group_chk = "jnl_standalone_group ='{$standalone_group}'";
					}
			}

			/*if (!file_exists($path))
			mkdir($path, 0777, TRUE);*/

			$url = '';
			$jnl_code_check = Journals::get_single_record('jnl_journal_code', $journal_code_chk); //check code
			$jnl_name_check = Journals::get_single_record('jnl_journal_name', $journal_name_chk); //check name
			//standalone journal
			$standalone = 'n';
			$standalone_journal_group = '';
			$standalone_journal_group_check = '';
			if (isset($journal_data['platform_standalone']) && $journal_data['platform_standalone'] == 'y') {
				$standalone_journal_group_check = Journals::get_single_record('jnl_standalone_group', $standalone_journal_group_chk);
				$standalone = 'y';
				$standalone_journal_group = $journal_data['standalone_group'];
			}
			//checking form submition
			if (!empty($jnl_code_check)) {
				$action_status = 'err';
				$abbr_exist =customTrans('platform_settings.abbr_exist');
				array_push($action_msg,$abbr_exist);

			} elseif (!empty($jnl_name_check)) {
				$action_status = 'err';
				$jnl_name =customTrans('platform_settings.jnl_name_exist');
			    array_push($action_msg,$jnl_name);

			} elseif ($this->current_client->modules->mdl_standalone_journals == 'y' && !empty($standalone_journal_group_check) && $standalone == 'y') {
				$action_status = 'err';
				$action_msg = customTrans('platform_settings.duplicate_standalonejournal_gp_msg');
			}
				if ($jnl_id != '') {
 if (isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y') {
					$res=$this->validate_supportdataform(array('jnl_id'=>$jnl_id,'jnl_code'=>strtolower($journal_code)));

					if(!empty($res)) {
						if(isset($res['forms']) && isset($res['forms']->gdata_atf_id)){
							$formidarray=explode(',',$res['forms']->gdata_atf_id);
							$formidarray2=array();				
							if(is_array($platform_supporting_forms) && count($platform_supporting_forms) > 0) {
								$formidarray2=$platform_supporting_forms;
							}

							if (!empty(array_diff($formidarray, $formidarray2))) {
								// All values of array1 exist in array2
								//echo "Valid";
							
								$diffformids=array_diff($formidarray, $formidarray2);
								if (empty($diffformids)) {
									$diffFormNames = '';
								} else {
									$diffFormNames = DB::table('rvw_generic_forms')
										->whereIn('gncf_id', $diffformids)
										->select(DB::raw("GROUP_CONCAT(DISTINCT gncf_form_name ORDER BY gncf_form_name SEPARATOR ', ') AS names"))
										->value('names');
									$items = explode(', ', $diffFormNames);

									$count = count($items);

									if ($count > 1) {
										$last = array_pop($items);
										$formatted = collect($items)->map(fn($v) => "<strong>$v</strong>")->implode(', ');
										$formatted .= " and <strong>$last</strong>";
									} else {
										$formatted = "<strong>{$items[0]}</strong>";
										
									}
									$supp_err='The supporting document forms ('.$formatted.') already contain data for this conference and cannot be modified.';
									array_push($action_msg,$supp_err);
								}
								
							}
						}
					}
				}
					
				}
			$return_array =array();
			if(empty($action_msg ))
			{
			if (
				$journal_data != FALSE &&
				$journal_code != '' &&
				$jounal_name != '' &&
				!(empty($submission_type)) &&
				$jounal_desciption != ''

			) {

				$path = 'public/uploads/' . $journal_code;

				if (!Storage::exists($path)) {
					$response = Storage::makeDirectory('public/uploads/' . $journal_code);
				}
				//custom journal type
				if ($platform_category == 'custom' && isset($platform_category) && $platform_category != '') {
					$journal_type = $journal_data['custom_platform_type'];
				} else {
					$journal_type = $platform_category;
				}
				// Task #3563 Collecting Supporting Documents for Conference
				$supporting_forms=null;
				if(is_array($platform_supporting_forms) && count($platform_supporting_forms) > 0) {
					$supporting_forms = json_encode($platform_supporting_forms);
				}

				$journal_form_data = array(
					'jnl_journal_code' => strtolower($journal_code),
					'jnl_journal_name' => $jounal_name,
					'jnl_journal_type' => $journal_type,
					// 'jnl_standalone' => $standalone,
					'jnl_journal_description' => $jounal_desciption,
					'jnl_metadata_id'=>$platform_metadata,
					'jnl_supporting_forms'=>$supporting_forms
				);

				if ($this->current_client->modules->mdl_standalone_journals == 'y' && $standalone == 'y' && $jnl_id == '') {
					$journal_form_data['jnl_standalone_group'] = $standalone_journal_group;
					$journal_form_data['jnl_standalone'] = $standalone;
				}
				$login_user_type='';
				if (isset($submission_type) && (!empty($submission_type))) {

					$login_user_type =json_encode($submission_type);
				}

				$reply_to_email = NULL;
				if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y" && (isset($journal_data['reply_to_email']) && $journal_data['reply_to_email'] != "")) {
					$reply_to_email = $journal_data['reply_to_email'];
				}
				$reply_to_email_traction = NULL;
				if ($this->current_client->functionality->cfty_enable_journal_reply_to == "y" && (isset($journal_data['reply_to_email_traction']) && $journal_data['reply_to_email_traction'] != "")) {
					$reply_to_email_traction = $journal_data['reply_to_email_traction'];
				}
				$journal_settings_form_data = array(
					'jset_login_user_type' => $login_user_type,
					'jset_date_format' => $date_format,
					'jset_reply_to_email' => $reply_to_email,
					// 'jset_rate_reviewer' => '',
					// 'jset_review_method' => '',
					// 'jset_review_open_count' => 0,
					'jset_custom_classification' => 'n',
					// 'jset_cust_secondary_class' => 'n',
					// 'jset_min_no_secondary_class' => 0,
					// 'jset_max_no_secondary_class' => 0,
					// // 'jset_secondary_class_alias' => '',
					// 'jset_min_no_primary_class' => 0,
					// 'jset_max_no_primary_class' => 0,
					// // 'jset_primary_class_alias' => '',
					'jset_text_direction' => '',
					'jset_default_ithapi_folder' => '',
					'jset_ithsubmission_type' => '',
					'jset_reply_to_email_traction' => $reply_to_email_traction,
					//'jset_proxy_login' => NULL,
					//'jset_add_notes' => NULL,
					//'jset_add_user_note'=>NULL,
					'jset_min_keyword' => $journal_data['platform_minimum_no_of_keyword'],
					'jset_max_keyword' => $journal_data['platform_maximum_no_of_keyword'],
					'jset_user_input_keyword' => $journal_data['platform_custom_keyword']
				);
				/* Copy Journal */
				if (isset($journal_data['copy_journal']) && !empty($journal_data['copy_journal'] && !empty($journal_data['jnl_section']))) {

					foreach($journal_data['copy_settings'] as $value)
					{
						$chek=$value['checked'];
						if($chek==true)
						{
							$journal_data['jnl_section'][]=$value['value'];
						}
					}
					$return_data=$this->copy_journal_from($journal_form_data, $journal_settings_form_data, $journal_data);
					return $this->success('success',200,$return_data);

				}
				/* Copy Journal Ends */

				// Task #3393 Metadata custom form fields should be able to delete
				if ($jnl_id != '') {
					if((in_array('sudo', $this->currentuser['roles']) || in_array('super_admin', $this->currentuser['roles']) || in_array('admin', $this->currentuser['roles']))) {
						$journaldata = Journals::get_single_record_with_bind_cond('jnl_id,jnl_journal_code,jnl_metadata_id', array('jnl_id'=>$journal_id));
						if(!empty($journaldata)){
							if(!empty($journaldata->jnl_metadata_id) && $journaldata->jnl_metadata_id!=$platform_metadata){
								$metadata_path=$this->get_metadatafilepath();
								$filepath=$journaldata->jnl_journal_code.'/'.$metadata_path;
								$formatted_journal_code='_'.$journaldata->jnl_journal_code;
                                /* Start -- clear generic form elements */
                                /* Get generic form elements that need to be cleared */														
								$record_exist = Article_generic_form_data::get_single_record_with_bind_cond("gdata_label,gdata_data",array('gdata_atf_id'=>$journaldata->jnl_metadata_id),'',array(),NULL,$formatted_journal_code);
								if(!empty($record_exist)) {
									$result = Article_generic_form_data::get_all_records('gdata_data,gdata_id',"gdata_atf_id = ? and gdata_element_type='file'",null,null,$formatted_journal_code,binding_arr:[$journaldata->jnl_metadata_id]);
									if ($result) {
										$otherController = new Manage_Generic_Form_Api();
										foreach ($result as $value) {
										   $otherController->removeUploadedFiles($value, $filepath);
										   Article_generic_form_data::delete_records("gdata_id={$value->gdata_id}",$formatted_journal_code);
										}                                   
									}
									Article_generic_form_data::delete_records("gdata_atf_id={$journaldata->jnl_metadata_id}",$formatted_journal_code);
								}
							}
						}
					}
				}


				if ($jnl_id != '') {
					//$jnl_data = $this->jnl_data;
					$criteria = "jnl_id={$journal_id}";
					Journals::update_record($journal_form_data, $criteria, $this->currentuser);
					//print_r($journal_settings_form_data); die;
					$criteria = "jset_jnl_id={$journal_id}";
					Journal_settings::update_record($journal_settings_form_data, $criteria, $this->currentuser);
					DB::commit();
					$return_array['action_status']='updated';

					$action_msg = "Update journal";
					//* start -- if success -- remove old uploaded logo*//
					if (isset($journal_form_data['jnl_logo'])) {
						$file_path = APP_DOC_PATH . $journal_form_data['jnl_journal_code'] . '/' . $jnl_data->jnl_logo;
						if (file_exists($file_path))
							unlink($file_path);
					}
					//* end -- if error occure -- remove uploaded logo*//
					//for set updated row to append
					$condition = "jnl_id={$journal_id}";
					$affect_rows = Journals::get_single_record('*', $condition);
				

				}
				else {

					$journal_desc = "Flow of " . $jounal_name;
					$Permission_desc = "Permission of $jounal_name";
					//for getting master flow tb id (FLOW)
					$mast_flow_id = Flow_master::insert_record(array(
						'fwm_description' => $journal_desc
					), $this->currentuser);
				   $mast_permission_id=Journal_permission_master::insert_record(array(
					'jpm_description' => $Permission_desc
				), $this->currentuser);
					$journal_form_data['jnl_fwm_id'] = $mast_flow_id;
					$journal_form_data['jnl_jpm_id'] = $mast_permission_id;
					//insert Journal
					$journal_id = Journals::insert_record($journal_form_data, $this->currentuser);
					$return_array['jnl']=$journal_id;

					//for copy feedback form if created journal is standalone one
					$copy_fd_frm = FALSE;
				

					if (isset($journal_data['proxy_login'])) {
						$journal_sett_data['jset_proxy_login'] = json_encode($journal_data['proxy_login']);
					}
					if (isset($journal_data['user_note'])) {
						$journal_sett_data['jset_add_user_note'] = json_encode($journal_data['user_note']);
					}

					$journal_settings_form_data['jset_jnl_id'] = $journal_id;
					$journal_settings = Journal_settings::insert_record($journal_settings_form_data, $this->currentuser);
					$permission_setting_data=array();
						if ($this->current_client->modules->mdl_review_for_doc == 'n') {
							$role_table = (new \App\Models\Roles())->getTable();
							$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
							$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
							$previleged_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
							$user_roles = Roles::get_records_by_raw_query($previleged_sql);
							$role_id_perm = array();
							foreach ($user_roles as $val) {
									if ($val->role_assigned_role == 'journal_admin' || $val->role_assigned_role == 'staff') {
											$role_id_perm[] = $val->role_id;
										}
								}
								$permission_setting_data["jp_add_notes"]=json_encode($role_id_perm);
							//set default permission for article add notes

						}
					$permission_setting_data["jp_jpm_id"]=$mast_permission_id;
					Journal_permission::insert_record($permission_setting_data, $this->currentuser);
					if($journal_settings=='')
					{
						DB::rollBack();
					}
					elseif(empty($jnl_id)){
					 DB::commit();
					}
					// start -- creating first stage in journal flow
					$submission_role = 'author';
					//$stage_name = 'Article Submission';
					$stage_name = customTrans(':Article Submission');
					$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
						$review_flow  = Config::get($workflow_config);
					//Task #596 Create EIDO configuration and build workflow
					if ($this->current_client->modules->mdl_review_for_doc == 'y' && isset($review_flow['author_submission']['roles'][0])) {


						$submission_role = $review_flow['author_submission']['roles'][0];
						$stage_name = $review_flow['author_submission']['label'];
					}
					//get author role id
					$condition = "role_assigned_role='{$submission_role}'";
					$author_role = Roles::get_single_record('role_id', $condition);


					$jnl_base_stages = array(
						array(
							'jwf_fwm_id' => $mast_flow_id,
							'jwf_stage_name' => $stage_name,
							'jwf_stage_type' => 'author_submission',
							'jwf_start' => 'y',
							'jwf_role_id' => $author_role->role_id,
							'jwf_parent_stages' => '[]',
							//'jwf_forms' => '[]', //avoid adding default generic form
							'jwf_tab_name' => $stage_name,
							'jwf_status_name' => $stage_name,
							'jwf_ypos' => '',
							'jwf_xpos' => '1',
							'jwf_posted_date' => date('Y-m-d H:i:s')
						)
					);

					//Task #596 Create EIDO configuration and build workflow
					if ($this->current_client->modules->mdl_review_for_doc == 'n') {
						$jnl_base_stages[] = array(
							'jwf_fwm_id' => $mast_flow_id,
							'jwf_stage_name' => 'Transit',
							'jwf_stage_type' => 'transit',
							'jwf_start' => 'n',
							'jwf_role_id' => $author_role->role_id,
							'jwf_parent_stages' => '[]',
							//'jwf_forms' => '[]', //avoid adding default generic form if exist
							'jwf_tab_name' => 'Transfer',
							'jwf_status_name' => 'Transit',
							'jwf_ypos' => '0',
							'jwf_xpos' => '6',
							'jwf_posted_date' => date('Y-m-d H:i:s')
						);
					}

					Generic_flows::insert_batch($jnl_base_stages);
					//					$this->Generic_flows->insert_record($jnl_base_stage, $this->currentuser);
					// end -- creating first stage in journal flow


					$return_array['action_status']='add';
					//						$this->db->trans_complete();

					$mast_flow = $mast_flow_id;


					$article_generic_form_data_table= (new \App\Models\Article_generic_form_data())->getTable();
					Article_generic_form_data::copy_table($article_generic_form_data_table, $journal_code);
					Article_generic_form_data::copy_constraints('rvw_article_gnf_form_data_' . strtolower($journal_code));
					/* Create backup table starts */
					$backup_table = Article_generic_form_data::copy_table($article_generic_form_data_table, $journal_code, 'tbk_article_gnf_form_data');
					Article_generic_form_data::add_columns($backup_table);
					$tablename = 'article_gnf_form_data_' . strtolower($journal_code);
					Article_generic_form_data::create_trigger($tablename, 'gdata_id');
					DB::commit();
					/* Create backup table Ends */
				}
			} else {
				$return_array['msg']=customTrans('platform_settings.failed_to_jnl_msg');
				return $this->warning('Failed',200,$return_array);


			}
			$return_array['jnl_code'] = $journal_code;
			//if ($edit_journal == TRUE) {
				return $this->success(customTrans('platform_settings.success_to_save_platform_settings'),200,$return_array);

			}
			else
			{
				return $this->warning(customTrans('platform_settings.failed_to_jnl_msg'),200,str_replace('Journal abbreviation already exists',"Journal code already exists",$action_msg));
			}

		} catch (\Exception $e) {
			
			//DB::rollback();
			//DB::rollBack();
			return $this->failure('Failure',500,$e);
		}
	}


	public function copy_journal_from($journal_form_data, $journal_settings_form_data, $jnl_data)
	{

		$this->currentuser = $this->get_current_user_details();
		$copyjnl_id=$jnl_data['copy_journal'];
		$jnl_section=$jnl_data['jnl_section'];
		$criteria = "jnl_id='{$copyjnl_id}'";
			$platform_data = Journals::get_single_record('*', $criteria);
		$new_generic_table_name = '';
		$newJnlData = array();
			// Flow_master::trans_start();
			//copy journal basic data. It returns array contains mast_flow_id , newJnlId, newJnlCode, newJnlName
			$newJnlData = $this->copy_jnl_basic_data($journal_form_data);

			//Copy journal settings . Returns journal settings insert id
			$jnlSettingsData = $this->copy_journal_settings($newJnlData, $copyjnl_id, $journal_settings_form_data, $jnl_section);

			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_setting', $jnl_section)))
			{
				$jnlDescription = $this->copy_journal_description($newJnlData, $copyjnl_id);
				$this->copy_ftp_journal_option($newJnlData, $platform_data, 'jnl_option');
				$this->copy_credential_ithenticate_journal($newJnlData, $copyjnl_id);	
			}
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_metadata', $jnl_section)))
			{
				if(!empty($platform_data))
				{
					if(!empty($newJnlData['newJnlId']))
					{
						$condtn="jnl_id='{$newJnlData['newJnlId']}'";
						Journals::update_record(array(
							'jnl_metadata_id' => $platform_data->jnl_metadata_id),$condtn, $this->currentuser);
					}

				}
			}
			// Task #3563 Collecting Supporting Documents for Conference
			if(isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y') {
				if(!empty($platform_data))
				{
					if(!empty($newJnlData['newJnlId']))
					{
						$condtn="jnl_id='{$newJnlData['newJnlId']}'";
						Journals::update_record(array(
							'jnl_supporting_forms' => $platform_data->jnl_supporting_forms),$condtn, $this->currentuser);
					}

				}
			}

			//Copy journal workflows
			$copied_new_forms = array();
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_workflow', $jnl_section)) || (empty($jnl_section)))
			{
			  $workflowData = $this->copy_journal_workflow($platform_data->jnl_fwm_id, $newJnlData['mast_flow_id']);
			//Copy Journal level custom form

			  $copied_new_forms = $this->copy_jounal_generic_forms($newJnlData['mast_flow_id'], $newJnlData['newJnlId'], $copyjnl_id);

                        /*/*
                           * task#669-Flow based FTP export
                           * copy journal workflow based ftp to new journal workflow
                           */
                          $this->copy_ftp_journal_option($newJnlData, $platform_data, 'jnl_workflow');
			}

			//Create article generic form table
			// $this->load->model('Article_generic_form_data');
			//Copy journal terms
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_classification', $jnl_section)) || (empty($jnl_section)))
			{

				Classifications::copy_journal_classification($newJnlData['newJnlId'], $copyjnl_id, $this->currentuser['user_id']);

				$this->update_Journal_terms($newJnlData['newJnlId']);

			}

			//Copy user journals
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_users', $jnl_section)) || (empty($jnl_section)))
			{
				//#4474 bug in copying journal
				$only_journal = FALSE;
				//if only 'Users with roles in journal' is checked then then only journal level users are copied
				//if 'Article Types' also selected then both jnl-level users and article-type level users are selected.
				if ((!in_array('jnl_article_types', $jnl_section)))
				{
					$only_journal = TRUE;
				}
				$userJnls = $this->copy_usr_jnl($newJnlData['newJnlId'], $copyjnl_id, $this->currentuser['user_id'],$only_journal);
                // $userJnls_class = $this->copy_usr_jnl_class($newJnlData['newJnlId'], $copyjnl_id, $this->currentuser['user_id']);    to do/not needed in review3
			}
			//Copy exclude journal keywords
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_keywords', $jnl_section)) || (empty($jnl_section)))
			{
				$keywords = Excluded_journal_keywords::copy_journal_keywords($copyjnl_id, $newJnlData['newJnlId'], $this->currentuser['user_id']);
				if ($this->current_client->functionality->cfty_keyword_hierarchy == "j")
				$relationship_keywords = keyword_relationship::copy_journal_relationship($copyjnl_id, $newJnlData['newJnlId'], $this->currentuser['user_id']);
			}
//			//Copy rvw_stage_email_tmpls
			//Copy rvw_stage_email_tmpls Customisation #1565 : JPR-120 : Email Templates: Global Email template
			$new_jrnl_id = array(
				'new_jrnl_id' => $newJnlData['newJnlId']);
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_workflow', $jnl_section)) || (empty($jnl_section)))
			{
				Stage_email_templates::copy_email_templates($copyjnl_id, $this->currentuser['user_id'], $new_jrnl_id);
			}

			$emtmpl_con="stage_etmp_journal_id='{$newJnlData['newJnlId']}'";
			$jrnl_stage_templates = Stage_email_templates::get_all_records('stage_etmp_id, stage_old_etmp_id',$emtmpl_con);
			$old_new_email_tmpl_id = array();
			foreach ($jrnl_stage_templates as $t)
			{
				$old_new_email_tmpl_id[$t->stage_old_etmp_id] = $t->stage_etmp_id;
			}
			//associate template to journal workflow
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_workflow', $jnl_section)) || (empty($jnl_section)))
			{
			$this->associate_email_template_on_copy($newJnlData['newJnlId'], $newJnlData['mast_flow_id'], $old_new_email_tmpl_id);
			}

			// copy journal permission assignments
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_permissions', $jnl_section)) || (empty($jnl_section)))
			{
				Assign_permission::move_user_assgmnt($copyjnl_id, NULL, $this->currentuser['user_id'], $newJnlData['newJnlId']);
			}
			//Copy Article types and its associated data
			if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_article_types', $jnl_section)) || (empty($jnl_section)))
			{
				$this->copy_article_types($newJnlData, $platform_data, $copied_new_forms, $old_new_email_tmpl_id, $jnl_section);
			}
			//empty stage_old_etmp_id in rvw_stage_email_template of record with new jrnal id
			if (!empty($old_new_email_tmpl_id))
			{
				$con="stage_etmp_journal_id='{$newJnlData['newJnlId']}'";
				Stage_email_templates::update_record(array(
					'stage_old_etmp_id' => 0),$con, $this->currentuser);
			}
				/* Create article generic form table and its backup table */

				// $this->load->model('Article_generic_form_data');
				Article_generic_form_data::copy_table('rvw_article_gnf_form_data', $newJnlData['newJnlCode']);
				Article_generic_form_data::copy_constraints('rvw_article_gnf_form_data_' . $newJnlData['newJnlCode']);

				/* Create backup table starts */
				$backup_table = Article_generic_form_data::copy_table('rvw_article_gnf_form_data', $newJnlData['newJnlCode'], 'tbk_article_gnf_form_data');
				Article_generic_form_data::add_columns($backup_table);
				$tablename = 'article_gnf_form_data_' . $newJnlData['newJnlCode'];
				$new_generic_table_name = $backup_table;
				Article_generic_form_data::create_trigger($tablename, 'gdata_id');
				if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_metadata', $jnl_section)))
				{
					Article_generic_form_data::copyMetaRecord($platform_data,$newJnlData['newJnlCode']);
				}
				
				/* Create backup table Ends */

				/* Create article generic form table and its backup table  ENDS */

				$message = 'Successfully copied \" ' . $newJnlData['newJnlName'] . ' \" from \" ' . $platform_data->jnl_journal_name . ' \" ';
			$result_array['success']=true;
			$result_array['message']=$message;
			$result_array['jnl_code']=$newJnlData['newJnlCode'];
			$result_array['action_status']='add';
            $result_array['jnl']=$newJnlData['newJnlId'];
				// $this->session->set_flashdata('copysuccessmsg', $message);
				return $result_array;

	}
	function copy_credential_ithenticate($newArtTypeId, $oldArticletype_id,$newJnlId)
	{
		$this->current_user = $this->get_current_user_details();
		//get journal_settings table field names
		$art_set_fields = Api_credentials::get_field_names();

		$insert_fields = implode(',', $art_set_fields);
		$insert_fields = str_replace('acrd_id,', '', $insert_fields);

		$select_fields = implode(',', $art_set_fields);
		$select_fields = str_replace('acrd_id,', '', $select_fields);
		$select_fields = str_replace('acrd_artp_id', $newArtTypeId, $select_fields);
		$select_fields = str_replace('acrd_jnl_id', $newJnlId, $select_fields);

		$select_fields = str_replace('acrd_posted_by', $this->current_user['user_id'], $select_fields);
		$select_fields = str_replace('acrd_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newartData = Api_credentials::copy_credential_ithenticate_articletype($insert_fields, $select_fields, $oldArticletype_id);
		return $newartData;
	}
public function copy_article_types($newJnlData, $oldJnlData, $copied_jnl_forms = array(), $old_new_tmpl_id = array(), $jnl_section = array())
{
	$this->currentuser = $this->get_current_user_details();
	$atype_con="artp_jnl_id='{$oldJnlData->jnl_id}'";
	$article_types = Article_types::get_all_records('*', $atype_con);

	$new_article_ids = array();
	foreach ($article_types as $article_type)
	{
		$oldArticle_id = $article_type->artp_id;
		$newArtData = array();
		$newArtCode = $this->generate_jnl_code('art', $article_type->artp_abbr_article_type, 0, $newJnlData['newJnlId']);
		$newArtName = $this->generate_jnl_name('art', $article_type->artp_article_type, 0, $newJnlData['newJnlId']);

		$artType_desc = 'Flow of ' . $newArtName;

		//for getting master flow tb id (FLOW)
		if(isset($oldJnlData->jnl_fwm_id) && isset($article_type->artp_fwm_id) && $oldJnlData->jnl_fwm_id==$article_type->artp_fwm_id)
		{
			$mast_flow_id=$newJnlData['mast_flow_id'];
		}else{
		$mast_flow_id = Flow_master::insert_record(array(
			'fwm_description' => $artType_desc
			), $this->currentuser);
		}
		$newArtData['mast_flow_id'] = $mast_flow_id;

		$artp_prefix_article_no =  $article_type->artp_prefix_article_no;
		//get article type table field names
		$art_type_fields = Article_types::get_field_names();

		$insert_fields = implode(',', $art_type_fields);
		$from = '/' . preg_quote('artp_id,', '/') . '/';
		$insert_fields = preg_replace($from, '', $insert_fields, 1);

		$select_fields = implode(',', $art_type_fields);
		$from = '/' . preg_quote('artp_id,', '/') . '/';
		$select_fields = preg_replace($from, '', $select_fields, 1);
		$select_fields = str_replace('artp_abbr_article_type', '"' . $newArtCode . '"', $select_fields);
		$select_fields = str_replace('artp_article_type', "'" . $newArtName . "'", $select_fields);
		$select_fields = str_replace('artp_jnl_id', $newJnlData['newJnlId'], $select_fields);
		$select_fields = str_replace('artp_fwm_id', $mast_flow_id, $select_fields);
		$select_fields = str_replace('artp_old_art_type_id', 'artp_id', $select_fields);
		$select_fields = str_replace('artp_prefix_article_no', '"' . $artp_prefix_article_no . '"', $select_fields); //
		$select_fields = str_replace('artp_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('artp_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newArtId = Article_types::copy_article_types($insert_fields, $select_fields, $oldArticle_id);

		if ($article_type->artp_parent_artp_id != NULL)
		{
			$new_article_ids[] = $newArtId;
		}
		/* Update Article type parent ID(artp_parent_artp_id) */

		$this->copy_article_type_options($newArtId, $oldArticle_id, $jnl_section);

		if ((!empty($jnl_section) && in_array('jnl_setting', $jnl_section)) || empty($jnl_section))
		{
		 $this->copy_article_type_description($newArtId, $oldArticle_id,$newJnlData);
		 $this->copy_credential_ithenticate($newArtId, $oldArticle_id,$newJnlData['newJnlId']);	
		}

		//Copy article type workflows
		if (isset($jnl_section) && (!empty($jnl_section) && in_array('jnl_workflow', $jnl_section)) || (empty($jnl_section)))
		{

						/*/*
						 * task#669-Flow based FTP export
						 * copy article type workflow based ftp to new article type workflow
						 */
						$newArtData['newJnlId'] = $newJnlData['newJnlId'];
						$oldArtTypData = new stdClass;
						$oldArtTypData->jnl_id = $oldJnlData->jnl_id;
						$oldArtTypData->jnl_fwm_id = $article_type->artp_fwm_id;
						$this->copy_ftp_journal_option($newArtData, $oldArtTypData, 'jnl_workflow');
						$workflowData = false;			
						if(isset($oldJnlData->jnl_fwm_id) && isset($article_type->artp_fwm_id) && $oldJnlData->jnl_fwm_id!=$article_type->artp_fwm_id)
						{
						//copy article workflow (not copying same as journal workflow using article worflow)
						$workflowData = $this->copy_journal_workflow($article_type->artp_fwm_id, $mast_flow_id);
		
						//Update stage forms
						if (!empty($copied_jnl_forms) && $workflowData == true)
							{
								$this->update_geric_stage_forms($mast_flow_id, $copied_jnl_forms);
							}
						//Customisation #1565JPR-120 : Email Templates: Global Email template
						//Associate email templates to article type workflow
						$this->associate_email_template_on_copy($newJnlData['newJnlId'], $mast_flow_id, $old_new_tmpl_id);
						}
		}
		//Update Article Terms
		if ( (!empty($jnl_section) && in_array('jnl_classification', $jnl_section)) || empty($jnl_section))
		{
			$cls_con="cls_artp_id='{$oldArticle_id}' and cls_jnl_id='{$newJnlData['newJnlId']}'";
		Classifications::update_record(array(
			'cls_artp_id' => $newArtId),$cls_con, $this->currentuser);
		}

		//comment code:Customisation #1565JPR-120 : Email Templates: Global Email template
		//Update Article email templates
		//Update journals users
		if ( (!empty($jnl_section) && in_array('jnl_users', $jnl_section)) || empty($jnl_section))
		{
			$users_con="usrj_artp_id='{$oldArticle_id}' and usrj_jnl_id='{$newJnlData['newJnlId']}'";
		User_to_journals::update_record(array(
			'usrj_artp_id' => $newArtId), $users_con, $this->currentuser);
		}

		//copy article permission assignments
		if ( (!empty($jnl_section) && in_array('jnl_permissions', $jnl_section)) || empty($jnl_section))
		{
		Assign_permission::move_user_assgmnt($oldJnlData->jnl_id, $oldArticle_id, $this->currentuser['user_id'], $newJnlData['newJnlId'], $newArtId);
		}
	}

	if (!empty($new_article_ids))
	{ //update parent article ids
		foreach ($new_article_ids as $article_id)
		{
			$con_artp="artp_id='{$article_id}'";
			$article_parents =Article_types::get_single_record("artp_parent_artp_id", $con_artp);
			$parent_ids = explode(',', $article_parents->artp_parent_artp_id);
			$getId = array();
			foreach ($parent_ids as $ids)
			{
				$old_con="artp_old_art_type_id='{$ids}'";
				$art_id = Article_types::get_single_record("max(artp_id) as artp_id", $old_con);
				$getId[] = $art_id->artp_id;
			}
			if (!empty($getId))
			{ //update parent id with new article type id for new jrnl article
				$new_parent_ids = implode(',', $getId);
				Article_types::update_record(array(
					'artp_parent_artp_id' => $new_parent_ids), $con_artp, $this->currentuser);
			}
		}
	}
}
	private function associate_email_template_on_copy($new_jrnl_id, $master_flow_id, $old_new_tmpl_id)
	{
		$this->currentuser = $this->get_current_user_details();
		$stage_con="jwf_fwm_id='{$master_flow_id}'";
		$all_stages = Generic_flows::get_all_records('jwf_id, jwf_temp_id', $stage_con);
		if (!empty($all_stages))
		{
			$insert_data = array();
			foreach ($all_stages as $stg)
			{
				$asoc_tmpls = Stage_email_tmpl_reference::get_associate_email_templates('stage_etmp_id,stage_etmp_journal_id,setr_stage_etmp_id', '', $stg->jwf_temp_id);
				foreach ($asoc_tmpls as $tmpls)
				{
					$setr_tmpl_id = NULL;
					if (empty($tmpls->stage_etmp_journal_id))
					{
						$setr_tmpl_id = $tmpls->stage_etmp_id;
					}
					elseif (isset($old_new_tmpl_id[$tmpls->setr_stage_etmp_id]))
					{
						$setr_tmpl_id = $old_new_tmpl_id[$tmpls->setr_stage_etmp_id];
					}
					if (!empty($setr_tmpl_id))
					{
						$insert_data[] = array(
							'setr_jwf_id' => $stg->jwf_id,
							'setr_stage_etmp_id' => $setr_tmpl_id,
							'setr_posted_date' => date('Y-m-d H:i:s'),
							'setr_posted_by' => $this->currentuser['user_id'],
							'setr_proxy_id' => $this->currentuser['proxy_user_id'],
							'setr_operation' => 'i'
						);
					}
				}
			}
			if (!empty($insert_data))
				Stage_email_tmpl_reference::insert_batch($insert_data);
		}
	}
	public function copy_article_type_description($newArtTypeId, $oldArticle_id,$newJnlData)
	{
		$this->currentuser = $this->get_current_user_details();
		//get journal_settings table field names
		$jnl_set_fields =Required_file_type::get_field_names();

		$insert_fields = implode(',', $jnl_set_fields);
		$insert_fields = str_replace('rft_id,', '', $insert_fields);

		$select_fields = implode(',', $jnl_set_fields);
		$select_fields = str_replace('rft_id,', '', $select_fields);
		$select_fields = str_replace('rft_jnl_id', $newJnlData['newJnlId'], $select_fields);
		$select_fields = str_replace('rft_artp_id', $newArtTypeId, $select_fields);

		$select_fields = str_replace('rft_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('rft_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newartData = Required_file_type::copy_article_type_description($insert_fields, $select_fields, $oldArticle_id);
		return $newartData;
	}

	public function copy_article_type_options($newArtTypeId, $oldArticle_id, $jnl_section = array())
	{
		$this->currentuser = $this->get_current_user_details();
		//get article type advanced option table field names
		$art_type_option_fields =Article_type_advance_options::get_field_names();

		$insert_fields = implode(',', $art_type_option_fields);
		$insert_fields = str_replace('atotp_id,', '', $insert_fields);

		$select_fields = implode(',', $art_type_option_fields);

		$select_fields = str_replace('atotp_id,', '', $select_fields);
		$select_fields = str_replace('atotp_artp_id', $newArtTypeId, $select_fields);
		$select_fields = str_replace('atotp_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('atotp_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$advanced_option_fields = array();
		if (!empty($jnl_section) && !in_array('jnl_setting', $jnl_section))
		{
			$advanced_option_fields = array(
				'atotp_file_type',
				'atotp_paper_length',
				'atotp_review_method',
				'atotp_review_open_decision',
				'atotp_review_open_count',
				'atotp_file_description',
			//	'atotp_secondary_class',
			//	'atotp_cust_primary_class',
			//	'atotp_cust_secondary_class',
			//	'atotp_min_no_secondary_class',
			//	'atotp_max_no_secondary_class',
			//	'atotp_secondary_class_alias',
			//	'atotp_primary_class',
			//	'atotp_min_no_primary_class',
			//	'atotp_max_no_primary_class',
			//	'atotp_primary_class_alias',
			//	'atotp_classification_hierarchy',
				'atotp_min_keyword',
				'atotp_max_keyword',
				'atotp_user_input_keyword',
				'atotp_separate_adhoc_keywords',
				'atotp_suggest_reviewers',
				'atotp_suggest_reviewers_mandatory',
				'atotp_oppose_reviewers',
				'atotp_oppose_reviewers_mandatory',
				'atotp_ithauto_submissions',
				'atotp_ithsubmission_type',
				'atotp_plagiarism_checking',
				'atotp_co_authors_agreement',
				'atotp_research_integrity',
				'atotp_rvrisubmission_type',
				'atotp_rvriauto_submissions'
			);
		}

		if (!empty($jnl_section) && !in_array('jnl_classification', $jnl_section))
		{
			array_push($advanced_option_fields, 'atotp_secondary_class', 'atotp_cust_primary_class', 'atotp_cust_secondary_class', 'atotp_min_no_secondary_class', 'atotp_max_no_secondary_class', 'atotp_secondary_class_alias', 'atotp_primary_class', 'atotp_min_no_primary_class', 'atotp_max_no_primary_class', 'atotp_primary_class_alias', 'atotp_classification_hierarchy'
			);
		}

		if ( !empty($jnl_section) && !in_array('jnl_permissions', $jnl_section))
		{
			array_push($advanced_option_fields, 'atotp_add_notes', 'atotp_flag_articles', 'atotp_edit_articles', 'atotp_edit_article_files', 'atotp_transfer_article', 'atotp_rescind_article', 'atotp_rescind_review', 'atotp_reset_article', 'atotp_extend_task', 'atotp_edit_reviewer_count', 'atotp_manage_article', 'atotp_edit_user_details', 'atotp_add_user_note', 'atotp_add_user_attachemnts', 'atotp_user_flags', 'atotp_change_user_status', 'atotp_view_auditrail', 'atotp_change_usr_assigmnts', 'atotp_move_article_from_payment', 'atotp_rate_reviewer,atotp_auto_assign_role'
			);

		}

		if (!empty($advanced_option_fields))
		{
			foreach ($advanced_option_fields as $field)
			{
				$insert_fields = str_replace($field . ',', '', $insert_fields);
				$select_fields = str_replace($field . ',', '', $select_fields);
			}
		}


		Article_type_advance_options::copy_advanced_options($insert_fields, $select_fields, $oldArticle_id);
	}



	public function generate_jnl_code($type, $jnl_code, $slNo = 0, $new_jnl_id=NULL)
	{
		$slNo = ($slNo + 1);
		$newJnlCode = $jnl_code;
		if ( $type != 'art' )
		{
			$newJnlCode = 'Copy' . $slNo . '_' . $jnl_code;
		}
		if ($type == 'jnl')
		{
			$jnl_con="jnl_journal_code='{$newJnlCode}'";
			$jnl_count = Journals::get_single_record('count(*) as cnt',$jnl_con);
		}
		else
		{
			$atype_con="artp_abbr_article_type='{$newJnlCode}' and artp_jnl_id='{$new_jnl_id}'";
			$jnl_count = Article_types::get_single_record('count(*) as cnt', $atype_con);
		}

		if ($jnl_count->cnt == 1)
		{
			return $newJnlCode = $this->generate_jnl_code($type, $jnl_code, $slNo);
		}
		else
		{
			return $newJnlCode;
		}
	}
	public function generate_jnl_name($type, $jnl_name, $slNo = 0, $new_jnl_id=NULL)
	{

		$slNo = ($slNo + 1);
		$newJnlName = $jnl_name;
		if ( $type != 'art' )
		{
			$newJnlName = 'Copy' . $slNo . ' of ' . $jnl_name;
		}

		if ($type == 'jnl')
		{
			$jnl_con="jnl_journal_name='{$newJnlName}'";
			$jnl_count = Journals::get_single_record('count(*) as cnt',$jnl_con);
		}
		else
		{
			$atype_con="artp_article_type='{$newJnlName}' and artp_jnl_id='{$new_jnl_id}'";
			$jnl_count = Article_types::get_single_record('count(*) as cnt',$atype_con);
		}
		if ($jnl_count->cnt == 1)
		{
			return $newJnlName = $this->generate_jnl_name($type, $jnl_name, $slNo);
		}
		else
		{
			return $newJnlName;
		}
	}
	public function copy_usr_jnl($newJnlId, $oldJnlId, $user_id, $only_journal = FALSE)
	{
		$this->currentuser = $this->get_current_user_details();
		//get rvw_user_journals table field names
		$usrj_fields = User_to_journals::get_field_names();

		$insert_fields = implode(',', $usrj_fields);
		$insert_fields = str_replace('usrj_id,', '', $insert_fields);
		$insert_fields = str_replace('usrj_jnl_usr_role_tmp,', '', $insert_fields);

		$select_fields = implode(',', $usrj_fields);
		$select_fields = str_replace('usrj_id,', '', $select_fields);
		$select_fields = str_replace('usrj_jnl_usr_role_tmp,', '', $select_fields);
		$select_fields = str_replace('usrj_jnl_id', $newJnlId, $select_fields);
		$select_fields = str_replace('usrj_posted_by', $user_id, $select_fields);
		$select_fields = str_replace('usrj_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);
                $retire_role_status = NULL;
                if(isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y')
                {
                    $retire_role_status = 'n';
                }


		//#4474 bug in copying journal
		$newUsrjnl = User_to_journals::copy_user_journal($insert_fields, $select_fields, $oldJnlId, FALSE, NULL, NULL, $retire_role_status, $only_journal);
		return $newUsrjnl;
	}

	public function update_Journal_terms($newJnlId)
	{
		$this->currentuser = $this->get_current_user_details();
		$journal_terms = Classifications::get_all_records("*", "cls_jnl_id = '{$newJnlId}' AND cls_primary_id!='NULL' AND cls_old_cls_id IS NOT NULL");
		foreach ($journal_terms as $journal_term)
		{
			$cls_con="cls_old_cls_id='{$journal_term->cls_primary_id}'";
			$getId =Classifications::get_single_record("cls_id", $cls_con);

			if ($getId)
			{
				$update_con="cls_id='{$journal_term->cls_id}'";
			Classifications::update_record(array(
					'cls_primary_id' => $getId->cls_id,
				), $update_con, $this->currentuser);



			}
		}
		$clearcon="cls_jnl_id = '{$newJnlId}'";
			Classifications::update_record(array(
				'cls_old_cls_id'=>NULL), $clearcon, $this->currentuser);

	}


	public function copy_journal_workflow($old_flw_master_id, $new_flw_master_id)
	{
		//get journal_workflow table field names
		$jnl_wflw_fields = Generic_flows::get_field_names();
		$this->currentuser = $this->get_current_user_details();
		$insert_fields = implode(',', $jnl_wflw_fields);
		$insert_fields = str_replace('jwf_id,', '', $insert_fields);

		$select_fields = implode(',', $jnl_wflw_fields);
		$select_fields = str_replace('jwf_id,', '', $select_fields);
		$select_fields = str_replace('jwf_fwm_id', $new_flw_master_id, $select_fields);
		$select_fields = str_replace('jwf_temp_id', 'jwf_id', $select_fields);
		$select_fields = str_replace('jwf_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('jwf_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newJnlData = Generic_flows::copy_journal_workflow($insert_fields, $select_fields, $old_flw_master_id);
		$this->update_flow_stages($old_flw_master_id,$new_flw_master_id);
		return $newJnlData;
	}

	public function update_flow_stages($old_flw_master_id,$new_flw_master_id)
	{
		$con="jwf_fwm_id='{$new_flw_master_id}'";
		$work_flows = Generic_flows::get_all_records('*', $con);
		$temp_id = array(); //(old_id => new_id)
		if (!empty($work_flows))
		{
			foreach ($work_flows as $work_flow)
			{
				$temp_id[$work_flow->jwf_temp_id] = $work_flow->jwf_id;
			}
			//start updating old stag ids with new ids
			foreach ($work_flows as $article_flow)
			{
				$parent_stages = json_decode($article_flow->jwf_parent_stages);
				$parent_stages_arr=array();
				foreach ($parent_stages as $key => $parent_stages_id)
				{
					foreach ($temp_id as $old_stage_id => $new_stage_id)
					{
						if ($parent_stages_id == $old_stage_id)
						{
							array_push($parent_stages_arr,$new_stage_id);
						}
					}
				}
				$flow_con="jwf_id='{$article_flow->jwf_id}'";
				Generic_flows::update_record(array(
					'jwf_parent_stages' => json_encode($parent_stages_arr)), $flow_con,$this->currentuser);

				$child_stages = json_decode($article_flow->jwf_child_stages);
				$child_stage_arr=array();
				foreach ($child_stages as $key => $child_stages_id)
				{
					foreach ($temp_id as $old_stage_id => $new_stage_id)
					{
						if ($child_stages_id == $old_stage_id)
						{
							array_push($child_stage_arr,$new_stage_id);
						}
					}
				}
				Generic_flows::update_record(array(
					'jwf_child_stages' => json_encode($child_stage_arr)), $flow_con,$this->currentuser);
			}
			//Task 664 ICE ReView new stages
			$this->manage_advance_flow_movement_entries($old_flw_master_id,$new_flw_master_id,$temp_id);

		}
	}

	public function copy_jounal_generic_forms($new_flow_master_id, $new_jnl_id, $old_jnl_id)
	{
		$this->currentuser = $this->get_current_user_details();
		$new_forms = array();
		$forms_copy = Generic_forms::copy_journal_forms($new_jnl_id, $old_jnl_id, $this->currentuser['user_id']);
		if ($forms_copy == TRUE)
		{
			$copycon="gncf_jnl_id={$new_jnl_id}";
			$copied_new_forms = Generic_forms::get_all_records('gncf_id, gncf_old_id',$copycon);
			foreach ($copied_new_forms as $copied_form)
			{
				Generic_form_groups::move_generic_form_groups($copied_form->gncf_old_id, $copied_form->gncf_id, $this->currentuser['user_id']);

				Generic_form_elements::move_generic_form_elements($copied_form->gncf_old_id, $copied_form->gncf_id, $this->currentuser['user_id']);

				//update group id in  rvw_generic_form_elements tb
				Generic_form_elements::update_form_element_group($copied_form->gncf_id);
				//update group dependency elements rvw_generic_form_elements tb
				Generic_form_elements::update_form_element_dependency($copied_form->gncf_id);
				//clear old gfg id
				$form_con='gfg_gncf_id={$copied_form->gncf_id}';
				Generic_form_groups::update_record(array(
					'gfg_old_gfg_id' => NULL
					),$form_con,$this->currentuser);
				$new_forms[$copied_form->gncf_old_id] = $copied_form->gncf_id;
			}
		}
		if (!empty($new_forms))
		{
			$this->update_geric_stage_forms($new_flow_master_id, $new_forms);
		}
		return $new_forms;
	}
	public function update_geric_stage_forms($new_flow_master_id, $new_forms)
	{
		$this->currentuser = $this->get_current_user_details();
		$con="jwf_fwm_id='{$new_flow_master_id}'";
		$copied_flow_stages = Generic_flows::get_all_records('*', $con);
		foreach ($copied_flow_stages as $copy_flow_stage)
		{
			$stage_forms = json_decode($copy_flow_stage->jwf_forms);
			$updated_forms = array();
                        if(!empty($stage_forms))
                        {
                            foreach ($stage_forms as $stage_form)
                            {
                                    $updated_forms[] = isset($new_forms[$stage_form]) ? $new_forms[$stage_form] : $stage_form;
                            }
                        }
						$update_con="jwf_id='{$copy_flow_stage->jwf_id}'";
			Generic_flows::update_record(array(
				'jwf_forms' => json_encode($updated_forms)), $update_con, $this->currentuser);
		}
	}
	public function copy_ftp_journal_option($newJnlData, $oldJnlData, $ftp_type)
	{
		if(isset($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage) && ($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage == 'y'))
		{
			$ftp_set_fields = Ftp::get_field_names();

			$insert_fields = implode(',', $ftp_set_fields);
			$insert_fields = str_replace('ftp_id,', '', $insert_fields);

			$select_fields = implode(',', $ftp_set_fields);
			$select_fields = str_replace('ftp_id,', '', $select_fields);
			$select_fields = str_replace('ftp_jnl_id', $newJnlData['newJnlId'], $select_fields);

			if($ftp_type == 'jnl_option')
			{
				$newFtpSettings = Ftp::copy_ftp_journal_option($insert_fields, $select_fields, $oldJnlData);
			}
			else if($ftp_type == 'jnl_workflow')
			{
				$select_fields = str_replace('ftp_posted_by,', '0,', $select_fields);
				$newFtpSettings = Ftp::copy_ftp_journal_workflow($insert_fields, $select_fields, $oldJnlData);
				$this->update_ftp_option_in_flow_stages($newJnlData,$oldJnlData);
			}
		}
	}
	public function update_ftp_option_in_flow_stages($newJnlData,$oldJnlData)
	{
		$this->currentuser = $this->get_current_user_details();
		$condition="jwf_fwm_id='".$newJnlData['mast_flow_id']."'";
		$work_flows = Generic_flows::get_all_records('*', $condition);
		$temp_wrk_flw_id = '';
		if (!empty($work_flows))
		{
			foreach ($work_flows as $work_flow)
			{
				$temp_wrk_flw_id = $work_flow->jwf_temp_id;
				$new_wrk_flw_id  = $work_flow->jwf_id;
				$updatecon="ftp_jwf_id={$temp_wrk_flw_id} and ftp_posted_by='0'";
				Ftp::update_record(
					array(
					'ftp_jwf_id' => $work_flow->jwf_id
						), $updatecon,$this->currentuser);
			}
		}
	}
	public function copy_jnl_basic_data($journal_form_data)
	{
		$newJnlData = array();
		$newJnlCode = $journal_form_data['jnl_journal_code'];
		$newJnlName = $journal_form_data['jnl_journal_name'];

		$journal_desc = 'Flow of ' . $newJnlName;
		$this->currentuser = $this->get_current_user_details();
		//for getting master flow tb id (FLOW)
		$mast_flow_id = Flow_master::insert_record(array(
			'fwm_description' => $journal_desc
			), $this->currentuser);
		$newJnlData['mast_flow_id'] = $mast_flow_id;

		//insert Journal
		$journal_form_data['jnl_fwm_id'] = $mast_flow_id;
		$newJnlId = Journals::insert_record($journal_form_data, $this->currentuser);

		$newJnlData['newJnlId'] = $newJnlId;
		$newJnlData['newJnlCode'] = $newJnlCode;
		$newJnlData['newJnlName'] = $newJnlName;
		return $newJnlData;
	}
	public function copy_journal_settings($newJnlData, $oldJnlId, $journal_settings_form_data, $jnl_section)
	{
		$jnlSettingsData = array();
		$jnlSettingsData['old_jnl_id'] = $oldJnlId;
		$this->currentuser = $this->get_current_user_details();
		//get journal_settings table field names
		$jnl_set_fields = Journal_settings::get_field_names();
		$common_permission=array();
		$insert_fields = implode(',', $jnl_set_fields);
		$insert_fields = str_replace('jset_id,', '', $insert_fields);
		$select_fields = implode(',', $jnl_set_fields);
		$select_fields = str_replace('jset_id,', '', $select_fields);
		$select_fields = str_replace('jset_jnl_id', $newJnlData['newJnlId'], $select_fields);

		$select_fields = str_replace('jset_login_user_type', "'" . $journal_settings_form_data['jset_login_user_type'] . "'", $select_fields);
		$select_fields = str_replace('jset_date_format', "'" . $journal_settings_form_data['jset_date_format'] . "'", $select_fields);
		$select_fields = str_replace('jset_min_keyword', $journal_settings_form_data['jset_min_keyword'], $select_fields);
		$select_fields = str_replace('jset_max_keyword', $journal_settings_form_data['jset_max_keyword'], $select_fields);
		$select_fields = str_replace('jset_user_input_keyword', "'" . $journal_settings_form_data['jset_user_input_keyword'] . "'", $select_fields);

		$select_fields = str_replace('jset_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('jset_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);
		//section based jnl copy - jnl option settings
		if (isset($jnl_section) && !empty($jnl_section))
		{
			$field_set = array();
			if (!in_array('jnl_setting', $jnl_section))
			{
				$field_set = [
					'jset_file_type',
					'jset_file_description',
					'jset_paper_length',
					'jset_review_method',
					'jset_review_open_decision',
					'jset_review_open_count',
					'jset_suggest_reviewers',
					'jset_suggest_reviewers_mandatory',
					'jset_oppose_reviewers',
					'jset_oppose_reviewers_mandatory',
					'jset_co_authors_agreement',
					'jset_plagiarism_checking',
					'jset_default_ithapi_folder',
					'jset_ithsubmission_type',
					'jset_ithauto_submissions',
					'jset_enable_publons',
					'jset_enable_figshare',
					'jset_editorial_production_assistant',
					'jset_publons_key',
					'jset_license_type',
					'jset_license_id',
					'jset_reviewer_connect_limit',
					'jset_reviewer_connect_search_years',
					'jset_enable_reviewer_connect',
                    'jset_notification_message',
					'jset_author_confirmation_bw_article_types',
					'jset_author_confirmation_jnl',
					'jset_classification_selection_mode',
					'jset_min_classification',
					'jset_max_classification',
					'jset_title_length',
					'jset_batch_decision',
					'jset_batch_reviews',
					'jset_research_integrity',
					'jset_rvrisubmission_type',
					'jset_rvriauto_submissions'
				];
			}

			if (!in_array('jnl_classification', $jnl_section))
			{
				array_push($field_set, 'jset_custom_classification',   'jset_classification_hierarchy', 'jset_classification', 'jset_classification_title');
				// array_push($field_set, 'jset_cust_primary_class', 'jset_cust_secondary_class', 'jset_secondary_class', 'jset_min_no_secondary_class', 'jset_max_no_secondary_class', 'jset_secondary_class_alias', 'jset_classification_hierarchy', 'jset_primary_class', 'jset_min_no_primary_class', 'jset_max_no_primary_class', 'jset_primary_class_alias'
				// );
			}

			if (!in_array('jnl_permissions', $jnl_section))
			{
				array_push($common_permission,'jset_add_notes','jset_flag_articles','jset_edit_articles','jset_edit_article_files', 'jset_transfer_article','jset_rescind_article','jset_rescind_review','jset_reset_article','jset_view_auditrail', 'jset_view_email_log','jset_stage_manual_reminder','jset_extend_task','jset_edit_reviewer_count','jset_view_file_inventory','jset_view_article_pdf','jset_auto_assign_role','jset_change_usr_assigmnts','jset_move_article_from_payment','jset_reinstantiate_payment','jset_rate_reviewer');

				array_push($field_set, 'jset_proxy_login', 'jset_email_permission', 'jset_create_article_stub',          'jset_manage_article', 'jset_edit_user_details', 'jset_add_user_note', 'jset_add_user_attachemnts', 'jset_user_flags', 'jset_change_user_status', 'jset_batch_decision'
				);
			}

            if(!in_array('jnl_date_management', $jnl_section)){
                array_push($field_set, 'jset_tat_exclude_days', 'jset_tat_days_excluded');
            }

			if (!empty($field_set))
			{
				foreach ($field_set as $field)
				{

					$insert_fields = str_replace($field . ',', '', $insert_fields);
					$select_fields = str_replace($field . ',', '', $select_fields);
				}
			}
		}

		$newJnlData['settings_id'] = Journal_settings::copy_journal_settings($insert_fields, $select_fields, $jnlSettingsData);

		$this->copy_common_permissions($oldJnlId, $newJnlData, $common_permission,$jnl_section);
		return $newJnlData['settings_id'];
	}
	public  function copy_common_permissions($oldjnlid, $newjnldata, $common_permission,$jnl_section)
	{
		$classname = get_called_class();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
		$oldcriteria = "jnl_id='{$oldjnlid}'";
		$oldplatform_data = Journals::get_single_record('*', $oldcriteria);
		$criteria = "jnl_id='{$newjnldata['newJnlId']}'";
		$newplatform_data = Journals::get_single_record('*', $criteria);
		$this->currentuser = $this->get_current_user_details();
		$jounal_name = $newplatform_data->jnl_journal_name;
		$permission_desc = "Permission of $jounal_name";
		$mast_permission_id = Journal_permission_master::insert_record(array(
			'jpm_description' => $permission_desc
		), $this->currentuser);
		//update permissionid in journal table
		$update_data['jnl_jpm_id'] = $mast_permission_id;
		$jnlid = 'jnl_id=' . $newjnldata['newJnlId'];
		Journals::update_record($update_data, $jnlid, $this->currentuser);
		if (isset($jnl_section) && !empty($jnl_section) && !in_array('jnl_permissions', $jnl_section))
		{
			$sql = "insert into " . $journal_permission_table . " (jp_jpm_id,jp_view_file_inventory,jp_add_notes,jp_auto_assign_role,jp_posted_by
			)". "select " . $mast_permission_id . ",jp_add_notes,jp_view_file_inventory,jp_auto_assign_role,jp_posted_by from " . $journal_permission_table . " where jp_jpm_id=" . $oldplatform_data->jnl_jpm_id;
		}else {
		//copy journal permissions
		// task #3137 removed the permission jp_imported_article_assigner
		$sql = "insert into " . $journal_permission_table . " (jp_jpm_id,jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_forms,jp_edit_article_files,
jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_rate_reviewer,jp_blind_articles,jp_request_rescind,jp_import_article,jp_view_research_integrity_report,jp_suspecious_activity,jp_prevent_edit,jp_posted_by
)"
		. "select " . $mast_permission_id . ",jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_forms,jp_edit_article_files,
jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_rate_reviewer,jp_blind_articles,jp_request_rescind,jp_import_article,jp_view_research_integrity_report,jp_suspecious_activity,jp_prevent_edit,jp_posted_by from " . $journal_permission_table . " where jp_jpm_id=" . $oldplatform_data->jnl_jpm_id;
		}		
DB::select($sql);
		$id = DB::connection()->getPdo()->lastInsertId();
		return $id;
	}

	public function copy_journal_description($newJnlData, $oldJnlData)
	{
		$jnlSettingsData = array();
		$jnlSettingsData['old_jnl_id'] = $oldJnlData;
		$this->currentuser = $this->get_current_user_details();
		//get journal_settings table field names
		$jnl_set_fields = Required_file_type::get_field_names();

		$insert_fields = implode(',', $jnl_set_fields);
		$insert_fields = str_replace('rft_id,', '', $insert_fields);

		$select_fields = implode(',', $jnl_set_fields);
		$select_fields = str_replace('rft_id,', '', $select_fields);
		$select_fields = str_replace('rft_jnl_id', $newJnlData['newJnlId'], $select_fields);


		$select_fields = str_replace('rft_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('rft_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newJnlData =Required_file_type::copy_journal_description($insert_fields, $select_fields, $jnlSettingsData);
		return $newJnlData;
	}

	public function copy_credential_ithenticate_journal($newJnlData, $oldJnlData)
	{
		$jnlSettingsData = array();
		$jnlSettingsData['old_jnl_id'] = $oldJnlData;
		$this->currentuser = $this->get_current_user_details();
		//get journal_settings table field names
		$jnl_set_fields = Api_credentials::get_field_names();

		$insert_fields = implode(',', $jnl_set_fields);
		$insert_fields = str_replace('acrd_id,', '', $insert_fields);

		$select_fields = implode(',', $jnl_set_fields);
		$select_fields = str_replace('acrd_id,', '', $select_fields);
		$select_fields = str_replace('acrd_jnl_id', $newJnlData['newJnlId'], $select_fields);


		$select_fields = str_replace('acrd_posted_by', $this->currentuser['user_id'], $select_fields);
		$select_fields = str_replace('acrd_posted_date', '"' . date('Y-m-d H:i:s') . '"', $select_fields);

		$newJnlData =Api_credentials::copy_credential_ithenticate_journal($insert_fields, $select_fields, $jnlSettingsData);
		return $newJnlData;
	}
	//available journal abbreviation
	public function check_journal_code(Request $request)
	{

		try {

			$journal_data = $request->all();
			$validator = Validator::make($request->all(), [
                'platform_code' => 'required'
            ]);

			if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
			$condition = "";
			if (!empty($journal_data) && isset($journal_data['platform_code'])) {
					$code = $journal_data['platform_code'];

					//standalone_group  is y the it check standalone_group otherwise journal code
					if (isset($journal_data['standalone_group']) && $journal_data['standalone_group'] == 'y')
					{
						$condition = "jnl_standalone_group='{$code}'";
					}
					else
					{
						$condition = "jnl_journal_code='{$code}'";
					}

					if (isset($journal_data['hdn_journal_id']) && $journal_data['hdn_journal_id'] != '') {
							$platform_id = $journal_data['hdn_journal_id'];
							$condition .= " AND jnl_id!={$platform_id}";
						}
				}

			$journal = Journals::get_single_record('count(jnl_id) cnt', $condition);

			if ($journal->cnt > 0) {
					$return_array['found'] = true;

				} else {
					$return_array['found'] = false;

				}
				return $this->success("Success",200,$return_array);
		} catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}

	public function check_journal_name(Request $request)
	{
		try {
			$condition = '';
			$bind_arr = array();

			//$journal_name
			$journal_data = $request->all();

			$validator = Validator::make($request->all(), [
                'platform_name' => 'required'
            ]);

			if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }

			if (!empty($journal_data) && isset($journal_data['platform_name'])) {
				$platform_name=trim($journal_data['platform_name']);
					//$condition='jnl_journal_name="'.$platform_name.'"';
					$condition='jnl_journal_name=?';
					$bind_arr[]=$platform_name;
					if (isset($journal_data['hdn_journal_id']) && $journal_data['hdn_journal_id'] != '') {
							//$condition.="jnl_id <> {$journal_data['hdn_journal_id']}";
							$condition.=" AND jnl_id <> ?";
							$bind_arr[]=$journal_data['hdn_journal_id'];
						}
				}
			$journal =Journals::get_single_record('count(jnl_id) cnt', $condition,NULL,NULL,NULL,$bind_arr);
			if ($journal->cnt > 0) {
				$return_array['found'] = true;
			} else {
				$return_array['found'] = false;
			}
			return $this->success("Success",200,$return_array);
		}catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
public function get_copyright_license_stmts(Request $request){

	try
	{
		$validator = Validator::make($request->all(), [
			'platform_id'      => 'required',
			'licence_type'      => 'required',
		]);
		if ($validator->fails()) {
			return  $this->failure('Failed', 422, $validator->errors());
		}
		  $post_data=$request->all();
		  $license_type = $post_data['licence_type'];
		  $jnl_id = $post_data['platform_id'];

	    $where='';
		$return_arr = array();
		$data = array();
		$bind_arr = [];
		if ($license_type != "all")
		{
			// $where="crtm_payment='{$license_type}'";
			$where="crtm_payment= ?";
			$bind_arr = [$license_type];
		}

		$copyright_stmts =Copyright_master::get_all_records('crtm_id, crtm_license_name', $where,binding_arr:$bind_arr);

		// $condition="jset_jnl_id={$jnl_id}";
		$condition="jset_jnl_id= ?";
		$jnl_licenses_id =Journal_settings::get_single_record('jset_license_type, jset_license_id',$condition,binding_arr:[$jnl_id]);

		$return_arr['jnl_copyrights_id'] = '';
		$return_arr['status'] = "failed";

		if (!empty($copyright_stmts))
		{
			$return_arr['status'] = "success";
		}

		if (!empty($jnl_licenses_id))
		{
			$return_arr['jset_license_id'] =  $jnl_licenses_id->jset_license_id;
			$return_arr['jset_license_type'] =  $jnl_licenses_id->jset_license_type;
		}
		$return_arr['copyrights_list'] = $copyright_stmts;

		return $this->success("Success",200,$return_arr);

	}
	catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}

}
public function formatLicenseList(array $licenses) {
   // Bold each license name
    $licenses = array_map(fn($license) => "<b>$license</b>", $licenses);

    $count = count($licenses);

    if ($count === 1) {
        return $licenses[0];
    }

    if ($count === 2) {
        return implode(' and ', $licenses);
    }

    // For 3 or more items
    $last = array_pop($licenses);
    return implode(', ', $licenses) . ', and ' . $last;
}
public function save_option_settings(Request $request)
{
	try{
	   $options=$request->all();
	   // Task #3022 Remove ‘abstract’ field’ in article submission page
	   $remove_abstract_submission=false;
	   $proceedingArr  =   $this->fetch_client_proceeding_config_array('create-article');
	   if(!empty($proceedingArr)) {
		$remove_abstract_submission=isset($proceedingArr['remove_abstract_submission'])?$proceedingArr['remove_abstract_submission']:false;
	   }

		// Define the base rules that are common in both cases
		$validationRules = [
			'platform_licence_type' => 'required',
			'platform_review_method' => 'required',
			'platform_file_type_data' => 'required',
			'platform_filetype' => 'required',
			'platform_article_submission_type' => 'required',
		];

		// Conditionally add the rule only if needed
		if ($remove_abstract_submission === false) {
			$validationRules['platform_paper_length'] = 'required';
		}

		// Create the validator with the complete set of rules
		$validator = Validator::make($request->all(), $validationRules);


	$is_proceeding=$this->check_client_proceeding();

		if ($validator->fails()) {
			return  $this->failure('Failed', 422, $validator->errors());
		}
	   $this->currentuser=$this->get_current_user_details();
	   $pltform_id=$options['platform_id'];
	   if (isset($options['platform_article_submission_type']) && (!empty($options['platform_article_submission_type'])))
	   {
		   $article_submission_type = $options['platform_article_submission_type'];
	   }
	   $paper_length=0;
	   if(isset($options['platform_paper_length'])&&$options['platform_paper_length']!='')
	   {
		   $paper_length=$options['platform_paper_length'];
	   }
			$file_types = '';
			if (isset($options['platform_filetype']) && !empty($options['platform_filetype']))
			{
				$file_types = json_encode($options['platform_filetype']);
			}
			$platform_custom_classification='';

			if(isset($options['platform_custom_classification'])&&$options['platform_custom_classification']=='y')
			{
				$platform_custom_classification=$options['platform_custom_classification'];	
			}
			$validator = Validator::make($request->all(), [
                'platform_file_type_data' => 'required'
            ]);

			if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
			if(isset($options['platform_file_type_data']) && $options['platform_file_type_data'] != '')
			{
				$platform_file_type_data = $options['platform_file_type_data'];
			}
			if(!empty($platform_file_type_data))
				{
					$where_desp='rft_jnl_id='.$pltform_id. ' and rft_artp_id is NULL';
					Required_file_type::delete_records($where_desp,'', $this->currentuser);
					$desp_arr=array();
					foreach($platform_file_type_data as $ft)
					{
						$desp_data=array();
						$desp_data['rft_file_desp_id']=$ft['rft_file_desp_id'];
						$desp_data['rft_req_count']=$ft['rft_req_count'];
						// The system should automatically sort out all the uploaded files by Main doc, Figures, and then tables In Progress
						if(isset($this->current_client->functionality->cfty_sort_order_for_author_submission_uploads) && $this->current_client->functionality->cfty_sort_order_for_author_submission_uploads == 'y' && isset($ft['rft_sort_order']))
							$desp_data['rft_sort_order']=$ft['rft_sort_order'];
						else
							$desp_data['rft_sort_order']=0;
						$desp_data['rft_req_fld']='n';
						if($ft['rft_req_fld']== 'y'){
						$desp_data['rft_req_fld']='y';}
						$desp_data['rft_jnl_id']=$pltform_id;
						if (!in_array($desp_data, $desp_arr)) {
							array_push($desp_arr, $desp_data);
						}
					}
					Required_file_type::insert_batch($desp_arr);
				}
		if($this->current_client->modules->mdl_review_for_doc == 'y')
		{
			$options['platform_review_method'] = 'o';
			$options['platform_review_open_decision'] = 'n';
			$options['platform_suggest_reviewer'] = 'n';
			$options['platform_oppose_reviewer'] = 'n';
			$options['platform_licence_type'] = '';
			$options['platform_co_author_agreement'] = 'n';

		}
		if (isset($options['platform_article_submission_type']) && ($options['platform_article_submission_type'] != ''))
		{
			$article_submission_type = json_encode($options['platform_article_submission_type']);
		}
		$copyrights_id = '';
		if(isset($options['licence_type_id']) && $options['licence_type_id'] != '')
		{
			$copyrights_id = json_encode($options['licence_type_id']);
			$existingLicenseTypes = DB::table('rvw_copyright')
										->join('rvw_articles', 'rvw_copyright.crt_art_id', '=', 'rvw_articles.art_id')
										->join('rvw_article_types', 'rvw_articles.art_artp_id', '=', 'rvw_article_types.artp_id')
										->where('rvw_article_types.artp_jnl_id', $pltform_id)
										->distinct()
										->pluck('rvw_copyright.crt_crtm_id') // adjust the column name if necessary
										->toArray();
			$removedLicenseTypes = array_diff($existingLicenseTypes, $options['licence_type_id']);
			$removedLicenseNames = DB::table('rvw_copyright_master')
									->whereIn('crtm_id', $removedLicenseTypes)
									->pluck('crtm_license_name')
									->toArray();
			if (!empty($removedLicenseNames)) 
			{
				$licenseList=$this->formatLicenseList($removedLicenseNames);
				$plaform_type_flag=env('VITE_CONFERENCE_PROCEEDINGS')==true?'conference':'journal';
				// $licenseList = implode(', ', $removedLicenseNames);
				$warningMessage = customTrans('copyright.copyright_delete_wng_msg',['licenseList' => $licenseList,'journal'=>$plaform_type_flag]);
				// Use session flash or return as response
				return $this->Warning('Warnings',200,$warningMessage);
				exit;

			}
		}
		$plagiarism_checking = isset($options['platform_plagiarism_checking']) ? $options['platform_plagiarism_checking'] : 'n';
		$default_ithapi_folder = isset($options['platform_default_ithapi_folder']) ? $options['platform_default_ithapi_folder'] : '';
		$ithsubmission_type = isset($options['platform_ithsubmission_type']) ? $options['platform_ithsubmission_type'] : '';
		$ithauto_submissions = isset($options['platform_ithauto_submissions']) ? json_encode($options['platform_ithauto_submissions']) : NULL;
		$editorial_production_assistant=NULL;
		// Task #925 research integrity checking
		$research_integrity_checking = isset($options['platform_research_integrity_checking']) ? $options['platform_research_integrity_checking'] : 'n';
		$rvrisubmission_type = isset($options['platform_rvri_type']) ? $options['platform_rvri_type'] : '';
		$rvriauto_submissions = isset($options['platform_rvriauto_submissions']) ? json_encode($options['platform_rvriauto_submissions']) : NULL;
		
		if(isset($options['editorial_production_assistant']) && $options['editorial_production_assistant']!='' && !empty($options['editorial_production_assistant_text']))
		{
		$editorial_production_assistant =$options['editorial_production_assistant'];
		}
		$review_open_count = 0;
	
		if (isset($options) && $options['platform_review_open_decision'] == 'y')
			$review_open_count = $options['review_open_count'];
			$advance_setting_data = array(

				'jset_article_submission_type' => $article_submission_type,
				'jset_file_type' => $file_types,
				//'jset_file_description' => $file_descriptions,
				//'jset_submission_editor' => $article_format_editor,
				'jset_paper_length' =>$paper_length,
				'jset_title_length' => $options['platform_title_length'],//article title character length validation
				//'jset_submission_upload' => $article_format_upload,
				'jset_review_method' => $options['platform_review_method'],
				'jset_custom_blind_params' => $options['platform_review_method'] == 'c' ? $options['custom_blind_params'] : null,
				'jset_review_open_decision' => $options['platform_review_open_decision'],
				'jset_review_open_count' => $review_open_count,
				'jset_custom_classification' => $platform_custom_classification,
				// 'jset_cust_secondary_class' => $platform_custom_secondary_classification,
				// 'jset_secondary_class' => isset($options['platform_secondary_classification'])?$options['platform_secondary_classification']:'',
				// 'jset_min_no_secondary_class' =>  $minimum_secondary_classification_number,
				// 'jset_max_no_secondary_class' => $maximum_secondary_classification_number,
				// 'jset_secondary_class_alias' => $title_secondary_classification,
				'jset_classification' =>$options['platform_classification'],
				'jset_classification_title' =>$options['platform_classification_title'],
				// 'jset_min_no_primary_class' =>$minimum_primary_classification_number,
				// 'jset_max_no_primary_class' =>$maximum_primary_classification_number,
				// 'jset_primary_class_alias' => $title_primary_classification,
				//'jset_classification_hierarchy' => $classification_hierarchy,
				'jset_suggest_reviewers' => $options['platform_suggest_reviewer'],
				'jset_suggest_reviewers_mandatory' => $options['platform_suggest_reviewers_mandatory'],
				'jset_oppose_reviewers' => $options['platform_oppose_reviewer'],
				'jset_oppose_reviewers_mandatory' => $options['platform_oppose_reviewers_mandatory'],
				//'jset_reviewer_cmt_to_author' => $options['reviewer_cmt_to_author'],
				'jset_co_authors_agreement' => $options['platform_co_author_agreement'],
				'jset_plagiarism_checking' => $plagiarism_checking,
				'jset_default_ithapi_folder' => $default_ithapi_folder,
				'jset_ithsubmission_type' => $ithsubmission_type,
				'jset_ithauto_submissions' => $ithauto_submissions,
				'jset_editorial_production_assistant'=>$editorial_production_assistant,
				'jset_license_type' => $options['platform_licence_type'],
				'jset_license_id' => $copyrights_id,
				'jset_author_confirmation_bw_article_types'=> $options['platform_art_type_au_confirm'],
				'jset_author_confirmation_jnl' => $options['platform_journal_au_confirm'],
				// Task #925 research_integrity_checking
				'jset_research_integrity' => $research_integrity_checking,
				'jset_rvrisubmission_type' => $rvrisubmission_type,
				'jset_rvriauto_submissions' => $rvriauto_submissions
			);
			if($options['platform_classification'] == 'y'){
				$advance_setting_data['jset_min_classification'] = $options['platform_minimum_no_of_classifications'];
				$advance_setting_data['jset_max_classification'] = $options['platform_maximum_no_of_classifications'];
				$advance_setting_data['jset_classification_selection_mode'] = $options['classification_mode_check'];
			}
			if($this->current_client->modules->mdl_publons == 'y'){
				if($options['platform_publons_allow_credits'] =='y'){
					$advance_setting_data['jset_enable_publons'] = 'y';
					$advance_setting_data['jset_publons_key'] = $options['platform_publons_journal_api_key'];
				}else{
					$advance_setting_data['jset_enable_publons'] = 'n';
				}
			}
			if($this->current_client->functionality->cfty_reviewer_connect == 'y'){
				if($options['platform_publons_enable_reviwer_locator'] =='y'){
					$advance_setting_data['jset_enable_reviewer_connect'] = 'y';
					$advance_setting_data['jset_reviewer_connect_limit'] = $options['platform_publons_max_num_reviewer_suggestions'];
					$advance_setting_data['jset_reviewer_connect_search_years'] = $options['platform_publons_search_years'];
				}else{
					$advance_setting_data['jset_enable_reviewer_connect'] = 'n';
				}
			}
			/**
			 * Task 5299 iThenticate V2 feature
			 */
			if(isset($this->current_client->functionality->cfty_ithenticate_v2) && isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
			{
				if(isset($options['ithv2_viewsettings']))
					$advance_setting_data['jset_ith_v2_view_settings'] = json_encode($options['ithv2_viewsettings']);
				if(isset($options['ithv2_add_to_index']))
					$advance_setting_data['jset_ith_v2_add_to_index'] = json_encode($options['ithv2_add_to_index']);
				if(isset($options['ithv2_save_changes']))
					$advance_setting_data['jset_ith_v2_save_changes'] = json_encode($options['ithv2_save_changes']);
				
				//Task 7850  iThenticate v2 enhancement
				//$advance_setting_data['jset_eula'] = isset($options['ith_v2_eula']) && $options['ith_v2_eula']?'y':'n';
			}
			/*Task #1787 Due date in settings page */
			if (isset($this->current_client->functionality->cfty_conf_article_submission_due_date) && $this->current_client->functionality->cfty_conf_article_submission_due_date == 'y' && $is_proceeding == true && isset($options['art_submission_due_date'])){
				$date = new DateTime($options['art_submission_due_date']);
				$options['art_submission_due_date'] = $date->format('Y-m-d H:i:s');
				$advance_setting_data['jset_conf_duedate'] = $options['art_submission_due_date'];
			}
			/*end Task #1787 Due date in settings page */

			$criteria="jset_jnl_id={$pltform_id}";
			Journal_settings::update_record($advance_setting_data,$criteria,$this->currentuser);
			return $this->success("Success",201);

	}
	catch (\Exception $e) {

		return  $this->failure('Failed',500,$e);
	}

}

public function save_date_management_option(Request $request){
    try{
        $data = $request->all();
        $validator = validator::make($data, [
            "platform_id" => "required",
            "platform_tat_exclude_days" => "required | string",
            "platform_tat_exclude_days_special" => "array"
        ]);

        $validator->sometimes("platform_tat_exclude_days_weekends", "required ", function ($input) {
            return $input->platform_tat_exclude_days != 'i';
        });

        if($validator->fails()){
            return  $this->failure('Failed',422,$validator->errors());
        }

        $this->currentuser=$this->get_current_user_details();
        $platform_id = $data['platform_id'];

        #setting due date management options
        $exclude_days = 'i';
        $days_excluded = null;
        if(isset($data['platform_tat_exclude_days']) && $data['platform_tat_exclude_days'] != ''){
            $due_days_params = $this->get_due_days_params($data['platform_tat_exclude_days'], $data['platform_tat_exclude_days_weekends'] ?? null, $data['platform_tat_exclude_days_special'] ?? []);
            $exclude_days = $due_days_params['exclude_days'];
            $days_excluded = $due_days_params['days_excluded'];
        }
        #end of setting due date management options

        $update_arr = [
            'jset_tat_exclude_days' => $exclude_days,
            'jset_tat_days_excluded' => $days_excluded,
        ];

        $criteria="jset_jnl_id={$platform_id}";
	    Journal_settings::update_record($update_arr,$criteria,$this->currentuser);
	    return $this->success("Success",201);
    }
    catch(Exception $e){
	    return $this->failure(data: $e);
    }

}

public function dowload_date_manage_file(Request $request)
{
try{
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
	$post_data=$request->all();
	$date_format = $this->get_platform_date_format($post_data['jnl_id']);
	$date_format = $this->date_format_map($date_format);
	$jnl_date_form = Journal_settings::get_single_record('jset_date_format', "jset_jnl_id = '{$post_data['jnl_id']}' ")->jset_date_format;
	
    // Sample data
	$endDate = new DateTime();
        $startDate = clone $endDate;

        $startDate->modify('-5 days');

        $row = 1;
        while ($startDate <= $endDate) {
            $sheet->setCellValue('A' . $row, $startDate->format($jnl_date_form));
            $startDate->modify('+1 day');
            $row++;
        }

    // ... more data
if($post_data['file_format']=='ods')
{
	$writer = new Ods($spreadsheet);
	$filename = 'sample_import_file.ods';

}
else{
	$writer = new Xlsx($spreadsheet);
    $filename = 'sample_import_file.xlsx';

}
   

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
	$file_location = storage_path() . '/app/public/uploads' ;
	if (!file_exists($file_location))
	{
	mkdir($file_location, 0765, true);
	}
	$client_details = $this->get_client_details();
	$client_code = $client_details->clnt_client_code;
	$file_location = $file_location . DIRECTORY_SEPARATOR . $client_code. '-sample_import_file' . '.'.$post_data['file_format'];
                        $search_data['location']=$writer->save($file_location);
                        $search_data['file_path']=encrypt_link($file_location);
                        $search_data['filename']=basename($file_location);
						if (file_exists($file_location)) {
						response()->download($file_location);
						return $this->success('success',200,$search_data);
						} else {
							return response()->json(['message' => 'File not found'], 404);
						}
}
catch(Exception $e){
	return $this->failure(data: $e);
}


}

private function get_due_days_params($exclude_days, $weekdays_excluded = null, $special_days_excluded = []){
        $days_excluded = null;
        if($exclude_days !='i' ){
            $days = new stdClass;
            if($weekdays_excluded){
				if(gettype($weekdays_excluded) == "integer")
					$weekdays_excluded = [$weekdays_excluded];
                $days->w = $weekdays_excluded;
            }else{
                $days->w = [5,6];
            }
            if($exclude_days == 's' && !empty($special_days_excluded)){
                sort($special_days_excluded);
                $days->s = $special_days_excluded;
        }
        $days_excluded = json_encode($days);
    }

    return ['exclude_days' => $exclude_days, 'days_excluded' => $days_excluded];
}

public function get_platform_user_list(Request $request)
{

	try{
		$post_data=$request->all();
		$search_data=$post_data['paramsdet'];
		$return_array=array();
		$artp_id=null;
		$is_proceeding=$this->check_client_proceeding();
		if(isset($post_data['advanced_flag']) && $post_data['advanced_flag'] == TRUE)
		{
			$validator = Validator::make($request->all(), [
				'platform_id'      => 'required',
				'jnl_code'    => 'required',
				'type'    => 'required',
			]);
		}
		else if(isset($post_data['platformenviornment']) && $post_data['platformenviornment'] == 'outside')
		{

			$validator = Validator::make($request->all(), [
			'sort_field'    => 'required',
            'sort_order'    => 'required',
			'type'    => 'required',
			]);

		}
		else
		{
		$validator = Validator::make($request->all(), [
            'platform_id'      => 'required',
            'jnl_code'    => 'required',
            'sort_field'    => 'required',
            'sort_order'    => 'required',
            'type'    => 'required',
		]);
		}
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
		
			
		if(isset($post_data['platform_id'])&&$post_data['platform_id']!=''&&isset($post_data['type'])&&$post_data['type']!=''||(isset($post_data['platformenviornment']) && $post_data['platformenviornment'] == 'outside'))
		{
		$type=$post_data['type'];
		if (isset($post_data['article_id']))
		{
		$artp_id = $this->decrypt_data($post_data['article_id']);
		}
		$id=$post_data['platform_id']?? null;
		$limit = isset($post_data['per_page']) ? $post_data['per_page'] : 10;
		$users=array();
		$join_sub_query = '';
		$search_condition = ' AND usr_status != \'u\' ';
		$sort_field = $post_data['sort_field']?? 'userfullname';
        $sort_order = $post_data['sort_order']?? 'asc';
        $journal_name = $search_data['journal_name'] ?? null;
		$add_con='';
		$bind_arr = [];
		$bind_arr1 = [];
		$bind_arr2 = [];
		if (isset($search_data['user_name'])&&$search_data['user_name'] != '')
		{
			// $search_condition =  $search_condition . ' AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $search_data['user_name'] . '%"))';
			$search_condition =  $search_condition . ' AND (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER(:user_name))';
			$bind_arr['user_name'] = "%{$search_data['user_name']}%";
		}
		if (isset($search_data['user_role'])&&$search_data['user_role'] != '')
		{
			if ($type === 'a')
			{
				// $join_sub_query = 'SELECT usrj_usr_id FROM rvw_user_journals WHERE usrj_artp_id = '.$artp_id .' and usrj_role_id = '.decrypt_link($search_data['user_role']).' AND usrj_jnl_id = '.$id;
				$join_sub_query = 'SELECT usrj_usr_id FROM rvw_user_journals WHERE usrj_artp_id = :artp_id1 and usrj_role_id = :user_role AND usrj_jnl_id = :jnl_id1';
				$bind_arr2['artp_id1'] = $artp_id;
				$bind_arr2['user_role'] = decrypt_link($search_data['user_role']);
				$bind_arr2['jnl_id1'] = $id;
			}
            else if($type == 'all')
            {
				$add_con='out';
                // $join_sub_query = 'SELECT usrj_usr_id,usrj_jnl_id AS usrjrnl_id FROM rvw_user_journals WHERE usrj_artp_id IS NULL and usrj_role_id = '.decrypt_link($search_data['user_role']) .' GROUP BY usrj_usr_id';
                $join_sub_query = 'SELECT usrj_usr_id,usrj_jnl_id AS usrjrnl_id FROM rvw_user_journals WHERE usrj_artp_id IS NULL and usrj_role_id = :user_role GROUP BY usrj_usr_id,usrj_jnl_id';
				$bind_arr2['user_role'] = decrypt_link($search_data['user_role']);
            }
			else{
				// $join_sub_query = 'SELECT usrj_usr_id FROM rvw_user_journals WHERE usrj_artp_id IS NULL and usrj_role_id = '.decrypt_link($search_data['user_role']).' AND usrj_jnl_id = '.$id;
				$join_sub_query = 'SELECT usrj_usr_id FROM rvw_user_journals WHERE usrj_artp_id IS NULL and usrj_role_id = :user_role AND usrj_jnl_id = :jnl_id1';
				$bind_arr2['user_role'] = decrypt_link($search_data['user_role']);
				$bind_arr2['jnl_id1'] = $id;
			}
		}
		$search_from_advance = FALSE;
		if (isset($search_data['advanced_role_id'])&&$search_data['advanced_role_id'] != '')
		{
			// $search_condition .= ' AND role_id = '.$search_data['advanced_role_id'];
			$search_condition .= ' AND role_id = :advanced_role_id';
			$bind_arr['advanced_role_id'] = $search_data['advanced_role_id'];
			if(isset($search_data['search_item']))
			{
				// $search_condition .= ' AND LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $search_data['search_item'] . '%")';
				$search_condition .= ' AND LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER(:search_item)';
				$bind_arr['search_item'] = "%{$search_data['search_item']}%";
			}
			$search_from_advance = TRUE;
		}
		if(isset($search_data['user_email'])&&$search_data['user_email'] != '')
		{
			// $search_condition = $search_condition.' AND usr_email  LIKE "%'.$search_data['user_email'].'%"';
			$search_condition = $search_condition.' AND usr_email  LIKE :user_email';
			$bind_arr['user_email'] = "%{$search_data['user_email']}%";
		}
		if ($type === 'a')
		{
			// $select_condition_first = ' usrj_artp_id = ' . $artp_id;
			$select_condition_first = ' usrj_artp_id = :artp_id';
			$bind_arr1['artp_id'] = $artp_id;
			// $select_condition_second = 'AND b.jntm_artp_id = ' . $artp_id;
		}
        else if($type == 'all')
        {
            $select_condition_first = " `usrj_artp_id` is NULL ";
            // $select_condition_second = ' AND b.jntm_artp_id is NULL ';
        }
		else //journal
		{
			// $select_condition_first = ' `usrj_jnl_id` = ' . $id . '  AND `usrj_artp_id` is NULL';
			$select_condition_first = ' `usrj_jnl_id` = :jnl_id AND `usrj_artp_id` is NULL';
			$bind_arr1['jnl_id'] = $id;
			// $select_condition_second = 'AND b.jntm_jnl_id = ' . $id . ' AND b.jntm_artp_id is NULL';
		}

		if (!empty($users))
		{
			$user_condition_first = " and usr_id IN ('" . implode("','", $users) . "' )";
		}
		else
		{
			$user_condition_first = '';
		}

        if($journal_name)
        {
            // $search_condition .= " AND jnl_journal_name like '%{$journal_name}%' ";
            $search_condition .= " AND jnl_journal_name like :journal_name";
			$bind_arr['journal_name']="%$journal_name%";
        }
        //     $sub_select = ", (SELECT
        //     COUNT(jucl_id)
        //   FROM
        //   {$user_journal_classification_table} a
        //     JOIN {$journal_terms_table} b
        //       ON a.jucl_jntm_id = b.jntm_id
        //       {$select_condition_second}
        //    WHERE a.jucl_usr_id = tb1.usrj_usr_id) AS classification_count";

			   DB::enableQueryLog();
			   $select_sql="tb1.usrj_usr_id AS user_id,tb1.usrj_jnl_id AS jnlid,
			   GROUP_CONCAT(DISTINCT jnl_journal_name SEPARATOR ',') jnl_journal_name,
			   GROUP_CONCAT(DISTINCT usrj_role_id SEPARATOR ',') role_ids,
			   GROUP_CONCAT(DISTINCT role_name SEPARATOR ',') role_names,
			   GROUP_CONCAT(DISTINCT role_assigned_role SEPARATOR ',') role_assigned_role,
			   GROUP_CONCAT(DISTINCT role_name,'\t',usrj_role_retired) role_retire_status,
			   CONCAT(
				 usr_first_name,
				 ' ',
				 usr_last_name
			   ) AS userfullname,
			   usr_email AS user_email,
			   usrj_jnl_id jnl_id,
               usrj_artp_id artp_id ";
			   $bind_arr = array_merge($bind_arr2,$bind_arr1,$bind_arr);
			   $condition=$select_condition_first.$user_condition_first.$search_condition;
		$journal_users=User_to_journals::get_user_assigned_role_based_platform($select_sql,$condition,$limit,$sort_field,$sort_order,$join_sub_query,$add_con,binding_arr:$bind_arr);
		foreach ($journal_users as $journaluser) {
			if($journaluser->user_id)
			{
				$displayArray = array(
					'user_id' => $journaluser->user_id,
					'jnl_code' => $post_data['jnl_code']??null,
					'flag'     => TRUE,
					'article_id' => $artp_id ?? $journaluser->artp_id ?? null,
					'availability' => TRUE,
					'save_coauthor' => FALSE,
					'remove_user' => FALSE,
					'source' => FALSE,
					'salutation' => TRUE,
					'flag_only' => FALSE,
					'inactive_user' => FALSE,
					'fullname_only' => FALSE,
					'journal_id' => $post_data['platform_id']??null,
				);
				if($search_from_advance = TRUE)
				{
					$displayArray['salutation'] = FALSE;
				}
				$journaluser->userfullname = $this->get_user_display_name($displayArray );
				$journaluser->evu_id = null;
				$event_already_exists    =   Event_invited_users::get_single_record_with_bind_cond('evu_id', array('evu_jnl_id' =>$journaluser->jnlid, 'evu_user_id'=>$journaluser->user_id, 'evu_submit_status' => 'i'));
				if (isset($event_already_exists) && !empty($event_already_exists))
				{
					$journaluser->evu_id = $event_already_exists->evu_id;
				}
			}
		}
		   $return_array['all_roles'] = Roles::get_all_records();
           $return_array['jnl_users']=$journal_users;
		   // for AIPP article import
		   $return_array['maxuserimprowlmt'] = '';
		   if($is_proceeding == true){
			   $return_array['maxuserimprowlmt'] = Consts::MaxUserImpRowLmt;
		   }

		   //fetch the client's proceeding config array
		   $proceedingArr  =   $this->fetch_client_proceeding_config_array('user-with-roles');
		   $return_array['proceeding_arr'] = $proceedingArr;

		return $this->success('success',200,$return_array);
		}
		else
		{
		return $this->warning('failed',402,$return_array);
		}
	}
	catch (\Exception $e) {

		return  $this->failure('Failed',500,$e);
	}

}
 public function remaining_user_list(Request $request)
 {
	 try
	 {
	$post_data=$request->all();
	$validator = Validator::make($request->all(), [
		'platform_id'      => 'required',
	]);

	if ($validator->fails()) {
		return  $this->failure('Failed', 422, $validator->errors());
	}
	$search_parameters = $post_data['paramsdet'];
	$user_to_journal_table=(new \App\Models\User_to_journals())->getTable();
	$type=$post_data['type'];
	$platform_id=$post_data['platform_id'];

	if ($type === 'a')
	{

		$id=$this->decrypt_data($platform_id);
		$check_column = 'usrj_artp_id = ?';

	}
	else
	{
		$id=$platform_id;
		$check_column = 'usrj_jnl_id = ? and usrj_artp_id is null';
	}
	$where_cnd = array(
		'jnl_id'=> $id
	);
	$jnl_data = Journals::get_single_record_with_bind_cond('jnl_id,jnl_journal_status,jnl_article_submission_status,jnl_standalone',$where_cnd);

	$stndalon_jnl_id = 0;
	if (isset($jnl_data) && !empty($jnl_data) && isset($jnl_data->jnl_standalone) && $jnl_data->jnl_standalone == 'y')
	{
	$stndalon_jnl_id = $jnl_data->jnl_id;
	}
	$bind_arr =[$id];
	$sql_condition_query='';
	$sql_condition_query .= 'usr_id NOT IN (select usrj_usr_id  from ' . $user_to_journal_table . ' where ' . $check_column . ')';
	$sql_condition_query .= ' AND (`usr_roles` NOT LIKE "%sudo%" OR `usr_roles` IS NULL )';
	$select='usr_id,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as full_name,usr_first_name,usr_middle_name,usr_last_name,usr_email';
	if ($sql_condition_query != '')
		$sql_condition_query .= ' AND usr_status = "a"';
	if (isset($search_parameters ['search_keyword']) && $search_parameters ['search_keyword'] != '' && !empty($search_parameters ['search_keyword']))
		{
			$user_to_journal_table=(new \App\Models\Userkeywords())->getTable();
			$Keyword_relationship=(new \App\Models\Keyword_relationship())->getTable();
			$Excluded_journal_keywords=(new \App\Models\Excluded_journal_keywords())->getTable();
			$key_method = isset($search_parameters ['jnl_sch_keyword_src_method'])?$search_parameters ['jnl_sch_keyword_src_method'] :"IN";
			$select_keys =array();
			foreach ($search_parameters ['search_keyword'] as $keywords) {
				if(isset($keywords['id']))
				{
				$select_keys[] = $keywords['id'];
				}
				}
				$placeholders =  implode(',',array_fill(0,count($select_keys),'?'));
				$bind_arr = array_merge($bind_arr,$select_keys);
			$hierachy = $this->current_client->functionality->cfty_keyword_hierarchy;

			$join_tb = $join_condition = '';

			$join_tb = ',' . $Keyword_relationship;
			if ($hierachy == "j")
			{
				$join_condition = ' AND kwdrl_kwd_id = ukwd_kwd_id AND kwdrl_jnl_id = ?';
				$bind_arr[] = $id;
			}
			else if ($hierachy == "c")
			{
				$join_condition = ' AND ukwd_kwd_id = kwdrl_kwd_id AND kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM ' .$Excluded_journal_keywords . ' where ejk_jnl_id= ?)';
				$bind_arr[] = $id;
			}

			$keyword_select_sql = 'select DISTINCT ukwd_usr_id from ' . $user_to_journal_table . $join_tb . ' WHERE ukwd_kwd_id IN('.$placeholders.') '. $join_condition;
			$sql_condition_query .= ' AND usr_id  ' . $key_method . ' (' . $keyword_select_sql . ')';
		}
	$limit = isset($post_data['per_page']) ? $post_data['per_page'] : 5;
	if (isset($search_parameters['username'])&&$search_parameters['username'] != '')
	{
	$sql_condition_query .= ' AND  (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER(?)) ';
	$bind_arr[] = "%{$search_parameters['username']}%";
	}
	if(isset($search_parameters['email'])&&$search_parameters['email'] != '')
	{
		$sql_condition_query .= ' AND  `usr_email` LIKE ?';
		$bind_arr[] = "%{$search_parameters['email']}%";
	}
	if ($stndalon_jnl_id > 0)
		{
			$sql_condition_query .= ' AND usr_jnl_standalone = ' . $stndalon_jnl_id;
		}
		else
		{
			$sql_condition_query .= ' AND usr_jnl_standalone IS NULL';
		}
	$remainig_users=User_to_journals::get_journal_user_list($select,$sql_condition_query,$limit,$bind_arr);
	$return_array['list']=$remainig_users;
	 return $this->success('success',200,$return_array);
	 }
	 catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}

 }

	public function save_user_permission_settings(Request $request)
	{
		try {

			$form_permission_data = $request->all();
			$jnl_id = (isset($form_permission_data['platform_id'])) ? $form_permission_data['platform_id'] : '';
			if ($form_permission_data['jnl_code'] != '') {
				$jnl_code = $this->decrypt_data($form_permission_data['jnl_code']);
				$criteria = "jnl_journal_code='{$jnl_code}'";
				$jnl_perm_id = Journals::get_single_record('jnl_jpm_id', $criteria);
				$perm_id= $jnl_perm_id->jnl_jpm_id;
				$this->currentuser = $this->get_current_user_details();
				$column_prefix = 'jset_';
				$condition = "jset_jnl_id='" . $jnl_id . "'";
				if (isset($form_permission_data['hdn_permission_art_typid'])) {
					$column_prefix = 'atotp_';
					$condition = "atotp_artp_id =" .$this->decrypt_data($form_permission_data['hdn_permission_art_typid']);
					$condition_art = "artp_id=". $this->decrypt_data($form_permission_data['hdn_permission_art_typid']);
				$artp_data = Article_types::get_single_record("artp_jpm_id", $condition_art);

					$perm_id= $artp_data->artp_jpm_id;
				}
				//Start--To save general permission, structure:input tag name=>table field name
				$common_permissions = array(
					"article_add_notes" => "add_notes",
					"article_flags" => "flag_articles",
					"article_edit" => "edit_articles",
					"edit_article_files" => "edit_article_files",
					"transfer_article" => "transfer_article",
					"rescind_article" => "rescind_article",
					"rescind_review" => "rescind_review",
					"generic_discussion"=>"generic_discussion",
					"reset_article" => "reset_article",
					"auditrail_article" => "view_auditrail",
					"emaillog_article" => "view_email_log",
					"stage_manual_reminder" => "stage_manual_reminder",
					"extend_task" => "extend_task",
					"edit_reviewer_count" => "edit_reviewer_count",
					"view_file_inventory" => "view_file_inventory",
					"view_article_pdf" => "view_article_pdf",
					"auto_assign_role" => "auto_assign_role",
					"change_usr_assigmnts" => "change_usr_assigmnts",
					"move_article_from_payment" => "move_article_from_payment",
					"reinstantiate_payment" => "reinstantiate_payment",
					"suspecious_activity" => "suspecious_activity",
					"rate_a_reviewer" => "rate_reviewer",
					"blind_articles" => "blind_articles",
					"download_review" => "download_review",
					"approve_prevent_user_edit" => "prevent_edit",
					"request_rescind" => "request_rescind",
					"import_article" => "import_article",
					"imported_article_assigner" => "imported_article_assigner"
				);

				//3313 - Editing forms after stage complete
				if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y')
				{
					$common_permissions['edit_article_forms'] = 'edit_article_forms';
				}
				/* Task #9425 Convey Integration In Review3*/
				if(isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y')
				{
					$common_permissions['view_disclosures'] = 'view_disclosures';
				}
				/* Task #9425 End */

				// Task #925 research_integrity_checking
				if(isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
				{
					$common_permissions['view_research_integrity_report'] = 'view_research_integrity_report';
				}

				foreach ($common_permissions as $key => $value) {
					$col_prefix = 'jp_';
					if (isset($form_permission_data[$key])) {
						$permission_array=[];
						if(!is_array($form_permission_data[$key]))
						{
						$permission_array = explode(",", $form_permission_data[$key]);
						}
						else
						{
							$permission_array=$form_permission_data[$key];
						}
						$newarray='["'. implode('", "', $permission_array). '"]';
						//$common_permission_sett_data[$col_prefix . $value] =count($permission_array)>0?json_encode($permission_array):NULL;
						$common_permission_sett_data[$col_prefix . $value] =count($permission_array)>0?($newarray):NULL;
					} else {
						$common_permission_sett_data[$col_prefix . $value] = NULL;
					}
				}
				$common_perm_condition = 'jp_jpm_id="' .$perm_id . '"';
				Journal_permission::update_record($common_permission_sett_data, $common_perm_condition, $this->currentuser);
				//End--To save general permission, structure:input tag name=>table field name

				if ($column_prefix == 'jset_') {
					//Start--To save journal permission in journal_settings tbl, structure:input tag name=>table field name
					$journal_permissions = array(
						"proxy_login" => "proxy_login",
						"email_users" => "email_permission",
						"edit_user_details" => "edit_user_details",
						"add_user_note" => "add_user_note",
						"add_user_attachemnts" => "add_user_attachemnts",
						"user_flags" => "user_flags",
						"change_user_status" => "change_user_status",
						// "create_article_stub" => "create_article_stub",
						"manage_issue" => "manage_issue",
						"add_article_to_issue" => "add_article_to_issue",
						"who_can_manage_article_type" => "manage_article_type",
						"manage_article" => "manage_article",
						"bulk_invite_submission" => "bulk_invite_submission",
						"who_can_manage_draft" => "draft_proposal_invite",
						"view_work_progress_report" => "view_work_progress_report",
						"blind_articles" => "blind_articles",
						"approve_prevent_user_edit" => "prevent_edit",
						"add_jats_export" => "jats_export",
						"who_can_do_batch_decisions" => "batch_decision",
						"who_can_do_batch_reviews" => "batch_reviews",
					);
					/* Task #3563 Collecting Supporting Documents for Conference - start*/
					if(isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y') {
						$journal_permissions['supportingdatapermission'] = 'showsupportingdata';
					}
					/* Task #3563 Collecting Supporting Documents for Conference - end*/
					if($this->current_client->functionality->cfty_submission_inprogress_view_article == 'y')
					{
						$journal_permissions['who_can_view_article_on_submission'] = 'view_article_on_submission';
					}
					// Checking article manage functionality is enabled or not
					$manage_functionality_enabled = ($this->current_client->functionality->cfty_enable_article_delete == 'y' || $this->current_client->functionality->cfty_enable_article_withdraw == 'y') ? true : false;

					foreach ($journal_permissions as $key => $value) {
						$col_prefix = 'jset_';
						$permission_array=array();
						$journal_permission_sett_data[$col_prefix . $value] = NULL;
						if (isset($form_permission_data[$key])) {
							if ($key == "manage_article" && !$manage_functionality_enabled) {
								continue;
							}
							$permission_array=[];
								if(!is_array($form_permission_data[$key]))
								{
								$permission_array = explode(",", $form_permission_data[$key]);
								}
								else
								{
									$permission_array=$form_permission_data[$key];
								}
								$newarray1='["'. implode('", "', $permission_array). '"]';
							$journal_permission_sett_data[$col_prefix . $value] = count($permission_array)>0?($newarray1):NULL;
						}
					}
				Journal_settings::update_record($journal_permission_sett_data, $condition, $this->currentuser);
					//End--To save journal permission in journal_settings tbl, structure:input tag name=>table field name
				}
					$return_array['status'] = 'success';
			//TASK #7560 The permission given in journal settings are not reflected in article type
			$article_data = Article_types::get_all_records_with_bind_cond('*', array('artp_jnl_id' => $jnl_id));
			$arttype_id=array();
			foreach ($article_data as $article) {
			if($jnl_perm_id->jnl_jpm_id == $article->artp_jpm_id)
			{
			$arttype_id[]=$article->artp_id;
			}
			
			}
			$asgm_artp_id = isset($form_permission_data['hdn_permission_art_typid']) ? $this->decrypt_data($form_permission_data['hdn_permission_art_typid']) : null;
			if(isset($form_permission_data['assign_data']) && count($form_permission_data['assign_data'])>0)
			{
				$this->save_assign_permission($form_permission_data,$arttype_id);

				$return_array['msg'] = ($column_prefix == 'jset_') ? customTrans('platform_settings.jnl_permission') : customTrans('platform_settings.art_permission');
			}
			if(isset($form_permission_data['assign_data']) && count($form_permission_data['remove_array'])>0)
			{
				$this->deleteAssignment($form_permission_data['remove_array'],$arttype_id,$asgm_artp_id);
			}
			//TASK #7560 The permission given in journal settings are not reflected in article type
			return $this->success('success',201,$return_array);
		}
		else{
			$return_array['status'] = 'failed';
			return $this->warning('failed',500,$return_array);
		}

		} catch (\Exception $e) {

			return  $this->failure('Failed',500,$e);

	}
}


	public function save_assign_permission($assg_role_set_data,$arttype_id =array())
	{
		$roledata=$assg_role_set_data['assign_data'];
		$this->currentuser=$this->get_current_user_details();
		$checkcondition="asgm_jnl_id ={$assg_role_set_data['platform_id']}";
		if(isset($assg_role_set_data['hdn_permission_art_typid']))
		{
			$perm_id=$this->decrypt_data($assg_role_set_data['hdn_permission_art_typid']);
			$checkcondition.=" AND asgm_artp_id ={$perm_id}";
		}
		else
		{
			$checkcondition.=" AND asgm_artp_id is null";
		}
				$assg_set_data["asgm_jnl_id"] = $assg_role_set_data['platform_id'];
				$assg_set_data["asgm_artp_id"] = isset($assg_role_set_data['hdn_permission_art_typid']) ? $this->decrypt_data($assg_role_set_data['hdn_permission_art_typid']) : NULL;
		// if (count($assg_role_set_data['roles_can_asgn']) === count($assg_role_set_data['assigned_role'])) {

		for ($i = 0; $i < count($roledata); $i++) {

			if (!empty($roledata[$i]['roles_can_asgn']) && !empty($roledata[$i]['assigned_role'])) {

					$assg_set_data["asgm_can_assgn_role"] = $roledata[$i]['roles_can_asgn'];
					$assg_set_data["asgm_assgnd_role"] = $roledata[$i]['assigned_role'];
					// $assg_set_data["asgm_assgnd_role"] = $this->decrypt_data($roledata[$i]['assigned_role']);

					$rolescanassign = $roledata[$i]['roles_can_asgn'];
					$rolesassigned = $roledata[$i]['assigned_role'];

					$checkcondition.= " AND asgm_can_assgn_role={$rolescanassign} AND asgm_assgnd_role={$rolesassigned}";

					$db_data = Assign_permission::get_single_record('count(*) cnt', $checkcondition);
					
					if ($db_data->cnt == 0) {
						if ($roledata[$i]["hdn_permission_asgmnt_id"] != "") {
							$asmnt_id =  $roledata[$i]["hdn_permission_asgmnt_id"];
							//TASK #7560 The permission given in journal settings are not reflected in article type
							if(!empty($arttype_id) && count($arttype_id)>0 && $assg_set_data["asgm_artp_id"] == null)
							{
							$assign_data=Assign_permission::get_single_record_with_bind_cond('asgm_can_assgn_role,asgm_assgnd_role,asgm_jnl_id', array('asgm_id' => $asmnt_id));
							$all_records=Assign_permission::get_all_records_with_bind_cond('GROUP_CONCAT(asgm_id) AS assignid',array('asgm_jnl_id'=>$assign_data->asgm_jnl_id,'asgm_can_assgn_role'=>$assign_data->asgm_can_assgn_role,
							'asgm_assgnd_role'=>$assign_data->asgm_assgnd_role));
							$condition_array = "asgm_id IN('" . $all_records[0]->assignid."')";
							}
							else
							{
								$condition_array = 'asgm_id=' . $asmnt_id;
							}
							Assign_permission::update_record($assg_set_data, $condition_array,$this->currentuser);
						} else {
							$insert_id = Assign_permission::insert_record($assg_set_data,$this->currentuser);
						
							if(!empty($arttype_id) && count($arttype_id)>0 && $assg_set_data["asgm_artp_id"] == null)
							{
								foreach ($arttype_id as $each_id) {

                                 $assg_set_data["asgm_artp_id"]= $each_id;
								 Assign_permission::insert_record($assg_set_data,$this->currentuser);
								 $assg_set_data["asgm_artp_id"]= null;
								 //TASK #7560 The permission given in journal settings are not reflected in article type

								}
							}
						}
					}
				}
		}
		
					// }
				return TRUE;

	}
    /*
   Upload Journal logo for advanced setting
    commited date :- 10-05-2022
    Requested type :- POST
    */
    public function upload_journal_logo(Request $request)
    {
        try {
			$validator = Validator::make($request->all(), [
				'jnlcode'      => 'required',
				'jnlid'    => 'required',
			]);

			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}
            if ($request->jnllogo) {
                $image =  $request->jnllogo;
				$width = getimagesize($image)[0]; // getting the image width
                $height = getimagesize($image)[1]; // getting the image height
				$client_default = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
				$client_defaults  = Config::get($client_default);
				$config_width=$client_defaults['jnl_logo_max_width'];
				$config_height=$client_defaults['jnl_logo_max_height'];
				$this->currentuser = $this->get_current_user_details();
				if($width >$config_width)
				{

					return $this->warning('Warnings',200,customTrans('platform_settings.max_width'));
					exit;
				}
				elseif($height > $config_height)
				{
					return $this->warning('Warnings',200,customTrans('platform_settings.max_height'));
					exit;
				}
                $name = $image->getClientOriginalName();
				$jnl_code =  decrypt_link($request->jnlcode);
				$jnl_id =  decrypt_link($request->jnlid);
				$path =$jnl_code . DIRECTORY_SEPARATOR;
				//echo public_path('uploads/'.$path.'thumbnail');exit;
				$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
				$uploaded_resize_path = storage_path() . $file_storage_path .'/uploads/'. $path;


				$uploaded_file_details=$this->upload_file_handler($path,$image, $name);
				$img = Image::make($image->getRealPath());
				Image::make($image->getRealPath())->save( $uploaded_resize_path.$name);
				$img->resize(125, 125, function ($constraint) {
					$constraint->aspectRatio();
				})->save( $uploaded_resize_path."thumb_".$name);
				// $img->resize(null, null, function ($constraint) {
				// 	$constraint->aspectRatio();
				// })->save( $uploaded_resize_path.$name);
				if ($this->current_client->enable_upload_s3_bucket == 'y') {
					$this->update_s3_files($path);
				}

                //$user->avatar = $name;
                $data['jnl_logo'] = $name;
                $jnlid = 'jnl_id=' . $jnl_id;
                Journals::update_record($data, $jnlid,$this->currentuser);
				return $this->success('success');
            }
		} catch (\Exception $e) {

			// DB::rollback();
			return $this->failure('Failure', 500, $e);
		}
	}


	public function get_all_roles_can_assign($role)
	{
		try {
			// $assigned = [];
			// $assign_array = array();
			// if (!empty($assigned)) {
			// 		foreach ($assigned as $key => $value) {
			// 				$new_array = (explode(",", $value));
			// 				if (array_key_exists($this->decrypt_data($new_array[0]), $assign_array)) {
			// 						array_push($assign_array[$this->decrypt_data($new_array[0])], $this->decrypt_data($new_array[1]));
			// 					} else {
			// 						$assign_array[$this->decrypt_data($new_array[0])] = [];
			// 						array_push($assign_array[$this->decrypt_data($new_array[0])], $this->decrypt_data($new_array[1]));
			// 					}
			// 			}
			// 	}
			$data = "role_id='{$role}'";
			$roles = Roles::get_single_record('role_assigned_role', $data);
			$role_assigned = $roles->role_assigned_role;

			$role_table = (new \App\Models\Roles())->getTable();
			$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
			$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";
			$roles_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
			$user_roles = Roles::get_records_by_raw_query($roles_sql);
			$priority_array = $this->RolesConfigdata('priority_roles')['priority_roles'];

			$final_role_array = array();
			$arr_assign = array();
			foreach ($priority_array as $key => $value) {
					if ($value['core_role'] == $role_assigned) {

							$parent_priority = $value['priority'];
						}
				}
			foreach ($user_roles as $rol) {
					foreach ($priority_array as $key => $value) {
							if ($value['core_role'] == $rol->role_assigned_role) {

									$child_priority = $value['priority'];
									if ($child_priority >= $parent_priority) {
											if ($rol->role_id != $role) {
													// if (array_key_exists($role, $assign_array) && !empty($assign_array)) {
													// 		if (!in_array($rol->role_id, $assign_array[$role])) {
													// 				$rol->role_id = $rol->role_id;
													// 				array_push($final_role_array, $rol);
													// 			}
													// 	} else {
															$rol->role_id = $rol->role_id;
															// $rol->role_id = $this->encrypt_data($rol->role_id);
															array_push($final_role_array, $rol);
														// }
												}
										}
								}
						}
				}
			return $final_role_array;
		} catch (\Exception $e) {
			// DB::rollback();
			return;
		}
	}
	public function get_roles_can_assign(Request $request)
	{

		try {
		$post_data=$request->all();

		$role = $this->decrypt_data($post_data['role']);
		$assigned = isset($post_data['assigned_roles'])?$post_data['assigned_roles']:[];

		$assign_array = array();
		if(!empty($assigned))
		{
		foreach($assigned as $key => $value)
		{
		  $new_array=(explode(",",$value));
		  if(array_key_exists($new_array[0],$assign_array))
		  {
			  array_push($assign_array[$new_array[0]],$new_array[1]);
		  }
		  else
		  {
			  $assign_array[$new_array[0]] = [];
			  array_push($assign_array[$new_array[0]],$new_array[1]);
		  }
		}
		}
		$data = "role_id='{$role}'";
		$roles = Roles::get_single_record('role_assigned_role', $data);
		$role_assigned = $roles->role_assigned_role;

		$role_table = (new \App\Models\Roles())->getTable();
		$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
		$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";



		$roles_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
		$user_roles = Roles::get_records_by_raw_query($roles_sql);

		$priority_array=$this->RolesConfigdata('priority_roles')['priority_roles'];

		$final_role_array = array();
		$arr_assign = array();
		foreach( $priority_array as $key => $value )
		{
		  if( $value['core_role'] == $role_assigned )
		   {

			  $parent_priority = $value['priority'];

		   }
		}

		foreach( $user_roles as $rol )
		{
			foreach( $priority_array as $key => $value )
			{
				if( $value['core_role'] == $rol->role_assigned_role )
				{

					$child_priority = $value['priority'];
					if( $child_priority >= $parent_priority )
					{
						if($rol->role_id != $role)
						{
							if(array_key_exists($role,$assign_array) && !empty($assign_array))
							{
								if (!in_array($rol->role_id, $assign_array[$role]))
								{
								   $rol->role_id = $rol->role_id;
								   array_push($final_role_array, $rol);
								}
							}
							else
							{
								$rol->role_id = $rol->role_id;
								array_push($final_role_array, $rol);
							}
						}

					}
				}
			}
		}
		$return_arr['status'] = "success";
		$return_arr['roles']  = $final_role_array;

		return $this->success('success',201,$return_arr);
	} catch (\Exception $e) {
		// DB::rollback();
		return $this->failure('Failure', 500, $e);
	}
	}

	public function get_roles_can_assign_new($key, $role, $assigned)
	{

		try {
		// $post_data=$request->all();

		// $role = $this->decrypt_data($post_data['role']);
		$assigned = isset($assigned)?$assigned:[];
		$assign_array = array();
		if(!empty($assigned))
		{
			unset($assigned[$key]);
			$assigned = array_values($assigned);
			foreach($assigned as $key => $value)
			{
				$new_array=(explode(",",$value));
				if(array_key_exists($new_array[0],$assign_array))
				{
					array_push($assign_array[$new_array[0]],$new_array[1]);
				}
				else
				{
					$assign_array[$new_array[0]] = [];
					array_push($assign_array[$new_array[0]],$new_array[1]);
				}
			}
		}
		$data = "role_id='{$role}'";
		$roles = Roles::get_single_record('role_assigned_role', $data);
		$role_assigned = $roles->role_assigned_role;

		$role_table = (new \App\Models\Roles())->getTable();
		$previleged_user_role = $this->RolesConfigdata('privileged_user_roles');
		$previleged_role_string = "'" . implode("','", $previleged_user_role['privileged_user_roles']) . "'";



		$roles_sql = "SELECT * FROM {$role_table} WHERE role_assigned_role IN({$previleged_role_string}) ORDER BY role_name";
		$user_roles = Roles::get_records_by_raw_query($roles_sql);

		$priority_array=$this->RolesConfigdata('priority_roles')['priority_roles'];

		$final_role_array = array();
		$arr_assign = array();
		foreach( $priority_array as $key => $value )
		{
		  if( $value['core_role'] == $role_assigned )
		   {

			  $parent_priority = $value['priority'];

		   }
		}
		foreach( $user_roles as $rol )
		{
			foreach( $priority_array as $key => $value )
			{
				if( $value['core_role'] == $rol->role_assigned_role )
				{

					$child_priority = $value['priority'];
					if( $child_priority >= $parent_priority )
					{
						if($rol->role_id != $role)
						{
							if(array_key_exists($role,$assign_array) && !empty($assign_array))
							{
								if (!in_array($rol->role_id, $assign_array[$role]))
								{
								   $rol->role_id = $rol->role_id;
								   array_push($final_role_array, $rol);
								}
							}
							else
							{
								$rol->role_id = $rol->role_id;
								array_push($final_role_array, $rol);
							}
						}

					}
				}
			}
		}
		return $final_role_array;
	} catch (\Exception $e) {
		// DB::rollback();
	}
	}

	public function get_assignment_details(Request $request)
	{
		try {
			$post_data = $request->all();
			$asgm_jnl_id = $post_data['jnl_id'];
			// $checkcondition = "asgm_jnl_id='{$asgm_jnl_id}' AND asgm_artp_id IS NULL";
			$checkcondition = "asgm_jnl_id= ? AND asgm_artp_id IS NULL";
			$bind_arr = [$asgm_jnl_id];
			if ($post_data['arttype_id'] != '') {
				$asgm_artp_id = $this->decrypt_data($post_data['arttype_id']);
				// $checkcondition = "asgm_jnl_id='{$asgm_jnl_id}' AND asgm_artp_id='{$asgm_artp_id}'";
				$checkcondition = "asgm_jnl_id= ? AND asgm_artp_id= ?";
				$bind_arr = [$asgm_jnl_id,$asgm_artp_id];
			}
			$db_data = Assign_permission::get_all_records('*', $checkcondition,binding_arr:$bind_arr);
			$assignment_list = array();
			$assigned = array();
			$index = 0;
			foreach($db_data as $key => $value)
			{
				$assigned[] = $value->asgm_can_assgn_role.','.$value->asgm_assgnd_role;
				$roles = $this->get_roles_can_assign_new($key, $value->asgm_can_assgn_role, $assigned);
				$roles_array = [];
				$item["label"] = "Select";
				$item["value"] = '';
				$roles_array[0] = $item;
				foreach($roles as $k => $val)
				{
					$childitem = [];
					$childitem["label"] = $val->role_name;
					$childitem["value"] = $val->role_id;
					$roles_array[$k] = $childitem;
				}
				$assignment_list[$key] = $roles_array;
			}
			$return_arr['assignment_data'] = $db_data;
			$return_arr['assignment_roles'] = $assignment_list;
			return $this->success('success', 201, $return_arr);
		} catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
	}
	public function removeAssignment(Request $request)
	{
		try {
			$post_data = $request->all();
			$return_arr['status'] = 'failed';

			//$exclude_users = ' AND usr_id NOT IN (' . implode(',', $jnl_user_ids) . ')';
			if($post_data['asmtid'])
			{
				$result = $this->deleteAssignment($post_data['asmtid']);
				if ($result > 0) {
					$return_arr['status'] = 'success';
					$return_arr['msg'] = customTrans('platform_settings.delete_assgmnt');
				}
			}

			return $this->success('success', 201, $return_arr);
		} catch (\Exception $e) {
			// DB::rollback();
			return $this->failure('Failure', 500, $e);
		}
	}
	public function deleteAssignment($remove_array = array() ,$arttype_id =array(),$asgm_artp_id = null)
	{
		$this->currentuser = $this->get_current_user_details();
		//TASK #7560 The permission given in journal settings are not reflected in article type
		if(!empty($arttype_id) && count($arttype_id)>0 && is_null($asgm_artp_id))
		{
			$condition_array ='asgm_id IN (' . implode(',', $remove_array) . ')';
			$assign_datas=Assign_permission::get_all_records('asgm_can_assgn_role,asgm_assgnd_role,asgm_jnl_id', $condition_array);
			$perm_assign= array();
			foreach($assign_datas as $assigndata)
			{
				$all_records=Assign_permission::get_all_records_with_bind_cond('asgm_id',array('asgm_jnl_id'=>$assigndata->asgm_jnl_id,'asgm_can_assgn_role'=>$assigndata->asgm_can_assgn_role,
							'asgm_assgnd_role'=>$assigndata->asgm_assgnd_role));
						
						$perm_data=$all_records->pluck('asgm_id')->toArray();
						$perm_assign=array_merge($perm_assign,$perm_data);
			}
		$deletecon = 'asgm_id IN (' . implode(',', $perm_assign) . ')';				
		}
		//TASK #7560 The permission given in journal settings are not reflected in article type
		else
		{
		$deletecon = 'asgm_id IN (' . implode(',', $remove_array) . ')';
		}
		//$exclude_users = ' AND usr_id NOT IN (' . implode(',', $jnl_user_ids) . ')';
		$result = Assign_permission::delete_records($deletecon, '', $this->currentuser);
		return $result;
	}
	public function get_classifications(Request $request)
	{
		try {

			$post_data = $request->all();
			$term_table = (new \App\Models\Terms())->getTable();
			$classification_table = (new \App\Models\Classifications())->getTable();
			$jnlid = $post_data['hdn_jnl_id'];
			// TASK #7259 SQL injection Journal settings getclassifications
			$jnlidarray = array('input'=>$post_data['hdn_jnl_id'],'type'=>'number');
			$jnlidvalidation= $this->Rv_validator($jnlidarray);
			if($jnlidvalidation != TRUE){
				return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
			}
			// end #7259 SQL injection Journal settings getclassifications
			$atypeid=NULL;
			$criteria = "cls_jnl_id='{$jnlid}'";
			if ($post_data['type'] == 'a') {
			$atypeid=$this->decrypt_data($post_data['hdn_atype_id']);
				$criteria .= " AND cls_artp_id='{$atypeid}'";
			}
			else
			{
				$criteria .= " AND cls_artp_id IS NULL";
			}
			$select = '*';
			$tables = array(
				'main_table' => $term_table,
				'join_table' => array(
					$classification_table => array($term_table . '.term_id', $classification_table . '.cls_term_id', "left")
				)
			);
			$classification_details = Classifications::get_results_using_joins($tables, $select, $criteria, '');


			// $nodearray = array();
			// foreach ($classification_details as $value) {

			// 	if ($value->jntm_primary_id == NULL) {
			// 		$arraysyntax = array();
			// 		$arraysyntax['title'] = $value->term_name;
			// 		$arraysyntax['id'] = $value->jntm_id;
			// 		$arraysyntax['children'] = array();

			// 		$nodearray[] = $arraysyntax;
			// 	} else {

			// 		$nodearray = $this->savenode($nodearray, $value);
			// 	}


			// }


			$res = [];
			if(count($classification_details)>0)
			{
			foreach($classification_details as $e)
			{
				$classifications =  $e;

			$this->addToArr($res, $classifications);

			}
		}

			// $classification_treedata = $this->recursive_convert_array_to_obj($res);




			$classification_treedata=json_decode(json_encode($res));

				$return_arr['status'] = 'success';
				$return_arr['classification_list'] = $classification_treedata;

			return $this->success('success', 201, $return_arr);
		} catch (\Exception $e) {
			// DB::rollback();
			return $this->failure('Failure', 500, $e);
		}
	}



	public function recursive_convert_array_to_obj($arr) {
		if (is_array($arr)){
			$new_arr = array();
			foreach($arr as $k => $v) {
				if (is_integer($k)) {
					// Needs this if you have indexed keys at the top level in the array
					// and want to utilize the indexes: eg. $o->index{1}
					$new_arr[$k] = $this->recursive_convert_array_to_obj($v);
				}
				else {
					$new_arr[$k] = $this->recursive_convert_array_to_obj($v);
				}
			}

			return (object) $new_arr;
		}

		// else maintain the type of $arr
		return $arr;
	}
// function savenode($node,$value)
// {
// $saveflag='0';


// foreach($node as $val)
// {
// if($val->jntm_id==$val->primary_id)
// {
// 	$arraysyntax = array();
// 					$arraysyntax['title'] = $val->term_name;
// 					$arraysyntax['id'] = $val->jntm_id;
// 					$arraysyntax['children'] = array();
// 	$val['children'][]=$arraysyntax;
// 	$saveflag='1';

// }
// if($saveflag='1')
// {

// 	return $node;
// }
// else
// {
// 	$node=$this->savenode($node['children'],$val);
// return $node;
// }

// }




// }


function updateParent($parents,$insertid)
{
foreach($parents as $val)
{
	$childrens=array();

	$parent_condition="cls_id='{$val}'";
	$sibling_info = Classifications::get_single_record('*', $parent_condition);




	if($sibling_info->cls_children_id!="")
					{
					$childrens=json_decode($sibling_info->cls_children_id);
					}
					$childrens[]=$insertid;
	$criteria="cls_id={$val}";
	$jnl_term_data = array(
		'cls_children_id' => json_encode($childrens)
	);
	Classifications::update_record($jnl_term_data,$criteria,$this->currentuser);

}

}

public function check_classification_duplicate($condition_array)
{
	$jnl_id=$condition_array['jnl_id'];
	$new_term_id=$condition_array['new_term_id'];
	$jnl_id=$condition_array['jnl_id'];
	$cls_parents_id=$condition_array['cls_parents_id'];
	$check_classifications='';
	$check_classifications = "cls_jnl_id='{$jnl_id}' AND cls_term_id='{$new_term_id}'";
	if (isset($condition_array['artp_id']))
	{
		$artp_id=$condition_array['artp_id'];
		$check_classifications.=" AND cls_artp_id='{$artp_id}'";
	}
	else
	{
	$check_classifications.=" AND cls_artp_id IS NULL";
	}
	$term_self_usage = Classifications::get_all_records('*', $check_classifications);

	$existflag = 0;

	if (count($term_self_usage) > 0) {
		foreach ($term_self_usage as $oldclassification) {
			if($cls_parents_id==$oldclassification->cls_parents_id)
			{
				$existflag = 1;
				break;
			}
			else
			{
				if($oldclassification->cls_parents_id=="")
				{
					//primary node
					$existflag = 1;
				break;

				}
				else
				{
				$class_common= array_intersect(json_decode($cls_parents_id),json_decode($oldclassification->cls_parents_id));
				if(count($class_common)>0)
				{
					$existflag = 1;
				break;
				}
			}
			}

		}
		if($existflag>0)
		{

			return true;
		}
		else
		{
			return false;
		}


	}

}


	//add/edit-classifications
	public function save_classifications(Request $request)
	{


		$parents=array();
try {
	$post_data = $request->all();
$type=$post_data['type'];
$mode=$post_data['mode'];
	$this->currentuser = $this->get_current_user_details();

		if (isset($post_data['name']))
		{
			$term = $post_data['name'];
			$edit_term = NULL;
			if ($post_data['currentnode_id'] != NULL)
			{
				//edit term
				$edit_term = $post_data['currentnode_id'];
			}
	$artp_id=NULL;
				$jnl_id = $post_data['hdn_jnl_id'];




			// WORKING AREA
			$term_con="term_name='".$term."'";
			$term_data = Terms::get_all_records('*', $term_con);

			if (count($term_data) > 0)
			{
				$new_term_id = $term_data[0]->term_id;
				// $update_con="term_id='".$new_term_id."'";
				// Terms::update_record(array("term_name"=>$term),$update_con,$this->currentuser);
			}
			else
			{
				//insert term
				$term_list = array(
					'term_name' => $term,
					'term_custom_addition' => 'n'
				);
				$new_term_id = Terms::insert_record($term_list, $this->currentuser);
			}

			// $check_classifications='';
			// 	$check_classifications = "cls_jnl_id='{$jnl_id}' AND cls_term_id='{$new_term_id}'";
				if ($type!='j')
				{
					$artp_id =$this->decrypt_data($post_data['hdn_atype_id']);
				}
			// 	else
			// 	{
			// 	$check_classifications.=" AND cls_artp_id IS NULL";
			// 	}
			// 	$term_self_usage = Classifications::get_all_records('*', $check_classifications);
			// 	$return_arr['term_id'] = $new_term_id;

// $query = DB::getQueryLog();
// $query = end($query);
// print_r($query);exit;

// if(count($term_self_usage)>0)
// {
// foreach($term_self_usage as $classdata)
// {
// if($classdata->cls_parents_id==NULL && )

// $parents_id= count(json_decode($classdata->cls_parents_id));

// }

// }






					$jnl_term_data=array();
				if($mode=='new')
				{
					$jnl_term_data = array(
						'cls_jnl_id' => $jnl_id,
						'cls_term_id' => $new_term_id,
						// 'cls_type' => $type,
						'cls_artp_id' => $artp_id,
						'cls_parents_id'=>'',
						'cls_children_id'=>''
					);
					$return_arr['status'] = 'Node added';
				}
				else if($mode=='sibling' || $mode=='child')
				{
					$silbling_id=$post_data['hdn_parent_id'];
					$sibling_condition="cls_id='{$silbling_id}'";
					$sibling_info = Classifications::get_single_record('*', $sibling_condition);
					$parent=NULL;

					$return_arr['status'] = 'Sibling node added successfully';

					if($sibling_info->cls_parents_id!="" && $sibling_info->cls_parents_id !=NULL)
					{
					$parents=json_decode($sibling_info->cls_parents_id);
					}




					if($mode=='child'){
						$return_arr['status'] = 'Child node added successfully';
						$parent=$silbling_id;
						$parent=$post_data['hdn_parent_id'];
						$parents[]=$post_data['hdn_parent_id'];
					}
					else{
						// $parents_list=$sibling_info->cls_primary_id;
						$parent=$sibling_info->cls_primary_id;
					}



					$jnl_term_data = array(
						'cls_jnl_id' => $jnl_id,
						'cls_term_id' => $new_term_id,
						'cls_primary_id'=>$parent,
						'cls_artp_id' => $artp_id,
						'cls_parents_id'=>count($parents)?json_encode($parents):''
					);


				}
				//start--check duplicate
				$condition_array=array();
				$condition_array['type']=$type;
				$condition_array['jnl_id']=$jnl_id;
				if ($type!='j')
				{
				$condition_array['artp_id']=$this->decrypt_data($post_data['hdn_atype_id']);
				}
				$condition_array['new_term_id']=$new_term_id;
				if($mode=='update')
				{
					$node_con="cls_id='{$edit_term}'";
					$node_info = Classifications::get_single_record('*', $node_con);

					$condition_array['cls_parents_id']=$node_info->cls_parents_id;
				}
				else{
				$condition_array['cls_parents_id']=isset($jnl_term_data['cls_parents_id'])?$jnl_term_data['cls_parents_id']:"";
				}
				$condition_array['mode']=$mode;

				$duplicate_status=$this->check_classification_duplicate($condition_array);
//End--check duplicate

				if($duplicate_status==true)
					{
						$return_arr['status'] = customTrans('platform_settings.classification_duplicate');
						$return_arr['success'] = 'false';

						return $this->success('success', 200,$return_arr);
					}
else
{
					$return_arr['term_id'] = $new_term_id;
				 if($mode=='update')
				{
				    $criteria="cls_id={$edit_term}";
					$jnl_update_data = array(
						'cls_jnl_id' => $jnl_id,
						'cls_term_id' => $new_term_id,
						'cls_artp_id' => $artp_id
					);
					$return_arr['message'] = customTrans('platform_settings.classification_updated');
					Classifications::update_record($jnl_update_data,$criteria,$this->currentuser);

				}

				else
					{
					$insertid = Classifications::insert_record($jnl_term_data, $this->currentuser);
					$return_arr['classificationid'] = $insertid;

					$this->updateParent($parents,$insertid);


					}




		}
	}
		else if($mode=='remove') {
				$classification_set = $post_data['currentnode_id'];
				//get all the associated child classification if any
				$get_childerns = Classifications::get_single_record('cls_children_id', "cls_id = ".$classification_set);
				if(!empty($get_childerns->cls_children_id)){
					$classification_set .= ','.implode(',',json_decode($get_childerns->cls_children_id));
				}

				$ac_checkcondition = "arcls_cls_id IN ({$classification_set})";
				$ac_data = Article_classification::get_all_records('*', $ac_checkcondition);
				$uc_checkcondition = "usrcls_cls_id IN ({$classification_set})";
				$uc_data = User_classification::get_all_records('*', $uc_checkcondition);
				if (count($ac_data) > 0 || count($uc_data) > 0) {
					$err_loc = customTrans('platform_settings.articles');
					if(count($uc_data) > 0){
						$err_loc = customTrans('platform_settings.users');
					}
					if(count($ac_data) > 0 && count($uc_data) > 0){
						$err_loc = customTrans('platform_settings.article_users');
					}
					$return_arr['status'] = str_replace('REPLACE_NAME', $err_loc, customTrans('platform_settings.classification_remove'));
					$return_arr['success'] = 'false';
					return $this->success('success', 200, $return_arr);
				}
			$criteria="cls_id={$post_data['currentnode_id']}";
			Classifications::delete_records($criteria,'',$this->currentuser);
			$return_arr['status'] = 'Node removed successfully';
		}
		else
		{
			$return_arr['status'] = 'err';
		}
		$return_arr['success'] = 'true';
	return $this->success('success', 201, $return_arr);
} catch (\Exception $e) {
	// DB::rollback();
	return $this->failure('Failure', 500, $e);
}
	}

	public function save_journalsettings_keyword(Request $request)
    {
         try {
            $form_data = $request->all();
            $this->currentuser = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'keywords'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
			$is_edit = FALSE;
            $hdn_keyword_id = '';
            if (isset($form_data['hdn_keyword_id']) && !empty($form_data['hdn_keyword_id'])) {
                $is_edit = TRUE;
                $hdn_keyword_id = $form_data['hdn_keyword_id'];
            }
			$keyword = $form_data['keywords'];
			$jnl_id = $form_data['jnl_id'];
			$error_msg = '';
			if ($is_edit == FALSE) //add mode
            {
                $keyword = is_array($keyword) ? $keyword : explode(',', $keyword);
                for ($i = 0; $i < count($keyword); $i++) {
                    $keyword_val = isset($keyword[$i]['value']) ? $keyword[$i]['value'] : $keyword[$i];
                    $keyword_val = str_replace('\\', '"', $keyword_val);
                    $kwd_name = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
                    // $condition = "kwd_name ='" . $kwd_name . "' AND kwdrl_jnl_id='" . $jnl_id . "'";
                    $condition = "kwd_name = ? AND kwdrl_jnl_id= ?";
                        $get_keyword_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt',binding_arr:[$kwd_name,$jnl_id]);
                        if ($get_keyword_record->cnt > 0) {
                            // $get_journal_record = Journals::get_single_record('jnl_journal_name', "jnl_id=" . $jnl_id);
                            $get_journal_record = Journals::get_single_record('jnl_journal_name', "jnl_id= ?",binding_arr:[$jnl_id]);
                            $journal_name = $get_journal_record->jnl_journal_name;
							$err_msg = customTrans("already exists for :journal");
                            $error_msg .= "keyword '" . $kwd_name ."' ". $err_msg ." '". $journal_name . "'<br/>";
                        }

			          }
			if ($error_msg != "") {
				return $this->warning('warning', 200, $error_msg, 'warning');
			}else {
				for ($i = 0; $i < count($keyword); $i++) {
					$keyword_val = $keyword[$i]['value'];
					$keyword_val = str_replace('\\', '"', $keyword_val);
					$kwd_name = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
					// $data = "kwd_name='" . strtoupper($kwd_name) . "'";
					$data = "kwd_name= ?";
					$get_keyword_record = Keywords::get_single_record('count(*) cnt,kwd_id', $data,binding_arr:[strtoupper($kwd_name)]);
					if ($get_keyword_record->cnt > 0) {
						$keyword_id = $get_keyword_record->kwd_id;
						// $where = "kwdrl_kwd_id=$keyword_id and kwdrl_jnl_id is not null";
						$where = "kwdrl_kwd_id= ? and kwdrl_jnl_id is not null";
						$select = 'count(*) as cnt';
						$journal_records = Keywords::check_keyword_exists($where, $select,binding_arr:[$keyword_id]);
						if ($journal_records->cnt > 0)
							$insertIDs[$i] = array(
								"action" => "u",
								"key_id" => $keyword_id
							);
						else
							$insertIDs[$i] = array(
								"action" => "i",
								"key_id" => $keyword_id
							);
					} else {
						$insertdata = array(
							'kwd_name' =>  $this->unicode_correction_export(strtoupper($kwd_name))
						);
						$keyword_id = Keywords::insert_record($insertdata, $this->currentuser);
						$insertIDs[$i] = array(
							"action" => "i",
							"key_id" => $keyword_id
						);
					}
					$data_keyword_journal = array(
						'kwdrl_jnl_id' => $jnl_id,
						'kwdrl_kwd_id' => $keyword_id);
						$result = Keyword_relationship::insert_record($data_keyword_journal, $this->currentuser);

				}
				$data = array(
					'message' => customTrans('keyword.keyword_added_msg'),
					'result' => $insertIDs,
					'mode' => 'add'
				);
				return $this->success('success', 200, $data);
			}

        } else{

			$keyword_val = $keyword;
			$keyword_val = str_replace('\\', '"', $keyword_val);
			$keyword = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
			// $condition = "kwd_name='" . $keyword . "' AND kwd_id!=" . $this->decrypt_data($hdn_keyword_id). " AND kwdrl_jnl_id=" . $jnl_id;
			$condition = "kwd_name= ? AND kwd_id!= ? AND kwdrl_jnl_id= ?";
			$get_keyword_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt',binding_arr:[$keyword,$this->decrypt_data($hdn_keyword_id),$jnl_id]);
			if ($get_keyword_record->cnt > 0) {
				$error_msg=customTrans('keyword.duplicate_keyword');
				return $this->warning('warning', 200, $error_msg, 'warning');
				//return $this->warning('warning', 200, customTrans('keyword.duplicate_keyword'), 'warning');
			}
			else
			{
				$hdn_keyword_id = $this->decrypt_data($hdn_keyword_id);
				// $where_update = "kwdrl_kwd_id='" . $hdn_keyword_id . "' AND kwdrl_jnl_id =" . $jnl_id;
				$where_update = "kwdrl_kwd_id= ? AND kwdrl_jnl_id = ?";
				$data = array(
					'kwd_name' => strtoupper($keyword)
				);
				$delete = Keyword_relationship::delete_records($where_update, '', $this->currentuser,binding_arr:[$hdn_keyword_id,$jnl_id]);
				// $condition = "kwdrl_kwd_id=" . $hdn_keyword_id;
				$condition = "kwdrl_kwd_id= ?";
				$get_keyword_rel_data = Keyword_relationship::get_single_record('*',$condition,binding_arr:[$hdn_keyword_id]);
		        if (empty($get_keyword_rel_data))
		        {
					// $conditions = "kwd_id=" . $hdn_keyword_id;
					$conditions = "kwd_id= ?";
				$delete_key = Keywords::delete_records($conditions, '', $this->currentuser,binding_arr:[$hdn_keyword_id]);
				}

				// $datas = "kwd_name='" . strtoupper($keyword) . "'";
				$datas = "kwd_name= ?";
			    $get_keyword_record = Keywords::get_single_record('*', $datas,binding_arr:[strtoupper($keyword)]);
			if (!empty($get_keyword_record))
			{
				$keyword_id = $get_keyword_record->kwd_id;
			}
			else
			{
				$insertdata = array(
					'kwd_name' =>  $this->unicode_correction_export(strtoupper($keyword))
				);
				$keyword_id = Keywords::insert_record($insertdata, $this->currentuser);
			}
			$data_keyword_journal = array(
				'kwdrl_jnl_id' => $jnl_id,
				'kwdrl_kwd_id' => $keyword_id
			);
			$result=Keyword_relationship::insert_record($data_keyword_journal,$this->currentuser);
			}
			$data = array(
				'success' => true,
				'mode' => 'update',
				'hdn_key_id' => $keyword_id,
				'message' =>  customTrans('keyword.keyword_update_msg')
			);
			return $this->success('success', 200, $data);
		}
	}catch (\Exception $e) {

            return $this->failure('Failed', 500, $e);
        }
    }

	public function display_journal_keyword(Request $request)
	{
		try {
            $form_data = $request->all();
			$hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $journal_id  =$form_data['platform_id'];
			$having = 'cnt >=0';
			$keyword_type = $this->KeywordData('keywordtype')['keywordtype'];
            $operant_type = $this->KeywordData('operanttype')['operanttype'];
			$search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
			$criteria = 'kwd_user_keyword IN (\'n\',\'y\') ';
			$total_records = 0;
            $jnl_keyword_records = array();
            $enable_separate_keywords = FALSE;
            if (isset($this->current_client->functionality->cfty_separate_adhoc_keywords) && $this->current_client->functionality->cfty_separate_adhoc_keywords == 'y') {
                $enable_separate_keywords = TRUE;
            }
			if (!empty($search)) {
                if (isset($search['keyword_name']) && $search['keyword_name'] != '') {
                    $key_name = htmlspecialchars($search['keyword_name'], ENT_QUOTES);
                    // $criteria .= ' AND LOWER(kwd_name) LIKE LOWER("%' . trim($key_name) . '%")';
                    $criteria .= ' AND LOWER(kwd_name) LIKE LOWER(?)';
					$bind_arr[] =  "%".trim($key_name)."%";
                }
                if (isset($search['keyword_status']) && $search['keyword_status'] != NULL) {
                    // $criteria .= ' AND kwdrl_inactive ="' . $search['keyword_status'] . '"';
                    $criteria .= ' AND kwdrl_inactive = ?';
					$bind_arr[] = $search['keyword_status'];
                }
				if ($enable_separate_keywords==TRUE)
				{
                    if (isset($search['keyword_type']) && $search['keyword_type'] != NULL) {
                        // $criteria .= ' AND kwd_user_keyword ="' . $search['keyword_type'] . '"';
						$criteria .= ' AND kwd_user_keyword = ?';
						$bind_arr[] = $search['keyword_type'];
                        //$find_value = $search['keyword_type'];
                    }
					if(isset($search['keyword_operant']) && $search['keyword_operant'] != NULL)
					{
                    $keyword_number = isset($search['keyword_number']) ? $search['keyword_number'] : '';
                    $keyword_operant = isset($search['keyword_operant']) ? $search['keyword_operant'] : '';
                    if ($keyword_number != '')
                        $having = 'cnt ' .  $keyword_operant . ' ' . $keyword_number . '';
					}
				}

				}

			// if ($hierarchy == "c")
			// {
			// $joinCondition = "ejk_keyword_category = kwc_id AND ejk_jnl_id={$journal_id}";
			// $select = "*";
			// $keywords = Keyword_category::get_keyword_categories($joinCondition, $select);
			// }
			// else{
			$select = 'kwd_id,count(kwd_name) as count,kwd_user_keyword,"" as keyword_data,kwdrl_inactive,kwdrl_id';
			$group_by = 'kwd_id';
			// $criteria .=" AND kwdrl_jnl_id=".$journal_id;
			$criteria .=" AND kwdrl_jnl_id= ?";
			//}
			$bind_arr[] = $journal_id;
			$group_by = 'kwd_id';
            $sort_field = $form_data['sort_field'] ?? 'kwd_name';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
			$all_records = Keywords::get_jnlsettings_keywords($select, TRUE, $criteria, NULL,$group_by, $sort_field, $sort_order,$having,$journal_id,binding_arr:$bind_arr);
			if (!empty($all_records)) {
                $total_records = $all_records->count;

                if ($total_records != 0) {
                    $select = 'kwd_id,REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name,kwd_user_keyword,kwdrl_inactive,CONCAT(REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\'),"\t",kwd_user_keyword,"\t",kwdrl_inactive) as keyword_data,kwdrl_id';
                    $limit =$form_data['per_page'] ?? '10';
                    $jnl_keyword_records = Keywords::get_jnlsettings_keywords($select, FALSE, $criteria, $limit, $group_by, $sort_field, $sort_order, $having,$journal_id,binding_arr:$bind_arr);
				}
            }
            $data['keywordtype'] = $keyword_type;
            $data['operanttype'] = $operant_type;
            $data['jnl_keyword_records'] = $jnl_keyword_records;
            $data['total_records'] = $total_records;
			$data['enable_separate_keywords'] = $enable_separate_keywords;

            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
	}
	public function get_jnlsettingkeyword_byid(Request $request)
    {
        try {
            $form_data = $request->all();
            $keywordid = $this->decrypt_data($form_data['keywordid']);
            if ($keywordid != '') {
                $condition = "kwd_id=" . $keywordid;
                $keyword_details['keyword_detail'] = Keywords::get_jnl_keywords('kwd_id, kwd_name', TRUE, $condition);
                return $this->success('success', 200, $keyword_details);
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

	public function delete_journalsetting_keyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->currentuser = $this->get_current_user_details();
            $key_id = $form_data['key_id'];
			$key_relation = $form_data['key_relation'];
			$Articles = (new \App\Models\Articles())->getTable();
			$Journals = (new \App\Models\Journals())->getTable();
			$Article_keywords = (new \App\Models\Article_keywords())->getTable();
			$Article_types = (new \App\Models\Article_types())->getTable();
			$Keywords = (new \App\Models\Keywords())->getTable();

			if (isset($key_id) && $key_id != '')
			{
                $key_id =  $this->decrypt_data($key_id);
				$condition = "kwdrl_id=" .  $this->decrypt_data($key_relation);
				if ($this->current_client->functionality->cfty_keyword_hierarchy == "j")
					{
				$get_journal_id = Keyword_relationship::get_single_record('kwdrl_jnl_id',$condition);
				$criteria = "jnl_id={$get_journal_id->kwdrl_jnl_id } AND kwd_id={$key_id}";
					}
					else{
						$get_journal_id = Keyword_relationship::get_single_record('kwdrl_category_id',$condition);
						$criteria = "jnl_id={$get_journal_id->kwdrl_category_id } AND kwd_id={$key_id}";
					}
				$tables = array(
					'main_table' => $Articles,
					'join_table' => array(
					  $Article_types => array($Articles . '.art_artp_id', $Article_types . '.artp_id', "join"),
					  $Journals => array($Article_types . '.artp_jnl_id', $Journals . '.jnl_id', "join"),
					  $Article_keywords => array($Articles . '.art_id',  $Article_keywords . '.ak_art_id', "join"),
					  $Keywords => array($Article_keywords . '.ak_keyword_id',  $Keywords . '.kwd_id', "join")
					)
				  );

				$select = 'count(art_id) as count';
				//$criteria = "jnl_id={$get_journal_id->kwdrl_jnl_id } AND kwd_id={$key_id}";
				$article_count = Articles::get_results_using_joins($tables,$select,$criteria);
				if ($article_count[0]->count == 0)
				{

					$condition='';
					$where_update = "kwdrl_id=" .$this->decrypt_data($key_relation);
					$result = Keyword_relationship::delete_records($where_update, '', $this->currentuser);

					if ($this->current_client->functionality->cfty_keyword_hierarchy == "j")
					{
						$condition.=" and kwdrl_jnl_id is not null";
					}
					else
					{
						$condition.=" and kwdrl_category_id is not null";
					}
					$condition_where = "kwdrl_kwd_id='" . $this->decrypt_data($key_id) . "' $condition";
					$keyword_records = Keywords::check_keyword_exists($condition_where,'count(*) as cnt');
						if ($keyword_records->cnt == 0)
						{

					Keywords::delete_records('kwd_id=' . $key_id, '', $this->currentuser);;
						}
					if ($result > 0)
					{

						$data = array(
							'success' => true,
							'message' => customTrans('keyword.delete_keyword'),
							'del_rcrd_id' => $key_id,
							'hierarchy'=>$this->current_client->functionality->cfty_keyword_hierarchy
						);
						return $this->success('success', 200, $data);
					}
					else
					{
						return $this->warning('warning', 200, customTrans('keyword.keywd_del_warning'), 'warning');
					}
                } else {
                    return $this->warning('warning', 200, customTrans('keyword.keywd_del_warning'), 'warning');
                }
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
	public function save_controlled_jnlsettingkeyword(Request $request)
    {
        try {
            $form_data = $request->all();
            $this->currentuser = $this->get_current_user_details();
            if (isset($form_data ['key_id']) && $form_data ['key_id'] != '') {
                $key_id =  $this->decrypt_data($form_data ['key_id']);
                $data = array(
                    'kwd_user_keyword' => 'n'
                );
                $result = Keywords::update_record($data, 'kwd_id=' . $key_id, $this->currentuser);
                $result_arry = array(
                    'success' => true,
                    'message' => customTrans('keyword.kwd_custom_msg'),
                );
                return $this->success('success', 200, $result_arry);
            } else {
                return $this->warning('warning', 200, customTrans('keyword.kwd_custom_err'), 'warning');
            }
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
	public function jnlsetting_keyword_action(Request $request)
	{
		try{
		$form_data = $request->all();
		$relation_id= $this->decrypt_data($form_data['key_relation']);
		$action=$form_data['action_status'];
		$hdn_key_id=$form_data['key_id'];
		$keyword_id=  $this->decrypt_data($hdn_key_id);
		$category_id='';
		$jnl_id_val=$form_data['jnl_id'];
		$this->currentuser = $this->get_current_user_details();
	    $Articles = (new \App\Models\Articles())->getTable();
			$Journals = (new \App\Models\Journals())->getTable();
			$Article_keywords = (new \App\Models\Article_keywords())->getTable();
			$Article_types = (new \App\Models\Article_types())->getTable();
			$Keywords = (new \App\Models\Keywords())->getTable();
			$Keyword_relationship = (new \App\Models\Keyword_relationship())->getTable();
			$Keyword_category = (new \App\Models\Keyword_category())->getTable();
		// if($form_data['category']!='')
		//  $category_id= $this->decrypt_data ($form_data['category']);
		if($action == "hide")
		{
			$data_update = array(
				'kwdrl_inactive' => 'y'
			);

			$result = Keyword_relationship::update_record($data_update,'kwdrl_id='.$relation_id,$this->currentuser);
		}
		else
		{
			$data_update = array(
				'kwdrl_inactive' => 'n'
			);
			$result = Keyword_relationship::update_record($data_update, 'kwdrl_id='.$relation_id,$this->currentuser);
		}

		$result_arry = array(
			'success' => true,
			'message' => customTrans('keyword.kwd_inactive')
		);
		return $this->success('success', 200, $result_arry);
} catch (\Exception $e) {
	return $this->failure('Failed', 500, $e);
}
}

	public function get_metadata(Request $request)
	{
		try {
			$post_data = $request->all();
			$jnlid=$this->decrypt_data($post_data['jnl_id']);
			$article_id=isset($post_data['art_id'])?$this->decrypt_data($post_data['art_id']):'';
			$jnlcode=$post_data['jnl_code'];
			$formatted_journal_code = '_'.$jnlcode;
			$supporting_details_status=isset($post_data['supporting_details_status']) && $post_data['supporting_details_status']==='y'?'y':'n';
			$role_id=isset($post_data['role_id']) ? $post_data['role_id']:'';
			$metadata_status='m';

			if(isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y' && $supporting_details_status==='y'){
				$metadata_status='s';
				$jnl_setting = Journal_settings::get_single_record_with_bind_cond('jset_bulk_invite_submission',array("jset_jnl_id"=>$jnlid));
						if(isset($jnl_setting->jset_bulk_invite_submission)){
							$jnl_permissionuser = json_decode($jnl_setting->jset_bulk_invite_submission, true);
							if (is_array($jnl_permissionuser) && in_array($role_id, $jnl_permissionuser)) {
								$return_arr['editpermission']=true;
							}						
						}
				$res=$this->getSupportingdataforms(array('jnl_id'=>$jnlid,'jnl_code'=>$jnlcode));
				if(!empty($res)){
					$return_arr['completedforms']=isset($res['completedforms'])?$res['completedforms']:[];
				}
			}
			$condition = "jnl_id= ?";
			$jnl_data = Journals::get_single_record('*',$condition,binding_arr:[$jnlid]);
// var_dump($jnl_data);exit;

			if(isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y' && $supporting_details_status==='y') {
				// Task #3563 Collecting Supporting Documents for Conference
				// Decode the JSON and validate
				$form_ids = json_decode($jnl_data->jnl_supporting_forms);
				if (!is_array($form_ids) || empty($form_ids)) {
					$form_ids = []; // Set empty array if invalid
				}

				// Create a safe comma-separated list for ORDER BY FIELD
				$placeholders = implode(',', array_fill(0, count($form_ids), '?'));

				// Build the query safely
				$generic_forms = DB::table('rvw_generic_forms')
					->where('gncf_metadata_status', 's')
					->whereIn('gncf_id', $form_ids);

				// Only add order if we have form IDs
				if (!empty($form_ids)) {
					$generic_forms = $generic_forms->orderByRaw("FIELD(gncf_id, $placeholders)", $form_ids);
				}

				$generic_forms = $generic_forms->get();

			} else {
				$condition = "gncf_id='{$jnl_data->jnl_metadata_id}' AND gncf_metadata_status='".$metadata_status."' ";
				$generic_forms=$this->loadMetadata($condition);
			}

			$return_arr['status'] = 'failed';
			$return_arr['msg']=customTrans('metadata.metadata_notfound');
			if(count($generic_forms)>0)
			{
			$return_arr['formdata']=$generic_forms;
		// Task #3563 Collecting Supporting Documents for Conference
			if(!empty($generic_forms)){
				$i=0;
				foreach ($generic_forms as $row) {
					$i++;
					$formid=$row->gncf_id;
					$element_con='emt_gucf_id='.$formid;
					$elements = Generic_form_elements::get_all_records('count(emt_gucf_id) as element_count',$element_con);
		
					$existdata = Article_generic_form_data::load_exist_form_contents($formid, $article_id, '', $formatted_journal_code);
					$return_arr['existdata'][$formid]=$existdata;
					$return_arr['no_of_element'] = $elements[0]->element_count;

					if($existdata==NULL || count($existdata)==0 || $i==count($generic_forms)) {
						$form_complete=false;
						if(empty($return_arr['form_openid'])) {
							$return_arr['form_openid']=$formid;
						}
					}	
					// if($file_only==true) {
					// 	$form_complete=false;
					// 	$return_array['form_openid']=$formid;
					// }

				}
			}


			$return_arr['status'] = 'success';
			$return_arr['msg']='';
			}
			return $this->success('success', 201, $return_arr);
		} catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
	}

	public function loadMetadata($condition=NULL)
	{
		$Generic_forms = new \App\Models\Generic_forms();
		$generic_forms = $Generic_forms::get_all_records('gncf_id,gncf_form_type,gncf_form_name,gncf_form_title', $condition);
			return $generic_forms;




	}

	public function change_journal_status(Request $request)
	{ // activate or deactivate journal
		try {
		$form_data = $request->all();
		$journal_id =$this->decrypt_data($form_data['journal_id']);
		$status_title = $form_data['title'];
		$condition = "jnl_id=" .$journal_id;
		$jnl_data = Journals::get_single_record('*',$condition);
		$this->currentuser = $this->get_current_user_details();
		//$jnl_data->jnl_journal_status=($jnl_data->jnl_journal_status =='y')?'n':'y';
		if ($status_title == 'archive' && $jnl_data->jnl_journal_status == 'y')
		{
			$jnl_data->jnl_journal_status = 'n';
		}
		elseif ($status_title == 'activate' && $jnl_data->jnl_journal_status == 'n')
		{
			$jnl_data->jnl_journal_status = 'y';
		}

		$data_update = array(
			'jnl_journal_status' => $jnl_data->jnl_journal_status
		);
		$update = Journals::update_record($data_update,'jnl_id='.$journal_id,$this->currentuser);
		$return_array['status'] = 'error';
		if ($update > 0)
		{
			$return_array['status'] = 'success';


		}
		$return_array['jnl_status']=$jnl_data->jnl_journal_status;
		return $this->success('success', 201, $return_array);

	} catch (\Exception $e) {
		return $this->failure('Failure', 500, $e);
	}
	}
       public function changejnl_articlesubmission_status(Request $request)
	   {
		try{
			$form_data=$request->all();
			$status     =   'error';
			$journal_id    =   $this->decrypt_data($form_data['jnl_id']);
			$condition = "jnl_id=" .$journal_id;
			$jnl_data  =   Journals::get_single_record('jnl_article_submission_status', $condition);
			$this->currentuser = $this->get_current_user_details();
			if ($jnl_data->jnl_article_submission_status == 'y') {
				$article_submission_status = 'n';
			} elseif ($jnl_data->jnl_article_submission_status == 'n') {
				$article_submission_status = 'y';
			}
			$data_update = array(
				'jnl_article_submission_status' => $article_submission_status
			);

			$update = Journals::update_record($data_update,'jnl_id='.$journal_id, $this->currentuser);
			$return_array['status'] = 'error';
			if ($update > 0)
			{
				$return_array['status'] = 'success';
			}
			$return_array['jnl_article_submission_status']=$article_submission_status;
			return $this->success('success', 201, $return_array);
		} catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
	   }

	   public function get_all_jnl_category_keywords(Request $request)
	   {
		   try {
			   $form_data = $request->all();

			   $Keyword_category=(new \App\Models\Keyword_category())->getTable();
			   $Excluded_journal_keywords=(new \App\Models\Excluded_journal_keywords())->getTable();
			   //$criteria = "ejk_jnl_id={$form_data['jnl_id']} AND kwc_is_default IN ('n','y')";
			    $criteria = "kwc_is_default IN ('n','y')";
			   $categories = array();

				   $sort_field = $form_data['sort_field'] ?? 'kwc_id';
				   $sort_order =  $form_data['sort_order'] ?? 'asc';
				   $limit = $form_data['per_page'] ?? 10;
				   $select = '*';

				$tables = array(
					'main_table' => $Keyword_category,
					'join_table' => $Excluded_journal_keywords,
					'column_prefix2' => $Excluded_journal_keywords . '.ejk_keyword_category',
					'column_prefix1' => $Keyword_category . '.kwc_id',
					'column_where_condition'=>$Excluded_journal_keywords . '.ejk_jnl_id',
					'column_where_value'=>$form_data['jnl_id']
				);
				$categories = Keyword_category::get_results_join_pagination($tables, $select, $criteria, null, $sort_field, $sort_order, $limit);


			   $data['categories'] = $categories;
			   return $this->success('success', 200, $data);
		   } catch (\Exception $e) {
			//print_r($e);
			   return $this->failure('Failed', 500, $e);
		   }
	   }



		public function get_category_keyword(Request $request)
	    {
		try{
			$form_data = $request->all();
			$category_id =$this->decrypt_data($form_data['category_id']);
			$hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $journal_id  =$form_data['platform_id'];
			$having = 'cnt >=0';
			$keyword_type = $this->KeywordData('keywordtype')['keywordtype'];
            $operant_type = $this->KeywordData('operanttype')['operanttype'];
			$search = isset($form_data['paramsdet']) ? $form_data['paramsdet'] : '';
			$total_records = 0;
            $jnl_keyword_records = array();
            $enable_separate_keywords = FALSE;
			$criteria ="kwdrl_category_id=".$category_id;
			// $criteria = "kwdrl_category_id ='" . $category_id . "' AND kwdrl_jnl_id='" . $journal_id . "'";
            if (isset($this->current_client->functionality->cfty_separate_adhoc_keywords) && $this->current_client->functionality->cfty_separate_adhoc_keywords == 'y') {
                $enable_separate_keywords = TRUE;
            }
			if (!empty($search)) {
                if (isset($search['keyword_name']) && $search['keyword_name'] != '') {
                    $key_name = htmlspecialchars($search['keyword_name'], ENT_QUOTES);
                    $criteria .= ' AND LOWER(kwd_name) LIKE LOWER("%' . trim($key_name) . '%")';
                }

				if ($enable_separate_keywords==TRUE)
				{
                    if (isset($search['keyword_type']) && $search['keyword_type'] != NULL) {
                        $criteria .= ' AND kwd_user_keyword ="' . $search['keyword_type'] . '"';
                        //$find_value = $search['keyword_type'];
                    }
					if(isset($search['keyword_operant']) && $search['keyword_operant'] != NULL)
					{
                    $keyword_number = isset($search['keyword_number']) ? $search['keyword_number'] : '';
                    $keyword_operant = isset($search['keyword_operant']) ? $search['keyword_operant'] : '';
                    if ($keyword_number != '')
                        $having = 'cnt ' .  $keyword_operant . ' ' . $keyword_number . '';
					}
				}

				}

			$select = "kwd_id,count(kwd_name) as count,kwdrl_category_id,kwdrl_id,kwdrl_inactive,(select count(*) from rvw_excluded_journal_keywords where ejk_keyword_category=$category_id and ejk_jnl_id=$journal_id) as excluded";
			$group_by = 'kwd_id';

            $sort_field = $form_data['sort_field'] ?? 'kwd_name';
            $sort_order =  $form_data['sort_order'] ?? 'asc';
			$all_records = Keywords::get_jnlsettings_catkeywords($select, TRUE, $criteria, NULL,$group_by, $sort_field, $sort_order,$having,$journal_id );

			if (!empty($all_records)) {
                $total_records = $all_records->count;

                if ($total_records != 0) {
					$select = "kwd_id,kwd_name,kwdrl_category_id,GROUP_CONCAT(kwc_name SEPARATOR  '\t') as names,GROUP_CONCAT(kwc_id) as ids,kwdrl_id,kwdrl_inactive,(select count(*) from rvw_excluded_journal_keywords where ejk_keyword_category=$category_id and ejk_jnl_id=$journal_id) as excluded";
                    $limit = 25;
                    $jnl_keyword_records =  Keywords::get_jnlsettings_catkeywords($select, FALSE, $criteria, $limit, $group_by, $sort_field, $sort_order, $having,$journal_id );
                }
            }
            $data['keywordtype'] = $keyword_type;
            $data['operanttype'] = $operant_type;
            $data['jnl_keyword_records'] = $jnl_keyword_records;
            $data['total_records'] = $total_records;
			$data['enable_separate_keywords'] = $enable_separate_keywords;

            return $this->success('success', 200, $data);
	}
	catch (\Exception $e) {
		return $this->failure('Failure', 500, $e);
	}
	}
	public function manage_journal_catkeyword(Request $request)
	{
		try{
		$form_data = $request->all();
		$category_id =$this->decrypt_data($form_data['catid']);
		$this->currentuser = $this->get_current_user_details();
		if (!empty($form_data['action']) && !empty($form_data['jnl_id']) && !empty($category_id))
		{

			if ($form_data['action'] == 'show')
			{
				//remove data from Excluded_journal_keywords table
				$condition = "ejk_jnl_id={$form_data['jnl_id']} AND ejk_keyword_category={$category_id }";
				$result = Excluded_journal_keywords::delete_records($condition, '', $this->currentuser);

			}
			else
			{
				// insert data to Excluded_journal_keywords table
				$data= array(
					'ejk_jnl_id' => $form_data['jnl_id'],
					'ejk_keyword_category' => $category_id
				);
				$result = Excluded_journal_keywords::insert_record($data, $this->currentuser);


			}
			$return_array = array(
				'success' => true
			);
		}
		return $this->success('success', 200, $return_array);
		}
	catch (\Exception $e) {
		return $this->failure('Failure', 500, $e);
	}
	}
	public function save_keyword_category(Request $request)
    {
         try {
            $form_data = $request->all();
            $this->currentuser = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                'keywords'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
			$is_edit = FALSE;
            $hdn_keyword_id = '';
            if (isset($form_data['hdn_keyword_id']) && !empty($form_data['hdn_keyword_id'])) {
                $is_edit = TRUE;
                $hdn_keyword_id = $form_data['hdn_keyword_id'];
            }
			$keyword = $form_data['keywords'];
			$category_id = $this->decrypt_data($form_data['category_id']);
			$error_msg = '';
			if ($is_edit == FALSE) //add mode
            {
                $keyword = is_array($keyword) ? $keyword : explode(',', $keyword);
                for ($i = 0; $i < count($keyword); $i++) {
                    $keyword_val = isset($keyword[$i]['value']) ? $keyword[$i]['value'] : $keyword[$i];
                    $keyword_val = str_replace('\\', '"', $keyword_val);
                    $kwd_name = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
                    $condition = "kwd_name ='" . $kwd_name . "' AND kwdrl_category_id='" . $category_id . "'";


                        $get_keyword_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt');
                        if ($get_keyword_record->cnt > 0) {
                            $get_journal_record = Keyword_category::get_single_record('kwc_name', "kwc_id=" . $category_id);
                            $kwc_name = $get_journal_record->kwc_name;
                            $error_msg .= "Keyword '" . $kwd_name . "' already exists for category '" . $kwc_name . "'<br/>";
                        }

			          }
			if ($error_msg != "") {
				return $this->warning('warning', 200, $error_msg, 'warning');
			}else {
				for ($i = 0; $i < count($keyword); $i++) {
					$keyword_val = $keyword[$i]['value'];
					$keyword_val = str_replace('\\', '"', $keyword_val);
					$kwd_name = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
					$data = "kwd_name='" . strtoupper($kwd_name) . "'";
					$get_keyword_record = Keywords::get_single_record('count(*) cnt,kwd_id', $data);

					if ($get_keyword_record->cnt > 0) {
						$keyword_id = $get_keyword_record->kwd_id;
						$where = "kwdrl_kwd_id=$keyword_id and kwdrl_category_id is not null";
						$select = 'count(*) as cnt';
						$journal_records = Keywords::check_keyword_exists($where, $select);
						if ($journal_records->cnt > 0)
							$insertIDs[$i] = array(
								"action" => "u",
								"key_id" => $keyword_id
							);
						else
							$insertIDs[$i] = array(
								"action" => "i",
								"key_id" => $keyword_id
							);
					} else {
						$insertdata = array(
							'kwd_name' => $this->unicode_correction_export(strtoupper($kwd_name))
						);
						$keyword_id = Keywords::insert_record($insertdata, $this->currentuser);
						$insertIDs[$i] = array(
							"action" => "i",
							"key_id" => $keyword_id
						);
					}
					$data_keyword_journal = array(
						'kwdrl_category_id' => $category_id,
						'kwdrl_kwd_id' => $keyword_id);
						$result = Keyword_relationship::insert_record($data_keyword_journal, $this->currentuser);

				}
				$data = array(
					'message' => customTrans('keyword.keyword_added_msg'),
					'result' => $insertIDs,
					'mode' => 'add'
				);
				return $this->success('success', 200, $data);
			}

        } else{

			$keyword_val = $keyword;
			$keyword_val = str_replace('\\', '"', $keyword_val);
			$keyword = htmlspecialchars(trim($keyword_val), ENT_QUOTES);
			$condition = "kwd_name='" . $keyword . "' AND kwd_id!=" . $this->decrypt_data($hdn_keyword_id). " AND kwdrl_category_id=" . $category_id;
			$get_keyword_record = Keywords::check_keyword_exists($condition, 'count(*) as cnt');
			if ($get_keyword_record->cnt > 0) {
				return $this->warning('warning', 200, customTrans('keyword.duplicate_keyword'), 'warning');
			}
			else
			{
				$hdn_keyword_id = $this->decrypt_data($hdn_keyword_id);
				$where_update = "kwdrl_kwd_id='" . $hdn_keyword_id . "' AND kwdrl_category_id =" . $category_id;
				$data = array(
					'kwd_name' => strtoupper($keyword)
				);
				$delete = Keyword_relationship::delete_records($where_update, '', $this->currentuser);
				$condition = "kwdrl_kwd_id=" . $hdn_keyword_id;
				$get_keyword_rel_data = Keyword_relationship::get_single_record('*',$condition);
		        if (empty($get_keyword_rel_data))
		        {
	      	$conditions = "kwd_id=" . $hdn_keyword_id;
				$delete_key = Keywords::delete_records($conditions, '', $this->currentuser);
				}

				$datas = "kwd_name='" . strtoupper($keyword) . "'";
			    $get_keyword_record = Keywords::get_single_record('*', $datas);

			if (!empty($get_keyword_record))
			{

				$keyword_id = $get_keyword_record->kwd_id;
			}
			else
			{
				$keyword_names=$this->unicode_correction_export(strtoupper($keyword));
				$keyword_id = Keywords::insert_record(array(
					'kwd_name' => $keyword_names
				),$this->currentuser);
			}

			$data_keyword_journal = array(
				'kwdrl_category_id' => $category_id,
				'kwdrl_kwd_id' => $keyword_id
			);
			$result=Keyword_relationship::insert_record($data_keyword_journal,$this->currentuser);
			}
			$data = array(
				'success' => true,
				'mode' => 'update',
				'hdn_key_id' => $keyword_id,
				'message' =>  customTrans('keyword.keyword_update_msg')
			);
			return $this->success('success', 200, $data);
		}
	}catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

	public function jnl_admin_upload_temp(Request $request)
    {
        try{
            $post_data = $request->all();
            $rtn_arr = array();
			$this->currentuser = $this->get_current_user_details();
            $validator = Validator::make($request->all(), [
                // 'file' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $allowed_extensions = array("doc", "docx", "tex", "TeX", "ltx","latex","zip");
            $attachment_file = $post_data['file'];
            $name = $attachment_file->getClientOriginalName();
			$jnl_code =  decrypt_link($request->jnlcode);
			$jnl_id =  decrypt_link($request->jnlid);
            $extension = $attachment_file->getClientOriginalExtension();
            if(!in_array($extension,$allowed_extensions)){
                $rtn_arr = array(
                    'status' => false,
                    'msg'    => 'Invalid File type'
                );
            } else {
                $file_path = Config::get('general_config.file_retrieval')['file_path'];
                $path = 'jnladmin_temp_author/' . $jnl_code;
                $fullpath = "uploads" . DIRECTORY_SEPARATOR . $path;
				$uploaded_file_details=$this->upload_file_handler($path, $attachment_file, $name);
				if ($this->current_client->enable_upload_s3_bucket == 'y') {
					$this->update_s3_files($path);
				}
				$exiting_files = Journals::get_single_record_with_bind_cond('jnl_journal_admin_upload_template', array('jnl_id'=>$jnl_id) );
				$exiting_template = $exiting_files->jnl_journal_admin_upload_template;

				if(!empty($exiting_template) &&  $exiting_template != NULL)
				{
				$tempArray = json_decode($exiting_template);
				array_push($tempArray, $uploaded_file_details['name']);
				$uploaded_content = json_encode($tempArray);
				}
				else
				{
				$uploaded_content = json_encode(explode(',', $uploaded_file_details['name']));
				}
				$data = array(
					'jnl_journal_admin_upload_template' => $uploaded_content);
					$criteria = 'jnl_id = '.$jnl_id;
					$temp_data = Journals::update_record($data, $criteria, $this->currentuser);
                $rtn_arr = array(
                    'status' => true,
                    'uploadedPath' => Rv_encrypt($fullpath . DIRECTORY_SEPARATOR . $name),
                    'fileName' => $name,
					'update_result' => $temp_data
                );
            }
            return $this->success('success', 201, $rtn_arr);

        }catch (\Exception $e) {
            return $this->failure('Failure', 500, $e);
        }
    }

	public function get_upload_temp_details(Request $request)
	{
		try
		{
			$post_data = $request->all();
			$this->currentuser = $this->get_current_user_details();
			$validator = Validator::make($request->all(), [
				// 'jnl_id' => 'required'
			]);

			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
				$jnl_code =  decrypt_link($request->jnlcode);
				$jnl_id =  decrypt_link($request->jnl_id);
				$data = 'jnl_id = ?';
				$result = Journals::get_single_record('jnl_journal_admin_upload_template,jnl_id', $data, binding_arr:[$jnl_id]);
				return  $this->success('Success',201,$result);
			}
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',500,$e);
		}

	}

	public function delete_upload_temp_details(Request $request)
	{
		try
		{
			$post_data = $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_code' => 'required',
				'jnl_id' => 'required'

			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
				$section = $post_data['section'];
				$jnl_id=decrypt_link($post_data['jnl_id']);
				$jnl_code =  decrypt_link($post_data['jnl_code']);
				$path = 'jnladmin_temp_author/' . $jnl_code;
                $fullpath = "uploads" . DIRECTORY_SEPARATOR . $path;
				$this->currentuser=$this->get_current_user_details();
				$data = 'jnl_id = '.$jnl_id;
					$result = Journals::get_single_record('jnl_journal_admin_upload_template,jnl_id', $data);
					if(!empty($result))
					{
						$section_str =  $section;
						$decode_data=json_decode($result->jnl_journal_admin_upload_template);
						$name = $decode_data[$section_str];
						Storage::disk('public')->delete($fullpath . DIRECTORY_SEPARATOR . $name);
						if (file_exists($fullpath .$name))
						{
							unlink($fullpath .$name);
						}
						if ($this->current_client->enable_upload_s3_bucket == 'y' && $fullpath!=NULL)
						{
							Storage::disk('s3')->delete($fullpath . DIRECTORY_SEPARATOR . $name);
							if (file_exists($fullpath .$name))
							{
								unlink($fullpath .$name);
							}
						}

						if(count((array)$decode_data)== 1)
						{
							$condition = 'jnl_id = '.$result->jnl_id;
							$update_arr = array(
									'jnl_journal_admin_upload_template' => NULL
								);
							$result = Journals::update_record($update_arr, $condition, $this->currentuser);
						}
						else
						{
							if(isset($decode_data[$section_str]) )
							{
								// api changes by priyakrishnan
								$key = array_search($name, $decode_data);
								if (($key) !== false)
								{
								#deleting the key found
								unset($decode_data[$key]);
								}
								$decode_data = array_values($decode_data);
								$condition = 'jnl_id = '.$result->jnl_id;
									$update_arr = array(
										'jnl_journal_admin_upload_template' => json_encode($decode_data)
									);
									$result = Journals::update_record($update_arr, $condition, $this->currentuser);

							}
						}
					}
				return  $this->success('Success',201,$result);
			}
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',500,$e);
		}

	}

	public function download_upload_temp_details(Request $request)
    {
		try
		{
			$post_data = $request->all();
			$data_result = array();
			$validator = Validator::make($request->all(), [
				'jnl_code' => 'required',
				'jnl_id' => 'required'

			]);
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
			else
			{
				$section = $post_data['section'];
				$jnl_id = decrypt_link($post_data['jnl_id']);
				$jnl_code = decrypt_link($post_data['jnl_code']);
				$this->currentuser=$this->get_current_user_details();
				$data = 'jnl_id = '.$jnl_id;
				$result = Journals::get_single_record('jnl_journal_admin_upload_template,jnl_id', $data);
				if(!empty($result))
				{
					$section_str =  $section;
					$decode_data=json_decode($result->jnl_journal_admin_upload_template);
					$name = $decode_data[$section_str];
					$path = 'jnladmin_temp_author/' . $jnl_code;
					$file_path = '/storage/uploads/'. $path . DIRECTORY_SEPARATOR . $name;
					$filepath = public_path() . $file_path;
					$data_result = array(
						'file_path'=> RV_encrypt($filepath),
						'filename' => $name
					);
					// return Response::download($filepath);
					return  $this->success('Success',201,$data_result);
				}
			}
		}
		catch(\Exception $e)
		{
			return  $this->failure('Failed',500,$e);
		}
    }

	public function download_upload_jnl_admin_temp($file_data)
	{
        try
		{
			$post_data = json_decode($file_data);
			$filepath=Rv_decrypt($post_data->file_path);
			if(file_exists($filepath))
			{
				return Response::download($filepath);
			}
			else
			{
				$this->warning('Failed',500,'file not exist');
			}
        }
		catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}

    }
	public function get_journals(Request $request)
    {
        try {
			$post_data = $request->all();
            $criteria = array("jnl_standalone"=>$post_data['standlone']);
            $journals = Journals::get_all_records_with_bind_cond('jnl_id,jnl_journal_name',$criteria);
            $data['journals'] = $journals;
            $data['keywordmethod'] = $this->KeywordData('keywordmethod')['keywordmethod'];
			$kwd_criteria=array();
            $data['keyword_list'] = Keywords::get_all_records_with_bind_cond('kwd_id,kwd_name',$kwd_criteria);

            return $this->success('success', 200, $data);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }
	public function user_list(Request $request)
    {
	 try
	 {
	$post_data=$request->all();
	$search_parameters = $post_data['paramsdet'];
	$user_to_journal_table=(new \App\Models\User_to_journals())->getTable();
	$role_table = (new \App\Models\Roles())->getTable();
	$sql_condition_query='';
	$sql_condition_query .= '(`usr_roles` NOT LIKE "%sudo%" OR `usr_roles` IS NULL )';
	$select='usr_id,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as full_name,usr_first_name,usr_middle_name,usr_last_name,usr_email';
	if ($sql_condition_query != '')
		$sql_condition_query .= ' AND usr_status = "a"';

	if (isset($search_parameters ['search_keyword']) && $search_parameters ['search_keyword'] != '' && !empty($search_parameters ['search_keyword']))
		{

			$user_to_journal_table=(new \App\Models\Userkeywords())->getTable();
			$key_method = isset($search_parameters ['jnl_sch_keyword_src_method'])?$search_parameters ['jnl_sch_keyword_src_method'] :"IN";
			$select_keys =array();
			foreach ($search_parameters ['search_keyword'] as $keywords) {

				if(isset($keywords))
				{

				$select_keys[] = $keywords;
				}
				}
				$select_keys_string = implode(',', $select_keys);

			$keyword_select_sql = 'select DISTINCT ukwd_usr_id from ' . $user_to_journal_table .' WHERE ukwd_kwd_id IN('.$select_keys_string.') ';
			$sql_condition_query .= ' AND usr_id  ' . $key_method . ' (' . $keyword_select_sql . ')';
		}

			$limit = isset($post_data['per_page']) ? $post_data['per_page'] : 5;
	if (isset($search_parameters['username'])&&$search_parameters['username'] != '')
	{
	$sql_condition_query .= ' AND  (LOWER(CONCAT(`usr_first_name`,IF (COALESCE(`usr_middle_name`,\'\') =\'\', \' \', CONCAT(\' \',`usr_middle_name`, \' \')),`usr_last_name`)) LIKE LOWER("%' . $search_parameters['username'] . '%")) ';
	}
	if(isset($search_parameters['email'])&&$search_parameters['email'] != '')
	{
		$sql_condition_query .= ' AND  `usr_email` LIKE "%' . $search_parameters['email'] . '%"';
	}
	if(isset($search_parameters['stand_alone'])&&$search_parameters['stand_alone'] != '' && $search_parameters['stand_alone']=='y')
	{
		if($search_parameters['journal_name']!= ''){
			$sql_condition_query .= ' AND usr_jnl_standalone = "'. $search_parameters['journal_name'] . '"';
		}
		else{
			$sql_condition_query .= ' AND usr_jnl_standalone IS NOT NULL';
		}
	}
	if(isset($post_data['standlone'])&&$post_data['standlone'] != ''){
		if($post_data['standlone'] =='y'){
			$sql_condition_query .= ' AND usr_jnl_standalone IS NOT NULL';
		}
		elseif($this->decrypt_data($post_data['standlone']) != '' && $post_data['standlone'] != 'Undefined'){

			$sql_condition_query .= ' AND usr_jnl_standalone = '.$this->decrypt_data($post_data['standlone']);
		}
		else{
			$sql_condition_query .= ' AND usr_jnl_standalone IS NULL';
		}
	}
	$remainig_users=User_to_journals::get_journal_user_list($select,$sql_condition_query,$limit);

	$return_array['list']=$remainig_users;

	 return $this->success('success',200,$return_array);
	 }
	 catch (\Exception $e) {
		return  $this->failure('Failed',500,$e);
	}

 }

 public function save_user_tojournal(Request $request)
 {
	try{
	DB::enableQueryLog();
	$user_journal=$request->all();
	$validator = Validator::make($request->all(), [
		'journal_name'      => 'required',
		'user_id'      => 'required',
	]);
	$is_proceeding=$this->check_client_proceeding();
	if ($validator->fails()) {
		return response()->json($validator->errors(), 422);
	}
	if(isset($user_journal['journal_name']) && isset($user_journal['stand_alone']) && $user_journal['stand_alone'] == 'y'){
		$user_journal['journal_name'] = array($user_journal['journal_name']);
	}
	$this->currentuser = $this->get_current_user_details();
	$roles_insert='';
	$del_result='';
	 if ($user_journal != FALSE && isset($user_journal['journal_name']) && isset($user_journal['user_id']) && isset($user_journal['roles']) && $user_journal['journal_name'] != '' && $user_journal['user_id'] != '' && $user_journal['roles'] != '')
	 {
		 //Delete the record from user to journal table group by journal name and username(postdata) and reinsert with postdata
		 DB::beginTransaction();
		 if (is_array($user_journal['roles'])) {
			$new_roles = $user_journal['roles'];
		} else {
			$new_roles = explode(",", $user_journal['roles']);
		}

		$error_msg_bit = FALSE;
		//$error_msg='';
		$resultArr = [];
		 $jnl_name_array = array();
		 $jnl_role_exists = FALSE;
		 if (isset($user_journal['edited_id']) && $user_journal['edited_id'] != "") {

			if ($user_journal['journal_name'])
			{

						   $cond=array(
							   'usrj_jnl_id' => $user_journal['journal_name'],
							   'usrj_usr_id' => $user_journal['user_id'],
							   'usrj_artp_id' => NULL);

						   $current_roles = User_to_journals::get_all_records_with_bind_cond('usrj_id,usrj_role_id',$cond );
						   $cur_role_record_ids = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE),'usrj_id') : array();
						   $cur_user_roles_in_jrnl = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE),'usrj_role_id') : array();


						    $return_arr['removal_failed_roles'] = array();
						     $role_removal_failed_msg = '';
						    $removal_failed_roles = array();
								if(!empty($cur_user_roles_in_jrnl) && !empty($new_roles)){
									$remove_roles = array_diff($cur_user_roles_in_jrnl,$new_roles);

									if(!empty($remove_roles))
									{
										$return_arr['removal_failed_roles_msg'] = customTrans('platform_settings.role_removal_failed') . '<br>';

										foreach ($remove_roles as $key => $r_roles)
										{//check role required
									   $role_required = $this->check_role_required('j', $user_journal['journal_name'], $user_journal['user_id'], $r_roles);


											if ($role_required['status'] !== false)
											{

												unset($remove_roles[$key]);
												$condition = "role_id={$r_roles}";
												$temp = Roles::get_single_record('role_name', $condition);

												$role_required_exists = false;
												foreach ($return_arr['removal_failed_roles'] as $element) {
													if ($element['reason'] === $role_required['reason']) {
														$role_required_exists = true;
													}
												}
												if (!$role_required_exists) {
													array_push($return_arr['removal_failed_roles'], array(
														'role_name' => $temp->role_name,
														'reason' => $role_required['reason']
													));
													$return_arr['removal_failed_roles_msg'] .= $temp->role_name . '-' . $role_required['reason'] . '.<br>';
												}

											}
										}

										if(!empty($remove_roles)){
										   $user_data=array(
											   'usrj_jnl_id' => $user_journal['journal_name'],
											   'usrj_usr_id' => $user_journal['user_id'],
											   );
										$del_result = User_to_journals::delete_records_wherein($user_data, $this->currentuser,$remove_roles,'usrj_role_id','');
										// $del_result = User_to_journals::del_user_roles($user_data, $remove_roles);


										}
									}
								}


							if (count($new_roles) > 0)
							{
								for ($k = 0; $k < count($new_roles); $k++)
								{
									if(!in_array($new_roles[$k], $cur_user_roles_in_jrnl)) // need to insert only new role
									{
									   $res = Roles::get_all_records_with_bind_cond('role_assigned_role', array('role_id' => $new_roles[$k]));
																			//Check user role
								   $article_user_role = $this->RolesConfigdata('article_user_role')['article_user_role'];
								   $article_roles = array_keys($article_user_role);
								   $role_used = $this->RolesConfigdata('privileged_user_roles');
                                   $privillaged_users = $role_used['privileged_user_roles'];
								   if (in_array($res[0]->role_assigned_role, $article_roles) || in_array($res[0]->role_assigned_role, $privillaged_users)) {
											$article_data = array();

											$article_data = Article_types::get_all_records_with_bind_cond('artp_id',array('artp_jnl_id'=>$user_journal['journal_name']));


											foreach ($article_data AS $article)
														{
											$data = array(
											'usrj_jnl_id' => $user_journal['journal_name'],
											'usrj_usr_id' => $user_journal['user_id'],
											'usrj_role_id' => $new_roles[$k],
											'usrj_artp_id'=>$article->artp_id
																						);

											   $roles_insert = User_to_journals::insert_record($data, $this->currentuser);
																						//$insertIDs[] = $roles_insert;


																					}
																				}
											$data = array(
											'usrj_jnl_id' => $user_journal['journal_name'],
											'usrj_usr_id' => $user_journal['user_id'],
											'usrj_role_id' => $new_roles[$k],
											//'usrj_status' => 's',
										);
										$roles_insert = User_to_journals::insert_record($data, $this->currentuser);


																		}

								}
							}
			DB::commit();
			}


		 }
		 else{
		 if (count($user_journal['journal_name']) > 0)
		 {
			 for ($i = 0; $i < count($user_journal['journal_name']); $i++)
			 {
				 if (count($user_journal['user_id']) > 0)
				 {
					 for ($j = 0; $j < count($user_journal['user_id']); $j++)
					 {
						$cond=array(
							'usrj_jnl_id' =>$user_journal['journal_name'][$i],
							'usrj_usr_id' =>  $user_journal['user_id'][$j],
							'usrj_artp_id' => NULL);
					$current_roles = User_to_journals::get_all_records_with_bind_cond('usrj_id,usrj_role_id',$cond );


						 $cur_role_record_ids = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE),'usrj_id') : array();
						 $cur_user_roles_in_jrnl = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE),'usrj_role_id') : array();

						 if(empty($user_journal['hdn_id']))
						 {

							foreach($cur_user_roles_in_jrnl as $user_roles_in_jrnl)
							{

								 if(in_array($user_roles_in_jrnl,$new_roles))
								 {

									$role_cond=array("role_id"=>$user_roles_in_jrnl);
									$roles_name_disp=Roles::get_all_records_with_bind_cond("role_name",$role_cond);

									 $jnl_id = $user_journal['journal_name'][$i];
									 if(isset($jnl_name_array[$jnl_id]))
									 {
										 $jnl_name = $jnl_name_array[$jnl_id];
									 }
									 else
									 {

										$jnl_cond=array('jnl_id'=>$jnl_id);
										$jnl_det = Journals::get_all_records_with_bind_cond('jnl_journal_name',$jnl_cond);
										$jnl_name = $jnl_det[0]->jnl_journal_name;

										$jnl_name_array[$jnl_id] = $jnl_name;
									 }
									 $user_cond=array("usr_id"=>$user_journal['user_id'][$j]);
									 $Users = new \App\Models\User();
									 $user_name_disp=$Users::get_all_records_with_bind_cond("usr_first_name,usr_middle_name,usr_last_name,usr_email",$user_cond);
									 //$error_msg.='<i class="fa fa-times" style="color:red"></i><strong> '.$roles_name_disp[0]->role_name.'</strong>'." role already exist for ".'<strong>'.$user_name_disp[0]->usr_first_name.' '.$user_name_disp[0]->usr_middle_name.''.$user_name_disp[0]->usr_last_name.'</strong>'." in the journal <strong>".$jnl_name."</strong><br/>";
									 $error_msg_bit = TRUE;
									 $resultArr[] = [
										'role_name' => $roles_name_disp[0]->role_name,
										'jnl_name' => $jnl_name,
										'user' => $user_name_disp[0]->usr_first_name.' '.$user_name_disp[0]->usr_middle_name.''.$user_name_disp[0]->usr_last_name,
										'email' => $user_name_disp[0]->usr_email,
										'style' => 'text-danger',
										'message' => 'Already exist',
										'status' => false
									 ];
									 $jnl_role_exists = TRUE;
								 }
							 }
						 }
					 }
				 }
			 }
		 }

		 if (count($user_journal['journal_name']) > 0)
		 {
			 for ($i = 0; $i < count($user_journal['journal_name']); $i++)
			 {
				 if (count($user_journal['user_id']) > 0)
				 {
					 for ($j = 0; $j < count($user_journal['user_id']); $j++)
					 {

						$cond=array(
							'usrj_jnl_id' => $user_journal['journal_name'][$i],
							'usrj_usr_id' => $user_journal['user_id'][$j],
							'usrj_artp_id' => NULL);

						$current_roles = User_to_journals::get_all_records_with_bind_cond('usrj_id,usrj_role_id',$cond );
						$cur_role_record_ids = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE),'usrj_id') : array();
						$cur_user_roles_in_jrnl = (!empty($current_roles)) ? array_column(json_decode(json_encode($current_roles), TRUE),'usrj_role_id') : array();


						 if (count($new_roles) > 0)
						 {
							 for ($k = 0; $k < count($new_roles); $k++)
							 {
								 if(!in_array($new_roles[$k], $cur_user_roles_in_jrnl)) // need to insert only new role
								 {
									$res = Roles::get_all_records_with_bind_cond('role_assigned_role,role_name', array('role_id' => $new_roles[$k]));
																		 //Check user role
								$article_user_role = $this->RolesConfigdata('article_user_role')['article_user_role'];
								$article_roles = array_keys($article_user_role);
								$role_used = $this->RolesConfigdata('privileged_user_roles');
								$privillaged_users = $role_used['privileged_user_roles'];
								if (in_array($res[0]->role_assigned_role, $article_roles) || in_array($res[0]->role_assigned_role, $privillaged_users)) {
										 $article_data = array();

										 $article_data = Article_types::get_all_records_with_bind_cond('artp_id',array('artp_jnl_id'=>$user_journal['journal_name'][$i]));


										 foreach ($article_data AS $article)
													 {
										 $data = array(
										 'usrj_jnl_id' => $user_journal['journal_name'][$i],
										 'usrj_usr_id' => $user_journal['user_id'][$j],
										 'usrj_role_id' => $new_roles[$k],
										 'usrj_artp_id'=>$article->artp_id
																					 );

											$roles_insert = User_to_journals::insert_record($data, $this->currentuser);
																					 //$insertIDs[] = $roles_insert;


																				 }
																			 }
										 $data = array(
										 'usrj_jnl_id' => $user_journal['journal_name'][$i],
										 'usrj_usr_id' => $user_journal['user_id'][$j],
										 'usrj_role_id' => $new_roles[$k],
										 //'usrj_status' => 's',
									 );
									 $roles_insert = User_to_journals::insert_record($data, $this->currentuser);

									 if($error_msg_bit == TRUE){
										$user_cond=array("usr_id"=>$user_journal['user_id'][$j]);
										$Users = new \App\Models\User();
										$user_name_disp=$Users::get_all_records_with_bind_cond("usr_first_name,usr_middle_name,usr_last_name,usr_email",$user_cond);
										//$error_msg.='<i class="fa fa-check" style="color:green"></i><strong> '.$res[0]->role_name.'</strong>'." role has assigned to ".'<strong>'.$user_name_disp[0]->usr_first_name.' '.$user_name_disp[0]->usr_middle_name.''.$user_name_disp[0]->usr_last_name.'</strong>'." in the journal <strong>".$jnl_name."</strong> successfully.<br/>";
										$resultArr[] = [
											'role_name' => $res[0]->role_name,
											'jnl_name' => $jnl_name,
											'email' => $user_name_disp[0]->usr_email,
											'user' => $user_name_disp[0]->usr_first_name.' '.$user_name_disp[0]->usr_middle_name.''.$user_name_disp[0]->usr_last_name,
											'style' => 'text-success',
											'message' => 'Assigned successfully',
											'status' => true
										 ];
									 }

									}
							 }
							 DB::commit();
						 }
					 }
				 }
			 }
		 }
		if($error_msg_bit == TRUE)
		{
			$return_arr['popup_msg']=$resultArr;
			$return_arr['status']='failed';
			//$return_arr['message']= customTrans('roles.role_already_exist');
			return $this->warning('Warning',200,$return_arr);
		}
		}

		// if ($success !== FALSE)
		// {

		if($is_proceeding == true){
			$pltFrm     =  'Conference';
		}
		else {
			$pltFrm     =   $this->current_client->platform_type;
		}

		$return_arr['msg'] = customTrans('platform_settings.jnlroleupdates') . ' ' . $pltFrm;
		if ($user_journal['edited_id'] == '')
			$return_arr['msg'] = customTrans('platform_settings.jnlroleadded') . ' ' . $pltFrm;
	 return $this->success('success', 200, $return_arr);
		//}
	 }
	} catch (\Exception $e) {

		return  $this->failure('Failed', 500, $e);
	}
 }
 public function choose_userdata(Request $request)
 {
	 try {

		 $postdata = $request->all();
		 $validator = Validator::make($request->all(), [
			 'user_id'      => 'required',
		 ]);
		 if ($validator->fails()) {
			 return response()->json($validator->errors(), 422);
		 }

		 $user_id = $postdata['user_id'];

		 $condition = "usrj_usr_id={$user_id} AND usrj_jnl_id={$postdata['jnl_id']}";

        $roles = User_to_journals::get_all_roles($condition, TRUE);
		$return_array['roles'] = $roles;
		 return $this->success('success', 200, $return_array);

	 } catch (\Exception $e) {

		 return  $this->failure('Failed', 500, $e);
	 }
 }
   public function delete_user_journal(Request $request)
   {
	try{
		$postdata = $request->all();

	 $j_id = $this->decrypt_data($postdata['jnlid']);
	 $u_id =  $this->decrypt_data($postdata['usr_id']);
	 $this->currentuser = $this->get_current_user_details();
	 if (isset($j_id) && $j_id != '' && isset($u_id) && $u_id != '')
	  {
		 $user_required = $this->check_user_required('j', $j_id, $u_id, NUll);

		 if ($user_required['status'] === true)
		 {
			 $return_arr['status'] = 'failed';
			 $return_arr['message'] = $user_required['reason'];
			 return $this->warning('Warning', 200, $return_arr);

		 }
		 else
		 {
			$elem_codition = 'usrj_jnl_id = '.$j_id.' and usrj_usr_id = '.$u_id.'';
			User_to_journals::delete_records($elem_codition, '', $this->currentuser);

			 $return_arr['status'] = 'success';
			 $return_arr['message'] = customTrans('platform_settings.jnlroleremoved') . ' ' . $this->current_client->platform_type;
		 }

	 }
	 return $this->success('success', 200, $return_arr);
	} catch (\Exception $e) {

		return  $this->failure('Failed', 500, $e);
	}
 }
	public function import_classification(Request $request)
	{
		try {
			$return_data	= array();
			$post_data		= $request->all();
			$validator = Validator::make($request->all(), [
				'jnl_id'	=> 'required',
				'file'      => 'required',
			]);
			if ($validator->fails()) {
				$return_data    = array(
					'status' => 'error',
					'msg'    => customTrans('platform_settings.processing_error')
				);
				return $this->success('success', 200, $return_data);
			}
			$jnl_id			= $post_data['jnl_id'];
			if (!empty($post_data) && isset($post_data['file'])) {
				$path 		 = $post_data['file']->store('public/uploads');
				$return_data = $this->read_import_classifications($jnl_id, $path);
				unlink(storage_path() . '/app/' . $path);
				return $this->success('success', 200, $return_data);
			} else {
				$return_data = array(
					'status' => 'warning',
					'msg'    => customTrans('platform_settings.uploaded_file_not_found'),
				);
				// print_r($return_data);die;
				return $this->success('success', 200, $return_data);
			}
		} catch (\Exception $e) {
			// print_r($e);die;
			return  $this->failure('Failed', 500, $e);
		}
	}
	public function read_import_classifications($jnl_id, $path)
	{
		try {
			$return_data    = array(
				'status' => 'error',
				'msg'    => ''
			);
			//uploaded csv must contain following fields.
			$required_columns = array('id', 'classification_name', 'level', 'parent_id');
			$file_path		= storage_path() . '/app/' . $path;
			$file_read 		= fopen($file_path, 'r');
			$fields         = fgetcsv($file_read);
			$column_headers	= $this->escape_string($fields);
			//check whether the uploaded csv has the necessary columns
			$flag = 'true';
			foreach ($required_columns as $required_column) {
				if (!in_array($required_column, $column_headers)) {
					$flag = 'false';
				}
			}
			if ($flag == 'false') {
				$return_data    = array(
					'status' => 'warning',
					'msg'    => customTrans('platform_settings.incorrect_header_column')
				);
				return $return_data;
			} else {
				$temp_classification_import_tbl = (new \App\Models\Temp_classification_import())->getTable();
				$temp_tbl_exist = Temp_classification_import::get_all_tables_in_db(" AND TABLE_NAME='{$temp_classification_import_tbl}'");
				if (empty($temp_tbl_exist)) {
					$return_data    = array(
						'status' => 'error',
						'msg'    => customTrans('platform_settings.import_table_missing')
					);
					return $return_data;
				} else {
					// $delete_id = array();
					$i = 2;
					$invalid_columns = array();
					$term_data = array();
					$term_id = '';
					$user_data = $this->get_current_user_details();
					$insert_status = true;
					$accepted_pattern = '/^[\w\s\d()\üéøçèáōūÜŌ.,:?&\/\'\-_]+$/';
					DB::beginTransaction();
					while (($row = fgetcsv($file_read)) !== FALSE) {
						// columns such as id, classification_name, parent_id should not contain special characters, and should not be empty.
						$terms_name = $row[1];
						// print_r(preg_match($accepted_pattern, $row[0]));die;
						if(!preg_match($accepted_pattern, $row[0]) || !preg_match($accepted_pattern, $row[1]) || !preg_match($accepted_pattern, $row[3])){
							$insert_status = false;
							$invalid_columns[] = $i;
						}
						if($insert_status == true) {
							//check whether the classification name is already in the rvw_terms table.
							$select_arr = array("term_name" => $terms_name);
							$terms_exist = Terms::get_single_record_with_bind_cond('term_id', $select_arr);
							if (isset($terms_exist->term_id)) {
								$term_id = $terms_exist->term_id;
							} else {
								$term_data = array(
									'term_name' => $terms_name,
									'term_custom_addition' => 'n'
								);
								$term_id = Terms::insert_record($term_data, $user_data);
							}

							$classifn_relation_data = array(
								'cls_jnl_id' => $jnl_id,
								'cls_term_id' => $term_id,
							);
							$classifn_relation_id = Classifications::insert_record($classifn_relation_data, $user_data);

							$insert_data[] = array(
								'tci_cls_id' 		=> $classifn_relation_id,
								'tci_term_id' 		=> $term_id,
								'tci_primary_id' 	=> $row[0],
								'tci_level' 		=> $row[2],
								'tci_parent_id' 	=> (is_numeric($row[3]) == true) ? $row[3] : NULL,
								'tci_posted_by' 	=> $user_data['user_id'],
								'tci_posted_date' 	=> date('Y-m-d H:i:s'),
								'tci_proxy_id' 		=> $user_data['proxy_user_id'],
								'tci_operation' 	=> 'i',
							);
						}
						$i++;
					}
					// print_r($insert_data);die;
					if ($insert_status == true && !empty($insert_data)) {
						DB::commit();
						// remove all the previously inserted data as there is no use to keep it around
						Temp_classification_import::delete_records(1);
						//insert the new data for importing
						Temp_classification_import::insert_batch($insert_data);

						$temp_data = Temp_classification_import::get_all_records('tci_cls_id,tci_primary_id,tci_term_id,tci_parent_id');
						$classfn_data = array();
						if (!empty($temp_data) && count($temp_data) > 0) {
							foreach ($temp_data as $data) {
								$child_ids = $this->get_all_associated_childs($data->tci_primary_id, $temp_data);
								$child_id_arr = ($child_ids != '') ? (json_encode(array_filter(explode(',', $child_ids)), JSON_NUMERIC_CHECK)) : NULL;
								$parent_ids = $this->get_all_associated_parents($data->tci_parent_id, $temp_data);
								$parent_id_arr = ($parent_ids != '') ? (json_encode(array_filter(explode(',', $parent_ids)), JSON_NUMERIC_CHECK)) : NULL;
								$primary_id = NULL;
								$primary_id_arr = array();
								if ($parent_id_arr != NULL) {
									$primary_id_arr = json_decode($parent_id_arr);
									if (isset($primary_id_arr[0]) && !empty($primary_id_arr[0])) {
										$primary_id = $primary_id_arr[0];
									}
								}
								$classfn_data = array(
									'cls_primary_id' 	=> $primary_id,
									'cls_parents_id' 	=> $parent_id_arr,
									'cls_children_id' 	=> $child_id_arr
								);
								$classfn_where = array(
									'cls_id' 		=> $data->tci_cls_id,
									'cls_jnl_id' 	=> $jnl_id,
									'cls_term_id' 	=> $data->tci_term_id,
								);
								Classifications::update_record($classfn_data, $classfn_where);
							}
						}
						$return_data    = array(
								'status' => 'success',
								'msg'    => customTrans('platform_settings.classification_import_success'),
							);
						return $return_data;
					} else if (!empty($invalid_columns)) {
						DB::rollback();
						$return_data    = array(
							'status' => 'error',
							'msg'    => '<p align="justify">Data validation failed for the following columns: ' . implode(', ', $invalid_columns) . '. <br/>Eliminate all columns that are either empty or contain non-alphanumeric characters.</p>'
						);
						return $return_data;
					} else if (empty($insert_data)) {
						$return_data    = array(
							'status' => 'error',
							'msg'    => 'No records were found in the uploaded file.'
						);
						return $return_data;
					}

				}
			}
		} catch (\Exception $e) {
			return  $this->failure('Failed', 500, $e);
		}
	}
	public function get_all_associated_childs($primary_id, $temp_data, $child_str = '')
	{
		foreach ($temp_data as $data) {
			if ($data->tci_parent_id == $primary_id) {
				$child_str .= $data->tci_cls_id . ',';
				$child_str = $this->get_all_associated_childs($data->tci_primary_id, $temp_data, $child_str);
			}
		}
		return $child_str;
	}
	public function get_all_associated_parents($parent_id, $temp_data, $parent_str = '')
	{
		foreach ($temp_data as $data) {
			if ($data->tci_primary_id == $parent_id) {
				$parent_str .= $data->tci_cls_id . ',';
				$parent_str = $this->get_all_associated_parents($data->tci_parent_id, $temp_data, $parent_str);
			}
		}
		return $parent_str;
	}
	public function getCustomBlindDropList(){
		$roles = Roles::get(['role_id as value', 'role_name as label', 'role_assigned_role']);
		$result = [];
		$non_priv_roles = Config('general_config.non_priv_roles');
		foreach($roles as $role){
			// if(in_array($role->role_assigned_role,$non_priv_roles)){
			$result['nonPrivilegedRoles'][] = ['value' => "$role->value", 'label' => $role->label];
			// }
			$result['privilegedRoles'][] = ['value' => "$role->value", 'label' => $role->label];

		}

		return $this->success('Success', data:$result);
	}

	/*
		TASK #8820 Implement an option to switch to article-type level permissions for article types that currently use journal-level permissions.
		create a copy of permissions of journal and create new permission separately for the article type
	*/
	public function create_new_article_type_permissions(Request $request)
	{
		try
		{
			$return_arr = array('status' => 'failed');
			$validator = Validator::make($request->all(), [
				'artp_type' => 'required',
				'artp_id' => 'required'
			]);
			if ($validator->fails()) {
				return  $this->failure('Failed', 422, $validator->errors());
			}
			$post_data = $request->all();
			$type_record_array = array('input' =>$post_data['artp_type'],'type'=> 'string');
			$type_validation =  $this->Rv_validator($type_record_array);
			$type_id_record_array = array('input' =>$post_data['artp_id'],'type'=> 'string');
			$id_validation =  $this->Rv_validator($type_id_record_array);
			if($id_validation != TRUE || $type_validation != TRUE){
				return $this->warning('Warning',200,'',customTrans('viewarticle.invalid_data'));
			}
			$get_artp_dtls = Article_types::get_single_record_with_bind_cond('artp_article_type,artp_jpm_id',array('artp_id' => decrypt_link($post_data['artp_id'])));
			if(!empty($get_artp_dtls))
			{
				$currentuser = $this->get_current_user_details();
				$article_type_name = $get_artp_dtls->artp_article_type;
				$Permission_desc = 'Permission of ' .$article_type_name;
				$mast_permission_id = Journal_permission_master::insert_record(array('jpm_description' => $Permission_desc), $currentuser);
				if($mast_permission_id)
				{
					$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
					$sql = "insert into " . $journal_permission_table . " (jp_jpm_id,jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_forms,jp_edit_article_files,
					jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
					jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_rate_reviewer,jp_request_rescind,jp_posted_by
					)"
					. "select " . $mast_permission_id . ",jp_add_notes,jp_flag_articles,jp_edit_articles,jp_edit_article_forms,jp_edit_article_files,
					jp_transfer_article,jp_rescind_article,jp_rescind_review,jp_generic_discussion,
					jp_reset_article,jp_view_auditrail,jp_view_email_log,jp_stage_manual_reminder,jp_extend_task,jp_edit_reviewer_count,jp_view_file_inventory,jp_view_article_pdf,jp_auto_assign_role,jp_change_usr_assigmnts,jp_move_article_from_payment,jp_reinstantiate_payment,jp_rate_reviewer,jp_request_rescind,jp_posted_by from " . $journal_permission_table . " where jp_jpm_id=" . $get_artp_dtls->artp_jpm_id;
					DB::select($sql);
					$update_types = Article_types::update_record(array('artp_jpm_id' => $mast_permission_id),array('artp_id' => decrypt_link($post_data['artp_id'])));
					$return_arr = array('status' => 'success');
				}
			}
			return $this->success('success',200,$return_arr);
		}
		catch (\Exception $e) {
			return  $this->failure('Failed',500,$e);
		}
	}
}

