<?php

namespace App\Http\Controllers\Platform;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Journals;
use App\Models\Journal_settings;
use App\Models\Generic_flows;
use App\Models\Generic_forms;
use App\Models\Advance_flow_movement;
use App\Models\Article_generic_form_data;
use App\Models\Flow_master;
use App\Models\Roles;
use App\Models\Article_flow;
use App\Models\User;
use App\Models\Assign_permission;
use App\Models\Journal_terms;
use App\Models\Copyright_master;
use App\Models\File_upload_type;
use App\Models\Attachment_file_description;
use App\Models\User_to_journals;
use App\Models\Article_types;
use App\Models\User_journal_classifications;
use App\Models\Authorize;
use App\Http\Traits\PlatformTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\UserDataTrait;
use App\Models\Email_templates;
use App\Http\Traits\KeywordTrait;
use JWTAuth;
use JWTAuthException;
use Config;
use DB;
use Exception;
use Illuminate\Support\Facades\Validator;
use \stdClass;

class Manage_Platform_User_Api extends Controller
{


    use RolesConfigTrait;
    use KeywordTrait;
    /*public function save_platform_user(Request $request)
    {
        try {

            $post_data = $request->all();
            $user_journal = $this->manage_users_platform($post_data);
            return $this->success('success',201,$user_journal );
        } catch (\Exception $e) {
			return $this->failure('Failure', 500, $e);
		}
    }*/
    public function save_platform_user(Request $request)
    {
        try {
            $user_journal = $request->all();
            $warning_msg = '';
            $warning_details = '';
            $warning_flag = false;
            $validator = Validator::make($request->all(), [
                'jnl_code'      => 'required',
                'platform_id'      => 'required',
                'user_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            DB::beginTransaction();
            /* TASK #2287 Improper access controls: Users with privileged roles can update their role using the 'saveplatformuser' API. */
            $user_journal['user_id'] = isset($user_journal['user_id']) ? explode(',', Rv_decrypt($user_journal['user_id'])) : '';
            if(isset($user_journal['core_role'])&& !empty($user_journal['core_role'])){
                $user_journal['core_role'] = Rv_decrypt($user_journal['core_role']);
            }
            $user_exists=User::get_single_record_with_bind_cond('count(usr_id) as count',['usr_id'=>$user_journal['user_id']]);
            if(isset($user_exists)){
                if (empty($user_exists)|| $user_exists->count == 0){
                    return $this->failure('Failed', 422, 'Invalid request parameters');
                }
            }

            /* Task #7987, If a role is retired for a user at the journal level, it should not be possible to assign that role to that user further in any article type unless the role is first unretired at the journal level. Currently, a retired role can still be added in another article type --> Start */
            if (isset($user_journal['type']) && !empty($user_journal['type']) && $user_journal['type'] == 'a') {
                
                $roles_array = (is_array($user_journal['roles'])) ? $user_journal['roles'] : explode(",", $user_journal['roles']);
                /* Task #1258, User role retire and inactive issue -> to check the conditions on adding new roles into users. */
                $current_role_diff = array_diff($roles_array, $user_journal['current_roles_to_edit']);
                $warning_data = $this->validate_save_platform_user_roles($user_journal['platform_id'], $user_journal['user_id'],$current_role_diff);
               
                /** Remove restricted user ids from the $user_journal['user_id'] */
                $user_journal['user_id'] = array_diff($user_journal['user_id'], $warning_data['usr_id']);
                if ($warning_data['error_status']) {
                    $warning_flag = $warning_data['error_status'];
                    $warning_msg = $warning_data['msg'];
                    $warning_details = $warning_data['data'];
                }
                if (count($user_journal['user_id']) == 0) {
                    if ($warning_data['error_status']) {
                        $return_arr['warn_msg']  = $warning_msg;
                        $return_arr['warn_flag']  = $warning_flag;
                        $return_arr['warn_data']  = $warning_details;
                        return $this->success('success', 201, $return_arr);
                    } else {
                        $return_arr['status']  = 'failed';
                        return $this->warning('Failure', 500, $return_arr);
                    }
                }
            }
            /* Task #7987, If a role is retired for a user at the journal level, it should not be possible to assign that role to that user further in any article type unless the role is first unretired at the journal level. Currently, a retired role can still be added in another article type --> End */

            /* end TASK #2287 Improper access controls: Users with privileged roles can update their role using the 'saveplatformuser' API. */
            $return_array = array();
            $current_user = $this->get_current_user_details();
            $role_ids = Roles::get_roles_data(array(
                'associate_editor'
            ));
            $this->current_user = $this->get_current_user_details();
            $artp_id = isset($user_journal['hdn_artp_id']) ? $this->decrypt_data($user_journal['hdn_artp_id']) : null;
            $standalone = $user_journal['standalone'] ?? 'n';
            $usrj_invite = 'n';
            $apply_all_article = 'n';
            $type = $user_journal['type'];
            $id = $user_journal['platform_id'];
            $role_used = $this->RolesConfigdata('privileged_user_roles');
            $user_data['usrj_jnl_id'] = $user_journal['platform_id'];
            if (isset($user_journal)) {
                if (is_array($user_journal['roles'])) {
                    $new_roles = $user_journal['roles'];
                } else {
                    $new_roles = explode(",", $user_journal['roles']);
                }
                $privillaged_users = $role_used['privileged_user_roles'];
                $current_date_time = date('Y-m-d H:i:s');

                if (isset($user_journal['edited_user_id']) && $user_journal['edited_user_id'] != "") {
                    $return_arr['operation'] = 'update';
                    $return_arr['removal_failed_roles'] = array();
                    $inserted_rows = 0;
                    $updated_rows = 0;
                    $classify_area_work = 'yes'; //for classification area working
                    $user_data['usrj_usr_id'] = $edit_user = $user_journal['edited_user_id'];

                    // $condition = "usrj_jnl_id={$user_journal['platform_id']}  AND usrj_usr_id={$user_journal['edited_user_id']}";
                    $condition = "usrj_jnl_id= ? AND usrj_usr_id= ?";
                    $bind_arr = [$user_journal['platform_id'],$user_journal['edited_user_id']];
                    if ($artp_id != '') {
                        $user_data['usrj_artp_id'] = $artp_id;
                        // $condition .= " AND usrj_artp_id ={$artp_id}";
                        $condition .= " AND usrj_artp_id = ?";
                        $bind_arr[] = $artp_id;
                    } else {
                        $condition .= " AND usrj_artp_id IS NULL";
                    }



                    $old_roles = User_to_journals::get_all_records('*', $condition,binding_arr:$bind_arr);
                    // TASK #7987, Retire and inactive issue changes applied as per the discussion start
                    $art_type_status = $user_journal['type'] == 'a' ? true : false;
                    $updated_user_roles_in_journal = implode(',', $user_journal['roles']);
                    if($art_type_status){
                        $check_journal_user_status = $this->check_roles_of_user_in_journal_change_details($user_journal['edited_user_id'],$id,$updated_user_roles_in_journal,$art_type_status,$artp_id);
                    }else{
                        $check_journal_user_status = $this->check_roles_of_user_in_journal_change_details($user_journal['edited_user_id'],$id,$updated_user_roles_in_journal,$art_type_status);
                    }
                    $return_arr['info_msg'] =(($check_journal_user_status!='') ? $check_journal_user_status :'');
                    // TASK #7987, Retire and inactive issue changes applied as per the discussion end
                    
                    $apply_all_article = 'n';
                    $classific_role_data = array();
                    //echo $apply_all_article; die;
                    if (!empty($old_roles)) {

                        $removed_list = array();
                        $update_data = array();
                        foreach ($old_roles as $old_role) {
                            $old_role_arr[] = $old_role->usrj_role_id;

                            if (($key = array_search($old_role->usrj_role_id, $new_roles)) === FALSE) {
                                $removed_list[] = $old_role->usrj_role_id;
                            } else {
                                //							$new_roles [] = $user_journal['journal_user_role'][$key];
                                // check user role and 'invite_author', to update change in 'invite_author'
                                // data to update if found change in 'invite_author'
                                if ($apply_all_article == "y" && in_array($old_role->usrj_role_id, $classific_role_data)) {
                                    $update_data[] = array(
                                        'usrj_id' => $old_role->usrj_id,
                                        'usrj_invite' => $usrj_invite,
                                        'usrj_posted_by' => $current_user['user_id'],
                                        'usrj_posted_date' => date('Y-m-d H:i:s'),
                                        'usrj_cpy_class_art_type' => "y"
                                    );
                                } else {

                                    $update_data[] = array(
                                        'usrj_id' => $old_role->usrj_id,
                                        'usrj_invite' => $usrj_invite,
                                        'usrj_posted_by' => $current_user['user_id'],
                                        'usrj_posted_date' => date('Y-m-d H:i:s'),
                                        'usrj_cpy_class_art_type' => "n"
                                    );
                                }
                            }
                            //						unset($new_roles[$key]);
                        }
                        // updating 'invite_author'
                        if (!empty($update_data))
                            User_to_journals::update_batch($update_data, 'usrj_id');

                        //any roel newly added
                        if (!empty($new_roles)) {
                            $insert_data = array();
                            $article_data = array();
                            if (!isset($user_data['usrj_artp_id'])) {
                                // $condition = "artp_jnl_id={$user_data['usrj_jnl_id']}";
                                $condition = "artp_jnl_id= ?";
                                $article_data = Article_types::get_all_records('artp_id', $condition,binding_arr:[$user_data['usrj_jnl_id']]);
                            }
                            foreach ($new_roles as $new_role) {
                                
                                if (in_array($new_role, $old_role_arr) == FALSE) {
                                    if (in_array($new_role, $removed_list) == FALSE) {
                                        $inserted_rows++;
                                        // start -- check role, and make 'usrj_invite' only for author if set

                                        $user_data['usrj_invite'] = $usrj_invite;
                                        // end -- check role, and make 'usrj_invite' only for author if set

                                        $user_data['usrj_role_id'] = $new_role;
                                        $user_data['usrj_posted_by'] = $current_user['user_id'];

                                        $user_data['usrj_posted_date'] = $current_date_time;

                                        if ($apply_all_article == "y" && in_array($new_role, $classific_role_data)) {
                                            $user_data['usrj_cpy_class_art_type'] = 'y';
                                        } else {
                                            $user_data['usrj_cpy_class_art_type'] = 'n';
                                            // }


                                            if (!isset($user_data['usrj_artp_id']))
                                                $user_data['usrj_artp_id'] = NULL;

                                            //Check the request not from Article Type
                                            if (!isset($user_data['usrj_artp_id'])) {
                                            }
                                            if (!empty($new_role)) {
                                                // $condition = "role_id={$new_role}";
                                                $condition = "role_id= ?";
                                                $res = Roles::get_single_record('role_assigned_role', $condition,binding_arr:[$new_role]);
                                                // $article_roles = array_keys($this->user->article_roles);
                                                $article_common_roles = $this->RolesConfigdata('article_user_role');
                                                $article_roles = array_keys($article_common_roles['article_user_role']);
                                                //add article role to article type
                                                $role_used = $this->RolesConfigdata('privileged_user_roles');
                                                $privillaged_users =  $role_used['privileged_user_roles'];
                                                // $user_journal['privilage_user'] ='a';

                                                if ((isset($user_journal['privilage_user']) && ($user_journal['privilage_user'] == "s" || $user_journal['privilage_user'] == "a")) && (in_array($res->role_assigned_role, $article_roles) || in_array($res->role_assigned_role, $privillaged_users))) {
                                                    $privillage_selected = FALSE;
                                                    if (isset($user_journal['privilage_user']) && $user_journal['privilage_user'] == "s") {
                                                        $privillage_selected = TRUE;
                                                    }
                                                    foreach ($article_data as $article) {
                                                        if ($privillage_selected == TRUE && isset($user_journal['selected_article_type']) && !in_array($article->artp_id, $user_journal['selected_article_type'])) {
                                                            continue;
                                                        }
                                                        // $condition = "usrj_jnl_id ={$user_data['usrj_jnl_id']} AND usrj_artp_id={$article->artp_id} AND usrj_jnl_id={$user_data['usrj_jnl_id']} AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$user_data['usrj_role_id']}";
                                                        $condition = "usrj_jnl_id = ? AND usrj_artp_id={$article->artp_id} AND usrj_jnl_id= ? AND usrj_usr_id= ? AND usrj_role_id= ?";

                                                        $user_role_in_artp = User_to_journals::get_single_record('count(*) as count', $condition,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_jnl_id'],$user_data['usrj_usr_id'],$user_data['usrj_role_id']]);
                                                        if ($article->artp_id != NULL && $user_role_in_artp->count == 0) {
                                                            $journal_user_data = $user_data;
                                                            $journal_user_data['usrj_artp_id'] = $article->artp_id;
                                                            $journal_user_data['usrj_invite'] = 'n';
                                                            $insert_data[] = $journal_user_data;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        /* start -- assign new user role to journal if the user doesn't have particular role in the journal */
                                        
                                        if (isset($user_data['usrj_artp_id']) && $user_data['usrj_artp_id'] != NULL) {
                                            /* $condition = "usrj_artp_id IS NULL AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$user_data['usrj_role_id']}";
                                             TASK #7317, Article type selection for article submisison ( roles in article and journal ) issue fix */
                                            $condition = "usrj_artp_id IS NULL AND usrj_usr_id= ? AND usrj_role_id= ? AND usrj_jnl_id= ?";
                                            $user_role_in_journal = User_to_journals::get_single_record('count(*) as count', $condition,binding_arr:[$user_data['usrj_usr_id'],$user_data['usrj_role_id'],$user_data['usrj_jnl_id']]);
                                            if ($user_role_in_journal != NULL && $user_role_in_journal->count == 0) {
                                                $journal_user_data = $user_data;
                                                $journal_user_data['usrj_artp_id'] = NULL;
                                                $journal_user_data['usrj_invite'] = 'n';

                                                //$user_data['usrj_role_id']
                                                if ($apply_all_article == "y" && in_array($journal_user_data['usrj_role_id'], $classific_role_data)) {
                                                    $journal_user_data['usrj_cpy_class_art_type'] = 'y';
                                                } else {
                                                    $journal_user_data['usrj_cpy_class_art_type'] = 'n';
                                                }
                                                $insert_data[] = $journal_user_data;
                                            }
                                        }

                                        /* end -- assign new user role to journal if the user doesn't have particular role in the journal */
                                        $insert_data[] = $user_data;
                                    }
                                }
                            }


                            if (count($insert_data) > 0) {
                                User_to_journals::insert_batch($insert_data);
                            }
                        }
                        $privillaged_role_arr = array();
                        if (isset($user_journal['privilage_user']) && ($user_journal['privilage_user'] == "s" || $user_journal['privilage_user'] == "a")) {
                            $role_used = $this->RolesConfigdata('privileged_user_roles');
                            $privillaged_users =  $role_used['privileged_user_roles'];
                            foreach ($new_roles as $single_roles) {
                                // $condition = "role_id={$single_roles}";
                                $condition = "role_id= ?";

                                $role_type = Roles::get_single_record('role_assigned_role', $condition,binding_arr:[$single_roles]);
                                if (in_array($role_type->role_assigned_role, $privillaged_users)) {
                                    array_push($privillaged_role_arr, $single_roles);
                                }
                            }
                        }
                        if (!empty($privillaged_role_arr)) {
                            $insert_bulk_data = array();
                            foreach ($privillaged_role_arr as $single_privillaged_role_arr) {
                                $journal_bulk_user_data = array();
                                /*$retire_data=array('usrj_artp_id'=>NULL,
                                'usrj_role_id'=>$single_privillaged_role_arr,
                                'usrj_jnl_id' => $user_data['usrj_jnl_id'],
                                'usrj_usr_id' => $user_data['usrj_usr_id'],
                                );*/
                                // $condition = "usrj_artp_id IS NULL AND usrj_role_id={$single_privillaged_role_arr} AND usrj_jnl_id={$user_data['usrj_jnl_id']} AND usrj_usr_id={$user_data['usrj_usr_id']}";
                                $condition = "usrj_artp_id IS NULL AND usrj_role_id={$single_privillaged_role_arr} AND usrj_jnl_id= ? AND usrj_usr_id= ?";
                                $retire_status = User_to_journals::get_single_record('usrj_role_retired', $condition,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_usr_id']]);
                                if (!empty($retire_status) && (isset($retire_status->usrj_role_retired) && $retire_status->usrj_role_retired == 'y')) {
                                    $journal_bulk_user_data['usrj_role_retired'] = $retire_status->usrj_role_retired;
                                } else {
                                    $journal_bulk_user_data['usrj_role_retired'] = "n";
                                }
                                $journal_bulk_user_data['usrj_jnl_id'] = $user_data['usrj_jnl_id'];
                                $journal_bulk_user_data['usrj_invite'] = 'n';
                                $journal_bulk_user_data['usrj_usr_id'] = $user_data['usrj_usr_id'];
                                $journal_bulk_user_data['usrj_role_id'] = $single_privillaged_role_arr;
                                $journal_bulk_user_data['usrj_posted_by'] = $current_user['user_id'];
                                $journal_bulk_user_data['usrj_posted_date'] = $current_date_time;
                                if ($apply_all_article == "y" && in_array($single_privillaged_role_arr, $classific_role_data)) {
                                    $journal_bulk_user_data['usrj_cpy_class_art_type'] = 'y';
                                } else {
                                    $journal_bulk_user_data['usrj_cpy_class_art_type'] = 'n';
                                }

                                // $condition = "artp_jnl_id={$user_data['usrj_jnl_id']}";
                                $condition = "artp_jnl_id= ?";
                                $article_data = Article_types::get_all_records('artp_id', $condition,binding_arr:[$user_data['usrj_jnl_id']]);

                                $privillage_selected = FALSE;
                                if (isset($user_journal['privilage_user']) && $user_journal['privilage_user'] == "s") {
                                    $privillage_selected = TRUE;
                                }

                                foreach ($article_data as $article) {
                                    if ($privillage_selected == TRUE && isset($user_journal['selected_article_type']) && !in_array($article->artp_id, $user_journal['selected_article_type'])) {
                                        // $condition = "usrj_jnl_id ={$user_data['usrj_jnl_id']} AND usrj_artp_id={$article->artp_id}  AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$single_privillaged_role_arr}";
                                        $condition = "usrj_jnl_id = ? AND usrj_artp_id={$article->artp_id}  AND usrj_usr_id= ? AND usrj_role_id={$single_privillaged_role_arr}";                                      
                                        $user_role_in_artp = User_to_journals::get_single_record('count(*) as count', $condition,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_usr_id']]);
                                        if ($article->artp_id != NULL && $user_role_in_artp->count !== 0) {
                                            $role_required = $this->check_role_required("a", $article->artp_id, $user_data['usrj_usr_id'], $single_privillaged_role_arr);
                                            if ($role_required['status'] === false) {
                                                // $delete_condition = "usrj_jnl_id ={$user_data['usrj_jnl_id']} AND usrj_artp_id={$article->artp_id}  AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$single_privillaged_role_arr}";
                                                $delete_condition = "usrj_jnl_id = ? AND usrj_artp_id={$article->artp_id}  AND usrj_usr_id= ? AND usrj_role_id={$single_privillaged_role_arr}";
                                                //$delete_condition =  array('usrj_jnl_id' => $user_data['usrj_jnl_id'], 'usrj_artp_id' => $article->artp_id, 'usrj_usr_id' => $user_data['usrj_usr_id'], 'usrj_role_id' => $single_privillaged_role_arr);
                                                User_to_journals::delete_records($delete_condition, NULL, $this->current_user,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_usr_id']]);
                                            }
                                        }
                                        continue;
                                    }
                                    $journal_bulk_user_data['usrj_artp_id'] = $article->artp_id;
                                    // $condition = "usrj_jnl_id={$user_data['usrj_jnl_id']} AND usrj_artp_id={$article->artp_id} AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$single_privillaged_role_arr}";
                                    $condition = "usrj_jnl_id= ? AND usrj_artp_id={$article->artp_id} AND usrj_usr_id= ? AND usrj_role_id={$single_privillaged_role_arr}";
                                    $user_role_in_artp = User_to_journals::get_single_record('count(*) as count', $condition,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_usr_id']]);
                                    if ($article->artp_id != NULL && $user_role_in_artp->count == 0) {
                                        $insert_bulk_data[] = $journal_bulk_user_data;
                                    }
                                }
                            }
                            if (!empty($insert_bulk_data)) {
                                User_to_journals::insert_batch($insert_bulk_data);
                            }
                        }


                        //any role remove
                        if (!empty($removed_list)) {

                            unset($user_data['usrj_role_id']);
                            //unset($user_data['usrj_status']);
                            unset($user_data['usrj_invite']);
                            unset($user_data['usrj_posted_date']);
                            unset($user_data['usrj_posted_by']);

                            $removed_list_allow = array(); // this array holds "not required" removed roles

                            if ($type === 'a') {
                                $update_data = array();
                                $return_arr['removal_failed_roles_msg'] = customTrans('platform_settings.role_removal_failed') . '<br>';
                                foreach ($removed_list as $removed_list_role_id) {
                                    $role_required = $this->check_role_required($type, $artp_id, $edit_user, $removed_list_role_id);
                                    if ($role_required['status'] === false) {
                                        array_push($removed_list_allow, $removed_list_role_id);
                                    } else {
                                        $condition = "role_id={$removed_list_role_id}";
                                        $temp = Roles::get_single_record('role_name', $condition);
                                        /*array_push($return_arr['removal_failed_roles'], array(
                                'role_name' => $temp->role_name,
                                'reason' => $role_required['reason']
                            ));
                            $return_arr['removal_failed_roles_msg'].=$temp->role_name.'-'.$role_required['reason'].'.<br>'; */
                                        $role_required_exists = false;
                                        foreach ($return_arr['removal_failed_roles'] as $element) {
                                            if ($element['reason'] === $role_required['reason']) {
                                                $role_required_exists = true;
                                            }
                                        }
                                        if (!$role_required_exists) {
                                            array_push($return_arr['removal_failed_roles'], array(
                                                'role_name' => $temp->role_name,
                                                'reason' => $role_required['reason']
                                            ));
                                            $return_arr['removal_failed_roles_msg'] .= $temp->role_name . '-' . $role_required['reason'] . '.<br>';
                                        }
                                        if ($usrj_invite === 'y') {
                                            foreach ($old_roles as $old_role) {
                                                if ($old_role->usrj_role_id == $removed_list_role_id) {
                                                    array_push($update_data, array(
                                                        'usrj_id' => $old_role->usrj_id,
                                                        'usrj_invite' => 'y',
                                                        'usrj_posted_by' => $this->current_user['user_id'],
                                                        'usrj_posted_date' => $current_date_time,
                                                        'usrj_cpy_class_art_type' => 'n'
                                                    ));
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                                if (!empty($removed_list_allow)) {
                                    if (count($update_data) > 0) {
                                        User_to_journals::update_batch($update_data, 'usrj_id');
                                    }
                                    $del_result = User_to_journals::delete_records_wherein($user_data, $this->current_user,$removed_list_allow,'usrj_role_id','');
                                    // $del_result = User_to_journals::del_user_roles($user_data, $removed_list_allow);
                                    foreach ($removed_list_allow as $single_removed_list_allow) {
                                        //$where_condition = array('usrj_jnl_id' => $user_data['usrj_jnl_id'], 'usrj_usr_id' => $user_data['usrj_usr_id'], 'usrj_role_id' => $single_removed_list_allow);
                                        // $where_condition = "usrj_jnl_id={$user_data['usrj_jnl_id']} AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$single_removed_list_allow}";
                                        $where_condition = "usrj_jnl_id= ? AND usrj_usr_id= ? AND usrj_role_id={$single_removed_list_allow}";
                                        $get_all_types = User_to_journals::get_all_records("*", $where_condition,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_usr_id']]);
                                        if (count($get_all_types) == 1) {
                                            if ($get_all_types[0]->usrj_artp_id == NULL) {
                                                $cond = "usrj_id={$get_all_types[0]->usrj_id}";
                                                $delete_user_from_journal = User_to_journals::delete_records($cond, NULL, $this->current_user);
                                            }
                                        }
                                    }
                                } else {
                                    if ($updated_rows === 0 && $inserted_rows === 0) {
                                        $return_arr['status'] = 'failed';
                                        $return_arr['msg'] = '';
                                        $return_arr['type'] = $type;
                                        // $return_arr['id'] = $id;
                                        $return_arr['user_update'] = $edit_user;

                                        DB::commit();
                                        return ($return_arr);
                                    } else {
                                        if (count($update_data) > 0) {
                                            User_to_journals::update_batch($update_data, 'usrj_id');
                                        }
                                    }
                                }
                            } else {
                                unset($user_data['usrj_artp_id']);
                                $update_data = array();
                                $role_required['status'] = false;
                                $return_arr['removal_failed_roles_msg'] = customTrans('platform_settings.role_removal_failed') . '<br>';
                                foreach ($removed_list as $removed_list_role_id) {
                                    $role_required = $this->check_role_required($type, $id, $edit_user, $removed_list_role_id);
                                    //print_r($role_required);exit;
                                    if (isset($role_required['status']) && $role_required['status'] == false) {
                                        array_push($removed_list_allow, $removed_list_role_id);
                                    } else {
                                        $condition = "role_id={$removed_list_role_id}";
                                        $temp = Roles::get_single_record('role_name', $condition);
                                        /*array_push($return_arr['removal_failed_roles'], array(
                                'role_name' => $temp->role_name,
                                'reason' => $role_required['reason']
                            ));
                            $return_arr['removal_failed_roles_msg'].=$temp->role_name.'-'.$role_required['reason'].'.<br>'; */
                                        $role_required_exists = false;
                                        foreach ($return_arr['removal_failed_roles'] as $element) {
                                            if ($element['reason'] === $role_required['reason']) {
                                                $role_required_exists = true;
                                            }
                                        }
                                        if (!$role_required_exists) {
                                            array_push($return_arr['removal_failed_roles'], array(
                                                'role_name' => $temp->role_name,
                                                'reason' => $role_required['reason']
                                            ));
                                            $return_arr['removal_failed_roles_msg'] .= $temp->role_name . '-' . $role_required['reason'] . '.<br>';
                                        }
                                        if ($usrj_invite === 'y') {
                                            foreach ($old_roles as $old_role) {
                                                if ($old_role->usrj_role_id == $removed_list_role_id) {
                                                    array_push($update_data, array(
                                                        'usrj_id' => $old_role->usrj_id,
                                                        'usrj_invite' => 'y',
                                                        'usrj_posted_by' => $this->current_user['user_id'],
                                                        'usrj_posted_date' => $current_date_time,
                                                        'usrj_cpy_class_art_type' => 'n'
                                                    ));
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                                if (!empty($removed_list_allow)) {
                                    if (count($update_data) > 0) {
                                        User_to_journals::update_batch($update_data, 'usrj_id');
                                    }
                                    // $del_result = User_to_journals::del_user_roles($user_data, $removed_list_allow);
                                    $del_result = User_to_journals::delete_records_wherein($user_data, $this->current_user,$removed_list_allow,'usrj_role_id','');
                                } else {
                                    if ($updated_rows === 0 && $inserted_rows === 0) {
                                        $return_arr['status'] = 'failed';
                                        $return_arr['msg'] = '';
                                        $return_arr['type'] = $type;
                                        $return_arr['id'] = $id;
                                        $return_arr['user_update'] = $edit_user;

                                        DB::commit();
                                        return ($return_arr);
                                    } else {
                                        if (count($update_data) > 0) {
                                            User_to_journals::update_batch($update_data, 'usrj_id');
                                        }
                                    }
                                }
                            }



                            $user_current_roles = isset($user_journal['journal_user_role']) ? $user_journal['journal_user_role'] : [];
                            if (!empty($role_ids)) {
                                $delete_classification_flag = true;
                                //$delete_classification_flag = false; // do not delete classification
                                foreach ($role_ids as $r_id) {
                                    if (in_array($r_id->role_id, $user_current_roles)) {
                                        $delete_classification_flag = false; //classification should be deleted
                                    }
                                    /*if (in_array($r_id->role_id, $removed_list_allow))
                    {
                        $delete_classification_flag = true; //classification should be deleted
                    }*/
                                }

                                if ($delete_classification_flag === true)

                                    //$this->User_journal_classifications->delete_classification_user($id, 's', $type, $edit_user, true);


                                    // $this->User_journal_classifications->delete_classification_user($id, 'p', $type, $edit_user, true);
                                    $classify_area_work = 'no';
                            }
                            foreach ($role_ids as $r_id) {
                                if (in_array($r_id->role_id, $removed_list) && (!in_array($r_id->role_id, $removed_list_allow))) {
                                    $classify_area_work = 'no';
                                }
                            }
                        }
                        if (isset($type) && $type == 'a') {
                            $return_arr['msg'] = customTrans('platform_settings.articleroleupdates');
                        } else {
                            if(env('VITE_CONFERENCE_PROCEEDINGS') === true){
                                $pltFrm     =  'Conference';
                            }
                            else {
                                $pltFrm     =   $this->current_client->platform_type;
                            }
                            $return_arr['msg'] = customTrans('platform_settings.jnlroleupdates') . ' ' . $pltFrm;
                        }
                        $return_arr['status'] = 'update';
                    }
                } else {

                    if ($artp_id != '') {
                        foreach ($user_journal['user_id'] as $user) {
                            $user_data['usrj_usr_id'] = $user;

                            foreach ($new_roles as $role) {
                                /*$retire_data=array('usrj_artp_id'=>NULL,
                        'usrj_role_id'=>$role,
                        'usrj_jnl_id' => $user_data['usrj_jnl_id'],
                        'usrj_usr_id' => $user_data['usrj_usr_id'],
                        );*/
                                // $retire_data = "usrj_jnl_id={$user_journal['platform_id']} AND usrj_artp_id=NULL AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$role}";
                                $retire_data = "usrj_jnl_id= ? AND usrj_artp_id=NULL AND usrj_usr_id= ? AND usrj_role_id= ?";
                                $retire_status = User_to_journals::get_single_record('usrj_role_retired', $retire_data,binding_arr:[$user_journal['platform_id'],$user_data['usrj_usr_id'],$role]);
                                if (!empty($retire_status) && (isset($retire_status->usrj_role_retired) && $retire_status->usrj_role_retired == 'y')) {
                                    $user_data['usrj_role_retired'] = $retire_status->usrj_role_retired;
                                } else
                                    $user_data['usrj_role_retired'] = "n";
                                // start -- check role, and make 'usrj_invite' only for author, if set
                                // $res = Roles::get_single_record('role_assigned_role', "role_id={$role}");
                                $res = Roles::get_single_record('role_assigned_role', "role_id= ?",binding_arr:[$role]);

                                $user_data['usrj_invite'] = $usrj_invite;
                                // end -- check role, and make 'usrj_invite' only for author if set

                                $user_data['usrj_artp_id'] = $artp_id;
                                $user_data['usrj_role_id'] = $role;

                                if ($apply_all_article == "y" && in_array($user_data['usrj_role_id'], $classific_role_data)) {
                                    $user_data['usrj_cpy_class_art_type'] = 'y';
                                } else {
                                    $user_data['usrj_cpy_class_art_type'] = 'n';
                                }

                                // $main_user_data_condition = "usrj_usr_id='{$user_data['usrj_usr_id']}' AND usrj_role_retired='{$user_data['usrj_role_retired']}' AND usrj_cpy_class_art_type='{$user_data['usrj_cpy_class_art_type']}' AND usrj_artp_id='{$user_data['usrj_artp_id']}' AND usrj_role_id={$user_data['usrj_role_id']}";
                                $main_user_data_condition = "usrj_usr_id= ? AND usrj_role_retired= ? AND usrj_cpy_class_art_type= ? AND usrj_artp_id= ? AND usrj_role_id= ?";
                                $user_role_cnt = User_to_journals::get_single_record('count(*) as cnt', $main_user_data_condition,binding_arr:[$user_data['usrj_usr_id'],$user_data['usrj_role_retired'],$user_data['usrj_cpy_class_art_type'],$user_data['usrj_artp_id'],$user_data['usrj_role_id']]);

                                if ($user_role_cnt->cnt == 0) {
                                    $user_data['usrj_posted_by'] = $current_user['user_id'];
                                    $user_data['usrj_posted_date'] = $current_date_time;
                                    /* start -- assign new user role to journal if the user doesn't have particular role in the journal */
                                    if ($user_data['usrj_artp_id'] != NULL) {
                                        // $user_role_condition = "usrj_jnl_id={$user_data['usrj_jnl_id']} AND usrj_artp_id IS NULL AND usrj_usr_id={$user_data['usrj_usr_id']}  AND usrj_role_id={$user_data['usrj_role_id']}";
                                        $user_role_condition = "usrj_jnl_id= ? AND usrj_artp_id IS NULL AND usrj_usr_id= ? AND usrj_role_id= ?";
                                        $user_role_in_journal = User_to_journals::get_single_record('count(*) as count', $user_role_condition,binding_arr:[$user_data['usrj_jnl_id'],$user_data['usrj_usr_id'],$user_data['usrj_role_id']]);
                                        if ($user_role_in_journal != NULL && $user_role_in_journal->count == 0) {
                                            $journal_user_data = $user_data;
                                            $journal_user_data['usrj_artp_id'] = NULL;
                                            $journal_user_data['usrj_invite'] = 'n';

                                            if ($apply_all_article == "y" && in_array($journal_user_data['usrj_role_id'], $classific_role_data)) {
                                                $journal_user_data['usrj_cpy_class_art_type'] = 'y';
                                            } else {
                                                $journal_user_data['usrj_cpy_class_art_type'] = 'n';
                                            }

                                            $insert_data[] = $journal_user_data;
                                        }
                                    }

                                    /* end -- assign new user role to journal if the user doesn't have particular role in the journal */
                                    $insert_data[] = $user_data;
                                    //	$this->User_to_journals->insert_record($user_data, $current_user);
                                }
                            }
                        }
                    } else {
                        $user_data = array('usrj_jnl_id' => $user_journal['platform_id']);
                        // $criteria = "artp_jnl_id={$user_journal['platform_id']}";
                        $criteria = "artp_jnl_id= ?";
                        $article_data = Article_types::get_all_records('artp_id', $criteria,binding_arr:[$user_journal['platform_id']]);
                        // print_r($article_data);exit;

                        foreach ($user_journal['user_id'] as $user) {
                            $user_data['usrj_usr_id'] = $user;
                            foreach ($user_journal['roles'] as $role) {
                                $user_data['usrj_artp_id'] = NULL;
                                $user_data['usrj_invite'] = $usrj_invite;
                                $user_data['usrj_role_id'] = $role;
                                // $condition = "usrj_jnl_id={$user_journal['platform_id']} AND usrj_artp_id=NULL AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$role}";
                                $condition = "usrj_jnl_id= ? AND usrj_artp_id=NULL AND usrj_usr_id= ? AND usrj_role_id= ?";

                                $user_role_cnt = User_to_journals::get_single_record('count(usrj_id) as cnt', $condition,binding_arr:[$user_journal['platform_id'],$user_data['usrj_usr_id'],$role]);

                                if (!empty($user_role_cnt) && $user_role_cnt->cnt == 0) {
                                    //   if($apply_all_article == "y" && in_array($user_data['usrj_role_id'],$classific_role_data))
                                    // {
                                    //  $user_data['usrj_cpy_class_art_type'] = 'y';
                                    //  }
                                    // else
                                    // {
                                    $user_data['usrj_cpy_class_art_type'] = 'n';
                                    // }
                                    $user_data['usrj_posted_by'] = $current_user['user_id'];
                                    $user_data['usrj_proxy_id'] = $current_user['proxy_user_id'];
                                    $user_data['usrj_posted_date'] = date('Y-m-d H:i:s');
                                    $insert_data[] = $user_data;
                                }
                                // $criteria = "role_id='{$role}'";
                                $criteria = "role_id= ?";
                                $res = Roles::get_single_record('role_assigned_role', $criteria,binding_arr:[$role]);

                                $article_common_roles = $this->RolesConfigdata('article_user_role');
                                $article_roles = array_keys($article_common_roles['article_user_role']);
                                //  print_r($article_common_roles['article_user_role']);exit;
                                // print_r($article_common_roles);exit;
                                // $article_roles = array_keys($article_common_roles['article_user_role']);
                                // print_r($article_common_roles);exit;

                                $role_used = $this->RolesConfigdata('privileged_user_roles');
                                $privillaged_users =  $role_used['privileged_user_roles'];
                                if ((isset($user_journal['privilage_user']) && ($user_journal['privilage_user'] == "s" || $user_journal['privilage_user'] == "a")) && (in_array($res->role_assigned_role, $article_roles) || in_array($res->role_assigned_role, $privillaged_users))) {
                                    $privillage_selected = FALSE;
                                    if (isset($user_journal['privilage_user']) && $user_journal['privilage_user'] == "s") {
                                        $privillage_selected = TRUE;
                                    }
                                    foreach ($article_data as $article) {
                                        if ($privillage_selected == TRUE && isset($user_journal['selected_article_type']) && !in_array($article->artp_id, $user_journal['selected_article_type'])) {
                                            continue;
                                        }
                                        // $condition = "usrj_jnl_id={$user_journal['platform_id']} AND usrj_artp_id={$article->artp_id} AND usrj_usr_id={$user_data['usrj_usr_id']} AND usrj_role_id={$user_data['usrj_role_id']}";
                                        $condition = "usrj_jnl_id= ? AND usrj_artp_id={$article->artp_id} AND usrj_usr_id= ? AND usrj_role_id= ?";
                                        $user_role_cnt_in_artp = User_to_journals::get_single_record('count(usrj_id) as cnt', $condition,binding_arr:[$user_journal['platform_id'],$user_data['usrj_usr_id'],$user_data['usrj_role_id']]);
                                        if (!empty($user_role_cnt_in_artp) && $user_role_cnt_in_artp->cnt == 0) {
                                            /*  if($apply_all_article == "y" && in_array($user_data['usrj_role_id'],$classific_role_data))
                            {
                                $user_data['usrj_cpy_class_art_type'] = 'y';
                            }
                            else
                            {*/
                                            $user_data['usrj_cpy_class_art_type'] = 'n';
                                            //  }
                                            $user_data['usrj_artp_id'] = $article->artp_id;
                                            $user_data['usrj_invite'] = 'n';
                                            $insert_data[] = $user_data;


                                        }
                                    }
                                }
                            }
                            //update standalone jnl id in users if the user is added for standalone jnl

                            if($standalone == 'y'){
                                $exist_standalone = User::get_single_record('usr_jnl_standalone', "usr_id = {$user} ");
                                if($exist_standalone && ($exist_standalone->usr_jnl_standalone == null || $exist_standalone->usr_jnl_standalone == $user_journal['platform_id'])){
                                    User::update_record(['jnl_standalone' => $user_journal['platform_id']], " usr_id = {$user} ", $this->current_user );
                                }
                                else{
                                    throw new Exception('User is already associated with other standalone Journal');
                                }
                            }
                        }
                    }
                    if (!empty($insert_data)) {
                        //print_r($insert_data);exit;
                        User_to_journals::insert_batch($insert_data);
                    }
                    if (isset($type) && $type == 'a') {
                        $return_arr['msg'] = customTrans('platform_settings.articleroleadded');
                    } else {
                        if(env('VITE_CONFERENCE_PROCEEDINGS') === true){
                            $pltFrm     =  'Conference';
                        }
                        else {
                            $pltFrm     =   $this->current_client->platform_type;
                        }
                        $return_arr['msg'] = customTrans('platform_settings.jnlroleadded') . ' ' . $pltFrm;
                    }
                    $return_arr['status']  = 'insert';
                }
                if (isset($user_journal['invite_author']) && $user_journal['invite_author'] != '' && !empty($user_journal['invite_author'])) {
                    $etmp_name = 'journal_invitation';
                    if (isset($user_journal['hdn_artp_id'])) {
                        $user_data['usrj_artp_id'] = $artp_id;
                        $type = 'a';
                        $id = $artp_id;
                        $etmp_name = 'article_type_invitation';
                    }
                    $criteria = "etmp_name = '{$etmp_name}' AND etmp_notification = 'User'";
                    $email_tmpls = Email_templates::get_single_record('etmp_id,etmp_name,etmp_notification', $criteria);
                   //Task #486 Email is not sent properly when add or remove a role in journal
                    $new_role = $user_journal['roles'];
                    $ex_role = $user_journal["current_roles_to_edit"];
                    $role_details=array();
                    $added_role_names=array();
                    $newly_added_roles='';
                    $added_roles = array_diff($new_role, $ex_role);// Find added roles
                    if (!empty($added_roles)) {
                    $condition='role_id IN (' . implode(',', $added_roles) . ')';
                    $role_details = Roles::get_all_records('role_id,role_name,role_assigned_role', $condition);
                    if (!empty($role_details))
                    {
                        foreach ($role_details as $role)
                        {
                            if ($role && !in_array($role->role_assigned_role, ['reviewer', 'author'])) {
                            $added_role_names[] = $role->role_name;
                            }
                        }
                    }
                     $newly_added_roles = implode(',', $added_role_names);
                }
                    if ($email_tmpls != null) { // eventhough the checkbox is checked, we should check whether there is any email template for this purpose
                        $usrj_invite = 'y';
                        $custom_data = array(
                            'jnl_id' => $user_journal['platform_id'],
                            'jnl_code' => $user_journal['jnl_code']
                        );
                        //Task #486 Email is not sent properly when add or remove a role in journal
                        if (isset($newly_added_roles) && !empty($newly_added_roles)) {
                            $custom_data['newly_added_roles'] = $newly_added_roles;
                        }
                        if (isset($artp_id) && !empty($artp_id)) {
                            $custom_data['artp_id'] = $artp_id;
                        }
                        if (is_array($user_journal['user_id'])&& !empty($newly_added_roles)) {
                            foreach ($user_journal['user_id'] as $usrid) {
                                $email_data = array(
                                    'type' => 'global',
                                    'action' => 'send',
                                    'email_with_login' => true,
                                    'user_id' => $usrid,
                                    'empt_name' => $etmp_name,
                                    'custom_data' => $custom_data,
                                    'jnl_user_role' => array(
                                        'core_role' => $user_journal['roles'],
                                        // 'role_name'=>$jnl_array['role_name'],
                                        'jnl_id' => $user_journal['platform_id'],
                                        'jnl_journal_code' => $user_journal['jnl_code']
                                    ),
                                );
                                $this->master_email_details($email_data);
                            }
                        } elseif (is_numeric($user_journal['user_id'])&&!empty($newly_added_roles)) {
                            $email_data = array(
                            'type' => 'global',
                                'action' => 'send',
                                'email_with_login' => true,
                                'user_id' => $user_journal['user_id'],
                                'empt_name' => $etmp_name,
                                'custom_data' => $custom_data,
                                'jnl_user_role' => array(
                                    'core_role' => $user_journal['roles'],
                                    // 'role_name'=>$jnl_array['role_name'],
                                    'jnl_id' => $user_journal['platform_id'],
                                    'jnl_journal_code' => $user_journal['jnl_code']
                                ),
                            );
                            $this->master_email_details($email_data);
                        }
                    }
                }
                /* deleteing roles from article type(remove_user_role_journal)*/
                if (isset($role_required['status']) && $role_required['status'] === false) {
                    if (isset($artp_id) && !empty($user_journal["current_roles_to_edit"])) {

                        $new_role = $user_journal['roles'];

                        $ex_role = $user_journal["current_roles_to_edit"];
                        $role_diff = array_diff($ex_role, $new_role);
                        foreach ($role_diff as $key => $value) {
                            // $condition = "usrj_jnl_id={$user_journal['platform_id']} AND  usrj_role_id={$value} AND usrj_usr_id={$user_journal['edited_user_id']}";
                            $condition = "usrj_jnl_id= ? AND  usrj_role_id={$value} AND usrj_usr_id= ?";
                            $chk_exist = User_to_journals::get_single_record("count(*) as article_count", $condition,binding_arr:[$user_journal['platform_id'],$user_journal['edited_user_id']]);
                            //if($chk_exist->article_count > 2)
                            // if the number is 2 then if 2 article type have arole and removed role from one article type then removed from another article type and journal and it's 1 in review2 also.
                            if ($chk_exist->article_count > 1) {
                                // $cond = "usrj_jnl_id={$user_journal['platform_id']} AND  usrj_role_id={$value} AND usrj_usr_id={$user_journal['edited_user_id']} AND usrj_artp_id={$artp_id}";
                                $cond = "usrj_jnl_id= ? AND  usrj_role_id={$value} AND usrj_usr_id={$user_journal['edited_user_id']} AND usrj_artp_id= ?";
                                User_to_journals::delete_records($cond, NULL, $this->current_user,binding_arr:[$user_journal['platform_id'],$artp_id]);
                            } else {
                                // $cond = "usrj_jnl_id={$user_journal['platform_id']} AND  usrj_role_id={$value} AND usrj_usr_id={$user_journal['edited_user_id']}";
                                $cond = "usrj_jnl_id= ? AND  usrj_role_id={$value} AND usrj_usr_id= ?";
                                User_to_journals::delete_records($cond, NULL, $this->current_user,binding_arr:[$user_journal['platform_id'],$user_journal['edited_user_id']]);
                            }
                        }
                    }
                }
                /* deleteing roles from article type(remove_user_role_journal)*/
                DB::commit();
                if($warning_flag){
                    $return_arr['warn_msg']  = $warning_msg;
                    $return_arr['warn_flag']  = $warning_flag;
                    $return_arr['warn_data']  = $warning_details;
                }
                return $this->success('success', 201, $return_arr);

            } else {
                DB::commit();
                $return_arr['status']  = 'failed';
                return $this->warning('Failure', 500, $return_arr);
            }

        } catch (\Exception $e) {
            DB::rollback();
            return $this->failure('Failure', 500, $e->getMessage());
        }
    }
    public function get_choose_userdata(Request $request)
    {
        try {

            $postdata = $request->all();
            $validator = Validator::make($request->all(), [
                'platform_id'      => 'required',
                'type'      => 'required',
                'user_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }

            $user_id = $postdata['user_id'];
            $type = $postdata['type'];; //$this->input->post('type', TRUE);
            $platform_id = $postdata['platform_id'];
            $condition = "usrj_usr_id={$user_id}";

            if ($type === 'a') {
                $article_id = $this->decrypt_data($platform_id);
                $condition .= " AND usrj_artp_id={$article_id}";
            } else {
                $condition .= " AND usrj_jnl_id={$platform_id}";
            }

            $roles = User_to_journals::get_all_roles($condition, TRUE, $type);
            $last_sent_date = '';
            for ($i = 0; $i < count($roles); $i++) {
                if ($roles[$i]->usrj_invite === 'y') {
                    if ($type === 'j') {
                        $condition .= ' AND usrj_artp_id IS NULL';
                    }
                    //	$date_format = User_to_journals::$date_format_map[$this->jnl_data->jset_date_format] . ' %H:%i';
                    //	$temp = $this->User_to_journals->get_single_record("DATE_FORMAT(max(usrj_posted_date), '" . $date_format . "')AS max_usrj_posted_date", $condition);
                    //	$last_sent_date = $temp->max_usrj_posted_date;
                    //	break;
                }
            }

            $privillaged_roles = array();
            if ($type === 'j') {
                $all_roles = Roles::get_all_records();
                $role_used = $this->RolesConfigdata('privileged_user_roles');
                $privillaged_user =  $role_used['privileged_user_roles'];
                foreach ($all_roles as $single_all_roles) {
                    if (in_array($single_all_roles->role_assigned_role, $privillaged_user)) {
                        array_push($privillaged_roles, $single_all_roles->role_id);
                    }
                }
            }
            $return_array['roles'] = $roles;
            $return_array['privillaged_roles'] = $privillaged_roles;
            if ($type === 'j') {
                $conditions = "artp_jnl_id={$platform_id}";
                $return_array['all_article_types'] = Article_types::get_all_records('artp_id,artp_article_type', $conditions);
            }
            return $this->success('success', 200, $return_array);
            /*echo json_encode(array(
			'status' => $status,
			'roles' => $roles,
                        'type'  =>$type,
			'last_sent_date' => $last_sent_date,
			'role_retire_status'=> $this->current_client->functionality->cfty_retire_role,
			'privillaged_roles' => $privillaged_roles
		));*/
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    //delete user from journal
    public function delete_admin_journal_user(Request $request)
    {
        try {
            $del_data = $request->all();
            $validator = Validator::make($request->all(), [
                'type'      => 'required',
                'id'      => 'required',
                'usr_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
            $this->current_user = $this->get_current_user_details();
            $return_arr = array();
            $id = $del_data['id'];
            $usr_id = $this->decrypt_data($del_data['usr_id']);
            $type = $del_data['type'];
            $check_journal_user_status = '';    // TASK #7987, Retire and inactive issue fix

            //	$id = decrypt_link($del_data['id']);
            //	$usr_id = $this->decrypt_link($del_data['usr_id']);
            //$type = $del_data['type'];

            if (!empty($del_data) && !empty($del_data['id']) && !empty($del_data['usr_id'])) {

                if ($type === 'a') {

                    $id = $this->decrypt_data($id);
                    $user_required = $this->check_user_required($type, $id, $usr_id, NUll);
                    if ($user_required['status'] === true) {
                        $return_arr['status'] = 'failed';

                        $return_arr['msg'] = $user_required['reason'];
                        //$return_arr['msg'] = "Remove failed";
                        return  $this->warning('Failed', 200, $return_arr);
                    }

                    // TASK #7987, Retire and inactive issue changes applied as per the discussion start
                    $art_type_status = ($type == 'a') ? true : false;
                    $art_type_id = $id;
                    $get_jnl_id = Article_types::get_single_record_with_bind_cond("artp_jnl_id",array("artp_id"=>$id));
                    $jnl_id = (isset($get_jnl_id->artp_jnl_id) && !empty($get_jnl_id->artp_jnl_id)) ? $get_jnl_id->artp_jnl_id : '';
                    $check_journal_user_status = $this->check_roles_of_user_in_journal_change_details($usr_id, $jnl_id,null,$art_type_status,$art_type_id);
                    // TASK #7987, Retire and inactive issue changes applied as per the discussion end                    

                    /*	$criteria = array(
					'usrj_usr_id' => $usr_id,
					'usrj_artp_id' => $id
				);*/
                    $criteria = "usrj_usr_id={$usr_id} AND usrj_artp_id={$id}";
                    $records = User_to_journals::get_all_records('*', $criteria);

                    User_to_journals::delete_records($criteria, '', $this->current_user);
                    //$this->User_journal_classifications->delete_classification_user($id, 's', $type, $usr_id, false);
                    //$this->User_journal_classifications->delete_classification_user($id, 'p', $type, $usr_id, false);

                    //for delete the role of a user from journal if that role exist only for that article type

                    foreach ($records as $record) {
                        $journal_id = $record->usrj_jnl_id;
                        $user_role_id = $record->usrj_role_id;
                        $chk_exist = User_to_journals::get_single_record('count(*) as article_count', "usrj_jnl_id={$journal_id} AND usrj_role_id ={$user_role_id} AND usrj_usr_id={$usr_id} AND usrj_artp_id IS NOT NULL");
                        if ($chk_exist->article_count == 0) {
                            User_to_journals::delete_records("usrj_jnl_id={$journal_id} AND usrj_role_id ={$user_role_id} AND usrj_usr_id ={$usr_id}", '', $this->current_user);
                        }
                    }
                } else {

                    $user_required['status'] = false;
                    //	$user_required =Article_flow::check_user_required($type, $id, $usr_id);
                    $user_required = $this->check_user_required($type, $id, $usr_id, NUll);
                    //  $return_arr['msg']=customTrans('platform_settings.user_removal_failed').'<br>';
                    if (isset($user_required['status']) && $user_required['status'] === true) {
                        $return_arr['status'] = 'failed';
                        $condition = "role_id={$id}";
                        $temp = Roles::get_single_record('role_name', $condition);
                        // $return_arr['msg'].=$temp->role_name.'-'.$user_required['reason'].'.<br>';
                        $return_arr['msg'] = $user_required['reason'];
                        return  $this->warning('Failed', 200, $return_arr);
                    }
                    $check_journal_user_status = $this->check_roles_of_user_in_journal_change_details($usr_id, $id);    // TASK #7987, Retire and inactive issue fix

                    $criteria = "usrj_usr_id={$usr_id} AND usrj_jnl_id={$id}";
                    /*$criteria = array(
					'usrj_usr_id' => $usr_id,
					'usrj_jnl_id' => $id
				);*/
                    User_to_journals::delete_records($criteria, '', $this->current_user);
                    //	$this->User_journal_classifications->delete_classification_user($id, 's', $type, $usr_id, true);
                    //$this->User_journal_classifications->delete_classification_user($id, 'p', $type, $usr_id, true);
                }



                $return_arr['status'] = 'success';
                $remaining = '';


                if ($type === 'a') {
                    $return_arr['msg'] = customTrans('platform_settings.artroleremoved');
                } else {
                    $return_arr['msg'] = customTrans('platform_settings.jnlroleremoved') . ' ' . customTrans(':journal');
                }
                $return_arr['info_msg'] = ($check_journal_user_status != '') ? $check_journal_user_status : '';     // TASK #7987, Retire and inactive issue fix
                return  $this->success('Success', 201, $return_arr);
            } else {
                $return_arr['status'] = 'failed';
                $return_arr['msg'] = "Role Can not delete";
                return  $this->warning('Failed', 200, $return_arr);
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function get_proxy_platform_users(Request $request)
    {

        try {

            //$current_user=$this->get_current_user_details();
            $post_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            /*
        if(isset($this->current_user['proxy_user_id'])&& $this->current_user['proxy_user_id']==0)
        $current_user_id=$this->current_user['user_id'];
        else
        $current_user_id=$this->current_user['proxy_user_id'];
        */
            $crnt_usr_id = $this->current_user;

            $search = $post_data['searchitem'];
            $jnl_code = $post_data['platform_code'];

            $search_data = array();
            $return_arr = array(
                'status' => 'err'
            );

            if ($search != '' && $jnl_code != '') {

                $enable_terms = FALSE;
                if (isset($this->current_client->functionality->cfty_show_terms_conditions) && $this->current_client->functionality->cfty_show_terms_conditions == 'y') {
                    $enable_terms = TRUE;
                }
                $search_db_data = User_to_journals::get_proxy_journal_users($jnl_code, $search, $crnt_usr_id, $enable_terms);

                foreach ($search_db_data as $user) {
                    $search_data[] = array(
                        'label' => $user->user . ' (' . $user->roles . ')',
                        'value' => $this->encrypt_data($user->usr_id)

                    );
                }
                $return_arr['status'] = 'success';
                $return_arr['search_data'] = $search_data;
            }
            return  $this->success('Success', 200, $return_arr);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function proxy_login_user(Request $request)
    {

        try {
            $allow_login = true;
            if (!$request['exit_proxy']) {
                $validator = Validator::make($request->all(), [
                    'jnl_id' => 'required',
                    'login_user_id' => 'required',
                    'pxy_login_user' => 'required',
                ]);
            } else {
                $validator = Validator::make($request->all(), [
                    'jnl_id' => 'required',
                    'login_user_id' => 'required',
                ]);
            }
            if ($validator->fails()) {
                return $this->warning('Failed', 422, $validator->errors());
            }
            $post_data = $request->all();
            $jnl_code = Rv_decrypt($post_data['jnl_id']);
            $login_user_id = Rv_decrypt($post_data['login_user_id']);
            $pxy_login_user = (isset($post_data['pxy_login_user'])) ? Rv_decrypt($post_data['pxy_login_user']) : "";
            //$jnl_condition = "jnl_journal_code ='{$jnl_code}'";
            $jnl_condition = array("jnl_journal_code" => $jnl_code);
            $jnl_data = Journals::get_single_record_with_bind_cond('jnl_id', $jnl_condition);
            $jnl_id = $jnl_data->jnl_id;
            if (isset($this->current_client->functionality->cfty_enable_proxy_priority) && $this->current_client->functionality->cfty_enable_proxy_priority == 'y' && $post_data['exit_proxy'] == FALSE) {
                $allow_login = $this->check_user_role_permission($login_user_id, $pxy_login_user, $jnl_id);
            }
            if ($allow_login) {
                if (isset($post_data['exit_proxy']) && $post_data['exit_proxy'] == TRUE)
                    return $this->exit_proxy_token_generate($post_data);
                else
                    return $this->proxy_token_generete($post_data);
            } else {
                return response()->json([
                    'success' => true,
                    'token' => null,
                    'token_flag' => 'priority_error',
                ]);
            }
        } catch (\Exception $e) {

            return  $this->warning('Failed', 500, $e);
        }
    }

    public function proxy_token_generete($post_data)
    {
        $return_array = array();
        $proxy_user_id = Rv_decrypt($post_data['pxy_login_user']);
        $login_user_id = Rv_decrypt($post_data['login_user_id']);

        $user = Authorize::where('usr_id', $proxy_user_id)->get()->first();

        if (!empty($user)) {
            if ($proxy_user_id != $login_user_id) {
                $token = JWTAuth::customClaims(['user_id' => $proxy_user_id, 'proxy_user_id' => $login_user_id])->fromUser($user);
                //JWTAuth::fromUser($user);
                return response()->json([
                    'success' => true,
                    'token' => $token,
                    'token_type' => 'bearer',
                    'expires_in' =>  auth('api')->factory()->getTTL() * 60
                ]);
            } else {
                return  $this->failure('Failed to Proxy', 500, $return_array);
            }
        } else
            $response = ['success' => false, 'message' => 'User not found !!'];
        return  $response;
    }
    public function exit_proxy_token_generate($post_data)
    {

        $login_user_id = Rv_decrypt($post_data['login_user_id']);

        $user = Authorize::where('usr_id', $login_user_id)->get()->first();

        if (!empty($user)) {
            $token = JWTAuth::customClaims(['user_id' => $login_user_id, 'proxy_user_id' => $login_user_id])->fromUser($user);
            //JWTAuth::fromUser($user);
            return response()->json([
                'success' => true,
                'token' => $token,
                'token_type' => 'bearer',
                'expires_in' =>  auth('api')->factory()->getTTL() * 60
            ]);
        } else
            $response = ['success' => false, 'message' => 'User not found !!'];
        return  $response;
    }
    public function search_journal_keyword(Request $request)
    {
        try {
            $return_arr = array();
            $hierarchy = $this->current_client->functionality->cfty_keyword_hierarchy;
            $Keywords = new \App\Models\Keywords();
            $validator = Validator::make($request->all(), [
                'platform_id'      => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $post_data = $request->all();
            $platform_id = decrypt_link($post_data['platform_id']);
            if ($hierarchy == "c") {
                $select = 'kwd_id,kwd_name,kwdrl_id,kwdrl_inactive';
                $group_by = 'kwd_id';
                $where = '';
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $where .= "kwdrl_inactive ='n' ";
                $keywords = $Keywords::get_keywords($where, $select, NULL, NULL, $group_by, $this->current_client->functionality->cfty_keyword_hierarchy);
            } else {
                $select = 'kwd_id,kwd_name,kwdrl_id,kwdrl_inactive';
                $group_by = 'kwd_id';
                // $where = "kwdrl_jnl_id={$platform_id}";
                $where = "kwdrl_jnl_id= ?";
                if ($this->current_client->functionality->cfty_keyword_inactive == 'y')
                    $where .= " and	kwdrl_inactive ='n' ";

                $keywords = $Keywords::get_keywords($where, $select, NULL, NULL, $group_by, $this->current_client->functionality->cfty_keyword_hierarchy,binding_arr:[$platform_id]);
            }
            // $condition = "artp_jnl_id={$platform_id}";
            $condition = "artp_jnl_id= ?";
            $return_arr['all_article_types'] = Article_types::get_all_records('artp_id,artp_article_type', $condition,binding_arr:[$platform_id]);
            $enable_browse = FALSE;

            if (isset($this->current_client->functionality->cfty_browse_keywords_in_submission) && $this->current_client->functionality->cfty_browse_keywords_in_submission == 'y') {
                $Keywords = new \App\Models\Keywords();
                $total = $Keywords::search_journal_keywords($platform_id, FALSE, NULL, FALSE, NULL, NULL, TRUE);
                if (isset($total) && $total[0]->cnt > 0) {
                    $enable_browse = TRUE;
                }
            }
            $return_arr['keywordmethod'] = $this->KeywordData('keywordmethod')['keywordmethod'];
            $return_arr['enable_browse'] = $enable_browse;
            $return_arr['hierarchy'] = $hierarchy;
            $return_arr['keywords'] = $keywords;
            return $this->success('success', 200, $return_arr);
        } catch (\Exception $e) {

            return  $this->failure('Failed', 500, $e);
        }
    }

    public function check_user_role_permission($current_user_id, $proxy_user_id, $jnl_id)
    {
        $allow_login = true;
        $crnt_userrole_array = [];
        $proxy_userrole_array = [];
        $crnt_usr_role_condition = "usrj_usr_id = ? AND usrj_jnl_id = ? AND usrj_role_retired = 'n' "; /** TASK #8527, priority of roles checks from the non retired roles of a user in the journal*/
        $crnt_user_roles = User_to_journals::get_all_roles($crnt_usr_role_condition, FALSE, binding_arr:[$current_user_id, $jnl_id]);
        if (count($crnt_user_roles) > 0) {
            foreach ($crnt_user_roles as $role) {
                array_push($crnt_userrole_array, $role);
            }
        };
        $proxy_usr_role_condition = "usrj_usr_id = ? AND usrj_jnl_id = ? ";
        $proxy_user_roles = User_to_journals::get_all_roles($proxy_usr_role_condition, FALSE, binding_arr:[$proxy_user_id, $jnl_id]);
        if (count($proxy_user_roles) > 0) {
            foreach ($proxy_user_roles as $role) {
                array_push($proxy_userrole_array, $role);
            }
        };
        $priority_roles = $this->RolesConfigdata('priority_roles')['priority_roles'];
        usort($priority_roles, function ($a, $b) {
            return $a['priority'] - $b['priority'];
        });
        $current_user_prior = $this->highest_role_user($priority_roles, $crnt_userrole_array);
        $proxy_user_prior = $this->highest_role_user($priority_roles, $proxy_userrole_array);
        if ($current_user_prior > $proxy_user_prior) {
            $allow_login = false;
        }
        return $allow_login;
    }
    public function highest_role_user($priority_roles, $user_roles)
    {
        $roles = array_map(function ($element) {
            return is_object($element) ? $element->role_assigned_role : $element['role_assigned_role'];
        }, $user_roles);
        $priority = '';
        foreach ($priority_roles as $pr) {
            $core_role = $pr['core_role'];
            if (in_array($core_role, $roles)) {
                $priority = $pr['priority'];
                break;
            } else
                continue;
        }
        return $priority;
    }
}
