<?php

namespace App\Http\Controllers\Platform;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\Generic_flows;
use App\Models\Generic_forms;
use App\Models\Article_flow;
use App\Models\Advance_flow_movement;
use App\Models\Ftp;
use Illuminate\Support\Facades\Storage;
use Config;
use DB;
use App\Http\Traits\WorkflowDataTrait;
use App\Http\Traits\RolesDataTrait;
use App\Http\Traits\EncryptionTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Http\Traits\LayoutexportimportTrait;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;
use App\Models\Stage_email_templates;
use App\Models\Stage_email_tmpl_reference;
use App\Models\Article_type_advance_options;
use App\Models\Attachment_file_description;
use App\Models\Required_file_type;
use App\Models\Copyright_master;
use App\Models\Journal_settings;
use App\Models\Article_types;
use Response;
use App\Http\Traits\WorkflowTrait;
use App\Models\Flags;
use App\Models\Generic_form_elements;

/*

*/

class Manage_Workflow_Api extends Controller
{
    use WorkflowDataTrait;
    use RolesDataTrait;
    use EncryptionTrait;
    use LayoutexportimportTrait;
    use RolesConfigTrait;
    use WorkflowTrait;
    public $current_user;
    /*
    get all node
    commited date :-  13-03-2022
    Request type :- GET
    */
    public function index(Request $request)
    {

        try {
            $post_data = $request->all();
            $data = [];
            if(!empty($post_data))
            {
            $idarray = array('input'=>$post_data['workflow_id'],'type'=>'number', 'enc_data'=>FALSE ); 
            $workflowidesciption= $this->Rv_validator($idarray);
            if($workflowidesciption===false)
            {
                $return_arr['msg'] = customTrans('workflow.stage_detail_failed_message');
                return $this->warning("Failed",201,$return_arr);     
            }
            //get flow nodes
            $criterianode = 'jwf_fwm_id=' . $post_data['workflow_id'];
            $work_flow = Generic_flows::get_all_records('count(*) as nodes',  $criterianode);
            if ($work_flow[0]->nodes == 0)
		    {
                $submission_role = 'author';
			    $stage_name = ($this->current_client->modules->mdl_conference == 'y')?'Abstract Submission':'Article Submission';
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);
                if($this->current_client->modules->mdl_review_for_doc == 'y' && isset($review_flow['author_submission']['roles'][0]))
			    {
				$submission_role = $review_flow['author_submission']['roles'][0];
				$stage_name = $review_flow['author_submission']['label'];
			    }
                //get author role id
                $criteriarole = "role_assigned_role='{$submission_role}'";
			    $author_role = Roles::get_single_record('role_id', $criteriarole);
                $currentdate=date('Y-m-d H:i:s');
                //insert default stages
                $jnl_base_stages = array(
                    array(
                        'jwf_fwm_id' => $post_data['workflow_id'],
                        'jwf_stage_name' => $stage_name,
                        'jwf_stage_type' => 'author_submission',
                        'jwf_start' => 'y',
                        'jwf_role_id' => $author_role->role_id,
                        //'jwf_forms' => '[]',
                        'jwf_tab_name' => $stage_name,
                        'jwf_status_name' => $stage_name,
                        'jwf_ypos' => '',
                        'jwf_xpos' => '',
                        'jwf_posted_date' => $currentdate
                    )
                );
                if($this->current_client->modules->mdl_review_for_doc == 'n')
                {
                    $jnl_base_stages[] = array(
                            'jwf_fwm_id' => $post_data['workflow_id'],
                            'jwf_stage_name' => 'Transit',
                            'jwf_stage_type' => 'transit',
                            'jwf_start' => 'n',
                            'jwf_role_id' => $author_role->role_id,
                            //'jwf_forms' => '[]',
                            'jwf_tab_name' => 'Transfer',
                            'jwf_status_name' => 'Transit',
                            'jwf_ypos' => '0',
                            'jwf_xpos' => '3.3',
                            'jwf_posted_date' => $currentdate
                        );
                }
                Generic_flows::insert_batch($jnl_base_stages);
                
            }

          
            $criteria = 'jwf_fwm_id=' . $post_data['workflow_id'].' AND jwf_hide_status=\'n\'';
            $workflow = Generic_flows::get_all_records('*', $criteria);
            $init_stage = array('author_submission', 'transit');
            $non_prev_roles=$this->RolesConfigdata('non_privileged_user_roles');
            $non_prev_role_array=$non_prev_roles['non_privileged_user_roles'];
            $this->current_user = $this->get_current_user_details();
            $artp = $this->decrypt_data($post_data['art_id']);
            if (!empty($workflow)) {
                $data = $this->format_workflow_data($workflow, $init_stage,$non_prev_role_array,$artp);
            }
            $show_export_flow_btn = false;
            $where_stg = "jwf_fwm_id={$post_data['workflow_id']} AND jwf_stage_type ='production'";
            if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
            {
            $where_stg = "jwf_fwm_id={$post_data['workflow_id']} AND jwf_stage_type ='publish'";
            }
            $perfect_flow = Generic_flows::get_single_record('count(jwf_id) as cnt',$where_stg);
         
            if($perfect_flow->cnt > 0)
            {
                $show_export_flow_btn = true;
            }
            $show_import_flow_btn = false;
			if (isset($this->current_user) && !empty($this->current_user['roles'])  && isset($this->current_user['roles']) && (in_array('sudo', $this->current_user['roles']) || in_array('super_admin', $this->current_user['roles'])))
			{
				$show_import_flow_btn = true;
			}
            $enable_reset_btn = false;
			if (isset($this->current_user)  && isset($this->current_user['roles']) && in_array('sudo', $this->current_user['roles']))
			{
				$enable_reset_btn = true;
			}
            $data['show_export_flow_btn'] =$show_export_flow_btn;
            $data['show_import_flow_btn'] =$show_import_flow_btn;
            $data['enable_reset_btn'] =$enable_reset_btn;
        	return $this->success("Success",200,$data);
          
            }
            else
            {

                return $this->success("Failed",200,$data);
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    /* 
    Node Form populated data based on stage type
    */
    public function get_stage_based_form_data(Request $request)
    {
        try {
            $form_data = $request->all();
            $current_stage = $form_data['current_stage'];
            $jnl_id = null;
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);
            $role_keys = $review_flow[$current_stage]['roles'];
            $has_generic_form = 1;
			if (isset($review_flow[$current_stage]['generic_form']))
			{
				$has_generic_form = $review_flow[$current_stage]['generic_form'];
			}
            $rolelist = "'" . implode("','", $role_keys) . "'";
            $role_details = $this->get_roles($rolelist);
            $criteria = 'role_assigned_role IN(' . $rolelist . ')';
            $role_details = Roles::get_all_records('*', $criteria);

            $return_array['stageroles'] = $role_details;
            
            $condition = array();
            if (isset($form_data['jnl_id']) && $form_data['jnl_id'] != ''){
                $jnl_id = $form_data['jnl_id'];
                $condition = "gncf_form_type = '" . $current_stage . "' AND (gncf_jnl_id IS NULL OR gncf_jnl_id = " . $jnl_id . ")";
            } else {
                $condition = "gncf_form_type = '" . $current_stage . "' AND gncf_jnl_id IS NULL";
            }
            $form_details = Generic_forms::get_all_records('gncf_id,gncf_form_name, gncf_jnl_id', $condition);
            $stage_upload_flag = '';
            $file_descriptions = array();
			$show_description = false;
            if ($this->current_client->modules->mdl_production == 'y' && isset($review_flow[$current_stage]['stage_for']) && isset($review_flow[$current_stage]['upload_type']) && $review_flow[$current_stage]['stage_for'] == 'manageproduction' && ($review_flow[$current_stage]['upload_type'] == 'optional' || $review_flow[$current_stage]['upload_type'] == 'required' ))
            {
                if($review_flow[$current_stage]['upload_type'] == 'required')
                {
                    $stage_upload_flag = 'r';
                }
            else{
                $stage_upload_flag = 'o';
                }
            }if ($this->current_client->modules->mdl_production == 'y' && isset($review_flow[$current_stage]['stage_for']) && isset($review_flow[$current_stage]['upload_type']) && $review_flow[$current_stage]['stage_for'] == 'manageproduction')
			{
                $show_description = true;
                $Attachment_file_description_tbl = (new \App\Models\Attachment_file_description())->getTable();
                $Required_file_type_tbl = (new \App\Models\Required_file_type())->getTable();
                $join_tables = array(
                        'main_table' => $Attachment_file_description_tbl,
                        'join_table' => array(
                            $Required_file_type_tbl => array($Attachment_file_description_tbl . '.afdec_id', $Required_file_type_tbl . '.rft_file_desp_id')
                ));
                $select = 'afdec_id,afdec_description';
                 if (isset($form_data['arttype']) && $form_data['arttype'] != '')
                {
                    $article_type_id = $this->decrypt_data($form_data['arttype']);
                    $criteria =  " FIND_IN_SET('p',afdec_apply_stage_type) AND rft_jnl_id={$jnl_id} AND rft_artp_id={$article_type_id}";
                }
                else 
                {
                    $criteria =  " FIND_IN_SET('p',afdec_apply_stage_type) AND rft_jnl_id={$jnl_id} AND rft_artp_id IS NULL";   
                } 
                $file_descriptions = Attachment_file_description::get_results_using_joins($join_tables, $select, $criteria,'all'); 
   
            }
             /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            //workflow assignment type
            $workflow_assignment_type_selection = $this->workflow_assignment_type_seletion_status($current_stage);
            $return_array['source_assign_status'] = $workflow_assignment_type_selection['source_assign_status'];
            $return_array['destination_assign_status'] = $workflow_assignment_type_selection['destination_assign_status'];
                if($return_array['source_assign_status'] === true)
                {
                    $return_array['all_source_assign'] = $this->get_workflow_assignment_type_for_source_stage();
                }
                if($return_array['destination_assign_status'] === true)
                {
                    $current_flow_master_id = $form_data['jwf_id'];
                    $return_array['all_destination_assign'] = $this->get_workflow_assignment_type_for_destination_stage($current_flow_master_id);
                }
             /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review end */
            $return_array['stage_saved_forms'] = [];
            if(isset($form_data['jnl_wrkflw_id']) && isset($form_data['operation']) && $form_data['operation']=="edit"){
                $criteria = ' jwf_id=' . decrypt_link($form_data['jnl_wrkflw_id']);
                $jnl_wrkflw_details = Generic_flows::get_single_record('jwf_forms', $criteria);
                $return_array['stage_saved_forms'] = json_decode($jnl_wrkflw_details->jwf_forms);
            }
            $return_array['stage_upload_flag'] = $stage_upload_flag;
            $return_array['show_description'] = $show_description;
            $return_array['file_descriptions'] = $file_descriptions;
            $return_array['form_details'] = $form_details;
            $return_array['has_generic_form'] = $has_generic_form;
            return $this->success("Success",200,$return_array);
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }


    /*
     Save node details
    commited date :-  13-03-2022
    Request type :- POST
*/
    public function save_node(Request $request)
    {
       // DB::beginTransaction();
        try {
            $formdata = $request->all();
            $return_arr = array();
            $validator = Validator::make($request->all(), [
                //'workflowform_parentstage' => 'required',
                'workflowform_privilegeduserstagename' => 'required',
                'workflowform_textforstagebutton'=> 'required',
                'workflowform_stagetype'   => 'required',
                'workflowform_textfortab' => 'required',
                'workflowform_nonprevilegeduserstagename'=>'required',
                'workflowform_userrole'=>'required'
                //'workflowform_tat_complete'=>'required'
            ]);
            if ($validator->fails()) {
               return $this->failure("Failed",201,$validator->errors());
                
            }
           
            $privilearray = array('input'=>$formdata['workflowform_privilegeduserstagename'],'type'=>'string', 'enc_data'=>false );
            $txtstagebtnarray = array('input'=>$formdata['workflowform_textforstagebutton'],'type'=>'string', 'enc_data'=>false );
            $txttabarray = array('input'=>$formdata['workflowform_textfortab'],'type'=>'string', 'enc_data'=>false );
            $nonprivilearray = array('input'=>$formdata['workflowform_nonprevilegeduserstagename'],'type'=>'string', 'enc_data'=>false );
            $userolearray = array('input'=>$formdata['workflowform_userrole'],'type'=>'number', 'enc_data'=>false );
            $privile= $this->Rv_validator($privilearray);
            $txtstagebtn= $this->Rv_validator($txtstagebtnarray);
            $txttab= $this->Rv_validator($txttabarray);
            $nonprivile= $this->Rv_validator($nonprivilearray);
            $userolecheck= $this->Rv_validator($userolearray);
            $jnlcode=$formdata['workflow_platform_data']??null;
            if($privile===false)
                {
                    $return_arr['msg'] = customTrans('workflow.txt_stage_btn');
                    return $this->warning("Failed",201,$return_arr);
                }
            if($txtstagebtn===false)
                {
                    $return_arr['msg'] = customTrans('workflow.txt_stage_name');
                    return $this->warning("Failed",201,$return_arr);
                }
            if($txttab===false)
                {
                    $return_arr['msg'] = customTrans('workflow.txt_tab_name');
                    return $this->warning("Failed",201,$return_arr);
                }
            if($nonprivile===false)
                {
                    $return_arr['msg'] = customTrans('workflow.txt_non_privilege');
                    return $this->warning("Failed",201,$return_arr);
                }
            if($userolecheck===false)
                {
                    $return_arr['msg'] = customTrans('workflow.user_role_validation');
                    return $this->warning("Failed",201,$return_arr);
                }

            $workflow_flow_stages =  isset($formdata['workflow_flow_stages']) ? $formdata['workflow_flow_stages'] :'';
            if($workflow_flow_stages!='author_submission')
            {
                $validator = Validator::make($request->all(), [
                    'workflowform_parentstage' => 'required',
                    'workflowform_tat_complete'=>'required'
                ]); 
                if ($validator->fails()) {
                    return $this->failure("Failed",201,$validator->errors());
                     
                 }
            }
             if($workflow_flow_stages=='review')
             {
                $minarray = array('input'=>$formdata['workflowform_min_reviewers'],'type'=>'number', 'enc_data'=>false );
                $maxarray = array('input'=>$formdata['workflowform_max_reviewers'],'type'=>'number', 'enc_data'=>false );
                $artclemin= $this->Rv_validator($minarray);
                $artclemax= $this->Rv_validator($maxarray);
                if($artclemin===false)
                {
                    $return_arr['msg'] = customTrans('workflow.min_reviewr');
                    return $this->warning("Failed",201,$return_arr);
                }
                if($artclemax===false)
                {
                    $return_arr['msg'] = customTrans('workflow.max_reviewr');
                    return $this->warning("Failed",201,$return_arr);
                }
                
             }if (isset($formdata['workflow_editor_assessment']) && $formdata['workflow_editor_assessment'] == 'invitation')
             {
                $validator = Validator::make($request->all(), [
                    'workflowform_shortlisting_carried_out' => 'required',
                    'workflowform_invite_carried_out' => 'required'
                ]);
                if ($validator->fails()) {
                    return $this->failure("Failed",201,$validator->errors());
                 }
             }
             elseif (isset($formdata['workflow_editor_assessment']) && $formdata['workflow_editor_assessment'] == 'manual')
             {
                $validator = Validator::make($request->all(), [
                    'workflowform_shortlisting_carried_out' => 'required'
                ]); 
                if ($validator->fails()) {
                    return $this->failure("Failed",201,$validator->errors());
                 }
             }
             
             if(isset($formdata['flowformenableautodecline']) && $formdata['flowformenableautodecline'] == '1')
             {
                $validator = Validator::make($request->all(), [
                    'workflowform_tatautodecline' => 'required'
                ]); 
                if ($validator->fails()) {
                    return $this->failure("Failed",201,$validator->errors());
                 }
                
             }
             if(isset($formdata['genericform_required']) && $formdata['genericform_required'] == '1')
             {
               
                //TASK #3039 - new validation here
                $workflowform = $formdata['workflowform'];
                $validator = Validator::make($workflowform, [
                    '*.form_id' => 'required',
                ],[
                    '*.form_id' => 'Form is required'
                ]);
                $return = array(
                    'status' => 'failed', 'msg' => customTrans('workflow.form_required')
                );
                if ($validator->fails()) {
                    return $this->failure("Failed",201,$return);
                 }
             }
             if(isset($formdata['workflowform_stagedescription']) && !empty($formdata['workflowform_stagedescription']))
             {
                $stagedescriptonarray = array('input'=>$formdata['workflowform_stagedescription'],'type'=>'string', 'enc_data'=>false );
                $stagedesrion= $this->Rv_validator($stagedescriptonarray);
                if($stagedesrion===false)
                {
                    $return_arr['msg'] = customTrans('workflow.txt_stage_descripton');
                    return $this->warning("Failed",201,$return_arr);
                }
             }
            /* Post the data values  */
            $this->current_user = $this->get_current_user_details();
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $flow_master_id = $formdata['workflow_flow_master_id'];
            $parent_stage_list = isset($formdata['workflowform_parentstage']) ? $formdata['workflowform_parentstage'] : array();
            $stage_name = $formdata['workflowform_privilegeduserstagename'];
            $stagetype = $formdata['workflowform_stagetype'];
            $tabname = $formdata['workflowform_textfortab'];
            $tempnonprevilegeduserstagename = $formdata['workflowform_tempnonprevilegeduserstagename'];
            $status_name = $formdata['workflowform_nonprevilegeduserstagename'];
            $user_role = $formdata['workflowform_userrole'];
            $stage_form = isset($formdata['workflowform_stageform']) ? $formdata['workflowform_stageform'] : '[]';
            $stage_description =  isset($formdata['workflowform_stagedescription']) ? $formdata['workflowform_stagedescription'] :'';
            $stage_button_title = $formdata['workflowform_textforstagebutton'];
            $shotlist_carried_out = isset($formdata['workflowform_shortlisting_carried_out']) ? $formdata['workflowform_shortlisting_carried_out'] :array();
            $invite_carried_out = isset($formdata['workflowform_invite_carried_out']) ? $formdata['workflowform_invite_carried_out'] :array();
            $avoid_email_role_notification = isset($formdata['workflowform_avoid_email_notification']) ? $formdata['workflowform_avoid_email_notification'] :array();
            $default_assignment = 'self_service';
            $arrowbeginwith = $formdata['workflowform_arrowbeginwith'];
            // $removeflags=[];
            // $removed_forms=[];

            /* Post Stage data array */

            $stage_data = array(
                'jwf_fwm_id' => $flow_master_id,
                'jwf_stage_name' => $stage_name,
                'jwf_stage_type' => $stagetype,
                'jwf_tab_name' => $tabname,
                'jwf_temporary_status_name' => $tempnonprevilegeduserstagename,
                'jwf_status_name' => $status_name,
                'jwf_no_of_min_users' => 1,
                'jwf_no_of_max_users' => 1,
                'jwf_reviewers_assignment' => '',
                'jwf_reviewers_filltype' => '',
                'jwf_reviewers_discuss_forum' => '',
                'jwf_assignment' => '',
                'jwf_parent_user_roles' => '',
                'jwf_who_can_invite' => '',
                'jwf_avoid_email_notifications_to_roles' => '',
                'jwf_classification_filter' => '',
                'jwf_classification_primary' => '',
                'jwf_classification_secondary' => '',
                'jwf_stage_description' => '',
                'jwf_article_editable' => 0,
                'jwf_enable_transfer' =>0,
                'jwf_tat_accept' => 0,
                'jwf_tat_complete' => 0,
                'jwf_tat_decline' => 0,
                'jwf_role_id' => $user_role,
                'jwf_temp_id' => 0,
                //'jwf_ypos' => $ypos,
                //'jwf_xpos' => 1,
                'jwf_stage_description' => $stage_description,
                'jwf_button_title' => $stage_button_title,
                'jwf_arrow_begin_with' =>$arrowbeginwith,
                'jwf_enable_popup_after_completion' =>'',
                'jwf_article_attachment_status'=>'',
                'jwf_enable_ithenticate' => 'n',
                'jwf_import_user_role_err'=>null,
                'jwf_import_custom_form_err'=>null,
                // Task #925 research_integrity_checking
                'jwf_enable_research_integrity' => 'n',
            );
            /* Load config file and stage list */
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $review_flow  = Config::get($workflow_config);

            /* When module production  */
            if ($this->current_client->modules->mdl_production == 'y' && isset($review_flow[$stagetype]['stage_for']) && isset($review_flow[$stagetype]['upload_type']) && $review_flow[$stagetype]['stage_for'] == 'manageproduction' && ($review_flow[$stagetype]['upload_type'] == 'optional' || $review_flow[$stagetype]['upload_type'] == 'required')) {
                $stage_data['jwf_production_upload'] = (isset($formdata['upload_type']) ? $formdata['upload_type']:'n');
                if ($this->current_client->modules->mdl_production == 'y' && isset($formdata['file_description'])) {
                    $stage_data['jwf_afdec_ids'] = json_encode($formdata['file_description']);
                }
            }
            //manage popup on completion 
            if (isset($this->current_client->functionality->cfty_manage_popup_on_completion) && ($this->current_client->functionality->cfty_manage_popup_on_completion == 'y')) {
                if((isset($formdata['workflow_enable_popup_on_stage_completion'])))
                {
                    $stage_data['jwf_enable_popup_after_completion'] = ($formdata['workflow_enable_popup_on_stage_completion'] == 'y') ? 'y' : 'n';
                }
               }
            /*** Customisation #2537 - JPR-411 Resubmission after reject ***/
            $stage_data['jwf_resubmission_after_reject'] = ($formdata['workflow_resubmission_rejection'] == 'y') ? 'y' : 'n';

            /*** Customisation #2044 - JPR-322 Feedback on transfer functionality ***/
            $stage_data['jwf_enable_transfer'] = (isset($formdata['workflow_new_stage_art_transfer']) && $formdata['workflow_new_stage_art_transfer'] == 1) ? 'y' : 'n';

            /*** Prevent authors from making changes to authorship ***/
            $stage_data['jwf_prevent_edit'] = (isset($formdata['workflow_prevent_authors_edit']) && $formdata['workflow_prevent_authors_edit'] == 1) ? 'y' : 'n';

            /*Feature #1050confirm_casrai_credits*/

            $stage_data['jwf_confirm_casrai_credits'] = (isset($formdata['confirm_casrai_credits']) && $formdata['confirm_casrai_credits'] == 1) ? 'y' : 'n';
            /*Feature Confirm Cascarin credict  #1050*/

            $stage_data['jwf_confirm_orcid'] = (isset($formdata['confirm_orcid']) && $formdata['confirm_orcid'] == 1) ? 'y' : 'n';

            /*Feature Confirm Submission Data  #1050*/
            $stage_data['jwf_edit_submission_date'] = (isset($formdata['workflow_edit_submision_date']) && $formdata['workflow_edit_submision_date'] == 1) ? 'y' : 'n';
            
            /*** Auto scroll view article ***/
            $stage_data['jwf_scroll_viewarticle'] = (isset($formdata['workflow_scroll_view_article']) && $formdata['workflow_scroll_view_article'] == 1) ? 'y' : 'n';
           
            /*
			 Process and assign posted values to array stage_data - Generic forms 
			 */
            //TASK #3039 - reordering workflowforms
           
            if(isset($formdata['workflowform'])&& is_array($formdata['workflowform'])){
                $form_ids = array_values(array_filter(array_column($formdata['workflowform'],'form_id')));
                if(count($form_ids)>0){
                    $stage_data["jwf_forms"] =  json_encode($form_ids);
                    if($workflow_flow_stages!='review'){
                        $valid_flags = array();
                        foreach($form_ids as $form_id){
                            $valid_flags[$form_id] = Generic_form_elements::where('emt_gucf_id', $form_id)
                                            ->whereNotNull('emt_flag_id')
                                            ->where(DB::raw('JSON_LENGTH(emt_flag_id)'), '>', 0)
                                            ->pluck('emt_flag_id')
                                            ->map(function ($form_id) {
                                                return json_decode($form_id, true);
                                            })
                                            ->filter() // Filter out null/empty results from json_decode
                                            ->toArray();     
                        }
                        $duplicateValues = [];
                        $allValues = [];
                      
                        foreach ($valid_flags as $formId => $flagArrays) {
                           
                            foreach ($flagArrays as $flagArray) {
                                if (is_array($flagArray)) {
                                    foreach ($flagArray as $innerArray) {
                                        if (is_array($innerArray)) {
                                            $allValues = array_merge($allValues, array_values($innerArray));
                                        }
                                    }
                                  
                                }
                            }
                        
                            $valueCounts = array_count_values($allValues);
                            $duplicates = array_keys(array_filter($valueCounts, function ($count) {
                                return $count > 1;
                            }));
                        
                            if (!empty($duplicates)) {
                                $duplicateValues[$formId] = $duplicates;
                            }
                        }
                        // $duplicateValues now contains the duplicate values for each form_id
                        DB::statement("SET SESSION group_concat_max_len = 1000000");

                        if(isset( $duplicateValues) && count($duplicateValues) >0)
                        {
                            foreach($duplicateValues as $duplicate_flag  => $flagval){
                                if (is_array($flagval) && !empty($flagval)) { // Ensure $flagval is an array and not empty
                                    /*
                                    $removeflags = Flags::whereIn('flag_id', $flagval)
                                    ->selectRaw("CASE WHEN COUNT(flag_name) = 1 THEN MAX(flag_name) WHEN COUNT(flag_name) = 2 THEN GROUP_CONCAT(flag_name SEPARATOR ' and ') ELSE CONCAT(SUBSTRING_INDEX(GROUP_CONCAT(flag_name SEPARATOR ', '), ', ', COUNT(flag_name) - 1),' and ',SUBSTRING_INDEX(GROUP_CONCAT(flag_name SEPARATOR ', '), ', ', -1)) END AS flag_name")
                                        ->pluck('flag_name')
                                        ->toArray();
                                    */
                                     $removeflags = Flags::whereIn('flag_id', $flagval)
                                    ->selectRaw("
                                        CASE 
                                            WHEN COUNT(flag_name) = 1 
                                                THEN MAX(CONCAT('<b>', flag_name, '</b>')) 
                                            WHEN COUNT(flag_name) = 2 
                                                THEN GROUP_CONCAT(CONCAT('<b>', flag_name, '</b>') SEPARATOR ' and ') 
                                            ELSE CONCAT(
                                                SUBSTRING_INDEX(GROUP_CONCAT(CONCAT('<b>', flag_name, '</b>') SEPARATOR ', '), ', ', COUNT(flag_name) - 1),
                                                ' and ',
                                                SUBSTRING_INDEX(GROUP_CONCAT(CONCAT('<b>', flag_name, '</b>') SEPARATOR ', '), ', ', -1)
                                            ) 
                                        END AS flag_name
                                    ")
                                    ->pluck('flag_name')
                                    ->toArray();
                            
                                    if (!empty($removeflags)) { // Ensure flags were found
                                        $translatedMessage = trans('workflow.flagging_element', ['flag' => implode(', ', $removeflags)]); // Use implode for multiple flag names
                                        $return = array('status' => 'failed', 'msg' => $translatedMessage);
                                        return $this->warning('Warnings',200,$return,'warning');
                                    } else {
                                        // Handle the case where no flags were found for the given IDs
                                        return $this->warning(trans('workflow.flags_not_found'), 200, '', 'warning'); //Or whatever is appropriate.
                                    }
                                }
                            }
                            
                        }

                    }
                    $pre_formid=$formdata['workflowform_pre_form']??[];
                    $form_id = json_decode($stage_data['jwf_forms'], true);
                    $form_id = is_array($form_id) ? $form_id : [];
                    if (!empty($pre_formid)) {
                    if (!is_array($pre_formid)) {
                        $pre_formid = [$pre_formid];
                    }
                    $removed_forms = array_diff($pre_formid, $form_id);
                }
                              
                }else{
                    $stage_data["jwf_forms"] =  json_encode(array());
                }
            }
            else{
                $stage_data["jwf_forms"] =  json_encode(array()); 
            }
            /*
			  Process and assign posted values to array stage_data - IThenticate
			 */
            /* Check Ithenticate enable  */
            if (isset($formdata['enable_ithenticate']))
            {
                $stage_data["jwf_enable_ithenticate"] = ($formdata['enable_ithenticate'] == '1') ? 'y' : 'n';
            }

            /*
			  Process and assign posted values to array stage_data - Research integrity
			 */
            /* Task #925 Check Research integrity enabled  */
            if (isset($formdata['enable_research_integrity']))
            {
                $stage_data["jwf_enable_research_integrity"] = ($formdata['enable_research_integrity'] == '1') ? 'y' : 'n';
            }

            /*
			  Process and assign posted values to array stage_data - Article is editable (Related to author)
			 */
            if (isset($formdata['workflow_new_stage_art_editable']) && $formdata['workflow_new_stage_art_editable'] == 1)
            {
                $stage_data["jwf_article_editable"] = 1;
            }

            /*
			 * 1.6 Process and assign posted values to array stage_data - Turn around time (in days) to complete the stage
			 */
            if (isset($formdata['workflowform_tat_complete']))
            {
                $stage_data["jwf_tat_complete"] = $formdata['workflowform_tat_complete'];
            }

            /*
            * feature#626-Auto decline/unassign reviewer on passing due date
			 * 1.8 Process and assign posted values to array stage_data - Turn around time (in days) to Auto decline/unassign after due date
			 */
            if (isset($formdata['workflowform_tatautodecline']))
            {
                $stage_data["jwf_tat_decline"] = $formdata['workflowform_tatautodecline'];
            }

            /*
                         * feature#626-Auto decline/unassign reviewer on passing due date
			 Process and assign posted values to array stage_data - Enable Tat for auto -decline/unassign
			 */
          
                if (isset($formdata['flowformenableautodecline']))
                {
                $stage_data["jwf_enable_tat_for_auto_decline"] = ($formdata['flowformenableautodecline'] == '1') ? 'y' : 'n';
                }else{
                    $stage_data["jwf_enable_tat_for_auto_decline"] ='n';   
                }
                if (isset($formdata['workflow_editor_assessment']) && $formdata['workflow_editor_assessment'] == 'invitation')
                {
                     $stage_data["jwf_tat_accept"] = $formdata['workflowform_tat_accept'] ?? 0;
                }
                if(isset($formdata['workflow_editor_assessment']) && $formdata['workflow_editor_assessment'] == 'manual')
                {
                $stage_data["jwf_tat_accept"] = $formdata['workflowform_tat_accept'] ?? 0;
                }
            /*Enable article attachment */
                $stage_data['jwf_article_attachment_status'] = (isset($formdata['workflow_article_attachment_status']) && $formdata['workflow_article_attachment_status'] == "y") ? 'y' : 'n';

            /*
			  Process and assign posted values to array stage_data - Assignment type 
			 * (Self service, Invitation, Assignment)
			 */
            if (isset($formdata['workflow_editor_assessment'])) {
                $stage_data['jwf_assignment'] = $formdata['workflow_editor_assessment'];
            }
            /*
			  If the Assignment type is not present then default assignment type assigned
			 */ else //if(isset($review_flow[$stagetype]['default_assignment_type']))
                {
                    $stage_data['jwf_assignment'] = $default_assignment;
                    
                }

            /*
			 Process and assign posted values to array stage_data - 'Who can assign'
			 */
            $stage_data['jwf_parent_user_roles'] = json_encode(array());
            if (isset($shotlist_carried_out) && (!empty($shotlist_carried_out))) {
                if (is_array($shotlist_carried_out) === true) {
                    $parent_roles_shortlist = json_encode($shotlist_carried_out);
                } else {
                    $parent_roles_shortlist = $shotlist_carried_out;
                }
                $stage_data['jwf_parent_user_roles'] = $parent_roles_shortlist;
            }

            //Task #5244 save payment details
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {
                $check_author   =   $review_flow[$workflow_flow_stages]['roles'];
                if (in_array('author',$check_author)) {
                    $enable_payment =   isset($formdata['workflow_enable_payment']) ? $formdata['workflow_enable_payment']:'n';
                    $currency_id    =   isset($formdata['workflow_curr_id']) ? $formdata['workflow_curr_id']:null;
                    $amount         =   isset($formdata['workflow_payment_fees']) ? $formdata['workflow_payment_fees']:null;
                    $notes          =   isset($formdata['workflow_payment_notes']) ? $formdata['workflow_payment_notes']:null;
                    if ($enable_payment == 'y' && ($amount == null || $currency_id == null)) {
                        $msg            =   'Payment fees and currency are required';
                        return $this->failure('Warning',200,['msg'=>$msg],'warning');
                    }
                    $stage_data['jwf_enable_payment']    =   $enable_payment;
                    $stage_data['jwf_curr_id']           =   $currency_id;
                    $stage_data['jwf_payment_fees']      =   $amount;
                    $stage_data['jwf_payment_notes']     =   $notes;
                }
            }

            /*
			  Process and assign posted values to array stage_data - 'Who can invite'
			 */
            $stage_data['jwf_who_can_invite'] = json_encode(array());
            if (isset($invite_carried_out) && (!empty($invite_carried_out))) {
                if (is_array($invite_carried_out) === true) {
                    $invite_role_carried_out = json_encode($invite_carried_out);
                } else {
                    $invite_role_carried_out = $invite_carried_out;
                }
                $stage_data['jwf_who_can_invite'] = $invite_role_carried_out;
            }


            /*
             * Process and assign posted values to array stage_data - 'Avoid email notifications to roles'
             */
            $stage_data['jwf_avoid_email_notifications_to_roles'] = json_encode(array());
            if (isset($avoid_email_role_notification) && (!empty($avoid_email_role_notification))) {
                if (is_array($avoid_email_role_notification) === true) {
                    $avoid_email_role_based_notification = json_encode($avoid_email_role_notification);
                } else {
                    $avoid_email_role_based_notification = $avoid_email_role_notification;
                }
                $stage_data['jwf_avoid_email_notifications_to_roles'] = $avoid_email_role_based_notification;
            }


            /*
			 Process and assign posted values to array stage_data - Min and Max users in case the assignment type is
			 * Assignment or Invitation
			 */
            if (isset($formdata['workflowform_min_reviewers']) && (int)$formdata['workflowform_min_reviewers'] > 1)
            {
                $stage_data['jwf_no_of_min_users'] = $formdata['workflowform_min_reviewers'];
            }
            if (isset($formdata['workflowform_max_reviewers']) && (int)$formdata['workflowform_max_reviewers'] > 1)
            {
                $stage_data['jwf_no_of_max_users'] = $formdata['workflowform_max_reviewers'];
            }
            /*
          Process and assign posted values to array stage_data - Discussion forum is required or not.
         */
            if ($stagetype == 'review') {
                $stage_data['jwf_reviewers_discuss_forum'] = $formdata['workflow_discussion_forum'] ?? "";
            }

            /* Parent stage */
            if (isset($parent_stage_list) && (!empty($parent_stage_list))) {
                if (is_array($parent_stage_list) === true) {

                    $parent_stages = $parent_stage_list;
                } else {
                    $parent_stages = json_decode($parent_stage_list);
                }
            }
            $mng_parent_ids_arr = array();
            /*
          Check whther this is a New stage (to insert) or existing stage (update) by examining
         * posted values
         * If true New stage - start insert operation
         */
            if (empty($formdata['workflow_current_stage_id']) && $formdata['workflow_current_stage_id'] == '' && isset($stagetype) && $stagetype != '' && is_array($parent_stages) && count($parent_stages) > 0) //insert time
                {
                    if (!empty($parent_stages)) {
                        foreach ($parent_stages as $key => $parent_stage) {

                            $parent_stage_id = $parent_stage;
                            $parent_stages[$key] = $parent_stage_id;
                        }
                    }
                    $stage_data['jwf_parent_stages'] = json_encode($parent_stages);
                    $return_arr['msg'] = 'insert';
                    $return_status = Generic_flows::insert_record($stage_data, $this->current_user);
                    $stage_data['jwf_id'] = $return_status;
                    $mng_parent_ids_arr = $parent_stages;
                }
            /*
				  Update current stage details
				 * 
				 */ else {


                /*
				  Get decrypted current stage id from posted data
				 */
                $stage_id = $formdata['workflow_current_stage_id'];

                /*
				  Get the child stages of the current stage
				 */
                $condition = "jwf_id=" . $stage_id;
                $current_stage_childs = Generic_flows::get_single_record('jwf_child_stages,jwf_parent_stages,jwf_fwm_id,jwf_import_custom_form_err,jwf_import_user_role_err,jwf_role_id', $condition);

                $aflw_conditions = "aflw_jwf_id={$stage_id}  AND aflw_status IN ('u','i','a') AND art_delete_status='n'";
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $articles_table = (new \App\Models\Articles())->getTable();
                $selectflow = 'aflw_id';
                $tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                        $articles_table => array($Article_flow_table . '.aflw_art_id', $articles_table . '.art_id', "left")
                    )
                );
                $chk_current_active_stage = Article_flow::get_results_using_joins($tables, $selectflow, $aflw_conditions, 'all');
                if (count($chk_current_active_stage) > 0 && $current_stage_childs->jwf_role_id != $user_role)
                {
                    $return = array(
                        'status' => 'failed', 'msg' => customTrans('workflow.already_inprogress_stage')
                    );
                    return $this->warning('Warnings',200,$return,'warning');
                }
                
                $condition_stagename = "jwf_stage_name= ? AND jwf_fwm_id =? AND jwf_id != ?";
                 $condition_stagename_arr = [
                    $stage_name,
                    $flow_master_id,
                    $stage_id,
                ];
                $stage_name_check = Generic_flows::get_all_records('count(*) cnt', $condition_stagename, binding_arr : $condition_stagename_arr);
                if ($stage_name_check[0]->cnt > 0) {
                    $return = array(
                        'status' => 'failed', 'msg' => customTrans('workflow.check_stage_name')
                    );
                    return $this->warning('Warnings',200,$return,'warning');
                }
                  if (!empty($removed_forms ?? [])) {
                    
                    $remove_restrict_form=$this->restrict_delete_form($removed_forms,$stage_id,$jnlcode,'workflow');
                    if (!empty($remove_restrict_form)) {
                        $message=$remove_restrict_form['msg'];
                        return $this->warning(
                            'Warnings',
                            200,
                            ['status' => 'failed', 'msg' => $message],
                            'warning'
                        );
                        } 
                }

                /*
				 If parent stage is set
				 */
                $new_parents = array();
                if (isset($parent_stages) && (!empty($parent_stages))) {
                    /*
					 * Navigate through all parent stages
					 */
                   
                    foreach ($parent_stages as $key => $parent_stage) {
                        $parent_stage_id = $parent_stage;
                        $new_parents[] = $parent_stage_id;
                        $condition = 'jwf_id=' . $parent_stage_id;
                        $stage_details = Generic_flows::get_single_record('*', $condition);

                        $new_stage_details['parent_stages'][$key] = strval($parent_stage_id);
                    }

                    /*
					  Process and assign posted values to array stage_data - Parent stages
					 */
                    $stage_data['jwf_parent_stages'] = json_encode($new_stage_details['parent_stages']);
                }

                /*
				 *  Assign parents to $remove_parents
				 */

                $remove_parents = json_decode($current_stage_childs->jwf_parent_stages);
                /*
				  Call remove parent function for remove current stage from all old parent stages
				 */
                if (count($remove_parents) > 0) {
                $this->remove_parents($stage_id, $remove_parents, $current_stage_childs->jwf_fwm_id);
                }
                /*
				 Call add parent function for adding current stage to new parent stages
				 */
                $this->add_parents($stage_id, $new_parents, $current_stage_childs->jwf_fwm_id);

                //Task 664 ICE ReView new stages
                //check removed parents in new updation comparing with current stage and new stage parents
                if (count($remove_parents) > 0) {
                    $rm_pnt_arr = array();
                    foreach ($remove_parents as $cnt_pnt) {
                        if (!in_array($cnt_pnt, $new_parents))
                            $rm_pnt_arr[] = $cnt_pnt;
                    }

                    $this->manage_stage_advance_flow_connection($rm_pnt_arr, $stage_id);
                }

                /*
				 new parents exist then merge removed parents, new parents and avoid duplicate parents
				 */
                if (!empty($new_parents) && count($new_parents) > 0) {
                    //for avoid array_intersect in the case of update parents
                    //$mng_parent_ids_arr = array_intersect($remove_parents,$new_parents);
                    $mng_parent_ids_arr = array_unique(array_merge($remove_parents, $new_parents));
                }
                /*
				  Assign removed parents
				 */ else
                 {
                    $mng_parent_ids_arr = $remove_parents;
                 }

                /*
				 Update jwf_import_user_role_err / jwf_import_custom_form_err
				 */
                //Feature #1212	Export/Import Journal workflow as XML
             
                if ($current_stage_childs->jwf_import_user_role_err != '' && isset($new_stage_details['user_role'] )&&$new_stage_details['user_role'] != '') 
                    {
                         $stage_data['jwf_import_user_role_err'] = null;
                    }
                if ($current_stage_childs->jwf_import_custom_form_err != '' && isset($new_stage_details['forms']) && $new_stage_details['forms'] != '') {
                        $stage_data['jwf_import_custom_form_err'] = null;
                    }
                $condition = 'jwf_id=' . $stage_id;
                $logged_user_data = array(
                    'user_id' => $tokeninfo['user_id'],
                    'proxy_user_id' => 0
                );
                $return_status = Generic_flows::update_record($stage_data, $condition, $logged_user_data);
       

             
                //	if($import_user_role_bug == FALSE && $import_custom_form_bug == FALSE && $import_email_tmpl_bug == FALSE)
                $return_arr['import_bug'] = 'false';
                $stage_data['jwf_id'] = $stage_id;
                $return_arr['status'] = 'success';
                $return_arr['msg'] = 'update';
            }
             /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            if(isset($stage_data['jwf_id']) && !empty($stage_data['jwf_id']))
            {
                $workflow_assignment_type_selection = $this->workflow_assignment_type_seletion_status($stagetype);
                $source_assign_status = $workflow_assignment_type_selection['source_assign_status'];
                $destination_assign_status = $workflow_assignment_type_selection['destination_assign_status'];
                if($source_assign_status === true && isset($formdata['workflowform_source_assign']))
                {
                    $workflow_assignment_ids = $formdata['workflowform_source_assign'];
                    $result_data=$this->save_workflow_assignment_reference($stage_data['jwf_id'],$workflow_assignment_ids,$flow_master_id);
                }
                if($destination_assign_status === true && isset($formdata['workflowform_destination_assign']))
                {
                    $workflow_assignment_destination_id = $formdata['workflowform_destination_assign'];
                    $result= $this->update_workflow_assignment_reference_to_add_destination_stage($stage_data['jwf_id'],$workflow_assignment_destination_id,$flow_master_id);
                }
            }
             /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review end */
            /*
			 * 1.16 If insert/update was success
			 */
            if ($return_status !== false) {
                /*
				 * 1.16.1 Read the inserted/updates stage data
				 */
                $condition = 'jwf_id=' . $stage_data['jwf_id'];
                $current_stage_data = Generic_flows::get_single_record('jwf_id, jwf_stage_type, jwf_parent_stages, jwf_child_stages, jwf_xpos, jwf_ypos, jwf_stage_incomplete,jwf_import_custom_form_err,jwf_import_user_role_err ', $condition);
               
                $stage_parent = $this->handle_stage($current_stage_data->jwf_parent_stages);
                $return_arr['stage_parent'] = $stage_parent;
                $stage_data['jwf_stage_type'] = $current_stage_data->jwf_stage_type;
                $stage_data['jwf_parent_stages'] = json_encode($current_stage_data->jwf_parent_stages);
                $stage_data['jwf_child_stages'] = $current_stage_data->jwf_child_stages;
                $stage_data['jwf_import_custom_form_err'] = $current_stage_data->jwf_import_custom_form_err;
                $stage_data['jwf_import_user_role_err'] = $current_stage_data->jwf_import_user_role_err;
                $stage_data['jwf_xpos'] = $current_stage_data->jwf_xpos;
                $stage_data['jwf_ypos'] = $current_stage_data->jwf_ypos;
                $stage_data['jwf_stage_incomplete'] = $current_stage_data->jwf_stage_incomplete;
                $stage_data['jwf_fwm_id'] =$flow_master_id;
                /* get parents of current stage and decide add child icon required or not -- start*/
                $stg_parents = json_decode($current_stage_data->jwf_parent_stages);
                $has_mul_child = array();
                $has_bind_data = array();
                for ($i = 0; $i < count($stg_parents); $i++) {
                    $criteria = 'jwf_id=' . $stg_parents[$i];
                    $stg_type = Generic_flows::get_single_record('jwf_stage_type', $criteria);
                    $has_mul_child[$this->encrypt_data($stg_parents[$i])] = isset($review_flow[$stg_type->jwf_stage_type]['multiple_child']) ? $review_flow[$stg_type->jwf_stage_type]['multiple_child'] : TRUE;
                    $criteria = 'jwf_id=' . $stg_parents[$i];
                    $stage_datas = Generic_flows::get_single_record('jwf_id, jwf_stage_type, jwf_parent_stages, jwf_child_stages, jwf_xpos, jwf_ypos, jwf_stage_incomplete,jwf_import_custom_form_err,jwf_import_user_role_err ', $criteria);
                    
                }

                /* --- end */
                /*
				 * 1.16.2 Set the stage count if the stage type is 'author_submission'
				 */
                if ($stage_data['jwf_stage_type'] == 'author_submission') {
                    $stage_data['stagecnt'] = 0;
                } else {
                    $stage_data['stagecnt'] = 1;
                }

                $ypos = 0;
                /*
				 Update parent stages and return the max y position.
				 */
                if (isset($parent_stages)) {
                    $ypos = $this->update_parents($parent_stages, $stage_data);
                }

                /*
				 If Find the un utilised xpos
				 */
                if ($return_arr['msg'] == 'insert') {
    
                    $this->update_position($stage_data, $ypos);
                }
                /*
				  Check whether flow has an exit point. Else return error message
				 */ elseif ($return_arr['msg'] == 'update' && ($this->validate_flow($stage_data['jwf_fwm_id']) === false && $this->current_client->modules->mdl_review_for_doc == 'n')) {
                    $return_arr['status'] = 'failed';
                    $return_arr['msg'] = customTrans('workflow.cyclic_stage');
                }
                /*
				 Set return values
				 */
                $return_arr['stage_id'] = $this->encrypt_data($current_stage_data->jwf_id);
                $stage_data["action"] = $return_arr['msg'];
                $child_stages = json_decode($stage_data['jwf_child_stages']);
                for ($i = 0; $i < count($child_stages); $i++)
                    $child_stages[$i] = $this->encrypt_data($child_stages[$i]);
                $return_arr['children'] = $child_stages;
                /*
				  Fetch stage roles from workflow library
				 */
                $allow_roles = $review_flow[$stage_data['jwf_stage_type']]['roles'];
                $non_allow_roles_array = $this->RolesConfigdata('non_privileged_user_roles');
                $non_allow_roles=$non_allow_roles_array['non_privileged_user_roles']; 
       

                $stage_data['can_disable_stage'] = false;
                if (isset($review_flow[$stage_data['jwf_stage_type']]['disable_criteria'])) {
                    $disable_criteria = $review_flow[$stage_data['jwf_stage_type']]['disable_criteria'];
                }

                /*
				  check parent stage parallel
				 */
                $stage_data['disable_add_stage'] = false;
                //to avoid add child icon showing on edit
                if (count($stg_parents) > 0) {
                    if ((isset($this->current_client->functionality->cfty_enable_multiple_child_below_parallel_stage) && ($this->current_client->functionality->cfty_enable_multiple_child_below_parallel_stage == 'n')) || !isset($this->current_client->functionality->cfty_enable_multiple_child_below_parallel_stage)) {
                        //$select_cond = '(select count(*) from '.Generic_flow::$tbl_name.' where (((LENGTH(jwf_child_stages) -LENGTH(REPLACE(jwf_child_stages,\'"\',\'\')))> 2 AND jwf_flow_proceed_type =\'parallel\') OR jwf_stage_incomplete=\'y\') and jwf_id IN ('. implode(',', $stg_parents) .')) as current_stage_in_parallel';
                        //	$parallel_stg = $this->Generic_flows->get_single_record($select_cond,array(
                        ////		'jwf_id' => $stage_data['jwf_id']
                        //	));
                        //	if($parallel_stg->current_stage_in_parallel > 0 && count($child_stages) >= 1)
                        //	$stage_data['disable_add_stage'] = TRUE;
                    }
                }
                if (isset($review_flow[$stage_data['jwf_stage_type']]['multiple_child']) && $review_flow[$stage_data['jwf_stage_type']]['multiple_child'] === true && count(json_decode($stage_data['jwf_child_stages'])) >= 1) {
                    $stage_data['allow_multiple_child'] = true;
                } else {
                    $stage_data['allow_multiple_child'] = true;
                }
                $stage_email_template_validate = true;
                $updted_stage_type = '';
                if (isset($stagetype)) {
                    $updted_stage_type = $stagetype;
                } else {
                    $updted_stage_type = $stagetype;
                }
                if (isset($review_flow[$updted_stage_type]['generic_form']) && $review_flow[$updted_stage_type]['generic_form'] == 0 && $this->current_client->modules->mdl_review_for_doc == 'y') {
                    $stage_email_template_validate = false;
                }
                $return_arr['stage_email_template_validate'] = $stage_email_template_validate;
                $return_arr['review_for_document'] = $this->current_client->modules->mdl_review_for_doc;
                $return_arr['parent_mul_child'] = $has_mul_child;
                $return_arr['has_bind_data'] = $has_bind_data;

                //Task 664 ICE ReView new stages
                $stage_data['is_add_next_stage'] = true;
                if ((isset($review_flow[$stagetype]['milestone_stage']) && $review_flow[$stagetype]['milestone_stage'] === true) || ($stagetype == 'production' && $this->current_client->modules->mdl_production == 'n')) {
                    $stage_data['is_add_next_stage'] = false;
                }
               // DB::commit();
            }
            return $this->success("Success",201,$return_arr);
         
        } catch (\Exception $e) {
            //DB:rollback();
            
            return  $this->failure('Failed',500,$e);
        }
            
            
        
        
    }
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    public function get_workflow_assignment_type_for_source_stage()
    {
        try {
        $workflow_Assignment_type = (new \App\Models\Workflow_Assignment_type);
        $workflow_assignment_types = $workflow_Assignment_type::get_all_records_with_bind_cond('wa_id,wa_name');
        $data_workflow_assignments = array();
        if (!empty($workflow_assignment_types)) {
            foreach ($workflow_assignment_types as $workflow_assignments) {
                $data_workflow_assignments[$workflow_assignments->wa_id] = $workflow_assignments->wa_name;
            }
        return $data_workflow_assignments;
        }
        } catch (\Exception $e) {
            //DB:rollback();
            //print_r($e);exit;
            return  $this->failure('Failed',500,$e);
        }
    }
    public function get_workflow_assignment_type_for_destination_stage($flow_master_id = null)
    {
        try {
        $data_workflow_assignments=array();
        $workflow_assignment_reference_table = (new \App\Models\Workflow_Assignment_reference())->getTable();
        $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
        $workflow_assignment_table = (new \App\Models\Workflow_Assignment_type())->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $criteria = 'war_flow_master_id=:flow_master_id';
        $binding_arr = array(
            'flow_master_id'=>$flow_master_id
        );
        $select = 'distinct wa_id,wa_name,war_id';
        $tables = array(
            'main_table' => $workflow_assignment_reference_table,
            'join_table' => array(
                $workflow_assignment_table => array($workflow_assignment_table . '.wa_id', $workflow_assignment_reference_table . '.war_wa_id','join'),
                $generic_flow_table => array($workflow_assignment_reference_table . '.war_flow_master_id', $generic_flow_table . '.jwf_fwm_id','join')
            )
            
        );
        $assignment_details = $workflow_assignment_reference::get_results_using_joins($tables, $select, $criteria,'all',  null,  null,'',  null, null,  false, false, false,$binding_arr);
        if (!empty($assignment_details)) {
            foreach ($assignment_details as $workflow_assignments) {
                $data_workflow_assignments[$workflow_assignments->war_id] = $workflow_assignments->wa_name;
            }
        }
        return $data_workflow_assignments;
        } catch (\Exception $e) {
            //DB:rollback();
            return  $this->failure('Failed',500,$e);
        }
        
    
    }
    public function update_workflow_assignment_reference_to_add_destination_stage($current_stage = null,$workflow_assignment_destination_id = null,$flow_master_id = null)
    {
        try {
        $result = false;
        $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
        $criteria = 'JSON_SEARCH(war_destination_review_stage_id,\'all\','.$current_stage.') is NOT NULL AND war_flow_master_id =:flow_master_id';
        $binding_arr = array(
            'flow_master_id'=>$flow_master_id
        );
        if(!empty($workflow_assignment_destination_id))
        {
            $workflow_assignment_destination_ids = implode(',',$workflow_assignment_destination_id);
            $criteria .= '  AND war_id NOT IN ('.$workflow_assignment_destination_ids.')';
        }
        $existning_destination_stage_ids = $workflow_assignment_reference::get_all_records('war_id,war_destination_review_stage_id', $criteria, null,  null,  '',null, null,'ASC',$binding_arr);
        if(!empty($existning_destination_stage_ids) && count($existning_destination_stage_ids)>0)
        {
            foreach($existning_destination_stage_ids as $not_selected)
            {
                    $decode_data=json_decode($not_selected->war_destination_review_stage_id);
                    $key = array_search($current_stage, $decode_data);
                    if(count((array)$decode_data) == 1)
                        {
                           $destination_assignment_id_update = null;
                        }
                    else{
                        if (($key) !== false)
                            {
                                #deleting the key found
                                unset($decode_data[$key]);
                            }
                            $decode_data = array_values($decode_data);
                        $destination_assignment_id_update = json_encode($decode_data);
                    }
                    $criteria = array('war_id'=>$not_selected->war_id);
                    $result = $workflow_assignment_reference::update_record(array(
                        'war_destination_review_stage_id' => $destination_assignment_id_update
                    ), $criteria, $this->current_user);
            }
        }
        foreach ($workflow_assignment_destination_id as $new_workflow_assignment_ids) {
            $condition = 'war_id =:new_workflow_assignment_ids AND war_flow_master_id =:flow_master_id';
            $bind_arr = array(
                'new_workflow_assignment_ids' =>$new_workflow_assignment_ids,
                'flow_master_id' => $flow_master_id
            );
            $old_assignments = $workflow_assignment_reference::get_all_records('war_id,war_destination_review_stage_id', $condition, null,  null,  '',null, null,'ASC',$bind_arr);
            if(!empty($old_assignments) && count($old_assignments)>0)
            {
                    if($old_assignments[0]->war_destination_review_stage_id != null)
                    {
                    $tempArray = json_decode($old_assignments[0]->war_destination_review_stage_id);
                    $update_status = false;
                    if(!in_array($current_stage,$tempArray))
                    {
                        array_push($tempArray, (string)$current_stage);
                        $destination_assignment_id = json_encode($tempArray);
                        $update_status = true;
                    }
                    }
                    else{
                        $destination_assignment_id = json_encode(explode(',', $current_stage));
                        $update_status = true;
                    }
                    if($update_status === true)
                    {
                        $criteria = array('war_id'=>$old_assignments[0]->war_id);
                        $result = $workflow_assignment_reference::update_record(array(
                            'war_destination_review_stage_id' => $destination_assignment_id
                        ), $criteria, $this->current_user);
                    }
            }
        }
        
        return $result;
        } catch (\Exception $e) {
            //DB:rollback();
            // print_r($e);die;
            return  $this->failure('Failed',500,$e);
        }
    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    public function get_selected_workflow_assignment_type_for_source_or_destination_stage($workflow_id = null,$source_stage = true)
    {
        try {
        $workflow_assignment_reference_table = (new \App\Models\Workflow_Assignment_reference())->getTable();
        $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
        $workflow_assignment_table = (new \App\Models\Workflow_Assignment_type())->getTable();
        if(isset($source_stage) && $source_stage === true)
        {
            $criteria = ' JSON_SEARCH(war_jwf_id,\'all\',:workflow_id) is NOT NULL ';
            $select = 'GROUP_CONCAT(war_wa_id) AS war_wa_id';
        }
        elseif(isset($source_stage) && $source_stage === false)
        {
            $criteria = ' JSON_SEARCH(war_destination_review_stage_id,\'all\',:workflow_id) is NOT NULL ';
            $select = 'GROUP_CONCAT(war_id) AS war_id';
        }
        $binding_arr = array(
           'workflow_id' => $workflow_id
        );
        $tables = array(
            'main_table' => $workflow_assignment_reference_table,
            'join_table' => array(
                $workflow_assignment_table => array($workflow_assignment_table . '.wa_id', $workflow_assignment_reference_table . '.war_wa_id','join')
            )
            
        );
        $assignment_details = $workflow_assignment_reference::get_results_using_joins($tables, $select, $criteria,'all',  null,  null,'',  null, null,  false, null, false,$binding_arr);
        return $assignment_details;
        }
                                                   
        catch (\Exception $e) {
            //DB:rollback();
            return  $this->failure('Failed', 500, $e);
        }
            
    }
    /* save workflow assignment type reference for source stage */
    public function save_workflow_assignment_reference($jwf_id = NULL,$workflow_assignment_ids = array(),$flow_master_id = NULL)
    {
        try {
            $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
        if (!empty($workflow_assignment_ids)) {
            $selcted_workflow_assignments = implode(',',$workflow_assignment_ids);
            $condition = 'war_wa_id NOT IN ('.$selcted_workflow_assignments. ') AND JSON_SEARCH(war_jwf_id,\'all\','.$jwf_id.') is NOT NULL';
            $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
            //removing the reference if a pool that was previously selected is not chosen in the current update
            $not_selected_workflow_assignments = $workflow_assignment_reference::get_all_records('war_id,war_wa_id,war_jwf_id', $condition);
            if(!empty($not_selected_workflow_assignments) && count($not_selected_workflow_assignments)>0)
                {
                    foreach($not_selected_workflow_assignments as $not_selected)
                    {
                        $decode_data=json_decode($not_selected->war_jwf_id);
                        if(count((array)$decode_data) == 1)
                        {
                            $criteria = array('war_id'=>$not_selected->war_id);
                            $result = $workflow_assignment_reference::delete_records($criteria, '',$this->current_user);
                        }
                        else{
                            $key = array_search($jwf_id, $decode_data);
                            if (($key) !== false)
                            {
                                #deleting the key found
                                unset($decode_data[$key]);
                            }
                            $decode_data = array_values($decode_data);
                            $source_assignment_id_update = json_encode($decode_data);
                            $criteria = array('war_id'=>$not_selected->war_id);
                            $result = $workflow_assignment_reference::update_record(array(
                                'war_jwf_id' => $source_assignment_id_update
                            ), $criteria, $this->current_user);
                        }
                    }
                }
            foreach ($workflow_assignment_ids as $new_workflow_assignment_ids) {
                $condition = 'war_wa_id ='.$new_workflow_assignment_ids.'  AND war_flow_master_id ='.$flow_master_id;
                $old_assignments = $workflow_assignment_reference::get_all_records('war_id,war_wa_id,war_jwf_id,war_destination_review_stage_id', $condition);
                if(!empty($old_assignments) && count($old_assignments)>0)
                {
                    $tempArray = json_decode($old_assignments[0]->war_jwf_id);
                    $update_status = false;
                    if(!in_array($jwf_id,$tempArray))
                    {
                        array_push($tempArray, (string)$jwf_id);
                        $source_assignment_id = json_encode($tempArray);
                        $update_status = true;
                    }
                    if($update_status === true)
                    {
                        $criteria = array('war_id'=>$old_assignments[0]->war_id);
                        $result = $workflow_assignment_reference::update_record(array(
                            'war_jwf_id' => $source_assignment_id
                        ), $criteria, $this->current_user);
                    }
                }
                else
                {
                    $source_stage_id = json_encode(explode(',', $jwf_id));
                    $workflow_assignment_data = array(
                        'war_Jwf_id'=>$source_stage_id,
                        'war_flow_master_id' => $flow_master_id,
                        'war_wa_id' => $new_workflow_assignment_ids
                    );
                    $workflow_assignment_reference::insert_record($workflow_assignment_data, $this->current_user);
                
                }
            }
        }
        else{
            $criteria = ' JSON_SEARCH(war_jwf_id,\'all\','.$jwf_id.') is NOT NULL ';
            $old_assignments = $workflow_assignment_reference::get_all_records('war_id,war_wa_id,war_jwf_id,war_destination_review_stage_id', $criteria);
                if(!empty($old_assignments) && count($old_assignments)>0)
                {
                    foreach($old_assignments as $each_assignment)
                    {
                        $decode_data=json_decode($each_assignment->war_jwf_id);
                        if(count((array)$decode_data) == 1)
                        {
                            $criteria = array('war_id'=>$each_assignment->war_id);
                            $result = $workflow_assignment_reference::delete_records($criteria, '',$this->current_user);
                        }
                        else{
                            $key = array_search($jwf_id, $decode_data);
                            if (($key) !== false)
                            {
                                #deleting the key found
                                unset($decode_data[$key]);
                            }
                            $decode_data = array_values($decode_data);
                            $source_assignment_id_update = json_encode($decode_data);
                            $criteria = array('war_id'=>$each_assignment->war_id);
                            $result = $workflow_assignment_reference::update_record(array(
                                'war_jwf_id' => $source_assignment_id_update
                            ), $criteria, $this->current_user);
                        }
                    }
                }
        }
    } catch (\Exception $e) {
        //DB:rollback();
        return  $this->failure('Failed', 500, $e);
    }
    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
    /*
    Get node details
    commited date :-  13-03-2022
    Request type :- GET
*/
    public function render_ftp_data($jnl_id, $stage_data, $file_description_type = 'r', $article_type_id = NULL)
    {
        try {
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$chart_data  = Config::get($workflow_config);
            $stage_for = $chart_data[$stage_data->jwf_stage_type]['stage_for'];
            $rtn_data = array();
            $jwf_id = $stage_data->jwf_id;
            $allowed_jwf_afdec_ids = json_decode($stage_data->jwf_afdec_ids);
            $select = 'ftp_id,ftp_jnl_id,ftp_afdec_ids,ftp_event_type,ftp_is_default,ftpm_display_name,ftpm_host_name,ftpm_user_name,ftpm_password,ftpm_enable_private_key,ftpm_private_key_path,ftpm_port,ftpm_location,ftp_action_for,ftp_metadata_on_export,ftp_import_stage_name';
            $where = "ftp_jnl_id ={$jnl_id} AND ftp_jwf_id={$jwf_id}";
            $ftp_data = $this->get_ftp_data($select, $where);
            $Attachment_file_description_tbl = (new \App\Models\Attachment_file_description())->getTable();
            $Required_file_type_tbl = (new \App\Models\Required_file_type())->getTable();
            $join_tables = array(
                'main_table' => $Attachment_file_description_tbl,
                'join_table' => array(
                    $Required_file_type_tbl => array($Attachment_file_description_tbl . '.afdec_id', $Required_file_type_tbl . '.rft_file_desp_id')
                )
            );
            $select = "afdec_id,afdec_description";
            if ($article_type_id != NULL) {
                $criteria =  " FIND_IN_SET('$file_description_type',afdec_apply_stage_type) AND rft_jnl_id={$jnl_id} AND rft_artp_id={$article_type_id}";
            } else {
                $criteria =  " FIND_IN_SET('$file_description_type',afdec_apply_stage_type) AND rft_jnl_id={$jnl_id} AND rft_artp_id IS NULL";
            }
/*             if(!empty($allowed_jwf_afdec_ids)){
                $criteria .= " AND afdec_id IN (" . implode(",", $allowed_jwf_afdec_ids) . ")";
            } */
            $file_description = Attachment_file_description::get_results_using_joins($join_tables, $select, $criteria, "all");
            $ftp_config_status = $this->Utility('ftp_config_status')['ftp_config_status'];
            $ftp_event_status = $this->Utility('ftp_event_status')['ftp_event_status'];
            $flag_status = $this->Utility('flag_status')['flag_status'];
            if(empty($ftp_data))
            {
                $rtn_data = array(
                    'enable' => FALSE,
                    'stage_for' => $stage_for,
                    'ftp_config_status' => $ftp_config_status,
                    'ftp_event_status' => $ftp_event_status,
                    // 'selected_event' => '',
                    'ftp_data'=> NULL,
                    'file_descritions'=> $file_description,
                    );
            }else{
                $default = false;
                foreach ($ftp_data as $row) 
                {
                    if($row->ftp_is_default == 'y')
                    {
                        $default = true;
                    }
                    $row->file_descriptions = null;
                    if(!empty($row->ftp_afdec_ids)){
                        $row->file_descriptions = Attachment_file_description::get_all_records('afdec_description', 'afdec_id IN ( '.$row->ftp_afdec_ids.' ) ');    
                    }
                    if (!empty($row->ftp_action_for))
                    {
                        $row->ftp_action_for_original = $row->ftp_action_for;
                        $row->ftp_action_for = $ftp_config_status[$row->ftp_action_for];
                    }
                    if (!empty($row->ftp_metadata_on_export)){
                        $row->ftp_metadata_on_export = $flag_status[$row->ftp_metadata_on_export];
                    }
                }
                $rtn_data = array(
                    'enable' => $default,
                    'stage_for' => $stage_for,
                    'ftp_config_status' => $ftp_config_status,
                    'ftp_event_status' => $ftp_event_status,
                    // 'selected_event' => $ftp_data[0]->ftp_event_type,
                    'ftp_data'=> $ftp_data,
                    'file_descritions'=> $file_description,
                );
            } 
            return $rtn_data;
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_stage_details(Request $request)
    {
        try {

            $current_stage = $request->all();
            $platform_id=$current_stage['platform_id'];
            $role_table = (new \App\Models\Roles())->getTable();
            $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
            $jwf_id = $this->decrypt_data($current_stage['node_id']);
            $jnl_data_set=true;
            /*get stage id based data get in workflow table */
            $criteria = 'jwf_id=' . $jwf_id;
            $select = '*';
            $tables = array(
                'main_table' => $generic_flow_table,
                'join_table' => array(
                    $role_table => array($generic_flow_table . '.jwf_role_id', $role_table . '.role_id', "left")
                )
            );

            $stage_details = Generic_flows::get_results_using_joins($tables, $select, $criteria, 'single');
            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
            $chart_data = Config::get($workflow_config);

            if (isset($this->current_client->functionality->cfty_import_stage_data_from_ftp_location)) {
                $return_array['cfty_import_stage_data_from_ftp_location'] = $this->current_client->functionality->cfty_import_stage_data_from_ftp_location;
            }
            $return_array['cfty_auto_decline_only'] ='n';
            if (isset($this->current_client->functionality->cfty_auto_decline_only)) {
                $return_array['cfty_auto_decline_only'] = $this->current_client->functionality->cfty_auto_decline_only;
            }
            $parent_id = $stage_details->jwf_id;
            $return_array['import_errs'] = '';
            $temp_from_err = $temp_usr_role_err = array();
            if ($stage_details->jwf_import_custom_form_err != '') {
                $temp_from_err = json_decode($stage_details->jwf_import_custom_form_err);
            }
            if ($stage_details->jwf_import_user_role_err != '') {
                $temp_usr_role_err = json_decode($stage_details->jwf_import_user_role_err,true);
            }
            $temp_import_bug = array_merge($temp_from_err, $temp_usr_role_err);
            if (count($temp_import_bug) > 0) {
                $return_array['import_errs'] = implode('<br>', array_unique($temp_import_bug));
            }
            $return_array['parent_name'] = $stage_details->jwf_stage_name;
            $return_array['parent_id'] = $parent_id;
            $return_array['tat_complete'] = $stage_details->jwf_tat_complete;
            //feature#626-Auto decline/unassign reviewer on passing due date
            $return_array['tat_decline'] = $stage_details->jwf_tat_decline;
            $return_array['enable_tat_for_auto_decline'] = $stage_details->jwf_enable_tat_for_auto_decline;
            $return_array['tat_accept'] = $stage_details->jwf_tat_accept;

            $return_array['confirm_credits'] = $stage_details->jwf_confirm_casrai_credits; // /*Feature #1050*/
            $return_array['confirm_orcid'] = $stage_details->jwf_confirm_orcid;
            $return_array['show_casrai_credits'] = (isset($chart_data[$stage_details->jwf_stage_type]['enable_casrai_credits_confirm'])) ?  $chart_data[$stage_details->jwf_stage_type]['enable_casrai_credits_confirm'] : 'n';
            $return_array['show_orcid_confirm'] = (isset($chart_data[$stage_details->jwf_stage_type]['enable_orcid_confirm'])) ? $chart_data[$stage_details->jwf_stage_type]['enable_orcid_confirm'] : 'n';

            $return_array['show_prevent_edit_check'] = ((isset($chart_data[$stage_details->jwf_stage_type]['prevent_edit'])) && $chart_data[$stage_details->jwf_stage_type]['prevent_edit'] == true)?'y':'n';
            //Task #5244 enable payment in abstract submssion, set payment in work flow
            $return_array['currency_details']   =   [];
            if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {
                $chck_author = $chart_data[$stage_details->jwf_stage_type]['roles'];
                if (in_array('author',$chck_author)) {
                    $currency_master	=	new \App\Models\Currency_master();

                    $currency_details   =   $currency_master::get_all_records('*');
                    $stage_details->curr_symbol = null;
                    if (isset($stage_details->jwf_curr_id)) {
                        $stage_details->curr_symbol = $currency_master::get_single_record('curr_symbol','curr_id = '.$stage_details->jwf_curr_id)->curr_symbol;
                        $stage_details->curr_code = $currency_master::get_single_record('curr_code','curr_id = '.$stage_details->jwf_curr_id)->curr_code;
                        
                        $clnt_config = 'clients.' . $this->current_client->clnt_client_code . '.client_default';
                        $fetch_confArr  = Config::get($clnt_config);
                        $fee_formArr     =   array();
                        if(isset($fetch_confArr['fee_format']) && $fetch_confArr['fee_format'] != '') {
                            $fee_formArr    =   explode("_", $fetch_confArr['fee_format']);
                        }
                        
                        //for formatting the fee in a unique style
                        $stage_details->formatted_fee   =   '';
                        $formatted_fee  =   '';
                        foreach($fee_formArr as $indx => $fmt) {
                            switch ($fmt) {
                                case "SYMBOL":
                                    $formatted_fee  .=   $stage_details->curr_symbol . '';
                                break;
                                case "AMOUNT":
                                    $formatted_fee  .=   number_format((float)$stage_details->jwf_payment_fees, 2, '.', '') . '';
                                break;
                                case "SPACE":
                                    $formatted_fee  .=   ' ';
                                break;
                                case "CODE":
                                    $formatted_fee  .=   $stage_details->curr_code . '';
                                break;
                                default:
                                    $formatted_fee  .=   '';
                            }
                        }
                        $stage_details->formatted_fee   =   $formatted_fee;
                    }
                    $return_array['currency_details']['enable_payment'] = $stage_details->jwf_enable_payment;
                    $return_array['currency_details']['paymnent_fees']  =  $stage_details->jwf_payment_fees;
                    $return_array['currency_details']['currencies']    =   $currency_details;
                    $return_array['currency_details']['payment_notes']    =   $stage_details->jwf_payment_notes;
                }
            }
            $arttypid = '';
            if (isset($current_stage['arttypid']) && $current_stage['arttypid'] != "")
			{
				$arttypid = $this->decrypt_data($current_stage['arttypid']);
                $con_arttype="atotp_artp_id ='{$arttypid}'";
				$return_array['classifications'] = Article_type_advance_options::get_single_record('*', $con_arttype);
			}
                        $return_array['show_custom_ftp_export'] = false;
                        if(isset($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage) && ($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage == 'y'))
                        {
                            $file_description_type = 'r';
                            if(isset($chart_data[$stage_details->jwf_stage_type]['stage_for']) && $chart_data[$stage_details->jwf_stage_type]['stage_for'] == 'manageproduction')
                            {
                                $file_description_type = 'p';
                            }
                                $return_array['show_custom_ftp_export'] = true;
                                //to do
                                $jnl_id = $platform_id;
                                 $return_array['ftp_config_data']       = $this->render_ftp_data($jnl_id,$stage_details,$file_description_type,$arttypid);
                        }
                       
			if (isset($current_stage['jnlid']) && $current_stage['jnlid'] != "")
			{
                $jnid = $this->decrypt_link($current_stage['jnlid']);
                $con_jnl="jset_jnl_id='{$jnid}'";
				$return_array['classifications'] =Journal_settings::get_single_record('*',$con_jnl);
            }
            //to do
			// if (isset($chart_data[$stage_details[0]->jwf_stage_type]['assignment_options']) && $chart_data[$stage_details[0]->jwf_stage_type]['assignment_options'] == true && $stage_details[0]->jwf_assignment != '' && $stage_details[0]->jwf_assignment != 'self_service')
			// {
			// 	$user_roles = $this->get_user_roles(array(
			// 		'staff',
			// 		'associate_editor',
			// 		'production_manager',
			// 		'editor_in_chief',
			// 		'tsp'), $stage_details[0]->jwf_role_id);
			// 	$return_array['parent_user_roles'] = $user_roles;
			// }
			
            $chart_key = $stage_details->jwf_stage_type;
            $jnl_id = $platform_id;
            if (!empty($current_stage['operation_type']) && ($current_stage['operation_type'] == 'info' || $current_stage['operation_type'] == 'edit')) //for details show in info/edit area
                {


                    $stage_details->generic_form = 1;
                    //echo '<pre>';print_r($chart_data[$chart_key]);exit;
                    if (isset($chart_data[$chart_key]['generic_form'])) {
                        $stage_details->generic_form = $chart_data[$chart_key]['generic_form'];
                    }

                    $stage_details->ithenticate = false;
                    if (isset($chart_data[$chart_key]['enable_ithenticate'])) {
                        $stage_details->ithenticate = $chart_data[$chart_key]['enable_ithenticate'];
                    }

                    if(isset($jnl_id) && !empty($jnl_id))
                    {
                        $con_jnl1="jset_jnl_id='{$jnl_id}'";
                        $journals =Journal_settings::get_single_record('jset_plagiarism_checking',$con_jnl1);  
                        if(!empty($journals))
                        {
                            if(isset($journals->jset_plagiarism_checking) && $journals->jset_plagiarism_checking=='n')
                            {
                                $stage_details->ithenticate = false;
                            }
                        }
                    }
                    if (isset($current_stage['arttypid']) && $current_stage['arttypid'] != "")
                    {
                        $arttypid = $this->decrypt_data($current_stage['arttypid']);
                        $con_arttype="atotp_artp_id ='{$arttypid}'";
                        $ithenti_data = Article_type_advance_options::get_single_record('atotp_plagiarism_checking,atotp_ithsubmission_type', $con_arttype);
                        if(!empty($ithenti_data))
                        {
                            if($ithenti_data->atotp_plagiarism_checking=='n')
                            {
                                $stage_details->ithenticate = false;
                            }
                            if($ithenti_data->atotp_ithsubmission_type=='auto')
                            {
                                $stage_details->ithenticate = true;
                            }
                        }
                    }
                    
                    // Task #925 research_integrity_checking
                    $stage_details->research_integrity = false;
                    if (isset($chart_data[$chart_key]['enable_research_integrity'])) {
                        $stage_details->research_integrity = $chart_data[$chart_key]['enable_research_integrity'];
                    }
                    if(isset($jnl_id) && !empty($jnl_id))
                    {
                        $con_jnl1="jset_jnl_id='{$jnl_id}'";
                        $journals =Journal_settings::get_single_record('jset_research_integrity',$con_jnl1);  
                        if(!empty($journals))
                        {
                            if(isset($journals->jset_research_integrity) && $journals->jset_research_integrity=='n')
                            {
                                $stage_details->research_integrity = false;
                            }
                        }
                    }
                    // Task #925 atotp_research_integrity
                    if (isset($current_stage['arttypid']) && $current_stage['arttypid'] != "")
                    {
                        $arttypid = $this->decrypt_data($current_stage['arttypid']);
                        $con_arttype="atotp_artp_id ='{$arttypid}'";
                        $rvri_data = Article_type_advance_options::get_single_record('atotp_research_integrity,atotp_rvrisubmission_type', $con_arttype);
                        if(!empty($rvri_data))
                        {
                            if($rvri_data->atotp_research_integrity=='n')
                            {
                                $stage_details->research_integrity = false;
                            }
                            if($rvri_data->atotp_rvrisubmission_type=='auto')
                            {
                                $stage_details->research_integrity = true;
                            }
                        }
                    }

                    $parent_stage_array = array();
                    $parent_stages = json_decode($stage_details->jwf_parent_stages);
                    if (!empty($parent_stages)) {
                            foreach ($parent_stages as $ps => $val) {
                                $criteria = 'jwf_hide_status="n" AND jwf_id=' . $val;
                                $rec = Generic_flows::get_single_record('*', $criteria);
                                if (!empty($rec)) {
                                    array_push($parent_stage_array, $val);
                                }
                            }
                        }
                        
                    $extended_roles = array('staff', 'associate_editor', 'editor_in_chief', 'production_manager', 'tsp','type_setter');
                    $exclude_role = $stage_details->role_id;

                    $rolelist = "'" . implode("','", $extended_roles) . "'";
                    if(!empty($exclude_role))
                    {
                    $criteria = 'role_assigned_role IN(' . $rolelist . ') AND role_id <>' . $exclude_role;
                    }else{
                        $criteria = 'role_assigned_role IN(' . $rolelist . ') ';
                    }
                    $extended_user_roles = Roles::get_all_records('role_id,role_name', $criteria);

                    $data_user_roles = array();
                    if (!empty($extended_user_roles)) {
                        foreach ($extended_user_roles as $user_roles) {
                            $data_user_roles[$user_roles->role_id] = $user_roles->role_name;
                        }
                    }
                    $stage_details->data_roles=$data_user_roles;

                    $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                    $review_flow = Config::get($workflow_config);
                    $review_flow_all_keys = array_keys($review_flow);
                    $review_flow_key =$review_flow_all_keys [array_search($stage_details->jwf_stage_type,  $review_flow_all_keys)];
                    $return_array['stage_type'] = $review_flow[$review_flow_key]['label'];
                    $return_array['stage_details'] = $stage_details;
                    $return_array['has_generic_form'] = $stage_details->generic_form;
                    $return_array['stage_type'] = $chart_data[$stage_details->jwf_stage_type]['label'];
                    $return_array['added_forms'] = json_decode($stage_details->jwf_forms,true); //selected forms
               
                    $return_array['parent_stages'] = $parent_stage_array; //Selected parents
                    //$return_array['parent_stages'] = json_decode($stage_details[0]->jwf_parent_stages); //Selected parents
                    foreach ($return_array['parent_stages'] as $key => $parent_stage) {
                        $return_array['parent_stages'][$key] = $this->encrypt_data($parent_stage);
                    }
                    // seting flag by checking stages with invitation
                    $return_array['stage_assignment'] = isset($chart_data[$stage_details->jwf_stage_type]['default_assignment_type']) ? $chart_data[$stage_details->jwf_stage_type]['default_assignment_type'] : 'auto';
                    $return_array['stage_assignment_option'] = isset($chart_data[$stage_details->jwf_stage_type]['assignment_options']) ? implode(',', $chart_data[$stage_details->jwf_stage_type]['assignment_options']) : '';
                    //for article type - Need to do some optimisation in this area
                    if (isset($jnl_id)) {
                        $added_form = '';

                        $select_forms = !empty($return_array['added_forms']) ? implode(',', $return_array['added_forms']) : "";

                        $sql = "";
                        $generic_form_table = (new \App\Models\Generic_forms())->getTable();
                        if ($select_forms != "") {


                            $sql .= "select * from " . $generic_form_table;

                            $sql .= " where gncf_id IN (" . $select_forms . ") UNION ";
                        }
                        $sql .= "select * from " . $generic_form_table . " where gncf_form_type = '" . $stage_details->jwf_stage_type . "' and (gncf_jnl_id IS NULL OR gncf_jnl_id = " . $jnl_id . ")";

                        $added_form = Generic_forms::get_records_by_raw_query($sql);

                    } else {
                        $condition = "gncf_form_type=" . $stage_details->jwf_stage_type . " AND gncf_jnl_id IS NULL";
                        $added_form = Generic_forms::get_all_records('*', $condition);
                    }

                    /*** Customisation #2044 - JPR-322 Feedback on transfer functionality ***/

                    $current_flow = $chart_data[$stage_details->jwf_stage_type];
                    $return_array['show_transfer'] = (isset($current_flow['permission']) && in_array('transfer', $current_flow['permission']) && $current_stage['operation_type'] != 'add') ? 'y' : 'n';

                    if ($current_stage['operation_type'] == 'info') {

                        $return_array['stage_forms'] = $added_form; //stage forms
                       
                    } elseif ($current_stage['operation_type'] == 'edit') //edit area
                        {

                            $chart_key = $stage_details->jwf_stage_type;
                            $get_stage_types = $this->populated_get_stagetype($chart_key, $chart_data, 'edit');
                            $return_array['stage_types'] = $get_stage_types['stage_types'];
                            $possible_parents = array();
                            $parent_stage_types = $this->get_parent_stages($stage_details->jwf_stage_type, $chart_data);
                            $parent_stage_type_list = "'" . implode("','", $parent_stage_types) . "'";
                          
                            $singleparent_stages = $this->single_parent_stages();
                            $singleparentlist = "'" . implode("','", $singleparent_stages) . "'";

                            $sql = "SELECT tb1.jwf_id,tb1.jwf_stage_name FROM " . $generic_flow_table . " as tb1 WHERE tb1.jwf_fwm_id=" . $stage_details->jwf_fwm_id;
                            $condition = " AND IF(jwf_stage_type IN (" . $singleparentlist . ") AND (select count(jwf_id) from " . $generic_flow_table . " as tb2  where (JSON_SEARCH(tb2.jwf_parent_stages,'all',tb1.jwf_id) || FIND_IN_SET(tb1.jwf_id, REPLACE(REPLACE(tb2.jwf_parent_stages, '[', ''), ']', ''))) is NOT NULL  and tb2.jwf_id =" . $stage_details->jwf_id . ") = 0,jwf_child_stages='[]',TRUE)";
                            $condition .= " AND tb1.jwf_stage_type IN(" . $parent_stage_type_list . ")";
                            $condition .= " AND  tb1.jwf_id NOT IN (" . $stage_details->jwf_id . ")";


                            $main_sql = $sql . $condition;
                            $possible_parents = Generic_flows::get_records_by_raw_query($main_sql);

                            if (!empty($possible_parents)) {
                                foreach ($possible_parents as $key => $parent) {
                                    $possible_parents[$key]->jwf_id = $parent->jwf_id;
                                }
                            }
                            $return_array['stage_forms'] = $added_form; //stage forms
                            $return_array['possible_parents'] = $possible_parents; //Possible parents

                            $role_keys = $chart_data[$stage_details->jwf_stage_type]['roles'];
                            $rolelist = "'" . implode("','", $role_keys) . "'";
                            $role_details = $this->get_roles($rolelist);

                            $return_array['role_key'] = $role_keys;
                            $return_array['role_details'] = $role_details;
                            $return_array['current_stage'] = $this->encrypt_data($stage_details->jwf_id);

                            //Task 664 ICE ReView new stages
                            $return_array['stage_upload_flag'] = '';
                            $show_file_description = false;
                            if (isset($chart_data[$stage_details->jwf_stage_type]['stage_for']) && isset($chart_data[$stage_details->jwf_stage_type]['upload_type']) && $chart_data[$stage_details->jwf_stage_type]['stage_for'] == 'manageproduction' && ($chart_data[$stage_details->jwf_stage_type]['upload_type'] == 'optional' || $chart_data[$stage_details->jwf_stage_type]['upload_type'] == 'required')) {
                                $return_array['stage_upload_flag'] = $stage_details->jwf_production_upload;
                                //Feature#2549 Select file description for workflow stage.
                                if ($this->current_client->modules->mdl_production == 'y') {
                                    $show_file_description = true;
                                    $return_array['file_descriptions'] = json_decode($stage_details->jwf_afdec_ids);
                                }
                            }
                            $return_array['show_file_description'] = $show_file_description;
                            //workflow assignment source and destination stage selected details
                            $workflow_assignment_type_selection = $this->workflow_assignment_type_seletion_status($chart_key);
                            $source_assign_status = $workflow_assignment_type_selection['source_assign_status'];
                            $destination_assign_status = $workflow_assignment_type_selection['destination_assign_status'];
                            $workflow_id = $stage_details->jwf_id;
                            $selected_workflow_assignment_for_source_stage = array();
                            $selected_workflow_assignment_for_destination_stage = array();
                            if($source_assign_status === true)
                            {
                                $get_selected_workflow_assignment_for_source_stage = $this->get_selected_workflow_assignment_type_for_source_or_destination_stage($workflow_id,TRUE);
                                if(!empty($get_selected_workflow_assignment_for_source_stage[0]->war_wa_id))
                                    {
                                        $selected_workflow_assignment_for_source_stage=explode(',',$get_selected_workflow_assignment_for_source_stage[0]->war_wa_id);
                                    }
                            }
                            elseif($destination_assign_status === true)
                            {
                                $get_selected_workflow_assignment_for_destination_stage = $this->get_selected_workflow_assignment_type_for_source_or_destination_stage($workflow_id,FALSE);
                                if(!empty($get_selected_workflow_assignment_for_destination_stage[0]->war_id))
                                    {
                                        $selected_workflow_assignment_for_destination_stage=explode(',',$get_selected_workflow_assignment_for_destination_stage[0]->war_id);
                                    }
                            }
                            $return_array['selected_source_assign'] = $selected_workflow_assignment_for_source_stage;
                            $return_array['selected_destination_assign'] = $selected_workflow_assignment_for_destination_stage;
                            
                        }
                } else {
                $chart_key = $stage_details->jwf_stage_type;
                $get_stage_types = $this->populated_get_stagetype($chart_key, $chart_data, 'add');
                $return_array['stage_types'] = $get_stage_types['stage_types'];

            }
            if (!empty($return_array))
            {
                $return_array['message'] =customTrans('workflow.stage_detail_success_message');
                return $this->success("success",200,$return_array);
            }
            else{
                return  $this->warning('Failed',500,customTrans('workflow.not_found'));
            }
        } catch (\Exception $e) {

            return  $this->failure('Failed',500,$e);
        }
        
    }
    /*
    Get user Roles
    commited date :-  13-03-2022
    Request type :- GET
*/
    public function get_user_roles(Request $request)
    {
        try {
            $posted_data = $request->all();
   
           if (isset($posted_data['role_id']) && $posted_data['role_id'] != '') {
                    $extended_roles = array('staff', 'associate_editor', 'editor_in_chief', 'production_manager', 'tsp');
                    $exclude_role =$posted_data['role_id'];

                    $rolelist = "'" . implode("','", $extended_roles) . "'";

                    $criteria = 'role_assigned_role IN(' . $rolelist . ') AND role_id <>' . $exclude_role;
                    $extended_user_roles = Roles::get_all_records('role_id,role_name', $criteria);

                    $data_user_roles = array();
                    if (!empty($extended_user_roles)) {
                        foreach ($extended_user_roles as $user_roles) {
                            $data_user_roles[$user_roles->role_id] = $user_roles->role_name;
                        }
                    }
                    return $this->success('success',200,$data_user_roles);
                 
                }
                /*else {
                     return  $this->failure('Failed',500,customTrans('workflow.not_found'));
                }*/
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
       
    }
    /*
    Get Stage Handle
    commited date :-  13-03-2022
    Request type :- GET
*/
    public function handle_stage($parent_stages)
    {
        $result = array();
        $p_data_arr = array();
        $hid_stage_display_arr = array();

        $parent_stages = json_decode($parent_stages);
        for ($i = 0; $i < count($parent_stages); $i++) {
            $condition = 'jwf_id=' . $parent_stages[$i];
            $stage_detail = Generic_flows::get_single_record('jwf_id, jwf_stage_type, jwf_parent_stages, jwf_child_stages, jwf_xpos, jwf_ypos, jwf_stage_incomplete,jwf_import_custom_form_err,jwf_import_user_role_err ', $condition);
            if (!empty($stage_detail)) {
                $child_stage = json_decode($stage_detail->jwf_child_stages);

                if (!empty($child_stage)) {
                    for ($j = 0; $j < count($child_stage); $j++) {
                        $condition = 'jwf_id=' . $child_stage[$j];
                        $stage_datas = Generic_flows::get_single_record('jwf_id, jwf_stage_type, jwf_parent_stages, jwf_child_stages, jwf_xpos, jwf_ypos, jwf_stage_incomplete,jwf_import_custom_form_err,jwf_import_user_role_err ', $condition);

                        $p_data = $this->encrypt_data($child_stage[$j]);
                        array_push($p_data_arr, $p_data);
                    }
                } else {
                    array_push($p_data_arr, $this->encrypt_data($parent_stages[$i]));
                    array_push($hid_stage_display_arr, true);
                }
            }
        }
        $result['p_data_arr'] = $p_data_arr;
        $result['hid_stage_display_arr'] = $hid_stage_display_arr;
        return $result;
    }
    /*
    Update Parent Records
    commited date :-  13-03-2022
    Request type :- POST
*/
    //To update the parent records
    public function update_parents($new_stage_details, $stage_data)
    {
        $this->current_user = $this->get_current_user_details();
        $ypos = 0;

        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);

        //Task #424 Production Management
        $all_roles = $this->set_all_roles_key_value();
        foreach ($new_stage_details as $parent) {
            $update_parent = array();
            $criteria = "jwf_id=" . $parent . " AND jwf_fwm_id=" . $stage_data['jwf_fwm_id'];
            //Need to update parent details
            $parent_details = Generic_flows::get_single_record('jwf_id, jwf_child_stages, jwf_ypos, jwf_stage_type, jwf_flow_proceed_type,jwf_role_id', $criteria);
      
            if(!empty( $parent_details))
         {
            $allow_roles = $review_flow[$parent_details->jwf_stage_type]['roles'];
            $non_allow_roles_array = $this->RolesConfigdata('non_privileged_user_roles');
            $non_allow_roles=$non_allow_roles_array['non_privileged_user_roles'];
            //Task #424 Production Management
            $work_role = '';
            if (isset($all_roles[$parent_details->jwf_role_id]))
            {
                $work_role = $all_roles[$parent_details->jwf_role_id];
            }

            $parent_childs = array();

            if (!empty($parent_details->jwf_child_stages) && ($parent_details->jwf_child_stages !== null)) {
                $parent_childs = json_decode($parent_details->jwf_child_stages);
                if ($parent_childs == null) {
                    $parent_childs = array();
                }
            }
            array_push($parent_childs, (string)$stage_data['jwf_id']); //push child 
            $parent_childs = array_unique($parent_childs);
            $parent_incomplete = 'n';
            if ((count(array_intersect($non_allow_roles, $allow_roles)) == 0 || in_array($work_role, $non_allow_roles) === false) && ($parent_details->jwf_flow_proceed_type == "" || $parent_details->jwf_flow_proceed_type == null) && count($parent_childs) > 1) {
                $parent_incomplete = 'y';
            }

            if (count(array_intersect($non_allow_roles, $allow_roles)) > 0 && count($parent_childs) > 1 &&  in_array($work_role, $non_allow_roles) == TRUE) //Task #424 Production Management
                {
                    $update_parent['jwf_flow_proceed_type'] = 'parallel';
                }

            if ($ypos < $parent_details->jwf_ypos)
            {
                $ypos = $parent_details->jwf_ypos;
            }

            $update_parent['jwf_child_stages'] = json_encode(array_unique(array_values($parent_childs))); // added array_value() so that when json encoding of associative array having unordered intiger key results encoded string of object array
            $update_parent['jwf_stage_incomplete'] = $parent_incomplete;
            $edit_array = 'jwf_id=' . $parent_details->jwf_id;
            Generic_flows::update_record($update_parent, $edit_array,$this->current_user);
            }
        }
        return (++$ypos);
    }
    /*
    Update  Position
    commited date :-  13-03-2022
    Request type :- POST
        */
    public function update_position($stage_data, $ypos)
    {
        $this->current_user = $this->get_current_user_details();
        $xpos = $stage_data['jwf_xpos'];
        

        if ($stage_data['jwf_ypos'] != $ypos) {
            $criteria ="jwf_id!=".$stage_data['jwf_id']." AND jwf_fwm_id=" . $stage_data['jwf_fwm_id'] . " AND jwf_ypos LIKE " . $ypos;
           // echo $criteria;
            $max_x_pos = Generic_flows::get_single_record('max(jwf_xpos) max_x', $criteria);

            if ($max_x_pos && $max_x_pos->max_x !== null)
            {
                
                $xpos = $max_x_pos->max_x + 2;
            }
        }
        $criteria = 'jwf_id=' . $stage_data['jwf_id'];
        Generic_flows::update_record(array(
            'jwf_ypos' => $ypos,
            'jwf_xpos' => $xpos
        ), $criteria,$this->current_user);

        $stage_data['jwf_xpos'] = $xpos;
        $stage_data['jwf_ypos'] = $ypos;
    }
    public function stage_flow_anomalies($parent_ids, $fwm_id)
    {
        $flow_meta = array(
            'child_stages' => array(),
            'issues_btn' => array(),
            'issues_msg' => array(),
            'hd_parent_st_add' => array(), //prevent parent stage add due to parallel stages
            'dy_parent_st_add' => array(), //allow parent stage add
            'single_child_stages' => array()
        );

        /*
		 * 1 create a loop to navigate through parent stage id   
		 */

        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);

        //Task #424 Production Management
        $all_roles = $this->set_all_roles_key_value();

        foreach ($parent_ids as $pnt_id) {
            /*
			 * 1.1 fetch parent stage data
			 */
            $condition = 'jwf_id=' . $pnt_id . ' AND jwf_fwm_id=' . $fwm_id;
            $parent_details = Generic_flows::get_single_record('jwf_id, jwf_child_stages,jwf_stage_type,jwf_stage_incomplete,jwf_flow_proceed_type,jwf_parent_stages,jwf_role_id', $condition);



            $jwf_parent_stages = json_decode($parent_details->jwf_parent_stages);
            $current_stage_in_parallel = 0;
            if (count($jwf_parent_stages) > 0) {
		        $generic_table = (new \App\Models\Generic_flows())->getTable();
                $select_cond = '(select count(*) from ' . $generic_table . ' where (((LENGTH(jwf_child_stages) -LENGTH(REPLACE(jwf_child_stages,\'"\',\'\')))> 2 AND jwf_flow_proceed_type =\'parallel\') OR jwf_stage_incomplete=\'y\') and jwf_id IN (' . implode(',', $jwf_parent_stages) . ')) as current_stage_in_parallel';
                $con="jwf_id={$pnt_id}";
                $parallel_stg = Generic_flows::get_single_record($select_cond,$con);
                $current_stage_in_parallel = $parallel_stg->current_stage_in_parallel;
            }

            $parent_childs = array();
            /*
			 * 1.2  Process and assign fetch data to array $parent_childs - child stages
			 */
    
            /*
			 * 1.3 Remove if any duplication in child stages is present.
			 */
            $parent_childs = array_unique($parent_childs);

            /*
			 * 1.4 Fetch stage roles from workflow library
			 */
            $allow_roles = $review_flow[$parent_details->jwf_stage_type]['roles'];
            $non_allow_roles_array = $this->RolesConfigdata('non_privileged_user_roles');
            $non_allow_roles=$non_allow_roles_array['non_privileged_user_roles'];
            //Task #424 Production Management
            $work_role = '';
            if (isset($all_roles[$parent_details->jwf_role_id]))
            {
                $work_role = $all_roles[$parent_details->jwf_role_id];
            }

            /*
			 * 1.5 Assign parent id to flow meta array if parent childs is zero
			 */
            if (sizeof($parent_childs) == 0) {
                $flow_meta['child_stages'][] = $this->encrypt_data($pnt_id);
            }
            /*
			 * 1.6 Check child stage array size equal to 1 and assign stage data to $flow_meta['single_child_stages'][]
			 */ elseif (sizeof($parent_childs) == 1) {
                $flow_meta['single_child_stages'][] = $this->encrypt_data($pnt_id);
            }
            /*
			 * 1.7 Check current parent stage having only privileged roles and  more than only child stage 
			 */ elseif ((count(array_intersect($non_allow_roles, $allow_roles)) == 0 || in_array($work_role, $non_allow_roles) === false) && sizeof($parent_childs) > 1) {
                /*
				 * 1.7.1 Assign encrypted parent id to flow meta [issue_btn] array
				 */
                $flow_meta['issues_btn'][] = $this->encrypt_data($pnt_id);
                /*
				 * 1.7.2 Check stage is incomplete then assign encrypted parent id to flow meta [issue_btn] array
				 */
                if ($parent_details->jwf_stage_incomplete == 'y')
                {
                    $flow_meta['issues_msg'][] = $this->encrypt_data($pnt_id);
                }
            }
        }

        return $flow_meta;
    }

    /*
      Check validate Workflow
    */
    public function validate_flow($flow_id)
    {
        $condition = 'jwf_fwm_id=' . $flow_id;
        $jnl_flow = Generic_flows::get_all_records('*', $condition);

        $my_flow = $this->convert_to_assoc($jnl_flow, 'jwf_id');

        return $this->have_exit_points($my_flow, 'jwf_child_stages');
    }


    /*
     Manage Advance flow Connection
    */
    //Task 664 ICE ReView new stages
    public function manage_stage_advance_flow_connection($avoid_frm_parents, $stage_id)
    {
        
        $this->current_user = $this->get_current_user_details();
        if (count($avoid_frm_parents) > 0) {

            foreach ($avoid_frm_parents as $rmparent) {
                $where_cnt = 'afm_jwf_id = ' . $rmparent . ' AND FIND_IN_SET(' . $stage_id . ',afm_associated_stage_ids)';

                $res = Advance_flow_movement::get_single_record('afm_id,afm_jwf_id,afm_associated_stage_ids', $where_cnt);

                if (!empty($res)) {
                    $paired_btns = explode(',', $res->afm_associated_stage_ids);
                    $condition = "afm_id={$res->afm_id}";

                    //if more than one then remove that stage only
                    if (count($paired_btns) > 1) {
                        $index = array_search($stage_id, $paired_btns);
                        unset($paired_btns[$index]);

                        Advance_flow_movement::update_record(array(
                            'afm_associated_stage_ids' => implode(',', $paired_btns)
                        ), $condition,$this->current_user);
                    } else //if only one stage then remove that entry
                        {
                            Advance_flow_movement::delete_records($condition,'', $this->current_user);
                        }
                }
            }
        }
        return true;
    }
    /*
Remove Paents Function
*/
    public function remove_parents($stage_id, $parent_ids, $fwm_id, $action = 'update')
    {
        $this->current_user = $this->get_current_user_details();
        /*
             * 1 create a loop to navigate through parent stage id
             */

        for ($i = 0; $i < count($parent_ids); $i++) {
            /*
                 * 1.1 fetch parent stage data
                 */
            $condition = 'jwf_id=' . $parent_ids[$i] . " AND jwf_fwm_id=" . $fwm_id;
            $parent_details = Generic_flows::get_single_record('jwf_id, jwf_child_stages, jwf_stage_incomplete', $condition);

            $parent_childs = array();
            /*
                 * 1.2  Process and assign fetch data to array $parent_childs - child stages
                 */
            if (isset($parent_details->jwf_child_stages) && (!empty($parent_details->jwf_child_stages))) {
                if (is_array($parent_details->jwf_child_stages) === true) {
                    $childstages = $parent_details->jwf_child_stages;
                } else {
                    $childstages = json_decode($parent_details->jwf_child_stages);
                }
            }

            if (isset($childstages) && ($childstages != null) && count($childstages) > 0) {
                $parent_childs = $childstages;
            }
            /*
                 * 1.3 search old stage id in child stage array and assign it's key and unset it (remove parameter stage id from its parent stage's child array) for delete parent id condition.
                 */
            if (($key = array_search($stage_id, $parent_childs)) !== false) {
                unset($parent_childs[$key]);
            }

            /*
                 * 1.4 Remove if any duplication in child stages is present.
                 */
            $parent_childs = array_unique($parent_childs);

            /*
                 * 1.5 assign child stage array,$parent_details->jwf_stage_incomplete to $updated_details array
                 */
            $updated_details = array(
                'jwf_stage_incomplete' => $parent_details->jwf_stage_incomplete,
                'jwf_child_stages' => json_encode(array_values($parent_childs))
            );

            /*
                 * 1.6 process child stage array and assign $updated_details['jwf_flow_proceed_type'] as null only in delete condtion and not in update
                 */
            if (count(array_values($parent_childs)) <= 1 && $action == 'delete') {
                $updated_details['jwf_stage_incomplete'] = 'n';
            }
            /*
                 * 1.7 update details to parent stage
                 */
            $condition = 'jwf_id=' . $parent_details->jwf_id;
            Generic_flows::update_record(
                $updated_details,
                $condition,$this->current_user
            );
        }
    }
    /*
      Add Parent functions
    */

    public function add_parents($stage_id, $parent_ids, $fwm_id)
    {
        $this->current_user = $this->get_current_user_details();
        /*
             * 1 create a loop to navigate through parent stage id
             */

        for ($i = 0; $i < count($parent_ids); $i++) {
            /*
                 * 1.1 fetch parent stage data
                 */
            $condition = 'jwf_id=' . $parent_ids[$i] . " AND jwf_fwm_id=" . $fwm_id;
            $parent_details = Generic_flows::get_single_record('jwf_id, jwf_child_stages, jwf_stage_incomplete', $condition);

            $parent_childs = array();
            /*
                 * 1.2  Process and assign fetch data to array $parent_childs - child stages
                 */

            if (isset($parent_details->jwf_child_stages) && (!empty($parent_details->jwf_child_stages))) {
                if (is_array($parent_details->jwf_child_stages) === true) {
                    $childstages = $parent_details->jwf_child_stages;
                } else {
                    $childstages = json_decode($parent_details->jwf_child_stages);
                }
            }

            if (isset($childstages) && ($childstages != null) && count($childstages) > 0) {
                $parent_childs = $childstages;
            }
            /*
                 * 1.4 Remove if any duplication in child stages is present.
                 */
            $parent_childs = array_unique($parent_childs);

            /*
                 * 1.5 Check child stage array size equal to 1 and assign stage data to $flow_meta['single_child_stages'][],$parent_details->jwf_stage_incomplete  as n
                 */
          
            if (sizeof($parent_childs) == 1) {
                $parent_details->jwf_stage_incomplete = 'n';
            }

            /*
                 * 1.6 assign child stage array,$parent_details->jwf_stage_incomplete to $updated_details array
                 */
            $updated_details = array(
                'jwf_stage_incomplete' => $parent_details->jwf_stage_incomplete,
                'jwf_child_stages' => json_encode(array_values($parent_childs))
            );
            /*
                 * 1.7 process child stage array and assign $updated_details['jwf_flow_proceed_type'] as null
                 */
            //Remove flow process type if child stage count is less than or equal to 1.

            /*
                 * 1.8 update details to parent stage
                 */
            $condition = 'jwf_id=' . $parent_details->jwf_id;
            Generic_flows::update_record(
                $updated_details,
                $condition,$this->current_user
            );
        }
    }
    /*
      Save flow layout 
    */
    public function save_flow_layout(Request $request)
    {
        try {
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $flow_data = $request->all();

            if (!empty($flow_data['nodes'])) {
                    foreach ($flow_data['nodes'] as $node) {
                            $ids[] = $node['data']['node_id'];
                            $jwf_id = $node['data']['node_id'];
                            $ypos = $node['position']['y'] / 100;
                            $xpos = $node['position']['x'] / 100;
                            $posted_date = date('Y-m-d H:i:s');
                            $posted_id = $tokeninfo['user_id'];
                            $cases_ypos[] = "when jwf_id = {$jwf_id} then '{$ypos}'";
                            $cases_xpos[] = "when jwf_id = {$jwf_id} then '{$xpos}'";
                            $cases_posted_date[] = "when jwf_id={$jwf_id} then '{$posted_date}' ";
                            $case_posted_by[] = "when jwf_id={$jwf_id} then '{$posted_id}' ";
                        }
                }
            $idlist = implode(',', $ids);
            $cases_ypos_list = implode(' ', $cases_ypos);
            $cases_xpos_list = implode(' ', $cases_xpos);
            $cases_post_date = implode('', $cases_posted_date);
            $cases_posted_by = implode('', $case_posted_by);
            $flow_table = (new \App\Models\Generic_flows())->getTable();
            DB::enableQueryLog();
            $sql = "UPDATE {$flow_table} SET jwf_ypos = (case {$cases_ypos_list} end), jwf_xpos=(case {$cases_xpos_list} end ),jwf_posted_date=( case {$cases_post_date} end ),jwf_posted_by=( case {$cases_posted_by} end)  WHERE jwf_id IN(" . $idlist . ")";
            $update = Generic_flows::get_records_by_raw_query($sql);
            $result['message']= customTrans('workflow.layout_saved');
            return $this->success('success', 200, $result);
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
       
    }

    public function save_individual_node_layout(Request $request)
    {
        try
        {
            $post_data=$request->all();
            $flow_data=$post_data['nodedata'];
            $current_user = $this->get_current_user_details();
            $flow_table = (new \App\Models\Generic_flows())->getTable();
            $jwf_id = $flow_data['data']['node_id'];
            $ypos = $flow_data['position']['y'] / 100;
            $xpos = $flow_data['position']['x'] / 100;
            $posted_date = date('Y-m-d H:i:s');
            $posted_id = $current_user['user_id'];
            $sql = "UPDATE {$flow_table} SET jwf_ypos ='{$ypos}' , jwf_xpos='{$xpos}',jwf_posted_date='{$posted_date}',jwf_posted_by={$posted_id}  WHERE jwf_id IN(" .  $jwf_id . ")";
            $update = Generic_flows::get_records_by_raw_query($sql);
            $result['message']= customTrans('workflow.layout_saved');
            return $this->success('success', 200, $result);
        }
        catch (\Exception $e) {

            return  $this->failure('Failed',500,$e);
           
        }
    }
    /*
    Export Workflow
    commited date :-  13-03-2022
    Request type :- POST
    */

    public function export_journal_flow(Request $request)
    {

        try
        {
        $return_arr = array(
            'status' => 'failed',
            'bugs' => ''
        );
        $post_data = $request->all();
        $platform_id = $post_data['platform_id'];
        $master_flow_id = $post_data['platform_flow_master_id'];
        if ($platform_id != '') {
                $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                $role_table = (new \App\Models\Roles())->getTable();
                $generic_forms = (new \App\Models\Generic_forms())->getTable();
                $ftp_table = (new \App\Models\Ftp())->getTable();
                $filedecription_table = (new \App\Models\Attachment_file_description())->getTable();
                $advance_flow_movement_table = (new \App\Models\Advance_flow_movement())->getTable();
                $stage_email_template_table = (new \App\Models\Stage_email_templates())->getTable();
                $stage_email_tmpl_reference_table = (new \App\Models\Stage_email_tmpl_reference())->getTable();
                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);


                $review_flow_keys = array_keys($review_flow);
                $order_by = ' ORDER BY FIELD(jwf_stage_type,\'' . implode('\',\'', $review_flow_keys) . '\')';

                //fet journal workflow data
                $workflow_select = '*,(select concat(role_assigned_role,"##",role_name) from ' . $role_table . ' where jwf_role_id = role_id) as stage_role, (select Group_concat(gncf_form_name SEPARATOR ",") from ' . $generic_forms . ' where FIND_IN_SET(gncf_id,replace(replace(replace(jwf_forms,\'"\',""),"]",""),"[",""))) as form_titles,(select Group_concat(concat(role_assigned_role,"##",role_name) SEPARATOR ",") from ' . $role_table . ' where FIND_IN_SET(role_id,replace(replace(replace(jwf_parent_user_roles,\'"\',""),"]",""),"[",""))) as parent_user_roles,(select Group_concat(concat(role_assigned_role,"##",role_name) SEPARATOR ",") from ' . $role_table . ' where FIND_IN_SET(role_id,replace(replace(replace(jwf_who_can_invite,\'"\',""),"]",""),"[",""))) as who_can_invite, (select Group_concat(afdec_description SEPARATOR ",") from ' . $filedecription_table . ' where FIND_IN_SET(afdec_id,replace(replace(replace(jwf_afdec_ids,\'"\',""),"]",""),"[",""))) as file_descriptions';
                $crietria = " WHERE jwf_fwm_id  ={$master_flow_id} AND jwf_hide_status='n'";
                $joincolumn = "(`ftp_jwf_id` = `jwf_id` AND `ftp_is_default` = 'y' AND `ftp_jwf_id` IS NOT NULL)";
                $main_sql = "SELECT {$workflow_select} FROM {$generic_flow_table} LEFT JOIN {$ftp_table} ON {$joincolumn} {$crietria} {$order_by}";

                $journal_workflow_data = Generic_flows::get_records_by_raw_query($main_sql);

                // echo $main_sql;exit;
                $jwf_arr = array();

                /*  $criteria = 'jwf_id=' . $jwf_id;
             $select = '*';
             $tables = array(
                 'main_table' => $generic_flow_table,
                 'join_table' => array(
                     $role_table => array($generic_flow_table . '.jwf_role_id', $role_table . '.role_id', "left")
                 )
             );
 
             $stage_details = Generic_flows::get_results_using_joins($tables, $select, $criteria, 'single');
 */
                /*	$join_tables = array(
				'main_table' => $generic_flow_table,
				'join_table' => array(
					$ftp_table => array("( {$ftp_table}. ftp_jwf_id = {$generic_flow_table}.jwf_id AND {$ftp_table}.ftp_is_default = 'y' AND {$ftp_table}.ftp_jwf_id IS NOT NULL)","left")
                )
                );
           */
                //$journal_workflow_data=Generic_flows::get_results_using_joins($join_tables,$workflow_select,,'all',$order_by);
                //exit;	

                /*$journal_workflow_data = $this->Generic_flows->get_results_using_joins($join_tables,'all',$workflow_select, array(
				'jwf_fwm_id' => $master_flow_id,
				'jwf_hide_status' => 'n'
			),$order_by);*/

                //Task 664 ICE ReView new stages

                $criteria = 'jwf_fwm_id=' . $master_flow_id;
                $select_col = $advance_flow_movement_table . '.*,' . $generic_flow_table . '.jwf_stage_name';
                $tables = array(
                    'main_table' => $advance_flow_movement_table,
                    'join_table' => array(
                        $generic_flow_table => array($generic_flow_table . '.jwf_id', $advance_flow_movement_table . '.afm_jwf_id', "left")
                    )
                );

                $advance_flow_data = Advance_flow_movement::get_results_using_joins($tables, $select_col, $criteria, 'all');

                /*$join_tables = array(
				'main_table' => Advance_flow_movement::$tbl_name,
				'join_table' => array(
					Generic_flows::$tbl_name => 'afm_jwf_id = jwf_id',
			));
			$select_col = Advance_flow_movement::$tbl_name.'.*,'.Generic_flows::$tbl_name.'.jwf_stage_name';
			$advance_flow_data = $this->Advance_flow_movement->get_results_using_joins($join_tables,'all',$select_col,array(
				'jwf_fwm_id' => $master_flow_id
			));
     */
                //Customisation #1565 : JPR-120 : Email Templates: Global Email template
                $assoc_email_tmpls = $get_email_tmpls = $ftp_arr = array();
                $user_roles = array();
                if (!empty($journal_workflow_data)) {
                        /*
				$get_email_tmpls = $this->Stage_email_templates->get_all_records('*', array(
					'stage_etmp_journal_id' => $jnl));
				*/
                        /* $criteria = 'jwf_fwm_id=' . $master_flow_id;
                $select_emails = $stage_email_template_table.'.*';
                $tables = array(
                    'main_table' =>$stage_email_template_table,
                    'join_table' => array(
                        $stage_email_tmpl_reference_table => array($stage_email_template_table . '.stage_etmp_id', $stage_email_tmpl_reference_table .' .setr_stage_etmp_id'),
                        $generic_flow_table => array($generic_flow_table . '.jwf_id', $stage_email_tmpl_reference_table .' .setr_jwf_id')
                    )
                );
                $get_email_tmpls=Stage_email_templates::get_results_using_joins($tables,$select_emails,$criteria,'all');
               */
                        $main_sql = "SELECT {$stage_email_template_table}.* FROM {$stage_email_template_table} INNER JOIN {$stage_email_tmpl_reference_table} ON {$stage_email_template_table}.stage_etmp_id = {$stage_email_tmpl_reference_table}.setr_stage_etmp_id INNER JOIN {$generic_flow_table} ON {$generic_flow_table}.jwf_id = {$stage_email_tmpl_reference_table} .setr_jwf_id WHERE jwf_fwm_id ={$master_flow_id}";
                        $get_email_tmpls = Stage_email_templates::get_records_by_raw_query($main_sql);
                        //  echo '<pre>';print_r($main_sql);die;
                        //echo '<pre>';print_r($get_email_tmpls);die;
                        /*$join_tables_email = array(
				'main_table' => Stage_email_templates::$tbl_name,
				'join_table' => array(
					Stage_email_tmpl_reference::$tbl_name => 'setr_stage_etmp_id = stage_etmp_id',
					Generic_flows::$tbl_name => 'setr_jwf_id = jwf_id',
				));
				$select_emails = Stage_email_templates::$tbl_name.'.*';
				$get_email_tmpls = $this->Stage_email_templates->get_results_using_joins($join_tables_email,'all',$select_emails,array(
					'jwf_fwm_id' => $master_flow_id
				));*/

                        //echo '<pre>';print_r($get_email_tmpls);die;

                        $role_name_arr = Roles::get_all_records('role_name, role_assigned_role', 'role_assigned_role NOT IN ("system", "author")');

                        foreach ($role_name_arr as $role) {
                                $user_roles[$role->role_name] = $role->role_assigned_role;
                            }

                        $jrnl_tmpl_ids = array_column(json_decode(json_encode($get_email_tmpls), TRUE), 'stage_etmp_id');
                        $global_tmpl_ids = $get_global_tmpls = array();
                        $jrnl_workflow_stages = array_column(json_decode(json_encode($journal_workflow_data), TRUE), 'jwf_id');
                        if (!empty($jrnl_workflow_stages)) {
                                $assoc_email_tmpls = Stage_email_tmpl_reference::get_all_records('*', 'setr_jwf_id IN(' . implode(',', $jrnl_workflow_stages) . ')');

                                /* $asoc_tmpl_ids = array_unique(array_column(json_decode(json_encode($assoc_email_tmpls), TRUE), 'setr_stage_etmp_id'));

					$global_tmpl_ids = array_diff($asoc_tmpl_ids, $jrnl_tmpl_ids);
					if (!empty($global_tmpl_ids))
					{
						$get_global_tmpls = $this->Stage_email_templates->get_all_records('*', 'stage_etmp_journal_id IS NULL AND stage_etmp_id IN(' . implode(',', $global_tmpl_ids) . ')');
						$i = count($get_email_tmpls);
						foreach ($get_global_tmpls as $gt)
						{
							$get_email_tmpls[$i] = $gt;
							$i++;
						}
					}
					*/
                            }
                    }
               $journal_data=Journals::get_single_record('*',"jnl_id={$platform_id}");
             
                $xml_string = '<journal version="1.0" export_date="' . date('Y-m-d H:i:s') . '" ></journal>';
               //echo  Storage::get('uploads/jgere');exit;
               $file_path='/storage/uploads/'.$journal_data->jnl_journal_code.'/'. env('PLATFORMTYPE').'_workflow_' . $journal_data->jnl_journal_code . '.xml'; 
              //  echo public_path($file_path);exit;
                //$file_location = 'uploads' . DIRECTORY_SEPARATOR . $this->journal_code . DIRECTORY_SEPARATOR . 'journal_workflow_' . $this->journal_code . '.xml';
              //  $file_location = public_path() . '/journal_workflow.xml';
              $file_location = public_path() . $file_path;
             
                if (file_exists($file_location))
                    unlink($file_location);

                file_put_contents($file_location, $xml_string);
             
                $destination = $file_location;

                $doc = new \DOMDocument();
                $doc->formatOutput = false;
                $doc->load($destination);


                $xpath = new \DOMXpath($doc);
                $root_element = $xpath->query('/journal');

                //1.0CREATE JOURNAL META NODE
                $journal_data = array(
                    'title' => 'jounal_title',
                    'code' => 'jounal_code',
                );
                $root_node = $root_element->item(0);
                $this->generate_node($doc, $root_node, 'journal_meta', $journal_data);

                //2.0CREATE WORKFLOW META NODE
                $workflow_node = $doc->createElement('workflow');

                foreach ($journal_workflow_data as $jnl_flow) {
                        //set user role
                        $ftp_temp = array();
                        foreach ($jnl_flow as $ftp_key => $ftp_val) {
                                if (substr($ftp_key, 0, 4) == 'ftp_') {
                                        if ($ftp_val != '') {
                                                $ftp_temp[$ftp_key] = $ftp_val;
                                                if ($ftp_key == 'ftp_jwf_id')
                                                    $ftp_temp['stage_name'] = $jnl_flow->jwf_stage_name;
                                            }

                                        unset($jnl_flow->$ftp_key);
                                    }
                            }
                        if (count($ftp_temp) > 0)
                            $ftp_arr[] = (object)$ftp_temp;

                        if (in_array($jnl_flow->jwf_id, $jwf_arr)) {
                                continue;
                            } else {
                                $jwf_arr[] = $jnl_flow->jwf_id;
                            }
                        $stage_role = explode('##', $jnl_flow->stage_role);
                        if (!empty($stage_role) && count($stage_role) > 0) {
                            if(isset($stage_role[1]))
                            {
                                $jnl_flow->jwf_role_id = array(
                                    'value' => $stage_role[1],
                                    'attrib' => array(
                                        'role' => $stage_role[0],
                                        'error_filed' => 'User Role'
                                    ),
                                );
                            }
                            }
                        unset($jnl_flow->stage_role);

                        //#3122 File description bug while exporting and importing
                        $jnl_flow->jwf_afdec_ids = array();
                        if (isset($jnl_flow->file_descriptions) && !empty($jnl_flow->file_descriptions)) {
                                $jwf_afdec_arr = explode(',', $jnl_flow->file_descriptions);
                                $child_nods = array();
                                if (count($jwf_afdec_arr) > 0) {
                                        foreach ($jwf_afdec_arr as $each_jwf_afdec) {
                                                if (!empty($each_jwf_afdec)) {
                                                        $child_nods[] = array(
                                                            'node' => 'file_description',
                                                            'value' => $each_jwf_afdec
                                                        );
                                                    }
                                            }
                                        $jnl_flow->jwf_afdec_ids['child_nodes'] =  $child_nods;
                                    }
                            }
                        $jnl_flow->jwf_afdec_ids['attrib'] = array(
                            'json_data' => 'true',
                            'error_filed' => 'File description'
                        );
                        unset($jnl_flow->file_descriptions);


                        //set generic form id
                        $jnl_flow->jwf_forms = array();
                        if ($jnl_flow->form_titles != '') {
                                $stage_forms = explode(',', $jnl_flow->form_titles);
                                $child_nodes = array();
                                foreach ($stage_forms as $stg_frm) {
                                        $child_nodes[] = array(
                                            'node' => 'form',
                                            'value' => $stg_frm,
                                        );
                                    }
                                $jnl_flow->jwf_forms['child_nodes'] = $child_nodes;
                            }

                        $jnl_flow->jwf_forms['attrib'] = array(
                            'json_data' => 'true',
                            'error_filed' => 'Form'
                        );
                        unset($jnl_flow->form_titles);

                        //set parent_user_roles
                        if ($jnl_flow->parent_user_roles != '[]') {
                                $stage_parentuser_roles = explode(',', $jnl_flow->parent_user_roles);
                                $child_nodes = array();

                                foreach ($stage_parentuser_roles as $usr_role) {
                                        if ($usr_role == '')
                                            continue;
                                        $par_role = explode('##', $usr_role);
                                        if (count($par_role) > 0) {
                                                $child_nodes[] = array(
                                                    'node' => 'role',
                                                    'value' => $par_role[1],
                                                    'attrib' => array(
                                                        'role' => trim($par_role[0])
                                                    ),
                                                );
                                            }
                                    }
                                $jnl_flow->jwf_parent_user_roles = array(
                                    'child_nodes' => $child_nodes,
                                    'attrib' => array(
                                        'json_data' => 'true',
                                        'error_filed' => 'Parent user roles'
                                    )
                                );
                            } else
                            $jnl_flow->jwf_parent_user_roles = '';
                        unset($jnl_flow->parent_user_roles);

                        //set who_can_invite
                        if ($jnl_flow->who_can_invite != '[]') {
                                $stage_who_can_invite = explode(',', $jnl_flow->who_can_invite);
                                $child_nodes = array();

                                foreach ($stage_who_can_invite as $usr_role) {
                                        if ($usr_role == '')
                                            continue;
                                        $invite_role = explode('##', $usr_role);
                                        if (count($invite_role) > 0) {
                                                $child_nodes[] = array(
                                                    'node' => 'role',
                                                    'value' => $invite_role[1],
                                                    'attrib' => array(
                                                        'role' => trim($invite_role[0])
                                                    ),
                                                );
                                            }
                                    }
                                $jnl_flow->jwf_who_can_invite = array(
                                    'child_nodes' => $child_nodes,
                                    'attrib' => array(
                                        'json_data' => 'true',
                                        'error_filed' => 'Who can invite'
                                    )
                                );
                            } else
                            $jnl_flow->jwf_who_can_invite = '';
                        unset($jnl_flow->who_can_invite);
                      
                        //avoid parent/child duplicate
                        if ($jnl_flow->jwf_parent_stages != '') {
                                $parent_temp = json_decode($jnl_flow->jwf_parent_stages);
                                $parent_temp = array_unique($parent_temp);
                                $jnl_flow->jwf_parent_stages = json_encode($parent_temp);
                       
                            }
                      
                        if ($jnl_flow->jwf_child_stages != '') {
                                $child_temp = json_decode($jnl_flow->jwf_child_stages);
                                $child_temp = array_unique($child_temp);
                                $jnl_flow->jwf_child_stages = json_encode($child_temp);
                            }
                        if(isset($jnl_flow->jwf_flip))
                            {
                                unset($jnl_flow->jwf_flip);
                            }
                         
                        $this->generate_node($doc, $workflow_node, 'stage', $jnl_flow);
                    }

                //SETTING META -- START

                /*$settings_details = array(
				'meta_one' => $this->encrypt_password($this->db->hostname),
				'meta_two' => $this->encrypt_password($this->db->database),
			);*/

                //$settings_meta_node = $doc->createElement('settings');
                //	$this->generate_node($doc, $root_node, 'settings_meta', $settings_details);
                //SETTING META -- STOP

                //CREATE ADV_FLOW NODE -- Task 664 ICE ReView new stages
                $adv_flow_node = $doc->createElement('adv_flow');
                if (count($advance_flow_data) > 0) {
                        foreach ($advance_flow_data as $adv_fl) {
                                $adv_fl->afm_jwf_id = array(
                                    'value' => $adv_fl->jwf_stage_name,
                                    'attrib' => array(
                                        'id' => $adv_fl->afm_jwf_id,
                                    ),
                                );
                                unset($adv_fl->jwf_stage_name);

                                //set associated stages
                                if ($adv_fl->afm_associated_stage_ids != '') {
                                        $stage_ids = explode(',', $adv_fl->afm_associated_stage_ids);
                                        $child_nodes = array();

                                        foreach ($stage_ids as $stg) {
                                                if ($stg == '')
                                                    continue;

                                                $child_nodes[] = array(
                                                    'node' => 'stage_id',
                                                    'value' => $stg,
                                                );
                                            }
                                        $adv_fl->afm_associated_stages = array(
                                            'child_nodes' => $child_nodes,
                                            'attrib' => array(
                                                'json_data' => 'false',
                                            )
                                        );
                                    }

                                unset($adv_fl->afm_associated_stage_ids);

                                $this->generate_node($doc, $adv_flow_node, 'button', $adv_fl);
                            }
                    }

                //CREATE FTP_FLOW NODE
                $ftp_flow_node = $doc->createElement('ftp_flow');
                if (count($ftp_arr) > 0) {
                        foreach ($ftp_arr as $ftp_sg) {
                                $ftp_sg->ftp_jwf_id = array(
                                    'value' => $ftp_sg->stage_name,
                                    'attrib' => array(
                                        'id' => $ftp_sg->ftp_jwf_id,
                                    ),
                                );

                                unset($ftp_sg->stage_name);
                                if(!empty($ftp_sg->ftp_afdec_ids)){
                                $ftp_afdec_id_arr = explode(',', $ftp_sg->ftp_afdec_ids);
                                $chd_nods = array();
                                if (count($ftp_afdec_id_arr) > 0) {
                                        foreach ($ftp_afdec_id_arr as $each_afdec_id) {
                                                $file_description = Attachment_file_description::get_single_record('afdec_description', 'afdec_id = ' . $each_afdec_id);
                                                if (!empty($each_afdec_id) && !empty($file_description)) {
                                                        $chd_nods[] = array(
                                                            'node' => 'afdec',
                                                            'value' => $file_description->afdec_description,
                                                            'attrib' => array(
                                                                'id' => $each_afdec_id,
                                                            ),
                                                        );
                                                    }
                                            }
                                        $ftp_sg->ftp_afdec_ids =  array(
                                            'child_nodes' => $chd_nods
                                        );
                                    }
                                }
                                $this->generate_node($doc, $ftp_flow_node, 'ftp', $ftp_sg);
                            }
                    }

                $root_node->appendChild($workflow_node);

                //Task 664 ICE ReView new stages
                $root_node->appendChild($adv_flow_node);

                //add stage FTP location
                $root_node->appendChild($ftp_flow_node);

                if (!empty($get_email_tmpls)) {
                        //3.0CREATE EMAIL TEMPLATE NODE
                        $email_template_node = $doc->createElement('email_template');

                        $fxd_send_to = array(
                            'User',
                            'submit_author',
                            'Author',
                            'article_authors',
                            'Authors',
                            'Custom'
                        );

                        foreach ($get_email_tmpls as $tmpls) {
                                if (in_array($tmpls->stage_etmp_to, $fxd_send_to)) {
                                        $tmpls->stage_etmp_to = array(
                                            'value' => $tmpls->stage_etmp_to,
                                            'attrib' => array(
                                                'role' => '',
                                                'error_filed' => 'Send mail to'
                                            ),
                                        );
                                    } elseif (isset($user_roles[$tmpls->stage_etmp_to])) {
                                        $tmpls->stage_etmp_to = array(
                                            'value' => $tmpls->stage_etmp_to,
                                            'attrib' => array(
                                                'role' => $user_roles[$tmpls->stage_etmp_to],
                                                'error_filed' => 'Send mail to'
                                            ),
                                        );
                                    } else
                                    $tmpls->stage_etmp_to = array(
                                        'value' => $tmpls->stage_etmp_to
                                    );

                                if (!empty($tmpls->stage_etmp_cc) && ($tmpls->stage_etmp_cc != '""' && $tmpls->stage_etmp_cc != '[]')) {
                                        $tmpl_cc = json_decode($tmpls->stage_etmp_cc);
                                        $child_nodes = array();

                                        foreach ($tmpl_cc as $cc) {
                                                if ($cc == '')
                                                    continue;
                                                if (in_array($cc, $fxd_send_to)) {
                                                        $child_nodes[] = array(
                                                            'node' => 'role',
                                                            'value' => $cc,
                                                            'attrib' => array(
                                                                'role' => ''
                                                            )
                                                        );
                                                    } elseif (isset($user_roles[$cc])) {
                                                        $child_nodes[] = array(
                                                            'node' => 'role',
                                                            'value' => $cc,
                                                            'attrib' => array(
                                                                'role' => $user_roles[$cc]
                                                            )
                                                        );
                                                    }
                                            }
                                        $tmpls->stage_etmp_cc = array(
                                            'child_nodes' => $child_nodes,
                                            'attrib' => array(
                                                'json_data' => 'true',
                                            )
                                        );
                                    } else
                                    $tmpls->stage_etmp_cc = array(
                                        'value' => '""'
                                    );
                                if (!empty($tmpls->stage_etmp_bcc) && ($tmpls->stage_etmp_bcc != '""' && $tmpls->stage_etmp_bcc != '[]')) {
                                        $tmpl_bcc = json_decode($tmpls->stage_etmp_bcc);
                                        $child_nodes = array();

                                        foreach ($tmpl_bcc as $bcc) {
                                                if ($bcc == '')
                                                    continue;
                                                if (in_array($bcc, $fxd_send_to)) {
                                                        $child_nodes[] = array(
                                                            'node' => 'role',
                                                            'value' => $bcc,
                                                            'attrib' => array(
                                                                'role' => ''
                                                            )
                                                        );
                                                    } elseif (isset($user_roles[$bcc])) {
                                                        $child_nodes[] = array(
                                                            'node' => 'role',
                                                            'value' => $bcc,
                                                            'attrib' => array(
                                                                'role' => $user_roles[$bcc]
                                                            )
                                                        );
                                                    }
                                            }
                                        $tmpls->stage_etmp_bcc = array(
                                            'child_nodes' => $child_nodes,
                                            'attrib' => array(
                                                'json_data' => 'true',
                                            )
                                        );
                                    } else
                                    $tmpls->stage_etmp_bcc = array(
                                        'value' => '""'
                                    );

                                //3.1 CREATE EMAIL TEMPLATE NODE
                                $template_node = $doc->createElement('template');
                                $global = 'true';
                                if ($tmpls->stage_etmp_journal_id != '')
                                    $global = 'false';

                                $template_node->setAttribute('global', $global);

                                $this->generate_node($doc, $email_template_node, $template_node, $tmpls, TRUE);
                            }

                        //4.0 CREATE EMAIL REFERENCE NODE
                        $email_reference_node = $doc->createElement('email_reference');
                        foreach ($assoc_email_tmpls as $aetmpls) {
                                $this->generate_node($doc, $email_reference_node, 'reference', $aetmpls);
                            }

                        $root_node->appendChild($email_template_node);
                        $root_node->appendChild($email_reference_node);
                    }
                $doc->saveXML();
                $doc->save($file_location);
                //$pathToFile = $file_location;
                $filepath =  $file_location;
             
                $headers = [
                    'Content-Type: text/xml',
                ];
                return Response::download($filepath);
                // return $this->success('success', 200, $result);
            }
              
               
            

        }
        catch (\Exception $e) {
            
            return  $this->failure('Failed',500,$e);
           // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }
    }
    /*
    Import Workflow
    commited date :-  13-03-2022
    Request type :- POST
    */
    public function import_journal_advance_flow(Request $request)
    {
        try
        {
            $post_data = $request->all();
            $return_arr = array(
                'status' => 'failed'
            );
            $source = $dest =$artp_id= $flow_master_id = $path = $file_name = '';
            if(isset($post_data['import_stage_path']))
            {
            $path= decrypt_link($post_data['import_stage_path']);
            } if(isset($post_data['import_stage_filename']))
            {
            $file_name= decrypt_link($post_data['import_stage_filename']);
            }if(isset($post_data['jnl_id']))
            {
            $jnl_id= decrypt_link($post_data['jnl_id']);
            }
            if(isset($post_data['artp_id']) && !empty($post_data['artp_id']))  
            {
             $artp_id= decrypt_link($post_data['artp_id']);
            }
            if(isset($post_data['import_stage_fl_mst_id']))
            {
            $flow_master_id= decrypt_link($post_data['import_stage_fl_mst_id']);
            }if(isset($post_data['source']))
            {
                $source = $post_data['source'];
            }if(isset($post_data['desination']))
            {
                $dest = $post_data['desination'];
            }if($source != '' && $dest != '' && $flow_master_id != '' && $path != '' && $file_name != '')
            {
               
                $import_reult = $this->set_xml_in_db($path, $file_name, $flow_master_id, $jnl_id,$artp_id,TRUE,$source,$dest);
			    $return_arr = $import_reult;
            }
            return $this->success('Success',201,$return_arr);
        }catch (\Exception $e) {
            
            return  $this->failure('Failed',500,$e);
        }

    }
    public function import_journal_flow(Request $request)
    {
        try
        {
            $artp_id='';
          if(isset($request->artp_id) && !empty($request->artp_id))  
          {
             $artp_id= decrypt_link($request->artp_id);
          }
         $criteria = "jnl_id='{$request->platform_id}'";
        $jounal_data = Journals::get_single_record('*', $criteria);
        $jnl_master_id = $request->platform_flow_master_id;
        $this->current_user = $this->get_current_user_details();
        $file =  $request->workflow_file;
        $filename=$file->getClientOriginalName();
        $journal_data=Journals::get_single_record('*',"jnl_id={$request->platform_id}");
        $jnl_code = $journal_data->jnl_journal_code;
		$path ='uploads' .DIRECTORY_SEPARATOR. $jnl_code . DIRECTORY_SEPARATOR . 'temp_xml'.DIRECTORY_SEPARATOR;
      
        // Storage::disk('public')->putFileAs('avatar', $image,$name);
        //$name = '.' . $file->getClientOriginalExtension();
      //  $name = $filename . '.' . $file->getClientOriginalExtension();
        //   $name = time().'.' . explode('/', explode(':', substr($image, 0, strpos($image, ';')))[1])[1];
        Storage::disk('public')->putFileAs($path, $file, $filename);
       
        $filepath = public_path('storage/'.$path.$filename);

       // $filename = 'journal_workflow.xml';
        $import_result = $this->set_xml_in_db($filepath, $filename, $jnl_master_id,$request->platform_id,$artp_id);
        
        $more_stage_count = false;
        if(isset($import_result['more_stage_count']))
        {
            $more_stage_count = $import_result['more_stage_count'];
            unset ($import_result['more_stage_count']);
            
        }

        //Enhancement#2152 Partly import workflow
        if ((isset($this->current_user) && in_array('sudo', $this->current_user['roles'])) && $more_stage_count== TRUE)
        { 
            //$import_reult['status'] = 'append_stage';
           
            $question_html = $this->get_status_of_import($filepath, $filename, $jnl_master_id,$import_result['flow_stages']);           
            $import_data['status']='append_stage';
            $import_result['question']=$question_html;
            $import_data['import_title']= 'Import workflow settings';
            $import_result['Partly_import']=$import_data;
        }

        
            return $this->success('Success',201,$import_result);
        }
        catch (\Exception $e) {

            return  $this->failure('Failed',500,$e);
           // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }
    }
    public function get_status_of_import($xml_path, $file_name, $master_id,$review_flow)
	{
		$where = 'jwf_fwm_id = '.$master_id.' AND jwf_child_stages = \'[]\' AND jwf_stage_type NOT IN (\'transit\',\'aop_publish\',\'reject\')';
      
		$dest_jnl_flow = Generic_flows::get_all_records('jwf_stage_name,jwf_stage_type,jwf_id', $where,'jwf_id',1,'',0,NULL,'DESC');

		$source_stage = $xml_query = $des_stages = array();
        $returnvalue=array();
		// $stage_opt_html = '<div class="modal-body"><label class="text-center text-danger"><strong>'.lang('no_empty_parent').'</strong></label></div>';

		if(count($dest_jnl_flow) > 0)
		{
			$source_stage = $dest_jnl_flow[0];
			/*$child_stages = $review_flow[$source_stage->jwf_stage_type]['child_stages'];
			foreach ($child_stages as $stg)
			{
				$xml_query[] = './/stage[jwf_stage_type[contains(text(),\''.$stg.'\')]]';
			}
			*/
			$xml_query[] = './/stage[jwf_stage_type[contains(text(),\''.$source_stage->jwf_stage_type.'\')]]';
			$text = implode(' | ', $xml_query);
			$destination = $xml_path . DIRECTORY_SEPARATOR . $file_name;
			$doc = new \DOMDocument();
			$doc->formatOutput = false;
			$doc->load($xml_path);


			$xpath = new \DOMXpath($doc);
			$stage_element = $xpath->query($text);
			//echo $doc->saveXML($stage_element->item(1));die;

			for ($i = 0; $i < $stage_element->length; $i++)
			{
				$st_text = './jwf_id | ./jwf_stage_name';
				$stage = $stage_element->item($i);
				$stage_childs = $xpath->query($st_text, $stage);

				//echo $doc->saveXML($stage);die;
				//echo $doc->saveXML($stage_childs->item(0));die;

				$temp_arr = array();
				for ($j = 0; $j < $stage_childs->length; $j++)
				{
					$temp_arr[$stage_childs->item($j)->nodeName] = $stage_childs->item($j)->nodeValue;
				}
				$des_stages[] = $temp_arr;
			}
			$data = array(
				'source' => $source_stage,
				'destination' => $des_stages,
				'flow_master_id' => $master_id,
				'path'=>$xml_path,
				'filename'=>$file_name,
			);
            $returnvalue[]=$data;
			// $stage_opt_html = $this->load->view('workflow/workflow_append_opts',$data,TRUE);
		}

		return $returnvalue;
	}
    public function flow_options(Request $request)
    {
        $post_data = $request->all();
        try {
            $node_id = $this->decrypt_data($post_data['stage_id']);


            $return_arr = array();
            if (!empty($node_id)) {
                    $criteria = "jwf_id={$node_id}";
                    //load model
                    $stage_data = Generic_flows::get_single_record('jwf_id, jwf_stage_name, jwf_flow_proceed_type, jwf_stage_type,jwf_child_stages,jwf_fwm_id', $criteria);

                    $return_arr['node_data'] = $stage_data;

                    //Task 664 ICE ReView new stages
                    $button_details = array();
                    $child_stages = array();
                
                    $ch_stages = json_decode($stage_data->jwf_child_stages);
                    /*if(count($ch_stages) > 2)
			{*/
                    //2003 Changes in 'advance' flow option in workflow
                    //modification in advance workflow, if there one child stage then also enable advance flow and child stage can add in more than one button

                    $where = 'jwf_id IN (' . implode(',', $ch_stages) . ') AND jwf_hide_status!=\'y\'';
                    $child_stages = Generic_flows::get_all_records('jwf_id, jwf_stage_name', $where);
                    $advance_section = 'true';

                    //fetching button details
                    $btn_where = "afm_jwf_id={$node_id} AND afm_fwm_id={$stage_data->jwf_fwm_id}";
                    /*$btn_where = array(
					'afm_jwf_id' => $node_id,
					'afm_fwm_id' => $stage_data->jwf_fwm_id,
				);*/
                    $button_details = Advance_flow_movement::get_all_records('afm_id,afm_jwf_id,afm_associated_stage_ids,afm_button_title,afm_button_tooltip', $btn_where);
                    $return_arr['button_details'] = $button_details;
                    //}

                    $return_arr['child_stages'] = $child_stages;


                    $return_arr['advance_section'] = $advance_section;
                    $return_arr['status'] = 'success';
                    //			$return_arr['label_content'] = 'The Stage <strong>' . $this->data['node_data']->jwf_stage_name . '</strong> ' . lang('issue_flow_option_hint') . lang('issue_flow_option_msg');


                }
                $return_arr['message']=customTrans('workflow.flow_options');
                return $this->success("success",200,$return_arr);
           // $response = ['success' => true, 'message' => 'Flow options', 'result' => $return_arr];
        } catch (\Exception $e) {
            
            return  $this->failure('Failed',500,$e);
           // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }

       // return response()->json($response);
    }

    //save flow_option
    public function save_flow_option(Request $request)
    {
        try {
        $post_data = $request->all();
        $this->current_user = $this->get_current_user_details();
        $stage_id = $this->decrypt_data($post_data['stage_id']);
        $prefered_option = 'advance';
        $form_option_data = array();
        if(isset($post_data['preference_group']))
         $prefered_option=$post_data['preference_group'];
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $return_arr = array();
        if (isset($post_data['flow_option']))
            $form_option_data = $post_data['flow_option'];
        if ($stage_id != '' && $prefered_option != '') {
                $node_id = $this->decrypt_data($post_data['stage_id']);
                $condition = "jwf_id={$node_id}";

                $node_data = Generic_flows::get_single_record('jwf_fwm_id', $condition);

                $fwm_id = $node_data->jwf_fwm_id;

                $parallel_condition = TRUE;
                //* start -- checking parallel condition*//
                $where_cond = ' FIND_IN_SET(jwf_id,(select replace(replace(replace(jwf_child_stages,\']\',\'\'),\'[\',\'\'),\'"\',\'\') from ' . $generic_flow_table . ' where jwf_id = ' . $node_id . '))';
                $parallel_stags = Generic_flows::get_all_records('*', $where_cond);

                foreach ($parallel_stags as $prl_stg) {
                        if (count(json_decode($prl_stg->jwf_child_stages)) > 1 && $prefered_option == 'parallel') {
                            $return_arr['msg']= customTrans('workflow.flow_parl_err');
                            $return_arr['status'] = 'err';
                                $parallel_condition = FALSE;
                            }

                        $status = isset($review_flow[$prl_stg->jwf_stage_type]['multiple_child']) ? $review_flow[$prl_stg->jwf_stage_type]['multiple_child'] : true;
                        $id = $this->encrypt_data($prl_stg->jwf_id);
                        if ($status == false) {
                                $sql = 'select * from( select replace(replace(replace(jwf_parent_stages,\']\',\'\'),\'[\',\'\'),\'"\',\'\')  as parent,jwf_id from rvw_journal_workflows where jwf_fwm_id = ' . $prl_stg->jwf_fwm_id . ' ) dum where find_in_set(' . $prl_stg->jwf_id . ',parent)';

                                $prnt_stags = Generic_flows::get_records_by_raw_query($sql);
                                //echo $this->db->last_query(); die;
                                if (empty($prnt_stags)) {
                                        $status = true;
                                    }
                            }


                        if (count(json_decode($prl_stg->jwf_child_stages)) >= 1 && $prefered_option == 'parallel') {
                                //$hd_parent_st_add[] = encrypt_link($prl_stg->jwf_id);
                                $hd_parent_st_add[] = array('id' => $id, 'status' => $status);
                            }

                        if ($prefered_option == 'manual') {
                                //echo '<pre>'; print_r($prl_stg->jwf_stage_type); die;
                                $dy_parent_st_add[] = array('id' => $id, 'status' => $status);
                            }
                    }

                //* end -- checking parallel condition*//
                if ($parallel_condition == TRUE) {
                        $flow_proceed_type = array(
                            'jwf_stage_incomplete' => 'n',
                            'jwf_flow_proceed_type' => $prefered_option

                        );
                        $condition = "jwf_id={$node_id}";
                        $this->current_user = $this->get_current_user_details();
                        $result = Generic_flows::update_record($flow_proceed_type, $condition, $this->current_user);
                        if ($result) {
                                $condition = "afm_jwf_id={$node_id}";

                                //Task 664 ICE ReView new stages
                                Advance_flow_movement::delete_records($condition,"",$this->current_user);
                                if ($prefered_option == 'advance') {

                                        // print_r($form_option_data);exit;

                                        //   print_r($btn_option_data);
                                        $numbs = count($form_option_data);
                                        $insert_arr = array();
                                        for ($i = 0; $i <= $numbs; $i++) {



                                                $sg_ids = array();
                                                //2003 Changes in 'advance' flow option in workflow
                                                if (isset($form_option_data[$i]['advanced_flow_child_stages']) && !empty($form_option_data[$i]['advanced_flow_child_stages'])) {
                                                    if(is_array($form_option_data[$i]['advanced_flow_child_stages']))
                                                    {
                                                        $stgs = implode(',', $form_option_data[$i]['advanced_flow_child_stages']);
                                                    }
                                                    else{
                                                        $stgs =  $form_option_data[$i]['advanced_flow_child_stages'];
                                                    }
                                                        $insert_arr[] = array(
                                                            'afm_jwf_id' => $node_id,
                                                            'afm_fwm_id' => $fwm_id,
                                                            'afm_associated_stage_ids' => $stgs,
                                                            'afm_button_title' => $form_option_data[$i]['advanced_flow_btn_label'],
                                                            'afm_button_tooltip' => $form_option_data[$i]['advanced_flow_button_title'],
                                                            'afm_posted_by' =>  $this->current_user['user_id'],
                                                            'afm_proxy_id' => $this->current_user['proxy_user_id'],
                                                            'afm_operation' => "i",
                                                            'afm_posted_date' => date('Y-m-d H:i:s')
                                                        );

                                                        //  Advance_flow_movement::insert_record($btn_data);
                                                    }
                                            }
                                        if (!empty($insert_arr)) {

                                                Advance_flow_movement::insert_batch($insert_arr);
                                            }
                                    }

                                $return_arr['status'] = 'success';
                                $return_arr['msg'] = '';
                                //  $return_arr['hd_parent_st_add'] = $hd_parent_st_add;
                                //  $return_arr['dy_parent_st_add'] = $dy_parent_st_add;
                                $return_arr['stage_id'] = $node_id;
                                $return_arr['msg']= customTrans('workflow.flow_options');
                            }
                    }
            }
            
            return $this->success('success',200,$return_arr);
       // $response = ['success' => true, 'message' => 'Flow options', 'result' => $return_arr];
        }
        catch (\Exception $e) {
          
            return  $this->failure('Failed',500,$e);
           // $response = ['success' => false, 'message' => '', 'result' => $e->getMessage()];
        }    
    }
    public function check_progress_role(Request $request)
	{
        try{
            $return_array=array();
            $post_data = $request->all();
            $flmid = $post_data['flow_master_id'];
            $stage_id = $post_data['flow_id'];
            $role_id = $post_data['role_id'];
            $return_array['foundrole'] = false;
            if(!empty($role_id) && !empty($stage_id))
            {
                $condition = "jwf_id=" . $stage_id;
                $current_stage_childs = Generic_flows::get_single_record('jwf_role_id', $condition);
                

                $aflw_condition = "aflw_jwf_id={$stage_id}  AND aflw_status IN ('u','i','a') AND art_delete_status='n'";
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                $articles_table = (new \App\Models\Articles())->getTable();
                $select = 'aflw_id';
                $tables = array(
                    'main_table' => $Article_flow_table,
                    'join_table' => array(
                        $articles_table => array($Article_flow_table . '.aflw_art_id', $articles_table . '.art_id', "left")
                    )
                );
                $chk_current_active_stage = Article_flow::get_results_using_joins($tables, $select, $aflw_condition, 'all');

               // $chk_current_active_stage = Article_flow::get_all_records('aflw_id', 'aflw_jwf_id=' . $stage_id . ' AND aflw_status IN (\'u\',\'i\',\'a\')');
                if (count($chk_current_active_stage) > 0)
                {
                    if($current_stage_childs->jwf_role_id != $role_id) 
                    {
                        $return_array['foundrole'] = true;
                        $return_array['msg']= customTrans('workflow.already_inprogress_stage');
                    }
                }
            }
            return $this->success('success',200,$return_array);
        }
        catch (\Exception $e) {          
            return  $this->failure('Failed',500,$e);
        }    
    }
    //checking duplicate stage name
    public function check_stage_name(Request $request)
	{
        try{
        $post_data = $request->all();
		$stagecode = $post_data['stage_name'];
		$flmid = $post_data['flow_master_id'];
        $stage_id = isset($post_data['flow_id']) ? $post_data['flow_id']:'';
		// if ($this->input->post('current_stage') != false)
		// {
		// 	$flow_id = decrypt_link($this->input->post('current_stage'));
		// 	$condition = array(
		// 		'jwf_stage_name' => $stagecode,
		// 		'jwf_fwm_id' => $flmid,
		// 		'jwf_id !=' => $flow_id);
		// }
		// else
		// {
            
            $condition = "jwf_stage_name= ? AND jwf_fwm_id = ? ";
            $condition_arr = [
                $stagecode,
                $flmid
            ];
            if(!empty($stage_id))
            {
                $condition.="AND jwf_id!= ? "; 
                 $condition_arr[] = $stage_id ;
            }
           // $condition = "jwf_stage_name= {$stagecode} AND jwf_fwm_id = {$flmid}";
		//}
		$stage_name = Generic_flows::get_all_records('count(*) cnt', $condition, binding_arr:$condition_arr);
        if ($stage_name[0]->cnt > 0) {
            $return_array['found'] = true;
        } else {

            $return_array['found'] = false;
        }
        $return_array['msg']= customTrans('workflow.check_stage_name');
        return $this->success('success',200,$return_array);
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
	}

    //- Advance workflow delete
    public function advance_workflow_delete(Request $request)
	{
        try{
        $post_data = $request->all();
		$flow_master_id =  $post_data['flow_master_id'];
		$data = array();
		if(!empty($flow_master_id) && $flow_master_id != '')
		{
			
			$core_stages = array(
				'staff_check',
				'qulity_check', //Task #3064 Advance workflow delete
				);
			$where = 'jwf_fwm_id = '.$flow_master_id.' AND jwf_stage_type IN (\''. implode('\',\'', $core_stages).'\')';
            $stage_data = Generic_flows::get_all_records('jwf_id,jwf_stage_name',$where);
			$data['stage_data'] = $stage_data;
			$data['flow_master_id'] = $flow_master_id;
		}

        return $this->success('success',200,$data);
    } catch (\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }
	}

//- Delete workflow
    public function reset_workflow(Request $request)
    {
    //if from journal then journal flow master id / in article type then it is article type flow master id
    try{
    $post_data = $request->all();
    $this->current_user = $this->get_current_user_details();
    $opt =$post_data['options'];
    $flow_master_id = $post_data['flow_master_id'];
    $option = $opt['deloption'];
    $articleflow_table = (new \App\Models\Article_flow())->getTable();
    $genricflow_table = (new \App\Models\Generic_flows())->getTable();
    $articles_table = (new \App\Models\Articles())->getTable();
    $tblFtp = (new \App\Models\Ftp())->getTable();
    $Stage_email_tmpl_reference_tbl = (new \App\Models\Stage_email_tmpl_reference())->getTable();
    
    $stage = $post_data['stage'];
    if(!empty($flow_master_id) && $flow_master_id != '')
    {
    
    $flow_master_id = $this->decrypt_data($flow_master_id);
    $stage = $post_data['stage'];

                $tables = array(
                    'main_table' => $genricflow_table ,
                    'join_table' => array(
                        $articleflow_table => array($genricflow_table . '.jwf_id', $articleflow_table . '.aflw_jwf_id'),
                        $articles_table => array($articleflow_table . '.aflw_art_id', $articles_table . '.art_id')
                    )
                );

            $select = 'count(jwf_id) as cnt';
            $condition = 'jwf_fwm_id = '.$flow_master_id;
            $condition_check = 'art_delete_status=\'n\' AND jwf_fwm_id = '.$flow_master_id;
            if($option == 'a')
            {
                $condition_new = 'jwf_id ='.$stage.' AND jwf_fwm_id = '.$flow_master_id.'';
                $stage_data = Generic_flows::get_single_record('jwf_parent_stages,jwf_child_stages',$condition_new);
                $st_childs = array();
                if(!empty($stage_data))
                {

                    $st_childs = json_decode($stage_data->jwf_child_stages);
                    if(count($st_childs)>0)
                    {
                    $condition .= ' AND jwf_id IN ('. implode(',',$st_childs).')';
                    }
                    else{
                        $return_arr['msg'] = customTrans('workflow.no-child-stages');
                        return $this->warning('warning',200,$return_arr,'warning');
                      
                    }
                    
                }
            }

            $flow_usered = Article_flow::get_results_using_joins($tables,$select, $condition_check,'single');
            
            if($flow_usered->cnt == 0)
            {
                $update_data = array();
                $del_flow_movement = 'afm_fwm_id = '.$flow_master_id;
                if($option == 'a')
                {
           
                    if(in_array($stage,$st_childs))
                    {
                        $tmp = array_search($stage,$st_childs);
        
                        if(isset($st_childs[$tmp]))
                            unset($st_childs[$tmp]);
                    }

                    $del_stages = $this->get_child_stages($st_childs,array());
                    $source_id = array_search($stage, $del_stages);
                    if($source_id !== FALSE)
                        unset($del_stages[$source_id]);

                    $st_parents = json_decode($stage_data->jwf_parent_stages);
                    $exist_childs_as_parent = array_intersect($st_parents,$del_stages);
                    if(count($exist_childs_as_parent) > 0)
                    {
                        foreach ($exist_childs_as_parent as $key => $val)
                        {
                            if(isset($st_parents[$key]))
                                unset($st_parents[$key]);
                        }
                        $update_data['jwf_parent_stages'] = json_encode($st_parents);
                    }

                    $exp_ids = implode(',', $del_stages);
                    $condition = 'jwf_fwm_id = '.$flow_master_id.' AND jwf_id IN ('. $exp_ids.')';
                    $del_flow_movement .=' AND afm_jwf_id IN ('.$exp_ids.')';
                    $update_cnd = 'jwf_fwm_id ='. $flow_master_id.' AND jwf_id = '.$stage.'';
                    $associate_tb_del_cnd = $exp_ids;
                }
                else
                {
                    $condition .= ' AND jwf_stage_type NOT IN (\'author_submission\',\'transit\')';
                    $update_cnd = 'jwf_fwm_id ='. $flow_master_id.' AND jwf_stage_type = "author_submission"';
                    $associate_tb_del_cnd = "SELECT jwf_id FROM {$genricflow_table}  WHERE $condition";
                }
                //delete withraw articles article flow tables
                $tables1 = array(
                    'main_table' => $genricflow_table ,
                    'join_table' => array(
                        $articleflow_table => array($genricflow_table . '.jwf_id', $articleflow_table . '.aflw_jwf_id'),
                        $articles_table => array($articleflow_table . '.aflw_art_id', $articles_table . '.art_id')
                    )
                );
                $select1 = 'aflw_id,aflw_jwf_id';
                $condition_check1 = 'art_delete_status!=\'n\' AND jwf_fwm_id = '.$flow_master_id;
                $flow_ids = Article_flow::get_results_using_joins($tables1,$select1, $condition_check1,'all');
               if(!empty($flow_ids) && count($flow_ids) > 0)
               {
                foreach ($flow_ids as $stg_flowid) {
                   $condition_articleflow = 'aflw_jwf_id = '.$stg_flowid->aflw_jwf_id.' AND aflw_id='.$stg_flowid->aflw_id.'';
                   Article_flow::delete_records($condition_articleflow,'', $this->current_user);
                }
               }
    
                //delete ftp
               $sql = "DELETE FROM {$tblFtp}  WHERE ftp_jwf_id IN ($associate_tb_del_cnd)";
                // print_r($sql);exit;
                Ftp::execute_query($sql);


                // //delete Stage_email_tmpl_reference
                $sql1 = "DELETE FROM {$Stage_email_tmpl_reference_tbl}  WHERE setr_jwf_id IN ($associate_tb_del_cnd)";
                 Stage_email_tmpl_reference::execute_query($sql1);

                // //delete advance flow movement
              Advance_flow_movement::delete_records($del_flow_movement,'', $this->current_user);

                //delete journal flow
                Generic_flows::delete_records($condition,'', $this->current_user);
                // //update journal flow
                $update_data['jwf_child_stages'] = '[]';
              Generic_flows::update_record($update_data,$update_cnd,$this->current_user);
        
                    $return_arr['status'] = 'success';
                
            }
            else
            {
                $return_arr['status'] = 'flow_used';
                $return_arr['msg'] =  customTrans('workflow.flow_used');
            }

         } return $this->success('Flow options',200,$return_arr);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
        }
    


//get child stages in delete workflow
public function get_child_stages($stages,$main_arr)
{
    $st_childs = $stages;
    $main_arr = array_unique(array_merge($st_childs,$main_arr));
    if(count($st_childs) > 0)
    {
        $condition = ' jwf_id IN ('. implode(',',$st_childs).')';
        $stage_data = Generic_flows::get_all_records('jwf_id,jwf_child_stages',$condition);
        if(count($stage_data) > 0)
        {

            $temp = array();
            foreach ($stage_data as $stage_datum)
            {
                $st_childs = json_decode($stage_datum->jwf_child_stages);
                $exist_childs = array_intersect($st_childs,$main_arr);

                if(count($exist_childs) > 0)
                {
                    foreach ($exist_childs as $key => $val)
                    {
                        unset($st_childs[$key]);
                    }
                   
                }

                $temp = array_merge($st_childs,$temp);
            }

            if(count($temp) > 0)
            {
                $main_arr = $this->get_child_stages($temp,$main_arr);
            }
        }
    }

    return $main_arr;
}
    public function update_flow_status(Request $request)
    {
        try {
            $returnArr = array(
                'status' => 'error'
            );
            $post_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $stageid = $this->decrypt_data($post_data['stageid']);
            $task = $post_data['task'];
            if (!empty($task) && !empty($stageid))
		    {
                $disable_status = '';
			if ($task == 'enable')
			{
				$disable_status = 'n';
			}
			elseif ($task == 'disable')
			{
				$disable_status = 'y';
			}
			$result = FALSE;
            if ($disable_status == 'y')
			{
                $rev_cnd = 'aflw_status IN ("p","a","w","u") AND aflw_jwf_id ='.$stageid;
                $stage_check = Article_flow::get_single_record('aflw_id',$rev_cnd);
                if(empty($stage_check))
                {
                if ($this->check_stage_disabled($stageid))
				{
                    $flow_disble = array(
                        'jwf_disable_status' => $disable_status

                    );
                    $condition = "jwf_id={$stageid}";
                    $result = Generic_flows::update_record($flow_disble, $condition, $this->current_user);
				}else
                {
                    $returnArr['status'] = 'restrict'; 
                }
                }
				else
				{
					$returnArr['status'] = 'restrict';
				}
                

            }else
			{
                $flow_disble = array(
                    'jwf_disable_status' => $disable_status

                );
                $condition = "jwf_id={$stageid}";
                $result = Generic_flows::update_record($flow_disble, $condition, $this->current_user);
				
			}if ($result)
			{
				$returnArr['status'] = 'success';
			}

            }
            return $this->success('success',200,$returnArr);
        }catch (\Exception $e) {
           
            return $this->failure('Failed', 500, $e);
        }


    }
    public function check_stage_disabled($stageId)
	{
        $return = FALSE;
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $stage_conditions = "jwf_id={$stageId}";
        $stage_details = Generic_flows::get_single_record('jwf_stage_type,jwf_parent_stages,jwf_child_stages',$stage_conditions);
        if ($stage_details != NULL)
        {
            if (isset($review_flow[$stage_details->jwf_stage_type]['disable_criteria']))
            {
                $disable_criteria = $review_flow[$stage_details->jwf_stage_type]['disable_criteria'];
                $parent_stages = $this->get_enabled_parent($stageId, $stage_details->jwf_parent_stages);
                $child_stages = $this->get_enabled_child($stageId, $stage_details->jwf_child_stages);
                if (!$this->restrict_multiple_childs($parent_stages, $child_stages, $review_flow))
                {
                    if (count($disable_criteria) == 0)
					{
						$return = TRUE;
					}else
					{
                        $parent_stage = array();
                        foreach ($parent_stages as $parent)
						{
							if ($parent->jwf_disable_status == 'n')
								$parent_stage[] = $parent->jwf_stage_type;
						}

                        $child_stage = array();
						foreach ($child_stages as $child)
						{
							if ($child->jwf_disable_status == 'n')
								$child_stage[] = $child->jwf_stage_type;
						}

                        $workflow_before_criteria = $disable_criteria['before'];
						$workflow_after_criteria = $disable_criteria['after'];
						$workflow_and_condition = $disable_criteria['and'];
                        $isParentSubset = $this->issubsets($parent_stage, $workflow_before_criteria);
						$isChildSubset = $this->issubsets($child_stage, $workflow_after_criteria);

                        if ($workflow_and_condition)
                        {
                            if ($isParentSubset == 1 && $isChildSubset == 1)
                                $return = TRUE;
                        }
                        else
                        {
                            if ($isParentSubset == 1 || $isChildSubset == 1)
                                $return = TRUE;
                        }

                    }

                }
            }
        }
        return $return;

    }
    public function issubsets($childarray, $parentarray)
	{
		if (count($parentarray) == 0)
		{
			$valid = 1;
			return $valid;
		}
		else
		{
			$c = count($childarray);
			$valid = 1;
			for ($i = 0; $i < $c; $i++)
			{
				if (!in_array($childarray[$i], $parentarray))
				{
					$valid = 0;
					return $valid;
				}
				return $valid;
			}
		}
	}
    public function restrict_multiple_childs($parent_stages, $child_stages, $review_flow)
    {
        $return = FALSE;
        if (count($child_stages) > 1)
		{
			//print_r($parent_stages);
			foreach ($parent_stages as $parent)
			{
				if (isset($review_flow[$parent->jwf_stage_type]['multiple_child']) && !$review_flow[$parent->jwf_stage_type]['multiple_child'])
				{
					//echo 'fhfghg-'.$review_flow[$parent->jwf_stage_type]['multiple_child'];
					$return = TRUE;
					break;
				}
			}
		}
		return $return;
    }
    public function get_enabled_parent($stageId, $parent_stages)
    {
        $return = array();
        $getParentStages = Generic_flows::get_stage_decisions($stageId, json_decode($parent_stages));
        if (count($getParentStages) == 1) {
            if ($getParentStages[0]->jwf_disable_status == 'y') {
                $return = $this->get_enabled_parent($getParentStages[0]->jwf_id, $getParentStages[0]->jwf_parent_stages);
            }else {
                //$return[] = $getParentStages[0]->jwf_stage_type;
                $return[] = $getParentStages[0];
            }
        }else {
            foreach ($getParentStages as $getParentStage) {
                /* if ($getParentStage->jwf_disable_status == 'n')
                  { */
                //$return[] = $getParentStage->jwf_stage_type;
                $return[] = $getParentStage;
                //}
            }

        }
        return $return;

    }
    public function get_enabled_child($stageId, $child_stages,$rescind = FALSE)
    {
        $return = array();
        $getChildStages = Generic_flows::get_stage_decisions($stageId, json_decode($child_stages));
        if (count($getChildStages) == 1 && $rescind == FALSE) {
            if ($getChildStages[0]->jwf_disable_status == 'y') {
                $return = $this->get_enabled_child($getChildStages[0]->jwf_id, $getChildStages[0]->jwf_child_stages);
            }else {
                //$return[] = $getChildStages[0]->jwf_stage_type;
                $return[] = $getChildStages[0];
            }
        }else {
            foreach ($getChildStages as $getChildStage) {
                /* if ($getChildStage->jwf_disable_status == 'n')
                  { */
                //$return[] = $getChildStage->jwf_stage_type;
                $return[] = $getChildStage;
                //}
            }
        }
        return $return;

    }
    public function stage_hide(Request $request)
    {
        try {
            $post_data = $request->all();
            $this->current_user = $this->get_current_user_details();
            $stage_id = $this->decrypt_data($post_data['stage']);
            /*
		 * 1 Fetch delete stage flow details
		 */
            $stage_condition = "jwf_id={$stage_id}";
            $node = Generic_flows::get_single_record('jwf_id, jwf_fwm_id, jwf_parent_stages, jwf_child_stages', $stage_condition);
            $response = array(
                'status' => 'error'
            );
          
            // Generic_flows::trans_start();
            $aflw_condition = "aflw_jwf_id={$stage_id}";
            //$aflw_id = Article_flow::get_all_records('aflw_id,aflw_status', $aflw_condition);
            $Article_flow_table = (new \App\Models\Article_flow())->getTable();
            $articles_table = (new \App\Models\Articles())->getTable();
            $select = 'aflw_id,aflw_status,art_delete_status';
            $tables = array(
                'main_table' => $Article_flow_table,
                'join_table' => array(
                    $articles_table => array($Article_flow_table . '.aflw_art_id', $articles_table . '.art_id', "left")
                )
            );

            $aflw_id = Article_flow::get_results_using_joins($tables, $select, $aflw_condition, 'all');
            $result = array();
            $flow_meta = '';
            $hid_stage_display = FALSE;
            $hid_stage_display_arr = array();
            $p_data_arr = array();
            $msg = customTrans('workflow.stg_del');
            $delete_status= array("w","y");
            if (!empty($aflw_id[0]->aflw_id)) {
                    $in_prgs_found = FALSE;
                    foreach ($aflw_id as $single_flow) {
                            if ($single_flow->aflw_status !== 'c' && !in_array($single_flow->art_delete_status,$delete_status)) {
                                    $in_prgs_found = TRUE;
                                    break;
                                }
                        }
                    if ($in_prgs_found == TRUE) {
                            $response = array(
                                'status' => 'error',
                                'flow_meta' => ''
                            );
                            $msg = customTrans('workflow.stg_hide');
                        } else {
                            $mng_parent_ids_arr = json_decode($node->jwf_parent_stages);
                            $flow_meta = $this->stage_flow_anomalies($mng_parent_ids_arr, $node->jwf_fwm_id);

                            // ICE ReView new stages
                            $this->manage_stage_advance_flow_connection($mng_parent_ids_arr, $stage_id);
                            $update_condition = "";
                            $result = Generic_flows::update_record(array(
                                'jwf_hide_status' => 'y'
                            ), $stage_condition,$this->current_user);
                            $msg = '';
                        }
                } else {

                    $mng_parent_ids_arr = json_decode($node->jwf_parent_stages);
                    $child_ids_arr = json_decode($node->jwf_child_stages);

                    //remove deleted record from the parent stage
                    for ($i = 0; $i < count($mng_parent_ids_arr); $i++) {
                            $parent_condition = "jwf_id={$mng_parent_ids_arr[$i]} AND jwf_fwm_id ={$node->jwf_fwm_id}";

                            $parent_details = Generic_flows::get_single_record('jwf_id, jwf_child_stages', $parent_condition);
                            $parent_childs = array();
                            if (($parent_details->jwf_child_stages != NULL) && count(json_decode($parent_details->jwf_child_stages)) > 0) {
                                    $parent_childs = json_decode($parent_details->jwf_child_stages);
                                }

                            if (($key = array_search($stage_id, $parent_childs)) !== FALSE) {
                                    unset($parent_childs[$key]);
                                }

                            $parent_childs = array_unique($parent_childs);
                            $updated_details_parent = array(
                                'jwf_child_stages' => json_encode(array_values($parent_childs))
                            );

                            $update_condition = "jwf_id={$parent_details->jwf_id}";
                            Generic_flows::update_record(
                                $updated_details_parent,
                                $update_condition,$this->current_user
                            );
                        }
                    //remove deleted record from the child stage
                    for ($i = 0; $i < count($child_ids_arr); $i++) {
                            //need to update parent
                            $parent_condition = "jwf_id={$child_ids_arr[$i]} AND jwf_fwm_id={$node->jwf_fwm_id}";
                            $child_details = Generic_flows::get_single_record('jwf_id, jwf_parent_stages', $parent_condition);
                            $child_parent = array();
                            if(!empty($child_details))
                            {
                            if (($child_details->jwf_parent_stages != NULL) && count(json_decode($child_details->jwf_parent_stages)) > 0) {
                                    $child_parent = json_decode($child_details->jwf_parent_stages);
                                }
                            }
                            if (($key = array_search($stage_id, $child_parent)) !== FALSE) {
                                    unset($child_parent[$key]);
                                }
                            $child_parent = array_unique($child_parent);
                            $updated_details_child = array(
                                'jwf_parent_stages' => json_encode(array_values($child_parent))
                            );
                            $updated_details_condition = "jwf_id=$child_details->jwf_id";
                            Generic_flows::update_record(
                                $updated_details_child,
                                $updated_details_condition,$this->current_user
                            );
                        }
                    // ICE ReView new stages
                    $this->manage_stage_advance_flow_connection($mng_parent_ids_arr, $stage_id);

                    $con = "jwf_id={$stage_id}";
                    $result = Generic_flows::delete_records($con, '', $this->current_user);
                    $msg = '';

                    $flow_meta = $this->stage_flow_anomalies($mng_parent_ids_arr, $node->jwf_fwm_id);
                }
                
            if (isset($flow_meta) && isset($flow_meta['issues_btn']) && !empty($flow_meta['issues_btn'])) {
                    $pri_data = $this->decrypt_data($flow_meta['issues_btn'][0]);
                    $jwf_con = "jwf_id={$pri_data}";
                    $c_details = Generic_flows::get_single_record('jwf_id, jwf_child_stages', $jwf_con);
                    if(!empty($c_details))
                    {
                    $chi_ids_arr = json_decode($c_details->jwf_child_stages);

                    for ($i = 0; $i < count($chi_ids_arr); $i++) {
                            if (!empty($chi_ids_arr)) {
                                    $stg_condition = "jwf_id={$chi_ids_arr[$i]}";
                                    $current_stage_data = Generic_flows::get_single_record('jwf_id, jwf_stage_type, jwf_parent_stages, jwf_child_stages', $stg_condition);

                                    $p_data = $this->encrypt_data($chi_ids_arr[$i]);
                                    // $hid_stage_display=$this->get_delete_status($current_stage_data->jwf_parent_stages,$current_stage_data->jwf_child_stages);

                                    array_push($p_data_arr, $p_data);
                                    // array_push($hid_stage_display_arr, $hid_stage_display);
                                }
                        }
                    }
                } else {
                    //if the child for a stage exist then remove that
                    if (!empty($flow_meta['single_child_stages']) && isset($child_parent)) {
                            array_push($p_data_arr, $this->encrypt_data($child_parent[0]));
                            array_push($hid_stage_display_arr, false);
                        }
                }

            if ($result) {
                    $response = array(
                        'status' => 'success',
                        'flow_meta' => $flow_meta,
                        'msg' => $msg,
                        'hid_stage_display' => $hid_stage_display_arr,
                        'p_data' => $p_data_arr
                    );
                }
            //}
            // if ($response['status'] == 'error' || Generic_flows::trans_complete() === FALSE)
            if ($response['status'] == 'error') {
                    $response = array(
                        'status' => 'error',
                        'flow_meta' => $flow_meta,
                        'msg' => $msg
                    );
                }
            return $this->success('success', 200, $response);
        } catch (\Exception $e) {
            return $this->failure('Failed', 500, $e);
        }
    }

}
