<?php
namespace App\Http\Controllers\Platform;

use App\Http\Controllers\Controller;
use App\Models\Article_types;
use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\Stage_email_templates;
use App\Models\Stage_email_tmpl_reference;
use App\Models\Generic_flows;
use App\Models\Journals;
use App\Models\Generic_forms;
use App\Models\Generic_form_elements;
use App\Models\General_permission;
use Config;
use DB;
use Illuminate\Support\Str;

class Manage_Workflow_Stage_Email_Templates extends Controller
{
    /*
    get workflow stage email template
    commited date :-  17-04-2022
    Request type :- POST
    */
    public function get_workflow_stage_templates(Request $request)
    {
        try {
            $stage_id =$request['stage_id'];
            $core_stage_type = $request['coretype'];
            $this->current_user = $this->get_current_user_details();
            $jnl_id =$request->jnl_id;
        
            if (!empty($stage_id) && !empty($core_stage_type)) {
                $stage_id = $this->decrypt_data($stage_id);
                $empty_send_to = array(); //empty send to tmpls



                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);
                $reviewflow = $review_flow[$core_stage_type];

                $where = 'stage_etmp_stage_type ="' . $core_stage_type . '"';

                if ($this->current_client->modules->mdl_orcid == 'n' || ($this->current_client->modules->mdl_orcid == 'y' && (!isset($reviewflow['enable_orcid_confirm']) || $reviewflow['enable_orcid_confirm'] == FALSE))) {
                    (!empty($where)) ? $where .= ' AND ' : '';
                    $where .= ' stage_etmp_action != "confirm_orcid"';
                }
                if ($this->current_client->modules->mdl_casrai_credit == 'n' || ($this->current_client->modules->mdl_casrai_credit == 'y' && (!isset($reviewflow['enable_casrai_credits_confirm']) || $reviewflow['enable_casrai_credits_confirm'] == FALSE))) {
                    (!empty($where)) ? $where .= ' AND ' : '';
                    $where .= ' stage_etmp_action != "confirm_casrai"';
                }
                $stage_email_template_table = (new \App\Models\Stage_email_templates())->getTable();
                $stage_email_tmpl_reference_table = (new \App\Models\Stage_email_tmpl_reference())->getTable();

                $sql = "SELECT stage_etmp_id,stage_etmp_name,stage_etmp_action,stage_etmp_journal_id,stage_etmp_to FROM {$stage_email_template_table} ";
                $condition = "WHERE(stage_etmp_journal_id IS NULL OR stage_etmp_journal_id ={$jnl_id}) AND stage_etmp_id NOT IN(SELECT setr_stage_etmp_id FROM {$stage_email_tmpl_reference_table} WHERE setr_jwf_id ={$stage_id}) AND {$where} ";
                $main_sql = "{$sql}{$condition}";
                //   echo $main_sql;exit;
                $get_usable_tmpls = Stage_email_tmpl_reference::get_records_by_raw_query($main_sql);
                    // $get_usable_tmpls = Stage_email_tmpl_reference::get_results_using_joins($tables, 'stage_etmp_id, stage_etmp_name, stage_etmp_action, stage_etmp_journal_id, stage_etmp_to', $where, 'all');
                ;
                $avail_tmpls_html = '';
                $assoc_tmpls_html = '';
                $is_super_admin = FALSE;

                $condition = "permission_route='email-templates'";
                $permission_roles = General_permission::get_single_record('permission_roles', $condition);
                $permission_roles = json_decode($permission_roles->permission_roles);
                $manage_roles=$this->convert_string_array($this->current_user['roles']);
                if ((!empty($permission_roles) && !empty(array_intersect($permission_roles, $manage_roles))) || in_array('sudo', $manage_roles))
                    $is_super_admin = TRUE;

                $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                $review_flow  = Config::get($workflow_config);
                $possible_actions = $review_flow[$core_stage_type]['possible_email_tmpl_actions'];

                if (!empty($get_usable_tmpls)) {

                    foreach ($get_usable_tmpls as $usable_tmpls) {
                        $usable_tmpls->is_super_admin = $is_super_admin;
                        if (array_key_exists($usable_tmpls->stage_etmp_action, $possible_actions)) {
                            $usable_tmpls->stage_etmp_action = $possible_actions[$usable_tmpls->stage_etmp_action];
                            $email_recipent = TRUE;
                            if ($usable_tmpls->stage_etmp_to == '') {
                                $empty_send_to[] = $usable_tmpls->stage_etmp_name;
                                $email_recipent = FALSE;
                            }
                            $usable_tmpls->email_recipent = $email_recipent;
                            // $avail_tmpls_html .= $this->load->view('workflow/stage_email_templates/tmpl_workflow_email_template', $usable_tmpls, TRUE);
                        }
                    }
                } else {
                    $message = 'No email template(s) found.';
                }

                //get stage associated templates
                if ($stage_id != NULL)
                    $where .= " AND setr_jwf_id={$stage_id}";

                $tables = array(
                    'main_table' => $stage_email_template_table,
                    'join_table' => array(
                        $stage_email_tmpl_reference_table => array($stage_email_template_table . '.stage_etmp_id', $stage_email_tmpl_reference_table . '.setr_stage_etmp_id')
                    )
                );
                $get_associated_tmpls = Stage_email_tmpl_reference::get_results_using_joins($tables, 'stage_etmp_id, stage_etmp_name, stage_etmp_action, stage_etmp_journal_id, stage_etmp_to', $where, 'all');
                // print_r($get_associated_tmpls);exit;
                if (!empty($get_associated_tmpls)) {

                    foreach ($get_associated_tmpls as $asoc_tmpl) {
                        $asoc_tmpl->is_super_admin = $is_super_admin;
                        if (array_key_exists($asoc_tmpl->stage_etmp_action, $possible_actions)) {
                            $asoc_tmpl->stage_etmp_action = $possible_actions[$asoc_tmpl->stage_etmp_action];
                            if ($asoc_tmpl->stage_etmp_to == '')
                                $empty_send_to[] = $asoc_tmpl->stage_etmp_name;
                            // $assoc_tmpls_html .= $this->load->view('workflow/stage_email_templates/tmpl_workflow_assoc_email_tmpl', $asoc_tmpl, TRUE);
                        }
                    }
                } else {
                    $assoc_tmpls_html = 'No email template(s) found.';
                }
                $return_arr['is_super_admin'] =  $is_super_admin;
                $return_arr['avail_tmpls'] =  $get_usable_tmpls;
                $return_arr['assoc_tmpls'] = $get_associated_tmpls;
                $return_arr['empty_send_to_tmpls'] = '';
                if (!empty($empty_send_to))
                    $return_arr['empty_send_to_tmpls'] = 'Please update Sent email to of email templates : ' . implode(', ', $empty_send_to);
                //athira -- start
                //$all_tags = $this->stage_email_tmpl_tags($jnl_id, $article_type_id, $core_stage_type);
                //  $return_arr['article_tags'] = $all_tags['article_tags'];
                //   $return_arr['generic_form_element_tags'] = $all_tags['generic_form_element_tags'];
                //--end
                $return_arr['status'] = 'success';
                $return_arr['msg'] = '';


                return  $this->success('Success',200,$return_arr);
       
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
    
      /*
    Assign Associate Email Template
    commited date :-  19-04-2022
    Request type :- POST
    */

    public function associate_stage_template(Request $request)
    {
        try {
            $post_data = $request->all();

            $this->current_user = $this->get_current_user_details();
            $tmpl_id = array_unique($post_data['template_ids']);
            $stage_id = $this->decrypt_data($post_data['stage_id']);
            $manage_roles=$this->convert_string_array( $this->current_user['roles']);
            $artpid = isset($post_data['artpid']) ? decrypt_link($post_data['artpid']) : '';
            $review_method=$post_data['review_method'];
            $Stage_email_templates = new \App\Models\Stage_email_templates;

            if (!empty($tmpl_id) && !empty($stage_id)) {
                    $insert_arr = array();
                    $time = date('Y-m-d H:i:s', time());
                    foreach ($tmpl_id as $t_id) {
                            $insert_arr[] = array(
                                'setr_jwf_id' => $stage_id,
                                'setr_stage_etmp_id' => $t_id,
                                'setr_posted_date' => $time,
                                'setr_posted_by' => $this->current_user['user_id'],
                                'setr_proxy_id' => $this->current_user['proxy_user_id'],
                                'setr_operation' => 'i'
                            );
                            $stage_email = $Stage_email_templates::get_single_record('stage_etmp_content', "stage_etmp_id={$t_id}");
                            $author_tags=array_keys($this->email_templates_config()['author_tags']);
                            $article_tags=array('REVIEW_ACCEPT_DATE',
                            'RESCIND_REVIEW_REASON',
                            'REOPEN_REASON');
                            $author_tags_contains = [];
                            $reviewer_tags_contains = [];
                        if(Str::contains($stage_email->stage_etmp_content, $author_tags)){
                            $author_tags_contains[] = true;

                        } 
                        if(Str::contains($stage_email->stage_etmp_content, $author_tags)){
                            $reviewer_tags_contains[] = true;

                        } 
                        }
                        $tags_contain_corresponding_author=false;
                        if(Str::contains('1', $author_tags_contains)){
                            $tags_contain_corresponding_author =true;
                                                } 
                        $Article_type_advance_options = new \App\Models\Article_type_advance_options;
                        $Articles = new \App\Models\Articles;
                        $Article_flow = new \App\Models\Article_flow();
                        $Generic_flows = new \App\Models\Generic_flows();
                        $Roles = new \App\Models\Roles();
                       if($artpid!=''){
                        $jnl_code = (new Article_types)->with('journals')->find($artpid)->journals->jnl_journal_code;
                        $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$artpid}");
                        $flowdetails = $Generic_flows::get_single_record('jwf_role_id', "jwf_id={$stage_id}");
                        $core_role_details  =   $Roles::get_single_record('role_assigned_role',"role_id={$flowdetails->jwf_role_id}");
                        if($tags_contain_corresponding_author==true&& $artp_settings->atotp_review_method=='d'&&$review_method==false){
                            if($core_role_details->role_assigned_role=='reviewer')
                           { $return_arr['msg'] = " A double-blind process is underway. Avoid linking email templates with author-related tags for emails that will be sent to reviewers.";
                            return  $this->warning('Warnings',200,$return_arr,'warning');
                        }
                        if($core_role_details->role_assigned_role=='author')
                        { $return_arr['msg'] = "A double-blind process is underway. Avoid linking email templates with reviewer-related tags for emails that will be sent to authors.";
                            return  $this->warning('Warnings',200,$return_arr,'warning');
                    }                 
                                           }                   
                    }
                    if($artpid!=''){
                        
                    if($artp_settings->atotp_review_method=='s'&&$core_role_details->role_assigned_role=='author'&&$review_method==false){
                        $return_arr['msg'] = "A single-blind process is underway. Avoid linking email templates with reviewer-related tags for emails that will be sent to authors.";
                    
                    return  $this->warning('Warnings',200,$return_arr,'warning');
                    }
                    // if($this->is_custom_blinded($jnl_code, $artp_settings, 'author', ['reviewer' => $core_role_details->role_assigned_role == 'reviewer'])){
                    //     $return_arr['msg'] = "The reviewer is blinded towards author. Avoid linking email templates with author-related tags for emails that will be sent to reviewers.";
                    //     return  $this->warning('Warnings',200,$return_arr,'warning');

                    // }elseif($this->is_custom_blinded($jnl_code, $artp_settings, 'author', ['author' => $core_role_details->role_assigned_role == 'author'])){
                    //     $return_arr['msg'] = "The author is blinded reviewer author. Avoid linking email templates with reviewer-related tags for emails that will be sent to authors.";
                    //     return  $this->warning('Warnings',200,$return_arr,'warning');
                    // }
                        }


                    if (!empty($insert_arr)) {

                            $result = Stage_email_tmpl_reference::insert_batch($insert_arr);

                            if ($result > 0) {
                                    $return_arr['status'] = 'success';
                                    $return_arr['msg'] = 'associate email success';
                                    $assoc_tmpls_array = '';

                                    $usr_condition ="jwf_id={$stage_id}";
                                    $user_details = array(
                                        'jwf_import_email_form_err' => null
                                    );
                                    $updated_result = Generic_flows::update_record($user_details,$usr_condition,$this->current_user);
                                    $record = Stage_email_templates::get_all_records('stage_etmp_id,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_journal_id', 'stage_etmp_id IN(' . implode(',', $tmpl_id) . ')');

                                    $is_super_admin = FALSE;
                                    $condition = "permission_route='email-templates'";
                                    $permission_roles = General_permission::get_single_record('permission_roles', $condition);
                                    $permission_roles = json_decode($permission_roles->permission_roles);
                                    if ((!empty($permission_roles) && !empty(array_intersect($permission_roles, $manage_roles))) || in_array('sudo', $manage_roles))
                                        $is_super_admin = TRUE;
                                    $return_arr['remove_class_import_err'] = '';

                                    if (!empty($record)) {

                                            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                                            $review_flow  = Config::get($workflow_config);
                                            $possible_actions = $review_flow[$record[0]->stage_etmp_stage_type]['possible_email_tmpl_actions'];

                                            foreach ($record as $r) {
                                                    $r->is_super_admin = $is_super_admin;
                                                    $r->stage_etmp_action = $possible_actions[$r->stage_etmp_action];
                                                    //$assoc_tmpls_html .= $this->load->view('workflow/stage_email_templates/tmpl_workflow_assoc_email_tmpl', $r, TRUE);
                                                }
                                        }
                                    $return_arr['assoc_tmpls_array'] = $record;
                                    return  $this->success('Success',200,$return_arr);
                            
                                } else {
                                    $return_arr['msg'] = "failed";

                                    return  $this->warning('Failed',500,$return_arr);
                               
                                }
                        }
                } else {
                    $return_arr['msg'] = "No email template selected";
                    return  $this->warning('Failed',500,$return_arr);
                  
                }
        } catch (\Exception $e) {
            return  $this->failure('Failed',500);
        }
    }
     /*
    Dissociate  Email Template
    commited date :-  19-04-2022
    Request type :- POST
    */
    public function delete_workflow_stage_email(Request $request)
    {
        try {
            $this->current_user = $this->get_current_user_details();
            $post_data = $request->all();
            $email_tmpl_id = $this->decrypt_data($post_data['email_tmpl_id']);
            $stage_id = $this->decrypt_data($post_data['stage_id']);
            $return_arr['status'] = 'failed';
            $return_arr['msg'] = 'failed';
            if (!empty($email_tmpl_id))
			{
                $crietria = "setr_stage_etmp_id={$email_tmpl_id} ";
                $is_used_tmpl = Stage_email_tmpl_reference::get_single_record('COUNT(setr_id) as cnt', $crietria);
                if ($is_used_tmpl->cnt > 0)
				{
                    $return_arr['status'] = 'failed';
                    $return_arr['msg'] = 'Email template cannot be deleted as it is currently in use.';
                }else{
                    $crietria1 = "stage_etmp_id={$email_tmpl_id} ";
                    Stage_email_templates::delete_records( $crietria1, '', $this->current_user);
					$return_arr['status'] = 'success';
					$return_arr['msg'] = 'Email template deleted';

                }
                return  $this->success('Success',200,$return_arr); 
            }
        }catch (\Exception $e) {
            return  $this->failure('Failed',500,$return_arr);
        }
    }
    public function dissociate_stage_template(Request $request)
    {

        try {
            $post_data = $request->all();

            $this->current_user = $this->get_current_user_details();
            $stage_id = $post_data['stage_id'];
            $email_tmpl_id = $post_data['email_tmpl_id'];
            $manage_roles=$this->convert_string_array( $this->current_user['roles']);
            if (!empty($email_tmpl_id) && !empty($stage_id)) {

                    $stage_id = $this->decrypt_data($stage_id);
                    $crietria = "setr_jwf_id={$stage_id} AND setr_stage_etmp_id={$email_tmpl_id}";
                    $result = Stage_email_tmpl_reference::delete_records($crietria, '', $this->current_user);

                    $return_arr['status'] = 'success';
                    $return_arr['msg'] = 'dissoc_tmpl_success';

                    $condition = "stage_etmp_id={$email_tmpl_id}";
                    $record = Stage_email_templates::get_single_record('stage_etmp_id,stage_etmp_name,stage_etmp_stage_type,stage_etmp_action,stage_etmp_journal_id,stage_etmp_to', $condition);

                    $is_super_admin = FALSE;

                    $condition = "permission_route='email-templates'";
                    $permission_roles = General_permission::get_single_record('permission_roles', $condition);
                    $permission_roles = json_decode($permission_roles->permission_roles);
                    if ((!empty($permission_roles) && !empty(array_intersect($permission_roles, $manage_roles))) || in_array('sudo', $manage_roles))
                        $is_super_admin = TRUE;
                    $return_arr['remove_class_import_err'] = '';

                    if (!empty($record)) {


                            $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
                            $review_flow  = Config::get($workflow_config);
                            $possible_actions = $review_flow[$record->stage_etmp_stage_type]['possible_email_tmpl_actions'];

                            $record->is_super_admin = $is_super_admin;
                            $record->stage_etmp_action = $possible_actions[$record->stage_etmp_action];
                            $email_recipent = TRUE;
                            if ($record->stage_etmp_to == '') {
                                    $empty_send_to[] = $record->stage_etmp_name;
                                    $email_recipent = FALSE;
                                }
                            $record->email_recipent = $email_recipent;
                        } else
                        $return_arr['msg'] = 'dessociation failed';
                    $return_arr['avail_tmpls'] = $record;
                }
                return  $this->success('Success',200,$return_arr);
   
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$return_arr);
   
        }
	}
    public function delete_stage_email_template(Request $request)
    {
        try {
            $current_user = $this->get_current_user_details();
            $email_tmpl_id = $request->email_tmpl_id;
            if (!empty($email_tmpl_id)) {
                $email_tmpl_id = $this->decrypt_data($email_tmpl_id);
                $criteria = "setr_stage_etmp_id = {$email_tmpl_id}";
                $is_used_tmpl = Stage_email_tmpl_reference::get_single_record('COUNT(setr_id) as cnt', $criteria);
                if ($is_used_tmpl->cnt == 0) {
                    $template_condition = "stage_etmp_id = {$email_tmpl_id}";
                    Stage_email_templates::delete_records($template_condition, '', $current_user);
                    $message = 'Email template deleted';
                    return  $this->success('Success', 200, $message);
                }
                else{
                    $message = 'Email template cannot be deleted as it is currently in use.';
                    return  $this->warning('Success', 200, $message);
                }
            }
        } catch (\Exception $e) {
     
            return  $this->failure('Failed', 500, $e);
        }
    }    
}
