<?php

namespace App\Http\Controllers;

use App\Http\Traits\UserDataTrait;
use App\Models\Article_types;
use App\Models\Articles;
use App\Models\Clients;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Reports_model;
use App\Models\Journals;
use App\Models\Roles;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use stdClass;
use Throwable;
use Illuminate\Support\Str;
use DOMDocument;
use Carbon\Carbon;
use DateTime;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\File;
use ReflectionClass;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;
ini_set('max_execution_time', 300);
ini_set('memory_limit', '1024M');
class Report_generation_Api extends Controller
{
    use UserDataTrait;
    public function buildQuery(array $req, $return_raw_query = false) //eg req: ['type' => 'article', 'limit' => 10, 'keys' => ["Jounal name"=>"article_journal", "Jounal name 1"=>"article_journal"], 'filters' => ['Jounal name' => ['fltr' => [['value' => 'proceed', 'key' => 'contains']],'view' => ['mode' => 'group_concat', 'separator' => ',']],'Jounal name 1' => [ 'fltr' => [['value' => 'cem', 'key' => 'contains'],['value'=>'Bio', 'key'=>'contains']],'match' => 'any']], 'global_filter' => ['flags_and_labels' => ['flag' => [ 'fltr' => [['fixed_value' => 0, 'opt_value' => 'Excellent article']]], 'resub_paper' => ['fltr' => [['fixed_value' => 0]]]]]];
    {
        try {
            $report_config = config('report_generation');
            $key_config = $report_config['table_columns'] ?? [];
            $cond_config = $report_config['condition_params'];
            $selects = [];
            $tables = [];
            $joins = [];
            $group_by = [];
            $where_conditions = [];
            $keys = $req['keys'];
            $filters = $req['filters'];
            $global_filter = $req['global_filter'] ?? null;
            $fn_column_values = $req['fn_column_values'];
            $client_dateformat = $this->current_client->settings->cs_date_format;
            $dateFormat = date_format_map($client_dateformat);
            $function_columns = [];
            $table_config = config('report_tables.tables');
            $sub_select = [];
            $having = [];
            $global_match = 'all';
            $having_for_condition_params = ['is_empty', 'is_not_empty'];
            DB::statement("SET max_heap_table_size = 1024000000");
            DB::statement("SET tmp_table_size = 1024000000");
            $base_keys = array_unique(array_values($req['keys']));
            $avoid_role = true;
            if (count($base_keys)) {
                foreach ($base_keys as $key) {
                    if (($key_config['article'][$key] ?? false)) {
                        $avoid_role = false;
                    }
                    if (!$avoid_role) {
                        break;
                    }
                }
            }
            $default_table = $this->getBaseTable($keys, $avoid_role);
            $parent_value = $default_table['parent'];
            $baseUserArticle = config('report_tables.tables.baseUserArticle');
            $joins = $default_table['joins'];
            $usr_role_ids = [];
            $addl_tables_required = [];
            $col_val_modifier = [];
            $col_val_seperator = config('report_generation.delimeters');
            foreach ($keys as $key => $value) {
                if ($key_config['article'][$value] ?? $key_config['user'][$value] ?? false) {
                    if($parent_value == 'both'){
                        $article_key = $key_config['article'][$value] ?? null;
                        $user_key = $key_config['user'][$value] ?? null;
                        $fieldConfig =  $article_key ?? $user_key;
                    }else{
                        $fieldConfig = $key_config[$parent_value][$value];
                    }
                    if($req['report_id'] ?? null){
                        $field_function = Reports_model::get_single_record("rep_field_function", 'rep_parent=' . $req['report_id'] . " AND rep_title = '" . $key . "'");
                        if (!empty((array) $field_function) && $field_function->rep_field_function == 'count') {
                            $fieldConfig['condition']['type'] = 'number';
                        }
                    }
                    if (($user_key ?? false) && isset($fn_column_values[$key]) && $default_table['base_table'] == $baseUserArticle && !$avoid_role) {
                        $usr_role_ids[] = $fn_column_values[$key];
                        $filters[$key]['fltr'][] = ['usr_role' => $fn_column_values[$key]];
                    }
                    if ($fieldConfig['addl_required_table'] ?? false) {
                        $addl_tables_required = array_merge($addl_tables_required, $fieldConfig['addl_required_table']);
                    }
                    if ($fieldConfig['col_val_modifier'] ?? false) {
                        $mod_name = $fieldConfig['col_val_modifier']['mod_name'];
                        if (!isset($col_val_modifier[$mod_name])) {
                            $fn = $fieldConfig['col_val_modifier']['fn'];
                            $param = $fieldConfig['col_val_modifier']['param'];
                            $type = $fieldConfig['col_val_modifier']['type'];
                            $col_delimiter = $filters[$key]['view']['separator'] ?? null;
                            $filters[$key]['view']['separator'] = $col_val_seperator[$fieldConfig['condition']['default_delimeters'] ?? null]['value'] ?? '';
                            $col_val_modifier['config'][$mod_name] = $this->$fn($param)[$param];
                            $col_val_modifier['keys'][$key] = [$mod_name, $type, $col_delimiter, $filters[$key]['fltr'] ?? [], $fieldConfig['condition']['type']];
                        }
                    }
                    if (isset($fieldConfig['function_call']) && $fieldConfig['function_call']) {

                        if (isset($req['sort_by']) && !empty($req['sort_by']) && $req['sort_by']['name'] == $key) {
                            $sort = ['name' => $req['sort_by']['name'], 'order' => $req['sort_by']['order']];
                            // unset($req['sort_by']);
                        }
                        $function_columns['columns'][$value][] = ['as' => $key, 'fn' => $fieldConfig['function_call']['name'], 'cdtn_field' => $fieldConfig['function_call']['cdtn_field'], 'cdtn_value' => $fn_column_values[$key], 'display_col' => $fieldConfig['column'], 'sort' => $sort ?? null, 'field_config' => $fieldConfig, 'filter' => $filters[$key] ?? null];
                        continue;
                    }
                    $check_temp_tbl = array_column($fieldConfig['tables'],'temp_table');
                    if($fieldConfig['column'] == true && (!empty($check_temp_tbl) && $check_temp_tbl[0] == true) && (isset($filters[$key]['view']['mode']) && !empty($filters))){
                        $fieldConfig['column'] = $fieldConfig['column'] . '_' . $filters[$key]['view']['mode'];
                    }
                    if (isset($filters[$key]) && !($fieldConfig['col_val_modifier'] ?? false)) {
                        $cdtn_str = $col = $fieldConfig['column'];
                        if (isset($filters[$key]['fltr']) && !empty($filters[$key]['fltr'])) {
                            $cdtn_str = " IF(";
                            if(isset($filters[$key]['view']['mode']) && !empty($filters) && $filters[$key]['view']['mode'] == 'count'){
                                $col = $fieldConfig['column'] = "count(DISTINCT $col)";
                            }
                            $cdtn_arr = [];
                            foreach ($filters[$key]['fltr'] as $filter_arr) {
                                if (!is_array($filter_arr) || isset($filters[$key]['mode']) || isset($filters[$key]['separator']) || (($user_key ?? false) && ($filter_arr['usr_role'] ?? false))) {
                                    continue;
                                }
                                $type_cndtn = $cond_config['type'][$fieldConfig['condition']['type']];
                                // print_r($cond_config);die;
                                if (in_array($filter_arr['fixed_value'], $having_for_condition_params)) {
                                    if (count($filters[$key]['fltr']) == 1) {
                                        $cdtn_arr[] = $col;
                                    }
                                    $having[$key] = "`" . $key . "` " . $type_cndtn[$filter_arr['fixed_value']][0];
                                } else {
                                    if ($fieldConfig['condition']['type'] == 'date') {

                                        /* $timestamp = strtotime($filter_arr['opt_value']);
                                        $filter_arr['opt_value'] = date('Y-m-d', $timestamp); */
                                        /* $converted = Carbon::createFromFormat($this->current_client->settings->cs_date_format, $filter_arr['opt_value'])->format('Y-m-d');
                                        print_r($this->current_client->settings->cs_date_format.' <-> ');
                                        print_r($filter_arr['opt_value']);
                                        print_r(' <-> ' . $converted);
                                        print_r(' <-> ' . 'Y-m-d');die; */
                                        $col = "date($col)";

                                    }
                                    $cdtn_arr[] = $col . " " . $type_cndtn[$filter_arr['fixed_value']][0] . " '" . str_replace('?', $filter_arr['opt_value'], $type_cndtn[$filter_arr['fixed_value']][1]) . "'";
                                }
                            }
                            $col = isset($fieldConfig['condition']['sel_fn']) ? str_replace('col_name', $fieldConfig['column'], $fieldConfig['condition']['sel_fn']) : $fieldConfig['column'];
                            if (strpos($col, 'DATE_FORMAT_KEY') !== false) {
                                $col = str_replace('DATE_FORMAT_KEY', $dateFormat, $col);
                            }

                            $cdtn_str_resp = ", " . $col . ", null ";
                            if (isset($filters[$key]['match'])) {
                                if ($filters[$key]['match'] == 'any' || $filters[$key]['match'] == 'none') {
                                    $str = implode(" OR ", $cdtn_arr);
                                    if ($filters[$key]['match'] == 'none') {
                                        $cdtn_str_resp = ", null, " . $col;
                                    }
                                } else {
                                    $str = implode(" AND ", $cdtn_arr);
                                }
                            } else {
                                $str = implode(" AND ", $cdtn_arr);
                            }

                            // $cdtn_str .= $str . $cdtn_str_resp . ")";

                            if (($user_key ?? false) && ($fn_column_values[$key] ?? false)) {
                                $base_table = config("report_tables.tables.baseUserArticle");
                                if ($str) {
                                    $str = " ($str) and $base_table.jwf_role_id = $fn_column_values[$key]";
                                } else {
                                    $str = " $base_table.jwf_role_id = $fn_column_values[$key]";
                                }
                            }
                            $cdtn_str .=  $str . $cdtn_str_resp . ")";
                        }else{
                             $col = isset($fieldConfig['condition']['sel_fn']) ? str_replace('col_name', $fieldConfig['column'], $fieldConfig['condition']['sel_fn']) : $fieldConfig['column'];
                            if (strpos($col, 'DATE_FORMAT_KEY') !== false) {
                                $col = $cdtn_str = str_replace('DATE_FORMAT_KEY', $dateFormat, $col);
                            }
                        }

                        if (isset($having[$key]) && !empty($having[$key]) && count($filters[$key]['fltr']) == 1) {
                            $col = isset($fieldConfig['condition']['sel_fn']) ? str_replace('col_name', $fieldConfig['column'], $fieldConfig['condition']['sel_fn']) : $fieldConfig['column'];
                            if (strpos($col, 'DATE_FORMAT_KEY') !== false) {
                                $col = str_replace('DATE_FORMAT_KEY', $dateFormat, $col);
                            }
                            $cdtn_str = $col;
                        }
                            
                        if (($fieldConfig['column_mod'] ?? null) != 'subselect') {
                            if(isset($check_temp_tbl[0]) && $check_temp_tbl[0] == true && isset($filters[$key]['view'])){
                                if($filters[$key]['view']['mode'] == 'count' ){
                                    $cnt = 'count';
                                    $distinct = 'distinct';
                                    if(isset($filters[$key]['fltr']) && !empty($filters[$key]['fltr'])){
                                        $cnt = '';
                                        $distinct = '';
                                    }
                                    $cdtn_str = "$cnt($distinct " . $cdtn_str . ")";
                                }elseif($filters[$key]['view']['mode'] == 'group_concat' ){
                                    $cdtn_str = "GROUP_CONCAT(DISTINCT " . $cdtn_str . " SEPARATOR '" . $filters[$key]['view']['separator'] . "')";
                                }
                            }elseif (isset($filters[$key]['view']) && isset($filters[$key]['view']['mode']) && $filters[$key]['view']['mode'] == 'group_concat') {
                                $cdtn_str = $filters[$key]['view']['mode'] . "(distinct " . $cdtn_str . " SEPARATOR '" . $filters[$key]['view']['separator'] . "')";
                            } elseif (isset($filters[$key]['view']) && isset($filters[$key]['view']['mode']) && $filters[$key]['view']['mode'] == 'count') {
                                if(isset($filters[$key]['fltr']) && !empty($filters[$key]['fltr'])){
                                    $cdtn_str = "(" . $cdtn_str . ") ";
                                }else{
                                    $cdtn_str = $filters[$key]['view']['mode'] . "(distinct " . $cdtn_str . ") ";
                                }
                            } else {
                                $group_by[] = $key;
                            }
                        } else {
                            $group_by[] = $key;
                        }
                        $selects[] = $cdtn_str . " as '" . $key . "'";
                    } else {
                        $group_by[] = $key;
                        $col = isset($fieldConfig['condition']['sel_fn']) ? str_replace('col_name', $fieldConfig['column'], $fieldConfig['condition']['sel_fn']) : $fieldConfig['column'];
                        if (strpos($col, 'DATE_FORMAT_KEY') !== false) {
                            $col = str_replace('DATE_FORMAT_KEY', $dateFormat, $col);
                        }

                        $selects[] = $col . " as '" . $key . "'";
                    }
                    if ($fieldConfig['addl_required_table'] ?? false) {
                        $addl_tables_required = array_merge($addl_tables_required, $fieldConfig['addl_required_table']);
                    }
                    if(isset($user_key) && $user_key != null){
                        // $group_by[] = 'usr_id';
                    }
                    foreach ($fieldConfig['tables'] as $table) {
                        if (!in_array($table['name'], $tables)) {
                            $tables[] = $table['name'];
                        }


                        foreach ($fieldConfig['tables'] as $table) {
                            $temp_group_by = '';
                            if (isset($table['sub_select']) && $table['sub_select']) {
                                $sub_selec_val = $table['sub_select'][0];
                                preg_match('/\bas\s+(\w+)\s*$/i', $sub_selec_val, $matches);
                
                                $select_as = $matches[1] ?? null;
                                if(!$select_as){
                                    $select_as = $sub_selec_val;
                                }
                                $sub_select_grouping = $table['sub_select_grouping'] ?? true;
                                if($sub_select_grouping){
                                if (isset($filters[$key]['view']) && isset($filters[$key]['view']['mode']) && $filters[$key]['view']['mode'] == 'group_concat' && (!str_contains($sub_selec_val, 'group_concat') && !str_contains($sub_selec_val, 'GROUP_CONCAT'))) {
                                    $sub_selec_val = str_replace("AS $select_as", "", $sub_selec_val);
                                    $sub_selec_val = str_replace("as $select_as", "", $sub_selec_val);
                                    if ($table['temp_table'] ?? false) {
                                        $sub_selec_val = "CAST(" . $filters[$key]['view']['mode'] . "(" . $sub_selec_val . " SEPARATOR '" . $filters[$key]['view']['separator'] . "')  AS CHAR(512)) AS $select_as".'_'.$filters[$key]['view']['mode'];
                                    } else {
                                        $sub_selec_val = $filters[$key]['view']['mode'] . "(" . $sub_selec_val . " SEPARATOR '" . $filters[$key]['view']['separator'] . "') AS $select_as";
                                    }
                                } elseif (isset($filters[$key]['view']) && isset($filters[$key]['view']['mode']) && $filters[$key]['view']['mode'] == 'count') {
                                    $sub_selec_val = str_replace("AS $select_as", "", $sub_selec_val);
                                    $sub_selec_val = str_replace("as $select_as", "", $sub_selec_val);
                                    if($table['temp_table'] ?? false){
                                        $sub_selec_val =  "(" . $sub_selec_val . ") as $select_as".'_'.$filters[$key]['view']['mode'];
                                    }else{
                                        $sub_selec_val = $filters[$key]['view']['mode'] . "(" . $sub_selec_val . ") as $select_as ";
                                    }
                                }
                                else{
                                    $key_arr = array('article_keyword','article_classification','user_keyword','user_classification');
                                    if(in_array($value,$key_arr)){
                                        $temp_group_by = $sub_selec_val;
                                    }
                                }
                            }elseif(isset($table['temp_table']) && $table['temp_table'] == true && isset($filters[$key]['view']) && isset($filters[$key]['view']['mode']) && ($filters[$key]['view']['mode'] == 'group_concat' || $filters[$key]['view']['mode'] == 'count')){
                                $sub_selec_val = $sub_selec_val .' as '. $sub_selec_val.'_'.$filters[$key]['view']['mode'];
                            }
                                $table['sub_select'][0] = $sub_selec_val;
                                $sub_select[$table['name']] = array_merge($sub_select[$table['name']] ?? [], $table['sub_select']);
                            }
                            if(($table['on'][0] ?? false) && is_array($table['on'][0])){
                                $joining_str = '';
                                foreach($table['on'] as $table_ons){
                                    $joining_str .= '_' . $table_ons[0] . $table_ons[1] . $table_ons[2];
                                }
                                 $joinKey = $table['name'] . $joining_str;
                            }else{
                                $joinKey = $table['name'] . '_' . $table['on'][0] . $table['on'][1] . $table['on'][2];
                            }
                            if (!isset($joins[$joinKey])) {
                                $joins[$joinKey] = [
                                    'type' => $table['join'],
                                    'table' => $table['name'],
                                    'temp_table' => $table['temp_table'] ?? false,
                                    'on' => $table['on'],
                                    'temp_group_by' => $temp_group_by ?? ''
                                ];
                            }
                        }
                    }
                }
            }
            if ($global_filter) {
                $filter_config = Config('reportFilter');
                foreach ($global_filter as $main => $sub) {
                    if($main == 'match'){
                        $global_match = $sub;
                        continue;
                    }
                    foreach ($sub as $sub_key => $sub_values) {
                        if($parent_value == 'both'){
                            $fieldConfig = ($filter_config['article'][$main] ?? $filter_config['user'][$main])[$sub_key];
                        }else{
                            $fieldConfig = $filter_config[$parent_value][$main][$sub_key];
                        }
                        if ($fieldConfig['addl_required_table'] ?? false) {
                            $addl_tables_required = array_merge($addl_tables_required, $fieldConfig['addl_required_table']);
                        }
                        $level = 0;
                        if (isset($fieldConfig['function_call']) && isset($fieldConfig['function_call'])) {
                            $fn_value = call_user_func([$this, $fieldConfig['function_call']['name']], $sub_values);
                            $sub_values['match'] = 'all';
                            $sub_values['fltr'] = [];
                            $sub_values['fltr'][] = ['fixed_value' => $fieldConfig['function_call']['fixed_option'], 'opt_value' => $fn_value];
                        }
                        if (isset($sub_values['match'])) {
                            $where_conditions[$sub_key]['match'] = $sub_values['match'];
                        }
                        foreach ($sub_values['fltr'] as $value_key => $sub_val) {
                            $actual_fltr_count = count($fieldConfig['condition']['options']);
                            $explicit_match = ($value_key+1)%$actual_fltr_count;
                            $has_opt_val = $sub_val['opt_value'] ?? false;
                            $fixed_val_bkp = null;
                            if ($sub_val['dependent'] ?? false) {
                                $dependent_index = $value_key%$actual_fltr_count;
                                $fixed_val_bkp = $fieldConfig['condition']['fixed_value'];
                                $fieldConfig['condition']['fixed_value'] = $fieldConfig['condition']["dependent_$dependent_index"];
                            }

                            /*foreach ($fieldConfig['tables'] as $table) {
                                if (!in_array($table['name'], $tables)) {
                                    $tables[] = $table['name'];
                                } */

                                foreach ($fieldConfig['tables'] as $table) {
                                    if (isset($table['sub_select']) && $table['sub_select']) {
                                        $sub_selec_val = $table['sub_select'][0];
                                        if (isset($global_filter[$key]['view']) && isset($global_filter[$key]['view']['mode']) && $global_filter[$key]['view']['mode'] == 'group_concat') {
                                            if ($table['temp_table'] ?? false) {
                                                $sub_selec_val = "CAST(" . $global_filter[$key]['view']['mode'] . "(" . $sub_selec_val . " SEPARATOR '" . $global_filter[$key]['view']['separator'] . "')  AS CHAR(512)) AS $sub_selec_val";
                                            } else {
                                                $sub_selec_val = $global_filter[$key]['view']['mode'] . "(" . $sub_selec_val . " SEPARATOR '" . $global_filter[$key]['view']['separator'] . "') AS $sub_selec_val";
                                            }
                                        } elseif (isset($global_filter[$key]['view']) && isset($global_filter[$key]['view']['mode']) && $global_filter[$key]['view']['mode'] == 'count') {
                                            $sub_selec_val = $global_filter[$key]['view']['mode'] . "(" . $sub_selec_val . ") ";
                                        }
                                        $table['sub_select'][0] = $sub_selec_val;
                                        $sub_select[$table['name']] = array_merge($sub_select[$table['name']] ?? [], $table['sub_select']);
                                    }
                                    if (($table['on'][0] ?? false) && is_array($table['on'][0])) {
                                        $joining_str = '';
                                        foreach ($table['on'] as $table_ons) {
                                            $joining_str .= '_' . $table_ons[0] . $table_ons[1] . $table_ons[2];
                                        }
                                        $joinKey = $table['name'] . $joining_str;
                                    } else {
                                        $joinKey = $table['name'] . '_' . $table['on'][0] . $table['on'][1] . $table['on'][2];
                                    }
                                    if (!isset($joins[$joinKey])) {
                                        $joins[$joinKey] = [
                                            'type' => $table['join'],
                                            'table' => $table['name'],
                                            'temp_table' => $table['temp_table'] ?? false,
                                            'on' => $table['on']
                                        ];
                                    }
                                }
                            // }
                            
                            if($has_opt_val)
                            {
                                $check_date_item = string_date_format($sub_val['opt_value'],'Y-m-d');  
                                if($check_date_item !== false)
                                {
                                     $sub_val['opt_value'] = $check_date_item;
                                }
                            }
                            if ($fieldConfig['condition']['fixed_option'] == 'condition_params' && $has_opt_val) {
                                $type = $fieldConfig['condition']['fixed_value']['type'];
                                $col = $fieldConfig['condition']['fixed_value']['col'];
                                $cdtn_values = $cond_config['type'][$type][$sub_val['fixed_value']];
                                $where_conditions[$sub_key][$level]['where'][] = [DB::raw($col), $cdtn_values[0], str_replace('?', $has_opt_val, $cdtn_values[1])];
                            } else {
                                $cdtns = $fieldConfig['condition']['fixed_value'][$sub_val['fixed_value']] ?? [];
                                foreach ($cdtns as $cdtn) {
                                    if ($cdtn[2] === null) {
                                        if ($cdtn[1] === 'is') {
                                            $where_conditions[$sub_key][$level]['whereNull'][] = DB::raw($cdtn[0]);
                                        } else {
                                            $where_conditions[$sub_key][$level]['whereNotNull'][] = DB::raw($cdtn[0]);
                                        }
                                    } elseif (Str::upper($cdtn[1]) === 'NOT IN') {
                                        $where_conditions[$sub_key][$level]['whereNotIn'][] = [DB::raw($cdtn[0]), $sub_val['opt_value']];
                                    } elseif (Str::upper($cdtn[1]) === 'IN') {
                                        $where_conditions[$sub_key][$level]['whereIn'][] = [DB::raw($cdtn[0]), $sub_val['opt_value']];
                                    } elseif ($cdtn[2] === 'raw_cdtn') {
                                        $where_conditions[$sub_key][$level]['whereRaw'][] = $has_opt_val ? str_replace('?', $sub_val['opt_value'], $cdtn[0]) : $cdtn[0];
                                    } else {
                                        $where_conditions[$sub_key][$level]['where'][] = [DB::raw($cdtn[0]), $cdtn[1], $has_opt_val ? str_replace('?', $sub_val['opt_value'], $cdtn[2]) : $cdtn[2]];
                                    }
                                }
                            }
                            if($explicit_match === 0){
                                $level++;
                            }
                            if($fixed_val_bkp ?? false){
                                    $fieldConfig['condition']['fixed_value'] = $fixed_val_bkp;
                                    $fixed_val_bkp = null;
                            }
                        }
                    }
                }
            }

            $where_conditions = array_unique($where_conditions, SORT_REGULAR);
            DB::enableQueryLog();
            $should_cache = $this->shouldUseCache($req);
            $cacheKey = "query_results_" . md5(json_encode([$req['report_id']]));
            $raw_sql = '';
            $result = Cache::store('report_redis')->rememberForever($cacheKey, function () use ($selects, $joins, $raw_sql, $default_table, $table_config, $where_conditions, $cond_config, $function_columns, $sub_select, $usr_role_ids, $group_by, $having, $addl_tables_required, $avoid_role, $col_val_modifier, $global_match, $having_for_condition_params, $dateFormat) {
                $table = config("report_tables.tables.baseUserArticle");
                $usr_role_where = "";
                if ($usr_role_ids) {
                    $usr_role_where = "where w.jwf_role_id in (" . implode(",", $usr_role_ids) . ")";
                }
                // DB::statement("SET SESSION group_concat_max_len = 1000000;");
                if (count($addl_tables_required)) {
                    $addl_table_desc = config("report_tables.tables");
                    $addl_tables_required = array_unique($addl_tables_required);
                    foreach ($addl_tables_required as $addl_table) {
                        DB::statement("CREATE TEMPORARY TABLE {$addl_table} ENGINE=MEMORY AS {$addl_table_desc[$addl_table]} ");
                    }
                }
                $has_baseuser = false;
                foreach ($joins as $key => $join) {
                    if (str_contains($key, $table)) {
                        $has_baseuser =  true;
                    }
                };
                if ($has_baseuser || $default_table['base_table'] == $table) {
                    if ($avoid_role) {
                        $base_table = "SELECT usr_id user_id, usrj_role_id jwf_role_id from rvw_users left join rvw_user_journals on usrj_usr_id = usr_id";
                    } else {
                        $base_table = "SELECT distinct u.usr_id AS user_id,COALESCE(af.aflw_art_id, aa.auth_art_id) AS article_id, jwf_role_id, aflw_id, jwf_id  FROM rvw_users u LEFT JOIN rvw_article_authors aa ON u.usr_id = aa.auth_usr_id left JOIN rvw_article_flow af ON u.usr_id = af.aflw_usr_id LEFT JOIN rvw_journal_workflows w ON af.aflw_jwf_id = w.jwf_id";
                    }

                    DB::statement("CREATE TEMPORARY TABLE $table ENGINE=MEMORY AS $base_table $usr_role_where");
                    DB::statement("ALTER TABLE $table ADD INDEX idx_user_id (user_id)");
                    if (!$avoid_role) {
                        DB::statement("ALTER TABLE $table ADD INDEX idx_article_id (article_id)");
                        DB::statement("ALTER TABLE $table ADD INDEX idx_user_article (user_id, article_id)");
                        // DB::statement("ALTER TABLE $table ADD INDEX idx_aflw_id (aflw_id)");
                        // DB::statement("ALTER TABLE $table ADD INDEX idx_jwf_id (jwf_id)");
                    }
                    if ($table != $default_table['base_table']) {
                        $base_join = config("report_generation.base_join.{$default_table['parent']}", null);
                        if ($base_join) {
                            if (($base_join['on'][0] ?? false) && is_array($base_join['on'][0])) {
                                        $joining_str = '';
                                        foreach ($base_join['on'] as $table_ons) {
                                            $joining_str .= '_' . $table_ons[0] . $table_ons[1] . $table_ons[2];
                                        }
                                        $joinKey = $table['name'] . $joining_str;
                                    } else {
                                        $joinKey = $base_join['name'] . '_' . $base_join['on'][0] . $base_join['on'][1] . $base_join['on'][2];
                            }
                            if (!isset($joins[$joinKey])) {
                                $base_table_join[$joinKey] = [
                                    'type' => $base_join['join'],
                                    'table' => $base_join['name'],
                                    'temp_table' => $base_join['temp_table'] ?? false,
                                    'on' => $base_join['on']
                                ];
                                $joins = array_merge($base_table_join, $joins);
                            }
                        }
                        $default_table['base_table'] = $table;
                    }
                }


                $query = DB::table($default_table['base_table']);
                $index_config = config('report_tables.indexing');
                foreach ($joins as $join) {
                    // dump($table_config[$join['table']] ?? []);
                    // dump(__($table_config[$join['table']], [$join['table'] => implode(",",array_unique($sub_select[$join['table']] ?? []))]));
                    // dump($join['table']);
                    $table_name = $join['table'];
                    $join['table'] = isset($table_config[$join['table']]) && $join['temp_table'] == false ? DB::raw(__($table_config[$join['table']], [$join['table'] => implode(",", array_unique($sub_select[$join['table']] ?? []))])) : $join['table'];

                    if ($join['temp_table']) {
                        $table_desc = __($table_config[$join['table']], [$join['table'] => implode(",", array_unique($sub_select[$join['table']] ?? []))]);
                        if(isset($join['temp_group_by']) && !empty($join['temp_group_by'])){
                            $table_desc = $table_desc . ',' . $join['temp_group_by'];
                        }
                        DB::statement("CREATE TEMPORARY TABLE {$table_name} ENGINE=MEMORY AS {$table_desc} ");
                    }

                    if ($index_config[$table_name] ?? false) {
                        $index = $index_config[$table_name];
                        DB::statement("ALTER TABLE {$table_name} ADD INDEX {$index['index_name']} ({$index['index_columns']})");
                    }
                    if(($join['on'][0] ?? false) && is_array($join['on'][0])){
                        if ($join['type'] === 'RIGHT') {
                            $query->rightJoin($join['table'], function ($joining) use ($join) {
                                foreach ($join['on'] as $query_join) {
                                    $joining->on($query_join[0], $query_join[1], DB::raw($query_join[2]));
                                }
                            });
                        } elseif ($join['type'] === 'LEFT') {
                            $query->leftJoin($join['table'], function ($joining) use ($join) {
                                foreach ($join['on'] as $query_join) {
                                    $joining->on($query_join[0], $query_join[1], DB::raw($query_join[2]));
                                }
                            });
                        } elseif ($join['type'] === 'INNER') {
                            $query->leftJoin($join['table'], function ($joining) use ($join) {
                                foreach ($join['on'] as $query_join) {
                                    $joining->on($query_join[0], $query_join[1], DB::raw($query_join[2]));
                                }
                            });
                        } else {
                            $query->join($join['table'], function ($joining) use ($join) {
                                foreach ($join['on'] as $query_join) {
                                    $joining->on($query_join[0], $query_join[1], DB::raw($query_join[2]));
                                }
                            });
                        }
                    }else{
                        if ($join['type'] === 'RIGHT') {
                            $query->rightJoin($join['table'],  $join['on'][0], $join['on'][1], DB::raw($join['on'][2]));
                        } elseif ($join['type'] === 'LEFT') {
                            $query->leftJoin($join['table'], $join['on'][0], $join['on'][1], DB::raw($join['on'][2]));
                        } else {
                            $query->join($join['table'], $join['on'][0], $join['on'][1], DB::raw($join['on'][2]));
                        }
                }
                }
                $merge_key = null;
                $art_table = (new Articles)->getTable();
                if ($default_table['base_table'] == $art_table || in_array($art_table, array_column($joins, 'table'))) {
                    $selects[] = "rvw_articles.art_id as custom_art_id";
                    $selects[] = "rvw_articles.art_artp_id as custom_artp_id";
                    $merge_key = "custom_art_id";
                }else{
                    $selects[] = "rvw_users.usr_id as custom_usr_id";
                    $merge_key = "custom_usr_id";

                }
                $global_cdtn_to_use = 'where';
                if ($global_match == 'any' && $key > 0) {
                    $global_cdtn_to_use = 'orWhere';
                } elseif ($global_match == 'none') {
                    $global_cdtn_to_use = 'WhereNot';
                }
                $query->select(DB::raw(implode(', ', $selects)))->distinct();
                foreach ($where_conditions as $level_condition) {
                    $query = $query->$global_cdtn_to_use(function ($query) use ($level_condition) {
                        $match = $level_condition['match'] ?? 'all';
                        foreach ($level_condition as $key => $where_condition) {
                            if (!is_array($where_condition)) {
                                continue;
                            }
                            $cdtn_to_use = 'where';
                            if ($match == 'any' && $key > 0) {
                                $cdtn_to_use = 'orWhere';
                            } elseif ($match == 'none') {
                                $cdtn_to_use = 'WhereNot';
                            }
                            $query = $query->$cdtn_to_use(function ($query) use ($where_condition) {
                                if (isset($where_condition['where']) && count($where_condition['where']))
                                    $query->where($where_condition['where']);
                                if (isset($where_condition['whereIn'])) {
                                    foreach ($where_condition['whereIn'] as $null_val) {
                                        $query->whereIn($null_val[0], $null_val[1]);
                                    }
                                }
                                if (isset($where_condition['whereNotIn'])) {
                                    foreach ($where_condition['whereNotIn'] as $null_val) {
                                        $query->whereNotIn($null_val[0], $null_val[1]);
                                    }
                                }
                                if (isset($where_condition['whereNull'])) {
                                    foreach ($where_condition['whereNull'] as $null_val) {
                                        $query->whereNull($null_val);
                                    }
                                }
                                if (isset($where_condition['whereNotNull'])) {
                                    foreach ($where_condition['whereNotNull'] as $not_null_val) {
                                        $query->whereNotNull($not_null_val);
                                    }
                                }
                                if (isset($where_condition['whereRaw'])) {
                                    foreach ($where_condition['whereRaw'] as $raw) {
                                        $query->whereRaw($raw);
                                    }
                                }
                            });
                        }
                    });
                }
                if (!empty($group_by)) {
                    $query->groupBy(array_unique($group_by));
                }
                if (!empty($having)) {
                    $query->havingRaw(implode(" AND ", $having));
                }
                // $result = $query->limit(10)->get();
                $raw_sql = $query->toSql();
                $bindings = $query->getBindings();
                foreach ($bindings as $binding) {
                    $raw_sql = preg_replace('/\?/', "'" . $binding . "'", $raw_sql, 1);
                }
                // $result = $query->paginate($req['limit']);
                // $generate_total_count = $this->get_generated_total_count($req['report_child_rows'], $show_column_total_type, $raw_sql);
                // if ($return_raw_query == true) {
                //     return $raw_sql;
                // }
                // print_r($raw_sql);exit;
                $result = $query->get();
                $result = collect($result);
                $uniqueIdentifierAlias = array();
                if ($function_columns || $col_val_modifier) {
                    $articleTypeIds = array_unique($result->pluck('custom_artp_id')?->toArray());
                    $having = $col_val_mod_sel_cond = [];
                    if ($function_columns['columns'] ?? false) {
                        foreach ($function_columns['columns'] as $fn_colmns) {
                            $cdtn_field_values = '';
                            $multi_col = count($fn_colmns) > 1;
                            $select = '';
                            foreach ($fn_colmns as $fn_colmn) {
                                $cdtn_str = $str = '';
                                $fn_col_fltr = $fn_colmn['filter'];
                                $fld_conf = $fn_colmn['field_config'];
                                if (isset($fn_col_fltr)) {
                                $cdtn_str = $col = $fn_colmn['display_col'];
                                if (isset($fn_col_fltr['fltr']) && !empty($fn_col_fltr['fltr'])) {
                                    $cdtn_str = " IF(";
                                    $cdtn_arr = [];
                                    foreach ($fn_col_fltr['fltr'] as $filter_arr) {
                                        if (!is_array($filter_arr) || isset($fn_col_fltr['mode']) || isset($fn_col_fltr['separator']) || (($user_key ?? false) && ($filter_arr['usr_role'] ?? false))) {
                                            continue;
                                        }
                                        $type_cndtn = $cond_config['type'][$fld_conf['condition']['type']];
                                        if (in_array($filter_arr['fixed_value'], $having_for_condition_params)) {
                                            $having['fn_col'][$fn_colmn['as']] = $type_cndtn[$filter_arr['fixed_value']][1];
                                            continue;
                                        } else {
                                            if ($fld_conf['condition']['type'] == 'date') {
                                                $col = "date($col)";
                                            }
                                            $cdtn_arr[] = $col . " " . $type_cndtn[$filter_arr['fixed_value']][0] . " '" . str_replace('?', $filter_arr['opt_value'], $type_cndtn[$filter_arr['fixed_value']][1]) . "'";
                                        }
                                    }
                                    $col = isset($fieldConfig['condition']['sel_fn']) ? str_replace('col_name', $fieldConfig['column'], $fieldConfig['condition']['sel_fn']) : $fld_conf['column'];
                                    if (strpos($col, 'DATE_FORMAT_KEY') !== false) {
                                        $col = str_replace('DATE_FORMAT_KEY', $dateFormat, $col);
                                    }
                                    $cdtn_str_resp = ", " . $col . ", null ";
                                    if (isset($fn_col_fltr['match'])) {
                                        if ($fn_col_fltr['match'] == 'any' || $fn_col_fltr['match'] == 'none') {
                                            $str = implode(" OR ", $cdtn_arr);
                                            if ($fn_col_fltr['match'] == 'none') {
                                                $cdtn_str_resp = ", null, " . $col;
                                            }
                                        } else {
                                            $str = implode(" AND ", $cdtn_arr);
                                        }
                                    } else {
                                        $str = implode(" AND ", $cdtn_arr);
                                    }
                                    $cdtn_str .=  $str . $cdtn_str_resp . ")";
                                }
                                
                            }
                            if ($multi_col) {
                                if($str){
                                    $str = "AND ($str) ";
                                }
                                $select .= "if({$fn_colmn['cdtn_field']} = '{$fn_colmn['cdtn_value']}' $str, {$fn_colmn['display_col']}, null) as '{$fn_colmn['as']}', ";
                            } else {
                                if($str){
                                    $select = "$cdtn_str as '{$fn_colmn['as']}', ";
                                }else{
                                    $select = "{$fn_colmn['display_col']} as '{$fn_colmn['as']}', ";
                                }
                            }
                            $cdtn_field_values .= "'{$fn_colmn['cdtn_value']}',";
                                $uniqueIdentifierAlias[$fn_colmn['as']] = null;
                            }
                            $fn = $fn_colmns[0]['fn'];
                            $resp = $this->$fn($articleTypeIds, $fn_colmns[0]['cdtn_field'], rtrim($cdtn_field_values, ", "), $select);
                            if ($resp) {
                                $resp_arr[] = $resp;
                            }
                        }
                    }
                    if ($col_val_modifier ?? false) {
                        foreach ($col_val_modifier['keys'] as $col_key => $col_val) {
                            $col_val_filter = $col_val[3] ?? [];
                            foreach ($col_val_filter as $filter_arr) {
                                if (!is_array($filter_arr) || isset($fn_col_fltr['mode']) || isset($fn_col_fltr['separator']) || (($filter_arr['usr_role'] ?? false))) {
                                    continue;
                                }
                                $type_cndtn = $cond_config['type'][$col_val[4]];
                                if (in_array($filter_arr['fixed_value'], $having_for_condition_params)) {
                                    $having['col_val'][$col_key] = $type_cndtn[$filter_arr['fixed_value']][1];
                                }
                                elseif($filter_arr['fixed_value'] ?? false){
                                    $col_val_mod_sel_cond[$col_key] = [$filter_arr['fixed_value'], $filter_arr['opt_value']];
                                }
                            }
                        }
                    }
                    $result = $this->mergeArrayToReport($result, $resp_arr ?? [], $col_val_modifier, $merge_key, $uniqueIdentifierAlias, $having, $col_val_mod_sel_cond);
                }
                return $result;
            }); 
            $counts = $this->getColumnCount($req, $result);
            $result = $this->packSparseColumns($result, 'custom_art_id');
            $result = $this->sort_report($result, $req['sort_by'], $client_dateformat);
            if ($return_raw_query == true) {
                return array(
                    'generated_report'           => $result,
                    'generated_total_count'      => $counts,
                );
            }
            // $this->generateReportPdf($req['report_id'], $result);
            $result = $result->paginate($req['limit']);
            $report_data = array(
                'generated_report_query'        => $raw_sql ?? null,
                'generated_report'              => $result,
                'generated_total_count_query'   => $generate_total_count['total_count_raw_query'] ?? null,// no need
                'generated_total_count'         => $counts,
                'cached_result' => $should_cache
            );
            if(!$should_cache){
                    Cache::store('report_redis')->forget("reportDateFor_" . $req['report_id']);
                    Cache::store('report_redis')->rememberForever("reportDateFor_" . $req['report_id'], function () {
                        return Carbon::now()->format('Y-m-d H:i:s');
                    });
            }
            $this->report_xml($req['report_id'], 'write', $report_data, true);
            return $report_data;

            // print_r($result);die;

            // $queries = DB::getQueryLog();
            // dd($queries);
            // return $result;
            // return $query->get();
        } catch (Throwable $e) {
            Log::warning($e->getMessage());
            Log::warning($e->getTraceAsString());
            $this->configRollbackFromCache($req['report_id']);
            throw $e;
        }
    }

    private function shouldUseCache($req)
    {
        if ($req['force_reload'] == false) {
            $previous_rpt_id = Cache::store('report_redis')->get("query_previous_rpt_id_" . $req['report_id']);
            if ($previous_rpt_id) {
                $previous_rpt_id = $previous_rpt_id;
                if ($previous_rpt_id['report_id'] == $req['report_id'] && $previous_rpt_id['keys'] == $req['keys'] && $previous_rpt_id['filters'] == $req['filters'] && $previous_rpt_id['global_filter'] == $req['global_filter']) {
                    return true;
                }
            }
        }
        $cacheKey = "query_results_" . md5(json_encode([$req['report_id']]));
        Cache::store('report_redis')->forget($cacheKey);
        Cache::store('report_redis')->forget("query_previous_rpt_id_" . $req['report_id']);
        Cache::store('report_redis')->rememberForever("query_previous_rpt_id_" . $req['report_id'], function () use ($req) {
            return $req;
        });

        return false;
    }

    private function determineKeySourceArray(array $key_arr): string
    {
        $foundInA = $independantA = false;
        $foundInB = $independantB = false;

        $config = config('report_generation')['table_columns'];
        $articleKeys = $config['article'];
        $userKeys = $config['user'];

        foreach ($key_arr as $value) {
            if (isset($articleKeys[$value])) {
                if($articleKeys[$value]['independant'] ?? false){
                    $independantA = true;
                }else{
                    $foundInA = true;
                }
            }
            if (isset($userKeys[$value])) {
                if($articleKeys[$value]['independant'] ?? false){
                    $independantB = true;
                }else{
                    $foundInB = true;
                }
            }
        }

        if ($foundInA && $foundInB) {
            return 'both';
        } elseif ($foundInA) {
            return 'article';
        } elseif ($foundInB) {
            return 'user';
        }elseif($independantA) {
            return 'article';
        }elseif($foundInB){
            return 'user';
        }

        return 'unknown';
    }

    private function getBaseTable(array $key_arr, $avoid_role)
    {
        $parent = $this->determineKeySourceArray($key_arr);
        $table = null;
        $joining_tables = [];
        $art_table = (new Articles())->getTable();
        $usr_table = (new User())->getTable();
        if ($parent == 'article') {
            $table = $art_table;
        } elseif ($parent == 'user') {
            $table = $usr_table;
        } else {
            $table = config('report_tables.tables')['baseUserArticle'];
            $joining_tables = [
                [
                    'table' => $usr_table,
                    'type' => '',
                    'on' => ["$table.user_id", "=", "$usr_table.usr_id"],
                    'temp_table' => false
                ],
            ];
            if (!$avoid_role) {
                $joining_tables[] = [
                    'table' => $art_table,
                    'type' => 'left',
                    'on' => ["$table.article_id", "=", "$art_table.art_id"],
                    'temp_table' => false
                ];
            }
        }

        return ['base_table' => $table, 'joins' => $joining_tables, 'parent' => $parent];
    }




    private function mergeArrayToReport($report_ar, $fn_resp_ar, $column_val_modifer = [], $merge_key = 'custom_art_id', $uniqueIdentifierAlias, $having, $col_val_mod_sel_cond)
    {
        $relatedData = [];
        if ($fn_resp_ar) {
            $relatedData = singlePassMergeByKey($fn_resp_ar, $merge_key);
        }
        $report_ar->transform(function ($article) use ($relatedData, $column_val_modifer, $merge_key, $uniqueIdentifierAlias, $having, $col_val_mod_sel_cond) {
            $related = $relatedData[$article->$merge_key] ?? $uniqueIdentifierAlias;
            if ($column_val_modifer) {
                foreach ($column_val_modifer['keys'] as $key => $value) {
                    if ($article->$key) {
                        $col_val_config = $column_val_modifer['config'][$value[0]];
                        if ($value[1] == 'array') {
                            if (is_string($article->$key)) {
                                $codes = explode(',', $article->$key);
                            }
                            if (count($codes) == 1) {
                                $article->$key = $col_val_config[trim($article->$key, " \"")] ?? $article->$key;
                            } else {
                                $article->$key = implode($value[2], array_map(function ($code) use ($col_val_config) {
                                    return $col_val_config[trim($code, " \"")] ?? '';
                                }, $codes)) ?? $article->$key;
                            }
                        } else {
                            $article->$key = trim($col_val_config[$article->$key] ?? $article->$key);
                        }
                    }
                    if($col_val_mod_sel_cond[$key] ?? false){
                        if(!$this->compare($article->$key, $col_val_mod_sel_cond[$key][1], $col_val_mod_sel_cond[$key][0])){
                            $article->$key = null;
                        }
                    }
                    if ($having['col_val'][$key] ?? false) {
                                $val = $article->$key ?? null;
                                if ($having['col_val'][$key] == 'IS NULL') {
                                    if ($val !== null && $val !== '') {
                                        return null;
                                    }
                                }
                                if ($having['col_val'][$key] == 'IS NOT NULL') {
                                    if ($val === null || $val === '') {
                                        return null;
                                    }
                                }
                    }
                }
            }
            if (is_object($related)) {
                $related = (array) $related;
            }
            if ($having['fn_col'] ?? false) {
                foreach ($having['fn_col'] as $having_key => $having_cdtn) {
                    $val = $related[$having_key] ?? null;
                    if ($having_cdtn == 'IS NULL') {
                        if ($val !== null && $val !== '') {
                            return null;
                        }
                    }
                    if ($having_cdtn == 'IS NOT NULL') {
                        if ($val === null || $val === '') {
                            return null;
                        }
                    }
                }
            }
            return (object) array_merge((array) $article, $related);
        });

        $report_ar = $report_ar->filter();
        return $report_ar;
    }

    function compare($a, $b, $type)
    {
        $a = strtolower($a);
        $b = strtolower($b);
        switch ($type) {
            case 'is':
                return $a === $b;
            case 'contains':
                return strpos($a, $b) !== false;
            case 'not_contains':
                return strpos($a, $b) === false;
            case 'starts_with':
                return str_starts_with($a, $b);
            case 'ends_with':
                return str_ends_with($a, $b);
            case 'not_start_with':
                return !str_starts_with($a, $b);
            case 'not_end_with':
                return !str_ends_with($a, $b);
        }
    }

    private function sort_report($report_ar, $sort, $dateFormat)
    {
        if (($sort['order'] ?? false) == 'asc') {
            // $report_ar = $report_ar->sortBy($sort['name']);
            $report_ar = $report_ar->sortBy(function ($report) use ($sort, $dateFormat) {
                if($this->isDate($report->{$sort['name']}, $dateFormat)){
                    return Carbon::createFromFormat($dateFormat, $report->{$sort['name']});
                }else{
                    $value = $report->{$sort['name']};
                    return trim(is_string($value) ? strtolower($value) : $value);
                }
            });
        } elseif (($sort['order'] ?? false) == 'desc') {
            // $report_ar = $report_ar->sortByDesc($sort['name']);
            $report_ar = $report_ar->sortByDesc(function ($report) use ($sort, $dateFormat) {
                if($this->isDate($report->{$sort['name']}, $dateFormat)){
                    return Carbon::createFromFormat($dateFormat, $report->{$sort['name']});
                }else{
                    $value = $report->{$sort['name']};
                    return trim(is_string($value) ? strtolower($value) : $value);
                }
            });
        }

        return $report_ar;
    }

    private function getArtIdFromUniqueIdentifier($filters)
    {
        $journal_codes = Journals::get('jnl_journal_code');
        $queries = [];
        $config_condition = Config('reportFilter.article.generic_form_elements.unique_identifier.condition');
        $match = $filters['match'];
        $filters = array_chunk($filters['fltr'], count($config_condition['options']));
        $cdtn_str_arr = [];
        $cdtn_str = '';
        $fixed_config = $config_condition['fixed_value'];
        foreach ($filters as $filter) {
            $cdtn_arr = [];
            foreach ($filter as $filter_value) {
                if ($filter_value) {
                    $cdtn = $fixed_config[$filter_value['fixed_value']];
                    foreach ($cdtn as $cdtn_value) {
                        if ($cdtn_value[2] ?? false) {
                            $cdtn_value[2] = "'" . str_replace('?', $filter_value['opt_value'], $cdtn_value[2]) . "'";
                        }
                        $cdtn_arr[] = implode(" ", $cdtn_value);
                    }
                }
            }
            $cdtn_str_arr[] = implode(" and ", $cdtn_arr);
        }
        if ($match == 'any') {
            $cdtn_str = "(" . implode(') or (', $cdtn_str_arr) . ")";
        } elseif ($match == 'none')
            $cdtn_str = "!(" . implode(') and !(', $cdtn_str_arr) . ")";
        else {
            $cdtn_str = implode(" and ", $cdtn_str_arr);
        }

        if ($cdtn_str) {
            $cdtn_str = "and $cdtn_str";
        }
        foreach ($journal_codes as $journal_code) {
            $queries[] = "Select distinct gdata_art_id as art_id from rvw_article_gnf_form_data_$journal_code->jnl_journal_code where gdata_art_id is not null $cdtn_str ";
        }
        if($queries ?? false){
            return [];
        }
        $query = implode(" UNION ALL ", $queries);

        $resp = DB::select($query);
        $art_id = array_column($resp, 'art_id');
        return $art_id;
    }

    public function getUniqueIdentifierValue($artp_ids, $column, $column_value, $select)
    {
        $jnls = Article_types::whereIn('artp_id', $artp_ids)->get('artp_jnl_id')?->toArray();
        $jnl_ids = array_column($jnls, 'artp_jnl_id');
        $journal_codes = Journals::whereIn('jnl_id', $jnl_ids)->get('jnl_journal_code');
        $cdtn_str = " $column in ($column_value) ";
        $queries = [];
        foreach ($journal_codes as $journal_code) {
            $queries[] = "Select distinct $select gdata_art_id as custom_art_id from rvw_article_gnf_form_data_$journal_code->jnl_journal_code where gdata_art_id is not null and $cdtn_str ";
        }

        if($queries == []){
            return [];
        }

        $query = implode(" UNION ALL ", $queries);

        $resp = DB::select($query);

        return $resp;
    }

    public function getAllFilters(Request $request)
    {
        try {
            $filter_for = $request->get('type');
            $columns = $request->get('column', []);
            $filterColumn = $request->get('filterColumn', null);
            $filter_config = Config('reportFilter');
            $return_ar = [];
            $report_config = config('report_generation');
            $cond_config = $report_config['condition_params']['type'];
            $initialFilterOption = [];
            $firstOption = new stdClass();
            $column_config = [];
            if($filterColumn){
            foreach ($columns as $key => $value) {
                if($filterColumn && $value[0] != $filterColumn['name']){
                    continue;
                }
                $column_data = $report_config['table_columns'];
                $comp_types_avaiable = [
                    'date' => 'date',
                    'string' => 'text',
                    'number' => 'number'
                ];
                $comp_type = ($column_data['article'][$value[1]] ?? $column_data['user'][$value[1]])['condition']['type'];
                $comp_type = $comp_types_avaiable[$comp_type] ?? 'text';
                $column_config['column_filter'][$value[0]] = [
                    'label' => $value[0],
                    'id' => $key,
                    'condition' => [
                        'fixed_option' => 'condition_params',
                        'fixed_value' => ['type' => ($column_data['article'][$value[1]] ?? $column_data['user'][$value[1]])['condition']['type']],
                        'options' => [
                            ['component' => $comp_type]
                        ]
                    ]
                ];
            }
        }
            $col_arr = [];
            foreach($columns as $value){
                $col_arr[$value[0]] = $value[1];
            }
            $fltr_headings = config('reportFilter.addtnl_data.filter_headings');
            $parent = $this->determineKeySourceArray($col_arr);
            if($parent != 'user' && !$filterColumn){
                $all_keys = array_keys($filter_config['article']);
                foreach($all_keys as $key => $value){
                    if($filter_config['user'][$value] ?? false){;
                        $filter_config['user'][$value] = array_merge($filter_config['article'][$value], $filter_config['user'][$value]);
                    }
                }
            }else{
                $filter_config['article'] = [];
                if($filterColumn){
                    $filter_config['user'] = [];
                }

            }
            $filter_config = array_merge($column_config, $filter_config['article'], $filter_config['user']);
            foreach ($filter_config as $main_key => $filters) {
                $item = new stdClass();
                $item->label = customTrans($fltr_headings[$main_key] ?? null) ?? str_replace('_', ' ', ucwords($main_key));
                $sub_options = [];
                foreach ($filters as $sub_key => $params) {
                    //if the selected column is converted to number of occurence, then option->component should be number
                    $set_count = false;
                    if($params['id'] ?? null){
                        $field_function = Reports_model::get_single_record("rep_field_function", 'rep_id=' . Rv_decrypt($params['id']));
                        if (!empty((array) $field_function) && $field_function->rep_field_function == 'count') {
                            $set_count = true;
                        }
                    }
                    $client_func = $params['client_functionality'] ?? null;
                    if($client_func && ($this->current_client->functionality->{$client_func} ?? null) === 'n')
                    {
                        continue;
                    }
                    $sub_item = new stdClass();
                    $sub_item->label = customTrans($params['label']);
                    $sub_item->value = $sub_key;
                    $sub_item->parent = $main_key;
                    $sub_item->id = $params['id'] ?? null;
                    $sub_options[] = $sub_item;
                    foreach ($params['condition']['options'] as $option) {
                        $sub_firstoption_item = new stdClass;
                        $cdnt_param_item = [];
                        if ($params['condition']['fixed_option'] == "condition_params") {
                            $fixed_value_type = ($set_count == true) ? 'number' : $params['condition']['fixed_value']['type'];
                            foreach ($cond_config[$fixed_value_type] as $key => $value) {
                                $cdnt_param_item[] = ['label' => $value[2] ?? str_replace('_', ' ', ucfirst($key)), 'value' => $key];
                            }

                            $sub_firstoption_item->options = $cdnt_param_item;
                        } else {
                            if (isset($option['explicit_fixed_option']) && count($option['explicit_fixed_option'])) {
                                $sub_firstoption_item->options = array_map(fn($i) => $params['condition']['fixed_option'][$i], $option['explicit_fixed_option']);
                            } else {
                                $sub_firstoption_item->options = $params['condition']['fixed_option'];
                            }
                            if (isset($option['explicit_fixed_option']) && count($option['explicit_fixed_option'])) {
                                $sub_firstoption_item->options = array_map(fn($i) => $params['condition']['fixed_option'][$i], $option['explicit_fixed_option']);
                            } else {
                                $sub_firstoption_item->options = $params['condition']['fixed_option'];
                            }
                        }
                        $sub_firstoption_item->component = ($set_count == true) ? 'number' : $option['component'];
                        $sub_firstoption_item->type = $option['type'] ?? null;
                        if (($option['search_value'] ?? false) == true) {
                            $sub_firstoption_item->search_value = $option['search_value'];
                        }
                        if (isset($option['dependent'])) {
                            $sub_firstoption_item->dependent = $option['dependent'];
                        }
                        if (isset($option['label'])) {
                            $sub_firstoption_item->label = customTrans($option['label']);
                        }
                        if (isset($option['enable_search'])) {
                            $sub_firstoption_item->enable_search = $option['enable_search'];
                        }
                        $firstOption->$sub_key[] = $sub_firstoption_item;
                    }
                }
                $item->options = $sub_options;
                $initialFilterOption[] = $item;
            }
            $return_ar['initialFilterOption'] = $initialFilterOption;
            $return_ar['firstOption'] = $firstOption;
            $array_date=platform_date_format();
            $return_ar['date_format'] = $array_date[$this->current_client->settings->cs_date_format];
            return $this->success('success', 200, $return_ar);
        } catch (Throwable $e) {
            dd($e);
        }
    }

    public function getFilterOptions(Request $request)
    {
        try {
            $post_data = $request->all();
            // $type = $post_data['type'];
            $parent = $post_data['parent'];
            $filter_key = $post_data['key'];
            $option_index = $post_data['index'];
            $value = $post_data['value'] ?? '';
            $pre_option = $post_data['pre_options'] ?? false;

            if ($pre_option) {
                // $filter_config = Config('report_generation')['table_columns'][$type];
                $report_config = config('report_generation')['table_columns'] ?? [];
                $filter_config = $report_config['article'][$filter_key] ?? $report_config['user'][$filter_key] ?? null;
                $option = $filter_config['pre_options'][$option_index];
            } else {
                $filter_config = Config('reportFilter')['article'][$parent][$filter_key] ?? Config('reportFilter')['user'][$parent][$filter_key];
                $option = $filter_config['condition']['options'][$option_index];
            }
            $limit = 25;
            $pre_option = $post_data['pre_options'] ?? false;

            $resp = null;
            if (isset($option['query'])) {
                if ($option['custom_table'] ?? false) {
                    $table_name = $option['custom_table']['name'];
                    $table_desc = $option['custom_table']['desc'];
                    DB::statement("CREATE TEMPORARY TABLE {$table_name} ENGINE=MEMORY AS {$table_desc} ");
                }
                $sql = $option['query'];
                if (($option['search_value'] ?? false) == true) {
                    $sql = "$sql limit $limit";
                }
                if (str_contains($sql, '?')) {
                    if ($value) {
                        if (is_array($value)) {
                            $bind_arr = ["$value[0]", "%$value[1]%"];
                        } else {
                            $bind_arr = ["%$value%"];
                        }
                    } else {
                        $bind_arr = ["%%"];
                    }
                    $resp =  DB::select($sql, $bind_arr);
                } else {
                    $resp = DB::select($sql);
                }
            } elseif (isset($option['custom_opt'])) {
                $resp = $option['custom_opt'];
            } elseif (isset($option['custom_opt_fn'])) {
                $resp = [];
                $fn = $option['custom_opt_fn']['fn'];
                $param = $option['custom_opt_fn']['param'];
                $arr = $this->$fn($param)[$param] ?? [];
                $resp = [];
                if ($option['custom_opt_fn']['type'] == 'key_value') {
                    foreach ($arr as $key => $value) {
                        $resp[] = ['value' => $key, 'label' => customTrans($value)];
                    }
                }elseif ($option['custom_opt_fn']['type'] == 'label_value') {
                    $resp = $arr;
                }
            }
            if (collect($resp)->contains(function ($item) {
                return isset($item->parent);
            })) {
                $resp = collect($resp)
                    ->groupBy('parent')
                    ->map(function ($items, $parent) {
                        return [
                            'label' => $parent,
                            'options' => $items->map(function ($item) {
                                return [
                                    'label' => $item->label,
                                    'value' => $item->value,
                                ];
                            })->values()->all()
                        ];
                    })
                    ->values()
                    ->all();
            }
            return $this->success('success', 200, $resp);
        } catch (Exception $e) {
            // print_r($e);die;
            dd($e);
            Log::warning($e->getMessage());
            Log::warning($e->getTraceAsString());
            return $this->failure(data: $e);
        }
    }
    /* 
        Function to return report bacis data, prefetched data if any and report column as array from the report config file
    */
    public function getReportSummary(Request $request)
    {
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'report_id'  => 'required'
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            //get all the report columns on the basis of report type
            $global_filter = $filters = $report_columns = $sorted_columns = $table_header_data = [];
            $client_dateformat = $this->current_client->settings->cs_date_format;
            $report_id = Rv_decrypt($post_data['report_id']);
            $rtn_arr['report_prefetch_data'] = new stdClass;
            $rtn_arr['report_basic_data'] = Reports_model::find($report_id);
            if (!empty($rtn_arr['report_basic_data'])) {
                $rtn_arr['status'] = 'success';
                $global_filter = json_decode($rtn_arr['report_basic_data']->rep_filter, true);
                $report_type = $rtn_arr['report_basic_data']->rep_type;
                $report_config = config('report_generation');
                $delimeters = $report_config['delimeters'];
                $field_type_functions = $report_config['field_type_functions']['string'];
                $key_configs = (isset($report_config['table_columns'])) ? $report_config['table_columns'] : [];
                if (count($key_configs) > 0) {
                    foreach ($key_configs as $heirarchy => $key_config) {
                        foreach ($key_config as $key => $value) {             
                            $funcKey = $value['client_functionality'] ?? null;
                            $skip_column = $value['skip_display'] ?? false;
                            if(($funcKey && ($this->current_client->functionality->{$funcKey} ?? null) === 'n') ||$skip_column === true) 
                            {
                                continue;
                            }
                            // $report_columns[] = array(
                            $report_columns[$value['parent']][] = array(
                                'id' => $key,
                                'name' => customTrans($value['label']),
                                'condition' => $value['condition'],
                                'pre_options' => isset($value['pre_options']) && $value['pre_options'] ? array_map(function ($value) {
                                    return ['component' => $value['component'] ?? null, 'search_value' => $value['search_value'] ?? false, 'label' => $value['label']];
                                }, $value['pre_options']) : null,
                                'show_status' => true,
                                'hierarchy' => $heirarchy,
                                'independant' => $value['independant'] ?? false,
                                'description' => customTrans($value['description'] ?? '')
                            );
                        }
                    }
                }
                $fn_column_values = [];
                $report_child_columns = Reports_model::get_all_records("rep_id, rep_col_value, rep_fields, rep_field_function, rep_values_seperator, rep_title, rep_show_total_type, rep_column_order, rep_filter", 'rep_parent =' . $report_id, 'rep_field_order');
                if (count($report_child_columns) > 0) {
                    $i = 1;
                    $tab = '&emsp;';
                    foreach ($report_child_columns as $child) {
                        $fields = json_decode($child->rep_fields, true)[0];
                        $column_data_config = ($key_configs['article'][$fields] ?? $key_configs['user'][$fields]);
                        $client_func = $column_data_config['client_functionality'] ?? null;
                        if($client_func && ($this->current_client->functionality->{$client_func} ?? null) === 'n')
                        {
                            continue;
                        }
                        $table_header_data[] = ['id' => Rv_encrypt($child->rep_id), 'name' => $child->rep_title, 'field_name' => $fields, 'field_id' => $child->rep_col_value];
                        $keys[$child->rep_title] = $fields;
                        $fn_column_values[$child->rep_title] = $child->rep_col_value ?? null;
                        $filter_arr = json_decode($child->rep_filter);
                        $j = 1;
                        $applied_filter = $operator = '';
                        if (isset($filter_arr->fltr) && !empty($filter_arr->fltr)) {

                            if (count($filter_arr->fltr) > 1) {
                                $operator = $i . '. <b>' . ucfirst($filter_arr->match) . '</b>' . customTrans('reports.following_true') . '</br>';
                            }
                            foreach ($filter_arr->fltr as $each_filters) {
                                /* $timestamp = '';
                                if(!empty($each_filters->opt_value) && $this->isValidDateTimeStamp($each_filters->opt_value) == true && Carbon::parse($each_filters->opt_value) == true){
                                    $timestamp = strtotime($each_filters->opt_value);
                                    $each_filters->opt_value = date($client_dateformat, $timestamp);
                                } */
                               if (is_string($each_filters->opt_value) && (preg_match('/^\d{2}-\d{2}-\d{2}$/', $each_filters->opt_value) || preg_match('/^\d{2}-\d{2}-\d{4}$/', $each_filters->opt_value) || preg_match('/^\d{4}-\d{2}-\d{2}$/', $each_filters->opt_value))) {
                                    $each_filters->opt_value = Carbon::createFromFormat('Y-m-d', $each_filters->opt_value)->format($this->current_client->settings->cs_date_format);
                                }
                                $col_desc = customTrans(($key_configs['article'][$fields] ?? $key_configs['user'][$fields])['label']);
                                $col_desc = trim(preg_replace('/\s*\([^)]*\)/', '', $col_desc));
                                $col_desc = preg_replace('~[^a-zA-Z0-9]+~', ' ', $col_desc);
                                $applied_filter .= ((count($filter_arr->fltr) > 1) ? $tab : '') . $i . '.' . ((count($filter_arr->fltr) > 1) ? ($j . '.') : ' ') . ' ' . " Column filter <b>" . $col_desc . "</b> " . str_replace('_', ' ', $each_filters->fixed_value) . ((!empty($each_filters->opt_value)) ? (' <b>' . $each_filters->opt_value . '</b>.') : '.') . '</br>';
                                $j++;
                            }
                            $applied_filter = $operator . $applied_filter;
                        }
                        // print_r(($applied_filter));die;
                        // $report_columns[] = array(
                        $report_columns['selected_columns'][] = array(
                            'id' => Rv_encrypt($child->rep_id),
                            'name' => $child->rep_title,
                            'condition' => ($key_configs['article'][$fields] ?? $key_configs['user'][$fields])['condition'],
                            'show_status' => false,
                            'always_disable' => true,
                            'field_function' => $field_type_functions[$child->rep_field_function]['label'],
                            'field_id' => $child->rep_col_value,
                            'field_name' => $fields,
                            'field_label' => customTrans(($key_configs['article'][$fields] ?? $key_configs['user'][$fields])['label']),
                            'field_filters' => $applied_filter,
                            'hasFilter' => ($child->rep_filter ? true : false)
                        );
                        if (in_array($child->rep_column_order, array('a', 'd'))) {
                            $sorted_columns = array(
                                'name' => $child->rep_title,
                                'order' => ($child->rep_column_order == 'a') ? 'asc' : 'desc'
                            );
                        }
                        if ($child->rep_filter) {
                            $filters[$child->rep_title] = json_decode($child->rep_filter, true);
                        }
                        if ($child->rep_field_function == 'group_concat') {
                            $filters[$child->rep_title]['view'] = array(
                                'mode'      => $child->rep_field_function,
                                'separator' => ($child->rep_values_seperator) ? $delimeters[$child->rep_values_seperator]['value'] : ''
                            );
                        } elseif ($child->rep_field_function == 'count') {
                            $filters[$child->rep_title]['view'] = array(
                                'mode'      => $child->rep_field_function
                            );
                        }
                        $i++;
                    }
                    $limit  = $post_data['per_page'] ? $post_data['per_page'] : 25;
                    $req = array(
                        'report_id' => $report_id,
                        'keys'      => $keys,
                        'fn_column_values' => $fn_column_values,
                        'filters'   => $filters,
                        'sort_by'   => $sorted_columns,
                        'global_filter' => $global_filter,
                        'limit'         => $limit,
                        'report_child_rows' => $report_child_columns,
                        'force_reload' => $post_data['forceReload'] ?? false
                    );
                    // dd($req);
                    $rtn_arr['xml_data'] = array();
                    $rtn_arr['report_total_count']   = '';
                    // if ($data_Element->item(0)->nodeValue != '' && json_decode($data_Element->item(0)->nodeValue)->current_page == $post_data['page'] && $post_data['forceReload'] == false) {
                    //     $rtn_arr['report_prefetch_data'] = json_decode($data_Element->item(0)->nodeValue);
                    //     $generated_report_total_count_Element = $xml->getElementsByTagName('generated_report_total_count');
                    //     if ($generated_report_total_count_Element->item(0)->nodeValue != '') {
                    //         $rtn_arr['report_total_count'] = json_decode($generated_report_total_count_Element->item(0)->nodeValue);
                    //     }
                    // } else {
                    $result_set = $this->buildQuery($req);
                    $rtn_arr['report_prefetch_data'] = $result_set['generated_report'];
                    $types = Reports_model::whereNotNull('rep_parent')->where('rep_parent', $report_id)->distinct()->get('rep_fields')?->toArray() ?? [];
                    $type_arr = [];
                    $col_config = config('report_generation.table_columns');
                    foreach($types as $column_key){
                        $col = json_decode($column_key['rep_fields'])[0];
                        if($col_config['article'][$col] ?? false){
                            $inde = $col_config['article'][$col]['independant'] ?? false;
                            if(!$inde){
                                $type_arr[] = 'article';
                            }
                        }
                        if($col_config['user'][$col] ?? false){
                            $inde = $col_config['user'][$col]['independant'] ?? false;
                            if(!$inde){
                                $type_arr[] = 'user';
                            }
                        }
                    }
                    $rtn_arr['drag_report_type'] = array_unique($type_arr);
                    $rtn_arr['report_total_count']   = json_decode($result_set['generated_total_count']);
                    $rtn_arr['xml_data']['generated_date'] = Cache::store('report_redis')->get("reportDateFor_" . $report_id);
                    // }
                }
                //Rendering global filters starts
                $global_filter_arr = array();
                if (!empty($rtn_arr['report_basic_data']->rep_filter) && $rtn_arr['report_basic_data']->rep_filter != null) {
                    //getting filter config
                    $filter_conf = Config('reportFilter');
                    //getting all applied global filters form the parent report data.
                    $filter_data = json_decode($rtn_arr['report_basic_data']->rep_filter);
                    $i=1;
                    //filter from the parent filter level like article, flags_and_labesl, users...
                    foreach($filter_data as $parent => $filter){
                        if($parent == 'match'){
                            continue;
                        }
                        // filter from the filter level like article_id, article_code...
                        foreach ($filter as $filter_key => $filter_arr) {
                            $filt_conf = $filter_conf['article'][$parent] ?? $filter_conf['user'][$parent] ?? [];
                            $fixed_label = customTrans($filt_conf[$filter_key]['label']);
                            $fixed_label_arr = array();
                            if(str_contains($fixed_label, ' and ')) {
                                $fixed_label_arr = explode(' and ' ,$fixed_label);
                            }
                            $fixed_options = $filt_conf[$filter_key]['condition']['fixed_option'] ?? [];
                            $options = $filt_conf[$filter_key]['condition']['options'] ?? [];
                            /* 
                                Three types of option setup
                                    1. options with single component
                                    2. options with 2 component
                                    3. options with 2 componnets where one component doesnt have fixed option
                            */
                            $option_count = count($options ?? []);
                            $k = 1;
                            $j = 1;
                            $operator_label = '';
                            $opted_value = '';
                            $global_filter_str = array();
                            //Filter_option can be array or string
                            //condition_params should be mapped from the condition_params array in report_generation.php
                            $condition_params = false;
                            if (is_string($fixed_options) && $fixed_options == 'condition_params') {
                                //otherwise it can be accessed from the applied filter
                                $condition_params = true;
                            }
                            //filter from the applied filter level.
                            if(isset($filter_arr->fltr) && !empty($filter_arr->fltr)){
                                $kk = 0;
                                $global_filter_str['match'] = (($option_count == 1 && count($filter_arr->fltr)>1) || ($option_count > 1 && count($filter_arr->fltr)>2)) ? '<b>'.(ucfirst($filter_arr->match).'</b>' . customTrans('reports.following_true') ) : '';
                                $tmp_filter_str = '';
                                foreach($filter_arr->fltr as $applied_filter){
                                    $operator_label = $applied_filter->fixed_value;
                                    if($condition_params == false){
                                        $matched = array_filter($fixed_options, function ($item) use ($applied_filter) {
                                            return $item['value'] === $applied_filter->fixed_value;
                                        });
                                        $operator_label = reset($matched)['label'] ?? null;
                                    }
                                    $operator_label = strtolower(str_replace('_', ' ', $operator_label));
                                    if(!is_array($applied_filter->opt_value)){
                                        $opted_value = $applied_filter->opt_value;
                                        if (is_string($opted_value) && (preg_match('/^\d{2}-\d{2}-\d{2}$/', $opted_value) || preg_match('/^\d{2}-\d{2}-\d{4}$/', $opted_value) || preg_match('/^\d{4}-\d{2}-\d{2}$/', $opted_value))) {
                                            $opted_value = Carbon::createFromFormat('Y-m-d', $opted_value)->format($this->current_client->settings->cs_date_format);
                                        }
                                        if(isset($options[$kk]['options_from'])){//isset($options[$kk]['search_value']) && $options[$kk]['search_value'] == true && 
                                            $option_from = $options[$kk]['options_from'];
                                            $search_key = explode(' ', $option_from['columns'][0])[0];
                                            $model_class = (new ReflectionClass('App\\Models\\' . $options[$kk]['options_from']['model']))->newInstance();
                                            $search_result = $model_class->where($search_key, $applied_filter->opt_value)->get([DB::raw($options[$kk]['options_from']['columns'][0]), DB::raw($options[$kk]['options_from']['columns'][1])])?->first()?->toArray();
                                            $opted_value = ($search_result['label'] ?? $opted_value);
                                        }elseif(isset($options[$kk]['custom_opt'])){
                                            // print_r($search_result);die;
                                            foreach ($options[$kk]['custom_opt'] as $custom_opt) {
                                                if ($applied_filter->opt_value == $custom_opt['value'])
                                                    $opted_value = $custom_opt['label'];
                                            }
                                        }elseif(isset($options[$kk]['custom_opt_fn'])){
                                            $fn = $options[$kk]['custom_opt_fn']['fn'];
                                            $param = $options[$kk]['custom_opt_fn']['param'];
                                            $arr = $this->$fn($param)[$param] ?? [];
                                            $resp = [];
                                            if ($options[$kk]['custom_opt_fn']['type'] == 'key_value') {
                                                foreach ($arr as $key => $value) {
                                                    $resp[] = ['value' => $key, 'label' => $value];
                                                }
                                            } elseif ($options[$kk]['custom_opt_fn']['type'] == 'label_value') {
                                                $resp = $arr;
                                            }
                                            foreach ($resp as $custom_opt) {
                                                if ($applied_filter->opt_value == $custom_opt['value'])
                                                    $opted_value = $custom_opt['label'];
                                            }
                                        }
                                        if($option_count > 1){
                                            // $fixed_label = (($kk == ($option_count-1))?'':($fixed_label . ' '));
                                            $label = '';
                                            if(!empty($fixed_label_arr) && isset($fixed_label_arr[$kk])){
                                                $label = $fixed_label_arr[$kk] . ' ';
                                            }else{
                                                $label = $fixed_label . ' ';
                                            }
                                            if(!empty($tmp_filter_str)){
                                                $tmp_filter_str .= ', ';
                                                if(empty($fixed_label_arr)){
                                                    $label = ' ';
                                                }
                                            }
                                            $tmp_filter_str .= '<b>' . $label . '</b>' . $operator_label . ' <b>' . $opted_value .'</b>';
                                            if($j >= ($option_count-1)){
                                                $global_filter_str[$j] = $tmp_filter_str;
                                                // $tmp_filter_str = '';
                                            }
                                            if($kk == ($option_count-1)){
                                                $tmp_filter_str = '';
                                            }
                                            // $global_filter_str[$j][$kk] = $fixed_label . $operator_label . ' ' . $opted_value;
                                        }else{
                                            $global_filter_str[$j] = '<b>' . $fixed_label . '</b> ' . $operator_label . ' <b>' . $opted_value . '</b>';
                                        }
                                    }else{
                                        $model_class = (new ReflectionClass('App\\Models\\' . $options[$kk]['options_from']['model']))->newInstance();
                                        $option_from = $options[$kk]['options_from'];
                                        $search_key = explode(' ', $option_from['columns'][0])[0];
                                        $search_result_arr = $model_class->whereIn($search_key, $applied_filter->opt_value)->get([DB::raw($options[$kk]['options_from']['columns'][0]), DB::raw($options[$kk]['options_from']['columns'][1])])?->toArray();
                                        $opted_value = implode(', ', array_column($search_result_arr, 'label'));
                                        $global_filter_str[$j] = '<b>' . $fixed_label . '</b> ' . $operator_label . ' <b>' . $opted_value . '</b>';
                                        // print_r($search_result);
                                    }
                                    if($option_count == $k){
                                        $j++;
                                        $kk=0;
                                        $k = 0;
                                    }else{
                                        if(($option_count <= 1) || ($kk == ($option_count-1))){
                                            $j++;
                                        }
                                        $kk++;
                                    }
                                    $k++;
                                }
                            } 
                            $global_filter_arr[$parent][$i] = $global_filter_str;
                            $i++;
                        }
                    }
                }             
                $clm = [];
                foreach($report_columns as $prnt_key => $val_arr){
                    foreach($val_arr as $child_key => $val){
                        if($clm[$val['id']] ?? false){
                            unset($report_columns[$prnt_key][$child_key]);
                        }else{
                            $clm[$val['id']] = true;
                        }
                    }
                }
                $formatted_report_columns = array_map(function ($k, $v) {
                    $arr = array(
                        'parent' => customTrans($k),
                        'child'  => $v,
                    );
                    return $arr;
                }, array_keys($report_columns), $report_columns);
                // print_r($formatted_report_columns);die;
                $rtn_arr['report_table_header'] = $table_header_data;
                $rtn_arr['sorted_columns']      = $sorted_columns;
                $rtn_arr['report_columns']      = $formatted_report_columns;
                $rtn_arr['global_filters']      = $global_filter_arr;
            }
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            $data = ['msg' => 'Unable to configure this report with the this action.'];
            return  $this->failure('Failed', 500, $data);
        }
    }

    private function configRollbackFromCache($report_id): void
    {
        $cacheKey = 'report_previous_config_' . $report_id;

        $backup = Cache::store('report_redis')->get($cacheKey);

        if (!$backup) {
            throw new \RuntimeException("No backup found in cache for {$cacheKey}");
        }
        
        DB::transaction(function () use ($backup, $report_id) {
            try{
            $ids = [];
            foreach ($backup as $row) {
                $fresh = new Reports_model();
                $fresh->fill($row->getAttributes());
                $fresh->rep_id = $row->rep_id; // make sure primary key is preserved
                $fresh->exists = $row->exists; // tell Eloquent whether it’s an update or insert
                $fresh->save();

                $ids[] = $fresh->rep_id;
            }
            $report_init_data = Reports_model::where('rep_parent', $report_id)->whereNotIn('rep_id',$ids)->delete();
        }catch(Exception $e){
            Log::warning($e->getMessage());
        }
        });
    }


    function column_name_exists_in_report($existing_fields, $label_in_config, $num = 0)
    {
        $label_in_config = trim($label_in_config);
        if ($num) {
            $label_in_config .= ' ' . $num;
        }
        foreach ($existing_fields as $k => $val) {
            if (trim($val->rep_title) == trim($label_in_config)) {
                return true;
            }
        }
        return false;
    }
    /* 
     This function is used for actions like drag, drop and duplicating columns
     report_id, field_id and mode are required.
    */
    public function editReportSummary(Request $request)
    {
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'report_id'  => 'required',
                'mode'  => 'required'
            );
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $input_arr = array(
                'input' => $post_data['report_id'],
                'type'  => 'number',
                'rv_enc_data' => true
            );
            $report_id_validate = $this->Rv_validator($input_arr);     
            if($report_id_validate == false)
            {
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            if ($post_data['selected_role'] ?? null) {
                $post_data['selected_role'] = decrypt_link($post_data['selected_role']);
            }
            $report_id = Rv_decrypt($post_data['report_id']);
            $mode = $post_data['mode'];
            $report_meta_data = Reports_model::get_single_record("rep_locked, rep_type, rep_values_seperator, rep_filter", 'rep_id=' . $report_id);
            // $report_type = $report_meta_data->rep_type;
            $report_config = config('report_generation');
            $required_attch_column = false;
            $append_id = '';
            $config_key_name = 'table_columns';
            if(isset($post_data['append_mode']))
            {
                $config_key_name = 'addition_column';
            }
            $key_config = $report_config[$config_key_name] ?? [];
            if ($report_meta_data->rep_locked == 'y') {
                $rtn_arr = array(
                    'msg' => customTrans('reports.locked_report'),
                    'alert_type' => 'alert_box',
                    'status' => 'error',
                );
            }
            $report_table = (new \App\Models\Reports_model())->getTable();
            $report_init_data = Reports_model::where('rep_id', $report_id)->Orwhere('rep_parent', $report_id)->get();
            cache::store('report_redis')->forget('report_previous_config_'.$report_id);
            Cache::store('report_redis')->rememberForever("report_previous_config_" . $report_id, function () use ($report_init_data) {
                return $report_init_data;
            });
            DB::beginTransaction();
            $this->report_xml($report_id, 'write', null, true);
            if ($mode == 'delete_column') {
                $criteria = 'rep_title = "' . $post_data['field_id'] . '" AND rep_parent =' . $report_id;
                $rep_id = Reports_model::get_single_record('rep_id', $criteria)->rep_id;
                $rem_filter_str = Reports_model::get_single_record('rep_filter', 'rep_id =' . $report_id)->rep_filter;

                /* if (!empty($rem_filter_str->rep_filter)) {
                    $rem_filters = json_decode($rem_filter_str->rep_filter);
                    if (isset($rem_filters->$rep_id)) {
                        unset($rem_filters->$rep_id);
                        Reports_model::update_record(
                            array(
                                'rep_filter' => json_encode($rem_filters)
                            ),
                            array(
                                'rep_id' => decrypt_link($report_id)
                            ),$current_user
                        );
                    }
                } */
                // $response = '';
                $response = Reports_model::delete_records('rep_id =' . $rep_id, '', $current_user);
                /*  After deleting check whether article columns are left or not. if there is not article columns are left then, remove all the article related global filters.*/
                $filterConfig = Config('reportFilter')['user'];
                $global_filters = json_decode($rem_filter_str) ?? null;
                $article_filter = Reports_model::get_single_record('count(rep_id) as cnt', 'rep_parent =' . $report_id . ' AND rep_type = \'article\' ');
                // print_r($article_filter->cnt);die;
                if ($global_filters != null && isset($article_filter->cnt) && $article_filter->cnt == 0) {
                    foreach ($global_filters as $parentkeys => $innerFilters) {
                        if ($parentkeys == 'match') {
                            continue;
                        }
                        if (isset($filterConfig[$parentkeys])) {
                            foreach ($innerFilters as $childKeys => $filters) {
                                if (!isset($filterConfig[$parentkeys][$childKeys])) {
                                    unset($global_filters->$parentkeys->$childKeys);
                                    if(isset($global_filters->$parentkeys) && empty((array) $global_filters->$parentkeys)){
                                        unset($global_filters->$parentkeys);
                                    }
                                }
                            }
                        } else {
                            unset($global_filters->$parentkeys);
                        }
                    }
                    if (array_keys(get_object_vars($global_filters)) === ['match']) {
                        $global_filters = null;
                    }else{
                        $global_filters = json_encode($global_filters);
                    }
                    Reports_model::update_record(
                        array(
                            'rep_filter' => $global_filters
                        ),
                        array(
                            'rep_id' => $report_id
                        ),
                        $current_user
                    );
                }

                if ($response) {
                    $rtn_arr = array(
                        'msg' => customTrans('reports.column_deleted'),
                        'status' => 'success'
                    );
                } else {
                    throw new Exception(customTrans('Failed to delete column'));
                }
            } elseif ($mode == 'order_column') {
                $criteria = 'rep_title = "' . $post_data['field_id'] . '" AND rep_parent =' . $report_id;
                $field_data = Reports_model::get_single_record('rep_id,rep_column_order', $criteria);
                $field_id = $field_data->rep_id;
                $rep_column_order = null;
                if ($field_data->rep_column_order == null) {
                    $rep_column_order = 'a';
                } else if ($field_data->rep_column_order == 'a') {
                    $rep_column_order = 'd';
                } else if($field_data->rep_column_order == 'd'){
                    $rep_column_order = null;
                }
                if($rep_column_order){
                    Reports_model::update_record(
                        array(
                            'rep_column_order' => null
                        ),
                        array(
                            'rep_parent' => $report_id
                        )
                    );
                }
                $response = Reports_model::update_record(
                    array(
                        'rep_column_order' => $rep_column_order
                    ),
                    array(
                        'rep_id' => $field_id
                    ),$current_user
                );
                if ($response) {
                    $rtn_arr = array(
                        'msg' => '',
                        'status' => 'success'
                    );
                } else {
                    throw new Exception(customTrans('Failed to update column'));
                }
            } elseif (isset($post_data['field_id']) && !empty($post_data['field_id'])) {
                // dragged from the sidebar and dropped into the table 
                $k = $duplicate_cnt = 0;
                $field_id = $post_data['field_id'];
                $report_type = isset(config('report_generation')[$config_key_name]['article'][$field_id]) ? 'article' : 'user';
                //getting all child columns if any
                $report_fields = Reports_model::get_all_records('*', 'rep_parent=' . $report_id);
                if (isset($mode) && $mode == 'duplicate_column') {
                    /*
                if (isset($mode) && $mode == 'duplicate') {
                    /*
                        code for report column duplication               
                        $field_id -  here needs to be label and not id
                     */
                    $field_data = Reports_model::get_single_record('*', 'rep_parent =' . $report_id . ' AND rep_title = "' . $field_id . '"');
                    //get current field location
                    $field_order = $field_data->rep_field_order + 1;
                    $data = json_decode($report_meta_data->rep_filter, TRUE);
                    $rep_title = $field_id;
                    $field_id = json_decode($field_data->rep_fields);
                    $field_id = $field_id[0];
                    $sql = 'SELECT 
                               count(rep_id) as count
                            FROM '. $report_table .' 
                            WHERE `rep_parent` = ' . $report_id . ' AND `rep_title` LIKE \'' . $rep_title . '%\' AND rep_field_function=\'' . $field_data->rep_field_function . '\'';
                    $select_data = Reports_model::get_records_by_raw_query($sql);
                    $duplicate_cnt = $select_data[0]->count;
                    $rep_field_title = $rep_title;
                }
                $report_title_no = 0;
                $rep_field_order = array(0 => 0);
                $label_in_config = '';
                $config_field = $key_config['article'][$field_id] ?? $key_config['user'][$field_id] ?? null;
                if (isset($config_field)) {
                    if(isset($config_field['append_column']))
                    {
                        $required_attch_column = true;
                        $append_id = $config_field['append_column'];
                    }
                    $label_in_config = customTrans($config_field['label']);
                }
                for ($i = 0; $i < count($report_fields); $i++) {
                    $rep_field_order[] = $report_fields[$i]->rep_field_order;
                }
                $label_in_config = trim(preg_replace('/[\(\[]if\b.*?[\)\]]/i', '', $label_in_config));
                $label_in_config = trim(preg_replace('/[\(\[]e\b.*?[\)\]]/i', ' ', $label_in_config));
                while ($this->column_name_exists_in_report($report_fields, $label_in_config, $report_title_no)) {
                    $report_title_no++;
                }
                $field_function = 'group_by';
                $seperator = $report_meta_data->rep_values_seperator;
                if (isset($config_field['condition']['default_field_function']) && isset($config_field['condition']['default_delimeters'])) {
                    $field_function = $config_field['condition']['default_field_function'];
                    $seperator = $config_field['condition']['default_delimeters'];
                }
                $insert_data = array(
                    'rep_type' => $report_type,
                    'rep_field_function' => $field_function,
                    'rep_values_seperator' => $seperator,
                    'rep_parent' => $report_id,
                    'rep_field_order' => max($rep_field_order) + 1,
                    'rep_fields' => json_encode([$field_id]),
                    'rep_col_value' => $post_data['col_value'] ?? null,
                    'rep_fields' => json_encode([$field_id]),
                    'rep_col_value' => $post_data['col_value'] ?? null,
                );
                if ($duplicate_cnt > 0) {
                    // for duplication mode
                    $rep_field_title = $rep_field_title . ' ' . $duplicate_cnt;
                    $insert_data['rep_type'] = $report_type;
                    $insert_data['rep_col_value'] = $field_data->rep_col_value;
                    $insert_data['rep_fields'] = $field_data->rep_fields;
                    $insert_data['rep_field_function'] = $field_data->rep_field_function;
                    $insert_data['rep_values_seperator'] = $field_data->rep_values_seperator;
                    $insert_data['rep_ratio_base_filter'] = $field_data->rep_ratio_base_filter;
                    $insert_data['rep_filter'] = $field_data->rep_filter;
                    $insert_data['rep_field_order'] = $field_order;
                    $insert_data['rep_show_total_type'] = $field_data->rep_show_total_type;
                    $sql = 'UPDATE ' . $report_table . ' set rep_field_order=rep_field_order+1  WHERE `rep_parent` = ' . $report_id . ' AND `rep_field_order` >= ' . $field_order;
                    $select_data = Reports_model::get_records_by_raw_query($sql);
                } else {
                    //for drag and drop modes
                    if ($post_data['column_heading'] ?? null) {
                        $rep_field_title = $post_data['column_heading'];
                    } else {
                        if ($post_data['column_heading'] ?? null) {
                            $rep_field_title = $post_data['column_heading'];
                        } else {
                            $rep_field_title = customTrans(config("report_generation.$config_key_name.article.$field_id", config("report_generation.$config_key_name.user.$field_id"))['label']);
                            if ($rep_field_title == 'Article abstract' && isset($this->current_client->modules->mdl_review_for_doc) && $this->current_client->modules->mdl_review_for_doc == 'y') {
                                $rep_field_title = 'Opening paragraph';
                            }
                            $rep_field_title = trim(preg_replace('/[\(\[]if\b.*?[\)\]]/i', '', $rep_field_title));
                            $rep_field_title = trim(preg_replace('/[\(\[]e\b.*?[\)\]]/i', ' ', $rep_field_title));
                            $insert_data['rep_fields'] = '["' . $field_id . '"]';
                        }
                        $rep_field_title = trim(preg_replace('/[\(\[]if\b.*?[\)\]]/i', '', $rep_field_title));
                        $rep_field_title = trim(preg_replace('/[\(\[]e\b.*?[\)\]]/i', ' ', $rep_field_title));
                        $insert_data['rep_fields'] = '["' . $field_id . '"]';
                    }
                    $rep_field_title_bkp = $rep_field_title;
                    $find_duplicate_sql = 'SELECT 
                        count(rep_id) as count  FROM ' . $report_table . ' WHERE `rep_parent` = ' . $report_id . ' AND `rep_title` LIKE \'%' . $rep_field_title . '%\'';
                    $rep_field_title_duplicate = Reports_model::get_records_by_raw_query($find_duplicate_sql);
                    if ($rep_field_title_duplicate[0]->count > 0) {
                        $k = $report_title_no;
                        if ($k > 0)
                            $rep_field_title = $rep_field_title_bkp . ' ' . $k;
                    }
                }
                $insert_data['rep_title'] = customTrans($rep_field_title);
                $new_field_id = Reports_model::insert_record($insert_data, $current_user);
                if (isset($field_data) && !empty($data[$field_data->rep_id])) {
                    $fltr = array($new_field_id => $data[$field_data->rep_id]);
                    $total = $fltr + $data;
                    $new_filter['rep_filter'] = json_encode($total);
                    Reports_model::update_record($new_filter, array('rep_id' => $report_id), $current_user);
                }
                if (!empty($new_field_id)) {
                    $rtn_arr = array(
                        'msg' => '',
                        'status' => 'success'
                    );
                } else {
                    throw new Exception(customTrans('Failed to add column'));
                }
            } elseif (isset($post_data['field_order']) && !empty($post_data['field_order']) && count($post_data['field_order']) > 0) {
                //reordering the columns
                $report_columns = Reports_model::get_all_records('*', 'rep_parent=' . $report_id);
                $field_order = array_column($post_data['field_order'], 'name');
                $rep_field_order = '';
                $updated_columns = array();
                foreach ($report_columns as $key => $rep) {
                    if ($rep->rep_field_order != array_search($rep->rep_title, array_values($field_order))) {
                        $rep_field_order = array_search($rep->rep_title, array_values($field_order));
                        array_push($updated_columns, array(
                            'rep_id'    => $rep->rep_id,
                            'rep_field_order' => array_search($rep->rep_title, $field_order),
                        ));
                        Reports_model::update_record(array('rep_field_order' => array_search($rep->rep_title, $field_order)), array('rep_id' => $rep->rep_id), $current_user);
                    }
                }
                //update batch desont have current user update
/*                 if (count($updated_columns) > 0) {
                    Reports_model::update_batch($updated_columns, 'rep_id', $current_user);
                    // $report_rearranged_columns = $this->return_report_child_data($report_id, $report_type);
                    $rtn_arr = array(
                        'msg' => '',
                        'status' => 'success',
                        // 'report_columns' => $report_rearranged_columns['report_columns']
                    );
                } */
            }
            if ($post_data['selected_role'] ?? null) {
                $rep_title_prefix = null;
                $rep_col_value = null;
                if (isset($post_data['selected_role'])) {
                    $rep_col_value = $post_data['selected_role'];
                    if ($post_data['rename_column'] ?? false) {
                        $rep_title_prefix = Roles::find($post_data['selected_role'], ['role_name'])->role_name;
                    }
                }
                DB::update("UPDATE $report_table SET rep_col_value = ?,rep_title = concat(ifnull(concat(?, ' '), ''), rep_title) WHERE rep_type = 'user' and rep_parent = ?  and rep_col_value is null", [$rep_col_value, $rep_title_prefix, $report_id]);
            }
            DB::commit();
            if($required_attch_column == false)
            {
                return $this->success($rtn_arr['status'], 200, $rtn_arr);
            }
            else
            {
                $newRequest = new Request([
                    'field_id' => $append_id,
                    'mode'     => $mode,
                    'report_id' => $post_data['report_id'],
                   // 'append_mode' => true
                ]);
                return $this->editReportSummary($newRequest);
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function getFieldData(Request $request)
    {
        try {
            $post_data   = $request->all();
            $validationArr = array(
                'report_id'  => 'required'
            );
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $report_id = Rv_decrypt($post_data['report_id']);
            $parent_criteria = 'rep_id =' . $report_id;
            $report_parent_data = Reports_model::get_single_record('*', $parent_criteria);
            $criteria = 'rep_parent =' . $report_id . ' AND rep_title ="' . $post_data['field_title'] . '"';
            $report_data = Reports_model::get_single_record('*', $criteria);
            $report_type = $report_parent_data->rep_type;
            $field_name = json_decode($report_data->rep_fields)[0];
            if (strpos($field_name, '##')) {
                $field_name = $report_type . '_unique_fields';
            }
            if (json_decode($report_parent_data->rep_filter) != '') {
                $filters_old = json_decode($report_parent_data->rep_filter);
            }

            // print_r($field_name);die;
            $field_type_functions = $this->convert_to_selectbox_options(Config('report_generation')['field_type_functions']['string']);
            $show_column_total_type = $this->convert_to_selectbox_options(Config('report_generation')['show_column_total_type']);
            $delimeters = $this->convert_to_selectbox_options(Config('report_generation')['delimeters']);

            $rtn_arr = array(
                'status'                     => 'success',
                'field_id'                   => Rv_encrypt($report_data->rep_id),
                'field_title'                => $report_data->rep_title,
                'col_value'                  => $report_data->rep_col_value,
                'field_type_functions'       => $field_type_functions,
                'selected_field_type'        => $report_data->rep_field_function,
                'show_column_total_type'     => $show_column_total_type,
                'selected_column_total_type' => $report_data->rep_show_total_type,
                'delimeters'                 => $delimeters,
                'selected_delimeters'        => $report_data->rep_values_seperator
            );
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    function convert_to_selectbox_options($raw_data)
    {
        $rtn_data = array();
        if (count($raw_data) > 0) {
            foreach ($raw_data as $key => $value) {
                $rtn_data[] = array('label' => $value['label'], 'value' => $key);
            }
        }
        return $rtn_data;
    }
    public function editFieldData(Request $request)
    {
        try {
            $post_data   = $request->all();
            $current_user = $this->get_current_user_details();
            $validationArr = array(
                'report_id'  => 'required',
                'field_id'   => 'required',
                'column_heading'   => 'required',
                'field_function'   => 'required',
            );
            $validator = Validator::make($request->all(), $validationArr);
            if ($validator->fails()) {
                return  $this->failure('Failed', 422, $validator->errors());
            }
            $rtn_arr = array(
                'status' => 'error',
                'msg' => ''
            );
            $input_arr = array(
                'input' => $post_data['report_id'],
                'type'  => 'number',
                'rv_enc_data' => true
            );
            $report_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['field_id'],
                'type'  => 'number',
                'rv_enc_data' => true
            );
            $field_id_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['column_heading'],
                'type'  => 'string'
            );
            $column_heading_validate = $this->Rv_validator($input_arr);
            $input_arr = array(
                'input' => $post_data['field_function'],
                'type'  => 'string'
            );
            $field_function_validate = $this->Rv_validator($input_arr);
            if ($report_id_validate == false && $field_id_validate == false && $column_heading_validate == false && $field_function_validate == false) {
                $arraymsg['mesage'] = customTrans('validation.notvalid');
                return $this->warning("Failed", 200, $arraymsg);
            }
            $report_id = Rv_decrypt($post_data['report_id']);
            $field_id = Rv_decrypt($post_data['field_id']);
            //checking duplicate field id
            $select = '*';
            $criteria = 'rep_title = "' . $post_data['column_heading'] . '" AND rep_id != ' . $field_id . " AND rep_parent = " . $report_id;
            $duplicate_field_search = Reports_model::get_all_records($select, $criteria);
            if (count($duplicate_field_search) != 0) {
                $rtn_arr = array(
                    'msg' => customTrans('reports.duplicate_column_title'),
                    'alert_type' => 'alert_box',
                    'status' => 'warning',
                );
            } else {
                $update_data = array(
                    'rep_title' => $post_data['column_heading'],
                    'rep_field_function' => $post_data['field_function'],
                    'rep_values_seperator'  => ($post_data['field_function'] == 'group_concat') ? $post_data['delimeter'] : "",
                    'rep_show_total_type'   => $post_data['show_total'] ?? null
                );
                if($post_data['originalFieldTypeFunctions'] != $post_data['field_function'] && ($post_data['field_function'] == 'count' || $post_data['originalFieldTypeFunctions'] == 'count')){
                    $update_data['rep_filter'] = null;
                }
                $existing_col = Reports_model::find($field_id);
                Reports_model::update_record($update_data, 'rep_id =' . $field_id, $current_user);
/*                 if(($existing_col->rep_field_function != $update_data['rep_field_function'] || $existing_col->rep_values_seperator != $update_data['rep_values_seperator']) && ($post_data['field_function'] != 'count')){
                    $exist_col_key = $existing_col->rep_fields;
                    $updtd = Reports_model::update_record(['rep_field_function' => $update_data['rep_field_function'], 'rep_values_seperator' => $update_data['rep_values_seperator']], "json_contains(rep_fields,'$exist_col_key') AND rep_parent = $report_id", $current_user);
                } */
                $rtn_arr = array(
                    'status' => 'success',
                    'msg' => customTrans('reports.column_configured_success'),
                    'alert_type' => 'toaster'
                );
            }
            return $this->success($rtn_arr['status'], 200, $rtn_arr);
        } catch (\Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function updateFilters(Request $request)
    {
        try {
            $rep_id = Rv_decrypt($request->get('report_id'));
            $filterColumn = $request->get('filterColumn', null);
            $report_init_data = Reports_model::where('rep_id', $rep_id)->Orwhere('rep_parent', $rep_id)->get();
            cache::store('report_redis')->forget('report_previous_config_' . $rep_id);
            Cache::store('report_redis')->rememberForever("report_previous_config_" . $rep_id, function () use ($report_init_data) {
                return $report_init_data;
            });
            $status = false;
            $filters = $this->normalizeFilterDates($request->get('filters', []), $this->current_client->settings->cs_date_format, 'Y-m-d');
            if ($filterColumn) {
                $status = true;
                $filter = $filters['column_filter'][$filterColumn['name']] ?? null;
                if($filter){
                    $column_id = Rv_decrypt($filter['id']);
                    Reports_model::where('rep_id', $column_id)->update(['rep_filter' => $filter]);
                }else{
                    $column_id = Rv_decrypt($filterColumn['id']);
                    Reports_model::where('rep_id', $column_id)->update(['rep_filter' => null]);
                }   
            } else {
                // Reports_model::where('rep_parent', $rep_id)->update(['rep_filter' => null]);

                // foreach ($filters['column_filter'] ?? [] as $filter) {
                //     $status = true;
                //     $column_id = Rv_decrypt($filter['id']);
                //     Reports_model::where('rep_id', $column_id)->update(['rep_filter' => $filter]);
                // }
                // unset($filters['column_filter']);
                if ($rep_id && count($filters)) {
                    $status = true;
                    Reports_model::where('rep_id', $rep_id)->update(['rep_filter' => $filters]);
                } else {
                    Reports_model::where('rep_id', $rep_id)->update(['rep_filter' => null]);
                }
            }
            $this->report_xml($rep_id, 'write', null, true);

            return $this->success('success', data: ['filter_saved' => $status]);
        } catch (Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }
    function normalizeFilterDates($array,$fromDateFormat,$toDateFormat)
    {
        foreach ($array as &$section) {
            if (is_array($section)) {
                foreach ($section as &$field) {
                    if (is_array($field) && isset($field['fltr'])) {
                        foreach ($field['fltr'] as &$filter) {
                            if (isset($filter['opt_value'])) {
                                // Convert date format from y-m-d to Y-m-d
                                if (is_string($filter['opt_value']) && (preg_match('/^\d{2}-\d{2}-\d{2}$/', $filter['opt_value']) || preg_match('/^\d{2}-\d{2}-\d{4}$/', $filter['opt_value']) || preg_match('/^\d{4}-\d{2}-\d{2}$/', $filter['opt_value']))) {
                                    $filter['opt_value'] = Carbon::createFromFormat($fromDateFormat, $filter['opt_value'])->format($toDateFormat);
                                }
                            }
                        }
                    }
                }
            }
        }
        return($array);
    }

    public function getReportFilter(Request $request)
    {
        try {
            $report_id = Rv_decrypt($request->get('report_id'));
            $filterColumn = $request->get('filterColumn', null);
            $main_filter = Reports_model::find($report_id, ['rep_filter', 'rep_type']);
            $filter_conf = Config('reportFilter');
            $sub_filters = Reports_model::where('rep_parent', $report_id)->whereNotNull('rep_filter')->get(['rep_filter', 'rep_title']);
            $column_filter = [];
            if($filterColumn){
                foreach ($sub_filters as $sub_filter) {
                    $field = $sub_filter->rep_title;
                    $column_filter['column_filter'][$field] = json_decode($sub_filter->rep_filter, true);
                }
            }

            $filter_data = array_merge($column_filter, json_decode($main_filter->rep_filter, true) ?? []);
            $filter_flat_array = [];
            $filter_flat_options = [];
            $i = 0;
            $filter_data = $this->normalizeFilterDates($filter_data ,'Y-m-d', $this->current_client->settings->cs_date_format);
            foreach ($filter_data as $parent => $filter) {
                if($parent == 'match'){
                    $global_match = $filter;
                    continue;
                }
                foreach ($filter as $filter_key => $filter_arr) {
                    if($filterColumn && $filter_key != $filterColumn['name']){
                        continue;
                    }
                    $filter_flat_array["{$i}parent_value"] = $parent;
                    $filter_flat_array["{$i}following"] = $filter_arr['match'] ?? null;
                    $filter_flat_array["{$i}idValue"] = $filter_arr['id'] ?? null;
                    $filter_flat_array["{$i}initial_value"] = $filter_key;
                    $options = ($filter_conf['article'][$parent] ?? $filter_conf['user'][$parent] ?? [])[$filter_key]['condition']['options'] ?? [];
                    $option_count = count($options ?? []);
                    $j = 0;
                    $k = 0;
                    foreach ($filter_arr['fltr'] as  $filter_value) {
                        $filter_flat_array["{$i}{$j}{$k}_mainValue"] = $filter_value['fixed_value'];
                        if ($filter_value['opt_value'] ?? false) {
                            $filter_flat_array["{$i}{$j}{$k}_subValue"] = $filter_value['opt_value'];
                        }
                        if ($options[$k]['options_from'] ?? false) {
                            $option_from = $options[$k]['options_from'];
                            $serach_key = explode(' ', $option_from['columns'][0])[0];
                            if ($options[$k]['custom_table'] ?? false) {
                                $table_name = $options[$k]['custom_table']['name'];
                                $table_desc = $options[$k]['custom_table']['desc'];
                                DB::statement("CREATE TEMPORARY TABLE {$table_name} ENGINE=MEMORY AS {$table_desc} ");
                                $temperory_model = new class extends \Illuminate\Database\Eloquent\Model {
                                    public $timestamps = false;
                                };
                                $model_class = $temperory_model->setTable($table_name);
                            } else {
                                $model_class = (new ReflectionClass('App\\Models\\' . $options[$k]['options_from']['model']))->newInstance();
                            }
                            if (is_array($filter_value['opt_value']) && count($filter_value['opt_value']) > 1) {
                                $filter_flat_options["{$i}{$j}{$k}_optValue"] = $model_class->whereIn($serach_key, $filter_value['opt_value'])->get([DB::raw($options[$k]['options_from']['columns'][0]), DB::raw($options[$k]['options_from']['columns'][1])])?->toArray();
                            } else {
                                $filter_flat_options["{$i}{$j}{$k}_optValue"] = $model_class->where($serach_key, $filter_value['opt_value'])->get([DB::raw($options[$k]['options_from']['columns'][0]), DB::raw($options[$k]['options_from']['columns'][1])])?->first()?->toArray();
                            }
                        } elseif ($options[$k]['custom_opt'] ?? false) {
                            $filtered_cust_opt = array_filter($options[$k]['custom_opt'], function ($item) use ($filter_value) {
                                return $filter_value['opt_value'] == $item['value'];
                            });
                            $filter_flat_options["{$i}{$j}{$k}_optValue"] = array_values($filtered_cust_opt)[0] ?? null;
                            //  $filter_flat_options["{$i}{$j}{$k}_optValue"] = $options[$k]['custom_opt'];
                        }
                        elseif ($options[$k]['custom_opt_fn'] ?? false) {
                            $fn = $options[$k]['custom_opt_fn']['fn'];
                            $param = $options[$k]['custom_opt_fn']['param'];
                            $arr = $this->$fn($param)[$param] ?? [];
                            $resp = [];
                            if ($options[$k]['custom_opt_fn']['type'] == 'key_value') {
                                foreach ($arr as $key => $value) {
                                    $resp[] = ['value' => $key, 'label' => $value];
                                }
                            }elseif ($options[$k]['custom_opt_fn']['type'] == 'label_value') {
                                $resp = $arr;
                            }
                            $filtered_cust_opt = array_filter($resp, function ($item) use ($filter_value) {
                                return $filter_value['opt_value'] == $item['value'];
                            });
                            $filter_flat_options["{$i}{$j}{$k}_optValue"] = array_values($filtered_cust_opt)[0] ?? null;
                            //  $filter_flat_options["{$i}{$j}{$k}_optValue"] = $options[$k]['custom_opt'];
                        }
                        if ($k < $option_count - 1) {
                            $k++;
                        } else {
                            $k = 0;
                            $j++;
                        }
                    }
                    $i++;
                }
            }
            // print_r($filter_flat_options);die;
            $return_ar = ['filters' => $filter_flat_array, 'options' => $filter_flat_options, 'match' => $global_match ?? 'all'];
            return $this->success('success', data: $return_ar);
        } catch (Exception $e) {
            // print_r($e);die;
            return $this->failure(data: $e);
        }
    }
    public function report_xml($report_id, $mode = 'write', $write_data = null, $reset = false)
    {
        try {
            $path = storage_path('/app/public/uploads/' . config('report_generation')['report_cache_path'] . '/' . $report_id);
            if (!File::exists($path)) {
                File::makeDirectory($path, 0777, TRUE);
            }
            $file = $path . '/' . $report_id . '.xml';
            if (!File::exists($file) || $reset == true) {
                $xml = new \DOMDocument();
                if ($reset == true) {
                    $xml = new \DOMDocument();
                    // $xpath = new \DomXPath($xml);
                    $oElement = $xml->getElementsByTagName('report');
                    $oElement->nodeValue = '';
                    $xml->save($file);
                }
                $execution_tag = $xml->createElement("report");
                $log_tag = $xml->createElement("report_meta");
                $execution_tag->appendChild($log_tag);
                $xml->appendChild($execution_tag);
                $log_tag = $xml->createElement("report_data");
                $execution_tag->appendChild($log_tag);
                $log_tag = $xml->createElement("generated_report");
                $execution_tag->appendChild($log_tag);
                $log_tag = $xml->createElement("generated_report_total_count");
                $execution_tag->appendChild($log_tag);
                $log_tag = $xml->createElement("report_description");
                $execution_tag->appendChild($log_tag);
                $xml->save($file);
            }
            if ($mode == "write" && $write_data != null) {
                $xml = new DOMDocument();
                $xml->load($file);
                $report_data_Element = $xml->getElementsByTagName('report_data');
                if ($report_data_Element->item(0)->nodeValue == '') {
                    $arr_formatted = array(
                        'generated_sql' => $write_data['generated_report_query']
                    );
                    if (isset($write_data['generated_total_count_query']) && !empty($write_data['generated_total_count_query'])) {
                        $arr_formatted['generated_sql_show_total'] = $write_data['generated_total_count_query'];
                    }
                    $report_data_Element->item(0)->nodeValue = htmlspecialchars(json_encode($arr_formatted));
                }
                $generated_report_Element = $xml->getElementsByTagName('generated_report');
                if ($generated_report_Element->item(0)->nodeValue == '') {
                    $generated_report_Element->item(0)->nodeValue = htmlspecialchars(json_encode($write_data['generated_report']));
                    if (!$write_data['cached_result']) {
                        $generated_report_Element->item(0)->setAttribute("generated-date", date('Y-m-d H:i:s'));
                    }
                }
                if (isset($write_data['generated_total_count']) && !empty($write_data['generated_total_count'])) {
                    $generated_report_total_count_Element = $xml->getElementsByTagName('generated_report_total_count');
                    if ($generated_report_total_count_Element->item(0)->nodeValue == '') {
                        $generated_report_total_count_Element->item(0)->nodeValue = htmlspecialchars(($write_data['generated_total_count']));
                    }
                }
                $xml->save($xml->documentURI);
            } else if ($mode == 'read') {
                $xml = new \DOMDocument();
                $xml->load($file);
                if ($mode == 'read') {
                    return $xml;
                }
            }
        } catch (Exception $e) {
            // print_r($e);die;
            return  $this->failure('Failed', 500, $e);
        }
    }
    public function get_generated_total_count($report_child_rows, $show_column_total_type, $raw_sql)
    {
        $rtn_arr = array();
        $aggragate_str = 'show_total';
        $total_count_query = $column_name = '';
        $total_count_query_arr = array();

        if (!empty($report_child_rows) && !empty($raw_sql)) {
            foreach ($report_child_rows as $child_row) {
                if (isset($show_column_total_type[$child_row->rep_show_total_type])) {
                    $column_name = Str::replace('COLUMN_NAME', $child_row->rep_title, $show_column_total_type[$child_row->rep_show_total_type]['display_value']);
                    $total_count_query =  Str::replace("LABEL_NAME", '`' . $column_name . '`', $show_column_total_type[$child_row->rep_show_total_type]['function']);
                    $total_count_query =  Str::replace("REPLACE", $aggragate_str . '.`' . $child_row->rep_title . '`', $total_count_query);
                    $total_count_query_arr[] = $total_count_query;
                }
            }
            //formatting total count query
            if (count($total_count_query_arr) > 0) {
                $total_count_raw_query = 'SELECT ' . implode(', ', $total_count_query_arr) . ' FROM (' . $raw_sql . ') AS ' . $aggragate_str;
                $total_count_result = Articles::get_records_by_raw_query($total_count_raw_query, TRUE);
                $rtn_arr = array(
                    'total_count_raw_query' => $total_count_raw_query,
                    'total_count_result' => json_encode($total_count_result)
                );
            }
        }
        return $rtn_arr;
    }
    public function getColumnCount($req, $result)
    {
        $report_child_rows = $req['report_child_rows'] ?? null ;
        if (empty($report_child_rows) || empty($result)) {
            return null;
        }
    
        $show_column_total_type = config('report_generation.show_column_total_type');
    
        // Extract columns and their total types
        $keysToCount = collect($report_child_rows)
            ->whereNotNull('rep_show_total_type')
            ->flatMap(fn($item) => [$item->rep_title => $item->rep_show_total_type])
            ->toArray();
    
        $carry_ar = array_fill_keys(array_keys($keysToCount), 0);
        $helper_ar = [];
    
        // Calculate totals based on type
        $counts = collect($result)->reduce(function ($carry, $item) use ($keysToCount, &$helper_ar) {
            foreach ($keysToCount as $key => $type) {
                if (!is_null($item->$key)) {
                    switch ($type) {
                        case 'unique_row_value':
                            $value = $item->$key;
                            if (empty($helper_ar[$key][$value])) {
                                $carry[$key]++;
                                $helper_ar[$key][$value] = true;
                            }
                            break;

                        case 'total_row_count':
                            $carry[$key]++;
                            break;
    
                        case 'sum_rows':
                            $carry[$key] += $item->$key;
                            break;
                    }
                }
            }
            return $carry;
        }, $carry_ar);
    
        // Prepare labeled output
        $output = [];
        foreach ($keysToCount as $key => $type) {
            $formated_key = '<b>'.$key.'</b>';
            if(isset($req['download']) && $req['download'] == true){
                $formated_key = $key;
            }
            $label = Str::replace('COLUMN_NAME', $key, $show_column_total_type[$type]['display_value']);
            $output["$label $formated_key"] = $counts[$key] ?? 0;
        }
    
        return json_encode($output);
    }
    /* public function getColumnCount($report_child_rows, $result)
    {
        if (!empty($report_child_rows) && !empty($result)) {
            $show_column_total_type = config('report_generation.show_column_total_type');
            $keysToCount = collect($report_child_rows)
                ->whereNotNull('rep_show_total_type')
                ->flatMap(fn($item) => [$item->rep_title => $item->rep_show_total_type])
                ->toArray();
            $helper_ar = [];
            $carry_ar = array_fill_keys(array_keys($keysToCount), 0);
            $counts = collect($result)->reduce(function ($carry, $item) use ($keysToCount, $helper_ar) {
                foreach ($keysToCount as  $key => $type) {
                    if (!is_null($item->$key)) {
                        if ($type == "unique_row_value") {
                            // dump($helper_ar[$key][$item->$key] ?? false);
                            if (($helper_ar[$key][$item->$key] ?? false) == false) {
                                $carry[$key]++;
                                $helper_ar[$key][$item->$key] = true;
                            }
                        } elseif ($type == "total_row_count") {
                            $carry[$key] == $carry[$key]++;
                        } elseif ($type == "sum_rows") {
                            $carry[$key] == $carry[$key] + $item->$key;
                        }
                    }
                }
                return $carry;
            }, $carry_ar);
            $output = [];
            foreach ($keysToCount as $key => $type) {
                $column_name_prefix = Str::replace('COLUMN_NAME', $key, $show_column_total_type[$type]['display_value']);
                $output["$column_name_prefix $key"] = $counts[$key] ?? 0;
            }
            return json_encode($output);
        }

        return null;
    } */

    public function generateReportPdf($id, $out_dir, $file_name, $result)
    {
        $csv_path = generateCSV($id, $out_dir, $result);
        if (!File::exists($out_dir)) {
            File::makeDirectory($out_dir, 0777, true, true);
        }
        $process = new Process(['python3', app_path("Scripts/reportpdfgenerator.py"), "$csv_path", "$out_dir", "$file_name"]);
        $process->setTimeout(300);
        $process->run();
        /* if (File::exists($csv_path)) {
            File::delete($csv_path);
        } */
        if (File::exists($out_dir.$file_name)) {
            return array(
                'temp_csv_file_path' => $csv_path,
                'generated_pdf_path' => $out_dir.$file_name
            );
        } else {
            throw new ProcessFailedException($process);
        }
    }
    public function isValidDateTimeStamp($dateString) {
        if (!is_string($dateString)) {
            return false;
        }
        try {
            $date = new DateTime($dateString);
            // Optional: You can add additional validation for the specific format
            // For example, check if it's in ISO 8601 format with milliseconds and Z timezone
            return $date->format('Y-m-d\TH:i:s.000\Z') === $dateString || 
                   preg_match('/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/', $dateString);
        } catch (Exception $e) {
            return false;
        }
    }
    public function isDate($value, $format)
    {
        try {
            $date = Carbon::createFromFormat($format, $value);
            return $date && $date->format($format) === $value;
        } catch (\Exception $e) {
            return false;
        }
    }

    public function getClientConfigdata($param){
        $client_code= Clients::get()->first()->clnt_client_code;
        $data = config("$client_code.$param");
        return [$param => $data];
    }

    /**
 * Packs sparse columns to the top per group.
 *
 * @param Collection $rows      Original rows
 * @param string     $groupKey  e.g. 'custom_art_id'
 * @param array      $forceStatic Optional list of columns you want to treat as static
 */
function packSparseColumns(Collection $rows, string $groupKey, array $forceStatic = []): Collection
{
    return $rows->groupBy($groupKey)
        ->flatMap(function (Collection $group, $groupValue) use ($groupKey, $forceStatic) {

            $rowCount = $group->count();

            // Discover all column names across this group (dynamic-safe, supports spaces)
            $allCols = [];
            foreach ($group as $item) {
                foreach ((array) $item as $col => $val) {
                    $allCols[$col] = true;
                }
            }
            $allCols = array_keys($allCols);

            // Classify columns: static vs pivot (sparse)
            $staticCols = array_unique(array_merge([$groupKey], $forceStatic));
            $pivotCols  = [];

            foreach ($allCols as $col) {
                if (in_array($col, $staticCols, true)) {
                    continue;
                }

                // Values present for this column in the group (keep 0, drop only null/"")
                $vals = $group->pluck($col)->filter(fn($v) => $v !== null && $v !== '');
                $distinct = $vals->unique();

                // Static if column is non-null for all rows AND the same value across rows
                if ($vals->count() === $rowCount && $distinct->count() <= 1) {
                    $staticCols[] = $col;
                } else {
                    $pivotCols[] = $col;
                }
            }

            // Prepare static values (take group key and first non-empty for others)
            $staticValues = [];
            foreach ($staticCols as $col) {
                if ($col === $groupKey) {
                    $staticValues[$col] = $groupValue;
                } else {
                    $staticValues[$col] = $group->pluck($col)
                        ->first(fn($v) => $v !== null && $v !== '');
                }
            }

            // Gather lists of values for pivot (sparse) columns in original order
            $lists = [];
            $max = 1;
            foreach ($pivotCols as $col) {
                $list = $group->pluck($col)
                    ->filter(fn($v) => $v !== null && $v !== '')
                    ->values();
                $lists[$col] = $list;
                $max = max($max, $list->count());
            }

            // Build packed rows
            $out = collect();
            for ($i = 0; $i < $max; $i++) {
                $row = $staticValues;
                foreach ($pivotCols as $col) {
                    $row[$col] = $lists[$col]->get($i);
                }
                $out->push((object) $row);
            }

            return $out;
        })
        ->values();
}

}