<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Traits\General_ConfigTraits;
use Illuminate\Support\Facades\Http;
use App\Models\Research_integrity_reports;

/*
* the callback_url is an endpoint where Research Integrity (RVRI) will send the result of the integrity check after the manuscript is submitted
*/
class RvriController_Api extends Controller
{
    // Handle incoming RVRI webhook
    public function handle_rvri_webhook(Request $request)
    {
        try
		{
            $post_data  =   $request->all();
            $this->rvriWebhookLog($post_data);
            $this->current_user = $this->get_current_user_details();
            if($post_data['status'] == 'success')
            {
                $art_id     =   $post_data['submission_id'];
                $result_url =   $post_data['result_url'];

                $update_arr     =   array('rri_report' => $result_url, 'rri_status' => 'y', 'rri_new_report' => 'y');
                $condition      =   'rri_status="n" and rri_art_id = ' . $art_id . '';
                if(Research_integrity_reports::update_record($update_arr, $condition, $this->current_user)) {
                    return response()->json([
                        'message' => 'Report generated',
                        'status' => 'success',
                    ]);
                }
            } else {
                return response()->json([
                    'message' => 'Report not generated',
                    'status' => 'error',
                ]);
            }
        }
		catch(\Exception $e)
		{
            $this->rvriWebhookLog($e->getMessage());
            return  $this->failure('Failed', 500, $e);
		}
    }

    public function rvriWebhookLog($request)
	{
		$app_log = General_ConfigTraits::General_config_data('RVRI_WEBHOOK_LOG_PATH');
		$app_log_path = $app_log['RVRI_WEBHOOK_LOG_PATH'];
		
		if (file_exists($app_log_path) == FALSE)
		{
			mkdir($app_log_path,0777,true);
		}
		
		if($app_log_path != '')
		{
			$log_file = $app_log_path . date("dmY", time()) . ".log";
			$handle = fopen($log_file, "a+");
            
            // Ensure $request is a string
            $request_string = is_array($request) || is_object($request) ? json_encode($request, JSON_PRETTY_PRINT) : $request;

			fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $request_string . "\r\n\r\n\r\n");
			fclose($handle);
		}
		return true;

	}
}