<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use App\Models\Clients;
use App\Models\Client_functionalities;
use App\Models\All_Client_Functionalities;
use App\Models\All_Clients;
use App\Models\All_Client_Functionality_Status;
use App\Models\All_Client_Url;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use App\Models\System_downtime;
use Illuminate\Support\Facades\Http;
use App\Http\Services\SuperSudoService;
class SudoManagementApi extends Controller
{
    public $currentuser;

    public function amend_debug_mode(Request $request)
    {
        $return_array['status'] = 'failed';
        $General_settings =new \App\Models\General_Settings();
        $update_settings = false;
        $this->currentuser = $this->get_current_user_details();
        if($request->enable_mode == 'n')
        {
            $update_settings = true;
        }
        else
        {
            $validator = Validator::make($request->all(), [
                'password'=>'required',
                'enable_mode' => 'required'
            ]);
            if($validator->fails())
            {
                return  $this->failure('Failed',422,$validator->errors());
            }
            $Users = new \App\Models\User();
            $user = $Users::where('usr_id', $this->currentuser['user_id'])->get()->first();
            if ($user && Hash::check($request->password, $user->usr_pwd))
            {
                $update_settings = true;
            }
        }
        if($update_settings === true)
        {
            $update_data = array("gnl_debug_mode" => $request->enable_mode);
            $update_condition = 'gnl_id = 1';
            $General_settings::update_record($update_data,$update_condition,$this->currentuser);
            $return_array['status'] = 'success';
        }
        return $this->success('Success',200,$return_array);
    }
    public function generate_proxy_password()
    {
        $Sudo_proxy = new \App\Models\Sudo_proxy_password();
        $this->currentuser = $this->get_current_user_details();
        $proxy_key = 'rviavlelry';
	    $date_key = date('Ymd');
        $proxy_psw = md5($proxy_key . $date_key .  $this->currentuser['user_id']);
        $insert_data = array();
        $insert_data['sp_password'] = $proxy_psw;
        $sudo_proxy_table = (new \App\Models\Sudo_proxy_password())->getTable();
        $sql = 'INSERT IGNORE INTO '.$sudo_proxy_table .' (`sp_password`, `sp_posted_by`, `sp_posted_date`, `sp_operation`) VALUES (\'' . $proxy_psw . '\', ' . $this->currentuser['user_id'] . ', \'' . date('Y-m-d H:i:s') . '\', \'i\')';
        $Sudo_proxy::execute_query($sql);
        $return_array['status'] = 'success';
        $return_array['proxy_password'] = $proxy_psw;
        return $this->success('Success',200,$return_array);
    }
    public function debug_status()
    {
        $debug_data = $this->get_debug_status();
        $return_array = array();
        $return_array['status'] = 'success';
        $return_array['debug_mode'] = $debug_data->gnl_debug_mode;
        return $this->success('Success',200,$return_array);
    }

    /**
     * #1358 Function to check if client exists in sudo application
     *
     * @param Request $client string
     * @param Request $ajax boolean
     * @return Response
     */
    public function check_client_access($client, $ajax = false)
	{
		$client_data    =   Clients::get_single_record('*', "clnt_client_code = '{$client}'");
        if(!$client_data && $ajax === false)
        {
            $return =   array(
                'status' => 'failure',
                'message' => customTrans('sudo_lang.wng_access'),
            );
            return $return;
        }

		if ($ajax === true)
		{
            $client_data    =   Clients::get_single_record('*', "clnt_id = '{$client}'");
			if (!$client_data)
			{
				$return =   array(
                    'status' => 'failure',
                    'message' => customTrans('sudo_lang.wng_access'),
                );
                return $return;
			}
			else
            {
                return $client_data;
            }
		}
		else
        {
			return $client_data;
        }
	}

    /**
     * #1358 Function to fetch all client functionalities in sudo application
     *
     * @param Request $request
     * @return Response
     */
    public function manage_client_functionalites(Request $request) {
        try
        {
        $post_data          = $request->all();
        if(isset($post_data['client']) && $post_data['client'] != '') {
            // Variable initializations
            $clnt_arr   =   array();
            $clnt_arr   =   array('on' => array(), 'off' => array(), 'new' => array());

            // Getting client
            $client = $post_data['client'];

            // Getting client data
		    $client_data    = $this->check_client_access($client);
            // Keeping client ID 
            $clnt_arr['clnt_id'] = encrypt_link($client_data->clnt_id);
            // Setting page title and page head
            $clnt_arr['page_head']    =   'Manage Clients Functionality - ' . $client_data->clnt_client_name;
            $clnt_arr['page_title']   =   'Client Functionalities';

            $arr            = (array)$client_data;
            
            if ($arr) {
                // Getting config file corresponding to the client ID
                #$client_default_config  =   'clients/' . $client_data->clnt_client_code . '/client_configurations';
                $client_default_config  =   'client_configurations';
                $path                   =   base_path() . '/config/' . $client_default_config . '.php';
                $descArr = [];
                if(File::exists(public_path('dist/client_functionality.json'))){
                    $descPathJson = File::get(public_path('dist/client_functionality.json'));
                    if($descPathJson!=""){
                        $descArr = json_decode($descPathJson,true);
                    }
                }
                
                if (!file_exists($path))
                {
                    $return =   array(
                        'status' => 'failure',
                        'message' => customTrans('sudo_lang.no_cnt_config_file'),
                    );
                }
                else
                {
                    $client_funct_db_arr  =   array();
                    // Fetch client functionalities from database
                    $client_functionalities_db = Client_functionalities::get_all_records('*', "cfty_clnt_id = {$client_data->clnt_id}");
                    // Making db values looking identical to the config value
                    if (!empty($client_functionalities_db))
                    {
                        foreach ($client_functionalities_db as $row)
                        {
                            $client_funct_db_arr[$row->cfty_functionality] = $row->cfty_status;
                        }
                    }
                   
                    // Getting client functionality default values from config file
                    #$client_config    =   'clients.' . $client_data->clnt_client_code . '.client_configurations.client_functionality';
                    $client_config  =   'client_configurations.client_functionality';
                    $clnt_conf_arr    =   Config::get($client_config);
                   
                    // y-yes, n-no, c-category, j-journal
                    foreach ($clnt_conf_arr as $row => $val)
                    {
                        
                        //remove everything before first occurance of underscore
                        $description = isset($descArr[$row])?$descArr[$row]:"";
                        $new_row     =  implode('_', array_slice( explode( '_', $row ),1 ));
                        if(isset($client_funct_db_arr[$row])) {
                            $clnt_arr['clnt_func'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$client_funct_db_arr[$row],'description'=>$description);
                            if($client_funct_db_arr[$row] == 'y' || $client_funct_db_arr[$row] == 'j') {
                                $clnt_arr['on'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$client_funct_db_arr[$row],'description'=>$description);
                            } else {
                                $clnt_arr['off'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$client_funct_db_arr[$row],'description'=>$description);
                            }
                        } else {
                            $clnt_arr['clnt_func'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$clnt_conf_arr[$row],'description'=>$description);
                            $clnt_arr['new'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$clnt_conf_arr[$row],'description'=>$description);
                        }
                    }
                   
                }
                $return =   array(
                    'status' => 'success',
                    'data' => $clnt_arr,
                    'tabs' => array(
                                'On ('.count($clnt_arr['on']).')',
                                'Off ('.count($clnt_arr['off']).')',
                                'New ('.count($clnt_arr['new']).')'
                                )
                );
                
            } else {
                $return =   array(
                    'status' => 'failure',
                    'message' => customTrans('sudo_lang.wng_access'),
                );
            }
        } else {
            $return =   array(
                'status' => 'failure',
                'message' => customTrans('sudo_lang.invalid_data'),
            );
        }
        return $return;
    }
    catch(\Exception $e)
    {
        return $this->failure('Failed', 500, $e);
    }
    }

    /**
     * #1358 Function to save/update client functionalities in sudo application
     *
     * @param Request $request
     * @return Response
     */
    public function save_client_functionalities(Request $request)
	{
        // y-yes, n-no, c-category, j-journal
        $post_data      =   $request->all();
		$client         =   decrypt_link($post_data['clnt_id']);
		$mode           =   $post_data['mode'];
        $cf_post        =   $post_data['clnt_functionality'];

        $return_arr =   array(
            'status' => 'failure',
            'message' => customTrans('sudo_lang.cmn_db_error'),
        );
        
		// Getting client data
        $client_data = $this->check_client_access($client, true);
		if (isset($client_data->status) && $client_data->status == 'false')
		{
			$return_arr['redirect_url'] = $client_data['redirect_url'];
		}
        // Fetch client functionalities from database
        $client_functionalities_db = Client_functionalities::get_all_records('*', "cfty_clnt_id = {$client_data->clnt_id}");
        // Making db values looking identical to the config value
        $cf_db_arr  =   array();
        if (!empty($client_functionalities_db))
        {
            foreach ($client_functionalities_db as $row)
            {
                $cf_db_arr[] = $row->cfty_functionality;
            }
        }
        // Getting client functionality default values from config file
       # $client_config          =   'clients.' . $client_data->clnt_client_code . '.client_configurations.client_functionality';
        $client_config  =   'client_configurations.client_functionality';
        $clnt_functionalities   =   Config::get($client_config);
        
        //fetching functionalities which are not saved in the db
        $cf_cf_arr              =   array_keys($clnt_functionalities);
        $diff_arr               =   array_values(array_diff($cf_cf_arr, $cf_db_arr));
        $diff_cf_arr            =   array();
        
        if(count($diff_arr) > 0) {
            foreach($diff_arr as $key) {
                // Check if associative array contains value, and retrieve key / position in array
                if (isset($clnt_functionalities[$key]) && (in_array($key, array_column($cf_post, 'func')) === false)) {
                        $diff_cf_arr[]  =   array('func' => $key, 'val' => $clnt_functionalities[$key]);
                }
            }
            //merge difference
            $cf_post    =   array_merge($cf_post, $diff_cf_arr);
        }
        
		DB::beginTransaction();
        try {
            $this->save_client_data($client_data);
            if($mode == 'save') {
                if(count($cf_post) == 0) {
                    $return_arr =   array(
                        'status' => 'failure', 
                        'message' => customTrans('sudo_lang.cf_no_changes'),
                    );
                    return $return_arr;
                }
                foreach ($cf_post as $key)
                {
                    $this->save_sudo_clnt_func($client_data, $key['func'], $key['val']);
                }
                $msg    =   customTrans('sudo_lang.cf_updated_suc_msg');
            } else {
                foreach ($clnt_functionalities as $func => $value)
                {
                    $this->save_sudo_clnt_func($client_data, $func, $value);
                }
                $msg    =   customTrans('sudo_lang.cf_default_msg');
            }
            DB::commit();
            $return_arr =   array(
                'status' => 'success',
                'message' => $msg,
            );
            return $return_arr;
        }
        catch (\exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
	}

    /*
     * #1358 insert or update save/update sql for client func
     *
     * @param array $client_data
     * @param string $func
     * @param string $value
     */
    public function save_sudo_clnt_func($client_data, $func, $value) {
        // Getting client functionality default values from config file
        #$client_config          =   'clients.' . $client_data->clnt_client_code . '.client_configurations.client_functionality';
        $client_config  =   'client_configurations.client_functionality';
        $clnt_functionalities   =   Config::get($client_config);
        if (isset($clnt_functionalities[$func]))
        {
            $this->save_client_functionality_common($client_data,$func,$value);
            $time       =   date("Y-m-d H:i:s.") . substr(microtime(false), 2, 3);
            $cf_table   =   (new \App\Models\Client_functionalities())->getTable();
            //insert if no data found unless udate the record
            $sql        =   'INSERT INTO ' . $cf_table . ' 
                            (cfty_clnt_id, cfty_functionality, cfty_status, cfty_posted_date) 
                            VALUES(' . $client_data->clnt_id . ', "' . $func . '", "' . $value . '", "' . $time . '") 
                            ON DUPLICATE KEY UPDATE cfty_status = "' . $value . '", cfty_posted_date = "' . $time . '"';            
            Client_functionalities::execute_query($sql);
            return $this->success('Success',200,'Created Successfully');
        }
    }
    
    /**
     * #2357 Function to fetch the google analytics data
     *
     * @param Request $request
     * @return Response
     */
    public function save_client_functionality_common($client_data,$func,$value){
       
        $current_user = $this->get_current_user_details();
        
        $app_url=env('APP_URL','');
        $client=(new All_Clients())->get_single_record_with_bind_cond("*",array("acls_client_code"=>$client_data->clnt_client_code));
        $client_url_data=(new All_Client_Url())->get_single_record_with_bind_cond('*',array("clu_acls_id"=>$client->acls_id,'clu_url'=>$app_url));
        
        $this->data_insert_client_functionality($func,$value);
        $this->save_client_functionality_status($func,$value,$client,$client_url_data);
         $sudo_enabled=config('superSudoServiceConfig.super_sudo_enabled');
         if($sudo_enabled==true)
         {
            $client_payload=array('funct_name'=>$func,"funct_status"=>$value);
            $response=app(SuperSudoService::class)->update_client_functionality_vector_db($client_payload);
          }
       return true;
        
    }
    public function save_client_data($client_data){
       $current_user = $this->get_current_user_details();
       $all_clients = new \App\Models\All_Clients();
       $app_url=env('APP_URL','');
       $exist_code= (new All_Clients())->get_single_record_with_bind_cond('count(acls_id)as count,acls_id',array('acls_client_code'=>$client_data->clnt_client_code,'acls_url'=>$app_url));
       $this->data_insert_update_client_all_clients($client_data);
       $this->data_insert_update_client_url($client_data);
             
    }
    public function fetch_google_analytics(Request $request) {
        try
        {
            $post_data      =   $request->all();
            $clnt_arr       =   array();
            if(isset($post_data['client']) && $post_data['client'] != '') {
                // Getting client
                $client = $post_data['client'];

                // Getting client data
                $client_data    = $this->check_client_access($client);
                // Setting page title and page head
                $clnt_arr['page_head']      =   'Manage Analytics - ' . $client_data->clnt_client_name;
                $clnt_arr['page_title']     =   'Analytics';
                $clnt_arr['ga_code']        =   array();
                
                $cs             =   new \App\Models\Client_settings();
                $client_settings=   $cs::get_client_settings_using_client_code('cs_id, cs_google_analytics_id', $client);
                
                if(count($client_settings)) {
                    $ga_code      =   $client_settings[0]->cs_google_analytics_id;
                    if($ga_code != null || $ga_code !='') {
                        $clnt_arr['ga_code']    =   json_decode($ga_code);
                    }
                    $return =   array(
                        'status' => 'success',
                        'data'   => $clnt_arr
                    );
                }
            } else {
                $return =   array(
                    'status' => 'failure',
                    'data'   => $clnt_arr
                );
            }
            return $return;
        }
        catch(\Exception $e)
        {
            return $this->failure('Failed', 500, $e);
        }
    }


    /**
     * #2357 Function to save the google analytics data
     *
     * @param Request $request
     * @return Response
     */
    public function save_google_analytics(Request $request) {
        DB::beginTransaction();
        try
        {
            $this->currentuser = $this->get_current_user_details();
            $return =   array(
                'status' => 'failure'
            );
            $post_data      =   $request->all();
            if(isset($post_data['clnt']) && $post_data['clnt'] != '') {
                // Getting client
                $client     =   $post_data['clnt'];
                $cs         =   new \App\Models\Client_settings();
                $client_settings = $cs::get_client_settings_using_client_code('cs_id, cs_google_analytics_id', $client);
                
                if(count($client_settings)) {
                    $arr1       =   array();
                    $cs_id      =   $client_settings[0]->cs_id;
                    
                    if(count($post_data) && $post_data['header_script'] != '') {
                        $header_script  =   $post_data['header_script'];
                        $body_script    =   $post_data['body_script'];
                        $i              =   0;
                        
                        foreach($header_script as $key => $val) {
                            if (isset($header_script[$key]) && $header_script[$key] != "")
                            {
                                $arr1[$i]['header_script']  =   ($val != "") ? $val : "null";
                                $arr1[$i]['body_script']    =   ($body_script[$key] != "" && isset($body_script[$key])) ? $body_script[$key] : "null";
                            }
                            $i++;
                        }
                    }
                    
                    $update_data        =   array("cs_google_analytics_id" => json_encode($arr1));
                    $update_condition   =   'cs_id = '.$cs_id;
                    $update_record      =   $cs::update_record($update_data,$update_condition,$this->currentuser);
                    if($update_record) {
                        $return =   array(
                            'status' => 'success'
                        ); 
                    }
                }
                DB::commit();
            } else {
                $return =   array(
                    'status' => 'failure'
                );
            }
            return $return;
        } 
        catch(\Exception $e)
        {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }

    /**
     * #2357 Function to remove the google analytics data
     *
     * @param Request $request
     * @return Response
     */
    public function remove_google_analytics(Request $request) {
        DB::beginTransaction();
        try
        {
            $this->currentuser = $this->get_current_user_details();
            $return =   array(
                'status' => 'failure'
            );
            $post_data      =   $request->all();
            if(isset($post_data['clnt']) && $post_data['clnt'] != '') {
                $client     =   $post_data['clnt'];
                $index      =   $post_data['index'];
                $cs         =   new \App\Models\Client_settings();
                $client_settings = $cs::get_client_settings_using_client_code('cs_id, cs_google_analytics_id', $client);
                
                if(count($client_settings)) {
                    $data       =   json_decode($client_settings[0]->cs_google_analytics_id);
                    $cs_id      =   $client_settings[0]->cs_id;
                    if ($index != "all")
                    {
                        unset($data[$index]);
                        $i=0;
                        foreach($data as $key=> $val)
                        {
                            $new_data[$i]=$val;
                            $i++;
                        }
                    }
                    else
                    {
                        unset($data);
                    }
                    $update_data["cs_google_analytics_id"] = !empty($new_data) ? json_encode($new_data) : null;
                    $update_condition   =   'cs_id = '.$cs_id;
                    $update_record      =   $cs::update_record($update_data,$update_condition,$this->currentuser);
                    if($update_record) {
                        $return =   array(
                            'status' => 'success'
                        ); 
                    }
                }
                DB::commit();
            } else {
                $return =   array(
                    'status' => 'failure'
                );
            }
            return $return;
        }
        catch(\Exception $e)
        {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
    }

    //listing of all system downtimes
    public function manage_system_downtime(Request $request) {
        try {
            $data['date_format'] = $this->current_client->settings->cs_date_format." H:i:s";
            $data['curr_date'] = date('Y-m-d');
            $data['min_time_arr'] = array(date('H'), date('i'));
            $orderby = 'dwn_time_id';
            $select = 'dwn_time_id,dwn_time_message,dwn_time_message_start,dwn_time_scheduled,dwn_time_status,dwn_time_zone,dwn_time_speed';
            $table_records  = System_downtime::get_all_records($select,array(),$orderby,null,null,null,null,'DESC');
            if(count($table_records) > 0) {
                // date_default_timezone_get();
                $currentDate	    =	date('Y-m-d H:i:s');            //SERVER CURRENT TIME
                $ISTzone			=	new \DateTime('now', new \DateTimeZone('Asia/Kolkata'));
                $currentISTDate		=	$ISTzone->format('Y-m-d H:i:s');
                
                $diff				=	strtotime($currentISTDate) - strtotime($currentDate);
                $hours				=	floor($diff / 3600);
                $minutes			=	floor(($diff - $hours * 3600) / 60);
                foreach($table_records as $key => $arr) {
                    $arr->dwn_time_message_start    =   date('M d, Y h:i A',strtotime($arr->dwn_time_message_start));
                    $arr->dwn_time_scheduled        =   date('M d, Y h:i A',strtotime($arr->dwn_time_scheduled));
                    if($arr->dwn_time_zone == 'b') {
                        $arr->conv_dwn_time_message_start    =   date('Y-m-d H:i:s',strtotime('+'.$hours.' hour +'.$minutes.' minutes',strtotime($arr->dwn_time_message_start)));
                        $arr->conv_dwn_time_scheduled   =   date('Y-m-d H:i:s',strtotime('+'.$hours.' hour +'.$minutes.' minutes',strtotime($arr->dwn_time_scheduled)));
                        $tz =   "IST";
                    } else {
                        $arr->conv_dwn_time_message_start    =   date('Y-m-d H:i:s',strtotime('-'.$hours.' hour -'.$minutes.' minutes',strtotime($arr->dwn_time_message_start)));
                        $arr->conv_dwn_time_scheduled   =   date('Y-m-d H:i:s',strtotime('-'.$hours.' hour -'.$minutes.' minutes',strtotime($arr->dwn_time_scheduled)));
                        $tz =   "BST";
                    }
                    $arr->conv_dwn_time_message_start    =   "(" .date('M d, Y h:i A',strtotime($arr->conv_dwn_time_message_start)). " ".$tz.")";
                    $arr->conv_dwn_time_scheduled        =   "(" .date('M d, Y h:i A',strtotime($arr->conv_dwn_time_scheduled)). " ".$tz.")";
                }
            }
            $data['table_records']  =   $table_records;
            return $this->success('success', 200, $data);
        } catch (\exception $e) {
            return $this->failure('failed', 500, $e);
        }
    }

    //Schedule a system downtime (both adding and editing)
    public function add_system_downtime(Request $request) {
        try {
            $post_data      =   $request->all();
            $validator = Validator::make($request->all(),[
                'time_zone'          => 'required',
                'time_scheduled'     => 'required',
                'time_message_start' => 'required',
                'time_message'       => 'required',
                'time_speed'         => 'required'
            ]);
            
            if ($validator->fails()) {
                return  $this->failure('failed', 422, $validator->errors());
            }
            $status			=	"failed";
            $message		=	"";
            $user_data = $this->get_current_user_details();
            $data = array(
                "dwn_time_message_start" => $post_data['time_message_start'],
                "dwn_time_scheduled"     => $post_data['time_scheduled'],
                "dwn_time_zone"          => $post_data['time_zone'],
                "dwn_time_message"       => $post_data['time_message'],
                "dwn_time_status"        => $post_data['time_status'],
                "dwn_time_speed"         => $post_data['time_speed'],
            );
            $id =  isset($post_data['dwn_time_id']) ? Rv_decrypt($post_data['dwn_time_id']) : '';
            //edit section
            if ($id != '') {
                //to fetch count (0 or above) of any similar message start date 
                $select     = "COUNT(*) as cnt";
                $criteria   = "dwn_time_message_start = '".$post_data['time_message_start']."' AND dwn_time_id != $id";
                $drow       = System_downtime::get_single_record($select,$criteria);
                if ($drow->cnt == 0) {
                    $criteria = "dwn_time_id = $id";
                    if ($request->time_status == 'y') {
                        //to fetch count (0 or above) of any downtime which is active
                        $select = "CASE
                                        WHEN
                                            (SELECT count(*) as  cnt from rvw_sys_downtime_msg_settings
                                            where `dwn_time_status` = 'y' and `dwn_time_id` != $id) > 0
                                        THEN '1'
                                        ELSE '0'
                                    END AS cnt ";
                        $row = System_downtime::get_single_record($select,$criteria);
                        if ($row->cnt == 0 ) {
                            //update existing records
                            System_downtime::update_record($data,$criteria,$user_data);
                            $message	=	'System downtime updated successfully';
                            $status		=	"success";
                            return $this->success($status,200,$message);
                        }
                        else {
                            $message	=	'An active record already exists';
                            $status		=	"failed";
                            return $this->failure($status,200,$message);
                        }
                    }
                    else {
                        //update existing records
                        System_downtime::update_record($data,$criteria,$user_data);
                        $message	=	'System downtime updated successfully';
                        $status		=	"success";
                        return $this->success($status,200,$message);
                    }
                }
                else {
                    $message	=	'Similar message starting date already exists';
                    $status		=	"failed";
                    return $this->failure($status,200,$message);
                }
            }
            else {
                //add section
                //to fetch count (0 or above) of any similar message start date 
                $select = "COUNT(*) as cnt";
                $criteria = "dwn_time_message_start = '".$post_data['time_message_start']."'";
                $drow = System_downtime::get_single_record($select,$criteria);
                if ($drow->cnt == 0) {
                    //to fetch count (0 or above) of any downtime which is active
                    if ($request->time_status == 'y') {
                        $select = "COUNT(*) as cnt";
                        $criteria = "dwn_time_status = 'y'";
                        $row = System_downtime::get_single_record($select,$criteria);
                        if ($row->cnt == 0) {
                            //insert new records
                            System_downtime::insert_record($data,$user_data);
                            $message	=	'New system downtime added successfully';
                            $status		=	"success";
                            return $this->success($status,200,$message);
                        }
                        else {
                            $message	=	'An active record already exists';
                            $status		=	"failed";
                            return $this->failure($status,200,$message);
                        }
                    }
                    else {
                        System_downtime::insert_record($data,$user_data);
                        $message	=	'New system downtime added successfully';
                        $status		=	"success";
                        return $this->success($status,200,$message);
                    }
                }
                else {
                    $message	=	'Similar message starting date already exists';
                    $status		=	"failed";
                    return $this->failure($status,200,$message);
                }
            }
        } catch (\Exception $e) {
            return $this->failure('failed', 500, $e);
        }
    }

    //fetch details of a system downtime record
    public function get_downtime_details(Request $request) {
        try {
            $post_data      =   $request->all();
            $dwn_time_id = Rv_decrypt($post_data['dwn_time_id']);
            if($dwn_time_id != ""){
                $criteria = "dwn_time_id = $dwn_time_id";
                $select  =	"dwn_time_id,dwn_time_message,dwn_time_message_start,dwn_time_scheduled,dwn_time_status,dwn_time_zone,dwn_time_speed";
                $data = System_downtime::get_single_record($select,$criteria);
                return $this->success('success',200, $data);
            }
            return $this->warning('warning',400,'Invalid id');
        } catch (\exception $e) {
            return $this->failure('failed', 500, $e);
        }
        
    }

    //delete a system downtime record
    public function remove_system_downtime(Request $request) {
        try {
            $post_data      =   $request->all();
            $dwn_time_id    =   Rv_decrypt($post_data['dwn_time_id']);
            if($dwn_time_id != ""){
                $criteria = "dwn_time_id = $dwn_time_id";
                System_downtime::delete_records($criteria);
                return $this->success('success', 200, 'System downtime record removed successfully');
            }
            return $this->warning('warning',400,'Invalid id');
        } catch (\exception $e) {
            return $this->failure('failed', 500, $e);
        }
    }

    public function save_client_functionality_desc(Request $request){
        try
        {
            $post_data      =   $request->all();
            $validator = Validator::make($request->all(),[
                'cfty_name' => 'required',
                'description' => 'required',
            ]);
            
            if ($validator->fails()) {
                return $this->success('failed', 200, $validator->errors()->first());
            }
            
            $data = "";
            $filePath = public_path('dist/client_functionality.json');
            if (file_exists($filePath)) {
                $existingData = json_decode(file_get_contents($filePath), true);
                if($existingData!=""){
                    $existingData[$post_data['cfty_name']] = $post_data['description'];
                }
                $data = json_encode($existingData,true);
            }else{
                $data = json_encode(array(
                    $post_data['cfty_name'] => $post_data['description'],
                ),true);
            }
            File::put($filePath, $data);

            return $this->success('success', 200, 'Description added successfully');
        } catch (\exception $e) {
            return $this->failure('failed', 500, $e);
        }
    }
// Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
    public function manage_client_fieldvalidation(Request $request) {
        try {
            $post_data          = $request->all();
            if(isset($post_data['client']) && $post_data['client'] != '') {
                // Variable initializations
                $clnt_arr   =   array();
                $clnt_arr   =   array('on' => array(), 'off' => array(), 'new' => array());

                // Getting client
                $client = $post_data['client'];

                // Getting client data
		        $client_data    = $this->check_client_access($client);
                // Keeping client ID 
                $clnt_arr['clnt_id'] = encrypt_link($client_data->clnt_id);
                // Setting page title and page head
                $clnt_arr['page_head']    =   'Manage Clients Field Validation - ' . $client_data->clnt_client_name;
                $clnt_arr['page_title']   =   'Client Fieldvalidation';

                $arr            = (array)$client_data; 
                if ($arr) {
                    // Getting config file corresponding to the client ID
                    $client_default_config  =   'client_fieldvalidation';
                    $path =   base_path() . '/config/' . $client_default_config . '.php';
                    $descArr = [];
                    if(File::exists(public_path('dist/client_fieldvalidation.json'))){
                        $descPathJson = File::get(public_path('dist/client_fieldvalidation.json'));
                        if($descPathJson!=""){
                            $descArr = json_decode($descPathJson,true);
                        }
                    }
                
                    if (!file_exists($path)) {
                        $return =   array(
                            'status' => 'failure',
                            'message' => customTrans('sudo_lang.no_cnt_config_file'),
                        );

                    } else {

                        $client_funct_db_arr  =   array();
                        // Fetch client functionalities from database
                        $cfv_tbl = new \App\Models\Client_fieldvalidation();

                        $client_functionalities_db = $cfv_tbl::get_all_records_with_bind_cond('cfv_validate_fields, cfv_status');
                        // Making db values looking identical to the config value
                        if (!empty($client_functionalities_db)) {
                            foreach ($client_functionalities_db as $row) {
                                $client_funct_db_arr[$row->cfv_validate_fields] = $row->cfv_status;
                            }
                        }
                    
                        // Getting client functionality default values from config file
                        $client_config    =   'client_fieldvalidation.fieldvalidation';
                        $clnt_conf_arr    =   Config::get($client_config);
                        // y-yes, n-no

                        foreach ($clnt_conf_arr as $row => $val) {
                            $description = isset($descArr[$row])?$descArr[$row]:"";
                            $new_row     =  $row;
                            if(isset($client_funct_db_arr[$row])) {
                                if($client_funct_db_arr[$row] == 'y' || $client_funct_db_arr[$row] == 'j') {
                                    $clnt_arr['on'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$client_funct_db_arr[$row],'description'=>$description);
                                } else {
                                    $clnt_arr['off'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$client_funct_db_arr[$row],'description'=>$description);
                                }
                            } else {
                                $clnt_arr['new'][] = array('func'=>$row, 'label' => $new_row, 'value'=>$clnt_conf_arr[$row],'description'=>$description);
                            }
                        }
                    }

                    $return =   array(
                        'status' => 'success',
                        'data' => $clnt_arr,
                        'tabs' => array(
                                    'On ('.count($clnt_arr['on']).')',
                                    'Off ('.count($clnt_arr['off']).')',
                                    'New ('.count($clnt_arr['new']).')'
                                    )
                    );
                
            } else {
                $return =   array(
                    'status' => 'failure',
                    'message' => customTrans('sudo_lang.wng_access'),
                );
            }
        } else {
            $return =   array(
                'status' => 'failure',
                'message' => customTrans('sudo_lang.invalid_data'),
            );
        }
        return $return;
    } catch(\Exception $e) {
        return $this->failure('Failed', 500, $e);
    }

}
// Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
    public function save_client_fieldvalidation(Request $request) {
        // y-yes, n-no, 
        $post_data      =   $request->all();
		$client         =   decrypt_link($post_data['clnt_id']);
		$mode           =   $post_data['mode'];
        $cf_post        =   $post_data['clnt_functionality'];

        $return_arr =   array(
            'status' => 'failure',
            'message' => customTrans('sudo_lang.cmn_db_error'),
        );
        
		// Getting client data
        $client_data = $this->check_client_access($client, true);
		if (isset($client_data->status) && $client_data->status == 'false') {
			$return_arr['redirect_url'] = $client_data['redirect_url'];
		}
        // Fetch client functionalities from database
        $cfv_tbl = new \App\Models\Client_fieldvalidation();
        $client_functionalities_db = $cfv_tbl::get_all_records_with_bind_cond('cfv_validate_fields');
        // Making db values looking identical to the config value
        $cf_db_arr  =   array();
        if (!empty($client_functionalities_db)) {
            foreach ($client_functionalities_db as $row) {
                $cf_db_arr[] = $row->cfv_validate_fields;
            }
        }
        // Getting client functionality default values from config file
        $client_config          =   'client_fieldvalidation.fieldvalidation';
        $clnt_functionalities   =   Config::get($client_config);
        
        //fetching functionalities which are not saved in the db
        $cf_cf_arr              =   array_keys($clnt_functionalities);
        $diff_arr               =   array_values(array_diff($cf_cf_arr, $cf_db_arr));
        $diff_cf_arr            =   array();
        
        if(count($diff_arr) > 0) {
            foreach($diff_arr as $key) {
                // Check if associative array contains value, and retrieve key / position in array
                if (isset($clnt_functionalities[$key]) && (in_array($key, array_column($cf_post, 'func')) === false)) {
                        $diff_cf_arr[]  =   array('func' => $key, 'val' => $clnt_functionalities[$key]);
                }
            }
            //merge difference
            $cf_post    =   array_merge($cf_post, $diff_cf_arr);
        }
        
		DB::beginTransaction();
        try {
            if($mode == 'save') {
                if(count($cf_post) == 0) {
                    $return_arr =   array(
                        'status' => 'failure', 
                        'message' => customTrans('sudo_lang.cfv_no_changes'),
                    );
                    return $return_arr;
                }
                foreach ($cf_post as $key)
                {
                    $this->save_sudo_clnt_fields($client_data, $key['func'], $key['val']);
                }
                $msg    =   customTrans('sudo_lang.cfv_updated_suc_msg');
            } else {
                foreach ($clnt_functionalities as $func => $value)
                {
                    $this->save_sudo_clnt_fields($client_data, $func, $value);
                }
                $msg    =   customTrans('sudo_lang.cfv_default_msg');
            }
            DB::commit();
            $return_arr =   array(
                'status' => 'success',
                'message' => $msg,
            );
            return $return_arr;
        }
        catch (\exception $e) {
            DB::rollback();
            return $this->failure('Failed', 500, $e);
        }
	}
// Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
    public function save_client_fieldvalidation_desc(Request $request){
        try
        {
            $post_data      =   $request->all();
            $validator = Validator::make($request->all(),[
                'cfty_name' => 'required',
                'description' => 'required',
            ]);
            
            if ($validator->fails()) {
                return $this->success('failed', 200, $validator->errors()->first());
            }
            
            $data = "";
            $filePath = public_path('dist/client_fieldvalidation.json');
            if (file_exists($filePath)) {
                $existingData = json_decode(file_get_contents($filePath), true);
                if($existingData!=""){
                    $existingData[$post_data['cfty_name']] = $post_data['description'];
                }
                $data = json_encode($existingData,true);
            }else{
                $data = json_encode(array(
                    $post_data['cfty_name'] => $post_data['description'],
                ),true);
            }
            File::put($filePath, $data);

            return $this->success('success', 200, 'Description added successfully');
        } catch (\exception $e) {
            return $this->failure('failed', 500, $e);
        }
    }
// Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
    public function save_sudo_clnt_fields($client_data, $func, $value) {
        // Getting client functionality default values from config file
        
        $client_config          =   'client_fieldvalidation.fieldvalidation';
        $clnt_functionalities   =   Config::get($client_config);
        if (isset($clnt_functionalities[$func])) {
            $time       =   date("Y-m-d H:i:s.") . substr(microtime(false), 2, 3);
            $cfv_tbl = new \App\Models\Client_fieldvalidation();
            $cf_table   =   (new \App\Models\Client_fieldvalidation())->getTable();
            //insert if no data found unless udate the record
            $sql        =   'INSERT INTO ' . $cf_table . ' 
                            ( cfv_validate_fields, cfv_status, cfv_posted_date) 
                            VALUES("' . $func . '", "' . $value . '", "' . $time . '") 
                            ON DUPLICATE KEY UPDATE cfv_status = "' . $value . '", cfv_posted_date = "' . $time . '"';
                            $cfv_tbl::execute_query($sql);
            return $this->success('Success',200,'Created Successfully');
        }
    }

    public function data_insert_update_client_url($current_client){
		$client_data_code =(new All_Clients())->get_single_record_with_bind_cond('count(acls_id) as count,acls_id',array("acls_client_code"=>$current_client->clnt_client_code));
		    $all_client_url = new \App\Models\All_Client_Url();
			$app_url=env('APP_URL','');
			$app_enviorn=config('general_config.app_client_enviorn');
			$client_url_data =(new All_Client_Url())->get_single_record_with_bind_cond('count(clu_id) as count,clu_id',array("clu_url"=>$app_url,'clu_acls_id'=>$client_data_code->acls_id));
			$arra_client_url=['clu_acls_id' =>$client_data_code->acls_id,
			'clu_url' => $app_url,
			'clu_enviornment'=>$app_enviorn,
			'clu_status'=>'y',
			'clu_posted_date' => date("Y-m-d H:i:s"),
			'clu_posted_by' => 0,
			'clu_proxy_id'  => 0
	];
    
			if(isset($client_url_data)&&$client_url_data->count==0){
                $arra_client_url['clu_operation']='i';
			$all_client_url::firstOrCreate(
				$arra_client_url
			);
		     }
			 else{
                $arra_client_url['clu_operation']='u';
				$all_client_url::where('clu_id',$client_url_data->clu_id)->update(	$arra_client_url);
			 }

	}

    public function data_insert_update_client_all_clients($current_client){
		$all_clients = new \App\Models\All_Clients();
			$client_data_code =(new All_Clients())->get_single_record_with_bind_cond('count(acls_id) as count,acls_id',array("acls_client_code"=>$current_client->clnt_client_code));
               $client_array=['acls_client_code' => $current_client->clnt_client_code,
               'acls_client_name' => $current_client->clnt_client_name,
               'acls_posted_date' => date("Y-m-d H:i:s"),
               'acls_posted_by' => 0,
               'acls_proxy_id'  => 0,
               'acls_operation' => 'i'
    ];
			if(isset($client_data_code)&&$client_data_code->count==0){
                $client_array['acls_operation']='i';
			$all_clients::firstOrCreate(
				$client_array
			);
		     }
			 else{
                $client_array['acls_operation']='u';
				$all_clients::where('acls_id',$client_data_code->acls_id)->update($client_array);
			 }
	}

    public function data_insert_client_functionality($fun,$value)
	{
	
			$all_client_functl = new \App\Models\All_Client_Functionalities();
		
				$exist_client_functionality=(new All_Client_Functionalities())->get_single_record_with_bind_cond('count(cfty_id)as count,cfty_id',array('cfty_functionality'=>$fun));
			     $array_functionality=['cfty_functionality' =>$fun,
				 'cfty_status' =>'y',
				 'cfty_posted_date'=>date("Y-m-d H:i:s"),
				 'cfty_posted_by'=>0,
				 'cfty_proxy_id'  => 0];
				if(isset($exist_client_functionality)&&$exist_client_functionality->count==0){
					
					$array_functionality['cfty_operation']='i';
					$all_client_functl::firstOrCreate(
						$array_functionality
					);
				   }
				   else
				   {
					$array_functionality['cfty_operation']='u';
		            $all_client_functl::where('cfty_id',$exist_client_functionality->cfty_id)->update($array_functionality);
				   }		
				
	}

	public function save_client_functionality_status($functionality,$status,$client_data,$client_url_data)
	{
  
		$all_client_functl_status = new \App\Models\All_Client_Functionality_Status();
		$client_functionality_data =(new All_Client_Functionalities())->get_single_record_with_bind_cond('*',array("cfty_functionality"=>$functionality));
		if(!empty($client_functionality_data))
		{
		$client_functionality_status =(new All_Client_Functionality_Status())->get_single_record_with_bind_cond('count(cfst_id) as count,cfst_id',array("cfst_cls_id"=>$client_data->acls_id,'cfst_cfty_id'=>$client_functionality_data->cfty_id));
	
		$array_functs_status=['cfst_cls_id' =>$client_data->acls_id,
		'cfst_cfty_id'=>$client_functionality_data->cfty_id,
		'cfst_clu_id'=>$client_url_data->clu_id,
		'cfst_status' => $status,
		'cfst_posted_date'=>date("Y-m-d H:i:s"),
		'cfst_posted_by'=>0,
		'cfst_proxy_id'  => 0];
		
		if($client_functionality_status->count==0)
		{
            
			$array_functs_status['cfst_operation']='i';
			$all_client_functl_status::firstOrCreate($array_functs_status);
		}
		else
		{
		
		$array_functs_status['cfst_operation']='u';
		 $all_client_functl_status::where('cfst_id',$client_functionality_status->cfst_id)->update($array_functs_status);
		
		}
    
		
	
	  }
	}


}
