<?php

namespace App\Http\Controllers;

use DB;
use Config;
use Exception;

use App\Models\Clients;
use Illuminate\Http\Request;
use App\Models\Client_settings;
use App\Http\Traits\UtilityTrait;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\SudoManagementApi;
class Sudo_Client_Settings extends Controller
{
    use UtilityTrait;

    /*
    *  function to list all clients
    */
    public function view_clients(Request $request){
        try {
            $post_data=request()->all();
                    $client_id='';
                        //fetches all clients if no clnt_id or action.
                    if($post_data['clnt_id']=='' && $post_data['action']==''){
                        $clients=Clients::get_all_records_with_bind_cond('*');
                        $all_clients=[];
                        foreach($clients as $client){
                            $client_data=[
                                'id'=>$client->clnt_id,
                                'name'=>$client->clnt_client_name,
                                'code'=>$client->clnt_client_code,
                                'email'=>$client->clnt_email,
                                'terms'=>$client->clnt_review_terms,
                                'login_message'=>$client->clnt_login_message,
                            ];
                            $path=config_path('clients/').$client->clnt_client_code;
                                 //config files exist check.
                            if (File::exists($path)){
                                    $files = File::files($path);
                                    if(!empty($files)){
                                        $client_data['config']='True';
                                    }else{
                                        $client_data['config']='False';
                                    }
                            }else{
                                $client_data['config']='False';
                            }
                            $all_clients[] = $client_data;
                        }
                        return $this->success('Success',200,$all_clients);
                    }
                        //validating input
                    $validator = Validator::make($request->all(), [
                        'clnt_id' => 'required',
                        'action'=>'required',
                    ]);
                    if ($validator->fails()) {
                        return $this->failure('Failed', 422, $validator->errors());
                    }
                        //check if post_data has client_id
                    if  ($post_data['clnt_id']!=''){
                        $client_id=Rv_decrypt($post_data['clnt_id']);
                            //to view client details
                            if ($post_data['action'] == 'view' && !empty($client_id)) {
                                    //to avoid invalid character error during decryption
                                if (!ctype_digit($client_id)) {
                                    throw new Exception('Invalid client ID');
                                }
                                $client_exists=Clients::get_single_record_with_bind_cond('*',['clnt_id'=>$client_id]);
                                if(!empty($client_exists)){
                                        //fetching client settings and settings
                                    $client = Clients::client_details_with_sett('*', $client_id);
                                    if ($client) {
                                        $client =   $client[0];
                                        $client_data =[
                                            'name' => $client->clnt_client_name,
                                            'code' => $client->clnt_client_code,
                                            'city'=>$client->clnt_client_city,
                                            'region'=>$client->clnt_client_region,
                                            'country'=>$client->clnt_client_country,
                                            'created_at'=>$client->clnt_created_date,
                                            'notes'=>$client->clnt_notes,
                                            'email' => $client->clnt_email,
                                            'phone' => $client->clnt_phone,
                                            'fax' => $client->clnt_fax,
                                            'minkeys' => $client->cs_min_keyword,
                                            'maxkeys' => $client->cs_max_keyword,
                                            'terms' => $client->clnt_review_terms,
                                            'logo'=>$client->clnt_client_logo,
                                            'show_feedback_frm' => $client->cs_show_reg_feedback_frm == 'y' ? "Yes" : "No",
                                        ];
                                        return $this->success('Success',200,$client_data);
                                    }
                                    else {
                                            throw new Exception('Client not found');
                                    }
                                }
                            }
                                //to view terms and conditions
                            elseif ($post_data['action'] == 'terms' && !empty($client_id)) {
                                    if (!ctype_digit($client_id)) {
                                            throw new Exception('Invalid client ID');
                                }
                                    //fetching client terms and condition
                                $client = Clients::get_single_record_with_bind_cond('clnt_review_terms', ['clnt_id' => $client_id]);
                                if ($client->clnt_review_terms!=null) {
                                        $client_data = (object) ['terms' => $client->clnt_review_terms];
                                        return $this->success('Success',200,$client_data);
                                }
                                else {
                                        throw new Exception('No terms and conditions found');
                                }
                            }
                                //to view client config files.
                            elseif ($post_data['action'] == 'config' && !empty($client_id)) {
                                 //to avoid invalid character error during decryption
                                if (!ctype_digit($client_id)) {
                                    throw new Exception('Invalid client ID');
                                }
                                    //fetching client details
                                $client_data =Clients::get_single_record_with_bind_cond('*',['clnt_id'=>$client_id]);
                                if ($client_data!=null){
                                    $path=config_path('clients/').$client_data->clnt_client_code;
                                    $config_file_list=[];
                                    //checking if files exist
                                    if (File::exists($path)){
                                        if (File::isDirectory($path)){
                                            $files = File::files($path);
                                            if(!empty($files)){
                                                foreach ($files as $file) {
                                                    $config_file_list[] = [
                                                        'file' => $file->getFilename(),
                                                        'path' => $file->getPathname(),
                                                    ];
                                                }
                                            }
                                            else{
                                                throw new Exception('No file(s) found');
                                            }
                                            return $this->success('Success',200,$config_file_list);
                                        }
                                    }
                                    else {
                                        throw new Exception('No folder found');
                                    }
                                }
                                else {
                                    throw new Exception('Client details not found');
                                }
                            }
                            else{
                                throw new Exception('Invalid action');
                            }
                    }
                    else {
                        throw new Exception('Invalid client id');
                    }
        }
        catch (Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }

    }
    /*
    *  function to show add or edit form
    */

    public function add_edit_form(Request $request){
        try{
            $post_data=$request->all();
             //checking if client_id exists(edit)
            if(!empty($post_data['clnt_id'])){
                    $edit_client = Rv_decrypt( $post_data['clnt_id']);
                        //to avoid invalid character error during decryption
                    if (!ctype_digit($edit_client)) {
                        throw new Exception('No client found');
                    }
                    $client_exists=Clients::get_single_record_with_bind_cond('*',['clnt_id'=>$edit_client]);
                    if(!empty($client_exists)){
                            //fetch client details and settings
                        $client=Clients::client_details_with_sett('*', $edit_client);
                            if(!empty($client)){
                                $client =   $client[0];
                                $clnt_date_frmt =   $this->Utility('date_format');
                                $file_path = Config::get('general_config.file_retrieval')['file_path'];
                                $logo_path = asset($file_path . '/' . 'clients/'.$client->clnt_client_code.'/'.$client->clnt_client_logo);
                                $client_data =[
                                    'name' => $client->clnt_client_name,
                                    'code' => $client->clnt_client_code,
                                    'city'=>$client->clnt_client_city,
                                    'region'=>$client->clnt_client_region,
                                    'country'=>$client->clnt_client_country,
                                    'notes'=>$client->clnt_notes,
                                    'email' => $client->clnt_email,
                                    'phone' => $client->clnt_phone,
                                    'fax' => $client->clnt_fax,
                                    'login_message' => $client->clnt_login_message,
                                    'minkeys' => $client->cs_min_keyword,
                                    'maxkeys' => $client->cs_max_keyword,
                                    'date_format'=>$client->cs_date_format,
                                    'all_date_formats'=>$clnt_date_frmt['date_format'],
                                    'terms' => $client->clnt_review_terms,
                                    'logo'=>$logo_path,
                                    'show_feedback_frm' => $client->cs_show_reg_feedback_frm,
                                ];
                                return $this->success('Success',200,$client_data);
                            }
                            else{
                                throw new Exception('Client settings not found');
                            }
                    }
                    else{
                        throw new Exception('Client does not exist.');
                    }
            }
             //if no client_id(add)
            else{
                $clnt_date_frmt =  $this->Utility('date_format');
                $client_data =[
                    'name' => null,
                    'code' => null,
                    'city'=>null,
                    'region'=>null,
                    'country'=>null,
                    'created_at'=>null,
                    'notes'=>null,
                    'email' => null,
                    'phone' => null,
                    'fax' => null,
                    'login_message' => null,
                    'minkeys' => null,
                    'maxkeys' => null,
                    'date_format'=> null,
                    'all_date_formats'=>$clnt_date_frmt['date_format'],
                    'terms' => null,
                    'logo'=>null,
                ];
                return $this->success('Success',200,$client_data);
            }
        }
        catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
    /*
    *  function to save client details
    */

    public function save_client_details(Request $request){
        try{
        
            $post_data=$request->all();
            // print_r($post_data);exit;
                //validating input
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'code'=>'required|alpha',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            $validatedData = $validator->validated();
            $decrypt_id=Rv_decrypt($post_data['clnt_id']);
            $data_list = [
                'clnt_client_name' => $validatedData['name'],
                // 'clnt_client_code' => $validatedData['code'],
                'clnt_client_city' => $post_data['city'],
                'clnt_client_region' => $post_data['region'],
                'clnt_created_date'=>date('Y-m-d H:i:s'),
                'clnt_client_country'=>$post_data['country'],
                'clnt_email'=>$post_data['email'],
                'clnt_phone'=>$post_data['phone'],
                'clnt_fax'=>$post_data['fax'],
                'clnt_notes' => $post_data['notes'],
                'clnt_review_terms'=>$post_data['terms'],
                'clnt_login_message'=>$post_data['login_message'],
            ];
            if(empty($post_data['email'])){
                $data_list['clnt_email']='';
            }
            if(empty($post_data['phone'])){
                $data_list['clnt_phone']='';
            }
            if(empty($post_data['phone'])){
                $data_list['clnt_phone']='';
            }
            if(empty($post_data['fax'])){
                $data_list['clnt_fax']='';
            }
            if ($logo = $request->file('logo')) {
                        $client_code = str_replace(' ', '_', $validatedData['code']);
                        $baseDirectory = 'public/uploads/clients/';
                        $destinationPath =    $baseDirectory. $client_code;
                        if (!file_exists($destinationPath)) {
                            mkdir($destinationPath, 0755, true);
                        }
                        $logoname = $logo->getClientOriginalName();
                        $request->logo->storeAs( $destinationPath, $logoname);
                        $data_list['clnt_client_logo']=$logoname;
            }
            //client_id check (insert)
            if ($decrypt_id==''){
                        $data_list['clnt_client_code']=$validatedData['code'];
                        if(!empty($post_data['email'])){
                                $validator = Validator::make($request->all(), [
                                    'email' => 'email|unique:rvw_clients,clnt_email',
                                ]);
                        }
                        if ($validator->fails()) {
                            return $this->failure('Failed', 422, $validator->errors());
                        }
                            //Insert data
                        $client_id=Clients::insert_record($data_list);
                        if(empty($post_data['minkeys'])){
                            $post_data['minkeys']='';
                        }
                        if(empty($post_data['maxkeys'])){
                            $post_data['maxkeys']='';
                        }
                        if(empty($post_data['date_format'])){
                            $post_data['date_format']='';
                        }
                        $insert_settings_table=Client_settings::insert_record(array(
                            'cs_client_id'=>$client_id,
                            'cs_min_keyword'=>$post_data['minkeys'],
                            'cs_max_keyword'=>$post_data['maxkeys'],
                            'cs_date_format'=>$post_data['date_format'],
                            'cs_show_reg_feedback_frm'=>$post_data['show_feedback_frm'],
                        ));
                            //Insertion check
                        if($client_id==TRUE && $insert_settings_table==TRUE){
                            $client_code = str_replace(' ', '_', $validatedData['code']);
                            $client_path=config_path('clients/').$client_code;
                            if (!file_exists($client_path)) {
                                //client folder creation if not existing
                                mkdir($client_path, 0755, true);
                            }
                        }
                        $msg='Created Successfully.';
                        
            }
            else
            {
                if (!ctype_digit($decrypt_id)) {
                    throw new Exception('Invalid client ID');
                }
                    //client_id check (update)
                $client_exist=Clients::get_single_record_with_bind_cond('*', ['clnt_id'=>$decrypt_id]);
                if (!empty($client_exist)) {
                        $data_list['clnt_client_code']=$client_exist->clnt_client_code;
                        if ($logo = $request->file('logo')) {
                            $client_code = str_replace(' ', '_', $validatedData['code']);
                            $baseDirectory = 'public/uploads/clients/';
                                //saving updated logo
                            $destinationPath =  $baseDirectory. $client_code;
                            if (!file_exists($destinationPath)) {
                                mkdir($destinationPath, 0755, true);
                            }
                            $logoname = $logo->getClientOriginalName();
                            $request->logo->storeAs( $destinationPath, $logoname);
                            $data_list['clnt_client_logo']=$logoname;
                        }
                         //update data
                        $client_id=Clients::update_record($data_list,array(
                            'clnt_id' => $decrypt_id
                        ));
                        $update_settings=Client_settings::update_record(array(
                            'cs_min_keyword'=>$post_data['minkeys'],
                            'cs_max_keyword'=>$post_data['maxkeys'],
                            'cs_date_format'=>$post_data['date_format'],
                            'cs_show_reg_feedback_frm'=>$post_data['show_feedback_frm'],
                        ),array(
                            'cs_client_id' => $decrypt_id
                        ));
                        $msg='Updated Successfully.';
                       
                }
                else {
                    throw new Exception('Client not found.');
                }
            }
            
            $current_client = $this->get_client_details();
            
            (new SudoManagementApi)->data_insert_update_client_all_clients($current_client);

			(new SudoManagementApi)->data_insert_update_client_url($current_client);
            return $this->success('Success',201,$msg);
        }
        catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

}