<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Validator;
use App\Models\Currency_master;
use App\Models\Generic_flows;


class Sudo_Currency_Settings extends Controller
{
    /*
    *  function to list all currencies
    */
    public function fetch_currencies(Request $request){
        try {
            $data=$request->all();
            $sort_field = $data['sort_field'] ?? 'curr_id';
            $sort_order = $data['sort_order'] ?? 'desc';
            $limit = $data['per_page'] ?? 10;
            $select = 'curr_id AS id,curr_name AS name,curr_symbol AS symbol,curr_code AS code';
            $condition = 'curr_status ="y"';
            $currencies = Currency_master::get_paginated_records($select, $condition, $sort_field, $sort_order, $limit);
            return $this->success('Success',200,$currencies);               
        }
        catch (Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

    /*
    *  function to add or edit currencies
    */
    public function save_currency_details(Request $request){
        try{
            $rules = [
                'currency_name' => 'required',
                'currency_symbol' => 'required'
            ];
            $messages['currency_code.unique'] = 'Currency code already exists.';
            // $validator = Validator::make($request->all(), [
            //     'currency_name' => 'required',
            //     'currency_code'=>'required|unique:rvw_currency_master,curr_code',
            //     'currency_symbol' => 'required'
            // ],[
            //     'currency_code.unique' => 'Currency code already exists.'
            // ]);
            $post_data = $request->all();
            if($post_data['currency_id']!=""){
                $currencyId = array('input'=>$post_data['currency_id'],'type'=>'string', 'enc_data'=>TRUE );
                $id=Rv_decrypt($post_data['currency_id']);
                $rules['currency_code'] = 'required|unique:rvw_currency_master,curr_code,'.$id.',curr_id';
                $validator = Validator::make($request->all(), $rules, $messages);
                if ($validator->fails()) {
                    return $this->success('failed', 200, $validator->errors()->first());
                }
                $validator = Validator::make($request->all(), $rules, $messages);
                $currencyValidation = $this->Rv_validator($currencyId);
                if($currencyValidation != true){
                    return $this->warning('Warning',200,'Invalid data','Warning');
                }
                $condition = ['curr_id'=>$id];
                $currency = Currency_master::get_single_record_with_bind_cond('*',$condition);
                if($currency){
                    $updt_data = array(
                        'curr_name' => $post_data['currency_name'],
                        'curr_symbol' => $post_data['currency_symbol'],
                        'curr_code' => $post_data['currency_code']
                    );
                    Currency_master::update_record($updt_data,$condition);
                    $message = 'Currency updated successfully';            
                }else{
                    $message = 'Currency updation failed'; 
                }
                
            }else{
                $rules['currency_code'] = 'required|unique:rvw_currency_master,curr_code';
                $validator = Validator::make($request->all(), $rules, $messages);
                if ($validator->fails()) {
                    return $this->success('failed', 200, $validator->errors()->first());
                }
                $data_list = [
                    'curr_name' => $post_data['currency_name'],
                    'curr_symbol' => $post_data['currency_symbol'],
                    'curr_code' => $post_data['currency_code'],
                ];
                Currency_master::insert_record($data_list);
                $message = 'Currency added successfully';
            }

            return $this->success('Success',200,$message);
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

    /*
    *  function to remove currency
    */
    public function delete_currency(Request $request){
        try{
            $currencyId = array('input'=>$request->id,'type'=>'string', 'enc_data'=>TRUE );
            $currencyValidation = $this->Rv_validator($currencyId);
            if($currencyValidation != true){
                return $this->warning('Warning',200,'Invalid data','Warning');
            }
            $currencyId=Rv_decrypt($request->id);
            $this->current_user = $this->get_current_user_details();
            if($currencyId!=""){
                $workflowCurrency = Generic_flows::get_single_record_with_bind_cond('jwf_id',['jwf_curr_id'=>$currencyId]);
                if(!$workflowCurrency){
                    $condition = ['curr_id' => $currencyId];
                    $currencyDelete = Currency_master::delete_records($condition);
                    $message = "";
                    if (!empty($currencyDelete)) {
                        $message = 'Currency removed successfully';
                    }
                    return $this->success('Success', 200, $message);
                }else{
                    return $this->success('Failed', 200, 'Currency cannot delete as it is used in workflow.');
                }
            }else{
                return $this->success('Failed', 200, 'Currency removal failed');
            }       
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
}
