<?php

namespace App\Http\Controllers;

use DB;
use Config;
use Exception;

use App\Models\Clients;
use App\Models\All_Client_Functionalities;
use App\Models\All_Clients;
use App\Models\All_Client_Functionality_Status;
use App\Models\All_Client_Url;
use App\Models\All_Modules;
use App\Models\All_Module_Status;
use App\Models\Modules;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Http\Services\SuperSudoService;
class Sudo_Manage_Modules_Api extends Controller
{
      /*
    * #3239 function to fetch modules
    */

    public function fetch_client_modules(Request $request){
        try {
            //getting post_data.
            $post_data = request()->all();
            $validator = Validator::make($request->all(), [
                'clnt_code' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 422, $validator->errors());
            }
            //client code is set and not empty.
            if(isset($post_data['clnt_code']) && $post_data['clnt_code'] != '') {
                //fetching client id
                $client_code=$post_data['clnt_code'];
                    //check if client exists
                    $client_exists = Clients::get_single_record_with_bind_cond('*',['clnt_client_code'=>$client_code]);
                    if (!empty($client_exists)) {
                        $client_id=$client_exists->clnt_id;
                        //keeping client id and client name
                        $clnt_arr['clnt_id'] =$client_id; 
                        $clnt_arr['clnt_name'] = $client_exists->clnt_client_name;
                        //fetching client modules from db
                        $clnt_mdl=Modules::get_all_records_with_bind_cond('*',['mdl_clnt_id'=>$client_id]);
                        //check if modules exists
                        if (!empty($clnt_mdl)) {
                            //loop through the array of objects
                            foreach ($clnt_mdl as $module) {
                                //For each object, loop through its properties
                                foreach ($module as $key => $value) {
                                    //removing the column prefix
                                        $label   =  implode('_', array_slice( explode( '_', $key ),1 ));
                                        if ($value === 'y' || $value === 'n') {
                                            $clnt_arr['modules'][] = array('module'=>$key, 'label' => $label, 'value'=>$value);
                                        }
                                }
                            }
                        }
                        else {
                            $msg="No modules found";
                            return $this->failure('Failed',200,$msg);
                        }
                    }
                    else {
                        $msg="No clients found";
                        return $this->failure('Failed',200,$msg);
                    }
            }
            return $this->success('Success',200,$clnt_arr);

        } catch(Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
    /*
    *#3239  function to save module changes.
    */
    public function save_client_modules(Request $request){
        try {
            //getting post data
            $post_data = request()->all();
            //validating to ensure only y/n values are inserted.
            $validator = Validator::make($request->all(), [
                'clnt_code' => 'required',
                'modules' => 'required',
            ]);
            if ($validator->fails()) {
                return $this->failure('Failed', 200, $validator->errors()->first());
            }
            $client_code = $post_data['clnt_code'];
            //array containing only input module changes
            $mdl_changes_arr=$post_data['modules'];
        
                //checking if client exists.
                $client_exists = Clients::get_single_record_with_bind_cond('*',['clnt_client_code'=>$client_code]);
                if(!empty($client_exists)) {
                    //getting modules from db
                    $client_id=$client_exists->clnt_id;
                    $mdl_db = Modules::get_single_record_with_bind_cond('*',['mdl_clnt_id'=>$client_id]);
                    if(!empty($mdl_db)) {
                        $mdl_db_arr = [];
                        //setting only the required modules from the db in the array.
                        // foreach ($mdl_db as $column => $value) {
                        //     // Check if the value is 'y' or 'n'
                        //     if ($value === 'y' || $value === 'n') {
                        //         $mdl_db_arr[$column] = $value;
                        //     }
                        // }
                        $i = 0;
                        if(count($mdl_changes_arr)){
                            foreach($mdl_changes_arr AS $key => $mdl_changes){
                                $func = isset($mdl_changes['func'])?$mdl_changes['func']:"";
                                if($func != "" && $mdl_db->$func != $mdl_changes['val'])
                                    $mdl_db_arr[$func] = isset($mdl_changes['val'])?$mdl_changes['val']:'n';
                            }
                        }
                        if(count($mdl_db_arr) == 0){
                            $msg="No changes in modules";
                            return $this->failure('Failed',200,$msg);
                        }
                        //sorting both arrays for comparing.
                        // ksort($mdl_db_arr);
                        // ksort($mdl_changes_arr);
                        // //comparing both arrays.  Equal- No changes, Not equal- Changes exist.
                        // if ($mdl_db_arr === $mdl_changes_arr) {
                        //     //no changes
                        //     $msg="No changes in modules";
                        //     return $this->failure('Failed',200,$msg);
                        // }
                        // else {
                            //updating changes.
                            // $update_mdl = Modules::update_record($mdl_changes_arr,['mdl_clnt_id'=>$client_id]);
                        $update_mdl = Modules::update_record($mdl_db_arr,['mdl_clnt_id'=>$client_id]);
                        if(!empty($mdl_db_arr ))
                        {
                        // if (($key = array_search('mdl_posted_date', $mdl_changes_arr)) !== false) {
                        //         unset($mdl_changes_arr[$key]);
                        //         $mdl_changes_arr = array_values($mdl_changes_arr); // optional: reindex the array
                        //     }
                        foreach($mdl_db_arr as $module=>$value)
                        {
                            $this->save_client_module_common($module,$value,$client_code);
                        }
                        }
                        $msg = "Modules updated successfully.";
                        return $this->success('Success',200,$msg);
                    // }
                    }
                    else {
                            $msg="No modules found";
                            return $this->failure('Failed',200,$msg);
                    }
                }
                else {
                    $msg="Wrong access";
                            return $this->failure('Failed',200,$msg);
                }
        }
        catch (Exception $e){
            return $this->failure('Failed',500,$e->getMessage());

        }

    }

    public function save_client_module_common($func,$value,$client_code){
       
        $current_user = $this->get_current_user_details();
        
        $app_url=env('APP_URL','');
        $client=(new All_Clients())->get_single_record_with_bind_cond("*",array("acls_client_code"=>$client_code));
        $client_url_data=(new All_Client_Url())->get_single_record_with_bind_cond('*',array("clu_acls_id"=>$client->acls_id,'clu_url'=>$app_url));
        
        $this->data_insert_module_functionality($func,$value);
        $this->save_client_module_status($func,$value,$client,$client_url_data);
         $sudo_enabled=config('superSudoServiceConfig.super_sudo_enabled');
         
         if($sudo_enabled==true)
         {
            
            $client_payload=array('funct_name'=>$func,"funct_status"=>$value);
            $response=app(SuperSudoService::class)->update_client_module_vector_db($client_payload);
          }
       return true;
        
    }

    public function data_insert_module_functionality($fun,$value)
	{
	
			$all_client_modules = new \App\Models\All_Modules();
		
				$exist_client_modules=(new All_Modules())->get_single_record_with_bind_cond('count(cm_id)as count,cm_id',array('cm_name'=>$fun));
			     $array_functionality=['cm_name' =>$fun,
				 'cm_status' =>'y',
				 'cm_posted_date'=>date("Y-m-d H:i:s"),
				 'cm_posted_by'=>0,
				 'cm_proxy_id'  => 0];
				if(isset($exist_client_modules)&&$exist_client_modules->count==0){
					
					$array_functionality['cm_operation']='i';
					$all_client_modules::firstOrCreate(
						$array_functionality
					);
				   }
				   else
				   {
					$array_functionality['cm_operation']='u';
		            $all_client_modules::where('cm_id',$exist_client_modules->cm_id)->update($array_functionality);
				   }		
				
	}

	public function save_client_module_status($functionality,$status,$client_data,$client_url_data)
	{
        
  
		$all_client_module_status = new \App\Models\All_Module_Status();
		$client_module_data =(new All_Modules())->get_single_record_with_bind_cond('*',array("cm_name"=>$functionality));
		if(!empty($client_module_data))
		{
		$client_module_status =(new All_Module_Status())->get_single_record_with_bind_cond('count(cms_id) as count,cms_id',array("cms_cls_id"=>$client_data->acls_id,'cms_cm_id'=>$client_module_data->cm_id));
	
		$array_functs_status=['cms_cls_id' =>$client_data->acls_id,
		'cms_cm_id'=>$client_module_data->cm_id,
		'cms_clu_id'=>$client_url_data->clu_id,
		'cms_status' => $status,
		'cms_posted_date'=>date("Y-m-d H:i:s"),
		'cms_posted_by'=>0,
		'cms_proxy_id'  => 0];
		
		if($client_module_status->count==0)
		{
            
			$array_functs_status['cms_operation']='i';
			$all_client_module_status::firstOrCreate($array_functs_status);
		}
		else
		{
		
		$array_functs_status['cms_operation']='u';
		 $all_client_module_status::where('cms_id',$client_module_status->cms_id)->update($array_functs_status);
		
		}
    
		
	
	  }
	}
}