<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Validator;
use App\Models\Release_Version;
use App\Models\Release_Notes;
use App\Models\Release_category;
use App\Models\Release_subtask;
use App\Models\Release_label;
use App\Models\Release_attachments;
use Config;
class Sudo_Release_Notes extends Controller
{
    /*
    *  function to list all currencies
    */
    public function fetch_release_notes(Request $request){
        try {
            $data=$request->all();
            $sort_field = $data['sort_field'] ?? 'rel_id';
            $sort_order = $data['sort_order'] ?? 'desc';
            $limit = $data['per_page'] ?? 10;
            $select = '*';
            $condition = 'rel_status ="y"';
            $currencies = (new Release_Version())->get_paginated_records($select, $condition, $sort_field, $sort_order, $limit);
            return $this->success('Success',200,$currencies);               
        }
        catch (Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

    /*
    *  function to add or edit currencies
    */
    public function save_release_details(Request $request){
        try{
            $rules = [
                'release_title' => 'required',
                'release_version' => 'required'
            ];

            $post_data = $request->all();

            $messages=array();
    
            if($post_data['release_id']!=""){
                $releaseId = array('input'=>$post_data['release_id'],'type'=>'string', 'enc_data'=>TRUE );
                $id=Rv_decrypt($post_data['release_id']);
          
                $validator = Validator::make($request->all(), $rules, $messages);
                if ($validator->fails()) {
                    return $this->success('failed', 200, $validator->errors()->first());
                }
                $validator = Validator::make($request->all(), $rules, $messages);
                $releaseValidation = $this->Rv_validator($releaseId);
                if($releaseValidation != true){
                    return $this->warning('Warning',200,'Invalid data','Warning');
                }
                if(isset($post_data['release_date'])&&$post_data['release_date']!='')
                {
                  $rel_date=$post_data['release_date'];
                }
                else
                {
                    $rel_date=date('Y-m-d H:i:s');
                }
                $condition = ['rel_id'=>$id];
                $release = (new Release_Version())->get_single_record_with_bind_cond('*',$condition);
                if($release){
                    $updt_data = array(
                        'rel_title' => $post_data['release_title'],
                        'rel_number' => $post_data['release_version'],
                        'rel_date' => $rel_date,
                        'rel_status'=>'y'
                    );
                    (new Release_Version())->update_record($updt_data,$condition);
                    $message = 'Release Version updated successfully';
                }else{
                    $message = 'Release Version updation failed';
                }
                
            }else{
               
                $validator = Validator::make($request->all(), $rules, $messages);
                if ($validator->fails()) {
                    return $this->success('failed', 200, $validator->errors()->first());
                }
                $data_list = [
                    'rel_title' => $post_data['release_title'],
                    'rel_number' => $post_data['release_version'],
                    'rel_date' => $post_data['release_date'],
                    'rel_status'=>'y'
                ];
                (new Release_Version())->insert_record($data_list);
                $message = 'Release Version added successfully';
            }

            return $this->success('Success',200,$messages);
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

    /*
    *  function to remove currency
    */
    public function delete_release_version(Request $request){
        try{
            $current_user = $this->get_current_user_details(); 
            $releaseId = array('input'=>$request->id,'type'=>'string', 'enc_data'=>true );
            $releaseValidation = $this->Rv_validator($releaseId);
            if($releaseValidation != true){
                return $this->warning('Warning',200,'Invalid data','Warning');
            }
            $releaseId=Rv_decrypt($request->id);
            $this->current_user = $this->get_current_user_details();
            if($releaseId!=""){
                $releasenote = (new Release_Notes())->get_single_record_with_bind_cond('note_id',['note_release_version_id'=>$releaseId]);
                if(empty($releasenote)){
                   
                    $condition = ['rel_id' => $releaseId];
                    $ReleaseNoteDelete = (new Release_Version())->delete_records($condition, '', $current_user);

                    $message = "";
                    if (!empty($ReleaseNoteDelete)) {
                        $message = 'Release Notes removed successfully';
                    }
                    return $this->success('Success', 200, $message);
                }else{
                    return $this->success('Failed', 200, 'Release Notes cannot delete as it is used in Release version.');
                }
        }else{
                return $this->success('Failed', 200, 'Release Notes removal failed');
            }
        }catch(Exception $e){
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

    public function get_version_data(Request $request){
        try {
            $data=$request->all();
            $release_Id=Rv_decrypt($data['release_id']);
            $releaseId = array('input'=>$release_Id,'type'=>'string', 'enc_data'=>true );
            $releaseValidation = $this->Rv_validator($releaseId);
            if($releaseValidation != true){
                return $this->warning('Warning',200,'Invalid data','Warning');
            }
           
            $select = '*';
            $condition['rel_id'] =$release_Id ;
            $version_data = (new Release_Version())->get_single_record_with_bind_cond($select, $condition);
            return $this->success('Success',200,$version_data);               
        }
        catch (Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
    /*Add  Release Category */
    public function manage_release_category(Request $request){

        try {
            $rules = [
                'cat_title' => 'required',
            ];
            $messages=array();
            $post_data=$request->all();
            $current_user = $this->get_current_user_details();
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) {
                return $this->success('failed', 200, $validator->errors()->first());
            }
            $edit_id=Rv_decrypt($post_data['edit_id']);
            $status =   'success';
            $return_arr['status']=$status;
            $data_list = array(
                'note_cat_title' => trim($post_data['cat_title']),
                'note_cat_posted_by' => $current_user['user_id']
            );
            if($post_data['edit_id']!='')
            {
                
                $msg="Updated successfully";
                $array_cat=array('note_cat_id'=>$edit_id);
                (new Release_category())->update_record($data_list, $array_cat, $current_user);
            }
            else
            {
                $msg="Save successfully"; 
                (new Release_category())->insert_record($data_list);
            }
            $return_array['message']=$msg;
            $return_array['status']=$status;
       
            
            return $this->success("Success",200, $return_arr ); 
        }
        catch (Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }
    }
    /*get  Release Category */
    public function get_release_category(Request $request){
      try{
        
        $return_arr['categorylist']=(new Release_category())->get_all_records('*',array());
        return $this->success("Success",200,$return_arr);
      }
      catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }

    }

    /*delete  Release Category */
    public function delete_release_category(Request $request)
    {
        try
        {
            $post_data=$request->all();
            $rules = [
                'id' => 'required',
            ];
            $messages=array();
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) {
                return $this->success('failed', 200, $validator->errors()->first());
            }
            $delete_id=Rv_decrypt($post_data['id']);
            $status ='success';
            $return_arr['status']=$status;
            $releasenote = (new Release_Notes())->get_single_record_with_bind_cond('note_id',['note_release_version_id'=>$delete_id]);
            if(empty($releasenote)){
                $relese_category=(new Release_category())->delete_records(array('note_cat_id'=>$delete_id));
            
                return $this->success("Success",200,$return_arr); 
            }
            else
            {
          return $this->success('Failed', 200, 'Release Notes cannot delete as it is used in Release version.');
            }
            return $this->success("Success",200,$return_arr); 
        }
        catch (Exception $e) {
            return $this->failure('Failed',500,$e->getMessage());
        }
    }

    /* Release Task list */
    public function fetch_taskboard(Request $request){
        try{
            $post_data=$request->all();
            $rules = [
                'version_id' => 'required',
            ];
            $messages=array();
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) {
                return $this->success('failed', 200, $validator->errors()->first());
            }
            $version_id=Rv_decrypt($post_data['version_id']);
            $release_category=(new Release_category())->get_all_records('*',array());
         $task_array=array();
            if(!empty($release_category))
            {
                  foreach($release_category as $category)
                  {
                // echo $version_id;
                    $task_array[$category->note_cat_id]['id']=$category->note_cat_id;
                    $task_array[$category->note_cat_id]['boardName']=$category->note_cat_title;
                  //  $card_data=(new Release_Notes())->get_all_records_with_bind_cond('*',array("note_category"=>$category->note_cat_id,"note_release_version_id"=>$version_id));
                    $card_data =(new Release_Notes())->where('note_release_version_id', $version_id)
                    ->where('note_category',$category->note_cat_id)
                    ->orderBy('note_order')
                    ->get();
         
                    
                    if(!empty($card_data))
                    {
                        $card_array=array();
                        foreach($card_data as $card)
                        {
                       
                            $card_array[$card->note_id]['note_details']=(new Release_Notes())->get_single_record_with_bind_cond('note_title,note_description,note_date',array('note_id'=>$card->note_id));
                            $card_array[$card->note_id]['subtask_details']=(new Release_subtask())->get_all_records_with_bind_cond('subtask_id as id,subtask_title as subTaskTitle,subtask_complete_status as completed' ,array('subtask_note_id'=>$card->note_id))?->toArray();
                            $card_array[$card->note_id]['label_details']=(new Release_label())->get_all_records_with_bind_cond('notelbl_title as name,notelbl_color as color,notelbl_id',array('notelbl_note_id'=>$card->note_id))?->toArray();
                            $card_array[$card->note_id]['attachments']=(new Release_attachments())->get_all_records_with_bind_cond('noteattch_name,noteattch_size',array('noteattch_note_id'=>$card->note_id))?->toArray();
                        }
                    }
                    $task_array[$category->note_cat_id]['card']=$card_data;
                    $task_array[$category->note_cat_id]['carddata']=$card_array;
                    
                  }
                 
            }
            $return_arr['release_data']=$task_array;
            return $this->success("Success",200,$return_arr);
        }
        catch (Exception $e) {

            return $this->failure('Failed',500,$e->getMessage());
        }
    }
    /*Fetch TaskNote Details */
    public function get_task_note_details(Request $request){
try{
    $post_data=$request->all();
    $rules = [
        'note_id' => 'required',
    ];
    $messages=array();
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
        return $this->success('failed', 200, $validator->errors()->first());
    }
    $note_id=Rv_decrypt($post_data['note_id']);

    $return_array['note_details']=(new Release_Notes())->get_single_record_with_bind_cond('note_title,note_description,note_date',array('note_release_version_id'=>$note_id));
    $return_array['subtask_details']=(new Release_subtask())->get_all_records_with_bind_cond('subtask_title,subtask_id',array('subtask_note_id'=>$note_id));
    $return_array['label_details']=(new Release_label())->get_all_records_with_bind_cond('notelbl_title,notelbl_color,notelbl_id',array('notelbl_note_id'=>$note_id));
    $return_array['attachments']=(new Release_attachments())->get_all_records_with_bind_cond('noteattch_name,noteattch_size',array('noteattch_note_id'=>$note_id));
    return $this->success("Success",200,$return_array);
}
catch (Exception $e) {

    return $this->failure('Failed',500,$e->getMessage());
}
    }

    /* Save Release Note */
   public function save_taskboard(Request $request)
   {
    try{
        $post_data=$request->all();

        $rules = [
            'note_version_id' => 'required',
            'note_title' => 'required',
            //'note_description' => 'required',
            'note_category' => 'required'
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $return_arr=array();
        $current_user = $this->get_current_user_details();
        $version_id=Rv_decrypt($post_data['note_version_id']);
        $note_title=$post_data['note_title'];
        $note_description=$post_data['note_description']??'';
        $note_category=Rv_decrypt($post_data['note_category']);
        $note_date=$post_data['note_date']??date('Y-m-d H:i:s');
        $edit_id=$post_data['note_id']??'';
        $notecount=(new Release_Notes())->get_single_record_with_bind_cond('count(note_id) as countdata',array('note_category'=>$note_category));
        if(isset($notecount->countdata)&&$notecount->countdata!='')
        {
            $countnote=$notecount->countdata+1;
        }
        else
        {
            $countnote=1;
        }

        $data_array=array('note_release_version_id'=>$version_id,
        'note_title'=>$note_title,
        'note_description'=>$note_description,
        'note_category'=>$note_category,
        'note_posted_by'=>$current_user['user_id'],
        'note_date'=>$note_date,
        'note_order'=>$countnote
        );
        
        if($edit_id!='')
        {
        $note_id=array('note_id'=>$edit_id);
        $relese_notes=(new Release_Notes())->update_record($data_array,$note_id,$current_user);
        }
        else
        {
        $relese_notes=(new Release_Notes())->insert_record($data_array);
        }
        $return_arr['success']=$relese_notes;
        return $this->success("Success",200,$return_arr);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }

   }

   public function change_title(Request $request)
   {
    try{
        $post_data=$request->all();
        $current_user = $this->get_current_user_details();
        $rules = [
            'title' => 'required',
            'type'=>'required',
            'boardid'=>'required',
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $type=$post_data['type'];
        $id=Rv_decrypt($post_data['boardid']);
        if($type==='category')
        {
            $data_array=array('note_cat_title'=>$post_data['title']);
            $note_cat=array('note_cat_id'=>$id);
  
            $updation=(new Release_category())->update_record($data_array,$note_cat,$current_user);
        }
        else
        {
            $data_array=array('note_title'=>$post_data['title']);

            $note_cond=array('note_id'=>$id); 
            $updation=(new Release_Notes())->update_record($data_array,$note_cond,$current_user);
        }
        return $this->success("Success",200,$updation);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }
   }
    /* Sub Task list */
   public function sub_task_list(Request $request)
   {
    try{
        $post_data=$request->all();
        $return_array=array();
        $rules = [
            'note_id' => 'required'
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
    $release_subtask=(new Release_subtask())->get_all_records_with_bind_cond('*',array("subtask_note_id"=>$post_data['note_id']));
    $return_array['subtask']=$release_subtask;
    return $this->success("Success",200,$return_array);
   
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }
   }
/* Add Sub Task */
   public function add_sub_task(Request $request)
   {
    try{
        $post_data=$request->all();
        $current_user = $this->get_current_user_details();
        $return_array=array();
        $rules = [
            'note_id' => 'required',
            'sub_task_title'=>'required'
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $data_array=array('subtask_note_id'=>$post_data['note_id'],'subtask_title'=>$post_data['sub_task_title'],'subtask_posted_by'=>$current_user['user_id']);
      
        $return_array['insert']=(new Release_subtask())->insert_record($data_array,$current_user);
        return $this->success("Success",200,$return_array);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }

   }
   /* Remove Sub Task */
   public function delete_sub_task(Request $request)
   {
    try{
        $post_data=$request->all();
        $current_user = $this->get_current_user_details();
        $return_array=array();
        $rules = [
            'subtask_id' => 'required',
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $condition=array('subtask_id'=>$post_data['subtask_id']);
        $return_array['status']=(new Release_subtask())->delete_records($condition, '', $current_user);
        return $this->success("Success",200,$return_array);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }

   }
/* Add Label */
   public function add_label(Request $request)
   {
    try{
        $post_data=$request->all();
        $current_user = $this->get_current_user_details();
        $return_array=array();
        $rules = [
            'name' => 'required',
            'color'=>'required',
            'note_id'=>'required'
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $data_array=array('notelbl_note_id'=>$post_data['note_id'],'notelbl_title'=>$post_data['name'],'notelbl_color'=>$post_data['color']);
      
        $return_array['insert']=(new Release_label())->insert_record($data_array,$current_user);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
    }
   }
/* Remove Label */
   public function delete_label(Request $request)
   {
    try{
    $post_data=$request->all();
    $current_user = $this->get_current_user_details();
    $return_array=array();
    $rules = [
        'label_id' => 'required',
    ];
    $messages=array();
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
        return $this->success('failed', 200, $validator->errors()->first());
    }
    $condition=array('notelbl_id'=>$post_data['subtask_id']);
    $return_array['status']=(new Release_label())->delete_records($condition, '', $current_user);
    return $this->success("Success",200,$return_array);
}
       catch (Exception $e) {
    return $this->failure('Failed',500,$e->getMessage());
       }
   }
   /* save attachment*/
   public function save_attachment(Request $request)
   {
    try{
        $return_array=array();
        $post_data=$request->all();

        $current_user = $this->get_current_user_details();
        $rules = [
            'file' => 'required|file|max:1024'
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $file=$post_data['file'];
        $filename = $file->getClientOriginalName();
    
        $filenameWithoutExtension['filename'] = pathinfo($filename, PATHINFO_FILENAME);
        if(isset($filenameWithoutExtension['filename']))
        {
            $validator = Validator::make($filenameWithoutExtension , [
                'filename'      => 'required|regex:/^[a-zA-Z0-9(),_,-^ ]+$/'
            ]);
            if ($validator->fails()) {
                return $this->failure('error',200,$validator->errors());
            }
            $pattern = '/\s{2,}/';
            if (preg_match($pattern, $filename)) {
                return $this->warning('Warnings',200,array('msg' => 'file name contains multiple adjacent spaces'));
            }
        }
        else
        {
            return $this->warning('Warnings',200,'Invalid file extension');
        }
        $validator = Validator::make($request->all(), [
            'note_id' => 'required',
        ],[
            'file.clamav' => 'The :attribute contains a virus!',
        ]);
        if ($validator->fails()) {


            return response()->json([
                'error' => $validator->errors()->first('file'),
                'file'=>$post_data['file']->getClientOriginalName(),
                'type'=>'clamav'
            ], 200);


        }
        if ($validator->fails()) {
            return  $this->failure('Failed', 200, $validator->errors());
        }
        $path ="note_attachment/";
        $attachment_file = $post_data['file'];
        $note_id=Rv_decrypt($post_data['note_id']);
        $name = $attachment_file->getClientOriginalName();
        $uploaded_file_details = $this->upload_file_handler($path, $attachment_file, $name);
        if ($uploaded_file_details['error'] === false) {
           $data_array=array('noteattch_note_id'=>$note_id,'noteattch_name'=>$uploaded_file_details['name'],'noteattch_size'=>$uploaded_file_details['size']);
           $return_array['insert']=(new Release_attachments())->insert_record($data_array,$current_user);
            
        } else {
            return  $this->warning('Warning', 200, 'Upload failed');
        }
        return $this->success("Success",200,$return_array);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
           }
   }
   public function fetch_attachment(Request $request){
try{
    $post_data=$request->all();
    $return_array=array();
    $rules = [
        'note_id' => 'required'
    ];
    $messages=array();
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
        return $this->success('failed', 200, $validator->errors()->first());
    }
    $note_id=Rv_decrypt($post_data['note_id']);
$release_attachment=(new Release_attachments())->get_all_records_with_bind_cond('noteattch_name as name,noteattch_id as id ',array("noteattch_note_id"=>$note_id));
$file_path = Config::get('general_config.file_retrieval')['file_path'];
$path ="note_attachment/";
if(!empty($release_attachment))
{
    foreach($release_attachment as $attach)
    {

        $attach->url=$this->get_upload_data( $path . '/' . $attach->name);
    }
	
}
$return_array['attachments']=$release_attachment;
return $this->success("Success",200,$return_array);
}
catch (Exception $e) {

    return $this->failure('Failed',500,$e->getMessage());
       }
   }
   /*function delete note */
   public function delete_note(Request $request)
   {
    try{
        $post_data=$request->all();
        $current_user = $this->get_current_user_details();
        $rules = [
            'note_id' => 'required',
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $note_id=Rv_decrypt($post_data['note_id']);
      
        $return_array['note_details']=(new Release_Notes())->delete_records(array('note_id'=>$note_id),'',$current_user);
        $return_array['subtask_details']=(new Release_subtask())->delete_records(array('subtask_note_id'=>$note_id),'',$current_user);
        $return_array['label_details']=(new Release_label())->delete_records(array('notelbl_note_id'=>$note_id),'',$current_user);
        $return_array['attachments']=(new Release_attachments())->delete_records(array('noteattch_note_id'=>$note_id),'',$current_user);
        return $this->success("Success",200,$return_array);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
           }
   }

   public function delete_attachment(Request $request)
   {
    try{
        $post_data=$request->all();
        $current_user = $this->get_current_user_details();
        $rules = [
            'id' => 'required',
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $attach_id=Rv_decrypt($post_data['id']);
        $exist_another_record = (new Release_attachments())->get_single_record_with_bind_cond('noteattch_name',array('noteattch_id'=>$attach_id));

        $folder_path='note_attachment';
        $file_path = public_path() . '/storage/uploads/' . $folder_path . "/";
        $aws_path="uploads/".$folder_path;
        $result=array();
        if (!empty($exist_another_record)) {
        $this->remove_fileinfolder($file_path,$exist_another_record->noteattch_name,$aws_path);
        $result = (new Release_attachments())->delete_records(array('noteattch_id'=>$attach_id), '',$current_user);
        }
        return $this->success("Success",200,$result);
        
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
           }
   }

   public function save_tasks_details(Request $request){
   try{
    $post_data=$request->all();
    $current_user = $this->get_current_user_details();
    $rules = [
        'note_id' => 'required',
    ];
    $messages=array();
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
        return $this->success('failed', 200, $validator->errors()->first());
    }
    $labellist=(new Release_label())->get_single_record_with_bind_cond('notelbl_title',array('notelbl_note_id'=>$post_data['note_id']));
     if(isset($post_data['labels'])&&!empty($post_data['labels']))
     {

        (new Release_label())->delete_records(array('notelbl_note_id'=>$post_data['note_id']));
        foreach($post_data['labels'] as $labels)
        {
           
           $data_array=array('notelbl_note_id'=>$post_data['note_id'],'notelbl_title'=>$labels['name'],'notelbl_color'=>$labels['color']);
        
    $return_array['insert']=(new Release_label())->insert_record($data_array,$current_user);
        }
    }
    
    if(isset($post_data['remaininglabels'])&&$post_data['remaininglabels']==0&&!empty($labellist))
    {
        (new Release_label())->delete_records(array('notelbl_note_id'=>$post_data['note_id']));
    }
    $subtasklist=(new Release_subtask())->get_single_record_with_bind_cond('subtask_title',array('subtask_note_id'=>$post_data['note_id']));
    if(isset($post_data['subTasks'])&&!empty($post_data['subTasks']))
     {
        (new Release_subtask())->delete_records(array('subtask_note_id'=>$post_data['note_id']));
      
        foreach($post_data['subTasks'] as $subtask)
        {
            $data_array=array('subtask_note_id'=>$post_data['note_id'],'subtask_title'=>$subtask['subTaskTitle'],'subtask_posted_by'=>$current_user['user_id']);
            if(isset($subtask['completed']))
            {

            $data_array['subtask_complete_status']=$subtask['completed'];
            }
            $return_array['insert']=(new Release_subtask())->insert_record($data_array,$current_user);
        }
    }

    if(isset($post_data['reminingsubtask'])&&$post_data['reminingsubtask']==0&&!empty($subtasklist))
    {
        (new Release_subtask())->delete_records(array('subtask_note_id'=>$post_data['note_id']));
    }
    $data_array=array();
    if($post_data['description']&&$post_data['description']!=null)
    {
        $data_array['note_description']=$post_data['description'];
    }
    if($post_data['createdDate']&&$post_data['createdDate']!=null)
    {
        $data_array['note_date']=$post_data['createdDate'];
    }

    if($post_data['note_id']!='')
    {
    $note_id=array('note_id'=>$post_data['note_id']);
    (new Release_Notes())->update_record($data_array,$note_id,$current_user);
    }
    
    return $this->success("Success",200,$messages);
  
   }
   catch (Exception $e) {
    return $this->failure('Failed',500,$e->getMessage());
       }
   }

   public function reorder_task(Request $request)
   {
    try{
        $post_data=$request->all();
        $rules = [
            'sourceBoardId' => 'required',
            'destinationBoardId'=>'required',
            'destinationIndex'=>'required',
            'note_id'=>'required',
            'version_id'=>'required'
        ];
        $messages=array();
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return $this->success('failed', 200, $validator->errors()->first());
        }
        $sourcecatid=Rv_decrypt($post_data['sourceBoardId']);
        $destinationcat_id=Rv_decrypt($post_data['destinationBoardId']);
        $note_id=Rv_decrypt($post_data['note_id']);
        $newposition=Rv_decrypt($post_data['destinationIndex']);
        $release_id=Rv_decrypt($post_data['version_id']);
        $messages['msg']="Reorder Success";
        $tasks=(new Release_Notes())->find($note_id);
        $note_condition=array('note_id'=>$note_id);
        if($sourcecatid!=$destinationcat_id)
        {
        (new Release_Notes())->update_record(array('note_category'=>$destinationcat_id),$note_condition);
        
            (new Release_Notes())->where('note_category',$destinationcat_id)
                ->where('note_order', '>=', $newposition)
               // ->where('note_order', '<', $tasks->note_order)
                ->increment('note_order');
    
            (new Release_Notes())->where('note_category', $sourcecatid)
                //->where('note_order', '<=', $newposition)
                ->where('note_order', '>', $tasks->note_order)
                ->decrement('note_order');
        
      
        }
        else
            {
                if($newposition < $tasks->note_order){
                (new Release_Notes())->where('note_category',$destinationcat_id)
                 ->where('note_order', '>=', $newposition)
                 ->where('note_order', '<', $tasks->note_order)
                 ->increment('note_order');
                }else{
                 (new Release_Notes())->where('note_category', $destinationcat_id)
                 ->where('note_order', '<=', $newposition)
                 ->where('note_order', '>', $tasks->note_order)
                 ->decrement('note_order');
                }
            }

        $data_array['note_order']=$newposition;
       
        (new Release_Notes())->update_record($data_array,$note_condition);
        return $this->success("Success",200,$messages);
    }
    catch (Exception $e) {
     return $this->failure('Failed',500,$e->getMessage());
        }

   }

   public function fetch_latest_version(Request $request){
    try{
        $latestRelease=array();
       $latestRelease = (new Release_Version())->select('rel_title as title', 'rel_number')
                                        ->orderBy('rel_posted_date', 'desc')
                                        ->first();
        return $this->success("Success",200,$latestRelease);
    }
    catch (Exception $e) {
        return $this->failure('Failed',500,$e->getMessage());
           }

        }
   


}
