<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Config;
use App\Models\Journal_settings;
use App\Models\Journals;
use App\Models\Article_types;
use App\Models\Volumes;
use App\Models\Generic_flows;
use App\Models\Roles;
use App\Models\Issues;
use App\Models\User_to_journals;
use App\Models\Article_flow;
use App\Models\Articles;
use App\Models\Article_transfer_suggestion;
use App\Models\Issue_management;
use App\Models\Article_export_data;
use App\Models\Article_reviewers;
use App\Models\Reject_reasons;
use App\Models\Authors;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\URL;

class Work_progress_report extends Controller
{
    private $stage_arr   =   array();
    public function index(Request $request)
    {
        try {
            if (($this->current_client->functionality->cfty_show_work_progress_report) && $this->current_client->functionality->cfty_show_work_progress_report=='y') {
                $validator = Validator::make($request->all(), [
                    'jnl_id' => 'required',
                    'jnl_code' => 'required',
                    'role_id' => 'required'
                ]);
                if ($validator->fails()) {
                    return  $this->failure('Failed',422,$validator->errors());  
                }
                $jnl_id     =   decrypt_link($request->jnl_id);
                $jnl_code     =   decrypt_link($request->jnl_code);
                $role_id     =   decrypt_link($request->role_id);

                $req_arr =      array
                                (
                                    'jnl_id' => $jnl_id,
                                    'jnl_code' => $jnl_code,
                                    'role_id' => $role_id,
                                    'records' => '5'
                                );

                //get the user roles permissions to view work progress report
                $criteria   =   "jset_jnl_id = {$jnl_id}";
                $usr_perm_roles =    Journal_settings::get_single_record('jset_view_work_progress_report',$criteria);
                $jnl_data   =   Journals::get_journal_data($jnl_code);
                if (!empty($jnl_data) && !empty($usr_perm_roles)) {
                    //check permission to view work progress report
                    if (!empty($usr_perm_roles->jset_view_work_progress_report) && in_array($role_id,json_decode($usr_perm_roles->jset_view_work_progress_report))) {
                        $data = array();
                        //Article types for select box options
                        $condition  =  "artp_jnl_id = {$jnl_id}";
                        $data['article_types']  =   Article_types::get_all_records('artp_id,artp_article_type',$condition);
                        //article status for select box options
                        /*
                        if ($this->current_client->modules->mdl_review_for_doc == 'n') {
                            $data['article_status_desc'] =    array(
                                'c' => 'Closed', 'r' => 'Rejected', 't' => 'Transferred', 'a' => 'Accepted'
                            );
                        }
                        else{
                            $data['article_status_desc'] =    array(
                                'c' => 'Closed', 'a' => 'Accepted', 'q' => 'In queue'
                            );
                        }
                        // fetch hold permissions
                        if ($this->current_client->functionality->cfty_enable_article_hold == 'y') {
                            $data['article_status_desc']['h'] = 'On hold';
                        }
                        */
                        $current_client   = $this->current_client;
                        $articlePermission = $this->getPermittedArticleStatus($current_client);
                        $data['articleStatus'] = $articlePermission['articleStatus'];
                        //fetch volumes data for filtering issues
                        $vls_cnd = "vol_jnl_id = {$jnl_id}";
                        $data['volumes'] = Volumes::get_all_records('vol_id, vol_title',$vls_cnd);
                        
                        return  $this->success('Success',200,$data);
                    }
                    return $this->warning('Failed',200,'User has no permission to view work progress report');
                }
            }
            return $this->warning('Failed',200,'No permission to view work progress report');
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function fetch_art_type_stages(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'art_type' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());  
            }
            $art_type   =   decrypt_link($request->art_type);
            $crt = "artp_id = $art_type";
            $artp = Article_types::get_single_record('artp_fwm_id',$crt);
            if (!empty($artp)) {
                $crt1 = "jwf_fwm_id = {$artp->artp_fwm_id}";
                $journal_wf = Generic_flows::get_all_records('jwf_id,jwf_stage_name',$crt1);
                return  $this->success('Success',200,$journal_wf);
            }
            return $this->warning('Failed',204,'No data found');
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function fetch_submitted_articles(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_id' => 'required',
                'jnl_code' => 'required',
                'role_id' => 'required',
                'cnt' => 'required',
                'per_page' => 'required',
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());  
            }
            if (isset($this->current_client->functionality->cfty_show_work_progress_report) && $this->current_client->functionality->cfty_show_work_progress_report=='y') {
                $user_data  =   $this->get_current_user_details();

                $jnl_id     =   decrypt_link($request->jnl_id);
                $jnl_code     =   decrypt_link($request->jnl_code);
                $role_id     =   decrypt_link($request->role_id);
                $pagi     =   $request->cnt;
                $page_no   =$request->page;
                $searchdata=$request->paramsdet;
                // var_dump($request->paramsdet);exit;
                $req_arr =      array
                                (
                                    'jnl_id' => $jnl_id,
                                    'jnl_code' => $jnl_code,
                                    'role_id' => $role_id,
                                    'records' => $pagi,
                                    'pageno'  => $page_no,
                                    'form_data'=>$searchdata

                                );
                //get the user roles permissions to view work progress report
                $criteria   =   "jset_jnl_id = {$jnl_id}";
                $usr_perm_roles =    Journal_settings::get_single_record('jset_view_work_progress_report',$criteria);
                $jnl_data   =   Journals::get_journal_data($jnl_code);
                $show_minified_version =   'no';
                if (!empty($usr_perm_roles) && !empty($jnl_data)) {
                    //check permission to view work progress report
                    if (!empty($usr_perm_roles->jset_view_work_progress_report) && in_array($role_id,json_decode($usr_perm_roles->jset_view_work_progress_report))) {
                        $return     =   array();
                        $review_flow    =   Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');
                        $stgs_aftr_prod = array();
                        foreach ($review_flow as $key => $value) {
                            if (isset($value['stage_for']) && $value['stage_for'] == 'manageproduction') {
                                array_push($stgs_aftr_prod,$key);
                            }
                        }
                        $prod_stage = $this->get_production_stages_keys();
                        $all_roles  =  Roles::get_all_records('role_id,role_assigned_role');
                        $prod_roles = array();
                        if (!empty($all_roles)) {
                            foreach ($all_roles as $key1 => $value1) {
                                if ($this->current_client->modules->mdl_production == 'y' && ($value1->role_assigned_role == 'copy_editor' || $value1->role_assigned_role == 'type_setter' ||  $value1->role_assigned_role == 'proof_reader' ||  $value1->role_assigned_role == 'production_manager' ||  $value1->role_assigned_role == 'author')) {
                                    array_push($prod_roles,$value1->role_id);
                                }
                            }
                        }
                        //check active role is production role, if so show only the production stages
                        $prd_stgs_only      =   in_array($role_id,$prod_roles) ? true : false;
                        $article_details    =   $this->fetch_articles($req_arr,$jnl_data->jset_date_format);
                        $articles           =   $article_details['article_result'];    
                        $articles_return    =   array();
                        foreach ($articles as $key => $value) {
                            $art_id         =   $value->art_id;
                            $art_artp_id    =   $value->art_artp_id;
                            $art_flw_str    =   $value->article_flow_string;
                            $ats_article_data   =   $value->ats_article_data;
                            $jwf_fwm_id_arr     =   array();
                            $art_flw_ids_arr    =   array();
                            $jwf_ids_arr        =   array();
                            $stage_occurances   =   array();
                            $journal_wf_arr     =   array();
                            $jwf_dls_arr     =   array();
                            $this->stage_arr    =   array();
                            $art_flw_arr    =   explode(',',$art_flw_str);

                            $Authors    =   new \App\Models\Authors;
                            $chk_author =   $Authors::get_single_record('count(auth_id) as count', 'auth_usr_id=' . $user_data['user_id'] . ' AND auth_art_id=' . $art_id);
                            $is_author  =   (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;

                            // if($is_author == TRUE){
                            //     $status_link = $this->author_status_link($art_stage, $is_reviewer, $jnl_code);
                            // } else {
                            //     $status_link = $this->set_article_url($art_stage, $skip_review_author, $core_role);
                            // }

                            $articles_return['articles'][$key] = [
                                'art_id' => $art_id,
                                'art_artp_id' => $art_artp_id,
                                'art_code' => $value->art_code,
                                'ats_article_data' => $ats_article_data,
                                'journal_wf' => [],
                            ];
                            foreach ($art_flw_arr as $k => $v) {
                                $article_flow_arr   =   explode('#$#',$v);
                                $aflw_jwf_id        =   $article_flow_arr[0] ?? '';
                                $aflw_id            =   $article_flow_arr[1] ?? '';
                                $jwf_stage_type     =   $article_flow_arr[2] ?? '';
                                $parent_flow_id     =   $article_flow_arr[3] ?? '';
                                $aflw_acptd_date    =   $article_flow_arr[5] ?? '';
                                $aflw_rtrnd_date    =   $article_flow_arr[6] ?? '';
                                $aflw_due_date      =   $article_flow_arr[7] ?? '';
                                $remaining_days     =   $article_flow_arr[8] ?? '';
                                $aflw_usr_id        =   $article_flow_arr[9] ?? '';
                                $aflw_skip_rvw      =   $article_flow_arr[10] ?? '';
                                $jwf_fwm_id         =   $article_flow_arr[11] ?? '';
                                $aflw_status = '';

                                if (isset($article_flow_arr[4])) {
                                    if ($jwf_stage_type == 'review') {
                                        //check min stage users for review with count of review completed
                                        $slct   =   "COUNT(rf.`aflw_status`) rvw_cnt";
                                        $cnd    =   array(
                                            "rf.aflw_art_id" => $art_id, 
                                            "jw.jwf_stage_type" => 'review',
                                            "rf.aflw_status" => 'c'
                                        );
                                        $art_flw_tbl    =   (new Article_flow())->getTable().' as rf';
                                        $jnl_flw_tbl    =   (new Generic_flows())->getTable().' as jw';
                                        $tbls = [
                                            "main_table" => $art_flw_tbl,
                                            "join_table" => [
                                                $jnl_flw_tbl => ["rf.aflw_jwf_id", "jw.jwf_id", "left"],
                                            ],
                                        ];
                                        
                                        $rev_cnt        =   Article_flow::get_results_using_joins($tbls,$slct,$cnd);
                                        $art_min_usrs   =   $article_flow_arr[12];
                                        $aflw_status    =   ($art_min_usrs <= $rev_cnt[0]->rvw_cnt) ? 'c' : $article_flow_arr[4];
                                    }else {
                                        $aflw_status    =  $article_flow_arr[4];
                                    }
                                }
                                
                                if ($aflw_skip_rvw == 'n') {
                                    if ($jwf_stage_type == 'review' && $parent_flow_id != 'null') {
                                       continue;
                                    }
                                    array_push($art_flw_ids_arr,$aflw_jwf_id);
                                    $jwf_ids_arr[$aflw_jwf_id]  = $aflw_id;  
                                    $jwf_fwm_id_arr[$aflw_jwf_id]   =   $jwf_fwm_id;

                                    //if awaiting assignment stage , then show roles who can assign the users
                                    if ($aflw_status == 'p' && in_array($jwf_stage_type,$prod_stage)) {
                                        $current_stage_details  =   Article_flow::get_stage_details('aflw_id = '.$aflw_id.'','jwf_parent_user_roles');
                                        //role who is assigning users
                                        $assigning_roles = json_decode($current_stage_details->jwf_parent_user_roles);
                                        if (count($assigning_roles) > 0) {
                                            $role_select        =   'GROUP_CONCAT(role_name SEPARATOR ",") as roles';
                                            $role_where         =   'role_id in ('.implode(',',$assigning_roles).')';
                                            $who_can_assign     =   Roles::get_single_record($role_select,$role_where);
                                            $display_username   =   ($who_can_assign->roles != '') ? $who_can_assign->roles : '';
                                        }
                                    }
                                    else {
                                        $display_username   =   $this->fetch_user_display_name($art_id,$aflw_usr_id,$aflw_jwf_id,$aflw_id,$jnl_id);    
                                    }
                                    //fetch popover data params
                                    $popover_param  =   array(
                                        'art_id' => $art_id,
                                        'aflw_jwf_id' => $aflw_jwf_id,
                                        'aflw_id' => $aflw_id,
                                        'jwf_stage_type' => $jwf_stage_type,
                                        'aflw_accepted_date' => $aflw_acptd_date,
                                        'aflw_returned_date' => $aflw_rtrnd_date,
                                        'aflw_due_date' => $aflw_due_date,
                                        'remaining_days' => abs($remaining_days),
                                        'user_display_name' => $display_username, 
                                        'jwf_fwm_id' =>$jwf_fwm_id,
                                        'first_jnl_stage_id' => $art_flw_ids_arr[0],
                                        'jset_date_format' => $jnl_data->jset_date_format,
                                        'jnl_code' => $jnl_data->jnl_journal_code
                                    );
                                    //fetch multiple occurances of each stages (review stage type is avoided)
                                    if ($jwf_stage_type != 'review' && $aflw_usr_id != 'null') {
                                        $stage_occurances[$aflw_jwf_id][]            =   array($aflw_id,$aflw_rtrnd_date);
                                    }
                                    $jwf_dls_arr[$aflw_jwf_id] = [
                                        'data' => $this->fetch_popover_data($popover_param),
                                        'display_username' => $display_username,
                                        "aflw_status" => $aflw_status,
                                        'aflw_accepted_date' => $aflw_acptd_date,
                                        'aflw_returned_date' => $aflw_rtrnd_date,
                                        'aflw_due_date' => $aflw_due_date,
                                        'remaining_days' => abs($remaining_days),
                                        'aflw_skip_review' => $aflw_skip_rvw,
                                    ];
                                }
                            }

                            //fetch the first stage of article flow
                            $first_art_stage    =   $art_flw_ids_arr[0]; 
                            if (isset($this->current_client->functionality->cfty_show_minified_work_progress_chart) && $this->current_client->functionality->cfty_show_minified_work_progress_chart =='n') {
                                //if transfer type is "move with data"
                                if ($ats_article_data == '2') {
                                    //fetch the new article type's fwm_id
                                    $dest_fwm_id        =   end($jwf_fwm_id_arr);
                                    $ftch_jwf_sngl_res  =   Generic_flows::get_single_record("jwf_id","jwf_fwm_id = {$dest_fwm_id}");
                                    $first_art_stage    =   $ftch_jwf_sngl_res->jwf_id;
                                }

                                $generic_wf         =   array_reverse($this->fetch_stage_order($first_art_stage,array()));
                                //stages like transfer does not have parent stage, so those stages are pushed to the array
                                $diff_arr           =   array_unique(array_values(array_diff($art_flw_ids_arr, $generic_wf)));
                                if (!empty($diff_arr)) {
                                    if($ats_article_data == '2')
                                        $generic_wf    =   array_merge($diff_arr, $generic_wf);
                                    else
                                        $generic_wf    =   array_merge($generic_wf, $diff_arr);
                                }
                                $show_minified_version =   'no';
                            } 
                            else {
                                $generic_wf =   array();
                                foreach ($art_flw_ids_arr as $afi_key => $afi_val) {
                                    $skip_rvw   =   Article_flow::get_single_record("aflw_skip_review","aflw_art_id = $art_id AND aflw_jwf_id = $aflw_jwf_id");
                                    if ($skip_rvw->aflw_skip_review !='y') {
                                        array_push($generic_wf,$afi_val);
                                    }
                                }
                                $show_minified_version =   'yes';
                            }
                            
                            // for checking laste stage
                            $reach_in_progress  =   false;
                            $not_applicable  =   false;
                            $in_progress    =   end($art_flw_ids_arr);
                            foreach ($generic_wf as  $jwf_key => $stgid) {
                                $cnt = isset($stage_occurances[$stgid]) ? count($stage_occurances[$stgid]) : 0;
                                if ($in_progress == $stgid) {
                                    $label = (isset($jwf_dls_arr[$stgid]['aflw_status']) && $jwf_dls_arr[$stgid]['aflw_status'] == 'c') ? 'success' : 'warning';
                                    $reach_in_progress = true;
                                } else {
                                    if (isset($jwf_ids_arr[$stgid]) && $jwf_ids_arr[$stgid] != '') {
                                        $label = 'success';
                                        $label = ($cnt > 1) ? 'danger' : $label;
                                        $label = (isset($jwf_dls_arr[$stgid]['aflw_skip_review']) && $jwf_dls_arr[$stgid]['aflw_skip_review'] == 'y') ? 'secondary' : $label;
                                    } else {
                                        $label = ($reach_in_progress == false) ? 'secondary' : 'info';
                                        if($reach_in_progress == true)
                                            $not_applicable  =   true;
                                    }
                                }

                                $journal_wf_param   =   [
                                    "jwf_id"    =>  $stgid,
                                    "prd_stgs_only" =>  $prd_stgs_only,
                                    "stgs_aftr_prod" => $stgs_aftr_prod,
                                    "label" => $label
                                ];
                                
                                $journal_wf_arr[$jwf_key]['stage_details']    =   $this->fetch_journal_flow_arr($journal_wf_param, $reach_in_progress, $not_applicable);
                                $journal_wf_arr[$jwf_key]['popover_data']     =   isset($jwf_dls_arr[$stgid]) ? $jwf_dls_arr[$stgid] : array();
                            }
                            $articles_return['articles'][$key]['journal_wf']         =   $journal_wf_arr; 
                            $articles_return['articles'][$key]['view_article_link']  =   $this->create_view_article_link($art_id, end($jwf_ids_arr), $jnl_data->jnl_journal_code);
                            // $articles_return[$art_id]['aflw_jwf_id']        =   $art_flw_ids_arr;
                            // $articles_return[$art_id]['stage_occurances']   =   $stage_occurances;
                            // $articles_return[$art_id]['aflw_id']            =   $jwf_ids_arr;
                        }
                        $articles_return["total_records"]   =   $article_details['count_result'];
                        $articles_return["show_minified_version"]   =   $show_minified_version;
                        return $this->success('Success',200, $articles_return);
                    }
                    // return $this->warning('Failed',204,'User has no permission to view work progress report');
                    return $this->success('Success',200, array('articles' => array(), 'total_records' => 0, 'show_minified_version' => null));
                }
            } else {
                return $this->warning('Warning',200, array('message' =>'Work progress chart not enabled', 'redirect' => true));
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function fetch_articles($post_data,$jset_date_format)
    {
        try {
            $user_data  =   $this->get_current_user_details();
            $seperator = '#$#';
            $all_roles  =  Roles::get_all_records('role_id,role_assigned_role');
            $permitted_roles = $production_roles    =   array();
            if (!empty($all_roles)) {
                foreach ($all_roles as $key => $value) {
                    if ($value->role_assigned_role == 'staff' || $value->role_assigned_role == 'journal_admin' || ($value->role_assigned_role == 'production_manager' && $this->current_client->modules->mdl_production == 'y')) {
                        array_push($permitted_roles,$value->role_id);
                    }
                    if ($this->current_client->modules->mdl_production == 'y' && ($value->role_assigned_role == 'copy_editor' || $value->role_assigned_role == 'type_setter' ||  $value->role_assigned_role == 'proof_reader' ||  $value->role_assigned_role == 'production_manager' ||  $value->role_assigned_role == 'author')) {
                        array_push($production_roles,$value->role_id);
                    }
                }
            }
            $limit_query        =   '';    
            $art_id_srch        =   '';
            $art_type_srch      =   '';
            $stage_srch         =   '';
            $issues_srch        =   '';
            /************status************
             * a - accepted article 
             * r - reject article
             * t - transfered article
             * y - aricle submit complete
             * c - production completed article
             * d - declined 
             * b - bioxriv article
             * n - not complete article
            */
            $art_status_srch = " AND `art`.`art_status` IN('c','a','r','t','y')";
            if ($this->current_client->modules->mdl_review_for_doc == 'y') {
                $art_status_srch = " AND `art`.`art_status` IN('c','a','q','y')";
            }
            $date_type_srch     =   '';
            $sub_date_srch      =   '';
            $start_date_srch    =   '';
            $end_date_srch      =   '';
            $prodcondition      =   '';
            $page   =   (isset($post_data['pageno']) ? $post_data['pageno'] : '1');
            //5records in dashboard and all records in full view page
            $articles_per_page  =   (isset($post_data['records']) ? $post_data['records'] : '20');
            $offset =   ($page > 0 ? ($page-1)*$articles_per_page : '0');
            if (isset($post_data['form_data'])) {
                $form_data  =   $post_data['form_data'];
                if (isset($form_data['not_assigned']) && $form_data['not_assigned'] == 1) {
                    $issues_srch    =   ' AND `ism`.`ism_iss_id` IS NULL';
                } else {
                    //volumes search
                    if (isset($form_data['volumes']) && $form_data['volumes'] !=  "") {
                        //issues search if selected
                        if (isset($form_data['issues']) && count($form_data['issues']) > 0) {
                            $issue_str  =  array();;
                            foreach ($form_data['issues'] as $isus) {
                                $issue_str[] = $isus;
                            }
                           
                            $issues_srch = ' AND `ism`.`ism_iss_id` IN (' . implode(',', $issue_str) . ')';
                        } else {
                            //if no issues selected, then its all issues are fetched and given for the search
                            $vol_id =   $form_data['volumes'];
                            $cnd_vol =  "iss_vol_id = {$vol_id}";
                            $issue_array    =   Issues::get_all_records('iss_id',$cnd_vol);
                            if (count($issue_array) > 0) {
                                $issue_str  =   '';
                                foreach ($issue_array as $key => $value) {
                                    $issue_str  .=   $value->iss_id.',';
                                }
                                $issues = rtrim($issue_str,',');
                                $issues_srch = ' AND `ism`.`ism_iss_id` IN (' . $issues . ')';
                            }
                        }
                    }
                }
                //article code search
                if (isset($form_data['article_id']) && $form_data['article_id'] != "") {
                    $art_id_srch =  ' AND `art`.`art_code` LIKE "%'.trim($form_data['article_id']).'%"';        
                }  
                //article type search
                if (isset($form_data['article_type']) && $form_data['article_type'] != "") {
                    $art_type_srch  =   ' AND `art`.`art_artp_id` = '.$form_data['article_type'].'';
                }
                //stage search
                if (isset($form_data['stage']) && $form_data['stage'] != "") {
                    $stage_srch     =   ' AND `af`.`aflw_jwf_id` = '.$form_data['stage']. '';
                }
                //date submission search
                if (isset($form_data['date_selection']) && $form_data['date_selection'] != "") {
                    if ($form_data['date_selection'] == 'd') {
                        $sub_date   =   date("Y-m-d",strtotime($form_data['submission_date']));
                        $sub_date_srch  =   ' AND `art`.`art_submission_date` LIKE  "%' . $sub_date . '%"';
                    }
                    else {
                        $start_date =   date("Y-m-d",strtotime($form_data['start_date']));
                        $end_date   =   date("Y-m-d",strtotime($form_data['end_date']));
                        $sub_date_srch  =   ' AND `art`.`art_submission_date` BETWEEN "' .$start_date. '" AND "' .$end_date. '"';  
                    }
                }
                //article status/decision search
                if (isset($form_data['article_status']) && !in_array($form_data['article_status'],array('h'))) {
                    if ($form_data['article_status'] == 'c' || $form_data['article_status'] == 'a') {
                        $art_status_srch = " AND `art`.`art_status` = '{$form_data['article_status']}' AND `art`.`art_status` != 'w' AND `art`.`art_delete_status` !='w' AND `art`.`art_delete_status` !='h'";
                    }
                    else {
                        $art_status_srch = " AND `art`.`art_status` = '{$form_data['article_status']}' AND `art`.`art_status` !='w' AND `art`.`art_delete_status` !='w'";;
                    }
                }
                elseif (isset($form_data['article_status']) && $form_data['article_status'] == 'h') {
                    $art_status_srch    =   " AND `art`.`art_delete_status` = 'h'";
                }
            }
            $blnd_condition = "";
            $blinded_articles   =   $this->get_blinded_articles($user_data['user_id']);
            if (!empty($blinded_articles)) {
                $blnd_condition =   ' AND art_id NOT IN ('.$blinded_articles.')';
            }
            if (!empty($production_roles) && !empty($permitted_roles)) {
                $subcondition   =   '';	
                $usrtojnl = (new User_to_journals())->getTable();
                $prod_roles_str = implode(',',$production_roles);
                $permitted_roles_str = implode(',', $permitted_roles);
                $hav_role_in_art_type = "(SELECT COUNT(usj.usrj_id) FROM $usrtojnl as usj WHERE usj.usrj_jnl_id = {$post_data['jnl_id']} AND usj.usrj_artp_id IS NOT NULL AND usj.usrj_artp_id = art.art_artp_id AND usj.usrj_role_id IN ($prod_roles_str) AND usj.usrj_usr_id = {$user_data['user_id']} AND usj.usrj_role_retired = 'n')";
                $subcondition   .=   "(IF(($hav_role_in_art_type > 0 AND FIND_IN_SET(jw.jwf_role_id,'$prod_roles_str') > 0),TRUE,FALSE) AND jw.jwf_stage_type NOT IN('author_submission','transit','resubmission','revision','copyright'))";
                if (!in_array($post_data['role_id'],$production_roles)) {
                    $subcondition   .=  " OR IF((SELECT COUNT(usj.usrj_id) FROM $usrtojnl as usj WHERE usj.usrj_jnl_id = {$post_data['jnl_id']} AND usj.usrj_artp_id IS NOT NULL AND usj.usrj_artp_id = art.art_artp_id AND usj.usrj_role_id IN($permitted_roles_str) AND usj.usrj_usr_id = {$user_data['user_id']} AND usj.usrj_role_retired = 'n') > 0, TRUE,FALSE)";
                }
                if ($subcondition != '') {
                    $subcondition   .=  " OR af.aflw_usr_id = {$user_data['user_id']}";
                    $prodcondition   =  " AND ($subcondition)";

                }
            }
            $limit_query    =   ' LIMIT '.$offset.', '.$articles_per_page.'';
            $order_query    =   ' ORDER BY `art`.`art_id` desc';
            $group_query    =   ' GROUP BY `art`.`art_id`';
            $art_flw_tbl    =   (new Article_flow())->getTable();
            $jnl_flw_tbl    =   (new Generic_flows())->getTable();
            $art_tbl        =   (new Articles())->getTable();
            $art_typ_tbl    =   (new Article_types())->getTable();
            $art_tnsfr_tbl  =   (new Article_transfer_suggestion())->getTable();
            $iss_mng_tble   =   (new Issue_management())->getTable();

            $query  =   "SELECT SQL_CALC_FOUND_ROWS `art`.`art_id`, `ism`.`ism_iss_id`, `art`.`art_title`, `art`.`art_artp_id`, `art`.`art_code`, `ats`.`ats_article_data`, `art`.`art_stage_submission_method`, (
                            SELECT GROUP_CONCAT(
                                CONCAT(
                                    aflw_jwf_id,'$seperator',aflw_id,'$seperator',jw2.jwf_stage_type,'$seperator',"
                                    ." IF(aflw_parent_flow_id IS NULL,'null',aflw_parent_flow_id),'$seperator',aflw_status,'$seperator',"
                                    ." IF(aflw_accepted_date IS NULL,'null',aflw_accepted_date),'$seperator',"
                                    ." IF(aflw_returned_date IS NULL,'null',aflw_returned_date),'$seperator',"
                                    ." IF(aflw_due_date IS NULL,'null', IF(aflw_status IN ('c', 'd'),'null',aflw_due_date)),'$seperator',"
                                    ." IF(aflw_due_date IS NULL,'0', IF(aflw_status IN ('c', 'd'),'0', IF(NOW() < aflw_due_date,'0',DATEDIFF(aflw_due_date,NOW())))),'$seperator',"
                                    ." IF(aflw_usr_id IS NULL,'null',aflw_usr_id),'$seperator',aflw_skip_review,'$seperator',`jw2`.`jwf_fwm_id`,'$seperator',aflw_stage_min_users
                                ) ORDER BY `aflw_id` ASC SEPARATOR ','
                            ) FROM $art_flw_tbl JOIN $jnl_flw_tbl as `jw2` ON `aflw_jwf_id` = `jw2`.`jwf_id` WHERE `aflw_art_id` = `art`.`art_id`
                            ) AS article_flow_string
                            FROM $art_tbl  AS `art`
                            JOIN $art_typ_tbl AS `artp` ON `artp`.`artp_id` = `art`.`art_artp_id`
                            JOIN $art_flw_tbl AS `af` ON `af`.`aflw_art_id` = `art`.`art_id`
                            JOIN $jnl_flw_tbl AS `jw` ON `af`.`aflw_jwf_id` = `jw`.`jwf_id`
                            LEFT JOIN $art_tnsfr_tbl AS `ats` ON `ats`.`ats_art_id` = `art`.`art_id` AND `ats`.`ats_author_action` = '1'
                            LEFT JOIN $iss_mng_tble AS `ism` ON `ism`.`ism_art_id` = `art`.`art_id`
                            WHERE 
                            `artp`.`artp_jnl_id` = {$post_data['jnl_id']} AND `art_delete_status` != 'y'
                            " . $art_id_srch . $art_type_srch . $stage_srch . $art_status_srch . $sub_date_srch
                                . $prodcondition . $issues_srch . $blnd_condition . $group_query . $order_query . $limit_query 
                            ."
                        ";
                        
            return  Articles::get_article_count_and_rows($query);   
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function fetch_user_display_name($art_id,$assgn_usr_id,$aflw_jwf_id,$aflw_id,$jnl_id)
    {
        $stage_res  =   Generic_flows::get_single_record("`jwf_role_id`,`jwf_stage_type`","jwf_id = {$aflw_jwf_id}");
        $stage_role =   Roles::get_single_record("role_name","role_id = {$stage_res->jwf_role_id}");
        $user_details   =   array();
        //Author without confirmation
        $without_au_confirmation = FALSE;
        if ($this->current_client->functionality->cfty_allow_transfer_without_au_confirmation == 'y') {
            $transfer_without_au_confirmation   =   Article_transfer_suggestion::get_transfer_details($art_id,$aflw_id);
            if (isset($transfer_without_au_confirmation->ats_without_au_confirmation_usr_role) && $transfer_without_au_confirmation->ats_without_au_confirmation_usr_role != 0 && $stage_res->jwf_stage_type == 'transit') {
                $without_au_confirmation = TRUE;
            }

        }
        if ($assgn_usr_id != 'null') {
            $array_data = array(
                "user_id" => $assgn_usr_id,
                "journal_id" => $jnl_id,
                "flag" => TRUE,
                "article_id" => $art_id
            );
            $user_display_name  =   $this->get_user_display_name($array_data);
            // $user_details['fullname'] = $without_au_confirmation ? $user_display_name['fullname'] : $user_display_name['fullname'].'('.$stage_role->role_name.')';
            $user_details['fullname'] = $user_display_name;

            $user_details['rolename']   =   '';
            if($without_au_confirmation == false)
                $user_details['rolename']   =   '('.$stage_role->role_name.')';

            $user_details['user_id']    =   $user_display_name['user_id'];
            return $user_details;
        }
        $user_details['assgn_usr_role']   =   $stage_role->role_name;
        return $user_details;
    }

    public function fetch_popover_data($popover_param)
    {
        if ($popover_param['jwf_stage_type'] == 'review') {
            //for review stage type show shortlisted data
            $stg_name_res   =   Generic_flows::get_single_record("`jwf_stage_type`, `jwf_stage_name`, `jwf_assignment`","jwf_id = {$popover_param['aflw_jwf_id']}");
            $select = 'count(aflw_id) as aflw_id,SUM(CASE WHEN (aflw_status ="u" or (aflw_status="g" and aflw_usr_id not in (select aflw_usr_id from rvw_article_flow where aflw_status in ("a","i","c","u","d") and aflw_parent_flow_id='.$popover_param['aflw_id'].'))) THEN 1 ELSE 0 END) AS short_list_count,SUM(CASE WHEN aflw_status ="c" THEN 1 ELSE 0 END) AS submitted_count, SUM(CASE WHEN aflw_status ="a" THEN 1 ELSE 0 END) AS accepted_count, SUM(CASE WHEN aflw_status ="i" THEN 1 ELSE 0 END) AS invited_count, SUM(CASE WHEN aflw_status="d" and aflw_usr_id not in (select aflw_usr_id from rvw_article_flow where aflw_status in ("a","i","c","u") and aflw_parent_flow_id='.$popover_param['aflw_id'].') THEN 1 ELSE 0 END) AS declined';
            $criteria   =   "aflw_parent_flow_id = {$popover_param['aflw_id']}";
            $acc_data  =   Article_flow::get_single_record($select,$criteria);
            $select1    =   'SELECT SUM(CASE WHEN t1.status = \'d\' and (t1.aflw_remarks is not null and t1.aflw_remarks !=\'timeout\' and t1.aflw_remarks!=\'ondecision\' ) THEN 1 ELSE 0 END) as declined_count FROM ( SELECT aflw_id,max(`aflw_id`),`aflw_status` as status,aflw_remarks from  rvw_article_flow where `aflw_parent_flow_id`='.$popover_param['aflw_id'].' group by `aflw_usr_id`) as t1';
            $declined   =   Article_flow::get_records_by_raw_query($select1);
            $data_content = array();
            if (!empty($acc_data)) {
                if ($acc_data->aflw_id > 0) {
                    $declined_count = 0;
                    if (!empty($declined)) {
                        if ($declined[0]->declined_count > 0 ||$declined[0]->declined_count != '') {
                            $declined_count = $declined[0]->declined_count;
                        }
                        $short_list_count    =  $acc_data->declined + $acc_data->submitted_count + $acc_data->accepted_count + $acc_data->invited_count + $acc_data->short_list_count;
                        if (($acc_data->declined == 0 && $acc_data->submitted_count == 0 && $acc_data->accepted_count == 0 && $acc_data->invited_count == 0) && $acc_data->short_list_count > 0 ) {
                            $short_list_count   =  $acc_data->short_list_count; 
                        }
                        $data_content = array(
                            "short_list_count" => $short_list_count,
                            "declined"  =>  $acc_data->declined,
                            "submitted_count" => $acc_data->submitted_count,
                            "accepted_count" => $acc_data->accepted_count,
                            "invited_count" => $acc_data->invited_count,
                            "declined_count" => $declined_count,
                            "params" =>array(
                                "parent_flow_id"    =>  $popover_param['aflw_id'],
                                "art_id"    =>  $popover_param['art_id'],
                                "jwf_id"    =>  $popover_param['aflw_jwf_id'],
                                "jwf_stage_name" =>  $stg_name_res->jwf_stage_name,
                                "jwf_stage_type" =>  $stg_name_res->jwf_stage_type,
                                "jwf_assignment" =>  $stg_name_res->jwf_assignment
                            )
                        );
                    }
                }
            }
            return $data_content;
        }
        else {
            $dateformat =   (isset($popover_param['jset_date_format']) ? $popover_param['jset_date_format'] : $this->current_client->settings->cs_date_format);
            if ($popover_param['jwf_stage_type'] != 'production') {
                if ($popover_param['aflw_accepted_date'] != 'null') { 
                    $data_content['start_date'] = date_format(date_create($popover_param['aflw_accepted_date']),$dateformat.' H:i');
                }
                if ($popover_param['aflw_returned_date'] != 'null') { 
                    $data_content['completed_date'] = date_format(date_create($popover_param['aflw_returned_date']),$dateformat.' H:i');
                }
            }
            else {
                $generic_flow = array_reverse($this->fetch_stage_order($popover_param['first_jnl_stage_id'],array()));
                $last_jwf_id        =   end($generic_flow);
                if ($last_jwf_id == $popover_param['aflw_jwf_id']) {
                    //fetch exported date
                    $exp_posted_date_res    =   Article_export_data::get_single_record("exp_posted_date","exp_art_id = {$popover_param['art_id']}",NULL,'',"exp_id DESC");
                    $exp_posted_date        =   (isset($exp_posted_date_res->exp_posted_date) ? $exp_posted_date_res->exp_posted_date : '' );
                    if ($exp_posted_date) {
                        $data_content["last_exported_date"]  =  $exp_posted_date;
                    }
                }
                else {
                    if ($popover_param['aflw_accepted_date'] != 'null') {
                        $data_content["start_date"]   =   date_format(date_create($popover_param['aflw_accepted_date']), $dateformat . ' H:i');
                    }
                    if ($popover_param['aflw_returned_date'] != 'null') {
                        $data_content["completed_date"]   =   date_format(date_create($popover_param['aflw_returned_date']), $dateformat . ' H:i');
                    }
                }
            }
            if ($popover_param['aflw_due_date'] != 'null') {
                $data_content ["due_date"] = date_format(date_create($popover_param['aflw_due_date']), $dateformat . ' H:i');
            }
            if ($popover_param['remaining_days'] != '0') {
                $data_content["over_due_info"] = abs($popover_param['remaining_days']);
            }
            //fetch repeated stage data
            $data_content['repeated_stage'] =   array();

            $compl_res  =   Article_flow::get_all_records("aflw_id,aflw_returned_date","aflw_art_id = {$popover_param['art_id']} AND aflw_jwf_id = {$popover_param['aflw_jwf_id']} AND aflw_id != {$popover_param['aflw_id']} AND aflw_usr_id IS NOT NULL");
            if (count($compl_res) > 0) {
                foreach ($compl_res as $so_key => $so_val) {
                    $stagename_res  =   Generic_flows::get_single_record("jwf_stage_name","jwf_id = {$popover_param['aflw_jwf_id']}");
                    $jwf_stage_name =   $stagename_res->jwf_stage_name;
                    $data_content['repeated_stage'][$so_key]['param']    =   encrypt_link('art_id='.$popover_param['art_id'].'&aflw_id='.$so_val->aflw_id.'&main_aflw_id='.$popover_param['aflw_id'].'&aflw_jwf_id='.$popover_param['aflw_jwf_id'].'&stage_name='.$jwf_stage_name.'&jnl_code='.$popover_param['jnl_code']);
                    $data_content['repeated_stage'][$so_key]['completed_date']   =   date_format(date_create($so_val->aflw_returned_date), $dateformat . ' H:i');
                    $data_content['repeated_stage'][$so_key]['abbr']     =   $this->fetch_abbr_form($jwf_stage_name);
                }
            }
        }
        return $data_content;
    }

    public function fetch_stage_order($jwf_id,$push_arr)
    {
        $treeArr    =   array(); 
        $select =   "jwf_id,jwf_stage_name,REPLACE(REPLACE(REPLACE(`jwf_child_stages`,']',''),'[',''),'\"','') jwf_child_stages";
        $condition  =   "jwf_id = {$jwf_id}";
        $generic_flow_res   =   Generic_flows::get_single_record($select,$condition);
        if (!empty($generic_flow_res)) {
            $jwf_name           =   $generic_flow_res->jwf_stage_name;
            if ($generic_flow_res->jwf_child_stages != '') {
                $work_flow_arr  =   explode(',',$generic_flow_res->jwf_child_stages);
                sort($work_flow_arr);
                foreach ($work_flow_arr as $val) {
                    $treeArr[$jwf_id][] = $val;
                }
            }
            else {
                $treeArr[$jwf_id] = array(); 
            }
        }

        if (isset($treeArr[$jwf_id])) {
            if (!in_array($jwf_id,$push_arr)) {
                $push_arr[] = $jwf_id;
                foreach ($treeArr[$jwf_id] as $val1) {
                    $this->fetch_stage_order($val1,$push_arr);
                }
                //this array is declared as global in the top of the program
                $this->stage_arr    =   array_values(array_unique($this->stage_arr));
                $this->stage_arr[]  =   $jwf_id;
            }
        }
        return $this->stage_arr;
    }

    public function fetch_abbr_form($jwf_stage_name)
    {
        $abbr_arr = Config::get('abbreviation_config.abbr');
        $jwf_stage_name =   strtolower($jwf_stage_name);
        if (isset($abbr_arr[$jwf_stage_name]) && $abbr_arr[$jwf_stage_name] != '') {
            $abbr = $abbr_arr[$jwf_stage_name];
        }
        else {
            if(str_word_count($jwf_stage_name) > 1) 
            {
                $only_string    =   str_replace('-', '', $jwf_stage_name); // Replaces all spaces with hyphens.
                $ro             =   preg_replace('/\s+/', ' ',$only_string);
                $pieces         =   explode(" ", $ro);
                $first_part     =   implode(" ", array_splice($pieces, 0, 3));
                if(preg_match_all('/\b(\w)/',strtoupper($first_part),$m)) {
                    $abbr   =   implode('',$m[1]);
                }
            }
            else
            {
                //if only 1 word, choose its first two letters
                $abbr   =  strtoupper(substr($jwf_stage_name,0,2));
            }
        }
        return $abbr;
    }

    public function review_shortlisted_data(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'jnl_code' => 'required',
				'art_id' => 'required',
                'jwf_id' => 'required',
                'parent_flow' => 'required',
                'jwfassignment' => 'required'
            ]);
			
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
            $parent_flow    =   $jwfassignment  =   "";
            $jnl_code       =   decrypt_link($request->jnl_code);
            $art_id         =   decrypt_link($request->art_id);
            $jwf_id         =   decrypt_link($request->jwf_id);
            $parent_flow    =   decrypt_link($request->parent_flow);
            $jwfassignment  =   decrypt_link($request->jwfassignment);
            $show_invited   =   ($jwfassignment == 'invitation' ) ? TRUE : FALSE;
            $jnl_data       =   Journals::get_journal_data($jnl_code);
            $art_flw_tbl    =   (new Article_flow())->getTable();
            $art_rvws_tbl   =   (new Article_reviewers())->getTable();
            $rjct_rsn_tbl   =   (new Reject_reasons())->getTable();
            $assg_tables    =   array(
                "main_table" => $art_flw_tbl.' as af',
                "join_table" => array(
                    $art_rvws_tbl => array("sorw_aflw_id","af.aflw_id"),
                    $rjct_rsn_tbl => array("sorw_rjct_id","rjct_id","left")
                )
            );
            $assg_criteria  =   "aflw_parent_flow_id = $parent_flow";
            $date_format    =   date_format_map($jnl_data->jset_date_format);
            $select =   "sorw_id,aflw_id,aflw_usr_id,aflw_status,sorw_invited_by,sorw_suggested_user_id,aflw_due_date,DATE_FORMAT(sorw_suggested_on,'{$date_format}') as suggested_date, DATE_FORMAT(sorw_invited_on,'{$date_format}') as invited_date, DATE_FORMAT(aflw_due_date,'{$date_format}') as due_date,aflw_posted_by,aflw_remarks,aflw_returned_date";
            $select .=  ",IF(((select max(b.aflw_id) from $art_flw_tbl as b where b.aflw_usr_id = af.aflw_usr_id and b.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id) && rjct_reinvite_flag = 'y' && (select count(*) from $art_flw_tbl as c where c.aflw_usr_id = af.aflw_usr_id and c.aflw_parent_flow_id = af.aflw_parent_flow_id and c.aflw_status != 'i' and c.aflw_status !='a' and c.aflw_status !='c')>0,1,0) as reinvte_condition,(select count(*) from $art_flw_tbl as d  where d.aflw_usr_id = af.aflw_usr_id and d.aflw_parent_flow_id = af.aflw_parent_flow_id) as reviewer_invite_count,sorw_usr_source";
            // to recognise if added through reviewer on fly or not
            $select .=  ',CASE WHEN sorw_usr_source=\'p\' THEN \'n\' WHEN `sorw_posted_by`=`sorw_suggested_user_id` and EXISTS(
                        SELECT `usr_id` FROM `rvw_users` where `usr_id`= `sorw_suggested_reviewer_id` and `usr_activation`=\'n\'
                        and `usr_status`=\'w\')   then \'y\' else \'n\' end as added_through_fly';
            $assigned_users =   Article_flow::get_results_using_joins($assg_tables,$select,$assg_criteria);
            $conflict_interest = array();
            if ($this->current_client->modules->mdl_review_for_doc == 'n') {
                $conflict_interest = $this->get_article_conflict_array($art_id);
            }
            $curr_stage =   Article_flow::get_single_record("aflw_id","aflw_art_id = {$art_id}",NULL,'',"aflw_id desc");
            $current_stage_active   =   ($curr_stage->aflw_id == $parent_flow) ? TRUE : FALSE;
            $return_data1    =   array();
            if (!empty($assigned_users)) {
                foreach ($assigned_users as  $k=>$assg) {

                    $due_date   =   $assg->aflw_due_date;
                    $date_diff  =   time() - strtotime($due_date);
                    $days       =   round($date_diff / (60 * 60 * 24));

                    $array_data =   array(
                        "user_id" => $assg->aflw_usr_id,
                        "journal_id" => $jnl_data->jnl_id,
                        "flag"  => TRUE,
                        "article_id" => $art_id,
                        "availability" => TRUE,
                        "remove_user" => isset($assg->sorw_usr_source) ? $assg->sorw_usr_source : false
                    );   
                    $short_listed_user  =   $this->get_user_display_name($array_data);
                    $return_data[$k]['short_listed_user']['fullname'] = $short_listed_user['fullname'];
                    $return_data[$k]['short_listed_user']['user_id'] = $short_listed_user['user_id'];
                    $suggested_user = [];
                    if ($assg->sorw_suggested_user_id != NULL) {
                        $array_data_sggested_usr = array(
                            "user_id"   =>  $assg->sorw_suggested_user_id,
                            "journal_id" => $jnl_data->jnl_id,
                            "flag"  => TRUE,
                            "article_id" => $art_id
                        );
                        $suggested_user_details  =   $this->get_user_display_name($array_data_sggested_usr); 
                        $suggested_user     =   ['fullname'=>$suggested_user_details['fullname'],'user_id'=>$suggested_user_details['user_id']];
                    }
                    $return_data[$k]['suggested_user']  =   $suggested_user;
                    $invited_user = [];
                    if ($assg->sorw_invited_by != NULL) {
                        $array_data_invited_user = array(
                            "user_id"   =>   $assg->sorw_invited_by,
                            "journal_id" => $jnl_data->jnl_id,
                            "flag"  => TRUE,
                            "article_id" => $art_id
                        );
                        $invited_user_details       =    $this->get_user_display_name($array_data_invited_user);
                        $invited_user       =   ['fullname' => $invited_user_details['fullname'],'user_id' =>$invited_user_details['user_id']];
                        if ($assg->sorw_invited_by == 0) {
                            $invited_user   =   ["'fullname'"=>"System","user_id"=>""];
                        }
                    }
                    $return_data[$k]['invited_user'] = $invited_user;
                    $return_data[$k]['invited_user']['invited_date'] = isset($assg->invited_date) ? $assg->invited_date : $assg->suggested_date;
                    $return_data[$k]['due_date']['date']    =   (in_array($assg->aflw_status, array('i','a')) && $assg->due_date != '') ?  $assg->due_date : '';
                    $return_data[$k]['due_date']['label']   =   $days > 0 ? 'text-danger':'text-dark';
                    $show_conflict_interest_message = array();
                    if (!empty($conflict_interest)) {
                        $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $assg->aflw_usr_id);
                    }
                    $return_data[$k]['conflict_interest_message'] = $show_conflict_interest_message;
                    $assg->unregistered_user = $this->check_usr_account($assg->aflw_usr_id);
                    $rev_param  =   array(
                        "art_id" => $art_id,
                        "parent_id" => $parent_flow,
                        "jwf_id" => $jwf_id,
                        "assigned_users" => $assg,
                        "show_invited" =>   $jwfassignment,
                        "current_stage_active" => $current_stage_active,
                        "jnl_code"      =>  $jnl_code
                    );
                    $return_data[$k]['user_status'] =   $this->fetch_review_status($rev_param);
                }
            }
            return  $this->success('Success',200,$return_data);
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function fetch_review_status($rev_param)
    {
        $sts         =   $result     =   '';
        $jnl_code =   $rev_param['jnl_code'];
        $art_id =   $rev_param['art_id'];
        $parent_flow    =   $rev_param['parent_id'];
        $jwf_id =   $rev_param['jwf_id'];
        $show_invited   =   $rev_param['show_invited'];
        $current_stage_active   =   $rev_param['current_stage_active'];
        $assigned_users    =    $rev_param['assigned_users'];
        $aflw_status    =   $assigned_users->aflw_status;
        $unreg_user =   $assigned_users->unregistered_user;
        $aflw_usr_id    =   $assigned_users->aflw_usr_id;
        $aflw_id    =   $assigned_users->aflw_id;
        $aflw_remarks   =   $assigned_users->aflw_remarks;
        $aflw_posted_by =   $assigned_users->aflw_posted_by;
        $added_thr_fly  =   $assigned_users->added_through_fly;
        $aflw_returned_date =   $assigned_users->aflw_returned_date;
        $reinvte_condition  =   $assigned_users->reinvte_condition;
        $reviewer_invite_count  =   $assigned_users->reviewer_invite_count;

        $read_only      =   (!isset($current_stage_active) || (isset($current_stage_active) && $current_stage_active == TRUE)) ? FALSE : TRUE;
        $user_roles     =   $this->validate_user_journal($jnl_code,$this->current_user['user_id']);
        $unregistered_user_flag =   (isset($unreg_user) && $unreg_user == TRUE) ? TRUE : FALSE;
        $invitation_status  =   invitation_status();
        $jwf_res    =   Generic_flows::get_single_record("`jwf_who_can_invite`,`jwf_parent_user_roles`","jwf_id = {$jwf_id}");
        $invite_role    =   (!empty($jwf_res) && $jwf_res->jwf_who_can_invite != '') ? json_decode($jwf_res->jwf_who_can_invite) : array();
        $assign_role    =   (!empty($jwf_res) && $jwf_res->jwf_parent_user_roles != '') ? json_decode($jwf_res->jwf_parent_user_roles) : array();
        $has_invite_permission  =   (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'],$assign_role)) > 0) ? TRUE : FALSE;
        $has_assign_permission  =   (isset($user_roles['role_id']) && count(array_intersect($user_roles['role_id'],$assign_role)) > 0) ? TRUE : FALSE;
        $enable_button_active   =   ($has_invite_permission == TRUE || $has_assign_permission == TRUE) ? TRUE : FALSE;
        if ($aflw_status == 'u' && $unregistered_user_flag == FALSE) {
            if (isset($show_invited) && $show_invited == TRUE && $read_only == FALSE && $has_invite_permission == TRUE) {
                if (isset($enable_button_active) && $enable_button_active == FALSE) {
                    $result = "Not invited";
                } else {
                    $result = $invitation_status[$aflw_status];
                }
            } else {
                $sts = "Not invited";
            }
        }
        elseif ($aflw_status == 'i') {
            if ($read_only == TRUE || $has_invite_permission == FALSE || $unregistered_user_flag == TRUE) {
                $result =   $invitation_status[$aflw_status];
            } else {
                $result = "Uninvite";
            }
        }
        elseif (($aflw_status != 'u' && $aflw_status != 'i') || $read_only == TRUE) {
            if ($aflw_status == 'd' && $aflw_posted_by!=$aflw_usr_id && ($aflw_remarks==null || $aflw_remarks=="timeout" ||$aflw_remarks=='ondecision' ||$aflw_remarks=='onwithdrawn')) {
                $sts =   'Auto-declined';
            } elseif (isset($invitation_status[$aflw_status])) {
                $sts =   $invitation_status[$aflw_status];
            }
        }
        if ($sts != '' && $unregistered_user_flag == FALSE ) {
            $result =   $sts;
        }
        if ($aflw_status == 'u') {
            if ($read_only == FALSE && ($has_invite_permission == TRUE || $has_assign_permission == TRUE) && isset($enable_button_active) && $enable_button_active == TRUE) {
                if ($unregistered_user_flag == FALSE ) {
                    $result = "";
                }
                $result =   "Delete";
                if (isset($added_thr_fly) && $added_thr_fly == 'y' && $aflw_status == 'u' && $has_assign_permission == TRUE ) {
                    $result =   "Edit";
                }
            }
        } 
        elseif ($aflw_status == 'a' && $aflw_returned_date == NULL && $has_invite_permission == TRUE && $read_only == FALSE && $unregistered_user_flag == FALSE) {
            $result =  "Unassign";
        }
        elseif ($unregistered_user_flag == FALSE) {
            if ((((isset($reinvte_condition) && $reinvte_condition == 1) || (isset($aflw_remarks) && $aflw_remarks == 'timeout' && $reviewer_invite_count <=1)) && $has_invite_permission == TRUE ) && $read_only == FALSE) {
                $result = $invitation_status['r'];
            }
        }

        $return_arr = array(
            "result" => $result,
            "aflw_usr_id" => $aflw_usr_id,
            "aflw_id" => $aflw_id,
            "parent_flow_id" => $parent_flow
        );
        return $return_arr;
    }

    //completed stage popover and repeated stages modal information
    public function stage_details_modal(Request $request)
    {
        try {
            $params_arr = array();
            $data_content = array();
            $user_dply_name =   array();
            $aflw_acc_date  =   $aflw_ret_date  =   $aflw_due_date  = $remaining_days =     $user_dply_name   = $parent_roles =  '';
            $params =   decrypt_link($request->params);
            parse_str($params,$params_arr);
            $validator = Validator::make($params_arr, [
                'jnl_code' => 'required',
				'art_id' => 'required',
                'main_aflw_id' => 'required',
                'aflw_id' => 'required',
                'aflw_jwf_id' => 'required',
                'stage_name' => 'required'
            ]);
			
			if($validator->fails())
			{
				return  $this->failure('Failed',422,$validator->errors());
			}
            $genl_date_format   =   $this->current_client->settings->cs_date_format;
            $jnl_data   =   Journals::get_journal_data($params_arr['jnl_code']);
            $dateformat =   isset($jnl_data->jset_date_format) ? $jnl_data->jset_date_format : $genl_date_format;
            //fetch prev record of current stage details
            $prev_cnd   =   "aflw_art_id = {$params_arr['art_id']} AND aflw_jwf_id = {$params_arr['aflw_jwf_id']} AND aflw_id < {$params_arr['aflw_id']} AND aflw_id != {$params_arr['main_aflw_id']} AND aflw_usr_id IS NOT NULL";
            $prev_res   =   Article_flow::get_single_record("aflw_id",$prev_cnd,NULL,'',"aflw_id DESC");
            //fetch next record of current stage details
            $next_cnd   =   "aflw_art_id = {$params_arr['art_id']} AND aflw_jwf_id = {$params_arr['aflw_jwf_id']} AND aflw_id > {$params_arr['aflw_id']} AND aflw_id != {$params_arr['main_aflw_id']} AND aflw_usr_id IS NOT NULL";
            $next_res   =   Article_flow::get_single_record("aflw_id",$next_cnd,NULL,'',"aflw_id ASC");
            $fields     =   " IF(aflw_accepted_date IS NULL, 'null', aflw_accepted_date) aflw_accepted_date,"
                            . " IF(aflw_returned_date IS NULL, 'null', aflw_returned_date) aflw_returned_date,"
                            . " IF(aflw_due_date IS NULL, 'null', IF(aflw_status IN ('c', 'd'), 'null', aflw_due_date)) aflw_due_date,"
                            . " IF(aflw_due_date IS NULL, '0', IF(aflw_status IN ('c', 'd'), '0', DATEDIFF(aflw_due_date, NOW()))) remaining_days,"
                            . " IF(aflw_usr_id IS NULL, 'null', aflw_usr_id) as aflw_usr_id";
            $aflw_res   =   Article_flow::get_single_record($fields,"aflw_art_id = {$params_arr['art_id']} AND aflw_id = {$params_arr['aflw_id']}");
            if (!empty($aflw_res)) {
                $stage_res  =   Generic_flows::get_single_record("`jwf_stage_name`, `jwf_stage_type`, `jwf_role_id`, `jwf_who_can_invite`, `jwf_parent_user_roles`,`jwf_stage_type`","jwf_id = {$params_arr['aflw_jwf_id']}");
                $stage_role =   Roles::get_single_record("role_name","role_id = {$stage_res->jwf_role_id}");
                
                if (isset($aflw_res->aflw_accepted_date) && $aflw_res->aflw_accepted_date != 'null') {
                    $aflw_acc_date  =   date_format(date_create($aflw_res->aflw_accepted_date),$dateformat . " H:i");
                }
                if (isset($aflw_res->aflw_returned_date) && $aflw_res->aflw_returned_date != 'null') {
                    $aflw_ret_date  =   date_format(date_create($aflw_res->aflw_returned_date),$dateformat . " H:i");
                }
                if (isset($aflw_res->aflw_due_date) && $aflw_res->aflw_due_date != 'null') {
                    $aflw_due_date  =   date_format(date_create($aflw_res->aflw_due_date),$dateformat . " H:i");
                }
                if (isset($aflw_res->remaining_days) && $aflw_res->remaining_days != '0') {
                    $remaining_days  =   $aflw_res->remaining_days;
                }
                if ($aflw_res->aflw_usr_id && $aflw_res->aflw_usr_id != 'null') {
                    $array_data =   array(
                        "user_id" => $aflw_res->aflw_usr_id,
                        "journal_id" => $jnl_data->jnl_id,
                        "flag"  => true,
                        "article_id" => $params_arr['art_id']
                    );
                    $user_display_name  =   $this->get_user_display_name($array_data);
                    $without_au_confirmation = FALSE;
                    if ($this->current_client->functionality->cfty_allow_transfer_without_au_confirmation == 'y') {
                        $transfer_without_au_confirmation   =   Article_transfer_suggestion::get_transfer_details($params_arr['art_id'],$params_arr['aflw_id']);
                        if (isset($transfer_without_au_confirmation->ats_without_au_confirmation_usr_role) && $transfer_without_au_confirmation->ats_without_au_confirmation_usr_role != 0 && $stage_res->jwf_stage_type == 'transit') {
                            $without_au_confirmation = TRUE;
                        }
                    }
                    if ($without_au_confirmation == FALSE) {
                        $user_dply_name = array("fullname" => $user_display_name,'rolename'=>$stage_role->role_name);
                    } else {
                        $user_dply_name = array("fullname" => $user_display_name);
                    }
                }
                else {
                    $invitation_role=   json_decode($stage_res->jwf_who_can_invite);
                    $user_role_arr  =   $this->set_all_roles_key_value();
                    $allocated_user =   $this->get_allocated_users_list(array($params_arr['art_id']));
                    if(isset($allocated_user[$params_arr['art_id']]))
                        $art_allocation[$params_arr['art_id']] = $allocated_user[$params_arr['art_id']];
                    else
                        $art_allocation[$params_arr['art_id']] = array();

                    if (!empty($invitation_role)) {
                        $assigned_role_users    =   $this->get_assign_details($invitation_role,$art_allocation,$params_arr['art_id'],$user_role_arr);
                        $parent_roles           =   $this->get_formated_roles_and_users_list($assigned_role_users,$params_arr['art_id'],$user_disply_name=array());
                    }
                    
                    if ($parent_roles != '') {
                        $user_dply_name = array("rolename" => $parent_roles['roles'][0]);
                    }else {
                        $user_dply_name = array("rolename" => $stage_role->role_name);
                    }
                }
                $next_param = $prev_param ='';
                if (!empty($next_res)) {
                    $next_param  = encrypt_link('art_id='.$params_arr['art_id'].'&aflw_id='.$next_res->aflw_id.'&main_aflw_id='.$params_arr['main_aflw_id'].'&aflw_jwf_id='.$params_arr['aflw_jwf_id'].'&stage_name='.$params_arr['stage_name'].'&jnl_code='.$params_arr['jnl_code']);
                }
                if (!empty($prev_res)) {
                    $prev_param  = encrypt_link('art_id='.$params_arr['art_id'].'&aflw_id='.$prev_res->aflw_id.'&main_aflw_id='.$params_arr['main_aflw_id'].'&aflw_jwf_id='.$params_arr['aflw_jwf_id'].'&stage_name='.$params_arr['stage_name'].'&jnl_code='.$params_arr['jnl_code']);
                }
                $data_content   =   array(
                    "start_date"    =>  $aflw_acc_date,
                    "completed_date"    =>  $aflw_ret_date,
                    "user_display_name" =>  $user_dply_name,
                    "due_date"      =>  $aflw_due_date,
                    "remaining_days"    => $remaining_days,
                    "next_param" => $next_param,
                    "prev_param" => $prev_param,
                    "stage_name" => $stage_res->jwf_stage_name
                );
            }
            return  $this->success('Success',200,$data_content);
        } catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }

    public function fetch_journal_flow_arr($journal_flow_param, $reach_in_progress, $not_applicable)
    {
        $journal_wf_arr =   array();
        $stage_result = Generic_flows::get_single_record("jwf_stage_name,jwf_stage_type","jwf_id = {$journal_flow_param['jwf_id']}"); 
        if (!$journal_flow_param['prd_stgs_only'] || in_array($stage_result->jwf_stage_type,$journal_flow_param['stgs_aftr_prod'])) {

            $journal_wf_arr = [
                'jwf_id' => $journal_flow_param['jwf_id'],
                'jwf_stage_name' => $stage_result->jwf_stage_name,
                'jwf_stage_type' => $stage_result->jwf_stage_type,
                'abbr' => ($reach_in_progress == true && $not_applicable != true) ? $stage_result->jwf_stage_name : $this->fetch_abbr_form($stage_result->jwf_stage_name),
                'label' => $journal_flow_param['label'] ?? ''
            ];
        }
        return $journal_wf_arr;
    }

    public function create_view_article_link($art_id,$aflw_id,$jnl_journal_code)
    {
        $paper  =   $this->current_client->platform_type == 'conference' ? 'abstract' : 'article';
        $authors    =   Authors::get_single_record('GROUP_CONCAT(auth_usr_id) as authors','auth_art_id ='.$art_id);
        $user_data  =   $this->get_current_user_details();
        $view_article = URL::to('/') .'/'. $this->current_client->platform_type.'/';

        if(isset($jnl_journal_code) && $jnl_journal_code != '')
        {
            $view_article .= $jnl_journal_code . '/';
        }

        if (isset($authors->authors) && in_array($user_data['user_id'],explode(',',$authors->authors))) {
            $view_article .= 'author-'.$paper;
        } else {
            $view_article .= 'view-'.$paper;
        }
        return $view_article   .=  '/'.encrypt_link($art_id).'/'.encrypt_link($aflw_id);
    }
     /*
     *populate issues on the change of selected volume for filtering articles
     */
    public function fetch_volume_issues(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'vol_id' => 'required'
            ]);
            if ($validator->fails()) {
                return  $this->failure('Failed',422,$validator->errors());  
            }
            $post_data = $request->all();
            if (count($post_data) > 0)
            {   
                $vol_id         =   '';
                
                if(isset($post_data['vol_id']))
                {
                    $vol_id           = decrypt_link ($post_data['vol_id']);
                }
                
                if($vol_id != '') {
                    $cnd_vol =  "iss_vol_id = {$vol_id}";
                    $return_arr['issue_list']         = Issues::get_all_records(
                                                '`iss_id`, `iss_title`', $cnd_vol
                                            );
                                        }
          
         }
         return  $this->success('Success',200,$return_arr);
        }catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
    }
   
}
