<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use JWTAuth;
use App\Http\Traits\JournalUserfunctionTrait;
use Exception;

class CheckPageAccess
{
    use JournalUserfunctionTrait;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
           
            $url = $request->url();
            $user = JWTAuth::parseToken()->authenticate();
            $token = JWTAuth::getToken();
            $tokeninfo = JWTAuth::getPayload($token)->toArray();
            $proxy_user_id=$tokeninfo['proxy_user_id'];
            $request_data=$request->all();
            $current_url=$request->segment(2);
            $journal_url=$request->segment(4);
         
            $platform_code='';
            if(isset($request_data['jnl_code']))
            {
            $platform_code = $request_data['jnl_code'];
            }
            if(isset($journal_url)&&($journal_url!=''))  
            $platform_code=$request->segment(3);
            $user_access= $this->check_page_access($platform_code,$user->usr_id,$current_url,$journal_url,$proxy_user_id);
           if($user_access)
           {
            return $next($request);
           }
           else
           {
            return response()->json(['status' => false,'message'=>'Unauthorized User','access_token'=>false,'success'=>false]);
           }
        
       
         } catch (Exception $e) {
    
            return response()->json(['status' =>false,'message'=>'Server Error','access_token'=>false]);
             
         }
    }
}
