<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use JWTAuth;
use App\Http\Traits\JournalUserfunctionTrait;
use Exception;
class CheckUser
{
    use JournalUserfunctionTrait;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
           
            $url = $request->url();
            $user = JWTAuth::parseToken()->authenticate();
            $request_data=$request->all();
            $active_role='';
            if(isset($request_data['active_role']))
            {
            $active_role = $request_data['active_role'];
            }
            $platform_code=$request->segment(3);
            $current_url=$request->segment(4);
            $user_access= $this->check_user_access($platform_code,$user->usr_id,$current_url,$active_role);
           if($user_access)
           {
            return $next($request);
           }
           else
           {
            return response()->json(['status' => false,'message'=>'Unauthorized User','access_token'=>false,'success'=>false]);
           }
        
       
         } catch (Exception $e) {
       
            return response()->json(['status' =>false,'message'=>'Server Error','access_token'=>false]);
             
         }
        

    }
}
