<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use JWTAuth;
use App\Http\Traits\JournalUserfunctionTrait;

class CheckUserStatus
{
    use JournalUserfunctionTrait;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        
        $user = JWTAuth::parseToken()->authenticate();
        if(empty($user)){
            return response()->json(['status' => false,'message'=>'Unauthorized User','access_token'=>false,'success'=>false]); 
        }
        $user_access= $this->check_user_status($user->usr_id);
        // $user_access =true;
        if($user_access)
           {
            return $next($request);
           }
           else
           {
            //JWTAuth::manager()->invalidate(new \Tymon\JWTAuth\Token($token), $forceForever = false);
            return response()->json(['status' => false,'message'=>'Unauthorized User','access_token'=>false,'success'=>false]);
           }
    }
}
