<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;


class Cors
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
    
        $response = $next($request);

        $response->headers->set('Access-Control-Allow-Origin' ,env('APP_URL'));
        $response->headers->set('Access-Control-Allow-Credentials', 'true'); // Set the header to true

        $response->headers->set('Cache-Control', 'no-store,no-cache, must-revalidate, post-check=0, pre-check=0');
        $response->headers->set('Access-Control-Allow-Methods', 'POST, GET, OPTIONS, PUT, DELETE');
        $response->headers->set('Access-Control-Allow-Headers', 'Content-Type, Accept, Authorization, X-Requested-With, Application,x-xsrf-token');
        $response->headers->set('X-Frame-Options', 'DENY', false);
        $response->headers->set('X-XSS-Protection', '1; mode=block');
        $response->headers->set('Strict-Transport-Security', 'max-age=63072000; includeSubDomains; preload');
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('Referrer-Policy', 'strict-origin-when-cross-origin');
        $allowedOrigins = Config::get('cors.allowed_origins', []);
        if (in_array($request->header('Origin'), $allowedOrigins)) {
            $response->header('Access-Control-Allow-Origin', $request->header('Origin'));
        }
        $frame_allowed_domain = env('RVRITE_BASE_URL', 'self');
        $response->headers->set('Content-Security-Policy', "frame-ancestors 'self' $frame_allowed_domain");


        return $response;
    
    }
}