<?php

namespace App\Http\Middleware;

use Closure;
use JWTAuth;
use Exception;
use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;

class JwtMiddleware extends BaseMiddleware
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
           $user = JWTAuth::parseToken()->authenticate();
           $this->set_user_session($user);
      //return response()->json(['status' => 'Token is Expired','access_token'=>false,'success'=>false]);
        } catch (Exception $e) {
            if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenInvalidException){
                return response()->json(['status' => 'Token is Invalid','access_token'=>false,'success'=>false]);
            }else if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenExpiredException){
                return response()->json(['status' => 'token_expired','access_token'=>false]);
            }else{
                return response()->json(['status' => 'Authorization Token not found','access_token'=>false]);
            }
        }
        return $next($request);
    }

    private function set_user_session($user){
        session()->put('user', $user);
        $current_user = array();
        $token = JWTAuth::getToken();

        $tokeninfo = JWTAuth::getPayload($token)->toArray();

        if (isset($tokeninfo) && (!empty($tokeninfo))) {

            if ($tokeninfo['user_id'] == $tokeninfo['proxy_user_id'])
                $proxy_user_id = 0;
            else
                $proxy_user_id = $tokeninfo['proxy_user_id'];
            $current_user = array(
                'user_id' => $tokeninfo['user_id'],
                'proxy_user_id' => $proxy_user_id,
                'roles' => ($tokeninfo['user_role']!=NULL)?json_decode($tokeninfo['user_role']):[]
            );

            session(['current_user' => $current_user, 'user_id' => $tokeninfo['user_id'], 'proxy_user_id' => $proxy_user_id, 'roles' => $current_user['roles']]);
        }

    }
}
