<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class LogFunctionCalls
{
    public function handle(Request $request, Closure $next)
    {
        Log::info('Start of request cycle');

        // Get the debug backtrace
        // $backtrace = $this->getBacktrace();

        $resp = $next($request);

        // Log each function call in the backtrace
        // foreach ($backtrace as $trace) {
        //     if (isset($trace['class']) && isset($trace['function'])) {
        //         Log::debug('Function called: ' . $trace['class'] . '::' . $trace['function']);
        //     }
        // }

        return $resp;
    }

    protected function getBacktrace()
    {
        $backtrace = [];
        $stack = debug_backtrace(DEBUG_BACKTRACE_PROVIDE_OBJECT | DEBUG_BACKTRACE_IGNORE_ARGS);

        // Log each function call in the backtrace recursively
        foreach ($stack as $trace) {
            if (isset($trace['class']) && isset($trace['function'])) {
                $backtrace[] = $trace;
                $backtrace = array_merge($backtrace, $this->getChildFunctionCalls($trace));
            }
        }

        return $backtrace;
    }

    protected function getChildFunctionCalls($trace)
    {
        $childBacktrace = [];
        if (isset($trace['object'])) {
            $childStack = debug_backtrace(DEBUG_BACKTRACE_PROVIDE_OBJECT | DEBUG_BACKTRACE_IGNORE_ARGS, 2);
            foreach ($childStack as $childTrace) {
                if ($childTrace['object'] === $trace['object'] && isset($childTrace['function'])) {
                    $childBacktrace[] = $childTrace;
                }
            }
        }
        return $childBacktrace;
    }
}

