<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Config;

class RequestLogger
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        session()->put('full_url', $request->fullUrl());
        session()->put('route', $request->path());
        $logreq = $request;
        $response = $next($request);
        if (env('LOG_REQUEST') == true) {
            Config::set('logging.default', 'dailyrequestlog');
            $this->LogRequest($logreq);
            $this->LogResponse($response);

        }
        return $response;
    }

    private function LogRequest(Request $request)
    {
        Log::info("==============================================================================");
        Log::info("--------------------------------Request---------------------------------------");
        $logReqContent = $request->all();
        if(isset($logReqContent['password'])) $logReqContent['password'] = '***********';
        $logReqContent = json_encode($logReqContent);
        Log::info("Request : ". $request->fullUrl());
        Log::info("Payload : ". $logReqContent);
    }

    private function LogResponse(Response $response)
    {
        Log::info("--------------------------------Response---------------------------------------");
        $logRespContent = $response->getContent();
        $logRespContent = json_decode($logRespContent, true);
        if(isset($logRespContent['token'])) $logRespContent['token'] = "***********************************************************";
        Log::info("Response : ".json_encode($logRespContent));
        Log::info("==============================================================================\n\n\n");

    }
}
