<?php

namespace App\Http\Traits;

use DB;
use Config;

trait ArticlelistTrait
{

    public  function get_article_submitted_user($article, $jnl_id)
    {

        if (isset($article->art_submitted_by) && (!($article->atotp_review_method == 'd' && ($is_reviewer == TRUE))) || $core_role == 'author') {
            if (isset($user_disply_name[$article->art_submitted_by])) {
                $submitted = $user_disply_name[$article->art_submitted_by];
            } else {
                if ($this->current_client->modules->mdl_review_for_doc == 'y' && $core_role == 'reviewer') {
                    $array_data['user_id'] = $article->art_submitted_by;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['flag'] = TRUE;
                    $array_data['article_id'] = $article->art_id;
                    $array_data['salutation'] = TRUE;
                    $submitted = $this->get_user_display_name($array_data);
                } else {
                    $array_data['user_id'] = $article->art_submitted_by;
                    $array_data['journal_id'] = $jnl_id;
                    $array_data['flag'] = TRUE;
                    $array_data['article_id'] = $article->art_id;
                    $submitted = $this->get_user_display_name($array_data);
                }
            }
        }

        return $submitted;
    }

    public function  check_special_issue_in_article($article)
    {
        $is_special = FALSE;
        if (isset($article->artp_special_issue) && $article->artp_special_issue == 'y') {
            $is_special = TRUE;
        }
        elseif ((isset($article->art_publication_issue) && !empty($article->art_publication_issue)) && (isset($article->iss_hard_end_date) && !empty($article->iss_hard_end_date)) && (isset($article->iss_special_issue) && $article->iss_special_issue == 'y')) {
            $is_special = TRUE;
        }

        return $is_special;
    }
    
   public function get_article_flag($jnl_id,$role_id,$article_id)
   {
    $Article_flag=new \App\Models\Article_flag();
    $flags = '';
    $flag_data = $Article_flag::get_article_flags('*',"aflg_jnl_id={$jnl_id} AND aflg_art_id={$article_id}");
    
    if (count($flag_data) > 0) {
        $flag_icon_selector = $this->current_client->functionality->cfty_flag_icon_selector;
        $flags .= ' ';

        foreach ($flag_data as $flag_value) {
            $permitted_roles = json_decode($flag_value->flag_role);
            if (in_array($role_id, $permitted_roles)) {
                if ($flag_value->flag_icon != null && $flag_icon_selector == 'y')
                    $icon = $flag_value->flag_icon;
                else
                    $icon = 'tag';
                $flags .= '<span class="fa fa-' . $icon . '" style="color:' . $flag_value->flag_color . '" title="' . $flag_value->flag_name . '"></span>';
            }
        }
        return $flags;
    }
   }
    public function formated_article_status($art_stage,$jnl_code)
    {
        $this->current_user = $this->get_current_user_details();
        $status_p = $status_w = $status_a = $status_i = $status_u = '';
        if ($art_stage->aflw_status == 'u' && $art_stage->jwf_stage_type == 'payment')
            $status_u = 'in progress';
        else
            $status_u = 'ready';

        $auto_decline_arr = array('timeout','auto_decline_after_decision_period','onwithdrawn','ondecision');    
        if ($art_stage->aflw_operation == 'u' && $art_stage->aflw_posted_by != $art_stage->aflw_usr_id && (in_array(trim($art_stage->aflw_remarks),$auto_decline_arr)  || $art_stage->aflw_remarks == ''))
            $decline_status = 'auto declined';
        else
            $decline_status = 'declined';
        $Article_flow=new \App\Models\Article_flow();
        $flowid = $art_stage->aflw_id;
        $cond = array(
            'aflw_id'=>$flowid
        );
        $stage_added_by_status = $Article_flow::get_single_record_with_bind_cond('aflw_reviewer_added_by_stage_status',$cond);
        $completed = 'completed';
        if ($art_stage->jwf_stage_type == 'production' && $art_stage->aflw_status == 'c' && $this->current_client->modules->mdl_production == 'n')
            $completed = 'exported';
        //Task-150 JPR-223	Papers on Hold
        $hold_baldge_reason = '';
        $art_withdrawn = '';
        $status_a_status = '';
        $status_p = 'Awaiting assignment';
        if (isset($art_stage->art_delete_status) && ($art_stage->art_delete_status == 'h')) 
        {
             $Article_types = new \App\Models\Article_types();
            $article_type_data=$Article_types::get_single_record('artp_fwm_id ',"artp_id={$art_stage->art_artp_id}");
        
            $article_data = (object) [
                'artp_id' =>$art_stage->art_artp_id,
                'art_id' =>$art_stage->art_id,
                'artp_fwm_id'=>$article_type_data->artp_fwm_id,
                'jnl_journal_code'=>$jnl_code,
                'art_artp_id'=>$art_stage->art_artp_id
            ];
        
            $art_previlege=$this->article_privilages($article_data,$art_stage->aflw_id,$jnl_code);
            $hold_status=$this->set_hold_status($art_previlege,$article_data);
            $status_u = $status_a_status = $status_a = $status_w = $status_i = $hold_status;                   
                //  $hold_baldge_reason = $this->set_hold_article_baldge($art_stage->art_id, $art_stage->art_artp_id);
        }
        elseif (isset($art_stage->art_delete_status) && isset($art_stage->aflw_parent_flow_id) && ($art_stage->art_delete_status == 'w') && $art_stage->aflw_parent_flow_id == NULL) 
        {
            $status_a_status = '';
            $status_p = $status_w = $status_a = $status_i = $status_u = 'Article withdrawn';
        }
        elseif((isset($art_stage->aflw_status) && $art_stage->aflw_status == 'a') && (isset($stage_added_by_status->aflw_reviewer_added_by_stage_status) && $stage_added_by_status->aflw_reviewer_added_by_stage_status == 'p'))
        {
            $status_a = 'accepted';
        }
       else {
            $status_a_status = $status_a = 'in progress';
            $status_w = 'in progress';
            $status_i = 'invited';
        }
        
        //$status_a = $status_a_status . '';
        if ($art_stage->jwf_stage_type == 'author_submission' && $art_stage->art_status == 't')
            $status_a = $status_a_status . '';

        if(isset($art_stage->auth_seek_confrim) && $art_stage->aflw_status == 'a' && $art_stage->jwf_stage_type == 'author_submission' && $art_stage->art_delete_status == 'n' && $art_stage->art_submitted_by != $this->current_user['user_id'] && $art_stage->auth_seek_confrim == $this->current_user['user_id'] )
        {
            $status_a = 'Co-author confirmation in progress';
        }
        if(isset($art_stage->ats_author_action) && $art_stage->ats_author_action !='' && $art_stage->jwf_stage_type == 'transit' && $art_stage->aflw_status == 'c')
        {
            if($art_stage->ats_author_action == 0)
            {
                $completed .= '/Transfer rejected';
            }
            elseif($art_stage->ats_author_action == 1)
            {
                $completed .= '/Transfer accepted';
            } 
            elseif($art_stage->ats_author_action == 2)
            {
                $completed .= '/Withdrawn';
            }

        }


        $jwf_status_name_array = array(
            'p' => $status_p,
            'w' => $status_w,
            'a' => $status_a,
            'c' => $completed,
            'i' => $status_i,
            'u' => $status_u,
            'd' => $decline_status,
            'g' => 'unassigned',
        );
        if (isset($jwf_status_name_array[$art_stage->aflw_status]))
            return $jwf_status_name_array[$art_stage->aflw_status];
    }

    public function author_status_link($article, $is_reviewer, $journal_code)
    {
        $this->current_user = $this->get_current_user_details();
        $Authors = new \App\Models\Authors();
        $edit_link = '';
        $bulksubmission = FALSE;
        if(isset($article->art_prev_article_id) && $article->art_prev_article_id != "")
        $previous_art_id=$article->art_prev_article_id;
        else
        $previous_art_id='';

        $edit_flag = $this->check_article_editable_action($article, $is_reviewer, $journal_code);
   
        $this->current_user = $this->get_current_user_details();
        $seek_confirmation = FALSE;
        $esarray['article_id']=$article->art_id;
        $checkdata=$this->check_espermission_access($esarray);
        //if($this->current_client->modules->mdl_es_integration == 'y' && isset($article->art_es_document_status) && $article->art_es_document_status !== 'n')
        if($checkdata==true && isset($article->art_es_document_status) && $article->art_es_document_status !== 'n')
        {
            $author_confirm = $Authors::get_single_record('count(auth_id) as cnt', "auth_art_id={$article->art_id} AND auth_usr_id={$this->current_user['user_id']} AND auth_confirm_status='y'");
            if($author_confirm->cnt == 0 && $article->atotp_co_authors_agreement == 'y')
            {
                $seek_confirmation = TRUE;
            }
        }
        else
        {
        if($article->aflw_status == 'a' && $article->art_status == 'n' && $article->art_submitted_by != $this->current_user['user_id']){
            $seek_confirmation = TRUE;
        }
        }
        // print_r($seek_confirmation);die;
        if (isset($article->art_stage_submission_method) && $article->art_stage_submission_method == 'b') {
            $bulksubmission = TRUE;
        }
        if (isset($article->art_stage_submission_method) && ($article->art_stage_submission_method == 'z') && $article->art_status == "n" && $previous_art_id=='' && $article->art_submitted_by_id == $this->current_user['user_id']) {
            $edit_link = 'preview-article-production-submission';
            //$edit_link= base_url('journal/' . $article->jnl_journal_code . '/' . $article->artp_abbr_article_type . '/preview-article-production-submission?' . encrypt_link('article_id=' . $article->art_id . '&status_id=' . $article->aflw_id));

        }
        elseif (isset($article->art_stage_submission_method) && ($article->art_stage_submission_method == 'z' || $article->art_stage_submission_method == 'n') && $article->art_status == "n" && $article->art_posted_by == $this->current_user['user_id'] && $article->art_submitted_by_id == "") {
            $edit_link = 'edit-article-production';
        }
        elseif ($article->art_status == "n" && $previous_art_id=='' && $article->art_submitted_by_id == $this->current_user['user_id']) {
            $edit_link = 'edit-article';
            //$edit_link = base_url('journal/' . $article->jnl_journal_code . '/' . $article->artp_abbr_article_type . '/edit-article/' . encrypt_link($article->art_id) . '?' . encrypt_link('current_flow_id=' . $article->aflw_id.$bulksubmission));
            if ($article->aflw_status == 'i') {
                $edit_link = 'author-article';
                //	$edit_link = base_url('journal/' . $article->jnl_journal_code . '/author-article?' . encrypt_link('article_id=' . $article->art_id . '&status_id=' .$article->aflw_id.$bulksubmission));
            }
        } elseif ($article->art_status == "n" && $previous_art_id=='' && isset($article->is_author) && $article->is_author == TRUE) {
            $invite_userid = '';
            $author_confirm = $Authors::get_single_record('count(auth_id) as cnt', "auth_art_id={$article->art_id} AND auth_usr_id={$this->current_user['user_id']} AND auth_confirm_status='i'");
            if ($author_confirm->cnt > 0) {
                $invite_userid = '&inviteuserid=' . $this->current_user['user_id'];
            }

            //$edit_link = base_url('journal/' . $article->jnl_journal_code . '/' . $article->artp_abbr_article_type . '/preview-article?' . encrypt_link('article_id=' . $article->art_id . '&status_id=' . $article->aflw_id.$invite_userid));
            $edit_link = 'preview-article';
        } elseif($seek_confirmation == TRUE){
            $edit_link = 'preview-article';
        } else
        {
            //$edit_link = base_url('journal/' . $article->jnl_journal_code . '/' . $article->artp_abbr_article_type . '/article-correction/' . encrypt_link($article->art_id)) . '/' . encrypt_link($article->aflw_id);
            $edit_link = 'author-article';
        }
        return $edit_link;
    }

    public function check_article_editable_action($article,$is_reviewer,$journal_code,$curr_role_id=NULL)
    {
    
        $journal_permission_table = new \App\Models\Journal_permission();
        if (isset($article->artp_jpm_id)) {
        $permission_roles = $journal_permission_table::get_single_record('jp_edit_articles,jp_extend_task',"jp_jpm_id={$article->artp_jpm_id}");
        }

        //if current role exist then article assiged user check also doing 
        $assinged_user = array();
        if($curr_role_id != NULL)
        {
            $user_article = new \App\Models\User_articles();
            $cnd = 'usra_art_id ='.$article->art_id.' AND usra_role_id = '.$curr_role_id;
            $assinged_user = $user_article::get_single_record('Group_concat(usra_usr_id) as usra_usr_ids',$cnd,'usra_art_id');
        }

        $this->current_user = $this->get_current_user_details();
        $edit_article=FALSE;
        $due_date_extend=FALSE;
        $mng_production = $this->is_article_in_production_management($article->art_id);
                    if (!empty($permission_roles) && $permission_roles->jp_edit_articles != NULL &&$is_reviewer!=TRUE)
                    {
                        $edit_roles = $edit_roles_org = json_decode($permission_roles->jp_edit_articles);
                        if($curr_role_id != NULL)
                        {
                            $edit_roles = array($curr_role_id);
                        }

                        $edit_article = $this->check_journal_permission_with_role_ids($edit_roles, $journal_code, $article->art_artp_id, $this->current_user['user_id']);
                        
                        // for check - current role have permission
                        if($curr_role_id != NULL  && $article->art_artp_id != NULL) 
                        {
                            if(in_array($curr_role_id, $edit_roles_org) != FALSE)
                            {
                                $edit_article = TRUE;
                            }
                            else
                            {
                                $edit_article = FALSE;
                            }    

                            if(!empty($assinged_user))
                            {
                                $assigned_user_arr = explode(',',$assinged_user->usra_usr_ids);
                                //this situation some other user is assigned to this article then his edit permission denied
                                if(in_array($this->current_user['user_id'], $assigned_user_arr) == FALSE)
                                {
                                    $edit_article = FALSE;
                                }
                            }
                        }
                            
                    }
                    if (!empty($permission_roles) && $permission_roles->jp_extend_task != NULL&&$is_reviewer!=TRUE)
                    {
                        $extend_roles = $extend_roles_org = json_decode($permission_roles->jp_extend_task);
                        if($curr_role_id != NULL)
                        {
                            $extend_roles = array($curr_role_id);
                        }
                        
                        $due_date_extend = $this->check_journal_permission_with_role_ids($extend_roles, $journal_code, $article->art_artp_id, $this->current_user['user_id']);
                        
                        // for check - current role have permission
                        if($curr_role_id != NULL  && $article->art_artp_id != NULL) 
                        {
                            if(in_array($curr_role_id, $extend_roles_org) != FALSE)
                            { 
                                $due_date_extend = TRUE;
                            }
                            else
                            {
                                $due_date_extend = FALSE;
                            }    

                            if(!empty($assinged_user))
                            {
                                $assigned_user_arr = explode(',',$assinged_user->usra_usr_ids);
                            
                                //this situation some other user is assigned to this article then his edit permission denied
                                if(in_array($this->current_user['user_id'], $assigned_user_arr) == FALSE)
                                { 
                                    $due_date_extend = FALSE;
                                }
                            }
                        }
                    } 
                $return_array['edit_article_status']=$edit_article;
                $return_array['due_date_extend_status']=$due_date_extend;
                return $return_array;
    }

    public function set_article_url($article, $skip_review_author, $core_role)
    {
        $client_code = $this->current_client->clnt_client_code;
        $this->review_flow = Config::get('clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow');

        $view_article = '';
        if($this->current_client->platform_type == 'conference')
            $paper =    'abstract';
        else
            $paper =    'article';

        if (isset($article->authors) && in_array($this->current_user['user_id'], explode(',', $article->authors)) == TRUE && $skip_review_author == FALSE) {
            $view_article = 'author-'.$paper;
            if (!empty($core_stage) && isset($this->review_flow[$core_stage]['stage_for']) && $this->review_flow[$core_stage]['stage_for'] == 'manageproduction') {
                $view_article = 'author-'.$paper.'-production';
            }
        } else {
            $view_article = 'view-'.$paper;
            if (!empty($core_stage) && isset($this->review_flow[$core_stage]['stage_for']) && $this->review_flow[$core_stage]['stage_for'] == 'manageproduction') {
                $view_article = 'view-'.$paper.'-production';
            }
        }

        return  $view_article;
    }

    public function format_due_date($article,$jnl_id)
    {
        $journal_permission_table = new \App\Models\Journal_settings();
        $cond = array(
            'jset_jnl_id'=>$jnl_id
        );
        $jnl_sett_data = $journal_permission_table::get_single_record_with_bind_cond('jset_date_format',$cond);
        
        $date_format = $this->current_client->settings->cs_date_format;
        if(isset($jnl_sett_data->jset_date_format))
        {
            $date_format = $jnl_sett_data->jset_date_format;
        }
        
        $expire_status = FALSE;
        $due_date = '';
        if (isset($article->artp_special_issue) && $article->artp_special_issue == 'y' && isset($article->is_author) && $article->is_author == TRUE && $article->art_status == "n" && $article->art_prev_article_id == "") {

            $softend_date = date_create($article->artp_soft_enddate);
            $current_date = date_create(date('Y-m-d'));
            $hardend_date = date_create($article->artp_hard_enddate);
            if ($current_date >= $softend_date) {
                if ($current_date > $hardend_date) {
                    $expire_status = TRUE;
                    $due_date = "| expired article";
                } else {

                    if ($article->artp_soft_enddate != '') {
                        $due_date = $this->get_due_date($date_format, $article->artp_soft_enddate);
                        //$sr_report->article_due = $this->get_due_date($date_format, $article->artp_soft_enddate);
                        $dates = date_format(date_create($article->artp_soft_enddate), $date_format);

                        if ($article->article_due == '')
                            $due_date = '| <span>Due: ' . $dates . '</span>';
                        else
                            $due_date = '| <span>Due: ' . $dates . '(' . $article->article_due . ' overdue)' . '</span>';
                    }
                }
            }
        }
        if (isset($article->art_publication_issue) && !empty($article->art_publication_issue) && $article->art_status == 'n') {

            $due_date_class = $this->get_due_date_class($article->rvd_remaining_days);
            $softend_date = $article->iss_soft_end_date;
            $current_date = date('Y-m-d H:i:s');
            $hardend_date = $article->iss_hard_end_date;
            if ($current_date >= $softend_date) {
                if ($current_date > $hardend_date) {
                    $expire_status = TRUE;
                    $due_date = "| Sorry! can\'t submit the article as the hard end date has expired";
                } else {
                    if ($article->iss_soft_end_date != '') {
                        $due_date = $this->get_due_date($date_format, $article->iss_soft_end_date);
                        $dates = date_format(date_create($article->iss_soft_end_date), $date_format);
                        if ($due_date == '')
                            $due_date = '| <span class="' . $due_date_class . '">Due: <strong>' . $dates . '</strong></span>';
                        elseif(isset($article->article_due))
                            $due_date = '| <span class="' . $due_date_class . '">Due: <strong>' . $dates . '(' . $article->article_due . ' overdue)' . '</strong></span>';
                    }
                }
            }
        } else if (isset($article->rvd_aflw_due_date) && $article->rvd_aflw_due_date != '' && $article->aflw_status != 'c') {
            $article->due_date_passed_days = '';
            $days_passed = '';

            if ($article->rvd_remaining_days < 0) {
                $expire = 'text-danger';
                $days_passed = ' (' . abs($article->rvd_remaining_days) . ' days overdue)';
                $article->due_date_passed_days = abs($article->rvd_remaining_days);
            }
            $due_date = '| <span>Due: ' . $article->rvd_aflw_due_date . $days_passed . '</span>';
        }
        $return['expired_status'] = $expire_status;
        $return['due_date'] = $due_date;
        return $return;
    }

  public function get_assiged_user_details($art_stage,$role_arr,$shorlist_permission,$invite_permission,$allocation_user,$jnl_array,$for_extra_invite = NULL)
  {
    $assigned_roles = array();
    $assigned_users = array();
    $user_name_arr = array();
    $assigned_text = 'Assigned role';	
    $mng_flow_status_w = '';
    $extra_invitation = FALSE;
    $due_change_field ='aflw_due_date';
    $due_change_field_modified ='due_date';
    $due_remaining_days ='rvd_remaining_days';
    $single_invite_due = '';
    $is_blinded = false;
    if($art_stage->aflw_status == 'p' || $art_stage->aflw_status == 'w')
    {
        $assigned_users_assign = array(); $assigned_users_invite = array();
        $assigned_roles_assign = array(); $assigned_roles_invite = array();
        $user_full_details =array();
        //art_current_status
        if(($art_stage->shot_listed < $art_stage->aflw_stage_min_users) &&  $shorlist_permission == TRUE && $for_extra_invite == NULL)
        {
            $mng_flow_status_w = 'selection';
            $assigned_role_users = $this->get_assign_details($art_stage->per_shotlist_roles,$allocation_user,$art_stage->art_id,$role_arr);
            $assigned_roles_data = $this->get_formated_roles_and_users_list($assigned_role_users,$art_stage->art_id,$user_name_arr,$jnl_array);
            
            $assigned_roles=$assigned_roles_data['roles'];
            if(isset($assigned_roles_data['users']))
            {
                $assigned_users = $assigned_roles_data['users'];
            }
            
            if(($art_stage->aflw_status == 'w' && $art_stage->shot_listed != 0 && $art_stage->invited_list < $art_stage->shot_listed && $art_stage->invited_list < $art_stage->aflw_stage_min_users) && $invite_permission == TRUE)
            {
                $extra_invitation = TRUE;
            }
        }
        elseif(($art_stage->invited_list < $art_stage->aflw_stage_min_users) && $invite_permission == TRUE)
        {
            $due_change_field ='aflw_invite_due_date';
            $due_remaining_days ='rvd_remaining_days_invite_due';
            $due_change_field_modified ='invite_due_date';
            $single_invite_due = '_invite';
            $mng_flow_status_w = 'invitation';
            
            $art_stage->invite_due_id = '_invite';
            $art_stage->rvd_aflw_due_date = $art_stage->invite_due_date;//Task #8720
            
            $assigned_role_users = $this->get_assign_details($art_stage->per_invite_roles,$allocation_user,$art_stage->art_id,$role_arr);
            $assigned_roles_data = $this->get_formated_roles_and_users_list($assigned_role_users,$art_stage->art_id,$user_name_arr,$jnl_array);
            //$assigned_roles = $this->get_formated_roles_and_users_list($assigned_role_users,$art_stage->art_id,$user_name_arr);
            $assigned_roles=$assigned_roles_data['roles'];
            if(isset($assigned_roles_data['users']))
            {
                $assigned_users = $assigned_roles_data['users'];
            }
        }
    
        if(isset($assigned_role_users['assigned_roles_assign']) && count($assigned_role_users['assigned_roles_assign']) > 0)
        {
            $assigned_text ='Assigned';
        }
        else
        {
            $assigned_text ='Assigned user';
            if(isset($assigned_roles_data['users']) && count($assigned_roles_data['users']) > 1)
            {
                $assigned_text ='Assigned users';
            }
        }
    }
    elseif( isset($art_stage->aflw_usr_id)&&$art_stage->aflw_usr_id != '')
    {
        $assigned_to = $user_role = '';
        if (isset($art_stage->art_id))	
        {
            if(isset($user_name_arr[$art_stage->aflw_usr_id]))
            {
                $assigned_to = $user_name_arr[$art_stage->aflw_usr_id];
            }
            else
            {
                $array_data['user_id']=$art_stage->aflw_usr_id;
                $array_data['journal_id']=$jnl_array['jnl_id'];
                $array_data['flag']=TRUE;
                $array_data['article_id']=$art_stage->art_id;
                $array_data['jnl_code']=$jnl_array['jnl_code'];
                $array_data['jwf_role_id'] = $art_stage->jwf_role_id ?? null;
                $array_data['aflw_id'] = $art_stage->aflw_id ?? null;
                // dd($art_stage);
                $assigned_to = $this->get_user_display_name($array_data,$is_blinded);
                $user_name_arr[$art_stage->aflw_usr_id] = $assigned_to;
            }
            
        }
        
        if (isset($art_stage->jwf_role_id) && isset($role_arr[$art_stage->jwf_role_id]) && $assigned_to != '')
        {
            $user_role = ' (' .$role_arr[$art_stage->jwf_role_id]. ')';
        }
        $art_stage->user_role=$user_role;
        if(!empty($assigned_to))
            $art_stage->assigned_user = $assigned_to;
    }
    else
    {
       if(isset($role_arr[$art_stage->jwf_role_id]))
        {
            $assigned_roles[] = $role_arr[$art_stage->jwf_role_id];
        }
    }
    $return_array['assigned_role']=$assigned_roles;
    $return_array['assigned_users']=$assigned_users;
    $return_array['assigned_text']=$assigned_text;
    $return_array['manage_flow_status']=$mng_flow_status_w;
    $return_array['extra_invitation']=$extra_invitation;
    
    return $return_array;
  }


}
