<?php

namespace App\Http\Traits;
use DB;
use App\Models\Generic_flows;
trait EncryptionTrait
{
 


/*
* function to encrypt password 
* @ $pain_text string to encrypt
* @ $salt optional parameter which force the function to return string before encoding
*/
public function encrypt_password($plain_text, $salt = FALSE) {

    $encryption_key = "DeMocRatiC"; //salt key for encryption_key

    $encrypt_type = "hash"; //password encoding methods are "hash" and "base64"
	
    $cypher_text = ""; //variable for encrypted text
	
    $temp_cypher_string = ""; //variable to build string before encoding
	
    $encryption_loop_count = 0; //salt encryption loop counter
	
	//loop to insert salt key to original string.
    for ($i = 0; $i < strlen($plain_text); $i++) {
		
        $temp_cypher_string .= $plain_text[$i] . encryption_key[$encryption_loop_count]; //building salt key entered string
		
        $count_increment_reset = ($i + 1) % strlen(encryption_key); //variable to reset loop counter
		
		//Resetting the salt encryption loop counter
        if ($count_increment_reset == 0) {
			
            $encryption_loop_count = 0;
			
        } else {
			
            $encryption_loop_count++;
			
        }
    }
	
	//Finding the default encryption method
    if (encrypt_type == 'hash') {
		
        $cypher_text = $salt == TRUE? $temp_cypher_string : password_hash($temp_cypher_string, PASSWORD_BCRYPT); //encrypt using hashing method
		
    } else {
		
        $cypher_text = $salt == TRUE? $temp_cypher_string : base64_encode($temp_cypher_string); // encrypt using base64 encoding
		
    }
	
    return $cypher_text;// returns the encrypted text.
}

/*
* Function to match the password.
* @ $password srting which used for password.
* @ $cypher_text encrypted text
*/
public function match_password($password, $cypher_text)
{
    $encryption_key = "DeMocRatiC"; //salt key for encryption_key

    $encrypt_type = "hash"; //password encoding methods are "hash" and "base64"
    $password_verification = FALSE; // variable used to get verification status the password.
	
	//Finding the default encryption method
    if(encrypt_type == "hash")
    {
		//veryfy the password using hashing method.
        $password_verification = password_verify(encrypt_password($password, TRUE), $cypher_text);
		
    }
    else
    {
		//verifying password using base64 decoding
        $password_verification = encrypt_password($password,TRUE) == base64_decode($cypher_text) ? TRUE : FALSE;
    }
	
    return $password_verification;// returns the verification status
}
}