<?php

namespace App\Http\Traits;

use App\Http\Controllers\Controller;
use Illuminate\Support\Str;

use App\Http\Traits\General_ConfigTraits;
use App\Http\Traits\UserDataTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\SendemailTrait;
use App\Jobs\ReportGenerationJob;
use App\Models\Email_templates;
use App\Models\Roles;
use App\Models\User;
use App\Models\Article_status_link_statistics;
use App\Models\User_feedback;
use Config;
use App\Models\Article_flow;
use Illuminate\Support\Facades\URL;
use \stdClass;
use App\Jobs\SendEmailJob;
use App\Models\Article_notification_emails;
use App\Models\Articles;
use App\Models\Email_send_log;
use App\Models\Journal_permission;
use App\Models\User_articles;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Bus;
use App\Models\Journal_settings; /*Task #1787 Due date in settings page */
use DateTime; /*Task #1787 Due date in settings page */

trait GeneralEmailTrait
{
    use WorkflowTrait;
    use UtilityTrait;
    use UserDataTrait;
    use General_ConfigTraits;
    use SendemailTrait;

    /*
    $data expected array values are :-
   * email_with_login:-Email Send Login or  without login
   * empt_name :- template name  required,
    *type :- global/stage  required,
    article_id:- article id ,
    *user_id :-user id required,
    jnl_id :- journal id ,
   *action:- email send/read required,
    jnl_user_role=array(
    'core_role'=>core role,
    'role_name'=>role name,
    'jnl_journal_code'=> journal code
    )
    new_email:- when change the primary email then pass the new mail address while submitting data
     */
    public function master_email_details($data)
    {      
        $valid_user = $this->validate_exist_user($data['user_id']);
        if ($valid_user === true || (isset($data['custom_data']['api_name']) && $data['custom_data']['api_name'] == 'cron_job')) {
            if ((isset($data['type'])) && ($data['type'] != null) && ($data['type'] == 'global') && (isset($data['user_id'])) && ($data['user_id'] != null) && (isset($data['email_with_login']))) {
               
                $record = $this->get_global_email_details($data);
                $user_data = $this->get_user_data($data['user_id']);
                return $this->email_data($record, $user_data, $data);
            }
        if ((isset($data['type'])) && ($data['type'] != null) && ($data['type'] == 'stage') && (isset($data['user_id'])) && ($data['user_id'] != null) && (isset($data['email_with_login']))) {
        $this->get_stage_based_email_details($data);

        }
        if ((isset($data['type'])) && ($data['type'] != null) && ($data['type'] == 'custom') && (isset($data['user_id'])) && ($data['user_id'] != null) && (isset($data['email_with_login']))) {
            if(isset($data['email_temp']) && ($data['email_temp'] != null) && ($data['email_temp'] == 'global')){

            $this->get_post_data_for_globalmail($data);
         }
         else{
             $this->get_array_post_data($data);
         }
        }


        }
    }
    public function get_post_data_for_globalmail($data){
        $Article_notification_emails = new \App\Models\Article_notification_emails();
        $Articles=new \App\Models\Articles;
        $Article_flow= (new \App\Models\Article_flow);
        $users = (new \App\Models\User());

        $this->current_user=$this->get_current_user_details();
        $attachments = $files_attached = array();
        $user_id=(isset($data['user_id']))?$data['user_id']:'';
        $current_aflw_id=(isset($data['aflw_id']))?$data['aflw_id']:'';
        $article_id=(isset($data['article_id']))?$data['article_id']:'';
        $template_name =(isset($data['template']))?$data['template']:'';
        $data['empt_name']= $template_name;
        $post_data=(isset($data["post_data"]["postdata"]))?$data["post_data"]["postdata"]:array();
        $template =  $this->get_global_email_details($data);
        if($article_id != NULL)
        {
        $article_details = $Articles::get_single_record('art_artp_id',"art_id={$article_id}");
        }
        if(!empty($template)){
        $email_data = new stdClass;
        $subject = $post_data['stage_template_sub'];
        $content = $post_data['stage_template_content'];
        $replace_button = array('<button contenteditable="false">', '</button>');
        $replaceval = str_replace($replace_button, '##', $content);
        $content = $replaceval;
        $email_attachments =       array();
        if (isset($article_id) && $article_id != NULL&&isset($current_aflw_id) && $current_aflw_id != NULL) {
        $article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',
        "ane_event_etmp_id={$template->etmp_id} and ane_art_id={$article_id} and ane_aflw_id={$current_aflw_id} ");
        if(isset($article_notification->ane_id))
        {
        $email_attachments	=	$this->get_invite_email_attachments($article_id,$article_notification->ane_id,FALSE);
        if(!empty($email_attachments)) {
            $attachments = $email_attachments['attachments'];
            $files_attached = $email_attachments['files_attached'];
        }
            $template->ane_id = $article_notification->ane_id; // Task #8948, The reopen mail showing previously added attachments in reopen submit invitation mail issue fixed
        }
    }
        if (!empty($files_attached))
        {
            $email_data->attachments = $attachments;
            $email_data->files_attached = $files_attached;
        }

        $email_data->article_id = $article_id;
        $email_data->jnl_journal_code = decrypt_link($data["post_data"]['jnl_code']);
        if(isset($article_details)&&isset($article_details->art_artp_id))
        {
        $email_data->artp_id = $article_details->art_artp_id;
        }
        if(isset($data['custom_data']['artp_id'])&&$data['custom_data']['artp_id']!=NULL)
        {
            $email_data->artp_id =$data['custom_data']['artp_id'];
        }
        if(isset($data['custom_data']['esl_etmp_action'])&&($data['custom_data']['esl_etmp_action']!='')){
            $email_data->esl_etmp_action = $data['custom_data']['esl_etmp_action'];
        }
        if (isset($data['custom_data']['change_copyright'])) {
            $email_data->change_copyright = true;
        }
         // TASK #9425 Convey Integration In Review3
         if(isset($data['custom_data']['convey_link_to_disclose'])&& $data['custom_data']['convey_link_to_disclose']!='')
         {
         $email_data->CONVEY_LINK_TO_DISCLOSE = $data['custom_data']['convey_link_to_disclose'];
         }
        $email_data->jnl_id = decrypt_link($data["post_data"]['jnl_id']);
        $email_data->aflw_id = $current_aflw_id;
        $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
        $email_data->email_templates_config = $this->email_templates_config();
        $template->etmp_cc = $template->etmp_bcc = '';
        $template->etmp_cust_cc = $template->etmp_cust_bcc = '';
        if (!empty($post_data['stage_template_to_cc']))
        {
            $template->etmp_cc = json_encode($post_data['stage_template_to_cc']);
            if ((in_array('Custom', $post_data['stage_template_to_cc']))||(in_array('Custom_cc', $post_data['stage_template_to_cc'])))
              {  $template->etmp_cust_cc = trim($post_data['stage_cust_cc']);}
        }
        if (!empty($post_data['stage_template_to_bcc']))
        {
            $template->etmp_bcc = json_encode($post_data['stage_template_to_bcc']);
            if (in_array('Custom', $post_data['stage_template_to_bcc'])||in_array('Custom_bcc', $post_data['stage_template_to_bcc']))
              {  $template->etmp_cust_bcc = trim($post_data['stage_cust_bcc']);}
        }
        $email_data->reply_to = trim($post_data['stage_template_to_mail']);
						$email_data->subject = $subject;
						$email_data->body = $content;
        if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
        { $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
        }
       if(isset($template->etmp_name) && $template->etmp_name == 'reopen_review')
       {
           //#3231 Reason for re-open
           $article_flow_data=$Article_flow->get_single_record('aflw_remarks',"aflw_id = {$email_data->aflw_id}");

           $email_data->REOPEN_REASON =$article_flow_data->aflw_remarks;
           $email_data->join_config = $this->join_config();
           $email_data->join_dependency_config = $this->join_dependency_config();   
           $email_data->user_role_tags = $this->user_role_tags();
           $user_titles = $this->UserConfigdata('titles')['titles'];

           $email_data->body = $this->generate_email_data_from_keys($email_data, $content, $this->current_user, $user_titles, TRUE, TRUE);
       }
        // TASK #9425 Convey Integration In Review3
        if(isset($template_name)&&$template_name=='reminder_disclosure_convey_email')
        { 
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();   
            $email_data->user_role_tags = $this->user_role_tags();
            $user_titles = $this->UserConfigdata('titles')['titles'];
            $email_data->body = $this->generate_email_data_from_keys($email_data, $content, $this->current_user, $user_titles, TRUE, TRUE);
        }
       $res = $users::get_single_record('usr_email',"usr_id={$user_id}");
       if ($res)
       {
         // TASK #9425 Convey Integration In Review3
        $cfty_retire_role = FALSE;
        if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
        {
            $cfty_retire_role = TRUE;
        }
        $send_mail_to_detail = $this->send_email_to($template->etmp_notification,$data["post_data"]['jnl_code'] , $email_data->artp_id, $article_id,$cfty_retire_role);
        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
        $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
        $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
        $send_mail_to = $send_mail_to_detail['email_ids'];
        $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
         // TASK #9425 Convey Integration In Review3
        if(isset($data['custom_data']['mail_recipient_ids'])&&$data['custom_data']['mail_recipient_ids']!=''&& (($data['empt_name'] ?? null) == 'reminder_disclosure_convey_email')&&(isset($data['custom_data']['api_name']) && $data['custom_data']['api_name'] != 'cron_job'))
        {          
            $res = $users::get_single_record('usr_email',"usr_id={$data['custom_data']['mail_recipient_ids']}");
            if ($res)
            {
                $send_mail_to = $res->usr_email;
            }
            $send_mail_to = $res->usr_email;
            $send_mail_to_usr_ids = $data['custom_data']['mail_recipient_ids'];
        }
         //Task #630 Re-open mail is not sent to the reviewers
        if(isset($template->etmp_name) && $template->etmp_name == 'reopen_review')
         {
            $send_mail_to = $res->usr_email;
            $send_mail_to_usr_ids = $user_id;
         }
           if ($send_mail_to != '' || $template->etmp_cust_to == 'Custom'||$template->etmp_cust_to == 'Custom_to')
           {
               $email_data->user_email = $send_mail_to;
               $email_data->mail_recipient_ids = $send_mail_to_usr_ids;      
               $this->send_email_notification($template, $email_data, $this->current_user, 'etmp_');
           }
           
       }
    }
    }
    public function get_array_post_data($data){
        $Article_notification_emails = new \App\Models\Article_notification_emails();
        $Articles=new \App\Models\Articles;
        $Article_type_advance_options=new \App\Models\Article_type_advance_options;
        $Article_flow= (new \App\Models\Article_flow);
        $this->current_user=$this->get_current_user_details();
        $attachments = $files_attached = array();
        $invite_tmpl_id = (isset($data["post_data"]['invite_tmpl_name'])&&$data["post_data"]['invite_tmpl_name']!=NULL)?$this->decrypt_data($data["post_data"]['invite_tmpl_name']):'';
        $aflw_deeplink_token=(isset($data['aflw_deeplink_token']))?$data['aflw_deeplink_token']:'';
        $user_id=(isset($data['user_id']))?$data['user_id']:'';
        $current_aflw_id=(isset($data['aflw_id']))?$data['aflw_id']:'';
        $role_id=(isset($data['role_id']))?$data['role_id']:'';
        $template =(isset($data['template']))?$data['template']:array();
        // $article_id=$data['article_id'];
        $post_data=(isset($data["post_data"]["postdata"]))?$data["post_data"]["postdata"]:array();
        $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_role_id, jwf_parent_user_roles';
        $article_details = $Articles::get_article_details($select,"aflw_id={$current_aflw_id}");

        $article_details = $article_details[0];
        $article_id = $article_details->art_id;
        $email_data = new stdClass;
        $email_data->user_id = $user_id;
        $email_data->article_id = $article_id;
        if(isset($data['custom_data'])&&isset($data['custom_data']['email_id'])&&$data['custom_data']['email_id']!='proposal')  {
            $subject = $template->stage_etmp_subject;
            $content = $template->stage_etmp_content;
        }
        else{
            $subject = $post_data['stage_template_sub'];
            $content = $post_data['stage_template_content'];
        }

        $email_data->jnl_journal_code = $data["post_data"]['jnl_code'];
        $email_data->artp_id = $article_details->art_artp_id;
        $email_data->jnl_id = decrypt_link($data["post_data"]['jnl_id']);
        $email_data->aflw_id = $article_details->aflw_id;
        $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
        // TASK #8733 Reinstate the Reply-to Address Feature for Email Communication
        if(isset($post_data['stage_template_to_mail'])&&$post_data['stage_template_to_mail']!=''){
            $reply_to=trim($post_data['stage_template_to_mail']);
        }else{
           $reply_to = $this->get_reply_to_email(decrypt_link($data["post_data"]['jnl_id']));
        }
                if (isset($reply_to) && $reply_to != '')
                    $email_data->reply_to = $reply_to;
        $send_mail_to = '';
        $send_mail_to_usr_ids = '';
        if(isset($post_data['attachments'])&&($post_data['files_attached']))
        {
            $attachments = $post_data['attachments'];
            $files_attached = $post_data['files_attached'];
        }
        $email_attachments = array();
            if(isset($invite_tmpl_id)&&$invite_tmpl_id!=''&&isset($article_id)&&$article_id!=''&&isset($current_aflw_id)&&$current_aflw_id!='')
          {  $article_notification = $Article_notification_emails::get_single_record('ane_id,ane_subject,ane_content,ane_cc,ane_bcc,ane_cust_cc,ane_cust_bcc,ane_reply_to',
        "ane_stage_etmp_id={$invite_tmpl_id} AND ane_art_id={$article_id} AND ane_aflw_id={$current_aflw_id}");
     }
        if(isset($article_notification->ane_id))
        {
            $email_attachments	=	$this->get_invite_email_attachments($article_id,$article_notification->ane_id,FALSE);
        if(!empty($email_attachments))
        {
            $attachments = $email_attachments['attachments'];
            $files_attached = $email_attachments['files_attached'];
        }
        }
        if (!empty($files_attached))
        {
            $email_data->attachments = $attachments;
            $email_data->files_attached = $files_attached;
        }
          if(isset($template->etmp_name) && $template->etmp_name == 'reopen_review')
        {
            //#3231 Reason for re-open
            $article_flow_data=$Article_flow->get_single_record('aflw_remarks',"aflw_id = {$email_data->aflw_id}");

            $email_data->REOPEN_REASON =$article_flow_data->aflw_remarks;

        }
        $custom_data=isset($data['custom_data'])?$data['custom_data']:'';

        $template->stage_etmp_cc = $template->stage_etmp_bcc = '';
                    $template->stage_etmp_cust_cc = $template->stage_etmp_cust_bcc = '';
                    if(isset($data['custom_data'])&&isset($data['custom_data']['email_id']))  {

                    if(isset($custom_data['article_id'])&&($custom_data['article_id']!='')){
                        $email_data->article_id =$custom_data['article_id'];
                    }
                       if(isset($custom_data['aflw_id'])&&($custom_data['aflw_id']!='')){
                        $email_data->aflw_id =$custom_data['aflw_id'];
                    }
                    if(isset($custom_data['artp_id'])&&($custom_data['artp_id']!='')){
                        $email_data->artp_id =$custom_data['artp_id'];
                    }
                    if(isset($custom_data['jnl_id'])&&($custom_data['jnl_id']!='')){
                        $email_data->jnl_id = $custom_data['jnl_id'];
                    }
                    if(isset($custom_data['aflw_due_date'])&&($custom_data['aflw_due_date']!='')){
                        $email_data->aflw_due_date=$custom_data['aflw_due_date'];    }
                                     }
                if (isset($post_data['stage_template_to_cc']))
                    {
                        $template->stage_etmp_cc = json_encode($post_data['stage_template_to_cc']);
                        if (in_array('Custom', $post_data['stage_template_to_cc']) || in_array('Custom_cc', $post_data['stage_template_to_cc']))
                            $template->stage_etmp_cust_cc = trim($post_data['stage_cust_cc']);
                    }
                    if (isset($post_data['stage_template_to_bcc']))
                    {
                        $template->stage_etmp_bcc = json_encode($post_data['stage_template_to_bcc']);
                        if (in_array('Custom', $post_data['stage_template_to_bcc']) || in_array('Custom_bcc', $post_data['stage_template_to_bcc']))
                            $template->stage_etmp_cust_bcc = trim($post_data['stage_cust_bcc']);
                    }
           $email_data->subject = $subject;
           $email_data->body = $content;
                    $email_data->email_templates_config = $this->email_templates_config();
                    $core_role = (isset($data['jnl_user_role']) && isset($data['jnl_user_role']['core_role'])) ? $data['jnl_user_role']['core_role'] : '';
                    $core_role_name = (isset($data['jnl_user_role']) && isset($data['jnl_user_role']['role_name'])) ? $data['jnl_user_role']['role_name'] : '';

                    if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                        $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                        $email_data->core_role = $core_role;
                        $email_data->core_role_name = $core_role_name;
        $res = User::get_single_record('usr_email, usr_status, usr_deeplink_token',"usr_id={$user_id}");
        if ($res)
        {
            $send_mail_to = $res->usr_email;
            $send_mail_to_usr_ids = $user_id;
            if ($res->usr_status == 'w')
            {
                if (!empty($res->usr_deeplink_token))
                    $aflw_deeplink_token = $res->usr_deeplink_token;
                else
                {
                    User::update_record(array(
                        'usr_deeplink_token' => $aflw_deeplink_token),"usr_id={$user_id}");
                }
            }
        }
        if ($send_mail_to != '' || $template->stage_etmp_to == 'user')
        {
            $email_data->user_email = $send_mail_to;
            $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
        }
 $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params', "atotp_artp_id ={$article_details->art_artp_id}");

            if(!empty($artp_settings))
            {
                $template->review_method = $template->assignments='';
                if(isset($data["post_data"]['jnl_code']) && isset($data['jnl_user_role']['core_role']))
                {
                    $core_role =$data['jnl_user_role']['core_role'];
                }
                elseif(isset($article_details->jwf_role_id))
                {
                    $roles = Roles::get_single_record('role_assigned_role',"role_id={$article_details->jwf_role_id}");
                    $core_role = $roles->role_assigned_role;
                }
                if($core_role == 'reviewer' && ($template->stage_etmp_to == 'submit_author' || $template->stage_etmp_to == 'Author' || $template->stage_etmp_to == 'article_authors' || $template->stage_etmp_to == 'Authors'))
                {
                    $template->review_method = $artp_settings->atotp_review_method;

                }
            }
            $email_data->email_templates_config = $this->email_templates_config();
            if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
                $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->user_role_tags = $this->user_role_tags();
            
            $data = array(
                'template' => $template,
                'email_data' => $email_data,
                'current_user' =>$this->current_user,
                'post_data'=>$data,
                'user_id'=>$user_id,
                'content'=>$content,
                'subject' =>$subject,
                'send_mail_to'=>$send_mail_to,
                'send_mail_to_usr_ids'=>$send_mail_to_usr_ids,'article_id'=>$article_id
            );
$this->post_stage_email_data($data);

    }

public function post_stage_email_data ($all_data){
    $data=$all_data['post_data'];
    $user_id=$all_data['user_id'];
    $template=$all_data['template'];
    $email_data=$all_data['email_data'];
    $content=$all_data['content'];
    $subject=$all_data['subject'];
    $send_mail_to=$all_data['send_mail_to'];
    $send_mail_to_usr_ids=$all_data['send_mail_to_usr_ids'];
    $article_id=$all_data['article_id'];
    $user_data = $this->get_current_user_details();
    $User_to_journals = new \App\Models\User_to_journals;
    $this->current_user==$all_data['current_user'];
    $custom_data=isset($data['custom_data'])?$data['custom_data']:'';
    $link = $accept_link = $reject_link = '';
            if(isset($data['custom_data'])&&isset($data['custom_data']['link'])&&$data['custom_data']['link']!='')  {
        $link =$data['custom_data']['link'];
        $accept_link =$data['custom_data']['accept_link'];
        $reject_link =$data['custom_data']['reject_link'];
       }
       if(isset($custom_data['article_id'])&&($custom_data['article_id']!='')){
        $email_data->article_id =$custom_data['article_id'];
    }
       if(isset($custom_data['aflw_id'])&&($custom_data['aflw_id']!='')){
        $email_data->aflw_id =$custom_data['aflw_id'];
    }
    if(isset($custom_data['artp_id'])&&($custom_data['artp_id']!='')){
        $email_data->artp_id =$custom_data['artp_id'];
    }
    if(isset($custom_data['jnl_id'])&&($custom_data['jnl_id']!='')){
        $email_data->jnl_id = $custom_data['jnl_id'];
    }
    if(isset($custom_data['aflw_due_date'])&&($custom_data['aflw_due_date']!='')){
        $email_data->aflw_due_date=$custom_data['aflw_due_date'];    }
    if(isset($custom_data['jnl_code'])&&($custom_data['jnl_code']!='')){
        $email_data->jnl_journal_code = $custom_data['jnl_code'];
    }
        if ($template->stage_etmp_to != 'User' && $template->stage_etmp_to != 'Custom')
        {
            $cfty_retire_role = FALSE;
            if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
            {
                $cfty_retire_role = TRUE;
            }

            $send_mail_to_detail = $this->send_email_to($template->stage_etmp_to,$data["post_data"]['jnl_code'] , $email_data->artp_id, $article_id,$cfty_retire_role);
            $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
            $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
            $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
            $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
            $send_mail_to = $send_mail_to_detail['email_ids'];
            $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
        }
        $core_role = (isset($data['jnl_user_role']) && isset($data['jnl_user_role']['core_role'])) ? $data['jnl_user_role']['core_role'] : '';
        $core_role_name = (isset($data['jnl_user_role']) && isset($data['jnl_user_role']['role_name'])) ? $data['jnl_user_role']['role_name'] : '';

        $email_data->core_role = $core_role;
        $email_data->core_role_name = $core_role_name;
        $decline_data =isset($data['decline_data'])?$data['decline_data']:'';

        $currentURL = \Request::segment(4);
        if ($currentURL == 'sendreviewerinvitation'||$currentURL == 'sendproposalinvitation' || $currentURL == 'articlesavemaster')
        {

            if(isset($data['custom_data'])&&isset($data['custom_data']['link'])){
            if (!empty($decline_data)||(!empty($template->stage_etmp_to) && $template->stage_etmp_to == 'User'))
            {
                preg_match_all('/##([^##]*)##/', $template->stage_etmp_content, $matches);
                $keys = $matches[1];
                if (in_array('DIRECT_REJECT', $keys))
                {
                    $content = preg_replace('/<a id="direct_reject_tag_reinvite".*>.*<\/a>/','##DIRECT_REJECT##', $content);
                }
                if (in_array('CONFIRMATION_URL', $keys))
                {
                    $content = preg_replace('/<a id="confirmation_url_tag_reinvite".*>.*<\/a>/',' ##CONFIRMATION_URL##', $content);
                }
                if (in_array('DIRECT_ACCEPT', $keys))
                {
                    $content = preg_replace('/<a id="direct_accept_tag_reinvite".*>.*<\/a>/','##DIRECT_ACCEPT##', $content);
                }

            }
            //bug with link tags DIRECT_ACCEPT, DIRECT_REJECT, CONFIRMATION_URL
            if (!empty($template->stage_etmp_to) && $template->stage_etmp_to == 'User')
            {

                preg_match_all('/##([^##]*)##/', $template->stage_etmp_content, $matches);

                $keys = $matches[1];

                if (in_array('CONFIRMATION_URL', $keys))
                {
                    $content = str_ireplace('##CONFIRMATION_URL##', '<a id="confirmation_url_tag_reinvite" href="' . $link . '">' . $link . '</a>', $content);
                }

                if (in_array('DIRECT_ACCEPT', $keys))
                {
                    $content = str_ireplace('##DIRECT_ACCEPT##', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . ((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept'). '</a>', $content);
                }

                if (in_array('DIRECT_REJECT', $keys))
                {
                    $content = str_ireplace('##DIRECT_REJECT##', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '" >' . ((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject') . '</a>', $content);
                }
                if (in_array('AUTHOR_DIRECT_ACCEPT', $keys))
                {
                    $content = str_ireplace('##AUTHOR_DIRECT_ACCEPT##', '<a id="direct_accept_tag_reinvite" href="' . $accept_link . '">' . ((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept'). '</a>', $content);
                }

                if (in_array('AUTHOR_DIRECT_REJECT', $keys))
                {
                    $content = str_ireplace('##AUTHOR_DIRECT_REJECT##', '<a id="direct_reject_tag_reinvite" href="' . $reject_link . '" >' . ((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject') . '</a>', $content);
                }
            }
            else
            {
                $content = str_ireplace('##CONFIRMATION_URL##', '', $content);
                $content = str_ireplace('##DIRECT_ACCEPT##', '', $content);
                $content = str_ireplace('##DIRECT_REJECT##', '', $content);
                $content = str_ireplace('##AUTHOR_DIRECT_ACCEPT##', '', $content);
                $content = str_ireplace('##AUTHOR_DIRECT_REJECT##', '', $content);
            }
        }
        $email_data->body = $content;
                if ($send_mail_to != '' || $template->stage_etmp_to == 'Custom')
            {
                $email_data->user_email = $send_mail_to;
                $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                $email_data->subject = $this->generate_email_data_from_keys($email_data, $subject, $this->current_user, '', false);
                $email_data->body = $this->generate_email_data_from_keys($email_data, $content,  $data['user_id'], '', false,true);
            $this->send_email_notification($template, $email_data, $this->current_user, 'stage_etmp_');
            }
        }
        else
        {
            if(isset($data['custom_data'])&&isset($data['custom_data']['link']))
          {  $email_data->CONFIRMATION_URL = $data['custom_data']['link'];
          }
          if(isset($data['custom_data'])&&isset($data['custom_data']['accept_link']))
           { $email_data->DIRECT_ACCEPT =$data['custom_data']['accept_link'];
           }
           if(isset($data['custom_data'])&&isset($data['custom_data']['reject_link']))
           { $email_data->DIRECT_REJECT = $data['custom_data']['reject_link'];}
            $reviewer = User::get_single_record('*', "usr_id = $user_id");
            $email_data->user_email = $reviewer->usr_email;

            $email_data->mail_recipient_ids = $user_id;
            $email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_id, 'a');

            if (isset($reply_to) && $reply_to != '')
                $email_data->reply_to = $reply_to;

            if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
                $email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;

            if (strpos($template->stage_etmp_email_template,"OPENING_PARAGRAPH") > 0)
            $template->stage_etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$template->stage_etmp_email_template);
            // TASK #8885 Edited emails are not being sent.
            if($subject){
                $template->stage_etmp_subject =$subject;
            }
            if($content){
                $template->stage_etmp_email_template =$content;
            }
            $data = array(
                'record' => $template,
                'email_data' => $email_data,
                'user_data' =>$user_data,
                'return_batch_id' => false,
                'column_prefix' => 'stage_etmp_'
            );
            $this->notify_mail($data);
        }
}
    public  function get_stage_based_email_details($data){
        $article_table= new \App\Models\Articles();
        $Stage_email_templates_table = new \App\Models\Stage_email_templates();
        $custom_data=isset($data['custom_data'])?$data['custom_data']:'';
        $stage_email_templates = NULL;
		if(isset($data['aflw_id']))
        {
            $select = 'art_id, art_artp_id, art_stub, art_title, artp_article_type,jnl_id, jnl_journal_name,jnl_journal_code,aflw_usr_id,aflw_id,art_submitted_by,jwf_stage_type,jwf_id,jwf_stage_name,jwf_status_name,aflw_parent_flow_id,jwf_who_can_invite,jwf_avoid_email_notifications_to_roles,jwf_parent_user_roles,jnl_standalone_group,jwf_role_id';
            $article_details = $article_table::get_article_details($select,"aflw_id={$data['aflw_id']}");
            $article_details = $article_details[0];

            $condition = array();
            if(((isset($custom_data['stage_etmp_action'])&&$custom_data['stage_etmp_action']!=''))||(isset($custom_data['stage_etmp_to'])&&($custom_data['stage_etmp_to']!='')))
            {
                if(isset($custom_data['stage_etmp_action'])&&$custom_data['stage_etmp_action']!=''){
            $condition[] = "stage_etmp_stage_type='{$article_details->jwf_stage_type}' AND setr_jwf_id={$article_details->jwf_id} AND stage_etmp_action='{$custom_data['stage_etmp_action']}'";
                }
            if(isset($custom_data['stage_etmp_to'])&&$custom_data['stage_etmp_to']!=''){
            $condition[] = " stage_etmp_to='{$custom_data['stage_etmp_to']}'";
            }
            if(isset($custom_data['template_id'])&&$custom_data['template_id']!=''){
                 $condition[] = " stage_etmp_id='{$custom_data['template_id']}'";
             }

             if(count($condition) > 0)
             {
                $condition = implode(' AND ',$condition);

                $stage_email_templates = $Stage_email_templates_table::get_stage_email_tmpl_to_trigger('*, stage_etmp_content AS stage_etmp_email_template', $condition);
             }


        }

        if (strpos($data['user_id'], ',') == false)
        {
            $user_data = $this->get_user_data($data['user_id']);
        }
        else
        {

            $user_data=(object) array(
                'usr_id' =>0,
                'proxy_user_id' => 0,
                'usr_roles' => NULL
            );
        }
        $return_array = array(
            'stage_email_templates' => $stage_email_templates,
            'post_data' => $data,
            'article_details'=>$article_details,
            'user_data' =>$user_data,

        );
        $this->stage_email_data($return_array);

        }

    }
    public function stage_email_data($data)
    {
        $User_to_journals = new \App\Models\User_to_journals;
        $Article_type_advance_options=new \App\Models\Article_type_advance_options;
        $article_details=$data['article_details'];
        $stage_email_templates=$data['stage_email_templates'];
        $user_id=$data['post_data']['user_id'];
        $user_details=$data['user_data'];
        $jnl_journal_code=(isset($data['post_data']['jnl_user_role'])&&isset($data['post_data']['jnl_user_role']['jnl_journal_code']))?$data['post_data']['jnl_user_role']['jnl_journal_code']:'';
        $jnl_id=(isset($data['post_data']['jnl_user_role'])&&isset($data['post_data']['jnl_user_role']['jnl_id']))?$data['post_data']['jnl_user_role']['jnl_id']:'';
        $core_role=(isset($data['post_data']['jnl_user_role'])&&isset($data['post_data']['jnl_user_role']['core_role']))?$data['post_data']['jnl_user_role']['core_role']:'';
        $core_role_name=(isset($data['post_data']['jnl_user_role'])&&isset($data['post_data']['jnl_user_role']['role_name']))?$data['post_data']['jnl_user_role']['role_name']:'';
        if((isset($data['email_with_login']))&&($data['email_with_login']==TRUE))
         {
         $this->current_user=$this->get_current_user_details();
         }
         else
        {
            $this->current_user= array(
                'user_id' =>$user_details->usr_id,
                'proxy_user_id' => 0,
                'roles' => json_decode($user_details->usr_roles)
            );
        }
        $email_data = new stdClass;
        $email_data->files_attached =array();

        $custom_data=isset($data['post_data']['custom_data'])?$data['post_data']['custom_data']:'';
  /*TASK #4801  Part of RVRite integration: Need to keep the change log */
        if(isset($custom_data['stage_etmp_action'])&&$custom_data['stage_etmp_action']=='track_author_changes')
        {
            $attach_data=$custom_data['send_attachment_data'];
         
            $email_data->files_attached =$attach_data['files_attached'];
            $email_data->attachments=$attach_data['attachments'];
        }
     /* TASK #4801 End */
        if ($stage_email_templates != NULL)
			{
        $email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_details->art_id, 'a');
        $email_data->article_id = $article_details->art_id;
        $email_data->user_id = $user_id;
        $email_data->artp_id = $article_details->art_artp_id;
        $email_data->aflw_id = $data['post_data']['aflw_id'];
        $send_mail_to = '';
				$send_mail_to_usr_ids = '';

				$send_mail_to_usr_ids = $user_id;
                if (strpos($user_id, ',') == false) {
                $user_details = User::get_single_record('usr_email,usr_username,CONCAT(usr_first_name," ",usr_last_name) as reviewer_name',"usr_id={$user_id}");
                if(isset($user_details->usr_username) && !empty($user_details->usr_username))
                {
                $email_data->user_name = $user_details->usr_username;
                $email_data->name = $user_details->reviewer_name;
                $send_mail_to = $user_details->usr_email;
                }
                }
                if(isset($custom_data['article_id'])&&($custom_data['article_id']!='')){
                    $email_data->article_id =$custom_data['article_id'];
                }
                if(isset($custom_data['artp_id'])&&($custom_data['artp_id']!='')){
                    $email_data->artp_id =$custom_data['artp_id'];
                }
                if(isset($custom_data['jnl_id'])&&($custom_data['jnl_id']!='')){
                    $jnl_id = $email_data->jnl_id = $custom_data['jnl_id'];
                }
                if(isset($custom_data['jnl_code'])&&($custom_data['jnl_code']!='')){
                    $email_data->jnl_code = $custom_data['jnl_code'];
                    $email_data->jnl_journal_code = $custom_data['jnl_code'];
                }
                if(isset($custom_data)&&isset($custom_data['link'])&&$custom_data['link']!='')
                {  $email_data->CONFIRMATION_URL = $custom_data['link'];
                }
                if(isset($custom_data)&&isset($custom_data['site_url'])&&$custom_data['site_url']!='')
                {  $email_data->SITE_URL = $custom_data['site_url'];
                }
                if(isset($custom_data)&&isset($custom_data['accept_link'])&&$custom_data['accept_link']!='')
                 { $email_data->DIRECT_ACCEPT =$custom_data['accept_link'];
                 }
                 if(isset($custom_data)&&isset($custom_data['reject_link'])&&$custom_data['reject_link']!='')
                 { $email_data->DIRECT_REJECT = $custom_data['reject_link'];}
                if(isset($custom_data['aflw_accepted_date'])&&$custom_data['aflw_accepted_date']!=''){
                $email_data->aflw_accepted_date=	$custom_data['aflw_accepted_date'];
                }
                if(isset($custom_data['aflw_id'])&&$custom_data['aflw_id']!=''){
                    $email_data->aflw_id = $custom_data['aflw_id'];
                }
                if(isset($custom_data['article_status_link'])&&$custom_data['article_status_link']!=''){
                $email_data->ARTICLE_STATUS_LINK=	$custom_data['article_status_link'];
                }
                if(isset($custom_data['base_url'])&&$custom_data['base_url']!=''){
                $email_data->base_url=	$custom_data['base_url'];
                }
                if(isset($custom_data['remaining_days'])&&$custom_data['remaining_days']!=''){
                    $email_data->remaining_days = $custom_data['remaining_days'];
                }
                if(isset($custom_data['prev_article_id'])&&$custom_data['prev_article_id']!=''){
                    $email_data->prev_article_id = $custom_data['prev_article_id'];
                }
                if(isset($custom_data['src_jnl_id'])&&$custom_data['src_jnl_id']!=''){
                    $email_data->src_jnl_id = $custom_data['src_jnl_id'];
                }
                if(isset($custom_data['api_name'])&&$custom_data['api_name']!=''){
                    $email_data->name = $custom_data['api_name'];
                }
                if(isset($custom_data['current_count'])&&$custom_data['current_count']!=''){
                    $current_count = $custom_data['current_count'];
                }
                if(isset($custom_data['aflw_due_date'])&&$custom_data['aflw_due_date']!=''){
                    $email_data->aflw_due_date = $custom_data['aflw_due_date'];
                }
                if(isset($custom_data['reason_for_rejection'])){
                $email_data->REASON_FOR_REJECT=	$custom_data['reason_for_rejection'];
                }
                $cfty_retire_role = FALSE;
                if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
                {
                    $cfty_retire_role = TRUE;
                }
                foreach ($stage_email_templates as $template)
				{
					if ($template->stage_etmp_to != 'User' && $template->stage_etmp_to != 'Custom')
					{
						$send_mail_to_detail = $this->send_email_to($template->stage_etmp_to, $jnl_journal_code, $article_details->art_artp_id, $article_details->art_id,$cfty_retire_role);
                        $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
                        $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
                        $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
                        $send_mail_to = $send_mail_to_detail['email_ids'];
						$send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
					}
					elseif ($template->stage_etmp_to == 'User')
					{
						//$send_mail_to = $user_details->usr_email;
						//$send_mail_to_usr_ids = $user_id;
                        $send_mail_to = isset($data['post_data']['custom_data']['user_email'])?$data['post_data']['custom_data']['user_email']:$user_details->usr_email;
                        $send_mail_to_usr_ids = isset($data['post_data']['user_id'])?$data['post_data']['user_id']:$user_id;
					}
					if ($send_mail_to != '' || $template->stage_etmp_to == 'Custom')
					{
						$email_data->user_email = $send_mail_to;
						$email_data->mail_recipient_ids = $send_mail_to_usr_ids;
						$email_data->aflw_id = $article_details->aflw_id;
						$email_data->artp_id = $article_details->art_artp_id;
						$email_data->jnl_id = $jnl_id;
						$email_data->jnl_journal_code = $jnl_journal_code;
						$email_data->email_templates_config = $this->email_templates_config();
						if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
							$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
						$email_data->join_config = $this->join_config();
						$email_data->join_dependency_config = $this->join_dependency_config();
						$email_data->user_role_tags = $this->user_role_tags();
                        //reply_to start
                        $current_status = array();
                        $reply_to='';
                        $article_flow_table = (new \App\Models\Article_flow);
                        if((isset($article_details->art_id)&&$article_details->art_id!=NULL)&&(isset($article_details->aflw_id)&&$article_details->aflw_id!=NULL))
                        {
                        $select = 'jwf_stage_type,jwf_role_id';
                        $where ="aflw_art_id={$article_details->art_id} AND aflw_id={$article_details->aflw_id}";
                        $current_status = $article_flow_table::get_generic_flow($select, $where);
                        }
                        $reply_to=$this->get_reply_to_email($jnl_id,$current_status);
						//reply_to end
                        if (isset($reply_to) && $reply_to != '')
							$email_data->reply_to = $reply_to;
						$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
						if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
						$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
						if (strpos($template->stage_etmp_email_template,"OPENING_PARAGRAPH") > 0)
						$template->stage_etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$template->stage_etmp_email_template);
						$artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id ={$article_details->art_artp_id}");
						if(!empty($artp_settings))
						{
							$template->review_method = $template->assignments='';
							if(isset($jnl_journal_code) && isset($core_role))
							{
								$core_role = $core_role;
							}
							elseif(isset($article_details->jwf_role_id))
							{
								$roles = Roles::get_single_record('role_assigned_role',"role_id={$article_details->jwf_role_id}");
								$core_role = $roles->role_assigned_role;
							}
							if($core_role == 'reviewer' && ($template->stage_etmp_to == 'submit_author' || $template->stage_etmp_to == 'Author' || $template->stage_etmp_to == 'article_authors' || $template->stage_etmp_to == 'Authors'))
							{

                                if(isset($artp_settings->atotp_review_method))
                                {
								$template->review_method = $artp_settings->atotp_review_method;
                                }
                                if(isset($current_count))
								{
                                    $template->assignments = $current_count;
                                }
							}
						}
						$email_data->core_role = $core_role;
						$email_data->core_role_name = $core_role_name;
                        $return_array = array(
                            'record' => $template,
                            'email_data' => $email_data,
                            'user_data' =>$this->current_user,
                            'column_prefix' => 'stage_etmp_'

                        );
						$this->notify_mail($return_array);
					}

					$send_mail_to = '';
					$send_mail_to_usr_ids = '';
                }
            }

    }
    public function get_global_email_details($data)
    {

        $type=$data['type'];
        $etmp_name=$data['empt_name'];
        $select = "email_hooks";
        $email_hooks = $this->Utility($select);
        $record=array();
        $email_all_keys = array_keys($email_hooks['email_hooks']);

        $email_key = $email_all_keys[array_search($etmp_name, $email_all_keys)]; //}
        $email_key_to = $email_hooks['email_hooks'][$email_key]['to'];
 
        if (!empty($email_key_to)) {
            foreach ($email_key_to as $key => $val) {
                if (isset($key) && isset($val)) {
                    $email_to = $val;
                }
            }
        }
        if(isset($data['custom_data'])&&(!empty($data['custom_data']))&& isset($data['custom_data']['etmp_notification'])&&($data['custom_data']['etmp_notification']!='')){
            $email_to = $data['custom_data']['etmp_notification'];
        }        

        if ((!empty($type) && $type == 'global')||(isset($data['email_temp'])&&$data['email_temp']== 'global')) {
            $criteria = "etmp_name = '{$etmp_name }' AND etmp_notification = '{$email_to }'";


            $record = Email_templates::get_single_record('*', $criteria);

        }
        return ($record);
    }


    public function email_data($record, $user_data, $data)
    {

        if ($record != null) {
            $user_email = (isset($data['new_mail']) ? $data['new_mail'] : '');
            $email_data = new stdClass;
            $email_data->user_id = $user_data->usr_id;
            $email_data->mail_recipient_ids = $user_data->usr_id;
            $email_data->files_attached =array();
            if(isset($data['custom_data'])&&(!empty($data['custom_data']))&& isset($data['custom_data']['user_email'])&&($data['custom_data']['user_email']!='')){
                $email_data->user_email = $data['custom_data']['user_email'];
                }
                else{
                $email_data->user_email = $user_data->usr_email;
                }
            if(isset($data['custom_data'])&&(!empty($data['custom_data'])))
            {
             $custom_data=$data['custom_data'];
            if(isset($custom_data['remove_email_link'])&&$custom_data['remove_email_link']!='') {
                $email_data->ALTERNATIVE_EMAIL_CONFIRMATION = '<a href="' . $custom_data['remove_email_link']. '">' . $custom_data['remove_email_link'] . '</a>';
                }

                if(isset($custom_data['merge_user_id'])&&$custom_data['merge_user_id']!='')
                {
                    $email_data->merge_user_id = $custom_data['merge_user_id'];
                }

                if(isset($custom_data['mail_recipient_ids'])&&$custom_data['mail_recipient_ids']!=''&&((isset($custom_data['esl_etmp_action'])&&($custom_data['esl_etmp_action']=='rv_rite_comment_mail')) || (($data['empt_name'] ?? null) == 'author_list_update')))
                {                
                    $email_data->mail_recipient_ids = $custom_data['mail_recipient_ids'];
                }
                if(isset($custom_data['editor_passed_comments'])&&$custom_data['editor_passed_comments']!='')
                {
                    $email_data->EDITOR_COMMENTS = $custom_data['editor_passed_comments'];
                }
             if(isset($custom_data['password'])&&($custom_data['password']!=''))
              {
                  $email_data->PASSWORD=$custom_data['password'];
              }
              if(isset($custom_data['rescind_request'])&&$custom_data['rescind_request']!='') {
                $email_data->rescind_request =$custom_data['rescind_request'];
                }
            if(isset($custom_data['transfer_article'])&&$custom_data['transfer_article']!='') {
                $email_data->transfer_article = $custom_data['transfer_article'];
                }
            if(isset($custom_data['prev_article_id'])&&$custom_data['prev_article_id']!='') {
                $email_data->prev_article_id = $custom_data['prev_article_id'];
                }
            if(isset($custom_data['src_jnl_id'])&&$custom_data['src_jnl_id']!='') {
                $email_data->src_jnl_id = $custom_data['src_jnl_id'];
                }
            if(isset($custom_data['transfer_link'])&&$custom_data['transfer_link']!='') {
                $email_data->DESTINATION_ARTICLE_STATUS_LINK = '<a href="' . $custom_data['transfer_link']. '">' . $custom_data['transfer_link'] . '</a>';
                }
              if(isset($custom_data['withdraw_reason'])&&($custom_data['withdraw_reason']!='')){
                $email_data->WITHDRAW_REASON = $custom_data['withdraw_reason'];
             }

             if(isset($custom_data['confirmation_link'])&&($custom_data['confirmation_link']!=''))
              {
                  $email_data->CONFIRMATION_URL=$custom_data['confirmation_link'];
              }
            if(isset($custom_data['confirm_cc_email'])&&$custom_data['confirm_cc_email']==TRUE)
            {
                $email_data->CONFIRMATION_URL=$custom_data['cc_confirmation_link'];
                $email_data->user_email = $custom_data['cc_email'];
            }
            if(isset($custom_data['esl_etmp_action'])&&($custom_data['esl_etmp_action']!='')){
                $email_data->esl_etmp_action = $custom_data['esl_etmp_action'];
            }
            if(isset($custom_data['action'])&&($custom_data['action']!='')){
                $email_data->action = $custom_data['action'];
            }
            if(isset($custom_data['aflw_id'])&&($custom_data['aflw_id']!='')){
                $email_data->aflw_id  = $custom_data['aflw_id'];
            }
            if(isset($custom_data['coauthor_notify'])&&($custom_data['coauthor_notify']!='')){
						$email_data->coauthor_notify=$custom_data['coauthor_notify'];
            }
            if(isset($custom_data['article_id'])&&($custom_data['article_id']!='')){
                $email_data->article_id =$custom_data['article_id'];
            }
            if(isset($custom_data['artp_id'])&&($custom_data['artp_id']!='')){
                $email_data->artp_id =$custom_data['artp_id'];
            }
            if(isset($custom_data['jnl_id'])&&($custom_data['jnl_id']!='')){
                $email_data->jnl_id = $custom_data['jnl_id'];
            }
            if(isset($custom_data['jnl_code'])&&($custom_data['jnl_code']!='')){
                $email_data->jnl_code = $custom_data['jnl_code'];
                $email_data->jnl_journal_code = $custom_data['jnl_code'];
            }
            if(isset($custom_data['reset_link'])&&$custom_data['reset_link']!='')
            {
            $email_data->RESET_PASSWORD_LINK = $custom_data['reset_link'];
            }
            if(isset($custom_data['stage_import_errors'])&&$custom_data['stage_import_errors']!='')
            {
            $email_data->STAGE_IMPORT_ERRORS = $custom_data['stage_import_errors'];
            }
            if(isset($custom_data['artp_id'])&&$custom_data['artp_id']!='')
            {
            $email_data->artp_id = $custom_data['artp_id'];
            } //TASK #5630 Implement an option within the sheet view to recover a withdrawn article. withdraw bugfix
            if(isset($custom_data['user_name'])&&$custom_data['user_name']!='')
            {
            $email_data->user_name = $custom_data['user_name'];
            }
            if(isset($custom_data['current_user_unregister_account'])&&$custom_data['current_user_unregister_account']!='')
            {
                $email_data->CURRENT_USER_UNREGISTER_REASON  = $custom_data['current_user_unregister_account'];
            }
            if(isset($custom_data['prevent_edit_reason'])&&$custom_data['prevent_edit_reason']!='')
            {
                $email_data->prevent_edit_reason  = $custom_data['prevent_edit_reason'];
            }
            if(isset($custom_data['prevent_edit_decline_access_reason'])&&$custom_data['prevent_edit_decline_access_reason']!='')
            {
                $email_data->prevent_edit_decline_access_reason  = $custom_data['prevent_edit_decline_access_reason'];
            }
            if(isset($custom_data['set_link'])&&$custom_data['set_link']!='')
            {$email_data->SET_PASSWORD_LINK =$custom_data['set_link'];}
            if(isset($custom_data['esl_etmp_action'])&&($custom_data['esl_etmp_action']!='')) {
                $email_data->esl_etmp_action = $custom_data['esl_etmp_action'];
                $email_data->add_potential_reviewer = TRUE;
            }
            if(isset($custom_data['article_status_link'])&&($custom_data['article_status_link']!='')) {
            $email_data->ARTICLE_STATUS_LINK = $custom_data['article_status_link'];;
            }
            if(isset($custom_data['user_roles'])&&($custom_data['user_roles']!='')&&isset($custom_data['role_names'])&&($custom_data['role_names']!='')) {

                $email_data->user_roles = rtrim($custom_data['role_names'],', ');
            }

             if(isset($data['duedate_extension'])&&($data['duedate_extension']==TRUE))
             {

                $email_data->aflw_due_date=$custom_data['aflw_due_date'];
                $email_data->PRECEDING_DUE_DATE=$custom_data['old_due_date'];
                $email_data->ARTICLE_STATUS_LINK=$custom_data['article_url'];

             }
             // TASK #9425 Convey Integration In Review3
             if(isset($custom_data['convey_link_to_disclose'])&&$custom_data['convey_link_to_disclose']!='')
             {
             $email_data->CONVEY_LINK_TO_DISCLOSE = $custom_data['convey_link_to_disclose'];
             }
             if(isset($custom_data['author_list_change'])&&($custom_data['author_list_change']!=''))
          {
              $email_data->ARTICLE_AUTHOR_LIST_CHANGE=$custom_data['author_list_change'];
          }
          //Task #486 Email is not sent properly when add or remove a role in journal
          if(isset($custom_data['newly_added_roles'])&&$custom_data['newly_added_roles']!='')
          {
              $email_data->newly_added_roles = $custom_data['newly_added_roles'];
          }
             if(isset($custom_data['api_name'])&&$custom_data['api_name']!=''){
                $email_data->name = $custom_data['api_name'];
            }
            }

            if ($user_email != "") {

                $email_data->CONFIRMATION_URL = URL::to('/') . '/confirmation/primary-email/' . $activation_url . '/' . $this->encrypt_data($user_email);

            }
            $email_data->email_templates_config = $this->email_templates_config();
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->user_role_tags = $this->user_role_tags();
            //reply_to start
            $current_status = array();
            $reply_to='';
            $article_flow_table = (new \App\Models\Article_flow);
            if(isset($custom_data['jnl_id'])&&($custom_data['jnl_id']!=''))
             {
                if(isset($custom_data['article_id'])&&($custom_data['article_id']!='')&&(isset($custom_data['aflw_id'])&&($custom_data['aflw_id']!='') && !is_array($custom_data['aflw_id'])))
                {
                $select = 'jwf_stage_type,jwf_role_id';
                $where ="aflw_art_id={$custom_data['article_id']} AND aflw_id={$custom_data['aflw_id']}";
                $current_status = $article_flow_table::get_generic_flow($select, $where);
                }
             $reply_to=$this->get_reply_to_email($custom_data['jnl_id'],$current_status);
             }
            if (isset($reply_to) && $reply_to != '')
            {
                $email_data->reply_to = $reply_to;
            }
            //reply_to end
            $email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
            if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y') {$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;}
            if (isset($record->etmp_email_template) && strpos($record->etmp_email_template, "OPENING_PARAGRAPH") > 0) {$record->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT', $record->etmp_email_template);}
            $core_role = (isset($data['jnl_user_role']) && isset($data['jnl_user_role']['core_role'])) ? $data['jnl_user_role']['core_role'] : '';
            $email_data->core_role = $core_role;
            $core_role_name = (isset($data['jnl_user_role']) && isset($data['jnl_user_role']['role_name'])) ? $data['jnl_user_role']['role_name'] : '';
            $email_data->core_role_name = $core_role_name;
         if((isset($data['email_with_login']))&&($data['email_with_login']==TRUE))
         {
         $this->current_user=$this->get_current_user_details();
         }
         else
        {
            $this->current_user= array(
                'user_id' =>$user_data->usr_id,
                'proxy_user_id' => 0,
                'roles' => json_decode($user_data->usr_roles)
            );
        }
        $return_batch_id=false;
        if(isset($data['custom_data'])&&(!empty($data['custom_data'])))
        {
         $custom_data=$data['custom_data'];
         if(isset($custom_data['user_data'])&&$custom_data['user_data']!='')
         {
            $this->current_user= $custom_data['user_data'];
         }
         if(isset($custom_data['return_batch_id'])&&$custom_data['return_batch_id']!='')
         {
            $return_batch_id= $custom_data['return_batch_id'];
         }
        }


            $data = array(
                'record' => $record,
                'email_data' => $email_data,
                'user_data' =>$this->current_user,
                'column_prefix' => 'etmp_',
                'return_batch_id' => $return_batch_id,
                'email_update_data' => [],
                'production_status' => ''

            );

            $return_data =   $this->notify_mail($data);
         return $return_data;
        }
    }
    public function notify_mail($data)
    {
        $template_content = $data['column_prefix'] . 'email_template';
        $template_subject = $data['column_prefix'] . 'subject';
        $body = $data['record']->$template_content;
        $subject = $data['record']->$template_subject;
        $return_batch_id=isset($data['return_batch_id'])?$data['return_batch_id']:FALSE;
        $production_status=isset($data['production_status'])?$data['production_status']:FALSE;
        $email_update_data=isset($data['email_update_data'])?$data['email_update_data']:array();
        if (isset($data['record']->review_method) && $data['record']->review_method != 'o') {
            $subject = $this->replace_content($data['record']->assignments, $subject);
        }
        $user_titles = $this->UserConfigdata('titles')['titles'];
        $data['email_data']->subject = html_entity_decode(strip_tags($this->generate_email_data_from_keys($data['email_data'], $subject, $data['user_data'], $user_titles, false, true, $production_status)), ENT_COMPAT, 'UTF-8');
        if (isset($data['email_data']->all_user_roles)) {
            foreach ($data['email_data']->all_user_roles as $role) {
                $tmp_name = 'name_' . $role->role_names;
                $tmp_name_email = 'name_and_email_' . $role->role_names;

                if (isset($data['email_data']->$tmp_name)) {
                    $data['email_data']->$tmp_name .= '<br>' . $role->user_name;
                    $data['email_data']->$tmp_name_email .= '<br>' . $role->user_name . ', ' . $role->user_email;
                } else {
                    $data['email_data']->$tmp_name = $role->user_name;
                    $data['email_data']->$tmp_name_email = $role->user_name . ', ' . $role->user_email;
                }
            }
        }
		if(isset($data['record']->review_method) && $data['record']->review_method!='o' && ($data['record']->stage_etmp_to == 'submit_author' || $data['record']->stage_etmp_to == 'Author' || $data['record']->stage_etmp_to == 'Authors' || $data['record']->stage_etmp_to == 'article_authors'))
        {
            $body = $this->replace_content($data['record']->assignments, $body);
        }

        $data['email_data']->body = $this->generate_email_data_from_keys($data['email_data'], $body, $data['user_data'], $user_titles, false, true, $production_status);
        foreach ($data['email_data'] as $key => $value) {
            if ($key == 'all_user_roles') {
                continue;
            }

        }
        $return_id = $this->send_email_notification($data['record'], $data['email_data'], $data['user_data'], $data['column_prefix'], $return_batch_id, $email_update_data);
        if ($return_batch_id == true) {
            return $return_id;
        }

    }
    public function generate_email_data_from_keys($email_data, $body, $user_data, $titles = array(), $show_preview = false, $replace_all_tags = true, $mng_production = false)
    {
        if (empty($titles)) {

            $titles = $this->UserConfigdata('titles')['titles'];
        }
        if (isset($email_data)) {
            preg_match_all('/##([^##]*)##/', $body, $matches);
            $keys = $matches[1];
            $email_templates = $email_data->email_templates_config;
            $join_condition = $email_data->join_config;
            $join_dependencies = $email_data->join_dependency_config;
            $prev_article_id = null;
            $tmpl_config = array();
            $user_config = array();
            $usr_jnl_config = array();
            $usr_artp_config = array();
            $current_user_config = array();
            $copyright_tags = array();
            $userrole_tags = array();
            $author_config = array();
            $rs_config_arr = array();
            $jnl_epa_tags = array();
            $merge_user_config = array();
            $transit_admin_keys = array();
            $transfer_tags = array();
            $api_user_client_config = array();
            $event_config_tags = array();  /*TASK #5761 Event Based Email Tags Settings in Email Template*/
            $article_status_arr = array(
                'ARTICLE_STAGE_NAME',
                'ARTICLE_STATUS_NAME',
                'TASK_DUE_DATE',
                'TASK_REMAINING_DAYS',
                'REVIEW_ACCEPT_DATE',
                'TASK_ASSIGNED_DATE');


            if (isset($email_data->prev_article_id)) {
                $prev_article_id = $email_data->prev_article_id;
            }
            $exclude_keys = array(
                'CURRENT_DATE',
                'SITE_URL',
                'ARTICLE_STATUS_LINK',
                'AUTHOR_CONFIRMATION_URL',
                'ARTICLE_STUB_SUBMISSION_LINK',
                'ARTICLE_STATUS_NAME',
                'ARTICLE_STAGE_NAME',
                'TASK_DUE_DATE',
                'PLAGIARISM_REPORT_LINK',
                'PERCENT_MATCH',
                'TASK_REMAINING_DAYS',
                'PRECEDING_DUE_DATE',
                'SENDING_JOURNAL',
                'REOPENED_REVIEW_STAGE_NAME',
                'WITHDRAW_REASON',
                'REASON_FOR_REJECT',
                'REVIEW_ACCEPT_DATE',
                'REOPEN_REASON',
                'TASK_ASSIGNED_DATE',
                // 'RESCIND_REASON',
                'ARTICLE_AUTHOR_ACCESS_APPROVE/REJECT_REASON'
            );
            $exclude_keys_for_edit = array(
                '##ARTICLE_STATUS_LINK##',
                '##AUTHOR_CONFIRMATION_URL##',
                '##ARTICLE_STUB_SUBMISSION_LINK##',
                '##TASK_DUE_DATE##',
                '##PLAGIARISM_REPORT_LINK##',
                '##PRECEDING_DUE_DATE##',
                '##REVIEW_ACCEPT_DATE##',
                '##TASK_ASSIGNED_DATE##',
                '##AUTHOR_CONFIRMATION_URL##',
                '##ARTICLE_STATUS_LINK_BLIND##',
                '##DECISION_STATUS##',
                '##TASK_REMAINING_DAYS##',
                '##RESCIND_REASON##',
                '##CONVEY_LINK_TO_DISCLOSE##',
                '##ARTICLE_CREATION_DUE_DATE##', /*Task #1787 Due date in settings page */
                '##FEEDBACK_TO_REVIEWER##'
            );
            $exclude_keys_for_preview = array(
                '##DECISION_STATUS##',
                '##ARTICLE_TITLE##',
                 '##TASK_DUE_DATE##',
                 '##ARTICLE_ID##',
                 '##TASK_REMAINING_DAYS##',
                 '##RESCIND_REASON##',
                 '##ARTICLE_CREATION_DUE_DATE##', /*Task #1787 Due date in settings page */
                 '##FEEDBACK_TO_REVIEWER##'
            ); // TASK 6401 preview button for decision


            $mail_type = '';
            if (isset($email_data->mail_type)) {
                $mail_type = $email_data->mail_type;
            }

            $etmp_action = null;
            if (isset($email_data->stage_etmp_action)) {
                $etmp_action = $email_data->stage_etmp_action;
            }

            $exclude_bmj_excp_art_tags = array();
            if (!empty($email_data->bmj_exceptional)) {
                $exclude_bmj_excp_art_tags = array_keys($email_data->bmj_exceptional);
            }

            $core_role = (isset($email_data->core_role)) ? $email_data->core_role : '';
            $core_role_name = (isset($email_data->core_role_name)) ? $email_data->core_role_name : '';
            $stage_keys = array();
            if (strpos($body, "OPENING_PARAGRAPH") > 0) {
                $body = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT', $body);
            }

            preg_match_all('/##\w*\{([\w\/\*\- ]*)\}##/', $body, $stage_matches); //TASK #7187 Check the initialization mail for submitted reviwers in revision,accpt and reject stage
            $stage_keys = $stage_matches[1];
            $additional_condi = null;
            if (isset($email_data->artp_id) && !empty($email_data->artp_id) && isset($email_data->aflw_id) && !empty($email_data->aflw_id)) {
                $sql = 'SELECT role_assigned_role,jwf_role_id FROM ' . self::get_table_name('roles_table') . ' LEFT JOIN ' . self::get_table_name('generic_flows_table') . ' on jwf_role_id = role_id LEFT JOIN ' . self::get_table_name('article_flow_table') . ' on aflw_jwf_id = jwf_id WHERE aflw_id = ' . $email_data->aflw_id;
                $role_table = new \App\Models\Roles();
                $current_user_role_data = $role_table::get_records_by_raw_query($sql);
                if (isset($current_user_role_data[0]->role_assigned_role)) {
                    $additional_condi = array(
                        'artp_id' => $email_data->artp_id,
                        'role_assigned_role' => $current_user_role_data[0]->role_assigned_role,
                        'current_role_id'=>$current_user_role_data[0]->jwf_role_id);
                }
            }
            if (isset($email_templates['article_tags']['REVISION_DATE']) && isset($email_data->artp_id) && !empty($email_data->artp_id) && isset($email_data->article_id) && !empty($email_data->article_id)) {
                $rv_sql = array('select' => array('(SELECT DATE_FORMAT(art_submission_date, "%d-%m-%Y") FROM ' . self::get_table_name('article_table') . ' WHERE art_prev_article_id IS NOT NULL AND ' . self::get_table_name('article_table') . '.art_artp_id = ' . $email_data->artp_id . ' AND ' . self::get_table_name('article_table') . '.art_id =' . $email_data->article_id . ')'));
                $email_templates['article_tags']['REVISION_DATE'] = $rv_sql;
            }
            if (isset($email_templates['article_tags']['ARTICLE_SUBMITTED_DATE']) && isset($email_data->artp_id) && !empty($email_data->artp_id) && isset($email_data->article_id) && !empty($email_data->article_id)) {
                $sub_date_sql = array('select' => array('(SELECT DATE_FORMAT(art_submission_date, "%d-%m-%Y") FROM ' . self::get_table_name('article_table') . ' WHERE ' . self::get_table_name('article_table') . '.art_artp_id = ' . $email_data->artp_id . ' AND (' . self::get_table_name('article_table') . '.art_id IN (SELECT art_pre_all_ids FROM ' . self::get_table_name('article_table') . ' WHERE art_id =' . $email_data->article_id . ') OR art_id =' . $email_data->article_id . ') LIMIT 1)'));
                $email_templates['article_tags']['ARTICLE_SUBMITTED_DATE'] = $sub_date_sql;

            }
            /** need to change the table name dynamically when discussion added **/

        if(isset($email_templates['article_tags']['DISCUSSION_TITLE']) && isset($email_data->gen_disc_id) && !empty($email_data->gen_disc_id) )
        {
        $gen_disc_title_sql = array('select' => array('(SELECT gdis_title  FROM  '. self::get_table_name('generic_discussion') .'  WHERE gdis_id = '.$email_data->gen_disc_id .')'));
        $email_templates['article_tags']['DISCUSSION_TITLE'] = $gen_disc_title_sql ;
        }
        if(isset($email_templates['article_tags']['DISCUSSION_COMMENT']) && isset($email_data->gen_disc_commnt_id) && !empty($email_data->gen_disc_commnt_id) )
        {
        $gen_disc_commnt_sql = array('select' => array('(SELECT gdsc_comment  FROM  '. self::get_table_name('generic_discussion_comments') .'  WHERE gdsc_id = '.$email_data->gen_disc_commnt_id .')'));
        $email_templates['article_tags']['DISCUSSION_COMMENT'] = $gen_disc_commnt_sql ;
        }
        if(isset($email_templates['article_tags']['DISCUSSION_STARTED_USER_FULLNAME']) && isset($email_data->gen_disc_id) && !empty($email_data->gen_disc_id) )
        {
        $disc_started_usr_sql = array('select' => array('(SELECT CONCAT(usr_first_name,IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")),usr_last_name) FROM  '. self::get_table_name('generic_discussion') .'  JOIN  '. self::get_table_name('user_table') .'  ON  '. self::get_table_name('user_table') .' .usr_id =  '. self::get_table_name('generic_discussion') .' .gdis_started_by  WHERE gdis_id = '.$email_data->gen_disc_id .')'));
        $email_templates['article_tags']['DISCUSSION_STARTED_USER_FULLNAME'] = $disc_started_usr_sql ;
        }

        if(isset($email_templates['article_tags']['DISCUSSION_STARTED_USER_TITLE']) && isset($email_data->gen_disc_id) && !empty($email_data->gen_disc_id) )
        {
        $disc_started_usr_title = array('select' => array('(SELECT gdis_title  FROM  '. self::get_table_name('generic_discussion') .' WHERE gdis_id = '.$email_data->gen_disc_id .')'));
        $email_templates['article_tags']['DISCUSSION_STARTED_USER_TITLE'] = $disc_started_usr_title ;
        }
        if(isset($email_templates['article_tags']['DISCUSSION_STARTED_USER_EMAIL']) && isset($email_data->gen_disc_id) && !empty($email_data->gen_disc_id) )
        {
        $disc_started_usr_email = array('select' => array('(SELECT usr_email FROM  '. self::get_table_name('generic_discussion') .'  JOIN  '. self::get_table_name('user_table') .'  ON  '. self::get_table_name('user_table') .' .usr_id =  '. self::get_table_name('generic_discussion') .' .gdis_started_by  WHERE gdis_id = '.$email_data->gen_disc_id .')'));
        $email_templates['article_tags']['DISCUSSION_STARTED_USER_EMAIL'] = $disc_started_usr_email ;
        }


            $Journal_settings_table = (new \App\Models\Journal_settings())->getTable();
            $Stage_email_templates_table = new \App\Models\Stage_email_templates();

            $client_email_date_format = '';
            if (isset($email_data->article_id) && !empty($email_data->article_id)) {
                $cndtn_val =  is_array($email_data->article_id) ? 'in ("'. implode('", "', $email_data->article_id) . '") ' : " = ". $email_data->article_id;
                $query = 'select jset_date_format FROM  ' . self::get_table_name('article_table') . ' INNER JOIN ' . self::get_table_name('article_type_table') . ' ON  ' . self::get_table_name('article_table') . '.art_artp_id = ' . self::get_table_name('article_type_table') . '.artp_id INNER JOIN ' . $Journal_settings_table . ' ON ' . $Journal_settings_table . '.jset_jnl_id = ' . self::get_table_name('article_type_table') . '.artp_jnl_id WHERE  ' . self::get_table_name('article_table') . '.art_id '. $cndtn_val;
                $jnl_data = $Stage_email_templates_table::get_records_by_raw_query($query);

                if (isset($jnl_data[0]->jset_date_format)) {
                    $client_email_date_format = $jnl_data[0]->jset_date_format;
                }

            }

          $body= $this->replace_generic_form_content($stage_keys,$email_data,$body);

        /* Start REPLACEMENT SELECT SQL TAG BASED */
          $rescind_reset_keys = array(
            'RESCIND_REASON',
            'RESET_REASON',
            'RESCIND_STAGE',
            'RESET_STAGE',
            'RESCIND_REVIEW_REASON',
        );
        $transfer_jrnl_admin_keys = array(
            'DESTINATION_JOURNAL_ADMIN_EMAIL',
            'DESTINATION_JOURNAL_ADMIN_NAME',
            'DESTINATION_JOURNAL_ADMIN_TITLE',
        );
        for ($i = 0; $i < count($keys); $i++) {
            if (substr($keys[$i], 0, 5) == 'ROLE_') {
                $user_roles_arr = $email_data->user_role_tags;
                $userrole_tags[] = $keys[$i];
            } else {
                foreach ($email_templates as $em_key => $em_value) {

                    foreach ($em_value as $key => $val) {

                        if ($em_key == 'article_tags' || $em_key == 'transfer_article_tags') {
                            if (in_array($key, $rescind_reset_keys)) {
                                $rs_config_arr[$key] = $val;
                            } elseif (in_array($key, $transfer_jrnl_admin_keys)) {
                                $transit_admin_keys[$em_key][$key] = $val;
                            } elseif ($em_key == 'transfer_article_tags' && !in_array($key, $exclude_keys)) {
                                $transfer_tags[$em_key][$key] = $val;
                            } elseif ($key == $keys[$i] && !in_array($key, $exclude_keys) && !in_array($key, $exclude_bmj_excp_art_tags)) {
                                $tmpl_config[$em_key][$key] = $val;
                            }
                        } elseif ($em_key == 'author_tags') {

                            if ($key == $keys[$i]) {

                              $author_config[$key] = $val;
                            }
                        } elseif ($em_key == 'recipient_tags') {

                            if ($key == $keys[$i]) {

                                $user_config[$key] = $val;

                            }
                        } elseif ($em_key == 'current_user_tags') {
                            if ($key == $keys[$i]) {
                                $current_user_config[$key] = $val;
                            }
                        } elseif ($em_key == 'copyright_tags') {
                            if ($key == $keys[$i]) {
                                $copyright_tags[$key] = $val;
                            }
                        } else if ($em_key == 'journal_tags') {
                            if ($key == $keys[$i]) {
                                $usr_jnl_config[$key] = $val;
                            }
                        } else if ($em_key == 'article_type_tags') {
                            if ($key == $keys[$i]) {
                                $usr_artp_config[$key] = $val;
                            }
                        } else if ($em_key == 'journal_EPA_tags') {
                            if ($key == $keys[$i]) {
                                $jnl_epa_tags[$key] = $val;
                            }
                        } elseif ($em_key == 'merged_user_tags') {
                            if ($key == $keys[$i]) {
                                $merge_user_config[$key] = $val;
                            }

                        } elseif ($em_key == 'api_user_client_tags') {
                            if ($key == $keys[$i]) {
                                $api_user_client_config[$key] = $val;
                            }

                        }elseif ($em_key == 'abstract_tags') {
                            if ($key == $keys[$i]) {
                                $abstract_config[$em_key][$key] = $val;
                            }

                        }
                          /*TASK #5761 Event Based Email Tags Settings in Email Template*/
                        elseif ($em_key =='event_tags') {
                          
                            if ($key == $keys[$i]) {
                                $event_config_tags[$key] = $val;
                            }

                        }
                    }
                }
            }
            
        }

        /* End REPLACEMENT SELECT SQL TAG BASED */
        /* RESCIND REPLACENET START */
       $body=$this->replace_resind_reset_data($rs_config_arr,$email_data,$titles,$mail_type,$body);
         /* RESCIND REPLACENET END  */
  /* ARTICLE TAG REPLACENET START */

         $body= $this->replace_article_related_tag_data($tmpl_config,$email_data,$titles,$client_email_date_format,$body,$show_preview);
         /* ARTICLE TAG REPLACENET END  */
        if(isset($abstract_config) && count($abstract_config) > 0){

         $body = $this->replace_conference_related_tags($abstract_config, $email_data, $titles, $client_email_date_format, $body);
        }
        if (isset($email_data->article_id)) {
                    if (count($transfer_tags) > 0 && !is_array($email_data->article_id)) {
                    $results = $Stage_email_templates_table::format_email_content($transfer_tags, $email_data->article_id, $join_condition, $join_dependencies, $prev_article_id);
                    foreach ($results as $result) {
                        foreach ($result as $rkey => $rval) {
                            if (array_key_exists($rval, $titles)) {
                                $body = str_ireplace("##$rkey##", $titles[$rval], $body);
                            } else {
                                $rval = preg_replace('/,+/', ',', $rval);
                                $body = str_ireplace("##$rkey##", $rval, $body);
                            }
                        }
                    }
                }
            }
            if (isset($email_data->article_id)) {
                    if (count($transit_admin_keys) > 0 && !is_array($email_data->article_id)) {
                    $results = $Stage_email_templates_table::format_email_content($transit_admin_keys, $email_data->article_id, $join_condition, $join_dependencies, $prev_article_id);
                    foreach ($results as $result) {
                        foreach ($result as $rkey => $rval) {
                            if (array_key_exists($rval, $titles)) {
                                $body = str_ireplace("##$rkey##", $titles[$rval], $body);
                            } else {
                                $rval = preg_replace('/,+/', ',', $rval);
                                $body = str_ireplace("##$rkey##", $rval, $body);
                            }
                        }
                    }
                }
            }
            if (count($author_config) > 0) {
                if (isset($email_data->article_id)) {
                    $auth_id = (isset($email_data->auth_id)) ? $email_data->auth_id : 0;
                    $authr_results = $Stage_email_templates_table::get_author_data($author_config, $email_data->article_id, $join_condition, $join_dependencies, $auth_id);
                    $Article_type_advance_options = new \App\Models\Article_type_advance_options;
                    $Articles = new \App\Models\Articles;
                    $Article_flow = new \App\Models\Article_flow();
                    $Roles = new \App\Models\Roles();
                    $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$email_data->artp_id}");
                    $author_details=array();
                    if (isset($email_data->aflw_id)) {
                    $condition = "aflw_id={$email_data->aflw_id}";
                    $flowdetails = $Articles::get_article_details("jwf_role_id", $condition);
                    $core_role_details  =   $Roles::get_single_record('role_assigned_role',"role_id={$flowdetails[0]->jwf_role_id}");
                    if (isset($core_role_details->role_assigned_role)&&($core_role_details->role_assigned_role=='reviewer' ||(isset($email_data->to)&&$email_data->to=='submitted_reviewers'))&&isset($artp_settings->atotp_review_method)&&($artp_settings->atotp_review_method=='d'))  {
                    $author_details=array(
                        'core_role_name'=>$core_role_details->role_assigned_role,
                        'review_method'=>$artp_settings->atotp_review_method,
                        'atotp_custom_blind_params' => $artp_settings->atotp_custom_blind_params,
                        'author_config'=>'author_config',
                        'email_data'=>$email_data,
                        'role_id' => $flowdetails[0]->jwf_role_id
                    );
                }
                }
                    $body = $this->replace_email_key_with_data($authr_results, $body, $titles, null, $mail_type,'',$author_details, is_preview:$show_preview, config_name:'author_config');
                }
            }

           /* //error in next button (due to ajo commit)
           if (count($copyright_tags) > 0) {
                if (isset($email_data->article_id)) {
                    $copyrightmaster_table = (new \App\Models\Copyright_master())->getTable();
                    $copyright_table = (new \App\Models\Copyright())->getTable();
                    $select = '';
                    foreach ($copyright_config as $cpkey => $cpval) {
                        $select .= $cpval['select'] . ' AS ' . $cpkey . ',';
                    }
                    $select = rtrim($select, ',');
                    $sql = 'SELECT ' . $select . ' FROM ' . $copyrightmaster_table . ' INNER JOIN ' . $copyright_table . ' on ' . $copyright_table . '.crt_crtm_id = ' . $copyrightmaster_table . '.crtm_id WHERE crt_art_id =' . $email_data->article_id;
                    $copyright_results = $Stage_email_templates_table::get_records_by_raw_query($sql);
                    $body = $this->replace_email_key_with_data($copyright_results, $body, $titles, null, $mail_type);
                }
            }
                */
                //Task #752 The "User Assign" email preview in the "Change Assignment" section is displaying the wrong recipient.
                if(isset($email_data->email_for)&&$email_data->email_for=='change_asmt'&&$mail_type=='preview'){
                    $show_preview=false;
                }
            if (count($user_config) > 0 && $show_preview == true) {
                if (isset($email_data->user_id)) {
                    $user_id = $user_data['user_id'];
                $is_blinded = false;
                $rcp_role_id = $this->get_role_id_from_mail_to($email_data->to ?? $email_data->too ?? 'User', $email_data->aflw_id ?? null);
                if($rcp_role_id){
                    $is_blinded = (new Controller())->is_custom_blinded($rcp_role_id, $email_data->article_id ?? null, null, null, $email_data->artp_id ?? null, $email_data->jnl_journal_code?? $email_data->jnl_id ?? null, blinded_user:$email_data->user_id ?? null);
                }
                    $user_id = $email_data->user_id;
                    $user_results = $Stage_email_templates_table::get_recipient_data($user_config, $user_id, $additional_condi, $core_role, $core_role_name);
                    $body = $this->replace_email_key_with_data($user_results, $body, $titles, is_blinded: $is_blinded, config_name:'user_config');
                }
            };
            unset($usr_jnl_config['ARTICLE_CREATION_DUE_DATE']);  // Task #3890 Organizer email no edited content is sent 
            if (count($usr_jnl_config) > 0) {
                if (isset($email_data->user_id) && isset($email_data->jnl_id)) {
                    $usr_jnl_results = $Stage_email_templates_table::get_usr_jnl_data($email_data->user_id, $email_data->jnl_id, $usr_jnl_config, $join_condition, $join_dependencies);
                    //Task #486 Email is not sent properly when add or remove a role in journal
                    if(isset($email_data->newly_added_roles)){
                        $usr_jnl_results[0]->INVITED_JOURNAL_ROLES=$email_data->newly_added_roles;
                    } 
                    $body = $this->replace_email_key_with_data($usr_jnl_results, $body, $titles, null, $mail_type);
                }
                if(isset($email_data->jnl_id)&&$email_data->jnl_id!=NULL&&isset($email_data->template_name)&&$email_data->template_name=='bulk_invite_submission')
                {
                    
                    $usr_jnl_results = $Stage_email_templates_table::get_usr_jnl_data(NULL, $email_data->jnl_id, $usr_jnl_config, $join_condition, $join_dependencies);
                    $body = $this->replace_email_key_with_data($usr_jnl_results, $body, $titles, null, $mail_type);      
                }
    
            }
            if (count($usr_artp_config) > 0) {
                if (isset($email_data->user_id) && isset($email_data->artp_id)) {
                    $usr_artp_results = $Stage_email_templates_table::get_usr_artp_data($email_data->user_id, $email_data->artp_id, $usr_artp_config, $join_condition, $join_dependencies);
                    //Task #486 Email is not sent properly when add or remove a role in journal
                    if(isset($email_data->newly_added_roles)){
                        $usr_artp_results[0]->INVITED_ARTICLE_TYPE_ROLES = $email_data->newly_added_roles;
                    } 
                    $body = $this->replace_email_key_with_data($usr_artp_results, $body, $titles, null, $mail_type);
                }
            }
            
              /*TASK #5761 Event Based Email Tags Settings in Email Template*/
            if (count($event_config_tags) > 0) {
                
                if (isset($email_data->artp_id)&&$email_data->artp_id!=NULL) {
                    
                    $article_type_table = (new \App\Models\Article_types())->getTable();
                 
                    $select = '';
                    
                    foreach ($event_config_tags as $evkey => $evval) {
                      if(isset($evval['select'])&&$evval['select']!=NULL)
                        $select .= $evval['select'] . ' AS ' . $evkey . ',';
                    }
                    $select = rtrim($select, ',');
                   
                    $sql = 'SELECT ' . $select . ' FROM ' . $article_type_table .' WHERE artp_id =' . $email_data->artp_id;
                    $event_results = $Stage_email_templates_table::get_records_by_raw_query($sql);
                    $body = $this->replace_email_key_with_data($event_results, $body, $titles, null, $mail_type);
                }
            }
            /*Task End */
            if (count($current_user_config) > 0) {
                $user_id = $user_data['user_id'];
                if ($user_data['user_id'] == 0) {
                    $user_id = (isset($email_data->user_id) && !empty($email_data->user_id && strpos($email_data->user_id, ',') == false) ? $email_data->user_id : 0);
                }
                $curr_usr_role = array();
                $is_blinded = false;
                $usr_role_id = $this->get_role_id_from_mail_to($email_data->to ?? $email_data->too ?? 'User', $email_data->aflw_id ?? null);
                if(isset($user_data['user_id']) && $usr_role_id){
                    $is_blinded = (new Controller())->is_custom_blinded(null, $email_data->article_id ?? null, null, $usr_role_id, $email_data->artp_id ?? null, $email_data->jnl_journal_code?? $email_data->jnl_id ?? null, $user_data['user_id']);
                }
                if(isset($user_data['jnl_user_role']))
				{
					$curr_usr_role = array('role_id' =>$user_data['jnl_user_role'][$email_data->jnl_journal_code]['role_id'], 'assigned_role'=>$user_data['jnl_user_role'][$email_data->jnl_journal_code]['core_role']) ;
				}
                if(isset($email_data->submsn_type) && $email_data->submsn_type == 'proposal' && $additional_condi ==null)
                {
                   /** current user role tag replacement on email preview in article proposal assignment when flow id is not set  */
                   $additional_condi = array('artp_id' => $email_data->artp_id,
                   'role_assigned_role' => '',
                   'current_role_id'=>''
                   );
               }

                $current_user_results = $Stage_email_templates_table::get_recipient_data($current_user_config, $user_id, $additional_condi, $core_role, $core_role_name,$curr_usr_role);
                // var_dump($current_user_results);die;
                $body = $this->replace_email_key_with_data($current_user_results, $body, $titles, null, $mail_type, is_blinded : $is_blinded, config_name:"current_user_config");
                // var_dump($body);die;
            }
            if (count($merge_user_config) > 0) {
                if (isset($email_data->merge_user_id)) {
                    $merge_user_results = $Stage_email_templates_table::get_recipient_data($merge_user_config, $email_data->merge_user_id, $additional_condi, $core_role, $core_role_name);
                    $body = $this->replace_email_key_with_data($merge_user_results, $body, $titles);
                }
            }

            $body= $this->replace_apiuserconfigtags($api_user_client_config,$email_data,$titles,$mail_type,$body);

            $Custom_email_template_tags_table = new \App\Models\Custom_email_template_tags();

            $custom_tags = $Custom_email_template_tags_table::get_all_records();
            if (count($custom_tags) > 0) {
                foreach ($custom_tags as $cust_tag) {
                    // TAG_DISCLAIMER reduce font size 
                    if($cust_tag->cettag_name=='TAG_DISCLAIMER'){
                        $cust_tag->cettag_value="<div style='font-size:12px'>".$cust_tag->cettag_value.'</div>';
                    }
                    if (in_array($cust_tag->cettag_name, $keys)) {
                        $body = str_ireplace("##$cust_tag->cettag_name##", $cust_tag->cettag_value, $body);
                    }
                }
            }
            if (count($userrole_tags) > 0) {
                if (isset($email_data->artp_id) && isset($email_data->jnl_id)) {
                    $jnl_id = $email_data->jnl_id;
                    $art_type_id = $email_data->artp_id;
                    $each_role_tag = array();
                    foreach ($userrole_tags as $role_key => $role_value) {
                        $user_role_tag = explode('_', $role_value);
                        array_shift($user_role_tag);
                        array_pop($user_role_tag);
                        $org_userrole = implode('_', $user_role_tag);
                        $each_role_tag[$org_userrole][] = $role_value;
                    }
                    $art_id = isset($email_data->article_id) ? $email_data->article_id : null;

                    foreach ($each_role_tag as $role_key => $role_tag) {
                        $user_role_tag_results = $Stage_email_templates_table::get_user_role_data(array_unique($each_role_tag[$role_key]), $user_roles_arr, $jnl_id, $art_type_id, $art_id);
                       // TASK #8200 Tag replacing issue in blind conditions start
                        $Article_type_advance_options = new \App\Models\Article_type_advance_options;
                        $Articles = new \App\Models\Articles;
                        $Article_flow = new \App\Models\Article_flow();
                        $Roles = new \App\Models\Roles();
                        $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$email_data->artp_id}");
                        $author_details=array();
                        if (isset($email_data->aflw_id)) {
                        $condition = "aflw_id={$email_data->aflw_id}";
                        $flowdetails = $Articles::get_article_details("jwf_role_id", $condition);
                        $core_role_details  =   $Roles::get_single_record('role_assigned_role',"role_id={$flowdetails[0]->jwf_role_id}");
                        if(((($artp_settings->atotp_review_method=='s')&&((($core_role_details->role_assigned_role == 'author') || (isset($email_data->to) && $core_role_details->role_assigned_role == 'reviewer'))))&&($artp_settings->atotp_review_method=='d'))){
                        $author_details=array(
                            'core_role_name'=>$core_role_details->role_assigned_role,
                            'review_method'=>$artp_settings->atotp_review_method,
                            'atotp_custom_blind_params' => $artp_settings->atotp_custom_blind_params,
                            'author_config'=>'user_role_tag',
                            'email_data'=>$email_data,
                            'role_id' => $flowdetails[0]->jwf_role_id
                        );
                    }
                    }
                     // TASK #8200 Tag replacing issue in blind conditions end

                        $body = $this->replace_email_key_with_data($user_role_tag_results, $body, $titles, null, $mail_type,'',$author_details);
                    }

                }
            }
            if (count($jnl_epa_tags) > 0 && isset($email_data->jnl_id) && isset($Stage_email_templates_table)) {
                $jnl_id = $email_data->jnl_id;
                $epa_result = $Stage_email_templates_table::get_epa_user_data($jnl_epa_tags, $jnl_id);
                $body = $this->replace_email_key_with_data($epa_result, $body, $titles, null, $mail_type);
            }
            if (isset($email_data->BIORXIV_CODE) && in_array('BIORXIV_CODE', $keys)) {
                $body = str_replace("##BIORXIV_CODE##", $email_data->BIORXIV_CODE, $body);
            }

            if (isset($email_data->BIORXIV_FAILURE_REASON) && in_array('BIORXIV_FAILURE_REASON', $keys)) {
                $body = str_replace("##BIORXIV_FAILURE_REASON##", $email_data->BIORXIV_FAILURE_REASON, $body);
            }
            if (isset($email_data->ASSIGN_USER_FULL_NAME) && in_array('ASSIGN_USER_FULL_NAME', $keys)) {
                $body = str_replace("##ASSIGN_USER_FULL_NAME##", $email_data->ASSIGN_USER_FULL_NAME, $body);
            }
            if (isset($email_data->ASSIGN_USER_ROLE) && in_array('ASSIGN_USER_ROLE', $keys)) {
                $body = str_replace("##ASSIGN_USER_ROLE##", $email_data->ASSIGN_USER_ROLE, $body);
            }
            if (isset($email_data->RETIRED_ROLES) && in_array('RETIRED_ROLES', $keys)) {
                $body = str_replace("##RETIRED_ROLES##", $email_data->RETIRED_ROLES, $body);
            }
            if (isset($email_data->STAGE_IMPORT_ERRORS) && in_array('STAGE_IMPORT_ERRORS', $keys)) {
                $body = str_replace("##STAGE_IMPORT_ERRORS##", $email_data->STAGE_IMPORT_ERRORS, $body);
            }
            if (isset($email_data->REJOIN_ROLES) && in_array('REJOIN_ROLES', $keys)) {
                $body = str_replace("##REJOIN_ROLES##", $email_data->REJOIN_ROLES, $body);
            }

            if (isset($email_data->ADDED_USER_KEYWORDS) && in_array('ADDED_USER_KEYWORDS', $keys)) {
                $body = str_replace("##ADDED_USER_KEYWORDS##", $email_data->ADDED_USER_KEYWORDS, $body);
            }

            if (isset($email_data->REMOVED_USER_KEYWORDS) && in_array('REMOVED_USER_KEYWORDS', $keys)) {
                $body = str_replace("##REMOVED_USER_KEYWORDS##", $email_data->REMOVED_USER_KEYWORDS, $body);
            }

            if (isset($email_data->DESTINATION_ARTICLE_STATUS_LINK) && in_array('DESTINATION_ARTICLE_STATUS_LINK', $keys)) {
                $body = str_replace("##DESTINATION_ARTICLE_STATUS_LINK##", $email_data->DESTINATION_ARTICLE_STATUS_LINK, $body);
            }
            if (in_array('TASK_DUE_DATE', $keys)) {
                if (isset($email_data->aflw_due_date)) {
                    $body = str_ireplace("##TASK_DUE_DATE##", $email_data->aflw_due_date, $body);

                }
            }
            if (count(array_intersect($keys, $article_status_arr)) > 0) {
                if (isset($email_data->article_status_details_for_init)) {
                    $body = $this->replace_email_key_with_data($email_data->article_status_details_for_init, $body, $titles, $client_email_date_format, $mail_type, $etmp_action);
                } else if (isset($email_data->aflw_id)) {
                    $intermediate_stage = isset($email_data->intermediate_stage) ? $email_data->intermediate_stage:false;
                    $article_status = $Stage_email_templates_table::get_article_status_data($email_data->aflw_id,$client_email_date_format,$mail_type,$intermediate_stage);
                 	//Task #604 Issue in Remaining Days Calculation.(TASK #9747)
                     if(!in_array($mail_type ,['edit','preview']) && (!isset($email_data->aflw_due_date) || ($email_data->aflw_due_date ?? '') == '') && isset($article_status[0]->TASK_DUE_DATE) && $article_status[0]->TASK_DUE_DATE == "##TASK_DUE_DATE##")
                     {
                        $Articles=new \App\Models\Articles;
                        $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept,jwf_tat_complete,jwf_role_id, jwf_parent_user_roles';
                        $article_details = $Articles::get_article_details($select,"aflw_id={$email_data->aflw_id}");
                        $article_details = $article_details[0];
                        $article_id = $article_details->art_id;
                        $article_details->TASK_DUE_DATE= $this->get_due_date_for_article($article_id, $article_details->jwf_tat_complete,$client_email_date_format);
                        $remaining_days = Carbon::now()->diffInDays(Carbon::createFromFormat($client_email_date_format,$article_details->TASK_DUE_DATE), false);                    
                        $article_status[0]->TASK_DUE_DATE= $article_details->TASK_DUE_DATE;
                        $article_status[0]->TASK_REMAINING_DAYS = $remaining_days > 0 ?  $remaining_days : 0;     
                    }        
                    else{
                        if(isset($article_status[0]->TASK_DUE_DATE) &&isset($article_status[0]->TASK_REMAINING_DAYS) && $article_status[0]->TASK_REMAINING_DAYS == "##TASK_REMAINING_DAYS##")
                       { 
                        $remaining_days = Carbon::now()->diffInDays(Carbon::createFromFormat($client_email_date_format,$article_status[0]->TASK_DUE_DATE), false);                    
                        $article_status[0]->TASK_REMAINING_DAYS = $remaining_days > 0 ?  $remaining_days : 0;
                       }
                    }
                    $body = $this->replace_email_key_with_data($article_status, $body, $titles, null, $mail_type, $etmp_action);
                  

                }
            }
            
            $journal_table = new \App\Models\Journals();
            $Client_settings_table = new \App\Models\Client_settings();
            if (in_array('SENDING_JOURNAL', $keys)) {
                if (isset($email_data->src_jnl_id)) {
                    $src_jnl_detail = $journal_table::get_single_record('jnl_journal_name', "jnl_id ={$email_data->src_jnl_id}");
                    $body = str_ireplace("##SENDING_JOURNAL##", $src_jnl_detail->jnl_journal_name, $body);
                }
            }
            if (in_array('CURRENT_DATE', $keys)) {

                if (isset($email_data->current_date_for_tag)) {
                    $current_date = $email_data->current_date_for_tag;
                } else {
                    $this->client_details_date = $Client_settings_table::get_single_record('cs_date_format', "cs_client_id =1");
                    if (isset($this->client_details_date->cs_date_format)) {
                        $current_date = date($this->client_details_date->cs_date_format, strtotime(date('d-m-Y')));
                    } else {
                        $current_date = date('d-m-Y');
                    }

                }
                if (!empty($client_email_date_format) && !empty($current_date)) {
                    $current_date = date($client_email_date_format, strtotime(date('d-m-Y')));
                }
                $body = str_ireplace("##CURRENT_DATE##", $current_date, $body);
            }
            if (in_array('CURRENT_TIME', $keys)) {
                $current_time = date('h:i:sa');
                $body = str_ireplace("##CURRENT_TIME##", $current_time, $body);
            }
            if (in_array('SITE_URL', $keys)) {
                if (isset($email_data->SITE_URL) && !empty($email_data->SITE_URL)) {
                    $site_url = $email_data->SITE_URL;
                } else {
                    $site_url=URL::to('/');
                }
                if ($mail_type == 'preview') {
                    $body = str_ireplace("##SITE_URL##", '<a class="linkable">' . $site_url . '</a>', $body);
                } else {
                    $body = str_ireplace("##SITE_URL##", '<a href="' . $site_url . '">' . $site_url . '</a>', $body);
                }
            }
            if (in_array('ARTICLE_STATUS_LINK', $keys)) {


                if (isset($email_data->ARTICLE_STATUS_LINK)) {
                    if (isset($email_data->more_reviewer_updated) && ($email_data->more_reviewer_updated) == true) {
                        if (isset($email_templates['links'])) {
                            unset($email_templates['links']['ARTICLE_STATUS_LINK']);
                        }

                    } else {
                        $body = str_ireplace("##ARTICLE_STATUS_LINK##", '<a href="' . $email_data->ARTICLE_STATUS_LINK . '">' . customTrans('client_lang.view_article_link') . '</a>', $body);
                    }

                } elseif (isset($email_data->jnl_journal_code) && isset($email_data->article_id)) {
                    $status_id = '';
                    $logout_msg = '';

                    if (isset($email_data->aflw_id)) {
                        $status_id = '&status_id=' . $email_data->aflw_id;
                    }

                    $article_id = $email_data->article_id;
                    if (isset($email_data->stage_staff_check) && $email_data->stage_staff_check == true) {
                        $logout_msg = '&logout_msg=show';
                    }
                    $jnl_journal_code = $email_data->jnl_journal_code;
                    $url_segmnt = 'view-article';
                    /*  TASK #3755 flow_id of submission stage should be passed for author mail  */
                    if (isset($email_data->user_id) && !empty($email_data->user_id) && isset($email_data->article_id) && !empty($email_data->article_id)){
                            $auth_chk_cond="auth_usr_id=:user_id AND auth_art_id=:auth_art_id";
                            $chk_arr=array('user_id'=>$email_data->user_id,
                                            'auth_art_id'=>$email_data->article_id
                            );
                            $Authors = new \App\Models\Authors();
                            $chk_author = $Authors::get_single_record('count(auth_id) as count', $auth_chk_cond,NULL,'',NULL,$chk_arr);
                        if(isset($chk_author)){
                                $is_author = (isset($chk_author->count) && $chk_author->count > 0) ? TRUE : FALSE;
                                if($is_author == TRUE){
                                    $url_segmnt = 'author-article';
                                }
                        }
                    }
                /* end TASK #3755 flow_id of submission stage should be passed for author mail  */

                   $article_url = URL::to('/').'/'. $this->current_client->platform_type.'/'. $jnl_journal_code . '/' . $url_segmnt . '?' . encrypt_link('&article_id=' . $article_id . $status_id . $logout_msg);

                if ($mail_type == 'preview') {
                        $body = str_ireplace("##ARTICLE_STATUS_LINK##", '<a class="linkable">' . customTrans('client_lang.view_article_link') . '</a>', $body);
                    } elseif ($mail_type != 'edit') {
                        $body = str_ireplace("##ARTICLE_STATUS_LINK##", '<a href="' . $article_url . '">' . customTrans('client_lang.view_article_link') . '</a>', $body);
                    }
                }
            }
            if (in_array('ARTICLE_STATUS_LINK_BLIND', $keys) && $mail_type == 'preview') {
                $body = str_ireplace("##ARTICLE_STATUS_LINK_BLIND##", '<a class="linkable">' . customTrans('client_lang.view_article_link') . '</a>', $body);
            }
            elseif(in_array('ARTICLE_STATUS_LINK_BLIND', $keys) && $mail_type != 'edit' && isset($email_data->jnl_journal_code) && isset($email_data->article_id)&& isset($email_data->user_id) && isset($email_data->aflw_id)){
                $status_id = '&status_id=' . $email_data->aflw_id;
                $article_id = '&article_id=' . $email_data->article_id;
                $rcv_usr_id = '&usr_id=' . $email_data->user_id;
                $deeplink_token = '&key=' . Str::random(16);
                $jnl_code = '&jnl_code=' . $email_data->jnl_journal_code;

                $Articles = new \App\Models\Articles;
                $Roles = new \App\Models\Roles();
                $core_role_details ='';
                $type='';
                $crid='';
                if (isset($email_data->aflw_id)) {
                $condition = "aflw_id={$email_data->aflw_id}";
                $flowdetails = $Articles::get_article_details("jwf_role_id", $condition);
                $core_role_details  =   $Roles::get_single_record('role_assigned_role',"role_id={$flowdetails[0]->jwf_role_id}");
                $type = '&rid=' . $flowdetails[0]->jwf_role_id;
		        $crid = '&type=' . $core_role_details->role_assigned_role;
                //Task #3029 After article submission, the cp team member should able to change the submitting author
                $eslAction = isset($email_data->esl_etmp_action) ? $email_data->esl_etmp_action : null;
                if ($eslAction == 'change_submitting_new_author') {

                    $Article_flow = (new \App\Models\Article_flow())->getTable();
                    $Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                    $Roles = (new \App\Models\Roles())->getTable();
                    $tables = [
                                'main_table' => $Article_flow,
                                'join_table' => [
                                    $Generic_flow_table => ["$Article_flow.aflw_jwf_id", "$Generic_flow_table.jwf_id"],
                                    $Roles => ["$Generic_flow_table.jwf_role_id", "$Roles.role_id"]
                                ]
                            ];

                    $select = "aflw_id,jwf_role_id,role_assigned_role";
                    $articleId = $email_data->article_id ?? null;
                    $criteria = [];
                    if ($articleId) {
                    $criteria = [
                               "$Article_flow.aflw_art_id" => $articleId,
                                "$Roles.role_assigned_role" => 'author'
                                ];
                            }
                     $latestAuthorflw =Article_flow::get_results_using_joins($tables,$select, $criteria,'single',"aflw_id DESC",1);

                    if ($latestAuthorflw) {
                    $latestAflwId = $latestAuthorflw->aflw_id;
                    $roleId       = $latestAuthorflw->jwf_role_id;
                    $assignedRole = $latestAuthorflw->role_assigned_role;
                    if ($assignedRole === 'author') {
                    $status_id = '&status_id=' . $latestAflwId;
                    $type      = '&rid=' . $roleId;
                    $crid      = '&type=' . $assignedRole;
                    }
                   }

                }elseif($eslAction == 'change_submitting_old_author')
                {
                   $body = str_ireplace("##ARTICLE_STATUS_LINK_BLIND##", '', $body); 
                }
                //END Task #3029 After article submission, the cp team member should able to change the submitting author
            }

                $article_url = URL::to('/').'/'. $this->current_client->platform_type.'/'. $email_data->jnl_journal_code . '/view-article-status?' . encrypt_link($rcv_usr_id . $jnl_code . $article_id . $status_id . $deeplink_token . $type . $crid);
                $body = str_ireplace("##ARTICLE_STATUS_LINK_BLIND##", '<a href="' . $article_url . '">' . customTrans('client_lang.view_article_link') . '</a>', $body);
            }

            if(strpos($body, '##BULK_INVITATION_SUBMISSION##') !== false && isset($email_data->jnl_journal_code) && isset($email_data->artp_code)){
                $url = URL::to('/').'/'. $this->current_client->platform_type.'/'. $email_data->jnl_journal_code. '/'. $email_data->artp_code . '/create-article';
                $site_url       =   "<a href='$url'>click here</a>";
                $body      =   str_ireplace("##BULK_INVITATION_SUBMISSION##", $site_url, $body);
            }

            if (in_array('ARTICLE_STUB_SUBMISSION_LINK', $keys)) {
                if (isset($email_data->jnl_journal_code) && isset($email_data->article_id)) {
                    $article_id = $email_data->article_id;
                    $jnl_journal_code = $email_data->jnl_journal_code;
                    if (isset($email_data->ARTICLE_STATUS_LINK)) {
                        $article_url = $email_data->ARTICLE_STATUS_LINK;
                    }

                    if ($mail_type == 'preview') {
                        $body = str_ireplace("##ARTICLE_STUB_SUBMISSION_LINK##", '<a class="linkable">' . customTrans('client_lang.view_article_link') . '</a>', $body);
                    } elseif ($mail_type != 'edit') {
                        $body = str_ireplace("##ARTICLE_STUB_SUBMISSION_LINK##", '<a href="' . $article_url . '">' . customTrans('client_lang.view_article_link') . '</a>', $body);
                    }
                }
            }
            /*TASK #6401 Create a new tag for informing Reviewers about the final decision*/
            if (in_array('DECISION_STATUS', $keys) && !in_array($mail_type, ['edit', 'preview'])) {
                if(isset($email_data->aflw_id) && isset($email_data->article_id )&& $mail_type != 'preview'){
                    $Articles = new \App\Models\Articles;
                    $articles_table=(new \App\Models\Articles())->getTable();
                    $article_flow_table = (new \App\Models\Article_flow)->getTable();
                    $Article_flow = new \App\Models\Article_flow();
                    $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                    $tables = array(
                        'main_table' =>   $article_flow_table,
                        'join_table' => array( $generic_flow_table => array($article_flow_table . '.aflw_jwf_id', $generic_flow_table . '.jwf_id'))
                    );
                    $select = 'jwf_stage_type,jwf_id,jwf_role_id,jwf_stage_name';
                    $condition = "aflw_id=? AND aflw_art_id=?";
                    $binding_arr = array( $email_data->aflw_id,$email_data->article_id);
                    $current_stage_type=$Article_flow::get_results_using_joins($tables, $select, $condition, 'single', NULL, NULL,'',NULL,NULL,FALSE,NULL,FALSE,$binding_arr);
                    $art_decision_status = $Articles::get_single_record_with_bind_cond('art_status',['art_id'=>$email_data->article_id]);
                        if(isset($art_decision_status) && isset($current_stage_type->jwf_stage_type)){
                            if(in_array($current_stage_type->jwf_stage_type, array('reject', 'accept', 'resubmission'))){
                                if($art_decision_status->art_status=='a' && $current_stage_type->jwf_stage_type =='accept'){
                                    $body = str_ireplace("##DECISION_STATUS##", $current_stage_type->jwf_stage_name, $body);
                                }
                                elseif($art_decision_status->art_status=='r' && $current_stage_type->jwf_stage_type =='reject'){
                                    $body = str_ireplace("##DECISION_STATUS##", $current_stage_type->jwf_stage_name, $body);
                                }elseif($current_stage_type->jwf_stage_type =='resubmission'){
                                    $role_name_confirm= Roles::where('role_id', $current_stage_type->jwf_role_id)->value('role_assigned_role');
                                    if (isset($current_stage_type->jwf_stage_type) && $current_stage_type->jwf_stage_type =='resubmission' && isset($role_name_confirm) && $role_name_confirm == 'author') {
                                        $body = str_ireplace("##DECISION_STATUS##", $current_stage_type->jwf_stage_name, $body);
                                    } else {
                                        $body = str_ireplace("##DECISION_STATUS##", '', $body);
                                    }
                                }else{
                                    $body = str_ireplace("##DECISION_STATUS##", '', $body);
                                }
                            }
                        }
                }
            }
            /* end TASK #6401 Create a new tag for informing Reviewers about the final decision */
            if (in_array('RESET_PASSWORD_LINK', $keys)) {
                if (isset($email_data->RESET_PASSWORD_LINK)) {
                    $body = str_ireplace("##RESET_PASSWORD_LINK##", '<a  style="box-sizing: border-box;position: relative; -webkit-text-size-adjust: none; border-radius: 4px; color: #fff; display: inline-block; overflow: hidden; text-decoration: none; background-color: #007bff; border-bottom: 8px solid #007bff; border-left: 18px solid #007bff; border-right: 18px solid #007bff; border-top: 8px solid #007bff; top: 10px;" href="' . $email_data->RESET_PASSWORD_LINK . '">Click here to Reset Password</a>', $body);
                } else {
                    $body = str_ireplace("##RESET_PASSWORD_LINK##", '', $body);
                }
            }
            if (in_array('EDITOR_COMMENTS', $keys)) {
                if (isset($email_data->EDITOR_COMMENTS)) {
                    $body = str_ireplace("##EDITOR_COMMENTS##", $email_data->EDITOR_COMMENTS, $body);
                } else {
                    $body = str_ireplace("##EDITOR_COMMENTS##", '', $body);
                }
            }
            if (in_array('SET_PASSWORD_LINK', $keys)) {
                if (isset($email_data->SET_PASSWORD_LINK)) {
                    $body = str_ireplace("##SET_PASSWORD_LINK##", '<a style="box-sizing: border-box;position: relative; -webkit-text-size-adjust: none; border-radius: 4px; color: #fff; display: inline-block; overflow: hidden; text-decoration: none; background-color: #007bff; border-bottom: 8px solid #007bff; border-left: 18px solid #007bff; border-right: 18px solid #007bff; border-top: 8px solid #007bff; top: 10px;" href="' . $email_data->SET_PASSWORD_LINK . '">Set new password</a>', $body);
                } else {
                    $body = str_ireplace("##SET_PASSWORD_LINK##", '', $body);
                }
            }
            if (in_array('CONFIRMATION_URL', $keys) && !isset($email_data->resend_usr_confirmation)) {

                if (isset($email_data->CONFIRMATION_URL) && !empty($email_data->CONFIRMATION_URL)) {
                    $body = str_ireplace("##CONFIRMATION_URL##", '<a  style="box-sizing: border-box;position: relative; -webkit-text-size-adjust: none; border-radius: 4px; color: #fff; display: inline-block; top: 10px; overflow: hidden; text-decoration: none; background-color: #007bff; border-bottom: 8px solid #007bff; border-left: 18px solid #007bff; border-right: 18px solid #007bff; border-top: 8px solid #007bff;" id="confirmation_url_tag" href="' . $email_data->CONFIRMATION_URL . '">Click here to confirm</a>', $body); //TASK #5895 Position of confirmation button issue.
                }
            }
            if (in_array('REVERT_EMAIL', $keys)) {
                if (isset($email_data->REVERT_EMAIL) && !empty($email_data->REVERT_EMAIL)) {
                    $body = str_ireplace("##REVERT_EMAIL##", '<a id="revert_url_tag_reinvite" style="box-sizing: border-box;position: relative; -webkit-text-size-adjust: none; border-radius: 4px; color: #fff; display: inline-block; overflow: hidden; text-decoration: none; background-color: #007bff; border-bottom: 8px solid #007bff; border-left: 18px solid #007bff; border-right: 18px solid #007bff; border-top: 8px solid #007bff;" href="' . $email_data->REVERT_EMAIL . '"><span style="background-color:#3c8dbc;padding:8px;border-radius:4px;color:#ebebeb;cursor:pointer;font-wight:bold;border:none;">Revert</span></a>', $body);
                }
            }
            if (in_array('VERIFY_EMAIL', $keys)) {
                if (isset($email_data->VERIFY_EMAIL) && !empty($email_data->VERIFY_EMAIL)) {
                    $body = str_ireplace("##VERIFY_EMAIL##", '<a id="verifyemail" style="box-sizing: border-box;position: relative; -webkit-text-size-adjust: none; border-radius: 4px; color: #fff; display: inline-block; overflow: hidden; text-decoration: none; background-color: #007bff; border-bottom: 8px solid #007bff; border-left: 18px solid #007bff; border-right: 18px solid #007bff; border-top: 8px solid #007bff;" href="' . $email_data->VERIFY_EMAIL . '"><span style="background-color:#3c8dbc;padding:8px;border-radius:4px;color:#ebebeb;cursor:pointer;font-wight:bold;border:none;">Verify</span></a>', $body);
                }
            }
            if (in_array('ALTERNATIVE_EMAIL_CONFIRMATION', $keys)) {
                if (isset($email_data->ALTERNATIVE_EMAIL_CONFIRMATION) && !empty($email_data->ALTERNATIVE_EMAIL_CONFIRMATION)) {
                    $body = str_ireplace("##ALTERNATIVE_EMAIL_CONFIRMATION##", $email_data->ALTERNATIVE_EMAIL_CONFIRMATION, $body);
                }
            }
			if (in_array('DIRECT_ACCEPT', $keys)) {
				if (isset($email_data->DIRECT_ACCEPT)) {
					$body = str_ireplace("##DIRECT_ACCEPT##", '<a id="direct_accept_tag_reinvite" href="' . $email_data->DIRECT_ACCEPT . '">' .((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept') . '</a>', $body);
				}
			}
			if (in_array('DIRECT_REJECT', $keys)) {
				if (isset($email_data->DIRECT_REJECT)) {
					$body = str_ireplace("##DIRECT_REJECT##", '<a id="direct_reject_tag_reinvite" href="' . $email_data->DIRECT_REJECT . '" >'.((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject').'</a>', $body);
				}
			}
			if (in_array('AUTHOR_DIRECT_ACCEPT', $keys)) {
				if (isset($email_data->AUTHOR_DIRECT_ACCEPT)) {
					$body = str_ireplace("##AUTHOR_DIRECT_ACCEPT##", '<a id="direct_accept_tag_reinvite" href="' . $email_data->AUTHOR_DIRECT_ACCEPT . '">' . ((customTrans('client_lang.accept_link_text') != '') ? customTrans('client_lang.accept_link_text') : 'Accept') . '</a>', $body);
				}
			}
			if (in_array('AUTHOR_DIRECT_REJECT', $keys)) {
				if (isset($email_data->AUTHOR_DIRECT_REJECT)) {
					$body = str_ireplace("##AUTHOR_DIRECT_REJECT##", '<a id="direct_reject_tag_reinvite" href="' . $email_data->AUTHOR_DIRECT_REJECT . '" >'.((customTrans('client_lang.reject_link_text') != '') ? customTrans('client_lang.reject_link_text') : 'Reject').'</a>', $body);
				}
            }
            if (in_array('PASSWORD', $keys)) {
                if (isset($email_data->PASSWORD)) {
                    $body = str_ireplace("##PASSWORD##", $email_data->PASSWORD, $body);
                } else {
                    $body = str_ireplace("##PASSWORD##", '', $body);
                }

            }
            // TASK #9425 Convey Integration In Review3
            if (in_array('CONVEY_LINK_TO_DISCLOSE', $keys)&& ($mail_type != 'edit')) {
                if (isset($email_data->CONVEY_LINK_TO_DISCLOSE )) {
                    $body = str_ireplace("##CONVEY_LINK_TO_DISCLOSE##", '<a href="' .  $email_data->CONVEY_LINK_TO_DISCLOSE . '">' .customTrans('client_lang.view_discolse_link'). '</a>', $body);
                } else {
                    $body = str_ireplace("##CONVEY_LINK_TO_DISCLOSE##", '', $body);
                }

            }
            if (in_array('ARTICLE_AUTHOR_LIST_CHANGE', $keys)) {
                if (isset($email_data->ARTICLE_AUTHOR_LIST_CHANGE)) {
                    $body = str_ireplace("##ARTICLE_AUTHOR_LIST_CHANGE##", $email_data->ARTICLE_AUTHOR_LIST_CHANGE, $body);
                } else {
                    $body = str_ireplace("##ARTICLE_AUTHOR_LIST_CHANGE##", '', $body);
                }
            }

            if (in_array('TASK_ASSIGNED_DATE', $keys)) {
                if (isset($email_data->aflw_accepted_date)) {
                    $body = str_ireplace("##TASK_ASSIGNED_DATE##", $email_data->aflw_accepted_date, $body);
                }
            }
            if (in_array('REVIEW_ACCEPT_DATE', $keys)) {
                if (isset($email_data->aflw_accepted_date)) {
                    $body = str_ireplace("##REVIEW_ACCEPT_DATE##", $email_data->aflw_accepted_date, $body);
                }
            }
            if (in_array('PRECEDING_DUE_DATE', $keys)) {
                if (isset($email_data->PRECEDING_DUE_DATE)) {
                    $body = str_ireplace("##PRECEDING_DUE_DATE##", $email_data->PRECEDING_DUE_DATE, $body);
                }
            }
            if (isset($email_data->WITHDRAW_REASON) && in_array('WITHDRAW_REASON', $keys)) {
                if (isset($email_data->WITHDRAW_REASON)) {
                    $body = str_ireplace("##WITHDRAW_REASON##", $email_data->WITHDRAW_REASON, $body);
                }
            }
            if (isset($email_data->prevent_edit_reason) && in_array('ARTICLE_AUTHOR_ACCESS_REQUEST_REASON', $keys)) {
                $body = str_ireplace("##ARTICLE_AUTHOR_ACCESS_REQUEST_REASON##", $email_data->prevent_edit_reason, $body);
            }
            if (isset($email_data->prevent_edit_decline_access_reason) && in_array('ARTICLE_AUTHOR_ACCESS_APPROVE/REJECT_REASON', $keys)) {
                $body = str_ireplace("##ARTICLE_AUTHOR_ACCESS_APPROVE/REJECT_REASON##", $email_data->prevent_edit_decline_access_reason, $body);
            }
            if (isset($email_data->CURRENT_USER_UNREGISTER_REASON) && in_array('CURRENT_USER_UNREGISTER_REASON', $keys)) {
                if (isset($email_data->CURRENT_USER_UNREGISTER_REASON)) {
                    $body = str_ireplace("##CURRENT_USER_UNREGISTER_REASON##", $email_data->CURRENT_USER_UNREGISTER_REASON, $body);
                }
            }
            if (isset($email_data->REOPEN_REASON) && in_array('REOPEN_REASON', $keys)) {
                if (isset($email_data->REOPEN_REASON)) {
                    $body = str_ireplace("##REOPEN_REASON##", $email_data->REOPEN_REASON, $body);
                }
            }
            if (isset($email_data->MORE_REVIEW_REASON) && in_array('MORE_REVIEW_REASON', $keys)) {
                if (isset($email_data->MORE_REVIEW_REASON)) {
                    $body = str_ireplace("##MORE_REVIEW_REASON##", $email_data->MORE_REVIEW_REASON, $body);
                }
            }
            if (isset($email_data->REASON_FOR_REJECT) && in_array('REASON_FOR_REJECT', $keys)) {
                if (isset($email_data->REASON_FOR_REJECT)) {
                    $body = str_ireplace("##REASON_FOR_REJECT##", $email_data->REASON_FOR_REJECT, $body);
                }
            }
            $article_pdf_table = new \App\Models\Article_pdf();
            if (in_array('REOPENED_REVIEW_STAGE_NAME', $keys) && isset($email_data->REOPENED_REVIEW_STAGE_NAME)) {
                $body = str_ireplace("##REOPENED_REVIEW_STAGE_NAME##", $email_data->REOPENED_REVIEW_STAGE_NAME, $body);
            }
            /*Task #1787 Due date in settings page */
            if (in_array('ARTICLE_CREATION_DUE_DATE', $keys) && !in_array($mail_type, ['edit', 'preview'])) {
                $jnl_id = $email_data->jnl_id;
                $art_creation_due_date = Journal_settings::get_single_record_with_bind_cond('jset_conf_duedate,jset_date_format',array('jset_jnl_id'=>$jnl_id));
                if(isset($art_creation_due_date->jset_conf_duedate) && !empty($art_creation_due_date->jset_conf_duedate)){
                $date_format= $art_creation_due_date->jset_date_format;
                $date = new DateTime($art_creation_due_date->jset_conf_duedate);
                $formatted_date = $date->format($date_format);
                $body = str_ireplace("##ARTICLE_CREATION_DUE_DATE##", $formatted_date, $body);
                }else{
                $body = str_ireplace("##ARTICLE_CREATION_DUE_DATE##", '', $body);
                }        
            }
            /*end Task #1787 Due date in settings page */

            if (in_array('PLAGIARISM_REPORT_LINK', $keys) || in_array('PERCENT_MATCH', $keys)) {
                $replace_string = '';
                $percent_match = '';
                if (isset($email_data->jnl_journal_code) && isset($email_data->article_id) && isset($email_data->jnl_id) && isset($email_data->artp_id)) {
                    $article_id = $email_data->article_id;
                    $jnl_journal_code = $email_data->jnl_journal_code;
                    $result = $article_pdf_table::get_all_records('pdf_id, pdf_ith_document_id, pdf_ith_similarity_percentage, pdf_word_count', "pdf_art_id = {$email_data->article_id}");
                    if ($result) {
                        $result = end($result);
                        if ($result->pdf_ith_document_id != 0 && $result->pdf_word_count != 0) {
                            if (in_array('PLAGIARISM_REPORT_LINK', $keys)) {
                                $url='';
                                $replace_string = '<a href="' . $url . '">Click here to view similarity report</a>';
                            }
                            if (in_array('PERCENT_MATCH', $keys)) {
                                $percent_match = $result->pdf_ith_similarity_percentage;
                            }

                        }
                    }
                }
                if (in_array('PLAGIARISM_REPORT_LINK', $keys) && ($mail_type != 'edit')) {
                    $body = str_ireplace('##PLAGIARISM_REPORT_LINK##', $replace_string, $body);
                }

                if (in_array('PERCENT_MATCH', $keys) && ($mail_type != 'edit')) {
                    $body = str_ireplace('##PERCENT_MATCH##', $percent_match, $body);
                }

            }

            if (isset($email_data->jnl_journal_code) && in_array('JOURNAL_URL', $keys)) {
                // change base url
                $journal_url =  URL::to('/').'/'. $this->current_client->platform_type.'/'. $email_data->jnl_journal_code ;
                if ($mail_type == 'preview') {
                    $body = str_ireplace("##JOURNAL_URL##", '<a class="linkable">' . $journal_url . '</a>', $body);
                } else {
                    $body = str_ireplace("##JOURNAL_URL##", '<a  href="' . $journal_url . '" >' . $journal_url . '</a>', $body);
                }
            }

            if (isset($email_data->jnl_id) && in_array('JOURNAL_NAME', $keys)) {
                // change journal name tag
                $jnl_name = $journal_table::get_single_record('jnl_journal_name', "jnl_id ={$email_data->jnl_id}");
                $body = str_ireplace("##JOURNAL_NAME##", $jnl_name->jnl_journal_name, $body);
            }

            if (!empty($exclude_bmj_excp_art_tags)) {
                foreach ($exclude_bmj_excp_art_tags as $exp_tags) {
                    if (in_array($exp_tags, $keys)) {
                        $body = str_ireplace("##" . $exp_tags . "##", $email_data->bmj_exceptional[$exp_tags], $body);
                    }

                }
            }
            $email_tags = $email_templates;
            unset($email_tags['recipient_tags']);
            unset($email_tags['links']['ARTICLE_STATUS_LINK_BLIND']);

            if (isset($email_data->resend_usr_confirmation) && $email_data->resend_usr_confirmation == true) {
                unset($email_tags['links']['CONFIRMATION_URL']);
            }
            if (isset($email_data->replace_email_link_tags) && $email_data->replace_email_link_tags == true) {
                unset($email_tags['links']['CONFIRMATION_URL']);
                unset($email_tags['links']['DIRECT_ACCEPT']);
                unset($email_tags['links']['DIRECT_REJECT']);
            }

            if ($replace_all_tags == true) {
                $body = $this->clean_unreplaced_email_tags($body, $email_tags, $mail_type, $exclude_keys_for_edit,$exclude_keys_for_preview); // TASK 6401 preview button for decision
            }
            
            $body = preg_replace('/,+/', ',', $body);
            return $body;
        }

    }

    private function clean_unreplaced_email_tags($body, $email_tags, $mail_type = '', $exclude_keys_for_edit='',$exclude_keys_for_preview='') // TASK 6401 preview button for decision
    {
        preg_match_all('/##([^##]*)##/', $body, $matches);
        $all_tags = array();
        foreach ($email_tags as $tag_keys) {
            foreach ($tag_keys as $keys => $value) {
                $all_tags[] = "##" . $keys . "##";
            }
        }
        $all_tags[] = "##PASSWORD##";
        $role_tags = array('FULLNAME EMAILS', 'FULLNAME', 'FULLNAME ADDRESS', 'DEPARTMENT', 'AFFILIATION', 'PHONE', 'FIRSTNAME', 'INSTITUTION', 'STATE', 'POSTALCODE', 'COUNTRY', 'CITY', 'TITLE', 'FULLNAME TITLE');
        $role_table = new \App\Models\Roles();

        if (isset($role_table)) {
            $user_roles = $role_table::get_all_records('role_name', 'role_assigned_role NOT IN("author","system")');
            foreach ($user_roles as $usr) {
                foreach ($role_tags as $role_key) {
                    $all_tags[] = '##ROLE_' . strtoupper($usr->role_name) . '_' . $role_key . '##';
                }
            }
        }
        $Custom_email_template_tags_table = new \App\Models\Custom_email_template_tags();
        if (isset($Custom_email_template_tags_table)) {
            $variable_tags = $Custom_email_template_tags_table::get_all_records('cettag_name');
            foreach ($variable_tags as $vble_tags) {
                $all_tags[] = '##' . $vble_tags->cettag_name . '##';
            }
        }
        $Generic_form_elements_table = new \App\Models\Generic_form_elements();
        if (isset($Generic_form_elements_table)) {
            $gneric_tags = $Generic_form_elements_table::get_all_form_elements('emt_unique_identifier', 'gncf_jnl_id IS NULL AND emt_unique_identifier IS NOT NULL');
            foreach ($gneric_tags as $gneric) {
                $all_tags[] = '##' . $gneric->emt_unique_identifier . '##';
            }

        }
        $body=preg_replace("/<span[^>]*>/","",$body);
        $body=preg_replace("/<\/span>/","",$body);
        preg_match_all('/##([^##]*{([^}]*)})##/', $body, $genric_form_tags);

        if (!empty($genric_form_tags[0])) {
            $all_tags = array_merge($all_tags, $genric_form_tags[0]);
        }

        if ($mail_type == 'edit') {
            $temp_tags = array_diff($all_tags, $exclude_keys_for_edit);
            $new_all_tags = array_values($temp_tags);
        /* TASK 6401 preview button for decision */
        } else {
            if (isset($exclude_keys_for_preview) && !empty($exclude_keys_for_preview)) {
                $temp_tags = array_diff($all_tags, $exclude_keys_for_preview);
                $new_all_tags = array_values($temp_tags);
            } else {
                $new_all_tags = $all_tags;
            }
        }
          /* end TASK 6401 preview button for decision */

        $body = str_ireplace($new_all_tags, '', $body);
        return $body;
    }
    public function get_unique_data($data_array, $show_name = false, $unique_hide_control_label_email = 'n')
    {
        $return_array = $name_array = array();
        $unique_array = $sub_date_array = array();
        if (!empty($data_array)) {

            foreach ($data_array as $key => $data) {
                $return_array[$data->gdata_unique_identifier]['label'] = $data->gdata_label;
                $return_array[$data->gdata_unique_identifier]['element_type'] = $data->gdata_element_type;
                $return_array[$data->gdata_unique_identifier]['gdata'] = $data->gdata_data;
                $return_array[$data->gdata_unique_identifier]['id'] = $data->gdata_id;
                $rcnt = (isset($name_array[$data->gdata_unique_identifier])) ? count($name_array[$data->gdata_unique_identifier]) + 1 : 1;
                $name_array[$data->gdata_unique_identifier][] = ($show_name) ? $data->posted_user : $data->user_role . ' ' . $rcnt;
                $unique_array[$data->gdata_unique_identifier][] = $data->gdata_display_data;
                $sub_date_array[$data->gdata_unique_identifier][] = $data->gdata_posted_date;

            }
        }

        if (!empty($return_array)) {
            foreach ($return_array as $rk => $rv) {
                $cnt = 1;
                $content = '';
                if ($unique_hide_control_label_email == 'n') {
                    $content = '<b>' . $rv['label'] . '</b> <br>';
                }

                if (!empty($unique_array[$rk])) {
                    if (count($unique_array[$rk]) > 1) {
                        foreach ($unique_array[$rk] as $uk => $uni) {
                            $content .= '<b>#' . $cnt . ' Submitted by: ' . $name_array[$rk][$uk] . '</b> <br>' . nl2br($uni) . '<br><br>';
                            $cnt++;
                        }
                    } else {
                        $content .= (isset($unique_array[$rk][0])) ? nl2br($unique_array[$rk][0]) : '';
                    }

                }
                $return_array[$rk]['content'] = $content;
            }
        }
        return $return_array;
    }
    public function checkemail($str) {
        return (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $str)) ? FALSE : TRUE;
  }
    public function send_email_notification($record, $email_data, $user_data = null, $column_prefix = '', $return_batch_id = false, $email_update_data = array(), $adhoc_attchment = false,$batch_id = '')
    {
        $template_to = null;
        if(isset($record->stage_etmp_to) && !empty($record->stage_etmp_to))
        {
            $template_to = $record->stage_etmp_to;
        }
        $template_cust_to = $column_prefix . 'cust_to';
        $template_cc = $column_prefix . 'cc';
        $template_ccemail = $column_prefix . 'email_cc';
        $template_bcc = $column_prefix . 'bcc';
        $template_cust_cc = $column_prefix . 'cust_cc';
        $template_cust_bcc = $column_prefix . 'cust_bcc';
        $cust_cc = $record->$template_cust_cc;
        $cust_bcc = $record->$template_cust_bcc;
        $attach_cc_mail_from_user_Email = (isset($email_data->new_email) && $email_data->new_email == true) ? false : true ;
        $ccemail_recipients_arr = array();
        $bccemail_recipients_arr = array();
        $User_emails_table = new \App\Models\User_emails();
        $Stage_email_templates_table = new \App\Models\Stage_email_templates();
        $email_send_log_table = new \App\Models\Email_send_log();
        $trigger_action = ($column_prefix == 'stage_etmp_' && !empty($record->stage_etmp_action)) ? $record->stage_etmp_action : null; //need to list only email send on complete decision in decision letter
        $core_role = (isset($email_data->core_role)) ? $email_data->core_role : '';
        $core_role_name = (isset($email_data->core_role_name)) ? $email_data->core_role_name : '';
        $mail_domain = $_ENV['DOM_EMAIL_EXTENTION']; // Task #206 , Reply mail domain extention declaration
        
        if (isset($email_data->esl_resend_email_id) && $email_data->esl_resend_email_id != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->rescind_request) && $email_data->rescind_request != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->transfer_article) && $email_data->transfer_article != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->add_potential_reviewer) && $email_data->add_potential_reviewer != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->edit_potential_reviewer) && $email_data->edit_potential_reviewer != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->assignment_change) && $email_data->assignment_change != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->coauthor_notify) && $email_data->coauthor_notify != "") {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->discussion_notify) && $email_data->discussion_notify != "") {
            $trigger_action = $email_data->esl_etmp_action;
        }else if (isset($email_data->adhoc_action) && $email_data->adhoc_action != "" && $email_data->adhoc_action == TRUE) {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->change_copyright)) {
            $trigger_action = $email_data->esl_etmp_action;
        } else if (isset($email_data->author_request_access)) {
            $trigger_action = $email_data->esl_etmp_action;
        }
        else{
            if(isset($email_data->esl_etmp_action))
           { 
            $trigger_action = $email_data->esl_etmp_action;
           }
           elseif(isset($record->etmp_name) && ($record->etmp_name=="change_assign_assignment" || $record->etmp_name=="change_assign_unassignment"))
           {
                $trigger_action = $record->etmp_name;
           }
    }
        $esl_id = '';
		// $batch_id = '';
        $Batch_id_generate_table = new \App\Models\Batch_id_generate();
        if (isset($Batch_id_generate_table)) {
            $generic_roles = array(
                'Super Admin',
                'Admin',
                'Report Operator');
            $email_log_data = array(
                'esl_article_id' => null,
                'esl_reply_to' => null,
                'esl_cc' => null,
                'esl_bcc' => null,
                'proxy_user_id' => null,
                'esl_attachments' => null,
            );
            $email_log_data["esl_read_status"] = (isset($email_data->esl_read_status) || !empty($email_data->esl_read_status)) ? $email_data->esl_read_status : NULL;
            if($batch_id == ''){
                $batch_id = $Batch_id_generate_table::insert_batch_id();
            }

            if ($batch_id !='' || $batch_id != false) {

                $email_log_data["esl_batch_id"] = $batch_id;
                if (isset($email_data->attachments) && $email_data->attachments != null) {
                    $email_log_data["esl_attachments"] = $email_data->attachments;
                }

                if (isset($record->$template_cc) && $record->$template_cc != "") {
                    $cc_arr = json_decode($record->$template_cc);

                    if (!empty($cc_arr) && $cc_arr != '') {
                        $ccemail_recipients_arr = $this->get_user_role_emails($cc_arr, $email_data);
                    }
                }
                else{
                    $cc_arr='';
                }
               
                if ($cust_cc != "") {
                    array_push($ccemail_recipients_arr, $cust_cc);
                }
                if (isset($record->$template_ccemail) && ($record->$template_ccemail != "")) {
                    $cc_arr = json_decode($record->$template_ccemail);
                    if (isset($cc_arr)) {
                        foreach ($cc_arr as $c_arr) {
                            array_push($ccemail_recipients_arr, $c_arr);
                        }
                    }
                }
                if (!empty($ccemail_recipients_arr)) {
                    foreach ($ccemail_recipients_arr as $key => $value) {
                        if ($value == '') {
                            unset($ccemail_recipients_arr[$key]);
                        }
                    }
                    $cust_cc = implode(",", $ccemail_recipients_arr);
                    $cust_cc = trim($cust_cc);
                    $cust_cc = str_replace(' ', '', $cust_cc);
                }
                if (isset($record->$template_bcc) && $record->$template_bcc != "") {
                    $bcc_arr = json_decode($record->$template_bcc);

                    if (!empty($bcc_arr) && $bcc_arr != '') {
                        $bccemail_recipients_arr = $this->get_user_role_emails($bcc_arr, $email_data);
                    }
                }
                else{
                    $bcc_arr='';
                }
                if ($cust_bcc != "") {
                    array_push($bccemail_recipients_arr, $cust_bcc);
                }

                if (!empty($bccemail_recipients_arr)) {
                    foreach ($bccemail_recipients_arr as $key => $value) {
                        if ($value == '') {
                            unset($bccemail_recipients_arr[$key]);
                        }
                    }
                    $cust_bcc = implode(",", $bccemail_recipients_arr);
                    $cust_bcc = trim($cust_bcc);
                    $cust_bcc = str_replace(' ', '', $cust_bcc);
                }
                $to = '';
                $to_array = array();
                $mail_recipient_ids = array();
                if($record->$template_cust_to == "") {
                if (isset($email_data->user_email) && $email_data->user_email != '') {
                    $to_array = explode(',', $email_data->user_email);
                    $to = $email_data->user_email;
                    if (isset($email_data->mail_recipient_ids) && $email_data->mail_recipient_ids != '') {
                        if(is_array($email_data->mail_recipient_ids)){
                            $mail_recipient_ids = $email_data->mail_recipient_ids;
                        }else{
                            $mail_recipient_ids = explode(',', $email_data->mail_recipient_ids);
                        }
                    }

                } elseif (isset($user_data['usr_email']) && $user_data['usr_email'] != '') {
                    $to = $user_data['usr_email'];
                    array_push($to_array, $user_data['usr_email']);
                    if (isset($user_data['user_id'])) {
                        array_push($mail_recipient_ids, $user_data['user_id']);
                    }

                }
            }
                $receiver_ids = $mail_recipient_ids;
                $get_recepient_cc = true;
                $tmpl_name = $column_prefix . 'name';
                if (($column_prefix == 'etmp_' && isset($record->$tmpl_name)) && ($record->$tmpl_name == 'confirm_mail_for_ccmail' || $record->$tmpl_name == 'confirm_mail')) {
                    $get_recepient_cc = false;
                }
                if ($record->$template_cust_to != "") { //custom to
                    $to = explode(',', $record->$template_cust_to);
                    // $to_array = array();
                     $mail_recipient_ids = array();
                     $to_array = array_merge($to_array, $to);
                     if(count($to_array) > 0){
                         foreach($to_array as $email){
                             $mail_recipient_ids[] = User::get_user_id_by_email($email) ?? 0;
                         }
                     }
                }
                if (isset($email_data->article_id) && $email_data->article_id != '') {
                    $email_log_data['esl_article_id'] = is_array($email_data->article_id) ? json_encode($email_data->article_id) : $email_data->article_id;
                }
                $email_log_data['esl_aflw_id'] = (isset($email_data->aflw_id) && $email_data->aflw_id != '') ?  $email_data->aflw_id : null;
                $email_config = 'clients.' . $this->current_client->clnt_client_code . '.email.email_settings';
                $config = Config::get($email_config);

                if (isset($email_data->ctfy_bounce_back_reply_to_email) && $email_data->ctfy_bounce_back_reply_to_email == 'y') {
                    $config['mailpath'] = '/usr/sbin/postfix';
                    $config['protocol'] = 'postfix';

                }
                $subject = $email_data->subject;
                $body = $email_data->body;
                if (isset($email_data->cc)) {
                    $cust_cc = $email_data->cc;
                }
                if (isset($email_data->bcc)) {
                    $cust_bcc = $email_data->bcc;
                }
                if ($cust_cc !== "") {
                    $email_log_data['esl_cc'] = $cust_cc;
                }
                if ($cust_bcc !== "") {
                    $email_log_data['esl_bcc'] = $cust_bcc;
                }
                $recipient_tags = isset($email_data->email_templates_config) ? $email_data->email_templates_config['recipient_tags'] : array();
                $recpt_tag_keys = array();
                foreach ($recipient_tags as $key => $val) {
                    $recpt_tag_keys[] = '##' . $key . '##';
                }

                $subject = str_ireplace($recpt_tag_keys, '', $subject);
                preg_match_all('/##([^##]*)##/', $subject, $matches);
                $keys = $matches[1];
                for ($i = 0; $i < count($keys); $i++) {
                    $element = $keys[$i];
                    if(!empty($element))
                    {
                    $tmpl_data = str_ireplace('##'.$element.'##', '',$subject);
                    $subject = $tmpl_data;
                    }
                }
                $subject = str_ireplace('##', '', $subject);
                $email_log_data['esl_subject'] = $subject;
                $send_content = $body;
                preg_match_all('/##([^##]*)##/', $send_content, $matches);
                $keys = $matches[1];
                if (isset($email_data->article_files_attached_ids) || isset($email_data->custom_file_ids)) {
                    $article_file_ids = (isset($email_data->article_files_attached_ids)) ? $email_data->article_files_attached_ids : array();
                    $custom_file_ids = (isset($email_data->custom_file_ids)) ? $email_data->custom_file_ids : array();
                    $email_log_data['esl_attachments'] = json_encode(array('article' => $article_file_ids, 'modified' => $custom_file_ids));
                }

                //TASK #6070 - Emails should not be sent to users who are designated as "Article blinded for." -start
                if (isset($email_data->article_id) && !empty($email_data->article_id)) {
                    if(!isset($email_data->jnl_journal_code) || empty($email_data->jnl_journal_code)){
                        $Articles = new \App\Models\Articles;
                        $email_data->jnl_journal_code = $Articles::get_art_jnl_column_val($email_data->article_id, 'jnl_journal_code');
                    }
                    $resultArray = array();
                    $resultUserArray = [];
                    $blinded_arr = array();
                    $blinded_usr_list = (new Controller)->get_blinded_users($email_data->jnl_journal_code, $email_data->article_id);
                    if (count($blinded_usr_list) > 0) {
                        foreach ($blinded_usr_list as $user) {
                            $blinded_arr[] = $user->usr_email;
                        }
                        foreach ($to_array as $key => $value) {
                            $removeValueFound = false;
                            foreach ($blinded_arr as $removeKey => $removeValue) {
                                if ($value === $removeValue) {
                                    $removeValueFound = true;
                                    break; // Exit inner loop if value found
                                }
                            }
                            if (!$removeValueFound) {
                                $resultUserArray[] = $mail_recipient_ids[$key] ?? 0;
                                $resultArray[] = $value;
                            }
                        }
                        $to_array = $resultArray;
                        $mail_recipient_ids = $resultUserArray;

                    /* Article blind for cc and bcc    */
                    if($cust_cc !="")
                    {
                       $cust_ar = explode(',',$cust_cc);
                       foreach($cust_ar as $cus_key=>$cc)
                       {
                          if(in_array($cc,$blinded_arr))
                          { 
                            unset($cust_ar[$cus_key]);
                          }
                       }
                       $cust_cc = implode(',',$cust_ar);
                       if ($cust_cc !== "") {
                        $email_log_data['esl_cc'] = $cust_cc;
                    }
                    
                    }

                    if($cust_bcc!="")
                    {
                       $cust_bcc_ar = explode(',',$cust_bcc);
                        foreach($cust_bcc_ar as $bc_key=>$bcc)
                        {
                          if(in_array($bcc,$blinded_arr))
                          { 
                            unset($cust_bcc_ar[$bc_key]);
                          }
                        }
                       $cust_bcc = implode(',',$cust_bcc_ar);
                       if ($cust_bcc !== "") {
                        $email_log_data['esl_bcc'] = $cust_bcc;
                        }
                    
                    } 
                      /* Article blind for cc and bcc    */
                    }

                    if(isset($email_data->is_forwarded) && $email_data->is_forwarded == 'y' && empty($to_array))
                    {
                      $is_blinded_user = 'blinded_user';
                      return $is_blinded_user;
                    }
                }
             
                //TASK #6070 - Emails should not be sent to users who are designated as "Article blinded for." - end
            // TASK #7387 No mail should be sent for inactive and suspended users. 
            $active_users_flag = '';
            if(isset($email_data->mail_recipient_ids) && !empty($email_data->mail_recipient_ids)){
                if(isset($receiver_ids) && !empty($receiver_ids) && isset($to_array) && !empty($to_array)){
                    $to_array = $this->filter_inactive_suspended_users($receiver_ids, $to_array);
                }
            /** Task #8549, Incorrect toast message "invalid_data" appears while sending a global manual reminder issue fix ->start */
            if (count($to_array) == 0) {
                $active_users_flag = 'no_active_user';
                return $active_users_flag;
            }
            /** Task #8549, Incorrect toast message "invalid_data" appears while sending a global manual reminder issue fix ->end */
            }
            // end TASK #7387 No mail should be sent for inactive and suspended users.
              foreach ($to_array as $email=>$key) {
              if(!$this->checkemail(trim($key))){
                $this->log_email_send_error("invalid email address " . $to_array[$email] . "'");
               //unset($to_array[$email]);
             }
            }
            if((isset($email_data->name) && ($email_data->name!='') && ($email_data->name='cron_job')) || ($record->etmp_name ?? $record->stage_etmp_name ?? null) == 'send_convey_disclosure_link'){
                $user_data= array(
                    'user_id' =>0,
                    'proxy_user_id' => 0,
                );
               $email_update_data = array(
                    'user_id' =>0,
                    'proxy_user_id' => 0,
                );;
            }    
                if (count(array_intersect($matches[0], $recpt_tag_keys)) > 0 || in_array('ARTICLE_STATUS_LINK_BLIND', $keys) || isset($email_data->body_arr)) {
                    if ($user_data != null) {
                        $user_config = array();
                        if (count(array_intersect($matches[0], $recpt_tag_keys)) > 0) {
                            for ($j = 0; $j < count($keys); $j++) {
                                foreach ($recipient_tags as $key => $val) {
                                    if ($key == $keys[$j]) {
                                        $user_config[$key] = $val;
                                    }

                                }
                            }
                        }
                        $data_list = array();
                        if (isset($user_data['proxy_user_id']) && $user_data['user_id'] != $user_data['proxy_user_id']) {
                            $email_log_data['proxy_user_id'] = $user_data['proxy_user_id'];
                        }
                       
                        for ($i = 0; $i < count($to_array); $i++) {
                            $email_log_data["esl_user_id"] = (isset($mail_recipient_ids[$i]) && $mail_recipient_ids[$i] != '') ? $mail_recipient_ids[$i] : $to_array[$i];
                            $send_content = $body;
                            $cust_cc = $email_log_data['esl_cc'];
                            if (isset($mail_recipient_ids[$i]) && $mail_recipient_ids[$i] != '') {
                                $user_id = $mail_recipient_ids[$i];
                                if ($get_recepient_cc == true && $attach_cc_mail_from_user_Email) {
                                    $receivers_cc_mails = $User_emails_table::get_single_record('GROUP_CONCAT(DISTINCT NULLIF(uml_email, "") SEPARATOR ",") as cc_mails', "uml_user_id = '{$user_id}' AND uml_cc_email='y' AND uml_status='c' AND uml_email <> '{$to_array[$i]}'");
                                    if (!empty($receivers_cc_mails->cc_mails)) {
                                        $cust_cc = (!empty($cust_cc)) ? $cust_cc . ',' . $receivers_cc_mails->cc_mails : $receivers_cc_mails->cc_mails;
                                    }

                                }
                                if (count($user_config) > 0) {
                                    if ($user_id != null) {
                                        $additional_condi = null;
                                        if (isset($email_data->artp_id) && !empty($email_data->artp_id) && isset($email_data->aflw_id) && !empty($email_data->aflw_id)) {
                                            $sql = 'SELECT role_assigned_role,jwf_role_id FROM ' . self::get_table_name('roles_table') . ' LEFT JOIN  '. self::get_table_name('generic_flows_table') .' on jwf_role_id = role_id LEFT JOIN  '. self::get_table_name('article_flow_table') .'  on aflw_jwf_id = jwf_id WHERE aflw_id = ' . $email_data->aflw_id;
                                            $current_user_role_data = Roles::get_records_by_raw_query($sql);
                                            if (isset($current_user_role_data[0]->role_assigned_role)) {
                                                $additional_condi = array(
                                                    'artp_id' => $email_data->artp_id,
                                                    'role_assigned_role' => $current_user_role_data[0]->role_assigned_role,
                                                    'current_role_id'=>$current_user_role_data[0]->jwf_role_id);
                                            }

                                        }

                                        $user_results = $Stage_email_templates_table::get_recipient_data($user_config, $user_id, $additional_condi,$core_role, $core_role_name);
                                        $titles = $this->UserConfigdata('titles')['titles'];
                                        $send_content = $this->replace_email_key_with_data($user_results, $send_content, $titles, config_name : 'user_config');
                                    }
                                }
                               if (in_array('ARTICLE_STATUS_LINK_BLIND', $keys)) {
                                    //tag avail for stage template only
                                    if (isset($email_data->jnl_journal_code) && isset($email_data->article_id) && isset($email_data->aflw_id) && ($column_prefix == 'stage_etmp_' || isset($email_data->status_link_blind_event))) {
                                        $status_id = '&status_id=' . $email_data->aflw_id;
                                        $article_id = '&article_id=' . $email_data->article_id;
                                        $rcv_usr_id = '&usr_id=' . $user_id;
                                        $deeplink_token = '&key=' . Str::random(16);
                                        $token = null;
                                            $token = Article_status_link_statistics::get_single_record('aslnks_deeplink_token',"aslnks_art_id={$email_data->article_id} AND aslnks_flw_id={$email_data->aflw_id} AND aslnks_usr_id={$user_id}");
                                        if (!empty($token)) {
                                            $deeplink_token = '&key=' . $token->aslnks_deeplink_token;
                                        }

                                        $jnl_code = '&jnl_code=' . $email_data->jnl_journal_code;
                                        $Articles = new \App\Models\Articles;
                                        $Roles = new \App\Models\Roles();
                                        $core_role_details ='';
                                        $type='';
                                        $crid ='';
                                        if (isset($email_data->aflw_id)) {
                                        $condition = "aflw_id={$email_data->aflw_id}";
                                        $flowdetails = $Articles::get_article_details("jwf_role_id", $condition);
                                        $core_role_details  =   $Roles::get_single_record('role_assigned_role',"role_id={$flowdetails[0]->jwf_role_id}");
                                        $type = '&rid=' . $flowdetails[0]->jwf_role_id;
                                        $crid = '&type=' . $core_role_details->role_assigned_role;
                                        $User_articles = new \App\Models\User_articles();
                                        $user_assigned = $User_articles::get_single_record('group_concat(usra_usr_id) as usra_usr_id', 'usra_role_id=' . $flowdetails[0]->jwf_role_id . ' AND usra_art_id=' . $email_data->article_id);
                                        if ($user_assigned->usra_usr_id ==  NULL) {
                                            $User_to_journals = new \App\Models\User_to_journals();
                                            $user_assigned = $User_to_journals::get_single_record('group_concat(usrj_usr_id) as usra_usr_id', "usrj_artp_id={$email_data->artp_id} AND usrj_role_id={$flowdetails[0]->jwf_role_id}");
                                        }
                                        $restrict_blind_link = FALSE;
                                        if ($user_assigned->usra_usr_id !=  NULL) {
                                            if (!in_array($user_id, explode(',', $user_assigned->usra_usr_id))) {
                                                $restrict_blind_link = TRUE;
                                            }
                                            if ($core_role_details->role_assigned_role != 'author') {
                                                $Authors = new \App\Models\Authors;
                                                $article_author_details = $Authors::get_single_record('count(auth_id) as cnt', 'auth_art_id= ? AND auth_usr_id=' . $user_id, binding_arr: [$email_data->article_id]);
                                                if ($article_author_details->cnt > 0) {
                                                    $restrict_blind_link = TRUE;
                                                }
                                            }
                                            if ($core_role_details->role_assigned_role != 'reviewer') {
                                                $Article_reviewers = new \App\Models\Article_reviewers();
                                                $reviewer_data = $Article_reviewers::get_single_record('count(sorw_id) as cnt', "sorw_art_id={$email_data->article_id} AND sorw_email='{$email_data->user_email}'");
                                                if ($reviewer_data->cnt > 0) {
                                                    $restrict_blind_link = TRUE;
                                                }
                                            }
                                        }

                                    }
                                        $article_url = URL::to('/').'/'. $this->current_client->platform_type.'/'. $email_data->jnl_journal_code . '/view-article-status?' . encrypt_link($rcv_usr_id . $jnl_code . $article_id . $status_id . $deeplink_token . $type . $crid);
                                        if(isset($restrict_blind_link) && $restrict_blind_link == TRUE)
                                        {
                                            $send_content = str_ireplace("##ARTICLE_STATUS_LINK_BLIND##", '', $send_content);
                                        }
                                        else{
                                            $send_content = str_ireplace("##ARTICLE_STATUS_LINK_BLIND##", '<a href="' . $article_url . '">' . customTrans('client_lang.view_article_link') . '</a>', $send_content);
                                        }
                                    } else {
                                        $send_content = str_ireplace("##ARTICLE_STATUS_LINK_BLIND##", '', $send_content);
                                    }

                                }
                                if (in_array('ARTICLE_STATUS_LINK', $keys) && (isset($email_data->more_reviewer_updated) && ($email_data->more_reviewer_updated == true))) {
                                    if (isset($email_data->ARTICLE_STATUS_LINK[$i])) {
                                        $article_link = $email_data->ARTICLE_STATUS_LINK[$i];
                                        $send_content = str_ireplace("##ARTICLE_STATUS_LINK##", '<a href="' . $article_link . '">' . $article_link . '</a>', $send_content);
                                    }

                                }
                            }
                            if (isset($email_data->reply_to) && $email_data->reply_to != '') {
                                $email_log_data["esl_reply_to"] = $email_data->reply_to;
                                $send_array['replay_to']= $email_log_data["esl_reply_to"];
                            }
                            if($template_to === 'submitted_reviewers'){
                                $send_content=$this->get_reviewe_rating_feedback($to_array[$i],$send_content,$keys,$email_log_data['esl_article_id']);
                            }
                            else {
                                if (in_array('FEEDBACK_TO_REVIEWER', $keys)) {
                                    $send_content = str_ireplace("##FEEDBACK_TO_REVIEWER##", '', $send_content);
                                }
                            }
                            $send_content = str_ireplace($recpt_tag_keys, '', $send_content);
                            if (isset($email_data->body_arr) && is_array($email_data->body_arr)) {
                                $user_id = str_replace("~", " ", encrypt_link(trim($email_log_data['esl_user_id'])));
                                $send_content = $email_data->body_arr[$user_id];
                            }
                          
                            // Task #206 , Reply-mail secret key generation fix
                            $dynamic_secret_mail_id = NULL;
                            $email_log_data['esl_bcc'] = trim($email_log_data['esl_bcc']);
                            $email_log_data['esl_bcc']=str_replace(' ', '', $email_log_data['esl_bcc']);
                            /** TASK #6494, cc and bcc value empty insertion prevention
                             * Replace the following code into single one => $cust_cc = trim($cust_cc);$cust_cc=str_replace(' ', '', $cust_cc);$cust_cc=str_replace('[]', '', $cust_cc);  converted into => $cust_cc= str_replace(['[]', ' '], '', trim($cust_cc)); 
                             * */
                            $cust_cc= str_replace(['[]', ' '], '', trim($cust_cc));
                            $cust_bcc= str_replace(['[]', ' '], '', trim($cust_bcc));
                            $email_log_data['esl_reply_to'] = trim($email_log_data['esl_reply_to']);
                            $email_log_data['esl_reply_to']=str_replace(' ', '', $email_log_data['esl_reply_to']);
                            $data_list = array(
                                'esl_user_id' => $email_log_data['esl_user_id'],
                                'esl_article_id' => $email_log_data['esl_article_id'],
                                'esl_aflw_id' => $email_log_data['esl_aflw_id'],
                                'esl_etmp_action' => $trigger_action,
                                'esl_subject' => $email_log_data['esl_subject'],
                                'esl_content' => $send_content,
                                'esl_to' => $to_array[$i],
                                'esl_reply_to' => $email_log_data["esl_reply_to"],
                                'esl_cc' => $cust_cc,
                                'esl_bcc' => $cust_bcc,
                                'esl_batch_id' => $email_log_data["esl_batch_id"],
                                'esl_posted_by' => (isset($email_update_data['user_id'])) ? $email_update_data['user_id'] : $user_data['user_id'],
                                'esl_posted_date' => (isset($email_update_data['date'])) ? $email_update_data['date'] : date('Y-m-d H:i:s'),
                                'esl_proxy_id' => (isset($email_update_data['proxy_user_id'])) ? $email_update_data['proxy_user_id'] : $email_log_data['proxy_user_id'],
                                'esl_attachments' => (isset($email_log_data['esl_attachments'])) ? $email_log_data['esl_attachments'] : null,
                                'esl_trans_secret_id' => $dynamic_secret_mail_id,
                                'esl_trans_mode' => (isset($email_data->esl_trans_mode) && !empty($email_data->esl_trans_mode)) ? $email_data->esl_trans_mode : 's',
                                'esl_rpid' => (isset($email_data->esl_rpid) && !empty($email_data->esl_rpid)) ? $email_data->esl_rpid : null,
                                'esl_rply_source' => (isset($email_data->esl_rply_source) && !empty($email_data->esl_rply_source)) ? $email_data->esl_rply_source : null,
                                'esl_response' => (isset($email_data->esl_trans_mode) && !empty($email_data->esl_trans_mode) && $email_data->esl_trans_mode == 'r') ? ((isset($email_update_data['date'])) ? $email_update_data['date'] : date('Y-m-d H:i:s')) : NULL,
                                'esl_read_status' => $email_log_data["esl_read_status"],
                                'esl_operation' => 'i',
                            );
                            if (isset($email_data->esl_resend_email_id) && $email_data->esl_resend_email_id != "") {
                                $data_list['esl_resend_email_id'] = $email_data->esl_resend_email_id;
                            }
                             $send_array=array();
                             $send_array['to']=$to_array[$i];
                             $send_array['subject']=$subject;
                             $send_array['cc']=$cust_cc;
                             $send_array['bcc']=$cust_bcc;
                             $send_array['send_content']=$send_content;
                             $send_array['attachments']=isset($email_data->files_attached)?$email_data->files_attached:'';
                             $send_array['secret_mail_id'] = $dynamic_secret_mail_id; 
                             $send_array['jnl_id']=(isset($email_data->jnl_id)) ? $email_data->jnl_id: '';
                             $data_list['esl_success_status'] = 'n';
                             $send_array['art_id']= $email_log_data["esl_article_id"];
                             $send_array['aflw_id']= $email_log_data["esl_aflw_id"];
                             $send_array['reply_to']= (isset($email_log_data["esl_reply_to"])?$email_log_data["esl_reply_to"]:'');

                            if(isset($email_data->files_attached) && !empty($email_data->files_attached)){
                                    $send_array['attachments']=$email_data->files_attached;
                            }
                            if (!empty($data_list)) {
                                $email_art_ids =is_numeric ($email_log_data['esl_article_id']) ? [$email_log_data['esl_article_id']] : json_decode($email_log_data['esl_article_id'], true);
                                if(!is_array($email_art_ids)){
                                    $email_art_ids = [$email_art_ids];
                                }
                                foreach($email_art_ids as $key => $val){
                                    $data_list['esl_article_id'] = $val;
                                    $data_list['esl_aflw_id'] = is_array($email_log_data['esl_aflw_id']) ? $email_log_data['esl_aflw_id'][$key] : $email_log_data['esl_aflw_id'];
                                    $esl_id = $email_send_log_table::insert_record($data_list, $user_data);
                                    // Task #206 , Reply-mail secret key generation fix
                                    $last_inserted_esl_id = DB::connection()->getPdo()->lastInsertId();
                                    if (isset($this->current_client->functionality->cfty_receive_email_response) && $this->current_client->functionality->cfty_receive_email_response == 'y' && !empty($email_log_data['esl_article_id']) ) {
                                        $sent_user_id = isset($email_update_data['user_id']) ? $email_update_data['user_id'] : $user_data['user_id'];
                                        $encrypt_dynamic_data = $this->encrypt_data('&userid=' . $email_log_data['esl_user_id'] . '&artid=' . $email_log_data['esl_article_id'] . '&flowid=' . $email_log_data['esl_aflw_id'] . '&senduserid=' . $sent_user_id . '&eslparentid=' . $last_inserted_esl_id . '&datetime=' . date("Y-m-d H:i:s"));
                                        $encrypt_dynamic_data = $this->custom_base64_encoded_data($encrypt_dynamic_data);
                                        $dynamic_secret_mail_id = 'reviewmailbox-' . $encrypt_dynamic_data .  $mail_domain;
                                        $send_array['secret_mail_id'] = $dynamic_secret_mail_id;
                                        $email_send_log_table::update_receive_record(['esl_trans_secret_id' => $dynamic_secret_mail_id], " esl_id = $last_inserted_esl_id");
                                    } else {
                                        $dynamic_secret_mail_id = NULL;
                                    }
                                    if(isset($record->ane_id)){
                                        Article_notification_emails::update_record(['ane_status' => 1], " ane_id = ? ", binding_arr:['ane_id' => $record->ane_id]);
                                    }
                                }
                               $send_array['batch_id'] = $email_log_data["esl_batch_id"];
                               $send_array['model'] = 'Email_send_log';
                           }
                          $this->trigger_email($send_array);
                        }

                    }
                    } else //email message same ie, no recepient tags in body
                    {
                        if (isset($email_send_log_table) && $user_data != null) {
                            $data_list = array();
                            $return_path = null;
                            if (isset($email_data->reply_to) && $email_data->reply_to != '') {
                                $email_log_data["esl_reply_to"] = $email_data->reply_to;
                                if (isset($email_data->ctfy_bounce_back_reply_to_email) && $email_data->ctfy_bounce_back_reply_to_email == 'y') {
                                    $return_path = $email_data->reply_to;
                                }
                                $send_array['replay_to']= $email_log_data["esl_reply_to"];
                            }
                            $email_log_data['proxy_user_id'] = null;
                            if (isset($user_data['proxy_user_id']) && $user_data['user_id'] != $user_data['proxy_user_id']) {
                                $email_log_data['proxy_user_id'] = $user_data['proxy_user_id'];
                            }

                            $cust_cc = $email_log_data['esl_cc']; //RVW1271
                            $cust_bcc = $email_log_data['esl_bcc']; 
                            if (!empty($receiver_ids) && $get_recepient_cc == true && $get_recepient_cc) {
                                $receivers_cc_mails = $User_emails_table::get_single_record('GROUP_CONCAT(DISTINCT NULLIF(uml_email, "") SEPARATOR ",") as cc_mails', 'uml_user_id IN(' . implode(",", $receiver_ids) . ') AND uml_cc_email="y" AND uml_status="c" AND uml_email NOT IN(SELECT usr_email FROM  '. self::get_table_name('user_table') .'  WHERE usr_id IN(' . implode(",", $receiver_ids) . '))');
                                if (!empty($receivers_cc_mails->cc_mails)) {
                                    if(isset($email_data->esl_rply_mail) && ($email_data->esl_rply_mail)){
                                        $cust_cc = '';
                                    }else{
                                        $cust_cc = (!empty($cust_cc)) ? $cust_cc . ',' . $receivers_cc_mails->cc_mails : $receivers_cc_mails->cc_mails;
                                    }
                                }

                            }
                            /** Replace the following code into single one => $cust_cc = trim($cust_cc);$cust_cc=str_replace(' ', '', $cust_cc);$cust_cc=str_replace('[]', '', $cust_cc);  converted into => $cust_cc= str_replace(['[]', ' '], '', trim($cust_cc));*/
                            $cust_cc= str_replace(['[]', ' '], '', trim($cust_cc));
                            $cust_bcc= str_replace(['[]', ' '], '', trim($cust_bcc));
                            for ($i = 0; $i < count($to_array); $i++) {
                                $esl_resend_email_id = (isset($email_data->esl_resend_email_id) && $email_data->esl_resend_email_id != "") ? $email_data->esl_resend_email_id : 0;
                                $email_log_data['esl_user_id'] = (isset($mail_recipient_ids[$i]) && $mail_recipient_ids[$i] != '') ? $mail_recipient_ids[$i] : $to_array[$i];
                                $email_log_data['esl_reply_to'] = trim($email_log_data['esl_reply_to']);
                                $email_log_data['esl_reply_to']=str_replace(' ', '', $email_log_data['esl_reply_to']);   
                                // Task #206 , Reply-mail secret key generation fix
                                $dynamic_secret_mail_id = NULL;
                                if($template_to === 'submitted_reviewers'){
                                    $body=$this->get_reviewe_rating_feedback($to_array[$i],$send_content,$keys,$email_log_data['esl_article_id']);
                                }
                                else {
                                    if (in_array('FEEDBACK_TO_REVIEWER', $keys)) {
                                        $body = str_ireplace("##FEEDBACK_TO_REVIEWER##", '', $send_content);
                                    }
                                }
                                $email_log_data['esl_reply_to']=str_replace(' ', '', $email_log_data['esl_reply_to']);
                                $data_list[$i] = array(
                                    'esl_user_id' => (isset($email_data->user_removed) && $email_data->user_removed == true) ? null : $email_log_data['esl_user_id'],
                                    'esl_article_id' => $email_log_data['esl_article_id'],
                                    'esl_aflw_id' => $email_log_data['esl_aflw_id'],
                                    'esl_etmp_action' => $trigger_action,
                                    'esl_subject' => $email_log_data['esl_subject'],
                                    'esl_content' => $body,
                                    'esl_to' => $to_array[$i],
                                    'esl_reply_to' => $email_log_data["esl_reply_to"],
                                    'esl_cc' => $cust_cc,
                                    'esl_bcc' => $cust_bcc,
                                    'esl_batch_id' => $email_log_data["esl_batch_id"],
                                    'esl_posted_by' => (isset($email_update_data['user_id'])) ? $email_update_data['user_id'] : $user_data['user_id'],
                                    'esl_posted_date' => (isset($email_update_data['date'])) ? $email_update_data['date'] : date('Y-m-d H:i:s'),
                                    'esl_proxy_id' => (isset($email_update_data['proxy_user_id'])) ? $email_update_data['proxy_user_id'] : $email_log_data['proxy_user_id'],
                                    'esl_attachments' => (isset($email_log_data['esl_attachments'])) ? $email_log_data['esl_attachments'] : null,
                                    'esl_operation' => 'i',
                                    'esl_resend_email_id' => $esl_resend_email_id,
                                    'esl_is_forward' => (isset($email_data->is_forwarded) && $email_data->is_forwarded != '') ? $email_data->is_forwarded : 'n',
                                    'esl_trans_mode' => (isset($email_data->esl_trans_mode) && !empty($email_data->esl_trans_mode)) ? $email_data->esl_trans_mode : 's',
                                    'esl_rpid' => (isset($email_data->esl_rpid) && !empty($email_data->esl_rpid)) ? $email_data->esl_rpid : null,
                                    'esl_rply_source' => (isset($email_data->esl_rply_source) && !empty($email_data->esl_rply_source)) ? $email_data->esl_rply_source : null,
                                    'esl_response' => (isset($email_data->esl_trans_mode) && !empty($email_data->esl_trans_mode) && $email_data->esl_trans_mode == 'r') ? ((isset($email_update_data['date'])) ? $email_update_data['date'] : date('Y-m-d H:i:s')) : NULL,
                                    'esl_read_status' => $email_log_data["esl_read_status"],
                                    'esl_trans_secret_id' => $dynamic_secret_mail_id,    
                                    'esl_success_status' => 'n',

                                );
                            }

                            if (!empty($data_list)) {
                                
                                $send_array['to']=$to;
                                $send_array['subject']=$subject;
                                $send_array['cc']=$cust_cc;
                                $send_array['bcc']=$cust_bcc;
                                $send_array['send_content']=$body;
                                $send_array['attachments']=isset($email_data->files_attached)?$email_data->files_attached:'';
                                $send_array['secret_mail_id'] = $dynamic_secret_mail_id;
                                if(isset($email_data->files_attached) && !empty($email_data->files_attached)){
                                        $send_array['attachments']=$email_data->files_attached;
                                }
                                $send_array['jnl_id']=(isset($email_data->jnl_id)) ? $email_data->jnl_id: '';
                                
                                //Send email
                              

                                $send_array['art_id']= $email_log_data["esl_article_id"];
                                $send_array['aflw_id']= $email_log_data["esl_aflw_id"];
                                $send_array['reply_to']= (isset($email_log_data["esl_reply_to"])?$email_log_data["esl_reply_to"]:'');
                                $email_art_ids =is_numeric ($email_log_data['esl_article_id']) ? [$email_log_data['esl_article_id']] : json_decode($email_log_data['esl_article_id'], true);
                                if(!is_array($email_art_ids)){
                                    $email_art_ids = [$email_art_ids];
                                }
                                foreach($email_art_ids as $key => $val){
                                    for ($i = 0; $i < count($to_array); $i++) {
                                    $data_list[$i]['esl_article_id'] = $val;
                                    $data_list[$i]['esl_aflw_id'] = is_array($email_log_data['esl_aflw_id']) ? $email_log_data['esl_aflw_id'][$key] : $email_log_data['esl_aflw_id'];
                                    }
                                    $esl_id = $email_send_log_table::insert_batch($data_list, $user_data);
                                    // Task #206 , Reply-mail secret key generation fix
                                    $last_inserted_esl_id = DB::connection()->getPdo()->lastInsertId();
                                    if (isset($this->current_client->functionality->cfty_receive_email_response) && $this->current_client->functionality->cfty_receive_email_response == 'y' && !empty($email_log_data['esl_article_id']) ) {
                                        $sent_user_id = isset($email_update_data['user_id']) ? $email_update_data['user_id'] : $user_data['user_id'];
                                        $encrypt_dynamic_data = $this->encrypt_data('&userid=' . $email_log_data['esl_user_id'] . '&artid=' . $email_log_data['esl_article_id'] . '&flowid=' . $email_log_data['esl_aflw_id'] . '&senduserid=' . $sent_user_id . '&eslparentid=' . $last_inserted_esl_id . '&datetime=' . date("Y-m-d H:i:s"));
                                        $encrypt_dynamic_data = $this->custom_base64_encoded_data($encrypt_dynamic_data);
                                        $dynamic_secret_mail_id = 'reviewmailbox-' . $encrypt_dynamic_data .  $mail_domain;
                                        $send_array['secret_mail_id'] = $dynamic_secret_mail_id;
                                        $email_send_log_table::update_receive_record(['esl_trans_secret_id' => $dynamic_secret_mail_id], " esl_id = $last_inserted_esl_id ");
                                    } else {
                                        $dynamic_secret_mail_id = NULL;
                                    } 
                                    
                                    if(isset($record->ane_id)){
                                        Article_notification_emails::update_record(['ane_status' => 1], " ane_id = ? ", binding_arr:['ane_id' => $record->ane_id]);
                                    }
                                }
                              $send_array['batch_id'] = $email_log_data["esl_batch_id"];
                              $send_array['model'] = 'Email_send_log';

                                //Send email
                                 $esl_status = $this->trigger_email($send_array);

                            }
                        }
                    }
                }
            }
            if ($adhoc_attchment == true) {
                return $batch_id;
            } else {
                if ($return_batch_id == true) {
                    return $batch_id;
                } else {
                    return $esl_id;
                }

            }

    }

    //Common function to trigger email
    public function trigger_email($send_array)
    {
        $email_config = 'clients.' . $this->current_client->clnt_client_code ;
        $email_config_data=Config::get($email_config.'.email');
        $current_status = array();
        $article_flow_table = (new \App\Models\Article_flow);
        if((isset($send_array['art_id'])&&$send_array['art_id']!=NULL)&&(isset($send_array['aflw_id'])&&$send_array['aflw_id']!=NULL && !is_array($send_array['aflw_id']))){
        $select = 'jwf_stage_type,jwf_role_id';
		$where ="aflw_art_id={$send_array['art_id']} AND aflw_id={$send_array['aflw_id']}";
		$current_status = $article_flow_table::get_generic_flow($select, $where);
        }
        // commit for shyno reply to mail error fix for reply mails.
        $replay_to_email_data = '';
        //// Task #31 , jnl_id existance checking on $send_array to get the reply_to_email address.
        if (isset($send_array['reply_to'])) {
            $replay_to_email_data = $send_array['reply_to'];
        } else {
            $replay_to_email_data = $this->get_reply_to_email(((isset($send_array['jnl_id']) && !empty($send_array['jnl_id']) && $send_array['jnl_id'] != '') ? $send_array['jnl_id'] : null), $current_status);
        }

        if (isset($this->current_client->functionality->cfty_receive_email_response) && $this->current_client->functionality->cfty_receive_email_response == 'y' && isset($send_array['secret_mail_id']) && $send_array['secret_mail_id'] != NULL) {
            // Task #206 , Reply-mail -> Added a new condition in this section for handling the response. The reply email has been sent to the corresponding users, and there is no need to pass the default/journal email address in the '$reply_to_email' field. Only the secret email address is needed to track the mail responses.
            if (isset($send_array['trans_mode']) && !empty($send_array['trans_mode']) && $send_array['trans_mode'] === 'r') {
                $replay_to_email = $send_array['secret_mail_id'];
            } else {
                $replay_to_email = $send_array['secret_mail_id'] . ',' . $replay_to_email_data;
            }
        } else {
            $replay_to_email = $replay_to_email_data;
        }
        // end commit for shyno reply to mail error fix for reply mails.
        $from_address_email =$email_config_data['email_settings']['email_from_address'];
        $from_name=$email_config_data['email_settings']['email_from_alias'];
        if(env('APP_ENV') != 'local'){
            $from_address_email =$email_config_data['email_settings']['email_from_address'];
            $from_name=$email_config_data['email_settings']['email_from_alias'];
        }else{
            $from_address_email =env('MAIL_FROM_ADDRESS');
            $from_name=env('MAIL_FROM_NAME');
        }
        $toemail = $send_array['to'];
        $app_name=config('app.name');
        $header_part = customTrans('email.email_header_html');
		$header_part = str_replace('%app_name%',$app_name, $header_part);
        $footer_part=customTrans('email.email_footer_html');
        $key = $send_array['batch_id']??null;
        // print_r($send_array);exit;
        $unsubeamil=is_string($toemail) ? $toemail:implode(',', $toemail);
        $ecncrypt_user_data=$this->encrypt_data('&email=' . $unsubeamil. '&datetime=' . date("Y-m-d H:i:s").'&batch_id=' . $key );
        $unsubscribe_url =URL::to('/').'/unsubscribe-email/'.$ecncrypt_user_data;
        $footer_part = str_replace(array('%client_name%','%user_unsbscribe_link%'), array($this->current_client->clnt_client_name,$unsubscribe_url), $footer_part);
        $wrapped_content=$this->wrap_email_content_body($send_array['send_content']);

        $mailData = [
            'model' => $send_array['model'],
            'esl_id' => $send_array['esl_id'] ?? null,
            'batch_id' => $send_array['batch_id'] ?? null,
            'toemail'=>is_string($toemail) ? explode(',', $toemail) : $toemail,
            'subject'=>$send_array['subject'],
            'replay_to_email'=>$replay_to_email,
            'form_email'=>$from_address_email,
            'from_name'=>$from_name,
            'ccuser'=>is_string($send_array['cc']) ? (explode(',',$send_array['cc'])[0] ?  explode(',',$send_array['cc']) : null) : $send_array['cc'] ?? null,
            'bccuser'=>is_string($send_array['bcc']) ? (explode(',',$send_array['bcc'])[0] ? explode(',',$send_array['bcc']) : null) : $send_array['bcc'] ?? null,
            'replay_to'=>$replay_to_email,
            'content'=>$send_array['send_content'],
            'email_header_functionality'=>'y',
            'footer_content'=>$footer_part,
            'header_content'=>$header_part,
            'maincontent'=>$wrapped_content,
            'attachments'=>$send_array['attachments']
        ];
        if(isset($this->current_client->functionality->cfty_reports) && $this->current_client->functionality->cfty_reports == 'y' && isset($send_array['report_mail']) && $send_array['report_mail'] == true && isset($send_array['report_generation_job_data']) ) {
            $senddata =  Bus::chain([
                new ReportGenerationJob($send_array['report_generation_job_data']),
                new SendEmailJob($mailData),
            ])->dispatch();
        }else{
            $senddata =  SendEmailJob::dispatch($mailData);
        }
    return $senddata;
    }
    public function unsubscribe_email_trigger($send_array){
         $Batch_id_generate_table = new \App\Models\Batch_id_generate();
        $batch_id =$send_array['usl_batch_id'];
         if($batch_id == ''){
            $batch_id=$Batch_id_generate_table->insert_batch_id();
         }
            $clnt_client_code=$send_array['clnt_client_code'];
            $key=$send_array['key'];
            $email=$send_array['email'];
            $usr_id=$send_array['usl_user_id'];
            $unsubscribe_url='#';
            $footer_part=customTrans('email.email_footer_html');
            $footer_part = str_replace(array('%client_name%','%user_unsbscribe_link%'), array($clnt_client_code,$unsubscribe_url), $footer_part);
            $app_name =config('app.name');
            $ecncrypt_user_data=$this->encrypt_data('&email=' . $email. '&datetime=' . date("Y-m-d H:i:s").'&batch_id=' . $batch_id.'&key=' . $key );
            $confirmationUrl =URL::to('/').'/unsubscribe-email/'.$ecncrypt_user_data;
            $subject='Confirm Your Unsubscribe Request';
            $content="<p>Hello,</p>
                                <p>We received a request to unsubscribe your email address: <b>{$email}</b></p>
                                <p>
                            Please confirm your request by clicking the link below:<br>
                            <a href='{$confirmationUrl}' style='color:#dc2626;text-decoration:underline;'>
                                Click here to confirm your unsubscribe
                            </a>
                        </p>
                                <p>If you didn’t request this, please ignore this email.</p>
                            ";
            $replay_to='support@reviewdemo.rivervalleytechnologies.com';
            $log_data   =   array(
                        'esl_subject'     => $subject,
                        'esl_content'     => $content,
                        'esl_to'          => $email,
                        'esl_reply_to'    => $replay_to,
                        'esl_user_id'     => $usr_id!=''?$usr_id:null,
                        // 'esl_cc'          => ($send_report->rmil_send_cc!=NULL) ? $send_report->rmil_send_cc : '',
                        'esl_success_status' => 'n',
                        'esl_batch_id'    =>  $batch_id,
                        // 'esl_attachments' => json_encode(array('article' => '', 'modified' => $send_report->attachment)),
                        'esl_posted_by'   => $usr_id!=''?$usr_id:0,
                        'esl_proxy_id'    => NULL,
                        'esl_posted_date' => date('Y-m-d H:i:s'),
                        'esl_operation'   => 'i'
                    );
                    if(!empty($log_data)){
                        $send_array['to']           =   $email;
                        $send_array['subject']      =   $subject;
                        // $send_array['cc']           =   ($send_report->rmil_send_cc!=NULL) ? explode(',',$send_report->rmil_send_cc) : '';
                        $send_array['cc']           = '';
                        $send_array['bcc']          =   '';
                        $send_array['send_content'] =   $content;
                        $send_array['attachments']  =  [];
                        $send_array['jnl_id']       =   null;
                        $send_array['reply_to']     =   $replay_to;
                        $send_array['model'] = 'Email_send_log';
                    }
                    $send_array['esl_id'] = Email_send_log::insert_record($log_data);
                    $this->trigger_email($send_array);
                    /*
                     $mailData = [
                            'form_email' => 'noreply@reviewdemo.rivervalleytechnologies.com',
                            'from_name' => $app_name,
                            'replay_to' => 'support@reviewdemo.rivervalleytechnologies.com',
                            'subject' => 'Confirm Your Unsubscribe Request',
                            'batch_id' => $batch_id,
                            // 'esl_id' => uniqid('ESL'),
                            'esl_id'=>$send_array['esl_id'],
                            'attachments' => [],
                            'header_content'=>$app_name,
                            // 'content'=>'hai',
                            'content' => "
                                <p>Hello,</p>
                                <p>We received a request to unsubscribe your email address: <b>{$email}</b>.</p>
                                <p>
                            Please confirm your request by clicking the link below:<br>
                            <a href='{$confirmationUrl}' style='color:#dc2626;text-decoration:underline;'>
                                Click here to confirm your unsubscribe
                            </a>
                        </p>
                                <p>If you didn’t request this, please ignore this email.</p>
                            ",
                            'footer_content'=>$footer_part
                        ];
                        Mail::to($email)->send(new SendEmail($mailData));
                        */

    }

    public function get_user_role_emails($role_arr, $email_data)
    {
        $general_config = $this->General_config_data('mail_block_usr_status');
        $mail_block_usr_status = $general_config['mail_block_usr_status'];
        $author_table = new \App\Models\Authors();
        $userjournal = new \App\Models\User_to_journals();
        $roles = (new \App\Models\Roles());
        $users = (new \App\Models\User());
        $email_recipients_arr = array();
        $email_recipients = '';
        $article_id = null;
        if (isset($email_data->article_id)) {
            $article_id = $email_data->article_id;
        }
        $custom_array=array("Custom","Custom_cc","Custom_bcc");
        foreach ($role_arr as $role) {
            if (!in_array($role,$custom_array)) {
                switch ($role) {
                    case 'Super Admin':
                        $res = User::get_single_record("GROUP_CONCAT(`usr_email` SEPARATOR ',') AS usr_email", 'usr_roles LIKE "%super_admin%" and usr_status NOT IN(' . $mail_block_usr_status . ')');
                        break;
                    case 'Admin':
                        $res = User::get_single_record("GROUP_CONCAT(`usr_email` SEPARATOR ',') AS usr_email", 'usr_roles LIKE "%\"admin\"%" and usr_status NOT IN(' . $mail_block_usr_status . ')');

                        break;
                    case 'Report Operator':
                        $res = User::get_single_record("GROUP_CONCAT(`usr_email` SEPARATOR ',') AS usr_email", 'usr_roles LIKE "%report_operator%" and usr_status NOT IN(' . $mail_block_usr_status . ')');

                        break;
                    case 'Author':
                        if ($article_id != null) {
                            $res = $author_table::get_email_record('usr_email', "auth_corr_author='y' AND auth_art_id ={$article_id} and usr_status NOT IN(" . $mail_block_usr_status . ")");
                            if(isset($res[0]))
                            {
                                $res = $res[0];
                            }
                        }
                        break;
                    case 'article_authors':
                        if ($article_id != null) {
                            $res = $author_table::get_email_record("GROUP_CONCAT(`usr_email` SEPARATOR ', ') AS usr_email", "auth_art_id ={$article_id} AND usr_status NOT IN(" . $mail_block_usr_status . ")");
                            if(isset($res[0]))
                            {
                                $res = $res[0];
                            }
                        }
                        break;
                    case 'Authors':
                        if (isset($roles)) {
                            $roles_records = $roles::get_single_record('role_id', "role_name ='Author'");
                            $role_id = $roles_records->role_id;
                            $condition = "role_id ={$role_id} AND usrj_role_retired = 'n' AND jnl_journal_code='{$email_data->jnl_journal_code}' AND artp_id={$email_data->artp_id}";
                            if (isset($userjournal)) {
                                $cours_recp = $userjournal::get_user_from_jnl('GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email', $condition);
                                if (count($cours_recp) > 0) {
                                    $email_recipients = $cours_recp[0]->usr_email;
                                }
                            }
                        }
                        break;
                    default:if (isset($email_data->jnl_journal_code) ) {    
                        if ($article_id != null) {
                            // Task #3890 Organizer email no edited content is sent start
                          if($article_id != NULL&&!isset($email_data->artp_id) || empty($email_data->artp_id))
                          {
                          $Articles = new \App\Models\Articles;
                          $article_details = $Articles::get_single_record('art_artp_id',"art_id={$article_id}");
                           if(isset($article_details)&&isset($article_details->art_artp_id))
                          {
                          $email_data->artp_id = $article_details->art_artp_id;
                          }
                          }
                            // Task #3890 Organizer email no edited content is sent end
                                $manange_email_privileged_user = '';
                                $manange_email_privileged_user_condtn = '';
                                if($role != 'User' && $role != 'Custom')
                                {
                                    $manange_email_privileged_user = ' LEFT JOIN (SELECT art_artp_id, GROUP_CONCAT(auth_usr_id) as auth_usr_id FROM rvw_articles,rvw_article_authors WHERE art_id = '.$article_id.' and art_id = auth_art_id) as art_authors_tb ON  ( usrj_artp_id = art_authors_tb.art_artp_id ) ';
                                    $manange_email_privileged_user_condtn = ' AND FIND_array_not_in( art_authors_tb.auth_usr_id,usrj_usr_id )=1 ';
                                }
                                $select = 'IF((SELECT COUNT("usra_id") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ) > 0, '
                            . '(SELECT GROUP_CONCAT(usra_usr_id SEPARATOR ",") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ), '
                            . '(SELECT GROUP_CONCAT(usrj_usr_id SEPARATOR ",")  FROM rvw_user_journals '.$manange_email_privileged_user.' WHERE usrj_role_id = role_id AND usrj_role_retired = "n" AND usrj_artp_id = ' .  $email_data->artp_id . ' '. $manange_email_privileged_user_condtn . ') ) AS user_id';
                                $where = "role_name='{$role}'";
                                $usr_ids = $roles::get_single_record($select, $where);
                                $result = null;
                                if (isset($usr_ids) && $usr_ids->user_id != null) {
                                    $result = $users::get_all_records('GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email', 'usr_id IN (' . $usr_ids->user_id . ') AND usr_status NOT IN (' . $mail_block_usr_status. ')');
                                }
                                if (isset($result) && $result != null && $result[0]->usr_email != null) {
                                    $email_recipients = $result[0]->usr_email;
                                } else {
                                    $email_recipients = '';
                                    $this->log_email_send_error("Reason : CC Email send failed due to non existing role '" . $result . "'");
                                }
                            } else {
                         // Task #3890 Organizer email no edited content is sent start
                          if (!preg_match("/^'.*'$/", $role)) {
                              $role ="'".$role."'";
                          }
                         // Task #3890 Organizer email no edited content is sent end
                                $roles_records = $roles::get_single_record('role_id', "role_name={$role}");
                                $role_id = $roles_records->role_id;
                            // Task #3890 Organizer email no edited content is sent start
                          if($email_data->artp_id){
                            $condition = "role_id ={$role_id} AND usrj_role_retired = 'n' AND jnl_journal_code='{$email_data->jnl_journal_code}' AND artp_id={$email_data->artp_id}";
                          }                        
                          elseif(isset($email_data->esl_etmp_action) && ($email_data->esl_etmp_action=="send_notification_to_organiser")){
                              $condition = "role_id ={$role_id} AND usrj_role_retired = 'n' AND jnl_journal_code='{$email_data->jnl_journal_code}' ";   
                          }
                          if (isset($userjournal)&&isset($condition)) {
                           // Task #3890 Organizer email no edited content is sent end
                                    $cours_recp = $userjournal::get_user_from_jnl('GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email', $condition);
                                    if (count($cours_recp) > 0) {
                                        $email_recipients = $cours_recp[0]->usr_email;
                                    }
                                }
                            }
                        }
                }   
                if (isset($res->usr_email)) {
                    $email_recipients = $res->usr_email;
                    $res = null;
                }
                $email_recipients_arr[] = $email_recipients;        
            }
        }
        return $email_recipients_arr;
    }

    public function replace_email_key_with_data($original_data, $tmpl_data, $titles = array(), $client_email_date_format = null, $mail_type = '', $etmp_action = null,$author_details = array(), $is_blinded =false, $is_preview = true, $config_name = null)
    {
        $orcid_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid.orcid';
        $orcid_settings = Config::get($orcid_config);
        if (empty($titles)) {
            $titles = $this->UserConfigdata('titles')['titles'];
        }
        if(isset($original_data[0]->INVITED_JOURNAL_ROLES) && $original_data[0]->INVITED_JOURNAL_ROLES){
            $arrayOfValues = [];
            $arrayOfValues = explode(', ', $original_data[0]->INVITED_JOURNAL_ROLES);
            $uniqueArray = array_unique($arrayOfValues);
            $original_data[0]->INVITED_JOURNAL_ROLES = implode(', ', $uniqueArray);
        }

        if (!empty($original_data)) {
            foreach ($original_data as $orgval) {
                foreach ($orgval as $org_key => $org_val) {

                    if (array_key_exists($org_val, $titles)) {
                        $hide_for_recipient = false;
                        /*TASK #5730 An error occuers when user click on reviewer invitation mail after adding all author tags in that email template */
                        if (!empty($author_details)&&((($author_details['core_role_name']=='reviewer' ||(isset($author_details['email_data']->to)&&$author_details['email_data']->to=='submitted_reviewers'))&&($author_details['review_method']=='d')) || ($is_preview ? ($this->is_custom_blinded('author', $author_details['email_data']->article_id) || $hide_for_recipient = $this->is_custom_blinded('author', $author_details['email_data']->article_id, usr_role_id : $author_details['role_id'])) : $this->is_custom_blinded('author', $author_details['email_data']->article_id, usr_role_id : $author_details['role_id']))) && ($author_details['author_config']=='author_config')) {
                            if($is_preview && !$hide_for_recipient){
                                $tmpl_data = str_ireplace("##$org_key##", '<button contenteditable="false">'.$org_key.'</button>', $tmpl_data);
                            }
                            else{
                                $author_tags=array_keys($this->email_templates_config()['author_tags']);
                                $new_value= strtolower(str_ireplace("_", ' ', $org_key));
                                $replaceword = ["fullname","firstname", "lastname", "postalcode"];
                                $changeword   = ["full name","first name", "last name", "postal code"];
                                $authortag = str_replace($replaceword, $changeword, $new_value);
                                $tmpl_data = str_ireplace("##$org_key##", ucwords($authortag), $tmpl_data);
                            }
                        } 
                        else {
                        if($config_name == 'author_config'){
                            $tag_name = "rvat";
                        }elseif($config_name == 'current_user_config'){
                            $tag_name = "rvbu";
                        }else{
                            $tag_name = "rvrt";
                        }
                        $class_val = ucwords(str_replace('_', ' ', $org_key));
                        $replaceword = ["fullname","firstname", "lastname", "postalcode"];
                        $changeword   = ["full name","first name", "last name", "postal code"];
                        $authortag = str_replace($replaceword, $changeword, $class_val);
                        $org_val = "<$tag_name class=\"$class_val\">$titles[$org_val]</$tag_name>";
                        $tmpl_data = str_ireplace("##$org_key##", $org_val, $tmpl_data);
                        }
                        /*end TASK #5730 An error occuers when user click on reviewer invitation mail after adding all author tags in that email template */
                    } else {
                        if ($org_val == ',') {
                            $org_val = '';
                        }
                        

                        $org_val = preg_replace('/,+/', ',', $org_val);
                        $hide_for_recipient = false;
                        // TASK #8200 Tag replacing issue in blind conditions start
                        $Article_type_advance_options = new \App\Models\Article_type_advance_options;
                        $Articles = new \App\Models\Articles;
                        if(isset($author_details['email_data']->article_id)){
                            $art_type = $Articles::get_single_record_with_bind_cond('art_artp_id', array(
                                'art_id' => $author_details['email_data']->article_id));
                            $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$art_type->art_artp_id}");  
                            $rcp_role_id = $this->get_role_id_from_mail_to($author_details['email_data']->to ?? $author_details['email_data']->too ?? 'User', $author_details['email_data']->aflw_id ?? null);   
                            $role_name = Roles::find($rcp_role_id)?->role_assigned_role;
                            $is_blinded = $this->is_custom_blinded('reviewer', $author_details['email_data']->article_id, usr_role_id :$rcp_role_id);
                            if(((($artp_settings->atotp_review_method=='s')&&((($role_name == 'author') || (isset($author_details['email_data']->to) && ($author_details['email_data']->to == 'submit_author' || $author_details['email_data']->to == 'Author' || $author_details['email_data']->to== 'article_authors' || $author_details['email_data']->to == 'Authors')))))||($artp_settings->atotp_review_method=='d')|| $is_blinded )&& (($author_details['author_config']=='user_role_tag')|| ($author_details['author_config']=='author_config'))){
                                $new_value= strtolower(str_ireplace("_", ' ', $org_key));
                                $replaceword = ["fullname","firstname", "lastname", "postalcode"];
                                $changeword   = ["full name","first name", "last name", "postal code"];
                                $authortag = str_replace($replaceword, $changeword, $new_value);
                                $tmpl_data = str_ireplace("##$org_key##", ucwords($authortag), $tmpl_data);
                            }         
                        } 
                        // TASK #8200 Tag replacing issue in blind conditions end

                        if (!empty($author_details)&&((($author_details['core_role_name']=='reviewer' ||(isset($author_details['email_data']->to)&&$author_details['email_data']->to=='submitted_reviewers'))&&($author_details['review_method']=='d')) || ($is_preview ? ($this->is_custom_blinded('author', $author_details['email_data']->article_id) || $hide_for_recipient = $this->is_custom_blinded('author', $author_details['email_data']->article_id, usr_role_id : $author_details['role_id'])) : $this->is_custom_blinded('author', $author_details['email_data']->article_id, usr_role_id : $author_details['role_id']))) && ($author_details['author_config']=='author_config')) {
                            $author_tags=array_keys($this->email_templates_config()['author_tags']);
                            if(in_array($org_key, $author_tags))
                            {
                                if($is_preview && !$hide_for_recipient){
                                    $tmpl_data = str_ireplace("##$org_key##", '<button contenteditable="false">'.$org_key.'</button>', $tmpl_data);
                                }
                                else{
                                     $new_value= strtolower(str_ireplace("_", ' ', $org_key));
                                $replaceword = ["fullname","firstname", "lastname", "postalcode"];
                                $changeword   = ["full name","first name", "last name", "postal code"];
                                $authortag = str_replace($replaceword, $changeword, $new_value);
                                $tmpl_data = str_ireplace("##$org_key##", ucwords($authortag), $tmpl_data);
                                }
                            }
                        }
                        else
                        {
                            if ($org_key == 'CORRESPONDING_AUTHOR_ORCID' || ($org_key == 'CURRENT_USER_ORCID' && !$is_blinded)) {
                                    if (!empty($org_val)) {
                                        $org_val = "<a href='" . $orcid_settings['link_url'] . $org_val . "' target='_blank'>" . $orcid_settings['link_url'] . $org_val . " </a>";
                                    }
                                }
                        }
                        if (($org_key == 'ARTICLE_SUBMITTED_DATE' || $org_key == 'DECISION_DATE' || $org_key == 'STUB_SUBMISSION_DUE_DATE' || $org_key == 'TASK_DUE_DATE') && $client_email_date_format != null) {
                            if ($mail_type == 'preview' || $mail_type == 'edit' || $mail_type == '') {
                                $tmpl_data = str_ireplace("##$org_key##", date($client_email_date_format, strtotime($org_val)), $tmpl_data);
                            }

                        }
                        if ($etmp_action == 'assigned' && ($org_key == 'ARTICLE_STATUS_NAME' || $org_key == 'ARTICLE_STAGE_NAME')) {
                            $tmpl_data = str_ireplace("##$org_key##", $org_val, $tmpl_data);
                        }
                        if(str_contains($org_key, 'CURRENT_USER')){
                            $class_val = ucwords(str_replace('_', ' ', $org_key));
                            $org_val = "<rvbu class=\"$class_val\">$org_val</rvbu>";
                        }
                        if(str_contains($org_key, 'RECIPIENT_')){
                            $class_val = ucwords(str_replace('_', ' ', $org_key));
                            $org_val = "<rvrt class=\"$class_val\">$org_val</rvrt>";
                        }
                        if(str_contains($org_key, 'CORRESPONDING_AUTHOR_')){
                            $class_val = ucwords(str_replace('_', ' ', $org_key));
                            $org_val = "<rvat class=\"$class_val\">$org_val</rvat>";
                        }
                        $tmpl_data = str_ireplace("##$org_key##", $is_blinded && (str_contains($org_key, 'CURRENT_USER') || str_contains($org_key, 'RECIPIENT_') || str_contains($org_key, 'CORRESPONDING_AUTHOR_')) ? ucwords(str_replace('_', ' ',$org_key)) : $org_val , $tmpl_data);
                    }                    
                }
            }
        }
        return $tmpl_data;
    }

    public function replace_content($assignments, $message)
    {
        preg_match_all('/##([^##]*)##/', $message, $matches);
        $keys = $matches[1];
        $replace_text = "Reviewer " . $assignments;
        for ($i = 0; $i < count($keys); $i++) {
            $element = $keys[$i];
            if (strstr($element, "CURRENT_USER") != false) {
                $lowertext = strtolower($element);
                $element_change = str_replace("current_user", $replace_text, $lowertext);
                $element_str = str_replace("_", " ", $element_change);
                $replace_subject =str_replace('##'.$element.'##','"'.$element_str.'"',$message);
                $message = $replace_subject;
            }
        }
        return $message;
    }

    public function replace_generic_form_content($stage_keys,$email_data,$body)
    {
        $Stage_email_templates_table = new \App\Models\Stage_email_templates();
        $Articles=new \App\Models\Articles;
        $articles_table=(new \App\Models\Articles())->getTable();
        $article_flow_table = (new \App\Models\Article_flow)->getTable();;
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        if(isset($email_data->jnl_id)&&$email_data->jnl_id!='')
        {
            $date_format = $this->get_platform_date_format($email_data->jnl_id);

        }
        else
        {
            $date_format = $this->current_client->settings->cs_date_format;
        }
		$date_format= date_format_map($date_format);
        if (count($stage_keys) > 0 && isset($email_data->article_id)) {
            for ($i = 0; $i < count($stage_keys); $i++) {
                $stage_form_result =$Stage_email_templates_table::get_stagewise_generic_form_data($stage_keys[$i], $email_data->article_id, $email_data->jnl_journal_code,$email_data->jnl_id,$date_format);
                if( strpos($stage_keys[$i], '_original') !== false) {
                    $stage_keys[$i] = substr($stage_keys[$i],0,-9);
                    $artall_id_sql = "SELECT art_pre_all_ids FROM {$articles_table} WHERE art_id ={$email_data->article_id}";
                    $article_prev_all_ids =$Articles::get_records_by_raw_query($artall_id_sql);
                    if(isset($article_prev_all_ids[0]->art_pre_all_ids) &&  $article_prev_all_ids[0]->art_pre_all_ids !='')
                    {
                        $org_versn_cndtn = 'FIND_IN_SET(art_id,"'.$article_prev_all_ids[0]->art_pre_all_ids.'")>0';
                        $sql_org_versn_art_id = "SELECT art_id FROM {$articles_table} INNER JOIN {$article_flow_table} ON aflw_art_id = art_id INNER JOIN {$generic_flow_table} ON aflw_jwf_id = jwf_id  WHERE {$org_versn_cndtn} AND jwf_stage_type = 'author_submission'";
                        $org_versn_art_id = $Articles::get_records_by_raw_query($sql_org_versn_art_id);
                        $articl_id = $org_versn_art_id[0]->art_id;
                    }
                    else
                    {
                        $articl_id = $email_data->article_id;
                    }
                    $stage_form_result =$Stage_email_templates_table::get_stagewise_generic_form_data($stage_keys[$i], $articl_id, $email_data->jnl_journal_code,$email_data->jnl_id,$date_format);
                }
                else
                {
                $stage_form_result = $Stage_email_templates_table::get_stagewise_generic_form_data($stage_keys[$i], $email_data->article_id, $email_data->jnl_journal_code,$email_data->jnl_id,$date_format);
                }
                if ($stage_form_result != null) {
                    $original_form_data[$stage_keys[$i]] = $stage_form_result;
                }

            }
            //   TASK #8239 start
            $decion_mail_name=true;           
            $Article_type_advance_options = new \App\Models\Article_type_advance_options;
            $Articles = new \App\Models\Articles;
            if(isset($email_data->article_id)){
                $art_type = $Articles::get_single_record_with_bind_cond('art_artp_id', array(
                    'art_id' => $email_data->article_id));
                $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$art_type->art_artp_id}");  
                $rcp_role_id = $this->get_role_id_from_mail_to($email_data->to ?? $email_data->too ?? 'User', $email_data->aflw_id ?? null);   
                $role_name = Roles::find($rcp_role_id)?->role_assigned_role;
                $is_blinded = $this->is_custom_blinded('reviewer', $email_data->article_id, usr_role_id :$rcp_role_id);
                if((($artp_settings->atotp_review_method=='s')&&((($role_name == 'author') || (isset($email_data->to) && ($email_data->to == 'submit_author' || $email_data->to == 'Author' || $email_data->to== 'article_authors' || $email_data->to == 'Authors')))))||($artp_settings->atotp_review_method=='d')|| $is_blinded ){
                    $decion_mail_name=false;
                }         
            }
            //   TASK #8239 end
            $hide_control_label = (isset($email_data->cfty_unique_hide_control_label_email)) ? $email_data->cfty_unique_hide_control_label_email : 'n';
            foreach ($original_form_data as $stage_key => $gdata_details) {
                $gdata_return = $this->get_unique_data($gdata_details, $decion_mail_name, $hide_control_label);
                if (!empty($gdata_return)) {
                    foreach ($gdata_return as $gk => $gdt) {
                        if ($gdt['element_type'] != 'file') {
                            $body = str_replace('##' . $gk . '{' . $stage_key . '}##', $gdt['content'], $body);
                            if(strpos($body,'##' . $gk . '{' . $stage_key .'_original}##') !== false)
							{
							$body = str_replace('##' . $gk . '{' . $stage_key .'_original}##', $gdt['content'], $body);
							}
                        } else {

                            $body = str_replace('##' . $gk . '{' . $stage_key . '}##', '', $body);
                        }
                    }
                }
            }
        }
          return $body;
    }

    public function replace_resind_reset_data($rs_config_arr,$email_data,$titles,$mail_type,$body) {
        $Stage_email_templates_table = new \App\Models\Stage_email_templates();

        if (count($rs_config_arr) > 0) {
            if (isset($email_data->rescind_details_for_preview)) {
                $body = $this->replace_email_key_with_data($email_data->rescind_details_for_preview, $body, $titles, null, $mail_type);
            } elseif (isset($email_data->aflw_id) && isset($email_data->action)) {
                $select = '';
                foreach ($rs_config_arr as $rvkey => $rvval) {

                    $select .= $rvval['select'] . ' AS `' . $rvkey . '`,';
                }
                $rescind_reset_record_table = (new \App\Models\Rescind_reset_record())->getTable();
                $select = rtrim($select, ',');

                $sql = 'SELECT ' . $select . ' FROM ' . $rescind_reset_record_table . ' iNNER JOIN ' . self::get_table_name('generic_flows_table') . ' ON ' . $rescind_reset_record_table . '.rsc_source_jwf_id = ' . self::get_table_name('generic_flows_table') . '.jwf_id where rsc_current_flow_id=' . $email_data->aflw_id . ' AND rsc_action = "' . $email_data->action . '" order by rsc_posted_date desc LIMIT 1';

                $result_data = $Stage_email_templates_table::get_records_by_raw_query($sql);
                $body = $this->replace_email_key_with_data($result_data, $body, $titles, null, $mail_type);
            }
        }
        return $body;
    }
    public function replace_article_related_tag_data($tmpl_config,$email_data,$titles,$client_email_date_format,$body,$is_preview)
    {

        $Stage_email_templates_table = new \App\Models\Stage_email_templates();

        if (count($tmpl_config) > 0) {
            $join_condition = $email_data->join_config;
            $join_dependencies = $email_data->join_dependency_config;
            if (isset($email_data->article_id)) {

                if (isset($tmpl_config['article_tags']['ARTICLE_TITLE']['select'][0]) && $tmpl_config['article_tags']['ARTICLE_TITLE']['select'][0] == 'strip_tags(art_title)') {
                    $tmpl_config['article_tags']['ARTICLE_TITLE']['select'][0] = 'art_title';
                }
                if (!empty($email_data->aflw_id)) {
                    $condition = "aflw_id={$email_data->aflw_id}";
                    $flowdetails = Articles::get_article_details("jwf_role_id", $condition);
                }
                $results = $Stage_email_templates_table::format_email_content($tmpl_config, $email_data->article_id, $join_condition, $join_dependencies);
                
                foreach ($results as $result) {
                    foreach ($result as $rkey => $rval) {
                        $hide_for_recipient = false;
                        if ($rkey == 'ARTICLE_TITLE') {
                            $replace_p_tags = array('<p>', '</p>');
                            $rval = str_replace($replace_p_tags, '', $rval);
                        }
                        if (array_key_exists($rval, $titles)) {
                            /* TASK #5730 An error occuers when user click on reviewer invitation mail after adding all author tags in that email template */
                            if (!empty($core_role_details)&&!empty($artp_settings)&&(((($core_role_details->role_assigned_role=='reviewer')||(isset($email_data->to)&&$email_data->to=='submitted_reviewers'))&&($artp_settings->atotp_review_method=='d')) || ( $is_preview ? $this->is_custom_blinded('author', $email_data->article_id) : $hide_for_recipient = $this->is_custom_blinded('author', $email_data->article_id, usr_role_id : $flowdetails[0]->jwf_role_id)))){
                                $article_tags=array_keys($this->email_templates_config()['article_tags']);
                                if($is_preview && !$hide_for_recipient && in_array($rkey, $article_tags)){
                                    $tmpl_data = str_ireplace("##$rkey##", '<button contenteditable="false">'.$rkey.'</button>', $body);
                                }
                                else if(in_array($rkey, $article_tags))
                                {
                                    $new_value= strtolower(str_ireplace("_", ' ', $rkey));
                                    $replaceword = ["fullname","firstname", "lastname", "postalcode"];
                                    $changeword   = ["full name","first name", "last name", "postal code"];
                                    $authortag = str_replace($replaceword, $changeword, $new_value);
                                    $tmpl_data = str_ireplace("##$rkey##", ucwords($authortag), $body);
                                    $body = $tmpl_data;
                                }   
                            }
                            else{
                            $body = str_ireplace("##$rkey##", $titles[$rval], $body);
                            } 
                            /* end TASK #5730 An error occuers when user click on reviewer invitation mail after adding all author tags in that email template */
                        } else {
                            $rval = preg_replace('/,+/', ',', $rval);
                            if (!empty($client_email_date_format) && !empty($rval) && ($rkey == 'ARTICLE_SUBMITTED_DATE' || $rkey == 'DECISION_DATE' || $rkey == 'STUB_SUBMISSION_DUE_DATE' || $rkey == 'REVISION_DATE')) {
                                $body = str_ireplace("##$rkey##", date($client_email_date_format, strtotime($rval)), $body);
                            }elseif($rkey == 'SUBMITTING_AUTHOR_EMAIL'||$rkey == 'SUBMITTING_AUTHOR_FULLNAME'||$rkey == 'SUBMITTING_AUTHOR_TITLE'||$rkey == 'ARTICLE_AUTHORS'||$rkey == 'AUTHORS_FULLNAMES'||$rkey == 'AUTHOR_ADDRESS'||$rkey == 'AUTHOR_INFO'){
                                $Article_type_advance_options = new \App\Models\Article_type_advance_options;
                                    $Roles = new \App\Models\Roles();
                                    $artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$email_data->artp_id}");
                                    if (isset($email_data->aflw_id)) {
                                    $core_role_details  =   $Roles::get_single_record('role_assigned_role',"role_id={$flowdetails[0]->jwf_role_id}");
                                    if (!empty($core_role_details)&&!empty($artp_settings)&&(((($core_role_details->role_assigned_role=='reviewer')||(isset($email_data->to)&&$email_data->to=='submitted_reviewers'))&& $artp_settings->atotp_review_method=='d') || ( $is_preview ? $this->is_custom_blinded('author', $email_data->article_id) : $hide_for_recipient = $this->is_custom_blinded('author', $email_data->article_id, usr_role_id : $flowdetails[0]->jwf_role_id)))) {
                                        $article_tags=array_keys($this->email_templates_config()['article_tags']);
                                        if($is_preview && !$hide_for_recipient && in_array($rkey, $article_tags)){
                                            $tmpl_data = str_ireplace("##$rkey##", '<button contenteditable="false">'.$rkey.'</button>', $body);
                                        }
                                        else if(in_array($rkey, $article_tags))
                                        {
                                            $new_value= strtolower(str_ireplace("_", ' ', $rkey));
                                            $replaceword = ["fullname","firstname", "lastname", "postalcode"];
                                            $changeword   = ["full name","first name", "last name", "postal code"];
                                            $authortag = str_replace($replaceword, $changeword, $new_value);
                                            $tmpl_data = str_ireplace("##$rkey##", ucwords($authortag), $body);
                                        }
                                        $body = $tmpl_data;

                                    }
                                }
                                $body = str_ireplace("##$rkey##", $rval, $body); // TASK #5730 An error occuers when user click on reviewer invitation mail after adding all author tags in that email template
                            } 
                            else {
                                $body = str_ireplace("##$rkey##", $rval, $body);
                            }

                        }
                    }
                }

            }
        }
        return $body;
    }

    public function replace_conference_related_tags($abstract_config,$email_data,$titles,$client_email_date_format,$body){
        $Stage_email_templates_table = new \App\Models\Stage_email_templates();

        if (count($abstract_config) > 0) {
            $join_condition = $email_data->join_config;
            $join_dependencies = $email_data->join_dependency_config;
            if (isset($email_data->article_id)) {

                $results = $Stage_email_templates_table::format_email_content($abstract_config, $email_data->article_id, $join_condition, $join_dependencies);

                foreach ($results as $result) {
                    foreach ($result as $rkey => $rval) {
                        if (array_key_exists($rval, $titles)) {

                            $body = str_ireplace("##$rkey##", $titles[$rval], $body);
                        } else {
                            $rval = preg_replace('/,+/', ',', $rval);
                            $body = str_ireplace("##$rkey##", $rval, $body);
                        }
                    }
                }

            }
        }

        return $body;
    }

   public function replace_apiuserconfigtags($api_user_client_config,$email_data,$titles,$mail_type,$body){

    if (count($api_user_client_config) > 0) {
        if (isset($email_data->api_client_id)) {
            $api_client_table = (new \App\Models\API_client())->getTable();
            $Stage_email_templates_table = new \App\Models\Stage_email_templates();
            $select = '';
            $group_by_str = '';
            $group_by_criteria = '';
            foreach ($api_user_client_config as $usr_key => $usr_val) {
                if (isset($usr_val['select'])) {
                    $select .= $usr_val['select'] . ' as ' . $usr_key . ',';
                }
            }
            if ($group_by_str != '') {
                $group_by_str = rtrim($group_by_str, ',');
                $group_by_arr = explode(',', $group_by_str);
                $org_group_by_arr = array_unique($group_by_arr);
                $group_by = implode(',', $org_group_by_arr);
                $group_by_criteria = ' GROUP BY ' . $group_by;
            }
            $select = rtrim($select, ',');
            $where = 'acl_id =' . $email_data->api_client_id;
            $sql = 'SELECT ' . $select . ' FROM ' . $api_client_table . ' WHERE ' . $where . $group_by_criteria;
            $api_user_results = $Stage_email_templates_table::get_records_by_raw_query($sql);
            $body = $this->replace_email_key_with_data($api_user_results, $body, $titles, null, $mail_type);
        }
    }
    return $body;
   }
   public function wrap_email_content_body($content)
   {
    $header_part_content=customTrans('email.email_header_html_data');
    $footer_part_content=customTrans('email.email_footer_html');
    $wrapped_content = '';
     $app_name =config('app.name');
     if(isset($this->client_functionality->cfty_show_client_name_email_header) && $this->client_functionality->cfty_show_client_name_email_header == 'y')
     {
         $app_name = $this->current_client->clnt_client_name.' – '.$app_name;
     }

     $header_part_content = str_replace('%app_name%',$app_name, $header_part_content);

     $unsubscribe_url = URL::to('/').'/unsubscribe-email/';
     $footer_part_content = str_replace(array('%client_name%','%user_unsbscribe_link%'), array($this->current_client->clnt_client_name,$unsubscribe_url), $footer_part_content);

     $wrapped_content =  $header_part_content.$content.$footer_part_content;
     return $wrapped_content;
   }
   public function send_unassign_email_workflow($email_template, $article_details, $user_id, $client, $current_user, $current_stage, $prefix ,$production_status=FALSE) {
    $usr_details = User::get_single_record('usr_email,usr_id',"usr_id={$user_id}");
    $Article_notification_emails = new \App\Models\Article_notification_emails();
    $userjournal_table = new \App\Models\User_to_journals();

    if (!empty($email_template)) {

        $user_id = $usr_details->usr_id;
        $send_mail_to = '';
        $send_mail_to_usr_ids = '';
        $article_email = NULL;
        if ($prefix == 'stage_etmp_') {
            $where="ane_stage_etmp_id={$email_template->stage_etmp_id} AND ane_setr_id={$email_template->setr_id} AND ane_art_id={$article_details->art_id} AND ane_prev_aflw_id={$current_stage}";

            $article_email = $Article_notification_emails::get_single_record('*', $where);
        }


        if ($article_email != NULL) {
            $email_template->stage_etmp_to = $article_email->ane_to;
            $email_template->stage_etmp_cc = $article_email->ane_cc;
            $email_template->stage_etmp_bcc = $article_email->ane_bcc;
            $email_template->stage_etmp_cust_to = $article_email->ane_cust_to;
            $email_template->stage_etmp_cust_cc = $article_email->ane_cust_cc;
            $email_template->stage_etmp_cust_bcc = $article_email->ane_cust_bcc;
            $email_template->stage_etmp_subject = $article_email->ane_subject;
            $email_template->stage_etmp_email_template = $article_email->ane_content;
            $email_template->stage_etmp_reply_to = $article_email->ane_reply_to;
        }

        $email_data = new stdClass;
        $email_data->article_id = $article_details->art_id;
        $email_data->art_article_upload_path = $article_details->art_article_upload_path;
        $email_data->all_user_roles = $userjournal_table::get_user_role_classification($article_details->art_id, 'a');

        $send_mail_to = $usr_details->usr_email;
        $send_mail_to_usr_ids = $user_id;
        if ($send_mail_to != '') {
            $email_data->user_email = $send_mail_to;
            $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
            $email_data->user_id = $user_id;
            $email_data->aflw_id = $article_details->aflw_id;
            $email_data->artp_id = $article_details->artp_id;
            $email_data->jnl_id = $article_details->jnl_id;
            $email_data->jnl_journal_code = $article_details->jnl_journal_code;
            $email_data->email_templates_config = $this->email_templates_config();
            if (isset($client->functionality->cfty_article_authors_tag) && $client->functionality->cfty_article_authors_tag == 'y')
                $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
            $email_data->join_config = $this->join_config();
            $email_data->join_dependency_config = $this->join_dependency_config();
            $email_data->user_role_tags = $this->user_role_tags();
            // TASK #8733 Reinstate the Reply-to Address Feature for Email Communication
            if(isset($email_template->stage_etmp_reply_to)&&$email_template->stage_etmp_reply_to!=''){
                $reply_to=$email_template->stage_etmp_reply_to;
            }else{
            $reply_to = $this->get_reply_to_email($article_details->jnl_id);
            }
            if (isset($reply_to) && $reply_to != '') {
                $email_data->reply_to = $reply_to;
            }
            if (isset($client->functionality->ctfy_bounce_back_reply_to_email)) {
                $email_data->ctfy_bounce_back_reply_to_email = $client->functionality->ctfy_bounce_back_reply_to_email;
            }
            if (isset($client->functionality->cfty_unique_hide_control_label_email) && $client->functionality->cfty_unique_hide_control_label_email == 'y')
                $email_data->cfty_unique_hide_control_label_email = $client->functionality->cfty_unique_hide_control_label_email;
                $data = array(
                    'record' => $email_template,
                    'email_data' => $email_data,
                    'user_data' =>$current_user,
                    'column_prefix' => $prefix,
                    'return_batch_id' => false,
                    'email_update_data' => [],
                    'production_status' => $production_status

                );
                $this->notify_mail($data);
        }
    }
}

        public function user_feedback_notification($post_data, $email_jnl_to){
            if(count($post_data) > 0) {
                $send_content   =   '';
                $jnl_id         =   $post_data['jnl_id'];

                if($jnl_id != '') {
                    $logged_user=   $this->get_current_user_details();
                    $user_id      = $logged_user['user_id'] ?? 0;
                } else {
                    $user_id    =   0;
                }

                if($post_data['contact_subject'] == 'custom'){
                    $subject    =   $post_data['custom_subject'];
                } else {
                    $select     =   $post_data['subj_category'];
                    $subject    =   $this->UserConfigdata($select)[$select][$post_data['contact_subject']];
                }
                // TASK #8907 contact us mail start
                $Email_templates = new \App\Models\Email_templates();

                $email_template_data = $Email_templates::get_single_record('*',"etmp_name='add_contact_us_mail'");
                if(!empty($email_template_data))
                {
                if(($email_template_data->etmp_notification=='Custom_to'||$email_template_data->etmp_notification=='Custom') && $email_jnl_to == ''){
                    $email_jnl_to=  $email_template_data->etmp_cust_to;
                }
                preg_match_all('/##([^##]*)##/', $email_template_data->etmp_email_template, $matches);
                $keys = $matches[1];
                $send_content=$email_template_data->etmp_email_template;
                if( $post_data['contact_jnlname'] !='' )
                {
                    $journal_table  =   new \App\Models\Journals();
                    $jnl_detail     =   $journal_table::get_single_record('jnl_journal_name', "jnl_journal_code ='{$post_data['contact_jnlname']}'");
                    if (in_array('CONTACT_JOURNAL_NAME', $keys))
                {
                    $send_content = str_ireplace('##CONTACT_JOURNAL_NAME##', $jnl_detail->jnl_journal_name, $send_content);
                }
                    
                }
                else{
                    $send_content = str_ireplace('##CONTACT_JOURNAL_NAME##', '', $send_content);
                }
                if( $post_data['contact_article_id'] != '')
                {
                    if (in_array('CONTACT_ARTICLE_ID', $keys))
                    {
                        $send_content = str_ireplace('##CONTACT_ARTICLE_ID##', $post_data['contact_article_id'], $send_content);
                    }
                }
                else{
                    $send_content = str_ireplace('##CONTACT_ARTICLE_ID##', '', $send_content);
                }
                $contact_title  =   '';
                if($post_data['contact_title'] != '') {
                    $contact_title   =   $this->UserConfigdata('titles')['titles'][$post_data['contact_title']] . '. ';
                }
                if( $post_data['contact_usrname'] != '')
                {
                    if (in_array('CONTACT_USERNAME', $keys))
                    {
                        $send_content = str_ireplace('##CONTACT_USERNAME##', $contact_title . ucwords($post_data['contact_usrname']), $send_content);
                    }

                }
                else{
                    $send_content = str_ireplace('##CONTACT_USERNAME##', '', $send_content);
                }
                if( $post_data['contact_comments'] != '')
                {
                    if (in_array('CONTACT_COMMENT', $keys))
                    {
                        $send_content = str_ireplace('##CONTACT_COMMENT##', $post_data['contact_comments'], $send_content);
                    }

                }
                else{
                    $send_content = str_ireplace('##CONTACT_COMMENT##', '', $send_content);
                }
                // TASK #69 contact us mail (task #8907)
                $ccemail_recipients_arr = array();
                $bccemail_recipients_arr = array();
                $cust_cc = $email_template_data->etmp_cust_cc;
                $cust_bcc = $email_template_data->etmp_cust_bcc;
            if (isset($email_template_data->etmp_cc) && $email_template_data->etmp_cc != "") {
                $cc_arr = json_decode($email_template_data->etmp_cc);
                array_push($ccemail_recipients_arr,Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['reply_to_email']);
                if (!empty($cc_arr) && $cc_arr != '') {
                    $ccemail_recipients_arr = $this->get_user_role_emails($cc_arr, '');
                }
            }
            else{
                $cc_arr='';
            }
            if ($cust_cc != "") {
                array_push($ccemail_recipients_arr, $cust_cc);
            }
            if (isset($email_template_data->etmp_cc) && ($email_template_data->etmp_cc != "")) {
                $cc_arr = json_decode($email_template_data->etmp_cc);
                if (isset($cc_arr)) {
                    foreach ($cc_arr as $c_arr) {
                        array_push($ccemail_recipients_arr, $c_arr);
                    }
                }
            }
            if (!empty($ccemail_recipients_arr)) {
                foreach ($ccemail_recipients_arr as $key => $value) {
                    if ($value == '') {
                        unset($ccemail_recipients_arr[$key]);
                    }
                }
                $cust_cc = implode(",", $ccemail_recipients_arr);
                $cust_cc = trim($cust_cc);
                $cust_cc = str_replace(' ', '', $cust_cc);
            }
            if (isset($email_template_data->etmp_bcc) && $email_template_data->etmp_bcc != "") {
                $bcc_arr = json_decode($email_template_data->etmp_bcc);
                if (!empty($bcc_arr) && $bcc_arr != '') {
                    $bccemail_recipients_arr = $this->get_user_role_emails($bcc_arr, '');
                }
            }
            else{
                $bcc_arr='';
            }
            if ($cust_bcc != "") {
                array_push($bccemail_recipients_arr, $cust_bcc);
            }
            if (!empty($bccemail_recipients_arr)) {
                foreach ($bccemail_recipients_arr as $key => $value) {
                    if ($value == '') {
                        unset($bccemail_recipients_arr[$key]);
                    }
                }
                $cust_bcc = implode(",", $bccemail_recipients_arr);
                $cust_bcc = trim($cust_bcc);
                $cust_bcc = str_replace(' ', '', $cust_bcc);
            }

                $pdata   =   array(
                                'fd_subject'=>$subject,
                                'fd_to_email'=>$email_jnl_to,
                                'fd_reply_to_email'=>$post_data['contact_email'],
                                'fd_jnl_id'=>$jnl_id,
                                'fd_cc_email_id'=>$cust_cc,
                                'fd_bcc_email_id'=>$cust_bcc,
                                'fd_art_code'=>$post_data['contact_article_id'],
                                'fd_comments'=>$send_content,
                                'fd_posted_by'=>$user_id,
                                'fd_proxy_id'=>0,
                                'fd_posted_date'=>date('Y-m-d H:i:s'),
                                'fd_email_status' => 'n',

                            );
                if (!empty($pdata)) {
                    $send_array['to']           =   $email_jnl_to;
                    $send_array['subject']      =   $subject;
                    $send_array['cc']           =   $cust_cc;
                    $send_array['bcc']          =   $cust_bcc;
                    $send_array['send_content'] =   $send_content;
                    $send_array['attachments']  =   '';
                    $send_array['jnl_id']       =   $jnl_id;
                    $send_array['reply_to']= isset($post_data['contact_email'])?$post_data['contact_email']:'';
                    $send_array['model'] = 'User_feedback';
                    $send_array['esl_id'] = User_feedback::insert_record($pdata);

                    //Send email
                    $mail_status    =   $this->trigger_email($send_array);

                    return $mail_status;
                }
                }
                else{
                    return false;
                }
            } else {
                return false;
            }
        }
            //Support #2545	ReViewer database clean up
    public function send_email_to_team_review($subject, $send_content, $attachment = NULL)
    {
        $email_config = 'clients.' . $this->current_client->clnt_client_code;
        $email_config_data = Config::get($email_config . '.email');
        $email_settings = $email_config_data['email_settings'];
        $return = FALSE;

      //  $config = $email_settings['email_config'];
        if (isset($email_settings['development_team'])) {
            $email_config = 'clients.' . $this->current_client->clnt_client_code ;
            $email_config_data=Config::get($email_config.'.email');
            $from_address_email =$email_config_data['email_settings']['email_from_address'];
            $from_name=$email_config_data['email_settings']['email_from_alias'];
            $toemail =  $email_settings['development_team'];
            $app_name=config('app.name');
            $header_part = customTrans('email.email_header_html');
            $header_part = str_replace('%app_name%',$app_name, $header_part);
            $footer_part=customTrans('email.email_footer_html');
            $unsubscribe_url =URL::to('/').'/unsubscribe-email/';
            $footer_part = str_replace(array('%client_name%','%user_unsbscribe_link%'), array($this->current_client->clnt_client_name,$unsubscribe_url), $footer_part);
            $wrapped_content=$this->wrap_email_content_body($send_content);

            $mailData = [
                'toemail'=>$toemail,
                'subject'=>$subject,
                'form_email'=>$from_address_email,
                'from_name'=>$from_name,
                'content'=>$send_content,
                'email_header_functionality'=>'y',
                'footer_content'=>$footer_part,
                'header_content'=>$header_part,
                'maincontent'=>$wrapped_content,
                'attachments'=>$attachment
            ];
         SendEmailJob::dispatch($mailData);
         $return = FALSE;
        }
        return $return;
    }

    public function send_review_reopen_mail($article_id, $jwf_fwm_id, $hdn_current_status_id, $record,$jnl_data,$post_data = NULL)
	{
        $Generic_flows = new \App\Models\Generic_flows;
        $Articles = new \App\Models\Articles;
        $Roles = new \App\Models\Roles;
        $User = new \App\Models\User;
		$workflow_details = $Generic_flows::get_single_record_with_bind_cond('jwf_assignment, jwf_parent_user_roles, jwf_who_can_invite, jwf_avoid_email_notifications_to_roles, jwf_stage_name , jwf_tat_complete', array(
			'jwf_id' => $jwf_fwm_id,
			'jwf_stage_type' => 'review'));
            $art_type = $Articles::get_single_record_with_bind_cond('art_artp_id', array(
                'art_id' => $article_id));
                if ($workflow_details != NULL && $art_type != NULL)
		{
			$send_to_roles = array();
			if ($workflow_details->jwf_assignment == 'manual')
			{
				$send_to_roles = json_decode($workflow_details->jwf_parent_user_roles);
			}
			elseif ($workflow_details->jwf_assignment == 'invitation')
			{
				$assigning_roles = json_decode($workflow_details->jwf_parent_user_roles);
				$invite_roles = json_decode($workflow_details->jwf_who_can_invite);
				$send_to_roles = array_unique(array_merge($assigning_roles, $invite_roles));
			}
			if (!empty($send_to_roles))
			{
				$avoid_email_notification_roles = array();
				if ($workflow_details->jwf_avoid_email_notifications_to_roles != '')
				{
					$avoid_email_notification_roles = json_decode($workflow_details->jwf_avoid_email_notifications_to_roles);
					$send_to_roles = array_diff($send_to_roles, $avoid_email_notification_roles);
				}
                $Authors = new \App\Models\Authors();
                $article_authors = $Authors::get_single_record('GROUP_CONCAT(auth_usr_id) as auth_ids','auth_art_id='.$article_id);
                $art_auth_arr = explode(',',$article_authors->auth_ids);
				$select = 'IF((SELECT COUNT("usra_id") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_usr_id NOT IN(' . implode(',', $art_auth_arr) . ') AND usra_role_id = role_id ) > 0, '
					. '(SELECT GROUP_CONCAT(usra_usr_id SEPARATOR ",") FROM rvw_user_articles WHERE usra_art_id = ' . $article_id . ' AND usra_usr_id NOT IN(' . implode(',', $art_auth_arr) . ')AND usra_role_id = role_id ), '
					. '(SELECT GROUP_CONCAT(usrj_usr_id SEPARATOR ",")  FROM rvw_user_journals WHERE usrj_role_id = role_id AND usrj_role_retired = \'n\' AND usrj_usr_id NOT IN(' . implode(',', $art_auth_arr) . ') AND usrj_artp_id = ' . $art_type->art_artp_id . ') ) AS user_id';
				$where = 'role_id IN(' . implode(',', $send_to_roles) . ')';
				$all_mail_receiver_ids = '';
				$all_usr_ids = $Roles::get_all_records($select, $where);
				foreach ($all_usr_ids as $usr_ids)
				{
					if ($usr_ids->user_id != NULL)
                    {
						$all_mail_receiver_ids .= $usr_ids->user_id . ',';
                    }
				}
                 
                $optccvalue = array();
                $record->etmp_cc = '';
                if(!empty($post_data['stage_template_to_cc']))
                {
                    $record->etmp_cc =json_encode($post_data['stage_template_to_cc']);
                }
              if (isset($post_data['stage_cust_cc'])&&!empty($post_data['stage_cust_cc']) && (in_array('Custom_cc',$post_data['stage_template_to_cc'])||in_array('Custom',$post_data['stage_template_to_cc']))) {
                    $custm_cc = $post_data['stage_cust_cc'];
                  for ($i = 0; $i < count($custm_cc); $i++) {
                $cust_value = isset($custm_cc[$i]['value']) ? $custm_cc[$i]['value'] : $custm_cc[$i];
                $cust_value = str_replace('\\', '"', $cust_value);
                $cust_value = htmlspecialchars(trim($cust_value), ENT_QUOTES);

                array_push($optccvalue, $cust_value);
            }
            $record->etmp_cust_cc= implode(',', $optccvalue);

        }
        $optbccvalue = array();
        $record->etmp_bcc = '';
        if(!empty($post_data['stage_template_to_bcc']))
        {
                   $record->etmp_bcc =json_encode($post_data['stage_template_to_bcc']);
        }
        if (isset($post_data['stage_cust_bcc'])&&!empty($post_data['stage_cust_bcc']) && (in_array('Custom_bcc',$post_data['stage_template_to_bcc'])||in_array('Custom',$post_data['stage_template_to_bcc']))) {
            $custm_bcc = $post_data['stage_cust_bcc'];
            for ($i = 0; $i < count($custm_bcc); $i++) {
            $cust_bcc_value = isset($custm_bcc[$i]['value']) ? $custm_bcc[$i]['value'] : $custm_bcc[$i];
            $cust_bcc_value = str_replace('\\', '"', $cust_bcc_value);
            $cust_bcc_value = htmlspecialchars(trim($cust_bcc_value), ENT_QUOTES);

            array_push($optbccvalue, $cust_bcc_value);

        }
        $record->etmp_cust_bcc = implode(',', $optbccvalue);
    }
  
                $more_rw_reason = '';
                if(isset($post_data['more_rw_reason']))
                {
                       $more_rw_reason = $post_data['more_rw_reason'];
                }
				$all_mail_receiver_ids = rtrim($all_mail_receiver_ids, ',');
				$all_mail_receiver_ids = implode(',', array_unique(explode(',', $all_mail_receiver_ids)));
				$email_data = new stdClass;
				$email_data->article_id = $article_id;
				$email_data->REOPENED_REVIEW_STAGE_NAME = $workflow_details->jwf_stage_name;
                $email_data->MORE_REVIEW_REASON = $more_rw_reason;
				$email_data->artp_id = $art_type->art_artp_id;
				$email_data->jnl_id = $jnl_data['jnl_id'];
				$email_data->jnl_journal_code = $jnl_data['jnl_code'];
				$email_data->aflw_id = $hdn_current_status_id; //for geting current stage name
				$email_data->email_templates_config = $this->email_templates_config();
                /* Task #1755 Incorrect stage due date is shown for review selection stage when user select more review from editor decisin stage.(due date in mail).*/
                $jset_date_format =  $this->get_platform_date_format($jnl_data['jnl_id']);
                $email_data->aflw_due_date = $this->get_due_date_for_article($article_id, $workflow_details->jwf_tat_complete,$jset_date_format);
				if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
					$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
				$email_data->join_config = $this->join_config();
				$email_data->join_dependency_config = $this->join_dependency_config();
				$email_data->user_role_tags = $this->user_role_tags();
                //$reply_to = $this->get_reply_to_email($jnl_data['jnl_id']);
				if (isset($post_data['stage_template_to_mail']) && $post_data['stage_template_to_mail']!= '' )
					$email_data->reply_to = $post_data['stage_template_to_mail'];
				$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;

				if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
					$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
                $current_user=$this->get_current_user_details();
               

			   $users = explode(',', $all_mail_receiver_ids);
               $send_mail_array=array();
               $send_to_array=array();
			   $art_status_link_array=array();
               $general_config = $this->General_config_data('mail_block_usr_status');
               $mail_block_usr_status = $general_config['mail_block_usr_status'];
				foreach ($users as $user_id)
				{

					$aflw_deeplink_token = Str::random(16);
					$user_data = $this->get_current_user_details();

					$res = $User::get_single_record('usr_email, usr_status, usr_deeplink_token', 'usr_id = ' . $user_id . ' AND usr_status NOT IN(' . $mail_block_usr_status . ')');

					if ($res)
					{

						if (!empty($res->usr_deeplink_token))
							$aflw_deeplink_token = $res->usr_deeplink_token;
						else
						{
							$User::update_record(array(
								'usr_deeplink_token' => $aflw_deeplink_token),"usr_id={$user_id}");
						}

                      $article_status_link = URL::to('/') . '/' . $this->current_client->platform_type . '/' . $jnl_data['jnl_code'] . '/view-article?' . encrypt_link('&article_id=' . $article_id . '&status_id=' . $hdn_current_status_id);
                      array_push($send_mail_array,$res->usr_email);
                      array_push($send_to_array,$user_id);
					  array_push($art_status_link_array,$article_status_link);
					}
				}
					$send_mail_to_usr_ids = implode(", ",$send_to_array);
				    $send_mail_to = implode(", ",$send_mail_array);

					    $email_data->ARTICLE_STATUS_LINK =$article_status_link;
						$email_data->user_email = $send_mail_to;
						$email_data->mail_recipient_ids = $send_mail_to_usr_ids;
						//$email_data->user_id = $send_mail_to_usr_ids;
                        $email_data->status_link_blind_event = TRUE;
						$email_data->esl_etmp_action = 'more_reviewer_updated';

					if (isset($record->etmp_email_template) && strpos($record->etmp_email_template,"OPENING_PARAGRAPH") > 0)
					$record->etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$record->etmp_email_template);
					$core_role=(isset($jnl_data['core_role']))?$jnl_data['core_role']:'';
					$email_data->core_role = $core_role;
					$core_role_name=(isset($jnl_data['core_role_name']))?$jnl_data['core_role_name']:'';
					$email_data->core_role_name = $core_role_name;

                        $replace_button = array('<button contenteditable="false">', '</button>');
                        $replaceval = str_replace($replace_button, '##', $record->etmp_email_template);
                        $record->etmp_email_template  = $replaceval;
                    $data = array(
                        'record' => $record,
                        'email_data' => $email_data,
                        'user_data' =>$current_user,
                        'column_prefix' =>'etmp_',
                    );

                    $this->notify_mail($data);
			}
		}

}
function custom_base64_encoded_data($data) {
    $encoded_data = rtrim($data, '=');
    return $encoded_data;
}

public function get_role_id_from_mail_to($mail_to, $aflw_id){
	$mail_to = strtolower($mail_to);
    if(in_array($mail_to, ['submitted author', 'corresponding author', 'all article authors', 'author', 'article_authors', 'submit_author'])){
        $role_id = Roles::select('role_id')->where('role_assigned_role', 'author')->get()?->first()?->role_id;
    }
	elseif($mail_to == 'stage assigned user' || $mail_to == 'user'){
        if(!$aflw_id)
            return null;
		$role_id = Article_flow::with('journal_workflow')->find($aflw_id)->journal_workflow->jwf_role_id;
	}
    else{
        $role_name = str_starts_with($mail_to, "all ") ? rtrim(substr($mail_to, 4), 's') : $mail_to;
        $role_id = Roles::select('role_id')->whereRaw("role_name like '%$role_name%'")->get()?->first()?->role_id;
    }

	return $role_id;
}

public static function filter_inactive_suspended_users($mail_recipient_ids, $to_array)
{
    $excluded_statuses = ['n','s','u']; //user statuses to be excluded from mail being sent ie inactive,suspended and unregistered.
    $excluded_emails = [];
        
        if (isset($mail_recipient_ids) && !empty($mail_recipient_ids)) {
            //checking user status for each mail recipient ids
            foreach ($mail_recipient_ids as $id) {
                $user_details = User::get_single_record_with_bind_cond('usr_email, usr_status', ['usr_id' => $id]);
                if (isset($user_details) && !empty($user_details) && in_array($user_details->usr_status, $excluded_statuses)) {
                    $excluded_emails[] = $user_details->usr_email; //pushing the email id to excluded email array if status n or s
                }
            }
        }

        $resultArray = [];
        if (!empty($excluded_emails) && !empty($to_array)) {
            foreach ($to_array as $email) {
                $removeValueFound = false;
                foreach ($excluded_emails as $excluded_email) {
                    if (isset($email) && $email === $excluded_email) {
                        $removeValueFound = true; //checking if mail id to be excluded is present in the to_array and flagging it.
                        break;
                    }
                }
                if (!$removeValueFound) {
                    $resultArray[] = $email; //pushing only the email ids which doesnt have the flag.
                }
            }
        } else {
            $resultArray = $to_array; //if no email id needs to excluded, the to_array is sent as it is.
        }

        return $resultArray;
}

        //to trigger cron for report mail
        public function cron_mail_trigger($send_report, $file_data, $report_generation_job_data){
            $email_jnl_to     =   Config::get('clients.'.$this->current_client->clnt_client_code.'.email.email_settings')['reply_to_email'];// TASK #8907 contact us mail

            if(!empty($send_report) > 0) {
                $Batch_id_generate_table = new \App\Models\Batch_id_generate();
                $batch_id = $Batch_id_generate_table::insert_batch_id();
                $log_data   =   array(
                    'esl_subject'     => $send_report->subject,
                    'esl_content'     => $send_report->rmil_covering_letter,
                    'esl_to'          => $send_report->rmil_send_to,
                    'esl_reply_to'    => $email_jnl_to,
                    'esl_cc'          => ($send_report->rmil_send_cc!=NULL) ? $send_report->rmil_send_cc : '',
                    'esl_success_status' => 'n',
                    'esl_batch_id'    =>  $batch_id,
                    'esl_attachments' => json_encode(array('article' => '', 'modified' => $send_report->attachment)),
                    'esl_posted_by'   => 0,
                    'esl_proxy_id'    => NULL,
                    'esl_posted_date' => date('Y-m-d H:i:s'),
                    'esl_operation'   => 'i'
                );
                if(!empty($log_data)){
                    $send_array['to']           =   $send_report->rmil_send_to;
                    $send_array['subject']      =   $send_report->subject;
                    $send_array['cc']           =   ($send_report->rmil_send_cc!=NULL) ? explode(',',$send_report->rmil_send_cc) : '';
                    $send_array['bcc']          =   '';
                    $send_array['send_content'] =   $send_report->rmil_covering_letter;
                    $send_array['attachments']  =   $file_data;
                    $send_array['jnl_id']       =   null;
                    $send_array['reply_to']     =   $email_jnl_to;
                    $send_array['model'] = 'Email_send_log';
                }
                $send_array['esl_id'] = Email_send_log::insert_record($log_data);
                $send_array['report_mail'] = true;
                $send_array['report_generation_job_data'] = $report_generation_job_data;
                
                //Send email
                $this->trigger_email($send_array);
                return $send_array;
            }else{
                return false;
            }
        }

    /* Task 6000 - To get user data from whoCanDoWhat permissions starts */
    public function permittedRoleUser($etmp_notification,$artp_id,$article_id)
    {
        $coll = (Object)NULL;
        $pUDropdown = permittedUserGlobalMail($etmp_notification);
        $pUColumn = isset($pUDropdown['value'])?$pUDropdown['value']:"";
        $pUColumnStr = ($pUColumn!="")?'REPLACE(REPLACE(REPLACE('.$pUColumn.',\'"\',""),"]",""),"[","") AS pu_column':"";
        $article_type_table = (new \App\Models\Article_types())->getTable();
        $jp_table = (new \App\Models\Journal_permission())->getTable();
        $user_to_journal = (new \App\Models\User_to_journals())->getTable();
        $tables = array(
                'main_table' => $jp_table,
                'join_table' => array(
                    $article_type_table => array('jp_jpm_id','artp_jpm_id')
                )
            );
        $criteria = ['artp_id' => $artp_id];
        $jpVal = Journal_permission::get_results_using_joins($tables,$pUColumnStr,$criteria,'single')->pu_column ?? "";
        if(!empty($jpVal)){
            $jpArr = array_map('intval',explode(',',$jpVal));
            $select_fields = ' GROUP_CONCAT(`usr_id`) AS usr_ids, GROUP_CONCAT(`usr_email`) AS usr_email';
            $Authors = new \App\Models\Authors;
            $results = $Authors::get_corresp_author_details($article_id);
            $authorArr = $results->isNotEmpty()?$results->pluck('usr_id')->all():[];
            $assignedUsers = User_articles::where('usra_art_id', $article_id)
                                        ->whereIn('usra_role_id', $jpArr)
                                        ->select('usra_usr_id','usra_role_id')
                                        ->get()
                                        ->groupBy('usra_role_id')
                                        ->map(function ($group) {
                                            return $group->pluck('usra_usr_id')->implode(',');
                                        });
         
            $users = User::join($user_to_journal, 'usr_id', '=', 'usrj_usr_id')
                        ->selectRaw($select_fields)
                        ->where(['usrj_artp_id' => $artp_id,'usrj_role_retired' => 'n'])
                        ->whereIn('usrj_role_id', $jpArr)
                        ->when($assignedUsers->isNotEmpty(), function ($query) use ($assignedUsers, $jpArr,$authorArr) {
                            $query->where(function ($mainQuery) use ($assignedUsers, $jpArr,$authorArr) {
                                foreach ($jpArr as $roleId) {
                                    $mainQuery->orWhere(function ($subQuery) use ($roleId, $assignedUsers,$authorArr) {
                                        if (isset($assignedUsers[$roleId])) {
                                            $assignedUserVal = explode(',',$assignedUsers[$roleId]);
                                            $subQuery->where('usrj_role_id', $roleId)
                                                ->whereIn('usrj_usr_id', $assignedUserVal);
                                        } else {
                                            $subQuery->where('usrj_role_id', $roleId)
                                                     ->whereNotIn('usrj_usr_id',$authorArr);
                                        }
                                    });
                                }
                            });
                        })
                        ->first();

            $coll->user_email = $users->usr_email ?? "";
            $coll->user_ids = $users->usr_ids ?? "";
        }
    return $coll;
    }
    /* Task 6000 - To get user data from whoCanDoWhat permissions ends */
    public function get_reviewe_rating_feedback($to_mail, $send_content, $keys, $article_id)
    {
        if ((isset($this->current_client->functionality->cfty_reviewer_rating_feedback) && $this->current_client->functionality->cfty_reviewer_rating_feedback === 'y') && in_array('FEEDBACK_TO_REVIEWER', $keys)) {
            if (!empty($article_id)) {
                $article_flow_table = (new \App\Models\Article_flow)->getTable();;
                $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                $rating_table = (new \App\Models\Review_rating())->getTable();
                $art_ids = array();

                $feedback = '';
                $feedback_value = array();
                $user_data = User::get_single_record_with_bind_cond('usr_id', array('usr_email' => $to_mail));
                $article_details = Articles::get_single_record_with_bind_cond('art_pre_all_ids,art_artp_id', array("art_id" => $article_id));
                $art_ids = ($article_details->art_pre_all_ids != NULL) ? $article_details->art_pre_all_ids : '';
                $art_ids = ($art_ids != '') ? $art_ids . ',' . $article_id : $article_id;
                $join  =   array(
                    'main_table' => $article_flow_table,
                    'join_table' => array(
                        $generic_flow_table => array($article_flow_table . '.aflw_jwf_id', $generic_flow_table . '.jwf_id')
                    )
                );
                $condition =  "aflw_parent_flow_id IS NOT NULL AND aflw_status = 'c' AND aflw_art_id IN ($art_ids) AND jwf_stage_type = 'review'";
                $Article_flow_details = Article_flow::get_results_using_joins($join, 'aflw_art_id', $condition, 'single', 'aflw_posted_date DESC', 1);
                if (!empty($Article_flow_details)) {
                    $artsub_id = $Article_flow_details->aflw_art_id; //store the latest art_id with latest reviewers
                }
                $join_tables         =   array(
                    'main_table' => $article_flow_table,
                    'join_table' => array(
                        $generic_flow_table => array($article_flow_table . '.aflw_jwf_id', $generic_flow_table . '.jwf_id'),
                        $rating_table   => array($article_flow_table . '.aflw_id',  $rating_table. '.rvr_aflw_id')
                    )
                );

                $criteria = "aflw_art_id = {$artsub_id} AND jwf_stage_type = 'review' and aflw_status = 'c' AND aflw_parent_flow_id IS NOT NULL AND rvr_reviewer_id={$user_data->usr_id} AND rvr_feedback IS NOT NULL";
                $select = "GROUP_CONCAT(rvr_feedback SEPARATOR '||') AS rvr_feedback,jwf_stage_name";
                $review_feedback = Article_flow::get_results_using_joins($join_tables, $select, $criteria, 'all',  NULL, NULL, '', NULL, NULL, FALSE, 'aflw_id');
                if (!empty($review_feedback) && count($review_feedback) > 0) {
                    $show_stage_name = false;
                    if (count($review_feedback) > 1) {
                        $show_stage_name = true;
                    }
                    foreach ($review_feedback as $individual_feedback) {
                        if ($show_stage_name == true) {
                            $feedback .= '<p><strong>Stage Name:' . $individual_feedback->jwf_stage_name . '</strong></p>';
                        }
                        $feedback_value = explode('||', $individual_feedback->rvr_feedback);
                        $show_count = false;
                        if (!empty($feedback_value) && count($feedback_value) > 0) {
                        if (count($feedback_value) > 1) {
                            $show_count = true;
                        }
                        $count = 1;
                        foreach ($feedback_value as $individual_value) {
                            if ($show_count == true) {
                                $feedback .= '<p><strong>Feedback #' . $count . '</strong></p>';
                            }
                            $feedback .= $individual_value;
                            $count++;
                        }
                        }
                    }
                    $send_content = str_ireplace("##FEEDBACK_TO_REVIEWER##", $feedback, $send_content);
                }
                else
                {
                    $send_content = str_ireplace("##FEEDBACK_TO_REVIEWER##", '' , $send_content);
                }
            }
        }
        return $send_content;
    }
}
