<?php

namespace App\Http\Traits;

use Config;
use DB;

trait InstituteSearchEngineTrait
{

    public function search_organisation($post_data, $search_in_ror, $family = false)
    {
        //ROR
        $institute_search_engine_config = 'clients.' . $this->current_client->clnt_client_code . '.institute_search_engine';
        $institute_search_engine  = Config::get($institute_search_engine_config);
        $search_key = trim($post_data['search_key']);
        if ($search_in_ror == true) {
            $ror_url = $institute_search_engine['ror']['url'];
            if ($post_data['page'] != NULL) {
                $page = '&page=' . $post_data['page'];
            }
            $api_url = $ror_url . '?query=' . urlencode($search_key) . $page;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Accept: application/json'
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $response = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($response, true);
            return $result;
        } else {
            $ringgold_url = $institute_search_engine['ringgold']['url'];
            if ((isset($institute_search_engine['ringgold']['rest_api_url']) && $institute_search_engine['ringgold']['rest_api_url'] != '')
                && (isset($institute_search_engine['ringgold']['rest_api_url_for_single_institution']) && $institute_search_engine['ringgold']['rest_api_url_for_single_institution'] != '')
            ) {
                if ($family == true) {
                    //Using REST API
                    $data = array(
                        'full' => 0,
                        'out' => 1,
                        'key' => $institute_search_engine['ringgold']['licenseKey']
                    );
                    $api_url    =    str_replace("{searchkey}", $search_key, $institute_search_engine['ringgold']['rest_api_url_for_single_institution']);
                } else {
                    $data = array(
                        'q' => $search_key,
                        'limit' => 100,
                        'ofr' => 0,
                        'out' => 2,
                        'key' => $institute_search_engine['ringgold']['licenseKey']
                    );
			        $api_url	=	$institute_search_engine['ringgold']['rest_api_url'];
                }
                $params = '';
                foreach($data as $key=>$value)
                {
                    $params .= $key.'='.$value.'&';
                }
                $params = trim($params, '&');
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $api_url.'?'.$params);
                curl_setopt($ch, CURLOPT_USERPWD, "myusername:mypassword");
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Accept: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                $response = curl_exec($ch);
                //Close cURL session
                curl_close($ch);
                $result = json_decode($response,true);
                // print_r($result);die;
                $return = array(
                    'status' => isset($result['data']) && !empty($result['data']) ? 'success' : 'error',
                    'response' => isset($result['data']) && !empty($result['data']) ? $result['data'] : '',
                    'api_call' => 'REST_API'
                );
                return json_encode($return, true);
            }
        }
        // $limit = $client_defaults['limit_keyword'];
    }
}
