<?php

namespace App\Http\Traits;

use DB;
use App\Models\Generic_flows;
use App\Models\Article_types;
use App\Models\Journals;
use App\Models\Articles;
use App\Models\Article_pdf;
use App\Models\Api_credentials;
use App\Models\Article_type_advance_options;
use Config;
use App\Http\Traits\StagemovementTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use App\Models\Ithenticate_autosubmission;
trait IthenticateTrait
{
    public $config_ithenticate = NULL;
	public static $login_attempt_counter = 0;
    public  function submit_to_ithenticate( $client_id,$article_id, $jnl_id, $pdf_id, $current_user, $aflw_id,$author_submit = FALSE)
    {
        $result = array(
			'status' => 'failed',
			'message' => customTrans('ithenticate.ithenticate_submission_failed'));
        
        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
        $ithenticateconfig  = Config::get($ithenticate_config);
        $condition = "art_id = {$article_id}";
        $article_data = Articles::get_single_record('art_title, art_artp_id, art_article_upload_path,art_submitted_by',$condition);
        $condition2 = "pdf_id = {$pdf_id}";
        $pdf_details = Article_pdf::get_single_record('*',  $condition2);
        if ($pdf_details == null)
		{
			return $result;
		}
        $condition3 = "atotp_artp_id = {$article_data->art_artp_id}";
        $art_type_advoptions = Article_type_advance_options::get_single_record('atotp_default_ithapi_folder', $condition3);
        $Authors = new \App\Models\Authors();
        $Authors_table = (new \App\Models\Authors())->getTable();
        $User_table = (new \App\Models\User())->getTable();
        $tables = array(
			'main_table' => $Authors_table,
			'join_table' => array(
                $User_table => array($User_table . '.usr_id', $Authors_table . '.auth_usr_id')
		));
        $select_fields ='usr_first_name as auth_first_name ,usr_middle_name as auth_mid_name, usr_last_name as auth_last_name,usr_email,auth_usr_id';

            $criteria = "auth_art_id={$article_id} and auth_corr_author='y'";
            $order_by = 'author_name';
		    $corresponding_author =  $Authors::get_results_using_joins($tables,$select_fields,$criteria, $order_by);
            
            $source_pdf_path= $this->get_upload_path($article_data->art_article_upload_path . DIRECTORY_SEPARATOR . $pdf_details->pdf_name,true);
            $destination_folder_name = $art_type_advoptions->atotp_default_ithapi_folder;
            $folder_group = '';
		    $directory_split = explode('/', $destination_folder_name);
		    if (count($directory_split) > 1)
		    {
			    $folder_group = trim($directory_split[0]);
			    $destination_folder_name = trim($directory_split[1]);
		    }

            if ($folder_group == '')
            {
                $folder_group = $ithenticateconfig['defualt_folder_group'];
            }
            if (!isset($current_user['user_id']))
            {
                $current_user = array(
                    'user_id' => 0,
                    'proxy_user_id'=>0
                );
            }

            if (file_exists($source_pdf_path))
		    {
                $ith_api_condition = array(
                    'acrd_clnt_id' => $client_id,
                    'acrd_api_name' => 'ithenticate',
                    'acrd_artp_id' => $article_data->art_artp_id,
                    'acrd_jnl_id' => $jnl_id
                );

                /**
                 * Task 5299 iThenticate V2 feature
                 */
                $ith_ver2 = FALSE;
                $ithv2_url = NULL;
                $ith_retry = 'false';
                if(isset($this->current_client->functionality->cfty_ithenticate_v2) &&  isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
                {
                    $sid = NULL;
                    
                    $ith_ver2 = TRUE;
                    $credential = $this->get_credentials($ith_api_condition);
                    if(isset($credential['password']))
                    {
                        $sid = $credential['password'];
                        $ithv2_url = $credential['username'];

                        //manage v1 ithenticate pdfs
                        if($pdf_details->pdf_ith_version == 'v1' /*&& $pdf_details->pdf_ith_document_id != null*/)
                        {
                            $ith_v1_data = array(
                                'pdf_ith_document_id' => null,
                                'pdf_ith_similarity_percentage' => 0,
                                'pdf_word_count' => 0,
                                'pdf_ith_similarity_response' => null,
                                'pdf_ith_report_url' => null,
                                'pdf_ith_view_only_url' => null,
                                'pdf_ith_view_only_expires' => null,
                                'pdf_ith_submission_status' => '',
                                'pdf_ith_version' => 'v2',
                                'pdf_ith_submission_message' => '',
                                'pdf_ith_report_date' => null
                            ); 
                            Article_pdf::update_record($ith_v1_data, $condition2, $current_user);
                        }
                    }
                }
                else
                {
                    $sid = $this->login_ithenticate($ith_api_condition);
                }

                $art_more_details = array();
                $upload_details = NULL;
                if ($sid != NULL)
                {
                    if($ith_ver2 == TRUE)
                    {
                        $ith_msg = 'webhook';
                        $folder_id = $this->create_webhook_if_not_exist($sid,$ithv2_url);
                    }
                    else
                    {
                        $ith_msg = 'folder';
                        $folder_id = $this->create_folder_if_not_exist($destination_folder_name, $sid, $ith_api_condition, $folder_group,$ith_ver2);
                    }
                    
                    
                    if ($folder_id != NULL)
                    {
                        $fileSize = true;
                        $file_size_in_bytes = filesize($source_pdf_path);
                        $file_size_in_mb = $file_size_in_bytes / (1024 * 1024);
                        if($file_size_in_mb <= 0 || $file_size_in_mb > 100)
                        {
                            $fileSize = false; 
                        }

                        if($ith_ver2 == TRUE && $fileSize == true)
                        {
                            $pending_art_submit= true;
                            //$pending_file_upload = TRUE;
                            if($pdf_details->pdf_ith_document_id != null)
                            {
                                $pending_art_submit= false;
                            }
                                

                            // if($pdf_details->pdf_ith_v2_fileupload_status == 'y')
                            //     $pending_file_upload= FALSE;    

                            //need to submit article
                            if($pending_art_submit == true)
                            {
                                $art_more_details = $this->get_more_article_details($article_id,$folder_id,$destination_folder_name,$author_submit);
                                $response = $this->do_call_v2($ithv2_url,$art_more_details,$sid,'POST','artsubmit');
                                $response_arr = (array) json_decode($response);
                            }
                            else
                            {
                                $response_arr = array(
                                    'id'=> $pdf_details->pdf_ith_document_id
                                );
                            }
                            
                            if(isset($response_arr['id']))
                            {
                                $body = array(
                                    'doc_id'=>$response_arr['id']
                                );
                                //here checking the article submit to ithenticate first step complete or not
                                $response_rep = $this->do_call_v2($ithv2_url,$body,$sid,'PUT','submit_status');
                                $response_rep_arr = (array) json_decode($response_rep);

                                $art_ithen_id = $response_arr['id'];
                                $repeat_status = false;
                                if(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'CREATED' && $pending_art_submit == true)
                                {
                                    $repeat_status = true;
                                    $upload_details = array(
                                        'pdf_ith_document_id' => $art_ithen_id,
                                        'pdf_ith_version' => 'v2'
                                    );
                                    Article_pdf::update_record($upload_details, $condition2, $current_user);
                                }
                                
                              /* if($pending_file_upload == TRUE)
                               {*/
                                    $art_more_details = array(
                                        'path'=>$source_pdf_path,
                                        'art_ith_id'=>$art_ithen_id
                                    );
                                    
                                    //upload file
                                    if(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'CREATED')
                                    {
                                        $response = $this->do_call_v2($ithv2_url,$art_more_details,$sid,'PUT','fileupload',$pdf_details->pdf_name);
                                        $repeat_status = true;
                                    }
                                    
                                    //get submission status
                                    if($repeat_status == true)
                                    {
                                        $repeat_status = true;
                                        $response_rep = $this->do_call_v2($ithv2_url,$body,$sid,'PUT','submit_status');
                                        $response_rep_arr = (array) json_decode($response_rep);
                                    }
                                    
                                    if(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'COMPLETE')
                                    {
                                        $upload_details = array(
                                            'id' => $art_ithen_id
                                        );
                                        $update_data = array(
                                            'pdf_ith_submission_status' => 'S',
                                            'pdf_word_count'=> $response_rep_arr['word_count'],
                                            'pdf_ith_v2_action_type' => 'c',
                                            'pdf_ith_v2_fileupload_status' => 'y',
                                            'pdf_ith_submission_message' => customTrans('ithenticate.ithenticate_submit_success')
                                        );
                                        $cond = "pdf_id = {$pdf_id} and pdf_ith_submission_status != 'S'";
                                        Article_pdf::update_record($update_data, $cond, $current_user);

                                        //CALL REPORT GENERATION FUNCTION
                                        $similarity_report = $this->similarity_report($art_ithen_id, $sid, $ith_api_condition,$article_data->art_artp_id);
                                    }
                                    elseif(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'PROCESSING')
                                    {
                                        $upload_details = array(
                                            'pdf_ith_v2_action_type' => 'sp', //submission inprogress
                                            'pdf_ith_v2_action_date' => date('Y-m-d H:i:s')
                                        );
                                        //if already submission in progress then no need to update again
                                        $cond = "pdf_id = {$pdf_id} and pdf_ith_v2_action_type != 'sp'";
                                        Article_pdf::update_record($upload_details, $cond, $current_user);
                                     }
                                    else
                                    {
                                        $this->retryIthenticatev2($pdf_id,$article_data->art_artp_id,$client_id,$current_user,'sp',$ith_retry);
                                        $ith_retry = 'true';
                                    }
                                //}
                            }
                            else
                            {
                                if(trim($pdf_details->pdf_ith_document_id) == null || empty($response_arr))
                                {
                                    //MAY BE ITHENTICATE DOWN
                                    //IF NEEDED RETRY THEN UNCOMMENT BELOW FUNCTION
                                   // $this->retryIthenticatev2($pdf_id,$article_data->art_artp_id,$client_id,$current_user,'i',$ith_retry);
                                   $ith_retry = 'down';
                                }
                                $this->error_message = $this->process_error($response_arr,true,'submission');
                            }
                        }
                        elseif($fileSize == false)
                        {
                            $ith_retry = 'sizeissue';
                        }
                        else
                        {
                            $upload_details = $this->upload($sid, $source_pdf_path, $folder_id, $article_data->art_title, $pdf_details->pdf_name, $corresponding_author[0]->auth_first_name, $corresponding_author[0]->auth_last_name, $ith_api_condition);
                        }
                        
                        if (!empty($upload_details) || $ith_retry == 'true')
                        {
                            if($ith_ver2 == FALSE)
                            {
                                $update_data = array(
                                    //'pdf_ith_document_id' => '\''.$upload_details['id'].'\'',
                                    'pdf_ith_document_id' => $upload_details['id'],
                                    'pdf_ith_submission_status' => 'S',
                                    'pdf_ith_submission_message' => customTrans('ithenticate.ithenticate_submit_success')
                                );
                                
                                $criteriaupdate = "pdf_id={$pdf_id} ";
                                Article_pdf::update_record($update_data, $criteriaupdate, $current_user);
                            }
                            $pending_html = '<span class="" id="pending_ithenticate_report">Generating Similarity Report</span>';
                            $result = array(
                                'status' => 'success',
                                'message' => customTrans('ithenticate.ithenticate_submit_success'),
                                'html' => $pending_html,
                            );
                            $result['try_report'] = 'true';
                            if($ith_retry == 'true')
                            {
                                $result['try_report'] = 'false';
                            }
                            if(isset($upload_details['id']))
                            {
                                $result['doc_id'] = $upload_details['id'];
                            }
                                
                        }elseif($ith_retry == 'down')
                        {
                            $result['message'] = customTrans('ithenticate.ithenticate_down');
                            self::log_ithenticate_call("Response::\r\n SERVER DOWN pdf id is:".$pdf_id );
                        }
                        elseif($ith_retry == 'sizeissue')
                        {
                            $result['message'] = customTrans('ithenticate.ithenticate_filesize');
                            self::log_ithenticate_call("Response::\r\n PDF FILE SIZE ISSUE pdf id is:".$pdf_id );
                        }
                        else
                        {
                            $result['message'] = 'Error while uploading pdf.Try once more'; //$this->error_message;
                            self::log_ithenticate_call("Response::\r\n".$result['message'].' pdf id is:'.$pdf_id );
                        }
                       
                    
                    }else
                    {
                        $result['message'] = 'Error in creating '.$ith_msg; 
                        self::log_ithenticate_call("Response::\r\n".$result['message'].' pdf id is:'.$pdf_id );
                    }
                }else
                {
                    $result['message'] = 'Error while connecting'; 
                    self::log_ithenticate_call("Response::\r\n".$result['message'].' pdf id is:'.$pdf_id );
                }
               
            }else{
                $result['message'] = customTrans('ithenticate.gnePdfmissing');
                self::log_ithenticate_call("Response::\r\n File does not exits.pdf id is:".$pdf_id);
            }

            if ($result['status'] == 'failed')
            {
                $update_data = array(
                    'pdf_ith_submission_status' => 'F',
                    'pdf_ith_submission_message' => $result['message']
                );
                if ($current_user == NULL)
                {
                    $update_data['pdf_posted_by'] = 0;
                }
                
                $criteriaupdate = "pdf_id={$pdf_id} ";  
                Article_pdf::update_record($update_data, $criteriaupdate, $current_user);

            }
           return $result;
          
        
    }
    public static function log_ithenticate_call($request)
	{
		$app_log = General_ConfigTraits::General_config_data('ITHENTICATE_LOG_PATH');
		$app_log_path = $app_log['ITHENTICATE_LOG_PATH'];
		if (file_exists($app_log_path) == FALSE)
			mkdir($app_log_path,0777);
		// if (file_exists($app_log_path) == FALSE)
		// 	mkdir($app_log_path,0777);
		$log_file = $app_log_path . date("dmY", time()) . ".log";
		$handle = fopen($log_file, "a+");
		fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $request . "\r\n\r\n\r\n");
		fclose($handle);
	}
    public function upload($sid, $source_file_path, $destination_folder, $article_title, $file_name, $author_first_name, $author_last_name, $criteria, $submit_to = 1)
	{
        $upload_detail = NULL;
        $content = file_get_contents($source_file_path);
        $article_title = str_replace(array("<p>","</p>"),"",$article_title);
        $file = array(
			"filename" => $file_name,
			"author_last" => $author_last_name,
			"upload" => base64_encode($content),
			"title" => htmlentities($article_title), // htmlentities added -  article title with  "ϕ" couldn't upload. Bug #1795 - JPR-208 Paper won't send to ithenticate
			"author_first" => $author_first_name
		);
        $document = array(
			"sid" => $sid, //Get this SID using the login option
			"uploads" => array(
				$file),
			"submit_to" => $submit_to,
			"folder" => $destination_folder
		);

        $request = xmlrpc_encode_request('document.add', array(
			$document), array(
			'encoding' => 'UTF-8'));
            $request_dom = new \DOMDocument();
            $request_dom->loadXML($request);
            $request_xpath = new \DOMXPath($request_dom);
            $upload = $request_xpath->query('//text()[normalize-space(.)="upload"]/ancestor::member[ancestor::array]');
            if ($upload->length > 0)
		    {
                $upload = $upload->item(0);
                $string_tag = $request_xpath->query('.//string', $upload);
			    $string_tag = $string_tag->length > 0 ? $string_tag->item(0) : NULL;
                if ($string_tag != NULL)
			    {
                    $base64_tag = $request_dom->createElement('base64');
                    while ($string_tag->hasChildNodes())
                    {
                        $base64_tag->appendChild($string_tag->childNodes->item(0));
                    }
                    $string_tag->parentNode->insertBefore($base64_tag, $string_tag);
                    $string_tag->parentNode->removeChild($string_tag);
                }
                $request = $request_dom->saveXML();
                $response = $this->do_call($request);
			    $response_arr = xmlrpc_decode($response);
                if (is_array($response_arr) && $response_arr['api_status'] == 200)
                    {
                        $upload_detail = $response_arr['uploaded'][0];
                    }
                    else
                    {
                        //$this->error_message = $this->process_error($response_arr);
                    }

            }else
            {
               // $this->error_message = lang('uplaod_request_error');
            }
            if ($upload_detail == NULL && $response_arr['api_status'] == 401)
            {
                $sid = $this->login_ithenticate($criteria, TRUE);
                if ($sid != NULL)
                {
                    $upload_detail = $this->upload($sid, $source_file_path, $destination_folder, $article_title, $file_name, $author_first_name, $author_last_name, $criteria);
                }
            }
            return $upload_detail;
           
            
    }
    public function login_ithenticate(&$criteria, $force_login = false)
	{

        $ith_sid = null;
        /**
         * Task 5299 iThenticate V2 feature
         */
        $ith_ver2 = false;
        if(isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
        {
                $ith_ver2 = true;
        }
        /*if($ith_ver2 == TRUE)
        {
            $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
            $ithenticateconfig  = Config::get($ithenticate_config);
            if(isset($ithenticateconfig['api_key']))
                $ith_sid = $ithenticateconfig['api_key'];
        }
        else
        {*/
            $credential = $this->get_credentials($criteria);
        
            if ($credential != null)
            {
            if(empty($credential['details']['acrd_artp_id']))
            {
                $credential['details']['acrd_artp_id']='NULL';
            }
            if(empty($credential['details']['acrd_jnl_id']))
            {
                $credential['details']['acrd_jnl_id']='NULL';
            }

            
                $criteria['acrd_artp_id'] = $credential['details']['acrd_artp_id'];
                $criteria['acrd_jnl_id'] = $credential['details']['acrd_jnl_id'];
                if($ith_ver2 == true)
                {
                    $ith_sid = $credential['password'];
                }
                elseif ($credential['details']['acrd_key'] != '' && $force_login === false)
                {
                    $ith_sid = $credential['details']['acrd_key'];
                }elseif($ith_ver2 == false){
                    if (self::$login_attempt_counter <= 1)
                    {
                        self::$login_attempt_counter++;
                        $super_key = $credential['details']['acrd_key'];
                        unset($credential['details']);
                        
                        //$request = xmlrpc_encode_request('login', $credential);
                        /*if($ith_ver2 == TRUE)
                        {
                            $request = xmlrpc_encode_request('login', $credential);
                            $response = $this->do_call_v2($request,$super_key);
                        }
                        else
                        {*/
                            $request = xmlrpc_encode_request('login', $credential);
                            $response = $this->do_call($request);
                    // }
                            
                        $response_arr = xmlrpc_decode($response);
                        if (is_array($response_arr) && isset($response_arr['api_status']) && $response_arr['api_status'] == 200)
                        {
                            $ith_sid = $response_arr['sid'];
                            $criteria6 = "acrd_clnt_id={$criteria['acrd_clnt_id']} AND acrd_api_name='{$criteria['acrd_api_name']}' ";  
                            Api_credentials::update_record(array(
                                'acrd_key' => $ith_sid), $criteria6);
                                
                        }

                    }
                    else
                    { 
                        self::$login_attempt_counter = 0;
                    }



                }
            //}
        }
        return $ith_sid;
       
    }
    public function create_folder_if_not_exist($directory_name, $sid, $criteria, $folder_group = '',$ith_ver2 = FALSE)
	{
       
        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
        $ithenticateconfig  = Config::get($ithenticate_config);
        $folder_id = NULL;
        if ($folder_group == '')
        {
            $folder_group = $ithenticateconfig['defualt_folder_group'];
        }

        /**
                 * Task 5299 iThenticate V2 feature
                 */
        if($ith_ver2 == TRUE)
        {
            //for fetch folder group
            $data = array(
                'id'=> $sid
            );
            $response = $this->do_call_v2($folder_group,$data,$sid,'GET','group');
            $response_arr = (array) json_decode($response);
            
            if(isset($response_arr['id']))
            {
                if(isset($response_arr['name']) && $response_arr['name'] == $directory_name)
                {
                    $folder_id = $response_arr['id'];
                }
                else
                {
                    //create folder
                    $data = array(
                        'name'=> $directory_name,
                        'type' => 'FOLDER',
                        'report_generation' => 'IMMEDIATELY'
                    );
                    $response = $this->do_call_v2($folder_group,$data,$sid,'PUT','group');
                    $response_arr = (array) json_decode($response);
                    if(isset($response_arr['id']))
                    {
                        $folder_id = $response_arr['id'];
                    }
                    else
                    {
                        $this->error_message = $this->process_error($response_arr,TRUE,'create_folder');
                    }
                }
            }
            else
            {
                $this->error_message = $this->process_error($response_arr,TRUE,'get_folder');
            }
        }
        else
        {

            $group_id = $this->get_folder_group($folder_group, $sid, $criteria);
            if ($group_id != NULL)
            {
                    $list_folders = array(
                        'sid' => $sid);
                    $request = xmlrpc_encode_request('folder.list', $list_folders);  
                    $response = $this->do_call($request);
                    $response_arr = xmlrpc_decode($response);
                    if (is_array($response_arr) && $response_arr['api_status'] == 200)
                    {
                        $folders = $response_arr['folders'];
                        foreach ($folders as $folder)
                        {
                            if ($folder['name'] == $directory_name && $folder['group']['id'] == $group_id)
                            {
                                $folder_id = $folder['id'];
                                break;
                            }
                        }
                        if ($folder_id == NULL)
                        {
                            
                            $create_folders = array(
                                'sid' => $sid,
                                'folder_group' => $group_id,
                                'name' => $directory_name,
                                'description' => 'This is a test',
                                'exclude_quotes' => TRUE);
                            $request = xmlrpc_encode_request('folder.add', $create_folders);
                            $response = $this->do_call($request);
                            $response_arr = xmlrpc_decode($response);
                            if (is_array($response_arr) && $response_arr['api_status'] == 200)
                                {
                                    $folder_id = $response_arr['id'];
                                }
                                else
                                {
                                // $this->error_message = $this->process_error($response_arr);
                                }

                        }

                    }
                    else
                    {
                    //$this->error_message = $this->process_error($response_arr);
                    }
                
            }
            if($folder_id == NULL && isset($response_arr['api_status'] ) && $response_arr['api_status'] == 401)
            {
                $sid = $this->login_ithenticate($criteria, TRUE);
                if ($sid != NULL)
                {
                    $folder_id = $this->create_folder_if_not_exist($directory_name, $sid, $criteria);
                }
    
            }
        }
       
        return $folder_id;
  }
    public function get_folder_group($group_name, $sid, $criteria)
	{
        
		$group_id = NULL;
        if(isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
        {
            $due_date = '';
            $get_folder_group = array(
                'name'=>$group_name,
                'type' => 'FOLDER',
                "report_generation"=> "IMMEDIATELY"
            );
            $response = $this->do_call_v2($get_folder_group,$sid,'folder_group');
        }
        else
        {
            $get_folder_group = array(
                'sid' => $sid);
            $request = xmlrpc_encode_request('group.list', $get_folder_group);
            $response = $this->do_call($request);
        }
        
        
        $response_arr = xmlrpc_decode($response);
        if (is_array($response_arr) && $response_arr['api_status'] == 200)
		{
            $groups = $response_arr['groups'];
            foreach ($groups as $group)
			{
				if ($group['name'] == $group_name)
				{
                   
					$group_id = $group['id'];
					break;
				}
			}if ($group_id == NULL)
			{
                $create_folder_group = array(
					'sid' => $sid,
					'name' => $group_name);
				$request = xmlrpc_encode_request('group.add', $create_folder_group);
				$response = $this->do_call($request);
				$response_arr = xmlrpc_decode($response);
                if (is_array($response_arr) && $response_arr['api_status'] == 200)
				{
					$group_id = $response_arr['id'];
				}
				else
				{
					$this->error_message = $this->process_error($response_arr);
				}

            }

        }else
		{
			$this->error_message = $this->process_error($response_arr);
		}
        if ($group_id == NULL && $response_arr['api_status'] == 401)
		{
			$sid = $this->login_ithenticate($criteria, TRUE);
			if ($sid != NULL)
			{
				$group_id = $this->get_folder_group($group_name, $sid, $criteria);
			}
		}
		return $group_id;
    }
    protected function do_call($request)
	{

        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
        $ithenticateconfig  = Config::get($ithenticate_config);
        $url = $ithenticateconfig['api_url'];
		$header[] = "Content-type: text/xml";
		$header[] = "Content-length: " . strlen($request);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 600);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request);

		$data = curl_exec($ch);
		if (curl_errno($ch))
		{
			print curl_error($ch);
		}
		else
		{
			curl_close($ch);
			return $data;
		}
	}
    public function get_credentials($criteria = array())
	{
        $credential = array();
        if (!empty($criteria))
		{
            $ithV2 = false;
            if(isset($this->current_client->functionality->cfty_ithenticate_v2) &&  isset($this->current_client->modules->mdl_ithenticate) && $this->current_client->modules->mdl_ithenticate == 'y' && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
            {
                $ithV2 = true;
            }
           $criteria1 = "acrd_clnt_id={$criteria['acrd_clnt_id']} AND acrd_api_name='{$criteria['acrd_api_name']}' AND  acrd_artp_id={$criteria['acrd_artp_id']} AND acrd_jnl_id={$criteria['acrd_jnl_id']}";
            $select_fields = 'acrd_user_name, acrd_password, acrd_key, acrd_artp_id, acrd_jnl_id';
            //Task 9475 Update ithenticate v2 functions related with new changes
            if($ithV2 == true)
            {
                $select_fields .= ',acrd_eula,acrd_ith_v2_view_settings,acrd_ith_v2_add_to_index,acrd_ith_v2_save_changes,acrd_ex_mch_cnt,acrd_id';
            }
           $api_config = Api_credentials::get_single_record($select_fields, $criteria1);
           if ($api_config == NULL)
			{
                $criteria2 = "acrd_clnt_id={$criteria['acrd_clnt_id']} AND acrd_api_name='{$criteria['acrd_api_name']}' AND  acrd_artp_id IS NULL AND acrd_jnl_id={$criteria['acrd_jnl_id']}";  
                $api_config = Api_credentials::get_single_record($select_fields, $criteria2);
                if ($api_config == NULL)
                {
                    $criteria3 = "acrd_clnt_id={$criteria['acrd_clnt_id']} AND acrd_api_name='{$criteria['acrd_api_name']}' AND  acrd_artp_id IS NULL AND acrd_jnl_id IS NULL";  
                    $api_config = Api_credentials::get_single_record($select_fields, $criteria3);  
                }
                
            }
            if ($api_config != NULL)
			{
                $credential = array(
					'password' => decrypt_link($api_config->acrd_password),
					'username' => $api_config->acrd_user_name,
					'details' => array(
						'acrd_key' => $api_config->acrd_key,
						'acrd_artp_id' => $api_config->acrd_artp_id,
						'acrd_jnl_id' => $api_config->acrd_jnl_id));
                if($ithV2 == true)
                {
                    $credential['details']['acrd_id'] = $api_config->acrd_id;
                    $credential['details']['acrd_eula'] = $api_config->acrd_eula;
                    $credential['details']['acrd_ith_v2_view_settings'] = $api_config->acrd_ith_v2_view_settings;
                    $credential['details']['acrd_ith_v2_add_to_index'] = $api_config->acrd_ith_v2_add_to_index;
                    $credential['details']['acrd_ith_v2_save_changes'] = $api_config->acrd_ith_v2_save_changes;
                    $credential['details']['acrd_ex_mch_cnt'] = $api_config->acrd_ex_mch_cnt;
                }

            }

        }
        return $credential;

    }
    public function process_error($response_arr,$ith_v2 = FALSE,$section = '')
	{
		$error_message = "";
        
		if (is_array($response_arr))
		{
            if($ith_v2 == TRUE)
            {   
                $this->error_status = '';
                if(isset($response_arr['status']))
                    $this->error_status = $response_arr['status'];
            }
            else
            {
                $this->error_status = $response_arr['api_status'];
            }
			
			if ($this->error_status == 401)
			{
				$error_message = customTrans('ithenticate.ithenticate_401');
			}
            elseif ($section == 'fileupload' && $this->error_status == 409)
			{
				$error_message = trans('ithenticate.fileupload_ithenticate_409');
			}
            elseif ($section == 'fileupload' && $this->error_status == 422)
			{
				$error_message = trans('ithenticate.fileupload_ithenticate_file_min_size_422');
			}
            elseif ($section == 'fileupload' && $this->error_status == 413)
			{
				$error_message = trans('ithenticate.fileupload_ithenticate_file_min_size_413');
			}
            elseif ($section == 'report_schedule' && $this->error_status == 409)
			{
				$error_message = trans('ithenticate.report_schedule_ithenticate_409');
			}
            elseif ($section == 'get_folder' && $this->error_status == 404)
			{
				$error_message = trans('ithenticate.get_folder_ithenticate_404');
			}
            elseif ($section == 'create_folder' && $this->error_status == 404)
			{
				$error_message = trans('ithenticate.create_folder_ithenticate_404');
			}
            elseif($section == 'submission' || $section == 'fileupload')
            {
                $error_message = customTrans('ithenticate.ithenticate_submit_err');
            }
			elseif (isset($response_arr['errors']) && $ith_v2 != TRUE)
			{
				$errors = $response_arr['errors'];
				foreach ($errors as $key => $error)
				{
					$error_message .= $key . ' : ' . implode(',', array_values($error));
				}
			}
			elseif (isset($response_arr['messages']))
			{
				$errors = $response_arr['messages'];
				$error_message .= implode(',', array_values($errors));
			}
            elseif($ith_v2 == TRUE)
            {
                $error_message = customTrans('ithenticate.ithenticate_submit_err');
            }
		}
		else
		{
			$error_message = customTrans('ithenticate.ithenticate_no_response');
		}
        self::log_ithenticate_call("Response::\r\n".$error_message);
		return $error_message;
	}
    public function similarity_report($document_id, $sid, $criteria,$artp_id = NULL)
	{
        $similarity_report = NULL;
        $status_details = $this->document_status($document_id, $sid, $criteria,$artp_id);
        
        if ($status_details != NULL && $status_details['is_pending'] == 0)
		{
            $ith_v2 = FALSE;
            $ithv2_url = NULL;
            if(isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
            {
                $credential = $this->get_credentials($criteria);
                $ithv2Settings = $this->getithV2credentials($credential);
                if(isset($credential['username']))
                {
                    $ithv2_url = $credential['username'];
                }
                    
                $ith_v2 = TRUE;

                $Artpdf = new \App\Models\Article_pdf();
                $Artpdf_table = (new \App\Models\Article_pdf())->getTable();
                $Article_table = (new \App\Models\Articles())->getTable();
                $tables = array(
                    'main_table' => $Artpdf_table,
                    'join_table' => array(
                        $Article_table => array('pdf_art_id','art_id'),
                ));
                $select ='art_submitted_by,pdf_word_count,pdf_ith_similarity_percentage,pdf_ith_report_date';
                $criteria = "pdf_ith_document_id = '{$document_id}'";
                
                $art_details =  $Artpdf::get_results_using_joins($tables,$select,$criteria,'single');

                //prepare similarity link array
                $data_arr = array(
                    'doc_id'=> $document_id,
                    "viewer_user_id" => 'rv_user_'.$art_details->art_submitted_by,
                    "locale"=>"en",
                    "viewer_default_permission_set"=> "EDITOR",
                    "similarity"=> array(
                        "view_settings"=> $ithv2Settings['save_changes']
                    ),
                );
                
                //$folder_group = $status_details['folder_group'];
                $response = $this->do_call_v2($ithv2_url,$data_arr,$sid,'','viewer_url');
                $response_arr = (array) json_decode($response);
                if(isset($response_arr['viewer_url']))
                {
                    $update_data = array(
                        'pdf_ith_report_url' => $response_arr['viewer_url'],
                        'pdf_ith_view_only_url' => $response_arr['viewer_url'],
                    );
                    
                    $cond = 'pdf_ith_document_id = \''.$document_id.'\' AND pdf_ith_report_url IS NULL';
                    $current_user = array(
                        'user_id' => 0,
                        'proxy_user_id' => 0
                    );
                    if (isset($this->current_user))
                    {
                        $current_user = $this->current_user;
                    }
                    Article_pdf::update_record($update_data, $cond,$current_user);

                    $similarity_report = array(
                        'report_url' => $response_arr['viewer_url'],
                        'view_only_url' => $response_arr['viewer_url'],
                        'percent_match' => $art_details->pdf_ith_similarity_percentage,
                        'words' => $art_details->pdf_word_count,
                        'is_pending' => 0,
                        // 'view_only_expires' => date('Y-m-d H:i:s', $response_arr['view_only_expires']->timestamp),
                        'response_timestamp' => $art_details->pdf_ith_report_date
                    );
                }
                else
                {
                    $this->error_message = $this->process_error($response_arr,TRUE);
                }   
            }
            else
            {
                $request_arr = array(
                    "sid" => $sid,
                    "id" => $status_details['status_id'],
                    "exclude_quotes" => 1,
                    "exclude_biblio" => 1,
                    "exclude_small_matches" => 1
                );
                $request = xmlrpc_encode_request('report.get', array(
                    $request_arr));
                $response = $this->do_call($request);
                $response_arr = xmlrpc_decode($response);
            }
            if($ith_v2 == FALSE)
            {
                if (is_array($response_arr) && $response_arr['api_status'] == 200)
                {
                    $similarity_report = array(
                        'report_url' => $response_arr['report_url'],
                        'view_only_url' => $response_arr['view_only_url'],
                        'percent_match' => $status_details['percent_match'],
                        'words' => $status_details['words'],
                        'view_only_expires' => date('Y-m-d H:i:s', $response_arr['view_only_expires']->timestamp),
                        'response_timestamp' => date('Y-m-d H:i:s', $response_arr['response_timestamp']->timestamp)
                    );
                    $this->update_pdf_details($document_id, $similarity_report);

                }else
                {
                    $this->error_message = $this->process_error($response_arr);
                    if ($this->error_status == 401)
                    {
                        $sid = $this->login_ithenticate($criteria, TRUE);
                        $similarity_report = $this->similarity_report($document_id, $sid, $criteria,$artp_id);
                    }

                }
            }
            

        }else{
            $similarity_report = array(
				'is_pending' => TRUE);
               // $this->error_message = customTrans('ithenticate.ithenticate_pending_report');

        }
        return $similarity_report;

    }
    private function update_pdf_details($document_id, $similarity_report)
	{
        $this->current_user = $this->get_current_user_details();
        $criteriaupdates = "pdf_ith_document_id='{$document_id}'";
        $article_pdf_data   =   Article_pdf::get_single_record('pdf_id, pdf_ith_report_date', $criteriaupdates);
        $update_data        =   array(
            'pdf_ith_report_url' => $similarity_report['report_url'],
            'pdf_ith_view_only_url' => $similarity_report['view_only_url'],
            'pdf_ith_view_only_expires' => $similarity_report['view_only_expires'],
            'pdf_ith_similarity_percentage' => $similarity_report['percent_match'],
            'pdf_word_count' => $similarity_report['words']
        );
        if(!empty($article_pdf_data)){
            $report_date    =   $article_pdf_data->pdf_ith_report_date;
            if($report_date == null || $report_date == ''){
                $update_data['pdf_ith_report_date']  =    $similarity_report['response_timestamp'];
            }

        }
        $criteriaviewurl = "pdf_ith_document_id='{$document_id}' ";  
        Article_pdf::update_record($update_data, $criteriaviewurl,$this->current_user);
    return true;
    }
     //When a webhook is called, a manual ithenticate submission is made using the proxy ID and posted by from the prior record.
     public function posted_poxy_status($document_id)
     {
         $data_check_postedby= array(
             'pdf_ith_document_id'=>$document_id
         );
         $checkdata =Article_pdf::get_single_record_with_bind_cond('pdf_posted_by,pdf_proxy_id',$data_check_postedby); 
         if(!empty($checkdata))
         { 
             $current_user = array(
                 'user_id' => $checkdata->pdf_posted_by,
                 'proxy_user_id' => $checkdata->pdf_proxy_id
                 );
         }else
         {
             $current_user = array(
                 'user_id' => 0,
                 'proxy_user_id' => 0
                 );
         }
         return $current_user;
     }
    public function document_status($document_id, $sid, $criteria,$artp_id)
    {
        $status_details = NULL;
        //$ith_ver2 = FALSE;
        if(isset($this->current_client->functionality->cfty_ithenticate_v2) && $this->current_client->functionality->cfty_ithenticate_v2 == 'y')
        {
            $this->current_user = $this->get_current_user_details();
            $word_cnt = 0;
            $ithv2_url = NULL;
            $credential = $this->get_credentials($criteria);
            $ithv2Settings = $this->getithV2credentials($credential);
            if(isset($credential['username']))
            {
                $ithv2_url = $credential['username'];
            }
            if (!isset($this->current_user['user_id']))
            {
                
                $current_user=$this->posted_poxy_status($document_id);
            }else
            {
                $current_user = $this->current_user;
                $current_user=$this->current_user;  
            }

            $artpdf = new \App\Models\Article_pdf();
            $select ='pdf_ith_similarity_response,pdf_ith_submission_status,pdf_word_count,pdf_ith_v2_action_type';
            $criteria = "pdf_ith_document_id = '{$document_id}'";
            $art_details =  $artpdf::get_single_record($select,$criteria);
            $word_cnt = $art_details->pdf_word_count;
            /**
             * Here check if the submission complete or webhook response not tiggered
             */
            if(empty($art_details->pdf_ith_submission_status) || $art_details->pdf_ith_v2_action_type == 'sp')
            {
                $body = array(
                    'doc_id'=>$document_id
                );
                //get submission status
                $response_rep = $this->do_call_v2($ithv2_url,$body,$sid,'PUT','submit_status');
                $response_rep_arr = (array) json_decode($response_rep);
                if(isset($response_rep_arr['status']) && $response_rep_arr['status'] == 'COMPLETE')
                {
                    $update_data = array(
                        'pdf_ith_submission_status' => 'S',
                        'pdf_word_count'=> $response_rep_arr['word_count'],
                        'pdf_ith_v2_action_type' => 'c',
                        'pdf_ith_v2_fileupload_status' => 'y',
                        'pdf_ith_submission_message' => customTrans('ithenticate.ithenticate_submit_success')
                    );
                    $word_cnt = $response_rep_arr['word_count'];
                    $data_check= array(
                        'pdf_ith_submission_status' => 'S',
                        'pdf_ith_v2_action_type' => 'c',
                        'pdf_ith_v2_fileupload_status' => 'y',
                        'pdf_ith_document_id'=>$document_id,
                        'pdf_ith_v2_action_date'=>null
                    );
                        $checkdata =Article_pdf::get_single_record_with_bind_cond('pdf_id',$data_check);
                        if(empty($checkdata))
                        {
                            Article_pdf::update_record($update_data, $criteria, $current_user);
                        }
                    //for avoiding extra database fetch
                    $art_details = (object) array(
                        'pdf_ith_similarity_response' => null, //this response not updated in the ithenticate article submission time
                        'pdf_ith_submission_status'=> 'S',
                        'pdf_word_count'=>$response_rep_arr['word_count'],
                        'pdf_ith_v2_action_type' => 'c'
                    );
                }
                else
                {
                    return $status_details;
                }
            }
            
            //$ith_ver2 = TRUE;
            //generate ithenticate report

            $folder_data = $this->get_ith_groupfolder($artp_id);
            
            $destination_folder_name = $folder_data['folder'];
            $folder_group = $folder_data['folder_group'];

            $view_settings = $ithv2Settings['view_settings'];
            $add_to_index = $ithv2Settings['add_to_index'];
            
            $add_temp = array(
                "add_to_index"=> true
            );
            if($add_to_index != '')
            {
                $add_temp = $add_to_index;
            }
            $body_data = array(
                'doc_id'=>$document_id,
                'indexing_settings'=> $add_temp,
                'generation_settings' => array(
                    'search_repositories'=>array(
                        "INTERNET",
                        "SUBMITTED_WORK",
                        "PUBLICATION",
                        "CROSSREF",
                        "CROSSREF_POSTED_CONTENT"
                    ),
                    'auto_exclude_self_matching_scope'=>'ALL',
                    'priority'=>'HIGH'
                )
            );

            if($view_settings != '')
            {
                $body_data['view_settings'] = $view_settings;
            }
            
            
            $response = '';
            $response_arr = array();
            $report_generating = false;
            $report_generated = false;
            $pdf_report_data = (object) array();
            if(isset($art_details->pdf_ith_similarity_response) && !empty($art_details))
            {
                $pdf_report_data = json_decode($art_details->pdf_ith_similarity_response); 
            }
            $update_table = true;
            if($art_details->pdf_ith_v2_action_type == 'rp')
            {
                $update_table = false;
            }
            //pdf_ith_similarity_response  column not updated in ithenticate v2 article submission
            if(isset($pdf_report_data->status))
            {
                if($pdf_report_data->status == 'PROCESSING' && $art_details->pdf_ith_submission_status == 'S')
                {
                    $report_generating = true;
                }
                elseif($pdf_report_data->status == 'COMPLETE')
                {
                    $report_generated = true;
                }
                        
            }
            else
            {
                //report schedule
                $response = $this->do_call_v2($ithv2_url,$body_data,$sid,'PUT','similarity');
                $response_arr = (array) json_decode($response);
            }
            
            if($report_generated == true)
            {//report generated
                $status_details = array(
                    'is_pending' => 0,
                    'destination_folder_name' => $destination_folder_name,
                    'folder_group'=>$folder_group
                );
            } 
            elseif(strpos($response,'Successfully scheduled') > 0 || $report_generating == true)
            {
                //generating report
                // $response = $this->do_call_v2($ithv2_url,$body_data,$sid,'PUT','similarityreport');
                // $update_data = array(
                //     'pdf_ith_similarity_response' => $response
                // );
                //$response_arr = (array) json_decode($response);
                
                $pending_status = TRUE;
                $submission_id = $document_id;
                $percent_match = 0;

                
                $body = array(
                    'doc_id'=>$document_id
                );
                //get report status
                $response_rep = $this->do_call_v2($ithv2_url,$body,$sid,'PUT','similarityreport_status');
                $response_arr = (array) json_decode($response_rep);
                
                $update_data = array(
                    'pdf_ith_similarity_response' => $response_rep
                );
                
                if(isset($response_arr['status']))
                {
                    $submission_id = $response_arr['submission_id'];
                    if($response_arr['status'] == 'COMPLETE')
                    {
                        $update_table = true;
                        $update_data = $this->prepare_for_artPdfUpdate($response_rep);
                        //$word_cnt = $update_data['pdf_word_count'];
                        $pending_status = 0;
                        $percent_match = $update_data['pdf_ith_similarity_percentage'];
                    }
                    elseif($response_arr['status'] == 'PROCESSING')
                    {
                        $update_data['pdf_ith_v2_action_type'] = 'rp';//report generation inprogress
                        $update_data['pdf_ith_v2_action_date'] = date('Y-m-d H:i:s');
                    }
                    
                }
                if($update_table == true)
                {
                    Article_pdf::update_record($update_data, $criteria,$current_user);
                }
                

                $status_details = array(
                    'status_id' => $submission_id,
                    'words' => $word_cnt,
                    'percent_match' => $percent_match,
                    'is_pending' => $pending_status,
                    'destination_folder_name' => $destination_folder_name,
                    'folder_group'=>$folder_group
                );
            }
            else
            {
                $this->error_message = $this->process_error($response_arr,TRUE,'report_schedule');
            }
        }
        else
        {
            $requesr_arr = array(
                "sid" => $sid,
                "id" => $document_id//28200041
            );
            $request = xmlrpc_encode_request('document.get', array(
                $requesr_arr));
            $response = $this->do_call($request);
            $response_arr = xmlrpc_decode($response);
            if (is_array($response_arr) && $response_arr['api_status'] == 200)
            {
                $document = $response_arr['documents'];
                if(isset($document[0]['parts'])) // http://www.ithenticate.com/products/whats-new/api-users : early response from a "document.get" call after uploading with the "document.add" method , and there is no “parts” array
                    {
                        $status_details = array(
                            'status_id' => $document[0]['parts'][0]['id'],
                            'words' => $document[0]['parts'][0]['words'],
                            'percent_match' => $document[0]['percent_match'],
                            'is_pending' => $document[0]['is_pending']);
                    }
            
            }else
            {
                //$this->error_message = $this->process_error($response_arr);
            }
            if ($status_details == NULL && $response_arr['api_status'] == 401)
            {
                $sid = $this->login_ithenticate($criteria, TRUE);
                if ($sid != NULL)
                {
                    $status_details = $this->document_status($document_id, $sid, $criteria,$artp_id);
                }

            }
        }
        return $status_details;

    }
    public function check_valid_view_url($pdf_detail)
	{
		$url_valid = FALSE;
        $expire_time = new \DateTime($pdf_detail->pdf_ith_view_only_expires);
		$current_time = new \DateTime(date('Y-m-d H:i:s'));
		if ($current_time < $expire_time)
		{
			$url_valid = TRUE;
		}
		return $url_valid;
	}

    /**
     * Task 5299 iThenticate V2 feature 
     */
    protected function do_call_v2($url,$request,$super_key,$request_type='GET',$type = '',$filename = '')
	{
        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
        $ithenticateconfig  = Config::get($ithenticate_config);

        $folder_group = NULL;
        if(isset($ithenticateconfig['ithenticate_v2']['name']))
            $folder_group = $ithenticateconfig['ithenticate_v2']['name'];

        $version = '3.0';
        if(isset($ithenticateconfig['ithenticate_v2']['version']))
            $version = $ithenticateconfig['ithenticate_v2']['version'];
        
        $filepath = '';
        $art_ith_id = '';
        $reqestNotneeded = array('submit_status','check_tnc','similarity','similarityreport','similarityreport_status','viewer_url','tnc','featuresEnab');
        if($type == 'fileupload')
        {
            $filepath = $request['path'];
            $art_ith_id = $request['art_ith_id'];
        }
        //elseif($type != 'similarity' && $type != 'similarityreport' && $type != 'similarityreport_status' && $type != 'viewer_url')
        elseif(!in_array($type,$reqestNotneeded))
        {
            $request = json_encode($request);
        }
        
        if($url != NULL)
        {
            $url = $this->set_path_slash(trim($url), FALSE);
        }

        if($type == 'webhook' || $type =='webhook_info')
        {
            $url .= 'api/v1/webhooks';
        }
        elseif($type == 'group')
        {
            $url .= 'api/v1/groups/'.$super_key;
        }
        elseif($type == 'tnc')
        {
            $url .= 'api/v1/eula/v1beta/view';
        }
        elseif($type == 'featuresEnab')
        {
            $url .= 'api/v1/features-enabled';
        }
        elseif($type == 'tncaccept')
        {
            $url .= 'api/v1/eula/v1beta/accept';
        }
        elseif($type == 'check_tnc')
        {
            $url .= 'api/v1/eula/v1beta/accept/'.$request['userid'];
        }
        elseif($type == 'artsubmit')
        {
            $url .= 'api/v1/submissions';
        }
        elseif($type == 'fileupload')
        {
            $url .= 'api/v1/submissions/'.$art_ith_id.'/original';
        }
        elseif($type == 'similarity' || $type == 'similarityreport')
        {
            $url .= 'api/v1/submissions/'.$request['doc_id'].'/similarity';
            unset($request['doc_id']);
            $request = json_encode($request);
        }
        elseif($type == 'submit_status')
        {
            $url .= 'api/v1/submissions/'.$request['doc_id'];
        }
        elseif($type == 'similarityreport_status')
        {
            $url .= 'api/v1/submissions/'.$request['doc_id'].'/similarity';
        }
        elseif($type == 'viewer_url')
        {
            $url .= 'api/v1/submissions/'.$request['doc_id'].'/viewer-url';
            unset($request['doc_id']);
            $request = json_encode($request);
        }

		$header[] = "X-Turnitin-Integration-Name: ".$folder_group;
        $header[] = "X-Turnitin-Integration-Version: ".$version;
        if($type != 'tnc')
        {
            $header[] = "Authorization: Bearer ".$super_key;
        }
            
        if($type == 'fileupload')
        {
            $header[] = "Content-Type: binary/octet-stream";
            $header[] = "Content-Disposition: inline; filename=\"".$filename."\"";
        }
        elseif($type != 'similarityreport' && $type != 'similarityreport_status' && $type != 'webhook_info' && $type != 'check_tnc' && $type != 'tnc' && $type != 'featuresEnab'  && $type != 'submit_status')
        {
            $header[] = "Content-Type: application/json";
        }

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 600);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        if($type == 'fileupload')
        {
            $fileHandle = fopen($filepath, 'r');
            curl_setopt($ch, CURLOPT_UPLOAD, true);
            curl_setopt($ch, CURLOPT_INFILE, $fileHandle);
        }
        if($type != 'similarityreport' && $type != 'similarityreport_status' && $type != 'webhook_info' && $type != 'check_tnc' && $type != 'tnc' && $type != 'featuresEnab'  && $type != 'submit_status')
        {
            if($type != 'viewer_url' )
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $request_type);
            if($type != 'fileupload' )
                curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
        }
		
		$data = curl_exec($ch);

        if($type == 'fileupload')
            fclose($fileHandle);

		if (curl_errno($ch))
		{
			print curl_error($ch);
		}
		else
		{
			curl_close($ch);
			return $data;
		}
	}

    /**
     * 5299
     * Artcile submit to iThenticate version 2
     * expect : return back unique article id from ithenticate
     */
    
    public function get_more_article_details($art_id,$fid,$folder_name,$author_submit = FALSE)
    {
        $Authors = new \App\Models\Authors();
        $Authors_table = (new \App\Models\Authors())->getTable();
        $User_table = (new \App\Models\User())->getTable();
        $Articles_table = (new \App\Models\Articles())->getTable();

        $tables = array(
			'main_table' => $Articles_table,
			'join_table' => array(
                $Authors_table => array('art_id','auth_art_id','left'),
                $User_table => array('usr_id', 'auth_usr_id','left')
		));
        $select ='usr_first_name, usr_last_name,usr_email,usr_id,art_submission_date,art_submitted_by,auth_usr_id as corresp_author,strip_tags(art_title) as art_title';
        $criteria = "art_id={$art_id} and auth_corr_author='y'";
        $art_details =  $Authors::get_results_using_joins($tables,$select,$criteria,'single');

        $owner_default_permission_set = 'EDITOR';
        if($author_submit == TRUE)
            $owner_default_permission_set = 'USER';
        
        $article_data = array(
            'owner' => 'rv_user_'.$art_details->corresp_author,
            'title' => trim(html_entity_decode($art_details->art_title)),
            'submitter'=> 'rv_user_'.$art_details->art_submitted_by,
            'owner_default_permission_set' => $owner_default_permission_set,
            'extract_text_only'=> 'false',
            'metadata'=>array(
                'owners' => array(
                   '0'=> array(
                    'id'=>'rv_user_'.$art_details->corresp_author,
                    'given_name' => $art_details->usr_first_name,
                    'family_name' => $art_details->usr_last_name,
                    'email'=> trim($art_details->usr_email)
                )),
            )
        );
        
        if($art_details->art_submitted_by != $art_details->corresp_author)
        {
            $User = new \App\Models\User();
            $submitted_user =  $art_details->art_submitted_by;
            $select = 'usr_id,usr_first_name,usr_middle_name,usr_last_name,usr_email';
            $subimt_user_details = $User::get_single_record_with_bind_cond($select,array(
                'usr_id' => $submitted_user
            ));
            if(!empty($subimt_user_details))
            {
                $article_data['metadata']['submitter'] = array(
                    'id'=>'rv_user_'.$subimt_user_details->usr_id,
                    'given_name' => $subimt_user_details->usr_first_name,
                    'family_name' => $subimt_user_details->usr_last_name,
                    'email'=> trim($subimt_user_details->usr_email)
                );
            }
            //echo '<pre>';print_r($subimt_user_details);exit;
        }
        else
        {
            unset($article_data['submitter']);
        }
      
        $article_data['metadata']['original_submitted_time'] = $this->getnormaltimetoISO($art_details->art_submission_date);
        
        return  $article_data;
    }

    /**
     * for fetching ithenticate article type group and folder names
     */
    public function get_ith_groupfolder($artp_id)
    {
        $return_arr = array(
            'folder_group' => '',
            'folder'=> '',
        );
        $cond = "atotp_artp_id = ".$artp_id;
        $art_type_advoptions = Article_type_advance_options::get_single_record('atotp_default_ithapi_folder', $cond);
        if(!empty($art_type_advoptions))
        {
            $return_arr['folder'] = $destination_folder_name = $art_type_advoptions->atotp_default_ithapi_folder;
            $folder_group = '';
            $directory_split = explode('/', $destination_folder_name);
            if (count($directory_split) > 1)
            {
                $return_arr['folder_group'] = trim($directory_split[0]);
                $return_arr['folder'] = trim($directory_split[1]);
            }
            
            $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
            $ithenticateconfig  = Config::get($ithenticate_config);

            if ($folder_group == '')
            {
                $return_arr['folder_group'] = $ithenticateconfig['defualt_folder_group'];
            }

        }
        return $return_arr;
    }

    /**
     * create webhook
     */
    public function create_webhook_if_not_exist($sid,$ith_url)
    {
        $Ithenticate_webhooks = new \App\Models\Ithenticate_webhooks();
        $webhook_arr = $Ithenticate_webhooks::get_single_record('iwh_webhook_id');
        $wid = NULL;
        if(!empty($webhook_arr))
        {
            $wid = $webhook_arr->iwh_webhook_id;
        }
        else
        {
            $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
            $ithenticateconfig  = Config::get($ithenticate_config);

            $request = isset($ithenticateconfig['ithenticate_v2']['webhook_settings']) ? $ithenticateconfig['ithenticate_v2']['webhook_settings'] :NULL;
            
            $Callback_Function = isset($request['url'])?$request['url']:NULL;

            if($request != NULL && $Callback_Function != NULL)
            {
                $callBack_url = URL::to('/').'/api/'.$Callback_Function;
                $web_hook_id = NULL;
                //check for webhook aleady exist
                $response_info = $this->do_call_v2($ith_url,array(),$sid,'POST','webhook_info');
                $web_response_info = (array) json_decode($response_info);
                
                $create_webhook = TRUE;
                if(count($web_response_info)>0)
                {
                    foreach($web_response_info as $webhook)
                    {
                        if(isset($webhook->url))
                        {
                            if($webhook->url == $callBack_url)
                            {
                                $web_hook_id = $webhook->id;
                                $create_webhook = FALSE;
                                break;
                            }
                        }
                    }
                }

                if($create_webhook == TRUE)
                {
                    $allow_insecure = str_contains($callBack_url,'https://')?false:true;
                    $request['url'] = $callBack_url;
                    $request['allow_insecure'] = $allow_insecure;
                
                    $response = $this->do_call_v2($ith_url,$request,$sid,'POST','webhook');
                    $web_response = (array) json_decode($response);
                    if(isset($web_response['id']))
                    {
                        $web_hook_id = $web_response['id'];
                    }
                }
                   
                if($web_hook_id != NULL)
                {
                    $data_arr = array(
                        'iwh_webhook_id'=> $web_hook_id
                    );

                    $current_user = array(
                        'user_id' => 0,
                        'proxy_user_id' => 0
                    );
                    if (isset($this->current_user))
                    {
                        $current_user = $this->current_user;
                    }

                    $id = $Ithenticate_webhooks::insert_record($data_arr,$current_user);
                    if($id)
                    {
                        $wid = $web_hook_id;
                    }
                }
            }
            
        }
        return $wid;
    }

    /**
     * After report Generation
     * $response expected in json_format
     */
    public function prepare_for_artPdfUpdate($response)
    {
        $response_arr = (array) json_decode($response);
        $update_data = array();
        if(isset($response_arr['submission_id']) && isset($response_arr['overall_match_percentage']) && isset($response_arr['status']) &&  $response_arr['status'] == 'COMPLETE')
        {
            $update_data['pdf_ith_similarity_response'] = $response;

            $update_data['pdf_ith_similarity_percentage'] =  $response_arr['overall_match_percentage'];
            //$update_data['pdf_word_count'] =  $response_arr['top_source_largest_matched_word_count'];
            $update_data['pdf_ith_v2_action_type'] = 'c'; // completed task
           
            $sys_timezone =env('APP_TIMEZONE');
            $ith_report_generate = $response_arr['time_generated'];
            $carbonDateTime = Carbon::parse($ith_report_generate);
            $normalDateTime = $carbonDateTime->setTimezone($sys_timezone);
            $update_data['pdf_ith_report_date'] = $normalDateTime;
        }
        return $update_data;
    }

    public function geteulaTNC($ithv2_url,$sid,$usrid)
    {
        $return_stg = '';
        //tnc == for getting terms and condition
        $userID = 'rv_user_'.$usrid;
        
        $data  = array(
            'userid' => $userID
        );
        //check user already accept T&C or not
        $response_rep = $this->do_call_v2($ithv2_url,$data,$sid,'PUT','check_tnc');
        $response_rep_arr = (array) json_decode($response_rep);
        if(isset($response_rep_arr['success']) && $response_rep_arr['success'] === false)
        {
            //fetching Terms and condition from turnitin if the end user not getting access from Crossref
            $return_stg = $this->do_call_v2($ithv2_url,array(),$sid,'PUT','tnc');
        }

        return $return_stg;
    }
    /**
     * Convert normal db time to iso time
     * If time not send then it convert current date and time
     */
    public function getnormaltimetoISO($time = null)
    {
        $date_from = new \DateTime();
        if($time == null)
        {
            $time = date('Y-m-d H:i:s');
        }
        $dateTime = $date_from::createFromFormat('Y-m-d H:i:s', $time);

        return $dateTime->format('c');
    }

    /**
     * Ithenticate retry logic
     */
    public function retryIthenticatev2($pdfId,$artpId,$clientId,$currentUser,$type,&$ithretry)
    {
        $select = 'pdf_id,pdf_ith_similarity_percentage,pdf_art_id,pdf_aflw_id,art_artp_id,pdf_ith_v2_action_type,pdf_ith_v2_action_date,ias_id,ias_pdf_id,ias_artp_id,ias_status,ias_retry_count';
        $cond = 'pdf_id = '.$pdfId;
        
        $Article_pdf_table = (new \App\Models\Article_pdf())->getTable();
        $Articles_table = (new \App\Models\Articles())->getTable();
        $Ithenticate_autosubmission_table = (new \App\Models\Ithenticate_autosubmission())->getTable();

        $tables = array(
            'main_table' => $Article_pdf_table,
            'join_table' => array(
            $Articles_table => array('pdf_art_id','art_id'),
            $Ithenticate_autosubmission_table => array('pdf_id','ias_pdf_id','left')
        ));
        $inproTasks =  Article_pdf::get_results_using_joins($tables, $select, $cond,'single');

        $ithretry = false;
        if(!empty($inproTasks))
        {
            $ithretry = true;
            if($inproTasks->pdf_ith_v2_action_type != $type && $type != 'i')
            {
                $upload_arr = array(
                   // 'pdf_ith_submission_status' => 'i',
                    'pdf_ith_v2_action_type' => $type,
                    'pdf_ith_v2_action_date' => date('Y-m-d H:i:s')

                );
                
                $cnd = ' pdf_id ='.$pdfId.' AND pdf_ith_submission_status = ""';
                Article_pdf::update_record($upload_arr, $cnd, $currentUser);
            }
            if($inproTasks->ias_id == null)
            {//if type = i then also enter into autosubmit ithenticate table for retry submission.
                $auto_ith_data = array(
                    'ias_pdf_id' => $pdfId,
                    'ias_artp_id' => $artpId,
                    'ias_clnt_id' => $clientId,
                    'ias_status' => 'n'
                );
                Ithenticate_autosubmission::insert_record($auto_ith_data,$currentUser);
            }
            elseif($inproTasks->ias_id != null && $inproTasks->pdf_ith_similarity_percentage == 0 && $inproTasks->ias_status == 'y' && ($inproTasks->pdf_ith_v2_action_type == 'sp' ||  $inproTasks->pdf_ith_v2_action_type == 'rp'))
            {	
                $update_arr = array(
                    'ias_status' => 'n',
                    'ias_retry_count' => 0
                );
                $cond_autosubmit = array(
                    'ias_id' => $inproTasks->ias_id
                );
                Ithenticate_autosubmission::update_record($update_arr, $cond_autosubmit, $currentUser);
            }
            
        }
    }

    /**
     * GET LOGIN CREDENTIALS USING ITHENTICATE ID
     */
    public function getIthenticatecred($ithId,&$artpId)
    {
        $returnarr = array();
        $articlepdf_table = (new \App\Models\Article_pdf())->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $artp_table = (new \App\Models\Article_types())->getTable();
        $artpId = null;

        $select = 'art_artp_id,artp_jnl_id';

        $condition = array(
            'pdf_ith_document_id'=> $ithId
        );
        $tables = array(
            'main_table' => $articlepdf_table,
            'join_table' => array(
                $article_table => array('pdf_art_id','art_id'),
                $artp_table => array('art_artp_id','artp_id'),
            )
        );
        $ithDetails = Article_pdf::get_results_using_joins($tables, $select, $condition, 'single');
        if(!empty($ithDetails))
        {
            $artpId = $ithDetails->art_artp_id;
            $returnarr = array(
                'acrd_clnt_id' => $this->current_client->clnt_id,
                'acrd_api_name' => 'ithenticate',
                'acrd_artp_id' => $ithDetails->art_artp_id,
                'acrd_jnl_id' => $ithDetails->artp_jnl_id
            );
        }
        return $returnarr;
    }

    public function getIthV2SettVal($ithenticateVal){
        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
        $ithenticateconfig  = Config::get($ithenticate_config);
        
        $data_view_settings = $data_index_settings = $data_save_changes = array();
        if(isset($ithenticateVal->acrd_ith_v2_view_settings) && $ithenticateVal->acrd_ith_v2_view_settings != NULL)
        {
            $data_view_settings = json_decode($ithenticateVal->acrd_ith_v2_view_settings);
        }
        if(isset($ithenticateVal->acrd_ith_v2_add_to_index) && $ithenticateVal->acrd_ith_v2_add_to_index != NULL)
        {
            $data_index_settings = json_decode($ithenticateVal->acrd_ith_v2_add_to_index);
        }
        if(isset($ithenticateVal->acrd_ith_v2_save_changes) && $ithenticateVal->acrd_ith_v2_save_changes != NULL)
        {
            $data_save_changes = json_decode($ithenticateVal->acrd_ith_v2_save_changes);
        }

        if(isset($ithenticateconfig['ithenticate_v2']['view_settings']))
        {
            $ith_view_settings = [];
            foreach($ithenticateconfig['ithenticate_v2']['view_settings'] as $key=>$val)
            {
                if(isset($data_view_settings->$key))
                {
                    $val['value'] = $data_view_settings->$key;
                }
                $ith_view_settings[] = array(
                    'key'=>$key,
                    'label'=>$val['label'],
                    'value'=>$val['value']
                );
            }
            $ithenticateVal->acrd_ith_v2_view_settings = $ith_view_settings;
        }
        if(isset($ithenticateconfig['ithenticate_v2']['indexing_settings']))
        {
            $ith_index_settings = [];
            foreach($ithenticateconfig['ithenticate_v2']['indexing_settings'] as $key=>$val)
            {
                if(isset($data_index_settings->$key))
                {
                    $val['value'] = $data_index_settings->$key;
                }
                $ith_index_settings[] = array(
                    'key'=>$key,
                    'label'=>$val['label'],
                    'value'=>$val['value']
                );
            }
            $ithenticateVal->acrd_ith_v2_add_to_index = $ith_index_settings;
        }

        if(isset($ithenticateconfig['ithenticate_v2']['similarity_view_settings']))
        {
            $ith_save_changes = [];
            foreach($ithenticateconfig['ithenticate_v2']['similarity_view_settings'] as $key=>$val)
            {
                if(isset($data_save_changes->$key))
                {
                    $val['value'] = $data_save_changes->$key;
                }
                $ith_save_changes[] = array(
                    'key'=>$key,
                    'label'=>$val['label'],
                    'value'=>$val['value']
                );
            }
            $ithenticateVal->acrd_ith_v2_save_changes = $ith_save_changes;
        }
    return $ithenticateVal;
    }

    /*Task 7850 ithenticate v2 enhancement
   *    $ithConfig - username,password
   *    id -- rvw_api_credentials id
   *    default return -- return EULA y/n (if no result from ithenticate then reutn null)
   *    updateStatus (true) and id there then update rvw_api_credentials table, default false
   */
    public function setEULA($ithConfigs,$updateStatus = false,$id=null)
    {
       $value = null;
       if(isset($ithConfigs['username']) && isset($ithConfigs['pass']))
       {
           $ithv2url = $ithConfigs['username'];
           $sid = $ithConfigs['pass'];
           $colName = 'acrd_eula';
           $response_rep = $this->do_call_v2($ithv2url,array(),$sid,'PUT','featuresEnab');
           $web_response_info = (array) json_decode($response_rep);
           if(isset($web_response_info['tenant']->require_eula))
           {
               $value = 'n';
               if($web_response_info['tenant']->require_eula == 'true')
               {
                   $value = 'y';
               }
               if($updateStatus == true && !empty($id))
               {
                    $table = new \App\Models\Api_credentials();
                    $cond = array(
                        'acrd_id' => $id
                    );

                    $table::update_record(array(
                        $colName => $value
                    ),$cond,$this->currentuser);
               }
           }
       }
       return $value;
    }

    /**
     * this function returns the creds from api_credentials, if not in this table then send it from ith. config file. 
     */
    public function getithV2credentials($creds)
    {
        $ithenticate_config = 'clients.' . $this->current_client->clnt_client_code . '.ithenticate';
        $ithenticateconfig  = Config::get($ithenticate_config);
        
        $view_arr = $sett_array = $saveChangeArr = array();
        $return_arr = array(
            'view_settings' => '',
            'add_to_index' => '',
            'save_changes' => ''
        );
        
        if(isset($creds['details']))
        {
            $creds = $creds['details'];
        }
        //view_settings
        if(isset($creds['acrd_ith_v2_view_settings']) && !empty($creds['acrd_ith_v2_view_settings']) && $creds['acrd_ith_v2_view_settings'] != NULL)
        {
            $view_arr = (array) json_decode($creds['acrd_ith_v2_view_settings']); 
            if(count($view_arr)>0)
            {
                foreach($view_arr as $key=>$val)
                {
                    $sett_array[$key] = 'false';
                    if(isset($val) && $val == true)
                    {
                        $sett_array[$key] = 'true';
                    }
                }
            }               
        }
        elseif(isset($ithenticateconfig['ithenticate_v2']['view_settings']))
        {
            foreach($ithenticateconfig['ithenticate_v2']['view_settings'] as $key => $val)
            {
                $sett_array[$key] = 'false';
                if(isset($val['value']) && $val['value'] == true)
                {
                    $sett_array[$key] = 'true';
                }
            }
        }
        
        if(isset($sett_array['exclude_small_matches']) && $sett_array['exclude_small_matches'] == true)
        {
            if(isset($creds['acrd_ex_mch_cnt']) && $creds['acrd_ex_mch_cnt'] > 0)
            {
                $sett_array['exclude_small_matches'] = $creds['acrd_ex_mch_cnt'];
            }
            else
            {
                $sett_array['exclude_small_matches'] = 8;
            }
        }
        $return_arr['view_settings'] = $sett_array;

        //save changes
        $return_arr['save_changes'] = array(
            "save_changes"=> 'false'
        );
        if(isset($creds['acrd_ith_v2_save_changes']) && !empty($creds['acrd_ith_v2_save_changes']) && $creds['acrd_ith_v2_save_changes'] != NULL)
        {
            $temp_save_changes = (array) json_decode($creds['acrd_ith_v2_save_changes']); 
            if(isset($temp_save_changes['save_changes']) && $temp_save_changes['save_changes'] == true)
            {
                $return_arr['save_changes']['save_changes'] = 'true';               
            }
        }
        elseif(isset($ithenticateconfig['ithenticate_v2']['similarity_view_settings']))
        {
            $index = $ithenticateconfig['ithenticate_v2']['similarity_view_settings'];
            if(isset($index['save_changes']['value']) && $index['save_changes']['value'] == true)
            {
                $return_arr['save_changes']['save_changes'] = 'true';
            }
                
        }

        // add to index  -- 
        $return_arr['add_to_index'] = array(
            'add_to_index' => 'false'
        );
        if(isset($creds['acrd_ith_v2_add_to_index']) && !empty($creds['acrd_ith_v2_add_to_index']) && $creds['acrd_ith_v2_add_to_index'] != null)
        {
            $temp_add_to_index = (array) json_decode($creds['acrd_ith_v2_add_to_index']); 
            if(isset($temp_add_to_index['add_to_index']) && $temp_add_to_index['add_to_index'] == true)
            {
                $return_arr['add_to_index']['add_to_index'] = 'true';               
            }
        }
        elseif(isset($ithenticateconfig['ithenticate_v2']['indexing_settings']))
        {
            $index = $ithenticateconfig['ithenticate_v2']['indexing_settings'];
            if(isset($index['add_to_index']['value']) && $index['add_to_index']['value'] == true)
            {
                $return_arr['add_to_index']['add_to_index'] = 'true';
            }
                
        }
        return $return_arr;
    }
}