<?php

namespace App\Http\Traits;

use App\Models\Journals;
use App\Models\Journal_settings;
use App\Models\Roles;
use App\Models\User_to_journals;
use App\Models\General_permission;
use App\Models\Modules;
use App\Models\Clients;
use App\Models\Client_functionalities;
use App\Http\Traits\UserDataTrait;
use App\Http\Traits\RolesConfigTrait;
use App\Models\User;
use Config;
use \stdClass;
trait JournalUserfunctionTrait
{
  use UserDataTrait;
  use RolesConfigTrait;
    public function check_user_access($jnl_code = NULL, $user_id = NULL,$current_url=NULL,$active_role=NULL)
	{
	$user_access=false;
	if($jnl_code!=NULL&&$user_id!=NULL)
	{

		$user_roles= $this->validate_user_journal($jnl_code,$user_id);
		$access_url= 'user_access_page.page-url-role-based';
		$access_url_list_main_array = Config::get($access_url);
		$access_url_sheetviewurl= Config::get('user_access_page.sheetview-url');
		$access_url_list=array_merge($access_url_list_main_array,$access_url_sheetviewurl);

		if(in_array($current_url,$access_url_list))
	 {
          if(isset($active_role)&&($active_role!=''))
		  {
	       if (in_array($active_role, $user_roles['role_id']))
            {
			$user_access=TRUE;
            }
		 }
	   else
	   {

		if(empty($user_roles['role_id']))
		{
		 $user_access=TRUE;
		}
		//$condition="jnl_journal_code='{$jnl_code}'";
		$condition=array("jnl_journal_code"=>$jnl_code);
		$jnl_data=Journals::get_single_record_with_bind_cond('jnl_id',$condition);
        if(!empty($jnl_data))
		{
			$active_default_role=$this->set_dashboard_default_role_active($user_roles,$jnl_data->jnl_id, $user_id);
			if(isset($active_default_role['role_id'])&&$active_default_role['role_id']!='')
			{
				if (in_array($active_default_role['role_id'], $user_roles['role_id']))
				{
				 $user_access=TRUE;
				 }
			}
		  }
		 }
		}

	}
        return $user_access;
	  }
	  public function check_user_status($user_id=NULL)
	  {
		$user_access=false;
		//$criteria = "usr_id={$user_id}";
		$criteria=array("usr_id"=>$user_id);
		$userStatus = User::get_single_record_with_bind_cond('usr_status',$criteria);
		if(isset($userStatus->usr_status) && $userStatus->usr_status=='a')
		{
			$user_access=TRUE;
		}
		return $user_access;
	  }
      public function check_page_access($jnl_code=NULL,$user_id=NULL,$current_url=NULL,$journal_url=NULL,$proxy_user_id=NULL)
	  {
		$user_access=false;
		$current_client=$this->get_current_client_functionality_data();
		$access_url_custom_form= 'user_access_page.custom-form-url';
		$access_url_custom_form_list = Config::get($access_url_custom_form);
		$access_url_jornal_form= 'user_access_page.page-url-journal-based';
		$access_url_jornal_form_list = Config::get($access_url_jornal_form);
		$access_role_manage_page_list=Config::get('user_access_page.manage-role-url');
		$access_email_template_manage_page_list=Config::get('user_access_page.manage-email-template-tags-url');
		$access_flags_manage_page_list=Config::get('user_access_page.manage-flags-url');
		$access_file_description_page_list=Config::get('user_access_page.manage-file-description-url');
		$access_file_reject_reason_page_list=Config::get('user_access_page.manage-reject-reason-url');
		$access_file_upload_page_list=Config::get('user_access_page.manage-file-upload-url');
		$access_ftp=Config::get('user_access_page.manage-ftp');
		$access_discussion_type_page_list=Config::get('user_access_page.manage-discussion-type-url');
		$access_copyright_page_list=Config::get('user_access_page.manage-copyright-url');
		$access_delete_reason_page_list=Config::get('user_access_page.manage-delete-reason-url');
		$access_manange_permission_page_list=Config::get('user_access_page.manage-permission-menu-url');
		$access_manange_users_page_list=Config::get('user_access_page.manage-users-menu-url');
		$access_manange_email_page_list=Config::get('user_access_page.manage-email-url');
		$access_manange_keyword_page_list=Config::get('user_access_page.manage-keyword-menu-url');
		$access_manange_sheetview_list=Config::get('user_access_page.sheetview-url');
		$access_manange_journal_user_list=Config::get('user_access_page.journal-user-url');
		//$access_manage_email_user_list=Config::get('user_access_page.manage-email-url');
		$access_manage_issue_url_list=Config::get('user_access_page.manange-issue-url');
		$access_manage_propasal_url_list=Config::get('user_access_page.manange-propasal-url');
		$access_manage_proxy_url_list=Config::get('user_access_page.manange-proxy-url');
		$access_manage_login_tracker_url=Config::get('user_access_page.login-tracker-api');
		$access_manage_workflow_assignment_url=Config::get('user_access_page.workflow-assignment-api');

		$access_manage_user_to_journal_url=Config::get('user_access_page.user-to-journal-api');
		$access_manage_articles_page_list=Config::get('user_access_page.manage-articles-url');
		$access_manage_rescind_request_url=Config::get('user_access_page.manage-rescind-request');

		//Task #6971 - Implementing Report on ReView 3
		$access_report=Config::get('user_access_page.manage-reports');

		if($jnl_code!=NULL&&$journal_url!=NULL)
		{

		if(in_array($journal_url,$access_manage_proxy_url_list))
		{
			if($user_id!=$proxy_user_id)
			{
				$user_id=$proxy_user_id;
			}
		}
		$user_roles= $this->validate_user_journal($jnl_code,$user_id);

		$condition=array("jnl_journal_code"=>$jnl_code);
		$jnl_data=Journals::get_single_record_with_bind_cond('jnl_id',$condition);
		if(!empty($jnl_data) )
		{

		$user_permission_roles =Journal_settings::get_single_record_with_bind_cond('jset_draft_proposal_invite,jset_add_user_note,jset_add_user_attachemnts,jset_user_flags,jset_change_user_status,jset_email_permission,jset_create_article_stub,jset_manage_issue,jset_add_article_to_issue,jset_manage_article_type,jset_manage_article,jset_edit_user_details,jset_bulk_invite_submission,jset_proxy_login',array("jset_jnl_id"=>$jnl_data->jnl_id));
		$functionality=$this->get_current_client_functionality_data();
		$client_finctionality=$functionality->functionality;
		$modules=$functionality->modules;

		$manage_article_type=array();
		$user_note=array();
		$user_attach=array();
		$user_change=array();
		$user_flags=array();
		$user_edit_det=array();
		$email_permission=array();
		$create_article_stub=array();
		if($user_permission_roles->jset_add_user_note != NULL)
		$user_note = json_decode($user_permission_roles->jset_add_user_note);

	if($user_permission_roles->jset_add_user_attachemnts != NULL)
		$user_attach = json_decode($user_permission_roles->jset_add_user_attachemnts);

	if($user_permission_roles->jset_change_user_status != NULL)
		$user_change = json_decode($user_permission_roles->jset_change_user_status);

	if($user_permission_roles->jset_user_flags != NULL)
		$user_flags = json_decode($user_permission_roles->jset_user_flags);
	if($user_permission_roles->jset_edit_user_details != NULL)
		$user_edit_det = json_decode($user_permission_roles->jset_edit_user_details);
	if($user_permission_roles->jset_email_permission != NULL)
		$email_permission = json_decode($user_permission_roles->jset_email_permission);
	if($user_permission_roles->jset_create_article_stub != NULL)
		$create_article_stub = json_decode($user_permission_roles->jset_create_article_stub);

		if(in_array($journal_url,$access_url_jornal_form_list)||in_array($journal_url,$access_manange_email_page_list))
		{

			if($user_permission_roles->jset_manage_article_type != NULL)
				$manage_article_type= json_decode($user_permission_roles->jset_manage_article_type);
				$permitted_menulist= $this->get_right_menu_permission($user_id);

				if(!empty($manage_article_type))
				{
					$result=array_intersect($manage_article_type,$user_roles['role_id']);
					if(!empty($result))
					$user_access=TRUE;

				}
                 //TASK #7427 Logout issue while clicking on decision menu in conference
                if (isset($modules->mdl_conference) && $modules->mdl_conference == 'y') {

                    $role_used = $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles'];
                    if(!empty($role_used)&&isset($user_roles['assigned_roles'])&&!empty($user_roles['assigned_roles']))
                    {
                    $result=array_intersect($role_used,$user_roles['assigned_roles']);
                    if(!empty($result))
                    {
                        $user_access = TRUE;
                    }
                       }
                    }
                //TASK #7427~
			    if(in_array('journal_admin',$user_roles['assigned_roles']))
				{
					$user_access=TRUE;
				}
				if(in_array('journals',$permitted_menulist['permission_menu']))
				{
				  $user_access=TRUE;
				}
				if($user_permission_roles->jset_email_permission != NULL)
				$email_permission = json_decode($user_permission_roles->jset_email_permission);

				if(array_intersect($user_roles['role_id'],$email_permission))
				{
					$user_access=TRUE;
				}

		 }
		 elseif(in_array($journal_url,$access_manange_journal_user_list))
		 {

			if (array_intersect($user_roles['role_id'], $user_note)||array_intersect($user_roles['role_id'],  $user_attach)||array_intersect($user_roles['role_id'],  $user_change)||array_intersect($user_roles['role_id'],  $user_flags)||array_intersect($user_roles['role_id'],  $user_edit_det)) {

				$user_access=TRUE;
			}


		  }
		  elseif(in_array($journal_url,$access_manange_sheetview_list))
		  {


			if (isset($client_finctionality->cfty_enable_article_delete) && $client_finctionality->cfty_enable_article_delete == 'y' || isset($client_finctionality->cfty_enable_article_withdraw) && $client_finctionality->cfty_enable_article_withdraw == 'y' )
			{
				if($user_permission_roles->jset_manage_article != NULL)
				$manage_article = json_decode($user_permission_roles->jset_manage_article);
			if(isset($manage_article)&&array_intersect($user_roles['role_id'],$manage_article))
			{

				$user_access=TRUE;
				/*if($functionality->cfty_enable_article_delete == 'y')
			    $user_access=TRUE;*/

			}
			$user_access=TRUE;

			}

		  }

		  elseif(in_array($journal_url,$access_manange_email_page_list))
		  {

			if($user_permission_roles->jset_email_permission != NULL)
			$email_permission = json_decode($user_permission_roles->jset_email_permission);

			if(array_intersect($user_roles['role_id'],$email_permission))
			{
				$user_access=TRUE;
		    }
		  }
		  elseif(in_array($journal_url,$access_url_custom_form_list)) {
			if(in_array($journal_url,array('viewformdemo')) ) {
				$user_access=TRUE;
			}
			elseif(in_array('journal_admin',$user_roles['assigned_roles'])) {


				$user_access=TRUE;
			}
		  }
         elseif(in_array($journal_url,$access_manage_issue_url_list))
         {
			if(isset($client_finctionality->cfty_manage_issues) && ($client_finctionality->cfty_manage_issues == 'y'))
			{
				if($user_permission_roles->jset_manage_issue != NULL)
						$manage_issue_users= json_decode($user_permission_roles->jset_manage_issue);
				if(array_intersect($user_roles['role_id'],$manage_issue_users))
				{
					$user_access=TRUE;
				}
			}

		 }
		 elseif(in_array($journal_url,$access_manage_propasal_url_list))
         {

		 if($user_permission_roles->jset_draft_proposal_invite != NULL)
		 {
			 $manage_draft = json_decode($user_permission_roles->jset_draft_proposal_invite);
			 if(array_intersect($user_roles['role_id'],$manage_draft))
			 {
				$user_access=TRUE;
			 }
		 }

         //TASK #7427 Logout issue while clicking on decision menu in conference

          if (isset($modules->mdl_conference) && $modules->mdl_conference == 'y') {
                        $user_access = TRUE;
        }
        //TASK #7427~
		}
        elseif(in_array($journal_url,$access_manage_proxy_url_list))
		{

			$manage_proxy_user = json_decode($user_permission_roles->jset_proxy_login);

			if(array_intersect($user_roles['role_id'],$manage_proxy_user))
			{
			   $user_access=TRUE;
			}

		}

		}
	 }
	 else
	 {
		$permitted_menulist= $this->get_right_menu_permission($user_id);
		if(in_array($current_url,$access_manage_user_to_journal_url))
		{
          if(in_array('user-to-journal',$permitted_menulist['permission_menu']))
		  {
			$user_access=TRUE;
		  }
		}

		if(in_array($current_url,$access_manange_users_page_list))
		{
          if(in_array('manage-users',$permitted_menulist['permission_menu']))
		  {
			$user_access=TRUE;
		  }
		}
		if(in_array($current_url,$access_url_jornal_form_list))
		{
          if(in_array('journals',$permitted_menulist['permission_menu']))
		  {
			$user_access=TRUE;
		  }
		}
		elseif(in_array($current_url,$access_role_manage_page_list)){
			if(in_array('user-role',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_email_template_manage_page_list))
		{
			if(in_array('manage-email-template-tags',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_flags_manage_page_list))
		{
			if(in_array('manage-flag',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_file_description_page_list))
		{
			if(in_array('manage-file-descriptions',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_file_reject_reason_page_list))
		{
			if(in_array('manage-reject-reason',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_file_upload_page_list))
		{
			if(in_array('manage-file-upload-type',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_ftp))
		{
			if(in_array('manage-ftp',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_discussion_type_page_list))
		{
			if(in_array('discussion-type',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_copyright_page_list))
		{
			if(in_array('copyright-statement',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_manange_permission_page_list))
	   {
			if(in_array('manage-permission',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_manange_email_page_list))
        {
			if(in_array('email-templates',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }

		}
		elseif(in_array($current_url,$access_url_custom_form_list))
        {
			if(in_array('generic-form',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }

		}
		elseif(in_array($current_url,$access_delete_reason_page_list))
        {
			if(in_array('delete-reasons',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }

		}
		elseif(in_array($current_url,$access_manage_articles_page_list))
        {
			if(in_array('articles',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }

		}
		elseif(in_array($current_url,$access_manange_keyword_page_list))
        {
			if(in_array('category-keyword',$permitted_menulist['permission_menu'])||in_array('journal-keyword',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }

		}
        elseif(in_array($current_url,$access_manage_login_tracker_url))
        {
			if(in_array('login-tracker',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }
		}
		elseif(in_array($current_url,$access_manage_workflow_assignment_url))
        {
			if(in_array('workflow-assignment',$permitted_menulist['permission_menu']) || in_array('get-all-workflow-assignment-type',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
		    }
		}
		elseif (in_array($current_url,$access_manage_rescind_request_url)) {
			if (in_array('manage-rescind-request',$permitted_menulist['permission_menu'])) {
				$user_access=TRUE;
			}
		}
		elseif(in_array($current_url,$access_report))
		{
			// Task #6971 - Implementing Report on ReView 3
			if(in_array('manage-reports',$permitted_menulist['permission_menu']))
			{
			  $user_access=TRUE;
			}
		}

	 }
		return $user_access;
	  }

	  public function set_dashboard_default_role_active($user_roles,$platform_id,$user_id,$set_role_id=NULL)
	  {
		// using $set_role_id for users by entering invite links for authors and reviewers
		  if(!isset($user_roles['role_id_name_list']))
		  {
			  return array();
			  die;
		  }


		  //$priority_roles = $this->user->priority_roles;
		  $priority_roles=$this->RolesConfigdata('priority_roles')['priority_roles'];

		  usort($priority_roles, function($a, $b)
		  {
			  return $a['priority'] - $b['priority'];
		  });
		  $condition='';
		if (isset($set_role_id)) {
			$condition=array("usrj_usr_id"=>$user_id,
			                 "usrj_jnl_id"=>$platform_id,
							 "usrj_role_id"=>$set_role_id,
							 "usrj_artp_id"=>NULL);
			//$condition = "usrj_usr_id={$user_id} AND usrj_jnl_id={$platform_id} AND usrj_role_id={$set_role_id} AND usrj_artp_id IS NULL";
		} else {
			$condition=array("usrj_usr_id"=>$user_id,
			"usrj_jnl_id"=>$platform_id,
			"usrj_enable_default_role"=>'y',
			"usrj_artp_id"=>NULL);
			//$condition = "usrj_usr_id={$user_id} AND usrj_jnl_id={$platform_id} AND usrj_enable_default_role='y' AND usrj_artp_id IS NULL";
		}
		  $records =User_to_journals::get_single_record_with_bind_cond('usrj_role_id',$condition);

		  if(!empty($records))
		  {
			  $roleid= $records->usrj_role_id;
			  //$where ="role_id={$roleid}";
			  $where=array("role_id"=>$roleid);
			  $review_roles = Roles::get_single_record_with_bind_cond('role_id,role_name,role_assigned_role', $where);
			  $role_name = $review_roles->role_name;

			  $user_role = array(
				  'role_id' => $roleid,
				  'role_name' => $role_name,
				  'core_role' => $review_roles->role_assigned_role,
				  'set_default_role' => $roleid
			  );

			  return $user_role;

		  }

		  $sess_core_role = '';
		  $sess_core_role_id = '';
		  $sess_role = '';
		 // print_r($priority_roles);exit;
		  foreach ($priority_roles as $pr)
		  {
			  $core_role = $pr['core_role'];

			  if (in_array($core_role, array_column($user_roles['role_id_name_list'], 'assigned_role')))
			  {
				  if ($sess_role != '')
				  {
					  $key = array_search($sess_role, array_column($user_roles['role_id_name_list'], 'role_name'));
					  $roleid = array_keys($user_roles['role_id_name_list'])[$key];
				  }
				  else
				  {
					  $key = array_search($core_role, array_column($user_roles['role_id_name_list'], 'assigned_role'));
					  $roleid = array_keys($user_roles['role_id_name_list'])[$key];
				  }


				 // $where ="role_id={$roleid}";
				  $where=array("role_id"=>$roleid);
				  $review_roles = Roles::get_single_record_with_bind_cond('role_id,role_name', $where);
				  $role_name = $review_roles->role_name;

				  $user_role = array(
					  'role_id' => $roleid,
					  'role_name' => $role_name,
					  'core_role' => $core_role,
					  'set_default_role'=>''
				  );

					  return $user_role;


			  }
		  }
	  }

public function get_right_menu_permission($user_id)
{
	   $functionality=$this->get_current_client_functionality_data();

	   $menu_data=$this->get_right_menu_data($user_id,$user_id,$functionality->functionality);
	    return $menu_data;
}
public function get_current_client_functionality_data(){
	$clnt_id=1;
	$criteria =array("clnt_id"=>$clnt_id);
	$client_details = Clients::get_single_record_with_bind_cond('*', $criteria);
	$client_functionality=$this->get_client_functionalities($client_details->clnt_id,$client_details->clnt_client_code);
	   unset($client_functionality->cfty_posted_date, $client_functionality->cfty_posted_by, $client_functionality->cfty_operation);
	   $current_client = new StdClass;
	   $current_client->functionality=$client_functionality;
	 //  $module_crietria = 'mdl_clnt_id=' . $clnt_id;
	   $module_crietria=array("mdl_clnt_id"=>$clnt_id);
        $client_modules = Modules::get_single_record_with_bind_cond('*', $module_crietria);
		$current_client->modules=$client_modules;
 return $current_client;
}
public function get_right_menu_data($user_id,$logged_user_id,$functionality)
{

	$adm_setting_menu = array();
	$link_route_permissions = General_permission::get_all_records('permission_icon,permission_route, permission_caption, permission_roles',"permission_caption!='' AND permission_roles !=''" );
	$User=new \App\Models\User();
	$user_data=$User->get_single_record_with_bind_cond('usr_roles',array("usr_id"=>$user_id));
	$user_role=array();
	$return_data = array();
	if(isset($user_data->usr_roles)&&($user_data->usr_roles!=''))
	{
	  $user_role = json_decode($user_data->usr_roles);
	}

		  /* start --- process admin links based on permission */
		  if (in_array("sudo", $user_role))
		  {
			/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
			$adm_setting_menu=array('tmpControlpanel','articles','delete-reasons','manage-api','login-tracker','manage-classification','manage-legacy-article','manage-legacy-reviewer','manage-generic-dashboard');
			$current_client=$this->get_current_client_functionality_data();
			if($current_client->modules->mdl_es_integration == 'y')
			{
				$clnt_id=1;
				$criteria = 'clnt_id='.$clnt_id;
				$client_details = Clients::get_single_record('*', $criteria);
				$es_config = 'clients.' . $client_details->clnt_client_code . '.es_integration';
                $es_api_data  = Config::get($es_config);
				$return_data['es_url'] = $es_api_data['rvriteurl'];
				//array_push($adm_setting_menu,'sync-with-rvrite');
			}
		  }

		  if ((in_array("sudo", $user_role) || in_array("super_admin", $user_role)) && isset($functionality->cfty_manage_resent_email) && $functionality->cfty_manage_resent_email == 'y') {
			array_push($adm_setting_menu,"sent-emails");
		  }
		  if (isset($link_route_permissions)&&!empty($link_route_permissions)) {

			  foreach ($link_route_permissions as $key=>$val) {
				  $permission_roles = json_decode($val->permission_roles);
				  $permission_icon = ($val->permission_icon != '') ? $val->permission_icon : ' fa-circle';
				  if ((count(array_intersect($permission_roles,$user_role)) > 0 ) || in_array("sudo", $user_role) ) {
				   if($val->permission_route == "casrai-credits")
				   {
					 if($functionality->cfty_carsrai_credit_mandatory =='n')
					 {
					  	unset($link_route_permissions[$key]);
					 }
					 else
					 {
						array_push($adm_setting_menu,$val->permission_route);
					 }
				   }
				   /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
				   if($val->permission_route == "workflow-assignment")
				   {
					 if($functionality->cfty_enable_pre_review_stage_shortlist_reveiwers =='n')
					 {
					  	unset($link_route_permissions[$key]);
					 }
					 else
					 {
						array_push($adm_setting_menu,$val->permission_route);
					 }
				   }
				   else{
				   /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
				   if($val->permission_route=='manage-keywords')
				   {
					if($functionality->cfty_keyword_hierarchy=="c")
						{
					  $val->permission_route='category-keyword';
					}
					else
					{
					  $val->permission_route='journal-keyword';
					}
				   }
					array_push($adm_setting_menu,$val->permission_route);
					if ($val->permission_route=='manage-rescind-request' && $functionality->cfty_enable_rescind_request == 'n') {
						unset($adm_setting_menu[(array_keys($adm_setting_menu, "manage-rescind-request")[0])]);
					}
				}
				  }
			  }
				if(($functionality->cfty_carsrai_credit_mandatory =='n') && (in_array("sudo", $user_role) || in_array("super_admin", $user_role)))
				unset($adm_setting_menu[(array_keys($adm_setting_menu, "casrai-credits")[0])]);
				if(isset($this->current_client->modules->mdl_generic_discussion) && $this->current_client->modules->mdl_generic_discussion=='n' && (in_array("sudo", $user_role) || in_array("super_admin", $user_role)))
				{
					unset($adm_setting_menu[(array_keys($adm_setting_menu, "discussion-type")[0])]);
				}
		  }
		  if (in_array("sudo", $user_role) || in_array("super_admin", $user_role)) {
			$current_client=$this->get_current_client_functionality_data();
			if($current_client->modules->mdl_convey_integration == 'y'){
				array_push($adm_setting_menu,"disclosure-list");
			}
		  }
		 if(isset(array_keys($adm_setting_menu, "view-report")[0]))
		  unset($adm_setting_menu[(array_keys($adm_setting_menu, "view-report")[0])]);

		/*  Task #6971 - Implementing Report on ReView 3
			should show when the functionality is enabled
		*/
		if(isset(array_keys($adm_setting_menu, "manage-reports")[0]) && $functionality->cfty_reports == "n")
		  	unset($adm_setting_menu[(array_keys($adm_setting_menu, "manage-reports")[0])]);

		  $return_data['permission_menu']=array();
		  if (count($adm_setting_menu) > 0 &&$logged_user_id==$user_id) {
			$return_data['permission_menu']=$adm_setting_menu;
		  }


      return $return_data;

}

function get_client_functionalities($client_id, $client_code)
{
	
	// Initializing variables
	$conf_client_functionalities = array();
	$db_client_functionalities = array();
	$final_client_functionalities = array();

	// Loading config file
	#$client_default_config = 'clients.' . $client_code . '.client_configurations';
	$client_default_config  =   'client_configurations';
	// $path = FCPATH.'application/config/'.$client_default_config.'.php';

	// If config file exists
	// if(file_exists($path))
	// {
	// Getting config data
	$conf_client_functionalities = Config::get($client_default_config . '.client_functionality');

	// }

	// Getting client functionalities from database
	$criteria = 'cfty_clnt_id=' . $client_id;
	$client_functionalities_db = Client_functionalities::get_all_records(
		'cfty_functionality, cfty_status',
		$criteria
	);

	// Traversing through the rows to create an array of client functionalites
	if (!empty($client_functionalities_db)) {
		foreach ($client_functionalities_db as $row) {
			$db_client_functionalities[$row->cfty_functionality] = $row->cfty_status;
		}
	}
	
	// Getting the functionalities which are not in db
	$func_only_in_conf = array_diff_key($conf_client_functionalities, $db_client_functionalities);

	// Resetting all the values in $func_only_in_conf array to 'n' except 'cfty_keyword_hierarchy'
	array_walk($func_only_in_conf, function (&$value, $key) {
		$value = $key == 'cfty_keyword_hierarchy' ? 'c' : 'n';
	});

	// Merging arrays $common_functionalities and $func_only_in_conf
	$final_client_functionalities = array_merge($db_client_functionalities, $func_only_in_conf);

	// Return the array:$final_client_functionalities as object
	return (object) $final_client_functionalities;
}
    public function validate_user_journal($jnl_code = NULL, $user_id = NULL, $article_type_id = NULL, $user_artp_roles = NULL)
	{
		$return_arr['status'] = FALSE;
		$return_arr['role_id'] = array();
		$return_arr['roles'] = array();
		$return_arr['assigned_roles'] = array();

		if ($jnl_code != "" || $article_type_id != "")
		{

			if ($user_id === NULL)
			{
				$user_id = $this->current_user['user_id'];
			}

			if ($user_artp_roles != NULL)
			{ //already have user artp roles //Bug #1834: JPR-257 Performance Issues
				$select_role = "group_concat(role_id SEPARATOR ';') role_ids, group_concat(role_name SEPARATOR ';') role_names, group_concat(role_assigned_role SEPARATOR ';') role_assigned_roles";
				$where_condition = ' role_id IN(' . $user_artp_roles . ')';
				$roles = Roles::get_all_records($select_role, $where_condition);
			}
			else
			{
				$core_roles = array_keys($this->UserConfigdata('roles')['roles']);
				$roles = User_to_journals::get_journal_user_roles($user_id, trim($jnl_code), $article_type_id,$core_roles);
			}

			if (isset($roles[0])&&$roles[0]->role_ids != "" && $roles[0]->role_names != "" && $roles[0]->role_assigned_roles != "")
			{
				$return_arr['status'] = TRUE;
				$return_arr['role_id'] = explode(";", $roles[0]->role_ids);
				$return_arr['roles'] = explode(";", $roles[0]->role_names);
				$return_arr['assigned_roles'] = explode(";", $roles[0]->role_assigned_roles);

				foreach ($return_arr['role_id'] as $key => $value)
				{
					$return_arr['role_id_name_list'][$value] = array(
						'role_name' => $return_arr['roles'][$key],
						'assigned_role' => $return_arr['assigned_roles'][$key]);
				}

			}
		}
		return $return_arr;
	}

	public function rebuild_array_by_field($array,$field)
	{
		$new_array = array();
		foreach($array as $val)
		{
			$new_array[$val->$field] = $val;
		}
		return $new_array;
	}

	//it will send database query date format
	public function date_format_map($dt_fmt)
	{
		$db_date_format = array(
			'd-m-y' => '%d-%m-%y',
			'm-d-y' => '%m-%d-%y',
			'y-m-d' => '%y-%m-%d',
			'd-m-Y' => '%d-%m-%Y',
			'm-d-Y' => '%m-%d-%Y',
			'Y-m-d' => '%Y-%m-%d');
		$format = '';
		if(isset($db_date_format[$dt_fmt]))
		{
			$format = $db_date_format[$dt_fmt];
		}
		return $format;
	}

	//Bug #2036 JPR-214 Retiring an AE/Editor on review2
	public function get_user_role_retire($role_id,$user_id,$jnl_id)
	{
		if($role_id != NULL && ((isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'n') || !isset($this->current_client->functionality->cfty_retire_role) ))
		{
			return FALSE;
		}

		$condition = array(
			'usrj_jnl_id' => $jnl_id,
			'usrj_usr_id'=>$user_id,
			'usrj_role_retired'=> 'y'
		);
		$select = 'group_concat(distinct usrj_role_id) as result';
		if($role_id != NULL)
		{
			$select = 'count(distinct usrj_jnl_id) as result';
			$condition['usrj_role_id'] = $role_id;
		}

		$result = User_to_journals::get_single_record_with_bind_cond($select,$condition);

		if($role_id != NULL)
		{
			if($result->result > 0)
				$return = TRUE;
			else
				$return = FALSE;
		}
		else
		{
			$return = $result->result;
		}

		return $return;
	}
}
